/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1988, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef	_Transport_h
#define	_Transport_h
#ident	"@(#)debugger:inc/common/Transport.h	1.4"

#include	"List.h"
#include	<unistd.h>

typedef void *	DBcontext;
typedef void *	UIcontext;

class Message;

enum Transport_type
{
	TT_invalid = 0,
	TT_UI_user_cmd,		// cmd generated by user action
	TT_UI_notify,		// msg generated by gui internal logic
	TT_UI_query,		// question to the debugger
	TT_UI_response,		// response to debugger's query
	TT_DE_notify,		// normal msg from debug
	TT_DE_response,		// response to gui's query
	TT_DE_query		// question to the user - need immediate answer	
};

enum tside { ts_debug, ts_gui };

class Transport
{
	tside	which_side;	// for consistency checking
	int	input;		// input file descriptor
	int	output;		// output file descriptor
	List	inq;		// message queue
	List	freeq;
	int	last_sent;	// sequence numbers
	int	last_received;
	int	in_query;	// currently responding to a query

	int	(*readfunc)(int, void *, unsigned int);
	int	(*writefunc)(int, const void *, unsigned int);
	void	(*exitfunc)(int);
	void	(*qhandler)(Message *);

	void	read_message(Message *);

public:
		Transport(int in, int out,
			int (*readf)(int, void *, unsigned int),
			int (*writef)(int, const void *, unsigned int),
			void (*exitf)(int),
			void (*handler)(Message *) = 0);
		~Transport()	{}

	void	send_message(Message *, Transport_type, DBcontext, UIcontext);
	int	get_next_message(Message *, 
			int (*readf)(int, void *, unsigned int) = ::read);
	void	get_response(Message *,
			int (*readf)(int, void *, unsigned int) = ::read);
	void	get_nonuser_message(Message *,
			int (*readf)(int, void *, unsigned int) = ::read);
	void	query_done()	{ in_query = 0; }
	int	inqempty()	{ return inq.isempty();  }
};

#endif	// _Transport_h
