/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1988, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef CCTYPE_H
#define CCTYPE_H
#ident	"@(#)debugger:libexp/common/CCtype.h	1.9"

#include "TYPE.h"
#include "Language.h"
#include "stddef.h"

class IntList;
class Resolver;
class VTBL_descriptor;

class C_base_type : public TYPE
{
protected:
	int		is_vtbl_member(ProcObj *, Symbol &, VTBL_descriptor &);

public:
			C_base_type() : TYPE() {}
				// init as a fundamental type.
			C_base_type(Fund_type ft) : TYPE(ft) {}
				// init as a user defined type.
			C_base_type(const Symbol &sym) : TYPE(sym) {}

	// assignment operators not inherited
	C_base_type	&operator=(Fund_type ft) { return (C_base_type&)TYPE::operator=(ft); }
	C_base_type	&operator=(Symbol &sym) { return (C_base_type&)TYPE::operator=(sym); }
			// query functions
	int		isPointer();
	int		isPtrType()	{ return (isPointer() || isArray()); }
	int		isArray()	{ return (_form == TF_user
						&& symbol.tag()==t_arraytype); }
	int		isIntegral();
	int		isFloatType();
	int		isArithmetic()	{ return (isIntegral() || isFloatType()); }

	int		isScalar()	{ return (isArithmetic() || isPtrType()); }

			// c++-specific queries
	virtual int	isDerivedFrom(C_base_type *t);
	virtual int	has_vtbl(ProcObj *, VTBL_descriptor &);

			// functions used to build types needed for
			// expression evaluation
	C_base_type	*build_ptrToBase(Resolver *context);
	C_base_type	*build_ptrTYPE(Resolver *context);
	C_base_type	*build_arrayTYPE(Resolver *context, IntList *subscr);
	C_base_type	*build_subrtnTYPE(Resolver *context);

			// overriding virtual functions
	TYPE		*clone();
	TYPE		*clone_type();
	int		size();			  // size in bytes
	int		print(Buffer *, ProcObj *);
};

// ANSI C
class C_type : public C_base_type
{
public:
			C_type() : C_base_type() {}
			C_type(Fund_type ft) : C_base_type(ft) {}
			C_type(const Symbol &sym) : C_base_type(sym) {}
	
			// overriding virtual functions
	TYPE		*clone();
	TYPE		*clone_type();
	int		print(Buffer *, ProcObj *);
};

// C++ - CPP_cgen_type makes assumptions about the C code generated by
// the C-generating ANSI C++ compiler
class CPP_cgen_type : public C_base_type
{
	int		find_vtbl_in_base_class(ProcObj *, Symbol &,
					VTBL_descriptor &);
public:
			CPP_cgen_type() : C_base_type() {}
			CPP_cgen_type(Fund_type ft) : C_base_type(ft) {}
			CPP_cgen_type(const Symbol &sym) : C_base_type(sym) {}

			// overriding virtual functions
	TYPE		*clone();
	TYPE		*clone_type();
	int		isDerivedFrom(C_base_type *t);
	int		print(Buffer *, ProcObj *);
	int		has_vtbl(ProcObj *, VTBL_descriptor &);
};

// C++ - CPP_cfront_type makes assumptions about the C code generated by cfront
class CPP_cfront_type : public C_base_type {
public:
			CPP_cfront_type() : C_base_type() {}
			CPP_cfront_type(Fund_type ft) : C_base_type(ft) {}
			CPP_cfront_type(const Symbol &sym) : C_base_type(sym) {}


			// overriding virtual functions
	TYPE		*clone();
	TYPE		*clone_type();
	int		isDerivedFrom(C_base_type *t);
	int		print(Buffer *, ProcObj *);
	int		has_vtbl(ProcObj *, VTBL_descriptor &);
};

C_base_type	*new_CTYPE(Language lang);
C_base_type	*new_CTYPE(Language lang, Fund_type ft);
C_base_type	*new_CTYPE(Language lang, const Symbol &sym);

int is_base_class(Symbol &member, Symbol &class_sym, char *&class_name);

class VTBL_descriptor
{
	unsigned long	offset;	// offset of vtbl pointer from beginning of class
	C_base_type	*type;	// type structure for vtbl pointer
	size_t		size;	// size of an entry in the vtbl
	Iaddr		address;	// address of vtbl
public:
			VTBL_descriptor() { offset = 0;
					    type = 0;
					    size = 0;
					    address = 0;
					  }
			~VTBL_descriptor() { delete type; }

	void		null() { offset = 0;
				 delete type;
				 type = 0;
				 size = 0;
				 address = 0;
				 }

	friend class	C_base_type;
	friend class	CPP_cgen_type;

			// access functions
	unsigned long	member_offset() { return offset; }
	C_base_type	*member_type()	{ return type; }
	size_t		entry_size()	{ return size; }
	Iaddr		get_address()	{ return address; }
	void		set_address(Iaddr addr) { address = addr; }
};

#endif	// CCTYPE_H
