/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1988, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef	_DIALOG_SHP
#define	_DIALOG_SHP
#ident	"@(#)debugger:libol/common/Dialog_shP.h	1.10"

// toolkit specific members of the Dialog_shell class
// included by ../../gui.d/common/Dialog_sh.h

class Button_data;
class DNDdata;

// toolkit specific members:
// popup_window		primary widget - widget in the base class is form or
//				rubber tile containing children
// control_area		widget containing buttons
// msg_widget		static text widget for error messages
// _is_open		true if the dialog is currently popped up
// ok_to_popdown	true if button pushed makes the dialog go away when done
// cmds_sent		dialog can't be popped down until debug cmds are completed
// errors		number of errors generated by last action
// error_string		space for error messages
// buttons		array of button-specific data
// nbuttons		number of buttons in the control area
// drop_data		UI specific data for drop
//
// make_buttons		creates the Button_data array and buttons widget

#define DIALOG_SHELL_TOOLKIT_SPECIFICS \
private:					\
	Widget		popup_window;		\
	Widget		popup_focus_widget;	\
	Widget		control_area;		\
	Widget		msg_widget;		\
	char		*error_string;		\
	Button_data	*buttons;		\
	DNDdata		*drop_data;		\
	short		nbuttons;		\
	Boolean		_is_open;		\
	Boolean		ok_to_popdown;		\
	Boolean		cmds_sent;		\
	Boolean		default_is_exec;	\
	Boolean		is_busy;		\
	Boolean		*busy_buttons;		\
						\
public:						\
	void		make_buttons(const Button *, int num_buttons);		\
	Widget		get_popup_window()	{ return popup_window; }	\
	Boolean		get_cmds_sent()		{ return cmds_sent; }		\
	void		set_ok_to_popdown(Boolean b) { ok_to_popdown = b; }	\
	void		set_is_open(Boolean b)	{ _is_open = b; }

#endif	// _DIALOG_SHP
