#ident	"@(#)debugger:libutil/common/print_path.C	1.2"
#include	"utility.h"
#include	"ProcObj.h"
#include	"Proglist.h"
#include	"Interface.h"
#include	"SrcFile.h"
#include 	"Parser.h"
#include 	"global.h"

int
print_path( Proclist * procl, const char *fname )
{
	int single = 1;
	ProcObj	*pobj;
	plist	*list;
	int	ret = 1;

	if (procl)
	{
		single = 0;
		list = proglist.proc_list(procl);
		pobj = list++->p_pobj;
	}
	else
	{
		pobj = proglist.current_object();
	}
	if (!pobj)
	{
		printe(ERR_no_proc, E_ERROR);
		return 0;
	}
	do
	{
		SrcFile	*srcfile;
		if ((srcfile = find_srcfile(pobj, fname)) == 0)
		{
			printe(ERR_no_source, E_ERROR, fname);
			ret = 0;
			continue;
		}
		printm(MSG_source_file, srcfile->filename());
	}
	while(!single && ((pobj = list++->p_pobj) != 0));
	return ret;
}
