/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)nfs.cmds:bootpd/bp_lib.c	1.4"
#ident	"$Header: $"

/*
 *	Copyright (c) 1982, 1986, 1988
 *	The Regents of the University of California
 *	All Rights Reserved.
 *	Portions of this document are derived from
 *	software developed by the University of
 *	California, Berkeley, and its contributors.
 */

/*
 * +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *	PROPRIETARY NOTICE (Combined)
 *
 * This source code is unpublished proprietary information
 * constituting, or derived under license from AT&T's UNIX(r) System V.
 * In addition, portions of such source code were derived from Berkeley
 * 4.3 BSD under license from the Regents of the University of
 * California.
 *
 *
 *
 *     Copyright Notice 
 * 
 * Notice of copyright on this source code product does not indicate 
 * publication.
 *
 *  (c) 1986,1987,1988.1989  Sun Microsystems, Inc
 *  (c) 1983,1984,1985,1986,1987,1988,1989  AT&T.
 *            All rights reserved.
 *
 */
/*
 * Library routines of the bootparam server.
 */

#include <stdio.h>
#include <string.h>
#include <rpcsvc/ypclnt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <errno.h>
#include <pfmt.h>

#define iseol(c)	(c == '\0' || c == '\n' || c == '#')
#define issep(c)	(c == ' ' || c == '\t')

#define BOOTPARAMS	"/etc/bootparams"
#define	LINESIZE	512
#define NAMESIZE	256
#define DOMAINSIZE	256

static char domain[DOMAINSIZE];			/* yp domain name */

struct stat laststat;
static char *bpbuf;

char *
read_bootparams()
{
	int fd;
	struct stat statb;

	if (stat(BOOTPARAMS, &statb) < 0) {
		pfmt(stderr, MM_ERROR, ":23:%s: cannot %s %s: %s\n",
		     "read_bootparams", "stat", BOOTPARAMS, strerror(errno));
		return (NULL);
	}

	if (statb.st_mtime != laststat.st_mtime) {
		if ((fd = open(BOOTPARAMS, O_RDWR, 0)) < 0) {
			pfmt(stderr, MM_ERROR, ":20:%s: cannot open %s: %s\n",
			     "read_bootparams", BOOTPARAMS, strerror(errno));
			return (NULL);
		}
		if (bpbuf) {
			free(bpbuf);
		}
		bpbuf = (char *)malloc(statb.st_size + 1);
		if (bpbuf == NULL) {
			pfmt(stderr, MM_ERROR, ":28:%s: no memory\n",
			     "read_bootparams");
			return (NULL);
		}
		if (read(fd, bpbuf, statb.st_size) < 0) {
			pfmt(stderr, MM_ERROR, ":85:%s: cannot read %s: %s\n",
			     "read_bootparams", BOOTPARAMS, strerror(errno));
			return (NULL);
		}
		bpbuf[statb.st_size] = '\0';
		laststat = statb;
	}
	return (bpbuf);
}

/*
 * getline()
 * Read a line from a buffer.
 * Fill in line buffer, and update lpp, return number of chars.
 */
getline(line, maxlinelen, lpp)
	char *line;
	int maxlinelen;
	char **lpp;
{
	int count;
	char *p;
	char *linestart;

	p = *lpp;
	if (p == NULL || *p == '\0') {
		return (0);
	}
	count = 0;
	linestart = line;

	while (iseol(*p)) {
		p++;
	}

	while (*p) {
		if (*p == '\n') {
			if (count && p[-1] == '\\') {
				/*
				 * Continuation line, back up one char
				 * and get next line from buf.
				 */
				line--;
				p++;
			} else {
				break;
			}
		}
		count++;
		*line++ = *p++;
	}
	*line = '\0';
	*lpp = p;

	return (count);
}

/*
 * getname()
 * Get the next entry from the line.
 * You tell getname() which characters to ignore before storing them 
 * into name, and which characters separate entries in a line.
 * The cookie is updated appropriately.
 * return:
 *	   1: one entry parsed
 *	   0: partial entry parsed, ran out of space in name
 *    -1: no more entries in line
 */
int
getname(name, namelen, linep)
	char *name;
	int namelen;
	char **linep;
{
	char c;
	char *lp;
	char *np;
	int maxnamelen;

	lp = *linep;
	do {
		c = *lp++;
	} while (issep(c) && !iseol(c));

	if (iseol(c)) {
		*linep = lp - 1;
		return(0);
	}

	np = name;
	while (! issep(c) && ! iseol(c) && np - name < namelen - 1) {	
		*np++ = c;	
		c = *lp++;
	} 
	*np = '\0';
	lp--;
	*linep = lp;
	return (np - name);
}

/*
 * getclntent reads the line buffer and returns a string of client entry
 * in yellow pages or the "/etc/bootparams" file. Called by getclntent.
 */
static int
getvalue(lpp, clnt_entry)
	register char **lpp;			/* function input */
	register char *clnt_entry;		/* function output */
{
	char name[NAMESIZE];
	int append = 0;

	while (getname(name, sizeof(name), lpp) > 0) {
		if (!append) {
			strcpy(clnt_entry, name);
			append++;
		} else {
			strcat(clnt_entry, " ");
			strcat(clnt_entry, name);
		}
	}
	return (0);
}	

/*
 * getfileent returns the client entry in the "/etc/bootparams"
 * file given the client name.
 */
int
bp_getclntent(clnt_name, clnt_entry)
	register char *clnt_name;		/* function input */
	register char *clnt_entry;		/* function output */
{
	FILE *fp; 
	char line[LINESIZE];
	char name[NAMESIZE];
	char *lp;
	char *linep;
	char *val;
	int vallen;
	int reason;
 
	reason = -1;
	lp = read_bootparams();
	while (reason && getline(line, sizeof(line), &lp)) {
		linep = line;
		val = NULL;

#ifdef	YP
		if (*linep == '+' && useyp()) {
			linep++;
			if (getname(name, sizeof(name), &linep)) {
				reason = yp_match(domain, name, clnt_name,
				    strlen(clnt_name), &val, &vallen);
			} else {
				reason = yp_match(domain, "bootparams",
				    clnt_name, strlen(clnt_name), &val,&vallen);
			}
			if (!reason) {
				linep = val;
			}
		}
#endif

		if (!reason || (getname(name, sizeof(name), &linep) > 0
		    && strcmp(name,clnt_name) == 0)) {
			reason = getvalue(&linep, clnt_entry);
		}

		if (val) {
			free(val);
		}
	}
	return (reason);
}

/*
 * return the value string associated with clnt_key (key=value) in
 * the line buffer lpp. Update lpp.
 */
static int
getkeyval(lpp, clnt_key, clnt_entry)
	register char **lpp;			/* function input */
	register char *clnt_key;		/* function input */
	register char *clnt_entry;		/* function output */
{
	char name[NAMESIZE];
	char *cp;

	while (getname(name, sizeof(name), lpp) > 0) {
		if ((cp = strchr(name, '=')) == 0)
			return (-1);
		*cp++ = '\0';
		if (strcmp(name, clnt_key) == 0) {
			strcpy(clnt_entry, cp);
			return (0);
		}
	}
	if (strcmp(clnt_key, "dump") == 0) {
		/*
		 * This is a gross hack to handle the case where 
		 * no dump file exists in bootparams. The null
		 * server and path names indicate this fact to the
		 * client.
		 */
		strcpy(clnt_entry, ":");
		return (0);
	}
	return (-1);
}

/*
 * getclntkey returns the client's server name and its pathname from either
 * the yellow pages or the "/etc/bootparams" file given the client name and
 * the key.
 */
int
bp_getclntkey(clnt_name, clnt_key, clnt_entry)
	register char *clnt_name;		/* function input */
	register char *clnt_key;		/* function input */
	register char *clnt_entry;		/* function output */
{
	char line[LINESIZE];
	char name[NAMESIZE];
	char *lp;
	char *linep;
	char *val;
	int reason;
	int vallen;
 
	reason = -1;
	lp = read_bootparams();
	while (reason && getline(line, sizeof(line), &lp)) {
		linep = line;
		val = NULL;

#ifdef	YP
		if (*linep == '+' && useyp()) {
			linep++;
			if (getname(name, sizeof(name), &linep)) {
				reason = yp_match(domain, name, clnt_name,
				    strlen(clnt_name), &val, &vallen);
			} else {
				reason = yp_match(domain, "bootparams",
				    clnt_name, strlen(clnt_name), &val,&vallen);
			}
			if (!reason) {
				linep = val;
			}
		}
#endif

		if (!reason || ( getname(name, sizeof(name), &linep) > 0
		    && strcmp(name,clnt_name) == 0) ) {
			reason = getkeyval(&linep, clnt_key, clnt_entry);
		}

		if (val) {
			free(val);
		}
	}
	return (reason);
}

#ifdef	YP
/*
 * Determine whether or not to use the yellow pages service to do lookups.
 */
static int
useyp()
{
	static int initted;
	static int usingyp;

	if (!initted) {
		getdomainname(domain, sizeof(domain));
		usingyp = !yp_bind(domain);
		initted = 1;
	}
	return (usingyp);
}
#endif

/*
 * Determine if a descriptor belongs to a socket or not
 */
issock(fd)
	int fd;
{
	struct stat st;

	if (fstat(fd, &st) < 0) {
		return (0);
	} 
	/*	
	 * SunOS returns S_IFIFO for sockets, while 4.3 returns 0 and
	 * does not even have an S_IFIFO mode.  Since there is confusion 
	 * about what the mode is, we check for what it is not instead of 
	 * what it is.
	 *
	 * NOTE: SYSV returns a 0 too. it returns S_IFIFO for pipes.
	 * so check that too.
	 */
	switch (st.st_mode & S_IFMT) {
	case S_IFIFO:
	case S_IFCHR:
	case S_IFREG:
	case S_IFLNK:
	case S_IFDIR:
	case S_IFBLK:
		return (0);
	default:	
		return (1);
	}
}
