#	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.
#	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.


#ident	"@(#)ksh:shlib/shlib.mk	1.4"

include $(CMDRULES)

# makefile for shlib generated by mkold and hand modified

KSHINC	 = ../include

LOCALINC = -I$(KSHINC)
LOCALDEF = -DKSHELL -DMULTIBYTE -DGETPWNAM

SOURCES = adjust.c assign.c assnum.c cannon.c chkid.c convert.c findnod.c \
	gettree.c growaray.c gsort.c linknod.c namscan.c optget.c rjust.c \
	strdata.c streval.c strmatch.c tilde.c unassign.c utos.c valup.c

OBJECTS = $(SOURCES:.c=.o)


all: libsh.a

libsh.a: $(OBJECTS)
	$(AR) $(ARFLAGS) libsh.a $(OBJECTS)

adjust.o: adjust.c \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/name.h \
	$(KSHINC)/flags.h 

assign.o: assign.c \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/name.h \
	$(KSHINC)/flags.h \
	$(KSHINC)/national.h \
	$(KSHINC)/outmsg.h

assnum.o: assnum.c \
	$(KSHINC)/name.h \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/flags.h 

cannon.o: cannon.c \
	$(KSHINC)/io.h \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(INC)/sys/stat.h \
	$(INC)/unistd.h \
	$(INC)/fcntl.h $(INC)/sys/fcntl.h \
	$(INC)/sys/file.h

chkid.o: chkid.c \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h

convert.o: convert.c \
	$(KSHINC)/shtype.h \
	$(KSHINC)/sh_config.h \
	$(INC)/ctype.h

findnod.o: findnod.c \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/name.h \
	$(KSHINC)/flags.h \
	$(KSHINC)/shtype.h \
	$(INC)/ctype.h

gettree.o: gettree.c \
	$(KSHINC)/name.h \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/flags.h 

growaray.o: growaray.c \
	$(KSHINC)/name.h \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/flags.h \
	$(KSHINC)/outmsg.h

gsort.o: gsort.c

linknod.o: linknod.c \
	$(KSHINC)/name.h \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/flags.h

namscan.o: namscan.c \
	$(KSHINC)/name.h \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/flags.h

optget.o: optget.c \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h

rjust.o: rjust.c \
	$(KSHINC)/shtype.h \
	$(KSHINC)/sh_config.h \
	$(INC)/ctype.h

strdata.o: strdata.c \
	$(KSHINC)/streval.h \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h

streval.o: streval.c \
	$(KSHINC)/shtype.h \
	$(INC)/ctype.h \
	$(KSHINC)/streval.h \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/outmsg.h

strmatch.o: strmatch.c \
	$(INC)/ctype.h \
	$(KSHINC)/national.h

tilde.o: tilde.c \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/defs.h \
	$(KSHINC)/outmsg.h \
	$(INC)/setjmp.h \
	$(INC)/signal.h $(INC)/sys/signal.h \
	$(INC)/unistd.h \
	$(INC)/sys/times.h \
	$(KSHINC)/name.h \
	$(KSHINC)/shnodes.h \
	$(KSHINC)/stak.h \
	$(KSHINC)/shtype.h \
	$(INC)/mnttab.h \
	$(INC)/sys/utsname.h \
	$(INC)/pwd.h

unassign.o: unassign.c \
	$(KSHINC)/name.h \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/flags.h

utos.o: utos.c \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h

valup.o: valup.c \
	$(KSHINC)/name.h \
	$(KSHINC)/sh_config.h \
	$(INC)/sys/types.h \
	$(KSHINC)/flags.h 

clean :
	rm -f $(OBJECTS)

clobber : clean
	rm -f libsh.a

lintit:
	$(LINT) $(LINTFLAGS) $(SOURCES)
