/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1990, 1991, 1992, 1993 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 *	Copyright (c) 1982, 1986, 1988
 *	The Regents of the University of California
 *	All Rights Reserved.
 *	Portions of this document are derived from
 *	software developed by the University of
 *	California, Berkeley, and its contributors.
 */

#ident	"@(#)mailx:is.c	1.4.8.5"
#ident "@(#)is.c	1.13 'attmail mail(1) command'"
#include "rcv.h"
#include <pwd.h>

static int isit ARGS((char *lp, int type));

/*
 * isheader(lp, ctf) - check if lp is header line and return type
 *	lp	-> 	pointer to line
 *	ctfp	->	continuation flag (should be FALSE the first time
 *			isheader() is called on a message.  isheader() sets
 *			it for the remaining calls to that message)
 * returns
 *	FALSE	->	not header line
 *	H_*     ->	type of header line found.
 */
int
isheader(lp, ctfp)
char	*lp;
int	*ctfp;
{
	register char	*p, *q;
	register int	i;

	p = lp;
	while((*p) && (*p != '\n') && (Isspace(*p))) {
		p++;
	}
	if((*p == NULL) || (*p == '\n')) {
		/* blank line */
		return (FALSE);
	}

	if ((*ctfp) && ((*lp == ' ') || (*lp == '\t'))) {
		return(H_CONT);
	}

	*ctfp = FALSE;
	for (i = 1; i < H_CONT; i++) {
		if (!isit(lp, i)) {
			continue;
		}
		if ((i == H_FROM) || (i == H_FROM1)) {
			/* From and >From must be case sensitive matches. */
			if (strncmp(lp, header[i].tag, header[i].length) != 0)
				return (FALSE);
			/*
			 * Should NEVER get 'From ' or '>From ' line on stdin
			 * if invoked as mail (rather than rmail) since
			 * 'From ' and/or '>From ' lines are generated by
			 * program itself. Therefore, if it DOES match and
			 * ismail == TRUE, it must be part of the content.
			 */
			if (sending && ismail) {
				return (FALSE);
			}
		}
		*ctfp = TRUE;
		return (i);
	}

	/*
	 * Check if it's a name: value pair.
	 * RFC 822 says a header is a series of non-control and
	 * non-space characters followed by a :.
	 */
	for (p = lp; *p; p++) {
		if (Iscntrl(*p) || Isspace(*p))
			return(FALSE);

		if (*p == ':') {
			/* If req_white, the : must be followed by white-space */
			/* or the end of the line in order for it to be a header. */
			p++;
			if (*p && (*p != ' ') && (*p != '\t') && (*p != '\n') && (*p != '\r'))
				return(FALSE);
			*ctfp = TRUE;
			return(H_NAMEVALUE);
		}
	}

	/* Hit the end of the line, so it can't be a header. */
	return(FALSE);
}

/*
 * isit(lp, type) -- case independent match of "name" portion of
 *		"name: value" pair
 *	lp	->	pointer to line to check
 *	typehdr	->	type of header line to match
 * returns
 *	TRUE	-> 	lp matches header type (case independent)
 *	FALSE	->	no match
 */
static int
isit(lp, typehdr)
register char 	*lp;
register int	typehdr;
{
	register char	*p;

	for (p = header[typehdr].tag; *lp && *p; lp++, p++) {
		if (toupper(*p) != toupper(*lp))  {
			return(FALSE);
		}
	}
	if (*p == NULL) {
		return(TRUE);
	}
	return(FALSE);
}

/*
    NAME
	istext - check a line for text, non-text characters

    SYNOPSIS
	t_Content istext(unsigned char *line, int size, t_Content cur_content)

    DESCRIPTION
	istext() looks at the "size" characters within "line"
	for non-text characters. The definition of text
	characters when sending is based on the MTA spec and is
	specifically the 7-bit ASCII printable characters. Generic
	text characters are those which are printable according
	to the current locale.
	Printable text is defined by isprint(), white space (as defined by
	isspace()) and backspaces.

    RETURNS
	M_text - all characters are 7-bit ASCII
	M_gtext - all characters are text according to the current locale
	M_binary - at least one non-text character was found
*/

static const char is7bitprintable[] =
    {
    /* nul */ 0, /* soh */ 0, /* stx */ 0, /* etx */ 0, /* eot */ 0, /* enq */ 0, /* ack */ 0, /* bel */ 0,
    /* bs  */ 1, /* ht  */ 1, /* nl  */ 1, /* vt  */ 1, /* np  */ 1, /* cr  */ 1, /* so  */ 0, /* si  */ 0,
    /* dle */ 0, /* dc1 */ 0, /* dc2 */ 0, /* dc3 */ 0, /* dc4 */ 0, /* nak */ 0, /* syn */ 0, /* etb */ 0,
    /* can */ 0, /* em  */ 0, /* sub */ 0, /* esc */ 0, /* fs  */ 0, /* gs  */ 0, /* rs  */ 0, /* us  */ 0,
    /* sp  */ 1, /* !   */ 1, /* "   */ 1, /* #   */ 1, /* $   */ 1, /* %   */ 1, /* &   */ 1, /* '   */ 1,
    /* (   */ 1, /* )   */ 1, /* *   */ 1, /* +   */ 1, /* ,   */ 1, /* -   */ 1, /* .   */ 1, /* /   */ 1,
    /* 0   */ 1, /* 1   */ 1, /* 2   */ 1, /* 3   */ 1, /* 4   */ 1, /* 5   */ 1, /* 6   */ 1, /* 7   */ 1,
    /* 8   */ 1, /* 9   */ 1, /* :   */ 1, /* ;   */ 1, /* <   */ 1, /* =   */ 1, /* >   */ 1, /* ?   */ 1,
    /* @   */ 1, /* A   */ 1, /* B   */ 1, /* C   */ 1, /* D   */ 1, /* E   */ 1, /* F   */ 1, /* G   */ 1,
    /* H   */ 1, /* I   */ 1, /* J   */ 1, /* K   */ 1, /* L   */ 1, /* M   */ 1, /* N   */ 1, /* O   */ 1,
    /* P   */ 1, /* Q   */ 1, /* R   */ 1, /* S   */ 1, /* T   */ 1, /* U   */ 1, /* V   */ 1, /* W   */ 1,
    /* X   */ 1, /* Y   */ 1, /* Z   */ 1, /* [   */ 1, /* \   */ 1, /* ]   */ 1, /* ^   */ 1, /* _   */ 1,
    /* `   */ 1, /* a   */ 1, /* b   */ 1, /* c   */ 1, /* d   */ 1, /* e   */ 1, /* f   */ 1, /* g   */ 1,
    /* h   */ 1, /* i   */ 1, /* j   */ 1, /* k   */ 1, /* l   */ 1, /* m   */ 1, /* n   */ 1, /* o   */ 1,
    /* p   */ 1, /* p   */ 1, /* r   */ 1, /* s   */ 1, /* t   */ 1, /* u   */ 1, /* v   */ 1, /* w   */ 1,
    /* x   */ 1, /* y   */ 1, /* z   */ 1, /* {   */ 1, /* |   */ 1, /* }   */ 1, /* ~   */ 1, /* del */ 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x80 - 0x8F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x90 - 0x9F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xA0 - 0xAF */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xB0 - 0xBF */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xC0 - 0xCF */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xD0 - 0xDF */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xE0 - 0xEF */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0  /* 0xF0 - 0xFF */
    };

#ifdef SVR4ES
#include <wctype.h>
#endif

t_Content istext(s, size, cur_content)
register unsigned char	*s;
int 		size;
t_Content	cur_content;
{
    register unsigned char *ep = s + size;
    register foundnontext;
    t_Content result;
/*
    char *type;

switch(cur_content)
    {
    case	M_binary: type = "M_binary";
    case	M_gtext: type = "M_gtext";
    case	M_text: type = "M_text";
    }

    fprintf(stderr, "istext(0x%x, %d, %s)\n", s, size, type);
*/
    switch (cur_content)
	{
	case M_text:
	    /* Look for characters which aren't 7-bit ASCII printables. */
	    result = M_text;
	    foundnontext = FALSE;
	    for (; s < ep; s++)
		{
		/*if (isprint(*s) || *s == '\n' || *s == '\t')*/
		if (isprint(*s) || iscntrl(*s))
		/* if (is7bitprintable[*s])*/
		    continue;
		foundnontext = TRUE;
		break;
		}
	    /* If any are found, then continue checking for non-generic-text printables */
	    if (!foundnontext)
		break;
	    /* FALLTHROUGH */

#ifdef SVR4ES
#define GSS2 0x8E
#define GSS3 0x8F
#define GISASCII(c) (((c)&0x80) != 0)
	case M_gtext:
	    /* look for characters which aren't locale-specific printables */
	    result = M_gtext;
	    while (s < ep)
		{
		register int c = *s;
		/* Code sets 1, 2 and 3 */
		if ((c == GSS2 || c == GSS3) || GISASCII(c))
		    {
		    /* Convert k bytes to a wide character. */
		    wchar_t w;
		    int k = mbtowc(&w, (char*)s, ep - s);
		    if (k == -1)
			return M_binary;
		    s += k;
		    /* Is our wide character printable? */
		    if (!(iswprint(w) || iswspace(w)))
			{
			result = M_binary;
			break;
			}
		    }
		/* Code sets 0 */
		else
		    {
		    /* Is our byte printable? */
		    if (!(Isprint(c) || Isspace(c) || (c == '\b')))
			{
			result = M_binary;
			break;
			}
		    s++;
		    }
		}

	    break;
#endif

	default:
	case M_binary:
	    result = M_binary;
	    break;
	}

/*
switch(cur_content)
    {
    case	M_binary: type = "M_binary";
    case	M_gtext: type = "M_gtext";
    case	M_text: type = "M_text";
    }

fprintf(stderr, "istextreturned %s.\n", type);
*/

return(result);
}

/*
 * linecount (line, size) - determine the number of lines in a printable
 *                          file.
 */
int
linecount(lp, size)
	char	*lp;
	int 	size;
{
	register unsigned char	*line = (unsigned char*)lp;
	register unsigned char *ch;
	register int count = 0;

	for (ch = line+size; --ch >= line;)
		if (*ch == '\n')
			count++;
	return (count);
}
