#	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.
#	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)portmgmt:common/cmd/portmgmt/tty_settings/tty.mk	1.6.8.4"
#ident "$Header: tty.mk 2.1 91/08/12 $"

include $(CMDRULES)

OAMBASE=$(USRSADM)/sysadm
INSDIR = $(OAMBASE)/menu/ports/tty_settings
BINDIR = $(OAMBASE)/bin
LINK = ln

MAINS=ttylist
TTYSRC=ttylist.c
TTYOBJ=ttylist.o
TTYLIST=ttylist

TASKS = add list remove

O_DFILES = tty.menu ttyvalues Help

add=Form.tty_add Text.tty_add Menu.tty_baud Menu.c_labels

list=Menu.tty_list Text.tty_list

remove=Menu.tty_remov

all: $(MAINS)

$(TTYLIST): $(TTYOBJ)
	$(CC) $(LDFLAGS) $(SHLIBS) $(TTYOBJ) -o $(TTYLIST)

clean:
	-rm -f *.o

clobber: clean
	-rm -f $(MAINS)
	
install: all dirs
	$(INS) -m 755 -g bin -u bin -f $(BINDIR) $(TTYLIST)
# add
	for i in $(add) ;\
	do \
		$(INS) -m 644 -g bin -u bin -f $(INSDIR)/add $$i ;\
	done
# list
	for i in $(list) ;\
	do \
		$(INS) -m 644 -g bin -u bin -f $(INSDIR)/list $$i ;\
	done
# remove
	for i in $(remove) ;\
	do \
		$(INS) -m 644 -g bin -u bin -f $(INSDIR)/remove $$i ;\
	done
	for i in $(O_DFILES) ;\
	do \
		$(INS) -m 644 -g bin -u bin -f $(INSDIR) $$i ;\
	done
#symbolic link all Help files
	-$(LINK) $(INSDIR)/Help $(INSDIR)/add/Help 
	-$(LINK) $(INSDIR)/Help $(INSDIR)/list/Help 
	-$(LINK) $(INSDIR)/Help $(INSDIR)/remove/Help 

size:	all

strip:	all

dirs:
	[ -d $(INSDIR) ] || mkdir -p $(INSDIR)
	for dir in $(TASKS) ;\
	do \
		[ -d $(INSDIR)/$$dir ] || mkdir -p $(INSDIR)/$$dir ;\
	done
