/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)head-nuc:api/nwerrors.h	1.1"
#ident	"$Header: $"

/*
 * Copyright 1989, 1991 Novell, Inc. All Rights Reserved.
 *
 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 * TREATIES.  NO PART OF THIS WORK MAY BE USED, PRACTICED, PERFORMED,
 * COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
 * CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
 * TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT
 * OF NOVELL.  ANY USE OR EXPLOITATION OF THIS WORK WITHOUT
 * AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
 * CIVIL LIABILITY.
 *
 *    include/api/nwerrors.h 1.7 (Novell) 7/30/91
 */

/*======================================================================
  ==    program         : NetWare Directory Services Platform Library
  ==
  ==    file            : nwerrors.h
  ==
  ==    date            : 13 December 1989
  ==
  ==    modifications   :
  ==
  ==    comments        : The format of the error code, which is 
  ==					contained in an unsigned long word 
  ==					(32-bits), is as follows:
  ==                 ||   high word       |       low word           ||
  ==                   ----------------------------------------------
  ==                 ||high byte| low byte| high byte  | low byte    ||
  ==                   ==============================================
  ==                 ||reserved | section | subsection | server error||
  ==                   ==============================================
  ==
  ==    Copyright (c) 1988-1990 Novell, Inc.  All rights reserved.
  ==
  ===================================================================*/

#ifndef _NWERRORS_
#define _NWERRORS_

extern unsigned long NWErrno;
#define NWSUCCESSFUL                       0x00000000L

/*=====================================================================
=                   		Sub-Section Base Masks
=
= 0x00      Sub-Section code is for errors returned by servers running
				netware 386 and later and errors created by the OS2
				api library software team before 3/1/90.
				Sub-Section code 0x00 and low order bytes between
				0x30-0x70 are for errors that were created by 
				the portable api library software team and have to 
				passed back using only one byte (nwccode_t) and later 
				ored with a section base mask.
=
= 0x10		Sub-Section code is reserved for errors that are like
				errors across section base masks and do not have to be 
				passed back as one byte (nwccode_t). These errors
				were created by the portable api library software team.
=
= 0x20		Sub-Section code is reserved for errors that are non-like
				errors across section base masks and do not have to be 
				passed back as one byte (nwccode_t). These errors
				were created by the portable api library software team.
=======================================================================
*/

/*======================================================================
=                   		Section Base Masks
=
========================================================================
*/
#define NWERR_ACCOUNT           0x00010000L
#define NWERR_ACCOUNT_INVALID_PARAMETERS   (NWERR_ACCOUNT | 0x000020FBL)
#define NWERR_ACCOUNT_INVALID_CONNECTION_ID	(NWERR_ACCOUNT | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_ACCOUNT_INVALID_NCP_PACKET_LENGTH (NWERR_ACCOUNT | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_ACCOUNT_SETTING_UP_TIMEOUT		(NWERR_ACCOUNT | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_ACCOUNT_TRANSPORT_SEND			(NWERR_ACCOUNT | \
													NWERR_TRANSPORT_SEND)
#define NWERR_ACCOUNT_IN_SETTING_SIGNALS		(NWERR_ACCOUNT | \
												NWERR_IN_SETTING_SIGNALS)
#define NWERR_ACCOUNT_INVALID_PARAMETER_LENGTH	(NWERR_ACCOUNT | \
													0x00001001L)



#define	NWERR_BINDERY			0x00070000L
#define NWERR_BIND              NWERR_BINDERY
#define NWERR_BIND_SERVER_OUT_OF_MEMORY     (NWERR_BIND | 0x96)
#define NWERR_BIND_LOGIN_LOCKOUT            (NWERR_BIND | 0xC5)
#define NWERR_BIND_DUPLICATE_PASSWORD       (NWERR_BIND | 0xD7)
#define NWERR_BIND_NO_DISK_TRACK            (NWERR_BIND | 0xE7)
#define NWERR_BIND_WRITE_TO_GROUP           (NWERR_BIND | 0xE8)
#define NWERR_BIND_MEMBER_EXISTS            (NWERR_BIND | 0xE9)
#define NWERR_BIND_NO_SUCH_MEMBER           (NWERR_BIND | 0xEA)
#define NWERR_BIND_NOT_SET_PROPERTY         (NWERR_BIND | 0xEB)
#define NWERR_BIND_NO_SUCH_SET              (NWERR_BIND | 0xEC)
#define NWERR_BIND_OBJECT_EXISTS            (NWERR_BIND | 0xEE)
#define NWERR_BIND_ILLEGAL_NAME             (NWERR_BIND | 0xEF)
#define NWERR_BIND_ILLEGAL_WILDCARD         (NWERR_BIND | 0xF0)
#define NWERR_BIND_BINDERY_SECURITY         (NWERR_BIND | 0xF1)
#define NWERR_BIND_NO_OBJECT_READ           (NWERR_BIND | 0xF2)
#define NWERR_BIND_NO_OBJECT_DELETE         (NWERR_BIND | 0xF4)
#define NWERR_BIND_NO_OBJECT_CREATE         (NWERR_BIND | 0xF5)
#define NWERR_BIND_NO_PROPERTY_DELETE       (NWERR_BIND | 0xF6)
#define NWERR_BIND_NO_PROPERTY_CREATE       (NWERR_BIND | 0xF7)
#define NWERR_BIND_NO_PROPERTY_WRITE        (NWERR_BIND | 0xF8)
#define NWERR_BIND_NO_PROPERTY_READ         (NWERR_BIND | 0xF9)
#define NWERR_BIND_NO_SUCH_PROPERTY         (NWERR_BIND | 0xFB)
#define NWERR_BIND_NO_SUCH_OBJECT           (NWERR_BIND | 0xFC)
#define NWERR_BIND_DIR_LOCKED               (NWERR_BIND | 0xFE)
#define NWERR_BIND_HARD_FAILURE             (NWERR_BIND | 0xFF)
#define NWERR_BIND_FAILURE                  (NWERR_BIND | 0xFF)
#define NWERR_BIND_NO_MORE_OBJECTS			NWERR_BIND_NO_SUCH_OBJECT
#define NWERR_BIND_NO_MORE_PROPERTIES       NWERR_BIND_NO_SUCH_PROPERTY
#define NWERR_BIND_NO_MORE_PROP_VALS        NWERR_BIND_NO_PROPERTY_READ
#define NWERR_BIND_INVALID_PARAMETERS		(NWERR_BIND | 0x000020FBL)
#define NWERR_BIND_INVALID_CONNECTION_ID	(NWERR_BIND | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_BIND_INVALID_NCP_PACKET_LENGTH (NWERR_BIND | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_BIND_SETTING_UP_TIMEOUT		(NWERR_BIND | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_BIND_TRANSPORT_SEND			(NWERR_BIND | \
													NWERR_TRANSPORT_SEND)
#define NWERR_BIND_IN_SETTING_SIGNALS		(NWERR_BIND | \
												NWERR_IN_SETTING_SIGNALS)
#define NWERR_BIND_INVALID_PARAMETER_LENGTH	(NWERR_BIND | 0x00001001L)



#define NWERR_CONNECTION   		0x00090000L
#define NWERR_CONN        		0x00090000L
#define NWERR_CONN_INVALID_CONNECTION_ID	(NWERR_CONN | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_CONN_INVALID_NCP_PACKET_LENGTH (NWERR_CONN | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_CONN_SETTING_UP_TIMEOUT		(NWERR_CONN | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_CONN_TRANSPORT_SEND			(NWERR_CONN | \
													NWERR_TRANSPORT_SEND)
#define NWERR_CONN_IN_SETTING_SIGNALS		(NWERR_CONN | \
												NWERR_IN_SETTING_SIGNALS)
#define NWERR_CONN_INVALID_PARAMETER_LENGTH	(NWERR_CONN | 0x00001001L)
#define NWERR_CONN_SETTING_UP_INTERRUPT		(NWERR_CONN | 0x00002001L)
#define NWERR_CONN_TRANSPORT_OPEN			(NWERR_CONN | 0x00002002L)
#define NWERR_CONN_TRANSPORT_CLOSE			(NWERR_CONN | 0x00002003L)
#define NWERR_CONN_NOT_CONNECTED_TO_SERVER	(NWERR_CONN | 0x00002004L)
#define NWERR_CONN_CONNECT_LIST_OVERFLOW	(NWERR_CONN | 0x00000004L)
#define NWERR_CONN_UNENCRYPTED_PASSWORD		(NWERR_CONN | 0x000000D6L)
#define NWERR_CONN_SERVER_OUT_OF_MEMORY		(NWERR_CONN | 0x00000096L)
#define NWERR_CONN_NO_ACCOUNT_BALANCE		(NWERR_CONN | 0x000000C1L)
#define NWERR_CONN_CREDIT_LIMIT_EXCEEDED	(NWERR_CONN | 0x000000C2L)
#define NWERR_CONN_LOGIN_LOGOUT				(NWERR_CONN | 0x000000C5L)
#define NWERR_CONN_ACCOUNT_BAD				(NWERR_CONN | 0x000000D7L)
#define NWERR_CONN_PASSWORD_TOO_SHORT		(NWERR_CONN | 0x000000D8L)
#define NWERR_CONN_MAX_LOGINS_EXCEEDED		(NWERR_CONN | 0x000000D9L)
#define NWERR_CONN_BAD_LOGIN_TIME			(NWERR_CONN | 0x000000DAL)
#define NWERR_CONN_LOGIN_STATION_ERROR		(NWERR_CONN | 0x000000DBL)
#define NWERR_CONN_BAD_PASSWORD				(NWERR_CONN | 0x000000DEL)
#define NWERR_CONN_PASSWORD_EXPIRED			(NWERR_CONN | 0x000000DFL)
#define NWERR_CONN_WRITE_TO_GROUP			(NWERR_CONN | 0x000000E8L)
#define NWERR_CONN_NO_SUCH_SET				(NWERR_CONN | 0x000000ECL)
#define NWERR_CONN_PROPERTY_EXISTS			(NWERR_CONN | 0x000000EDL)
#define NWERR_CONN_ILLEGAL_NAME				(NWERR_CONN | 0x000000EFL)
#define NWERR_CONN_ILLEGAL_WILDCARD			(NWERR_CONN | 0x000000F0L)
#define NWERR_CONN_BINDERY_SECURITY			(NWERR_CONN | 0x000000F1L)
#define NWERR_CONN_NO_OBJECT_READ			(NWERR_CONN | 0x000000F2L)
#define NWERR_CONN_NO_PROPERTY_DELETE		(NWERR_CONN | 0x000000F6L)
#define NWERR_CONN_ALREADY_ATTACHED_TO_SERVER (NWERR_CONN | 0x000000F8L)
#define NWERR_CONN_NO_FREE_CONNECTION_SLOTS	(NWERR_CONN | 0x000000F9L)
#define NWERR_CONN_NO_MORE_SERVER_SLOTS		(NWERR_CONN | 0x000000FAL)
#define NWERR_CONN_INVALID_PARAMETERS		(NWERR_CONN | 0x000020FBL)
#define NWERR_CONN_UNKNOWN_FILE_SERVER		(NWERR_CONN | 0x000000FCL)
#define NWERR_CONN_SERVER_BINDERY_LOCKED	(NWERR_CONN | 0x000000FEL)
#define NWERR_CONN_NO_RESPONSE_FROM_SERVER	(NWERR_CONN | 0x000000FFL)




#define NWERR_FS                             0x00110000L
#define NWERR_FS_PATH_TOO_LONG               (NWERR_FS | 0x00000001L)   
#define NWERR_FS_NO_MORE_RESTRICTIONS        (NWERR_FS | 0x00000024L)
#define NWERR_FS_NO_CREATE_PRIVILEGES        (NWERR_FS | 0x00000084L)
#define NWERR_FS_NO_MORE_TRUSTEES            (NWERR_FS | 0x0000009CL)
#define NWERR_FS_DIRECTORY_NOT_EMPTY         (NWERR_FS | 0x000000A0L)
#define NWERR_FS_NOT_386_FILE_SYSTEM         (NWERR_FS | 0x000000FBL)
#define NWERR_FS_NO_SUCH_RESTRICTION         (NWERR_FS | 0x000000FEL)
#define NWERR_FS_FILE_ALREADY_EXISTS		(NWERR_FS | 0x000000FFL)
#define NWERR_FS_PATH_NOT_LOCATABLE			(NWERR_FS | 0x000000FFL)
#define NWERR_FS_NO_MODIFY_PRIVILEGES        (NWERR_FS | \
                                             NWERR_NO_MODIFY_PRIVILEGES)
#define NWERR_FS_NO_DELETE_PRIVILEGES        (NWERR_FS | \
                                             NWERR_NO_DELETE_PRIVILEGES)
#define NWERR_FS_ENTRY_IN_USE                (NWERR_FS | \
                                             NWERR_ENTRY_IN_USE)
#define NWERR_FS_NO_CONSOLE_RIGHTS           (NWERR_FS | \
                                             NWERR_NO_CONSOLE_RIGHTS)
#define NWERR_FS_SERVER_OUT_OF_MEMORY        (NWERR_FS |   \
                                             NWERR_SERVER_OUT_OF_MEMORY)
#define NWERR_FS_VOL_DOES_NOT_EXIST          (NWERR_FS |   \
                                             NWERR_VOL_DOES_NOT_EXIST)
#define NWERR_FS_NO_SUCH_BINDERY_OBJ         (NWERR_FS |   \
                                             NWERR_NO_SUCH_BINDERY_OBJ)
#define NWERR_FS_NO_OBJECT_READ              (NWERR_FS |   \
                                             NWERR_NO_OBJECT_READ)
#define NWERR_FS_BAD_DIR_HANDLE              (NWERR_FS |   \
                                             NWERR_BAD_DIR_HANDLE)
#define NWERR_FS_INVALID_PATH                (NWERR_FS |   \
                                             NWERR_INVALID_PATH)
#define NWERR_FS_ENTRY_EXISTS                (NWERR_FS |   \
                                             NWERR_ENTRY_EXISTS)
#define NWERR_FS_DIR_FULL                    (NWERR_FS |   \
                                             NWERR_DIR_FULL)
#define NWERR_FS_ENTRY_NOT_FOUND             (NWERR_FS |   \
                                             NWERR_ENTRY_NOT_FOUND)
#define NWERR_FS_INVALID_PARAMETERS			 (NWERR_FS | 0x000020FBL)	
#define NWERR_FS_INVALID_CONNECTION_ID		(NWERR_FS | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_FS_INVALID_NCP_PACKET_LENGTH 	(NWERR_FS | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_FS_SETTING_UP_TIMEOUT			(NWERR_FS | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_FS_TRANSPORT_SEND				(NWERR_FS | \
												NWERR_TRANSPORT_SEND)
#define NWERR_FS_IN_SETTING_SIGNALS			(NWERR_FS | \
												NWERR_IN_SETTING_SIGNALS)
#define NWERR_FS_INVALID_PARAMETER_LENGTH	(NWERR_FS | 0x00001001L)
#define NWERR_FS_CORRUPTION_OF_CURRENT_SCAN	(NWERR_FS | 0x00002001L)




#define NWERR_PATH              0x001b0000L
#define NWERR_PATH_BAD_SRCH_DRIVE_VCTR       (NWERR_PATH | 0x00000001L)
#define NWERR_PATH_INVALID_PATH_LENGTH       (NWERR_PATH | 0x00000002L) 
#define NWERR_PATH_INVALID_DRIVE_NUM         (NWERR_PATH | 0x00000020L)
#define NWERR_PATH_NO_DRIVES_AVAILABLE       (NWERR_PATH | 0x00000025L)
#define NWERR_PATH_WS_DOES_NOT_SUPPORT       (NWERR_PATH | 0x00000030L)
#define NWERR_PATH_INVALID_PARAMETERS		 (NWERR_PATH | 0x000020FBL)
#define NWERR_PATH_INVALID_CONNECTION_ID	(NWERR_PATH | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_PATH_INVALID_PATH				(NWERR_PATH | 0x0000009CL)
#define NWERR_PATH_NO_DIRECTORY_HANDLES		(NWERR_PATH | 0x0000009DL)
#define NWERR_PATH_INVALID_NCP_PACKET_LENGTH (NWERR_PATH | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_PATH_SETTING_UP_TIMEOUT		(NWERR_PATH | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_PATH_TRANSPORT_SEND			(NWERR_PATH | \
													NWERR_TRANSPORT_SEND)
#define NWERR_PATH_IN_SETTING_SIGNALS		(NWERR_PATH | \
												NWERR_IN_SETTING_SIGNALS)
#define NWERR_PATH_INVALID_PARAMETER_LENGTH	(NWERR_PATH | 0x00001001L)



#define NWERR_QUEUE             0x00210000L
#define NWERR_Q                 NWERR_QUEUE
#define NWERR_Q_SERVER_OUT_OF_MEMORY            (NWERR_QUEUE | 0x96)
#define NWERR_Q_DIR_FULL                        (NWERR_QUEUE | 0x99)
#define NWERR_Q_BAD_DIR_HANDLE                  (NWERR_QUEUE | 0x9B)
#define NWERR_Q_INVALID_PATH                    (NWERR_QUEUE | 0x9C)
#define NWERR_Q_ERROR                           (NWERR_QUEUE | 0xD0)
#define NWERR_Q_NO_QUEUE                        (NWERR_QUEUE | 0xD1)
#define NWERR_Q_NO_QUEUE_SERVER                 (NWERR_QUEUE | 0xD2)
#define NWERR_Q_NO_QUEUE_RIGHTS                 (NWERR_QUEUE | 0xD3)
#define NWERR_Q_FULL                            (NWERR_QUEUE | 0xD4)
#define NWERR_Q_NO_JOB                          (NWERR_QUEUE | 0xD5)
#define NWERR_Q_NO_JOB_RIGHTS                   (NWERR_QUEUE | 0xD6)
#define NWERR_Q_PASSWORD_NOT_UNIQUE             (NWERR_QUEUE | 0xD7)
#define NWERR_Q_SERVICING                       (NWERR_QUEUE | 0xD7)
#define NWERR_Q_NOT_ACTIVE                      (NWERR_QUEUE | 0xD8)
#define NWERR_Q_PASSWORD_TOO_SHORT              (NWERR_QUEUE | 0xD8)
#define NWERR_Q_STATION_NOT_SERVER              (NWERR_QUEUE | 0xD9)
#define NWERR_Q_HALTED                          (NWERR_QUEUE | 0xDA)
#define NWERR_Q_MAX_QUEUE_SERVERS               (NWERR_QUEUE | 0xDB)
#define NWERR_Q_NO_SUCH_MEMBER                  (NWERR_QUEUE | 0xEA)
#define NWERR_Q_PROPERTY_ALREADY_EXISTS         (NWERR_QUEUE | 0xED)
#define NWERR_Q_OBJECT_ALREADY_EXISTS           (NWERR_QUEUE | 0xEE)
#define NWERR_Q_INVALID_NAME                    (NWERR_QUEUE | 0xEF)
#define NWERR_Q_WILD_CARD_NOT_ALLOWED           (NWERR_QUEUE | 0xF0)
#define NWERR_Q_INVALID_BINDERY_SECUR           (NWERR_QUEUE | 0xF1)
#define NWERR_Q_NO_OBJECT_DELETE_PRIVILEGE		(NWERR_QUEUE | 0xF4)
#define NWERR_Q_NO_OBJECT_CREATE_PRIV           (NWERR_QUEUE | 0xF5)
#define NWERR_Q_NO_PROPERTY_CREATE_PRIV         (NWERR_QUEUE | 0xF7)
#define NWERR_Q_NO_SUCH_OBJECT                  (NWERR_QUEUE | 0xFC)
#define NWERR_Q_SERVER_BINDERY_LOCKED           (NWERR_QUEUE | 0xFE)
#define NWERR_Q_BINDERY_FAILURE                 (NWERR_QUEUE | 0xFF)
#define NWERR_Q_HARDWARE_FAILURE                (NWERR_QUEUE | 0xFF)
#define NWERR_Q_VOL_DOES_NOT_EXIST				(NWERR_QUEUE | 0x98)
#define NWERR_Q_INVALID_PARAMETERS				(NWERR_QUEUE | \
												0x000020FBL)
#define NWERR_Q_INVALID_CONNECTION_ID	(NWERR_QUEUE | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_Q_INVALID_NCP_PACKET_LENGTH (NWERR_QUEUE | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_Q_SETTING_UP_TIMEOUT		(NWERR_QUEUE | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_Q_TRANSPORT_SEND			(NWERR_QUEUE | \
													NWERR_TRANSPORT_SEND)
#define NWERR_Q_IN_SETTING_SIGNALS		(NWERR_QUEUE | \
												NWERR_IN_SETTING_SIGNALS)
#define NWERR_Q_INVALID_PARAMETER_LENGTH	(NWERR_QUEUE | 0x00001001L)



#define NWERR_SP                0x00230000L  /* server platform */

#define NWERR_SP_VERSION_TOO_LOW    (NWERR_SP | 0x00000001L)
#define NWERR_SP_SFT_LEVEL_TOO_LOW  (NWERR_SP | 0x00000002L)
#define NWERR_SP_TTS_LEVEL_TOO_LOW  (NWERR_SP | 0x00000004L)
#define NWERR_SP_AFP_LEVEL_TOO_LOW  (NWERR_SP | 0x00000008L)
#define NWERR_SP_NO_CONSOLE_RIGHTS  (NWERR_SP | 0x000000C6L)
#define NWERR_SP_OPEN_FILES         (NWERR_SP | 0x000000FFL)
#define NWERR_SP_INVALID_PARAMETERS (NWERR_SP | 0x000020FBL)
#define NWERR_SP_NOT_286_FILE_SYSTEM (NWERR_SP | 0x000010FCL)
#define NWERR_SP_INVALID_CONNECTION_ID	(NWERR_SP | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_SP_INVALID_NCP_PACKET_LENGTH (NWERR_SP | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_SP_SETTING_UP_TIMEOUT		(NWERR_SP | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_SP_TRANSPORT_SEND			(NWERR_SP | \
													NWERR_TRANSPORT_SEND)
#define NWERR_SP_IN_SETTING_SIGNALS		(NWERR_SP | \
												NWERR_IN_SETTING_SIGNALS)
#define NWERR_SP_INVALID_PARAMETER_LENGTH	(NWERR_SP | 0x00001001L)




#define NWERR_SYNC                         0x00270000L
#define NWERR_SYNC_SERVER_OUT_OF_MEMORY   (NWERR_SYNC |  \
                                           NWERR_SERVER_OUT_OF_MEMORY)
#define NWERR_SYNC_INVALID_NAME_LEN       (NWERR_SYNC | \
                                           NWERR_INVALID_NAME_LEN)
#define NWERR_SYNC_TIMEOUT_FAILURE        (NWERR_SYNC | \
                                           NWERR_TIMEOUT_FAILURE)
#define NWERR_SYNC_INVALID_PARAMETERS	  (NWERR_SYNC | 0x000020FBL)
#define NWERR_SYNC_INVALID_CONNECTION_ID	(NWERR_SYNC | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_SYNC_INVALID_NCP_PACKET_LENGTH (NWERR_SYNC | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_SYNC_SETTING_UP_TIMEOUT		(NWERR_SYNC | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_SYNC_TRANSPORT_SEND			(NWERR_SYNC | \
													NWERR_TRANSPORT_SEND)
#define NWERR_SYNC_IN_SETTING_SIGNALS		(NWERR_SYNC | \
												NWERR_IN_SETTING_SIGNALS)
#define NWERR_SYNC_INVALID_PARAMETER_LENGTH	(NWERR_SYNC | 0x00001001L)



#define NWERR_SEMAPHORE                   (NWERR_SYNC | 0x00000100L)
#define NWERR_SEMAPHORE_OVERFLOW          (NWERR_SEMAPHORE | 0x00000001L)
#define NWERR_SEMAPHORE_INVALID_NAM_LEN   (NWERR_SEMAPHORE | \
                                           NWERR_INVALID_NAME_LEN)
#define NWERR_SEMAPHORE_TIMEOUT_FAILURE   (NWERR_SEMAPHORE | \
                                           NWERR_TIMEOUT_FAILURE)
#define NWERR_SEMAPHORE_INVALID_CONNECTION_ID	(NWERR_SEMAPHORE | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_SEMAPHORE_INVALID_NCP_PACKET_LENGTH (NWERR_SEMAPHORE | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_SEMAPHORE_SETTING_UP_TIMEOUT		(NWERR_SEMAPHORE | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_SEMAPHORE_TRANSPORT_SEND			(NWERR_SEMAPHORE | \
													NWERR_TRANSPORT_SEND)
#define NWERR_SEMAPHORE_IN_SETTING_SIGNALS		(NWERR_SEMAPHORE | \
												NWERR_IN_SETTING_SIGNALS)
#define NWERR_SEMAPHORE_INVALID_PARAMETER_LENGTH	(NWERR_SEMAPHORE | \
													0x00001001L)



#define NWERR_TTS                         0x00290000L
#define NWERR_TTS_SERVER_OUT_OF_MEMORY    (NWERR_TTS |  \
                                           NWERR_SERVER_OUT_OF_MEMORY)
#define NWERR_TTS_NO_CONSOLE_RIGHTS       (NWERR_TTS |  \
                                           NWERR_NO_CONSOLE_RIGHTS)
#define NWERR_TTS_IMPLICIT_TRANS_ACTIVE   (NWERR_TTS | 0x000000FEL)
#define NWERR_TTS_RECORDS_STILL_LOCKED    (NWERR_TTS | 0x000000FEL)
#define NWERR_TTS_NO_EXPL_TRANS_ACTIVE    (NWERR_TTS | 0x000000FFL)
#define NWERR_TTS_EXPLICIT_TRANS_ACTIVE   (NWERR_TTS | 0x000000FFL)
#define NWERR_TTS_TRANS_NOT_WRITTEN       (NWERR_TTS | 0x000000FFL)
#define NWERR_TTS_INVALID_CONNECTION_ID	(NWERR_TTS | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_TTS_INVALID_NCP_PACKET_LENGTH (NWERR_TTS | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_TTS_SETTING_UP_TIMEOUT		(NWERR_TTS | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_TTS_TRANSPORT_SEND			(NWERR_TTS | \
													NWERR_TRANSPORT_SEND)
#define NWERR_TTS_IN_SETTING_SIGNALS		(NWERR_TTS | \
												NWERR_IN_SETTING_SIGNALS)
#define NWERR_TTS_INVALID_PARAMETER_LENGTH	(NWERR_TTS | 0x00001001L)


/*======================================================================
                       Server-Returned Error Codes
========================================================================
*/
#define	NWERR_OUT_OF_DISK_SPACE				0x00000001L
#define	NWERR_BAD_SRCH_DRIVE_VECTOR			0x00000001L
#define	NWERR_VERSION_TOO_LOW				0x00000001L
#define NWERR_SFT_LEVEL_TOO_LOW				0x00000002L
#define NWERR_TTS_LEVEL_TOO_LOW				0x00000004L
#define NWERR_AFP_LEVEL_TOO_LOW				0x00000008L
#define NWERR_INVALID_DRIVE_NUM				0x00000020L
#define NWERR_NO_MORE_RESTRICTIONS			0x00000024L
#define NWERR_NO_DRIVES_AVAILABLE			0x00000025L
#define NWERR_WS_DOES_NOT_SUPPORT			0x00000030L
#define NWERR_LOCK_FAIL						0x00000080L
#define NWERR_FILE_IN_USE					0x00000080L
#define NWERR_NO_MORE_FILE_HANDLES			0x00000081L
#define NWERR_NO_OPEN_PRIVILEGES			0x00000082L
#define NWERR_IO_ERROR_NETWORK_DISK			0x00000083L
#define NWERR_NO_CREATE_PRIVILEGES			0x00000084L
#define NWERR_NO_CREATE_DELETE_PRIVILEGES	0x00000085L
#define NWERR_CREATE_FILE_EXISTS_READ_ONLY	0x00000086L
#define NWERR_CREATE_ERROR					0x00000087L
#define NWERR_WILD_CARDS_IN_CREATE_FILE_NAM	0x00000087L
#define NWERR_CREATE_FILE_NAME				0x00000087L
#define	NWERR_INVALID_FILE_HANDLE			0x00000088L
#define NWERR_NO_SEARCH_PRIVILEGES			0x00000089L
#define NWERR_NO_DELETE_PRIVILEGES         	0x0000008AL
#define NWERR_NO_RENAME_PRIVILEGES			0x0000008BL
#define NWERR_NO_MODIFY_PRIVILEGES         	0x0000008CL
#define NWERR_ENTRY_IN_USE                 	0x0000008DL
#define NWERR_SOME_FILES_AFFECTED_IN_USE	0x0000008DL
#define NWERR_ALL_FILES_IN_USE				0x0000008EL
#define NWERR_NO_FILES_AFFECTED_IN_USE		0x0000008EL
#define NWERR_SOME_FILES_AFFECTED_READ_ONLY	0x0000008FL
#define NWERR_ALL_READ_ONLY					0x00000090L
#define NWERR_NO_FILES_AFFECTED_READ_ONLY	0x00000090L
#define NWERR_SOME_FILES_RENAMED_NAME_EXIST 0x00000091L
#define NWERR_NO_FILES_RENAMED_NAME_EXISTS  0x00000092L
#define NWERR_NO_READ_PRIVILEGES			0x00000093L
#define NWERR_NO_WRITE_PRIVILEGES			0x00000094L
#define NWERR_FILE_DETACHED					0x00000095L 
#define NWERR_SERVER_OUT_OF_MEMORY         	0x00000096L 
#define NWERR_NO_DISK_SPACE_FOR_SPOOL_FILE	0x00000097L
#define NWERR_VOL_DOES_NOT_EXIST           	0x00000098L 
#define NWERR_BAD_VOL_NUM   	        	0x00000098L 
#define NWERR_DIR_FULL                     	0x00000099L 
#define NWERR_INVALID_NAME                 	0x00000099L 
#define NWERR_RENAMING_ACROSS_VOLUMES		0x0000009AL
#define NWERR_BAD_DIR_HANDLE               	0x0000009BL
#define NWERR_INVALID_PATH                 	0x0000009CL
#define NWERR_NO_MORE_TRUSTEES				0x0000009CL
#define NWERR_NO_MORE_DIRECTORY_HANDLES		0x0000009DL
#define NWERR_BAD_FILE_NAME					0x0000009EL
#define NWERR_INVALID_FILE_NAME				0x0000009EL
#define NWERR_DIRECTORY_ACTIVE				0x0000009FL
#define NWERR_DIRECTORY_NOT_EMPTY			0x000000A0L
#define NWERR_DIRECTORY_IO_ERROR			0x000000A1L
#define NWERR_READ_FILE_WITH_RECORD_LOCKED	0x000000A2L
#define NWERR_NO_ACCOUNT_PRIVILEGES		   	0x000000C0L
#define NWERR_NO_ACCOUNT_BALANCE			0x000000C1L
#define NWERR_CREDIT_LIMIT_EXCEEDED			0x000000C2L
#define NWERR_LOGIN_DENIED_NO_CREDIT_LIMIT	0x000000C2L
#define NWERR_TOO_MANY_HOLDS				0x000000C3L
#define NWERR_USER_ACCOUNT_DISABLED			0x000000C4L
#define NWERR_INTRUDER_DETECTION_LOCK		0x000000C5L
#define NWERR_LOGIN_LOCKOUT					0x000000C5L
#define NWERR_NO_CONSOLE_OPERATOR_RIGHTS  	0x000000C6L
#define NWERR_QUEUE_ERROR					0x000000D0L
#define NWERR_NO_QUEUE                      0x000000D1L
#define NWERR_NO_QUEUE_SERVER               0x000000D2L
#define NWERR_NO_QUEUE_RIGHTS               0x000000D3L
#define NWERR_QUEUE_FULL                    0x000000D4L
#define NWERR_NO_JOB    		            0x000000D5L
#define NWERR_NO_JOB_RIGHTS    			    0x000000D6L
#define NWERR_UNENCRYPTED_PASSWORD			0x000000D6L
#define NWERR_ACCOUNT_BAD					0x000000D7L
#define NWERR_PASSWORD_NOT_UNIQUE			0x000000D7L
#define NWERR_QUEUE_SERVICING				0x000000D7L
#define NWERR_PASSWORD_TOO_SHORT			0x000000D8L
#define NWERR_QUEUE_NOT_ACTIVE				0x000000D8L
#define NWERR_MAXIMUM_LOGINS_EXCEEDED		0x000000D9L
#define NWERR_LOGIN_DENIED_NO_CONNECTION	0x000000D9L
#define NWERR_QUEUE_PASSWORD_TOO_SHORT		0x000000D9L
#define NWERR_BAD_LOGIN_TIME				0x000000DAL
#define NWERR_UNAUTHORIZED_LOGIN_TIME		0x000000DAL
#define NWERR_QUEUE_HALTED					0x000000DAL
#define NWERR_LOG_STATION_ERROR				0x000000DBL
#define NWERR_UNAUTHORIZED_LOGIN_STATION	0x000000DBL
#define NWERR_MAX_QUEUE_SERVERS				0x000000DBL
#define NWERR_ACCOUNT_DISABLED				0x000000DCL
#define NWERR_BAD_PASSWORD					0x000000DEL
#define NWERR_PASSWORD_HAS_EXPIRED_NO_GRACE	0x000000DEL
#define NWERR_OLD_PASSWORD					0x000000DFL
#define NWERR_NO_DISK_TRACK					0x000000E7L
#define NWERR_WRITE_PROPERTY_TO_GROUP		0x000000E8L
#define NWERR_NOT_ITEM_PROPERTY				0x000000E8L
#define NWERR_MEMBER_ALREADY_EXISTS			0x000000E9L
#define NWERR_NO_SUCH_MEMBER				0x000000EAL
#define NWERR_NOT_SET_PROPERTY				0x000000EBL
#define	NWERR_NO_SUCH_SET					0x000000ECL
#define	NWERR_NO_SUCH_SEGMENT				0x000000ECL
#define NWERR_PROPERTY_ALREADY_EXISTS		0x000000EDL
#define	NWERR_OBJECT_ALREADY_EXISTS			0x000000EEL
#define NWERR_ILLEGAL_NAME					0x000000EFL
#define NWERR_ILLEGAL_WILDCARD				0x000000F0L
#define NWERR_WILDCARD_NOT_ALLOWED			0x000000F0L
#define NWERR_MALFORMED_NCP_PACKET			0x000000F0L
#define NWERR_INVALID_BINDERY_SECURITY		0x000000F1L
#define NWERR_NO_OBJECT_READ_PRIVILEGE     	0x000000F2L
#define NWERR_NO_OBJECT_RENAME_PRIVILEGE	0x000000F3L
#define NWERR_NO_OBJECT_DELETE_PRIVILEGE	0x000000F4L
#define NWERR_NO_OBJECT_CREATE_PRIVILEGE	0x000000F5L
#define NWERR_NO_PROPERTY_DELETE_PRIVILEGE	0x000000F6L
#define NWERR_NOT_SAME_LOCAL_DRIVE			0x000000F6L
#define NWERR_NO_PROPERTY_CREATE_PRIVILEGE	0x000000F7L 
#define NWERR_TARGET_DRIVE_NOT_LOCAL		0x000000F7L
#define NWERR_NO_PROPERTY_WRITE_PRIVILEGE	0x000000F8L
#define NWERR_ALREADY_ATTACHED_TO_SERVER	0x000000F8L
#define NWERR_NOT_ATTACHED_TO_SERVER		0x000000F8L
#define NWERR_NO_PROPERTY_READ_PRIVILEGE	0x000000F9L
#define NWERR_NO_MORE_PROP_VALS				0x000000F9L
#define NWERR_NO_MORE_SERVER_SLOTS			0x000000FAL
#define NWERR_TEMP_REMAP_ERROR				0x000000FAL
#define NWERR_INVALID_PARAMETERS           	0x000000FBL 
#define NWERR_NOT_386_FILE_SYSTEM          	0x000000FBL 
#define NWERR_NO_MORE_PROPERTIES          	0x000000FBL 
#define NWERR_NO_SUCH_PROPERTY          	0x000000FBL 
#define NWERR_INTERNET_PACKET_REQT_CANCELED	0x000000FBL 
#define NWERR_SEMAPHORE_INVALID_PARAMETERS 	0x000000FBL 
#define NWERR_SYNC_INVALIDE_PARAMETERS     	0x000000FBL 
#define NWERR_NO_SUCH_OBJECT	          	0x000000FCL
#define NWERR_NO_MORE_OBJECTS	          	0x000000FCL
#define NWERR_UNKNOWN_FILE_SERVER			0x000000FCL
#define NWERR_MESSAGE_QUEUE_FULL			0x000000FCL
#define NWERR_BAD_STATION_NUMBER			0x000000FDL
#define NWERR_INVALID_PACKET_LENGTH			0x000000FDL
#define NWERR_TTS_DISABLED					0x000000FDL
#define NWERR_UNKNOWN_REQUEST				0x000000FDL
#define NWERR_TIMEOUT_FAILURE              	0x000000FEL
#define NWERR_INVALID_NAME_LEN             	0x000000FEL
#define NWERR_BINDERY_LOCKED				0x000000FEL
#define NWERR_DIRECTORY_LOCKED				0x000000FEL
#define NWERR_INVALID_SEMAPHORE_NAME_LENGTH 0x000000FEL
#define NWERR_IMPLICIT_TRANS_ACTIVE			0x000000FEL
#define NWERR_NO_SUCH_RESTRICTION			0x000000FEL
#define NWERR_PACKET_NOT_DELIVERABLE		0x000000FEL
#define NWERR_RECORDS_STILL_LOCKED			0x000000FEL
#define NWERR_SERVER_BINDERY_LOCKED			0x000000FEL
#define NWERR_SOCKET_TABLE_FULL				0x000000FEL
#define NWERR_SPOOL_DIRECTORY_ERROR			0x000000FEL
#define NWERR_SUPERVISOR_HAS_DISABLED_LOGIN 0x000000FEL
#define NWERR_ENTRY_NOT_FOUND              	0x000000FFL
#define NWERR_NO_FILES_FOUND               	0x000000FFL
#define NWERR_BAD_PRINTER_ERROR				0x000000FFL
#define NWERR_BAD_RECORD_OFFSET				0x000000FFL
#define NWERR_CLOSE_FCB_ERROR				0x000000FFL
#define NWERR_ENTRY_EXISTS					0x000000FFL
#define NWERR_EXPLICIT_TRANS_ACTIVE			0x000000FFL
#define NWERR_FILE_ALREADY_EXISTS			0x000000FFL
#define NWERR_FILE_EXTENSION_ERROR			0x000000FFL
#define NWERR_FILE_NAME_ERROR				0x000000FFL
#define NWERR_HARDWARE_FAILURE				0x000000FFL
#define NWERR_INVALID_DRIVE_NUMBER			0x000000FFL
#define NWERR_INVALID_INITIAL_SEMAPHORE_VAL 0x000000FFL
#define NWERR_INVALID_SEMAPHORE_HANDLE		0x000000FFL
#define NWERR_IO_BOUND_ERROR				0x000000FFL
#define NWERR_NO_EXPLICIT_TRANS_ACTIVE		0x000000FFL
#define NWERR_NO_FILES_FOUND_ERROR			0x000000FFL
#define NWERR_NO_MORE_FILES_FOUND			0x000000FFL	
#define NWERR_NO_RESPONSE_FROM_SERVER		0x000000FFL
#define NWERR_NO_SUCH_OBJECT_OR_BAD_PASSWORD 0x000000FFL
#define NWERR_OPEN_FILES					0x000000FFL
#define NWERR_PATH_NOT_LOCATABLE			0x000000FFL
#define NWERR_QUEUE_FULL_ERROR				0x000000FFL
#define NWERR_REQUEST_NOT_OUTSTANDING		0x000000FFL
#define NWERR_SEMAPHORE_INVALID_VALUE		0x000000FFL
#define NWERR_SEMAPHORE_INVALID_HANDLE		0x000000FFL
#define NWERR_SOCKET_ALREADY_OPEN			0x000000FFL
#define NWERR_SYNC_LOCK_FAILURE				0x000000FFL
#define NWERR_SYNC_ENTRY_NOT_FOUND			0x000000FFL
#define NWERR_SYNC_RECORD_NOT_FOUND			0x000000FFL
#define NWERR_TRANS_NOT_WRITTEN				0x000000FFL
#define NWERR_TTS_NOT_AVAILABLE				0x000000FFL

/*======================================================================
                   Client Generated - Returned Error Codes
========================================================================
*/
#define NWERR_INVALID_CONNECTION_ID						0x00000030L
#define NWERR_INVALID_NCP_PACKET_LENGTH 				0x00000031L
#define NWERR_SETTING_UP_TIMEOUT					 	0x00000032L
#define NWERR_TRANSPORT_SEND						 	0x00000033L
#define NWERR_IN_SETTING_SIGNALS					 	0x00000034L
#define NWERR_SERVER_CONNECTION_LOST					0x00000035L
#ifndef NWERR_NO_RESPONSE_FROM_SERVER
#define NWERR_NO_RESPONSE_FROM_SERVER					0x000000FFL
#endif

#endif
