/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)ktool:common/ktool/idtools/idtarg/idmkinit.c	1.14"
#ident	"$Header:"

/* This program reads Init files in /etc/conf/init.d/* and generates
 * inittab entries. These entries are combined, starting w/the kernel Init file,
 * to produce /etc/conf/cf.d/inittab.
 * An inittab entry has the form:
 *	id:rstate:action:process
 * The files in /etc/conf/init.d must have the form:
 *	CASE 1: action:process   , OR
 *	CASE 2: rstate:action:process
 *	CASE 3: id:rstate:action:process
 * Idmkinit will insert the fields:
 *	CASE 1:  id:2:
 *	CASE 2:  id:
 *	CASE 3:  	(nothing)
 * Inserted id's start at 00 and advance numerically.
 *
 * The command line options are:
 *	-o directory	- an alternate installation directory.
 *	-e directory	- the directory containing the Init files.
 *	-M module_name	- the loadable module which just preconfigured.
 *	-#		- print diagnostics.
 */

#include "inst.h"
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <varargs.h>
#include <sys/stat.h>

#include <locale.h>
#include <pfmt.h>

/* directories */
#define	ENVIRON		0
#define OUTPUT		1
#define FULL_PATH	2

/* error messages */
#define USAGE	":100:Usage: idmkinit [-o directory] [-e directory] [[-M module_name] ...] [-#]\n"

/* misc. */
#define	FOUND		0
#define	UNFOUND		1

/* directories */
char current[256];		/* current directory */
char envirmnt[256];		/* path name of init directory */
char output[256];		/* path name of '/dev' directory */

/* flags */
int oflag;			/* 'etc' directory specified */
int eflag;			/* 'init.d' directory specified */
int debug;			/* debug flag */
int errors;			/* number of errors */
int colons;			/* number of colons */
int mflag;			/* loadable module specified */

/* new inittab variables */
FILE *initp;			/* file pointer to new inittab */
int initid;			/* two character id used in field 1 */

int initchg;

FILE *open1();
DIR  *open2();
void runcmd();
extern char *optarg;		/* used by getopt */

struct modlist *modlist;
extern int setlevel();

main(argc, argv)
int argc;
char *argv[];
{
	char buf[LINESZ];
	int c;
	struct modlist *mod;

	umask(022);

        (void) setlocale(LC_ALL, "");
        (void) setcat("uxidtools");
        (void) setlabel("UX:idmkinit");

	while ((c = getopt(argc, argv, "M:o:e:#?")) != EOF)
		switch (c) {
		case 'e':	/* contains init files */
			strcpy(envirmnt, optarg);
			eflag++;
			break;
		case 'o':	/* output directory */
			strcpy(output, optarg);
			oflag++;
			break;
		case 'M':
			mflag++;
			mod = (struct modlist *)malloc(sizeof(struct modlist));
			strcpy(mod->name, optarg);
			mod->next = modlist;
			modlist = mod;
			break;
		case '#':
			debug++;
			break;
		case '?':
			pfmt(stderr, MM_ACTION, USAGE);
			exit(1);
		}

	/* get current directory */
	getcwd(current, 80);

	/* get full path name */
	sprintf(buf, "%s/init.d", ROOT);
	getpath(eflag, envirmnt, buf);
	sprintf(buf, "%s/%s", ROOT, CFDIR);
	getpath(oflag, output, buf);

	if (debug) {
		fprintf(stderr, "debug:\toutput=%s\n\tenvirmnt=%s\n",
			output, envirmnt);
		fprintf(stderr, "\tcurrent=%s\n", current);
	}

	/* open inittab for output */
	if (mflag) {
		runcmd("cp /etc/inittab %s", output);
		initp = open1("inittab", "a", OUTPUT);
	} else
		initp = open1("inittab", "w", OUTPUT);

	if (mflag)
		mod_mkinit();
	else {
		/* add a block comment to indicate the /etc/inittab is
		   automatically generated. */
		fprintf(initp,
"#\n\
# WARNING: THIS FILE IS AUTOMATICALLY GENERATED.\n\
# Any changes made directly to this file may be overwritten\n\
# at the next system reboot.\n\
# Permanent changes should also be made to files in the\n\
# /etc/conf/init.d directory.\n\
# See Init(4) and idmkinit(1M) for more information.\n\
#\n");

		/* If a kernel Init file exists, process it first */
		install("kernel");
		mkinit();		/* process other Init files */
	}
	fclose(initp);

	if (mflag) {
		if (initchg) {
			setlevel("/etc/inittab", 2);
			sprintf(buf, "mv %s/inittab /etc/inittab", output);
			system(buf);
			chmod("/etc/inittab", 0444);
			setlevel("/etc/inittab", 1);
			runcmd("sync");
			runcmd("telinit q");
		} else
			runcmd("rm -f inittab");
	} else {
		sprintf(buf, "%s/inittab", output);
		setlevel(buf, 2);
	}
	exit(errors);
}


/* get Init files from environment directory (/etc/conf/init.d) */

mkinit()
{
	struct dirent *direntp;
	DIR *dp;

	dp = open2(envirmnt);
	while (direntp = readdir (dp)) {
		if (debug)
			fprintf(stderr, "debug: file='%s'\n", direntp->d_name);
		if (direntp->d_ino == 0 || direntp->d_name[0] == '.')
			continue;
		if (strcmp(direntp->d_name, "kernel") != 0)
			install(direntp->d_name);
	}
	closedir(dp);
}



/* Add Init Files from init.d  */

install(file)
char *file;
{
	FILE *ip;			/* pointer to node file */
	char buf[516], *p;

	ip = open1(file, "r", ENVIRON);
	if (ip == NULL)
		return;
	while (fgets(buf, 516, ip) != NULL) {

		if (debug)
			fprintf(stderr, "debug: file='%s'\n\tentry='%s'",
				file, buf);
		/* Reject comment and blank lines */
		if (buf[0] == '*' || buf[0] == '#' || buf[0] == '\n')
			continue;  
		/* check syntax of line */
		if (parse(buf)==FOUND){
			fprintf(initp, "%02d:2:%s", initid, buf);
			++initid;
		}
		else{
		    switch(colons){

		     case 1:
			fprintf(initp, "%02d:%s", initid, buf);
			++initid;
			break;

		     case 2:
			fprintf(initp, "%s", buf);
			break;

		     default:
			pfmt(stderr, MM_ERROR, ":101:Cannot parse line: %s\n", buf);
			++errors;
		  	break;
		    }
		}
	}
	fclose(ip);
}


parse(buf)
char *buf;
{
	int i;
	if (lookup(buf) == FOUND)
		return(FOUND);
	else{
		/* non 6300PLUS style; try to parse further */
		colons=0;
		for (i=0; i < (int)strlen(buf); i++){
			if (buf[i] == ':'){
				colons++;
				if (lookup(&buf[i+1])==FOUND)
					return(colons);
			}
		}
		colons = -1;
		return(UNFOUND);
	}
}

/* check for legitimate action keyword */

lookup(sptr)
char * sptr;
{

	static char *actions[] = {
		"off","respawn","ondemand","once","wait","boot",
		"bootwait","powerfail","powerwait","initdefault",
		"sysinit",
	};
	int i;
	char **keyptr;

	for (i=0,keyptr=actions; i<sizeof(actions)/sizeof(char *);i++) {
		if (!strncmp(keyptr[i], sptr, sizeof(keyptr[i])-1))
			return(FOUND);
	}
	return(UNFOUND);
}

/* open a directory */

DIR *
open2(directory)
char *directory;
{
	DIR *dp;

	if (debug)
		fprintf(stderr, "debug: open directory '%s' for mode 'r'\n",
			directory);

	if ((dp = opendir(directory)) == NULL) {
		perror(directory);
		exit(1);
	}
	return(dp);
}

/* open a file */

FILE *
open1(file, mode, dir)
char *file, *mode;
int dir;
{
	FILE *fp;
	char *p;
	char path[256];

	switch (dir) {
	case ENVIRON:
		sprintf(path, "%s/%s", envirmnt, file);
		p = path;
		break;
	case OUTPUT:
		sprintf(path, "%s/%s", output, file);
		p = path;
		break;
	case FULL_PATH:
		p = file;
		break;
	}

	if (debug)
		fprintf(stderr, "debug: open '%s' for mode '%s'\n",
			p, mode);

	if ((fp = fopen(p, mode)) == NULL) {
		perror(file);
		exit(1);
	}
	return(fp);
}


/* construct full path name */

getpath(flag, buf, def)
int flag;
char *buf, *def;
{
	switch (flag) {
	case 0:
		strcpy(buf, def);
		break;
	case 1:
		if (chdir(buf) != 0) {
			perror(buf);
			exit(1);
		}
		getcwd(buf, 80);
		chdir(current);
		break;
	}
}

mod_mkinit()
{
	struct modlist *mod;
	char file[256];
	struct stat statb;

	for (mod = modlist; mod != NULL; mod = mod->next) {
		sprintf(file, "%s/%s", envirmnt, mod->name);
		if (stat(file, &statb) < 0)
			if (errno == ENOENT)
				continue;
			else {
				pfmt(stderr, MM_ERROR, ":102:Can't access %s for module %s\n",
					file, mod->name);
				exit(1);
			}
		install(mod->name);
		initchg++;
	}
}

/* This routine takes a variable number of arguments to pass them to the "system"
 * library routine.
 */

void 
runcmd(va_alist)
va_dcl
{
	va_list args;
	char *fmt;
	char buf[512];

	va_start(args);
	fmt = va_arg(args, char *);
	va_end(args);
	vsprintf(buf, fmt, args);
	system(buf);
	return;
}

