/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1988, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)libc-port:fmt/_idoprnt.c	1.12"
/*LINTLIBRARY*/

#include "synonyms.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <values.h>
#ifdef __STDC__
#   include <stdarg.h>
#   include <float.h>
#   include <limits.h>
#else /* use some approximations instead */
#   include <varargs.h>
#   define CHAR_BIT	BITSPERBYTE
#   define SHRT_MAX	0x7fff			/* have to guess: 16 bits? */
#   define SHRT_MIN	(~0x7fff)		/* assuming 2's complement */
#   define LONG_MIN	((long)~(~(Ulong)0 >> 1)) /* ibid */
#   define DBL_MANT_DIG	DSIGNIF
#   define LDBL_MANT_DIG LDSIGNIF
#   define DBL_DIG	(DSIGNIF / 3)		/* 3+ binary digits/decimal */
#   define LDBL_DIG	(LDSIGNIF / 3)		/* 3+ binary digits/decimal */
#endif
#include <locale.h>
#include "_locale.h"
#include "stdiom.h"
#include "format.h"
#include "qstr.h"

#ifdef WIDE
#   ifdef ALLWIDE
#	define FCNNAME	_iwsdoprnt
#   else
#	define FCNNAME	_iwdoprnt
#   endif
#   define PARGLIST	_wparglist
#   define UCHAR	wuchar_t
#   define CHAR		wchar_t
#   define ISDIGIT(c)	('0' <= (c) && (c) <= '9')
#else
#   define FCNNAME	_idoprnt
#   define PARGLIST	_parglist
#   define UCHAR	Uchar
#   define CHAR		char
#   define ISDIGIT(c)	isdigit(c)
#endif

#ifndef NO_MSE /* make sure there's room for at least one multibyte character */
#   define WORKSIZE	(NDIG_MAX < MB_LEN_MAX ? MB_LEN_MAX : NDIG_MAX)
#else
#   define WORKSIZE	NDIG_MAX
#endif

#define F_DOT		0x0001	/* '.' */
#define F_CAPS		0x0002	/* capitolized format character */
#define F_HALF		0x0004	/* 'h' */
#define F_LONG		0x0008	/* 'l' */
#define F_LDBL		0x0010	/* 'L' or 'll' */
#define F_SHARP		0x0020	/* '#' */
#define F_PLUS		0x0040	/* '+' */
#define F_BLANK		0x0080	/* ' ' */
#define F_QUOTE		0x0100	/* '\'' */
#define F_DASH		0x0200	/* '-' */
#define F_ZERO		0x0400	/* '0' as flag */
#define F_BEFORE	0x0800	/* something before beg...end */
#define F_AFTER		0x1000	/* something after beg...end */

typedef struct	/* locals shared between _i[w[s]]doprnt and other functions */
{
	BFILE		*bp;		/* the stream; strings provide fake */
	Uchar		*curptr;	/* output placed here */
	Uchar		*beg;		/* start of main generated bytes */
	Uchar		*end;		/* one past main generated bytes */
	Uchar		*radix;		/* points at radix, if appropriate */
	const Uchar	*prefix;	/* bytes before main generated ones */
	const Uchar	*suffix;	/* bytes after main generated ones */
	const Uchar	*grp;		/* location in grouping string */
#if defined(WIDE) || !defined(NO_MSE)
	const wchar_t	*wp;		/* start of provided wide string */
	wint_t		wc;		/* local wide character */
#endif
	size_t		nprefix;	/* length of prefix (none if 0) */
	size_t		nsuffix;	/* length of suffix (none if 0) */
	size_t		nsuf0;		/* length of zero-padding for suffix */
	size_t		nleft0;		/* number of zeros before main bytes */
	size_t		nright0;	/* number of zeros after main bytes */
	size_t		width;		/* minimum conversion length */
	size_t		prec;		/* precision, valid iff F_DOT */
	Uint		flags;		/* status about current conversion */
	int		roomleft;	/* space left before flush */
	int		total;		/* total generated bytes/characters */
	int		ngrp;		/* number of digits in current group */
	Uchar		buf[WORKSIZE];	/* space for main generated bytes */
	Uchar		suf[NDIG_MAX];	/* variable suffixes built here */
} Prnt;

static const Uchar blanks[32] = "                                "; /*must have*/
static const Uchar zero_s[32] = "00000000000000000000000000000000"; /*same len.*/
static const Uchar uc2pre[2] = "0B";
static const Uchar lc2pre[2] = "0b";
static const Uchar uc_b0x[3] = " 0X";
static const Uchar lc_b0x[3] = " 0x";
static const Uchar uc_m0x[3] = "-0X";
static const Uchar lc_m0x[3] = "-0x";
static const Uchar uc_p0x[3] = "+0X";
static const Uchar lc_p0x[3] = "+0x";

#ifdef ALLWIDE	/* must be from *swprintf: result is a wide character string */

	/*
	* PUTW and doputw: copy len wide characters from src to the buffer.
	*/
#define PUTW(src, len, prp) \
do { \
	if (((prp)->roomleft -= (len)) < 0) \
	{ \
		if (doputw(src, len, prp) != 0) \
			return EOF; \
	} \
	else \
	{ \
		(prp)->curptr = _qcpy((void *)(prp)->curptr, \
			(const void *)(src), (len) * sizeof(wchar_t)); \
		(prp)->total += (len); \
	} \
} while (0)

static int
#ifdef __STDC__
doputw(const wuchar_t *src, int len, register Prnt *prp)
#else
doputw(src, len, prp)const wuchar_t *src; int len; register Prnt *prp;
#endif
{
	size_t room = (prp->bp->endptr - prp->curptr) / sizeof(wchar_t);
	int ret = 0;

	if (room < len)
	{
		len = room;
		ret = EOF;
	}
	else if ((room -= len) > INT_MAX)
		room = INT_MAX;
	prp->roomleft = room;
	prp->curptr = _qcpy((void *)prp->curptr, (const void *)src,
		len * sizeof(wchar_t));
	prp->total += len;
	return ret;
}

	/*
	* PUTB and doputb: copy and widen len bytes from src to the buffer.
	*/
#define PUTB(src, len, prp) \
do { \
	int nn = (len); \
\
	if (((prp)->roomleft -= nn) < 0) \
	{ \
		if (doputb(src, nn, prp) != 0) \
			return EOF; \
	} \
	else \
	{ \
		const Uchar *pp = (src); \
\
		(prp)->total += nn; \
		while (--nn >= 0) \
		{ \
			*(wchar_t *)(prp)->curptr = *pp++; \
			(prp)->curptr += sizeof(wchar_t); \
		} \
	} \
} while (0)

static int
#ifdef __STDC__
doputb(const Uchar *src, register int len, register Prnt *prp)
#else
doputb(src, len, prp)const Uchar *src; register int len; register Prnt *prp;
#endif
{
	register Uchar *cp = prp->curptr;
	size_t room = (prp->bp->endptr - cp) / sizeof(wchar_t);
	int ret = 0;

	if (room < len)
	{
		len = room;
		ret = EOF;
	}
	else if ((room -= len) > INT_MAX)
		room = INT_MAX;
	prp->roomleft = room;
	prp->total += len;
	while (--len >= 0)
	{
		*(wchar_t *)cp = *src++;
		cp += sizeof(wchar_t);
	}
	prp->curptr = cp;
	return ret;
}

#else /*!ALLWIDE*/

	/*
	* PUTB and doputb: copy len bytes from src to the buffer.
	*/
#define PUTB(src, len, prp) \
do { \
	if (((prp)->roomleft -= (len)) < 0) \
	{ \
		if (doputb(src, len, prp) != 0) \
			return EOF; \
	} \
	else \
	{ \
		(prp)->curptr = _qcpy((void *)(prp)->curptr, \
			(const void *)(src), (size_t)(len)); \
		(prp)->total += (len); \
	} \
} while (0)

static int
#ifdef __STDC__
doputb(const Uchar *src, int len, register Prnt *prp)
#else
doputb(src, len, prp)const Uchar *src; int len; register Prnt *prp;
#endif
{
	register BFILE *bp = prp->bp;
	register Uchar *cp = prp->curptr;
	FILE *fp;
	int n;

	if (bp->fd < 0)	/* string-based: check against "true" upper bound */
	{
		n = 0;
		prp->roomleft = INT_MAX;
		if (bp->fd < -1)	/* actual upper bound */
		{
			size_t room = bp->endptr - cp;

			if (room < len)
			{
				len = room;
				n = EOF;
			}
			else if ((room -= len) < INT_MAX)
				prp->roomleft = room;
		}
		prp->curptr = _qcpy((void *)cp, (const void *)src, (size_t)len);
		prp->total += len;
		return n;
	}
	fp = (FILE *)bp->file._base;
	fp->_cnt -= cp - fp->_ptr;
	fp->_ptr = cp;
	BUFSYNC(fp, bp);
	if (cp > bp->begptr && _xflsbuf(bp) != 0)
	{
		if (fp->_flag & _IONBF)
			((FILE *)bp->next)->_flag |= _IOERR;
		return EOF;
	}
	prp->roomleft = n = bp->endptr - bp->begptr;
	if ((fp->_flag & (_IONBF | _IOLBF)) == 0)
		fp->_cnt = n;
	prp->total += len;
	if (n > len)	/* fits: use buffer */
	{
		prp->curptr = _qcpy((void *)bp->begptr,
			(const void *)src, (size_t)len);
		prp->roomleft -= len;
		return 0;
	}
	while ((n = write(bp->fd, (const void *)src, (size_t)len)) != len)
	{
		if (n <= 0)
		{
			fp->_flag |= _IOERR;
			if (fp->_flag & _IONBF)
				((FILE *)bp->next)->_flag |= _IOERR;
			return EOF;
		}
		src += n;
		len -= n;
	}
	prp->curptr = bp->begptr;	/* == fp->_ptr */
	return 0;
}

#endif /*ALLWIDE*/

	/*
	* PADB: append len pad bytes from src to the buffer,
	*	limited to sizeof(blanks) per copy.
	*/
#define PADB(src, len, prp) \
do { \
	size_t pdsz = sizeof(blanks), pdn = (len); \
\
	do { \
		if (pdsz > pdn) \
			pdsz = pdn; \
		PUTB(src, (int)pdsz, prp); \
	} while ((pdn -= pdsz) != 0); \
} while (0)

static int
#ifdef __STDC__
revgrp(register Prnt *prp)
#else
revgrp(prp)register Prnt *prp;
#endif
{
	Uchar buf[4 * NDIG_MAX];
	register Uchar *p;
	size_t sz;
	int ret;

	p = &buf[sizeof(buf)];
	for (;;)
	{
		if (p <= &buf[1])	/* need room for at least two */
		{
			ret = revgrp(prp);
			break;
		}
		/*
		* Drop next byte into buf[] (in reverse order).
		*/
		if (prp->nright0 != 0)
		{
			prp->nright0--;
			*--p = '0';
		}
		else if (prp->radix > prp->beg)
		{
			*--p = *--prp->radix;
		}
		else if (prp->nleft0 != 0)
		{
			prp->nleft0--;
			*--p = '0';
		}
		else /* no more "real" digits to emit */
		{
			if (prp->width <= prp->nprefix)
				prp->width = 0;
			else
			{
				prp->width -= prp->nprefix;
				if (prp->flags & F_DASH)
					prp->flags |= F_AFTER;
				else if ((prp->flags & F_ZERO) == 0)
				{
					PADB(blanks, prp->width, prp);
					prp->width = 0;
				}
			}
			if (prp->nprefix != 0)
				PUTB(prp->prefix, (int)prp->nprefix, prp);
			if (prp->width != 0
				&& (prp->flags & (F_DASH | F_ZERO)) == F_ZERO)
			{
				/*
				* XPG4 says that these zeros aren't digits--at
				* least with respect to grouping.  Whatever...
				*/
				PADB(zero_s, prp->width, prp);
				prp->width = 0;
			}
			ret = 0;
			break;
		}
		if (prp->width != 0)
			prp->width--;
		/*
		* See if a separator was desired just before the above digit.
		*/
		if (prp->ngrp == 0)
		{
			if (prp->width != 0)
				prp->width--;
			p[-1] = p[0];
			*p-- = _numeric[1];
			if ((prp->ngrp = *++prp->grp) == 0)
			{
				prp->ngrp = *--prp->grp; /* repeat previous */
			}
			else if (prp->ngrp >= CHAR_MAX)
			{
				prp->ngrp = INT_MAX;
				prp->grp--;	/* just in case */
			}
		}
		prp->ngrp--;
	}
	if ((sz = &buf[sizeof(buf)] - p) != 0)
		PUTB(p, (int)sz, prp);
	return ret;
}

static int
#ifdef __STDC__
dogroup(register Prnt *prp)
#else
dogroup(prp)register Prnt *prp;
#endif
{
	int ret;

	/*
	* Sprinkle grouping separators throughout the nonfractional
	* portion of a decimal digit sequence.  revgrp() handles all
	* output down to just before the radix.
	*/
	if (prp->width > prp->nsuffix)
		prp->width -= prp->nsuffix;
	else
		prp->width = 0;
	if (prp->radix == 0)	/* %f with the radix at prp->suf[0] */
	{
		prp->radix = prp->end;
		ret = revgrp(prp);
	}
	else /* prp->radix is at or before prp->end */
	{
		size_t sz0 = prp->nright0;
		int szr = prp->end - prp->radix;

		if (prp->width > sz0 + szr)
			prp->width -= sz0 + szr;
		else
			prp->width = 0;
		prp->nright0 = 0;
		ret = revgrp(prp);
		prp->nright0 = sz0;
		if (szr != 0)
			PUTB(&prp->end[-szr], szr, prp);
	}
	return ret;
}

#if (defined(WIDE) || !defined(NO_MSE)) && !defined(ALLWIDE)

static int
#ifdef __STDC__
dowcs(register Prnt *prp, size_t max)
#else
dowcs(prp, max)register Prnt *prp; size_t max;
#endif
{
	size_t n, tot;

	/*
	* Determine number of bytes to be generated if limited by the
	* count of wide characters (max != 0) or if left-padding is
	* possible.  If max == 0, then the incoming prp->prec limits
	* the number of bytes to produce.  Include 0-padding to match
	* the regular 's' and 'c' behavior.
	*/
	if (max != 0)
		prp->prec = _wssize(prp->wp, ~(size_t)0, max);
	if (prp->width != 0 && (prp->flags & F_DASH) == 0)
	{
		if (max == 0)
			prp->prec = _wssize(prp->wp, prp->prec, ~(size_t)0);
		if (prp->width > prp->prec)
		{
			const Uchar *padptr = blanks;

			if (prp->flags & F_ZERO)
				padptr = zero_s;
			n = prp->width - prp->prec;
			PADB(padptr, n, prp);
			prp->width = 0;
		}
	}
	/*
	* Convert wide characters pointed to by prp->wp into multibyte
	* characters in the buffer.  PUTB bypassed unless buffer might
	* not hold enough, to reduce the amount of copying.  Stop either
	* when more than prp->prec bytes would be produced or the wide
	* string ends.
	*/
	tot = 0;
	do
	{
		if ((n = prp->roomleft) < MB_LEN_MAX)	/* use buffer */
		{
			if (n >= prp->prec)	/* direct still okay */
				goto trunc;
			if ((n = sizeof(prp->buf)) > prp->prec)
				n = prp->prec;
			n = _iwcstombs((char *)&prp->buf[0], &prp->wp, n);
			if (n == 0)
				break;
			PUTB(prp->buf, (int)n, prp);
		}
		else /* convert directly into stream buffer */
		{
			if (n > prp->prec)
			{
			trunc:;
				n = prp->prec;
			}
			n = _iwcstombs((char *)prp->curptr, &prp->wp, n);
			if (n == 0)
				break;
			prp->roomleft -= n;
			prp->curptr += n;
			prp->total += n;
		}
		tot += n;
	} while (prp->wp != 0 && (prp->prec -= n) != 0);
	/*
	* Finally, do any right-padding.
	*/
	if (prp->width > tot)
	{
		n = prp->width - tot;
		PADB(blanks, n, prp);
	}
	return 0;
}

#endif /*(defined(WIDE) || !defined(NO_MSE)) && !defined(ALLWIDE)*/

#define NARGS	30	/* cache positions of this many arguments */

int
#ifdef __STDC__
FCNNAME(FILE *fp, const CHAR *orig_fmt, va_list ap)
#else
FCNNAME(fp, orig_fmt, ap)FILE *fp; const CHAR *orig_fmt; va_list ap;
#endif
{
	RA_va_list arglist[NARGS];	/* cached arg positions */
	RA_va_list curpos;		/* current va_list position */
	RA_va_list star_curpos;		/* saved curpos (see pos_star_flag) */
	int pos_arg_flag;		/* any positional arguments so far? */
	int pos_star_flag;		/* in a positional width/precision? */
	Prnt pr;			/* all shared locals */
	const UCHAR *fmt;		/* walks through format string */
	const UCHAR *regfmt;		/* start of regular chars in fmt */
	int regular;			/* set while not in conversion spec. */

	pr.bp = (BFILE *)fp->_base;
	pr.curptr = fp->_ptr;
	if ((pr.roomleft = fp->_cnt) <= 0)
		pr.roomleft = (pr.bp->endptr - pr.curptr) / sizeof(CHAR);
	fmt = (const UCHAR *)orig_fmt;
	curpos = *(RA_va_list *)&ap;
	pos_arg_flag = 1;
	pos_star_flag = 0;
	pr.total = 0;
	/*
	* Walk through format.  Each lone % begins a specification.
	* Multibyte format strings are examined byte by byte and a
	* % byte is assumed not to be part of a multibyte character.
	*/
	regular = 1;
	regfmt = fmt;
	for (;; fmt++)
	{
	again:;
		switch (*fmt)
		{
		default:
		regchar:;
			/*
			* Skip past regular characters (not % or \0).
			*/
			do
			{
				if (*++fmt == '%')
					goto percent;
			} while (*fmt != '\0');
			/*FALLTHROUGH*/
		case '\0':		/* end of format */
		{
			register int n;

			if ((n = fmt - regfmt) != 0)
			{
#ifdef WIDE
#ifdef ALLWIDE
				PUTW(regfmt, n, &pr);
#else
				pr.width = 0;
				pr.wp = (const wchar_t *)regfmt;
				if (dowcs(&pr, (size_t)n) != 0)
					return EOF;
#endif
#else /*!WIDE*/
				PUTB(regfmt, n, &pr);
#endif /*WIDE*/
			}
			if ((n = pr.curptr - fp->_ptr) == 0)
				return pr.total;
			fp->_cnt -= n;
			fp->_ptr = pr.curptr;
#ifndef ALLWIDE
			if (fp->_flag & (_IONBF | _IOLBF))
			{
				if (fp->_flag & _IONBF)
				{
					if (_xflsbuf(pr.bp) != 0)
					{
						((FILE *)pr.bp->next)->_flag
							|= _IOERR;
						pr.total = EOF;
					}
				}
				else if (memchr((void *)&pr.curptr[-n], '\n',
					(size_t)n) != 0)
				{
					if (_xflsbuf(pr.bp) != 0)
						pr.total = EOF;
				}
			}
#endif
			return pr.total;
		case '%':
			if (!regular)	/* %% specification */
			{
				pr.buf[0] = '%';
				goto onebyte;
			}
		percent:;
			if ((n = fmt - regfmt) != 0)
			{
#ifdef WIDE
#ifdef ALLWIDE
				PUTW(regfmt, n, &pr);
#else
				pr.width = 0;
				pr.wp = (const wchar_t *)regfmt;
				if (dowcs(&pr, (size_t)n) != 0)
					return EOF;
#endif
#else /*!WIDE*/
				PUTB(regfmt, n, &pr);
#endif /*WIDE*/
			}
			regular = 0;
			regfmt = fmt;
			pr.flags = 0;
			pr.width = 0;
			pr.nprefix = 0;
			pr.nsuffix = 0;
			pr.nleft0 = 0;
			pr.nright0 = 0;
			continue;
		}
		case '.':
			pr.flags |= F_DOT;
			pr.prec = 0;
			continue;
		case 'h':
			pr.flags |= F_HALF;
			continue;
		case 'l':
#ifndef NO_LONG_LONG_EMULATE
			if (pr.flags & F_LONG)
				pr.flags |= F_LDBL;
#endif
			pr.flags |= F_LONG;
			continue;
		case 'L':
#ifndef NO_LONG_LONG_EMULATE
			pr.flags |= F_LDBL | F_LONG;
#else
			pr.flags |= F_LDBL;
#endif
			continue;
		case '#':
			pr.flags |= F_SHARP;
			continue;
		case '+':
			pr.flags |= F_PLUS;
			continue;
		case ' ':
			pr.flags |= F_BLANK;
			continue;
		case '\'':
			pr.flags |= F_QUOTE;
			continue;
		case '-':
			pr.flags |= F_DASH;
			pr.flags &= ~F_ZERO;
			continue;
		case '0':
			if ((pr.flags & (F_DOT | F_DASH)) == 0)
				pr.flags |= F_ZERO;
			continue;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		{
			register Uint n = *fmt - '0';

			while (++fmt, ISDIGIT(*fmt)) /* ignores overflows */
			{
				n *= 10;
				n += *fmt - '0';
			}
			if (pr.flags & F_DOT)
				pr.prec = n;
			else
				pr.width = n;
			goto again;
		}
		case '*':
		{
			register int n;

			if (regular)
				goto regchar;
			if (ISDIGIT(fmt[1]))	/* positional width/prec */
			{
				pos_star_flag = 1;
				star_curpos = curpos;
				continue;
			}
			n = va_arg(curpos.ap, int);
		star_set:;
			if (pr.flags & F_DOT)
			{
				if (n < 0)
					pr.flags &= ~F_DOT;
				else
					pr.prec = n;
			}
			else if (n < 0)
			{
				pr.flags ^= F_DASH;
				pr.width = -n;
			}
			else
				pr.width = n;
			continue;
		case '$':
			if (regular)
				goto regchar;
			if (pos_arg_flag)	/* first time */
			{
				pos_arg_flag = 0;
				arglist[0] = *(RA_va_list *)&ap;
				PARGLIST(orig_fmt, arglist, NARGS, 0, 0);
			}
			if (pr.flags & F_DOT)
			{
				if (!pos_star_flag)	/* bogus $ spec. */
					continue;
				n = pr.prec;
			}
			else
			{
				n = pr.width;
				pr.width = 0;
			}
			if (n > NARGS)
			{
				curpos = arglist[NARGS - 1];
				PARGLIST(orig_fmt, &curpos, NARGS, n, 0);
			}
			else
			{
				if (--n < 0)
					n = 0;
				curpos = arglist[n];
			}
			if (pos_star_flag)
			{
				pos_star_flag = 0;
				n = va_arg(curpos.ap, int);
				curpos = star_curpos;
				goto star_set;
			}
			pr.flags &= ~F_ZERO;
			continue;
		}
		case 'n':
			if (regular)
				goto regchar;
			/*CONSTANTCONDITION*/
			if (sizeof(short) == sizeof(long)) /*==sizeof(int)*/
			{
				*va_arg(curpos.ap, int *) = pr.total;
			}
			/*CONSTANTCONDITION*/
			else if (sizeof(int) == sizeof(long))
			{
				if (pr.flags & F_HALF)
					*va_arg(curpos.ap, short *) = pr.total;
				else
					*va_arg(curpos.ap, long *) = pr.total;
			}
			/*CONSTANTCONDITION*/
			else if (sizeof(short) == sizeof(int))
			{
				if (pr.flags & F_LONG)
					*va_arg(curpos.ap, long *) = pr.total;
				else
					*va_arg(curpos.ap, short *) = pr.total;
			}
			else if (pr.flags & (F_LONG | F_HALF))
			{
				if (pr.flags & F_HALF)
					*va_arg(curpos.ap, short *) = pr.total;
				else
					*va_arg(curpos.ap, long *) = pr.total;
			}
			else
				*va_arg(curpos.ap, int *) = pr.total;
			goto done;
		onebyte:;
			pr.beg = &pr.buf[0];
			pr.end = &pr.buf[1];
			break;
		case 'c':
			if (regular)
				goto regchar;
#if defined(WIDE) || !defined(NO_MSE)
			if (pr.flags & F_LONG)
				goto C_fmt;
#endif
#ifdef WIDE
			pr.wc = btowc(va_arg(curpos.ap, int));
			goto onewc;
#else /*!WIDE*/
			pr.buf[0] = va_arg(curpos.ap, int);
			goto onebyte;
#endif /*WIDE*/
		case 's':
			if (regular)
				goto regchar;
#if defined(WIDE) || !defined(NO_MSE)
			if (pr.flags & F_LONG)
				goto S_fmt;
#endif
			pr.beg = (Uchar *)va_arg(curpos.ap, char *);
#ifdef WIDE
			if ((pr.flags & F_DOT) == 0)
				pr.prec = ~(size_t)0;
			pr.end = pr.beg + _mbsize(pr.beg, &pr.prec);
#ifdef ALLWIDE
			/*
			* This is the only place in which general multibyte
			* characters are being converted to wide characters.
			*/
			if (pr.width != 0 && (pr.flags & F_DASH) == 0)
			{
				if (pr.width > pr.prec)
				{
					const Uchar *padptr = blanks;

					if (pr.flags & F_ZERO)
						padptr = zero_s;
					pr.width -= pr.prec;
					PADB(padptr, pr.width, &pr);
					pr.width = 0;
				}
			}
			/*
			* Can do everything in a single conversion, but
			* we still have all the bookkeeping to do.  The
			* following is essentially doputw() with the
			* copy instead a conversion.
			*/
			{
				size_t room = (pr.bp->endptr - pr.curptr)
						/ sizeof(wchar_t);
				int toomuch = 0;

				if (room < pr.prec)
				{
					pr.prec = room;
					toomuch = 1;
				}
				_xmbstowcs((wchar_t *)pr.curptr,
					(const char **)&pr.beg, pr.prec);
				if ((room -= pr.prec) > INT_MAX)
					room = INT_MAX;
				pr.roomleft = room;
				pr.curptr += pr.prec * sizeof(wchar_t);
				pr.total += pr.prec;
				if (toomuch)
					return EOF;
			}
			if (pr.width > pr.prec)	/* F_DASH must be set */
			{
				pr.width -= pr.prec;
				PADB(blanks, pr.width, &pr);
			}
			goto done;
#endif /*ALLWIDE*/
#else /*!WIDE*/
#ifdef STREND
			if ((pr.flags & F_DOT) == 0)
				pr.prec = ~(size_t)0;
			pr.end = (Uchar *)STREND((char *)pr.beg, pr.prec);
#else /*!STREND*/
			if (pr.flags & F_DOT)
			{
				if ((pr.end = (Uchar *)memchr((void *)pr.beg,
					'\0', pr.prec)) == 0)
				{
					pr.end = pr.beg + pr.prec;
				}
			}
			else
				pr.end = pr.beg + strlen((char *)pr.beg);
#endif /*STREND*/
#endif /*WIDE*/
			break;
#if defined(WIDE) || !defined(NO_MSE)
		case 'C':
		{
			int n;

			if (regular)
				goto regchar;
		C_fmt:;
			/*CONSTANTCONDITION*/
			if (sizeof(wint_t) < sizeof(int))
				pr.wc = va_arg(curpos.ap, int);
			else
				pr.wc = va_arg(curpos.ap, wint_t);
		onewc:;
			if (pr.wc == 0)	/* null wide character special */
			{
				pr.buf[0] = '\0';
				goto onebyte;
			}
#ifdef ALLWIDE
			pr.prec = 1;
			pr.wp = (wchar_t *)&pr.wc;
			goto fmtwcs;
#else /*!ALLWIDE*/
			if ((n = wctomb((char *)&pr.buf[0], pr.wc)) < 0)
				n = 0;
			pr.beg = &pr.buf[0];
			pr.end = &pr.buf[n];
			break;
#endif /*ALLWIDE*/
		case 'S':
			if (regular)
				goto regchar;
		S_fmt:;
			pr.wp = va_arg(curpos.ap, wchar_t *);
			if ((pr.flags & F_DOT) == 0)
				pr.prec = ~(size_t)0;
#ifdef WIDE
#ifdef ALLWIDE
			/*
			* Still have to handle entirely here because the
			* common PUTB will widen each byte of the input
			* string to wide characters.
			* First, determine how many wide characters to copy.
			*/
#ifdef WCSEND
			pr.prec = WCSEND(pr.wp, pr.prec) - pr.wp;
#else /*!WCSEND*/
			{
				register wchar_t *p = pr.wp;
				size_t cnt;

				for (cnt = pr.prec; cnt != 0; cnt--)
				{
					if (*p++ == 0)
					{
						pr.prec -= cnt;
						break;
					}
				}
			}
#endif /*WCSEND*/
		fmtwcs:;
			if (pr.width != 0 && (pr.flags & F_DASH) == 0)
			{
				if (pr.width > pr.prec)
				{
					const Uchar *padptr = blanks;

					if (pr.flags & F_ZERO)
						padptr = zero_s;
					pr.width -= pr.prec;
					PADB(padptr, pr.width, &pr);
					pr.width = 0;
				}
			}
			PUTW((wuchar_t *)pr.wp, pr.prec, &pr);
			if (pr.width > pr.prec)	/* F_DASH must be set */
			{
				pr.width -= pr.prec;
				PADB(blanks, pr.width, &pr);
			}
#else /*!ALLWIDE*/
			if (pr.prec == 0)
			{
				pr.end = pr.beg = &pr.buf[0];
				break;
			}
			if (dowcs(&pr, pr.prec) != 0)
				return EOF;
#endif /*ALLWIDE*/
#else /*!WIDE*/
			if (dowcs(&pr, (size_t)0) != 0)
				return EOF;
#endif /*WIDE*/
			goto done;
		}
#endif /*defined(WIDE) || !defined(NO_MSE)*/
		case 'd':
		case 'i':
		{
			register Ulong ul;
			register Uchar *p;
#ifndef NO_LONG_LONG_EMULATE
			union {
				Ulong	ul;
				long	l;
			} val, val2;
#else
			union {
				Ulong	ul;
				long	l;
			} val;
#endif

			if (regular)
				goto regchar;
			/*CONSTANTCONDITION*/
			if (sizeof(short) == sizeof(long)) /*==sizeof(int)*/
			{
				val.l = va_arg(curpos.ap, int);
			}
			/*CONSTANTCONDITION*/
			else if (sizeof(int) == sizeof(long))
			{
				val.l = va_arg(curpos.ap, int);
				if (pr.flags & F_HALF)
					val.l = (short)val.l;
			}
			/*CONSTANTCONDITION*/
			else if (sizeof(short) == sizeof(int))
			{
				if (pr.flags & F_LONG)
					val.l = va_arg(curpos.ap, long);
				else
					val.l = va_arg(curpos.ap, int);
			}
			else if (pr.flags & (F_LONG | F_HALF))
			{
				if (pr.flags & F_HALF)
					val.l = (short)va_arg(curpos.ap, int);
				else
					val.l = va_arg(curpos.ap, long);
			}
			else
				val.l = va_arg(curpos.ap, int);
#ifndef NO_LONG_LONG_EMULATE
			if (pr.flags & F_LDBL)
			{
				val2.l = va_arg(curpos.ap, long);
				if (_ullabs(&val.ul, &val2.ul))
				{
					pr.prefix = lc_m0x;
					pr.nprefix = 1;
				}
				else if (pr.flags & (F_PLUS | F_BLANK))
				{
					if ((pr.flags & F_PLUS) == 0)
						pr.prefix = blanks;
					else
						pr.prefix = lc_p0x;
					pr.nprefix = 1;
				}
			lldecimal:;
				pr.end = p = &pr.buf[sizeof(pr.buf)];
				/*
				* This presumes that a big integer zero
				* can only occur when both halves are zero.
				*/
				if (val.l != 0 || val2.l != 0)
					p = _ulltos(p, val.ul, val2.ul);
				goto decfill;
			}
#endif /*NO_LONG_LONG_EMULATE*/
			if (val.l < 0)
			{
				pr.prefix = lc_m0x;
#if -SHRT_MAX > SHRT_MIN /* two's complement: don't negate most negative */
				if (val.l != LONG_MIN)
					val.l = -val.l;
#else
				val.l = -val.l;
#endif
				pr.nprefix = 1;
			}
			else if (pr.flags & (F_PLUS | F_BLANK))
			{
				if ((pr.flags & F_PLUS) == 0)
					pr.prefix = blanks;
				else
					pr.prefix = lc_p0x;
				pr.nprefix = 1;
			}
			ul = val.ul;	/* from other part of union */
		decimal:;
			pr.end = p = &pr.buf[sizeof(pr.buf)];
			if (ul != 0)
			{
#ifdef _ULTOS
				_ULTOS(p, ul);
#else
				p = _ultos(p, ul);
#endif
			}
		decfill:;
			if (pr.flags & F_DOT)
				pr.flags &= ~F_ZERO;
			else
				pr.prec = 1;
			if ((ul = &pr.buf[sizeof(pr.buf)] - p) < pr.prec)
			{
				ul = pr.prec - ul;
				if (ul > p - &pr.buf[0])
				{
					pr.flags |= F_BEFORE;
					pr.nleft0 = ul;
					goto decdone;
				}
				else	/* room to zero fill buf */
				{
					do
						*--p = '0';
					while (--ul != 0);
				}
			}
			if (pr.nprefix != 0)	/* try to eliminate it */
			{
				if (pr.flags & F_ZERO || p == &pr.buf[0])
					pr.flags |= F_BEFORE;
				else
				{
					*--p = *pr.prefix;
					pr.nprefix = 0;
				}
			}
		decdone:;
			pr.beg = p;
			if (pr.flags & F_QUOTE)
			{
				pr.radix = pr.end;
				goto quote;
			}
			break;
		case 'u':
			if (regular)
				goto regchar;
			/*CONSTANTCONDITION*/
			if (sizeof(Ushort) == sizeof(Ulong)) /*==sizeof(Uint)*/
			{
				ul = va_arg(curpos.ap, Uint);
			}
			/*CONSTANTCONDITION*/
			else if (sizeof(Uint) == sizeof(Ulong))
			{
				ul = va_arg(curpos.ap, Uint);
				if (pr.flags & F_HALF)
					ul = (Ushort)ul;
			}
			/*CONSTANTCONDITION*/
			else if (sizeof(Ushort) == sizeof(Uint))
			{
				if (pr.flags & F_LONG)
					ul = va_arg(curpos.ap, Ulong);
				else
					ul = va_arg(curpos.ap, Uint);
			}
			else if (pr.flags & (F_LONG | F_HALF))
			{
				if (pr.flags & F_HALF)
					ul = (Ushort)va_arg(curpos.ap, Uint);
				else
					ul = va_arg(curpos.ap, Ulong);
			}
			else
				ul = va_arg(curpos.ap, Uint);
#ifndef NO_LONG_LONG_EMULATE
			if (pr.flags & F_LDBL)
			{
				val.ul = ul;
				val2.ul = va_arg(curpos.ap, Ulong);
				goto lldecimal;
			}
#endif /*NO_LONG_LONG_EMULATE*/
			goto decimal;
		}
		case 'p':
		{
			register Uchar *p;
			register Ulong ul;
			register const Uchar *digs;
			int shift;
			Uint mask;

			if (regular)
				goto regchar;
			pr.prefix = &lc_b0x[1];
			shift = 4;
			mask = 0xf;
			digs = (const Uchar *)_str_lc_hex;
			ul = (Ulong)va_arg(curpos.ap, void *);
			goto num_pow2;
		case 'B':
			if (regular)
				goto regchar;
			pr.prefix = uc2pre;
			shift = 1;
			mask = 0x1;
			goto lc_pow2;
		case 'b':
			if (regular)
				goto regchar;
			pr.prefix = lc2pre;
			shift = 1;
			mask = 0x1;
			goto lc_pow2;
		case 'o':
			if (regular)
				goto regchar;
			shift = 3;
			mask = 0x7;
			goto lc_pow2;
		case 'X':
			if (regular)
				goto regchar;
			pr.prefix = &uc_b0x[1];
			shift = 4;
			mask = 0xf;
			digs = (const Uchar *)_str_uc_hex;
			goto get_pow2;
		case 'x':
			if (regular)
				goto regchar;
			pr.prefix = &lc_b0x[1];
			shift = 4;
			mask = 0xf;
		lc_pow2:;
			digs = (const Uchar *)_str_lc_hex;
		get_pow2:;
			/*CONSTANTCONDITION*/
			if (sizeof(Ushort) == sizeof(Ulong)) /*==sizeof(Uint)*/
			{
				ul = va_arg(curpos.ap, Uint);
			}
			/*CONSTANTCONDITION*/
			else if (sizeof(Uint) == sizeof(Ulong))
			{
				ul = va_arg(curpos.ap, Uint);
				if (pr.flags & F_HALF)
					ul = (Ushort)ul;
			}
			/*CONSTANTCONDITION*/
			else if (sizeof(Ushort) == sizeof(Uint))
			{
				if (pr.flags & F_LONG)
					ul = va_arg(curpos.ap, Ulong);
				else
					ul = va_arg(curpos.ap, Uint);
			}
			else if (pr.flags & (F_LONG | F_HALF))
			{
				if (pr.flags & F_HALF)
					ul = (Ushort)va_arg(curpos.ap, Uint);
				else
					ul = va_arg(curpos.ap, Ulong);
			}
			else
				ul = va_arg(curpos.ap, Uint);
#ifndef NO_LONG_LONG_EMULATE
			if (pr.flags & F_LDBL)
			{
				Ulong ul1, ul2; /* need addresses */

				ul1 = ul;
				ul2 = va_arg(curpos.ap, Ulong);
				pr.end = p = &pr.buf[sizeof(pr.buf)];
				while (ul1 != 0 || ul2 != 0)
				{
					ul = _ullrshift(shift, &ul1, &ul2);
					*--p = digs[ul & mask];
				}
				goto pow2fill;
			}
#endif /*NO_LONG_LONG_EMULATE*/
		num_pow2:;
			pr.end = p = &pr.buf[sizeof(pr.buf)];
			while (ul != 0)
			{
				*--p = digs[ul & mask];
				ul >>= shift;
			}
		pow2fill:;
			if (pr.flags & F_DOT)
				pr.flags &= ~F_ZERO;
			else
				pr.prec = 1;
			ul = &pr.buf[sizeof(pr.buf)] - p;
			if (pr.flags & F_SHARP && ul != 0)
			{
				if (shift == 3)	/* octal */
				{
					*--p = '0';
					ul++;
				}
				else
					pr.nprefix = 2;
			}
			if (ul < pr.prec)
			{
				ul = pr.prec - ul;
				if (ul > p - &pr.buf[0])
				{
					pr.flags |= F_BEFORE;
					pr.nleft0 = ul;
					pr.beg = p;
					break;
				}
				else	/* room to zero fill buf */
				{
					do
						*--p = '0';
					while (--ul != 0);
				}
			}
			if (pr.nprefix != 0)	/* try to eliminate it */
			{
				if (pr.flags & F_ZERO || p < &pr.buf[2])
					pr.flags |= F_BEFORE;
				else
				{
					*--p = pr.prefix[1];
					*--p = pr.prefix[0];
					pr.nprefix = 0;
				}
			}
			pr.beg = p;
			break;
		}
		/*
		* Floating formats.  All share the items
		* necessary for _cvt() and _cvtl().
		*/
		{
			Cvt cvt;
			register Uchar *p;

#ifndef NO_NCEG_FPE
		case 'A':
			pr.flags |= F_CAPS;
			/*FALLTHROUGH*/
		case 'a':
			if (regular)
				goto regchar;
			cvt.buf = &pr.buf[4];	/* room for sign, 0x and radix */
			if (pr.flags & F_CAPS)
				cvt.mode = CVT_A | CVT_CAPS;
			else
				cvt.mode = CVT_A;
			cvt.ndig = NDIG_HEX;
			if (pr.flags & F_DOT && pr.prec < NDIG_HEX)
				cvt.ndig = pr.prec + 1;
#ifndef NO_LONG_DOUBLE
			if (pr.flags & F_LDBL)
			{
				cvt.val.ld = va_arg(curpos.ap, long double);
				p = _cvtl(&cvt);
			}
			else
#endif
			{
				cvt.val.d = va_arg(curpos.ap, double);
				p = _cvt(&cvt);
			}
#ifdef _IEEE
			if (p == 0)	/* NaN or Infinity */
			{
				pr.beg = cvt.buf;
				pr.end = pr.beg + cvt.len; /* always has room */
				goto infnansign;
			}
#endif
			/*
			* "A" format has, in effect, two prefixes.  Try to
			* keep the "0x" with the digits, but this fails if
			* we need to fill on the left with zeros.  In this
			* case, choose the right combination prefix.
			*/
			if (pr.flags & F_ZERO)
			{
				pr.beg = p - 1;		/* room only for radix */
				pr.flags |= F_BEFORE;
				if (cvt.sign)
				{
					if (pr.flags & F_CAPS)
						pr.prefix = uc_m0x;
					else
						pr.prefix = lc_m0x;
					pr.nprefix = 3;
				}
				else if (pr.flags & (F_PLUS | F_BLANK))
				{
					if ((pr.flags & F_PLUS) == 0)
					{
						if (pr.flags & F_CAPS)
							pr.prefix = uc_b0x;
						else
							pr.prefix = lc_b0x;
					}
					else if (pr.flags & F_CAPS)
						pr.prefix = uc_p0x;
					else
						pr.prefix = lc_p0x;
					pr.nprefix = 3;
				}
				else
				{
					if (pr.flags & F_CAPS)
						pr.prefix = &uc_b0x[1];
					else
						pr.prefix = &lc_b0x[1];
					pr.nprefix = 2;
				}
			}
			else /* room to insert [prefix]"0x" here */
			{
				pr.beg = p - 3;
				if (pr.flags & F_CAPS)
					p[-2] = 'X';
				else
					p[-2] = 'x';
				p[-3] = '0';
				if (cvt.sign)
				{
					*--pr.beg = '-';
				}
				else if (pr.flags & (F_PLUS | F_BLANK))
				{
					if ((pr.flags & F_PLUS) == 0)
						*--pr.beg = ' ';
					else
						*--pr.beg = '+';
				}
			}
			/*
			* Insert binary radix after first digit.
			*/
			p[-1] = p[0];
			p[0] = _numeric[0];
			/*
			* Determine the digits to keep in the result.
			* Leave p pointing at the last byte.
			*/
			cvt.len--;
			if ((pr.flags & F_DOT) == 0)	/* keep all digits */
			{
				p += cvt.len;
			}
			else if (pr.prec > cvt.len)	/* zeros after digits */
			{
				p += cvt.len;
				if ((pr.nright0 = pr.prec - cvt.len) >
					&pr.buf[sizeof(pr.buf)] - p)
				{
					pr.flags |= F_AFTER;
				}
				else	/* zero fill buf */
				{
					do
						*++p = '0';
					while (--pr.nright0 != 0);
				}
			}
			else if (pr.prec != 0)
			{
				p += pr.prec;	/* already rounded */
			}
			else if ((pr.flags & F_SHARP) == 0)
			{
				p--;	/* toss radix */
			}
			/*
			* Create binary exponent in pr.suf[].  If it and "p+"
			* will fit in pr.buf[] after the main digits, append
			* to the single buffer.
			*/
			{
				register Uchar *cp;
				register int n;

				if ((n = cvt.decpt) < 0)
					n = -n;
				cp = &pr.suf[sizeof(pr.suf)];
#ifdef _ULTOS
				_ULTOS(cp, n);
#else
				cp = _ultos(cp, n);
#endif
				/*
				* Can it be packed into one buffer?
				*/
				if ((n = &pr.suf[sizeof(pr.suf)] - cp) >=
					&pr.buf[sizeof(pr.buf) - 2] - p
					|| pr.nright0 != 0)
				{
					cp -= 2;
					pr.suffix = cp;
					pr.nsuffix = n + 2;
					pr.flags |= F_AFTER;
					pr.nsuf0 = 0;
				}
				else
				{
					p += 2;
					do
						*++p = *cp;
					while (++cp < &pr.suf[sizeof(pr.suf)]);
					cp = p - (n + 1);
				}
				if (cvt.decpt < 0)
					cp[1] = '-';
				else
					cp[1] = '+';
				if (pr.flags & F_CAPS)
					cp[0] = 'P';
				else
					cp[0] = 'p';
			}
			pr.end = p + 1;
			break;
#endif /*NO_NCEG_FPE*/
		case 'E':
			pr.flags |= F_CAPS;
			/*FALLTHROUGH*/
		case 'e':
			if (regular)
				goto regchar;
			cvt.buf = &pr.buf[2];	/* room for sign and radix */
			if (pr.flags & F_CAPS)
				cvt.mode = CVT_E | CVT_CAPS;
			else
				cvt.mode = CVT_E;
			if (pr.flags & F_DOT)
			{
				if ((cvt.ndig = NDIG_DEC) > pr.prec)
					cvt.ndig = pr.prec + 1;
			}
			else
			{
				pr.prec = 6;
				cvt.ndig = 6 + 1;
			}
#ifndef NO_LONG_DOUBLE
			if (pr.flags & F_LDBL)
			{
				cvt.val.ld = va_arg(curpos.ap, long double);
				p = _cvtl(&cvt);
			}
			else
#endif
			{
				cvt.val.d = va_arg(curpos.ap, double);
				p = _cvt(&cvt);
			}
#ifdef _IEEE
			if (p == 0)	/* NaN or Infinity */
			{
			infnan:;
				pr.beg = cvt.buf;
				pr.end = pr.beg + cvt.len;
				if (cvt.decpt == CVT_INF && pr.prec < cvt.len
					&& pr.width < cvt.len)
				{
					pr.end = &pr.beg[3];	/* only "inf" */
				}
			infnansign:;
				if (pr.flags & F_ZERO)	/* separate prefix */
				{
					if (cvt.sign)
					{
						pr.prefix = lc_m0x;
						pr.nprefix = 1;
						pr.flags |= F_BEFORE;
					}
					else if (pr.flags & (F_PLUS | F_BLANK))
					{
						if ((pr.flags & F_PLUS) == 0)
							pr.prefix = blanks;
						else
							pr.prefix = lc_p0x;
						pr.nprefix = 1;
						pr.flags |= F_BEFORE;
					}
				}
				else if (cvt.sign)
				{
					*--pr.beg = '-';
				}
				else if (pr.flags & (F_PLUS | F_BLANK))
				{
					if ((pr.flags & F_PLUS) == 0)
						*--pr.beg = ' ';
					else
						*--pr.beg = '+';
				}
				break;
			}
#endif /*_IEEE*/
		e_fmt:;
			pr.beg = p - 1;
			if (pr.flags & F_ZERO)	/* prefix must be separate */
			{
				if (cvt.sign)
				{
					pr.prefix = lc_m0x;
					pr.nprefix = 1;
					pr.flags |= F_BEFORE;
				}
				else if (pr.flags & (F_PLUS | F_BLANK))
				{
					if ((pr.flags & F_PLUS) == 0)
						pr.prefix = blanks;
					else
						pr.prefix = lc_p0x;
					pr.nprefix = 1;
					pr.flags |= F_BEFORE;
				}
			}
			else if (cvt.sign)
			{
				*--pr.beg = '-';
			}
			else if (pr.flags & (F_PLUS | F_BLANK))
			{
				if ((pr.flags & F_PLUS) == 0)
					*--pr.beg = ' ';
				else
					*--pr.beg = '+';
			}
			/*
			* Insert decimal radix after first digit.
			* Leave p pointing at the last byte.  There
			* is always at least one digit available.
			*/
			p[-1] = p[0];
			p[0] = _numeric[0];
			if (pr.prec < cvt.len)	/* digits are sufficient */
			{
				if (pr.prec != 0)
					p += pr.prec;	/* already rounded */
				else if ((pr.flags & F_SHARP) == 0)
					p--;	/* toss radix */
			}
			else	/* zeros after digits */
			{
				p += --cvt.len;
				if ((pr.nright0 = pr.prec - cvt.len) >
					&pr.buf[sizeof(pr.buf)] - p)
				{
					pr.flags |= F_AFTER;
				}
				else	/* zero fill pr.buf[] now */
				{
					do
						*++p = '0';
					while (--pr.nright0 != 0);
				}
			}
			/*
			* Create exponent with at least 2 digits in suf.
			* If it and "e+" will fit in buf after the main
			* digits, append to the single buffer.
			*/
			{
				register Uchar *cp;
				register int n;

				if ((n = cvt.decpt - 1) < 0) /* radix at +1 */
					n = -n;
				cp = &pr.suf[sizeof(pr.suf)];
#ifdef _ULTOS
				_ULTOS(cp, n);
#else
				cp = _ultos(cp, n);
#endif
				if ((n = &pr.suf[sizeof(pr.suf)] - cp) == 1)
				{
					*--cp = '0';
					n = 2;
				}
				/*
				* Can it be packed into one buffer?
				*/
				if (n >= &pr.buf[sizeof(pr.buf) - 2] - p
					|| pr.nright0 != 0)
				{
					cp -= 2;
					pr.suffix = cp;
					pr.nsuffix = n + 2;
					pr.flags |= F_AFTER;
					pr.nsuf0 = 0;
				}
				else
				{
					p += 2;
					do
						*++p = *cp;
					while (++cp < &pr.suf[sizeof(pr.suf)]);
					cp = p - (n + 1);
				}
				if (cvt.decpt <= 0)
					cp[1] = '-';
				else
					cp[1] = '+';
				if (pr.flags & F_CAPS)
					cp[0] = 'E';
				else
					cp[0] = 'e';
			}
			pr.end = p + 1;
			break;
		case 'F':
			pr.flags |= F_CAPS;
			/*FALLTHROUGH*/
		case 'f':
			if (regular)
				goto regchar;
			cvt.buf = &pr.buf[2];	/* room for sign and radix */
			if (pr.flags & F_CAPS)
				cvt.mode = CVT_F | CVT_CAPS;
			else
				cvt.mode = CVT_F;
			if (pr.flags & F_DOT)
			{
				if ((cvt.ndig = NDIG_DEC) > pr.prec)
					cvt.ndig = pr.prec;
			}
			else
			{
				pr.prec = 6;
				cvt.ndig = 6;
			}
#ifndef NO_LONG_DOUBLE
			if (pr.flags & F_LDBL)
			{
				cvt.val.ld = va_arg(curpos.ap, long double);
				p = _cvtl(&cvt);
			}
			else
#endif
			{
				cvt.val.d = va_arg(curpos.ap, double);
				p = _cvt(&cvt);
			}
#ifdef _IEEE
			if (p == 0)	/* NaN or Infinity */
				goto infnan;
#endif
		f_fmt:;
			/*
			* F format is the most complex to handle.  The
			* problem is that there can be a great many zeros
			* at three separate places:
			*  1. Between the _cvt digits and the radix.
			*  2. Between the radix and the _cvt digits.
			*  3. After the _cvt digits, after the radix.
			* Whenever possible, the entire result is kept in
			* buf[], or through use of a regular suffix
			* and/or nright0.  However, when both 2 and 3 occur
			* in sufficient amounts, a special zero-padding
			* suffix is used which zero-fills on the right.
			*/
			if (cvt.decpt <= 0)	/* all digits right of radix */
			{
				/*
				* Begin buf[] with "[-]0.".
				* Move digits (if any) to the right
				* or into the suffix as appropriate.
				*/
				pr.beg = &pr.buf[1]; /* leave room for prefix */
				pr.buf[1] = '0';
				cvt.decpt = -cvt.decpt;
				if (pr.prec <= sizeof(pr.buf) - 3)
				{
					/*
					* Room for radix, 0s, digits, and 0s.
					*/
					pr.end = &pr.buf[3] + pr.prec;
					if (cvt.len == 0 || cvt.decpt >= pr.prec)
					{
						/*
						* All zero result.
						*/
						if (pr.prec != 0) /* zero fill */
						{
							p = &pr.buf[2];
							do
								*++p = '0';
							while (--pr.prec != 0);
						}
						else if (!(pr.flags & F_SHARP))
						{
							pr.end = &pr.buf[2];
						}
					}
					else /* decpt<prec, len != 0, w/digits */
					{
						register Uchar *cp;

						cp = &pr.buf[3] + cvt.decpt;
						pr.prec -= cvt.decpt;
						if (pr.prec < cvt.len)
							cvt.len = pr.prec;
						pr.prec -= cvt.len;
						/*
						* Adjust digits in buffer.
						* Then fill with zeros on the
						* left and right of the digits.
						*/
						if (cp < p) /* move forward */
						{
							do
								*cp++ = *p++;
							while (--cvt.len != 0);
						}
						else if (cp > p) /* move back */
						{
							cp += cvt.len;
							p += cvt.len;
							do
								*--cp = *--p;
							while (--cvt.len != 0);
						}
						if (cvt.decpt != 0) /* left 0s */
						{
							cp = &pr.buf[2];
							do
								*++cp = '0';
							while (--cvt.decpt != 0);
						}
						if (pr.prec != 0) /* right 0s */
						{
							cp = pr.end;
							do
								*--cp = '0';
							while (--pr.prec != 0);
						}
					}
				}
				else if (cvt.len == 0 || cvt.decpt >= pr.prec)
				{
					/*
					* All zeros, but too many for pr.buf[].
					*/
					pr.flags |= F_AFTER;
					pr.nright0 = pr.prec;
					pr.end = &pr.buf[3];
				}
				else /* decpt < prec, prec > buffer, w/digits */
				{
					register Uchar *cp = &pr.suf[0];

					pr.flags |= F_AFTER;
					pr.suffix = cp;
					pr.prec -= cvt.decpt;
					if ((pr.nsuffix = pr.prec) > cvt.len)
					{
						/*
						* Use special zero-padding suffix.
						*/
						pr.nsuf0 = pr.nsuffix - cvt.len;
						do
							*cp++ = *p++;
						while (--cvt.len != 0);
					}
					else /* enough digits for precision */
					{
						pr.nsuf0 = 0;
						do
							*cp++ = *p++;
						while (--pr.prec != 0);
					}
					if (cvt.decpt >= sizeof(pr.buf) - 2)
					{
						pr.nright0 = cvt.decpt;
						pr.end = &pr.buf[3];
					}
					else /* zero fill now */
					{
						p = &pr.buf[2];
						while (--cvt.decpt >= 0)
							*++p = '0';
						pr.end = p + 1;
					}
				}
				pr.buf[2] = _numeric[0];
				pr.radix = &pr.buf[2];	/* only for F_QUOTE */
			}
			else if (cvt.decpt >= cvt.len) /* all digits on left */
			{
				register size_t sz;

				pr.beg = p;
				p += cvt.len;
				cvt.decpt -= cvt.len;
				sz = &pr.buf[sizeof(pr.buf)] - p;
				if (cvt.decpt < sz) /* at least room for radix */
				{
					sz -= cvt.decpt;
					while (--cvt.decpt >= 0)
						*p++ = '0';
					p[0] = _numeric[0];
					pr.radix = p;	/* only for F_QUOTE */
					if (pr.prec == 0)
					{
						if ((pr.flags & F_SHARP) == 0)
							p--;	/* toss radix */
					}
					else if (pr.prec < sz) /* fraction, too */
					{
						do
							*++p = '0';
						while (--pr.prec != 0);
					}
					else /* not enough room for fraction */
					{
						pr.flags |= F_AFTER;
						pr.nright0 = pr.prec;
					}
					pr.end = p + 1;
				}
				else /* not enough room to reach radix */
				{
					pr.flags |= F_AFTER;
					pr.nright0 = cvt.decpt;
					pr.end = p;	/* entire _cvt result */
					pr.radix = 0;	/* only for F_QUOTE */
					pr.nsuffix = 1 + pr.prec;
					if (pr.prec == 0)
					{
						if (pr.flags & F_SHARP)
						{
							pr.nsuf0 = 0;
							pr.suffix =
							 (Uchar *)&_numeric[0];
						}
						else
							pr.nsuffix = 0;
					}
					else if (pr.prec < sizeof(pr.suf))
					{
						pr.nsuf0 = 0;
						pr.suffix = p = &pr.suf[0];
						p[0] = _numeric[0];
						do
							*++p = '0';
						while (--pr.prec != 0);
					}
					else /* too many zeros to fit */
					{
						/*
						* Use special zero-padding suffix.
						*/
						pr.nsuf0 = pr.prec;
						pr.suffix = (Uchar *)&_numeric[0];
					}
				}
			}
			else /* 0 < decpt < cvt.len: radix among digits */
			{
				if (pr.prec == 0)	/* no fraction digits */
				{
					pr.beg = p;
					p += cvt.decpt;
					if (pr.flags & F_SHARP)
						*p++ = _numeric[0];
					pr.end = p;
					pr.radix = p;	/* only for F_QUOTE */
				}
				else /* some fraction digits */
				{
					/*
					* Move digits one to the left
					* until reach radix.
					*/
					pr.beg = --p;
					cvt.len -= cvt.decpt;
					do
						p[0] = p[1];
					while (++p, --cvt.decpt != 0);
					p[0] = _numeric[0];
					pr.radix = p;	/* only for F_QUOTE */
					if (pr.prec <= cvt.len)
					{
						p += pr.prec; /* was rounded */
					}
					else if (&pr.buf[sizeof(pr.buf)] - p
						<= pr.prec)
					{
						p += cvt.len;
						pr.flags |= F_AFTER;
						pr.nright0 = pr.prec - cvt.len;
					}
					else /* zero fill now */
					{
						p += cvt.len;
						pr.prec -= cvt.len;
						do
							*++p = '0';
						while (--pr.prec != 0);
					}
					pr.end = p + 1;
				}
			}
			/*
			* Add on prefix, if any.
			*/
			if (pr.flags & F_ZERO)
			{
				if (cvt.sign)
				{
					pr.prefix = lc_m0x;
					pr.nprefix = 1;
					pr.flags |= F_BEFORE;
				}
				else if (pr.flags & (F_PLUS | F_BLANK))
				{
					if ((pr.flags & F_PLUS) == 0)
						pr.prefix = blanks;
					else
						pr.prefix = lc_p0x;
					pr.nprefix = 1;
					pr.flags |= F_BEFORE;
				}
			}
			else if (cvt.sign)
			{
				*--pr.beg = '-';
			}
			else if (pr.flags & (F_PLUS | F_BLANK))
			{
				if ((pr.flags & F_PLUS) == 0)
					*--pr.beg = ' ';
				else
					*--pr.beg = '+';
			}
			if (pr.flags & F_QUOTE)
				goto quote;
			break;
		case 'G':
			pr.flags |= F_CAPS;
			/*FALLTHROUGH*/
		case 'g':
			if (regular)
				goto regchar;
			cvt.buf = &pr.buf[2];	/* room for sign and radix */
			if (pr.flags & F_CAPS)
				cvt.mode = CVT_E | CVT_CAPS;
			else
				cvt.mode = CVT_E;
			if (pr.flags & F_DOT)
			{
				if ((cvt.ndig = NDIG_DEC) > pr.prec)
				{
					if (pr.prec == 0)
						pr.prec = 1;
					cvt.ndig = pr.prec;
				}
			}
			else
			{
				pr.prec = 6;
				cvt.ndig = 6;
			}
#ifndef NO_LONG_DOUBLE
			if (pr.flags & F_LDBL)
			{
				cvt.val.ld = va_arg(curpos.ap, long double);
				p = _cvtl(&cvt);
			}
			else
#endif
			{
				cvt.val.d = va_arg(curpos.ap, double);
				p = _cvt(&cvt);
			}
#ifdef _IEEE
			if (p == 0)
				goto infnan;
#endif
			{
				register size_t n = pr.prec;

				if ((pr.flags & F_SHARP) == 0)
				{
					if (cvt.len < n)
						n = cvt.len;
					do
					{
						if (p[n - 1] != '0')
							break;
					} while (--n != 0);
				}
				if (cvt.decpt > 0)
				{
					if (cvt.decpt > pr.prec)
					{
						pr.prec = n - 1;
						goto e_fmt;
					}
					if (cvt.decpt >= n)
					{
						pr.prec = 0;
						goto f_fmt;
					}
				}
				else if (cvt.decpt < -3)
				{
					pr.prec = n - 1;
					goto e_fmt;
				}
				/*
				* Know that -4 < cvt.decpt < n.
				* Thus pr.prec will be [1,n+3].
				*/
				pr.prec = n - cvt.decpt;
				goto f_fmt;
			}
		}
		quote:;
			if (_numeric[1] != '\0'
				&& (pr.ngrp = _grouping[0]) > 0
				&& pr.ngrp < CHAR_MAX)
			{
				pr.grp = _grouping;
				if (dogroup(&pr) != 0)
					return EOF;
				goto after;
			}
		}
		/*
		* All preparation complete.
		* Generate "prefix"+"0"*nleft0+"end-beg"+"0"*nright0+"suffix"
		* padded on the left or right as appropriate to width.
		*/
		{
			register size_t len = pr.end - pr.beg;

			if (pr.width > len)	/* chance for other padding */
			{
				size_t n;

				n = pr.nprefix + pr.nleft0 + len
					+ pr.nright0 + pr.nsuffix;
				if (n < pr.width)
				{
					pr.width -= n;
					if (pr.flags & F_DASH)
					{
						pr.flags |= F_AFTER;
						goto keepwidth;
					}
					if (pr.flags & F_ZERO)
					{
						pr.flags |= F_BEFORE;
						pr.nleft0 += pr.width;
					}
					else
						PADB(blanks, pr.width, &pr);
				}
			}
			pr.width = 0;
		keepwidth:;
			if (pr.flags & F_BEFORE)
			{
				if (pr.nprefix != 0)
					PUTB(pr.prefix, (int)pr.nprefix, &pr);
				if (pr.nleft0 != 0)
					PADB(zero_s, pr.nleft0, &pr);
			}
			PUTB(pr.beg, (int)len, &pr);
		after:;
			if (pr.flags & F_AFTER)
			{
				if (pr.nright0 != 0)
					PADB(zero_s, pr.nright0, &pr);
				if (pr.nsuffix != 0)
				{
					pr.nsuffix -= pr.nsuf0;
					PUTB(pr.suffix, (int)pr.nsuffix, &pr);
					if (pr.nsuf0 != 0)
						PADB(zero_s, (int)pr.nsuf0, &pr);
				}
				if (pr.width != 0)
					PADB(blanks, pr.width, &pr);
			}
		}
	done:;
		regular = 1;
		regfmt = ++fmt;
		goto again;
	}
}
