/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _NET_DES_DESDATA_H	/* wrapper symbol for kernel use */
#define _NET_DES_DESDATA_H	/* subject to change without notice */

#ident	"@(#)libnsl:common/lib/libnsl/des/des/desdata.h	1.1"
#ident	"$Header: $"

/*
 *	desdata.h, data for software implementation of DES
 */

#ifdef _KERNEL_HEADERS

#include <util/types.h>		/* REQUIRED */

#elif defined(_KERNEL)

#include <sys/types.h>		/* REQUIRED */

#endif

/*
 * Permuted-choice 1 from the key bits
 * to yield C and D.
 * Note that bits 8,16... are left out:
 * They are intended for a parity check.
 * Table has been munged to be zero-origin
 */
const static	short	PC1_C[] = {
	57-1, 49-1, 41-1, 33-1, 25-1, 17-1,  9-1, 
	 1-1, 58-1, 50-1, 42-1, 34-1, 26-1, 18-1, 
	10-1,  2-1, 59-1, 51-1, 43-1, 35-1, 27-1, 
	19-1, 11-1,  3-1, 60-1, 52-1, 44-1, 36-1, 
};

const static	short	PC1_D[] = {
	63-1, 55-1, 47-1, 39-1, 31-1, 23-1, 15-1, 
	 7-1, 62-1, 54-1, 46-1, 38-1, 30-1, 22-1, 
	14-1,  6-1, 61-1, 53-1, 45-1, 37-1, 29-1, 
	21-1, 13-1,  5-1, 28-1, 20-1, 12-1,  4-1, 
};

/*
 * Sequence of shifts used for the key schedule.
*/
const static	char	shifts[] = {
	1-1, 1-1, 2-1, 2-1, 2-1, 2-1, 2-1, 2-1,
	1-1, 2-1, 2-1, 2-1, 2-1, 2-1, 2-1, 1-1, 
};

/*
 * Permuted-choice 2, to pick out the bits from
 * the CD array that generate the key schedule.
 */
const static	char	PC2_C[] = {
	14, 17, 11, 24,  1,  5, 
	 3, 28, 15,  6, 21, 10, 
	23, 19, 12,  4, 26,  8, 
	16,  7, 27, 20, 13,  2, 
};

const static	char	PC2_D[] = {
	41-28, 52-28, 31-28, 37-28, 47-28, 55-28, 
	30-28, 40-28, 51-28, 45-28, 33-28, 48-28, 
	44-28, 49-28, 39-28, 56-28, 34-28, 53-28, 
	46-28, 42-28, 50-28, 36-28, 29-28, 32-28, 
};

/*
 * Initial permutation
 */
const static	short	IPtab[64] = {
	40-1,  8-1, 48-1, 16-1, 56-1, 24-1, 64-1, 32-1, 
	39-1,  7-1, 47-1, 15-1, 55-1, 23-1, 63-1, 31-1, 
	38-1,  6-1, 46-1, 14-1, 54-1, 22-1, 62-1, 30-1, 
	37-1,  5-1, 45-1, 13-1, 53-1, 21-1, 61-1, 29-1, 
	36-1,  4-1, 44-1, 12-1, 52-1, 20-1, 60-1, 28-1, 
	35-1,  3-1, 43-1, 11-1, 51-1, 19-1, 59-1, 27-1, 
	34-1,  2-1, 42-1, 10-1, 50-1, 18-1, 58-1, 26-1, 
	33-1,  1-1, 41-1,  9-1, 49-1, 17-1, 57-1, 25-1, 
};

/*
 * Final permutation
 */
const static	short	FPtab[64] = {
	58-1, 50-1, 42-1, 34-1, 26-1, 18-1, 10-1,  2-1, 
	60-1, 52-1, 44-1, 36-1, 28-1, 20-1, 12-1,  4-1, 
	62-1, 54-1, 46-1, 38-1, 30-1, 22-1, 14-1,  6-1, 
	64-1, 56-1, 48-1, 40-1, 32-1, 24-1, 16-1,  8-1, 
	57-1, 49-1, 41-1, 33-1, 25-1, 17-1,  9-1,  1-1, 
	59-1, 51-1, 43-1, 35-1, 27-1, 19-1, 11-1,  3-1, 
	61-1, 53-1, 45-1, 37-1, 29-1, 21-1, 13-1,  5-1, 
	63-1, 55-1, 47-1, 39-1, 31-1, 23-1, 15-1,  7-1, 
};

/*
 * Mask bit selection table
 */
const static	u_long longtab[32] = {
	0x80000000, 	0x40000000,	0x20000000,	0x10000000,
	0x8000000, 	0x4000000,	0x2000000,	0x1000000,
	0x800000, 	0x400000,	0x200000,	0x100000,
	0x80000, 	0x40000,	0x20000,	0x10000,
	0x8000,	 	0x4000,		0x2000,		0x1000,
	0x800, 		0x400,		0x200,		0x100,
	0x80, 		0x40,		0x20,		0x10,
	0x8, 		0x4,		0x2,		0x1,
};

/*
 * Table to expand 32 bit (4 bytes of 8 bits) R value
 * to 48 bits (8 bytes of 6 bits)
 */
struct R_to_ER {
	u_long l0, l1;
};

const static	struct R_to_ER R_to_ER_tab[4][256] = {
	{{ 0x00000000, 0x00000000, },	{ 0x00022000, 0x00000000, },
	{ 0x00040000, 0x00000000, },	{ 0x00062000, 0x00000000, },
	{ 0x00080000, 0x00000000, },	{ 0x000a2000, 0x00000000, },
	{ 0x000c0000, 0x00000000, },	{ 0x000e2000, 0x00000000, },
	{ 0x01100000, 0x00000000, },	{ 0x01122000, 0x00000000, },
	{ 0x01140000, 0x00000000, },	{ 0x01162000, 0x00000000, },
	{ 0x01180000, 0x00000000, },	{ 0x011a2000, 0x00000000, },
	{ 0x011c0000, 0x00000000, },	{ 0x011e2000, 0x00000000, },
	{ 0x02200000, 0x00000000, },	{ 0x02222000, 0x00000000, },
	{ 0x02240000, 0x00000000, },	{ 0x02262000, 0x00000000, },
	{ 0x02280000, 0x00000000, },	{ 0x022a2000, 0x00000000, },
	{ 0x022c0000, 0x00000000, },	{ 0x022e2000, 0x00000000, },
	{ 0x03300000, 0x00000000, },	{ 0x03322000, 0x00000000, },
	{ 0x03340000, 0x00000000, },	{ 0x03362000, 0x00000000, },
	{ 0x03380000, 0x00000000, },	{ 0x033a2000, 0x00000000, },
	{ 0x033c0000, 0x00000000, },	{ 0x033e2000, 0x00000000, },
	{ 0x04000000, 0x00000000, },	{ 0x04022000, 0x00000000, },
	{ 0x04040000, 0x00000000, },	{ 0x04062000, 0x00000000, },
	{ 0x04080000, 0x00000000, },	{ 0x040a2000, 0x00000000, },
	{ 0x040c0000, 0x00000000, },	{ 0x040e2000, 0x00000000, },
	{ 0x05100000, 0x00000000, },	{ 0x05122000, 0x00000000, },
	{ 0x05140000, 0x00000000, },	{ 0x05162000, 0x00000000, },
	{ 0x05180000, 0x00000000, },	{ 0x051a2000, 0x00000000, },
	{ 0x051c0000, 0x00000000, },	{ 0x051e2000, 0x00000000, },
	{ 0x06200000, 0x00000000, },	{ 0x06222000, 0x00000000, },
	{ 0x06240000, 0x00000000, },	{ 0x06262000, 0x00000000, },
	{ 0x06280000, 0x00000000, },	{ 0x062a2000, 0x00000000, },
	{ 0x062c0000, 0x00000000, },	{ 0x062e2000, 0x00000000, },
	{ 0x07300000, 0x00000000, },	{ 0x07322000, 0x00000000, },
	{ 0x07340000, 0x00000000, },	{ 0x07362000, 0x00000000, },
	{ 0x07380000, 0x00000000, },	{ 0x073a2000, 0x00000000, },
	{ 0x073c0000, 0x00000000, },	{ 0x073e2000, 0x00000000, },
	{ 0x08000000, 0x00000000, },	{ 0x08022000, 0x00000000, },
	{ 0x08040000, 0x00000000, },	{ 0x08062000, 0x00000000, },
	{ 0x08080000, 0x00000000, },	{ 0x080a2000, 0x00000000, },
	{ 0x080c0000, 0x00000000, },	{ 0x080e2000, 0x00000000, },
	{ 0x09100000, 0x00000000, },	{ 0x09122000, 0x00000000, },
	{ 0x09140000, 0x00000000, },	{ 0x09162000, 0x00000000, },
	{ 0x09180000, 0x00000000, },	{ 0x091a2000, 0x00000000, },
	{ 0x091c0000, 0x00000000, },	{ 0x091e2000, 0x00000000, },
	{ 0x0a200000, 0x00000000, },	{ 0x0a222000, 0x00000000, },
	{ 0x0a240000, 0x00000000, },	{ 0x0a262000, 0x00000000, },
	{ 0x0a280000, 0x00000000, },	{ 0x0a2a2000, 0x00000000, },
	{ 0x0a2c0000, 0x00000000, },	{ 0x0a2e2000, 0x00000000, },
	{ 0x0b300000, 0x00000000, },	{ 0x0b322000, 0x00000000, },
	{ 0x0b340000, 0x00000000, },	{ 0x0b362000, 0x00000000, },
	{ 0x0b380000, 0x00000000, },	{ 0x0b3a2000, 0x00000000, },
	{ 0x0b3c0000, 0x00000000, },	{ 0x0b3e2000, 0x00000000, },
	{ 0x0c000000, 0x00000000, },	{ 0x0c022000, 0x00000000, },
	{ 0x0c040000, 0x00000000, },	{ 0x0c062000, 0x00000000, },
	{ 0x0c080000, 0x00000000, },	{ 0x0c0a2000, 0x00000000, },
	{ 0x0c0c0000, 0x00000000, },	{ 0x0c0e2000, 0x00000000, },
	{ 0x0d100000, 0x00000000, },	{ 0x0d122000, 0x00000000, },
	{ 0x0d140000, 0x00000000, },	{ 0x0d162000, 0x00000000, },
	{ 0x0d180000, 0x00000000, },	{ 0x0d1a2000, 0x00000000, },
	{ 0x0d1c0000, 0x00000000, },	{ 0x0d1e2000, 0x00000000, },
	{ 0x0e200000, 0x00000000, },	{ 0x0e222000, 0x00000000, },
	{ 0x0e240000, 0x00000000, },	{ 0x0e262000, 0x00000000, },
	{ 0x0e280000, 0x00000000, },	{ 0x0e2a2000, 0x00000000, },
	{ 0x0e2c0000, 0x00000000, },	{ 0x0e2e2000, 0x00000000, },
	{ 0x0f300000, 0x00000000, },	{ 0x0f322000, 0x00000000, },
	{ 0x0f340000, 0x00000000, },	{ 0x0f362000, 0x00000000, },
	{ 0x0f380000, 0x00000000, },	{ 0x0f3a2000, 0x00000000, },
	{ 0x0f3c0000, 0x00000000, },	{ 0x0f3e2000, 0x00000000, },
	{ 0x10000000, 0x00000001, },	{ 0x10022000, 0x00000001, },
	{ 0x10040000, 0x00000001, },	{ 0x10062000, 0x00000001, },
	{ 0x10080000, 0x00000001, },	{ 0x100a2000, 0x00000001, },
	{ 0x100c0000, 0x00000001, },	{ 0x100e2000, 0x00000001, },
	{ 0x11100000, 0x00000001, },	{ 0x11122000, 0x00000001, },
	{ 0x11140000, 0x00000001, },	{ 0x11162000, 0x00000001, },
	{ 0x11180000, 0x00000001, },	{ 0x111a2000, 0x00000001, },
	{ 0x111c0000, 0x00000001, },	{ 0x111e2000, 0x00000001, },
	{ 0x12200000, 0x00000001, },	{ 0x12222000, 0x00000001, },
	{ 0x12240000, 0x00000001, },	{ 0x12262000, 0x00000001, },
	{ 0x12280000, 0x00000001, },	{ 0x122a2000, 0x00000001, },
	{ 0x122c0000, 0x00000001, },	{ 0x122e2000, 0x00000001, },
	{ 0x13300000, 0x00000001, },	{ 0x13322000, 0x00000001, },
	{ 0x13340000, 0x00000001, },	{ 0x13362000, 0x00000001, },
	{ 0x13380000, 0x00000001, },	{ 0x133a2000, 0x00000001, },
	{ 0x133c0000, 0x00000001, },	{ 0x133e2000, 0x00000001, },
	{ 0x14000000, 0x00000001, },	{ 0x14022000, 0x00000001, },
	{ 0x14040000, 0x00000001, },	{ 0x14062000, 0x00000001, },
	{ 0x14080000, 0x00000001, },	{ 0x140a2000, 0x00000001, },
	{ 0x140c0000, 0x00000001, },	{ 0x140e2000, 0x00000001, },
	{ 0x15100000, 0x00000001, },	{ 0x15122000, 0x00000001, },
	{ 0x15140000, 0x00000001, },	{ 0x15162000, 0x00000001, },
	{ 0x15180000, 0x00000001, },	{ 0x151a2000, 0x00000001, },
	{ 0x151c0000, 0x00000001, },	{ 0x151e2000, 0x00000001, },
	{ 0x16200000, 0x00000001, },	{ 0x16222000, 0x00000001, },
	{ 0x16240000, 0x00000001, },	{ 0x16262000, 0x00000001, },
	{ 0x16280000, 0x00000001, },	{ 0x162a2000, 0x00000001, },
	{ 0x162c0000, 0x00000001, },	{ 0x162e2000, 0x00000001, },
	{ 0x17300000, 0x00000001, },	{ 0x17322000, 0x00000001, },
	{ 0x17340000, 0x00000001, },	{ 0x17362000, 0x00000001, },
	{ 0x17380000, 0x00000001, },	{ 0x173a2000, 0x00000001, },
	{ 0x173c0000, 0x00000001, },	{ 0x173e2000, 0x00000001, },
	{ 0x18000000, 0x00000001, },	{ 0x18022000, 0x00000001, },
	{ 0x18040000, 0x00000001, },	{ 0x18062000, 0x00000001, },
	{ 0x18080000, 0x00000001, },	{ 0x180a2000, 0x00000001, },
	{ 0x180c0000, 0x00000001, },	{ 0x180e2000, 0x00000001, },
	{ 0x19100000, 0x00000001, },	{ 0x19122000, 0x00000001, },
	{ 0x19140000, 0x00000001, },	{ 0x19162000, 0x00000001, },
	{ 0x19180000, 0x00000001, },	{ 0x191a2000, 0x00000001, },
	{ 0x191c0000, 0x00000001, },	{ 0x191e2000, 0x00000001, },
	{ 0x1a200000, 0x00000001, },	{ 0x1a222000, 0x00000001, },
	{ 0x1a240000, 0x00000001, },	{ 0x1a262000, 0x00000001, },
	{ 0x1a280000, 0x00000001, },	{ 0x1a2a2000, 0x00000001, },
	{ 0x1a2c0000, 0x00000001, },	{ 0x1a2e2000, 0x00000001, },
	{ 0x1b300000, 0x00000001, },	{ 0x1b322000, 0x00000001, },
	{ 0x1b340000, 0x00000001, },	{ 0x1b362000, 0x00000001, },
	{ 0x1b380000, 0x00000001, },	{ 0x1b3a2000, 0x00000001, },
	{ 0x1b3c0000, 0x00000001, },	{ 0x1b3e2000, 0x00000001, },
	{ 0x1c000000, 0x00000001, },	{ 0x1c022000, 0x00000001, },
	{ 0x1c040000, 0x00000001, },	{ 0x1c062000, 0x00000001, },
	{ 0x1c080000, 0x00000001, },	{ 0x1c0a2000, 0x00000001, },
	{ 0x1c0c0000, 0x00000001, },	{ 0x1c0e2000, 0x00000001, },
	{ 0x1d100000, 0x00000001, },	{ 0x1d122000, 0x00000001, },
	{ 0x1d140000, 0x00000001, },	{ 0x1d162000, 0x00000001, },
	{ 0x1d180000, 0x00000001, },	{ 0x1d1a2000, 0x00000001, },
	{ 0x1d1c0000, 0x00000001, },	{ 0x1d1e2000, 0x00000001, },
	{ 0x1e200000, 0x00000001, },	{ 0x1e222000, 0x00000001, },
	{ 0x1e240000, 0x00000001, },	{ 0x1e262000, 0x00000001, },
	{ 0x1e280000, 0x00000001, },	{ 0x1e2a2000, 0x00000001, },
	{ 0x1e2c0000, 0x00000001, },	{ 0x1e2e2000, 0x00000001, },
	{ 0x1f300000, 0x00000001, },	{ 0x1f322000, 0x00000001, },
	{ 0x1f340000, 0x00000001, },	{ 0x1f362000, 0x00000001, },
	{ 0x1f380000, 0x00000001, },	{ 0x1f3a2000, 0x00000001, },
	{ 0x1f3c0000, 0x00000001, },	{ 0x1f3e2000, 0x00000001, },},

	{{ 0x00000000, 0x00000000, },	{ 0x00000002, 0x20000000, },
	{ 0x00000004, 0x00000000, },	{ 0x00000006, 0x20000000, },
	{ 0x00000008, 0x00000000, },	{ 0x0000000a, 0x20000000, },
	{ 0x0000000c, 0x00000000, },	{ 0x0000000e, 0x20000000, },
	{ 0x00000110, 0x00000000, },	{ 0x00000112, 0x20000000, },
	{ 0x00000114, 0x00000000, },	{ 0x00000116, 0x20000000, },
	{ 0x00000118, 0x00000000, },	{ 0x0000011a, 0x20000000, },
	{ 0x0000011c, 0x00000000, },	{ 0x0000011e, 0x20000000, },
	{ 0x00000220, 0x00000000, },	{ 0x00000222, 0x20000000, },
	{ 0x00000224, 0x00000000, },	{ 0x00000226, 0x20000000, },
	{ 0x00000228, 0x00000000, },	{ 0x0000022a, 0x20000000, },
	{ 0x0000022c, 0x00000000, },	{ 0x0000022e, 0x20000000, },
	{ 0x00000330, 0x00000000, },	{ 0x00000332, 0x20000000, },
	{ 0x00000334, 0x00000000, },	{ 0x00000336, 0x20000000, },
	{ 0x00000338, 0x00000000, },	{ 0x0000033a, 0x20000000, },
	{ 0x0000033c, 0x00000000, },	{ 0x0000033e, 0x20000000, },
	{ 0x00000400, 0x00000000, },	{ 0x00000402, 0x20000000, },
	{ 0x00000404, 0x00000000, },	{ 0x00000406, 0x20000000, },
	{ 0x00000408, 0x00000000, },	{ 0x0000040a, 0x20000000, },
	{ 0x0000040c, 0x00000000, },	{ 0x0000040e, 0x20000000, },
	{ 0x00000510, 0x00000000, },	{ 0x00000512, 0x20000000, },
	{ 0x00000514, 0x00000000, },	{ 0x00000516, 0x20000000, },
	{ 0x00000518, 0x00000000, },	{ 0x0000051a, 0x20000000, },
	{ 0x0000051c, 0x00000000, },	{ 0x0000051e, 0x20000000, },
	{ 0x00000620, 0x00000000, },	{ 0x00000622, 0x20000000, },
	{ 0x00000624, 0x00000000, },	{ 0x00000626, 0x20000000, },
	{ 0x00000628, 0x00000000, },	{ 0x0000062a, 0x20000000, },
	{ 0x0000062c, 0x00000000, },	{ 0x0000062e, 0x20000000, },
	{ 0x00000730, 0x00000000, },	{ 0x00000732, 0x20000000, },
	{ 0x00000734, 0x00000000, },	{ 0x00000736, 0x20000000, },
	{ 0x00000738, 0x00000000, },	{ 0x0000073a, 0x20000000, },
	{ 0x0000073c, 0x00000000, },	{ 0x0000073e, 0x20000000, },
	{ 0x00000800, 0x00000000, },	{ 0x00000802, 0x20000000, },
	{ 0x00000804, 0x00000000, },	{ 0x00000806, 0x20000000, },
	{ 0x00000808, 0x00000000, },	{ 0x0000080a, 0x20000000, },
	{ 0x0000080c, 0x00000000, },	{ 0x0000080e, 0x20000000, },
	{ 0x00000910, 0x00000000, },	{ 0x00000912, 0x20000000, },
	{ 0x00000914, 0x00000000, },	{ 0x00000916, 0x20000000, },
	{ 0x00000918, 0x00000000, },	{ 0x0000091a, 0x20000000, },
	{ 0x0000091c, 0x00000000, },	{ 0x0000091e, 0x20000000, },
	{ 0x00000a20, 0x00000000, },	{ 0x00000a22, 0x20000000, },
	{ 0x00000a24, 0x00000000, },	{ 0x00000a26, 0x20000000, },
	{ 0x00000a28, 0x00000000, },	{ 0x00000a2a, 0x20000000, },
	{ 0x00000a2c, 0x00000000, },	{ 0x00000a2e, 0x20000000, },
	{ 0x00000b30, 0x00000000, },	{ 0x00000b32, 0x20000000, },
	{ 0x00000b34, 0x00000000, },	{ 0x00000b36, 0x20000000, },
	{ 0x00000b38, 0x00000000, },	{ 0x00000b3a, 0x20000000, },
	{ 0x00000b3c, 0x00000000, },	{ 0x00000b3e, 0x20000000, },
	{ 0x00000c00, 0x00000000, },	{ 0x00000c02, 0x20000000, },
	{ 0x00000c04, 0x00000000, },	{ 0x00000c06, 0x20000000, },
	{ 0x00000c08, 0x00000000, },	{ 0x00000c0a, 0x20000000, },
	{ 0x00000c0c, 0x00000000, },	{ 0x00000c0e, 0x20000000, },
	{ 0x00000d10, 0x00000000, },	{ 0x00000d12, 0x20000000, },
	{ 0x00000d14, 0x00000000, },	{ 0x00000d16, 0x20000000, },
	{ 0x00000d18, 0x00000000, },	{ 0x00000d1a, 0x20000000, },
	{ 0x00000d1c, 0x00000000, },	{ 0x00000d1e, 0x20000000, },
	{ 0x00000e20, 0x00000000, },	{ 0x00000e22, 0x20000000, },
	{ 0x00000e24, 0x00000000, },	{ 0x00000e26, 0x20000000, },
	{ 0x00000e28, 0x00000000, },	{ 0x00000e2a, 0x20000000, },
	{ 0x00000e2c, 0x00000000, },	{ 0x00000e2e, 0x20000000, },
	{ 0x00000f30, 0x00000000, },	{ 0x00000f32, 0x20000000, },
	{ 0x00000f34, 0x00000000, },	{ 0x00000f36, 0x20000000, },
	{ 0x00000f38, 0x00000000, },	{ 0x00000f3a, 0x20000000, },
	{ 0x00000f3c, 0x00000000, },	{ 0x00000f3e, 0x20000000, },
	{ 0x00011000, 0x00000000, },	{ 0x00011002, 0x20000000, },
	{ 0x00011004, 0x00000000, },	{ 0x00011006, 0x20000000, },
	{ 0x00011008, 0x00000000, },	{ 0x0001100a, 0x20000000, },
	{ 0x0001100c, 0x00000000, },	{ 0x0001100e, 0x20000000, },
	{ 0x00011110, 0x00000000, },	{ 0x00011112, 0x20000000, },
	{ 0x00011114, 0x00000000, },	{ 0x00011116, 0x20000000, },
	{ 0x00011118, 0x00000000, },	{ 0x0001111a, 0x20000000, },
	{ 0x0001111c, 0x00000000, },	{ 0x0001111e, 0x20000000, },
	{ 0x00011220, 0x00000000, },	{ 0x00011222, 0x20000000, },
	{ 0x00011224, 0x00000000, },	{ 0x00011226, 0x20000000, },
	{ 0x00011228, 0x00000000, },	{ 0x0001122a, 0x20000000, },
	{ 0x0001122c, 0x00000000, },	{ 0x0001122e, 0x20000000, },
	{ 0x00011330, 0x00000000, },	{ 0x00011332, 0x20000000, },
	{ 0x00011334, 0x00000000, },	{ 0x00011336, 0x20000000, },
	{ 0x00011338, 0x00000000, },	{ 0x0001133a, 0x20000000, },
	{ 0x0001133c, 0x00000000, },	{ 0x0001133e, 0x20000000, },
	{ 0x00011400, 0x00000000, },	{ 0x00011402, 0x20000000, },
	{ 0x00011404, 0x00000000, },	{ 0x00011406, 0x20000000, },
	{ 0x00011408, 0x00000000, },	{ 0x0001140a, 0x20000000, },
	{ 0x0001140c, 0x00000000, },	{ 0x0001140e, 0x20000000, },
	{ 0x00011510, 0x00000000, },	{ 0x00011512, 0x20000000, },
	{ 0x00011514, 0x00000000, },	{ 0x00011516, 0x20000000, },
	{ 0x00011518, 0x00000000, },	{ 0x0001151a, 0x20000000, },
	{ 0x0001151c, 0x00000000, },	{ 0x0001151e, 0x20000000, },
	{ 0x00011620, 0x00000000, },	{ 0x00011622, 0x20000000, },
	{ 0x00011624, 0x00000000, },	{ 0x00011626, 0x20000000, },
	{ 0x00011628, 0x00000000, },	{ 0x0001162a, 0x20000000, },
	{ 0x0001162c, 0x00000000, },	{ 0x0001162e, 0x20000000, },
	{ 0x00011730, 0x00000000, },	{ 0x00011732, 0x20000000, },
	{ 0x00011734, 0x00000000, },	{ 0x00011736, 0x20000000, },
	{ 0x00011738, 0x00000000, },	{ 0x0001173a, 0x20000000, },
	{ 0x0001173c, 0x00000000, },	{ 0x0001173e, 0x20000000, },
	{ 0x00011800, 0x00000000, },	{ 0x00011802, 0x20000000, },
	{ 0x00011804, 0x00000000, },	{ 0x00011806, 0x20000000, },
	{ 0x00011808, 0x00000000, },	{ 0x0001180a, 0x20000000, },
	{ 0x0001180c, 0x00000000, },	{ 0x0001180e, 0x20000000, },
	{ 0x00011910, 0x00000000, },	{ 0x00011912, 0x20000000, },
	{ 0x00011914, 0x00000000, },	{ 0x00011916, 0x20000000, },
	{ 0x00011918, 0x00000000, },	{ 0x0001191a, 0x20000000, },
	{ 0x0001191c, 0x00000000, },	{ 0x0001191e, 0x20000000, },
	{ 0x00011a20, 0x00000000, },	{ 0x00011a22, 0x20000000, },
	{ 0x00011a24, 0x00000000, },	{ 0x00011a26, 0x20000000, },
	{ 0x00011a28, 0x00000000, },	{ 0x00011a2a, 0x20000000, },
	{ 0x00011a2c, 0x00000000, },	{ 0x00011a2e, 0x20000000, },
	{ 0x00011b30, 0x00000000, },	{ 0x00011b32, 0x20000000, },
	{ 0x00011b34, 0x00000000, },	{ 0x00011b36, 0x20000000, },
	{ 0x00011b38, 0x00000000, },	{ 0x00011b3a, 0x20000000, },
	{ 0x00011b3c, 0x00000000, },	{ 0x00011b3e, 0x20000000, },
	{ 0x00011c00, 0x00000000, },	{ 0x00011c02, 0x20000000, },
	{ 0x00011c04, 0x00000000, },	{ 0x00011c06, 0x20000000, },
	{ 0x00011c08, 0x00000000, },	{ 0x00011c0a, 0x20000000, },
	{ 0x00011c0c, 0x00000000, },	{ 0x00011c0e, 0x20000000, },
	{ 0x00011d10, 0x00000000, },	{ 0x00011d12, 0x20000000, },
	{ 0x00011d14, 0x00000000, },	{ 0x00011d16, 0x20000000, },
	{ 0x00011d18, 0x00000000, },	{ 0x00011d1a, 0x20000000, },
	{ 0x00011d1c, 0x00000000, },	{ 0x00011d1e, 0x20000000, },
	{ 0x00011e20, 0x00000000, },	{ 0x00011e22, 0x20000000, },
	{ 0x00011e24, 0x00000000, },	{ 0x00011e26, 0x20000000, },
	{ 0x00011e28, 0x00000000, },	{ 0x00011e2a, 0x20000000, },
	{ 0x00011e2c, 0x00000000, },	{ 0x00011e2e, 0x20000000, },
	{ 0x00011f30, 0x00000000, },	{ 0x00011f32, 0x20000000, },
	{ 0x00011f34, 0x00000000, },	{ 0x00011f36, 0x20000000, },
	{ 0x00011f38, 0x00000000, },	{ 0x00011f3a, 0x20000000, },
	{ 0x00011f3c, 0x00000000, },	{ 0x00011f3e, 0x20000000, },},

	{{ 0x00000000, 0x00000000, },	{ 0x00000000, 0x00022000, },
	{ 0x00000000, 0x00040000, },	{ 0x00000000, 0x00062000, },
	{ 0x00000000, 0x00080000, },	{ 0x00000000, 0x000a2000, },
	{ 0x00000000, 0x000c0000, },	{ 0x00000000, 0x000e2000, },
	{ 0x00000000, 0x01100000, },	{ 0x00000000, 0x01122000, },
	{ 0x00000000, 0x01140000, },	{ 0x00000000, 0x01162000, },
	{ 0x00000000, 0x01180000, },	{ 0x00000000, 0x011a2000, },
	{ 0x00000000, 0x011c0000, },	{ 0x00000000, 0x011e2000, },
	{ 0x00000000, 0x02200000, },	{ 0x00000000, 0x02222000, },
	{ 0x00000000, 0x02240000, },	{ 0x00000000, 0x02262000, },
	{ 0x00000000, 0x02280000, },	{ 0x00000000, 0x022a2000, },
	{ 0x00000000, 0x022c0000, },	{ 0x00000000, 0x022e2000, },
	{ 0x00000000, 0x03300000, },	{ 0x00000000, 0x03322000, },
	{ 0x00000000, 0x03340000, },	{ 0x00000000, 0x03362000, },
	{ 0x00000000, 0x03380000, },	{ 0x00000000, 0x033a2000, },
	{ 0x00000000, 0x033c0000, },	{ 0x00000000, 0x033e2000, },
	{ 0x00000000, 0x04000000, },	{ 0x00000000, 0x04022000, },
	{ 0x00000000, 0x04040000, },	{ 0x00000000, 0x04062000, },
	{ 0x00000000, 0x04080000, },	{ 0x00000000, 0x040a2000, },
	{ 0x00000000, 0x040c0000, },	{ 0x00000000, 0x040e2000, },
	{ 0x00000000, 0x05100000, },	{ 0x00000000, 0x05122000, },
	{ 0x00000000, 0x05140000, },	{ 0x00000000, 0x05162000, },
	{ 0x00000000, 0x05180000, },	{ 0x00000000, 0x051a2000, },
	{ 0x00000000, 0x051c0000, },	{ 0x00000000, 0x051e2000, },
	{ 0x00000000, 0x06200000, },	{ 0x00000000, 0x06222000, },
	{ 0x00000000, 0x06240000, },	{ 0x00000000, 0x06262000, },
	{ 0x00000000, 0x06280000, },	{ 0x00000000, 0x062a2000, },
	{ 0x00000000, 0x062c0000, },	{ 0x00000000, 0x062e2000, },
	{ 0x00000000, 0x07300000, },	{ 0x00000000, 0x07322000, },
	{ 0x00000000, 0x07340000, },	{ 0x00000000, 0x07362000, },
	{ 0x00000000, 0x07380000, },	{ 0x00000000, 0x073a2000, },
	{ 0x00000000, 0x073c0000, },	{ 0x00000000, 0x073e2000, },
	{ 0x00000000, 0x08000000, },	{ 0x00000000, 0x08022000, },
	{ 0x00000000, 0x08040000, },	{ 0x00000000, 0x08062000, },
	{ 0x00000000, 0x08080000, },	{ 0x00000000, 0x080a2000, },
	{ 0x00000000, 0x080c0000, },	{ 0x00000000, 0x080e2000, },
	{ 0x00000000, 0x09100000, },	{ 0x00000000, 0x09122000, },
	{ 0x00000000, 0x09140000, },	{ 0x00000000, 0x09162000, },
	{ 0x00000000, 0x09180000, },	{ 0x00000000, 0x091a2000, },
	{ 0x00000000, 0x091c0000, },	{ 0x00000000, 0x091e2000, },
	{ 0x00000000, 0x0a200000, },	{ 0x00000000, 0x0a222000, },
	{ 0x00000000, 0x0a240000, },	{ 0x00000000, 0x0a262000, },
	{ 0x00000000, 0x0a280000, },	{ 0x00000000, 0x0a2a2000, },
	{ 0x00000000, 0x0a2c0000, },	{ 0x00000000, 0x0a2e2000, },
	{ 0x00000000, 0x0b300000, },	{ 0x00000000, 0x0b322000, },
	{ 0x00000000, 0x0b340000, },	{ 0x00000000, 0x0b362000, },
	{ 0x00000000, 0x0b380000, },	{ 0x00000000, 0x0b3a2000, },
	{ 0x00000000, 0x0b3c0000, },	{ 0x00000000, 0x0b3e2000, },
	{ 0x00000000, 0x0c000000, },	{ 0x00000000, 0x0c022000, },
	{ 0x00000000, 0x0c040000, },	{ 0x00000000, 0x0c062000, },
	{ 0x00000000, 0x0c080000, },	{ 0x00000000, 0x0c0a2000, },
	{ 0x00000000, 0x0c0c0000, },	{ 0x00000000, 0x0c0e2000, },
	{ 0x00000000, 0x0d100000, },	{ 0x00000000, 0x0d122000, },
	{ 0x00000000, 0x0d140000, },	{ 0x00000000, 0x0d162000, },
	{ 0x00000000, 0x0d180000, },	{ 0x00000000, 0x0d1a2000, },
	{ 0x00000000, 0x0d1c0000, },	{ 0x00000000, 0x0d1e2000, },
	{ 0x00000000, 0x0e200000, },	{ 0x00000000, 0x0e222000, },
	{ 0x00000000, 0x0e240000, },	{ 0x00000000, 0x0e262000, },
	{ 0x00000000, 0x0e280000, },	{ 0x00000000, 0x0e2a2000, },
	{ 0x00000000, 0x0e2c0000, },	{ 0x00000000, 0x0e2e2000, },
	{ 0x00000000, 0x0f300000, },	{ 0x00000000, 0x0f322000, },
	{ 0x00000000, 0x0f340000, },	{ 0x00000000, 0x0f362000, },
	{ 0x00000000, 0x0f380000, },	{ 0x00000000, 0x0f3a2000, },
	{ 0x00000000, 0x0f3c0000, },	{ 0x00000000, 0x0f3e2000, },
	{ 0x00000001, 0x10000000, },	{ 0x00000001, 0x10022000, },
	{ 0x00000001, 0x10040000, },	{ 0x00000001, 0x10062000, },
	{ 0x00000001, 0x10080000, },	{ 0x00000001, 0x100a2000, },
	{ 0x00000001, 0x100c0000, },	{ 0x00000001, 0x100e2000, },
	{ 0x00000001, 0x11100000, },	{ 0x00000001, 0x11122000, },
	{ 0x00000001, 0x11140000, },	{ 0x00000001, 0x11162000, },
	{ 0x00000001, 0x11180000, },	{ 0x00000001, 0x111a2000, },
	{ 0x00000001, 0x111c0000, },	{ 0x00000001, 0x111e2000, },
	{ 0x00000001, 0x12200000, },	{ 0x00000001, 0x12222000, },
	{ 0x00000001, 0x12240000, },	{ 0x00000001, 0x12262000, },
	{ 0x00000001, 0x12280000, },	{ 0x00000001, 0x122a2000, },
	{ 0x00000001, 0x122c0000, },	{ 0x00000001, 0x122e2000, },
	{ 0x00000001, 0x13300000, },	{ 0x00000001, 0x13322000, },
	{ 0x00000001, 0x13340000, },	{ 0x00000001, 0x13362000, },
	{ 0x00000001, 0x13380000, },	{ 0x00000001, 0x133a2000, },
	{ 0x00000001, 0x133c0000, },	{ 0x00000001, 0x133e2000, },
	{ 0x00000001, 0x14000000, },	{ 0x00000001, 0x14022000, },
	{ 0x00000001, 0x14040000, },	{ 0x00000001, 0x14062000, },
	{ 0x00000001, 0x14080000, },	{ 0x00000001, 0x140a2000, },
	{ 0x00000001, 0x140c0000, },	{ 0x00000001, 0x140e2000, },
	{ 0x00000001, 0x15100000, },	{ 0x00000001, 0x15122000, },
	{ 0x00000001, 0x15140000, },	{ 0x00000001, 0x15162000, },
	{ 0x00000001, 0x15180000, },	{ 0x00000001, 0x151a2000, },
	{ 0x00000001, 0x151c0000, },	{ 0x00000001, 0x151e2000, },
	{ 0x00000001, 0x16200000, },	{ 0x00000001, 0x16222000, },
	{ 0x00000001, 0x16240000, },	{ 0x00000001, 0x16262000, },
	{ 0x00000001, 0x16280000, },	{ 0x00000001, 0x162a2000, },
	{ 0x00000001, 0x162c0000, },	{ 0x00000001, 0x162e2000, },
	{ 0x00000001, 0x17300000, },	{ 0x00000001, 0x17322000, },
	{ 0x00000001, 0x17340000, },	{ 0x00000001, 0x17362000, },
	{ 0x00000001, 0x17380000, },	{ 0x00000001, 0x173a2000, },
	{ 0x00000001, 0x173c0000, },	{ 0x00000001, 0x173e2000, },
	{ 0x00000001, 0x18000000, },	{ 0x00000001, 0x18022000, },
	{ 0x00000001, 0x18040000, },	{ 0x00000001, 0x18062000, },
	{ 0x00000001, 0x18080000, },	{ 0x00000001, 0x180a2000, },
	{ 0x00000001, 0x180c0000, },	{ 0x00000001, 0x180e2000, },
	{ 0x00000001, 0x19100000, },	{ 0x00000001, 0x19122000, },
	{ 0x00000001, 0x19140000, },	{ 0x00000001, 0x19162000, },
	{ 0x00000001, 0x19180000, },	{ 0x00000001, 0x191a2000, },
	{ 0x00000001, 0x191c0000, },	{ 0x00000001, 0x191e2000, },
	{ 0x00000001, 0x1a200000, },	{ 0x00000001, 0x1a222000, },
	{ 0x00000001, 0x1a240000, },	{ 0x00000001, 0x1a262000, },
	{ 0x00000001, 0x1a280000, },	{ 0x00000001, 0x1a2a2000, },
	{ 0x00000001, 0x1a2c0000, },	{ 0x00000001, 0x1a2e2000, },
	{ 0x00000001, 0x1b300000, },	{ 0x00000001, 0x1b322000, },
	{ 0x00000001, 0x1b340000, },	{ 0x00000001, 0x1b362000, },
	{ 0x00000001, 0x1b380000, },	{ 0x00000001, 0x1b3a2000, },
	{ 0x00000001, 0x1b3c0000, },	{ 0x00000001, 0x1b3e2000, },
	{ 0x00000001, 0x1c000000, },	{ 0x00000001, 0x1c022000, },
	{ 0x00000001, 0x1c040000, },	{ 0x00000001, 0x1c062000, },
	{ 0x00000001, 0x1c080000, },	{ 0x00000001, 0x1c0a2000, },
	{ 0x00000001, 0x1c0c0000, },	{ 0x00000001, 0x1c0e2000, },
	{ 0x00000001, 0x1d100000, },	{ 0x00000001, 0x1d122000, },
	{ 0x00000001, 0x1d140000, },	{ 0x00000001, 0x1d162000, },
	{ 0x00000001, 0x1d180000, },	{ 0x00000001, 0x1d1a2000, },
	{ 0x00000001, 0x1d1c0000, },	{ 0x00000001, 0x1d1e2000, },
	{ 0x00000001, 0x1e200000, },	{ 0x00000001, 0x1e222000, },
	{ 0x00000001, 0x1e240000, },	{ 0x00000001, 0x1e262000, },
	{ 0x00000001, 0x1e280000, },	{ 0x00000001, 0x1e2a2000, },
	{ 0x00000001, 0x1e2c0000, },	{ 0x00000001, 0x1e2e2000, },
	{ 0x00000001, 0x1f300000, },	{ 0x00000001, 0x1f322000, },
	{ 0x00000001, 0x1f340000, },	{ 0x00000001, 0x1f362000, },
	{ 0x00000001, 0x1f380000, },	{ 0x00000001, 0x1f3a2000, },
	{ 0x00000001, 0x1f3c0000, },	{ 0x00000001, 0x1f3e2000, },},

	{{ 0x00000000, 0x00000000, },	{ 0x20000000, 0x00000002, },
	{ 0x00000000, 0x00000004, },	{ 0x20000000, 0x00000006, },
	{ 0x00000000, 0x00000008, },	{ 0x20000000, 0x0000000a, },
	{ 0x00000000, 0x0000000c, },	{ 0x20000000, 0x0000000e, },
	{ 0x00000000, 0x00000110, },	{ 0x20000000, 0x00000112, },
	{ 0x00000000, 0x00000114, },	{ 0x20000000, 0x00000116, },
	{ 0x00000000, 0x00000118, },	{ 0x20000000, 0x0000011a, },
	{ 0x00000000, 0x0000011c, },	{ 0x20000000, 0x0000011e, },
	{ 0x00000000, 0x00000220, },	{ 0x20000000, 0x00000222, },
	{ 0x00000000, 0x00000224, },	{ 0x20000000, 0x00000226, },
	{ 0x00000000, 0x00000228, },	{ 0x20000000, 0x0000022a, },
	{ 0x00000000, 0x0000022c, },	{ 0x20000000, 0x0000022e, },
	{ 0x00000000, 0x00000330, },	{ 0x20000000, 0x00000332, },
	{ 0x00000000, 0x00000334, },	{ 0x20000000, 0x00000336, },
	{ 0x00000000, 0x00000338, },	{ 0x20000000, 0x0000033a, },
	{ 0x00000000, 0x0000033c, },	{ 0x20000000, 0x0000033e, },
	{ 0x00000000, 0x00000400, },	{ 0x20000000, 0x00000402, },
	{ 0x00000000, 0x00000404, },	{ 0x20000000, 0x00000406, },
	{ 0x00000000, 0x00000408, },	{ 0x20000000, 0x0000040a, },
	{ 0x00000000, 0x0000040c, },	{ 0x20000000, 0x0000040e, },
	{ 0x00000000, 0x00000510, },	{ 0x20000000, 0x00000512, },
	{ 0x00000000, 0x00000514, },	{ 0x20000000, 0x00000516, },
	{ 0x00000000, 0x00000518, },	{ 0x20000000, 0x0000051a, },
	{ 0x00000000, 0x0000051c, },	{ 0x20000000, 0x0000051e, },
	{ 0x00000000, 0x00000620, },	{ 0x20000000, 0x00000622, },
	{ 0x00000000, 0x00000624, },	{ 0x20000000, 0x00000626, },
	{ 0x00000000, 0x00000628, },	{ 0x20000000, 0x0000062a, },
	{ 0x00000000, 0x0000062c, },	{ 0x20000000, 0x0000062e, },
	{ 0x00000000, 0x00000730, },	{ 0x20000000, 0x00000732, },
	{ 0x00000000, 0x00000734, },	{ 0x20000000, 0x00000736, },
	{ 0x00000000, 0x00000738, },	{ 0x20000000, 0x0000073a, },
	{ 0x00000000, 0x0000073c, },	{ 0x20000000, 0x0000073e, },
	{ 0x00000000, 0x00000800, },	{ 0x20000000, 0x00000802, },
	{ 0x00000000, 0x00000804, },	{ 0x20000000, 0x00000806, },
	{ 0x00000000, 0x00000808, },	{ 0x20000000, 0x0000080a, },
	{ 0x00000000, 0x0000080c, },	{ 0x20000000, 0x0000080e, },
	{ 0x00000000, 0x00000910, },	{ 0x20000000, 0x00000912, },
	{ 0x00000000, 0x00000914, },	{ 0x20000000, 0x00000916, },
	{ 0x00000000, 0x00000918, },	{ 0x20000000, 0x0000091a, },
	{ 0x00000000, 0x0000091c, },	{ 0x20000000, 0x0000091e, },
	{ 0x00000000, 0x00000a20, },	{ 0x20000000, 0x00000a22, },
	{ 0x00000000, 0x00000a24, },	{ 0x20000000, 0x00000a26, },
	{ 0x00000000, 0x00000a28, },	{ 0x20000000, 0x00000a2a, },
	{ 0x00000000, 0x00000a2c, },	{ 0x20000000, 0x00000a2e, },
	{ 0x00000000, 0x00000b30, },	{ 0x20000000, 0x00000b32, },
	{ 0x00000000, 0x00000b34, },	{ 0x20000000, 0x00000b36, },
	{ 0x00000000, 0x00000b38, },	{ 0x20000000, 0x00000b3a, },
	{ 0x00000000, 0x00000b3c, },	{ 0x20000000, 0x00000b3e, },
	{ 0x00000000, 0x00000c00, },	{ 0x20000000, 0x00000c02, },
	{ 0x00000000, 0x00000c04, },	{ 0x20000000, 0x00000c06, },
	{ 0x00000000, 0x00000c08, },	{ 0x20000000, 0x00000c0a, },
	{ 0x00000000, 0x00000c0c, },	{ 0x20000000, 0x00000c0e, },
	{ 0x00000000, 0x00000d10, },	{ 0x20000000, 0x00000d12, },
	{ 0x00000000, 0x00000d14, },	{ 0x20000000, 0x00000d16, },
	{ 0x00000000, 0x00000d18, },	{ 0x20000000, 0x00000d1a, },
	{ 0x00000000, 0x00000d1c, },	{ 0x20000000, 0x00000d1e, },
	{ 0x00000000, 0x00000e20, },	{ 0x20000000, 0x00000e22, },
	{ 0x00000000, 0x00000e24, },	{ 0x20000000, 0x00000e26, },
	{ 0x00000000, 0x00000e28, },	{ 0x20000000, 0x00000e2a, },
	{ 0x00000000, 0x00000e2c, },	{ 0x20000000, 0x00000e2e, },
	{ 0x00000000, 0x00000f30, },	{ 0x20000000, 0x00000f32, },
	{ 0x00000000, 0x00000f34, },	{ 0x20000000, 0x00000f36, },
	{ 0x00000000, 0x00000f38, },	{ 0x20000000, 0x00000f3a, },
	{ 0x00000000, 0x00000f3c, },	{ 0x20000000, 0x00000f3e, },
	{ 0x00000000, 0x00011000, },	{ 0x20000000, 0x00011002, },
	{ 0x00000000, 0x00011004, },	{ 0x20000000, 0x00011006, },
	{ 0x00000000, 0x00011008, },	{ 0x20000000, 0x0001100a, },
	{ 0x00000000, 0x0001100c, },	{ 0x20000000, 0x0001100e, },
	{ 0x00000000, 0x00011110, },	{ 0x20000000, 0x00011112, },
	{ 0x00000000, 0x00011114, },	{ 0x20000000, 0x00011116, },
	{ 0x00000000, 0x00011118, },	{ 0x20000000, 0x0001111a, },
	{ 0x00000000, 0x0001111c, },	{ 0x20000000, 0x0001111e, },
	{ 0x00000000, 0x00011220, },	{ 0x20000000, 0x00011222, },
	{ 0x00000000, 0x00011224, },	{ 0x20000000, 0x00011226, },
	{ 0x00000000, 0x00011228, },	{ 0x20000000, 0x0001122a, },
	{ 0x00000000, 0x0001122c, },	{ 0x20000000, 0x0001122e, },
	{ 0x00000000, 0x00011330, },	{ 0x20000000, 0x00011332, },
	{ 0x00000000, 0x00011334, },	{ 0x20000000, 0x00011336, },
	{ 0x00000000, 0x00011338, },	{ 0x20000000, 0x0001133a, },
	{ 0x00000000, 0x0001133c, },	{ 0x20000000, 0x0001133e, },
	{ 0x00000000, 0x00011400, },	{ 0x20000000, 0x00011402, },
	{ 0x00000000, 0x00011404, },	{ 0x20000000, 0x00011406, },
	{ 0x00000000, 0x00011408, },	{ 0x20000000, 0x0001140a, },
	{ 0x00000000, 0x0001140c, },	{ 0x20000000, 0x0001140e, },
	{ 0x00000000, 0x00011510, },	{ 0x20000000, 0x00011512, },
	{ 0x00000000, 0x00011514, },	{ 0x20000000, 0x00011516, },
	{ 0x00000000, 0x00011518, },	{ 0x20000000, 0x0001151a, },
	{ 0x00000000, 0x0001151c, },	{ 0x20000000, 0x0001151e, },
	{ 0x00000000, 0x00011620, },	{ 0x20000000, 0x00011622, },
	{ 0x00000000, 0x00011624, },	{ 0x20000000, 0x00011626, },
	{ 0x00000000, 0x00011628, },	{ 0x20000000, 0x0001162a, },
	{ 0x00000000, 0x0001162c, },	{ 0x20000000, 0x0001162e, },
	{ 0x00000000, 0x00011730, },	{ 0x20000000, 0x00011732, },
	{ 0x00000000, 0x00011734, },	{ 0x20000000, 0x00011736, },
	{ 0x00000000, 0x00011738, },	{ 0x20000000, 0x0001173a, },
	{ 0x00000000, 0x0001173c, },	{ 0x20000000, 0x0001173e, },
	{ 0x00000000, 0x00011800, },	{ 0x20000000, 0x00011802, },
	{ 0x00000000, 0x00011804, },	{ 0x20000000, 0x00011806, },
	{ 0x00000000, 0x00011808, },	{ 0x20000000, 0x0001180a, },
	{ 0x00000000, 0x0001180c, },	{ 0x20000000, 0x0001180e, },
	{ 0x00000000, 0x00011910, },	{ 0x20000000, 0x00011912, },
	{ 0x00000000, 0x00011914, },	{ 0x20000000, 0x00011916, },
	{ 0x00000000, 0x00011918, },	{ 0x20000000, 0x0001191a, },
	{ 0x00000000, 0x0001191c, },	{ 0x20000000, 0x0001191e, },
	{ 0x00000000, 0x00011a20, },	{ 0x20000000, 0x00011a22, },
	{ 0x00000000, 0x00011a24, },	{ 0x20000000, 0x00011a26, },
	{ 0x00000000, 0x00011a28, },	{ 0x20000000, 0x00011a2a, },
	{ 0x00000000, 0x00011a2c, },	{ 0x20000000, 0x00011a2e, },
	{ 0x00000000, 0x00011b30, },	{ 0x20000000, 0x00011b32, },
	{ 0x00000000, 0x00011b34, },	{ 0x20000000, 0x00011b36, },
	{ 0x00000000, 0x00011b38, },	{ 0x20000000, 0x00011b3a, },
	{ 0x00000000, 0x00011b3c, },	{ 0x20000000, 0x00011b3e, },
	{ 0x00000000, 0x00011c00, },	{ 0x20000000, 0x00011c02, },
	{ 0x00000000, 0x00011c04, },	{ 0x20000000, 0x00011c06, },
	{ 0x00000000, 0x00011c08, },	{ 0x20000000, 0x00011c0a, },
	{ 0x00000000, 0x00011c0c, },	{ 0x20000000, 0x00011c0e, },
	{ 0x00000000, 0x00011d10, },	{ 0x20000000, 0x00011d12, },
	{ 0x00000000, 0x00011d14, },	{ 0x20000000, 0x00011d16, },
	{ 0x00000000, 0x00011d18, },	{ 0x20000000, 0x00011d1a, },
	{ 0x00000000, 0x00011d1c, },	{ 0x20000000, 0x00011d1e, },
	{ 0x00000000, 0x00011e20, },	{ 0x20000000, 0x00011e22, },
	{ 0x00000000, 0x00011e24, },	{ 0x20000000, 0x00011e26, },
	{ 0x00000000, 0x00011e28, },	{ 0x20000000, 0x00011e2a, },
	{ 0x00000000, 0x00011e2c, },	{ 0x20000000, 0x00011e2e, },
	{ 0x00000000, 0x00011f30, },	{ 0x20000000, 0x00011f32, },
	{ 0x00000000, 0x00011f34, },	{ 0x20000000, 0x00011f36, },
	{ 0x00000000, 0x00011f38, },	{ 0x20000000, 0x00011f3a, },
	{ 0x00000000, 0x00011f3c, },	{ 0x20000000, 0x00011f3e, }, }
};

/*
 * The 8 selection functions.
 * 8 functions to map 6 bits to 64 bits
 */
const static	u_long  S_tab[8][64] = {
	{
		0xe0000000, 0x00000000, 0x40000000, 0xf0000000, 
		0xd0000000, 0x70000000, 0x10000000, 0x40000000, 
		0x20000000, 0xe0000000, 0xf0000000, 0x20000000, 
		0xb0000000, 0xd0000000, 0x80000000, 0x10000000, 
		0x30000000, 0xa0000000, 0xa0000000, 0x60000000, 
		0x60000000, 0xc0000000, 0xc0000000, 0xb0000000, 
		0x50000000, 0x90000000, 0x90000000, 0x50000000, 
		0x00000000, 0x30000000, 0x70000000, 0x80000000, 
		0x40000000, 0xf0000000, 0x10000000, 0xc0000000, 
		0xe0000000, 0x80000000, 0x80000000, 0x20000000, 
		0xd0000000, 0x40000000, 0x60000000, 0x90000000, 
		0x20000000, 0x10000000, 0xb0000000, 0x70000000, 
		0xf0000000, 0x50000000, 0xc0000000, 0xb0000000, 
		0x90000000, 0x30000000, 0x70000000, 0xe0000000, 
		0x30000000, 0xa0000000, 0xa0000000, 0x00000000, 
		0x50000000, 0x60000000, 0x00000000, 0xd0000000, 
	},
	{
		0x0f000000, 0x03000000, 0x01000000, 0x0d000000, 
		0x08000000, 0x04000000, 0x0e000000, 0x07000000, 
		0x06000000, 0x0f000000, 0x0b000000, 0x02000000, 
		0x03000000, 0x08000000, 0x04000000, 0x0e000000, 
		0x09000000, 0x0c000000, 0x07000000, 0x00000000, 
		0x02000000, 0x01000000, 0x0d000000, 0x0a000000, 
		0x0c000000, 0x06000000, 0x00000000, 0x09000000, 
		0x05000000, 0x0b000000, 0x0a000000, 0x05000000, 
		0x00000000, 0x0d000000, 0x0e000000, 0x08000000, 
		0x07000000, 0x0a000000, 0x0b000000, 0x01000000, 
		0x0a000000, 0x03000000, 0x04000000, 0x0f000000, 
		0x0d000000, 0x04000000, 0x01000000, 0x02000000, 
		0x05000000, 0x0b000000, 0x08000000, 0x06000000, 
		0x0c000000, 0x07000000, 0x06000000, 0x0c000000, 
		0x09000000, 0x00000000, 0x03000000, 0x05000000, 
		0x02000000, 0x0e000000, 0x0f000000, 0x09000000, 
	},
	{
		0x00a00000, 0x00d00000, 0x00000000, 0x00700000, 
		0x00900000, 0x00000000, 0x00e00000, 0x00900000, 
		0x00600000, 0x00300000, 0x00300000, 0x00400000, 
		0x00f00000, 0x00600000, 0x00500000, 0x00a00000, 
		0x00100000, 0x00200000, 0x00d00000, 0x00800000, 
		0x00c00000, 0x00500000, 0x00700000, 0x00e00000, 
		0x00b00000, 0x00c00000, 0x00400000, 0x00b00000, 
		0x00200000, 0x00f00000, 0x00800000, 0x00100000, 
		0x00d00000, 0x00100000, 0x00600000, 0x00a00000, 
		0x00400000, 0x00d00000, 0x00900000, 0x00000000, 
		0x00800000, 0x00600000, 0x00f00000, 0x00900000, 
		0x00300000, 0x00800000, 0x00000000, 0x00700000, 
		0x00b00000, 0x00400000, 0x00100000, 0x00f00000, 
		0x00200000, 0x00e00000, 0x00c00000, 0x00300000, 
		0x00500000, 0x00b00000, 0x00a00000, 0x00500000, 
		0x00e00000, 0x00200000, 0x00700000, 0x00c00000, 
	},
	{
		0x00070000, 0x000d0000, 0x000d0000, 0x00080000, 
		0x000e0000, 0x000b0000, 0x00030000, 0x00050000, 
		0x00000000, 0x00060000, 0x00060000, 0x000f0000, 
		0x00090000, 0x00000000, 0x000a0000, 0x00030000, 
		0x00010000, 0x00040000, 0x00020000, 0x00070000, 
		0x00080000, 0x00020000, 0x00050000, 0x000c0000, 
		0x000b0000, 0x00010000, 0x000c0000, 0x000a0000, 
		0x00040000, 0x000e0000, 0x000f0000, 0x00090000, 
		0x000a0000, 0x00030000, 0x00060000, 0x000f0000, 
		0x00090000, 0x00000000, 0x00000000, 0x00060000, 
		0x000c0000, 0x000a0000, 0x000b0000, 0x00010000, 
		0x00070000, 0x000d0000, 0x000d0000, 0x00080000, 
		0x000f0000, 0x00090000, 0x00010000, 0x00040000, 
		0x00030000, 0x00050000, 0x000e0000, 0x000b0000, 
		0x00050000, 0x000c0000, 0x00020000, 0x00070000, 
		0x00080000, 0x00020000, 0x00040000, 0x000e0000, 
	},
	{
		0x00002000, 0x0000e000, 0x0000c000, 0x0000b000, 
		0x00004000, 0x00002000, 0x00001000, 0x0000c000, 
		0x00007000, 0x00004000, 0x0000a000, 0x00007000, 
		0x0000b000, 0x0000d000, 0x00006000, 0x00001000, 
		0x00008000, 0x00005000, 0x00005000, 0x00000000, 
		0x00003000, 0x0000f000, 0x0000f000, 0x0000a000, 
		0x0000d000, 0x00003000, 0x00000000, 0x00009000, 
		0x0000e000, 0x00008000, 0x00009000, 0x00006000, 
		0x00004000, 0x0000b000, 0x00002000, 0x00008000, 
		0x00001000, 0x0000c000, 0x0000b000, 0x00007000, 
		0x0000a000, 0x00001000, 0x0000d000, 0x0000e000, 
		0x00007000, 0x00002000, 0x00008000, 0x0000d000, 
		0x0000f000, 0x00006000, 0x00009000, 0x0000f000, 
		0x0000c000, 0x00000000, 0x00005000, 0x00009000, 
		0x00006000, 0x0000a000, 0x00003000, 0x00004000, 
		0x00000000, 0x00005000, 0x0000e000, 0x00003000, 
	},
	{
		0x00000c00, 0x00000a00, 0x00000100, 0x00000f00, 
		0x00000a00, 0x00000400, 0x00000f00, 0x00000200, 
		0x00000900, 0x00000700, 0x00000200, 0x00000c00, 
		0x00000600, 0x00000900, 0x00000800, 0x00000500, 
		0x00000000, 0x00000600, 0x00000d00, 0x00000100, 
		0x00000300, 0x00000d00, 0x00000400, 0x00000e00, 
		0x00000e00, 0x00000000, 0x00000700, 0x00000b00, 
		0x00000500, 0x00000300, 0x00000b00, 0x00000800, 
		0x00000900, 0x00000400, 0x00000e00, 0x00000300, 
		0x00000f00, 0x00000200, 0x00000500, 0x00000c00, 
		0x00000200, 0x00000900, 0x00000800, 0x00000500, 
		0x00000c00, 0x00000f00, 0x00000300, 0x00000a00, 
		0x00000700, 0x00000b00, 0x00000000, 0x00000e00, 
		0x00000400, 0x00000100, 0x00000a00, 0x00000700, 
		0x00000100, 0x00000600, 0x00000d00, 0x00000000, 
		0x00000b00, 0x00000800, 0x00000600, 0x00000d00, 
	},
	{
		0x00000040, 0x000000d0, 0x000000b0, 0x00000000, 
		0x00000020, 0x000000b0, 0x000000e0, 0x00000070, 
		0x000000f0, 0x00000040, 0x00000000, 0x00000090, 
		0x00000080, 0x00000010, 0x000000d0, 0x000000a0, 
		0x00000030, 0x000000e0, 0x000000c0, 0x00000030, 
		0x00000090, 0x00000050, 0x00000070, 0x000000c0, 
		0x00000050, 0x00000020, 0x000000a0, 0x000000f0, 
		0x00000060, 0x00000080, 0x00000010, 0x00000060, 
		0x00000010, 0x00000060, 0x00000040, 0x000000b0, 
		0x000000b0, 0x000000d0, 0x000000d0, 0x00000080, 
		0x000000c0, 0x00000010, 0x00000030, 0x00000040, 
		0x00000070, 0x000000a0, 0x000000e0, 0x00000070, 
		0x000000a0, 0x00000090, 0x000000f0, 0x00000050, 
		0x00000060, 0x00000000, 0x00000080, 0x000000f0, 
		0x00000000, 0x000000e0, 0x00000050, 0x00000020, 
		0x00000090, 0x00000030, 0x00000020, 0x000000c0, 
	},
	{
		0x0000000d, 0x00000001, 0x00000002, 0x0000000f, 
		0x00000008, 0x0000000d, 0x00000004, 0x00000008, 
		0x00000006, 0x0000000a, 0x0000000f, 0x00000003, 
		0x0000000b, 0x00000007, 0x00000001, 0x00000004, 
		0x0000000a, 0x0000000c, 0x00000009, 0x00000005, 
		0x00000003, 0x00000006, 0x0000000e, 0x0000000b, 
		0x00000005, 0x00000000, 0x00000000, 0x0000000e, 
		0x0000000c, 0x00000009, 0x00000007, 0x00000002, 
		0x00000007, 0x00000002, 0x0000000b, 0x00000001, 
		0x00000004, 0x0000000e, 0x00000001, 0x00000007, 
		0x00000009, 0x00000004, 0x0000000c, 0x0000000a, 
		0x0000000e, 0x00000008, 0x00000002, 0x0000000d, 
		0x00000000, 0x0000000f, 0x00000006, 0x0000000c, 
		0x0000000a, 0x00000009, 0x0000000d, 0x00000000, 
		0x0000000f, 0x00000003, 0x00000003, 0x00000005, 
		0x00000005, 0x00000006, 0x00000008, 0x0000000b, 
	},
};

/*
 * Permute 32 bit output of S boxes
 */
const static	u_long	P_tab[4][256] = {
	0x00000000, 0x00004000, 0x40000000, 0x40004000,
	0x00000010, 0x00004010, 0x40000010, 0x40004010,
	0x00080000, 0x00084000, 0x40080000, 0x40084000,
	0x00080010, 0x00084010, 0x40080010, 0x40084010,
	0x00000002, 0x00004002, 0x40000002, 0x40004002,
	0x00000012, 0x00004012, 0x40000012, 0x40004012,
	0x00080002, 0x00084002, 0x40080002, 0x40084002,
	0x00080012, 0x00084012, 0x40080012, 0x40084012,
	0x00000200, 0x00004200, 0x40000200, 0x40004200,
	0x00000210, 0x00004210, 0x40000210, 0x40004210,
	0x00080200, 0x00084200, 0x40080200, 0x40084200,
	0x00080210, 0x00084210, 0x40080210, 0x40084210,
	0x00000202, 0x00004202, 0x40000202, 0x40004202,
	0x00000212, 0x00004212, 0x40000212, 0x40004212,
	0x00080202, 0x00084202, 0x40080202, 0x40084202,
	0x00080212, 0x00084212, 0x40080212, 0x40084212,
	0x00008000, 0x0000c000, 0x40008000, 0x4000c000,
	0x00008010, 0x0000c010, 0x40008010, 0x4000c010,
	0x00088000, 0x0008c000, 0x40088000, 0x4008c000,
	0x00088010, 0x0008c010, 0x40088010, 0x4008c010,
	0x00008002, 0x0000c002, 0x40008002, 0x4000c002,
	0x00008012, 0x0000c012, 0x40008012, 0x4000c012,
	0x00088002, 0x0008c002, 0x40088002, 0x4008c002,
	0x00088012, 0x0008c012, 0x40088012, 0x4008c012,
	0x00008200, 0x0000c200, 0x40008200, 0x4000c200,
	0x00008210, 0x0000c210, 0x40008210, 0x4000c210,
	0x00088200, 0x0008c200, 0x40088200, 0x4008c200,
	0x00088210, 0x0008c210, 0x40088210, 0x4008c210,
	0x00008202, 0x0000c202, 0x40008202, 0x4000c202,
	0x00008212, 0x0000c212, 0x40008212, 0x4000c212,
	0x00088202, 0x0008c202, 0x40088202, 0x4008c202,
	0x00088212, 0x0008c212, 0x40088212, 0x4008c212,
	0x00800000, 0x00804000, 0x40800000, 0x40804000,
	0x00800010, 0x00804010, 0x40800010, 0x40804010,
	0x00880000, 0x00884000, 0x40880000, 0x40884000,
	0x00880010, 0x00884010, 0x40880010, 0x40884010,
	0x00800002, 0x00804002, 0x40800002, 0x40804002,
	0x00800012, 0x00804012, 0x40800012, 0x40804012,
	0x00880002, 0x00884002, 0x40880002, 0x40884002,
	0x00880012, 0x00884012, 0x40880012, 0x40884012,
	0x00800200, 0x00804200, 0x40800200, 0x40804200,
	0x00800210, 0x00804210, 0x40800210, 0x40804210,
	0x00880200, 0x00884200, 0x40880200, 0x40884200,
	0x00880210, 0x00884210, 0x40880210, 0x40884210,
	0x00800202, 0x00804202, 0x40800202, 0x40804202,
	0x00800212, 0x00804212, 0x40800212, 0x40804212,
	0x00880202, 0x00884202, 0x40880202, 0x40884202,
	0x00880212, 0x00884212, 0x40880212, 0x40884212,
	0x00808000, 0x0080c000, 0x40808000, 0x4080c000,
	0x00808010, 0x0080c010, 0x40808010, 0x4080c010,
	0x00888000, 0x0088c000, 0x40888000, 0x4088c000,
	0x00888010, 0x0088c010, 0x40888010, 0x4088c010,
	0x00808002, 0x0080c002, 0x40808002, 0x4080c002,
	0x00808012, 0x0080c012, 0x40808012, 0x4080c012,
	0x00888002, 0x0088c002, 0x40888002, 0x4088c002,
	0x00888012, 0x0088c012, 0x40888012, 0x4088c012,
	0x00808200, 0x0080c200, 0x40808200, 0x4080c200,
	0x00808210, 0x0080c210, 0x40808210, 0x4080c210,
	0x00888200, 0x0088c200, 0x40888200, 0x4088c200,
	0x00888210, 0x0088c210, 0x40888210, 0x4088c210,
	0x00808202, 0x0080c202, 0x40808202, 0x4080c202,
	0x00808212, 0x0080c212, 0x40808212, 0x4080c212,
	0x00888202, 0x0088c202, 0x40888202, 0x4088c202,
	0x00888212, 0x0088c212, 0x40888212, 0x4088c212,
	0x00000000, 0x80000000, 0x00400000, 0x80400000,
	0x00001000, 0x80001000, 0x00401000, 0x80401000,
	0x00000040, 0x80000040, 0x00400040, 0x80400040,
	0x00001040, 0x80001040, 0x00401040, 0x80401040,
	0x04000000, 0x84000000, 0x04400000, 0x84400000,
	0x04001000, 0x84001000, 0x04401000, 0x84401000,
	0x04000040, 0x84000040, 0x04400040, 0x84400040,
	0x04001040, 0x84001040, 0x04401040, 0x84401040,
	0x00000004, 0x80000004, 0x00400004, 0x80400004,
	0x00001004, 0x80001004, 0x00401004, 0x80401004,
	0x00000044, 0x80000044, 0x00400044, 0x80400044,
	0x00001044, 0x80001044, 0x00401044, 0x80401044,
	0x04000004, 0x84000004, 0x04400004, 0x84400004,
	0x04001004, 0x84001004, 0x04401004, 0x84401004,
	0x04000044, 0x84000044, 0x04400044, 0x84400044,
	0x04001044, 0x84001044, 0x04401044, 0x84401044,
	0x00010000, 0x80010000, 0x00410000, 0x80410000,
	0x00011000, 0x80011000, 0x00411000, 0x80411000,
	0x00010040, 0x80010040, 0x00410040, 0x80410040,
	0x00011040, 0x80011040, 0x00411040, 0x80411040,
	0x04010000, 0x84010000, 0x04410000, 0x84410000,
	0x04011000, 0x84011000, 0x04411000, 0x84411000,
	0x04010040, 0x84010040, 0x04410040, 0x84410040,
	0x04011040, 0x84011040, 0x04411040, 0x84411040,
	0x00010004, 0x80010004, 0x00410004, 0x80410004,
	0x00011004, 0x80011004, 0x00411004, 0x80411004,
	0x00010044, 0x80010044, 0x00410044, 0x80410044,
	0x00011044, 0x80011044, 0x00411044, 0x80411044,
	0x04010004, 0x84010004, 0x04410004, 0x84410004,
	0x04011004, 0x84011004, 0x04411004, 0x84411004,
	0x04010044, 0x84010044, 0x04410044, 0x84410044,
	0x04011044, 0x84011044, 0x04411044, 0x84411044,
	0x00000100, 0x80000100, 0x00400100, 0x80400100,
	0x00001100, 0x80001100, 0x00401100, 0x80401100,
	0x00000140, 0x80000140, 0x00400140, 0x80400140,
	0x00001140, 0x80001140, 0x00401140, 0x80401140,
	0x04000100, 0x84000100, 0x04400100, 0x84400100,
	0x04001100, 0x84001100, 0x04401100, 0x84401100,
	0x04000140, 0x84000140, 0x04400140, 0x84400140,
	0x04001140, 0x84001140, 0x04401140, 0x84401140,
	0x00000104, 0x80000104, 0x00400104, 0x80400104,
	0x00001104, 0x80001104, 0x00401104, 0x80401104,
	0x00000144, 0x80000144, 0x00400144, 0x80400144,
	0x00001144, 0x80001144, 0x00401144, 0x80401144,
	0x04000104, 0x84000104, 0x04400104, 0x84400104,
	0x04001104, 0x84001104, 0x04401104, 0x84401104,
	0x04000144, 0x84000144, 0x04400144, 0x84400144,
	0x04001144, 0x84001144, 0x04401144, 0x84401144,
	0x00010100, 0x80010100, 0x00410100, 0x80410100,
	0x00011100, 0x80011100, 0x00411100, 0x80411100,
	0x00010140, 0x80010140, 0x00410140, 0x80410140,
	0x00011140, 0x80011140, 0x00411140, 0x80411140,
	0x04010100, 0x84010100, 0x04410100, 0x84410100,
	0x04011100, 0x84011100, 0x04411100, 0x84411100,
	0x04010140, 0x84010140, 0x04410140, 0x84410140,
	0x04011140, 0x84011140, 0x04411140, 0x84411140,
	0x00010104, 0x80010104, 0x00410104, 0x80410104,
	0x00011104, 0x80011104, 0x00411104, 0x80411104,
	0x00010144, 0x80010144, 0x00410144, 0x80410144,
	0x00011144, 0x80011144, 0x00411144, 0x80411144,
	0x04010104, 0x84010104, 0x04410104, 0x84410104,
	0x04011104, 0x84011104, 0x04411104, 0x84411104,
	0x04010144, 0x84010144, 0x04410144, 0x84410144,
	0x04011144, 0x84011144, 0x04411144, 0x84411144,
	0x00000000, 0x00002000, 0x00200000, 0x00202000,
	0x00000008, 0x00002008, 0x00200008, 0x00202008,
	0x10000000, 0x10002000, 0x10200000, 0x10202000,
	0x10000008, 0x10002008, 0x10200008, 0x10202008,
	0x20000000, 0x20002000, 0x20200000, 0x20202000,
	0x20000008, 0x20002008, 0x20200008, 0x20202008,
	0x30000000, 0x30002000, 0x30200000, 0x30202000,
	0x30000008, 0x30002008, 0x30200008, 0x30202008,
	0x00000080, 0x00002080, 0x00200080, 0x00202080,
	0x00000088, 0x00002088, 0x00200088, 0x00202088,
	0x10000080, 0x10002080, 0x10200080, 0x10202080,
	0x10000088, 0x10002088, 0x10200088, 0x10202088,
	0x20000080, 0x20002080, 0x20200080, 0x20202080,
	0x20000088, 0x20002088, 0x20200088, 0x20202088,
	0x30000080, 0x30002080, 0x30200080, 0x30202080,
	0x30000088, 0x30002088, 0x30200088, 0x30202088,
	0x00040000, 0x00042000, 0x00240000, 0x00242000,
	0x00040008, 0x00042008, 0x00240008, 0x00242008,
	0x10040000, 0x10042000, 0x10240000, 0x10242000,
	0x10040008, 0x10042008, 0x10240008, 0x10242008,
	0x20040000, 0x20042000, 0x20240000, 0x20242000,
	0x20040008, 0x20042008, 0x20240008, 0x20242008,
	0x30040000, 0x30042000, 0x30240000, 0x30242000,
	0x30040008, 0x30042008, 0x30240008, 0x30242008,
	0x00040080, 0x00042080, 0x00240080, 0x00242080,
	0x00040088, 0x00042088, 0x00240088, 0x00242088,
	0x10040080, 0x10042080, 0x10240080, 0x10242080,
	0x10040088, 0x10042088, 0x10240088, 0x10242088,
	0x20040080, 0x20042080, 0x20240080, 0x20242080,
	0x20040088, 0x20042088, 0x20240088, 0x20242088,
	0x30040080, 0x30042080, 0x30240080, 0x30242080,
	0x30040088, 0x30042088, 0x30240088, 0x30242088,
	0x01000000, 0x01002000, 0x01200000, 0x01202000,
	0x01000008, 0x01002008, 0x01200008, 0x01202008,
	0x11000000, 0x11002000, 0x11200000, 0x11202000,
	0x11000008, 0x11002008, 0x11200008, 0x11202008,
	0x21000000, 0x21002000, 0x21200000, 0x21202000,
	0x21000008, 0x21002008, 0x21200008, 0x21202008,
	0x31000000, 0x31002000, 0x31200000, 0x31202000,
	0x31000008, 0x31002008, 0x31200008, 0x31202008,
	0x01000080, 0x01002080, 0x01200080, 0x01202080,
	0x01000088, 0x01002088, 0x01200088, 0x01202088,
	0x11000080, 0x11002080, 0x11200080, 0x11202080,
	0x11000088, 0x11002088, 0x11200088, 0x11202088,
	0x21000080, 0x21002080, 0x21200080, 0x21202080,
	0x21000088, 0x21002088, 0x21200088, 0x21202088,
	0x31000080, 0x31002080, 0x31200080, 0x31202080,
	0x31000088, 0x31002088, 0x31200088, 0x31202088,
	0x01040000, 0x01042000, 0x01240000, 0x01242000,
	0x01040008, 0x01042008, 0x01240008, 0x01242008,
	0x11040000, 0x11042000, 0x11240000, 0x11242000,
	0x11040008, 0x11042008, 0x11240008, 0x11242008,
	0x21040000, 0x21042000, 0x21240000, 0x21242000,
	0x21040008, 0x21042008, 0x21240008, 0x21242008,
	0x31040000, 0x31042000, 0x31240000, 0x31242000,
	0x31040008, 0x31042008, 0x31240008, 0x31242008,
	0x01040080, 0x01042080, 0x01240080, 0x01242080,
	0x01040088, 0x01042088, 0x01240088, 0x01242088,
	0x11040080, 0x11042080, 0x11240080, 0x11242080,
	0x11040088, 0x11042088, 0x11240088, 0x11242088,
	0x21040080, 0x21042080, 0x21240080, 0x21242080,
	0x21040088, 0x21042088, 0x21240088, 0x21242088,
	0x31040080, 0x31042080, 0x31240080, 0x31242080,
	0x31040088, 0x31042088, 0x31240088, 0x31242088,
	0x00000000, 0x00000800, 0x00020000, 0x00020800,
	0x00000020, 0x00000820, 0x00020020, 0x00020820,
	0x08000000, 0x08000800, 0x08020000, 0x08020800,
	0x08000020, 0x08000820, 0x08020020, 0x08020820,
	0x02000000, 0x02000800, 0x02020000, 0x02020800,
	0x02000020, 0x02000820, 0x02020020, 0x02020820,
	0x0a000000, 0x0a000800, 0x0a020000, 0x0a020800,
	0x0a000020, 0x0a000820, 0x0a020020, 0x0a020820,
	0x00000400, 0x00000c00, 0x00020400, 0x00020c00,
	0x00000420, 0x00000c20, 0x00020420, 0x00020c20,
	0x08000400, 0x08000c00, 0x08020400, 0x08020c00,
	0x08000420, 0x08000c20, 0x08020420, 0x08020c20,
	0x02000400, 0x02000c00, 0x02020400, 0x02020c00,
	0x02000420, 0x02000c20, 0x02020420, 0x02020c20,
	0x0a000400, 0x0a000c00, 0x0a020400, 0x0a020c00,
	0x0a000420, 0x0a000c20, 0x0a020420, 0x0a020c20,
	0x00100000, 0x00100800, 0x00120000, 0x00120800,
	0x00100020, 0x00100820, 0x00120020, 0x00120820,
	0x08100000, 0x08100800, 0x08120000, 0x08120800,
	0x08100020, 0x08100820, 0x08120020, 0x08120820,
	0x02100000, 0x02100800, 0x02120000, 0x02120800,
	0x02100020, 0x02100820, 0x02120020, 0x02120820,
	0x0a100000, 0x0a100800, 0x0a120000, 0x0a120800,
	0x0a100020, 0x0a100820, 0x0a120020, 0x0a120820,
	0x00100400, 0x00100c00, 0x00120400, 0x00120c00,
	0x00100420, 0x00100c20, 0x00120420, 0x00120c20,
	0x08100400, 0x08100c00, 0x08120400, 0x08120c00,
	0x08100420, 0x08100c20, 0x08120420, 0x08120c20,
	0x02100400, 0x02100c00, 0x02120400, 0x02120c00,
	0x02100420, 0x02100c20, 0x02120420, 0x02120c20,
	0x0a100400, 0x0a100c00, 0x0a120400, 0x0a120c00,
	0x0a100420, 0x0a100c20, 0x0a120420, 0x0a120c20,
	0x00000001, 0x00000801, 0x00020001, 0x00020801,
	0x00000021, 0x00000821, 0x00020021, 0x00020821,
	0x08000001, 0x08000801, 0x08020001, 0x08020801,
	0x08000021, 0x08000821, 0x08020021, 0x08020821,
	0x02000001, 0x02000801, 0x02020001, 0x02020801,
	0x02000021, 0x02000821, 0x02020021, 0x02020821,
	0x0a000001, 0x0a000801, 0x0a020001, 0x0a020801,
	0x0a000021, 0x0a000821, 0x0a020021, 0x0a020821,
	0x00000401, 0x00000c01, 0x00020401, 0x00020c01,
	0x00000421, 0x00000c21, 0x00020421, 0x00020c21,
	0x08000401, 0x08000c01, 0x08020401, 0x08020c01,
	0x08000421, 0x08000c21, 0x08020421, 0x08020c21,
	0x02000401, 0x02000c01, 0x02020401, 0x02020c01,
	0x02000421, 0x02000c21, 0x02020421, 0x02020c21,
	0x0a000401, 0x0a000c01, 0x0a020401, 0x0a020c01,
	0x0a000421, 0x0a000c21, 0x0a020421, 0x0a020c21,
	0x00100001, 0x00100801, 0x00120001, 0x00120801,
	0x00100021, 0x00100821, 0x00120021, 0x00120821,
	0x08100001, 0x08100801, 0x08120001, 0x08120801,
	0x08100021, 0x08100821, 0x08120021, 0x08120821,
	0x02100001, 0x02100801, 0x02120001, 0x02120801,
	0x02100021, 0x02100821, 0x02120021, 0x02120821,
	0x0a100001, 0x0a100801, 0x0a120001, 0x0a120801,
	0x0a100021, 0x0a100821, 0x0a120021, 0x0a120821,
	0x00100401, 0x00100c01, 0x00120401, 0x00120c01,
	0x00100421, 0x00100c21, 0x00120421, 0x00120c21,
	0x08100401, 0x08100c01, 0x08120401, 0x08120c01,
	0x08100421, 0x08100c21, 0x08120421, 0x08120c21,
	0x02100401, 0x02100c01, 0x02120401, 0x02120c01,
	0x02100421, 0x02100c21, 0x02120421, 0x02120c21,
	0x0a100401, 0x0a100c01, 0x0a120401, 0x0a120c01,
	0x0a100421, 0x0a100c21, 0x0a120421, 0x0a120c21,
};

#endif /* _NET_DES_DESDATA_H */
