/*	Copyright (c) 1990, 1991, 1992, 1993, 1994, 1995 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)libnsl:common/lib/libnsl/rpc/svc_generic.c	1.7.12.5"
#ident	"$Header: $"

/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 *
 * Copyright (c) 1986-1991 by Sun Microsystems Inc.
 */

/*
 * svc_generic.c
 *
 * Server side for RPC.
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <rpc/rpc.h>
#include <sys/types.h>
#include "trace.h"
#include <errno.h>
#include <sys/syslog.h>
#include <rpc/nettype.h>
#include <malloc.h>
#include "rpc_mt.h"

/*
 * The highest level interface for server creation.
 * It tries for all the nettokens in that particular class of token
 * and returns the number of handles it can create and/or find.
 *
 * It creates a link list of all the handles it could create.
 * If svc_create() is called multiple times, it uses the handle
 * created earlier instead of creating a new handle every time.
 */
int
svc_create(dispatch, prognum, versnum, nettype)
	void (*dispatch)();	/* Dispatch function */
	u_long prognum;		/* Program number */
	u_long versnum;		/* Version number */
	char *nettype;		/* Networktype token */
{
	struct xlist {
		SVCXPRT *xprt;		/* Server handle */
		struct xlist *next;	/* Next item */
	} *l;
	static struct xlist *xprtlist;	/* A link list of all the handles */
	int num = 0;
	SVCXPRT *xprt;
	struct netconfig *nconf;
	void *handle;

	trace3(TR_svc_create, 0, prognum, versnum);
	if ((handle = _rpc_setconf(nettype)) == NULL) {
		(void) syslog(LOG_ERR,
		    gettxt("uxnsl:102",
			"svc_create: unknown protocol"));
		trace3(TR_svc_create, 1, prognum, versnum);
		return (0);
	}
	MUTEX_LOCK(&__list_lock);
	while (nconf = _rpc_getconf(handle)) {
		for (l = xprtlist; l; l = l->next) {
			if (strcmp(l->xprt->xp_netid, nconf->nc_netid) == 0) {
				/* Found an old one, use it */
				(void) rpcb_unset(prognum, versnum, nconf);
				if (svc_reg(l->xprt, prognum, versnum,
					dispatch, nconf) == FALSE)
					(void) syslog(LOG_ERR,
					    gettxt("uxnsl:103",
	  "svc_create: could not register program %d version %d on network %s"),
					    prognum, versnum, nconf->nc_netid);
				else
					num++;
				break;
			}
		}
		if (l == (struct xlist *)NULL) {
			/* It was not found. Now create a new one */
			xprt = svc_tp_create(dispatch, prognum, versnum, nconf);
			if (xprt) {
				l = (struct xlist *)malloc(sizeof
						(struct xlist));
				if (l == (struct xlist *)NULL) {
					MUTEX_UNLOCK(&__list_lock);
					_rpc_endconf(handle);
					(void) syslog(LOG_ERR,
					    gettxt("uxnsl:32",
						"%s: out of memory"),
					    "svc_create");
					trace3(TR_svc_create, 1, prognum,
						versnum);
					return (0);
				}
				l->xprt = xprt;
				l->next = xprtlist;
				xprtlist = l;
				num++;
			}
		}
	}
	MUTEX_UNLOCK(&__list_lock);
	_rpc_endconf(handle);
	/*
	 * In case of num == 0; the error messages are generated by the
	 * underlying layers; and hence not needed here.
	 */
	trace3(TR_svc_create, 1, prognum, versnum);
	return (num);
}

/*
 * The high level interface to svc_tli_create().
 * It tries to create a server for "nconf" and registers the service
 * with the rpcbind. It calls svc_tli_create();
 */
SVCXPRT *
svc_tp_create(dispatch, prognum, versnum, nconf)
	void (*dispatch)();	/* Dispatch function */
	u_long prognum;		/* Program number */
	u_long versnum;		/* Version number */
	struct netconfig *nconf; /* Netconfig structure for the network */
{
	SVCXPRT *xprt;

	trace3(TR_svc_tp_create, 0, prognum, versnum);
	if (nconf == (struct netconfig *)NULL) {
		(void) syslog(LOG_ERR,
		    gettxt("uxnsl:104",
	"svc_tp_create: invalid netconfig structure for program %d version %d"),
		    prognum, versnum);
		trace3(TR_svc_tp_create, 1, prognum, versnum);
		return ((SVCXPRT *)NULL);
	}
	xprt = svc_tli_create(RPC_ANYFD, nconf, (struct t_bind *)NULL, 0, 0);
	if (xprt == (SVCXPRT *)NULL) {
		trace3(TR_svc_tp_create, 1, prognum, versnum);
		return ((SVCXPRT *)NULL);
	}
	(void) rpcb_unset(prognum, versnum, nconf);
	if (svc_reg(xprt, prognum, versnum, dispatch, nconf) == FALSE) {
		(void) syslog(LOG_ERR,
		    gettxt("uxnsl:105",
	       "svc_tp_create: could not register program %d version %d on %s"),
		    prognum, versnum, nconf->nc_netid);
		SVC_DESTROY(xprt);
		trace3(TR_svc_tp_create, 1, prognum, versnum);
		return ((SVCXPRT *)NULL);
	}
	trace3(TR_svc_tp_create, 1, prognum, versnum);
	return (xprt);
}

/*
 * If fd is RPC_ANYFD, then it opens a fd for the given transport
 * provider (nconf cannot be NULL then). If the t_state is T_UNBND and
 * bindaddr is NON-NULL, it performs a t_bind using the bindaddr. For
 * NULL bindaddr and Connection oriented transports, the value of qlen
 * is set to 64 (up from 8).
 *
 * If sendsz or recvsz are zero, their default values are chosen.
 */
SVCXPRT *
svc_tli_create(fd, nconf, bindaddr, sendsz, recvsz)
	register int fd;		/* Connection end point */
	struct netconfig *nconf;	/* Netconfig struct for nettoken */
	struct t_bind *bindaddr;	/* Local bind address */
	u_int sendsz;			/* Max sendsize */
	u_int recvsz;			/* Max recvsize */
{
	register SVCXPRT *xprt = NULL;	/* service handle */
	struct t_info tinfo;		/* transport info */
	struct t_bind *tres = NULL;	/* bind info */
	bool_t madefd = FALSE;		/* whether fd opened here  */
	int state;			/* state of the transport provider */

	trace4(TR_svc_tli_create, 0, fd, sendsz, recvsz);
	if (fd == RPC_ANYFD) {
		if (nconf == (struct netconfig *)NULL) {
			(void) syslog(LOG_ERR,
			    gettxt("uxnsl:106",
				"svc_tli_create: invalid netconfig"));
			trace2(TR_svc_tli_create, 1, fd);
			return ((SVCXPRT *)NULL);
		}
		fd = t_open(nconf->nc_device, O_RDWR, &tinfo);
		if (fd == -1) {
			(void) syslog(LOG_ERR,
			    gettxt("uxnsl:107",
			    "svc_tli_create: could not open connection for %s"),
			    nconf->nc_netid);
			trace2(TR_svc_tli_create, 1, fd);
			return ((SVCXPRT *)NULL);
		}
		madefd = TRUE;
		state = T_UNBND;
	} else {
		/*
		 * It is an open descriptor. Sync it & get the transport info.
		 */
		if ((state = t_sync(fd)) == -1) {
			(void) syslog(LOG_ERR,
			    gettxt("uxnsl:108",
				"svc_tli_create: could not do t_sync: %s"),
			    t_strerror(t_errno));
			trace2(TR_svc_tli_create, 1, fd);
			return ((SVCXPRT *)NULL);
		}
		if (t_getinfo(fd, &tinfo) == -1) {
			(void) syslog(LOG_ERR,
			    gettxt("uxnsl:109",
			"svc_tli_create: could not get transport information"));
			trace2(TR_svc_tli_create, 1, fd);
			return ((SVCXPRT *)NULL);
		}
	}

	/*
	 * If the fd is unbound, try to bind it.
	 * In any case, try to get its bound info in tres
	 */
	tres = (struct t_bind *)t_alloc(fd, T_BIND, T_ADDR);
	if (tres == NULL) {
		(void) syslog(LOG_ERR,
		    gettxt("uxnsl:32", "%s: out of memory"),
		    "svc_tli_create");
		goto freedata;
	}

	switch (state) {
	case T_UNBND:
		if (bindaddr) {
			if (t_bind(fd, bindaddr, tres) == -1) {
				(void) syslog(LOG_ERR,
				    gettxt("uxnsl:110",
					"svc_tli_create: could not t_bind: %s"),
				    t_strerror(t_errno));
				goto freedata;
			}
			/*
			 * Should compare the addresses only if addr.len
			 * was non-zero
			 */
			if (bindaddr->addr.len &&
				(memcmp(bindaddr->addr.buf, tres->addr.buf,
					(int)tres->addr.len) != 0)) {
				(void) syslog(LOG_ERR,
				    gettxt("uxnsl:111",
		   "svc_tli_create: could not t_bind to requested address: %s"),
				    t_strerror(t_errno));
				goto freedata;
			}
		} else {
			tres->qlen = 64; /* changed from 8 to 64 in UW2.0 */
			tres->addr.len = 0;
			if (t_bind(fd, tres, tres) == -1) {
				(void) syslog(LOG_ERR,
				    gettxt("uxnsl:110",
					"svc_tli_create: could not t_bind: %s"),
				    t_strerror(t_errno));
				goto freedata;
			}
		}
		break;

	case T_IDLE:
		if (bindaddr) {
			/* Copy the entire stuff in tres */
			if (tres->addr.maxlen < bindaddr->addr.len) {
				(void) syslog(LOG_ERR,
				    gettxt("uxnsl:112",
				      "svc_tli_create: illegal netbuf length"));
				goto freedata;
			}
			tres->addr.len = bindaddr->addr.len;
			(void) memcpy(tres->addr.buf, bindaddr->addr.buf,
					(int)tres->addr.len);
		} else
			if (t_getname(fd, (struct netbuf *)tres, LOCALNAME)
							== -1)
				tres->addr.len = 0;
		break;
	case T_DATAXFER:
		/*
		 * This takes care of the case where a fd
		 * is passed on which a connection has already
		 * been accepted.
		 */
		if (t_getname(fd, (struct netbuf *)tres, LOCALNAME) == -1)
			tres->addr.len = 0;
		break;
	default:
		(void) syslog(LOG_ERR,
		    gettxt("uxnsl:113",
		      "svc_tli_create: connection in unrecognized state (%d)"),
		    state);
		goto freedata;
	}

	/*
	 * call transport specific function.
	 */
	switch (tinfo.servtype) {
		case T_COTS_ORD:
		case T_COTS:
			if (state == T_DATAXFER)
				xprt = svc_fd_create(fd, sendsz, recvsz);
			else
				xprt = svc_vc_create(fd, sendsz, recvsz);
			break;

		case T_CLTS:
			xprt = svc_dg_create(fd, sendsz, recvsz);
			break;
		default:
			(void) syslog(LOG_ERR,
			    gettxt("uxnsl:114",
				"svc_tli_create: unrecognized service type"));
			goto freedata;
	}
	if (xprt == (SVCXPRT *)NULL)
		/*
		 * The error messages here are spitted out by the lower layers:
		 * svc_vc_create(), svc_fd_create() and svc_dg_create().
		 */
		goto freedata;

	/* fill in the other xprt information */

	/* Assign the local bind address */
	xprt->xp_ltaddr = tres->addr;
	tres->addr.buf = NULL;
	(void) t_free((char *)tres, T_BIND);

	/* Allocate space for the remote bind info */
	xprt->xp_rtaddr.len = 0;
	xprt->xp_rtaddr.maxlen = _rpc_get_a_size(tinfo.addr);
	if ((xprt->xp_rtaddr.buf = mem_alloc(xprt->xp_rtaddr.maxlen)) == NULL) {
		(void) syslog(LOG_ERR,
		    gettxt("uxnsl:32", "%s: out of memory"),
		    "svc_tli_create");
		goto freedata;
	}

	if (nconf) {
		xprt->xp_netid = strdup(nconf->nc_netid);
		xprt->xp_tp = strdup(nconf->nc_device);
	}
	trace2(TR_svc_tli_create, 1, fd);
	return (xprt);

freedata:
	if (madefd)
		(void) t_close(fd);
	if (tres)
		(void) t_free((char *)tres, T_BIND);
	if (xprt) {
		if (!madefd) /* so that svc_destroy doesnt close fd */
			xprt->xp_fd = RPC_ANYFD;
		SVC_DESTROY(xprt);
	}
	trace2(TR_svc_tli_create, 1, fd);
	return ((SVCXPRT *)NULL);
}
