/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)libNwNcp:22s31.c	1.5"
#include "ntypes.h"
#include "nwaccess.h"
#include "unicode.h"
#include "nwclient.h"
#include "ncpfile.h"

/*manpage*NWNCP22s31GetEntryInfo**********************************
SYNTAX:  N_GLOBAL_LIBRARY( NWRCODE )
         NWNCP22s31GetEntryInfo
         (
            pNWAccess          pAccess,
            nuint8            buDirHandle,
            pNWNCPEntryUnion  pEntryInfo,
         );

REMARKS: This function gets the directory entry that is pointed to by the directory
         handle.  This is useful for getting information about the volume root entry.


ARGS: <> pAccess
      >  buDirHandle
      <  pEntryInfo

INCLUDE: ncpfile.h

RETURN:  0x0000  Successful
         0x8989  No Search Privileges
         0x89BF  Invalid Name Space
         0x89FB  386 File Structure Not Supported On Server

SERVER:

CLIENT:  DOS OS2 WIN NT

SEE:     22 00  Set Directory Handle

NCP:     22 31  Get Directory Entry

CHANGES: 9 Sep 1993 - written - dromrell
----------------------------------------------------------------------------
         Copyright (c) 1993 by Novell, Inc. All rights reserved
***************************************************************************/
N_GLOBAL_LIBRARY( NWRCODE )
NWNCP22s31GetEntryInfo
(
   pNWAccess          pAccess,
   nuint8            buDirHandle,
   pNWNCPEntryUnion  pEntryInfo
)
{
   #define NCP_FUNCTION    ((nuint) 22)
   #define NCP_SUBFUNCTION ((nuint8) 31)
   #define NCP_STRUCT_LEN  ((nuint16) 2)
   #define NCP_REQ_LEN     ((nuint) (2 + NCP_STRUCT_LEN))
   #define NCP_REPLY_LEN   ((nuint) 333)

   nint32   lCode;
   nuint16 suNCPLen;
   nuint8 abuReq[4], abuRep[333];

   suNCPLen = NCP_STRUCT_LEN;
   NCopyHiLo16(&abuReq[0],&suNCPLen);
   abuReq[2] = NCP_SUBFUNCTION;
   abuReq[3] = buDirHandle;

   lCode = NWCRequestSingle(pAccess, NCP_FUNCTION, abuReq, NCP_REQ_LEN,
               abuRep, NCP_REPLY_LEN, NULL);
   if(lCode == 0)
   {
      NWNCPUnpackEntryUnion(pEntryInfo, &abuRep[0], NCP_SUBFUNCTION);
   }

   return ((NWRCODE) lCode);
}


/*
$Header: /SRCS/esmp/usr/src/nw/lib/libnwNcp/22s31.c,v 1.7 1994/09/26 17:34:13 rebekah Exp $
*/
