/*	Copyright (c) 1990, 1991, 1992, 1993, 1994, 1995 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)kern-nuc:net/nuc/nwstring.c	1.9"
#ident 	"$Header: /SRCS/esmp/usr/src/nw/uts/net/nuc/nwstring.c,v 2.51.2.2 1994/12/21 02:48:40 ram Exp $"

/*
 *  Netware Unix Client
 *
 *	  MODULE: nwstring.c
 *	ABSTRACT: String manipulation library for use in NUC
 *
 */ 
#include <net/nuc/nwctypes.h>
#include <net/nuc/nuc_prototypes.h>

#include <io/ddi.h>

static uchar CaseIgnHash[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
};

/*
 * BEGIN_MANUAL_ENTRY(NWtlStricmp.3k)
 * NAME
 *	NWtlStricmp - Compare two character strings case insensitive
 *
 * SYNOPSIS
 *	int
 *	NWtlStricmp( s1, s2 )
 *	char *s1, *s2;
 *
 *
 * INPUT
 *	s1	- Source string
 *	s2	- Target string that source is being compared to
 *
 * OUTPUT
 *	Nothing
 *
 * RETURN VALUES
 *	Returns	0 	if strings match
 *	Returns -1 	if s1 is less than s2
 *	Returns 1 	if s1 is greater than s2
 *
 * DESCRIPTION
 *	Compairs string s1 and s2 case insensitively.
 *
 * NOTES
 *	Assumes both strings are NULL terminated. Though, will work if
 *	s1 is not. Best to make sure both are.
 *
 * SEE ALSO
 *	string(3C)
 *
 * END_MANUAL_ENTRY
 */
int
NWtlStricmp( s1, s2 )
char *s1, *s2;
{

	while (*s2) {
		if (CaseIgnHash[*((unsigned char *)s1)] == 
				CaseIgnHash[*((unsigned char *)s2)]) {
			++s2; ++s1;
			continue;
		} else {
			if (CaseIgnHash[*((unsigned char *)s1)] <
					CaseIgnHash[*((unsigned char *)s2)]) {
				return(-1);
			} else {
				return(1);
			}
		}
	}

	/*
	 *	 If the while is broken and string 1 still has data, 
	 *	then s1 is greater than s2
	 */
	if (*s1)
		return(1);

	return(0);
}
