/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)mach:mach/devices/ultra/l_opt.c	1.4"

/***								-*- C -*-
 ***
 ***	Warning!  Target file, do not modify.
 ***	
 ***	Generated from: l_opt.gen
 ***
 ***	Generated by: (genoptions 1.0.0).
 ***
 ***/

PUBLIC

#include "stdenv.h"
#include "global.h"


enum lfb_options_use_linear_frame_buffer
{
	LFB_OPTIONS_USE_LINEAR_FRAME_BUFFER_YES,
	LFB_OPTIONS_USE_LINEAR_FRAME_BUFFER_NO,
	LFB_OPTIONS_USE_LINEAR_FRAME_BUFFER_AUTO_CONFIGURE,
	lfb_options_use_linear_frame_buffer_end_enumeration
};

enum lfb_options_linear_frame_buffer_page_size
{
	LFB_OPTIONS_LINEAR_FRAME_BUFFER_PAGE_SIZE_AUTO_CONFIGURE,
	LFB_OPTIONS_LINEAR_FRAME_BUFFER_PAGE_SIZE_1,
	LFB_OPTIONS_LINEAR_FRAME_BUFFER_PAGE_SIZE_4,
	lfb_options_linear_frame_buffer_page_size_end_enumeration
};


#define	LFB_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT	1
#define	LFB_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT	2


#define	LFB_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINTS	1


#define	LFB_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS	1




struct lfb_options_structure
{
	int arc_cache_size;
	unsigned int arcdraw_options;
	unsigned int bitblt_options;
	int frame_buffer_physical_address;
	int frame_buffer_size;
	enum lfb_options_linear_frame_buffer_page_size linear_frame_buffer_page_size;
	int number_of_graphics_states;
	unsigned int pointdraw_options;
	enum lfb_options_use_linear_frame_buffer use_linear_frame_buffer;

};

/*
 * Names of the option defaults
 */

#define LFB_OPTIONS_ARC_CACHE_SIZE_DEFAULT\
	16
#define LFB_OPTIONS_ARCDRAW_OPTIONS_DEFAULT\
	( LFB_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS )
#define LFB_OPTIONS_BITBLT_OPTIONS_DEFAULT\
	( LFB_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT |LFB_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT )
#define LFB_OPTIONS_FRAME_BUFFER_PHYSICAL_ADDRESS_DEFAULT\
	0
#define LFB_OPTIONS_FRAME_BUFFER_SIZE_DEFAULT\
	0
#define LFB_OPTIONS_LINEAR_FRAME_BUFFER_PAGE_SIZE_DEFAULT\
	LFB_OPTIONS_LINEAR_FRAME_BUFFER_PAGE_SIZE_AUTO_CONFIGURE
#define LFB_OPTIONS_NUMBER_OF_GRAPHICS_STATES_DEFAULT\
	8
#define LFB_OPTIONS_POINTDRAW_OPTIONS_DEFAULT\
	( LFB_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINTS )
#define LFB_OPTIONS_USE_LINEAR_FRAME_BUFFER_DEFAULT\
	LFB_OPTIONS_USE_LINEAR_FRAME_BUFFER_AUTO_CONFIGURE


#if (defined(__DEBUG__))
export boolean	lfb_options_debug = FALSE;
#endif


PRIVATE
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <limits.h>

/*
 * The types of options.
 */

enum lfb_options_kind
{
	LFB_OPTIONS_MULTIPLE_ENUMERATION,
	LFB_OPTIONS_NUMERIC,
	LFB_OPTIONS_OPTION_ENVIRONMENT,
	LFB_OPTIONS_OPTION_FILE,
	LFB_OPTIONS_STRING,
	LFB_OPTIONS_UNIQUE_ENUMERATION,

	lfb_options_end_option_types
};

#if (defined(__DEBUG__))

static const char *const option_type_dump[] = 
{
	"multiple-enumeration",
	"numeric",
	"option-environment",
	"option-file",
	"string",
	"unique-enumeration",

	0
};

#endif

/*
 * The default options.
 */
static struct lfb_options_structure lfb_options_default =
{
	16,
	( LFB_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS ),
	( LFB_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT |LFB_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT ),
	0,
	0,
	LFB_OPTIONS_LINEAR_FRAME_BUFFER_PAGE_SIZE_AUTO_CONFIGURE,
	8,
	( LFB_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINTS ),
	LFB_OPTIONS_USE_LINEAR_FRAME_BUFFER_AUTO_CONFIGURE,

};

/*
 * The list of option keywords.
 */

static const char *const lfb_options_keywords[] = 
{
	"arc-cache-size",
	"arcdraw-options",
	"bitblt-options",
	"frame-buffer-physical-address",
	"frame-buffer-size",
	"linear-frame-buffer-page-size",
	"number-of-graphics-states",
	"options-file",
	"options-variable",
	"pointdraw-options",
	"use-linear-frame-buffer",

	0
};
/*
 * This array maps the option index to the option kind.
 */
static enum lfb_options_kind option_index_to_option_kind[] =
{
	LFB_OPTIONS_NUMERIC,
	LFB_OPTIONS_MULTIPLE_ENUMERATION,
	LFB_OPTIONS_MULTIPLE_ENUMERATION,
	LFB_OPTIONS_NUMERIC,
	LFB_OPTIONS_NUMERIC,
	LFB_OPTIONS_UNIQUE_ENUMERATION,
	LFB_OPTIONS_NUMERIC,
	LFB_OPTIONS_OPTION_FILE,
	LFB_OPTIONS_OPTION_ENVIRONMENT,
	LFB_OPTIONS_MULTIPLE_ENUMERATION,
	LFB_OPTIONS_UNIQUE_ENUMERATION,

	lfb_options_end_option_types
};



/*
 * List of enumeration keywords.
 */

static const char *const lfb_options_use_linear_frame_buffer_keywords[] =
{
	"yes",
	"no",
	"auto-configure",
	0
};
static const enum lfb_options_use_linear_frame_buffer lfb_options_use_linear_frame_buffer_index_to_value[] =
{
	LFB_OPTIONS_USE_LINEAR_FRAME_BUFFER_YES,
	LFB_OPTIONS_USE_LINEAR_FRAME_BUFFER_NO,
	LFB_OPTIONS_USE_LINEAR_FRAME_BUFFER_AUTO_CONFIGURE,
	lfb_options_use_linear_frame_buffer_end_enumeration
};
static const char *const lfb_options_linear_frame_buffer_page_size_keywords[] =
{
	"auto-configure",
	"1",
	"4",
	0
};
static const enum lfb_options_linear_frame_buffer_page_size lfb_options_linear_frame_buffer_page_size_index_to_value[] =
{
	LFB_OPTIONS_LINEAR_FRAME_BUFFER_PAGE_SIZE_AUTO_CONFIGURE,
	LFB_OPTIONS_LINEAR_FRAME_BUFFER_PAGE_SIZE_1,
	LFB_OPTIONS_LINEAR_FRAME_BUFFER_PAGE_SIZE_4,
	lfb_options_linear_frame_buffer_page_size_end_enumeration
};
static const char *const lfb_options_bitblt_options_keywords[] =
{
	"use-ms-bitblt",
	"use-sm-bitblt",
	0
};
static const int lfb_options_bitblt_options_index_to_value[] =
{
	LFB_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT,
	LFB_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT,
	-1
};
static const char *const lfb_options_pointdraw_options_keywords[] =
{
	"use-plot-points",
	0
};
static const int lfb_options_pointdraw_options_index_to_value[] =
{
	LFB_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINTS,
	-1
};
static const char *const lfb_options_arcdraw_options_keywords[] =
{
	"draw-one-bit-arcs",
	0
};
static const int lfb_options_arcdraw_options_index_to_value[] =
{
	LFB_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS,
	-1
};


/*
 * Help message.
 */
static const char *const lfb_options_description = 
"frame-buffer-physical-address\tThe physical address at which the ATI frame\n"
"frame-buffer-size\tThe size of the frame buffer in units of MB.  `0'\n"
"number-of-graphics-states\tNumber of SDD graphics states.  `0' means use internal default.\n"
"use-linear-frame-buffer\tControls the usage of LFB layer code.  `yes'\n"
"linear-frame-buffer-page-size\tThe page size for mapping the memory aperture.\n"
"arc-cache-size\tThe number of arcs to cache in the display library\n"
"bitblt-options\tFlags to control bitblt operations.\n"
"pointdraw-options\tFlags to control point plotting operations.\n"
"arcdraw-options\tControls the drawing operation for arcs.\n"
;

/*
 * Lookup a name in a table.
 */
static int
lfb_options_lookup_name(const char *name_p, const char *const *name_list_p)
{
	int name_index = 0;
	
	while (*name_list_p)
	{
		if (strcmp(*name_list_p, name_p))
		{
			name_index ++;
			name_list_p ++;
		}
		else
		{

#if (defined(__DEBUG__))
			if(lfb_options_debug)
			{
				(void) fprintf(debug_stream_p,
						"(lfb_options_ lookup) \"%s\" "
						"index = %d.\n", name_p, name_index);
					
			}
#endif
			return name_index;
			
		}
	}
	return -1;
	
}

/*
 * Get the next token.
 */

static char * 
lfb_options_parse_get_next_token(char *character_p)
{
	/* CONSTANTCONDITION */
	while (1)
	{
		/*
		 * Skip leading WS.
		 */
		while( (*character_p != EOS) && isspace(*character_p))
		{
			character_p ++;
		}
		if (*character_p == EOS)
		{
			break;
		}
		else if(*character_p == '#')
		{
			/*
			 * Comment.  Skip till new line.
			 */
			while ((*character_p != EOS) && (*character_p != '\n'))
			{
				character_p ++;
			}
		}
		else if (*character_p == '\\')
		{
			*character_p ++ = ' ';	/* replace '\' */
			*character_p = (*character_p == '\n') ? ' ' : *character_p;
		}
		else
		{
			return character_p;
		}
	}
	return (char *) 0;
}		

/*
 * lfb_options_parse : parse options.
 */
function struct lfb_options_structure *
lfb_options_parse (struct lfb_options_structure *option_struct_p,
			   const char *option_string_p)
{
	char * character_p;
	char * option_check_integer_p; /* return value of strtol() */
	struct stat stat_buf;
	
	char *option_list_p;		/* modifiable copy of option list */
	int option_name_index;		/* option keyword index */
	int option_enum_index;		/* enumeration value index */
	int option_enum_is_inverted; /* for !<value> parsing */
	
	char *tmp_p;				/* temporary */
	char *option_name_p, *option_value_p; /* for separating name=value */
	FILE *option_file_p;
	
	
	if (!option_struct_p)
	{
		option_struct_p = allocate_memory(sizeof (struct
												  lfb_options_structure));
		if (!option_struct_p)
		{
			perror(DEFAULT_OPTION_CANNOT_ALLOCATE_MEMORY_MESSAGE);
			goto error;
			
		}
		
		/*
		 * Copy the defaults.
		 */
		*option_struct_p = lfb_options_default;
		
	}

#if (defined(__DEBUG__))
	if (lfb_options_debug)
	{
		(void) fprintf(debug_stream_p, "(lfb_options_parse) "
				"option_string = \"%s\"\n", option_string_p);
	}
#endif

	/*
	 * Save the option string as we are going to munge it.
	 */
	option_list_p = strdup(option_string_p);
	
	character_p =
		lfb_options_parse_get_next_token(option_list_p);
	
	while(character_p)
	{
		/*
		 * parse the token, looking for name'='value pairs.
		 */
		option_name_p = character_p;
		while ((*character_p != EOS) && 
			   (*character_p != '='))
		{
			character_p ++;
		}
		if (*character_p != '=')
		{
			/*
			 * Error encountered.
			 */
			(void) fprintf(stderr, 
						   DEFAULT_OPTION_MALFORMED_OPTION_STRING_MESSAGE,
						   option_name_p);
			
			free_memory(option_list_p);
			return (struct lfb_options_structure *) 0;
			
		}
		else
		{
			*character_p++ = EOS;
			if (*character_p == EOS)
			{
				/*
				 * Error encountered.
				 */
				(void) fprintf(stderr, 
							   DEFAULT_OPTION_MALFORMED_OPTION_STRING_MESSAGE,
							   option_name_p);
			
				free_memory(option_list_p);
				return (struct lfb_options_structure *) 0;
				
			}
			/*
			 * Look for terminating white-space.
			 */
			if (*character_p == '\"')
			{
				/*
				 * Terminated by a '\"'.
				 */
				*character_p ++ = EOS;
				option_value_p = character_p;
				
				while ((*character_p != EOS) && 
					   (*character_p != '\"'))
				{
					character_p ++;
				}
				if (*character_p == EOS)
				{
					(void) fprintf(stderr,
						DEFAULT_OPTION_UNTERMINATED_STRING_CONSTANT_MESSAGE,
								   option_name_p);
					free_memory (option_list_p);
					return (struct lfb_options_structure *) 0;
				}
				else
				{
					*character_p ++ = EOS;
				}
			}
			else
			{
				/*
				 * White space terminated.
				 */
				option_value_p = character_p;

				/* CONSTANTCONDITION */
				while (1)
				{
					
					while ( (*character_p != EOS) && ! isspace(*character_p))
					{
						character_p ++;
					}
			
					if (*character_p != EOS)
					{

						if (*character_p == '\n' && *(character_p-1) == '\\')
						{
							/*
							 * Skip backslashed newline.
							 */
							character_p ++;
						}
						else
						{
							*character_p++ = EOS;
							break;
						}
					}
					else
					{
						break;
					}

				}			
			}
		}

		/*
		 * Analyze the option name and option value extracted.
		 */
		option_name_index =
			lfb_options_lookup_name(option_name_p, &(lfb_options_keywords[0]));
				
		if (option_name_index == -1)
		{
			(void) fprintf(stderr,
					DEFAULT_OPTION_UNRECOGNIZED_OPTION_MESSAGE,
					option_name_p);
			free_memory (option_list_p);
			return (struct lfb_options_structure *) 0;
		}
#if (defined(__DEBUG__))
		else
		{
			if (lfb_options_debug)
			{
				(void) fprintf(debug_stream_p,
						"(lfb_options_parse) recognized "
						"\"%s\" of type \"%s\", value "
						"\"%s\".\n", 
						option_name_p,
						option_type_dump[option_index_to_option_kind[option_name_index]],
						option_value_p);
				
			}
		}
#endif
	
		/*
		 * Depending on the kind of code, take action.
		 */
		switch (option_name_index)
		{

			

case 0 :	/* arc-cache-size */
	option_struct_p->arc_cache_size = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->arc_cache_size == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"arc-cache-size");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (lfb_options_debug)
	{
		(void) fprintf(debug_stream_p, "	arc-cache-size = %d\n",
				option_struct_p->arc_cache_size);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->arc_cache_size >= 0) && (option_struct_p->arc_cache_size <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"arc-cache-size");
		goto error;
	}

	break;

case 1 :	/* arcdraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			lfb_options_lookup_name(option_value_p, &(lfb_options_arcdraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "arcdraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->arcdraw_options &= 
				(~lfb_options_arcdraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->arcdraw_options |= 
				(lfb_options_arcdraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(lfb_options_debug)
	{
		(void) fprintf(debug_stream_p, "(lfb_options_parse) enum arcdraw-options value %d.\n",
			option_struct_p->arcdraw_options);
	}
#endif

	break;

case 2 :	/* bitblt-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			lfb_options_lookup_name(option_value_p, &(lfb_options_bitblt_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "bitblt-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->bitblt_options &= 
				(~lfb_options_bitblt_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->bitblt_options |= 
				(lfb_options_bitblt_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(lfb_options_debug)
	{
		(void) fprintf(debug_stream_p, "(lfb_options_parse) enum bitblt-options value %d.\n",
			option_struct_p->bitblt_options);
	}
#endif

	break;


case 3 :	/* frame-buffer-physical-address */
	option_struct_p->frame_buffer_physical_address = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->frame_buffer_physical_address == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"frame-buffer-physical-address");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (lfb_options_debug)
	{
		(void) fprintf(debug_stream_p, "	frame-buffer-physical-address = %d\n",
				option_struct_p->frame_buffer_physical_address);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->frame_buffer_physical_address >= 0) && (option_struct_p->frame_buffer_physical_address <= 127)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"frame-buffer-physical-address");
		goto error;
	}

	break;


case 4 :	/* frame-buffer-size */
	option_struct_p->frame_buffer_size = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->frame_buffer_size == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"frame-buffer-size");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (lfb_options_debug)
	{
		(void) fprintf(debug_stream_p, "	frame-buffer-size = %d\n",
				option_struct_p->frame_buffer_size);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->frame_buffer_size >= 0) && (option_struct_p->frame_buffer_size <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"frame-buffer-size");
		goto error;
	}

	break;

case 5 :	/* linear-frame-buffer-page-size */
	if ((option_enum_index = 
		lfb_options_lookup_name(option_value_p, &(lfb_options_linear_frame_buffer_page_size_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "linear-frame-buffer-page-size");
		goto error;
	}
	option_struct_p->linear_frame_buffer_page_size = lfb_options_linear_frame_buffer_page_size_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (lfb_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(lfb_options_parse) enum linear-frame-buffer-page-size value '%s'\n",
			lfb_options_linear_frame_buffer_page_size_keywords[option_enum_index]);
	}
#endif
	break;


case 6 :	/* number-of-graphics-states */
	option_struct_p->number_of_graphics_states = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->number_of_graphics_states == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"number-of-graphics-states");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (lfb_options_debug)
	{
		(void) fprintf(debug_stream_p, "	number-of-graphics-states = %d\n",
				option_struct_p->number_of_graphics_states);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->number_of_graphics_states >= 0) && (option_struct_p->number_of_graphics_states <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"number-of-graphics-states");
		goto error;
	}

	break;

case 7 :	/* options-file */
	/*
	 * look up the file.
	 */
	if (stat(option_value_p, &stat_buf) != 0)
	{
		/*
		 * Warn the user of missing files, and continue.
		 */
		(void) fprintf(stderr, 
					DEFAULT_OPTION_CANNOT_STAT_FILE_ARGUMENT_MESSAGE,
					option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		break;
	}

	if (stat_buf.st_size == 0)
	{
		/*
		 * Warn the user of zero length files, and continue.
		 */
		(void) fprintf(stderr,
					DEFAULT_OPTION_ZERO_LENGTH_FILE_ARGUMENT_MESSAGE,
					option_value_p, "options-file");
		break;
	}

	/* read the option file into a buffer */
	if (!(tmp_p = allocate_and_clear_memory(stat_buf.st_size+1)))
	{
		perror(DEFAULT_OPTION_CANNOT_ALLOCATE_MEMORY_MESSAGE);
		goto error;
	}

	if( (option_file_p = fopen(option_value_p, "r")) == NULL)
	{

		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_OPEN_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		goto error;
	}
	if (fread(tmp_p, stat_buf.st_size, 1, option_file_p) != 1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_READ_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		goto error;
	}

#if (defined(__DEBUG__))
	if (lfb_options_debug)
	{
		(void) fprintf(debug_stream_p, "\t\"%s\"\n", tmp_p);
	}
#endif
	/*
	 * Recursively invoke the interpreter.
	 */
	if (!lfb_options_parse(option_struct_p, tmp_p))
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_PROCESS_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		free_memory(tmp_p);
		goto error;
	}
	free_memory(tmp_p);
	break;

case 8 :	/* options-variable */

	tmp_p = getenv(option_value_p);
	if (tmp_p)
	{

#if (defined(__DEBUG__))
		if (lfb_options_debug)
		{
			(void) fprintf(debug_stream_p, "\t\"%s\"\n", tmp_p);
		}
#endif
		if (!lfb_options_parse(option_struct_p, tmp_p))
		{
			(void) fprintf(stderr, 
					DEFAULT_OPTION_CANNOT_PROCESS_ENVIRONMENT_ARGUMENT_MESSAGE,
				option_value_p, "options-variable");
			goto error;
		}

	}
	break;

case 9 :	/* pointdraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			lfb_options_lookup_name(option_value_p, &(lfb_options_pointdraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "pointdraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->pointdraw_options &= 
				(~lfb_options_pointdraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->pointdraw_options |= 
				(lfb_options_pointdraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(lfb_options_debug)
	{
		(void) fprintf(debug_stream_p, "(lfb_options_parse) enum pointdraw-options value %d.\n",
			option_struct_p->pointdraw_options);
	}
#endif

	break;

case 10 :	/* use-linear-frame-buffer */
	if ((option_enum_index = 
		lfb_options_lookup_name(option_value_p, &(lfb_options_use_linear_frame_buffer_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "use-linear-frame-buffer");
		goto error;
	}
	option_struct_p->use_linear_frame_buffer = lfb_options_use_linear_frame_buffer_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (lfb_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(lfb_options_parse) enum use-linear-frame-buffer value '%s'\n",
			lfb_options_use_linear_frame_buffer_keywords[option_enum_index]);
	}
#endif
	break;


			default :
				(void) fprintf(stderr,
						DEFAULT_OPTION_INTERNAL_ERROR_MESSAGE);
				free_memory(option_list_p);
				return (struct lfb_options_structure *) 0;
			
		}
		
		/*
		 * while ...
		 */
		character_p = 
			lfb_options_parse_get_next_token(character_p);
		
	}
	/*
	 * Free the space we allocated.
	 */
	free_memory(option_list_p);
	
	return option_struct_p;

  error:
	if (option_list_p)
	{
		free_memory(option_list_p);
	}
	
	return (struct lfb_options_structure *) 0;
	
}

#if (defined(__TEST__))
int
main(int parameter_count, char ** parameter_pp)
{
	int i;
	int string_length = 0;
	char * options_p;

#if (defined(__DEBUG__))
	lfb_options_debug = 
		getenv("lfb_options_debug") ? TRUE :	FALSE;
	if (debug_stream_p == NULL && (debug_stream_p =
		    fopen(getenv("debug_stream"), "w")) == NULL)
	{
		debug_stream_p = stdout;
	}
#endif

	for(i = 1; i < parameter_count; i++)
	{
		string_length += strlen(*(parameter_pp + i));
	}
	options_p = allocate_memory(string_length + 1);
	*options_p = EOS;
	
	for(i = 1; i < parameter_count; i++)
	{
		strcat(options_p, *(parameter_pp +i));
	}

	lfb_options_parse(0, options_p);

}

#endif
