/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#pragma ident	"@(#)mach:mach/m_opt.c	1.10"

/***								-*- C -*-
 ***
 ***	Warning!  Target file, do not modify.
 ***	
 ***	Generated from: m_opt.gen
 ***
 ***	Generated by: (genoptions 1.0.0).
 ***
 ***/

PUBLIC

#include "stdenv.h"
#include "global.h"


enum mach_options_si_interface_version
{
	MACH_OPTIONS_SI_INTERFACE_VERSION_1_0,
	MACH_OPTIONS_SI_INTERFACE_VERSION_1_1,
	MACH_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE,
	mach_options_si_interface_version_end_enumeration
};

enum mach_options_verbose_startup
{
	MACH_OPTIONS_VERBOSE_STARTUP_YES,
	MACH_OPTIONS_VERBOSE_STARTUP_NO,
	mach_options_verbose_startup_end_enumeration
};

enum mach_options_cursor_type
{
	MACH_OPTIONS_CURSOR_TYPE_AUTO_CONFIGURE,
	MACH_OPTIONS_CURSOR_TYPE_HARDWARE_CURSOR,
	MACH_OPTIONS_CURSOR_TYPE_SOFTWARE_CURSOR,
	mach_options_cursor_type_end_enumeration
};

enum mach_options_cursor_byte_swap
{
	MACH_OPTIONS_CURSOR_BYTE_SWAP_ENABLED,
	MACH_OPTIONS_CURSOR_BYTE_SWAP_DISABLED,
	MACH_OPTIONS_CURSOR_BYTE_SWAP_AUTO_CONFIGURE,
	mach_options_cursor_byte_swap_end_enumeration
};

enum mach_options_dac_name
{
	MACH_OPTIONS_DAC_NAME_ATI_68830,
	MACH_OPTIONS_DAC_NAME_SIERRA_SC11_48X,
	MACH_OPTIONS_DAC_NAME_ATT_20C491,
	MACH_OPTIONS_DAC_NAME_TI_TLC_34075,
	MACH_OPTIONS_DAC_NAME_ATI_68875_BFN,
	MACH_OPTIONS_DAC_NAME_ATI_68875_CFN,
	MACH_OPTIONS_DAC_NAME_BT_478,
	MACH_OPTIONS_DAC_NAME_IMS_G178J_80Z,
	MACH_OPTIONS_DAC_NAME_BT_481,
	MACH_OPTIONS_DAC_NAME_IMS_G176J_80Z,
	MACH_OPTIONS_DAC_NAME_BT_476,
	MACH_OPTIONS_DAC_NAME_AUTO_DETECT,
	mach_options_dac_name_end_enumeration
};

enum mach_options_dac_rgb_width
{
	MACH_OPTIONS_DAC_RGB_WIDTH_6,
	MACH_OPTIONS_DAC_RGB_WIDTH_8,
	MACH_OPTIONS_DAC_RGB_WIDTH_DEFAULT,
	mach_options_dac_rgb_width_end_enumeration
};

enum mach_options_dac_24_bit_color_mode
{
	MACH_OPTIONS_DAC_24_BIT_COLOR_MODE_RGBA,
	MACH_OPTIONS_DAC_24_BIT_COLOR_MODE_ABGR,
	mach_options_dac_24_bit_color_mode_end_enumeration
};

enum mach_options_dac_16_bit_color_mode
{
	MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_555,
	MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_565,
	MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_655,
	MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_664,
	mach_options_dac_16_bit_color_mode_end_enumeration
};

enum mach_options_monitor_sync_type
{
	MACH_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC,
	MACH_OPTIONS_MONITOR_SYNC_TYPE_SYNC_ON_GREEN,
	MACH_OPTIONS_MONITOR_SYNC_TYPE_SEPARATE_SYNC,
	mach_options_monitor_sync_type_end_enumeration
};

enum mach_options_chipset_name
{
	MACH_OPTIONS_CHIPSET_NAME_MACH_8,
	MACH_OPTIONS_CHIPSET_NAME_MACH_32,
	MACH_OPTIONS_CHIPSET_NAME_AUTO_DETECT,
	mach_options_chipset_name_end_enumeration
};

enum mach_options_clock_chip_name
{
	MACH_OPTIONS_CLOCK_CHIP_NAME_18810,
	MACH_OPTIONS_CLOCK_CHIP_NAME_18810_2,
	MACH_OPTIONS_CLOCK_CHIP_NAME_18811_0,
	MACH_OPTIONS_CLOCK_CHIP_NAME_18811_1,
	MACH_OPTIONS_CLOCK_CHIP_NAME_18812_0,
	mach_options_clock_chip_name_end_enumeration
};

enum mach_options_io_bus_width
{
	MACH_OPTIONS_IO_BUS_WIDTH_16_BIT,
	MACH_OPTIONS_IO_BUS_WIDTH_8_BIT,
	MACH_OPTIONS_IO_BUS_WIDTH_AUTO_DETECT,
	mach_options_io_bus_width_end_enumeration
};

enum mach_options_horizontal_line_draw_optimizations
{
	MACH_OPTIONS_HORIZONTAL_LINE_DRAW_OPTIMIZATIONS_ENABLED,
	MACH_OPTIONS_HORIZONTAL_LINE_DRAW_OPTIMIZATIONS_DISABLED,
	mach_options_horizontal_line_draw_optimizations_end_enumeration
};

enum mach_options_passthrough_override
{
	MACH_OPTIONS_PASSTHROUGH_OVERRIDE_ENABLED,
	MACH_OPTIONS_PASSTHROUGH_OVERRIDE_DISABLED,
	mach_options_passthrough_override_end_enumeration
};


#define	MACH_OPTIONS_SCREEN_8_4_BIT_VISUAL_LIST_STATIC_GRAY	1
#define	MACH_OPTIONS_SCREEN_8_4_BIT_VISUAL_LIST_GRAY_SCALE	2
#define	MACH_OPTIONS_SCREEN_8_4_BIT_VISUAL_LIST_STATIC_COLOR	4
#define	MACH_OPTIONS_SCREEN_8_4_BIT_VISUAL_LIST_PSEUDO_COLOR	8


#define	MACH_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT	1
#define	MACH_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT	2
#define	MACH_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT	4
#define	MACH_OPTIONS_RECTFILL_OPTIONS_USE_PATTERN_REGISTERS	8
#define	MACH_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY	16
#define	MACH_OPTIONS_RECTFILL_OPTIONS_USE_LARGE_OFFSCREEN_AREAS	32
#define	MACH_OPTIONS_RECTFILL_OPTIONS_USE_IBM_MODE	64


#define	MACH_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT	1
#define	MACH_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT	2
#define	MACH_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT	4
#define	MACH_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT	8
#define	MACH_OPTIONS_BITBLT_OPTIONS_USE_IBM_MODE	16


#define	MACH_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW	1
#define	MACH_OPTIONS_LINEDRAW_OPTIONS_USE_PATTERN_REGISTERS	2
#define	MACH_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES	4
#define	MACH_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW	8
#define	MACH_OPTIONS_LINEDRAW_OPTIONS_USE_IBM_MODE	16


#define	MACH_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL	1
#define	MACH_OPTIONS_SPANSFILL_OPTIONS_USE_STIPPLE_FILL	2
#define	MACH_OPTIONS_SPANSFILL_OPTIONS_USE_TILE_FILL	4
#define	MACH_OPTIONS_SPANSFILL_OPTIONS_USE_PATTERN_REGISTERS	8


#define	MACH_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT	1


#define	MACH_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS	1
#define	MACH_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS	2
#define	MACH_OPTIONS_FONTDRAW_OPTIONS_USE_OFFSCREEN_MEMORY	4
#define	MACH_OPTIONS_FONTDRAW_OPTIONS_USE_IBM_MODE	8




struct mach_options_structure
{
	unsigned int bitblt_options;
	enum mach_options_chipset_name chipset_name;
	char *chipset_revision;
	enum mach_options_clock_chip_name clock_chip_name;
	char *crtc_parameters;
	int crtc_start_offset;
	enum mach_options_cursor_byte_swap cursor_byte_swap;
	char *cursor_max_size;
	enum mach_options_cursor_type cursor_type;
	enum mach_options_dac_16_bit_color_mode dac_16_bit_color_mode;
	enum mach_options_dac_24_bit_color_mode dac_24_bit_color_mode;
	int dac_access_delay_count;
	int dac_blank_adjust;
	int dac_max_frequency;
	enum mach_options_dac_name dac_name;
	int dac_pixel_delay;
	enum mach_options_dac_rgb_width dac_rgb_width;
	unsigned int fontdraw_options;
	char *glyph_cache_size;
	int graphics_engine_fifo_blocking_factor;
	int graphics_engine_loop_timeout_count;
	int graphics_engine_micro_delay_count;
	enum mach_options_horizontal_line_draw_optimizations horizontal_line_draw_optimizations;
	enum mach_options_io_bus_width io_bus_width;
	unsigned int linedraw_options;
	int max_number_of_glyphs_in_downloadable_font;
	char *modedb_string;
	enum mach_options_monitor_sync_type monitor_sync_type;
	int number_of_downloadable_cursors;
	int number_of_downloadable_fonts;
	int number_of_graphics_states;
	int offscreen_stipple_padded_height;
	int offscreen_stipple_padded_width;
	int offscreen_tile_padded_height;
	int offscreen_tile_padded_width;
	int omm_full_coalesce_watermark;
	int omm_hash_list_size;
	int omm_horizontal_constraint;
	char *omm_named_allocation_list;
	int omm_neighbour_list_increment;
	int omm_vertical_constraint;
	char *overscan_color;
	int overscan_h;
	int overscan_v;
	enum mach_options_passthrough_override passthrough_override;
	unsigned int pointdraw_options;
	unsigned int rectfill_options;
	unsigned int screen_8_4_bit_visual_list;
	enum mach_options_si_interface_version si_interface_version;
	unsigned int spansfill_options;
	char *static_colormap_description_file;
	char *stipple_best_size;
	char *tile_best_size;
	enum mach_options_verbose_startup verbose_startup;
	char *video_memory_dimensions;
	int vram_fifo_depth;
	int vt_switch_save_lines;

};

/*
 * Names of the option defaults
 */

#define MACH_OPTIONS_BITBLT_OPTIONS_DEFAULT\
	( MACH_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT |MACH_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT |MACH_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT |MACH_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT |MACH_OPTIONS_BITBLT_OPTIONS_USE_IBM_MODE )
#define MACH_OPTIONS_CHIPSET_NAME_DEFAULT\
	MACH_OPTIONS_CHIPSET_NAME_AUTO_DETECT
#define MACH_OPTIONS_CHIPSET_REVISION_DEFAULT 0
#define MACH_OPTIONS_CLOCK_CHIP_NAME_DEFAULT\
	MACH_OPTIONS_CLOCK_CHIP_NAME_18811_1
#define MACH_OPTIONS_CRTC_PARAMETERS_DEFAULT 0
#define MACH_OPTIONS_CRTC_START_OFFSET_DEFAULT\
	0
#define MACH_OPTIONS_CURSOR_BYTE_SWAP_DEFAULT\
	MACH_OPTIONS_CURSOR_BYTE_SWAP_AUTO_CONFIGURE
#define MACH_OPTIONS_CURSOR_MAX_SIZE_DEFAULT 0
#define MACH_OPTIONS_CURSOR_TYPE_DEFAULT\
	MACH_OPTIONS_CURSOR_TYPE_AUTO_CONFIGURE
#define MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_DEFAULT\
	MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_555
#define MACH_OPTIONS_DAC_24_BIT_COLOR_MODE_DEFAULT\
	MACH_OPTIONS_DAC_24_BIT_COLOR_MODE_RGBA
#define MACH_OPTIONS_DAC_ACCESS_DELAY_COUNT_DEFAULT\
	10
#define MACH_OPTIONS_DAC_BLANK_ADJUST_DEFAULT\
	-1
#define MACH_OPTIONS_DAC_MAX_FREQUENCY_DEFAULT\
	0
#define MACH_OPTIONS_DAC_NAME_DEFAULT\
	MACH_OPTIONS_DAC_NAME_AUTO_DETECT
#define MACH_OPTIONS_DAC_PIXEL_DELAY_DEFAULT\
	-1
#define MACH_OPTIONS_DAC_RGB_WIDTH_DEFAULT\
	MACH_OPTIONS_DAC_RGB_WIDTH_DEFAULT
#define MACH_OPTIONS_FONTDRAW_OPTIONS_DEFAULT\
	( MACH_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS |MACH_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS |MACH_OPTIONS_FONTDRAW_OPTIONS_USE_OFFSCREEN_MEMORY |MACH_OPTIONS_FONTDRAW_OPTIONS_USE_IBM_MODE )
#define MACH_OPTIONS_GLYPH_CACHE_SIZE_DEFAULT\
	"128X128"
#define MACH_OPTIONS_GRAPHICS_ENGINE_FIFO_BLOCKING_FACTOR_DEFAULT\
	8
#define MACH_OPTIONS_GRAPHICS_ENGINE_LOOP_TIMEOUT_COUNT_DEFAULT\
	200000
#define MACH_OPTIONS_GRAPHICS_ENGINE_MICRO_DELAY_COUNT_DEFAULT\
	40
#define MACH_OPTIONS_HORIZONTAL_LINE_DRAW_OPTIMIZATIONS_DEFAULT\
	MACH_OPTIONS_HORIZONTAL_LINE_DRAW_OPTIMIZATIONS_ENABLED
#define MACH_OPTIONS_IO_BUS_WIDTH_DEFAULT\
	MACH_OPTIONS_IO_BUS_WIDTH_AUTO_DETECT
#define MACH_OPTIONS_LINEDRAW_OPTIONS_DEFAULT\
	( MACH_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW |MACH_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW |MACH_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES |MACH_OPTIONS_LINEDRAW_OPTIONS_USE_PATTERN_REGISTERS |MACH_OPTIONS_LINEDRAW_OPTIONS_USE_IBM_MODE )
#define MACH_OPTIONS_MAX_NUMBER_OF_GLYPHS_IN_DOWNLOADABLE_FONT_DEFAULT\
	256
#define MACH_OPTIONS_MODEDB_STRING_DEFAULT 0
#define MACH_OPTIONS_MONITOR_SYNC_TYPE_DEFAULT\
	MACH_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC
#define MACH_OPTIONS_NUMBER_OF_DOWNLOADABLE_CURSORS_DEFAULT\
	1
#define MACH_OPTIONS_NUMBER_OF_DOWNLOADABLE_FONTS_DEFAULT\
	32
#define MACH_OPTIONS_NUMBER_OF_GRAPHICS_STATES_DEFAULT\
	8
#define MACH_OPTIONS_OFFSCREEN_STIPPLE_PADDED_HEIGHT_DEFAULT\
	32
#define MACH_OPTIONS_OFFSCREEN_STIPPLE_PADDED_WIDTH_DEFAULT\
	128
#define MACH_OPTIONS_OFFSCREEN_TILE_PADDED_HEIGHT_DEFAULT\
	32
#define MACH_OPTIONS_OFFSCREEN_TILE_PADDED_WIDTH_DEFAULT\
	128
#define MACH_OPTIONS_OMM_FULL_COALESCE_WATERMARK_DEFAULT\
	2
#define MACH_OPTIONS_OMM_HASH_LIST_SIZE_DEFAULT\
	512
#define MACH_OPTIONS_OMM_HORIZONTAL_CONSTRAINT_DEFAULT\
	0
#define MACH_OPTIONS_OMM_NAMED_ALLOCATION_LIST_DEFAULT\
	""
#define MACH_OPTIONS_OMM_NEIGHBOUR_LIST_INCREMENT_DEFAULT\
	20
#define MACH_OPTIONS_OMM_VERTICAL_CONSTRAINT_DEFAULT\
	0
#define MACH_OPTIONS_OVERSCAN_COLOR_DEFAULT 0
#define MACH_OPTIONS_OVERSCAN_H_DEFAULT\
	0
#define MACH_OPTIONS_OVERSCAN_V_DEFAULT\
	0
#define MACH_OPTIONS_PASSTHROUGH_OVERRIDE_DEFAULT\
	MACH_OPTIONS_PASSTHROUGH_OVERRIDE_DISABLED
#define MACH_OPTIONS_POINTDRAW_OPTIONS_DEFAULT\
	( MACH_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT )
#define MACH_OPTIONS_RECTFILL_OPTIONS_DEFAULT\
	( MACH_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT |MACH_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT |MACH_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT |MACH_OPTIONS_RECTFILL_OPTIONS_USE_PATTERN_REGISTERS |MACH_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY |MACH_OPTIONS_RECTFILL_OPTIONS_USE_LARGE_OFFSCREEN_AREAS |MACH_OPTIONS_RECTFILL_OPTIONS_USE_IBM_MODE )
#define MACH_OPTIONS_SCREEN_8_4_BIT_VISUAL_LIST_DEFAULT 0
#define MACH_OPTIONS_SI_INTERFACE_VERSION_DEFAULT\
	MACH_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE
#define MACH_OPTIONS_SPANSFILL_OPTIONS_DEFAULT\
	( MACH_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL |MACH_OPTIONS_SPANSFILL_OPTIONS_USE_STIPPLE_FILL |MACH_OPTIONS_SPANSFILL_OPTIONS_USE_TILE_FILL |MACH_OPTIONS_SPANSFILL_OPTIONS_USE_PATTERN_REGISTERS )
#define MACH_OPTIONS_STATIC_COLORMAP_DESCRIPTION_FILE_DEFAULT 0
#define MACH_OPTIONS_STIPPLE_BEST_SIZE_DEFAULT\
	"32X32"
#define MACH_OPTIONS_TILE_BEST_SIZE_DEFAULT\
	"32X32"
#define MACH_OPTIONS_VERBOSE_STARTUP_DEFAULT\
	MACH_OPTIONS_VERBOSE_STARTUP_NO
#define MACH_OPTIONS_VIDEO_MEMORY_DIMENSIONS_DEFAULT 0
#define MACH_OPTIONS_VRAM_FIFO_DEPTH_DEFAULT\
	8
#define MACH_OPTIONS_VT_SWITCH_SAVE_LINES_DEFAULT\
	-1


#if (defined(__DEBUG__))
export boolean	mach_options_debug = FALSE;
#endif


PRIVATE
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <limits.h>

/*
 * The types of options.
 */

enum mach_options_kind
{
	MACH_OPTIONS_MULTIPLE_ENUMERATION,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_OPTION_ENVIRONMENT,
	MACH_OPTIONS_OPTION_FILE,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_UNIQUE_ENUMERATION,

	mach_options_end_option_types
};

#if (defined(__DEBUG__))

static const char *const option_type_dump[] = 
{
	"multiple-enumeration",
	"numeric",
	"option-environment",
	"option-file",
	"string",
	"unique-enumeration",

	0
};

#endif

/*
 * The default options.
 */
static struct mach_options_structure mach_options_default =
{
	( MACH_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT |MACH_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT |MACH_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT |MACH_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT |MACH_OPTIONS_BITBLT_OPTIONS_USE_IBM_MODE ),
	MACH_OPTIONS_CHIPSET_NAME_AUTO_DETECT,
	0,
	MACH_OPTIONS_CLOCK_CHIP_NAME_18811_1,
	0,
	0,
	MACH_OPTIONS_CURSOR_BYTE_SWAP_AUTO_CONFIGURE,
	0,
	MACH_OPTIONS_CURSOR_TYPE_AUTO_CONFIGURE,
	MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_555,
	MACH_OPTIONS_DAC_24_BIT_COLOR_MODE_RGBA,
	10,
	-1,
	0,
	MACH_OPTIONS_DAC_NAME_AUTO_DETECT,
	-1,
	MACH_OPTIONS_DAC_RGB_WIDTH_DEFAULT,
	( MACH_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS |MACH_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS |MACH_OPTIONS_FONTDRAW_OPTIONS_USE_OFFSCREEN_MEMORY |MACH_OPTIONS_FONTDRAW_OPTIONS_USE_IBM_MODE ),
	"128x128",
	8,
	200000,
	40,
	MACH_OPTIONS_HORIZONTAL_LINE_DRAW_OPTIMIZATIONS_ENABLED,
	MACH_OPTIONS_IO_BUS_WIDTH_AUTO_DETECT,
	( MACH_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW |MACH_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW |MACH_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES |MACH_OPTIONS_LINEDRAW_OPTIONS_USE_PATTERN_REGISTERS |MACH_OPTIONS_LINEDRAW_OPTIONS_USE_IBM_MODE ),
	256,
	0,
	MACH_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC,
	1,
	32,
	8,
	32,
	128,
	32,
	128,
	2,
	512,
	0,
	"",
	20,
	0,
	0,
	0,
	0,
	MACH_OPTIONS_PASSTHROUGH_OVERRIDE_DISABLED,
	( MACH_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT ),
	( MACH_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT |MACH_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT |MACH_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT |MACH_OPTIONS_RECTFILL_OPTIONS_USE_PATTERN_REGISTERS |MACH_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY |MACH_OPTIONS_RECTFILL_OPTIONS_USE_LARGE_OFFSCREEN_AREAS |MACH_OPTIONS_RECTFILL_OPTIONS_USE_IBM_MODE ),
	0,
	MACH_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE,
	( MACH_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL |MACH_OPTIONS_SPANSFILL_OPTIONS_USE_STIPPLE_FILL |MACH_OPTIONS_SPANSFILL_OPTIONS_USE_TILE_FILL |MACH_OPTIONS_SPANSFILL_OPTIONS_USE_PATTERN_REGISTERS ),
	0,
	"32x32",
	"32x32",
	MACH_OPTIONS_VERBOSE_STARTUP_NO,
	0,
	8,
	-1,

};

/*
 * The list of option keywords.
 */

static const char *const mach_options_keywords[] = 
{
	"bitblt-options",
	"chipset-name",
	"chipset-revision",
	"clock-chip-name",
	"crtc-parameters",
	"crtc-start-offset",
	"cursor-byte-swap",
	"cursor-max-size",
	"cursor-type",
	"dac-16-bit-color-mode",
	"dac-24-bit-color-mode",
	"dac-access-delay-count",
	"dac-blank-adjust",
	"dac-max-frequency",
	"dac-name",
	"dac-pixel-delay",
	"dac-rgb-width",
	"fontdraw-options",
	"glyph-cache-size",
	"graphics-engine-fifo-blocking-factor",
	"graphics-engine-loop-timeout-count",
	"graphics-engine-micro-delay-count",
	"horizontal-line-draw-optimizations",
	"io-bus-width",
	"linedraw-options",
	"max-number-of-glyphs-in-downloadable-font",
	"modedb-string",
	"monitor-sync-type",
	"number-of-downloadable-cursors",
	"number-of-downloadable-fonts",
	"number-of-graphics-states",
	"offscreen-stipple-padded-height",
	"offscreen-stipple-padded-width",
	"offscreen-tile-padded-height",
	"offscreen-tile-padded-width",
	"omm-full-coalesce-watermark",
	"omm-hash-list-size",
	"omm-horizontal-constraint",
	"omm-named-allocation-list",
	"omm-neighbour-list-increment",
	"omm-vertical-constraint",
	"options-file",
	"options-variable",
	"overscan-color",
	"overscan-h",
	"overscan-v",
	"passthrough-override",
	"pointdraw-options",
	"rectfill-options",
	"screen-8-4-bit-visual-list",
	"si-interface-version",
	"spansfill-options",
	"static-colormap-description-file",
	"stipple-best-size",
	"tile-best-size",
	"verbose-startup",
	"video-memory-dimensions",
	"vram-fifo-depth",
	"vt-switch-save-lines",

	0
};
/*
 * This array maps the option index to the option kind.
 */
static enum mach_options_kind option_index_to_option_kind[] =
{
	MACH_OPTIONS_MULTIPLE_ENUMERATION,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_MULTIPLE_ENUMERATION,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_MULTIPLE_ENUMERATION,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_OPTION_FILE,
	MACH_OPTIONS_OPTION_ENVIRONMENT,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_MULTIPLE_ENUMERATION,
	MACH_OPTIONS_MULTIPLE_ENUMERATION,
	MACH_OPTIONS_MULTIPLE_ENUMERATION,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_MULTIPLE_ENUMERATION,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_UNIQUE_ENUMERATION,
	MACH_OPTIONS_STRING,
	MACH_OPTIONS_NUMERIC,
	MACH_OPTIONS_NUMERIC,

	mach_options_end_option_types
};



/*
 * List of enumeration keywords.
 */

static const char *const mach_options_si_interface_version_keywords[] =
{
	"1-0",
	"1-1",
	"auto-configure",
	0
};
static const enum mach_options_si_interface_version mach_options_si_interface_version_index_to_value[] =
{
	MACH_OPTIONS_SI_INTERFACE_VERSION_1_0,
	MACH_OPTIONS_SI_INTERFACE_VERSION_1_1,
	MACH_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE,
	mach_options_si_interface_version_end_enumeration
};
static const char *const mach_options_verbose_startup_keywords[] =
{
	"yes",
	"no",
	0
};
static const enum mach_options_verbose_startup mach_options_verbose_startup_index_to_value[] =
{
	MACH_OPTIONS_VERBOSE_STARTUP_YES,
	MACH_OPTIONS_VERBOSE_STARTUP_NO,
	mach_options_verbose_startup_end_enumeration
};
static const char *const mach_options_cursor_type_keywords[] =
{
	"auto-configure",
	"hardware-cursor",
	"software-cursor",
	0
};
static const enum mach_options_cursor_type mach_options_cursor_type_index_to_value[] =
{
	MACH_OPTIONS_CURSOR_TYPE_AUTO_CONFIGURE,
	MACH_OPTIONS_CURSOR_TYPE_HARDWARE_CURSOR,
	MACH_OPTIONS_CURSOR_TYPE_SOFTWARE_CURSOR,
	mach_options_cursor_type_end_enumeration
};
static const char *const mach_options_cursor_byte_swap_keywords[] =
{
	"enabled",
	"disabled",
	"auto-configure",
	0
};
static const enum mach_options_cursor_byte_swap mach_options_cursor_byte_swap_index_to_value[] =
{
	MACH_OPTIONS_CURSOR_BYTE_SWAP_ENABLED,
	MACH_OPTIONS_CURSOR_BYTE_SWAP_DISABLED,
	MACH_OPTIONS_CURSOR_BYTE_SWAP_AUTO_CONFIGURE,
	mach_options_cursor_byte_swap_end_enumeration
};
static const char *const mach_options_dac_name_keywords[] =
{
	"ati-68830",
	"sierra-sc11-48x",
	"att-20c491",
	"ti-tlc-34075",
	"ati-68875-bfn",
	"ati-68875-cfn",
	"bt-478",
	"ims-g178j-80z",
	"bt-481",
	"ims-g176j-80z",
	"bt-476",
	"auto-detect",
	0
};
static const enum mach_options_dac_name mach_options_dac_name_index_to_value[] =
{
	MACH_OPTIONS_DAC_NAME_ATI_68830,
	MACH_OPTIONS_DAC_NAME_SIERRA_SC11_48X,
	MACH_OPTIONS_DAC_NAME_ATT_20C491,
	MACH_OPTIONS_DAC_NAME_TI_TLC_34075,
	MACH_OPTIONS_DAC_NAME_ATI_68875_BFN,
	MACH_OPTIONS_DAC_NAME_ATI_68875_CFN,
	MACH_OPTIONS_DAC_NAME_BT_478,
	MACH_OPTIONS_DAC_NAME_IMS_G178J_80Z,
	MACH_OPTIONS_DAC_NAME_BT_481,
	MACH_OPTIONS_DAC_NAME_IMS_G176J_80Z,
	MACH_OPTIONS_DAC_NAME_BT_476,
	MACH_OPTIONS_DAC_NAME_AUTO_DETECT,
	mach_options_dac_name_end_enumeration
};
static const char *const mach_options_dac_rgb_width_keywords[] =
{
	"6",
	"8",
	"default",
	0
};
static const enum mach_options_dac_rgb_width mach_options_dac_rgb_width_index_to_value[] =
{
	MACH_OPTIONS_DAC_RGB_WIDTH_6,
	MACH_OPTIONS_DAC_RGB_WIDTH_8,
	MACH_OPTIONS_DAC_RGB_WIDTH_DEFAULT,
	mach_options_dac_rgb_width_end_enumeration
};
static const char *const mach_options_dac_24_bit_color_mode_keywords[] =
{
	"rgba",
	"abgr",
	0
};
static const enum mach_options_dac_24_bit_color_mode mach_options_dac_24_bit_color_mode_index_to_value[] =
{
	MACH_OPTIONS_DAC_24_BIT_COLOR_MODE_RGBA,
	MACH_OPTIONS_DAC_24_BIT_COLOR_MODE_ABGR,
	mach_options_dac_24_bit_color_mode_end_enumeration
};
static const char *const mach_options_dac_16_bit_color_mode_keywords[] =
{
	"555",
	"565",
	"655",
	"664",
	0
};
static const enum mach_options_dac_16_bit_color_mode mach_options_dac_16_bit_color_mode_index_to_value[] =
{
	MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_555,
	MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_565,
	MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_655,
	MACH_OPTIONS_DAC_16_BIT_COLOR_MODE_664,
	mach_options_dac_16_bit_color_mode_end_enumeration
};
static const char *const mach_options_screen_8_4_bit_visual_list_keywords[] =
{
	"static-gray",
	"gray-scale",
	"static-color",
	"pseudo-color",
	0
};
static const int mach_options_screen_8_4_bit_visual_list_index_to_value[] =
{
	MACH_OPTIONS_SCREEN_8_4_BIT_VISUAL_LIST_STATIC_GRAY,
	MACH_OPTIONS_SCREEN_8_4_BIT_VISUAL_LIST_GRAY_SCALE,
	MACH_OPTIONS_SCREEN_8_4_BIT_VISUAL_LIST_STATIC_COLOR,
	MACH_OPTIONS_SCREEN_8_4_BIT_VISUAL_LIST_PSEUDO_COLOR,
	-1
};
static const char *const mach_options_monitor_sync_type_keywords[] =
{
	"composite-sync",
	"sync-on-green",
	"separate-sync",
	0
};
static const enum mach_options_monitor_sync_type mach_options_monitor_sync_type_index_to_value[] =
{
	MACH_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC,
	MACH_OPTIONS_MONITOR_SYNC_TYPE_SYNC_ON_GREEN,
	MACH_OPTIONS_MONITOR_SYNC_TYPE_SEPARATE_SYNC,
	mach_options_monitor_sync_type_end_enumeration
};
static const char *const mach_options_chipset_name_keywords[] =
{
	"mach-8",
	"mach-32",
	"auto-detect",
	0
};
static const enum mach_options_chipset_name mach_options_chipset_name_index_to_value[] =
{
	MACH_OPTIONS_CHIPSET_NAME_MACH_8,
	MACH_OPTIONS_CHIPSET_NAME_MACH_32,
	MACH_OPTIONS_CHIPSET_NAME_AUTO_DETECT,
	mach_options_chipset_name_end_enumeration
};
static const char *const mach_options_clock_chip_name_keywords[] =
{
	"18810",
	"18810-2",
	"18811-0",
	"18811-1",
	"18812-0",
	0
};
static const enum mach_options_clock_chip_name mach_options_clock_chip_name_index_to_value[] =
{
	MACH_OPTIONS_CLOCK_CHIP_NAME_18810,
	MACH_OPTIONS_CLOCK_CHIP_NAME_18810_2,
	MACH_OPTIONS_CLOCK_CHIP_NAME_18811_0,
	MACH_OPTIONS_CLOCK_CHIP_NAME_18811_1,
	MACH_OPTIONS_CLOCK_CHIP_NAME_18812_0,
	mach_options_clock_chip_name_end_enumeration
};
static const char *const mach_options_io_bus_width_keywords[] =
{
	"16-bit",
	"8-bit",
	"auto-detect",
	0
};
static const enum mach_options_io_bus_width mach_options_io_bus_width_index_to_value[] =
{
	MACH_OPTIONS_IO_BUS_WIDTH_16_BIT,
	MACH_OPTIONS_IO_BUS_WIDTH_8_BIT,
	MACH_OPTIONS_IO_BUS_WIDTH_AUTO_DETECT,
	mach_options_io_bus_width_end_enumeration
};
static const char *const mach_options_horizontal_line_draw_optimizations_keywords[] =
{
	"enabled",
	"disabled",
	0
};
static const enum mach_options_horizontal_line_draw_optimizations mach_options_horizontal_line_draw_optimizations_index_to_value[] =
{
	MACH_OPTIONS_HORIZONTAL_LINE_DRAW_OPTIMIZATIONS_ENABLED,
	MACH_OPTIONS_HORIZONTAL_LINE_DRAW_OPTIMIZATIONS_DISABLED,
	mach_options_horizontal_line_draw_optimizations_end_enumeration
};
static const char *const mach_options_passthrough_override_keywords[] =
{
	"enabled",
	"disabled",
	0
};
static const enum mach_options_passthrough_override mach_options_passthrough_override_index_to_value[] =
{
	MACH_OPTIONS_PASSTHROUGH_OVERRIDE_ENABLED,
	MACH_OPTIONS_PASSTHROUGH_OVERRIDE_DISABLED,
	mach_options_passthrough_override_end_enumeration
};
static const char *const mach_options_rectfill_options_keywords[] =
{
	"use-solid-fill-rect",
	"use-tile-fill-rect",
	"use-stipple-fill-rect",
	"use-pattern-registers",
	"use-offscreen-memory",
	"use-large-offscreen-areas",
	"use-ibm-mode",
	0
};
static const int mach_options_rectfill_options_index_to_value[] =
{
	MACH_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT,
	MACH_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT,
	MACH_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT,
	MACH_OPTIONS_RECTFILL_OPTIONS_USE_PATTERN_REGISTERS,
	MACH_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY,
	MACH_OPTIONS_RECTFILL_OPTIONS_USE_LARGE_OFFSCREEN_AREAS,
	MACH_OPTIONS_RECTFILL_OPTIONS_USE_IBM_MODE,
	-1
};
static const char *const mach_options_bitblt_options_keywords[] =
{
	"use-ss-bitblt",
	"use-ms-bitblt",
	"use-sm-bitblt",
	"use-ms-stplblt",
	"use-ibm-mode",
	0
};
static const int mach_options_bitblt_options_index_to_value[] =
{
	MACH_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT,
	MACH_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT,
	MACH_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT,
	MACH_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT,
	MACH_OPTIONS_BITBLT_OPTIONS_USE_IBM_MODE,
	-1
};
static const char *const mach_options_linedraw_options_keywords[] =
{
	"use-line-draw",
	"use-pattern-registers",
	"use-line-rectangles",
	"use-segment-draw",
	"use-ibm-mode",
	0
};
static const int mach_options_linedraw_options_index_to_value[] =
{
	MACH_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW,
	MACH_OPTIONS_LINEDRAW_OPTIONS_USE_PATTERN_REGISTERS,
	MACH_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES,
	MACH_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW,
	MACH_OPTIONS_LINEDRAW_OPTIONS_USE_IBM_MODE,
	-1
};
static const char *const mach_options_spansfill_options_keywords[] =
{
	"use-solid-fill",
	"use-stipple-fill",
	"use-tile-fill",
	"use-pattern-registers",
	0
};
static const int mach_options_spansfill_options_index_to_value[] =
{
	MACH_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL,
	MACH_OPTIONS_SPANSFILL_OPTIONS_USE_STIPPLE_FILL,
	MACH_OPTIONS_SPANSFILL_OPTIONS_USE_TILE_FILL,
	MACH_OPTIONS_SPANSFILL_OPTIONS_USE_PATTERN_REGISTERS,
	-1
};
static const char *const mach_options_pointdraw_options_keywords[] =
{
	"use-plot-point",
	0
};
static const int mach_options_pointdraw_options_index_to_value[] =
{
	MACH_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT,
	-1
};
static const char *const mach_options_fontdraw_options_keywords[] =
{
	"draw-non-terminal-fonts",
	"draw-terminal-fonts",
	"use-offscreen-memory",
	"use-ibm-mode",
	0
};
static const int mach_options_fontdraw_options_index_to_value[] =
{
	MACH_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS,
	MACH_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS,
	MACH_OPTIONS_FONTDRAW_OPTIONS_USE_OFFSCREEN_MEMORY,
	MACH_OPTIONS_FONTDRAW_OPTIONS_USE_IBM_MODE,
	-1
};


/*
 * Help message.
 */
static const char *const mach_options_description = 
"si-interface-version\tThe version number that the SDD returns to the SI server.\n"
"verbose-startup\tPrint messages about chipset configuration if set to `yes'.\n"
"cursor-type\tCursor implementation types.\n"
"cursor-byte-swap\tThe cursor bits need to be byte swapped when using certain chipset revisions and in certain modes.\n"
"cursor-max-size\tMaximum size of a cursor in WxH.\n"
"number-of-downloadable-cursors\tNumber of downloaded hardware cursors.  `0' means use internal default.\n"
"number-of-downloadable-fonts\tNumber of downloaded fonts.  `0' means to turn off font handling in the SDD.\n"
"max-number-of-glyphs-in-downloadable-font\tThe maximum number of glyphs in a font suitable for downloading.  0 means ignore this criterion.\n"
"glyph-cache-size\tCache glyphs smaller than this size in offscreen memory\n"
"vt-switch-save-lines\tNumber of lines of screen to save.  `-1' means save the whole screen.\n"
"number-of-graphics-states\tNumber of SDD graphics states.  `0' means use internal default.\n"
"tile-best-size\t`Best tile size' as seen by the SI code.\n"
"stipple-best-size\t`Best stipple size' as seen by the SI code.\n"
"offscreen-tile-padded-width\tPad small tiles to this value in offscreen memory.  Should be a power of two.\n"
"offscreen-tile-padded-height\tPad small tiles to this value in offscreen memory.  Should be a power of two.\n"
"offscreen-stipple-padded-width\tPad small stipples to this value in offscreen memory.  Should be a power of two.\n"
"offscreen-stipple-padded-height\tPad small stipples to this value in offscreen memory.  Should be a power of two.\n"
"crtc-start-offset\tOffset of start of display memory.\n"
"crtc-parameters\tCRTC parameters in hexadecimal : h-total h-disp h-sync-strt h-sync-wid v-total v-disp v-sync-strt v-sync-wid disp-cntl clock-sel\n"
"modedb-string\tModeDB entry in the following format: \"Clock HorizontalTiming VerticalTiming Flags\".  Clock is in MHz.  The Timing field consists of Display, SyncStart, SyncEnd and Total timings in that order.  Flags field may or may not be present.  Flags field may specify if a mode is interlaced and hsync and vsync polarities.  The two options modedb-string and crtc-parameters are mutually exclusive.  However, if both are present, this option takes higher priority.\n"
"dac-name\tThe type of DAC on board.\n"
"dac-max-frequency\tThe maximum frequency of the DAC in Mhz.  `0' means use builtin values for the DAC.\n"
"dac-blank-adjust\tThe numeric value of the blank adjust parameter when initializing the DAC.  This parameter depends on the selected display mode and the type of DAC.  `-1' means use the builtin rules for this parameter.\n"
"dac-pixel-delay\tThe numeric value of the pixel delay parameter for initializing the DAC.  This parameter depends on the selected display mode and the type of DAC present on board.  `-1' means use the builtin rules for this parameter.\n"
"dac-access-delay-count\tNumber of cycles to wait between dac accesses.  On fast machines, this value may need to be increased.\n"
"dac-rgb-width\tNumber of significant bits per R/G/B output.  `default' will use the libraries internal values for the detected DAC type.\n"
"dac-24-bit-color-mode\tOrder of R/G/B pixels in a 32 bit word.  The DAC on board should support the selected mode.\n"
"dac-16-bit-color-mode\tNumber of bits for R/G/B in 16 bit mode.  The DAC on board should support the selected mode.\n"
"overscan-color\tColor name for the overscan color.\n"
"overscan-h\tRegister value for the horz_overscan register.\n"
"overscan-v\tRegister value for the vert_overscan register.\n"
"screen-8-4-bit-visual-list\tSupported display visuals in addition to the screen default visual specified in the server config file.  Caveat : the core server does not seem to handle multiple visuals per screen yet ...\n"
"monitor-sync-type\tThe monitor's SYNC type.\n"
"omm-named-allocation-list\tNamed allocation requests for the offscreen memory manager.  This option is primarily used to name `holes' in the video memory.\n"
"omm-horizontal-constraint\tThe widths of all offscreen memory requests are rounded up to this value.  0 means use an internal heuristic.\n"
"omm-vertical-constraint\tThe heights of all offscreen memory requests are rounded up to this value.  0 means use an internal heuristic.\n"
"omm-neighbour-list-increment\tNumber of neighbour list nodes allocated at one time.  Neighbour lists are managed during every allocate and free operation.  0 means use an internal heuristic.\n"
"omm-full-coalesce-watermark\tIf the number of currently allocated blocks falls below this value the omm will attempt a full coalesion operation.  Remember that coalesion is an expensive operation.\n"
"omm-hash-list-size\tSize of the hash table of omm free blocks.  0 means use an an internal heuristic.\n"
"video-memory-dimensions\tVideo memory organization in pixels (WxH).\n"
"chipset-name\tThe type of accelarator.\n"
"chipset-revision\tThe revision of the graphics accelarator chipset.  NULL (default) means auto-detect.\n"
"clock-chip-name\tThe type of clock chip on the video board.\n"
"io-bus-width\tI/O bus width.\n"
"horizontal-line-draw-optimizations\tWhether the graphics engine should use its\n"
"passthrough-override\tEnabled if a passthrough cable is not attached.\n"
"vram-fifo-depth\tTrigger value for filling DRAM FIFO.  `-1' means\n"
"graphics-engine-loop-timeout-count\tNumber of cycles to wait before signalling an error.\n"
"graphics-engine-micro-delay-count\tNumber of cycles spin-wait between register accesses.\n"
"graphics-engine-fifo-blocking-factor\tNumber of fifo entries to wait for by default.\n"
"rectfill-options\tControlling fill functionality.\n"
"bitblt-options\tControlling fill functionality.\n"
"linedraw-options\tControlling line draw functionality.\n"
"spansfill-options\tControlling spans fill functionality.\n"
"pointdraw-options\tControlling plot point functionality.\n"
"fontdraw-options\tControlling the kinds of fonts the display library should handle, whether we should attempt to download fonts into offscreen memory and whether font drawing should be in ATI or IBM modes.\n"
;

/*
 * Lookup a name in a table.
 */
static int
mach_options_lookup_name(const char *name_p, const char *const *name_list_p)
{
	int name_index = 0;
	
	while (*name_list_p)
	{
		if (strcmp(*name_list_p, name_p))
		{
			name_index ++;
			name_list_p ++;
		}
		else
		{

#if (defined(__DEBUG__))
			if(mach_options_debug)
			{
				(void) fprintf(debug_stream_p,
						"(mach_options_ lookup) \"%s\" "
						"index = %d.\n", name_p, name_index);
					
			}
#endif
			return name_index;
			
		}
	}
	return -1;
	
}

/*
 * Get the next token.
 */

static char * 
mach_options_parse_get_next_token(char *character_p)
{
	/* CONSTANTCONDITION */
	while (1)
	{
		/*
		 * Skip leading WS.
		 */
		while( (*character_p != EOS) && isspace(*character_p))
		{
			character_p ++;
		}
		if (*character_p == EOS)
		{
			break;
		}
		else if(*character_p == '#')
		{
			/*
			 * Comment.  Skip till new line.
			 */
			while ((*character_p != EOS) && (*character_p != '\n'))
			{
				character_p ++;
			}
		}
		else if (*character_p == '\\')
		{
			*character_p ++ = ' ';	/* replace '\' */
			*character_p = (*character_p == '\n') ? ' ' : *character_p;
		}
		else
		{
			return character_p;
		}
	}
	return (char *) 0;
}		

/*
 * mach_options_parse : parse options.
 */
function struct mach_options_structure *
mach_options_parse (struct mach_options_structure *option_struct_p,
			   const char *option_string_p)
{
	char * character_p;
	char * option_check_integer_p; /* return value of strtol() */
	struct stat stat_buf;
	
	char *option_list_p;		/* modifiable copy of option list */
	int option_name_index;		/* option keyword index */
	int option_enum_index;		/* enumeration value index */
	int option_enum_is_inverted; /* for !<value> parsing */
	
	char *tmp_p;				/* temporary */
	char *option_name_p, *option_value_p; /* for separating name=value */
	FILE *option_file_p;
	
	
	if (!option_struct_p)
	{
		option_struct_p = allocate_memory(sizeof (struct
												  mach_options_structure));
		if (!option_struct_p)
		{
			perror(DEFAULT_OPTION_CANNOT_ALLOCATE_MEMORY_MESSAGE);
			goto error;
			
		}
		
		/*
		 * Copy the defaults.
		 */
		*option_struct_p = mach_options_default;
		
	}

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "(mach_options_parse) "
				"option_string = \"%s\"\n", option_string_p);
	}
#endif

	/*
	 * Save the option string as we are going to munge it.
	 */
	option_list_p = strdup(option_string_p);
	
	character_p =
		mach_options_parse_get_next_token(option_list_p);
	
	while(character_p)
	{
		/*
		 * parse the token, looking for name'='value pairs.
		 */
		option_name_p = character_p;
		while ((*character_p != EOS) && 
			   (*character_p != '='))
		{
			character_p ++;
		}
		if (*character_p != '=')
		{
			/*
			 * Error encountered.
			 */
			(void) fprintf(stderr, 
						   DEFAULT_OPTION_MALFORMED_OPTION_STRING_MESSAGE,
						   option_name_p);
			
			free_memory(option_list_p);
			return (struct mach_options_structure *) 0;
			
		}
		else
		{
			*character_p++ = EOS;
			if (*character_p == EOS)
			{
				/*
				 * Error encountered.
				 */
				(void) fprintf(stderr, 
							   DEFAULT_OPTION_MALFORMED_OPTION_STRING_MESSAGE,
							   option_name_p);
			
				free_memory(option_list_p);
				return (struct mach_options_structure *) 0;
				
			}
			/*
			 * Look for terminating white-space.
			 */
			if (*character_p == '\"')
			{
				/*
				 * Terminated by a '\"'.
				 */
				*character_p ++ = EOS;
				option_value_p = character_p;
				
				while ((*character_p != EOS) && 
					   (*character_p != '\"'))
				{
					character_p ++;
				}
				if (*character_p == EOS)
				{
					(void) fprintf(stderr,
						DEFAULT_OPTION_UNTERMINATED_STRING_CONSTANT_MESSAGE,
								   option_name_p);
					free_memory (option_list_p);
					return (struct mach_options_structure *) 0;
				}
				else
				{
					*character_p ++ = EOS;
				}
			}
			else
			{
				/*
				 * White space terminated.
				 */
				option_value_p = character_p;

				/* CONSTANTCONDITION */
				while (1)
				{
					
					while ( (*character_p != EOS) && ! isspace(*character_p))
					{
						character_p ++;
					}
			
					if (*character_p != EOS)
					{

						if (*character_p == '\n' && *(character_p-1) == '\\')
						{
							/*
							 * Skip backslashed newline.
							 */
							character_p ++;
						}
						else
						{
							*character_p++ = EOS;
							break;
						}
					}
					else
					{
						break;
					}

				}			
			}
		}

		/*
		 * Analyze the option name and option value extracted.
		 */
		option_name_index =
			mach_options_lookup_name(option_name_p, &(mach_options_keywords[0]));
				
		if (option_name_index == -1)
		{
			(void) fprintf(stderr,
					DEFAULT_OPTION_UNRECOGNIZED_OPTION_MESSAGE,
					option_name_p);
			free_memory (option_list_p);
			return (struct mach_options_structure *) 0;
		}
#if (defined(__DEBUG__))
		else
		{
			if (mach_options_debug)
			{
				(void) fprintf(debug_stream_p,
						"(mach_options_parse) recognized "
						"\"%s\" of type \"%s\", value "
						"\"%s\".\n", 
						option_name_p,
						option_type_dump[option_index_to_option_kind[option_name_index]],
						option_value_p);
				
			}
		}
#endif
	
		/*
		 * Depending on the kind of code, take action.
		 */
		switch (option_name_index)
		{

			
case 0 :	/* bitblt-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			mach_options_lookup_name(option_value_p, &(mach_options_bitblt_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "bitblt-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->bitblt_options &= 
				(~mach_options_bitblt_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->bitblt_options |= 
				(mach_options_bitblt_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "(mach_options_parse) enum bitblt-options value %d.\n",
			option_struct_p->bitblt_options);
	}
#endif

	break;

case 1 :	/* chipset-name */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_chipset_name_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "chipset-name");
		goto error;
	}
	option_struct_p->chipset_name = mach_options_chipset_name_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum chipset-name value '%s'\n",
			mach_options_chipset_name_keywords[option_enum_index]);
	}
#endif
	break;

case 2 :	/* chipset-revision */
	option_struct_p->chipset_revision = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	chipset-revision = \"%s\"\n",
			option_struct_p->chipset_revision);
	}
#endif

	break;

case 3 :	/* clock-chip-name */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_clock_chip_name_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "clock-chip-name");
		goto error;
	}
	option_struct_p->clock_chip_name = mach_options_clock_chip_name_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum clock-chip-name value '%s'\n",
			mach_options_clock_chip_name_keywords[option_enum_index]);
	}
#endif
	break;

case 4 :	/* crtc-parameters */
	option_struct_p->crtc_parameters = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	crtc-parameters = \"%s\"\n",
			option_struct_p->crtc_parameters);
	}
#endif

	break;


case 5 :	/* crtc-start-offset */
	option_struct_p->crtc_start_offset = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->crtc_start_offset == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"crtc-start-offset");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	crtc-start-offset = %d\n",
				option_struct_p->crtc_start_offset);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->crtc_start_offset >= 0) && (option_struct_p->crtc_start_offset <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"crtc-start-offset");
		goto error;
	}

	break;

case 6 :	/* cursor-byte-swap */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_cursor_byte_swap_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "cursor-byte-swap");
		goto error;
	}
	option_struct_p->cursor_byte_swap = mach_options_cursor_byte_swap_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum cursor-byte-swap value '%s'\n",
			mach_options_cursor_byte_swap_keywords[option_enum_index]);
	}
#endif
	break;

case 7 :	/* cursor-max-size */
	option_struct_p->cursor_max_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	cursor-max-size = \"%s\"\n",
			option_struct_p->cursor_max_size);
	}
#endif

	break;

case 8 :	/* cursor-type */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_cursor_type_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "cursor-type");
		goto error;
	}
	option_struct_p->cursor_type = mach_options_cursor_type_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum cursor-type value '%s'\n",
			mach_options_cursor_type_keywords[option_enum_index]);
	}
#endif
	break;

case 9 :	/* dac-16-bit-color-mode */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_dac_16_bit_color_mode_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-16-bit-color-mode");
		goto error;
	}
	option_struct_p->dac_16_bit_color_mode = mach_options_dac_16_bit_color_mode_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum dac-16-bit-color-mode value '%s'\n",
			mach_options_dac_16_bit_color_mode_keywords[option_enum_index]);
	}
#endif
	break;

case 10 :	/* dac-24-bit-color-mode */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_dac_24_bit_color_mode_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-24-bit-color-mode");
		goto error;
	}
	option_struct_p->dac_24_bit_color_mode = mach_options_dac_24_bit_color_mode_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum dac-24-bit-color-mode value '%s'\n",
			mach_options_dac_24_bit_color_mode_keywords[option_enum_index]);
	}
#endif
	break;


case 11 :	/* dac-access-delay-count */
	option_struct_p->dac_access_delay_count = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->dac_access_delay_count == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"dac-access-delay-count");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	dac-access-delay-count = %d\n",
				option_struct_p->dac_access_delay_count);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->dac_access_delay_count >= 1) && (option_struct_p->dac_access_delay_count <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"dac-access-delay-count");
		goto error;
	}

	break;


case 12 :	/* dac-blank-adjust */
	option_struct_p->dac_blank_adjust = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->dac_blank_adjust == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"dac-blank-adjust");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	dac-blank-adjust = %d\n",
				option_struct_p->dac_blank_adjust);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->dac_blank_adjust >= -1) && (option_struct_p->dac_blank_adjust <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"dac-blank-adjust");
		goto error;
	}

	break;


case 13 :	/* dac-max-frequency */
	option_struct_p->dac_max_frequency = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->dac_max_frequency == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"dac-max-frequency");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	dac-max-frequency = %d\n",
				option_struct_p->dac_max_frequency);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->dac_max_frequency >= 0) && (option_struct_p->dac_max_frequency <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"dac-max-frequency");
		goto error;
	}

	break;

case 14 :	/* dac-name */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_dac_name_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-name");
		goto error;
	}
	option_struct_p->dac_name = mach_options_dac_name_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum dac-name value '%s'\n",
			mach_options_dac_name_keywords[option_enum_index]);
	}
#endif
	break;


case 15 :	/* dac-pixel-delay */
	option_struct_p->dac_pixel_delay = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->dac_pixel_delay == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"dac-pixel-delay");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	dac-pixel-delay = %d\n",
				option_struct_p->dac_pixel_delay);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->dac_pixel_delay >= -1) && (option_struct_p->dac_pixel_delay <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"dac-pixel-delay");
		goto error;
	}

	break;

case 16 :	/* dac-rgb-width */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_dac_rgb_width_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-rgb-width");
		goto error;
	}
	option_struct_p->dac_rgb_width = mach_options_dac_rgb_width_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum dac-rgb-width value '%s'\n",
			mach_options_dac_rgb_width_keywords[option_enum_index]);
	}
#endif
	break;

case 17 :	/* fontdraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			mach_options_lookup_name(option_value_p, &(mach_options_fontdraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "fontdraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->fontdraw_options &= 
				(~mach_options_fontdraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->fontdraw_options |= 
				(mach_options_fontdraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "(mach_options_parse) enum fontdraw-options value %d.\n",
			option_struct_p->fontdraw_options);
	}
#endif

	break;

case 18 :	/* glyph-cache-size */
	option_struct_p->glyph_cache_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	glyph-cache-size = \"%s\"\n",
			option_struct_p->glyph_cache_size);
	}
#endif

	break;


case 19 :	/* graphics-engine-fifo-blocking-factor */
	option_struct_p->graphics_engine_fifo_blocking_factor = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->graphics_engine_fifo_blocking_factor == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"graphics-engine-fifo-blocking-factor");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	graphics-engine-fifo-blocking-factor = %d\n",
				option_struct_p->graphics_engine_fifo_blocking_factor);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->graphics_engine_fifo_blocking_factor >= 1) && (option_struct_p->graphics_engine_fifo_blocking_factor <= 16)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"graphics-engine-fifo-blocking-factor");
		goto error;
	}

	break;


case 20 :	/* graphics-engine-loop-timeout-count */
	option_struct_p->graphics_engine_loop_timeout_count = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->graphics_engine_loop_timeout_count == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"graphics-engine-loop-timeout-count");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	graphics-engine-loop-timeout-count = %d\n",
				option_struct_p->graphics_engine_loop_timeout_count);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->graphics_engine_loop_timeout_count >= 1) && (option_struct_p->graphics_engine_loop_timeout_count <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"graphics-engine-loop-timeout-count");
		goto error;
	}

	break;


case 21 :	/* graphics-engine-micro-delay-count */
	option_struct_p->graphics_engine_micro_delay_count = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->graphics_engine_micro_delay_count == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"graphics-engine-micro-delay-count");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	graphics-engine-micro-delay-count = %d\n",
				option_struct_p->graphics_engine_micro_delay_count);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->graphics_engine_micro_delay_count >= 1) && (option_struct_p->graphics_engine_micro_delay_count <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"graphics-engine-micro-delay-count");
		goto error;
	}

	break;

case 22 :	/* horizontal-line-draw-optimizations */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_horizontal_line_draw_optimizations_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "horizontal-line-draw-optimizations");
		goto error;
	}
	option_struct_p->horizontal_line_draw_optimizations = mach_options_horizontal_line_draw_optimizations_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum horizontal-line-draw-optimizations value '%s'\n",
			mach_options_horizontal_line_draw_optimizations_keywords[option_enum_index]);
	}
#endif
	break;

case 23 :	/* io-bus-width */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_io_bus_width_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "io-bus-width");
		goto error;
	}
	option_struct_p->io_bus_width = mach_options_io_bus_width_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum io-bus-width value '%s'\n",
			mach_options_io_bus_width_keywords[option_enum_index]);
	}
#endif
	break;

case 24 :	/* linedraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			mach_options_lookup_name(option_value_p, &(mach_options_linedraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "linedraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->linedraw_options &= 
				(~mach_options_linedraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->linedraw_options |= 
				(mach_options_linedraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "(mach_options_parse) enum linedraw-options value %d.\n",
			option_struct_p->linedraw_options);
	}
#endif

	break;


case 25 :	/* max-number-of-glyphs-in-downloadable-font */
	option_struct_p->max_number_of_glyphs_in_downloadable_font = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->max_number_of_glyphs_in_downloadable_font == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"max-number-of-glyphs-in-downloadable-font");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	max-number-of-glyphs-in-downloadable-font = %d\n",
				option_struct_p->max_number_of_glyphs_in_downloadable_font);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->max_number_of_glyphs_in_downloadable_font >= 0) && (option_struct_p->max_number_of_glyphs_in_downloadable_font <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"max-number-of-glyphs-in-downloadable-font");
		goto error;
	}

	break;

case 26 :	/* modedb-string */
	option_struct_p->modedb_string = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	modedb-string = \"%s\"\n",
			option_struct_p->modedb_string);
	}
#endif

	break;

case 27 :	/* monitor-sync-type */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_monitor_sync_type_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "monitor-sync-type");
		goto error;
	}
	option_struct_p->monitor_sync_type = mach_options_monitor_sync_type_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum monitor-sync-type value '%s'\n",
			mach_options_monitor_sync_type_keywords[option_enum_index]);
	}
#endif
	break;


case 28 :	/* number-of-downloadable-cursors */
	option_struct_p->number_of_downloadable_cursors = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->number_of_downloadable_cursors == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"number-of-downloadable-cursors");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	number-of-downloadable-cursors = %d\n",
				option_struct_p->number_of_downloadable_cursors);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->number_of_downloadable_cursors >= 0) && (option_struct_p->number_of_downloadable_cursors <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"number-of-downloadable-cursors");
		goto error;
	}

	break;


case 29 :	/* number-of-downloadable-fonts */
	option_struct_p->number_of_downloadable_fonts = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->number_of_downloadable_fonts == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"number-of-downloadable-fonts");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	number-of-downloadable-fonts = %d\n",
				option_struct_p->number_of_downloadable_fonts);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->number_of_downloadable_fonts >= 0) && (option_struct_p->number_of_downloadable_fonts <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"number-of-downloadable-fonts");
		goto error;
	}

	break;


case 30 :	/* number-of-graphics-states */
	option_struct_p->number_of_graphics_states = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->number_of_graphics_states == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"number-of-graphics-states");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	number-of-graphics-states = %d\n",
				option_struct_p->number_of_graphics_states);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->number_of_graphics_states >= 0) && (option_struct_p->number_of_graphics_states <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"number-of-graphics-states");
		goto error;
	}

	break;


case 31 :	/* offscreen-stipple-padded-height */
	option_struct_p->offscreen_stipple_padded_height = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->offscreen_stipple_padded_height == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"offscreen-stipple-padded-height");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	offscreen-stipple-padded-height = %d\n",
				option_struct_p->offscreen_stipple_padded_height);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->offscreen_stipple_padded_height >= 0) && (option_struct_p->offscreen_stipple_padded_height <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"offscreen-stipple-padded-height");
		goto error;
	}

	break;


case 32 :	/* offscreen-stipple-padded-width */
	option_struct_p->offscreen_stipple_padded_width = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->offscreen_stipple_padded_width == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"offscreen-stipple-padded-width");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	offscreen-stipple-padded-width = %d\n",
				option_struct_p->offscreen_stipple_padded_width);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->offscreen_stipple_padded_width >= 0) && (option_struct_p->offscreen_stipple_padded_width <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"offscreen-stipple-padded-width");
		goto error;
	}

	break;


case 33 :	/* offscreen-tile-padded-height */
	option_struct_p->offscreen_tile_padded_height = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->offscreen_tile_padded_height == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"offscreen-tile-padded-height");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	offscreen-tile-padded-height = %d\n",
				option_struct_p->offscreen_tile_padded_height);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->offscreen_tile_padded_height >= 0) && (option_struct_p->offscreen_tile_padded_height <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"offscreen-tile-padded-height");
		goto error;
	}

	break;


case 34 :	/* offscreen-tile-padded-width */
	option_struct_p->offscreen_tile_padded_width = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->offscreen_tile_padded_width == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"offscreen-tile-padded-width");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	offscreen-tile-padded-width = %d\n",
				option_struct_p->offscreen_tile_padded_width);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->offscreen_tile_padded_width >= 0) && (option_struct_p->offscreen_tile_padded_width <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"offscreen-tile-padded-width");
		goto error;
	}

	break;


case 35 :	/* omm-full-coalesce-watermark */
	option_struct_p->omm_full_coalesce_watermark = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_full_coalesce_watermark == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-full-coalesce-watermark");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-full-coalesce-watermark = %d\n",
				option_struct_p->omm_full_coalesce_watermark);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_full_coalesce_watermark >= 0) && (option_struct_p->omm_full_coalesce_watermark <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-full-coalesce-watermark");
		goto error;
	}

	break;


case 36 :	/* omm-hash-list-size */
	option_struct_p->omm_hash_list_size = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_hash_list_size == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-hash-list-size");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-hash-list-size = %d\n",
				option_struct_p->omm_hash_list_size);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_hash_list_size >= 0) && (option_struct_p->omm_hash_list_size <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-hash-list-size");
		goto error;
	}

	break;


case 37 :	/* omm-horizontal-constraint */
	option_struct_p->omm_horizontal_constraint = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_horizontal_constraint == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-horizontal-constraint");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-horizontal-constraint = %d\n",
				option_struct_p->omm_horizontal_constraint);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_horizontal_constraint >= 0) && (option_struct_p->omm_horizontal_constraint <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-horizontal-constraint");
		goto error;
	}

	break;

case 38 :	/* omm-named-allocation-list */
	option_struct_p->omm_named_allocation_list = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-named-allocation-list = \"%s\"\n",
			option_struct_p->omm_named_allocation_list);
	}
#endif

	break;


case 39 :	/* omm-neighbour-list-increment */
	option_struct_p->omm_neighbour_list_increment = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_neighbour_list_increment == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-neighbour-list-increment");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-neighbour-list-increment = %d\n",
				option_struct_p->omm_neighbour_list_increment);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_neighbour_list_increment >= 0) && (option_struct_p->omm_neighbour_list_increment <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-neighbour-list-increment");
		goto error;
	}

	break;


case 40 :	/* omm-vertical-constraint */
	option_struct_p->omm_vertical_constraint = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_vertical_constraint == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-vertical-constraint");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-vertical-constraint = %d\n",
				option_struct_p->omm_vertical_constraint);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_vertical_constraint >= 0) && (option_struct_p->omm_vertical_constraint <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-vertical-constraint");
		goto error;
	}

	break;

case 41 :	/* options-file */
	/*
	 * look up the file.
	 */
	if (stat(option_value_p, &stat_buf) != 0)
	{
		/*
		 * Warn the user of missing files, and continue.
		 */
		(void) fprintf(stderr, 
					DEFAULT_OPTION_CANNOT_STAT_FILE_ARGUMENT_MESSAGE,
					option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		break;
	}

	if (stat_buf.st_size == 0)
	{
		/*
		 * Warn the user of zero length files, and continue.
		 */
		(void) fprintf(stderr,
					DEFAULT_OPTION_ZERO_LENGTH_FILE_ARGUMENT_MESSAGE,
					option_value_p, "options-file");
		break;
	}

	/* read the option file into a buffer */
	if (!(tmp_p = allocate_and_clear_memory(stat_buf.st_size+1)))
	{
		perror(DEFAULT_OPTION_CANNOT_ALLOCATE_MEMORY_MESSAGE);
		goto error;
	}

	if( (option_file_p = fopen(option_value_p, "r")) == NULL)
	{

		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_OPEN_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		goto error;
	}
	if (fread(tmp_p, stat_buf.st_size, 1, option_file_p) != 1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_READ_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		goto error;
	}

	fclose (option_file_p);

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "\t\"%s\"\n", tmp_p);
	}
#endif
	/*
	 * Recursively invoke the interpreter.
	 */
	if (!mach_options_parse(option_struct_p, tmp_p))
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_PROCESS_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		free_memory(tmp_p);
		goto error;
	}
	free_memory(tmp_p);
	break;

case 42 :	/* options-variable */

	tmp_p = getenv(option_value_p);
	if (tmp_p)
	{

#if (defined(__DEBUG__))
		if (mach_options_debug)
		{
			(void) fprintf(debug_stream_p, "\t\"%s\"\n", tmp_p);
		}
#endif
		if (!mach_options_parse(option_struct_p, tmp_p))
		{
			(void) fprintf(stderr, 
					DEFAULT_OPTION_CANNOT_PROCESS_ENVIRONMENT_ARGUMENT_MESSAGE,
				option_value_p, "options-variable");
			goto error;
		}

	}
	break;

case 43 :	/* overscan-color */
	option_struct_p->overscan_color = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	overscan-color = \"%s\"\n",
			option_struct_p->overscan_color);
	}
#endif

	break;


case 44 :	/* overscan-h */
	option_struct_p->overscan_h = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->overscan_h == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"overscan-h");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	overscan-h = %d\n",
				option_struct_p->overscan_h);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->overscan_h >= 0) && (option_struct_p->overscan_h <= 255)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"overscan-h");
		goto error;
	}

	break;


case 45 :	/* overscan-v */
	option_struct_p->overscan_v = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->overscan_v == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"overscan-v");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	overscan-v = %d\n",
				option_struct_p->overscan_v);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->overscan_v >= 0) && (option_struct_p->overscan_v <= 65535)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"overscan-v");
		goto error;
	}

	break;

case 46 :	/* passthrough-override */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_passthrough_override_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "passthrough-override");
		goto error;
	}
	option_struct_p->passthrough_override = mach_options_passthrough_override_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum passthrough-override value '%s'\n",
			mach_options_passthrough_override_keywords[option_enum_index]);
	}
#endif
	break;

case 47 :	/* pointdraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			mach_options_lookup_name(option_value_p, &(mach_options_pointdraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "pointdraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->pointdraw_options &= 
				(~mach_options_pointdraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->pointdraw_options |= 
				(mach_options_pointdraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "(mach_options_parse) enum pointdraw-options value %d.\n",
			option_struct_p->pointdraw_options);
	}
#endif

	break;

case 48 :	/* rectfill-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			mach_options_lookup_name(option_value_p, &(mach_options_rectfill_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "rectfill-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->rectfill_options &= 
				(~mach_options_rectfill_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->rectfill_options |= 
				(mach_options_rectfill_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "(mach_options_parse) enum rectfill-options value %d.\n",
			option_struct_p->rectfill_options);
	}
#endif

	break;

case 49 :	/* screen-8-4-bit-visual-list */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			mach_options_lookup_name(option_value_p, &(mach_options_screen_8_4_bit_visual_list_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "screen-8-4-bit-visual-list");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->screen_8_4_bit_visual_list &= 
				(~mach_options_screen_8_4_bit_visual_list_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->screen_8_4_bit_visual_list |= 
				(mach_options_screen_8_4_bit_visual_list_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "(mach_options_parse) enum screen-8-4-bit-visual-list value %d.\n",
			option_struct_p->screen_8_4_bit_visual_list);
	}
#endif

	break;

case 50 :	/* si-interface-version */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_si_interface_version_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "si-interface-version");
		goto error;
	}
	option_struct_p->si_interface_version = mach_options_si_interface_version_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum si-interface-version value '%s'\n",
			mach_options_si_interface_version_keywords[option_enum_index]);
	}
#endif
	break;

case 51 :	/* spansfill-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			mach_options_lookup_name(option_value_p, &(mach_options_spansfill_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "spansfill-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->spansfill_options &= 
				(~mach_options_spansfill_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->spansfill_options |= 
				(mach_options_spansfill_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "(mach_options_parse) enum spansfill-options value %d.\n",
			option_struct_p->spansfill_options);
	}
#endif

	break;

case 52 :	/* static-colormap-description-file */
	option_struct_p->static_colormap_description_file = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	static-colormap-description-file = \"%s\"\n",
			option_struct_p->static_colormap_description_file);
	}
#endif

	break;

case 53 :	/* stipple-best-size */
	option_struct_p->stipple_best_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	stipple-best-size = \"%s\"\n",
			option_struct_p->stipple_best_size);
	}
#endif

	break;

case 54 :	/* tile-best-size */
	option_struct_p->tile_best_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	tile-best-size = \"%s\"\n",
			option_struct_p->tile_best_size);
	}
#endif

	break;

case 55 :	/* verbose-startup */
	if ((option_enum_index = 
		mach_options_lookup_name(option_value_p, &(mach_options_verbose_startup_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "verbose-startup");
		goto error;
	}
	option_struct_p->verbose_startup = mach_options_verbose_startup_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(mach_options_parse) enum verbose-startup value '%s'\n",
			mach_options_verbose_startup_keywords[option_enum_index]);
	}
#endif
	break;

case 56 :	/* video-memory-dimensions */
	option_struct_p->video_memory_dimensions = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	video-memory-dimensions = \"%s\"\n",
			option_struct_p->video_memory_dimensions);
	}
#endif

	break;


case 57 :	/* vram-fifo-depth */
	option_struct_p->vram_fifo_depth = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->vram_fifo_depth == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"vram-fifo-depth");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	vram-fifo-depth = %d\n",
				option_struct_p->vram_fifo_depth);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->vram_fifo_depth >= -1) && (option_struct_p->vram_fifo_depth <= 15)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"vram-fifo-depth");
		goto error;
	}

	break;


case 58 :	/* vt-switch-save-lines */
	option_struct_p->vt_switch_save_lines = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->vt_switch_save_lines == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"vt-switch-save-lines");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (mach_options_debug)
	{
		(void) fprintf(debug_stream_p, "	vt-switch-save-lines = %d\n",
				option_struct_p->vt_switch_save_lines);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->vt_switch_save_lines >= -1) && (option_struct_p->vt_switch_save_lines <= 2048)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"vt-switch-save-lines");
		goto error;
	}

	break;


			default :
				(void) fprintf(stderr,
						DEFAULT_OPTION_INTERNAL_ERROR_MESSAGE);
				free_memory(option_list_p);
				return (struct mach_options_structure *) 0;
			
		}
		
		/*
		 * while ...
		 */
		character_p = 
			mach_options_parse_get_next_token(character_p);
		
	}
	/*
	 * Free the space we allocated.
	 */
	free_memory(option_list_p);
	
	return option_struct_p;

  error:
	if (option_list_p)
	{
		free_memory(option_list_p);
	}
	
	return (struct mach_options_structure *) 0;
	
}

#if (defined(__TEST__))
int
main(int parameter_count, char ** parameter_pp)
{
	int i;
	int string_length = 0;
	char * options_p;

#if (defined(__DEBUG__))
	mach_options_debug = 
		getenv("mach_options_debug") ? TRUE :	FALSE;
	if (debug_stream_p == NULL && (debug_stream_p =
		    fopen(getenv("debug_stream"), "w")) == NULL)
	{
		debug_stream_p = stdout;
	}
#endif

	for(i = 1; i < parameter_count; i++)
	{
		string_length += strlen(*(parameter_pp + i));
	}
	options_p = allocate_memory(string_length + 1);
	*options_p = EOS;
	
	for(i = 1; i < parameter_count; i++)
	{
		strcat(options_p, *(parameter_pp +i));
	}

	mach_options_parse(0, options_p);

}

#endif
