/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#pragma ident	"@(#)mach64:mach64/m64_opt.c	1.11"

/***								-*- C -*-
 ***
 ***	Warning!  Target file, do not modify.
 ***	
 ***	Generated from: m64_opt.gen
 ***
 ***	Generated by: (genoptions 1.0.0).
 ***
 ***/

PUBLIC

#include "stdenv.h"
#include "global.h"


enum m64_options_si_interface_version
{
	M64_OPTIONS_SI_INTERFACE_VERSION_1_0,
	M64_OPTIONS_SI_INTERFACE_VERSION_1_1,
	M64_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE,
	m64_options_si_interface_version_end_enumeration
};

enum m64_options_framebuffer_access_for_core_server
{
	M64_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_YES,
	M64_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_NO,
	m64_options_framebuffer_access_for_core_server_end_enumeration
};

enum m64_options_cursor_type
{
	M64_OPTIONS_CURSOR_TYPE_HARDWARE_CURSOR,
	M64_OPTIONS_CURSOR_TYPE_SOFTWARE_CURSOR,
	m64_options_cursor_type_end_enumeration
};

enum m64_options_monitor_sync_type
{
	M64_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC,
	M64_OPTIONS_MONITOR_SYNC_TYPE_SYNC_ON_GREEN,
	M64_OPTIONS_MONITOR_SYNC_TYPE_SEPARATE_SYNC,
	m64_options_monitor_sync_type_end_enumeration
};

enum m64_options_vsync_polarity
{
	M64_OPTIONS_VSYNC_POLARITY_POSITIVE,
	M64_OPTIONS_VSYNC_POLARITY_NEGATIVE,
	M64_OPTIONS_VSYNC_POLARITY_DEFAULT,
	m64_options_vsync_polarity_end_enumeration
};

enum m64_options_hsync_polarity
{
	M64_OPTIONS_HSYNC_POLARITY_POSITIVE,
	M64_OPTIONS_HSYNC_POLARITY_NEGATIVE,
	M64_OPTIONS_HSYNC_POLARITY_DEFAULT,
	m64_options_hsync_polarity_end_enumeration
};

enum m64_options_revision_number
{
	M64_OPTIONS_REVISION_NUMBER_AUTO_DETECT,
	M64_OPTIONS_REVISION_NUMBER_0,
	M64_OPTIONS_REVISION_NUMBER_1,
	M64_OPTIONS_REVISION_NUMBER_2,
	m64_options_revision_number_end_enumeration
};

enum m64_options_enable_blocked_memory_write
{
	M64_OPTIONS_ENABLE_BLOCKED_MEMORY_WRITE_YES,
	M64_OPTIONS_ENABLE_BLOCKED_MEMORY_WRITE_NO,
	M64_OPTIONS_ENABLE_BLOCKED_MEMORY_WRITE_DEFAULT,
	m64_options_enable_blocked_memory_write_end_enumeration
};

enum m64_options_clock_chip_name
{
	M64_OPTIONS_CLOCK_CHIP_NAME_USE_BUILTIN_DEFAULT,
	m64_options_clock_chip_name_end_enumeration
};

enum m64_options_memory_aperture_type
{
	M64_OPTIONS_MEMORY_APERTURE_TYPE_USE_BUILTIN_DEFAULT,
	M64_OPTIONS_MEMORY_APERTURE_TYPE_SMALL_DUAL_PAGED,
	M64_OPTIONS_MEMORY_APERTURE_TYPE_BIG_LINEAR,
	m64_options_memory_aperture_type_end_enumeration
};

enum m64_options_memory_aperture_size
{
	M64_OPTIONS_MEMORY_APERTURE_SIZE_USE_4MB_APERTURE,
	M64_OPTIONS_MEMORY_APERTURE_SIZE_USE_8MB_APERTURE,
	m64_options_memory_aperture_size_end_enumeration
};

enum m64_options_dac_name
{
	M64_OPTIONS_DAC_NAME_AUTO_DETECT,
	M64_OPTIONS_DAC_NAME_ATI68875,
	M64_OPTIONS_DAC_NAME_BT476,
	M64_OPTIONS_DAC_NAME_BT481,
	M64_OPTIONS_DAC_NAME_ATI68860,
	M64_OPTIONS_DAC_NAME_STG1700,
	M64_OPTIONS_DAC_NAME_SC15021,
	M64_OPTIONS_DAC_NAME_STG1702,
	m64_options_dac_name_end_enumeration
};

enum m64_options_dac_rgb_width
{
	M64_OPTIONS_DAC_RGB_WIDTH_6,
	M64_OPTIONS_DAC_RGB_WIDTH_8,
	M64_OPTIONS_DAC_RGB_WIDTH_DEFAULT,
	m64_options_dac_rgb_width_end_enumeration
};

enum m64_options_dac_32_bit_color_mode
{
	M64_OPTIONS_DAC_32_BIT_COLOR_MODE_RGBA,
	M64_OPTIONS_DAC_32_BIT_COLOR_MODE_ABGR,
	M64_OPTIONS_DAC_32_BIT_COLOR_MODE_ARGB,
	M64_OPTIONS_DAC_32_BIT_COLOR_MODE_DEFAULT,
	m64_options_dac_32_bit_color_mode_end_enumeration
};

enum m64_options_dac_16_bit_color_mode
{
	M64_OPTIONS_DAC_16_BIT_COLOR_MODE_555,
	M64_OPTIONS_DAC_16_BIT_COLOR_MODE_565,
	m64_options_dac_16_bit_color_mode_end_enumeration
};


#define	M64_OPTIONS_SCREEN_VISUAL_LIST_STATIC_GRAY	1
#define	M64_OPTIONS_SCREEN_VISUAL_LIST_GRAY_SCALE	2
#define	M64_OPTIONS_SCREEN_VISUAL_LIST_STATIC_COLOR	4
#define	M64_OPTIONS_SCREEN_VISUAL_LIST_PSEUDO_COLOR	8
#define	M64_OPTIONS_SCREEN_VISUAL_LIST_TRUE_COLOR	16
#define	M64_OPTIONS_SCREEN_VISUAL_LIST_DIRECT_COLOR	32


#define	M64_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT	1
#define	M64_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT	2
#define	M64_OPTIONS_RECTFILL_OPTIONS_USE_TILE_SHRINK	4
#define	M64_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT	8
#define	M64_OPTIONS_RECTFILL_OPTIONS_USE_MONO_PATTERN	16
#define	M64_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY	32


#define	M64_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT	1
#define	M64_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT	2
#define	M64_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT	4
#define	M64_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT	8


#define	M64_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW	1
#define	M64_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES	2
#define	M64_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW	4
#define	M64_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_LINE	8


#define	M64_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL	1
#define	M64_OPTIONS_SPANSFILL_OPTIONS_USE_TILE_FILL	2
#define	M64_OPTIONS_SPANSFILL_OPTIONS_USE_STIPPLE_FILL	4


#define	M64_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT	1


#define	M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS	1
#define	M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS	2
#define	M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_PACKED_TERMINAL_FONTS	4
#define	M64_OPTIONS_FONTDRAW_OPTIONS_USE_OFFSCREEN_MEMORY	8


#define	M64_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS	1




struct m64_options_structure
{
	int arc_cache_size;
	unsigned int arcdraw_options;
	unsigned int bitblt_options;
	enum m64_options_clock_chip_name clock_chip_name;
	int crtc_display_fifo_low_watermark;
	char *crtc_parameters;
	int crtc_start_offset;
	char *cursor_max_size;
	enum m64_options_cursor_type cursor_type;
	enum m64_options_dac_16_bit_color_mode dac_16_bit_color_mode;
	enum m64_options_dac_32_bit_color_mode dac_32_bit_color_mode;
	int dac_access_delay_count;
	int dac_max_frequency;
	enum m64_options_dac_name dac_name;
	enum m64_options_dac_rgb_width dac_rgb_width;
	enum m64_options_enable_blocked_memory_write enable_blocked_memory_write;
	unsigned int fontdraw_options;
	enum m64_options_framebuffer_access_for_core_server framebuffer_access_for_core_server;
	char *glyph_cache_size;
	int graphics_engine_loop_timeout_count;
	int graphics_engine_micro_delay_count;
	int host_data_transfer_blocking_factor;
	enum m64_options_hsync_polarity hsync_polarity;
	unsigned int linedraw_options;
	int max_number_of_glyphs_in_downloadable_font;
	int maximum_offscreen_downloadable_bitmap_height;
	int maximum_offscreen_downloadable_bitmap_width;
	enum m64_options_memory_aperture_size memory_aperture_size;
	enum m64_options_memory_aperture_type memory_aperture_type;
	enum m64_options_monitor_sync_type monitor_sync_type;
	int number_of_downloadable_cursors;
	int number_of_downloadable_fonts;
	int number_of_graphics_states;
	int offscreen_tile_padded_height;
	int offscreen_tile_padded_width;
	int omm_full_coalesce_watermark;
	int omm_hash_list_size;
	int omm_horizontal_constraint;
	char *omm_named_allocation_list;
	int omm_neighbour_list_increment;
	int omm_vertical_constraint;
	unsigned int pointdraw_options;
	unsigned int rectfill_options;
	enum m64_options_revision_number revision_number;
	unsigned int screen_visual_list;
	enum m64_options_si_interface_version si_interface_version;
	int small_stipple_conversion_threshold;
	unsigned int spansfill_options;
	char *static_colormap_description_file;
	char *stipple_best_size;
	char *tile_best_size;
	int verbose_startup;
	enum m64_options_vsync_polarity vsync_polarity;
	int vt_switch_save_lines;

};

/*
 * Names of the option defaults
 */

#define M64_OPTIONS_ARC_CACHE_SIZE_DEFAULT\
	16
#define M64_OPTIONS_ARCDRAW_OPTIONS_DEFAULT\
	( M64_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS )
#define M64_OPTIONS_BITBLT_OPTIONS_DEFAULT\
	( M64_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT |M64_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT |M64_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT |M64_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT )
#define M64_OPTIONS_CLOCK_CHIP_NAME_DEFAULT\
	M64_OPTIONS_CLOCK_CHIP_NAME_USE_BUILTIN_DEFAULT
#define M64_OPTIONS_CRTC_DISPLAY_FIFO_LOW_WATERMARK_DEFAULT\
	0
#define M64_OPTIONS_CRTC_PARAMETERS_DEFAULT 0
#define M64_OPTIONS_CRTC_START_OFFSET_DEFAULT\
	0
#define M64_OPTIONS_CURSOR_MAX_SIZE_DEFAULT 0
#define M64_OPTIONS_CURSOR_TYPE_DEFAULT\
	M64_OPTIONS_CURSOR_TYPE_HARDWARE_CURSOR
#define M64_OPTIONS_DAC_16_BIT_COLOR_MODE_DEFAULT\
	M64_OPTIONS_DAC_16_BIT_COLOR_MODE_565
#define M64_OPTIONS_DAC_32_BIT_COLOR_MODE_DEFAULT\
	M64_OPTIONS_DAC_32_BIT_COLOR_MODE_DEFAULT
#define M64_OPTIONS_DAC_ACCESS_DELAY_COUNT_DEFAULT\
	10000
#define M64_OPTIONS_DAC_MAX_FREQUENCY_DEFAULT\
	0
#define M64_OPTIONS_DAC_NAME_DEFAULT\
	M64_OPTIONS_DAC_NAME_AUTO_DETECT
#define M64_OPTIONS_DAC_RGB_WIDTH_DEFAULT\
	M64_OPTIONS_DAC_RGB_WIDTH_6
#define M64_OPTIONS_ENABLE_BLOCKED_MEMORY_WRITE_DEFAULT\
	M64_OPTIONS_ENABLE_BLOCKED_MEMORY_WRITE_DEFAULT
#define M64_OPTIONS_FONTDRAW_OPTIONS_DEFAULT\
	( M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS |M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS |M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_PACKED_TERMINAL_FONTS |M64_OPTIONS_FONTDRAW_OPTIONS_USE_OFFSCREEN_MEMORY )
#define M64_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_DEFAULT\
	M64_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_NO
#define M64_OPTIONS_GLYPH_CACHE_SIZE_DEFAULT\
	"64X64"
#define M64_OPTIONS_GRAPHICS_ENGINE_LOOP_TIMEOUT_COUNT_DEFAULT\
	200000
#define M64_OPTIONS_GRAPHICS_ENGINE_MICRO_DELAY_COUNT_DEFAULT\
	40
#define M64_OPTIONS_HOST_DATA_TRANSFER_BLOCKING_FACTOR_DEFAULT\
	16
#define M64_OPTIONS_HSYNC_POLARITY_DEFAULT\
	M64_OPTIONS_HSYNC_POLARITY_DEFAULT
#define M64_OPTIONS_LINEDRAW_OPTIONS_DEFAULT\
	( M64_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW |M64_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW |M64_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES |M64_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_LINE )
#define M64_OPTIONS_MAX_NUMBER_OF_GLYPHS_IN_DOWNLOADABLE_FONT_DEFAULT\
	256
#define M64_OPTIONS_MAXIMUM_OFFSCREEN_DOWNLOADABLE_BITMAP_HEIGHT_DEFAULT\
	256
#define M64_OPTIONS_MAXIMUM_OFFSCREEN_DOWNLOADABLE_BITMAP_WIDTH_DEFAULT\
	256
#define M64_OPTIONS_MEMORY_APERTURE_SIZE_DEFAULT\
	M64_OPTIONS_MEMORY_APERTURE_SIZE_USE_4MB_APERTURE
#define M64_OPTIONS_MEMORY_APERTURE_TYPE_DEFAULT\
	M64_OPTIONS_MEMORY_APERTURE_TYPE_USE_BUILTIN_DEFAULT
#define M64_OPTIONS_MONITOR_SYNC_TYPE_DEFAULT\
	M64_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC
#define M64_OPTIONS_NUMBER_OF_DOWNLOADABLE_CURSORS_DEFAULT\
	1
#define M64_OPTIONS_NUMBER_OF_DOWNLOADABLE_FONTS_DEFAULT\
	17
#define M64_OPTIONS_NUMBER_OF_GRAPHICS_STATES_DEFAULT\
	4
#define M64_OPTIONS_OFFSCREEN_TILE_PADDED_HEIGHT_DEFAULT\
	32
#define M64_OPTIONS_OFFSCREEN_TILE_PADDED_WIDTH_DEFAULT\
	128
#define M64_OPTIONS_OMM_FULL_COALESCE_WATERMARK_DEFAULT\
	2
#define M64_OPTIONS_OMM_HASH_LIST_SIZE_DEFAULT\
	512
#define M64_OPTIONS_OMM_HORIZONTAL_CONSTRAINT_DEFAULT\
	0
#define M64_OPTIONS_OMM_NAMED_ALLOCATION_LIST_DEFAULT\
	""
#define M64_OPTIONS_OMM_NEIGHBOUR_LIST_INCREMENT_DEFAULT\
	20
#define M64_OPTIONS_OMM_VERTICAL_CONSTRAINT_DEFAULT\
	0
#define M64_OPTIONS_POINTDRAW_OPTIONS_DEFAULT\
	( M64_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT )
#define M64_OPTIONS_RECTFILL_OPTIONS_DEFAULT\
	( M64_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT |M64_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT |M64_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY |M64_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT |M64_OPTIONS_RECTFILL_OPTIONS_USE_MONO_PATTERN |M64_OPTIONS_RECTFILL_OPTIONS_USE_TILE_SHRINK )
#define M64_OPTIONS_REVISION_NUMBER_DEFAULT\
	M64_OPTIONS_REVISION_NUMBER_AUTO_DETECT
#define M64_OPTIONS_SCREEN_VISUAL_LIST_DEFAULT 0
#define M64_OPTIONS_SI_INTERFACE_VERSION_DEFAULT\
	M64_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE
#define M64_OPTIONS_SMALL_STIPPLE_CONVERSION_THRESHOLD_DEFAULT\
	32
#define M64_OPTIONS_SPANSFILL_OPTIONS_DEFAULT\
	( M64_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL )
#define M64_OPTIONS_STATIC_COLORMAP_DESCRIPTION_FILE_DEFAULT 0
#define M64_OPTIONS_STIPPLE_BEST_SIZE_DEFAULT\
	"64X64"
#define M64_OPTIONS_TILE_BEST_SIZE_DEFAULT\
	"64X64"
#define M64_OPTIONS_VERBOSE_STARTUP_DEFAULT\
	0
#define M64_OPTIONS_VSYNC_POLARITY_DEFAULT\
	M64_OPTIONS_VSYNC_POLARITY_DEFAULT
#define M64_OPTIONS_VT_SWITCH_SAVE_LINES_DEFAULT\
	0


#if (defined(__DEBUG__))
export boolean	m64_options_debug = FALSE;
#endif


PRIVATE
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <limits.h>

/*
 * The types of options.
 */

enum m64_options_kind
{
	M64_OPTIONS_MULTIPLE_ENUMERATION,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_OPTION_ENVIRONMENT,
	M64_OPTIONS_OPTION_FILE,
	M64_OPTIONS_STRING,
	M64_OPTIONS_UNIQUE_ENUMERATION,

	m64_options_end_option_types
};

#if (defined(__DEBUG__))

static const char *const option_type_dump[] = 
{
	"multiple-enumeration",
	"numeric",
	"option-environment",
	"option-file",
	"string",
	"unique-enumeration",

	0
};

#endif

/*
 * The default options.
 */
static struct m64_options_structure m64_options_default =
{
	16,
	( M64_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS ),
	( M64_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT |M64_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT |M64_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT |M64_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT ),
	M64_OPTIONS_CLOCK_CHIP_NAME_USE_BUILTIN_DEFAULT,
	0,
	0,
	0,
	0,
	M64_OPTIONS_CURSOR_TYPE_HARDWARE_CURSOR,
	M64_OPTIONS_DAC_16_BIT_COLOR_MODE_565,
	M64_OPTIONS_DAC_32_BIT_COLOR_MODE_DEFAULT,
	10000,
	0,
	M64_OPTIONS_DAC_NAME_AUTO_DETECT,
	M64_OPTIONS_DAC_RGB_WIDTH_6,
	M64_OPTIONS_ENABLE_BLOCKED_MEMORY_WRITE_DEFAULT,
	( M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS |M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS |M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_PACKED_TERMINAL_FONTS |M64_OPTIONS_FONTDRAW_OPTIONS_USE_OFFSCREEN_MEMORY ),
	M64_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_NO,
	"64x64",
	200000,
	40,
	16,
	M64_OPTIONS_HSYNC_POLARITY_DEFAULT,
	( M64_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW |M64_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW |M64_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES |M64_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_LINE ),
	256,
	256,
	256,
	M64_OPTIONS_MEMORY_APERTURE_SIZE_USE_4MB_APERTURE,
	M64_OPTIONS_MEMORY_APERTURE_TYPE_USE_BUILTIN_DEFAULT,
	M64_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC,
	1,
	17,
	4,
	32,
	128,
	2,
	512,
	0,
	"",
	20,
	0,
	( M64_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT ),
	( M64_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT |M64_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT |M64_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY |M64_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT |M64_OPTIONS_RECTFILL_OPTIONS_USE_MONO_PATTERN |M64_OPTIONS_RECTFILL_OPTIONS_USE_TILE_SHRINK ),
	M64_OPTIONS_REVISION_NUMBER_AUTO_DETECT,
	0,
	M64_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE,
	32,
	( M64_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL ),
	0,
	"64x64",
	"64x64",
	0,
	M64_OPTIONS_VSYNC_POLARITY_DEFAULT,
	0,

};

/*
 * The list of option keywords.
 */

static const char *const m64_options_keywords[] = 
{
	"arc-cache-size",
	"arcdraw-options",
	"bitblt-options",
	"clock-chip-name",
	"crtc-display-fifo-low-watermark",
	"crtc-parameters",
	"crtc-start-offset",
	"cursor-max-size",
	"cursor-type",
	"dac-16-bit-color-mode",
	"dac-32-bit-color-mode",
	"dac-access-delay-count",
	"dac-max-frequency",
	"dac-name",
	"dac-rgb-width",
	"enable-blocked-memory-write",
	"fontdraw-options",
	"framebuffer-access-for-core-server",
	"glyph-cache-size",
	"graphics-engine-loop-timeout-count",
	"graphics-engine-micro-delay-count",
	"host-data-transfer-blocking-factor",
	"hsync-polarity",
	"linedraw-options",
	"max-number-of-glyphs-in-downloadable-font",
	"maximum-offscreen-downloadable-bitmap-height",
	"maximum-offscreen-downloadable-bitmap-width",
	"memory-aperture-size",
	"memory-aperture-type",
	"monitor-sync-type",
	"number-of-downloadable-cursors",
	"number-of-downloadable-fonts",
	"number-of-graphics-states",
	"offscreen-tile-padded-height",
	"offscreen-tile-padded-width",
	"omm-full-coalesce-watermark",
	"omm-hash-list-size",
	"omm-horizontal-constraint",
	"omm-named-allocation-list",
	"omm-neighbour-list-increment",
	"omm-vertical-constraint",
	"options-file",
	"options-variable",
	"pointdraw-options",
	"rectfill-options",
	"revision-number",
	"screen-visual-list",
	"si-interface-version",
	"small-stipple-conversion-threshold",
	"spansfill-options",
	"static-colormap-description-file",
	"stipple-best-size",
	"tile-best-size",
	"verbose-startup",
	"vsync-polarity",
	"vt-switch-save-lines",

	0
};
/*
 * This array maps the option index to the option kind.
 */
static enum m64_options_kind option_index_to_option_kind[] =
{
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_MULTIPLE_ENUMERATION,
	M64_OPTIONS_MULTIPLE_ENUMERATION,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_STRING,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_STRING,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_MULTIPLE_ENUMERATION,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_STRING,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_MULTIPLE_ENUMERATION,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_STRING,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_OPTION_FILE,
	M64_OPTIONS_OPTION_ENVIRONMENT,
	M64_OPTIONS_MULTIPLE_ENUMERATION,
	M64_OPTIONS_MULTIPLE_ENUMERATION,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_MULTIPLE_ENUMERATION,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_MULTIPLE_ENUMERATION,
	M64_OPTIONS_STRING,
	M64_OPTIONS_STRING,
	M64_OPTIONS_STRING,
	M64_OPTIONS_NUMERIC,
	M64_OPTIONS_UNIQUE_ENUMERATION,
	M64_OPTIONS_NUMERIC,

	m64_options_end_option_types
};



/*
 * List of enumeration keywords.
 */

static const char *const m64_options_si_interface_version_keywords[] =
{
	"1-0",
	"1-1",
	"auto-configure",
	0
};
static const enum m64_options_si_interface_version m64_options_si_interface_version_index_to_value[] =
{
	M64_OPTIONS_SI_INTERFACE_VERSION_1_0,
	M64_OPTIONS_SI_INTERFACE_VERSION_1_1,
	M64_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE,
	m64_options_si_interface_version_end_enumeration
};
static const char *const m64_options_framebuffer_access_for_core_server_keywords[] =
{
	"yes",
	"no",
	0
};
static const enum m64_options_framebuffer_access_for_core_server m64_options_framebuffer_access_for_core_server_index_to_value[] =
{
	M64_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_YES,
	M64_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_NO,
	m64_options_framebuffer_access_for_core_server_end_enumeration
};
static const char *const m64_options_cursor_type_keywords[] =
{
	"hardware-cursor",
	"software-cursor",
	0
};
static const enum m64_options_cursor_type m64_options_cursor_type_index_to_value[] =
{
	M64_OPTIONS_CURSOR_TYPE_HARDWARE_CURSOR,
	M64_OPTIONS_CURSOR_TYPE_SOFTWARE_CURSOR,
	m64_options_cursor_type_end_enumeration
};
static const char *const m64_options_monitor_sync_type_keywords[] =
{
	"composite-sync",
	"sync-on-green",
	"separate-sync",
	0
};
static const enum m64_options_monitor_sync_type m64_options_monitor_sync_type_index_to_value[] =
{
	M64_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC,
	M64_OPTIONS_MONITOR_SYNC_TYPE_SYNC_ON_GREEN,
	M64_OPTIONS_MONITOR_SYNC_TYPE_SEPARATE_SYNC,
	m64_options_monitor_sync_type_end_enumeration
};
static const char *const m64_options_vsync_polarity_keywords[] =
{
	"positive",
	"negative",
	"default",
	0
};
static const enum m64_options_vsync_polarity m64_options_vsync_polarity_index_to_value[] =
{
	M64_OPTIONS_VSYNC_POLARITY_POSITIVE,
	M64_OPTIONS_VSYNC_POLARITY_NEGATIVE,
	M64_OPTIONS_VSYNC_POLARITY_DEFAULT,
	m64_options_vsync_polarity_end_enumeration
};
static const char *const m64_options_hsync_polarity_keywords[] =
{
	"positive",
	"negative",
	"default",
	0
};
static const enum m64_options_hsync_polarity m64_options_hsync_polarity_index_to_value[] =
{
	M64_OPTIONS_HSYNC_POLARITY_POSITIVE,
	M64_OPTIONS_HSYNC_POLARITY_NEGATIVE,
	M64_OPTIONS_HSYNC_POLARITY_DEFAULT,
	m64_options_hsync_polarity_end_enumeration
};
static const char *const m64_options_revision_number_keywords[] =
{
	"auto-detect",
	"0",
	"1",
	"2",
	0
};
static const enum m64_options_revision_number m64_options_revision_number_index_to_value[] =
{
	M64_OPTIONS_REVISION_NUMBER_AUTO_DETECT,
	M64_OPTIONS_REVISION_NUMBER_0,
	M64_OPTIONS_REVISION_NUMBER_1,
	M64_OPTIONS_REVISION_NUMBER_2,
	m64_options_revision_number_end_enumeration
};
static const char *const m64_options_enable_blocked_memory_write_keywords[] =
{
	"yes",
	"no",
	"default",
	0
};
static const enum m64_options_enable_blocked_memory_write m64_options_enable_blocked_memory_write_index_to_value[] =
{
	M64_OPTIONS_ENABLE_BLOCKED_MEMORY_WRITE_YES,
	M64_OPTIONS_ENABLE_BLOCKED_MEMORY_WRITE_NO,
	M64_OPTIONS_ENABLE_BLOCKED_MEMORY_WRITE_DEFAULT,
	m64_options_enable_blocked_memory_write_end_enumeration
};
static const char *const m64_options_clock_chip_name_keywords[] =
{
	"use-builtin-default",
	0
};
static const enum m64_options_clock_chip_name m64_options_clock_chip_name_index_to_value[] =
{
	M64_OPTIONS_CLOCK_CHIP_NAME_USE_BUILTIN_DEFAULT,
	m64_options_clock_chip_name_end_enumeration
};
static const char *const m64_options_memory_aperture_type_keywords[] =
{
	"use-builtin-default",
	"small-dual-paged",
	"big-linear",
	0
};
static const enum m64_options_memory_aperture_type m64_options_memory_aperture_type_index_to_value[] =
{
	M64_OPTIONS_MEMORY_APERTURE_TYPE_USE_BUILTIN_DEFAULT,
	M64_OPTIONS_MEMORY_APERTURE_TYPE_SMALL_DUAL_PAGED,
	M64_OPTIONS_MEMORY_APERTURE_TYPE_BIG_LINEAR,
	m64_options_memory_aperture_type_end_enumeration
};
static const char *const m64_options_memory_aperture_size_keywords[] =
{
	"use-4mb-aperture",
	"use-8mb-aperture",
	0
};
static const enum m64_options_memory_aperture_size m64_options_memory_aperture_size_index_to_value[] =
{
	M64_OPTIONS_MEMORY_APERTURE_SIZE_USE_4MB_APERTURE,
	M64_OPTIONS_MEMORY_APERTURE_SIZE_USE_8MB_APERTURE,
	m64_options_memory_aperture_size_end_enumeration
};
static const char *const m64_options_dac_name_keywords[] =
{
	"auto-detect",
	"ati68875",
	"bt476",
	"bt481",
	"ati68860",
	"stg1700",
	"sc15021",
	"stg1702",
	0
};
static const enum m64_options_dac_name m64_options_dac_name_index_to_value[] =
{
	M64_OPTIONS_DAC_NAME_AUTO_DETECT,
	M64_OPTIONS_DAC_NAME_ATI68875,
	M64_OPTIONS_DAC_NAME_BT476,
	M64_OPTIONS_DAC_NAME_BT481,
	M64_OPTIONS_DAC_NAME_ATI68860,
	M64_OPTIONS_DAC_NAME_STG1700,
	M64_OPTIONS_DAC_NAME_SC15021,
	M64_OPTIONS_DAC_NAME_STG1702,
	m64_options_dac_name_end_enumeration
};
static const char *const m64_options_dac_rgb_width_keywords[] =
{
	"6",
	"8",
	"default",
	0
};
static const enum m64_options_dac_rgb_width m64_options_dac_rgb_width_index_to_value[] =
{
	M64_OPTIONS_DAC_RGB_WIDTH_6,
	M64_OPTIONS_DAC_RGB_WIDTH_8,
	M64_OPTIONS_DAC_RGB_WIDTH_DEFAULT,
	m64_options_dac_rgb_width_end_enumeration
};
static const char *const m64_options_dac_32_bit_color_mode_keywords[] =
{
	"rgba",
	"abgr",
	"argb",
	"default",
	0
};
static const enum m64_options_dac_32_bit_color_mode m64_options_dac_32_bit_color_mode_index_to_value[] =
{
	M64_OPTIONS_DAC_32_BIT_COLOR_MODE_RGBA,
	M64_OPTIONS_DAC_32_BIT_COLOR_MODE_ABGR,
	M64_OPTIONS_DAC_32_BIT_COLOR_MODE_ARGB,
	M64_OPTIONS_DAC_32_BIT_COLOR_MODE_DEFAULT,
	m64_options_dac_32_bit_color_mode_end_enumeration
};
static const char *const m64_options_dac_16_bit_color_mode_keywords[] =
{
	"555",
	"565",
	0
};
static const enum m64_options_dac_16_bit_color_mode m64_options_dac_16_bit_color_mode_index_to_value[] =
{
	M64_OPTIONS_DAC_16_BIT_COLOR_MODE_555,
	M64_OPTIONS_DAC_16_BIT_COLOR_MODE_565,
	m64_options_dac_16_bit_color_mode_end_enumeration
};
static const char *const m64_options_screen_visual_list_keywords[] =
{
	"static-gray",
	"gray-scale",
	"static-color",
	"pseudo-color",
	"true-color",
	"direct-color",
	0
};
static const int m64_options_screen_visual_list_index_to_value[] =
{
	M64_OPTIONS_SCREEN_VISUAL_LIST_STATIC_GRAY,
	M64_OPTIONS_SCREEN_VISUAL_LIST_GRAY_SCALE,
	M64_OPTIONS_SCREEN_VISUAL_LIST_STATIC_COLOR,
	M64_OPTIONS_SCREEN_VISUAL_LIST_PSEUDO_COLOR,
	M64_OPTIONS_SCREEN_VISUAL_LIST_TRUE_COLOR,
	M64_OPTIONS_SCREEN_VISUAL_LIST_DIRECT_COLOR,
	-1
};
static const char *const m64_options_rectfill_options_keywords[] =
{
	"use-solid-fill-rect",
	"use-tile-fill-rect",
	"use-tile-shrink",
	"use-stipple-fill-rect",
	"use-mono-pattern",
	"use-offscreen-memory",
	0
};
static const int m64_options_rectfill_options_index_to_value[] =
{
	M64_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT,
	M64_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT,
	M64_OPTIONS_RECTFILL_OPTIONS_USE_TILE_SHRINK,
	M64_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT,
	M64_OPTIONS_RECTFILL_OPTIONS_USE_MONO_PATTERN,
	M64_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY,
	-1
};
static const char *const m64_options_bitblt_options_keywords[] =
{
	"use-ss-bitblt",
	"use-ms-bitblt",
	"use-sm-bitblt",
	"use-ms-stplblt",
	0
};
static const int m64_options_bitblt_options_index_to_value[] =
{
	M64_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT,
	M64_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT,
	M64_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT,
	M64_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT,
	-1
};
static const char *const m64_options_linedraw_options_keywords[] =
{
	"use-line-draw",
	"use-line-rectangles",
	"use-segment-draw",
	"use-dashed-line",
	0
};
static const int m64_options_linedraw_options_index_to_value[] =
{
	M64_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW,
	M64_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES,
	M64_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW,
	M64_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_LINE,
	-1
};
static const char *const m64_options_spansfill_options_keywords[] =
{
	"use-solid-fill",
	"use-tile-fill",
	"use-stipple-fill",
	0
};
static const int m64_options_spansfill_options_index_to_value[] =
{
	M64_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL,
	M64_OPTIONS_SPANSFILL_OPTIONS_USE_TILE_FILL,
	M64_OPTIONS_SPANSFILL_OPTIONS_USE_STIPPLE_FILL,
	-1
};
static const char *const m64_options_pointdraw_options_keywords[] =
{
	"use-plot-point",
	0
};
static const int m64_options_pointdraw_options_index_to_value[] =
{
	M64_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT,
	-1
};
static const char *const m64_options_fontdraw_options_keywords[] =
{
	"draw-non-terminal-fonts",
	"draw-terminal-fonts",
	"draw-packed-terminal-fonts",
	"use-offscreen-memory",
	0
};
static const int m64_options_fontdraw_options_index_to_value[] =
{
	M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS,
	M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS,
	M64_OPTIONS_FONTDRAW_OPTIONS_DRAW_PACKED_TERMINAL_FONTS,
	M64_OPTIONS_FONTDRAW_OPTIONS_USE_OFFSCREEN_MEMORY,
	-1
};
static const char *const m64_options_arcdraw_options_keywords[] =
{
	"draw-one-bit-arcs",
	0
};
static const int m64_options_arcdraw_options_index_to_value[] =
{
	M64_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS,
	-1
};


/*
 * Help message.
 */
static const char *const m64_options_description = 
"si-interface-version\tThe version number that the SDD returns to the SI server.\n"
"verbose-startup\tPrint messages about chipset configuration if set to 1.\n"
"framebuffer-access-for-core-server\tWhether or not the framebuffer is visible to the core server or not.  If yes the core server can directly draw into the video memory without calling the sdd specific drawing routines if required.  Currently this seems to have some problems with the 16 bit modes.\n"
"cursor-type\tCursor implementation types.\n"
"cursor-max-size\tMaximum size of a cursor in WxH.\n"
"number-of-downloadable-cursors\tNumber of downloaded hardware cursors.  `0' means use internal default.\n"
"number-of-downloadable-fonts\tNumber of downloaded fonts.  `0' means to turn off font handling in the SDD.\n"
"max-number-of-glyphs-in-downloadable-font\tThe maximum number of glyphs in a font suitable for downloading.  0 means ignore this criterion.\n"
"vt-switch-save-lines\tNumber of lines of screen to save.  Exact values would save the total memory occupied by the x server.  0 means use internal default (all physical memory).\n"
"number-of-graphics-states\tNumber of SDD graphics states.  `0' means use internal default.\n"
"tile-best-size\tBest tile size as seen by the Si code\n"
"stipple-best-size\tBest stipple size as seen by si code.\n"
"offscreen-tile-padded-width\tPad small tiles to this value in offscreen memory.  Should be a power of two.\n"
"offscreen-tile-padded-height\tPad small tiles to this value in offscreen memory.  Should be a power of two.\n"
"small-stipple-conversion-threshold\tConvert stipples that are a power of two and having repeated patterns into 8x8 patterns so that they can be stippled using the faster graphics engine monochrome pattern registers.  This value specifies the maximum width and height of such a stipple.  Only powers of 2 are legal values.  This option is used even for tiles which get reduced to stipples because they have only 2 colors.\n"
"maximum-offscreen-downloadable-bitmap-width\tDo not download tiles of more than this width into offscreen memory\n"
"maximum-offscreen-downloadable-bitmap-height\tDo not download tiles of more than this height into offscreen memory\n"
"glyph-cache-size\tCache glyphs smaller than this size in offscreen memory\n"
"arc-cache-size\tThe number of arcs to cache in the display library\n"
"crtc-start-offset\tOffset of start of display memory.\n"
"crtc-parameters\tcrtc parameters (similar to modeDB lines).  String consists of the following space seperated decimal values clock_frequency h_active_display h_sync_start h_sync_end h_total v_active_display v_sync_start v_sync_end v_total\n"
"crtc-display-fifo-low-watermark\tThis option is valid for dram cards.  Specifies the display fifo threshold.  Experiment with this option if you see random disturbances on the screen, screen jitter etc.  A value of 0 indicates the use of builtin default value.\n"
"monitor-sync-type\tThe monitor's SYNC type.\n"
"vsync-polarity\tThe polarity of the v-sync pulse.  Actually monitor dependent.  But most monitors could handle either case.\n"
"hsync-polarity\tThe polarity of the h-sync pulse.  Actually monitor dependent.  But most monitors could handle either case.\n"
"omm-named-allocation-list\tNamed allocation requests for the offscreen memory manager.\n"
"omm-horizontal-constraint\tThe widths of all offscreen memory requests are rounded up to this value.  O means use an internal heuristic.\n"
"omm-vertical-constraint\tThe heights of all offscreen memory requests are rounded up to this value.  0 means use an internal heuristic.\n"
"omm-neighbour-list-increment\tNumber of neighbour list nodes allocated at one time.  Neighbour lists are managed during every allocate and free operation.  0 means use an internal heuristic.\n"
"omm-full-coalesce-watermark\tIf the number of currently allocated blocks falls below this value the omm will attempt a full coalesion operation.  Remember that coalesion is an expensive operation.\n"
"omm-hash-list-size\tSize of the hash table of omm free blocks.  0 means use an an internal heuristic.\n"
"revision-number\tThe stepping number on the chipset.\n"
"graphics-engine-loop-timeout-count\tNumber of cycles to wait before signalling an error.\n"
"graphics-engine-micro-delay-count\tNumber of cycles spin-wait between register accesses.\n"
"enable-blocked-memory-write\tWhether blocked writes to memory are permitted.  selecting default selects bios defaults.\n"
"clock-chip-name\tName of the clock chip on the board.\n"
"memory-aperture-type\tType of memory aperture.  Built in default is to use small dual paged apertures for the ISA based boards and the big linear aperture for the other bus types.\n"
"memory-aperture-size\tSize of big linear memory aperture.  Built in default is to use the 4MB aperture for cases where the video memory is less than or equal to 4MB and for cases where the video memory is more, use 8MB aperture.This option allows user to override the built-in-default to 8 MB\n"
"dac-name\tThe type of DAC on board.\n"
"dac-max-frequency\tEvery dac has a maximum frequency to which it can operate without damaging itself/card/monitor.  This option allows overriding of the builtin default value for the dac.  A value of 0 (default) will use the builtin defaults.  UTMOST CAUTION SHOULD BE USED WHILE CHANGING THIS OPTION.  Wrong use can damage your system.  The value is in Hz.\n"
"dac-access-delay-count\tNumber of cycles to wait between dac accesses.\n"
"dac-rgb-width\tNumber of significant bits per R/G/B output.  `default' will use the industry standard of 6.\n"
"dac-32-bit-color-mode\tOrder of R/G/B pixels in a 32 bit word.\n"
"dac-16-bit-color-mode\tBits for R/G/B in 16 bit mode.  Switch between the two\n"
"screen-visual-list\tSupported display visuals in addition to the screen default visual specified in the server config file.  Remember that for screen depths greater than 8 only true-color or direct-color can appear as the list.  Caveat : the core server does not seem to handle multiple visuals per screen yet ...\n"
"host-data-transfer-blocking-factor\tnumber of longwords to pump in one shot thro host data transfer registers.\n"
"rectfill-options\tControlling fill functionality.\n"
"bitblt-options\tControlling bitblt functionality.\n"
"linedraw-options\tControlling line draw functionality.\n"
"spansfill-options\tControlling spans fill functionality.\n"
"pointdraw-options\tControlling plot point functionality.\n"
"fontdraw-options\tControlling the kinds of fonts the display library should handle, and whether we should attempt to download fonts into offscreen memory.\n"
"arcdraw-options\tControls the drawing operation for arcs.\n"
;

/*
 * Lookup a name in a table.
 */
static int
m64_options_lookup_name(const char *name_p, const char *const *name_list_p)
{
	int name_index = 0;
	
	while (*name_list_p)
	{
		if (strcmp(*name_list_p, name_p))
		{
			name_index ++;
			name_list_p ++;
		}
		else
		{

#if (defined(__DEBUG__))
			if(m64_options_debug)
			{
				(void) fprintf(debug_stream_p,
						"(m64_options_ lookup) \"%s\" "
						"index = %d.\n", name_p, name_index);
					
			}
#endif
			return name_index;
			
		}
	}
	return -1;
	
}

/*
 * Get the next token.
 */

static char * 
m64_options_parse_get_next_token(char *character_p)
{
	/* CONSTANTCONDITION */
	while (1)
	{
		/*
		 * Skip leading WS.
		 */
		while( (*character_p != EOS) && isspace(*character_p))
		{
			character_p ++;
		}
		if (*character_p == EOS)
		{
			break;
		}
		else if(*character_p == '#')
		{
			/*
			 * Comment.  Skip till new line.
			 */
			while ((*character_p != EOS) && (*character_p != '\n'))
			{
				character_p ++;
			}
		}
		else if (*character_p == '\\')
		{
			*character_p ++ = ' ';	/* replace '\' */
			*character_p = (*character_p == '\n') ? ' ' : *character_p;
		}
		else
		{
			return character_p;
		}
	}
	return (char *) 0;
}		

/*
 * m64_options_parse : parse options.
 */
function struct m64_options_structure *
m64_options_parse (struct m64_options_structure *option_struct_p,
			   const char *option_string_p)
{
	char * character_p;
	char * option_check_integer_p; /* return value of strtol() */
	struct stat stat_buf;
	
	char *option_list_p;		/* modifiable copy of option list */
	int option_name_index;		/* option keyword index */
	int option_enum_index;		/* enumeration value index */
	int option_enum_is_inverted; /* for !<value> parsing */
	
	char *tmp_p;				/* temporary */
	char *option_name_p, *option_value_p; /* for separating name=value */
	FILE *option_file_p;
	
	
	if (!option_struct_p)
	{
		option_struct_p = allocate_memory(sizeof (struct
												  m64_options_structure));
		if (!option_struct_p)
		{
			perror(DEFAULT_OPTION_CANNOT_ALLOCATE_MEMORY_MESSAGE);
			goto error;
			
		}
		
		/*
		 * Copy the defaults.
		 */
		*option_struct_p = m64_options_default;
		
	}

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "(m64_options_parse) "
				"option_string = \"%s\"\n", option_string_p);
	}
#endif

	/*
	 * Save the option string as we are going to munge it.
	 */
	option_list_p = strdup(option_string_p);
	
	character_p =
		m64_options_parse_get_next_token(option_list_p);
	
	while(character_p)
	{
		/*
		 * parse the token, looking for name'='value pairs.
		 */
		option_name_p = character_p;
		while ((*character_p != EOS) && 
			   (*character_p != '='))
		{
			character_p ++;
		}
		if (*character_p != '=')
		{
			/*
			 * Error encountered.
			 */
			(void) fprintf(stderr, 
						   DEFAULT_OPTION_MALFORMED_OPTION_STRING_MESSAGE,
						   option_name_p);
			
			free_memory(option_list_p);
			return (struct m64_options_structure *) 0;
			
		}
		else
		{
			*character_p++ = EOS;
			if (*character_p == EOS)
			{
				/*
				 * Error encountered.
				 */
				(void) fprintf(stderr, 
							   DEFAULT_OPTION_MALFORMED_OPTION_STRING_MESSAGE,
							   option_name_p);
			
				free_memory(option_list_p);
				return (struct m64_options_structure *) 0;
				
			}
			/*
			 * Look for terminating white-space.
			 */
			if (*character_p == '\"')
			{
				/*
				 * Terminated by a '\"'.
				 */
				*character_p ++ = EOS;
				option_value_p = character_p;
				
				while ((*character_p != EOS) && 
					   (*character_p != '\"'))
				{
					character_p ++;
				}
				if (*character_p == EOS)
				{
					(void) fprintf(stderr,
						DEFAULT_OPTION_UNTERMINATED_STRING_CONSTANT_MESSAGE,
								   option_name_p);
					free_memory (option_list_p);
					return (struct m64_options_structure *) 0;
				}
				else
				{
					*character_p ++ = EOS;
				}
			}
			else
			{
				/*
				 * White space terminated.
				 */
				option_value_p = character_p;

				/* CONSTANTCONDITION */
				while (1)
				{
					
					while ( (*character_p != EOS) && ! isspace(*character_p))
					{
						character_p ++;
					}
			
					if (*character_p != EOS)
					{

						if (*character_p == '\n' && *(character_p-1) == '\\')
						{
							/*
							 * Skip backslashed newline.
							 */
							character_p ++;
						}
						else
						{
							*character_p++ = EOS;
							break;
						}
					}
					else
					{
						break;
					}

				}			
			}
		}

		/*
		 * Analyze the option name and option value extracted.
		 */
		option_name_index =
			m64_options_lookup_name(option_name_p, &(m64_options_keywords[0]));
				
		if (option_name_index == -1)
		{
			(void) fprintf(stderr,
					DEFAULT_OPTION_UNRECOGNIZED_OPTION_MESSAGE,
					option_name_p);
			free_memory (option_list_p);
			return (struct m64_options_structure *) 0;
		}
#if (defined(__DEBUG__))
		else
		{
			if (m64_options_debug)
			{
				(void) fprintf(debug_stream_p,
						"(m64_options_parse) recognized "
						"\"%s\" of type \"%s\", value "
						"\"%s\".\n", 
						option_name_p,
						option_type_dump[option_index_to_option_kind[option_name_index]],
						option_value_p);
				
			}
		}
#endif
	
		/*
		 * Depending on the kind of code, take action.
		 */
		switch (option_name_index)
		{

			

case 0 :	/* arc-cache-size */
	option_struct_p->arc_cache_size = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->arc_cache_size == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"arc-cache-size");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	arc-cache-size = %d\n",
				option_struct_p->arc_cache_size);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->arc_cache_size >= 0) && (option_struct_p->arc_cache_size <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"arc-cache-size");
		goto error;
	}

	break;

case 1 :	/* arcdraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			m64_options_lookup_name(option_value_p, &(m64_options_arcdraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "arcdraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->arcdraw_options &= 
				(~m64_options_arcdraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->arcdraw_options |= 
				(m64_options_arcdraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "(m64_options_parse) enum arcdraw-options value %d.\n",
			option_struct_p->arcdraw_options);
	}
#endif

	break;

case 2 :	/* bitblt-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			m64_options_lookup_name(option_value_p, &(m64_options_bitblt_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "bitblt-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->bitblt_options &= 
				(~m64_options_bitblt_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->bitblt_options |= 
				(m64_options_bitblt_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "(m64_options_parse) enum bitblt-options value %d.\n",
			option_struct_p->bitblt_options);
	}
#endif

	break;

case 3 :	/* clock-chip-name */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_clock_chip_name_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "clock-chip-name");
		goto error;
	}
	option_struct_p->clock_chip_name = m64_options_clock_chip_name_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum clock-chip-name value '%s'\n",
			m64_options_clock_chip_name_keywords[option_enum_index]);
	}
#endif
	break;


case 4 :	/* crtc-display-fifo-low-watermark */
	option_struct_p->crtc_display_fifo_low_watermark = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->crtc_display_fifo_low_watermark == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"crtc-display-fifo-low-watermark");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	crtc-display-fifo-low-watermark = %d\n",
				option_struct_p->crtc_display_fifo_low_watermark);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->crtc_display_fifo_low_watermark >= 0) && (option_struct_p->crtc_display_fifo_low_watermark <= 15)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"crtc-display-fifo-low-watermark");
		goto error;
	}

	break;

case 5 :	/* crtc-parameters */
	option_struct_p->crtc_parameters = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	crtc-parameters = \"%s\"\n",
			option_struct_p->crtc_parameters);
	}
#endif

	break;


case 6 :	/* crtc-start-offset */
	option_struct_p->crtc_start_offset = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->crtc_start_offset == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"crtc-start-offset");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	crtc-start-offset = %d\n",
				option_struct_p->crtc_start_offset);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->crtc_start_offset >= 0) && (option_struct_p->crtc_start_offset <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"crtc-start-offset");
		goto error;
	}

	break;

case 7 :	/* cursor-max-size */
	option_struct_p->cursor_max_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	cursor-max-size = \"%s\"\n",
			option_struct_p->cursor_max_size);
	}
#endif

	break;

case 8 :	/* cursor-type */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_cursor_type_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "cursor-type");
		goto error;
	}
	option_struct_p->cursor_type = m64_options_cursor_type_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum cursor-type value '%s'\n",
			m64_options_cursor_type_keywords[option_enum_index]);
	}
#endif
	break;

case 9 :	/* dac-16-bit-color-mode */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_dac_16_bit_color_mode_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-16-bit-color-mode");
		goto error;
	}
	option_struct_p->dac_16_bit_color_mode = m64_options_dac_16_bit_color_mode_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum dac-16-bit-color-mode value '%s'\n",
			m64_options_dac_16_bit_color_mode_keywords[option_enum_index]);
	}
#endif
	break;

case 10 :	/* dac-32-bit-color-mode */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_dac_32_bit_color_mode_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-32-bit-color-mode");
		goto error;
	}
	option_struct_p->dac_32_bit_color_mode = m64_options_dac_32_bit_color_mode_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum dac-32-bit-color-mode value '%s'\n",
			m64_options_dac_32_bit_color_mode_keywords[option_enum_index]);
	}
#endif
	break;


case 11 :	/* dac-access-delay-count */
	option_struct_p->dac_access_delay_count = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->dac_access_delay_count == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"dac-access-delay-count");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	dac-access-delay-count = %d\n",
				option_struct_p->dac_access_delay_count);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->dac_access_delay_count >= 1) && (option_struct_p->dac_access_delay_count <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"dac-access-delay-count");
		goto error;
	}

	break;


case 12 :	/* dac-max-frequency */
	option_struct_p->dac_max_frequency = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->dac_max_frequency == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"dac-max-frequency");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	dac-max-frequency = %d\n",
				option_struct_p->dac_max_frequency);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->dac_max_frequency >= 0) && (option_struct_p->dac_max_frequency <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"dac-max-frequency");
		goto error;
	}

	break;

case 13 :	/* dac-name */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_dac_name_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-name");
		goto error;
	}
	option_struct_p->dac_name = m64_options_dac_name_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum dac-name value '%s'\n",
			m64_options_dac_name_keywords[option_enum_index]);
	}
#endif
	break;

case 14 :	/* dac-rgb-width */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_dac_rgb_width_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-rgb-width");
		goto error;
	}
	option_struct_p->dac_rgb_width = m64_options_dac_rgb_width_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum dac-rgb-width value '%s'\n",
			m64_options_dac_rgb_width_keywords[option_enum_index]);
	}
#endif
	break;

case 15 :	/* enable-blocked-memory-write */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_enable_blocked_memory_write_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "enable-blocked-memory-write");
		goto error;
	}
	option_struct_p->enable_blocked_memory_write = m64_options_enable_blocked_memory_write_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum enable-blocked-memory-write value '%s'\n",
			m64_options_enable_blocked_memory_write_keywords[option_enum_index]);
	}
#endif
	break;

case 16 :	/* fontdraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			m64_options_lookup_name(option_value_p, &(m64_options_fontdraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "fontdraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->fontdraw_options &= 
				(~m64_options_fontdraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->fontdraw_options |= 
				(m64_options_fontdraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "(m64_options_parse) enum fontdraw-options value %d.\n",
			option_struct_p->fontdraw_options);
	}
#endif

	break;

case 17 :	/* framebuffer-access-for-core-server */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_framebuffer_access_for_core_server_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "framebuffer-access-for-core-server");
		goto error;
	}
	option_struct_p->framebuffer_access_for_core_server = m64_options_framebuffer_access_for_core_server_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum framebuffer-access-for-core-server value '%s'\n",
			m64_options_framebuffer_access_for_core_server_keywords[option_enum_index]);
	}
#endif
	break;

case 18 :	/* glyph-cache-size */
	option_struct_p->glyph_cache_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	glyph-cache-size = \"%s\"\n",
			option_struct_p->glyph_cache_size);
	}
#endif

	break;


case 19 :	/* graphics-engine-loop-timeout-count */
	option_struct_p->graphics_engine_loop_timeout_count = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->graphics_engine_loop_timeout_count == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"graphics-engine-loop-timeout-count");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	graphics-engine-loop-timeout-count = %d\n",
				option_struct_p->graphics_engine_loop_timeout_count);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->graphics_engine_loop_timeout_count >= 1) && (option_struct_p->graphics_engine_loop_timeout_count <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"graphics-engine-loop-timeout-count");
		goto error;
	}

	break;


case 20 :	/* graphics-engine-micro-delay-count */
	option_struct_p->graphics_engine_micro_delay_count = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->graphics_engine_micro_delay_count == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"graphics-engine-micro-delay-count");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	graphics-engine-micro-delay-count = %d\n",
				option_struct_p->graphics_engine_micro_delay_count);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->graphics_engine_micro_delay_count >= 1) && (option_struct_p->graphics_engine_micro_delay_count <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"graphics-engine-micro-delay-count");
		goto error;
	}

	break;


case 21 :	/* host-data-transfer-blocking-factor */
	option_struct_p->host_data_transfer_blocking_factor = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->host_data_transfer_blocking_factor == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"host-data-transfer-blocking-factor");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	host-data-transfer-blocking-factor = %d\n",
				option_struct_p->host_data_transfer_blocking_factor);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->host_data_transfer_blocking_factor >= 1) && (option_struct_p->host_data_transfer_blocking_factor <= 16)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"host-data-transfer-blocking-factor");
		goto error;
	}

	break;

case 22 :	/* hsync-polarity */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_hsync_polarity_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "hsync-polarity");
		goto error;
	}
	option_struct_p->hsync_polarity = m64_options_hsync_polarity_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum hsync-polarity value '%s'\n",
			m64_options_hsync_polarity_keywords[option_enum_index]);
	}
#endif
	break;

case 23 :	/* linedraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			m64_options_lookup_name(option_value_p, &(m64_options_linedraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "linedraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->linedraw_options &= 
				(~m64_options_linedraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->linedraw_options |= 
				(m64_options_linedraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "(m64_options_parse) enum linedraw-options value %d.\n",
			option_struct_p->linedraw_options);
	}
#endif

	break;


case 24 :	/* max-number-of-glyphs-in-downloadable-font */
	option_struct_p->max_number_of_glyphs_in_downloadable_font = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->max_number_of_glyphs_in_downloadable_font == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"max-number-of-glyphs-in-downloadable-font");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	max-number-of-glyphs-in-downloadable-font = %d\n",
				option_struct_p->max_number_of_glyphs_in_downloadable_font);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->max_number_of_glyphs_in_downloadable_font >= 0) && (option_struct_p->max_number_of_glyphs_in_downloadable_font <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"max-number-of-glyphs-in-downloadable-font");
		goto error;
	}

	break;


case 25 :	/* maximum-offscreen-downloadable-bitmap-height */
	option_struct_p->maximum_offscreen_downloadable_bitmap_height = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->maximum_offscreen_downloadable_bitmap_height == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"maximum-offscreen-downloadable-bitmap-height");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	maximum-offscreen-downloadable-bitmap-height = %d\n",
				option_struct_p->maximum_offscreen_downloadable_bitmap_height);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->maximum_offscreen_downloadable_bitmap_height >= 1) && (option_struct_p->maximum_offscreen_downloadable_bitmap_height <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"maximum-offscreen-downloadable-bitmap-height");
		goto error;
	}

	break;


case 26 :	/* maximum-offscreen-downloadable-bitmap-width */
	option_struct_p->maximum_offscreen_downloadable_bitmap_width = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->maximum_offscreen_downloadable_bitmap_width == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"maximum-offscreen-downloadable-bitmap-width");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	maximum-offscreen-downloadable-bitmap-width = %d\n",
				option_struct_p->maximum_offscreen_downloadable_bitmap_width);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->maximum_offscreen_downloadable_bitmap_width >= 1) && (option_struct_p->maximum_offscreen_downloadable_bitmap_width <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"maximum-offscreen-downloadable-bitmap-width");
		goto error;
	}

	break;

case 27 :	/* memory-aperture-size */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_memory_aperture_size_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "memory-aperture-size");
		goto error;
	}
	option_struct_p->memory_aperture_size = m64_options_memory_aperture_size_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum memory-aperture-size value '%s'\n",
			m64_options_memory_aperture_size_keywords[option_enum_index]);
	}
#endif
	break;

case 28 :	/* memory-aperture-type */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_memory_aperture_type_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "memory-aperture-type");
		goto error;
	}
	option_struct_p->memory_aperture_type = m64_options_memory_aperture_type_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum memory-aperture-type value '%s'\n",
			m64_options_memory_aperture_type_keywords[option_enum_index]);
	}
#endif
	break;

case 29 :	/* monitor-sync-type */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_monitor_sync_type_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "monitor-sync-type");
		goto error;
	}
	option_struct_p->monitor_sync_type = m64_options_monitor_sync_type_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum monitor-sync-type value '%s'\n",
			m64_options_monitor_sync_type_keywords[option_enum_index]);
	}
#endif
	break;


case 30 :	/* number-of-downloadable-cursors */
	option_struct_p->number_of_downloadable_cursors = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->number_of_downloadable_cursors == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"number-of-downloadable-cursors");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	number-of-downloadable-cursors = %d\n",
				option_struct_p->number_of_downloadable_cursors);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->number_of_downloadable_cursors >= 0) && (option_struct_p->number_of_downloadable_cursors <= 1)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"number-of-downloadable-cursors");
		goto error;
	}

	break;


case 31 :	/* number-of-downloadable-fonts */
	option_struct_p->number_of_downloadable_fonts = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->number_of_downloadable_fonts == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"number-of-downloadable-fonts");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	number-of-downloadable-fonts = %d\n",
				option_struct_p->number_of_downloadable_fonts);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->number_of_downloadable_fonts >= 0) && (option_struct_p->number_of_downloadable_fonts <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"number-of-downloadable-fonts");
		goto error;
	}

	break;


case 32 :	/* number-of-graphics-states */
	option_struct_p->number_of_graphics_states = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->number_of_graphics_states == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"number-of-graphics-states");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	number-of-graphics-states = %d\n",
				option_struct_p->number_of_graphics_states);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->number_of_graphics_states >= 0) && (option_struct_p->number_of_graphics_states <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"number-of-graphics-states");
		goto error;
	}

	break;


case 33 :	/* offscreen-tile-padded-height */
	option_struct_p->offscreen_tile_padded_height = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->offscreen_tile_padded_height == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"offscreen-tile-padded-height");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	offscreen-tile-padded-height = %d\n",
				option_struct_p->offscreen_tile_padded_height);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->offscreen_tile_padded_height >= 1) && (option_struct_p->offscreen_tile_padded_height <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"offscreen-tile-padded-height");
		goto error;
	}

	break;


case 34 :	/* offscreen-tile-padded-width */
	option_struct_p->offscreen_tile_padded_width = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->offscreen_tile_padded_width == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"offscreen-tile-padded-width");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	offscreen-tile-padded-width = %d\n",
				option_struct_p->offscreen_tile_padded_width);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->offscreen_tile_padded_width >= 1) && (option_struct_p->offscreen_tile_padded_width <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"offscreen-tile-padded-width");
		goto error;
	}

	break;


case 35 :	/* omm-full-coalesce-watermark */
	option_struct_p->omm_full_coalesce_watermark = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_full_coalesce_watermark == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-full-coalesce-watermark");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-full-coalesce-watermark = %d\n",
				option_struct_p->omm_full_coalesce_watermark);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_full_coalesce_watermark >= 0) && (option_struct_p->omm_full_coalesce_watermark <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-full-coalesce-watermark");
		goto error;
	}

	break;


case 36 :	/* omm-hash-list-size */
	option_struct_p->omm_hash_list_size = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_hash_list_size == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-hash-list-size");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-hash-list-size = %d\n",
				option_struct_p->omm_hash_list_size);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_hash_list_size >= 0) && (option_struct_p->omm_hash_list_size <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-hash-list-size");
		goto error;
	}

	break;


case 37 :	/* omm-horizontal-constraint */
	option_struct_p->omm_horizontal_constraint = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_horizontal_constraint == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-horizontal-constraint");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-horizontal-constraint = %d\n",
				option_struct_p->omm_horizontal_constraint);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_horizontal_constraint >= 0) && (option_struct_p->omm_horizontal_constraint <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-horizontal-constraint");
		goto error;
	}

	break;

case 38 :	/* omm-named-allocation-list */
	option_struct_p->omm_named_allocation_list = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-named-allocation-list = \"%s\"\n",
			option_struct_p->omm_named_allocation_list);
	}
#endif

	break;


case 39 :	/* omm-neighbour-list-increment */
	option_struct_p->omm_neighbour_list_increment = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_neighbour_list_increment == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-neighbour-list-increment");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-neighbour-list-increment = %d\n",
				option_struct_p->omm_neighbour_list_increment);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_neighbour_list_increment >= 0) && (option_struct_p->omm_neighbour_list_increment <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-neighbour-list-increment");
		goto error;
	}

	break;


case 40 :	/* omm-vertical-constraint */
	option_struct_p->omm_vertical_constraint = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_vertical_constraint == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-vertical-constraint");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-vertical-constraint = %d\n",
				option_struct_p->omm_vertical_constraint);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_vertical_constraint >= 0) && (option_struct_p->omm_vertical_constraint <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-vertical-constraint");
		goto error;
	}

	break;

case 41 :	/* options-file */
	/*
	 * look up the file.
	 */
	if (stat(option_value_p, &stat_buf) != 0)
	{
		/*
		 * Warn the user of missing files, and continue.
		 */
		(void) fprintf(stderr, 
					DEFAULT_OPTION_CANNOT_STAT_FILE_ARGUMENT_MESSAGE,
					option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		break;
	}

	if (stat_buf.st_size == 0)
	{
		/*
		 * Warn the user of zero length files, and continue.
		 */
		(void) fprintf(stderr,
					DEFAULT_OPTION_ZERO_LENGTH_FILE_ARGUMENT_MESSAGE,
					option_value_p, "options-file");
		break;
	}

	/* read the option file into a buffer */
	if (!(tmp_p = allocate_and_clear_memory(stat_buf.st_size+1)))
	{
		perror(DEFAULT_OPTION_CANNOT_ALLOCATE_MEMORY_MESSAGE);
		goto error;
	}

	if( (option_file_p = fopen(option_value_p, "r")) == NULL)
	{

		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_OPEN_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		goto error;
	}
	if (fread(tmp_p, stat_buf.st_size, 1, option_file_p) != 1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_READ_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		goto error;
	}
	(void) fclose(option_file_p);
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "\t\"%s\"\n", tmp_p);
	}
#endif
	/*
	 * Recursively invoke the interpreter.
	 */
	if (!m64_options_parse(option_struct_p, tmp_p))
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_PROCESS_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		free_memory(tmp_p);
		goto error;
	}
	free_memory(tmp_p);
	break;

case 42 :	/* options-variable */

	tmp_p = getenv(option_value_p);
	if (tmp_p)
	{

#if (defined(__DEBUG__))
		if (m64_options_debug)
		{
			(void) fprintf(debug_stream_p, "\t\"%s\"\n", tmp_p);
		}
#endif
		if (!m64_options_parse(option_struct_p, tmp_p))
		{
			(void) fprintf(stderr, 
					DEFAULT_OPTION_CANNOT_PROCESS_ENVIRONMENT_ARGUMENT_MESSAGE,
				option_value_p, "options-variable");
			goto error;
		}

	}
	break;

case 43 :	/* pointdraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			m64_options_lookup_name(option_value_p, &(m64_options_pointdraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "pointdraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->pointdraw_options &= 
				(~m64_options_pointdraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->pointdraw_options |= 
				(m64_options_pointdraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "(m64_options_parse) enum pointdraw-options value %d.\n",
			option_struct_p->pointdraw_options);
	}
#endif

	break;

case 44 :	/* rectfill-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			m64_options_lookup_name(option_value_p, &(m64_options_rectfill_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "rectfill-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->rectfill_options &= 
				(~m64_options_rectfill_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->rectfill_options |= 
				(m64_options_rectfill_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "(m64_options_parse) enum rectfill-options value %d.\n",
			option_struct_p->rectfill_options);
	}
#endif

	break;

case 45 :	/* revision-number */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_revision_number_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "revision-number");
		goto error;
	}
	option_struct_p->revision_number = m64_options_revision_number_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum revision-number value '%s'\n",
			m64_options_revision_number_keywords[option_enum_index]);
	}
#endif
	break;

case 46 :	/* screen-visual-list */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			m64_options_lookup_name(option_value_p, &(m64_options_screen_visual_list_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "screen-visual-list");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->screen_visual_list &= 
				(~m64_options_screen_visual_list_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->screen_visual_list |= 
				(m64_options_screen_visual_list_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "(m64_options_parse) enum screen-visual-list value %d.\n",
			option_struct_p->screen_visual_list);
	}
#endif

	break;

case 47 :	/* si-interface-version */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_si_interface_version_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "si-interface-version");
		goto error;
	}
	option_struct_p->si_interface_version = m64_options_si_interface_version_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum si-interface-version value '%s'\n",
			m64_options_si_interface_version_keywords[option_enum_index]);
	}
#endif
	break;


case 48 :	/* small-stipple-conversion-threshold */
	option_struct_p->small_stipple_conversion_threshold = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->small_stipple_conversion_threshold == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"small-stipple-conversion-threshold");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	small-stipple-conversion-threshold = %d\n",
				option_struct_p->small_stipple_conversion_threshold);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->small_stipple_conversion_threshold >= 1) && (option_struct_p->small_stipple_conversion_threshold <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"small-stipple-conversion-threshold");
		goto error;
	}

	break;

case 49 :	/* spansfill-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			m64_options_lookup_name(option_value_p, &(m64_options_spansfill_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "spansfill-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->spansfill_options &= 
				(~m64_options_spansfill_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->spansfill_options |= 
				(m64_options_spansfill_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "(m64_options_parse) enum spansfill-options value %d.\n",
			option_struct_p->spansfill_options);
	}
#endif

	break;

case 50 :	/* static-colormap-description-file */
	option_struct_p->static_colormap_description_file = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	static-colormap-description-file = \"%s\"\n",
			option_struct_p->static_colormap_description_file);
	}
#endif

	break;

case 51 :	/* stipple-best-size */
	option_struct_p->stipple_best_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	stipple-best-size = \"%s\"\n",
			option_struct_p->stipple_best_size);
	}
#endif

	break;

case 52 :	/* tile-best-size */
	option_struct_p->tile_best_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	tile-best-size = \"%s\"\n",
			option_struct_p->tile_best_size);
	}
#endif

	break;


case 53 :	/* verbose-startup */
	option_struct_p->verbose_startup = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->verbose_startup == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"verbose-startup");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	verbose-startup = %d\n",
				option_struct_p->verbose_startup);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->verbose_startup >= 0) && (option_struct_p->verbose_startup <= 1)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"verbose-startup");
		goto error;
	}

	break;

case 54 :	/* vsync-polarity */
	if ((option_enum_index = 
		m64_options_lookup_name(option_value_p, &(m64_options_vsync_polarity_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "vsync-polarity");
		goto error;
	}
	option_struct_p->vsync_polarity = m64_options_vsync_polarity_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(m64_options_parse) enum vsync-polarity value '%s'\n",
			m64_options_vsync_polarity_keywords[option_enum_index]);
	}
#endif
	break;


case 55 :	/* vt-switch-save-lines */
	option_struct_p->vt_switch_save_lines = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->vt_switch_save_lines == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"vt-switch-save-lines");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (m64_options_debug)
	{
		(void) fprintf(debug_stream_p, "	vt-switch-save-lines = %d\n",
				option_struct_p->vt_switch_save_lines);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->vt_switch_save_lines >= 0) && (option_struct_p->vt_switch_save_lines <= 4096)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"vt-switch-save-lines");
		goto error;
	}

	break;


			default :
				(void) fprintf(stderr,
						DEFAULT_OPTION_INTERNAL_ERROR_MESSAGE);
				free_memory(option_list_p);
				return (struct m64_options_structure *) 0;
			
		}
		
		/*
		 * while ...
		 */
		character_p = 
			m64_options_parse_get_next_token(character_p);
		
	}
	/*
	 * Free the space we allocated.
	 */
	free_memory(option_list_p);
	
	return option_struct_p;

  error:
	if (option_list_p)
	{
		free_memory(option_list_p);
	}
	
	return (struct m64_options_structure *) 0;
	
}

#if (defined(__TEST__))
int
main(int parameter_count, char ** parameter_pp)
{
	int i;
	int string_length = 0;
	char * options_p;

#if (defined(__DEBUG__))
	m64_options_debug = 
		getenv("m64_options_debug") ? TRUE :	FALSE;
	if (debug_stream_p == NULL && (debug_stream_p =
		    fopen(getenv("debug_stream"), "w")) == NULL)
	{
		debug_stream_p = stdout;
	}
#endif

	for(i = 1; i < parameter_count; i++)
	{
		string_length += strlen(*(parameter_pp + i));
	}
	options_p = allocate_memory(string_length + 1);
	*options_p = EOS;
	
	for(i = 1; i < parameter_count; i++)
	{
		strcat(options_p, *(parameter_pp +i));
	}

	m64_options_parse(0, options_p);

}

#endif
