/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)p9k:p9k/p9k_opt.h	1.4"
#if (! defined(__P9K_OPT_INCLUDED__))

#define __P9K_OPT_INCLUDED__



#include "stdenv.h"


enum p9000_options_si_interface_version
{
	P9000_OPTIONS_SI_INTERFACE_VERSION_1_0,
	P9000_OPTIONS_SI_INTERFACE_VERSION_1_1,
	P9000_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE,
	p9000_options_si_interface_version_end_enumeration
};

enum p9000_options_verbose_startup
{
	P9000_OPTIONS_VERBOSE_STARTUP_YES,
	P9000_OPTIONS_VERBOSE_STARTUP_NO,
	p9000_options_verbose_startup_end_enumeration
};

enum p9000_options_clock_name
{
	P9000_OPTIONS_CLOCK_NAME_ICD2061A,
	p9000_options_clock_name_end_enumeration
};

enum p9000_options_dac_name
{
	P9000_OPTIONS_DAC_NAME_BT485KPJ135,
	P9000_OPTIONS_DAC_NAME_BT485KPJ110,
	p9000_options_dac_name_end_enumeration
};

enum p9000_options_memory_configuration
{
	P9000_OPTIONS_MEMORY_CONFIGURATION_1,
	P9000_OPTIONS_MEMORY_CONFIGURATION_2,
	P9000_OPTIONS_MEMORY_CONFIGURATION_3,
	P9000_OPTIONS_MEMORY_CONFIGURATION_4,
	P9000_OPTIONS_MEMORY_CONFIGURATION_5,
	p9000_options_memory_configuration_end_enumeration
};

enum p9000_options_cursor_type
{
	P9000_OPTIONS_CURSOR_TYPE_AUTO_CONFIGURE,
	P9000_OPTIONS_CURSOR_TYPE_DAC_CURSOR,
	P9000_OPTIONS_CURSOR_TYPE_SOFTWARE_CURSOR,
	p9000_options_cursor_type_end_enumeration
};

enum p9000_options_dac_rgb_width
{
	P9000_OPTIONS_DAC_RGB_WIDTH_6,
	P9000_OPTIONS_DAC_RGB_WIDTH_8,
	P9000_OPTIONS_DAC_RGB_WIDTH_DEFAULT,
	p9000_options_dac_rgb_width_end_enumeration
};

enum p9000_options_dac_24_bit_color_mode
{
	P9000_OPTIONS_DAC_24_BIT_COLOR_MODE_RGBA,
	P9000_OPTIONS_DAC_24_BIT_COLOR_MODE_ABGR,
	p9000_options_dac_24_bit_color_mode_end_enumeration
};

enum p9000_options_dac_16_bit_color_mode
{
	P9000_OPTIONS_DAC_16_BIT_COLOR_MODE_555,
	P9000_OPTIONS_DAC_16_BIT_COLOR_MODE_565,
	P9000_OPTIONS_DAC_16_BIT_COLOR_MODE_655,
	P9000_OPTIONS_DAC_16_BIT_COLOR_MODE_664,
	p9000_options_dac_16_bit_color_mode_end_enumeration
};

enum p9000_options_allow_core_server_to_use_linear_frame_buffer
{
	P9000_OPTIONS_ALLOW_CORE_SERVER_TO_USE_LINEAR_FRAME_BUFFER_YES,
	P9000_OPTIONS_ALLOW_CORE_SERVER_TO_USE_LINEAR_FRAME_BUFFER_NO,
	p9000_options_allow_core_server_to_use_linear_frame_buffer_end_enumeration
};


#define	P9000_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT	1
#define	P9000_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT	2
#define	P9000_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT	4
#define	P9000_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT	8


#define	P9000_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT	1
#define	P9000_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT	2
#define	P9000_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT	4
#define	P9000_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY	8
#define	P9000_OPTIONS_RECTFILL_OPTIONS_USE_PATTERN_REGISTERS	16
#define	P9000_OPTIONS_RECTFILL_OPTIONS_USE_TWO_COLOR_TILE_SPEEDUP	32
#define	P9000_OPTIONS_RECTFILL_OPTIONS_USE_REDUCED_STIPPLE_SPEEDUP	64


#define	P9000_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES	1
#define	P9000_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW	2
#define	P9000_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW	4
#define	P9000_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_LINES	8
#define	P9000_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_SEGMENTS	16
#define	P9000_OPTIONS_LINEDRAW_OPTIONS_USE_PATTERN_REGISTERS	32


#define	P9000_OPTIONS_FONTDRAW_OPTIONS_USE_TERMINAL_FONTS	1
#define	P9000_OPTIONS_FONTDRAW_OPTIONS_USE_NON_TERMINAL_FONTS	2


#define	P9000_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS	1


#define	P9000_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT	1


#define	P9000_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL_SPANS	1




struct p9000_options_structure
{
	enum p9000_options_allow_core_server_to_use_linear_frame_buffer allow_core_server_to_use_linear_frame_buffer;
	unsigned int arcdraw_options;
	unsigned int bitblt_options;
	int bt485_clock_doubler_threshold;
	enum p9000_options_clock_name clock_name;
	char *cursor_max_size;
	enum p9000_options_cursor_type cursor_type;
	enum p9000_options_dac_16_bit_color_mode dac_16_bit_color_mode;
	enum p9000_options_dac_24_bit_color_mode dac_24_bit_color_mode;
	int dac_access_delay_count;
	char *dac_base_address;
	int dac_max_frequency;
	enum p9000_options_dac_name dac_name;
	enum p9000_options_dac_rgb_width dac_rgb_width;
	int dot_clock_divide;
	unsigned int fontdraw_options;
	int graphics_engine_loop_timeout_count;
	int linear_frame_buffer_size;
	unsigned int linedraw_options;
	char *max_font_glyph_size;
	int max_number_of_glyphs_in_downloadable_font;
	int maximum_offscreen_downloadable_tile_height;
	int maximum_offscreen_downloadable_tile_width;
	enum p9000_options_memory_configuration memory_configuration;
	char *modedb_string;
	int number_of_downloadable_cursors;
	int number_of_downloadable_fonts;
	int number_of_graphics_states;
	int offscreen_tile_padded_height;
	int offscreen_tile_padded_width;
	int omm_full_coalesce_watermark;
	int omm_hash_list_size;
	int omm_horizontal_constraint;
	char *omm_named_allocation_list;
	int omm_neighbour_list_increment;
	int omm_vertical_constraint;
	char *p9000_base_address;
	unsigned int pointdraw_options;
	unsigned int rectfill_options;
	enum p9000_options_si_interface_version si_interface_version;
	unsigned int spansfill_options;
	char *stipple_best_size;
	char *tile_best_size;
	int two_color_tile_maximum_height;
	int two_color_tile_maximum_width;
	enum p9000_options_verbose_startup verbose_startup;
	char *video_memory_dimensions;
	int vram_ras_low_maximum;
	int vram_refresh_period;
	int vt_switch_save_lines;

};

/*
 * Names of the option defaults
 */

#define P9000_OPTIONS_ALLOW_CORE_SERVER_TO_USE_LINEAR_FRAME_BUFFER_DEFAULT\
	P9000_OPTIONS_ALLOW_CORE_SERVER_TO_USE_LINEAR_FRAME_BUFFER_NO
#define P9000_OPTIONS_ARCDRAW_OPTIONS_DEFAULT\
	( P9000_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS )
#define P9000_OPTIONS_BITBLT_OPTIONS_DEFAULT\
	( P9000_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT |P9000_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT |P9000_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT |P9000_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT )
#define P9000_OPTIONS_BT485_CLOCK_DOUBLER_THRESHOLD_DEFAULT\
	80
#define P9000_OPTIONS_CLOCK_NAME_DEFAULT\
	P9000_OPTIONS_CLOCK_NAME_ICD2061A
#define P9000_OPTIONS_CURSOR_MAX_SIZE_DEFAULT 0
#define P9000_OPTIONS_CURSOR_TYPE_DEFAULT\
	P9000_OPTIONS_CURSOR_TYPE_AUTO_CONFIGURE
#define P9000_OPTIONS_DAC_16_BIT_COLOR_MODE_DEFAULT\
	P9000_OPTIONS_DAC_16_BIT_COLOR_MODE_555
#define P9000_OPTIONS_DAC_24_BIT_COLOR_MODE_DEFAULT\
	P9000_OPTIONS_DAC_24_BIT_COLOR_MODE_RGBA
#define P9000_OPTIONS_DAC_ACCESS_DELAY_COUNT_DEFAULT\
	1000
#define P9000_OPTIONS_DAC_BASE_ADDRESS_DEFAULT 0
#define P9000_OPTIONS_DAC_MAX_FREQUENCY_DEFAULT\
	0
#define P9000_OPTIONS_DAC_NAME_DEFAULT\
	P9000_OPTIONS_DAC_NAME_BT485KPJ110
#define P9000_OPTIONS_DAC_RGB_WIDTH_DEFAULT\
	P9000_OPTIONS_DAC_RGB_WIDTH_8
#define P9000_OPTIONS_DOT_CLOCK_DIVIDE_DEFAULT\
	4
#define P9000_OPTIONS_FONTDRAW_OPTIONS_DEFAULT\
	( P9000_OPTIONS_FONTDRAW_OPTIONS_USE_NON_TERMINAL_FONTS |P9000_OPTIONS_FONTDRAW_OPTIONS_USE_TERMINAL_FONTS )
#define P9000_OPTIONS_GRAPHICS_ENGINE_LOOP_TIMEOUT_COUNT_DEFAULT\
	200000
#define P9000_OPTIONS_LINEAR_FRAME_BUFFER_SIZE_DEFAULT\
	0
#define P9000_OPTIONS_LINEDRAW_OPTIONS_DEFAULT\
	( P9000_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW |P9000_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW |P9000_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES |P9000_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_LINES |P9000_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_SEGMENTS |P9000_OPTIONS_LINEDRAW_OPTIONS_USE_PATTERN_REGISTERS )
#define P9000_OPTIONS_MAX_FONT_GLYPH_SIZE_DEFAULT 0
#define P9000_OPTIONS_MAX_NUMBER_OF_GLYPHS_IN_DOWNLOADABLE_FONT_DEFAULT\
	256
#define P9000_OPTIONS_MAXIMUM_OFFSCREEN_DOWNLOADABLE_TILE_HEIGHT_DEFAULT\
	256
#define P9000_OPTIONS_MAXIMUM_OFFSCREEN_DOWNLOADABLE_TILE_WIDTH_DEFAULT\
	256
#define P9000_OPTIONS_MEMORY_CONFIGURATION_DEFAULT\
	P9000_OPTIONS_MEMORY_CONFIGURATION_3
#define P9000_OPTIONS_MODEDB_STRING_DEFAULT 0
#define P9000_OPTIONS_NUMBER_OF_DOWNLOADABLE_CURSORS_DEFAULT\
	1
#define P9000_OPTIONS_NUMBER_OF_DOWNLOADABLE_FONTS_DEFAULT\
	32
#define P9000_OPTIONS_NUMBER_OF_GRAPHICS_STATES_DEFAULT\
	8
#define P9000_OPTIONS_OFFSCREEN_TILE_PADDED_HEIGHT_DEFAULT\
	32
#define P9000_OPTIONS_OFFSCREEN_TILE_PADDED_WIDTH_DEFAULT\
	128
#define P9000_OPTIONS_OMM_FULL_COALESCE_WATERMARK_DEFAULT\
	2
#define P9000_OPTIONS_OMM_HASH_LIST_SIZE_DEFAULT\
	512
#define P9000_OPTIONS_OMM_HORIZONTAL_CONSTRAINT_DEFAULT\
	0
#define P9000_OPTIONS_OMM_NAMED_ALLOCATION_LIST_DEFAULT\
	""
#define P9000_OPTIONS_OMM_NEIGHBOUR_LIST_INCREMENT_DEFAULT\
	20
#define P9000_OPTIONS_OMM_VERTICAL_CONSTRAINT_DEFAULT\
	0
#define P9000_OPTIONS_P9000_BASE_ADDRESS_DEFAULT 0
#define P9000_OPTIONS_POINTDRAW_OPTIONS_DEFAULT\
	( P9000_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT )
#define P9000_OPTIONS_RECTFILL_OPTIONS_DEFAULT\
	( P9000_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT |P9000_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT |P9000_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY |P9000_OPTIONS_RECTFILL_OPTIONS_USE_PATTERN_REGISTERS |P9000_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT |P9000_OPTIONS_RECTFILL_OPTIONS_USE_TWO_COLOR_TILE_SPEEDUP |P9000_OPTIONS_RECTFILL_OPTIONS_USE_REDUCED_STIPPLE_SPEEDUP )
#define P9000_OPTIONS_SI_INTERFACE_VERSION_DEFAULT\
	P9000_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE
#define P9000_OPTIONS_SPANSFILL_OPTIONS_DEFAULT\
	( P9000_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL_SPANS )
#define P9000_OPTIONS_STIPPLE_BEST_SIZE_DEFAULT 0
#define P9000_OPTIONS_TILE_BEST_SIZE_DEFAULT\
	"64X64"
#define P9000_OPTIONS_TWO_COLOR_TILE_MAXIMUM_HEIGHT_DEFAULT\
	128
#define P9000_OPTIONS_TWO_COLOR_TILE_MAXIMUM_WIDTH_DEFAULT\
	128
#define P9000_OPTIONS_VERBOSE_STARTUP_DEFAULT\
	P9000_OPTIONS_VERBOSE_STARTUP_NO
#define P9000_OPTIONS_VIDEO_MEMORY_DIMENSIONS_DEFAULT 0
#define P9000_OPTIONS_VRAM_RAS_LOW_MAXIMUM_DEFAULT\
	0
#define P9000_OPTIONS_VRAM_REFRESH_PERIOD_DEFAULT\
	0
#define P9000_OPTIONS_VT_SWITCH_SAVE_LINES_DEFAULT\
	2048


#if (defined(__DEBUG__))
extern boolean	p9000_options_debug ;
#endif


extern struct p9000_options_structure *
p9000_options_parse (struct p9000_options_structure *option_struct_p,
			   const char *option_string_p)
;


#endif
