#pragma ident	"%W%"
/***								-*- C -*-
 ***
 ***	Warning!  Target file, do not modify.
 ***	
 ***	Generated from: s364_opt.gen
 ***
 ***	Generated by: (genoptions 1.0.0).
 ***
 ***/

PUBLIC

#include "stdenv.h"
#include "global.h"


enum s364_options_si_interface_version
{
	S364_OPTIONS_SI_INTERFACE_VERSION_1_0,
	S364_OPTIONS_SI_INTERFACE_VERSION_1_1,
	S364_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE,
	s364_options_si_interface_version_end_enumeration
};

enum s364_options_monitor_sync_type
{
	S364_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC,
	S364_OPTIONS_MONITOR_SYNC_TYPE_SYNC_ON_GREEN,
	S364_OPTIONS_MONITOR_SYNC_TYPE_SEPARATE_SYNC,
	s364_options_monitor_sync_type_end_enumeration
};

enum s364_options_vsync_polarity
{
	S364_OPTIONS_VSYNC_POLARITY_POSITIVE,
	S364_OPTIONS_VSYNC_POLARITY_NEGATIVE,
	S364_OPTIONS_VSYNC_POLARITY_DEFAULT,
	s364_options_vsync_polarity_end_enumeration
};

enum s364_options_hsync_polarity
{
	S364_OPTIONS_HSYNC_POLARITY_POSITIVE,
	S364_OPTIONS_HSYNC_POLARITY_NEGATIVE,
	S364_OPTIONS_HSYNC_POLARITY_DEFAULT,
	s364_options_hsync_polarity_end_enumeration
};

enum s364_options_framebuffer_access_for_core_server
{
	S364_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_YES,
	S364_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_NO,
	s364_options_framebuffer_access_for_core_server_end_enumeration
};

enum s364_options_chipset_name
{
	S364_OPTIONS_CHIPSET_NAME_VISION864,
	S364_OPTIONS_CHIPSET_NAME_VISION964,
	S364_OPTIONS_CHIPSET_NAME_AUTO_DETECT,
	s364_options_chipset_name_end_enumeration
};

enum s364_options_clock_chip_name
{
	S364_OPTIONS_CLOCK_CHIP_NAME_CHRONTEL_CH9204C,
	S364_OPTIONS_CLOCK_CHIP_NAME_CHRONTEL_CH9204G,
	S364_OPTIONS_CLOCK_CHIP_NAME_ICD_2061A,
	S364_OPTIONS_CLOCK_CHIP_NAME_TVP3025,
	S364_OPTIONS_CLOCK_CHIP_NAME_USE_BUILTIN,
	s364_options_clock_chip_name_end_enumeration
};

enum s364_options_bus_kind
{
	S364_OPTIONS_BUS_KIND_VLB,
	S364_OPTIONS_BUS_KIND_PCI,
	S364_OPTIONS_BUS_KIND_AUTO_DETECT,
	s364_options_bus_kind_end_enumeration
};

enum s364_options_video_clock_delay
{
	S364_OPTIONS_VIDEO_CLOCK_DELAY_YES,
	S364_OPTIONS_VIDEO_CLOCK_DELAY_NO,
	s364_options_video_clock_delay_end_enumeration
};

enum s364_options_video_clock_invert
{
	S364_OPTIONS_VIDEO_CLOCK_INVERT_YES,
	S364_OPTIONS_VIDEO_CLOCK_INVERT_NO,
	s364_options_video_clock_invert_end_enumeration
};

enum s364_options_dac_name
{
	S364_OPTIONS_DAC_NAME_ATT21C498,
	S364_OPTIONS_DAC_NAME_BT485KPJ110,
	S364_OPTIONS_DAC_NAME_BT485KPJ135,
	S364_OPTIONS_DAC_NAME_TVP3020_135MDN,
	S364_OPTIONS_DAC_NAME_TVP3020_175MDN,
	S364_OPTIONS_DAC_NAME_TVP3020_200MDN,
	S364_OPTIONS_DAC_NAME_PTVP3025_135MDN,
	S364_OPTIONS_DAC_NAME_PTVP3025_175MDN,
	S364_OPTIONS_DAC_NAME_PTVP3025_200MDN,
	S364_OPTIONS_DAC_NAME_USE_BUILTIN,
	s364_options_dac_name_end_enumeration
};

enum s364_options_dac_rgb_width
{
	S364_OPTIONS_DAC_RGB_WIDTH_6,
	S364_OPTIONS_DAC_RGB_WIDTH_8,
	s364_options_dac_rgb_width_end_enumeration
};

enum s364_options_dac_32_bit_color_mode
{
	S364_OPTIONS_DAC_32_BIT_COLOR_MODE_RGBA,
	S364_OPTIONS_DAC_32_BIT_COLOR_MODE_ABGR,
	S364_OPTIONS_DAC_32_BIT_COLOR_MODE_ARGB,
	S364_OPTIONS_DAC_32_BIT_COLOR_MODE_BGRA,
	s364_options_dac_32_bit_color_mode_end_enumeration
};

enum s364_options_dac_16_bit_color_mode
{
	S364_OPTIONS_DAC_16_BIT_COLOR_MODE_555,
	S364_OPTIONS_DAC_16_BIT_COLOR_MODE_565,
	S364_OPTIONS_DAC_16_BIT_COLOR_MODE_664,
	s364_options_dac_16_bit_color_mode_end_enumeration
};

enum s364_options_cursor_type
{
	S364_OPTIONS_CURSOR_TYPE_SOFTWARE_CURSOR,
	S364_OPTIONS_CURSOR_TYPE_CHIPSET_CURSOR,
	S364_OPTIONS_CURSOR_TYPE_DAC_CURSOR,
	S364_OPTIONS_CURSOR_TYPE_AUTO_CONFIGURE,
	s364_options_cursor_type_end_enumeration
};

enum s364_options_pci_9gxe64_1280_modes
{
	S364_OPTIONS_PCI_9GXE64_1280_MODES_YES,
	S364_OPTIONS_PCI_9GXE64_1280_MODES_NO,
	s364_options_pci_9gxe64_1280_modes_end_enumeration
};

enum s364_options_vlb_964_line_workaround
{
	S364_OPTIONS_VLB_964_LINE_WORKAROUND_YES,
	S364_OPTIONS_VLB_964_LINE_WORKAROUND_NO,
	s364_options_vlb_964_line_workaround_end_enumeration
};


#define	S364_OPTIONS_SCREEN_VISUAL_LIST_STATIC_GRAY	1
#define	S364_OPTIONS_SCREEN_VISUAL_LIST_GRAY_SCALE	2
#define	S364_OPTIONS_SCREEN_VISUAL_LIST_STATIC_COLOR	4
#define	S364_OPTIONS_SCREEN_VISUAL_LIST_PSEUDO_COLOR	8
#define	S364_OPTIONS_SCREEN_VISUAL_LIST_TRUE_COLOR	16
#define	S364_OPTIONS_SCREEN_VISUAL_LIST_DIRECT_COLOR	32


#define	S364_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT	1
#define	S364_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT	2
#define	S364_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT	4
#define	S364_OPTIONS_RECTFILL_OPTIONS_USE_GE_MONO_PATFILL	8
#define	S364_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY	16
#define	S364_OPTIONS_RECTFILL_OPTIONS_USE_TILE_SHRINK	32
#define	S364_OPTIONS_RECTFILL_OPTIONS_NONE	64


#define	S364_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT	1
#define	S364_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT	2
#define	S364_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT	4
#define	S364_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT	8
#define	S364_OPTIONS_BITBLT_OPTIONS_NONE	16


#define	S364_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW	1
#define	S364_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES	2
#define	S364_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW	4
#define	S364_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_LINE	8
#define	S364_OPTIONS_LINEDRAW_OPTIONS_NONE	16


#define	S364_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL	1


#define	S364_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT	1
#define	S364_OPTIONS_POINTDRAW_OPTIONS_NONE	2


#define	S364_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS	1
#define	S364_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS	2
#define	S364_OPTIONS_FONTDRAW_OPTIONS_ASSEMBLE_GLYPHS	4


#define	S364_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS	1




struct s364_options_structure
{
	int arc_cache_size;
	unsigned int arcdraw_options;
	unsigned int bitblt_options;
	enum s364_options_bus_kind bus_kind;
	enum s364_options_chipset_name chipset_name;
	int chipset_revision_number;
	enum s364_options_clock_chip_name clock_chip_name;
	int clock_doubler_threshold;
	int crtc_sync_timeout_count;
	char *cursor_max_size;
	enum s364_options_cursor_type cursor_type;
	enum s364_options_dac_16_bit_color_mode dac_16_bit_color_mode;
	enum s364_options_dac_32_bit_color_mode dac_32_bit_color_mode;
	int dac_max_frequency;
	enum s364_options_dac_name dac_name;
	enum s364_options_dac_rgb_width dac_rgb_width;
	unsigned int fontdraw_options;
	enum s364_options_framebuffer_access_for_core_server framebuffer_access_for_core_server;
	int framebuffer_physical_address;
	char *glyph_cache_size;
	int graphics_engine_loop_timeout_count;
	int graphics_engine_micro_delay_count;
	enum s364_options_hsync_polarity hsync_polarity;
	unsigned int linedraw_options;
	int max_number_of_glyphs_in_downloadable_font;
	int maximum_offscreen_downloadable_bitmap_height;
	int maximum_offscreen_downloadable_bitmap_width;
	int memory_clock_frequency;
	char *modedb_string;
	enum s364_options_monitor_sync_type monitor_sync_type;
	int number_of_downloadable_cursors;
	int number_of_downloadable_fonts;
	int number_of_graphics_states;
	int omm_full_coalesce_watermark;
	int omm_hash_list_size;
	int omm_horizontal_constraint;
	char *omm_named_allocation_list;
	int omm_neighbour_list_increment;
	int omm_vertical_constraint;
	enum s364_options_pci_9gxe64_1280_modes pci_9gxe64_1280_modes;
	unsigned int pointdraw_options;
	unsigned int rectfill_options;
	char *register_values_string;
	unsigned int screen_visual_list;
	enum s364_options_si_interface_version si_interface_version;
	int small_stipple_conversion_threshold;
	unsigned int spansfill_options;
	char *static_colormap_description_file;
	char *stipple_best_size;
	char *tile_best_size;
	int verbose_startup;
	enum s364_options_video_clock_delay video_clock_delay;
	enum s364_options_video_clock_invert video_clock_invert;
	enum s364_options_vlb_964_line_workaround vlb_964_line_workaround;
	enum s364_options_vsync_polarity vsync_polarity;
	int vt_switch_save_lines;

};

/*
 * Names of the option defaults
 */

#define S364_OPTIONS_ARC_CACHE_SIZE_DEFAULT\
	16
#define S364_OPTIONS_ARCDRAW_OPTIONS_DEFAULT\
	( S364_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS )
#define S364_OPTIONS_BITBLT_OPTIONS_DEFAULT\
	( S364_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT |S364_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT |S364_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT |S364_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT )
#define S364_OPTIONS_BUS_KIND_DEFAULT\
	S364_OPTIONS_BUS_KIND_AUTO_DETECT
#define S364_OPTIONS_CHIPSET_NAME_DEFAULT\
	S364_OPTIONS_CHIPSET_NAME_AUTO_DETECT
#define S364_OPTIONS_CHIPSET_REVISION_NUMBER_DEFAULT\
	-1
#define S364_OPTIONS_CLOCK_CHIP_NAME_DEFAULT\
	S364_OPTIONS_CLOCK_CHIP_NAME_USE_BUILTIN
#define S364_OPTIONS_CLOCK_DOUBLER_THRESHOLD_DEFAULT\
	-1
#define S364_OPTIONS_CRTC_SYNC_TIMEOUT_COUNT_DEFAULT\
	100000
#define S364_OPTIONS_CURSOR_MAX_SIZE_DEFAULT 0
#define S364_OPTIONS_CURSOR_TYPE_DEFAULT\
	S364_OPTIONS_CURSOR_TYPE_AUTO_CONFIGURE
#define S364_OPTIONS_DAC_16_BIT_COLOR_MODE_DEFAULT\
	S364_OPTIONS_DAC_16_BIT_COLOR_MODE_555
#define S364_OPTIONS_DAC_32_BIT_COLOR_MODE_DEFAULT\
	S364_OPTIONS_DAC_32_BIT_COLOR_MODE_ARGB
#define S364_OPTIONS_DAC_MAX_FREQUENCY_DEFAULT\
	0
#define S364_OPTIONS_DAC_NAME_DEFAULT\
	S364_OPTIONS_DAC_NAME_USE_BUILTIN
#define S364_OPTIONS_DAC_RGB_WIDTH_DEFAULT\
	S364_OPTIONS_DAC_RGB_WIDTH_8
#define S364_OPTIONS_FONTDRAW_OPTIONS_DEFAULT\
	( S364_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS |S364_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS |S364_OPTIONS_FONTDRAW_OPTIONS_ASSEMBLE_GLYPHS )
#define S364_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_DEFAULT\
	S364_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_NO
#define S364_OPTIONS_FRAMEBUFFER_PHYSICAL_ADDRESS_DEFAULT\
	120
#define S364_OPTIONS_GLYPH_CACHE_SIZE_DEFAULT\
	"64X64"
#define S364_OPTIONS_GRAPHICS_ENGINE_LOOP_TIMEOUT_COUNT_DEFAULT\
	200000
#define S364_OPTIONS_GRAPHICS_ENGINE_MICRO_DELAY_COUNT_DEFAULT\
	40
#define S364_OPTIONS_HSYNC_POLARITY_DEFAULT\
	S364_OPTIONS_HSYNC_POLARITY_DEFAULT
#define S364_OPTIONS_LINEDRAW_OPTIONS_DEFAULT\
	( S364_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW |S364_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES |S364_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW |S364_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_LINE )
#define S364_OPTIONS_MAX_NUMBER_OF_GLYPHS_IN_DOWNLOADABLE_FONT_DEFAULT\
	256
#define S364_OPTIONS_MAXIMUM_OFFSCREEN_DOWNLOADABLE_BITMAP_HEIGHT_DEFAULT\
	256
#define S364_OPTIONS_MAXIMUM_OFFSCREEN_DOWNLOADABLE_BITMAP_WIDTH_DEFAULT\
	256
#define S364_OPTIONS_MEMORY_CLOCK_FREQUENCY_DEFAULT\
	57
#define S364_OPTIONS_MODEDB_STRING_DEFAULT 0
#define S364_OPTIONS_MONITOR_SYNC_TYPE_DEFAULT\
	S364_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC
#define S364_OPTIONS_NUMBER_OF_DOWNLOADABLE_CURSORS_DEFAULT\
	1
#define S364_OPTIONS_NUMBER_OF_DOWNLOADABLE_FONTS_DEFAULT\
	17
#define S364_OPTIONS_NUMBER_OF_GRAPHICS_STATES_DEFAULT\
	4
#define S364_OPTIONS_OMM_FULL_COALESCE_WATERMARK_DEFAULT\
	2
#define S364_OPTIONS_OMM_HASH_LIST_SIZE_DEFAULT\
	0
#define S364_OPTIONS_OMM_HORIZONTAL_CONSTRAINT_DEFAULT\
	0
#define S364_OPTIONS_OMM_NAMED_ALLOCATION_LIST_DEFAULT\
	""
#define S364_OPTIONS_OMM_NEIGHBOUR_LIST_INCREMENT_DEFAULT\
	0
#define S364_OPTIONS_OMM_VERTICAL_CONSTRAINT_DEFAULT\
	0
#define S364_OPTIONS_PCI_9GXE64_1280_MODES_DEFAULT\
	S364_OPTIONS_PCI_9GXE64_1280_MODES_NO
#define S364_OPTIONS_POINTDRAW_OPTIONS_DEFAULT\
	( S364_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT )
#define S364_OPTIONS_RECTFILL_OPTIONS_DEFAULT\
	( S364_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT |S364_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT |S364_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY |S364_OPTIONS_RECTFILL_OPTIONS_USE_GE_MONO_PATFILL |S364_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT |S364_OPTIONS_RECTFILL_OPTIONS_USE_TILE_SHRINK )
#define S364_OPTIONS_REGISTER_VALUES_STRING_DEFAULT\
	""
#define S364_OPTIONS_SCREEN_VISUAL_LIST_DEFAULT 0
#define S364_OPTIONS_SI_INTERFACE_VERSION_DEFAULT\
	S364_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE
#define S364_OPTIONS_SMALL_STIPPLE_CONVERSION_THRESHOLD_DEFAULT\
	32
#define S364_OPTIONS_SPANSFILL_OPTIONS_DEFAULT\
	( S364_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL )
#define S364_OPTIONS_STATIC_COLORMAP_DESCRIPTION_FILE_DEFAULT 0
#define S364_OPTIONS_STIPPLE_BEST_SIZE_DEFAULT\
	"64X64"
#define S364_OPTIONS_TILE_BEST_SIZE_DEFAULT\
	"64X64"
#define S364_OPTIONS_VERBOSE_STARTUP_DEFAULT\
	0
#define S364_OPTIONS_VIDEO_CLOCK_DELAY_DEFAULT\
	S364_OPTIONS_VIDEO_CLOCK_DELAY_NO
#define S364_OPTIONS_VIDEO_CLOCK_INVERT_DEFAULT\
	S364_OPTIONS_VIDEO_CLOCK_INVERT_NO
#define S364_OPTIONS_VLB_964_LINE_WORKAROUND_DEFAULT\
	S364_OPTIONS_VLB_964_LINE_WORKAROUND_NO
#define S364_OPTIONS_VSYNC_POLARITY_DEFAULT\
	S364_OPTIONS_VSYNC_POLARITY_DEFAULT
#define S364_OPTIONS_VT_SWITCH_SAVE_LINES_DEFAULT\
	8072


#if (defined(__DEBUG__))
export boolean	s364_options_debug = FALSE;
#endif


PRIVATE
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <limits.h>

/*
 * The types of options.
 */

enum s364_options_kind
{
	S364_OPTIONS_MULTIPLE_ENUMERATION,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_OPTION_ENVIRONMENT,
	S364_OPTIONS_OPTION_FILE,
	S364_OPTIONS_STRING,
	S364_OPTIONS_UNIQUE_ENUMERATION,

	s364_options_end_option_types
};

#if (defined(__DEBUG__))

static const char *const option_type_dump[] = 
{
	"multiple-enumeration",
	"numeric",
	"option-environment",
	"option-file",
	"string",
	"unique-enumeration",

	0
};

#endif

/*
 * The default options.
 */
static struct s364_options_structure s364_options_default =
{
	16,
	( S364_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS ),
	( S364_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT |S364_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT |S364_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT |S364_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT ),
	S364_OPTIONS_BUS_KIND_AUTO_DETECT,
	S364_OPTIONS_CHIPSET_NAME_AUTO_DETECT,
	-1,
	S364_OPTIONS_CLOCK_CHIP_NAME_USE_BUILTIN,
	-1,
	100000,
	0,
	S364_OPTIONS_CURSOR_TYPE_AUTO_CONFIGURE,
	S364_OPTIONS_DAC_16_BIT_COLOR_MODE_555,
	S364_OPTIONS_DAC_32_BIT_COLOR_MODE_ARGB,
	0,
	S364_OPTIONS_DAC_NAME_USE_BUILTIN,
	S364_OPTIONS_DAC_RGB_WIDTH_8,
	( S364_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS |S364_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS |S364_OPTIONS_FONTDRAW_OPTIONS_ASSEMBLE_GLYPHS ),
	S364_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_NO,
	120,
	"64x64",
	200000,
	40,
	S364_OPTIONS_HSYNC_POLARITY_DEFAULT,
	( S364_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW |S364_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES |S364_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW |S364_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_LINE ),
	256,
	256,
	256,
	57,
	0,
	S364_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC,
	1,
	17,
	4,
	2,
	0,
	0,
	"",
	0,
	0,
	S364_OPTIONS_PCI_9GXE64_1280_MODES_NO,
	( S364_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT ),
	( S364_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT |S364_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT |S364_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY |S364_OPTIONS_RECTFILL_OPTIONS_USE_GE_MONO_PATFILL |S364_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT |S364_OPTIONS_RECTFILL_OPTIONS_USE_TILE_SHRINK ),
	"",
	0,
	S364_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE,
	32,
	( S364_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL ),
	0,
	"64x64",
	"64x64",
	0,
	S364_OPTIONS_VIDEO_CLOCK_DELAY_NO,
	S364_OPTIONS_VIDEO_CLOCK_INVERT_NO,
	S364_OPTIONS_VLB_964_LINE_WORKAROUND_NO,
	S364_OPTIONS_VSYNC_POLARITY_DEFAULT,
	8072,

};

/*
 * The list of option keywords.
 */

static const char *const s364_options_keywords[] = 
{
	"arc-cache-size",
	"arcdraw-options",
	"bitblt-options",
	"bus-kind",
	"chipset-name",
	"chipset-revision-number",
	"clock-chip-name",
	"clock-doubler-threshold",
	"crtc-sync-timeout-count",
	"cursor-max-size",
	"cursor-type",
	"dac-16-bit-color-mode",
	"dac-32-bit-color-mode",
	"dac-max-frequency",
	"dac-name",
	"dac-rgb-width",
	"fontdraw-options",
	"framebuffer-access-for-core-server",
	"framebuffer-physical-address",
	"glyph-cache-size",
	"graphics-engine-loop-timeout-count",
	"graphics-engine-micro-delay-count",
	"hsync-polarity",
	"linedraw-options",
	"max-number-of-glyphs-in-downloadable-font",
	"maximum-offscreen-downloadable-bitmap-height",
	"maximum-offscreen-downloadable-bitmap-width",
	"memory-clock-frequency",
	"modedb-string",
	"monitor-sync-type",
	"number-of-downloadable-cursors",
	"number-of-downloadable-fonts",
	"number-of-graphics-states",
	"omm-full-coalesce-watermark",
	"omm-hash-list-size",
	"omm-horizontal-constraint",
	"omm-named-allocation-list",
	"omm-neighbour-list-increment",
	"omm-vertical-constraint",
	"options-file",
	"options-variable",
	"pci-9gxe64-1280-modes",
	"pointdraw-options",
	"rectfill-options",
	"register-values-string",
	"screen-visual-list",
	"si-interface-version",
	"small-stipple-conversion-threshold",
	"spansfill-options",
	"static-colormap-description-file",
	"stipple-best-size",
	"tile-best-size",
	"verbose-startup",
	"video-clock-delay",
	"video-clock-invert",
	"vlb-964-line-workaround",
	"vsync-polarity",
	"vt-switch-save-lines",

	0
};
/*
 * This array maps the option index to the option kind.
 */
static enum s364_options_kind option_index_to_option_kind[] =
{
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_MULTIPLE_ENUMERATION,
	S364_OPTIONS_MULTIPLE_ENUMERATION,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_STRING,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_MULTIPLE_ENUMERATION,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_STRING,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_MULTIPLE_ENUMERATION,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_STRING,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_STRING,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_OPTION_FILE,
	S364_OPTIONS_OPTION_ENVIRONMENT,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_MULTIPLE_ENUMERATION,
	S364_OPTIONS_MULTIPLE_ENUMERATION,
	S364_OPTIONS_STRING,
	S364_OPTIONS_MULTIPLE_ENUMERATION,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_MULTIPLE_ENUMERATION,
	S364_OPTIONS_STRING,
	S364_OPTIONS_STRING,
	S364_OPTIONS_STRING,
	S364_OPTIONS_NUMERIC,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_UNIQUE_ENUMERATION,
	S364_OPTIONS_NUMERIC,

	s364_options_end_option_types
};



/*
 * List of enumeration keywords.
 */

static const char *const s364_options_si_interface_version_keywords[] =
{
	"1-0",
	"1-1",
	"auto-configure",
	0
};
static const enum s364_options_si_interface_version s364_options_si_interface_version_index_to_value[] =
{
	S364_OPTIONS_SI_INTERFACE_VERSION_1_0,
	S364_OPTIONS_SI_INTERFACE_VERSION_1_1,
	S364_OPTIONS_SI_INTERFACE_VERSION_AUTO_CONFIGURE,
	s364_options_si_interface_version_end_enumeration
};
static const char *const s364_options_monitor_sync_type_keywords[] =
{
	"composite-sync",
	"sync-on-green",
	"separate-sync",
	0
};
static const enum s364_options_monitor_sync_type s364_options_monitor_sync_type_index_to_value[] =
{
	S364_OPTIONS_MONITOR_SYNC_TYPE_COMPOSITE_SYNC,
	S364_OPTIONS_MONITOR_SYNC_TYPE_SYNC_ON_GREEN,
	S364_OPTIONS_MONITOR_SYNC_TYPE_SEPARATE_SYNC,
	s364_options_monitor_sync_type_end_enumeration
};
static const char *const s364_options_vsync_polarity_keywords[] =
{
	"positive",
	"negative",
	"default",
	0
};
static const enum s364_options_vsync_polarity s364_options_vsync_polarity_index_to_value[] =
{
	S364_OPTIONS_VSYNC_POLARITY_POSITIVE,
	S364_OPTIONS_VSYNC_POLARITY_NEGATIVE,
	S364_OPTIONS_VSYNC_POLARITY_DEFAULT,
	s364_options_vsync_polarity_end_enumeration
};
static const char *const s364_options_hsync_polarity_keywords[] =
{
	"positive",
	"negative",
	"default",
	0
};
static const enum s364_options_hsync_polarity s364_options_hsync_polarity_index_to_value[] =
{
	S364_OPTIONS_HSYNC_POLARITY_POSITIVE,
	S364_OPTIONS_HSYNC_POLARITY_NEGATIVE,
	S364_OPTIONS_HSYNC_POLARITY_DEFAULT,
	s364_options_hsync_polarity_end_enumeration
};
static const char *const s364_options_framebuffer_access_for_core_server_keywords[] =
{
	"yes",
	"no",
	0
};
static const enum s364_options_framebuffer_access_for_core_server s364_options_framebuffer_access_for_core_server_index_to_value[] =
{
	S364_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_YES,
	S364_OPTIONS_FRAMEBUFFER_ACCESS_FOR_CORE_SERVER_NO,
	s364_options_framebuffer_access_for_core_server_end_enumeration
};
static const char *const s364_options_chipset_name_keywords[] =
{
	"vision864",
	"vision964",
	"auto-detect",
	0
};
static const enum s364_options_chipset_name s364_options_chipset_name_index_to_value[] =
{
	S364_OPTIONS_CHIPSET_NAME_VISION864,
	S364_OPTIONS_CHIPSET_NAME_VISION964,
	S364_OPTIONS_CHIPSET_NAME_AUTO_DETECT,
	s364_options_chipset_name_end_enumeration
};
static const char *const s364_options_clock_chip_name_keywords[] =
{
	"chrontel-ch9204c",
	"chrontel-ch9204g",
	"icd-2061a",
	"tvp3025",
	"use-builtin",
	0
};
static const enum s364_options_clock_chip_name s364_options_clock_chip_name_index_to_value[] =
{
	S364_OPTIONS_CLOCK_CHIP_NAME_CHRONTEL_CH9204C,
	S364_OPTIONS_CLOCK_CHIP_NAME_CHRONTEL_CH9204G,
	S364_OPTIONS_CLOCK_CHIP_NAME_ICD_2061A,
	S364_OPTIONS_CLOCK_CHIP_NAME_TVP3025,
	S364_OPTIONS_CLOCK_CHIP_NAME_USE_BUILTIN,
	s364_options_clock_chip_name_end_enumeration
};
static const char *const s364_options_bus_kind_keywords[] =
{
	"vlb",
	"pci",
	"auto-detect",
	0
};
static const enum s364_options_bus_kind s364_options_bus_kind_index_to_value[] =
{
	S364_OPTIONS_BUS_KIND_VLB,
	S364_OPTIONS_BUS_KIND_PCI,
	S364_OPTIONS_BUS_KIND_AUTO_DETECT,
	s364_options_bus_kind_end_enumeration
};
static const char *const s364_options_video_clock_delay_keywords[] =
{
	"yes",
	"no",
	0
};
static const enum s364_options_video_clock_delay s364_options_video_clock_delay_index_to_value[] =
{
	S364_OPTIONS_VIDEO_CLOCK_DELAY_YES,
	S364_OPTIONS_VIDEO_CLOCK_DELAY_NO,
	s364_options_video_clock_delay_end_enumeration
};
static const char *const s364_options_video_clock_invert_keywords[] =
{
	"yes",
	"no",
	0
};
static const enum s364_options_video_clock_invert s364_options_video_clock_invert_index_to_value[] =
{
	S364_OPTIONS_VIDEO_CLOCK_INVERT_YES,
	S364_OPTIONS_VIDEO_CLOCK_INVERT_NO,
	s364_options_video_clock_invert_end_enumeration
};
static const char *const s364_options_dac_name_keywords[] =
{
	"att21c498",
	"Bt485KPJ110",
	"Bt485KPJ135",
	"TVP3020-135MDN",
	"TVP3020-175MDN",
	"TVP3020-200MDN",
	"PTVP3025-135MDN",
	"PTVP3025-175MDN",
	"PTVP3025-200MDN",
	"use-builtin",
	0
};
static const enum s364_options_dac_name s364_options_dac_name_index_to_value[] =
{
	S364_OPTIONS_DAC_NAME_ATT21C498,
	S364_OPTIONS_DAC_NAME_BT485KPJ110,
	S364_OPTIONS_DAC_NAME_BT485KPJ135,
	S364_OPTIONS_DAC_NAME_TVP3020_135MDN,
	S364_OPTIONS_DAC_NAME_TVP3020_175MDN,
	S364_OPTIONS_DAC_NAME_TVP3020_200MDN,
	S364_OPTIONS_DAC_NAME_PTVP3025_135MDN,
	S364_OPTIONS_DAC_NAME_PTVP3025_175MDN,
	S364_OPTIONS_DAC_NAME_PTVP3025_200MDN,
	S364_OPTIONS_DAC_NAME_USE_BUILTIN,
	s364_options_dac_name_end_enumeration
};
static const char *const s364_options_dac_rgb_width_keywords[] =
{
	"6",
	"8",
	0
};
static const enum s364_options_dac_rgb_width s364_options_dac_rgb_width_index_to_value[] =
{
	S364_OPTIONS_DAC_RGB_WIDTH_6,
	S364_OPTIONS_DAC_RGB_WIDTH_8,
	s364_options_dac_rgb_width_end_enumeration
};
static const char *const s364_options_dac_32_bit_color_mode_keywords[] =
{
	"rgba",
	"abgr",
	"argb",
	"bgra",
	0
};
static const enum s364_options_dac_32_bit_color_mode s364_options_dac_32_bit_color_mode_index_to_value[] =
{
	S364_OPTIONS_DAC_32_BIT_COLOR_MODE_RGBA,
	S364_OPTIONS_DAC_32_BIT_COLOR_MODE_ABGR,
	S364_OPTIONS_DAC_32_BIT_COLOR_MODE_ARGB,
	S364_OPTIONS_DAC_32_BIT_COLOR_MODE_BGRA,
	s364_options_dac_32_bit_color_mode_end_enumeration
};
static const char *const s364_options_dac_16_bit_color_mode_keywords[] =
{
	"555",
	"565",
	"664",
	0
};
static const enum s364_options_dac_16_bit_color_mode s364_options_dac_16_bit_color_mode_index_to_value[] =
{
	S364_OPTIONS_DAC_16_BIT_COLOR_MODE_555,
	S364_OPTIONS_DAC_16_BIT_COLOR_MODE_565,
	S364_OPTIONS_DAC_16_BIT_COLOR_MODE_664,
	s364_options_dac_16_bit_color_mode_end_enumeration
};
static const char *const s364_options_screen_visual_list_keywords[] =
{
	"static-gray",
	"gray-scale",
	"static-color",
	"pseudo-color",
	"true-color",
	"direct-color",
	0
};
static const int s364_options_screen_visual_list_index_to_value[] =
{
	S364_OPTIONS_SCREEN_VISUAL_LIST_STATIC_GRAY,
	S364_OPTIONS_SCREEN_VISUAL_LIST_GRAY_SCALE,
	S364_OPTIONS_SCREEN_VISUAL_LIST_STATIC_COLOR,
	S364_OPTIONS_SCREEN_VISUAL_LIST_PSEUDO_COLOR,
	S364_OPTIONS_SCREEN_VISUAL_LIST_TRUE_COLOR,
	S364_OPTIONS_SCREEN_VISUAL_LIST_DIRECT_COLOR,
	-1
};
static const char *const s364_options_cursor_type_keywords[] =
{
	"software-cursor",
	"chipset-cursor",
	"dac-cursor",
	"auto-configure",
	0
};
static const enum s364_options_cursor_type s364_options_cursor_type_index_to_value[] =
{
	S364_OPTIONS_CURSOR_TYPE_SOFTWARE_CURSOR,
	S364_OPTIONS_CURSOR_TYPE_CHIPSET_CURSOR,
	S364_OPTIONS_CURSOR_TYPE_DAC_CURSOR,
	S364_OPTIONS_CURSOR_TYPE_AUTO_CONFIGURE,
	s364_options_cursor_type_end_enumeration
};
static const char *const s364_options_rectfill_options_keywords[] =
{
	"use-solid-fill-rect",
	"use-tile-fill-rect",
	"use-stipple-fill-rect",
	"use-ge-mono-patfill",
	"use-offscreen-memory",
	"use-tile-shrink",
	"none",
	0
};
static const int s364_options_rectfill_options_index_to_value[] =
{
	S364_OPTIONS_RECTFILL_OPTIONS_USE_SOLID_FILL_RECT,
	S364_OPTIONS_RECTFILL_OPTIONS_USE_TILE_FILL_RECT,
	S364_OPTIONS_RECTFILL_OPTIONS_USE_STIPPLE_FILL_RECT,
	S364_OPTIONS_RECTFILL_OPTIONS_USE_GE_MONO_PATFILL,
	S364_OPTIONS_RECTFILL_OPTIONS_USE_OFFSCREEN_MEMORY,
	S364_OPTIONS_RECTFILL_OPTIONS_USE_TILE_SHRINK,
	S364_OPTIONS_RECTFILL_OPTIONS_NONE,
	-1
};
static const char *const s364_options_bitblt_options_keywords[] =
{
	"use-ss-bitblt",
	"use-ms-bitblt",
	"use-sm-bitblt",
	"use-ms-stplblt",
	"none",
	0
};
static const int s364_options_bitblt_options_index_to_value[] =
{
	S364_OPTIONS_BITBLT_OPTIONS_USE_SS_BITBLT,
	S364_OPTIONS_BITBLT_OPTIONS_USE_MS_BITBLT,
	S364_OPTIONS_BITBLT_OPTIONS_USE_SM_BITBLT,
	S364_OPTIONS_BITBLT_OPTIONS_USE_MS_STPLBLT,
	S364_OPTIONS_BITBLT_OPTIONS_NONE,
	-1
};
static const char *const s364_options_linedraw_options_keywords[] =
{
	"use-line-draw",
	"use-line-rectangles",
	"use-segment-draw",
	"use-dashed-line",
	"none",
	0
};
static const int s364_options_linedraw_options_index_to_value[] =
{
	S364_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_DRAW,
	S364_OPTIONS_LINEDRAW_OPTIONS_USE_LINE_RECTANGLES,
	S364_OPTIONS_LINEDRAW_OPTIONS_USE_SEGMENT_DRAW,
	S364_OPTIONS_LINEDRAW_OPTIONS_USE_DASHED_LINE,
	S364_OPTIONS_LINEDRAW_OPTIONS_NONE,
	-1
};
static const char *const s364_options_spansfill_options_keywords[] =
{
	"use-solid-fill",
	0
};
static const int s364_options_spansfill_options_index_to_value[] =
{
	S364_OPTIONS_SPANSFILL_OPTIONS_USE_SOLID_FILL,
	-1
};
static const char *const s364_options_pointdraw_options_keywords[] =
{
	"use-plot-point",
	"none",
	0
};
static const int s364_options_pointdraw_options_index_to_value[] =
{
	S364_OPTIONS_POINTDRAW_OPTIONS_USE_PLOT_POINT,
	S364_OPTIONS_POINTDRAW_OPTIONS_NONE,
	-1
};
static const char *const s364_options_fontdraw_options_keywords[] =
{
	"draw-non-terminal-fonts",
	"draw-terminal-fonts",
	"assemble-glyphs",
	0
};
static const int s364_options_fontdraw_options_index_to_value[] =
{
	S364_OPTIONS_FONTDRAW_OPTIONS_DRAW_NON_TERMINAL_FONTS,
	S364_OPTIONS_FONTDRAW_OPTIONS_DRAW_TERMINAL_FONTS,
	S364_OPTIONS_FONTDRAW_OPTIONS_ASSEMBLE_GLYPHS,
	-1
};
static const char *const s364_options_arcdraw_options_keywords[] =
{
	"draw-one-bit-arcs",
	0
};
static const int s364_options_arcdraw_options_index_to_value[] =
{
	S364_OPTIONS_ARCDRAW_OPTIONS_DRAW_ONE_BIT_ARCS,
	-1
};
static const char *const s364_options_pci_9gxe64_1280_modes_keywords[] =
{
	"yes",
	"no",
	0
};
static const enum s364_options_pci_9gxe64_1280_modes s364_options_pci_9gxe64_1280_modes_index_to_value[] =
{
	S364_OPTIONS_PCI_9GXE64_1280_MODES_YES,
	S364_OPTIONS_PCI_9GXE64_1280_MODES_NO,
	s364_options_pci_9gxe64_1280_modes_end_enumeration
};
static const char *const s364_options_vlb_964_line_workaround_keywords[] =
{
	"yes",
	"no",
	0
};
static const enum s364_options_vlb_964_line_workaround s364_options_vlb_964_line_workaround_index_to_value[] =
{
	S364_OPTIONS_VLB_964_LINE_WORKAROUND_YES,
	S364_OPTIONS_VLB_964_LINE_WORKAROUND_NO,
	s364_options_vlb_964_line_workaround_end_enumeration
};


/*
 * Help message.
 */
static const char *const s364_options_description = 
"si-interface-version\tThe version number that the SDD returns to the SI server.\n"
"verbose-startup\tPrint messages about chipset configuration if set to 1.\n"
"modedb-string\tModeDB entry in the following format: \"Clock HorizontalTiming VerticalTiming \".  Clock is in MHz.  The Timing field consists of Display, SyncStart, SyncEnd and Total timings in that order.  Anything after VerticalTiming field is IGNORED.  Interlaced modes are NOT SUPPORTED.  Hence, it is assumed that the mode parameters are for Non Interlaced mode.\n"
"monitor-sync-type\tThe monitor's SYNC type.\n"
"vsync-polarity\tThe polarity of the v-sync pulse.  Actually monitor dependent.  But most monitors could handle either case.\n"
"hsync-polarity\tThe polarity of the h-sync pulse.  Actually monitor dependent.  But most monitors could handle either case.\n"
"register-values-string\tThis option provides a general way of programming crtc registers of the chipset.  Format of the string is as follows \"index mask value rbits, index mask value rbits , ...\" Each 4-tuple is comma seperated.  No range value checking is done.  The meanings of index,mask,value,rbits are : index - register index to program ( like crtc registers) mask,value - value bits corresponding to a 1 in the mask will be programmed.  rbits - bit positions with a 1 in rbits are treated as reserved bits.  ( a 0 will be written).\n"
"framebuffer-physical-address\tThe physical address where the framebuffer will be mapped.  This value is specified in megabytes and indicates the start physical address of the framebuffer in your systems memory space.  This has to be greater than the available memory on your system and has to be a multiple of 8MB\n"
"framebuffer-access-for-core-server\tWhether or not the framebuffer is visible to the core server or not.  If yes the core server can directly draw into the video memory without calling the sdd specific drawing routines if required.  There are some problems here which are performance related.\n"
"chipset-name\tThe type of accelarator.\n"
"chipset-revision-number\tThe stepping number on the chipset.  -1 indicates auto detect.\n"
"clock-chip-name\tThe type of clock chip on the video board.\n"
"bus-kind\tType of memory bus.\n"
"graphics-engine-loop-timeout-count\tNumber of cycles to wait before signalling an error.\n"
"graphics-engine-micro-delay-count\tNumber of cycles spin-wait between register accesses.\n"
"crtc-sync-timeout-count\tNumber of cycles to wait for sync pulse to occour\n"
"video-clock-delay\tIntroduces a delay for the clocks to synchronize.  Used only if the video board has Ti3025 dac.\n"
"video-clock-invert\tThe video clock inversion loop is enabled till the\\n"
"memory-clock-frequency\tSpecifies the Mclock frequency in MHz that is to be programmed.  Used only if the video board has Ti3025 dac.  When increaing memory clock frequency beyond 57 MHz, MAKE SURE your board can operate at that frequency.  High values of memory clock frequency MIGHT cause drawing problems ( pixel droppings ).  A value of 0 means the memory clock is not progrmmed.\n"
"dac-name\tThe type of DAC on board.\n"
"dac-max-frequency\tEvery dac has a maximum frequency to which it can operate without damaging itself/card/monitor.  This option allows overriding of the builtin default value for the dac.  A value of 0 (default) will use the builtin defaults.  UTMOST CAUTION SHOULD BE TAKEN WHILE CHANGING THIS OPTION.  Wrong use can damage your system.  The value is in Hz.\n"
"clock-doubler-threshold\tThis option provides a way of specifying the threshold greater than which the clock doubler will be enabled for dacs that have an internal clock doubler.  A value of -1 indicates that builtin default threshold values have to be used.\n"
"dac-rgb-width\tNumber of significant bits per R/G/B output.  `default' value is the industry standard of 6.\n"
"dac-32-bit-color-mode\tOrder of R/G/B pixels in a 32 bit word.\n"
"dac-16-bit-color-mode\tBits for R/G/B in 16 bit mode.\n"
"screen-visual-list\tSupported display visuals in addition to the screen default visual specified in the server config file.  Remember that for screen depths greater than 8 only true-color or direct-color can appear as the list.  Caveat : the core server does not seem to handle multiple visuals per screen yet ...\n"
"cursor-type\tCursor implementation types.\n"
"cursor-max-size\tMaximum size of a cursor in WxH.\n"
"number-of-downloadable-cursors\tNumber of downloaded hardware cursors.  `0' means use internal default.\n"
"number-of-downloadable-fonts\tNumber of downloaded fonts.  `0' means to turn off font handling in the SDD.\n"
"max-number-of-glyphs-in-downloadable-font\tThe maximum number of glyphs in a font suitable for downloading.  0 means ignore this criterion.\n"
"vt-switch-save-lines\tNumber of lines of screen to save.  Exact values would save the total memory occupied by the x server.\n"
"number-of-graphics-states\tNumber of SDD graphics states.  `0' means use internal default.\n"
"tile-best-size\tBest tile size as seen by the Si code\n"
"stipple-best-size\tBest stipple size as seen by si code.\n"
"maximum-offscreen-downloadable-bitmap-width\tDo not download tiles/stipples of more than this width into offscreen memory\n"
"maximum-offscreen-downloadable-bitmap-height\tDo not download tiles/stipples of more than this height into offscreen memory\n"
"small-stipple-conversion-threshold\tConvert stipples that are a power of two and having repeated patterns into 8x8 patterns so that they can be stippled using the faster graphics engine monochrome patblt feature.  This value specifies the maximum width and height of such a stipple.  Only powers of 2 are legal values.  This option is used even for tiles which get reduced to stipples because they have only 2 colors.\n"
"glyph-cache-size\tCache glyphs smaller than this size in offscreen memory\n"
"arc-cache-size\tThe number of arcs to cache in the display library at a given time.  `0' means switch off arc caching.\n"
"rectfill-options\tControlling fill functionality.\n"
"bitblt-options\tControlling fill functionality.\n"
"linedraw-options\tControlling line draw functionality.\n"
"spansfill-options\tControlling spans fill functionality.\n"
"pointdraw-options\tControlling plot point functionality.\n"
"fontdraw-options\tOptions for controlling the fontdrawing module.\n"
"arcdraw-options\tControls the drawing operation for arcs.\n"
"omm-named-allocation-list\tNamed allocation requests for the offscreen memory manager.\n"
"omm-horizontal-constraint\tThe widths of all offscreen memory requests are rounded up to this value.  O means use an internal heuristic.\n"
"omm-vertical-constraint\tThe heights of all offscreen memory requests are rounded up to this value.  0 implies internal default.\n"
"omm-neighbour-list-increment\tNumber of neighbour list nodes allocated at one time.  Neighbour lists are managed during every allocate and free operation.  0 implies an internal default.\n"
"omm-full-coalesce-watermark\tIf the number of currently allocated blocks falls below this value the omm will attempt a full coalesion operation.  Remember that coalesion is an expensive operation.\n"
"omm-hash-list-size\tSize of the hash table of omm free blocks.  0 implies an internal default.\n"
"pci-9gxe64-1280-modes\tOption to enable/disable 1280 and 1152 (high refresh rate) modes on #9GXE64 PCI Vision864 based boards.\n"
"vlb-964-line-workaround\tWorkaround in case any problems are observed in solid line drawing on VLB Vision964 based boards.\n"
;

/*
 * Lookup a name in a table.
 */
static int
s364_options_lookup_name(const char *name_p, const char *const *name_list_p)
{
	int name_index = 0;
	
	while (*name_list_p)
	{
		if (strcmp(*name_list_p, name_p))
		{
			name_index ++;
			name_list_p ++;
		}
		else
		{

#if (defined(__DEBUG__))
			if(s364_options_debug)
			{
				(void) fprintf(debug_stream_p,
						"(s364_options_ lookup) \"%s\" "
						"index = %d.\n", name_p, name_index);
					
			}
#endif
			return name_index;
			
		}
	}
	return -1;
	
}

/*
 * Get the next token.
 */

static char * 
s364_options_parse_get_next_token(char *character_p)
{
	/* CONSTANTCONDITION */
	while (1)
	{
		/*
		 * Skip leading WS.
		 */
		while( (*character_p != EOS) && isspace(*character_p))
		{
			character_p ++;
		}
		if (*character_p == EOS)
		{
			break;
		}
		else if(*character_p == '#')
		{
			/*
			 * Comment.  Skip till new line.
			 */
			while ((*character_p != EOS) && (*character_p != '\n'))
			{
				character_p ++;
			}
		}
		else if (*character_p == '\\')
		{
			*character_p ++ = ' ';	/* replace '\' */
			*character_p = (*character_p == '\n') ? ' ' : *character_p;
		}
		else
		{
			return character_p;
		}
	}
	return (char *) 0;
}		

/*
 * s364_options_parse : parse options.
 */
function struct s364_options_structure *
s364_options_parse (struct s364_options_structure *option_struct_p,
			   const char *option_string_p)
{
	char * character_p;
	char * option_check_integer_p; /* return value of strtol() */
	struct stat stat_buf;
	
	char *option_list_p;		/* modifiable copy of option list */
	int option_name_index;		/* option keyword index */
	int option_enum_index;		/* enumeration value index */
	int option_enum_is_inverted; /* for !<value> parsing */
	
	char *tmp_p;				/* temporary */
	char *option_name_p, *option_value_p; /* for separating name=value */
	FILE *option_file_p;
	
	
	if (!option_struct_p)
	{
		option_struct_p = allocate_memory(sizeof (struct
												  s364_options_structure));
		if (!option_struct_p)
		{
			perror(DEFAULT_OPTION_CANNOT_ALLOCATE_MEMORY_MESSAGE);
			goto error;
			
		}
		
		/*
		 * Copy the defaults.
		 */
		*option_struct_p = s364_options_default;
		
	}

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "(s364_options_parse) "
				"option_string = \"%s\"\n", option_string_p);
	}
#endif

	/*
	 * Save the option string as we are going to munge it.
	 */
	option_list_p = strdup(option_string_p);
	
	character_p =
		s364_options_parse_get_next_token(option_list_p);
	
	while(character_p)
	{
		/*
		 * parse the token, looking for name'='value pairs.
		 */
		option_name_p = character_p;
		while ((*character_p != EOS) && 
			   (*character_p != '='))
		{
			character_p ++;
		}
		if (*character_p != '=')
		{
			/*
			 * Error encountered.
			 */
			(void) fprintf(stderr, 
						   DEFAULT_OPTION_MALFORMED_OPTION_STRING_MESSAGE,
						   option_name_p);
			
			free_memory(option_list_p);
			return (struct s364_options_structure *) 0;
			
		}
		else
		{
			*character_p++ = EOS;
			if (*character_p == EOS)
			{
				/*
				 * Error encountered.
				 */
				(void) fprintf(stderr, 
							   DEFAULT_OPTION_MALFORMED_OPTION_STRING_MESSAGE,
							   option_name_p);
			
				free_memory(option_list_p);
				return (struct s364_options_structure *) 0;
				
			}
			/*
			 * Look for terminating white-space.
			 */
			if (*character_p == '\"')
			{
				/*
				 * Terminated by a '\"'.
				 */
				*character_p ++ = EOS;
				option_value_p = character_p;
				
				while ((*character_p != EOS) && 
					   (*character_p != '\"'))
				{
					character_p ++;
				}
				if (*character_p == EOS)
				{
					(void) fprintf(stderr,
						DEFAULT_OPTION_UNTERMINATED_STRING_CONSTANT_MESSAGE,
								   option_name_p);
					free_memory (option_list_p);
					return (struct s364_options_structure *) 0;
				}
				else
				{
					*character_p ++ = EOS;
				}
			}
			else
			{
				/*
				 * White space terminated.
				 */
				option_value_p = character_p;

				/* CONSTANTCONDITION */
				while (1)
				{
					
					while ( (*character_p != EOS) && ! isspace(*character_p))
					{
						character_p ++;
					}
			
					if (*character_p != EOS)
					{

						if (*character_p == '\n' && *(character_p-1) == '\\')
						{
							/*
							 * Skip backslashed newline.
							 */
							character_p ++;
						}
						else
						{
							*character_p++ = EOS;
							break;
						}
					}
					else
					{
						break;
					}

				}			
			}
		}

		/*
		 * Analyze the option name and option value extracted.
		 */
		option_name_index =
			s364_options_lookup_name(option_name_p, &(s364_options_keywords[0]));
				
		if (option_name_index == -1)
		{
			(void) fprintf(stderr,
					DEFAULT_OPTION_UNRECOGNIZED_OPTION_MESSAGE,
					option_name_p);
			free_memory (option_list_p);
			return (struct s364_options_structure *) 0;
		}
#if (defined(__DEBUG__))
		else
		{
			if (s364_options_debug)
			{
				(void) fprintf(debug_stream_p,
						"(s364_options_parse) recognized "
						"\"%s\" of type \"%s\", value "
						"\"%s\".\n", 
						option_name_p,
						option_type_dump[option_index_to_option_kind[option_name_index]],
						option_value_p);
				
			}
		}
#endif
	
		/*
		 * Depending on the kind of code, take action.
		 */
		switch (option_name_index)
		{

			

case 0 :	/* arc-cache-size */
	option_struct_p->arc_cache_size = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->arc_cache_size == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"arc-cache-size");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	arc-cache-size = %d\n",
				option_struct_p->arc_cache_size);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->arc_cache_size >= 0) && (option_struct_p->arc_cache_size <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"arc-cache-size");
		goto error;
	}

	break;

case 1 :	/* arcdraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			s364_options_lookup_name(option_value_p, &(s364_options_arcdraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "arcdraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->arcdraw_options &= 
				(~s364_options_arcdraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->arcdraw_options |= 
				(s364_options_arcdraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "(s364_options_parse) enum arcdraw-options value %d.\n",
			option_struct_p->arcdraw_options);
	}
#endif

	break;

case 2 :	/* bitblt-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			s364_options_lookup_name(option_value_p, &(s364_options_bitblt_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "bitblt-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->bitblt_options &= 
				(~s364_options_bitblt_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->bitblt_options |= 
				(s364_options_bitblt_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "(s364_options_parse) enum bitblt-options value %d.\n",
			option_struct_p->bitblt_options);
	}
#endif

	break;

case 3 :	/* bus-kind */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_bus_kind_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "bus-kind");
		goto error;
	}
	option_struct_p->bus_kind = s364_options_bus_kind_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum bus-kind value '%s'\n",
			s364_options_bus_kind_keywords[option_enum_index]);
	}
#endif
	break;

case 4 :	/* chipset-name */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_chipset_name_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "chipset-name");
		goto error;
	}
	option_struct_p->chipset_name = s364_options_chipset_name_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum chipset-name value '%s'\n",
			s364_options_chipset_name_keywords[option_enum_index]);
	}
#endif
	break;


case 5 :	/* chipset-revision-number */
	option_struct_p->chipset_revision_number = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->chipset_revision_number == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"chipset-revision-number");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	chipset-revision-number = %d\n",
				option_struct_p->chipset_revision_number);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->chipset_revision_number >= -1) && (option_struct_p->chipset_revision_number <= 10)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"chipset-revision-number");
		goto error;
	}

	break;

case 6 :	/* clock-chip-name */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_clock_chip_name_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "clock-chip-name");
		goto error;
	}
	option_struct_p->clock_chip_name = s364_options_clock_chip_name_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum clock-chip-name value '%s'\n",
			s364_options_clock_chip_name_keywords[option_enum_index]);
	}
#endif
	break;


case 7 :	/* clock-doubler-threshold */
	option_struct_p->clock_doubler_threshold = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->clock_doubler_threshold == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"clock-doubler-threshold");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	clock-doubler-threshold = %d\n",
				option_struct_p->clock_doubler_threshold);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->clock_doubler_threshold >= -1) && (option_struct_p->clock_doubler_threshold <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"clock-doubler-threshold");
		goto error;
	}

	break;


case 8 :	/* crtc-sync-timeout-count */
	option_struct_p->crtc_sync_timeout_count = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->crtc_sync_timeout_count == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"crtc-sync-timeout-count");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	crtc-sync-timeout-count = %d\n",
				option_struct_p->crtc_sync_timeout_count);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->crtc_sync_timeout_count >= 1) && (option_struct_p->crtc_sync_timeout_count <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"crtc-sync-timeout-count");
		goto error;
	}

	break;

case 9 :	/* cursor-max-size */
	option_struct_p->cursor_max_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	cursor-max-size = \"%s\"\n",
			option_struct_p->cursor_max_size);
	}
#endif

	break;

case 10 :	/* cursor-type */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_cursor_type_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "cursor-type");
		goto error;
	}
	option_struct_p->cursor_type = s364_options_cursor_type_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum cursor-type value '%s'\n",
			s364_options_cursor_type_keywords[option_enum_index]);
	}
#endif
	break;

case 11 :	/* dac-16-bit-color-mode */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_dac_16_bit_color_mode_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-16-bit-color-mode");
		goto error;
	}
	option_struct_p->dac_16_bit_color_mode = s364_options_dac_16_bit_color_mode_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum dac-16-bit-color-mode value '%s'\n",
			s364_options_dac_16_bit_color_mode_keywords[option_enum_index]);
	}
#endif
	break;

case 12 :	/* dac-32-bit-color-mode */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_dac_32_bit_color_mode_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-32-bit-color-mode");
		goto error;
	}
	option_struct_p->dac_32_bit_color_mode = s364_options_dac_32_bit_color_mode_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum dac-32-bit-color-mode value '%s'\n",
			s364_options_dac_32_bit_color_mode_keywords[option_enum_index]);
	}
#endif
	break;


case 13 :	/* dac-max-frequency */
	option_struct_p->dac_max_frequency = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->dac_max_frequency == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"dac-max-frequency");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	dac-max-frequency = %d\n",
				option_struct_p->dac_max_frequency);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->dac_max_frequency >= 0) && (option_struct_p->dac_max_frequency <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"dac-max-frequency");
		goto error;
	}

	break;

case 14 :	/* dac-name */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_dac_name_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-name");
		goto error;
	}
	option_struct_p->dac_name = s364_options_dac_name_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum dac-name value '%s'\n",
			s364_options_dac_name_keywords[option_enum_index]);
	}
#endif
	break;

case 15 :	/* dac-rgb-width */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_dac_rgb_width_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "dac-rgb-width");
		goto error;
	}
	option_struct_p->dac_rgb_width = s364_options_dac_rgb_width_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum dac-rgb-width value '%s'\n",
			s364_options_dac_rgb_width_keywords[option_enum_index]);
	}
#endif
	break;

case 16 :	/* fontdraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			s364_options_lookup_name(option_value_p, &(s364_options_fontdraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "fontdraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->fontdraw_options &= 
				(~s364_options_fontdraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->fontdraw_options |= 
				(s364_options_fontdraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "(s364_options_parse) enum fontdraw-options value %d.\n",
			option_struct_p->fontdraw_options);
	}
#endif

	break;

case 17 :	/* framebuffer-access-for-core-server */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_framebuffer_access_for_core_server_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "framebuffer-access-for-core-server");
		goto error;
	}
	option_struct_p->framebuffer_access_for_core_server = s364_options_framebuffer_access_for_core_server_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum framebuffer-access-for-core-server value '%s'\n",
			s364_options_framebuffer_access_for_core_server_keywords[option_enum_index]);
	}
#endif
	break;


case 18 :	/* framebuffer-physical-address */
	option_struct_p->framebuffer_physical_address = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->framebuffer_physical_address == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"framebuffer-physical-address");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	framebuffer-physical-address = %d\n",
				option_struct_p->framebuffer_physical_address);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->framebuffer_physical_address >= 32) && (option_struct_p->framebuffer_physical_address <= 4088)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"framebuffer-physical-address");
		goto error;
	}

	break;

case 19 :	/* glyph-cache-size */
	option_struct_p->glyph_cache_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	glyph-cache-size = \"%s\"\n",
			option_struct_p->glyph_cache_size);
	}
#endif

	break;


case 20 :	/* graphics-engine-loop-timeout-count */
	option_struct_p->graphics_engine_loop_timeout_count = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->graphics_engine_loop_timeout_count == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"graphics-engine-loop-timeout-count");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	graphics-engine-loop-timeout-count = %d\n",
				option_struct_p->graphics_engine_loop_timeout_count);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->graphics_engine_loop_timeout_count >= 1) && (option_struct_p->graphics_engine_loop_timeout_count <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"graphics-engine-loop-timeout-count");
		goto error;
	}

	break;


case 21 :	/* graphics-engine-micro-delay-count */
	option_struct_p->graphics_engine_micro_delay_count = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->graphics_engine_micro_delay_count == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"graphics-engine-micro-delay-count");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	graphics-engine-micro-delay-count = %d\n",
				option_struct_p->graphics_engine_micro_delay_count);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->graphics_engine_micro_delay_count >= 1) && (option_struct_p->graphics_engine_micro_delay_count <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"graphics-engine-micro-delay-count");
		goto error;
	}

	break;

case 22 :	/* hsync-polarity */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_hsync_polarity_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "hsync-polarity");
		goto error;
	}
	option_struct_p->hsync_polarity = s364_options_hsync_polarity_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum hsync-polarity value '%s'\n",
			s364_options_hsync_polarity_keywords[option_enum_index]);
	}
#endif
	break;

case 23 :	/* linedraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			s364_options_lookup_name(option_value_p, &(s364_options_linedraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "linedraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->linedraw_options &= 
				(~s364_options_linedraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->linedraw_options |= 
				(s364_options_linedraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "(s364_options_parse) enum linedraw-options value %d.\n",
			option_struct_p->linedraw_options);
	}
#endif

	break;


case 24 :	/* max-number-of-glyphs-in-downloadable-font */
	option_struct_p->max_number_of_glyphs_in_downloadable_font = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->max_number_of_glyphs_in_downloadable_font == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"max-number-of-glyphs-in-downloadable-font");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	max-number-of-glyphs-in-downloadable-font = %d\n",
				option_struct_p->max_number_of_glyphs_in_downloadable_font);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->max_number_of_glyphs_in_downloadable_font >= 0) && (option_struct_p->max_number_of_glyphs_in_downloadable_font <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"max-number-of-glyphs-in-downloadable-font");
		goto error;
	}

	break;


case 25 :	/* maximum-offscreen-downloadable-bitmap-height */
	option_struct_p->maximum_offscreen_downloadable_bitmap_height = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->maximum_offscreen_downloadable_bitmap_height == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"maximum-offscreen-downloadable-bitmap-height");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	maximum-offscreen-downloadable-bitmap-height = %d\n",
				option_struct_p->maximum_offscreen_downloadable_bitmap_height);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->maximum_offscreen_downloadable_bitmap_height >= 1) && (option_struct_p->maximum_offscreen_downloadable_bitmap_height <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"maximum-offscreen-downloadable-bitmap-height");
		goto error;
	}

	break;


case 26 :	/* maximum-offscreen-downloadable-bitmap-width */
	option_struct_p->maximum_offscreen_downloadable_bitmap_width = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->maximum_offscreen_downloadable_bitmap_width == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"maximum-offscreen-downloadable-bitmap-width");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	maximum-offscreen-downloadable-bitmap-width = %d\n",
				option_struct_p->maximum_offscreen_downloadable_bitmap_width);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->maximum_offscreen_downloadable_bitmap_width >= 1) && (option_struct_p->maximum_offscreen_downloadable_bitmap_width <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"maximum-offscreen-downloadable-bitmap-width");
		goto error;
	}

	break;


case 27 :	/* memory-clock-frequency */
	option_struct_p->memory_clock_frequency = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->memory_clock_frequency == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"memory-clock-frequency");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	memory-clock-frequency = %d\n",
				option_struct_p->memory_clock_frequency);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->memory_clock_frequency >= 0) && (option_struct_p->memory_clock_frequency <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"memory-clock-frequency");
		goto error;
	}

	break;

case 28 :	/* modedb-string */
	option_struct_p->modedb_string = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	modedb-string = \"%s\"\n",
			option_struct_p->modedb_string);
	}
#endif

	break;

case 29 :	/* monitor-sync-type */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_monitor_sync_type_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "monitor-sync-type");
		goto error;
	}
	option_struct_p->monitor_sync_type = s364_options_monitor_sync_type_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum monitor-sync-type value '%s'\n",
			s364_options_monitor_sync_type_keywords[option_enum_index]);
	}
#endif
	break;


case 30 :	/* number-of-downloadable-cursors */
	option_struct_p->number_of_downloadable_cursors = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->number_of_downloadable_cursors == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"number-of-downloadable-cursors");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	number-of-downloadable-cursors = %d\n",
				option_struct_p->number_of_downloadable_cursors);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->number_of_downloadable_cursors >= 0) && (option_struct_p->number_of_downloadable_cursors <= 1)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"number-of-downloadable-cursors");
		goto error;
	}

	break;


case 31 :	/* number-of-downloadable-fonts */
	option_struct_p->number_of_downloadable_fonts = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->number_of_downloadable_fonts == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"number-of-downloadable-fonts");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	number-of-downloadable-fonts = %d\n",
				option_struct_p->number_of_downloadable_fonts);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->number_of_downloadable_fonts >= 0) && (option_struct_p->number_of_downloadable_fonts <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"number-of-downloadable-fonts");
		goto error;
	}

	break;


case 32 :	/* number-of-graphics-states */
	option_struct_p->number_of_graphics_states = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->number_of_graphics_states == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"number-of-graphics-states");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	number-of-graphics-states = %d\n",
				option_struct_p->number_of_graphics_states);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->number_of_graphics_states >= 0) && (option_struct_p->number_of_graphics_states <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"number-of-graphics-states");
		goto error;
	}

	break;


case 33 :	/* omm-full-coalesce-watermark */
	option_struct_p->omm_full_coalesce_watermark = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_full_coalesce_watermark == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-full-coalesce-watermark");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-full-coalesce-watermark = %d\n",
				option_struct_p->omm_full_coalesce_watermark);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_full_coalesce_watermark >= 0) && (option_struct_p->omm_full_coalesce_watermark <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-full-coalesce-watermark");
		goto error;
	}

	break;


case 34 :	/* omm-hash-list-size */
	option_struct_p->omm_hash_list_size = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_hash_list_size == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-hash-list-size");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-hash-list-size = %d\n",
				option_struct_p->omm_hash_list_size);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_hash_list_size >= 0) && (option_struct_p->omm_hash_list_size <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-hash-list-size");
		goto error;
	}

	break;


case 35 :	/* omm-horizontal-constraint */
	option_struct_p->omm_horizontal_constraint = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_horizontal_constraint == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-horizontal-constraint");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-horizontal-constraint = %d\n",
				option_struct_p->omm_horizontal_constraint);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_horizontal_constraint >= 0) && (option_struct_p->omm_horizontal_constraint <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-horizontal-constraint");
		goto error;
	}

	break;

case 36 :	/* omm-named-allocation-list */
	option_struct_p->omm_named_allocation_list = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-named-allocation-list = \"%s\"\n",
			option_struct_p->omm_named_allocation_list);
	}
#endif

	break;


case 37 :	/* omm-neighbour-list-increment */
	option_struct_p->omm_neighbour_list_increment = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_neighbour_list_increment == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-neighbour-list-increment");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-neighbour-list-increment = %d\n",
				option_struct_p->omm_neighbour_list_increment);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_neighbour_list_increment >= 0) && (option_struct_p->omm_neighbour_list_increment <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-neighbour-list-increment");
		goto error;
	}

	break;


case 38 :	/* omm-vertical-constraint */
	option_struct_p->omm_vertical_constraint = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->omm_vertical_constraint == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"omm-vertical-constraint");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	omm-vertical-constraint = %d\n",
				option_struct_p->omm_vertical_constraint);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->omm_vertical_constraint >= 0) && (option_struct_p->omm_vertical_constraint <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"omm-vertical-constraint");
		goto error;
	}

	break;

case 39 :	/* options-file */
	/*
	 * look up the file.
	 */
	if (stat(option_value_p, &stat_buf) != 0)
	{
		/*
		 * Warn the user of missing files, and continue.
		 */
		(void) fprintf(stderr, 
					DEFAULT_OPTION_CANNOT_STAT_FILE_ARGUMENT_MESSAGE,
					option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		break;
	}

	if (stat_buf.st_size == 0)
	{
		/*
		 * Warn the user of zero length files, and continue.
		 */
		(void) fprintf(stderr,
					DEFAULT_OPTION_ZERO_LENGTH_FILE_ARGUMENT_MESSAGE,
					option_value_p, "options-file");
		break;
	}

	/* read the option file into a buffer */
	if (!(tmp_p = allocate_and_clear_memory(stat_buf.st_size+1)))
	{
		perror(DEFAULT_OPTION_CANNOT_ALLOCATE_MEMORY_MESSAGE);
		goto error;
	}

	if( (option_file_p = fopen(option_value_p, "r")) == NULL)
	{

		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_OPEN_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		goto error;
	}
	if (fread(tmp_p, stat_buf.st_size, 1, option_file_p) != 1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_READ_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		perror(LIBRARY_NAME ": Reason ");
		goto error;
	}
	(void) fclose(option_file_p);
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "\t\"%s\"\n", tmp_p);
	}
#endif
	/*
	 * Recursively invoke the interpreter.
	 */
	if (!s364_options_parse(option_struct_p, tmp_p))
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_CANNOT_PROCESS_FILE_ARGUMENT_MESSAGE,
				option_value_p, "options-file");
		free_memory(tmp_p);
		goto error;
	}
	free_memory(tmp_p);
	break;

case 40 :	/* options-variable */

	tmp_p = getenv(option_value_p);
	if (tmp_p)
	{

#if (defined(__DEBUG__))
		if (s364_options_debug)
		{
			(void) fprintf(debug_stream_p, "\t\"%s\"\n", tmp_p);
		}
#endif
		if (!s364_options_parse(option_struct_p, tmp_p))
		{
			(void) fprintf(stderr, 
					DEFAULT_OPTION_CANNOT_PROCESS_ENVIRONMENT_ARGUMENT_MESSAGE,
				option_value_p, "options-variable");
			goto error;
		}

	}
	break;

case 41 :	/* pci-9gxe64-1280-modes */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_pci_9gxe64_1280_modes_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "pci-9gxe64-1280-modes");
		goto error;
	}
	option_struct_p->pci_9gxe64_1280_modes = s364_options_pci_9gxe64_1280_modes_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum pci-9gxe64-1280-modes value '%s'\n",
			s364_options_pci_9gxe64_1280_modes_keywords[option_enum_index]);
	}
#endif
	break;

case 42 :	/* pointdraw-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			s364_options_lookup_name(option_value_p, &(s364_options_pointdraw_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "pointdraw-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->pointdraw_options &= 
				(~s364_options_pointdraw_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->pointdraw_options |= 
				(s364_options_pointdraw_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "(s364_options_parse) enum pointdraw-options value %d.\n",
			option_struct_p->pointdraw_options);
	}
#endif

	break;

case 43 :	/* rectfill-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			s364_options_lookup_name(option_value_p, &(s364_options_rectfill_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "rectfill-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->rectfill_options &= 
				(~s364_options_rectfill_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->rectfill_options |= 
				(s364_options_rectfill_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "(s364_options_parse) enum rectfill-options value %d.\n",
			option_struct_p->rectfill_options);
	}
#endif

	break;

case 44 :	/* register-values-string */
	option_struct_p->register_values_string = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	register-values-string = \"%s\"\n",
			option_struct_p->register_values_string);
	}
#endif

	break;

case 45 :	/* screen-visual-list */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			s364_options_lookup_name(option_value_p, &(s364_options_screen_visual_list_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "screen-visual-list");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->screen_visual_list &= 
				(~s364_options_screen_visual_list_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->screen_visual_list |= 
				(s364_options_screen_visual_list_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "(s364_options_parse) enum screen-visual-list value %d.\n",
			option_struct_p->screen_visual_list);
	}
#endif

	break;

case 46 :	/* si-interface-version */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_si_interface_version_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "si-interface-version");
		goto error;
	}
	option_struct_p->si_interface_version = s364_options_si_interface_version_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum si-interface-version value '%s'\n",
			s364_options_si_interface_version_keywords[option_enum_index]);
	}
#endif
	break;


case 47 :	/* small-stipple-conversion-threshold */
	option_struct_p->small_stipple_conversion_threshold = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->small_stipple_conversion_threshold == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"small-stipple-conversion-threshold");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	small-stipple-conversion-threshold = %d\n",
				option_struct_p->small_stipple_conversion_threshold);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->small_stipple_conversion_threshold >= 1) && (option_struct_p->small_stipple_conversion_threshold <= INT_MAX)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"small-stipple-conversion-threshold");
		goto error;
	}

	break;

case 48 :	/* spansfill-options */
	while (*option_value_p)
	{	
		tmp_p = option_value_p;
		/* skip till a comma */
		while((*tmp_p != EOS) && (*tmp_p != ','))
		{
			tmp_p ++;
		}
		if (*tmp_p)
		{
			*tmp_p++ = EOS;
		}

		if (*option_value_p == '!')
		{
			option_value_p ++;
			option_enum_is_inverted = 1;
		}
		else
		{
			option_enum_is_inverted = 0;
		}
		option_enum_index = 
			s364_options_lookup_name(option_value_p, &(s364_options_spansfill_options_keywords[0]));

		if (option_enum_index == -1)
		{
			(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
				option_value_p, "spansfill-options");
			goto error;
		}
		if (option_enum_is_inverted)
		{
			option_struct_p->spansfill_options &= 
				(~s364_options_spansfill_options_index_to_value[option_enum_index]);
		}
		else
		{
			option_struct_p->spansfill_options |= 
				(s364_options_spansfill_options_index_to_value[option_enum_index]);
		}

		option_value_p = tmp_p;
	}

#if (defined(__DEBUG__))
	if(s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "(s364_options_parse) enum spansfill-options value %d.\n",
			option_struct_p->spansfill_options);
	}
#endif

	break;

case 49 :	/* static-colormap-description-file */
	option_struct_p->static_colormap_description_file = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	static-colormap-description-file = \"%s\"\n",
			option_struct_p->static_colormap_description_file);
	}
#endif

	break;

case 50 :	/* stipple-best-size */
	option_struct_p->stipple_best_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	stipple-best-size = \"%s\"\n",
			option_struct_p->stipple_best_size);
	}
#endif

	break;

case 51 :	/* tile-best-size */
	option_struct_p->tile_best_size = strdup(option_value_p);
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	tile-best-size = \"%s\"\n",
			option_struct_p->tile_best_size);
	}
#endif

	break;


case 52 :	/* verbose-startup */
	option_struct_p->verbose_startup = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->verbose_startup == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"verbose-startup");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	verbose-startup = %d\n",
				option_struct_p->verbose_startup);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->verbose_startup >= 0) && (option_struct_p->verbose_startup <= 1)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"verbose-startup");
		goto error;
	}

	break;

case 53 :	/* video-clock-delay */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_video_clock_delay_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "video-clock-delay");
		goto error;
	}
	option_struct_p->video_clock_delay = s364_options_video_clock_delay_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum video-clock-delay value '%s'\n",
			s364_options_video_clock_delay_keywords[option_enum_index]);
	}
#endif
	break;

case 54 :	/* video-clock-invert */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_video_clock_invert_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "video-clock-invert");
		goto error;
	}
	option_struct_p->video_clock_invert = s364_options_video_clock_invert_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum video-clock-invert value '%s'\n",
			s364_options_video_clock_invert_keywords[option_enum_index]);
	}
#endif
	break;

case 55 :	/* vlb-964-line-workaround */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_vlb_964_line_workaround_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "vlb-964-line-workaround");
		goto error;
	}
	option_struct_p->vlb_964_line_workaround = s364_options_vlb_964_line_workaround_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum vlb-964-line-workaround value '%s'\n",
			s364_options_vlb_964_line_workaround_keywords[option_enum_index]);
	}
#endif
	break;

case 56 :	/* vsync-polarity */
	if ((option_enum_index = 
		s364_options_lookup_name(option_value_p, &(s364_options_vsync_polarity_keywords[0])))
		== -1)
	{
		(void) fprintf(stderr, 
				DEFAULT_OPTION_INCORRECT_ENUMERATION_VALUE_MESSAGE,
					option_value_p, "vsync-polarity");
		goto error;
	}
	option_struct_p->vsync_polarity = s364_options_vsync_polarity_index_to_value[option_enum_index];

#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p,
			"(s364_options_parse) enum vsync-polarity value '%s'\n",
			s364_options_vsync_polarity_keywords[option_enum_index]);
	}
#endif
	break;


case 57 :	/* vt-switch-save-lines */
	option_struct_p->vt_switch_save_lines = 
		strtol(option_value_p, &option_check_integer_p, 0);
	if(option_check_integer_p == option_value_p &&
		option_struct_p->vt_switch_save_lines == 0)
	{
		(void) fprintf(stderr, DEFAULT_OPTION_BAD_INTEGER_MESSAGE,
				"vt-switch-save-lines");
		goto error;
	}
			
#if (defined(__DEBUG__))
	if (s364_options_debug)
	{
		(void) fprintf(debug_stream_p, "	vt-switch-save-lines = %d\n",
				option_struct_p->vt_switch_save_lines);
	}
#endif 


	/* CONSTANTCONDITION */
	if (!(0|| ((option_struct_p->vt_switch_save_lines >= 0) && (option_struct_p->vt_switch_save_lines <= 8072)) ))
	{
		(void) fprintf(stderr, 
			DEFAULT_OPTION_INTEGER_OPTION_OUT_OF_BOUNDS_MESSAGE,
			"vt-switch-save-lines");
		goto error;
	}

	break;


			default :
				(void) fprintf(stderr,
						DEFAULT_OPTION_INTERNAL_ERROR_MESSAGE);
				free_memory(option_list_p);
				return (struct s364_options_structure *) 0;
			
		}
		
		/*
		 * while ...
		 */
		character_p = 
			s364_options_parse_get_next_token(character_p);
		
	}
	/*
	 * Free the space we allocated.
	 */
	free_memory(option_list_p);
	
	return option_struct_p;

  error:
	if (option_list_p)
	{
		free_memory(option_list_p);
	}
	
	return (struct s364_options_structure *) 0;
	
}

#if (defined(__TEST__))
int
main(int parameter_count, char ** parameter_pp)
{
	int i;
	int string_length = 0;
	char * options_p;

#if (defined(__DEBUG__))
	s364_options_debug = 
		getenv("s364_options_debug") ? TRUE :	FALSE;
	if (debug_stream_p == NULL && (debug_stream_p =
		    fopen(getenv("debug_stream"), "w")) == NULL)
	{
		debug_stream_p = stdout;
	}
#endif

	for(i = 1; i < parameter_count; i++)
	{
		string_length += strlen(*(parameter_pp + i));
	}
	options_p = allocate_memory(string_length + 1);
	*options_p = EOS;
	
	for(i = 1; i < parameter_count; i++)
	{
		strcat(options_p, *(parameter_pp +i));
	}

	s364_options_parse(0, options_p);

}

#endif
