.TH vprobe 1 "Version 1.0" ""
.SH NAME
vprobe - probe for and identify installed video hardware.
.SH SYNOPSIS
.B vprobe
[-verbose] [-no16] [-excl \fIlist\fP] [-mask10] 
.if n .br
[-order \fIlist\fP] [-noprobe \fIlist\fP] [-bios \fIbase\fP] 
.br
[-no_bios] [-info]
.SH DESCRIPTION
.PP
.I vprobe
is a a program that will attempt to determine the type of video hardware
installed in an EISA/ISA-bus system by checking for known registers in various
combinations at various locations (MicroChannel machines are not currently
supported).  This is an error-prone process, especially on Unix (which 
usually has a lot more esoteric hardware installed than MS-DOS system do), so 
vprobe may likely need help from the user.
.PP
.I vprobe
can identify MDA, Hercules, CGA, MCGA, EGA, VGA, and an entire horde of
SVGA chipsets (see the
.I -info
option, below).  It can also identify several HiColor/True-color RAMDACs
in use on SVGA boards.  It can identify 8514/A and some derivatives, but
not XGA, or PGC (although the author intends to add those capabilities).
Nor can it identify other esoteric video hardware (like Targa, TIGA, or 
Microfield boards).
.SH OPTIONS
.TP 8
.B "-verbose"
.I vprobe
will be verbose and provide lots of information as it does its work.
.TP 8
.B "-no16"
.I vprobe
will not attempt to use any ports that require 16-bit I/O address decoding.  
The original ISA bus only specified that I/O ports be decoded to 10 bits.
Therefore some old cards (including many 8-bit cards) will mis-decode 
references to ports that use the upper 6 bits, and may get into funny states
because they think that they are being addressed when they are not.
It is recommended that this option be used initially if any 8-bit cards
are present in the system.
.TP 8
.BI "-excl" "\ list"
.I vprobe
will not attempt to access any I/O ports on the specified exclusion list.
Some video cards use rather non-standard I/O ports that may conflict with
other cards installed in your system.  By specifying to
.I vprobe
a list of ports already in use, it will know that there cannot be any video
cards that use those ports, and hence will not probe them (which could
otherwise confuse your hardware).  The exclusion list is specified as
a comma-separated list of I/O ports or port ranges.  A range is specified
as "low-high", and is inclusive.  The ports can be specified in decimal,
in octal (numbers begin with '0'), or hexadecimal (numbers begin with '0x').
.TP 8
.B "-mask10"
This option is used in combination with
.I -excl.
It tells
.I vprobe
that when comparing an I/O port under test against the exclusion list, the
port address should be masked to 10 bits.  This is important with older
8-bit cards that only do 10 bit decoding, and for some cheap 16-bit cards
as well.  This option is simply a less-drastic form of the
.I -no16
option.
.TP 8
.BI "-order" "\ list"
This option specifies which chipsets
.I vprobe
should test, and in which order.  The
.I list
parameter is a comma-separated list of chipset names.  This list overrides
the built-in default testing order.  To find the list of acceptable names,
use the
.I -info
option described below.  Note that items displayed as "Standard video
hardware" are not usable with the
.I -order
option.
.TP 8
.BI "-noprobe" "\ list"
This options specifies which chipsets
.I vprobe
should
.B not
test.  The order of testing will either be the default order, or that
specified with the
.I -order
option described above.  The
.I list
parameter is a comma-separated list of chipset names.  To find the list
of acceptable names, use the
.I -info
option described below.  Note that items displayed as "Standard video
hardware" are not usable with the
.I -noprobe
option.
.TP 8
.BI "-bios" "\ base"
This option specifies the base address for the graphics-hardware BIOS.
By default,
.I vprobe
will attempt to locate the BIOS base on its own (the normal address is
0xC0000).  If it fails to correctly locate the BIOS (an error message will
be printed if this occurs), the
.I -bios
option can be used to specify the base.
.TP 8
.B "-no_bios"
Disallow reading of the video BIOS and
sssume that an EGA or later (VGA, SVGA) board is present as the primary
video hardware.  
.TP 8
.B "-info"
.I vprobe
will print out a listing of all the video hardware that it knows how to
identify.
.SH EXAMPLES
.PP
To run 
.I vprobe 
in its most basic and automated form, simply enter:
.sp
.ce
.B vprobe
.PP
Note - you may want to redirect 
.I stdout
to a file when you run
.I vprobe
(especially if your OS does not support Virtual Terminals on the console).
.PP
However, if you have any 8-bit cards installed, you should initially run
.I vprobe
as:
.sp
.ce
.B vprobe -verbose -no16
.PP
(the
.I -verbose
option is included so you can see what
.I vprobe
is skipping).
.PP
Finer granularity can be obtained with an exclusion list, for example:
.sp
.ce
.B vprobe -verbose -excl 0x200,0x220-0x230,0x250
.PP
which will not test for any device that use port 0x200, ports 0x220 through
0x230, inclusive, or port 0x250.  If you have any 8-bit cards installed,
you should add
.I -mask10
to the list of options.
.PP
To restrict the search to Western Digital, Tseng, and Cirrus chipset,
run
.I vprobe
as follows:
.sp
.ce
.B vprobe -order WD,Tseng,Cirrus
.SH BUGS
.PP
Probably a lot at this point.  Please report any bugs or incorrect
identifications to the author.
.PP
\fBIt is possible that vprobe can lock up your machine.  Be sure to
narrow the search by using the \fI-no16\fB, \fI-excl\fB, and \fI-mask10\fB
options provided to keep vprobe from conflicting with other installed
hardware.\fR
.SH SEE ALSO
.PP
The
.I vgadoc2.zip
documentation package by Finn Thoegersen, available in the MS-DOS archives
of many FTP repositories.
.PP
\fIProgrammer's Guide to the EGA and VGA Cards, 2nd Ed\fP, by Richard
Ferraro.
.SH AUTHOR
David E. Wexelblat <dwex@goblin.org>
.br
with help from David Dawes <dawes@physics.su.oz.au> and the XFree86 
development team.
