/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)proto:desktop/instcmd/kb_remap.h	1.1.1.4"

#define LOC_DIR "/etc/inst/locale/keyboards/"	/*  Locale directory  */
#define FONT_DIR "/etc/inst/locale/keyboards/code_sets/" /*font directory */
#define DK_FILE_NAME "/dead_keys"	/*  Name of dead key config file  */
#define KB_FILE_NAME "/kbmap"		/*  Name of keyboard config file  */

#define DH_MAGIC "dUsD"		/*  Accronym for desktop UNIX system Deadkeys  */
#define KH_MAGIC "dUsK"		/*  Accronym for desktop UNIX system Keyboard  */
#define CS_MAGIC "dUsC"		/*  Accronym for desktop UNIX system Codeset  */
#define CS_VERSION 1		/*  Version of codeset file  */

#define DK_BUF_SIZE 10240	/*  Size of dead key buffer  */
#define DK_COMP_OFFSET 514	/*  Offset to pointer for empty compose table  */
#define DK_SEQ_OFFSET 516	/*  Offset to pointer to sequence table  */
#define DK_S_TBL_OFFSET 518	/*  Offset to pointer to strings table  */
#define DK_S_BUF_OFFSET 520	/*  Offset to pointer to strings buffer  */
#define DK_TBL_OFFSET 522	/*  Offset of deadkey table in mapping buffer  */

#define STR_LEN 256			/*  General string length  */

#define NUM_FONT_CHARS 128	/*  Number of font characters in file  */

#define SUCCESS 0			/*  Everything went okay  */
#define FAILURE 1			/*  Something went wrong  */

#define SPACE ' '
#define NEWLINE '\n'

void fatal(), read_font_map(), insert_num(), read_dk_map(), read_kb_map();
char *file_read();

/**
 *  Structures used for the information stored and retrieved from the
 *  keyboard/font configuration files.
 **/

/**
 *  Header for keyboard file
 **/
typedef struct key_hdr {
	unchar kh_magic[4];		/*  File identifier magic "number"  */
	unchar kh_nkeys;		/*  Number of keys to be remapped  */
} KEY_HDR;

/**
 *  Key remapping information
 **/
typedef struct key_info {
	unchar ki_scan;			/*  The scancode (key) to remap  */
	unchar ki_states;		/*  Changed key states bit map  */
	unchar ki_spcl;			/*  Bit mask for special keys  */
	unchar ki_flgs;			/*  Flag for lock keys  */
} KEY_INFO;

typedef struct dead_hdr {
	unchar dh_magic[4];		/*  File identifier magic "number"  */
	unchar dh_ndead;		/*  Number of dead keys  */
} DK_HDR;

typedef struct dead_key {
	unchar di_key;			/*  The dead key character  */
	unchar di_ncombi;		/*  Number of valid combination keys  */
} DK_INFO;

typedef struct dead_combi {
	unchar dc_orig;			/*  The dead key combination character  */
	unchar dc_result;		/*  The result generated by this combination  */
} DK_COMBI;

typedef struct ega_codeset {
	unchar ec_bitmap[14];	/*  Bit map for an EGA charater representation  */
} ega_codeset_t;

typedef struct vga_codeset {
	unchar vc_bitmap[16];	/*  Bit map for a VGA character representation  */
} vga_codeset_t;

typedef struct code_sets {
	ega_codeset_t cs_ega[NUM_FONT_CHARS];	/*  EGA code set modifications  */
	vga_codeset_t cs_vga[NUM_FONT_CHARS];	/*  VGA code set modifications  */
} code_sets_t;

typedef struct codeset_hdr {
	unchar ch_magic[4];		/*  File identifier 'magic' number  */
	unchar ch_vers;			/*  "Version" of file  */
	code_sets_t ch_cset;	/*  Code set modifications  */
} CS_HDR;
