/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)kern-i386:psm/netframe/nmi.c	1.1"
#ident	"$Header: $"

/*
 * Machine-dependent Non-Maskable Interrupt (NMI) handler.
 */

#include <sys/buf.h>
#include <sys/disp.h>
#include <sys/cmn_err.h>
#include <sys/engine.h>
#include <sys/inline.h>
#include <sys/plocal.h>
#include <sys/types.h>


/*
 * void
 * nmi(...)
 *	Handle an NMI interrupt.
 * 
 * Calling/Exit State:
 *
 *	The arguments are the saved registers which will be restored
 *	on return from this routine.
 */

/* ARGSUSED */
void
nmi(volatile uint edi, volatile uint esi, volatile uint ebp,
    volatile uint unused, volatile uint ebx, volatile uint edx,
    volatile uint ecx, volatile uint eax, volatile uint es, volatile uint ds,
    volatile uint eip, volatile uint cs, volatile uint flags, volatile uint sp,
    volatile uint ss)
{
	extern is_gemstone;

	/* XXX - Have to add support for NMI handlers (nmi_hook). */

	/*
	 *+ A Non-Maskable Interrupt was generated by an unknown source.
	 */
	if (is_gemstone) {
		cmn_err(CE_CONT, "NMI Low(0x1000) = 0x%x\n", inl(0x1000));
		cmn_err(CE_CONT, "NMI High(0x1008) = 0x%x\n", inl(0x1008));
		cmn_err(CE_CONT, "S_Check Low(0x1010) = 0x%x\n", inl(0x1010));
		cmn_err(CE_CONT, "S_Check High(0x1018) = 0x%x\n", inl(0x1018));
		cmn_err(CE_CONT, "P_Check Low(0x1020) = 0x%x\n", inl(0x1020));
		cmn_err(CE_CONT, "P_Check High(0x1028) = 0x%x\n", inl(0x1028));
		cmn_err(CE_CONT, "Status/Control(0x4100) = 0x%x\n",inl(0x4100));
	}
	cmn_err(CE_PANIC, "Unexpected NMI.");
}
