/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)kern-i386:psm/netframe/pic.c	1.3"
#ident	"$Header: $"

#include <sys/bootinfo.h>
#include <sys/eisa.h>
#include <svc/intr.h>
#include <psm/intr_p.h>
#include <sys/nf_pic.h>
#include <sys/systm.h>
#include <sys/cmn_err.h>
#include <sys/inline.h>
#include <sys/ipl.h>
#include <sys/plocal.h>
#include <sys/sysmacros.h>
#include <sys/types.h>

#define	PIC_LTIM	0x08

extern unsigned long level_intr_mask;

/* Programmable Interrupt Controllers */

/* defined in conf.c, which is generated by config: */
extern int (*ivect[])();	/* interrupt routines */
extern uchar_t intpri[];	/* priority levels for interrupts */
extern int nintr;		/* number of interrupts */

/* defined in space.c file: */
extern ushort_t cmdport[];	/* command port addrs for pics */
extern ushort_t imrport[];	/* intr mask port addrs for pics */
extern uchar_t masterpic[];	/* index of this pic's master */
extern uchar_t masterline[];	/* line this pic connected to */
extern uchar_t curmask[];	/* current masks for pics */
extern uchar_t picbuffered;	/* true if pic buffered */
extern int npic;		/* number of pics configured */
extern struct irqtab irqtab[];	/* per-IRQ info */
extern pl_t svcpri[];		/* interrupt service priority levels */

/*
 * iplmask[] contains the pic masks for each interrupt priority level.
 * It is effectively dimensioned iplmask[PLHI + 1][NPIC], and is initialized
 * from intpri[].
 *
 * Since code always runs at PLHI or below, we only need entries in iplmask
 * for PLBASE through PLHI, thus iplmask is dimensioned up to PLHI only.
 */
extern uchar_t iplmask[];

void intnull(void);		/* null interrupt routine */

/*
 * The deferred interrupt stack and stack index.  The size of the deferred
 * interrupt stack is based on the following considerations:
 *
 *  (1)	At most one interrupt per service level can be deferred.  This
 *	is guaranteed because whenever an interrupt occurs, the system
 *	blocks all interrupts at the interrupt's service level, and the
 *	interrupts remain blocked until the service of the interrupt
 *	is completed.
 *
 *  (2)	Only interrupts whose interrupt priority level is at or below PLHI
 *	will be deferred.  This is guaranteed because the system always
 *	runs at PLHI or below, thus interrupts whose level is above PLHI
 *	will never be deferred.
 *
 *  (3)	The implication of (1) & (2) is that the maximum number of interrupts
 *	which will be deferred at any one time is equal to the number of
 *	priority levels from PL1 to PLHI, inclusive.  Since this implementation
 *	uses ordinal numbers to represent priority levels, we can say that the
 *	maximum number of deferred interrupts is PLHI - PL1 + 1, or just PLHI.
 *
 *  (4)	There is always a dummy value at the bottom of the deferred interrupt
 *	stack; see the initialization of picdeferred below.  Thus, the total
 *	size of picdeferred is PLHI + 1: PLHI for the maximum number of
 *	deferred interrupts, plus 1 for the dummy value.
 */
int picdeferred[PLHI + 1];	/* deferred interrupt stack */
int picdeferndx;		/* deferred interrupt stack index */

static int slaves;		/* bitmask of slave lines into master PIC */

extern int picreload(void);

/*
 * void picinit(void)
 *	Initialize the Programmable Interrupt Controller (PIC) chip(s).
 *	The PIC interrupt masks are temporarily programmed to disallow
 *	all interrupts, and the logical level is set to PLBASE.  The
 *	PIC masks will be rewritten with their real values later, in
 *	picstart().
 *
 * Calling/Exit State:
 *	On entry, the IF flag is off, and ipl, picipl, and the PICs
 *	are uninitialized.
 *
 *	On exit, the IF flag is on, ipl and picipl are set to PLBASE,
 *	the PICs have been initialized, the PIC interrupt masks disallow
 *	all interrupts.
 */

void
picinit(void)
{
	int cmd, imr, pic, bit;
	struct irqtab *ip;
	int i;
	unsigned char	icw1_cmd;

	/*
	 * Identify lines on master to which slaves are connected.
	 */
	slaves = 0;
	for (pic = 1; pic < npic; pic++)        /* for each slave */
		slaves |= 1 << masterline[pic];

	/*
	 * Initialize the irqtab, which contains per-vector information.
	 */
	ip = irqtab;
	for (pic = 0; pic < npic; pic++) {	/* loop thru PICs */
		for (bit = 1; bit <= 0x80; bit <<= 1, ip++) {
			ip->irq_cmdport = cmdport[pic];
			ip->irq_flags = 0;
			if (pic != 0)
				ip->irq_flags |= IRQ_ONSLAVE;
			if (bit == PIC_IRQSPUR)
				ip->irq_flags |= IRQ_CHKSPUR;
		}
	}

	/*
	 * Initialize the PIC hardware, starting with the master PIC.
	 */

#ifdef AT380
	/*
	 * AT380 support: Set the vector registers to match the 8259
	 */
	outb(VRB0, PIC_VECTBASE);
	outb(VRB1, PIC_VECTBASE + 1);
	outb(VRB3, PIC_VECTBASE + 3);
	outb(VRB4, PIC_VECTBASE + 4);
	outb(VRB5, PIC_VECTBASE + 5);
	outb(VRB6, PIC_VECTBASE + 6);
	outb(VRB7, PIC_VECTBASE + 7);
#endif
	
	icw1_cmd = PIC_ICW1BASE|PIC_NEEDICW4;

	if (bootinfo.machflags & MC_BUS)
		icw1_cmd |= PIC_LTIM;

	/* ICW1: Edge-level triggered, Cascaded, need ICW4 */
	outb(cmdport[0], icw1_cmd);
	
	/* ICW2: start master vectors at PIC_VECTBASE */
	outb(imrport[0], PIC_VECTBASE);
	
	/* ICW3: define which lines are connected to slaves */
	outb(imrport[0], slaves);

#ifdef AT380
	/*
	 * AT380 support: Use auto-EOI mode.
	 */
	outb(imrport[0], PIC_AUTOEOI|PIC_86MODE);
	inb(cmdport[0]);	/* to avoid a bug in the 380 */
	inb(cmdport[0] + 2);	/* read back ICW2 to reset IRQ1.5 */
#else
	/* ICW4: buffered master (?), norm eoi, mcs 86 */
	outb(imrport[0],
	     picbuffered ? PIC_MASTERBUF|PIC_86MODE : PIC_86MODE);
#endif

	/* OCW1: Start the master with all interrupts off */
	outb(imrport[0], curmask[0] = 0xFF);
	
	/* OCW3: set master into "read isr mode" */
	outb(cmdport[0], PIC_READISR);
	
	/*
	 * Initialize slave PICs
	 */
#ifdef AT380
	/*
	 * AT380 support: Set the vector registers for bank C here. We
	 * know that bank C is the only slave.
	 */
	outb(VRC0, PIC_VECTBASE + 8);
	outb(VRC1, PIC_VECTBASE + 9);
	outb(VRC2, PIC_VECTBASE + 10);
	outb(VRC3, PIC_VECTBASE + 11);
	outb(VRC4, PIC_VECTBASE + 12);
	outb(VRC5, PIC_VECTBASE + 13);
	outb(VRC6, PIC_VECTBASE + 14);
	outb(VRC7, PIC_VECTBASE + 15);
#endif

	for (pic = 1; pic < npic; pic++) {
		cmd = cmdport[pic];
		imr = imrport[pic];

		/* ICW1: edge/level-triggered, Cascaded, need ICW4 */
		outb(cmd, icw1_cmd);

		/* ICW2: set base of vectors */
		outb(imr, PIC_VECTBASE + pic * 8);

		/* ICW3: specify ID for this slave */
		outb(imr, masterline[pic]);

#ifdef AT380
		/*
		 * AT380 support: Use auto-EOI mode.
		 */
		outb(imr, PIC_AUTOEOI|PIC_86MODE);
		inb(cmd);	/* to avoid a bug in the 380 */
		inb(cmd + 2);	/* read back ICW2 to reset IRQ1.5 */
#else
		/* ICW4: buffered slave (?), norm eoi, mcs 86 */
		outb(imr,
		     picbuffered ? PIC_SLAVEBUF|PIC_86MODE : PIC_86MODE);
#endif

		/* OCW1: start the slave with all interrupts off */
		outb(imr, curmask[pic] = 0xFF);

		/* OCW3: set pic into "read isr mode" */
		outb(cmd, PIC_READISR);
	}

#ifdef AT380
	/*
	 * AT380 support: Initialize bank A to make it transparent from
	 * here on.  With auto-EOI mode, we never have to give it an EOI
	 * and it's transparent to the rest of the code.
	 */
	outb(ACMD_PORT, 0x1b);	/* ICW1 */
	outb(AIMR_PORT, 0x02);	/* ICW2 */
	outb(AIMR_PORT, 0x02);	/* ICW4 */
	outb(AIMR_PORT, 0xfb);	/* mask */
	outb(VRA0, 0x02);	/* shouldn't ever get these, so */
	outb(VRA1, 0x02);	/* have them come in as NMI's */
	outb(VRA1_5, 0x02);
	outb(VRA3, 0x02);
	outb(VRA4, 0x02);
	outb(VRA7, 0x02);
	inb(ACMD_PORT);		/* to avoid a bug in the 380 */
	inb(ACMD_PORT + 2);	/* read back ICW2 to reset IRQ1.5 */
#endif

	if (bootinfo.machflags & EISA_IO_BUS) {
		/*
		 * Set Level Mode for those IRQ's requiring it.
		 */
		for (i = 0; i < 16; ++i) {
			if (level_intr_mask & (1 << i))
				eisa_set_elt(i, LEVEL_TRIG);
		}
	}

	/*
	 * initialize ipl and picipl
	 */
	l.ipl = l.picipl = PLBASE;

	/*
	 * Initialize the deferred interrupt stack.  In order to simplify
	 * the testing of the deferred interrupt stack, the stack always
	 * contains a dummy interrupt number as the bottom-most element
	 * of the stack.  This dummy interrumpt number must be distinct
	 * from any valid interrupt (IRQ) number and also must have the
	 * property that its intpri entry is 0.  The value which is used
	 * is one more than the highest possible IRQ number; this is just
	 * npic * PIC_NIRQ.
	 *
	 * Set picdeferndx to 0 to indicate we're at the bottom of the
	 * stack, and set the bottom-most element to npic * PIC_NIRQ;
	 */
	picdeferndx = 0;
	picdeferred[picdeferndx] = npic * PIC_NIRQ;

	/* Initially set all masks to disable all interrupts */
	for (i = (PLHI + 1) * npic; i-- != 0;)
		iplmask[i] = 0xFF;

	asm("sti");	/* ENABLE */
}

/*
 * void picstart(void)
 *	Enable normal interrupt masks and allow device interrupts.
 *
 * Calling/Exit State:
 *	Called from selfinit() during processor initialization.
 *
 * Remarks:
 *	Now we can enable interrupts.  This requires both an ENABLE
 *	to enable interrupts at the processor and an spl0 to set the
 *	priority level to PLBASE.
 */
void
picstart(void)
{
	int intno, bit, pic, level;
#ifdef	NETFRAME
	int  (*tmpvect)();
	int	tmppri;
#endif	/* NETFRAME */

	if (upyet) {
		spl0();
		return;
	}

#ifdef	NETFRAME
	/*
	 * ivect[0] and intpri[0] have been hard coded by idconfig
	 * for clock, which is fine on 386AT.  However,  clock
	 * is on IRQ8 on NetFRAME machines.  Rather than changing
	 * idconfig, let's just switch the entries here temporarily
 	 * for the purpose computing picmasks.
	 * Actual revectoring will be done in the interrupt entry.
	 */ 
	tmpvect = ivect[0];
	tmppri = intpri[0];
	ivect[0] = ivect[8];
	intpri[0] = intpri[8];
	ivect[8] = tmpvect;
	intpri[8] = tmppri;
#endif	/* NETFRAME */

	/*
	 * Initialize PIC-related data structures:
	 *  (1)	Set up iplmask[][] from ivect[] and intpri[].  If an
	 *	interrupt number is configured, set its bit in the masks
	 *	at its priority level and higher.  Otherwise, mask it out
 	 *	for all priority levels, including PLBASE.  (Note that
	 *	interrupts above PLHI are never masked, since the
	 *	system never runs above PLHI, and iplmask only includes
	 *	entries up to and including PLHI, but not beyond it.)
	 *
	 *  (2)	Initialize the svcpri array.  For each hardware interrupt,
	 *	svcpri gives the priority level at which the interrupt service
	 *	routine should run.  The service priority level is the same
	 *	as the interrupt priority level, specified in intpri, unless
	 * 	the interrupt pl is above PLHI; in such cases, the service
	 *	pl is PLHI.  This is part of enforcing the constraint that no
	 *	code runs above PLHI.
	 *
	 * NOTE: master PIC must always be PIC zero.
	 *	 PIC base vector is always PIC_VECTBASE + picno * 8.
	 */

	bzero(iplmask, (PLHI + 1) * npic);
	for (pic = 0; pic < npic; pic++) {	/* loop thru PIC */
		intno = pic * 8;
		for (bit = 1; bit <= 0x80; bit <<= 1, intno++) {
			if (pic == 0 && (bit & slaves)) {
				if (intno < nintr &&
				    ivect[intno] != (int (*)())intnull) {
					/*
					 *+ There is a conflict between the
					 *+ assignment of IRQ lines to slave
					 *+ PICs and the assignment of IRQ
					 *+ lines to devices.  The assignment
					 *+ of the IRQ lines to slave PICs is
					 *+ specified by the masterline array
					 *+ in the space.c file for the pic
					 *+ module, and the assignment of IRQ
					 *+ lines to devices is specified by
					 *+ the sdevice files.  Corrective
					 *+ action: check those files for
					 *+ conflicts, fix the conflicts,
					 *+ rebuild, and reboot.
					 */
					cmn_err(CE_WARN,
						"reserved interrupt vector"
						 " specified; ignored");
				}
			} else {
				if (intno >= nintr ||
				    ivect[intno] == (int (*)())intnull)
					level = 0;
				else if ((level = intpri[intno]) == 0 ||
					 level > PLMAX) {
					/*
					 *+ The intpri array contains an
					 *+ invalid pl value.  Corrective
					 *+ action: ensure that IPLs assigned
					 *+ in sdevice files are less than or
					 *+ equal to PLMAX, then rebuild the
					 *+ kernel and reboot.
					 */
					cmn_err(CE_WARN,
						"bad interrupt priority in "
						 " intpri[]: %d", level);
					level = 0;
				}
				for ( ; level <= PLHI; level++)
					iplmask[level * npic + pic] |= bit;
			}

			svcpri[intno] = MIN(intpri[intno], PLHI);
		}
	}

#ifdef _MPSTATS
	/*
	 * unblock/allow clock interrupts at PLHI to have a free-flowing 
	 * ulbolt counter.
	 */
#ifdef	NETFRAME
        iplmask[PLHI * npic + 1] &= ~0x01;
#else /* NETFRAME */
        iplmask[PLHI * npic] &= ~0x01;
#endif /* NETFRAME */
#endif /* _MPSTATS */

	l.ipl = l.picipl = PLHI;	/* Force the spl0 to change PIC masks */

	spl0();
}


/*
 * void ndisableint(int iv, pl_t level, int engnum, int itype)
 *	Disable interrupts of specified interrupt number.
 *
 * Calling/Exit State:
 *	Called and exit with mod_iv_lock held at PLHI.
 */
/* ARGSUSED */
void
pic_ndisableint(int iv, pl_t level, int engnum, int itype)
{
	uchar_t	mask, lv;
	int	pic, bit; 
	int	i;		/* interrupt priority level */

	/* change pic mask */

	/*
	 * Find the bit no corressponding to irqno that needs to
	 * be unmasked.
	 */
	pic = iv / PIC_NIRQ;
	bit = iv % PIC_NIRQ;

	mask = 1 << bit;

	i = PL0 * npic + pic;

	/*
	 * Mask/Set the interrupt's bit in iplmask[]
	 * for priorities lower than its own.
	 */
	for (lv = PLBASE; lv < (uchar_t)level; lv++) {
		iplmask[i] |= mask;
		i += npic;
	}

	/*
	 * Reload pic masks so that mask modifications take
	 * effect immediately.
	 */
	picreload();
}


/*
 * void nenableint(int iv, pl_t level, int engnum, int intmp, int itype)
 *	Enable interrupts of specified interrupt number.
 *
 * Calling/Exit State:
 *	Called and exit with mod_iv_lock held at PLHI.
 */
/* ARGSUSED */
void
pic_nenableint(int iv, pl_t level, int engnum, int intmp, int itype)
{
	uchar_t	mask, lv;
	int	pic, bit; 
	int	i;		/* interrupt priority level */

	if (bootinfo.machflags & EISA_IO_BUS) {
		if (itype == 4) {
			eisa_set_elt(iv, LEVEL_TRIG);
		} else {
			eisa_set_elt(iv, EDGE_TRIG);
		}
	}

	/* change pic mask */

	/*
	 * Find the bit no corresponding to iv (irqno) that needs to
	 * be unmasked.
	 */
	pic = iv / PIC_NIRQ;
	bit = iv % PIC_NIRQ;

	mask = ~(1 << bit);

	i = PL0 * npic + pic;

	/*
	 * Unmask/Clear the interrupt's bit in iplmask[]
	 * for priorities lower than its own.
	 */
	for (lv = PLBASE; lv < (uchar_t)level; lv++) {
		iplmask[i] &= mask;
		i += npic;
	}

	mask = ~mask;

	/*
	 * Mask/Set the interrupt's bit in iplmask[]
	 * for priorities greater than, or equal to its own.
	 */
	for (; lv <= PLHI; lv++) {
		iplmask[i] |= mask;
		i += npic;
	}

	/*
	 * Reload pic masks so that mask modifications take
	 * effect immediately.
	 */
	picreload();
}


/*
 * void
 * intnull(void)
 *	Null interrupt routine.  Used to fill in empty slots in the
 *	interrupt handler table.
 *
 * Calling/Exit State:
 *	None.
 */
void
intnull(void)
{
}
