/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/


#ident	"@(#)init:i386at/cmd/init/init.c	1.32.10.30"

/*
 *	Copyright (c) 1982, 1986, 1988
 *	The Regents of the University of California
 *	All Rights Reserved.
 *	Portions of this document are derived from
 *	software developed by the University of
 *	California, Berkeley, and its contributors.
 */

/*******************************************************************

		PROPRIETARY NOTICE (Combined)

This source code is unpublished proprietary information
constituting, or derived under license from AT&T's UNIX(r) System V.
In addition, portions of such source code were derived from Berkeley
4.3 BSD under license from the Regents of the University of
California.



		Copyright Notice 

Notice of copyright on this source code product does not indicate 
publication.

	(c) 1986,1987,1988,1989  Sun Microsystems, Inc
	(c) 1983,1984,1985,1986,1987,1988,1989  AT&T.
	          All rights reserved.

 ***************************************************************************
 * Command:	/sbin/init
 *
 * Inheritable Privileges: P_OWNER,P_AUDIT,P_DEV,P_DACWRITE,P_MACREAD,P_MACWRITE
 *       Fixed Privileges: None
 *
 * Notes:	The above privileges are for any process other then 1. If
 *		the pid is 1, init is given allprivs via the pm_init()
 *		routine in the kernel.
 *
 ***************************************************************************/

/*
 * "init" is the general process spawning program.  It reads
 * /etc/inittab for a script.
 *
 * General Note:The has been implemented to run with or without the Trusted
 *		Path driver configured on the system.
 *
 * Routines appear in the source code in the following order:
 *
 *	main()
 *	single()
 *	remv()
 *	spawn()
 *	respawn()
 *	findpslot()
 *	getcmd()
 *	mask()
 *	level()
 *	killproc()
 *	initialize()
 *	init_signals()
 *	siglvl()
 *	alarmclk()
 *	childeath()
 *	powerfail()
 *	getlvl()
 *	switchcon()
 *	efork()
 *	waitproc()
 *	account()
 *	prog_name()
 *	opensyscon()
 *	realcon()
 *	get_ioctl_syscon()
 *	reset_syscon()
 *	reset_modes()
 *	console()
 *	error_time()
 *	timer()
 *	setimer()
 *	zero()
 *	userinit()
 *	bcopy()
 *	fdup()
 *	drop_core()
 *	debug()
 *	C()
 *	sigpoll()
 *	cleanaux()
 *	clearent()
 *	initprivs()
 *	adt_runprog()
 *	v_pgm()
 *	is_macrunning()
 *	is_macinstalled()
 *	initialize_devtab()
 *	verify_devtab()
 *	setup_consdev()
 *	opentpdev()
 *	allocatedev()
 *	firmware()
 *	substitutedev()
 *	update_devtab()
 *	tpswitchcons()
 *	setuptpdev()
 *	getttyname()
 *	set_autopush()
 *
 * In case of bugs, there are four flavors of debug available.
 *
 *	UDEBUG		Will generate a version of "init" that can
 *			be run as a user process.  In this form,
 *			certain signals will cause core dumps and
 *			and a file called "debug" is written in the
 *			directory where "init" was started.  It also
 *			reads the local directory for utmp, inittab
 *			and other administrative files.  It also uses
 *			/dev/sysconx and /dev/systtyx instead of
 *			/dev/syscon and /dev/systty.
 *
 *	DEBUG		Generates an "init" which runs in the usual
 *			way, but generates a file, /etc/debug, with
 *			information about process removal, level
 *			changes, and accounting.
 *
 *	DEBUG1		This symbol adds more debug to what would be
 *			generated by DEBUG or UDEBUG.  It has
 *			detailed information about each process
 *			spawned from inittab.  DEBUG1 by itself is
 *			equivalent to DEBUG and DEBUG1.  It can be
 *			added to UDEBUG to get a user process version.
 *
 *	ACCTDEBUG	Generate debug from the accounting program
 *			only.
 */

/*   "console()" and "write_message()" have been internationalized.
 *  The first argument is the severity.
 *  The string to be output must include at least the message number
 *  and optionally a catalog name.
 *  The string is output using <severity>.
 */

#ifdef	ACCTDEBUG
#define	DEBUGGER
#endif

#ifdef	DEBUG
#ifndef	DEBUGGER
#define	DEBUGGER
#endif
#endif

#ifdef	UDEBUG
#ifndef	DEBUG
#define	DEBUG
#endif
#ifndef	ACCTDEBUG
#define	ACCTDEBUG
#endif
#ifndef	DEBUGGER
#define	DEBUGGER
#endif
#endif

#ifdef	DEBUG1
#ifndef	DEBUG
#define	DEBUG
#endif
#ifndef	ACCTDEBUG
#define	ACCTDEBUG
#endif
#ifndef	DEBUGGER
#define	DEBUGGER
#endif
#endif

#include	<sys/types.h>
#include	<wait.h>
#include	<signal.h>
#include	<priv.h>
#include	<mac.h>
#include	<sys/uadmin.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<string.h>
#include	<utmpx.h>
#include	<errno.h>
#include	<termio.h>
#include	<sys/tty.h>
#include	<sys/stat.h>
#include	<sys/statvfs.h>
#include	<ctype.h>
#include	<fcntl.h>
#include	<sys/time.h>
#include	<sys/resource.h>
#include	<time.h>
#include	<sys/stropts.h>
#include	<sys/param.h>
#include	<audit.h>
#include	<sys/systeminfo.h>
#include	<limits.h>
#include	<sys/termios.h>
#include	<sys/stream.h>
#include	<sys/conf.h>
#include	<sys/sad.h>
#include	<sys/mkdev.h>
#include	<sys/secsys.h>
#include	<sys/tp.h>
#include	<deflt.h>
#include	<sys/uadmin.h>
#include	<sys/sysi86.h>
#include	<pfmt.h>
#include	<locale.h>
#include	<string.h>
#include	<errno.h>
#include	<pwd.h>
#include	<sys/mod.h>

#undef	sleep

#define	fioctl(p, sptr, cmd)	ioctl(fileno(p), sptr, cmd)

#define	TRUE	1
#define	FALSE	0
#define	FAILURE	-1
#define SUCCESS	0
#define	REBOOT	 5


#define	ERRBUFSZ	(256)
#define	COPYBUF(srcbuf, dstbuf, dstbufsz) {\
	size_t	srcbufsz; \
	size_t	dstremainbufsz; \
	size_t	catsz; \
	\
	if ((srcbuf != (char *)NULL) && (dstbuf != (char *)NULL)){ \
		srcbufsz = strlen(srcbuf); \
		dstremainbufsz = strlen(dstbuf) + 1; \
		if (dstremainbufsz < dstbufsz){ \
			dstremainbufsz = dstbufsz - dstremainbufsz; \
			strncpy(dstbuf, srcbuf, ((srcbufsz <= dstremainbufsz) ? srcbufsz : dstremainbufsz)); \
		} \
	} \
}

/*
 * SLEEPTIME	The number of seconds "init" sleeps between wakeups if
 *		nothing else requires this "init" wakeup.
 */
#define	SLEEPTIME	5*60

/*
 * MAXCMDL	The maximum length of a command string in inittab.
 */
#define	MAXCMDL	512

/*
 * EXEC		The length of the prefix string added to all comamnds
 *		found in inittab.
 */
#define	EXEC	(sizeof("exec ") - 1)

/*
 * TWARN	The amount of time between warning signal, SIGTERM,
 *		and the fatal kill signal, SIGKILL.
 */
#define	TWARN	5

/*
 * WARNFREQUENCY The number of consecutive failures to find an empty slot in
 *		 "init's" internal "proc_table" before another message will
 *		 be generated.
 */
#define	WARNFREQUENCY	25

#define	id_eq(x,y)	(( x[0] == y[0] && x[1] == y[1] && x[2] == y[2]\
			    && x[3] == y[3] ) ? TRUE : FALSE)

#ifdef UDEBUG

pid_t SPECIALPID;		/* Any pid can be made special for debugging */

#else

#define	SPECIALPID	1	/* Normally the special pid is process 1 */

#endif

/*
 * Correspondence of signals to init actions.
 */
#define LVLQ		SIGHUP
#define	LVL0		SIGINT
#define	LVL1		SIGQUIT
#define	LVL2		SIGILL
#define	LVL3		SIGTRAP
#define	LVL4		SIGIOT
#define	LVL5		SIGEMT
#define	LVL6		SIGFPE
#define	SINGLE_USER	SIGBUS
#define	LVLa		SIGSEGV
#define	LVLb		SIGSYS
#define	LVLc		SIGPIPE

/* audit: signal sent from kernel to kick off handling program	*/
#define ADT_PROG	SIGUSR1
extern void adt_runprog();

/*
 * Bit Mask for each level.  Used to determine legal levels.
 */
#define	MASK0	01
#define	MASK1	02
#define	MASK2	04
#define	MASK3	010
#define	MASK4	020
#define	MASK5	040
#define	MASK6	0100
#define	MASKSU	0200
#define	MASKa	0400
#define	MASKb	01000
#define	MASKc	02000

#ifndef	NPROC
#define	NPROC	200
#endif

/*
 * Legal action field values.
 */
#define	OFF		0	/* Kill process if on, else ignore */
#define	RESPAWN		1	/* Continuously restart process when it dies */
#define	ONDEMAND	RESPAWN	/* Respawn for a, b, c type processes */
#define	ONCE		2	/* Start process, do not respawn when dead */
#define	WAIT		3	/* Perform once and wait to complete */
#define	BOOT		4	/* Start at boot time only */
#define	BOOTWAIT	5	/* Start at boot time and wait to complete */
#define	POWERFAIL	6	/* Start on powerfail */
#define	POWERWAIT	7	/* Start and wait for complete on powerfail */
#define	INITDEFAULT	8	/* Default level "init" should start at */
#define	SYSINIT		9	/* Actions performed before init speaks */

#define	M_OFF		0001
#define	M_RESPAWN	0002
#define	M_ONDEMAND	M_RESPAWN
#define	M_ONCE		0004
#define	M_WAIT		0010
#define	M_BOOT		0020
#define	M_BOOTWAIT	0040
#define	M_PF		0100
#define	M_PWAIT		0200
#define	M_INITDEFAULT	0400
#define M_SYSINIT	01000

#define	ID	1
#define	LEVELS	2
#define	ACTION	3
#define	COMMAND	4

#define DEFLT_TPATH_FILE  "tpath"
#define TPNAME "TP_DEFAULT"
#define NO_U    "NO"
#define NO_L    "no"

/*
 * Init can be in any of three main states, "normal" mode where it is
 * processing entries for the lines file in a normal fashion, "boot" mode,
 * where it is only interested in the boot actions, and "powerfail" mode,
 * where it is only interested in powerfail related actions. The following
 * masks declare the legal actions for each mode.
 */
#define	NORMAL_MODES	(M_OFF | M_RESPAWN | M_ONCE | M_WAIT)
#define	BOOT_MODES	(M_BOOT | M_BOOTWAIT)
#define	PF_MODES	(M_PF | M_PWAIT)

struct PROC_TABLE {
	char	p_id[4];	/* Four letter unique id of process */
	pid_t	p_pid;		/* Process id */
	short	p_count;	/* How many respawns of this command in */
			 	/*   the current series */
	long	p_time;		/* Start time for a series of respawns */
	short	p_flags;
	short	p_exit;		/* Exit status of a process which died */
};

struct PROC_TABLE	proc_table[NPROC];	/* Table of active processes */
struct PROC_TABLE	dummy;	/* A zero table used when calling account() */
				/*   for non-process type accounting. */

/*
 * Flags for the "p_flags" word of a PROC_TABLE entry:
 *
 *	OCCUPIED	This slot in init's proc table is in use.
 *
 *	LIVING		Process is alive.
 *
 *	NOCLEANUP	efork() is not allowed to cleanup this entry even
 *			if process is dead.
 *
 *	NAMED		This process has a name, i.e. came from inittab.
 *
 *	DEMANDREQUEST	Process started by a "telinit [abc]" command.  Processes
 *			formed this way are respawnable and immune to level
 *			changes as long as their entry exists in inittab.
 *
 *	TOUCHED		Flag used by remv() to determine whether it has looked
 *			at an entry while checking for processes to be killed.
 *
 *	WARNED		Flag used by remv() to mark processes that have been
 *			sent the SIGTERM signal.  If they don't die in 5
 *			seconds, they are sent the SIGKILL signal.
 *
 *	KILLED		Flag used by remv() to mark procs that have been sent
 *			the SIGTERM and SIGKILL signals.
 *
 *	NOCHLDWAKEUP	Flag used by childeath(), which is an indication not to
 *			set wakeup.w_mask.w_childdeath flag.
 */
#define	OCCUPIED	01
#define	LIVING		02
#define	NOCLEANUP	04
#define	NAMED		010
#define	DEMANDREQUEST	020
#define	TOUCHED		040
#define	WARNED		0100
#define	KILLED		0200
#define	NOCHLDWAKEUP	0400

/*
 * Respawn limits for processes that are to be respawned:
 *
 *	SPAWN_INTERVAL	The number of seconds over which "init" will try to
 *			respawn a process SPAWN_LIMIT times before it gets mad.
 *
 *	SPAWN_LIMIT	The number of respawns "init" will attempt in
 *			SPAWN_INTERVAL seconds before it generates an
 *			error message and inhibits further tries for
 *			INHIBIT seconds.
 *
 *	INHIBIT		The number of seconds "init" ignores an entry it had
 *			trouble spawning unless a "telinit Q" is received.
 */

#define	SPAWN_INTERVAL	(1*60)
#define	SPAWN_LIMIT	10
#define	INHIBIT		(5*60)

#define	NULLPROC	((struct PROC_TABLE *)(0))
#define	NO_ROOM		((struct PROC_TABLE *)(FAILURE))

struct CMD_LINE {
	char c_id[4];	/* Four letter unique id of process to be */
			/*   affected by action */
	short c_levels;	/* Mask of legal levels for process */
	short c_action;	/* Mask for type of action required */
	char *c_command; /* Pointer to init command */
};

/*
 * Following are symbols for the types of errors for which "error_time" keeps
 * timing entries.  MAX_E_TYPES is the number of types currently being kept.
 */
#define	FULLTABLE	0
#define	BADLINE		1

#define	MAX_E_TYPES	2

static struct ERRORTIMES {
	long e_time;	/* Time of last message */
	long e_max;	/* Amount of time to wait until next message */
} err_times[MAX_E_TYPES] = {0L, 120L,
			    0L, 120L};

struct	pidrec {
	int	pd_type;	/* Command type */
	pid_t	pd_pid;		/* pid to add or remove */
};

/*
 * pd_type's
 */
#define ADDPID	1
#define REMPID	2

struct	pidlist {
	pid_t	pl_pid;		/* pid to watch for */
	int	pl_dflag;	/* Flag indicating SIGCLD from this pid */
	short	pl_exit;	/* Exit status of proc */
	struct	pidlist	*pl_next; /* Next in list */
} *Plhead, *Plfree;

/*
 * The following structures contain a set of modes for consdevdsf.
 */
#define control(x)	(x&037)

struct termio	dflt_termio = {
	BRKINT|IGNPAR|ISTRIP|IXON|IXANY|ICRNL,
	OPOST|ONLCR|TAB3,
	CS8|CREAD|B9600,
	ISIG|ICANON|ECHO|ECHOK,
	0,
	0177,control('\\'),'#','@',control('D'),0,0,0
};

struct termio	termio, curterm;


union WAKEUP {
	struct WAKEFLAGS {
		unsigned w_usersignal : 1;	/* User sent signal to "init" */
		unsigned w_childdeath : 1;	/* An "init" child died */
		unsigned w_powerhit : 1;	/* OS experienced powerfail */
	}	w_flags;
	int w_mask;
} wakeup;

/*
 * flag definitions for getttyname()
 */
#define	GETTTYNM_ONLYTP		(0x01)

major_t real_consdevmajnum;
minor_t real_consdevminnum;

#define	REAL_CONSDEVMAJNUM	(5)
#define	REAL_CONSDEVMINNUM	(0)

/*
 * Level definitions if MAC is not installed.
 */
#define SYS_PRIVATE_LVL	((level_t)2)
#define SYS_PUBLIC_LVL	((level_t)1)

/*
 * Useful file and device names.
 */
#define DEF_FILE	"/etc/default/init"

char	*CONSOLE	=	"/dev/console";	/* Real system console */
char	*INITPIPE	=	"/etc/.initpipe";
char	*INITPRIVS	=	"/sbin/initprivs";
#define	PDF			gettxt(":1", "Privilege Data File")
/*
 * Trusted Path Device Special Files
 */
char	*TP_CONSDEV_DSF	=	"/dev/tp/cons";
char	*TP_ADMDEV_DSF	=	"/dev/tp/adm";
char	*TP_CTRLCLONE_DSF=	"/dev/tp/ctrl";
char	*TP_DATACLONE_DSF=	"/dev/tp/data";
/*
 * Streams Administrative Device
 */
char	*SAD_ADMDEV_DSF = 	ADMINDEV;	/* See sys/sad.h */
/*
 * When init s|S is entered, need to leave a "cookie" for the real init
 * (pid == 1) to set up a Trusted Path.  "/dev/sysconreal" will be linked
 * to the real/physical tty device linked under a TP device.
 */
char	*SYSCONREAL	=	"/dev/sysconreal";

/*
 * Administrator of the UTMP, UTMPX, WTMP, WTMPX files id 
 */
char	*UWTMPADMIN	=	"adm";

#ifdef UDEBUG

char	*UTMP		=	"utmp";
char	*WTMP		=	"wtmp";
char	*UTMPX		=	"utmpx";
char	*WTMPX		=	"wtmpx";
char	*INITTAB	=	"inittab";
char	*SYSTTY		=	"/dev/systtyx";
char	*SYSCON		=	"/dev/sysconx";
char	*CORE_RECORD	=	"core_record";
char	*DBG_FILE	=	"debug";
char	*IOCTLSYSCON	=	"ioctl.syscon";	/* Last syscon modes */
char    *ENVFILE        =       "/etc/TIMEZONE";

#else


char	*UTMP		=	UTMP_FILE;	/* Snapshot record file */
char	*WTMP		=	WTMP_FILE;	/* Long term record file */
char	*UTMPX		=	UTMPX_FILE;	/* Snapshot record file */
char	*WTMPX		=	WTMPX_FILE;	/* Long term record file */
char	*INITTAB 	=	"/etc/inittab";	/* Script file for "init" */
char	*SYSTTY		=	"/dev/systty";	/* System Console */
char	*SYSCON		=	"/dev/syscon";	/* Virtual System console */
char	*IOCTLSYSCON	=	"/etc/ioctl.syscon";	/* Last syscon modes */
char	*ENVFILE	=	"/etc/TIMEZONE";

#ifdef	DEBUGGER
char	*DBG_FILE	=	"/etc/debug";
#endif

#endif /* UDEBUG */

char	*SYSMSG		=	"/dev/sysmsg";
char	*TTY00		=	"/dev/tty00";
char	*INIT386	=	"/etc/conf/init.d/kernel"; /* Back up inittab */
char	*ALTINITTAB	=	(char *)NULL;	/* Indicates an alternate
						 * (backup) inittab is defined.
						 * Set to the Back up inittab
						 * if defined, INIT386.
						 * ALTINITTAB should eventually
						 * by set via a sysinfo() call
						 * similar to how SOFTINITTAB
						 * is obtained and INIT386
						 * should be removed.
						 */

char	*SU	=	"/etc/sulogin";	/* Super-user program for single user */
char	*SH	=	"/sbin/sh";	/* Standard shell */
char	SOFTINITTAB[PATH_MAX];



/*
 * Index tags for init's required Device Special Files defined in devtab
 */
#define	DTTAG_SYSTTY		(0)
#define	DTTAG_TP_CONSDEV	(1)
#define	DTTAG_CONSOLE		(2)
#define	DTTAG_SYSCON		(3)
#define DTTAG_SYSCONREAL	(4)
#define DTTAG_TP_ADMDEV		(5)
#define	DTTAG_TP_CTRLCLONE	(6)
#define	DTTAG_TP_DATACLONE	(7)
#define	DTTAG_SAD_ADMDEV	(8)

/*
 * Required Device Special Files for init
 * NOTE: Do not change order of entries with making cooresponding changes
 * to DTTAG_**** defines
 */
enum devtabstatus {
	dtsUNVERIFIED,	/* initial status of devtab entry. */
	dtsVERIFIED,	/* state of devtab entry if verified to exist. */
	dtsIGNORE,	/* indicates to ingore devtab entry */
	dtsENOENT,	/* state of devtab entry if DSF does not exist. */
	dtsWRONGDEV	/* state of devtab entry if DSF Major and or Minor
			 * device number does not match major and or minor
			 * device number in devtab entry.
			 */
};
enum devtabaction{
	dtaNOACTION,	/* indicates no action is to be performed on/for
			 * devtab entry.
			 */
	dtaMKNOD,	/* indicates that a DSF needs to be created for the
			 * devtab entry.  associated with dtsENOENT and
			 * dtsWRONGDEV statuses.
			 */
	dtaLINK		/* indicates that DSF needs to be linked to DSF
			 * specified in dt_linkdsfname field in devtab entry.
			 * associated with dtsENOENT and dtsWRONGDEV statuses.
			 */
};
struct devicetable {
	char			*dt_dsfname;
	char			*dt_linkdsfname;/* if action is dtaLINK,
						 * indicates the dsf name
						 * dt_dfsname will link to.
						 */
	major_t			dt_major;
	minor_t			dt_minor;
	enum devtabstatus	dt_status;
	enum devtabaction	dt_action;
	short			dt_tag;		/* tag to identify devtab entry.
						 * also indicates index of
						 * devtab entry.
						 */
};
struct devicetable	devtab[] = {
	(char *)NULL, (char *)NULL, (major_t)NODEV, (minor_t)NODEV,
		dtsUNVERIFIED, dtaNOACTION, DTTAG_SYSTTY,
	(char *)NULL, (char *)NULL, (major_t)NODEV, (minor_t)TP_CONSDEV,
		dtsUNVERIFIED, dtaNOACTION, DTTAG_TP_CONSDEV,
	(char *)NULL, (char *)NULL, (major_t)NODEV, (minor_t)NODEV,
		dtsUNVERIFIED, dtaNOACTION, DTTAG_CONSOLE,
	(char *)NULL, (char *)NULL, (major_t)NODEV, (minor_t)NODEV,
		dtsUNVERIFIED, dtaNOACTION, DTTAG_SYSCON,
	(char *)NULL, (char *)NULL, (major_t)NODEV, (minor_t)NODEV,
		dtsUNVERIFIED, dtaNOACTION, DTTAG_SYSCONREAL,
	(char *)NULL, (char *)NULL, (major_t)NODEV, (minor_t)TP_ADMDEV,
		dtsUNVERIFIED, dtaNOACTION, DTTAG_TP_ADMDEV,
	(char *)NULL, (char *)NULL, (major_t)NODEV, (minor_t)TP_CTRLCLONE,
		dtsUNVERIFIED, dtaNOACTION, DTTAG_TP_CTRLCLONE,
	(char *)NULL, (char *)NULL, (major_t)NODEV, (minor_t)TP_DATACLONE,
		dtsUNVERIFIED, dtaNOACTION, DTTAG_TP_DATACLONE,
	(char *)NULL, (char *)NULL, (major_t)NODEV, (minor_t)ADMMIN,
		dtsUNVERIFIED, dtaNOACTION, DTTAG_SAD_ADMDEV,
	"", (char *)NULL, (major_t)NODEV, (minor_t)NODEV,
		dtsUNVERIFIED, dtaNOACTION, -1
};

int	n_prev[NSIG];	/* Number of times previously in state */
int	cur_state = -1;	/* Current state of "init" */
int	prior_state;
int	prev_state;	/* State "init" was in last time it woke */
int	new_state;	/* State user wants "init" to go to. */
int	op_modes = BOOT_MODES; /* Current state of "init" */
int	Gchild = 0;	/* Flag to indicate "godchild" died, set in */
			/*   childeath() and cleared in cleanaux() */
int	Pfd = -1;	/* fd to receive pids thru */
unsigned int	spawncnt, pausecnt;
int	rsflag;		/* Set if a respawn has taken place */
pid_t	own_pid;	/* This is the value of our own pid.  If the value */
			/*   is SPECIALPID, then we have to fork to interact */
			/*   with the outside world. */
int	time_up;	/* Flag set to TRUE by alarm interupt routine */
		 	/*   each time an alarm interupt takes place. */
int	fd_systty;

#ifdef	DEBUG
char	comment[120];
#endif

char *regfile = "/etc/mod_register";
#define SYNTAX        "%d:%d:%[^:]:%s"
#define ENTLEN 128

/*
 * Array for default global environment.
 */
#define MAXENVENT	6	/* Max number of default env variables + 1 */
char	*glob_envp[MAXENVENT];	/* Array of environment strings */


int		macinstalled;		/* indicates whether or not MAC is
					 * installed. 0 mean no, non-zero
					 * means yes
					 */
int		macrunning;		/* indicates whether or not MAC is
					 * running. 0 mean no, non-zero
					 * means yes
					 */
static char	*consdevdsf =
		(char *)NULL;		/* indicates where console message
					 * output is to be displayed.
					 */
static char	*substitutedsf =
		(char *)NULL;		/* indicates whether or not the device
					 * name on /etc/inittab command line
					 * sysinit entries should be
					 * substituted.  NULL means no.
					 */
static major_t	tpmajornum =
		(major_t)NODEV;		/* indicates whether or not TP is
					 * configured into the system.
					 */
static int	tperrno;		/* to hold errnos from TP library
					 * function calls
					 */
static int	tperrormsg[256];	/* to hold error messages from TP
					 * library function calls
					 */
static struct termios nulltermios;	/* for TP library functions */
					/* an undefined SAK for TP library
					 * functions
					 */
static struct sak undefsak = {
	saktypeUNDEF,
	(ulong)0,
	(enum saklinecond)0,
	(enum saksecondary)0
};
					/* a SAK defined as NONE for TP
					 * library
					 */
static struct sak nonesak = {
	saktypeNONE,
	(ulong)0,
	(enum saklinecond)0,
	(enum saksecondary)0
};

/* 2 states that indicates the disposition of Trusted Path on the system
 * console device:
 * FALSE:indicates that no TP exists on the console device (the initial state).
 *	indicates that the attempt to setup a TP on the system console
 *	device failed.
 * TRUE:indicates that a TP exists for the defined system console device
 *	consdevdsf (as far as init knows.)
 */
static int	tponconsole = FALSE;

/*
 * Indicates whether or not the root file system has been verified to be
 * sane.
 */
static int	rootfs_verified = FALSE;


char	level();
char	*prog_name(), *getttyname();
int	error_time(), getcmd(), getlvl(), initialize(), mask(), realcon();
int	spawn(), is_macrunning(), is_macinstalled();
int	opentpdev(), setup_consdev(), allocatedev(), substitutedev();
int	update_devtab(), tpswitchcons(), setuptpdev(), set_autopush();
void	account(), alarmclk(), bcopy(), childeath(), cleanaux(), clearent();
void	console(), get_ioctl_syscon(), init_signals(), killproc();
void	opensyscon(), powerfail(), remv(), reset_syscon(), respawn();
void	reset_modes(), setimer(), siglvl(), sigpoll(), single();
void	switchcon(), timer(), userinit(), zero();
void	initialize_devtab(), verify_devtab(), firmware();
long	waitproc();
FILE	*fdup();
struct PROC_TABLE	*efork(), *findpslot();


#ifdef UDEBUG
void	drop_core();
#endif

#ifdef DEBUGGER
char	*C();
void	debug();
#endif

static	arec_t	arec;		/* auditdmp(2) structure */
static	char 	istate[30];	/* init state for audit record */

/*
 * External Declarartions
 */
extern int	tp_devopen();
extern int	tp_consconnect();
extern int	tp_fconsconnect();
extern int	tp_consdisconnect();
extern int	tp_fconsdisconnect();
extern int	tp_dataconnect();
extern int	tp_datadisconnect();
extern int	tp_consset();
extern int	tp_getinf();
extern int	tp_fgetinf();
extern int	tp_makedevice();
extern int	tp_chanopen();
extern void	tp_geterror();
extern char	*sttyname();


/*
 * Procedure:     main
 *
 * Restrictions:
                 unlink(2): None
                 mknod(2): None
                 open(2): None
                 ioctl(2): None
                 fopen: None
                 fclose: None
                 lvlin: None
                 lvlfile(2): None
                 fcntl(2): None
                 auditdmp(2): None
*/


main(argc,argv)
int argc;
char **argv;
{
	int	defaultlevel;
	int	utmpflag = 0;
	int	chg_lvl_flag;
	FILE	*fp, *fp2;
	level_t	lvl;
	int	consfd = -1;
	int	tmpfd;

	/* Administrator of the UTMP, UTMPX, WTMP, WTMPX files passwd entry */
	struct	passwd *uwtmpadminpwentp = (struct passwd *)NULL;
	uid_t	uwtmpadminuid = -1;
	gid_t	uwtmpadmingid = -1;

	struct	tp_info	tpinf;
	extern int errno;

	(void)setcat("uxinit");
	(void)setlabel("UX:init");

#ifdef DEBUG
debug("%d:main():ENTER\n",getpid());
#endif

#ifdef	UDEBUG
	if (argc == 1)
		SPECIALPID = getpid();
#endif

	/*
 	 * Determine if we are process 1, the main init, or a user
 	 * invoked init, whose job it is to inform init to change
 	 * levels or perform some other action.
	 */
	if ((own_pid = getpid()) != SPECIALPID) {
		(void)setlocale(LC_ALL,"");
		userinit(argc, argv);
		/* NOTREACHED */
	}

	setpanic();

	/*
	 * Set up the initial states and see if there is a default
	 * level supplied in the inittab file.
	 */
	defaultlevel = initialize(argc, argv);
	chg_lvl_flag = FALSE;

#ifdef	DEBUG
	console("Debug version of init starting-pid = %ld\n", SPECIALPID);
#endif

	/*
	 * Set up pipe for "godchildren".
	 */
	(void)unlink(INITPIPE);
	(void)mknod(INITPIPE, S_IFIFO | 0600, 0);
	Pfd = open(INITPIPE, O_RDWR | O_NDELAY);
	if (Pfd >= 0) {
		(void)ioctl(Pfd, I_SETSIG, S_INPUT);
		/*
		 * Read pipe in message discard mode.
		 */
		(void)ioctl(Pfd, I_SRDOPT, RMSGD);
		sigset(SIGPOLL, sigpoll);
	}
	/*
	 * Set level of INITPIPE.
	 */
	if (macrunning){
		(void)lvlproc(MAC_GET, &lvl);
	}else{
		/*
		 * 1 is equivalent to level SYS_PRIVATE.
		 */
		lvl == (level_t)1;
	}
	(void)lvlfile(INITPIPE, MAC_SET, &lvl);

	/*
	 * Get administrator of the UTMP, UTMPX, WTMP, WTMPX files 
	 * password entry.  If these files are created, need to change
	 * the owner and group of the files to that of the administrator.
	 */
	if ((uwtmpadminpwentp = getpwnam(UWTMPADMIN)) != (struct passwd *)NULL){
		uwtmpadminuid = uwtmpadminpwentp->pw_uid;
		uwtmpadmingid = uwtmpadminpwentp->pw_gid;
	}

	/*
	 * Initialize the "utmp" and "utmpx" files.  Set the umask so
	 * that the utmp  and utmpx files are created 664.
	 * If "utmp" can't be opened we default to single user mode.
	 */
	umask(002);
	if ((fp = fopen(UTMP,"w+")) == NULL ||
	    (fp2 = fopen(UTMPX, "w+")) == NULL) {
		console(MM_ERROR,
		    ":2:Cannot create %s or %s\n", UTMP, UTMPX);	
		cur_state = SINGLE_USER;
		defaultlevel = -1;
	} else {
		utmpflag = 1;
		fclose(fp);
		fclose(fp2);
		if (uwtmpadminuid != -1){
			(void)chown(UTMP, uwtmpadminuid, uwtmpadmingid);
			(void)chown(UTMPX, uwtmpadminuid, uwtmpadmingid);
		}
		(void)chmod(UTMP,0664);
		(void)chmod(UTMPX,0664);
		/* Check to see if MAC is installed */
		if (lvlproc(MAC_GET, &lvl) == 0) {
			/* change the MAC level of utmp & utmpx to SYS_PUBLIC */
                	lvlin ("SYS_PUBLIC", &lvl);
                	lvlfile (UTMP, MAC_SET, &lvl);
                	lvlfile (UTMPX, MAC_SET, &lvl);
		}
	}

	if ((fp = fopen(WTMP,"a+")) != NULL) {
		fclose (fp);
		if (uwtmpadminuid != -1){
			(void)chown(WTMP, uwtmpadminuid, uwtmpadmingid);
		}
		(void)chmod(WTMP,0664);
	}
	if ((fp = fopen(WTMPX,"a+")) != NULL) {
		fclose (fp);
		if (uwtmpadminuid != -1){
			(void)chown(WTMPX, uwtmpadminuid, uwtmpadmingid);
		}
		(void)chmod(WTMPX,0664);
	}

	umask(0);	/* Allow later files to be created normally. */

	/*
	 * If there is no default level supplied, ask the user to supply one.
	 */
	if (defaultlevel == 0) {
		if ((tpmajornum != (major_t)NODEV) &&
		 (tponconsole == TRUE)){
			consfd = open(consdevdsf, O_RDWR|O_NONBLOCK|O_NOCTTY);
			tmpfd = consfd;
			consfd = fcntl(consfd, F_DUPFD, 3);
			(void)close(tmpfd);
			(void)tp_fconsconnect(consfd, &tpinf);
		}
		new_state = getlvl();
		if ((tpmajornum != (major_t)NODEV)){
			(void)tp_fconsdisconnect(consfd, &tpinf);
			(void)close(consfd);
			consfd = -1;
		}
	} else if (defaultlevel == -1) {
		new_state = SINGLE_USER;
		defaultlevel = 0;
	} else {
		new_state = defaultlevel;
	}
	if (new_state == SINGLE_USER) {
		account(BOOT_TIME, &dummy, NULL); /* Put Boot Entry in "utmpx" */
		account(RUN_LVL, &dummy, "S"); /* Make the run level entry */
		single(defaultlevel);
		while (utmpflag == 0) {
			/*
			 * We went to single user because we couldn't get at
			 * "utmpx" earlier. Since we have returned from single()
			 * we should be able to get there now.  Truncate the 
			 * file now.  The boot time we will write may be off
			 * since we may have been up for a while but this is the
			 * best we can do under the circumstances.  If we still
			 * can't get at "utmpx" we keep going back to single
			 * user until we can.
			 */
			umask(002);
			if ((fp = fopen(UTMP,"w+")) == NULL ||
			    (fp2 = fopen(UTMPX, "w+")) == NULL) {
				console(MM_ERROR,
				    ":2:Cannot create %s or %s\n",UTMP,UTMPX);
				new_state = cur_state = SINGLE_USER;
				umask(0);
				single(0);
			} else {
				utmpflag = 1;
				fclose(fp);
				fclose(fp2);
				if (uwtmpadminuid != -1){
					(void)chown(UTMP, uwtmpadminuid,
					 uwtmpadmingid);
					(void)chown(UTMPX, uwtmpadminuid,
					 uwtmpadmingid);
				}
				(void)chmod(UTMP,0664);
				(void)chmod(UTMPX,0664);
				/* Check to see if MAC is installed */
				if (lvlproc(MAC_GET, &lvl) == 0) {
					/*
					 * change the MAC level of 
					 * utmp & utmpx to SYS_PUBLIC
					 */
                			lvlin ("SYS_PUBLIC", &lvl);
                			lvlfile (UTMP, MAC_SET, &lvl);
                			lvlfile (UTMPX, MAC_SET, &lvl);
				}
				umask(0);
				account(BOOT_TIME, &dummy, NULL);
			}
		}
		chg_lvl_flag = TRUE;
	} else {
		prev_state = cur_state;
		if(cur_state >= 0) {
			n_prev[cur_state]++;
			prior_state = cur_state;
		}
		cur_state = new_state;
		account(BOOT_TIME, &dummy, NULL); /* Put Boot Entry in "utmp" */
		account(RUN_LVL, &dummy, NULL);	/* Make the run level entry */
	}

	/*
	 * Any executions of init from a :sysinit: entry from /etc/inittab
	 * are effectively ignored since new_state is not taken from siglvl()
	 *	-prior to entering the main process loop,
	 *	 new_state is obtained from either the :initdefault: entry
	 *	 in /etc/inittab or is prompted for it just above.
	 * Therefore any global side effects set in siglvl() should be ignored.
	 * This includes the setting of w_usersignal flag.
	 */ 
	wakeup.w_flags.w_usersignal = 0;

	/*
	 * Here is the beginning of the main process loop.
	 */
	for (;;) {

		/*
		 * Clean up any accounting records for dead "godchildren".
		 */
		if (Gchild)
			cleanaux();

		/*
		 * If in "normal" mode, check all living processes and initiate
		 * kill sequence on those that should not be there anymore.
		 */
		if (op_modes == NORMAL_MODES && cur_state != LVLa &&
		    cur_state != LVLb && cur_state != LVLc)
			remv();

		/*
		 * If a change in run levels is the reason we awoke, now do
		 * the accounting to report the change in the utmp file.
		 * Also report the change on the system console.
		 */
		if (chg_lvl_flag) {
			chg_lvl_flag = FALSE;
			account(RUN_LVL, &dummy, NULL);
			console(MM_INFO,
			    ":3:New run level: %c\n", level(cur_state));
		}

		/*
		 * Scan the inittab file and spawn and respawn processes that
		 * should be alive in the current state. If inittab does not
		 * exist default to  single user mode.
		 */
		if (spawn() == FAILURE) {
			prior_state = prev_state;
			cur_state = SINGLE_USER;
		}

		if (rsflag) {
			rsflag = 0;
			spawncnt++;
		}

		if (cur_state == SINGLE_USER) {
			account(RUN_LVL, &dummy, NULL);
			single(0);
			if (cur_state != prev_state &&
			    cur_state != LVLa && cur_state != LVLb &&
			    cur_state != LVLc) {
				chg_lvl_flag = TRUE;
				continue;
			}
		}

		/*
		 * If a powerfail signal was received during the last
		 * sequence, set mode to powerfail.  When spawn() is entered
		 * the first thing it does is to check "powerhit".  If it is
		 * in PF_MODES then it clears "powerhit" and does a powerfail
		 * sequence.  If it is not in PF_MODES, then it puts itself
		 * in PF_MODES and then clears "powerhit".  Should "powerhit"
		 * get set again while spawn() is working on a powerfail
		 * sequence, the following code  will see that spawn() tries to
		 * execute the powerfail sequence again.  This guarantees that
		 * the powerfail sequence will be successfully completed before
		 * further processing takes place.
		 */
		if (wakeup.w_flags.w_powerhit) {
			op_modes = PF_MODES;
			/*
			 * Make sure that cur_state != prev_state so that
			 * ONCE and WAIT types work.
			 */
			prev_state = 0;
		} else if (op_modes != NORMAL_MODES) {
			/*
			 * If spawn() was not just called while in normal mode,
			 * we set the mode to normal and it will be called again
			 * to check normal modes.  If we have just finished
			 * a powerfail sequence with prev_state equal to zero,
			 * we set prev_state equal to cur_state before the next
			 * pass through.
			 */
			if (op_modes == PF_MODES)
				prev_state = cur_state;
			op_modes = NORMAL_MODES;
		} else if (cur_state == LVLa || cur_state == LVLb ||
		    cur_state == LVLc) {
			/*
			 * If it was a change of levels that awakened us and the
			 * new level is one of the demand levels then reset
			 * cur_state to the previous state and do another scan
			 * to take care of the usual respawn actions.
			 */
			n_prev[cur_state]++;
			cur_state = prior_state;
			prior_state = prev_state;
			prev_state = cur_state;
			account(RUN_LVL, &dummy, NULL);
		} else {
			prev_state = cur_state;

			if (wakeup.w_mask == 0) {
				/*
				 * "init" is finished with all actions for
				 * the current wakeup.
				 */
				setimer(SLEEPTIME);
				pause();
				pausecnt++;
			}

			setimer(0);

			if (wakeup.w_flags.w_usersignal) {
				/*
				 * Install the new level.  This could be a real
				 * change in levels  or a telinit [Q|a|b|c] or
				 * just a telinit to the same level at which
				 * we are running.
				 */
#ifdef	DEBUG
				debug("\nmain\tSignal-new:%c cur:%c prev:%c\n",
				    level(new_state), level(cur_state),
				    level(prev_state));
#endif

		/* Dump an audit record indicating change of init states by P1 */
				sprintf(istate,"current_state: %c new_state: %c",
					level(cur_state),
					level(new_state));
			        arec.rtype = ADT_INIT;
			        arec.rstatus = 0;
			        arec.rsize = strlen(istate);
			        arec.argp = istate;
			        auditdmp(&arec, sizeof(arec_t));

				if (new_state != cur_state) {
					if (new_state == LVLa ||
					    new_state == LVLb ||
					    new_state == LVLc) {
						prev_state = prior_state;
						prior_state = cur_state;
						cur_state = new_state;
						account(RUN_LVL, &dummy, NULL);
					} else {
						prev_state = cur_state;
						if(cur_state >= 0) {
							n_prev[cur_state]++;
							prior_state = cur_state;
						}
						cur_state = new_state;
						chg_lvl_flag = TRUE;
					}
				}

				if (new_state == SINGLE_USER)
					reset_modes();
				new_state = 0;
			}

			if (wakeup.w_flags.w_powerhit)
				op_modes = PF_MODES;

			/*
			 * Clear all wakeup reasons.
			 */
			wakeup.w_mask = 0;
		}
	}
}


/*
 * Procedure:     single
 *
 * Restrictions:
                 kill(2): None
                 open(2): None
                 fcntl(2): None
                 auditdmp(2): None
                 access(2): None
*/
void
single(defaultlevel)
int defaultlevel;
{
	register struct PROC_TABLE	*su_process;
	register struct pidlist		*p;
	int				state;
	struct devstat			consdevstat;
	struct tp_info			tpinf;
	char				datadsfname[PATH_MAX] = {'\0'};
					/* This flag is only used if TP is
					 * configured on the system.
					 */
	char				*saveconsdevdsf = (char *)NULL;
	int				remainsingle = FALSE;
	int				ctrlfd = -1;
	int				datafd = -1;
	int				consfd = -1;
	int				tmpfd;
#ifdef DEBUG
debug("%d:single():ENTER\n",getpid());
#endif

	/*
	 * Go through the godchild list and send SIGTERM, then wait for
	 * TWARN seconds and send SIGKILL to anything that is left.
	 * Also wait a little bit before doing this so SIGCLDs hopefully
	 * go to the right process.
	 */
	timer(3);
	for (p = Plhead; p; p = p->pl_next)
		kill(p->pl_pid, SIGTERM);
	timer(TWARN);
	cleanaux();	/* Clean up utmp entries. */

	/*
	 * Any left?
	 */
	if (Plhead) {
		for (p = Plhead; p; p = p->pl_next)
			kill(p->pl_pid, SIGKILL);
		timer(3);	/* Give them a little time to die. */
		cleanaux();	/* Clean up utmp entries. */
	}

	for (;;) {
		console(MM_INFO, ":4:SINGLE USER MODE\n");
		sighold(SIGCLD);
		saveconsdevdsf = (char *)NULL;
		datadsfname[0] = '\0';
		/*
		 * If TP is configure on system, setup a TP in a "trusted state"
		 * if TP is on the console device
		 */
		if ((tpmajornum != (major_t)NODEV) && (tponconsole == TRUE)){
			if (setuptpdev(&ctrlfd, &datafd, datadsfname) ==
			 SUCCESS){
				/*
				 * Temporarily set the console device DSF name
				 * (consdevdsf) to DATA channel DSF name since
				 * we are going to interract on that device.
				 * It will be reset via setup_consdev()
				 * after the child exits or before this
				 * function returns.
				 */
				saveconsdevdsf = consdevdsf;
				consdevdsf = datadsfname;
#ifdef DEBUG
debug("%d:single(): setuptpdev() SUCCESSFULL\n\tsaveconsdevdsf= %s\n\tconsdevdsf= %s\n\tdatadsfname= %s\n",
 getpid(), saveconsdevdsf, consdevdsf, datadsfname);
#endif
			}else{
#ifdef DEBUG
debug("%d:single(): setuptpdev() FAILED\n", getpid());
#endif
				/*
				 * Next best thing is to connect CONS channel
				 * for input if TP is on the console, otherwise
				 * set the console device DSF name to SYSTTY.
				 */
				if (tponconsole == TRUE){
#ifdef DEBUG
debug("%d:single():Connecting Cons Channel  consdevdsf \"%s\" for input\n",
 getpid(), consdevdsf);
#endif
					/*
					 * Holding CONS open during duration of
					 * child process or until init state
					 * changes.  This is to prevent CONS
					 * channel from automatically being
					 * disconnected if all open references
					 * are closed in the child process.
					 */
					(void)allocatedev(consdevdsf,
					 DEV_PRIVATE, DEV_LASTCLOSE);
					consfd = open(consdevdsf,
					 O_RDWR|O_NONBLOCK|O_NOCTTY);
					tmpfd = consfd;
					consfd = fcntl(consfd, F_DUPFD, 3);
					(void)fcntl(consfd, F_SETFD, 1);
					(void)close(tmpfd);
					(void)tp_consconnect(&tpinf);
				}else{
					consdevdsf = SYSTTY;
				}
			}
		}
		while((su_process = efork(M_OFF,NULLPROC,NOCLEANUP)) == NO_ROOM)
			pause();
		sigrelse(SIGCLD);
		if (su_process == NULLPROC) {
#ifdef DEBUG
debug("%d:single():CHILD PROCESS  consdevdsf = %s\n",getpid(), consdevdsf);
#endif
			opensyscon();

			/*
			 * This case pertains only if TP is configured on the
			 * system.
			 * If for some "strange" reason inits concept of the
			 * current system console device (shoud be the Device
			 * Special File name of the data channel) was changed
			 * back to the default system console device, allocate
			 * and connect the cons channel for input.  This is
			 * necessary since the cons channel has now been set to
			 * the stdin, stdout, and stderr for this child process.
			 */
			if ((tpmajornum != (major_t)NODEV) &&
			 (tponconsole == TRUE)){ 
				if ((datadsfname[0] != '\0') &&
				 (strcmp(datadsfname, consdevdsf) != 0)){
#ifdef DEBUG
debug("%d:single():CHILD PROCESS  opensyscon() changed consdevdsf to \"%s\"\n\tConnecting it (cons channel) for input",
getpid(), consdevdsf);
#endif
					(void)allocatedev(consdevdsf,
					 DEV_PRIVATE, DEV_LASTCLOSE);
					consfd =
				 	open(consdevdsf,
					 O_RDWR|O_NONBLOCK|O_NOCTTY);
					(void)fcntl(consfd, F_SETFD, 1);
					(void)tp_fconsconnect(consfd, &tpinf);
				}
			}

			/*
			 * Execute the "su" program.
			 */
			execle(SU, SU, "-", (char *)0, glob_envp);
			console(MM_ERROR,
			    ":5:execle of %s failed; errno = %d\n", SU, errno);
			timer(5);
			(void)tp_fconsdisconnect(consfd, &tpinf);
			(void)close(consfd);
			exit(1);
		}

		/*
		 * If we are the parent, wait around for the child to die
		 * or for "init" to be signaled to change levels.
		 */
		while (waitproc(su_process) == FAILURE) {

			/*
			 * Did we waken because a change of levels?
			 * If so, kill the child and then exit.
			 */
			if (wakeup.w_flags.w_usersignal) {
#ifdef DEBUG
debug("%d:single():waitproc() returned (CASE: NOT BY MY CHILD):A CHILD INIT SENT A SIGNAL\n",getpid());
#endif
		/* Dump an audit record indicating change of init states by P1 */
				sprintf(istate,"current_state: %c new_state: %c",
					level(cur_state),
					level(new_state));
			        arec.rtype = ADT_INIT;
			        arec.rstatus = 0;
			        arec.rsize = strlen(istate);
			        arec.argp = istate;
			        auditdmp(&arec, sizeof(arec_t));

				if (new_state >= LVL0 && new_state <= LVL6) {
					/*
					 * Check to make sure UTMPX is
					 * accessible.  If not, remain in
					 * single user mode.
					 */
					if (access(UTMPX, F_OK) == -1) {
						console(MM_ERROR,
						    ":6:Cannot access %s, remaining in single user mode.\n", UTMPX);
					} else {
						if (tpmajornum != (major_t)NODEV){
							if (tponconsole == FALSE){
								verify_devtab();
								update_devtab();
								(void)setup_consdev((char *)NULL, (size_t)0);
							}else{
								if ((saveconsdevdsf != (char *)NULL) &&
								 (strcmp(datadsfname, consdevdsf) == 0)){
									consdevdsf = saveconsdevdsf;
								}
							}
							if (tponconsole == TRUE){
								kill(su_process->p_pid,SIGKILL);
								prev_state = cur_state;
								if(cur_state >= 0) {
									n_prev[cur_state]++;
									prior_state = cur_state;
								}
								cur_state = new_state;
								new_state = 0;
								wakeup.w_mask = 0;
								su_process->p_flags&=~NOCLEANUP;
								/*
								 * Close down the TP
								 * CTRL and DATA
								 * channel.  Disconnect
								 * CONS channel for
								 * input.
								 */
								tpinf.tpinf_dconnid = 0;
								(void)tp_datadisconnect(ctrlfd, &tpinf);
								(void)close(datafd);
								(void)close(ctrlfd);
								(void)tp_fconsdisconnect(consfd,&tpinf);
								(void)close(consfd);
								datafd = ctrlfd = consfd = -1;
#ifdef DEBUG
debug("%d:single():waitproc() returned (CASE: NOT BY MY CHILD):RETURN %s\n",getpid(), istate);
#endif
								return;
							}else{
								console(MM_INFO,
								    ":7:No TP on console remaining in SINGLE USER\n");
							}
						}else{
							kill(su_process->p_pid,SIGKILL);
							prev_state = cur_state;
							if(cur_state >= 0) {
								n_prev[cur_state]++;
								prior_state = cur_state;
							}
							cur_state = new_state;
							new_state = 0;
							wakeup.w_mask = 0;
							su_process->p_flags&=~NOCLEANUP;
							return;
						}
					}
				}

			}
			/*
			 * All other reasons for waking are ignored when in 
			 * single-user mode.  The only child we are interested
			 * in is being waited for explicitly by waitproc().
			 */
			wakeup.w_mask = 0;
		}
#ifdef DEBUG
debug("%d:single():waitproc() returned (CASE: MY CHILD )\n",getpid());
#endif

		/*
		 * Since the su user process died and the level hasn't been
		 * changed by a signal, either request a new level from the
		 * user if default one wasn't supplied, or use the supplied
		 * default level.
		 */
		if (tpmajornum != (major_t)NODEV){
			if (tponconsole == FALSE){
				verify_devtab();
				update_devtab();
				(void)setup_consdev((char *)NULL, (size_t)0);
				if (tponconsole == FALSE){
					remainsingle = TRUE;
					console(MM_INFO,
					    ":7:No TP on console remaining in SINGLE USER\n");
				}else{
					remainsingle = FALSE;
				}
			}else{
				if ((saveconsdevdsf != (char *)NULL) &&
				 (datadsfname[0] != '\0') &&
				 (strcmp(datadsfname, consdevdsf) == 0)){
					consdevdsf = saveconsdevdsf;
				}
			}
		}
		/*
		 * Close down the TP CTRL and DATA channel.  Disconnect CONS
		 * channel for input.  The TP will be setup again at the top
		 * of the loop.
		 */
		if (tpmajornum != (major_t)NODEV){
			tpinf.tpinf_dconnid = 0;
			(void)tp_datadisconnect(ctrlfd, &tpinf);
			(void)close(datafd);
			(void)close(ctrlfd);
			(void)tp_fconsdisconnect(consfd, &tpinf);
			(void)close(consfd);
			datafd = ctrlfd = consfd = -1;
		}
		if (remainsingle == TRUE){
			state = SINGLE_USER;
		}else if (defaultlevel != 0){
			state = defaultlevel;
		}else{
			if ((tpmajornum != (major_t)NODEV) &&
			 (tponconsole == TRUE)){
				consfd =
				 open(consdevdsf, O_RDWR|O_NONBLOCK|O_NOCTTY);
				tmpfd = consfd;
				consfd = fcntl(consfd, F_DUPFD, 3);
				(void)close(tmpfd);
				(void)tp_fconsconnect(consfd, &tpinf);
			}
			state = getlvl();
			if (tpmajornum != (major_t)NODEV){
				(void)tp_fconsdisconnect(consfd, &tpinf);
				(void)close(consfd);
				consfd = -1;
			}
		}

		/*
		 * If the new level is not SINGLE_USER, then return,
		 * otherwise go back and make up a new "su" process.
		 */
		if (state != SINGLE_USER) {
#ifdef DEBUG
debug("%d:single():state != SINGLE_USER\n",getpid());
#endif
			/*
			 * Check to make sure UTMPX is accessible.
			 * If not, remain in single user mode.
			 */
			if (access(UTMPX, F_OK) == -1) {
#ifdef DEBUG
debug("%d:single():ACCESS %s FAILED REMAIN SINGLE_USER\n",getpid(), UTMPX);
#endif
				console(MM_ERROR,
				    ":6:Cannot access %s, remaining in single user mode.\n",
					UTMPX);
			} else {
				prev_state = cur_state;
				if(cur_state >= 0) {
					n_prev[cur_state]++;
					prior_state = cur_state;
				}
				cur_state = state;
#ifdef DEBUG
debug("%d:single():RETURN\tconsdevdsf = %s\n", getpid(), consdevdsf);
#endif
				return;
			}
		}
	}
}


/*
 * Procedure:     remv
 *
 * Restrictions:
                 kill(2): None
*/

/*
 * remv() scans through "proc_table" and performs cleanup.  If
 * there is a process in the table, which shouldn't be here at
 * the current run level, then remv() kills the process.
 */
void
remv()
{
	register struct PROC_TABLE	*process;
	struct CMD_LINE			cmd;
	char				cmd_string[MAXCMDL];
	int				change_level;

	change_level = (cur_state != prev_state ? TRUE : FALSE);

	/*
	 * Clear the TOUCHED flag on all entries so that when we have
	 * finished scanning inittab, we will be able to tell if we
	 * have any processes for which there is no entry in inittab.
	 */
	for (process = &proc_table[0]; process < &proc_table[NPROC]; process++)
		process->p_flags &= ~TOUCHED;

	/*
	 * Scan all inittab entries.
	 */
	while (getcmd(&cmd, &cmd_string[0]) == TRUE) {
	    /*
	     * Scan for process which goes with this entry in inittab.
	     */
	    for (process= &proc_table[0]; process < &proc_table[NPROC];
	        process++) {
		/*
		 * Does this slot contain the proc we are looking for?
		 */
		if ((process->p_flags & OCCUPIED) &&
		    id_eq(process->p_id, cmd.c_id)) {
#ifdef	DEBUG
		    debug("remv- id:%s pid:%ld time:%lo %d %o %o\n",
			    C(&process->p_id[0]), process->p_pid,
			    process->p_time, process->p_count,
			    process->p_flags, process->p_exit);
#endif
		    /*
		     * Is the cur_state SINGLE_USER or is this
		     * process marked as "off" or was this proc
		     * started by some mechanism other than
		     * LVL{a|b|c} and the current level does
		     * not support this process?
		     */
		    if (cur_state == SINGLE_USER ||
		      cmd.c_action == M_OFF ||
		      ((cmd.c_levels & mask(cur_state)) == 0 &&
		      (process->p_flags & DEMANDREQUEST) == 0)) {

			if (process->p_flags & LIVING) {
				/*
				 * Touch this entry so we know we have
				 * treated it.  Note that procs which are
				 * already dead at this point and should
				 * not be restarted are left untouched.
				 * This causes their slot to be freed later
				 * after dead accounting is done.
				 */
				process->p_flags |= TOUCHED;

				if ((process->p_flags & KILLED) == 0) {
					if (change_level) {
						process->p_flags |= WARNED;
						kill(process->p_pid, SIGTERM);
					} else {
						/*
						 * fork a killing proc so "init"
						 * can continue without having
						 * to pause for TWARN seconds.
						 */
						killproc(process->p_pid);
					}
					process->p_flags |= KILLED;
				}
			}

		    } else {
			/*
			 * Process can exist at current level.  If it is still
			 * alive or a DEMANDREQUEST we touch it so it will be
			 * left alone.  Otherwise we leave it untouched so it
			 * will be accounted for and cleaned up later in remv().
			 * Dead DEMANDREQUESTs will be accounted but not freed.
			 */
			if (process->p_flags & (LIVING|NOCLEANUP|DEMANDREQUEST))
				process->p_flags |= TOUCHED;
		    }
		    break;
		}
	    }
	}

	/*
	 * If this was a change of levels call, scan through the
	 * process table for processes that were warned to die.  If any
	 * are found that haven't left yet, sleep for TWARN seconds and
	 * then send final terminations to any that haven't died yet.
	 */
	if (change_level) {

		/*
		 * Set the alarm for TWARN seconds on the assumption
		 * that there will be some that need to be waited for.
		 * This won't harm anything except we are guaranteed to
		 * wakeup in TWARN seconds whether we need to or not.
		 */
		setimer(TWARN);

		/*
		 * Scan for processes which should be dying.  We hope they
		 * will die without having to be sent a SIGKILL signal.
		 */
		for (process = &proc_table[0]; process < &proc_table[NPROC];
		    process++) {
			/*
			 * If this process should die, hasn't yet, and the
			 * TWARN time hasn't expired yet, wait for process
			 * to die or for timer to expire.
			 */
			while (time_up == FALSE &&
			    (process->p_flags & (WARNED|LIVING|OCCUPIED)) ==
			    (WARNED|LIVING|OCCUPIED))
				pause();

			if (time_up == TRUE)
				break;
		}

		/*
		 * If we reached the end of the table without the timer
		 * expiring, then there are no procs which will have to be
		 * sent the SIGKILL signal.  If the timer has expired, then
		 * it is necessary to scan the table again and send signals
		 * to all processes which aren't going away nicely.
		 */
		if (time_up == TRUE) {
		    for (process = &proc_table[0];
			process < &proc_table[NPROC]; process++) {

			    if ((process->p_flags & (WARNED|LIVING|OCCUPIED)) ==
				(WARNED|LIVING|OCCUPIED))
				    kill(process->p_pid, SIGKILL);
		    }
		}
		setimer(0);
	}

	/*
	 * Rescan the proc_table for two kinds of entry, those marked LIVING,
	 * NAMED, which don't have an entry in inittab (haven't been TOUCHED
	 * by the above scanning), and haven't been sent kill signals, and
	 * those entries marked not LIVING, NAMED.  The former procs are killed.
	 * The latter have DEAD_PROCESS accounting done and the slot cleared.
	 */
	for (process= &proc_table[0]; process < &proc_table[NPROC]; process++) {
		if ((process->p_flags & (LIVING|NAMED|TOUCHED|KILLED|OCCUPIED))
		    == (LIVING|NAMED|OCCUPIED)) {
			killproc(process->p_pid);
			process->p_flags |= KILLED;
		} else if ((process->p_flags & (LIVING|NAMED|OCCUPIED)) ==
		    (NAMED|OCCUPIED)) {
			account(DEAD_PROCESS, process, NULL);
			/*
			 * If this named proc hasn't been TOUCHED, then free the
			 * space. It has either died of it's own accord, but
			 * isn't respawnable or it was killed because it
			 * shouldn't exist at this level.
			 */
			if ((process->p_flags & TOUCHED) == 0)
				process->p_flags = 0;
		}
	}
}



/*
 * Procedure:     spawn
 *
 * Restrictions:
                 open(2): None
                 fcntl(2): None
*/
/*
 * spawn() scans inittab for entries which should be run at this mode.
 * Processes which should be running but are not, are started.
 */
int
spawn()
{
	register struct PROC_TABLE	*pp;
	struct CMD_LINE			cmd;
	char				cmd_string[MAXCMDL];
	char				substituteline[MAXCMDL];
	short				lvl_mask;
	int				status;
	int				fd;
	int				tmpfd;
	struct tp_info			tpinf;

	/*
	 * First check the "powerhit" flag.  If it is set, make sure the modes
	 * are PF_MODES and clear the "powerhit" flag.  Avoid the possible race
	 * on the "powerhit" flag by disallowing a new powerfail interrupt
	 * between the test of the powerhit flag and the clearing of it.
	 */
	if (wakeup.w_flags.w_powerhit) {
		wakeup.w_flags.w_powerhit = 0;
		op_modes = PF_MODES;
	}
	lvl_mask = mask(cur_state);

#ifdef	DEBUG1
	debug("spawn\tSignal-new: %c cur: %c prev: %c\n", level(new_state),
	    level(cur_state),level(prev_state));
	debug("spawn- lvl_mask: %o op_modes: %o\n",lvl_mask,op_modes);
#endif

	/*
	 * Scan through all the entries in inittab.
	 */
	while ((status = getcmd(&cmd, &cmd_string[0])) == TRUE) {

		/*
		 * Find out if there is a process slot for this entry already.
		 */
		if ((pp = findpslot(&cmd)) == NULLPROC) {
			/*
			 * Only generate an error message every WARNFREQUENCY
			 * seconds when the internal process table is full.
			 */
			if (error_time(FULLTABLE))
				console(MM_ERROR,
				    ":8:Internal process table is full.\n");
			continue;
		}

		/*
		 * If there is an entry, and it is marked as DEMANDREQUEST,
		 * one of the levels a, b, or c is in its levels mask, and
		 * the action field is ONDEMAND and ONDEMAND is a permissable
		 * mode, and the process is dead, then respawn it.
		 */
		if (((pp->p_flags & (LIVING|DEMANDREQUEST)) == DEMANDREQUEST) &&
		    (cmd.c_levels & (MASKa|MASKb|MASKc)) &&
		    (cmd.c_action & op_modes) == M_ONDEMAND) {
			respawn(pp, &cmd);
			continue;
		}

#ifdef	DEBUG1
		debug("process:\t%s\t%05d\n%s\t%d\t%o\t%o\n",
			C(&pp->p_id[0]), pp->p_pid, ctime(&pp->p_time),
			pp->p_count, pp->p_flags, pp->p_exit);
		debug("cmd:\t%s\t%o\t%o\n\"%s\"\n", C(&cmd.c_id[0]),
			cmd.c_levels, cmd.c_action, cmd.c_command);
#endif

		/*
		 * If the action is not an action we are interested in,
		 * skip the entry.
		 */
		if ((cmd.c_action & op_modes) == 0 || pp->p_flags & LIVING ||
		    (cmd.c_levels & lvl_mask) == 0)
			continue;

		/*
		 * If the modes are the normal modes (ONCE, WAIT, RESPAWN, OFF,
		 * ONDEMAND) and the action field is either OFF or the action
		 * field is ONCE or WAIT and the current level is the same as
		 * the last level, then skip this entry.  ONCE and WAIT only
		 * get run when the level changes.
		 */
		if (op_modes == NORMAL_MODES &&
		    (cmd.c_action == M_OFF ||
		    (cmd.c_action & (M_ONCE|M_WAIT)) &&
		    cur_state == prev_state))
			continue;

		/*
		 * If consdevdsf != CONSOLE, substitute all occurrences of
		 * CONSOLE in the command line with consdevdsf.  This will
		 * redirect input and output to floating console device even
		 * though /etc/inittab entries indicate CONSOLE as the device
		 * to redirect input and output.
		 */
		if (strcmp(CONSOLE, consdevdsf) != 0){ 
			if (substitutedev(&cmd, substituteline, consdevdsf)
			 == FAILURE){
				console(MM_ERROR,
				    ":9:Substituting device %s failed for command\n\"%s\"\ncommand line length exceeds %d\n",
					substitutedsf, cmd.c_command, MAXCMDL);
				continue;
			}
		}
			
		/*
		 * At this point we are interested in performing the action for
		 * this entry.  Actions fall into two categories, spinning off
		 * a process and not waiting, and spinning off a process and
		 * waiting for it to die.  If the action is ONCE, RESPAWN,
		 * ONDEMAND, POWERFAIL, or BOOT we don't wait for the process
		 * to die, for all other actions we do wait.
		 */
		if (cmd.c_action & (M_ONCE | M_RESPAWN | M_PF | M_BOOT)) {
			respawn(pp, &cmd);

		} else {
			/*
			 * If TP is configured on the system connect the
			 * TP console device (consdevdsf) for input.  This is
			 * done because all actions that wait for its command
			 * to terminate, can open the console device for input.
			 * After the process terminates the console device is
			 * disconnected for input.
			 */
			if (tpmajornum != (major_t)NODEV){
				fd = open(consdevdsf, O_RDWR|O_NONBLOCK|O_NOCTTY);
				tmpfd = fd;
				fd = fcntl(fd, F_DUPFD, 3);
				(void)fcntl(fd, F_SETFD, 1);
				(void)close(tmpfd);
				(void)tp_fconsconnect(fd,&tpinf);
			}
			respawn(pp,&cmd);
			while (waitproc(pp) == FAILURE);
			if (tpmajornum != (major_t)NODEV){
				(void)tp_fconsdisconnect(fd,&tpinf);
				(void)close(fd);
			}
			account(DEAD_PROCESS, pp, NULL);
			pp->p_flags = 0;
		}
	}
	return(status);
}



/*
 * Procedure:     respawn
 *
 * Restrictions:
                 fcntl(2): None
*/

/*
 * respawn() spawns a shell, inserts the information about the process
 * process into the proc_table, and does the startup accounting.
 */
void
respawn(process, cmd)
register struct PROC_TABLE	*process;
register struct CMD_LINE	*cmd;
{
	register int	i;
	int		modes, maxfiles;
	long		now;
	struct PROC_TABLE tmproc, *oprocess;

#ifdef	DEBUG1
	debug("**  respawn  **  id:%s\n", C(&process->p_id[0]));
#endif

	/*
	 * The modes to be sent to efork() are 0 unless we are
	 * spawning a LVLa, LVLb, or LVLc entry or we will be
	 * waiting for the death of the child before continuing.
	 */
	modes = NAMED;
	if (process->p_flags & DEMANDREQUEST || cur_state == LVLa ||
	    cur_state == LVLb || cur_state == LVLc)
		modes |= DEMANDREQUEST;
	if ((cmd->c_action & (M_SYSINIT | M_WAIT | M_BOOTWAIT | M_PWAIT)) != 0)
		modes |= NOCLEANUP;

	/*
	 * If this is a respawnable process, check the threshold
	 * information to avoid excessive respawns.
	 */
	if (cmd->c_action & M_RESPAWN) {
		/*
		 * Add NOCLEANUP to all respawnable commands so that the
		 * information about the frequency of respawns isn't lost.
		 */
		modes |= NOCLEANUP;
		time(&now);

		/*
		 * If no time is assigned, then this is the first time
		 * this command is being processed in this series.  Assign
		 * the current time.
		 */
		if (process->p_time == 0L)
			process->p_time = now;

		if (process->p_count++ == SPAWN_LIMIT) {

			if ((now - process->p_time) < SPAWN_INTERVAL) {
				/*
				 * Process is respawning too rapidly.  Print
				 * message and refuse to respawn it for now.
				 */
				console(MM_ERROR,
				    ":10:Command is respawning too rapidly.  Check for possible errors.\nid:%4s \"%s\"\n",
					&cmd->c_id[0], &cmd->c_command[EXEC]);
				return;
			}
			process->p_time = now;
			process->p_count = 0;

		} else if (process->p_count > SPAWN_LIMIT) {
			/*
			 * If process has been respawning too rapidly and
			 * the inhibit time limit hasn't expired yet, we
			 * refuse to respawn.
			 */
			if (now - process->p_time < SPAWN_INTERVAL + INHIBIT)
				return;
			process->p_time = now;
			process->p_count = 0;
		}
		rsflag = TRUE;
	}

	/*
	 * Spawn a child process to execute this command.
	 */
	sighold(SIGCLD);
	oprocess = process;
	if (cmd->c_action & (M_WAIT | M_BOOTWAIT))
		while ((process = efork(M_WAIT, oprocess, modes)) == NO_ROOM)
			pause();
	else
		while ((process = efork(M_OFF, oprocess, modes)) == NO_ROOM)
			pause();

	if (process == NULLPROC) {

		/*
		 * We are the child.  We must make sure we get a different
		 * file pointer for our references to utmp.  Otherwise our
		 * seeks and reads will compete with those of the parent.
		 */
		endutxent();

		/*
		 * Perform the accounting for the beginning of a process.
		 * Note that all processes are initially "INIT_PROCESS"es.
		 */
		tmproc.p_id[0] = cmd->c_id[0];
		tmproc.p_id[1] = cmd->c_id[1];
		tmproc.p_id[2] = cmd->c_id[2];
		tmproc.p_id[3] = cmd->c_id[3];
		tmproc.p_pid = getpid();
		tmproc.p_exit = 0;
		account(INIT_PROCESS, &tmproc,prog_name(&cmd->c_command[EXEC]));
		maxfiles = ulimit(4,0L);
		for (i = 0; i < maxfiles; i++ )
			fcntl(i, F_SETFD, 1);

		/*
		 * Now exec a shell with the -c option and the command
		 * from inittab.
		 */
		execle(SH, "INITSH", "-c", cmd->c_command, (char *)0,glob_envp);
		console(MM_ERROR,
		    ":11:Command\n\"%s\"\n failed to execute. ", cmd->c_command);
		console(MM_NOSTD,
		    ":12:errno = %d (exec of shell failed)\n", errno);

		/*
		 * Don't come back so quickly that "init" doesn't have a
		 * chance to finish putting this child in "proc_table".
		 */
		timer(20);
		exit(1);

	} else {
		/*
		 * We are the parent.  Insert the necessary
		 * information in the proc_table.
		 */
		process->p_id[0] = cmd->c_id[0];
		process->p_id[1] = cmd->c_id[1];
		process->p_id[2] = cmd->c_id[2];
		process->p_id[3] = cmd->c_id[3];
	}
	sigrelse(SIGCLD);
	return;
}


/************************/
/****    findpslot    ****/
/************************/

/*
 * findpslot() finds the old slot in the process table for the
 * command with the same id, or it finds an empty slot.
 */
struct PROC_TABLE *
findpslot(cmd)
register struct CMD_LINE	*cmd;
{
	register struct PROC_TABLE	*process;
	register struct PROC_TABLE	*empty = NULLPROC;

	for (process = &proc_table[0]; process < &proc_table[NPROC]; process++){
		if (process->p_flags & OCCUPIED &&
		    id_eq(process->p_id, cmd->c_id))
			break;

		/*
		 * If the entry is totally empty and "empty" is still 0,remember
		 * where this hole is and make sure the slot is zeroed out.
		 */
		if (empty == NULLPROC && (process->p_flags & OCCUPIED) == 0) {
			empty = process;
			process->p_id[0] = '\0';
			process->p_id[1] = '\0';
			process->p_id[2] = '\0';
			process->p_id[3] = '\0';
			process->p_pid = 0;
			process->p_time = 0L;
			process->p_count = 0;
			process->p_flags = 0;
			process->p_exit = 0;
		}
	}

	/*
	 * If there is no entry for this slot, then there should be an
	 * empty slot.  If there is no empty slot, then we've run out
	 * of proc_table space.  If the latter is true, empty will be
	 * NULL and the caller will have to complain.
	 */
	if (process == &proc_table[NPROC])
		process = empty;

	return(process);
}


/*
 * Procedure:     getcmd
 *
 * Restrictions:
                 stat(2): None
                 fopen: None
                 fclose: None
                 fgetc: None
                 rewind: None
*/

/*
 * getcmd() parses lines from inittab.  Each time it finds a command line
 * it will return TRUE as well as fill the passed CMD_LINE structure and
 * the shell command string.  When the end of inittab is reached, FALSE
 * is returned.  From the time the inittab is opened to the end of the
 * file is called a cycle.
 * To handle the case where a file table overflow occurs, access to the
 * inittab (i.e. the file pointer to the inittab), obtained in the current
 * cycle, is held (i.e. kept open) to the next cycle.  At the end of a
 * cycle, the file pointer is rewound.  If in the next cycle through a
 * file pointer can not be obtained for the inittab due a file table overflow
 * condition, the file pointer associated with inittab from the previous
 * cycle is used.  If a file pointer is obtained the previous one is closed.
 */

static FILE 	*fp_inittab = NULL;
static FILE 	*fptmp_inittab = NULL;
static int	itabopened = 0;		/* indicates whether or not inittab
					 * file is currently opened.
					 */
static char	*inittabp = NULL;	/* path name of inittab being used in
					 * current cycle.
					 */
static char	*previnittabp = NULL;	/* path name of inittab used in a
					 * previous cycle.
					 */

int
getcmd(cmd, shcmd)
register struct CMD_LINE	*cmd;
char				*shcmd;
{
	register char	*ptr;
	register int	c, lastc, state;
	char 		*ptr1;
	int		answer, i, proceed;
	struct	stat	sbuf;
	static char *actions[] = {
		"off", "respawn", "ondemand", "once", "wait", "boot",
		"bootwait", "powerfail", "powerwait", "initdefault",
		"sysinit",
	};
	static short act_masks[] = {
		M_OFF, M_RESPAWN, M_ONDEMAND, M_ONCE, M_WAIT, M_BOOT,
		M_BOOTWAIT, M_PF, M_PWAIT, M_INITDEFAULT, M_SYSINIT,
	};

	if(!itabopened) {

		/*
		 * Before attempting to open inittab we stat it to make
		 * sure it currently exists and is not empty.  We try
		 * several times because someone may have temporarily
		 * unlinked or truncated the file.
		 */
		inittabp = SOFTINITTAB;
		for (i = 0; i < 3; i++) {
			if (stat(inittabp, &sbuf) == -1) {
				if (i == 2) {
					console(MM_ERROR,
					    ":13:Cannot stat %s, errno: %d\n",
					 inittabp, errno);
					if ((inittabp = ALTINITTAB) != (char *)NULL){
						console(MM_ERROR,
						    ":14:Using %s instead\n",
						 inittabp);
					} else {
						return (FAILURE);
					}
				} else {
					timer(3);
				}
			} else if (sbuf.st_size < 10) {
				if (i == 2) {
					console(MM_WARNING,
					    ":15:%s truncated or corrupted\n",
					 inittabp);
					if ((inittabp = ALTINITTAB) != (char *)NULL){
						console(MM_WARNING,
						    ":14:Using %s instead\n",
						 inittabp);
					} else {
						return (FAILURE);
					}
				} else {
					timer(3);
				}
			} else {
				break;
			}
		}

		/*
		 * Open the inittab file.
		 * If open succeeds, close the file pointer kept open from
		 * the previous cycle, and indicate that the inittab is opened
		 * for the cycle.
		 * If open fails and reason is NOT a file table overflow
		 * condtion return FAILURE condition.  Note.  The file pointer
		 * to inittab (if on existed) opened in a previous cycle is
		 * not closed.  Always want to have a file pointer to an
		 * inittab to handle file table overflow condtions
		 * (which may occur in the furture).
		 * If open fails and reason is a file table overflow condition,
		 * use the file pointer (if one exists) held open from a
		 * previous cycle, and indicate that the inittab is opened for
		 * the cycle.
		 */

		if ((fptmp_inittab = fopen(inittabp, "r")) != NULL) {
			(void)fclose(fp_inittab);
			fp_inittab = fptmp_inittab;
			previnittabp = inittabp;
			itabopened = 1;
		} else if (errno != ENFILE) {
			console(MM_ERROR,
			    ":16:Cannot open %s errno: %d\n", inittabp, errno);
			return (FAILURE);
		} else { /* errno == ENFILE */
			if (fp_inittab == (FILE *)NULL) {
				return (FAILURE);
			}
			console(MM_WARNING,
			    ":16:Cannot open %s errno: %d\n", inittabp, errno);
			console(MM_WARNING,
			    ":17:Using %s that was previously opened.\n",
			 previnittabp);
			console(MM_WARNING,
			    ":18:It may be different or out of date.\n");
			itabopened = 1;
		}
	}


	/*
	 * Keep getting commands from inittab until you find a
	 * good one or run out of file.
	 */
	for (answer = FALSE; answer == FALSE;) {
		/*
		 * Zero out the cmd itself before trying next line.
		 */
		zero((char *)cmd, sizeof(struct CMD_LINE));

		/*
		 * Read in lines of inittab, parsing at colons, until a line is
		 * read in which doesn't end with a backslash.  Do not start if
		 * the first character read is an EOF.  Note that this means
		 * that lines which don't end in a newline are still processed,
		 * since the "for" will terminate normally once started,
		 * regardless of whether line terminates with a newline or EOF.
		 */
		state = FAILURE;
		if ((c = fgetc(fp_inittab)) == EOF) {
			answer = FALSE;
			itabopened = 0;
			rewind(fp_inittab);
			break;
		}

		for (proceed = TRUE, ptr = shcmd, state = ID, lastc = '\0';
		  proceed && c != EOF;
		  lastc = c, c = fgetc(fp_inittab)) {
		    /*
		     * If we're not in the FAILURE state and haven't
		     * yet reached the shell command field, process
		     * the line, otherwise just look for a real end
		     * of line.
		     */
		    if (state != FAILURE && state != COMMAND) {
			/*
			 * Squeeze out spaces and tabs.
			 */
			if (c == ' ' || c == '\t')
				continue;

			/*
			 * If the character is a ':', then check the
			 * previous field for correctness and advance
			 * to the next field.
			 */
			if ( c == ':' ) {
			    switch (state) {

			    case ID :
				/*
				 * Check to see that there are only
				 * 1 to 4 characters for the id.
				 */
				if ((i = ptr - shcmd) < 1 || i > 4 ) {
					state = FAILURE;
				} else {
					bcopy(shcmd, &cmd->c_id[0], i);
					ptr = shcmd;
					state = LEVELS;
				}
				break;

			    case LEVELS :
				/*
				 * Build a mask for all the levels for
				 * which this command will be legal.
				 */
				for (cmd->c_levels = 0, ptr1 = shcmd;
				    ptr1 < ptr; ptr1++) {
					if (*ptr1 >= '0' && *ptr1 <= '6') {
						cmd->c_levels |=
						    (MASK0 << (*ptr1 - '0'));
					} else if(*ptr1 >= 'a' && *ptr1 <= 'c'){
						cmd->c_levels |=
						    (MASKa << (*ptr1 - 'a'));
					} else if(*ptr1 == 's' || *ptr1 == 'S'){
						cmd->c_levels |= MASKSU;
					} else {
						state = FAILURE;
						break;
					}
				}
				if (state != FAILURE) {
					state = ACTION;
					ptr = shcmd;	/* Reset the buffer */
				}
				break;

			    case ACTION :
				/*
				 * Null terminate the string in shcmd buffer and
				 * then try to match against legal actions.  If
				 * the field is of length 0, then the default of
				 * "RESPAWN" is used if the id is numeric,
				 * otherwise the default is "OFF".
				 */
				if (ptr == shcmd) {
					if (isdigit(cmd->c_id[0])
					   && (cmd->c_id[1] == '\0' ||
						isdigit(cmd->c_id[1]))
					   && (cmd->c_id[2] == '\0' ||
						isdigit(cmd->c_id[2]))
					   && (cmd->c_id[3] == '\0' ||
						isdigit(cmd->c_id[3])) )
						    cmd->c_action = M_RESPAWN;
					else
						    cmd->c_action = M_OFF;
				} else {
				    for (cmd->c_action=0, i= 0,*ptr = '\0';
				      i < sizeof(actions)/sizeof(char *);
				      i++) {
					if (strcmp(shcmd,actions[i]) == 0) {
					    if ((cmd->c_levels & MASKSU) &&
						!(act_masks[i] &
						(M_INITDEFAULT|M_PF|M_PWAIT|M_WAIT)))
						    cmd->c_action = 0;
					    else
						    cmd->c_action= act_masks[i];
					    break;
					}
				    }
				}

				/*
				 * If the action didn't match any legal action,
				 * set state to FAILURE.
				 */
				if (cmd->c_action == 0) {
					state = FAILURE;
				} else {
					state = COMMAND;
					strcpy(shcmd,"exec ");
				}
				ptr = shcmd + EXEC;
				break;
			    }
			    continue;
			}
		    }

		    /*
		     * If the character is a '\n', then this is the end of a
		     * line.  If the '\n' wasn't preceded by a backslash,
		     * it is also the end of an inittab command.  If it was
		     * preceded by a backslash then the next line is a
		     * continuation.  Note that the continuation '\n' falls
		     * through and is treated like other characters and is
		     * stored in the shell command line.
		     */
		    if (c == '\n' && lastc != '\\') {
				proceed = FALSE;
				*ptr = '\0';
				break;
		    }

		    /*
		     * For all other characters just stuff them into the command
		     * as long as there aren't too many of them. Make sure there
		     * is room for a terminating '\0' also.
		     */
		    if (ptr >= shcmd + MAXCMDL - 1)
			state = FAILURE;
		    else
			*ptr++ = (char)c;

		    /*
		     * If the character we just stored was a quoted backslash,
		     * then change "c" to '\0', so that this backslash will not
		     * cause a subsequent '\n' to appear quoted.  In otherwords
		     * '\' '\' '\n' is the real end of a command, while '\' '\n'
		     * is a continuation.
		     */
		    if ( c == '\\' && lastc == '\\')
			c = '\0';
		}

		/*
		 * Make sure all the fields are properly specified
		 * for a good command line.
		 */
		if (state == COMMAND) {
			answer = TRUE;
			cmd->c_command = shcmd;

			/*
			 * If no default level was supplied, insert
			 * all numerical levels.
			 */
			if (cmd->c_levels == 0)
				cmd->c_levels =
				    MASK0|MASK1|MASK2| MASK3|MASK4|MASK5|MASK6;

			/*
			 * If no action has been supplied, declare this
			 * entry to be OFF.
			 */
			if (cmd->c_action == 0)
				cmd->c_action = M_OFF;

			/*
			 * If no shell command has been supplied, make sure
			 * there is a null string in the command field.
			 */
			if (ptr == shcmd + EXEC)
				*shcmd = '\0';
		} else 
			answer = FALSE;

		/*
		 * If we have reached the end of inittab, rewind inittab's file
		 * pointer and hold on to it (i.e. keep it open) incase it is
		 * needed in the next cycle.
		 */
		if (c == EOF) {
			itabopened = 0;
			rewind(fp_inittab);
		}
	}
	return(answer);
}

/********************/
/****    mask    ****/
/********************/

int
mask(lvl)
int	lvl;
{
	register int	answer;

	switch (lvl) {

	case LVLQ:
		answer = 0;
		break;
	case LVL0:
		answer = MASK0;
		break;
	case LVL1:
		answer = MASK1;
		break;
	case LVL2:
		answer = MASK2;
		break;
	case LVL3:
		answer = MASK3;
		break;
	case LVL4:
		answer = MASK4;
		break;
	case LVL5:
		answer = MASK5;
		break;
	case LVL6:
		answer = MASK6;
		break;
	case SINGLE_USER:
		answer = MASKSU;
		break;
	case LVLa:
		answer = MASKa;
		break;
	case LVLb:
		answer = MASKb;
		break;
	case LVLc:
		answer = MASKc;
		break;
	default:
		answer = FAILURE;
		break;
	}
	return(answer);
}


/*********************/
/****    level    ****/
/*********************/

char
level(state)
int	state;
{
	register char	answer;

	switch(state) {

	case LVL0:
		answer = '0';
		break;
	case LVL1:
		answer = '1';
		break;
	case LVL2:
		answer = '2';
		break;
	case LVL3:
		answer = '3';
		break;
	case LVL4:
		answer = '4';
		break;
	case LVL5:
		answer = '5';
		break;
	case LVL6:
		answer = '6';
		break;
	case SINGLE_USER:
		answer = 'S';
		break;
	case LVLa:
		answer = 'a';
		break;
	case LVLb:
		answer = 'b';
		break;
	case LVLc:
		answer = 'c';
		break;
	default:
		answer = '?';
		break;
	}
	return(answer);
}


/*
 * Procedure:     killproc
 *
 * Restrictions:
                 kill(2): None

 * Notes: creates a child which kills the process specified by pid.
 */
void
killproc(pid)
register pid_t	pid;
{
	register struct PROC_TABLE	*process;

	sighold(SIGCLD);
	while ((process = efork(M_OFF, NULLPROC, 0)) == NO_ROOM)
		pause();
	sigrelse(SIGCLD);

	if (process == NULLPROC) {
		/*
		 * We are the child.  Try to terminate the process nicely
		 * first using SIGTERM and if it refuses to die in TWARN
		 * seconds kill it with SIGKILL.
		 */
		kill(pid, SIGTERM);
		timer(TWARN);
		kill(pid, SIGKILL);
		exit(0);
	}
}


/*
 * Procedure:     initialize
 *
 * Restrictions:
                 fopen: None
                 fclose: None
                 fcntl(2): None
                 open(2): None
*/

/*
 * Perform the initial state setup and look for an
 * initdefault entry in the "inittab" file.
 */
int
initialize(argc, argv)
int	argc;
char	**argv;
{
	register int		msk, i;
	register struct		PROC_TABLE *process, *oprocess;
	static int 		states[] = {LVL0,LVL1,LVL2,LVL3,LVL4,LVL5,
					    LVL6,SINGLE_USER};
	struct CMD_LINE		cmd;
	struct tp_info		tpinf;
	char 			line[MAXCMDL];
	char			substituteline[MAXCMDL];
	char			lerrbuf[ERRBUFSZ];
	FILE			*fp;
	int 			initstate, inquotes, length, maxfiles, wslength;
	char			*tokp, *cp1, *cp2;
	int			status;
	int			consfd;
	int			tmpfd;
	int			ret;
        FILE    *tpath_fp;
        char    *tpath_ptr;
	struct  mod_mreg mreg;
	FILE    *regfp;
	unsigned int type, rtype;
	unsigned int fcmd, rfcmd;
	char buf[ENTLEN], typed[512];
	int nfield;
	int major;
	char modname[MODMAXNAMELEN];
	char *def_lang = (char *)NULL;
	FILE *locale_fp;


#ifdef DEBUG
debug("%d:initialize():ENTER\n",getpid());
#endif
	/*
	 * Since this is process 1, we can't pick up the locale from
	 * the environment; instead, init should pick up the system
	 * default locale as defined in /etc/default/locale.
	 * If /usr isn't mounted, try to find the catalog under
	 * /etc/inst/locale/<locale>/LC_MESSAGES.
	 */
	if (((locale_fp = defopen("locale")) != (FILE *)NULL) &&
	   ((def_lang = defread(locale_fp, "LANG")) != (char *)NULL))
		if ((setlocale(LC_ALL, def_lang)) == NULL)
			setlocale(LC_MESSAGES, strcat("/etc/inst/locale/", def_lang));

	(void)defclose(locale_fp);

	/*
	 * Determine whether or not MAC is installed and/or running.
	 * Get Major Device number for Trusted Path.  This also determines
	 * whether or not TP is configured in the system.
	 */
	macinstalled = is_macinstalled();
	macrunning = is_macrunning();

#ifndef  NO_TPCONS
	/* 
	 * In a system where Trusted Path is loadable we need to register
	 * it now so the secsys call will work.
	 * Normally most loadable modules are 'registered' with
	 * the idmodreg command run out of inittab, however this is well
	 * before inittab is run so we must register it ourselves 
	 * See MR ul93-18701>
	 *
	 * Should anything fail in reading /etc/mod_register we set up
	 * our best guess at the major #. Currently
	 * the major number for 'tpath' is 36, should this ever
	 * change we need to change the value here.
	 *
	 * note: if 'tpath' is in /etc/mod_register, the 'idmodreg'
	 * cmd soon to be run out of inittab will print out:
	 * "modadm: cannot register module tpath: File exists"
	 * so we have redirected idmodreg output to /dev/null 
	 */
	mreg.md_typedata = (void *) 36;
	strcpy(mreg.md_modname, "tpath");
	rtype = MOD_TY_SDEV;
	rfcmd = MOD_C_MREG;
	if((access(regfile, F_OK) >= 0) && ((regfp = fopen(regfile, "r")) != NULL)) {
        	while (fgets(buf, sizeof(buf), regfp) != NULL) {
     			if (buf[0] == '#' || buf[0] == '*')
                        	continue;
			nfield = sscanf(buf, SYNTAX,  &type, &fcmd,
				modname, typed);
			if (nfield != 4) 
                        	continue;
			if (strcmp(modname, "tpath") != 0 )
				continue;
			if (type != MOD_TY_SDEV)
				continue;
                        major = atoi(typed);
                        mreg.md_typedata = (void *)major;
			strcpy(mreg.md_modname, modname);
			rtype = type;	
			rfcmd = fcmd;
			break;
		}
	}

	/* 
	 * don't complain if modadmin fails since it could fail
	 * if tpath is not loadable. the secsys later on would
	 * fail in this case
	 */
	modadm(rtype, rfcmd, (void *)&mreg);

	(void)secsys(ES_TPGETMAJOR, (char *)&tpmajornum);
        if (tpmajornum != (major_t)NODEV) {
                /*
                 * the only way we will allow a TP-deconfig is if mac is
                 * not installed and there is a /etc/default/tpath file
                 * with a TP_DEFAULT=no entry.
                 */
                if(!macinstalled &&
                   ((tpath_fp = defopen(DEFLT_TPATH_FILE)) != (FILE *)NULL) &&
                   ((tpath_ptr = defread(tpath_fp, TPNAME)) != (char *)NULL) &&
                   ((strcmp(tpath_ptr, NO_U) == 0) ||
                    (strcmp(tpath_ptr, NO_L) == 0))) {
                        tpmajornum = (major_t)NODEV;
                }
        }
#endif

	/*
	 * -initialize entries in devtab
	 * -verify the existence of the DSF listed in devtab.  If any do not
	 *  exist, they will be made after the root file system has been
	 *  verified to be sane.
	 * -If TP is configured on the system, setup an autopush configuration
	 *  for the TP CONS channel.
	 * -setup the device to direct console message output.
	 * If the CONSOLE DSF is not the DSF to direct console message
	 * output, substitutedsf has been set to consdevdsf in setup_consdev.
	 * This will cause all occurences of /dev/console in /etc/inittab
	 * for the SYSINIT entries to be substituted with substitutedsf
	 * before the SYSINIT command is executed.
	 * If consdevdsf is NULL go into firmware mode since most
	 * of the SYSINIT entries in the inittab will fail without a device
	 * to read from and write to.  
	 *
	 * NOTE: Since there is no device to direct console message output to,
	 * we can not display an error message, that could assist the
	 * administrator, before going into firmware mode.
	 * Need to find a way to get a message out. (Perhaps modifying
	 * uadmin(2) to accept a sting to be displayed.)
	 */
	initialize_devtab();
	verify_devtab();
	(void)set_autopush();
	if (setup_consdev(lerrbuf, ERRBUFSZ) == FAILURE){
		console(MM_NOGET|MM_ERROR, "%s", lerrbuf);
	}

	if (consdevdsf == (char *)NULL){
#ifdef DEBUG
#endif
		/*
		 * The following is the error message to be displayed
		 * if any error could be displayed via uadmin(2).
		 *
		 *sprintf(buf,
		 *"%s:%s:returning to firmware mode\n
		 *Reboot from Assurance Media to correct problem\n
		 *%s:major device number %d:minor device number %d\n",
 		 *CONSOLE, (devtab[DTTAG_CONSOLE].dt_status ==
		 *dtsWRONGDEV?"incorrect major/minor device number":
		 *"does not exist"),CONSOLE,
		 *devtab[DTTAG_CONSOLE].dt_major,
		 *devtab[DTTAG_CONSOLE].dt_minor);
		 *firmware(buf);
		 */
		firmware();
	}

	/* Get the name of the inittab (if sysinfo() returns an error, default
	 * to the value of INITTAB).
	 */
	if (sysinfo(SI_INITTAB_NAME, (char *) &SOFTINITTAB,
		(long) sizeof(SOFTINITTAB)) < 0) {

		(void) strcpy(SOFTINITTAB, INITTAB);
	}
	/* Get the name of the alternate (backup) inittab */
	ALTINITTAB = INIT386;
	
	/*
	 * Initialize state to "SINGLE_USER" "BOOT_MODES".
	 */
	if(cur_state >= 0) {
		n_prev[cur_state]++;
		prior_state = cur_state;
	}
	cur_state = SINGLE_USER;
	op_modes = BOOT_MODES;

	/*
	 * Set up all signals to be caught or ignored as appropriate.
	 */
	init_signals();
	initstate = 0;

	/* Call "initprivs" routine to exec the program "/sbin/initprivs".
	 * This is required since the kernel privilege mechanism has
	 * changed and the current implementation calls for
	 * initialization of a kernel privilege table to associate
	 * privilege with files.  This design offers flexibility since
	 * the program "/sbin/initprivs" can be modified to accomodate
	 * any privilege mechanism without recompilation of "/etc/init".
	 *
	 * A return code of "REBOOT" indicates that there was some type
	 * a problem with the file ``/etc/security/tcb/privs''.
	 * The system goes down to FIRMWARE MODE with a suggestion to
	 * reboot from assurance media (if possible).
	 */

	if (initprivs() == REBOOT) {
		console(MM_ERROR,
		    ":19:Cannot access %s, returning to firmware mode.\r\n", PDF);
		firmware();	/* No Return */

	}

#ifdef	UDEBUG
	reset_modes();
#endif

	/*
	 * Set up the default environment for all procs to be forked from init.
	 * Read the values from the /etc/TIMEZONE file, except for PATH and 
	 * LANG.  If there's not enough room in the environment array,
	 * the environment lines that don't fit are silently discarded.
	 */
	glob_envp[0] =
	    malloc((unsigned)(strlen("PATH=/sbin:/usr/sbin:/etc:/usr/bin")+2));
	strcpy(glob_envp[0], "PATH=/sbin:/usr/sbin:/etc:/usr/bin");

	glob_envp[1] =
	    malloc((unsigned)(strlen("LANG=") + strlen(def_lang) + 2));
	strcpy(glob_envp[1], "LANG=");
	if (def_lang)
		strcat(glob_envp[1], def_lang);
	else
		strcat(glob_envp[1], "C");

	if( (fp = fopen(ENVFILE, "r")) == NULL ) {
		console(MM_ERROR,
		    ":20:Cannot open %s. Environment not initialized.\n",
			ENVFILE);
	} else {
		i = 2;
		while (fgets(line, MAXCMDL - 1, fp) != NULL &&
		    i < MAXENVENT - 1) {
			/*
			 * Toss newline
			 */
			length = strlen(line);
			if (line[length - 1] == '\n')
				line[length - 1] = '\0';
			/*
			 * Ignore blank or comment lines.
			 */
			if (line[0] == '#' || line[0] == '\0' ||
			    (wslength=strspn(line, " \t\n")) == strlen(line) ||
			    strchr(line, '#') == line + wslength)
				continue;
			/*
			 * First make a pass through the line and change
			 * any non-quoted semi-colons to blanks so they
			 * will be treated as token separators below.
			 */
			inquotes = 0;
			for (cp1 = line; *cp1 != '\0'; cp1++) {
				if (*cp1 == '"') {
					if (inquotes == 0)
						inquotes = 1;
					else
						inquotes = 0;
				} else if (*cp1 == ';') {
					if (inquotes == 0)
						*cp1 = ' ';
				}
			}

			/*
			 * Tokens within the line are separated by blanks
			 *  and tabs.  For each token in the line which
			 * contains a '=' we strip out any quotes and then
			 * stick the token in the environment array.
			 */
			if ((tokp = strtok(line, " \t")) == NULL)
				continue;
			do {
				if (strchr(tokp, '=') == NULL)
					continue;
				length = strlen(tokp);
				while ((cp1 = strpbrk(tokp,"\"\'")) != NULL ) {
				 	for (cp2 = cp1;
					    cp2 < &tokp[length - 1]; cp2++)
				 		*cp2 = *(cp2 + 1);
					*cp2 = '\0';
				 	length--;
 				}
				glob_envp[i]= malloc((unsigned)(length + 1));
				strcpy(glob_envp[i], tokp);
				if (++i >= MAXENVENT - 1)
					break;
			} while ((tokp = strtok(NULL, " \t")) != NULL);
		}

		/*
		 * Append a null pointer to the environment array
		 * to mark its end.
		 */
		glob_envp[i] = NULL;
		fclose(fp);
	}

	/*
	 * Scan the "inittab" file and process "initdefault"
	 * and "sysinit" entries.
	 */
	while (getcmd(&cmd, &line[0]) == TRUE) {
		if (cmd.c_action == M_INITDEFAULT) {
			/*
			 * Look through the "c_levels" word, starting at
			 * the highest level.  If there is more than one
			 * level specified, the system will come up at
			 * the highest of the specified levels.
			 */
			for (msk = MASKSU, i = sizeof(states)/sizeof(int) - 1;
			    msk > 0; msk >>= 1 , i--) {
				if (msk & cmd.c_levels) {
					initstate = states[i];
				}
			}
		} else if (cmd.c_action == M_SYSINIT) {
			/*
			 * Execute the "sysinit" entry and wait for it to
			 * complete.  No bookkeeping is performed on these
			 * entries because we avoid writing to the file system
			 * until after there has been an chance to check it.
			 */
			if (process = findpslot(&cmd)) {
				sighold(SIGCLD);

				/*
				 * If Trusted Path is on the console device need
				 * to connect the console device for input.
				 * NOTE: When TP is on the console, the console
				 * device's major/minor device number is always
				 * the same as the major/minor device number of
				 * TP_CONSDEV_DSF.
				 */
				if (tponconsole == TRUE){
					consfd = open(consdevdsf,
					 O_WRONLY|O_NONBLOCK|O_NOCTTY);
					(void)tp_fconsconnect(consfd,
					 &tpinf);
					tmpfd = consfd;
					consfd =
					 fcntl(consfd, F_DUPFD, 3);
					(void)fcntl(consfd, F_SETFD, 1);
					(void)close(tmpfd);
				}
				for (oprocess = process;
				    (process = efork(M_OFF, oprocess,
				    (NAMED|NOCLEANUP))) == NO_ROOM;);

				sigrelse(SIGCLD);

				if (process == NULLPROC) {
					maxfiles = ulimit(4, 0L);
					for (i = 0; i < maxfiles; i++)
						fcntl(i, F_SETFD, 1);

					/*
					 * If substitutedsf is defined, the DSF
					 * CONSOLE either does not exist or has
					 * an incorrect major and/or minor
					 * device number.  substitutedev() will
					 * substitute all occurrences of the
					 * DSF name CONSOLE in the command line
					 * with the DSF name defined in
					 * substitutedsf.
					 */
					if (substitutedsf != (char *)NULL){
						if (substitutedev(&cmd,
						 substituteline, substitutedsf)
						 == FAILURE){
							console(MM_ERROR,
							    ":9:Substituting device %s failed for command\n\"%s\"\ncommand line length exceeds %d\n",
								substitutedsf,
								cmd.c_command,
								MAXCMDL);
							exit(1);
						}
					}
					execle(SH,"INITSH", "-c", cmd.c_command,
					    (char *)0, glob_envp);
					console(MM_ERROR,
					    ":11:Command\n\"%s\"\n failed to execute. ", cmd.c_command);
					console(MM_NOSTD,
					    ":12:errno = %d (exec of shell failed)\n", errno);
					exit(1);
				} else while (waitproc(process) == FAILURE);
					if (tponconsole == TRUE){
						(void)tp_fconsdisconnect(consfd,
						 &tpinf);
						(void)close(consfd);
					}

#ifdef	ACCTDEBUG
				debug("SYSINIT- id: %.4s term: %o exit: %o\n",
					&cmd.c_id[0],(process->p_exit&0xff),
					(process->p_exit&0xff00)>>8);
#endif
				process->p_flags = 0;
			}
		}

		if (!rootfs_verified) {
		    struct statvfs statv;

		    if (statvfs("/", &statv) == 0 &&
			!(statv.f_flag & ST_RDONLY)) {
			/*
			 * The previous action has made the root filesystem
			 * writeable.  Presumably it was ckroot.  It is now
			 * safe to assume that root has been fsck'ed and is
			 * OK to start modifying.
			 *
			 * Update any entries in devtab with action dtaMKNOD
			 * or dtaLINK.  Setup the console device (consdevdsf
			 * and TP) again.  If any of the devices in devtab were
			 * created, consdevdsf and TP (if TP is configured) may
			 * need to be updated or allocated also.
			 */
			rootfs_verified = TRUE;
			ret = update_devtab();
			if (setup_consdev(lerrbuf, ERRBUFSZ) == FAILURE) {
				console(MM_NOGET|MM_ERROR, "%s", lerrbuf);
			}
			
			if ((ret == FAILURE) ||
			    (tpmajornum != (major_t)NODEV) &&
			    (tponconsole != TRUE)) {
				console(MM_INFO,
				    ":21:Remaining at run level %c\n",level(SINGLE_USER));
				initstate = SINGLE_USER;
			}

			/*
			 * Get the ioctl settings for /dev/syscon so that it can be
			 * brought up in the state it was in when the system went down.
			 */
			get_ioctl_syscon();
		    }
		}
	}

	/*
	 * Override :initdefault: with supplied -s option, if any.
	 */
	if (argc > 2 && strcmp(argv[1], "-s") == 0) {
		if (argv[2][0] >= '0' && argv[2][0] <= '6')
			initstate = states[argv[2][0] - '0'];
		else if (argv[2][0] == 's' || argv[2][0] == 'S')
			initstate = SINGLE_USER;
	}

#ifdef DEBUG
debug("%d:initialize():RETURN\tinitstate = %d\n",getpid(),initstate);
#endif
	if (initstate == SINGLE_USER)
		return(-1);

	/*
	 * If no "initdefault" entry is found, return 0.  This will
	 * have "init" ask the user at /dev/syscon to supply a level.
	 */
	if (initstate) 
		return(initstate);
	else
		return(0);
}


/****************************/
/****    init_signals    ****/
/****************************/

/*
 * Initialize all signals to either be caught or ignored.
 */
void
init_signals()
{
	sigset(LVLQ, siglvl);
	sigset(LVL0, siglvl);
	sigset(LVL1, siglvl);
#ifdef	UDEBUG
	sigset(LVL2, SIG_DFL);
	sigset(LVL3, SIG_DFL);
	sigset(LVL4, SIG_DFL);
#else
	sigset(LVL2, siglvl);
	sigset(LVL3, siglvl);
	sigset(LVL4, siglvl);
#endif
	sigset(LVL5, siglvl);
	sigset(LVL6, siglvl);
	sigset(SINGLE_USER, siglvl);
	sigset(LVLa, siglvl);
	sigset(LVLb, siglvl);
	sigset(LVLc, siglvl);
	sigset(SIGALRM, alarmclk);
	alarmclk();
#ifdef	UDEBUG
	sigset(SIGTERM, SIG_DFL);
        sigset(SIGUSR1, abort);
	sigset(SIGUSR2, abort);
	sigset(SIGXCPU, abort);
	sigset(SIGXFSZ, abort);
#else
	sigset(SIGTERM, SIG_IGN);
        sigset(SIGUSR1, SIG_IGN);
	sigset(SIGUSR2, SIG_IGN);
	sigset(SIGXCPU, SIG_IGN);
	sigset(SIGXFSZ, SIG_IGN);
#endif
	sigset(SIGCLD, childeath);
	sigset(SIGPWR, powerfail);
	sigset(ADT_PROG,adt_runprog);			
}


/**********************/
/****    siglvl    ****/
/**********************/

void
siglvl(sig)
int sig;
{
	register struct PROC_TABLE	*process;

	/*
	 * If the signal received is a LVLQ signal, do not really
	 * change levels, just restate the current level.  If the
	 * signal is not a LVLQ, set the new level to the signal
	 * received.
	 */
	if (sig == LVLQ)
		new_state = cur_state;
	else
		new_state = sig;

	/*
	 * Clear all times and repeat counts in the process table
	 * since either the level is changing or the user has editted
	 * the inittab file and wants us to look at it again.
	 * If the user has fixed a typo, we don't want residual timing
	 * data preventing the fixed command line from executing.
	 */
	for (process = &proc_table[0]; process < &proc_table[NPROC]; process++){
		process->p_time = 0L;
		process->p_count = 0;
	}

	/*
	 * Set the flag to indicate that a "user signal" was received.
	 */
	wakeup.w_flags.w_usersignal = 1;
}


/************************/
/****    alarmclk    ****/
/************************/

void
alarmclk()
{
	time_up = TRUE;
}


/*************************/
/****    childeath    ****/
/*************************/
/* ARGSUSED */
void
childeath(signo)
int signo;
{
	register struct PROC_TABLE	*process;
	register struct pidlist		*pp;
	register pid_t			pid;
	int				status;

	/*
	 * Perform waitpid() to get the process id of any child processes
	 * that have finished and scan the process table to see if we are
	 * interested in these processes.
	 */
	while ((pid = waitpid(-1, &status, WNOHANG|WUNTRACED)) > 0) {

#ifdef	UDEBUG
		debug("childeath: pid- %ld status- %x\n", pid , status);
#endif

		for (process = &proc_table[0];
		 process < &proc_table[NPROC];
		 process++){
			if ((process->p_flags & OCCUPIED) == OCCUPIED &&
			    process->p_pid == pid) {

				/*
				 * Mark this process as having died and store
				 * the exit status.  Also set the wakeup flag
				 * for a dead child if NOCHLDWAKEUP is not set
				 * and break out of the loop.
				 */
				process->p_flags &= ~LIVING;
				process->p_exit = (short)status;
				if (!(process->p_flags & NOCHLDWAKEUP)) {
					wakeup.w_flags.w_childdeath = 1;
				}
				break;
			}
		}
		if (process == &proc_table[NPROC]) {
#ifdef	UDEBUG
			debug("Didn't find process %ld.\n", pid);
#endif

			/*
			 * No process was found above, look through auxiliary
			 * list.
			 */
			(void)sighold(SIGPOLL);
			pp = Plhead;
			while (pp) {
				if (pid > pp->pl_pid) {
					/*
			 		 * Keep on looking.
			 		 */
					pp = pp->pl_next;
					continue;
				}
				else if (pid < pp->pl_pid) {
					/*
			 		 * Not in the list.
			 		 */
					break;
				}
				else {
					/*
			 		 * This is a dead "godchild".
			 		 */
					pp->pl_dflag = 1;
					pp->pl_exit = (short)status;
					wakeup.w_flags.w_childdeath = 1;
					Gchild = 1;	/* Notice to call cleanaux(). */
					break;
				}
			}
			(void)sigrelse(SIGPOLL);
		} /* if (process not in proc_table) */
	} /* while (...waitpid...) */
}


/*************************/
/****    powerfail    ****/
/*************************/

void
powerfail()
{
	nice(-19);
	wakeup.w_flags.w_powerhit = 1;
}


/*
 * Procedure:     getlvl
 *
 * Restrictions:
                 fopen: None
                 fcntl(2): None
                 fclose: None
                 fflush: None
                 fscanf: None
*/

/*
 * Get the new run level from /dev/syscon.  If someone at /dev/systty
 * types a <del> while we are waiting for the user to start typing,
 * relink /dev/syscon to /dev/systty.
 */
int
getlvl()
{
	char	c;
	int	status, flag;
	FILE	*fp_tmp, *fp_systty;
	register int	process;
	static char levels[] = {
		LVL0,LVL1,LVL2,LVL3,LVL4,LVL5,LVL6,SINGLE_USER
	};
#ifdef DEBUG
debug("%d:getlvl():ENTER\n",getpid());
#endif

	/*
	 * fork a child who will request the new run level from  /dev/syscon.
	 */
	sighold(SIGCLD);
	while ((process = fork()) == -1)
		;
	if (process == 0) {
#ifdef DEBUG
#endif
		sigset(SIGHUP, SIG_IGN);

		/*
		 * Open /dev/systty so that if someone types a <del>,
		 * we can be informed of the fact.
		 */
		if ((fp_tmp = fopen(SYSTTY,"r+")) != NULL) {
			/*
			 * Make sure the file descriptor is greater than 2 so
			 * that it won't interfere with the standard descriptors
			 */
			fd_systty = fcntl(fileno(fp_tmp), F_DUPFD, 3);
			fp_systty = fdopen(fd_systty, "r+");
			fclose(fp_tmp);

			/*
			 * Prepare to catch the interupt signal if <del> typed
			 * at /dev/systty.
			 */
			sigset(SIGINT, switchcon);
			sigset(SIGQUIT, switchcon);
		}

#ifdef	UDEBUG
	      sigset(SIGUSR1, abort); 
	      sigset(SIGUSR2, abort); 
#endif

		for (;;) {
			/*
			 * Close the current descriptors and open
			 * ones to consdevdsf.
			 */
			opensyscon();

			/*
			 * Print something unimportant and pause, since reboot
			 * may be taking place over a line coming in over the
			 * dataswitch.  The dataswitch sometimes gets the
			 * carrier up before the connection is complete and
			 * the first write gets lost.
			 */
			fprintf(stdout,"\n");
			sleep(2);
	
           		flag = TRUE;
	   		while(flag) {

				/*
				 * Now read in the user response.
				 */
				pfmt(stdout, MM_NOSTD,
				    ":22:ENTER RUN LEVEL (0-6,s or S): ");
				fflush(stdout);

				/*
				 * Get a character from the user which isn't a
				 * space, tab or a <cr>.
				 */
				while (fscanf(stdin, "%c", &c) != 1 ||
				    c == '\n' || c == '\t' || c == ' ')
					;
				c &= 0x7f;

				/*
				 * If the character is a digit between 0 and 6
				 * or the letter S, exit with the level equal to
				 * the new desired state.
				 */
				if (c >= '0' && c <= '6') { 
					pfmt(stdout, MM_INFO,
					    ":23:will change to state %c\n", c);
					exit(levels[c - '0']);
				} else if (c == 'S' || c == 's') {
					pfmt(stdout, MM_INFO,
					    ":23:will change to state %c\n", c);
					exit(levels['7' - '0']);
				} else if (c > '6' && c <= '9') {
					pfmt(stdout, MM_ACTION,
					    ":24:\nUsage: 0123456sS\n");
					pfmt(stdout, MM_NOSTD,
					    ":25:%c is not a valid state\n\n",c);
                       			while ((fscanf(stdin, "%c", &c) != 1) ||
					    (c != '\n'))
						;
                		} else { 
					pfmt(stdout, MM_ACTION,
					    ":24:\nUsage: 0123456sS\n");
					pfmt(stdout, MM_NOSTD,
					    ":26:\nbad character <%3.3o>\n\n",c);
                       			while ((fscanf(stdin,"%c",&c) != 1) ||
					    (c != '\n'))
						;
                		}
	   		}
		}
	}

#ifdef DEBUG
#endif
	/*
	 * Wait for the child to die and return it's status.
	 */
	while (wait(&status) != process)
		;

#ifdef DEBUG
	debug("getlvl: status: %o exit: %o termination: %o\n",
	    status, (status & 0xff00)>>8, (status & 0xff));
debug("%d:getlvl():RETURN\n",getpid());
#endif

	sigrelse(SIGCLD);
	return((status & 0xff00) >> 8);
}


/*************************/
/****    switchcon    ****/
/*************************/
/* ARGSUSED */
void
switchcon(sig)
int sig;
{
	/*
	 * If this is the first time a <del> has been typed on the
	 * real/default system console device (the one associated with SYSTTY),
	 * then reset console device to the device associated with SYSTTY.
	 * Also re-establish file pointers.
	 */
	if (fd_systty != -1) {
		reset_syscon();
		opensyscon();

		/*
		 * Set fd_systty to -1 so that we ignore any deletes from it in
		 * the future as far as resetting console device to real/default
		 * system console device (the one associated with SYSTTY).
		 */
		fd_systty = -1;
	}
}


/*********************/
/****    efork    ****/
/*********************/

/*
 * efork() forks a child and the parent inserts the process in its table
 * of processes that are directly a result of forks that it has performed.
 * The child just changes the "global" with the process id for this process
 * to it's new value.
 * If efork() is called with a pointer into the proc_table it uses that slot,
 * otherwise it searches for a free slot.  Regardless of how it was called,
 * it returns the pointer to the proc_table entry
 */
struct PROC_TABLE *
efork(action, process, modes)
int	action;
register struct PROC_TABLE *process;
int	modes;
{
	register pid_t	childpid;
	register struct PROC_TABLE *proc;
	int		i;
#ifdef	UDEBUG
	static void (*oldsigs[NSIG])();
#endif

	/*
	 * Freshen up the proc_table, removing any entries for dead processes
	 * that don't have NOCLEANUP set.  Perform the necessary accounting.
	 */
	for (proc = &proc_table[0]; proc < &proc_table[NPROC]; proc++) {
		if((proc->p_flags & (OCCUPIED|LIVING|NOCLEANUP)) == (OCCUPIED)){
#ifdef	DEBUG
			debug("efork- id:%s pid: %ld time: %lo %d %o %o\n",
				C(&proc->p_id[0]), proc->p_pid, proc->p_time,
				proc->p_count, proc->p_flags, proc->p_exit);
#endif

			/*
			 * Is this a named process?
			 * If so, do the necessary bookkeeping.
			 */
			if (proc->p_flags & NAMED)
				account(DEAD_PROCESS, proc, NULL);

			/*
			 * Free this entry for new usage.
			 */
			proc->p_flags = 0;
		}
	}

	while ((childpid = fork()) == FAILURE) {
		/*
		 * Shorten the alarm timer in case someone else's child dies
		 * and free up a slot in the process table.
		 */
		setimer(5);

		/*
		 * Wait for some children to die so fork() can succeed.
		 * NOTE: Since efork() is normally called with SIGCLD blocked,
		 * release it so that child death signals can come in.
		 */
		sigrelse(SIGCLD);
		/* allow some children to die */
		pause();
		sighold(SIGCLD);
		setimer(0);
	}

	if (childpid != 0) {

		if (process == NULLPROC) {
			/*
			 * No proc table pointer specified so search
			 * for a free slot.
			 */
			for (process = &proc_table[0]; process->p_flags != 0 &&
			    process < &proc_table[NPROC]; process++)
				;

			if (process == &proc_table[NPROC]) {
				if (error_time(FULLTABLE))
				    console(MM_ERROR,
					":27:Internal process table is full\n");
				return(NO_ROOM);
			}
			process->p_time = 0L;
			process->p_count = 0;
		}
		process->p_id[0] = '\0';
		process->p_id[1] = '\0';
		process->p_id[2] = '\0';
		process->p_id[3] = '\0';
		process->p_pid = childpid;
		process->p_flags = (LIVING | OCCUPIED | modes);
		process->p_exit = 0;
	} else {
		/*
		 * Reset child's concept of its own process id.
		 */
		own_pid = getpid();

		if (action != M_WAIT)
			setpgrp();

		process = NULLPROC;

		/*
		 * Reset all signals to the system defaults,
		 * making sure that SIGXCPU and SIGXFSZ remain
		 * ignored, for backward compatibility.
		 */
#ifdef	UDEBUG
		for (i = SIGHUP; i <= SIGPWR; i++)
			oldsigs[i] = sigset(i, SIG_DFL);
#else
		for (i = SIGHUP; i <= SIGPWR; i++)
			sigset(i, SIG_DFL);
#endif
	}
	return(process);
}


/************************/
/****    waitproc    ****/
/************************/

/*
 * waitproc() waits for a specified process to die.  For this function to
 * work, the specified process must already in the proc_table.  waitproc()
 * returns the exit status of the specified process when it dies.
 */
long
waitproc(process)
register struct PROC_TABLE *process;
{
	int	answer;

	/*
	 * Wait around until the process dies.
	 */
	if (process->p_flags & LIVING)
		pause();
	if (process->p_flags & LIVING)
		return (FAILURE);

	/*
	 * Make sure to only return 16 bits so that answer will always
	 * be positive whenever the process of interest really died.
	 */
	answer = (process->p_exit & 0xffff);

	/*
	 * Free the slot in the proc_table.
	 */
	process->p_flags = 0;
	return(answer);
}


/***********************/
/****    account    ****/
/***********************/

/*
 * Procedure:     account
 *
 * Restrictions:
                 getutxid: None
                 pututxline: None
                 updwtmpx: None
*/
/*
 * account() updates entries in utmp and utmpx and appends new entries
 * new entries to the end of wtmp and wtmpx (assuming they exist).
 */
void
account(state, process, program)
short	state;
register struct PROC_TABLE *process;
char	*program;	/* Name of program if INIT_PROCESS, otherwise NULL */
{
	struct utmpx	utmpbuf;
	register struct utmpx *u, *oldu;

#ifdef	ACCTDEBUG
	debug("** account ** state: %d id:%s\n", state, C(&process->p_id[0]));
#endif

	/*
	 * Set up the prototype for the utmp structure we want to write.
	 */
	u = &utmpbuf;
	zero(&u->ut_user[0], sizeof(u->ut_user));
	zero(&u->ut_line[0], sizeof(u->ut_line));
	zero(&u->ut_host[0], sizeof(u->ut_host));

	/*
	 * Fill in the various fields of the utmp structure.
	 */
	u->ut_id[0] = process->p_id[0];
	u->ut_id[1] = process->p_id[1];
	u->ut_id[2] = process->p_id[2];
	u->ut_id[3] = process->p_id[3];
	u->ut_pid = process->p_pid;

	/*
	 * Fill the "ut_exit" structure.
	 */
	u->ut_exit.e_termination = process->p_exit & 0xff;
	u->ut_exit.e_exit = process->p_exit >> 8 & 0xff;
	u->ut_type = state;
	time(&u->ut_tv.tv_sec);

	/*
	 * See if there already is such an entry in the "utmp" file.
	 */
	setutxent();	/* Start at beginning of utmp file. */

	if ((oldu = getutxid(u)) != NULL) {
		/*
		 * Copy in the old "user", "line" and "host" fields
		 * to our new structure.
		 */
		bcopy(&oldu->ut_user[0], &u->ut_user[0], sizeof(u->ut_user));
		bcopy(&oldu->ut_line[0], &u->ut_line[0], sizeof(u->ut_line));
		bcopy(&oldu->ut_host[0], &u->ut_host[0], sizeof(u->ut_host));
#ifdef	ACCTDEBUG
		debug("New entry in utmp file.\n");
#endif
	}
#ifdef	ACCTDEBUG
	else debug("Replacing old entry in utmp file.\n");
#endif

	/*
	 * Perform special accounting. Insert the special string into the
	 * ut_line array. For INIT_PROCESSes put in the name of the
	 * program in the "ut_user" field.
	 */
	switch(state) {

	case RUN_LVL:
		u->ut_exit.e_termination = level(cur_state);
		if (program != NULL && oldu != NULL && *program == 'S')
			u->ut_exit.e_exit = oldu->ut_exit.e_termination;
		else
			u->ut_exit.e_exit = level(prior_state);

		u->ut_pid = n_prev[cur_state];
		sprintf(&u->ut_line[0], RUNLVL_MSG, level(cur_state));
		break;

	case BOOT_TIME:
		sprintf(&u->ut_line[0], "%.12s",BOOT_MSG);
		break;

	case INIT_PROCESS:
		strncpy(&u->ut_user[0], program, sizeof(u->ut_user));
		break;

	default:
		break;
	}

	/*
	 * Write out the updated entry to utmp file.
	 */
	if (pututxline(u) == (struct utmpx *)NULL)
		console(MM_ERROR,
		    ":28:failed write of utmpx entry:\"%2.2s\"\n",&u->ut_id[0]);
	endutxent();

	/*
	 * Now attempt to add to the end of the wtmp and wtmpx files.
	 */
	updwtmpx(WTMPX, u);
}


/*************************/
/****    prog_name    ****/
/*************************/

/*
 * prog_name() searches for the word or unix path name and
 * returns a pointer to the last element of the pathname.
 */
char *
prog_name(string)
register char *string;
{
	register char	*ptr, *ptr2;
	struct utmp	*dummy;	/* Used only to get size of ut_user */
	static char word[sizeof(dummy->ut_user) + 1];

	/*
	 * Search for the first word skipping leading spaces and tabs.
	 */
	while (*string == ' ' || *string == '\t')
		string++;

	/*
	 * If the first non-space non-tab character is not one allowed in
	 * a word, return a pointer to a null string, otherwise parse the
	 * pathname.
	 */
	if (*string != '.' && *string != '/' && *string != '_' &&
	    !isalnum((int)*string))
		return("");

	/*
	 * Parse the pathname looking forward for '/', ' ', '\t', '\n' or
	 * '\0'.  Each time a '/' is found, move "ptr" to one past the
	 * '/', thus when a ' ', '\t', '\n', or '\0' is found, "ptr" will
	 * point to the last element of the pathname.
	 */
	for (ptr = string;
	    *string !=' ' && *string !='\t' && *string !='\n' && *string !='\0';
	    string++) {
		if (*string == '/')
			ptr = string+1;
	}

	/*
	 * Copy out up to the size of the "ut_user" array into "word",
	 * null terminate it and return a pointer to it.
	 */
	for (ptr2 = &word[0];
	    ptr2 < &word[sizeof(dummy->ut_user)] && ptr < string;)
		*ptr2++ = *ptr++;

	*ptr2 = '\0';
	return(&word[0]);
}


/*
 * Procedure:     opensyscon
 *
 * Restrictions:
                 fclose: None
                 fopen: None
                 setbuf: None
                 ioctl(2): None
*/

/*
 * opensyscon() opens stdin, stdout, and stderr, making sure
 * that their file descriptors are 0, 1, and 2, respectively.
 */
void
opensyscon()
{
	register FILE	*fp;
#ifdef DEBUG
debug("%d:opensyscon():ENTER\n",getpid());
#endif

	fclose(stdin);
	fclose(stdout);
	fclose(stderr);
	close(0);
	close(1);
	close(2);

#ifdef DEBUG
debug("opensyscon():consdevdsf = %s\n",consdevdsf);
#endif
	if ((fp = fopen(consdevdsf,"r+")) == NULL) {
		/*
		 * If the open fails, switch back to real/default system
		 * console device (associated with SYSTTY).
		 */
#ifdef DEBUG
#endif
		reset_syscon();
		fp = fopen(consdevdsf,"r+");
	}

	(void)fdup(fp);
	(void)fdup(fp);
	setbuf(fp, NULL);
	setbuf(stdout, NULL);
	setbuf(stderr, NULL);

	/*
	 * Save the current consdevdsf modes and restore the modes stored in
	 * termio (modes from the IOCTL.SYSCON file or default modes).
	 * The current modes will be restored by console() after the
	 * message is printed.
	 */
	fioctl(fp, TCGETA, &curterm);

	/*
	 * If the baud rate is B0, reset it to the default baud rate.
	 */
	if ((curterm.c_cflag & CBAUD) == B0){
		curterm.c_cflag &= ~CBAUD;
		curterm.c_cflag |= dflt_termio.c_cflag & CBAUD;
	}


	if (realcon386()) {
		/*
		 * Don't overwrite cflag when init console is real console.
		 */
		termio.c_cflag = curterm.c_cflag;
	}
	termio.c_cflag &= ~HUPCL;	/* Make sure hangup on close is off. */
	fioctl(fp, TCSETA, &termio);
#ifdef DEBUG
debug("%d:opensyscon():RETURN\n",getpid());
#endif
	return;
}


/*********************************/
/****      realcon386         ****/
/*********************************/
int 
realcon386()
{
	struct	stat	consdevdsfbuf, consolebuf, tty00buf;
	int baud;
	int fd;
	struct	tp_info	tpinf;
	int		ret = 1;

	stat(consdevdsf, &consdevdsfbuf);
	stat(SYSTTY, &consolebuf);
	stat(TTY00, &tty00buf);
	/* if any of the previous system calls failed there is nothing
	 * sensible to do!
	 */

	if ((tpmajornum != (major_t)NODEV) && (tponconsole == TRUE)){
		fd = open(consdevdsf, O_RDWR|O_NONBLOCK|O_NOCTTY);
		if (tp_fgetinf(fd, &tpinf) == -1){
#ifdef DEBUG
			tp_geterror(&tperrno, sizeof(tperrormsg), tperrormsg);
			debug("realcon386:Can not determine if console device is the real default console device\n%s; errno = %d:%s\n",
			 tperrormsg, tperrno, strerror(tperrno));
#endif
			ret = 0;
		}else{
			consdevdsfbuf.st_rdev = tpinf.tpinf_rdev;
		}
		(void)close(fd);
	}
	if (consolebuf.st_rdev == consdevdsfbuf.st_rdev){
		termio.c_cflag = curterm.c_cflag;
	}else if (tty00buf.st_rdev == consdevdsfbuf.st_rdev){
		;
	}else{
		ret = 0;
	}

	/* ensure sane port settings */
	termio.c_iflag |= ICRNL;
	termio.c_oflag |= (OPOST | ONLCR);
	termio.c_lflag |= (ICANON | ECHO);

	return (ret);
}



/*
 * Procedure:     get_ioctl_syscon
 *
 * Restrictions:
                 fopen: None
                 fscanf: None
                 fclose: None
*/
/*
 * get_ioctl_syscon() retrieves the consdevdsf settings from the
 * IOCTLSYSCON file.
 */
void
get_ioctl_syscon()
{
	register FILE	*fp;
	unsigned int	iflags, oflags, cflags, lflags, ldisc, cc[8];
	int		i, valid_format = 0;

	/*
	 * Read in the previous modes for SYSCON from IOCTLSYSCON.
	 */
	if ((fp = fopen(IOCTLSYSCON, "r")) == NULL) {
		console(MM_WARNING,
		    ":29:%s does not exist, default settings assumed\n",
			IOCTLSYSCON);
		reset_syscon();
	} else {

		i = fscanf(fp,"%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x",
		    &iflags, &oflags, &cflags, &lflags, &ldisc, &cc[0], &cc[1],
		    &cc[2], &cc[3], &cc[4], &cc[5], &cc[6], &cc[7]);

		/*
		 * If the file is formatted properly, use the values to
		 * initialize the console terminal condition.
		 */
		if (i == 13) {
			termio.c_iflag = (ushort) iflags;
			termio.c_oflag = (ushort) oflags;
			termio.c_cflag = (ushort) cflags;
			termio.c_lflag = (ushort) lflags;
			termio.c_line = (char) ldisc;
			for(i = 0; i < 8; i++)
				termio.c_cc[i] = (char) cc[i];
			valid_format = 1;
		} 
		fclose(fp);

		/*
		 * If the file is badly formatted, use the default settings.
		 */
		if (!valid_format)
			reset_syscon();
	}
}


/*
 * Procedure:     reset_syscon
 *
 * Restrictions:
                 fopen: None
                 lvlin: None
                 lvlfile(2): None
                 fclose: None
*/


/*
 * Switch the console back to the default system console device SYSTTY and
 * set the default ioctl settings back into IOCTLSYSCON and the incore arrays.
 *
 * If the root file system has not been verified, do not perform the switch
 * or set the ioctl settings.
 * NOTE: The code has been implemented such that this function should not be
 * called before the root file system has been verified.
 *
 * If TP is configured on the system, tpswitchcons() will switch the console
 * back to SYSTTY.  tpswitchcons() informs TP via a TP ioctl on consdevdsf to
 * switch the console device.
 * If TP is not configured on the system, SYSCON is relinked to SYSTTY.
 */
void
reset_syscon()
{
	register FILE	*fp;
	level_t		maclevel;
	struct tp_info	tpinf;
	int		ctrlfd;
#ifdef DEBUG
debug("%d:reset_syscon():ENTER\n",getpid());
#endif

	if (rootfs_verified != TRUE){
		return;
	}
	if (tpmajornum != (major_t)NODEV){
		devtab[DTTAG_SYSCONREAL].dt_major =
		 devtab[DTTAG_SYSTTY].dt_major;
		devtab[DTTAG_SYSCONREAL].dt_minor =
		 devtab[DTTAG_SYSTTY].dt_minor;
		devtab[DTTAG_SYSCONREAL].dt_linkdsfname =
		 devtab[DTTAG_SYSTTY].dt_dsfname;
		devtab[DTTAG_SYSCONREAL].dt_action = dtaLINK;
		devtab[DTTAG_SYSTTY].dt_action = dtaMKNOD;
		devtab[DTTAG_TP_CONSDEV].dt_action = dtaMKNOD;
		devtab[DTTAG_CONSOLE].dt_action = dtaLINK;
		devtab[DTTAG_SYSCON].dt_action = dtaLINK;
		devtab[DTTAG_TP_ADMDEV].dt_action = dtaMKNOD;
		(void)update_devtab();
		consdevdsf = CONSOLE;
		/*
		 * If something fails here, either something is seriously wrong
		 * with the system, or someone or some process is removing DSF
		 * listed in devtab.  In either case there is not much we
		 * can do.
		 */
		if (tpswitchcons(SYSTTY, 0, &tpinf, (char *)NULL,
		 (size_t)0) == SUCCESS){
			/*
		 	* If SYSTTY is not linked under a TP device, setup
			* a TP device for SYSTTY.
		 	*/
			if (tpinf.tpinf_muxid == 0){
				/*
				 * Nothing useful we can do if this fails.
				 */
				ctrlfd = opentpdev(SYSTTY, TPINF_CONSOLE,
				 &tpinf, (char *)NULL, (size_t)0);
				(void)close(ctrlfd);
			}
		}
	}else{
		devtab[DTTAG_SYSCON].dt_major = devtab[DTTAG_SYSTTY].dt_major;
		devtab[DTTAG_SYSCON].dt_minor = devtab[DTTAG_SYSTTY].dt_minor;
		devtab[DTTAG_SYSCON].dt_linkdsfname = SYSTTY;
		devtab[DTTAG_SYSCON].dt_action = dtaLINK;
		devtab[DTTAG_SYSCON].dt_action = dtaLINK;
		devtab[DTTAG_CONSOLE].dt_action = dtaLINK;
		devtab[DTTAG_SYSTTY].dt_action = dtaMKNOD;
		(void)update_devtab();
		consdevdsf = SYSCON;
	}
	fp = fopen(IOCTLSYSCON, "w");

	if (macinstalled == TRUE){
		(void)lvlin("SYS_PRIVATE", &maclevel);
		(void)lvlfile("IOCTLSYSCON", MAC_SET, &maclevel);
	}

	bcopy((char *)&dflt_termio, (char *)&termio, sizeof(struct termio));
	fprintf(fp, "%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x\n", termio.c_iflag,
	    termio.c_oflag, termio.c_cflag, termio.c_lflag, termio.c_line,
	    termio.c_cc[0], termio.c_cc[1], termio.c_cc[2], termio.c_cc[3],
	    termio.c_cc[4], termio.c_cc[5], termio.c_cc[6], termio.c_cc[7]);
	fclose(fp);
	umask(0);
#ifdef DEBUG
debug("%d:reset_syscon():RETURN\n",getpid());
#endif
}


/*
 * Procedure:     reset_modes
 *
 * Restrictions:
                 fopen: None
                 ioctl(2): None
                 fclose: None
                 fscanf: None
*/
/*
 * reset_modes() makes sure the proper terminal modes are set so init can
 * continue talking to consdevdsf after coming down to single user and after
 * rebooting.  It must see that the proper modes are set in the driver,
 * init's in-core termio structure, and the ioctl.syscon file.
 */
void
reset_modes()
{
	register FILE	*fp;
	register struct PROC_TABLE *process;
	struct termio	tio;
	ushort		curcflag = 0;
	int		i;
	unsigned int	iflags, oflags, cflags, lflags, ldisc, cc[8];

	sighold(SIGCLD);
	while ((process = efork(M_OFF, NULLPROC, NOCLEANUP)) == NO_ROOM)
		timer(2);
	sigrelse(SIGCLD);

	if (process == NULLPROC) {
		if ((fp = fopen(consdevdsf,"w")) == NULL) {
			console(MM_ERROR,
			    ":30:Unable to open %s\n", consdevdsf);
		} else {
			if (fioctl(fp, TCGETA, &tio) != FAILURE) {
				curcflag = tio.c_cflag;
				/*
				 * Clear HUPCL in the driver.
				 */
				tio.c_cflag &= ~HUPCL;
				fioctl(fp, TCSETA, &tio);
			}
			fclose(fp);
		}

		if ((fp = fopen(IOCTLSYSCON, "r")) != NULL) {
			/*
			 * Update the in-core termio structure so it agrees
			 * with the ioctl.syscon file.  Better sanity checking
			 * should probably be done here on the ioctl.syscon
			 * data.
			 */
			if (fscanf(fp,"%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x",
			    &iflags, &oflags, &cflags, &lflags, &ldisc, &cc[0],
			    &cc[1], &cc[2], &cc[3], &cc[4], &cc[5], &cc[6],
			    &cc[7]) == 13) {
				termio.c_iflag = (ushort) iflags;
				termio.c_oflag = (ushort) oflags; 
				termio.c_cflag = (ushort) cflags;
				termio.c_lflag = (ushort) lflags;
				termio.c_line = (char) ldisc;
				for(i = 0; i < 8; i++)
					termio.c_cc[i] = (char) cc[i];
			} 
			fclose(fp);
		}
           	if (!realcon386() && curcflag != 0)  {
			termio.c_cflag = curcflag;
		}

		umask(~0644);
		if ((fp = fopen(IOCTLSYSCON, "w")) == NULL) {
			console(MM_ERROR,
			    ":31:Cannot open %s. errno: %d\n",IOCTLSYSCON,errno);
		} else {
			fprintf(fp, "%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x\n",
			    termio.c_iflag, termio.c_oflag, termio.c_cflag,
		 	    termio.c_lflag, termio.c_line, termio.c_cc[0],
			    termio.c_cc[1], termio.c_cc[2], termio.c_cc[3],
			    termio.c_cc[4], termio.c_cc[5], termio.c_cc[6],
			    termio.c_cc[7]);
			fclose(fp);
		}
		termio.c_cflag &= ~HUPCL;
		exit(0);
	} else {
		/*
		 * The parent waits for the child to die.
		 */
		while (waitproc(process) == FAILURE)
			;
	}
}


/*
 * Procedure:     console
 *
 * Restrictions:
                 setbuf: None
                 fflush: None
                 ioctl(2): None
*/

/*
 * console() forks a child if it finds that it is the main "init" and outputs
 * the requested message to the system console.	 Note that the number of
 * arguments passed to console() is determined by the print format.
 *
 * NOTE: The following list of functions are directly or indirectly called
 * from this function.  They should not call the function console() or any
 * other function that may directly or indirectly call console, since it may
 * cause an infinite call loop to console() if one of the code pathes from
 * console() is failing.
 *	efork(), write_messge(), opensyscon(), reset_syscon(),
 *	realcon386(), tpswitchcons(), opentpdev(), update_devtab(), and
 *	setup_consdev()
 */
/* PRINTFLIKE1 */
void
console(severity, format, arg1, arg2, arg3, arg4)
long	severity;
char	*format;
int	arg1, arg2, arg3, arg4;
{
	register struct PROC_TABLE *process;
	char	outbuf[BUFSIZ];
#ifdef DEBUG
debug("%d:console():ENTER\n",getpid());
#endif

	if (own_pid == SPECIALPID) {
#ifdef DEBUG
#endif
		/*
		 * We are the original "init" so we fork a child to do the
		 * printing for us.
		 * Set NOCHLDWAKEUP since the child to be forked is not from
		 * an entry in the inittab file.  Do not want to notify
		 * init's main processing loop when this child dies since it may
		 * cause loop to become infinite if console() is persistently
		 * called via any code path in init's main processing loop.
		 */
		sighold(SIGCLD);
		while ((process =
		 efork(M_OFF, NULLPROC, NOCLEANUP|NOCHLDWAKEUP)) == NO_ROOM)
			timer(5);
		sigrelse(SIGCLD);
		if (process == NULLPROC) {
#ifdef	UDEBUG
			sigset(SIGUSR1, abort);
			sigset(SIGUSR2, abort);
#endif
           		write_message(severity,
				format, arg1, arg2, arg3, arg4);
			exit(0);
		} else {
			while ( waitproc(process) == FAILURE)
				;
		}

	} else {
#ifdef DEBUG
#endif
		write_message(severity, format, arg1, arg2, arg3, arg4);
	}

#ifdef	ACCTDEBUG
	debug(format, arg1, arg2, arg3, arg4);
#endif

#ifdef DEBUG
debug("%d:console():RETURN\n",getpid());
#endif
}

/*****************************/
/****    write_message    ****/
/*****************************/
write_message(severity, format, arg1, arg2, arg3, arg4)
long severity;
char *format;
int arg1, arg2, arg3, arg4;
{
	FILE *fp;
	int fd;
	int write_to_syscon;
	struct stat console_stat_buf, syscon_stat_buf, tty00_stat_buf;
	char *fpfmt = format;
	char fp_catalog[] = "uxinit_msg";

	/* 
	 * if /dev/syscon and /dev/console are the same, only write to /dev/sysmsg
	 * else if /dev/syscon and /dev/tty00 are the same 
	 *	only write to /dev/sysmsg
	 * else write to both /dev/sysmsg and /dev/syscon
	 */

	write_to_syscon = 1;
	stat(SYSTTY, &console_stat_buf);
	stat(SYSCON, &syscon_stat_buf);

	if (console_stat_buf.st_rdev == syscon_stat_buf.st_rdev)
		write_to_syscon = 0;
	else if (stat(TTY00, &tty00_stat_buf) != -1)
	{
		if ((fd = open(SYSMSG, O_WRONLY)) != -1)
		{
			close(fd);

			if (syscon_stat_buf.st_rdev == tty00_stat_buf.st_rdev )
				write_to_syscon = 0;
		}
	}

	if ((fp = fopen(SYSMSG, "w")) != NULL)
	{
		if(!(severity & MM_NOGET))
			fpfmt = strcat(fp_catalog, format);
		pfmt(fp, severity, fpfmt, arg1, arg2, arg3, arg4);
		fclose(fp);
	}

	if (write_to_syscon)
	{
		opensyscon();

		pfmt(stdout, severity, format, arg1, arg2, arg3, arg4);
		fflush(stdout);

		/*Restore the setting saved in opensyscon()*/
		fioctl (stdout, TCSETAW, &curterm);
	}

}


/**************************/
/****    error_time    ****/
/**************************/

/*
 * error_time() keeps a table of times, one for each type of error that it
 * handles.  If the current entry is 0 or the elapsed time since the last error
 * message is large enough, error_time() returns TRUE, else it returns FALSE.
 */
int
error_time(type)
register int	type;
{
	long	curtime;

	time(&curtime);
	if (err_times[type].e_time == 0 ||
	    curtime - err_times[type].e_time >= err_times[type].e_max) {
		err_times[type].e_time = curtime;
		return(TRUE);
	} else {
		 return(FALSE);
	}
}


/*********************/
/****    timer    ****/
/*********************/

/*
 * timer() is a substitute for sleep() which uses alarm() and pause().
 */
void
timer(waitime)
register int	waitime;
{
	setimer(waitime);
	while (time_up == FALSE)
		pause();
}


/***********************/
/****    setimer    ****/
/***********************/

void
setimer(timelimit)
int	timelimit;
{
	alarmclk();
	alarm(timelimit);
	time_up = (timelimit ? FALSE : TRUE);
}


/********************/
/****    zero    ****/
/********************/

void
zero(adr, size)
register char	*adr;
register int	size;
{
	while (size--)
		*adr++ = '\0';
}

/*
 * Procedure:     userinit
 *
 * Restrictions:
                 auditdmp(2): None
                 open(2): None
                 ttyname: None
                 stat(2): None
                 unlink(2): None
                 link(2): None
                 fopen: None
                 fclose: None
                 kill(2): None
*/

/*
 * Function to handle requests from users to main init running as process 1.
 */
void
userinit(argc, argv)
int	argc;
char	**argv;
{
		FILE		*fp;
		char		*userttydsf;
		int		saverr;
		int		init_signal;
		int		fd;
		int		statret = 0;
		struct stat	consdevdsfbuf;
		struct stat	userttydsfbuf;
		struct tp_info	tpinf;
		char		lerrbuf[ERRBUFSZ]={'\0'};
	static	char		*cmdline=(char *)0;
        FILE    *tpath_fp;
        char    *tpath_ptr;

#ifdef DEBUG
debug("%d:userinit():ENTER\n",getpid());
#endif

	/* save command line arguments for audit record */
	if (( cmdline = (char *)argvtostr(argv)) == NULL)
		/* This should never happen! */
                (void) pfmt(stderr, MM_ERROR,
			":32:failed argvtostr\n");
	arec.rtype = ADT_INIT;
	arec.rsize = strlen(cmdline);
	arec.argp = cmdline;

	/*
	 * We are a user invoked init.  Is there an argument and is it
	 * a single character?  If not, print usage message and quit.
	 */
	if (argc != 2 || argv[1][1] != '\0') {
		pfmt(stderr, MM_ACTION,
			":33:Usage: init [0123456SsQqabc]\n");
		arec.rstatus = 1;
		auditdmp(&arec, sizeof(arec_t));
		exit(0);
	}

	switch (argv[1][0]) {

	case 'Q':
	case 'q':
		init_signal = LVLQ;
		break;

	case '0':
		init_signal = LVL0;
		break;

	case '1':
		init_signal = LVL1;
		break;

	case '2':
		init_signal = LVL2;
		break;

	case '3':
		init_signal = LVL3;
		break;

	case '4':
		init_signal = LVL4;
		break;

	case '5':
		init_signal = LVL5;
		break;

	case '6':
		init_signal = LVL6;
		break;

	case 'S':
	case 's':
#ifdef DEBUG
#endif

		/*
		 * Initialize all global variables needed for init s.
		 * 
		 * Get Major Device number for Trusted Path.  This also
		 * determines whether or not TP is configured in the system.
		 * Initialize entries in devtab.
		 * Verify existence of the DSFs listed in the devtab.
		 */
#ifndef NO_TPCONS
		(void)secsys(ES_TPGETMAJOR, (char *)&tpmajornum);
        	if (tpmajornum != (major_t)NODEV) {
                	/*
                 	* the only way we will allow a TP-deconfig is if mac is
                 	* not installed and there is a /etc/default/tpath file
                 	* with a TP_DEFAULT=no entry.
                 	*/
                	if(!macinstalled &&
                   	((tpath_fp = defopen(DEFLT_TPATH_FILE)) != (FILE *)NULL) &&
                   	((tpath_ptr = defread(tpath_fp, TPNAME)) != (char *)NULL) &&
                   	((strcmp(tpath_ptr, NO_U) == 0) ||
                    	(strcmp(tpath_ptr, NO_L) == 0))) {
                        	tpmajornum = (major_t)NODEV;
                	}
        	}
#endif
		initialize_devtab();
		verify_devtab();

		/*
		 * Get the current console device, based on the devices that
		 * have been verified in devtab.
		 */
		if (tpmajornum != (major_t) NODEV){
			if (devtab[DTTAG_CONSOLE].dt_status == dtsVERIFIED){
				consdevdsf = devtab[DTTAG_CONSOLE].dt_dsfname;
			}else if (devtab[DTTAG_SYSCON].dt_status == dtsVERIFIED){
				consdevdsf = devtab[DTTAG_SYSCON].dt_dsfname;
			}else if (devtab[DTTAG_TP_CONSDEV].dt_status == dtsVERIFIED){
				consdevdsf = devtab[DTTAG_TP_CONSDEV].dt_dsfname;
			}else{
				/*
				 * if SYSTTY does not exist, consdevdsf
				 * is set to SYSTTY as a place holder.
				 */
				consdevdsf = devtab[DTTAG_SYSTTY].dt_dsfname;
			}
			/*
			 * If TP is not on the 'console' DSF, assume current
			 * 'console' device is SYSTTY.
			 * NOTE: If consdevdsf is == to SYSTTY and the
			 * real console device is linked under a TP device,
			 * threre is nothing else that should be done to get
			 * the 'console' device.
			 * We do not try to fix problems (eg via mknod(2) and
			 * links(2) with what is defined as console device.
			 * This is left up to the user and/or the 'real' init
			 * process to fix.
			 */
			if (strcmp(consdevdsf, SYSTTY) != 0){
				fd = open(consdevdsf, O_RDWR|O_NONBLOCK|O_NOCTTY);
				if ((tp_fgetinf(fd, &tpinf) == -1) ||
			 	(tpinf.tpinf_muxid == 0)){
					consdevdsf = SYSTTY;
				}
				(void)close(fd);
			}
		}else{
			if ((fd = open(SYSCON, O_RDWR|O_NONBLOCK|O_NOCTTY))
			 == -1){
				if (devtab[DTTAG_CONSOLE].dt_status ==
				 dtsVERIFIED){
					consdevdsf =
					 devtab[DTTAG_CONSOLE].dt_dsfname;
				}else{
					/*
					 * if SYSTTY does not exist, consdevdsf
					 * is set to SYSTTY as a place holder.
					 */
					consdevdsf =
					 devtab[DTTAG_SYSTTY].dt_dsfname;
				}
			}else{
				consdevdsf = SYSCON;
				(void)close(fd);
			}
		}


		/*
		 * Make sure this process is talking to a legal tty line
		 * and that consdevdsf is associated with this line.
		 */
		if (tpmajornum != (major_t)NODEV){
			userttydsf = getttyname(0, 0);
		}else{
			userttydsf = ttyname(0);
		}
		if (userttydsf == NULL) {
			pfmt(stderr, MM_ERROR,
				":34:Standard input not a tty line\n");
			arec.rstatus = 1;
			auditdmp(&arec, sizeof(arec_t));
			exit(1);
		}

		if (tpmajornum != (major_t)NODEV){
			if (strcmp(consdevdsf, SYSTTY) != 0){
				fd = open(consdevdsf, O_RDWR|O_NONBLOCK|O_NOCTTY);
				if ((tp_fgetinf(fd, &tpinf) == -1) ||
			 	(tpinf.tpinf_muxid == 0)){
					statret = -1;
				}else{
					consdevdsfbuf.st_rdev =
					 tpinf.tpinf_rdev;
				}
				(void)close(fd);
			}else if (stat(consdevdsf, &consdevdsfbuf) == -1){
				statret = -1;
			}
		}else{
			if (stat(consdevdsf, &consdevdsfbuf) == -1){
				statret = -1;
			}
		}

		if ((statret != -1) &&
		    (stat(userttydsf, &userttydsfbuf)) != -1 &&
		    (userttydsfbuf.st_rdev != consdevdsfbuf.st_rdev)){
			if (tpmajornum != (major_t)NODEV){
				/*
				 * Unlink SYSCONREAL and link it to the users
				 * tty device (userttydsf).  Call tpswitchcons()
				 * to switch console device to userttydsf.
				 */
				if (unlink(SYSCONREAL) == FAILURE){
					pfmt(stderr, MM_ERROR,
					    ":35:Can not unlink %s:%s\n",
						SYSCONREAL, strerror(errno));
					arec.rstatus = 1;
					auditdmp(&arec, sizeof(arec_t));
					exit(1);
				}
				if (link(userttydsf, SYSCONREAL) == FAILURE){
					pfmt(stderr, MM_ERROR,
					    ":36:Can not link %s to %s:%s\n",
						userttydsf, SYSCONREAL,
						strerror(errno));
					arec.rstatus = 1;
					auditdmp(&arec, sizeof(arec_t));
					exit(1);
				}
				/*
				 * Try to leave a message on previous console
				 * device that console device is going to
				 * be switched.
				 */
				if ((fp = fopen(consdevdsf, "r+")) !=
				 (FILE *)NULL){
					pfmt(fp, MM_INFO,
					 ":66:\n***	SYSCON CHANGING TO %s	***\n",
					 userttydsf);
					(void)fclose(fp);
				}
				if (tpswitchcons(userttydsf, TPINF_ONLYIFLINKED,
				 &tpinf, (char *)NULL, (size_t)0) == FAILURE){
					if ((fp = fopen(consdevdsf, "r+")) !=
					 (FILE *)NULL){
						pfmt(fp, MM_ERROR,
						 ":37:Switching Console failed, Console remaining on %s\n",
						 sttyname(consdevdsf));
						(void)fclose(fp);
					}
					pfmt(stderr, MM_ERROR,
					    ":37:Switching Console failed, Console remaining on %s\n",
						sttyname(consdevdsf));
					(void)unlink(SYSCONREAL);
					(void)link(SYSTTY, SYSCONREAL);
					arec.rstatus = 1;
					auditdmp(&arec, sizeof(arec_t));
					exit(1);
				}

			}else{
				/*
				 * Unlink /dev/syscon and relink it to the
				 * current line.
				 */
				if (unlink(SYSCON) == FAILURE) {
					pfmt(stderr, MM_ERROR,
					    ":38:Cannot unlink /dev/syscon: %s\n",
						strerror(errno));
					arec.rstatus = 1;
					auditdmp(&arec, sizeof(arec_t));
					exit(1);
				}
				if (link(userttydsf, SYSCON) == FAILURE) {
					saverr = errno;
					pfmt(stderr, MM_ERROR,
					    ":39:Cannot link /dev/syscon to %s",
						userttydsf);
					errno = saverr;
					pfmt(stderr, MM_ERROR|MM_NOGET,
						" %s\n",strerror(errno));
					link(SYSTTY,SYSCON); /* Try to leave a syscon */
					arec.rstatus = 1;
					auditdmp(&arec, sizeof(arec_t));
					exit(1);
				}

				/*
				 * Try to leave a message on system console
				 * saying where /dev/syscon is currently
				 * connected.
				 */
				if ((fp = fopen(SYSTTY, "r+")) != NULL) {
					pfmt(fp, MM_INFO,
					    ":67:\n****	SYSCON CHANGED TO %s	****\n",
					    userttydsf);
					fclose(fp);
				}
			}
		}
		init_signal = SINGLE_USER;
		break;

	case 'a':
		init_signal = LVLa;
		break;

	case 'b':
		init_signal = LVLb;
		break;

	case 'c':
		init_signal = LVLc;
		break;

	default:
		pfmt(stderr, MM_ACTION,
			":33:Usage: init [0123456SsQqabc]\n");
		arec.rstatus = 1;
		auditdmp(&arec, sizeof(arec_t));
		exit(1);
	}

	/*
	 * Now send signal to main init and then exit.
	 */
	if (kill(SPECIALPID, init_signal) == FAILURE) {
		pfmt(stderr, MM_ERROR,
			":40:Must be privileged user\n");
		arec.rstatus = 1;
		auditdmp(&arec, sizeof(arec_t));
#ifdef DEBUG
debug("%d:userinit():RETURN\tkill FAILED\n",getpid());
#endif
		exit(1);
	} else {
		arec.rstatus = 0;
		auditdmp(&arec, sizeof(arec_t));
#ifdef DEBUG
debug("%d:userinit():RETURN\tkill SUCCEEDED\n",getpid());
#endif
		exit(0);
	}
}


/*********************/
/****    bcopy    ****/
/*********************/

void
bcopy(from, to, size)
register char	*from, *to;
register int	size;
{
	while (size--)
		*to++ = *from++;
}


/********************/
/****    fdup    ****/
/********************/

FILE *
fdup(fp)
register FILE	*fp;
{
	register int	newfd;
	register char	*mode;

	/*
	 * Dup the file descriptor for the specified stream and then convert
	 * it to a stream pointer with the modes of the original stream pointer.
	 */
	if ((newfd = dup(fileno(fp))) != FAILURE) {

		/*
		 * Determine the proper mode.  If the old file was _IORW, then
		 * use the "r+" option, if _IOREAD, the "r" option, or if _IOWRT
		 * the "w" option.  Note that since none of these force an lseek
		 * by fdopen(), the duped file pointer will be at the same spot
		 * as the original.
		 */
		if (fp->_flag & _IORW) {
			mode = "r+";
		} else if (fp->_flag & _IOREAD) {
			mode = "r";
		} else if (fp->_flag & _IOWRT) {
			mode = "w";
		} else {
			/*
			 * Something is wrong.
			 */
			close(newfd);
			return(NULL);
		}

		/*
		 * Now have fdopen() finish the job of establishing
		 * a new file pointer.
		 */
		return(fdopen(newfd, mode));

	} else {
		return(NULL);
	}
}


#ifdef	UDEBUG

/*************************/
/****    drop_core    ****/
/*************************/

void
drop_core(reason)
char	*reason;
{
	FILE	*fp;

	sighold(SIGCLD);
	if (efork(M_OFF, NULLPROC, 0) != NULLPROC)
		return;
	sigrelse(SIGCLD);

	/*
	 * Tell user where core is going to be.
	 */
	if ((fp = fopen(CORE_RECORD, "a+")) == NULL) {
		console(MM_ERROR,
		    ":41:Could not open \"%s\".\n", CORE_RECORD);
	} else {
		fprintf(fp, "core.%05d: \"%s\"\n", getpid(), reason);
		fclose(fp);
	}
	sigset(SIGIOT, SIG_DFL);
	abort();
}

#endif


#ifdef DEBUGGER

/*********************/
/****    debug    ****/
/*********************/

void
debug(format, arg1, arg2, arg3, arg4, arg5, arg6)
char	*format;
int	arg1, arg2, arg3, arg4, arg5, arg6;
{
	register FILE	*fp;
	register int	errnum;

	if ((fp = fopen(DBG_FILE, "a+")) == NULL) {
		errnum = errno;
		console("Can't open \"%s\".  errno: %d\n", DBG_FILE, errnum);
		return;
	}
	fprintf(fp, format, arg1, arg2, arg3, arg4, arg5, arg6);
	fclose(fp);
}


/*****************/
/****    C    ****/
/*****************/

char *
C(id)
register char	*id;
{
	static char	answer[12];
	register char	*ptr;
	register int	i;

	for (i = 4, ptr = &answer[0]; --i >= 0; id++) {
		if (isprint(*id) == 0 ) {
			*ptr++ = '^';
			*ptr++ = *id + 0100;
		} else {
			 *ptr++ = *id;
		}
	}
	*ptr++ = '\0';
	return(&answer[0]);
}

#endif


/*
 * Procedure:     sigpoll
 *
 * Restrictions:
                 read(2): None
*/

#define DELTA	25	/* Number of pidlist elements to allocate at a time */

/* ARGSUSED */
void
sigpoll(n)
int	n;
{
	struct pidrec prec;
	register struct pidrec *p = &prec;
	register struct pidlist *plp;
	register struct pidlist *tp, *savetp;
	register int i;

	if (Pfd < 0) {
		return;
	}
	sighold(SIGCLD);
	for (;;) {
		/*
		 * Important Note: Either read will really fail (in which case
		 * return is all we can do) or will get EAGAIN (Pfd was opened
		 * O_NDELAY), in which case we also want to return.
		 * Always return from here!
		 */
		if (read(Pfd,p,sizeof(struct pidrec)) != sizeof(struct pidrec)){
			sigrelse(SIGCLD);
			return;
		}
		switch (p->pd_type) {

		case ADDPID:
			/*
			 * New "godchild", add to list.
			 */
			if (Plfree == NULL) {
				plp = (struct pidlist *) calloc(DELTA,
				    sizeof(struct pidlist));
				if (plp == NULL) {
					/* Can't save pid */
					break;
				}
				/*
				 * Point at 2nd record allocated, we'll use plp.
				 */
				tp = plp + 1;
				/*
				 * Link them into a chain.
				 */
				Plfree = tp;
				for (i = 0; i < DELTA - 2; i++) {
					tp->pl_next = tp + 1;
					tp++;
				}
			}
			else {
				plp = Plfree;
				Plfree = plp->pl_next;
			}
			plp->pl_pid = p->pd_pid;
			plp->pl_dflag = 0;
			plp->pl_next = NULL;
			/*
			 * Note - pid list is kept in increasing order of pids.
			 */
			if (Plhead == NULL) {
				Plhead = plp;
				/* Back up to read next record */
				break;
			}
			else {
				savetp = tp = Plhead;
				while (tp) {
					if (plp->pl_pid > tp->pl_pid) {
						savetp = tp;
						tp = tp->pl_next;
						continue;
					}
					else if (plp->pl_pid < tp->pl_pid) {
						if (tp == Plhead) {
							plp->pl_next = Plhead;
							Plhead = plp;
						}
						else {
							plp->pl_next =
							    savetp->pl_next;
							savetp->pl_next = plp;
						}
						break;
					}
					else {
						/* Already in list! */
						plp->pl_next = Plfree;
						Plfree = plp;
						break;
					}
				}
				if (tp == NULL) {
					/* Add to end of list */
					savetp->pl_next = plp;
				}
			}
			/* Back up to read next record. */
			break;

		case REMPID:
			/*
			 * This one was handled by someone else,
			 * purge it from the list.
			 */
			if (Plhead == NULL) {
				/* Back up to read next record. */
				break;
			}
			savetp = tp = Plhead;
			while (tp) {
				if (p->pd_pid > tp->pl_pid) {
					/* Keep on looking. */
					savetp = tp;
					tp = tp->pl_next;
					continue;
				}
				else if (p->pd_pid < tp->pl_pid) {
					/* Not in list. */
					break;
				}
				else {
					/* Found it. */
					if (tp == Plhead)
						Plhead = tp->pl_next;
					else
						savetp->pl_next = tp->pl_next;
					tp->pl_next = Plfree;
					Plfree = tp;
					break;
				}
			}
			/* Back up to read next record. */
			break;
		default:
			console(MM_ERROR,
			    ":42:Bad message on initpipe\n");
			break;
		}
	}
}


/************************/
/*******  cleanaux  *****/
/************************/
void
cleanaux()
{
	register struct pidlist *savep, *p;
	pid_t	pid;
	short	status;

	sighold(SIGCLD);
	Gchild = 0;	/* Note - Safe to do this here since no SIGCLDs */
	(void) sighold(SIGPOLL);
	savep = p = Plhead;
	while (p) {
		if (p->pl_dflag) {
			/*
			 * Found an entry to delete,
			 * remove it from list first.
			 */
			pid = p->pl_pid;
			status = p->pl_exit;
			if (p == Plhead) {
				Plhead = p->pl_next;
				p->pl_next = Plfree;
				Plfree = p;
				savep = p = Plhead;
			}
			else {
				savep->pl_next = p->pl_next;
				p->pl_next = Plfree;
				Plfree = p;
				p = savep->pl_next;
			}
			clearent(pid, status);
			continue;
		}
		savep = p;
		p = p->pl_next;
	}
	(void) sigrelse(SIGPOLL);
	sigrelse(SIGCLD);
}


/*
 * Procedure:     clearent
 *
 * Restrictions:
                 getutxent: None
                 pututxline: None
                 updwtmpx: None
*/

void
clearent(pid, status)
pid_t	pid;
short	status;
{
	register struct utmpx	*up;

	setutxent();
	while (up = getutxent()) {
		if (up->ut_pid == pid) {
			if (up->ut_type == DEAD_PROCESS) {
				/*
				 * Cleaned up elsewhere.
				 */
				endutxent();
				return;
			}
			up->ut_type = DEAD_PROCESS;
			up->ut_exit.e_termination = status & 0xff;
			up->ut_exit.e_exit = (status >> 8) & 0xff;
			time(&up->ut_tv.tv_sec);
			pututxline(up);

			/*
			 * Now attempt to add to the end of the wtmp and wtmpx
			 * files.  Do not create if they don't already exist.
			 */
			updwtmpx(WTMPX, up);
			endutxent();
			return;
		}
	}
	endutxent();
}

/************************/
/****    setpanic    ****/
/************************/

/*
 * S007
 * Read the default file.
 */

setpanic()
{
	register char *cp;
	int flags;
	FILE	*def_fp;

	if ((def_fp = (FILE *)defopen(DEF_FILE)) == NULL)
		return(0);
	flags = defcntl(DC_GETFLAGS, 0);
	flags &= ~(DC_CASE);
	defcntl(DC_SETFLAGS, flags);
	if ((cp = defread(def_fp,"PANICBOOT")) != NULL) {
		if(0==strcmp(cp,"YES") || 0==strcmp(cp,"yes"))
			uadmin(A_SETCONFIG, AD_PANICBOOT, 1);
		else
			uadmin(A_SETCONFIG, AD_PANICBOOT, 0);
	}
	defopen(NULL);
}


/*
 * Procedure:     initprivs
 *
 * Restrictions:
                 fcntl(2): None
*/

initprivs()
{
	struct CMD_LINE cmd;
	extern void childeath();
	extern long waitproc();
	register struct PROC_TABLE *process,*oprocess;
	extern struct PROC_TABLE *efork(),*findpslot();
	int maxfiles;
	int i;


	/* Zero out the cmd itself before trying next line. */
	zero(&cmd,sizeof(struct CMD_LINE));

	cmd.c_levels = MASK0 | MASK1 | MASK2 | MASK3 | MASK4 | MASK5 | MASK6;
	cmd.c_action = M_SYSINIT;
	cmd.c_command = INITPRIVS;
	cmd.c_id[0] = 'p';
	cmd.c_id[1] = 'm';
	cmd.c_id[2] = '\0';

	if (process = findpslot(&cmd)) {
		sighold(SIGCLD);
		for (oprocess=process; (process = efork(M_OFF,oprocess,(NAMED|NOCLEANUP))) == NO_ROOM;);
		sigrelse(SIGCLD);
		if (process == NULLPROC) {
	
	/* Notice no bookkeeping is performed on this entry.  This is */
	/* to avoid doing anything that would cause writes to the file */
	/* system to take place.  No writing should be done until the */
	/* operator has had the chance to decide whether the file system */
	/* needs checking or not. */
			maxfiles = ulimit(4,0);
			for( i=0; i<maxfiles; i++ ) fcntl(i,F_SETFD,1);
			execle(cmd.c_command,cmd.c_command,0,&glob_envp[0]);
	/* If the "exec" fails print an error message. */
			console(MM_WARNING,
			    ":43:Could not initialize privilege data.\r\n");
			exit(1);
		} else while (waitproc(process) == FAILURE);
	#ifdef	ACCTDEBUG
		debug("SYSINIT- id: %.4s term: %o exit: %o\n",
			&cmd.c_id[0],(process->p_exit&0xff),
			(process->p_exit&0xff00)>>8);
	#endif
		process->p_flags = 0;
	}
	return((process->p_exit&0xff00)>>8);
}



/*
 * Procedure:     adt_runprog
 *
 * Restrictions:
                 auditctl(2): None
                 auditlog(2): None
                 defopen: None
                 execl: None
*/
/*	Kick off the audit log-full handling program, as defined by the
 *	auditlog -n option.  Get the program's pathname from kernel with
 *	auditlog() syscall.  
 */

void
adt_runprog()                                                   
{                                                               
	actl_t	actl;		/* auditctl(2) structure */
	alog_t	alog;		/* auditlog(2) structure */
	int	pid,status;
	char 	*savedprogp, *dfltpgmp, *dfltapathp;
	FILE	*def_fp;

	if ((pid=fork()) != FAILURE) {
		if (pid==0) {
			/* Child Process */
			if ((auditctl(ASTATUS, &actl, sizeof(actl_t)))==FAILURE) {
				if (!( (errno == ENOSYS) || (errno == ENOPKG)))
		                	console(MM_ERROR, ":44:auditctl: unable to get status of auditing\n");
				exit(1);
			}
		        else if (actl.auditon) {
				/* allocate space for the ppathp, apathp, progp and defpathp */
				if (((alog.ppathp=(char *)
					calloc(MAXPATHLEN,sizeof(char)))==NULL)
				  ||((alog.apathp=(char *)
					calloc(MAXPATHLEN,sizeof(char)))==NULL)
				  ||((savedprogp=(char *)
					calloc(MAXPATHLEN,sizeof(char)))==NULL)
				  ||((alog.progp=(char *)
					calloc(MAXPATHLEN,sizeof(char)))==NULL)) {
					console(MM_ERROR,
					    ":45:adt_runprog: unable to malloc() space.\n");
					exit(ADT_MALLOC);
				}
	                	if ((auditlog(ALOGGET,&alog,sizeof(alog_t)))==FAILURE) {
	                        	console(MM_ERROR,
					    ":46:auditlog: failed to get pathname to AUDIT switch program.\n");
					exit(1);
				}
				strcpy(savedprogp,alog.progp);
				if (alog.onfull & AALOG) {
				    if ((def_fp = (FILE *)defopen(ADT_DEFLTFILE)) != NULL) {
				    	if ((dfltapathp=(char *)calloc(MAXPATHLEN,sizeof(char)))==NULL) {
				    		console(MM_ERROR, ":45:adt_runprog: unable to malloc() space.\n");
				    		exit(ADT_MALLOC);
				    	}
				    	if ((dfltapathp=(char *)defread(def_fp,"AUDIT_DEFPATH"))==NULL) {
                    			    	strncpy(alog.apathp, ADT_DEFPATH, ADT_DEFPATHLEN);
					} else {
                    			    	strncpy(alog.apathp, dfltapathp, MAXPATHLEN);
					}
				    	if ((dfltpgmp=(char *)calloc(MAXPATHLEN,sizeof(char)))==NULL) {
				    		console(MM_ERROR, ":45:adt_runprog: unable to malloc() space.\n");
				    		exit(ADT_MALLOC);
				    	}
				    	if ((dfltpgmp=(char *)defread(def_fp,"AUDIT_PGM"))!=NULL) {
         				    	if (v_pgm(dfltpgmp)==0) {
                    				    	strncpy(alog.progp,dfltpgmp, MAXPATHLEN);
							if ((alog.defpgmp=(char *)
								calloc(MAXPATHLEN, sizeof(char)))==NULL) {
				    					console(MM_ERROR, ":45:adt_runprog: unable to malloc() space.\n");

				    					exit(ADT_MALLOC);
							}
                    				    	strncpy(alog.defpgmp,dfltpgmp, MAXPATHLEN);
				   		}
					}
				    	alog.onfull |= APROG;
				    	alog.flags &= ~PPATH;
				    	alog.flags &= ~PNODE;
					alog.ppathp = NULL;
					alog.pnodep[0] = '\0';
					alog.defpathp = NULL;
					alog.defnodep = NULL;
					alog.defonfull = alog.onfull;
		            		if ((auditlog(ALOGSET,&alog,sizeof(alog_t)))==FAILURE) {
						console(MM_ERROR,":47:auditlog: failed ALOGSET.\n");
						exit(1);
				    	}
				    }
				} /* AALOG */
				if (execl(savedprogp, savedprogp, (char *)NULL) == FAILURE)  {
					if (errno!=ENOEXEC)
						console(MM_ERROR,
						    ":48:execl of \"%s\" failed; errno = %d\n",
							savedprogp,errno);
					else
						execl("/sbin/sh","sh","-c",savedprogp,(char *)NULL);
				} /* exec */
			} /* !auditon */
		}else /* parent */
			wait(&status);
	} else /* fork failed */
		console(MM_ERROR,
		    ":49:adt_runprog: fork failed; errno = %d\n",errno);
}

/*
 * Procedure:     v_pgm
 *
 * Restrictions:
                 stat(2): none
*/
int
v_pgm(pgmp)
char *pgmp;
{
 	struct stat statpgm;

        /* absolute pathnames required */
	if (*pgmp != '/')
		return(1);

	/*Program must exist*/
	/*If pathname is greater than 1024 characters, stat will return*/
	/*ENAMETOOLONG.                                                */
	if (stat(pgmp, &statpgm))
		return(1);
	else
	{
		/* pgm must be executable by owner */
		if ((statpgm.st_mode & S_IFMT) == S_IFREG) {
			if (statpgm.st_mode & S_IXUSR)
                                return(0);
			else
                                return(1);
		}else
			return(1);
	}
}

/*
 * is_macrunning()
 *
 * -returns 1 if MAC is running
 * -returns 0 if MAC is not running
 */
int
is_macrunning()
{
 	(void)lvlproc(MAC_GET, (level_t *)NULL);
	if (!( (errno == ENOSYS) || (errno == ENOPKG))){
		return (1);
	}else{
		return (0);
	}
}


/*
 * Procedure:     is_macinstalled
 *
 * Restrictions:
                 lvlin: None
 * Notes:
 * -returns 1 if MAC is installed
 * -returns 0 if MAC is not installed
 */
int
is_macinstalled()
{
 	level_t level;

	if (lvlin("SYS_PRIVATE", &level) == 0){
		return (1);
	}else{
		return (0);
	}
}


/*
 * initialize_devtab()
 *
 * Perform any initialization needed for entries in devtab.
 *
 * If TP is configured into system, set dt_major field for CONSOLE, SYSCON,
 * TP_CONSDEV_DSF, TP_ADMDEV_DSF, TP_CTRLCLONE_DSF, and TP_DATACLONE_DSF
 * to tpmajornum.  Set dt_minor field for CONSOLE, and SYSCON to the
 * TP_CONSDEV minor device number.  Set dt_linkdsfname for CONSOLE, and
 * SYSCON to TP_CONSDEV_DSF.
 *
 * If TP is not configured into system, set dt_major, dt_minor,
 * and dt_linkdsfname for CONSOLE, to real_consdevmajnum,
 * real_consdevminnum, and SYSTTY respectively.  Set dt_status for
 * TP_CONSDEV_DSF, SYSCONREAL, TP_ADMDEV_DSF, TP_CTRLCLONE_DSF, 
 * TP_DATACLONE_DSF, and SAD_ADMDEV_DSF to dtsIGNORE.
 *
 * NOTE (For Future Enhancement): To initialize the major device number of
 * the Streams Administrative Device, need a mechansim to get the SAD's major
 * device number.  The mechanism could be  similar to way the Trusted Path's
 * major device number is retrieved.
 */
void
initialize_devtab()
{
	dev_t consdev;

#ifdef DEBUG
debug("%d:initialize_devtab():ENTER\n",getpid());
#endif

	/* Determine major and minor for real console.
	 * In case of failure, use the hardcoded values.
	 */
	if (sysi86(SI86GCON, &consdev) == -1){
		real_consdevmajnum = REAL_CONSDEVMAJNUM;
		real_consdevminnum = REAL_CONSDEVMINNUM;
	} else {
		real_consdevmajnum = major(consdev);
		real_consdevminnum = minor(consdev);
	}
	devtab[DTTAG_SYSTTY].dt_major = real_consdevmajnum;
	devtab[DTTAG_SYSTTY].dt_minor = real_consdevminnum;

	devtab[DTTAG_SYSTTY].dt_dsfname = SYSTTY;
	devtab[DTTAG_TP_CONSDEV].dt_dsfname = TP_CONSDEV_DSF;
	devtab[DTTAG_CONSOLE].dt_dsfname = CONSOLE;
	devtab[DTTAG_SYSCON].dt_dsfname = SYSCON;
	devtab[DTTAG_SYSCONREAL].dt_dsfname = SYSCONREAL;
	devtab[DTTAG_SYSCONREAL].dt_linkdsfname = SYSTTY;
	devtab[DTTAG_TP_ADMDEV].dt_dsfname = TP_ADMDEV_DSF;
	devtab[DTTAG_TP_CTRLCLONE].dt_dsfname = TP_CTRLCLONE_DSF;
	devtab[DTTAG_TP_DATACLONE].dt_dsfname = TP_DATACLONE_DSF;
	devtab[DTTAG_SAD_ADMDEV].dt_dsfname = SAD_ADMDEV_DSF;

	if (tpmajornum != (major_t)NODEV){
		devtab[DTTAG_CONSOLE].dt_major = tpmajornum;
		devtab[DTTAG_SYSCON].dt_major = tpmajornum;
		devtab[DTTAG_TP_CONSDEV].dt_major = tpmajornum;
		devtab[DTTAG_TP_ADMDEV].dt_major = tpmajornum;
		devtab[DTTAG_TP_CTRLCLONE].dt_major = tpmajornum;
		devtab[DTTAG_TP_DATACLONE].dt_major = tpmajornum;

		devtab[DTTAG_CONSOLE].dt_minor = TP_CONSDEV;
		devtab[DTTAG_SYSCON].dt_minor = TP_CONSDEV;

		devtab[DTTAG_CONSOLE].dt_linkdsfname = TP_CONSDEV_DSF;
		devtab[DTTAG_SYSCON].dt_linkdsfname = TP_CONSDEV_DSF;
	}else{
		devtab[DTTAG_CONSOLE].dt_major = real_consdevmajnum;

		devtab[DTTAG_CONSOLE].dt_minor = real_consdevminnum;

		devtab[DTTAG_CONSOLE].dt_linkdsfname = SYSTTY;
		devtab[DTTAG_SYSCON].dt_linkdsfname = SYSTTY;

		devtab[DTTAG_TP_CONSDEV].dt_status = dtsIGNORE;
		devtab[DTTAG_TP_ADMDEV].dt_status = dtsIGNORE;
		devtab[DTTAG_TP_CTRLCLONE].dt_status = dtsIGNORE;
		devtab[DTTAG_TP_DATACLONE].dt_status = dtsIGNORE;
		devtab[DTTAG_SYSCONREAL].dt_status = dtsIGNORE;
		devtab[DTTAG_SAD_ADMDEV].dt_status = dtsIGNORE;
	}
#ifdef DEBUG
debug("%d:initial_devtab():RETURN\n",getpid());
#endif
}

/*
 * Procedure:     verify_devtab
 *
 * Restrictions:
                 stat(2): None
*/
/*
 * verify_devtab()
 *
 * Verify the existence, and major and minor device numbers of all devices
 * in the device table devtab.
 *
 * If a device does not exist, set it status to dtsENOENT and action to
 * dtsMKNOD, if its dt_linkdsfname field is NULL, dtsLINK, if its
 * dt_linkdsfname field in not NULL.  The DSF will be created or linked
 * after the root file system has been checked.  (This will have occured
 * after all "sysinit" entries in /etc/inittab have run.)
 *
 * If the device's major and or minor device number stated in the devtab does
 * not match its cooresponding DSF entry in the file system, set it status to
 * dtsWRONGDEV.  The action is set to dtsMKNOD or dtsLINK as described above.
 */
void
verify_devtab()
{

	struct devicetable	*dtp;
	struct stat		statbuf;
#ifdef DEBUG
debug("%d:verify_devtab():ENTER\n",getpid());
#endif


	for (dtp = devtab; dtp->dt_tag != -1; dtp++){
		if (dtp->dt_status == dtsIGNORE){
			continue;
		}else{
			dtp->dt_status = dtsUNVERIFIED;
		}
	}
	for (dtp = devtab; dtp->dt_tag != -1; dtp++){
		if ((dtp->dt_status == dtsVERIFIED) ||
		 (dtp->dt_status == dtsIGNORE)){
			continue;
		}
		if (stat(dtp->dt_dsfname, &statbuf) == -1){
			dtp->dt_status = dtsENOENT;

		}
		else if (dtp->dt_major != (major_t)(NODEV)){
			if ((dtp->dt_major != major(statbuf.st_rdev)) ||
			 (dtp->dt_minor != minor(statbuf.st_rdev))){
				dtp->dt_status = dtsWRONGDEV;
			}else{
				dtp->dt_status = dtsVERIFIED;
			}
		}else{
			dtp->dt_major = major(statbuf.st_rdev);
			dtp->dt_minor = minor(statbuf.st_rdev);
			dtp->dt_status = dtsVERIFIED;
		}
		if ((dtp->dt_status == dtsENOENT) ||
		 (dtp->dt_status == dtsWRONGDEV)){
			/*
			 * Special Case Handling:
			 */
			switch (dtp->dt_tag){
			/*
			 * If entry is missing, have SYSCONREAL_DSF Major
			 * and Minor device number set to default system
			 * console major and minor device number.
			 * If entry indicates the wrong device, assume its
			 * correct and that it was changed due to being
			 * switched from 'init s|S' being called from a device
			 * other then the real/physical console device.
			 */
			case DTTAG_SYSCONREAL:
				if (dtp->dt_status == dtsENOENT){
					dtp->dt_major = real_consdevmajnum;
					dtp->dt_minor = real_consdevminnum;
					dtp->dt_linkdsfname = SYSTTY;
				}else{
					dtp->dt_major = major(statbuf.st_rdev);
					dtp->dt_minor = minor(statbuf.st_rdev);
					dtp->dt_status = dtsVERIFIED;
				}
				break;
			/*
			 * If TP is configured, set dt_major, dt_minor, and
			 * dt_linkdsfname to tpmajornum, TP_CONSDEV, and
			 * TP_CONSDEV_DSF respectively.
			 * If TP is not configured, set dt_major, dt_minor, and
			 * dt_linkdsfname to real_consdevmajnum,
			 * REAL_CONSDEVMINNUM, and SYSTTY respectively.
			 */
			case DTTAG_SYSCON:
				if (tpmajornum != (major_t)(NODEV)){
					dtp->dt_major = tpmajornum;
					dtp->dt_minor = TP_CONSDEV;
					dtp->dt_linkdsfname =
					 TP_CONSDEV_DSF;
				}else{
					if (dtp->dt_status == dtsENOENT){
						dtp->dt_major =
						 real_consdevmajnum;
						dtp->dt_minor =
						 real_consdevminnum;
						dtp->dt_linkdsfname = SYSTTY;
					}else{
						dtp->dt_major =
						 major(statbuf.st_rdev);
						dtp->dt_minor =
						 minor(statbuf.st_rdev);
						dtp->dt_status = dtsVERIFIED;
					}
				}
				break;
			default:
				break;
			}
			if (dtp->dt_status != dtsVERIFIED){
				if (dtp->dt_linkdsfname == (char *)NULL){
					dtp->dt_action = dtaMKNOD;
				}else{
					dtp->dt_action = dtaLINK;
				} 
			}
		}
	}
	/*
	 * Special Case Handling:
	 *
	 * CASE: SYSTTY does not exist or has the wrong major/minor
	 * device number.
	 * If TP is configured and SYSCONREAL's major and minor device number
	 * is the save as SYSTTY's, set SYSCONREAL's devtab entry's action
	 * field to dtaLINK.  This is done so SYSCONREAL will be linked to
	 * SYSTTY after SYSTTY is created. (mknod and links of the DSF are
	 * done after the SYSINIT entries have run.)
	 * If TP is not configured, set CONSOLE's devtab entry's action field
	 * to dtaLINK.  If SYSCONS's major and minor device number is the
	 * same as SYSTTY, set SYSCONS's devtab entry's action field to dtaLINK.
	 * The dt_status field is not changed since if the devices have
	 * been verified, they may be used before they are relinked to SYSTTY.
	 *
	 * CASE: TP_CONSDEV_DSF does not exist or has the wrong major/minor
	 * device number.
	 * Set SYSCON's and CONSOLE's devtab entry's action field to dtaLINK.
	 * The dt_status field is not changed since if the devices have been
	 * verified, they may be used before they are relinked to
	 * TP_CONSDEV_DSF.
	 *
	 * CASE: SAD_ADMDEV_DSF does not exist.
	 * For now, set action to datNOACTION, since there is no way to get
	 * the major * device number (via some system call) for the SAD driver.
	 */
	if (devtab[DTTAG_SYSTTY].dt_status == dtsUNVERIFIED){
		if (tpmajornum != (major_t)(NODEV)){
			if ((devtab[DTTAG_SYSCONREAL].dt_major ==
			 devtab[DTTAG_SYSTTY].dt_major) &&
			 (devtab[DTTAG_SYSCONREAL].dt_minor ==
			 devtab[DTTAG_SYSTTY].dt_minor)){
				devtab[DTTAG_SYSCONREAL].dt_action = dtaLINK;
			}
		}else{
			devtab[DTTAG_CONSOLE].dt_action = dtaLINK;
			if ((devtab[DTTAG_SYSCON].dt_major ==
			 devtab[DTTAG_SYSTTY].dt_major) &&
			 (devtab[DTTAG_SYSCON].dt_minor ==
			 devtab[DTTAG_SYSTTY].dt_minor)){
				devtab[DTTAG_SYSCON].dt_action = dtaLINK;
			}
		}
	}
	if (devtab[DTTAG_TP_CONSDEV].dt_status == dtsUNVERIFIED){
		devtab[DTTAG_SYSCON].dt_action = dtaLINK;
		devtab[DTTAG_CONSOLE].dt_action = dtaLINK;
	}
	if (devtab[DTTAG_SAD_ADMDEV].dt_status == dtsENOENT){
		devtab[DTTAG_SAD_ADMDEV].dt_action = dtaNOACTION;
	}
#ifdef DEBUG
{
	char *status;
	for (dtp = devtab; dtp->dt_tag != -1; dtp++){
		switch (dtp->dt_status){
		case dtsUNVERIFIED:
			status = "UNVERIFIED";
			break;
		case dtsVERIFIED:
			status = "VERIFIED";
			break;
		case dtsIGNORE:
			status = "IGNORE";
			break;
		case dtsENOENT:
			status = "ENOENT";
			break;
		case dtsWRONGDEV:
			status = "WRONGDEV";
			break;
		default:
			break;
		}
		debug("verify_devtab():DSF %s\tSTATUS = %s\n",dtp->dt_dsfname, status);
	}
}
debug("%d:verify_devtab():RETURN\n",getpid());
#endif
}

/*
 * Procedure:     setup_consdev
 *
 * Restrictions:
                 open(2): None


 * setup_consdev(errbuf, errbufsz)
 *
 * Setup consdevdsf, which is the dsf init uses internally to write
 * console messages.
 * Setup device to display console messages output.
 *
 ****************************************************************************
 * If TP is configured on the system;
 * -consdevdsf is set to the first device that exists and has the correct
 *   major/minor device number in the following order; CONSOLE, SYSCON,
 *   TP_CONSDEV_DSF, and SYSTTY.
 * -Determine whether the floating real/physical tty device (SYSCONREAL) or
 *  the default real/physical tty device (SYSTTY) will be the real/physical
 *  tty device.
 * -Determine whether or not TP is on the real/physical console device.
 *  If TP in not indicated to be on the real/physical console device, setup
 *  up a TP device.
 *  NOTE: Do not setup a TP device if consdevdsf is NULL or SYSTTY.  If it
 *  is NULL and this is being called from initialize() before the root file
 *  system has been checked, the system will go down to firmware mode.  If
 *  it is SYSTTY, we want the user to be able come up in single user mode
 *  and attempt to fix/make whatever files are missing or are incorrect,
 *  if it can not be corrected by init itself.
 * NOTE: SYSCON is obsolete as the device to use as the floating console
 * since the floating console is now registered with TP via a TP ioctl.
 * (See userinit().)
 ****************************************************************************
 * If TP is not configured on the system, set consdevdsf to SYSCON if it
 * exists and can be opened.  If SYSCON does not exist or can not be opened
 * set consdevdsf to the first device that exists and has the correct
 * major/minor device number in the following order;
 * CONSOLE, and SYSTTY.
 ****************************************************************************
 * SIDE EFFECTS:
 *
 *	Global consdevdsf	gets set to DSF to send console messages.
 *	Global tponconsole	(if TP is configured on system) gets set
 *				to TRUE if a TP is setup on the console
 *				device and FALSE if it does not.
 *	Global substitutedsf	gets set to consdevdsf if consdevdsf !=
 *				CONSOLE, otherwise it gets set to NULL.
 */
int
setup_consdev(errbuf, errbufsz)
char	*errbuf;
size_t	errbufsz;
{
	int		ctrlfd;
	int		fd;
	struct tp_info	tpinf;
	char		lerrbuf[ERRBUFSZ]={'\0'};
	char		*consdev = (char *)NULL;
	int		ret = SUCCESS;
#ifdef DEBUG
debug("%d:setup_consdev():ENTER\n",getpid());
#endif


	if (errbuf != (char *)NULL){
		*errbuf = '\0';
	}
	if (tpmajornum != (major_t)NODEV){
		if (devtab[DTTAG_CONSOLE].dt_status == dtsVERIFIED){
			consdevdsf = devtab[DTTAG_CONSOLE].dt_dsfname;
		}else if (devtab[DTTAG_SYSCON].dt_status == dtsVERIFIED){
			consdevdsf = devtab[DTTAG_SYSCON].dt_dsfname;
		}else if (devtab[DTTAG_TP_CONSDEV].dt_status == dtsVERIFIED){
			consdevdsf = devtab[DTTAG_TP_CONSDEV].dt_dsfname;
		}else if (devtab[DTTAG_SYSTTY].dt_status == dtsVERIFIED){
			consdevdsf = devtab[DTTAG_SYSTTY].dt_dsfname;
		}else{
			consdevdsf = (char *)NULL;
#ifdef DEBUG
debug("%d:setup_consdev():RETURN FAILURE\tCAN NOT SET consdevdsf, HAVE NOT DETERMINED IF TP IS ON CONSOLE DEVICE\n\t NOT changing previous state of tpconsole\n\ttponconsole = \"%s\"  consdevdsf = \"%s\"\n",
 getpid(), ((tponconsole == TRUE)? "TRUE":"FALSE"), consdevdsf);
#endif
			return (FAILURE);
		}

		/*
		 * Determine which physical/real device will be the console
		 * device. (Either SYSCONREAL or SYSTTY).
		 */
		if (strcmp(devtab[DTTAG_SYSTTY].dt_dsfname, consdevdsf) == 0){
			if (devtab[DTTAG_SYSTTY].dt_status == dtsVERIFIED){
				consdev = devtab[DTTAG_SYSTTY].dt_dsfname;
			}
			devtab[DTTAG_SYSCONREAL].dt_major = real_consdevmajnum;
			devtab[DTTAG_SYSCONREAL].dt_minor = real_consdevminnum;
			devtab[DTTAG_SYSCONREAL].dt_status = dtsWRONGDEV;
			devtab[DTTAG_SYSCONREAL].dt_action = dtaLINK;
		}else if (devtab[DTTAG_SYSCONREAL].dt_status == dtsVERIFIED){
			if ((fd = open(SYSCONREAL, O_RDWR|O_NONBLOCK|O_NOCTTY))
			 != -1){
				consdev = devtab[DTTAG_SYSCONREAL].dt_dsfname;
				(void)close(fd);
			}else{
				devtab[DTTAG_SYSCONREAL].dt_major =
				 real_consdevmajnum;
				devtab[DTTAG_SYSCONREAL].dt_minor =
				 real_consdevminnum;
				devtab[DTTAG_SYSCONREAL].dt_status =
				 dtsWRONGDEV;
				devtab[DTTAG_SYSCONREAL].dt_action =
				 dtaLINK;

				if (devtab[DTTAG_SYSTTY].dt_status ==
				 dtsVERIFIED){
					consdev =
					 devtab[DTTAG_SYSTTY].dt_dsfname;
				}
			}
		}else if (devtab[DTTAG_SYSTTY].dt_status == dtsVERIFIED){
			consdev = devtab[DTTAG_SYSTTY].dt_dsfname;
		}

		/*
		 * Determine whether or not TP is on the real/physcial
		 * console device.
		 * Setup TP on real/physical console device if necessary
		 */
		if (consdev != (char *)NULL){
			if ((tp_getinf(consdev, &tpinf) != -1) &&
			 (tpinf.tpinf_muxid != 0)){
#ifdef DEBUG
debug("setup_consdev(): TP already on console device\n");
#endif
				tponconsole = TRUE;
			}else if ((fd =
			 open(consdevdsf, O_RDWR|O_NONBLOCK|O_NOCTTY)) != -1){
				if ((tp_fgetinf(fd, &tpinf) != -1) &&
				 (tpinf.tpinf_muxid != 0)){
#ifdef DEBUG
debug("setup_consdev(): TP already on console device\n");
#endif
					tponconsole = TRUE;
				}else{
					tponconsole = FALSE;
				}
				(void)close(fd);
			}/*else: could not determine whether or not TP is on
			  *the console.
			  */

			if ( (tponconsole != TRUE) &&
			 ((ctrlfd = opentpdev(consdev, TPINF_CONSOLE,
			 &tpinf,  lerrbuf, ERRBUFSZ)) == FAILURE)){
				COPYBUF(lerrbuf, errbuf, errbufsz);
#ifdef DEBUG
debug("setupconsdev():%s", lerrbuf);
#endif
				if (tperrno == EBUSY){
#ifdef DEBUG
debug("setup_consdev(): Found TP to already be on the console device when setting up a TP\n");
#endif
					tponconsole = TRUE;
				}else{
					/*
			 	 	* Try to reset consdevdsf.
			 	 	*/
					if (devtab[DTTAG_SYSTTY].dt_status ==
				 	dtsVERIFIED){
						consdevdsf = 
					 	devtab[DTTAG_SYSTTY].dt_dsfname;
					}else{
						consdevdsf = (char *)NULL;
					}
#ifdef DEBUG
debug("setup_consdev():Could not set up a TP device\n");
#endif
					tponconsole = FALSE;
					ret = FAILURE;
				}
			}else{
				tponconsole = TRUE;
				(void)close(ctrlfd);
			}
		}else{
			/*
			 * Can not verify anything.  Do not change previous
			 * value of whether or not TP is on the console.
			 */
#ifdef DEBUG
debug("setup_consdev():Could not find real/physical device condev\n");
#endif
			ret = FAILURE;
		}
	}else{
		if ((fd = open(SYSCON, O_RDWR|O_NONBLOCK|O_NOCTTY)) == -1){
			if (devtab[DTTAG_CONSOLE].dt_status == dtsVERIFIED){
				consdevdsf = devtab[DTTAG_CONSOLE].dt_dsfname;
			}else if (devtab[DTTAG_SYSTTY].dt_status == dtsVERIFIED){
				consdevdsf = devtab[DTTAG_SYSTTY].dt_dsfname;
			}else{
				ret = FAILURE;
			}
			devtab[DTTAG_SYSCON].dt_major = real_consdevmajnum;
			devtab[DTTAG_SYSCON].dt_minor = real_consdevminnum;
			devtab[DTTAG_SYSCON].dt_status = dtsWRONGDEV;
			devtab[DTTAG_SYSCON].dt_action = dtaLINK;
			devtab[DTTAG_SYSCON].dt_linkdsfname = SYSTTY;
		}else{
			consdevdsf = SYSCON;
			(void)close(fd);
		}
	}
	if (strcmp(CONSOLE, consdevdsf) != 0){
		substitutedsf = consdevdsf;
	}else{
		substitutedsf = (char *)NULL;
	}
#ifdef DEBUG
debug("%d:setup_consdev():RETURN %s\ttponconsole = %s  consdevdsf = %s\n",
 getpid(), ((ret == SUCCESS)? "SUCCESS":"FAILURE"),
 ((tponconsole == TRUE)? "TRUE":"FALSE"), consdevdsf);
#endif
	return (ret);
}

/*
 * opentpdev(char *ttynm, int tpflags, struct tp_info *, char *errbuf,
 *	     (size_t)errbufsz)
 *
 * Allocates a Trusted Path for the given device.
 *
 * Returns file descriptor of ctrl channel for TP if successful.
 * Returns FAILURE if not successful.
 */
int
opentpdev(ttynm, tpflags, tpinfop, errbuf, errbufsz)
char		*ttynm;
int		tpflags;
struct tp_info	*tpinfop;
char		*errbuf;
size_t		errbufsz;
{
	struct tp_info	tpinf;
	int		ctrlfd;
#ifdef DEBUG
debug("%d:opentpdev():ENTER\n",getpid());
#endif

	if (errbuf != (char *)NULL){
		*errbuf = '\0';
	}
	/* -setup TP device via tp_devopen()
	 *	-tp_devopen() returns a file descriptor to the ctrl channel of
	 *	 the TP device
	 *	-args to tp_devopen()
	 *		-path name of device to be muxed under (eg. the real
	 *		 system console device (SYSTTY)
	 *		-default SAK definition (SAK is to be defined to NONE)
	 *		-return parameter pointer for TP device information
	 *		 the return paramter is also and input parameter which
	 *		 loaded with the following information:
	 *			-default SAK definition
	 */
	TP_LOADINF(tpinf, (dev_t)-1, (dev_t)-1, 0, 0, (dev_t)-1, (dev_t)-1,
	 (dev_t)-1, 0, 0, 0, 0, nonesak, tpflags, nulltermios,
	 nulltermios);
	if ((ctrlfd = tp_devopen(ttynm, &tpinf)) == -1){
		if (errbuf != (char *)NULL){
			char	tmpbuf[sizeof(tperrormsg) * 2];
			tp_geterror(&tperrno, sizeof(tperrormsg), tperrormsg);
			(void)sprintf(tmpbuf, 
			    gettxt(":50","Can not allocate TP device for %s\n%s errno == %d\n"),
				ttynm, tperrormsg, tperrno);
			COPYBUF(tmpbuf, errbuf, errbufsz);
		}
#ifdef DEBUG
		else{
			tp_geterror(&tperrno, sizeof(tperrormsg), tperrormsg);
		}
		debug("Can not allocate TP device for %s\n%s errno == %d\n",
		 ttynm, tperrormsg, tperrno);
debug("%d:opentpdev():RETURN\tFAILED\n",getpid());
#endif
		return (FAILURE);
	}
	*tpinfop = tpinf;
#ifdef DEBUG
debug("%d:opentpdev():RETURN\tSUCCEEDED\n",getpid());
#endif
	return (ctrlfd);
}

/*
 * Procedure:     allocatedev
 *
 * Restrictions:
                 lvlin: None
                 devstat(2): None
*/

/*
 * allocatedev(char *dsfpath, int sdhstate, int sdhrelflag)
 *
 * If MAC is running, set the Secure Device Handling Attributes on the
 * Device Special File.
 *
 * Return 0 on success, FAILURE otherwise
 */
int
allocatedev(dsfpath, sdhstate, sdhrelflag)
char	*dsfpath;	/* DSF path name */
ushort	sdhstate;	/* SDH state to set device to (either Private or
			 * Public).
			 */
ushort	sdhrelflag;	/* SDH release flags, indicates the duration
			 * that the SDH information is valid for
			 * (either permanent or last close on device).
			 */
{
	struct devstat	ttydevstat;	/* devstat() kernel attrs */
#ifdef DEBUG
int	saveerrno;
debug("%d:allocatedev():ENTER\t%s SDHSTATE = %d  SDHRELFLAG = %d\n",getpid(),
 dsfpath, sdhstate, sdhrelflag);
#endif

	if (macrunning){
		/*
		 * Set the range to system maximum and minimun
		 * so devstat(2) will not fail because of range to
		 * MAC level domination checks
		 */
		ttydevstat.dev_mode = DEV_STATIC;
		lvlin("SYS_RANGE_MAX", &ttydevstat.dev_hilevel);
		lvlin("SYS_RANGE_MIN", &ttydevstat.dev_lolevel);
		ttydevstat.dev_state = sdhstate;
		ttydevstat.dev_relflag = sdhrelflag;
		if(devstat(dsfpath, DEV_SET, &ttydevstat) < 0) {
#ifdef DEBUG
saveerrno = errno;
debug("%d:allocatedev():RETURN  devstat(%s, DEV_SET, ..) FAILED:%s\n", getpid(), dsfpath, strerror(errno));
errno = saveerrno;
#endif
			console(MM_ERROR,
			    ":51:Cannot set security attributes on %s errno == %d\n",
				dsfpath, errno);
			return (FAILURE);
		}

	}
#ifdef DEBUG
debug("%d:allocatedev():RETURN SUCCESS\n",getpid());
#endif
	return (0);
}


void
firmware()
{
	pid_t	pid;
	int	status;

	while ((pid = fork()) == FAILURE); /* NULL STATEMENT */
	if (pid == 0){
		console(MM_INFO,
		    ":52:Reboot from Assurance Media\n\n");
		(void)uadmin(A_SHUTDOWN, AD_IBOOT, 0);
	}else{
		while (wait(&status)); /* NULL STATEMENT */
	}
}


/*
 * substitutedev()
 *
 * For the given command line from /etc/inittab, substitute all Device
 * Special File (ie. /dev/console entries) with the DSF specified in subdev.
 *
 * NOTE: There is an assumption that /etc/inittab entries always use
 * /dev/console when re-directing input and/or output from the console device.
 */ 
int
substitutedev(cmd, line, subdev)
struct CMD_LINE	*cmd;
char		*line;
char		*subdev;
{

	char	*cmdlinesegp;	/* pointer to beginning of a segment of the
				 * command line to be searched for a DSF
				 * entry.
				 */
	char	*dsfp;		/* pointer to beginning of a DSF located in
				 * the segment of the command line.
				 */
	char	*segdelimp;	/* pointer to delimiter of the segment of
				 * the command line being processed.  It is
				 * the first char after the DSF entry in the
				 * command line.
				 */
	char	*nsegdelimp;	/* temporary pointer used while finding
				 * delimiter of the segment of command line
				 * being processed.
				 */
	int	linelen = 0;	/* length of new command line being created */
	int	seglen;		/* length of segment current segment of command
				 * line.
				 */


	*line = '\0';
	cmdlinesegp = cmd->c_command;


	while ((dsfp = strstr(cmdlinesegp, "/dev/console")) != (char *)NULL){
		/*
		 * Copy over segment from cmdlinesegp to dsfp to new command
		 * line and copy the substitute DSF to new command line.
		 */
		seglen = dsfp - cmdlinesegp;
		linelen += seglen;
		if (linelen < MAXCMDL){
			strncat(line, cmdlinesegp, seglen);
#ifdef DEBUG
debug("substitutedev():After strncat of cmdlinesegp line = \n%s\n",line);
#endif
		}else{
			return (FAILURE);
		}
		seglen = strlen(subdev);
		linelen += seglen;
		if (linelen < MAXCMDL){
			strncat(line, subdev, seglen);
#ifdef DEBUG
printf("substitutedev():After strncat of subdev line = \n%s\n",line);
#endif
		}else{
			return (FAILURE);
		}
		cmdlinesegp =  dsfp + strlen("/dev/console");
	} /* end while */

	/*
	 * Copy rest of commnad line to new command line if any DSFs were
	 * substituted.
	 */

	if (cmdlinesegp == cmd->c_command){
		return (SUCCESS);
	}else{
		seglen = strlen(cmdlinesegp);
		linelen += seglen;
		if (linelen < MAXCMDL){
			strncat(line, cmdlinesegp, seglen);
		}else{
			return (FAILURE);
		}
		cmd->c_command = line;
	}
	return (SUCCESS);
}

/*
 * Procedure:     update_devtab
 *
 * Restrictions:
                 unlink(2): None
                 mknod(2): None
                 lvlin: None
                 lvlfile(2): None
                 link(2): None
*/
/*
 * update_devtab()
 *
 *
 * Go through devtab and make all devices that have the action dtaMKNOD.
 * Go through devtab and make all devices that have the action dtaLINK.
 * NOTE: Function should not be called the root file system has been verified.
 */
int
update_devtab()
{
	struct devicetable	*dtp;
	level_t			level;
	int			ret = SUCCESS;
#ifdef DEBUG
debug("%d:update_devtab():ENTER\n",getpid());
#endif

	if (rootfs_verified != TRUE){
		return (FAILURE);
	}

	/*
	 * get the level to set the devices to, if any are created.
	 */
	if (macinstalled){
		(void)lvlin("SYS_PRIVATE", &level);
	}else{
		level = SYS_PRIVATE_LVL;
	}
	for (dtp = &devtab[0]; dtp->dt_tag != (short)-1; dtp++){
		if (dtp->dt_action == dtaMKNOD){
#ifdef DEBUG
			debug("update_devtab:making DSF %s:major %d:minor %d:reason - %s\n",
			 dtp->dt_dsfname, dtp->dt_major,
			 dtp->dt_minor, (dtp->dt_status == dtsWRONGDEV?
			 "incorrect major/minor number":"entry does not exit"));
#endif
			(void)unlink(dtp->dt_dsfname);
			if (mknod(dtp->dt_dsfname, S_IFCHR|S_IRWXU|S_IWGRP,
			 makedev(dtp->dt_major, dtp->dt_minor)) == -1){
#ifdef DEBUG
				debug("update_devtab:mknod %s failed errno %d:%s\n",
				 dtp->dt_dsfname, errno, strerror(errno));
#endif
				ret = FAILURE;
			}else{
				dtp->dt_status = dtsVERIFIED;
				dtp->dt_action = dtaNOACTION;
				(void)lvlfile(dtp->dt_dsfname, MAC_SET, &level);
			}
		}
	}

	for (dtp = devtab; dtp->dt_tag != (short)-1; dtp++){
		if (dtp->dt_action == dtaLINK){
#ifdef DEBUG
			debug("update_devtab:linking DSF %s to %s:major %d:minor %d:reason - %s\n",
			 dtp->dt_linkdsfname, dtp->dt_dsfname, dtp->dt_major,
			 dtp->dt_minor, (dtp->dt_status == dtsWRONGDEV?
			 "incorrect major/minor number":"entry does not exit"));
#endif
			(void)unlink(dtp->dt_dsfname);
			if (link(dtp->dt_linkdsfname, dtp->dt_dsfname)){
#ifdef DEBUG
				debug("update_devtab:link %s to %s failed errno %d:%s\n",
				 dtp->dt_linkdsfname, dtp->dt_dsfname, errno,
				 strerror(errno));
#endif
				ret = FAILURE;
			}else{
				dtp->dt_status = dtsVERIFIED;
				dtp->dt_action = dtaNOACTION;
			}
		}
	}
#ifdef DEBUG
debug("%d:update_devtab():RETURN\t%s\n",getpid(), ((ret == SUCCESS)?"EVERY DEVICE UPDATED SUCCESSFULLY":"ONE OR MORE DEVICE(S) FAILED TO BE UPDATED"));
#endif
	return (ret);
}

/*
 * tpswitchcons(char *dsfname, tpflags, tpinfp, errbuf, errbufsz)
 *
 * Call TP library function tp_consset, which instructs TP to set the console
 * device to dsfname.  This is done via the TP_SETCONS TP ioctl down the
 * TP_ADMDEV_DSF channel.
 */
int
tpswitchcons(dsfname, tpflags, tpinfp, errbuf, errbufsz)
char		*dsfname;
int		tpflags;
struct tp_info	*tpinfp;
char		*errbuf;
size_t		errbufsz;
{
	char	*saveconsdevdsf;
#ifdef DEBUG
debug("%d:tpswitchcons():ENTER\n",getpid());
#endif

	if (errbuf != (char *)NULL){
		*errbuf = '\0';
	}
	if (tp_consset(dsfname, tpflags, tpinfp) == -1){
		if (errbuf != (char *)NULL){
			char tmpbuf[ERRBUFSZ * 2];
			tp_geterror(&tperrno, sizeof(tperrormsg), tperrormsg);
			(void)sprintf(tmpbuf,
			    gettxt(":53","Can not switch console to %s\n%s:%s\n"),
				dsfname,
				tperrormsg, strerror(tperrno));
			COPYBUF(tmpbuf, errbuf, errbufsz);
		}
#ifdef DEBUG
		else{
			tp_geterror(&tperrno, sizeof(tperrormsg), tperrormsg);
		}
		debug("tpswitchcons:Can not switch console to %s\n%s:%s\n",
		 dsfname, tperrormsg, strerror(tperrno));
debug("%d:tpswitchcons():RETURN\tFAILED\n",getpid());
#endif
		return (FAILURE);
	}else{
#ifdef DEBUG
debug("%d:tpswitchcons():RETURN\tSUCCESS\n",getpid());
#endif
		return (SUCCESS);
	}
}

/*
 * Procedure:     setuptpdev
 *
 * Restrictions:
                 stat(2): None
                 chown(2): None
                 chmod(2): None
                 open(2): None
                 ioctl(2): None
                 fcntl(2): None
                 lvlfile(2): None
*/


/*
 * setuptpdev(ctrlfdp, datafdp, datadsfnamep)
 *
 * Setup a Trusted Path in a "trusted state" (ie. the newly allocated data 
 * channel with be in Secure Device Handling PRIVATE state) on the physical
 * tty device indicated by SYSCONREAL.
 *
 * Setting up a TP in a "trusted state" is necessary since /sbin/sulogin
 * prompts user for password.
 *
 * NOTE: This function is to be used when init is in single user mode!
 */
int
setuptpdev(ctrlfdp, datafdp, datadsfnamep)
int	*ctrlfdp;
int	*datafdp;
char	*datadsfnamep;
{

	int		ctrlfd;
	int		datafd;
	int		tmpfd;
	char		datadsfname[PATH_MAX] = {'\0'};
	char		errbuf[ERRBUFSZ];
	char		*realdsf = SYSCONREAL;
	struct stat	statbuf;
	struct tp_info	tpinf;
	level_t		level;
#ifdef DEBUG
int	saveerrno;
debug("%d:setuptpdev():ENTER\n",getpid());
#endif

	if ((tpmajornum != (major_t)NODEV) && (tponconsole == TRUE)){
		if ((ctrlfd = opentpdev(SYSCONREAL, 0, &tpinf, errbuf,
		 ERRBUFSZ)) == -1){
			(void)stat(SYSCONREAL, &statbuf);
			reset_syscon();
			console(MM_NOGET|MM_ERROR, "%s", errbuf);
			console(MM_NOSTD,
			    ":54:%s not accessible, resetting device to default\n",
				sttyname(&statbuf));
			/*
			 * Try opening and setting up a TP device on the
			 * default system console device, SYSTTY
			 */
			ctrlfd = opentpdev(SYSTTY, 0, &tpinf, (char *)NULL,
			 (size_t)0);
			realdsf = SYSTTY;
		}
		if (ctrlfd == -1){
			/*
			 * Nothing much else can be done except to try to
			 * determine whether on not SYSTTY is linked under a
			 * TP device, even though we could not open the CTRL
			 * channel for the TP device
			 */
			if (tp_getinf(SYSTTY, &tpinf) != -1){
				if (tpinf.tpinf_muxid == 0){
					tponconsole = FALSE;
				}
			}
#ifdef DEBUG
debug("%d:setuptpdev():FAILED\tSETTING UP TP DEVICE:%s\n",getpid());
#endif
			return (FAILURE);
		}
		/*
		 * Disconnect current DATA channel on TP device (if one is
		 * connected).  Allocate a new data channel in a
		 * "trusted state".
		 */
		tpinf.tpinf_dconnid = 0;	/* connection id of 0 instructs
						 * TP to disconnect data channel
						 * regardless of its connection
						 * id.
						 */
		(void)tp_datadisconnect(ctrlfd, &tpinf);
		if ((datafd =
		 tp_chanopen(TPC_DATA, O_RDWR|O_NONBLOCK|O_NOCTTY)) == -1){ 
#ifdef DEBUG
saveerrno = errno;
debug("%d:setuptpdev():FAILED\ttp_chanopen():%s\n",getpid(),
strerror(saveerrno));
errno = saveerrno;
#endif
			tp_geterror(&tperrno, sizeof(tperrormsg), tperrormsg);
			console(MM_ERROR,
			    ":55:%s errno %d:%s\n", tperrormsg, tperrno,
				strerror(tperrno));
			(void)close(ctrlfd);
			return (FAILURE);
		}

		/*
		 * Connect new data channel to TP device.
		 */
		if (tp_dataconnect(realdsf, ctrlfd, datafd, &tpinf) == -1){
#ifdef DEBUG
saveerrno = errno;
debug("%d:setuptpdev():FAILED\ttp_dataconnect():%s\n",getpid(),
strerror(saveerrno));
errno = saveerrno;
#endif
			tp_geterror(&tperrno, sizeof(tperrormsg), tperrormsg);
			console(MM_ERROR,
			    ":55:%s errno %d:%s\n", tperrormsg, tperrno,
				strerror(tperrno));
			(void)close(ctrlfd);
			(void)close(datafd);
			return (FAILURE);
		}
		/*
		 * Make a Device Special File name for the DATA channel
		 * under /dev/tp.
		 */ 
		if (tp_makedevice(datafd, sizeof(datadsfname), datadsfname)
		 == -1){
#ifdef DEBUG
saveerrno = errno;
debug("%d:setuptpdev():FAILED\ttp_makedevice():%s\n",getpid(),
strerror(saveerrno));
errno = saveerrno;
#endif
			(void)tp_datadisconnect(ctrlfd, &tpinf);
			(void)close(ctrlfd);
			(void)close(datafd);
			tp_geterror(&tperrno, sizeof(tperrormsg), tperrormsg);
			console(MM_ERROR,
			    ":55:%s errno %d:%s\n", tperrormsg, tperrno,
				strerror(tperrno));
			return (FAILURE);
		}

		/*
		 * Change ownership and mode of data channel's DSF.
		 * Allocate the data channel's DSF in PRIVATE state and
		 * change its level to the level of the process.
		 */
		(void)chown(datadsfname, getuid(), getgid());
		(void)chmod(datadsfname, S_IRUSR|S_IWUSR|S_IWGRP);
		/*
		 * get the level to set the devices to, if any are created.
		 */
		if (macinstalled){
			(void)lvlin("SYS_PRIVATE", &level);
		}else{
			level = SYS_PRIVATE_LVL;
		}
		(void)lvlfile(datadsfname, MAC_SET, &level);

		/*
		 * Re-open data channel via its DSF name, since the Secure
		 * Device Handling's (SDH) Device Control Information (DCI)
		 * will be setup on the specfs snode associated with the
		 * data channel's DSF name, and not the snode associated with
		 * the data channel's clone. (NOTE: data channel file
		 * descriptor is to a clone snode, since the data channel was
		 * opened via Trusted Path's data channel clone device.)
		 */
		tmpfd = datafd;
		if ((datafd = open(datadsfname, O_RDWR|O_NONBLOCK|O_NOCTTY)) ==
		 -1){
#ifdef DEBUG
saveerrno = errno;
debug("%d:setuptpdev():FAILED\tTO RE-OPEN DATA CHANNEL VIA ITS DSF:%s\n",getpid(),
strerror(saveerrno));
errno = saveerrno;
#endif
			console(MM_ERROR,
			    ":56:Failed to re-open data channel during setting up a Trusted Path\n\t%s\n",
				strerror(errno)); 
			(void)tp_datadisconnect(ctrlfd, &tpinf);
			(void)close(ctrlfd);
			(void)close(tmpfd);
			return (FAILURE);
		}
		(void)close(tmpfd);

		if (allocatedev(datadsfname, DEV_PRIVATE, DEV_LASTCLOSE) ==
		 FAILURE){
#ifdef DEBUG
saveerrno = errno;
debug("%d:setuptpdev():FAILED\tallocatedev():%s\n",getpid(),
strerror(saveerrno));
errno = saveerrno;
#endif
			console(MM_ERROR,
			    ":57:Allocating %s during setting up a Trusted Path Failed\n",
				datadsfname);
			(void)tp_datadisconnect(ctrlfd, &tpinf);
			(void)close(ctrlfd);
			(void)close(datafd);
			return (FAILURE);
		}
		(void)lvlfile(datadsfname, MAC_SET, &level);

		/*
		 * Push STREAM module(s) onto TP data channel.
		 *
		 * NOTE (For Future Enhancement): Get list of modules to push
		 * from a table that was generate when the devtab was being
		 * initialized.
		 */
		if (ioctl(datafd, I_PUSH, "ldterm") == -1){
#ifdef DEBUG
saveerrno = errno;
debug("%d:setuptpdev():FAILED\tioctl(I_PUSH, \"ldterm\"):%s\n",getpid(),
strerror(saveerrno));
errno = saveerrno;
#endif
			console(MM_ERROR,
			    ":58:Pushing STREAMS module(s) %s failed:%s\n",
				"ldterm", strerror(errno));
			tpinf.tpinf_dconnid = 0;
			(void)tp_datadisconnect(ctrlfd, &tpinf);
			(void)close(datafd);
			(void)close(ctrlfd);
			return (FAILURE);
		}

		/*
		 * Since this function is typically invoke by the "real" init
		 * process (ie. pid == SPECIALPID), change ctrlfd and datafd
		 * to be outside the range that would be occupied by stdin,
		 * stdout, and stderr. Also set close on exec flag.
		 */
		tmpfd = ctrlfd;
		ctrlfd = fcntl(ctrlfd, F_DUPFD, 3);
		(void)fcntl(ctrlfd, F_SETFD, 1);
		(void)close(tmpfd);
		tmpfd = datafd;
		datafd = fcntl(datafd, F_DUPFD, 3);
		(void)fcntl(datafd, F_SETFD, 1);
		(void)close(tmpfd);

		*ctrlfdp = ctrlfd;
		*datafdp = datafd;
		/*
		 * Assuming the recieving buffer is large enough.
		 */
		strcpy(datadsfnamep, datadsfname);
	}
#ifdef DEBUG
debug("%d:setuptpdev():RETURN\tSUCCESS device = %s\n",getpid(),ttyname(datafd));
#endif
	return (SUCCESS);
}

/*
 * Procedure:     getttyname
 *
 * Restrictions:
                 ttyname: None
 * Notes:
 * getttyname(fd, flag)
 *
 * Get the ttyname of the real/physical tty device linked under the TP device.
 *
 * -flag: Valid flags values are as follows:
 *		GETTTYNM_ONLYTP: This flag indicates that the real/physical
 *			device name will only be returned if the real/physcial
 *			device is linked under a TP device.
 *
 * -Call tp_fgetinf() to return information from the TP device regarding the
 *  real/physical tty device linked underneath.
 * -From the information retrieved from the TP device, load a stat(4) struture's
 *  st_mode, st_ino, st_dev, and st_rdev fields.
 * -Call sttyname() to get the tty path name, which will be the path name of
 *  the real/physical tty device linked under the TP device.
 *
 * NOTE: If tp_fgetinf() fails then this file descriptor is not associated
 *	 with a Trusted Path (ie. it is not a TP data or cons channel).
 *	 If the GETTYNM_ONLYTP flag is set, NULL is returned.  If GETTYNM_ONLYTP
 *	 is not set, ttyname(3C) of fd is returned.
 * NOTE: If the TP information indicates no multiplexor id, then the
 *	 real/physical device is not linked under the TP device.  A
 *	 NULL device is returned.
 */
char *
getttyname(fd, flag)
int	fd;
int	flag;
{
	struct stat	statbuf;
	struct tp_info	tpinf;		/* Information structure for TP device*/
#ifdef DEBUG
debug("%d:gettyname():ENTER\n",getpid());
#endif

	
	if (tp_fgetinf(fd, &tpinf) == -1){
		if (flag & GETTTYNM_ONLYTP){
#ifdef DEBUG
debug("%d:getttyname():RETURN\tGETTYNM_ONLYTP SET and tp_fgetinf() FAILED\n",
getpid());
#endif
			return ((char *)NULL);
		}else{
#ifdef DEBUG
debug("%d:getttyname():RETURN\tGETTYNM_ONLYTP NOT SET and tp_fgetinf() FAILED %s\n",
getpid(), ttyname(fd));
#endif
			return (ttyname(fd));
		}
	}else if (tpinf.tpinf_muxid == 0){
#ifdef DEBUG
debug("%d:getttyname():RETURN\tNO REAL DEVICE LINKED UNDER TP DEVICE\n",
getpid());
#endif
		return ((char *)NULL);
	}else{
		statbuf.st_mode = tpinf.tpinf_rdevmode;
		statbuf.st_ino = tpinf.tpinf_rdevino;
		statbuf.st_dev = tpinf.tpinf_rdevfsdev;
		statbuf.st_rdev = tpinf.tpinf_rdev;
#ifdef DEBUG
debug("%d:getttyname():RETURN\t%s\n",getpid(), sttyname(&statbuf));
#endif
		return (sttyname(&statbuf));
	}
}

/*
 * Procedure:     set_autopush
 *
 * Restrictions:
                 open(2): None
                 ioctl(2): None
*/
/*
 *	set autopush configuration information for TP CONS channel.
 */
int
set_autopush()
{
	struct strapush push;	/* configuration information */
	int sadfd;		/* file descriptor to SAD driver */
	int retcode = 0;	/* return code */
#ifdef DEBUG
debug("%d:set_autopush():ENTER\n",getpid());
#endif

	if (tpmajornum != (major_t)NODEV){
		if ((sadfd = open(ADMINDEV, O_RDWR)) < 0) {
			console(MM_ERROR,
			    ":59:Could not open %s:%s\n" ,
				ADMINDEV, strerror(errno));
#ifdef DEBUG
#endif
			return (FAILURE);
		}

		push.sap_cmd = SAP_ONE;
		push.sap_major = devtab[DTTAG_TP_CONSDEV].dt_major;
		push.sap_minor = devtab[DTTAG_TP_CONSDEV].dt_minor;
		push.sap_lastminor = 0;	/* indicates no range */
		push.sap_npush = 1;
		/*
		 * NOTE (For Future Enhancement): For added flexibility,
		 * may want to get the list of STREAMS modules to push
		 * from either a default file (/etc/default/init) or from
		 * the real/physical console device DSF autopush (ie. XX.ap)
		 * file.
		 */
		strcpy((char *)(&push.sap_list[0][0]), "ldterm");

		if (ioctl(sadfd, SAD_SAP, &push) < 0) {
			retcode = errno;
			console(MM_ERROR,
			    ":60:Could not configure autopush for line %s:%s\n",
				devtab[DTTAG_TP_CONSDEV].dt_dsfname, strerror(errno));
			switch (retcode) {
	
			case EINVAL:
				console(MM_ERROR,
				    ":61:\tInvalid major device number or invalid module name or too many modules\n");
				break;

			case ENOSTR:
				console(MM_ERROR,
				    ":62:Major device is not a STREAMS driver\n");
				break;

			case EEXIST:
				console(MM_ERROR,
				    ":63:Major/minor already configured\n");
				break;

			case ENOSR:
				console(MM_ERROR,
				    ":64:Ran out of autopush structures");
				break;

			case ERANGE:
				console(MM_ERROR,
				    ":65:lastminor must be greater than minor\n");
				break;

			default:
				break;
			} /* switch */
#ifdef DEBUG
debug("%d:set_autopush():RETURN\t FAILED %s\n",getpid(), strerror(retcode));
#endif
			(void)close(sadfd);
			return (FAILURE);
		} /* if */
		(void)close(sadfd);
	} /* if tpmajornum */
#ifdef DEBUG
debug("%d:set_autopush():RETURN\t SUCCESS\n",getpid());
#endif
	return (SUCCESS);
}

