/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _IO_CONF_H	/* wrapper symbol for kernel use */
#define _IO_CONF_H	/* subject to change without notice */

#ident	"@(#)kern-i386at:io/conf.h	1.29"
#ident	"$Header: $"

#if defined(__cplusplus)
extern "C" {
#endif

/*
 * Configuration specific defines and structures.
 */

#ifdef _KERNEL_HEADERS

#include <util/types.h> /* REQUIRED */

#elif defined(_KERNEL) || defined(_KMEMUSER)

#include <sys/types.h> /* REQUIRED */

#endif /* _KERNEL_HEADERS */

/*
 * Device flags.
 *
 * Bit 0 to bit 15 are reserved for kernel.
 * Bit 16 to bit 31 are reserved for different machines.
 */
#define D_NEW		0x00	/* new-style driver */
#define	D_OLD		0x01	/* old-style driver; no longer supported */
#define D_DMA		0x02	/* driver does DMA */
#define D_BLKOFF	0x400	/* driver understands b_blkoff; */
				/* i.e. is byte addressable */
/*
 * Added for UFS.
 */
#define D_SEEKNEG       0x04    /* negative seek offsets are OK */
#define D_TAPE          0x08    /* magtape device (no bdwrite when cooked) */
/*
 * Added for ease of transition from pre-DDI drivers.  By not setting this
 * flag, the driver only sees pre-SVR4-style buffers.
 */
#define D_NOBRKUP	0x10	/* no breakup needed for new drivers */
/*
 * Security additions, for drivers requiring special MAC access policies.
 */
#define D_INITPUB	0x20	/* device is public in system setting */
#define D_NOSPECMACDATA	0x40	/* no MAC access check for data transfer */ 
				/* and no inode access time change */ 
#define D_RDWEQ		0x80	/* destructive reads, read equal, write eq */
#define SECMASK		(D_INITPUB|D_NOSPECMACDATA|D_RDWEQ)
				/* mask of all security flags */
/*
 * d_auxflag values
 */
#define DAF_REQDMA	0x1	/* driver is ddi version 5 or less */
#define DAF_PHYSREQ	0x2	/* driver is ddi version 4 or less */

/*
 * MP-related flags.
 */
#define D_MP		0x100	/* driver/module is MP */
#define D_UPF		0x200	/* mux is UP-friendly */
/*
 * End of devflag definitions.
 */

#define ROOTFS_NAMESZ	7	/* Maximum length of root fstype name */

#define	FMNAMESZ	8	/* max length of streams module name */

#if defined _KERNEL || defined _KMEMUSER

/*
 * Declaration of block device switch. Each entry (row) is
 * the only link between the main unix code and the driver.
 * The initialization of the device switches is in the file conf.c.
 */
struct bdevsw {
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_strategy)();
	int	(*d_size)();
	int	(*d_devinfo)();
	char	*d_name;
	struct iobuf	*d_tab;
	int	*d_flag;
	int	d_cpu;
	struct module	*d_modp;
};

/*
 * Character device switch.
 */
struct cdevsw {
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_read)();
	int	(*d_write)();
	int	(*d_ioctl)();
	int	(*d_mmap)();
	int	(*d_segmap)();
	int	(*d_poll)();
	int	(*d_msgio)();
	int	(*d_devinfo)();
	int	d_auxflag;
	struct streamtab *d_str;
	char	*d_name;
	int	*d_flag;
	int	d_cpu;
	struct module *d_modp;
};

/*
 * Parameter types for d_devinfo()
 */

typedef enum di_parm {
	DI_BCBP,
	DI_MEDIA
} di_parm_t;

/*
 * STREAMS module information
 */

struct fmodsw {
	char	f_name[FMNAMESZ+1];
	struct streamtab *f_str;
	int	*f_flag;		/* same as device flag */
	struct module	*f_modp;
};

/*
 * Console-capable device table
 */

struct constab {
	char	*cn_name;
	struct conssw *cn_consswp;
	int	cn_cpu;
};

/*
 * Statically-linked (non-autoconfig) modules which need interrupts
 */
struct intr_list {
	char	*il_name;	/* module name */
	int	*il_devflagp;	/* pointer to module's devflag */
	void	(*il_handler)();
};

/*
 * Configuration data for loadable modules.  Generated by the configuration
 * tools and pointed to by the module wrapper.
 */
struct mod_conf_data {
	uint_t	mcd_version;	/* version number of this structure */
	time_t	mcd_unload_delay;
};

#define MCD_VERSION	1	/* current version of mod_conf_data */

/*
 * Interface definitions.  Used by DLM to verify interface conformance
 * and to do symbol remapping for compatibility interfaces.
 */

struct intfc_sym {
	char	*ifs_name;
	char	*ifs_newname;
};

struct interface {
	char	*if_name;
	char	*if_version;
	struct intfc_sym *if_symbols;
	char	*if_depends;
	struct interface *if_next_intfc;
	struct interface *if_next_ver;
	struct interface *if_rep_intfc;
	int	if_order;
};

#define SYM_DROPPED	((char *)-1)

#endif /* _KERNEL || _KMEMUSER */

#if defined _KERNEL

extern struct bdevsw bdevsw[];
extern struct cdevsw cdevsw[];
extern struct fmodsw fmodsw[];
extern struct constab constab[];
extern struct intr_list static_intr_list[];
extern struct interface interfaces[];

extern int	bdevcnt;
extern int	cdevcnt;
extern int	fmodcnt;
extern int	conscnt;

extern int bdevswsz;
extern int cdevswsz;
extern int fmodswsz;

#endif /* _KERNEL */

#if defined(__cplusplus)
        }
#endif
#endif /* _IO_CONF_H */
