/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _UTIL_IPL_H	/* wrapper symbol for kernel use */
#define _UTIL_IPL_H	/* subject to change without notice */

#ident	"@(#)kern-i386at:util/ipl.h	1.37"
#ident	"$Header: $"

#if defined(__cplusplus)
extern "C" {
#endif

#ifdef _KERNEL_HEADERS

#include <proc/disp_p.h> /* PORTABILITY (for do_softint and EVT_xxx) */
#include <util/types.h> /* REQUIRED */

#elif defined(_KERNEL) || defined(_KMEMUSER)

#include <sys/disp_p.h> /* PORTABILITY (for do_softint and EVT_xxx) */
#include <sys/types.h> /* REQUIRED */

#endif /* _KERNEL_HEADERS */


/*
 * Interrupt Priority Levels
 *
 * The following defines are used in misc.s to map
 * spl*() functions to interrupt priority levels,
 * and in initializing the intpri[] array in conf.c,
 * which is generated by the config command.
 * The interrupt priority (intpri) levels specified in the
 * master.d/ * /config files are SPL* constants, not ipl's.
 * Thus the spl to ipl mapping can be changed to add new spls and ipls
 * without changing the intpri values in the config files.
 *
 * PLHI is the priority level at which interrupts are entirely disabled
 * by clearing the IF flag with a cli instruction.
 * Interrupts are selectively disabled at lower priority levels
 * by loading interrupt masks into the PICs.
 */

#if !defined(_DDI)

/*      spl             ipl     */

#define PL0		0
#define PL1		1
#define PL2		2
#define PL3		3
#define PL4		4
#define PL5		5
#define PL6		6
#define PLHI		8
#define PL7		PLHI

#define INVPL		((pl_t)-1)	/* impossible PL value return value */

#define PLBASE		PL0		/* Block no interrupts */
#define PLTIMEOUT	PL1		/* Block functions scheduled by
					 * itimeout and dtimeout */
#define PLDISK		PL5		/* Block disk device interrupts */
#define PLSTR		PL6		/* Block STREAMS interrupts */
#define PLTTY		PLSTR		/* TTY driver interrupts */
#define PLMAX		(MAX_INTR_LEVELS - 1)	/* Block all interrupts */
#define PLXCALL		PLMAX		/* Cross-processor interrupts */

#ifdef UNIPROC
#define PLMIN		PL0		/* minimum ipl for locks. */
#else
#define PLMIN		PL1		/* minimum ipl for locks. */
#endif

/*
 * Define for the interrupt statistics gathering. MAX_INTR_LEVELS
 * should be set to the number of distinct ipl levels supported.
 */
#define MAX_INTR_LEVELS 10


#if defined(_KERNEL) || defined(_KMEMUSER)

/*
 * Since we drop the ipl and schedule timeouts in the clock interrupt handler
 * we can nest interrupts more than the number of distinct levels 
 * that are supported. 
 */
#define MAX_INTR_NESTING 50 

/*
 * Typedefs for collecting information on interrupt handlers.
 */

typedef struct {
	ulong_t	intr_count;	/* Number of interrupts for this bin/ipl */
	ulong_t	intr_start;	/* Start time for the handler */
	ulong_t	intr_mx;	/* max duration for which the handler ran */
	void	*intr_handler;	/* handler address */
	void	*intr_retpc;	/* pc to which the handler will return */
	void	*intr_mxhandler;	/* handler that ran for max time */
	void	*intr_mxretpc;	/* pc to which the handler (mx) returns */
} intr_stats_t;

typedef struct {
	int	intr_top;	/* the current top of stack */
	int	intr_stack[MAX_INTR_NESTING]; /* stack to maintain bin # */
} intr_stack_t;

#endif /* _KERNEL || _KMEMUSER */

#endif /* !_DDI */


#if defined(_KERNEL)

/*
 * Definitions for DDI/DKI complaint drivers.
 */
extern pl_t pl0;
extern pl_t pl1;
extern pl_t pl2;
extern pl_t pl3;
extern pl_t pl4;
extern pl_t pl5;
extern pl_t pl6;
extern pl_t pl7;

extern pl_t plbase;
extern pl_t pltimeout;
extern pl_t pldisk;
extern pl_t plstr;
extern pl_t plhi;

extern pl_t invpl;

#if !defined(_DDI)

/*
 * Software "Interrupt" messages
 */
#define STRSCHED	EVT_STRSCHED	/* streams scheduler */
#define GLOBALSOFTINT	EVT_GLOBCALLOUT	/* global software interrupt */
#define LOCALSOFTINT	EVT_LCLCALLOUT	/* local software interrupt */
#define NUDGE		EVT_RUNRUN	/* user mode reschedule */
#define KPNUDGE		(EVT_RUNRUN|EVT_KPRUNRUN)  /* kernel mode reschedule */


#ifndef UNIPROC

/*
 * Send cross-processor interrupt to nudge another engine, or
 * to ourself, to handle low-priority events.  Must be called with all
 * interrupts disabled (via DISABLE or FSPIN_LOCK).
 */ 

#define sendsoft(engp, val)	psm_sendsoft(engp - engine, val)

struct engine;
extern void psm_sendsoft(int, uint_t);

#else /* UNIPROC */

#define sendsoft(engp, val)	(l.eventflags |= (val))

#endif /* UNIPROC */

extern void globalsoftint(void);
extern void localsoftint(void);

#endif /* !_DDI */

#endif /* _KERNEL */

#if defined(__cplusplus)
	}
#endif

#endif /* _UTIL_IPL_H */
