/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef	_IO_XS_XS_H	/* wrapper symbol for kernel use */
#define	_IO_XS_XS_H	/* subject to change without notice */

#ident	"@(#)kern-i386sym:io/xs/xs.h	1.6"
#ident	"$Header: $"

#if defined(__cplusplus)
extern "C" {
#endif

/* 
 * Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1992
 * Sequent Computer Systems, Inc.   All rights reserved.
 *  
 * This software is furnished under a license and may be used
 * only in accordance with the terms of that license and with the
 * inclusion of the above copyright notice.   This software may not
 * be provided or otherwise made available to, or used by, any
 * other person.  No title to or ownership of the software is
 * hereby transferred.
 *
 * This software is furnished under a license and may be used
 * only in accordance with the terms of that license and with the
 * inclusion of the above copyright notice.   This software may not
 * be provided or otherwise made available to, or used by, any
 * other person.  No title to or ownership of the software is
 * hereby transferred.
 */

/*
 * Xylogics 781 16-port RS-232 terminal mux. STREAMS driver (xs) definitions.
 */

#if defined(_KERNEL)

/*
 * Misc. definitions.
 */
#define	XS_MAXPORTS	  16		/* 16 ports per 781 board */
#define XS_OBUF_SZ 	2048		/* 2k output buffer size */
#define XS_IBUF_SZ	1024		/* 1k input buffer size */

/*
 * An array of the following structures is declared in
 * the xs-driver's Space.c file.  In the future, it should
 * be generated by enhanced idtools, output to the conf.c file, 
 * based upon input from the driver's Master and System files.  
 * Each record describes the potential location of a 781 board 
 * on the specified SSM/VMEbus.
 */
struct xs_conf {
	uint	tag;			/* Currently used for logical unit # */
	int	configured;		/* Device configured in System file? */
        int     ssmno;			/* SSM/VMEbus where board resides. */
        paddr_t csr;			/* Board's configured control/status
					 * register base address on VMEbus */
	int	intlvl;			/* Board's configured interrupt level */
};

extern struct xs_conf *xs_conf[];	/* Configuartion attributes array */
extern int xs_nconf;			/* # elements in xs_conf */

/*
 * Structure for grouping global xs-driver data
 * together.  Consists of binary reconfiguration
 * parameters via the driver's Space.c file.
 */
typedef const struct xs_bin_conf {
	major_t	c_major;		/* Major device # for sc devices */
	uint 	bin;			/* SLIC bin for sc-interrupts */
	tcflag_t cflags;    		/* Initial termios cflags */
	tcflag_t iflags; 		/* Initial termios iflags */
	int	addwait;		/* Additional wait time factor */
	int	brktime;		/* Break duration in milliseconds */
	int	arcptime;		/* ARCP command timeout in msec */
	ushort	rxtime;			/* Input transfer timeout (in ms)*/
	ushort	ibufsize;		/* Minimal input buffer size */
	int	lowwater;		/* Output low water mark */
	uchar_t	printallocfail;		/* 0=don't print allocb fail */
	uchar_t	printoverflow;		/* 0=don't print overflow messages */
} xs_bconf_t;

extern xs_bconf_t xs_global;		/* Initialized in xs-driver's Space.c */

/*
 * Macros for extracting port # and board # from dev #
 */
#define XSPORT(x)	(minor((x)) & 0x0f)
#define XSBOARD(x)	(minor((x)) >> 4)
#define XSMINOR(bd,ln)	(((bd) << 4) | ((ln) & 0x0f))

#endif /* _KERNEL */

#if defined(__cplusplus)
	}
#endif

#endif /* _IO_XS_XS_H */
