Q /* --------------------------------- grbgi.c --------------------------------- */   / /* This is part of the flight simulator 'fly8'. 6  * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au). */  ; /* Vga graphics driver (uses Borland BGI graphics library).  */   #include "fly.h"   #ifdef FLY8_BC   #include <conio.h> #include <graphics.h>      #define DOSYNC		0x0001 #define BIGPAGE		0x0006  #define POSTSYNC	0x0008  #define INITED		0x1000  9 #define MAX_SYNC_WAIT	1000L	/* 1 second is long enough */   ! static Uint	LastColor = (Uint)-1;    LOCAL_FUNC int FAR BGISetVisual (int page)  {  	Ulong	lasttime;
 	int	port;   	if (2 == CS->device->colors) ! 		port = 0x3ba;		/* monochrome */  	else  		port = 0x3da;		/* colour */  	lasttime = st.lasttime;  " 	if (CS->device->flags & DOSYNC) {< 		while (inp (port) & 0x01) {	/* wait for Display Enabled */ 			sys_poll (26); 0 			if (st.lasttime - lasttime > MAX_SYNC_WAIT) {1 				LogPrintf ("%s: sync timed out\n", Gr->name);  				die ();  			} 		}  	} 	setvisualpage(page); - 	if (CS->device->flags & (DOSYNC|POSTSYNC)) { < 		while (inp (port) & 0x08) {	/* wait for Vert Sync start */ 			sys_poll (27); 0 			if (st.lasttime - lasttime > MAX_SYNC_WAIT) {1 				LogPrintf ("%s: sync timed out\n", Gr->name);  				die ();  			} 		} = 		while (!(inp (port) & 0x08)) {	/* wait for Vert Sync end */  			sys_poll (28); 0 			if (st.lasttime - lasttime > MAX_SYNC_WAIT) {1 				LogPrintf ("%s: sync timed out\n", Gr->name);  				die ();  			} 		}  	} 	return (0); }    LOCAL_FUNC int FAR BGISetActive (int page)  {  	setactivepage (page); 	return (0); }    LOCAL_FUNC void FAR $ BGIDrawTo (int x, int y, Uint color) {  	if (color != LastColor) { 		setcolor (color);  		LastColor = color; 	} 	lineto (x, y);  }    LOCAL_FUNC int FAR BGIWriteMode (int mode)  {  	switch (mode) {
 	case T_MSET:  		setwritemode (COPY_PUT); 		break; 	case T_MOR: 		exit(99);  		break;
 	case T_MXOR:  		setwritemode (XOR_PUT);  		break; 	} 	return (0); }    LOCAL_FUNC int FAR! BGISetPalette (int index, long c)  {   > 	setrgbpalette (index, C_RGB_R (c), C_RGB_G (c), C_RGB_B (c)); 	return (0); }    LOCAL_FUNC int FAR$ BGIInit (DEVICE *dev, char *options) {  	long	temp; + 	int	gdriver = DETECT;	/* auto detection */  	int	gmode;  	int	errorcode;    /* initialize graphics mode  */" 	initgraph (&gdriver, &gmode, "");, 	if (grOk != (errorcode = graphresult ())) {+ 		LogPrintf ("GrBGI Graphics error: %s\n",   			grapherrormsg (errorcode));+ 		return (1);		/* return with error code */  	}   	dev->sizex = getmaxx () +1; 	dev->sizey = getmaxy () +1;   	dev->npages = 1;   , 	if (get_narg (options, "shutters=", &temp)) 		st.misc[7] = (int)temp;  	else  		st.misc[7] = 0;    	Gr->flags |= INITED;    	return (0); }    LOCAL_FUNC void FAR  BGITerm (DEVICE *dev)  {  	if (!(Gr->flags & INITED)) 	 		return;  	Gr->flags &= ~INITED;   	dev = dev;  	closegraph ();  }    LOCAL_FUNC void FAR 7 BGIEllipse (int x1, int y1, int rx, int ry, Uint color)  {  	if (color != LastColor) { 		setcolor (color);  		LastColor = color; 	}  	ellipse (x1, y1, 0, 0, rx, ry); }    LOCAL_FUNC void FAR  BGIClear (SCREEN *scr) {  	setbkcolor (scr->BgColor);  	cleardevice (); }    LOCAL_FUNC int FAR BGIShutters (int eye)  {  	if (st.misc[7]) { 		if (eye >= 0)   			outp (st.misc[7]+4, 1+2*eye); 		else if (-1 == eye) $ 			outp (st.misc[7]+4, 1);		/* on */ 		else if (-2 == eye) % 			outp (st.misc[7]+4, 0);		/* off */ $ 		return (0);				/* have shutters */ 	} else " 		return (1);				/* no shutters */ }    struct GrDriver NEAR GrBGI = {	 	"GrBGI",  	0,  	NULL,	/* extra */ 	0, 	 	BGIInit, 	 	BGITerm,  	moveto, 	BGIDrawTo,  	BGISetVisual, 	BGISetActive, 	0	/* BGIClear */, 	BGIWriteMode, 	BGISetPalette,  	BGIEllipse, 	0,	/* Flush */  	BGIShutters };  
 #undef DOSYNC  #undef BIGPAGE #undef POSTSYNC 
 #undef INITED  #undef MAX_SYNC_WAIT   #endif /* ifdef FLY8_BC */