P /* --------------------------------- grwing.c ------------------------------- */  / /* This is part of the flight simulator 'fly8'. 6  * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au). */  . /* Graphics driver for Microsoft Windows Wing.;  * Windows support by Michael Taylor miket@canb.auug.org.au  */   #define STRICT #include <windows.h> #include <wing.h>    #include "fly.h" #include "common.h"  #include "bgr.h" #include "vgr.h"    # extern int FAR ResetPalette (void);    #define GRG_STATS	0x0001 #define GRG_VGR		0x0002  #define INITED		0x1000   #define COLOR_PLANE	16   static HDC		memhdc = 0; % static HBITMAP		mybm1 = 0, oldbm = 0;  static RECT		rect; static COLORREF		*colors = 0;  static HPALETTE		hpal = 0;! static RGBQUAD		*aPaletteRGB = 0; $ static void FAR 	*p1SurfaceBits = 0; static struct Info { 	BITMAPINFOHEADER	InfoHeader;  	RGBQUAD			ColorTable[256]; 
 }			*Info;" static PALETTEENTRY	*aPalette = 0; static LOGPALETTE	*plgpl;  static Uint		rcolor[256];  	  LOCAL_FUNC int FAR grvw_bank (int bank) { G 	vSetMem ((char far *)((char huge *)p1SurfaceBits + bank * 0x10000UL));  	return (0); }    static void FAR  WinGChangeSize ()  {  	HBITMAP	newbm;  	RECT	rect;  	RECT	wrect; 	int	wx, wy, newx;   	sim_set (); 	screen_empty ();   " 	GetClientRect (ghWndMain, &rect);# 	GetWindowRect (ghWndMain, &wrect);   H 	wx = wrect.right - wrect.left - rect.right;	/* extra size of borders */M 	wy = wrect.bottom - wrect.top - rect.bottom;	/* extra size of caption etc */ 3 	newx = wx+((unsigned)((8*rect.right+31)&(~31))/8);   ( 	if (newx != wrect.right - wrect.left) {0 		/* make sure window size is a multiple of 8 */> 		SetWindowPos (ghWndMain, HWND_TOP, 0, 0, newx, rect.bottom,  			SWP_NOMOVE); # 		GetClientRect (ghWndMain, &rect);  	}   /* Initialise Info structure */1 	WinGRecommendDIBFormat ((BITMAPINFO far *)Info);   7 /* Set the width and height of the DIB but preserve the 4  * sign of biHeight in case top-down DIBs are faster */* 	Info->InfoHeader.biHeight *= rect.bottom;' 	Info->InfoHeader.biWidth = rect.right; @ 	if T(newbm = WinGCreateBitmap (memhdc, (BITMAPINFO FAR *)Info,  					 &p1SurfaceBits)) {' 		mybm1 = SelectObject (memhdc, newbm);  		DeleteObject (mybm1);  		mybm1 = newbm; 	} 	ResetPalette ();    	if (Gr->flags & GRG_VGR) { & 		vSetMem ((char far *)p1SurfaceBits);1 		vSetSize (rect.right, rect.bottom, rect.right); 	 	} else { * 		bSetActive ((char huge *)p1SurfaceBits);1 		bSetSize (rect.right, rect.bottom, rect.right);  	}  (   	set_screen (rect.right, rect.bottom); 	screen_start ();  	sim_reset (); }    #if 0 % static void ClearSystemPalette(void);  #endif  C static HPALETTE CreateIdentityPalette(RGBQUAD aRGB[], int nColors);    static int maxused = 0;    extern int FAR ResetPalette (void)  {  	Uint	i;	 	Ulong	c;    	if (hpal) {2 		for (i = COLOR_PLANE; i <= (Uint)maxused; ++i) { 			c = colors[i]; : 			aPaletteRGB[i-COLOR_PLANE].rgbRed      = GetRValue (c);: 			aPaletteRGB[i-COLOR_PLANE].rgbGreen    = GetGValue (c);: 			aPaletteRGB[i-COLOR_PLANE].rgbBlue     = GetBValue (c);. 			aPaletteRGB[i-COLOR_PLANE].rgbReserved = 0; 		}  		if (hpal)  			DeleteObject (hpal);    #if 0  	  	ClearSystemPalette();  #endif7 		hpal = CreateIdentityPalette(aPaletteRGB, maxused+1);    		UnrealizeObject (hpal); # 		SelectPalette (hdc, hpal, FALSE);  		RealizePalette (hdc);  		# /* match the DIB color table to the 0  * current palette to match the animated palette6  * Alas, palette entries are r-g-b, rgbquads are b-g-r */- 		GetPaletteEntries (hpal, 0, 256, aPalette);  		for (i = 0; i < 256; ++i) { 2 			aPaletteRGB[i].rgbRed      = aPalette[i].peRed;4 			aPaletteRGB[i].rgbGreen    = aPalette[i].peGreen;3 			aPaletteRGB[i].rgbBlue     = aPalette[i].peBlue; " 			aPaletteRGB[i].rgbReserved = 0; 		} 5 		WinGSetDIBColorTable (memhdc, 0, 256, aPaletteRGB);    /* convert to real position  */& 		for (i = 0; i <= (Uint)maxused; ++i)8 			rcolor[i] = GetNearestPaletteIndex (hpal, colors[i]); 	} 	return (0); }    LOCAL_FUNC int FAR WinGSetActive (int page) { 
 	page = page;  	return (0); }    LOCAL_FUNC int FAR WinGSetVisual (int page) { 
 	page = page;  #if 0  	if (resetSSize) { 		WinGChangeSize (); 		resetSSize = 0;  	} else   & /* copy the WinG Bitmap to the display */= 		WinGBitBlt (hdc, 0, 0, CS->sizex, CS->sizey, memhdc, 0, 0);  #endif 	return (0); }    LOCAL_FUNC int FAR WinGSetPalette (int n, long c) {  	n = st.colors[n]; 	if (n > maxused)  		maxused = n;9 	colors[n] = RGB (C_RGB_R (c), C_RGB_G (c), C_RGB_B (c));    	ResetPalette ();  	return (0); }    LOCAL_FUNC int FAR& WinGInit (DEVICE *dev, char * options) {  	int i;  	  	Gr->flags &= GRG_VGR;  	if (get_arg (options, "stats")) 		Gr->flags |= GRG_STATS;   % /* allocate all large data structures  */7 	colors = (COLORREF *)malloc (256 * sizeof (COLORREF)); A 	aPalette = (PALETTEENTRY *)malloc (256 * sizeof (PALETTEENTRY)); : 	aPaletteRGB = (RGBQUAD *)malloc (256 * sizeof (RGBQUAD));5 	Info = (struct Info *)malloc (sizeof (struct Info));  		( 	if (dev->sizex == 0 || dev->sizey == 0)
 		return (1);    	for (i = 0; i < 256; ++i) 		colors[i] = 0; 	  	ghWndMain = CreateWindow( 			(LPSTR)Fly8AppName, 			(LPSTR)Fly8Message, 			WS_OVERLAPPEDWINDOW,  			0,			/*  x  */  			0,			/*  y  */  			dev->sizex,		/* cx  */  			dev->sizey,		/* cy  */  			(HWND)0,		/* no parent */" 			(HMENU)0,		/* use class menu */8 			(HANDLE)Fly8Instance,	/* handle to window instance */' 			(LPSTR)0		/* no params to pass on */  			);    /* Make window visible */" 	ShowWindow (ghWndMain, SW_SHOW ); 	UpdateWindow (ghWndMain);   	hdc = GetDC (ghWndMain); " 	GetClientRect (ghWndMain, &rect);(   	set_screen (rect.right, rect.bottom); 	    /* Set up an optimal bitmap  */? 	if (WinGRecommendDIBFormat((BITMAPINFO far *)Info) == FALSE) { 0 		MessageBox((HWND)0, (LPCSTR)"Cannot use WinG",' 				    (LPCSTR)"Fly8 Message", MB_OK); 
 		return (1);  	}  7 /* Set the width and height of the DIB but preserve the 4  * sign of biHeight in case top-down DIBs are faster */* 	Info->InfoHeader.biHeight *= rect.bottom;' 	Info->InfoHeader.biWidth = rect.right;   6 	if ((GetDeviceCaps (hdc, RASTERCAPS) & RC_BITBLT) && $ 	    T(memhdc = WinGCreateDC ()) && B 	    T(mybm1  = WinGCreateBitmap (memhdc, (BITMAPINFO FAR *)Info,  					 &p1SurfaceBits))) { ' 		oldbm = SelectObject (memhdc, mybm1); @ 		dev->npages = 1; /* WinG double-bufferred using WinGBitBlt! */	 	} else { 1 		MessageBox((HWND)0, (LPCSTR)"Cannot use WinG",  ' 				    (LPCSTR)"Fly8 Message", MB_OK); 
 		return (1);  	}   	dev->colors = 256;    	SetROP2 (memhdc, R2_COPYPEN); 	 1 	GetSystemPaletteEntries (hdc, 0, 256, aPalette);   6 /* Alas, palette entries are r-g-b, rgbquads are b-g-r */ 	for (i = 0; i < 256; ++i) {1 		aPaletteRGB[i].rgbRed      = aPalette[i].peRed; 3 		aPaletteRGB[i].rgbGreen    = aPalette[i].peGreen; 2 		aPaletteRGB[i].rgbBlue     = aPalette[i].peBlue;! 		aPaletteRGB[i].rgbReserved = 0;  	} #if 0  	ClearSystemPalette(); #endif0 	hpal = CreateIdentityPalette(aPaletteRGB, 256);  * 	for (i = 0; i < rangeof (st.colors); ++i)! 		st.colors[i] = COLOR_PLANE + i;    	if (Gr->flags & GRG_VGR) { < 		vInit ((char far *)p1SurfaceBits, rect.right, rect.bottom,  			rect.right, grvw_bank, NULL); 		vSetWriteMode (T_MSET); 	 	} else { 1 		bSetSize (rect.right, rect.bottom, rect.right); * 		bSetActive ((char huge *)p1SurfaceBits); 		bSetWriteMode (T_MSET);  	}   	usingWinG = 1;    	Gr->flags |= INITED;    	return (0); }    LOCAL_FUNC void FAR  WinGTerm (DEVICE *dev) {  	if (!(Gr->flags & INITED)) 	 		return;  	Gr->flags &= ~INITED;  * 	SetSystemPaletteUse (hdc, SYSPAL_STATIC);
 	if (hpal) 		DeleteObject (hpal); 	  	if (ghWndMain)  		ReleaseDC (ghWndMain, hdc);   
 	if (oldbm) {  		SelectObject (memhdc, oldbm);  		DeleteObject (mybm1);  		DeleteDC (memhdc); 	} 	  	free (colors);  	free (aPalette);  	free (aPaletteRGB);
 	free (Info); 
 	hpal = 0; 	ghWndMain = 0;  	oldbm = 0;  	memhdc = 0; 	mybm1 = 0; 	 	hdc = 0;    	dev = dev;    	if (Gr->flags & GRG_STATS)  		LogStats (); }      LOCAL_FUNC void FAR  WinGFlush (void) {  #if 1- 	if (resetSSize) { 		WinGChangeSize (); 		resetSSize = 0;- 	} else-  & /* copy the WinG Bitmap to the display */= 		WinGBitBlt (hdc, 0, 0, CS->sizex, CS->sizey, memhdc, 0, 0);u #endif }*   struct GrDriver NEAR GrWing = {o
 	"GrWing", 	0,o 	NULL,	/* extra */ 	0,l
 	WinGInit,
 	WinGTerm,	 	bMoveTo,d	 	bDrawTo,T 	WinGSetVisual,w 	WinGSetActive,i 	0,		/* Clear */ 	bSetWriteMode,e 	WinGSetPalette, 	bDrawEllipse, 	WinGFlush," 	0		/* Shutters */ };    struct GrDriver NEAR GrvWing = { 	"GrvWing",d	 	GRG_VGR,G 	NULL,	/* extra */ 	0,D
 	WinGInit,
 	WinGTerm,	 	vMoveTo, 	 	vDrawTo,C 	WinGSetVisual,t 	WinGSetActive,m 	0,		/* Clear */ 	vSetWriteMode,c 	WinGSetPalette,
 	vEllipse, 	WinGFlush,H 	0		/* Shutters */ };   static HPALETTE 2 CreateIdentityPalette(RGBQUAD aRGB[], int nColors) {c 	int	nStaticColors;A 	int	nUsableColors;r
 	int	j, i;	 	struct {l 		WORD		Version; 		WORD		NumberOfEntries; 		PALETTEENTRY	aEntries[256];	 	}	Palette;t	 	HDC	hdc;o   	Palette.Version = 0x300;t 	Palette.NumberOfEntries = 256;v  * /* Just use the screen DC where we need it */ 	hdc = GetDC(NULL);   , 	SetSystemPaletteUse (hdc, SYSPAL_NOSTATIC);  $ /* get the twenty static colors into4  * the array, then fill in the empty spaces with the  * given color table */  0 /* Get the static colors from the system palette *// 	nStaticColors = GetDeviceCaps(hdc, NUMCOLORS);-8 	GetSystemPaletteEntries(hdc, 0, 256, Palette.aEntries);   	for (i = 0; i < 10; i++)	" 		Palette.aEntries[i].peFlags = 0; 	for (i = 10; i < 246; i++)r, 		Palette.aEntries[i].peFlags = PC_RESERVED; 	for (i = 246; i < 256; i++)" 		Palette.aEntries[i].peFlags = 0;  1 /* Fill in the entries from the given color tabler */ 	nUsableColors = nColors; ) 	if (nUsableColors > 256 - nStaticColors) & 		nUsableColors = 256 - nStaticColors;< 	for (i = COLOR_PLANE, j = 0; j < nUsableColors; i++, j++) {/ 		Palette.aEntries[i].peRed   = aRGB[j].rgbRed;g1 		Palette.aEntries[i].peGreen = aRGB[j].rgbGreen; 0 		Palette.aEntries[i].peBlue  = aRGB[j].rgbBlue;, 		Palette.aEntries[i].peFlags = PC_RESERVED; 	}   /* Remember to release the DC! */ 	ReleaseDC(NULL, hdc); #if 0i* 	SetSystemPaletteUse (hdc, SYSPAL_STATIC); #endif   /* Return the palette	 */. 	return CreatePalette((LOGPALETTE *)&Palette); }s   #if 0R static void  ClearSystemPalette(void) {; /* A dummy palette setup */	 	struct {c 		WORD Version;s 		WORD NumberOfEntries;  		PALETTEENTRY aEntries[256];i 	}		Palette; 	HPALETTE	ScreenPalette = 0; 	HDC		ScreenDC;e 	int		Counter;  2 /* Reset everything in the system palette to black */ 	Palette.Version = 0x300;e 	Palette.NumberOfEntries = 256;c- 	for(Counter = 0; Counter < 256; Counter++) { & 		Palette.aEntries[Counter].peRed = 0;( 		Palette.aEntries[Counter].peGreen = 0;' 		Palette.aEntries[Counter].peBlue = 0;{4 		Palette.aEntries[Counter].peFlags = PC_NOCOLLAPSE; 	}  < /* Create, select, realize, deselect, and delete the palette */ 	ScreenDC = GetDC(NULL);7 	ScreenPalette = CreatePalette((LOGPALETTE *)&Palette);i 	if (ScreenPalette) { > 		ScreenPalette = SelectPalette(ScreenDC,ScreenPalette,FALSE); 		RealizePalette(ScreenDC);l> 		ScreenPalette = SelectPalette(ScreenDC,ScreenPalette,FALSE); 		DeleteObject(ScreenPalette); 	} 	ReleaseDC(NULL, ScreenDC);n }l #endif #undef GRG_STATS #undef GRG_VGR
 #undef INITED 