P /* --------------------------------- plane.h -------------------------------- */  / /* This is part of the flight simulator 'fly8'. 6  * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au). */  + /* Common header for plane dynamics models.  */   #ifndef FLY8_PLANE #define FLY8_PLANE   #include "hud.h"   typedef struct btrail	BTRAIL;  struct btrail {  	BTRAIL		*next; 
 	LVECT		R;	 	VECT		V; 
 	Uint		ms; };   typedef struct e_plane E_PLANE;  struct e_plane {/ 	struct e_parms	*parms;		/* plane parameters */ ) 	void		*private;	/* private model data */  	Ushort	flags; #define	PF_AUTO		0x0001  #define	PF_ONGROUND	0x0002 #define PF_CHASE	0x0004  #define PF_KILL		0x0008  #define PF_FLAMEOUT	0x0010 #define PF_GLIMIT	0x0020 #define PF_STALL	0x0040  #define PF_AUTOFLAP	0x0080 #define PF_AUTORUDDER	0x0100 #define PF_AUTOELEVATOR	0x0200 #define PF_NOSTALL	0x0400  #define PF_LIMITED	0x0800  	Ushort	hud; #define	HUD_ON		0x0001 #define	HUD_LADDER	0x0002  #define	HUD_BIG		0x0004  #define	HUD_FINE	0x0008  #define	HUD_XFINE	0x0010 #define	HUD_PLUS	0x0020  #define	HUD_CURSOR	0x0040  #define	HUD_VV		0x0080 #define	HUD_TARGET	0x0100  #define	HUD_DATA	0x0200  #define	HUD_RETICLE	0x0400 #define	HUD_ROSS	0x0800  #define	HUD_INFO	0x1000  #define	HUD_INFOM	0x7000, #define	HUD_DEFAULT	(HUD_TARGET|HUD_RETICLE) #define	HUD_FULLHEADING	0x8000
 	Ushort	hud1;  #define	HUD_TOP		0x0001  #define	HUD_LIMIT	0x0002 #define	HUD_CORNER	0x0004  #define	HUD_AALARM	0x0008  #define	HUD_VALARM	0x0010  #define	HUD_KNOTS	0x0020 #define	HUD_PANEL	0x0040 #define	HUD_ACCVECT	0x0080 #define	HUD_TYPE	0x0100  #define	HUD_TYPES	0x0700  #define	HUD_CLASSIC	(0*HUD_TYPE) #define	HUD_FA18	(1*HUD_TYPE)  #define	HUD_F16		(2*HUD_TYPE)  #define	HUD_F15		(3*HUD_TYPE)  #define	HUD_ETHER	(4*HUD_TYPE) #define	HUD_FLIR	(5*HUD_TYPE)  #define	HUD_PENDULUM	0x0800  #define	HUD_INAME	0x1000 #define	HUD_IDIST	0x2000 #define	HUD_THICK	0x4000 #define	HUD_BORDER	0x8000 
 	Ushort	hud2;  #define	HUD_ILS		0x0001  #define	HUD_VW 		0x0002  #define	HUD_ALTITUDE	0x0004  #define	HUD_SPEED	0x0008 #define	HUD_HEADING	0x0010< #define HUD_REALHEADING	0x0020		/* show real heding scale */ #define	HUD_HIDETGT	0x0040 #define	HUD_BETA	0x0080  #define HUD_XBREAK	0x0100  #define HUD_XGRID	0x02007 #define HUD_DIRECTOR	0x0400		/* show flight director */  #define HUD_WAYPOINT	0x0800 5 #define HUD_BTRAIL	0x1000		/* bullet trail history */ 8 #define HUD_CALIBRATED	0x2000		/* calibrated airspeed */1 #define HUD_TPOINTER	0x4000		/* target pointer */ ? #define HUD_VPOINTER	0x8000		/* variable size target pointer */ 
 	Ushort	hud3; , #define	HUD_GVV		0x0001		/* show ghost VV */ #define	HUD_CUE		0x0002  #define	HUD_XVAR	0x0004  #define	HUD_TRUEHEADING	0x0008 	Ushort	hudmode; #define	HM_LAND		0x0001  #define	HM_NAV		0x0002 #define	HM_DGFT		0x0004  #define	HM_CDIP		0x0008  #define	HM_DECLUTTER	0x0100  	Ushort	hdd; #define HDD_INSTRUMENTS	0x0001, #define	HDD_NAV		0x0002		/* show nav data */ #define	HDD_COMPASS	0x0004 #define	HDD_SQRCOMPASS	0x0008  #define	HDD_ORTCOMPASS	0x0010  	Ushort	ladder; 8 #define	LD_FIXED	0x0001		/* ladder fixed on waterline */9 #define	LD_RIGHT	0x0002		/* numerals on the right only */ 3 #define	LD_ERECT	0x0004		/* numerals do not roll */ 0 #define	LD_COLOR	0x0008		/* steps are colored *// #define	LD_FUNNEL	0x0010		/* tips are inside */ 0 #define	LD_SLANT	0x0020		/* steps are slanted */4 #define	LD_ZENITH	0x0040		/* zenith/nadir symbols */6 #define	LD_UNDER	0x0080		/* numerals under the step */2 #define	LD_TIP0		0x0100		/* show tip on horizon */+ #define	LD_HOLD		0x0200		/* hold ladder  */ 1 #define	LD_HOLDROLL	0x0400		/* hold on heading */ - #define	LD_SUN		0x0800		/* show sun symbol */ 6 #define	LD_NEGTIP	0x1000		/* -ve pitch tip inverted */ 	Ushort	radar; #define	R_ON		0x0001 #define	R_LOCK		0x0002 #define	R_INTEL		0x0004  #define	R_INTELCC	0x0008 #define	R_MODE		0x0010 #define	R_MODES		0x0070  #define	R_SHOOT		0x0080  #define	R_SELECT3	0x0100 #define	R_SELECT20	0x0200  #define	R_SELECT5	0x0400 	Ushort	equip;, #define	EQ_GEAR		0x0001		/* gear deployed */? #define	EQ_GEAR1	0x0002		/* true if gear1 has ground contact */  #define	EQ_GEAR2	0x0004  #define	EQ_GEAR3	0x0008  #define	EQ_GEAR4	0x0010  #define	EQ_GEAR5	0x0020 " 	short	weapon;			/* weapon type */ #define	WE_M61		0x0001 #define	WE_MK82		0x0002  #define	WE_LAST		0x0002  #define	N_WE		5 - 	short	stores[N_WE];		/* weapons available */ * #define MODEL_BASIC	0		/* opt[0] values */ #define MODEL_CLASSIC	1  #define MODEL_XPLANE	2 #define MODEL_YPLANE	3 #define MODEL_FPLANE	4 	Uchar	lamps[25];  #define LAMP_ON		0x01  #define LAMP_BLINK	0x02 ( #define LAMP_MASK	(LAMP_ON | LAMP_BLINK) #define LAMP_OK		0x04    #define LAMP_GREEN	LAMP_ON #define LAMP_BGREEN	LAMP_BLINK #define LAMP_OKGREEN	LAMP_OK #define LAMP_MGREEN	LAMP_MASK  #define LAMP_REDSHIFT	4 . #define LAMP_RED	(LAMP_ON    << LAMP_REDSHIFT)/ #define LAMP_BRED	(LAMP_BLINK << LAMP_REDSHIFT) 0 #define LAMP_OKRED	(LAMP_OK    << LAMP_REDSHIFT)/ #define LAMP_MRED	(LAMP_MASK  << LAMP_REDSHIFT) * #define LAMP_ALL	(LAMP_MGREEN | LAMP_MRED)   #define LAMP_GLIMIT	0  #define LAMP_STALL	1 #define LAMP_FUEL	2  #define LAMP_GEAR	3  #define LAMP_ALT	4 #define LAMP_PULLUP	5  #define LAMP_DAMAGE	6  #define LAMP_EJECT	7   #define LAMP_SET_GREEN(n,s) \ > 	(EX->lamps[n] = (Uchar)((EX->lamps[n] & ~LAMP_MGREEN) | (s))) #define LAMP_SET_RED(n,s) \ 6 	(EX->lamps[n] = (Uchar)((EX->lamps[n] & ~LAMP_MRED) \ 			| ((s) << LAMP_REDSHIFT)))  #define LAMP_SET_OFF(n) \  	(EX->lamps[n] &= ~LAMP_ALL)  2 	short		hudarea;	/* degrees from center to edge */ 	short		hudFontSize;! 	short		ils;		/* ils beacon id */  	Ushort		ilsRange; 	ANGLE		ilsHeading; , 	short		tapelen;	/* speed/alt scale range */# 	short		hudshift;	/* hud y shift */ % 	short		ldgap;		/* ladder gap size */ ' 	short		ldstep;		/* ladder step size */ * 	short		ldstep0;	/* ladder step 00 size */6 	short		ldstepg;	/* ladder step 00 (gear down) size */% 	short		ldtip;		/* ladder tip size */ / 	short		ldndash;	/* ladder -ve step n-dashes */ $ 	long		fuel;		/* fuel left [*100] */ 	short		fuelRate;	/* [*100] */+ 	short		throttle;	/* position [-100..100]*/ , 	short		afterburner;	/* position [0..100] */* 	short		elevators;	/* position [0..100] */, 	short		ailerons;	/* position [-100..100] */) 	short		rudder;		/* position [-70..70] */ ' 	short		flaps;		/* position [0..100] */ ( 	short		leFlaps;	/* position [0..100] */) 	short		spoilers;	/* position [0..100] */ 0 	short		tElevators;	/* trim position [0..100] */- 	short		tRudder;	/* trim position [0..100] */ ) 	short		airbrake;	/* position [0..100] */ ' 	short		brake;		/* position [0..100] */ ( 	short		gear[5];	/* position [0..100] */, 	short		power;		/* percent*100 [0..10000] */# 	short		thrust;		/* lb_thrust/10 */ " 	short		Gforce;		/* for display */  	short		maxG;		/* for display */ 	short		aoa;		/* for display */   	short		mach;		/* for display */$ 	VECT		a;		/* acceleration [body] */  	VECT		v;		/* velocity [body] */ 	short		StFont; 5 	Uchar		NEAR*  NEAR* StFontPtr;	/* StFonts[StFont] */  	short		StFontSize; ' 	OBJECT		*target;	/* aqcuired target */  	long		tid;		/* target id */ 	PID		*PIDthrottle;  	PID		*PIDpitch; 	PID		*PIDroll; 1 	VECT		taccel;		/* target average acceleration */ - 	VECT		tspeed;		/* target average velocity */ , 	BTRAIL		*btrail;	/* bullet trail history *// 	short		misc[20];	/* autopilot, history etc. */ ) #define EE(p)		(*(E_PLANE **)&(p)->extra) H #define	LIFETIME(p)	EE(p)->misc[0]	/* millisecs to next randomization */3 #define	SPEED(p)	EE(p)->misc[1]	/* desired speed */ 7 #define	HEADING(p)	EE(p)->misc[2]	/* desired heading */ 9 #define	ALTITUDE(p)	EE(p)->misc[3]	/* desired altitude */   #define	NEWTGT(p)	EE(p)->misc[4] };     typedef struct e_bomb E_BOMB;  struct e_bomb {  	LVECT		IP;  	long		timpact;  };  ) #define EBM(p)		(*(E_BOMB **)&(p)->extra)      struct e_parms { 	struct e_parms	*next; 	char	name[10];   ' 	long	weight;			/* empty weight [lb] */ / 	short	Ixx;			/* Ixx as I/Weight in kg-m2/kg */  	short	Iyy;			/* Iyy */  	short	Izz;			/* Izz */  	short	Izx;			/* Izx */*  " 	short	liftoff_speed;		/* [kts] */ 	short	max_lift;		/* [vm] */ 	short	min_lift;		/* [vm] */9 	ANGLE	pitch_rate;		/* at 300 knots full elev. [ang/s] */y7 	ANGLE	roll_rate;		/* at 300 knots full ail. [ang/s] */p, 	short	eyez;			/* pilot eye above cg [vm] */0 	short	eyey;			/* pilot eye forwad of cg [vm] */, 	ANGLE	gpitch;			/* pitch on ground [ang] */. 	long	ceiling;		/* operational ceiling [ft] */! 	short	stores[N_WE];		/* count */E  4 	short	brake_mu;		/* friction with brakes applied */2 	short	wheel_mu;		/* friction when freewheeling */   	short	mil_thrust;		/* [lbf] */n/ 	short	mil_sfc;		/* lb_fuel/(lb_thrust*hour) */d 	short	ab_thrust;		/* [lbf] *// 	short	ab_sfc;			/* lb_fuel/(lb_thrust*hour) */f0 	Ushort	fuel_capacity;		/* internal fuel [lb] */1 	ANGLE	Ea;			/* Engine rig ang vs. plane [ang] */14 	ANGLE	Eb;			/* Engine offset ang vs. plane [ang] */, 	short	Er;			/* Engine offset vs. cg [vm] */  ( 	short	wing_area;		/* wings area [vm] */( 	short	wing_span;		/* tip to tip [vm] */3 	short	wing_cord;		/* mean aerodynamic cord [vm] */f. 	short	ACy;			/* wing ac forward of cg [vm] */- 	short	ACz;			/* wing ac upward of cg [vm] */09 	ANGLE	Aoffset;		/* Wing rigging angle vs. plane [ang] */ * 	ANGLE	Cl0;			/* alpha where Cl=0 [ang] */* 	short	maxCl;			/* max Cl for wing foil */* 	short	minCl;			/* min Cl for wing foil */0 	short	FEff;			/* flaps effective alpha/flaps */0 	short	FEffCl;			/* flaps Clmax rate/DegFlaps */* 	short	lefEffCl;		/* Clmax/LE flaps deg */: 	short	efficiency_factor;	/* Oswald's efficiency factor */, 	short	Cm0w;			/* wing foil Cm at 0 alpha */   	short	tail_area;		/* [vm] */d 	short	tail_span;		/* [vm] */	/ 	short	TACy;			/* tail ac forward of cg [vm] */_. 	short	TACz;			/* tail ac upward of cg [vm] */8 	ANGLE	Toffset;		/* Tail rigging angle vs. wing [ang] */  	short	Tvol;			/* tail volume */+ 	short	TmaxCl;			/* max Cl for tail foil */x+ 	short	TminCl;			/* min Cl for tail foil */H   	short	rudd_area;		/* [vm] */8 	short	rudd_span;		/* [vm] */U1 	short	RACy;			/* rudder ac forward of cg [vm] */U0 	short	RACz;			/* rudder ac upward of cg [vm] */- 	short	RmaxCl;			/* max Cl for rudder foil */	  , 	short	Cdp0;			/* parasitic drag: profile */0 	short	Cds;			/* parasitic drag: speed brakes */( 	short	Cdg;			/* parasitic drag: gear */0 	short	CdMK82;			/* parasitic drag: each MK82 */  ' 	ANGLE	MaxFlaps;		/* max flaps [ang] */ , 	ANGLE	MaxLEFlaps;		/* max LE flaps [ang] */- 	ANGLE	MaxSpoilers;		/* max spoilers [ang] */i/ 	ANGLE	MaxElevators;		/* max elevators [ang] *//- 	ANGLE	MaxAilerons;		/* max ailerons [ang] */0) 	ANGLE	MaxRudder;		/* max rudder [ang] */h  3 	ANGLE	AFamin;			/* AutoFlaps: min aoa to engage *//0 	short	AFrate;			/* AutoFlaps: flaps/aoa rate */8 	ANGLE	AFmax;			/* AutoFlaps: max flaps authority [%] */  6 	ANGLE	ALEFamin;		/* AutoLEFlaps: min aoa to engage */5 	short	ALEFrate;		/* AutoLEFlaps: leFlaps/aoa rate */U  2 	short	AErate;			/* AutoElevators: speed factor */  / 	short	APrate;			/* AutoPedals: speed factor */   % 	short	Cydr;			/* rudder sideforce */Q! 	short	Cybeta;			/* vx damping */M  ' 	short	Cm0;			/* total Cm at 0 alpha */F, 	short	Cmde;			/* elevators effectiveness */! 	short	Cmq;			/* pitch damping */s7 	short	Cmalpha;		/* alpha (stabilizer) induced pitch */a2 	short	Cmalphadot;		/* alpha rate induced pitch */  * 	short	Clda;			/* aileron effectiveness */  	short	Clp;			/* roll damping */& 	short	Clbeta;			/* dihedral effect */% 	short	Cldr;			/* roll from rudder */   ) 	short	Cndr;			/* rudder effectiveness */a 	short	Cnr;			/* yaw damping */T, 	short	Cnbeta;			/* weathercock stability */) 	short	Cnda;			/* ailerons induced yaw */f$ 	short	Cnp;			/* roll induced yaw */  # 	short	hudtype;		/* HUD_F16 etc. */o   	short	opt[10];		/* options */ 	PID	PIDthrottle;t 	PID	PIDpitch;
 	PID	PIDroll;a6 	struct gear {		/* gear tip position relative to cg */ 		short	x;		/* + means right */E! 		short	y;		/* + means forward */  		short	z;		/* - means down */* 		short	dgmax;		/* max strut deflection */( 		short	dtp;		/* tyre deflection at P */' 		short	P;		/* strut precharge force */G' 		short	Cv;		/* strut damping coeff. */	3 		ANGLE	emax;		/* Steering angle at full pedals. */** 		short	ur;		/* rolling friction coeff. */- 		short	ub;		/* full brake friction coeff. */Q+ 		short	us;		/* sideslip friction coeff. */p- 		short	rateup;		/* percent/sec raise rate */0- 		short	ratedn;		/* percent/sec lower rate */	 	} gear[5];o };   #define EEP(p)	EE(p)->parms  #define EP	EEP(p)I  
 #ifndef EX #define EX	EE(p) #endif  
 /* autop.c */nE extern void	FAR SetKillCorrection (OBJECT *p, OBJECT *target, VECT R,r 	int *tti); * extern void	FAR dynamics_auto (OBJECT *p);   /* engine.c */1 extern void	FAR f16engine (OBJECT *p, short sos);    /* gear.c */6 extern void	FAR LandGear (OBJECT *p, VECT F, VECT MM);) extern void	FAR LandGearDamp (OBJECT *p);A   /* oplane.c */6 #define DDshow(p,n,t,v)	if (CC==(p)) fDDshow (n, t, v)K #define CCshow(p,n,t,v)	if (CC==(p)&&(st.flags&SF_DEBUG)) fCCshow (n, t, v)DF #define CFshow(p,t,v)	if (CC==(p)&&(st.flags&SF_DEBUG)) fCFshow (t, v)F #define CAshow(p,t,v)	if (CC==(p)&&(st.flags&SF_DEBUG)) fCAshow (t, v)F #define CVshow(p,t,v)	if (CC==(p)&&(st.flags&SF_DEBUG)) fCVshow (t, v)  E extern void	FASTCALL FAR fDDshow (int frac, char *title, long value);fE extern void	FASTCALL FAR fCCshow (int frac, char *title, long value);c: extern void	FASTCALL FAR fCFshow (char *title, int value);: extern void	FASTCALL FAR fCAshow (char *title, int value);: extern void	FASTCALL FAR fCVshow (char *title, int value);  / extern void	FAR CCnote (OBJECT *p, char *note);u# extern void	FAR CCland (OBJECT *p); # extern void	FAR CCfly  (OBJECT *p);;& extern int	FAR check_land (OBJECT *p);) extern int	FAR check_takeoff (OBJECT *p);/- extern void	FAR supply (OBJECT *p, int mode);*9 extern void	FAR dampen (short *old, int new, int factor);s% extern int	FAR on_runway (OBJECT *p); * extern int	FAR dynamics_input (OBJECT *p);   /* om61.c */ #define	BULLETV		(1000*VONE) #define	BULLETSCATTER	(D90/180)e/ extern int	FAR BulletSpeed (OBJECT *p, VECT V);e  
 /* omk82.c */l- extern int	FAR BombSpeed (OBJECT *p, VECT V);l; extern int	FAR BombIP (LVECT R, VECT V, long tz, LVECT IP);*   /* prm.c */e? extern void 	(FAR* FAR flight_models[])(OBJECT *p, int action);[4 extern struct e_parms * FAR parms_get (char *pname);" extern void	FAR parms_free (void);   /* sixdof.c */; extern void	FAR SixDOF (OBJECT *p, VECT F, VECT MM, MAT I);i   #endif