P /* --------------------------------- sky.c ---------------------------------- */  / /* This is part of the flight simulator 'fly8'. 6  * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au). */  " /* Render the sky algorithmically. */   #include "fly.h"     #define NSIZE	(st.SkyLines*2+1)    static ANGLE	*skylines = 0;    extern int FAR sky_init (void)  {  	int	i;  	ANGLE	a, v;   	if (skylines) 		sky_term ();  @ 	skylines = (ANGLE *) memory_alloc (NSIZE * sizeof (*skylines)); 	if (!skylines) {  		MsgEPrintf (-50, "No Sky");  		st.flags &= ~SF_SKY;
 		return (1);  	} 	skylines[0] = 0;  	skylines[st.SkyLines] = D90;   	skylines[2*st.SkyLines] = D180;  $ 	for (i = 1; i < st.SkyLines; ++i) {# 		a = muldiv (i, D90, st.SkyLines);  		v = fmul (D90, SIN (a));$ 		skylines[st.SkyLines-i] = D90 - v;$ 		skylines[st.SkyLines+i] = D90 + v; 	} 	return (0); }    extern void FAR  sky_term (void)  {  	if (!skylines) 	 		return;   4 	memory_free (skylines, NSIZE * sizeof (*skylines)); 	skylines = 0; }    extern void FAR   show_sky (VIEW *view, OBJECT *p) { * 	int	orgx, orgy, maxx, maxy, sizex, sizey;2 	int	sroll, croll, srollh, crollh, spitch, cpitch; 	int	h, xh, yh;   	int	i, k, n, x[2], y[2], slope; 	ANGLE	a, z;
 	AVECT	aa; 	MAT	T;   ' 	if (!skylines || !(st.flags & SF_SKY)) 	 		return;   / 	get_area (view, &orgx, &orgy, &sizex, &sizey);    	maxx = VP->maxx;  	maxy = VP->maxy;   ! 	if (maxx < (i = (sizex+1) << 1))  		maxx = i; ! 	if (maxy < (i = (sizey+1) << 1))  		maxy = i;    	Mident (T); 	if (VP->roty) 		Mroty (T, -VP->roty);  	if (VP->rotx) 		Mrotx (T, -VP->rotx);  	if (VP->rotz) 		Mrotz (T, -VP->rotz);  	fMroty (T, p->siny, p->cosy); 	fMrotx (T, p->sinx, p->cosx); 	fMrotz (T, p->sinz, p->cosz); 	Mangles (0, T, aa, 0);    	i = ihypot2d (maxx, maxy);  	a = ATAN (i, VP->z);    	i = aa[X] - a;  	for (n = 0; n < NSIZE; ++n) 		if (skylines[n] >= i) 	 			break;  /*	a = a/2*3;*/    	sroll  = SIN (-aa[Y]);  	croll  = COS (-aa[Y]);   & 	srollh = muldiv (sroll, sizex, maxx);& 	crollh = muldiv (croll, sizey, maxy);  ? 	slope = iabs(fmul (croll, sizey)) > iabs(fmul (sroll, sizex));   & 	sroll  = muldiv (sroll, sizey, maxy);& 	croll  = muldiv (croll, sizex, maxx);   	gr_color (ST_SKY);        for (; n < NSIZE; ++n) {* 	z = skylines[n]			/* angle being shown */+ 	    -aa[X];			/* relative pitch of line */ . 	if (iabs (z) > (Uint)a)		/* trivial reject */ 		break;   	spitch = SIN (z); 	cpitch = COS (z);  $ 	h = muldiv (VP->z, spitch, cpitch);   	xh = fmul (h, srollh);  	yh = fmul (h, crollh);    	if (!croll) {  		if (xh > sizex || xh < -sizex) 			continue; 		x[0] = xh; 		y[0] = sizey;  		x[1] = xh; 		y[1] = -sizey; 	} else if (!sroll) {   		if (yh > sizey || yh < -sizey) 			continue; 		x[0] = sizex;  		y[0] = yh; 		x[1] = -sizex; 		y[1] = yh;	 	} else { " 		for (i = 0, k = 0; k < 2; ++k) { 			if (slope^k) {  				if (!k || xh >= 0) { 					x[i] = sizex;& 					y[i] = yh-muldiv (x[i]-xh, sroll, 								croll); ) 					if (y[i] <= sizey && y[i] >= -sizey)  						if (++i >= 2) 
 							break;  				}  				if (!k || xh < 0) {  					x[i] = -sizex; & 					y[i] = yh-muldiv (x[i]-xh, sroll, 								croll); ) 					if (y[i] <= sizey && y[i] >= -sizey)  						if (++i >= 2) 
 							break;  				}  				if (0 == i)  					break;  			} else {  				if (!k || yh >= 0) { 					y[i] = sizey;& 					x[i] = xh-muldiv (y[i]-yh, croll, 								sroll); ) 					if (x[i] <= sizex && x[i] >= -sizex)  						if (++i >= 2)  								break; 				}  				if (!k || yh < 0) {  					y[i] = -sizey; & 					x[i] = xh-muldiv (y[i]-yh, croll, 							sroll);) 					if (x[i] <= sizex && x[i] >= -sizex)  						if (++i >= 2) 
 							break;  				}  				if (0 == i)  					break;  			} 		}  		if (i < 2) 			continue; 	}  # /* a mirror has left-right swapped.  */ 	if (VP->flags & VF_MIRROR) {  		x[0] = -x[0];  		x[1] = -x[1];  	}    	gr_move (orgx+x[0], orgy-y[0]);  	gr_draw (orgx+x[1], orgy-y[1]);     }  }  #undef NSIZE