/*
** 
**  $Header: /usr/home/hellmann/nedit_add_ons/RCS/pref_dialog.c,v 1.2 96/05/10 14:53:00 hellmann Exp $
** 
**  FILENAME: pref_dialog.c
** 
**   PURPOSE: General preferences dialog functions.
** 
**    AUTHOR: Doug Hellmann
** 
**      DATE: 15 March 1996
** 
**  COMMENTS: 
** 
**    RCSLOG:   $Log:	pref_dialog.c,v $
** Revision 1.2  96/05/10  14:53:00  hellmann
** Completed functionality of preference dialog.
** 
** Revision 1.1  96/05/10  12:12:57  hellmann
** Initial revision
** 
** 
** 
*/

#include "client.h"
#include "pref_dialog.h"
#include "preferences.h"

	/*	D E F I N I T I O N S	*/

#ifdef LOCAL_PREF_FILE_NAME
#undef LOCAL_PREF_FILE_NAME
#endif
#define LOCAL_PREF_FILE_NAME ".mmake"

	/*	T Y P E D E F S	*/


	/*	G L O B A L S	*/

	/*	E X T E R N S	*/

extern Widget NeditCreateToplevelDialog(char*, char*, char*);

	/*	P R E D E C L A R A T I O N S   A N D   P R O T O T Y P E S	*/


/* 
**   PURPOSE: raise the pref dialog
** 
** ARGUMENTS: 
** 
**   RETURNS: 
** 
**  COMMENTS: 
*/ 
static void PrefDialogRaise(Widget w, XtPointer xtp1, XtPointer xtp2)
{
	Widget dialog = (Widget) xtp1;
	
	XtPopdown(dialog);
	XtPopup(dialog,  XtGrabNone);	
}

/* 
**   PURPOSE: add a button in the specified menu which will bring up the
**		preferences dialog
** 
** ARGUMENTS: label for button, menu for button
** 
**   RETURNS: button created
** 
**  COMMENTS: 
*/ 
Widget PrefDialogAttachToMenu(	char * label, 
				Widget parent_menu, 
				const PrefDescripRec PrefDescription[], 
				int pref_count)
{
	Widget button;
	XmString xstr;
	Widget dialog;
	
	xstr = XmStringCreateLtoR(label, XmSTRING_DEFAULT_CHARSET);
	
	button = XtVaCreateManagedWidget("preferences", xmPushButtonWidgetClass,
			parent_menu,
			XmNlabelString, xstr,
			NULL);
	XmStringFree(xstr);
	
	dialog = CreatePreferenceDialog(PrefDescription, pref_count);
	
	XtAddCallback(button, XmNactivateCallback, PrefDialogRaise, dialog);
	
	return button;
}

/* 
**   PURPOSE: take the contents of the dialog and store them in the
**		pref database in memory
** 
** ARGUMENTS: widget which is the parent of the pref interface pieces
** 
**   RETURNS: none
** 
**  COMMENTS: 
*/ 
static void PrefDialogGrabContents(Widget rc)
{
	WidgetList children;
	Cardinal numChildren;
	int i;
	
	XtVaGetValues(rc, XmNnumChildren, &numChildren,
			  XmNchildren, &children,
			  NULL);
	
	for (i = 0; i < numChildren; i++)
	{
		PrefDescripRec * storage;
		char * str_val;
		int i_val;
		
		XtVaGetValues(children[i], XmNuserData, &storage, NULL);
		
		if (!storage)
			continue;
		
#ifdef DEBUG
		fprintf(stderr, "Widget %d: %s has storage\n", 
				i, XtName(children[i]));
#endif
		
		switch (storage->dataType)
		{
			case PREF_STRING:
#ifdef DEBUG
				fprintf(stderr, "\tSave string\n");
#endif
				str_val = XmTextFieldGetString(children[i]);
				strcpy(storage->valueAddr, str_val);
				XtFree(str_val);
			break;

			case PREF_INT:
#ifdef DEBUG
				fprintf(stderr, "\tSave int\n");
#endif
				str_val = XmTextFieldGetString(children[i]);
				i_val = atoi(str_val);
				*((int*)(storage->valueAddr)) = i_val;
				XtFree(str_val);
			break;
			
			case PREF_BOOLEAN:
#ifdef DEBUG
				fprintf(stderr, "\tSave boolean\n");
#endif
				i_val = XmToggleButtonGetState(children[i]);
				*((int*)(storage->valueAddr)) = i_val;
			break;
			
			case PREF_ENUM:
				fprintf(stderr, "Can't handle enum yet\n");
			break;
			
			default:
				fprintf(stderr, "Unknown type %d\n", 
					storage->dataType);
			break;
		}
	}	
}

/* 
**   PURPOSE: close the pref dialog.
** 
** ARGUMENTS: standard callback
** 
**   RETURNS: 
** 
**  COMMENTS: 
*/ 
static void PrefDialogCancel(Widget w, XtPointer xtp1, XtPointer xtp2)
{
	Widget dialog = XtParent(XtParent(w));
	
	XtPopdown(dialog);
}


/* 
**   PURPOSE: close the pref dialog and accept changes
** 
** ARGUMENTS: standard callback
** 
**   RETURNS: 
** 
**  COMMENTS: 
*/ 
static void PrefDialogApply(Widget w, XtPointer xtp1, XtPointer xtp2)
{
	Widget rc = (Widget)xtp1;
	Widget dialog = XtParent(XtParent(w));
	
	PrefDialogGrabContents(rc);
	
	XtPopdown(dialog);
}

/* 
**   PURPOSE: save the new preferences
** 
** ARGUMENTS: callback
** 
**   RETURNS: 
** 
**  COMMENTS: 
*/ 
static void PrefDialogSave(Widget w, XtPointer xtp1, XtPointer xtp2)
{
	Widget rc = (Widget)xtp1;
	PrefDescripRec * PrefDescription;
	Cardinal numChildren;
	int numPrefs;
	
	XtVaGetValues(w, XmNuserData, &PrefDescription, NULL);
	XtVaGetValues(rc, XmNnumChildren, &numChildren, NULL);
	
	numPrefs = numChildren/2;
	
	PrefDialogGrabContents(rc);
	
	SavePreferences(TheDisplay, LOCAL_PREF_FILE_NAME, HeaderText,
	    PrefDescription, numPrefs); 
}

/* 
**   PURPOSE: Create a preferences dialog for a preference database passed in
** 
** ARGUMENTS: preference database description, number of items in the database
** 
**   RETURNS: toplevel shell of pref dialog
** 
**  COMMENTS: 
*/ 
Widget CreatePreferenceDialog(const PrefDescripRec PrefDescription[], int pref_count)
{
	Widget Return = NeditCreateToplevelDialog("pref_dialog", "Preferences", 
				"Preferences");
	Widget form, ok, save, cancel, def, sep, sw, rc;
	int i;
	XmString toggle_label = XmStringCreateSimple("");
	Dimension w, h;
	
	form = XtVaCreateManagedWidget("form", xmFormWidgetClass, Return, NULL);
	ok = XtVaCreateManagedWidget("Ok", xmPushButtonWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
	save = XtVaCreateManagedWidget("Save", xmPushButtonWidgetClass, form,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, ok,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNuserData, PrefDescription,
		NULL);
	cancel = XtVaCreateManagedWidget("Cancel", xmPushButtonWidgetClass, form,
		XmNrightAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
	
	def = XtVaCreateManagedWidget("Default", xmPushButtonWidgetClass, form,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, cancel,
		XmNbottomAttachment, XmATTACH_FORM,
		NULL); 	
		
	sep = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
		XmNorientation, XmHORIZONTAL,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, ok,
		NULL);
		
	sw = XtVaCreateManagedWidget("sw", xmScrolledWindowWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, sep,
		XmNscrollBarDisplayPolicy, XmAS_NEEDED,
		XmNscrollingPolicy, XmAUTOMATIC,
		XmNwidth, 340,
		XmNheight, 380,
		NULL);
	
	rc = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, 
		sw,
		XmNorientation, XmHORIZONTAL,
		XmNnumColumns, pref_count,
		XmNentryAlignment, XmALIGNMENT_BEGINNING,
		XmNpacking, XmPACK_COLUMN,
		NULL);
	XtVaSetValues(Return, XmNuserData, rc, NULL);

		/*
		** Callbacks - they require rc as data
		*/
	
	XtAddCallback(cancel, XmNactivateCallback, PrefDialogCancel, rc);
	XtAddCallback(save, XmNactivateCallback, PrefDialogSave, rc);
	XtAddCallback(ok, XmNactivateCallback, PrefDialogApply, rc);
	
		/*
		** Build the widgets specific for each pref.
		*/
	
	for (i = 0; i < pref_count; i++)
	{
		Widget label, edit;
		char * edit_name;
		char buf[32];
		int * int_data = (int*)PrefDescription[i].valueAddr;
		char * string_data = (char*)PrefDescription[i].valueAddr;
		
		
		edit_name = PrefDescription[i].name;
		label = XtVaCreateManagedWidget(PrefDescription[i].class,
				xmLabelWidgetClass, rc,
				XmNalignment, XmALIGNMENT_BEGINNING,
				XmNuserData, NULL,
				NULL);
		
		switch (PrefDescription[i].dataType)
		{
			case PREF_STRING:
				edit = XtVaCreateManagedWidget(edit_name,
						xmTextFieldWidgetClass, rc,
						NULL);
				XmTextFieldSetString(edit, string_data);
			break;

			case PREF_INT:
				edit = XtVaCreateManagedWidget(edit_name,
						xmTextFieldWidgetClass, rc,
						NULL);
				sprintf(buf, "%d", *int_data );
				XmTextFieldSetString(edit, buf);
			break;
			
			case PREF_BOOLEAN:
				edit = XtVaCreateManagedWidget(edit_name,
						xmToggleButtonWidgetClass, rc,
						XmNset, *int_data,
						XmNlabelString, toggle_label,
						NULL);
			break;
			
			case PREF_ENUM:
				fprintf(stderr, "Can't handle enum yet\n");
			break;
			
			default:
				fprintf(stderr, "Unknown type %d\n", 
					PrefDescription[i].dataType);
			break;
		}
		
		XtVaSetValues(edit, XmNuserData, (XtPointer) &(PrefDescription[i]), NULL);
	}
	
	XmStringFree(toggle_label);
	
	return Return;
}




