/*
** 
**  $Header: /usr/home/hellmann/nedit_add_ons/RCS/stringobj.c,v 1.3 96/06/03 11:35:04 hellmann Exp $
** 
**  FILENAME: stringobj.c
** 
**   PURPOSE: 
**   A string handler module implementing the abstract idea of a character
**   string. The characters of the string are indexed beginning from 0.
** 
**    AUTHOR: Doug Hellmann
** 
**      DATE: June, 1992
** 
**  COMMENTS: 
** 
**    RCSLOG:   $Log:	stringobj.c,v $
** Revision 1.3  96/06/03  11:35:04  hellmann
** Added stdlib.h
** 
** Revision 1.2  96/02/21  17:39:41  hellmann
** Added/updated header.
** 
** 
** 
*/

#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>

#include "stringobj.h"

struct StringStruct {
    char* the_string;
};

#ifndef _NO_PROTO
StringObj* StringObj_Create (char p[])
#else
StringObj* StringObj_Create (p)
char p[];
#endif
{
    StringObj *newp;

    newp = (StringObj *) malloc (sizeof (StringObj));
    newp->the_string = (char *) malloc (strlen (p) + 1);
    strcpy (newp->the_string, p);
    return newp;
}

        
    
#ifndef _NO_PROTO
void StringObj_Destroy (StringObj* strg)
#else
void StringObj_Destroy (strg)
StringObj * strg;
#endif
{
    if (strg!=NULL)
    {
        free (strg->the_string); 
        free (strg); 
    }
/*
    else
	printf("ERROR: Cannot Destroy a StringObj which has not been created.\n\n");
*/
}



#ifndef _NO_PROTO
int StringObj_Length (StringObj* strg)
#else
int StringObj_Length (strg)
StringObj * strg;
#endif
{
  if (strg!=NULL)
    return strlen(strg->the_string);

  fprintf(stderr, "ERROR: Cannot Length an uninitialized StringObj.\n\n");

  return 0;
}



#ifndef _NO_PROTO
int StringObj_CharIndex (StringObj* strg, int position, char c[])
#else
int StringObj_CharIndex (strg,position,c)
StringObj * strg;
int position;
char c[];
#endif
{
    if (strg!=NULL)
    {
        int i,len;

        len=StringObj_Length(strg);

        for(i=position;strchr(c,StringObj_CharAt(strg,i)) == NULL && i<len;i++);

        return (i<len) ? i
		       : -1;
    }
    else
    {
	printf("ERROR: Cannot CharIndex a StringObj which has not been initialized.\n\n");
	return -1;
    }
}


#ifndef _NO_PROTO
int StringObj_NCharIndex(StringObj* strg, int position, char c[])
#else
int StringObj_NCharIndex(strg,position,c)
StringObj * strg;
int position;
char c[];
#endif
{
    if (strg!=NULL)
    {
        int i,len;

        len=StringObj_Length(strg);

        for(i=position;strchr(c,StringObj_CharAt(strg,i)) != NULL && i<len;i++);

        return (i<len) ? i
                       : -1;
    }
    else
    {
	printf("ERROR: Cannot NCharIndex a StringObj which has not been initialized.\n\n");
	return -1;
    }
}


#ifndef _NO_PROTO
int StringObj_StrgIndex (StringObj* strg, int position, char s[])
#else
int StringObj_StrgIndex (strg,position,s)
StringObj * strg;
int position;
char s[];
#endif
{
    if (strg!=NULL)
    {
        int l1,l2,j,start;

        start=position;		/* start position in strg */
        l1=strlen(s);		/* assign length of s to be efficient
*/
        l2=strlen(strg->the_string);
				/* assign length of strg->the_string to be
				//  efficient */

        for (; start<l2-l1+1;start++)
	    {
	        for (j=0;j<l1;j++)
	        {
	            if (strg->the_string[start+j]!=s[j])
	   	        break;
	        }
	        if (j>=l1) break;
	    }

        return (j>=l1) ? start
		       : -1;
    }
    else
    {
	printf("ERROR: Cannot StrgIndex an StringObj which has not been initialized.\n\n");
	return -1;
    }
}



#ifndef _NO_PROTO
void StringObj_Concat (StringObj* strg, char s[])
#else
void StringObj_Concat (strg,s)
StringObj * strg;
char s[];
#endif
{
    if (strg!=NULL)
    {
        char *p;
        int l1, l2;

        l1=strlen(strg->the_string);
        l2=strlen(s);
        p=(char *)malloc(l1+l2+1);

        strcpy(p,strg->the_string);
        strcat(p,s);

        free(strg->the_string);
        strg->the_string=p;
    }
    else
	printf("ERROR:  Cannot Concat a StringObj which has not been initialized.\n\n");
}



#ifndef _NO_PROTO
char StringObj_CharAt (StringObj* strg, int position)
#else
char StringObj_CharAt (strg,position)
StringObj * strg;
int position;
#endif
{
  if (strg!=NULL)
    return strg->the_string[position];

  fprintf(stderr, "ERROR: Cannot CharAt an uninitialized StringObj.\n\n");

  return 0;
}



#ifndef _NO_PROTO
void StringObj_AssignStringObj (StringObj* strg, StringObj* another_strg)
#else
void StringObj_AssignStringObj (strg, another_strg)
StringObj * strg,
	  * another_strg;
#endif
{
    if (strg!=NULL)
    {
        free(strg->the_string);
        strg->the_string=(char *)malloc(strlen(another_strg->the_string)+1);
        strcpy(strg->the_string,another_strg->the_string);
    }
    else
	printf("ERROR: Cannot AssignStringObj a StringObj which has not been initialized.\n\n");
}



#ifndef _NO_PROTO
void StringObj_AssignCharArray (StringObj* strg, char array[])
#else
void StringObj_AssignCharArray (strg,array)
StringObj * strg;
char array[];
#endif
{
    if (strg!=NULL)
    {
         free(strg->the_string);
         strg->the_string=(char *)malloc(strlen(array)+1);
         strcpy(strg->the_string,array);
    }
    else
	printf("ERROR: Cannot AssignCharArray to a StringObj which has not been initialized.\n\n");
}

#ifndef _NO_PROTO
char * StringObj_AsString(StringObj * strg)
#else
char * StringObj_AsString(strg)
StringObj * strg;
#endif
{
  if (strg!=NULL)
    return strg->the_string;

  fprintf(stderr, "ERROR: Cannon AsString an uninitialized StringObj.\n");

  return NULL;
}
