Rem  Copyright (c) Oracle Corporation 1999 - 2019. All Rights Reserved.
Rem
Rem    NAME
Rem      apxdwngrd.sql
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem      Assumes the SYS user is connected.
Rem
Rem    REQUIREMENTS
Rem      - Oracle Database 10.2.0.3 or later
Rem
Rem
Rem    Example:
Rem
Rem     sqlplus "sys/syspass as sysdba" @apxdwngrd
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jstraub   01/08/2019 - Created
Rem      jstraub   01/24/2019 - Optimized by removing unneccesary granting/compiling


set define '^'
set concat on
set concat .
set verify off

set termout off
column foo new_val LOG
select 'apxdwngrd_' ||to_char(sysdate, 'YYYY-MM-DD_HH24-MI-SS') || '.log' as foo
  from sys.dual;
set termout on
spool ^LOG

@@core/scripts/set_appun.sql

whenever sqlerror exit
set serveroutput on size unlimited

declare
    l_cnt    number := 0;
begin
    select count(*) into l_cnt from sys.dba_users where username = '^APPUN';
    if l_cnt = 0 then
        dbms_output.put_line('^APPUN not found in this database.');
        raise program_error;
    end if;
end;
/
whenever sqlerror continue

column down NEW_VALUE dfrom NOPRINT

select nvl(sys.dbms_registry.schema('APEX'),'^APPUN') down from sys.dual;

prompt ...Create validate procedure in SYS schema and start registration
@@core/validate_apex.sql x x ^APPUN

grant inherit any privileges to ^APPUN;

prompt Installing SYS views

@@core/sys_core_views.sql

@@core/wwv_flow_val.sql
grant execute on sys.wwv_flow_val to ^APPUN.;

@@core/wwv_flow_val.plb

ALTER SESSION SET CURRENT_SCHEMA = ^APPUN;

exec sys.dbms_session.modify_package_state(sys.dbms_session.reinitialize);

exec ^APPUN..wwv_flow_upgrade.switch_schemas('^DFROM','^APPUN');

ALTER SESSION SET CURRENT_SCHEMA = SYS;

drop context APEX$SESSION;
create context APEX$SESSION using ^APPUN..WWV_FLOW_SESSION_CONTEXT;


alter package sys.wwv_dbms_sql_^APPUN. compile;
alter package sys.wwv_dbms_sql_^APPUN. compile body;

exec sys.dbms_session.modify_package_state(sys.dbms_session.reinitialize);

set serveroutput on size unlimited

declare
     l_apex_version varchar2(30);
     l_schemas sys.dbms_registry.schema_list_t;
begin
    execute immediate 'drop package ^APPUN..WWV_FLOW_DB_VERSION';
    l_apex_version := ^APPUN..wwv_flows_release;
    sys.dbms_registry.loading('APEX','Oracle Application Express','validate_apex', '^APPUN');
    select username
      bulk collect into l_schemas
      from sys.all_users
     where username in ('FLOWS_FILES','APEX_PUBLIC_USER','APEX_LISTENER','APEX_REST_PUBLIC_USER','APEX_INSTANCE_ADMIN_USER')
     order by 1;
     sys.dbms_registry.update_schema_list('APEX', l_schemas);
     sys.dbms_registry.loaded('APEX',l_apex_version);
     commit;
     sys.validate_apex;
end;
/

spool off
