prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4414
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4414 - Oracle APEX  System Messages and Native Types
--
-- Application Export:
--   Application:     4414
--   Name:            Oracle APEX  System Messages and Native Types
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             124
--       Globalization:
--         Messages:          14,593
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX  System Messages and Native Types')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286625200861926924')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135328'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'de'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(91645213681389498.4414)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141227'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562090986404402217.4414)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48650898565635010.4414)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Abmelden'
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>'Von Application Express abmelden'
,p_list_text_09=>'Y'
,p_list_text_10=>'abmelden beenden verlassen :q'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(281916990329150760.4414)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Anwendung anhand einer Kalkulationstabelle erstellen'
,p_list_item_link_target=>'f?p=4000:447:&APP_SESSION.::NO:448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT::'
,p_list_text_01=>'Excel- oder CSV-Dateien importieren und eine Anwendung erstellen'
,p_list_text_09=>'Y'
,p_list_text_10=>unistr('Excel CSV XSL XSLX Kalkulationstabellendaten einf\00FCgen laden importieren')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(282255839842182292.4414)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Oracle APEX Home'
,p_list_item_link_target=>'f?p=4500:1000:&APP_SESSION.'
,p_list_text_10=>'Homepage Start '
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(296033420364984683.4414)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Font APEX-Symbole durchsuchen'
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>unistr('Durchsuchen Sie Font APEX-Symbole, f\00FCgen Sie Modifikatoren hinzu, und kopieren Sie ben\00F6tigte CSS- oder HTML-Elemente.')
,p_list_text_09=>'Y'
,p_list_text_10=>'Symbole, Font APEX-Library, Grafiken'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562091518091404815.4414)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562091727563404815.4414)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Anwendung exportieren'
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>'Anwendung {APP_ID} als SQL-Datei exportieren'
,p_list_text_09=>'Y'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562093357853428158.4414)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Nicht verwendete Listen'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562092153904409717.4414)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48392393581618193.4414)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Konsolenlog'
,p_list_item_link_target=>'javascript:console.log(''hello friend'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14843831009863117.4414)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859012524941040.4414)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(86380554411225400.4414)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91997339122572414.4414)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(460407779408652225.4414)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(497671453666914719.4414)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attribute_01=>'fa-star'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082458703597614427.4414)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082517678315623391.4414)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072678475712055.4414)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831649180083980462.4414)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780276458994154.4414)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1832884277947217587.4414)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1840861033969283097.4414)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917665913120940054.4414)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1990227023531717243.4414)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626406749381989.4414)
,p_theme_id=>1
,p_name=>'One Level Tabs.de'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE# ',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626529080381989.4414)
,p_theme_id=>1
,p_name=>'Printer Friendly.de'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(91626823864381990.4414)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(91632832228382001.4414)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(91636711305382010.4414)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(91638400927382012.4414)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(91638400927382012.4414)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(91641225667382016.4414)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641730492382017.4414)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641814330382017.4414)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(91642503902382024.4414)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>'Suchdialog'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Suche'
,p_close_button_text=>unistr('Schlie\00DFen')
,p_next_button_text=>'Weiter >'
,p_prev_button_text=>unistr('< Zur\00FCck')
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91641910982382018.4414)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642102481382020.4414)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642303533382020.4414)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273417075250864393)
,p_name=>'2DCOLUMN'
,p_message_language=>'de'
,p_message_text=>'2D-Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273419359406864394)
,p_name=>'2DCOLUMN_LINE'
,p_message_language=>'de'
,p_message_text=>'2D-Spaltenzeile'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273417290882864393)
,p_name=>'2DDOUGHNUT'
,p_message_language=>'de'
,p_message_text=>'2D-Ring'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273419156070864394)
,p_name=>'2DHSTACKED_PCT'
,p_message_language=>'de'
,p_message_text=>'Gestapelte horizontale 2D-Spalte (Prozent)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273417358537864393)
,p_name=>'2DLINE'
,p_message_language=>'de'
,p_message_text=>'2D-Linie'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273417446618864393)
,p_name=>'2DPIE'
,p_message_language=>'de'
,p_message_text=>'2D-Kreis'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273418984671864394)
,p_name=>'2DSTACKED_PCT'
,p_message_language=>'de'
,p_message_text=>'Gestapelte 2D-Spalte (Prozent)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273417522669864393)
,p_name=>'3DCOLUMN'
,p_message_language=>'de'
,p_message_text=>'3D-Spalte'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273419263092864394)
,p_name=>'3DHSTACKED_PCT'
,p_message_language=>'de'
,p_message_text=>'Gestapelte horizontale 3D-Spalte (Prozent)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273417600249864393)
,p_name=>'3DPIE'
,p_message_language=>'de'
,p_message_text=>'3D-Kreis'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273419022518864394)
,p_name=>'3DSTACKED_PCT'
,p_message_language=>'de'
,p_message_text=>'Gestapelte 3D-Spalte (Prozent)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274314998032865032)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'de'
,p_message_text=>unistr('0 Elemente zum Einf\00FCgen in das Attribut-Dictionary')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274314753454865032)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_language=>'de'
,p_message_text=>unistr('0 Elemente f\00FCr die Aktualisierung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274315126591865033)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'de'
,p_message_text=>'0 Elemente zur Aktualisierung des Attribut-Dictionarys'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274315537163865033)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'de'
,p_message_text=>unistr('0 Berichtsspalten zum Einf\00FCgen in das Attribut-Dictionary')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274315729660865033)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'de'
,p_message_text=>'0 Berichtsspalten zum Aktualisieren des Attribut-Dictionarys'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274314621699865032)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_language=>'de'
,p_message_text=>unistr('%0 Elemente f\00FCr die Aktualisierung pr\00FCfen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274315390408865033)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_language=>'de'
,p_message_text=>'0 Berichtsspalten zur Aktualisierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274314823130865032)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'de'
,p_message_text=>unistr('%0 Elemente f\00FCr die Einbindung in das Attribut-Dictionary pr\00FCfen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274315059067865032)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'de'
,p_message_text=>unistr('%0-Elemente f\00FCr die Aktualisierung des Attribut-Dictionarys pr\00FCfen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274315433004865033)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'de'
,p_message_text=>unistr('%0 Berichtsspalten zum Einf\00FCgen in das Attribut-Dictionary pr\00FCfen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274315254208865033)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_language=>'de'
,p_message_text=>unistr('%0 Berichtsspalten zur Aktualisierung pr\00FCfen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274315683760865033)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'de'
,p_message_text=>unistr('%0 Berichtsspalten zum Aktualisieren des Attribut-Dictionarys pr\00FCfen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274005405791864810)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_language=>'de'
,p_message_text=>'Der Wert muss numerisch sein.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273989909816864799)
,p_name=>'4000_639_SEQ_MESG'
,p_message_language=>'de'
,p_message_text=>unistr('<span class="fielddata"> Neuanordnung nicht m\00F6glich, weil die Regionssequenzen nicht eindeutig sind.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273990087892864799)
,p_name=>'4000_641_SEQ_MESG'
,p_message_language=>'de'
,p_message_text=>unistr('<span class="fielddata">Neuanordnung nicht m\00F6glich, weil die Schaltfl\00E4chensequenzen nicht eindeutig sind.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273990177793864799)
,p_name=>'4000_646_SEQ_MESG'
,p_message_language=>'de'
,p_message_text=>unistr('<span class="fielddata">Neuanordnung nicht m\00F6glich, weil die Navigationsleistensequenzen nicht eindeutig sind.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273990287716864799)
,p_name=>'4000_749_SEQ_MESG'
,p_message_language=>'de'
,p_message_text=>unistr('<span class="fielddata">Neuanordnung nicht m\00F6glich, weil die Regionselementsequenzen nicht eindeutig sind.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274069816724864855)
,p_name=>'4000_APPLICATION_ID'
,p_message_language=>'de'
,p_message_text=>'Anwendungs-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273561539863864490)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung bearbeiten: %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273961572663864767)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_language=>'de'
,p_message_text=>unistr('Das angegebene Datumsformat ist ung\00FCltig. F\00FCr den Kalender muss ein Datum im Format YYYYMMDD angegeben werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274010693650864814)
,p_name=>'4000_TREE'
,p_message_language=>'de'
,p_message_text=>'Baum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274069911594864855)
,p_name=>'4000_WORKSPACE_ID'
,p_message_language=>'de'
,p_message_text=>'Workspace-ID'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273842635071864683)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Geben Sie den Namen des neuen Schemas an, das erstellt werden soll. W\00E4hlen Sie ein Kennwort f\00FCr das Schema und anschlie\00DFend den Default Tablespace sowie den Temporary Tablespace.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273842757172864684)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_language=>'de'
,p_message_text=>'Geben Sie den Namen des vorhandenen Schemas ein.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273842823937864684)
,p_name=>'4050_106_WHEN_DONE'
,p_message_language=>'de'
,p_message_text=>'Wenn Sie fertig sind, klicken Sie auf <b>Weiter</b>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273735842951864608)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_language=>'de'
,p_message_text=>unistr('Tablespaces und zugeh\00F6rige Datendateien l\00F6schen: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273735787913864608)
,p_name=>'4050_110_DROP_USERS'
,p_message_language=>'de'
,p_message_text=>unistr('Datenbankbenutzer l\00F6schen: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274648447492865266)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_language=>'de'
,p_message_text=>unistr('Webservice-Aktivit\00E4tslogeintr\00E4ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273836020271864679)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_language=>'de'
,p_message_text=>unistr('Aktivit\00E4tslog-Eintr\00E4ge f\00FCr den Entwickler')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273454640445864418)
,p_name=>'4050_31_LOG_COUNT'
,p_message_language=>'de'
,p_message_text=>unistr('Eintr\00E4ge im Zugriffslog f\00FCr die Anmeldung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273835563152864678)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_language=>'de'
,p_message_text=>unistr('\00C4nderungsanforderungen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273835618119864679)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_language=>'de'
,p_message_text=>'Runtime-Anforderungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273835303093864678)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_language=>'de'
,p_message_text=>'Workspace-Anforderung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273838091301864680)
,p_name=>'4050_46_AD_HOC'
,p_message_language=>'de'
,p_message_text=>unistr('Historieneintr\00E4ge von SQL Command Processor')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273837996015864680)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_language=>'de'
,p_message_text=>unistr('Ausf\00FChrungslog-Eintr\00E4ge f\00FCr Kontrolldatei')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273837880367864680)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_language=>'de'
,p_message_text=>unistr('Ausf\00FChrungslog-Eintr\00E4ge f\00FCr Skriptdatei')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273838171384864680)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_language=>'de'
,p_message_text=>unistr('SQL-Archiveintr\00E4ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273840186696864682)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_language=>'de'
,p_message_text=>'Aktive Log-Informationen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273840291371864682)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_language=>'de'
,p_message_text=>'Aktuelle Lognummer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273840361096864682)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_language=>'de'
,p_message_text=>'Aktueller Logzeitstempel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273840931930864682)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_language=>'de'
,p_message_text=>unistr('Stunden bis zum n\00E4chsten Logwechsel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273840551409864682)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_language=>'de'
,p_message_text=>'Intervall in Tagen (konstant)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273840883565864682)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chster Logwechsel geplant f\00FCr')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273841292526864682)
,p_name=>'4050_70_DEV_ACT'
,p_message_language=>'de'
,p_message_text=>unistr('Aktivit\00E4tslog-Eintr\00E4ge f\00FCr den Entwickler')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273841498218864683)
,p_name=>'4050_71_CLICK'
,p_message_language=>'de'
,p_message_text=>unistr('Clickthrough Log-Eintr\00E4ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273842200280864683)
,p_name=>'4050_75_AD_HOC'
,p_message_language=>'de'
,p_message_text=>unistr('Historieneintr\00E4ge von SQL Command Processor')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273842109320864683)
,p_name=>'4050_75_CTRL_FILE'
,p_message_language=>'de'
,p_message_text=>unistr('Ausf\00FChrungslog-Eintr\00E4ge f\00FCr Kontrolldatei')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273841901948864683)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_language=>'de'
,p_message_text=>unistr('Ausf\00FChrungslog-Eintr\00E4ge f\00FCr Skriptdatei')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273842305105864683)
,p_name=>'4050_75_SQL_ARCH'
,p_message_language=>'de'
,p_message_text=>unistr('SQL-Archiveintr\00E4ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273842499603864683)
,p_name=>'4050_82_WORKSPACE'
,p_message_language=>'de'
,p_message_text=>'Der Workspace %1 hat %2 Anwendungen und %3 Benutzer.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273842566217864683)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_language=>'de'
,p_message_text=>unistr('Clickthrough Log-Eintr\00E4ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274040685629864835)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_language=>'de'
,p_message_text=>unistr('Produktivit\00E4ts- und Beispiel-Apps')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274040725315864835)
,p_name=>'4050_PACKAGED_WEBSHEETS'
,p_message_language=>'de'
,p_message_text=>'Beispiel-Websheets'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274039987314864834)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_language=>'de'
,p_message_text=>'Workspace-Anzahl'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273580225285864502)
,p_name=>'4150_COLUMN_NUMBER'
,p_message_language=>'de'
,p_message_text=>'Spalte %0'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273763961731864627)
,p_name=>'4350_APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273764061539864628)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung bearbeiten'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273469775977864428)
,p_name=>'4500 800 HD DBA'
,p_message_language=>'de'
,p_message_text=>'Oracle Database Express Edition 2 Day DBA.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273469849114864428)
,p_name=>'4500 800 HD DEV'
,p_message_language=>'de'
,p_message_text=>'Oracle Database Express Edition 2 Day Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273469681184864428)
,p_name=>'4500 800 HD HTMLDB'
,p_message_language=>'de'
,p_message_text=>'Oracle Application Express 2 Day Plus Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273469947094864429)
,p_name=>'4500 800 HD JAVA'
,p_message_language=>'de'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus Java Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273470032008864429)
,p_name=>'4500 800 HD NET'
,p_message_language=>'de'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus .NET Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273470198556864429)
,p_name=>'4500 800 HD PHP'
,p_message_language=>'de'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus PHP Developer.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273470213320864429)
,p_name=>'4500 800 MSG DBA'
,p_message_language=>'de'
,p_message_text=>unistr('Erl\00E4utert allgemeine, t\00E4glich auszuf\00FChrende administrative Aufgaben.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273470384854864429)
,p_name=>'4500 800 MSG DEV'
,p_message_language=>'de'
,p_message_text=>unistr('Erl\00E4utert, wie Sie die Vorteile der Oracle Database Express Edition-Entwicklungsumgebung nutzen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273470493482864429)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_language=>'de'
,p_message_text=>'Bietet eine Reihe von Tutorials, die die Erstellung von auf Datenbanken basierenden Webanwendungen beschreiben.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273470670660864429)
,p_name=>'4500 800 MSG JAVA'
,p_message_language=>'de'
,p_message_text=>unistr('Dieses Dokument bietet ein Tutorial, das zeigt, wie Sie sich mit Java und JDBC bei Oracle Database XE anmelden. Au\00DFerdem erfahren Sie, wie Sie damit eine einfache Java-Anwendung entwickeln, die auf Daten zugreift und diese \00E4ndert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273470797374864429)
,p_name=>'4500 800 MSG NET'
,p_message_language=>'de'
,p_message_text=>unistr('Dieses Dokument beschreibt die Haupt-Features von Oracle Data Provider for .NET und Oracle Developer Tools for Visual Studio .NET. Es f\00FChrt Sie durch die Installation und Konfiguration und zeigt, wie Sie einfache Anwendungen mit Oracle Data Provider ')
||unistr('for .NET und Oracle Developer Tools for Visual Studio .NET erstellen. Au\00DFerdem erfahren Sie, wie Sie gespeicherte PL/SQL- sowie .NET-Prozeduren erstellen und verwenden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273470522213864429)
,p_name=>'4500 800 MSG PHP'
,p_message_language=>'de'
,p_message_text=>'Dieses Dokument bietet ein Tutorial, das zeigt, wie Sie Apache und die Zend Core PHP-Treiber herunterladen und installieren. Danach erfahren Sie, wie Sie sich mit PHP bei Oracle Database XE anmelden und eine einfache Anwendung entwickeln, die auf Dat'
||unistr('en zugreift und diese \00E4ndert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273440444826864409)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_language=>'de'
,p_message_text=>'Aliasname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273440344031864409)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273440672902864409)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_language=>'de'
,p_message_text=>'Bedingung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273899376332864723)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273441022899864409)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_language=>'de'
,p_message_text=>'Funktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273441133444864409)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_language=>'de'
,p_message_text=>'Gruppieren nach'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273440578767864409)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_language=>'de'
,p_message_text=>'Objekt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273440981975864409)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_language=>'de'
,p_message_text=>'Anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273440737146864409)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_language=>'de'
,p_message_text=>'Sortiertyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273440834570864409)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_language=>'de'
,p_message_text=>'Sortierreihenfolge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273444235022864411)
,p_name=>'4500_1002_QB_JOIN'
,p_message_language=>'de'
,p_message_text=>'Join'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273437700435864407)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_language=>'de'
,p_message_text=>unistr('Klicken Sie hier, um die Spalte f\00FCr den Join auszuw\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273444689201864411)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_language=>'de'
,p_message_text=>unistr('Es k\00F6nnen maximal 60 Spalten ausgew\00E4hlt werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273437651530864407)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_language=>'de'
,p_message_text=>'Entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273437523704864407)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_language=>'de'
,p_message_text=>'Spalten ein-/ausblenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273444391849864411)
,p_name=>'4500_1002_QB_TO'
,p_message_language=>'de'
,p_message_text=>'bis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273435971144864406)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_language=>'de'
,p_message_text=>unistr('Ergebnisse von %0, ausgef\00FChrt um %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273736039505864608)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck zur urspr\00FCnglichen Abfrage')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273451965354864416)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_language=>'de'
,p_message_text=>'Die ersten %0 angezeigten Spalten.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273929085060864744)
,p_name=>'4500_SESS_EVENT'
,p_message_language=>'de'
,p_message_text=>'Ereignis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273928917355864744)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_language=>'de'
,p_message_text=>'Kilobyte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273928851443864744)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_language=>'de'
,p_message_text=>'Megabyte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273473699875864431)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzeroberfl\00E4chen-Standards werden von App Builder verwendet, um die Ausgangswerte f\00FCr die Regions- und Elementeigenschaften aufzuf\00FCllen, und gew\00E4hrleisten eine Konsistenz bei mehreren Seiten einer oder mehrerer Anwendungen.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273518016456864461)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr diese Anwendung m\00FCssen Cookies aktiviert sein.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273517909382864461)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr diese Anwendung muss JavaScript aktiviert sein.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273709686375864589)
,p_name=>'4800_9015_UPDATE_OVERDUE_FEATURES'
,p_message_language=>'de'
,p_message_text=>unistr('%0 \00FCberf\00E4llige Features werden auf den ausgew\00E4hlten neuen Meilenstein aktualisiert.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273959895501864766)
,p_name=>'ABOUT'
,p_message_language=>'de'
,p_message_text=>'Info'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274720689327865317)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_language=>'de'
,p_message_text=>unistr('Best\00E4tigen Sie, dass die folgenden %0 Benutzer Ihrem Workspace hinzugef\00FCgt werden sollen.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273972257654864775)
,p_name=>'ACCEPTED'
,p_message_language=>'de'
,p_message_text=>'Angenommen'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273938687294864751)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_language=>'de'
,p_message_text=>unistr('Verf\00FCgbarkeitsbeauftragter')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273936782862864750)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_language=>'de'
,p_message_text=>'Auswirkung der Barrierefreiheit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273939121369864751)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_language=>'de'
,p_message_text=>'Status Barrierefreiheit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274799754032865373)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_language=>'de'
,p_message_text=>'Barrierefreiheit getestet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273450720822864416)
,p_name=>'ACCESS_CONTROL_ADMIN'
,p_message_language=>'de'
,p_message_text=>'Administrator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273610137706864522)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_language=>'de'
,p_message_text=>'Administrationsrechte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273449207855864414)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Administrationsseite f\00FCr die Zugriffskontrolle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273887894747864715)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_language=>'de'
,p_message_text=>'Administrator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273998952668864805)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_language=>'de'
,p_message_text=>'Diese Rolle wird Anwendungsadministratoren zugewiesen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273449458665864415)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_language=>'de'
,p_message_text=>'Anwendungsadministration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273450046670864415)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_language=>'de'
,p_message_text=>'Anwendungsmodus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273449942835864415)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_language=>'de'
,p_message_text=>'Geben Sie an, wie der Zugriff auf diese Anwendung kontrolliert wird.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273451245335864416)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Verarbeiten der Anforderung zum Festlegen des Anwendungsmodus nicht m\00F6glich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273451325500864416)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_language=>'de'
,p_message_text=>'Anwendungsmodus festgelegt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273611036857864523)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie k\00F6nnen sich nicht selbst l\00F6schen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273611181709864523)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_language=>'de'
,p_message_text=>unistr('Sie k\00F6nnen die Administratorberechtigung f\00FCr sich selbst nicht entfernen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273449301435864415)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_language=>'de'
,p_message_text=>'Tabelle erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273887718470864715)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_language=>'de'
,p_message_text=>'Beitragsrechte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273887923339864715)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_language=>'de'
,p_message_text=>'Beitragender'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273999054329864806)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_language=>'de'
,p_message_text=>'Diese Rolle wird Anwendungsbeitragenden zugewiesen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273931468946864746)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Die folgenden Anwendungseinstellungen werden erstellt:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273888057988864715)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_language=>'de'
,p_message_text=>'Die folgenden Anwendungszugriffsrollen werden erstellt:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273466830185864426)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_language=>'de'
,p_message_text=>'Die folgenden Autorisierungsschemas werden erstellt:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273540525062864476)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Erstellen der Zugriffskontrollseite nicht m\00F6glich. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273540423265864476)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Erstellen der Zugriffskontrolltabellen nicht m\00F6glich. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273613615850864524)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_language=>'de'
,p_message_text=>unistr('Sie d\00FCrfen keine doppelten Benutzernamen eingeben.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273610214978864522)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_language=>'de'
,p_message_text=>'Zugriffskontrolle - Bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273450957558864416)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_language=>'de'
,p_message_text=>unistr('Geben Sie Abfragekriterien ohne Ber\00FCcksichtigung der Gro\00DF-/Kleinschreibung ein, und klicken Sie anschlie\00DFend auf <b>Los</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273451032220864416)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Abrufen des Modus f\00FCr die Anwendungsadministration nicht m\00F6glich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273450880694864416)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_language=>'de'
,p_message_text=>unistr('Zuletzt ge\00E4ndert von')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273450330421864415)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_language=>'de'
,p_message_text=>'Access Control-Liste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273449577494864415)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_language=>'de'
,p_message_text=>'Voller Zugriff auf alle, Access Control-Liste nicht verwendet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273449660836864415)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_language=>'de'
,p_message_text=>unistr('Eingeschr\00E4nkter Zugriff. Nur in der Access Control-Liste definierte Benutzer sind zugelassen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273449770257864415)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_language=>'de'
,p_message_text=>unistr('Nur \00F6ffentlicher Lesezugriff. Berechtigungen f\00FCr das Bearbeiten und die Administration werden \00FCber die Access Control-Liste gesteuert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273449890212864415)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_language=>'de'
,p_message_text=>'Nur Administratorzugriff.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273451115567864416)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_language=>'de'
,p_message_text=>unistr('Keine Berechtigung f\00FCr versuchte Aktion.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273450605247864415)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_language=>'de'
,p_message_text=>'Berechtigung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273931338159864746)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_language=>'de'
,p_message_text=>'Leserrechte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273931266878864746)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_language=>'de'
,p_message_text=>'Leser'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273999127652864806)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_language=>'de'
,p_message_text=>'Diese Rolle wird Anwendungsleseberechtigten zugewiesen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273467680612864427)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_language=>'de'
,p_message_text=>'Identifizieren Sie Benutzernamen, die diesem Anwendungsautorisierungsschema entsprechen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273450105851864415)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_language=>'de'
,p_message_text=>'Anwendungsmodus festlegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273568652699864494)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_language=>'de'
,p_message_text=>'Die Zugriffskontrollseiten wurden erfolgreich erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273450586172864415)
,p_name=>'ACCESS_CONTROL_USERNAME'
,p_message_language=>'de'
,p_message_text=>'Benutzername'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273888191880864715)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_language=>'de'
,p_message_text=>'Vorhandene Zugriffskontrollrolle verwenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273467508580864427)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_language=>'de'
,p_message_text=>'Vorhandenes Autorisierungsschema verwenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273466745450864426)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_language=>'de'
,p_message_text=>'Vorhandene Tabelle verwenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273610358006864522)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_language=>'de'
,p_message_text=>'Zugriffskontrolle - Anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273900052215864724)
,p_name=>'ACCESS_DENIED_SIMPLE'
,p_message_language=>'de'
,p_message_text=>'Zugriff verweigert'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273471015982864429)
,p_name=>'ACCOUNT_CREATED'
,p_message_language=>'de'
,p_message_text=>'Account wurde erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273593988702864511)
,p_name=>'ACCOUNT_HAS_BEEN_CREATED'
,p_message_language=>'de'
,p_message_text=>'Ihr %0-Account wurde erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273468427498864428)
,p_name=>'ACCOUNT_LOCKED'
,p_message_language=>'de'
,p_message_text=>'Account ist gesperrt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274261053656864994)
,p_name=>'ACCOUNT_MENU'
,p_message_language=>'de'
,p_message_text=>unistr('Men\00FC "Account"')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273918565941864737)
,p_name=>'ACKNOWLEDGED'
,p_message_language=>'de'
,p_message_text=>unistr('Best\00E4tigt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273918722452864737)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_language=>'de'
,p_message_text=>unistr('Best\00E4tigt, keine Aktion')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273982697889864794)
,p_name=>'ACL_ADD_USER'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzer hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274651215451865268)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_language=>'de'
,p_message_text=>'Zugriffs-Dashboard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274651312773865268)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_language=>'de'
,p_message_text=>unistr('Auf \00DCberwachungsaktivit\00E4t zugreifen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274650480811865268)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen/\00C4ndern')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274651121366865268)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_language=>'de'
,p_message_text=>'Administration bei laufender Anwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274649629020865267)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_language=>'de'
,p_message_text=>'Administration von App Builder aus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274650392925865268)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_language=>'de'
,p_message_text=>'Annotationen (Dateien, Tags, Anmerkungen)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274649394791865267)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_language=>'de'
,p_message_text=>unistr('Authentifizierung f\00FCr Application Express-Accounts ohne Access Control-Liste')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274649272299865267)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_language=>'de'
,p_message_text=>'Authentifizierung mithilfe der Access Control-Liste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274650080822865267)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_language=>'de'
,p_message_text=>'SQL-Zugriff und vorgeschlagene Objekte bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274654343995865270)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Nachdem ein Benutzer f\00FCr eine Anwendung authentifiziert wurde, wird mithilfe der Zugriffskontrolle kontrolliert, was er innerhalb der Anwendung tun darf. In der untenstehenden Tabelle wird angegeben, welche Funktionen den verschiedenen Benutzertypen ')
||unistr('aufgrund der f\00FCr diese Anwendung verwendeten Authentifizierung zur Verf\00FCgung stehen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274651469247865268)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_language=>'de'
,p_message_text=>'Access Control-Liste pflegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274650198421865267)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_language=>'de'
,p_message_text=>unistr('Ausf\00FChren und Anzeigen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274649815863865267)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_language=>'de'
,p_message_text=>'Anwendungseigenschaften aktualisieren'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274309595259865029)
,p_name=>'ACTIONS'
,p_message_language=>'de'
,p_message_text=>'Aktionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274648777577865266)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_language=>'de'
,p_message_text=>unistr('Aktionsmen\00FCeinstellungen')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273482169030864437)
,p_name=>'ACTIVE'
,p_message_language=>'de'
,p_message_text=>'Aktiv'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273895680928864721)
,p_name=>'ACTIVITY'
,p_message_language=>'de'
,p_message_text=>unistr('Aktivit\00E4t')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273940147965864752)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Aktivit\00E4tszusammenfassung'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274175689223864931)
,p_name=>'ADDED_BY'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzugef\00FCgt von')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274646229670865265)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_language=>'de'
,p_message_text=>unistr('Der Bereinigungsliste hinzugef\00FCgt')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274295297294865018)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_language=>'de'
,p_message_text=>unistr('Zus\00E4tzliche Informationen angefordert')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273849847399864688)
,p_name=>'ADD_ARGUEMENT'
,p_message_language=>'de'
,p_message_text=>unistr('Argument hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273839951610864681)
,p_name=>'ADD_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Spalte hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274056140033864846)
,p_name=>'ADD_COLUMN_NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen von Spalte %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273697936002864581)
,p_name=>'ADD_CONSTRAINT'
,p_message_language=>'de'
,p_message_text=>unistr('Constraint hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273837718723864680)
,p_name=>'ADD_MORE...'
,p_message_language=>'de'
,p_message_text=>unistr('Weitere hinzuf\00FCgen...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273910506857864731)
,p_name=>'ADD_ROW'
,p_message_language=>'de'
,p_message_text=>unistr('Zeile hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274063669612864851)
,p_name=>'ADD_USER_INTERFACE'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzeroberfl\00E4che hinzuf\00FCgen')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274067235853864853)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_language=>'de'
,p_message_text=>'Durch Provisioning bereitgestellten Speicherplatz um %0 MB anpassen'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273836216312864679)
,p_name=>'ADMIN'
,p_message_language=>'de'
,p_message_text=>'Admin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273462456629864423)
,p_name=>'ADMINISTRATOR'
,p_message_language=>'de'
,p_message_text=>'Workspace-Administrator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273939925262864752)
,p_name=>'ADMINISTRATORS'
,p_message_language=>'de'
,p_message_text=>'Administratoren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273843518169864684)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Adresse des Administrators muss angegeben werden'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274007626964864812)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_language=>'de'
,p_message_text=>'Barrierefreiheit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273498072750864447)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273498368702864448)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_language=>'de'
,p_message_text=>'Performance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273498482125864448)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_language=>'de'
,p_message_text=>unistr('Qualit\00E4tssicherung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273498190309864448)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_language=>'de'
,p_message_text=>'Sicherheit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273498593877864448)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_language=>'de'
,p_message_text=>'Verwendbarkeit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273498271189864448)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_language=>'de'
,p_message_text=>'Warnung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274140905253864906)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_language=>'de'
,p_message_text=>unistr('Element "%1" ist gesch\00FCtzt und kann nicht \00FCber einen Ajax-Aufruf festgelegt werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274141029115864906)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_language=>'de'
,p_message_text=>unistr('Element "%1" ist gesch\00FCtzt und kann nicht \00FCber einen Ajax-Aufruf festgelegt werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274172996603864929)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_language=>'de'
,p_message_text=>unistr('Element "%1" ist gesch\00FCtzt und kann nicht \00FCber einen Ajax-Aufruf festgelegt werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273528808080864468)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_language=>'de'
,p_message_text=>unistr('SYS-Schemapr\00E4fix fehlt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274350820052865057)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_language=>'de'
,p_message_text=>'Verwendung von WWV_FLOW APIs (verwenden Sie stattdessen APEX APIs)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274290993404865015)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Spalte %0 ist in SQL-Anweisung der Regionsquelle nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273508340143864454)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Die interaktive Berichtsspalte %0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273506063940864453)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'%0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273474413712864432)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Spalte %0 ist in SQL-Anweisung der Regionsquelle nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274385472775865082)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Tabellenspalte %0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273506131031864453)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_language=>'de'
,p_message_text=>'%0 kann nicht als Name des Anwendungs- oder Seitenelements referenziert werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274726634533865321)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_language=>'de'
,p_message_text=>unistr('Ajax Callback-Prozess ist nicht durch ein Autorisierungsschema gesch\00FCtzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274726211221865321)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_language=>'de'
,p_message_text=>unistr('Seite ist nicht durch ein Autorisierungsschema gesch\00FCtzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273507086077864453)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr Zielseite %1 (in Anwendung %0) wurde kein Autorisierungsschema definiert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274728368164865323)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_language=>'de'
,p_message_text=>unistr('Die Autorisierung dieser Seite unterscheidet sich von der Autorisierung "%1" der \00FCbergeordneten Seite %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273507196201864454)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_language=>'de'
,p_message_text=>'Autorisierung "%0" auf Zielseite ist nicht identisch mit "%1".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273505692247864453)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'%0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273505503854864453)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Pr\00FCfung der Bind-Variablensyntax konnte nicht durchgef\00FChrt werden. Fehler: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273505760352864453)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'de'
,p_message_text=>'Auf %0 kann nicht mit der Bind-Variablensyntax verwiesen werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273507723160864454)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_language=>'de'
,p_message_text=>'Verzweigung ohne Bedingung vor anderen Verzweigungen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274726062089865321)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_language=>'de'
,p_message_text=>unistr('"Automatisch vervollst\00E4ndigen" ist f\00FCr eine Seite, die Kennwortelemente enth\00E4lt, auf "Ein" gesetzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274726170127865321)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_language=>'de'
,p_message_text=>unistr('"Cachen" l\00E4sst zu, dass der Browser vertrauliche Daten cacht.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274611043544865240)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_language=>'de'
,p_message_text=>unistr('"In Frames einbetten" macht die Anwendung f\00FCr Clickjacking-Angriffe anf\00E4llig.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274611118159865240)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_language=>'de'
,p_message_text=>'"HTML-Escape-Modus" maskiert nur eine begrenzte Gruppe von Zeichen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273432260839864403)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('ID in den Schaltfl\00E4chenattributen f\00FCr eine Schaltfl\00E4che gefunden, die in einer dynamischen Aktion (%0) referenziert wird. '),
'',
unistr('Wenn eine ID in den Schaltfl\00E4chenattributen definiert ist, f\00FChrt dies dazu, dass die dynamischen Aktionen, die die Schaltfl\00E4che referenzieren, nicht funktionieren. Sie sollten diese ID entfernen, weil die Schaltfl\00E4che automatisch eine ID generiert.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273432365588864403)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Schaltfl\00E4chen-Template, das von einer Schaltfl\00E4che verwendet wird, die selbst in einer dynamischen Aktion (%0) referenziert wird, enth\00E4lt die Ersetzungszeichenfolge #BUTTON_ID# nicht.'),
'',
'Template:',
'%1',
'',
unistr('Sie sollten entweder die Ersetzungszeichenfolge #BUTTON_ID# diesem Template hinzuf\00FCgen oder das Schaltfl\00E4chen-Template in ein Template \00E4ndern, das die Zeichenfolge #BUTTON_ID# enth\00E4lt.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273434984120864405)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4che "Aktion" ist nicht ''Von dynamischer Aktion definiert'' f\00FCr eine Schaltfl\00E4che, die in einer dynamischen Aktion (%0) referenziert wird.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273441665247864409)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr Schaltfl\00E4che (%0) ist eine "Aktion" gleich "Von dynamischer Aktion definiert" festgelegt, es ist jedoch keine entsprechende dynamische Aktion vorhanden, die diese Schaltfl\00E4che referenziert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274009127232864813)
,p_name=>'ADVISOR.CHECK.CHART_TYPE_IS_ACCESSIBLE.MSG_ANYCHART_CHART'
,p_message_language=>'de'
,p_message_text=>unistr('Dieses Diagramm ist ein altes AnyChart-Diagramm. Mit der Funktion "Anwendungsupgrade" k\00F6nnen Sie dieses Diagramm migrieren und die neuen Oracle JET-basierten Diagramme verwenden, die benutzerfreundlicher sind und mehr Barrierefreiheit bieten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273506710102864453)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schcacheseite %0 ist nicht die aktuelle Seite oder die Zielseite %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273505420086864452)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'%0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274698288147865301)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_language=>'de'
,p_message_text=>'Der Attributwert ist veraltet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274699748722865302)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_language=>'de'
,p_message_text=>'Dieser Komponententyp ist veraltet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274141195361864906)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_language=>'de'
,p_message_text=>unistr('Gesch\00FCtzte Elemente in Ajax-Aufrufen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273528799614864468)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_language=>'de'
,p_message_text=>'Code-Smell (APEX intern)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273503539074864451)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_language=>'de'
,p_message_text=>'Deklarative Referenzen von Anwendungselementen, Seitenelementen, Spalten oder interaktiven Berichtsfiltern'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274725965705865321)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_language=>'de'
,p_message_text=>'Autorisierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273503205922864451)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_language=>'de'
,p_message_text=>'Referenzen mit Bind-Variablensyntax'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273504678969864452)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_language=>'de'
,p_message_text=>'Verzweigung ohne Bedingung vor anderen Verzweigungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274726454732865321)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_language=>'de'
,p_message_text=>'Browser-Sicherheitseinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273432169763864403)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4che ist mit dynamischen Aktionen nicht kompatibel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273441493932864409)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_language=>'de'
,p_message_text=>unistr('Inkonsistente Referenzen zwischen dynamischen Aktionen und Schaltfl\00E4chen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274008963293864813)
,p_name=>'ADVISOR.CHECK.DESC_CHART_TYPE_IS_ACCESSIBLE'
,p_message_language=>'de'
,p_message_text=>unistr('Diagrammtyp unterst\00FCtzt Barrierefreiheit')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273503818174864451)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_language=>'de'
,p_message_text=>unistr('Seitennummer f\00FCr L\00F6schcache entspricht Zielseite oder aktueller Seite')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273503164052864451)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_language=>'de'
,p_message_text=>'Referenzen mit Spaltensyntax'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274698157520865301)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_language=>'de'
,p_message_text=>'Veraltete Attributwerte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273504101318864452)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_language=>'de'
,p_message_text=>unistr('Fetch-, DML-, MR*-Prozesse sind g\00FCltig')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273504524756864452)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_language=>'de'
,p_message_text=>'Hartcodierte Anwendungs-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273915137225864734)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_language=>'de'
,p_message_text=>'Seitenelement hat Hilfetext'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274007417821864811)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_language=>'de'
,p_message_text=>'Seite hat Seitentitel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274033526524864830)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr Element zum Anzeigen von Bildern ist ALT-Bildtext definiert')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274610884292865240)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_language=>'de'
,p_message_text=>unistr('Anwendungsattribute, die gesperrt werden k\00F6nnen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273503303104864451)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_language=>'de'
,p_message_text=>'Referenziertes Element befindet sich auf der aktuellen Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273503437503864451)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_language=>'de'
,p_message_text=>'Referenziertes Element ist Seitenelement der Zielseite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274008119676864812)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_language=>'de'
,p_message_text=>unistr('Seitenelement verursacht keine unerwartete Kontext\00E4nderung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274009361032864813)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_language=>'de'
,p_message_text=>'Seitenelement hat Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273504890112864452)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_language=>'de'
,p_message_text=>unistr('L\00E4nge des Element- oder tabellarischen Formular-Spaltennamens')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273503623100864451)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_language=>'de'
,p_message_text=>'Referenzen von Seitenelementen in einer Zeichenfolge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273503715190864451)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Referenzierte Seitennummer ist vorhanden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274007750539864812)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_language=>'de'
,p_message_text=>'Region hat Zeilenheader'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273505064970864452)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_language=>'de'
,p_message_text=>'Bericht hat Standardreihenfolge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274726516537865321)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_language=>'de'
,p_message_text=>unistr('Schutz f\00FCr den Sessionzustand')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273504258970864452)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_language=>'de'
,p_message_text=>'Unpassende Verwendung der Ersetzungssyntax'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273503072933864451)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_language=>'de'
,p_message_text=>'Referenzen mit Ersetzungssyntax'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273504009813864452)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_language=>'de'
,p_message_text=>unistr('Autorisierung der Zielseite ist auch f\00FCr aktuelle Komponente eingerichtet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274007936149864812)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_language=>'de'
,p_message_text=>'Theme-Stil auf Barrierefreiheit getestet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274129807928864898)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzeroberfl\00E4che umfasst Kompatibilit\00E4ts-JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273504735896864452)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_language=>'de'
,p_message_text=>unistr('Verkn\00FCpftes Element oder verkn\00FCpfte Spalte der Validierungen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273503919501864451)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_language=>'de'
,p_message_text=>unistr('Ist g\00FCltiger SQL- oder PL/SQL-Code')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273504470742864452)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_language=>'de'
,p_message_text=>unistr('CLOB-Eigenschaft pr\00FCfen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273504322281864452)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_language=>'de'
,p_message_text=>'In SQL-Anweisungen verwendete V-Funktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273504972610864452)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_language=>'de'
,p_message_text=>unistr('Referenzierte Schaltfl\00E4che ist in "Bei geklickter Schaltfl\00E4che" vorhanden')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273507371980864454)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_language=>'de'
,p_message_text=>'Kompilierungsfehler - %0 Anweisung: %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273507625890864454)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_language=>'de'
,p_message_text=>unistr('Link enth\00E4lt die aktuelle Anwendungs-ID als hartcodierten Wert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273915010179864734)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_language=>'de'
,p_message_text=>'Kein Hilfetext definiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274007536027864812)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Seite hat keinen Titel. Aussagekr\00E4ftige Seitentitel sind wichtig f\00FCr die Barrierefreiheit, damit Benutzer den Inhalt und den Zweck der aktuellen Seite richtig verstehen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274033667964864830)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr das Element fehlt der f\00FCr das Bild erforderliche alternative Text. Verwenden Sie hierf\00FCr einen Text, mit dem der Inhalt des Bildes zutreffend beschrieben wird. Au\00DFerdem sollte der Text keine Informationen enthalten, die im Zusammenhang mit dem Bi')
||unistr('ld auf der Seite angezeigt werden (zur Vermeidung einer m\00F6glichen Duplizierung). Hinweis: Wird das Bild von Benutzern zur Verf\00FCgung gestellt, sollten diese auch den alternativen Bildtext erstellen. Stellen Sie den Benutzern entsprechende Anweisungen ')
||unistr('zum Erstellen ad\00E4quater Texte zur Verf\00FCgung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274610990414865240)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_language=>'de'
,p_message_text=>unistr('"Laufzeit-API-Verwendung" l\00E4sst Anwendungs- und Workspace-\00C4nderung zu.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273505801704864453)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_language=>'de'
,p_message_text=>'%0 ist kein Element von Seite %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273505925991864453)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_language=>'de'
,p_message_text=>'%0 ist kein Element von Zielseite %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274008260158864812)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Die Einstellung "Seitenaktion bei Auswahl" f\00FCr das Seitenelement k\00F6nnte eine unerwartete Kontext\00E4nderung f\00FCr den Benutzer verursachen. Sie k\00F6nnen die Einstellung in "Kein Wert" \00E4ndern, damit keine Kontext\00E4nderung stattfindet, und die Funktionalit\00E4t d')
||unistr('urch dynamische Aktionen oder kaskadierende Wertelisten ersetzen (falls Sie auf derselben Seite bleiben m\00FCssen). Alternativ k\00F6nnen Sie den Benutzer dar\00FCber informieren, was geschehen wird (beispielsweise durch Hinzuf\00FCgen von "Startet neue Seite" im L')
||'abel). '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274033446493864830)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr das Element muss ein Label definiert sein. Wenn Sie kein sichtbares Label anzeigen m\00F6chten, sollten Sie trotzdem ein Label definieren und das Labeltemplate "Ausgeblendet" ausw\00E4hlen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274009451090864813)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr das Element ist der Wert "Wertplatzhalter" definiert, aber kein Label. Platzhaltertext alleine reicht als Label f\00FCr das Element nicht aus und f\00FChrt zu Problemen bei der Barrierefreiheit. F\00FCr eine bessere Barrierefreiheit sollte ein Elementlabel d')
||unistr('efiniert sein. Wenn Sie kein sichtbares Label anzeigen m\00F6chten, sollten Sie trotzdem ein Label definieren und das Labeltemplate "Ausgeblendet" ausw\00E4hlen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273508083955864454)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_language=>'de'
,p_message_text=>unistr('Der Namen ist %0 Zeichen lang, darf aber h\00F6chstens 30 Zeichen lang sein.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273506223716864453)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 ist m\00F6glicherweise nicht vorhanden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273506353714864453)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_language=>'de'
,p_message_text=>unistr('%0 ist m\00F6glicherweise kein Seiten- oder Anwendungselement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273506650086864453)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schcacheseite %1 (in Anwendung %0) ist nicht vorhanden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273506491997864453)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Seite %0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273506538130864453)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Zielseite %1 (in Anwendung %0) ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273931518620864746)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Spaltenumschaltregion verf\00FCgt nicht \00FCber eine Spalte, bei der "Als Zeilenheader verwenden" auf "Ja" gesetzt ist. Die Spalte "Zeilenheader" sollte die Spalte sein, die die aktuelle Zeile am besten identifiziert (beispielsweise ein Kundenname in ')
||'einem Bericht mit Kundeninformationen).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273931695856864746)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Reflow-Region verf\00FCgt nicht \00FCber eine Spalte, bei der "Als Zeilenheader verwenden" auf "Ja" gesetzt ist. Die Spalte "Zeilenheader" sollte die Spalte sein, die die aktuelle Zeile am besten identifiziert (beispielsweise ein Kundenname in einem Be')
||'richt mit Kundeninformationen).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274007852823864812)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_language=>'de'
,p_message_text=>unistr('Diese tabellarische Formularregion verf\00FCgt nicht \00FCber eine Spalte, bei der "Als Zeilenheader verwenden" auf "Ja" gesetzt ist. Die Spalte "Zeilenheader" sollte die Spalte sein, die die aktuelle Zeile am besten identifiziert (beispielsweise ein Kundenn')
||unistr('ame in einer Tabelle mit Kundeninformationen). Diese Informationen werden dann beim Rendering des tabellarischen Formulars verwendet, um eindeutige Labels f\00FCr die Formularfelder der einzelnen Zeilen bereitzustellen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273508212089864454)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_language=>'de'
,p_message_text=>'Bericht hat keine Standardreihenfolge.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274611266082865240)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_language=>'de'
,p_message_text=>unistr('"Lesezeichen f\00FCr Hashfunktion setzen" ist auf einen veralteten Algorithmus festgelegt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274611304559865240)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_language=>'de'
,p_message_text=>unistr('"Schutz f\00FCr den Sessionzustand" ist deaktiviert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274726357848865321)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_language=>'de'
,p_message_text=>unistr('Auf einer Seite mit einem Fetch-Prozess m\00FCssen Sie "Seitenzugriffsschutz" verwenden und den Schutz f\00FCr die Elemente aktivieren, die Sie \00FCber die URL \00FCbergeben.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273464921732864425)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_language=>'de'
,p_message_text=>unistr('Region enth\00E4lt "f?p"-URL, die nicht von APEX_UTIL.PREPARE_URL \00FCbergeben wurde.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273507477350864454)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_language=>'de'
,p_message_text=>unistr('M\00F6gliche SQL-Injection erkannt. %0 wird mit Ersetzungssyntax in SQL-, PL/SQL-Code oder Prozesstabellenname verwendet.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273505279014864452)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'%0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273505320143864452)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'de'
,p_message_text=>'Auf %0 kann nicht mit der Ersetzungssyntax verwiesen werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273507265571864454)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr Zielseite %1 (in Anwendung %0) wurde ein Autorisierungsschema definiert, f\00FCr die aktuelle Komponente jedoch nicht.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274008089116864812)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_language=>'de'
,p_message_text=>unistr('Der aktuelle Theme-Stil f\00FCr die Anwendung wurde nicht auf Barrierefreiheit getestet. W\00E4hlen Sie entweder einen Theme-Stil aus, bei dem "Barrierefreiheit getestet" auf "Ja" gesetzt ist, oder setzen Sie das Attribut "Barrierefreiheit getestet" in den T')
||'heme-Einstellungen auf "Ja", wenn der aktuelle Theme-Stil getestet wurde.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274130089667864898)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Die Benutzeroberfl\00E4che umfasst jQuery Migrate. jQuery Migrate bietet Unterst\00FCtzung bei der Migration auf eine neuere Version von jQuery, indem entfernte APIs wiederhergestellt werden. Au\00DFerdem werden Warnungen in der Browserkonsole angezeigt, wenn en')
||unistr('tfernte oder veraltete APIs verwendet werden. Dazu geh\00F6rt eine zus\00E4tzliche JavaScript-Datei f\00FCr jede Seite in Ihrer App. Informationen zum Entfernen dieser Datei finden Sie im jQuery Migrate-Upgradehandbuch. Es enth\00E4lt Angaben dazu, welche APIs ge\00E4nd')
||unistr('ert werden m\00FCssen. Wenn Sie sich sicher sind, dass Sie diese APIs nicht mehr ben\00F6tigen, setzen Sie "jQuery Migrate einbeziehen" auf "Nein".'),
'',
'https://github.com/jquery/jquery-migrate'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274129970470864898)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_language=>'de'
,p_message_text=>unistr('Die Benutzeroberfl\00E4che umfasst veraltete oder nicht mehr unterst\00FCtzte JavaScript-Funktionen. Dazu geh\00F6rt eine zus\00E4tzliche JavaScript-Datei f\00FCr jede Seite in Ihrer App. Informationen zum Entfernen dieser Datei finden Sie in den Versionshinweisen im Ab')
||unistr('schnitt "Veraltete Features". Dort finden Sie Anweisungen zum Pr\00FCfen, ob Abh\00E4ngigkeiten f\00FCr veraltete oder nicht mehr unterst\00FCtzte Funktionen vorliegen, und wie Sie erreichen, dass diese nicht mehr in Ihre App einbezogen werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273507937477864454)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_language=>'de'
,p_message_text=>unistr('Verkn\00FCpftes Element oder verkn\00FCpfte Spalte ist nicht definiert, ist aber f\00FCr "Position f\00FCr die Fehlermeldung" erforderlich.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273507891383864454)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_language=>'de'
,p_message_text=>unistr('Verkn\00FCpftes Element oder verkn\00FCpfte Spalte entspricht nicht dem in Validierungsausdruck 1 angegebenen Wert "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273506810324864453)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_language=>'de'
,p_message_text=>'Kompilierungsfehler - %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273506927869864453)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_language=>'de'
,p_message_text=>'Kein SQL- oder PL/SQL-Code definiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273505183585864452)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_language=>'de'
,p_message_text=>unistr('Ist l\00E4nger als 32767. Nur die ersten 32767 werden gepr\00FCft. L\00E4nge: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273507576775864454)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_language=>'de'
,p_message_text=>unistr('Enth\00E4lt einen V/NV/DV-Funktionsaufruf in einer SQL-Anweisung (kann ein Performance-Problem sein).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273508115837864454)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>unistr('Die referenzierte Schaltfl\00E4che ist nicht mehr vorhanden.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273901627678864725)
,p_name=>'AFTER'
,p_message_language=>'de'
,p_message_text=>'Nach'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273842940695864684)
,p_name=>'AGREEMENT_MISSING'
,p_message_language=>'de'
,p_message_text=>'Vereinbarung fehlt'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273647893358864547)
,p_name=>'ALIAS'
,p_message_language=>'de'
,p_message_text=>'Aliasname'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274354008052865059)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_language=>'de'
,p_message_text=>'Anwendungserstellung zulassen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274270838415865001)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Lassen Sie die Installation von Produktivit\00E4ts- und Beispielanwendungen zu.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274106150461864881)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_language=>'de'
,p_message_text=>'Verwendung von RESTful Services zulassen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274354185370865060)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_language=>'de'
,p_message_text=>'Verwendung von SQL Workshop zulassen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274354305110865060)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_language=>'de'
,p_message_text=>'Verwendung von Team Development zulassen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274353962968865059)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen von Workspace zulassen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274354296803865060)
,p_name=>'ALLOW_WEBSHEET_DEV'
,p_message_language=>'de'
,p_message_text=>'Websheet-Entwicklung zulassen'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273667143234864560)
,p_name=>'ALL_APPLICATIONS'
,p_message_language=>'de'
,p_message_text=>'Alle Anwendungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273452925300864417)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_language=>'de'
,p_message_text=>'- Alles -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273452751002864417)
,p_name=>'ALL_CATEGORIES'
,p_message_language=>'de'
,p_message_text=>'Alle Kategorien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273453099607864417)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_language=>'de'
,p_message_text=>'- Alle Kategorien -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274357038418865062)
,p_name=>'ALL_MILESTONES'
,p_message_language=>'de'
,p_message_text=>'Alle Meilensteine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274035025411864831)
,p_name=>'ALL_RELEASES'
,p_message_language=>'de'
,p_message_text=>'Alle Releases'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273673074827864564)
,p_name=>'ALL_STATIC_FILES'
,p_message_language=>'de'
,p_message_text=>'Alle statischen Dateien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273671690173864563)
,p_name=>'ALL_THEMES'
,p_message_language=>'de'
,p_message_text=>'Alle Themes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274378753525865077)
,p_name=>'ALL_TYPES'
,p_message_language=>'de'
,p_message_text=>'Alle Typen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274379175975865077)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_language=>'de'
,p_message_text=>'- Alle Typen -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273668239268864561)
,p_name=>'ALL_USERS'
,p_message_language=>'de'
,p_message_text=>'Alle Benutzer'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274720856274865317)
,p_name=>'ALREADY_IN_ACL'
,p_message_language=>'de'
,p_message_text=>'Benutzer hat bereits einen APEX-Account'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274710764537865310)
,p_name=>'ALREADY_IN_WS'
,p_message_language=>'de'
,p_message_text=>'Benutzer ist bereits im Workspace vorhanden'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274671486899865282)
,p_name=>'ALWAYS'
,p_message_language=>'de'
,p_message_text=>'Immer'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273424403289864398)
,p_name=>'AM_PM'
,p_message_language=>'de'
,p_message_text=>'AM / PM'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273918366714864737)
,p_name=>'ANALYSIS'
,p_message_language=>'de'
,p_message_text=>'%0-Analyse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273918402491864737)
,p_name=>'ANALYZE'
,p_message_language=>'de'
,p_message_text=>'Analysieren pro %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274057354225864847)
,p_name=>'ANALYZE_TABLE'
,p_message_language=>'de'
,p_message_text=>'Analysieren mit Methode %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273526043515864466)
,p_name=>'ANCHOR.SHOW_ALL'
,p_message_language=>'de'
,p_message_text=>'Alles anzeigen'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273670554679864562)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_language=>'de'
,p_message_text=>'anonymer Block'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273512944193864457)
,p_name=>'ANSWERS'
,p_message_language=>'de'
,p_message_text=>'Antworten'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273464683514864425)
,p_name=>'ANY_DEVELOPER'
,p_message_language=>'de'
,p_message_text=>'(Beliebiger Entwickler)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274686572166865293)
,p_name=>'APEX.ACTIONS.TOGGLE'
,p_message_language=>'de'
,p_message_text=>'%0 umschalten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274725710815865321)
,p_name=>'APEX.ACTIVE_STATE'
,p_message_language=>'de'
,p_message_text=>'(Aktiv)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274789324742865366)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_language=>'de'
,p_message_text=>unistr('Anwendungs\00E4nderungen:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274789236101865365)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_language=>'de'
,p_message_text=>'Stunde:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274794001703865369)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_language=>'de'
,p_message_text=>'%0 K'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274789401360865366)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_language=>'de'
,p_message_text=>'Seitenansichten: '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274311472302865030)
,p_name=>'APEX.AJAX_SERVER_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Ajax-Aufruf hat Serverfehler %0 f\00FCr %1 zur\00FCckgegeben.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274608866209865238)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Ein API-Aufruf wurde untersagt.',
'Wenden Sie sich an den Administrator.',
unistr('Details zu diesem Vorfall k\00F6nnen \00FCber Debugging-ID "%0" abgerufen werden.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273715565264864593)
,p_name=>'APEX.APPLICATION.ALIAS.NON_UNIQUE'
,p_message_language=>'de'
,p_message_text=>'Der Anwendungsaliasname "%0" kann nicht in eine eindeutige Anwendungs-ID konvertiert werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273715621179864593)
,p_name=>'APEX.APPLICATION.ALIAS.NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Anwendung mit dem Alias "%0" ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273673266596864564)
,p_name=>'APEX.APPLICATION.ALIAS.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'ERR-1816 Unerwarteter Fehler beim Konvertieren von Anwendungsaliasname p_flow_alias_or_id (%0).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273542067904864477)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_language=>'de'
,p_message_text=>unistr('Der API-Aufruf "%0" wird in Application Express Version %1 nicht mehr unterst\00FCtzt. Details zu diesem Vorfall finden Sie unter Debugging-ID "%2".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273548756942864481)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNC.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der Authentifizierungsfunktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273436307866864406)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der Authentifizierungsfunktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274804186862865376)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.HOST_PREFIX_MISMATCH'
,p_message_language=>'de'
,p_message_text=>unistr('Von Oracle Cloud Identity Management zur\00FCckgegebener Mandantenname %0 ist nicht f\00FCr die Domain %1 autorisiert.<br/><a href="&LOGOUT_URL.">Melden Sie sich erneut an</a>, und geben Sie einen autorisierten Mandantennamen an, oder \00E4ndern Sie die URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273429404614864401)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.USER_IS_NOT_DEVELOPER'
,p_message_language=>'de'
,p_message_text=>unistr('Ihr Account "%0" verf\00FCgt nicht \00FCber die erforderlichen Entwicklungsberechtigungen (DB_DEVELOPER oder DB_ADMINISTRATOR)<br/>f\00FCr Workspace "%1". <a href="&LOGOUT_URL.">Melden Sie sich erneut an</a>, nachdem die Berechtigungen erteilt wurden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273424829080864398)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.WRONG_GROUP_NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Von Oracle Cloud Identity Management zur\00FCckgegebener Mandantenname ist nicht f\00FCr den aktuellen Workspace autorisiert. <br/><a href="&LOGOUT_URL.">Melden Sie sich erneut an</a>, und geben Sie einen autorisierten Mandantennamen an.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273563078045864491)
,p_name=>'APEX.AUTHENTICATION.HEADER.DUPLICATE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Der HTTP-Header %0 wurde zweimal gesendet. Das k\00F6nnte auf einen Angriff hinweisen.'),
'<ul>',
'<li>Erster Wert: "%1"</li>',
'<li>Zweiter Wert: "%2"</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273429661374864401)
,p_name=>'APEX.AUTHENTICATION.HOST_PREFIX_MISMATCH'
,p_message_language=>'de'
,p_message_text=>unistr('Aus Sicherheitsgr\00FCnden ist das Ausf\00FChren von Anwendungen dieses Workspace \00FCber die Domain in der URL nicht zul\00E4ssig.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273548453301864481)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.ASK_FOR_INSTALLATION'
,p_message_language=>'de'
,p_message_text=>unistr('Bitten Sie Ihren Datenbankadministrator, die Datei $OH/rdbms/admin/catldap.sql auszuf\00FChren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273548350256864481)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.MISSING'
,p_message_language=>'de'
,p_message_text=>unistr('SYS.DBMS_LDAP-Package ist nicht vorhanden oder ung\00FCltig.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273548270832864481)
,p_name=>'APEX.AUTHENTICATION.LDAP.EDIT_USER_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der LDAP-Benutzerfunktion.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273548555981864481)
,p_name=>'APEX.AUTHENTICATION.LDAP.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der LDAP-Authentifizierung.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273549796474864482)
,p_name=>'APEX.AUTHENTICATION.LOGIN.ILLEGAL_PAGE_ARG'
,p_message_language=>'de'
,p_message_text=>'Fehler in der Prozedur p_flow_page argument to login_page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273549293441864481)
,p_name=>'APEX.AUTHENTICATION.LOGIN.INVALID_ARG'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige p_session in wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273549012514864481)
,p_name=>'APEX.AUTHENTICATION.LOGIN.MALFORMED_ARGS'
,p_message_language=>'de'
,p_message_text=>unistr('Fehlerhaftes Argument f\00FCr wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273549491710864481)
,p_name=>'APEX.AUTHENTICATION.LOGIN.NULL_USER'
,p_message_language=>'de'
,p_message_text=>unistr('Null Benutzername an Anmeldeprozedur \00FCbergeben.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273449143880864414)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.COUNTER'
,p_message_language=>'de'
,p_message_text=>'Warten Sie <span id="apex_login_throttle_sec">%0</span> Sekunden, bis Sie sich erneut anmelden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273454173154864418)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.ERROR'
,p_message_language=>'de'
,p_message_text=>'Der Anmeldeversuch wurde blockiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273889479646864716)
,p_name=>'APEX.AUTHENTICATION.NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Authentifizierung "%0" nicht gefunden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273462779657864424)
,p_name=>'APEX.AUTHENTICATION.NO_SECURITY_GROUP_ID'
,p_message_language=>'de'
,p_message_text=>'Sicherheitsgruppen-ID ist Null.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273548963340864481)
,p_name=>'APEX.AUTHENTICATION.POST_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler beim Ausf\00FChren des Post-Authentifizierungsprozesses.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273548692330864481)
,p_name=>'APEX.AUTHENTICATION.PRE_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten des Pre-Authentifizierungsprozesses.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273568173773864494)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD.INSTRUCTIONS'
,p_message_language=>'de'
,p_message_text=>unistr('\00D6ffnen Sie die URL in dem Browser, in dem die Kennwortr\00FCcksetzung angefordert wurde.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274788549258865365)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD_URL'
,p_message_language=>'de'
,p_message_text=>unistr('Kennwort-URL zur\00FCcksetzen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273429861541864401)
,p_name=>'APEX.AUTHENTICATION.RM_GROUP_NOT_GRANTED'
,p_message_language=>'de'
,p_message_text=>'Resource Manager-Nutzungsgruppe %0 wurde nicht %1 erteilt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273429976947864401)
,p_name=>'APEX.AUTHENTICATION.RM_INFO_TO_GRANT'
,p_message_language=>'de'
,p_message_text=>'Verwenden Sie DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP, um die fehlende Berechtigung zu erteilen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273625993632864533)
,p_name=>'APEX.AUTHENTICATION.SESSION_SENTRY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der Session-Sentry-Funktion.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273626079283864533)
,p_name=>'APEX.AUTHENTICATION.SESSION_VERIFY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der Sessionverifizierungsfunktion.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273626215230864533)
,p_name=>'APEX.AUTHENTICATION.SSO.ASK_FOR_INSTALLATION'
,p_message_language=>'de'
,p_message_text=>unistr('Bitten Sie den %0 Administrator, die Engine f\00FCr Oracle Application Server Single Sign-On zu konfigurieren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273702368595864584)
,p_name=>'APEX.AUTHENTICATION.SSO.BAD_URLC'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltiges %0 in %1 Token von SSO zur\00FCckgegeben.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273549623540864482)
,p_name=>'APEX.AUTHENTICATION.SSO.FIX_PARTNER_APP'
,p_message_language=>'de'
,p_message_text=>unistr('Bearbeiten Sie das Authentifizierungsschema, und f\00FCgen Sie den Anwendungsnamen hinzu.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273701971779864584)
,p_name=>'APEX.AUTHENTICATION.SSO.ILLEGAL_CALLER'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltiger Caller von %0-Prozedur:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273702133895864584)
,p_name=>'APEX.AUTHENTICATION.SSO.INVALID_APP_SESSION'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige Anwendungssession in URLC-Token: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273701722660864584)
,p_name=>'APEX.AUTHENTICATION.SSO.MISSING_APP_REGISTRATION'
,p_message_language=>'de'
,p_message_text=>'Fehler in portal_sso_redirect: Fehlende Informationen zur Anwendungsregistrierung: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273626130165864533)
,p_name=>'APEX.AUTHENTICATION.SSO.PACKAGE_MISSING'
,p_message_language=>'de'
,p_message_text=>unistr('WWSEC_SSO_ENABLER_PRIVATE-Package ist nicht vorhanden oder ist ung\00FCltig.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273549528309864482)
,p_name=>'APEX.AUTHENTICATION.SSO.PARTNER_APP_IS_NULL'
,p_message_language=>'de'
,p_message_text=>'Name der registrierten Partneranwendung im Authentifizierungsschema nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273701826384864584)
,p_name=>'APEX.AUTHENTICATION.SSO.REGISTER_APP'
,p_message_language=>'de'
,p_message_text=>'Registrieren Sie diese Anwendung entsprechend der Beschreibung im Installation Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273626337871864533)
,p_name=>'APEX.AUTHENTICATION.SSO.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der SSO-Authentifizierung.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274705382373865306)
,p_name=>'APEX.AUTHENTICATION.UNAUTHORIZED_URL'
,p_message_language=>'de'
,p_message_text=>'Nicht autorisierter URL: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273625790789864533)
,p_name=>'APEX.AUTHENTICATION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der Authentifizierung.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273429713030864401)
,p_name=>'APEX.AUTHENTICATION.WORKSPACE_NOT_ASSIGNED'
,p_message_language=>'de'
,p_message_text=>'Workspace "%0" ist inaktiv. Wenden Sie sich an den Administrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273430903938864402)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED'
,p_message_language=>'de'
,p_message_text=>'%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273451644593864416)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.APPLICATION'
,p_message_language=>'de'
,p_message_text=>unistr('Zugriff von Sicherheitspr\00FCfung der Anwendung abgelehnt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273451713612864416)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Zugriff von Sicherheitspr\00FCfung der Seite abgelehnt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273451827735864416)
,p_name=>'APEX.AUTHORIZATION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler bei Verarbeitung der Autorisierung.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273928602686864744)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_language=>'de'
,p_message_text=>'#LABEL# ist in Liste nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274311042940865030)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_language=>'de'
,p_message_text=>unistr('"Nur Verzweigungen anzeigen" wird nicht unterst\00FCtzt, wenn das Seitenattribut "Bei Weiterleitung erneut laden" auf "Nur bei Erfolg" festgelegt ist.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273676019926864566)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der Verzweigung.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273996597296864804)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX'
,p_message_language=>'de'
,p_message_text=>'Erstellt mit %0 und %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273996608123864804)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX.ACCESSIBLE.LOVE'
,p_message_language=>'de'
,p_message_text=>'Liebe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274033226604864830)
,p_name=>'APEX.CALCULATOR.ICON_TEXT'
,p_message_language=>'de'
,p_message_text=>'Popup-Rechner: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274661318120865275)
,p_name=>'APEX.CALENDAR.EVENT_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Ereignisbeschreibung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274661162278865275)
,p_name=>'APEX.CALENDAR.EVENT_END'
,p_message_language=>'de'
,p_message_text=>'Enddatum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274661496833865275)
,p_name=>'APEX.CALENDAR.EVENT_ID'
,p_message_language=>'de'
,p_message_text=>'Ereignis-ID'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274661029941865275)
,p_name=>'APEX.CALENDAR.EVENT_START'
,p_message_language=>'de'
,p_message_text=>'Startdatum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274661261522865275)
,p_name=>'APEX.CALENDAR.EVENT_TITLE'
,p_message_language=>'de'
,p_message_text=>'Ereignistitel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274129364460864898)
,p_name=>'APEX.CLIPBOARD.COPIED'
,p_message_language=>'de'
,p_message_text=>'In Zwischenablage kopiert.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274122317649864893)
,p_name=>'APEX.CLIPBOARD.NOTSUP'
,p_message_language=>'de'
,p_message_text=>unistr('Dieser Browser unterst\00FCtzt das Kopieren \00FCber eine Schaltfl\00E4che oder ein Men\00FC nicht. Verwenden Sie STRG+C oder Befehlstaste+C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273998614454864805)
,p_name=>'APEX.CLOSE_NOTIFICATION'
,p_message_language=>'de'
,p_message_text=>unistr('Benachrichtigung schlie\00DFen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273420458442864395)
,p_name=>'APEX.COLOR_PICKER.ICON_TEXT'
,p_message_language=>'de'
,p_message_text=>'Popup-Farbauswahl: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274774540786865355)
,p_name=>'APEX.COMBOBOX.LIST_OF_VALUES'
,p_message_language=>'de'
,p_message_text=>'Werteliste'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274774678706865355)
,p_name=>'APEX.COMBOBOX.SHOW_ALL_VALUES'
,p_message_language=>'de'
,p_message_text=>unistr('Liste \00F6ffnen f\00FCr: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274725816346865321)
,p_name=>'APEX.COMPLETED_STATE'
,p_message_language=>'de'
,p_message_text=>'(Abgeschlossen)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273431174600864402)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der Berechnung.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273653450353864551)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der Bedingung.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273716128141864594)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_language=>'de'
,p_message_text=>'Unbekannter Bedingungstyp "%0"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273681382044864570)
,p_name=>'APEX.CONTACT_ADMIN'
,p_message_language=>'de'
,p_message_text=>'Wenden Sie sich an den Anwendungsadministrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273763699136864627)
,p_name=>'APEX.CONTACT_ADMIN.DEBUG'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Wenden Sie sich an den Anwendungsadministrator.',
'Details zu diesem Vorfall finden Sie unter Debugging-ID "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274648352906865266)
,p_name=>'APEX.CORRECT_ERRORS'
,p_message_language=>'de'
,p_message_text=>'Korrigieren Sie die Fehler, bevor Sie speichern.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274730052843865324)
,p_name=>'APEX.CURRENT_PROGRESS'
,p_message_language=>'de'
,p_message_text=>'Aktueller Fortschritt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274349392013865056)
,p_name=>'APEX.DATA_HAS_CHANGED'
,p_message_language=>'de'
,p_message_text=>unistr('Die aktuelle Version der Daten in der Datenbank wurde ge\00E4ndert, seit der Benutzer einen Update-Prozess eingeleitet hat.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274033113382864830)
,p_name=>'APEX.DATEPICKER.ICON_TEXT'
,p_message_language=>'de'
,p_message_text=>'Popup-Kalender: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274042203160864836)
,p_name=>'APEX.DATEPICKER_VALUE_GREATER_MAX_DATE'
,p_message_language=>'de'
,p_message_text=>unistr('#LABEL# ist sp\00E4ter als das angegebene sp\00E4teste Datum %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274047536846864840)
,p_name=>'APEX.DATEPICKER_VALUE_INVALID'
,p_message_language=>'de'
,p_message_text=>unistr('#LABEL# stimmt nicht mit Format %0 \00FCberein.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274042118249864836)
,p_name=>'APEX.DATEPICKER_VALUE_LESS_MIN_DATE'
,p_message_language=>'de'
,p_message_text=>unistr('#LABEL# ist fr\00FCher als das angegebene fr\00FCheste Datum %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274042387556864836)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'de'
,p_message_text=>unistr('#LABEL# liegt nicht im g\00FCltigen Bereich zwischen %0 und %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274045893060864838)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_IN_YEAR_RANGE'
,p_message_language=>'de'
,p_message_text=>unistr('#LABEL# liegt nicht innerhalb des g\00FCltigen Jahresbereichs von %0 und %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274649077573865267)
,p_name=>'APEX.DIALOG.CANCEL'
,p_message_language=>'de'
,p_message_text=>'Abbrechen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274754759885865341)
,p_name=>'APEX.DIALOG.CLOSE'
,p_message_language=>'de'
,p_message_text=>unistr('Schlie\00DFen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274759753465865345)
,p_name=>'APEX.DIALOG.HELP'
,p_message_language=>'de'
,p_message_text=>'Hilfe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274648828504865267)
,p_name=>'APEX.DIALOG.OK'
,p_message_language=>'de'
,p_message_text=>'OK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273860291448864696)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Anwendung %0 Dialogseite %1 kann nicht erfolgreich wiedergegeben werden. Stellen Sie sicher, dass das auf Seite %1 verwendete Template den Typ "Dialogseite" hat und der entsprechende Code zur Initialisierung, zum Schlie\00DFen und Abbrechen des JavaScrip')
||'t-Dialogs definiert ist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274648906036865267)
,p_name=>'APEX.DIALOG.SAVE'
,p_message_language=>'de'
,p_message_text=>'Speichern'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274776464199865357)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_language=>'de'
,p_message_text=>'Copyright &copy; %0, Oracle und/oder verbundene Unternehmen. All rights reserved. Alle Rechte vorbehalten.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274777260437865357)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_language=>'de'
,p_message_text=>'Workspace erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274776348544865356)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_language=>'de'
,p_message_text=>'Dies ist eine systemgenerierte Nachricht. Beantworten Sie diese nicht.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274786150327865363)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_language=>'de'
,p_message_text=>'Umgebung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274798750400865372)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_language=>'de'
,p_message_text=>'Oracle Application Express-Benutzer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274777803309865358)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_language=>'de'
,p_message_text=>'Erste Schritte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274776563066865357)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_language=>'de'
,p_message_text=>'Hallo %0,'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274777518382865357)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_language=>'de'
,p_message_text=>'Kennwort'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274786220627865363)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen von Workspace verhindern')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274777789144865357)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_language=>'de'
,p_message_text=>unistr('Sie k\00F6nnen verhindern, dass Ihr Workspace gel\00F6scht wird, indem Sie auf die Schaltfl\00E4che unten klicken und den Anweisungen auf dem Bildschirm folgen. Wenn Sie nicht innerhalb von %0 Tag(en) reagieren, wird Ihr Workspace automatisch entfernt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274785912296865363)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_language=>'de'
,p_message_text=>unistr('Wenn Sie Ihren Workspace nicht mehr ben\00F6tigen, ist keine Aktion erforderlich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274786460480865364)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_language=>'de'
,p_message_text=>unistr('Ihr Workspace wird in K\00FCrze gel\00F6scht.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274785737863865363)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr Ihren Workspace %0 wurden in letzter Zeit keine Aktivit\00E4ten verzeichnet, deshalb wird er in K\00FCrze gel\00F6scht.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274785607397865363)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_language=>'de'
,p_message_text=>unistr('Warnung. Ihr Workspace "%0" wird in K\00FCrze gel\00F6scht.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274786062786865363)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schendatum')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274786708279865364)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_language=>'de'
,p_message_text=>unistr('Schlie\00DFen Sie Ihre Workspace-Anforderung ab.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274786599156865364)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_language=>'de'
,p_message_text=>'Ihr Workspace "%0" ist bereit.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274786848898865364)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_language=>'de'
,p_message_text=>'Ihr Workspace "%0" wurde genehmigt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274786634616865364)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_language=>'de'
,p_message_text=>'Ihre Workspace-Anforderung wurde abgelehnt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274777126268865357)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_language=>'de'
,p_message_text=>'Benutzername'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274786362799865363)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_language=>'de'
,p_message_text=>'Warnung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274777026998865357)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_language=>'de'
,p_message_text=>'Workspace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274776692480865357)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_language=>'de'
,p_message_text=>'Workspace-Anforderung genehmigt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274777370522865357)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_language=>'de'
,p_message_text=>unistr('Klicken Sie auf die Schaltfl\00E4che unten, um den Genehmigungsprozess abzuschlie\00DFen und Ihr Kennwort festzulegen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274776899351865357)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_language=>'de'
,p_message_text=>'Ihre Workspace-Anforderung wurde genehmigt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274777405788865357)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_language=>'de'
,p_message_text=>unistr('Klicken Sie unten auf die Schaltfl\00E4che, um zu beginnen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274777623206865357)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_language=>'de'
,p_message_text=>'Ihr Workspace ist bereit.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274776732517865357)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_language=>'de'
,p_message_text=>'Workspace-Anforderung abgelehnt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274776963703865357)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_language=>'de'
,p_message_text=>'Ihre Workspace-Anforderung wurde leider abgelehnt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273676337828864566)
,p_name=>'APEX.ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273426654805864399)
,p_name=>'APEX.ERROR.CALLBACK_FAILED'
,p_message_language=>'de'
,p_message_text=>unistr('Der folgende Fehler ist bei der Ausf\00FChrung des Callbacks zur Fehlerbehandlung aufgetreten: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273467759945864427)
,p_name=>'APEX.ERROR.ERROR_PAGE.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim erstellen der Fehlerseite: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273430489830864402)
,p_name=>'APEX.ERROR.INTERNAL'
,p_message_language=>'de'
,p_message_text=>'Interner Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274718825281865316)
,p_name=>'APEX.ERROR.INTERNAL.CONTACT_ADMINISTRATOR'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Wenden Sie sich an den Administrator.',
'Details zu diesem Vorfall finden Sie unter Debugging-ID "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274799606842865373)
,p_name=>'APEX.ERROR.ORA-28353'
,p_message_language=>'de'
,p_message_text=>unistr('ORA-28353: Wallet konnte nicht ge\00F6ffnet werden. Auf Anwendungsdaten kann derzeit nicht zugegriffen werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274701054483865303)
,p_name=>'APEX.ERROR.PAGE_NOT_AVAILABLE'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Seite ist leider nicht verf\00FCgbar.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273436213919864406)
,p_name=>'APEX.ERROR.TECHNICAL_INFO'
,p_message_language=>'de'
,p_message_text=>unistr('Technische Informationen (nur f\00FCr Entwickler sichtbar)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274264088908864996)
,p_name=>'APEX.ERROR_MESSAGE_HEADING'
,p_message_language=>'de'
,p_message_text=>'Fehlermeldung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274337908685865048)
,p_name=>'APEX.EXPECTED_FORMAT'
,p_message_language=>'de'
,p_message_text=>'Erwartetes Format: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274061590831864849)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.ALREADY_IN_ACL'
,p_message_language=>'de'
,p_message_text=>'Benutzer ist bereits in Access-Control-Liste enthalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274061455491864849)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.CREATE_CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('Best\00E4tigen Sie, dass die folgenden %0 <strong>%1</strong> Benutzer Ihrer Access-Control-Liste hinzugef\00FCgt werden sollen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274061986086864850)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.DUPLICATE_USE'
,p_message_language=>'de'
,p_message_text=>'Doppelter Benutzer vorhanden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274061610586864850)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_AT_SIGN'
,p_message_language=>'de'
,p_message_text=>'Fehlendes At-Zeichen (@) in E-Mail-Adresse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274061768090864850)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_DO'
,p_message_language=>'de'
,p_message_text=>'Fehlender Punkt (.) in E-Mail-Adresse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274061857440864850)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.USERNAME_TOO_LONG'
,p_message_language=>'de'
,p_message_text=>'Benutzername ist zu lang'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274062124186864850)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_ONLY'
,p_message_language=>'de'
,p_message_text=>unistr('Nur in der Access-Control-Liste definierte Benutzer k\00F6nnen auf diese Anwendung zugreifen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274062295840864850)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_VALUE_INVALID'
,p_message_language=>'de'
,p_message_text=>'Unerwarteter Zugriffskontroll-Einstellungswert: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274062017217864850)
,p_name=>'APEX.FEATURE.ACL.INFO.ALL_USERS'
,p_message_language=>'de'
,p_message_text=>unistr('Alle authentifizierten Benutzer k\00F6nnen auf diese Anwendung zugreifen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274607651389865237)
,p_name=>'APEX.FEATURE.CONFIG.DISABLED'
,p_message_language=>'de'
,p_message_text=>'Deaktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274607572367865237)
,p_name=>'APEX.FEATURE.CONFIG.ENABLED'
,p_message_language=>'de'
,p_message_text=>'Aktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274608649687865238)
,p_name=>'APEX.FEATURE.CONFIG.IS_DISABLED'
,p_message_language=>'de'
,p_message_text=>'%0: Ist deaktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274607737205865238)
,p_name=>'APEX.FEATURE.CONFIG.IS_ENABLED'
,p_message_language=>'de'
,p_message_text=>'%0: Ist aktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273997342452864804)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_language=>'de'
,p_message_text=>'In Queue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273997451849864804)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_language=>'de'
,p_message_text=>'Gesendet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274607406021865237)
,p_name=>'APEX.FEATURE.TOP_USERS.USERNAME.NOT_IDENTIFIED'
,p_message_language=>'de'
,p_message_text=>'nicht identifiziert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273461064053864422)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_language=>'de'
,p_message_text=>unistr('Feedbackeintr\00E4ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273461198885864423)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_language=>'de'
,p_message_text=>unistr('Offene Feedback-Eintr\00E4ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273461208898864423)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_language=>'de'
,p_message_text=>'Benutzer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274351058182865057)
,p_name=>'APEX.FILE_BROWSE.DOWNLOAD_LINK_TEXT'
,p_message_language=>'de'
,p_message_text=>'Herunterladen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274344272157865053)
,p_name=>'APEX.FS.BATCH_APPLY'
,p_message_language=>'de'
,p_message_text=>'Anwenden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274344734087865053)
,p_name=>'APEX.FS.CLEAR'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274344844630865053)
,p_name=>'APEX.FS.CLEAR_ALL'
,p_message_language=>'de'
,p_message_text=>unistr('Alle l\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274344994877865053)
,p_name=>'APEX.FS.CLEAR_VALUE'
,p_message_language=>'de'
,p_message_text=>unistr('%0 l\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274675546420865285)
,p_name=>'APEX.FS.COLUMN_UNAUTHORIZED'
,p_message_language=>'de'
,p_message_text=>unistr('Spalte %1, referenziert durch Facet %0, ist nicht verf\00FCgbar oder nicht autorisiert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274667964857865280)
,p_name=>'APEX.FS.FACET_VALUE_LIMIT_EXCEEDED'
,p_message_language=>'de'
,p_message_text=>unistr('Grenzwert f\00FCr eindeutigen Wert (%0) f\00FCr Facet %1 wurde \00FCberschritten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274346477837865054)
,p_name=>'APEX.FS.FC_TYPE_UNSUPPORTED_FOR_DATE_COLUMNS'
,p_message_language=>'de'
,p_message_text=>unistr('Facet %0 wird f\00FCr DATE- oder TIMESTAMP-Spalten nicht unterst\00FCtzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274344325455865053)
,p_name=>'APEX.FS.FILTER'
,p_message_language=>'de'
,p_message_text=>'%0 filtern'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274344490553865053)
,p_name=>'APEX.FS.GO'
,p_message_language=>'de'
,p_message_text=>'Los'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274346004398865054)
,p_name=>'APEX.FS.INPUT_CURRENT_LABEL'
,p_message_language=>'de'
,p_message_text=>'gleich %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274346215793865054)
,p_name=>'APEX.FS.NO_SEARCH_COLUMNS_PROVIDED'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr das Facet %0 wurden keine Suchspalten angegeben')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274345745055865054)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL'
,p_message_language=>'de'
,p_message_text=>'%0 bis %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274345876406865054)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_HI'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCber %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274345900258865054)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_LO'
,p_message_language=>'de'
,p_message_text=>'Unter %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274686369031865293)
,p_name=>'APEX.FS.RANGE_LOV_ITEM_INVALID'
,p_message_language=>'de'
,p_message_text=>unistr('Wertelistenelement #%2 ("%1") f\00FCr Bereichs-Facet %0 ist ung\00FCltig (Trennzeichen "|" fehlt).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274346178583865054)
,p_name=>'APEX.FS.RANGE_MANUAL_NOT_SUPPORTED'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr das Bereichs-Facet %0 wird eine manuelle Eingabe derzeit nicht unterst\00FCtzt, weil die Spalte den Typ DATE oder TIMESTAMP hat.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274345330921865053)
,p_name=>'APEX.FS.RANGE_TEXT'
,p_message_language=>'de'
,p_message_text=>'bis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274344674726865053)
,p_name=>'APEX.FS.SEARCH_LABEL'
,p_message_language=>'de'
,p_message_text=>'Suche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274344503652865053)
,p_name=>'APEX.FS.SEARCH_PLACEHOLDER'
,p_message_language=>'de'
,p_message_text=>'Suchen...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274345595818865054)
,p_name=>'APEX.FS.SELECT_PLACEHOLDER'
,p_message_language=>'de'
,p_message_text=>unistr('- Ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274345172222865053)
,p_name=>'APEX.FS.SHOW_LESS'
,p_message_language=>'de'
,p_message_text=>'Weniger anzeigen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274345283593865053)
,p_name=>'APEX.FS.SHOW_MORE'
,p_message_language=>'de'
,p_message_text=>'Mehr anzeigen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274345458683865053)
,p_name=>'APEX.FS.STAR_RATING_LABEL'
,p_message_language=>'de'
,p_message_text=>'%0 Sterne und mehr'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274346330649865054)
,p_name=>'APEX.FS.TEXT_FIELD_ONLY_FOR_NUMBER_COLUMNS'
,p_message_language=>'de'
,p_message_text=>unistr('Das Textfeld-Facet %0 wird derzeit nur f\00FCr NUMBER-Spalten unterst\00FCtzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274675772946865285)
,p_name=>'APEX.FS.UNSUPPORTED_DATA_TYPE'
,p_message_language=>'de'
,p_message_text=>unistr('Der Datentyp %0 (%1) wird f\00FCr die Facet-Suche nicht unterst\00FCtzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274609288148865239)
,p_name=>'APEX.GO_TO_ERROR'
,p_message_language=>'de'
,p_message_text=>'Gehen Sie zum Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273822167292864669)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Gruppe "%0" konnte nicht gefunden werden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274068031184864854)
,p_name=>'APEX.GV.AGG_CONTEXT'
,p_message_language=>'de'
,p_message_text=>'Aggregat.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274176640256864931)
,p_name=>'APEX.GV.BREAK_COLLAPSE'
,p_message_language=>'de'
,p_message_text=>'Gruppenwechsel ausblenden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274068128912864854)
,p_name=>'APEX.GV.BREAK_CONTEXT'
,p_message_language=>'de'
,p_message_text=>'Kontrollgruppenwechsel.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274176569138864931)
,p_name=>'APEX.GV.BREAK_EXPAND'
,p_message_language=>'de'
,p_message_text=>'Gruppenwechsel einblenden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274805822443865377)
,p_name=>'APEX.GV.COLUMN_CONTEXT'
,p_message_language=>'de'
,p_message_text=>'Spalte %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274176359609864931)
,p_name=>'APEX.GV.DELETED_COUNT'
,p_message_language=>'de'
,p_message_text=>unistr('%0  Datens\00E4tze gel\00F6scht')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274765376966865349)
,p_name=>'APEX.GV.DUP_REC_ID'
,p_message_language=>'de'
,p_message_text=>unistr('Identit\00E4t duplizieren')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274055025067864845)
,p_name=>'APEX.GV.FIRST_PAGE'
,p_message_language=>'de'
,p_message_text=>'Erster'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274068398444864854)
,p_name=>'APEX.GV.GROUP_CONTEXT'
,p_message_language=>'de'
,p_message_text=>'Gruppenheader.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274068207803864854)
,p_name=>'APEX.GV.HEADER_CONTEXT'
,p_message_language=>'de'
,p_message_text=>'Header.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274055140661864845)
,p_name=>'APEX.GV.LAST_PAGE'
,p_message_language=>'de'
,p_message_text=>'Letzte'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274216903499864959)
,p_name=>'APEX.GV.LOAD_MORE'
,p_message_language=>'de'
,p_message_text=>'Weitere Zeilen laden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274054828609864845)
,p_name=>'APEX.GV.NEXT_PAGE'
,p_message_language=>'de'
,p_message_text=>'Weiter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274068450262864854)
,p_name=>'APEX.GV.PAGE_RANGE'
,p_message_language=>'de'
,p_message_text=>'Seitenzeilen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274055235230864845)
,p_name=>'APEX.GV.PAGE_RANGE_XY'
,p_message_language=>'de'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274055399723864845)
,p_name=>'APEX.GV.PAGE_RANGE_XYZ'
,p_message_language=>'de'
,p_message_text=>'%0 - %1 von %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274054997299864845)
,p_name=>'APEX.GV.PREV_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274765157345865349)
,p_name=>'APEX.GV.ROW_ADDED'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzugef\00FCgt')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274765220065865349)
,p_name=>'APEX.GV.ROW_CHANGED'
,p_message_language=>'de'
,p_message_text=>unistr('Ge\00E4ndert')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274805665733865377)
,p_name=>'APEX.GV.ROW_COLUMN_CONTEXT'
,p_message_language=>'de'
,p_message_text=>'Zeile %0, Spalte %1.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274805735586865377)
,p_name=>'APEX.GV.ROW_CONTEXT'
,p_message_language=>'de'
,p_message_text=>'Zeile %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274765012447865348)
,p_name=>'APEX.GV.ROW_DELETED'
,p_message_language=>'de'
,p_message_text=>unistr('Gel\00F6scht')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274097204059864875)
,p_name=>'APEX.GV.ROW_HEADER'
,p_message_language=>'de'
,p_message_text=>'Zeilenheader '
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274054185638864844)
,p_name=>'APEX.GV.SELECTION_CELL_COUNT'
,p_message_language=>'de'
,p_message_text=>unistr('%0 Zellen ausgew\00E4hlt')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274055475382864845)
,p_name=>'APEX.GV.SELECTION_COUNT'
,p_message_language=>'de'
,p_message_text=>unistr('%0 Zeilen ausgew\00E4hlt')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274400858122865093)
,p_name=>'APEX.GV.SELECT_ALL'
,p_message_language=>'de'
,p_message_text=>unistr('Alle ausw\00E4hlen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274176426198864931)
,p_name=>'APEX.GV.SELECT_PAGE_N'
,p_message_language=>'de'
,p_message_text=>'Seite %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274097157227864875)
,p_name=>'APEX.GV.SELECT_ROW'
,p_message_language=>'de'
,p_message_text=>unistr('Zeile ausw\00E4hlen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274099774273864877)
,p_name=>'APEX.GV.SORTED_ASCENDING'
,p_message_language=>'de'
,p_message_text=>'Aufsteigend sortiert %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274099820558864877)
,p_name=>'APEX.GV.SORTED_DESCENDING'
,p_message_language=>'de'
,p_message_text=>'Absteigend sortiert %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274054340899864845)
,p_name=>'APEX.GV.SORT_ASCENDING'
,p_message_language=>'de'
,p_message_text=>'Aufsteigend sortieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274054638931864845)
,p_name=>'APEX.GV.SORT_ASCENDING_ORDER'
,p_message_language=>'de'
,p_message_text=>'Aufsteigend sortieren %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274054439423864845)
,p_name=>'APEX.GV.SORT_DESCENDING'
,p_message_language=>'de'
,p_message_text=>'Absteigend sortieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274054700131864845)
,p_name=>'APEX.GV.SORT_DESCENDING_ORDER'
,p_message_language=>'de'
,p_message_text=>'Absteigend sortieren%0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274054546594864845)
,p_name=>'APEX.GV.SORT_OFF'
,p_message_language=>'de'
,p_message_text=>'Nicht sortieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274176255652864931)
,p_name=>'APEX.GV.TOTAL_PAGES'
,p_message_language=>'de'
,p_message_text=>'Gesamt %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274739525642865330)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_language=>'de'
,p_message_text=>'Dokumentation anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274759007296865344)
,p_name=>'APEX.ICON_LIST.GRID_DIM'
,p_message_language=>'de'
,p_message_text=>'Grid-Auswahlliste %0 Spalten %1 Zeilen. Verwenden Sie die Pfeiltasten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274175314104864930)
,p_name=>'APEX.ICON_LIST.LIST_DIM'
,p_message_language=>'de'
,p_message_text=>'Auswahlliste %0 Zeilen. Verwenden Sie die Pfeiltasten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274805444411865377)
,p_name=>'APEX.IG.ACC_LABEL'
,p_message_language=>'de'
,p_message_text=>'Interaktives Raster %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274037596880864833)
,p_name=>'APEX.IG.ACTIONS'
,p_message_language=>'de'
,p_message_text=>'Aktionen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274038555129864833)
,p_name=>'APEX.IG.ADD'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274038467079864833)
,p_name=>'APEX.IG.ADD_ROW'
,p_message_language=>'de'
,p_message_text=>unistr('Zeile hinzuf\00FCgen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274773147880865354)
,p_name=>'APEX.IG.AGGREGATE'
,p_message_language=>'de'
,p_message_text=>'Aggregat'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274736050944865328)
,p_name=>'APEX.IG.AGGREGATION'
,p_message_language=>'de'
,p_message_text=>'Aggregation'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274739003760865330)
,p_name=>'APEX.IG.ALL'
,p_message_language=>'de'
,p_message_text=>'Alle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274296232167865019)
,p_name=>'APEX.IG.ALL_TEXT_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Alle Textspalten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274297403989865020)
,p_name=>'APEX.IG.ALTERNATIVE'
,p_message_language=>'de'
,p_message_text=>'Alternative'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274298501095865021)
,p_name=>'APEX.IG.AND'
,p_message_language=>'de'
,p_message_text=>'und'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274644575370865264)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT'
,p_message_language=>'de'
,p_message_text=>unistr('Eindeutige Reihen z\00E4hlen - Ungef\00E4hr')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274774152221865355)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT_OVERALL'
,p_message_language=>'de'
,p_message_text=>unistr('Eindeutige z\00E4hlen - Insgesamt gesch\00E4tzt')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274732114190865325)
,p_name=>'APEX.IG.AREA'
,p_message_language=>'de'
,p_message_text=>unistr('Fl\00E4che')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274737686704865329)
,p_name=>'APEX.IG.ASCENDING'
,p_message_language=>'de'
,p_message_text=>'Aufsteigend'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274297517643865020)
,p_name=>'APEX.IG.AUTHORIZATION'
,p_message_language=>'de'
,p_message_text=>'Autorisierung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274773227555865354)
,p_name=>'APEX.IG.AUTO'
,p_message_language=>'de'
,p_message_text=>'Auto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274644920309865264)
,p_name=>'APEX.IG.AVG'
,p_message_language=>'de'
,p_message_text=>'Durchschnitt'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274773863267865355)
,p_name=>'APEX.IG.AVG_OVERALL'
,p_message_language=>'de'
,p_message_text=>'Gesamtdurchschnitt'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274731606794865325)
,p_name=>'APEX.IG.AXIS_LABEL_TITLE'
,p_message_language=>'de'
,p_message_text=>'Titel der Labelachse'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274731889768865325)
,p_name=>'APEX.IG.AXIS_VALUE_DECIMAL'
,p_message_language=>'de'
,p_message_text=>'Dezimalstellen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274731774916865325)
,p_name=>'APEX.IG.AXIS_VALUE_TITLE'
,p_message_language=>'de'
,p_message_text=>'Wert Achsentitel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274745810769865335)
,p_name=>'APEX.IG.BACKGROUND_COLOR'
,p_message_language=>'de'
,p_message_text=>'Hintergrundfarbe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274732258412865325)
,p_name=>'APEX.IG.BAR'
,p_message_language=>'de'
,p_message_text=>'Balken'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274279969115865007)
,p_name=>'APEX.IG.BETWEEN'
,p_message_language=>'de'
,p_message_text=>'zwischen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274747541495865336)
,p_name=>'APEX.IG.BOTH'
,p_message_language=>'de'
,p_message_text=>'Beides'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274732311061865325)
,p_name=>'APEX.IG.BUBBLE'
,p_message_language=>'de'
,p_message_text=>'Blase'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274038705226864833)
,p_name=>'APEX.IG.CANCEL'
,p_message_language=>'de'
,p_message_text=>'Abbrechen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274298487489865021)
,p_name=>'APEX.IG.CASE_SENSITIVE'
,p_message_language=>'de'
,p_message_text=>unistr('Gro\00DF-/Kleinschreibung beachten')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274774717786865355)
,p_name=>'APEX.IG.CASE_SENSITIVE_WITH_BRACKETS'
,p_message_language=>'de'
,p_message_text=>unistr('(Gro\00DF-/Kleinschreibung beachten)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274684267577865291)
,p_name=>'APEX.IG.CHANGES_SAVED'
,p_message_language=>'de'
,p_message_text=>unistr('\00C4nderungen gespeichert')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274039181460864834)
,p_name=>'APEX.IG.CHANGE_VIEW'
,p_message_language=>'de'
,p_message_text=>unistr('Ansicht \00E4ndern')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274299568274865021)
,p_name=>'APEX.IG.CHART'
,p_message_language=>'de'
,p_message_text=>'Diagramm'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274294943701865018)
,p_name=>'APEX.IG.CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'de'
,p_message_text=>unistr('Ihre Abfrage \00FCberschreitet die maximal zul\00E4ssigen %0 Datenpunkte pro Diagramm. Wenden Sie einen Filter an, um die Anzahl der Datens\00E4tze in der Basisabfrage zu reduzieren.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274037458080864833)
,p_name=>'APEX.IG.CHART_VIEW'
,p_message_language=>'de'
,p_message_text=>'Diagrammansicht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274100704411864878)
,p_name=>'APEX.IG.CLEAR'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274731151999865324)
,p_name=>'APEX.IG.CLOSE_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Schlie\00DFen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274746566668865335)
,p_name=>'APEX.IG.COLORS'
,p_message_language=>'de'
,p_message_text=>'Farben'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274746400502865335)
,p_name=>'APEX.IG.COLOR_BLUE'
,p_message_language=>'de'
,p_message_text=>'Blau'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274746387105865335)
,p_name=>'APEX.IG.COLOR_GREEN'
,p_message_language=>'de'
,p_message_text=>unistr('Gr\00FCn')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274746164264865335)
,p_name=>'APEX.IG.COLOR_ORANGE'
,p_message_language=>'de'
,p_message_text=>'Orange'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274746263791865335)
,p_name=>'APEX.IG.COLOR_RED'
,p_message_language=>'de'
,p_message_text=>'Rot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274746059641865335)
,p_name=>'APEX.IG.COLOR_YELLOW'
,p_message_language=>'de'
,p_message_text=>'Gelb'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274297840614865020)
,p_name=>'APEX.IG.COLUMN'
,p_message_language=>'de'
,p_message_text=>'Spalte'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274037620994864833)
,p_name=>'APEX.IG.COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Spalten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274751354591865339)
,p_name=>'APEX.IG.COLUMN_TYPE'
,p_message_language=>'de'
,p_message_text=>'Spaltenzweck'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274297920715865020)
,p_name=>'APEX.IG.COMPLEX'
,p_message_language=>'de'
,p_message_text=>'Komplex'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274037824710864833)
,p_name=>'APEX.IG.COMPUTE'
,p_message_language=>'de'
,p_message_text=>'Berechnen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274280586208865008)
,p_name=>'APEX.IG.CONTAINS'
,p_message_language=>'de'
,p_message_text=>unistr('enth\00E4lt')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274303831211865024)
,p_name=>'APEX.IG.CONTROL_BREAK'
,p_message_language=>'de'
,p_message_text=>'Kontrollgruppenwechsel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274100551936864878)
,p_name=>'APEX.IG.COPY_CB'
,p_message_language=>'de'
,p_message_text=>'In Zwischenablage kopieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274100632885864878)
,p_name=>'APEX.IG.COPY_DOWN'
,p_message_language=>'de'
,p_message_text=>'Nach unten kopieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274644327933865263)
,p_name=>'APEX.IG.COUNT'
,p_message_language=>'de'
,p_message_text=>'Anzahl'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274644431496865263)
,p_name=>'APEX.IG.COUNT_DISTINCT'
,p_message_language=>'de'
,p_message_text=>unistr('Nur eindeutige Reihen z\00E4hlen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274774015719865355)
,p_name=>'APEX.IG.COUNT_DISTINCT_OVERALL'
,p_message_language=>'de'
,p_message_text=>unistr('Eindeutige z\00E4hlen - Insgesamt')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274773978900865355)
,p_name=>'APEX.IG.COUNT_OVERALL'
,p_message_language=>'de'
,p_message_text=>'Gesamtanzahl'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274765489648865349)
,p_name=>'APEX.IG.CREATE_X'
,p_message_language=>'de'
,p_message_text=>'%0 erstellen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274296403597865019)
,p_name=>'APEX.IG.DATA'
,p_message_language=>'de'
,p_message_text=>'Daten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274748703094865337)
,p_name=>'APEX.IG.DATA_TYPE'
,p_message_language=>'de'
,p_message_text=>'Datentyp'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274747797052865336)
,p_name=>'APEX.IG.DATE'
,p_message_language=>'de'
,p_message_text=>'Datum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274684011841865291)
,p_name=>'APEX.IG.DATE_INVALID_VALUE'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltiger Datumswert')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274281483435865008)
,p_name=>'APEX.IG.DAYS'
,p_message_language=>'de'
,p_message_text=>'Tage'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274297167561865020)
,p_name=>'APEX.IG.DEFAULT_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Standardeinstellungen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274296950803865019)
,p_name=>'APEX.IG.DEFAULT_TYPE'
,p_message_language=>'de'
,p_message_text=>'Standardtyp'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274038632829864833)
,p_name=>'APEX.IG.DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274752309405865339)
,p_name=>'APEX.IG.DELETE_REPORT_CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('M\00F6chten Sie diesen Bericht wirklich l\00F6schen?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274305639557865026)
,p_name=>'APEX.IG.DELETE_ROW'
,p_message_language=>'de'
,p_message_text=>unistr('Zeile l\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274304455257865025)
,p_name=>'APEX.IG.DELETE_ROWS'
,p_message_language=>'de'
,p_message_text=>unistr('Zeilen l\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274737747066865329)
,p_name=>'APEX.IG.DESCENDING'
,p_message_language=>'de'
,p_message_text=>'Absteigend'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274299284753865021)
,p_name=>'APEX.IG.DETAIL'
,p_message_language=>'de'
,p_message_text=>'Detail'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274037118979864832)
,p_name=>'APEX.IG.DETAIL_VIEW'
,p_message_language=>'de'
,p_message_text=>'Detailansicht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274699955542865302)
,p_name=>'APEX.IG.DIRECTION'
,p_message_language=>'de'
,p_message_text=>'Richtung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274298915321865021)
,p_name=>'APEX.IG.DISABLED'
,p_message_language=>'de'
,p_message_text=>'Deaktiviert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274280667890865008)
,p_name=>'APEX.IG.DOES_NOT_CONTAIN'
,p_message_language=>'de'
,p_message_text=>unistr('enth\00E4lt nicht')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274280803599865008)
,p_name=>'APEX.IG.DOES_NOT_START_WITH'
,p_message_language=>'de'
,p_message_text=>'beginnt nicht mit'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274732409219865325)
,p_name=>'APEX.IG.DONUT'
,p_message_language=>'de'
,p_message_text=>'Ring'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274304060487865025)
,p_name=>'APEX.IG.DOWNLOAD'
,p_message_language=>'de'
,p_message_text=>'Herunterladen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274753396845865340)
,p_name=>'APEX.IG.DOWNLOAD_FORMAT'
,p_message_language=>'de'
,p_message_text=>unistr('Format ausw\00E4hlen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274738667000865330)
,p_name=>'APEX.IG.DUPLICATE_AGGREGATION'
,p_message_language=>'de'
,p_message_text=>'Aggregation duplizieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274738731816865330)
,p_name=>'APEX.IG.DUPLICATE_CONTROLBREAK'
,p_message_language=>'de'
,p_message_text=>'Gruppenwechsel duplizieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274305530303865026)
,p_name=>'APEX.IG.DUPLICATE_ROW'
,p_message_language=>'de'
,p_message_text=>'Zeile duplizieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274304304631865025)
,p_name=>'APEX.IG.DUPLICATE_ROWS'
,p_message_language=>'de'
,p_message_text=>'Doppelte Zeilen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274038221950864833)
,p_name=>'APEX.IG.EDIT'
,p_message_language=>'de'
,p_message_text=>'Bearbeiten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274737129750865329)
,p_name=>'APEX.IG.EDIT_CHART'
,p_message_language=>'de'
,p_message_text=>'Diagramm bearbeiten'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274761157037865346)
,p_name=>'APEX.IG.EDIT_GROUP_BY'
,p_message_language=>'de'
,p_message_text=>'"Gruppieren nach" bearbeiten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274752955467865340)
,p_name=>'APEX.IG.EMAIL_BCC'
,p_message_language=>'de'
,p_message_text=>'Blindkopie (Bcc)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274753164245865340)
,p_name=>'APEX.IG.EMAIL_BODY'
,p_message_language=>'de'
,p_message_text=>'Meldung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274752856614865340)
,p_name=>'APEX.IG.EMAIL_CC'
,p_message_language=>'de'
,p_message_text=>'Kopie (Cc)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274752544674865339)
,p_name=>'APEX.IG.EMAIL_SENT'
,p_message_language=>'de'
,p_message_text=>'E-Mail wurde gesendet.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274753072199865340)
,p_name=>'APEX.IG.EMAIL_SUBJECT'
,p_message_language=>'de'
,p_message_text=>'Betreff'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274752714976865340)
,p_name=>'APEX.IG.EMAIL_TO'
,p_message_language=>'de'
,p_message_text=>unistr('Empf\00E4nger (an)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274298686082865021)
,p_name=>'APEX.IG.ENABLED'
,p_message_language=>'de'
,p_message_text=>'Aktiviert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274278936130865007)
,p_name=>'APEX.IG.EQUALS'
,p_message_language=>'de'
,p_message_text=>'ist gleich'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274751990189865339)
,p_name=>'APEX.IG.EXAMPLE'
,p_message_language=>'de'
,p_message_text=>'Beispiel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274298778620865021)
,p_name=>'APEX.IG.EXPRESSION'
,p_message_language=>'de'
,p_message_text=>'Ausdruck'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274751849734865339)
,p_name=>'APEX.IG.FD_TYPE'
,p_message_language=>'de'
,p_message_text=>'Typ'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274400770263865092)
,p_name=>'APEX.IG.FILE_PREPARED'
,p_message_language=>'de'
,p_message_text=>'Datei vorbereitet. Download wird gestartet.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274100854187864878)
,p_name=>'APEX.IG.FILL'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCllen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274122274216864893)
,p_name=>'APEX.IG.FILL_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Auswahl f\00FCllen mit')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274122185435864893)
,p_name=>'APEX.IG.FILL_TITLE'
,p_message_language=>'de'
,p_message_text=>unistr('Auswahl f\00FCllen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274037708154864833)
,p_name=>'APEX.IG.FILTER'
,p_message_language=>'de'
,p_message_text=>'Filter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274298092009865020)
,p_name=>'APEX.IG.FILTERS'
,p_message_language=>'de'
,p_message_text=>'Filter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274773537355865354)
,p_name=>'APEX.IG.FILTER_WITH_DOTS'
,p_message_language=>'de'
,p_message_text=>'Filtern...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274737949243865329)
,p_name=>'APEX.IG.FIRST'
,p_message_language=>'de'
,p_message_text=>'Erster'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274037939611864833)
,p_name=>'APEX.IG.FLASHBACK'
,p_message_language=>'de'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274296548940865019)
,p_name=>'APEX.IG.FORMAT'
,p_message_language=>'de'
,p_message_text=>'Formatieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274747451790865336)
,p_name=>'APEX.IG.FORMATMASK'
,p_message_language=>'de'
,p_message_text=>'Formatmaske'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274752234477865339)
,p_name=>'APEX.IG.FORMAT_CSV'
,p_message_language=>'de'
,p_message_text=>'CSV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274752104582865339)
,p_name=>'APEX.IG.FORMAT_HTML'
,p_message_language=>'de'
,p_message_text=>'HTML'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274305215214865025)
,p_name=>'APEX.IG.FREEZE'
,p_message_language=>'de'
,p_message_text=>'Fixieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274298814878865021)
,p_name=>'APEX.IG.FUNCTIONS_AND_OPERATORS'
,p_message_language=>'de'
,p_message_text=>'Funktionen und Operatoren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274732568825865325)
,p_name=>'APEX.IG.FUNNEL'
,p_message_language=>'de'
,p_message_text=>'Trichter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274644226611865263)
,p_name=>'APEX.IG.GO'
,p_message_language=>'de'
,p_message_text=>'Los'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274279509131865007)
,p_name=>'APEX.IG.GREATER_THAN'
,p_message_language=>'de'
,p_message_text=>unistr('gr\00F6\00DFer als')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274279674121865007)
,p_name=>'APEX.IG.GREATER_THAN_OR_EQUALS'
,p_message_language=>'de'
,p_message_text=>unistr('gr\00F6\00DFer/gleich')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274299171777865021)
,p_name=>'APEX.IG.GRID'
,p_message_language=>'de'
,p_message_text=>'Grid'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274036989911864832)
,p_name=>'APEX.IG.GRID_VIEW'
,p_message_language=>'de'
,p_message_text=>'Grid-Ansicht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274738968585865330)
,p_name=>'APEX.IG.GROUP'
,p_message_language=>'de'
,p_message_text=>'Gruppe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274299327819865021)
,p_name=>'APEX.IG.GROUP_BY'
,p_message_language=>'de'
,p_message_text=>'Gruppieren nach'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274037277052864832)
,p_name=>'APEX.IG.GROUP_BY_VIEW'
,p_message_language=>'de'
,p_message_text=>'Ansicht "Gruppieren nach"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274748012167865336)
,p_name=>'APEX.IG.HD_TYPE'
,p_message_language=>'de'
,p_message_text=>'Bedingungstyp'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274746984797865336)
,p_name=>'APEX.IG.HEADING'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCberschrift')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274747143977865336)
,p_name=>'APEX.IG.HEADING_ALIGN'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCberschriftenausrichtung')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274773436150865354)
,p_name=>'APEX.IG.HELP'
,p_message_language=>'de'
,p_message_text=>'Hilfe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274759200837865344)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Sie k\00F6nnen Daten direkt innerhalb dieses interaktiven Grids einf\00FCgen, aktualisieren und l\00F6schen.</p>'),
'',
unistr('<p>F\00FCgen Sie eine neue Zeile ein, indem Sie auf die Schaltfl\00E4che "Zeile hinzuf\00FCgen" klicken.</p>'),
'',
unistr('<p>Bearbeiten Sie vorhandene Daten, indem Sie auf eine bestimmte Zelle doppelklicken. F\00FCr umfangreichere Bearbeitungen klicken Sie auf "Bearbeiten", um den Bearbeitungsmodus aufzurufen. Im Bearbeitungsmodus k\00F6nnen Sie bestimmte Zellen mit einem Einze')
||'lklick oder der Tastatur bearbeiten.</p>',
'',
unistr('<p>Verwenden Sie das Men\00FC "\00C4ndern", um Zeilen zu duplizieren und zu l\00F6schen. Um das Men\00FC "\00C4ndern" zu aktivieren, verwenden Sie die Kontrollk\00E4stchen, um eine oder mehrere Zeilen auszuw\00E4hlen.</p>'),
'',
unistr('<p>Duplizieren Sie eine ausgew\00E4hlte Zeile, indem Sie auf das Men\00FC "\00C4ndern" klicken und "Zeilen duplizieren" ausw\00E4hlen. L\00F6schen Sie eine ausgew\00E4hlte Zeile, indem Sie auf das Men\00FC "\00C4ndern" klicken und "Zeile l\00F6schen" ausw\00E4hlen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274761690359865346)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING_HEADING'
,p_message_language=>'de'
,p_message_text=>unistr('Bearbeitungsm\00F6glichkeiten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274761744560865346)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In einem interaktiven Grid wird eine Gruppe von Daten in einem Bericht dargestellt, der durchsucht und angepasst werden kann. Sie k\00F6nnen viele Vorg\00E4nge ausf\00FChren, um die zur\00FCckgegebenen Datens\00E4tze zu begrenzen und die Art der Datenanzeige zu \00E4nder')
||'n.</p>',
'',
unistr('<p>Mit dem Suchfeld k\00F6nnen Sie die zur\00FCckgegebenen Datens\00E4tze filtern. Klicken Sie auf "Aktionen", um die verschiedenen Optionen zur \00C4nderung des Berichtslayouts aufzurufen. Sie k\00F6nnen auch das Men\00FC "Spalten\00FCberschrift" f\00FCr angezeigte Spalten verwend')
||'en.</p>',
'',
unistr('<p>Verwenden Sie "Berichtseinstellungen", um die Anpassungen in einem Bericht zu speichern. Sie k\00F6nnen die Daten aus dem Bericht auch in eine externe Datei herunterladen oder die Daten per E-Mail an sich selbst oder andere senden. </p>'),
'',
'<p>Weitere Informationen finden Sie unter "Using Interactive Grids" in <em>Oracle Application Express End User''s Guide</em>.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274761417541865346)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO_HEADING'
,p_message_language=>'de'
,p_message_text=>'Zusammenfassung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274759157341865344)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Sie k\00F6nnen das interaktive Grid anpassen, um Daten mit den integrierten Funktionen auf unterschiedliche Weise anzuzeigen.</p>'),
'',
unistr('<p>Mit den Men\00FCs "Spalten\00FCberschrift" oder dem Men\00FC "Aktionen" k\00F6nnen Sie bestimmen, welche Spalten angezeigt werden sollen und in welcher Reihenfolge sie angezeigt werden sollen. Au\00DFerdem k\00F6nnen Sie Spalten fixieren. Sie k\00F6nnen auch verschiedene Dat')
||unistr('enfilter definieren und die zur\00FCckgegebenen Daten sortieren.</p>'),
'',
unistr('<p>Mit der Schaltfl\00E4che "Anzeigen" (neben dem Suchfeld) k\00F6nnen Sie andere Datenansichten aufrufen, die vom Anwendungsentwickler definiert wurden. Sie k\00F6nnen auch ein Diagramm erstellen oder ein vorhandenes Diagramm anzeigen.</p>  '),
'',
unistr('<p><em>Hinweis: Klicken Sie auf <strong>Hilfe</strong> in den Dialogfeldern des interaktiven Grids, um detailliertere Informationen zu der ausgew\00E4hlten Funktion zu erhalten.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274761588129865346)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING_HEADING'
,p_message_language=>'de'
,p_message_text=>unistr('Berichtserstellungsm\00F6glichkeiten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274304229609865025)
,p_name=>'APEX.IG.HELP.ACTIONS_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu interaktivem Grid'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274756198684865342)
,p_name=>'APEX.IG.HELP.AGGREGATE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie Spalten aggregieren. Aggregierte Werte werden am Ende der Daten angezeigt, oder wenn Gruppenwechsel definiert sind, am Ende jedes Umbruchs.</p>'),
'',
'<p><strong>Aggregationsliste</strong><br>',
'Die Aggregationsliste zeigt definierte Aggregationen an. Deaktivieren Sie eine vorhandene Aggregation, indem Sie deren Auswahl aufheben.<br>',
unistr('Klicken Sie auf "Hinzuf\00FCgen" ( &plus; ), um eine neue Aggregation zu erstellen, oder auf "L\00F6schen" ( &minus; ), um eine vorhandene Aggregation zu entfernen.</p>'),
'',
'<p><strong>Aggregationseinstellungen</strong><br>',
'Mit dem Formular auf der rechten Seite definieren Sie die Aggregation.<br>',
unistr('W\00E4hlen Sie den Spaltennamen und Aggregationstyp aus.<br>'),
unistr('Optional geben Sie eine QuickInfo f\00FCr die Aggregation ein.<br>'),
unistr('Wenn Sie einen Gruppenwechsel definiert haben, wird durch Auswahl von <strong>Gesamtwert anzeigen</strong> der Gesamtdurchschnitt, die Gesamtsumme oder ein \00E4hnlicher Wert am Ende der Daten angezeigt.</p>'),
'',
unistr('<p><em>Hinweis: Rufen Sie das Dialogfeld "Aggregation" im Men\00FC "Aktionen" oder durch Klicken auf die Spalten\00FCberschrift und Summe ( &sum; ) auf.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274760536206865345)
,p_name=>'APEX.IG.HELP.AGGREGATE_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu "Aggregation"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274756848229865343)
,p_name=>'APEX.IG.HELP.CHART'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie ein Diagramm definieren, das als separate Datenansicht angezeigt wird.<br> '),
unistr('W\00E4hlen Sie einen Diagrammtyp aus, konfigurieren Sie die Diagrammeinstellungen, und klicken Sie auf <strong>Speichern.</strong></p>'),
'',
'<p><strong>Diagrammeinstellungen</strong></br>',
'Die angezeigten Diagrammattribute variieren je nach Diagrammtyp. Eine Anzahl von Attributen kann zur Definition des Diagramms eingegeben werden. Mit einem roten Sternchen markierte Attribute sind obligatorisch.</p>',
'',
unistr('<p>Im Folgenden werden alle verf\00FCgbaren Attribute \00FCber die verschiedenen Diagrammtypen hinweg (in alphabetischer Reihenfolge) aufgef\00FChrt:'),
'<ul>',
unistr('  <li>Aggregation - W\00E4hlen Sie aus, wie die verkn\00FCpften Diagrammwerte aggregiert werden sollen.</li> '),
unistr('  <li>Schluss - W\00E4hlen Sie die Spalte aus, die den t\00E4glichen Schlusskurs einer Aktie enth\00E4lt (nur Aktiendiagramme).</li> '),
'  <li>Dezimalstellen - Geben Sie die Anzahl von Dezimalstellen ein, auf die die Werte gerundet werden.</li> ',
'  <li>Richtung - Geben Sie bezogen auf das Attribut "Sortieren nach" an, ob die Daten nach aufsteigenden oder absteigenden Werten sortiert werden sollen.</li> ',
unistr('  <li>Hoch - W\00E4hlen Sie die Spalte aus, die den h\00F6chsten Wert enth\00E4lt (nur Bereichs- und Aktiendiagramme).</li> '),
unistr('  <li>Label - W\00E4hlen Sie die Spalte aus, die den Text f\00FCr jeden Datenpunkt enth\00E4lt.</li> '),
'  <li>Titel der Labelachse - Geben Sie den Titel ein, der auf der Labelachse angezeigt wird.</li> ',
unistr('  <li>Niedrig - W\00E4hlen Sie die Spalte aus, die den niedrigen Wert enth\00E4lt (nur Bereichs- und Aktiendiagramme).</li> '),
unistr('  <li>Nullwerte - Geben Sie in Bezug auf das Attribut "Sortieren nach" an, wie Datens\00E4tze mit Nullwerten bezogen auf Datens\00E4tze mit Nicht-Null-Werten sortiert werden sollen.</li> '),
unistr('  <li>Er\00F6ffnung - W\00E4hlen Sie die Spalte aus, die den t\00E4glichen Er\00F6ffnungskurs der Aktien enth\00E4lt (nur Aktiendiagramme).</li> '),
unistr('  <li>Ausrichtung - W\00E4hlen Sie, ob die Diagrammelemente, wie Balken, vertikal oder horizontal angezeigt werden sollen.</li> '),
unistr('  <li>Datenreihe - W\00E4hlen Sie die Spalte aus, die zur Definition einer dynamischen Abfrage mit mehreren Datenreihen verwendet wird.</li> '),
'  <li>Stapel - Geben Sie an, ob die Datenelemente gestapelt werden.</li> ',
unistr('  <li>Sortieren nach - W\00E4hlen Sie aus, ob das Diagramm nach dem Label oder dem bzw. den Werten sortiert werden soll.</li> '),
unistr('  <li>Ziel - W\00E4hlen Sie die Spalte aus, die zur Definition des Zielwertes in diesem Diagramm verwendet werden soll. Wenn es festgelegt ist, definiert das Wertattribut den ausgef\00FCllten Bereich innerhalb des Segments, und das Ziel stellt den Wert des g')
||'esamten Segments dar (nur Trichterdiagramm).</li> ',
unistr('  <li>Wert - W\00E4hlen Sie die Spalte aus, die die darzustellenden Daten enth\00E4lt.</li> '),
'  <li>Titel der Wertachse - Geben Sie den Titel ein, der auf der Wertachse angezeigt wird.</li> ',
unistr('  <li>Volumen - W\00E4hlen Sie die Spalte aus, die das t\00E4gliche Aktienvolumen enth\00E4lt (nur Aktiendiagramme).</li> '),
unistr('  <li>X - W\00E4hlen Sie die Spalte aus, die den X-Achsenwert f\00FCr dieses Diagramm enth\00E4lt (nur Blasen- und Streudiagramme).</li> '),
unistr('  <li>Y - W\00E4hlen Sie die Spalte aus, die den Y-Achsenwert f\00FCr dieses Diagramm enth\00E4lt (nur Blasen- und Streudiagramme).</li> '),
unistr('  <li>Z - W\00E4hlen Sie die Spalte aus, die die Balkenbreite oder den Blasenradius enth\00E4lt (nur Balken-, Blasen- und Bereichsdiagramme)</li> '),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274760902644865346)
,p_name=>'APEX.IG.HELP.CHART_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu "Diagramme"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274755866274865342)
,p_name=>'APEX.IG.HELP.COLUMNS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie ausw\00E4hlen, welche Spalten angezeigt werden und in welcher Reihenfolge sie angezeigt werden.</p>'),
'',
'<p>Blenden Sie eine Spalte aus, indem Sie ihre Auswahl aufheben.<br>',
'Ordnen Sie Spalten neu an, indem Sie auf "Nach oben verschieben" ( &uarr; ) oder "Nach unten verschieben" ( &darr; ) klicken.<br>',
'Verwenden Sie den Dropdown-Selektor, um "Alle Spalten", "Angezeigte Spalten" oder "Nicht angezeigte Spalten" aufzulisten.</p>',
'',
'<p>Optional geben Sie im Formular die Mindestbreite einer Spalte in Pixel an.</p>',
'',
unistr('<p><em>Hinweis: Sie k\00F6nnen angezeigte Spalten auch neu anordnen, indem Sie auf den Ziehpunkt (am Anfang der Spalten\00FCberschrift) klicken und die Spalte nach links oder rechts ziehen. Sie k\00F6nnen die Breite von angezeigten Spalten auch \00E4ndern, indem Sie')
||unistr(' die Spaltentrennlinie zwischen \00DCberschriften ausw\00E4hlen und nach links oder rechts verschieben.</em</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274760854944865345)
,p_name=>'APEX.IG.HELP.COLUMNS_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu Spalten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274756223799865342)
,p_name=>'APEX.IG.HELP.COMPUTE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie zus\00E4tzliche Spalten basierend auf mathematischen und funktionalen Berechnungen definieren, die f\00FCr vorhandene Spalten ausgef\00FChrt werden.</p>'),
'',
'<p><strong>Berechnungsliste</strong><br>',
'In der Berechnungsliste werden definierte Berechnungen angezeigt. Deaktivieren Sie eine vorhandene Berechnung, indem Sie deren Auswahl aufheben.<br>',
unistr('Klicken Sie auf "Hinzuf\00FCgen" ( &plus; ), um eine neue Berechnung hinzuzuf\00FCgen, oder auf "L\00F6schen" ( &minus; ), um eine vorhandene Berechnung zu entfernen.</p>'),
'',
'<p><strong>Berechnungseinstellungen</strong><br>',
'Verwenden Sie das Formular zur Definition der Berechnung.<br>',
unistr('Geben Sie die Spaltendetails ein, wie \00DCberschrift und Label, und w\00E4hlen Sie Ausrichtungseinstellungen aus.<br> '),
unistr('Im Ausdruckstextbereich geben Sie die Spalten und verkn\00FCpften Funktionen f\00FCr die Berechnung ein.<br>'),
unistr('W\00E4hlen Sie den entsprechenden Datentyp und optional eine Formatmaske f\00FCr die neue Spalte aus.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274760456480865345)
,p_name=>'APEX.IG.HELP.COMPUTE_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu "Berechnen"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274756514824865342)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie einen Gruppenwechsel f\00FCr eine oder mehrere Spalten definieren.</p>'),
'',
'<p><strong>Gruppenwechselliste</strong><br>',
'In der Gruppenwechselliste werden definierte Gruppenwechsel angezeigt. Deaktivieren Sie eine vorhandene Gruppenwechselspalte, indem Sie deren Auswahl aufheben.<br>',
unistr('Klicken Sie auf "Hinzuf\00FCgen" ( &plus; ), um eine neue Spalte in dem Gruppenwechsel einzubeziehen, oder auf "L\00F6schen" ( &minus; ), um eine vorhandene Spalte aus dem Gruppenwechsel zu entfernen.<br>'),
unistr('Um Spalten neu anzuordnen, klicken Sie auf "Nach oben verschieben" ( &uarr; ) oder "Nach unten verschieben" ( &darr; ), um die ausgew\00E4hlte Spalte bezogen auf andere Spalten nach oben oder unten zu verschieben.</p>'),
'',
'<p><strong>Gruppenwechseleinstellungen</strong><br>',
unistr('In dem Formular k\00F6nnen Sie eine Gruppenwechselspalte definieren.<br>'),
unistr('W\00E4hlen Sie eine Gruppenwechselspalte und die Sortierrichtung aus, und geben Sie an, wie Nullspalten (Spalten ohne Wert) angeordnet werden sollen.</p>'),
'',
unistr('<p><em>Hinweis: Bei Anzeige des interaktiven Grids k\00F6nnen Sie einen Gruppenwechsel definieren, indem Sie auf eine Spalten\00FCberschrift klicken und das Gruppenwechselsymbol ausw\00E4hlen.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274760133974865345)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu "Gruppenwechsel"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274756711682865343)
,p_name=>'APEX.IG.HELP.DOWNLOAD'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie alle aktuellen Zeilen in eine externe Datei herunterladen. Die Datei enth\00E4lt nur die aktuell angezeigten Spalten, wobei f\00FCr die Daten angewendete Filter und Sortiervorg\00E4nge verwendet werden.</p>'),
'',
unistr('<p>W\00E4hlen Sie das Dateiformat aus, und klicken Sie auf "Herunterladen".<br>'),
unistr('Hinweis: Das CSV-Format enth\00E4lt keine Textformatierung, wie Aggregate und Gruppenwechsel.</p>'),
'',
unistr('<p>Um die Datei per E-Mail zu versenden, w\00E4hlen Sie "Als E-Mail senden" aus und geben die E-Mail-Details ein (Empf\00E4nger, Betreff und Nachricht).</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274759998319865345)
,p_name=>'APEX.IG.HELP.DOWNLOAD_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu "Download"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274755950816865342)
,p_name=>'APEX.IG.HELP.FILTER'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie Datenfilter konfigurieren, die die zur\00FCckgegebenen Zeilen begrenzen.</p>'),
'',
'<p><strong>Filterliste</strong><br>',
'In der Filterliste werden definierte Filter angezeigt. Deaktivieren Sie einen vorhandenen Filter, indem Sie dessen Auswahl aufheben.<br>',
unistr('Klicken Sie auf "Hinzuf\00FCgen" (&plus;), um einen neuen Filter zu erstellen, oder auf "L\00F6schen" (&minus;), um einen vorhandenen Filter zu entfernen.</p>'),
'',
'<p><strong>Filtereinstellungen</strong><br>',
unistr('Im Formular k\00F6nnen Sie die Filtereigenschaften definieren.<br>'),
unistr('W\00E4hlen Sie den entsprechenden Filtertyp:<br>'),
'&nbsp;&nbsp;&nbsp;Zeile - Filtert nach einem Begriff in einer Spalte, die gefiltert werden kann.<br>',
'&nbsp;&nbsp;&nbsp;Spalte - Filtert eine bestimmte Spalte mit einem angegebenen Operator und Wert.<br>',
'',
unistr('<p><em>Hinweis: Bei der Anzeige des interaktiven Rasters k\00F6nnen Sie Zeilenfilter durch direkte Eingabe in das Suchfeld definieren. Klicken Sie auf "Zu suchende Spalten ausw\00E4hlen", um die Suche auf eine bestimmte Spalte zu begrenzen. \00D6ffnen Sie altern')
||unistr('ativ ein Men\00FC "Spalten\00FCberschrift", und w\00E4hlen Sie einen Wert, um einen Spaltenfilter zu erstellen.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274760745094865345)
,p_name=>'APEX.IG.HELP.FILTER_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu Filter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274756332041865342)
,p_name=>'APEX.IG.HELP.FLASHBACK'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie die Daten so anzeigen, wie sie zu einem fr\00FCheren Zeitpunkt vorhanden waren.</p>'),
unistr('<p>Geben Sie die Anzahl von Minuten in der Vergangenheit ein, um die Flashback-Abfrage auszuf\00FChren.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274760390359865345)
,p_name=>'APEX.IG.HELP.FLASHBACK_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu "Flashback"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274761033013865346)
,p_name=>'APEX.IG.HELP.GROUP_BY_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu "Gruppieren nach"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274756442353865342)
,p_name=>'APEX.IG.HELP.HIGHLIGHT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie Zeilen oder Spalten mit Daten basierend auf der eingegebenen Bedingung markieren.</p>'),
'',
'<p><strong>Markierungsliste</strong><br>',
'In der Markierungsliste werden definierte Markierungen angezeigt. Deaktivieren Sie eine vorhandene Markierung, indem Sie deren Auswahl aufheben.<br>',
unistr('Klicken Sie auf "Hinzuf\00FCgen" (&plus;), um eine neue Markierung zu erstellen, oder auf "L\00F6schen" (&minus;), um eine vorhandene Markierung zu entfernen.</p>'),
'',
'<p><strong>Markierungseinstellungen</strong><br>',
unistr('Im Formular k\00F6nnen Sie die Markierungseigenschaften definieren.<br>'),
unistr('Geben Sie den Namen ein, w\00E4hlen Sie "Zeile" oder "Spalte", und w\00E4hlen Sie die HTML-Farbcodes f\00FCr Hintergrund und Text.<br>'),
unistr('W\00E4hlen Sie den entsprechenden <strong>Bedingungstyp</strong>, um bestimmte Daten zu markieren:<br>'),
'&nbsp;&nbsp;&nbsp;Zeile - Markiert den Begriff in jeder Spalte.<br>',
'&nbsp;&nbsp;&nbsp;Spalte - Markiert den Begriff innerhalb einer bestimmten Spalte basierend auf dem angegebenen Operator und Wert.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274760268483865345)
,p_name=>'APEX.IG.HELP.HIGHLIGHT_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu "Markieren"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274756687016865342)
,p_name=>'APEX.IG.HELP.REPORT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie \00C4nderungen speichern, die Sie an dem aktuellen Grid-Layout und der aktuellen Konfiguration vorgenommen haben.<br>'),
unistr('Anwendungsentwickler k\00F6nnen mehrere alternative Berichtslayouts erstellen. Wenn zul\00E4ssig, k\00F6nnen Sie und andere Endbenutzer einen Bericht als \00F6ffentlichen Bericht speichern, sodass der Bericht f\00FCr alle Benutzer des Grids verf\00FCgbar ist. Sie k\00F6nnen ein')
||unistr('en Bericht auch als privaten Bericht speichern, den nur Sie anzeigen k\00F6nnen.</p>'),
unistr('<p>W\00E4hlen Sie unter den verf\00FCgbaren Typen aus, und geben Sie einen Namen f\00FCr den gespeicherten Bericht ein.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274760095724865345)
,p_name=>'APEX.IG.HELP.REPORT_TITLE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hilfe zu "Bericht"',
''))
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274756034272865342)
,p_name=>'APEX.IG.HELP.SORT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Dialogfeld k\00F6nnen Sie die Anzeigereihenfolge festlegen.</p>'),
'',
'<p><strong>Sortierliste</strong><br>',
'Im Dialogfeld "Sortieren" wird eine Liste der konfigurierten Sortierregeln angezeigt.<br>',
unistr('Klicken Sie auf "Hinzuf\00FCgen" ( &plus; ), um eine Sortierspalte zu erstellen, oder auf "L\00F6schen" ( &minus; ), um eine Sortierspalte zu entfernen.<br>'),
unistr('Klicken Sie auf "Nach oben verschieben" ( &uarr; ) und "Nach unten verschieben" ( &darr; ), um die ausgew\00E4hlte Sortierspalte bezogen auf die anderen Sortierspalten nach oben oder unten zu verschieben.</p>'),
'',
'<p><strong>Sortiereinstellungen</strong><br>',
unistr('W\00E4hlen Sie eine Sortierspalte und die Sortierrichtung aus, und geben Sie an, wie Nullspalten (Spalten ohne Wert) angeordnet werden sollen.</p>'),
'',
unistr('<p><em>Hinweis: Daten k\00F6nnen nach Spalten sortiert werden, die nicht angezeigt werden, es k\00F6nnen jedoch nicht alle Spalten sortiert werden.</em><br>'),
unistr('<em>Angezeigte Spalten k\00F6nnen sortiert werden, indem auf die Pfeile nach oben (aufsteigend) oder nach unten (absteigend) am Ende der Spalten\00FCberschriften geklickt wird. Um eine nachfolgende Spalte zu einem vorhandenen Sortiervorgang hinzuzuf\00FCgen, hal')
||unistr('ten Sie die Umschalttaste gedr\00FCckt und klicken auf den Pfeil nach oben oder unten.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274760615079865345)
,p_name=>'APEX.IG.HELP.SORT_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu "Sortieren"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274759896170865345)
,p_name=>'APEX.IG.HELP.SUBSCRIPTION_TITLE'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu "Abonnement"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274305130032865025)
,p_name=>'APEX.IG.HIDE'
,p_message_language=>'de'
,p_message_text=>'Ausblenden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274038170860864833)
,p_name=>'APEX.IG.HIGHLIGHT'
,p_message_language=>'de'
,p_message_text=>'Markierung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274731270052865325)
,p_name=>'APEX.IG.HIGH_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Hoch'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274732014973865325)
,p_name=>'APEX.IG.HORIZONTAL'
,p_message_language=>'de'
,p_message_text=>'Horizontal'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274281322347865008)
,p_name=>'APEX.IG.HOURS'
,p_message_language=>'de'
,p_message_text=>'Stunden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274299096537865021)
,p_name=>'APEX.IG.ICON'
,p_message_language=>'de'
,p_message_text=>'Symbol'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274037032203864832)
,p_name=>'APEX.IG.ICON_VIEW'
,p_message_language=>'de'
,p_message_text=>'Symbolansicht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274279344650865007)
,p_name=>'APEX.IG.IN'
,p_message_language=>'de'
,p_message_text=>'in'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274304755602865025)
,p_name=>'APEX.IG.INACTIVE_SETTING'
,p_message_language=>'de'
,p_message_text=>'Inaktive Einstellung'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274304837460865025)
,p_name=>'APEX.IG.INACTIVE_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Inaktive Einstellungen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274352117523865058)
,p_name=>'APEX.IG.INTERNAL_ERROR'
,p_message_language=>'de'
,p_message_text=>'Bei der Verarbeitung der Anforderung "Interaktives Grid" ist ein interner Fehler aufgetreten.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274759349645865344)
,p_name=>'APEX.IG.INVALID_DATE_FORMAT'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltiges Datumsformat')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274769954932865352)
,p_name=>'APEX.IG.INVALID_SETTING'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige Einstellung')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274770061256865352)
,p_name=>'APEX.IG.INVALID_SETTINGS'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige Einstellungen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274745736835865335)
,p_name=>'APEX.IG.INVALID_SORT_BY'
,p_message_language=>'de'
,p_message_text=>unistr('"Sortieren nach" wurde auf %0 festgelegt, es wurde jedoch keine Spalte f\00FCr %0 ausgew\00E4hlt.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274738811948865330)
,p_name=>'APEX.IG.INVALID_VALUE'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltiger Wert')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274727000869865322)
,p_name=>'APEX.IG.INVISIBLE'
,p_message_language=>'de'
,p_message_text=>'Nicht angezeigt'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274280155191865008)
,p_name=>'APEX.IG.IN_THE_LAST'
,p_message_language=>'de'
,p_message_text=>'in den letzten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274280331263865008)
,p_name=>'APEX.IG.IN_THE_NEXT'
,p_message_language=>'de'
,p_message_text=>unistr('in den n\00E4chsten')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274279232988865007)
,p_name=>'APEX.IG.IS_NOT_NULL'
,p_message_language=>'de'
,p_message_text=>'ist nicht leer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274279196395865007)
,p_name=>'APEX.IG.IS_NULL'
,p_message_language=>'de'
,p_message_text=>'ist leer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274747068587865336)
,p_name=>'APEX.IG.LABEL'
,p_message_language=>'de'
,p_message_text=>'Label'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274730572337865324)
,p_name=>'APEX.IG.LABEL_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Label'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274738016164865329)
,p_name=>'APEX.IG.LAST'
,p_message_language=>'de'
,p_message_text=>'Letzte'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274178030983864932)
,p_name=>'APEX.IG.LAST.DAY'
,p_message_language=>'de'
,p_message_text=>'Letzter Tag'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274178248995864932)
,p_name=>'APEX.IG.LAST.HOUR'
,p_message_language=>'de'
,p_message_text=>'Letzte Stunde'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274178741983864933)
,p_name=>'APEX.IG.LAST.MINUTE'
,p_message_language=>'de'
,p_message_text=>'Letzte Minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274177732738864932)
,p_name=>'APEX.IG.LAST.MONTH'
,p_message_language=>'de'
,p_message_text=>'Letzter Monat'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274177815879864932)
,p_name=>'APEX.IG.LAST.WEEK'
,p_message_language=>'de'
,p_message_text=>'Letzte Woche'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274177910053864932)
,p_name=>'APEX.IG.LAST.X_DAYS'
,p_message_language=>'de'
,p_message_text=>'Letzte %0 Tage'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274178172453864932)
,p_name=>'APEX.IG.LAST.X_HOURS'
,p_message_language=>'de'
,p_message_text=>'Letzte %0 Stunden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274178845969864933)
,p_name=>'APEX.IG.LAST.X_MINUTES'
,p_message_language=>'de'
,p_message_text=>'Letzte %0 Minuten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274178614699864933)
,p_name=>'APEX.IG.LAST.X_MONTHS'
,p_message_language=>'de'
,p_message_text=>'Letzte %0 Monate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274178590602864933)
,p_name=>'APEX.IG.LAST.X_WEEKS'
,p_message_language=>'de'
,p_message_text=>'Letzte %0 Wochen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274177593118864932)
,p_name=>'APEX.IG.LAST.X_YEARS'
,p_message_language=>'de'
,p_message_text=>'Letzte %0 Jahre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274177656601864932)
,p_name=>'APEX.IG.LAST.YEAR'
,p_message_language=>'de'
,p_message_text=>'Letztes Jahr'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274747261590865336)
,p_name=>'APEX.IG.LAYOUT_ALIGN'
,p_message_language=>'de'
,p_message_text=>'Zellenausrichtung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274747394427865336)
,p_name=>'APEX.IG.LAYOUT_USEGROUPFOR'
,p_message_language=>'de'
,p_message_text=>unistr('Gruppe verwenden f\00FCr')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274279787928865007)
,p_name=>'APEX.IG.LESS_THAN'
,p_message_language=>'de'
,p_message_text=>'kleiner als'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274279869062865007)
,p_name=>'APEX.IG.LESS_THAN_OR_EQUALS'
,p_message_language=>'de'
,p_message_text=>'kleiner/gleich'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274732663561865325)
,p_name=>'APEX.IG.LINE'
,p_message_language=>'de'
,p_message_text=>'Zeile'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274732729284865326)
,p_name=>'APEX.IG.LINE_WITH_AREA'
,p_message_language=>'de'
,p_message_text=>unistr('Linien/Fl\00E4chen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274747627706865336)
,p_name=>'APEX.IG.LISTAGG'
,p_message_language=>'de'
,p_message_text=>'Listagg'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274731398694865325)
,p_name=>'APEX.IG.LOW_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Niedrig'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274753246310865340)
,p_name=>'APEX.IG.MAILADDRESSES_COMMASEP'
,p_message_language=>'de'
,p_message_text=>'Trennen Sie mehrere Adressen durch Komma'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274280912267865008)
,p_name=>'APEX.IG.MATCHES_REGULAR_EXPRESSION'
,p_message_language=>'de'
,p_message_text=>unistr('entspricht regul\00E4rem Ausdruck')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274644883826865264)
,p_name=>'APEX.IG.MAX'
,p_message_language=>'de'
,p_message_text=>'Maximal'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274774319006865355)
,p_name=>'APEX.IG.MAX_OVERALL'
,p_message_language=>'de'
,p_message_text=>unistr('Gesamth\00F6chstwert')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274645013383865264)
,p_name=>'APEX.IG.MEDIAN'
,p_message_language=>'de'
,p_message_text=>'Medianwert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274774438624865355)
,p_name=>'APEX.IG.MEDIAN_OVERALL'
,p_message_language=>'de'
,p_message_text=>'Gesamtmittelwert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274644713611865264)
,p_name=>'APEX.IG.MIN'
,p_message_language=>'de'
,p_message_text=>'Minimal'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274281227788865008)
,p_name=>'APEX.IG.MINUTES'
,p_message_language=>'de'
,p_message_text=>'Minuten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274646548557865265)
,p_name=>'APEX.IG.MINUTES_AGO'
,p_message_language=>'de'
,p_message_text=>unistr('Minuten zur\00FCck')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274774218650865355)
,p_name=>'APEX.IG.MIN_OVERALL'
,p_message_language=>'de'
,p_message_text=>'Gesamtmindestwert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274281829600865009)
,p_name=>'APEX.IG.MONTHS'
,p_message_language=>'de'
,p_message_text=>'Monaten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274305040348865025)
,p_name=>'APEX.IG.MORE_DATA_FOUND'
,p_message_language=>'de'
,p_message_text=>unistr('Die Daten enthalten mehr als %0 Zeilen; dies \00FCberschreitet den zul\00E4ssigen H\00F6chstwert. Wenden Sie zus\00E4tzliche Filter an, um die Ergebnisse anzuzeigen.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274297067476865020)
,p_name=>'APEX.IG.NAME'
,p_message_language=>'de'
,p_message_text=>'Name'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274297237293865020)
,p_name=>'APEX.IG.NAMED_REPORT'
,p_message_language=>'de'
,p_message_text=>'Benannter Bericht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274176929544864931)
,p_name=>'APEX.IG.NEXT.DAY'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chster Tag')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274176739670864931)
,p_name=>'APEX.IG.NEXT.HOUR'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste Stunde')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274178972881864933)
,p_name=>'APEX.IG.NEXT.MINUTE'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste Minute')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274177209430864932)
,p_name=>'APEX.IG.NEXT.MONTH'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chster Monat')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274177182347864932)
,p_name=>'APEX.IG.NEXT.WEEK'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste Woche')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274177050452864932)
,p_name=>'APEX.IG.NEXT.X_DAYS'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste %0 Tage')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274176879620864931)
,p_name=>'APEX.IG.NEXT.X_HOURS'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste %0 Stunden')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274179029101864933)
,p_name=>'APEX.IG.NEXT.X_MINUTES'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste %0 Minuten')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274178329257864932)
,p_name=>'APEX.IG.NEXT.X_MONTHS'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste %0 Monate')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274178475149864932)
,p_name=>'APEX.IG.NEXT.X_WEEKS'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste %0 Wochen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274177411176864932)
,p_name=>'APEX.IG.NEXT.X_YEARS'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste %0 Jahre')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274177375954864932)
,p_name=>'APEX.IG.NEXT.YEAR'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chstes Jahr')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274280005740865007)
,p_name=>'APEX.IG.NOT_BETWEEN'
,p_message_language=>'de'
,p_message_text=>'nicht zwischen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274279074476865007)
,p_name=>'APEX.IG.NOT_EQUALS'
,p_message_language=>'de'
,p_message_text=>'ist nicht gleich'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274799479210865373)
,p_name=>'APEX.IG.NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Region mit ID %0 ist keine interaktive Rasterregion oder ist in Anwendung %1 nicht vorhanden.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274279440404865007)
,p_name=>'APEX.IG.NOT_IN'
,p_message_language=>'de'
,p_message_text=>'nicht in'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274280241285865008)
,p_name=>'APEX.IG.NOT_IN_THE_LAST'
,p_message_language=>'de'
,p_message_text=>'nicht in den letzten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274280476766865008)
,p_name=>'APEX.IG.NOT_IN_THE_NEXT'
,p_message_language=>'de'
,p_message_text=>unistr('nicht in den n\00E4chsten')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274304932760865025)
,p_name=>'APEX.IG.NO_DATA_FOUND'
,p_message_language=>'de'
,p_message_text=>'Keine Daten gefunden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274737816937865329)
,p_name=>'APEX.IG.NULLS'
,p_message_language=>'de'
,p_message_text=>'Nullwerte'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274747868543865336)
,p_name=>'APEX.IG.NUMBER'
,p_message_language=>'de'
,p_message_text=>'Numerisch'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274738302294865330)
,p_name=>'APEX.IG.OFF'
,p_message_language=>'de'
,p_message_text=>'Aus'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274738428660865330)
,p_name=>'APEX.IG.ON'
,p_message_language=>'de'
,p_message_text=>'Ein'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274262477055864995)
,p_name=>'APEX.IG.ONE_MINUTE_AGO'
,p_message_language=>'de'
,p_message_text=>'vor 1 Minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274755581494865342)
,p_name=>'APEX.IG.OPEN_COLORPICKER'
,p_message_language=>'de'
,p_message_text=>unistr('Farbauswahl \00F6ffnen: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274731055452865324)
,p_name=>'APEX.IG.OPEN_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('\00D6ffnen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274298127930865020)
,p_name=>'APEX.IG.OPERATOR'
,p_message_language=>'de'
,p_message_text=>'Operator'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274730494322865324)
,p_name=>'APEX.IG.ORIENTATION'
,p_message_language=>'de'
,p_message_text=>'Ausrichtung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274732845414865326)
,p_name=>'APEX.IG.PIE'
,p_message_language=>'de'
,p_message_text=>'Kreis'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274299468435865021)
,p_name=>'APEX.IG.PIVOT'
,p_message_language=>'de'
,p_message_text=>'Pivot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274037384934864832)
,p_name=>'APEX.IG.PIVOT_VIEW'
,p_message_language=>'de'
,p_message_text=>'Pivot-Ansicht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274755408919865342)
,p_name=>'APEX.IG.PLACEHOLDER_INVALUES'
,p_message_language=>'de'
,p_message_text=>'Werte durch %0 trennen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274732953940865326)
,p_name=>'APEX.IG.POLAR'
,p_message_language=>'de'
,p_message_text=>'Polar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274746715201865335)
,p_name=>'APEX.IG.POSITION_CENTER'
,p_message_language=>'de'
,p_message_text=>'Zentriert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274746893880865335)
,p_name=>'APEX.IG.POSITION_END'
,p_message_language=>'de'
,p_message_text=>'Ende'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274746675864865335)
,p_name=>'APEX.IG.POSITION_START'
,p_message_language=>'de'
,p_message_text=>'Start'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274297379491865020)
,p_name=>'APEX.IG.PRIMARY'
,p_message_language=>'de'
,p_message_text=>'Primary'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274297646464865020)
,p_name=>'APEX.IG.PRIMARY_DEFAULT'
,p_message_language=>'de'
,p_message_text=>unistr('Prim\00E4rer Standardwert')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274592669960865227)
,p_name=>'APEX.IG.PRIMARY_REPORT'
,p_message_language=>'de'
,p_message_text=>'Hauptbericht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274733002520865326)
,p_name=>'APEX.IG.RADAR'
,p_message_language=>'de'
,p_message_text=>'Radar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274733116571865326)
,p_name=>'APEX.IG.RANGE'
,p_message_language=>'de'
,p_message_text=>'Bereich'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274756908656865343)
,p_name=>'APEX.IG.REFRESH'
,p_message_language=>'de'
,p_message_text=>'Aktualisieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274305721639865026)
,p_name=>'APEX.IG.REFRESH_ROW'
,p_message_language=>'de'
,p_message_text=>'Zeile aktualisieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274304547043865025)
,p_name=>'APEX.IG.REFRESH_ROWS'
,p_message_language=>'de'
,p_message_text=>'Zeilen aktualisieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274038828224864833)
,p_name=>'APEX.IG.REMOVE_CONTROL'
,p_message_language=>'de'
,p_message_text=>'%0 entfernen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274296732946865019)
,p_name=>'APEX.IG.REPORT'
,p_message_language=>'de'
,p_message_text=>'Bericht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274790198274865366)
,p_name=>'APEX.IG.REPORT.DELETED'
,p_message_language=>'de'
,p_message_text=>unistr('Bericht gel\00F6scht')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274789850230865366)
,p_name=>'APEX.IG.REPORT.SAVED.ALTERNATIVE'
,p_message_language=>'de'
,p_message_text=>unistr('Alternativer Bericht f\00FCr alle Benutzer gespeichert')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274789749559865366)
,p_name=>'APEX.IG.REPORT.SAVED.DEFAULT'
,p_message_language=>'de'
,p_message_text=>unistr('Standardbericht f\00FCr alle Benutzer gespeichert')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274790001278865366)
,p_name=>'APEX.IG.REPORT.SAVED.PRIVATE'
,p_message_language=>'de'
,p_message_text=>'Privater Bericht gespeichert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274789972866865366)
,p_name=>'APEX.IG.REPORT.SAVED.PUBLIC'
,p_message_language=>'de'
,p_message_text=>unistr('\00D6ffentlicher Bericht f\00FCr alle Benutzer gespeichert')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274262347262864995)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF.X.MINUTES_AGO'
,p_message_language=>'de'
,p_message_text=>unistr('Bericht f\00FCr Daten erstellen - Stand vor %0 Minuten')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274262281287864995)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF_ONE_MINUTE_AGO'
,p_message_language=>'de'
,p_message_text=>unistr('Bericht f\00FCr Daten erstellen - Stand vor 1 Minute')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274761394458865346)
,p_name=>'APEX.IG.REPORT_EDIT'
,p_message_language=>'de'
,p_message_text=>'Bericht - Bearbeiten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274761296667865346)
,p_name=>'APEX.IG.REPORT_SAVE_AS'
,p_message_language=>'de'
,p_message_text=>'Bericht - Speichern unter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274038953699864834)
,p_name=>'APEX.IG.REPORT_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Berichteinstellungen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274799516919865373)
,p_name=>'APEX.IG.REPORT_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Gespeichertes interaktives Raster mit statischer ID %0 ist nicht vorhanden.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274773609662865355)
,p_name=>'APEX.IG.REPORT_VIEW'
,p_message_language=>'de'
,p_message_text=>'Berichtsansicht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274038076938864833)
,p_name=>'APEX.IG.RESET'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCcksetzen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274305810388865026)
,p_name=>'APEX.IG.REVERT_CHANGES'
,p_message_language=>'de'
,p_message_text=>unistr('\00C4nderungen wiederherstellen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274304620324865025)
,p_name=>'APEX.IG.REVERT_ROWS'
,p_message_language=>'de'
,p_message_text=>'Zeilen wiederherstellen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274297744600865020)
,p_name=>'APEX.IG.ROW'
,p_message_language=>'de'
,p_message_text=>'Zeile'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274296638852865019)
,p_name=>'APEX.IG.ROWS_PER_PAGE'
,p_message_language=>'de'
,p_message_text=>'Zeilen pro Seite'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274798176436865372)
,p_name=>'APEX.IG.ROW_ACTIONS'
,p_message_language=>'de'
,p_message_text=>'Zeilenaktionen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274805340030865377)
,p_name=>'APEX.IG.ROW_ACTIONS_FOR'
,p_message_language=>'de'
,p_message_text=>unistr('Aktionen f\00FCr Zeile %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274038392103864833)
,p_name=>'APEX.IG.SAVE'
,p_message_language=>'de'
,p_message_text=>'Speichern'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274380754920865078)
,p_name=>'APEX.IG.SAVED'
,p_message_language=>'de'
,p_message_text=>'gespeichert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274036515288864832)
,p_name=>'APEX.IG.SAVED_REPORTS'
,p_message_language=>'de'
,p_message_text=>'Gespeicherte Berichte'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274036653120864832)
,p_name=>'APEX.IG.SAVED_REPORT_DEFAULT'
,p_message_language=>'de'
,p_message_text=>'Standard'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274036776077864832)
,p_name=>'APEX.IG.SAVED_REPORT_PRIVATE'
,p_message_language=>'de'
,p_message_text=>'Privat'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274036850823864832)
,p_name=>'APEX.IG.SAVED_REPORT_PUBLIC'
,p_message_language=>'de'
,p_message_text=>unistr('\00D6ffentlich')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274773333587865354)
,p_name=>'APEX.IG.SAVE_AS'
,p_message_language=>'de'
,p_message_text=>'Speichern unter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274303940876865025)
,p_name=>'APEX.IG.SAVE_REPORT_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Berichtseinstellungen speichern'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274733254223865326)
,p_name=>'APEX.IG.SCATTER'
,p_message_language=>'de'
,p_message_text=>'Streudiagramm'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274036404046864832)
,p_name=>'APEX.IG.SEARCH'
,p_message_language=>'de'
,p_message_text=>'Suche'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274752031061865339)
,p_name=>'APEX.IG.SEARCH.ALL_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Suchen: Alle Textspalten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274036356041864832)
,p_name=>'APEX.IG.SEARCH.COLUMN'
,p_message_language=>'de'
,p_message_text=>'Suchen: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274750843855865338)
,p_name=>'APEX.IG.SEARCH.ORACLE_TEXT'
,p_message_language=>'de'
,p_message_text=>'Suche: Volltextsuche'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274262122544864995)
,p_name=>'APEX.IG.SEARCH_FOR.X'
,p_message_language=>'de'
,p_message_text=>'Nach ''%0'' suchen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274726750724865321)
,p_name=>'APEX.IG.SELECT'
,p_message_language=>'de'
,p_message_text=>unistr('- Ausw\00E4hlen -')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274100926523864878)
,p_name=>'APEX.IG.SELECTION'
,p_message_language=>'de'
,p_message_text=>'Auswahl'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274699502774865302)
,p_name=>'APEX.IG.SELECT_1_ROW_IN_MASTER'
,p_message_language=>'de'
,p_message_text=>unistr('1 Zeile in der Masterregion ausw\00E4hlen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274036244037864832)
,p_name=>'APEX.IG.SELECT_COLUMNS_TO_SEARCH'
,p_message_language=>'de'
,p_message_text=>unistr('Zu suchende Spalten ausw\00E4hlen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274797143475865371)
,p_name=>'APEX.IG.SEL_ACTIONS'
,p_message_language=>'de'
,p_message_text=>'Auswahlaktionen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274101109506864878)
,p_name=>'APEX.IG.SEL_MODE_CELL'
,p_message_language=>'de'
,p_message_text=>'Zellenauswahl'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274101036455864878)
,p_name=>'APEX.IG.SEL_MODE_ROW'
,p_message_language=>'de'
,p_message_text=>'Zeilenauswahl'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274752654448865340)
,p_name=>'APEX.IG.SEND_AS_EMAIL'
,p_message_language=>'de'
,p_message_text=>'Als E-Mail senden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274736110421865328)
,p_name=>'APEX.IG.SERIES_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Reihe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273997159191864804)
,p_name=>'APEX.IG.SHOW'
,p_message_language=>'de'
,p_message_text=>'Anzeigen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274612034907865241)
,p_name=>'APEX.IG.SHOW_OVERALL_VALUE'
,p_message_language=>'de'
,p_message_text=>'Gesamtwert anzeigen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274305461737865026)
,p_name=>'APEX.IG.SINGLE_ROW_VIEW'
,p_message_language=>'de'
,p_message_text=>'Single Row-Ansicht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274299651599865021)
,p_name=>'APEX.IG.SORT'
,p_message_language=>'de'
,p_message_text=>'Sortierung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274736206468865328)
,p_name=>'APEX.IG.SORT_BY'
,p_message_language=>'de'
,p_message_text=>'Sortieren nach'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274798205774865372)
,p_name=>'APEX.IG.SORT_ONLY_ONE_PER_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Nur eine Sortierung pro Spalte zul\00E4ssig.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274797351043865371)
,p_name=>'APEX.IG.SRV_CHANGE_MENU'
,p_message_language=>'de'
,p_message_text=>unistr('Men\00FC \00E4ndern')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274738561615865330)
,p_name=>'APEX.IG.STACK'
,p_message_language=>'de'
,p_message_text=>'Stapel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274280714008865008)
,p_name=>'APEX.IG.STARTS_WITH'
,p_message_language=>'de'
,p_message_text=>'beginnt mit'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274733398603865326)
,p_name=>'APEX.IG.STOCK'
,p_message_language=>'de'
,p_message_text=>'Aktien'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273925889889864742)
,p_name=>'APEX.IG.STRETCH_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Spaltenbreiten dehnen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274304144105865025)
,p_name=>'APEX.IG.SUBSCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Subscription'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274644646799865264)
,p_name=>'APEX.IG.SUM'
,p_message_language=>'de'
,p_message_text=>'Summe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274805508715865377)
,p_name=>'APEX.IG.SUMMARY'
,p_message_language=>'de'
,p_message_text=>'Interaktives Grid. Bericht: %0, Ansicht: %1.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274773740457865355)
,p_name=>'APEX.IG.SUM_OVERALL'
,p_message_language=>'de'
,p_message_text=>'Gesamtsumme'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274731577004865325)
,p_name=>'APEX.IG.TARGET_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Ziel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274745967635865335)
,p_name=>'APEX.IG.TEXT_COLOR'
,p_message_language=>'de'
,p_message_text=>'Textfarbe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274039026388864834)
,p_name=>'APEX.IG.TOGGLE'
,p_message_language=>'de'
,p_message_text=>'Ein-/ausschalten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274611915104865241)
,p_name=>'APEX.IG.TOOLTIP'
,p_message_language=>'de'
,p_message_text=>'QuickInfo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274296832931865019)
,p_name=>'APEX.IG.TYPE'
,p_message_language=>'de'
,p_message_text=>'Typ'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274305319041865026)
,p_name=>'APEX.IG.UNFREEZE'
,p_message_language=>'de'
,p_message_text=>'Fixierung aufheben'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274298376286865020)
,p_name=>'APEX.IG.UNIT'
,p_message_language=>'de'
,p_message_text=>'Einheit'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274752481816865339)
,p_name=>'APEX.IG.UNSAVED_CHANGES_CONTINUE_CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('Es sind nicht gespeicherte \00C4nderungen vorhanden. M\00F6chten Sie fortfahren?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274298263697865020)
,p_name=>'APEX.IG.VALUE'
,p_message_language=>'de'
,p_message_text=>'Wert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274730606669865324)
,p_name=>'APEX.IG.VALUE_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Wert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274739623141865330)
,p_name=>'APEX.IG.VALUE_REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Ein Wert ist erforderlich.'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274684152384865291)
,p_name=>'APEX.IG.VALUE_TIMESTAMP_TZ'
,p_message_language=>'de'
,p_message_text=>unistr('Wert (Zeitzone darf nicht ge\00E4ndert werden)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274747996009865336)
,p_name=>'APEX.IG.VARCHAR2'
,p_message_language=>'de'
,p_message_text=>'Text'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274731934608865325)
,p_name=>'APEX.IG.VERTICAL'
,p_message_language=>'de'
,p_message_text=>'Vertikal'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274296369650865019)
,p_name=>'APEX.IG.VIEW'
,p_message_language=>'de'
,p_message_text=>'Anzeigen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274726808723865321)
,p_name=>'APEX.IG.VISIBLE'
,p_message_language=>'de'
,p_message_text=>'Angezeigt'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274731405369865325)
,p_name=>'APEX.IG.VOLUME_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Volumen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274281776250865009)
,p_name=>'APEX.IG.WEEKS'
,p_message_language=>'de'
,p_message_text=>'Wochen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274726945143865322)
,p_name=>'APEX.IG.WIDTH'
,p_message_language=>'de'
,p_message_text=>'Minimale Spaltenbreite (Pixel)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274211912022864956)
,p_name=>'APEX.IG.X.BETWEEN.Y.AND.Z'
,p_message_language=>'de'
,p_message_text=>'%0 zwischen %1 und %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274211685778864956)
,p_name=>'APEX.IG.X.CONTAINS.Y'
,p_message_language=>'de'
,p_message_text=>unistr('%0 enth\00E4lt %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274211782336864956)
,p_name=>'APEX.IG.X.DOES_NOT_CONTAIN.Y'
,p_message_language=>'de'
,p_message_text=>unistr('%0 enth\00E4lt nicht %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273993321660864801)
,p_name=>'APEX.IG.X.DOES_NOT_START_WITH.Y'
,p_message_language=>'de'
,p_message_text=>'%0 beginnt nicht mit %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274210433858864955)
,p_name=>'APEX.IG.X.EQUALS.Y'
,p_message_language=>'de'
,p_message_text=>'%0 gleich %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274210676060864955)
,p_name=>'APEX.IG.X.GREATER_THAN.Y'
,p_message_language=>'de'
,p_message_text=>unistr('%0 gr\00F6\00DFer als %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274210745399864955)
,p_name=>'APEX.IG.X.GREATER_THAN_OR_EQUALS.Y'
,p_message_language=>'de'
,p_message_text=>unistr('%0 gr\00F6\00DFer als oder gleich %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274211440608864956)
,p_name=>'APEX.IG.X.IN.Y'
,p_message_language=>'de'
,p_message_text=>'%0 in %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274212671948864956)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.DAYS'
,p_message_language=>'de'
,p_message_text=>'%0 in den letzten %1  Tagen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274212418468864956)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.HOURS'
,p_message_language=>'de'
,p_message_text=>'%0 in den letzten %1 Stunden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274212238852864956)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MINUTES'
,p_message_language=>'de'
,p_message_text=>'%0 in den letzten %1 Minuten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274213007873864957)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MONTHS'
,p_message_language=>'de'
,p_message_text=>'%0 in den letzten %1 Monaten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274212899642864957)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.WEEKS'
,p_message_language=>'de'
,p_message_text=>'%0 in den letzten %1  Wochen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274213281320864957)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.YEARS'
,p_message_language=>'de'
,p_message_text=>'%0 in den letzten %1 Jahren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274212545790864956)
,p_name=>'APEX.IG.X.IN_THE_LAST_DAY'
,p_message_language=>'de'
,p_message_text=>'%0 am letzten Tag'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274212315138864956)
,p_name=>'APEX.IG.X.IN_THE_LAST_HOUR'
,p_message_language=>'de'
,p_message_text=>'%0 in der letzten Stunde'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274212186431864956)
,p_name=>'APEX.IG.X.IN_THE_LAST_MINUTE'
,p_message_language=>'de'
,p_message_text=>'%0 in der letzten Minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274212901326864957)
,p_name=>'APEX.IG.X.IN_THE_LAST_MONTH'
,p_message_language=>'de'
,p_message_text=>'%0 im letzten Monat'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274212766932864957)
,p_name=>'APEX.IG.X.IN_THE_LAST_WEEK'
,p_message_language=>'de'
,p_message_text=>'%0 in der letzten  Woche'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274213138919864957)
,p_name=>'APEX.IG.X.IN_THE_LAST_YEAR'
,p_message_language=>'de'
,p_message_text=>'%0 im letzten Jahr'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274215076965864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.DAYS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 in den n\00E4chsten %1 Tagen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274214861685864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.HOURS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 in den n\00E4chsten %1 Stunden')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274214681433864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'de'
,p_message_text=>unistr('%0 in den n\00E4chsten %1 Minuten')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274215470155864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 in den n\00E4chsten %1 Monaten')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274215296407864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 in den n\00E4chsten %1 Wochen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274215675741864959)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.YEARS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 in den n\00E4chsten %1 Jahren')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274214953681864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT_DAY'
,p_message_language=>'de'
,p_message_text=>unistr('%0 am n\00E4chsten Tag')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274214749360864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT_HOUR'
,p_message_language=>'de'
,p_message_text=>unistr('%0 in der n\00E4chsten Stunde')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274214550603864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MINUTE'
,p_message_language=>'de'
,p_message_text=>unistr('%0 in der n\00E4chsten Minute')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274215314963864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MONTH'
,p_message_language=>'de'
,p_message_text=>unistr('%0 im n\00E4chsten Monat')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274215114106864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT_WEEK'
,p_message_language=>'de'
,p_message_text=>unistr('%0 in der n\00E4chsten Woche')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274215556555864958)
,p_name=>'APEX.IG.X.IN_THE_NEXT_YEAR'
,p_message_language=>'de'
,p_message_text=>unistr('%0 im n\00E4chsten Jahr')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274211190101864955)
,p_name=>'APEX.IG.X.IS_NOT_NULL'
,p_message_language=>'de'
,p_message_text=>'%0 ist nicht leer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274211085692864955)
,p_name=>'APEX.IG.X.IS_NULL'
,p_message_language=>'de'
,p_message_text=>'%0 ist leer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274210834305864955)
,p_name=>'APEX.IG.X.LESS_THAN.Y'
,p_message_language=>'de'
,p_message_text=>'%0 kleiner als %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274210962569864955)
,p_name=>'APEX.IG.X.LESS_THAN_OR_EQUALS.Y'
,p_message_language=>'de'
,p_message_text=>'%0 kleiner als oder gleich %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274211290281864955)
,p_name=>'APEX.IG.X.LIKE.Y'
,p_message_language=>'de'
,p_message_text=>'%0 wie %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274211848202864956)
,p_name=>'APEX.IG.X.MATCHES_REGULAR_EXPRESSION.Y'
,p_message_language=>'de'
,p_message_text=>unistr('%0 entspricht regul\00E4rem Ausdruck %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274262591897864995)
,p_name=>'APEX.IG.X.MINUTES_AGO'
,p_message_language=>'de'
,p_message_text=>'vor %0 Minuten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274212029187864956)
,p_name=>'APEX.IG.X.NOT_BETWEEN.Y.AND.Z'
,p_message_language=>'de'
,p_message_text=>'%0 nicht zwischen %1  und %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274210574341864955)
,p_name=>'APEX.IG.X.NOT_EQUALS.Y'
,p_message_language=>'de'
,p_message_text=>'%0 nicht gleich %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274211513287864956)
,p_name=>'APEX.IG.X.NOT_IN.Y'
,p_message_language=>'de'
,p_message_text=>'%0 nicht in %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274213884836864957)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.DAYS'
,p_message_language=>'de'
,p_message_text=>'%0 nicht an den letzten %1 Tagen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274213691470864957)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.HOURS'
,p_message_language=>'de'
,p_message_text=>'%0 nicht in den letzten %1 Stunden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274213441608864957)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MINUTES'
,p_message_language=>'de'
,p_message_text=>'%0 nicht in den letzten %1 Minuten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274214254609864958)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MONTHS'
,p_message_language=>'de'
,p_message_text=>'%0 nicht in den letzten %1 Monaten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274214078050864957)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.WEEKS'
,p_message_language=>'de'
,p_message_text=>'%0 nicht in den letzten %1 Wochen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274214451776864958)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.YEARS'
,p_message_language=>'de'
,p_message_text=>'%0 nicht in den letzten %1 Jahren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274213755042864957)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_DAY'
,p_message_language=>'de'
,p_message_text=>'%0 nicht am letzten Tag'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274213548368864957)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_HOUR'
,p_message_language=>'de'
,p_message_text=>'%0 nicht in der letzten Stunde'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274213360591864957)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MINUTE'
,p_message_language=>'de'
,p_message_text=>'%0 nicht in der letzten Minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274214119728864958)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MONTH'
,p_message_language=>'de'
,p_message_text=>'%0 nicht im letzten Monat'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274213914462864957)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_WEEK'
,p_message_language=>'de'
,p_message_text=>'%0 nicht in der letzten Woche'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274214359910864958)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_YEAR'
,p_message_language=>'de'
,p_message_text=>'%0 nicht im letzten Jahr'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274216265914864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.DAYS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht in den n\00E4chsten %1 Tagen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274216026888864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.HOURS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht in den n\00E4chsten %1 Stunden')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274215840168864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht in den n\00E4chsten %1 Minuten')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274216644401864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht in den n\00E4chsten %1 Monaten')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274216467336864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht in den n\00E4chsten %1 Wochen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274216886797864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.YEARS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht in den n\00E4chsten %1 Jahren')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274216157817864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_DAY'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht am n\00E4chsten Tag')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274215997649864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_HOUR'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht in der n\00E4chsten Stunde')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274215784975864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MINUTE'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht in der n\00E4chsten Minute')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274216531617864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MONTH'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht im n\00E4chsten Monat')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274216376521864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_WEEK'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht in der n\00E4chsten Woche')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274216752378864959)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_YEAR'
,p_message_language=>'de'
,p_message_text=>unistr('%0 nicht im n\00E4chsten Jahr')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274211303116864956)
,p_name=>'APEX.IG.X.NOT_LIKE.Y'
,p_message_language=>'de'
,p_message_text=>'%0 nicht wie %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274272427453865002)
,p_name=>'APEX.IG.X.STARTS_WITH.Y'
,p_message_language=>'de'
,p_message_text=>'%0 beginnt mit %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274730708488865324)
,p_name=>'APEX.IG.X_COLUMN'
,p_message_language=>'de'
,p_message_text=>'X'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274281972277865009)
,p_name=>'APEX.IG.YEARS'
,p_message_language=>'de'
,p_message_text=>'Jahren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274730894316865324)
,p_name=>'APEX.IG.Y_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Y'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274730961768865324)
,p_name=>'APEX.IG.Z_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Z'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274751422373865339)
,p_name=>'APEX.IG_FORMAT_SAMPLE_1'
,p_message_language=>'de'
,p_message_text=>'Montag, 12. Januar 2016'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274751591065865339)
,p_name=>'APEX.IG_FORMAT_SAMPLE_2'
,p_message_language=>'de'
,p_message_text=>'Januar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274751681311865339)
,p_name=>'APEX.IG_FORMAT_SAMPLE_3'
,p_message_language=>'de'
,p_message_text=>'vor 16 Stunden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274751731238865339)
,p_name=>'APEX.IG_FORMAT_SAMPLE_4'
,p_message_language=>'de'
,p_message_text=>'in 16 Std.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273607535949864520)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_language=>'de'
,p_message_text=>unistr('Die Druckunterst\00FCtzung muss entweder STANDARD oder ERWEITERT sein')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273607646625864520)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_language=>'de'
,p_message_text=>'Das erste bereitgestellte Schema kann nicht entfernt werden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273496467299864446)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige Anwendungs-ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274034429300864830)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige E-Mail-Adresse')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273477583764864434)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_language=>'de'
,p_message_text=>'Der Wert muss null oder eine positive Ganzzahl sein.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273607771326864520)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige Portnummer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274070280652864856)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige Abonnement-ID.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273607819230864520)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_language=>'de'
,p_message_text=>'Der Wallet-Pfad muss in der Form-Datei sein:<filesystempath>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273699213251864582)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_language=>'de'
,p_message_text=>'Der Workspace wurde nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273699156839864582)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige Workspace-ID.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273626792025864533)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_language=>'de'
,p_message_text=>unistr('Der Wert "%1" von Instanzparameter "%0" entspricht nicht dem regul\00E4ren Ausdruck "%2"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273626611488864533)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Der Instanzparameter "%0" muss einen Wert enthalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273607935633864521)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_language=>'de'
,p_message_text=>'Instanzparameter nicht gefunden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274065831234864853)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_language=>'de'
,p_message_text=>'Kennwort'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273431201138864402)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_language=>'de'
,p_message_text=>unistr('Gruppen (nur f\00FCr Authentifizierung mit Workspace-Benutzeraccount-Repository)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274351379681865058)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_language=>'de'
,p_message_text=>unistr('Gruppen (nur f\00FCr Authentifizierung mit Workspace-Benutzeraccount-Repository)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274172829242864929)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_language=>'de'
,p_message_text=>unistr('Gruppen (nur f\00FCr Authentifizierung mit Workspace-Benutzeraccount-Repository)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273753097143864620)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_language=>'de'
,p_message_text=>unistr('Gruppen (nur f\00FCr Authentifizierung mit Workspace-Benutzeraccount-Repository)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274065740985864852)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_language=>'de'
,p_message_text=>unistr('Gruppen (nur f\00FCr Authentifizierung mit Workspace-Benutzeraccount-Repository)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273609890211864522)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_language=>'de'
,p_message_text=>'Das Druckserverprotokoll muss entweder HTTP oder HTTPS sein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273609963443864522)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Das Schema ist nicht vorhanden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273610018655864522)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_language=>'de'
,p_message_text=>unistr('Das Schema ist eingeschr\00E4nkt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273456179592864419)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273455903796864419)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Anwendung nicht mehr vorhanden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274400568279865092)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_language=>'de'
,p_message_text=>'Zuweisen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274680810135865289)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_language=>'de'
,p_message_text=>'Karten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273458002043864420)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_language=>'de'
,p_message_text=>'Kommentiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273457928403864420)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_language=>'de'
,p_message_text=>'Kommentare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273432714067864403)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273432544052864403)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('M\00F6chten Sie diesen Kommentar wirklich l\00F6schen?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274384909579865081)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_language=>'de'
,p_message_text=>unistr('Vorgang l\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273442355513864410)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('M\00F6chten Sie diesen Vorgang wirklich l\00F6schen?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273459656044864421)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_language=>'de'
,p_message_text=>'Dokument'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273458518731864421)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_language=>'de'
,p_message_text=>'Dokumente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273432643607864403)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_language=>'de'
,p_message_text=>'Bearbeiten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274608410188865238)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_language=>'de'
,p_message_text=>'Kommentar bearbeiten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274608524092865238)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_language=>'de'
,p_message_text=>'Vorgang bearbeiten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273456767301864420)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Die angegebene Anwendung ist in diesem Workspace nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273457177398864420)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler beim Versuch, den Kommentar zu l\00F6schen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273457038753864420)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Kommentar nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273457318236864420)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Vorgang nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273457488337864420)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler beim Versuch, den Vorgang zum L\00F6schen zu markieren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273456806922864420)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Die angegebene Seite ist in diesem Workspace oder in der angegebenen Anwendung nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273457272031864420)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzer ist nicht autorisiert, diesen Kommentar zu l\00F6schen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273457561744864420)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzer ist nicht autorisiert, diesen Vorgang zu l\00F6schen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273456971721864420)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzer ist nicht autorisiert, die Sichtbarkeit dieses Kommentars zu \00E4ndern.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274617332118865244)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Beim Pr\00FCfen der Dateigr\00F6\00DFen ist ein Problem aufgetreten. Wenden Sie sich an den Systemadministrator.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274617219136865244)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_language=>'de'
,p_message_text=>unistr('Eine dieser Dateien \00FCberschreitet die maximale Dateigr\00F6\00DFe von %0 Byte.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274617162900865244)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Datei \00FCberschreitet die maximale Dateigr\00F6\00DFe von %0 Byte.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273432888567864403)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_language=>'de'
,p_message_text=>'Ausblenden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273459490102864421)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_language=>'de'
,p_message_text=>'Bild'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273458336919864421)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_language=>'de'
,p_message_text=>'Bilder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273455753598864419)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Vorgang, der nicht im System gefunden wurde'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273416407043864392)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_language=>'de'
,p_message_text=>unistr('Voreinstellung f\00FCr Benutzer hinzuf\00FCgen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273458188544864420)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_language=>'de'
,p_message_text=>unistr('Dateien anh\00E4ngen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273457818419864420)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_language=>'de'
,p_message_text=>'Geschlossen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274686419519865293)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCberschrift')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273459104598864421)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_language=>'de'
,p_message_text=>'ist leer.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273458975477864421)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_language=>'de'
,p_message_text=>'Eine dieser Dateien ist'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273457734006864420)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_language=>'de'
,p_message_text=>unistr('\00D6ffnen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273460244969864422)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_language=>'de'
,p_message_text=>unistr('Auswahl dauerhaft l\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274385850382865082)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_language=>'de'
,p_message_text=>unistr('Alle l\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273460198540864422)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_language=>'de'
,p_message_text=>'Auswahl wiederherstellen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273458278693864421)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_language=>'de'
,p_message_text=>'Antwortvorlagen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273459005088864421)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_language=>'de'
,p_message_text=>unistr('zu gro\00DF zum Hochladen. <br>Dateien m\00FCssen kleiner sein als')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273459383005864421)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_language=>'de'
,p_message_text=>unistr('Unterst\00FCtzte Dateitypen: ')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274612318072865241)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('W\00E4hlen Sie ein Antworttemplate aus')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273458816518864421)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_language=>'de'
,p_message_text=>'Diese Datei ist'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273459235970864421)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_language=>'de'
,p_message_text=>unistr('kein unterst\00FCtzter Dateityp.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274324699136865039)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_language=>'de'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274325210444865039)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_language=>'de'
,p_message_text=>'Dokumentationsvorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274324787633865039)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_language=>'de'
,p_message_text=>'Erweiterungsanforderung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274324823542865039)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_language=>'de'
,p_message_text=>'Featureanforderung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274325117556865039)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_language=>'de'
,p_message_text=>'Installationsvorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274325053132865039)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_language=>'de'
,p_message_text=>'Performancevorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274324938684865039)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_language=>'de'
,p_message_text=>'Sicherheitsvorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274325313132865040)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_language=>'de'
,p_message_text=>'Schulungsvorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274326091915865040)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_language=>'de'
,p_message_text=>'Administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274325722712865040)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_language=>'de'
,p_message_text=>'CSS / HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274325855939865040)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_language=>'de'
,p_message_text=>'Dynamische Aktionen/JavaScript'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274325522964865040)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_language=>'de'
,p_message_text=>'Datenbank'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274326154708865040)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_language=>'de'
,p_message_text=>'Externe Systemintegration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274325613677865040)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_language=>'de'
,p_message_text=>'REST-Integration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274325961407865040)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_language=>'de'
,p_message_text=>'Sicherheit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274325426861865040)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_language=>'de'
,p_message_text=>'UI / UX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274324599155865039)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_language=>'de'
,p_message_text=>'Kategorie, die dem Vorgang zugewiesen wird.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274323677957865038)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_language=>'de'
,p_message_text=>'Kategorie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274324444552865039)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_language=>'de'
,p_message_text=>'Funktionsbereich, der von dem Vorgang betroffen ist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274323710206865038)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_language=>'de'
,p_message_text=>'Funktionsbereich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274324375348865039)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_language=>'de'
,p_message_text=>'Wichtigkeit, die dem Vorgang beigemessen wird.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274323840343865039)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_language=>'de'
,p_message_text=>'Wichtigkeit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274324250688865039)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_language=>'de'
,p_message_text=>'Mit dem Vorgang verbundener Aufwand.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274323999977865039)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_language=>'de'
,p_message_text=>'Aufwand'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274324187468865039)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_language=>'de'
,p_message_text=>'Fortschritt in Bezug auf den Vorgang.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274324067030865039)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_language=>'de'
,p_message_text=>'Fortschritt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274326559359865040)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_language=>'de'
,p_message_text=>'Backlog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274326287163865040)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_language=>'de'
,p_message_text=>'Kritisch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274326336011865040)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_language=>'de'
,p_message_text=>'Wichtig'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274326443398865040)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_language=>'de'
,p_message_text=>'Normal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274326620641865040)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_language=>'de'
,p_message_text=>'Wird nicht behoben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274326794061865041)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_language=>'de'
,p_message_text=>'Einfacher Fix'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274326933996865041)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_language=>'de'
,p_message_text=>unistr('Gro\00DFer Entwicklungsaufwand')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274326820195865041)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_language=>'de'
,p_message_text=>unistr('M\00E4\00DFiger Aufwand')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274327350829865041)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_language=>'de'
,p_message_text=>'Kann nicht behoben werden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274327417421865041)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_language=>'de'
,p_message_text=>'Abgeschlossen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274327157504865041)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_language=>'de'
,p_message_text=>'Weitere Info erforderlich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274327267949865041)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_language=>'de'
,p_message_text=>'Warten auf Drittanbieter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274327026657865041)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_language=>'de'
,p_message_text=>'In Bearbeitung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274337748606865048)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Labelgruppe kann nicht gel\00F6scht werden, weil mindestens eines der zugeh\00F6rigen Mitglieder einem Vorgang zugewiesen ist.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273457672753864420)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_language=>'de'
,p_message_text=>'Markiert als Duplikat von'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274385332062865082)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_language=>'de'
,p_message_text=>'Beauftragte'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274385289304865082)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_language=>'de'
,p_message_text=>'Labels'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274385745552865082)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_language=>'de'
,p_message_text=>'Meilensteine'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274385189850865081)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_language=>'de'
,p_message_text=>'Status'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273455543836864419)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_language=>'de'
,p_message_text=>'Meilensteine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274328081814865041)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_language=>'de'
,p_message_text=>'Codesperrung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274328286873865042)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_language=>'de'
,p_message_text=>unistr('Endg\00FCltiges Release')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274328172875865042)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_language=>'de'
,p_message_text=>'UI-Sperrung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273460098110864422)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_language=>'de'
,p_message_text=>unistr('%0 hat %2 einen Kommentar zu %1 hinzugef\00FCgt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273416164739864392)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_language=>'de'
,p_message_text=>unistr('hat sich ge\00E4ndert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274341949881865051)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_language=>'de'
,p_message_text=>unistr('Vorgangsnummer %0 in Workspace %1 wurde ge\00E4ndert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274617040786865244)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_language=>'de'
,p_message_text=>'Es wurden keine Labels definiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273458755720864421)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_language=>'de'
,p_message_text=>'Weitere'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273456258080864419)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273456033956864419)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Seite nicht mehr vorhanden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274678327414865287)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_language=>'de'
,p_message_text=>unistr('Alle l\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274400687548865092)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_language=>'de'
,p_message_text=>'Entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273455818643864419)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_language=>'de'
,p_message_text=>unistr('Anwendungs- und Seitenverkn\00FCpfung entfernt von')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273456598938864419)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_language=>'de'
,p_message_text=>'Anhang entfernt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274652198589865269)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('M\00F6chten Sie Ihren aktuellen Kommentar durch dieses Template ersetzen?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274654158620865270)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hallo, ',
'',
unistr('Sie haben Ihren allerersten Vorgang erstellt. Sie k\00F6nnen Vorg\00E4nge erstellen, um Aufgaben, Features, Bugs und Feedback f\00FCr alle APEX-Projekte zu verfolgen. Sie k\00F6nnen Vorg\00E4ngen Labels und Beauftragte hinzuf\00FCgen, Meilensteine festlegen und sogar Format')
||unistr('ierungen mit Markdown-K\00FCrzeln anwenden.  '),
'',
unistr('Nachfolgend finden Sie ein kurzes Beispiel f\00FCr die Verwendung von Markdown:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274654091427865270)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_language=>'de'
,p_message_text=>'Willkommen bei Team Development in Oracle APEX.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274400924708865093)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_language=>'de'
,p_message_text=>unistr('- Ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273456623647864419)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_language=>'de'
,p_message_text=>' Status festlegen auf'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273433075115864404)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_language=>'de'
,p_message_text=>'Aktionen anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274653921517865270)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_language=>'de'
,p_message_text=>'Mehr anzeigen...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273456357268864419)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_language=>'de'
,p_message_text=>'Abonniert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274617440965865244)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr %0 in Workspace %1 liegen %2 neue Benachrichtigungen vor.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274321161068865037)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_language=>'de'
,p_message_text=>'Template, das zum Loggen eines Bugs verwendet wird.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274321079364865037)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_language=>'de'
,p_message_text=>'Bugtemplate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274320948084865037)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Erwartetes Verhalten**',
'- Geben Sie an, was Ihrer Meinung nach geschehen soll.',
'',
'',
'**Aktuelles Verhalten**',
'- Geben Sie an, was geschieht.',
'',
'',
'**Wer ist betroffen**',
'- Geben Sie an, wer/was betroffen ist. ',
'',
unistr('**M\00F6gliche L\00F6sung**'),
unistr('- Falls m\00F6glich, geben Sie eine Empfehlung zur Korrektur dieses Bugs.'),
'',
'**Schritte zur Reproduktion**',
unistr('- Geben Sie eindeutige Schritte zur Reproduktion des Bugs an, einschlie\00DFlich Screenshots und Code-Snippets, falls zutreffend.'),
'1.',
'2.',
'3.',
'',
'**Kontext**',
'- Was wollten Sie gerade erreichen, als der Bug auftrat. Tritt der Bug nur unter bestimmten Bedingungen oder zu bestimmten Tageszeiten usw. auf.',
'',
'**Umgebung**',
'',
'- Version: ',
'- Plattform: ',
'- Subsystem:',
'',
'______',
'',
unistr('_**HINWEIS:** Um einen Vorgang mit einer Anwendung und/oder Seite zu verkn\00FCpfen, loggen Sie zuerst den Vorgang. Verkn\00FCpfen Sie anschlie\00DFend Anwendung und Seite \00FCber das Dropdown-Listenfeld **AKTIONEN**._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274322208316865037)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_language=>'de'
,p_message_text=>'Ein Bug wurde gemeldet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274322105246865037)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_language=>'de'
,p_message_text=>'Bug gemeldet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274322385549865037)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Ein **Bug** wurde im entsprechenden externen System erfasst.',
'',
'- Bugtrackingsystem: ',
'- Bug-ID: ',
'- URL zu Bug: ',
'',
'Kommentare:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274321393497865037)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_language=>'de'
,p_message_text=>'Template, das zum Loggen einer Featureanforderung verwendet wird.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274321235878865037)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_language=>'de'
,p_message_text=>'Featureanforderungstemplate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274321473804865037)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**Feature\00FCbersicht**'),
unistr(' - Geben Sie in einem Absatz eine allgemeine \00DCbersicht \00FCber die Featureanforderung an.'),
'',
'',
'**Kontext**',
' - Bezieht sich diese Anforderung auf eine bestimmte Situation oder einen bestimmten Prozess? Beispiel: "Ich bin immer frustriert, wenn [...]"',
'',
'',
unistr(' - Geben Sie Zusatzinformationen an, einschlie\00DFlich Screenshots, Anwendungsf\00E4lle usw.'),
'',
'',
unistr('**Bevorzugte L\00F6sung**'),
unistr('- Geben Sie eine klare Beschreibung der gew\00FCnschten Implementierungen an.'),
'',
'',
unistr('**Alternative L\00F6sungen**'),
unistr('- Geben Sie eine Beschreibung in Erw\00E4gung gezogener alternativer L\00F6sungen oder Features bzw. verwendeter Workarounds an.'),
'',
'',
'______',
unistr('_**HINWEIS:** Um einen Vorgang mit einer Anwendung und/oder Seite zu verkn\00FCpfen, loggen Sie zuerst den Vorgang. Verkn\00FCpfen Sie anschlie\00DFend Anwendung und Seite \00FCber das Dropdown-Listenfeld **AKTIONEN**._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274322544129865038)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_language=>'de'
,p_message_text=>'Eine Featureanforderung wurde erfasst.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274322492738865038)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_language=>'de'
,p_message_text=>'Featureanforderung erfasst'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274322617877865038)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Eine **Featureanforderung** wurde im entsprechenden externen System erfasst.',
'',
'- Featuretrackingsystem: ',
'- Feature-ID: ',
'- URL zu Featuredefinition: ',
'',
'Kommentare:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274323409742865038)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Es ist eine Folgema\00DFnahme erforderlich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274323357103865038)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Folgema\00DFnahme erforderlich')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274323594875865038)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('F\00FChren Sie folgende Ma\00DFnahmen aus: '),
'',
'1.',
'2.',
'3.',
'4.',
'',
'Kommentare: '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274321636825865037)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_language=>'de'
,p_message_text=>'Template, das zum Stellen einer prozeduralen Frage verwendet wird.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274321588572865037)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_language=>'de'
,p_message_text=>'Anleitungen ...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274321707291865037)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Frage**',
unistr('- Geben Sie Ihre Frage oder Anforderung so eindeutig wie m\00F6glich an.'),
'',
'**Allgemeiner Kontext**',
'- Was versuchen Sie zu erreichen? ',
'',
'',
'- Wo haben Sie sonst noch nach Antworten gesucht, bzw. wen haben Sie sonst noch kontaktiert, um eine Antwort zu erhalten? ',
'',
'',
'**Umgebung** ',
'Bezieht sich diese Frage auf eine bestimmte Umgebung, Programmiersprache oder auf einen bestimmten anderen Bereich?',
'',
'______',
unistr('_**HINWEIS:** Um einen Vorgangmit einer Anwendung und/oder Seite zu verkn\00FCpfen, loggen Sie zuerst den Vorgang. Verkn\00FCpfen Sie anschlie\00DFend Anwendung und Seite \00FCber das Dropdown-Listenfeld **AKTIONEN**._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274323151221865038)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_language=>'de'
,p_message_text=>'Referenzieren Sie ein bekanntes Problem.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274323070478865038)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_language=>'de'
,p_message_text=>'Bekanntes Problem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274323209233865038)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Die Pr\00FCfung hat ergeben, dass es sich um ein bekanntes Problem handelt (siehe Details unten).'),
'',
'- Bugtrackingsystem: ',
'- Bug-ID: ',
'- URL zu Bug: ',
'',
'Kommentare: '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274322898812865038)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_language=>'de'
,p_message_text=>'Anforderung weiterer Informationen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274322758236865038)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_language=>'de'
,p_message_text=>'Weitere Informationen erforderlich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274322978721865038)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Zu diesem Vorgang sind weitere Informationen erforderlich:**',
'',
'Geben Sie die angeforderten Informationen unten ein. Ohne diese Informationen ist es schwierig, den Vorgang einzuordnen und weiter zu bearbeiten.',
'',
'',
'Kommentare:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274321952011865037)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Bei diesem Vorgang wird keine Ma\00DFnahme ergriffen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274321892187865037)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Keine Ma\00DFnahme')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274322024981865037)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Nach sorgf\00E4ltiger Pr\00FCfung **wird keine weitere Ma\00DFnahme bez\00FCglich dieses Vorgangs ergriffen**. '),
'',
'Kommentare:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273459781148864422)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_language=>'de'
,p_message_text=>'Textdatei'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273458644831864421)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_language=>'de'
,p_message_text=>'Textdateien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273455492689864419)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_language=>'de'
,p_message_text=>'dieser Vorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274343025816865052)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_language=>'de'
,p_message_text=>unistr('hat Anhang %0 %2 zu %1 hinzugef\00FCgt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274342035329865051)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_language=>'de'
,p_message_text=>unistr('hat %0 %2 zu %1 hinzugef\00FCgt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274343694698865052)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_language=>'de'
,p_message_text=>unistr('hat %0 %2 zu %1 hinzugef\00FCgt				')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274342223053865051)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_language=>'de'
,p_message_text=>'hat %0 %2 zu %1 zugewiesen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274342618907865052)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_language=>'de'
,p_message_text=>unistr('hat %0 %2 mit %1 verkn\00FCpft')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273459982911864422)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_language=>'de'
,p_message_text=>unistr('hat einen Kommentar bearbeitet f\00FCr %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274343587370865052)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_language=>'de'
,p_message_text=>'Der Vorgang wurde ausgeblendet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274342432845865051)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_language=>'de'
,p_message_text=>'hat %0 %2 als Duplikat von %1 markiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274343424674865052)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_language=>'de'
,p_message_text=>unistr('%0 wurde ge\00F6ffnet von')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274343165409865052)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_language=>'de'
,p_message_text=>'hat den Anhang %0 %2 aus %1 entfernt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274342130712865051)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_language=>'de'
,p_message_text=>'hat %0 %2 aus %1 entfernt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274343707963865052)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_language=>'de'
,p_message_text=>'hat %0 %2 aus %1 entfernt 			'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274343215732865052)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_language=>'de'
,p_message_text=>unistr('hat den Status f\00FCr %0 %2 auf %1 gesetzt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274342894381865052)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_language=>'de'
,p_message_text=>'hat %1 %0 abonniert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274342380657865051)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_language=>'de'
,p_message_text=>'hat Zuweisung von %0 zu %1 %2 aufgehoben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274342754396865052)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_language=>'de'
,p_message_text=>unistr('hat %1 die Anwendungs- und Seitenverkn\00FCpfung von %0 entfernt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274342566713865051)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_language=>'de'
,p_message_text=>'hat Markierung von %0 als Duplikat %1 aufgehoben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274342906734865052)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_language=>'de'
,p_message_text=>'hat das Abonnement von %0 %1 aufgehoben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274343387451865052)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_language=>'de'
,p_message_text=>'hat Duplikat von %0 %1 durch %2 markiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273455683055864419)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_language=>'de'
,p_message_text=>'Nicht zugeordnet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273432993734864404)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_language=>'de'
,p_message_text=>'Einblenden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273456428275864419)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_language=>'de'
,p_message_text=>'Subscription aufgehoben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274385089250865081)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_language=>'de'
,p_message_text=>'Aktualisieren...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273459505384864421)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_language=>'de'
,p_message_text=>'ZIP-Datei'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273458483497864421)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_language=>'de'
,p_message_text=>'ZIP-Dateien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274691351972865296)
,p_name=>'APEX.ITEM.FILE.BROWSE'
,p_message_language=>'de'
,p_message_text=>'Durchsuchen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274689221998865295)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILE'
,p_message_language=>'de'
,p_message_text=>unistr('Datei w\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274689345107865295)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILES'
,p_message_language=>'de'
,p_message_text=>unistr('Dateien ausw\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274794234348865369)
,p_name=>'APEX.ITEM.HELP_TEXT'
,p_message_language=>'de'
,p_message_text=>'Hilfetext: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274647375412865265)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Element %0 nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273443026121864410)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'de'
,p_message_text=>unistr('#LABEL# liegt nicht im g\00FCltigen Bereich zwischen %0 und %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273443111268864410)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_MULTIPLE_OF_STEP'
,p_message_language=>'de'
,p_message_text=>'#LABEL# ist kein Mehrfaches von %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273442426204864410)
,p_name=>'APEX.ITEM_TYPE.YES_NO.INVALID_VALUE'
,p_message_language=>'de'
,p_message_text=>'#LABEL# muss den Werten %0 und %1 entsprechen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273442693775864410)
,p_name=>'APEX.ITEM_TYPE.YES_NO.NO_LABEL'
,p_message_language=>'de'
,p_message_text=>'Nein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274102207437864879)
,p_name=>'APEX.ITEM_TYPE.YES_NO.OFF_LABEL'
,p_message_language=>'de'
,p_message_text=>'Aus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274102388962864879)
,p_name=>'APEX.ITEM_TYPE.YES_NO.ON_LABEL'
,p_message_language=>'de'
,p_message_text=>'Ein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273442504839864410)
,p_name=>'APEX.ITEM_TYPE.YES_NO.YES_LABEL'
,p_message_language=>'de'
,p_message_text=>'Ja'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273413640327864390)
,p_name=>'APEX.LIST_MANAGER.ADD_ENTRY'
,p_message_language=>'de'
,p_message_text=>unistr('Eintrag hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274359176219865063)
,p_name=>'APEX.LIST_MANAGER.BUTTON_ADD'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274359229358865063)
,p_name=>'APEX.LIST_MANAGER.BUTTON_REMOVE'
,p_message_language=>'de'
,p_message_text=>'Entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273413707257864391)
,p_name=>'APEX.LIST_MANAGER.SELECTED_ENTRY'
,p_message_language=>'de'
,p_message_text=>unistr('Ausgew\00E4hlte Eintr\00E4ge')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274590962005865226)
,p_name=>'APEX.LTO.ADVANCED'
,p_message_language=>'de'
,p_message_text=>'Erweitert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274591232035865226)
,p_name=>'APEX.LTO.CANCEL'
,p_message_language=>'de'
,p_message_text=>'Abbrechen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274591057449865226)
,p_name=>'APEX.LTO.COMMON'
,p_message_language=>'de'
,p_message_text=>'Allgemein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274591380472865226)
,p_name=>'APEX.LTO.LIVE_TEMPLATE_OPTIONS'
,p_message_language=>'de'
,p_message_text=>'Live-Templateoptionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274592557906865227)
,p_name=>'APEX.LTO.NOT_APPLICABLE'
,p_message_language=>'de'
,p_message_text=>unistr('Templateoptionen sind nicht verf\00FCgbar, weil diese Komponente nicht auf der Seite gerendert wird.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274590889896865226)
,p_name=>'APEX.LTO.NO_OPTIONS_FOUND'
,p_message_language=>'de'
,p_message_text=>'Keine Templateoptionen gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274591172358865226)
,p_name=>'APEX.LTO.SAVE'
,p_message_language=>'de'
,p_message_text=>'Speichern'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274588655435865224)
,p_name=>'APEX.MARKDOWN.BOLD'
,p_message_language=>'de'
,p_message_text=>'Fett'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274589941686865225)
,p_name=>'APEX.MARKDOWN.IMAGE'
,p_message_language=>'de'
,p_message_text=>'Bild'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274589558774865225)
,p_name=>'APEX.MARKDOWN.INLINE_CODE'
,p_message_language=>'de'
,p_message_text=>'Inline-Code'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274684402824865292)
,p_name=>'APEX.MARKDOWN.INSERT_IMAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Bild einf\00FCgen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274684559698865292)
,p_name=>'APEX.MARKDOWN.INSERT_LINK'
,p_message_language=>'de'
,p_message_text=>unistr('Link einf\00FCgen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274588748129865224)
,p_name=>'APEX.MARKDOWN.ITALIC'
,p_message_language=>'de'
,p_message_text=>'Kursiv'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274686296094865293)
,p_name=>'APEX.MARKDOWN.LINK'
,p_message_language=>'de'
,p_message_text=>'Link'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274589894196865225)
,p_name=>'APEX.MARKDOWN.LIST'
,p_message_language=>'de'
,p_message_text=>'Liste'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274589710840865225)
,p_name=>'APEX.MARKDOWN.ORDERED_LIST'
,p_message_language=>'de'
,p_message_text=>'Sortierte Liste'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274588867851865224)
,p_name=>'APEX.MARKDOWN.PREVIEW'
,p_message_language=>'de'
,p_message_text=>'Vorschau'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274589318421865225)
,p_name=>'APEX.MARKDOWN.PREVIEW_EMPTY'
,p_message_language=>'de'
,p_message_text=>'Keine Vorschau vorhanden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274589426987865225)
,p_name=>'APEX.MARKDOWN.STRIKETHROUGH'
,p_message_language=>'de'
,p_message_text=>'Durchgestrichen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274589661318865225)
,p_name=>'APEX.MARKDOWN.UNORDERED_LIST'
,p_message_language=>'de'
,p_message_text=>'Unsortierte Liste'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274217312611864960)
,p_name=>'APEX.MENU.CURRENT_MENU'
,p_message_language=>'de'
,p_message_text=>'Aktuell'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274757599089865343)
,p_name=>'APEX.MENU.OVERFLOW_LABEL'
,p_message_language=>'de'
,p_message_text=>'Weitere...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274217265661864960)
,p_name=>'APEX.MENU.PROCESSING'
,p_message_language=>'de'
,p_message_text=>'Wird geladen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274668164540865280)
,p_name=>'APEX.NOTIFICATION_MESSAGE_HEADING'
,p_message_language=>'de'
,p_message_text=>'Benachrichtigung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273579413204864502)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler im Pr\00FCfsummencontent der Benachrichtigung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273579335285864502)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler im Pr\00FCfsummenformat der Benachrichtigung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274292891749865017)
,p_name=>'APEX.NUMBER_FIELD.VALUE_GREATER_MAX_VALUE'
,p_message_language=>'de'
,p_message_text=>unistr('#LABEL# ist gr\00F6\00DFer als das angegebene Maximum %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274292928380865017)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID'
,p_message_language=>'de'
,p_message_text=>'#LABEL# muss numerisch sein.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274293054734865017)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID2'
,p_message_language=>'de'
,p_message_text=>'#LABEL# entspricht nicht dem Zahlenformat %0 (Beispiel: %1).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274292757076865016)
,p_name=>'APEX.NUMBER_FIELD.VALUE_LESS_MIN_VALUE'
,p_message_language=>'de'
,p_message_text=>'#LABEL# liegt unter dem angegebenen Mindestwert %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274292607736865016)
,p_name=>'APEX.NUMBER_FIELD.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'de'
,p_message_text=>unistr('#LABEL# liegt nicht im g\00FCltigen Bereich zwischen %0 und %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273818409006864666)
,p_name=>'APEX.PAGE.DUPLICATE_SUBMIT'
,p_message_language=>'de'
,p_message_text=>'Diese Seite wurde bereits weitergeleitet und kann nicht erneut weitergeleitet werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273681159425864569)
,p_name=>'APEX.PAGE.NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Anwendung "%0" Seite "%1" nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273962028048864767)
,p_name=>'APEX.PAGE_ITEM_IS_REQUIRED'
,p_message_language=>'de'
,p_message_text=>'#LABEL# muss einen Wert haben.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274697724152865301)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_language=>'de'
,p_message_text=>'Info zur Anwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274697521548865301)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_language=>'de'
,p_message_text=>'Konfigurationsoptionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274697621654865301)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_language=>'de'
,p_message_text=>'Theme-Stilauswahl'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274359561903865063)
,p_name=>'APEX.POPUP_LOV.BUTTON_CLOSE'
,p_message_language=>'de'
,p_message_text=>unistr('Schlie\00DFen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274359435588865063)
,p_name=>'APEX.POPUP_LOV.BUTTON_FIND'
,p_message_language=>'de'
,p_message_text=>'Find%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274359723098865063)
,p_name=>'APEX.POPUP_LOV.BUTTON_NEXT'
,p_message_language=>'de'
,p_message_text=>'Weiter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274359696979865063)
,p_name=>'APEX.POPUP_LOV.BUTTON_PREV'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273437076272864406)
,p_name=>'APEX.POPUP_LOV.FILTER_REQ'
,p_message_language=>'de'
,p_message_text=>'Geben Sie einen Suchbegriff aus mindestens %0 Zeichen ein.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274011331923864814)
,p_name=>'APEX.POPUP_LOV.ICON_TEXT'
,p_message_language=>'de'
,p_message_text=>'Popup-Werteliste: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273437155526864406)
,p_name=>'APEX.POPUP_LOV.INITIAL_FILTER_REQ'
,p_message_language=>'de'
,p_message_text=>'Geben Sie einen Suchbegriff ein.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273436929776864406)
,p_name=>'APEX.POPUP_LOV.NO_RESULTS'
,p_message_language=>'de'
,p_message_text=>'Keine Ergebnisse gefunden.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273436869377864406)
,p_name=>'APEX.POPUP_LOV.REMOVE_VALUE'
,p_message_language=>'de'
,p_message_text=>'%0 entfernen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274179587609864933)
,p_name=>'APEX.POPUP_LOV.SEARCH'
,p_message_language=>'de'
,p_message_text=>'Suchbegriff'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274359390686865063)
,p_name=>'APEX.POPUP_LOV.TITLE'
,p_message_language=>'de'
,p_message_text=>'Suchdialog'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273439617513864408)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Abrufen des n\00E4chsten oder vorherigen Prim\00E4rschl\00FCsselwertes nicht m\00F6glich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274172576907864928)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Der Webservice wurde nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273682643244864571)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten des Prozesses.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274651743690865269)
,p_name=>'APEX.PROCESSING'
,p_message_language=>'de'
,p_message_text=>'Verarbeitung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273466379263864426)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Application Express konnte die Anforderung wegen Ressourceneinschr\00E4nkungen der Datenbanksession nicht verarbeiten. Wiederholen Sie den Vorgang sp\00E4ter.'),
'<p/>',
'Details zu diesem Vorfall finden Sie unter Debugging-ID "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274708706552865309)
,p_name=>'APEX.REGION.CSSCALENDAR.ADD'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274130901546864899)
,p_name=>'APEX.REGION.CSSCALENDAR.ALL_DAY'
,p_message_language=>'de'
,p_message_text=>unistr('Ganzt\00E4gig')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274781067194865360)
,p_name=>'APEX.REGION.CSSCALENDAR.BUTTON.SENDEMAIL'
,p_message_language=>'de'
,p_message_text=>'Einladung senden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274780742858865360)
,p_name=>'APEX.REGION.CSSCALENDAR.CHOOSE_ACTION'
,p_message_language=>'de'
,p_message_text=>'Optionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274146095381864910)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_ALLDAY'
,p_message_language=>'de'
,p_message_text=>unistr('T\00E4gliche Anzeige f\00FCr jeden Tag')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274145838297864910)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_TIME_SPECIFIC'
,p_message_language=>'de'
,p_message_text=>unistr('T\00E4gliche Anzeige f\00FCr Daten mit Uhrzeit')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274670616250865282)
,p_name=>'APEX.REGION.CSSCALENDAR.DAY'
,p_message_language=>'de'
,p_message_text=>'Tag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274617561113865245)
,p_name=>'APEX.REGION.CSSCALENDAR.DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Beschreibung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273528680341864468)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.CSV'
,p_message_language=>'de'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273528460437864467)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.ICALENDAR'
,p_message_language=>'de'
,p_message_text=>'iCal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273528306224864467)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.PDF'
,p_message_language=>'de'
,p_message_text=>'PDF'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273528553684864468)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.XML'
,p_message_language=>'de'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273528021550864467)
,p_name=>'APEX.REGION.CSSCALENDAR.ENDDATE'
,p_message_language=>'de'
,p_message_text=>'Enddatum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273528258823864467)
,p_name=>'APEX.REGION.CSSCALENDAR.EVENTNAME'
,p_message_language=>'de'
,p_message_text=>'Ereignisname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274780837943865360)
,p_name=>'APEX.REGION.CSSCALENDAR.INVITATION'
,p_message_language=>'de'
,p_message_text=>'Einladung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274670763716865282)
,p_name=>'APEX.REGION.CSSCALENDAR.LIST'
,p_message_language=>'de'
,p_message_text=>'Liste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274670482025865282)
,p_name=>'APEX.REGION.CSSCALENDAR.MONTH'
,p_message_language=>'de'
,p_message_text=>'Monat'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274685460415865292)
,p_name=>'APEX.REGION.CSSCALENDAR.NEXT'
,p_message_language=>'de'
,p_message_text=>'Weiter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274739132182865330)
,p_name=>'APEX.REGION.CSSCALENDAR.NOEVENTS'
,p_message_language=>'de'
,p_message_text=>'Keine Ereignisse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274781440339865360)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.FORM'
,p_message_language=>'de'
,p_message_text=>'Bearbeiten Sie ein vorhandenes Ereignis.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274781338326865360)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.SEND'
,p_message_language=>'de'
,p_message_text=>'Senden Sie die Einladung per E-Mail.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274685596659865292)
,p_name=>'APEX.REGION.CSSCALENDAR.PREVIOUS'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274724842047865320)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL'
,p_message_language=>'de'
,p_message_text=>'E-Mail senden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274724440495865320)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.BUTTON'
,p_message_language=>'de'
,p_message_text=>'E-Mail senden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274788453146865365)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Alle Felder sind Pflichtfelder.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274788372808865365)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.TITLE'
,p_message_language=>'de'
,p_message_text=>'Einladung senden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274780460084865359)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.SUBJECT'
,p_message_language=>'de'
,p_message_text=>'Betreff'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274724718958865320)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.TO'
,p_message_language=>'de'
,p_message_text=>'An'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273528189735864467)
,p_name=>'APEX.REGION.CSSCALENDAR.STARTDATE'
,p_message_language=>'de'
,p_message_text=>'Startdatum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274705441577865306)
,p_name=>'APEX.REGION.CSSCALENDAR.TABLEFORM'
,p_message_language=>'de'
,p_message_text=>'Formular basierend auf %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274145681646864909)
,p_name=>'APEX.REGION.CSSCALENDAR.TIME'
,p_message_language=>'de'
,p_message_text=>'Uhrzeit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274686138403865293)
,p_name=>'APEX.REGION.CSSCALENDAR.TODAY'
,p_message_language=>'de'
,p_message_text=>'Heute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274671539573865282)
,p_name=>'APEX.REGION.CSSCALENDAR.VIEW'
,p_message_language=>'de'
,p_message_text=>'Anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274670507344865282)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEK'
,p_message_language=>'de'
,p_message_text=>'Woche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274145967438864910)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_ALLDAY'
,p_message_language=>'de'
,p_message_text=>unistr('W\00F6chentliche Anzeige f\00FCr jeden Tag')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274145738404864909)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_TIME_SPECIFIC'
,p_message_language=>'de'
,p_message_text=>unistr('W\00F6chentliche Anzeige f\00FCr Daten mit Uhrzeit')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274671164879865282)
,p_name=>'APEX.REGION.CSSCALENDAR.YEAR'
,p_message_language=>'de'
,p_message_text=>'Jahr'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273439913530864408)
,p_name=>'APEX.REGION.FLASH_CHART.INITIALIZING'
,p_message_language=>'de'
,p_message_text=>'Initialisierung erfolgt...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273699332411864582)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_DATA'
,p_message_language=>'de'
,p_message_text=>'Daten werden geladen...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274710276443865310)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_RESOURCES'
,p_message_language=>'de'
,p_message_text=>'Ressourcen werden geladen...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274710383875865310)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_TEMPLATES'
,p_message_language=>'de'
,p_message_text=>'Templates werden geladen...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273440046165864408)
,p_name=>'APEX.REGION.FLASH_CHART.NO_DATA_FOUND'
,p_message_language=>'de'
,p_message_text=>'Keine Daten gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273604836582864519)
,p_name=>'APEX.REGION.FLASH_CHART.SHOW_XML'
,p_message_language=>'de'
,p_message_text=>'XML anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273699410651864582)
,p_name=>'APEX.REGION.FLASH_CHART.WAITING'
,p_message_language=>'de'
,p_message_text=>'Daten werden geladen. Bitte warten.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274670863223865282)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Spalten...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274670947052865282)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.LOAD_MORE'
,p_message_language=>'de'
,p_message_text=>'Mehr laden...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273871753211864704)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.BACK'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273467885754864427)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.LOAD_MORE'
,p_message_language=>'de'
,p_message_text=>'Mehr laden...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273492846176864444)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.SEARCH'
,p_message_language=>'de'
,p_message_text=>'Suchen...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274671021765865282)
,p_name=>'APEX.REGION.JQM_REFLOW.LOAD_MORE'
,p_message_language=>'de'
,p_message_text=>'Mehr laden...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274684794151865292)
,p_name=>'APEX.REGION.NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Regions-ID %0 nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273479032084864435)
,p_name=>'APEX.REGION.NO_DATA_FOUND_MESSAGE'
,p_message_language=>'de'
,p_message_text=>'Keine Daten gefunden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273687072978864574)
,p_name=>'APEX.REGION.PAGINATION.RESET_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCcksetzen von Seitennummerierung f\00FCr Region nicht m\00F6glich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273439805601864408)
,p_name=>'APEX.REGION.PAGINATION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Festlegen des Regionsumbruchs.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274612291611865241)
,p_name=>'APEX.REGION.RESPONSIVE_TABLE.COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Spalten...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274684610013865292)
,p_name=>'APEX.REGION.TYPE_NOT_SUPPORTED'
,p_message_language=>'de'
,p_message_text=>unistr('Regionstyp %0 wird nicht unterst\00FCtzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273439733674864408)
,p_name=>'APEX.REGION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Rendering von Region "#COMPONENT_NAME#".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273962154556864767)
,p_name=>'APEX.REGION_COLUMN_IS_REQUIRED'
,p_message_language=>'de'
,p_message_text=>'#COLUMN_HEADER# muss einen Wert aufweisen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274142229048864907)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_language=>'de'
,p_message_text=>unistr('Authentifizierung f\00FCr REST-f\00E4higen SQL-Service nicht erfolgreich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273466664346864426)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler bei der Authentifizierung. Werteliste verwendet eine REST-f\00E4hige SQL-Datenquelle, die auf ung\00FCltige Webzugangsdaten verweist, die verhindern, dass Sie Spalteninformationen f\00FCr diese Werteliste \00E4ndern k\00F6nnen. Pr\00FCfen Sie die Zugangsdaten f\00FCr die')
||' Authentifizierung. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274680527506865289)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_language=>'de'
,p_message_text=>unistr('Kommunikationsfehler. Beim Aufrufen der von der Werteliste referenzierten REST-f\00E4higen SQL-Datenquelle ist ein Problem aufgetreten, das verhindert, dass Sie Spalteninformationen f\00FCr die Werteliste bearbeiten k\00F6nnen. Pr\00FCfen Sie, ob die REST-f\00E4hige SQL')
||unistr('-Datenquelle ordnungsgem\00E4\00DF arbeitet und ob die entsprechenden Zugangsdaten f\00FCr die Authentifizierung korrekt sind.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274209963674864955)
,p_name=>'APEX.REMOTESQL.OAUTH_IS_RECOMMENDED'
,p_message_language=>'de'
,p_message_text=>unistr('Warnung: Oracle empfiehlt die Verwendung von OAuth-Clientzugangsdaten f\00FCr die Authentifizierung mit REST-f\00E4higer SQL.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274143693428864908)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler auf Remoteserver: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274100414184864877)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>unistr('Angegebene ORDS-REST-f\00E4hige SQL-Instanz nicht gefunden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273701681398864584)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_language=>'de'
,p_message_text=>'Server hat eine Umleitung zu: %0 gesendet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273989691322864799)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_language=>'de'
,p_message_text=>unistr('SQL-Anweisung ist l\00E4nger als 32.767 Byte.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274009578312864813)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hallo, Application Express! Sie sind als #USER# angemeldet.',
'Der lokale Datenbankzeitstempel ist: #SYSDATE#.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274337681214865048)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_language=>'de'
,p_message_text=>unistr('Sie bearbeiten den Alias f\00FCr das Standardschema des Workspace. Wenn Sie diesen Alias festlegen, wird auch das Pfadpr\00E4fix auf Workspace-Ebene ge\00E4ndert. Dies wirkt sich auf die URL f\00FCr alle definierten APEX-basierten RESTful Services aus.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273996888765864804)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ORDS'
,p_message_language=>'de'
,p_message_text=>unistr('Die aktuelle ORDS-Version unterst\00FCtzt die REST-Administrationsoberfl\00E4che nicht.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273996986690864804)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ROLE'
,p_message_language=>'de'
,p_message_text=>unistr('Die angegebene Clientrolle wird von der REST-Administrationsoberfl\00E4che nicht unterst\00FCtzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274776296706865356)
,p_name=>'APEX.RICH_TEXT_EDITOR.ACCESSIBLE_LABEL'
,p_message_language=>'de'
,p_message_text=>'%0, Rich Text-Editor'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273987280108864797)
,p_name=>'APEX.RICH_TEXT_EDITOR.MAXIMUM_LENGTH_EXCEEDED'
,p_message_language=>'de'
,p_message_text=>unistr('Das Rich-Text-HTML-Markup \00FCberschreitet die maximale L\00E4nge des Elements (tats\00E4chlich: %0, zul\00E4ssig: %1 Zeichen)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274669446977865281)
,p_name=>'APEX.RV.DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274595239598865229)
,p_name=>'APEX.RV.DUPLICATE'
,p_message_language=>'de'
,p_message_text=>'Duplizieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274590496130865225)
,p_name=>'APEX.RV.EXCLUDE_HIDDEN'
,p_message_language=>'de'
,p_message_text=>'Angezeigte Spalten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274590362428865225)
,p_name=>'APEX.RV.EXCLUDE_NULL'
,p_message_language=>'de'
,p_message_text=>unistr('Nullwerte ausschlie\00DFen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274669567714865281)
,p_name=>'APEX.RV.INSERT'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274129635608864898)
,p_name=>'APEX.RV.MOVE_DOWN'
,p_message_language=>'de'
,p_message_text=>'Nach unten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274129769549864898)
,p_name=>'APEX.RV.MOVE_UP'
,p_message_language=>'de'
,p_message_text=>'Nach oben'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274590142299865225)
,p_name=>'APEX.RV.NEXT_RECORD'
,p_message_language=>'de'
,p_message_text=>'Weiter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274590753694865226)
,p_name=>'APEX.RV.NOT_GROUPED_LABEL'
,p_message_language=>'de'
,p_message_text=>'Andere Spalten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274590266821865225)
,p_name=>'APEX.RV.PREV_RECORD'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274590596119865226)
,p_name=>'APEX.RV.REC_X'
,p_message_language=>'de'
,p_message_text=>'Zeile %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274590670384865226)
,p_name=>'APEX.RV.REC_XY'
,p_message_language=>'de'
,p_message_text=>'Zeile %0 von %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274595374435865229)
,p_name=>'APEX.RV.REFRESH'
,p_message_language=>'de'
,p_message_text=>'Aktualisieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274595418804865229)
,p_name=>'APEX.RV.REVERT'
,p_message_language=>'de'
,p_message_text=>unistr('\00C4nderungen wiederherstellen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274590023858865225)
,p_name=>'APEX.RV.SETTINGS_MENU'
,p_message_language=>'de'
,p_message_text=>unistr('Men\00FC "Einstellungen"')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274064455014864852)
,p_name=>'APEX.SAMPLE_FORMAT'
,p_message_language=>'de'
,p_message_text=>'Beispiel: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273987325003864797)
,p_name=>'APEX.SC.REFERENCES'
,p_message_language=>'de'
,p_message_text=>'%0 Referenzen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274328996191865042)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_language=>'de'
,p_message_text=>'Utilitys'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274329072067865042)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Anwendungsutilitys\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274336409714865047)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_language=>'de'
,p_message_text=>'Zur Seite gehen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274336329288865047)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_language=>'de'
,p_message_text=>'Zu "Gemeinsame Komponenten" navigieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274329109651865042)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_language=>'de'
,p_message_text=>'App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274329291585865042)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_language=>'de'
,p_message_text=>'App Builder-Aufgaben > '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274329356390865042)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Anwendungselemente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274329424555865042)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Anwendungselemente\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274329596187865042)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_language=>'de'
,p_message_text=>'Anwendungslogik'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274329606159865043)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_language=>'de'
,p_message_text=>'Authentifizierungsschemas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274329781633865043)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Sicherheitsauthentifizierungsschemas\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274329855646865043)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_language=>'de'
,p_message_text=>'Autorisierungsschemas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274329955834865043)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Sicherheitsautorisierungsschemas\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274330036123865043)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_language=>'de'
,p_message_text=>'Navigationspfade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274330128574865043)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Navigationspfade\%LIST_ITEM_NAME%'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274330296586865043)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_language=>'de'
,p_message_text=>'Erstelloptionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274330328972865043)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Erstelloptionen\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274330452169865043)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Komponenteneinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274330555975865043)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Komponenteneinstellungen\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274330609076865043)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_language=>'de'
,p_message_text=>'Berechnungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274330730569865043)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Anwendungsberechnungen\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274330867126865043)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_language=>'de'
,p_message_text=>'Anwendungselement erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274330937478865043)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_language=>'de'
,p_message_text=>'Authentifizierungsschema erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274331088111865044)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_language=>'de'
,p_message_text=>'Erstelloption erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274331174656865044)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_language=>'de'
,p_message_text=>'Anwendungsberechnung erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274331226383865044)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Template erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274331395920865044)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_language=>'de'
,p_message_text=>'Plug-in erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274331473037865044)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_language=>'de'
,p_message_text=>'Theme erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274331587851865044)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_language=>'de'
,p_message_text=>'Webzugangsdaten erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274331609252865044)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_language=>'de'
,p_message_text=>'Datenladedefinitionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274331764006865044)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Datenladedefinitionen\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274331812654865044)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_language=>'de'
,p_message_text=>'Datenquellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274331909988865044)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_language=>'de'
,p_message_text=>'Definitionsattribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274332074194865044)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274332188916865044)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_language=>'de'
,p_message_text=>'Berichtslayouts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274332241484865044)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Berichtslayouts\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274332320015865044)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_language=>'de'
,p_message_text=>'Legacy-Webservices'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274332478021865045)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Legacy-Webservices\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274332576766865045)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_language=>'de'
,p_message_text=>'Navigationslisten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274332658436865045)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Klassische Navigationslisten\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274332724883865045)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_language=>'de'
,p_message_text=>'Werteliste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274332845088865045)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Werteliste\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274332977555865045)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_language=>'de'
,p_message_text=>'Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274333053737865045)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_language=>'de'
,p_message_text=>'Weitere Komponenten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274333179809865045)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_language=>'de'
,p_message_text=>'Plug-ins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274333285952865045)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Plug-ins\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274333360511865045)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_language=>'de'
,p_message_text=>'Prozesse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274333420269865045)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Anwendungsprozesse\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274333515777865045)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_language=>'de'
,p_message_text=>'Berichtsabfragen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274333674187865045)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Berichtsabfragen\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274333763640865045)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_language=>'de'
,p_message_text=>'Berichte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274333870032865046)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_language=>'de'
,p_message_text=>unistr('REST-f\00E4hige SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274333929649865046)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>unistr('Navigieren Sie zu: Gemeinsame Komponenten\005CREST-f\00E4hige SQL\005C%LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274334013523865046)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_language=>'de'
,p_message_text=>'Sicherheit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274334129234865046)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_language=>'de'
,p_message_text=>unistr('Schutz f\00FCr den Sessionzustand')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274334229715865046)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_language=>'de'
,p_message_text=>unistr('Schutz f\00FCr den Anwendungsstatus festlegen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274334419601865046)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_language=>'de'
,p_message_text=>'Gemeinsame Komponenten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274334508377865046)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274334679703865046)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_language=>'de'
,p_message_text=>'Shortcuts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274334788158865046)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Shortcuts\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274334884125865046)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_language=>'de'
,p_message_text=>'Registerkarten (Legacy)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274334904122865046)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_language=>'de'
,p_message_text=>'Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274335088347865046)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\UI-Templates\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274335121232865046)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_language=>'de'
,p_message_text=>'Themes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274335283846865047)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\UI-Themes\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274335351676865047)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzeroberfl\00E4che')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274335417999865047)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_language=>'de'
,p_message_text=>'Webzugangsdaten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274335587381865047)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Sicherheitswebzugangsdaten\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274335623344865047)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_language=>'de'
,p_message_text=>'Webquellenmodule'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274335701290865047)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Navigieren Sie zu: Gemeinsame Komponenten\Webquellenmodule\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274335877623865047)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_language=>'de'
,p_message_text=>'SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274335984026865047)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_language=>'de'
,p_message_text=>'Objekt erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274336004726865047)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'%LIST_ITEM_NAME% in SQL Workshop erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274336188407865047)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_language=>'de'
,p_message_text=>'Skripteditor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274336287333865047)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_language=>'de'
,p_message_text=>'SQL Workshop-Aufgaben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274718711737865316)
,p_name=>'APEX.SESSION.DB_SESSION_CLEANUP.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten des Cleanup-Codes der Datenbanksession.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273680629527864569)
,p_name=>'APEX.SESSION.DB_SESSION_INIT.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten des Setup-Codes der Datenbanksession.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273454370998864418)
,p_name=>'APEX.SESSION.EXPIRED'
,p_message_language=>'de'
,p_message_text=>'Ihre Session ist abgelaufen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274710459611865310)
,p_name=>'APEX.SESSION.EXPIRED.CLOSE_DIALOG'
,p_message_language=>'de'
,p_message_text=>unistr('Schlie\00DFen Sie dieses Dialogfeld, und dr\00FCcken Sie auf die Browserschaltfl\00E4che f\00FCr das erneute Laden, um eine neue Session aufzurufen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274770615571865352)
,p_name=>'APEX.SESSION.EXPIRED.NEW_SESSION'
,p_message_language=>'de'
,p_message_text=>'Klicken Sie <a href="%0">hier</a>, um eine neue Session zu erstellen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274133774297864901)
,p_name=>'APEX.SESSION.RAS.NO_DYNAMIC_ROLES'
,p_message_language=>'de'
,p_message_text=>unistr('Es konnten keine dynamischen Rollen in der Real Application Security-Session f\00FCr Benutzer "%0" aktiviert werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273673537194864564)
,p_name=>'APEX.SESSION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('ERR-99900 Erstellen von eindeutiger Session-ID nicht m\00F6glich: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274781704909865360)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_language=>'de'
,p_message_text=>unistr('Seitenelement %0 basiert auf einer Datenbankspalte, das Attribut ''Verwendete Quelle'' ist jedoch auf ''Nur wenn aktueller Wert in Sessionzustand Null ist'' festgelegt. Dies ist sehr gef\00E4hrlich und kann dazu f\00FChren, dass Daten \00FCberschrieben werden, wenn ')
||unistr('mehrere Datens\00E4tze angezeigt und gespeichert werden. Legen Sie ''Verwendete Quelle'' immer auf ''Vorhandene Werte im Sessionzustand immer ersetzen'' fest.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274691256360865296)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_language=>'de'
,p_message_text=>'Zugriff auf Sessionzustand ist deaktiviert, Lese-/Schreibversuch wurde blockiert. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273491975419864443)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_language=>'de'
,p_message_text=>unistr('Es wurde versucht, das Element %0 im Sessionzustand w\00E4hrend der show-Verarbeitung zu speichern. Das Element ist nur intern gesch\00FCtzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273473347539864431)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_language=>'de'
,p_message_text=>unistr('Es wurde versucht, das Element %0 im Sessionstatus w\00E4hrend der accept-Verarbeitung zu speichern. Das Element ist nur intern gesch\00FCtzt oder ist kein Formularelement, bei dem ein POST-Vorgang ausgef\00FChrt werden kann.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273747813140864616)
,p_name=>'APEX.SESSION_STATE.ITEM_VALUE_PROTECTION'
,p_message_language=>'de'
,p_message_text=>unistr('Verletzung des Sessionzustandsschutzes: Dieser Fehler wurde m\00F6glicherweise verursacht, weil das gesch\00FCtzte Seitenelement %0 manuell ge\00E4ndert wurde. Wenn Sie nicht wissen, wodurch dieser Fehler verursacht wurde, wenden Sie sich an den Anwendungsadmini')
||'strator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274806736807865378)
,p_name=>'APEX.SESSION_STATE.PAGE_PROTECTION'
,p_message_language=>'de'
,p_message_text=>unistr('Seitenschutzverletzung: Dies kann auftreten, wenn Sie eine Seite weiterleiten, die noch nicht vollst\00E4ndig geladen wurde, oder wenn Sie gesch\00FCtzte Seitenelemente manuell \00E4ndern. Wenden Sie sich an den Anwendungsadministrator, wenn Sie weitere Hilfe be')
||unistr('n\00F6tigen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274803680262865376)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR'
,p_message_language=>'de'
,p_message_text=>unistr('%0 enth\00E4lt eines der folgenden ung\00FCltigen Zeichen: &<>"/;,*|=% oder --')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274803751930865376)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR_NL'
,p_message_language=>'de'
,p_message_text=>unistr('%0 enth\00E4lt eines der folgenden ung\00FCltigen Zeichen: &<>"/;,*|=% oder -- oder Zeilenendmarke.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274803482376865376)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.US_ONLY'
,p_message_language=>'de'
,p_message_text=>unistr('%0 enth\00E4lt Sonderzeichen. Nur die Zeichen a-Z, 0-9 und Leerzeichen sind zul\00E4ssig.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274803566894865376)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'de'
,p_message_text=>unistr('%0 enth\00E4lt <, > oder ". Dies sind ung\00FCltige Zeichen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273472952467864431)
,p_name=>'APEX.SESSION_STATE.SSP_CHECKSUM_MISSING'
,p_message_language=>'de'
,p_message_text=>unistr('Es wurde keine Pr\00FCfsumme f\00FCr die Verarbeitungsanzeige f\00FCr eine Seite zur Verf\00FCgung gestellt, die eine Pr\00FCfsumme ben\00F6tigt, wenn Werte f\00FCr Anforderungen, L\00F6schvorg\00E4nge beim Cacheinhalt oder Argumente als Parameter \00FCbergeben werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273734832691864607)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION'
,p_message_language=>'de'
,p_message_text=>unistr('Verletzung des Sessionzustandschutzes: Dieser Fehler wurde m\00F6glicherweise verursacht, weil der URL ge\00E4ndert wurde, der eine Pr\00FCfsumme enth\00E4lt. Es wurde m\00F6glicherweise auch ein Link mit einer falschen oder fehlenden Pr\00FCfsumme verwendet. Wenn Sie nicht')
||' wissen, wodurch dieser Fehler verursacht wurde, wenden Sie sich an den Anwendungsadministrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273473064976864431)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Die berechnete Pr\00FCfsumme f\00FCr Anforderungen, L\00F6schvorg\00E4nge beim Cacheinhalt oder Argumentnamen und -werte (%0) stimmt nicht mit der Pr\00FCfsumme \00FCberein, die an die show-Prozedur (%1) \00FCbergeben wurde.'),
'',
'Hinweis: Endbenutzer erhalten eine andere Fehlermeldung.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273471972234864430)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Es wurde versucht, das Element %0 im Sessionzustand w\00E4hrend der Verarbeitung von "show" zu speichern. Die Schutzebene f\00FCr das Element gibt Folgendes an: '),
'"%1"',
'',
unistr('Es wurde keine Pr\00FCfsumme \00FCbergeben, oder die \00FCbergebene Pr\00FCfsumme ist f\00FCr ein Element mit der Schutzebene "%2" geeignet.'),
'',
'Hinweis: Endbenutzer erhalten eine andere Fehlermeldung.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273682465160864570)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('ERR-1022 Speichern von Attributen nicht m\00F6glich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274591488397865226)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_OFF'
,p_message_language=>'de'
,p_message_text=>'Modus "Hoher Kontrast" deaktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274591569961865226)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_ON'
,p_message_language=>'de'
,p_message_text=>'Modus "Hoher Kontrast" aktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273707219585864587)
,p_name=>'APEX.SHUTTLE.CONTROL_BOTTOM'
,p_message_language=>'de'
,p_message_text=>'Unten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273707462082864588)
,p_name=>'APEX.SHUTTLE.CONTROL_DOWN'
,p_message_language=>'de'
,p_message_text=>'Nach unten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273707591702864588)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE'
,p_message_language=>'de'
,p_message_text=>'Verschieben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273707628114864588)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE_ALL'
,p_message_language=>'de'
,p_message_text=>'Alle verschieben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273707789806864588)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE'
,p_message_language=>'de'
,p_message_text=>'Entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273707801082864588)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE_ALL'
,p_message_language=>'de'
,p_message_text=>'Alle entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273707904780864588)
,p_name=>'APEX.SHUTTLE.CONTROL_RESET'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCcksetzen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273707114201864587)
,p_name=>'APEX.SHUTTLE.CONTROL_TOP'
,p_message_language=>'de'
,p_message_text=>'Oben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273707384972864588)
,p_name=>'APEX.SHUTTLE.CONTROL_UP'
,p_message_language=>'de'
,p_message_text=>'Nach oben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274744685249865334)
,p_name=>'APEX.SINCE.SHORT.DAYS_AGO'
,p_message_language=>'de'
,p_message_text=>'%0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274745395515865334)
,p_name=>'APEX.SINCE.SHORT.DAYS_FROM_NOW'
,p_message_language=>'de'
,p_message_text=>'in %0T'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274744547898865334)
,p_name=>'APEX.SINCE.SHORT.HOURS_AGO'
,p_message_language=>'de'
,p_message_text=>'%0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274745493994865335)
,p_name=>'APEX.SINCE.SHORT.HOURS_FROM_NOW'
,p_message_language=>'de'
,p_message_text=>'in %0Std'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274744314763865334)
,p_name=>'APEX.SINCE.SHORT.MINUTES_AGO'
,p_message_language=>'de'
,p_message_text=>'%0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274745547650865335)
,p_name=>'APEX.SINCE.SHORT.MINUTES_FROM_NOW'
,p_message_language=>'de'
,p_message_text=>'in %0Min'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274744930266865334)
,p_name=>'APEX.SINCE.SHORT.MONTHS_AGO'
,p_message_language=>'de'
,p_message_text=>'%0Mo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274745188465865334)
,p_name=>'APEX.SINCE.SHORT.MONTHS_FROM_NOW'
,p_message_language=>'de'
,p_message_text=>'in %0Mo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274744407548865334)
,p_name=>'APEX.SINCE.SHORT.SECONDS_AGO'
,p_message_language=>'de'
,p_message_text=>'%0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274745220066865334)
,p_name=>'APEX.SINCE.SHORT.SECONDS_FROM_NOW'
,p_message_language=>'de'
,p_message_text=>'in %0S'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274744753045865334)
,p_name=>'APEX.SINCE.SHORT.WEEKS_AGO'
,p_message_language=>'de'
,p_message_text=>'%0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274745670332865335)
,p_name=>'APEX.SINCE.SHORT.WEEKS_FROM_NOW'
,p_message_language=>'de'
,p_message_text=>'in %0W'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274744822703865334)
,p_name=>'APEX.SINCE.SHORT.YEARS_AGO'
,p_message_language=>'de'
,p_message_text=>'%0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274745021177865334)
,p_name=>'APEX.SINCE.SHORT.YEARS_FROM_NOW'
,p_message_language=>'de'
,p_message_text=>'in %0J'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273921075673864739)
,p_name=>'APEX.SPLITTER.COLLAPSE_TEXT'
,p_message_language=>'de'
,p_message_text=>'Ausblenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273920996995864738)
,p_name=>'APEX.SPLITTER.RESTORE_TEXT'
,p_message_language=>'de'
,p_message_text=>'Wiederherstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274327972719865041)
,p_name=>'APEX.STAR_RATING.CLEAR_RATING'
,p_message_language=>'de'
,p_message_text=>unistr('Bewertung l\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274291965491865016)
,p_name=>'APEX.STAR_RATING.INVALID_RATING_RANGE'
,p_message_language=>'de'
,p_message_text=>unistr('%0 liegt nicht im g\00FCltigen Bewertungsbereich von 1 bis %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274292099950865016)
,p_name=>'APEX.STAR_RATING.IS_NOT_NUMERIC'
,p_message_language=>'de'
,p_message_text=>'%0 ist nicht numerisch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274263925338864996)
,p_name=>'APEX.SUCCESS_MESSAGE_HEADING'
,p_message_language=>'de'
,p_message_text=>'Erfolgsmeldung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273579600978864502)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler im Pr\00FCfsummencontent der Erfolgsmeldung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273579577219864502)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler im Pr\00FCfsummenformat der Erfolgsmeldung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274775805263865356)
,p_name=>'APEX.TABS.NEXT'
,p_message_language=>'de'
,p_message_text=>'Weiter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274775787319865356)
,p_name=>'APEX.TABS.PREVIOUS'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273431037790864402)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler beim Berechnen des Standardwertes f\00FCr Spalte #COMPONENT_NAME#.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273431617146864403)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler beim Verarbeiten des Prozesses zum L\00F6schen mehrerer Zeilen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273716677247864594)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_language=>'de'
,p_message_text=>unistr('Die Pr\00FCfsumme-Spalte (FCS) ist erforderlich, wurde aber nicht angegeben')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273716835470864594)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_language=>'de'
,p_message_text=>unistr('Es wurden keine Prim\00E4rschl\00FCsselwerte angegeben. Um Aktualisierungen ausf\00FChren zu k\00F6nnen, muss mindestens eine Zeile angegeben werden')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273717624737864595)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_language=>'de'
,p_message_text=>unistr('Es wurden keine Sekund\00E4rwerte f\00FCr die angegebene Sekund\00E4rschl\00FCsselspalte angegeben')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273834505286864678)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_language=>'de'
,p_message_text=>'Keine Daten auf tabellarischem Formular gefunden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273716597119864594)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_language=>'de'
,p_message_text=>unistr('Die Prim\00E4rschl\00FCsselspalte wurde nicht angegeben')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273717533848864595)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_language=>'de'
,p_message_text=>unistr('Die angegebene Sekund\00E4rschl\00FCsselspalte wurde in der Auswahlliste der Abfrage nicht ermittelt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273716490465864594)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_language=>'de'
,p_message_text=>'Der Tabellenname wurde nicht angegeben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273716389367864594)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_language=>'de'
,p_message_text=>unistr('Der Tabelleneigent\00FCmer wurde nicht angegeben')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273738665240864610)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten des Prozesses zum Update mehrerer Zeilen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274739203780865330)
,p_name=>'APEX.TB.TOOLBAR'
,p_message_language=>'de'
,p_message_text=>'Symbolleiste'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273599906889864515)
,p_name=>'APEX.TEAM.COMMITTED'
,p_message_language=>'de'
,p_message_text=>'Festgeschrieben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273599767046864515)
,p_name=>'APEX.TEAM.CONTRIBUTOR'
,p_message_language=>'de'
,p_message_text=>'Beitragender'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273601682545864516)
,p_name=>'APEX.TEAM.CREATE'
,p_message_language=>'de'
,p_message_text=>unistr('Feature %0 hinzugef\00FCgt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273601763079864516)
,p_name=>'APEX.TEAM.DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('Feature %0 gel\00F6scht.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273422044197864396)
,p_name=>'APEX.TEAM.DEPRECATED'
,p_message_language=>'de'
,p_message_text=>unistr('APEX Team Development ist seit Version 19.2 veraltet und wird in einem zuk\00FCnftigen Release entfernt. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273600078911864515)
,p_name=>'APEX.TEAM.ESTIMATED_EFFORT'
,p_message_language=>'de'
,p_message_text=>unistr('Gesch\00E4tzter Aufwand')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273600301301864516)
,p_name=>'APEX.TEAM.FEATURE_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Beschreibung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273599529786864515)
,p_name=>'APEX.TEAM.FEATURE_NAME'
,p_message_language=>'de'
,p_message_text=>'Feature'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273600113255864515)
,p_name=>'APEX.TEAM.FEATURE_STATUS'
,p_message_language=>'de'
,p_message_text=>'Featurestatus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273600251769864515)
,p_name=>'APEX.TEAM.MILESTONE'
,p_message_language=>'de'
,p_message_text=>'Meilenstein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273600557363864516)
,p_name=>'APEX.TEAM.NO'
,p_message_language=>'de'
,p_message_text=>'Nein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273599666358864515)
,p_name=>'APEX.TEAM.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Eigent\00FCmer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273599886878864515)
,p_name=>'APEX.TEAM.RELEASE'
,p_message_language=>'de'
,p_message_text=>'Release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273598624841864514)
,p_name=>'APEX.TEAM.SAVE'
,p_message_language=>'de'
,p_message_text=>'Feature %0 aktualisiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273600451404864516)
,p_name=>'APEX.TEAM.YES'
,p_message_language=>'de'
,p_message_text=>'Ja'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274778618137865358)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_NAV_LABEL'
,p_message_language=>'de'
,p_message_text=>'Navigation ein-/ausblenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274778750616865358)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_SIDE_COL_LABEL'
,p_message_language=>'de'
,p_message_text=>'Rechte Spalte einblenden/ausblenden'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273454732625864418)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_language=>'de'
,p_message_text=>'Theme "%0" kann nicht in Anwendung "%1" kopiert werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274771108144865353)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Das importierte Theme ist nicht mit dem aktuellen Theme kompatibel.',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274736925063865329)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_language=>'de'
,p_message_text=>unistr('Theme-Nummer ist ung\00FCltig oder Theme ist kein aktuelles UI-Theme.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274060851000864849)
,p_name=>'APEX.TIME.DAY'
,p_message_language=>'de'
,p_message_text=>'1 Tag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274060640322864849)
,p_name=>'APEX.TIME.HOUR'
,p_message_language=>'de'
,p_message_text=>'1 Stunde'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274060924570864849)
,p_name=>'APEX.TIME.N_DAYS'
,p_message_language=>'de'
,p_message_text=>'%0 Tage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274060705689864849)
,p_name=>'APEX.TIME.N_HOURS'
,p_message_language=>'de'
,p_message_text=>'%0 Stunden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274060590036864849)
,p_name=>'APEX.TIME.N_MINUTES'
,p_message_language=>'de'
,p_message_text=>'%0 Minuten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274061149861864849)
,p_name=>'APEX.TIME.N_WEEKS'
,p_message_language=>'de'
,p_message_text=>'%0 Wochen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274061085986864849)
,p_name=>'APEX.TIME.WEEK'
,p_message_language=>'de'
,p_message_text=>'1 Woche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274690372806865296)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_language=>'de'
,p_message_text=>unistr('Die Spalten "Prim\00E4rschl\00FCssel" und "\00DCbergeordneter Schl\00FCssel" sind zum Berechnen der Hierarchie erforderlich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274690447427865296)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Die Spalten "Knotenebene" und "Knotenstatus" sind erforderlich, wenn die Hierarchie nicht berechnet wird.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274798304441865372)
,p_name=>'APEX.UI.BACK_TO_TOP'
,p_message_language=>'de'
,p_message_text=>'Seitenanfang'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273616076677864526)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_language=>'de'
,p_message_text=>'Dunkler Modus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273616293143864526)
,p_name=>'APEX.UI.DISABLED'
,p_message_language=>'de'
,p_message_text=>'Deaktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273616103968864526)
,p_name=>'APEX.UI.ENABLED'
,p_message_language=>'de'
,p_message_text=>'Aktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274055700751864845)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>unistr('W\00E4hlen Sie eine Benutzeroberfl\00E4che aus der Liste unten:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274058296426864847)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.TITLE'
,p_message_language=>'de'
,p_message_text=>unistr('%0 - Benutzeroberfl\00E4chenauswahl')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273431375061864402)
,p_name=>'APEX.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten von Anforderung.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273576202713864500)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_language=>'de'
,p_message_text=>unistr('Unberechtigter Zugriff (Package-Variable f\00FCr die Sicherheitsgruppe kein festgelegt).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273576897960864500)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzerinformationen k\00F6nnen nicht abgerufen werden. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273564024664864491)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_language=>'de'
,p_message_text=>unistr('Der Benutzer %0 ben\00F6tigt ADMIN-Berechtigungen f\00FCr die Ausf\00FChrung dieses Vorgangs.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273576715008864500)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_language=>'de'
,p_message_text=>'Der Benutzer %0 hat keine E-Mail-Adresse angegeben.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273532218546864470)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_language=>'de'
,p_message_text=>'Unberechtigter Zugriff.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273576634712864500)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Benutzer %0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273682595553864570)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler beim Verarbeiten der Validierung.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274064773920864852)
,p_name=>'APEX.VALUE_REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Wert erforderlich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274787949292865365)
,p_name=>'APEX.WAIT_UNTIL_PAGE_LOADED'
,p_message_language=>'de'
,p_message_text=>unistr('Warten Sie, bis die Seite vollst\00E4ndig geladen ist, und wiederholen Sie den Vorgang.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274611862059865240)
,p_name=>'APEX.WARN_ON_UNSAVED_CHANGES'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Seite enth\00E4lt nicht gespeicherte \00C4nderungen.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274691794432865297)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_language=>'de'
,p_message_text=>'Application Express kann ein Datenprofil aus den Antwortdaten des Typs: %0 nicht berechnen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274122563971864893)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_language=>'de'
,p_message_text=>'Tabelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274122465194864893)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_language=>'de'
,p_message_text=>'Zeile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274675682586865285)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_language=>'de'
,p_message_text=>unistr('Der Filterausdruck ist keine g\00FCltige JSON.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274667300879865280)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_language=>'de'
,p_message_text=>unistr('Der Filter wird von Oracle REST Data Services nicht unterst\00FCtzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274009099380864813)
,p_name=>'APEX.WEBSRC.HIDE_COLUMNS'
,p_message_language=>'de'
,p_message_text=>unistr('Ausgew\00E4hlte Spalten ausblenden')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274101936494864878)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_language=>'de'
,p_message_text=>'HTTP 200: Erfolg'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274102082907864879)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_language=>'de'
,p_message_text=>'HTTP 201: Erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274101422096864878)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_language=>'de'
,p_message_text=>unistr('HTTP 400: Ung\00FCltige Anforderung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274101298438864878)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_language=>'de'
,p_message_text=>'HTTP 401: Nicht autorisiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274101577599864878)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_language=>'de'
,p_message_text=>unistr('HTTP 403: Unzul\00E4ssig')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274101336035864878)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_language=>'de'
,p_message_text=>'HTTP 404: Nicht gefunden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274101667858864878)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_language=>'de'
,p_message_text=>unistr('HTTP 405: Methode nicht zul\00E4ssig')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273421204211864396)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_language=>'de'
,p_message_text=>'HTTP 407: Proxyauthentifizierung erforderlich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273421543635864396)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_language=>'de'
,p_message_text=>'HTTP 409: Konflikt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273421325895864396)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_language=>'de'
,p_message_text=>unistr('HTTP 412: Voraussetzung nicht erf\00FCllt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273421474613864396)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_language=>'de'
,p_message_text=>'HTTP 428: Voraussetzung erforderlich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274101729239864878)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_language=>'de'
,p_message_text=>'HTTP 500: Interner Serverfehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274101889078864878)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_language=>'de'
,p_message_text=>unistr('HTTP 502: Ung\00FCltiges Gateway')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274692110914865297)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_language=>'de'
,p_message_text=>unistr('HTTP 503: Service nicht verf\00FCgbar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274692214529865297)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_language=>'de'
,p_message_text=>'HTTP 504: Gatewaytimeout'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274611796850865240)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_language=>'de'
,p_message_text=>unistr('Webquelle hat einen HTTP-Fehler zur\00FCckgegeben: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274100343924864877)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Webquellenmodul nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273644669500864545)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_language=>'de'
,p_message_text=>unistr('Zeilenselektor "%0" hat kein Objektarray ausgew\00E4hlt, das als Tabelle behandelt werden soll.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273644745944864545)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_language=>'de'
,p_message_text=>unistr('Zeilenselektor "%0" hat kein Objekt ausgew\00E4hlt, das als einzelne Zeile behandelt werden soll.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274611646276865240)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_language=>'de'
,p_message_text=>'Erforderlicher IN-Webquellenparameter "%0" des Typs "%1" muss einen Wert haben.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274594281991865228)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_language=>'de'
,p_message_text=>unistr('Der Antworttext ist zu gro\00DF f\00FCr die Anzeige.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274009269332864813)
,p_name=>'APEX.WEBSRC.SHOW_COLUMNS'
,p_message_language=>'de'
,p_message_text=>unistr('Ausgew\00E4hlte Spalten anzeigen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274064699390864852)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'de'
,p_message_text=>unistr('Legacy-ORDS-REST-Service verwendet eine kleine feste Seitengr\00F6\00DFe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274009649578864813)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_language=>'de'
,p_message_text=>unistr('Timeout wurde beim Abrufen aller Webquellendaten \00FCberschritten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273984390903864795)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_language=>'de'
,p_message_text=>unistr('Die aktuellen lokalen SQL-Filter erfordern zu viele "N\00E4chste Seite"-Anforderungen an den REST-Service.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274064563669864852)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'de'
,p_message_text=>unistr('Feste Seitengr\00F6\00DFe f\00FCr Legacy-ORDS-REST-Service ist unbekannt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274716114897865314)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>unistr('Interaktive Grid-Spalte ''%0'', die f\00FCr die dynamische Aktion ''#COMPONENT_NAME#'' angegeben wurde, ist nicht vorhanden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274716320738865314)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_language=>'de'
,p_message_text=>unistr('Prozess ''%0'' hat ''%1'' bei der Ausf\00FChrung einer Zeilensperre ausgel\00F6st. Dieser Fehler kann auftreten, wenn der Prozess eine SELECT FOR UPDATE-Anweisung bei einer komplexen View mit einem Instead-of-Trigger ausgibt, um die Zeile zu sperren. Legen Sie d')
||'as Prozessattribut ''Zeile sperren'' auf ''Nein'' oder ''PL/SQL-Code'' fest.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274716278402865314)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Prozess ''%0'' hat ''%1'' bei der Ausf\00FChrung eines DML-Befehls ausgel\00F6st. Dieser Fehler kann auftreten, wenn eine Spalte auf einer Aggregation oder einem SQL-Ausdruck basiert. Legen Sie das Spaltenattribut ''Nur Abfrage'' auf ''Ja'' fest, um die Spalte aus d')
||unistr('er INSERT- und UPDATE-Anweisung auszuschlie\00DFen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274380390551865078)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_language=>'de'
,p_message_text=>unistr('Die Master/Detailspalte ''%0'' enth\00E4lt keinen Wert. Stellen Sie sicher, dass der Prozess ''%1'' nach dem entsprechenden Prozess der Masterregion ausgef\00FChrt wird.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274697909524865301)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr interaktives Grid ''%0'' ist keine Masterspalte definiert; dies ist bei einer Master/Detailbeziehung erforderlich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274054008480864844)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr interaktives Grid ''%0'' ist keine Prim\00E4rschl\00FCsselspalte definiert; dies ist f\00FCr die Bearbeitung oder in einer Master/Detailbeziehung erforderlich.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274669657033865281)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_language=>'de'
,p_message_text=>'Bei einem editierbaren interaktiven Grid muss das Seitenattribut "Bei Weiterleitung neu laden" auf "Nur bei Erfolg" festgelegt werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274669716177865281)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_language=>'de'
,p_message_text=>'Bei einem tabellarischen Formular muss das Seitenattribut ''Bei Weiterleitung neu laden'' auf ''Immer'' festgelegt werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273611716656864523)
,p_name=>'APEXIR_3D'
,p_message_language=>'de'
,p_message_text=>'3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274705079681865306)
,p_name=>'APEXIR_ACTIONS'
,p_message_language=>'de'
,p_message_text=>'Aktionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273832421918864676)
,p_name=>'APEXIR_ACTIONS_MENU'
,p_message_language=>'de'
,p_message_text=>unistr('Men\00FC "Aktionen"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273737376948864609)
,p_name=>'APEXIR_ADD'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273822069338864669)
,p_name=>'APEXIR_ADD_FUNCTION'
,p_message_language=>'de'
,p_message_text=>unistr('Funktion hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273821962060864669)
,p_name=>'APEXIR_ADD_GROUP_BY_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Gruppe nach Spalte hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274146492537864910)
,p_name=>'APEXIR_ADD_PIVOT_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Pivot-Spalte hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274146575227864910)
,p_name=>'APEXIR_ADD_ROW_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Zeilenspalte hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274310207404865029)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_language=>'de'
,p_message_text=>unistr('Subscription hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273611993166864523)
,p_name=>'APEXIR_AGGREGATE'
,p_message_language=>'de'
,p_message_text=>'Aggregat'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273856468158864693)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Aggregate werden nach jedem Kontrollgruppenwechsel und am Ende des Berichts angezeigt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273859522380864695)
,p_name=>'APEXIR_AGGREGATION'
,p_message_language=>'de'
,p_message_text=>'Aggregation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273737826329864609)
,p_name=>'APEXIR_AGG_AVG'
,p_message_language=>'de'
,p_message_text=>'Durchschnitt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273746794765864615)
,p_name=>'APEXIR_AGG_COUNT'
,p_message_language=>'de'
,p_message_text=>'Anzahl'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273763725282864627)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_language=>'de'
,p_message_text=>unistr('Nur eindeutige Reihen z\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273737921692864609)
,p_name=>'APEXIR_AGG_MAX'
,p_message_language=>'de'
,p_message_text=>'Maximal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273738103594864609)
,p_name=>'APEXIR_AGG_MEDIAN'
,p_message_language=>'de'
,p_message_text=>'Medianwert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273738000498864609)
,p_name=>'APEXIR_AGG_MIN'
,p_message_language=>'de'
,p_message_text=>'Minimal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273738231623864609)
,p_name=>'APEXIR_AGG_MODE'
,p_message_language=>'de'
,p_message_text=>'Modus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273737759008864609)
,p_name=>'APEXIR_AGG_SUM'
,p_message_language=>'de'
,p_message_text=>'Summe %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273739554719864610)
,p_name=>'APEXIR_ALL'
,p_message_language=>'de'
,p_message_text=>'Alle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273610972729864523)
,p_name=>'APEXIR_ALL_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Alle Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273461785339864423)
,p_name=>'APEXIR_ALL_ROWS'
,p_message_language=>'de'
,p_message_text=>'Alle Zeilen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274701598754865304)
,p_name=>'APEXIR_ALTERNATIVE'
,p_message_language=>'de'
,p_message_text=>'Alternative'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274703699598865305)
,p_name=>'APEXIR_ALTERNATIVE_DEFAULT_NAME'
,p_message_language=>'de'
,p_message_text=>'Alternativer Standardwert: %0 '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273697670901864581)
,p_name=>'APEXIR_AND'
,p_message_language=>'de'
,p_message_text=>'und'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273618461670864528)
,p_name=>'APEXIR_APPLY'
,p_message_language=>'de'
,p_message_text=>'Anwenden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274667597870865280)
,p_name=>'APEXIR_AREA'
,p_message_language=>'de'
,p_message_text=>unistr('Fl\00E4che')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273582394929864504)
,p_name=>'APEXIR_ASCENDING'
,p_message_language=>'de'
,p_message_text=>'Aufsteigend'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273710163710864590)
,p_name=>'APEXIR_AS_OF'
,p_message_language=>'de'
,p_message_text=>'Ab %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274704246151865305)
,p_name=>'APEXIR_AVERAGE_X'
,p_message_language=>'de'
,p_message_text=>'Durchschnitt %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274667422101865280)
,p_name=>'APEXIR_BAR'
,p_message_language=>'de'
,p_message_text=>'Balken'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273614877997864525)
,p_name=>'APEXIR_BETWEEN'
,p_message_language=>'de'
,p_message_text=>'zwischen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273581032219864503)
,p_name=>'APEXIR_BGCOLOR'
,p_message_language=>'de'
,p_message_text=>'Hintergrundfarbe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274307208095865027)
,p_name=>'APEXIR_BLACK'
,p_message_language=>'de'
,p_message_text=>'Schwarz'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273583103940864504)
,p_name=>'APEXIR_BLUE'
,p_message_language=>'de'
,p_message_text=>'blau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273824850909864671)
,p_name=>'APEXIR_BOTTOM'
,p_message_language=>'de'
,p_message_text=>'Unten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273739143080864610)
,p_name=>'APEXIR_CALENDAR'
,p_message_language=>'de'
,p_message_text=>'Kalender'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273583734237864505)
,p_name=>'APEXIR_CANCEL'
,p_message_language=>'de'
,p_message_text=>'Abbrechen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273623851082864531)
,p_name=>'APEXIR_CATEGORY'
,p_message_language=>'de'
,p_message_text=>'Kategorie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273580992495864503)
,p_name=>'APEXIR_CELL'
,p_message_language=>'de'
,p_message_text=>'Zelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273739043081864610)
,p_name=>'APEXIR_CHART'
,p_message_language=>'de'
,p_message_text=>'Diagramm'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273828033903864673)
,p_name=>'APEXIR_CHART_INITIALIZING'
,p_message_language=>'de'
,p_message_text=>'Initialisierung erfolgt...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274182391033864935)
,p_name=>'APEXIR_CHART_LABEL_NOT_NULL'
,p_message_language=>'de'
,p_message_text=>'Das Diagrammlabel muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274294881394865018)
,p_name=>'APEXIR_CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'de'
,p_message_text=>unistr('Ihre Abfrage \00FCberschreitet die maximal zul\00E4ssigen %0 Datenpunkte pro Diagramm. Wenden Sie einen Filter an, um die Anzahl der Datens\00E4tze in der Basisabfrage zu reduzieren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274288823988865014)
,p_name=>'APEXIR_CHART_MAX_ROW_CNT'
,p_message_language=>'de'
,p_message_text=>unistr('Die maximale Zeilenanzahl f\00FCr eine "Diagramm"-Abfrage begrenzt die Anzahl der Zeilen in der Basisabfrage, aber nicht die Anzahl der angezeigten Zeilen. Die Basisabfrage \00FCberschreitet die maximale Zeilenanzahl von %0. Wenden Sie einen Filter an, um di')
||unistr('e Anzahl der Datens\00E4tze in der Basisabfrage zu reduzieren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273611246229864523)
,p_name=>'APEXIR_CHART_TYPE'
,p_message_language=>'de'
,p_message_text=>'Diagrammtyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274264675671864996)
,p_name=>'APEXIR_CHECK_ALL'
,p_message_language=>'de'
,p_message_text=>unistr('Alle ausw\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273710564705864590)
,p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT'
,p_message_language=>'de'
,p_message_text=>unistr('Format f\00FCr Herunterladen von Bericht ausw\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273813202499864663)
,p_name=>'APEXIR_CLEAR'
,p_message_language=>'de'
,p_message_text=>unistr('l\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273583690634864504)
,p_name=>'APEXIR_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273856548144864693)
,p_name=>'APEXIR_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Spalten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274683741714865291)
,p_name=>'APEXIR_COLUMN_FILTER'
,p_message_language=>'de'
,p_message_text=>'Filtern...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273822959737864670)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_language=>'de'
,p_message_text=>unistr('Spalten\00FCberschrift')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273816942917864665)
,p_name=>'APEXIR_COLUMN_HEADING_MENU'
,p_message_language=>'de'
,p_message_text=>unistr('Men\00FC "Spalten\00FCberschrift"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273827893535864673)
,p_name=>'APEXIR_COLUMN_INFO'
,p_message_language=>'de'
,p_message_text=>'Spalteninformationen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274693923288865298)
,p_name=>'APEXIR_COLUMN_LABEL'
,p_message_language=>'de'
,p_message_text=>'Spaltenbeschriftung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273822637753864669)
,p_name=>'APEXIR_COLUMN_N'
,p_message_language=>'de'
,p_message_text=>'Spalte %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273691919252864577)
,p_name=>'APEXIR_COMPARISON_CONTAINS'
,p_message_language=>'de'
,p_message_text=>unistr('enth\00E4lt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273696669878864580)
,p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN'
,p_message_language=>'de'
,p_message_text=>unistr('enth\00E4lt nicht')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273582013893864503)
,p_name=>'APEXIR_COMPARISON_IN'
,p_message_language=>'de'
,p_message_text=>'in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273696878116864580)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST'
,p_message_language=>'de'
,p_message_text=>'ist nicht in den letzten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273742222692864612)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT'
,p_message_language=>'de'
,p_message_text=>unistr('ist nicht in den n\00E4chsten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273696737039864580)
,p_name=>'APEXIR_COMPARISON_IS_IN_LAST'
,p_message_language=>'de'
,p_message_text=>'ist in den letzten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273742183842864612)
,p_name=>'APEXIR_COMPARISON_IS_IN_NEXT'
,p_message_language=>'de'
,p_message_text=>unistr('ist in den n\00E4chsten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273581952948864503)
,p_name=>'APEXIR_COMPARISON_IS_NOT_NULL'
,p_message_language=>'de'
,p_message_text=>'ist nicht Null'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273581875715864503)
,p_name=>'APEXIR_COMPARISON_IS_NULL'
,p_message_language=>'de'
,p_message_text=>'ist Null'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273581619302864503)
,p_name=>'APEXIR_COMPARISON_LIKE'
,p_message_language=>'de'
,p_message_text=>'wie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273582191410864503)
,p_name=>'APEXIR_COMPARISON_NOT_IN'
,p_message_language=>'de'
,p_message_text=>'nicht in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273581748412864503)
,p_name=>'APEXIR_COMPARISON_NOT_LIKE'
,p_message_language=>'de'
,p_message_text=>'nicht wie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273692618071864577)
,p_name=>'APEXIR_COMPARISON_REGEXP_LIKE'
,p_message_language=>'de'
,p_message_text=>unistr('entspricht regul\00E4rem Ausdruck')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273710440932864590)
,p_name=>'APEXIR_COMPUTATION'
,p_message_language=>'de'
,p_message_text=>'Berechnung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274288453412865013)
,p_name=>'APEXIR_COMPUTATION_EXPRESSION'
,p_message_language=>'de'
,p_message_text=>'Berechnungsausdruck'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273856823865864693)
,p_name=>'APEXIR_COMPUTATION_FOOTER'
,p_message_language=>'de'
,p_message_text=>'Erstellen Sie eine Berechnung mit Spaltenaliasnamen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273856982576864693)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E1'
,p_message_language=>'de'
,p_message_text=>'(B+C)*100'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273857061552864694)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E2'
,p_message_language=>'de'
,p_message_text=>'INITCAP(B)||'', ''||INITCAP(C)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273857168736864694)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E3'
,p_message_language=>'de'
,p_message_text=>'CASE WHEN A = 10 THEN B + C ELSE B END'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273449085854864414)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E4'
,p_message_language=>'de'
,p_message_text=>'ROUND(C / 1000000)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273740246056864611)
,p_name=>'APEXIR_COMPUTE'
,p_message_language=>'de'
,p_message_text=>'Berechnen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273823639436864670)
,p_name=>'APEXIR_CONTROL_BREAK'
,p_message_language=>'de'
,p_message_text=>'Kontrollgruppenwechsel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273831870005864676)
,p_name=>'APEXIR_CONTROL_BREAKS'
,p_message_language=>'de'
,p_message_text=>'Kontrollgruppenwechsel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274712321799865311)
,p_name=>'APEXIR_CONTROL_BREAK_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Gruppenwechselspalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273441253978864409)
,p_name=>'APEXIR_COUNT_DISTINCT'
,p_message_language=>'de'
,p_message_text=>unistr('Nur eindeutige Reihen z\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274704709057865306)
,p_name=>'APEXIR_COUNT_DISTINCT_X'
,p_message_language=>'de'
,p_message_text=>unistr('Nur eindeutige Reihen z\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274704694096865306)
,p_name=>'APEXIR_COUNT_X'
,p_message_language=>'de'
,p_message_text=>'Anzahl %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274307790605865027)
,p_name=>'APEXIR_DAILY'
,p_message_language=>'de'
,p_message_text=>unistr('T\00E4glich')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274797286155865371)
,p_name=>'APEXIR_DATA'
,p_message_language=>'de'
,p_message_text=>'Daten'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273827902814864673)
,p_name=>'APEXIR_DATA_AS_OF'
,p_message_language=>'de'
,p_message_text=>unistr('Bericht f\00FCr Daten im Status vor %0 Minuten erstellen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274659023128865274)
,p_name=>'APEXIR_DATA_GRID_HELP'
,p_message_language=>'de'
,p_message_text=>'Daten-Grid-Hilfe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273612131089864523)
,p_name=>'APEXIR_DATE'
,p_message_language=>'de'
,p_message_text=>'Datum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274703242030865305)
,p_name=>'APEXIR_DAY'
,p_message_language=>'de'
,p_message_text=>'Tag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273854105372864691)
,p_name=>'APEXIR_DEFAULT'
,p_message_language=>'de'
,p_message_text=>'Standard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274701349848865303)
,p_name=>'APEXIR_DEFAULT_REPORT_TYPE'
,p_message_language=>'de'
,p_message_text=>unistr('Standardm\00E4\00DFiger Berichtstyp')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273583809503864505)
,p_name=>'APEXIR_DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273741071207864611)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_language=>'de'
,p_message_text=>unistr('Markierte Elemente l\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273613038091864524)
,p_name=>'APEXIR_DELETE_CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('M\00F6chten Sie diese Berichtseinstellungen l\00F6schen?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273858373700864694)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_language=>'de'
,p_message_text=>unistr('Soll dieser L\00F6schvorgang ausgef\00FChrt werden?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274592038249865227)
,p_name=>'APEXIR_DELETE_DEFAULT_REPORT'
,p_message_language=>'de'
,p_message_text=>unistr('Standardbericht l\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273823346281864670)
,p_name=>'APEXIR_DELETE_REPORT'
,p_message_language=>'de'
,p_message_text=>unistr('Bericht l\00F6schen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273582425474864504)
,p_name=>'APEXIR_DESCENDING'
,p_message_language=>'de'
,p_message_text=>'Absteigend'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273623986578864531)
,p_name=>'APEXIR_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Beschreibung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273816872808864665)
,p_name=>'APEXIR_DETAIL_VIEW'
,p_message_language=>'de'
,p_message_text=>'Single Row-Ansicht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273855106687864692)
,p_name=>'APEXIR_DIRECTION'
,p_message_language=>'de'
,p_message_text=>'Richtung %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273832394014864676)
,p_name=>'APEXIR_DISABLE'
,p_message_language=>'de'
,p_message_text=>'Deaktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273856343307864693)
,p_name=>'APEXIR_DISABLED'
,p_message_language=>'de'
,p_message_text=>'Deaktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273612270761864523)
,p_name=>'APEXIR_DISPLAY'
,p_message_language=>'de'
,p_message_text=>'Anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273583329125864504)
,p_name=>'APEXIR_DISPLAYED'
,p_message_language=>'de'
,p_message_text=>'Angezeigt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273610843756864523)
,p_name=>'APEXIR_DISPLAYED_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Angezeigte Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273855063638864692)
,p_name=>'APEXIR_DISPLAY_IN_REPORT'
,p_message_language=>'de'
,p_message_text=>'In Bericht anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273584058942864505)
,p_name=>'APEXIR_DONUT'
,p_message_language=>'de'
,p_message_text=>'Ring'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273824709709864671)
,p_name=>'APEXIR_DOWN'
,p_message_language=>'de'
,p_message_text=>'Nach unten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273740310665864611)
,p_name=>'APEXIR_DOWNLOAD'
,p_message_language=>'de'
,p_message_text=>'Herunterladen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273612051795864523)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_language=>'de'
,p_message_text=>'- Nicht aggregieren -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273854904507864692)
,p_name=>'APEXIR_DO_NOT_DISPLAY'
,p_message_language=>'de'
,p_message_text=>'Nicht anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274712541980865311)
,p_name=>'APEXIR_DUPLICATE_PIVOT_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Doppelt vorhandene Pivotspalte. Pivotspaltenliste muss eindeutig sein.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274712961600865312)
,p_name=>'APEXIR_EDIT'
,p_message_language=>'de'
,p_message_text=>'Bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274651668210865269)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_language=>'de'
,p_message_text=>'Alternativen Standardwert bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273828140009864673)
,p_name=>'APEXIR_EDIT_CHART'
,p_message_language=>'de'
,p_message_text=>'Diagrammeinstellungen bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273858121051864694)
,p_name=>'APEXIR_EDIT_CHART2'
,p_message_language=>'de'
,p_message_text=>'Diagramm bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273858611241864695)
,p_name=>'APEXIR_EDIT_FILTER'
,p_message_language=>'de'
,p_message_text=>'Filter bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274354563943865060)
,p_name=>'APEXIR_EDIT_GROUP_BY'
,p_message_language=>'de'
,p_message_text=>'"Gruppieren nach" bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273858506975864695)
,p_name=>'APEXIR_EDIT_HIGHLIGHT'
,p_message_language=>'de'
,p_message_text=>'Markierung bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274171215123864928)
,p_name=>'APEXIR_EDIT_PIVOT'
,p_message_language=>'de'
,p_message_text=>'Pivot bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274701639292865304)
,p_name=>'APEXIR_EMAIL'
,p_message_language=>'de'
,p_message_text=>'E-Mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273526963096864466)
,p_name=>'APEXIR_EMAIL_ADDRESS'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Adresse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274701930655865304)
,p_name=>'APEXIR_EMAIL_BCC'
,p_message_language=>'de'
,p_message_text=>'Bcc'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274702106862865304)
,p_name=>'APEXIR_EMAIL_BODY'
,p_message_language=>'de'
,p_message_text=>'Body'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274701849397865304)
,p_name=>'APEXIR_EMAIL_CC'
,p_message_language=>'de'
,p_message_text=>'Cc'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274702838194865304)
,p_name=>'APEXIR_EMAIL_FREQUENCY'
,p_message_language=>'de'
,p_message_text=>unistr('H\00E4ufigkeit')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273561710097864490)
,p_name=>'APEXIR_EMAIL_NOT_CONFIGURED'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr diese Anwendung wurde keine E-Mail konfiguriert. Wenden Sie sich an den Administrator.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274306841879865027)
,p_name=>'APEXIR_EMAIL_REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Die E-Mail-Adresse muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274702218963865304)
,p_name=>'APEXIR_EMAIL_SEE_ATTACHED'
,p_message_language=>'de'
,p_message_text=>'Siehe Anhang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274702083202865304)
,p_name=>'APEXIR_EMAIL_SUBJECT'
,p_message_language=>'de'
,p_message_text=>'Betreff'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274308730802865028)
,p_name=>'APEXIR_EMAIL_SUBJECT_REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Der Betreff der E-Mail muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274701760160865304)
,p_name=>'APEXIR_EMAIL_TO'
,p_message_language=>'de'
,p_message_text=>'An'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273832217119864676)
,p_name=>'APEXIR_ENABLE'
,p_message_language=>'de'
,p_message_text=>'Aktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273580736423864502)
,p_name=>'APEXIR_ENABLED'
,p_message_language=>'de'
,p_message_text=>'Aktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273858451760864695)
,p_name=>'APEXIR_ENABLE_DISABLE_ALT'
,p_message_language=>'de'
,p_message_text=>'Aktivieren/Deaktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273857809947864694)
,p_name=>'APEXIR_ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273857213795864694)
,p_name=>'APEXIR_EXAMPLES'
,p_message_language=>'de'
,p_message_text=>'Beispiele'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273858206034864694)
,p_name=>'APEXIR_EXAMPLES_WITH_COLON'
,p_message_language=>'de'
,p_message_text=>'Beispiele:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273610720440864522)
,p_name=>'APEXIR_EXCLUDE_NULL'
,p_message_language=>'de'
,p_message_text=>unistr('Nullwerte ausschlie\00DFen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273859178932864695)
,p_name=>'APEXIR_EXPAND_COLLAPSE_ALT'
,p_message_language=>'de'
,p_message_text=>'Einblenden/Ausblenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273856068447864693)
,p_name=>'APEXIR_EXPRESSION'
,p_message_language=>'de'
,p_message_text=>'Ausdruck'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273739874444864610)
,p_name=>'APEXIR_FILTER'
,p_message_language=>'de'
,p_message_text=>'Filter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273831786220864676)
,p_name=>'APEXIR_FILTERS'
,p_message_language=>'de'
,p_message_text=>'Filter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273916240903864735)
,p_name=>'APEXIR_FILTER_EXPRESSION'
,p_message_language=>'de'
,p_message_text=>'Filterausdruck'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274779159052865358)
,p_name=>'APEXIR_FILTER_EXPR_TOO_LONG'
,p_message_language=>'de'
,p_message_text=>'Der Filterausdruck ist zu lang.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273916176670864735)
,p_name=>'APEXIR_FILTER_TYPE'
,p_message_language=>'de'
,p_message_text=>'Filtertyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273859364581864695)
,p_name=>'APEXIR_FINDER_ALT'
,p_message_language=>'de'
,p_message_text=>unistr('Zu suchende Spalten ausw\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273740100969864611)
,p_name=>'APEXIR_FLASHBACK'
,p_message_language=>'de'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273855707811864693)
,p_name=>'APEXIR_FLASHBACK_DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>unistr('Mit Flashback Query k\00F6nnen Sie die Daten in dem Status anzeigen, den sie zu einem vorherigen Zeitpunkt hatten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273857646422864694)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_language=>'de'
,p_message_text=>unistr('Flashback-Anforderung kann nicht ausgef\00FChrt werden')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274307404466865027)
,p_name=>'APEXIR_FLASHBACK_LABEL'
,p_message_language=>'de'
,p_message_text=>'Flashback-Dauer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274316012572865033)
,p_name=>'APEXIR_FORMAT'
,p_message_language=>'de'
,p_message_text=>'Formatieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273710360262864590)
,p_name=>'APEXIR_FORMAT_MASK'
,p_message_language=>'de'
,p_message_text=>'Formatmaske %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273823081018864670)
,p_name=>'APEXIR_FUNCTION'
,p_message_language=>'de'
,p_message_text=>'Funktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273856702390864693)
,p_name=>'APEXIR_FUNCTIONS'
,p_message_language=>'de'
,p_message_text=>'Funktionen %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274701209971865303)
,p_name=>'APEXIR_FUNCTIONS_OPERATORS'
,p_message_language=>'de'
,p_message_text=>'Funktionen/Operatoren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274288968155865014)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Funktionsspalte %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273822565544864669)
,p_name=>'APEXIR_FUNCTION_N'
,p_message_language=>'de'
,p_message_text=>'Funktion %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273739657776864610)
,p_name=>'APEXIR_GO'
,p_message_language=>'de'
,p_message_text=>'Los'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274307303314865027)
,p_name=>'APEXIR_GRAY'
,p_message_language=>'de'
,p_message_text=>'Grau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273581264639864503)
,p_name=>'APEXIR_GREEN'
,p_message_language=>'de'
,p_message_text=>unistr('gr\00FCn')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273441337223864409)
,p_name=>'APEXIR_GROUP_BY'
,p_message_language=>'de'
,p_message_text=>'Gruppieren nach'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274702308208865304)
,p_name=>'APEXIR_GROUP_BY_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Nach Spalte %0 gruppieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274182425388864935)
,p_name=>'APEXIR_GROUP_BY_COL_NOT_NULL'
,p_message_language=>'de'
,p_message_text=>'"Nach Spalte gruppieren" muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274288765647865014)
,p_name=>'APEXIR_GROUP_BY_MAX_ROW_CNT'
,p_message_language=>'de'
,p_message_text=>unistr('Die maximale Zeilenanzahl f\00FCr eine "Gruppieren nach"-Abfrage begrenzt die Anzahl der Zeilen in der Basisabfrage, aber nicht die Anzahl der angezeigten Zeilen. Die Basisabfrage \00FCberschreitet die maximale Zeilenanzahl von %0. Wenden Sie einen Filter an')
||unistr(', um die Anzahl der Datens\00E4tze in der Basisabfrage zu reduzieren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274102845513864879)
,p_name=>'APEXIR_GROUP_BY_SORT'
,p_message_language=>'de'
,p_message_text=>'Nach Sortierung gruppieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274712438938865311)
,p_name=>'APEXIR_GROUP_BY_SORT_ORDER'
,p_message_language=>'de'
,p_message_text=>'Nach Sortierfolge gruppieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273611339608864523)
,p_name=>'APEXIR_HCOLUMN'
,p_message_language=>'de'
,p_message_text=>'Horizontale Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273849584833864688)
,p_name=>'APEXIR_HELP'
,p_message_language=>'de'
,p_message_text=>'Hilfe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273815171989864664)
,p_name=>'APEXIR_HELP_01'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('In den interaktiven Berichten k\00F6nnen Endbenutzer Berichte anpassen. Benutzer k\00F6nnen das Layout von Berichtsdaten \00E4ndern, indem sie Spalten ausw\00E4hlen, Filter anwenden, Bereiche markieren oder sortieren. Benutzer k\00F6nnen dar\00FCber hinaus Gruppenwechsel, A')
||unistr('ggregationen, Diagramme und Gruppierungen definieren und ihre eigenen Berechnungen hinzuf\00FCgen. Sie k\00F6nnen auch ein Abonnement einrichten, sodass sie HTML-Versionen des Berichts per E-Mail in einem festgelegten Intervall erhalten. Benutzer k\00F6nnen mehr')
||unistr('ere Varianten eines Berichts erstellen und diese als benannte Berichte speichern, die entweder \00F6ffentlich oder privat angezeigt werden k\00F6nnen.'),
'<p/>',
unistr('In den folgenden Abschnitten wird zusammengefasst, wie Sie einen interaktiven Bericht anpassen k\00F6nnen. Weitere Informationen finden Sie unter "Using Interactive Reports" in <a href="http://www.oracle.com/pls/topic/lookup?ctx=E37097_01&id=AEEUG453" ta')
||'rget="_blank"><i>Oracle Application Express End User''s Guide</i></a>.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273832533286864676)
,p_name=>'APEXIR_HELP_ACTIONS_MENU'
,p_message_language=>'de'
,p_message_text=>unistr('Das Men\00FC "Aktion" wird in der Suchleiste rechts der Schaltfl\00E4che "Los" angezeigt. Mit diesem Men\00FC k\00F6nnen Sie interaktive Berichte anpassen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273816175046864665)
,p_name=>'APEXIR_HELP_AGGREGATE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Aggregate sind mathematische Berechnungen f\00FCr eine Spalte. Aggregate werden nach jedem Kontrollgruppenwechsel und am Ende des Berichts in der Spalte angezeigt, in der sie definiert werden. Zu den Optionen geh\00F6ren:'),
'<p>',
'</p><ul>',
unistr('<li><b>Aggregation</b>: Erm\00F6glicht die Wahl einer vorher'),
'definierten Aggregation zur Bearbeitung.</li>',
unistr('<li><b>Funktion</b>: Ist die auszuf\00FChrende Funktion (z.B. SUM, MIN).</li>'),
unistr('<li><b>Spalte</b>: Wird verwendet, um die Spalte zu w\00E4hlen, f\00FCr die die mathematische Funktion angewendet werden soll. Nur numerische Spalten werden angezeigt.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273816288951864665)
,p_name=>'APEXIR_HELP_CHART'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Sie k\00F6nnen ein Diagramm pro gespeicherten Bericht definieren. Nach der Definition k\00F6nnen Sie mit den Ansichtsymbolen in der Suchleiste zwischen der Diagramm- und Berichtsansicht wechseln. Zu den Optionen geh\00F6ren: '),
'<p>',
'</p><ul>',
'<li><b>Diagrammtyp</b>: Gibt den aufzunehmenden Diagrammtyp an. ',
'Optionen: Horizontaler Balken, Vertikaler Balken, Kreis oder Linie.</li>',
unistr('<li><b>Label</b>: W\00E4hlen Sie die Spalte, die als Label verwendet werden soll.</li>'),
unistr('<li><b>Achsenbeschriftung f\00FCr Label</b>: Diese Beschriftung wird auf der Achse angezeigt, die mit der '),
unistr('als Label ausgew\00E4hlten Spalte verkn\00FCpft ist. Diese Option ist bei Tortendiagrammen nicht verf\00FCgbar.</li>'),
unistr('<li><b>Wert</b>: W\00E4hlen Sie die Spalte, die als Wert verwendet werden soll. Wenn als Funktion '),
unistr('COUNT verwendet wird, muss kein Wert ausgew\00E4hlt werden.</li>'),
unistr('<li><b>Achsenbeschriftung f\00FCr Wert</b>: Diese Beschriftung wird auf der Achse angezeigt, die mit der als'),
unistr('Wert ausgew\00E4hlten Spalte verkn\00FCpft ist. Diese Option ist bei Tortendiagrammen nicht verf\00FCgbar.</li>'),
unistr('<li><b>Funktion</b>: Ist eine optionale Funktion, die f\00FCr die als Wert ausgew\00E4hlte Spalte ausgef\00FChrt werden soll.</li>'),
'<li><b>Sortieren</b>: Zum Sortieren der Ergebnismenge.</li></ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273815597398864664)
,p_name=>'APEXIR_HELP_COLUMN_HEADING_MENU'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Wenn Sie auf eine Spalten\00FCberschrift klicken, wird ein Men\00FC f\00FCr Spalten\00FCberschriften angezeigt. Zu den Optionen geh\00F6ren:'),
'<p/>',
'<ul><li><b>Symbol "Aufsteigend sortieren"</b>: sortiert den Bericht nach Spalte in aufsteigender Reihenfolge.</li>',
'<li><b>Symbol "Absteigend sortieren"</b>: sortiert den Bericht nach Spalte in absteigender Reihenfolge.</li>',
'<li><b>Spalte ausblenden</b>: blendet die Spalte aus.</li>',
unistr('<li><b>Gruppenwechselspalte</b>: erstellt einen Gruppenwechsel f\00FCr die Spalte. Dadurch wird die Spalte als Master-Datensatz aus dem Bericht herausgezogen.</li>'),
unistr('<li><b>Spalteninformationen</b>: zeigt einen Hilfetext zur Spalte an, falls verf\00FCgbar.</li>'),
unistr('<li><b>Textbereich</b> wird zur Eingabe von Suchkriterien verwendet (keine Platzhalter erforderlich). Die Gro\00DF-/Kleinschreibung wird dabei ignoriert. Durch die Eingabe eines Wertes wird die Werteliste am Ende des Men\00FCs gek\00FCrzt. Sie k\00F6nnen dann einen ')
||unistr('Wert vom Ende der Liste ausw\00E4hlen, und der ausgew\00E4hlte Wert wird als Filter mit ''='' erstellt (z.B. <code>column = ''ABC''</code>). Alternativ k\00F6nnen Sie auf das Taschenlampensymbol klicken und einen Wert eingeben, der dann als Filter mit dem Modifier ''')
||'LIKE'' erstellt wird (z.B. <code>column LIKE ''%ABC%''</code>).',
unistr('<li> <b>Liste mit eindeutigen Werten</b> enth\00E4lt die ersten 500 eindeutigen Werte, die den Filterkriterien entsprechen. Wenn die Spalte ein Datum darstellt, wird stattdessen eine Liste mit Datumsbereichen angezeigt. Wenn Sie einen Wert ausw\00E4hlen, wir')
||'d ein Filter mit ''='' erstellt (z.B. <code>column = ''ABC''</code>).</li> </ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273816097436864665)
,p_name=>'APEXIR_HELP_COMPUTE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('L\00E4sst Sie berechnete Spalten zu dem Bericht hinzuf\00FCgen. Dabei kann es sich um mathematische Berechnungen (z.B. <code>NBR_HOURS/24</code>) oder Oracle-Standardfunktionen handeln, die f\00FCr vorhandene Spalten angewendet werden. Einige werden als Beispiel')
||unistr(' angezeigt, andere, wie <code>TO_DATE</code>, k\00F6nnen ebenfalls verwendet werden. Zu den Optionen geh\00F6ren:'),
'<p/>',
unistr('<ul><li><b>Berechnung</b>: Erm\00F6glicht die Wahl einer vorher definierten Berechnung zur Bearbeitung.</li>'),
unistr('<li><b>Spalten\00FCberschrift</b>: Ist die Spalten\00FCberschrift f\00FCr die neue Spalte.</li>'),
unistr('<li><b>Formatmaske</b>: Ist eine Oracle-Formatmaske, die f\00FCr die Spalte angewendet werden soll (z.B. S9999).</li>'),
unistr('<li><b>Berechnung</b>: Ist die auszuf\00FChrende Berechnung. Innerhalb der Berechnung werden Spalten mit den angezeigten Aliasnamen referenziert.</li>'),
'</ul>',
unistr('<p>Unter der Berechnung werden die Spalten in der Abfrage mit den zugeh\00F6rigen Aliasnamen angezeigt. Wenn Sie auf den Spalten- oder Aliasnamen klicken, wird dieser in die Berechnung eingef\00FCgt. Neben "Spalten" befindet sich eine Zehnertastatur. Sie ent')
||unistr('h\00E4lt Shortcuts f\00FCr h\00E4ufig verwendete Tasten. Ganz au\00DFen rechts stehen Funktionen</p>'),
unistr('<p>Eine Beispielberechnung zur Anzeige der Gesamtverg\00FCtung folgt:'),
'<p/>',
'<pre>CASE WHEN A = ''SALES'' THEN B + C ELSE B END</pre>',
'(wobei A ORGANIZATION [Unternehmen], B SALARY [Gehalt] und C COMMISSION [Provision] ist)</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273832653603864676)
,p_name=>'APEXIR_HELP_CONTROL_BREAK'
,p_message_language=>'de'
,p_message_text=>'Wird verwendet, um einen Gruppenwechsel auf einer oder mehreren Spalten zu erstellen. Dadurch werden die Spalten aus dem interaktiven Bericht herausgezogen und als Master-Datensatz angezeigt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273816717186864665)
,p_name=>'APEXIR_HELP_DETAIL_VIEW'
,p_message_language=>'de'
,p_message_text=>unistr('Um die Details von jeweils einer Zeile anzuzeigen, klicken Sie auf das Symbol f\00FCr die Single Row-Ansicht in der Zeile, die angezeigt werden soll. Wenn verf\00FCgbar, ist die Single Row-Ansicht immer die erste Spalte. Je nach Anpassung des interaktiven Be')
||unistr('richts kann die Single Row-Ansicht eine Standardansicht oder eine benutzerdefinierte Seite sein, die eine Aktualisierung zul\00E4sst.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273816613922864665)
,p_name=>'APEXIR_HELP_DOWNLOAD'
,p_message_language=>'de'
,p_message_text=>unistr('Erm\00F6glicht das Herunterladen der aktuellen Ergebnismenge. Die Downloadformate variieren je nach Installation und Berichtsdefinition, k\00F6nnen jedoch CSV, HTML, E-Mail, XLS, PDF oder RTF umfassen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273815758722864664)
,p_name=>'APEXIR_HELP_FILTER'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Fokussiert den Bericht durch Hinzuf\00FCgen oder \00C4ndern der <code>WHERE</code>-Klausel der Abfrage. Sie k\00F6nnen nach Spalte oder Zeile filtern.   '),
unistr('<p>IWenn Sie nach Spalte filtern, ausw\00E4hlen Sie zun\00E4chst eine Spalte (nicht unbedingt die angezeigte Spalte). W\00E4hlen Sie dann einen Operator aus der Liste mit Oracle-Standardoperatoren (=, !=, nicht in, zwischen), und geben Sie einen Ausdruck f\00FCr den')
||unistr(' Vergleich ein. Beim Ausdruck muss die Gro\00DF-/Kleinschreibung beachtet werden. Sie k\00F6nnen % als Platzhalterzeichen verwenden (Beispiel: <code>STATE_NAME wie A%)</code>.</p>'),
unistr('<p>Wenn Sie nach Zeile filtern, k\00F6nnen Sie komplexe <code>WHERE</code>-Klauseln mit'),
unistr('Spaltenaliasnamen und beliebigen Oracle-Funktionen oder -Operatoren erstellen (Beispiel: <code>G = ''VA'' oder G = ''CT''</code>, wobei <code>G</code> der Alias f\00FCr <code>CUSTOMER_STATE</code> ist).</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273816365693864665)
,p_name=>'APEXIR_HELP_FLASHBACK'
,p_message_language=>'de'
,p_message_text=>unistr('Flashback Query erm\00F6glicht Ihnen, die Daten in dem Status anzuzeigen, den sie zu einem fr\00FCheren Zeitpunkt hatten. Die Standardzeit f\00FCr das Flashback betr\00E4gt 3 Stunden (oder 180 Minuten), die tats\00E4chliche Zeit differiert jedoch je nach Datenbank.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274315988520865033)
,p_name=>'APEXIR_HELP_FORMAT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Mit der Option "Formatieren" k\00F6nnen Sie das Erscheinungsbild des Berichts anpassen.'),
unistr('"Formatieren" enth\00E4lt das folgende Untermen\00FC:</p>'),
'<ul><li>Sortieren</li>',
'<li>Kontrollgruppenwechsel</li>',
'<li>Markieren</li>',
'<li>Berechnen</li>',
'<li>Aggregieren</li>',
'<li>Diagramm</li>',
'<li>Gruppieren nach</li>',
'<li>Pivot</li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274306606873865026)
,p_name=>'APEXIR_HELP_GROUP_BY'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Pro gespeicherten Bericht k\00F6nnen Sie eine Ansicht "Gruppieren nach" definieren. '),
unistr('Nach der Definition k\00F6nnen Sie zwischen den "Gruppieren nach"- und den Berichtsansichten umschalten. '),
unistr('Verwenden Sie hierf\00FCr die Ansichtssymbole in der Suchleiste. Um eine Ansicht "Gruppieren nach" zu erstellen,'),
unistr('w\00E4hlen Sie:'),
'<p></p><ul>',
'<li>die Spalten, nach denen gruppiert werden soll</li>',
unistr('<li>die Spalten, die zusammen mit der auszuf\00FChrenden Funktion (Durchschnitt, Summe, Anzahl usw.) aggregiert werden sollen</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273815949879864665)
,p_name=>'APEXIR_HELP_HIGHLIGHT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erm\00F6glicht Ihnen, Filter zu definieren. Die Zeilen, die den Filterkriterien entsprechen, werden entsprechend den Eigenschaften markiert, die mit dem Filter verkn\00FCpft sind. Zu den Optionen geh\00F6ren:'),
'<p/>',
'<ul><li><b>Name</b>: Wird nur zur Anzeige verwendet.</li>',
'<li><b>Sequenz</b>: Gibt die Reihenfolge an, in der die Regeln ausgewertet werden.</li>',
'<li><b>Aktiviert</b>: Gibt an, ob die Regel aktiviert oder deaktiviert ist.</li>',
unistr('<li><b>Markierungstyp</b>: Gibt an, ob die Zeile oder Zelle markiert werden soll. Wenn "Zelle" ausgew\00E4hlt wird, wird die Spalte markiert, die in der Markierungsbedingung referenziert wird.</li>'),
unistr('<li><b>Hintergrundfarbe</b>: Ist die neue Farbe f\00FCr den Hintergrund des markierten Bereichs.</li>'),
unistr('<li><b>Textfarbe</b>: Ist die neue Farbe f\00FCr den Text im markierten Bereich.</li>'),
'<li><b>Markierungsbedingung</b>: Definiert Ihre Filterbedingung.</li></ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273412662761864390)
,p_name=>'APEXIR_HELP_PIVOT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Sie k\00F6nnen eine Pivot-Ansicht pro gespeicherten Bericht definieren. Nach der Definition k\00F6nnen Sie zwischen der Pivot- und Berichtsansicht mit Ansichtsymbolen in der Suchleiste wechseln. Um eine Pivot-Ansicht zu erstellen, w\00E4hlen Sie Folgendes: '),
'<p></p>',
'<ul>',
'<li>die Spalten, die pivotiert werden sollen</li>',
'<li>die Spalten, die als Zeilen angezeigt werden sollen</li>',
unistr('<li>die Spalten, die zusammen mit der auszuf\00FChrenden Funktion aggregiert werden sollen (Durchschnitt, Summe, Anzahl usw.)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273857436645864694)
,p_name=>'APEXIR_HELP_REPORT_SETTINGS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Wenn Sie einen interaktiven Bericht anpassen, werden die Berichtseinstellungen unter der Suchleiste und \00FCber dem Bericht angezeigt. Dieser Bereich kann mit dem Symbol auf der linken Seite aus- und eingeblendet werden.'),
'<p/>',
unistr('Sie k\00F6nnen f\00FCr Berichtseinstellungen folgende Aktionen durchf\00FChren:'),
'</p><ul>',
'<li>Bearbeiten</b>, indem Sie auf den Namen klicken.</li>',
unistr('<li><b>Deaktivieren/Aktivieren</b>, indem Sie das Kontrollk\00E4stchen "Aktivieren/Deaktivieren" w\00E4hlen oder die Wahl aufheben. Diese Option wird verwendet, um die Einstellung vor\00FCbergehend ein- und auszuschalten.</li>'),
unistr('<li><b>Entfernen</b>, indem Sie auf das Symbol f\00FCr Entfernen klicken.</li></ul>'),
'<p/>',
unistr('Wenn Sie ein Diagramm, "Gruppieren nach" oder "Pivot" erstellt haben, k\00F6nnen Sie mit den Links "Berichtsansicht", "Diagrammansicht" und "Nach Ansicht gruppieren" und "Pivot-Ansicht" '),
unistr('auf der rechten Seite zwischen den Diagrammen und dem Basisbericht umschalten. Im Diagramm oder der Ansicht "Gruppieren nach" k\00F6nnen Sie auch den Link "Bearbeiten" verwenden, um die Einstellungen zu bearbeiten.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273816535898864665)
,p_name=>'APEXIR_HELP_RESET'
,p_message_language=>'de'
,p_message_text=>unistr('Setzt den Bericht auf die Standardeinstellungen zur\00FCck, wobei von Ihnen vorgenommene Anpassungen entfernt werden. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274316295124865033)
,p_name=>'APEXIR_HELP_ROWS_PER_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Legt die Anzahl der pro Seite anzuzeigenden Datens\00E4tze fest')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273816489637864665)
,p_name=>'APEXIR_HELP_SAVE_REPORT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Speichert den angepassten Bericht f\00FCr die sp\00E4tere Verwendung. Sie k\00F6nnen einen Namen und eine optionale Beschreibung eingeben und den Bericht \00F6ffentlich zug\00E4nglich machen (bzw. den Zugriff allen Benutzern erm\00F6glichen, die auf den prim\00E4ren Standard')
||unistr('bericht zugreifen k\00F6nnen). Es k\00F6nnen vier Arten interaktiver Berichte gespeichert werden:</p>'),
'<ul>',
unistr('<li><strong>Prim\00E4rstandard</strong> (nur Entwickler). Prim\00E4rstandardberichte werden urspr\00FCnglich angezeigt. Solche Berichte k\00F6nnen weder umbenannt noch gel\00F6scht werden.</li>'),
unistr('<li><strong>Alternativer Bericht</strong> (Nur Entwickler). Erlaubt Entwicklern die Erstellung von Berichten mit mehreren Layouts. Nur Entwickler k\00F6nnen alternative Berichte sichern, umbenennen oder l\00F6schen.</li>'),
unistr('<li><strong>\00D6ffentliche Berichte</strong> (Endbenutzer). Diese Berichte k\00F6nnen von dem erstellenden Endbenutzer gespeichert, umbenannt und gel\00F6scht werden. Andere Benutzer k\00F6nnen das Layout als weiteren Bericht anzeigen und speichern.</li>'),
unistr('<li><strong>Private Berichte</strong> (Endbenutzer). Diese Berichte kann nur der erstellende Endbenutzer anzeigen, speichern, umbenennen oder l\00F6schen.</li>'),
'</ul>',
'<p>Wenn Sie angepasste Berichte speichern, dann wird der Berichtsselektor in der Suchleiste links des Spaltenselektors angezeigt (falls dieses Feature aktiviert ist).</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273815447492864664)
,p_name=>'APEXIR_HELP_SEARCH_BAR'
,p_message_language=>'de'
,p_message_text=>unistr('Im oberen Bereich der einzelnen Berichtsseiten befindet sich eine Suchregion. Diese Region (bzw. die Suchleiste) enth\00E4lt die folgenden Features:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274316880062865034)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ACTIONS_MENU'
,p_message_language=>'de'
,p_message_text=>unistr('<li>Das <b>Aktionsmen\00FC</b> erm\00F6glicht die Anpassung von Berichten. Weitere Informationen finden Sie in den folgenden Abschnitten.</li>')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274316387482865033)
,p_name=>'APEXIR_HELP_SEARCH_BAR_FINDER'
,p_message_language=>'de'
,p_message_text=>unistr('Mit dem Symbol <li><b>Spalten ausw\00E4hlen</b> k\00F6nnen Sie angeben, welche Spalten durchsucht werden sollen, bzw. ob alle Spalten durchsucht werden sollen.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274316693560865034)
,p_name=>'APEXIR_HELP_SEARCH_BAR_REPORTS'
,p_message_language=>'de'
,p_message_text=>unistr('In <li><b>Berichte</b> werden verschiedene Standardwerte und gespeicherte private oder \00F6ffentliche Berichte angezeigt.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274316597472865033)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ROWS'
,p_message_language=>'de'
,p_message_text=>unistr('In <li><b>Zeilen</b> wird die Anzahl der pro Seite anzuzeigenden Datens\00E4tze angezeigt.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274316460679865033)
,p_name=>'APEXIR_HELP_SEARCH_BAR_TEXTBOX'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li>Im <b>Textbereich</b> k\00F6nnen Sie Suchkriterien eingeben, bei denen die Gro\00DF-/Kleinschreibung nicht beachtet werden muss (Platzhalterzeichen sind impliziert).</li>'),
unistr('<li><b>Schaltfl\00E4che "Los"</b> f\00FChrt die Suche durch. Wenn Sie die Eingabetaste dr\00FCcken, w\00E4hrend sich der Cursor im Suchtextbereich befindet, wird die Suche ebenfalls ausgef\00FChrt.</li>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274316780214865034)
,p_name=>'APEXIR_HELP_SEARCH_BAR_VIEW'
,p_message_language=>'de'
,p_message_text=>'<li><b>Ansicht-Symbole</b> wechselt zwischen Symbol-, Berichts-, Detail-, Diagramm-, Gruppieren nach- und Pivot-Ansicht des Berichts, sofern definiert.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274659191030865274)
,p_name=>'APEXIR_HELP_SEARCH_BAR_WS_MANAGE'
,p_message_language=>'de'
,p_message_text=>unistr('<li><b>Verwalten</b> erm\00F6glicht es, die Eigenschaften, Spalten, Zeilen und die Anzeigenhistorie eines Berichts oder Daten-Grids zu verwalten.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273815644982864664)
,p_name=>'APEXIR_HELP_SELECT_COLUMNS'
,p_message_language=>'de'
,p_message_text=>unistr('Wird zur \00C4nderung der angezeigten Spalten verwendet. Die Spalten auf der rechten Seite werden angezeigt. Die Spalten auf der linken Seite werden ausgeblendet. Sie k\00F6nnen die angezeigten Spalten mit den Pfeilen ganz au\00DFen rechts neu anordnen. Vor bere')
||'chneten Spalten steht <b>**</b>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273815884137864665)
,p_name=>'APEXIR_HELP_SORT'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Wird verwendet, um die zu sortierenden Spalten zu wechseln und anzugeben, ob in aufsteigender oder absteigender Reihenfolge sortiert werden soll. Sie k\00F6nnen auch angeben, wie <code>Nullwerte</code> behandelt werden sollen. Die Standardeinstellung ')
||unistr('zeigt die <code>Nullwerte</code> immer am Ende an; Sie k\00F6nnen sie alternativ immer am Anfang anzeigen. Die Ergebnissortierung wird rechts neben den Spalten\00FCberschriften im Bericht angezeigt.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274306259398865026)
,p_name=>'APEXIR_HELP_SUBSCRIPTION'
,p_message_language=>'de'
,p_message_text=>unistr('Wenn Sie eine Subscription hinzuf\00FCgen, geben Sie E-Mail-Adresse (oder mehrere, durch Komma getrennte E-Mail-Adressen), E-Mail-Betreff, H\00E4ufigkeit sowie die Angaben zum Start- und Enddatum ein. Die resultierenden E-Mails enthalten eine HTML-Version de')
||unistr('s interaktiven Berichts. Sie enthalten die aktuellen Daten mit den Berichtseinstellungen, die bei Hinzuf\00FCgen der Subscription vorhanden waren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274658603055865274)
,p_name=>'APEXIR_HELP_WS_01'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Daten-Grids sind im Grunde Berichte, die bearbeitet und hochgradig angepasst werden k\00F6nnen. Benutzer k\00F6nnen das Layout von Berichtsdaten \00E4ndern, indem sie Spalten ausw\00E4hlen, Filter anwenden, Bereiche hervorheben und sortieren. Sie k\00F6nnen dar\00FCber hina')
||unistr('us Gruppenwechsel, Aggregationen, verschiedene Diagramme und Gruppierungen definieren und ihre eigenen Berechnungen hinzuf\00FCgen. Benutzer k\00F6nnen mehrere Variationen eines Berichts erstellen und diese als benannte Berichte speichern, die privat angezei')
||unistr('gt werden k\00F6nnen.'),
'<p/>',
unistr('Ein Daten-Grid kann \00FCber die Suchleiste, im Men\00FC "Aktionen", im Men\00FC "Verwaltung" oder im Men\00FC "Spalten\00FCberschrift" angepasst werden.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274711035745865310)
,p_name=>'APEXIR_HELP_WS_ACTIONS_MENU'
,p_message_language=>'de'
,p_message_text=>unistr('Das Men\00FC "Aktionen" wird in der Suchleiste rechts der Schaltfl\00E4che "Los" angezeigt. Mit diesem Men\00FC k\00F6nnen Sie Daten-Grid-Berichte anpassen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274659412173865274)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT'
,p_message_language=>'de'
,p_message_text=>unistr('Zeilenseite hinzuf\00FCgen/bearbeiten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274659519202865274)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT_ROW'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Klicken Sie auf "Zeile hinzuf\00FCgen", um dem Daten-Grid eine Zeile hinzuzuf\00FCgen. Klicken Sie in der zu bearbeitenden Zeile auf das Symbol f\00FCr die Zeilenbearbeitung (erste Spalte), um die Zeilendetails zu bearbeiten. Die Seite "Zeile hinzuf\00FCgen/bearb')
||'eiten" wird mit den Zeilen des Daten-Grids angezeigt. </p>',
'',
unistr('<p>Die Optionen f\00FCr das Bearbeiten von Zeilen sind:</p>'),
'',
'<p><ul>',
unistr('<li><b>L\00F6schen</b>: Die Zeile wird gel\00F6scht.</li>'),
unistr('<li><b>\00C4nderungen anwenden</b>: Die an der Zeile vorgenommenen \00C4nderungen werden gespeichert.</li>'),
unistr('<li><b>Aktionen</b>: Dient zum Hinzuf\00FCgen von Zeilen, Dateien, Anmerkungen, Links oder Tags und zum Pr\00FCfen der Historie.</li>'),
unistr('<li><b>N\00E4chsten und Vorherigen</b>: Dient zum Navigieren zur n\00E4chsten/vorherigen Zeile.</li>'),
'<li><b>Verwalten</b>: Dient zum Einrichten von Spalteneigenschaften, Spaltengruppen, Vaildierungen und Wertelisten.</li>',
'</ul></p>',
'',
unistr('<p>Der Bereich "Annotationen" im unteren Abschnitt der Seite zeigt alle mit der aktuellen Zeile verkn\00FCpften Dateien, Anmerkungen, Links oder Tags.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274711169343865310)
,p_name=>'APEXIR_HELP_WS_CONTROL_BREAK'
,p_message_language=>'de'
,p_message_text=>'Wird verwendet, um einen Gruppenwechsel auf einer oder mehreren Spalten zu erstellen. Dadurch werden die Spalten aus dem Daten-Grid herausgezogen und als Master-Datensatz angezeigt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274659372450865274)
,p_name=>'APEXIR_HELP_WS_DOWNLOAD'
,p_message_language=>'de'
,p_message_text=>unistr('Erm\00F6glicht das Herunterladen der aktuellen Ergebnismenge. Zu den Downloadformaten geh\00F6ren CSV, HTML und E-Mail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274711270985865310)
,p_name=>'APEXIR_HELP_WS_REPORT_SETTINGS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Wenn Sie einen Daten-Grid-Bericht anpassen, werden die Berichtseinstellungen unter der Suchleiste und \00FCber dem Bericht angezeigt. Dieser Bereich kann mit dem Symbol auf der linken Seite aus- und eingeblendet werden.'),
'<p/>',
unistr('Sie k\00F6nnen f\00FCr Berichtseinstellungen folgende Aktionen durchf\00FChren:'),
'</p><ul>',
'<li>Bearbeiten Sie eine Einstellung. indem Sie auf den Namen klicken.</li>',
unistr('<li>Deaktivieren/aktivieren Sie eine Einstellung, indem Sie das Kontrollk\00E4stchen "Aktivieren/Deaktivieren" ausw\00E4hlen oder die Wahl aufheben. Diese Option wird verwendet, um die Einstellung vor\00FCbergehend ein- und auszuschalten.</li>'),
unistr('<li>Entfernen Sie eine Einstellung, indem Sie auf das Symbol f\00FCr Entfernen klicken.</li>'),
'</ul>',
unistr('Wenn Sie ein Diagramm oder eine Ansicht "Gruppieren nach" erstellt haben, k\00F6nnen Sie mit den Links'),
' "Berichtsansicht", "Diagrammansicht" und "Nach Ansicht gruppieren" auf der rechten Seite zwischen',
' den Diagrammen und dem Basisbericht umschalten. Im Diagramm oder der Ansicht "Gruppieren nach" ',
unistr('k\00F6nnen Sie auch den Link "Bearbeiten" verwenden, um die Einstellungen zu bearbeiten.</p><p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274659264668865274)
,p_name=>'APEXIR_HELP_WS_SAVE_REPORT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Speichert das angepasste Layout des Daten-Grid-Berichts f\00FCr die sp\00E4tere Verwendung. Sie k\00F6nnen einen Namen und eine optionale Beschreibung eingeben. Es k\00F6nnen drei Layoutarten f\00FCr Daten-Grid-Berichte gespeichert werden:</p>'),
'<ul>',
unistr('<li><strong>Prim\00E4rstandard</strong> (nur Administrator). Prim\00E4rstandardlayouts werden urspr\00FCnglich angezeigt. Solche Berichte k\00F6nnen weder umbenannt noch gel\00F6scht werden.</li>'),
unistr('<li><strong>Alternativer Bericht</strong> (Nur Administrator). Erlaubt Administratoren die Erstellung von Berichten mit mehreren Layouts. Nur Administratoren k\00F6nnen alternative Berichte sichern, umbenennen oder l\00F6schen.</li>'),
unistr('<li><strong>Private Berichte</strong> (Alle Benutzer). Diese Berichtslayouts k\00F6nnen vom erstellenden Benutzer angezeigt, gespeichert, umbenannt oder gel\00F6scht werden.</li>'),
'</ul>',
'<p>Wenn Sie angepasste Berichte speichern, dann wird die Berichtsauswahl in der Suchleiste links der Spaltenauswahl angezeigt (falls dieses Feature aktiviert ist).</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273827780230864673)
,p_name=>'APEXIR_HIDE_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Spalte ausblenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273740020259864611)
,p_name=>'APEXIR_HIGHLIGHT'
,p_message_language=>'de'
,p_message_text=>'Markierung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273831971206864676)
,p_name=>'APEXIR_HIGHLIGHTS'
,p_message_language=>'de'
,p_message_text=>'Markierungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273857577504864694)
,p_name=>'APEXIR_HIGHLIGHT_CONDITION'
,p_message_language=>'de'
,p_message_text=>'Markierungsbedingung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274307189148865027)
,p_name=>'APEXIR_HIGHLIGHT_STYLE'
,p_message_language=>'de'
,p_message_text=>unistr('Stil f\00FCr Hervorheben')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273580863107864503)
,p_name=>'APEXIR_HIGHLIGHT_TYPE'
,p_message_language=>'de'
,p_message_text=>'Markierungstyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273581532615864503)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_language=>'de'
,p_message_text=>'Markieren wenn'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274667753277865280)
,p_name=>'APEXIR_HORIZONTAL'
,p_message_language=>'de'
,p_message_text=>'Horizontal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274771298507865353)
,p_name=>'APEXIR_INACTIVE_SETTING'
,p_message_language=>'de'
,p_message_text=>'1 inaktive Einstellung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274771335527865353)
,p_name=>'APEXIR_INACTIVE_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'%0 inaktive Einstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273817129626864665)
,p_name=>'APEXIR_INTERACTIVE_REPORT_HELP'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu interaktivem Bericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273858897094864695)
,p_name=>'APEXIR_INVALID'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltig')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273830487524864675)
,p_name=>'APEXIR_INVALID_COMPUTATION'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltiger Berechnungsausdruck. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273527971954864467)
,p_name=>'APEXIR_INVALID_END_DATE'
,p_message_language=>'de'
,p_message_text=>'Das Enddatum muss nach dem Anfangdatum liegen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273977240011864790)
,p_name=>'APEXIR_INVALID_FILTER'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltiger Filterausdruck. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274703847797865305)
,p_name=>'APEXIR_INVALID_FILTER_QUERY'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige Filterabfrage')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274771434631865353)
,p_name=>'APEXIR_INVALID_SETTING'
,p_message_language=>'de'
,p_message_text=>unistr('1 ung\00FCltige Einstellung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274771572178865353)
,p_name=>'APEXIR_INVALID_SETTINGS'
,p_message_language=>'de'
,p_message_text=>unistr('%0 ung\00FCltige Einstellungen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274307518954865027)
,p_name=>'APEXIR_IN_MINUTES'
,p_message_language=>'de'
,p_message_text=>'(in Minuten)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274650666828865268)
,p_name=>'APEXIR_IS_IN_THE_LAST'
,p_message_language=>'de'
,p_message_text=>'%0 ist in den letzten %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274650923766865268)
,p_name=>'APEXIR_IS_IN_THE_NEXT'
,p_message_language=>'de'
,p_message_text=>unistr('%0 ist in den n\00E4chsten %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274650883104865268)
,p_name=>'APEXIR_IS_NOT_IN_THE_LAST'
,p_message_language=>'de'
,p_message_text=>'%0 ist nicht in den letzten %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274651023052865268)
,p_name=>'APEXIR_IS_NOT_IN_THE_NEXT'
,p_message_language=>'de'
,p_message_text=>unistr('%0 ist nicht in den n\00E4chsten %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273856670993864693)
,p_name=>'APEXIR_KEYPAD'
,p_message_language=>'de'
,p_message_text=>'Zehnertastatur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273611803349864523)
,p_name=>'APEXIR_LABEL'
,p_message_language=>'de'
,p_message_text=>'Beschriftung %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273825317213864671)
,p_name=>'APEXIR_LABEL_AXIS_TITLE'
,p_message_language=>'de'
,p_message_text=>unistr('Achsenbeschriftung f\00FCr Label')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274172683670864929)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_language=>'de'
,p_message_text=>unistr('Labelpr\00E4fix')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273744294611864614)
,p_name=>'APEXIR_LAST_DAY'
,p_message_language=>'de'
,p_message_text=>'Letzter Tag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273744436925864614)
,p_name=>'APEXIR_LAST_HOUR'
,p_message_language=>'de'
,p_message_text=>'Letzte Stunde'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273743914911864613)
,p_name=>'APEXIR_LAST_MONTH'
,p_message_language=>'de'
,p_message_text=>'Letzter Monat'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273744047254864613)
,p_name=>'APEXIR_LAST_WEEK'
,p_message_language=>'de'
,p_message_text=>'Letzte Woche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273744174653864613)
,p_name=>'APEXIR_LAST_X_DAYS'
,p_message_language=>'de'
,p_message_text=>'Letzte %0 Tage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273744311678864614)
,p_name=>'APEXIR_LAST_X_HOURS'
,p_message_language=>'de'
,p_message_text=>'Letzte %0 Stunden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273743721966864613)
,p_name=>'APEXIR_LAST_X_YEARS'
,p_message_language=>'de'
,p_message_text=>'Letzte %0 Jahre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273743836679864613)
,p_name=>'APEXIR_LAST_YEAR'
,p_message_language=>'de'
,p_message_text=>'Letztes Jahr'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273611608198864523)
,p_name=>'APEXIR_LINE'
,p_message_language=>'de'
,p_message_text=>'Zeile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273583997177864505)
,p_name=>'APEXIR_LINE_WITH_AREA'
,p_message_language=>'de'
,p_message_text=>unistr('Linien/Fl\00E4chen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274290832201865015)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Klicken Sie <a href=''%0''>hier</a>, um die Subscription zu verwalten.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274703749678865305)
,p_name=>'APEXIR_MAP_IT'
,p_message_language=>'de'
,p_message_text=>'Zuordnen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273828387509864673)
,p_name=>'APEXIR_MAX_QUERY_COST'
,p_message_language=>'de'
,p_message_text=>unistr('Die Abfrage wird wahrscheinlich die maximal zul\00E4ssigen Ressourcen \00FCberschreiten. \00C4ndern Sie die Berichteinstellungen, und wiederholen Sie den Vorgang.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273696559607864580)
,p_name=>'APEXIR_MAX_ROW_CNT'
,p_message_language=>'de'
,p_message_text=>unistr('Die maximale Anzahl der Zeilen f\00FCr diesen Bericht ist %0. Wenden Sie einen Filter an, um die Anzahl der Datens\00E4tze in der Abfrage zu reduzieren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274704328890865306)
,p_name=>'APEXIR_MAX_X'
,p_message_language=>'de'
,p_message_text=>'Maximum %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274704574729865306)
,p_name=>'APEXIR_MEDIAN_X'
,p_message_language=>'de'
,p_message_text=>'Mittelwert %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273710220590864590)
,p_name=>'APEXIR_MIN_AGO'
,p_message_language=>'de'
,p_message_text=>'vor %0 Minuten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274704411139865306)
,p_name=>'APEXIR_MIN_X'
,p_message_language=>'de'
,p_message_text=>'Minimum %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274703340979865305)
,p_name=>'APEXIR_MONTH'
,p_message_language=>'de'
,p_message_text=>'Monat'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274307901178865027)
,p_name=>'APEXIR_MONTHLY'
,p_message_language=>'de'
,p_message_text=>'Monatlich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273859076770864695)
,p_name=>'APEXIR_MORE_DATA'
,p_message_language=>'de'
,p_message_text=>'Weitere Daten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273824256402864671)
,p_name=>'APEXIR_MOVE'
,p_message_language=>'de'
,p_message_text=>'Verschieben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273824113819864670)
,p_name=>'APEXIR_MOVE_ALL'
,p_message_language=>'de'
,p_message_text=>'Alle verschieben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274789611740865366)
,p_name=>'APEXIR_MULTIIR_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_language=>'de'
,p_message_text=>unistr('Die statische Regions-ID muss angegeben werden, da die Seite mehrere interaktive Berichte enth\00E4lt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273582697603864504)
,p_name=>'APEXIR_NAME'
,p_message_language=>'de'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273813543610864663)
,p_name=>'APEXIR_NEW_AGGREGATION'
,p_message_language=>'de'
,p_message_text=>'Neue Aggregation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273605846141864519)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_language=>'de'
,p_message_text=>'- Neue Kategorie -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274772972739865354)
,p_name=>'APEXIR_NEW_CATEGORY_LABEL'
,p_message_language=>'de'
,p_message_text=>'Neue Kategorie'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273813670373864663)
,p_name=>'APEXIR_NEW_COMPUTATION'
,p_message_language=>'de'
,p_message_text=>'Neue Berechnung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273738322601864609)
,p_name=>'APEXIR_NEXT'
,p_message_language=>'de'
,p_message_text=>'Weiter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273744815879864614)
,p_name=>'APEXIR_NEXT_DAY'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chster Tag')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273744604252864614)
,p_name=>'APEXIR_NEXT_HOUR'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste Stunde')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273745190748864614)
,p_name=>'APEXIR_NEXT_MONTH'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chster Monat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273745078871864614)
,p_name=>'APEXIR_NEXT_WEEK'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste Woche')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273744927870864614)
,p_name=>'APEXIR_NEXT_X_DAYS'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste %0 Tage')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273744799778864614)
,p_name=>'APEXIR_NEXT_X_HOURS'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste %0 Stunden')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273745370539864614)
,p_name=>'APEXIR_NEXT_X_YEARS'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chste %0 Jahre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273745293485864614)
,p_name=>'APEXIR_NEXT_YEAR'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chstes Jahr')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273582928195864504)
,p_name=>'APEXIR_NO'
,p_message_language=>'de'
,p_message_text=>'Nein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273859213062864695)
,p_name=>'APEXIR_NONE'
,p_message_language=>'de'
,p_message_text=>'- Keine -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274306949588865027)
,p_name=>'APEXIR_NOT_VALID_EMAIL'
,p_message_language=>'de'
,p_message_text=>unistr('Keine g\00FCltige E-Mail-Adresse.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273741135149864611)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_language=>'de'
,p_message_text=>'Keine Aggregation definiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273695359501864579)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_language=>'de'
,p_message_text=>unistr('Keine Spalteninformationen verf\00FCgbar.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273741208248864611)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_language=>'de'
,p_message_text=>'Keine Berechnung definiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274703159172865305)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_language=>'de'
,p_message_text=>'- Kein Enddatum -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273854362105864692)
,p_name=>'APEXIR_NULLS_ALWAYS_FIRST'
,p_message_language=>'de'
,p_message_text=>'Nullwerte immer am Anfang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273854218492864692)
,p_name=>'APEXIR_NULLS_ALWAYS_LAST'
,p_message_language=>'de'
,p_message_text=>'Nullwerte immer am Ende'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273855292462864692)
,p_name=>'APEXIR_NULL_SORTING'
,p_message_language=>'de'
,p_message_text=>'Keine Sortierung %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273830557243864675)
,p_name=>'APEXIR_NUMERIC_FLASHBACK_TIME'
,p_message_language=>'de'
,p_message_text=>'Flashback-Zeit muss numerisch sein.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273830089918864675)
,p_name=>'APEXIR_NUMERIC_SEQUENCE'
,p_message_language=>'de'
,p_message_text=>'Sequenz muss numerisch sein.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273855930903864693)
,p_name=>'APEXIR_OPERATOR'
,p_message_language=>'de'
,p_message_text=>'Operator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273581339537864503)
,p_name=>'APEXIR_ORANGE'
,p_message_language=>'de'
,p_message_text=>'orange'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274667600431865280)
,p_name=>'APEXIR_ORIENTATION'
,p_message_language=>'de'
,p_message_text=>'Ausrichtung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273583478590864504)
,p_name=>'APEXIR_OTHER'
,p_message_language=>'de'
,p_message_text=>'Weitere'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274704896997865306)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_COUNT_X'
,p_message_language=>'de'
,p_message_text=>'Prozentsatz der Gesamtanzahl %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274704069227865305)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_SUM_X'
,p_message_language=>'de'
,p_message_text=>'Prozentsatz der Gesamtsumme %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274702570586865304)
,p_name=>'APEXIR_PERCENT_TOTAL_COUNT'
,p_message_language=>'de'
,p_message_text=>'Prozentsatz der Gesamtanzahl'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274702408820865304)
,p_name=>'APEXIR_PERCENT_TOTAL_SUM'
,p_message_language=>'de'
,p_message_text=>'Prozentsatz der Gesamtsumme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273611553883864523)
,p_name=>'APEXIR_PIE'
,p_message_language=>'de'
,p_message_text=>'Kreis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274146359573864910)
,p_name=>'APEXIR_PIVOT'
,p_message_language=>'de'
,p_message_text=>'Pivot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274173959594864929)
,p_name=>'APEXIR_PIVOT_AGG_NOT_NULL'
,p_message_language=>'de'
,p_message_text=>'Aggregat muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274174233583864930)
,p_name=>'APEXIR_PIVOT_AGG_NOT_ON_ROW_COL'
,p_message_language=>'de'
,p_message_text=>unistr('Sie k\00F6nnen keine Spalte aggregieren, die als Zeilenspalte ausgew\00E4hlt ist.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274171731652864928)
,p_name=>'APEXIR_PIVOT_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Pivot-Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274171556269864928)
,p_name=>'APEXIR_PIVOT_COLUMN_N'
,p_message_language=>'de'
,p_message_text=>'Pivot-Spalte %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274173754744864929)
,p_name=>'APEXIR_PIVOT_COLUMN_NOT_NULL'
,p_message_language=>'de'
,p_message_text=>'Pivot-Spalte muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273412537458864390)
,p_name=>'APEXIR_PIVOT_MAX_ROW_CNT'
,p_message_language=>'de'
,p_message_text=>unistr('Die maximale Zeilenanzahl f\00FCr eine "Pivot"-Abfrage begrenzt die Anzahl der Zeilen in der Basisabfrage, aber nicht die Anzahl der angezeigten Zeilen. Die Basisabfrage \00FCberschreitet die maximale Zeilenanzahl von %0. Wenden Sie einen Filter an, um die A')
||unistr('nzahl der Datens\00E4tze in der Basisabfrage zu reduzieren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274785523964865363)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_language=>'de'
,p_message_text=>unistr('W\00E4hlen Sie eine andere Zeilenspalte. Der HTML-Ausdruck oder -Link in der Zeilenspalte enth\00E4lt die Spalte als Pivot- oder Aggregatspalte definiert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274172719987864929)
,p_name=>'APEXIR_PIVOT_SORT'
,p_message_language=>'de'
,p_message_text=>'Pivot-Sortierung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274307026288865027)
,p_name=>'APEXIR_PREVIEW'
,p_message_language=>'de'
,p_message_text=>'Vorschau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273738423898864609)
,p_name=>'APEXIR_PREVIOUS'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274701422144865303)
,p_name=>'APEXIR_PRIMARY'
,p_message_language=>'de'
,p_message_text=>'Primary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274310743976865029)
,p_name=>'APEXIR_PRIMARY_REPORT'
,p_message_language=>'de'
,p_message_text=>'Hauptbericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273971237668864774)
,p_name=>'APEXIR_PRIVATE'
,p_message_language=>'de'
,p_message_text=>'Privat'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273612904476864524)
,p_name=>'APEXIR_PUBLIC'
,p_message_language=>'de'
,p_message_text=>unistr('\00D6ffentlich')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273583295214864504)
,p_name=>'APEXIR_RED'
,p_message_language=>'de'
,p_message_text=>'rot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274789528290865366)
,p_name=>'APEXIR_REGION_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Statische Regions-ID %0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273824379161864671)
,p_name=>'APEXIR_REMOVE'
,p_message_language=>'de'
,p_message_text=>'Entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273737441133864609)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_language=>'de'
,p_message_text=>'Aggregat entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273824442168864671)
,p_name=>'APEXIR_REMOVE_ALL'
,p_message_language=>'de'
,p_message_text=>'Alle entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274771664926865353)
,p_name=>'APEXIR_REMOVE_CHART'
,p_message_language=>'de'
,p_message_text=>'Diagramm entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273823755121864670)
,p_name=>'APEXIR_REMOVE_CONTROL_BREAK'
,p_message_language=>'de'
,p_message_text=>'Kontrollgruppenwechsel entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273823415405864670)
,p_name=>'APEXIR_REMOVE_FILTER'
,p_message_language=>'de'
,p_message_text=>'Filter entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273823535244864670)
,p_name=>'APEXIR_REMOVE_FLASHBACK'
,p_message_language=>'de'
,p_message_text=>'Flashback entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274771713010865353)
,p_name=>'APEXIR_REMOVE_GROUP_BY'
,p_message_language=>'de'
,p_message_text=>'"Gruppieren nach" entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273823899157864670)
,p_name=>'APEXIR_REMOVE_HIGHLIGHT'
,p_message_language=>'de'
,p_message_text=>'Markierung entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274771811768865353)
,p_name=>'APEXIR_REMOVE_PIVOT'
,p_message_language=>'de'
,p_message_text=>'Pivot entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274713026205865312)
,p_name=>'APEXIR_REMOVE_REPORT'
,p_message_language=>'de'
,p_message_text=>'Bericht entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274591992453865227)
,p_name=>'APEXIR_RENAME_DEFAULT_REPORT'
,p_message_language=>'de'
,p_message_text=>'Standardbericht umbenennen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273859695410864695)
,p_name=>'APEXIR_RENAME_REPORT'
,p_message_language=>'de'
,p_message_text=>'Bericht umbenennen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273738911523864610)
,p_name=>'APEXIR_REPORT'
,p_message_language=>'de'
,p_message_text=>'Bericht'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274704942111865306)
,p_name=>'APEXIR_REPORTS'
,p_message_language=>'de'
,p_message_text=>'Berichte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273572486926864497)
,p_name=>'APEXIR_REPORT_ALIAS_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Gespeicherter interaktiver Bericht mit Alias %0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274121865468864893)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_language=>'de'
,p_message_text=>unistr('Die Anzahl der Anzeigespalten im Bericht hat den Grenzwert erreicht. Klicken Sie im Men\00FC "Aktionen" auf "Spalten ausw\00E4hlen", um die Liste der Berichtsanzeigespalten zu minimieren.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273974574165864788)
,p_name=>'APEXIR_REPORT_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Bericht ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273572595545864497)
,p_name=>'APEXIR_REPORT_ID_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'ID des gespeicherten interaktiven Berichts %0 ist nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273857367544864694)
,p_name=>'APEXIR_REPORT_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Berichteinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273710710445864590)
,p_name=>'APEXIR_REPORT_VIEW'
,p_message_language=>'de'
,p_message_text=>'Berichtsansicht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273740560003864611)
,p_name=>'APEXIR_RESET'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCcksetzen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273613161371864524)
,p_name=>'APEXIR_RESET_CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('Stellen Sie die Standardeinstellungen f\00FCr den Bericht wieder her.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273583079478864504)
,p_name=>'APEXIR_ROW'
,p_message_language=>'de'
,p_message_text=>'Zeile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274697288484865301)
,p_name=>'APEXIR_ROWID_NOT_SUPPORTED_FOR_WEBSOURCE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie k\00F6nnen ROWID nicht als Prim\00E4rschl\00FCsselspalte f\00FCr eine Webquelle verwenden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273822491744864669)
,p_name=>'APEXIR_ROWS'
,p_message_language=>'de'
,p_message_text=>'Zeilen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274316150039865033)
,p_name=>'APEXIR_ROWS_PER_PAGE'
,p_message_language=>'de'
,p_message_text=>'Zeilen pro Seite'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274171830935864928)
,p_name=>'APEXIR_ROW_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Zeilenspalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274171606744864928)
,p_name=>'APEXIR_ROW_COLUMN_N'
,p_message_language=>'de'
,p_message_text=>'Zeilenspalte %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274173843352864929)
,p_name=>'APEXIR_ROW_COLUMN_NOT_NULL'
,p_message_language=>'de'
,p_message_text=>'Zeilenspalte muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274174095893864929)
,p_name=>'APEXIR_ROW_COL_DIFF_FROM_PIVOT_COL'
,p_message_language=>'de'
,p_message_text=>'Zeilenspalte darf nicht identisch mit der Pivot-Spalte sein.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273919136969864737)
,p_name=>'APEXIR_ROW_FILTER'
,p_message_language=>'de'
,p_message_text=>'Zeilenfilter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273710831213864590)
,p_name=>'APEXIR_ROW_OF'
,p_message_language=>'de'
,p_message_text=>'Zeile %0 von %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273710011598864589)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_language=>'de'
,p_message_text=>'Zeilenreihenfolge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273742029740864612)
,p_name=>'APEXIR_ROW_TEXT_CONTAINS'
,p_message_language=>'de'
,p_message_text=>unistr('Zeilentext enth\00E4lt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273432473395864403)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_language=>'de'
,p_message_text=>unistr('Die Anzahl der Anzeigespalten im Bericht hat den Grenzwert erreicht. Klicken Sie im Men\00FC "Aktionen" auf "Spalten ausw\00E4hlen", um die Liste der Berichtsanzeigespalten zu minimieren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273582222140864504)
,p_name=>'APEXIR_SAVE'
,p_message_language=>'de'
,p_message_text=>'Speichern'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273832190229864676)
,p_name=>'APEXIR_SAVED_REPORT'
,p_message_language=>'de'
,p_message_text=>'Gespeicherter Bericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273832098136864676)
,p_name=>'APEXIR_SAVED_REPORT_MSG'
,p_message_language=>'de'
,p_message_text=>'Gespeicherter Bericht = "%0"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273740990107864611)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_language=>'de'
,p_message_text=>'Als Standard speichern'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273853542725864691)
,p_name=>'APEXIR_SAVE_DEFAULT_CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('Die aktuellen Berichteinstellungen werden als Standard f\00FCr alle Benutzer verwendet.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274591867370865227)
,p_name=>'APEXIR_SAVE_DEFAULT_REPORT'
,p_message_language=>'de'
,p_message_text=>'Standardbericht speichern'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273740477691864611)
,p_name=>'APEXIR_SAVE_REPORT'
,p_message_language=>'de'
,p_message_text=>'Bericht speichern'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274772896071865354)
,p_name=>'APEXIR_SAVE_REPORT_DEFAULT'
,p_message_language=>'de'
,p_message_text=>'Bericht speichern *'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274327767560865041)
,p_name=>'APEXIR_SEARCH'
,p_message_language=>'de'
,p_message_text=>'Suche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273817011351864665)
,p_name=>'APEXIR_SEARCH_BAR'
,p_message_language=>'de'
,p_message_text=>'Suchleiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274772756158865354)
,p_name=>'APEXIR_SEARCH_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Suchen: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274377053357865076)
,p_name=>'APEXIR_SEARCH_REPORT'
,p_message_language=>'de'
,p_message_text=>'Suchbericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274288681770865014)
,p_name=>'APEXIR_SELECTED_COLUMNS'
,p_message_language=>'de'
,p_message_text=>unistr('Ausgew\00E4hlte Spalten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273582510794864504)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_language=>'de'
,p_message_text=>unistr('- Kategorie ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273584186361864505)
,p_name=>'APEXIR_SELECT_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('- Spalte ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273739721243864610)
,p_name=>'APEXIR_SELECT_COLUMNS'
,p_message_language=>'de'
,p_message_text=>unistr('Spalten ausw\00E4hlen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273859491507864695)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_language=>'de'
,p_message_text=>'Vor berechneten Spalten steht **.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273612346899864524)
,p_name=>'APEXIR_SELECT_FUNCTION'
,p_message_language=>'de'
,p_message_text=>unistr('- Funktion ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273821835311864669)
,p_name=>'APEXIR_SELECT_GROUP_BY_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('- Gruppe nach Spalte ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274171321913864928)
,p_name=>'APEXIR_SELECT_PIVOT_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('- Pivot-Spalte ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274703993533865305)
,p_name=>'APEXIR_SELECT_ROW'
,p_message_language=>'de'
,p_message_text=>unistr('Zeile ausw\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274171412415864928)
,p_name=>'APEXIR_SELECT_ROW_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('- Zeilenspalte ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274702724235865304)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('- Sortierspalte ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273858968223864695)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_language=>'de'
,p_message_text=>unistr('Wert ausw\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273422250149864396)
,p_name=>'APEXIR_SEND'
,p_message_language=>'de'
,p_message_text=>'Senden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273582788757864504)
,p_name=>'APEXIR_SEQUENCE'
,p_message_language=>'de'
,p_message_text=>'Sequenz'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273739917115864611)
,p_name=>'APEXIR_SORT'
,p_message_language=>'de'
,p_message_text=>'Sortierung'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273827577745864673)
,p_name=>'APEXIR_SORT_ASCENDING'
,p_message_language=>'de'
,p_message_text=>'Aufsteigend sortieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274702641501865304)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Sortierspalte %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273827654166864673)
,p_name=>'APEXIR_SORT_DESCENDING'
,p_message_language=>'de'
,p_message_text=>'Absteigend sortieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274712205597865311)
,p_name=>'APEXIR_SORT_ORDER'
,p_message_language=>'de'
,p_message_text=>'Sortierreihenfolge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273813183752864663)
,p_name=>'APEXIR_SPACE_AS_IN_ONE_EMPTY_STRING'
,p_message_language=>'de'
,p_message_text=>'Speicherplatz'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273856220039864693)
,p_name=>'APEXIR_STATUS'
,p_message_language=>'de'
,p_message_text=>'Status %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274307606024865027)
,p_name=>'APEXIR_SUBSCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Subscription'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274703098695865305)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING'
,p_message_language=>'de'
,p_message_text=>'Bis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274288586903865014)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_language=>'de'
,p_message_text=>'Endeinheit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274702944924865304)
,p_name=>'APEXIR_SUBSCRIPTION_STARTING_FROM'
,p_message_language=>'de'
,p_message_text=>'Ab'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274704117457865305)
,p_name=>'APEXIR_SUM_X'
,p_message_language=>'de'
,p_message_text=>'Summe %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274653465889865270)
,p_name=>'APEXIR_TABLE_SUMMARY'
,p_message_language=>'de'
,p_message_text=>'Region = %0, Bericht = %1, Ansicht = %2, Angezeigte Zeilen Start = %3, Angezeigte Zeilen Ende = %4, Zeilen insgesamt = %5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273763530780864627)
,p_name=>'APEXIR_TABLE_SUMMARY_NO_TOTAL'
,p_message_language=>'de'
,p_message_text=>'Region = %0, Bericht = %1, Ansicht = %2, Angezeigte Zeilen Start = %3, Angezeigte Zeilen Ende = %4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273581424842864503)
,p_name=>'APEXIR_TEXT_COLOR'
,p_message_language=>'de'
,p_message_text=>'Textfarbe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273697189431864580)
,p_name=>'APEXIR_TIME_DAYS'
,p_message_language=>'de'
,p_message_text=>'Tage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273697089895864580)
,p_name=>'APEXIR_TIME_HOURS'
,p_message_language=>'de'
,p_message_text=>'Stunden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273696921673864580)
,p_name=>'APEXIR_TIME_MINS'
,p_message_language=>'de'
,p_message_text=>'Minuten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273697353699864581)
,p_name=>'APEXIR_TIME_MONTHS'
,p_message_language=>'de'
,p_message_text=>'Monaten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273697211471864581)
,p_name=>'APEXIR_TIME_WEEKS'
,p_message_language=>'de'
,p_message_text=>'Wochen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273697417138864581)
,p_name=>'APEXIR_TIME_YEARS'
,p_message_language=>'de'
,p_message_text=>'Jahren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274712811024865312)
,p_name=>'APEXIR_TOGGLE'
,p_message_language=>'de'
,p_message_text=>'Ein-/ausschalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273824553816864671)
,p_name=>'APEXIR_TOP'
,p_message_language=>'de'
,p_message_text=>'Oben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273857720963864694)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_language=>'de'
,p_message_text=>'Nicht autorisiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274686681710865293)
,p_name=>'APEXIR_UNGROUPED_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Nicht gruppierte Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273830254479864675)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_language=>'de'
,p_message_text=>unistr('Spalten\00FCberschrift muss eindeutig sein.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273829974312864675)
,p_name=>'APEXIR_UNIQUE_HIGHLIGHT_NAME'
,p_message_language=>'de'
,p_message_text=>'Markierungsname muss eindeutig sein.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273610610950864522)
,p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE'
,p_message_language=>'de'
,p_message_text=>unistr('Nicht unterst\00FCtzter Datentyp')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273824670431864671)
,p_name=>'APEXIR_UP'
,p_message_language=>'de'
,p_message_text=>'Nach oben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273830101878864675)
,p_name=>'APEXIR_VALID_COLOR'
,p_message_language=>'de'
,p_message_text=>unistr('Geben Sie eine g\00FCltige Farbe ein.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273830369508864675)
,p_name=>'APEXIR_VALID_FORMAT_MASK'
,p_message_language=>'de'
,p_message_text=>unistr('Geben Sie eine g\00FCltige Formatmaske ein.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273583526788864504)
,p_name=>'APEXIR_VALUE'
,p_message_language=>'de'
,p_message_text=>'Wert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273825455987864671)
,p_name=>'APEXIR_VALUE_AXIS_TITLE'
,p_message_language=>'de'
,p_message_text=>unistr('Achsenbeschriftung f\00FCr Wert')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273858714005864695)
,p_name=>'APEXIR_VALUE_REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Wert erforderlich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273611468019864523)
,p_name=>'APEXIR_VCOLUMN'
,p_message_language=>'de'
,p_message_text=>'Vertikale Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274667867067865280)
,p_name=>'APEXIR_VERTICAL'
,p_message_language=>'de'
,p_message_text=>'Vertikal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273857900109864694)
,p_name=>'APEXIR_VIEW_CHART'
,p_message_language=>'de'
,p_message_text=>'Diagramm anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274356831382865061)
,p_name=>'APEXIR_VIEW_DETAIL'
,p_message_language=>'de'
,p_message_text=>'Detail anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274775957926865356)
,p_name=>'APEXIR_VIEW_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr den Bericht ist keine %0-Ansicht definiert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274356906535865061)
,p_name=>'APEXIR_VIEW_GROUP_BY'
,p_message_language=>'de'
,p_message_text=>'"Gruppieren nach" anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274356798980865061)
,p_name=>'APEXIR_VIEW_ICONS'
,p_message_language=>'de'
,p_message_text=>'Symbole anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274171106040864927)
,p_name=>'APEXIR_VIEW_PIVOT'
,p_message_language=>'de'
,p_message_text=>'Pivot anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273858078093864694)
,p_name=>'APEXIR_VIEW_REPORT'
,p_message_language=>'de'
,p_message_text=>'Bericht anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274703559582865305)
,p_name=>'APEXIR_WEEK'
,p_message_language=>'de'
,p_message_text=>'Woche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274307879480865027)
,p_name=>'APEXIR_WEEKLY'
,p_message_language=>'de'
,p_message_text=>unistr('W\00F6chentlich')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273738823318864610)
,p_name=>'APEXIR_WORKING_REPORT'
,p_message_language=>'de'
,p_message_text=>'Arbeitsbericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274705701216865307)
,p_name=>'APEXIR_X_DAYS'
,p_message_language=>'de'
,p_message_text=>'%0 Tage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274705616136865307)
,p_name=>'APEXIR_X_HOURS'
,p_message_language=>'de'
,p_message_text=>'%0 Stunden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274705533436865306)
,p_name=>'APEXIR_X_MINS'
,p_message_language=>'de'
,p_message_text=>'%0 Minuten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274705973735865307)
,p_name=>'APEXIR_X_MONTHS'
,p_message_language=>'de'
,p_message_text=>'%0 Monate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274705883792865307)
,p_name=>'APEXIR_X_WEEKS'
,p_message_language=>'de'
,p_message_text=>'%0 Wochen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274706089214865307)
,p_name=>'APEXIR_X_YEARS'
,p_message_language=>'de'
,p_message_text=>'%0 Jahre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274703444724865305)
,p_name=>'APEXIR_YEAR'
,p_message_language=>'de'
,p_message_text=>'Jahr'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273581111223864503)
,p_name=>'APEXIR_YELLOW'
,p_message_language=>'de'
,p_message_text=>'gelb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273582849107864504)
,p_name=>'APEXIR_YES'
,p_message_language=>'de'
,p_message_text=>'Ja'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273429565070864401)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_language=>'de'
,p_message_text=>unistr('Administration Services f\00FCr Application Express')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274652014649865269)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr diese Anwendung ist keine Authentifizierung konfiguriert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273825273868864671)
,p_name=>'APEX_GROUP.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'de'
,p_message_text=>unistr('%0 enth\00E4lt < oder >. Dies sind ung\00FCltige Zeichen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274042489086864836)
,p_name=>'APEX_REGION'
,p_message_language=>'de'
,p_message_text=>'Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273899105161864723)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_language=>'de'
,p_message_text=>unistr('Die folgenden Datenbankobjekte werden in das ausgew\00E4hlte Schema %0:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273899216257864723)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_language=>'de'
,p_message_text=>'Die folgenden Datenbankobjekte wurden erfolgreich %0:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274387125439865083)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_language=>'de'
,p_message_text=>'Bildlauf nach unten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274387246700865083)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_language=>'de'
,p_message_text=>'Zum Anfang scrollen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273435154985864405)
,p_name=>'APEX_WIZARD_FORM'
,p_message_language=>'de'
,p_message_text=>'Navigationsformular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274651577639865269)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_language=>'de'
,p_message_text=>'Zeile bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274070051024864855)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltige Objekte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274709945998865310)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_language=>'de'
,p_message_text=>'Es sind keine Peer-Seiten vorhanden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274654887819865271)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_language=>'de'
,p_message_text=>'Zu erstellende Objekte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274655048403865271)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_language=>'de'
,p_message_text=>unistr('Aus Tabellen l\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274655205375865271)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_language=>'de'
,p_message_text=>unistr('Objekte l\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274317926867865034)
,p_name=>'APEX_WS_SETUP_DROP_TABLES'
,p_message_language=>'de'
,p_message_text=>unistr('Tabellen l\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274317266667865034)
,p_name=>'APEX_WS_SETUP_MSG1'
,p_message_language=>'de'
,p_message_text=>'Diese Objekte werden im Schema <b>%0</b> erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274655378449865271)
,p_name=>'APEX_WS_SETUP_MSG10'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Objekte sind im Schema <b>%0</b> bereits vorhanden und werden von anderen Workspaces verwendet. Wenn Sie fortfahren, werden die bestehenden, <b>%0</b> zugeh\00F6rigen Websheet-Objekte auch diesem Workspace zugeordnet.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274655472231865271)
,p_name=>'APEX_WS_SETUP_MSG11'
,p_message_language=>'de'
,p_message_text=>unistr('W\00E4hlen Sie das f\00FCr diese Objekte zu verwendende Schema:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274655505696865271)
,p_name=>'APEX_WS_SETUP_MSG12'
,p_message_language=>'de'
,p_message_text=>'Zu verwendende bestehende Tabellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274656426686865272)
,p_name=>'APEX_WS_SETUP_MSG13'
,p_message_language=>'de'
,p_message_text=>unistr('Websheet-Datenbankobjekte werden mit den folgenden Informationen erneut verwendet. Best\00E4tigen Sie die Anforderung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274317357856865034)
,p_name=>'APEX_WS_SETUP_MSG2'
,p_message_language=>'de'
,p_message_text=>unistr('Wenn Sie die Websheet-Objekte in einem neuen Schema erstellen m\00F6chten, verwenden Sie den Assistenten <a href=%0>Datenbankschema anfordern</a>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274317416515865034)
,p_name=>'APEX_WS_SETUP_MSG3'
,p_message_language=>'de'
,p_message_text=>unistr('Um Websheets ausf\00FChren zu k\00F6nnen, m\00FCssen die folgenden Objekte vorhanden sein:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274317537338865034)
,p_name=>'APEX_WS_SETUP_MSG5'
,p_message_language=>'de'
,p_message_text=>unistr('Websheet-Datenbankobjekte werden mit den folgenden Informationen erstellt. Best\00E4tigen Sie die Anforderung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274317649501865034)
,p_name=>'APEX_WS_SETUP_MSG6'
,p_message_language=>'de'
,p_message_text=>'Zu erstellende Tabellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274317736785865034)
,p_name=>'APEX_WS_SETUP_MSG7'
,p_message_language=>'de'
,p_message_text=>unistr('Sie m\00F6chten Websheet-Datenbankobjekte entfernen. Hierdurch werden au\00DFer den Websheet-Datenbankobjekten auch die internen Daten im Workspace gel\00F6scht, die Websheet-Komponenten enthalten. M\00F6chten Sie fortfahren? ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274318005714865035)
,p_name=>'APEX_WS_SETUP_MSG8'
,p_message_language=>'de'
,p_message_text=>unistr('Die folgenden ung\00FCltigen Objekte m\00FCssen korrigiert werden, damit Websheets ordnungsgem\00E4\00DF ausgef\00FChrt werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274654908566865271)
,p_name=>'APEX_WS_SETUP_MSG9'
,p_message_language=>'de'
,p_message_text=>unistr('Sie m\00F6chten die Websheet-Definitionen f\00FCr diesen Workspace entfernen. Da diese Websheet-Datenbankobjekte auch von anderen Workspaces verwendet werden, werden sie nicht gel\00F6scht. M\00F6chten Sie fortfahren? ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274318167398865035)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_language=>'de'
,p_message_text=>'Objektname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274318202365865035)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_language=>'de'
,p_message_text=>'Objekttyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274317840400865034)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_language=>'de'
,p_message_text=>'Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274654751996865271)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_language=>'de'
,p_message_text=>'Zu verwendende vorhandene Objekte'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273446428071864413)
,p_name=>'API_PRECONDITION_VIOLATED'
,p_message_language=>'de'
,p_message_text=>'API-Vorbedingung verletzt'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273604734829864518)
,p_name=>'APP.SETTING.CANNOT.GET'
,p_message_language=>'de'
,p_message_text=>unistr('Wert f\00FCr Anwendungseinstellung %0 kann nicht abgerufen werden, da die zugeh\00F6rige Erstelloption deaktiviert ist.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273604618782864518)
,p_name=>'APP.SETTING.CANNOT.SET'
,p_message_language=>'de'
,p_message_text=>unistr('Wert f\00FCr Anwendungseinstellung %0 kann nicht festgelegt werden, da die zugeh\00F6rige Erstelloption deaktiviert ist.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274681443854865289)
,p_name=>'APP.SETTING.INVALID.VALUE'
,p_message_language=>'de'
,p_message_text=>unistr('Wert der Anwendungseinstellung %0 ist ung\00FCltig')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274681355099865289)
,p_name=>'APP.SETTING.NOT.DEFINED'
,p_message_language=>'de'
,p_message_text=>'Angeforderte Anwendungseinstellung %0 ist nicht definiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274681518655865290)
,p_name=>'APP.SETTING.VALUE.NOT.NULL'
,p_message_language=>'de'
,p_message_text=>'Anwendungseinstellung %0 darf nicht auf einen Nullwert gesetzt werden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273497844419864447)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_language=>'de'
,p_message_text=>'Anwendungsberechnungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273497779963864447)
,p_name=>'APPLICACTION_PROCESS'
,p_message_language=>'de'
,p_message_text=>'Anwendungsprozesse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274063093733864851)
,p_name=>'APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274143231371864908)
,p_name=>'APPLICATION BUILDER'
,p_message_language=>'de'
,p_message_text=>'App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273967770437864771)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_language=>'de'
,p_message_text=>unistr('Bedingung f\00FCr Anwendungsberechnung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273970462982864773)
,p_name=>'APPLICATION IMAGE'
,p_message_language=>'de'
,p_message_text=>'Anwendungsbild'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273967830357864771)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_language=>'de'
,p_message_text=>unistr('Bedingung f\00FCr Anwendungsprozess')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273894525666864720)
,p_name=>'APPLICATIONS'
,p_message_language=>'de'
,p_message_text=>'Anwendungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274040276729864834)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_language=>'de'
,p_message_text=>'Anwendungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273940513874864752)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_language=>'de'
,p_message_text=>unistr('Anwendungsaktivit\00E4t')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273981076386864793)
,p_name=>'APPLICATION_ALIAS'
,p_message_language=>'de'
,p_message_text=>unistr('Aliasname f\00FCr die Anwendung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273979057772864791)
,p_name=>'APPLICATION_DELETED'
,p_message_language=>'de'
,p_message_text=>unistr('Anwendung wurde gel\00F6scht')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273429239459864401)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_language=>'de'
,p_message_text=>'Anwendungsentwicklung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273980030228864792)
,p_name=>'APPLICATION_HELP'
,p_message_language=>'de'
,p_message_text=>'Gibt die Anwendung an.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273937181232864750)
,p_name=>'APPLICATION_ID'
,p_message_language=>'de'
,p_message_text=>'Anwendungsnummer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273826422738864672)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_language=>'de'
,p_message_text=>'Die Anwendungs-ID ist reserviert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273826361268864672)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_language=>'de'
,p_message_text=>'Die Anwendungs-ID muss eine positive Ganzzahl sein.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274358535165865063)
,p_name=>'APPLICATION_IMAGES'
,p_message_language=>'de'
,p_message_text=>'Anwendungsbilder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274010371023864814)
,p_name=>'APPLICATION_ITEM'
,p_message_language=>'de'
,p_message_text=>'Anwendungselement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273526802312864466)
,p_name=>'APPLICATION_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Anwendungselemente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273492255474864444)
,p_name=>'APPLICATION_LABEL'
,p_message_language=>'de'
,p_message_text=>'Anwendung: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273980945478864793)
,p_name=>'APPLICATION_NAME'
,p_message_language=>'de'
,p_message_text=>'Anwendungsname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274709593155865309)
,p_name=>'APPLICATION_NAMES'
,p_message_language=>'de'
,p_message_text=>'Anwendungsnamen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274103358428864879)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_language=>'de'
,p_message_text=>'Anwendungs-Override-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273978550068864791)
,p_name=>'APPLICATION_OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Anwendungseigent\00FCmer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274709446087865309)
,p_name=>'APPLICATION_PAGES'
,p_message_language=>'de'
,p_message_text=>'Anwendungsseiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273614975368864525)
,p_name=>'APPLICATION_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Anwendungseinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273978790252864791)
,p_name=>'APPLICATION_STATUS'
,p_message_language=>'de'
,p_message_text=>'Anwendungsstatus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274065097504864852)
,p_name=>'APPLICATION_VERSION'
,p_message_language=>'de'
,p_message_text=>'Anwendungsversion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273444862089864412)
,p_name=>'APPLICATION_X'
,p_message_language=>'de'
,p_message_text=>'Anwendung %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273924302317864741)
,p_name=>'APPROVED'
,p_message_language=>'de'
,p_message_text=>'Genehmigt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273985240877864796)
,p_name=>'APP_SUCCESS_MSG'
,p_message_language=>'de'
,p_message_text=>'Die Anwendung wurde erfolgreich erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274712185092865311)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_language=>'de'
,p_message_text=>'Templateanwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273479282767864435)
,p_name=>'APP_TYPE_DATABASE'
,p_message_language=>'de'
,p_message_text=>'Datenbankanwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273479367458864435)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_language=>'de'
,p_message_text=>unistr('Produktivit\00E4ts- oder Beispielanwendung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274006720097864811)
,p_name=>'APP_TYPE_PACKAGED_WS'
,p_message_language=>'de'
,p_message_text=>'Beispiel-Websheet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273479159654864435)
,p_name=>'APP_TYPE_WEBSHEET'
,p_message_language=>'de'
,p_message_text=>'Websheet-Anwendung'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273923854787864740)
,p_name=>'ARCHIVED'
,p_message_language=>'de'
,p_message_text=>'Archiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273492521326864444)
,p_name=>'ARCHIVELOG'
,p_message_language=>'de'
,p_message_text=>'Logarchivierung: Ein'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273743474145864613)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_language=>'de'
,p_message_text=>unistr('Argumente m\00FCssen Pr\00FCfsumme haben')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273839283473864681)
,p_name=>'ARGUMENT_NAME'
,p_message_language=>'de'
,p_message_text=>'Argumentname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273839421324864681)
,p_name=>'ARGUMENT_TYPE'
,p_message_language=>'de'
,p_message_text=>'Argumenttyp'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273917749386864736)
,p_name=>'ASAP'
,p_message_language=>'de'
,p_message_text=>unistr('So schnell wie m\00F6glich')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273914326551864734)
,p_name=>'ASSIGNED'
,p_message_language=>'de'
,p_message_text=>'Zugeordnet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273612540590864524)
,p_name=>'ASSIGNEE'
,p_message_language=>'de'
,p_message_text=>'Beauftragter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274737015598865329)
,p_name=>'ASSIGN_LABEL'
,p_message_language=>'de'
,p_message_text=>' %0 zuweisen'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273673113800864564)
,p_name=>'ASSOCIATED'
,p_message_language=>'de'
,p_message_text=>unistr('zugeh\00F6rig')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273614413972864525)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_language=>'de'
,p_message_text=>'Zugeordnete Features'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273945704543864756)
,p_name=>'ATTACHMENT'
,p_message_language=>'de'
,p_message_text=>'Anhang'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274753452725865340)
,p_name=>'AT_RISK_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Gef\00E4hrdet')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273643020312864544)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_language=>'de'
,p_message_text=>'Sie sind im Begriff, die benutzerdefinierten Authentifizierungsoptionen zu einem Authentifizierungsschema zu migrieren.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273642529103864544)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_language=>'de'
,p_message_text=>'Aktuelle Authentifizierungsmethode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273642949077864544)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_language=>'de'
,p_message_text=>unistr('Funktion f\00FCr eine benutzerdefinierte Authentifizierung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273642639255864544)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_language=>'de'
,p_message_text=>'Anmeldeseite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273642880942864544)
,p_name=>'AUTH.LOGIN_URL'
,p_message_language=>'de'
,p_message_text=>'Anmelde-URL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273642750476864544)
,p_name=>'AUTH.NONE'
,p_message_language=>'de'
,p_message_text=>'Kein Eintrag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273648154874864547)
,p_name=>'AUTHENTICATION'
,p_message_language=>'de'
,p_message_text=>'Authentifizierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273968776087864772)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_language=>'de'
,p_message_text=>'Authentifizierungsfunktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273968475698864772)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_language=>'de'
,p_message_text=>'Authentifizierungsschema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273663276396864558)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie sind im Begriff, ein Authentifizierungsschema aus der Anwendung %0 zu l\00F6schen. Wenn die Anwendung aktuell nicht die SCHEME-Authentifizierung verwendet oder SCHEME nicht das aktuelle Authentifizierungsschema ist und Sie das Schema l\00F6schen, hat die')
||unistr('s keine Auswirkung auf den Vorgang der Anwendung. Wenn die Anwendung die SCHEME-Authentifizierung verwendet und es sich hierbei um das aktuelle Authentifizierungsschema handelt, f\00FChrt die Anwendung weiterhin die SCHEME-Authentifizierung durch, und zw')
||unistr('ar mit einem Standardauthentifizierungsschema. Hierbei wird eine integrierte Anmeldeseite mit einer "Open Door"-Zugangsdatenverifizierung verwendet (bei der jeder Benutzer berechtigt ist, die Anwendung auszuf\00FChren). ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273665144029864559)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_language=>'de'
,p_message_text=>'Klicken Sie auf <b>Als aktuelles Element festlegen</b>, damit Ihre Anwendung dieses Authentifizierungsschema verwendet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274173085674864929)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_language=>'de'
,p_message_text=>'Application Express-Accounts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273425885095864399)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'de'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274173105610864929)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_language=>'de'
,p_message_text=>'Benutzerdefiniert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274173433626864929)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_language=>'de'
,p_message_text=>'Keine Authentifizierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274173252979864929)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_language=>'de'
,p_message_text=>'Datenbankaccounts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274606458378865237)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_language=>'de'
,p_message_text=>'HTTP-Headervariable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274173672014864929)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_language=>'de'
,p_message_text=>'Oracle Application Server Single Sign-On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274173372258864929)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_language=>'de'
,p_message_text=>'LDAP-Verzeichnis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274173515381864929)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_language=>'de'
,p_message_text=>'Open Door-Zugangsdaten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273416066718864392)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_language=>'de'
,p_message_text=>'SAML-Anmeldung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273454543212864418)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_language=>'de'
,p_message_text=>'Social Sign-In'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274011426628864814)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_language=>'de'
,p_message_text=>'Authentifizierungsschema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273968353749864772)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_language=>'de'
,p_message_text=>'Autorisierungsschema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273425957354864399)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'de'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273445087651864412)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Exists-SQL-Abfrage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273445143560864412)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_language=>'de'
,p_message_text=>unistr('PL/SQL-Funktion, die Boolean zur\00FCckgibt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273822262504864669)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_language=>'de'
,p_message_text=>'Ist in Rolle oder Gruppe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273822331807864669)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_language=>'de'
,p_message_text=>'Ist nicht in Rolle oder Gruppe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273445217188864412)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_language=>'de'
,p_message_text=>'Wert von Element in Ausdruck 1 ist gleich Ausdruck 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273445355256864412)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_language=>'de'
,p_message_text=>'Element in Ausdruck 1 ist NOT NULL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273445415985864412)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_language=>'de'
,p_message_text=>'Element in Ausdruck 1 ist NULL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273445535672864412)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_language=>'de'
,p_message_text=>'Wert des Elements in Ausdruck 1 ist nicht gleich Ausdruck 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273445637122864412)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Not Exists-SQL-Abfrage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273445740864864412)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_language=>'de'
,p_message_text=>'Wert der Voreinstellung in Ausdruck 1 = Ausdruck 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273445884056864412)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_language=>'de'
,p_message_text=>'Wert von Voreinstellung in Ausdruck 1 ist NICHT gleich Ausdruck 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273510808057864456)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr jede Seitenansicht auswerten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273510944882864456)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_language=>'de'
,p_message_text=>'Einmal pro Session auswerten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273448224114864414)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_language=>'de'
,p_message_text=>'Account abgelaufen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273448187225864414)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_language=>'de'
,p_message_text=>'Account gesperrt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273448557685864414)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_language=>'de'
,p_message_text=>unistr('Maximale Anmeldeversuche \00FCberschritten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273448656181864414)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_language=>'de'
,p_message_text=>'Unbekannter interner Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273448411261864414)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_language=>'de'
,p_message_text=>'Erste Verwendung des Kennworts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273448387048864414)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_language=>'de'
,p_message_text=>'Falsches Kennwort'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273447923105864414)
,p_name=>'AUTH_SUCCESS'
,p_message_language=>'de'
,p_message_text=>'Normale, erfolgreiche Authentifizierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273448064485864414)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_language=>'de'
,p_message_text=>'Unbekannter Benutzername'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273562824805864491)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_language=>'de'
,p_message_text=>'Unbekannter Workspace-Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273573321831864498)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_language=>'de'
,p_message_text=>'Unbekannter Workspace-Name: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273717192760864594)
,p_name=>'AUTOCOMMIT'
,p_message_language=>'de'
,p_message_text=>'COMMIT-Anweisung nicht anwendbar. Alle Anweisungen werden automatisch festgeschrieben.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274040859993864835)
,p_name=>'AUTOPROVISION_MODE'
,p_message_language=>'de'
,p_message_text=>'Provisioning-Modus'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273423507476864397)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_language=>'de'
,p_message_text=>'Erstes Element'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274066772890864853)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_language=>'de'
,p_message_text=>unistr('Verf\00FCgbarkeit')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273453132948864417)
,p_name=>'AVAILABLE'
,p_message_language=>'de'
,p_message_text=>unistr('Verf\00FCgbar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274270462266865001)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_language=>'de'
,p_message_text=>unistr('Nur f\00FCr Entwickler verf\00FCgbar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274270377129865001)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_language=>'de'
,p_message_text=>unistr('Mit Entwicklersymbolleiste verf\00FCgbar')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273941349160864753)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_language=>'de'
,p_message_text=>'Durchschnittliche Rendering-Zeit (Sekunden)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273511689340864456)
,p_name=>'BACK'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273922215248864739)
,p_name=>'BAR_CHART'
,p_message_language=>'de'
,p_message_text=>'Balkendiagramm'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274343962456865052)
,p_name=>'BASIC'
,p_message_language=>'de'
,p_message_text=>'Einfach'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273466928041864427)
,p_name=>'BASIC_DEVELOPER'
,p_message_language=>'de'
,p_message_text=>'Basisentwickler'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273901512036864725)
,p_name=>'BEFORE'
,p_message_language=>'de'
,p_message_text=>'Vor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274714891629865313)
,p_name=>'BEFORE LIST ENTRY'
,p_message_language=>'de'
,p_message_text=>'Vor Listeneintrag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274735733004865328)
,p_name=>'BEFORE_FIRST'
,p_message_language=>'de'
,p_message_text=>'Vor erstem'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273971671183864774)
,p_name=>'BIND_LABEL'
,p_message_language=>'de'
,p_message_text=>'Bind-Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273970926384864774)
,p_name=>'BIND_VARIABLE'
,p_message_language=>'de'
,p_message_text=>'Bind-Variable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273971027989864774)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_language=>'de'
,p_message_text=>'Label Bind-Variable'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273986808415864797)
,p_name=>'BLACK_TEXT'
,p_message_language=>'de'
,p_message_text=>'Schwarzer Text'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273430314481864402)
,p_name=>'BLANK'
,p_message_language=>'de'
,p_message_text=>'Leer'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273944976969864755)
,p_name=>'BLOB_COLUMN'
,p_message_language=>'de'
,p_message_text=>'BLOB-Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274105031108864881)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_language=>'de'
,p_message_text=>'Herunterladen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273482003232864437)
,p_name=>'BLOB_FORMAT'
,p_message_language=>'de'
,p_message_text=>'Blob-Format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274105440762864881)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_language=>'de'
,p_message_text=>'Anhang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274105139101864881)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_language=>'de'
,p_message_text=>'DOWNLOAD'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274105227303864881)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_language=>'de'
,p_message_text=>'IMAGE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274105386655864881)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_language=>'de'
,p_message_text=>'Inline'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273945925824864756)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_language=>'de'
,p_message_text=>'BLOB-Format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273945416589864756)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_language=>'de'
,p_message_text=>'BLOB Zuletzt aktualisierte Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273944894546864755)
,p_name=>'BLOB_TABLE'
,p_message_language=>'de'
,p_message_text=>'BLOB-Tabelle'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273986716812864797)
,p_name=>'BLUE_TEXT'
,p_message_language=>'de'
,p_message_text=>'Blauer Text'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273961921687864767)
,p_name=>'BRANCH CONDITION'
,p_message_language=>'de'
,p_message_text=>unistr('Bedingung f\00FCr Verzweigung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273515202222864459)
,p_name=>'BRANCHES'
,p_message_language=>'de'
,p_message_text=>'Verzweigungen'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273739390072864610)
,p_name=>'BREADCRUMB'
,p_message_language=>'de'
,p_message_text=>'Navigationspfad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273902272485864725)
,p_name=>'BREADCRUMB LABEL'
,p_message_language=>'de'
,p_message_text=>'Navigationspfad-Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273902342297864725)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Langer Name f\00FCr Navigationspfad')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273739475387864610)
,p_name=>'BREADCRUMBS'
,p_message_language=>'de'
,p_message_text=>'Navigationspfade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273995330375864803)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_language=>'de'
,p_message_text=>'Navigationspfadeintrag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274010504407864814)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_language=>'de'
,p_message_text=>'Navigationspfadeintrag: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273826626022864672)
,p_name=>'BREADCRUMB_PAGES'
,p_message_language=>'de'
,p_message_text=>'Navigationspfadseiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273910481036864731)
,p_name=>'BREADCRUMB_REGION'
,p_message_language=>'de'
,p_message_text=>'Navigationspfadregion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273575651621864499)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_language=>'de'
,p_message_text=>'Der Navigationspfad wurde erfolgreich erstellt.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273904858757864727)
,p_name=>'BROWSE_ICON'
,p_message_language=>'de'
,p_message_text=>'Durchsuchen-Symbol'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273904651737864727)
,p_name=>'BROWSE_PACKAGE'
,p_message_language=>'de'
,p_message_text=>'Package durchsuchen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273838993654864681)
,p_name=>'BROWSE_TABLE'
,p_message_language=>'de'
,p_message_text=>'Tabelle durchsuchen'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273433658162864404)
,p_name=>'BUFFER CACHE'
,p_message_language=>'de'
,p_message_text=>'Puffercache'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273918246567864737)
,p_name=>'BUG'
,p_message_language=>'de'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273942442030864754)
,p_name=>'BUGS'
,p_message_language=>'de'
,p_message_text=>'Bugs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273964902237864769)
,p_name=>'BUGS_ASSIGNED'
,p_message_language=>'de'
,p_message_text=>'Zugewiesene Bugs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274004127734864809)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_language=>'de'
,p_message_text=>'Zugewiesene Bugs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273462250225864423)
,p_name=>'BUGS_CLOSED'
,p_message_language=>'de'
,p_message_text=>'Geschlossene Bugs (%0/%1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274379601263865078)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_language=>'de'
,p_message_text=>'Prozentsatz geschlossener Bugs (%0/%1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274004272294864809)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_language=>'de'
,p_message_text=>'Nicht zugewiesene Bugs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274004325225864809)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_language=>'de'
,p_message_text=>unistr('Keine Korrekturf\00E4lligkeitsdaten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274380046386865078)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_language=>'de'
,p_message_text=>'Bugs: %1 von %0 geschlossen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274743910706865333)
,p_name=>'BUG_LABEL'
,p_message_language=>'de'
,p_message_text=>'Bug: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273958240160864765)
,p_name=>'BUILD QUERY'
,p_message_language=>'de'
,p_message_text=>'Abfrage erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273425411404864398)
,p_name=>'BUILDER'
,p_message_language=>'de'
,p_message_text=>'Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274064257553864851)
,p_name=>'BUILDER.PLUGINS'
,p_message_language=>'de'
,p_message_text=>'Plug-ins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274059791731864848)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_language=>'de'
,p_message_text=>unistr('[Nicht unterst\00FCtzt]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274354439956865060)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_language=>'de'
,p_message_text=>'Workspace-Meldung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273655467103864552)
,p_name=>'BUILD_OPTION'
,p_message_language=>'de'
,p_message_text=>'Erstelloption'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274128681612864897)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_language=>'de'
,p_message_text=>'Erstelloption: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274742663965865333)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_language=>'de'
,p_message_text=>'Build-Status: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274129502045864898)
,p_name=>'BUILD_VERSION'
,p_message_language=>'de'
,p_message_text=>'Build-Version'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273997797346864805)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Integriertes Berichtstemplate'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273900725872864724)
,p_name=>'BUTTON'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4che')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273901440361864725)
,p_name=>'BUTTON LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4chenbeschriftung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274106794664864882)
,p_name=>'BUTTON.ADD'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273442022779864410)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_language=>'de'
,p_message_text=>unistr('Die Schaltfl\00E4chenattribute der ausgew\00E4hlten Schaltfl\00E4che d\00FCrfen keine ID enthalten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273441999718864410)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_language=>'de'
,p_message_text=>unistr('Die ausgew\00E4hlte Schaltfl\00E4che muss eine Schaltfl\00E4che mit einer Aktion sein, f\00FCr die "Von dynamischer Aktion definiert" festgelegt wurde.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273442211102864410)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_language=>'de'
,p_message_text=>unistr('Die ausgew\00E4hlte Schaltfl\00E4che verwendet ein ''Schaltfl\00E4chen-Template'', das die Ersetzungszeichenfolge #BUTTON_ID# nicht enth\00E4lt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274106589132864882)
,p_name=>'BUTTON.DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273515520396864459)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_language=>'de'
,p_message_text=>'Die Seite muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273491783761864443)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_language=>'de'
,p_message_text=>'Die Berichtsabfrage muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273478949945864435)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_language=>'de'
,p_message_text=>unistr('Eine Schaltfl\00E4chenanforderung muss f\00FCr alle Quelltypen von Schaltfl\00E4chenanforderungen angegeben werden, au\00DFer der Quelltyp der Schaltfl\00E4chenanforderung ist "Immer null".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273479660325864435)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_language=>'de'
,p_message_text=>unistr('Quelltyp f\00FCr Schaltfl\00E4chenanforderung muss angegeben werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273515656607864459)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_language=>'de'
,p_message_text=>'Das Ziel der URL muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273444550278864411)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_language=>'de'
,p_message_text=>unistr('Wenn die Aktion ''Von dynamischer Aktion definiert" ist, d\00FCrfen die Schaltfl\00E4chenattribute keine ID enthalten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273517226603864460)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_language=>'de'
,p_message_text=>'Bild muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273517398136864460)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_language=>'de'
,p_message_text=>'Format-Template muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273517118929864460)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Das Template muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273444485651864411)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_language=>'de'
,p_message_text=>unistr('Wenn der Schaltfl\00E4chenstil "Template-basierte Schaltfl\00E4che" und Aktion "Von dynamischer Aktion definiert ist", muss das ausgew\00E4hlte Schaltfl\00E4chentemplate die Ersetzungszeichenfolge #BUTTON_ID# enthalten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273432048439864403)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4che kann nicht gel\00F6scht werden, weil sie in einer dynamischen Aktion referenziert wird (Seite: %0, Dynamische Aktion: ''%1'', Aktion: ''%2'', Attribut: ''Betroffenes Element'')')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273431955601864403)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4che kann nicht gel\00F6scht werden, weil sie in einer dynamischen Aktion referenziert wird (Seite: %0, Dynamische Aktion: ''%1'', Attribut: ''When'').')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274106670908864882)
,p_name=>'BUTTON.SUBMIT'
,p_message_language=>'de'
,p_message_text=>'Weiterleiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274102535742864879)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_language=>'de'
,p_message_text=>'Muss in einem "Onclick"-Attribut verwendet werden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274106073693864881)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_language=>'de'
,p_message_text=>'Muss in einem "href"-Attribut verwendet werden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273515430391864459)
,p_name=>'BUTTONS'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4chen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273972102655864774)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4chenattribute')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273424328197864398)
,p_name=>'BUTTON_CSS_CLASSES'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4chen-CSS-Klassen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273622816537864531)
,p_name=>'BUTTON_ID'
,p_message_language=>'de'
,p_message_text=>unistr('Generierte Schaltfl\00E4chen-ID ist die statische ID der Schaltfl\00E4che sofern definiert. Sonst handelt es sich um eine intern generierte ID im Format ''B'' || [Interne Schaltfl\00E4chen-ID]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274742472215865332)
,p_name=>'BUTTON_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4che: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273977348904864790)
,p_name=>'BUTTON_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4chen-Template')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273512372587864457)
,p_name=>'BYTES'
,p_message_language=>'de'
,p_message_text=>'Byte'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273917898122864736)
,p_name=>'BY_NEXT_PATCH'
,p_message_language=>'de'
,p_message_text=>unistr('Nach n\00E4chstem Patch')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273917947269864736)
,p_name=>'BY_NEXT_RELEASE'
,p_message_language=>'de'
,p_message_text=>unistr('Nach n\00E4chster Version')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274841813380865403)
,p_name=>'CA.ABOUT'
,p_message_language=>'de'
,p_message_text=>'Info'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274808132097865379)
,p_name=>'CA.ABOUT.PAGE'
,p_message_language=>'de'
,p_message_text=>'Info-Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274808096504865379)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Nehmen Sie eine Seite mit Informationen zu dieser Anwendung auf, die eine Beschreibung der Anwendung, die Anwendungsversion und eine Seitenanzahl enth\00E4lt.'),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273632923400864537)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_language=>'de'
,p_message_text=>'Inhaltscontainer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274842008493865403)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Info-Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274842167594865403)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_language=>'de'
,p_message_text=>'Text zu dieser Anwendung kann hier platziert werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274841729333865403)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_language=>'de'
,p_message_text=>'Info zu dieser Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274854032574865411)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_language=>'de'
,p_message_text=>'Informationen zum Vorschaurelease'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274808409249865379)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_language=>'de'
,p_message_text=>'Zugriffskontrolle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274844354159865404)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_language=>'de'
,p_message_text=>'Zugriffskontrollaktionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274833840119865397)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_language=>'de'
,p_message_text=>'Konfiguration der Zugriffskontrolle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274806831099865378)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_language=>'de'
,p_message_text=>'Rollenbasierte Benutzerauthentifizierung aktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274808583969865379)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Integrieren Sie rollenbasierte Benutzerauthentifizierung in Ihre Anwendung.',
unistr('Benutzer k\00F6nnen als Administratoren, Beitragende oder Leseberechtigte definiert werden.'),
unistr('Sie k\00F6nnen dann leicht definieren, dass verschiedenen Rollen ein jeweils unterschiedlicher Zugriff auf verschiedene Komponenten in Ihrer Anwendung gew\00E4hrt wird, beispielsweise auf Seiten, Men\00FCeintr\00E4ge, Regionen, Spalten, Elemente, Schaltfl\00E4chen und s')
||'o weiter.</p>',
'<p>Umfasst die folgenden Komponenten:',
'<ul>',
'<li>Region auf der Administrationsseite mit Links zu Zugriffskontrollfeatures</li>',
'<li>Benutzertabelle zur Verwaltung der Zugriffskontrolle</li>',
unistr('<li>Konfigurationsseite zum Festlegen der Zugriffsebene f\00FCr authentifizierte Benutzer</li>'),
'<li>Konfigurationsseite zur Angabe, ob Benutzernamen E-Mail-Adressen sind</li>',
'<li>Seite zum Verwalten des Benutzerzugriffs, um den Benutzerzugriff zu melden und zu bearbeiten</li>',
unistr('<li>Seite "Benutzer hinzuf\00FCgen", um einen einzelnen Benutzer hinzuzuf\00FCgen</li>'),
unistr('<li>Seite zum Hinzuf\00FCgen mehrerer Benutzer, \00FCber die mehrere Benutzer (nur E-Mail-Benutzernamen) hinzugef\00FCgt werden k\00F6nnen</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274832754359865396)
,p_name=>'CA.ACCESS.ROLE'
,p_message_language=>'de'
,p_message_text=>'Rolle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274833461512865397)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_language=>'de'
,p_message_text=>'Zugriffsrollen-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273552368510864483)
,p_name=>'CA.ACCESS.ROLES'
,p_message_language=>'de'
,p_message_text=>'Rollen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274832834172865396)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_language=>'de'
,p_message_text=>'Account gesperrt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273580117715864502)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_language=>'de'
,p_message_text=>unistr('Best\00E4tigt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274844112423865404)
,p_name=>'CA.ACL.INFORMATION'
,p_message_language=>'de'
,p_message_text=>'ACL-Informationen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274844863154865405)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_language=>'de'
,p_message_text=>'Keine ausreichenden Berechtigungen. Benutzer ist kein Administrator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274844957576865405)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_language=>'de'
,p_message_text=>unistr('Sie sind nicht berechtigt, diese Anwendung anzuzeigen. Entweder wurde Ihnen kein Zugriff gew\00E4hrt, oder Ihr Account ist gesperrt. Wenden Sie sich an den Anwendungsadministrator.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274845004115865405)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_language=>'de'
,p_message_text=>'Keine ausreichenden Berechtigungen. Benutzer ist kein Beitragender'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274834500177865398)
,p_name=>'CA.ACL.SAVED'
,p_message_language=>'de'
,p_message_text=>'Zugriffskontrolleinstellungen wurden gespeichert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274839262932865401)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_language=>'de'
,p_message_text=>unistr('HTML f\00FCr Aktionsschaltfl\00E4che')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274838186572865400)
,p_name=>'CA.ACTION.LABEL'
,p_message_language=>'de'
,p_message_text=>'Aktionslabel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274838224439865400)
,p_name=>'CA.ACTION.LINK'
,p_message_language=>'de'
,p_message_text=>'Aktionslink'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274840897118865402)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_language=>'de'
,p_message_text=>unistr('HTML f\00FCr Aktionslink')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274826353012865392)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_language=>'de'
,p_message_text=>'Aktion wurde verarbeitet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274831849868865396)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_language=>'de'
,p_message_text=>unistr('Aktivit\00E4t pro Stunde')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274866139177865420)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_language=>'de'
,p_message_text=>unistr('Dashboard-Aktivit\00E4t')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274808602027865379)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_language=>'de'
,p_message_text=>unistr('Aktivit\00E4tsberichte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274807842039865379)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Berichte zu Benutzeraktivit\00E4t und Fehlern einbeziehen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274808777205865379)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Nehmen Sie zahlreiche Berichte zur Endbenutzeraktivit\00E4t f\00FCr Ihre Anwendung auf. Bestimmen Sie die aktivsten Benutzer, die am h\00E4ufigsten verwendeten Seiten, die Performance der Seiten und die ausgel\00F6sten Fehler. Dies erm\00F6glicht ein besseres Verst\00E4n')
||unistr('dnis dar\00FCber, wie Ihre Anwendung genutzt wird, und zeigt Bereiche mit Verbesserungspotenzial auf.</p>'),
'<p>Umfasst Folgendes:',
'<ul>',
'<li>Bericht zu Top-Benutzern</li>',
'<li>Bericht zum Anwendungsfehlerlog</li>',
unistr('<li>Seitenperformance, Aktivit\00E4t und Performance nach Seite</li>'),
unistr('<li>Bericht zur Anwendungsaktivit\00E4t nach Seite</li>'),
'<li>Detailbericht zu Seitenansichten</li>',
'',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273954570692864762)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_language=>'de'
,p_message_text=>unistr('Tats\00E4chliches Anfangsdatum')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274844077723865404)
,p_name=>'CA.ADD'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274839477159865401)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('E-Mail-Template hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274857009162865413)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_language=>'de'
,p_message_text=>unistr('Mehrere Benutzer hinzuf\00FCgen - Schritt 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274842398906865403)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_language=>'de'
,p_message_text=>unistr('Neues %0 hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274825309876865391)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_language=>'de'
,p_message_text=>unistr('Benachrichtigung hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274697808931865301)
,p_name=>'CA.ADD.PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Seite hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274833589263865397)
,p_name=>'CA.ADD.USER'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzer hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274857483542865414)
,p_name=>'CA.ADD.USERS'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzer hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274810259527865381)
,p_name=>'CA.ADDING.PAGES'
,p_message_language=>'de'
,p_message_text=>unistr('Seiten werden hinzugef\00FCgt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274810771739865381)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Klicken Sie auf <strong>Seite hinzuf\00FCgen</strong>, um der Anwendung eine Seite hinzuzuf\00FCgen. W\00E4hlen Sie anschlie\00DFend einen Seitentyp (z.B. Leer, Diagramm, Formular, Bericht usw.) aus, und definieren Sie die zugeh\00F6rigen Attribute. M\00F6glicherweise m\00FC')
||unistr('ssen Sie auch eine g\00FCltige Tabelle oder View angeben oder Datenbankobjekte im Workspace mit SQL Workshop vorbereiten.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274840286283865402)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_language=>'de'
,p_message_text=>'Erweitert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273953857394864762)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_language=>'de'
,p_message_text=>unistr('Zus\00E4tzliche Informationen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274833216817865397)
,p_name=>'CA.ADDRESS'
,p_message_language=>'de'
,p_message_text=>'Adresse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274813440830865383)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_language=>'de'
,p_message_text=>'Zugriffskontrolle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274814078390865383)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Zugriffsebene f\00FCr authentifizierte Benutzer dieser Anwendung festlegen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274812504683865382)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_language=>'de'
,p_message_text=>unistr('Aktivit\00E4tsberichte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274813588967865383)
,p_name=>'CA.ADMIN.ADD'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274815286341865384)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_language=>'de'
,p_message_text=>'Administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274813939086865383)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_language=>'de'
,p_message_text=>'Administratoren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273989569888864799)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_language=>'de'
,p_message_text=>'Anwendungskonfiguration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274100269752864877)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzeroberfl\00E4che')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274848882027865408)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_language=>'de'
,p_message_text=>'Anwendungsadministration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274848944365865408)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_language=>'de'
,p_message_text=>'Komponente verwalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274812100917865382)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_language=>'de'
,p_message_text=>'Theme-Stilauswahl'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274812217620865382)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_language=>'de'
,p_message_text=>'Look-and-Feel der Standardanwendung festlegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274811883489865382)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_language=>'de'
,p_message_text=>'Konfigurationsoptionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274811703040865382)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_language=>'de'
,p_message_text=>'Anwendungsfeatures aktivieren oder deaktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274812885790865382)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_language=>'de'
,p_message_text=>'Anwendungsfehlerlog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274812968677865382)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_language=>'de'
,p_message_text=>'Bericht zu Fehlern, die von dieser Anwendung protokolliert wurden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274812382415865382)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Anwendungseinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274812430904865382)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_language=>'de'
,p_message_text=>'Anwendungsname und Kurzbeschreibung festlegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274811930756865382)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_language=>'de'
,p_message_text=>'Anwendungsupdates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274812045901865382)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_language=>'de'
,p_message_text=>'Liste der Anwendungsupdates verwalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274811475743865381)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_language=>'de'
,p_message_text=>'Konfiguration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274813874925865383)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_language=>'de'
,p_message_text=>'Beitragende'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274864918083865419)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_language=>'de'
,p_message_text=>'Dashboard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274864849190865419)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Metriken zur Anwendungsaktivit\00E4t anzeigen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274816942130865385)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_language=>'de'
,p_message_text=>'Standardzeitzone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274817034509865385)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Standardzeitzone f\00FCr diese Anwendung festlegen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274814761685865384)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_language=>'de'
,p_message_text=>'E-Mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274817111973865385)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Einstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274817218759865385)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Festlegen, ob E-Mail gesendet werden soll, und wenn ja, Person f\00FCr "Antwort an" angeben')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274814260010865383)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_language=>'de'
,p_message_text=>'Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274814533337865384)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Feedbackeinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274814690908865384)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Verwalten, ob Anh\00E4nge zul\00E4ssig sein sollen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274814326292865383)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_language=>'de'
,p_message_text=>'Benutzerfeedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274814480584865384)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_language=>'de'
,p_message_text=>'Bericht zum gesamten von Anwendungsbenutzern abgegebenen Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274814872467865384)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274814977310865384)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_language=>'de'
,p_message_text=>'Die von dieser Anwendung verwendeten HTML- und CSS-E-Mail-Templates verwalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274811519350865381)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_language=>'de'
,p_message_text=>'Benachrichtigungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274811696670865382)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_language=>'de'
,p_message_text=>'Benachrichtigungen auf der Homepage anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274849510648865408)
,p_name=>'CA.ADMIN.PAGE'
,p_message_language=>'de'
,p_message_text=>'Administrationsseite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274813030145865383)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_language=>'de'
,p_message_text=>'Seiten-Performance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274813167043865383)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Bericht zu Aktivit\00E4t und Performance nach Anwendungsseite')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274813210546865383)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_language=>'de'
,p_message_text=>'Seitenansichten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274813337581865383)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Bericht zu jeder Seitenansicht nach Benutzer, einschlie\00DFlich Zugriffsdatum und verstrichene Zeit')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274813749055865383)
,p_name=>'CA.ADMIN.READERS'
,p_message_language=>'de'
,p_message_text=>'Leseberechtigte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274858184746865414)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_language=>'de'
,p_message_text=>'E-Mail senden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274858214617865414)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_language=>'de'
,p_message_text=>'Auf Template basierende E-Mail von dieser Anwendung senden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274812617311865382)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_language=>'de'
,p_message_text=>'Topbenutzer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274812711233865382)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_language=>'de'
,p_message_text=>'Bericht zu Seitenansichten, nach Benutzer zusammengefasst'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274813694379865383)
,p_name=>'CA.ADMIN.USERS'
,p_message_language=>'de'
,p_message_text=>'Benutzer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274814181556865383)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Zugriffskontrolleinstellungen \00E4ndern und Zugriffskontrolle deaktivieren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274815079729865384)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274815141713865384)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_language=>'de'
,p_message_text=>'Das von dieser Anwendung gesendete E-Mail-Log anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273736163783864608)
,p_name=>'CA.ADVANCED'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Erweitert</strong> - Damit k\00F6nnen Sie erweiterte Optionen einblenden.'),
'    <ul>',
unistr('      <li><strong>Als Homepage festlegen</strong> - Legen Sie diese Seite als Homepage f\00FCr die Anwendung fest.<br>'),
'      &nbsp;&nbsp;&nbsp;Alle zuvor als Homepage definierten Seiten werden aktualisiert.</li>',
unistr('      <li><strong>Als Administrationsseite festlegen</strong> - F\00FCgen Sie diese Seite unter "Administration" und nicht als normale Seite in der Anwendung hinzu. Greifen Sie darauf zu, indem Sie im Hauptmen\00FC auf "Administration" klicken und die Seite ')
||unistr('in der Liste "Anwendungsadministration" ausw\00E4hlen.<br>'),
'        <em><strong>Hinweis:</strong> Eine Seite kann nicht sowohl Homepage als auch Administrationsseite sein.</em></li>',
'      &nbsp;<br>',
unistr('      <li><strong>Hilfe zu den Seiten</strong> - Geben Sie Text ein, der dem Hilfetext f\00FCr die Seite hinzugef\00FCgt werden soll.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273606437479864520)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
' <li><strong>Erweitert</strong> - Blenden Sie erweiterte Optionen ein.',
'    <ul>',
unistr('      <li><strong>Hilfe zu den Seiten</strong> - Geben Sie Text ein, der zum Hilfetext f\00FCr die Seite hinzugef\00FCgt werden soll.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274849927932865408)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Erweiterte Einstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274850061628865408)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Legen Sie zus\00E4tzliche Definitionen, Sicherheit und Globalisierungseinstellungen fest. Diese Einstellungen k\00F6nnen w\00E4hrend der Erstellung der Anwendung festgelegt und nach der Erstellung auch bearbeitet werden.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274853069224865411)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_language=>'de'
,p_message_text=>'<p>Weitere Informationen zu den jeweiligen Einstellungen finden Sie in der entsprechenden Hilfe ( <span class="fa fa-question-circle" aria-hidden="true"></span> ).</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274858880608865415)
,p_name=>'CA.AFTER.ROWS'
,p_message_language=>'de'
,p_message_text=>'Nach Zeilen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274839147800865401)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_language=>'de'
,p_message_text=>unistr('HTML f\00FCr "Nach Zeilen"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274842286262865403)
,p_name=>'CA.ALL.COLS'
,p_message_language=>'de'
,p_message_text=>'Alle Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274838375582865400)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_language=>'de'
,p_message_text=>'Opt-out zulassen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273947404871864757)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_language=>'de'
,p_message_text=>unistr('Ausf\00FChrungen im eingeschr\00E4nkten Modus zulassen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274831767265865396)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_language=>'de'
,p_message_text=>'Anwendungsfehlerlog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274827651898865393)
,p_name=>'CA.APP.NAME'
,p_message_language=>'de'
,p_message_text=>'Anwendungsname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274000400311864807)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_language=>'de'
,p_message_text=>'Gibt an, ob die Zugriffskontrolle eingeschaltet ist oder nicht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274000591130864807)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_language=>'de'
,p_message_text=>'Die Standardzugriffsebene, die authentifizierten Benutzern erteilt wird, die nicht in der Access-Control-Liste enthalten sind'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274828005021865393)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_language=>'de'
,p_message_text=>'Anwendungseinstellungen wurden aktualisiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274827820116865393)
,p_name=>'CA.APP.SUBTITLE'
,p_message_language=>'de'
,p_message_text=>'Kurzbeschreibung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274827979309865393)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_language=>'de'
,p_message_text=>'Der hier eingegebene Text wird auf der Homepage der Anwendung unter dem Anwendungsnamen angezeigt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274817318794865386)
,p_name=>'CA.APPEARANCE'
,p_message_language=>'de'
,p_message_text=>'Darstellung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274817445094865386)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Definieren Sie das Standardfarbschema f\00FCr die Anwendung (Theme-Stil), die Position der Navigation und das f\00FCr die Anwendung verwendete Symbol.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274836841153865399)
,p_name=>'CA.APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274823980995865390)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_language=>'de'
,p_message_text=>'Darstellung der Anwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274817948767865386)
,p_name=>'CA.APPLICATION.ICON'
,p_message_language=>'de'
,p_message_text=>'Anwendungssymbol'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274818053414865386)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Klicken Sie auf <strong>Neues Symbol ausw\00E4hlen</strong>, um die Symbolfarbe und eines der verf\00FCgbaren Symbole auszuw\00E4hlen. Ihre Auswahl wird auf der Homepage der Anwendung angezeigt.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274818308757865386)
,p_name=>'CA.APPLICATION.ID'
,p_message_language=>'de'
,p_message_text=>'Anwendungs-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274818498014865386)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Geben Sie eine eindeutige, numerische ID f\00FCr die Anwendung ein. Dieses Feld enth\00E4lt standardm\00E4\00DFig eine automatisch generierte ID.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274837475169865400)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_language=>'de'
,p_message_text=>'Anwendungsseite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274829632233865394)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_language=>'de'
,p_message_text=>'Anwendungs-Sessions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274808219767865379)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Anwendungseinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274807184341865378)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_language=>'de'
,p_message_text=>'Anwendungsname und Kurzbeschreibung festlegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274808302836865379)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erm\00F6glichen Sie Anwendungsadministratoren, verschiedene Einstellungen zu aktualisieren, beispielsweise den Namen und eine Beschreibung der Anwendung, die Standardzeitzone und mehr.</p>'),
'<p>Umfasst die folgenden Komponenten:',
'<ul>',
unistr('<li>Listeneintrag und Formular f\00FCr Administrationsseite</li>'),
unistr('<li>M\00F6glichkeit zum Festlegen des Anwendungsnamens</li>'),
unistr('<li>M\00F6glichkeit zum Festlegen eines Untertitels in der Hero-Region der Homepage</li>'),
unistr('<li>M\00F6glichkeit zum Festlegen von Feedbackempf\00E4ngern, falls Feedback verwendet wird</li>'),
unistr('<li>M\00F6glichkeit zum Festlegen einer Standardzeitzone f\00FCr die Anwendung</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274863906379865418)
,p_name=>'CA.APPLICATIONITEM'
,p_message_language=>'de'
,p_message_text=>'Anwendungselement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274865762742865420)
,p_name=>'CA.APPLY'
,p_message_language=>'de'
,p_message_text=>'Anwenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274867509633865421)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_language=>'de'
,p_message_text=>'Anwendungsstandardwerte werden angewendet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274823139890865390)
,p_name=>'CA.APPLY.CHANGES'
,p_message_language=>'de'
,p_message_text=>unistr('\00C4nderungen anwenden')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274865508785865419)
,p_name=>'CA.APPLY.FILTERS'
,p_message_language=>'de'
,p_message_text=>'Filter anwenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274098189542864876)
,p_name=>'CA.APP_BANNER'
,p_message_language=>'de'
,p_message_text=>'Anwendung wurde mit Assistent zum Erstellen von Anwendungen %0 erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274099440218864877)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_language=>'de'
,p_message_text=>'Einstellung speichern'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274869741254865422)
,p_name=>'CA.ATTACHMENT'
,p_message_language=>'de'
,p_message_text=>'Anhang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273813861904864663)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_language=>'de'
,p_message_text=>unistr('Anzahl von Anh\00E4ngen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274869848122865423)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_language=>'de'
,p_message_text=>'Anhangname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273813795066864663)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_language=>'de'
,p_message_text=>unistr('Anhangsgr\00F6\00DFe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274865868888865420)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_language=>'de'
,p_message_text=>unistr('Attributstandardwerte wurden bereits definiert f\00FCr: %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274833944630865397)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_language=>'de'
,p_message_text=>'Jeder authentifizierte Benutzer darf auf diese Anwendung zugreifen'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274819106429865387)
,p_name=>'CA.AUTHENTICATION'
,p_message_language=>'de'
,p_message_text=>'Authentifizierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274819259313865387)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('<p>W\00E4hlen Sie aus, wie Benutzer in der Anwendung authentifiziert werden sollen.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273950120803864759)
,p_name=>'CA.AUTO.DROP'
,p_message_language=>'de'
,p_message_text=>unistr('Automatisches L\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274830396000865395)
,p_name=>'CA.AVG.ELAPSED'
,p_message_language=>'de'
,p_message_text=>'Durchschnittlich verstrichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273997566870864804)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck zum Jobbericht')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273814528567864664)
,p_name=>'CA.BCC'
,p_message_language=>'de'
,p_message_text=>'Bcc'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274858799570865415)
,p_name=>'CA.BEFORE.ROWS'
,p_message_language=>'de'
,p_message_text=>'Vor Zeilen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274839085783865401)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_language=>'de'
,p_message_text=>unistr('HTML f\00FCr "Vor Zeilen"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274840595550865402)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Vor Zeileninhalt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274815833975865385)
,p_name=>'CA.BLANK'
,p_message_language=>'de'
,p_message_text=>unistr('Leere Seite hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274815945708865385)
,p_name=>'CA.BLANK.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erstellen Sie eine leere Seite als Platzhalter. Sobald Sie die Anwendung erstellt haben, k\00F6nnen Sie in Page Designer leicht Regionen auf der Seite erstellen.</p>'),
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Seitenname</strong> (Obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
'<!--  <li><strong>Seitennavigation einbeziehen</strong> - Aktivieren Sie diese Option, um eine Kartenliste aller anderen in der Anwendung definierten Seiten anzuzeigen.<br>',
'      &nbsp;&nbsp;&nbsp;Diese Option wird in der Regel auf der Homepage Ihrer Anwendung verwendet.</li>',
'-->',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274849248250865408)
,p_name=>'CA.BLUEPRINT'
,p_message_language=>'de'
,p_message_text=>'Anwendungs-Blueprint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274849364145865408)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Im Blueprint ist die Anwendungsdefinition im JSON-Format angegeben.</p>',
unistr('<p>Wenn Sie diese Seite zum ersten Mal \00F6ffnen, wird die aktuelle Anwendungsdefinition in ein JSON-Dokument umgewandelt und angezeigt. Sie k\00F6nnen das Dokument bearbeiten und die Anwendungseigenschaften aktualisieren. Klicken Sie dann auf <strong>Bluep')
||unistr('rint anwenden</strong>, um die aktuellen Anwendungsdetails zu \00E4ndern.</p>'),
'<p>&nbsp;</p>',
unistr('<p>Wenn Sie eine gro\00DFe Anzahl \00E4hnlicher Seiten erstellen m\00FCssen, kopieren Sie den relevanten JSON-Code f\00FCr eine Seite, f\00FCgen Sie ihn mehrmals ein und passen Sie ihn dann geringf\00FCgig an. Diese Methode ist erheblich schneller, als die manuelle Erstellu')
||unistr('ng einzelner Seiten \00FCber <strong>Seite hinzuf\00FCgen</strong>.</p>'),
unistr('<p>Klicken Sie auf <strong>Vorherigen Blueprint laden</strong>, um den Blueprint mit der Definition aus einer zuvor generierten Anwendung zu ersetzen. Auf diese Weise k\00F6nnen Sie ein Anwendungsdesign einfach replizieren, indem Sie zus\00E4tzliche Seiten h')
||unistr('inzuf\00FCgen, die Features \00E4ndern oder die Einstellungen optimieren, bevor Sie die Anwendung erneut generieren.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274837907896865400)
,p_name=>'CA.BODY1.TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Text f\00FCr Hauptteil 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274838025665865400)
,p_name=>'CA.BODY2.TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Text f\00FCr Hauptteil 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274859106858865415)
,p_name=>'CA.BOTH'
,p_message_language=>'de'
,p_message_text=>'Beide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274824349157865391)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_language=>'de'
,p_message_text=>'Verzweigung zur Admin-Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273735097626864607)
,p_name=>'CA.BUTTON.BAR'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4chenleiste')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274824098223865390)
,p_name=>'CA.BUTTONS'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4chen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274816505853865385)
,p_name=>'CA.CALENDAR'
,p_message_language=>'de'
,p_message_text=>unistr('Kalenderseite hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274816676636865385)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Erstellen Sie eine Seite, die einen Kalender anzeigt.</p>',
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Seitenname</strong> (Obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
unistr('  <li><strong>Tabelle oder View</strong> (Obligatorisch) - W\00E4hlen Sie das Datenbankobjekt f\00FCr den Kalender aus.</li>'),
unistr('  <li><strong>Anzeigespalte</strong> (Obligatorisch) - W\00E4hlen Sie die Spalte aus der Tabelle oder View aus, die in den Kalenderereignissen angezeigt werden soll.</li>'),
unistr('  <li><strong>Startdatumsspalte</strong> (Obligatorisch) - W\00E4hlen Sie die Datumsspalte aus der Tabelle oder View aus, die als Startdatum f\00FCr Kalenderereignisse verwendet werden soll.</li>'),
unistr('  <li><strong>Enddatumsspalte</strong> - W\00E4hlen Sie die Datumsspalte aus der Tabelle oder View aus, die als Enddatum f\00FCr Kalenderereignisse verwendet werden soll.<br>'),
'      &nbsp;&nbsp;&nbsp;Wenn das Enddatum angegeben ist, werden dauerbasierte Ereignisse angezeigt. </li>',
unistr('  <li><strong>Zeit anzeigen</strong> - W\00E4hlen Sie <strong>Ja</strong> aus, um den Zeitanteil f\00FCr Ereignisse anzuzeigen und um Wochen- und Tageskalenderansichten zu aktivieren. W\00E4hlen Sie <strong>Nein</strong> aus, um nur die Datumsangaben f\00FCr Ereigni')
||'sse anzuzeigen.</li>',
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274823084301865390)
,p_name=>'CA.CANCEL'
,p_message_language=>'de'
,p_message_text=>'Abbrechen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274824946685865391)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_language=>'de'
,p_message_text=>'Dialog abbrechen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273715167034864593)
,p_name=>'CA.CANCEL.MODAL'
,p_message_language=>'de'
,p_message_text=>'Modalmodus abbrechen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274834870394865398)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_language=>'de'
,p_message_text=>unistr('Sie k\00F6nnen aus Ihrem eigenen Datensatz keine Administrationsrechte entfernen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274866738548865420)
,p_name=>'CA.CARD'
,p_message_language=>'de'
,p_message_text=>unistr('Kartenseite hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274866665389865420)
,p_name=>'CA.CARD.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Erstellen Sie eine Seite, die Karten anzeigt.</p>',
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Seitenname</strong> (Obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
unistr('  <li><strong>Tabelle oder View</strong> (Obligatorisch) - W\00E4hlen Sie das Datenbankobjekt f\00FCr die Karte aus.</li>'),
unistr('  <li><strong>Kartentitel</strong> (Obligatorisch) - W\00E4hlen Sie die Spalte aus der Tabelle oder View aus, die als Titel f\00FCr die Karte verwendet werden soll.</li>'),
unistr('  <li><strong>Beschreibungsspalte</strong> (Obligatorisch) - W\00E4hlen Sie die Spalte aus der Tabelle oder View aus, die als Beschreibung f\00FCr die Karte verwendet werden soll.</li>'),
unistr('  <li><strong>Spalte mit zus\00E4tzlichem Text</strong> - W\00E4hlen Sie die Spalte aus der Tabelle oder View aus, die als sekund\00E4re Beschreibung f\00FCr die Karte verwendet werden soll.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274865243606865419)
,p_name=>'CA.CARDS'
,p_message_language=>'de'
,p_message_text=>'Karten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274865364617865419)
,p_name=>'CA.CARDS.VIEW'
,p_message_language=>'de'
,p_message_text=>'Kartenansicht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273814609358864664)
,p_name=>'CA.CC'
,p_message_language=>'de'
,p_message_text=>'Cc'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274098803105864876)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_language=>'de'
,p_message_text=>unistr('Filter \00E4ndern')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274815641071865384)
,p_name=>'CA.CHART'
,p_message_language=>'de'
,p_message_text=>unistr('Diagrammseite hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274815708542865384)
,p_name=>'CA.CHART.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erstellen Sie eine Seite, die entweder ein Fl\00E4chen-, Balken-, Linien- oder Tortendiagramm anzeigt.</p>'),
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Seitenname</strong> (Obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
unistr('  <li><strong>Diagrammtyp</strong> - W\00E4hlen Sie den anzuzeigenden Diagrammtyp aus [<strong>Fl\00E4che</strong>, <strong>Balken</strong>, <strong>Linie</strong>, <strong>Torte</strong>].</li>'),
unistr('  <li><strong>Tabelle oder View</strong> (Obligatorisch) - W\00E4hlen Sie das Datenbankobjekt f\00FCr das Diagramm aus.</li>'),
unistr('  <li><strong>Labelspalte</strong> (Obligatorisch) - W\00E4hlen Sie die Spalte aus der Tabelle oder View aus, die als Label f\00FCr das Diagramm verwendet werden soll.</li>'),
'  <li><strong>Wertaggregation</strong> - Legen Sie fest, wie die Wertspalte angezeigt bzw. aggregiert werden soll<br>',
'      &nbsp;&nbsp;&nbsp;[Spaltenwert, Summe, Anzahl].</li>',
unistr('  <li><strong>Wertspalte</strong> (Obligatorisch) - W\00E4hlen Sie eine numerische Spalte aus der Tabelle oder View aus, die zur Berechnung der angezeigten Diagrammwerte verwendet wird.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274816006858865385)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h3>Beispiele</h3>',
'<p>Sehen Sie sich die Beispiele zur Verwendung der unterschiedlichen <strong>Zusammenfassung</strong>stypen an:</p>',
unistr('<p><strong>Beispiel 1:</strong> Zeigen Sie ein Mitarbeiterdiagramm mit der Personalnummer des Managers f\00FCr jeden Mitarbeiter an.'),
'<code><ul>',
unistr('  <li>Tabelle oder View - W\00E4hlen Sie EMP.</li>'),
unistr('  <li>Labelspalte - W\00E4hlen Sie ENAME.</li>'),
unistr('  <li>Zusammenfassung - W\00E4hlen Sie <u><strong>Spaltenwert</strong></u>.</li>'),
unistr('  <li>Wertspalte - W\00E4hlen Sie MGR.</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>Beispiel 2:</strong> Zeigen Sie ein Mitarbeiterdiagramm an, das das Gesamtgehalt f\00FCr jede Stelle zeigt.'),
'<code><ul>',
unistr('  <li>Tabelle oder View - W\00E4hlen Sie EMP.</li>'),
unistr('  <li>Labelspalte - W\00E4hlen Sie JOB.</li>'),
unistr('  <li>Zusammenfassung - W\00E4hlen Sie <u><strong>Summe</strong></u>.</li>'),
unistr('  <li>Wertespalte - W\00E4hlen Sie SAL.</li>'),
'</ul></code>',
'</p>',
'<p><strong>Beispiel 3:</strong> Zeigen Sie ein Mitarbeiterdiagramm an, das die Anzahl der Mitarbeiter in den einzelnen Abteilungen zeigt.',
'<code><ul>',
unistr('  <li>Tabelle oder View - W\00E4hlen Sie EMP.</li>'),
unistr('  <li>Labelspalte - W\00E4hlen Sie DEPTNO.</li>'),
unistr('  <li>Zusammenfassung - W\00E4hlen Sie <u><strong>Anzahl</strong></u>.</li>'),
unistr('  <li>Wertespalte - W\00E4hlen Sie EMPNO.</li>'),
'</ul></code>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273952190101864760)
,p_name=>'CA.CLIENT.ID'
,p_message_language=>'de'
,p_message_text=>'Client-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274869924449865423)
,p_name=>'CA.CLOSE'
,p_message_language=>'de'
,p_message_text=>unistr('Schlie\00DFen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273580090607864502)
,p_name=>'CA.CLOSED'
,p_message_language=>'de'
,p_message_text=>'Geschlossen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274867949199865421)
,p_name=>'CA.COLUMN'
,p_message_language=>'de'
,p_message_text=>'Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274843851771865404)
,p_name=>'CA.COLUMN.1'
,p_message_language=>'de'
,p_message_text=>'Spalte 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274843903928865404)
,p_name=>'CA.COLUMN.2'
,p_message_language=>'de'
,p_message_text=>'Spalte 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274831240473865395)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_language=>'de'
,p_message_text=>'Spaltenalias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274863715266865418)
,p_name=>'CA.COMMENTS'
,p_message_language=>'de'
,p_message_text=>'Kommentare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274828982520865394)
,p_name=>'CA.COMPONENT.NAME'
,p_message_language=>'de'
,p_message_text=>'Komponentenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274833775891865397)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_language=>'de'
,p_message_text=>'Access Control konfigurieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274824115824865390)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_language=>'de'
,p_message_text=>'Darstellung konfigurieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274824208323865390)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_language=>'de'
,p_message_text=>'<p>Die Darstellung der Anwendung wird durch den Theme-Stil definiert.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274827500561865393)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_language=>'de'
,p_message_text=>'Konfigurationsoptionen wurden aktualisiert. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274809409156865380)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Konfigurationsoptionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274807782753865379)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_language=>'de'
,p_message_text=>'Anwendungsfeatures aktivieren oder deaktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274809573169865380)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Damit k\00F6nnen Anwendungsadministratoren bestimmte Funktionen in der Anwendung aktivieren oder deaktivieren. Dieses Feature ist n\00FCtzlich, wenn Sie Features ausw\00E4hlen, bei denen zus\00E4tzliche Entwicklungsaufgaben ausgef\00FChrt werden m\00FCssen, bevor sie von')
||unistr(' Endbenutzern verwendet werden k\00F6nnen.<br>'),
unistr('Dieses Feature kann auch auf anwendungsspezifische Features ausgedehnt werden. Wenn Entwickler zus\00E4tzliche Erstelloptionen definieren und mit einer spezifischen Funktion in der Anwendung verkn\00FCpfen, k\00F6nnen diese zu den Konfigurationseinstellungen f\00FCr')
||unistr(' Administratoren hinzugef\00FCgt werden. Beispiel: In der App "Customer Tracker" k\00F6nnen Administratoren Features wie Kontakte, Laden von Daten, Geografie und mehr aktivieren oder deaktivieren.'),
'</p>',
'<p>Umfasst die folgenden Komponenten:',
'<ul>',
unistr('<li>Anwendungsfunktionen k\00F6nnen aktiviert und deaktiviert werden</li>'),
unistr('<li>Je nach Deployment k\00F6nnen selektive Features erm\00F6glicht werden</li>'),
unistr('<li>Erm\00F6glicht die Gruppierung zusammengeh\00F6riger Anwendungseinstellungen</li>'),
unistr('<li>Anwendungsentwickler k\00F6nnen Komponenten mit Erstelloptionen steuern</li>'),
unistr('<li>Verf\00FCgbar \00FCber die Administrationsseite</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273947015921864757)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Zugangsdatenname f\00FCr Anmeldung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273947147902864757)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Zugangsdateneigent\00FCmer f\00FCr Anmeldung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274677019237865286)
,p_name=>'CA.CONTEXT'
,p_message_language=>'de'
,p_message_text=>'Kontext'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274834268747865397)
,p_name=>'CA.CONTRIBUTOR'
,p_message_language=>'de'
,p_message_text=>'Beitragender'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273954026562864762)
,p_name=>'CA.CPU.USED'
,p_message_language=>'de'
,p_message_text=>'Belegte CPU'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274842766603865403)
,p_name=>'CA.CREATE'
,p_message_language=>'de'
,p_message_text=>'Erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274847808040865407)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_language=>'de'
,p_message_text=>'Administrationsseite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274845428007865405)
,p_name=>'CA.CREATE.APP'
,p_message_language=>'de'
,p_message_text=>'Anwendung wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274846556744865406)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_language=>'de'
,p_message_text=>'Anwendungsberechnungen werden erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274845826266865406)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_language=>'de'
,p_message_text=>'Anwendungssymbol wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274846449729865406)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_language=>'de'
,p_message_text=>'Anwendungselemente werden erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274846663608865406)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_language=>'de'
,p_message_text=>'Anwendungsprozesse werden erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274688090699865294)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_language=>'de'
,p_message_text=>'Anwendungseinstellungen werden erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274853824262865411)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273998884791864805)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_language=>'de'
,p_message_text=>'Anwendungsrollen werden erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274846014790865406)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_language=>'de'
,p_message_text=>'Autorisierungsschemas werden erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274846833179865406)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_language=>'de'
,p_message_text=>'Leere Seite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274845999408865406)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_language=>'de'
,p_message_text=>'Erstelloptionen werden erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274847205184865407)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_language=>'de'
,p_message_text=>'Kalenderseite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274860182201865416)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_language=>'de'
,p_message_text=>'Kartenseite erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274847053399865406)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_language=>'de'
,p_message_text=>'Diagrammseite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274847526824865407)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite mit klassischem Bericht wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274847146500865406)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_language=>'de'
,p_message_text=>'Dashboard-Seite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274845343715865405)
,p_name=>'CA.CREATE.END'
,p_message_language=>'de'
,p_message_text=>'Fertigstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274867499906865421)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_language=>'de'
,p_message_text=>'Facet-Suchseite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274848130034865407)
,p_name=>'CA.CREATE.FEATURES'
,p_message_language=>'de'
,p_message_text=>'Features werden erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274864702687865419)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite mit gefilterten Inhalten erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274846997027865406)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_language=>'de'
,p_message_text=>'Formularseite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274845508205865405)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_language=>'de'
,p_message_text=>'Globale Seite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274847701663865407)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_language=>'de'
,p_message_text=>'Navigationsliste der Homepage wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274847680187865407)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite mit interaktivem Grid wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274847414628865407)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite mit interaktivem Bericht wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274853538491865411)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_language=>'de'
,p_message_text=>'Master/Detail-Seiten erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274846224982865406)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_language=>'de'
,p_message_text=>'Navigationsleisten werden erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274849489533865408)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_language=>'de'
,p_message_text=>'Seitengruppe erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274848077361865407)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCbersetzung wird ausgef\00FChrt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274847923455865407)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCbersetzung von %0 wird ausgef\00FChrt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274847389722865407)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_language=>'de'
,p_message_text=>'Bericht- und Formularseite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274853727889865411)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_language=>'de'
,p_message_text=>'Blueprint speichern'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274846322392865406)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_language=>'de'
,p_message_text=>unistr('Verkn\00FCpfung wird erstellt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274846725777865406)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_language=>'de'
,p_message_text=>'Anmeldeseite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274845284980865405)
,p_name=>'CA.CREATE.START'
,p_message_language=>'de'
,p_message_text=>'Start'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274845665893865405)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_language=>'de'
,p_message_text=>unistr('Unterst\00FCtzende Objektskripte werden erstellt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274846105600865406)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_language=>'de'
,p_message_text=>'Textnachrichten werden erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274860249345865416)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_language=>'de'
,p_message_text=>'Timelineseite erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274867631922865421)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_language=>'de'
,p_message_text=>'Assistentenseite wird erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274826806096865392)
,p_name=>'CA.CREATED'
,p_message_language=>'de'
,p_message_text=>'Erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274826930457865392)
,p_name=>'CA.CREATED.BY'
,p_message_language=>'de'
,p_message_text=>'Erstellt von'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274815391424865384)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung wird erstellt ...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273947784054864757)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_language=>'de'
,p_message_text=>'Zugangsdatenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273953947545864762)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Eigent\00FCmer der Zugangsdaten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274827458183865393)
,p_name=>'CA.CURRENT.STATUS'
,p_message_language=>'de'
,p_message_text=>'Aktueller Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274848485289865407)
,p_name=>'CA.CUSTOM.QRY'
,p_message_language=>'de'
,p_message_text=>'Benutzerdefinierte Abfrage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274045699679864838)
,p_name=>'CA.CUSTOM.THEME'
,p_message_language=>'de'
,p_message_text=>'Benutzerdefiniertes Theme verwenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274045798491864838)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Legen Sie fest, dass der Assistent ein benutzerdefiniertes Theme anstelle des Universal Themes verwendet.</p>',
'',
unistr('<p>W\00E4hlen Sie ein Workspace Theme f\00FCr die Anwendung aus. Wenn das Theme Theme-Stile unterst\00FCtzt, k\00F6nnen Sie auch den Stil ausw\00E4hlen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273714863292864593)
,p_name=>'CA.CUSTOM_THEME'
,p_message_language=>'de'
,p_message_text=>'Benutzerdefiniertes Theme'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274849014549865408)
,p_name=>'CA.DASHBOARD'
,p_message_language=>'de'
,p_message_text=>unistr('Dashboard-Seite hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274675409264865285)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_language=>'de'
,p_message_text=>'Diagramm %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274849190909865408)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Erstellen Sie eine Dashboard-Seite mit mehreren Diagrammen.</p>',
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Seitenname</strong> (Obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
'  </ul>',
'</ul>',
'&nbsp;<br>',
'<p>Jedes Diagramm (Diagramm 1, Diagramm 2, Diagramm 3 und Diagramm 4) hat einen anderen Diagrammtyp als Standard und basiert auf <em>Beispieldaten</em>. ',
unistr('  Daher m\00FCssen Sie keine weiteren Details zum Hinzuf\00FCgen dieser Seite eingeben.'),
unistr('  Sie k\00F6nnen allerdings jedes Diagramm anpassen, indem Sie die Standardwerte durch eigene Werte ersetzen.<br>'),
'  Geben Sie die folgenden Attribute ein, um ein Diagramm anzupassen:</p>',
'<ul>',
unistr('  <li><strong>Diagrammname</strong> (Obligatorisch) - Geben Sie den Namen f\00FCr das Diagramm ein.</li>'),
unistr('  <li><strong>Diagrammtyp</strong> - W\00E4hlen Sie den anzuzeigenden Diagrammtyp aus [<strong>Fl\00E4che</strong>, <strong>Balken</strong>, <strong>Linie</strong>, <strong>Torte</strong>].</li>'),
unistr('  <li><strong>Tabelle oder View</strong> (Obligatorisch) - W\00E4hlen Sie das Datenbankobjekt f\00FCr das Diagramm aus.</li>'),
unistr('  <li><strong>Labelspalte</strong> (Obligatorisch) - W\00E4hlen Sie die Spalte aus der Tabelle oder View aus, die als Label f\00FCr das Diagramm verwendet werden soll.</li>'),
'  <li><strong>Wertaggregation</strong> - Legen Sie fest, wie die Wertspalte angezeigt bzw. aggregiert werden soll<br>',
'      &nbsp;&nbsp;&nbsp;[Spaltenwert, Summe, Anzahl].</li>',
unistr('  <li><strong>Wertspalte</strong> (Obligatorisch) - W\00E4hlen Sie eine numerische Spalte aus der Tabelle oder View aus, die zur Berechnung der angezeigten Diagrammwerte verwendet wird.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274860896096865416)
,p_name=>'CA.DATATYPE'
,p_message_language=>'de'
,p_message_text=>'Datentyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274861974197865417)
,p_name=>'CA.DATEFORMATMASK'
,p_message_language=>'de'
,p_message_text=>'Datumsformatmaske'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274828118284865393)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_language=>'de'
,p_message_text=>'Standardzeitzone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274828208727865393)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_language=>'de'
,p_message_text=>'Standardzeitzone wurde aktualisiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274849818541865408)
,p_name=>'CA.DEFAULTS'
,p_message_language=>'de'
,p_message_text=>'Standardwerte Anwendungsattribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274850199962865409)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('Mit diesem JSON-Dokument haben Sie feingranulierte Steuerung \00FCber die Generierung von Namen f\00FCr Berichts- und Formularspalten, Formatmasken usw. Sie k\00F6nnen auch Wertelisten und andere gemeinsame Komponenten definieren. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274867285553865421)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_language=>'de'
,p_message_text=>'Wertelistenattribute'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274867353438865421)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>F\00FCgen Sie ein Wertelistenattribut hinzu. Wertelisten k\00F6nnen in Tabellenspaltendefinitionen verwendet werden.</p>'),
'<p>Geben Sie die folgenden Attribute ein:',
'  <ul>',
unistr('    <li><strong>Name</strong> (obligatorisch): Geben Sie den Namen f\00FCr die Werteliste ein.</li>'),
unistr('    <li><strong>Typ</strong>: W\00E4hlen Sie den Wertelistentyp [Strukturiert, Dynamisch, Statisch] aus.<br>'),
unistr('      F\00FCr den Typ <u>Strukturiert</u>:'),
'      <ul>',
unistr('          <li><strong>Tabelle</strong> (obligatorisch): W\00E4hlen Sie die Tabelle oder View aus, auf der die Werteliste basieren soll.</li>'),
unistr('          <li><strong>Anzeigespalte</strong> (obligatorisch): W\00E4hlen Sie die Spalte aus, die Endbenutzern angezeigt werden soll.</li>'),
unistr('          <li><strong>Schl\00FCsselspalte</strong> (obligatorisch): W\00E4hlen Sie den Spaltenwert aus, der zur\00FCckgegeben werden soll. Dies ist im Allgemeinen der Prim\00E4rschl\00FCssel f\00FCr die Tabelle.</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      F\00FCr den Typ <u>Dynamisch</u>:'),
'      <ul>',
unistr('          <li><strong>SQL-Abfrage</strong> (obligatorisch): Geben Sie eine g\00FCltige SQL-SELECT-Anweisung ein, die zwei Werte zur\00FCckgibt (Anzeigewert und R\00FCckgabewert).</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      F\00FCr den Typ <u>Statisch</u>:'),
'      <ul>',
unistr('          <li><strong>Statische Werteliste</strong> (obligatorisch): Geben Sie eine g\00FCltige statische Liste in einem der folgenden Formate ein:'),
'          <ul>',
'            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>Liste wird in der Eingabereihenfolge angezeigt</li>',
'            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>Liste wird alphabetisch sortiert</li>',
unistr('            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>Anzeigewert und R\00FCckgabewert sind identisch</li>'),
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274868457389865421)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_language=>'de'
,p_message_text=>'Berichtsattribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274868530871865422)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Bearbeiten Sie die Attribute f\00FCr alle Berichte.</p>'),
'<p>Geben Sie die folgenden Attribute ein:',
'  <ul>',
unistr('    <li><strong> Zeilen pro Seite</strong>: Geben Sie an, wie viele Berichtszeilen standardm\00E4\00DFig angezeigt werden sollen.</li>'),
'    <li><strong>Paginierungsmethode</strong>: Legen Sie fest, wie die Berichtspaginierung angezeigt wird.</li>',
unistr('    <li><strong>Zahlenformatmaske</strong>: Geben Sie die Formatmaske f\00FCr Zahlenspalten und -elemente ein.</li>'),
unistr('    <li><strong>Datumsformatmaske</strong>: Geben Sie die Formatmaske f\00FCr Datumsspalten und -elemente ein.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274868248475865421)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_language=>'de'
,p_message_text=>'Tabellenattribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274868074111865421)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_language=>'de'
,p_message_text=>'Tabellenspaltenattribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274868195999865421)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Bearbeiten Sie die Attribute f\00FCr die ausgew\00E4hlte Tabellenspalte.</p>'),
'<p>Geben Sie die folgenden Attribute ein:',
'  <ul>',
unistr('    <li><strong>Tabelle</strong> (nur Anzeige): Die verkn\00FCpfte Tabelle.</li>'),
'    <li><strong>Spalte</strong> (nur Anzeige): Die Spalte, mit der die Attribute definiert sind.</li>',
unistr('    <li><strong>Label</strong>: Geben Sie das Label f\00FCr Berichts\00FCberschriften und Formularlabels ein.</li>'),
unistr('    <li><strong>Formularsteuerelement</strong>: W\00E4hlen Sie den Elementtyp f\00FCr Formulare.</li>'),
unistr('    <li><strong>Werteliste</strong>: W\00E4hlen Sie eine vorhandene Werteliste, mit der benutzerfreundliche Namen entsprechend angezeigt werden.</li>'),
'    <li><strong>Formatmaske</strong>: Geben Sie eine geeignete Formatmaske basierend auf dem Spaltentyp ein (Text, Zahl, Datum usw.).</li>',
unistr('    <li><strong>Statischer Standardwert</strong>: Geben Sie einen Textstandardwert f\00FCr die Spalte ein.</li>'),
'    <li><strong>In Formulare aufnehmen</strong>: Klicken Sie auf "Ja", wenn die Spalte in Formulare aufgenommen werden soll.</li>',
'    <li><strong>In Berichten aufnehmen</strong>: Klicken Sie auf "Ja", wenn die Spalte in Berichte aufgenommen werden soll.</li>',
unistr('    <li><strong>Erforderlich</strong>: Klicken Sie auf "Ja", wenn in Formularen Daten in diese Spalte eingegeben werden m\00FCssen.</li>'),
unistr('    <li><strong>Hilfe</strong>: Geben Sie Hilfetext ein, der dem Attribut zur Elementhilfe hinzugef\00FCgt wird.</li>'),
'  </ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274868357609865421)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Bearbeiten Sie die Attribute f\00FCr die ausgew\00E4hlte Tabelle.</p>'),
'<p>Geben Sie die folgenden Attribute ein:',
'  <ul>',
unistr('    <li><strong>Tabelle</strong> (nur Anzeige): Die verkn\00FCpfte Tabelle.</li>'),
unistr('    <li><strong>Label, Singular</strong> (obligatorisch): Geben Sie das Label f\00FCr Formularseiten ein.</li>'),
unistr('    <li><strong>Label, Plural</strong> (obligatorisch): Geben Sie das Label f\00FCr Regions\00FCberschriften und Seitennamen ein.</li>'),
unistr('    <li><strong>Prim\00E4re Anzeigespalte</strong>: W\00E4hlen Sie die erste anzuzeigende Spalte (z.B. in Kartenregionen).</li>'),
unistr('    <li><strong>Sekund\00E4re Anzeigespalte</strong>: W\00E4hlen Sie die zweite anzuzeigende Spalte (z.B. in Kartenregionen).</li>'),
unistr('    <li><strong>Prim\00E4rschl\00FCsselspalte</strong>: W\00E4hlen Sie die eindeutige Prim\00E4rschl\00FCsselspalte f\00FCr die Tabelle.</li>'),
unistr('    <li><strong>Beschreibung</strong>: Geben Sie eine Beschreibung f\00FCr die Tabelle ein.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273947560617864757)
,p_name=>'CA.DEFERRED.DROP'
,p_message_language=>'de'
,p_message_text=>unistr('Verz\00F6gertes L\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274862582451865417)
,p_name=>'CA.DEFINITION'
,p_message_language=>'de'
,p_message_text=>'Definition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274845177090865405)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_language=>'de'
,p_message_text=>'Deinstallation abgeschlossen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274825472743865391)
,p_name=>'CA.DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274844700938865405)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('Soll dieser L\00F6schvorgang ausgef\00FChrt werden?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274811090830865381)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_language=>'de'
,p_message_text=>unistr('M\00F6chten Sie diese Seite wirklich l\00F6schen?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274835297356865398)
,p_name=>'CA.DELETE.PHOTO'
,p_message_language=>'de'
,p_message_text=>unistr('Foto l\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274826118062865392)
,p_name=>'CA.DESCRIPTION'
,p_message_language=>'de'
,p_message_text=>'Beschreibung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274843380029865404)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_language=>'de'
,p_message_text=>'Desktopnavigationsleiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274843276372865404)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_language=>'de'
,p_message_text=>unistr('Desktopnavigationsmen\00FC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274824458947865391)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_language=>'de'
,p_message_text=>'Desktop-Theme-Stil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274824541874865391)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Der Standard-Theme-Stil gilt f\00FCr alle Benutzer.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273947968142864758)
,p_name=>'CA.DESTINATION'
,p_message_language=>'de'
,p_message_text=>'Ziel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273948022809864758)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Zieleigent\00FCmer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273714973084864593)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_language=>'de'
,p_message_text=>unistr('Dialogfeldschaltfl\00E4chen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274839713418865401)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_language=>'de'
,p_message_text=>unistr('E-Mails \00FCbermitteln')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274859319798865415)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_language=>'de'
,p_message_text=>'Legt fest, ob E-Mails vom E-Mail-Framework gesendet werden sollen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274825970871865392)
,p_name=>'CA.DISPLAY.FROM'
,p_message_language=>'de'
,p_message_text=>'Anzeigen von'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274825840539865392)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_language=>'de'
,p_message_text=>'Anzeigereihenfolge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274826033513865392)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_language=>'de'
,p_message_text=>'Anzeigen bis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274861014699865416)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_language=>'de'
,p_message_text=>'Anzeigespalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274829578335865394)
,p_name=>'CA.DISTINCT .USERS'
,p_message_language=>'de'
,p_message_text=>'Eindeutige Benutzer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274842804379865403)
,p_name=>'CA.DOWNLOAD'
,p_message_language=>'de'
,p_message_text=>'Herunterladen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274849767147865408)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_language=>'de'
,p_message_text=>'Ziehen, um Seite neu anzuordnen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273736250146864608)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr('  <li><strong>Drilldown-Link</strong> - Damit k\00F6nnen Sie Attribute zum Definieren eines Drilldown-Links einblenden.'),
'&nbsp;<br>',
'    <em><strong>Hinweis:</strong> "Drilldown-Link" wird nur angezeigt, wenn die aktuelle Seite auf einer Tabelle oder View basiert und den Berichtstyp "Interaktiver Bericht" aufweist und Sie einen Bericht (Interaktiver Bericht) oder eine Master-Detai'
||'l-Seite (Master-Detail) definiert haben.</em>',
'  <ul>',
unistr('    <li><strong>Linkspalte</strong> - W\00E4hlen Sie die Spalte aus, die in eine Linkspalte im Bericht ge\00E4ndert werden soll.</li>'),
unistr('    <li><strong>Linkschl\00FCssel</strong> - W\00E4hlen Sie die Linkschl\00FCssel-(Fremdschl\00FCssel-)Spalte aus, mit der der jeweilige Datensatz in der zu verlinkenden Seite identifiziert wird.</li>'),
unistr('    <li><strong>Link zur Seite</strong> - W\00E4hlen Sie die Berichts- oder Formularseite aus, zu der der Link navigiert.</li>'),
unistr('    <li><strong>Zielschl\00FCssel</strong> - W\00E4hlen Sie die Zielschl\00FCssel-(Prim\00E4rschl\00FCssel-)Spalte in der Tabelle aus, zu der der Link navigiert und auf der er basiert.'),
'  </ul>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274828604423865394)
,p_name=>'CA.ELAPSED'
,p_message_language=>'de'
,p_message_text=>'Verstrichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274811248016865381)
,p_name=>'CA.EMAIL'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Framework'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274858972602865415)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Adressen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274868940449865422)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_language=>'de'
,p_message_text=>'Standard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274811171720865381)
,p_name=>'CA.EMAIL.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Funktion zum Konfigurieren und Senden von E-Mails hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274811337023865381)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Die Funktion zum Senden von E-Mails aus Ihrer Anwendung heraus hinzuf\00FCgen. Mit dem Beispiel-E-Mail-Template k\00F6nnen Sie professionell gestaltete E-Mails an Benutzer senden. Die gesendeten E-Mails werden protokolliert, damit Administratoren die E-Ma')
||unistr('il-Aktivit\00E4t verfolgen k\00F6nnen.</p>'),
'<p>Umfasst die folgenden Komponenten:',
'<ul>',
'<li>Erweiterbares HTML-E-Mail-Templatesystem</li>',
unistr('<li>PL/SQL-Package zum Senden von E-Mails \00FCber APEX-Packages</li>'),
unistr('<li>Logging von E-Mail-Aktivit\00E4t und -Status</li>'),
'<li>Administrative UI zur Verwaltung von Templates</li>',
'<li>Administrative UI zur Anzeige von E-Mail-Logs</li>',
'<li>Administrative UI zum Senden von E-Mails</li>',
'</ul>',
'</p>',
unistr('<p><em>Hinweis: Dieses Feature wird aktiviert, wenn "Feedback" ausgew\00E4hlt ist</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274864671951865419)
,p_name=>'CA.EMAIL.FROM'
,p_message_language=>'de'
,p_message_text=>'E-Mail von'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274838795862865401)
,p_name=>'CA.EMAIL.LOG'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274869503800865422)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Angaben zu E-Mail-Einstellungen erforderlich.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274869049926865422)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_language=>'de'
,p_message_text=>unistr('Absenderadresse ist keine g\00FCltige E-Mail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274860535452865416)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_language=>'de'
,p_message_text=>unistr('Absenderadresse ist keine g\00FCltige E-Mail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274859717482865415)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_language=>'de'
,p_message_text=>'E-Mail verarbeitet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273814969799864664)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Berichte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274000706072864807)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_language=>'de'
,p_message_text=>'Bericht mit allen in der Sendequeue enthaltenen und bereits gesendeten E-Mails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274839664621865401)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Einstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274840042063865401)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Einstellungen wurden aktualisiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274865022216865419)
,p_name=>'CA.EMAIL.STATUS'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274840112332865402)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_language=>'de'
,p_message_text=>'Details E-Mail-Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274351898259865058)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_language=>'de'
,p_message_text=>unistr('Geplanter Ausfall f\00FCr #SERVICE_NAME#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274053239935864844)
,p_name=>'CA.EMAIL2'
,p_message_language=>'de'
,p_message_text=>'E-Mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274838601635865400)
,p_name=>'CA.EMAILS.SENT'
,p_message_language=>'de'
,p_message_text=>'Gesendete E-Mails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274869171030865422)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_language=>'de'
,p_message_text=>unistr('Anh\00E4nge aktivieren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273953027335864761)
,p_name=>'CA.ENABLED'
,p_message_language=>'de'
,p_message_text=>'Aktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273950217696864759)
,p_name=>'CA.END.DATE'
,p_message_language=>'de'
,p_message_text=>'Enddatum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274840789074865402)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Nach Zeileninhalt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274856851013865413)
,p_name=>'CA.ENTER.USERNAME'
,p_message_language=>'de'
,p_message_text=>'Benutzernamen hier eingeben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274829235222865394)
,p_name=>'CA.ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274831589341865396)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_language=>'de'
,p_message_text=>'Fehler-Backtrace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274831415886865395)
,p_name=>'CA.ERROR.CODE'
,p_message_language=>'de'
,p_message_text=>'Fehlercode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274830730449865395)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_language=>'de'
,p_message_text=>'Fehlermeldung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273954780210864762)
,p_name=>'CA.ERROR.NUMBER'
,p_message_language=>'de'
,p_message_text=>'Fehlernummer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273953725629864762)
,p_name=>'CA.ERRORS'
,p_message_language=>'de'
,p_message_text=>'Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273950696102864759)
,p_name=>'CA.EVENT.CONDITION'
,p_message_language=>'de'
,p_message_text=>'Ereignisbedingung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273950715264864759)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_language=>'de'
,p_message_text=>'Agent der Ereignisqueue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273950815292864760)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_language=>'de'
,p_message_text=>'Name der Ereignisqueue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273950906638864760)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Eigent\00FCmer der Ereignisqueue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273950572514864759)
,p_name=>'CA.EVENT.RULE'
,p_message_language=>'de'
,p_message_text=>'Ereignisregel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274857124339865413)
,p_name=>'CA.EXCEPTIONS'
,p_message_language=>'de'
,p_message_text=>'Ausnahmen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274870017806865423)
,p_name=>'CA.EXPERIENCE'
,p_message_language=>'de'
,p_message_text=>'Erfahrung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273952704976864761)
,p_name=>'CA.FAILURE.COUNT'
,p_message_language=>'de'
,p_message_text=>'Anzahl Nicht erfolgreich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274827297209865393)
,p_name=>'CA.FEATURE'
,p_message_language=>'de'
,p_message_text=>'Feature'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274607206868865237)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_language=>'de'
,p_message_text=>'Anwendungsversion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274607315672865237)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_language=>'de'
,p_message_text=>'Seiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274099232708864877)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzer zur Access-Control-Liste hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274099074297864876)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Gehe zum n\00E4chsten Schritt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274099173623864877)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_language=>'de'
,p_message_text=>'Collections erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274098986587864876)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_language=>'de'
,p_message_text=>unistr('Der letzte Administrator kann nicht ge\00E4ndert werden')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274606957119865237)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_language=>'de'
,p_message_text=>unistr('Letzte Aktivit\00E4t')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274098796399864876)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_language=>'de'
,p_message_text=>unistr('Es wurden keine Aktivit\00E4ten gefunden')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274607148160865237)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_language=>'de'
,p_message_text=>'Grund'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274099388567864877)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Mindestens ein Feedbackeintrag erforderlich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274099659738864877)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_language=>'de'
,p_message_text=>'Datei-ID abrufen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274098256752864876)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_language=>'de'
,p_message_text=>'Theme-Stil speichern'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274098357410864876)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_language=>'de'
,p_message_text=>'Endbenutzer-Stilvoreinstellung speichern'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274607067676865237)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_language=>'de'
,p_message_text=>'Benutzername'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274815471656865384)
,p_name=>'CA.FEATURES'
,p_message_language=>'de'
,p_message_text=>'Features'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274815532520865384)
,p_name=>'CA.FEATURES.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Features liefern Funktionen auf Anwendungsebene und werden in der Regel einmal pro Anwendung hinzugef\00FCgt. W\00E4hlen Sie die Features aus, die in Ihre Anwendung aufgenommen werden sollen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274809342769865380)
,p_name=>'CA.FEEDBACK'
,p_message_language=>'de'
,p_message_text=>'Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274807395916865378)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_language=>'de'
,p_message_text=>'Benutzerfeedback zulassen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274809273797865380)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Stellen Sie ein Verfahren f\00FCr Endbenutzer bereit, mit dem diese allgemeine Kommentare an die Anwendungsadministratoren und -entwickler senden k\00F6nnen. Die Posts enthalten n\00FCtzliche Informationen zum Sessionstatus, anhand derer leichter bestimmt wer')
||unistr('den kann, von wo der Endbenutzer das Feedback gesendet hat. Die Bereitstellung einer solch einfachen Feedbackschleife erleichtert die Kommunikation zwischen der Benutzercommunity und den Anwendungseigent\00FCmern, was zu einer deutlich h\00F6heren Zufriedenh')
||unistr('eit der Endbenutzer f\00FChrt.</p>'),
'<p>Umfasst die folgenden Komponenten:',
'<ul>',
unistr('<li>M\00F6glichkeit f\00FCr Endbenutzer, durch Klicken auf ein Symbol in der Navigationsleiste Feedback abzugeben</li>'),
'<li>Administrativer Bericht zum Anzeigen und Aktualisieren von Feedback</li>',
'<li>Feedback erfasst Informationen zu Benutzer, Datum und Uhrzeit sowie Benutzer-Agent</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274870498071865423)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_language=>'de'
,p_message_text=>'Geben Sie Feedback zu Ihrer Erfahrung an.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274869417079865422)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_language=>'de'
,p_message_text=>'Senden an'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274868858170865422)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Feedbackeinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274836775607865399)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_language=>'de'
,p_message_text=>'Feedbackeinstellungen aktualisiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274869620554865422)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_language=>'de'
,p_message_text=>'Feedback weitergeleitet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273950333332864759)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_language=>'de'
,p_message_text=>'Name File-Watcher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273950498026864759)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('File-Watcher-Eigent\00FCmer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273605509260864519)
,p_name=>'CA.FILED'
,p_message_language=>'de'
,p_message_text=>'Eingereicht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273605618908864519)
,p_name=>'CA.FILED.BY'
,p_message_language=>'de'
,p_message_text=>'Eingereicht von'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274865106507865419)
,p_name=>'CA.FILTER.REPORT'
,p_message_language=>'de'
,p_message_text=>'Bericht filtern'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274841151536865402)
,p_name=>'CA.FILTERS'
,p_message_language=>'de'
,p_message_text=>'Filter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274867809198865421)
,p_name=>'CA.FINISH'
,p_message_language=>'de'
,p_message_text=>'Fertigstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274835482016865398)
,p_name=>'CA.FIRST.NAME'
,p_message_language=>'de'
,p_message_text=>'Vorname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273947304532864757)
,p_name=>'CA.FLAGS'
,p_message_language=>'de'
,p_message_text=>'Flags'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274816826360865385)
,p_name=>'CA.FORM'
,p_message_language=>'de'
,p_message_text=>unistr('Formularseite hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274816746465865385)
,p_name=>'CA.FORM.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erstellen Sie eine Seite, auf der eine Formularseite angezeigt wird, auf der Endbenutzer Daten verwalten k\00F6nnen.</p>'),
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Seitenname</strong> (obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
unistr('  <li><strong>Tabelle</strong> (Obligatorisch) - W\00E4hlen Sie die Tabelle f\00FCr das Formular aus.</li>'),
unistr('<li><strong>Bericht einbeziehen</strong> (Obligatorisch) - W\00E4hlen Sie diese Option aus, um einen Bericht und ein Formular zu erstellen. Die erste Seite ist ein interaktiver Bericht. Jede Zeile enth\00E4lt einen Link zu einem Formular, in dem Benutzer den')
||unistr(' Datensatz aktualisieren k\00F6nnen. </li>'),
'  &nbsp;<br>',
unistr('<li><strong>Erweitert</strong> - Damit k\00F6nnen Sie erweiterte Optionen einblenden.'),
'     <ul>',
unistr('      <li><strong>Hilfe zu den Seiten</strong> - Geben Sie Text ein, der dem Hilfetext f\00FCr die Seite hinzugef\00FCgt werden soll.</li>'),
'      </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273735279837864607)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_language=>'de'
,p_message_text=>unistr('Region f\00FCr Formularelemente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274843019029865404)
,p_name=>'CA.FORM.ON'
,p_message_language=>'de'
,p_message_text=>'Formular basierend auf %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274856611181865413)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_language=>'de'
,p_message_text=>unistr('Der Formulartyp ist kein g\00FCltiger Typ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274863052104865418)
,p_name=>'CA.FORMATMASK'
,p_message_language=>'de'
,p_message_text=>'Formatmaske'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274862077446865417)
,p_name=>'CA.FORMCONTROL'
,p_message_language=>'de'
,p_message_text=>'Formularsteuerelement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274826698275865392)
,p_name=>'CA.FROM'
,p_message_language=>'de'
,p_message_text=>'Von'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274839865375865401)
,p_name=>'CA.FROM.ADDRESS'
,p_message_language=>'de'
,p_message_text=>'Absenderadresse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274864560389865419)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Einstellung "Absenderadresse"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274860410597865416)
,p_name=>'CA.FROM.EMAIL'
,p_message_language=>'de'
,p_message_text=>'Von E-Mail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274860312070865416)
,p_name=>'CA.FROM.WHO'
,p_message_language=>'de'
,p_message_text=>'Von wem'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274609152562865239)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_language=>'de'
,p_message_text=>'%0 Suche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274830154515865395)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_language=>'de'
,p_message_text=>'Ganze Seitenansichten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274838892287865401)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_language=>'de'
,p_message_text=>unistr('HTML f\00FCr vollst\00E4ndiges Template')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274861536247865417)
,p_name=>'CA.FUNCTION'
,p_message_language=>'de'
,p_message_text=>'Funktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274809714359865380)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_language=>'de'
,p_message_text=>'Globale Suche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274807536994865379)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Suchfunktion f\00FCr Anwendung bereitstellen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274809640636865380)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erm\00F6glichen Sie Endbenutzern, in wichtigen Tabellen oder Views der Anwendung nach Text zu suchen. Die Seite "Erweiterte Suche" enth\00E4lt Filter, mit denen Endbenutzer ihre Suchergebnisse leicht eingrenzen k\00F6nnen.<br>'),
unistr('Bei diesem \00E4u\00DFerst leistungsstarken Feature m\00FCssen einige Entwicklungsaufgaben zur Definition der SQL (basierend auf den bereitgestellten Beispielen) ausgef\00FChrt werden.</p>'),
'<p>Umfasst die folgenden Komponenten:',
'<ul>',
'<li>Zeigt ein Suchsymbol in der Headerleiste an</li>',
unistr('<li>Enth\00E4lt eine Seite mit detaillierten Suchergebnissen mit einem Filter in der seitlichen Leiste</li>'),
'<li>Entwickler muss die SQL implementieren, um die App-Suche zu definieren</li>',
unistr('<li>Enth\00E4lt Beispieldaten zur Veranschaulichung</li>'),
'</ul>',
'</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273952017827864760)
,p_name=>'CA.GLOBAL.UID'
,p_message_language=>'de'
,p_message_text=>'Globale eindeutige ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274097898158864876)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_language=>'de'
,p_message_text=>'Globale Seite - Desktop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273715022912864593)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_language=>'de'
,p_message_text=>'Gehe zur Admin-Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274816373077865385)
,p_name=>'CA.GRID'
,p_message_language=>'de'
,p_message_text=>unistr('Seite mit interaktivem Grid hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274816404947865385)
,p_name=>'CA.GRID.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erstellen Sie eine Seite, die als interaktives Grid angezeigt wird, das einer Kalkulationstabelle \00E4hnelt. Wenn es editierbar ist, k\00F6nnen Benutzer mehrere Zeilen direkt auf der Seite bearbeiten (wenn "Bearbeitung zulassen" aktiviert ist).</p>'),
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Seitenname</strong> (Obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
unistr('  <li><strong>Abfragetyp</strong> - W\00E4hlen Sie die Quelle f\00FCr den Bericht aus [<strong>Tabelle oder View</strong> oder <strong>SQL-Abfrage</strong>].<br>'),
'    <strong>Tabelle oder View</strong>:',
'    <ul>',
unistr('      <li><strong>Tabelle oder View</strong> (Obligatorisch) - W\00E4hlen Sie das Datenbankobjekt f\00FCr das Grid aus.</li>'),
'    </ul>',
'    <strong>SQL-Abfrage</strong>:',
'    <ul>',
unistr('      <li><strong>SQL-Abfrage</strong> (Obligatorisch) - Geben Sie eine g\00FCltige SQL-Anweisung ein, die eindeutige Spalten zur\00FCckgibt.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>Grid-Typ</strong> - Legen Sie fest, ob Benutzer die Zeilen im Grid bearbeiten d\00FCrfen [<strong>Bearbeitung zulassen</strong> oder <strong>Schreibgesch\00FCtzt</strong>]. Um die Bearbeitung zu aktivieren, w\00E4hlen Sie <strong>Bearbeitung zulass')
||'en</strong> aus.</li>',
'  &nbsp;<br>',
unistr('  <em><strong>Warnung:</strong> Wenn Sie den Abfragetyp <strong>SQL-Abfrage</strong> und den Grid-Typ <strong>Bearbeitung zulassen</strong> ausw\00E4hlen und Ihre Abfrage mindestens zwei Tabellen verkn\00FCpft, erzeugt das generierte interaktive Grid Fehler,')
||unistr(' wenn Benutzer versuchen, Datens\00E4tze zu aktualisieren.'),
unistr('Wenn der ausgew\00E4hlte Grid-Typ au\00DFerdem <strong>Bearbeitung zulassen</strong> ist und die Abfrage (oder die ausgew\00E4hlte Tabelle oder View) eine View verwendet, die nicht aktualisiert werden kann, erzeugt das generierte interaktive Grid ebenfalls Fehle')
||unistr('r, wenn Benutzer versuchen, Datens\00E4tze zu aktualisieren.</em><br>'),
'  </li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274841661055865403)
,p_name=>'CA.HELP'
,p_message_language=>'de'
,p_message_text=>'Hilfe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274834089807865397)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_language=>'de'
,p_message_text=>unistr('W\00E4hlen Sie <strong>Nein</strong>, wenn alle Benutzer in der Access Control-Liste definiert sind. W\00E4hlen Sie <strong>Ja</strong>, wenn authentifizierte Benutzer, die nicht in der Access Control-Liste aufgef\00FChrt sind, die Anwendung ebenfalls verwenden ')
||unistr('d\00FCrfen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274827701874865393)
,p_name=>'CA.HELP.APP.NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Der hier eingegebene Text wird in der gesamten Anwendung verwendet, vor allem in der oberen linken Ecke auf jeder Seite. Die \00C4nderung wird f\00FCr den ausf\00FChrenden Administrator umgehend wirksam, aber die anderen Benutzer sehen die \00C4nderung erst bei eine')
||unistr('r neuen Session (zum Beispiel bei der n\00E4chsten Anmeldung).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274822333354865389)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_language=>'de'
,p_message_text=>'<p>Klicken Sie von einer beliebigen Seite der Anwendung aus auf das Feedbacksymbol ( <span class="fa fa-comment-o" aria-hidden="true"></span> ) in der Navigationsleiste, um den Anwendungsadministratoren Feedback zu geben.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274822072628865389)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Dies ist die Homepage der Anwendung. Klicken Sie auf die Karten, um auf die verschiedenen Seiten in der Anwendung zuzugreifen, oder verwenden Sie das Navigationsmen\00FC am seitlichen Rand der Seite.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274822288796865389)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Dies ist die Homepage der Anwendung. Klicken Sie auf die Karten, um auf die verschiedenen Seiten in der Anwendung zuzugreifen, oder verwenden Sie das Navigationsmen\00FC am oberen Rand der Seite.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274822402764865389)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_language=>'de'
,p_message_text=>'<p>Geben Sie auf dieser Seite einen Suchbegriff in das Feld <strong>Anwendung durchsuchen</strong> ein, oder klicken Sie von einer beliebigen Seite aus auf das Suchsymbol ( <span class="fa fa-search" aria-hidden="true"></span> ) in der Navigationslei'
||'ste, um in der Anwendung nach dem Begriff zu suchen.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274822788751865389)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Klicken Sie in der Navigationsleiste auf das Dropdown-Men\00FC mit Ihrem Namen, um sich von der Anwendung abzumelden.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274822667551865389)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Klicken Sie in der Navigationsleiste auf das Benutzermen\00FC ( <span class="fa fa-user" aria-hidden="true"></span> ), um Ihre Zeitzonenvoreinstellung zu aktualisieren und um sich von der Anwendung abzumelden.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274822190525865389)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_language=>'de'
,p_message_text=>'Homepage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274822803546865389)
,p_name=>'CA.HELP.HOME.USER'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Klicken Sie in der Navigationsleiste (oben rechts auf der Seite) auf das Benutzermen\00FC ( <span class="fa fa-user" aria-hidden="true"></span> ), um auf Ihr Benutzerprofil zuzugreifen und um sich von der Anmeldung abzumelden.<br>'),
unistr('Wenn Sie auf <strong>Mein Profil anzeigen</strong> klicken, k\00F6nnen Sie anschlie\00DFend auf <strong>Profil aktualisieren</strong> klicken, um Ihre pers\00F6nlichen Daten einzugeben und ein Foto oder einen Avatar hochzuladen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274822527647865389)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Klicken Sie in der Navigationsleiste auf das Benutzermen\00FC ( <span class="fa fa-user" aria-hidden="true"></span> ), um auf Ihr Benutzerprofil zuzugreifen, Ihre Zeitzonenvoreinstellung zu aktualisieren und um sich von der Anmeldung abzumelden.<br>'),
unistr('Wenn Sie auf <strong>Mein Profil anzeigen</strong> klicken, k\00F6nnen Sie anschlie\00DFend auf <strong>Profil aktualisieren</strong> klicken, um Ihre pers\00F6nlichen Daten einzugeben und ein Foto oder einen Avatar hochzuladen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274848623371865407)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Geben Sie zum Suchen von Daten einen Suchbegriff in das Dialogfeld "Suchen" ein, oder klicken Sie auf die Spalten\00FCberschriften, um die zur\00FCckgegebenen Datens\00E4tze einzuschr\00E4nken.</p>'),
'',
unistr('<p>Wenn Sie auf die Schaltfl\00E4che <strong>Aktionen</strong> klicken, k\00F6nnen Sie zahlreiche Funktionen ausf\00FChren, beispielsweise die angezeigten/ausgeblendeten Spalten und ihre Anzeigereihenfolge ausw\00E4hlen sowie mehrere Daten- und Formatfunktionen ausf')
||unistr('\00FChren. Dar\00FCber hinaus k\00F6nnen Sie mit der Diagrammoption eine zus\00E4tzliche Datenansicht definieren.</p>'),
'',
unistr('<p>Wenn Sie Ihre Anpassungen speichern m\00F6chten, w\00E4hlen Sie "Bericht", oder klicken Sie auf "Herunterladen", um die Daten zu entladen.<p>'),
'<br>',
unistr('<p>Weitere Informationen erhalten Sie, wenn Sie unten im Aktionsmen\00FC auf "Hilfe" klicken.</p>'),
'',
unistr('<p>Klicken Sie auf die Schaltfl\00E4che <strong>Zur\00FCcksetzen</strong>, um den interaktiven Bericht auf die Standardeinstellungen zur\00FCckzusetzen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274848599598865407)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem interaktiven Grid k\00F6nnen Sie Daten direkt einf\00FCgen, aktualisieren und l\00F6schen.<br>'),
unistr('  F\00FCgen Sie eine neue Zeile ein, indem Sie auf die Schaltfl\00E4che "Zeile hinzuf\00FCgen" klicken.<br>'),
unistr('  Um Datenwerte zu aktualisieren, doppelklicken Sie auf eine Zelle, oder klicken Sie auf die Schaltfl\00E4che <strong>Bearbeiten</strong>. Dies entspricht in etwa der Bearbeitung von Daten in einem Arbeitsblatt.</p>'),
'',
unistr('<p>\00DCber das Men\00FC "Zeilenaktionen" ( <span class="fa fa-bars" aria-hidden="true"></span> ) am Anfang des Berichts k\00F6nnen Sie ausgew\00E4hlte Zeilen duplizieren, l\00F6schen, aktualisieren oder wiederherstellen.<br>'),
unistr('  Wenn Sie das Men\00FC "Zeilenaktionen" f\00FCr einzelne Zeilen verwenden, k\00F6nnen Sie auf die Single Row-Ansicht zugreifen oder eine neue Zeile hinzuf\00FCgen.</p>'),
'',
unistr('<p>Geben Sie zum Suchen von Daten einen Suchbegriff in das Dialogfeld "Suchen" ein, oder klicken Sie auf die Spalten\00FCberschriften, um die zur\00FCckgegebenen Datens\00E4tze einzuschr\00E4nken.</p>'),
'',
unistr('<p>Wenn Sie auf die Schaltfl\00E4che <strong>Aktionen</strong> klicken, k\00F6nnen Sie zahlreiche Funktionen ausf\00FChren, beispielsweise die angezeigten/ausgeblendeten Spalten und ihre Anzeigereihenfolge ausw\00E4hlen sowie mehrere Daten- und Formatfunktionen ausf')
||unistr('\00FChren. Dar\00FCber hinaus k\00F6nnen Sie mit der Diagrammoption eine zus\00E4tzliche Datenansicht definieren.</p>'),
'',
unistr('<p>Wenn Sie Ihre Anpassungen speichern m\00F6chten, w\00E4hlen Sie "Bericht", oder klicken Sie auf "Herunterladen", um die Daten zu entladen.<p>'),
'<br>',
unistr('<p>Weitere Informationen erhalten Sie, wenn Sie unten im Aktionsmen\00FC auf "Hilfe" klicken.</p>'),
'',
unistr('<p>Klicken Sie auf die Schaltfl\00E4che <strong>Zur\00FCcksetzen</strong>, um den interaktiven Bericht auf die Standardeinstellungen zur\00FCckzusetzen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274821915993865389)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Geben Sie zum Suchen von Daten einen Suchbegriff in das Dialogfeld "Suchen" ein, oder klicken Sie auf die Spalten\00FCberschriften, um die zur\00FCckgegebenen Datens\00E4tze einzuschr\00E4nken.</p>'),
'',
unistr('<p>Wenn Sie auf die Schaltfl\00E4che <strong>Aktionen</strong> klicken, k\00F6nnen Sie zahlreiche Funktionen ausf\00FChren, beispielsweise die angezeigten/ausgeblendeten Spalten und ihre Anzeigereihenfolge ausw\00E4hlen sowie mehrere Daten- und Formatfunktionen ausf')
||unistr('\00FChren. Dar\00FCber hinaus k\00F6nnen Sie mit den Optionen "Diagramm", "Gruppieren nach" und "Pivot" zus\00E4tzliche Datenansichten definieren.</p>'),
'',
unistr('<p>Wenn Sie Ihre Anpassungen speichern m\00F6chten, w\00E4hlen Sie "Bericht", oder klicken Sie auf "Herunterladen", um die Daten zu entladen. Geben Sie Ihre E-Mail-Adresse und den Zeitrahmen f\00FCr das Abonnement ein, damit Ihnen die Daten regelm\00E4\00DFig zugesendet')
||' werden.<p>',
'',
unistr('<p>Weitere Informationen erhalten Sie, wenn Sie unten im Aktionsmen\00FC auf "Hilfe" klicken.</p>'),
'',
unistr('<p>Klicken Sie auf die Schaltfl\00E4che <strong>Zur\00FCcksetzen</strong>, um den interaktiven Bericht auf die Standardeinstellungen zur\00FCckzusetzen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274857612692865414)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Auf dieser Berichtsseite werden prim\00E4re Datens\00E4tze in einer Auswahl am Rand der Seite angezeigt. '),
unistr('  W\00E4hlen Sie einen Datensatz, um den Masterdatensatz und alle definierten Detaildatens\00E4tze anzuzeigen.<br> '),
'  Klicken Sie auf das Symbol "Bearbeiten" ( <span class="fa fa-pencil-square-o" aria-hidden="true"></span> ), um den Masterdatensatz zu bearbeiten.',
unistr('  Die Detaildatens\00E4tze werden angezeigt, wenn Sie am Anfang der jeweiligen Zeilen auf den Stift zur Bearbeitung des Datensatzes klicken.</p>'),
'<p>Um die in der Auswahl angezeigten Daten zu begrenzen, geben Sie im Dialogfeld "Suchen" einen Suchbegriff ein.</p>',
'',
unistr('<p>Um einen neuen Masterdatensatz hinzuzuf\00FCgen, klicken Sie am oberen Rand der Seite auf <strong>Erstellen</strong>.'),
unistr('  Detaildatens\00E4tze werden angezeigt, wenn Sie am oberen Rand der Detailregion auf das Plussymbol (+) klicken, um einen Detaildatensatz hinzuzuf\00FCgen.</p>'),
'',
unistr('<p>Klicken Sie im oberen Bereich der Seite auf <strong>Zur\00FCcksetzen</strong>, um die Seite auf die Standardeinstellungen zur\00FCckzusetzen. Dabei werden alle zuvor definierten Suchbegriffe und Filter entfernt.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274819977799865387)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Auf der Administrationsseite k\00F6nnen Anwendungseigent\00FCmer (Administratoren) die Anwendung konfigurieren und allgemeine anwendungsweit verwendete Daten verwalten.'),
unistr('Durch Auswahl einer der verf\00FCgbaren Einstellungen k\00F6nnen Administratoren potenziell \00E4ndern, wie die Anwendung angezeigt wird und/oder welche Features f\00FCr die Endbenutzer zur Verf\00FCgung stehen.</p>'),
unistr('<p>Der Zugriff auf diese Seite sollte ausschlie\00DFlich f\00FCr Administratoren m\00F6glich sein.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274821101877865388)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Treffen Sie die passende Auswahl f\00FCr authentifizierte Benutzer.<br>'),
unistr('Wenn Sie <strong>Nein</strong> w\00E4hlen, wird die Anwendung sicherer, da nur bestimmte Benutzer auf die Anwendung zugreifen k\00F6nnen.'),
unistr('Wenn Ihre Anwendung jedoch von einer gro\00DFen Benutzercommunity verwendet und die Verwaltung der Benutzer m\00FChselig wird, kann es ratsam sein, <strong>Ja</strong> zu w\00E4hlen und nur Anwendungsadministratoren und eventuell Beitragende einzugeben.<br>'),
unistr('Wenn Sie <strong>Ja</strong> w\00E4hlen, m\00FCssen Sie auch festlegen, wie Benutzer, die nicht in der Liste enthalten sind, behandelt werden.</p>'),
unistr('<p>W\00E4hlen Sie aus, ob f\00FCr Benutzernamen E-Mail-Adressen oder alphanumerische Werte angegeben werden m\00FCssen.<br>'),
unistr('In der Regel empfiehlt es sich, f\00FCr diese Einstellung <strong>E-Mail-Adresse</strong> festzulegen, wenn Ihre Anwendung ein zentrales Authentifizierungsschema verwendet (bzw. daf\00FCr konfiguriert wird), beispielsweise Oracle Access Manager oder SSO.</p>'),
unistr('<p><em><strong>Hinweis:</strong> Diese Anwendung unterst\00FCtzt die folgenden drei Zugriffsebenen: Leseberechtigter, Beitragender und Administrator.'),
'<ul>',
unistr('  <li><strong>Leseberechtigte</strong> haben schreibgesch\00FCtzten Zugriff auf alle Informationen und k\00F6nnen Berichte anzeigen.</li>'),
unistr('  <li><strong>Beitragende</strong> k\00F6nnen Informationen erstellen, bearbeiten und l\00F6schen sowie Berichte anzeigen.</li>'),
unistr('  <li><strong>Administratoren</strong> k\00F6nnen zus\00E4tzlich zu den Berechtigungen der Beitragenden die Anwendung konfigurieren, indem sie auf den Administrationsbereich der Anwendung zugreifen.</li>'),
'</ul>',
'</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274821354138865388)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>In diesem Formular geben Sie Benutzer mit ihrer E-Mail-Adresse und Zugriffsebene ein.',
'Die unter <em>Zugriffskontrolle konfigurieren</em> definierten Einstellungen bestimmen, ob der Benutzername die E-Mail-Adresse sein muss oder ein beliebiger alphanumerischer Eintrag sein kann.</p>',
unistr('<p>Diese Anwendung unterst\00FCtzt die folgenden drei Zugriffsebenen: Leseberechtigter, Beitragender und Administrator.</p>'),
'<ul>',
unistr('  <li><strong>Leseberechtigte</strong> haben schreibgesch\00FCtzten Zugriff auf alle Informationen und k\00F6nnen Berichte anzeigen.</li>'),
unistr('  <li><strong>Beitragende</strong> k\00F6nnen Informationen erstellen, bearbeiten und l\00F6schen sowie Berichte anzeigen.</li>'),
unistr('  <li><strong>Administratoren</strong> k\00F6nnen zus\00E4tzlich zu den Berechtigungen der Beitragenden die Anwendung konfigurieren, indem sie auf den Administrationsbereich der Anwendung zugreifen.</li>'),
'</ul>',
unistr('<p>Bei der Bearbeitung eines vorhandenen Benutzers k\00F6nnen Sie dessen Account sperren, um den Benutzer am Zugriff auf die Anwendung zu hindern.</p>'),
unistr('<p><em><strong>Hinweis:</strong> Wenn Oracle Application Express-Accounts verwendet werden, m\00FCssen die hier eingetragenen Benutzer auch von einem Workspace-Administrator, der auch die Kennw\00F6rter festlegen kann, als Endbenutzer definiert werden.</em><')
||'/p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274821225994865388)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Diese Seite zeigt einen Bericht zu den Anwendungsbenutzern und den erteilten Zugriffsebenen.</p>',
unistr('<p>Klicken Sie auf die Spalten\00FCberschriften, um Daten zu sortieren und zu filtern, oder klicken Sie auf die Schaltfl\00E4che <strong>Aktionen</strong>, um die Spaltenanzeige und viele zus\00E4tzliche erweiterte Features anzupassen.<br>'),
unistr('Klicken Sie auf die Schaltfl\00E4che <strong>Zur\00FCcksetzen</strong>, um den interaktiven Bericht auf die Standardeinstellungen zur\00FCckzusetzen.</p>'),
unistr('<p>Klicken Sie auf das Symbol "Bearbeiten" (gelber Stift), um die Benutzerdetails und die Zugriffsebene zu bearbeiten oder um den Benutzer zu l\00F6schen.</p>'),
unistr('<p>Klicken Sie am oberen Rand des Berichts auf <strong>Benutzer hinzuf\00FCgen</strong>, um einen neuen Benutzer und dessen Zugriffsebene hinzuzuf\00FCgen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274834756430865398)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Wenn die Zugriffskontrolle aktiviert ist, k\00F6nnen Administratoren den Zugriff auf bestimmte Anwendungsfeatures f\00FCr authentifizierte Benutzer einschr\00E4nken. Diese Anwendung unterst\00FCtzt die folgenden drei Rollen: Leseberechtigter, Beitragender und Adm')
||'inistrator.<p>',
'<ul>',
unistr('  <li><strong>Leseberechtigte</strong> haben schreibgesch\00FCtzten Zugriff auf alle Informationen und k\00F6nnen Berichte anzeigen.</li>'),
unistr('  <li><strong>Beitragende</strong> k\00F6nnen Informationen erstellen, bearbeiten und l\00F6schen sowie Berichte anzeigen.</li>'),
unistr('  <li><strong>Administratoren</strong> k\00F6nnen zus\00E4tzlich zu den Berechtigungen der Beitragenden auch die Anwendung konfigurieren.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274856758778865413)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_language=>'de'
,p_message_text=>'Geben Sie Benutzernamen getrennt durch Komma, Semikolon oder Leerzeichen ein. Vorhandene oder doppelte Benutzernamen werden automatisch ignoriert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274820151371865388)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Konfigurationseinstellungen erm\00F6glichen Ihnen, bestimmte Funktionen f\00FCr Endbenutzer entweder verf\00FCgbar zu machen (zu aktivieren) oder nicht verf\00FCgbar zu machen (zu deaktivieren).</p>'),
unistr('<p>Wenn eine bestimmte Funktion nicht 100-prozentig einsatzbereit ist oder vor\00FCbergehend entfernt werden muss, klicken Sie auf <strong>Deaktiviert</strong>.'),
unistr('Wenn Sie wieder verf\00FCgbar gemacht werden soll, klicken Sie einfach auf <strong>Aktiviert</strong>.</p>'),
unistr('<p><em><strong>Hinweis:</strong> An dieser Stelle vorgenommene \00C4nderungen werden f\00FCr einzelne Endbenutzer, die gerade die Anwendung ausf\00FChren, nicht angezeigt. Wenn sich der Endbenutzer bei der Anwendung ab- und anschlie\00DFend wieder anmeldet, werden d')
||unistr('ie ge\00E4nderten Featureeinstellungen aufgerufen.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274820248830865388)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>W\00E4hlen Sie das Standardfarbschema aus, das f\00FCr die Anzeige der Anwendung verwendet wird.</p>'),
unistr('<p>Wenn <strong>Endbenutzer d\00FCrfen Theme-Stil ausw\00E4hlen</strong> aktiviert ist, kann jeder Endbenutzer durch Klicken auf den Link <em>Anpassen</em> in der unteren linken Ecke der Homepage eine Auswahl aus den verf\00FCgbaren Theme-Stilen treffen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274820892755865388)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Diese Seite bietet einen interaktiven Bericht zu allen unerwarteten Fehlern, die von dieser Anwendung protokolliert werden.</p>',
unistr('<p>Klicken Sie auf die Spalten\00FCberschriften, um Daten zu sortieren und zu filtern, oder klicken Sie auf die Schaltfl\00E4che <strong>Aktionen</strong>, um die Spaltenanzeige und viele zus\00E4tzliche erweiterte Features anzupassen. Klicken Sie auf die Schalt')
||unistr('fl\00E4che <strong>Zur\00FCcksetzen</strong>, um den interaktiven Bericht auf die Standardeinstellungen zur\00FCckzusetzen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274820773555865388)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Mit diesem Bericht und Diagramm zeigen Sie die Benutzer mit den h\00E4ufigsten Seitenansichten f\00FCr den angegebenen Zeitrahmen an.</p>'),
unistr('<p>W\00E4hlen Sie am oberen Rand der Seite den Zeitrahmen f\00FCr die Berichtserstellung aus (Standard = 1 Tag), und w\00E4hlen Sie dann entweder das Bericht- oder das Diagrammsymbol.</p>'),
unistr('<p>Verwenden Sie bei interaktiven Berichten das Suchfeld, oder w\00E4hlen Sie die Spalten\00FCberschrift <strong>Benutzer</strong>, um einen bestimmten Benutzer auszuw\00E4hlen. Wenn Sie auf die Schaltfl\00E4che <strong>Aktionen</strong> klicken, k\00F6nnen Sie zahlreic')
||unistr('he Funktionen ausf\00FChren, Beispiel: die angezeigten/ausgeblendeten Spalten ausw\00E4hlen, Zeilen pro Seite angeben, filtern usw. Klicken Sie auf die Schaltfl\00E4che <strong>Zur\00FCcksetzen</strong>, um den interaktiven Bericht auf die Standardeinstellungen zur\00FC')
||'ckzusetzen.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274820900214865388)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Diese Seite bietet einen interaktiven Bericht zur Performance und Beliebtheit der Seite. Der Bericht wird nach <strong>Gewichtete Performance</strong> sortiert, die berechnet wird, indem der Medianwert der verstrichenen Zeit mit der Anzahl der Sei'
||'tenansichten multipliziert wird.</p>',
unistr('<p>W\00E4hlen Sie gegebenenfalls am oberen Rand der Seite den Zeitrahmen f\00FCr die Berichtserstellung (Standard = 1 Tag).<br>'),
unistr('Klicken Sie auf die Spalten\00FCberschriften, um Daten zu sortieren und zu filtern, oder klicken Sie auf die Schaltfl\00E4che <strong>Aktionen</strong>, um die Spaltenanzeige und viele zus\00E4tzliche erweiterte Features anzupassen. Klicken Sie auf die Schaltfl\00E4')
||unistr('che <strong>Zur\00FCcksetzen</strong>, um den interaktiven Bericht auf die Standardeinstellungen zur\00FCckzusetzen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274821068184865388)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Diese Seite bietet einen interaktiven Bericht zu den letzten Seitenansichten.</p>',
unistr('<p>W\00E4hlen Sie gegebenenfalls am oberen Rand der Seite den Zeitrahmen f\00FCr die Berichtserstellung (Standard = 1 Tag).<br>'),
unistr('Klicken Sie auf die Spalten\00FCberschriften, um Daten zu sortieren und zu filtern, oder klicken Sie auf die Schaltfl\00E4che <strong>Aktionen</strong>, um die Spaltenanzeige und viele zus\00E4tzliche erweiterte Features anzupassen. Klicken Sie auf die Schaltfl\00E4')
||unistr('che <strong>Zur\00FCcksetzen</strong>, um den interaktiven Bericht auf die Standardeinstellungen zur\00FCckzusetzen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274820029676865387)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Wenn Benachrichtigungen aktiviert sind, werden diese auf der Homepage angezeigt.</p>',
'<p>Dieser Bericht zeigt an, welche Benachrichtigungen definiert sind und in welchem Zeitraum sie angezeigt werden.</p>',
unistr('<p>Klicken Sie auf das Symbol "Bearbeiten" (gelber Stift), um eine vorhandene Benachrichtigung zu bearbeiten, oder klicken Sie auf <strong>Benachrichtigung hinzuf\00FCgen</strong>, um eine neue Benachrichtigung einzuf\00FCgen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274820331562865388)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Geben Sie den Anwendungsnamen und eine kurze Beschreibung f\00FCr die Anwendung ein.</p>'),
'<p>Der Name der Anwendung wird auf der Homepage angezeigt. Die Kurzbeschreibung wird unter dem Anwendungsnamen angezeigt.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274820588540865388)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Endbenutzer k\00F6nnen Feedback auf allen normalen Seiten der Anwendung eingeben.</p>'),
'<p>Dieser Bericht zeigt das eingegebene Feedback, die Antworten der Administratoren und den Feedbackstatus.</p>',
'<p>Klicken Sie auf das Symbol "Bearbeiten" (gelber Stift), um eine Antwort einzugeben oder den Feedbackstatus zu aktualisieren.</p>',
unistr('<p><em><strong>Hinweis:</strong> Wenn Feedbackempf\00E4nger definiert wurden, wird weitergeleitetes Feedback auch per E-Mail an die in der Liste der Feedbackempf\00E4nger aufgef\00FChrten E-Mail-Adressen gesendet.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274836697677865399)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_language=>'de'
,p_message_text=>'Geben Sie eine durch Komma getrennte Liste mit E-Mail-Adressen an.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274820650849865388)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_language=>'de'
,p_message_text=>unistr('<p><strong>Anh\00E4nge aktivieren</strong>: Wenn diese Option auf "Ja" gesetzt ist, k\00F6nnen Benutzer zus\00E4tzlich zum Feedback einen Anhang hochladen.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274821677881865389)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Auf dieser Seite werden die definierten E-Mail-Templates aufgef\00FChrt. Dar\00FCber hinaus wird angegeben, wie h\00E4ufig das Template in gesendeten E-Mails referenziert wurde.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274821477929865388)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Auf dieser Seite werden die gesendeten E-Mails aufgef\00FChrt.</p>'),
'<p>Klicken Sie auf das Lupensymbol, um weitere Details zu den gesendeten E-Mails anzuzeigen.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274821546455865389)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>F\00FCllen Sie die folgenden Felder aus, um ein E-Mail-Template zu definieren:</p>'),
'<ul>',
unistr('  <li><strong>Templatename</strong> (obligatorisch): Geben Sie einen aussagekr\00E4ftigen Namen f\00FCr das Template ein.</li>'),
unistr('  <li><strong>HTML-Template</strong> (obligatorisch): Geben Sie den HTML-Code zum Erstellen einer E-Mail ein, die an Empf\00E4nger gesendet wird, die die Zustellung von HTML-basierten E-Mails zulassen.'),
unistr('    Die folgenden Substitutionsvariablen sind verf\00FCgbar:'),
'    <ul>',
'        <li><strong>#APP_NAME#</strong>: Wird durch den Namen der Anwendung ersetzt</li>',
unistr('        <li><strong>#BODY1#</strong>: Wird durch den Wert ersetzt, der als p_body1_text \00FCbergeben wurde</li> '),
unistr('        <li><strong>#TABLE#</strong>: Wird durch den Wert ersetzt, der mit Table Open HTML, Table Row HTML und Table Close HTML als p_table_content \00FCbergeben wurde</li>'),
unistr('        <li><strong>#BODY2#</strong>: Wird durch den Wert ersetzt, der als p_body2_text \00FCbergeben wurde</li> '),
unistr('        <li><strong>#ACTION#</strong>: Wird durch den Wert ersetzt, der mit der Vorlage "Aktionslink" als p_action_label und p_action_link \00FCbergeben wurde</li>'),
'      </ul></li>',
unistr('  <li><strong>Nur-Text-Vorlage</strong> (obligatorisch): Geben Sie den Nur-Text zum Erstellen einer E-Mail ein, die an Empf\00E4nger gesendet wird, die keine HTML-basierten E-Mails akzeptieren. Diese Option verwendet dieselben Ersetzungen wie die HTML-Vo')
||'rlage, jedoch werden #TABLE# und #ACTION# als Nur-Text wiedergegeben.</li>',
'<ul>',
unistr('<p>Es gibt weitere HTML-Templates, die E-Mails mit zus\00E4tzlichen Elementen erm\00F6glichen.  Dazu geh\00F6ren:</p>'),
'<ul>',
unistr('  <li><strong>Vor Zeilen</strong>: Geben Sie HTML ein, das #TABLE# in der HTML-Vorlage ersetzt. Wird nur verwendet, wenn p_table_content \00FCbergeben wird.</li>'),
unistr('  <li><strong>Zeilentemplate</strong>: Geben Sie HTML f\00FCr die Wiedergabe der einzelnen Tabellenzeilen ein. Dazu geh\00F6rt "Zeilen \00F6ffnen/schlie\00DFen" und "Daten \00F6ffnen/schlie\00DFen" mit den #LABEL#- und #VALUE#-Ersetzungen. Wird nur verwendet, wenn p_table_c')
||unistr('ontent \00FCbergeben wird.</li>'),
unistr('  <li><strong>Nach Zeilen</strong>: Geben Sie HTML ein, um die Tabelle oder Div zu schlie\00DFen. Wird nur verwendet, wenn p_table_content \00FCbergeben wird.</li>'),
unistr('  <li><strong>HTML f\00FCr Aktionslink</strong>: Geben Sie HTML ein, um #ACTION# in der HTML-Template zu ersetzen. HTML sollte #ACTION_LINK# und #ACTION_TEXT# enthalten. Wird nur verwendet, wenn p_action_label und p_action_link \00FCbergeben werden.</li>'),
'</ul>',
unistr('<p><em><strong>Hinweis</strong>: Verwenden Sie die Eintr\00E4ge in der <strong>Standardvorlage</strong> als Ausgangsbasis f\00FCr die Entwicklung Ihrer eigenen Vorlage. In der Standardvorlage werden viele der Substitutionsvariablen verwendet, die Sie m\00F6glich')
||unistr('erweise auch in Ihrem eigenen E-Mail-Template einf\00FCgen m\00F6chten.</em></p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274821739987865389)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Aktivieren oder deaktivieren Sie das Senden von E-Mails durch Auswahl einer der Optionen f\00FCr <strong>E-Mails \00FCbermitteln</strong>.</p>'),
unistr('<p>Machen Sie eine Angabe unter <strong>E-Mails von</strong>. Geben Sie die E-Mail-Adresse des prim\00E4ren Kontakts bei Anwendungsproblemen ein. Dieser Wert kann bei Verwendung der E-Mail-Features verwendet oder \00FCberschrieben werden.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274839971556865401)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_language=>'de'
,p_message_text=>unistr('Dies ist die Adresse, von der aus E-Mails gesendet werden. Sie kann bei Verwendung des E-Mail-Features \00FCberschrieben werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274858300735865414)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>F\00FCllen Sie die folgenden Felder aus, und klicken Sie auf [E-Mail senden]. Alle gesendeten E-Mails werden im E-Mail-Log protokolliert.'),
'    <ul>',
unistr('        <li><strong>Von</strong>: Wenn in den E-Mail-Einstellungen eine "Absenderadresse" festgelegt wurde, wird diese Adresse als Absenderoption aufgef\00FChrt. Wenn diese Anwendung E-Mail-Adressen als Benutzernamen verwendet, k\00F6nnen Sie wahlweise E-Mai')
||unistr('ls von Ihrer Adresse aus senden. Sie k\00F6nnen dar\00FCber hinaus festlegen, dass die Absenderadresse dieselbe wie die Empf\00E4ngeradresse ist.</li>'),
unistr('        <li><strong>Empf\00E4nger</strong>: Wenn diese Anwendung E-Mail-Adressen als Benutzername verwendet, k\00F6nnen Sie festlegen, ob E-Mails an E-Mail-Adressen und/oder Benutzer gesendet werden sollen.</li>'),
unistr('        <li><strong>E-Mail-Adressen</strong>: Durch Komma getrennte Liste von E-Mail-Adressen, an die E-Mails gesendet werden k\00F6nnen. Ung\00FCltige Adressen werden nicht aufgenommen.</li>'),
unistr('        <li><strong>Rolle</strong>: Sie k\00F6nnen festlegen, ob E-Mails an alle Benutzer einer ausgew\00E4hlten Rolle oder an alle definierten Benutzer gesendet werden sollen. Die Auswahlliste enth\00E4lt eine Liste von Rollen und die Anzahl der Benutzer innerh')
||'alb dieser Rolle.</li>',
unistr('        <li><strong>Template</strong>: W\00E4hlen Sie das E-Mail-Template, die zur Erstellung des Hauptteils der E-Mail verwendet werden soll.</li>'),
'        <li><strong>Betreff</strong>: Der Betreff der E-Mail-Nachricht.</li>',
'        <li><strong>E-Mail-Text</strong>: Der Text, der in die E-Mail aufgenommen werden soll.</li>',
unistr('        <li><strong>Opt-out zulassen</strong>: Einige E-Mails m\00FCssen gesendet werden, auch wenn der Benutzer den Erhalt von E-Mails abgew\00E4hlt hat. Dazu geh\00F6ren beispielsweise Meldungen zu Ausf\00E4llen. Mit diesem Kennzeichen wird angegeben, ob die Opt-o')
||unistr('ut-Option f\00FCr diese E-Mail zul\00E4ssig ist oder ob die E-Mail unabh\00E4ngig von den Voreinstellungen des Benutzers gesendet werden soll.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274860091448865415)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>F\00FCllen Sie die die folgenden Felder aus, und klicken Sie auf [E-Mail senden].  Alle gesendeten E-Mails werden im E-Mail-Protokoll aufgezeichnet.'),
'    <ul>',
unistr('        <li><strong>Von</strong>: Ist in den E-Mail-Einstellungen eine "Absenderadresse" festgelegt, wird diese als Adressenoption angezeigt. Andernfalls k\00F6nnen Sie die Absenderadresse ebenfalls als Empf\00E4ngeradresse angeben.</li>'),
unistr('        <li><strong>E-Mail-Adressen</strong>: Durch Komma getrennte Liste der E-Mail-Adressen, an die E-Mails gesendet werden k\00F6nnen. Ung\00FCltige Adressen sind nicht aufgef\00FChrt.</li>'),
unistr('        <li><strong>Template</strong>: W\00E4hlen Sie das E-Mail-Template zur Erstellung des E-Mail-Textes.</li>'),
'        <li><strong>Betreff</strong>: Der Betreff der E-Mail.</li>',
'        <li><strong>E-Mail-Text</strong>: Text, der in die E-Mail aufgenommen werden soll.</li>',
unistr('        <li><strong>Opt-out zulassen</strong>: Einige E-Mails m\00FCssen gesendet werden, auch wenn der Benutzer den Erhalt von E-Mails abgew\00E4hlt hat. Dazu geh\00F6ren beispielsweise Meldungen zu Ausf\00E4llen. Mit diesem Flag wird angegeben, ob die Opt-out-Opti')
||unistr('on f\00FCr die E-Mail zul\00E4ssig ist oder ob die E-Mail unabh\00E4ngig von den Voreinstellungen des Benutzers gesendet werden soll.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274820430058865388)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>W\00E4hlen Sie die Standardzeitzone f\00FCr alle Benutzer dieser Anwendung.</p>'),
unistr('<p>Einzelne Benutzer k\00F6nnen diese Einstellung \00FCberschreiben, indem Sie auf ihren Benutzernamen (oben rechts) klicken und <strong>Voreinstellungen</strong> ausw\00E4hlen. Alternativ k\00F6nnen sie auch auf den Zeitzonenlink klicken, der am unteren Rand der Ho')
||'mepage angezeigt wird.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274836302428865399)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'de'
,p_message_text=>unistr('Auf diese Seite kann nicht direkt \00FCber die UI zugegriffen werden. Sie wird f\00FCr den Download des Profilfotos verwendet.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274836006945865399)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_language=>'de'
,p_message_text=>unistr('Auf der Seite "Benutzerprofil" k\00F6nnen Sie relevante Informationen zu einem Benutzer in einem benutzerfreundlichen Bildschirm anzeigen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274835773282865398)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_language=>'de'
,p_message_text=>unistr('Laden Sie ein Foto mit einem quadratischen Seitenverh\00E4ltnis hoch, da es andernfalls m\00F6glicherweise verzerrt dargestellt wird. Die bevorzugte Bildgr\00F6\00DFe ist 250 x 250 Pixel.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274821879815865389)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In diesem Formular k\00F6nnen Sie Ihre pers\00F6nlichen Daten aktualisieren und ein Foto oder einen Avatar hochladen.</p>'),
unistr('<p>Um ein Bild hochzuladen, klicken Sie auf <strong>Durchsuchen</strong>, oder ziehen Sie das Bild per Drag-and-Drop auf die Schaltfl\00E4che.<br>'),
unistr('Laden Sie ein Foto mit einem quadratischen Seitenverh\00E4ltnis hoch, da es andernfalls m\00F6glicherweise verzerrt dargestellt wird. Die bevorzugte Bildgr\00F6\00DFe ist 250 x 250 Pixel.</p>'),
unistr('<p>Klicken Sie auf <strong>Foto l\00F6schen</strong>, um das Bild zu entfernen.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274841909164865403)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_language=>'de'
,p_message_text=>unistr('Von dieser Seite aus kann auf den gesamten Hilfetext f\00FCr die Anwendung zugegriffen werden. Die Links in der Region "Dokumentation" bieten ausf\00FChrlichere Erkl\00E4rungen zu den Features und Funktionen der Anwendung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274822915523865390)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCber diese Seite k\00F6nnen Sie Anwendungsvoreinstellungen f\00FCr Ihren Account festlegen. Die Voreinstellungen k\00F6nnen verschiedene Aspekte der Anwendung betreffen, Beispiel: Zeitzone. Klicken Sie auf die Hilfesymbole auf Elementebene, um zu erfahren, welch')
||'e Auswirkungen jede Voreinstellung hat.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273815053373864664)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_language=>'de'
,p_message_text=>'<p>In diesem Bericht werden alle in der Sendequeue enthaltenen und bereits gesendeten E-Mails angezeigt.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273946961251864757)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Diese Berichte umfassen alle Jobs, die von dieser Anwendung \00FCberwacht werden. Sie k\00F6nnen weitere Details zu jedem Job anzeigen, indem Sie auf den Jobnamen klicken.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273953528446864761)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Dieser Bericht umfasst die Ausf\00FChrungsdetails zu den Jobs, die von dieser Anwendung \00FCberwacht werden.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274807267666865378)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Seite mit Informationen zu dieser Anwendung hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274823694220865390)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_language=>'de'
,p_message_text=>unistr('Setzen Sie diese Option auf "Nein", wenn Sie keine E-Mails von dieser Anwendung empfangen m\00F6chten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274857825336865414)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Geben Sie einen Suchbegriff in das Dialogfeld "Suchen" ein, und klicken Sie auf <strong>Suchen</strong>.<br>',
unistr('Klicken Sie eine beliebige Ergebnis\00FCberschrift, um zu dem jeweiligen Datensatz zu navigieren.</p>'),
'<p>Um die Suche einzugrenzen, deaktivieren Sie eine oder mehrere Quellen, wodurch die jeweiligen Berichte aus den Suchergebnissen entfernt werden.</p>',
unistr('<p>Klicken Sie auf <strong>Zur\00FCcksetzen</strong>, um den aktuellen Suchbegriff zu entfernen alle Quellen zu aktivieren.</p> ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274823445048865390)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_language=>'de'
,p_message_text=>unistr('Legen Sie Ihre bevorzugte Zeitzone f\00FCr die Anwendung fest.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273735542763864607)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_language=>'de'
,p_message_text=>'Ausgeblendete Elemente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274843549810865404)
,p_name=>'CA.HOME'
,p_message_language=>'de'
,p_message_text=>'Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274849681312865408)
,p_name=>'CA.HOME.PAGE'
,p_message_language=>'de'
,p_message_text=>'Homepage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274866002503865420)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_language=>'de'
,p_message_text=>unistr('St\00FCndliche Seitenereignisse')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273814191168864663)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_language=>'de'
,p_message_text=>unistr('HTML-Hauptteilgr\00F6\00DFe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274840385099865402)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'HTML-Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274837071527865399)
,p_name=>'CA.IN.PROGRESS'
,p_message_language=>'de'
,p_message_text=>'In Arbeit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274862256181865417)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_language=>'de'
,p_message_text=>'In Formulare aufnehmen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274862184650865417)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_language=>'de'
,p_message_text=>'In Berichten aufnehmen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274845711190865405)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_language=>'de'
,p_message_text=>unistr('Unterst\00FCtzende Objektskripte werden installiert')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273947632896864757)
,p_name=>'CA.INSTANCE.ID'
,p_message_language=>'de'
,p_message_text=>'Instanz-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273948839609864758)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_language=>'de'
,p_message_text=>'Instanz-Stickiness'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274819489999865387)
,p_name=>'CA.INTRO.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Willkommen bei dieser cloudbasierten Vorschau eines neuen und verbesserten Verfahrens zur Erstellung von Anwendungen mit noch mehr leistungsstarken Features. Mit dem Standardassistenten zur Erstellung einer Anwendung k\00F6nnen Sie lediglich Seiten au')
||unistr('sw\00E4hlen, die erstellt werden sollen. Dieser Assistent dagegen erm\00F6glicht Ihnen, schnell eine Reihe von zus\00E4tzlichen Features im Voraus in Ihre Anwendung zu laden.</p>'),
unistr('<p>Mit diesem Assistenten erstellte Anwendungen werden vollst\00E4ndig unterst\00FCtzt und k\00F6nnen zudem unterst\00FCtzende Objekte f\00FCr ausgew\00E4hlte Features enthalten, Beispiel: Zugriffskontrolle, E-Mail-Framework, Feedback und mehr.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274819680407865387)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Geben Sie zun\00E4chst einen Anwendungsnamen ein. F\00FCgen Sie dann mindestens eine Seite zu der Anwendung hinzu. W\00E4hlen Sie die Features aus, die Sie einbeziehen m\00F6chten. Entscheiden Sie sich, wie die Anwendung dargestellt werden soll, und pr\00FCfen Sie da')
||'nn die Einstellungen.<br>',
'So einfach geht das. Klicken Sie auf <strong>Anwendung erstellen</strong>, und schon sind Sie fertig.</p>',
'<p>Klicken Sie auf <strong>Blueprint anzeigen</strong>, um das Modell einer zuvor generierten Anwendung wiederzuverwenden oder Seiten schnell zu replizieren.</p>',
unistr('<p><em><strong>Hinweis:</strong> In jedem Abschnitt und auf jeder neu hinzugef\00FCgten Seite finden Sie detaillierte Hilfe zur weiteren Unterst\00FCtzung.</em></p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274819541337865387)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_language=>'de'
,p_message_text=>'Verwendung dieses Assistenten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274854253556865411)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Im Folgenden werden wesentliche Probleme zum Zeitpunkt der Freigabe aufgef\00FChrt:'),
'<ol>',
unistr('  <li>Der Assistent zum Erstellen der Anwendung vom Blueprint wird nicht \00FCbersetzt.</li>'),
unistr('  <li>Von diesem Assistenten generierte \00FCbersetzte Anwendungen werden nur teilweise \00FCbersetzt.</li>'),
unistr('  <li>Im Rahmen des Drilldowns von Berichten ist nur eine Drilldown-Spalte m\00F6glich.</li>'),
unistr('  <li>Es k\00F6nnen keine Filterberichtsseiten generiert werden.</li>'),
unistr('  <li>Das E-Mail-Feature bietet die API auf niedriger Ebene, umfasst jedoch noch keine E-Mail-Featuresauf h\00F6herer Ebene.</li>'),
'  <li>Die Generierung von Anwendungen von Blueprints, die auf nicht vorhandene Tabellen verweisen, scheitert mit einem Fehler.</li>',
'  <li>Erweiterte Einstellungen - Auf die generierte Anwendung werden keine Datumsformate angewendet.</li>',
'</ol>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274854198248865411)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_language=>'de'
,p_message_text=>'Bekannte Probleme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274819820694865387)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Freigegeben %0.</p>',
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274819715951865387)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_language=>'de'
,p_message_text=>'Releasedetails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274819319216865387)
,p_name=>'CA.INTRO.TITLE'
,p_message_language=>'de'
,p_message_text=>'Anwendung mit einem Blueprint-Assistenten erstellen {Cloudbasierte Vorschau}'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274830943052865395)
,p_name=>'CA.IP.ADDRESS'
,p_message_language=>'de'
,p_message_text=>'IP-Adresse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274829164766865394)
,p_name=>'CA.IR.SEARCH'
,p_message_language=>'de'
,p_message_text=>'IR-Suchvorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274832159368865396)
,p_name=>'CA.IR.SEARCHES'
,p_message_language=>'de'
,p_message_text=>unistr('IR-Suchvorg\00E4nge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274860658735865416)
,p_name=>'CA.ITEMNAME'
,p_message_language=>'de'
,p_message_text=>'Objektname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273951672562864760)
,p_name=>'CA.JOB.ACTION'
,p_message_language=>'de'
,p_message_text=>'Job-Aktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273953155885864761)
,p_name=>'CA.JOB.CLASS'
,p_message_language=>'de'
,p_message_text=>'Job-Klasse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273952289195864761)
,p_name=>'CA.JOB.CREATOR'
,p_message_language=>'de'
,p_message_text=>'Job-Ersteller'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273953349102864761)
,p_name=>'CA.JOB.NAME'
,p_message_language=>'de'
,p_message_text=>'Job-Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273949814365864759)
,p_name=>'CA.JOB.PRIORITY'
,p_message_language=>'de'
,p_message_text=>unistr('Job-Priorit\00E4t')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273946887333864757)
,p_name=>'CA.JOB.REPORTING'
,p_message_language=>'de'
,p_message_text=>'Jobberichte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273989420219864799)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Status und Ausf\00FChrungsdetails von Jobs anzeigen, die diese Anwendung unterst\00FCtzen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273953499593864761)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_language=>'de'
,p_message_text=>'Details des Job-Runs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273952385645864761)
,p_name=>'CA.JOB.STYLE'
,p_message_language=>'de'
,p_message_text=>'Job-Stil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273952498820864761)
,p_name=>'CA.JOB.SUBNAME'
,p_message_language=>'de'
,p_message_text=>'Job-Untername'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273951782614864760)
,p_name=>'CA.JOB.TYPE'
,p_message_language=>'de'
,p_message_text=>'Job-Typ'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273948451931864758)
,p_name=>'CA.JOB.WEIGHT'
,p_message_language=>'de'
,p_message_text=>'Job-Gewichtung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274861187762865416)
,p_name=>'CA.KEYCOLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Schl\00FCsselspalte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274862982655865418)
,p_name=>'CA.LABEL'
,p_message_language=>'de'
,p_message_text=>'Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274861469932865416)
,p_name=>'CA.LABELCOLUMN'
,p_message_language=>'de'
,p_message_text=>'Labelspalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274863117335865418)
,p_name=>'CA.LABELPLURAL'
,p_message_language=>'de'
,p_message_text=>'Label Plural'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274862893416865417)
,p_name=>'CA.LABELSINGULAR'
,p_message_language=>'de'
,p_message_text=>'Label Singular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274818578283865386)
,p_name=>'CA.LANGUAGE'
,p_message_language=>'de'
,p_message_text=>'Sprache'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274818640398865386)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('W\00E4hlen Sie die prim\00E4re Sprache f\00FCr diese Anwendung aus.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274853689400865411)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Die prim\00E4re Sprache gibt die Sprache zur Anzeige der Seiten und Komponenten an, die im App Builder generiert wurden. Wenn Sie mehrere \00DCbersetzungen ausw\00E4hlen, haben Ihre Endbenutzer mehrere Sprachen zur Auswahl, in denen die Laufzeitumgebung wiede')
||'rgegeben werden kann.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274098079103864876)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_language=>'de'
,p_message_text=>'Sprachselektor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274835559057865398)
,p_name=>'CA.LAST.NAME'
,p_message_language=>'de'
,p_message_text=>'Nachname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273952596123864761)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_language=>'de'
,p_message_text=>unistr('Dauer der letzten Ausf\00FChrung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273952600337864761)
,p_name=>'CA.LAST.START.DATE'
,p_message_language=>'de'
,p_message_text=>'Letztes Anfangsdatum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274866480576865420)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_language=>'de'
,p_message_text=>unistr('Letzte Aktivit\00E4t')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274862382262865417)
,p_name=>'CA.LISTOFVALUES'
,p_message_language=>'de'
,p_message_text=>'Werteliste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274857751018865414)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_language=>'de'
,p_message_text=>'Blueprint laden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273954986481864762)
,p_name=>'CA.LOG.DATE'
,p_message_language=>'de'
,p_message_text=>'Logdatum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273955145321864763)
,p_name=>'CA.LOG.ID'
,p_message_language=>'de'
,p_message_text=>'Log-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273949160153864758)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_language=>'de'
,p_message_text=>'Protokollierungsebene'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273736334983864608)
,p_name=>'CA.LOOKUP.COLUMNS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Lookup-Spalten</strong> - Damit k\00F6nnen Sie Attribute zum Definieren eines Lookups in einer anderen Tabelle einblenden. Verwenden Sie Lookup-Spalten, um IDs durch eine Anzeigespalte zu ersetzen (z.B. um den Abteilungsnamen anstelle der Ab')
||'teilungsnummer anzuzeigen).<br>',
'<em><strong>Hinweis:</strong> Lookup-Spalten werden nur angezeigt, wenn die aktuelle Seite auf einer Tabelle oder View basiert und Foreign Key Constraints zu einer anderen Tabelle aufweist.',
'  <ul>',
unistr('    <li><strong>Lookup-Schl\00FCssel</strong> - W\00E4hlen Sie die Spalte aus, die ge\00E4ndert werden soll, um die Anzeigespalte auszugeben.</li>'),
unistr('    <li><strong>Anzeigespalte</strong> - W\00E4hlen Sie die anzuzeigende Spalte (in der Lookup-Tabelle) aus.</li>'),
'    &nbsp;<br>',
unistr('    <em><strong>Hinweis:</strong> W\00E4hlen Sie nur Spalten aus, die eine andere Tabelle (\00FCber einen Fremdschl\00FCssel) referenzieren.</em></li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274839505833865401)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Templates verwalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274837594019865400)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_language=>'de'
,p_message_text=>'Feedback verwalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274833668350865397)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_language=>'de'
,p_message_text=>'Benutzerzugriff verwalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274867073659865420)
,p_name=>'CA.MASTER'
,p_message_language=>'de'
,p_message_text=>unistr('Master/Detail-Seite hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274867163252865421)
,p_name=>'CA.MASTER.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erstellen Sie eine Seite, auf der eine Master/Detail-Seite angezeigt wird, auf der Endbenutzer Daten anzeigen und verwalten k\00F6nnen.<br>'),
'&nbsp;</p>',
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Seitenname</strong> (Obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
unistr('  <li><strong>Seitentyp</strong> - W\00E4hlen Sie den Typ der Seite [Nebeneinander, Gestapelt] aus.<br>'),
'    <strong>Nebeneinander</strong>: <br>',
'<em>Ein einseitiges Master/Detail, das nebeneinander angeordnete Layouts und Berichtsregionen mit modalen Bearbeitungsfenstern verwendet.</em>',
'    <ul>',
unistr('      <li><strong>Tabelle</strong> (Obligatorisch) - W\00E4hlen Sie die Mastertabelle f\00FCr die Seite aus.</li>'),
unistr('      <li><strong>Prim\00E4re Anzeigespalte</strong> (Obligatorisch) - W\00E4hlen Sie die Spalte aus, die in der Liste der Masterdatens\00E4tze angezeigt werden soll.</li>'),
unistr('      <li><strong>Sekund\00E4re Anzeigespalte</strong> (Obligatorisch) - W\00E4hlen Sie die beschreibende Spalte aus, die in der Liste der Masterdatens\00E4tze unter der prim\00E4ren Anzeigespalte angezeigt werden soll.</li>'),
unistr('      <li><strong>Detailtabelle 1</strong> (Obligatorisch) - W\00E4hlen Sie die erste Detailtabelle f\00FCr die Seite aus.</li>'),
unistr('      <li><strong>Detailtabelle 2</strong> - W\00E4hlen Sie die zweite Detailtabelle f\00FCr die Seite aus.</li>'),
unistr('      <li><strong>Detailtabelle 3</strong> - W\00E4hlen Sie die dritte Detailtabelle f\00FCr die Seite aus.</li>'),
unistr('      <li><strong>Detailtabelle 4</strong> - W\00E4hlen Sie die vierte Detailtabelle f\00FCr die Seite aus.</li>'),
'    </ul>',
'   <strong>Gestapelt</strong>: <br>',
'<em>Ein einseitiges Master/Detail, das editierbare interaktive Grids verwendet.</em>',
'    <ul>',
unistr('      <li><strong>Tabelle</strong> (Obligatorisch) - W\00E4hlen Sie die Mastertabelle f\00FCr das editierbare interaktive Grid aus.</li>'),
unistr('      <li><strong>Detailtabelle</strong> (Obligatorisch) - W\00E4hlen Sie die Detailtabelle f\00FCr die Seite aus.</li>'),
unistr('      <em><strong>Hinweis:</strong> Mit dem Assistenten kann nur eine Detailtabelle (editierbares interaktives Grid) hinzugef\00FCgt werden. Nach der Generierung k\00F6nnen Sie ganz einfach weitere Detailtabellen hinzuf\00FCgen.</em>'),
'    </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274097954736864876)
,p_name=>'CA.MASTER_RECORDS'
,p_message_language=>'de'
,p_message_text=>unistr('Masterdatens\00E4tze')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274829807645865394)
,p_name=>'CA.MAX.ELAPSED'
,p_message_language=>'de'
,p_message_text=>'Maximal verstrichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273949606757864759)
,p_name=>'CA.MAX.FAILURES'
,p_message_language=>'de'
,p_message_text=>'Max. Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273949215231864758)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_language=>'de'
,p_message_text=>unistr('Maximale Ausf\00FChrungsdauer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273949793606864759)
,p_name=>'CA.MAX.RUNS'
,p_message_language=>'de'
,p_message_text=>unistr('Maximale Ausf\00FChrungen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274861377286865416)
,p_name=>'CA.MAXIMUMROWS'
,p_message_language=>'de'
,p_message_text=>'Maximale Zeilenanzahl'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274864367676865419)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_language=>'de'
,p_message_text=>'Maximale Breite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274854946642865412)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_language=>'de'
,p_message_text=>unistr('Filter hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274855396989865412)
,p_name=>'CA.MD.ADD.ROW'
,p_message_language=>'de'
,p_message_text=>unistr('%0 hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274854852487865412)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_language=>'de'
,p_message_text=>'Filter anwenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274855715445865412)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_language=>'de'
,p_message_text=>'Datumswert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274855845388865413)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_language=>'de'
,p_message_text=>'Datumswert 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274855029745865412)
,p_name=>'CA.MD.EDIT'
,p_message_language=>'de'
,p_message_text=>'Bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274854484872865412)
,p_name=>'CA.MD.FILTER'
,p_message_language=>'de'
,p_message_text=>'Filter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274854347232865411)
,p_name=>'CA.MD.FILTERS'
,p_message_language=>'de'
,p_message_text=>'Filter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274855456348865412)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_language=>'de'
,p_message_text=>'Keine Filter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274854752427865412)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_language=>'de'
,p_message_text=>unistr('Keine Datens\00E4tze ausgew\00E4hlt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274854653551865412)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_language=>'de'
,p_message_text=>unistr('Keine Datens\00E4tze gefunden')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274855264693865412)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_language=>'de'
,p_message_text=>unistr('%0 gel\00F6scht')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274855107727865412)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_language=>'de'
,p_message_text=>'%0 aktualisiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274854550046865412)
,p_name=>'CA.MD.SEARCH'
,p_message_language=>'de'
,p_message_text=>'Suche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274855513303865412)
,p_name=>'CA.MD.VALUE'
,p_message_language=>'de'
,p_message_text=>'Wert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274855671071865412)
,p_name=>'CA.MD.VALUE.2'
,p_message_language=>'de'
,p_message_text=>'Wert 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274829370990865394)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_language=>'de'
,p_message_text=>'Verstrichen, Medianwert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274838444350865400)
,p_name=>'CA.MESSAGE'
,p_message_language=>'de'
,p_message_text=>'Meldung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274863809063865418)
,p_name=>'CA.METRIC'
,p_message_language=>'de'
,p_message_text=>'Metrik'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274830238408865395)
,p_name=>'CA.MIN.ELAPSED'
,p_message_language=>'de'
,p_message_text=>'Mindestens verstrichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274833024323865397)
,p_name=>'CA.MOBILE.PHONE'
,p_message_language=>'de'
,p_message_text=>'Mobiltelefon'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274828897199865394)
,p_name=>'CA.MODE'
,p_message_language=>'de'
,p_message_text=>'Modus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274842671933865403)
,p_name=>'CA.MORE'
,p_message_language=>'de'
,p_message_text=>'Mehr'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274832291968865396)
,p_name=>'CA.MOST RECENT'
,p_message_language=>'de'
,p_message_text=>'Most_Recent'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274866209614865420)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_language=>'de'
,p_message_text=>'Aktivste Seiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273736489868864608)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_language=>'de'
,p_message_text=>'Mehrere Berichte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273736518467864608)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Aktivieren Sie mindestens einen Tabellen- oder View-Namen. Alternativ k\00F6nnen Sie das Kontrollk\00E4stchen im Header aktivieren, um alle aufgelisteten Datenbankobjekte auszuw\00E4hlen oder deren Auswahl aufzuheben.</p>'),
unistr('<p>Eine Seite mit einem interaktiven Bericht wird f\00FCr jedes ausgew\00E4hlte Datenbankobjekt hinzugef\00FCgt.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274826235622865392)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_language=>'de'
,p_message_text=>unistr('#LABEL# muss ein g\00FCltiger Zeitstempel sein.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274863671596865418)
,p_name=>'CA.NAME'
,p_message_language=>'de'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274817759361865386)
,p_name=>'CA.NAVIGATION'
,p_message_language=>'de'
,p_message_text=>'Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274817872010865386)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Legen Sie fest, ob das Men\00FC am seitlichen oder oberen Rand der Anwendung angezeigt werden soll.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274870307673865423)
,p_name=>'CA.NEGATIVE'
,p_message_language=>'de'
,p_message_text=>'Negativ'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274870244651865423)
,p_name=>'CA.NEUTRAL'
,p_message_language=>'de'
,p_message_text=>'Neutral'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274856347479865413)
,p_name=>'CA.NEXT'
,p_message_language=>'de'
,p_message_text=>'Weiter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273949425615864759)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_language=>'de'
,p_message_text=>unistr('N\00E4chstes Ausf\00FChrungsdatum')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273948310446864758)
,p_name=>'CA.NLS.ENV'
,p_message_language=>'de'
,p_message_text=>'NLS-Umgebung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274046151484864839)
,p_name=>'CA.NO'
,p_message_language=>'de'
,p_message_text=>'Nein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274837160404865399)
,p_name=>'CA.NO.ACTION'
,p_message_language=>'de'
,p_message_text=>'Keine Aktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274848712881865408)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr diese Seite ist keine Hilfe verf\00FCgbar.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273735694314864608)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'de'
,p_message_text=>unistr('Keine g\00FCltigen Benutzer vorhanden - Seiteninfo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274857390666865414)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_language=>'de'
,p_message_text=>unistr('Keine g\00FCltigen neuen Benutzer gefunden')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274853476219865411)
,p_name=>'CA.NONE'
,p_message_language=>'de'
,p_message_text=>'Kein Wert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274833372261865397)
,p_name=>'CA.NOTE'
,p_message_language=>'de'
,p_message_text=>'Hinweis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274808812725865380)
,p_name=>'CA.NOTIFICATION'
,p_message_language=>'de'
,p_message_text=>'Benachrichtigungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274807678741865379)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_language=>'de'
,p_message_text=>'Benachrichtigungen auf der Homepage anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274808987840865380)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Damit k\00F6nnen Anwendungsadministratoren entweder Alerts (gelb) oder Fehler (rot) angeben, die allen Endbenutzern auf der Homepage der Anwendung angezeigt werden. Dieses Feature ist hilfreich, um wichtige Informationen an die Endbenutzercommunity we')
||'iterzugeben.</p>',
'<p>Umfasst die folgenden Komponenten:<ul>',
unistr('<li>M\00F6glichkeit zum Definieren von Benachrichtigungen</li>'),
'<li>Anzeige von Benachrichtigungen auf der Anwendungshomepage</li>',
unistr('<li>M\00F6glichkeit zur Kontrolle des Zeitfensters f\00FCr die Anzeige von Benachrichtigungen</li>'),
unistr('<li>Unterst\00FCtzung der Farbcodierung von Benachrichtigungen nach Typ</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274825595741865391)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_language=>'de'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274829072695865394)
,p_name=>'CA.NUM.ROWS'
,p_message_language=>'de'
,p_message_text=>'Anzahl Zeilen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273951596384864760)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_language=>'de'
,p_message_text=>'Anzahl der Argumente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273948105559864758)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_language=>'de'
,p_message_text=>'Anzahl Ziele'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274861814843865417)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_language=>'de'
,p_message_text=>'Zahlenformatmaske      '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274830516026865395)
,p_name=>'CA.OCCURRENCE'
,p_message_language=>'de'
,p_message_text=>'Vorkommen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274870500646865423)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_language=>'de'
,p_message_text=>unistr('Sie k\00F6nnen diese Aktion nur ausf\00FChren, wenn ein anderer Administrator verf\00FCgbar ist.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274837360843865400)
,p_name=>'CA.OPEN'
,p_message_language=>'de'
,p_message_text=>unistr('\00D6ffnen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274810389774865381)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_language=>'de'
,p_message_text=>'Seiten werden angeordnet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274810665272865381)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Sie k\00F6nnen die Seiten in der Reihenfolge anordnen, in der sie in der Anwendung angezeigt werden sollen. <br>'),
unistr('Um Seiten in der Liste neu anzuordnen, klicken Sie am Ende einer Seitenliste auf das Symbol <em>Ziehen, um Seite neu anzuordnen</em> (<span class="fa fa-bars" aria-hidden="true"></span>), und verschieben Sie die Seite bei gedr\00FCcktem Symbol per Drag-a')
||'nd-Drop nach oben oder unten.</p>',
'<p>Die Homepage wird immer zuerst angezeigt und kann nicht neu angeordnet werden.<br>',
unistr('Administrationsseiten werden immer am Ende der Liste angezeigt. Die hier festgelegte Reihenfolge wird auf der Seite "Administration" in der Liste "Anwendungsadministration" \00FCbernommen.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273953661026864762)
,p_name=>'CA.OUTPUT'
,p_message_language=>'de'
,p_message_text=>'Ausgabe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273954871047864762)
,p_name=>'CA.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Eigent\00FCmer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274828712670865394)
,p_name=>'CA.PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274831994510865396)
,p_name=>'CA.PAGE.EVENTS'
,p_message_language=>'de'
,p_message_text=>'Seitenereignisse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274844499089865405)
,p_name=>'CA.PAGE.HELP'
,p_message_language=>'de'
,p_message_text=>'Hilfe zu den Seiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274831091803865395)
,p_name=>'CA.PAGE.ITEM'
,p_message_language=>'de'
,p_message_text=>'Seitenelement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274099940932864877)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_language=>'de'
,p_message_text=>'Masterdatensatz bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274100139557864877)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_language=>'de'
,p_message_text=>unistr('Suche ausf\00FChren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274828369584865393)
,p_name=>'CA.PAGE.NAME'
,p_message_language=>'de'
,p_message_text=>'Seitenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274843756130865404)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_language=>'de'
,p_message_text=>'Seitennavigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274830498601865395)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_language=>'de'
,p_message_text=>'Seiten-Performance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274856451284865413)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_language=>'de'
,p_message_text=>unistr('Der Seitentyp "%0" ist kein g\00FCltiger Typ.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274829716256865394)
,p_name=>'CA.PAGE.VIEWS'
,p_message_language=>'de'
,p_message_text=>'Seitenansichten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274810807315865381)
,p_name=>'CA.PAGES'
,p_message_language=>'de'
,p_message_text=>'Seiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274810952161865381)
,p_name=>'CA.PAGES.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Hier definieren Sie die Seiten, die in Ihre anf\00E4ngliche Anwendung aufgenommen werden sollen. Sie m\00FCssen mindestens eine Seite definieren, um eine Anwendung erstellen zu k\00F6nnen.</p>'),
unistr('<p>Sie k\00F6nnen Ihre Anwendung mit Stubs versehen, indem Sie mit diesem Assistenten beliebig viele Seiten erstellen. Nachdem Sie die Anwendung erstellt haben, k\00F6nnen Sie mit dem Assistenten "Seite erstellen" weitere Seiten hinzuf\00FCgen.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274861780086865417)
,p_name=>'CA.PAGINATIONMETHOD'
,p_message_language=>'de'
,p_message_text=>unistr('Methode f\00FCr Seitenumbruch')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274830027958865394)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_language=>'de'
,p_message_text=>'Seitenbestandteil-Ansichten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274835878882865399)
,p_name=>'CA.PHOTO'
,p_message_language=>'de'
,p_message_text=>'Foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274836477291865399)
,p_name=>'CA.PHOTO.DELETED'
,p_message_language=>'de'
,p_message_text=>unistr('Foto gel\00F6scht.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274835905718865399)
,p_name=>'CA.PHOTO.NAME'
,p_message_language=>'de'
,p_message_text=>'Fotoname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274835655696865398)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_language=>'de'
,p_message_text=>'Fotoupload'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274840483705865402)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Nur-Text-Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274870159014865423)
,p_name=>'CA.POSITIVE'
,p_message_language=>'de'
,p_message_text=>'Positiv'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274823258632865390)
,p_name=>'CA.PREFERENCES'
,p_message_language=>'de'
,p_message_text=>'Voreinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274867721568865421)
,p_name=>'CA.PREVIOUS'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274862432579865417)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Prim\00E4re Anzeigespalte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274863349286865418)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Prim\00E4rschl\00FCsselspalte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274863461679865418)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_language=>'de'
,p_message_text=>unistr('Prim\00E4re \00FCbergeordnete Tabelle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274830686695865395)
,p_name=>'CA.PROCEDURE'
,p_message_language=>'de'
,p_message_text=>'Prozedur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274823806466865390)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Voreinstellung wurde aktualisiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274099503098864877)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_language=>'de'
,p_message_text=>'Zeile abrufen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274825086674865391)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_language=>'de'
,p_message_text=>unistr('Einstellungen f\00FCr die Darstellung der Anwendung wurden gespeichert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274823707288865390)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_language=>'de'
,p_message_text=>'Zeitzonenvoreinstellung wurde aktualisiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274836269184865399)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'de'
,p_message_text=>'Download des Profilfotos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273951806234864760)
,p_name=>'CA.PROGRAM.NAME'
,p_message_language=>'de'
,p_message_text=>'Programmname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273951950826864760)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Programmeigent\00FCmer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274862789491865417)
,p_name=>'CA.QUERY'
,p_message_language=>'de'
,p_message_text=>'Abfrage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273948649483864758)
,p_name=>'CA.RAISE.EVENTS'
,p_message_language=>'de'
,p_message_text=>unistr('Ereignisse ausl\00F6sen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273580462327864502)
,p_name=>'CA.RATING'
,p_message_language=>'de'
,p_message_text=>'Bewertung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274834198659865397)
,p_name=>'CA.READERS'
,p_message_language=>'de'
,p_message_text=>'Leseberechtigte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274823563111865390)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_language=>'de'
,p_message_text=>'E-Mails empfangen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274866379234865420)
,p_name=>'CA.RECENT.ERRORS'
,p_message_language=>'de'
,p_message_text=>'Letzte Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274606748968865237)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_language=>'de'
,p_message_text=>'Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274606863032865237)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_language=>'de'
,p_message_text=>'Wert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274825737447865391)
,p_name=>'CA.RED'
,p_message_language=>'de'
,p_message_text=>'Rot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274839334940865401)
,p_name=>'CA.REFERENCED'
,p_message_language=>'de'
,p_message_text=>'Referenziert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274098669552864876)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_language=>'de'
,p_message_text=>'Admin-Seite aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273716097755864594)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_language=>'de'
,p_message_text=>unistr('Bei Schlie\00DFen von Dialogfeld aktualisieren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274100061739864877)
,p_name=>'CA.REFRESH_REPORT'
,p_message_language=>'de'
,p_message_text=>'Bericht aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274825278185865391)
,p_name=>'CA.REGION.BUTTONS'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4chenregion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274825191957865391)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_language=>'de'
,p_message_text=>unistr('Region f\00FCr Formularelemente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274831110724865395)
,p_name=>'CA.REGION.ID'
,p_message_language=>'de'
,p_message_text=>'Regions-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274843176908865404)
,p_name=>'CA.RELEASE'
,p_message_language=>'de'
,p_message_text=>'Release %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274810457887865381)
,p_name=>'CA.REMOVING.PAGES'
,p_message_language=>'de'
,p_message_text=>'Seiten werden entfernt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274810547081865381)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Klicken Sie auf <strong>Bearbeiten</strong>, um die Seite auszuw\00E4hlen, und klicken Sie anschlie\00DFend auf <strong>Seite l\00F6schen</strong>, um eine Seite aus Ihrer Anwendung zu entfernen.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273953252200864761)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_language=>'de'
,p_message_text=>'Wiederholungsintervall'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273814756843864664)
,p_name=>'CA.REPLY.TO'
,p_message_language=>'de'
,p_message_text=>'Antwort an'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274816232736865385)
,p_name=>'CA.REPORT'
,p_message_language=>'de'
,p_message_text=>unistr('Berichtsseite hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274816199476865385)
,p_name=>'CA.REPORT.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Erstellen Sie eine Seite, die entweder einen interaktiven oder einen klassischen Bericht anzeigt.</p>',
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Seitenname</strong> (Obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
unistr('  <li><strong>Abfragetyp</strong> - W\00E4hlen Sie die Quelle f\00FCr den Bericht aus [<strong>Tabelle oder View</strong> oder <strong>SQL-Abfrage</strong>].<br>'),
'    <strong>Tabelle oder View</strong>:',
'    <ul>',
unistr('      <li>Tabelle oder View (Obligatorisch) - W\00E4hlen Sie das Datenbankobjekt f\00FCr den Bericht aus.</li>'),
unistr('      <li>Formular einbeziehen - Aktivieren Sie diese Option, um eine verkn\00FCpfte Formularseite aufzunehmen, damit Benutzer die Tabellenwerte verwalten k\00F6nnen.</li>'),
'    </ul>',
'    <strong>SQL-Abfrage</strong>:',
'    <ul>',
unistr('      <li>SQL-Abfrage (Obligatorisch) - Geben Sie eine g\00FCltige SQL-Anweisung ein, die eindeutige Spalten zur\00FCckgibt.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>Berichtstyp</strong> - W\00E4hlen Sie den Typ des Berichts aus [<strong>Interaktiver Bericht</strong> oder <strong>Klassischer Bericht</strong>].</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274807906018865379)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_language=>'de'
,p_message_text=>'%0 mit Formular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274652765914865269)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_language=>'de'
,p_message_text=>'%0 Bericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274865430198865419)
,p_name=>'CA.REPORT.VIEW'
,p_message_language=>'de'
,p_message_text=>'Berichtsansicht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274864033210865418)
,p_name=>'CA.REPORTS'
,p_message_language=>'de'
,p_message_text=>'Berichte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273954628976864762)
,p_name=>'CA.REQ.START.DATE'
,p_message_language=>'de'
,p_message_text=>'Angefordertes Anfangsdatum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274864292242865418)
,p_name=>'CA.REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Erforderlich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274841207874865402)
,p_name=>'CA.RESET'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCcksetzen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274837208205865399)
,p_name=>'CA.RESOLVED'
,p_message_language=>'de'
,p_message_text=>unistr('Gel\00F6st')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274836920587865399)
,p_name=>'CA.RESPONSE'
,p_message_language=>'de'
,p_message_text=>'Antwort'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273949989685864759)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_language=>'de'
,p_message_text=>'Neustart bei Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273950034021864759)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_language=>'de'
,p_message_text=>'Neustart bei Recovery'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273947253437864757)
,p_name=>'CA.RESTARTABLE'
,p_message_language=>'de'
,p_message_text=>'Kann neu gestartet werden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273949517410864759)
,p_name=>'CA.RETRY.COUNT'
,p_message_language=>'de'
,p_message_text=>'Anzahl Wiederholungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274859245556865415)
,p_name=>'CA.ROLE'
,p_message_language=>'de'
,p_message_text=>'Rolle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274831354953865395)
,p_name=>'CA.ROW.NUMBER'
,p_message_language=>'de'
,p_message_text=>'Zeilennummer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274840616942865402)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Zeilentemplate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274858682967865414)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_language=>'de'
,p_message_text=>unistr('HTML f\00FCr Zeilentemplate')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274859945704865415)
,p_name=>'CA.ROWS.CONTENT'
,p_message_language=>'de'
,p_message_text=>'Zeileninhalt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274832001875865396)
,p_name=>'CA.ROWS.FETCHED'
,p_message_language=>'de'
,p_message_text=>'Abgerufene Zeilen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274861628131865417)
,p_name=>'CA.ROWSPERPAGE'
,p_message_language=>'de'
,p_message_text=>'Zeilen pro Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273952840345864761)
,p_name=>'CA.RUN.COUNT'
,p_message_language=>'de'
,p_message_text=>unistr('Anzahl von Ausf\00FChrungen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273954423167864762)
,p_name=>'CA.RUN.DURATION'
,p_message_language=>'de'
,p_message_text=>unistr('Ausf\00FChrungsdauer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273949335383864759)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_language=>'de'
,p_message_text=>unistr('Grenzwert des Ausf\00FChrungsplans')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273951360378864760)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Name des Ausf\00FChrungsplans')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273951404882864760)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Eigent\00FCmer des Ausf\00FChrungsplans')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273951239600864760)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_language=>'de'
,p_message_text=>unistr('Typ des Ausf\00FChrungsplans')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274818719357865387)
,p_name=>'CA.SCHEMA'
,p_message_language=>'de'
,p_message_text=>'Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274818869860865387)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('<p>W\00E4hlen Sie das Datenbankschema aus, in dem die Datenbankobjekte gespeichert sind, die Sie in dieser Anwendung verwenden m\00F6chten.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274860728346865416)
,p_name=>'CA.SCOPE'
,p_message_language=>'de'
,p_message_text=>'Geltungsbereich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274841304629865402)
,p_name=>'CA.SEARCH'
,p_message_language=>'de'
,p_message_text=>'Suche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274841458697865402)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung durchsuchen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274841564925865402)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_language=>'de'
,p_message_text=>'Suchdialog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274865663126865419)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_language=>'de'
,p_message_text=>'Suchfilter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274848286178865407)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Diese Seite wird aus der Liste der gemeinsamen Komponenten, der sogenannten durchsuchten Tabellen entfernt.',
'',
unistr('Alle Seiten f\00FCr den interaktiven Bericht, die vom Assistenten zum Erstellen von Anwendungen anf\00E4nglich generiert wurden, werden der Liste automatisch hinzugef\00FCgt. Um der Liste eigene Tabellen hinzuzuf\00FCgen und dann zu "Gemeinsame Komponenten" zu navig')
||unistr('ieren, w\00E4hlen Sie "Listen" und klicken auf "Durchsuchte Tabellen".'),
'  Geben Sie die folgenden Attribute ein:',
unistr('    Eintrag: Listeneintragslabel - Geben Sie den Anzeigenamen f\00FCr die Tabelle ein.'),
unistr('    Ziel: Seite - W\00E4hlen Sie die Seite, zu der navigiert werden soll (vorzugsweise ein interaktiver Bericht)'),
unistr('    Ziel: Cacheinhalt l\00F6schen - Geben Sie alle Seiten ein, die gel\00F6scht werden m\00FCssen (meist dieselbe Anzahl wie unter "Seite" eingegeben).'),
unistr('       Wenn Sie zu einer Seite f\00FCr einen interaktiven Bericht navigieren, geben Sie CIR,RIR ein, um vorhandene Filter usw. zu l\00F6schen'),
unistr('    Ziel: Diese Elemente festlegen - W\00E4hlen Sie das korrekte auszuf\00FCllende Seitenelement aus (oder geben Sie es ein).'),
'       Geben Sie IR_[COLUMN_NAME] ein, um zu einer Seite mit interaktivem Bericht zu navigieren.',
'    Ziel: Mit diesen Werten - Geben Sie =PK= ein',
unistr('    Benutzerdefinierte Attribute: 1 - Geben Sie den zu suchenden Tabellennamen in Gro\00DFbuchstaben ein.'),
unistr('    Benutzerdefinierte Attribute: 2 - Geben Sie den Namen der prim\00E4ren Spalte in Gro\00DFbuchstaben ein.'),
'    Benutzerdefinierte Attribute: 3 (optional) - durch Komma getrennte Liste der zu durchsuchenden Spalten.',
unistr('       Falls keine Spalten angegeben werden, werden die Spalten f\00FCr Nur-Text (varchar2) und Character Large Object (clob) durchsucht.'),
'',
unistr('Hinweis: Eine Liste der verf\00FCgbaren zu durchsuchenden Tabellen wird Benutzern nur angezeigt, wenn mehr als eine Tabelle aufgef\00FChrt ist.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274841007983865402)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_language=>'de'
,p_message_text=>'Suchergebnisse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274863216204865418)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Sekund\00E4re Anzeigespalte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274837684592865400)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Ausgew\00E4hltes Template')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273814081696864663)
,p_name=>'CA.SEND.BEGIN'
,p_message_language=>'de'
,p_message_text=>'Sendebeginn'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273814415702864664)
,p_name=>'CA.SEND.COUNT'
,p_message_language=>'de'
,p_message_text=>'Anzahl Sendungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273813997623864663)
,p_name=>'CA.SEND.END'
,p_message_language=>'de'
,p_message_text=>'Sendeende'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273814389342864663)
,p_name=>'CA.SEND.ERROR'
,p_message_language=>'de'
,p_message_text=>'Sendefehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274869279321865422)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_language=>'de'
,p_message_text=>'E-Mails senden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274869377694865422)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_language=>'de'
,p_message_text=>'Legt fest, ob E-Mails gesendet werden sollen, wenn neues Feedback empfangen wird.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274865995364865420)
,p_name=>'CA.SEND.FROM'
,p_message_language=>'de'
,p_message_text=>'Absenderadresse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274858433267865414)
,p_name=>'CA.SEND.TO'
,p_message_language=>'de'
,p_message_text=>'Senden an'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274842940119865404)
,p_name=>'CA.SERIES'
,p_message_language=>'de'
,p_message_text=>'Datenreihe %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273954330286864762)
,p_name=>'CA.SESSION.ID'
,p_message_language=>'de'
,p_message_text=>'Session-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274860975103865416)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_language=>'de'
,p_message_text=>unistr('Schutz f\00FCr den Sessionzustand')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274818179385865386)
,p_name=>'CA.SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Einstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274818277850865386)
,p_name=>'CA.SETTINGS.DESC'
,p_message_language=>'de'
,p_message_text=>'<p>Geben Sie die Einstellungen ein, die zur Generierung der Anwendung verwendet werden.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274842558477865403)
,p_name=>'CA.SHOW.ALL'
,p_message_language=>'de'
,p_message_text=>'Alles anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273715201911864593)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_language=>'de'
,p_message_text=>'Geltungsbereich ein-/ausblenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274843651049865404)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_language=>'de'
,p_message_text=>'Zeitzone anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274843405924865404)
,p_name=>'CA.SIGN.IN'
,p_message_language=>'de'
,p_message_text=>'Anmelden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274844631584865405)
,p_name=>'CA.SIGN.OUT'
,p_message_language=>'de'
,p_message_text=>'Abmelden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273954228835864762)
,p_name=>'CA.SLAVE.PID'
,p_message_language=>'de'
,p_message_text=>'Untergeordnete PID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273948235221864758)
,p_name=>'CA.SOURCE'
,p_message_language=>'de'
,p_message_text=>'Quelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274856505017865413)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_language=>'de'
,p_message_text=>unistr('Der Quelltyp ist kein g\00FCltiger Typ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274848359253865407)
,p_name=>'CA.SOURCES'
,p_message_language=>'de'
,p_message_text=>'Quellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273951156921864760)
,p_name=>'CA.START.DATE'
,p_message_language=>'de'
,p_message_text=>'Startdatum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273952970970864761)
,p_name=>'CA.STATE'
,p_message_language=>'de'
,p_message_text=>'Status'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274864153474865418)
,p_name=>'CA.STATICDEFAULT'
,p_message_language=>'de'
,p_message_text=>'Statischer Standardwert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274827341390865393)
,p_name=>'CA.STATUS'
,p_message_language=>'de'
,p_message_text=>'Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273948997267864758)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_language=>'de'
,p_message_text=>unistr('Bei Schlie\00DFen von Fenster stoppen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273949006811864758)
,p_name=>'CA.STORE.OUTPUT'
,p_message_language=>'de'
,p_message_text=>'Ausgabe speichern'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274837881040865400)
,p_name=>'CA.SUBJECT'
,p_message_language=>'de'
,p_message_text=>'Betreff'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274836549518865399)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_language=>'de'
,p_message_text=>'Feedback weiterleiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274861231853865416)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_language=>'de'
,p_message_text=>'Empfohlene Visualisierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274853118670865411)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_language=>'de'
,p_message_text=>unistr('Unterst\00FCtzende Objekte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274853250249865411)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('<p>Geben Sie Code in das Installationsskript ein. In der Regel erstellen oder bearbeiten Sie damit Datenbankobjekte oder f\00FChren Einf\00FCge-, Aktualisierungs- oder L\00F6schvorg\00E4nge f\00FCr vorhandene Datens\00E4tze aus. Geben Sie Code in das Deinstallationsskript e')
||unistr('in, um Datenbankobjekte zu entfernen (l\00F6schen). Diese Skripte werden in die unterst\00FCtzenden Objekte eingebunden, sodass beim Export der Anwendung dieselben Aktualisierungen in den Test- und Production-Umgebungen durchgef\00FChrt werden.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274853344925865411)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Geben Sie g\00FCltige SQL- und/oder PL/SQL-Anweisungen in das Installationsskript ein, die beim Import der Anwendung ausgef\00FChrt werden.</p>'),
unistr('<p>Wenn diese Anweisungen nicht nur beim Import in eine andere Umgebung, sondern auch in der aktuellen Umgebung ausgef\00FChrt werden sollen, klicken Sie auf <strong>Bei Erstellung der Anwendung ausf\00FChren</strong>.</p>'),
unistr('<p>Geben Sie g\00FCltige SQL- und/oder PL/SQL-Anweisungen in das Deinstallationsskript ein, die ausgef\00FChrt werden, wenn die Anwendung vom App Builder gel\00F6scht wird.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273948544853864758)
,p_name=>'CA.SYSTEM'
,p_message_language=>'de'
,p_message_text=>'System'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274862635232865417)
,p_name=>'CA.TABLE'
,p_message_language=>'de'
,p_message_text=>'Tabelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274818909970865387)
,p_name=>'CA.TABLE.PREFIX'
,p_message_language=>'de'
,p_message_text=>unistr('Pr\00E4fix f\00FCr Framework-Objekt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274819037044865387)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Geben Sie ein Objektpr\00E4fix ein, das von der Anwendung verwendet werden soll. Einige Features f\00FCgen dieses Pr\00E4fix zu den von ihnen erstellen Datenbankobjekten hinzu (einschlie\00DFlich Packages und Tabellen).</p>'),
unistr('<p>Warnung: Stellen Sie sicher, dass Sie ein eindeutiges Pr\00E4fix eingeben, das nicht von anderen Anwendungen verwendet wird. Wenn das Pr\00E4fix nicht eindeutig ist, werden bei der Erstellung der Anwendung m\00F6glicherweise Fehler ausgel\00F6st, und die Anwendun')
||'g funktioniert nicht richtig.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274863572000865418)
,p_name=>'CA.TABLECOLUMN'
,p_message_language=>'de'
,p_message_text=>'Tabellenspalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274858552651865414)
,p_name=>'CA.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274840976350865402)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_language=>'de'
,p_message_text=>'Dieser Template-Name wird bereits verwendet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274837749924865400)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_language=>'de'
,p_message_text=>'Templatename'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274826495923865392)
,p_name=>'CA.TEXT'
,p_message_language=>'de'
,p_message_text=>'Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273814251733864663)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_language=>'de'
,p_message_text=>unistr('Textteilgr\00F6\00DFe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274838953226865401)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Texttemplate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274824644493865391)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_language=>'de'
,p_message_text=>'Endbenutzer-Theme-Voreinstellung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274824859702865391)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_language=>'de'
,p_message_text=>unistr('Wenn diese Option aktiviert ist, d\00FCrfen Endbenutzer ihren eigenen Theme-Stil \00FCber den Link "Anpassen" ausw\00E4hlen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274824767076865391)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_language=>'de'
,p_message_text=>unistr('Endbenutzer d\00FCrfen Theme-Stil ausw\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274809084092865380)
,p_name=>'CA.THEME.SELECTOR'
,p_message_language=>'de'
,p_message_text=>'Theme-Stilauswahl'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274807475876865379)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_language=>'de'
,p_message_text=>'Look-and-Feel der Standardanwendung aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274809132316865380)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Damit k\00F6nnen Administratoren ein Standardfarbschema (Theme-Stil) f\00FCr die Anwendung ausw\00E4hlen. Administratoren k\00F6nnen auch festlegen, ob Endbenutzer ihren eigenen Theme-Stil ausw\00E4hlen d\00FCrfen. Endbenutzer k\00F6nnen einfach unten auf der Homepage auf di')
||unistr('e Schaltfl\00E4che <em>Anpassen</em> klicken und eine Auswahl aus den verf\00FCgbaren Theme-Stilen treffen. Beispiel: Benutzer mit Sehbeeintr\00E4chtigung bevorzugen m\00F6glicherweise den Theme-Stil <em>Vista</em>, der einen sehr viel h\00F6heren Farbkontrast bietet.</')
||'p>',
'<p>Umfasst die folgenden Komponenten:',
'<ul>',
unistr('<li>Administratoren d\00FCrfen den Standard-Theme-Stil definieren</li>'),
unistr('<li>Endbenutzer d\00FCrfen verschiedene Theme-Stile ausw\00E4hlen</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274817573851865386)
,p_name=>'CA.THEME.STYLE'
,p_message_language=>'de'
,p_message_text=>'Designformat'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274817689539865386)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>W\00E4hlen Sie den Standard-Theme-Stil aus, mit dem die Anwendung angezeigt werden soll.</p>'),
unistr('<p>Der Stil kann leicht in einen anderen vordefinierten Stil ge\00E4ndert oder nach der Generierung angepasst werden. Um den Stil zu \00E4ndern, f\00FChren Sie die Anwendung aus, und klicken Sie in der Entwicklersymbolleiste auf <strong>Theme Roller</strong>.</p')
||'>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274831669989865396)
,p_name=>'CA.TIME'
,p_message_language=>'de'
,p_message_text=>'Uhrzeit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274823322237865390)
,p_name=>'CA.TIME.ZONE'
,p_message_language=>'de'
,p_message_text=>'Zeitzone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274810115819865380)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_language=>'de'
,p_message_text=>unistr('Unterst\00FCtzung f\00FCr Zeitzonen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274807070559865378)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_language=>'de'
,p_message_text=>'Standard- und Benutzerzeitzonen festlegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274809899306865380)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erm\00F6glichen Sie Endbenutzern, die lokale Zeitzone einzustellen. Dies ist wichtig, wenn in Ihren Anwendungstabellen zeitzonenbasierte Datumstypen verwendet werden (Beispiel: Zeitstempel mit lokaler Zeitzone), damit Berichte und Dateneintr\00E4ge den St')
||'andort der Endbenutzer widerspiegeln.</p>',
'<p>Umfasst die folgenden Komponenten:',
'<ul>',
unistr('<li>Administratoren d\00FCrfen die Standardzeitzone festlegen</li>'),
unistr('<li>Endbenutzer d\00FCrfen ihre Zeitzonenvoreinstellung ausw\00E4hlen</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274866538761865420)
,p_name=>'CA.TIMEFRAME'
,p_message_language=>'de'
,p_message_text=>'Zeitrahmen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274866815647865420)
,p_name=>'CA.TIMELINE'
,p_message_language=>'de'
,p_message_text=>unistr('Timelineseite hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274866964203865420)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erstellen Sie eine Seite, die eine Timeline anzeigt. Dies eignet sich besonders f\00FCr die Anzeige von Updates.</p>'),
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Seitenname</strong> (Obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
unistr('  <li><strong>Tabelle oder View</strong> (Obligatorisch) - W\00E4hlen Sie das Datenbankobjekt f\00FCr die Timeline aus.</li>'),
unistr('  <li><strong>Benutzername</strong> (Obligatorisch) - W\00E4hlen Sie die Spalte aus der Tabelle oder View aus, die als Benutzer f\00FCr die Timelineeintr\00E4ge verwendet werden soll.</li>'),
unistr('  <li><strong>Datum</strong> (Obligatorisch) - W\00E4hlen Sie die Spalte aus der Tabelle oder View aus, die als Datum f\00FCr die Timelineeintr\00E4ge verwendet werden soll.</li>'),
unistr('  <li><strong>Ereignisname</strong> (Obligatorisch) - W\00E4hlen Sie die Spalte aus der Tabelle oder View aus, die als Titel f\00FCr die Timelineeintr\00E4ge verwendet werden soll.</li>'),
unistr('  <li><strong>Beschreibung</strong> - W\00E4hlen Sie die Spalte aus der Tabelle oder View aus, die als Beschreibung f\00FCr die Timelineeintr\00E4ge verwendet werden soll.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274828523715865393)
,p_name=>'CA.TIMESTAMP'
,p_message_language=>'de'
,p_message_text=>'Zeitstempel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274833188401865397)
,p_name=>'CA.TITLE'
,p_message_language=>'de'
,p_message_text=>'Anrede'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273814853453864664)
,p_name=>'CA.TO'
,p_message_language=>'de'
,p_message_text=>'An'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274832311428865396)
,p_name=>'CA.TOP.USERS'
,p_message_language=>'de'
,p_message_text=>'Topbenutzer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274832435870865396)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_language=>'de'
,p_message_text=>'Diagramm Top-Benutzer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274829964578865394)
,p_name=>'CA.TOTAL.ROWS'
,p_message_language=>'de'
,p_message_text=>'Zeilen gesamt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274834390295865397)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_language=>'de'
,p_message_text=>unistr('Standardrolle f\00FCr Benutzer, die nicht in der Access-Control-Liste enthalten sind:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274826537614865392)
,p_name=>'CA.TYPE'
,p_message_language=>'de'
,p_message_text=>'Typ'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274045439600864838)
,p_name=>'CA.UI.DEFAULTS'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzeroberfl\00E4chen-Standards')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274045540936864838)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('Legen Sie Standardwerte f\00FCr Einstellungen der Benutzeroberfl\00E4che fest, wie Zeilen pro Seite, und f\00FCgen Sie eine Liste mit Wertdefinitionen hinzu. Diese Einstellungen werden beim Generieren von Komponenten in der Anwendung verwendet. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274826795759865392)
,p_name=>'CA.UNTIL'
,p_message_language=>'de'
,p_message_text=>'Bis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274098447322864876)
,p_name=>'CA.UPDATE'
,p_message_language=>'de'
,p_message_text=>'Aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274836161311865399)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_language=>'de'
,p_message_text=>'Profil aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274827090531865392)
,p_name=>'CA.UPDATED'
,p_message_language=>'de'
,p_message_text=>'Aktualisiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274827156038865392)
,p_name=>'CA.UPDATED.BY'
,p_message_language=>'de'
,p_message_text=>'Aktualisiert von'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274828469857865393)
,p_name=>'CA.USER'
,p_message_language=>'de'
,p_message_text=>'Benutzer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274856034237865413)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_language=>'de'
,p_message_text=>unistr('Mehrere Benutzer hinzuf\00FCgen - Schritt 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274856139108865413)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_language=>'de'
,p_message_text=>unistr('Mehrere Benutzer hinzuf\00FCgen - Schritt 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274856238300865413)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_language=>'de'
,p_message_text=>unistr('Mehrere Benutzer hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274830835398865395)
,p_name=>'CA.USER.AGENT'
,p_message_language=>'de'
,p_message_text=>'Benutzer-Agent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274844202334865404)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_language=>'de'
,p_message_text=>'Bericht zur Benutzeranzahl'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274832693125865396)
,p_name=>'CA.USER.NAME'
,p_message_language=>'de'
,p_message_text=>'Benutzername'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274835145051865398)
,p_name=>'CA.USER.PROFILE'
,p_message_language=>'de'
,p_message_text=>'Benutzerprofil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274810011253865380)
,p_name=>'CA.USER.PROFILES'
,p_message_language=>'de'
,p_message_text=>'Benutzerprofile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274806985073865378)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzer d\00FCrfen ihr Profil aktualisieren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274809915575865380)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erm\00F6glichen Sie Endbenutzern, zus\00E4tzliche Informationen \00FCber sich selbst, darunter ein Bild oder einen Avatar, einzugeben, um ihren Account zu personalisieren.</p>'),
'<p>Umfasst die folgenden Komponenten:',
'<ul>',
unistr('<li>Einstellungsseite, auf der Endbenutzer ihr Profil festlegen k\00F6nnen</li>'),
unistr('<li>M\00F6glichkeit zum Hochladen eines Fotos/Avatars</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274835331272865398)
,p_name=>'CA.USERNAME'
,p_message_language=>'de'
,p_message_text=>'Benutzername'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274834477386865398)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_language=>'de'
,p_message_text=>'Format Benutzername'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274856970186865413)
,p_name=>'CA.USERNAMES'
,p_message_language=>'de'
,p_message_text=>'Benutzernamen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274053162778864844)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_language=>'de'
,p_message_text=>'Benutzernamenformat'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274857526728865414)
,p_name=>'CA.USERS.ADDED'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzer hinzugef\00FCgt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274859053110865415)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_language=>'de'
,p_message_text=>'Benutzer nach Rollen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274838593129865400)
,p_name=>'CA.USERS.INCLUDED'
,p_message_language=>'de'
,p_message_text=>'Einbezogene Benutzer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274857253769865414)
,p_name=>'CA.USERS.TO.ADD'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuzuf\00FCgende Benutzer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274834601489865398)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_language=>'de'
,p_message_text=>'Format des Benutzernamens wurde gespeichert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273735441082864607)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'de'
,p_message_text=>unistr('G\00FCltige Benutzer vorhanden - Seiteninfo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274850210381865409)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_language=>'de'
,p_message_text=>unistr('Die Anwendungs-ID ist bereits vorhanden oder f\00FCr eine andere Anwendung reserviert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273993740047864802)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_language=>'de'
,p_message_text=>'Der Anwendungsname muss angegeben werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274859614725865415)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_language=>'de'
,p_message_text=>'Muss E-Mail-Adressen bereitstellen, an die Ihre E-Mail gesendet wird.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274859431608865415)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_language=>'de'
,p_message_text=>unistr('Muss E-Mail-Adressen bereitstellen oder eine Benutzergruppe ausw\00E4hlen, an die Ihre E-Mail gesendet wird.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274859502610865415)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_language=>'de'
,p_message_text=>unistr('Muss eine Benutzergruppe ausw\00E4hlen, an die Ihre E-Mail gesendet wird.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274850313938865409)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_language=>'de'
,p_message_text=>unistr('Das Pr\00E4fix der Tabelle darf h\00F6chstens sechs Zeichen umfassen, muss mit einem Buchstaben beginnen und darf nur Buchstaben, Zahlen und Unterstriche enthalten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274850421973865409)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_language=>'de'
,p_message_text=>unistr('Geben Sie ein anderes Tabellenpr\00E4fix ein. Die folgenden Datenbankobjekte sind bereits vorhanden: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274835093347865398)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Das E-Mail-Adressformat f\00FCr den Benutzernamen ist ung\00FCltig. Beachten Sie das f\00FCr die Anwendung geltende Format des Benutzernamens unten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274834944316865398)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_language=>'de'
,p_message_text=>unistr('E-Mail-Format pr\00FCfen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274832538407865396)
,p_name=>'CA.VIEW.AS'
,p_message_language=>'de'
,p_message_text=>'Anzeigen als'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274853911834865411)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_language=>'de'
,p_message_text=>'Blueprint anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274842435070865403)
,p_name=>'CA.VIEW.DETAILS'
,p_message_language=>'de'
,p_message_text=>'Details anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274859887138865415)
,p_name=>'CA.VIEW.EMAIL'
,p_message_language=>'de'
,p_message_text=>'E-Mail anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274844560169865405)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_language=>'de'
,p_message_text=>'Mein Profil anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274829453466865394)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_language=>'de'
,p_message_text=>'Gewichtete Performance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274864486199865419)
,p_name=>'CA.WIDTH'
,p_message_language=>'de'
,p_message_text=>'Breite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274868637537865422)
,p_name=>'CA.WIZARD'
,p_message_language=>'de'
,p_message_text=>'Assistentenseiten erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273735311533864607)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_language=>'de'
,p_message_text=>'Assistentencontainer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274868754609865422)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Erstellen Sie eine Collection von Seiten, die als Assistent verwendet werden sollen. Im Allgemeinen werden Assistenten f\00FCr die Eingabe von Daten in mehreren Schritten eingesetzt.</p>'),
'<p>Geben Sie die folgenden Attribute ein:</p>',
'<ul>',
unistr('  <li><strong>Assistentenname</strong> (Obligatorisch) - Geben Sie einen Namen f\00FCr diese Seite ein.</li>'),
unistr('  <li><strong>Symbol festlegen</strong> - W\00E4hlen Sie ein Symbol aus, das im Navigationsmen\00FC f\00FCr diese Seite angezeigt werden soll.</li>'),
unistr('  <li><strong>Seitenmodus</strong> (Obligatorisch) - Legen Sie fest, ob die Assistentenschritte als modale oder normale Seiten angezeigt werden. W\00E4hlen Sie entweder <strong>Modale Seite</strong> oder <strong>Ganze Seite</strong> aus.</li>'),
unistr('  <li><strong>Schritt 1 ... 8</strong> - Geben Sie den Seitennamen f\00FCr die Schritte des Assistenten ein.<br><em><strong>Hinweis:</strong> Schritte 5 - 8 werden angezeigt, wenn Namen f\00FCr die einzelnen vorherigen Schritte eingegeben werden.</em></li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274832919835865396)
,p_name=>'CA.WORK.PHONE'
,p_message_language=>'de'
,p_message_text=>unistr('Telefon gesch\00E4ftlich')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274825694742865391)
,p_name=>'CA.YELLOW'
,p_message_language=>'de'
,p_message_text=>'Gelb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274046024279864839)
,p_name=>'CA.YES'
,p_message_language=>'de'
,p_message_text=>'Ja'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273580312281864502)
,p_name=>'CACHED'
,p_message_language=>'de'
,p_message_text=>'Gecacht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273464080510864425)
,p_name=>'CACHE_CREATED'
,p_message_language=>'de'
,p_message_text=>'Cache erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273451535227864416)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_language=>'de'
,p_message_text=>unistr('"Daten l\00F6schen"-Funktionalit\00E4t ist deaktiviert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273436094936864406)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_language=>'de'
,p_message_text=>unistr('"Daten hinzuf\00FCgen"-Funktionalit\00E4t ist deaktiviert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273436128321864406)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_language=>'de'
,p_message_text=>unistr('"Daten aktualisieren"-Funktionalit\00E4t ist deaktiviert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273619399473864528)
,p_name=>'CALENDAR.NEXT'
,p_message_language=>'de'
,p_message_text=>'Weiter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273619243550864528)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273476966167864433)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_language=>'de'
,p_message_text=>'Einfacher Kalender'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274640440462865261)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_language=>'de'
,p_message_text=>'Kalendereintrag bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273424641961864398)
,p_name=>'CALENDAR_POPUP'
,p_message_language=>'de'
,p_message_text=>unistr('Kalender-Popup f\00FCr %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273575166693864499)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_language=>'de'
,p_message_text=>'Der Kalender wurde erfolgreich erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273977906409864791)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Vorg\00E4ngerkalender-Template')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273476870924864433)
,p_name=>'CALENDAR_TYPE'
,p_message_language=>'de'
,p_message_text=>'Kalender'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273828448138864673)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'Keine Kalendertemplates bei dem Versuch gefunden, aus Anwendung %0 und Template-ID %1 zu kopieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273979380907864792)
,p_name=>'CANCEL'
,p_message_language=>'de'
,p_message_text=>'Abbrechen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273417743202864393)
,p_name=>'CANDLESTICK'
,p_message_language=>'de'
,p_message_text=>'Kerzendiagramm'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274314094951865032)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_language=>'de'
,p_message_text=>'Kaskadierende Stylesheets'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274035478846864831)
,p_name=>'CENTER'
,p_message_language=>'de'
,p_message_text=>'Zentriert'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274069571355864855)
,p_name=>'CHANGES'
,p_message_language=>'de'
,p_message_text=>unistr('\00C4nderungen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274699623796865302)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_language=>'de'
,p_message_text=>unistr('Authentifizierung \00E4ndern')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273973728576864788)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_language=>'de'
,p_message_text=>unistr('Datenbankgr\00F6\00DFe \00E4ndern')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273591985241864510)
,p_name=>'CHANGE_PW_REQUEST'
,p_message_language=>'de'
,p_message_text=>'%0-Anforderung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273973520980864787)
,p_name=>'CHANGE_REQUEST'
,p_message_language=>'de'
,p_message_text=>unistr('\00C4nderungsanforderung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274261269502864994)
,p_name=>'CHANGE_WORKSPACE'
,p_message_language=>'de'
,p_message_text=>unistr('Workspace \00E4ndern')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273945582334864756)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Spalte f\00FCr Zeichensatz')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273670816297864563)
,p_name=>'CHART'
,p_message_language=>'de'
,p_message_text=>'Diagramm'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273423038508864397)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ung\00FCltige Diagrammabfrage: %0<br><br>'),
'Verwenden Sie folgende Syntax:',
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
unistr('<tr><td>LABEL</td><td>Text f\00FCr den Balken</td></tr>'),
unistr('<tr><td>VALUE</td><td>Numerische Spalte f\00FCr die Definition der Balkengr\00F6\00DFe</td></tr>'),
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273614152124864525)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ung\00FCltige Diagrammabfrage.<br /><br /> Verwenden Sie folgende Syntax: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'),
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
unistr('<td>Numerische Spalte f\00FCr die Definition des Dial-Wertes.</td>'),
'</tr>',
'<tr>',
'<td>MAX</td>',
unistr('<td>Numerische Spalte f\00FCr die Definition des maximalen Dial-Wertes.</td>'),
'</tr>',
'<tr>',
'<td>LOW (optional)</td>',
unistr('<td>Numerische Spalte f\00FCr die Definition des minimalen vorherigen Dial-Wertes.</td>'),
'</tr>',
'<tr>',
'<td>HIGH (optional)</td>',
unistr('<td>Numerische Spalte f\00FCr die Definition des maximalen vorherigen Dial-Wertes.</td>'),
'</tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273689013084864575)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltiger Diagrammtyp.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273422921254864397)
,p_name=>'CHART.INVALID_QUERY'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Parsen von SQL-Abfrage nicht erfolgreich.',
'<p>%0</p>',
unistr('Bestimmte Abfragen k\00F6nnen nur in Ihrer Anwendung ausgef\00FChrt werden. Wenn Ihre Abfrage syntaktisch korrekt ist, k\00F6nnen Sie Ihre Abfrage ohne Validierung speichern. Die entsprechenden Optionen werden unter der Abfragequelle angezeigt.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274754838808865341)
,p_name=>'CHART_DEGREES'
,p_message_language=>'de'
,p_message_text=>'Grad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273922463959864739)
,p_name=>'CHART_PAGE'
,p_message_language=>'de'
,p_message_text=>'%0-Diagramm'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273452388833864417)
,p_name=>'CHART_SERIES'
,p_message_language=>'de'
,p_message_text=>'Diagrammreihe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273970025599864773)
,p_name=>'CHART_SERIES_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler bei Diagrammdatenreihe %0 f\00FCr %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273568361056864494)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_language=>'de'
,p_message_text=>'Das Diagramm wurde erfolgreich erstellt.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273527607988864467)
,p_name=>'CHECK$'
,p_message_language=>'de'
,p_message_text=>'Zeilenselektor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274687385703865294)
,p_name=>'CHECKED'
,p_message_language=>'de'
,p_message_text=>'aktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273926365771864742)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_language=>'de'
,p_message_text=>unistr('Pr\00FCfsumme erforderlich: Anwendungsebene')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273742849994864613)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_language=>'de'
,p_message_text=>unistr('Pr\00FCfsumme erforderlich: Sessionebene')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273742752670864612)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_language=>'de'
,p_message_text=>unistr('Pr\00FCfsumme erforderlich: Benutzerebene')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273742675804864612)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_language=>'de'
,p_message_text=>unistr('Pr\00FCfsumme erforderlich: Anwendungsebene')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274757266729865343)
,p_name=>'CHECK_ALL'
,p_message_language=>'de'
,p_message_text=>unistr('Alle ausw\00E4hlen')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273910390893864731)
,p_name=>'CLASSIC_CALENDAR'
,p_message_language=>'de'
,p_message_text=>'Klassischer Kalender'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273913362682864733)
,p_name=>'CLASSIC_REPORT'
,p_message_language=>'de'
,p_message_text=>'Klassischer Bericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273612623089864524)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Spalten von klassischem Bericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273910915553864731)
,p_name=>'CLASSIC_TREE'
,p_message_language=>'de'
,p_message_text=>'Klassischer Baum'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273909184109864730)
,p_name=>'CLEAN_UP'
,p_message_language=>'de'
,p_message_text=>'Seite bereinigen'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273446589099864413)
,p_name=>'CLEAR_COMMAND'
,p_message_language=>'de'
,p_message_text=>unistr('Befehl l\00F6schen')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273919092442864737)
,p_name=>'CLOSED'
,p_message_language=>'de'
,p_message_text=>'Geschlossen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273966631468864771)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_language=>'de'
,p_message_text=>'In den letzten 7 Tagen geschlossen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273732307690864605)
,p_name=>'CLOSE_WINDOW'
,p_message_language=>'de'
,p_message_text=>unistr('Fenster schlie\00DFen')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274850873215865409)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'de'
,p_message_text=>unistr('Schlie\00DFen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274852536823865410)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'de'
,p_message_text=>'Suchen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274850747438865409)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'de'
,p_message_text=>'Suchen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274852412030865410)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'de'
,p_message_text=>'Weitersuchen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274852309727865410)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'de'
,p_message_text=>'Vorherige suchen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274852180173865410)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'de'
,p_message_text=>unistr('Automatisch vervollst\00E4ndigen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274851437463865409)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'de'
,p_message_text=>unistr('Einzugsgr\00F6\00DFe')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274851639390865410)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'de'
,p_message_text=>unistr('Mit Tabulatortaste Leerzeichen einf\00FCgen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274851003909865409)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'de'
,p_message_text=>unistr('Gro\00DF-/Kleinschreibung beachten')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274850939476865409)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'de'
,p_message_text=>unistr('Regul\00E4rer Ausdruck')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274855939493865413)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_language=>'de'
,p_message_text=>'Query Builder'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274852696437865410)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'de'
,p_message_text=>'Wiederholen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274852295230865410)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'de'
,p_message_text=>'Ersetzen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274850569982865409)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'de'
,p_message_text=>'Alle ersetzen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274850658699865409)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'de'
,p_message_text=>'Ersetzen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274852925010865410)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCberspringen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274851988275865410)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Einstellungen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274851256065865409)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'de'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274851784444865410)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'de'
,p_message_text=>'Zeilennummern anzeigen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274851111036865409)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'de'
,p_message_text=>'Schieberegler anzeigen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274851585180865410)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'de'
,p_message_text=>'Tabulatorweite'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274851310503865409)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'de'
,p_message_text=>'Themes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274852725185865410)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'de'
,p_message_text=>unistr('R\00FCckg\00E4ngig')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274851891309865410)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'de'
,p_message_text=>'Texteditor verwenden'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274852078729865410)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'de'
,p_message_text=>'Validieren'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274852825967865410)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'de'
,p_message_text=>'Validierung erfolgreich'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273849216730864688)
,p_name=>'COLLAPSE'
,p_message_language=>'de'
,p_message_text=>'Ausblenden'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273459899040864422)
,p_name=>'COLOR_PALETTE'
,p_message_language=>'de'
,p_message_text=>'Farbpalette'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273685611526864573)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_language=>'de'
,p_message_text=>'Analog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273685280465864572)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_language=>'de'
,p_message_text=>unistr('Komplement\00E4r')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273685869815864573)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_language=>'de'
,p_message_text=>unistr('Komplement\00E4rfarben')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273685795833864573)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_language=>'de'
,p_message_text=>'Monochromatisch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273685383925864572)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_language=>'de'
,p_message_text=>unistr('Teil-komplement\00E4r')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273685593243864572)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_language=>'de'
,p_message_text=>'Tetrade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273685412432864572)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_language=>'de'
,p_message_text=>'Triade'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274306143445865026)
,p_name=>'COLUMN'
,p_message_language=>'de'
,p_message_text=>'Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274742215417865332)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_language=>'de'
,p_message_text=>'Anzeigename: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273841570921864683)
,p_name=>'COLUMN_NAME'
,p_message_language=>'de'
,p_message_text=>'Spaltenname'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274047274581864839)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_language=>'de'
,p_message_text=>unistr('Alle authentifizierten Benutzer k\00F6nnen auf diese Anwendung zugreifen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274047362385864840)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_language=>'de'
,p_message_text=>unistr('Nur in der Access-Control-Liste definierte Benutzer k\00F6nnen auf diese Anwendung zugreifen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274047436326864840)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_language=>'de'
,p_message_text=>'Unerwarteter Zugriffskontroll-Einstellungswert: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273453259059864417)
,p_name=>'COMING_SOON'
,p_message_language=>'de'
,p_message_text=>unistr('In K\00FCrze verf\00FCgbar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273842035266864683)
,p_name=>'COMMENT'
,p_message_language=>'de'
,p_message_text=>'Kommentar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273979581661864792)
,p_name=>'COMMENTS'
,p_message_language=>'de'
,p_message_text=>'Kommentare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273733530211864606)
,p_name=>'COMPILE_FAILURE'
,p_message_language=>'de'
,p_message_text=>'Kompilierung nicht erfolgreich. Zeile <a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274063546158864851)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_language=>'de'
,p_message_text=>'Kompilierung nicht erfolgreich. Zeile %0 (%2) Zeilennummern bei Kompilierungsfehlern beziehen sich auf die erste BEGIN-Anweisung. Dies betrifft nur die Kompilierung von Datenbanktriggern.<br />%1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273733470503864606)
,p_name=>'COMPILE_SUCCESS'
,p_message_language=>'de'
,p_message_text=>'PL/SQL-Code erfolgreich kompiliert (%0)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273916374814864735)
,p_name=>'COMPLETE'
,p_message_language=>'de'
,p_message_text=>'Abgeschlossen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273923703013864740)
,p_name=>'COMPLETED'
,p_message_language=>'de'
,p_message_text=>'Abgeschlossen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273930711881864745)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_language=>'de'
,p_message_text=>unistr('Abgeschlossen/Keine Vorg\00E4nge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273967212729864771)
,p_name=>'COMPONENT'
,p_message_language=>'de'
,p_message_text=>'Komponente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274124047670864894)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_language=>'de'
,p_message_text=>'Komponentenname: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274395376945865089)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_language=>'de'
,p_message_text=>'Komponente nicht aktiviert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273571871928864497)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_language=>'de'
,p_message_text=>'Die Komponente wurde erfolgreich erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274737510421865329)
,p_name=>'COMPONENT_SUMMARY'
,p_message_language=>'de'
,p_message_text=>'Komponentenzusammenfassung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273515022447864459)
,p_name=>'COMPUTATIONS'
,p_message_language=>'de'
,p_message_text=>'Berechnungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273990721154864800)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_language=>'de'
,p_message_text=>'Anwendungskomponenten erfolgreich installiert.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273734189281864607)
,p_name=>'CONDITIONAL'
,p_message_language=>'de'
,p_message_text=>'Bedingt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273824005307864670)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_language=>'de'
,p_message_text=>'Popup-Werteliste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273907812370864729)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_language=>'de'
,p_message_text=>'immer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273643833890864544)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'vorhanden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273643343774864544)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_language=>'de'
,p_message_text=>'Element/Spalte=Wert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273643496554864544)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_language=>'de'
,p_message_text=>'Element/Spalte nicht null'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274609458018865239)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_language=>'de'
,p_message_text=>'Element/Spalte null'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273643940365864545)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_language=>'de'
,p_message_text=>'Nie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273644011419864545)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_language=>'de'
,p_message_text=>'Kein Eintrag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273643654365864544)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_language=>'de'
,p_message_text=>'Seite in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273643784267864544)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_language=>'de'
,p_message_text=>'Seite nicht in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273643227194864544)
,p_name=>'CONDITIONS_SHORTCUT_PLSQL'
,p_message_language=>'de'
,p_message_text=>'PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273643587522864544)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_language=>'de'
,p_message_text=>'Anforderung=e1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273655121930864552)
,p_name=>'CONDITION_TYPE'
,p_message_language=>'de'
,p_message_text=>'Bedingungstyp'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273869285128864702)
,p_name=>'CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('Best\00E4tigen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273419574291864394)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_language=>'de'
,p_message_text=>'Master-Detail (2 Seiten)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273419462716864394)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_language=>'de'
,p_message_text=>'Master-Detail (3 Seiten)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273629815703864535)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Tats\00E4chlicher Name')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273915520223864735)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_language=>'de'
,p_message_text=>'Aggregieren pro Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273915664509864735)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_language=>'de'
,p_message_text=>'Zu verwendende Aggregatfunktionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273627251907864534)
,p_name=>'CONFIRM.APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273640655046864542)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_language=>'de'
,p_message_text=>'Aliasname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273640733901864542)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_language=>'de'
,p_message_text=>'Standardsprache'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273640590949864542)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_language=>'de'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273521714502864463)
,p_name=>'CONFIRM.ARRAY'
,p_message_language=>'de'
,p_message_text=>unistr('Ergebnisbaum f\00FCr Bericht')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273521873125864463)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_language=>'de'
,p_message_text=>unistr('Ergebnisparameter f\00FCr Bericht')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273640867211864542)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_language=>'de'
,p_message_text=>'Authentifizierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274107230945864882)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_language=>'de'
,p_message_text=>'Verzweigung zu Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273831460799864676)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Gruppenwechselspalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273629673993864535)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_language=>'de'
,p_message_text=>unistr('%0-Schaltfl\00E4chenverzweigung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273629565913864535)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Anzeigetext f\00FCr die Schaltfl\00E4che "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273433208035864404)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzuf\00FCgen von Daten aktivieren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273433157062864404)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_language=>'de'
,p_message_text=>'Drag-and-Drop aktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274049644760864841)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_language=>'de'
,p_message_text=>'Verzweigung abbrechen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274107089742864882)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Label f\00FCr die Schaltfl\00E4che "Abbrechen"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274097506127864875)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_language=>'de'
,p_message_text=>unistr('Gro\00DF-/Kleinschreibung beachten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273731867754864605)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die \00C4nderung der Abfrage f\00FCr den interaktiven Bericht angefordert. Wenn Sie Spalten aus der Abfrage entfernt haben, werden vorhandene Filter, Markierungsregeln und andere Berichtseinstellungen f\00FCr diese Spalten deaktiviert. Best\00E4tigen Sie I')
||'hre Anforderung.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273630714093864536)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_language=>'de'
,p_message_text=>'Diagrammachse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273979815710864792)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_language=>'de'
,p_message_text=>'Dial'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273979997861864792)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_language=>'de'
,p_message_text=>'Dial (Sweep)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273631457767864536)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_language=>'de'
,p_message_text=>'Horizontaler Balken'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273631661544864536)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_language=>'de'
,p_message_text=>'Zeile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273630976103864536)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_language=>'de'
,p_message_text=>'Zahlenmaske'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273631559154864536)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_language=>'de'
,p_message_text=>'Kreis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273630678754864536)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_language=>'de'
,p_message_text=>'Diagrammabfrage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273630845479864536)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_language=>'de'
,p_message_text=>'Nachkommastellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273631702446864536)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_language=>'de'
,p_message_text=>'Streudiagramm'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273631233929864536)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_language=>'de'
,p_message_text=>unistr('Diagrammgr\00F6\00DFe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273631170684864536)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_language=>'de'
,p_message_text=>unistr('Diagramm\00FCberschrift')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273631082208864536)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_language=>'de'
,p_message_text=>'Diagrammtyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273631306669864536)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_language=>'de'
,p_message_text=>'Vertikaler Balken'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273521966136864463)
,p_name=>'CONFIRM.COLLECTION'
,p_message_language=>'de'
,p_message_text=>unistr('Name f\00FCr die tempor\00E4re Ergebnismenge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273628049451864534)
,p_name=>'CONFIRM.COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273831241965864675)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_language=>'de'
,p_message_text=>unistr('Spalten\00FCberschriften')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274007128460864811)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_language=>'de'
,p_message_text=>'Spaltenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274049833089864841)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_language=>'de'
,p_message_text=>'Spaltenname(n)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273640382211864542)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_language=>'de'
,p_message_text=>unistr('Sortierung nach Spalten\00FCberschriften')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273747000191864615)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Kopieren einer Anwendung mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273638963823864541)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Kopieren einer Seite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273628523465864534)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_language=>'de'
,p_message_text=>'Eine neue Registerkartengruppe "%0" wird erstellt und von dieser Seite verwendet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273640434340864542)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Anwendung mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273633012590864537)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Kalenderseite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273636224619864539)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Seite f\00FCr einen Aufgliederungsbericht mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273695970309864580)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Erstellung einer Seite f\00FCr einen interaktiven Bericht angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273639283136864541)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Berichtsseite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273426811188864399)
,p_name=>'CONFIRM.CREATE_FLASH_CHART'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Flash-Diagrammseite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274713171524865312)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben angefordert, dass eine Datenbankanwendung mit derselben ID wie eine vorhandene Datenbankanwendung im aktuellen Workspace erstellt wird. Die vorhandene Datenbankanwendung wird gel\00F6scht und dann durch die neue Datenbankanwendung ersetzt. Best')
||unistr('\00E4tigen Sie die Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274003903081864809)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen von Form- und Listenansichtsseiten mit folgenden Attributen angefordert. Best\00E4tigen Sie die Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273915217781864734)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Form und einer Berichtsseite mit Analyseseiten angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273632606890864537)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen eines Formulars basierend auf einer SQL-Abfrage mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273632541781864537)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen eines Formulars basierend auf einer gespeicherten Prozedur mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273632489334864537)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen eines Formulars basierend auf einer Tabellenseite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273477946493864434)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen eines Formulars basierend auf einer Webservicereferenz-Seite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273534717883864472)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Form und eines Berichts \00FCber eine Webservicereferenz-Seite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273944542550864755)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Kartenseite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273416958723864393)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen von Master-Detailseiten mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273634237842864538)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Navigationspfadregion und Navigationspfadoption mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273922500254864740)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_language=>'de'
,p_message_text=>'Modus erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273632244700864537)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Seite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274788631591865365)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_language=>'de'
,p_message_text=>'Seite erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274788781144865365)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_language=>'de'
,p_message_text=>'Seitenname erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273635020190864539)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen von Form- und Berichtseiten mit folgenden Attributen angefordert. Best\00E4tigen Sie Ihre Wahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274709086464865309)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Seite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273639067891864541)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Berichtsseite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273632728855864537)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer HTML-Balkendiagrammseite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273638644675864541)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Zusammenfassungsseite mit folgenden Attributen angefordert. Klicken Sie auf <b>Weitere hinzuf\00FCgen</b>, um zus\00E4tzliche Elemente von anderen Seiten und/oder Regionen hinzuzuf\00FCgen. Klicken Sie auf <b>Beenden</b>, um die Zus')
||'ammenfassungselemente zu erstellen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273632802882864537)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer SVG-Diagrammseite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273632139496864537)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer tabellarischen Formularseite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273633386893864537)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen einer Baumseite mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273632398736864537)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben das Erstellen eines Assistenten mit folgenden Attributen angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274712733000865311)
,p_name=>'CONFIRM.CREATE_WS_APP_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben angefordert, dass eine Websheet-Anwendung mit derselben ID wie eine vorhandene Websheet-Anwendung im aktuellen Workspace erstellt wird. Die vorhandene Websheet-Anwendung wird gel\00F6scht und dann durch die neue Websheet-Anwendung ersetzt. Best')
||unistr('\00E4tigen Sie die Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273827079090864672)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_language=>'de'
,p_message_text=>'Link-Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274645745808865264)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_language=>'de'
,p_message_text=>'Datenladedefinitionsname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274720334330865317)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Diese Datenladedefinition wird mit den vorhandenen Tabellen-Lookups und Transformationsregeln neu erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274097627235864875)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_language=>'de'
,p_message_text=>'Seitennummer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273633135943864537)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Datumsspalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273922686782864740)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_language=>'de'
,p_message_text=>'Standard-Authentifizierungsschema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273632043564864537)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273636918978864540)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_language=>'de'
,p_message_text=>'%0-Anzeigespalten - Detail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273419927121864395)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Detail-Anzeigespalte(n)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273638511526864541)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_language=>'de'
,p_message_text=>'Detail-Navigationspfadspalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273637763208864540)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_language=>'de'
,p_message_text=>'Detail-Tabelle %0 anordnen nach'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273636400090864540)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_language=>'de'
,p_message_text=>'Detailseite %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273419808407864395)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_language=>'de'
,p_message_text=>'Detail-Tabelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273636770437864540)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_language=>'de'
,p_message_text=>'Der Name der Detail-Tabelle %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273636517659864540)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Label f\00FCr Detailregisterkarte %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274050135185864842)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Uploadspalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273630175481864535)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Spalten anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274006856553864811)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_language=>'de'
,p_message_text=>'Uploadspalte 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274006974557864811)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_language=>'de'
,p_message_text=>'Uploadspalte 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273634420397864538)
,p_name=>'CONFIRM.DISPLAY_POINT'
,p_message_language=>'de'
,p_message_text=>'Anzeigepunkt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274797550333865371)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274797657559865372)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_language=>'de'
,p_message_text=>'Seitenname bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273819963354864667)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_language=>'de'
,p_message_text=>'CSV-Ausgabe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273820617290864668)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_language=>'de'
,p_message_text=>'Druckausgabe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273821251358864668)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_language=>'de'
,p_message_text=>unistr('Sortieren der Spalten\00FCberschriften aktivieren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273871150221864704)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Der vorhandenen Administrationsseite wird eine Region hinzugef\00FCgt:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274049706200864841)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_language=>'de'
,p_message_text=>'Verzweigung beenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273635532628864539)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_language=>'de'
,p_message_text=>'Formularseite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273635687502864539)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_language=>'de'
,p_message_text=>'Form-Seitenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273635825828864539)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_language=>'de'
,p_message_text=>'Formularseiten-Registerkartenlabel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273635718983864539)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_language=>'de'
,p_message_text=>'Formularseiten-Registerkartengruppe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273922772123864740)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_language=>'de'
,p_message_text=>'Gemeinsame Komponenten importieren aus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274380234133865078)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzerdefinierten Kalender einf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273420180159864395)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_language=>'de'
,p_message_text=>'Master-Bericht einbeziehen?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273638209613864541)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_language=>'de'
,p_message_text=>'Navigationspfad einbeziehen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273629328317864535)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Informations-Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273629476525864535)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_language=>'de'
,p_message_text=>'Informations-Standardtext'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273478136230864434)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Form-Elemente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273522166348864463)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Form-Regionstemplate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273522026055864463)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_language=>'de'
,p_message_text=>unistr('Formularregions\00FCberschrift:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273631844736864537)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_language=>'de'
,p_message_text=>unistr('Einf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273629140115864535)
,p_name=>'CONFIRM.ITEMS'
,p_message_language=>'de'
,p_message_text=>'Elemente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274050015292864842)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('R\00FCckgabespalte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274048968442864841)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_language=>'de'
,p_message_text=>unistr('Lookup-Schl\00FCsselspalte 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274049018634864841)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_language=>'de'
,p_message_text=>unistr('Schl\00FCsselspalte 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274049145277864841)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_language=>'de'
,p_message_text=>unistr('Schl\00FCsselspalte 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273633256197864537)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Labelspalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274007030790864811)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Lookup-Eigent\00FCmer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274049970967864841)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_language=>'de'
,p_message_text=>'Lookup-Tabelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273420216880864395)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_language=>'de'
,p_message_text=>'Master-Detail-Layout'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273419706432864395)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Master-Anzeigespalte(n)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273420048147864395)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_language=>'de'
,p_message_text=>'Master-Datensatz navigieren nach'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273419624739864395)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_language=>'de'
,p_message_text=>'Mastertabelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273831374871864676)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Maximale Anzahl von Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273826841238864672)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_language=>'de'
,p_message_text=>'Zeilen pro Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273704632507864586)
,p_name=>'CONFIRM.MENU'
,p_message_language=>'de'
,p_message_text=>'Navigationspfad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273634784843864538)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_language=>'de'
,p_message_text=>'Navigationspfad-Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273638380686864541)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_language=>'de'
,p_message_text=>'Navigationspfad-Root'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273634586953864538)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Template f\00FCr Navigationspfad')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273634825318864538)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_language=>'de'
,p_message_text=>'Navigationspfadtext'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273552462327864483)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben ein Upgrade des Flash-Diagramms auf ein neues Flash 6-Diagramm angefordert. Best\00E4tigen Sie die Anforderung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273916429644864735)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6_XML'
,p_message_language=>'de'
,p_message_text=>'Sie haben ein Upgrade eines Flash-Diagramms auf ein neues Flash 6-Diagramm auf Grundlage von benutzerdefinierter XML angefordert. Aufgrund der unterschiedlichen XML-Strukturen zwischen dem aktuellen und dem Flash 6-Diagramm wird das upgegradete Diagr'
||unistr('amm nicht angezeigt. Sie m\00FCssen die benutzerdefinierte XML des upgegradeten Diagramms \00E4ndern, um die neue XML-Struktur zu verwenden. Best\00E4tigen Sie die Anforderung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273490716400864443)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben ein Upgrade des Flash-Diagramms auf ein neues HTML5-Diagramm angefordert. Best\00E4tigen Sie die Anforderung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273490898715864443)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5_XML'
,p_message_language=>'de'
,p_message_text=>'Sie haben ein Upgrade eines Flash-Diagramms auf ein neues HTML5-Diagramm auf Grundlage von benutzerdefinierter XML angefordert. Aufgrund der unterschiedlichen XML-Strukturen zwischen dem aktuellen und dem HTML5-Diagramm wird das upgegradete Diagramm '
||unistr('nicht angezeigt. Sie m\00FCssen die benutzerdefinierte XML des upgegradeten Diagramms \00E4ndern, um die neue XML-Struktur zu verwenden. Best\00E4tigen Sie die Anforderung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273490653427864442)
,p_name=>'CONFIRM.MIGRATE_HTML_TO_HTML5'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben ein Upgrade des HTML-Diagramms auf ein neues HTML5-Diagramm angefordert. Best\00E4tigen Sie die Anforderung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274733558785865326)
,p_name=>'CONFIRM.MIGRATE_JSTREE_TO_APEXTREE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben ein Upgrade von jsTree auf eine neue Baumstruktur angefordert. Best\00E4tigen Sie die Anforderung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273618550607864528)
,p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Das Upgrade des SVG-Diagramm erfolgt mit folgenden Einschr\00E4nkungen:  '),
'<ul>',
'<li>',
'Es werden nur Zahlenformate migriert, die in Achsenformat-Zeichenfolgen definiert sind. Datums- und Zeitformate werden ignoriert.',
'</li>',
'<li>',
'Es werden Zahlenformatelemente migriert, die Folgendes enthalten:',
'<br />',
'0,9,D,G,, (Komma),. (Punkt),$,C,L,FM',
'</li>',
'<li>',
unistr('Das Label f\00FCr die Datenreihe im Flash-Diagramm wird vom Spaltenaliasnamen der Datenreihe abgeleitet.  '),
'Bei SVG-Diagrammen wird hingegen das Label der jeweiligen Datenreihe vom Namensattribut der Datenreihe abgeleitet.',
'</li>',
'<li>',
unistr('In Flash Dial-Diagrammen werden anstelle von Prozents\00E4tzen die tats\00E4chlichen Werte angezeigt.'),
'</li>',
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273573639218864498)
,p_name=>'CONFIRM.MIGRATE_SVG_TO_HTML5'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben ein Upgrade des SVG-Diagramms auf ein HTML5-Diagramm angefordert. Best\00E4tigen Sie die Anforderung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274708815220865309)
,p_name=>'CONFIRM.NAVIGATION'
,p_message_language=>'de'
,p_message_text=>'Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273641101544864543)
,p_name=>'CONFIRM.NAV_BAR'
,p_message_language=>'de'
,p_message_text=>'Navigationsleiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274359043093865063)
,p_name=>'CONFIRM.NAV_LIST'
,p_message_language=>'de'
,p_message_text=>unistr('Navigationsmen\00FCliste')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273934314904864748)
,p_name=>'CONFIRM.NEW_ADMIN_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Eine neue Administrationsseite wird hinzugef\00FCgt. Seite:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273732016736864605)
,p_name=>'CONFIRM.NEW_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Neue Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273629942419864535)
,p_name=>'CONFIRM.NEW_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Neues Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274106863511864882)
,p_name=>'CONFIRM.NEXT_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Beschriftung der Schaltfl\00E4che "Weiter"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273628496131864534)
,p_name=>'CONFIRM.NO.TABSET.SELECTED'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr diese Seite wurde keine Registerkartengruppe ausgew\00E4hlt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273629061200864535)
,p_name=>'CONFIRM.NO_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Kein Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273478291511864434)
,p_name=>'CONFIRM.OUTPUT_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Ausgabeelemente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273630341802864536)
,p_name=>'CONFIRM.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Eigent\00FCmer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273627335073864534)
,p_name=>'CONFIRM.PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273640983333864542)
,p_name=>'CONFIRM.PAGES'
,p_message_language=>'de'
,p_message_text=>'Seiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273627465176864534)
,p_name=>'CONFIRM.PAGE_NAME'
,p_message_language=>'de'
,p_message_text=>'Seitenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273628378200864534)
,p_name=>'CONFIRM.PAGE_TITLE'
,p_message_language=>'de'
,p_message_text=>unistr('Seiten\00FCberschrift')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273636810493864540)
,p_name=>'CONFIRM.PARENT_DISPLAY_COLS'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCbergeordnete Anzeigespalten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273634907443864539)
,p_name=>'CONFIRM.PARENT_MENU'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCbergeordneter Navigationspfad')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273638405184864541)
,p_name=>'CONFIRM.PARENT_MENU_COL'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCbergeordnete Navigationspfadspalte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273637044312864540)
,p_name=>'CONFIRM.PARENT_ORDER_BY'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCbergeordnete Tabelle anordnen nach')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273636364965864539)
,p_name=>'CONFIRM.PARENT_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCbergeordnete Seite')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273636671708864540)
,p_name=>'CONFIRM.PARENT_TABLE_NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Der Name der \00FCbergeordneten Tabelle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273628923095864535)
,p_name=>'CONFIRM.PARENT_TAB_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Label f\00FCr \00FCbergeordnete Registerkarte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273628843048864535)
,p_name=>'CONFIRM.PARENT_TAB_SET'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCbergeordnete Registerkartengruppe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273731702222864605)
,p_name=>'CONFIRM.PARSING_SCHEMA'
,p_message_language=>'de'
,p_message_text=>'Parsingschema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273740760158864611)
,p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR'
,p_message_language=>'de'
,p_message_text=>'Aktualisierung von Seitenbestandteilen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274106938186864882)
,p_name=>'CONFIRM.PREVIOUS_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Beschriftung der Schaltfl\00E4che "Zur\00FCck"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273628269800864534)
,p_name=>'CONFIRM.PRIMARY_KEY'
,p_message_language=>'de'
,p_message_text=>unistr('Prim\00E4rschl\00FCsselspalte %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273635907282864539)
,p_name=>'CONFIRM.PRIMARY_KEY_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Prim\00E4rschl\00FCsselspalte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273827135015864673)
,p_name=>'CONFIRM.PRINT_FORMAT'
,p_message_language=>'de'
,p_message_text=>'Ausgabeformat'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273831500292864676)
,p_name=>'CONFIRM.PRINT_LABEL'
,p_message_language=>'de'
,p_message_text=>'Link-Label drucken'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273827238969864673)
,p_name=>'CONFIRM.PRINT_OUTPUT'
,p_message_language=>'de'
,p_message_text=>'Bericht drucken'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273630234217864535)
,p_name=>'CONFIRM.PROCESS_OPTIONS'
,p_message_language=>'de'
,p_message_text=>'Prozessoptionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273826902564864672)
,p_name=>'CONFIRM.REGION_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Regionsspalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273629280645864535)
,p_name=>'CONFIRM.REGION_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Regionstemplate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273627509447864534)
,p_name=>'CONFIRM.REGION_TITLE'
,p_message_language=>'de'
,p_message_text=>unistr('Regions\00FCberschrift')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273634347498864538)
,p_name=>'CONFIRM.REGION_TYPE'
,p_message_language=>'de'
,p_message_text=>'Regionstyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273731975172864605)
,p_name=>'CONFIRM.REMOVED_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Entfernte Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273636099485864539)
,p_name=>'CONFIRM.REPORT_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Berichtsspalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273849362917864688)
,p_name=>'CONFIRM.REPORT_IMPLEMENTATION'
,p_message_language=>'de'
,p_message_text=>'Berichtimplementierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273635140711864539)
,p_name=>'CONFIRM.REPORT_PAGE'
,p_message_language=>'de'
,p_message_text=>'Berichtsseite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273635253563864539)
,p_name=>'CONFIRM.REPORT_PAGE_NAME'
,p_message_language=>'de'
,p_message_text=>'Berichtsseitenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273635481355864539)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL'
,p_message_language=>'de'
,p_message_text=>'Berichtsseiten-Registerkartenlabel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273635399468864539)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_SET'
,p_message_language=>'de'
,p_message_text=>'Berichtsseiten-Registerkartengruppe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273522322102864463)
,p_name=>'CONFIRM.REPORT_REGION_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Berichtsregions-Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273522287009864463)
,p_name=>'CONFIRM.REPORT_REGION_TITLE'
,p_message_language=>'de'
,p_message_text=>unistr('Berichts-Regions\00FCberschrift')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273639382559864541)
,p_name=>'CONFIRM.REPORT_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Berichtstemplate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273524839711864465)
,p_name=>'CONFIRM.ROW_VERSION_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Zeilenversionsspalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273639591152864542)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME1'
,p_message_language=>'de'
,p_message_text=>'Standard: HTML (Standard)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273639826229864542)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME11'
,p_message_language=>'de'
,p_message_text=>'Standard: Darstellung 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273639927018864542)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME12'
,p_message_language=>'de'
,p_message_text=>'Standard: Darstellung 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273731534526864605)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME13'
,p_message_language=>'de'
,p_message_text=>'Standard: Darstellung 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273731658544864605)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME14'
,p_message_language=>'de'
,p_message_text=>'Standard: Darstellung 4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273522857917864464)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME15'
,p_message_language=>'de'
,p_message_text=>'Standard: Darstellung 5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273639680612864542)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME2'
,p_message_language=>'de'
,p_message_text=>'Standard: Vertikaler Bericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273640006468864542)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME21'
,p_message_language=>'de'
,p_message_text=>'Exportieren: CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273640197828864542)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME22'
,p_message_language=>'de'
,p_message_text=>'Exportieren: XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273639794424864542)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME3'
,p_message_language=>'de'
,p_message_text=>'Standard: vertikaler Bericht, Darstellung 1 (Null-Spalten einbeziehen)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273731325505864605)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME4'
,p_message_language=>'de'
,p_message_text=>unistr('Standard: vertikaler Bericht, Darstellung 2 (Null-Spalten ausschlie\00DFen)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273731497748864605)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME5'
,p_message_language=>'de'
,p_message_text=>'Standard: vertikaler Bericht, Darstellung 2 (Null-Spalten einbeziehen)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274050228100864842)
,p_name=>'CONFIRM.RULE_NAME'
,p_message_language=>'de'
,p_message_text=>'Regelname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274050484184864842)
,p_name=>'CONFIRM.RULE_SEQUENCE'
,p_message_language=>'de'
,p_message_text=>'Sequenz'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274050540951864842)
,p_name=>'CONFIRM.RULE_TYPE'
,p_message_language=>'de'
,p_message_text=>'Regeltyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273452007396864416)
,p_name=>'CONFIRM.RUN_SCRIPT'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ausf\00FChrung des folgenden Skripts angefordert. Bitte best\00E4tigen Sie Ihre Auswahl.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273634634522864538)
,p_name=>'CONFIRM.SEQUENCE'
,p_message_language=>'de'
,p_message_text=>'Sequenz'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273639469734864542)
,p_name=>'CONFIRM.SORT_OPTION'
,p_message_language=>'de'
,p_message_text=>'Sortieroption'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273630598648864536)
,p_name=>'CONFIRM.SQL_QUERY'
,p_message_language=>'de'
,p_message_text=>'SQL-Abfrage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273740667862864611)
,p_name=>'CONFIRM.STANDARD_CALENDAR'
,p_message_language=>'de'
,p_message_text=>'Standard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273868851231864702)
,p_name=>'CONFIRM.STARTING_PAGE'
,p_message_language=>'de'
,p_message_text=>'Mehrere Seiten werden erstellt, beginnend mit Seite:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273630497467864536)
,p_name=>'CONFIRM.STORED_PROCEDURE_NAME'
,p_message_language=>'de'
,p_message_text=>'Name der gespeicherten Prozedur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273733377336864606)
,p_name=>'CONFIRM.STORED_PROCEDURE_OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Eigent\00FCmer der gespeicherten Prozedur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274107100077864882)
,p_name=>'CONFIRM.SUBMIT_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Label f\00FCr die Schaltfl\00E4che "Fertigstellen"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274724317356865320)
,p_name=>'CONFIRM.SUBSCRIBE_THEME'
,p_message_language=>'de'
,p_message_text=>'Theme abonnieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273629752638864535)
,p_name=>'CONFIRM.SUGGESTED_NAME'
,p_message_language=>'de'
,p_message_text=>'Vorgeschlagener Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273915342724864734)
,p_name=>'CONFIRM.TABLE'
,p_message_language=>'de'
,p_message_text=>'Tabelle/View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273915466801864735)
,p_name=>'CONFIRM.TABLE_COLS'
,p_message_language=>'de'
,p_message_text=>'Zusammenfassen pro Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274134332896864901)
,p_name=>'CONFIRM.TABLE_LOOKUPS'
,p_message_language=>'de'
,p_message_text=>'Tabellen-Lookups'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273627953341864534)
,p_name=>'CONFIRM.TABLE_NAME'
,p_message_language=>'de'
,p_message_text=>'Tabellenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273627827823864534)
,p_name=>'CONFIRM.TABLE_OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Tabelleneigent\00FCmer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274306473840865026)
,p_name=>'CONFIRM.TABLE_RULE'
,p_message_language=>'de'
,p_message_text=>'Transformationsregel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274050637649864842)
,p_name=>'CONFIRM.TABLE_RULES'
,p_message_language=>'de'
,p_message_text=>'Transformationsregeln'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273732281420864605)
,p_name=>'CONFIRM.TABLE_VIEW_NAME'
,p_message_language=>'de'
,p_message_text=>'Tabellen-/View-Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273732119480864605)
,p_name=>'CONFIRM.TABLE_VIEW_OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Tabellen-/View-Eigent\00FCmer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273641075177864543)
,p_name=>'CONFIRM.TABS'
,p_message_language=>'de'
,p_message_text=>'Registerkarten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273628708466864535)
,p_name=>'CONFIRM.TABSET.INCOMPLETE'
,p_message_language=>'de'
,p_message_text=>unistr('Warnung. Informationen zur Registerkartengruppe sind unvollst\00E4ndig.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273627747379864534)
,p_name=>'CONFIRM.TAB_LABEL'
,p_message_language=>'de'
,p_message_text=>'Registerkartenlabel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273639132877864541)
,p_name=>'CONFIRM.TAB_NAME'
,p_message_language=>'de'
,p_message_text=>'Registerkartenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273627616202864534)
,p_name=>'CONFIRM.TAB_SET'
,p_message_language=>'de'
,p_message_text=>'Registerkartengruppe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273640219734864542)
,p_name=>'CONFIRM.TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Template:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273633990667864538)
,p_name=>'CONFIRM.TREE_LOV'
,p_message_language=>'de'
,p_message_text=>'Basiert auf neuem Element mit Popup-Werteliste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273633636227864538)
,p_name=>'CONFIRM.TREE_MAX_LEVEL'
,p_message_language=>'de'
,p_message_text=>'Maximale Ebenen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273633483961864538)
,p_name=>'CONFIRM.TREE_NAME'
,p_message_language=>'de'
,p_message_text=>'Baumname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273633852344864538)
,p_name=>'CONFIRM.TREE_QUERY'
,p_message_language=>'de'
,p_message_text=>'Baumabfrage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273634005030864538)
,p_name=>'CONFIRM.TREE_SQL'
,p_message_language=>'de'
,p_message_text=>'Auf einer SQL-Abfrage basierend'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273633791037864538)
,p_name=>'CONFIRM.TREE_START'
,p_message_language=>'de'
,p_message_text=>'Ausgangsbaum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273634165436864538)
,p_name=>'CONFIRM.TREE_STATIC'
,p_message_language=>'de'
,p_message_text=>'Statischer Wert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273633599845864538)
,p_name=>'CONFIRM.TREE_TYPE'
,p_message_language=>'de'
,p_message_text=>'Baumtyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273641261820864543)
,p_name=>'CONFIRM.UI_THEME'
,p_message_language=>'de'
,p_message_text=>'Theme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273641340371864543)
,p_name=>'CONFIRM.UI_THEME1'
,p_message_language=>'de'
,p_message_text=>'Blau und Gelbbraun'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273641497522864543)
,p_name=>'CONFIRM.UI_THEME2'
,p_message_language=>'de'
,p_message_text=>'Rot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273641547792864543)
,p_name=>'CONFIRM.UI_THEME4'
,p_message_language=>'de'
,p_message_text=>'Marineblau und Grau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273641633382864543)
,p_name=>'CONFIRM.UI_THEME5'
,p_message_language=>'de'
,p_message_text=>unistr('Olivgr\00FCn')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273641720162864543)
,p_name=>'CONFIRM.UI_THEME6'
,p_message_language=>'de'
,p_message_text=>'Kastanienbraun'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273641895784864543)
,p_name=>'CONFIRM.UI_THEME7'
,p_message_language=>'de'
,p_message_text=>'Einfaches Blau und Gelbbraun'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273641921610864543)
,p_name=>'CONFIRM.UI_THEME8'
,p_message_language=>'de'
,p_message_text=>'Blau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273642044686864543)
,p_name=>'CONFIRM.UI_THEME_NONE'
,p_message_language=>'de'
,p_message_text=>'Keine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273628123028864534)
,p_name=>'CONFIRM.UPDATEABLE_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Aktualisierbare Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273631916855864537)
,p_name=>'CONFIRM.UPDATE_PROCESS'
,p_message_language=>'de'
,p_message_text=>'Aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273628681652864534)
,p_name=>'CONFIRM.USE.EXISTING.TABSET'
,p_message_language=>'de'
,p_message_text=>'Diese Seite verwendet die vorhandene Registerkartengruppe "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273478052737864434)
,p_name=>'CONFIRM.WEB_SERVICE_REF'
,p_message_language=>'de'
,p_message_text=>'Webservicereferenz, Vorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273636127941864539)
,p_name=>'CONFIRM.WHERE_CLAUSE'
,p_message_language=>'de'
,p_message_text=>'WHERE-Klausel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273904730044864727)
,p_name=>'CONFIRMATION_ICON'
,p_message_language=>'de'
,p_message_text=>unistr('Symbol f\00FCr die Best\00E4tigung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273916866886864736)
,p_name=>'CONFIRMED'
,p_message_language=>'de'
,p_message_text=>unistr('Best\00E4tigt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273917123767864736)
,p_name=>'CONFIRMED_BY_QA'
,p_message_language=>'de'
,p_message_text=>unistr('Von QA best\00E4tigt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273827409556864673)
,p_name=>'CONFIRM_BREAK_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Gruppenwechselspalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273827359853864673)
,p_name=>'CONFIRM_PRINT_FORMAT'
,p_message_language=>'de'
,p_message_text=>'Druckformat'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273945638105864756)
,p_name=>'CONTENT_DISPOSITION'
,p_message_language=>'de'
,p_message_text=>'Content Disposition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273980851342864793)
,p_name=>'CONTENT_SERVED_IN_KBYTES'
,p_message_language=>'de'
,p_message_text=>'Behandelter Inhalt'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273818382530864666)
,p_name=>'CONTINUE'
,p_message_language=>'de'
,p_message_text=>'Weiter'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274857981646865414)
,p_name=>'CONTRIBUTORS'
,p_message_language=>'de'
,p_message_text=>'Beitragende'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274750546934865338)
,p_name=>'COPY.PAGE.NEW_STATIC_ID'
,p_message_language=>'de'
,p_message_text=>'Neue statische ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273514743335864458)
,p_name=>'COPYRIGHT'
,p_message_language=>'de'
,p_message_text=>'Copyright &copy; %0, Oracle und/oder verbundene Unternehmen. All rights reserved. Alle Rechte vorbehalten.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273573189771864497)
,p_name=>'COPY_APP_SUCCESS_MSG'
,p_message_language=>'de'
,p_message_text=>'Die Anwendung wurde kopiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273708738747864589)
,p_name=>'COPY_BUTTON.EXECUTION_ERR'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler bei Ausf\00FChrung von copy_button: %0 >> %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273747651798864616)
,p_name=>'COPY_DEPLOYMENT'
,p_message_language=>'de'
,p_message_text=>'Objektdefinitionsattribute kopieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273546457571864479)
,p_name=>'COPY_EXISTING_APP'
,p_message_language=>'de'
,p_message_text=>'Anwendung kopieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274004721702864810)
,p_name=>'COPY_FEATURE'
,p_message_language=>'de'
,p_message_text=>'Feature kopieren: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273747285953864616)
,p_name=>'COPY_FROM_APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Aus Anwendung kopieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274181448452864935)
,p_name=>'COPY_FROM_APP_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Basierend auf Templateanwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273747317706864616)
,p_name=>'COPY_FROM_NAME'
,p_message_language=>'de'
,p_message_text=>'Aus Name kopieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273575325945864499)
,p_name=>'COPY_LIST_ENTRY'
,p_message_language=>'de'
,p_message_text=>'Listeneintrag kopieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273709168401864589)
,p_name=>'COPY_NAMED_LOV.EXECUTION_ERR'
,p_message_language=>'de'
,p_message_text=>unistr('Fehler bei Ausf\00FChrung von copy_named_lov: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273709019680864589)
,p_name=>'COPY_NAMED_LOV.NOT_FOUND_ERR'
,p_message_language=>'de'
,p_message_text=>'Wertelisten-ID "%0" nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273708949821864589)
,p_name=>'COPY_NAMED_LOV.NUMERIC_ERR'
,p_message_language=>'de'
,p_message_text=>'Wertelisten-ID "%0" ist nicht numerisch.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273985729079864796)
,p_name=>'COPY_PAGE.COPY_FROM_PAGE'
,p_message_language=>'de'
,p_message_text=>'Kopie aus Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273985873927864796)
,p_name=>'COPY_PAGE.COPY_TO_PAGE'
,p_message_language=>'de'
,p_message_text=>'Kopie in Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273984723987864795)
,p_name=>'COPY_PAGE.SELECT_AUTHORIZATION'
,p_message_language=>'de'
,p_message_text=>unistr('- Autorisierung ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273984667683864795)
,p_name=>'COPY_PAGE.SELECT_LIST'
,p_message_language=>'de'
,p_message_text=>unistr('- Liste ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273984580277864795)
,p_name=>'COPY_PAGE.SELECT_NAMED_LOV'
,p_message_language=>'de'
,p_message_text=>unistr('- Werteliste ausw\00E4hlen -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274056637833864846)
,p_name=>'COPY_TABLE'
,p_message_language=>'de'
,p_message_text=>'Kopieren von %0 in Tabelle %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273747414456864616)
,p_name=>'COPY_TO_APPLICATION'
,p_message_language=>'de'
,p_message_text=>'In Anwendung kopieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273747580563864616)
,p_name=>'COPY_TO_NAME'
,p_message_language=>'de'
,p_message_text=>'In Name kopieren'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273672913636864564)
,p_name=>'CORE'
,p_message_language=>'de'
,p_message_text=>'Kern'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273839880551864681)
,p_name=>'COUNT'
,p_message_language=>'de'
,p_message_text=>'Anzahl'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273897646479864722)
,p_name=>'CREATE'
,p_message_language=>'de'
,p_message_text=>'Erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274143816084864908)
,p_name=>'CREATE APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274143941206864908)
,p_name=>'CREATE OBJECT'
,p_message_language=>'de'
,p_message_text=>'Objekt erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274353504761865059)
,p_name=>'CREATED'
,p_message_language=>'de'
,p_message_text=>'Erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274353686065865059)
,p_name=>'CREATED_BY'
,p_message_language=>'de'
,p_message_text=>'Erstellt von'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274004489404864809)
,p_name=>'CREATED_LAST_7_DAYS'
,p_message_language=>'de'
,p_message_text=>'In den letzten 7 Tagen erstellt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273709856074864589)
,p_name=>'CREATED_ON'
,p_message_language=>'de'
,p_message_text=>'Erstellt am'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273546559949864480)
,p_name=>'CREATE_APP_FROM_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Aus einem Anwendungstemplate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274647792186865266)
,p_name=>'CREATE_APP_WIZ.CANDLE_CHARTS'
,p_message_language=>'de'
,p_message_text=>'Kerzendiagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274647596236865266)
,p_name=>'CREATE_APP_WIZ.COL_CHARTS'
,p_message_language=>'de'
,p_message_text=>'2D- und 3D-Spalten-, Balken- und Stapeldiagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274648234336865266)
,p_name=>'CREATE_APP_WIZ.GAUGE_CHARTS'
,p_message_language=>'de'
,p_message_text=>'Skalen- und Skalen-(Prozent)-Diagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274647618376865266)
,p_name=>'CREATE_APP_WIZ.PIE_CHARTS'
,p_message_language=>'de'
,p_message_text=>'2D- und 3D-Kreis- und Ringdiagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274647904400865266)
,p_name=>'CREATE_APP_WIZ.PROJECTGANTT_CHARTS'
,p_message_language=>'de'
,p_message_text=>'Projekt-Gantt-Diagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274648181131865266)
,p_name=>'CREATE_APP_WIZ.RANGE_CHARTS'
,p_message_language=>'de'
,p_message_text=>'2D- und 3D-Bereichsdiagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274648059863865266)
,p_name=>'CREATE_APP_WIZ.RESOURCEGANTT_CHARTS'
,p_message_language=>'de'
,p_message_text=>'Ressourcen-Gantt-Diagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274647876702865266)
,p_name=>'CREATE_APP_WIZ.SCATTER_CHARTS'
,p_message_language=>'de'
,p_message_text=>'Streumarkierungsdiagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273664868305864559)
,p_name=>'CREATE_CONDITION.AND'
,p_message_language=>'de'
,p_message_text=>'AND'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273664634808864559)
,p_name=>'CREATE_CONDITION.ARROW_DOWN'
,p_message_language=>'de'
,p_message_text=>'Pfeil nach unten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273664721674864559)
,p_name=>'CREATE_CONDITION.ARROW_RIGHT'
,p_message_language=>'de'
,p_message_text=>'Pfeil nach rechts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273664405683864558)
,p_name=>'CREATE_CONDITION.COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273664577122864558)
,p_name=>'CREATE_CONDITION.CONDITIONS'
,p_message_language=>'de'
,p_message_text=>'Bedingungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273664977631864559)
,p_name=>'CREATE_CONDITION.OR'
,p_message_language=>'de'
,p_message_text=>'OR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273665021399864559)
,p_name=>'CREATE_CONDITION.PREVIEW'
,p_message_language=>'de'
,p_message_text=>'Vorschaubedingung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274005230577864810)
,p_name=>'CREATE_DEMO_APP.GRANT'
,p_message_language=>'de'
,p_message_text=>'Klicken Sie unten auf "Berechtigungen erteilen", um %0 mit diesen Berechtigungen auszustatten.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274005096162864810)
,p_name=>'CREATE_DEMO_APP.NO_CREATE_PRIV'
,p_message_language=>'de'
,p_message_text=>'%0 hat nicht die Berechtigung CREATE TABLE, CREATE VIEW, CREATE TRIGGER, CREATE SEQUENCE oder CREATE PROCEDURE und kann somit die Demoanwendung nicht installieren.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274005137022864810)
,p_name=>'CREATE_DEMO_APP.NO_EXEC_PRIV'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('%0 hat keine Ausf\00FChrungsberechtigung f\00FCr CTX_DOC und CTX_DDL und kann somit die Demo "President''s Inaugural" nicht installieren. F\00FChren Sie folgende Berechtigungserteilungen als berechtigter Benutzer aus: '),
'<pre>',
'GRANT EXECUTE ON CTXSYS.CTX_DDL TO %0; ',
'GRANT EXECUTE ON CTXSYS.CTX_DOC TO %0;',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274351696381865058)
,p_name=>'CREATE_DIALOG_CLOSED_DA'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4che erstellen - Dialog geschlossen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273448978880864414)
,p_name=>'CREATE_DYNAMIC_LIST'
,p_message_language=>'de'
,p_message_text=>'Dynamische Liste erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273733022021864606)
,p_name=>'CREATE_DYNAMIC_LOV'
,p_message_language=>'de'
,p_message_text=>'Dynamische Werteliste erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273426949836864399)
,p_name=>'CREATE_FLOW.CLOUD_IDM'
,p_message_language=>'de'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273466497972864426)
,p_name=>'CREATE_FLOW.DBACCOUNT'
,p_message_language=>'de'
,p_message_text=>'Datenbankaccount'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274170062871864927)
,p_name=>'CREATE_FLOW.HTMLDB_AUTH'
,p_message_language=>'de'
,p_message_text=>unistr('Authentifizierung f\00FCr Application Express')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274005694863864810)
,p_name=>'CREATE_FLOW.LDAP'
,p_message_language=>'de'
,p_message_text=>'LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274708966077865309)
,p_name=>'CREATE_FLOW.NAVIGATION_LIST'
,p_message_language=>'de'
,p_message_text=>unistr('Navigationsmen\00FCliste')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274170156632864927)
,p_name=>'CREATE_FLOW.NO_AUTH'
,p_message_language=>'de'
,p_message_text=>'Keine Authentifizierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274169775039864926)
,p_name=>'CREATE_FLOW.NO_TABS'
,p_message_language=>'de'
,p_message_text=>'Keine Registerkarten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274169891161864927)
,p_name=>'CREATE_FLOW.ONE_LEVEL_TABS'
,p_message_language=>'de'
,p_message_text=>'Registerkarten mit einer Ebene'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274005709959864810)
,p_name=>'CREATE_FLOW.SSO'
,p_message_language=>'de'
,p_message_text=>'Single Sign On (SSO)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274169968946864927)
,p_name=>'CREATE_FLOW.TWO_LEVEL_TABS'
,p_message_language=>'de'
,p_message_text=>'Registerkarten mit zwei Ebenen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273546339653864479)
,p_name=>'CREATE_FROM_SPREADSHEET'
,p_message_language=>'de'
,p_message_text=>'Aus einem Spreadsheet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273423369194864397)
,p_name=>'CREATE_GLOBAL_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Komponenten f\00FCr die globale Seite werden auf allen Seiten angezeigt, wenn der Anzeigepunkt ihrer Region im ausgew\00E4hlten Seitentemplate enthalten ist. Bedingte Anzeigeattribute k\00F6nnen zum Unterdr\00FCcken der Anzeige verwendet werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273698087282864581)
,p_name=>'CREATE_INDEX'
,p_message_language=>'de'
,p_message_text=>'Index erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273853688985864691)
,p_name=>'CREATE_ITEM_WIZ.NO_REGION'
,p_message_language=>'de'
,p_message_text=>unistr('Keine zugeh\00F6rige Region')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273672635412864564)
,p_name=>'CREATE_NEW_LOGIN_PAGE'
,p_message_language=>'de'
,p_message_text=>'Neue Anmeldeseite erstellen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273666539921864560)
,p_name=>'CREATE_PACKAGE.BACK'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck zum Assistenten zum Erstellen von Tabellen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273666010187864559)
,p_name=>'CREATE_PACKAGE.BROWSE'
,p_message_language=>'de'
,p_message_text=>'Package durchsuchen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273665906543864559)
,p_name=>'CREATE_PACKAGE.CREATED'
,p_message_language=>'de'
,p_message_text=>'Das Package "%0" wurde im "%1"-Schema erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273666693558864560)
,p_name=>'CREATE_PACKAGE.FAILED'
,p_message_language=>'de'
,p_message_text=>'Erstellen von Tabelle "%0" nicht erfolgreich.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273666473280864560)
,p_name=>'CREATE_PACKAGE.HOME'
,p_message_language=>'de'
,p_message_text=>'Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273666279647864560)
,p_name=>'CREATE_PACKAGE.RETURN_TO'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck zu')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273666399511864560)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP'
,p_message_language=>'de'
,p_message_text=>'SQL&nbsp;Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273666143530864560)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME'
,p_message_language=>'de'
,p_message_text=>'Home SQL Workshop '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273661806949864557)
,p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND'
,p_message_language=>'de'
,p_message_text=>'Keine Elemente gefunden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273661435887864556)
,p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Seitenelemente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273661789730864557)
,p_name=>'CREATE_PAGE_ITEM.PROMPT'
,p_message_language=>'de'
,p_message_text=>'Prompt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273661500141864556)
,p_name=>'CREATE_PAGE_ITEM.REGION'
,p_message_language=>'de'
,p_message_text=>'Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273661687981864557)
,p_name=>'CREATE_PAGE_ITEM.SET_REGION'
,p_message_language=>'de'
,p_message_text=>'Klicken Sie hier, um die Region festzulegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273659539471864555)
,p_name=>'CREATE_PROCESS.PAGE_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Seitenelemente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273659694169864555)
,p_name=>'CREATE_PROCESS.REGION'
,p_message_language=>'de'
,p_message_text=>'Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273665887805864559)
,p_name=>'CREATE_TABLE.HOME'
,p_message_language=>'de'
,p_message_text=>'Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273665698633864559)
,p_name=>'CREATE_TABLE.RETURN_TO'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck zu')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273665549928864559)
,p_name=>'CREATE_TABLE.RUN_SCRIPT'
,p_message_language=>'de'
,p_message_text=>unistr('Skript ausf\00FChren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273665282899864559)
,p_name=>'CREATE_TABLE.SCRIPT_CREATED'
,p_message_language=>'de'
,p_message_text=>unistr('Das Skript zum Erstellen von Tabellen f\00FCr die Tabelle %0 wurde im SQL-Skript-Repository erstellt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273665371700864559)
,p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY'
,p_message_language=>'de'
,p_message_text=>'Gehe zu Skript-Repository'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273665756378864559)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP'
,p_message_language=>'de'
,p_message_text=>'SQL&nbsp;Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273665436012864559)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME'
,p_message_language=>'de'
,p_message_text=>'Home SQL Workshop '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274122694180864893)
,p_name=>'CREATE_TABULAR_FORM'
,p_message_language=>'de'
,p_message_text=>'Tabellarisches Formular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274728237790865322)
,p_name=>'CREATE_TO_DO'
,p_message_language=>'de'
,p_message_text=>'To-do erstellen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274057424516864847)
,p_name=>'CREATE_TRIGGER'
,p_message_language=>'de'
,p_message_text=>'Erstellen von Trigger %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273995649970864803)
,p_name=>'CREATE_WS_OBJ_SUCCESS_MSG'
,p_message_language=>'de'
,p_message_text=>'Websheet-Datenbankobjekte erstellt.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273947883154864757)
,p_name=>'CREDENTIAL.OWNER'
,p_message_language=>'de'
,p_message_text=>unistr('Eigent\00FCmer der Zugangsdaten')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273910217736864731)
,p_name=>'CSS_CALENDAR'
,p_message_language=>'de'
,p_message_text=>'Kalender'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273823106210864670)
,p_name=>'CURRENT'
,p_message_language=>'de'
,p_message_text=>'Aktuell'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273902098393864725)
,p_name=>'CURRENT ENTRY'
,p_message_language=>'de'
,p_message_text=>'Aktueller Eintrag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273901747454864725)
,p_name=>'CURRENT FORM ELEMENT'
,p_message_language=>'de'
,p_message_text=>'Aktuelles Formularelement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273685949140864573)
,p_name=>'CURRENT ITEM HELP TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Hilfetext f\00FCr aktuelles Element')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273901861419864725)
,p_name=>'CURRENT ITEM IDENTIFICATION NUMBER'
,p_message_language=>'de'
,p_message_text=>'Aktuelle Element-ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273901958930864725)
,p_name=>'CURRENT ITEM LABEL NAME'
,p_message_language=>'de'
,p_message_text=>'Aktueller Elementlabelname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273960945869864767)
,p_name=>'CURRENT TAB'
,p_message_language=>'de'
,p_message_text=>'Aktuelle Registerkarte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273647789113864547)
,p_name=>'CURRENT_APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Aktuelle Anwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273654700194864552)
,p_name=>'CURRENT_IMAGE'
,p_message_language=>'de'
,p_message_text=>'Aktuelles Bild'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274261457883864994)
,p_name=>'CURRENT_ITEM_CONTAINER_ID'
,p_message_language=>'de'
,p_message_text=>'ID, die in einem Containerelement, das das aktuelle Feld umbricht, im Attribut "Vor Label und Element" verwendet werden kann.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274736790046865328)
,p_name=>'CURRENT_ITEM_HELP_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('Hilfetextlabel f\00FCr aktuelles Element')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273613580449864524)
,p_name=>'CURRENT_MILESTONE'
,p_message_language=>'de'
,p_message_text=>'Aktueller Meilenstein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273653899397864551)
,p_name=>'CURRENT_PAGE'
,p_message_language=>'de'
,p_message_text=>'Aktuelle Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273928571259864744)
,p_name=>'CURRENT_PAGE_CONTAINS_NO_ITEMS'
,p_message_language=>'de'
,p_message_text=>unistr('Aktuelle Seite enth\00E4lt keine Elemente.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273818961055864667)
,p_name=>'CUSTOM'
,p_message_language=>'de'
,p_message_text=>'Benutzerdefiniert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273861667608864697)
,p_name=>'CUSTOMIZE'
,p_message_language=>'de'
,p_message_text=>'Anpassen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273897552577864722)
,p_name=>'CUSTOMIZE LINK'
,p_message_language=>'de'
,p_message_text=>'Link anpassen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273907148339864729)
,p_name=>'CUSTOMIZE.USER_PAGE_PREFS_RESET'
,p_message_language=>'de'
,p_message_text=>unistr('Seitenvoreinstellungen f\00FCr Benutzer %0 wurden zur\00FCckgesetzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273907231369864729)
,p_name=>'CUSTOMIZE.USER_PREFS_CHANGED'
,p_message_language=>'de'
,p_message_text=>unistr('Voreinstellungen f\00FCr Benutzer %0 ge\00E4ndert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273907069903864729)
,p_name=>'CUSTOMIZE.USER_PREFS_RESET'
,p_message_language=>'de'
,p_message_text=>unistr('Seitenvoreinstellungen f\00FCr Benutzer %0 wurden zur\00FCckgesetzt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274611481719865240)
,p_name=>'CUSTOM_APPLICATIONS'
,p_message_language=>'de'
,p_message_text=>'Benutzerdefinierte Anwendungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273447817431864414)
,p_name=>'CUSTOM_AUTH_SCHEME_DESC'
,p_message_language=>'de'
,p_message_text=>'Entwicklerdefiniert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273702282839864584)
,p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR'
,p_message_language=>'de'
,p_message_text=>'Fehler in %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273613788769864524)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1'
,p_message_language=>'de'
,p_message_text=>unistr('Geben Sie eine beliebige Zeichenfolge als Ihre Benutzer-ID f\00FCr diese Session ein.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273613806707864525)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2'
,p_message_language=>'de'
,p_message_text=>unistr('Geben Sie den Benutzernamen und das Kennwort f\00FCr %0 ein.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273613900481864525)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3'
,p_message_language=>'de'
,p_message_text=>unistr('Geben Sie den Benutzernamen und das Kennwort f\00FCr die Verifizierung durch den LDAP-Host ein: %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273614060472864525)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4'
,p_message_language=>'de'
,p_message_text=>unistr('Geben Sie den Benutzernamen und das Kennwort f\00FCr das Datenbankschema ein.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274380511253865078)
,p_name=>'CUSTOM_CALENDAR'
,p_message_language=>'de'
,p_message_text=>'Erneut laden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274385655610865082)
,p_name=>'CUSTOM_CALENDAR.END_DATE'
,p_message_language=>'de'
,p_message_text=>'Enddatum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274385566135865082)
,p_name=>'CUSTOM_CALENDAR.START_DATE'
,p_message_language=>'de'
,p_message_text=>'Startdatum'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274058355488864847)
,p_name=>'DA.SET_VALUE.SQL.HELP_MSG'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Wenn die Aktion mit Status "True" "Wert festlegen" mit einer festgelegten SQL-Anweisung ist, m\00FCssen Sie die betroffenen Elemente in der Reihenfolge definieren, die der Spaltenreihenfolge Ihrer SQL-Anweisung entspricht. Die von Ihnen definierte SQL')
||'-Anweisung war:</p>',
'<pre>%0</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273619175951864528)
,p_name=>'DAILY'
,p_message_language=>'de'
,p_message_text=>unistr('T\00E4glich')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273836327797864679)
,p_name=>'DATA'
,p_message_language=>'de'
,p_message_text=>'Daten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274143477046864908)
,p_name=>'DATA WORKSHOP'
,p_message_language=>'de'
,p_message_text=>'Data Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273713828392864592)
,p_name=>'DATA.LOAD.ALL_COL_MAPPED'
,p_message_language=>'de'
,p_message_text=>'Alle %0 Spalten wurden automatisch der Tabelle %1 zugeordnet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273714695093864593)
,p_name=>'DATA.LOAD.APPEND_INCOMPLETE'
,p_message_language=>'de'
,p_message_text=>unistr('Daten in Tabelle <code>%0</code> wurden mit <b id="incompl_success_row_count"></b> neuen Zeilen angeh\00E4ngt. <b class="u-danger-text" id="incompl_fail_row_count"></b> Zeilen wurden abgelehnt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273714220759864592)
,p_name=>'DATA.LOAD.APPEND_SUCCESS'
,p_message_language=>'de'
,p_message_text=>unistr('Daten in Tabelle <code>%0</code> wurden mit <b id="success_row_count"></b> neuen Zeilen angeh\00E4ngt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273714491832864593)
,p_name=>'DATA.LOAD.APPEND_WARNING'
,p_message_language=>'de'
,p_message_text=>unistr('Daten in Tabelle <code>%0</code> wurden mit <b id="err_success_row_count"></b> neuen Zeilen angeh\00E4ngt. <b class="u-danger-text" id="err_fail_row_count"></b> Zeilen wurden abgelehnt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273423820974864397)
,p_name=>'DATA.LOAD.CHOOSE_FILE'
,p_message_language=>'de'
,p_message_text=>unistr('Datei ausw\00E4hlen')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273461417647864423)
,p_name=>'DATA.LOAD.CONFIGURATION_SAVED'
,p_message_language=>'de'
,p_message_text=>'Konfiguration gespeichert.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273713914217864592)
,p_name=>'DATA.LOAD.DEFINE_COL_MAPPING'
,p_message_language=>'de'
,p_message_text=>'Definieren Sie die Spaltenzuordnung, um diese Daten in die Tabelle %0 zu laden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273423795232864397)
,p_name=>'DATA.LOAD.DRAG_DROP_FILE_HERE'
,p_message_language=>'de'
,p_message_text=>'Datei per Drag-and-Drop hier ablegen oder'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273423669874864397)
,p_name=>'DATA.LOAD.FILE_FORMATS'
,p_message_language=>'de'
,p_message_text=>unistr('Unterst\00FCtzte Formate: CSV, XLSX, TXT, XML, JSON')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273424745565864398)
,p_name=>'DATA.LOAD.INVALID_FILE'
,p_message_language=>'de'
,p_message_text=>unistr('Die hochgeladene Datei ist ung\00FCltig oder hat die falsche Erweiterung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273593085843864511)
,p_name=>'DATA.LOAD.INVALID_SELECTOR'
,p_message_language=>'de'
,p_message_text=>unistr('Ung\00FCltiger XML- oder JSON-Selektor.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274141321450864906)
,p_name=>'DATA.LOAD.JOB_INTERMITTENTLY_FAILED'
,p_message_language=>'de'
,p_message_text=>unistr('Die Ausf\00FChrung des Datenladejobs wurde unerwartet gestoppt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274065547842864852)
,p_name=>'DATA.LOAD.JOB_NAME'
,p_message_language=>'de'
,p_message_text=>'Datenladejob in Workspace %0: Laden in Tabelle %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273714083140864592)
,p_name=>'DATA.LOAD.MAP_REMAINING_COLS'
,p_message_language=>'de'
,p_message_text=>'%0 von %1 Spalten wurden automatisch der Tabelle %2 zugeordnet. Konfigurieren Sie die verbleibenden %3 Spalten.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274059120551864848)
,p_name=>'DATA.LOAD.NO_FILE_CONTENTS'
,p_message_language=>'de'
,p_message_text=>'Keine Daten in hochgeladener Datei gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274059212297864848)
,p_name=>'DATA.LOAD.NO_WORKSHEET_CONTENTS'
,p_message_language=>'de'
,p_message_text=>'Keine Daten in Arbeitsblatt "%0" gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273424189025864398)
,p_name=>'DATA.LOAD.NO_XLSX_FILE'
,p_message_language=>'de'
,p_message_text=>'Die angegebene Datei ist keine XLSX-Datei.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274105949896864881)
,p_name=>'DATA.LOAD.PASTED_DATA'
,p_message_language=>'de'
,p_message_text=>unistr('Eingef\00FCgte Daten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273714739877864593)
,p_name=>'DATA.LOAD.REPLACE_INCOMPLETE'
,p_message_language=>'de'
,p_message_text=>'Daten in Tabelle <code>%0</code> wurden mit <b id="incompl_success_row_count"></b> neuen Zeilen ersetzt. <b class="u-danger-text" id="incompl_fail_row_count"></b> Zeilen wurden abgelehnt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273714387083864592)
,p_name=>'DATA.LOAD.REPLACE_SUCCESS'
,p_message_language=>'de'
,p_message_text=>'Daten in Tabelle <code>%0</code> wurden mit <b id="success_row_count"></b> neuen Zeilen ersetzt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273714585621864593)
,p_name=>'DATA.LOAD.REPLACE_WARNING'
,p_message_language=>'de'
,p_message_text=>'Daten in Tabelle <code>%0</code> wurden mit <b id="err_success_row_count"></b> neuen Zeilen ersetzt. <b class="u-danger-text" id="err_fail_row_count"></b> Zeilen wurden abgelehnt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273714123112864592)
,p_name=>'DATA.LOAD.SELECT_COLS'
,p_message_language=>'de'
,p_message_text=>unistr('W\00E4hlen Sie die zu ladenden Spalten aus.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274721094450865317)
,p_name=>'DATABASE'
,p_message_language=>'de'
,p_message_text=>'Datenbank'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274144042808864908)
,p_name=>'DATABASE BROWSER'
,p_message_language=>'de'
,p_message_text=>'Database-Browser'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274659628788865274)
,p_name=>'DATABASE.DEMO.SAMPLE.APP'
,p_message_language=>'de'
,p_message_text=>'Datenbankanwendung (Beispiel)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274721182644865317)
,p_name=>'DATABASE_APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Datenbankanwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273468121604864427)
,p_name=>'DATABASE_APPLICATIONS'
,p_message_language=>'de'
,p_message_text=>'Datenbankanwendungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273495914312864446)
,p_name=>'DATABASE_APPS'
,p_message_language=>'de'
,p_message_text=>'Datenbankanwendungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273990543151864800)
,p_name=>'DATABASE_APP_SUCCESS_MSG'
,p_message_language=>'de'
,p_message_text=>'Anwendung <strong>%0</strong> erfolgreich installiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273887437957864715)
,p_name=>'DATABASE_LINK'
,p_message_language=>'de'
,p_message_text=>'Datenbanklink'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273940277064864752)
,p_name=>'DATABASE_OBJECT_COUNTS_BY_TYPE'
,p_message_language=>'de'
,p_message_text=>'Anzahl Datenbankobjekte nach Objekttyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273943417221864754)
,p_name=>'DATABASE_ROLE_PRIVILEGES'
,p_message_language=>'de'
,p_message_text=>unistr('Berechtigungen f\00FCr Datenbankrolle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273490406177864442)
,p_name=>'DATABASE_USERS'
,p_message_language=>'de'
,p_message_text=>'Datenbank'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274051115783864842)
,p_name=>'DATA_GRID'
,p_message_language=>'de'
,p_message_text=>'Daten-Grid'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274650200042865268)
,p_name=>'DATA_GRIDS'
,p_message_language=>'de'
,p_message_text=>'Datenraster'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274650729701865268)
,p_name=>'DATA_GRID_DATA'
,p_message_language=>'de'
,p_message_text=>'Daten-Grid-Daten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274640757350865261)
,p_name=>'DATA_LOAD.ADVANCED_SETTINGS_REGION'
,p_message_language=>'de'
,p_message_text=>unistr('Erweiterte Einstellungen f\00FCr Datenladen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273577380874864500)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT'
,p_message_language=>'de'
,p_message_text=>'Zu verwendende Datums-/Zahlenformate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273577468864864500)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT_HELP'
,p_message_language=>'de'
,p_message_text=>unistr('W\00E4hlen Sie, ob benutzerdefinierte Formatmasken oder Standardformatmasken verwendet werden sollen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273491891115864443)
,p_name=>'DATA_LOAD.CHARSET'
,p_message_language=>'de'
,p_message_text=>'Datei-Zeichensatz'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274132008451864900)
,p_name=>'DATA_LOAD.COLUMN_NAMES'
,p_message_language=>'de'
,p_message_text=>'Spaltennamen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274130591598864899)
,p_name=>'DATA_LOAD.COLUMN_NAMES_MAPPING'
,p_message_language=>'de'
,p_message_text=>'Zielspalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273988672579864798)
,p_name=>'DATA_LOAD.COLUMN_NAME_ALIASES'
,p_message_language=>'de'
,p_message_text=>'Spaltenaliasnamen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274345011488865053)
,p_name=>'DATA_LOAD.CONFIRM'
,p_message_language=>'de'
,p_message_text=>'Die Daten wurde erfolgreich in die Tabelle hochgeladen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274352317974865058)
,p_name=>'DATA_LOAD.COPY_PASTE'
,p_message_language=>'de'
,p_message_text=>unistr('Kopieren und einf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274338688911865049)
,p_name=>'DATA_LOAD.COPY_PASTE_TEXTAREA'
,p_message_language=>'de'
,p_message_text=>unistr('Durch Begrenzungszeichen getrennte Daten kopieren und einf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274681025227865289)
,p_name=>'DATA_LOAD.CURRENCY_ITEM'
,p_message_language=>'de'
,p_message_text=>unistr('W\00E4hrungssymbol')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274681121088865289)
,p_name=>'DATA_LOAD.CURRENCY_ITEM_HELP'
,p_message_language=>'de'
,p_message_text=>unistr('Wenn Ihre Daten ein internationales W\00E4hrungssymbol enthalten, geben Sie dieses hier ein. Beispiel: Wenn Ihre Daten "&euro;1,234.56" oder "&yen;1,234.56" enthalten, geben Sie "&euro;" oder "&yen;" ein. Andernfalls werden die Daten nicht ordnungsgem\00E4\00DF ')
||'geladen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273496805236864447)
,p_name=>'DATA_LOAD.DATA_LOADING'
,p_message_language=>'de'
,p_message_text=>'Laden von Daten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274640817701865261)
,p_name=>'DATA_LOAD.DATE_FORMAT_APP'
,p_message_language=>'de'
,p_message_text=>'Standardformatmasken der Anwendung verwenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274640958295865261)
,p_name=>'DATA_LOAD.DATE_FORMAT_CUSTOM'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzerdefinierte Formate f\00FCr hochgeladene Spalten bereitstellen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274682680330865290)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_HELP'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Das Dezimalzeichen trennt bei einer Zahl die Ganzzahl von den Dezimalstellen.</p><p> Sie k\00F6nnen ein beliebiges Zeichen als Dezimalzeichen festlegen. Das angegebene Zeichen muss ein Ein-Byte-Zeichen sein, und das Dezimalzeichen darf nicht mit dem G')
||unistr('ruppentrennzeichen identisch sein. Bei dem Zeichen kann es sich um ein Leerzeichen handeln. Numerische Zeichen oder folgende Sonderzeichen sind nicht zul\00E4ssig:</p>'),
'<ul class="noIndent">',
'<li>Plus (+)</li>',
'<li>Bindestrich (-)</li>',
'<li>Kleiner-als-Zeichen (<)</li>',
unistr('<li>Gr\00F6\00DFer-als-Zeichen (>)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274681715347865290)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_ITEM'
,p_message_language=>'de'
,p_message_text=>'Dezimalzeichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273988820530864798)
,p_name=>'DATA_LOAD.DISPLAY'
,p_message_language=>'de'
,p_message_text=>'Anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274131911427864900)
,p_name=>'DATA_LOAD.DO_NOT_LOAD'
,p_message_language=>'de'
,p_message_text=>'Nicht laden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274676635389865286)
,p_name=>'DATA_LOAD.FAILED'
,p_message_language=>'de'
,p_message_text=>'Vorverarbeitungsfehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274589195660865225)
,p_name=>'DATA_LOAD.FAILED_COUNT'
,p_message_language=>'de'
,p_message_text=>'Fehlerhafte Zeilen:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274660622800865275)
,p_name=>'DATA_LOAD.FAILED_RECORD'
,p_message_language=>'de'
,p_message_text=>unistr('Nicht erfolgreiche Datens\00E4tze')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274680656701865289)
,p_name=>'DATA_LOAD.FILE_NAME_ITEM'
,p_message_language=>'de'
,p_message_text=>'Der Name der Datei, die hochgeladen werden soll'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274130868279864899)
,p_name=>'DATA_LOAD.FIRST_COLUMN_NAMES'
,p_message_language=>'de'
,p_message_text=>'Quellspalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274349031146865056)
,p_name=>'DATA_LOAD.FIRST_ROW'
,p_message_language=>'de'
,p_message_text=>unistr('Erste Zeile enth\00E4lt Spaltennamen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274680748571865289)
,p_name=>'DATA_LOAD.FIRST_ROW_HELP'
,p_message_language=>'de'
,p_message_text=>unistr('W\00E4hlen Sie dieses Kontrollk\00E4stchen, wenn Ihre Daten Spaltennamen in der ersten Zeile enthalten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274132123929864900)
,p_name=>'DATA_LOAD.FORMAT'
,p_message_language=>'de'
,p_message_text=>'Datums-/Zahlenformat'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274680908943865289)
,p_name=>'DATA_LOAD.GLOBALIZATION_REGION'
,p_message_language=>'de'
,p_message_text=>'Globalization'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274681634941865290)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_HELP'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Ein Gruppentrennzeichen trennt Gruppen von Ganzzahlen, beispielsweise Tausender und Millionen.</p>',
unistr('<p>Sie k\00F6nnen ein beliebiges Zeichen als Gruppentrennzeichen verwenden. Das angegebene Zeichen muss ein Ein-Byte-Zeichen sein und darf nicht einem anderen Dezimalzeichen identisch sein. Bei dem Zeichen kann es sich um ein Leerzeichen handeln. Numeris')
||unistr('che Zeichen oder folgende Sonderzeichen sind nicht zul\00E4ssig:</p><ul class="noIndent">'),
'<li>Plus (+)</li>',
'<li>Bindestrich (-)</li>',
'<li>Kleiner-als-Zeichen (<)</li>',
unistr('<li>Gr\00F6\00DFer-als-Zeichen (>)</li> </ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274681260198865289)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_ITEM'
,p_message_language=>'de'
,p_message_text=>'Gruppentrennzeichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274676345254865286)
,p_name=>'DATA_LOAD.INSERT'
,p_message_language=>'de'
,p_message_text=>unistr('Zeile einf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274588992724865224)
,p_name=>'DATA_LOAD.INSERTED_COUNT'
,p_message_language=>'de'
,p_message_text=>unistr('Eingef\00FCgte Zeilen:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274678145711865287)
,p_name=>'DATA_LOAD.IR_MAX_ROW_COUNT'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Abfrage gibt \00FCber #MAX_ROW_COUNT# Zeilen zur\00FCck. Filtern Sie die Daten, um vollst\00E4ndige Ergebnisse zu gew\00E4hrleisten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273987557960864797)
,p_name=>'DATA_LOAD.JUSTCHANGED_RECORD'
,p_message_language=>'de'
,p_message_text=>unistr('Datens\00E4tze von einem anderen Benutzer ge\00E4ndert.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273603835028864518)
,p_name=>'DATA_LOAD.LABEL_CASE_SENSITIVE'
,p_message_language=>'de'
,p_message_text=>unistr('Gro\00DF-/Kleinschreibung beachten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273603700265864518)
,p_name=>'DATA_LOAD.LABEL_UNIQUE_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Eindeutige Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274312177982865030)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'de'
,p_message_text=>'Datenladen nicht erfolgreich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274312219182865030)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'de'
,p_message_text=>'Aktion verarbeitet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274337813624865048)
,p_name=>'DATA_LOAD.LOAD_TO'
,p_message_language=>'de'
,p_message_text=>'Importieren aus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274741797456865332)
,p_name=>'DATA_LOAD.LOOKUP_FAILED'
,p_message_language=>'de'
,p_message_text=>'Lookup-Wert konnte nicht abgerufen werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274358236662865062)
,p_name=>'DATA_LOAD.MAPPING'
,p_message_language=>'de'
,p_message_text=>'Daten-/Tabellenzuordnung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274049311622864841)
,p_name=>'DATA_LOAD.MAPPING_PAGE'
,p_message_language=>'de'
,p_message_text=>'Schritt 2 - Seitenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274740475964865331)
,p_name=>'DATA_LOAD.NO_PREVIEW'
,p_message_language=>'de'
,p_message_text=>unistr('Keine Dateivorschau verf\00FCgbar')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274679811939865288)
,p_name=>'DATA_LOAD.OPTIONAL_ENCLOSE_ITEM'
,p_message_language=>'de'
,p_message_text=>'Optional umschlossen von'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274644199012865263)
,p_name=>'DATA_LOAD.PROGRESS_TITLE'
,p_message_language=>'de'
,p_message_text=>'Datenladeassistent - Fortschritt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274049560685864841)
,p_name=>'DATA_LOAD.RESULTS_PAGE'
,p_message_language=>'de'
,p_message_text=>'Schritt 4 - Seitenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273988748254864798)
,p_name=>'DATA_LOAD.RETURN'
,p_message_language=>'de'
,p_message_text=>unistr('Zur\00FCck')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273987073518864797)
,p_name=>'DATA_LOAD.REVIEW_COUNT'
,p_message_language=>'de'
,p_message_text=>unistr('Zu pr\00FCfende Zeile(n):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274132275868864900)
,p_name=>'DATA_LOAD.ROW'
,p_message_language=>'de'
,p_message_text=>'Zeile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274128721853864897)
,p_name=>'DATA_LOAD.RULES_PLSQL_EXPRESSION_EXAMPLES'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'to_char(sysdate);',
'',
'my_func(p_1  => :SAL,',
'        p_2  => :COMM);',
'',
'wobei SAL und COMM Spaltennamen der hochgeladenen Daten sind',
unistr('und my_func die Funktion ist, die den Wert zur\00FCckgibt, der zum neuen Wert'),
unistr('f\00FCr die Spalte wird, f\00FCr die diese Transformationsregel definiert wird.'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274128963568864898)
,p_name=>'DATA_LOAD.RULES_PLSQL_FUNCTION_EXAMPLES'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'declare',
'    l_result   number;',
'begin',
'   l_result := :SAL * :COMM',
'   return l_result;',
'end;',
'',
unistr('Auch hier wird das zur\00FCckgegebene Ergebnis zum neuen Wert der Spalte, f\00FCr die diese Transformationsregel definiert wird.'),
'',
':SAL und :COMM beziehen sich auf die Spaltennamen SAL und COMM der hochgeladenen Daten.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274128844911864898)
,p_name=>'DATA_LOAD.RULES_SQL_QUERY_EXAMPLES'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'',
'select depno',
'  from dept',
'  where dname = :DEPTNAME',
'  and   loc = :LOC',
'',
'wobei :DEPNAME und :LOC sich auf die Spaltennamen DEPNAME und LOC der hochgeladenen Daten beziehen.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274679625139865288)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_HELP'
,p_message_language=>'de'
,p_message_text=>unistr('Geben Sie ein Spaltentrennzeichen ein. Verwenden Sie <code>\005Ct</code> f\00FCr Tabulatoren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274679793291865288)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_LABEL'
,p_message_language=>'de'
,p_message_text=>'Trennzeichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273988951789864798)
,p_name=>'DATA_LOAD.SEQUENCE'
,p_message_language=>'de'
,p_message_text=>'Sequenz'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274733422676865326)
,p_name=>'DATA_LOAD.SEQUENCE_ACTION'
,p_message_language=>'de'
,p_message_text=>'Sequenz: Aktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274640542062865261)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Erweiterte Einstellungen verwenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274640623156865261)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS_HELP'
,p_message_language=>'de'
,p_message_text=>unistr('Zeigen Sie erweiterte Einstellungen f\00FCr das Laden von Daten an: W\00E4hrungssymbol, Dezimalzeichen, Dateicodierung oder Datumsformate')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274357652739865062)
,p_name=>'DATA_LOAD.SOURCE'
,p_message_language=>'de'
,p_message_text=>'Datenladequelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274049258301864841)
,p_name=>'DATA_LOAD.SOURCE_PAGE'
,p_message_language=>'de'
,p_message_text=>'Schritt 1 - Seitenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274721367851865318)
,p_name=>'DATA_LOAD.TAB_SEPARTOR_NOTE'
,p_message_language=>'de'
,p_message_text=>unistr('(\005Ct f\00FCr Tabulator)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274062328405864850)
,p_name=>'DATA_LOAD.TRANSFORMATION_FAILED'
,p_message_language=>'de'
,p_message_text=>'Die Transformationsregel war nicht erfolgreich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274678432495865287)
,p_name=>'DATA_LOAD.UNIQUE_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Eindeutige Spalte %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274676417614865286)
,p_name=>'DATA_LOAD.UPDATE'
,p_message_language=>'de'
,p_message_text=>'Zeile aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274589068598865225)
,p_name=>'DATA_LOAD.UPDATED_COUNT'
,p_message_language=>'de'
,p_message_text=>'Aktualisierte Zeilen:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274789116098865365)
,p_name=>'DATA_LOAD.UPLOADED_NULL_VALUE'
,p_message_language=>'de'
,p_message_text=>'Nullwert wurde hochgeladen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274352253901865058)
,p_name=>'DATA_LOAD.UPLOAD_FILE'
,p_message_language=>'de'
,p_message_text=>'Datei hochladen, durch Kommas (*.csv) oder Tabulatoren getrennt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274357821594865062)
,p_name=>'DATA_LOAD.UPLOAD_RESULTS'
,p_message_language=>'de'
,p_message_text=>'Datenladeergebnisse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274357726472865062)
,p_name=>'DATA_LOAD.VALIDATION'
,p_message_language=>'de'
,p_message_text=>'Datenvalidierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274049495011864841)
,p_name=>'DATA_LOAD.VALIDATION_PAGE'
,p_message_language=>'de'
,p_message_text=>'Schritt 3 - Seitenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274053599924864844)
,p_name=>'DATA_LOAD_WIZARD_CREATED_SUCCESSFULLY'
,p_message_language=>'de'
,p_message_text=>'Die Seiten des Datenladeassistenten wurden erfolgreich erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274312311801865031)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'de'
,p_message_text=>'Daten-/Tabellenzuordnung nicht erfolgreich'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274312473806865031)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'de'
,p_message_text=>'Aktion verarbeitet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273911721282864732)
,p_name=>'DATA_UPLOAD_COLUMN_MAPPING'
,p_message_language=>'de'
,p_message_text=>'Spaltenzuordnung beim Hochladen von Daten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273837279986864680)
,p_name=>'DATE'
,p_message_language=>'de'
,p_message_text=>'Datum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274041897196864836)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID'
,p_message_language=>'de'
,p_message_text=>unistr('Der hervorgehobene Datumsattributwert %0 f\00FCr Element %1 entspricht nicht dem Format %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274047671042864840)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID_RELATIVE'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr Element %1 eingegebener Attributwert %0 f\00FCr hervorgehobenes Datum ist kein relatives Datum.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274042020814864836)
,p_name=>'DATEPICKER.MAX_DATE_INVALID'
,p_message_language=>'de'
,p_message_text=>unistr('Der f\00FCr Element %1 eingegebene Attributwert f\00FCr das sp\00E4teste Datum %0 entspricht nicht dem Format %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274047894993864840)
,p_name=>'DATEPICKER.MAX_DATE_INVALID_RELATIVE'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr Element %1 eingegebener Attributwert %0 f\00FCr sp\00E4testes Datum ist kein relatives Datum.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274041967791864836)
,p_name=>'DATEPICKER.MIN_DATE_INVALID'
,p_message_language=>'de'
,p_message_text=>unistr('Der eingegebene Wert f\00FCr das fr\00FCheste Datum %0 f\00FCr Element %1 entspricht nicht dem Format %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274047759145864840)
,p_name=>'DATEPICKER.MIN_DATE_INVALID_RELATIVE'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr Element %1 eingegebener Attributwert %0 f\00FCr fr\00FChestes Datum ist kein relatives Datum.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274175784988864931)
,p_name=>'DATE_ADDED'
,p_message_language=>'de'
,p_message_text=>unistr('Hinzugef\00FCgt am')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274648503586865266)
,p_name=>'DATE_OF_LAST_RUN'
,p_message_language=>'de'
,p_message_text=>unistr('Zuletzt ausgef\00FChrte Oracle Application Express-Datenbank-Jobs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273667741783864561)
,p_name=>'DAY'
,p_message_language=>'de'
,p_message_text=>'Tag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273667829872864561)
,p_name=>'DAYS'
,p_message_language=>'de'
,p_message_text=>'Tage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273964421623864769)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE'
,p_message_language=>'de'
,p_message_text=>'zu letztem Meilenstein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273964582145864769)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE_OF_RELASE'
,p_message_language=>'de'
,p_message_text=>'zu letztem Meilenstein von Release %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274046920505864839)
,p_name=>'DA_NAME.NATIVE_ADD_CLASS'
,p_message_language=>'de'
,p_message_text=>unistr('Klasse hinzuf\00FCgen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274653594374865270)
,p_name=>'DA_NAME.NATIVE_ALERT'
,p_message_language=>'de'
,p_message_text=>'Alert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274652294067865269)
,p_name=>'DA_NAME.NATIVE_CANCEL_EVENT'
,p_message_language=>'de'
,p_message_text=>'Ereignis abbrechen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274653746089865270)
,p_name=>'DA_NAME.NATIVE_CLEAR'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274653606906865270)
,p_name=>'DA_NAME.NATIVE_CONFIRM'
,p_message_language=>'de'
,p_message_text=>unistr('Best\00E4tigen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273413309171864390)
,p_name=>'DA_NAME.NATIVE_DIALOG_CANCEL'
,p_message_language=>'de'
,p_message_text=>'Dialog abbrechen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273413450526864390)
,p_name=>'DA_NAME.NATIVE_DIALOG_CLOSE'
,p_message_language=>'de'
,p_message_text=>unistr('Dialog schlie\00DFen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273573015309864497)
,p_name=>'DA_NAME.NATIVE_DISABLE'
,p_message_language=>'de'
,p_message_text=>'Deaktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273572975923864497)
,p_name=>'DA_NAME.NATIVE_ENABLE'
,p_message_language=>'de'
,p_message_text=>'Aktivieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274645830597865264)
,p_name=>'DA_NAME.NATIVE_EXECUTE_PLSQL_CODE'
,p_message_language=>'de'
,p_message_text=>unistr('PL/SQL-Code ausf\00FChren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273572872883864497)
,p_name=>'DA_NAME.NATIVE_HIDE'
,p_message_language=>'de'
,p_message_text=>'Ausblenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273959237069864765)
,p_name=>'DA_NAME.NATIVE_JAVASCRIPT_CODE'
,p_message_language=>'de'
,p_message_text=>unistr('JavaScript-Code ausf\00FChren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274319289761865035)
,p_name=>'DA_NAME.NATIVE_REFRESH'
,p_message_language=>'de'
,p_message_text=>'Aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274047027368864839)
,p_name=>'DA_NAME.NATIVE_REMOVE_CLASS'
,p_message_language=>'de'
,p_message_text=>'Klasse entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274047160133864839)
,p_name=>'DA_NAME.NATIVE_SET_CSS'
,p_message_language=>'de'
,p_message_text=>'Stil festlegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274292166228865016)
,p_name=>'DA_NAME.NATIVE_SET_FOCUS'
,p_message_language=>'de'
,p_message_text=>'Fokus festlegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273959104890864765)
,p_name=>'DA_NAME.NATIVE_SET_VALUE'
,p_message_language=>'de'
,p_message_text=>'Wert festlegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273572752559864497)
,p_name=>'DA_NAME.NATIVE_SHOW'
,p_message_language=>'de'
,p_message_text=>'Anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274292223516865016)
,p_name=>'DA_NAME.NATIVE_SUBMIT_PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite senden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274229715325864969)
,p_name=>'DA_NAME.NATIVE_TREE_COLLAPSE'
,p_message_language=>'de'
,p_message_text=>'Baum ausblenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274229601735864968)
,p_name=>'DA_NAME.NATIVE_TREE_EXPAND'
,p_message_language=>'de'
,p_message_text=>'Baum einblenden'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273450256026864415)
,p_name=>'DBACCOUNT_AUTH_SCHEME_DESC'
,p_message_language=>'de'
,p_message_text=>'Datenbankaccount'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273955379686864763)
,p_name=>'DB_COLS_CASE_SEN'
,p_message_language=>'de'
,p_message_text=>unistr('Bei Datenbanktabellen- und Spaltennamen muss die Gro\00DF-/Kleinschreibung beachtet werden')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274067666034864854)
,p_name=>'DB_OBJECT_CREATION_EXCEPTION'
,p_message_language=>'de'
,p_message_text=>'Ausnahme beim Erstellen von Datenbankobjekt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273463910818864424)
,p_name=>'DB_PRODUCT_NAME'
,p_message_language=>'de'
,p_message_text=>'Oracle Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274711573616865311)
,p_name=>'DB_SERVICES_ALIAS'
,p_message_language=>'de'
,p_message_text=>'Aliasname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274707915535865308)
,p_name=>'DB_SERVICES_ALL_MIMES'
,p_message_language=>'de'
,p_message_text=>'Alle MIME-Typen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274711408124865311)
,p_name=>'DB_SERVICES_CREATE_HANDLER'
,p_message_language=>'de'
,p_message_text=>'Handler erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274708291414865308)
,p_name=>'DB_SERVICES_CREATE_METHOD'
,p_message_language=>'de'
,p_message_text=>'Methode erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274708008151865308)
,p_name=>'DB_SERVICES_CREATE_PARAMETER'
,p_message_language=>'de'
,p_message_text=>'Parameter erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274708178333865308)
,p_name=>'DB_SERVICES_CREATE_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Template erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274715204843865313)
,p_name=>'DB_SERVICES_DB_SERVICES_MODULE'
,p_message_language=>'de'
,p_message_text=>'RESTful Servicemodul'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274711317210865310)
,p_name=>'DB_SERVICES_HANDLER'
,p_message_language=>'de'
,p_message_text=>'Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274715781559865314)
,p_name=>'DB_SERVICES_HANDLER_BIND_VARIABLE'
,p_message_language=>'de'
,p_message_text=>'Handler Bind-Variable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274685130967865292)
,p_name=>'DB_SERVICES_HANDLER_METHOD'
,p_message_language=>'de'
,p_message_text=>'Handler-Methode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274716074911865314)
,p_name=>'DB_SERVICES_HANDLER_SOURCE'
,p_message_language=>'de'
,p_message_text=>'Handler-Quelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274685257450865292)
,p_name=>'DB_SERVICES_HANDLER_SRC_TYPE'
,p_message_language=>'de'
,p_message_text=>'Handler-Quelltyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274707790651865308)
,p_name=>'DB_SERVICES_METHOD'
,p_message_language=>'de'
,p_message_text=>'Methode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274715342177865313)
,p_name=>'DB_SERVICES_MODULE_NAME'
,p_message_language=>'de'
,p_message_text=>'Modulname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274715886649865314)
,p_name=>'DB_SERVICES_MODULE_URI'
,p_message_language=>'de'
,p_message_text=>unistr('URI-Pr\00E4fix des Moduls')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274708313439865308)
,p_name=>'DB_SERVICES_NO_SOURCE'
,p_message_language=>'de'
,p_message_text=>'Keine Quelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274707615156865308)
,p_name=>'DB_SERVICES_PARAMETER'
,p_message_language=>'de'
,p_message_text=>'Parameter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274715579203865313)
,p_name=>'DB_SERVICES_RESTFUL_SERVICES'
,p_message_language=>'de'
,p_message_text=>'RESTful Services'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274707850466865308)
,p_name=>'DB_SERVICES_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274715984355865314)
,p_name=>'DB_SERVICES_TEMPLATE_URI'
,p_message_language=>'de'
,p_message_text=>'URI-Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274685097698865292)
,p_name=>'DB_SERVICES_URI'
,p_message_language=>'de'
,p_message_text=>'Uniform Resource Identifier (URI)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274715051049865313)
,p_name=>'DB_SERVICES_URI_PRIFIX'
,p_message_language=>'de'
,p_message_text=>unistr('URI-Pr\00E4fix')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274715199756865313)
,p_name=>'DB_SERVICES_URI_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'URI-Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274685306712865292)
,p_name=>'DB_SERVICE_QUERY_ONE_ROW'
,p_message_language=>'de'
,p_message_text=>'Eine Zeile abfragen'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273860742249864696)
,p_name=>'DEBUG'
,p_message_language=>'de'
,p_message_text=>'Debuggen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273975740359864789)
,p_name=>'DEBUGGING_OFF'
,p_message_language=>'de'
,p_message_text=>unistr('Debugging ist f\00FCr diese Anwendung nicht aktiviert.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273972468794864775)
,p_name=>'DECLINED'
,p_message_language=>'de'
,p_message_text=>'Abgelehnt'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274787002704865364)
,p_name=>'DEFAULT_DIALOGBTNR_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Standard-Template f\00FCr Region "Dialogfeldschaltfl\00E4che"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274786990343865364)
,p_name=>'DEFAULT_DIALOGR_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Standard-Template f\00FCr Region "Dialogfeldinhalt"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274313198199865031)
,p_name=>'DEFAULT_PAGE'
,p_message_language=>'de'
,p_message_text=>'Standardseite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273841687413864683)
,p_name=>'DEFAULT_TABLESPACE'
,p_message_language=>'de'
,p_message_text=>'Default Tablespace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273843355676864684)
,p_name=>'DEFAULT_TABLESPACE_INIT'
,p_message_language=>'de'
,p_message_text=>'Default Tablespace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274131078045864899)
,p_name=>'DEFAULT_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Standardtemplate'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273445971163864412)
,p_name=>'DEFINED_BY_DA'
,p_message_language=>'de'
,p_message_text=>'Von dynamischer Aktion definiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274376758149865076)
,p_name=>'DEFINED_TABS'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Anwendung hat %0 Registerkarten, die in %1 Registerkartengruppen aufgeteilt sind. Au\00DFerdem enth\00E4lt sie %2 \00FCbergeordnete Registerkarten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273732911383864606)
,p_name=>'DEFINE_LOV'
,p_message_language=>'de'
,p_message_text=>'Werteliste definieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273897822858864722)
,p_name=>'DEFINITION'
,p_message_language=>'de'
,p_message_text=>'Definition'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274065423651864852)
,p_name=>'DEINSTALLATION_SCRIPT'
,p_message_language=>'de'
,p_message_text=>'Deinstallationsskript'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273669519940864562)
,p_name=>'DELETE'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273561127606864489)
,p_name=>'DELETED'
,p_message_language=>'de'
,p_message_text=>unistr('Gel\00F6scht')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274649750517865267)
,p_name=>'DELETE_APPLICATION'
,p_message_language=>'de'
,p_message_text=>unistr('Anwendung l\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274122777027864893)
,p_name=>'DELETE_LABEL'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274098574249864876)
,p_name=>'DELETE_LINK_TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('%0 l\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273474535437864432)
,p_name=>'DELETE_MSG'
,p_message_language=>'de'
,p_message_text=>unistr('Soll dieser L\00F6schvorgang ausgef\00FChrt werden?')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273512262484864457)
,p_name=>'DEMO.COLLECT.DESCR'
,p_message_language=>'de'
,p_message_text=>unistr('Mit "Collections Showcase" k\00F6nnen Datenzeilen zur Verwendung in einer Oracle Application Express-Session gespeichert werden. Diese Datenbankanwendung zeigt, wie Sie mithilfe von PL/SQL einen auf Collections basierenden Sessionzustand erstellen und ve')
||unistr('rwalten k\00F6nnen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273512008108864457)
,p_name=>'DEMO.SAMPLE.APP'
,p_message_language=>'de'
,p_message_text=>'Beispielanwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273512144931864457)
,p_name=>'DEMO.SAMPLE.APP.DESCR'
,p_message_language=>'de'
,p_message_text=>unistr('"Product Portal" ist eine Beispielanwendung, die allgemeine Designkonzepte beschreibt. Sie umfasst dedizierte Seiten f\00FCr Kunden, Produkte und Auftr\00E4ge und veranschaulicht die Verwendung von Berichten, Diagrammen, Kalender, Karten und Baum.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273920571868864738)
,p_name=>'DEMONSTRABLE'
,p_message_language=>'de'
,p_message_text=>'Demonstrierbar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273650346122864549)
,p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK'
,p_message_language=>'de'
,p_message_text=>unistr('Beispiele f\00FCr stabile Berichte und Konzepte f\00FCr die Seitennummerierung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273650046076864549)
,p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE'
,p_message_language=>'de'
,p_message_text=>unistr('Beispiel f\00FCr einen Online-Store, der mit %0 erstellt wurde.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273650700190864549)
,p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL'
,p_message_language=>'de'
,p_message_text=>unistr('Wissenswertes \00FCber das Verwenden von Oracle Text mit %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273651103686864549)
,p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING'
,p_message_language=>'de'
,p_message_text=>'Beispiel einer Anwendung zur Protokollierung des Projektstatus, die mit %0 erstellt wurde.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273650541543864549)
,p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES'
,p_message_language=>'de'
,p_message_text=>unistr('Wissenswertes \00FCber die Verwendung der Web Services mit %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273648895472864548)
,p_name=>'DEMO_APPLICATION.ACTION'
,p_message_language=>'de'
,p_message_text=>'Aktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273646680760864546)
,p_name=>'DEMO_APPLICATION.APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273646328600864546)
,p_name=>'DEMO_APPLICATION.BASIC_LEXER'
,p_message_language=>'de'
,p_message_text=>'BASIC_LEXER'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273650246079864549)
,p_name=>'DEMO_APPLICATION.BUSINESS_LOOK'
,p_message_language=>'de'
,p_message_text=>'Business Look'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273648930559864548)
,p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE'
,p_message_language=>'de'
,p_message_text=>'Collection Showcase'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273646473691864546)
,p_name=>'DEMO_APPLICATION.CONTEXT_INDEX'
,p_message_language=>'de'
,p_message_text=>'CONTEXT INDEX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273645810098864546)
,p_name=>'DEMO_APPLICATION.CREATE_BASIC'
,p_message_language=>'de'
,p_message_text=>'Sie sind im Begriff, die Basic Examples-Demoanwendung zu erstellen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273644483981864545)
,p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK'
,p_message_language=>'de'
,p_message_text=>'Sie sind im Begriff, die Business Look-Demoanwendung (neu) zu erstellen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273645922579864546)
,p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE'
,p_message_language=>'de'
,p_message_text=>'Sie sind im Begriff, die Collections Showcase-Demoanwendung zu erstellen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273646041585864546)
,p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE'
,p_message_language=>'de'
,p_message_text=>'In Schema %0 erstellen oder neu erstellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273644385156864545)
,p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES'
,p_message_language=>'de'
,p_message_text=>unistr('Erstellen Sie eine Beispielanwendung f\00FCr die Demonstration von Web Services.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273644566583864545)
,p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA'
,p_message_language=>'de'
,p_message_text=>'Sie sind im Begriff, die WorldCup Mania-Demoanwendung zu erstellen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273454453646864418)
,p_name=>'DEMO_APPLICATION.DEINSTALL'
,p_message_language=>'de'
,p_message_text=>'Entfernen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273648609457864548)
,p_name=>'DEMO_APPLICATION.DEMO_APP'
,p_message_language=>'de'
,p_message_text=>'Demoanwendung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273646976742864547)
,p_name=>'DEMO_APPLICATION.FREE_SPACE'
,p_message_language=>'de'
,p_message_text=>unistr('Es stehen Ihnen etwa %0 MB zur Verf\00FCgung.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273649449694864548)
,p_name=>'DEMO_APPLICATION.INSTALL'
,p_message_language=>'de'
,p_message_text=>'Installieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273649125604864548)
,p_name=>'DEMO_APPLICATION.INSTALLED'
,p_message_language=>'de'
,p_message_text=>'Installiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273764131578864628)
,p_name=>'DEMO_APPLICATION.INSTALL_DEMO_APP'
,p_message_language=>'de'
,p_message_text=>'Sie sind im Begriff, die Beispielanwendung zu installieren, die die wichtigsten Features von %0 zeigt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273650184361864549)
,p_name=>'DEMO_APPLICATION.INSTALL_NOW'
,p_message_language=>'de'
,p_message_text=>'Jetzt installieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273649000038864548)
,p_name=>'DEMO_APPLICATION.LEARN_ABOUT'
,p_message_language=>'de'
,p_message_text=>unistr('Wissenswertes \00FCber die Konzepte bei %0-Warenkorb.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274102723686864879)
,p_name=>'DEMO_APPLICATION.LOCKED'
,p_message_language=>'de'
,p_message_text=>'Gesperrt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273646732655864546)
,p_name=>'DEMO_APPLICATION.NEED_7M'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr das Presidential Inaugural Address-Demo sind etwa 7 MB freier Speicherplatz erforderlich. Die Installation in Ihr Schema dauert ungef\00E4hr zwei Minuten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273763889240864627)
,p_name=>'DEMO_APPLICATION.NOT_ENOUGH_SPACE_ERR'
,p_message_language=>'de'
,p_message_text=>unistr('Es ist nicht gen\00FCgend Speicherplatz zum Erstellen dieser Demo verf\00FCgbar. Fordern Sie zus\00E4tzlichen Speicher an, indem Sie auf der Seite f\00FCr die Administration zu den Provisioning-Services navigieren und auf den Link zum Anfordern von zus\00E4tzlicher Spei')
||unistr('cherkapazit\00E4t klicken. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273649355458864548)
,p_name=>'DEMO_APPLICATION.NOT_INSTALLED'
,p_message_language=>'de'
,p_message_text=>'Nicht installiert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273645216422864545)
,p_name=>'DEMO_APPLICATION.OBJECT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Vorhanden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273644177928864545)
,p_name=>'DEMO_APPLICATION.OBJECT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'vorhanden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273645194027864545)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME'
,p_message_language=>'de'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273646235365864546)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME2'
,p_message_language=>'de'
,p_message_text=>'Objektname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273644243099864545)
,p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS'
,p_message_language=>'de'
,p_message_text=>'nicht vorhanden ist'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273644877642864545)
,p_name=>'DEMO_APPLICATION.OBJECT_RECREATE'
,p_message_language=>'de'
,p_message_text=>'Die folgenden Datenbankobjekte werden neu erstellt, falls sie vorhanden sind'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273645055184864545)
,p_name=>'DEMO_APPLICATION.OBJECT_TYPE'
,p_message_language=>'de'
,p_message_text=>'Objekttyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273645737379864546)
,p_name=>'DEMO_APPLICATION.PACKAGE'
,p_message_language=>'de'
,p_message_text=>'Package'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273649965187864549)
,p_name=>'DEMO_APPLICATION.PETSTORE'
,p_message_language=>'de'
,p_message_text=>'Pet-Speicher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273650618121864549)
,p_name=>'DEMO_APPLICATION.PRESIDENTIAL'
,p_message_language=>'de'
,p_message_text=>'Presidential Inaugural Addresses'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273650950479864549)
,p_name=>'DEMO_APPLICATION.PROJECT_TRACKING'
,p_message_language=>'de'
,p_message_text=>'Projektprotokollierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273847396023864687)
,p_name=>'DEMO_APPLICATION.RE_INSTALL'
,p_message_language=>'de'
,p_message_text=>'Neu installieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273649282266864548)
,p_name=>'DEMO_APPLICATION.RUN'
,p_message_language=>'de'
,p_message_text=>unistr('Ausf\00FChren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273644932360864545)
,p_name=>'DEMO_APPLICATION.SCHEMA'
,p_message_language=>'de'
,p_message_text=>'Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273645502141864546)
,p_name=>'DEMO_APPLICATION.SEQUENCE'
,p_message_language=>'de'
,p_message_text=>'Sequenz'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273648731147864548)
,p_name=>'DEMO_APPLICATION.STATUS'
,p_message_language=>'de'
,p_message_text=>'Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273645324065864545)
,p_name=>'DEMO_APPLICATION.TABLE'
,p_message_language=>'de'
,p_message_text=>'Tabelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273648501398864548)
,p_name=>'DEMO_APPLICATION.TABLE_SUMMARY'
,p_message_language=>'de'
,p_message_text=>'Demoanwendung installieren - Statusbericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273645666495864546)
,p_name=>'DEMO_APPLICATION.TRIGGER'
,p_message_language=>'de'
,p_message_text=>'Trigger'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274102937512864879)
,p_name=>'DEMO_APPLICATION.UNLOCKED'
,p_message_language=>'de'
,p_message_text=>'Entsperrt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273491401038864443)
,p_name=>'DEMO_APPLICATION.UPDATE_AVAILABLE'
,p_message_language=>'de'
,p_message_text=>unistr('Update verf\00FCgbar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274741446549865332)
,p_name=>'DEMO_APPLICATION.WEBSHEET_OBJECT_VALIDATE'
,p_message_language=>'de'
,p_message_text=>unistr('Die folgenden ung\00FCltigen Objekte m\00FCssen korrigiert werden, damit Websheets ordnungsgem\00E4\00DF ausgef\00FChrt werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273650488896864549)
,p_name=>'DEMO_APPLICATION.WEB_SERVICES'
,p_message_language=>'de'
,p_message_text=>'Webservices'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273647029141864547)
,p_name=>'DEMO_APPLICATION.WILL_ERROR'
,p_message_language=>'de'
,p_message_text=>'Es tritt gegebenenfalls ein Fehler auf, wenn Sie diese Demo nicht neu erstellen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273579992373864502)
,p_name=>'DEMO_FLOW.CREATED_ERROR'
,p_message_language=>'de'
,p_message_text=>unistr('Es steht nicht gen\00FCgend Speicherplatz zum Erstellen dieser Demo zur Verf\00FCgung. Fordern Sie zus\00E4tzliche Speicherkapazit\00E4t an, indem Sie zur Seite f\00FCr die Administration navigieren und anschlie\00DFend auf "\00C4nderungen beim aktuellen Service anfordern" klic')
||'ken.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273579846006864502)
,p_name=>'DEMO_FLOW.CREATED_SUCCESS'
,p_message_language=>'de'
,p_message_text=>'Die %0-Demoanwendung wurde erstellt.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274350931037865057)
,p_name=>'DEPRECATED'
,p_message_language=>'de'
,p_message_text=>'Verworfen'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273527823097864467)
,p_name=>'DERIVED$'
,p_message_language=>'de'
,p_message_text=>'Abgeleitete Spalte'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273920496303864738)
,p_name=>'DESIRABLE'
,p_message_language=>'de'
,p_message_text=>unistr('Gew\00FCnscht')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273996374426864804)
,p_name=>'DETAIL'
,p_message_language=>'de'
,p_message_text=>'Detail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274063194128864851)
,p_name=>'DETAILS_FOR_ALT_TAG'
,p_message_language=>'de'
,p_message_text=>'Details'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273996418377864804)
,p_name=>'DETAIL_2'
,p_message_language=>'de'
,p_message_text=>'Detail 2'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273462536503864424)
,p_name=>'DEVELOPER'
,p_message_language=>'de'
,p_message_text=>'Entwickler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274069316552864855)
,p_name=>'DEVELOPERS'
,p_message_language=>'de'
,p_message_text=>'Entwickler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273940896079864753)
,p_name=>'DEVELOPER_ACTIVITY_SUMMARY'
,p_message_language=>'de'
,p_message_text=>unistr('Zusammenfassung Entwickleraktivit\00E4t')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273965738433864770)
,p_name=>'DEVELOPER_SUMMARY'
,p_message_language=>'de'
,p_message_text=>unistr('Entwickler\00FCbersicht')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274146293127864910)
,p_name=>'DEVELOPER_TOOLBAR_CLEAR'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274146172847864910)
,p_name=>'DEVELOPER_TOOLBAR_COPY'
,p_message_language=>'de'
,p_message_text=>'Kopieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274174818955864930)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LABEL'
,p_message_language=>'de'
,p_message_text=>'Debug (%0)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274174361217864930)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL'
,p_message_language=>'de'
,p_message_text=>'Standard-Debug-Ebene'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274174522072864930)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL4'
,p_message_language=>'de'
,p_message_text=>'Info (Standard)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274174641094864930)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL6'
,p_message_language=>'de'
,p_message_text=>'App-Trace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274174789366864930)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL9'
,p_message_language=>'de'
,p_message_text=>unistr('Vollst\00E4ndiges Trace')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274133829927864901)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS'
,p_message_language=>'de'
,p_message_text=>'Seit die Seite geladen wurde, ist mindestens ein Fehler aufgetreten. Die Fehler werden in der JavaScript-Konsole des Browsers angezeigt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274134455732864902)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS_BTN'
,p_message_language=>'de'
,p_message_text=>'JavaScript-Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274229328427864968)
,p_name=>'DEVELOPER_TOOLBAR_NO_BUILDER'
,p_message_language=>'de'
,p_message_text=>unistr('Diese Funktionalit\00E4t erfordert, dass das Application Express App Builder-Fenster ge\00F6ffnet ist. M\00F6chten Sie den Builder in diesem Fenster \00F6ffnen?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274209207027864954)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS'
,p_message_language=>'de'
,p_message_text=>'Optionen der Entwicklersymbolleiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274217573381864960)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_AUTO_HIDE'
,p_message_language=>'de'
,p_message_text=>'Automatisch ausblenden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274217785228864960)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_DISPLAY'
,p_message_language=>'de'
,p_message_text=>'Anzeigeposition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274217649017864960)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_ICONS_ONLY'
,p_message_language=>'de'
,p_message_text=>'Nur Symbole anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274217936429864960)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_BOTTOM'
,p_message_language=>'de'
,p_message_text=>'Unten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274217820824864960)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_LEFT'
,p_message_language=>'de'
,p_message_text=>'Links'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274218039030864960)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_RIGHT'
,p_message_language=>'de'
,p_message_text=>'Rechts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274225678781864966)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_TOP'
,p_message_language=>'de'
,p_message_text=>'Oben'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274140551635864906)
,p_name=>'DEVELOPER_TOOLBAR_PAGE_INFO'
,p_message_language=>'de'
,p_message_text=>'Seiteninformationen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274140780024864906)
,p_name=>'DEVELOPER_TOOLBAR_PERF_TITLE'
,p_message_language=>'de'
,p_message_text=>unistr('Timing f\00FCr Seitenperformance')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274209385942864954)
,p_name=>'DEVELOPER_TOOLBAR_QUICK_EDIT'
,p_message_language=>'de'
,p_message_text=>'Schnellbearbeitung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274140665747864906)
,p_name=>'DEVELOPER_TOOLBAR_SHOW_PERF'
,p_message_language=>'de'
,p_message_text=>unistr('Timing f\00FCr Seitenanzeige')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274757410581865343)
,p_name=>'DEVELOPER_TOOLBAR_THEME_ROLLER'
,p_message_language=>'de'
,p_message_text=>'Theme Roller'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274217456815864960)
,p_name=>'DEVELOPER_TOOLBAR_TITLE'
,p_message_language=>'de'
,p_message_text=>'Entwicklersymbolleiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273913936363864734)
,p_name=>'DEVELOPMENT_TASK'
,p_message_language=>'de'
,p_message_text=>'Entwicklungsaufgabe'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274097081384864875)
,p_name=>'DIAL_CHART_ALERT_VALUE'
,p_message_language=>'de'
,p_message_text=>'Alert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274096998893864875)
,p_name=>'DIAL_CHART_HIGH_VALUE'
,p_message_language=>'de'
,p_message_text=>'Hoch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274096843171864875)
,p_name=>'DIAL_CHART_LOW_VALUE'
,p_message_language=>'de'
,p_message_text=>'Mindestwert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273417179240864393)
,p_name=>'DIAL_PCT'
,p_message_language=>'de'
,p_message_text=>'Dial (Prozent)'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273498693430864448)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATIONS'
,p_message_language=>'de'
,p_message_text=>'Anwendungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273501201665864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTH'
,p_message_language=>'de'
,p_message_text=>'Authentifizierungsschemas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273501396232864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTHORIZATION'
,p_message_language=>'de'
,p_message_text=>'Autorisierungsschemas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273500452232864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BC_ENTRIES'
,p_message_language=>'de'
,p_message_text=>unistr('Eintr\00E4ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273500344477864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BREADCRUMBS'
,p_message_language=>'de'
,p_message_text=>'Navigationspfade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274799224737865373)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BUILD_OPTIONS'
,p_message_language=>'de'
,p_message_text=>'Erstelloptionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273500087085864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_COMPUTATIONS'
,p_message_language=>'de'
,p_message_text=>'Anwendungsberechnungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273500294116864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Anwendungselemente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273500525836864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LISTS'
,p_message_language=>'de'
,p_message_text=>'Listen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273500629285864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LIST_ENTRIES'
,p_message_language=>'de'
,p_message_text=>unistr('Eintr\00E4ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273500747014864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOVS'
,p_message_language=>'de'
,p_message_text=>'Werteliste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273436705674864406)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_COLS'
,p_message_language=>'de'
,p_message_text=>'Wertelistenspalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273500810236864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_ENTRIES'
,p_message_language=>'de'
,p_message_text=>unistr('Eintr\00E4ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273500986595864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_NAV_BAR'
,p_message_language=>'de'
,p_message_text=>'Navigationsleisten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273498737141864448)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGES'
,p_message_language=>'de'
,p_message_text=>'Seiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273499920466864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BRANCHES'
,p_message_language=>'de'
,p_message_text=>'Verzweigungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273499125821864448)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BUTTONS'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4chen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273886913520864715)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHARTS'
,p_message_language=>'de'
,p_message_text=>'Diagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273887149190864715)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_A'
,p_message_language=>'de'
,p_message_text=>'Achsen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273887068369864715)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_S'
,p_message_language=>'de'
,p_message_text=>'Reihe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273499624625864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_COMP'
,p_message_language=>'de'
,p_message_text=>'Berechnungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273545833283864479)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA'
,p_message_language=>'de'
,p_message_text=>'Dynamische Aktionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273545924556864479)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA_ACTS'
,p_message_language=>'de'
,p_message_text=>'Dynamische Aktion - Aktionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274318540992865035)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5'
,p_message_language=>'de'
,p_message_text=>'Flash 5-Diagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274318612156865035)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5_S'
,p_message_language=>'de'
,p_message_text=>'Reihe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273499234619864448)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_CH'
,p_message_language=>'de'
,p_message_text=>'Flash-Diagramme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273499350484864448)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_S'
,p_message_language=>'de'
,p_message_text=>'Reihe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273499465336864448)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR'
,p_message_language=>'de'
,p_message_text=>'IR-Regionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273499586619864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR_COL'
,p_message_language=>'de'
,p_message_text=>'Berichtsspalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273498933551864448)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Seitenelemente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273499890985864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_PROC'
,p_message_language=>'de'
,p_message_text=>'Prozesse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273498887211864448)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REGIONS'
,p_message_language=>'de'
,p_message_text=>'Regionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274610668569865240)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REG_COLS'
,p_message_language=>'de'
,p_message_text=>'Spalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273499010350864448)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_RPT_COLS'
,p_message_language=>'de'
,p_message_text=>'Berichtsspalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274706104194865307)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_TREES'
,p_message_language=>'de'
,p_message_text=>unistr('B\00E4ume')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273499788720864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_VAL'
,p_message_language=>'de'
,p_message_text=>'Validierungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273501073713864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PARENT_TABS'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCbergeordnete Registerkarten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273500178363864449)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PROCESSES'
,p_message_language=>'de'
,p_message_text=>'Anwendungsprozesse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274737335688865329)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_LAYOUTS'
,p_message_language=>'de'
,p_message_text=>'Berichtslayouts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274738189123865329)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QRY_STMTS'
,p_message_language=>'de'
,p_message_text=>'SQL-Anweisungen der Berichtsabfrage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274737217325865329)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QUERIES'
,p_message_language=>'de'
,p_message_text=>'Berichtsabfragen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274676263906865286)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Anwendungseinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273501498767864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SHORTCUTS'
,p_message_language=>'de'
,p_message_text=>'Shortcuts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273496600632864447)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_STATIC_FILES'
,p_message_language=>'de'
,p_message_text=>'Anwendungsdateien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273502926156864451)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUBSTITUTIONS'
,p_message_language=>'de'
,p_message_text=>'Ersetzungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274798950398865372)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJECTS'
,p_message_language=>'de'
,p_message_text=>unistr('Unterst\00FCtzende Objekte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274799055747865373)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_BOPT'
,p_message_language=>'de'
,p_message_text=>unistr('Unterst\00FCtzende Objekte - Erstelloptionen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273502793734864451)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_CHCK'
,p_message_language=>'de'
,p_message_text=>unistr('Objektvalidierungen unterst\00FCtzen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273502885496864451)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_SCR'
,p_message_language=>'de'
,p_message_text=>unistr('Objektskripts unterst\00FCtzen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273501146669864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TABS'
,p_message_language=>'de'
,p_message_text=>'Registerkarten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273501858470864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BC'
,p_message_language=>'de'
,p_message_text=>unistr('Templates f\00FCr Navigationspfad')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273501953291864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BUTTON'
,p_message_language=>'de'
,p_message_text=>unistr('Templates f\00FCr Schaltfl\00E4chen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273502023386864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_CALENDAR'
,p_message_language=>'de'
,p_message_text=>'Kalendertemplates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273572399459864497)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_GRID'
,p_message_language=>'de'
,p_message_text=>'Grid-Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273502155534864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LABEL'
,p_message_language=>'de'
,p_message_text=>'Labeltemplates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273502207403864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LIST'
,p_message_language=>'de'
,p_message_text=>'Listentemplate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273502366813864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_PAGE'
,p_message_language=>'de'
,p_message_text=>'Seitentemplates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273502403433864451)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_POPUPLOV'
,p_message_language=>'de'
,p_message_text=>unistr('Templates f\00FCr Popup-Wertelisten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273502575825864451)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REGION'
,p_message_language=>'de'
,p_message_text=>'Regionstemplates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273502642774864451)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REPORT'
,p_message_language=>'de'
,p_message_text=>'Berichtstemplates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273501764628864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEMES'
,p_message_language=>'de'
,p_message_text=>'Themes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273478803400864435)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_FILES'
,p_message_language=>'de'
,p_message_text=>'Theme-Dateien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273424993366864398)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_STYLES'
,p_message_language=>'de'
,p_message_text=>'Theme-Stile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273946016579864756)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANSLATIONS'
,p_message_language=>'de'
,p_message_text=>'Textnachrichten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273471336556864429)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_DYNAMIC'
,p_message_language=>'de'
,p_message_text=>unistr('Dynamische \00DCbersetzungen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273471409041864430)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_REPOS'
,p_message_language=>'de'
,p_message_text=>unistr('\00DCbersetzbarer Text')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273501616521864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TREES'
,p_message_language=>'de'
,p_message_text=>unistr('B\00E4ume')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273501577463864450)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_WEB_SERVICES'
,p_message_language=>'de'
,p_message_text=>'Webservices'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274697393366865301)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_ROLES'
,p_message_language=>'de'
,p_message_text=>'Rollen Zugriffskontrolle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274697424596865301)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USERS'
,p_message_language=>'de'
,p_message_text=>'Zugriffskontrollbenutzer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273987773778864798)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USER_ROLES'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzerrollenzuweisung f\00FCr Zugriffskontrolle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274741077633865331)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_CONCATENATED_FILES'
,p_message_language=>'de'
,p_message_text=>'Verkettete Dateien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273894964857864720)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILES'
,p_message_language=>'de'
,p_message_text=>unistr('Profile f\00FCr Datenparsing')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273895073262864720)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILE_COLS'
,p_message_language=>'de'
,p_message_text=>unistr('Profilspalten f\00FCr Datenparsing')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274770701237865352)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DEVELOPER_COMMENTS'
,p_message_language=>'de'
,p_message_text=>'Entwicklerkommentare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274306372875865026)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE'
,p_message_language=>'de'
,p_message_text=>'Datenladetabelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274294570001865018)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLES'
,p_message_language=>'de'
,p_message_text=>'Datenladetabellen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274294696110865018)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_LOOKUPS'
,p_message_language=>'de'
,p_message_text=>'Datenladetabellen-Lookups'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274294706315865018)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_RULES'
,p_message_language=>'de'
,p_message_text=>unistr('Transformationsregeln f\00FCr Datenladetabellen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273431729569864403)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CALENDARS'
,p_message_language=>'de'
,p_message_text=>'Kalenderseiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274210195880864955)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IGS'
,p_message_language=>'de'
,p_message_text=>'Interaktive Grid-Regionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274210259789864955)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COLUMNS'
,p_message_language=>'de'
,p_message_text=>'Berichtsspalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274210333101864955)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COL_GROUPS'
,p_message_language=>'de'
,p_message_text=>'Spaltengruppen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273519039446864461)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGINS'
,p_message_language=>'de'
,p_message_text=>'Plug-ins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273519165569864461)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTRIBUTES'
,p_message_language=>'de'
,p_message_text=>'Attribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273944682454864755)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTR_VALUES'
,p_message_language=>'de'
,p_message_text=>'Werte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273577117883864500)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_EVENTS'
,p_message_language=>'de'
,p_message_text=>'Ereignisse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273521546174864463)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_FILES'
,p_message_language=>'de'
,p_message_text=>'Dateien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273997096100864804)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ITEM_FILTERS'
,p_message_language=>'de'
,p_message_text=>'Filteroperatoren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274799199793865373)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Komponenteneinstellungen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274711926166865311)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_STD_ATTRS'
,p_message_language=>'de'
,p_message_text=>unistr('Metadaten f\00FCr Plug-in-Standardattribut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273894861318864720)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_REMOTE_SQL'
,p_message_language=>'de'
,p_message_text=>unistr('REST-f\00E4hige SQL-Server')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274610519760865240)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPTIONS'
,p_message_language=>'de'
,p_message_text=>'Templateoptionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274798855877865372)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GROUPS'
,p_message_language=>'de'
,p_message_text=>'Templateoptionsgruppen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274683129681865291)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GRP'
,p_message_language=>'de'
,p_message_text=>'Templateoptionsgruppe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274754290843865341)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_PAGE_DP'
,p_message_language=>'de'
,p_message_text=>'Anzeigepunkte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274754357348865341)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_REGION_DP'
,p_message_language=>'de'
,p_message_text=>'Anzeigepunkte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273575520892864499)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_THEME_DISPLAY_POINTS'
,p_message_language=>'de'
,p_message_text=>'Theme-Anzeigepunkte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273496520406864447)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_USER_INTERFACES'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzeroberfl\00E4chen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273895561163864721)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_COMP_PARAMS'
,p_message_language=>'de'
,p_message_text=>unistr('Webquellenparameter f\00FCr Komponente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273895291548864721)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_MODULES'
,p_message_language=>'de'
,p_message_text=>'Webquellenmodule'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273895360719864721)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_OPERATIONS'
,p_message_language=>'de'
,p_message_text=>unistr('Webquellenvorg\00E4nge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273895483587864721)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_PARAMETERS'
,p_message_language=>'de'
,p_message_text=>'Webquellenparameter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273895189026864720)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_SERVERS'
,p_message_language=>'de'
,p_message_text=>'Webquellen-Remoteserver'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274714418211865313)
,p_name=>'DISABLED_NEXT_BUTTON'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4che "Weiter" deaktiviert')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274714325137865313)
,p_name=>'DISABLED_PREVIOUS_BUTTON'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4che "Zur\00FCck" deaktiviert')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274057740133864847)
,p_name=>'DISABLE_TRIGGER'
,p_message_language=>'de'
,p_message_text=>'Deaktivieren von Trigger %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273655040463864552)
,p_name=>'DISPLAY_CONDITION'
,p_message_language=>'de'
,p_message_text=>'Anzeigebedingung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273655250417864552)
,p_name=>'DISPLAY_CONDITION_TEXT'
,p_message_language=>'de'
,p_message_text=>'Bedingungstext anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274122975905864893)
,p_name=>'DISPLAY_ORDER_LABEL'
,p_message_language=>'de'
,p_message_text=>'Anzeigereihenfolge: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273525531226864466)
,p_name=>'DISPLAY_TYPE'
,p_message_language=>'de'
,p_message_text=>'Anzeigetyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274798523135865372)
,p_name=>'DISPLAY_VALUE.N'
,p_message_language=>'de'
,p_message_text=>'Anzeigewert: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274709710759865309)
,p_name=>'DISTINCT_PAGES'
,p_message_language=>'de'
,p_message_text=>'Eindeutige Seiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274709828241865309)
,p_name=>'DISTINCT_USERS'
,p_message_language=>'de'
,p_message_text=>'Eindeutige Benutzer'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273436489964864406)
,p_name=>'DML_FORM'
,p_message_language=>'de'
,p_message_text=>'DML-Form'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273743371742864613)
,p_name=>'DO NOT UPDATE PAGE ITEMS'
,p_message_language=>'de'
,p_message_text=>'DO_NOT_UPDATE_PAGE_ITEMS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273936497815864749)
,p_name=>'DOC_IMPACT'
,p_message_language=>'de'
,p_message_text=>'Dokumentationsauswirkung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273937689194864750)
,p_name=>'DOC_STATUS'
,p_message_language=>'de'
,p_message_text=>'Dokumentationsstatus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273937878830864750)
,p_name=>'DOC_WRITER'
,p_message_language=>'de'
,p_message_text=>'Schreiber der Dokumentation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273815355059864664)
,p_name=>'DOWN'
,p_message_language=>'de'
,p_message_text=>'Nach unten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273446875084864413)
,p_name=>'DOWNLOAD'
,p_message_language=>'de'
,p_message_text=>'Herunterladen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273945882991864756)
,p_name=>'DOWNLOAD_LINK_TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Link-Text f\00FCr Download')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273743045307864613)
,p_name=>'DO_NOT_UPDATE_APPLICATION_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Keine Anwendungselemente aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273743153048864613)
,p_name=>'DO_NOT_UPDATE_DATA_ENTRY_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Keine Dateneintragselemente aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273743281662864613)
,p_name=>'DO_NOT_UPDATE_DISPLAY_ONLY_ITEMS'
,p_message_language=>'de'
,p_message_text=>unistr('Keine schreibgesch\00FCtzten Elemente aktualisieren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273742947659864613)
,p_name=>'DO_NOT_UPDATE_PAGES'
,p_message_language=>'de'
,p_message_text=>'Keine Seiten aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273744594588864614)
,p_name=>'DO_NOT_UPDATE_PAGE_ITEMS'
,p_message_language=>'de'
,p_message_text=>'Keine Seitenelemente aktualisieren'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273623551056864531)
,p_name=>'DRAG_AND_DROP'
,p_message_language=>'de'
,p_message_text=>'Drag-and-Drop'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273516264550864459)
,p_name=>'DRILLDOWN'
,p_message_language=>'de'
,p_message_text=>'Mehr Verzweigungsebenen anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273516142599864459)
,p_name=>'DRILLUP'
,p_message_language=>'de'
,p_message_text=>'Weniger Verzweigungsebenen anzeigen'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273671811906864563)
,p_name=>'DRIVEN'
,p_message_language=>'de'
,p_message_text=>'gesteuert'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274057563740864847)
,p_name=>'DROP TRIGGER'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen von Trigger %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274056476440864846)
,p_name=>'DROP_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('L\00F6schen von Spalte %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274289821517865014)
,p_name=>'DS_ACCESS_METHOD'
,p_message_language=>'de'
,p_message_text=>'Zugriffsmethode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274289656265865014)
,p_name=>'DS_BIND_VARIABLE_NAME'
,p_message_language=>'de'
,p_message_text=>'Bind-Variablenname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274290049621865015)
,p_name=>'DS_HANDLER'
,p_message_language=>'de'
,p_message_text=>'Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274290482019865015)
,p_name=>'DS_ITEMS_PER_PAGE'
,p_message_language=>'de'
,p_message_text=>'Elemente pro Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274290277749865015)
,p_name=>'DS_MIME_TYPES_ALLOWED'
,p_message_language=>'de'
,p_message_text=>unistr('Zul\00E4ssige MIME-Typen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274290361221865015)
,p_name=>'DS_ORIGINS_ALLOWED'
,p_message_language=>'de'
,p_message_text=>unistr('Ursprung zul\00E4ssig')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274289965695865015)
,p_name=>'DS_PARAMETER_TYPE'
,p_message_language=>'de'
,p_message_text=>'Parametertyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274290590245865015)
,p_name=>'DS_SECURITY_CONSTRAINT'
,p_message_language=>'de'
,p_message_text=>'Sicherheits-Constraint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274289760836865014)
,p_name=>'DS_SOURCE'
,p_message_language=>'de'
,p_message_text=>'Quelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274290180673865015)
,p_name=>'DS_SOURCE_TYPE'
,p_message_language=>'de'
,p_message_text=>'Quelltyp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274290685690865015)
,p_name=>'DS_URI_PREFIX'
,p_message_language=>'de'
,p_message_text=>unistr('URI-Pr\00E4fix')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274289334534865014)
,p_name=>'DS_URI_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'URI-Template'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274738294304865329)
,p_name=>'DUE'
,p_message_language=>'de'
,p_message_text=>unistr('F\00E4llig')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273937479203864750)
,p_name=>'DUE_DATE'
,p_message_language=>'de'
,p_message_text=>unistr('F\00E4llig am')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273917276062864736)
,p_name=>'DUPLICATE'
,p_message_language=>'de'
,p_message_text=>'Duplizieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274710636889865310)
,p_name=>'DUPLICATE_USER'
,p_message_language=>'de'
,p_message_text=>'Doppelt in Liste vorhandener Benutzer'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274359806155865064)
,p_name=>'DUP_USER'
,p_message_language=>'de'
,p_message_text=>'Doppelter Benutzername in Liste.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273425320123864398)
,p_name=>'DYNAMIC ACTION'
,p_message_language=>'de'
,p_message_text=>'Dynamische Aktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273425286106864398)
,p_name=>'DYNAMIC ACTIONS'
,p_message_language=>'de'
,p_message_text=>'Dynamische Aktionen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273435090527864405)
,p_name=>'DYNAMIC_FORM'
,p_message_language=>'de'
,p_message_text=>'Dynamische Form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273561243505864489)
,p_name=>'DYNAMIC_HTML'
,p_message_language=>'de'
,p_message_text=>'Dynamische HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273622364902864530)
,p_name=>'DYNAMIC_QUERY'
,p_message_language=>'de'
,p_message_text=>'Interaktiver Bericht'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273422837632864397)
,p_name=>'DYNAMIC_REFERENCE'
,p_message_language=>'de'
,p_message_text=>'Dynamische Referenz'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273731250832864604)
,p_name=>'EASY_REPORT.INVALID_CONDITION'
,p_message_language=>'de'
,p_message_text=>unistr('Durch die hinzugef\00FCgte Bedingung wurde die Abfrage ung\00FCltig.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273516334473864460)
,p_name=>'EDIT'
,p_message_language=>'de'
,p_message_text=>'Bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273430538135864402)
,p_name=>'EDIT PAGE GROUP'
,p_message_language=>'de'
,p_message_text=>'Seitengruppe bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273980743663864793)
,p_name=>'EDITOR_EXIT'
,p_message_language=>'de'
,p_message_text=>unistr('Wenn Sie auf OK klicken, gehen nicht gespeicherte \00C4nderungen verloren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273461812899864423)
,p_name=>'EDIT_ALL'
,p_message_language=>'de'
,p_message_text=>'Alle bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273732437577864605)
,p_name=>'EDIT_ALL_PAGE_DEFINITION_ATTRIBUTES'
,p_message_language=>'de'
,p_message_text=>'Alle Seitendefinitionsattribute bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273974947914864788)
,p_name=>'EDIT_ALL_REGION'
,p_message_language=>'de'
,p_message_text=>'Alle Elemente in dieser Region bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273901041574864725)
,p_name=>'EDIT_APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273995148448864803)
,p_name=>'EDIT_ATTRIBUTE'
,p_message_language=>'de'
,p_message_text=>'Attribut bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274649980444865267)
,p_name=>'EDIT_AUTHENTICATION'
,p_message_language=>'de'
,p_message_text=>'Authentifizierung bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273985199599864796)
,p_name=>'EDIT_COMPONENT'
,p_message_language=>'de'
,p_message_text=>'Komponente bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273995229190864803)
,p_name=>'EDIT_COMPONENT_DEF'
,p_message_language=>'de'
,p_message_text=>'Komponentendefinition bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274097795588864876)
,p_name=>'EDIT_LINK_TEXT'
,p_message_language=>'de'
,p_message_text=>'%0 bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273995075209864803)
,p_name=>'EDIT_LIST_DEV'
,p_message_language=>'de'
,p_message_text=>'Listendefinition bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274724663431865320)
,p_name=>'EDIT_LOCK'
,p_message_language=>'de'
,p_message_text=>'Bearbeitungssperre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273860523957864696)
,p_name=>'EDIT_PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273734990894864607)
,p_name=>'EDIT_PAGE_ATTRIBUTES'
,p_message_language=>'de'
,p_message_text=>'Seitenattribute bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274358316394865062)
,p_name=>'EDIT_PROFILE'
,p_message_language=>'de'
,p_message_text=>'Profil bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274379250999865077)
,p_name=>'EDIT_PROFILE.USER_NO_PRIV_ERR'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzer 0% hat keine Berechtigung zur Aktualisierung der Informationen f\00FCr einen anderen Benutzer.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273984966712864796)
,p_name=>'EDIT_REGION'
,p_message_language=>'de'
,p_message_text=>'Region bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274070113340864855)
,p_name=>'EDIT_REPORTING_TIMEFRAME'
,p_message_language=>'de'
,p_message_text=>unistr('Zeitrahmen f\00FCr Berichtserstellung bearbeiten')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273985047339864796)
,p_name=>'EDIT_REPORT_COLS'
,p_message_language=>'de'
,p_message_text=>'Berichtsspalten bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274351762909865058)
,p_name=>'EDIT_REPORT_DIALOG_CLOSED_DA'
,p_message_language=>'de'
,p_message_text=>'Bericht bearbeiten - Dialog geschlossen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273973910257864788)
,p_name=>'EDIT_SYSTEM_MESSAGE'
,p_message_language=>'de'
,p_message_text=>'Systemmeldung bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274312942734865031)
,p_name=>'EDIT_TAB'
,p_message_language=>'de'
,p_message_text=>'Register bearbeiten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273996743440864804)
,p_name=>'EDIT_THIS_ATTRIBUTE'
,p_message_language=>'de'
,p_message_text=>'Dieses Attribut bearbeiten'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273837663910864680)
,p_name=>'ELAPSED_TIME'
,p_message_language=>'de'
,p_message_text=>'Verstrichene Zeit'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273924617350864741)
,p_name=>'EMAIL.TEMPLATE.FOOTER_EXAMPLE'
,p_message_language=>'de'
,p_message_text=>'<a href="#MY_APPLICATION_LINK#">Gehen Sie zu "Meine Anwendung", und verwalten Sie Ihre E-Mail-Voreinstellungen</a>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273931857564864746)
,p_name=>'EMAIL.TEMPLATE.HEADER_EXAMPLE'
,p_message_language=>'de'
,p_message_text=>'<b style="font-size: 24px;">Meine Anwendung</b>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274056869459864846)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.EV'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>Hallo #INVITEE#,</b><br>',
'<br>',
'dies ist eine Erinnerung an ein bevorstehendes Ereignis, zu dem Sie eingeladen wurden. Die Ereignisdetails lauten wie folgt:<br>',
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Organisator</th>',
'    <td>#ORGANIZER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Ereignisdatum</th>',
'    <td>#EVENT_DATE#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Startzeit</th>',
'    <td>#START_TIME#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Dauer</th>',
'    <td>#DURATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Ort</th>',
'    <td>#LOCATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">URL</th>',
'    <td><a href="#URL_LINK#">#URL_NAME#</a></td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Notizen</th>',
'    <td>#NOTES#</td>',
'  </tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273924573628864741)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.OD'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>Hallo #CUSTOMER_NAME#</b>,<br>',
'<br>',
unistr('vielen Dank f\00FCr Ihre Bestellung.<br>'),
'<br>',
'<b>Bestelldetails</b><br>',
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Bestelldatum</th>',
'    <td>#ORDER_DATE#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Bestellnummer</th>',
'    <td>#ORDER_NUMBER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Versand an</th>',
'    <td>#SHIP_TO#</td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Versandadresse</th>',
'    <td>',
'      #SHIPPING_ADDRESS_LINE_1#<br>',
'      #SHIPPING_ADDRESS_LINE_2#',
'    </td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Bestellte Produkte</th>',
'    <td>#ITEMS_ORDERED#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Bestellsumme</th>',
'    <td>#ORDER_TOTAL#</td>',
'  </tr>',
'</table>',
'<br>',
'<br>',
unistr('M\00F6chten Sie Ihre Bestellung \00E4ndern? <a href="#ORDER_URL#">Verwalten Sie Ihre Bestellung #ORDER_NUMBER# hier.</a>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274352038206865058)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.SO'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hallo #SERVICE_USER#,<br>',
'<br>',
unistr('denken Sie daran, dass f\00FCr Ihren Service #SERVICE_NAME# ein geplanter Ausfall bevorsteht.<br>'),
unistr('Der Ausfall beginnt plangem\00E4\00DF um #OUTAGE_START# und dauert voraussichtlich #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.<br>'),
'<br>',
unistr('W\00E4hrend dieses geplanten Ausfalls wird Folgendes durchgef\00FChrt:<br>'),
'#OUTAGE_REASON#<br>',
'<br>',
'<br>',
'Wenden Sie sich bei Problemen im Zusammenhang mit diesem Ausfall an #OUTAGE_CONTACT#.<br>',
'<br>',
unistr('Vielen Dank f\00FCr Ihr Verst\00E4ndnis,<br>'),
'#SERVICE_TEAM#',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274351456347865058)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.EV'
,p_message_language=>'de'
,p_message_text=>'Ereigniserinnerung: #EVENT_NAME#'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274351521778865058)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.OD'
,p_message_language=>'de'
,p_message_text=>unistr('Bestellung (#ORDER_NUMBER#) best\00E4tigt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274057034784864846)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.EV'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hallo #INVITEE#,',
'',
unistr('diese E-Mail soll Sie an ein bevorstehendes Ereignis erinnern, mit dem Sie verkn\00FCpft sind.'),
'',
'Ereignisdatum: #EVENT_DATE#',
'Startzeit: #START_TIME#',
'Dauer:   #DURATION#',
'Organisator:  #ORGANIZER#',
'Ort:   #LOCATION#',
'URL:        #URL_NAME# (#URL_LINK#)',
'Notizen:      #NOTES#',
'',
'Weitere Ereignisdetails finden Sie hier: #EVENT_LINK#'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274056940394864846)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.OD'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hallo #CUSTOMER_NAME#,',
'',
unistr('vielen Dank f\00FCr Ihre Bestellung.'),
'',
'Bestelldetails',
'--------------------------------------------------------------------------------',
'  Bestelldatum: #ORDER_DATE#',
'  Bestellnummer: #ORDER_NUMBER#',
'  Versand an: #SHIP_TO#',
'  Versandadresse: #SHIPPING_ADDRESS_LINE_1#',
'                    #SHIPPING_ADDRESS_LINE_2#',
'  Bestellte Produkte: #ITEMS_ORDERED#',
'  Bestellsumme:      #ORDER_TOTAL#',
'--------------------------------------------------------------------------------',
'',
unistr('M\00F6chten Sie Ihre Bestellung \00E4ndern? Verwalten Sie Ihre Bestellung #ORDER_NUMBER# hier: #ORDER_URL#')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274351917459865058)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.SO'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hallo #SERVICE_USER#,',
'',
unistr('denken Sie daran, dass f\00FCr Ihren Service #SERVICE_NAME# ein geplanter Ausfall bevorsteht.'),
unistr('Der Ausfall beginnt plangem\00E4\00DF um #OUTAGE_START# und dauert voraussichtlich #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.'),
'',
unistr('W\00E4hrend dieses geplanten Ausfalls wird Folgendes durchgef\00FChrt:'),
'#OUTAGE_REASON#',
'',
'Wenden Sie sich bei Problemen im Zusammenhang mit diesem Ausfall an #OUTAGE_CONTACT#.',
'',
unistr('Vielen Dank f\00FCr Ihr Verst\00E4ndnis,'),
'#SERVICE_TEAM#',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273591865254864510)
,p_name=>'EMAIL_NOT_FOUND'
,p_message_language=>'de'
,p_message_text=>'E-Mail-Adresse "%0" wurde nicht gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273462868923864424)
,p_name=>'EMAIL_SENT_BY'
,p_message_language=>'de'
,p_message_text=>'Diese E-Mail wurde von %0 gesendet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274360000271865064)
,p_name=>'EMAIL_TOO_LONG'
,p_message_language=>'de'
,p_message_text=>unistr('Die E-Mail-Adresse ist zu lang. Sie darf h\00F6chstens 240 Zeichen enthalten.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273978854310864791)
,p_name=>'ENABLE_DEBUGGING'
,p_message_language=>'de'
,p_message_text=>'Debugging aktivieren (Ja oder Nein)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274057664132864847)
,p_name=>'ENABLE_TRIGGER'
,p_message_language=>'de'
,p_message_text=>'Aktivieren von Trigger %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273464492195864425)
,p_name=>'ENCRYPTION_INPUT_TOO_LONG'
,p_message_language=>'de'
,p_message_text=>unistr('Die L\00E4nge des zu verschl\00FCsselnden Wertes darf 4000 Byte nicht \00FCberschreiten.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273462699721864424)
,p_name=>'END_USER'
,p_message_language=>'de'
,p_message_text=>'Endbenutzer'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273913593041864733)
,p_name=>'ENHANCEMENT_REQUEST'
,p_message_language=>'de'
,p_message_text=>'Erweiterungsanforderung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274379921933865078)
,p_name=>'ENHANCEMENT_REQUEST_DASH'
,p_message_language=>'de'
,p_message_text=>'Erweiterungsanforderungen: %1 von %0 geschlossen'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273916741624864735)
,p_name=>'ENTERED'
,p_message_language=>'de'
,p_message_text=>'Eingegeben '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273429108652864401)
,p_name=>'ENTER_WEBSHEETS_CREDENTIALS'
,p_message_language=>'de'
,p_message_text=>unistr('Zugangsdaten f\00FCr Websheets eingeben.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273902767952864726)
,p_name=>'ENTRY LINK'
,p_message_language=>'de'
,p_message_text=>'Eintrags-Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273902641696864726)
,p_name=>'ENTRY TEXT'
,p_message_language=>'de'
,p_message_text=>'Eintragstext'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273817669282864666)
,p_name=>'ERROR'
,p_message_language=>'de'
,p_message_text=>'Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273961305566864767)
,p_name=>'ERROR PAGE TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Template f\00FCr Fehlerseite')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273813012277864663)
,p_name=>'ERRORPAGE'
,p_message_language=>'de'
,p_message_text=>'Fehlermeldungsseite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273975557327864789)
,p_name=>'ERRORS'
,p_message_language=>'de'
,p_message_text=>'Fehler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273903935375864727)
,p_name=>'ERROR_ICON'
,p_message_language=>'de'
,p_message_text=>'Fehlersymbol'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274736651584865328)
,p_name=>'ERROR_MESSAGE'
,p_message_language=>'de'
,p_message_text=>'Fehlermeldung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274063312937864851)
,p_name=>'ERROR_SET_ITEM_STATE_FOR_PPR_REGION'
,p_message_language=>'de'
,p_message_text=>'Der Seitenelement-Quellwert zur Aktualisierung der Seitenbestandteil-Region kann nicht festgelegt werden'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273896035080864721)
,p_name=>'ESCAPED_COL_TOO_LARGE'
,p_message_language=>'de'
,p_message_text=>unistr('<br><b>Escape-Daten \00FCberschreiten den zul\00E4ssigen Grenzwert. Die Ergebnisse werden auf 32 KB gek\00FCrzt </b>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273671052760864563)
,p_name=>'ESCAPE_SC'
,p_message_language=>'de'
,p_message_text=>'Escape bei Sonderzeichen'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273938988863864751)
,p_name=>'ESTIMATED_EFFORT_IN_HOURS'
,p_message_language=>'de'
,p_message_text=>unistr('Gesch\00E4tzter Aufwand in Stunden')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274289504404865014)
,p_name=>'ETAG_QUERY'
,p_message_language=>'de'
,p_message_text=>'ETag-Abfrage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274289464306865014)
,p_name=>'ETAG_TYPE'
,p_message_language=>'de'
,p_message_text=>'ETag-Typ'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273914173056864734)
,p_name=>'EVENT'
,p_message_language=>'de'
,p_message_text=>'Ereignis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274356508155865061)
,p_name=>'EVENT.APEX.APEXAFTERREFRESH'
,p_message_language=>'de'
,p_message_text=>'Nach Aktualisierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274357142788865062)
,p_name=>'EVENT.APEX.APEXBEFOREPAGESUBMIT'
,p_message_language=>'de'
,p_message_text=>'Vor Seitenweiterleitung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274356463845865061)
,p_name=>'EVENT.APEX.APEXBEFOREREFRESH'
,p_message_language=>'de'
,p_message_text=>'Vor Aktualisierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274360782142865064)
,p_name=>'EVENT.BROWSER'
,p_message_language=>'de'
,p_message_text=>'Browserereignisse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273727556067864602)
,p_name=>'EVENT.BROWSER.APEXDOUBLETAP'
,p_message_language=>'de'
,p_message_text=>'Doppeltippen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273727709093864602)
,p_name=>'EVENT.BROWSER.APEXPAN'
,p_message_language=>'de'
,p_message_text=>'Schwenken'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273727622466864602)
,p_name=>'EVENT.BROWSER.APEXPRESS'
,p_message_language=>'de'
,p_message_text=>unistr('Dr\00FCcken')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273727878387864602)
,p_name=>'EVENT.BROWSER.APEXSWIPE'
,p_message_language=>'de'
,p_message_text=>'Streichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273727424147864602)
,p_name=>'EVENT.BROWSER.APEXTAP'
,p_message_language=>'de'
,p_message_text=>'Tippen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274355955601865061)
,p_name=>'EVENT.BROWSER.CHANGE'
,p_message_language=>'de'
,p_message_text=>unistr('\00C4ndern')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274355267641865060)
,p_name=>'EVENT.BROWSER.CLICK'
,p_message_language=>'de'
,p_message_text=>'Klick'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274355322495865060)
,p_name=>'EVENT.BROWSER.DBLCLICK'
,p_message_language=>'de'
,p_message_text=>'Doppelklick'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274354761476865060)
,p_name=>'EVENT.BROWSER.FOCUSIN'
,p_message_language=>'de'
,p_message_text=>'Fokus erhalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274354678191865060)
,p_name=>'EVENT.BROWSER.FOCUSOUT'
,p_message_language=>'de'
,p_message_text=>'Fokus verlieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274356165401865061)
,p_name=>'EVENT.BROWSER.KEYDOWN'
,p_message_language=>'de'
,p_message_text=>'Taste nach unten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274356263516865061)
,p_name=>'EVENT.BROWSER.KEYPRESS'
,p_message_language=>'de'
,p_message_text=>unistr('Taste dr\00FCcken')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274356360078865061)
,p_name=>'EVENT.BROWSER.KEYUP'
,p_message_language=>'de'
,p_message_text=>'Taste loslassen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274354849652865060)
,p_name=>'EVENT.BROWSER.LOAD'
,p_message_language=>'de'
,p_message_text=>'Ressourcenladevorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274355471350865060)
,p_name=>'EVENT.BROWSER.MOUSEDOWN'
,p_message_language=>'de'
,p_message_text=>unistr('Maustaste dr\00FCcken')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274355779103865061)
,p_name=>'EVENT.BROWSER.MOUSEENTER'
,p_message_language=>'de'
,p_message_text=>'Mauseintritt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274355846244865061)
,p_name=>'EVENT.BROWSER.MOUSELEAVE'
,p_message_language=>'de'
,p_message_text=>'Mausaustritt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274355650032865061)
,p_name=>'EVENT.BROWSER.MOUSEMOVE'
,p_message_language=>'de'
,p_message_text=>'Maus bewegen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274355505115865060)
,p_name=>'EVENT.BROWSER.MOUSEUP'
,p_message_language=>'de'
,p_message_text=>'Maustaste loslassen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273428156604864400)
,p_name=>'EVENT.BROWSER.ORIENTATIONCHANGE'
,p_message_language=>'de'
,p_message_text=>unistr('Ausrichtungs\00E4nderung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274365606824865068)
,p_name=>'EVENT.BROWSER.READY'
,p_message_language=>'de'
,p_message_text=>'Seitenladevorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274354914448865060)
,p_name=>'EVENT.BROWSER.RESIZE'
,p_message_language=>'de'
,p_message_text=>'Skalieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274355070683865060)
,p_name=>'EVENT.BROWSER.SCROLL'
,p_message_language=>'de'
,p_message_text=>'Scrollen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273428279896864400)
,p_name=>'EVENT.BROWSER.SCROLLSTART'
,p_message_language=>'de'
,p_message_text=>'Bildlauf - Start'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273428397329864400)
,p_name=>'EVENT.BROWSER.SCROLLSTOP'
,p_message_language=>'de'
,p_message_text=>'Bildlauf - Stopp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274356049538865061)
,p_name=>'EVENT.BROWSER.SELECT'
,p_message_language=>'de'
,p_message_text=>unistr('Ausw\00E4hlen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273427310639864400)
,p_name=>'EVENT.BROWSER.SWIPE'
,p_message_language=>'de'
,p_message_text=>'Streichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273427401102864400)
,p_name=>'EVENT.BROWSER.SWIPELEFT'
,p_message_language=>'de'
,p_message_text=>'Nach links streichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273427505759864400)
,p_name=>'EVENT.BROWSER.SWIPERIGHT'
,p_message_language=>'de'
,p_message_text=>'Nach rechts streichen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273427107498864400)
,p_name=>'EVENT.BROWSER.TAP'
,p_message_language=>'de'
,p_message_text=>'Tippen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273427257917864400)
,p_name=>'EVENT.BROWSER.TAPHOLD'
,p_message_language=>'de'
,p_message_text=>'Tippen und halten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274355162370865060)
,p_name=>'EVENT.BROWSER.UNLOAD'
,p_message_language=>'de'
,p_message_text=>'Seitenentladevorgang'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273427960096864400)
,p_name=>'EVENT.BROWSER.VCLICK'
,p_message_language=>'de'
,p_message_text=>'Virtueller Klick'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273428084393864400)
,p_name=>'EVENT.BROWSER.VMOUSECANCEL'
,p_message_language=>'de'
,p_message_text=>unistr('Ber\00FChrung - Abbrechen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273427670692864400)
,p_name=>'EVENT.BROWSER.VMOUSEDOWN'
,p_message_language=>'de'
,p_message_text=>unistr('Ber\00FChrung - Anfang')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273427741398864400)
,p_name=>'EVENT.BROWSER.VMOUSEMOVE'
,p_message_language=>'de'
,p_message_text=>unistr('Ber\00FChrung - Bewegung')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273427874930864400)
,p_name=>'EVENT.BROWSER.VMOUSEUP'
,p_message_language=>'de'
,p_message_text=>unistr('Ber\00FChrung - Ende')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274360915976865064)
,p_name=>'EVENT.COMPONENT'
,p_message_language=>'de'
,p_message_text=>'Komponentenereignisse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273423997086864397)
,p_name=>'EVENT.CUSTOM'
,p_message_language=>'de'
,p_message_text=>'Benutzerdefiniertes Ereignis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273424079467864398)
,p_name=>'EVENT.CUSTOM.CUSTOM'
,p_message_language=>'de'
,p_message_text=>'Benutzerdefiniert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274360835068865064)
,p_name=>'EVENT.FRAMEWORK'
,p_message_language=>'de'
,p_message_text=>'Framework-Ereignisse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273984836121864796)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERCLOSEDIALOG'
,p_message_language=>'de'
,p_message_text=>'Dialog geschlossen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274751035445865338)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERREFRESH'
,p_message_language=>'de'
,p_message_text=>'Nach Aktualisierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274751124087865339)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREPAGESUBMIT'
,p_message_language=>'de'
,p_message_text=>'Vor Seitenweiterleitung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274750912657865338)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREREFRESH'
,p_message_language=>'de'
,p_message_text=>'Vor Aktualisierung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273897939367864722)
,p_name=>'EVENTS'
,p_message_language=>'de'
,p_message_text=>'Ereignisse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273937584766864750)
,p_name=>'EVENT_ID'
,p_message_language=>'de'
,p_message_text=>'Nummer Meilenstein'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273981105766864793)
,p_name=>'EXACT_SUBS'
,p_message_language=>'de'
,p_message_text=>'Exakte Ersetzungen'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274121993640864893)
,p_name=>'EXAMPLE_1'
,p_message_language=>'de'
,p_message_text=>'Beispiel 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274122084354864893)
,p_name=>'EXAMPLE_2'
,p_message_language=>'de'
,p_message_text=>'Beispiel 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274655171158865271)
,p_name=>'EXAMPLE_OF_XML_COLUMN'
,p_message_language=>'de'
,p_message_text=>unistr('Hier ein Beispiel f\00FCr die in einer XML-Datenbankspalte enthaltenen Daten.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274710568564865310)
,p_name=>'EXAMPLE_URI'
,p_message_language=>'de'
,p_message_text=>'Beispiel-URI'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274058784188864848)
,p_name=>'EXCLUDE'
,p_message_language=>'de'
,p_message_text=>unistr('Ausschlie\00DFen')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274032825495864829)
,p_name=>'EXISTING_SCHEMA_NAME'
,p_message_language=>'de'
,p_message_text=>'Vorhandener Schemaname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273971346338864774)
,p_name=>'EXISTS'
,p_message_language=>'de'
,p_message_text=>'Exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273509975855864455)
,p_name=>'EXISTS_SQL_QUERY'
,p_message_language=>'de'
,p_message_text=>'SQL-Abfrage EXISTS'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274343868876865052)
,p_name=>'EXPANDED'
,p_message_language=>'de'
,p_message_text=>'Eingeblendet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274705213046865306)
,p_name=>'EXPAND_ALL'
,p_message_language=>'de'
,p_message_text=>'Alles einblenden'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273580623227864502)
,p_name=>'EXPIRED'
,p_message_language=>'de'
,p_message_text=>'Abgelaufen'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273901220822864725)
,p_name=>'EXPLAIN PLAN'
,p_message_language=>'de'
,p_message_text=>'Explain-Plan'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273898295845864723)
,p_name=>'EXPORT'
,p_message_language=>'de'
,p_message_text=>'Exportieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274314213957865032)
,p_name=>'EXPORT REPOSITORY'
,p_message_language=>'de'
,p_message_text=>'Export-Repository'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273985504853864796)
,p_name=>'EXPORTED_FROM_ANOTHER_WORKSPACE'
,p_message_language=>'de'
,p_message_text=>'Aus einem anderen Workspace oder einer anderen Anwendung exportiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273985696256864796)
,p_name=>'EXPORTED_FROM_CURRENT_WORKSPACE'
,p_message_language=>'de'
,p_message_text=>'Aus aktuellem Workspace exportiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274065171110864852)
,p_name=>'EXPORT_APPLICATION'
,p_message_language=>'de'
,p_message_text=>'Anwendung exportieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274069733515864855)
,p_name=>'EXPORT_PKG_APP_FOR_DEPLOYMENT'
,p_message_language=>'de'
,p_message_text=>unistr('Verwenden Sie diese Links, um diese Anwendung und die entsprechenden datenbankunterst\00FCtzenden Objekte f\00FCr das Deployment in einer anderen Oracle Application Express-Installation herunterzuladen. Die heruntergeladenen Dateien sind SQL-Skripte, die aus')
||unistr(' SQL*Plus, SQL Developer oder SQL-Skripten in Oracle Application Express ausgef\00FChrt werden k\00F6nnen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274065253497864852)
,p_name=>'EXPORT_SUPPORTING_OBJECTS'
,p_message_language=>'de'
,p_message_text=>unistr('Unterst\00FCtzende Objekte exportieren')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273898537401864723)
,p_name=>'EXPORT_TYPES.APP_EXPORT'
,p_message_language=>'de'
,p_message_text=>'Anwendungsexport '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273898764184864723)
,p_name=>'EXPORT_TYPES.CSS_EXPORT'
,p_message_language=>'de'
,p_message_text=>'CSS-Export'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273898926475864723)
,p_name=>'EXPORT_TYPES.FILE_EXPORT'
,p_message_language=>'de'
,p_message_text=>'Statischer Dateiexport'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273898854950864723)
,p_name=>'EXPORT_TYPES.IMAGE_EXPORT'
,p_message_language=>'de'
,p_message_text=>'Bild exportieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273898674279864723)
,p_name=>'EXPORT_TYPES.PAGE_EXPORT'
,p_message_language=>'de'
,p_message_text=>'Seite exportieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273899028929864723)
,p_name=>'EXPORT_TYPES.SCRIPT_FILE_EXPORT'
,p_message_language=>'de'
,p_message_text=>'Skriptdatei exportieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273894718694864720)
,p_name=>'EXPORT_TYPES.UI_DEFAULTS'
,p_message_language=>'de'
,p_message_text=>unistr('Benutzeroberfl\00E4chen-Standards')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273820720750864668)
,p_name=>'F4000.APPLICATION_COMPUTATION'
,p_message_language=>'de'
,p_message_text=>'Anwendungsberechnung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273818587197864666)
,p_name=>'F4000.APPLICATION_ITEM'
,p_message_language=>'de'
,p_message_text=>'Anwendungselement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273820587394864668)
,p_name=>'F4000.APPLICATION_PROCESS'
,p_message_language=>'de'
,p_message_text=>'Anwendungsprozess'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273645485030864546)
,p_name=>'F4000.APPLICATION_RESERVED'
,p_message_language=>'de'
,p_message_text=>'Die Anwendungs-IDs von 3000 bis 8999 sind reserviert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273511275718864456)
,p_name=>'F4000.APP_EXPORT_CURR_WS'
,p_message_language=>'de'
,p_message_text=>'Diese Anwendung wurde aus dem aktuellen Workspace exportiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273511372849864456)
,p_name=>'F4000.APP_EXPORT_NON_CURR_WS'
,p_message_language=>'de'
,p_message_text=>'Diese Anwendung wurde aus einem anderen Workspace exportiert.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273820470344864668)
,p_name=>'F4000.BRANCH'
,p_message_language=>'de'
,p_message_text=>'Verzweigung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273833081766864677)
,p_name=>'F4000.BRANCH_FROM_PAGE'
,p_message_language=>'de'
,p_message_text=>'Verzweigung von Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273833275588864677)
,p_name=>'F4000.BRANCH_TO_PAGE'
,p_message_language=>'de'
,p_message_text=>'Verzweigung zu Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273820014729864668)
,p_name=>'F4000.BUTTON'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4che')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273970213276864773)
,p_name=>'F4000.BUTTON.ITEM'
,p_message_language=>'de'
,p_message_text=>unistr('Schaltfl\00E4chenelement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273572235374864497)
,p_name=>'F4000.CALENDAR'
,p_message_language=>'de'
,p_message_text=>'Kalender'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273717766489864595)
,p_name=>'F4000.CALENDAR_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Kalenderspalte.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273833659949864677)
,p_name=>'F4000.COLUMN_ATTRIBUTES'
,p_message_language=>'de'
,p_message_text=>'Spaltenattribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274668008356865280)
,p_name=>'F4000.COLUMN_NAME_RESERVED_WORD'
,p_message_language=>'de'
,p_message_text=>unistr('Der angegebene Spaltenname ist ein f\00FCr Oracle reserviertes Wort. W\00E4hlen Sie einen anderen Namen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273847693812864687)
,p_name=>'F4000.DYNAMIC'
,p_message_language=>'de'
,p_message_text=>'Dynamisch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273527171472864467)
,p_name=>'F4000.DYNAMIC ACTION'
,p_message_language=>'de'
,p_message_text=>'Dynamische Aktion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273511172345864456)
,p_name=>'F4000.EXPORT'
,p_message_language=>'de'
,p_message_text=>'Exportieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273849927763864689)
,p_name=>'F4000.FIX_ME'
,p_message_language=>'de'
,p_message_text=>'Fix Me'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273847249788864687)
,p_name=>'F4000.FOR_USER'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr Benutzer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273847119427864687)
,p_name=>'F4000.FOR_USER_SESSION'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr Benutzersession')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273833322883864677)
,p_name=>'F4000.FROM'
,p_message_language=>'de'
,p_message_text=>'Von'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273646559608864546)
,p_name=>'F4000.HEADER_VALIDATION1'
,p_message_language=>'de'
,p_message_text=>'Header muss <b> &lt;head&gt;</b>- und <b>&lt;/head&gt;</b>-Tags enthalten.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273646870287864546)
,p_name=>'F4000.HEADER_VALIDATION2'
,p_message_language=>'de'
,p_message_text=>'<b>#HEAD#</b>-Ersetzungszeichenfolge muss zwischen den <b> &lt;head&gt;</b>- und <b>&lt;/head&gt;</b>-Tags angezeigt werden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273911513556864732)
,p_name=>'F4000.INVALID_FILE_TYPE'
,p_message_language=>'de'
,p_message_text=>unistr('Datei "%0" hat einen ung\00FCltigen Typ.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273819744859864667)
,p_name=>'F4000.ITEM_DISPLAY'
,p_message_language=>'de'
,p_message_text=>'Elementanzeige'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273819896339864667)
,p_name=>'F4000.ITEM_READ_ONLY'
,p_message_language=>'de'
,p_message_text=>unistr('Schreibgesch\00FCtztes Element')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273443936213864411)
,p_name=>'F4000.LEGACY_SQL'
,p_message_language=>'de'
,p_message_text=>'Legacy-SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273999337900864806)
,p_name=>'F4000.LINK_COLUMN'
,p_message_language=>'de'
,p_message_text=>'Link-Spalte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273852424018864690)
,p_name=>'F4000.LIST_INITCAP'
,p_message_language=>'de'
,p_message_text=>'Liste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273821115729864668)
,p_name=>'F4000.LIST_ITEM'
,p_message_language=>'de'
,p_message_text=>'Listenelement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273443855529864411)
,p_name=>'F4000.LOCAL'
,p_message_language=>'de'
,p_message_text=>'Lokal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273821410383864668)
,p_name=>'F4000.LOV_ENTRY'
,p_message_language=>'de'
,p_message_text=>'Wertelisteneintrag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273833430528864677)
,p_name=>'F4000.MENU'
,p_message_language=>'de'
,p_message_text=>'Navigationspfad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273821384617864668)
,p_name=>'F4000.MENU_OPTION'
,p_message_language=>'de'
,p_message_text=>'Navigationspfadeintrag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273868786410864702)
,p_name=>'F4000.MUST_SELECT_AT_LEAST_ONE_TO_COPY'
,p_message_language=>'de'
,p_message_text=>unistr('Es muss mindestens ein Element f\00FCr den Kopiervorgang oder die Subscription ausgew\00E4hlt werden.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273820832577864668)
,p_name=>'F4000.NAVIGATION_BAR_ENTRY'
,p_message_language=>'de'
,p_message_text=>'Eintrag der Navigationsleiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273742343355864612)
,p_name=>'F4000.NAVIGATION_BAR_ICON'
,p_message_language=>'de'
,p_message_text=>'Symbol&nbsp;der&nbsp;Navigationsleiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273818254254864666)
,p_name=>'F4000.NO'
,p_message_language=>'de'
,p_message_text=>'Nein'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273847796744864687)
,p_name=>'F4000.NOT_REFERENCED'
,p_message_language=>'de'
,p_message_text=>'Nicht referenziert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273830722078864675)
,p_name=>'F4000.NO_DATA_FOUND'
,p_message_language=>'de'
,p_message_text=>'Keine Daten gefunden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274741178601865332)
,p_name=>'F4000.P1.APP_DOES_NOT_EXIST'
,p_message_language=>'de'
,p_message_text=>'Anwendung %0 ist in aktuellem Workspace nicht vorhanden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274377175163865076)
,p_name=>'F4000.P1000.UPDATE_CHECK_DISABLED'
,p_message_language=>'de'
,p_message_text=>unistr('Updatepr\00FCfung deaktiviert')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273861791891864697)
,p_name=>'F4000.P104.PARENT_TAB_NAME'
,p_message_language=>'de'
,p_message_text=>unistr('Name f\00FCr die \00FCbergeordnete Registerkarte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273514166443864458)
,p_name=>'F4000.P111.CANCEL_BUTTON_BRANCH'
,p_message_language=>'de'
,p_message_text=>unistr('Verzweigung f\00FCr Schaltfl\00E4che Abbrechen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273513786883864458)
,p_name=>'F4000.P111.CANCEL_BUTTON_TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Anzeigetext f\00FCr die Schaltfl\00E4che Abbrechen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273514212391864458)
,p_name=>'F4000.P111.FINISH_BUTTON_BRANCH'
,p_message_language=>'de'
,p_message_text=>unistr('Verzweigung f\00FCr Schaltfl\00E4che Fertigstellen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273513848938864458)
,p_name=>'F4000.P111.FINISH_BUTTON_TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Anzeigetext f\00FCr die Schaltfl\00E4che Fertigstellen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273514082623864458)
,p_name=>'F4000.P111.NEXT_BUTTON_TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Anzeigetext f\00FCr die Schaltfl\00E4che Weiter')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273513934353864458)
,p_name=>'F4000.P111.PREVIOUS_BUTTON_TEXT'
,p_message_language=>'de'
,p_message_text=>unistr('Anzeigetext f\00FCr die Schaltfl\00E4che Zur\00FCck')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273861855742864697)
,p_name=>'F4000.P112.TREE_PAGE'
,p_message_language=>'de'
,p_message_text=>'Baumseite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273861977265864697)
,p_name=>'F4000.P119.GO'
,p_message_language=>'de'
,p_message_text=>'Los'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273862077435864697)
,p_name=>'F4000.P130.USING_SAME_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>'Es werden die Templates einer vorhandenen Anwendung verwendet.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274744196227865334)
,p_name=>'F4000.P135.COPY'
,p_message_language=>'de'
,p_message_text=>'%0 kopieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274749737270865338)
,p_name=>'F4000.P149.PUBLISH_AUTHORIZATION'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Autorisierungsschemas aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274750073356865338)
,p_name=>'F4000.P149.PUBLISH_BREADCRUMB_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Navigationspfad-Templates aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274750115758865338)
,p_name=>'F4000.P149.PUBLISH_BUTTON_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Schaltfl\00E4chen-Templates aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274750240519865338)
,p_name=>'F4000.P149.PUBLISH_CALENDAR_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Kalendertemplates aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274749656046865337)
,p_name=>'F4000.P149.PUBLISH_FIELD_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Labeltemplates aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274749427540865337)
,p_name=>'F4000.P149.PUBLISH_LIST_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Listentemplates aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274749189776865337)
,p_name=>'F4000.P149.PUBLISH_LOV'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Wertelisten aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274749908480865338)
,p_name=>'F4000.P149.PUBLISH_NAVBAR'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Navigationsleisteneintr\00E4ge aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274749262184865337)
,p_name=>'F4000.P149.PUBLISH_PAGE_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Seiten-Templates aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274750380988865338)
,p_name=>'F4000.P149.PUBLISH_PLUGIN'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Plug-ins aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274750492613865338)
,p_name=>'F4000.P149.PUBLISH_POPUP_LOV_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Popup-Wertelisten-Templates aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274749336067865337)
,p_name=>'F4000.P149.PUBLISH_REGION_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Regionstemplates aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274749540965865337)
,p_name=>'F4000.P149.PUBLISH_REPORT_TEMPLATE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Berichtstemplates aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274749868876865338)
,p_name=>'F4000.P149.PUBLISH_SHORTCUT'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Shortcuts aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274034190278864830)
,p_name=>'F4000.P149.PUBLISH_WEB_SRC_MODULE'
,p_message_language=>'de'
,p_message_text=>unistr('Sie haben die Ver\00F6ffentlichung von <strong>%0</strong> angefordert. Dadurch werden die folgenden Webquellenmodule aktualisiert:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273869594367864702)
,p_name=>'F4000.P158.COPY_OF'
,p_message_language=>'de'
,p_message_text=>'Kopie von %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274744073807865334)
,p_name=>'F4000.P1701.LOOKUP_DEFINITION'
,p_message_language=>'de'
,p_message_text=>'Lookup-Definition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274741356391865332)
,p_name=>'F4000.P1704.REGION_NAME'
,p_message_language=>'de'
,p_message_text=>'Regionsname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273646150410864546)
,p_name=>'F4000.P19.VALIDATION'
,p_message_language=>'de'
,p_message_text=>'Es muss mindestens ein Element angegeben werden, um eine NOT NULL-Validierung zu erstellen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274400430272865092)
,p_name=>'F4000.P2.UPDATE_EXPORT_SETTINGS'
,p_message_language=>'de'
,p_message_text=>'Standardexporteinstellungen aktualisieren'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273906970750864729)
,p_name=>'F4000.P203.COMMENT='
,p_message_language=>'de'
,p_message_text=>'Kommentar='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273905064815864727)
,p_name=>'F4000.P203.COMP.MSG'
,p_message_language=>'de'
,p_message_text=>unistr('Wird f\00FCr die Ausf\00FChrung der Berechnung verwendet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274758582624865344)
,p_name=>'F4000.P203.CONCATENATED_FILE'
,p_message_language=>'de'
,p_message_text=>'Verkettete Datei'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273905641403864728)
,p_name=>'F4000.P203.DISPVAL='
,p_message_language=>'de'
,p_message_text=>'Anzeigewert='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274758467486865344)
,p_name=>'F4000.P203.FILE='
,p_message_language=>'de'
,p_message_text=>'file='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273905387498864728)
,p_name=>'F4000.P203.ICONBAR'
,p_message_language=>'de'
,p_message_text=>'Symbolleiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273905845757864728)
,p_name=>'F4000.P203.LOV='
,p_message_language=>'de'
,p_message_text=>'Werteliste='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273905563849864728)
,p_name=>'F4000.P203.LOVDATA'
,p_message_language=>'de'
,p_message_text=>'Wertelistendaten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273905487312864728)
,p_name=>'F4000.P203.NAME='
,p_message_language=>'de'
,p_message_text=>'name='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273904919826864727)
,p_name=>'F4000.P203.PAGE.MSG'
,p_message_language=>'de'
,p_message_text=>unistr('F\00FCr die Seitenanzeige')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273906850245864729)
,p_name=>'F4000.P203.PAGEBRANCH'
,p_message_language=>'de'
,p_message_text=>'Seitenverzweigung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273905970152864728)
,p_name=>'F4000.P203.PGTEMP'
,p_message_language=>'de'
,p_message_text=>'Seitentemplate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273905299373864728)
,p_name=>'F4000.P203.PROC.MSG'
,p_message_language=>'de'
,p_message_text=>unistr('Wird f\00FCr die Prozessausf\00FChrung verwendet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273905181561864727)
,p_name=>'F4000.P203.PROCESSING'
,p_message_language=>'de'
,p_message_text=>'Verarbeitung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273905743300864728)
,p_name=>'F4000.P203.RETVAL='
,p_message_language=>'de'
,p_message_text=>unistr('R\00FCckgabewert=')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274750647251865338)
,p_name=>'F4000.P2222.REPARENT_LIST_ENTRY'
,p_message_language=>'de'
,p_message_text=>'Listeneintrag neu zuordnen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273717359137864595)
,p_name=>'F4000.P254.VALIDATION'
,p_message_language=>'de'
,p_message_text=>unistr('Sie m\00FCssen mindestens eine Region f\00FCr den Erstellvorgang angeben.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273817958869864666)
,p_name=>'F4000.P277.WORKSPACE_NOT_CREATED_ALREADY_EXISTS'
,p_message_language=>'de'
,p_message_text=>'Der Workspace wird nicht erstellt, weil er bereits vorhanden ist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273818025424864666)
,p_name=>'F4000.P277.WORKSPACE_WILL_BE_CREATED'
,p_message_language=>'de'
,p_message_text=>'Der Workspace wird erstellt.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274753775677865340)
,p_name=>'F4000.P291.VIEW_LOCK'
,p_message_language=>'de'
,p_message_text=>'Sperre anzeigen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273717459162864595)
,p_name=>'F4000.P295.VALIDATION'
,p_message_language=>'de'
,p_message_text=>unistr('Sie m\00FCssen mindestens eine Seite f\00FCr den Erstellvorgang angeben.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274753836805865340)
,p_name=>'F4000.P337.PAGE_UNLOCKED'
,p_message_language=>'de'
,p_message_text=>'Diese Seite ist aktuell entsperrt. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274338790094865049)
,p_name=>'F4000.P371.POPUP_LOV'
,p_message_language=>'de'
,p_message_text=>'Popup-Werteliste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273862490166864697)
,p_name=>'F4000.P374.POS.1'
,p_message_language=>'de'
,p_message_text=>'Pos.1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273862506492864697)
,p_name=>'F4000.P374.POS.2'
,p_message_language=>'de'
,p_message_text=>'Pos.2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273862620168864697)
,p_name=>'F4000.P374.POS.3'
,p_message_language=>'de'
,p_message_text=>'Pos. 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273862731094864698)
,p_name=>'F4000.P374.POS.4'
,p_message_language=>'de'
,p_message_text=>'Pos.4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273434529610864405)
,p_name=>'F4000.P374.POS.5'
,p_message_language=>'de'
,p_message_text=>'Pos. 5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274041550336864835)
,p_name=>'F4000.P374.POS.6'
,p_message_language=>'de'
,p_message_text=>'Pos. 6'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274041629909864835)
,p_name=>'F4000.P374.POS.7'
,p_message_language=>'de'
,p_message_text=>'Pos. 7'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274041779389864836)
,p_name=>'F4000.P374.POS.8'
,p_message_language=>'de'
,p_message_text=>'Pos. 8'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273862834580864698)
,p_name=>'F4000.P381_XBUTTON_HELP'
,p_message_language=>'de'
,p_message_text=>unistr('DML- und Seitennummerierungsschaltfl\00E4chen ben\00F6tigen bestimmte Schaltfl\00E4chennamen. Weitere Informationen hierzu finden Sie im Hilfetext.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274744258614865334)
,p_name=>'F4000.P386.CLASS_MATCHES'
,p_message_language=>'de'
,p_message_text=>unistr('%0 (Klasse stimmt \00FCberein)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273862999800864698)
,p_name=>'F4000.P4001.AUTH_HOME'
,p_message_language=>'de'
,p_message_text=>'Verwalten'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274758895476865344)
,p_name=>'F4000.P4001.ORIGINAL_VALUE'
,p_message_language=>'de'
,p_message_text=>unistr('Urspr\00FCnglicher Wert')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273863085798864698)
,p_name=>'F4000.P4001.SUBSTITUTION_STR'
,p_message_language=>'de'
,p_message_text=>'Ersetzungszeichenfolge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273863109505864698)
,p_name=>'F4000.P4001.SUBSTITUTION_VALUE'
,p_message_language=>'de'
,p_message_text=>'Ersetzungswert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273830636312864675)
,p_name=>'F4000.P4017.HELP_REGION_SOURCE'
,p_message_language=>'de'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<font class="instructiontext">In dieser Region wird mit der folgenden Syntax die Seiten- und Elementhilfe f\00FCr die aktuelle Seite angezeigt:<br>'),
'<pre><escape sc>f?p=&AMP;APP_ID.:Page:Session:&APP_PAGE_ID.</pre></font>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273863245301864698)
,p_name=>'F4000.P4039.FORM_ON'
,p_message_language=>'de'
,p_message_text=>'Formular basierend auf %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273863374330864698)
,p_name=>'F4000.P404.VALUES'
,p_message_language=>'de'
,p_message_text=>'Werte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273584394989864505)
,p_name=>'F4000.P4045.BRANCH='
,p_message_language=>'de'
,p_message_text=>'Verzweigung='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273850866682864689)
,p_name=>'F4000.P4045.BUTTON='
,p_message_language=>'de'
,p_message_text=>'Button='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273452626262864417)
,p_name=>'F4000.P4045.CHART_SERIES='
,p_message_language=>'de'
,p_message_text=>'Diagrammreihe='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273851035665864689)
,p_name=>'F4000.P4045.COMPUTATION='
,p_message_language=>'de'
,p_message_text=>'Computation='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273850454949864689)
,p_name=>'F4000.P4045.ICON_SUBTEXT='
,p_message_language=>'de'
,p_message_text=>'Icon Subtext='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273850382056864689)
,p_name=>'F4000.P4045.IMAGE='
,p_message_language=>'de'
,p_message_text=>'Image='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273850911541864689)
,p_name=>'F4000.P4045.ITEM='
,p_message_language=>'de'
,p_message_text=>'Item='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273850524093864689)
,p_name=>'F4000.P4045.LIST='
,p_message_language=>'de'
,p_message_text=>'List='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273584464632864505)
,p_name=>'F4000.P4045.MENU_OPTION='
,p_message_language=>'de'
,p_message_text=>'Navigationspfadeintrag='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273850759200864689)
,p_name=>'F4000.P4045.PAGE='
,p_message_language=>'de'
,p_message_text=>'Page='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273851107391864689)
,p_name=>'F4000.P4045.PROCESS='
,p_message_language=>'de'
,p_message_text=>'Process='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273452505888864417)
,p_name=>'F4000.P4045.REGION='
,p_message_language=>'de'
,p_message_text=>'Region='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273847874001864687)
,p_name=>'F4000.P4045.REQUIRED_BY_EVERY_PAGE'
,p_message_language=>'de'
,p_message_text=>unistr('Wird von jeder Seite der Anwendung ben\00F6tigt')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273850040185864689)
,p_name=>'F4000.P4045.REQUIRED_TO_DISPLAY_PAGE'
,p_message_language=>'de'
,p_message_text=>'Seite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273850123402864689)
,p_name=>'F4000.P4045.REQUIRED_TO_RUN_APP_COMPUTATION'
,p_message_language=>'de'
,p_message_text=>'Anwendungsberechnung'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273850235806864689)
,p_name=>'F4000.P4045.REQUIRED_TO_RUN_APP_PROCESS'
,p_message_language=>'de'
,p_message_text=>'Anwendungsprozess'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273851317068864690)
,p_name=>'F4000.P4045.TAB_NAME='
,p_message_language=>'de'
,p_message_text=>'Tab Name='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273851456652864690)
,p_name=>'F4000.P4045.TAB_SET='
,p_message_language=>'de'
,p_message_text=>'Tab Set='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273850678771864689)
,p_name=>'F4000.P4045.TEXT='
,p_message_language=>'de'
,p_message_text=>'Text='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273851271128864690)
,p_name=>'F4000.P4045.VALIDATION='
,p_message_language=>'de'
,p_message_text=>'Validation='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273865034773864699)
,p_name=>'F4000.P420.CSV_EXPORT'
,p_message_language=>'de'
,p_message_text=>'Herunterladen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273865679972864700)
,p_name=>'F4000