prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4412
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4412 - Oracle APEX  System Messages and Native Types
--
-- Application Export:
--   Application:     4412
--   Name:            Oracle APEX  System Messages and Native Types
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             124
--       Globalization:
--         Messages:          14,593
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX  System Messages and Native Types')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286625417947926996')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135328'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'es'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(91645213681389498.4412)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141228'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562090986404402217.4412)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48650898565635010.4412)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Desconectar'
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>'Desconectarse de Application Express'
,p_list_text_09=>'Y'
,p_list_text_10=>'logout exit quit :q'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(281916990329150760.4412)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Crear una aplicaci\00F3n en una hoja de c\00E1lculo')
,p_list_item_link_target=>'f?p=4000:447:&APP_SESSION.::NO:448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT::'
,p_list_text_01=>unistr('Importe los archivos excel o csv y cree una aplicaci\00F3n')
,p_list_text_09=>'Y'
,p_list_text_10=>'excel csv xsl xslx spreadsheet data paste load import'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(282255839842182292.4412)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('P\00E1gina inicial de Oracle APEX')
,p_list_item_link_target=>'f?p=4500:1000:&APP_SESSION.'
,p_list_text_10=>unistr('inicio de p\00E1gina inicial ')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(296033420364984683.4412)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Examinar iconos de fuente APEX'
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>unistr('Examine los iconos de fuente APEX, a\00F1ada los modificadores y copie el CSS o HTML necesario.')
,p_list_text_09=>'Y'
,p_list_text_10=>unistr('librer\00EDa gr\00E1fica de iconos de fuente apex')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562091518091404815.4412)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562091727563404815.4412)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Exportar Aplicaci\00F3n')
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>unistr('Exportar aplicaci\00F3n {APP_ID} como archivo SQL')
,p_list_text_09=>'Y'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562093357853428158.4412)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Listas no Utilizadas'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562092153904409717.4412)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48392393581618193.4412)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Log de consola'
,p_list_item_link_target=>'javascript:console.log(''hello friend'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14843831009863117.4412)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859012524941040.4412)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(86380554411225400.4412)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91997339122572414.4412)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(460407779408652225.4412)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(497671453666914719.4412)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attribute_01=>'fa-star'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082458703597614427.4412)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082517678315623391.4412)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072678475712055.4412)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831649180083980462.4412)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780276458994154.4412)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1832884277947217587.4412)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1840861033969283097.4412)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917665913120940054.4412)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1990227023531717243.4412)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626406749381989.4412)
,p_theme_id=>1
,p_name=>'One Level Tabs.es'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE# ',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626529080381989.4412)
,p_theme_id=>1
,p_name=>'Printer Friendly.es'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(91626823864381990.4412)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(91632832228382001.4412)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(91636711305382010.4412)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(91638400927382012.4412)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(91638400927382012.4412)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(91641225667382016.4412)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641730492382017.4412)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641814330382017.4412)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(91642503902382024.4412)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>unistr('B\00FAsqueda')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Buscar'
,p_close_button_text=>'Cerrar'
,p_next_button_text=>'Siguiente >'
,p_prev_button_text=>'< Anterior'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91641910982382018.4412)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642102481382020.4412)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642303533382020.4412)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274876243807865585)
,p_name=>'2DCOLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna 2D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274878539565865586)
,p_name=>'2DCOLUMN_LINE'
,p_message_language=>'es'
,p_message_text=>unistr('L\00EDnea de Columnas 2D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274876436533865585)
,p_name=>'2DDOUGHNUT'
,p_message_language=>'es'
,p_message_text=>'Donut 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274878393298865586)
,p_name=>'2DHSTACKED_PCT'
,p_message_language=>'es'
,p_message_text=>'Columna 2D Horizontal Apilada (Porcentaje)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274876520737865585)
,p_name=>'2DLINE'
,p_message_language=>'es'
,p_message_text=>unistr('L\00EDnea 2D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274876671309865585)
,p_name=>'2DPIE'
,p_message_language=>'es'
,p_message_text=>'Tarta 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274878118674865586)
,p_name=>'2DSTACKED_PCT'
,p_message_language=>'es'
,p_message_text=>'Columna 2D Apilada (Porcentaje)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274876708227865585)
,p_name=>'3DCOLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna 3D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274878413412865586)
,p_name=>'3DHSTACKED_PCT'
,p_message_language=>'es'
,p_message_text=>'Columna 3D Horizontal Apilada (Porcentaje)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274876845883865585)
,p_name=>'3DPIE'
,p_message_language=>'es'
,p_message_text=>'Tarta 3D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274878218645865586)
,p_name=>'3DSTACKED_PCT'
,p_message_language=>'es'
,p_message_text=>'Columna 3D Apilada (Porcentaje)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275774164001866161)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'es'
,p_message_text=>'0 elementos para insertar en el diccionario de atributos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275773913208866161)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_language=>'es'
,p_message_text=>unistr('0 elementos para la actualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275774330609866161)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'es'
,p_message_text=>unistr('0 elementos para la actualizaci\00F3n del diccionario de atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275774741739866161)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'es'
,p_message_text=>'0 columnas de informe para insertarlas en el diccionario de atributos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275774967042866161)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'es'
,p_message_text=>unistr('0 columnas de informe para la actualizaci\00F3n del diccionario de atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275773891271866160)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_language=>'es'
,p_message_text=>unistr('Revisar %0 elementos para la actualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275774556798866161)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_language=>'es'
,p_message_text=>unistr('0 columnas de informe para la actualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275774021674866161)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'es'
,p_message_text=>'Revisar %0 elementos para insertar en el diccionario de atributos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275774269541866161)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'es'
,p_message_text=>unistr('Revisar %0 elementos para la actualizaci\00F3n del diccionario de atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275774624131866161)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'es'
,p_message_text=>'Revisar %0 columnas de informe para insertarlas en el diccionario de atributos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275774491625866161)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_language=>'es'
,p_message_text=>unistr('Revisar %0 columnas de informe para la actualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275774828312866161)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'es'
,p_message_text=>unistr('Revisar %0 columnas de informe para la actualizaci\00F3n del diccionario de atributos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275464601916865968)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_language=>'es'
,p_message_text=>unistr('El valor debe ser num\00E9rico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275449178596865956)
,p_name=>'4000_639_SEQ_MESG'
,p_message_language=>'es'
,p_message_text=>unistr('<span class="fielddata">No se puede reordenar porque las secuencias de regi\00F3n no son \00FAnicas.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275449291405865956)
,p_name=>'4000_641_SEQ_MESG'
,p_message_language=>'es'
,p_message_text=>unistr('<span class="fielddata">No se puede reordenar porque las secuencias de bot\00F3n no son \00FAnicas.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275449382087865956)
,p_name=>'4000_646_SEQ_MESG'
,p_message_language=>'es'
,p_message_text=>unistr('<span class="fielddata">No se puede reordenar porque las secuencias de barra de navegaci\00F3n no son \00FAnicas.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275449480314865956)
,p_name=>'4000_749_SEQ_MESG'
,p_message_language=>'es'
,p_message_text=>unistr('<span class="fielddata">No se puede reordenar porque las secuencias de elemento de regi\00F3n no son \00FAnicas.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275529090395866009)
,p_name=>'4000_APPLICATION_ID'
,p_message_language=>'es'
,p_message_text=>unistr('Identificador de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275020713035865676)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Aplicaci\00F3n: %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275420740445865936)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_language=>'es'
,p_message_text=>unistr('El formato de fecha especificado no es v\00E1lido. El calendario necesita una fecha en formato YYYYMMDD.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275469826463865972)
,p_name=>'4000_TREE'
,p_message_language=>'es'
,p_message_text=>unistr('\00C1rbol')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275529103052866009)
,p_name=>'4000_WORKSPACE_ID'
,p_message_language=>'es'
,p_message_text=>'Identificador de Espacio de Trabajo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275301845043865859)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Introduzca el nombre del nuevo esquema que se va a crear.  Seleccione',
unistr('         una contrase\00F1a para el esquema y seleccione el tablespace por defecto'),
'         y el tablespace temporal.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275301992432865859)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_language=>'es'
,p_message_text=>'Introduzca el nombre del esquema existente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275302043399865859)
,p_name=>'4050_106_WHEN_DONE'
,p_message_language=>'es'
,p_message_text=>unistr('Cuando termine, haga clic en el bot\00F3n "Siguiente &gt;"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275195083311865790)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_language=>'es'
,p_message_text=>'Borrar tablespaces y archivos de datos asociados: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275194957299865790)
,p_name=>'4050_110_DROP_USERS'
,p_message_language=>'es'
,p_message_text=>'Borrar usuarios de base de datos: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276107665443866366)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_language=>'es'
,p_message_text=>'Entradas de log de actividad por servicio web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275295258927865854)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_language=>'es'
,p_message_text=>'Entradas de Log de Actividades del Desarrollador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274913821000865609)
,p_name=>'4050_31_LOG_COUNT'
,p_message_language=>'es'
,p_message_text=>unistr('Entradas del Log de Acceso de Conexi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275294719819865854)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_language=>'es'
,p_message_text=>'Solicitudes de Cambio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275294888009865854)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_language=>'es'
,p_message_text=>unistr('Solicitudes de Tiempo de Ejecuci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275294544371865854)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_language=>'es'
,p_message_text=>'Solicitudes de Espacio de Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275297267973865856)
,p_name=>'4050_46_AD_HOC'
,p_message_language=>'es'
,p_message_text=>'Entradas del historial del procesador de comandos SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275297129063865856)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_language=>'es'
,p_message_text=>unistr('Entradas de Log de Ejecuci\00F3n del Archivo de Control')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275297036365865856)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_language=>'es'
,p_message_text=>unistr('Entradas de Log de Ejecuci\00F3n del Script')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275297338221865856)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_language=>'es'
,p_message_text=>'Entradas de Archivados de SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275299342774865857)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_language=>'es'
,p_message_text=>unistr('Informaci\00F3n de Log Activo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275299479142865857)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de Log Actual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275299502268865857)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_language=>'es'
,p_message_text=>'Registro de Hora de Log Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275300178186865858)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_language=>'es'
,p_message_text=>'Horas hasta el Siguiente Cambio de Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275299730017865857)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('Intervalo en D\00EDas (constante)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275300091738865858)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_language=>'es'
,p_message_text=>'Siguiente Cambio de Log Planificado para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275300457967865858)
,p_name=>'4050_70_DEV_ACT'
,p_message_language=>'es'
,p_message_text=>'Entradas de Log de Actividades del Desarrollador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275300691135865858)
,p_name=>'4050_71_CLICK'
,p_message_language=>'es'
,p_message_text=>'Entradas de Log de Clics de Paso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275301443986865859)
,p_name=>'4050_75_AD_HOC'
,p_message_language=>'es'
,p_message_text=>'Entradas del historial del procesador de comandos SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275301325711865858)
,p_name=>'4050_75_CTRL_FILE'
,p_message_language=>'es'
,p_message_text=>unistr('Entradas de Log de Ejecuci\00F3n del Archivo de Control')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275301110083865858)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_language=>'es'
,p_message_text=>unistr('Entradas de Log de Ejecuci\00F3n del Script')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275301590457865859)
,p_name=>'4050_75_SQL_ARCH'
,p_message_language=>'es'
,p_message_text=>'Entradas de Archivados de SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275301625573865859)
,p_name=>'4050_82_WORKSPACE'
,p_message_language=>'es'
,p_message_text=>'El espacio de trabajo %1 tiene %2 aplicaciones y %3 usuarios.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275301762047865859)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_language=>'es'
,p_message_text=>'Entradas de Log de Recuento de Clics'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275499821761865991)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_language=>'es'
,p_message_text=>'Aplicaciones de ejemplo y de productividad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275499937302865991)
,p_name=>'4050_PACKAGED_WEBSHEETS'
,p_message_language=>'es'
,p_message_text=>unistr('Hojas de c\00E1lculo web de ejemplo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275499140311865990)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_language=>'es'
,p_message_text=>'Recuento de Espacios de Trabajo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275039428442865688)
,p_name=>'4150_COLUMN_NUMBER'
,p_message_language=>'es'
,p_message_text=>'Columna %0'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275223152176865808)
,p_name=>'4350_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275223284306865808)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Aplicaci\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274928903939865618)
,p_name=>'4500 800 HD DBA'
,p_message_language=>'es'
,p_message_text=>'DBA de Oracle Database Express Edition 2 Day.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274929078564865618)
,p_name=>'4500 800 HD DEV'
,p_message_language=>'es'
,p_message_text=>'Oracle Database Express Edition 2 Day Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274928859510865618)
,p_name=>'4500 800 HD HTMLDB'
,p_message_language=>'es'
,p_message_text=>'Oracle Application Express 2 Day Plus Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274929109568865618)
,p_name=>'4500 800 HD JAVA'
,p_message_language=>'es'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus Java Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274929289334865618)
,p_name=>'4500 800 HD NET'
,p_message_language=>'es'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus .NET Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274929392060865618)
,p_name=>'4500 800 HD PHP'
,p_message_language=>'es'
,p_message_text=>'Desarrollador PHP de Oracle Database Express Edition 2 Day Plus.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274929423313865618)
,p_name=>'4500 800 MSG DBA'
,p_message_language=>'es'
,p_message_text=>unistr('Incluye tareas de administraci\00F3n comunes del d\00EDa a d\00EDa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274929567143865619)
,p_name=>'4500 800 MSG DEV'
,p_message_language=>'es'
,p_message_text=>unistr('Explica c\00F3mo aprovechar las ventajas del entorno de desarrollo de Oracle Database Express Edition.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274929644840865619)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_language=>'es'
,p_message_text=>unistr('Proporciona una serie de tutoriales que describen c\00F3mo crear aplicaciones Web basadas en bases de datos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274929865952865619)
,p_name=>'4500 800 MSG JAVA'
,p_message_language=>'es'
,p_message_text=>unistr('Este documento proporciona un tutorial que le ayudar\00E1 a utilizar Java y JDBC para conectarse a Oracle Database Express Edition. Tambi\00E9n le ense\00F1ar\00E1 a utilizar y desarrollar una sencilla aplicaci\00F3n Java para acceder y modificar los datos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274929921378865619)
,p_name=>'4500 800 MSG NET'
,p_message_language=>'es'
,p_message_text=>unistr('Este documento describe las funciones clave de Oracle Data Provider para .NET y Oracle Developer Tools para Visual Studio .NET. Le guiar\00E1 a trav\00E9s de la instalaci\00F3n y configuraci\00F3n y le ense\00F1ar\00E1 a crear aplicaciones b\00E1sicas utilizando Oracle Data Pro')
||unistr('vider para .NET y Oracle Developer Tools para Visual Studio .NET, adem\00E1s le mostrar\00E1 c\00F3mo crear y utilizar procedimientos almacenados de PL/SQL y de .NET.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274929787644865619)
,p_name=>'4500 800 MSG PHP'
,p_message_language=>'es'
,p_message_text=>unistr('Este documento le ense\00F1ar\00E1 a descargar e instalar Apache y los controladores de Zend Core PHP. Tambi\00E9n le ense\00F1ar\00E1 a utilizar PHP para conectarse a Oracle Database Express Edition y realiza una demostraci\00F3n de c\00F3mo utilizar PHP para desarrollar una s')
||unistr('encilla aplicaci\00F3n para acceder y modificar los datos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274899627211865600)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_language=>'es'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274899513663865600)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274899857188865600)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_language=>'es'
,p_message_text=>unistr('Condici\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275358553393865895)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_language=>'es'
,p_message_text=>'Suprimir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274900271957865600)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274900318950865600)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_language=>'es'
,p_message_text=>'Agrupar por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274899748820865600)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_language=>'es'
,p_message_text=>'Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274900131844865600)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_language=>'es'
,p_message_text=>'Mostrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274899976809865600)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_language=>'es'
,p_message_text=>'Tipo de Orden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274900060391865600)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_language=>'es'
,p_message_text=>unistr('Orden de Clasificaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274903463496865602)
,p_name=>'4500_1002_QB_JOIN'
,p_message_language=>'es'
,p_message_text=>unistr('Uni\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274896922985865598)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_language=>'es'
,p_message_text=>unistr('Haga clic aqu\00ED para seleccionar la columna que desea unir')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274903871028865602)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_language=>'es'
,p_message_text=>unistr('Se puede seleccionar un m\00E1ximo de 60 columnas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274896821391865598)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_language=>'es'
,p_message_text=>'Eliminar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274896700757865598)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_language=>'es'
,p_message_text=>'Mostrar/Ocultar Columnas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274903560745865602)
,p_name=>'4500_1002_QB_TO'
,p_message_language=>'es'
,p_message_text=>'a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274895132734865597)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_language=>'es'
,p_message_text=>unistr('Resultados de %0, ejecuci\00F3n %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275195236350865790)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_language=>'es'
,p_message_text=>'Volver a la Consulta Original'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274911144647865607)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_language=>'es'
,p_message_text=>'Se muestran las %0 primeras columnas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275388286081865915)
,p_name=>'4500_SESS_EVENT'
,p_message_language=>'es'
,p_message_text=>'Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275388196102865915)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_language=>'es'
,p_message_text=>'KB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275388063248865914)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_language=>'es'
,p_message_text=>'MB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274932861233865621)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('El creador de aplicaciones utiliza los valores por defecto de la interfaz de usuario para rellenar con valores iniciales las propiedades de regi\00F3n y elemento, a fin de proporcionar consistencia entre p\00E1ginas de una aplicaci\00F3n o entre varias aplicacio')
||'nes.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274977261602865649)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_language=>'es'
,p_message_text=>unistr('Esta aplicaci\00F3n necesita que las cookies est\00E9n activadas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274977175647865649)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_language=>'es'
,p_message_text=>unistr('Esta aplicaci\00F3n necesita que JavaScript est\00E9 activado.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275168888365865773)
,p_name=>'4800_9015_UPDATE_OVERDUE_FEATURES'
,p_message_language=>'es'
,p_message_text=>unistr('Las siguientes %0 funciones vencidas se actualizar\00E1n para el nuevo hito seleccionado.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275419012657865935)
,p_name=>'ABOUT'
,p_message_language=>'es'
,p_message_text=>'Acerca de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276179895258866411)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_language=>'es'
,p_message_text=>unistr('Confirme la adici\00F3n de los siguientes %0 usuarios al espacio de trabajo.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275431444374865942)
,p_name=>'ACCEPTED'
,p_message_language=>'es'
,p_message_text=>'Aceptado'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275397872888865921)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_language=>'es'
,p_message_text=>'Persona asignada a Accesibilidad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275395993049865920)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_language=>'es'
,p_message_text=>'Impacto de Accesibilidad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275398318671865921)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_language=>'es'
,p_message_text=>'Estado de Accesibilidad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276258925562866461)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_language=>'es'
,p_message_text=>'Accesibilidad Probada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274909912920865606)
,p_name=>'ACCESS_CONTROL_ADMIN'
,p_message_language=>'es'
,p_message_text=>'Administrador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275069367277865709)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Derechos de administraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274908477698865605)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina de Administraci\00F3n de Control de Acceso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275347006918865888)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_language=>'es'
,p_message_text=>'Administrador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275458165667865963)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_language=>'es'
,p_message_text=>'Rol asignado a los administradores de aplicaciones.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274908603252865605)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_language=>'es'
,p_message_text=>unistr('Administraci\00F3n de Aplicaciones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274909277524865606)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_language=>'es'
,p_message_text=>unistr('Modo de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274909162990865606)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_language=>'es'
,p_message_text=>unistr('Identifique c\00F3mo se va a controlar el acceso a esta aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274910425058865607)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha podido procesar la solicitud de modo de aplicaci\00F3n definido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274910518708865607)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Modo de Aplicaci\00F3n Definido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275070249110865709)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_language=>'es'
,p_message_text=>unistr('No se puede suprimir a s\00ED mismo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275070364869865710)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_language=>'es'
,p_message_text=>'No puede eliminar su propio privilegio de administrador.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274908521590865605)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_language=>'es'
,p_message_text=>'Crear Tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275346925403865888)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Derechos de contribuci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275347123049865888)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_language=>'es'
,p_message_text=>'Contribuyente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275458215882865963)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_language=>'es'
,p_message_text=>'Rol asignado a los contribuyentes de aplicaciones.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275390653397865916)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Se crear\00E1n los siguientes valores de aplicaci\00F3n:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275347235468865888)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_language=>'es'
,p_message_text=>unistr('Se crear\00E1n los siguientes roles de acceso a la aplicaci\00F3n:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274926059055865616)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_language=>'es'
,p_message_text=>unistr('Se crear\00E1n los siguientes esquemas de autorizaci\00F3n:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274999771625865663)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha podido crear la p\00E1gina de control de acceso. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274999697697865663)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_language=>'es'
,p_message_text=>'No se han podido crear tablas de control de acceso. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275072814748865711)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_language=>'es'
,p_message_text=>'No puede introducir un nombre de usuario duplicado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275069424399865709)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('control de acceso: edici\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274910156969865606)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca criterios de consulta que no sean sensibles a may\00FAsculas/min\00FAsculas y haga clic en el bot\00F3n <b>Ir</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274910216901865606)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha podido obtener el modo de administraci\00F3n de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274910062389865606)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimo Cambio de')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274909577843865606)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_language=>'es'
,p_message_text=>'Lista de Control de Acceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274908755149865605)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_language=>'es'
,p_message_text=>'Acceso completo a todos, no se utiliza la lista de control de acceso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274908898505865606)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_language=>'es'
,p_message_text=>unistr('Acceso restringido. S\00F3lo se permite a los usuarios definidos en la lista de control de acceso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274908920336865606)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_language=>'es'
,p_message_text=>unistr('S\00F3lo lectura p\00FAblica. Privilegios de edici\00F3n y administraci\00F3n controlados por lista de control de acceso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274909087988865606)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_language=>'es'
,p_message_text=>unistr('S\00F3lo acceso administrativo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274910370595865607)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_language=>'es'
,p_message_text=>unistr('No tiene privilegios para realizar esta acci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274909814186865606)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_language=>'es'
,p_message_text=>'Privilegio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275390548823865916)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_language=>'es'
,p_message_text=>'Derechos de lector'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275390493935865916)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_language=>'es'
,p_message_text=>'Lector'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275458397840865963)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_language=>'es'
,p_message_text=>'Rol asignado a los lectores de aplicaciones.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274926834025865617)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_language=>'es'
,p_message_text=>unistr('Identifique nombres de usuario que se corresponden con el esquema de autenticaci\00F3n de esta aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274909332589865606)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_language=>'es'
,p_message_text=>unistr('Definir Modo de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275027862038865681)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_language=>'es'
,p_message_text=>unistr('Las p\00E1ginas de control de acceso se han creado correctamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274909711263865606)
,p_name=>'ACCESS_CONTROL_USERNAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275347307163865888)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_language=>'es'
,p_message_text=>'Usar el rol de control de acceso existente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274926738228865617)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_language=>'es'
,p_message_text=>unistr('Usar Esquema de Autorizaci\00F3n Existente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274925940638865616)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_language=>'es'
,p_message_text=>'Usar Tabla Existente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275069525321865709)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('control de acceso: visualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275359271460865896)
,p_name=>'ACCESS_DENIED_SIMPLE'
,p_message_language=>'es'
,p_message_text=>'Acceso Denegado'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274930233263865619)
,p_name=>'ACCOUNT_CREATED'
,p_message_language=>'es'
,p_message_text=>'Cuenta creada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275053175424865699)
,p_name=>'ACCOUNT_HAS_BEEN_CREATED'
,p_message_language=>'es'
,p_message_text=>'Se ha creado la cuenta %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274927672234865617)
,p_name=>'ACCOUNT_LOCKED'
,p_message_language=>'es'
,p_message_text=>unistr('La cuenta est\00E1 bloqueada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275720279247866128)
,p_name=>'ACCOUNT_MENU'
,p_message_language=>'es'
,p_message_text=>unistr('Men\00FA Cuenta')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275377722716865908)
,p_name=>'ACKNOWLEDGED'
,p_message_language=>'es'
,p_message_text=>'Confirmado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275377904872865908)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_language=>'es'
,p_message_text=>unistr('Confirmado, sin acci\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275441803194865950)
,p_name=>'ACL_ADD_USER'
,p_message_language=>'es'
,p_message_text=>'Agregar Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276110491369866368)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_language=>'es'
,p_message_text=>'Acceder a Panel de Control'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276110532079866368)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_language=>'es'
,p_message_text=>'Acceder a Control de Actividad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276109601261866368)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_language=>'es'
,p_message_text=>'Agregar/Modificar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276110367904866368)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_language=>'es'
,p_message_text=>unistr('Administraci\00F3n al Ejecutar Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276108835782866367)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_language=>'es'
,p_message_text=>unistr('Administraci\00F3n desde Creador de Aplicaciones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276109552175866367)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_language=>'es'
,p_message_text=>'Anotaciones (archivos, etiquetas, notas)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276108578489866367)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_language=>'es'
,p_message_text=>unistr('Autenticaci\00F3n de Cuenta de Application Express sin Lista de Control de Acceso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276108483015866367)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_language=>'es'
,p_message_text=>unistr('Autenticaci\00F3n con Lista de Control de Acceso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276109255622866367)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_language=>'es'
,p_message_text=>'Editar Acceso SQL y Objetos Sugeridos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276113508662866370)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Tras su autenticaci\00F3n en una aplicaci\00F3n, el control de acceso especifica lo que los usuarios pueden hacer dentro de la misma. En la tabla que se muestra a continuaci\00F3n se indican las capacidades que tienen los distintos tipos de usuario en funci\00F3n de')
||unistr(' la autenticaci\00F3n que se utiliza dentro de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276110673344866368)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_language=>'es'
,p_message_text=>'Mantener Lista de Control de Acceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276109343552866367)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_language=>'es'
,p_message_text=>'Ejecutar y Ver'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276109098645866367)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_language=>'es'
,p_message_text=>unistr('Actualizar Propiedades de la Aplicaci\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275768754902866157)
,p_name=>'ACTIONS'
,p_message_language=>'es'
,p_message_text=>'Acciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276107923964866366)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n del Men\00FA Acci\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274941340185865626)
,p_name=>'ACTIVE'
,p_message_language=>'es'
,p_message_text=>'Activo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275354846479865893)
,p_name=>'ACTIVITY'
,p_message_language=>'es'
,p_message_text=>'Actividad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275399377646865922)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_language=>'es'
,p_message_text=>'Resumen de Actividad'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275634867629866075)
,p_name=>'ADDED_BY'
,p_message_language=>'es'
,p_message_text=>'Agregado por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276105443538866365)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_language=>'es'
,p_message_text=>unistr('Agregado a Lista de Depuraci\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275754411544866149)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_language=>'es'
,p_message_text=>unistr('Se necesita informaci\00F3n adicional')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275309031656865864)
,p_name=>'ADD_ARGUEMENT'
,p_message_language=>'es'
,p_message_text=>'Agregar Argumento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275299184007865857)
,p_name=>'ADD_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Agregar Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275515378118866000)
,p_name=>'ADD_COLUMN_NAME'
,p_message_language=>'es'
,p_message_text=>'Agregar Columna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275157170511865765)
,p_name=>'ADD_CONSTRAINT'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar Restricci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275296920874865856)
,p_name=>'ADD_MORE...'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar M\00E1s...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275369723240865903)
,p_name=>'ADD_ROW'
,p_message_language=>'es'
,p_message_text=>'Agregar Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275522843233866005)
,p_name=>'ADD_USER_INTERFACE'
,p_message_language=>'es'
,p_message_text=>'Agregar Interfaz de Usuario'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275526454908866007)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_language=>'es'
,p_message_text=>'Ajustar Espacio Proporcionado en %0 MB'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275295457556865855)
,p_name=>'ADMIN'
,p_message_language=>'es'
,p_message_text=>'Administrador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274921689199865614)
,p_name=>'ADMINISTRATOR'
,p_message_language=>'es'
,p_message_text=>'Administrador de Espacio de Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275399195719865922)
,p_name=>'ADMINISTRATORS'
,p_message_language=>'es'
,p_message_text=>'Administradores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275302747489865859)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe proporcionar el correo electr\00F3nico de los administradores')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275466834351865970)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_language=>'es'
,p_message_text=>'Accesibilidad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274957292061865636)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_language=>'es'
,p_message_text=>'Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274957513970865636)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_language=>'es'
,p_message_text=>'Rendimiento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274957639540865636)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_language=>'es'
,p_message_text=>'Control de Calidad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274957382891865636)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_language=>'es'
,p_message_text=>'Seguridad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274957790265865637)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_language=>'es'
,p_message_text=>'Uso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274957452448865636)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_language=>'es'
,p_message_text=>'Advertencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275600195120866053)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento "%1" est\00E1 protegido y no se puede definir mediante una llamada de AJAX.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275600258135866053)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento "%1" est\00E1 protegido y no se puede definir mediante una llamada de AJAX.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275632115015866073)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento "%1" est\00E1 protegido y no se puede definir mediante una llamada de AJAX.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274988094251865656)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_language=>'es'
,p_message_text=>'Falta el prefijo de esquema SYS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275810046278866183)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_language=>'es'
,p_message_text=>'Sintaxis de las API WWV_FLOW (utilice API de APEX en su lugar)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275750196662866146)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('La columna %0 no existe en la sentencia SQL de origen de regi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274967553514865643)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'La columna de informe interactivo %0 no existe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274965266602865641)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'%0 no existe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274933647503865621)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('La columna %0 no existe en la sentencia SQL de origen de regi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275844622100866204)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'La columna la pantalla tabular %0 no existe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274965388076865641)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_language=>'es'
,p_message_text=>unistr('No se puede hacer referencia a %0 como nombre del elemento de aplicaci\00F3n o p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276185898865866415)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_language=>'es'
,p_message_text=>unistr('El proceso de aplicaci\00F3n de devoluci\00F3n de llamada de AJAX no est\00E1 protegido por un esquema de autorizaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276185447623866415)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina no est\00E1 protegida por un esquema de autorizaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274966275891865642)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina de destino %1 (de la aplicaci\00F3n %0) no tiene ning\00FAn esquema de autorizaci\00F3n definido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276187558204866416)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_language=>'es'
,p_message_text=>unistr('La autorizaci\00F3n de esta p\00E1gina es diferente en la autorizaci\00F3n "%1" de la p\00E1gina principal %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274966364025865642)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_language=>'es'
,p_message_text=>unistr('La autorizaci\00F3n "%0" de la p\00E1gina de destino es diferente a "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274964840002865641)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'%0 no existe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274964767887865641)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha podido realizar una comprobaci\00F3n de sintaxis de la variable de enlace. Error: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274964962613865641)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'es'
,p_message_text=>'No se puede hacer referencia a %0 con la sintaxis de variable de enlace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274966992274865642)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_language=>'es'
,p_message_text=>'Rama incondicional antes que otras ramas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276185256867866415)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_language=>'es'
,p_message_text=>unistr('Terminar Autom\00E1ticamente se ha definido en "Activado" para la p\00E1gina que contiene los elementos de contrase\00F1a.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276185326203866415)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_language=>'es'
,p_message_text=>unistr('"Cach\00E9" permite al explorador almacenar la cach\00E9 de los datos importantes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276070275566866343)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_language=>'es'
,p_message_text=>unistr('"Embeber en Macros" vuelve a la aplicaci\00F3n vulnerable ante los ataques de clickjacking (secuestro de clics).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276070320703866343)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_language=>'es'
,p_message_text=>unistr('"Modo de Identificaci\00F3n de HTML" solo identifica un juego limitado de caracteres.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274891464909865595)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Identificador encontrado en los atributos de bot\00F3n, para un bot\00F3n al que se hace referencia en una acci\00F3n din\00E1mica (%0). '),
'',
unistr('Cuando se define un identificador en atributos de bot\00F3n, no funcionan las acciones din\00E1micas que hacen referencia al bot\00F3n. Elimine este identificador, ya que el bot\00F3n generar\00E1 un identificador por defecto.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274891586043865595)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('La plantilla de bot\00F3n utilizada por un bot\00F3n al que hace referencia una acci\00F3n din\00E1mica (%0) no contiene la cadena de sustituci\00F3n #BUTTON_ID#.'),
'',
'Plantilla:',
'%1',
'',
unistr('Agregue la cadena de sustituci\00F3n #BUTTON_ID# a esta plantilla o cambie la plantilla de bot\00F3n por una que incluya la cadena de sustituci\00F3n #BUTTON_ID#.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274894161306865596)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_language=>'es'
,p_message_text=>unistr('El bot\00F3n ''Acci\00F3n'' no est\00E1 definido por una acci\00F3n din\00E1mica para un bot\00F3n al que se hace referencia en una acci\00F3n din\00E1mica (%0).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274900827131865601)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_language=>'es'
,p_message_text=>unistr('El bot\00F3n (%0) tiene una acci\00F3n definida por acci\00F3n din\00E1mica, pero no hay ninguna acci\00F3n din\00E1mica correspondiente que haga referencia a este bot\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275468354124865971)
,p_name=>'ADVISOR.CHECK.CHART_TYPE_IS_ACCESSIBLE.MSG_ANYCHART_CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Este es un tipo de gr\00E1fico antiguo AnyChart. Deber\00EDa usar la utilidad ''Actualizaci\00F3n de la aplicaci\00F3n'' para migrarlo a los nuevos gr\00E1ficos basados en Oracle JET y disfrutar de una mayor facilidad de uso y una mejor accesibilidad.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274965999960865642)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina Borrar Cach\00E9 %0 no es la p\00E1gina actual ni la de destino %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274964600446865641)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'%0 no existe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276157422350866397)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_language=>'es'
,p_message_text=>unistr('Este valor de atributo est\00E1 en desuso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276158985307866398)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Este tipo de componente est\00E1 en desuso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275600301477866053)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_language=>'es'
,p_message_text=>'Elementos protegidos en llamadas AJAX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274987918103865656)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_language=>'es'
,p_message_text=>unistr('Hediondez de c\00F3digo (APEX interno)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274962728488865640)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_language=>'es'
,p_message_text=>unistr('Referencias Declarativas de Elementos de Aplicaci\00F3n, Elementos de P\00E1gina, Columnas o Filtros de Informe Interactivo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276185177096866415)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_language=>'es'
,p_message_text=>unistr('Autorizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274962423314865640)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_language=>'es'
,p_message_text=>'Referencias con Sintaxis de Variable de Enlace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274963860880865640)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_language=>'es'
,p_message_text=>'Rama incondicional antes que otras ramas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276185650203866415)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de Seguridad del Explorador')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274891358438865594)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_language=>'es'
,p_message_text=>unistr('El bot\00F3n no es compatible con las acciones din\00E1micas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274900635530865600)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_language=>'es'
,p_message_text=>unistr('Referencias inconsistentes entre las acciones din\00E1micas y los botones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275468146870865971)
,p_name=>'ADVISOR.CHECK.DESC_CHART_TYPE_IS_ACCESSIBLE'
,p_message_language=>'es'
,p_message_text=>unistr('El tipo de gr\00E1fico soporta la accesibilidad')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274963035358865640)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_language=>'es'
,p_message_text=>unistr('El n\00FAmero de p\00E1gina Borrar Cach\00E9 es igual a la p\00E1gina de destino o actual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274962393652865639)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_language=>'es'
,p_message_text=>'Referencias con Sintaxis de Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276157369663866397)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_language=>'es'
,p_message_text=>'Valores de Atributo En desuso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274963304921865640)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_language=>'es'
,p_message_text=>unistr('Los procesos Recuperaci\00F3n, DML, MR* son v\00E1lidos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274963738197865640)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_language=>'es'
,p_message_text=>unistr('Identificador de Aplicaci\00F3n de C\00F3digo Fuente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275374390178865906)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Elemento de P\00E1gina con Texto de Ayuda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275466695172865970)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina tiene t\00EDtulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275492752741865986)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_language=>'es'
,p_message_text=>'El elemento Mostrar imagen tiene texto alternativo de imagen definido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276070081228866343)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_language=>'es'
,p_message_text=>unistr('Atributos de aplicaci\00F3n que se pueden bloquear')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274962574438865640)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento de referencia est\00E1 en la p\00E1gina actual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274962672372865640)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento de referencia es el elemento de p\00E1gina de la p\00E1gina de destino')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275467344854865970)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento de p\00E1gina no causa ning\00FAn cambio de contexto inesperado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275468506446865971)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento de p\00E1gina tiene etiqueta')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274964059109865641)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_language=>'es'
,p_message_text=>'Longitud de Elemento o Nombre de Columna de Pantalla Tabular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274962863727865640)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_language=>'es'
,p_message_text=>unistr('Referencias de Elemento de P\00E1gina en una Cadena')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274962991142865640)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('Existe N\00FAmero de P\00E1gina de Referencia')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275466959861865970)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_language=>'es'
,p_message_text=>unistr('La regi\00F3n tiene fila de cabecera')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274964269737865641)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_language=>'es'
,p_message_text=>'El informe tiene un orden por defecto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276185748842866415)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_language=>'es'
,p_message_text=>unistr('Protecci\00F3n de Estado de la Sesi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274963457256865640)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_language=>'es'
,p_message_text=>unistr('Uso incorrecto de sintaxis de sustituci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274962266260865639)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_language=>'es'
,p_message_text=>unistr('Referencias con Sintaxis de Sustituci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274963269941865640)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_language=>'es'
,p_message_text=>unistr('La autorizaci\00F3n de p\00E1gina de destino est\00E1 definida tambi\00E9n para el componente actual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275467178565865970)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_language=>'es'
,p_message_text=>'Accesibilidad de estilo de tema probada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275589024818866046)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_language=>'es'
,p_message_text=>'La interfaz de usuario incluye JavaScript de compatibilidad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274963922565865640)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_language=>'es'
,p_message_text=>'Elemento o Columna de Validaciones Asociado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274963160893865640)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_language=>'es'
,p_message_text=>unistr('Es C\00F3digo SQL o PL/SQL V\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274963610908865640)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_language=>'es'
,p_message_text=>'Verificar Propiedad Clob'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274963583880865640)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n V utilizada en sentencias SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274964138098865641)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_language=>'es'
,p_message_text=>unistr('Existe el bot\00F3n al que se hace referencia en Si Se Hace Clic en el Bot\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274966541718865642)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('Error de compilaci\00F3n: %0 Sentencia: %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274966838625865642)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('El enlace contiene el identificador de aplicaci\00F3n actual como valor codificado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275374293859865906)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_language=>'es'
,p_message_text=>'No se ha definido texto de ayuda.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275466742958865970)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('Esta p\00E1gina no tiene t\00EDtulo. En aras de la accesibilidad, es importante asignar t\00EDtulos de p\00E1gina relevantes para que los usuarios se hagan una idea del contenido y el objetivo de la p\00E1gina en la que se encuentren.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275492832204865986)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento carece del texto alternativo que debe tener la imagen. Para que el texto sea eficaz, debe describir el contenido de la imagen de forma adecuada, y no debe duplicar la informaci\00F3n que aparezca en la p\00E1gina que se muestra en el contexto de ')
||unistr('la imagen (para evitar posibles duplicados). Nota: Si la imagen la proporcionan los usuarios, tambi\00E9n deben proporcionar el texto alternativo de imagen, adem\00E1s de las instrucciones necesarias para que los usuarios creen textos de buena calidad.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276070172560866343)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_language=>'es'
,p_message_text=>unistr('"Sintaxis de la API en Tiempo de Ejecuci\00F3n" permite realizar modificaciones del espacio de trabajo y la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274965067931865641)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no es un elemento de la p\00E1gina %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274965153455865641)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no es un elemento de la p\00E1gina de destino %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275467492987865970)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_language=>'es'
,p_message_text=>unistr('El valor ''Acci\00F3n de p\00E1gina al seleccionar'' del elemento de esta p\00E1gina puede provocar un cambio de contexto inesperado para el usuario. Puede cambiar a ''Ninguno'' para que no se produzca ning\00FAn cambio de contexto y sustituir la funci\00F3n con acciones di')
||unistr('n\00E1micas o listas de valores en cascada (si debe permanecer en la misma p\00E1gina). De forma alternativa, puede proporcionar informaci\00F3n al usuario para que sepa lo que ocurrir\00E1 (por ejemplo, incluya ''Se abre en una p\00E1gina nueva'' en la etiqueta). ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275492677848865986)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe definir una etiqueta para el elemento. Aunque prefiera que no se muestre una etiqueta visible, debe definir la etiqueta y, despu\00E9s, seleccionar la plantilla de etiqueta ''Oculta''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275468615001865971)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento tiene definido un valor ''Marcador de posici\00F3n de valor'', pero no una etiqueta. El texto de marcador de posici\00F3n no debe usarse solo en la etiqueta de un elemento, puesto que as\00ED se generan problemas de accesibilidad. Para mejorarla realme')
||unistr('nte, las etiquetas de los elementos deben estar definidas. Aunque prefiera que no se muestre una etiqueta visible, debe definir la etiqueta y, despu\00E9s, seleccionar la plantilla de etiqueta ''Oculta''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274967227926865643)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_language=>'es'
,p_message_text=>unistr('El nombre tiene una longitud de %0 caracteres, pero debe tener como m\00E1ximo 30 caracteres.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274965479766865641)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'Puede que %0 no exista.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274965569222865641)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_language=>'es'
,p_message_text=>unistr('Puede que %0 no sea un elemento de aplicaci\00F3n o p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274965849990865642)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina Borrar Cach\00E9 %1 (de la aplicaci\00F3n %0) no existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274965652197865642)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina %0 no existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274965736907865642)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina de destino %1 (de la aplicaci\00F3n %0) no existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275390756713865916)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('Esta regi\00F3n de conmutaci\00F3n de columnas no tiene ninguna columna con "Usar como cabecera de fila" definida en "S\00ED". La columna de cabecera de fila debe ser aquella que mejor represente la fila actual (por ejemplo, el nombre de un cliente en un informe')
||' de datos del cliente).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275390833999865916)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('Esta regi\00F3n de reflujo no tiene ninguna columna con "Usar como cabecera de fila" definida en "S\00ED". La columna de cabecera de fila debe ser aquella que mejor represente la fila actual (por ejemplo, el nombre de un cliente en un informe de detalles del')
||' cliente).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275467072031865970)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('Esta regi\00F3n de pantalla tabular no tiene ninguna columna con "Usar como cabecera de fila" definida en S\00ED. La columna de cabecera de fila debe ser aquella que mejor represente la fila actual (por ejemplo, el nombre de cliente en una tabla de informaci')
||unistr('\00F3n del cliente). Esta informaci\00F3n se usa al representar la pantalla tabular para proporcionar etiquetas \00FAnicas a los campos de cada fila.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274967435880865643)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_language=>'es'
,p_message_text=>'El informe no tiene un orden por defecto.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276070410813866343)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_language=>'es'
,p_message_text=>unistr('"Funci\00F3n Hash de Marcador" se define en un algoritmo heredado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276070538029866343)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_language=>'es'
,p_message_text=>unistr('"Protecci\00F3n de Estado de la Sesi\00F3n" est\00E1 desactivada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276185512185866415)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_language=>'es'
,p_message_text=>unistr('En una p\00E1gina con un proceso de recuperaci\00F3n, debe usar la protecci\00F3n de acceso a p\00E1gina y activar la protecci\00F3n de los elementos que transfiere mediante la URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274924172971865615)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_language=>'es'
,p_message_text=>unistr('La regi\00F3n contiene una URL "f?p" no transferida a APEX_UTIL.PREPARE_URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274966604822865642)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha detectado una posible inyecci\00F3n SQL. %0 se utiliza con la sintaxis de sustituci\00F3n en el c\00F3digo SQL o PL/SQL o el nombre de la tabla de proceso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274964459921865641)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'%0 no existe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274964587555865641)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'es'
,p_message_text=>unistr('No se puede hacer referencia a %0 con la sintaxis de sustituci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274966450477865642)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina de destino %1 (de la aplicaci\00F3n %0) tiene un esquema de autorizaci\00F3n definido, pero el componente actual no.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275467299402865970)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha probado la accesibilidad del estilo de tema actual para la aplicaci\00F3n. Cambie a un estilo de tema en el que Accesibilidad probada est\00E9 definida en S\00ED, o si el estilo de tema actual a\00FAn no se ha probado, defina el atributo Accesibilidad proba')
||unistr('da en S\00ED en la configuraci\00F3n del tema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275589230734866046)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('La interfaz de usuario incluye la migraci\00F3n de jQuery. La migraci\00F3n de jQuery facilita la migraci\00F3n a una versi\00F3n m\00E1s reciente de jQuery mediante la restauraci\00F3n de las API eliminadas, y muestra advertencias en la consola del explorador cuando se uti')
||unistr('lizan API anticuadas o eliminadas. Esto incluye un archivo JavaScript adicional en cada p\00E1gina de su aplicaci\00F3n. Para eliminarlas, consulte la gu\00EDa de actualizaci\00F3n de la migraci\00F3n de jQuery, en la que obtendr\00E1 informaci\00F3n sobre las API que se deben ')
||unistr('cambiar. Una vez que se haya asegurado de que no desea utilizar ninguna de estas API, defina Incluir migraci\00F3n de jQuery en No.'),
'',
'https://github.com/jquery/jquery-migrate'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275589154139866046)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_language=>'es'
,p_message_text=>unistr('La interfaz de usuario utiliza funciones JavaScript anticuadas o no soportadas. Esto incluye un archivo JavaScript adicional en cada p\00E1gina de su aplicaci\00F3n. Para eliminarlas, consulte la secci\00F3n ''Funciones anticuadas'' de las notas t\00E9cnicas sobre la ')
||unistr('versi\00F3n, en la que encontrar\00E1 instrucciones sobre c\00F3mo buscar dependencias con funciones anticuadas o no soportadas y su eliminaci\00F3n de la aplicaci\00F3n.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274967161589865642)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento o columna asociados no est\00E1 definido, pero "Ubicaci\00F3n de Visualizaci\00F3n de Mensaje de Error" lo requiere.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274967071368865642)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento o columna asociados no es igual a "%0" especificado en la expresi\00F3n de validaci\00F3n 1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274966040510865642)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('Error de compilaci\00F3n: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274966150495865642)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha definido ning\00FAn c\00F3digo SQL o PL/SQL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274964373782865641)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_language=>'es'
,p_message_text=>unistr('Tiene m\00E1s de 32767. S\00F3lo se comprueban los primeros 32767. Longitud: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274966776453865642)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_language=>'es'
,p_message_text=>unistr('Contiene la llamada de funci\00F3n V/NV/DV en la sentencia SQL (puede producir un problema de rendimiento).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274967380472865643)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('El bot\00F3n al que se hace referencia ya no existe.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275360842858865897)
,p_name=>'AFTER'
,p_message_language=>'es'
,p_message_text=>unistr('Despu\00E9s')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275302125842865859)
,p_name=>'AGREEMENT_MISSING'
,p_message_language=>'es'
,p_message_text=>'Falta el acuerdo'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275107057634865733)
,p_name=>'ALIAS'
,p_message_language=>'es'
,p_message_text=>'Alias'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275813224294866185)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_language=>'es'
,p_message_text=>unistr('Permitir Creaci\00F3n de Aplicaciones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275730048308866134)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Permita la instalaci\00F3n de aplicaciones de ejemplo y de productividad.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275565383189866031)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_language=>'es'
,p_message_text=>'Permitir Uso de Servicios RESTful'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275813387596866185)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_language=>'es'
,p_message_text=>'Permitir Uso de Taller SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275813577311866185)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_language=>'es'
,p_message_text=>'Permitir Uso de Desarrollo de Equipos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275813193170866185)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_language=>'es'
,p_message_text=>unistr('Permitir Depuraci\00F3n de Espacio de Trabajo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275813437279866185)
,p_name=>'ALLOW_WEBSHEET_DEV'
,p_message_language=>'es'
,p_message_text=>unistr('Permitir Desarrollo de Hoja de C\00E1lculo Web')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275126327819865746)
,p_name=>'ALL_APPLICATIONS'
,p_message_language=>'es'
,p_message_text=>'Todas las Aplicaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274912103857865608)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_language=>'es'
,p_message_text=>'- Todo -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274911908868865608)
,p_name=>'ALL_CATEGORIES'
,p_message_language=>'es'
,p_message_text=>unistr('Todas las Categor\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274912299642865608)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_language=>'es'
,p_message_text=>unistr('- Todas las Categor\00EDas -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275816261821866187)
,p_name=>'ALL_MILESTONES'
,p_message_language=>'es'
,p_message_text=>'todos los hitos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275494234414865987)
,p_name=>'ALL_RELEASES'
,p_message_language=>'es'
,p_message_text=>'Todas las Versiones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275132215966865750)
,p_name=>'ALL_STATIC_FILES'
,p_message_language=>'es'
,p_message_text=>unistr('todos los archivos est\00E1ticos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275130834019865749)
,p_name=>'ALL_THEMES'
,p_message_language=>'es'
,p_message_text=>'todos los temas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275837951313866200)
,p_name=>'ALL_TYPES'
,p_message_language=>'es'
,p_message_text=>'Todos los Tipos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275838307241866200)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_language=>'es'
,p_message_text=>'- Todos los Tipos -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275127438490865746)
,p_name=>'ALL_USERS'
,p_message_language=>'es'
,p_message_text=>'Todos los Usuarios'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276180035336866411)
,p_name=>'ALREADY_IN_ACL'
,p_message_language=>'es'
,p_message_text=>'El usuario ya tiene una cuenta de APEX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276169963687866405)
,p_name=>'ALREADY_IN_WS'
,p_message_language=>'es'
,p_message_text=>'El usuario ya existe en el espacio de trabajo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276130654369866381)
,p_name=>'ALWAYS'
,p_message_language=>'es'
,p_message_text=>'Siempre'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274883664943865590)
,p_name=>'AM_PM'
,p_message_language=>'es'
,p_message_text=>'AM / PM'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275377512209865908)
,p_name=>'ANALYSIS'
,p_message_language=>'es'
,p_message_text=>unistr('An\00E1lisis de %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275377668208865908)
,p_name=>'ANALYZE'
,p_message_language=>'es'
,p_message_text=>'Analizar por %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275516594042866001)
,p_name=>'ANALYZE_TABLE'
,p_message_language=>'es'
,p_message_text=>unistr('Analizar con el M\00E9todo %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274985256123865654)
,p_name=>'ANCHOR.SHOW_ALL'
,p_message_language=>'es'
,p_message_text=>'Mostrar Todo'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275129712092865748)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_language=>'es'
,p_message_text=>unistr('bloque an\00F3nimo')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274972112891865646)
,p_name=>'ANSWERS'
,p_message_language=>'es'
,p_message_text=>'Respuestas'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274923840342865615)
,p_name=>'ANY_DEVELOPER'
,p_message_language=>'es'
,p_message_text=>'(Cualquier Desarrollador)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276145732533866390)
,p_name=>'APEX.ACTIONS.TOGGLE'
,p_message_language=>'es'
,p_message_text=>'Conmutar %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276184985783866414)
,p_name=>'APEX.ACTIVE_STATE'
,p_message_language=>'es'
,p_message_text=>'(Activo)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276248503421866454)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_language=>'es'
,p_message_text=>unistr('Cambios de Aplicaci\00F3n:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276248425073866454)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_language=>'es'
,p_message_text=>'Hora:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276253223972866457)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_language=>'es'
,p_message_text=>'%0 K'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276248683691866454)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_language=>'es'
,p_message_text=>unistr('Vistas de P\00E1gina: ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275770619285866159)
,p_name=>'APEX.AJAX_SERVER_ERROR'
,p_message_language=>'es'
,p_message_text=>'La llamada Ajax ha devuelto el error de servidor %0 para %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276068049000866342)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'La llamada de API de se ha prohibido.',
unistr('P\00F3ngase en contacto con el administrador.'),
unistr('Puede acceder a m\00E1s informaci\00F3n sobre este incidente a trav\00E9s del ID de depuraci\00F3n "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275174708671865777)
,p_name=>'APEX.APPLICATION.ALIAS.NON_UNIQUE'
,p_message_language=>'es'
,p_message_text=>unistr('El alias de aplicaci\00F3n "%0" no se puede convertir en un identificador de aplicaci\00F3n \00FAnico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275174805781865777)
,p_name=>'APEX.APPLICATION.ALIAS.NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('La aplicaci\00F3n con el alias "%0" no existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275132480051865750)
,p_name=>'APEX.APPLICATION.ALIAS.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('ERR-1816: Error inesperado al convertir el alias de aplicaci\00F3n p_flow_alias_or_id (%0).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275001283952865664)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_language=>'es'
,p_message_text=>unistr('La llamada de API de "%0" ya no est\00E1 soportada en Application Express versi\00F3n %1. Puede acceder a m\00E1s informaci\00F3n sobre este incidente a trav\00E9s del ID de depuraci\00F3n "%2".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275007936597865668)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNC.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la funci\00F3n de autenticaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274895561116865597)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la funci\00F3n de autenticaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276263316168866464)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.HOST_PREFIX_MISMATCH'
,p_message_language=>'es'
,p_message_text=>unistr('El nombre de inquilino %0 devuelto por Oracle Cloud Identity Management no est\00E1 autorizado para el dominio %1.<br/><a href="&LOGOUT_URL.">Vuelva a conectarse</a> y especifique un nombre de inquilino autorizado o cambie la URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274888601325865593)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.USER_IS_NOT_DEVELOPER'
,p_message_language=>'es'
,p_message_text=>'La cuenta "%0" no tiene los privilegios de desarrollo necesarios (DB_DEVELOPER o DB_ADMINISTRATOR)<br/>para el espacio de trabajo "%1". <a href="&LOGOUT_URL.">Vuelva a conectarse</a> una vez que se hayan proporcionado los privilegios.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274884017763865590)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.WRONG_GROUP_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('El nombre de inquilino devuelto por Oracle Cloud Identity Management no est\00E1 autorizado para el espacio de trabajo actual.<br/><a href="&LOGOUT_URL.">Vuelva a conectarse</a> y especifique un nombre de inquilino autorizado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275022292375865677)
,p_name=>'APEX.AUTHENTICATION.HEADER.DUPLICATE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('La cabecera HTTP %0 se ha enviado dos veces, podr\00EDa tratarse de un ataque.'),
'<ul>',
'<li>Primer valor: "%1"</li>',
'<li>Segundo valor: "%2"</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274888846243865593)
,p_name=>'APEX.AUTHENTICATION.HOST_PREFIX_MISMATCH'
,p_message_language=>'es'
,p_message_text=>unistr('Por motivos de seguridad, no est\00E1 permitida la ejecuci\00F3n de aplicaciones de este espacio de trabajo a trav\00E9s del dominio de la URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275007693026865668)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.ASK_FOR_INSTALLATION'
,p_message_language=>'es'
,p_message_text=>'Pida al DBA que ejecute $OH/rdbms/admin/catldap.sql.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275007561212865668)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.MISSING'
,p_message_language=>'es'
,p_message_text=>unistr('El paquete SYS.DBMS_LDAP no existe o no es v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275007464599865668)
,p_name=>'APEX.AUTHENTICATION.LDAP.EDIT_USER_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la funci\00F3n de edici\00F3n del usuario LDAP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275007710233865668)
,p_name=>'APEX.AUTHENTICATION.LDAP.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la autenticaci\00F3n de LDAP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275008969498865669)
,p_name=>'APEX.AUTHENTICATION.LOGIN.ILLEGAL_PAGE_ARG'
,p_message_language=>'es'
,p_message_text=>'Error en el argumento p_flow_page para el procedimiento login_page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275008425851865669)
,p_name=>'APEX.AUTHENTICATION.LOGIN.INVALID_ARG'
,p_message_language=>'es'
,p_message_text=>unistr('p_session no v\00E1lido en wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275008210865865668)
,p_name=>'APEX.AUTHENTICATION.LOGIN.MALFORMED_ARGS'
,p_message_language=>'es'
,p_message_text=>'Argumento con formato incorrecto en wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275008665338865669)
,p_name=>'APEX.AUTHENTICATION.LOGIN.NULL_USER'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha transferido un nombre de usuario nulo al procedimiento de conexi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274908346187865605)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.COUNTER'
,p_message_language=>'es'
,p_message_text=>'Espere <span id="apex_login_throttle_sec">%0</span> segundos para volver a conectarse.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274913345547865608)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('El intento de conexi\00F3n se ha bloqueado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275348603693865889)
,p_name=>'APEX.AUTHENTICATION.NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado la autenticaci\00F3n "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274921953419865614)
,p_name=>'APEX.AUTHENTICATION.NO_SECURITY_GROUP_ID'
,p_message_language=>'es'
,p_message_text=>'El identificador de grupo de seguridad es nulo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275008105739865668)
,p_name=>'APEX.AUTHENTICATION.POST_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al ejecutar el proceso de autenticaci\00F3n posterior.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275007832302865668)
,p_name=>'APEX.AUTHENTICATION.PRE_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la autenticaci\00F3n previa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275027397613865680)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD.INSTRUCTIONS'
,p_message_language=>'es'
,p_message_text=>unistr('Abra la URL en el mismo buscador en el que inici\00F3 la solicitud de restablecimiento de la contrase\00F1a.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276247799481866454)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD_URL'
,p_message_language=>'es'
,p_message_text=>unistr('Restablecer URL de Contrase\00F1a')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274889074314865593)
,p_name=>'APEX.AUTHENTICATION.RM_GROUP_NOT_GRANTED'
,p_message_language=>'es'
,p_message_text=>'El grupo de consumidores %0 del gestor de recursos no se ha otorgado a %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274889175198865593)
,p_name=>'APEX.AUTHENTICATION.RM_INFO_TO_GRANT'
,p_message_language=>'es'
,p_message_text=>'Utilice DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP para otorgar el privilegio que falta.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275085116987865719)
,p_name=>'APEX.AUTHENTICATION.SESSION_SENTRY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la funci\00F3n de protecci\00F3n de sesi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275085289635865719)
,p_name=>'APEX.AUTHENTICATION.SESSION_VERIFY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la funci\00F3n de verificaci\00F3n de sesi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275085411232865719)
,p_name=>'APEX.AUTHENTICATION.SSO.ASK_FOR_INSTALLATION'
,p_message_language=>'es'
,p_message_text=>'Pida al administrador de %0 que configure el motor para Oracle Application Server Single Sign-On.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275161540075865768)
,p_name=>'APEX.AUTHENTICATION.SSO.BAD_URLC'
,p_message_language=>'es'
,p_message_text=>unistr('SSO ha devuelto un token %0 en %1 no v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275008852696865669)
,p_name=>'APEX.AUTHENTICATION.SSO.FIX_PARTNER_APP'
,p_message_language=>'es'
,p_message_text=>unistr('Edite el esquema de autenticaci\00F3n y agregue el nombre de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275161197120865768)
,p_name=>'APEX.AUTHENTICATION.SSO.ILLEGAL_CALLER'
,p_message_language=>'es'
,p_message_text=>unistr('Llamada no v\00E1lida del procedimiento %0:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275161384378865768)
,p_name=>'APEX.AUTHENTICATION.SSO.INVALID_APP_SESSION'
,p_message_language=>'es'
,p_message_text=>unistr('Sesi\00F3n de aplicaci\00F3n no v\00E1lida en el token urlc: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275160910791865768)
,p_name=>'APEX.AUTHENTICATION.SSO.MISSING_APP_REGISTRATION'
,p_message_language=>'es'
,p_message_text=>unistr('Error en portal_sso_redirect: falta la informaci\00F3n de registro de la aplicaci\00F3n: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275085392891865719)
,p_name=>'APEX.AUTHENTICATION.SSO.PACKAGE_MISSING'
,p_message_language=>'es'
,p_message_text=>unistr('El paquete WWSEC_SSO_ENABLER_PRIVATE no existe o no es v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275008704228865669)
,p_name=>'APEX.AUTHENTICATION.SSO.PARTNER_APP_IS_NULL'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado el nombre de la aplicaci\00F3n asociada registrado en el esquema de autenticaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275161088433865768)
,p_name=>'APEX.AUTHENTICATION.SSO.REGISTER_APP'
,p_message_language=>'es'
,p_message_text=>unistr('Registre esta aplicaci\00F3n como se describe en la gu\00EDa de instalaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275085582822865719)
,p_name=>'APEX.AUTHENTICATION.SSO.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la autenticaci\00F3n de SSO.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276164559155866401)
,p_name=>'APEX.AUTHENTICATION.UNAUTHORIZED_URL'
,p_message_language=>'es'
,p_message_text=>'URL No Autorizada:  %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275084955563865719)
,p_name=>'APEX.AUTHENTICATION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la autenticaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274888966188865593)
,p_name=>'APEX.AUTHENTICATION.WORKSPACE_NOT_ASSIGNED'
,p_message_language=>'es'
,p_message_text=>unistr('El espacio de trabajo "%0" est\00E1 inactivo. P\00F3ngase en contacto con el administrador.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274890129562865594)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED'
,p_message_language=>'es'
,p_message_text=>'%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274910870159865607)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Acceso denegado por la comprobaci\00F3n de seguridad de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274910938885865607)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Acceso denegado por la comprobaci\00F3n de seguridad de la p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274911080535865607)
,p_name=>'APEX.AUTHORIZATION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la autorizaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275387802681865914)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_language=>'es'
,p_message_text=>'#LABEL# no existe en la lista.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275770285057866158)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_language=>'es'
,p_message_text=>unistr('La opci\00F3n Mostrar Solo Bifurcaciones no est\00E1 soportada si el atributo de p\00E1gina "Recargar al Enviar" est\00E1 definido en "Solo para Correcto".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275135273848865751)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la bifurcaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275455744070865961)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX'
,p_message_language=>'es'
,p_message_text=>'Creado con %0 mediante %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275455801390865961)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX.ACCESSIBLE.LOVE'
,p_message_language=>'es'
,p_message_text=>'love'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275492419068865986)
,p_name=>'APEX.CALCULATOR.ICON_TEXT'
,p_message_language=>'es'
,p_message_text=>'Calculadora Emergente: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276120510825866374)
,p_name=>'APEX.CALENDAR.EVENT_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Descripci\00F3n del evento')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276120322512866374)
,p_name=>'APEX.CALENDAR.EVENT_END'
,p_message_language=>'es'
,p_message_text=>unistr('Fecha de Finalizaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276120606041866374)
,p_name=>'APEX.CALENDAR.EVENT_ID'
,p_message_language=>'es'
,p_message_text=>'ID del evento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276120293424866374)
,p_name=>'APEX.CALENDAR.EVENT_START'
,p_message_language=>'es'
,p_message_text=>'Fecha de Inicio'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276120496129866374)
,p_name=>'APEX.CALENDAR.EVENT_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo del Evento')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275588543868866046)
,p_name=>'APEX.CLIPBOARD.COPIED'
,p_message_language=>'es'
,p_message_text=>'Copiado en el portapapeles.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275581554981866042)
,p_name=>'APEX.CLIPBOARD.NOTSUP'
,p_message_language=>'es'
,p_message_text=>unistr('Este explorador no soporta la copia de botones y men\00FAs. Utilice Ctrl+C o Comando+C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275457886363865963)
,p_name=>'APEX.CLOSE_NOTIFICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Notificaci\00F3n de Cierre')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274879689217865587)
,p_name=>'APEX.COLOR_PICKER.ICON_TEXT'
,p_message_language=>'es'
,p_message_text=>'Selector de Color Emergente: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276233793963866445)
,p_name=>'APEX.COMBOBOX.LIST_OF_VALUES'
,p_message_language=>'es'
,p_message_text=>'Lista de Valores'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276233837464866445)
,p_name=>'APEX.COMBOBOX.SHOW_ALL_VALUES'
,p_message_language=>'es'
,p_message_text=>'Abrir lista para: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276185089226866414)
,p_name=>'APEX.COMPLETED_STATE'
,p_message_language=>'es'
,p_message_text=>'(Terminado)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274890347162865594)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar el c\00E1lculo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275112682521865737)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la condici\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275175321637865777)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de condici\00F3n desconocido "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275140500373865755)
,p_name=>'APEX.CONTACT_ADMIN'
,p_message_language=>'es'
,p_message_text=>unistr('P\00F3ngase en contacto con el administrador de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275222867856865808)
,p_name=>'APEX.CONTACT_ADMIN.DEBUG'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('P\00F3ngase en contacto con el administrador de la aplicaci\00F3n.'),
unistr('Hay m\00E1s detalles sobre este incidente disponibles mediante el ID de depuraci\00F3n "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276107523548866366)
,p_name=>'APEX.CORRECT_ERRORS'
,p_message_language=>'es'
,p_message_text=>'Corrija los errores antes de guardar.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276189296926866417)
,p_name=>'APEX.CURRENT_PROGRESS'
,p_message_language=>'es'
,p_message_text=>'Progreso actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275808529764866182)
,p_name=>'APEX.DATA_HAS_CHANGED'
,p_message_language=>'es'
,p_message_text=>unistr('La versi\00F3n actual de los datos de la base de datos ha cambiado desde que el usuario inici\00F3 el proceso de actualizaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275492384703865986)
,p_name=>'APEX.DATEPICKER.ICON_TEXT'
,p_message_language=>'es'
,p_message_text=>'Calendario Emergente: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275501471509865992)
,p_name=>'APEX.DATEPICKER_VALUE_GREATER_MAX_DATE'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# es posterior a la fecha m\00E1xima especificada %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275506711776865995)
,p_name=>'APEX.DATEPICKER_VALUE_INVALID'
,p_message_language=>'es'
,p_message_text=>'#LABEL# no coincide con el formato %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275501321909865992)
,p_name=>'APEX.DATEPICKER_VALUE_LESS_MIN_DATE'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# es anterior a la fecha m\00EDnima especificada %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275501593317865992)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# no est\00E1 en el rango v\00E1lido de %0 y %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275505042226865994)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_IN_YEAR_RANGE'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# no est\00E1 en el rango v\00E1lido de a\00F1o de %0 y %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276108252522866367)
,p_name=>'APEX.DIALOG.CANCEL'
,p_message_language=>'es'
,p_message_text=>'Cancelar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276213908766866432)
,p_name=>'APEX.DIALOG.CLOSE'
,p_message_language=>'es'
,p_message_text=>'Cerrar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276218995504866435)
,p_name=>'APEX.DIALOG.HELP'
,p_message_language=>'es'
,p_message_text=>'Ayuda'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276108007851866367)
,p_name=>'APEX.DIALOG.OK'
,p_message_language=>'es'
,p_message_text=>'Aceptar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275319448311865870)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina %1 de cuadro de di\00E1logo de la aplicaci\00F3n %0 no se puede presentar correctamente. Aseg\00FArese de que la plantilla de p\00E1gina que est\00E1 en uso en la p\00E1gina %1 es del tipo de plantilla "P\00E1gina de Cuadro de Di\00E1logo", con el c\00F3digo de cancelaci\00F3n de')
||unistr(' cuadro de di\00E1logo, de cierre de cuadro de di\00E1logo o de inicializaci\00F3n de cuadro de di\00E1logo de JavaScritpt adecuado definido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276108148139866367)
,p_name=>'APEX.DIALOG.SAVE'
,p_message_language=>'es'
,p_message_text=>'Guardar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276235698769866446)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_language=>'es'
,p_message_text=>'Copyright &copy; %0, Todos los derechos reservados.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276236436320866446)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_language=>'es'
,p_message_text=>'Crear Espacio de Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276235514241866446)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_language=>'es'
,p_message_text=>'Este es un mensaje generado por el sistema. No responda a este mensaje.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276245358082866452)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_language=>'es'
,p_message_text=>'Entorno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276257914228866460)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_language=>'es'
,p_message_text=>'Usuario de Oracle Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276237080412866447)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_language=>'es'
,p_message_text=>unistr('Introducci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276235764724866446)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_language=>'es'
,p_message_text=>'Hola %0,'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276236729033866447)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_language=>'es'
,p_message_text=>unistr('Contrase\00F1a')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276245429684866452)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_language=>'es'
,p_message_text=>unistr('Evitar depuraci\00F3n de espacio de trabajo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276236934057866447)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_language=>'es'
,p_message_text=>unistr('Puede impedir que se depure su espacio de trabajo haciendo clic en el bot\00F3n siguiente y siguiendo las instrucciones que se muestran en pantalla. Si no act\00FAa en %0 d\00EDa(s), el espacio de trabajo se eliminar\00E1 autom\00E1ticamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276245176829866452)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_language=>'es'
,p_message_text=>unistr('No es necesaria ninguna acci\00F3n si ya no necesita el espacio de trabajo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276245696824866452)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_language=>'es'
,p_message_text=>unistr('El espacio de trabajo est\00E1 a punto de depurarse.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276244964977866452)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_language=>'es'
,p_message_text=>unistr('El espacio de trabajo %0 no ha mostrado ninguna actividad reciente y est\00E1 programado para depurarse pronto.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276244826737866452)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_language=>'es'
,p_message_text=>unistr('Advertencia: El espacio de trabajo "%0" est\00E1 a punto de depurarse.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276245213544866452)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_language=>'es'
,p_message_text=>unistr('Fecha de Depuraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276245935467866453)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_language=>'es'
,p_message_text=>'Complete la solicitud de espacio de trabajo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276245706052866452)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_language=>'es'
,p_message_text=>unistr('El espacio de trabajo "%0" est\00E1 listo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276246052045866453)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_language=>'es'
,p_message_text=>'El espacio de trabajo "%0" ha sido aprobado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276245844859866452)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_language=>'es'
,p_message_text=>'La solicitud de espacio de trabajo se ha rechazado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276236384919866446)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276245589217866452)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_language=>'es'
,p_message_text=>unistr('\00A1Advertencia!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276236227072866446)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_language=>'es'
,p_message_text=>'Espacio de Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276235818135866446)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_language=>'es'
,p_message_text=>'Solicitud de espacio de trabajo aprobada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276236504886866446)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_language=>'es'
,p_message_text=>unistr('Haga clic en el bot\00F3n siguiente para terminar el proceso de aprobaci\00F3n y definir su contrase\00F1a.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276236071054866446)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_language=>'es'
,p_message_text=>'Su solicitud de espacio de trabajo ha sido aprobada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276236619241866447)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_language=>'es'
,p_message_text=>unistr('Haga clic en el bot\00F3n siguiente para comenzar.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276236865610866447)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_language=>'es'
,p_message_text=>unistr('Su espacio de trabajo est\00E1 listo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276235946919866446)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_language=>'es'
,p_message_text=>'Solicitud de espacio de trabajo rechazada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276236100293866446)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_language=>'es'
,p_message_text=>'Si solicitud de espacio de trabajo ha sido rechazada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275135517847865752)
,p_name=>'APEX.ERROR'
,p_message_language=>'es'
,p_message_text=>'Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274885841098865591)
,p_name=>'APEX.ERROR.CALLBACK_FAILED'
,p_message_language=>'es'
,p_message_text=>'Se ha producido el siguiente error al ejecutar la llamada de manejo de error: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274926905060865617)
,p_name=>'APEX.ERROR.ERROR_PAGE.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha producido un error al pintar la p\00E1gina de error: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274889632397865593)
,p_name=>'APEX.ERROR.INTERNAL'
,p_message_language=>'es'
,p_message_text=>'Error Interno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276178068899866410)
,p_name=>'APEX.ERROR.INTERNAL.CONTACT_ADMINISTRATOR'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('P\00F3ngase en contacto con el administrador.'),
unistr('Hay m\00E1s detalles sobre este incidente disponibles mediante el ID de depuraci\00F3n "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276258864727866461)
,p_name=>'APEX.ERROR.ORA-28353'
,p_message_language=>'es'
,p_message_text=>unistr('ORA-28353: Fallo al abrir la cartera. No se puede acceder actualmente a los datos de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276160262447866399)
,p_name=>'APEX.ERROR.PAGE_NOT_AVAILABLE'
,p_message_language=>'es'
,p_message_text=>unistr('Esta p\00E1gina no est\00E1 disponible')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274895415355865597)
,p_name=>'APEX.ERROR.TECHNICAL_INFO'
,p_message_language=>'es'
,p_message_text=>unistr('Informaci\00F3n T\00E9cnica (visible s\00F3lo para los desarrolladores)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275723236459866129)
,p_name=>'APEX.ERROR_MESSAGE_HEADING'
,p_message_language=>'es'
,p_message_text=>'Mensaje de Error'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275797172465866175)
,p_name=>'APEX.EXPECTED_FORMAT'
,p_message_language=>'es'
,p_message_text=>'Formato esperado: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275520729554866004)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.ALREADY_IN_ACL'
,p_message_language=>'es'
,p_message_text=>unistr('El usuario ya est\00E1 en la lista de control de acceso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275520619132866004)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.CREATE_CONFIRM'
,p_message_language=>'es'
,p_message_text=>unistr('Confirme la adici\00F3n de los siguientes %0 <strong>%1</strong> usuarios a la lista de control de acceso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275521162270866004)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.DUPLICATE_USE'
,p_message_language=>'es'
,p_message_text=>'Existe un usuario duplicado'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275520851839866004)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_AT_SIGN'
,p_message_language=>'es'
,p_message_text=>unistr('Falta el s\00EDmbolo arroba (@) en la direcci\00F3n de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275520949100866004)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_DO'
,p_message_language=>'es'
,p_message_text=>unistr('Falta "." en la direcci\00F3n de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275521097436866004)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.USERNAME_TOO_LONG'
,p_message_language=>'es'
,p_message_text=>'El nombre de usuario es demasiado largo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275521375396866004)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_ONLY'
,p_message_language=>'es'
,p_message_text=>unistr('Solo se permite el acceso a la aplicaci\00F3n a los usuarios definidos en la lista de control de acceso a la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275521451047866004)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_VALUE_INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('Valor de configuraci\00F3n de control de acceso no esperado: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275521245229866004)
,p_name=>'APEX.FEATURE.ACL.INFO.ALL_USERS'
,p_message_language=>'es'
,p_message_text=>unistr('Todos los usuarios autenticados pueden acceder a esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276066841129866341)
,p_name=>'APEX.FEATURE.CONFIG.DISABLED'
,p_message_language=>'es'
,p_message_text=>'Desactivado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276066795125866341)
,p_name=>'APEX.FEATURE.CONFIG.ENABLED'
,p_message_language=>'es'
,p_message_text=>'Activado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276067853318866342)
,p_name=>'APEX.FEATURE.CONFIG.IS_DISABLED'
,p_message_language=>'es'
,p_message_text=>'%0: desactivado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276066907974866341)
,p_name=>'APEX.FEATURE.CONFIG.IS_ENABLED'
,p_message_language=>'es'
,p_message_text=>'%0: activado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275456592294865962)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_language=>'es'
,p_message_text=>'En cola'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275456611184865962)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_language=>'es'
,p_message_text=>'Enviados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276066613959866341)
,p_name=>'APEX.FEATURE.TOP_USERS.USERNAME.NOT_IDENTIFIED'
,p_message_language=>'es'
,p_message_text=>'sin identificar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274920287552865613)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_language=>'es'
,p_message_text=>'Entradas de Comentario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274920378823865613)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_language=>'es'
,p_message_text=>'Entradas de Comentarios Abiertos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274920420185865613)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_language=>'es'
,p_message_text=>'Usuarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275810295312866183)
,p_name=>'APEX.FILE_BROWSE.DOWNLOAD_LINK_TEXT'
,p_message_language=>'es'
,p_message_text=>'Descargar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275803411707866179)
,p_name=>'APEX.FS.BATCH_APPLY'
,p_message_language=>'es'
,p_message_text=>'Aplicar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275803940324866179)
,p_name=>'APEX.FS.CLEAR'
,p_message_language=>'es'
,p_message_text=>'Borrar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275804010053866179)
,p_name=>'APEX.FS.CLEAR_ALL'
,p_message_language=>'es'
,p_message_text=>'Borrar todo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275804148809866179)
,p_name=>'APEX.FS.CLEAR_VALUE'
,p_message_language=>'es'
,p_message_text=>'Borrar %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276134759471866383)
,p_name=>'APEX.FS.COLUMN_UNAUTHORIZED'
,p_message_language=>'es'
,p_message_text=>unistr('La columna %1, a la que hace referencia la faceta %0, no est\00E1 disponible o autorizada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276127105968866378)
,p_name=>'APEX.FS.FACET_VALUE_LIMIT_EXCEEDED'
,p_message_language=>'es'
,p_message_text=>unistr('L\00EDmite de valor distinto (%0) superado para la faceta %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275805693540866180)
,p_name=>'APEX.FS.FC_TYPE_UNSUPPORTED_FOR_DATE_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'La faceta %0 no se soporta en columnas DATE o TIMESTAMP.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275803507974866179)
,p_name=>'APEX.FS.FILTER'
,p_message_language=>'es'
,p_message_text=>'Filtrar %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275803641258866179)
,p_name=>'APEX.FS.GO'
,p_message_language=>'es'
,p_message_text=>'Ir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275805289372866180)
,p_name=>'APEX.FS.INPUT_CURRENT_LABEL'
,p_message_language=>'es'
,p_message_text=>'igual que %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275805412016866180)
,p_name=>'APEX.FS.NO_SEARCH_COLUMNS_PROVIDED'
,p_message_language=>'es'
,p_message_text=>unistr('No se han proporcionado columnas de b\00FAsqueda para la faceta %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275804967229866179)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL'
,p_message_language=>'es'
,p_message_text=>'De %0 a %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275805038685866180)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_HI'
,p_message_language=>'es'
,p_message_text=>'Por encima de %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275805163910866180)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_LO'
,p_message_language=>'es'
,p_message_text=>'Por debajo de %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276145533546866390)
,p_name=>'APEX.FS.RANGE_LOV_ITEM_INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('Elemento de lista de valores n.\00BA %2 ("%1") para la faceta de rango %0 no es v\00E1lido (falta el separador "|").')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275805320438866180)
,p_name=>'APEX.FS.RANGE_MANUAL_NOT_SUPPORTED'
,p_message_language=>'es'
,p_message_text=>'La entrada manual para la faceta de rango %0 no se soporta actualmente, ya que la columna es DATE o TIMESTAMP.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275804592389866179)
,p_name=>'APEX.FS.RANGE_TEXT'
,p_message_language=>'es'
,p_message_text=>'a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275803836320866179)
,p_name=>'APEX.FS.SEARCH_LABEL'
,p_message_language=>'es'
,p_message_text=>'Buscar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275803768182866179)
,p_name=>'APEX.FS.SEARCH_PLACEHOLDER'
,p_message_language=>'es'
,p_message_text=>'Buscar...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275804727410866179)
,p_name=>'APEX.FS.SELECT_PLACEHOLDER'
,p_message_language=>'es'
,p_message_text=>'- Seleccionar -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275804337758866179)
,p_name=>'APEX.FS.SHOW_LESS'
,p_message_language=>'es'
,p_message_text=>'Mostrar menos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275804498455866179)
,p_name=>'APEX.FS.SHOW_MORE'
,p_message_language=>'es'
,p_message_text=>unistr('Mostrar m\00E1s')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275804631506866179)
,p_name=>'APEX.FS.STAR_RATING_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('%0 estrellas y m\00E1s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275805520077866180)
,p_name=>'APEX.FS.TEXT_FIELD_ONLY_FOR_NUMBER_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'La faceta de campo de texto %0 solo se soporta actualmente para las columnas NUMBER.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276134977403866383)
,p_name=>'APEX.FS.UNSUPPORTED_DATA_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('El tipo de dato %0 (%1) no se soporta en la b\00FAsqueda de faceta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276068466194866342)
,p_name=>'APEX.GO_TO_ERROR'
,p_message_language=>'es'
,p_message_text=>'Ir al error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275281376288865845)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>'No se ha encontrado el grupo "%0"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275527269446866008)
,p_name=>'APEX.GV.AGG_CONTEXT'
,p_message_language=>'es'
,p_message_text=>'Agregado.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275635827601866075)
,p_name=>'APEX.GV.BREAK_COLLAPSE'
,p_message_language=>'es'
,p_message_text=>unistr('Reducir Divisi\00F3n de Control')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275527301121866008)
,p_name=>'APEX.GV.BREAK_CONTEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Divisi\00F3n de control.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275635782714866075)
,p_name=>'APEX.GV.BREAK_EXPAND'
,p_message_language=>'es'
,p_message_text=>unistr('Ampliar Divisi\00F3n de Control')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276265006066866465)
,p_name=>'APEX.GV.COLUMN_CONTEXT'
,p_message_language=>'es'
,p_message_text=>'Columna %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275635594694866075)
,p_name=>'APEX.GV.DELETED_COUNT'
,p_message_language=>'es'
,p_message_text=>'%0 Filas Suprimidas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276224585304866439)
,p_name=>'APEX.GV.DUP_REC_ID'
,p_message_language=>'es'
,p_message_text=>'Identidad duplicada'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275514297291866000)
,p_name=>'APEX.GV.FIRST_PAGE'
,p_message_language=>'es'
,p_message_text=>'Primero'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275527570890866008)
,p_name=>'APEX.GV.GROUP_CONTEXT'
,p_message_language=>'es'
,p_message_text=>'Cabecera de grupo.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275527476305866008)
,p_name=>'APEX.GV.HEADER_CONTEXT'
,p_message_language=>'es'
,p_message_text=>'Cabecera.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275514366652866000)
,p_name=>'APEX.GV.LAST_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275676134518866100)
,p_name=>'APEX.GV.LOAD_MORE'
,p_message_language=>'es'
,p_message_text=>unistr('Cargar M\00E1s Filas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275514053988866000)
,p_name=>'APEX.GV.NEXT_PAGE'
,p_message_language=>'es'
,p_message_text=>'Siguiente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275527684426866008)
,p_name=>'APEX.GV.PAGE_RANGE'
,p_message_language=>'es'
,p_message_text=>unistr('Filas de p\00E1gina')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275514467148866000)
,p_name=>'APEX.GV.PAGE_RANGE_XY'
,p_message_language=>'es'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275514523567866000)
,p_name=>'APEX.GV.PAGE_RANGE_XYZ'
,p_message_language=>'es'
,p_message_text=>'%0 - %1 de %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275514126773866000)
,p_name=>'APEX.GV.PREV_PAGE'
,p_message_language=>'es'
,p_message_text=>'Anterior'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276224392110866439)
,p_name=>'APEX.GV.ROW_ADDED'
,p_message_language=>'es'
,p_message_text=>'Agregado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276224406740866439)
,p_name=>'APEX.GV.ROW_CHANGED'
,p_message_language=>'es'
,p_message_text=>'Cambiado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276264809596866465)
,p_name=>'APEX.GV.ROW_COLUMN_CONTEXT'
,p_message_language=>'es'
,p_message_text=>'Fila %0, Columna %1.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276264989305866465)
,p_name=>'APEX.GV.ROW_CONTEXT'
,p_message_language=>'es'
,p_message_text=>'Fila %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276224272031866439)
,p_name=>'APEX.GV.ROW_DELETED'
,p_message_language=>'es'
,p_message_text=>'Suprimido'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275556421322866026)
,p_name=>'APEX.GV.ROW_HEADER'
,p_message_language=>'es'
,p_message_text=>'Cabecera de fila'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275513398914865999)
,p_name=>'APEX.GV.SELECTION_CELL_COUNT'
,p_message_language=>'es'
,p_message_text=>'%0 celdas seleccionadas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275514680014866000)
,p_name=>'APEX.GV.SELECTION_COUNT'
,p_message_language=>'es'
,p_message_text=>'%0 filas seleccionadas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275860026130866214)
,p_name=>'APEX.GV.SELECT_ALL'
,p_message_language=>'es'
,p_message_text=>'Seleccionar Todo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275635699844866075)
,p_name=>'APEX.GV.SELECT_PAGE_N'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275556380662866026)
,p_name=>'APEX.GV.SELECT_ROW'
,p_message_language=>'es'
,p_message_text=>'Seleccionar Fila'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275558915527866028)
,p_name=>'APEX.GV.SORTED_ASCENDING'
,p_message_language=>'es'
,p_message_text=>'Orden ascendente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275559017320866028)
,p_name=>'APEX.GV.SORTED_DESCENDING'
,p_message_language=>'es'
,p_message_text=>'Orden descendente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275513593445865999)
,p_name=>'APEX.GV.SORT_ASCENDING'
,p_message_language=>'es'
,p_message_text=>'Orden Ascendente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275513842210865999)
,p_name=>'APEX.GV.SORT_ASCENDING_ORDER'
,p_message_language=>'es'
,p_message_text=>'Orden Ascendente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275513672561865999)
,p_name=>'APEX.GV.SORT_DESCENDING'
,p_message_language=>'es'
,p_message_text=>'Orden Descendente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275513991833866000)
,p_name=>'APEX.GV.SORT_DESCENDING_ORDER'
,p_message_language=>'es'
,p_message_text=>'Orden Descendente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275513772873865999)
,p_name=>'APEX.GV.SORT_OFF'
,p_message_language=>'es'
,p_message_text=>'No Ordenar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275635466296866075)
,p_name=>'APEX.GV.TOTAL_PAGES'
,p_message_language=>'es'
,p_message_text=>'Total %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276198734552866423)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_language=>'es'
,p_message_text=>unistr('Ver Documentaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276218278853866435)
,p_name=>'APEX.ICON_LIST.GRID_DIM'
,p_message_language=>'es'
,p_message_text=>unistr('Filas %1 de las columnas de la lista de selecci\00F3n de cuadr\00EDcula %0. Utilizar las teclas de flecha')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275634577480866074)
,p_name=>'APEX.ICON_LIST.LIST_DIM'
,p_message_language=>'es'
,p_message_text=>'Seleccionar las filas de %0 de la lista. Utilizar las techas de flecha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276264607797866465)
,p_name=>'APEX.IG.ACC_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Cuadr\00EDcula Interactiva %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275496751585865989)
,p_name=>'APEX.IG.ACTIONS'
,p_message_language=>'es'
,p_message_text=>'Acciones'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275497742875865989)
,p_name=>'APEX.IG.ADD'
,p_message_language=>'es'
,p_message_text=>'Agregar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275497687117865989)
,p_name=>'APEX.IG.ADD_ROW'
,p_message_language=>'es'
,p_message_text=>'Agregar Fila'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276232344247866444)
,p_name=>'APEX.IG.AGGREGATE'
,p_message_language=>'es'
,p_message_text=>'Agregar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276195211196866421)
,p_name=>'APEX.IG.AGGREGATION'
,p_message_language=>'es'
,p_message_text=>unistr('Agregaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276198238676866423)
,p_name=>'APEX.IG.ALL'
,p_message_language=>'es'
,p_message_text=>'Todo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275755441312866149)
,p_name=>'APEX.IG.ALL_TEXT_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Todas las Columnas de Texto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275756605510866150)
,p_name=>'APEX.IG.ALTERNATIVE'
,p_message_language=>'es'
,p_message_text=>'Alternativo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275757774749866151)
,p_name=>'APEX.IG.AND'
,p_message_language=>'es'
,p_message_text=>'y'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276103766362866364)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT'
,p_message_language=>'es'
,p_message_text=>'Recuento de los Valores Distintos Aprox.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276233326243866444)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT_OVERALL'
,p_message_language=>'es'
,p_message_text=>'Recuento aproximado general de valores distintos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276191312658866418)
,p_name=>'APEX.IG.AREA'
,p_message_language=>'es'
,p_message_text=>unistr('\00C1rea')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276196860291866422)
,p_name=>'APEX.IG.ASCENDING'
,p_message_language=>'es'
,p_message_text=>'Ascendente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275756720230866150)
,p_name=>'APEX.IG.AUTHORIZATION'
,p_message_language=>'es'
,p_message_text=>unistr('Autorizaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276232424669866444)
,p_name=>'APEX.IG.AUTO'
,p_message_language=>'es'
,p_message_text=>unistr('Autom\00E1tico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276104171761866364)
,p_name=>'APEX.IG.AVG'
,p_message_language=>'es'
,p_message_text=>'Media'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276233015273866444)
,p_name=>'APEX.IG.AVG_OVERALL'
,p_message_language=>'es'
,p_message_text=>'Media general'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276190825252866418)
,p_name=>'APEX.IG.AXIS_LABEL_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo de Eje de Etiqueta')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276191037082866418)
,p_name=>'APEX.IG.AXIS_VALUE_DECIMAL'
,p_message_language=>'es'
,p_message_text=>'Posiciones Decimales'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276190947575866418)
,p_name=>'APEX.IG.AXIS_VALUE_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo de Eje de Valor')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276205028985866427)
,p_name=>'APEX.IG.BACKGROUND_COLOR'
,p_message_language=>'es'
,p_message_text=>'Color de Fondo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276191447451866418)
,p_name=>'APEX.IG.BAR'
,p_message_language=>'es'
,p_message_text=>'Barra'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275739127982866139)
,p_name=>'APEX.IG.BETWEEN'
,p_message_language=>'es'
,p_message_text=>'entre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276206721682866428)
,p_name=>'APEX.IG.BOTH'
,p_message_language=>'es'
,p_message_text=>'Ambos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276191579394866418)
,p_name=>'APEX.IG.BUBBLE'
,p_message_language=>'es'
,p_message_text=>'Burbuja'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275497902631865989)
,p_name=>'APEX.IG.CANCEL'
,p_message_language=>'es'
,p_message_text=>'Cancelar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275757633861866151)
,p_name=>'APEX.IG.CASE_SENSITIVE'
,p_message_language=>'es'
,p_message_text=>unistr('Sensible a May\00FAsculas/Min\00FAsculas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276233909661866445)
,p_name=>'APEX.IG.CASE_SENSITIVE_WITH_BRACKETS'
,p_message_language=>'es'
,p_message_text=>unistr('(Sensible a May\00FAsculas/Min\00FAsculas)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276143481605866388)
,p_name=>'APEX.IG.CHANGES_SAVED'
,p_message_language=>'es'
,p_message_text=>'Se han guardado los cambios'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275498345728865990)
,p_name=>'APEX.IG.CHANGE_VIEW'
,p_message_language=>'es'
,p_message_text=>'Cambiar Vista'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275758704121866151)
,p_name=>'APEX.IG.CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1fico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275754166285866148)
,p_name=>'APEX.IG.CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'es'
,p_message_text=>unistr('La consulta supera el m\00E1ximo de %0 puntos de datos por gr\00E1fico. Aplique un filtro para reducir el n\00FAmero de registros de la consulta base.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275496680782865989)
,p_name=>'APEX.IG.CHART_VIEW'
,p_message_language=>'es'
,p_message_text=>'Vista de Diagrama'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275559976468866028)
,p_name=>'APEX.IG.CLEAR'
,p_message_language=>'es'
,p_message_text=>'Borrar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276190339234866418)
,p_name=>'APEX.IG.CLOSE_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Cerrar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276205709488866427)
,p_name=>'APEX.IG.COLORS'
,p_message_language=>'es'
,p_message_text=>'Colores'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276205684529866427)
,p_name=>'APEX.IG.COLOR_BLUE'
,p_message_language=>'es'
,p_message_text=>'Azul'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276205501143866427)
,p_name=>'APEX.IG.COLOR_GREEN'
,p_message_language=>'es'
,p_message_text=>'Verde'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276205308163866427)
,p_name=>'APEX.IG.COLOR_ORANGE'
,p_message_language=>'es'
,p_message_text=>'Naranja'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276205410440866427)
,p_name=>'APEX.IG.COLOR_RED'
,p_message_language=>'es'
,p_message_text=>'Rojo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276205259668866427)
,p_name=>'APEX.IG.COLOR_YELLOW'
,p_message_language=>'es'
,p_message_text=>'Amarillo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275757007919866150)
,p_name=>'APEX.IG.COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275496832829865989)
,p_name=>'APEX.IG.COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276210593885866430)
,p_name=>'APEX.IG.COLUMN_TYPE'
,p_message_language=>'es'
,p_message_text=>'Objetivo de la Columna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275757162534866150)
,p_name=>'APEX.IG.COMPLEX'
,p_message_language=>'es'
,p_message_text=>'Complejo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275497044616865989)
,p_name=>'APEX.IG.COMPUTE'
,p_message_language=>'es'
,p_message_text=>'Calcular'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275739778171866140)
,p_name=>'APEX.IG.CONTAINS'
,p_message_language=>'es'
,p_message_text=>'contiene'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275763037899866154)
,p_name=>'APEX.IG.CONTROL_BREAK'
,p_message_language=>'es'
,p_message_text=>unistr('Divisi\00F3n de Control')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275559707865866028)
,p_name=>'APEX.IG.COPY_CB'
,p_message_language=>'es'
,p_message_text=>'Copiar en portapapeles'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275559839517866028)
,p_name=>'APEX.IG.COPY_DOWN'
,p_message_language=>'es'
,p_message_text=>'Copiar hacia abajo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276103522878866364)
,p_name=>'APEX.IG.COUNT'
,p_message_language=>'es'
,p_message_text=>'Recuento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276103635674866364)
,p_name=>'APEX.IG.COUNT_DISTINCT'
,p_message_language=>'es'
,p_message_text=>'Recuento de los Valores Distintos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276233226216866444)
,p_name=>'APEX.IG.COUNT_DISTINCT_OVERALL'
,p_message_language=>'es'
,p_message_text=>'Recuento general de valores distintos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276233101981866444)
,p_name=>'APEX.IG.COUNT_OVERALL'
,p_message_language=>'es'
,p_message_text=>'Recuento General'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276224668201866439)
,p_name=>'APEX.IG.CREATE_X'
,p_message_language=>'es'
,p_message_text=>'Crear %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275755620655866149)
,p_name=>'APEX.IG.DATA'
,p_message_language=>'es'
,p_message_text=>'Datos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276207902212866428)
,p_name=>'APEX.IG.DATA_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Dato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276206932275866428)
,p_name=>'APEX.IG.DATE'
,p_message_language=>'es'
,p_message_text=>'Fecha'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276143251725866388)
,p_name=>'APEX.IG.DATE_INVALID_VALUE'
,p_message_language=>'es'
,p_message_text=>unistr('Valor de fecha no v\00E1lido')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275740630297866140)
,p_name=>'APEX.IG.DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('d\00EDas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275756317004866150)
,p_name=>'APEX.IG.DEFAULT_SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n por Defecto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275756148028866150)
,p_name=>'APEX.IG.DEFAULT_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo por Defecto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275497810060865989)
,p_name=>'APEX.IG.DELETE'
,p_message_language=>'es'
,p_message_text=>'Suprimir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276211568765866431)
,p_name=>'APEX.IG.DELETE_REPORT_CONFIRM'
,p_message_language=>'es'
,p_message_text=>unistr('\00BFSeguro que desea suprimir este informe?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275764846142866155)
,p_name=>'APEX.IG.DELETE_ROW'
,p_message_language=>'es'
,p_message_text=>'Suprimir Fila'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275763675826866154)
,p_name=>'APEX.IG.DELETE_ROWS'
,p_message_language=>'es'
,p_message_text=>'Suprimir Filas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276196928246866422)
,p_name=>'APEX.IG.DESCENDING'
,p_message_language=>'es'
,p_message_text=>'Descendente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275758492766866151)
,p_name=>'APEX.IG.DETAIL'
,p_message_language=>'es'
,p_message_text=>'Detalle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275496340945865988)
,p_name=>'APEX.IG.DETAIL_VIEW'
,p_message_language=>'es'
,p_message_text=>'Vista de Detalles'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276159153212866398)
,p_name=>'APEX.IG.DIRECTION'
,p_message_language=>'es'
,p_message_text=>'Sentido'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275758118801866151)
,p_name=>'APEX.IG.DISABLED'
,p_message_language=>'es'
,p_message_text=>'Desactivado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275739871904866140)
,p_name=>'APEX.IG.DOES_NOT_CONTAIN'
,p_message_language=>'es'
,p_message_text=>'no contiene'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275740093832866140)
,p_name=>'APEX.IG.DOES_NOT_START_WITH'
,p_message_language=>'es'
,p_message_text=>'no empieza por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276191646155866419)
,p_name=>'APEX.IG.DONUT'
,p_message_language=>'es'
,p_message_text=>'Anillo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275763289954866154)
,p_name=>'APEX.IG.DOWNLOAD'
,p_message_language=>'es'
,p_message_text=>'Descargar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276212558716866431)
,p_name=>'APEX.IG.DOWNLOAD_FORMAT'
,p_message_language=>'es'
,p_message_text=>'Seleccionar Formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197842300866422)
,p_name=>'APEX.IG.DUPLICATE_AGGREGATION'
,p_message_language=>'es'
,p_message_text=>unistr('Agregaci\00F3n Duplicada')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197940748866422)
,p_name=>'APEX.IG.DUPLICATE_CONTROLBREAK'
,p_message_language=>'es'
,p_message_text=>unistr('Divisi\00F3n de Control Duplicada')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275764719494866155)
,p_name=>'APEX.IG.DUPLICATE_ROW'
,p_message_language=>'es'
,p_message_text=>'Duplicar Fila'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275763599112866154)
,p_name=>'APEX.IG.DUPLICATE_ROWS'
,p_message_language=>'es'
,p_message_text=>'Filas Duplicadas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275497448430865989)
,p_name=>'APEX.IG.EDIT'
,p_message_language=>'es'
,p_message_text=>'Editar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276196386756866421)
,p_name=>'APEX.IG.EDIT_CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Gr\00E1fico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276220390839866436)
,p_name=>'APEX.IG.EDIT_GROUP_BY'
,p_message_language=>'es'
,p_message_text=>'Editar Grupo por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276212199151866431)
,p_name=>'APEX.IG.EMAIL_BCC'
,p_message_language=>'es'
,p_message_text=>'Copia oculta (Cco)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276212363152866431)
,p_name=>'APEX.IG.EMAIL_BODY'
,p_message_language=>'es'
,p_message_text=>'Mensaje'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276212045995866431)
,p_name=>'APEX.IG.EMAIL_CC'
,p_message_language=>'es'
,p_message_text=>'Copia (Cc)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276211716133866431)
,p_name=>'APEX.IG.EMAIL_SENT'
,p_message_language=>'es'
,p_message_text=>unistr('Correo electr\00F3nico enviado.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276212288474866431)
,p_name=>'APEX.IG.EMAIL_SUBJECT'
,p_message_language=>'es'
,p_message_text=>'Asunto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276211977471866431)
,p_name=>'APEX.IG.EMAIL_TO'
,p_message_language=>'es'
,p_message_text=>'Destinatario (para)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275757836734866151)
,p_name=>'APEX.IG.ENABLED'
,p_message_language=>'es'
,p_message_text=>'Activado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275738188867866139)
,p_name=>'APEX.IG.EQUALS'
,p_message_language=>'es'
,p_message_text=>'igual que'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276211142362866430)
,p_name=>'APEX.IG.EXAMPLE'
,p_message_language=>'es'
,p_message_text=>'Ejemplo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275757938100866151)
,p_name=>'APEX.IG.EXPRESSION'
,p_message_language=>'es'
,p_message_text=>unistr('Expresi\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276211076839866430)
,p_name=>'APEX.IG.FD_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275859995601866214)
,p_name=>'APEX.IG.FILE_PREPARED'
,p_message_language=>'es'
,p_message_text=>'Archivo preparado. Iniciando descarga.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275560099539866028)
,p_name=>'APEX.IG.FILL'
,p_message_language=>'es'
,p_message_text=>'Rellenar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275581487742866042)
,p_name=>'APEX.IG.FILL_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Rellenar selecci\00F3n con')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275581387131866041)
,p_name=>'APEX.IG.FILL_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Rellenar selecci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275496920328865989)
,p_name=>'APEX.IG.FILTER'
,p_message_language=>'es'
,p_message_text=>'Filtro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275757293706866150)
,p_name=>'APEX.IG.FILTERS'
,p_message_language=>'es'
,p_message_text=>'Filtros'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276232786569866444)
,p_name=>'APEX.IG.FILTER_WITH_DOTS'
,p_message_language=>'es'
,p_message_text=>'Filtrar...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197175428866422)
,p_name=>'APEX.IG.FIRST'
,p_message_language=>'es'
,p_message_text=>'Primero'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275497126336865989)
,p_name=>'APEX.IG.FLASHBACK'
,p_message_language=>'es'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275755732571866149)
,p_name=>'APEX.IG.FORMAT'
,p_message_language=>'es'
,p_message_text=>'Formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276206650673866428)
,p_name=>'APEX.IG.FORMATMASK'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1scara de Formato')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276211465535866431)
,p_name=>'APEX.IG.FORMAT_CSV'
,p_message_language=>'es'
,p_message_text=>'CSV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276211302945866431)
,p_name=>'APEX.IG.FORMAT_HTML'
,p_message_language=>'es'
,p_message_text=>'HTML'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275764427590866155)
,p_name=>'APEX.IG.FREEZE'
,p_message_language=>'es'
,p_message_text=>'Congelar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275758007815866151)
,p_name=>'APEX.IG.FUNCTIONS_AND_OPERATORS'
,p_message_language=>'es'
,p_message_text=>'Funciones y Operadores'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276191761621866419)
,p_name=>'APEX.IG.FUNNEL'
,p_message_language=>'es'
,p_message_text=>'Embudo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276103491208866364)
,p_name=>'APEX.IG.GO'
,p_message_language=>'es'
,p_message_text=>'Ir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275738716298866139)
,p_name=>'APEX.IG.GREATER_THAN'
,p_message_language=>'es'
,p_message_text=>'mayor que'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275738802671866139)
,p_name=>'APEX.IG.GREATER_THAN_OR_EQUALS'
,p_message_language=>'es'
,p_message_text=>'mayor o igual que'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275758377789866151)
,p_name=>'APEX.IG.GRID'
,p_message_language=>'es'
,p_message_text=>unistr('Cuadr\00EDcula')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275496156824865988)
,p_name=>'APEX.IG.GRID_VIEW'
,p_message_language=>'es'
,p_message_text=>unistr('Vista de Cuadr\00EDcula')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276198104027866423)
,p_name=>'APEX.IG.GROUP'
,p_message_language=>'es'
,p_message_text=>'Agrupar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275758510402866151)
,p_name=>'APEX.IG.GROUP_BY'
,p_message_language=>'es'
,p_message_text=>'Agrupar por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275496436019865989)
,p_name=>'APEX.IG.GROUP_BY_VIEW'
,p_message_language=>'es'
,p_message_text=>'Vista Agrupar por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276207222797866428)
,p_name=>'APEX.IG.HD_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de Condici\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276206154377866427)
,p_name=>'APEX.IG.HEADING'
,p_message_language=>'es'
,p_message_text=>'Cabecera'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276206367161866428)
,p_name=>'APEX.IG.HEADING_ALIGN'
,p_message_language=>'es'
,p_message_text=>unistr('Alineaci\00F3n de Cabecera')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276232694509866444)
,p_name=>'APEX.IG.HELP'
,p_message_language=>'es'
,p_message_text=>'Ayuda'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276218475174866435)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Puede insertar, actualizar y suprimir datos directamente en esta cuadr\00EDcula interactiva.</p>'),
'',
unistr('<p>Inserte una nueva fila haciendo clic en el bot\00F3n Agregar Fila.</p>'),
'',
unistr('<p>Edite datos existentes haciendo doble clic en una celda espec\00EDfica. Para un trabajo de edici\00F3n mayor, haga clic en Editar para acceder al modo de edici\00F3n. En el modo de edici\00F3n, puede hacer un solo clic o utilizar el teclado para editar celdas esp')
||unistr('ec\00EDficas.</p>'),
'',
unistr('<p>Utilice el men\00FA Cambiar para duplicar y suprimir filas. Para activar el men\00FA Cambiar, utilice las casillas de control para seleccionar una o m\00E1s filas.</p>'),
'',
unistr('<p>Duplique una fila seleccionada haciendo clic en el men\00FA Cambiar y seleccionando Filas duplicadas. Suprima una fila seleccionada haciendo clic en el men\00FA Cambiar y seleccionando Suprimir fila.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276220826735866437)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING_HEADING'
,p_message_language=>'es'
,p_message_text=>unistr('Funciones de Edici\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276220928911866437)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Una cuadr\00EDcula interactiva presenta un juego de datos en un informe personalizable en el que se pueden realizar b\00FAsquedas. Puede realizar diversas operaciones para limitar los registros que se devuelven y cambiar la forma en la que se muestran los')
||' datos.</p>',
'',
unistr('<p>Utilice el campo Buscar para filtrar los registros devueltos. Haga clic en Acciones para acceder a diversas opciones para modificar el dise\00F1o del informe, o utilizar los men\00FAs de Cabecera de Columna en las columnas mostradas.</p>'),
'',
unistr('<p>Utilice Configuraci\00F3n de Informe para guardar sus personalizaciones en un informe. Tambi\00E9n puede descargar los datos del informe en un archivo externo o enviarse a los datos por correo electr\00F3nico a s\00ED mismo o a otros usuarios.</p>'),
'',
unistr('<p>Para obtener m\00E1s informaci\00F3n, consulte "Uso de cuadr\00EDculas interactivas" en <em>Oracle Application Express End User''s Guide</em>.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276220676035866436)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO_HEADING'
,p_message_language=>'es'
,p_message_text=>unistr('Visi\00F3n General')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276218349157866435)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Puede personalizar la cuadr\00EDcula interactiva para mostrar datos en diversos niveles diferentes utilizando las funciones incorporadas.</p>'),
'',
unistr('<p>Utilice los men\00FAs de Cabecera de Columna del men\00FA Acciones para determinar qu\00E9 columnas se deben mostrar, en qu\00E9 secuencia y congelar columnas. Tambi\00E9n puede definir varios filtros de datos y ordenar los datos devueltos.</p>'),
'',
unistr('<p>Utilice el bot\00F3n Ver (junto al campo Buscar) para acceder a otras vistas de datos que puede haber definido el desarrollador de aplicaciones. Tambi\00E9n puede crear un gr\00E1fico o ver un gr\00E1fico existente.</p>  '),
'',
unistr('<p><em>Nota: Haga clic en <strong>Ayuda</strong> en los cuadros de di\00E1logo de la cuadr\00EDcula interactiva para obtener informaci\00F3n m\00E1s detallada sobre la funci\00F3n seleccionada.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276220706586866436)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING_HEADING'
,p_message_language=>'es'
,p_message_text=>unistr('Funciones de Generaci\00F3n de Informes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275763464196866154)
,p_name=>'APEX.IG.HELP.ACTIONS_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Ayuda de Cuadr\00EDcula Interactiva')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276215388291866433)
,p_name=>'APEX.IG.HELP.AGGREGATE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para agregar columnas. Los valores agregados se muestran en la parte inferior de los datos, o si se definen divisiones de control, en la parte inferior de cada divisi\00F3n.</p>'),
'',
unistr('<p><strong>Lista de agregaci\00F3n</strong><br>'),
unistr('La lista de agregaci\00F3n muestra agregaciones definidas. Desactive una agregaci\00F3n existente anulando su selecci\00F3n.<br>'),
unistr('Haga clic en Agregar ( &plus; ) para crear una nueva agregaci\00F3n, o en Suprimir ( &minus; ) para eliminar una agregaci\00F3n existente.</p>'),
'',
unistr('<p><strong>Configuraci\00F3n de agregaci\00F3n</strong><br>'),
unistr('Utilice el formulario a la derecha para definir la agregaci\00F3n.<br>'),
unistr('Seleccione el nombre Columna y el tipo Agregaci\00F3n.<br>'),
unistr('Opcionalmente, introduzca una pista para la agregaci\00F3n.<br>'),
unistr('Si ha definido una divisi\00F3n de control, al seleccionar <strong>Mostrar Valor General</strong> se muestra el valor de media general, total o similar en la parte inferior de los datos.</p>'),
'',
unistr('<p><em>Nota: Acceda al cuadro de di\00E1logo Agregaci\00F3n en el men\00FA Acciones o haciendo clic en la cabecera de columna y suma ( &suma; ).</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276219737248866436)
,p_name=>'APEX.IG.HELP.AGGREGATE_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Ayuda de Agregaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276216095258866433)
,p_name=>'APEX.IG.HELP.CHART'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para definir un gr\00E1fico que se muestre como una vista de datos independiente.<br> '),
unistr('Seleccione un tipo de gr\00E1fico, configure los valores del mismo y haga clic en <strong>Guardar.</strong></p>'),
'',
unistr('<p><strong>Configuraci\00F3n de gr\00E1fico</strong></br>'),
unistr('Los atributos del gr\00E1fico que se muestran var\00EDan en funci\00F3n del tipo de gr\00E1fico. Se puede introducir un n\00FAmero de atributos para definir el gr\00E1fico. Los atributos marcados con un asterisco rojo son obligatorios.</p>'),
'',
unistr('<p>A continuaci\00F3n, se muestran todos los atributos disponibles en diferentes tipos de gr\00E1ficos (en orden alfab\00E9tico):'),
'<ul>',
unistr('  <li>Agregaci\00F3n: Seleccione c\00F3mo agregar los valores del gr\00E1fico asociados.</li> '),
'  <li>Cerrar: Seleccione la columna que contiene el precio de cierre de las acciones diario (solo grafico de mercado de valores).</li> ',
unistr('  <li>Posiciones Decimales: Introduzca el n\00FAmero de posiciones decimales hasta el que se redondean los valores.</li> '),
unistr('  <li>Direcci\00F3n: En relaci\00F3n con el atributo Ordenar por, especifique si los datos se ordenan en valores ascendentes o descendentes.</li> '),
unistr('  <li>Alto: Seleccione la columna que contiene el valor alto (solo los gr\00E1ficos de rango y mercado de valores).</li> '),
'  <li>Etiqueta: Seleccione la columna que contiene el texto para cada punto de datos.</li> ',
unistr('  <li>T\00EDtulo de Eje de Etiqueta: Introduzca el t\00EDtulo que se muestra en el eje de etiqueta.</li> '),
unistr('  <li>Bajo: Seleccione la columna que contiene el valor bajo (solo gr\00E1ficos de rango y mercado de valores).</li> '),
unistr('  <li>Valores Nulos: En relaci\00F3n con el atributo Ordenar por, especifique c\00F3mo desea que se ordenen los registros con valores nulos con respecto a los valores no nulos.</li> '),
unistr('  <li>Abrir: Seleccione la columna que contiene el precio de apertura de las acciones diario (solo gr\00E1fico de mercado de valores).</li> '),
unistr('  <li>Orientaci\00F3n: Seleccione si los elementos del gr\00E1fico, tales como barras, se muestran verticalmente u horizontalmente.</li> '),
unistr('  <li>Serie: Seleccione la columna utilizada para definir su consulta din\00E1mica de varias series.</li> '),
unistr('  <li>Pila: Especifique si los elementos de datos est\00E1n apilados.</li> '),
unistr('  <li>Ordenar por: Seleccione si el gr\00E1fico est\00E1 ordenado por la etiqueta o el(los) valor(es).</li> '),
unistr('  <li>Destino: Seleccione el nombre de columna que se utilizar\00E1 para definir el valor de destino en este gr\00E1fico. Cuando est\00E1 definido, el atributo de valor define el \00E1rea rellenada dentro de la porci\00F3n y Destino representa el valor de toda la porci\00F3')
||unistr('n (solo gr\00E1fico de embudo).</li> '),
'  <li>Valor: Seleccione la columna que contiene los datos que se van a trazar.</li> ',
unistr('  <li>T\00EDtulo del Eje de Valor: Introduzca el t\00EDtulo que se muestra en el eje de valor.</li> '),
unistr('  <li>Volumen: Seleccione la columna que contiene el volumen de acciones diario (solo gr\00E1fico de mercado de valores).</li> '),
unistr('  <li>X: Seleccione la columna que contiene el valor de eje x para este gr\00E1fico (solo gr\00E1ficos de burbuja y de dispersi\00F3n).</li> '),
unistr('  <li>Y: Seleccione la columna que contiene el valor de eje y para este gr\00E1fico (solo gr\00E1ficos de burbuja y de dispersi\00F3n).</li> '),
unistr('  <li>Z: Seleccione la columna que contiene el ancho de barra o el radio de burbuja (solo gr\00E1ficos de barra, burbuja y rango)</li> '),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276220117624866436)
,p_name=>'APEX.IG.HELP.CHART_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Ayuda de Gr\00E1fico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276215099402866433)
,p_name=>'APEX.IG.HELP.COLUMNS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para seleccionar qu\00E9 columnas se muestran y en qu\00E9 orden.</p>'),
'',
unistr('<p>Para ocultar una columna, anule su selecci\00F3n.<br>'),
'Para reordenar columnas, haga clic en Mover Arriba ( &uarr; ) o Mover Abajo ( &darr; ).<br>',
'Utilice el selector desplegable para mostrar Todas las Columnas, Columnas Mostradas o Columnas No Mostradas.</p>',
'',
unistr('<p>Tambi\00E9n puede utilizar el formulario para especificar la anchura m\00EDnima de una columna en p\00EDxeles.</p>'),
'',
unistr('<p><em>Nota: Tambi\00E9n puede reordenar columnas mostradas haciendo clic en el manejador de arrastre (al inicio de la cabecera de columna) y arrastrando la columna a la izquierda o la derecha. Cambie la anchura de las columnas mostradas seleccionando el')
||unistr(' separador de columna, entre cabeceras, y movi\00E9ndolo hacia la izquierda o la derecha.</em</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276220023259866436)
,p_name=>'APEX.IG.HELP.COLUMNS_TITLE'
,p_message_language=>'es'
,p_message_text=>'Ayuda de Columnas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276215481585866433)
,p_name=>'APEX.IG.HELP.COMPUTE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para definir columnas adicionales basadas en los c\00E1lculos matem\00E1ticos y funcionales realizados en columnas existentes.</p>'),
'',
unistr('<p><strong>Lista de c\00E1lculo</strong><br>'),
unistr('La lista de c\00E1lculo muestra c\00E1lculos definidos. Desactive un c\00E1lculo existente anulando su selecci\00F3n.<br>'),
unistr('Haga clic en Agregar ( &plus; ) para agregar un nuevo c\00E1lculo, o en Suprimir ( &minus; ) para eliminar un c\00E1lculo existente.</p>'),
'',
unistr('<p><strong>Configuraci\00F3n de c\00E1lculo</strong><br>'),
unistr('Utilice el formulario para definir el c\00E1lculo.<br>'),
unistr('Introduzca los detalles de la columna, como la cabecera y la etiqueta y seleccione la configuraci\00F3n de alineaci\00F3n.<br> '),
unistr('Utilice el \00E1rea de texto Expresi\00F3n para introducir la(s) columna(s) y las funciones asociadas para el c\00E1lculo.<br>'),
unistr('Seleccione el tipo de datos adecuado y, opcionalmente, una m\00E1scara de formato para la nueva columna.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276219638362866436)
,p_name=>'APEX.IG.HELP.COMPUTE_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Ayuda de C\00E1lculo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276215702135866433)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para definir una divisi\00F3n de control en una o m\00E1s columnas.</p>'),
'',
'<p><strong>Lista de divisiones de control</strong><br>',
unistr('La lista de divisiones de control muestra divisiones de control definidas. Desactive una columna de divisi\00F3n de control existente anulando su selecci\00F3n.<br>'),
unistr('Haga clic en Agregar ( &plus; ) para incluir una nueva columna en la divisi\00F3n de control, o en Suprimir ( &minus; ) para eliminar una columna existente de la divisi\00F3n de control.<br>'),
unistr('Para reordenar columna, haga clic en Mover Arriba ( &uarr; ) o Mover Abajo ( &darr; ) para mover la columna seleccionada arriba y abajo en relaci\00F3n con otras columnas.</p>'),
'',
unistr('<p><strong>Configuraci\00F3n de divisi\00F3n de control</strong><br>'),
unistr('Utilice este formulario para definir la columna de divisi\00F3n de control.<br>'),
unistr('Seleccione una columna de divisi\00F3n de control, la direcci\00F3n de ordenaci\00F3n y el modo de ordenar las columnas nulas (columnas sin valor).</p>'),
'',
unistr('<p><em>Nota: Al visualizar la cuadr\00EDcula interactiva, puede definir una divisi\00F3n de control haciendo clic en una cabecera de columna y seleccionando el icono de divisi\00F3n de control.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276219389217866436)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Ayuda de Divisi\00F3n de Control')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276215905879866433)
,p_name=>'APEX.IG.HELP.DOWNLOAD'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para descargar todas las filas actuales en un archivo externo. El archivo contendr\00E1 solo las columnas mostradas actualmente, con cualquier filtro y ordenaci\00F3n que se haya aplicado a los datos.</p>'),
'',
'<p>Seleccione el formato de archivo y haga clic en Descargar.<br>',
unistr('Nota: CSV no incluir\00E1 formato de texto, tal como agregaciones y divisiones de control.</p>'),
'',
unistr('<p>Para enviar un archivo por correo electr\00F3nico, seleccione Enviar como correo electr\00F3nico e introduzca los detalles del correo en cuesti\00F3n (destinatario, asunto y mensaje).</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276219159903866435)
,p_name=>'APEX.IG.HELP.DOWNLOAD_TITLE'
,p_message_language=>'es'
,p_message_text=>'Ayuda de Descarga'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276215196310866433)
,p_name=>'APEX.IG.HELP.FILTER'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para configurar filtros de datos que limiten las filas devueltas.</p>'),
'',
'<p><strong>Lista de Filtros</strong><br>',
unistr('La lista de filtros muestra filtros definidos. Desactive un filtro existente anulando su selecci\00F3n.<br>'),
'Haga clic en Agregar ( &plus; ) para crear un nuevo filtro, o en Suprimir (&minus; ) para eliminar un filtro existente.</p>',
'',
'<p><strong>Valores de Filtro</strong><br>',
'Utilice el formulario para definir las propiedades del filtro.<br>',
'Seleccione el tipo de filtro adecuado:<br>',
unistr('&nbsp;&nbsp;&nbsp;Fila: filtra por un t\00E9rmino en cualquier columna que se pueda filtrar.<br>'),
unistr('&nbsp;&nbsp;&nbsp;Columna: filtra una columna espec\00EDfica con un valor y un operador espec\00EDfico.<br>'),
'',
unistr('<p><em>Nota: Al visualizar la cuadr\00EDcula interactiva, puede definir los filtros de fila escribiendo directamente en el campo Buscar. Haga clic en Seleccionar Columnas a buscar para limitar la b\00FAsqueda a una columna espec\00EDfica. Como alternativa, abra ')
||unistr('un men\00FA Cabecera de Columna y seleccione un valor para crear un filtro de columna.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276219929144866436)
,p_name=>'APEX.IG.HELP.FILTER_TITLE'
,p_message_language=>'es'
,p_message_text=>'Ayuda de Filtro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276215579737866433)
,p_name=>'APEX.IG.HELP.FLASHBACK'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para ver los datos tal como exist\00EDan en un punto en el tiempo anterior.</p>'),
unistr('<p>Introduzca el n\00FAmero de minutos en el pasado para ejecutar la consulta de flashback.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276219553580866436)
,p_name=>'APEX.IG.HELP.FLASHBACK_TITLE'
,p_message_language=>'es'
,p_message_text=>'Ayuda de Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276220223272866436)
,p_name=>'APEX.IG.HELP.GROUP_BY_TITLE'
,p_message_language=>'es'
,p_message_text=>'Ayuda de Agrupar por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276215642095866433)
,p_name=>'APEX.IG.HELP.HIGHLIGHT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para resaltar las filas o columnas de datos en funci\00F3n de la condici\00F3n introducida.</p>'),
'',
'<p><strong>Lista de resaltados</strong><br>',
unistr('La lista de resaltados muestra resaltados definidos. Desactive un resaltado existente anulando su selecci\00F3n.<br>'),
'Haga clic en Agregar ( &plus; ) para crear un nuevo resaltado, o en Suprimir ( &minus; ) para eliminar un resaltado existente.</p>',
'',
unistr('<p><strong>Configuraci\00F3n de resaltado</strong><br>'),
'Utilice el formulario para definir las propiedades de resaltado.<br>',
unistr('Introduzca el nombre, seleccione Fila o Columna y seleccione los c\00F3digos de color HTML para al fondo y el texto.<br>'),
unistr('Seleccione el <strong>tipo de condici\00F3n</strong> adecuado para resaltar datos espec\00EDficos:<br>'),
unistr('&nbsp;&nbsp;&nbsp;Fila: se resalta el t\00E9rmino en cualquier columna.<br>'),
unistr('&nbsp;&nbsp;&nbsp;Columna: se resalta dentro de una columna espec\00EDfica en funci\00F3n de un valor y operador especificados.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276219440248866436)
,p_name=>'APEX.IG.HELP.HIGHLIGHT_TITLE'
,p_message_language=>'es'
,p_message_text=>'Ayuda de Resaltado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276215844545866433)
,p_name=>'APEX.IG.HELP.REPORT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para guardar los cambios que ha realizado en el dise\00F1o de cuadr\00EDcula actual y la configuraci\00F3n.<br>'),
unistr('Los desarrolladores de aplicaciones pueden definir varios dise\00F1os de informes alternativos. Siempre que sea posible, tanto usted como los otros usuarios finales pueden guardar un informe como P\00FAblico, de modo que pueda estar disponible para todos los')
||unistr(' usuarios de la cuadr\00EDcula. Tambi\00E9n puede guardar un informe como Privado para que solo usted pueda verlo.</p>'),
'<p>Seleccione uno de los tipos disponibles e introduzca un nombre para el informe guardado.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276219205397866435)
,p_name=>'APEX.IG.HELP.REPORT_TITLE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Ayuda de Informe',
''))
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276215292863866433)
,p_name=>'APEX.IG.HELP.SORT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este cuadro de di\00E1logo para definir el orden de visualizaci\00F3n.</p>'),
'',
'<p><strong>Ordenar Lista</strong><br>',
unistr('El cuadro de di\00E1logo Ordenar muestra una lista de reglas de ordenaci\00F3n configuradas.<br>'),
unistr('Haga clic en Agregar ( &plus; ) para crear una columna de ordenaci\00F3n, o en Suprimir ( &minus; ) para eliminar una columna de ordenaci\00F3n.<br>'),
unistr('Haga clic en Mover Arriba ( &uarr; ) y Mover Abajo ( &darr; ) para mover la columna de ordenaci\00F3n seleccionada arriba y abajo en relaci\00F3n a las otras columnas de ordenaci\00F3n.</p>'),
'',
unistr('<p><strong>Valores de Ordenaci\00F3n</strong><br>'),
unistr('Seleccione una columna de ordenaci\00F3n, la direcci\00F3n de ordenaci\00F3n y el modo de ordenar las columnas nulas (columnas sin valor).</p>'),
'',
'<p><em>Nota: Los datos se pueden ordenar por columnas que no se muestran; sin embargo, no todas las columnas pueden ordenarse.</em><br>',
unistr('<em>Las columnas mostradas pueden ordenarse pulsando las flechas arriba (ascendentes) o abajo (descendentes) al final de las cabeceras de columna. Para agregar una columna posterior a una ordenaci\00F3n existente, mantenga pulsada la tecla May\00FAs y haga c')
||'lic en la flecha arriba o abajo.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276219898302866436)
,p_name=>'APEX.IG.HELP.SORT_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Ayuda de Ordenaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276219066989866435)
,p_name=>'APEX.IG.HELP.SUBSCRIPTION_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Ayuda de Suscripci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275764349142866155)
,p_name=>'APEX.IG.HIDE'
,p_message_language=>'es'
,p_message_text=>'Ocultar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275497352614865989)
,p_name=>'APEX.IG.HIGHLIGHT'
,p_message_language=>'es'
,p_message_text=>'Resaltar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276190450465866418)
,p_name=>'APEX.IG.HIGH_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Superior'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276191281787866418)
,p_name=>'APEX.IG.HORIZONTAL'
,p_message_language=>'es'
,p_message_text=>'Horizontal'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275740521435866140)
,p_name=>'APEX.IG.HOURS'
,p_message_language=>'es'
,p_message_text=>'horas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275758244326866151)
,p_name=>'APEX.IG.ICON'
,p_message_language=>'es'
,p_message_text=>'Icono'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275496232582865988)
,p_name=>'APEX.IG.ICON_VIEW'
,p_message_language=>'es'
,p_message_text=>'Vista de Icono'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275738519909866139)
,p_name=>'APEX.IG.IN'
,p_message_language=>'es'
,p_message_text=>'en'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275763955302866154)
,p_name=>'APEX.IG.INACTIVE_SETTING'
,p_message_language=>'es'
,p_message_text=>'Valor Inactivo'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275764089405866155)
,p_name=>'APEX.IG.INACTIVE_SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n Inactiva')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275811361975866184)
,p_name=>'APEX.IG.INTERNAL_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha producido un error interno al procesar la solicitud de cuadr\00EDcula interactiva.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276218555518866435)
,p_name=>'APEX.IG.INVALID_DATE_FORMAT'
,p_message_language=>'es'
,p_message_text=>unistr('Formato de Fecha No V\00E1lido')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276229112366866442)
,p_name=>'APEX.IG.INVALID_SETTING'
,p_message_language=>'es'
,p_message_text=>unistr('Valor no v\00E1lido')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276229213158866442)
,p_name=>'APEX.IG.INVALID_SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n no v\00E1lida')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276204940223866427)
,p_name=>'APEX.IG.INVALID_SORT_BY'
,p_message_language=>'es'
,p_message_text=>'Ordenar por se ha definido en %0, pero no se ha seleccionado ninguna columna para %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276198088427866422)
,p_name=>'APEX.IG.INVALID_VALUE'
,p_message_language=>'es'
,p_message_text=>unistr('Valor No V\00E1lido')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276186205471866415)
,p_name=>'APEX.IG.INVISIBLE'
,p_message_language=>'es'
,p_message_text=>'No Mostrado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275739344288866139)
,p_name=>'APEX.IG.IN_THE_LAST'
,p_message_language=>'es'
,p_message_text=>unistr('en los \00FAltimos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275739596022866139)
,p_name=>'APEX.IG.IN_THE_NEXT'
,p_message_language=>'es'
,p_message_text=>'en siguiente(s)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275738406702866139)
,p_name=>'APEX.IG.IS_NOT_NULL'
,p_message_language=>'es'
,p_message_text=>unistr('no est\00E1 vac\00EDo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275738317061866139)
,p_name=>'APEX.IG.IS_NULL'
,p_message_language=>'es'
,p_message_text=>unistr('est\00E1 vac\00EDo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276206212383866427)
,p_name=>'APEX.IG.LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276189719601866417)
,p_name=>'APEX.IG.LABEL_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Etiqueta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197259463866422)
,p_name=>'APEX.IG.LAST'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275637264961866076)
,p_name=>'APEX.IG.LAST.DAY'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimo D\00EDa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275637440969866076)
,p_name=>'APEX.IG.LAST.HOUR'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltima Hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275637994478866076)
,p_name=>'APEX.IG.LAST.MINUTE'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimo Minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275636923967866076)
,p_name=>'APEX.IG.LAST.MONTH'
,p_message_language=>'es'
,p_message_text=>'Mes Pasado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275637082556866076)
,p_name=>'APEX.IG.LAST.WEEK'
,p_message_language=>'es'
,p_message_text=>'Semana Pasada'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275637153195866076)
,p_name=>'APEX.IG.LAST.X_DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimos %0 D\00EDas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275637352007866076)
,p_name=>'APEX.IG.LAST.X_HOURS'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimas %0 Horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275638024484866077)
,p_name=>'APEX.IG.LAST.X_MINUTES'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimos %0 Minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275637834311866076)
,p_name=>'APEX.IG.LAST.X_MONTHS'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimos %0 Meses')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275637798184866076)
,p_name=>'APEX.IG.LAST.X_WEEKS'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimas %0 Semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275636735507866076)
,p_name=>'APEX.IG.LAST.X_YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimos %0 A\00F1os')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275636811990866076)
,p_name=>'APEX.IG.LAST.YEAR'
,p_message_language=>'es'
,p_message_text=>unistr('A\00F1o Pasado')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276206406386866428)
,p_name=>'APEX.IG.LAYOUT_ALIGN'
,p_message_language=>'es'
,p_message_text=>unistr('Alineaci\00F3n de Celda')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276206568167866428)
,p_name=>'APEX.IG.LAYOUT_USEGROUPFOR'
,p_message_language=>'es'
,p_message_text=>'Usar Grupos para'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275738997134866139)
,p_name=>'APEX.IG.LESS_THAN'
,p_message_language=>'es'
,p_message_text=>'menor que'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275739096527866139)
,p_name=>'APEX.IG.LESS_THAN_OR_EQUALS'
,p_message_language=>'es'
,p_message_text=>'menor o igual que'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276191880804866419)
,p_name=>'APEX.IG.LINE'
,p_message_language=>'es'
,p_message_text=>unistr('L\00EDnea')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276191986165866419)
,p_name=>'APEX.IG.LINE_WITH_AREA'
,p_message_language=>'es'
,p_message_text=>unistr('L\00EDnea con \00C1rea')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276206837115866428)
,p_name=>'APEX.IG.LISTAGG'
,p_message_language=>'es'
,p_message_text=>'Listagg'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276190515311866418)
,p_name=>'APEX.IG.LOW_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Bajo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276212434690866431)
,p_name=>'APEX.IG.MAILADDRESSES_COMMASEP'
,p_message_language=>'es'
,p_message_text=>unistr('Si introduce varias direcciones, sep\00E1relas con comas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275740108264866140)
,p_name=>'APEX.IG.MATCHES_REGULAR_EXPRESSION'
,p_message_language=>'es'
,p_message_text=>unistr('coincide con expresi\00F3n regular')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276104053234866364)
,p_name=>'APEX.IG.MAX'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1ximo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276233513996866445)
,p_name=>'APEX.IG.MAX_OVERALL'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1ximo general')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276104282881866364)
,p_name=>'APEX.IG.MEDIAN'
,p_message_language=>'es'
,p_message_text=>'Mediana'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276233631645866445)
,p_name=>'APEX.IG.MEDIAN_OVERALL'
,p_message_language=>'es'
,p_message_text=>'Mediana general'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276103916763866364)
,p_name=>'APEX.IG.MIN'
,p_message_language=>'es'
,p_message_text=>unistr('M\00EDnimo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275740402328866140)
,p_name=>'APEX.IG.MINUTES'
,p_message_language=>'es'
,p_message_text=>'minutos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276105731689866365)
,p_name=>'APEX.IG.MINUTES_AGO'
,p_message_language=>'es'
,p_message_text=>'Minutos antes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276233416687866445)
,p_name=>'APEX.IG.MIN_OVERALL'
,p_message_language=>'es'
,p_message_text=>unistr('M\00EDnimo general')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275741057994866140)
,p_name=>'APEX.IG.MONTHS'
,p_message_language=>'es'
,p_message_text=>'meses'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275764283825866155)
,p_name=>'APEX.IG.MORE_DATA_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('Los datos contienen m\00E1s de %0 filas que exceden el m\00E1ximo permitido. Aplique los filtros adicionales para ver los resultados.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275756206016866150)
,p_name=>'APEX.IG.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275756434407866150)
,p_name=>'APEX.IG.NAMED_REPORT'
,p_message_language=>'es'
,p_message_text=>'Informe con Nombre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275636127354866075)
,p_name=>'APEX.IG.NEXT.DAY'
,p_message_language=>'es'
,p_message_text=>unistr('D\00EDa Siguiente')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275635973702866075)
,p_name=>'APEX.IG.NEXT.HOUR'
,p_message_language=>'es'
,p_message_text=>'Hora Siguiente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275638162827866077)
,p_name=>'APEX.IG.NEXT.MINUTE'
,p_message_language=>'es'
,p_message_text=>unistr('Pr\00F3ximo Minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275636418384866076)
,p_name=>'APEX.IG.NEXT.MONTH'
,p_message_language=>'es'
,p_message_text=>'Mes Siguiente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275636332509866075)
,p_name=>'APEX.IG.NEXT.WEEK'
,p_message_language=>'es'
,p_message_text=>'Semana Siguiente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275636223018866075)
,p_name=>'APEX.IG.NEXT.X_DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('Siguientes %0 D\00EDas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275636090723866075)
,p_name=>'APEX.IG.NEXT.X_HOURS'
,p_message_language=>'es'
,p_message_text=>'Siguientes %0 Horas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275638271921866077)
,p_name=>'APEX.IG.NEXT.X_MINUTES'
,p_message_language=>'es'
,p_message_text=>unistr('Pr\00F3ximos %0 Minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275637578970866076)
,p_name=>'APEX.IG.NEXT.X_MONTHS'
,p_message_language=>'es'
,p_message_text=>unistr('Pr\00F3ximos %0 Meses')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275637612098866076)
,p_name=>'APEX.IG.NEXT.X_WEEKS'
,p_message_language=>'es'
,p_message_text=>unistr('Pr\00F3ximas %0 Semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275636608672866076)
,p_name=>'APEX.IG.NEXT.X_YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('Siguientes %0 A\00F1os')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275636559811866076)
,p_name=>'APEX.IG.NEXT.YEAR'
,p_message_language=>'es'
,p_message_text=>unistr('A\00F1o Siguiente')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275739227288866139)
,p_name=>'APEX.IG.NOT_BETWEEN'
,p_message_language=>'es'
,p_message_text=>'no entre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275738296686866139)
,p_name=>'APEX.IG.NOT_EQUALS'
,p_message_language=>'es'
,p_message_text=>'distinto de'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276258605921866461)
,p_name=>'APEX.IG.NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>unistr('La regi\00F3n con el identificador %0 no es una regi\00F3n de cuadr\00EDcula interactiva o no existe en la aplicaci\00F3n %1.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275738681831866139)
,p_name=>'APEX.IG.NOT_IN'
,p_message_language=>'es'
,p_message_text=>'no en'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275739449363866139)
,p_name=>'APEX.IG.NOT_IN_THE_LAST'
,p_message_language=>'es'
,p_message_text=>unistr('no en los \00FAltimos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275739618105866140)
,p_name=>'APEX.IG.NOT_IN_THE_NEXT'
,p_message_language=>'es'
,p_message_text=>unistr('no en los pr\00F3ximos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275764197472866155)
,p_name=>'APEX.IG.NO_DATA_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado ning\00FAn dato')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197056885866422)
,p_name=>'APEX.IG.NULLS'
,p_message_language=>'es'
,p_message_text=>'Valores Nulos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276207023565866428)
,p_name=>'APEX.IG.NUMBER'
,p_message_language=>'es'
,p_message_text=>unistr('Num\00E9rico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197558065866422)
,p_name=>'APEX.IG.OFF'
,p_message_language=>'es'
,p_message_text=>'Desactivado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197689645866422)
,p_name=>'APEX.IG.ON'
,p_message_language=>'es'
,p_message_text=>'Activado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275721641133866128)
,p_name=>'APEX.IG.ONE_MINUTE_AGO'
,p_message_language=>'es'
,p_message_text=>'Hace 1 minuto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276214768748866433)
,p_name=>'APEX.IG.OPEN_COLORPICKER'
,p_message_language=>'es'
,p_message_text=>'Abrir Selector de Color: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276190208418866418)
,p_name=>'APEX.IG.OPEN_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Abrir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275757375859866150)
,p_name=>'APEX.IG.OPERATOR'
,p_message_language=>'es'
,p_message_text=>'Operador'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276189679882866417)
,p_name=>'APEX.IG.ORIENTATION'
,p_message_language=>'es'
,p_message_text=>unistr('Orientaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276192029073866419)
,p_name=>'APEX.IG.PIE'
,p_message_language=>'es'
,p_message_text=>'Tarta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275758691463866151)
,p_name=>'APEX.IG.PIVOT'
,p_message_language=>'es'
,p_message_text=>unistr('Din\00E1mica')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275496504063865989)
,p_name=>'APEX.IG.PIVOT_VIEW'
,p_message_language=>'es'
,p_message_text=>unistr('Vista Din\00E1mica')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276214611913866433)
,p_name=>'APEX.IG.PLACEHOLDER_INVALUES'
,p_message_language=>'es'
,p_message_text=>'Separar valores con "%0"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276192156050866419)
,p_name=>'APEX.IG.POLAR'
,p_message_language=>'es'
,p_message_text=>'Polar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276205952673866427)
,p_name=>'APEX.IG.POSITION_CENTER'
,p_message_language=>'es'
,p_message_text=>'Centro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276206007954866427)
,p_name=>'APEX.IG.POSITION_END'
,p_message_language=>'es'
,p_message_text=>'Fin'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276205825660866427)
,p_name=>'APEX.IG.POSITION_START'
,p_message_language=>'es'
,p_message_text=>'Inicio'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275756556012866150)
,p_name=>'APEX.IG.PRIMARY'
,p_message_language=>'es'
,p_message_text=>'Primario'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275756808996866150)
,p_name=>'APEX.IG.PRIMARY_DEFAULT'
,p_message_language=>'es'
,p_message_text=>'Por Defecto Primario'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276051867565866332)
,p_name=>'APEX.IG.PRIMARY_REPORT'
,p_message_language=>'es'
,p_message_text=>'Informe Primario'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276192244773866419)
,p_name=>'APEX.IG.RADAR'
,p_message_language=>'es'
,p_message_text=>'Radial'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276192349762866419)
,p_name=>'APEX.IG.RANGE'
,p_message_language=>'es'
,p_message_text=>'Rango'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276216129729866434)
,p_name=>'APEX.IG.REFRESH'
,p_message_language=>'es'
,p_message_text=>'Refrescar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275764926741866155)
,p_name=>'APEX.IG.REFRESH_ROW'
,p_message_language=>'es'
,p_message_text=>'Refrescar Fila'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275763701536866154)
,p_name=>'APEX.IG.REFRESH_ROWS'
,p_message_language=>'es'
,p_message_text=>'Refrescar Filas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275498040037865990)
,p_name=>'APEX.IG.REMOVE_CONTROL'
,p_message_language=>'es'
,p_message_text=>'Eliminar %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275755934342866150)
,p_name=>'APEX.IG.REPORT'
,p_message_language=>'es'
,p_message_text=>'Informe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276249395174866455)
,p_name=>'APEX.IG.REPORT.DELETED'
,p_message_language=>'es'
,p_message_text=>'Informe suprimido'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276249023741866455)
,p_name=>'APEX.IG.REPORT.SAVED.ALTERNATIVE'
,p_message_language=>'es'
,p_message_text=>'Se ha guardado el informe alternativo para todos los usuarios'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276248944247866454)
,p_name=>'APEX.IG.REPORT.SAVED.DEFAULT'
,p_message_language=>'es'
,p_message_text=>'Se ha guardado el informe por defecto para todos los usuarios'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276249203104866455)
,p_name=>'APEX.IG.REPORT.SAVED.PRIVATE'
,p_message_language=>'es'
,p_message_text=>'Informe privado guardado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276249126718866455)
,p_name=>'APEX.IG.REPORT.SAVED.PUBLIC'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha guardado el informe p\00FAblico para todos los usuarios')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275721577908866128)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF.X.MINUTES_AGO'
,p_message_language=>'es'
,p_message_text=>'Informar de datos de hace %0 minutos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275721434671866128)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF_ONE_MINUTE_AGO'
,p_message_language=>'es'
,p_message_text=>'Informar de datos de hace 1 minuto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276220549309866436)
,p_name=>'APEX.IG.REPORT_EDIT'
,p_message_language=>'es'
,p_message_text=>'Informe - Editar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276220411329866436)
,p_name=>'APEX.IG.REPORT_SAVE_AS'
,p_message_language=>'es'
,p_message_text=>'Informe - Guardar como'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275498137743865990)
,p_name=>'APEX.IG.REPORT_SETTINGS'
,p_message_language=>'es'
,p_message_text=>'Valores de Informe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276258705847866461)
,p_name=>'APEX.IG.REPORT_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>unistr('La cuadr\00EDcula interactiva guardada con el identificador est\00E1tico %0 no existe.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276232890962866444)
,p_name=>'APEX.IG.REPORT_VIEW'
,p_message_language=>'es'
,p_message_text=>'Vista de Informe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275497221825865989)
,p_name=>'APEX.IG.RESET'
,p_message_language=>'es'
,p_message_text=>'Restablecer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275765036969866155)
,p_name=>'APEX.IG.REVERT_CHANGES'
,p_message_language=>'es'
,p_message_text=>'Revertir Cambios'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275763862166866154)
,p_name=>'APEX.IG.REVERT_ROWS'
,p_message_language=>'es'
,p_message_text=>'Revertir Filas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275756907736866150)
,p_name=>'APEX.IG.ROW'
,p_message_language=>'es'
,p_message_text=>'Fila'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275755814815866150)
,p_name=>'APEX.IG.ROWS_PER_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Filas por P\00E1gina')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276257366308866460)
,p_name=>'APEX.IG.ROW_ACTIONS'
,p_message_language=>'es'
,p_message_text=>'Acciones de Fila'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276264514149866465)
,p_name=>'APEX.IG.ROW_ACTIONS_FOR'
,p_message_language=>'es'
,p_message_text=>'Acciones para la fila %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275497580203865989)
,p_name=>'APEX.IG.SAVE'
,p_message_language=>'es'
,p_message_text=>'Guardar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275839936282866201)
,p_name=>'APEX.IG.SAVED'
,p_message_language=>'es'
,p_message_text=>'guardado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275495734434865988)
,p_name=>'APEX.IG.SAVED_REPORTS'
,p_message_language=>'es'
,p_message_text=>'Informes Guardados'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275495810446865988)
,p_name=>'APEX.IG.SAVED_REPORT_DEFAULT'
,p_message_language=>'es'
,p_message_text=>'Valor por Defecto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275495922998865988)
,p_name=>'APEX.IG.SAVED_REPORT_PRIVATE'
,p_message_language=>'es'
,p_message_text=>'Privado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275496002517865988)
,p_name=>'APEX.IG.SAVED_REPORT_PUBLIC'
,p_message_language=>'es'
,p_message_text=>unistr('P\00FAblico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276232543180866444)
,p_name=>'APEX.IG.SAVE_AS'
,p_message_language=>'es'
,p_message_text=>'Guardar como'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275763183246866154)
,p_name=>'APEX.IG.SAVE_REPORT_SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Guardar Configuraci\00F3n de Informe')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276192441004866419)
,p_name=>'APEX.IG.SCATTER'
,p_message_language=>'es'
,p_message_text=>unistr('Dispersi\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275495626784865988)
,p_name=>'APEX.IG.SEARCH'
,p_message_language=>'es'
,p_message_text=>'Buscar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276211293091866431)
,p_name=>'APEX.IG.SEARCH.ALL_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Buscar: Todas las columnas de texto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275495527194865988)
,p_name=>'APEX.IG.SEARCH.COLUMN'
,p_message_language=>'es'
,p_message_text=>'Buscar: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276210090801866430)
,p_name=>'APEX.IG.SEARCH.ORACLE_TEXT'
,p_message_language=>'es'
,p_message_text=>'Buscar: Texto completo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275721314448866128)
,p_name=>'APEX.IG.SEARCH_FOR.X'
,p_message_language=>'es'
,p_message_text=>'Buscar ''%0'''
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276185997840866415)
,p_name=>'APEX.IG.SELECT'
,p_message_language=>'es'
,p_message_text=>'- Seleccionar -'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275560121316866028)
,p_name=>'APEX.IG.SELECTION'
,p_message_language=>'es'
,p_message_text=>unistr('Selecci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276158747388866398)
,p_name=>'APEX.IG.SELECT_1_ROW_IN_MASTER'
,p_message_language=>'es'
,p_message_text=>unistr('Seleccione 1 fila en la regi\00F3n maestra')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275495439711865988)
,p_name=>'APEX.IG.SELECT_COLUMNS_TO_SEARCH'
,p_message_language=>'es'
,p_message_text=>'Seleccionar Columnas a Buscar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276256348544866459)
,p_name=>'APEX.IG.SEL_ACTIONS'
,p_message_language=>'es'
,p_message_text=>unistr('Acciones de Selecci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275560313558866028)
,p_name=>'APEX.IG.SEL_MODE_CELL'
,p_message_language=>'es'
,p_message_text=>unistr('Selecci\00F3n de celdas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275560266219866028)
,p_name=>'APEX.IG.SEL_MODE_ROW'
,p_message_language=>'es'
,p_message_text=>unistr('Selecci\00F3n de Fila')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276211826863866431)
,p_name=>'APEX.IG.SEND_AS_EMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Enviar como Correo Electr\00F3nico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276195331795866421)
,p_name=>'APEX.IG.SERIES_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Serie'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275456364371865962)
,p_name=>'APEX.IG.SHOW'
,p_message_language=>'es'
,p_message_text=>'Mostrar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276071237566866344)
,p_name=>'APEX.IG.SHOW_OVERALL_VALUE'
,p_message_language=>'es'
,p_message_text=>'Mostrar Valor General'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275764663074866155)
,p_name=>'APEX.IG.SINGLE_ROW_VIEW'
,p_message_language=>'es'
,p_message_text=>'Vista de Una Sola Fila'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275758803672866151)
,p_name=>'APEX.IG.SORT'
,p_message_language=>'es'
,p_message_text=>'Ordenar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276195405065866421)
,p_name=>'APEX.IG.SORT_BY'
,p_message_language=>'es'
,p_message_text=>'Ordenar por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276257492531866460)
,p_name=>'APEX.IG.SORT_ONLY_ONE_PER_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Solo se puede definir una ordenaci\00F3n por columna.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276256580760866459)
,p_name=>'APEX.IG.SRV_CHANGE_MENU'
,p_message_language=>'es'
,p_message_text=>unistr('Cambiar Men\00FA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197743001866422)
,p_name=>'APEX.IG.STACK'
,p_message_language=>'es'
,p_message_text=>'Apilar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275739937327866140)
,p_name=>'APEX.IG.STARTS_WITH'
,p_message_language=>'es'
,p_message_text=>'empieza por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276192511438866419)
,p_name=>'APEX.IG.STOCK'
,p_message_language=>'es'
,p_message_text=>'Valores'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275385055575865913)
,p_name=>'APEX.IG.STRETCH_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Expandir anchos de columna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275763356433866154)
,p_name=>'APEX.IG.SUBSCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Suscripci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276103826486866364)
,p_name=>'APEX.IG.SUM'
,p_message_language=>'es'
,p_message_text=>'Suma'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276264720161866465)
,p_name=>'APEX.IG.SUMMARY'
,p_message_language=>'es'
,p_message_text=>unistr('Cuadr\00EDcula interactiva. Informe: %0, vista: %1.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276232998606866444)
,p_name=>'APEX.IG.SUM_OVERALL'
,p_message_language=>'es'
,p_message_text=>'Suma general'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276190751704866418)
,p_name=>'APEX.IG.TARGET_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Destino'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276205180664866427)
,p_name=>'APEX.IG.TEXT_COLOR'
,p_message_language=>'es'
,p_message_text=>'Color del Texto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275498213141865990)
,p_name=>'APEX.IG.TOGGLE'
,p_message_language=>'es'
,p_message_text=>'Conmutar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276071130252866344)
,p_name=>'APEX.IG.TOOLTIP'
,p_message_language=>'es'
,p_message_text=>'Pista'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275756002831866150)
,p_name=>'APEX.IG.TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275764557720866155)
,p_name=>'APEX.IG.UNFREEZE'
,p_message_language=>'es'
,p_message_text=>'Descongelar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275757511485866151)
,p_name=>'APEX.IG.UNIT'
,p_message_language=>'es'
,p_message_text=>'Unidad'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276211697564866431)
,p_name=>'APEX.IG.UNSAVED_CHANGES_CONTINUE_CONFIRM'
,p_message_language=>'es'
,p_message_text=>unistr('Hay cambios sin guardar. \00BFDesea continuar?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275757462477866150)
,p_name=>'APEX.IG.VALUE'
,p_message_language=>'es'
,p_message_text=>'Valor'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276189818821866417)
,p_name=>'APEX.IG.VALUE_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Valor'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276198840286866423)
,p_name=>'APEX.IG.VALUE_REQUIRED'
,p_message_language=>'es'
,p_message_text=>'Se necesita un valor.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276143309812866388)
,p_name=>'APEX.IG.VALUE_TIMESTAMP_TZ'
,p_message_language=>'es'
,p_message_text=>'Valor (no se puede cambiar la zona horaria)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276207183732866428)
,p_name=>'APEX.IG.VARCHAR2'
,p_message_language=>'es'
,p_message_text=>'Texto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276191130666866418)
,p_name=>'APEX.IG.VERTICAL'
,p_message_language=>'es'
,p_message_text=>'Vertical'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275755542261866149)
,p_name=>'APEX.IG.VIEW'
,p_message_language=>'es'
,p_message_text=>'Ver'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276186067532866415)
,p_name=>'APEX.IG.VISIBLE'
,p_message_language=>'es'
,p_message_text=>'Mostrado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276190687784866418)
,p_name=>'APEX.IG.VOLUME_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Volumen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275740975643866140)
,p_name=>'APEX.IG.WEEKS'
,p_message_language=>'es'
,p_message_text=>'semanas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276186109607866415)
,p_name=>'APEX.IG.WIDTH'
,p_message_language=>'es'
,p_message_text=>unistr('Ancho de Columna M\00EDnimo (P\00EDxel)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275671109086866097)
,p_name=>'APEX.IG.X.BETWEEN.Y.AND.Z'
,p_message_language=>'es'
,p_message_text=>'%0 entre %1 y %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275670864289866097)
,p_name=>'APEX.IG.X.CONTAINS.Y'
,p_message_language=>'es'
,p_message_text=>'%0 contiene %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275670927996866097)
,p_name=>'APEX.IG.X.DOES_NOT_CONTAIN.Y'
,p_message_language=>'es'
,p_message_text=>'%0 no contiene %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275452517760865959)
,p_name=>'APEX.IG.X.DOES_NOT_START_WITH.Y'
,p_message_language=>'es'
,p_message_text=>'%0 no empieza por %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275669670370866096)
,p_name=>'APEX.IG.X.EQUALS.Y'
,p_message_language=>'es'
,p_message_text=>'%0 igual que %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275669830316866096)
,p_name=>'APEX.IG.X.GREATER_THAN.Y'
,p_message_language=>'es'
,p_message_text=>'%0 mayor que %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275669913565866096)
,p_name=>'APEX.IG.X.GREATER_THAN_OR_EQUALS.Y'
,p_message_language=>'es'
,p_message_text=>'0% mayor o igual que %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275670673789866097)
,p_name=>'APEX.IG.X.IN.Y'
,p_message_language=>'es'
,p_message_text=>'%0 en %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275671842405866097)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en los \00FAltimos %1 d\00EDas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275671670141866097)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.HOURS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en las \00FAltimas %1 horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275671472209866097)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MINUTES'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en los \00FAltimos %1 minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275672279693866098)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MONTHS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en los \00FAltimos %1 meses')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275672011551866098)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.WEEKS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en las \00FAltimas %1 semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275672495028866098)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en los \00FAltimos %1 a\00F1os')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275671717366866097)
,p_name=>'APEX.IG.X.IN_THE_LAST_DAY'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en el \00FAltimo d\00EDa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275671503267866097)
,p_name=>'APEX.IG.X.IN_THE_LAST_HOUR'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en la \00FAltima hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275671350488866097)
,p_name=>'APEX.IG.X.IN_THE_LAST_MINUTE'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en el \00FAltimo minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275672186910866098)
,p_name=>'APEX.IG.X.IN_THE_LAST_MONTH'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en el \00FAltimo mes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275671944134866097)
,p_name=>'APEX.IG.X.IN_THE_LAST_WEEK'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en la \00FAltima semana')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275672353587866098)
,p_name=>'APEX.IG.X.IN_THE_LAST_YEAR'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en el \00FAltimo a\00F1o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275674228324866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en los pr\00F3ximos %1 d\00EDas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275674094838866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.HOURS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en las pr\00F3ximas %1 horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275673801438866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en los pr\00F3ximos %1 minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275674600048866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en los pr\00F3ximos %1 meses')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275674485711866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en las pr\00F3ximas %1 semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275674813696866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en los pr\00F3ximos %1 a\00F1os')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275674100329866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT_DAY'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en el pr\00F3ximo d\00EDa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275673996733866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT_HOUR'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en la pr\00F3xima hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275673711357866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MINUTE'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en el pr\00F3ximo minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275674599852866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MONTH'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en el pr\00F3ximo mes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275674331487866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT_WEEK'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en la pr\00F3xima semana')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275674734792866099)
,p_name=>'APEX.IG.X.IN_THE_NEXT_YEAR'
,p_message_language=>'es'
,p_message_text=>unistr('%0 en el pr\00F3ximo a\00F1o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275670343029866097)
,p_name=>'APEX.IG.X.IS_NOT_NULL'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no est\00E1 vac\00EDo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275670204608866096)
,p_name=>'APEX.IG.X.IS_NULL'
,p_message_language=>'es'
,p_message_text=>unistr('%0 est\00E1 vac\00EDo')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275670087219866096)
,p_name=>'APEX.IG.X.LESS_THAN.Y'
,p_message_language=>'es'
,p_message_text=>'%0 menor que %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275670152070866096)
,p_name=>'APEX.IG.X.LESS_THAN_OR_EQUALS.Y'
,p_message_language=>'es'
,p_message_text=>'0% menor o igual que %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275670491994866097)
,p_name=>'APEX.IG.X.LIKE.Y'
,p_message_language=>'es'
,p_message_text=>'%0 como %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275671008961866097)
,p_name=>'APEX.IG.X.MATCHES_REGULAR_EXPRESSION.Y'
,p_message_language=>'es'
,p_message_text=>unistr('%0 coincide con la expresi\00F3n regular %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275721787856866128)
,p_name=>'APEX.IG.X.MINUTES_AGO'
,p_message_language=>'es'
,p_message_text=>'Hace %0 minutos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275671202515866097)
,p_name=>'APEX.IG.X.NOT_BETWEEN.Y.AND.Z'
,p_message_language=>'es'
,p_message_text=>'%0 no entre %1 y %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275669719244866096)
,p_name=>'APEX.IG.X.NOT_EQUALS.Y'
,p_message_language=>'es'
,p_message_text=>'%0 distinto de %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275670777664866097)
,p_name=>'APEX.IG.X.NOT_IN.Y'
,p_message_language=>'es'
,p_message_text=>'%0 no en %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275673011228866098)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en los \00FAltimos %1 d\00EDas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275672818315866098)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.HOURS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en las \00FAltimas %1 horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275672627880866098)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MINUTES'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en los \00FAltimos %1 minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275673490120866099)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MONTHS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en los \00FAltimos %1 meses')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275673211158866098)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.WEEKS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en las \00FAltimas %1 semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275673625596866099)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en los \00FAltimos %1 a\00F1os')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275672941128866098)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_DAY'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en el \00FAltimo d\00EDa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275672771668866098)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_HOUR'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en la \00FAltima hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275672584853866098)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MINUTE'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en el \00FAltimo minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275673350044866098)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MONTH'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en el \00FAltimo mes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275673102623866098)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_WEEK'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en la \00FAltima semana')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275673524986866099)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_YEAR'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en el \00FAltimo a\00F1o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275675487108866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en los pr\00F3ximos %1 d\00EDas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275675201201866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.HOURS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en las pr\00F3ximas %1 horas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275675025569866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en los pr\00F3ximos %1 minutos')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275675858606866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en los pr\00F3ximos %1 meses ')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275675612714866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en las pr\00F3ximas %1 semanas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275676051078866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en los pr\00F3ximos %1 a\00F1os')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275675394996866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_DAY'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en el pr\00F3ximo d\00EDa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275675100204866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_HOUR'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en la pr\00F3xima hora')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275674909292866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MINUTE'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en el pr\00F3ximo minuto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275675790579866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MONTH'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en el pr\00F3ximo mes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275675541639866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_WEEK'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en la pr\00F3xima semana')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275675925629866100)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_YEAR'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no en el pr\00F3ximo a\00F1o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275670536877866097)
,p_name=>'APEX.IG.X.NOT_LIKE.Y'
,p_message_language=>'es'
,p_message_text=>'%0 no como %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275731604766866135)
,p_name=>'APEX.IG.X.STARTS_WITH.Y'
,p_message_language=>'es'
,p_message_text=>'0% empieza por %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276189953735866417)
,p_name=>'APEX.IG.X_COLUMN'
,p_message_language=>'es'
,p_message_text=>'X'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275741159656866140)
,p_name=>'APEX.IG.YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('a\00F1os')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276190039348866418)
,p_name=>'APEX.IG.Y_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Y'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276190112495866418)
,p_name=>'APEX.IG.Z_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Z'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276210609940866430)
,p_name=>'APEX.IG_FORMAT_SAMPLE_1'
,p_message_language=>'es'
,p_message_text=>'Lunes, 12 de enero, 2016'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276210776522866430)
,p_name=>'APEX.IG_FORMAT_SAMPLE_2'
,p_message_language=>'es'
,p_message_text=>'Enero'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276210859450866430)
,p_name=>'APEX.IG_FORMAT_SAMPLE_3'
,p_message_language=>'es'
,p_message_text=>'Hace 16 horas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276210979579866430)
,p_name=>'APEX.IG_FORMAT_SAMPLE_4'
,p_message_language=>'es'
,p_message_text=>'en 16 h'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275066731064865707)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_language=>'es'
,p_message_text=>unistr('El soporte de impresi\00F3n debe ser Est\00E1ndar o Avanzado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275066883705865707)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_language=>'es'
,p_message_text=>'No se puede eliminar el primer esquema provisionado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274955672522865635)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Identificador de aplicaci\00F3n no v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275493659669865987)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_language=>'es'
,p_message_text=>unistr('Direcci\00F3n de Correo Electr\00F3nico No V\00E1lida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274936700239865623)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_language=>'es'
,p_message_text=>'El valor debe ser cero o un entero positivo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275066957977865707)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de puerto no v\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275529431186866009)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('ID de suscripci\00F3n no v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275067005045865707)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_language=>'es'
,p_message_text=>'La ruta de acceso de la cartera debe estar en el archivo de pantallas: <filesystempath>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275158461180865766)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_language=>'es'
,p_message_text=>'No se ha encontrado el espacio de trabajo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275158391771865766)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_language=>'es'
,p_message_text=>unistr('Identificador de espacio de trabajo no v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275085967914865720)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_language=>'es'
,p_message_text=>unistr('El valor "%1" del par\00E1metro de instancia "%0" no coincide con la expresi\00F3n regular "%2"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275085893410865720)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('El par\00E1metro de instancia "%0" debe tener un valor')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275067180341865707)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_language=>'es'
,p_message_text=>unistr('Par\00E1metro de instancia no encontrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275525037830866006)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Contrase\00F1a')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274890493597865594)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Contrase\00F1a (Para autenticaci\00F3n s\00F3lo en repositorio de cuentas de usuario de espacio de trabajo)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275810578959866183)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Contrase\00F1a (Para autenticaci\00F3n s\00F3lo en repositorio de cuentas de usuario de espacio de trabajo)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275632024865866073)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Contrase\00F1a (Para autenticaci\00F3n s\00F3lo en repositorio de cuentas de usuario de espacio de trabajo)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275212261974865801)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Contrase\00F1a (Para autenticaci\00F3n s\00F3lo en repositorio de cuentas de usuario de espacio de trabajo)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275524955905866006)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Contrase\00F1a (Para autenticaci\00F3n s\00F3lo en repositorio de cuentas de usuario de espacio de trabajo)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275069046028865709)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_language=>'es'
,p_message_text=>unistr('El protocolo del servidor de impresi\00F3n debe ser http o https')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275069124860865709)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>'El esquema no existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275069203706865709)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_language=>'es'
,p_message_text=>unistr('El esquema est\00E1 restringido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274915376095865610)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274915159886865610)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('La Aplicaci\00F3n ya no existe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275859735124866213)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_language=>'es'
,p_message_text=>'Asignar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276140086049866386)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_language=>'es'
,p_message_text=>'Tarjetas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274917223679865611)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_language=>'es'
,p_message_text=>'Comentado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274917132831865611)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_language=>'es'
,p_message_text=>'comentarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274891929991865595)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_language=>'es'
,p_message_text=>'Suprimir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274891770627865595)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_language=>'es'
,p_message_text=>unistr('\00BFSeguro que desea suprimir este comentario?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275844190883866204)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_language=>'es'
,p_message_text=>'Suprimir problema'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274901513472865601)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_language=>'es'
,p_message_text=>unistr('\00BFSeguro que desea suprimir esta incidencia?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274918877147865612)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_language=>'es'
,p_message_text=>'Documento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274917745098865611)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_language=>'es'
,p_message_text=>'Documentos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274891870832865595)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_language=>'es'
,p_message_text=>'Editar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276067606384866342)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_language=>'es'
,p_message_text=>'Editar Comentario'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276067727363866342)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_language=>'es'
,p_message_text=>'Editar Problema'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274915999904865610)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>unistr('La aplicaci\00F3n especificada no existe en este espacio de trabajo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274916329086865610)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_language=>'es'
,p_message_text=>'Error al intentar suprimir el comentario.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274916217059865610)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>'No se ha encontrado el comentario.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274916566723865610)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>'No se ha encontrado la incidencia.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274916694361865610)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_language=>'es'
,p_message_text=>'Error al intentar marcar la incidencia para suprimir.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274916057727865610)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina especificada no existe en este espacio de trabajo ni en la aplicaci\00F3n indicada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274916465160865610)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_language=>'es'
,p_message_text=>unistr('El usuario no est\00E1 autorizado a suprimir el comentario.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274916733079865611)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_language=>'es'
,p_message_text=>unistr('El usuario no est\00E1 autorizado a suprimir la incidencia.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274916142021865610)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_language=>'es'
,p_message_text=>unistr('El usuario no est\00E1 autorizado para cambiar la visibilidad de este comentario.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276076584939866347)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha producido un problema al comprobar los tama\00F1os de archivo. P\00F3ngase en contacto con el administrador del sistema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276076493125866347)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_language=>'es'
,p_message_text=>unistr('Uno de estos archivos es m\00E1s grande que el tama\00F1o m\00E1ximo de archivo de %0 bytes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276076364232866347)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_language=>'es'
,p_message_text=>unistr('Este archivo es m\00E1s grande que el tama\00F1o m\00E1ximo de archivo de %0 bytes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274892056592865595)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_language=>'es'
,p_message_text=>'Ocultar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274918609314865612)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_language=>'es'
,p_message_text=>'Imagen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274917566717865611)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_language=>'es'
,p_message_text=>unistr('Im\00E1genes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274914959440865609)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>'una incidencia que no se ha encontrado en el sistema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274875670969865585)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_language=>'es'
,p_message_text=>unistr('A\00F1adir Preferencias para Usuario')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274917328329865611)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_language=>'es'
,p_message_text=>'Adjuntar Archivos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274917075857865611)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_language=>'es'
,p_message_text=>'Cerrado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276145685438866390)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_language=>'es'
,p_message_text=>'Cabecera'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274918374092865612)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_language=>'es'
,p_message_text=>unistr('est\00E1 vac\00EDo.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274918101357865611)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_language=>'es'
,p_message_text=>unistr('Uno de estos archivos est\00E1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274916984540865611)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_language=>'es'
,p_message_text=>'Abrir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274919494266865612)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_language=>'es'
,p_message_text=>unistr('Suprimir Selecci\00F3n Permanentemente')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275845006709866204)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_language=>'es'
,p_message_text=>'Depurar Todo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274919387318865612)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_language=>'es'
,p_message_text=>unistr('Restaurar Selecci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274917426750865611)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_language=>'es'
,p_message_text=>'Plantillas de Respuestas'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274918289994865611)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_language=>'es'
,p_message_text=>'demasiado grande para cargar. <br>Los archivos deben pesar menos de'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274918596475865612)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_language=>'es'
,p_message_text=>'Los tipos de archivo soportados son: '
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276071504018866344)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Seleccione una plantilla de respuesta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274918009121865611)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_language=>'es'
,p_message_text=>unistr('Este archivo est\00E1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274918439990865612)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_language=>'es'
,p_message_text=>'no es un tipo de archivo soportado.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275783816397866167)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_language=>'es'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275784415466866167)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_language=>'es'
,p_message_text=>unistr('Problema de documentaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275783935213866167)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_language=>'es'
,p_message_text=>'Solicitud de Mejora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275784087389866167)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_language=>'es'
,p_message_text=>unistr('Solicitud de funci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275784320599866167)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_language=>'es'
,p_message_text=>unistr('Problema de instalaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275784253266866167)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_language=>'es'
,p_message_text=>'Problema de rendimiento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275784102234866167)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_language=>'es'
,p_message_text=>'Problema de seguridad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275784507022866167)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_language=>'es'
,p_message_text=>unistr('Problema de formaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275785275550866167)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_language=>'es'
,p_message_text=>unistr('Administraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275784977434866167)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_language=>'es'
,p_message_text=>'CSS / HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275785012209866167)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_language=>'es'
,p_message_text=>unistr('Acciones din\00E1micas / JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275784746776866167)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_language=>'es'
,p_message_text=>'Base de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275785370506866168)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_language=>'es'
,p_message_text=>unistr('Integraci\00F3n de sistema externo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275784870035866167)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_language=>'es'
,p_message_text=>unistr('Integraci\00F3n de REST')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275785142315866167)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_language=>'es'
,p_message_text=>'Seguridad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275784610755866167)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_language=>'es'
,p_message_text=>'UI / UX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275783784729866167)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Categor\00EDa asignada al problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275782860228866166)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Categor\00EDa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275783666746866166)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('\00C1rea funcional afectada por el problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275782957617866166)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('\00C1rea funcional')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275783501805866166)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_language=>'es'
,p_message_text=>'Nivel de importancia asignado al problema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275783071498866166)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_language=>'es'
,p_message_text=>'Importancia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275783473352866166)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_language=>'es'
,p_message_text=>'Nivel de esfuerzo para abordar el problema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275783167384866166)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_language=>'es'
,p_message_text=>'Nivel de esfuerzo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275783375110866166)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_language=>'es'
,p_message_text=>'Progreso frente al problema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275783223775866166)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_language=>'es'
,p_message_text=>'Progreso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275785773411866168)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_language=>'es'
,p_message_text=>'Atraso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275785475359866168)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_language=>'es'
,p_message_text=>unistr('Cr\00EDtico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275785537819866168)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_language=>'es'
,p_message_text=>'Importante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275785609989866168)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_language=>'es'
,p_message_text=>'Normal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275785815262866168)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_language=>'es'
,p_message_text=>unistr('No se abordar\00E1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275785904864866168)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_language=>'es'
,p_message_text=>unistr('Soluci\00F3n f\00E1cil')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275786141344866168)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_language=>'es'
,p_message_text=>'Gran esfuerzo de desarrollo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275786087567866168)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_language=>'es'
,p_message_text=>'Esfuerzo moderado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275786587171866168)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_language=>'es'
,p_message_text=>'No se puede reparar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275786642793866168)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_language=>'es'
,p_message_text=>'Terminado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275786327813866168)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_language=>'es'
,p_message_text=>unistr('Necesita m\00E1s informaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275786435076866168)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_language=>'es'
,p_message_text=>'A la espera de un tercero'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275786239138866168)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_language=>'es'
,p_message_text=>'Trabajando en ello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275796925650866175)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_language=>'es'
,p_message_text=>unistr('Este grupo de etiquetas no se puede eliminar porque uno o m\00E1s de sus miembros est\00E1n asignados a un problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274916813882865611)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_language=>'es'
,p_message_text=>'Marcado como duplicado de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275844570899866204)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_language=>'es'
,p_message_text=>'Personas asignadas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275844427895866204)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_language=>'es'
,p_message_text=>'Etiquetas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275844971896866204)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_language=>'es'
,p_message_text=>'Hitos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275844389192866204)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_language=>'es'
,p_message_text=>'Estado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274914724682865609)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_language=>'es'
,p_message_text=>'hitos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275787229702866169)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_language=>'es'
,p_message_text=>unistr('Congelaci\00F3n del C\00F3digo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275787484581866169)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_language=>'es'
,p_message_text=>unistr('Versi\00F3n final')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275787359078866169)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_language=>'es'
,p_message_text=>unistr('Congelaci\00F3n de IU')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274919215692865612)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_language=>'es'
,p_message_text=>'%0 ha agregado un comentario a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274875322930865584)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_language=>'es'
,p_message_text=>'ha cambiado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275801155521866177)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_language=>'es'
,p_message_text=>unistr('El n\00FAmero de problema %0 en el espacio de trabajo %1 ha cambiado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276076249371866347)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_language=>'es'
,p_message_text=>'No se ha definido ninguna etiqueta.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274917909848865611)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_language=>'es'
,p_message_text=>'Otro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274915447590865610)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274915227757865610)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina ya no existe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276137568746866385)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_language=>'es'
,p_message_text=>'Depurar Todo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275859870626866213)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_language=>'es'
,p_message_text=>'Eliminar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274915082188865609)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_language=>'es'
,p_message_text=>unistr('Se han eliminado las asociaciones de P\00E1gina y Aplicaci\00F3n de')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274915725745865610)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_language=>'es'
,p_message_text=>'Se ha eliminado el adjunto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276111310264866369)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_language=>'es'
,p_message_text=>unistr('\00BFDesea sustituir su comentario actual por esta plantilla?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276113332385866370)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hola: ',
'',
unistr('Esta es su primera incidencia. Puede crear incidencias para hacer un seguimiento de tareas, funciones, errores y comentarios de todos sus proyectos APEX. Puede a\00F1adir etiquetas a las incidencias, agregar personas asignadas, establecer hitos e incluso')
||unistr(' aplicar formato con el m\00E9todo abreviado Markdown.  '),
'',
unistr('A continuaci\00F3n se ofrece una breve muestra de lo que se puede hacer con Markdown:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276113260432866370)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('\00A1Bienvenido a Desarrollo de equipos en Oracle APEX!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275860109534866214)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_language=>'es'
,p_message_text=>'- Seleccionar -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274915857396865610)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_language=>'es'
,p_message_text=>'Definir estado en'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274892210815865595)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_language=>'es'
,p_message_text=>'Mostrar acciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276113117158866370)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_language=>'es'
,p_message_text=>unistr('Mostrar M\00E1s...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274915560122865610)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_language=>'es'
,p_message_text=>'Suscrito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276076692175866347)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_language=>'es'
,p_message_text=>'%0 en el espacio de trabajo %1 tiene %2 notificaciones nuevas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275780301380866164)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_language=>'es'
,p_message_text=>'Plantilla utilizada para registrar un bug.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275780280017866164)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_language=>'es'
,p_message_text=>'Plantilla de bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275780183606866164)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Comportamiento esperado**',
unistr('- D\00EDganos qu\00E9 cree que deber\00EDa suceder.'),
'',
'',
'**Comportamiento actual**',
unistr('- D\00EDganos qu\00E9 sucede.'),
'',
'',
unistr('**A qui\00E9n afecta**'),
unistr('- D\00EDganos qui\00E9n o qu\00E9 est\00E1 afectado. '),
'',
unistr('**Posible soluci\00F3n**'),
unistr('- Si lo sabe, sugiera c\00F3mo corregir este bug.'),
'',
'**Pasos para reproducirlo**',
unistr('- Proporcione un conjunto inequ\00EDvoco de pasos para reproducirlo, incluyendo capturas de pantalla y fragmentos de c\00F3digo, si corresponde.'),
'1.',
'2.',
'3.',
'',
'**Contexto**',
unistr('- \00BFQu\00E9 estaba intentando hacer cuando ocurri\00F3 el bug? \00BFEl bug solo sucede bajo ciertas condiciones, o a ciertas horas del d\00EDa, de forma sucesiva?'),
'',
'**Entorno**',
'',
unistr('- Versi\00F3n: '),
'- Plataforma: ',
'- Subsistema:',
'',
'______',
'',
unistr('_**NOTA:** Para asociar una incidencia con una aplicaci\00F3n y/o p\00E1gina, registre primero la incidencia; a continuaci\00F3n, use el men\00FA desplegable **ACCIONES** para asociar la aplicaci\00F3n y la p\00E1gina._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275781475872866165)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_language=>'es'
,p_message_text=>'Se ha creado un bug.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275781382606866165)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_language=>'es'
,p_message_text=>'Bug creado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275781592727866165)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Se ha archivado un **bug** en el sistema externo adecuado.',
'',
'- Sistema de seguimiento de bugs: ',
'- ID de bug: ',
'- URL al bug: ',
'',
'Comentarios:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275780593309866165)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla utilizada para registrar una solicitud de funci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275780409809866164)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla de solicitud de funci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275780621766866165)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Resumen de funciones**',
unistr(' - Proporcione un resumen general de un p\00E1rrafo de la solicitud de funci\00F3n.'),
'',
'',
'**Contexto**',
unistr(' - \00BFEst\00E1 relacionada esta solicitud con una situaci\00F3n o proceso espec\00EDfico? Por ejemplo, "Siempre me siento frustrado cuando [...]"'),
'',
'',
unistr(' - Proporcione cualquier informaci\00F3n de apoyo, incluyendo capturas de pantalla, casos de uso, etc.'),
'',
'',
unistr('**Soluci\00F3n preferida**'),
unistr('- Proporcione una descripci\00F3n clara de lo que le gustar\00EDa implantar.'),
'',
'',
'**Soluciones alternativas**',
unistr('- Proporcione una descripci\00F3n de las soluciones o funciones alternativas consideradas, o de las soluciones alternativas empleadas.'),
'',
'',
'______',
unistr('_**NOTA:** Para asociar una incidencia con una aplicaci\00F3n y/o p\00E1gina, registre primero la incidencia; a continuaci\00F3n, use el men\00FA desplegable **ACCIONES** para asociar la aplicaci\00F3n y la p\00E1gina._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275781706686866165)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha archivado una solicitud de funci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275781616692866165)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Solicitud de funci\00F3n archivada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275781817751866165)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Se ha archivado una **solicitud de funci\00F3n** en el sistema externo adecuado.'),
'',
'- Sistema de seguimiento de funciones: ',
unistr('- ID de funci\00F3n: '),
unistr('- URL a la definici\00F3n de funci\00F3n: '),
'',
'Comentarios:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275782632214866166)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Se necesita una acci\00F3n de seguimiento.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275782528160866166)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Necesita acci\00F3n de seguimiento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275782707603866166)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Realice las siguientes acciones: ',
'',
'1.',
'2.',
'3.',
'4.',
'',
'Comentarios: '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275780841380866165)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_language=>'es'
,p_message_text=>'Plantilla utilizada para hacer una pregunta de procedimiento.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275780797977866165)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('C\00F3mo puedo ...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275780982838866165)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Pregunta**',
unistr('- Exponga su pregunta o solicitud de la manera m\00E1s concisa posible.'),
'',
'**Contexto general**',
unistr('- \00BFQu\00E9 est\00E1 tratando de hacer? '),
'',
'',
unistr('- \00BFD\00F3nde m\00E1s ha mirado o con qui\00E9n se ha puesto en contacto para encontrar una respuesta? '),
'',
'',
'**Entorno** ',
unistr('\00BFEs esta pregunta espec\00EDfica de un entorno, lenguaje de programaci\00F3n u otra \00E1rea?'),
'',
'______',
unistr('_**NOTA:** Para asociar un problema con una aplicaci\00F3n y/o p\00E1gina, registre primero el problema; a continuaci\00F3n, use el men\00FA desplegable **ACCIONES** para asociar la aplicaci\00F3n y la p\00E1gina._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275782319818866166)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_language=>'es'
,p_message_text=>'Referencia a un problema conocido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275782206560866166)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_language=>'es'
,p_message_text=>'Problema conocido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275782464967866166)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Despu\00E9s de su revisi\00F3n, se ha determinado que se trata de un problema conocido; consulte los detalles a continuaci\00F3n.'),
'',
'- Sistema de seguimiento de bugs: ',
'- ID de bug: ',
'- URL al bug: ',
'',
'Comentarios: '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275782071766866166)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Solicitud de m\00E1s informaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275781947070866165)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Necesita m\00E1s informaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275782186504866166)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**Se necesita m\00E1s informaci\00F3n sobre este problema:**'),
'',
unistr('Proporcione la informaci\00F3n que se solicita a continuaci\00F3n. Sin ella, ser\00E1 dif\00EDcil clasificar y abordar el problema m\00E1s a fondo.'),
'',
'',
'Comentarios:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275781119239866165)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Este problema no generar\00E1 ninguna acci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275781051874866165)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Sin acci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275781218280866165)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Despu\00E9s de una cuidadosa consideraci\00F3n, **no se llevar\00E1n a cabo m\00E1s acciones para este problema**. '),
'',
'Comentarios:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274918906126865612)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_language=>'es'
,p_message_text=>'Archivo de Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274917848308865611)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_language=>'es'
,p_message_text=>'Archivos de Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274914612707865609)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_language=>'es'
,p_message_text=>'esta incidencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275802222232866178)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_language=>'es'
,p_message_text=>'agregado el adjunto %0 a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275801268311866177)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_language=>'es'
,p_message_text=>'agregado %0 a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275802812585866178)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_language=>'es'
,p_message_text=>'agregado %0 a %1 %2				'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275801499051866177)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_language=>'es'
,p_message_text=>'asignado %0 a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275801820758866178)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_language=>'es'
,p_message_text=>'asociado %0 con %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274919175293865612)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_language=>'es'
,p_message_text=>'ha editado un comentario para %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275802766999866178)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_language=>'es'
,p_message_text=>'Este problema se ha ocultado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275801632432866178)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_language=>'es'
,p_message_text=>'marcado %0 como duplicado de %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275802634436866178)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_language=>'es'
,p_message_text=>'Abierto %0 por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275802331073866178)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_language=>'es'
,p_message_text=>'eliminado el adjunto %0 de %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275801378937866177)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_language=>'es'
,p_message_text=>'eliminado %0 de %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275802997753866178)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_language=>'es'
,p_message_text=>'eliminado %0 de %1 %2 			'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275802422320866178)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_language=>'es'
,p_message_text=>'definido estado para %0 en %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275802032306866178)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_language=>'es'
,p_message_text=>'suscrito a %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275801504975866177)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_language=>'es'
,p_message_text=>unistr('anulada la asignaci\00F3n de %0 de %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275801935738866178)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_language=>'es'
,p_message_text=>unistr('eliminada la asociaci\00F3n de p\00E1gina y aplicaci\00F3n de %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275801784118866178)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_language=>'es'
,p_message_text=>'anulado el marcado de %0 como duplicado de %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275802147888866178)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_language=>'es'
,p_message_text=>unistr('anulada la suscripci\00F3n de %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275802589299866178)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_language=>'es'
,p_message_text=>'marcado duplicado de %0 %1 por %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274914889322865609)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_language=>'es'
,p_message_text=>'No Asignado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274892154047865595)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_language=>'es'
,p_message_text=>'Mostrar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274915600387865610)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_language=>'es'
,p_message_text=>unistr('Suscripci\00F3n Cancelada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275844228975866204)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_language=>'es'
,p_message_text=>'Actualizar...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274918770958865612)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_language=>'es'
,p_message_text=>'Archivo Zip'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274917690589865611)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_language=>'es'
,p_message_text=>'Archivos Zip'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276150569889866393)
,p_name=>'APEX.ITEM.FILE.BROWSE'
,p_message_language=>'es'
,p_message_text=>'Examinar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276148401946866391)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILE'
,p_message_language=>'es'
,p_message_text=>'Seleccionar Archivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276148566456866392)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILES'
,p_message_language=>'es'
,p_message_text=>'Seleccionar archivos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276253494801866457)
,p_name=>'APEX.ITEM.HELP_TEXT'
,p_message_language=>'es'
,p_message_text=>'Texto de Ayuda: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276106557128866366)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>'No se ha encontrado el elemento %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274902221766865601)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# no est\00E1 en el rango v\00E1lido de %0 y %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274902331340865601)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_MULTIPLE_OF_STEP'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# no es un m\00FAltiplo de %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274901685625865601)
,p_name=>'APEX.ITEM_TYPE.YES_NO.INVALID_VALUE'
,p_message_language=>'es'
,p_message_text=>'#LABEL# debe coincidir con los valores %0 y %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274901840142865601)
,p_name=>'APEX.ITEM_TYPE.YES_NO.NO_LABEL'
,p_message_language=>'es'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275561406163866029)
,p_name=>'APEX.ITEM_TYPE.YES_NO.OFF_LABEL'
,p_message_language=>'es'
,p_message_text=>'Desactivado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275561505040866029)
,p_name=>'APEX.ITEM_TYPE.YES_NO.ON_LABEL'
,p_message_language=>'es'
,p_message_text=>'Activado'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274901785678865601)
,p_name=>'APEX.ITEM_TYPE.YES_NO.YES_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('S\00ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274872861316865583)
,p_name=>'APEX.LIST_MANAGER.ADD_ENTRY'
,p_message_language=>'es'
,p_message_text=>'Agregar Entrada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275818345875866188)
,p_name=>'APEX.LIST_MANAGER.BUTTON_ADD'
,p_message_language=>'es'
,p_message_text=>'Agregar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275818419873866188)
,p_name=>'APEX.LIST_MANAGER.BUTTON_REMOVE'
,p_message_language=>'es'
,p_message_text=>'Eliminar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274872968092865583)
,p_name=>'APEX.LIST_MANAGER.SELECTED_ENTRY'
,p_message_language=>'es'
,p_message_text=>'Entradas seleccionadas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276050185324866331)
,p_name=>'APEX.LTO.ADVANCED'
,p_message_language=>'es'
,p_message_text=>'Avanzada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276050484227866331)
,p_name=>'APEX.LTO.CANCEL'
,p_message_language=>'es'
,p_message_text=>'Cancelar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276050281028866331)
,p_name=>'APEX.LTO.COMMON'
,p_message_language=>'es'
,p_message_text=>unistr('Com\00FAn')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276050554246866331)
,p_name=>'APEX.LTO.LIVE_TEMPLATE_OPTIONS'
,p_message_language=>'es'
,p_message_text=>'Opciones de Plantilla Activas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276051784773866332)
,p_name=>'APEX.LTO.NOT_APPLICABLE'
,p_message_language=>'es'
,p_message_text=>unistr('Las opciones de plantilla no est\00E1n disponibles porque este componente no est\00E1 representado en la p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276050003176866331)
,p_name=>'APEX.LTO.NO_OPTIONS_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado ninguna opci\00F3n de plantilla.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276050321893866331)
,p_name=>'APEX.LTO.SAVE'
,p_message_language=>'es'
,p_message_text=>'Guardar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276047806020866329)
,p_name=>'APEX.MARKDOWN.BOLD'
,p_message_language=>'es'
,p_message_text=>'Negrita'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276049169237866330)
,p_name=>'APEX.MARKDOWN.IMAGE'
,p_message_language=>'es'
,p_message_text=>'Imagen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276048765135866330)
,p_name=>'APEX.MARKDOWN.INLINE_CODE'
,p_message_language=>'es'
,p_message_text=>unistr('C\00F3digo en l\00EDnea')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276143636835866389)
,p_name=>'APEX.MARKDOWN.INSERT_IMAGE'
,p_message_language=>'es'
,p_message_text=>'Insertar imagen'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276143788430866389)
,p_name=>'APEX.MARKDOWN.INSERT_LINK'
,p_message_language=>'es'
,p_message_text=>'Insertar Enlace'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276047944985866329)
,p_name=>'APEX.MARKDOWN.ITALIC'
,p_message_language=>'es'
,p_message_text=>'Cursiva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276145420362866390)
,p_name=>'APEX.MARKDOWN.LINK'
,p_message_language=>'es'
,p_message_text=>'Enlace'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276049009859866330)
,p_name=>'APEX.MARKDOWN.LIST'
,p_message_language=>'es'
,p_message_text=>'Lista'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276048941866866330)
,p_name=>'APEX.MARKDOWN.ORDERED_LIST'
,p_message_language=>'es'
,p_message_text=>'Lista Ordenada'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276048011462866329)
,p_name=>'APEX.MARKDOWN.PREVIEW'
,p_message_language=>'es'
,p_message_text=>'Vista previa'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276048536170866330)
,p_name=>'APEX.MARKDOWN.PREVIEW_EMPTY'
,p_message_language=>'es'
,p_message_text=>'Nada que mostrar en la vista previa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276048610624866330)
,p_name=>'APEX.MARKDOWN.STRIKETHROUGH'
,p_message_language=>'es'
,p_message_text=>'Tachado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276048848355866330)
,p_name=>'APEX.MARKDOWN.UNORDERED_LIST'
,p_message_language=>'es'
,p_message_text=>'Lista Desordenada'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275676506635866101)
,p_name=>'APEX.MENU.CURRENT_MENU'
,p_message_language=>'es'
,p_message_text=>'actual'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276216733865866434)
,p_name=>'APEX.MENU.OVERFLOW_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1s...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275676461916866101)
,p_name=>'APEX.MENU.PROCESSING'
,p_message_language=>'es'
,p_message_text=>'Cargando'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276127369558866378)
,p_name=>'APEX.NOTIFICATION_MESSAGE_HEADING'
,p_message_language=>'es'
,p_message_text=>unistr('Mensaje de Notificaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275038680439865688)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error de contenido de total de control de mensaje de notificaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275038515296865688)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error de formato de total de control de mensaje de notificaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275752021539866147)
,p_name=>'APEX.NUMBER_FIELD.VALUE_GREATER_MAX_VALUE'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# es mayor que el m\00E1ximo especificado de %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275752132441866147)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# debe ser num\00E9rico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275752250695866147)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID2'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# no coincide con el formato num\00E9rico %0 (Ejemplo: %1).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275751963878866147)
,p_name=>'APEX.NUMBER_FIELD.VALUE_LESS_MIN_VALUE'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# es inferior al m\00EDnimo especificado %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275751833191866147)
,p_name=>'APEX.NUMBER_FIELD.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# no est\00E1 en el rango v\00E1lido de %0 y %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275277651992865843)
,p_name=>'APEX.PAGE.DUPLICATE_SUBMIT'
,p_message_language=>'es'
,p_message_text=>unistr('Esta p\00E1gina ya se ha ejecutado y no se puede volver a ejecutar.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275140342082865755)
,p_name=>'APEX.PAGE.NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado la aplicaci\00F3n "%0" p\00E1gina "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275421221389865936)
,p_name=>'APEX.PAGE_ITEM_IS_REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# debe tener alg\00FAn valor.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276156940489866397)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_language=>'es'
,p_message_text=>unistr('Acerca de esta Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276156762893866397)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_language=>'es'
,p_message_text=>unistr('Opciones de Configuraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276156819823866397)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_language=>'es'
,p_message_text=>unistr('Selecci\00F3n de estilo de tema')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275818771925866188)
,p_name=>'APEX.POPUP_LOV.BUTTON_CLOSE'
,p_message_language=>'es'
,p_message_text=>'Cerrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275818608142866188)
,p_name=>'APEX.POPUP_LOV.BUTTON_FIND'
,p_message_language=>'es'
,p_message_text=>'Buscar %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275818962836866188)
,p_name=>'APEX.POPUP_LOV.BUTTON_NEXT'
,p_message_language=>'es'
,p_message_text=>'Siguiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275818803975866188)
,p_name=>'APEX.POPUP_LOV.BUTTON_PREV'
,p_message_language=>'es'
,p_message_text=>'Anterior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274896216638865598)
,p_name=>'APEX.POPUP_LOV.FILTER_REQ'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca un t\00E9rmino de b\00FAsqueda con al menos %0 caracteres.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275470500796865972)
,p_name=>'APEX.POPUP_LOV.ICON_TEXT'
,p_message_language=>'es'
,p_message_text=>'Lista de Valores Emergente: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274896372138865598)
,p_name=>'APEX.POPUP_LOV.INITIAL_FILTER_REQ'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca un t\00E9rmino de b\00FAsqueda.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274896185475865598)
,p_name=>'APEX.POPUP_LOV.NO_RESULTS'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado ning\00FAn resultado.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274896051930865597)
,p_name=>'APEX.POPUP_LOV.REMOVE_VALUE'
,p_message_language=>'es'
,p_message_text=>'Eliminar %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275638784966866077)
,p_name=>'APEX.POPUP_LOV.SEARCH'
,p_message_language=>'es'
,p_message_text=>unistr('T\00E9rmino de B\00FAsqueda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275818559298866188)
,p_name=>'APEX.POPUP_LOV.TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('B\00FAsqueda')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274898859830865599)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_language=>'es'
,p_message_text=>'No se ha podido obtener el valor de clave primaria anterior o siguiente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275631766459866073)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>'No se ha encontrado el servicio web.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275141850388865756)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>'Error al procesar el proceso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276110937693866368)
,p_name=>'APEX.PROCESSING'
,p_message_language=>'es'
,p_message_text=>'Procesamiento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274925578458865616)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Application Express no ha podido procesar la solicitud debido a las limitaciones de recursos de sesi\00F3n de la base de datos. Vuelva a intentarlo m\00E1s tarde.'),
'<p/>',
unistr('Puede obtener informaci\00F3n sobre este incidente a trav\00E9s del ID de depuraci\00F3n "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276167978956866404)
,p_name=>'APEX.REGION.CSSCALENDAR.ADD'
,p_message_language=>'es'
,p_message_text=>'Agregar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275590120517866047)
,p_name=>'APEX.REGION.CSSCALENDAR.ALL_DAY'
,p_message_language=>'es'
,p_message_text=>unistr('Todo el D\00EDa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276240290347866449)
,p_name=>'APEX.REGION.CSSCALENDAR.BUTTON.SENDEMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Enviar Invitaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276239988362866449)
,p_name=>'APEX.REGION.CSSCALENDAR.CHOOSE_ACTION'
,p_message_language=>'es'
,p_message_text=>'Opciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275605265146866056)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_ALLDAY'
,p_message_language=>'es'
,p_message_text=>unistr('Vista diaria de todos los d\00EDas ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275605004451866056)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_TIME_SPECIFIC'
,p_message_language=>'es'
,p_message_text=>'Vista diaria de los datos con hora '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276129827416866380)
,p_name=>'APEX.REGION.CSSCALENDAR.DAY'
,p_message_language=>'es'
,p_message_text=>unistr('D\00EDa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276076764256866347)
,p_name=>'APEX.REGION.CSSCALENDAR.DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Descripci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274987821685865656)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.CSV'
,p_message_language=>'es'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274987619219865655)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.ICALENDAR'
,p_message_language=>'es'
,p_message_text=>'iCal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274987529457865655)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.PDF'
,p_message_language=>'es'
,p_message_text=>'PDF'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274987700091865656)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.XML'
,p_message_language=>'es'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274987210821865655)
,p_name=>'APEX.REGION.CSSCALENDAR.ENDDATE'
,p_message_language=>'es'
,p_message_text=>unistr('Fecha de Finalizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274987438771865655)
,p_name=>'APEX.REGION.CSSCALENDAR.EVENTNAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276240000807866449)
,p_name=>'APEX.REGION.CSSCALENDAR.INVITATION'
,p_message_language=>'es'
,p_message_text=>unistr('Invitaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276129983697866380)
,p_name=>'APEX.REGION.CSSCALENDAR.LIST'
,p_message_language=>'es'
,p_message_text=>'Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276129609490866380)
,p_name=>'APEX.REGION.CSSCALENDAR.MONTH'
,p_message_language=>'es'
,p_message_text=>'Mes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276144622417866389)
,p_name=>'APEX.REGION.CSSCALENDAR.NEXT'
,p_message_language=>'es'
,p_message_text=>'Siguiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276198377463866423)
,p_name=>'APEX.REGION.CSSCALENDAR.NOEVENTS'
,p_message_language=>'es'
,p_message_text=>'Sin Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276240656993866449)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.FORM'
,p_message_language=>'es'
,p_message_text=>'Editar Evento Existente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276240584616866449)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.SEND'
,p_message_language=>'es'
,p_message_text=>unistr('Enviando invitaci\00F3n a trav\00E9s de correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276144772233866389)
,p_name=>'APEX.REGION.CSSCALENDAR.PREVIOUS'
,p_message_language=>'es'
,p_message_text=>'Anterior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276184099556866414)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Enviar Correo Electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276183666650866414)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.BUTTON'
,p_message_language=>'es'
,p_message_text=>unistr('Enviar Correo Electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276247635688866454)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.REQUIRED'
,p_message_language=>'es'
,p_message_text=>'Todos los campos son necesarios.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276247578903866454)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Enviar Invitaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276239658852866448)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.SUBJECT'
,p_message_language=>'es'
,p_message_text=>'Asunto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276183934188866414)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.TO'
,p_message_language=>'es'
,p_message_text=>'Para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274987358680865655)
,p_name=>'APEX.REGION.CSSCALENDAR.STARTDATE'
,p_message_language=>'es'
,p_message_text=>'Fecha de Inicio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276164620854866402)
,p_name=>'APEX.REGION.CSSCALENDAR.TABLEFORM'
,p_message_language=>'es'
,p_message_text=>'Pantalla Basada en %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275604862949866056)
,p_name=>'APEX.REGION.CSSCALENDAR.TIME'
,p_message_language=>'es'
,p_message_text=>'Hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276145301677866390)
,p_name=>'APEX.REGION.CSSCALENDAR.TODAY'
,p_message_language=>'es'
,p_message_text=>'Hoy'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276130701759866381)
,p_name=>'APEX.REGION.CSSCALENDAR.VIEW'
,p_message_language=>'es'
,p_message_text=>'Ver'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276129786988866380)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEK'
,p_message_language=>'es'
,p_message_text=>'Semana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275605178772866056)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_ALLDAY'
,p_message_language=>'es'
,p_message_text=>unistr('Vista semanal de todos los d\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275604938627866056)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_TIME_SPECIFIC'
,p_message_language=>'es'
,p_message_text=>'Vista semanal de los datos con hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276130339744866380)
,p_name=>'APEX.REGION.CSSCALENDAR.YEAR'
,p_message_language=>'es'
,p_message_text=>unistr('A\00F1o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274899165385865599)
,p_name=>'APEX.REGION.FLASH_CHART.INITIALIZING'
,p_message_language=>'es'
,p_message_text=>'Inicializando...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275158581948865766)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_DATA'
,p_message_language=>'es'
,p_message_text=>'Cargando datos...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276169476677866405)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_RESOURCES'
,p_message_language=>'es'
,p_message_text=>'Cargando recursos...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276169562012866405)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_TEMPLATES'
,p_message_language=>'es'
,p_message_text=>'Cargando plantillas...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274899266507865599)
,p_name=>'APEX.REGION.FLASH_CHART.NO_DATA_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado ning\00FAn dato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275064075225865706)
,p_name=>'APEX.REGION.FLASH_CHART.SHOW_XML'
,p_message_language=>'es'
,p_message_text=>'Mostrar XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275158658153865766)
,p_name=>'APEX.REGION.FLASH_CHART.WAITING'
,p_message_language=>'es'
,p_message_text=>'Cargando datos. Espere.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276130033021866380)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276130144184866380)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.LOAD_MORE'
,p_message_language=>'es'
,p_message_text=>unistr('Cargar M\00E1s...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275330901113865878)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.BACK'
,p_message_language=>'es'
,p_message_text=>unistr('Atr\00E1s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274927093255865617)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.LOAD_MORE'
,p_message_language=>'es'
,p_message_text=>unistr('Cargar M\00E1s...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274952013045865633)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.SEARCH'
,p_message_language=>'es'
,p_message_text=>'Buscar...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276130290544866380)
,p_name=>'APEX.REGION.JQM_REFLOW.LOAD_MORE'
,p_message_language=>'es'
,p_message_text=>unistr('Cargar M\00E1s...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276143949344866389)
,p_name=>'APEX.REGION.NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado el ID de regi\00F3n %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274938261808865624)
,p_name=>'APEX.REGION.NO_DATA_FOUND_MESSAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Ning\00FAn Dato Encontrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275146201601865758)
,p_name=>'APEX.REGION.PAGINATION.RESET_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha podido restablecer la paginaci\00F3n de regi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274899098891865599)
,p_name=>'APEX.REGION.PAGINATION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al definir la paginaci\00F3n de la regi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276071422192866344)
,p_name=>'APEX.REGION.RESPONSIVE_TABLE.COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276143873592866389)
,p_name=>'APEX.REGION.TYPE_NOT_SUPPORTED'
,p_message_language=>'es'
,p_message_text=>unistr('El tipo de regi\00F3n {0} no est\00E1 soportado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274898965497865599)
,p_name=>'APEX.REGION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error en la presentaci\00F3n de la regi\00F3n "#COMPONENT_NAME#".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275421381907865936)
,p_name=>'APEX.REGION_COLUMN_IS_REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('#COLUMN_HEADER# debe tener alg\00FAn valor.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275601434721866054)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_language=>'es'
,p_message_text=>unistr('Error de autenticaci\00F3n del servicio de SQL activado para REST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274925884397865616)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_language=>'es'
,p_message_text=>unistr('Fallo de autenticaci\00F3n. La lista de valores utiliza un origen de datos de SQL activado para REST que hace referencia a credenciales web no v\00E1lidas, que le impedir\00E1n editar la informaci\00F3n de la columna de esta lista de valores. Compruebe las credencia')
||unistr('les de autenticaci\00F3n. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276139779771866386)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_language=>'es'
,p_message_text=>unistr('Fallo de comunicaci\00F3n. Se ha producido un problema al llamar al origen de datos SQL activado para REST por parte de la lista de valores, lo que le impide editar la informaci\00F3n de la columna para la lista de valores. Compruebe que el origen de datos S')
||unistr('QL activado para REST funciona correctamente y que las credenciales de autenticaci\00F3n correspondientes son correctas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275669141984866096)
,p_name=>'APEX.REMOTESQL.OAUTH_IS_RECOMMENDED'
,p_message_language=>'es'
,p_message_text=>unistr('Advertencia: Oracle recomienda el uso de credenciales de cliente de OAuth para la autenticaci\00F3n con SQL activado para REST.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275602818129866055)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_language=>'es'
,p_message_text=>'Error en el servidor remoto: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275559626276866028)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>'No se ha encontrado la instancia SQL activada para REST de ORDS especificada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275160865071865768)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_language=>'es'
,p_message_text=>'El servidor ha enviado un redireccionamiento a: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275448814487865956)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_language=>'es'
,p_message_text=>unistr('La sentencia SQL tiene m\00E1s de 32.767 bytes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275468784278865971)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hola, Application Express. Se ha conectado como #USER#.',
'El registro de hora de la base de datos local es: #SYSDATE#.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275796895384866175)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_language=>'es'
,p_message_text=>unistr('Est\00E1 editando el alias del esquema por defecto del espacio de trabajo. Al ajustarlo, tambi\00E9n cambiar\00E1 el prefijo de la ruta de acceso en el nivel del espacio de trabajo. Esto afectar\00E1 a la URL de cualquier servicio RESTful basado en APEX que haya def')
||'inido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275456066362865961)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ORDS'
,p_message_language=>'es'
,p_message_text=>unistr('La interfaz de administraci\00F3n de REST no est\00E1 soportada por la versi\00F3n actual de ORDS.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275456117934865961)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ROLE'
,p_message_language=>'es'
,p_message_text=>unistr('El rol de cliente proporcionado no est\00E1 soportado por la interfaz de administraci\00F3n de REST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276235487732866446)
,p_name=>'APEX.RICH_TEXT_EDITOR.ACCESSIBLE_LABEL'
,p_message_language=>'es'
,p_message_text=>'%0, editor de texto enriquecido'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275446479229865954)
,p_name=>'APEX.RICH_TEXT_EDITOR.MAXIMUM_LENGTH_EXCEEDED'
,p_message_language=>'es'
,p_message_text=>unistr('El marcador HTML de texto enriquecido supera la longitud m\00E1xima del elemento (real: %0, permitida: %1 caracteres)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276128613245866379)
,p_name=>'APEX.RV.DELETE'
,p_message_language=>'es'
,p_message_text=>'Suprimir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276054429832866333)
,p_name=>'APEX.RV.DUPLICATE'
,p_message_language=>'es'
,p_message_text=>'Duplicado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276049672131866330)
,p_name=>'APEX.RV.EXCLUDE_HIDDEN'
,p_message_language=>'es'
,p_message_text=>'Columnas Mostradas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276049577108866330)
,p_name=>'APEX.RV.EXCLUDE_NULL'
,p_message_language=>'es'
,p_message_text=>'Excluir Valores Nulos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276128732447866379)
,p_name=>'APEX.RV.INSERT'
,p_message_language=>'es'
,p_message_text=>'Agregar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275588871723866046)
,p_name=>'APEX.RV.MOVE_DOWN'
,p_message_language=>'es'
,p_message_text=>'Mover hacia abajo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275588988767866046)
,p_name=>'APEX.RV.MOVE_UP'
,p_message_language=>'es'
,p_message_text=>'Mover hacia arriba'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276049363962866330)
,p_name=>'APEX.RV.NEXT_RECORD'
,p_message_language=>'es'
,p_message_text=>'Siguiente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276049934389866331)
,p_name=>'APEX.RV.NOT_GROUPED_LABEL'
,p_message_language=>'es'
,p_message_text=>'Otras Columnas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276049447987866330)
,p_name=>'APEX.RV.PREV_RECORD'
,p_message_language=>'es'
,p_message_text=>'Anterior'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276049772899866330)
,p_name=>'APEX.RV.REC_X'
,p_message_language=>'es'
,p_message_text=>'Fila %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276049844612866331)
,p_name=>'APEX.RV.REC_XY'
,p_message_language=>'es'
,p_message_text=>'Fila %0 de %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276054576632866333)
,p_name=>'APEX.RV.REFRESH'
,p_message_language=>'es'
,p_message_text=>'Refrescar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276054672585866333)
,p_name=>'APEX.RV.REVERT'
,p_message_language=>'es'
,p_message_text=>'Revertir Cambios'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276049230285866330)
,p_name=>'APEX.RV.SETTINGS_MENU'
,p_message_language=>'es'
,p_message_text=>unistr('Men\00FA Configuraci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275523663875866006)
,p_name=>'APEX.SAMPLE_FORMAT'
,p_message_language=>'es'
,p_message_text=>'Por ejemplo, %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275446592773865954)
,p_name=>'APEX.SC.REFERENCES'
,p_message_language=>'es'
,p_message_text=>'%0 referencias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275788157650866169)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_language=>'es'
,p_message_text=>'Utilidades'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275788282268866169)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Utilidades de aplicaci\00F3n \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275795689725866174)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Ir a P\00E1gina')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275795513687866174)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_language=>'es'
,p_message_text=>'Ir a Componentes compartidos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275788362166866169)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_language=>'es'
,p_message_text=>'Creador de Aplicaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275788444874866169)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_language=>'es'
,p_message_text=>'Tareas del creador de aplicaciones > '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275788522399866170)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('Elementos de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275788631559866170)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C Elementos de aplicaci\00F3n \005C %LIST_ITEM_NAME%')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275788757461866170)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_language=>'es'
,p_message_text=>unistr('L\00F3gica de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275788893148866170)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_language=>'es'
,p_message_text=>unistr('Esquemas de Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275788971404866170)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C Esquemas de autenticaci\00F3n de seguridad \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275789079735866170)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_language=>'es'
,p_message_text=>unistr('Esquemas de Autorizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275789162634866170)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C Esquemas de autorizaci\00F3n de seguridad \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275789259147866170)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_language=>'es'
,p_message_text=>unistr('Rutas de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275789371321866170)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C Rutas de navegaci\00F3n \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275789432552866170)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_language=>'es'
,p_message_text=>unistr('Opciones de Creaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275789569183866170)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C Opciones de creaci\00F3n \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275789621791866170)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_language=>'es'
,p_message_text=>'Valores de Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275789741295866170)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ Valores de componente \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275789861502866170)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_language=>'es'
,p_message_text=>unistr('C\00E1lculos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275789994500866170)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C C\00E1lculos de aplicaci\00F3n \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275790080724866170)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_language=>'es'
,p_message_text=>unistr('Crear Elemento de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275790146885866170)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_language=>'es'
,p_message_text=>unistr('Crear Esquema de Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275790208722866171)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Crear Opci\00F3n de Creaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275790314397866171)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_language=>'es'
,p_message_text=>unistr('Crear c\00E1lculo de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275790465228866171)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Crear plantilla de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275790581510866171)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_language=>'es'
,p_message_text=>'Crear Plugin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275790608234866171)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_language=>'es'
,p_message_text=>'Crear Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275790763431866171)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_language=>'es'
,p_message_text=>'Crear credenciales web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275790887170866171)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_language=>'es'
,p_message_text=>'Definiciones de Carga de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275790959667866171)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ Definiciones de carga de datos \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275791055079866171)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_language=>'es'
,p_message_text=>unistr('Or\00EDgenes de datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275791157386866171)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_language=>'es'
,p_message_text=>unistr('Atributos de definici\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275791247005866171)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_language=>'es'
,p_message_text=>unistr('Plantillas de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275791344909866171)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_language=>'es'
,p_message_text=>unistr('Dise\00F1os de Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275791425509866171)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C Dise\00F1os de informe \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275791510500866171)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_language=>'es'
,p_message_text=>'Servicios web heredados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275791665496866171)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ Servicios web heredados \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275791772018866171)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_language=>'es'
,p_message_text=>unistr('Listas de navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275791899347866171)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C Listas de navegaci\00F3n cl\00E1sica \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275791946520866172)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_language=>'es'
,p_message_text=>'Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275792028181866172)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ Lista de valores \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275792145239866172)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275792294919866172)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_language=>'es'
,p_message_text=>'Otros Componentes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275792395381866172)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_language=>'es'
,p_message_text=>'Plugins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275792434598866172)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ Plugins \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275792596156866172)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_language=>'es'
,p_message_text=>'Procesos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275792616535866172)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C Procesos de aplicaci\00F3n \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275792745277866172)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_language=>'es'
,p_message_text=>'Consultas de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275792841629866172)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ Consultas de informe \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275792929024866172)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_language=>'es'
,p_message_text=>'Informes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275793045249866172)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_language=>'es'
,p_message_text=>'SQL activado para REST'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275793183588866172)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ SQL activado para REST \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275793294785866172)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_language=>'es'
,p_message_text=>'Seguridad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275793336645866172)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_language=>'es'
,p_message_text=>unistr('Protecci\00F3n de Estado de la Sesi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275793417119866173)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_language=>'es'
,p_message_text=>unistr('Definir protecci\00F3n de estado de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275793673024866173)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_language=>'es'
,p_message_text=>'Componentes Compartidos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275793701231866173)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275793829041866173)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E9todos Abreviados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275793986540866173)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C M\00E9todos abreviados \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275794045290866173)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_language=>'es'
,p_message_text=>'Separadores (heredados)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275794117739866173)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_language=>'es'
,p_message_text=>'Plantillas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275794242398866173)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ Plantillas de interfaz de usuario \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275794329607866173)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_language=>'es'
,p_message_text=>'Temas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275794478352866173)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ Temas de interfaz de usuario \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275794516435866173)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_language=>'es'
,p_message_text=>'Interfaz de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275794684155866173)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_language=>'es'
,p_message_text=>'Credenciales web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275794715034866173)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Navegar a: Componentes compartidos \ Credenciales web de seguridad \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275794883082866173)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_language=>'es'
,p_message_text=>unistr('M\00F3dulos de origen web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275794945277866173)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegar a: Componentes compartidos \005C M\00F3dulos de origen web \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275795068272866173)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_language=>'es'
,p_message_text=>'Taller de SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275795139280866174)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_language=>'es'
,p_message_text=>'Crear Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275795210610866174)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Crear %LIST_ITEM_NAME% en taller de SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275795363722866174)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_language=>'es'
,p_message_text=>'Editor de Script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275795484138866174)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_language=>'es'
,p_message_text=>'Tareas del taller de SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276177934174866410)
,p_name=>'APEX.SESSION.DB_SESSION_CLEANUP.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar el c\00F3digo de limpieza de la sesi\00F3n de base de datos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275139819977865754)
,p_name=>'APEX.SESSION.DB_SESSION_INIT.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar el c\00F3digo de configuraci\00F3n de la sesi\00F3n de base de datos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274913598942865609)
,p_name=>'APEX.SESSION.EXPIRED'
,p_message_language=>'es'
,p_message_text=>unistr('La sesi\00F3n ha vencido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276169624564866405)
,p_name=>'APEX.SESSION.EXPIRED.CLOSE_DIALOG'
,p_message_language=>'es'
,p_message_text=>unistr('Cierre este cuadro de di\00E1logo y pulse el bot\00F3n de recarga del explorador para obtener una nueva sesi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276229871859866442)
,p_name=>'APEX.SESSION.EXPIRED.NEW_SESSION'
,p_message_language=>'es'
,p_message_text=>unistr('Haga clic <a href="%0">aqu\00ED</a> para crear una nueva sesi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275592985630866049)
,p_name=>'APEX.SESSION.RAS.NO_DYNAMIC_ROLES'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha podido activar ning\00FAn rol din\00E1mico en la sesi\00F3n de Real Application Security para el usuario "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275132762784865750)
,p_name=>'APEX.SESSION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('ERR-99900: No se ha podido crear un identificador de sesi\00F3n \00FAnico: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276240986983866449)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_language=>'es'
,p_message_text=>unistr('El elemento de la p\00E1gina %0 se basa en una columna de base de datos, pero el atributo ''Origen Utilizado'' se define en ''Solo cuando el valor de sesi\00F3n actual en el estado de sesi\00F3n sea nulo''. Esta acci\00F3n es muy peligrosa y puede dar como resultado que')
||unistr(' se sobrescriban los datos de forma accidental al visualizar y guardar varios registros. Defina siempre ''Origen Utilizado'' en ''Siempre, sustituyendo cualquier valor existente en el estado de sesi\00F3n''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276150409496866393)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_language=>'es'
,p_message_text=>unistr('El acceso al estado de la sesi\00F3n est\00E1 desactivado, el intento de lectura/escritura se ha bloqueado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274951115258865632)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha intentado guardar el elemento %0 en el estado de la sesi\00F3n durante el procesamiento de presentaci\00F3n, el elemento tiene protecci\00F3n de tipo S\00F3lo Interno.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274932548900865620)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha intentado guardar el elemento %0 en el estado de la sesi\00F3n durante el procesamiento de aceptaci\00F3n, el elemento tiene protecci\00F3n de tipo S\00F3lo Interno o no es un elemento de pantalla que se pueda enviar con POST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275207001795865798)
,p_name=>'APEX.SESSION_STATE.ITEM_VALUE_PROTECTION'
,p_message_language=>'es'
,p_message_text=>unistr('Violaci\00F3n de la protecci\00F3n del estado de la sesi\00F3n: puede ser debida a una modificaci\00F3n manual del elemento de p\00E1gina protegido %0. En caso de duda sobre el motivo de este error, p\00F3ngase en contacto con el administrador de la aplicaci\00F3n para recibir ')
||'ayuda.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276265927530866465)
,p_name=>'APEX.SESSION_STATE.PAGE_PROTECTION'
,p_message_language=>'es'
,p_message_text=>unistr('Violaci\00F3n de la protecci\00F3n de la p\00E1gina: puede ser debida al env\00EDo de una p\00E1gina que a\00FAn no se hab\00EDa terminado de cargar o a una modificaci\00F3n manual de los elementos de p\00E1gina protegidos. Para obtener ayuda, p\00F3ngase en contacto con el administrador d')
||unistr('e la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276262866078866463)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR'
,p_message_language=>'es'
,p_message_text=>unistr('%0 contiene uno de los siguientes caracteres no v\00E1lidos &<>"/;,*|=% o --')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276262938774866463)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR_NL'
,p_message_language=>'es'
,p_message_text=>unistr('%0 contiene uno de los siguientes caracteres no v\00E1lidos &<>"/;,*|=% o -- o una nueva l\00EDnea.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276262642111866463)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.US_ONLY'
,p_message_language=>'es'
,p_message_text=>unistr('%0 contiene caracteres especiales. S\00F3lo est\00E1n permitidos los caracteres a-Z, 0-9 y espacios.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276262775392866463)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'es'
,p_message_text=>unistr('%0 contiene <, > o " que son caracteres no v\00E1lidos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274932107515865620)
,p_name=>'APEX.SESSION_STATE.SSP_CHECKSUM_MISSING'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha proporcionado ning\00FAn total de control para el procesamiento de presentaci\00F3n de una p\00E1gina que requiere un total de control cuando se transfieren como par\00E1metros uno o m\00E1s valores de argumento, limpieza de cach\00E9 o solicitud.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275194090965865789)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION'
,p_message_language=>'es'
,p_message_text=>unistr('Violaci\00F3n de la protecci\00F3n del estado de la sesi\00F3n: Puede ser debida a una modificaci\00F3n manual de una direcci\00F3n URL que contenga un total de control, que se haya utilizado un enlace con un total de control incorrecto o que no tenga ning\00FAn total de co')
||unistr('ntrol. En caso de duda sobre el motivo de este error, p\00F3ngase en contacto con el administrador de la aplicaci\00F3n para recibir ayuda.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274932275015865620)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('El total de control calculado a partir de valores de solicitud, borrado de cach\00E9, nombres de argumento y valores de argumento (%0) no ha coincidido con el total de control transferido al procedimiento de presentaci\00F3n (%1).'),
'',
'Nota: los usuarios finales obtienen un mensaje de error diferente.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274931188159865620)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Se ha intentado guardar el elemento %0 en el estado de sesi\00F3n durante el procesamiento de presentaci\00F3n. El nivel de protecci\00F3n del elemento indica:'),
'  %1',
'',
unistr('No se ha transferido ning\00FAn total de control o el total de control que se ha transferido ser\00EDa adecuado para un elemento con un nivel de protecci\00F3n "%2".'),
'',
'Nota: los usuarios finales obtienen un mensaje de error diferente.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275141671555865756)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>'ERR-1022: No se han podido guardar los atributos.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276050655481866331)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_OFF'
,p_message_language=>'es'
,p_message_text=>'Desactivar Modo de Alto Contraste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276050721211866331)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_ON'
,p_message_language=>'es'
,p_message_text=>'Activar Modo de Alto Contraste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275166460062865771)
,p_name=>'APEX.SHUTTLE.CONTROL_BOTTOM'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275166601324865772)
,p_name=>'APEX.SHUTTLE.CONTROL_DOWN'
,p_message_language=>'es'
,p_message_text=>'Abajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275166718243865772)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE'
,p_message_language=>'es'
,p_message_text=>'Mover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275166896190865772)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE_ALL'
,p_message_language=>'es'
,p_message_text=>'Mover Todo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275166957444865772)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE'
,p_message_language=>'es'
,p_message_text=>'Eliminar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275167071170865772)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE_ALL'
,p_message_language=>'es'
,p_message_text=>'Eliminar Todo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275167133980865772)
,p_name=>'APEX.SHUTTLE.CONTROL_RESET'
,p_message_language=>'es'
,p_message_text=>'Restablecer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275166393676865771)
,p_name=>'APEX.SHUTTLE.CONTROL_TOP'
,p_message_language=>'es'
,p_message_text=>'Primero'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275166561700865772)
,p_name=>'APEX.SHUTTLE.CONTROL_UP'
,p_message_language=>'es'
,p_message_text=>'Arriba'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276203877868866426)
,p_name=>'APEX.SINCE.SHORT.DAYS_AGO'
,p_message_language=>'es'
,p_message_text=>'%0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276204507434866426)
,p_name=>'APEX.SINCE.SHORT.DAYS_FROM_NOW'
,p_message_language=>'es'
,p_message_text=>'en %0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276203711487866426)
,p_name=>'APEX.SINCE.SHORT.HOURS_AGO'
,p_message_language=>'es'
,p_message_text=>'%0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276204603378866427)
,p_name=>'APEX.SINCE.SHORT.HOURS_FROM_NOW'
,p_message_language=>'es'
,p_message_text=>'en %0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276203513703866426)
,p_name=>'APEX.SINCE.SHORT.MINUTES_AGO'
,p_message_language=>'es'
,p_message_text=>'%0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276204716794866427)
,p_name=>'APEX.SINCE.SHORT.MINUTES_FROM_NOW'
,p_message_language=>'es'
,p_message_text=>'en %0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276204110732866426)
,p_name=>'APEX.SINCE.SHORT.MONTHS_AGO'
,p_message_language=>'es'
,p_message_text=>'%0mo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276204366863866426)
,p_name=>'APEX.SINCE.SHORT.MONTHS_FROM_NOW'
,p_message_language=>'es'
,p_message_text=>'en %0mo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276203671630866426)
,p_name=>'APEX.SINCE.SHORT.SECONDS_AGO'
,p_message_language=>'es'
,p_message_text=>'%0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276204432395866426)
,p_name=>'APEX.SINCE.SHORT.SECONDS_FROM_NOW'
,p_message_language=>'es'
,p_message_text=>'en %0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276203958045866426)
,p_name=>'APEX.SINCE.SHORT.WEEKS_AGO'
,p_message_language=>'es'
,p_message_text=>'%0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276204840132866427)
,p_name=>'APEX.SINCE.SHORT.WEEKS_FROM_NOW'
,p_message_language=>'es'
,p_message_text=>'en %0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276204025455866426)
,p_name=>'APEX.SINCE.SHORT.YEARS_AGO'
,p_message_language=>'es'
,p_message_text=>'%0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276204204363866426)
,p_name=>'APEX.SINCE.SHORT.YEARS_FROM_NOW'
,p_message_language=>'es'
,p_message_text=>'en %0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275380272195865909)
,p_name=>'APEX.SPLITTER.COLLAPSE_TEXT'
,p_message_language=>'es'
,p_message_text=>'Reducir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275380131457865909)
,p_name=>'APEX.SPLITTER.RESTORE_TEXT'
,p_message_language=>'es'
,p_message_text=>'Restaurar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275787144048866169)
,p_name=>'APEX.STAR_RATING.CLEAR_RATING'
,p_message_language=>'es'
,p_message_text=>unistr('Borrar calificaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275751103294866147)
,p_name=>'APEX.STAR_RATING.INVALID_RATING_RANGE'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no est\00E1 en el rango v\00E1lido de de calificaci\00F3n de 1 - %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275751267862866147)
,p_name=>'APEX.STAR_RATING.IS_NOT_NUMERIC'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no es num\00E9rico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275723120449866129)
,p_name=>'APEX.SUCCESS_MESSAGE_HEADING'
,p_message_language=>'es'
,p_message_text=>'Mensaje Correcto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275038873618865688)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'es'
,p_message_text=>'Error de contenido de total de control de mensaje correcto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275038702700865688)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'es'
,p_message_text=>'Error de formato de total de control de mensaje correcto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276235086405866446)
,p_name=>'APEX.TABS.NEXT'
,p_message_language=>'es'
,p_message_text=>'Siguiente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276234963082866445)
,p_name=>'APEX.TABS.PREVIOUS'
,p_message_language=>'es'
,p_message_text=>'Anterior'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274890213598865594)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_language=>'es'
,p_message_text=>'Error al calcular el valor por defecto para la columna #COMPONENT_NAME#.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274890822089865594)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la supresi\00F3n de varias filas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275175862045865778)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_language=>'es'
,p_message_text=>'Se necesita la columna de total de control ("FCS") y no se ha proporcionado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275176013775865778)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_language=>'es'
,p_message_text=>'No se han proporcionado valores de clave primaria. Para que se produzcan las actualizaciones, se debe proporcionar al menos una fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275176863398865778)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha proporcionado ning\00FAn valor secundario para la columna de clave secundaria identificada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275293762771865853)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado ning\00FAn dato en la pantalla tabular')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275175788791865777)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_language=>'es'
,p_message_text=>'No se ha especificado la columna de clave primaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275176711929865778)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado la columna de clave secundaria identificada en la lista de selecci\00F3n de la consulta')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275175686063865777)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_language=>'es'
,p_message_text=>'No se ha especificado el nombre de la tabla.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275175546490865777)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_language=>'es'
,p_message_text=>'No se ha especificado el propietario de la tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275197879209865792)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la actualizaci\00F3n de varias filas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276198480240866423)
,p_name=>'APEX.TB.TOOLBAR'
,p_message_language=>'es'
,p_message_text=>'Barra de Herramientas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275059136829865702)
,p_name=>'APEX.TEAM.COMMITTED'
,p_message_language=>'es'
,p_message_text=>'Confirmado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275058934815865702)
,p_name=>'APEX.TEAM.CONTRIBUTOR'
,p_message_language=>'es'
,p_message_text=>'Contribuyente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275060883208865704)
,p_name=>'APEX.TEAM.CREATE'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n %0 agregada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275060975986865704)
,p_name=>'APEX.TEAM.DELETE'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n %0 suprimida.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274881284818865588)
,p_name=>'APEX.TEAM.DEPRECATED'
,p_message_language=>'es'
,p_message_text=>unistr('APEX Team Development est\00E1 en desuso a partir de la versi\00F3n 19.2 y se eliminar\00E1 en una futura versi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275059298983865702)
,p_name=>'APEX.TEAM.ESTIMATED_EFFORT'
,p_message_language=>'es'
,p_message_text=>'Esfuerzo estimado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275059592412865703)
,p_name=>'APEX.TEAM.FEATURE_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Descripci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275058797536865702)
,p_name=>'APEX.TEAM.FEATURE_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275059347055865703)
,p_name=>'APEX.TEAM.FEATURE_STATUS'
,p_message_language=>'es'
,p_message_text=>unistr('Estado de Funci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275059483283865703)
,p_name=>'APEX.TEAM.MILESTONE'
,p_message_language=>'es'
,p_message_text=>'Hito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275059761747865703)
,p_name=>'APEX.TEAM.NO'
,p_message_language=>'es'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275058828386865702)
,p_name=>'APEX.TEAM.OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275059028958865702)
,p_name=>'APEX.TEAM.RELEASE'
,p_message_language=>'es'
,p_message_text=>unistr('Versi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275057860407865702)
,p_name=>'APEX.TEAM.SAVE'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n %0 actualizada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275059660586865703)
,p_name=>'APEX.TEAM.YES'
,p_message_language=>'es'
,p_message_text=>unistr('S\00ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276237860771866447)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_NAV_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Ampliar / contraer navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276237980864866447)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_SIDE_COL_LABEL'
,p_message_language=>'es'
,p_message_text=>'Ampliar / contraer columna lateral'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274913951859865609)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('No se puede copiar el tema "%0" en la aplicaci\00F3n "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276230301244866443)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'El tema importado no es compatible con el tema actual.',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276196185092866421)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_language=>'es'
,p_message_text=>unistr('El n\00FAmero de tema no es v\00E1lido o el tema no es un tema de interfaz de usuario actual.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275520092030866003)
,p_name=>'APEX.TIME.DAY'
,p_message_language=>'es'
,p_message_text=>unistr('1 d\00EDa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275519887078866003)
,p_name=>'APEX.TIME.HOUR'
,p_message_language=>'es'
,p_message_text=>'1 hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275520188301866003)
,p_name=>'APEX.TIME.N_DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 d\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275519986683866003)
,p_name=>'APEX.TIME.N_HOURS'
,p_message_language=>'es'
,p_message_text=>'%0 horas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275519787900866003)
,p_name=>'APEX.TIME.N_MINUTES'
,p_message_language=>'es'
,p_message_text=>'%0 minutos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275520380875866004)
,p_name=>'APEX.TIME.N_WEEKS'
,p_message_language=>'es'
,p_message_text=>'%0 semanas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275520256427866004)
,p_name=>'APEX.TIME.WEEK'
,p_message_language=>'es'
,p_message_text=>'1 semana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276149510828866392)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('Se necesitan las columnas de clave primaria y clave principal para calcular la jerarqu\00EDa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276149643662866392)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('Se necesitan las columnas de estado de nodo y nivel de nodo cuando no se ha calculado la jerarqu\00EDa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276257597062866460)
,p_name=>'APEX.UI.BACK_TO_TOP'
,p_message_language=>'es'
,p_message_text=>unistr('Inicio de la p\00E1gina')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275075295283865713)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_language=>'es'
,p_message_text=>'Modo oscuro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275075478342865713)
,p_name=>'APEX.UI.DISABLED'
,p_message_language=>'es'
,p_message_text=>'Desactivado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275075381503865713)
,p_name=>'APEX.UI.ENABLED'
,p_message_language=>'es'
,p_message_text=>'Activado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275514940734866000)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>'Seleccione una interfaz de usuario de la siguiente lista:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275517475216866002)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('%0: Selecci\00F3n de Interfaz de Usuario')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274890569569865594)
,p_name=>'APEX.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>'Error al procesar la solicitud.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275035449787865686)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_language=>'es'
,p_message_text=>'Acceso no autorizado (no se ha definido la variable del paquete del grupo de seguridad).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275036074466865686)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha podido recuperar la informaci\00F3n de b\00FAsqueda de usuario. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275023271643865678)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_language=>'es'
,p_message_text=>unistr('El usuario %0 necesita el privilegio ADMIN para realizar esta operaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275035903993865686)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('El usuario %0 no ha proporcionado ninguna direcci\00F3n de correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274991474827865658)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_language=>'es'
,p_message_text=>'Acceso no autorizado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275035895545865686)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>'El usuario %0 no existe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275141735911865756)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error al procesar la validaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275523943220866006)
,p_name=>'APEX.VALUE_REQUIRED'
,p_message_language=>'es'
,p_message_text=>'Valor Necesario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276247148976866453)
,p_name=>'APEX.WAIT_UNTIL_PAGE_LOADED'
,p_message_language=>'es'
,p_message_text=>unistr('Espere hasta que la p\00E1gina se haya cargado completamente y vuelva a intentarlo.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276071084245866344)
,p_name=>'APEX.WARN_ON_UNSAVED_CHANGES'
,p_message_language=>'es'
,p_message_text=>unistr('Esta p\00E1gina tiene cambios no guardados.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276150913835866393)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_language=>'es'
,p_message_text=>'Application Express no puede calcular un perfil de datos a partir de los datos de respuesta del tipo: %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275581757739866042)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_language=>'es'
,p_message_text=>'Tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275581641558866042)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_language=>'es'
,p_message_text=>'Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276134867177866383)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_language=>'es'
,p_message_text=>unistr('La expresi\00F3n de filtro no es un valor JSON v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276126590973866378)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_language=>'es'
,p_message_text=>unistr('El filtro no est\00E1 soportado por Oracle REST Data Services.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275468266172865971)
,p_name=>'APEX.WEBSRC.HIDE_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Ocultar columnas seleccionadas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275561159869866029)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_language=>'es'
,p_message_text=>'HTTP 200: correcto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275561261478866029)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_language=>'es'
,p_message_text=>'HTTP 201: creado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275560695498866029)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_language=>'es'
,p_message_text=>unistr('HTTP 400: Solicitud Err\00F3nea')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275560486280866028)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_language=>'es'
,p_message_text=>'HTTP 401: no autorizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275560782490866029)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_language=>'es'
,p_message_text=>'HTTP 403: prohibido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275560548576866029)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_language=>'es'
,p_message_text=>'HTTP 404: No Encontrado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275560889228866029)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_language=>'es'
,p_message_text=>unistr('HTTP 405: m\00E9todo no permitido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274880487850865588)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_language=>'es'
,p_message_text=>unistr('HTTP 407: Autenticaci\00F3n del proxy necesaria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274880729893865588)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_language=>'es'
,p_message_text=>'HTTP 409: Conflicto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274880548928865588)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_language=>'es'
,p_message_text=>unistr('HTTP 412: Fallo en condici\00F3n previa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274880639590865588)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_language=>'es'
,p_message_text=>unistr('HTTP 428: Condici\00F3n previa necesaria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275560942994866029)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_language=>'es'
,p_message_text=>'HTTP 500: error interno del servidor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275561062608866029)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_language=>'es'
,p_message_text=>unistr('HTTP 502: gateway err\00F3neo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276151312850866393)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_language=>'es'
,p_message_text=>'HTTP 503: Servicio no disponible'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276151426218866393)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_language=>'es'
,p_message_text=>'HTTP 504: Timeout del gateway'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276070943295866344)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_language=>'es'
,p_message_text=>'El origen web ha devuelto un error de HTTP: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275559532055866028)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('M\00F3dulo de origen web no encontrado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275103852068865731)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_language=>'es'
,p_message_text=>unistr('El selector de filas "%0" no ha seleccionado ninguna matriz de objetos que se considerar\00E1 como una tabla.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275103974564865731)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_language=>'es'
,p_message_text=>unistr('El selector de filas "%0" no ha seleccionado ning\00FAn objeto que se considerar\00E1 como una sola fila.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276070876298866343)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_language=>'es'
,p_message_text=>unistr('El par\00E1metro IN de origen web necesario "%0" del tipo "%1" debe tener un valor.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276053432327866333)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_language=>'es'
,p_message_text=>'El cuerpo de respuesta es demasiado grande para mostrarse.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275468445660865971)
,p_name=>'APEX.WEBSRC.SHOW_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Mostrar columnas seleccionadas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275523875127866006)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('El servicio heredado ORDS REST utiliza un tama\00F1o fijo de p\00E1gina peque\00F1o.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275468812724865971)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_language=>'es'
,p_message_text=>'Se ha excedido el timeout al recuperar todos los datos del origen web.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275443554566865952)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_language=>'es'
,p_message_text=>unistr('Los filtros de SQL local actuales necesitan demasiadas solicitudes de "P\00E1gina siguiente" para el servicio REST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275523778600866006)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('El tama\00F1o fijo de p\00E1gina del servicio REST de ORDS heredado es desconocido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276175357208866408)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('La columna Cuadr\00EDcula Interactiva ''%0'' especificada para la acci\00F3n din\00E1mica ''#COMPONENT_NAME#'' no existe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276175534902866409)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_language=>'es'
,p_message_text=>'El proceso ''%0'' ha emitido ''%1'' al realizar el bloqueo de fila. Este error puede producirse cuando el proceso emite una sentencia SELECT FOR UPDATE en una vista compleja con un disparador instead-of para bloquear la fila. Defina el atributo del proce'
||unistr('so ''Lock Row'' en No o C\00F3digo PL/SQL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276175461579866408)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('El proceso ''%0'' ha emitido ''%1'' al ejecutar un comando DML. Este error se puede producir si una columna est\00E1 basada en una agregaci\00F3n o expresi\00F3n SQL. Defina el atributo de columna ''Solo Consulta'' en S\00ED para excluir la columna de la sentencia INSERT ')
||'y UPDATE.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275839516938866201)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_language=>'es'
,p_message_text=>unistr('La columna maestra/de detalles ''%0'' no contiene ning\00FAn valor. Aseg\00FArese de que se ejecuta el proceso ''%1'' despu\00E9s del proceso correspondiente de la regi\00F3n maestra.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276157152849866397)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('La cuadr\00EDcula interactiva ''%0'' no tiene definida ninguna columna maestra, lo cual es necesario para la relaci\00F3n maestro/detalle.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275513284805865999)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_language=>'es'
,p_message_text=>unistr('La cuadr\00EDcula interactiva ''%0'' no tiene definida una columna de clave primaria, lo cual es necesario para realizar ediciones o para la relaci\00F3n maestro/detalle.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276128848116866379)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_language=>'es'
,p_message_text=>unistr('Para una cuadr\00EDcula interactiva editable, el atributo de p\00E1gina ''Recargar al Enviar'' se debe definir en ''Solo para Correcto''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276128995764866379)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_language=>'es'
,p_message_text=>unistr('Para un formato tabular, el atributo de p\00E1gina ''Recargar al Enviar'' se debe definir en ''Siempre''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275070912989865710)
,p_name=>'APEXIR_3D'
,p_message_language=>'es'
,p_message_text=>'3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276164208224866401)
,p_name=>'APEXIR_ACTIONS'
,p_message_language=>'es'
,p_message_text=>'Acciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275291616866865852)
,p_name=>'APEXIR_ACTIONS_MENU'
,p_message_language=>'es'
,p_message_text=>unistr('Men\00FA de Acciones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275196562989865791)
,p_name=>'APEXIR_ADD'
,p_message_language=>'es'
,p_message_text=>'Agregar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275281238603865845)
,p_name=>'APEXIR_ADD_FUNCTION'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar Funci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275281171629865845)
,p_name=>'APEXIR_ADD_GROUP_BY_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Agregar Grupo por Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275605632463866057)
,p_name=>'APEXIR_ADD_PIVOT_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar Columna Din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275605775726866057)
,p_name=>'APEXIR_ADD_ROW_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Agregar Columna de Filas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275769414861866158)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar Suscripci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275071194891865710)
,p_name=>'APEXIR_AGGREGATE'
,p_message_language=>'es'
,p_message_text=>'Agregar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275315672731865868)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Las agregaciones se muestran detr\00E1s de cada divisi\00F3n de control y al final del informe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275318794047865870)
,p_name=>'APEXIR_AGGREGATION'
,p_message_language=>'es'
,p_message_text=>unistr('Agregaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275197057599865791)
,p_name=>'APEXIR_AGG_AVG'
,p_message_language=>'es'
,p_message_text=>'Media'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275205939413865797)
,p_name=>'APEXIR_AGG_COUNT'
,p_message_language=>'es'
,p_message_text=>'Recuento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275222982267865808)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_language=>'es'
,p_message_text=>'Recuento de los Valores Distintos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275197150350865791)
,p_name=>'APEXIR_AGG_MAX'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275197317308865791)
,p_name=>'APEXIR_AGG_MEDIAN'
,p_message_language=>'es'
,p_message_text=>'Mediana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275197249711865791)
,p_name=>'APEXIR_AGG_MIN'
,p_message_language=>'es'
,p_message_text=>unistr('M\00EDnimo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275197480881865791)
,p_name=>'APEXIR_AGG_MODE'
,p_message_language=>'es'
,p_message_text=>'Modo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275196961230865791)
,p_name=>'APEXIR_AGG_SUM'
,p_message_language=>'es'
,p_message_text=>'Suma de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275198712140865792)
,p_name=>'APEXIR_ALL'
,p_message_language=>'es'
,p_message_text=>'Todo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275070157943865709)
,p_name=>'APEXIR_ALL_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Todas las Columnas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274920918507865613)
,p_name=>'APEXIR_ALL_ROWS'
,p_message_language=>'es'
,p_message_text=>'Todas las Filas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276160748217866399)
,p_name=>'APEXIR_ALTERNATIVE'
,p_message_language=>'es'
,p_message_text=>'Alternativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276162863106866400)
,p_name=>'APEXIR_ALTERNATIVE_DEFAULT_NAME'
,p_message_language=>'es'
,p_message_text=>'Valor Por Defecto Alternativo:  %0 '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275156896297865765)
,p_name=>'APEXIR_AND'
,p_message_language=>'es'
,p_message_text=>'y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275077685316865714)
,p_name=>'APEXIR_APPLY'
,p_message_language=>'es'
,p_message_text=>'Aplicar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276126728876866378)
,p_name=>'APEXIR_AREA'
,p_message_language=>'es'
,p_message_text=>unistr('\00C1rea')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275041548276865691)
,p_name=>'APEXIR_ASCENDING'
,p_message_language=>'es'
,p_message_text=>'Ascendente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275169322138865773)
,p_name=>'APEXIR_AS_OF'
,p_message_language=>'es'
,p_message_text=>'Hace %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276163412461866401)
,p_name=>'APEXIR_AVERAGE_X'
,p_message_language=>'es'
,p_message_text=>'Media de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276126672597866378)
,p_name=>'APEXIR_BAR'
,p_message_language=>'es'
,p_message_text=>'Barra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275074057119865712)
,p_name=>'APEXIR_BETWEEN'
,p_message_language=>'es'
,p_message_text=>'entre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275040244337865689)
,p_name=>'APEXIR_BGCOLOR'
,p_message_language=>'es'
,p_message_text=>'Color de Fondo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275766487370866156)
,p_name=>'APEXIR_BLACK'
,p_message_language=>'es'
,p_message_text=>'Negro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275042360894865692)
,p_name=>'APEXIR_BLUE'
,p_message_language=>'es'
,p_message_text=>'azul'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275284081304865847)
,p_name=>'APEXIR_BOTTOM'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275198323736865792)
,p_name=>'APEXIR_CALENDAR'
,p_message_language=>'es'
,p_message_text=>'Calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275042937816865692)
,p_name=>'APEXIR_CANCEL'
,p_message_language=>'es'
,p_message_text=>'Cancelar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275083069114865718)
,p_name=>'APEXIR_CATEGORY'
,p_message_language=>'es'
,p_message_text=>unistr('Categor\00EDa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275040132615865689)
,p_name=>'APEXIR_CELL'
,p_message_language=>'es'
,p_message_text=>'Celda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275198267423865792)
,p_name=>'APEXIR_CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1fico')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275287287880865849)
,p_name=>'APEXIR_CHART_INITIALIZING'
,p_message_language=>'es'
,p_message_text=>'Inicializando...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275641537019866079)
,p_name=>'APEXIR_CHART_LABEL_NOT_NULL'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe especificar la etiqueta de gr\00E1fico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275754060186866148)
,p_name=>'APEXIR_CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'es'
,p_message_text=>unistr('La consulta supera el m\00E1ximo de %0 puntos de datos por gr\00E1fico. Aplique un filtro para reducir el n\00FAmero de registros de la consulta base.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275748072898866145)
,p_name=>'APEXIR_CHART_MAX_ROW_CNT'
,p_message_language=>'es'
,p_message_text=>unistr('El recuento m\00E1ximo de filas para una consulta de Gr\00E1fico limita el n\00FAmero de filas de la consulta base, no el n\00FAmero de filas que se muestran. La consulta base supera el recuento m\00E1ximo de filas de %0. Aplique un filtro para reducir el n\00FAmero de regi')
||'stros en la consulta base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275070492580865710)
,p_name=>'APEXIR_CHART_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275723832294866130)
,p_name=>'APEXIR_CHECK_ALL'
,p_message_language=>'es'
,p_message_text=>'Activar Todo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275169706442865774)
,p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT'
,p_message_language=>'es'
,p_message_text=>'Seleccione el formato de descarga del informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275272473805865840)
,p_name=>'APEXIR_CLEAR'
,p_message_language=>'es'
,p_message_text=>'borrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275042853149865692)
,p_name=>'APEXIR_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275315722051865868)
,p_name=>'APEXIR_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276142996098866388)
,p_name=>'APEXIR_COLUMN_FILTER'
,p_message_language=>'es'
,p_message_text=>'Filtrar...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275282120044865846)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_language=>'es'
,p_message_text=>'Cabecera de Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275276170960865842)
,p_name=>'APEXIR_COLUMN_HEADING_MENU'
,p_message_language=>'es'
,p_message_text=>unistr('Men\00FA de Cabecera de Columna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275287097120865849)
,p_name=>'APEXIR_COLUMN_INFO'
,p_message_language=>'es'
,p_message_text=>unistr('Informaci\00F3n de la Columna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276153176966866394)
,p_name=>'APEXIR_COLUMN_LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta de Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275281804449865846)
,p_name=>'APEXIR_COLUMN_N'
,p_message_language=>'es'
,p_message_text=>'Columna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275151155719865762)
,p_name=>'APEXIR_COMPARISON_CONTAINS'
,p_message_language=>'es'
,p_message_text=>'contiene'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275155858916865765)
,p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN'
,p_message_language=>'es'
,p_message_text=>'no contiene'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275041210720865691)
,p_name=>'APEXIR_COMPARISON_IN'
,p_message_language=>'es'
,p_message_text=>'en'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275156054014865765)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST'
,p_message_language=>'es'
,p_message_text=>unistr('no en \00FAltimos(as)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275201492046865794)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT'
,p_message_language=>'es'
,p_message_text=>'no en siguientes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275155979040865765)
,p_name=>'APEXIR_COMPARISON_IS_IN_LAST'
,p_message_language=>'es'
,p_message_text=>unistr('en \00FAltimos(as)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275201378241865794)
,p_name=>'APEXIR_COMPARISON_IS_IN_NEXT'
,p_message_language=>'es'
,p_message_text=>'en siguientes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275041174188865691)
,p_name=>'APEXIR_COMPARISON_IS_NOT_NULL'
,p_message_language=>'es'
,p_message_text=>'no es nulo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275041071701865691)
,p_name=>'APEXIR_COMPARISON_IS_NULL'
,p_message_language=>'es'
,p_message_text=>'es nulo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275040870553865691)
,p_name=>'APEXIR_COMPARISON_LIKE'
,p_message_language=>'es'
,p_message_text=>'igual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275041366646865691)
,p_name=>'APEXIR_COMPARISON_NOT_IN'
,p_message_language=>'es'
,p_message_text=>'no en'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275040978380865691)
,p_name=>'APEXIR_COMPARISON_NOT_LIKE'
,p_message_language=>'es'
,p_message_text=>'no igual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275151832334865762)
,p_name=>'APEXIR_COMPARISON_REGEXP_LIKE'
,p_message_language=>'es'
,p_message_text=>unistr('coincide con expresi\00F3n regular')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275169601602865773)
,p_name=>'APEXIR_COMPUTATION'
,p_message_language=>'es'
,p_message_text=>unistr('C\00E1lculo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275747605793866144)
,p_name=>'APEXIR_COMPUTATION_EXPRESSION'
,p_message_language=>'es'
,p_message_text=>unistr('Expresi\00F3n de C\00E1lculo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275316022826865868)
,p_name=>'APEXIR_COMPUTATION_FOOTER'
,p_message_language=>'es'
,p_message_text=>unistr('Cree un c\00E1lculo utilizando los alias de columna.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275316135399865868)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E1'
,p_message_language=>'es'
,p_message_text=>'(B+C)*100'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275316289911865868)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E2'
,p_message_language=>'es'
,p_message_text=>'INITCAP(B)||'', ''||INITCAP(C)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275316385760865868)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E3'
,p_message_language=>'es'
,p_message_text=>'CASE WHEN A = 10 THEN B + C ELSE B END'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274908283102865605)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E4'
,p_message_language=>'es'
,p_message_text=>'ROUND(C / 1000000)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275199493422865793)
,p_name=>'APEXIR_COMPUTE'
,p_message_language=>'es'
,p_message_text=>'Calcular'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275282858440865846)
,p_name=>'APEXIR_CONTROL_BREAK'
,p_message_language=>'es'
,p_message_text=>unistr('Divisi\00F3n de Control')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275291070272865852)
,p_name=>'APEXIR_CONTROL_BREAKS'
,p_message_language=>'es'
,p_message_text=>'Divisiones de Control'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276171566271866406)
,p_name=>'APEXIR_CONTROL_BREAK_COLUMNS'
,p_message_language=>'es'
,p_message_text=>unistr('Columnas de Divisi\00F3n de Control')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274900413899865600)
,p_name=>'APEXIR_COUNT_DISTINCT'
,p_message_language=>'es'
,p_message_text=>'Recuento de los Valores Distintos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276163984840866401)
,p_name=>'APEXIR_COUNT_DISTINCT_X'
,p_message_language=>'es'
,p_message_text=>'Recuento de los Valores Distintos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276163877252866401)
,p_name=>'APEXIR_COUNT_X'
,p_message_language=>'es'
,p_message_text=>'Recuento %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275766977175866156)
,p_name=>'APEXIR_DAILY'
,p_message_language=>'es'
,p_message_text=>'Diario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276256474209866459)
,p_name=>'APEXIR_DATA'
,p_message_language=>'es'
,p_message_text=>'Datos'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275287147747865849)
,p_name=>'APEXIR_DATA_AS_OF'
,p_message_language=>'es'
,p_message_text=>'Informar de datos de hace %0 minutos.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276118222319866373)
,p_name=>'APEXIR_DATA_GRID_HELP'
,p_message_language=>'es'
,p_message_text=>unistr('Ayuda de Cuadr\00EDcula de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275071309254865710)
,p_name=>'APEXIR_DATE'
,p_message_language=>'es'
,p_message_text=>'Fecha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276162405382866400)
,p_name=>'APEXIR_DAY'
,p_message_language=>'es'
,p_message_text=>unistr('D\00EDa ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275313348820865867)
,p_name=>'APEXIR_DEFAULT'
,p_message_language=>'es'
,p_message_text=>'Valor por Defecto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276160507313866399)
,p_name=>'APEXIR_DEFAULT_REPORT_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Informe por Defecto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275043036451865692)
,p_name=>'APEXIR_DELETE'
,p_message_language=>'es'
,p_message_text=>'Suprimir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275200251389865793)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_language=>'es'
,p_message_text=>unistr('Suprimir Selecci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275072224875865711)
,p_name=>'APEXIR_DELETE_CONFIRM'
,p_message_language=>'es'
,p_message_text=>unistr('\00BFDesea suprimir estos valores del informe?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275317552058865869)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_language=>'es'
,p_message_text=>unistr('\00BFDesea realizar esta acci\00F3n de supresi\00F3n?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276051279546866331)
,p_name=>'APEXIR_DELETE_DEFAULT_REPORT'
,p_message_language=>'es'
,p_message_text=>'Suprimir Informe por Defecto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275282561247865846)
,p_name=>'APEXIR_DELETE_REPORT'
,p_message_language=>'es'
,p_message_text=>'Suprimir Informe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275041627427865691)
,p_name=>'APEXIR_DESCENDING'
,p_message_language=>'es'
,p_message_text=>'Descendente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275083103267865718)
,p_name=>'APEXIR_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Descripci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275276011882865842)
,p_name=>'APEXIR_DETAIL_VIEW'
,p_message_language=>'es'
,p_message_text=>'Vista de Una Sola Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275314370994865867)
,p_name=>'APEXIR_DIRECTION'
,p_message_language=>'es'
,p_message_text=>unistr('Direcci\00F3n %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275291527553865852)
,p_name=>'APEXIR_DISABLE'
,p_message_language=>'es'
,p_message_text=>'Desactivar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275315571584865868)
,p_name=>'APEXIR_DISABLED'
,p_message_language=>'es'
,p_message_text=>'Desactivado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275071457257865710)
,p_name=>'APEXIR_DISPLAY'
,p_message_language=>'es'
,p_message_text=>'Mostrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275042524922865692)
,p_name=>'APEXIR_DISPLAYED'
,p_message_language=>'es'
,p_message_text=>'Mostrado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275070056832865709)
,p_name=>'APEXIR_DISPLAYED_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas Mostradas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275314218981865867)
,p_name=>'APEXIR_DISPLAY_IN_REPORT'
,p_message_language=>'es'
,p_message_text=>'Mostrar en Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275043221770865692)
,p_name=>'APEXIR_DONUT'
,p_message_language=>'es'
,p_message_text=>'Anillo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275283961924865847)
,p_name=>'APEXIR_DOWN'
,p_message_language=>'es'
,p_message_text=>'Abajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275199558544865793)
,p_name=>'APEXIR_DOWNLOAD'
,p_message_language=>'es'
,p_message_text=>'Descargar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275071279514865710)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_language=>'es'
,p_message_text=>'- No Agregar -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275314168959865867)
,p_name=>'APEXIR_DO_NOT_DISPLAY'
,p_message_language=>'es'
,p_message_text=>'No Mostrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276171711809866406)
,p_name=>'APEXIR_DUPLICATE_PIVOT_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna din\00E1mica duplicada. La lista de columna din\00E1mica debe ser \00FAnica.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276172175513866406)
,p_name=>'APEXIR_EDIT'
,p_message_language=>'es'
,p_message_text=>'Editar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276110824008866368)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_language=>'es'
,p_message_text=>'Editar Valor por Defecto Alternativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275287305777865849)
,p_name=>'APEXIR_EDIT_CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Valores de Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275317389712865869)
,p_name=>'APEXIR_EDIT_CHART2'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275317890765865869)
,p_name=>'APEXIR_EDIT_FILTER'
,p_message_language=>'es'
,p_message_text=>'Editar Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275813731983866185)
,p_name=>'APEXIR_EDIT_GROUP_BY'
,p_message_language=>'es'
,p_message_text=>'Editar Grupo por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275317746736865869)
,p_name=>'APEXIR_EDIT_HIGHLIGHT'
,p_message_language=>'es'
,p_message_text=>'Editar Resaltado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275630438930866072)
,p_name=>'APEXIR_EDIT_PIVOT'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276160842787866399)
,p_name=>'APEXIR_EMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Correo Electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274986189849865654)
,p_name=>'APEXIR_EMAIL_ADDRESS'
,p_message_language=>'es'
,p_message_text=>unistr('Direcci\00F3n de Correo Electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276161119140866399)
,p_name=>'APEXIR_EMAIL_BCC'
,p_message_language=>'es'
,p_message_text=>'Cco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276161377715866400)
,p_name=>'APEXIR_EMAIL_BODY'
,p_message_language=>'es'
,p_message_text=>'Cuerpo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276161025007866399)
,p_name=>'APEXIR_EMAIL_CC'
,p_message_language=>'es'
,p_message_text=>'Cc'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276162064786866400)
,p_name=>'APEXIR_EMAIL_FREQUENCY'
,p_message_language=>'es'
,p_message_text=>'Frecuencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275020979062865676)
,p_name=>'APEXIR_EMAIL_NOT_CONFIGURED'
,p_message_language=>'es'
,p_message_text=>unistr('El correo electr\00F3nico no se ha configurado para esta aplicaci\00F3n. P\00F3ngase en contacto con el administrador.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275766095681866156)
,p_name=>'APEXIR_EMAIL_REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe especificar la direcci\00F3n de correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276161421408866400)
,p_name=>'APEXIR_EMAIL_SEE_ATTACHED'
,p_message_language=>'es'
,p_message_text=>'Consulte adjuntos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276161258229866399)
,p_name=>'APEXIR_EMAIL_SUBJECT'
,p_message_language=>'es'
,p_message_text=>'Asunto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275767906748866157)
,p_name=>'APEXIR_EMAIL_SUBJECT_REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe especificar el asunto del correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276160963118866399)
,p_name=>'APEXIR_EMAIL_TO'
,p_message_language=>'es'
,p_message_text=>'Para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275291469893865852)
,p_name=>'APEXIR_ENABLE'
,p_message_language=>'es'
,p_message_text=>'Activar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275039974282865689)
,p_name=>'APEXIR_ENABLED'
,p_message_language=>'es'
,p_message_text=>'Activado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275317674259865869)
,p_name=>'APEXIR_ENABLE_DISABLE_ALT'
,p_message_language=>'es'
,p_message_text=>'Activar/Desactivar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275317082787865869)
,p_name=>'APEXIR_ERROR'
,p_message_language=>'es'
,p_message_text=>'Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275316447139865868)
,p_name=>'APEXIR_EXAMPLES'
,p_message_language=>'es'
,p_message_text=>'Ejemplos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275317450033865869)
,p_name=>'APEXIR_EXAMPLES_WITH_COLON'
,p_message_language=>'es'
,p_message_text=>'Ejemplos:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275069905098865709)
,p_name=>'APEXIR_EXCLUDE_NULL'
,p_message_language=>'es'
,p_message_text=>'Excluir Valores Nulos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275318337301865870)
,p_name=>'APEXIR_EXPAND_COLLAPSE_ALT'
,p_message_language=>'es'
,p_message_text=>'Ampliar/Reducir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275315260834865868)
,p_name=>'APEXIR_EXPRESSION'
,p_message_language=>'es'
,p_message_text=>unistr('Expresi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275199084461865792)
,p_name=>'APEXIR_FILTER'
,p_message_language=>'es'
,p_message_text=>'Filtro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275290992903865852)
,p_name=>'APEXIR_FILTERS'
,p_message_language=>'es'
,p_message_text=>'Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275375417483865906)
,p_name=>'APEXIR_FILTER_EXPRESSION'
,p_message_language=>'es'
,p_message_text=>unistr('Expresi\00F3n de Filtro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276238342017866448)
,p_name=>'APEXIR_FILTER_EXPR_TOO_LONG'
,p_message_language=>'es'
,p_message_text=>unistr('La expresi\00F3n de filtro es demasiado larga.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275375363547865906)
,p_name=>'APEXIR_FILTER_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275318559592865870)
,p_name=>'APEXIR_FINDER_ALT'
,p_message_language=>'es'
,p_message_text=>'Seleccionar Columnas a Buscar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275199313509865793)
,p_name=>'APEXIR_FLASHBACK'
,p_message_language=>'es'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275314944886865868)
,p_name=>'APEXIR_FLASHBACK_DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Las consultas de flashback permiten visualizar los datos tal como exist\00EDan en un punto en el tiempo anterior.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275316887232865869)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_language=>'es'
,p_message_text=>'No se ha podido realizar la solicitud de flashback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275766651551866156)
,p_name=>'APEXIR_FLASHBACK_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Duraci\00F3n de flashback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275775257229866161)
,p_name=>'APEXIR_FORMAT'
,p_message_language=>'es'
,p_message_text=>'Formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275169589848865773)
,p_name=>'APEXIR_FORMAT_MASK'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1scara de Formato %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275282228157865846)
,p_name=>'APEXIR_FUNCTION'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275315909219865868)
,p_name=>'APEXIR_FUNCTIONS'
,p_message_language=>'es'
,p_message_text=>'Funciones %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276160426114866399)
,p_name=>'APEXIR_FUNCTIONS_OPERATORS'
,p_message_language=>'es'
,p_message_text=>'Funciones/Operadores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275748113485866145)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna de Funci\00F3n %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275281781955865846)
,p_name=>'APEXIR_FUNCTION_N'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275198867976865792)
,p_name=>'APEXIR_GO'
,p_message_language=>'es'
,p_message_text=>'Ir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275766523499866156)
,p_name=>'APEXIR_GRAY'
,p_message_language=>'es'
,p_message_text=>'Gris'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275040434793865689)
,p_name=>'APEXIR_GREEN'
,p_message_language=>'es'
,p_message_text=>'verde'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274900505397865600)
,p_name=>'APEXIR_GROUP_BY'
,p_message_language=>'es'
,p_message_text=>'Agrupar por'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276161529174866400)
,p_name=>'APEXIR_GROUP_BY_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Agrupar por Columna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275641628680866079)
,p_name=>'APEXIR_GROUP_BY_COL_NOT_NULL'
,p_message_language=>'es'
,p_message_text=>'Se debe especificar la columna Agrupar por.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275747946705866145)
,p_name=>'APEXIR_GROUP_BY_MAX_ROW_CNT'
,p_message_language=>'es'
,p_message_text=>unistr('El recuento m\00E1ximo de filas para una consulta de Agrupar por limita el n\00FAmero de filas de la consulta base, no el n\00FAmero de filas que se muestran. La consulta base supera el recuento m\00E1ximo de filas de %0. Aplique un filtro para reducir el n\00FAmero de ')
||'registros en la consulta base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275562047089866029)
,p_name=>'APEXIR_GROUP_BY_SORT'
,p_message_language=>'es'
,p_message_text=>unistr('Agrupar por Ordenaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276171688278866406)
,p_name=>'APEXIR_GROUP_BY_SORT_ORDER'
,p_message_language=>'es'
,p_message_text=>unistr('Agrupar por Orden de Clasificaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275070502105865710)
,p_name=>'APEXIR_HCOLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna Horizontal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275308724457865863)
,p_name=>'APEXIR_HELP'
,p_message_language=>'es'
,p_message_text=>'Ayuda'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275274360837865841)
,p_name=>'APEXIR_HELP_01'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Los informes interactivos permiten que los usuarios finales personalicen los informes. Los usuarios pueden modificar el dise\00F1o de los datos del informe seleccionando columnas, aplicando filtros, resaltando y ordenando. Tambi\00E9n pueden definir saltos d')
||unistr('e l\00EDnea, agregaciones, gr\00E1ficos, organizaciones por grupos y sus propios c\00E1lculos. Tambi\00E9n se puede configurar una suscripci\00F3n para que env\00EDe por correo electr\00F3nico el informe en versi\00F3n HTML con intervalos de tiempo designados. Los usuarios pueden c')
||unistr('rear m\00FAltiples variaciones del informe y guardarlas como informes con nombre, para visualizaci\00F3n p\00FAblica o privada.'),
'<p/>',
unistr('Las secciones siguientes ofrecen un resumen de los modos de personalizar un informe interactivo. Para obtener m\00E1s informaci\00F3n, consulte la secci\00F3n sobre el uso de informes interactivos en <i>Oracle Application Express End User''s Guide</i></a>.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275291715787865852)
,p_name=>'APEXIR_HELP_ACTIONS_MENU'
,p_message_language=>'es'
,p_message_text=>unistr('El men\00FA Acciones aparece a la derecha del bot\00F3n Ir en la barra de b\00FAsqueda. Utilice este men\00FA para personalizar un informe interactivo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275275336683865841)
,p_name=>'APEXIR_HELP_AGGREGATE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Las agregaciones son c\00E1lculos matem\00E1ticos que se realizan en una columna. Las agregaciones se muestran detr\00E1s de cada divisi\00F3n de control y, al final del informe, dentro de la columna en la que est\00E1n definidos. Las opciones incluyen:'),
'<p>',
'</p><ul>',
unistr('<li><b>Agregaci\00F3n</b> permite seleccionar una agregaci\00F3n definida previamente para editarla.</li>'),
unistr('<li><b>Funci\00F3n</b> es la funci\00F3n que se debe ejecutar (por ejemplo, SUM, MIN).</li>'),
unistr('<li><b>Columna</b> se utiliza para seleccionar la columna a la que se aplica la funci\00F3n matem\00E1tica. S\00F3lo se muestran las columnas num\00E9ricas.</li></ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275275471394865842)
,p_name=>'APEXIR_HELP_CHART'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Puede definir un gr\00E1fico por informe guardado. Despu\00E9s '),
unistr('de definirlo, puede cambiar entre las vistas de gr\00E1fico e informe mediante los iconos de visualizaci\00F3n de la barra de b\00FAsqueda.'),
'Las opciones incluyen: ',
'<p>',
'</p><ul>',
unistr('<li><b>Tipo de Gr\00E1fico</b> identifica el tipo de gr\00E1fico que se debe incluir.'),
unistr('Seleccione un gr\00E1fico de barras horizontales, de barras verticales, de tarta o de l\00EDneas.</li>'),
'<li><b>Etiqueta</b> permite seleccionar la columna que se debe utilizar como etiqueta.</li>',
unistr('<li><b>T\00EDtulo del Eje para Etiqueta</b> es el t\00EDtulo que se mostrar\00E1 en el eje asociado a la columna seleccionada como'),
unistr('etiqueta. No est\00E1 disponible para gr\00E1ficos de tarta.</li>'),
unistr('<li><b>Valor</b> permite seleccionar la columna que se debe utilizar como valor. Si la funci\00F3n'),
unistr('es COUNT, no se tiene que seleccionar ning\00FAn valor.</li>'),
unistr('<li><b>T\00EDtulo del Eje para Valor</b> es el t\00EDtulo que se mostrar\00E1 en el eje asociado a la columna seleccionada'),
unistr('como valor. No est\00E1 disponible para gr\00E1ficos de tarta.</li>'),
unistr('<li><b>Funci\00F3n</b> es una funci\00F3n opcional que se debe realizar en la columna seleccionada como valor.</li>'),
'<li><b>Ordenar</b> permite ordenar el juego de resultados.</li></ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275274756952865841)
,p_name=>'APEXIR_HELP_COLUMN_HEADING_MENU'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Al hacer clic en cualquier cabecera de columna, se muestra un men\00FA de cabecera de columna con las siguientes opciones:'),
'<p></p>',
'<ul>',
unistr('<li><b>El icono <b>Orden Ascendente</b> ordena el informe seg\00FAn la columna en orden ascendente.</li>'),
unistr('<li>El icono <b>Orden Descendente</b> ordena el informe seg\00FAn la columna en orden descendente.</li>'),
unistr('<li><b>Ocultar Columna</b> oculta la columna. No todas las columnas se pueden ocultar. Si una columna no se puede ocultar, no habr\00E1 ning\00FAn icono Ocultar Columna.</li>'),
unistr('<li><b>Columna Divisoria</b> crea un grupo de divisi\00F3n en la columna. De esta forma se extrae la columna del informe como registro maestro.</li>'),
unistr('<li><b>Informaci\00F3n de la Columna</b> muestra texto de ayuda sobre la columna si est\00E1 disponible.</li>'),
unistr('<li><b>\00C1rea de Texto</b> se utiliza para introducir criterios de b\00FAsqueda que no sean sensibles a may\00FAsculas/min\00FAsculas (no se necesitan comodines). Al introducir un valor, se reduce la lista de valores de la parte inferior del men\00FA. A continuaci\00F3n, ')
||unistr('puede seleccionar un valor de la parte inferior para que se cree como filtro con ''='' (por ejemplo, <code>columna = ''ABC''</code>). Tambi\00E9n puede hacer clic en el icono de linterna e introducir un valor para que se cree como filtro con el modificador ''')
||'LIKE'' (por ejemplo, <code>columna LIKE ''%ABC%''</code>).',
unistr('<li><b>Lista de Valores \00DAnicos</b> contiene los 500 primeros valores \00FAnicos que cumplen los filtros. Si la columna es una fecha, aparece una lista de rangos de fechas. Si selecciona un valor, se crear\00E1 un filtro con ''='' (por ejemplo, <code>columna = ')
||'''ABC''</code>).</li></ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275275245840865841)
,p_name=>'APEXIR_HELP_COMPUTE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Permite agregar columnas calculadas al informe. Pueden ser c\00E1lculos matem\00E1ticos (por ejemplo, <code>NBR_HOURS/24</code>) o funciones est\00E1ndar de Oracle aplicadas a columnas existentes. Algunas se muestran como ejemplo pero tambi\00E9n se pueden utilizar ')
||'otras (como <code>TO_DATE)</code>). Las opciones incluyen:',
'<p></p>',
'<ul>',
unistr('<li><b>C\00E1lculo</b> permite seleccionar un c\00E1lculo definido previamente para editarlo.</li>'),
'<li><b>Cabecera de Columna</b> es la cabecera para la nueva columna.</li>',
unistr('<li><b>M\00E1scara de Formato</b> es una m\00E1scara de formato de Oracle que se debe aplicar a la columna (por ejemplo, S9999).</li>'),
unistr('<li><b>C\00E1lculo</b> es el c\00E1lculo que se debe realizar. Dentro del c\00E1lculo, se hace referencia a las columnas mediante los alias mostrados.</li>'),
'</ul>',
unistr('<p>Debajo del c\00E1lculo, las columnas de la consulta se muestran con sus alias asociados. Al hacer clic en el nombre o el alias de una columna, estos se incluyen en el c\00E1lculo. Junto a las columnas hay un teclado que funciona como m\00E9todo abreviado para')
||unistr(' las teclas que m\00E1s se utilizan. En el extremo de la derecha est\00E1n las funciones.</p>'),
unistr('<p>El siguiente es un ejemplo de c\00E1lculo para mostrar la remuneraci\00F3n total:</p>'),
'<pre>CASE WHEN A = ''VENTAS'' THEN B + C ELSE B END</pre>',
unistr('(donde A es ORGANIZACI\00D3N, B es SALARIO y C es COMISI\00D3N)')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275291874495865852)
,p_name=>'APEXIR_HELP_CONTROL_BREAK'
,p_message_language=>'es'
,p_message_text=>'Se utiliza para crear un grupo divisorio en una o varias columnas. Obtiene las columnas del informe interactivo y las muestra como un registro maestro.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275275912757865842)
,p_name=>'APEXIR_HELP_DETAIL_VIEW'
,p_message_language=>'es'
,p_message_text=>unistr('Para visualizar los detalles de una sola fila cada vez, haga clic en el icono de vista de una sola fila correspondiente a la fila que desea visualizar. Si est\00E1 disponible, la vista de una sola fila siempre estar\00E1 en la primera columna. Seg\00FAn la perso')
||unistr('nalizaci\00F3n del informe interactivo, la vista de una sola fila puede ser la vista est\00E1ndar o una p\00E1gina personalizada que se puede actualizar.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275275875228865842)
,p_name=>'APEXIR_HELP_DOWNLOAD'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Permite descargar el juego de resultados actual. Los formatos de',
unistr(' descarga son diferentes seg\00FAn la instalaci\00F3n y la definici\00F3n del'),
unistr(' informe pero pueden ser CSV, HTML, Correo Electr\00F3nico, XLS, PDF'),
' o RTF.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275274972049865841)
,p_name=>'APEXIR_HELP_FILTER'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Delimita el informe mediante la adici\00F3n o modificaci\00F3n de la cl\00E1usula WHERE de la consulta. Puede filtrar por columna o por fila.'),
'<p/>',
unistr('Si filtra por columna, seleccione primero una columna (no tiene que ser la mostrada), seleccione un operador est\00E1ndar de Oracle (=, !=, no en, entre) y, a continuaci\00F3n, introduzca una expresi\00F3n con la que realizar la comparaci\00F3n. Las expresiones son ')
||unistr('sensibles a may\00FAsculas/min\00FAsculas. Utilice % como comod\00EDn (por ejemplo, <code>STATE_NAME'),
'like A%)</code>.</p>',
unistr('<p>Si filtra por fila, puede crear cl\00E1usulas WHERE complejas con alias de columna y cualquier funci\00F3n u operador de Oracle (por ejemplo, <code>G = ''VA'' o G = ''CT''</code>, donde <code>G</code> es el alias de CUSTOMER_STATE).</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275275514854865842)
,p_name=>'APEXIR_HELP_FLASHBACK'
,p_message_language=>'es'
,p_message_text=>unistr('Las consultas de flashback permiten visualizar los datos tal como exist\00EDan en un punto en el tiempo anterior. El tiempo por defecto en el que se puede realizar la operaci\00F3n de flashback es 3 horas (o 180 minutos) aunque el tiempo real es diferente se')
||unistr('g\00FAn la base de datos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275775105286866161)
,p_name=>'APEXIR_HELP_FORMAT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>El men\00FA Formato permite personalizar la visualizaci\00F3n del informe.'),
unistr('Contiene los siguientes submen\00FAs:</p>'),
'<ul><li>Ordenar</li>',
unistr('<li>Divisi\00F3n de Control</li>'),
'<li>Resaltar</li>',
'<li>Calcular</li>',
'<li>Agregar</li>',
unistr('<li>Gr\00E1fico</li>'),
'<li>Agrupar por</li>',
'<li>Girar</li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275765882216866156)
,p_name=>'APEXIR_HELP_GROUP_BY'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Puede definir una vista Agrupar por, por informe guardado.',
unistr('Una vez se ha definido, puede cambiar entre las vistas de agrupaci\00F3n e informe'),
unistr('mediante los iconos de vista que se encuentran en la barra de b\00FAsqueda. Para crear una vista Agrupar por,'),
'seleccione:',
'<p></p><ul>',
unistr('<li>las columnas en las que realizar la agrupaci\00F3n</li>,'),
unistr('<li>las columnas para agregar, junto con la funci\00F3n que se va a realizar (media, suma, recuento, etc.)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275275129704865841)
,p_name=>'APEXIR_HELP_HIGHLIGHT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite definir un filtro. Las filas que cumplen los criterios de filtro se resaltan seg\00FAn las caracter\00EDsticas asociadas al filtro. Las opciones incluyen:</p>'),
'<ul>',
unistr('<li><b>Nombre</b> s\00F3lo se utiliza para la visualizaci\00F3n.</li>'),
unistr('<li><b>Secuencia</b> identifica la secuencia en la que se evaluar\00E1n las reglas.</li>'),
unistr('<li><b>Activado</b> identifica si la regla est\00E1 activada o desactivada.</li>'),
unistr('<li><b>Tipo de Resaltado</b> identifica si la fila o la celda debe estar resaltada. Si se selecciona Celda, se resalta la columna a la que se hace referencia en Condici\00F3n para Resaltar.</li>'),
unistr('<li><b>Color de Fondo</b> es el nuevo color para el fondo del \00E1rea resaltada.</li>'),
unistr('<li><b>Color del Texto</b> es el nuevo color para el texto del \00E1rea resaltada.</li>'),
unistr('<li><b>Condici\00F3n para Resaltar</b> define la condici\00F3n del filtro.</li></ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274871803613865582)
,p_name=>'APEXIR_HELP_PIVOT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Puede definir una vista din\00E1mica por informe guardado. Una vez definidas, puede cambiar entre las vistas din\00E1micas y de informe utilizando los iconos de vista que se encuentran en la barra de b\00FAsqueda. Para crear una vista din\00E1mica, se seleccionan: '),
'<p></p>',
'<ul>',
'<li>las columnas sobre las que girar</li>',
'<li>las columnas que mostrar como filas</li>',
unistr('<li>las columnas que agregar junto con la funci\00F3n que se va a realizar (media, suma, recuento, etc.)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275316626629865869)
,p_name=>'APEXIR_HELP_REPORT_SETTINGS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Si personaliza un informe interactivo, la configuraci\00F3n del informe se mostrar\00E1'),
unistr('debajo de la barra de b\00FAsqueda y encima del informe. Esta \00E1rea se puede reducir y ampliar mediante el icono de la izquierda.'),
'<p>',
unistr('En cada configuraci\00F3n de informe, puede hacer lo siguiente:'),
'</p><ul>',
'<li>Editar un valor haciendo clic en el nombre.</li>',
'<li>Desactivar/activar un valor marcando o anulando la marca de la casilla de control Activar/Desactivar. Se utiliza para desactivar y activar temporalmente el valor.</li>',
'<li>Eliminar un valor haciendo clic en el icono Eliminar.</li>',
'</ul>',
unistr('<p>Si ha creado un gr\00E1fico, una ordenaci\00F3n por grupos o elemento din\00E1mico, puede cambiar entre ellos'),
unistr('y el informe base con los enlaces Vista de Informe, Vista de Gr\00E1fico, Vista Agrupar por y Vista Din\00E1mica por'),
unistr('que se muestran a la derecha. Si est\00E1 visualizando el gr\00E1fico, la ordenaci\00F3n por grupos o elemento din\00E1mico, tambi\00E9n'),
unistr('puede utilizar el enlace Editar para editar la configuraci\00F3n.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275275723746865842)
,p_name=>'APEXIR_HELP_RESET'
,p_message_language=>'es'
,p_message_text=>'Restablece los valores por defecto del informe eliminando todas las personalizaciones realizadas.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275775426319866161)
,p_name=>'APEXIR_HELP_ROWS_PER_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Define el n\00FAmero de registros que se mostrar\00E1n por p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275275664748865842)
,p_name=>'APEXIR_HELP_SAVE_REPORT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Guarda el informe personalizado para su uso en el futuro. Se proporcionan un nombre y una descripci\00F3n opcional y el p\00FAblico (es decir, todos los usuarios con acceso al informe principal por defecto) podr\00E1 acceder al informe. Puede guardar cuatro t')
||'ipos de informe interactivo:</p>',
'<ul>',
unistr('<li><strong>Principal por Defecto</strong> (s\00F3lo desarrolladores). El informe principal por defecto es el primero que se muestra. No se puede cambiar el nombre de estos informes ni se pueden suprimir.</li>'),
unistr('<li><strong>Informe Alternativo</strong> (s\00F3lo desarrolladores). Permite a los desarrolladores crear varios dise\00F1os de informe. S\00F3lo los desarrolladores pueden guardar, cambiar el nombre o suprimir un informe alternativo.</li>'),
unistr('<li><strong>Informe P\00FAblico</strong> (usuario final). El usuario final que lo cre\00F3 puede guardarlo, suprimirlo o cambiarle el nombre. Los dem\00E1s usuarios pueden visualizarlo y guardar el dise\00F1o como otro informe.</li>'),
unistr('<li><strong>Informe Privado</strong> (usuario final). S\00F3lo el usuario que cre\00F3 el informe puede visualizarlo, guardarlo, suprimirlo o cambiarle el nombre.</li>'),
'</ul>',
unistr('<p>Si guarda informes personalizados, se muestra un selector de informes en la barra de b\00FAsqueda a la izquierda del selector de filas (si est\00E1 activada esta funci\00F3n).</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275274623072865841)
,p_name=>'APEXIR_HELP_SEARCH_BAR'
,p_message_language=>'es'
,p_message_text=>unistr('En la parte superior de cada p\00E1gina de informe se encuentra una regi\00F3n de b\00FAsqueda. Esta regi\00F3n (o barra de herramientas) proporciona las siguientes funciones:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275776030103866162)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ACTIONS_MENU'
,p_message_language=>'es'
,p_message_text=>unistr('<li>El <b>men\00FA Acciones</b> permite actualizar un informe. Consulte las siguientes secciones.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275775574698866161)
,p_name=>'APEXIR_HELP_SEARCH_BAR_FINDER'
,p_message_language=>'es'
,p_message_text=>unistr('<li>El icono <b>Seleccionar Columnas</b> permite identificar en qu\00E9 columnas buscar (o si desea hacerlo en todas).</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275775872824866162)
,p_name=>'APEXIR_HELP_SEARCH_BAR_REPORTS'
,p_message_language=>'es'
,p_message_text=>unistr('<li><b>Informes</b> muestra informes privados o p\00FAblicos por defecto o guardados de forma alterna.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275775759409866162)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ROWS'
,p_message_language=>'es'
,p_message_text=>unistr('<li><b>Filas</b> define el n\00FAmero de registros que se mostrar\00E1n en cada p\00E1gina.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275775684304866162)
,p_name=>'APEXIR_HELP_SEARCH_BAR_TEXTBOX'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li>El <b>\00E1rea de texto</b> permite utilizar criterios de b\00FAsqueda que no sean sensibles a may\00FAsculas/min\00FAsculas (se permite el uso de comodines).</li>'),
unistr('<li>El <b>bot\00F3n Ir</b> ejecuta la b\00FAsqueda. Al pulsar la tecla Intro, tambi\00E9n se ejecutar\00E1 la b\00FAsqueda si el cursor est\00E1 en el \00E1rea de texto de b\00FAsqueda.</li>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275775909917866162)
,p_name=>'APEXIR_HELP_SEARCH_BAR_VIEW'
,p_message_language=>'es'
,p_message_text=>unistr('<li><b>Iconos de Visualizaci\00F3n</b> cambia entre la vista de icono, informe, detallada, gr\00E1fico, agrupar por y din\00E1mica del informe si se han definido.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276118322500866373)
,p_name=>'APEXIR_HELP_SEARCH_BAR_WS_MANAGE'
,p_message_language=>'es'
,p_message_text=>unistr('<li><b>Gestionar</b> permite gestionar las propiedades, columnas y filas, y ver el historial de un informe o una cuadr\00EDcula de datos.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275274849295865841)
,p_name=>'APEXIR_HELP_SELECT_COLUMNS'
,p_message_language=>'es'
,p_message_text=>unistr('Se utiliza para modificar las columnas mostradas. Se muestran las columnas de la derecha. Las columnas de la izquierda permanecen ocultas. Puede volver a ordenar las columnas mostradas mediante las flechas que hay m\00E1s a la derecha. Las columnas calcu')
||'ladas tienen el prefijo <b>**</b>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275275039852865841)
,p_name=>'APEXIR_HELP_SORT'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Se utiliza para cambiar las columnas por las que se ordena y determina si ordenar en sentido ascendente o descendente. Tambi\00E9n puede especificar c\00F3mo se manejan los <code>valores nulos</code>: el valor por defecto, mostrarlos siempre al final o mo')
||unistr('strarlos siempre al principio. La ordenaci\00F3n resultante se muestra a la derecha de las cabeceras de columna del informe.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275765402479866155)
,p_name=>'APEXIR_HELP_SUBSCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Al agregar una suscripci\00F3n, proporciona una direcci\00F3n (o varias separadas por comas) y el asunto del correo electr\00F3nico, la frecuencia y las fechas de inicio y fin. Los correos electr\00F3nicos resultantes incluyen una versi\00F3n HTML del informe interactiv')
||unistr('o que contiene los datos actuales utilizando la configuraci\00F3n de informe que exist\00EDa al agregar la suscripci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276117893615866373)
,p_name=>'APEXIR_HELP_WS_01'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Las cuadr\00EDculas de datos son b\00E1sicamente informes editables que se pueden personalizar. Los usuarios pueden modificar el dise\00F1o de los datos del informe seleccionando columnas, aplicando filtros, resaltando y ordenando. Tambi\00E9n pueden definir saltos ')
||unistr('de l\00EDnea, agregaciones, gr\00E1ficos, organizaciones por grupos y sus propios c\00E1lculos. Adem\00E1s los usuarios pueden crear m\00FAltiples variaciones del informe y guardarlas como informes con nombre, para visualizaci\00F3n privada.'),
'<p/>',
unistr('Una cuadr\00EDcula de datos se puede personalizar de varias maneras: mediante la barra de b\00FAsqueda, el men\00FA de acciones, el men\00FA Gestionar o el men\00FA de cabecera de columna.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276170287764866405)
,p_name=>'APEXIR_HELP_WS_ACTIONS_MENU'
,p_message_language=>'es'
,p_message_text=>unistr('El men\00FA Acciones aparece a la derecha del bot\00F3n Ir en la barra de b\00FAsqueda. Utilice este men\00FA para personalizar un informe de cuadr\00EDcula de datos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276118639324866373)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina Agregar/Editar Fila')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276118730998866373)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT_ROW'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para agregar una fila a la cuadr\00EDcula de datos, haga clic en Agregar Fila. Para editar los detalles de una fila, haga clic en el icono de edici\00F3n (primera columna) de la fila que desee editar. La p\00E1gina Agregar/Editar Fila se mostrar\00E1 con las colu')
||unistr('mnas de la cuadr\00EDcula de datos. </p>'),
'',
'<p>Al editar una fila, puede:</p>',
'',
'<p><ul>',
'<li><b>Suprimir</b> la fila.</li>',
'<li><b>Aplicar Cambios</b> para guardar los cambios realizados en la fila.</li>',
'<li>Dentro de <b>Acciones</b>, agregar una fila, agregar archivos, notas, enlaces o etiquetas, y revisar el historial.</li>',
'<li>Navegar a las filas <b>Anterior y Siguiente</b>.</li>',
'<li>En <b>Gestionar</b>, definir las propiedades de columna, grupos de columnas, validaciones y listas de valores.</li>',
'</ul></p>',
'',
unistr('<p>La regi\00F3n Anotaciones de la parte inferior de la p\00E1gina incluir\00E1 los archivos, notas, enlaces y etiquetas asociados a la fila actual.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276170306445866405)
,p_name=>'APEXIR_HELP_WS_CONTROL_BREAK'
,p_message_language=>'es'
,p_message_text=>unistr('Se utiliza para crear un grupo divisorio en una o varias columnas. Obtiene las columnas de la cuadr\00EDcula de datos y las muestra como un registro maestro.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276118553286866373)
,p_name=>'APEXIR_HELP_WS_DOWNLOAD'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Permite descargar el juego de resultados actual. Los formatos de',
unistr(' descarga incluyen CSV, HTML o Correo Electr\00F3nico.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276170454877866405)
,p_name=>'APEXIR_HELP_WS_REPORT_SETTINGS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Si personaliza un informe de cuadr\00EDcula de datos, la configuraci\00F3n del informe se mostrar\00E1'),
unistr('debajo de la barra de b\00FAsqueda y encima del informe. Esta \00E1rea se puede reducir y ampliar mediante el icono de la izquierda.'),
'<p>',
unistr('En cada configuraci\00F3n de informe, puede hacer lo siguiente:'),
'</p><ul>',
'<li>Editar un valor haciendo clic en el nombre.</li>',
'<li>Desactivar/activar un valor marcando o anulando la marca de la casilla de control Activar/Desactivar. Se utiliza para desactivar y activar temporalmente el valor.</li>',
'<li>Eliminar un valor haciendo clic en el icono correspondiente.</li>',
'</ul>',
unistr('<p>Si ha creado un gr\00E1fico o una ordenaci\00F3n por grupos, puede'),
'conmutar entre ellos y el informe base con los enlaces Vista de',
unistr('Informe, Vista de Gr\00E1fico o Agrupar por que se muestran a la'),
unistr('derecha. Si est\00E1 visualizando el gr\00E1fico o la ordenaci\00F3n por grupos,'),
unistr('tambi\00E9n puede utilizar el enlace Editar para editar la configuraci\00F3n.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276118422815866373)
,p_name=>'APEXIR_HELP_WS_SAVE_REPORT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Guarda el dise\00F1o del informe de cuadr\00EDcula de datos personalizado para su uso en el futuro. Se proporcionan un nombre y una descripci\00F3n opcional. Puede guardar tres tipos de dise\00F1o de informe de cuadr\00EDcula de datos:</p>'),
'<ul>',
unistr('<li><strong>Principal por Defecto</strong> (s\00F3lo administrador). \00C9ste es el primer dise\00F1o que se muestra. No se puede cambiar el nombre de estos informes principales por defecto ni se pueden suprimir.</li>'),
unistr('<li><strong>Informe Alternativo</strong> (s\00F3lo administrador). Permite a los administradores crear varios dise\00F1os de informe. S\00F3lo los administradores pueden guardar, cambiar el nombre o suprimir un informe alternativo.</li>'),
unistr('<li><strong>Informe Privado</strong> (todos los usuarios). El usuario que cre\00F3 el dise\00F1o de informe puede visualizar, guardar, suprimir o cambiar el nombre del informe. </li>'),
'</ul>',
unistr('<p>Si guarda informes personalizados, se muestra un selector de informes en la barra de b\00FAsqueda a la izquierda del selector de filas (si est\00E1 activada esta funci\00F3n).</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275286907083865849)
,p_name=>'APEXIR_HIDE_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Ocultar Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275199292896865793)
,p_name=>'APEXIR_HIGHLIGHT'
,p_message_language=>'es'
,p_message_text=>'Resaltar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275291100101865852)
,p_name=>'APEXIR_HIGHLIGHTS'
,p_message_language=>'es'
,p_message_text=>'Resaltados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275316779674865869)
,p_name=>'APEXIR_HIGHLIGHT_CONDITION'
,p_message_language=>'es'
,p_message_text=>unistr('Condici\00F3n para Resaltar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275766393381866156)
,p_name=>'APEXIR_HIGHLIGHT_STYLE'
,p_message_language=>'es'
,p_message_text=>'Estilo de resaltado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275040033030865689)
,p_name=>'APEXIR_HIGHLIGHT_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Resaltado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275040749296865689)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_language=>'es'
,p_message_text=>'Resaltar Cuando'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276126975440866378)
,p_name=>'APEXIR_HORIZONTAL'
,p_message_language=>'es'
,p_message_text=>'Horizontal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276230495367866443)
,p_name=>'APEXIR_INACTIVE_SETTING'
,p_message_language=>'es'
,p_message_text=>'1 valor inactivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276230597868866443)
,p_name=>'APEXIR_INACTIVE_SETTINGS'
,p_message_language=>'es'
,p_message_text=>'%0 valores inactivos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275276319346865842)
,p_name=>'APEXIR_INTERACTIVE_REPORT_HELP'
,p_message_language=>'es'
,p_message_text=>'Ayuda de Informe Interactivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275318098171865870)
,p_name=>'APEXIR_INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('No V\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275289693208865851)
,p_name=>'APEXIR_INVALID_COMPUTATION'
,p_message_language=>'es'
,p_message_text=>unistr('Expresi\00F3n de c\00E1lculo no v\00E1lida. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274987130889865655)
,p_name=>'APEXIR_INVALID_END_DATE'
,p_message_language=>'es'
,p_message_text=>unistr('La fecha de finalizaci\00F3n debe ser posterior a la fecha de inicio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275436491967865946)
,p_name=>'APEXIR_INVALID_FILTER'
,p_message_language=>'es'
,p_message_text=>unistr('Expresi\00F3n de filtro no v\00E1lida. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276163048922866401)
,p_name=>'APEXIR_INVALID_FILTER_QUERY'
,p_message_language=>'es'
,p_message_text=>unistr('Consulta de filtro no v\00E1lida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276230663317866443)
,p_name=>'APEXIR_INVALID_SETTING'
,p_message_language=>'es'
,p_message_text=>unistr('1 valor no v\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276230788315866443)
,p_name=>'APEXIR_INVALID_SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 valores no v\00E1lidos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275766725128866156)
,p_name=>'APEXIR_IN_MINUTES'
,p_message_language=>'es'
,p_message_text=>'(en minutos)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276109832560866368)
,p_name=>'APEXIR_IS_IN_THE_LAST'
,p_message_language=>'es'
,p_message_text=>unistr('%0 est\00E1 en el \00FAltimo %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276110188150866368)
,p_name=>'APEXIR_IS_IN_THE_NEXT'
,p_message_language=>'es'
,p_message_text=>unistr('%0 est\00E1 en el siguiente %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276110011555866368)
,p_name=>'APEXIR_IS_NOT_IN_THE_LAST'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no est\00E1 en el \00FAltimo %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276110225659866368)
,p_name=>'APEXIR_IS_NOT_IN_THE_NEXT'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no est\00E1 en el siguiente %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275315806231865868)
,p_name=>'APEXIR_KEYPAD'
,p_message_language=>'es'
,p_message_text=>'Teclado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275071006921865710)
,p_name=>'APEXIR_LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275284554449865847)
,p_name=>'APEXIR_LABEL_AXIS_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo del Eje para Etiqueta')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275631847252866073)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_language=>'es'
,p_message_text=>'Prefijo de Etiqueta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275203405911865795)
,p_name=>'APEXIR_LAST_DAY'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimo D\00EDa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275203600281865795)
,p_name=>'APEXIR_LAST_HOUR'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltima Hora')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275203105601865795)
,p_name=>'APEXIR_LAST_MONTH'
,p_message_language=>'es'
,p_message_text=>'Mes Pasado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275203288149865795)
,p_name=>'APEXIR_LAST_WEEK'
,p_message_language=>'es'
,p_message_text=>'Semana Pasada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275203338296865795)
,p_name=>'APEXIR_LAST_X_DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimos %0 D\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275203519818865795)
,p_name=>'APEXIR_LAST_X_HOURS'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimas %0 Horas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275202977212865795)
,p_name=>'APEXIR_LAST_X_YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltimos %0 A\00F1os')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275203027815865795)
,p_name=>'APEXIR_LAST_YEAR'
,p_message_language=>'es'
,p_message_text=>unistr('A\00F1o Pasado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275070839218865710)
,p_name=>'APEXIR_LINE'
,p_message_language=>'es'
,p_message_text=>unistr('L\00EDnea')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275043108955865692)
,p_name=>'APEXIR_LINE_WITH_AREA'
,p_message_language=>'es'
,p_message_text=>unistr('L\00EDnea con \00C1rea')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275750081137866146)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Haga clic <a href=''%0''>aqu\00ED</a> para gestionar la suscripci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276162978182866401)
,p_name=>'APEXIR_MAP_IT'
,p_message_language=>'es'
,p_message_text=>'Asignar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275287559632865849)
,p_name=>'APEXIR_MAX_QUERY_COST'
,p_message_language=>'es'
,p_message_text=>unistr('Se estima que la consulta supera el m\00E1ximo de recursos permitidos. Modifique los valores del informe y vuelva a intentarlo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275155751267865765)
,p_name=>'APEXIR_MAX_ROW_CNT'
,p_message_language=>'es'
,p_message_text=>unistr('El recuento m\00E1ximo de filas de este informe es %0 filas. Aplique un filtro para reducir el n\00FAmero de registros de la consulta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276163517884866401)
,p_name=>'APEXIR_MAX_X'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1ximo %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276163783623866401)
,p_name=>'APEXIR_MEDIAN_X'
,p_message_language=>'es'
,p_message_text=>'Mediana %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275169426391865773)
,p_name=>'APEXIR_MIN_AGO'
,p_message_language=>'es'
,p_message_text=>'%0 minutos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276163668222866401)
,p_name=>'APEXIR_MIN_X'
,p_message_language=>'es'
,p_message_text=>unistr('M\00EDnimo %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276162526412866400)
,p_name=>'APEXIR_MONTH'
,p_message_language=>'es'
,p_message_text=>'Mes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275767176620866156)
,p_name=>'APEXIR_MONTHLY'
,p_message_language=>'es'
,p_message_text=>'Mensual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275318259430865870)
,p_name=>'APEXIR_MORE_DATA'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1s Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275283496880865847)
,p_name=>'APEXIR_MOVE'
,p_message_language=>'es'
,p_message_text=>'Mover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275283395156865847)
,p_name=>'APEXIR_MOVE_ALL'
,p_message_language=>'es'
,p_message_text=>'Mover Todo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276248898007866454)
,p_name=>'APEXIR_MULTIIR_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe especificar el identificador est\00E1tico de regi\00F3n, ya que la p\00E1gina contiene varios informes interactivos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275041889386865692)
,p_name=>'APEXIR_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275272793577865840)
,p_name=>'APEXIR_NEW_AGGREGATION'
,p_message_language=>'es'
,p_message_text=>unistr('Nueva Agregaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275065046664865706)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_language=>'es'
,p_message_text=>unistr('- Nueva Categor\00EDa -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276232147751866444)
,p_name=>'APEXIR_NEW_CATEGORY_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Nueva Categor\00EDa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275272870625865840)
,p_name=>'APEXIR_NEW_COMPUTATION'
,p_message_language=>'es'
,p_message_text=>unistr('Nuevo C\00E1lculo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275197524201865792)
,p_name=>'APEXIR_NEXT'
,p_message_language=>'es'
,p_message_text=>'Siguiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275204002320865796)
,p_name=>'APEXIR_NEXT_DAY'
,p_message_language=>'es'
,p_message_text=>unistr('D\00EDa Siguiente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275203873689865796)
,p_name=>'APEXIR_NEXT_HOUR'
,p_message_language=>'es'
,p_message_text=>'Hora Siguiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275204390876865796)
,p_name=>'APEXIR_NEXT_MONTH'
,p_message_language=>'es'
,p_message_text=>'Mes Siguiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275204238651865796)
,p_name=>'APEXIR_NEXT_WEEK'
,p_message_language=>'es'
,p_message_text=>'Semana Siguiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275204116827865796)
,p_name=>'APEXIR_NEXT_X_DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('Siguientes %0 D\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275203912314865796)
,p_name=>'APEXIR_NEXT_X_HOURS'
,p_message_language=>'es'
,p_message_text=>'Siguientes %0 Horas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275204563752865796)
,p_name=>'APEXIR_NEXT_X_YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('Siguientes %0 A\00F1os')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275204446176865796)
,p_name=>'APEXIR_NEXT_YEAR'
,p_message_language=>'es'
,p_message_text=>unistr('A\00F1o Siguiente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275042142228865692)
,p_name=>'APEXIR_NO'
,p_message_language=>'es'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275318447100865870)
,p_name=>'APEXIR_NONE'
,p_message_language=>'es'
,p_message_text=>'- Ninguno -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275766194922866156)
,p_name=>'APEXIR_NOT_VALID_EMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Direcci\00F3n de correo electr\00F3nico no v\00E1lida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275200371680865793)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('Ninguna agregaci\00F3n definida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275154557288865764)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_language=>'es'
,p_message_text=>unistr('No hay informaci\00F3n de columna disponible.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275200490216865793)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('Ning\00FAn c\00E1lculo definido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276162314634866400)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_language=>'es'
,p_message_text=>unistr('- Sin Fecha de Finalizaci\00F3n -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275313504277865867)
,p_name=>'APEXIR_NULLS_ALWAYS_FIRST'
,p_message_language=>'es'
,p_message_text=>'Valores Nulos Siempre al Principio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275313480811865867)
,p_name=>'APEXIR_NULLS_ALWAYS_LAST'
,p_message_language=>'es'
,p_message_text=>'Valores Nulos Siempre al Final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275314437020865867)
,p_name=>'APEXIR_NULL_SORTING'
,p_message_language=>'es'
,p_message_text=>unistr('Ordenaci\00F3n de Valores Nulos %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275289718020865851)
,p_name=>'APEXIR_NUMERIC_FLASHBACK_TIME'
,p_message_language=>'es'
,p_message_text=>unistr('El tiempo de flashback debe ser un valor num\00E9rico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275289219933865851)
,p_name=>'APEXIR_NUMERIC_SEQUENCE'
,p_message_language=>'es'
,p_message_text=>unistr('La secuencia debe ser num\00E9rica.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275315175144865868)
,p_name=>'APEXIR_OPERATOR'
,p_message_language=>'es'
,p_message_text=>'Operador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275040503170865689)
,p_name=>'APEXIR_ORANGE'
,p_message_language=>'es'
,p_message_text=>'naranja'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276126853954866378)
,p_name=>'APEXIR_ORIENTATION'
,p_message_language=>'es'
,p_message_text=>unistr('Orientaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275042647594865692)
,p_name=>'APEXIR_OTHER'
,p_message_language=>'es'
,p_message_text=>'Otro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276164082701866401)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_COUNT_X'
,p_message_language=>'es'
,p_message_text=>'Porcentaje de Recuento Total %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276163278584866401)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_SUM_X'
,p_message_language=>'es'
,p_message_text=>'Porcentaje de Suma Total %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276161753498866400)
,p_name=>'APEXIR_PERCENT_TOTAL_COUNT'
,p_message_language=>'es'
,p_message_text=>'Porcentaje de Recuento Total'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276161615656866400)
,p_name=>'APEXIR_PERCENT_TOTAL_SUM'
,p_message_language=>'es'
,p_message_text=>'Porcentaje de Suma Total'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275070758653865710)
,p_name=>'APEXIR_PIE'
,p_message_language=>'es'
,p_message_text=>'Tarta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275605589367866056)
,p_name=>'APEXIR_PIVOT'
,p_message_language=>'es'
,p_message_text=>unistr('Din\00E1mica')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275633184587866073)
,p_name=>'APEXIR_PIVOT_AGG_NOT_NULL'
,p_message_language=>'es'
,p_message_text=>'Se debe especificar el agregado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275633478053866074)
,p_name=>'APEXIR_PIVOT_AGG_NOT_ON_ROW_COL'
,p_message_language=>'es'
,p_message_text=>'No puede agregar en una columna que se ha seleccionado como columna de fila.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275630903171866072)
,p_name=>'APEXIR_PIVOT_COLUMNS'
,p_message_language=>'es'
,p_message_text=>unistr('Columnas Din\00E1micas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275630798843866072)
,p_name=>'APEXIR_PIVOT_COLUMN_N'
,p_message_language=>'es'
,p_message_text=>unistr('Columna Din\00E1mica %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275632906174866073)
,p_name=>'APEXIR_PIVOT_COLUMN_NOT_NULL'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe especificar la columna din\00E1mica.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274871750284865582)
,p_name=>'APEXIR_PIVOT_MAX_ROW_CNT'
,p_message_language=>'es'
,p_message_text=>unistr('El recuento m\00E1ximo de filas para una consulta din\00E1mica limita el n\00FAmero de filas de la consulta base, no el n\00FAmero de filas que se muestran. La consulta base supera el recuento m\00E1ximo de filas de %0. Aplique un filtro para reducir el n\00FAmero de regist')
||'ros en la consulta base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276244778024866452)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('Seleccione una columna de fila distinta.  La expresi\00F3n o enlace HTML en la columna de fila contiene una columna definida como din\00E1mica o columna de agregado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275631968316866073)
,p_name=>'APEXIR_PIVOT_SORT'
,p_message_language=>'es'
,p_message_text=>unistr('Ordenaci\00F3n Din\00E1mica')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275766234251866156)
,p_name=>'APEXIR_PREVIEW'
,p_message_language=>'es'
,p_message_text=>'Vista previa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275197678358865792)
,p_name=>'APEXIR_PREVIOUS'
,p_message_language=>'es'
,p_message_text=>'Anterior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276160602026866399)
,p_name=>'APEXIR_PRIMARY'
,p_message_language=>'es'
,p_message_text=>'Primario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275769949765866158)
,p_name=>'APEXIR_PRIMARY_REPORT'
,p_message_language=>'es'
,p_message_text=>'Informe Primario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275430453424865942)
,p_name=>'APEXIR_PRIVATE'
,p_message_language=>'es'
,p_message_text=>'Privado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275072161031865711)
,p_name=>'APEXIR_PUBLIC'
,p_message_language=>'es'
,p_message_text=>unistr('P\00FAblico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275042412403865692)
,p_name=>'APEXIR_RED'
,p_message_language=>'es'
,p_message_text=>'rojo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276248725341866454)
,p_name=>'APEXIR_REGION_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>unistr('No existe el identificador est\00E1tico de regi\00F3n %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275283531802865847)
,p_name=>'APEXIR_REMOVE'
,p_message_language=>'es'
,p_message_text=>'Eliminar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275196637683865791)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_language=>'es'
,p_message_text=>'Eliminar Agregado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275283617959865847)
,p_name=>'APEXIR_REMOVE_ALL'
,p_message_language=>'es'
,p_message_text=>'Eliminar Todo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276230806287866443)
,p_name=>'APEXIR_REMOVE_CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Eliminar Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275282970957865846)
,p_name=>'APEXIR_REMOVE_CONTROL_BREAK'
,p_message_language=>'es'
,p_message_text=>unistr('Eliminar Divisi\00F3n de Control')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275282626169865846)
,p_name=>'APEXIR_REMOVE_FILTER'
,p_message_language=>'es'
,p_message_text=>'Eliminar Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275282707431865846)
,p_name=>'APEXIR_REMOVE_FLASHBACK'
,p_message_language=>'es'
,p_message_text=>'Eliminar Flashback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276230932747866443)
,p_name=>'APEXIR_REMOVE_GROUP_BY'
,p_message_language=>'es'
,p_message_text=>'Eliminar Grupo por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275283034468865847)
,p_name=>'APEXIR_REMOVE_HIGHLIGHT'
,p_message_language=>'es'
,p_message_text=>'Eliminar Resaltado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276231073829866443)
,p_name=>'APEXIR_REMOVE_PIVOT'
,p_message_language=>'es'
,p_message_text=>unistr('Eliminar Din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276172295771866406)
,p_name=>'APEXIR_REMOVE_REPORT'
,p_message_language=>'es'
,p_message_text=>'Eliminar Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276051192516866331)
,p_name=>'APEXIR_RENAME_DEFAULT_REPORT'
,p_message_language=>'es'
,p_message_text=>'Cambiar Nombre de Informe por Defecto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275318831946865870)
,p_name=>'APEXIR_RENAME_REPORT'
,p_message_language=>'es'
,p_message_text=>'Cambiar Nombre del Informe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275198130873865792)
,p_name=>'APEXIR_REPORT'
,p_message_language=>'es'
,p_message_text=>'Informe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276164158912866401)
,p_name=>'APEXIR_REPORTS'
,p_message_language=>'es'
,p_message_text=>'Informes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275031650947865683)
,p_name=>'APEXIR_REPORT_ALIAS_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>'El informe interactivo guardado con el alias %0 no existe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275581099188866041)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_language=>'es'
,p_message_text=>unistr('El n\00FAmero de columnas de visualizaci\00F3n del informe ha alcanzado el l\00EDmite. Haga clic en Seleccionar Columnas en el men\00FA Acciones para minimizar la lista de columnas de visualizaci\00F3n del informe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275433790378865944)
,p_name=>'APEXIR_REPORT_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>'El informe no existe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275031799762865683)
,p_name=>'APEXIR_REPORT_ID_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>'El informe interactivo guardado con el ID %0 no existe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275316535450865869)
,p_name=>'APEXIR_REPORT_SETTINGS'
,p_message_language=>'es'
,p_message_text=>'Valores de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275169959553865774)
,p_name=>'APEXIR_REPORT_VIEW'
,p_message_language=>'es'
,p_message_text=>'Vista de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275199719894865793)
,p_name=>'APEXIR_RESET'
,p_message_language=>'es'
,p_message_text=>'Restablecer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275072369944865711)
,p_name=>'APEXIR_RESET_CONFIRM'
,p_message_language=>'es'
,p_message_text=>'Restaure los valores por defecto del informe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275042277415865692)
,p_name=>'APEXIR_ROW'
,p_message_language=>'es'
,p_message_text=>'Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276156402132866396)
,p_name=>'APEXIR_ROWID_NOT_SUPPORTED_FOR_WEBSOURCE'
,p_message_language=>'es'
,p_message_text=>'No puede utilizar ROWID como columna de clave primaria para un origen web.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275281655509865846)
,p_name=>'APEXIR_ROWS'
,p_message_language=>'es'
,p_message_text=>'Filas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275775313445866161)
,p_name=>'APEXIR_ROWS_PER_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Filas por P\00E1gina')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275631050871866072)
,p_name=>'APEXIR_ROW_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas de Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275630807516866072)
,p_name=>'APEXIR_ROW_COLUMN_N'
,p_message_language=>'es'
,p_message_text=>'Columna de Fila %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275633088786866073)
,p_name=>'APEXIR_ROW_COLUMN_NOT_NULL'
,p_message_language=>'es'
,p_message_text=>'Se debe especificar la columna de fila.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275633241236866074)
,p_name=>'APEXIR_ROW_COL_DIFF_FROM_PIVOT_COL'
,p_message_language=>'es'
,p_message_text=>unistr('La columna de fila debe ser diferente a la columna din\00E1mica.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275378383421865908)
,p_name=>'APEXIR_ROW_FILTER'
,p_message_language=>'es'
,p_message_text=>'Filtro de Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275170090420865774)
,p_name=>'APEXIR_ROW_OF'
,p_message_language=>'es'
,p_message_text=>'Fila %0 de %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275169215153865773)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_language=>'es'
,p_message_text=>'Orden de Filas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275201235409865794)
,p_name=>'APEXIR_ROW_TEXT_CONTAINS'
,p_message_language=>'es'
,p_message_text=>'El texto de la fila contiene'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274891661287865595)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_language=>'es'
,p_message_text=>unistr('El n\00FAmero de columnas de visualizaci\00F3n del informe ha alcanzado el l\00EDmite. Haga clic en Seleccionar Columnas en el men\00FA Acciones para minimizar la lista de columnas de visualizaci\00F3n del informe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275041446985865691)
,p_name=>'APEXIR_SAVE'
,p_message_language=>'es'
,p_message_text=>'Guardar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275291344650865852)
,p_name=>'APEXIR_SAVED_REPORT'
,p_message_language=>'es'
,p_message_text=>'Informe Guardado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275291211984865852)
,p_name=>'APEXIR_SAVED_REPORT_MSG'
,p_message_language=>'es'
,p_message_text=>'Informe Guardado = "%0"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275200167617865793)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_language=>'es'
,p_message_text=>'Guardar como Valores por Defecto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275312773147865866)
,p_name=>'APEXIR_SAVE_DEFAULT_CONFIRM'
,p_message_language=>'es'
,p_message_text=>unistr('Los valores de informe actuales se utilizar\00E1n como valores por defecto para todos los usuarios.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276051001252866331)
,p_name=>'APEXIR_SAVE_DEFAULT_REPORT'
,p_message_language=>'es'
,p_message_text=>'Guardar Informe por Defecto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275199621255865793)
,p_name=>'APEXIR_SAVE_REPORT'
,p_message_language=>'es'
,p_message_text=>'Guardar Informe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276232016511866444)
,p_name=>'APEXIR_SAVE_REPORT_DEFAULT'
,p_message_language=>'es'
,p_message_text=>'Guardar Informe *'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275786984282866168)
,p_name=>'APEXIR_SEARCH'
,p_message_language=>'es'
,p_message_text=>'Buscar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275276227623865842)
,p_name=>'APEXIR_SEARCH_BAR'
,p_message_language=>'es'
,p_message_text=>unistr('Barra de B\00FAsqueda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276231974282866444)
,p_name=>'APEXIR_SEARCH_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Buscar: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275836293283866199)
,p_name=>'APEXIR_SEARCH_REPORT'
,p_message_language=>'es'
,p_message_text=>'Buscar Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275747828139866145)
,p_name=>'APEXIR_SELECTED_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas Seleccionadas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275041762628865691)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_language=>'es'
,p_message_text=>unistr('- Seleccionar Categor\00EDa -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275043343575865693)
,p_name=>'APEXIR_SELECT_COLUMN'
,p_message_language=>'es'
,p_message_text=>'- Seleccionar Columna -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275198916224865792)
,p_name=>'APEXIR_SELECT_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Seleccionar Columnas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275318638800865870)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_language=>'es'
,p_message_text=>'Las columnas calculadas tienen el prefijo **.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275071543931865710)
,p_name=>'APEXIR_SELECT_FUNCTION'
,p_message_language=>'es'
,p_message_text=>unistr('- Seleccionar Funci\00F3n -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275281074312865845)
,p_name=>'APEXIR_SELECT_GROUP_BY_COLUMN'
,p_message_language=>'es'
,p_message_text=>'- Seleccionar Grupo por Columna -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275630530934866072)
,p_name=>'APEXIR_SELECT_PIVOT_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('- Seleccionar Columna Din\00E1mica -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276163131021866401)
,p_name=>'APEXIR_SELECT_ROW'
,p_message_language=>'es'
,p_message_text=>'Seleccionar Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275630675655866072)
,p_name=>'APEXIR_SELECT_ROW_COLUMN'
,p_message_language=>'es'
,p_message_text=>'- Seleccionar Columna de Fila -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276161909840866400)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('- Seleccionar Columna de Ordenaci\00F3n -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275318105157865870)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_language=>'es'
,p_message_text=>'Seleccionar Valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274881455595865588)
,p_name=>'APEXIR_SEND'
,p_message_language=>'es'
,p_message_text=>'Enviar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275041915142865692)
,p_name=>'APEXIR_SEQUENCE'
,p_message_language=>'es'
,p_message_text=>'Secuencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275199104104865793)
,p_name=>'APEXIR_SORT'
,p_message_language=>'es'
,p_message_text=>'Ordenar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275286714130865849)
,p_name=>'APEXIR_SORT_ASCENDING'
,p_message_language=>'es'
,p_message_text=>'Orden Ascendente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276161850362866400)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna de Ordenaci\00F3n %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275286810733865849)
,p_name=>'APEXIR_SORT_DESCENDING'
,p_message_language=>'es'
,p_message_text=>'Orden Descendente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276171466427866406)
,p_name=>'APEXIR_SORT_ORDER'
,p_message_language=>'es'
,p_message_text=>unistr('Orden de Clasificaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275272370595865840)
,p_name=>'APEXIR_SPACE_AS_IN_ONE_EMPTY_STRING'
,p_message_language=>'es'
,p_message_text=>'espacio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275315419943865868)
,p_name=>'APEXIR_STATUS'
,p_message_language=>'es'
,p_message_text=>'Estado %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275766831709866156)
,p_name=>'APEXIR_SUBSCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Suscripci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276162241699866400)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING'
,p_message_language=>'es'
,p_message_text=>'Terminando'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275747792040866145)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_language=>'es'
,p_message_text=>'Unidad Final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276162108817866400)
,p_name=>'APEXIR_SUBSCRIPTION_STARTING_FROM'
,p_message_language=>'es'
,p_message_text=>'Empezando por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276163330376866401)
,p_name=>'APEXIR_SUM_X'
,p_message_language=>'es'
,p_message_text=>'Suma de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276112683855866369)
,p_name=>'APEXIR_TABLE_SUMMARY'
,p_message_language=>'es'
,p_message_text=>unistr('Regi\00F3n = %0, Informe = %1, Vista = %2, Inicio de Filas Mostradas = %3, Fin de Filas Mostradas = %4, Total de Filas = %5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275222735932865808)
,p_name=>'APEXIR_TABLE_SUMMARY_NO_TOTAL'
,p_message_language=>'es'
,p_message_text=>unistr('Regi\00F3n = %0, Informe = %1, Vista = %2, Inicio de filas mostradas = %3, Fin de filas mostradas = %4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275040663641865689)
,p_name=>'APEXIR_TEXT_COLOR'
,p_message_language=>'es'
,p_message_text=>'Color del Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275156332665865765)
,p_name=>'APEXIR_TIME_DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('d\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275156270283865765)
,p_name=>'APEXIR_TIME_HOURS'
,p_message_language=>'es'
,p_message_text=>'horas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275156116570865765)
,p_name=>'APEXIR_TIME_MINS'
,p_message_language=>'es'
,p_message_text=>'minutos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275156546330865765)
,p_name=>'APEXIR_TIME_MONTHS'
,p_message_language=>'es'
,p_message_text=>'meses'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275156438291865765)
,p_name=>'APEXIR_TIME_WEEKS'
,p_message_language=>'es'
,p_message_text=>'semanas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275156677790865765)
,p_name=>'APEXIR_TIME_YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('a\00F1os')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276172098804866406)
,p_name=>'APEXIR_TOGGLE'
,p_message_language=>'es'
,p_message_text=>'Conmutar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275283793364865847)
,p_name=>'APEXIR_TOP'
,p_message_language=>'es'
,p_message_text=>'Primero'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275316991319865869)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_language=>'es'
,p_message_text=>'No Autorizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276145898033866390)
,p_name=>'APEXIR_UNGROUPED_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna sin Agrupaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275289491443865851)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_language=>'es'
,p_message_text=>unistr('La cabecera de columna debe ser \00FAnica.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275289132227865850)
,p_name=>'APEXIR_UNIQUE_HIGHLIGHT_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('El nombre del resaltado debe ser \00FAnico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275069868225865709)
,p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE'
,p_message_language=>'es'
,p_message_text=>'tipo de dato no soportado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275283894552865847)
,p_name=>'APEXIR_UP'
,p_message_language=>'es'
,p_message_text=>'Arriba'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275289387046865851)
,p_name=>'APEXIR_VALID_COLOR'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca un color v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275289598009865851)
,p_name=>'APEXIR_VALID_FORMAT_MASK'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca una m\00E1scara de formato v\00E1lida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275042722704865692)
,p_name=>'APEXIR_VALUE'
,p_message_language=>'es'
,p_message_text=>'Valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275284670793865848)
,p_name=>'APEXIR_VALUE_AXIS_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo del Eje para Valor')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275317944120865870)
,p_name=>'APEXIR_VALUE_REQUIRED'
,p_message_language=>'es'
,p_message_text=>'Valor Necesario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275070677519865710)
,p_name=>'APEXIR_VCOLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna Vertical'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276127086428866378)
,p_name=>'APEXIR_VERTICAL'
,p_message_language=>'es'
,p_message_text=>'Vertical'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275317160561865869)
,p_name=>'APEXIR_VIEW_CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Ver Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275816011141866186)
,p_name=>'APEXIR_VIEW_DETAIL'
,p_message_language=>'es'
,p_message_text=>'Ver Detalle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276235179620866446)
,p_name=>'APEXIR_VIEW_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>'El informe no tiene la vista %0 definida.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275816112553866186)
,p_name=>'APEXIR_VIEW_GROUP_BY'
,p_message_language=>'es'
,p_message_text=>'Ver Grupo por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275815921458866186)
,p_name=>'APEXIR_VIEW_ICONS'
,p_message_language=>'es'
,p_message_text=>'Ver Iconos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275630348428866072)
,p_name=>'APEXIR_VIEW_PIVOT'
,p_message_language=>'es'
,p_message_text=>unistr('Ver Din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275317225802865869)
,p_name=>'APEXIR_VIEW_REPORT'
,p_message_language=>'es'
,p_message_text=>'Ver Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276162727825866400)
,p_name=>'APEXIR_WEEK'
,p_message_language=>'es'
,p_message_text=>'Semana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275767055387866156)
,p_name=>'APEXIR_WEEKLY'
,p_message_language=>'es'
,p_message_text=>'Semanal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275198081220865792)
,p_name=>'APEXIR_WORKING_REPORT'
,p_message_language=>'es'
,p_message_text=>'Informe de Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276164972977866402)
,p_name=>'APEXIR_X_DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 d\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276164833883866402)
,p_name=>'APEXIR_X_HOURS'
,p_message_language=>'es'
,p_message_text=>'%0 horas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276164723634866402)
,p_name=>'APEXIR_X_MINS'
,p_message_language=>'es'
,p_message_text=>'%0 minutos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276165122898866402)
,p_name=>'APEXIR_X_MONTHS'
,p_message_language=>'es'
,p_message_text=>'%0 meses'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276165081882866402)
,p_name=>'APEXIR_X_WEEKS'
,p_message_language=>'es'
,p_message_text=>'%0 semanas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276165255253866402)
,p_name=>'APEXIR_X_YEARS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 a\00F1os')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276162688763866400)
,p_name=>'APEXIR_YEAR'
,p_message_language=>'es'
,p_message_text=>unistr('A\00F1o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275040303869865689)
,p_name=>'APEXIR_YELLOW'
,p_message_language=>'es'
,p_message_text=>'amarillo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275042027534865692)
,p_name=>'APEXIR_YES'
,p_message_language=>'es'
,p_message_text=>unistr('S\00ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274888751336865593)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_language=>'es'
,p_message_text=>unistr('Servicios de Administraci\00F3n de Application Express')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276111263675866368)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_language=>'es'
,p_message_text=>unistr('No hay ninguna autenticaci\00F3n configurada para esta aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275284477686865847)
,p_name=>'APEX_GROUP.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'es'
,p_message_text=>unistr('%0 contiene < o >, que no son caracteres v\00E1lidos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275501634374865992)
,p_name=>'APEX_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275358325188865895)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_language=>'es'
,p_message_text=>'Los siguientes objetos de base de datos se %0 en el esquema seleccionado:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275358409669865895)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_language=>'es'
,p_message_text=>'Los siguientes objetos de base de datos se han %0 correctamente:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275846356371866205)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_language=>'es'
,p_message_text=>'Desplazar hacia abajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275846417351866205)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_language=>'es'
,p_message_text=>'Desplazarse al principio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274894341284865596)
,p_name=>'APEX_WIZARD_FORM'
,p_message_language=>'es'
,p_message_text=>unistr('Pantalla de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276110768985866368)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_language=>'es'
,p_message_text=>'Editar Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275529263487866009)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_language=>'es'
,p_message_text=>unistr('Objetos no V\00E1lidos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276169152568866405)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('No hay p\00E1ginas de peers')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276114094882866370)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_language=>'es'
,p_message_text=>'Objetos para Crear'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276114256244866370)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_language=>'es'
,p_message_text=>'Suprimir de Tablas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276114459995866370)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_language=>'es'
,p_message_text=>'Borrar Objetos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275777106037866162)
,p_name=>'APEX_WS_SETUP_DROP_TABLES'
,p_message_language=>'es'
,p_message_text=>'Borrar Tablas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275776409855866162)
,p_name=>'APEX_WS_SETUP_MSG1'
,p_message_language=>'es'
,p_message_text=>unistr('Se crear\00E1n estos objetos en el esquema <b>%0</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276114593742866371)
,p_name=>'APEX_WS_SETUP_MSG10'
,p_message_language=>'es'
,p_message_text=>unistr('Estos objetos ya existen en el esquema <b>%0</b> y los utilizan otros espacios de trabajo. Si contin\00FAa, los objetos de hoja de c\00E1lculo web existentes que sean propiedad de <b>%0</b> tambi\00E9n se asociar\00E1n a este espacio de trabajo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276114680098866371)
,p_name=>'APEX_WS_SETUP_MSG11'
,p_message_language=>'es'
,p_message_text=>'Seleccione el esquema que desea utilizar para estos objetos:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276114718639866371)
,p_name=>'APEX_WS_SETUP_MSG12'
,p_message_language=>'es'
,p_message_text=>'Tablas Existentes para Utilizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276115694153866371)
,p_name=>'APEX_WS_SETUP_MSG13'
,p_message_language=>'es'
,p_message_text=>unistr('Los objetos de base de datos de hojas de c\00E1lculo web se reutilizar\00E1n utilizando la siguiente informaci\00F3n. Confirme la solicitud.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275776590025866162)
,p_name=>'APEX_WS_SETUP_MSG2'
,p_message_language=>'es'
,p_message_text=>unistr('Si prefiere crear los objetos de hoja de c\00E1lculo web en un esquema nuevo, utilice el asistente para <a href=%0>Solicitar Esquema de Base de Datos</a>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275776604658866162)
,p_name=>'APEX_WS_SETUP_MSG3'
,p_message_language=>'es'
,p_message_text=>unistr('Para ejecutar las hojas de c\00E1lculo web, se necesitan los siguientes objetos:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275776742099866162)
,p_name=>'APEX_WS_SETUP_MSG5'
,p_message_language=>'es'
,p_message_text=>unistr('Los objetos de base de datos de hojas de c\00E1lculo web se crear\00E1n utilizando la siguiente informaci\00F3n. Confirme la solicitud.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275776847352866162)
,p_name=>'APEX_WS_SETUP_MSG6'
,p_message_language=>'es'
,p_message_text=>'Tablas para Crear'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275776975409866162)
,p_name=>'APEX_WS_SETUP_MSG7'
,p_message_language=>'es'
,p_message_text=>unistr('Va a eliminar los objetos de base de datos de hojas de c\00E1lculo web. Borrar\00E1 los objetos de base de datos de hojas de c\00E1lculo web as\00ED como los datos internos que contienen los componentes de hojas web en su espacio de trabajo. \00BFDesea continuar?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275777213844866162)
,p_name=>'APEX_WS_SETUP_MSG8'
,p_message_language=>'es'
,p_message_text=>unistr('Es necesario corregir los siguientes objetos no v\00E1lidos para ejecutar las hojas web correctamente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276114116790866370)
,p_name=>'APEX_WS_SETUP_MSG9'
,p_message_language=>'es'
,p_message_text=>unistr('Va a eliminar las definiciones de hoja de c\00E1lculo web de este espacio de trabajo. Los objetos de base de datos de hoja de c\00E1lculo web los utilizan tambi\00E9n otros espacios de trabajo, por lo que no se borrar\00E1n. Se suprimir\00E1n los registros asociados a e')
||unistr('ste espacio de trabajo. \00BFDesea continuar?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275777344579866163)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre del Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275777408505866163)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275777074823866162)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_language=>'es'
,p_message_text=>'Esquema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276113945975866370)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_language=>'es'
,p_message_text=>'Objetos Existentes para Utilizar'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274905617527865604)
,p_name=>'API_PRECONDITION_VIOLATED'
,p_message_language=>'es'
,p_message_text=>unistr('Condici\00F3n previa de API violada')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275063985850865705)
,p_name=>'APP.SETTING.CANNOT.GET'
,p_message_language=>'es'
,p_message_text=>unistr('No se puede obtener el valor para el valor de aplicaci\00F3n %0 porque la opci\00F3n de creaci\00F3n asociada est\00E1 desactivada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275063832484865705)
,p_name=>'APP.SETTING.CANNOT.SET'
,p_message_language=>'es'
,p_message_text=>unistr('No se puede definir el valor para el valor de aplicaci\00F3n %0 porque la opci\00F3n de creaci\00F3n asociada est\00E1 desactivada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276140692437866387)
,p_name=>'APP.SETTING.INVALID.VALUE'
,p_message_language=>'es'
,p_message_text=>unistr('El valor %0 de configuraci\00F3n de la aplicaci\00F3n no es v\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276140519922866387)
,p_name=>'APP.SETTING.NOT.DEFINED'
,p_message_language=>'es'
,p_message_text=>unistr('El valor %0 de aplicaci\00F3n solicitado no est\00E1 definido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276140723617866387)
,p_name=>'APP.SETTING.VALUE.NOT.NULL'
,p_message_language=>'es'
,p_message_text=>unistr('El valor de aplicaci\00F3n %0 no se puede definir en un valor nulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274957057728865636)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_language=>'es'
,p_message_text=>unistr('C\00E1lculos de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274956985070865636)
,p_name=>'APPLICACTION_PROCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Procesos de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275522245397866005)
,p_name=>'APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275602457663866055)
,p_name=>'APPLICATION BUILDER'
,p_message_language=>'es'
,p_message_text=>'Creador de Aplicaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275426901072865940)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_language=>'es'
,p_message_text=>unistr('Condici\00F3n de C\00E1lculo de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275429641305865941)
,p_name=>'APPLICATION IMAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Imagen de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275427065528865940)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_language=>'es'
,p_message_text=>unistr('Condici\00F3n de Proceso de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275353763306865892)
,p_name=>'APPLICATIONS'
,p_message_language=>'es'
,p_message_text=>'aplicaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275499450622865990)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_language=>'es'
,p_message_text=>'Aplicaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275399764087865922)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_language=>'es'
,p_message_text=>'Actividad de Aplicaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275440262683865949)
,p_name=>'APPLICATION_ALIAS'
,p_message_language=>'es'
,p_message_text=>unistr('Alias de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275438296936865948)
,p_name=>'APPLICATION_DELETED'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha suprimido la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274888412666865593)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_language=>'es'
,p_message_text=>'Desarrollo de Aplicaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275439285319865948)
,p_name=>'APPLICATION_HELP'
,p_message_language=>'es'
,p_message_text=>unistr('Identifica la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275396311894865920)
,p_name=>'APPLICATION_ID'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275285635044865848)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_language=>'es'
,p_message_text=>unistr('El ID de aplicaci\00F3n est\00E1 reservado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275285516593865848)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_language=>'es'
,p_message_text=>unistr('El identificador de aplicaci\00F3n debe ser un n\00FAmero entero y positivo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275817722257866187)
,p_name=>'APPLICATION_IMAGES'
,p_message_language=>'es'
,p_message_text=>unistr('Im\00E1genes de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275469528059865972)
,p_name=>'APPLICATION_ITEM'
,p_message_language=>'es'
,p_message_text=>unistr('Elemento de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274986049232865654)
,p_name=>'APPLICATION_ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('Elementos de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274951419061865632)
,p_name=>'APPLICATION_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275440103876865949)
,p_name=>'APPLICATION_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de la Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276168723407866404)
,p_name=>'APPLICATION_NAMES'
,p_message_language=>'es'
,p_message_text=>unistr('Nombres de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275562543278866030)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_language=>'es'
,p_message_text=>unistr('ID de Sustituci\00F3n de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275437793993865947)
,p_name=>'APPLICATION_OWNER'
,p_message_language=>'es'
,p_message_text=>unistr('Propietario de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276168685430866404)
,p_name=>'APPLICATION_PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1ginas de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275074198113865712)
,p_name=>'APPLICATION_SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275437990720865947)
,p_name=>'APPLICATION_STATUS'
,p_message_language=>'es'
,p_message_text=>unistr('Estado de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275524213043866006)
,p_name=>'APPLICATION_VERSION'
,p_message_language=>'es'
,p_message_text=>unistr('Versi\00F3n de la Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274904050494865603)
,p_name=>'APPLICATION_X'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275383566238865912)
,p_name=>'APPROVED'
,p_message_language=>'es'
,p_message_text=>'Aprobado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275444432799865952)
,p_name=>'APP_SUCCESS_MSG'
,p_message_language=>'es'
,p_message_text=>unistr('La aplicaci\00F3n se ha creado correctamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276171389264866406)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n de Plantilla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274938497794865624)
,p_name=>'APP_TYPE_DATABASE'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n de Base de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274938524768865624)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n de ejemplo o de productividad')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275465955643865969)
,p_name=>'APP_TYPE_PACKAGED_WS'
,p_message_language=>'es'
,p_message_text=>unistr('Hoja de C\00E1lculo Web de Ejemplo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274938326260865624)
,p_name=>'APP_TYPE_WEBSHEET'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n de Hoja de C\00E1lculo Web')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275383010835865911)
,p_name=>'ARCHIVED'
,p_message_language=>'es'
,p_message_text=>'Archivado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274951700816865633)
,p_name=>'ARCHIVELOG'
,p_message_language=>'es'
,p_message_text=>'Archivado de Logs: Activado'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275202668059865795)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_language=>'es'
,p_message_text=>'Los Argumentos Deben Tener Total de Control'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275298468811865857)
,p_name=>'ARGUMENT_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre del Argumento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275298632233865857)
,p_name=>'ARGUMENT_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Argumento'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275376967258865907)
,p_name=>'ASAP'
,p_message_language=>'es'
,p_message_text=>'Lo antes Posible'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275373584470865905)
,p_name=>'ASSIGNED'
,p_message_language=>'es'
,p_message_text=>'Asignado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275071709436865710)
,p_name=>'ASSIGNEE'
,p_message_language=>'es'
,p_message_text=>'Persona asignada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276196293317866421)
,p_name=>'ASSIGN_LABEL'
,p_message_language=>'es'
,p_message_text=>'Asignar %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275132359845865750)
,p_name=>'ASSOCIATED'
,p_message_language=>'es'
,p_message_text=>'asociado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275073672707865712)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_language=>'es'
,p_message_text=>'Funciones Asociadas'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275404912968865925)
,p_name=>'ATTACHMENT'
,p_message_language=>'es'
,p_message_text=>'Adjunto'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276212687125866431)
,p_name=>'AT_RISK_LABEL'
,p_message_language=>'es'
,p_message_text=>'En Riesgo'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275102291827865730)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_language=>'es'
,p_message_text=>unistr('Va a migrar las opciones de autenticaci\00F3n personalizadas de esta aplicaci\00F3n a un esquema de autenticaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275101787661865730)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E9todo de Autenticaci\00F3n Actual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275102129657865730)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n de Autenticaci\00F3n Personalizada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275101886641865730)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina de Conexi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275102022240865730)
,p_name=>'AUTH.LOGIN_URL'
,p_message_language=>'es'
,p_message_text=>unistr('URL de Conexi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275101963233865730)
,p_name=>'AUTH.NONE'
,p_message_language=>'es'
,p_message_text=>'ninguno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275107345609865733)
,p_name=>'AUTHENTICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275427992512865940)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n de Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275427677419865940)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_language=>'es'
,p_message_text=>unistr('Esquema de Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275122426394865743)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_language=>'es'
,p_message_text=>unistr('Va a suprimir un esquema de autenticaci\00F3n de la aplicaci\00F3n %0. Si la aplicaci\00F3n no est\00E1 utilizando actualmente la autenticaci\00F3n de esquemas o si el esquema no es el esquema de autenticaci\00F3n actual, su supresi\00F3n no tendr\00E1 efecto en el funcionamiento d')
||unistr('e la aplicaci\00F3n. Si la aplicaci\00F3n est\00E1 utilizando la autenticaci\00F3n de esquemas y es el esquema de autenticaci\00F3n actual, la aplicaci\00F3n continuar\00E1 ejecut\00E1ndose con la autenticaci\00F3n de esquemas, pero con un esquema de autenticaci\00F3n por defecto. Utilizar')
||unistr('\00E1 una p\00E1gina de conexi\00F3n incorporada con la verificaci\00F3n de credenciales de "puertas abiertas" (es decir, todos los usuarios podr\00E1n ejecutar la aplicaci\00F3n). ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275124343650865744)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_language=>'es'
,p_message_text=>unistr('Haga clic en el bot\00F3n Actualizar para que la aplicaci\00F3n utilice este esquema de autenticaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275632251000866073)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_language=>'es'
,p_message_text=>'Cuentas de Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274885062284865590)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'es'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275632346783866073)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_language=>'es'
,p_message_text=>'Personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275632617018866073)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_language=>'es'
,p_message_text=>unistr('Sin Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275632483105866073)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_language=>'es'
,p_message_text=>'Cuentas de Base de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276065667644866340)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_language=>'es'
,p_message_text=>'Variable de Cabecera HTTP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275632827760866073)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_language=>'es'
,p_message_text=>'Oracle Application Server Single Sign-On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275632552893866073)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_language=>'es'
,p_message_text=>'Directorio LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275632704874866073)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_language=>'es'
,p_message_text=>'Credenciales de Puertas Abiertas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274875256399865584)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_language=>'es'
,p_message_text=>unistr('Conexi\00F3n de SAML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274913777881865609)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_language=>'es'
,p_message_text=>unistr('Inicio de sesi\00F3n en medios sociales')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275470627827865972)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_language=>'es'
,p_message_text=>unistr('Esquema de Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275427556418865940)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_language=>'es'
,p_message_text=>unistr('Esquema de Autorizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274885135929865591)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'es'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274904242375865603)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_language=>'es'
,p_message_text=>'Consulta SQL Exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274904348763865603)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n PL/SQL que Devuelve Valor Booleano')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275281461528865845)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_language=>'es'
,p_message_text=>unistr('Est\00E1 en rol o en grupo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275281562537865846)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_language=>'es'
,p_message_text=>unistr('No est\00E1 en rol ni en grupo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274904408032865603)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_language=>'es'
,p_message_text=>unistr('Valor de Elemento en Expresi\00F3n 1 Equivale a Expresi\00F3n 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274904541618865603)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_language=>'es'
,p_message_text=>unistr('Elemento en Expresi\00F3n 1 No Nulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274904646069865603)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_language=>'es'
,p_message_text=>unistr('Elemento en Expresi\00F3n 1 Nulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274904702023865603)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_language=>'es'
,p_message_text=>unistr('Valor de Elemento en Expresi\00F3n 1 No Equivale a Expresi\00F3n 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274904890385865603)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'Consulta SQL NOT Exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274904953194865603)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_language=>'es'
,p_message_text=>unistr('Valor de Preferencia en Expresi\00F3n 1 Equivale a Expresi\00F3n 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274905092007865603)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_language=>'es'
,p_message_text=>unistr('Valor de Preferencia en Expresi\00F3n 1 No Equivale a Expresi\00F3n 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274970099285865644)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_language=>'es'
,p_message_text=>unistr('Evaluar para cada vista de p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274970150798865644)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_language=>'es'
,p_message_text=>unistr('Evaluar una vez por sesi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274907420739865605)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_language=>'es'
,p_message_text=>'Cuenta Vencida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274907349001865605)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_language=>'es'
,p_message_text=>'Cuenta Bloqueada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274907753694865605)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_language=>'es'
,p_message_text=>unistr('Se han excedido los intentos de conexi\00F3n m\00E1ximos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274907820068865605)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_language=>'es'
,p_message_text=>'Error interno desconocido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274907633957865605)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_language=>'es'
,p_message_text=>unistr('Primer Uso de Contrase\00F1a')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274907504101865605)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_language=>'es'
,p_message_text=>unistr('Contrase\00F1a Incorrecta')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274907104857865604)
,p_name=>'AUTH_SUCCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Autenticaci\00F3n normal correcta')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274907254764865605)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_language=>'es'
,p_message_text=>'Nombre de Usuario Desconocido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275022024729865677)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_language=>'es'
,p_message_text=>'Nombre de espacio de trabajo desconocido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275032532673865684)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_language=>'es'
,p_message_text=>'Nombre de espacio de trabajo desconocido: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275176363829865778)
,p_name=>'AUTOCOMMIT'
,p_message_language=>'es'
,p_message_text=>unistr('La sentencia de confirmaci\00F3n no es aplicable. Todas las sentencias se confirman autom\00E1ticamente.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275500038559865991)
,p_name=>'AUTOPROVISION_MODE'
,p_message_language=>'es'
,p_message_text=>'Modo de Provisionamiento'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274882781600865589)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_language=>'es'
,p_message_text=>'Primer Elemento'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275525927339866007)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_language=>'es'
,p_message_text=>'Disponibilidad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274912323245865608)
,p_name=>'AVAILABLE'
,p_message_language=>'es'
,p_message_text=>'Disponible'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275729673801866133)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_language=>'es'
,p_message_text=>unistr('Disponible S\00F3lo para Desarrolladores')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275729568227866133)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_language=>'es'
,p_message_text=>'Disponible con Barra de Herramientas de Desarrollador'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275400596371865922)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_language=>'es'
,p_message_text=>unistr('Tiempo Medio de Presentaci\00F3n (segundos)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274970802475865645)
,p_name=>'BACK'
,p_message_language=>'es'
,p_message_text=>unistr('Atr\00E1s')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275381450910865910)
,p_name=>'BAR_CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1fico de Barras')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275803116844866178)
,p_name=>'BASIC'
,p_message_language=>'es'
,p_message_text=>unistr('B\00E1sico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274926107080865616)
,p_name=>'BASIC_DEVELOPER'
,p_message_language=>'es'
,p_message_text=>unistr('Desarrollador B\00E1sico')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275360759225865897)
,p_name=>'BEFORE'
,p_message_language=>'es'
,p_message_text=>'Antes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276174014048866408)
,p_name=>'BEFORE LIST ENTRY'
,p_message_language=>'es'
,p_message_text=>'Antes de Entrada de Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276194968490866421)
,p_name=>'BEFORE_FIRST'
,p_message_language=>'es'
,p_message_text=>'Antes de la Primera'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275430810971865942)
,p_name=>'BIND_LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta Ligada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275430108574865942)
,p_name=>'BIND_VARIABLE'
,p_message_language=>'es'
,p_message_text=>'Variable de Enlace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275430203805865942)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta de Variable de Enlace'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275446016344865954)
,p_name=>'BLACK_TEXT'
,p_message_language=>'es'
,p_message_text=>'Texto Negro'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274889549285865593)
,p_name=>'BLANK'
,p_message_language=>'es'
,p_message_text=>'En Blanco'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275404165741865925)
,p_name=>'BLOB_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275564215310866031)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_language=>'es'
,p_message_text=>'Descargar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274941203289865626)
,p_name=>'BLOB_FORMAT'
,p_message_language=>'es'
,p_message_text=>'Formato Blob'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275564664596866031)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_language=>'es'
,p_message_text=>'Adjunto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275564366171866031)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_language=>'es'
,p_message_text=>'DOWNLOAD'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275564472241866031)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_language=>'es'
,p_message_text=>'IMAGE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275564577392866031)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_language=>'es'
,p_message_text=>unistr('En L\00EDnea')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275405174097865925)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_language=>'es'
,p_message_text=>'Formato BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275404611232865925)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltima Columna BLOB Actualizada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275404087029865925)
,p_name=>'BLOB_TABLE'
,p_message_language=>'es'
,p_message_text=>'Tabla BLOB'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275445913203865953)
,p_name=>'BLUE_TEXT'
,p_message_language=>'es'
,p_message_text=>'Texto Azul'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275421168881865936)
,p_name=>'BRANCH CONDITION'
,p_message_language=>'es'
,p_message_text=>unistr('Condici\00F3n de Bifurcaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274974498873865647)
,p_name=>'BRANCHES'
,p_message_language=>'es'
,p_message_text=>'Bifurcaciones'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275198545751865792)
,p_name=>'BREADCRUMB'
,p_message_language=>'es'
,p_message_text=>unistr('Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275361492841865897)
,p_name=>'BREADCRUMB LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Etiqueta de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275361501455865897)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre Completo de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275198606914865792)
,p_name=>'BREADCRUMBS'
,p_message_language=>'es'
,p_message_text=>unistr('Rutas de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275454560285865960)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_language=>'es'
,p_message_text=>unistr('Entrada de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275469720887865972)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Entrada de Ruta de Navegaci\00F3n: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275285891566865848)
,p_name=>'BREADCRUMB_PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1ginas de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275369607776865903)
,p_name=>'BREADCRUMB_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Regi\00F3n de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275034836000865685)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_language=>'es'
,p_message_text=>unistr('La ruta de navegaci\00F3n se ha creado correctamente.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275364004330865899)
,p_name=>'BROWSE_ICON'
,p_message_language=>'es'
,p_message_text=>'Icono Examinar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275363850101865899)
,p_name=>'BROWSE_PACKAGE'
,p_message_language=>'es'
,p_message_text=>'Examinar Paquete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275298156986865856)
,p_name=>'BROWSE_TABLE'
,p_message_language=>'es'
,p_message_text=>'Examinar Tabla'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274892877775865595)
,p_name=>'BUFFER CACHE'
,p_message_language=>'es'
,p_message_text=>unistr('Cach\00E9 de Buffers')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275377461351865908)
,p_name=>'BUG'
,p_message_language=>'es'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275401628547865923)
,p_name=>'BUGS'
,p_message_language=>'es'
,p_message_text=>'Bugs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275424128596865938)
,p_name=>'BUGS_ASSIGNED'
,p_message_language=>'es'
,p_message_text=>'bugs asignados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275463327195865967)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_language=>'es'
,p_message_text=>'Bugs Asignados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274921419976865613)
,p_name=>'BUGS_CLOSED'
,p_message_language=>'es'
,p_message_text=>'Bugs Cerrados (%0 / %1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275838849797866200)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_language=>'es'
,p_message_text=>'Porcentaje de bugs cerrados (%0/%1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275463448526865967)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_language=>'es'
,p_message_text=>'Bugs No Asignados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275463590506865967)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_language=>'es'
,p_message_text=>unistr('Ninguna Correcci\00F3n por Fechas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275839275362866201)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_language=>'es'
,p_message_text=>'Bugs: %1 de %0 cerrados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276203181079866426)
,p_name=>'BUG_LABEL'
,p_message_language=>'es'
,p_message_text=>'Bug: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275417411395865933)
,p_name=>'BUILD QUERY'
,p_message_language=>'es'
,p_message_text=>'Crear Consulta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274884623639865590)
,p_name=>'BUILDER'
,p_message_language=>'es'
,p_message_text=>'Creador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275523441854866006)
,p_name=>'BUILDER.PLUGINS'
,p_message_language=>'es'
,p_message_text=>'Plugins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275518930583866003)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_language=>'es'
,p_message_text=>'[No Soportado]'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275813668323866185)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_language=>'es'
,p_message_text=>'Mensaje de Espacio de Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275114678294865738)
,p_name=>'BUILD_OPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Opci\00F3n de Creaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275587887444866045)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Opci\00F3n de Creaci\00F3n: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276201872369866425)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Estado de Creaci\00F3n: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275588758540866046)
,p_name=>'BUILD_VERSION'
,p_message_language=>'es'
,p_message_text=>unistr('Versi\00F3n Interna')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275456916692865962)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla de Informe Incorporada'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275359980765865896)
,p_name=>'BUTTON'
,p_message_language=>'es'
,p_message_text=>unistr('bot\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275360694917865897)
,p_name=>'BUTTON LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Etiqueta de Bot\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275565909227866032)
,p_name=>'BUTTON.ADD'
,p_message_language=>'es'
,p_message_text=>'Agregar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274901290658865601)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_language=>'es'
,p_message_text=>unistr('Los atributos de bot\00F3n del bot\00F3n seleccionado no deben contener un identificador')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274901103381865601)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_language=>'es'
,p_message_text=>unistr('El bot\00F3n seleccionado debe ser un bot\00F3n con una acci\00F3n definida por acci\00F3n din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274901440208865601)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_language=>'es'
,p_message_text=>unistr('El bot\00F3n seleccionado utiliza una plantilla de bot\00F3n que no contiene la cadena de sustituci\00F3n #BUTTON_ID#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275565780062866032)
,p_name=>'BUTTON.DELETE'
,p_message_language=>'es'
,p_message_text=>'Suprimir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274974730965865647)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe especificar la p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274950934187865632)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_language=>'es'
,p_message_text=>'Se debe especificar la consulta del informe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274938132984865624)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe especificar una solicitud de bot\00F3n para todos los tipos de origen de solicitud de bot\00F3n a menos que Tipo de Origen de Solicitud de Bot\00F3n est\00E9 definido en "Siempre Nulo".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274938885301865624)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe especificar el tipo de origen de solicitud de bot\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274974820794865647)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_language=>'es'
,p_message_text=>'Se debe especificar el destino de URL.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274903774395865602)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_language=>'es'
,p_message_text=>unistr('Si la acci\00F3n es ''Definida por Acci\00F3n Din\00E1mica'', los atributos de bot\00F3n no deben contener un identificador')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274976421260865648)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_language=>'es'
,p_message_text=>'Se debe especificar la imagen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274976582880865648)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_language=>'es'
,p_message_text=>'Se debe especificar el estilo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274976371385865648)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Se debe especificar la plantilla.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274903612204865602)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_language=>'es'
,p_message_text=>unistr('Si el estilo del bot\00F3n es ''Bot\00F3n Basado en Plantilla'' y la acci\00F3n es ''Definida por Acci\00F3n Din\00E1mica'', la plantilla de bot\00F3n seleccionada debe contener la cadena de sustituci\00F3n #BUTTON_ID#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274891278358865594)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_language=>'es'
,p_message_text=>unistr('No se puede suprimir el bot\00F3n porque se hace referencia al mismo en una acci\00F3n din\00E1mica (P\00E1gina: %0, Acci\00F3n Din\00E1mica: ''%1'', Acci\00F3n: ''2%'', Atributo: ''Elemento Afectado'').')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274891189677865594)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_language=>'es'
,p_message_text=>unistr('No se puede suprimir el bot\00F3n porque se hace referencia al mismo en una acci\00F3n din\00E1mica (P\00E1gina: %0, Acci\00F3n Din\00E1mica: ''%1'', Atributo: ''Cuando'').')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275565893030866032)
,p_name=>'BUTTON.SUBMIT'
,p_message_language=>'es'
,p_message_text=>'Ejecutar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275561706917866029)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_language=>'es'
,p_message_text=>'Para utilizar en un atributo "onclick"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275565216355866031)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_language=>'es'
,p_message_text=>'Para utilizar en un atributo "href"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274974680753865647)
,p_name=>'BUTTONS'
,p_message_language=>'es'
,p_message_text=>'Botones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275431369596865942)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_language=>'es'
,p_message_text=>unistr('Atributos de Bot\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274883533394865590)
,p_name=>'BUTTON_CSS_CLASSES'
,p_message_language=>'es'
,p_message_text=>unistr('Clases CSS de Bot\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275082091151865717)
,p_name=>'BUTTON_ID'
,p_message_language=>'es'
,p_message_text=>unistr('El identificador de bot\00F3n generado ser\00E1 el identificador est\00E1tico del bot\00F3n, si se ha definido, o de lo contrario ser\00E1 un identificador generado de forma interna con el formato ''B'' || [Identificador de Bot\00F3n Interno]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276201618411866425)
,p_name=>'BUTTON_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Bot\00F3n: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275436551599865946)
,p_name=>'BUTTON_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla de Bot\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274971559998865645)
,p_name=>'BYTES'
,p_message_language=>'es'
,p_message_text=>'bytes'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275377016131865907)
,p_name=>'BY_NEXT_PATCH'
,p_message_language=>'es'
,p_message_text=>'Para el Siguiente Parche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275377141829865907)
,p_name=>'BY_NEXT_RELEASE'
,p_message_language=>'es'
,p_message_text=>unistr('Para la Siguiente Versi\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276301092643866488)
,p_name=>'CA.ABOUT'
,p_message_language=>'es'
,p_message_text=>'Acerca de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276267391896866466)
,p_name=>'CA.ABOUT.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Acerca de la P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276267294953866466)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Incluya una p\00E1gina Acerca de esta aplicaci\00F3n, que incorpore una descripci\00F3n de la aplicaci\00F3n, la versi\00F3n de la aplicaci\00F3n y un recuento de p\00E1ginas.'),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275092161302865724)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_language=>'es'
,p_message_text=>'Contenedor de contenido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276301230750866488)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Acerca de la P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276301313822866488)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('El texto sobre esta aplicaci\00F3n se puede colocar aqu\00ED.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276300939122866488)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Acerca de esta p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276313215846866495)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_language=>'es'
,p_message_text=>unistr('Acerca de esta versi\00F3n de vista previa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276267679754866466)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_language=>'es'
,p_message_text=>'Control de Acceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276303552877866489)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_language=>'es'
,p_message_text=>'Acciones de control de acceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276293024313866483)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de control de acceso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276266035965866465)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Activar autorizaci\00F3n de usuarios basada en roles')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276267712844866467)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Incorpora la autenticaci\00F3n de usuarios basada en roles en la aplicaci\00F3n.'),
'Los usuarios se pueden definir como administradores, contribuyentes o lectores.',
unistr('A continuaci\00F3n, puede definir f\00E1cilmente un acceso diferente a distintos roles para los distintos componentes de la aplicaci\00F3n, como p\00E1ginas, entradas de men\00FA, regiones, columnas, elementos, botones, etc.</p>'),
'<p>Incluye los siguientes componentes:',
'<ul>',
unistr('<li>Regi\00F3n de p\00E1gina administrativa con enlaces para acceder a las funciones de control</li>'),
'<li>Tabla de usuarios para gestionar el control de acceso</li>',
unistr('<li>P\00E1gina de configuraci\00F3n para definir el nivel de acceso de los usuarios autenticados</li>'),
unistr('<li>P\00E1gina de configuraci\00F3n para especificar si los nombres de usuario son direcciones de correo electr\00F3nico o no</li>'),
unistr('<li>P\00E1gina de gesti\00F3n de acceso de usuarios para generar informes y editar el acceso del usuario</li>'),
unistr('<li>P\00E1gina de adici\00F3n de usuarios con capacidad de agregar un solo usuario</li>'),
unistr('<li>P\00E1gina de adici\00F3n de varios usuarios con capacidad de agregar varios usuarios (solo nombres de usuario de correo electr\00F3nico)</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276291978216866482)
,p_name=>'CA.ACCESS.ROLE'
,p_message_language=>'es'
,p_message_text=>'Rol'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276292636001866482)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_language=>'es'
,p_message_text=>'ID de rol de acceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275011508709865670)
,p_name=>'CA.ACCESS.ROLES'
,p_message_language=>'es'
,p_message_text=>'Roles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276292064661866482)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_language=>'es'
,p_message_text=>'Cuenta Bloqueada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275039326355865688)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_language=>'es'
,p_message_text=>'Confirmado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276303347734866489)
,p_name=>'CA.ACL.INFORMATION'
,p_message_language=>'es'
,p_message_text=>unistr('Informaci\00F3n de ACL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276304088652866490)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_language=>'es'
,p_message_text=>'Privilegios insuficientes. El usuario no es administrador.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276304135899866490)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_language=>'es'
,p_message_text=>unistr('No tiene autorizaci\00F3n para ver esta aplicaci\00F3n porque no le han otorgado acceso o porque su cuenta se ha bloqueado. P\00F3ngase en contacto con el administrador de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276304266810866490)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_language=>'es'
,p_message_text=>'Privilegios insuficientes. El usuario no es contribuyente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276293704398866483)
,p_name=>'CA.ACL.SAVED'
,p_message_language=>'es'
,p_message_text=>unistr('La configuraci\00F3n de control de acceso se ha guardado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276298416023866486)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_language=>'es'
,p_message_text=>unistr('HTML de bot\00F3n de acci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276297345504866485)
,p_name=>'CA.ACTION.LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Etiqueta de acci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276297468334866485)
,p_name=>'CA.ACTION.LINK'
,p_message_language=>'es'
,p_message_text=>unistr('Enlace de Acci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276300005033866487)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_language=>'es'
,p_message_text=>unistr('HTML de enlace de acci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276285557488866478)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_language=>'es'
,p_message_text=>unistr('Acci\00F3n procesada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276291059715866481)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_language=>'es'
,p_message_text=>'Actividad por Hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276325358300866503)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_language=>'es'
,p_message_text=>'Panel de Control de Actividad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276267876585866467)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_language=>'es'
,p_message_text=>unistr('Generaci\00F3n de informes de actividades')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276267062524866466)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_language=>'es'
,p_message_text=>'Incluir informes de errores y actividad del usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276267933325866467)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Incluya una gran cantidad de informes sobre la actividad del usuario final para la aplicaci\00F3n. Con el fin de comprender mejor c\00F3mo se est\00E1 utilizando la aplicaci\00F3n y las \00E1reas de mejora, determine los usuarios m\00E1s activos, las p\00E1ginas m\00E1s utilizad')
||unistr('as, el rendimiento de las p\00E1ginas y los errores producidos.</p>'),
'<p>Incluye los siguientes componentes:',
'<ul>',
'<li>Informe de usuarios principales</li>',
unistr('<li>Informe de log de errores de la aplicaci\00F3n</li>'),
unistr('<li>Rendimiento de p\00E1gina, actividad y rendimiento por p\00E1gina</li>'),
unistr('<li>Informe de actividad de la aplicaci\00F3n por p\00E1gina</li>'),
unistr('<li>Informe de detalle de vistas de p\00E1gina</li>'),
'',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275413764988865931)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_language=>'es'
,p_message_text=>'Fecha de Inicio Real'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276303272203866489)
,p_name=>'CA.ADD'
,p_message_language=>'es'
,p_message_text=>'Agregar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276298669503866486)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar Plantilla de Correo Electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276316287153866497)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_language=>'es'
,p_message_text=>'Agregar varios usuarios: paso 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276301570419866488)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_language=>'es'
,p_message_text=>'Agregar nuevo %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276284524539866477)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar Notificaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276157076825866397)
,p_name=>'CA.ADD.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276292749222866483)
,p_name=>'CA.ADD.USER'
,p_message_language=>'es'
,p_message_text=>'Agregar Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276316665159866497)
,p_name=>'CA.ADD.USERS'
,p_message_language=>'es'
,p_message_text=>'Agregar usuarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276269423611866468)
,p_name=>'CA.ADDING.PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('Adici\00F3n de p\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276269918043866468)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Haga clic en <strong>Agregar p\00E1gina</strong> para agregar una p\00E1gina a la aplicaci\00F3n. A continuaci\00F3n, seleccione un tipo de p\00E1gina (como en blanco, gr\00E1fico, formulario, informe, etc.) y defina sus atributos. Tambi\00E9n puede que necesite especificar ')
||unistr('una tabla o vista v\00E1lidas, o utilizar Taller de SQL para preparar los objetos de base de datos en su espacio de trabajo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276299417151866487)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_language=>'es'
,p_message_text=>'Avanzada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275413042357865931)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_language=>'es'
,p_message_text=>unistr('Informaci\00F3n Adicional')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276292428651866482)
,p_name=>'CA.ADDRESS'
,p_message_language=>'es'
,p_message_text=>unistr('Direcci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276272665279866470)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_language=>'es'
,p_message_text=>'Control de Acceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276273203116866470)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Definir nivel de acceso para los usuarios autenticados de esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276271783828866469)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_language=>'es'
,p_message_text=>'Informes de Actividades'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276272701346866470)
,p_name=>'CA.ADMIN.ADD'
,p_message_language=>'es'
,p_message_text=>'Agregar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276274409690866471)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_language=>'es'
,p_message_text=>unistr('Administraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276273175395866470)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_language=>'es'
,p_message_text=>'Administradores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275448787259865956)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de la Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275559490091866028)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_language=>'es'
,p_message_text=>'Interfaz de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276308068815866492)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_language=>'es'
,p_message_text=>unistr('Administraci\00F3n de Aplicaciones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276308169888866492)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_language=>'es'
,p_message_text=>'Gestionar componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276271341754866469)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_language=>'es'
,p_message_text=>unistr('Selecci\00F3n de estilo de tema')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276271483819866469)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Definir la interfaz de usuario por defecto de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276271027428866469)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_language=>'es'
,p_message_text=>unistr('Opciones de Configuraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276270945005866469)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Activar o desactivar funciones de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276272087116866469)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_language=>'es'
,p_message_text=>unistr('Log de errores de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276272116281866469)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Informe de errores registrados por esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276271584998866469)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276271645056866469)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Definir nombre y descripci\00F3n breve de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276271194076866469)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_language=>'es'
,p_message_text=>unistr('Actualizaciones de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276271286645866469)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Mantener la lista de actualizaciones de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276270653705866468)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276273073050866470)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_language=>'es'
,p_message_text=>'Contribuyentes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276324107556866502)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_language=>'es'
,p_message_text=>'Panel de Control'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276324048204866502)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Ver m\00E9tricas de actividad de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276276112548866472)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_language=>'es'
,p_message_text=>'Zona Horaria por Defecto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276276237996866472)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Definir la zona horaria por defecto para esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276273946606866471)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Correo Electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276276313229866472)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276276495040866472)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Definir si el correo electr\00F3nico se debe enviar y, en ese caso, cu\00E1l debe ser el destinario de la respuesta')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276273423252866470)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_language=>'es'
,p_message_text=>'Comentarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276273773138866470)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de los comentarios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276273855548866470)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Permite gestionar la posibilidad de inclusi\00F3n de datos adjuntos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276273568517866470)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_language=>'es'
,p_message_text=>'Comentarios del usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276273661881866470)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Informe de todos los comentarios enviados por los usuarios de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276274080391866471)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_language=>'es'
,p_message_text=>unistr('Plantillas de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276274187095866471)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Gestionar HTML y CSS de plantilla de correo electr\00F3nico utilizados por esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276270758445866469)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_language=>'es'
,p_message_text=>'Notificaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276270879598866469)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Mostrar notificaciones en la p\00E1gina inicial')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276308717872866492)
,p_name=>'CA.ADMIN.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina de Administraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276272298438866469)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_language=>'es'
,p_message_text=>unistr('Rendimiento de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276272368151866470)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Informe de actividad y rendimiento por p\00E1gina de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276272491405866470)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_language=>'es'
,p_message_text=>unistr('Vistas de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276272546198866470)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Informe de cada vista de p\00E1gina por usuario, incluida la fecha de acceso y el tiempo transcurrido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276272975571866470)
,p_name=>'CA.ADMIN.READERS'
,p_message_language=>'es'
,p_message_text=>'Lectores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276317346763866498)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Enviar Correo Electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276317406249866498)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Enviar correo electr\00F3nico basado en plantilla desde esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276271837606866469)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_language=>'es'
,p_message_text=>'Usuarios Principales'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276271982085866469)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Informe de vistas de p\00E1gina agregadas por usuarios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276272812137866470)
,p_name=>'CA.ADMIN.USERS'
,p_message_language=>'es'
,p_message_text=>'Usuarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276273391027866470)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Cambiar configuraci\00F3n de control de acceso y desactivar control de acceso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276274278027866471)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_language=>'es'
,p_message_text=>unistr('Log de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276274360955866471)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Ver log de correos electr\00F3nicos enviados por esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275195302216865790)
,p_name=>'CA.ADVANCED'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Avanzado</strong>: ampl\00EDe para ver las opciones avanzadas.'),
'    <ul>',
unistr('      <li><strong>Definir como p\00E1gina inicial</strong>: convierta esta p\00E1gina en la p\00E1gina inicial de la aplicaci\00F3n.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;Las p\00E1ginas previamente definidas como p\00E1gina inicial se actualizar\00E1n.</li>'),
unistr('      <li><strong>Definir como p\00E1gina de administraci\00F3n</strong>: agregue esta p\00E1gina a Administraci\00F3n en lugar de a una p\00E1gina normal de la aplicaci\00F3n. Acceda haciendo clic en Administraci\00F3n en el men\00FA principal y seleccion\00E1ndola a continuaci\00F3n en l')
||unistr('a lista Administraci\00F3n de aplicaciones.<br>'),
unistr('        <em><strong>Nota:</strong>: Una p\00E1gina no puede actuar al mismo tiempo como p\00E1gina inicial y p\00E1gina de Administraci\00F3n.</em></li>'),
'      &nbsp;<br>',
unistr('      <li><strong>Ayuda de p\00E1gina</strong>: introduzca el texto que se debe agregar al texto de ayuda de la p\00E1gina.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275065619786865707)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Avanzado</strong>: ampl\00EDe para ver las opciones avanzadas.'),
'    <ul>',
unistr('      <li><strong>Ayuda de p\00E1gina</strong>: introduzca el texto que se agregar\00E1 al texto de ayuda de la p\00E1gina.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276309165919866493)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n avanzada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276309261070866493)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Defina la definici\00F3n adicional y la configuraci\00F3n de globalizaci\00F3n y seguridad. Esta configuraci\00F3n se puede aplicar al crear la aplicaci\00F3n y tambi\00E9n se puede editar despu\00E9s de crear la aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276312224797866495)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Para obtener m\00E1s informaci\00F3n, consulte el tema de ayuda ( <span class="fa fa-question-circle" aria-hidden="true"></span> ) para cada configuraci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276318078520866498)
,p_name=>'CA.AFTER.ROWS'
,p_message_language=>'es'
,p_message_text=>unistr('Despu\00E9s de Filas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276298352021866486)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_language=>'es'
,p_message_text=>unistr('HTML despu\00E9s de filas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276301494668866488)
,p_name=>'CA.ALL.COLS'
,p_message_language=>'es'
,p_message_text=>'Todas las Columnas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276297513986866485)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_language=>'es'
,p_message_text=>unistr('Permitir exclusi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275406664892865926)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_language=>'es'
,p_message_text=>'Permitir ejecuciones en modo restringido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276290922562866481)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_language=>'es'
,p_message_text=>unistr('Log de errores de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276286887046866479)
,p_name=>'CA.APP.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de la Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275459637848865964)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Est\00E9 o no activado el control de acceso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275459742630865964)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Nivel de acceso por defecto proporcionado a miembros autenticados que no est\00E1n en la lista de control de acceso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276287240783866479)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_language=>'es'
,p_message_text=>unistr('La configuraci\00F3n de la aplicaci\00F3n se ha actualizado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276287006384866479)
,p_name=>'CA.APP.SUBTITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Descripci\00F3n Breve')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276287169747866479)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_language=>'es'
,p_message_text=>unistr('El texto que se introduzca aqu\00ED aparece bajo el nombre de la aplicaci\00F3n en la p\00E1gina inicial de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276276535123866472)
,p_name=>'CA.APPEARANCE'
,p_message_language=>'es'
,p_message_text=>'Apariencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276276652245866472)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Defina el esquema de color (estilo de tema) de la aplicaci\00F3n por defecto, d\00F3nde se encuentra la navegaci\00F3n y el icono utilizado para la aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276296055133866485)
,p_name=>'CA.APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276283146840866477)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_language=>'es'
,p_message_text=>unistr('Apariencia de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276277188434866473)
,p_name=>'CA.APPLICATION.ICON'
,p_message_language=>'es'
,p_message_text=>unistr('Icono de la Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276277218315866473)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Haga clic en <strong>Seleccionar icono nuevo</strong> para seleccionar el color del icono y uno de los iconos disponibles. Su selecci\00F3n se muestra en la p\00E1gina inicial de la aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276277541982866473)
,p_name=>'CA.APPLICATION.ID'
,p_message_language=>'es'
,p_message_text=>unistr('Identificador de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276277602146866473)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Introduzca un identificador num\00E9rico \00FAnico para la aplicaci\00F3n. Este campo contiene un identificador generado autom\00E1ticamente por defecto.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276296665848866485)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276288874854866480)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_language=>'es'
,p_message_text=>'Sesiones de Aplicaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276267467588866466)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276266375667866466)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Definir nombre y descripci\00F3n breve de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276267527210866466)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite a los administradores de la aplicaci\00F3n actualizar varios valores, como el nombre y una descripci\00F3n de la aplicaci\00F3n, la zona horaria por defecto, entre otros.</p>'),
'<p>Incluye los siguientes componentes:',
'<ul>',
unistr('<li>Pantalla y entrada de lista de p\00E1ginas administrativas</li>'),
unistr('<li>Capacidad de definir el nombre de la aplicaci\00F3n</li>'),
unistr('<li>Capacidad de definir el subt\00EDtulo de la regi\00F3n h\00E9roe de la p\00E1gina inicial</li>'),
'<li>Capacidad de definir los destinatarios de los comentarios si se usan comentarios</li>',
unistr('<li>Capacidad de definir la zona horaria por defecto de la aplicaci\00F3n</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276323106234866501)
,p_name=>'CA.APPLICATIONITEM'
,p_message_language=>'es'
,p_message_text=>unistr('Elemento de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276324979997866503)
,p_name=>'CA.APPLY'
,p_message_language=>'es'
,p_message_text=>'Aplicar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276326786443866504)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n de valores por defecto de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276282374983866476)
,p_name=>'CA.APPLY.CHANGES'
,p_message_language=>'es'
,p_message_text=>'Aplicar Cambios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276324717175866502)
,p_name=>'CA.APPLY.FILTERS'
,p_message_language=>'es'
,p_message_text=>'Aplicar Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275557383050866027)
,p_name=>'CA.APP_BANNER'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n creada desde el asistente de creaci\00F3n de aplicaciones %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275558665276866027)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_language=>'es'
,p_message_text=>unistr('Guardar configuraci\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276328921810866505)
,p_name=>'CA.ATTACHMENT'
,p_message_language=>'es'
,p_message_text=>'Adjunto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275273053325865840)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_language=>'es'
,p_message_text=>'Recuento de anexos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276329070164866505)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre del Anexo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275272966421865840)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('Tama\00F1o de anexo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276325008632866503)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_language=>'es'
,p_message_text=>unistr('Los atributos por defecto ya est\00E1n definidos para este %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276293138488866483)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Cualquier usuario autenticado puede acceder a esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276278342124866473)
,p_name=>'CA.AUTHENTICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276278485556866473)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Seleccione la forma en la que desea que los usuarios se autentiquen en la aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275409350446865928)
,p_name=>'CA.AUTO.DROP'
,p_message_language=>'es'
,p_message_text=>unistr('Borrado Autom\00E1tico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276289510937866481)
,p_name=>'CA.AVG.ELAPSED'
,p_message_language=>'es'
,p_message_text=>'Tiempo Medio Transcurrido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275456703285865962)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_language=>'es'
,p_message_text=>'Volver a Informe de trabajos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275273728494865840)
,p_name=>'CA.BCC'
,p_message_language=>'es'
,p_message_text=>'CCO'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276317979603866498)
,p_name=>'CA.BEFORE.ROWS'
,p_message_language=>'es'
,p_message_text=>'Antes de Filas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276298232362866486)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_language=>'es'
,p_message_text=>'HTML antes de filas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276299751942866487)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Contenido antes de filas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276275010338866471)
,p_name=>'CA.BLANK'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar p\00E1gina en blanco')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276275127981866471)
,p_name=>'CA.BLANK.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cree una p\00E1gina en blanco que act\00FAe como marcador de posici\00F3n. Cuando haya creado la aplicaci\00F3n, podr\00E1 crear regiones en la p\00E1gina desde el Dise\00F1ador de p\00E1ginas f\00E1cilmente.</p>'),
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre de la p\00E1gina</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione un icono para que se muestre en el men\00FA de navegaci\00F3n de la p\00E1gina.</li>'),
unistr('<!--  <li><strong>Incluir navegaci\00F3n de p\00E1gina</strong>: active esta opci\00F3n para mostrar una lista de tarjetas del resto de p\00E1ginas definidas de su aplicaci\00F3n.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;Normalmente, esta opci\00F3n se utiliza en la p\00E1gina inicial de la aplicaci\00F3n.</li>'),
'-->',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276308458895866492)
,p_name=>'CA.BLUEPRINT'
,p_message_language=>'es'
,p_message_text=>unistr('Plan detallado de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276308573140866492)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>El plan detallado muestra la definici\00F3n de la aplicaci\00F3n en formato JSON.</p>'),
unistr('<p>Al acceder a esta pantalla por primera vez, la definici\00F3n de la aplicaci\00F3n actual se transforma en un documento JSON. Puede editar el documento para actualizar las propiedades de la aplicaci\00F3n y, a continuaci\00F3n, hacer clic en <strong>Aplicar plan ')
||unistr('detallado</strong> para cambiar los detalles actuales de la aplicaci\00F3n.</p>'),
'<p>&nbsp;</p>',
unistr('<p>Si necesita crear un gran n\00FAmero de p\00E1ginas similares, copiar el c\00F3digo JSON relevante para una p\00E1gina y pegarlo varias veces, adem\00E1s de realizar peque\00F1os ajustes a JSON es significativamente m\00E1s r\00E1pido que utilizar manualmente <strong>Agregar p\00E1g')
||unistr('ina</strong> para cada p\00E1gina.</p>'),
unistr('<p>Haga clic en <strong>Cargar un plan detallado anterior</strong> para sustituir el plan detallado por la definici\00F3n desde una aplicaci\00F3n generada anteriormente. De esta forma puede iterar muy f\00E1cilmente un dise\00F1o de la aplicaci\00F3n agregando p\00E1ginas ')
||unistr('adicionales, cambiando las funciones o modificando la configuraci\00F3n antes de volver a generar la aplicaci\00F3n.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276297103557866485)
,p_name=>'CA.BODY1.TEXT'
,p_message_language=>'es'
,p_message_text=>'Texto del cuerpo1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276297240587866485)
,p_name=>'CA.BODY2.TEXT'
,p_message_language=>'es'
,p_message_text=>'Texto del cuerpo2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276318341515866498)
,p_name=>'CA.BOTH'
,p_message_language=>'es'
,p_message_text=>'Ambos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276283558485866477)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_language=>'es'
,p_message_text=>unistr('Bifurcar a p\00E1gina de administraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275194205382865789)
,p_name=>'CA.BUTTON.BAR'
,p_message_language=>'es'
,p_message_text=>'Barra de Botones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276283285708866477)
,p_name=>'CA.BUTTONS'
,p_message_language=>'es'
,p_message_text=>'Botones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276275761743866472)
,p_name=>'CA.CALENDAR'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar p\00E1gina de calendario')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276275867520866472)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cree una p\00E1gina que muestre un calendario.</p>'),
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre de la p\00E1gina</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione un icono para que se muestre en el men\00FA de navegaci\00F3n de la p\00E1gina.</li>'),
'  <li><strong>Tabla o vista</strong> (obligatorio): seleccione el objeto de base de datos para el calendario.</li>',
unistr('  <li><strong>Columna de visualizaci\00F3n</strong> (obligatorio): seleccione la columna de la tabla o vista que se mostrar\00E1 en los eventos de calendario.</li>'),
unistr('  <li><strong>Columna de fecha de inicio</strong> (obligatorio): seleccione la columna de fecha de la tabla o vista que se utilizar\00E1 como fecha de inicio de los eventos de calendario.</li>'),
unistr('  <li><strong>Columna de fecha de finalizaci\00F3n</strong>: seleccione la columna de fecha de la tabla o vista que se utilizar\00E1 como fecha de finalizaci\00F3n de los eventos de calendario.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;Si se especifica la fecha de finalizaci\00F3n, se mostrar\00E1n los eventos basados en la duraci\00F3n. </li>'),
unistr('  <li><strong>Mostrar hora</strong>: seleccione <u>S\00ED</u> para mostrar la parte de hora para los eventos y activar las vistas de calendario Diaria y Semanal. Seleccione <u>No</u> para mostrar solo las fechas de eventos.</li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276282288476866476)
,p_name=>'CA.CANCEL'
,p_message_language=>'es'
,p_message_text=>'Cancelar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276284166013866477)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_language=>'es'
,p_message_text=>unistr('Cancelar Cuadro de Di\00E1logo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275174350189865777)
,p_name=>'CA.CANCEL.MODAL'
,p_message_language=>'es'
,p_message_text=>'Cancelar modal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276294073683866483)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_language=>'es'
,p_message_text=>unistr('No puede eliminar los derechos de administraci\00F3n de su propio registro.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276325990001866503)
,p_name=>'CA.CARD'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar p\00E1gina de tarjeta')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276325893889866503)
,p_name=>'CA.CARD.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Crea una p\00E1gina que muestra tarjetas.</p>'),
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre de p\00E1gina</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione un icono para mostrar en el men\00FA de navegaci\00F3n de la p\00E1gina.</li>'),
'  <li><strong>Tabla o vista</strong> (obligatorio): seleccione el objeto de base de datos de la tarjeta.</li>',
unistr('  <li><strong>T\00EDtulo de tarjeta</strong> (obligatorio): seleccione la columna de la tabla o vista que se va a utilizar como descripci\00F3n de la tarjeta.</li>'),
unistr('  <li><strong>Columna Descripci\00F3n</strong> (obligatorio): seleccione la columna de la tabla o vista que se va a utilizar como descripci\00F3n de la tarjeta.</li>'),
unistr('  <li><strong>Columna Texto adicional</strong>: seleccione la columna de la tabla o vista que se va a utilizar como descripci\00F3n secundaria de la tarjeta.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276324480576866502)
,p_name=>'CA.CARDS'
,p_message_language=>'es'
,p_message_text=>'Tarjetas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276324538457866502)
,p_name=>'CA.CARDS.VIEW'
,p_message_language=>'es'
,p_message_text=>'Vista de tarjetas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275273858023865840)
,p_name=>'CA.CC'
,p_message_language=>'es'
,p_message_text=>'CC'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275558006814866027)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_language=>'es'
,p_message_text=>'Cambiar filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276274813686866471)
,p_name=>'CA.CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar p\00E1gina de gr\00E1ficos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276274933513866471)
,p_name=>'CA.CHART.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cree una p\00E1gina que muestre un gr\00E1fico de \00E1reas, de barras, de l\00EDneas o circular.</p>'),
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre de la p\00E1gina</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione un icono para que se muestre en el men\00FA de navegaci\00F3n de la p\00E1gina.</li>'),
unistr('  <li><strong>Tipo de gr\00E1fico</strong>: seleccione el tipo de gr\00E1fico que desea mostrar [<strong>de \00E1reas</strong>, <strong>de barras</strong>, <strong>de l\00EDneas</strong>, <strong>de tarta</strong>].</li>'),
unistr('  <li><strong>Tabla o vista</strong> (obligatorio): seleccione el objeto de base de datos para el gr\00E1fico.</li>'),
unistr('  <li><strong>Columna de etiquetas</strong> (obligatorio): seleccione la columna de la tabla o la vista que desea utilizar como etiqueta para el gr\00E1fico.</li>'),
unistr('  <li><strong>Agregaci\00F3n de valores</strong>: seleccione c\00F3mo se debe mostrar o agregar la columna de valor<br>'),
'      &nbsp;&nbsp;&nbsp;[Valor de columna, Suma, Recuento].</li>',
unistr('  <li><strong>Columna Valor</strong> (obligatorio): seleccione una columna num\00E9rica de la tabla o vista utilizada para calcular los valores del gr\00E1fico mostrados.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276275235346866471)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h3>Ejemplos</h3>',
unistr('<p>Consulte los ejemplos para ver c\00F3mo utilizar los distintos tipos de <strong>Resumen</strong>:</p>'),
unistr('<p><strong>Ejemplo 1:</strong> se muestra un gr\00E1fico de los empleados con el n\00FAmero de empleado del m\00E1nager de cada empleado.'),
'<code><ul>',
'  <li>Table or View - Select EMP.</li>',
'  <li>Label Column - Select ENAME.</li>',
'  <li>Summarization - Select <u><strong>Column Value</strong></u>.</li>',
'  <li>Value Column - Select MGR.</li>',
'</ul></code>',
'</p>',
unistr('<p><strong>Ejemplo 2:</strong> se muestra un gr\00E1fico de los empleados con el salario total de cada trabajo.'),
'<code><ul>',
'  <li>Table or View - Select EMP.</li>',
'  <li>Label Column - Select JOB.</li>',
'  <li>Summarization - Select <u><strong>Sum</strong></u>.</li>',
'  <li>Value Column - Select SAL.</li>',
'</ul></code>',
'</p>',
unistr('<p><strong>Ejemplo 3:</strong> se muestra un gr\00E1fico de los empleados con el n\00FAmero de empleados de cada departamento.'),
'<code><ul>',
'  <li>Table or View - Select EMP.</li>',
'  <li>Label Column - Select DEPTNO.</li>',
'  <li>Summarization - Select <u><strong>Count</strong></u>.</li>',
'  <li>Value Column - Select EMPNO.</li>',
'</ul></code>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275411310896865930)
,p_name=>'CA.CLIENT.ID'
,p_message_language=>'es'
,p_message_text=>'Identificador de Cliente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276329190402866505)
,p_name=>'CA.CLOSE'
,p_message_language=>'es'
,p_message_text=>'Cerrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275039226300865688)
,p_name=>'CA.CLOSED'
,p_message_language=>'es'
,p_message_text=>'Cerrado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276327174002866504)
,p_name=>'CA.COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276303095057866489)
,p_name=>'CA.COLUMN.1'
,p_message_language=>'es'
,p_message_text=>'Columna 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276303136844866489)
,p_name=>'CA.COLUMN.2'
,p_message_language=>'es'
,p_message_text=>'Columna 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276290438157866481)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_language=>'es'
,p_message_text=>'Alias de Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276322946958866501)
,p_name=>'CA.COMMENTS'
,p_message_language=>'es'
,p_message_text=>'Comentarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276288122810866480)
,p_name=>'CA.COMPONENT.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre del Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276292946875866483)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_language=>'es'
,p_message_text=>'Configurar Control de Acceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276283336116866477)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_language=>'es'
,p_message_text=>'Configurar apariencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276283451629866477)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('<p>El aspecto de la aplicaci\00F3n viene definida por el estilo del tema.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276286766346866479)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_language=>'es'
,p_message_text=>unistr('Las opciones de configuraci\00F3n se han actualizado. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276268664645866467)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Opciones de Configuraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276266990793866466)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Activar o desactivar funciones de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276268755663866467)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite a los administradores de aplicaciones activar o desactivar una funcionalidad espec\00EDfica en la aplicaci\00F3n. Esta funci\00F3n es sumamente \00FAtil si selecciona funciones que necesitan un esfuerzo de desarrollo adicional antes de que las puedan util')
||'izar los usuarios finales.<br>',
unistr('Esta funci\00F3n tambi\00E9n se puede ampliar a funciones espec\00EDficas de la aplicaci\00F3n. Si los desarrolladores definen m\00E1s opciones de creaci\00F3n y las asocian a una funcionalidad espec\00EDfica de la aplicaci\00F3n, se pueden agregan a los valores de configuraci\00F3n pa')
||unistr('ra los administradores. Por ejemplo, en la aplicaci\00F3n empaquetada Sistema de seguimiento de clientes, los administradores pueden activar o desactivar funciones como Contactos, Carga de datos, Geograf\00EDa, etc.'),
'</p>',
'<p>Incluye los siguientes componentes:',
'<ul>',
unistr('<li>Permite activar y desactivar la funcionalidad de la aplicaci\00F3n</li>'),
unistr('<li>Utilice esta funci\00F3n para permitir una funcionalidad selectiva por despliegue</li>'),
unistr('<li>Permite el agrupamiento de la configuraci\00F3n relacionada de la aplicaci\00F3n</li>'),
unistr('<li>Los desarrolladores de aplicaciones controlan los componentes mediante opciones de creaci\00F3n</li>'),
unistr('<li>Disponible en la p\00E1gina Administraci\00F3n</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275406243365865926)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de Credencial de Conexi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275406315933865926)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_language=>'es'
,p_message_text=>unistr('Propietario de credenciales de conexi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276136283227866384)
,p_name=>'CA.CONTEXT'
,p_message_language=>'es'
,p_message_text=>'Contexto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276293427477866483)
,p_name=>'CA.CONTRIBUTOR'
,p_message_language=>'es'
,p_message_text=>'Contribuyente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275413231598865931)
,p_name=>'CA.CPU.USED'
,p_message_language=>'es'
,p_message_text=>'CPU Usada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276301955878866488)
,p_name=>'CA.CREATE'
,p_message_language=>'es'
,p_message_text=>'Crear'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276307023173866491)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina de administraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276304697770866490)
,p_name=>'CA.CREATE.APP'
,p_message_language=>'es'
,p_message_text=>unistr('Creando aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276305726766866491)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_language=>'es'
,p_message_text=>unistr('Creando c\00E1lculos de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276305044377866490)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_language=>'es'
,p_message_text=>unistr('Creando icono de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276305677759866491)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_language=>'es'
,p_message_text=>unistr('Creando elementos de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276305869592866491)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Creando procesos de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276147237300866391)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_language=>'es'
,p_message_text=>unistr('Creando configuraci\00F3n de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276313040378866495)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Crear una Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275458086269865963)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_language=>'es'
,p_message_text=>unistr('Creaci\00F3n de roles de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276305261207866490)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_language=>'es'
,p_message_text=>unistr('Creando esquemas de autorizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276306047707866491)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina en blanco')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276305117784866490)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_language=>'es'
,p_message_text=>unistr('Creando opciones de creaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276306439170866491)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina de calendario')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276319393623866499)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creaci\00F3n de p\00E1gina de tarjetas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276306257665866491)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina de gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276306790050866491)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina de informe cl\00E1sico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276306369459866491)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina de panel de control')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276304590888866490)
,p_name=>'CA.CREATE.END'
,p_message_language=>'es'
,p_message_text=>unistr('Finalizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276326680710866504)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creaci\00F3n de una p\00E1gina de b\00FAsqueda por facetas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276307379022866492)
,p_name=>'CA.CREATE.FEATURES'
,p_message_language=>'es'
,p_message_text=>'Creando funciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276323985928866502)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina Creaci\00F3n de contenido filtrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276306155974866491)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina de pantalla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276304736566866490)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina global')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276306940200866491)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_language=>'es'
,p_message_text=>unistr('Creando lista de navegaci\00F3n de p\00E1gina inicial')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276306873228866491)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina de cuadr\00EDcula interactiva')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276306626977866491)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina de informe interactivo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276312799493866495)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Crear p\00E1ginas maestro/detalle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276305460624866490)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_language=>'es'
,p_message_text=>unistr('Creando barras de navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276308681424866492)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_language=>'es'
,p_message_text=>unistr('Creando grupo de p\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276307264854866492)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_language=>'es'
,p_message_text=>unistr('Realizando traducci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276307178917866491)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_language=>'es'
,p_message_text=>unistr('Realizando traducci\00F3n de %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276306508738866491)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina de pantalla e informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276312988877866495)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_language=>'es'
,p_message_text=>'Guardar plan detallado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276305505299866490)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_language=>'es'
,p_message_text=>'Creando acceso directo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276305910273866491)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creando p\00E1gina de conexi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276304499606866490)
,p_name=>'CA.CREATE.START'
,p_message_language=>'es'
,p_message_text=>'Inicio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276304865725866490)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_language=>'es'
,p_message_text=>'Creando scripts de objetos de soporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276305353151866490)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_language=>'es'
,p_message_text=>'Creando mensajes de texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276319419700866499)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creaci\00F3n de p\00E1gina de cronolog\00EDa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276326885070866504)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Creaci\00F3n de una p\00E1gina del asistente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276286022736866478)
,p_name=>'CA.CREATED'
,p_message_language=>'es'
,p_message_text=>'Creado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276286104926866478)
,p_name=>'CA.CREATED.BY'
,p_message_language=>'es'
,p_message_text=>'Creado por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276274576799866471)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Creando Aplicaci\00F3n ...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275406903250865927)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de la Credencial'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275413167413865931)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario de Credencial'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276286643769866479)
,p_name=>'CA.CURRENT.STATUS'
,p_message_language=>'es'
,p_message_text=>'Estado Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276307670741866492)
,p_name=>'CA.CUSTOM.QRY'
,p_message_language=>'es'
,p_message_text=>'Consulta Personalizada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275504802274865994)
,p_name=>'CA.CUSTOM.THEME'
,p_message_language=>'es'
,p_message_text=>'Utilizar tema personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275504951980865994)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Cambie el asistente para que utilice un tema personalizado en lugar de Tema universal.</p>',
'',
unistr('<p>Seleccione un tema de espacio de trabajo para la aplicaci\00F3n. Si el tema soporta temas estilos de tema, tambi\00E9n se puede seleccionar el estilo.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275174014682865776)
,p_name=>'CA.CUSTOM_THEME'
,p_message_language=>'es'
,p_message_text=>'Tema personalizado'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276308236686866492)
,p_name=>'CA.DASHBOARD'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar P\00E1gina de Panel de Control')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276134644607866383)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1fico %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276308326586866492)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cree una p\00E1gina de panel de control con varios gr\00E1ficos.</p>'),
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre de p\00E1gina</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione un icono para mostrar en el men\00FA de navegaci\00F3n de la p\00E1gina.</li>'),
'  </ul>',
'</ul>',
'&nbsp;<br>',
unistr('<p>Cada gr\00E1fico (Gr\00E1fico 1, Gr\00E1fico 2, Gr\00E1fico 3 y Gr\00E1fico 4) se corresponde con un tipo de gr\00E1fico por defecto y se basa en <em>datos de ejemplo</em>. '),
unistr('  De este modo, no tiene que introducir m\00E1s detalles para agregar a la p\00E1gina.'),
unistr('  No obstante, puede personalizar cada gr\00E1fico sustituyendo los valores por defecto por sus propias selecciones.<br>'),
unistr('  Para personalizar un gr\00E1fico, introduzca los siguientes atributos:</p>'),
'<ul>',
unistr('  <li><strong>Nombre de gr\00E1fico</strong> (obligatorio): introduzca el nombre del gr\00E1fico.</li>'),
unistr('  <li><strong>Tipo de gr\00E1fico</strong>: seleccione el tipo de gr\00E1fico que desea mostrar [<strong>\00C1rea</strong>, <strong>Barra</strong>, <strong>L\00EDnea</strong>, <strong>Gr\00E1fico de tarta</strong>].</li>'),
unistr('  <li><strong>Tabla o vista</strong> (obligatorio): seleccione el objeto de base de datos para el gr\00E1fico.</li>'),
unistr('  <li><strong>Columna de etiqueta</strong> (obligatorio): seleccione la columna de la tabla o vista que desee utilizar como etiqueta para el gr\00E1fico.</li>'),
unistr('  <li><strong>Agregaci\00F3n de valores</strong>: seleccione el modo en que se debe mostrar o agregar la columna de valor<br>'),
'      &nbsp;&nbsp;&nbsp;[Columna Valor, Suma, Recuento].</li>',
unistr('  <li><strong>Columna Valor</strong> (obligatorio): seleccione una columna num\00E9rica de la tabla o vista utilizada para calcular los valores del gr\00E1fico mostrados.</li>'),
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276320027948866500)
,p_name=>'CA.DATATYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Dato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276321113256866500)
,p_name=>'CA.DATEFORMATMASK'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1scara Formato Fecha')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276287366045866479)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_language=>'es'
,p_message_text=>'Zona Horaria por Defecto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276287498075866479)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_language=>'es'
,p_message_text=>'La zona horaria por defecto se ha actualizado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276309057731866493)
,p_name=>'CA.DEFAULTS'
,p_message_language=>'es'
,p_message_text=>unistr('Valores por defecto de atributo de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276309335353866493)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Este documento de JSON permite un control detallado sobre la generaci\00F3n de nombres de columnas de formulario e informes, m\00E1scaras de formato, etc. Tambi\00E9n puede definir listas de valores y otros componentes compartidos. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276326432198866503)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_language=>'es'
,p_message_text=>'Lista de atributos de valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276326526229866504)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Agregue un atributo de lista de valores (LOV). Las listas se pueden utilizar en definiciones de columnas de la tabla. </p>',
'<p>Introduzca los siguientes atributos: ',
'  <ul> ',
'    <li><strong>Nombre</strong> (obligatorio): introduzca el nombre para la lista de valores. </li>',
unistr('    <li><strong>Tipo</strong>: seleccione el tipo de la lista de valores [Estructurado, Din\00E1mico, Est\00E1tico]. <br>'),
'      Para el tipo <u>Estructurado</u> - ',
'      <ul>',
unistr('          <li><strong>Tabla</strong> (obligatorio): seleccione la tabla o la vista en la que se basar\00E1 la lista de valores.</li>'),
unistr('          <li><strong>Columna de visualizaci\00F3n</strong> (obligatorio): seleccione la columna que se le mostrar\00E1 a los usuarios finales.</li>'),
unistr('          <li><strong>Columna de clave</strong> (obligatorio): seleccione el valor de columna que se devolver\00E1. Normalmente, es la clave primaria de la tabla.</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      Para el tipo <u>Din\00E1mico</u> -'),
'      <ul>',
unistr('          <li><strong>Consulta SQL</strong> (obligatorio): introduzca una sentencia SQL v\00E1lida que devuelva dos valores (valor de visualizaci\00F3n y valor de retorno).</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      Para el tipo <u>Est\00E1tico</u> -'),
'      <ul>',
unistr('          <li><strong>Lista de valores est\00E1tica</strong> (obligatorio): introduzca una lista est\00E1tica v\00E1lida de la pantalla:'),
'          <ul>',
'            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>Lista mostrada en el orden introducido</li>',
unistr('            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>Lista ordenada alfab\00E9ticamente</li>'),
unistr('            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>El valor de visualizaci\00F3n y el valor de retorno coinciden</li>'),
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276327691890866504)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_language=>'es'
,p_message_text=>'Atributos de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276327797428866504)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edite los atributos de todos los informes.</p>',
'<p>Introduzca los siguientes atributos:',
'  <ul>',
unistr('    <li><strong>Filas por p\00E1gina</strong>: introduzca el n\00FAmero de filas de informe que se mostrar\00E1n por defecto.</li>'),
unistr('    <li><strong>M\00E9todo de paginaci\00F3n</strong>: seleccione el modo en que se mostrar\00E1 la paginaci\00F3n de los informes.</li>'),
unistr('    <li><strong>M\00E1scara de formato num\00E9rico</strong>: introduzca la m\00E1scara de formato que se aplicar\00E1 para numerar columnas y elementos.</li>'),
unistr('    <li><strong>M\00E1scara de formato de fecha</strong>. introduzca la m\00E1scara de formato que se aplicar\00E1 para definir la fecha de columnas y elementos.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276327403764866504)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_language=>'es'
,p_message_text=>'Atributos de tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276327200087866504)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_language=>'es'
,p_message_text=>'Atributos de columnas de tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276327397837866504)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edite los atributos de la columna de la tabla seleccionada. </p>',
'<p>Introduzca los siguientes atributos:',
'  <ul> ',
unistr('    <li><strong>Tabla</strong> (solo visualizaci\00F3n): tabla asociada. </li>'),
unistr('    <li><strong>Columna</strong> (solo visualizaci\00F3n): columna con la que se han definido los atributos. </li>'),
'    <li><strong>Etiqueta</strong>: introduzca la etiqueta que desea utilizar en las cabeceras de informes y las etiquetas de formularios. </li>',
'    <li><strong>Control de formularios</strong>: seleccione el tipo de elemento que desea utilizar en los formularios. </li>',
unistr('    <li><strong>Lista de valores</strong>: seleccione una lista de valores existente que se utilizar\00E1 para mostrar nombres que le resulten sencillos al usuario seg\00FAn corresponda. </li>'),
unistr('     <li><strong>M\00E1scara de formato</strong>: introduzca una m\00E1scara de formato adecuada seg\00FAn el tipo de columna (texto, n\00FAmero, fecha, etc.).</li>'),
unistr('    <li><strong>Valor est\00E1tico por defecto</strong>: introduzca un valor de texto por defecto para la columna. </li>'),
unistr('    <li><strong>Incluir en formularios</strong>: haga clic en S\00ED si la columna se debe incluir en los formularios. </li>'),
unistr('    <li><strong>Incluir en informes</strong>: haga clic en S\00ED si la columna se debe incluir en los informes. </li>'),
unistr('    <li><strong>Necesario</strong>: haga clic en S\00ED si los datos se deben introducir en esta columna de los formularios. </li>'),
'    <li><strong>Ayuda</strong>: introduzca el texto de ayuda que se agrega al atributo de ayuda de elemento. </li>',
'  </ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276327563372866504)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edite los atributos de la tabla seleccionada. </p>',
'<p>Introduzca los siguientes atributos: ',
'  <ul>',
unistr('    <li><strong>Tabla</strong> (solo visualizaci\00F3n): tabla asociada.</li>'),
unistr('    <li><strong>Etiqueta, singular</strong> (obligatorio): introduzca la etiqueta que desea utilizar en p\00E1ginas de pantalla.</li>'),
unistr('    <li><strong>Etiqueta, plural</strong> (obligatorio): introduzca la etiqueta que desea utilizar en cabeceras de regiones y nombres de p\00E1ginas.</li>'),
unistr('    <li><strong>Columna de visualizaci\00F3n principal</strong>: seleccione la primera columna que se mostrar\00E1 en regiones de tarjetas, por ejemplo.</li>'),
unistr('    <li><strong>Columna de visualizaci\00F3n secundaria</strong>: seleccione la segunda columna que se mostrar\00E1 en regiones de tarjetas, por ejemplo.</li>'),
unistr('    <li><strong>Columna de clave principal</strong>: seleccione la columna de clave principal \00FAnica para la tabla.</li>'),
unistr('    <li><strong>Descripci\00F3n</strong>: introduzca una descripci\00F3n de la tabla.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275406725098865927)
,p_name=>'CA.DEFERRED.DROP'
,p_message_language=>'es'
,p_message_text=>'Borrado Diferido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276321722075866501)
,p_name=>'CA.DEFINITION'
,p_message_language=>'es'
,p_message_text=>unistr('Definici\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276304317718866490)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_language=>'es'
,p_message_text=>unistr('Desinstalaci\00F3n terminada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276284679123866478)
,p_name=>'CA.DELETE'
,p_message_language=>'es'
,p_message_text=>'Suprimir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276303933197866490)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_language=>'es'
,p_message_text=>unistr('\00BFDesea realizar esta acci\00F3n de supresi\00F3n?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276270282186866468)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_language=>'es'
,p_message_text=>unistr('\00BFSeguro que desea suprimir esta p\00E1gina?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276294489480866484)
,p_name=>'CA.DELETE.PHOTO'
,p_message_language=>'es'
,p_message_text=>'Suprimir foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276285370334866478)
,p_name=>'CA.DESCRIPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Descripci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276302570129866489)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_language=>'es'
,p_message_text=>unistr('Barra de navegaci\00F3n de escritorio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276302407720866489)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_language=>'es'
,p_message_text=>unistr('Men\00FA de navegaci\00F3n de escritorio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276283601665866477)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_language=>'es'
,p_message_text=>'Estilo de tema de escritorio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276283738220866477)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_language=>'es'
,p_message_text=>'El estilo de tema por defecto se aplica a todos los usuarios.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275407170785865927)
,p_name=>'CA.DESTINATION'
,p_message_language=>'es'
,p_message_text=>'Destino'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275407225353865927)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario del Destino'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275174121017865776)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_language=>'es'
,p_message_text=>unistr('Botones de cuadro de di\00E1logo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276298902476866486)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_language=>'es'
,p_message_text=>unistr('Distribuir correos electr\00F3nicos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276318506750866499)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_language=>'es'
,p_message_text=>unistr('Determina si se deben enviar los correos electr\00F3nicos desde el marco de correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276285138433866478)
,p_name=>'CA.DISPLAY.FROM'
,p_message_language=>'es'
,p_message_text=>'Mostrar desde'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276285076510866478)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_language=>'es'
,p_message_text=>unistr('Secuencia de Visualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276285218593866478)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_language=>'es'
,p_message_text=>'Mostrar hasta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276320200843866500)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna de Visualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276288746533866480)
,p_name=>'CA.DISTINCT .USERS'
,p_message_language=>'es'
,p_message_text=>'Usuarios Distintos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276302047402866488)
,p_name=>'CA.DOWNLOAD'
,p_message_language=>'es'
,p_message_text=>'Descargar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276308984157866493)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_language=>'es'
,p_message_text=>unistr('Arrastrar para reordenar p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275195420705865790)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr('  <li><strong>Enlace de detalles</strong>: ampl\00EDe para ver los atributos para la definici\00F3n de un enlace de detalles.'),
'&nbsp;<br>',
unistr('    <em><strong>Nota:</strong> El enlace de detalles solo aparece si la p\00E1gina actual se basa en una tabla o vista y tiene el tipo de informe Informe interactivo, y si ha definido un informe (Informe interactivo) o una p\00E1gina maestro/detalle (Maestro')
||'/detalle).</em>',
'  <ul>',
'    <li><strong>Columna Enlace</strong>: seleccione la columna para cambiar a una columna de enlace en el informe.</li>',
unistr('    <li><strong>Clave de enlace</strong>: seleccione la clave de enlace (clave ajena) utilizada para identificar el registro espec\00EDfico en la p\00E1gina con la que se enlaza.</li>'),
unistr('    <li><strong>Enlazar con p\00E1gina</strong>: seleccione el informe o p\00E1gina de formulario a la que navega el enlace.</li>'),
unistr('    <li><strong>Clave de destino</strong>: seleccione la columna de clave de destino (clave primaria) de la tabla de la p\00E1gina de informe a la que navega y en la que se basa el enlace.'),
'  </ul>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276287814479866480)
,p_name=>'CA.ELAPSED'
,p_message_language=>'es'
,p_message_text=>'Tiempo transcurrido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276270429635866468)
,p_name=>'CA.EMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Marco de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276318131140866498)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_language=>'es'
,p_message_text=>unistr('Direcciones de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276328197571866505)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_language=>'es'
,p_message_text=>'Valor por Defecto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276270391983866468)
,p_name=>'CA.EMAIL.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar capacidad para configurar y enviar correos electr\00F3nicos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276270592862866468)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Incluya la posibilidad de enviar correos electr\00F3nicos desde su aplicaci\00F3n. Env\00EDe correos electr\00F3nicos profesionales a los usuarios con esta plantilla de correo electr\00F3nico de ejemplo. Los correos electr\00F3nicos enviados se registran para que los adm')
||unistr('inistradores puedan realizar un seguimiento de la actividad de correo electr\00F3nico.</p>'),
'<p>Incluye los siguientes componentes:',
'<ul>',
unistr('<li>Sistema de plantillas de correo electr\00F3nico HTML ampliable</li>'),
'<li>Paquete PL/SQL para enviar correo mediante paquetes de APEX</li>',
unistr('<li>Registro del estado y la actividad de correo electr\00F3nico</li>'),
'<li>Interfaz de usuario administrativa para gestionar plantillas</li>',
unistr('<li>Interfaz de usuario administrativa para ver logs de correo electr\00F3nico</li>'),
unistr('<li>Interfaz de usuario administrativa para enviar correos electr\00F3nicos</li>'),
'</ul>',
'</p>',
unistr('<p><em>Nota: Esta funci\00F3n se activar\00E1 al seleccionar Comentarios</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276323898180866502)
,p_name=>'CA.EMAIL.FROM'
,p_message_language=>'es'
,p_message_text=>unistr('Correo Electr\00F3nico De')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276297901730866486)
,p_name=>'CA.EMAIL.LOG'
,p_message_language=>'es'
,p_message_text=>unistr('Log de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276328749507866505)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('Se necesitan los detalles de configuraci\00F3n de correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276328219490866505)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('La direcci\00F3n de origen no es una direcci\00F3n de correo electr\00F3nico v\00E1lida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276319789983866499)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('La direcci\00F3n de origen no es una direcci\00F3n de correo electr\00F3nico v\00E1lida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276318994055866499)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_language=>'es'
,p_message_text=>unistr('Correo electr\00F3nico procesado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275274168066865841)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_language=>'es'
,p_message_text=>unistr('Informes de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275459977320865964)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Informe de todos los correos electr\00F3nicos en cola de env\00EDo y los que ya se han enviado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276298834914866486)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276299289573866487)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha actualizado la configuraci\00F3n de correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276324264472866502)
,p_name=>'CA.EMAIL.STATUS'
,p_message_language=>'es'
,p_message_text=>unistr('Estado de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276299337541866487)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_language=>'es'
,p_message_text=>unistr('Detalles de la Plantilla de Correo Electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275811052626866183)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_language=>'es'
,p_message_text=>unistr('Interrupci\00F3n programada para #SERVICE_NAME#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275512428965865999)
,p_name=>'CA.EMAIL2'
,p_message_language=>'es'
,p_message_text=>unistr('Correo Electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276297821278866486)
,p_name=>'CA.EMAILS.SENT'
,p_message_language=>'es'
,p_message_text=>unistr('Correos Electr\00F3nicos Enviados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276328360458866505)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_language=>'es'
,p_message_text=>'Activar anexos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275412228339865930)
,p_name=>'CA.ENABLED'
,p_message_language=>'es'
,p_message_text=>'Activado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275409426611865928)
,p_name=>'CA.END.DATE'
,p_message_language=>'es'
,p_message_text=>unistr('Fecha de Finalizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276299992572866487)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Contenido despu\00E9s de filas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276316039041866497)
,p_name=>'CA.ENTER.USERNAME'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca aqu\00ED el nombre de usuario')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276288413304866480)
,p_name=>'CA.ERROR'
,p_message_language=>'es'
,p_message_text=>'Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276290749279866481)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_language=>'es'
,p_message_text=>'Rastreo inverso de errores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276290603127866481)
,p_name=>'CA.ERROR.CODE'
,p_message_language=>'es'
,p_message_text=>unistr('C\00F3digo de error')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276289962186866481)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_language=>'es'
,p_message_text=>'Mensaje de Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275413982245865931)
,p_name=>'CA.ERROR.NUMBER'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de Error')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275412917863865931)
,p_name=>'CA.ERRORS'
,p_message_language=>'es'
,p_message_text=>'Errores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275409842278865929)
,p_name=>'CA.EVENT.CONDITION'
,p_message_language=>'es'
,p_message_text=>unistr('Condici\00F3n de Evento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275409994134865929)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_language=>'es'
,p_message_text=>'Agente de Cola de Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275410020428865929)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Cola de Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275410145788865929)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario de Cola de Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275409777461865928)
,p_name=>'CA.EVENT.RULE'
,p_message_language=>'es'
,p_message_text=>'Regla de evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276316383862866497)
,p_name=>'CA.EXCEPTIONS'
,p_message_language=>'es'
,p_message_text=>'Excepciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276329253271866505)
,p_name=>'CA.EXPERIENCE'
,p_message_language=>'es'
,p_message_text=>'Experiencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275411979500865930)
,p_name=>'CA.FAILURE.COUNT'
,p_message_language=>'es'
,p_message_text=>'Recuento de Fallos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276286407234866479)
,p_name=>'CA.FEATURE'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276066482919866341)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_language=>'es'
,p_message_text=>unistr('Versi\00F3n de la Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276066557031866341)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275558451094866027)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_language=>'es'
,p_message_text=>'Agregar usuarios a la lista de control de acceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275558226214866027)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_language=>'es'
,p_message_text=>'Ir al paso siguiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275558356597866027)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_language=>'es'
,p_message_text=>'Crear recopilaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275558187082866027)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_language=>'es'
,p_message_text=>unistr('No se puede cambiar el \00FAltimo administrador')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276066171339866341)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltima Actividad')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275557999399866027)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_language=>'es'
,p_message_text=>'No se ha encontrado ninguna actividad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276066397055866341)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_language=>'es'
,p_message_text=>'Motivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275558570224866027)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_language=>'es'
,p_message_text=>'Se necesita al menos un comentario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275558884512866027)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_language=>'es'
,p_message_text=>'Obtener ID de archivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275557435689866027)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_language=>'es'
,p_message_text=>'Guardar estilo de tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275557559951866027)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_language=>'es'
,p_message_text=>'Guardar preferencia de estilo de usuario final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276066281110866341)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276274655216866471)
,p_name=>'CA.FEATURES'
,p_message_language=>'es'
,p_message_text=>'Funciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276274784911866471)
,p_name=>'CA.FEATURES.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Las funciones ofrecen funcionalidades a nivel de aplicaci\00F3n y normalmente se agregan una vez por aplicaci\00F3n. Seleccione las funciones que desea incluir en su aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276268572096866467)
,p_name=>'CA.FEEDBACK'
,p_message_language=>'es'
,p_message_text=>'Comentarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276266530278866466)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_language=>'es'
,p_message_text=>'Permitir a los usuarios proporcionar comentarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276268412220866467)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Ofrece a los usuarios finales un mecanismo para publicar comentarios generales como respuesta a los administradores y desarrolladores de la aplicaci\00F3n. Las publicaciones incluyen informaci\00F3n \00FAtil sobre el estado de la sesi\00F3n para ayudar a determin')
||unistr('ar el lugar desde el que el usuario final ha enviado los comentarios. Proporcionar ese \00FAtil intercambio de comentarios permite mejorar la comunicaci\00F3n entre la comunidad de usuarios y los propietarios de la aplicaci\00F3n, lo que permite mejorar en gran ')
||unistr('medida la satisfacci\00F3n del usuario final.</p>'),
'<p>Incluye los siguientes componentes:',
'<ul>',
unistr('<li>Capacidad de que los usuarios finales dejen comentarios haciendo clic en un icono de la barra de navegaci\00F3n</li>'),
'<li>Informe administrativo para ver y actualizar los comentarios</li>',
unistr('<li>Los comentarios capturar\00E1n la informaci\00F3n de usuario, fecha y hora y agente de usuario</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276329644129866506)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_language=>'es'
,p_message_text=>unistr('Env\00EDe comentarios sobre su experiencia.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276328613223866505)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_language=>'es'
,p_message_text=>unistr('Destino de env\00EDo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276328080612866504)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de comentarios')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276295960643866485)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha actualizado la configuraci\00F3n de comentarios.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276328807458866505)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_language=>'es'
,p_message_text=>'Comentarios enviados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275409547302865928)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Observador de Archivos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275409644586865928)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario del observador de archivos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275064796951865706)
,p_name=>'CA.FILED'
,p_message_language=>'es'
,p_message_text=>'Archivado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275064873921865706)
,p_name=>'CA.FILED.BY'
,p_message_language=>'es'
,p_message_text=>'Archivado por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276324362269866502)
,p_name=>'CA.FILTER.REPORT'
,p_message_language=>'es'
,p_message_text=>'Filtrar informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276300353396866487)
,p_name=>'CA.FILTERS'
,p_message_language=>'es'
,p_message_text=>'Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276327022655866504)
,p_name=>'CA.FINISH'
,p_message_language=>'es'
,p_message_text=>'Terminar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276294608237866484)
,p_name=>'CA.FIRST.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275406512182865926)
,p_name=>'CA.FLAGS'
,p_message_language=>'es'
,p_message_text=>'Indicadores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276276022863866472)
,p_name=>'CA.FORM'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar p\00E1gina de pantalla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276275959929866472)
,p_name=>'CA.FORM.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cree una p\00E1gina que muestre una p\00E1gina de pantalla que permita a los usuarios finales mantener los datos.</p>'),
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre de la p\00E1gina</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione el icono que se mostrar\00E1 en el men\00FA de navegaci\00F3n de esta p\00E1gina.</li>'),
'  <li><strong>Tabla</strong> (obligatorio): seleccione la tabla para la pantalla.</li>',
unistr('<li><strong>Incluir informe</strong> (obligatorio): seleccione esta opci\00F3n para crear un informe y una pantalla La primera p\00E1gina es un informe interactivo. Cada fila proporciona un enlace a una pantalla donde los usuarios pueden actualizar el regist')
||'ro. </li>',
'  &nbsp;<br>',
unistr('<li><strong>Avanzadas</strong>: ampl\00EDe para ver opciones avanzadas.'),
'     <ul>',
unistr('      <li><strong>Ayuda de la p\00E1gina</strong>: introduzca el texto que se agregar\00E1 al Texto de ayuda para la p\00E1gina.</li>'),
'      </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275194403250865790)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Regi\00F3n de elementos de pantalla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276302263873866488)
,p_name=>'CA.FORM.ON'
,p_message_language=>'es'
,p_message_text=>'Pantalla Basada en %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276315877609866497)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_language=>'es'
,p_message_text=>unistr('El tipo de formulario no es de un tipo v\00E1lido')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276322225108866501)
,p_name=>'CA.FORMATMASK'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1scara de Formato')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276321256376866500)
,p_name=>'CA.FORMCONTROL'
,p_message_language=>'es'
,p_message_text=>'Control de Pantalla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276285882831866478)
,p_name=>'CA.FROM'
,p_message_language=>'es'
,p_message_text=>'De'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276299046166866486)
,p_name=>'CA.FROM.ADDRESS'
,p_message_language=>'es'
,p_message_text=>unistr('Direcci\00F3n remitente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276323724579866502)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de correo electr\00F3nico de "Direcci\00F3n de origen"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276319644243866499)
,p_name=>'CA.FROM.EMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Correo electr\00F3nico de origen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276319520411866499)
,p_name=>'CA.FROM.WHO'
,p_message_language=>'es'
,p_message_text=>'Remitente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276068387311866342)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('B\00FAsqueda %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276289324966866480)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_language=>'es'
,p_message_text=>unistr('Vistas de p\00E1ginas completas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276298032455866486)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_language=>'es'
,p_message_text=>'HTML de plantilla completa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276320748692866500)
,p_name=>'CA.FUNCTION'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276268963105866467)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_language=>'es'
,p_message_text=>unistr('B\00FAsqueda global')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276266789457866466)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Proporcionar capacidad de b\00FAsqueda en la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276268820038866467)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite a los usuarios finales buscar texto en tablas o vistas clave de la aplicaci\00F3n. La p\00E1gina de b\00FAsqueda avanzada incluye filtros para que los usuarios finales puedan limitar f\00E1cilmente los resultados.<br>'),
unistr('Para utilizar esta funci\00F3n tan potente se deben realizar algunas tareas de desarrollo para definir el SQL (basado en los ejemplos proporcionados).</p>'),
'<p>Incluye los siguientes componentes:',
'<ul>',
unistr('<li>Muestra un icono de b\00FAsqueda en la barra de cabecera</li>'),
unistr('<li>Incluye una p\00E1gina de resultados de b\00FAsqueda de detalle con filtro de barra lateral</li>'),
unistr('<li>Necesita que el desarrollador implante el SQL para definir la b\00FAsqueda en la aplicaci\00F3n</li>'),
'<li>Incluye datos de ejemplo como muestra</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275411281898865929)
,p_name=>'CA.GLOBAL.UID'
,p_message_language=>'es'
,p_message_text=>unistr('ID \00FAnico global')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275557010311866026)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina Global - Escritorio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275174262779865776)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Ir a la p\00E1gina de administraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276275578376866472)
,p_name=>'CA.GRID'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar p\00E1gina de cuadr\00EDcula interactiva')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276275615744866472)
,p_name=>'CA.GRID.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cree una p\00E1gina que se muestre como una cuadr\00EDcula interactiva, que es similar a una hoja de c\00E1lculo. Cuando es editable, los usuarios pueden editar varias filas directamente en la p\00E1gina (es decir, cuando la opci\00F3n Permitir edici\00F3n est\00E1 activada)')
||'.</p>',
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre de la p\00E1gina</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione un icono para que se muestre en el men\00FA de navegaci\00F3n de la p\00E1gina.</li>'),
'  <li><strong>Tipo de consulta</strong>: seleccione el origen del informe [<strong>Tabla o vista<strong> o <strong>Consulta SQL<strong>].<br>',
'    <strong>Tabla o vista</strong>:',
'    <ul>',
unistr('      <li><strong>Tabla o vista</strong> (obligatorio): seleccione el objeto de base de datos de la cuadr\00EDcula.</li>'),
'    </ul>',
'    <strong>Consulta SQL</strong>:',
'    <ul>',
unistr('      <li><strong>Consulta SQL</strong> (obligatorio): introduzca una sentencia SQL v\00E1lida que devuelva columnas distintas.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>Tipo de cuadr\00EDcula</strong>: seleccione si los usuarios pueden editar las filas de la cuadr\00EDcula [<strong>Permitir edici\00F3n<strong> o <strong>Solo lectura<strong>]. Para activar la edici\00F3n, seleccione<strong>Permitir edici\00F3n</strong>.</l')
||'i>',
'  &nbsp;<br>',
unistr('  <em><strong>Advertencia:</strong>Si selecciona el tipo de consulta <strong>Consulta SQL</strong> y el tipo de cuadr\00EDcula <strong>Permitir edici\00F3n</strong> y su consulta une dos o m\00E1s tablas, la cuadr\00EDcula interactiva generada fallar\00E1 cuando los usu')
||'arios intenten actualizar los registros.',
unistr('Adem\00E1s, si selecciona el tipo de cuadr\00EDcula <strong>Permitir edici\00F3n</strong> y la consulta (o tabla o vista seleccionada) utiliza una vista que no se puede actualizar, la cuadr\00EDcula interactiva generada fallar\00E1 cuando los usuarios intenten actualiza')
||'r los registros.</em><br>',
'  </li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276300813606866488)
,p_name=>'CA.HELP'
,p_message_language=>'es'
,p_message_text=>'Ayuda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276293263637866483)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_language=>'es'
,p_message_text=>unistr('Seleccione <strong>No</strong> si se definen todos los usuarios en la lista de control de acceso. Seleccione <strong>S\00ED</strong> si los usuarios autenticados que no est\00E9n en la lista de control de acceso pueden tambi\00E9n utilizar esta aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276286984483866479)
,p_name=>'CA.HELP.APP.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('El texto que se introduce aqu\00ED se utiliza en toda la aplicaci\00F3n, en especial, en la esquina superior izquierda de las p\00E1ginas. El cambio se aplicar\00E1 de forma inmediata para el administrador que realiza el cambio, pero otros usuarios solo ver\00E1n el cam')
||unistr('bio cuando inicien una nueva sesi\00F3n (es decir, la pr\00F3xima vez que se conecten).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276281592358866476)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Haga clic en el icono de comentarios ( <span class="fa fa-comment-o" aria-hidden="true"></span> ) de la barra de navegaci\00F3n, en cualquier p\00E1gina de la aplicaci\00F3n, para dejar un comentario para los administradores de la aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276281287305866475)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Esta es la p\00E1gina inicial de la aplicaci\00F3n. Haga clic en las tarjetas para acceder a distintas p\00E1ginas de la aplicaci\00F3n o utilice el men\00FA de navegaci\00F3n del lateral de la p\00E1gina.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276281401188866475)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Esta es la p\00E1gina inicial de la aplicaci\00F3n. Haga clic en las tarjetas para acceder a distintas p\00E1ginas de la aplicaci\00F3n o utilice el men\00FA de navegaci\00F3n de la parte superior de la p\00E1gina.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276281680657866476)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Introduzca un t\00E9rmino de b\00FAsqueda en el campo <strong>Buscar aplicaci\00F3n</strong> de esta p\00E1gina o haga clic en el icono de b\00FAsqueda ( <span class="fa fa-search" aria-hidden="true"></span> ) de la barra de navegaci\00F3n de cualquier p\00E1gina, para busca')
||unistr('r el t\00E9rmino en la aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276281961815866476)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Haga clic en la lista desplegable de nombres de la barra de navegaci\00F3n para cerrar sesi\00F3n de la aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276281847235866476)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Haga clic en el men\00FA de usuario ( <span class="fa fa-user" aria-hidden="true"></span> ) de la barra de navegaci\00F3n para actualizar su preferencia de zona horaria y cerrar sesi\00F3n de la aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276281368320866475)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina Inicial')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276282023904866476)
,p_name=>'CA.HELP.HOME.USER'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Haga clic en el men\00FA de usuario ( <span class="fa fa-user" aria-hidden="true"></span> ) de la barra de navegaci\00F3n (parte superior derecha de la p\00E1gina) para acceder a su perfil de usuario y cerrar sesi\00F3n de la aplicaci\00F3n.<br>'),
unistr('Si hace clic en <strong>Ver mi perfil</strong>, podr\00E1 a continuaci\00F3n hacer clic en <strong>Actualizar perfil</strong> para introducir sus datos personales y cargar una fotograf\00EDa o un avatar.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276281759600866476)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Haga clic en el men\00FA de usuario ( <span class="fa fa-user" aria-hidden="true"></span> ) de la barra de navegaci\00F3n para acceder a su perfil de usuario, actualizar su preferencia de zona horaria y cerrar sesi\00F3n de la aplicaci\00F3n.<br>'),
unistr('Si hace clic en <strong>Ver mi perfil</strong>, podr\00E1 a continuaci\00F3n hacer clic en <strong>Actualizar perfil</strong> para introducir sus datos personales y cargar una fotograf\00EDa o un avatar.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276307893487866492)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para buscar los datos, introduzca un t\00E9rmino de b\00FAsqueda en el cuadro de di\00E1logo de b\00FAsqueda o haga clic en las cabeceras de columna para limitar los registros devueltos.</p>'),
'',
unistr('<p>Puede realizar varias funciones haciendo clic en el bot\00F3n <strong>Acciones</strong>, entre las que se incluyen el seleccionar las columnas que se muestran u ocultan y su secuencia de visualizaci\00F3n, adem\00E1s de numeras funciones de datos y formato. T')
||unistr('ambi\00E9n puede definir m\00E1s vistas de los datos con la opci\00F3n de gr\00E1fico.</p>'),
'',
'<p>Si desea guardar las personalizaciones, seleccione el informe o haga clic en Descargar para descargar los datos.<p>',
'<br>',
unistr('<p>Para obtener m\00E1s informaci\00F3n, haga clic en Ayuda en la parte inferior del men\00FA Acciones.</p>'),
'',
unistr('<p>Haga clic en el bot\00F3n <strong>Restablecer</strong> para restablecer la configuraci\00F3n por defecto del informe interactivo.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276307702662866492)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Puede insertar, actualizar y suprimir los datos directamente en esta cuadr\00EDcula interactiva.<br>'),
unistr('  Inserte una fila nueva haciendo clic en el bot\00F3n Agregar fila.<br>'),
unistr('  Haga doble clic en una celda o haga clic en el bot\00F3n <strong>Editar</strong> para actualizar los valores de datos, lo que equivale a editar los datos en una hoja de c\00E1lculo.</p>'),
'',
unistr('<p>Utilice el men\00FA Acciones de fila ( <span class="fa fa-bars" aria-hidden="true"></span> ) en la parte superior del informe para duplicar, suprimir, refrescar o revertir las filas seleccionadas.<br>'),
unistr('  Utilice el men\00FA Acciones de fila en las distintas filas para acceder tambi\00E9n a la vista de una fila o agregar una nueva fila.</p>'),
'',
unistr('<p>Para buscar los datos, introduzca un t\00E9rmino de b\00FAsqueda en el cuadro de di\00E1logo de b\00FAsqueda o haga clic en las cabeceras de columna para limitar los registros devueltos.</p>'),
'',
unistr('<p>Puede realizar varias funciones haciendo clic en el bot\00F3n <strong>Acciones</strong>, entre las que se incluyen el seleccionar las columnas que se muestran u ocultan y su secuencia de visualizaci\00F3n, adem\00E1s de numeras funciones de datos y formato. T')
||unistr('ambi\00E9n puede definir m\00E1s vistas de los datos con la opci\00F3n de gr\00E1fico.</p>'),
'',
'<p>Si desea guardar las personalizaciones, seleccione el informe o haga clic en Descargar para descargar los datos.<p>',
'',
unistr('<p>Para obtener m\00E1s informaci\00F3n, haga clic en Ayuda en la parte inferior del men\00FA Acciones.</p>'),
'',
unistr('<p>Haga clic en el bot\00F3n <strong>Restablecer</strong> para restablecer la configuraci\00F3n por defecto del informe interactivo.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276281154661866475)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para buscar los datos, introduzca un t\00E9rmino de b\00FAsqueda en el cuadro de di\00E1logo de b\00FAsqueda o haga clic en las cabeceras de columna para limitar los registros devueltos.</p>'),
'',
unistr('<p>Puede realizar varias funciones haciendo clic en el bot\00F3n <strong>Acciones</strong>, entre las que se incluyen el seleccionar las columnas que se muestran u ocultan y su secuencia de visualizaci\00F3n, adem\00E1s de numerosas funciones de datos y formato.')
||unistr(' Tambi\00E9n puede definir m\00E1s vistas de los datos con las opciones de gr\00E1fico, agrupaci\00F3n por y giro.</p>'),
'',
unistr('<p>Si desea guardar las personalizaciones, seleccione el informe o haga clic en Descargar para descargar los datos. Introduzca la direcci\00F3n de correo electr\00F3nico y el marco temporal de la suscripci\00F3n para el env\00EDo de los datos de forma regular.<p>'),
'',
unistr('<p>Para obtener m\00E1s informaci\00F3n, haga clic en Ayuda en la parte inferior del men\00FA Acciones.</p>'),
'',
unistr('<p>Haga clic en el bot\00F3n <strong>Restablecer</strong> para restablecer la configuraci\00F3n por defecto del informe interactivo.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276316877525866498)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta p\00E1gina de informe muestra los registros principales en un selector en un lateral de la p\00E1gina. '),
'  Seleccione un registro para ver el registro maestro y cualquier registro de detalle definido.<br> ',
unistr('  Haga clic en el icono de edici\00F3n ( <span class="fa fa-pencil-square-o" aria-hidden="true"></span> ) para editar el registro maestro.'),
unistr('  Para los registros detallados, haga clic en el l\00E1piz, al principio de cada fila, para editar ese registro.</p>'),
unistr('<p>Para limitar los datos mostrados en el selector, introduzca un t\00E9rmino de b\00FAsqueda en el cuadro de di\00E1logo de b\00FAsqueda.</p>'),
'',
unistr('<p>Para agregar nuevos registros maestros, haga clic en <strong>Crear</strong> al principio de la p\00E1gina.'),
unistr('  Para los registros detallados, haga clic en el icono de signo m\00E1s ( + ) en la parte superior de la regi\00F3n de detalle para agregar un registro detallado.</p>'),
'',
unistr('<p>Haga clic en <strong>Restablecer</strong> en la parte superior de la p\00E1gina para restablecer la p\00E1gina a la configuraci\00F3n por defecto, eliminando cualquier t\00E9rmino de b\00FAsqueda definido previamente.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276279193642866474)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>La p\00E1gina de administraci\00F3n permite a los propietarios de aplicaciones (administradores) configurar la aplicaci\00F3n y conservar los datos comunes que se utilizan en toda la aplicaci\00F3n.'),
unistr('Al seleccionar uno de los valores disponibles, los administradores pueden cambiar potencialmente la forma en que se muestra la aplicaci\00F3n y/o las funciones que pueden utilizar los usuarios finales.</p>'),
unistr('<p>El acceso a esta p\00E1gina debe estar restringido solo a los administradores.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276280376854866475)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Seleccione la opci\00F3n adecuada para cualquier usuario autenticado.<br>'),
unistr('Al seleccionar <strong>No</strong>, la aplicaci\00F3n pasa a ser m\00E1s segura, ya que solo podr\00E1n acceder a ella los usuarios especificados.'),
unistr('Sin embargo, si la aplicaci\00F3n tiene una comunidad de usuarios grande, mantener a tal cantidad de usuarios puede ser una tarea laboriosa y tal vez prefiera seleccionar <strong>S\00ED</strong> y solo implicar a los administradores de la aplicaci\00F3n y puede ')
||'que a los contribuyentes.<br>',
unistr('Si selecciona <strong>S\00ED</strong>, tambi\00E9n debe seleccionar c\00F3mo se considera a los usuarios no incluidos en la lista de usuarios.</p>'),
unistr('<p>Seleccione entre exigir las direcciones de correo electr\00F3nico y cualquier valor alfanum\00E9rico para los nombres de usuario.<br>'),
unistr('Por lo general, debe definir este valor en <strong>Direcci\00F3n de correo electr\00F3nico</strong> si la aplicaci\00F3n utiliza (o se configurar\00E1 para utilizar) un esquema de autenticaci\00F3n centralizado como Oracle Access Manager o SSO.</p>'),
unistr('<p><em><strong>Nota:</strong> Esta aplicaci\00F3n soporta los tres niveles siguientes de acceso: Lector, Contribuyente y Administrador.'),
'<ul>',
unistr('  <li>Los <strong>lectores</strong> tienen acceso de solo lectura a toda la informaci\00F3n y tambi\00E9n pueden ver informes.</li>'),
unistr('  <li>Los <strong>contribuyentes</strong> pueden crear, editar y suprimir informaci\00F3n y ver informes.</li>'),
unistr('  <li>Los <strong>administradores</strong>, adem\00E1s de la capacidad Contribuyentes, tambi\00E9n pueden realizar la configuraci\00F3n de la aplicaci\00F3n mediante el acceso a la secci\00F3n Administraci\00F3n de la aplicaci\00F3n.</li>'),
'</ul>',
'</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276280567139866475)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice esta pantalla para introducir usuarios, sus direcciones de correo electr\00F3nico y definir sus niveles de acceso.'),
unistr('La configuraci\00F3n definida en <em>Configurar control de acceso</em> determinar\00E1 si el nombre de usuario debe ser su direcci\00F3n de correo electr\00F3nico o puede ser cualquier entrada alfanum\00E9rica.</p>'),
unistr('<p>Esta aplicaci\00F3n soporta los tres niveles de acceso siguientes: Lector, Contribuyente y Administrador.</p>'),
'<ul>',
unistr('  <li>Los <strong>lectores</strong> tienen acceso de solo lectura a toda la informaci\00F3n y tambi\00E9n pueden ver informes.</li>'),
unistr('  <li>Los <strong>contribuyentes</strong> pueden crear, editar y suprimir informaci\00F3n y ver informes.</li>'),
unistr('  <li>Los <strong>administradores</strong>, adem\00E1s de la capacidad Contribuyentes, tambi\00E9n pueden realizar la configuraci\00F3n de la aplicaci\00F3n mediante al acceso a la secci\00F3n Administraci\00F3n de la aplicaci\00F3n.</li>'),
'</ul>',
unistr('<p>Al editar un usuario existente, puede bloquear su cuenta, lo que evitar\00E1 que accedan a la aplicaci\00F3n.</p>'),
unistr('<p><em><strong>Nota:</strong> Si utiliza cuentas de Oracle Application Express, el administrador del espacio de trabajo tambi\00E9n debe definir a los usuarios introducidos aqu\00ED como usuarios finales, cuyas contrase\00F1as tambi\00E9n puede definir.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276280435771866475)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>En esta p\00E1gina se muestra un informe de los usuarios de la aplicaci\00F3n y el nivel de acceso otorgado.</p>'),
unistr('<p>Haga clic en las cabeceras de columna para ordenar y filtrar los datos, o bien haga clic en el bot\00F3n <strong>Acciones</strong> para personalizar la visualizaci\00F3n de columnas y otras muchas funciones avanzadas.<br>'),
unistr('Haga clic en el bot\00F3n <strong>Restablecer</strong> para restablecer la configuraci\00F3n por defecto del informe interactivo.</p>'),
unistr('<p>Haga clic en el icono de edici\00F3n (l\00E1piz de color amarillo) para editar los detalles y el nivel de acceso del usuario, o bien para suprimir el usuario.</p>'),
'<p>Haga clic en <strong>Agregar usuario</strong>, en la parte superior del informe, para agregar un nuevo usuario y su nivel de acceso.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276293930927866483)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cuando el control de acceso est\00E1 activado, los administradores pueden restringir el acceso a determinadas funciones de la aplicaci\00F3n para los usuarios autenticados. Esta aplicaci\00F3n soporta los tres roles siguientes: Lector, Contribuyente y Adminis')
||'trador.</p>',
'<ul>',
unistr('  <li>Los <strong>lectores</strong> tienen acceso de solo lectura a toda la informaci\00F3n y tambi\00E9n pueden ver informes.</li>'),
unistr('  <li>Los <strong>contribuyentes</strong> pueden crear, editar y suprimir informaci\00F3n y ver informes.</li>'),
unistr('  <li>Los <strong>administradores</strong>, adem\00E1s de la capacidad de los contribuyentes, pueden realizar la configuraci\00F3n de la aplicaci\00F3n.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276315959989866497)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca los nombres de usuario separados por comas, puntos y comas o espacios en blanco. Los nombres de usuario duplicados o existentes se ignorar\00E1n autom\00E1ticamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276279316522866474)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Los valores de configuraci\00F3n permiten hacer que una funcionalidad espec\00EDfica est\00E9 disponible (activada) o no disponible (desactivada) para los usuarios finales.</p>'),
unistr('<p>Si una funci\00F3n concreta no est\00E1 100% lista o se tiene que eliminar temporalmente, haga clic en <strong>Desactivado</strong>.'),
'Para que vuelva a estar disponible, solo tiene que hacer clic en <strong>Activado</strong>.</p>',
unistr('<p><em><strong>Nota:</strong> Los usuarios finales que est\00E9n ejecutando actualmente la aplicaci\00F3n no ver\00E1n reflejados los cambios que se realicen aqu\00ED. La configuraci\00F3n de funciones revisada se mostrar\00E1 una vez que el usuario se haya desconectado y s')
||'e vuelva a conectar.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276279453171866474)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Seleccione el esquema de color por defecto que se utiliza para mostrar la aplicaci\00F3n.</p>'),
unistr('<p>Si la opci\00F3n <strong>Permitir a los usuarios finales seleccionar el estilo de tema</strong> est\00E1 activada, los usuarios finales podr\00E1n seleccionar uno de los estilos de tema disponibles haciendo clic en el enlace <em>Personalizar</em> de la esquin')
||unistr('a inferior izquierda de la p\00E1gina inicial.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276280063314866474)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>En esta p\00E1gina se proporciona un informe interactivo de todos los errores inesperados que haya registrado esta aplicaci\00F3n.</p>'),
unistr('<p>Haga clic en las cabeceras de columna para ordenar y filtrar los datos, o bien haga clic en el bot\00F3n <strong>Acciones</strong> para personalizar la visualizaci\00F3n de columnas y otras muchas funciones avanzadas. Haga clic en el bot\00F3n <strong>Restabl')
||unistr('ecer</strong> para restablecer la configuraci\00F3n por defecto del informe interactivo.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276279993799866474)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilice este informe y gr\00E1fico para ver qui\00E9nes son los usuarios con m\00E1s vistas de p\00E1gina durante el marco temporal especificado.</p>'),
unistr('<p>Seleccione el marco temporal del informe (Valor por defecto = 1 d\00EDa) y seleccione entre los iconos de informe y gr\00E1fico en la parte superior de la p\00E1gina.</p>'),
unistr('<p>Para el informe interactivo, utilice el campo de b\00FAsqueda o seleccione la cabecera de columna <strong>Usuario</strong> para seleccionar un usuario espec\00EDfico. Puede realizar muchas funciones con el bot\00F3n <strong>Acciones</strong>, como mostrar u o')
||unistr('cultar columnas, especificar las filas por p\00E1gina, filtrar, etc. Haga clic en el bot\00F3n <strong>Restablecer</strong> para restablecer la configuraci\00F3n por defecto del informe interactivo.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276280108923866475)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>En esta p\00E1gina se proporciona un informe interactivo del rendimiento y la popularidad de la p\00E1gina. El informe se ordena por <strong>Rendimiento ponderado</strong>, que se calcula multiplicando el tiempo de mediana transcurrido y el n\00FAmero de vist')
||unistr('as de p\00E1gina.</p>'),
unistr('<p>Seleccione el marco temporal del informe (valor por defecto = 1 d\00EDa) en la parte superior de la p\00E1gina seg\00FAn sea necesario.<br>'),
unistr('Haga clic en las cabeceras de columna para ordenar y filtrar los datos, o bien haga clic en el bot\00F3n <strong>Acciones</strong> para personalizar la visualizaci\00F3n de columnas y otras muchas funciones avanzadas. Haga clic en el bot\00F3n <strong>Restablece')
||unistr('r</strong> para restablecer la configuraci\00F3n por defecto del informe interactivo.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276280226540866475)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>En esta p\00E1gina se proporciona un informe interactivo de las vistas de p\00E1gina m\00E1s recientes.</p>'),
unistr('<p>Seleccione el marco temporal del informe (valor por defecto = 1 d\00EDa) en la parte superior de la p\00E1gina seg\00FAn sea necesario.<br>'),
unistr('Haga clic en las cabeceras de columna para ordenar y filtrar los datos, o bien haga clic en el bot\00F3n <strong>Acciones</strong> para personalizar la visualizaci\00F3n de columnas y otras muchas funciones avanzadas. Haga clic en el bot\00F3n <strong>Restablece')
||unistr('r</strong> para restablecer la configuraci\00F3n por defecto del informe interactivo.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276279267512866474)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Las notificaciones se muestran en la p\00E1gina inicial si est\00E1n activas.</p>'),
unistr('<p>En este informe se muestran las notificaciones definidas y el per\00EDodo de tiempo en que se muestran.</p>'),
unistr('<p>Haga clic en el icono de edici\00F3n (l\00E1piz de color amarillo) para editar una notificaci\00F3n existente o haga clic en <strong>Agregar notificaci\00F3n</strong> para insertar una nueva notificaci\00F3n.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276279500518866474)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Introduzca el nombre de la aplicaci\00F3n y una descripci\00F3n breve.</p>'),
unistr('<p>El nombre de la aplicaci\00F3n aparece en la p\00E1gina inicial. La descripci\00F3n breve aparece debajo del nombre de la aplicaci\00F3n.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276279710413866474)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Los usuarios finales pueden introducir comentarios en cualquier p\00E1gina normal de la aplicaci\00F3n.</p>'),
'<p>En este informe se muestran los comentarios introducidos, las respuestas que hayan introducido los administradores y el estado de los comentarios.</p>',
unistr('<p>Haga clic en el icono de edici\00F3n (l\00E1piz de color amarillo) para introducir una respuesta o actualizar el estado de los comentarios.</p>'),
unistr('<p><em><strong>Nota:</strong> Si se han definido los destinatarios de los comentarios, tambi\00E9n se mandar\00E1n por correo electr\00F3nico los env\00EDos de comentarios a las direcciones de correo electr\00F3nico de la lista de destinatarios de comentarios.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276295887036866484)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Proporcione una lista separada por comas de las direcciones de correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276279831200866474)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('<p><strong>Activar anexos</strong>: si se define esta opci\00F3n, los usuarios podr\00E1n cargar anexos complementarios a sus comentarios.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276280845583866475)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta p\00E1gina muestra las plantillas de correo electr\00F3nico definidas y cu\00E1ntas veces se ha hecho referencia a la plantilla en los correos electr\00F3nicos enviados.</p>'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276280641578866475)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>En esta p\00E1gina se muestran las plantillas de correo electr\00F3nico enviadas.</p>'),
unistr('<p>Haga clic en el icono de lupa para ver m\00E1s detalles en los mensajes enviados.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276280782696866475)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Introduzca los siguientes campos para definir una plantilla de correo electr\00F3nico:</p>'),
'<ul>',
'  <li><strong>Nombre de plantilla</strong> (obligatorio): introduzca un nombre significativo para la plantilla.</li>',
unistr('  <li><strong>Plantilla HTML</strong> (obligatorio): introduzca el c\00F3digo HTML utilizado para crear el correo electr\00F3nico enviado a los destinatarios que permiten la entrega de correos electr\00F3nicos basados en HTML.'),
unistr('    Los valores de sustituci\00F3n incluyen:'),
'    <ul>',
unistr('        <li><strong>#APP_NAME#</strong>: se sustituir\00E1 por el nombre de la aplicaci\00F3n</li>'),
unistr('        <li><strong>#BODY1#</strong>: se sustituir\00E1 por el valor transferido como p_body1_text</li> '),
unistr('        <li><strong>#TABLE#</strong>: se sustituir\00E1 por el valor transferido como p_table_content, utilizando HTML abierto de tabla, HTML abierto de fila y HTML cerrado de tabla</li> '),
unistr('        <li><strong>#BODY2#</strong>: se sustituir\00E1 por el valor transferido como p_body2_text</li> '),
unistr('        <li><strong>#ACTION#</strong>: se sustituir\00E1 por el valor transferido como p_action_label y p_action_link, utilizando la plantilla Enlace de acci\00F3n</li>'),
'     </ul></li>',
unistr('  <li><strong>Plantilla de texto sin formato</strong> (obligatorio): introduzca el texto sin formato utilizado para crear el correo electr\00F3nico enviado a los destinatarios que no aceptan correos electr\00F3nicos basados en HTML. Utiliza las mismas sustit')
||unistr('uciones que la plantilla HTML, excepto #TABLE# y #ACTION#, que se presentar\00E1n como texto sin formato.</li>'),
'<ul>',
unistr('<p>Las plantillas HTML adicionales permiten correos electr\00F3nicos m\00E1s avanzados. Estos elementos incluyen:</p>'),
'<ul>',
'  <li><strong>Antes de filas</strong>: introduzca HTML para sustituir #TABLE# en la plantilla HTML. Solo se utiliza si se transfiere p_table_content.</li>',
'  <li><strong>Plantilla de fila</strong>: introduzca HTML para presentar cada fila de la tabla. Esto incluye la apertura/cierre de la fila y la apertura/cierre de los datos mediante las sustituciones #LABEL# y #VALUE#.    Solo se utiliza si se transf'
||'iere p_table_content.</li>',
unistr('  <li><strong>Despu\00E9s de filas</strong>: introduzca HTML para cerrar la tabla o divisi\00F3n. Solo se utiliza si se transfiere p_table_content.</li>'),
unistr('  <li><strong>HTML de enlace de acci\00F3n</strong>: introduzca HTML para sustituir #ACTION# en la plantilla HTML. Debe contener #ACTION_LINK# y #ACTION_TEXT#. Solo se utiliza si se transfieren p_action_label y p_action_link.</li>'),
'</ul>',
unistr('<p><em><strong>Nota:</strong> utilice las entradas de la <strong>plantilla por defecto</strong> como un ejemplo para desarrollar su propia plantilla. La plantilla por defecto utiliza todas las variables de sustituci\00F3n que puede o no incluir en su pro')
||unistr('pia plantilla de correo electr\00F3nico.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276280991743866475)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Active o desactive el env\00EDo de correos electr\00F3nicos seleccionando una de las opciones de <strong>Distribuir correos electr\00F3nicos</strong>.</p>'),
unistr('<p>Introduzca la informaci\00F3n en <strong>Correos electr\00F3nicos enviados desde</strong> utilizando la direcci\00F3n de correo electr\00F3nico del contacto principal para los problemas de la aplicaci\00F3n. Este valor se puede utilizar o sobrescribir al utilizar la ')
||unistr('funci\00F3n de correo electr\00F3nico.</p>'),
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276299161097866487)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_language=>'es'
,p_message_text=>unistr('Direcci\00F3n que se utilizar\00E1 para enviar correos electr\00F3nicos. Se puede sobrescribir al utilizar la funci\00F3n de correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276317524563866498)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Rellene los siguientes elementos y haga clic en [Enviar correo electr\00F3nico]. Todos los correos electr\00F3nicos enviados se registrar\00E1n en el log de correo electr\00F3nico.'),
'    <ul>',
unistr('        <li><strong>De</strong>: si se define una "Direcci\00F3n de origen" en Configuraci\00F3n de correo electr\00F3nico, esa direcci\00F3n de correo electr\00F3nico ser\00E1 una opci\00F3n desde la que enviar el correo. Si la aplicaci\00F3n utiliza Direcciones de correo electr\00F3n')
||unistr('ico como nombre de usuario, puede enviar correos electr\00F3nicos desde su correo electr\00F3nico.  Por \00FAltimo, Enviar desde y Enviar a pueden ser la misma direcci\00F3n.</li>'),
unistr('        <li><strong>Enviar a</strong>: si la aplicaci\00F3n utiliza Direcciones de correo electr\00F3nico como nombre de usuario, puede enviar correos electr\00F3nicos a Direcciones de correo electr\00F3nico o a Usuarios.</li>'),
unistr('        <li><strong>Direcciones de correo electr\00F3nico</strong>: lista separada por comas de direcciones de correo electr\00F3nico que recibir\00E1n el correo electr\00F3nico. No se incluir\00E1n las direcciones no v\00E1lidas.</li>'),
unistr('        <li><strong>Rol</strong>: enviar correo electr\00F3nico a todos los usuarios de un rol seleccionado o a todos los usuarios definidos. La lista de selecci\00F3n incluye una lista de roles y el recuento de usuarios con ese rol.</li>'),
unistr('        <li><strong>Plantilla</strong>: seleccione la plantilla de correo electr\00F3nico que se va a utilizar para crear el cuerpo del correo electr\00F3nico.</li>'),
unistr('        <li><strong>Asunto</strong>: asunto del correo electr\00F3nico.</li>'),
unistr('        <li><strong>Cuerpo del correo electr\00F3nico</strong>: texto que se va a incluir como el cuerpo del correo electr\00F3nico.</li>'),
unistr('        <li><strong>Permitir exclusi\00F3n</strong>: algunos correos electr\00F3nicos se deben enviar, independientemente del usuario excluido para recibir correos electr\00F3nicos. Se incluyen los mensajes de interrupci\00F3n, entre otros. Este indicador identifica')
||unistr(' si este correo electr\00F3nico se debe excluir o si se debe enviar independientemente de las preferencias del usuario.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276319203207866499)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Rellene los siguientes elementos y haga clic en [Enviar correo electr\00F3nico]. Todos los correos electr\00F3nicos enviados se registrar\00E1n en el log de correo electr\00F3nico.'),
'    <ul>',
unistr('        <li><strong>De</strong>: si se define una "Direcci\00F3n de correo electr\00F3nico de origen" en Configuraci\00F3n de correo electr\00F3nico, esa direcci\00F3n de correo electr\00F3nico ser\00E1 una opci\00F3n desde la que enviar el correo. De lo contrario, Enviar de siempr')
||'e puede ser igual a Enviar a.</li>',
unistr('        <li><strong>Direcciones de correo electr\00F3nico</strong>: lista separada por comas de direcciones de correo electr\00F3nico que recibir\00E1n el correo electr\00F3nico. No se incluir\00E1n las direcciones no v\00E1lidas.</li>'),
unistr('        <li><strong>Plantilla</strong>: seleccione la plantilla de correo electr\00F3nico que se va a utilizar para crear el cuerpo del correo electr\00F3nico.</li>'),
unistr('        <li><strong>Asunto</strong>: asunto del correo electr\00F3nico.</li>'),
unistr('        <li><strong>Cuerpo del correo electr\00F3nico</strong>: texto que se va a incluir como el cuerpo del correo electr\00F3nico.</li>'),
unistr('        <li><strong>Permitir exclusi\00F3n</strong>: algunos correos electr\00F3nicos se deben enviar, independientemente del usuario excluido para recibir correos electr\00F3nicos. Se incluyen los mensajes de interrupci\00F3n, etc. Este indicador identifica si este')
||unistr(' correo electr\00F3nico se debe excluir o si se debe enviar independientemente de las preferencias del usuario.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276279650841866474)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Seleccione la zona horaria por defecto para todos los usuarios de esta aplicaci\00F3n.</p>'),
unistr('<p>Los distintos usuarios pueden sustituir este valor haciendo clic en su nombre de usuario (parte superior derecha) y seleccionando <strong>Preferencias</strong>. Tambi\00E9n pueden hacer clic en el enlace de zona horaria que aparece en la parte inferio')
||unistr('r de la p\00E1gina inicial.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276295575805866484)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'es'
,p_message_text=>unistr('A esta p\00E1gina no se puede acceder directamente mediante la interfaz de usuario. Se utiliza para facilitar la descarga de la fotograf\00EDa de perfil.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276295275346866484)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina Perfil de usuario permite ver la informaci\00F3n relevante sobre un usuario en una pantalla f\00E1cil de utilizar.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276294983560866484)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_language=>'es'
,p_message_text=>unistr('Cargue una fotograf\00EDa con un ratio de aspecto de cuadrado ya que, de no ser as\00ED, puede que aparezca distorsionada. El tama\00F1o de imagen recomendado es de 250 x 250 p\00EDxeles')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276281032884866475)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Esta pantalla \00A1le permite actualizar su informaci\00F3n personal y cargar una fotograf\00EDa o un avatar.</p>'),
unistr('<p>Para cargar una imagen, haga clic en <strong>Examinar</strong> o arrastre y suelte la imagen sobre el bot\00F3n.<br>'),
unistr('Cargue una fotograf\00EDa con un ratio de aspecto de cuadrado ya que, de no ser as\00ED, puede que aparezca distorsionada. El tama\00F1o de imagen recomendado es de 250 x 250 p\00EDxeles.</p>'),
'<p>Haga clic en <strong>Suprimir foto</strong> para eliminar la imagen.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276301128206866488)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_language=>'es'
,p_message_text=>unistr('Desde esta p\00E1gina se puede acceder a todo el texto de ayuda de la aplicaci\00F3n. Los enlaces de la regi\00F3n "Documentaci\00F3n" ofrecen una explicaci\00F3n mucho m\00E1s detallada de las funciones y la funcionalidad de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276282163818866476)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_language=>'es'
,p_message_text=>unistr('Puede definir las preferencias de la aplicaci\00F3n de su cuenta en esta p\00E1gina. Las preferencias pueden afectar a varios aspectos de la aplicaci\00F3n como la zona horaria. Haga clic en los iconos de ayuda de nivel de elemento para saber qu\00E9 funci\00F3n realiza')
||' cada preferencia.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275274257139865841)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Este informe muestra todos los correos electr\00F3nicos que esperan en cola a ser enviados, as\00ED como los que ya se han enviado.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275406164910865926)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_language=>'es'
,p_message_text=>unistr('<p>En este informe se incluyen todos los trabajos seleccionados que va a supervisar esta aplicaci\00F3n. Para obtener m\00E1s informaci\00F3n sobre cada trabajo, haga clic en el nombre del trabajo.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275412778894865930)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_language=>'es'
,p_message_text=>unistr('<p>En este informe se incluyen los detalles de ejecuci\00F3n sobre los trabajos seleccionados que va a supervisar esta aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276266417525866466)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar p\00E1gina Acerca de esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276282809920866476)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_language=>'es'
,p_message_text=>unistr('Defina esta opci\00F3n en No si no desea recibir mensajes de correo electr\00F3nico de esta aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276317009063866498)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Introduzca un t\00E9rmino de b\00FAsqueda en el cuadro de di\00E1logo de b\00FAsqueda y haga clic en <strong>Buscar</strong>.<br>'),
unistr('Haga clic en cualquiera de las cabeceras de resultados para navegar a ese registro espec\00EDfico.</p>'),
unistr('<p>Para limitar la b\00FAsqueda, desactive uno o m\00E1s or\00EDgenes, eliminando as\00ED ese informe de los resultados de la b\00FAsqueda</p>'),
unistr('<p>Haga clic en <strong>Restablecer</strong> para eliminar el t\00E9rmino de b\00FAsqueda actual y comprobar  todos los or\00EDgenes</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276282695267866476)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_language=>'es'
,p_message_text=>unistr('Defina la zona horaria que prefiera utilizar en toda la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275194734588865790)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_language=>'es'
,p_message_text=>'Elementos Ocultos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276302706850866489)
,p_name=>'CA.HOME'
,p_message_language=>'es'
,p_message_text=>'Inicio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276308867827866493)
,p_name=>'CA.HOME.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina Inicial')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276325233378866503)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_language=>'es'
,p_message_text=>unistr('Eventos de p\00E1gina por hora')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275273384996865840)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('Tama\00F1o de cuerpo HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276299573373866487)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276296218475866485)
,p_name=>'CA.IN.PROGRESS'
,p_message_language=>'es'
,p_message_text=>'En Curso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276321425002866500)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_language=>'es'
,p_message_text=>'Incluir en formularios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276321365506866500)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_language=>'es'
,p_message_text=>'Incluir en informes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276304991759866490)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_language=>'es'
,p_message_text=>'Instalando scripts de objetos de soporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275406822572865927)
,p_name=>'CA.INSTANCE.ID'
,p_message_language=>'es'
,p_message_text=>'Identificador de Instancia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275408010816865927)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_language=>'es'
,p_message_text=>'Persistencia de Instancia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276278600730866474)
,p_name=>'CA.INTRO.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Bienvenido a esta versi\00F3n preliminar solo para la nube de un nuevo m\00E9todo mejorado que permite crear una aplicaci\00F3n m\00E1s completa. El asistente de creaci\00F3n de aplicaciones est\00E1ndar solo permite seleccionar p\00E1ginas para generar, mientras que este as')
||unistr('istente tambi\00E9n permite cargar previamente una serie de funciones adicionales en la aplicaci\00F3n.</p>'),
unistr('<p>Las aplicaciones generadas con este asistente estar\00E1n totalmente soportadas y tambi\00E9n pueden incluir objetos de soporte para las funciones seleccionadas, como Control de acceso, Marco de correo electr\00F3nico, Comentarios, etc.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276278854901866474)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para empezar, introduzca un nombre de aplicaci\00F3n. A continuaci\00F3n, agregue una o m\00E1s p\00E1ginas a la misma. Compruebe las funciones que desee incluir. Realice las selecciones del aspecto de la aplicaci\00F3n y, a continuaci\00F3n, revise la configuraci\00F3n.<br>'),
unistr('Eso es todo. Solo tiene que hacer clic en <strong>Crear aplicaci\00F3n</strong>.</p>'),
unistr('<p>Haga clic en <strong>Ver plan detallado</strong> para reutilizar el modelo de una aplicaci\00F3n generada anteriormente o para replicar p\00E1ginas r\00E1pidamente.</p>'),
unistr('<p><em><strong>Nota:</strong> cada secci\00F3n y cada opci\00F3n ''Agregar p\00E1gina'' incluye ayuda detallada que le ayudar\00E1 m\00E1s adelante.</em></p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276278799372866474)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_language=>'es'
,p_message_text=>'Uso de este asistente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276313409052866495)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Los problemas significativos de la versi\00F3n en el momento de su lanzamiento son los siguientes:'),
'<ol>',
unistr('  <li>El Asistente de creaci\00F3n de aplicaciones desde el plan detallado no est\00E1 traducido.</li>'),
unistr('  <li>Las aplicaciones traducidas generadas con este asistente solo est\00E1n traducidas parcialmente.</li>'),
'  <li>Aumentar detalle en el informe solo permite una columna de aumento de detalle.</li>',
unistr('  <li>No se pueden generar p\00E1ginas de informe de filtro.</li>'),
unistr('  <li>La funci\00F3n de correo electr\00F3nico proporciona la API de nivel bajo, pero a\00FAn no incluye funciones de correo electr\00F3nico de nivel superior.</li>'),
unistr('  <li>La generaci\00F3n de una aplicaci\00F3n desde un plan detallado que hace referencia a tablas que faltan ser\00E1 incorrecta.</li>'),
unistr('  <li>Configuraci\00F3n avanzada: los formatos de fecha no se aplican a la aplicaci\00F3n generada.</li>'),
'</ol>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276313397687866495)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_language=>'es'
,p_message_text=>'Problemas conocidos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276279031159866474)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Publicada %0.</p>',
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276278921771866474)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Detalles de versi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276278514418866474)
,p_name=>'CA.INTRO.TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Creaci\00F3n de aplicaciones desde el Asistente de planes detallados {Vista previa solo de Cloud}')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276290120994866481)
,p_name=>'CA.IP.ADDRESS'
,p_message_language=>'es'
,p_message_text=>unistr('Direcci\00F3n IP')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276288349950866480)
,p_name=>'CA.IR.SEARCH'
,p_message_language=>'es'
,p_message_text=>unistr('B\00FAsqueda de IR')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276291375167866482)
,p_name=>'CA.IR.SEARCHES'
,p_message_language=>'es'
,p_message_text=>unistr('B\00FAsquedas de IR')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276319862172866499)
,p_name=>'CA.ITEMNAME'
,p_message_language=>'es'
,p_message_text=>'Nombre del Elemento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275410822082865929)
,p_name=>'CA.JOB.ACTION'
,p_message_language=>'es'
,p_message_text=>unistr('Acci\00F3n del Trabajo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275412328943865930)
,p_name=>'CA.JOB.CLASS'
,p_message_language=>'es'
,p_message_text=>'Clase de Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275411460081865930)
,p_name=>'CA.JOB.CREATOR'
,p_message_language=>'es'
,p_message_text=>'Creador del Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275412545363865930)
,p_name=>'CA.JOB.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre del Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275409049743865928)
,p_name=>'CA.JOB.PRIORITY'
,p_message_language=>'es'
,p_message_text=>'Prioridad del Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275406039621865926)
,p_name=>'CA.JOB.REPORTING'
,p_message_language=>'es'
,p_message_text=>'Informes de trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275448605345865956)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Ver estado y detalles de ejecuci\00F3n de los trabajos que soportan esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275412673027865930)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_language=>'es'
,p_message_text=>unistr('Detalles de Ejecuci\00F3n de Trabajo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275411546974865930)
,p_name=>'CA.JOB.STYLE'
,p_message_language=>'es'
,p_message_text=>'Estilo del Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275411694804865930)
,p_name=>'CA.JOB.SUBNAME'
,p_message_language=>'es'
,p_message_text=>'Subnombre del Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275410950897865929)
,p_name=>'CA.JOB.TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275407625491865927)
,p_name=>'CA.JOB.WEIGHT'
,p_message_language=>'es'
,p_message_text=>'Peso del Trabajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276320393359866500)
,p_name=>'CA.KEYCOLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna de Claves'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276322155162866501)
,p_name=>'CA.LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276320676546866500)
,p_name=>'CA.LABELCOLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna de etiquetas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276322342984866501)
,p_name=>'CA.LABELPLURAL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta: Plural'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276322015327866501)
,p_name=>'CA.LABELSINGULAR'
,p_message_language=>'es'
,p_message_text=>'Etiqueta: Singular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276277722988866473)
,p_name=>'CA.LANGUAGE'
,p_message_language=>'es'
,p_message_text=>'Idioma'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276277831878866473)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Seleccione el idioma principal para esta aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276312880999866495)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('<p>El idioma principal indica el idioma que se utiliza para mostrar las p\00E1ginas y componentes generados en el Creador de aplicaciones. La selecci\00F3n de varias traducciones proporcionar\00E1 opciones para los usuarios finales como qu\00E9 idioma utiliza la apl')
||unistr('icaci\00F3n que se presenta en tiempo de ejecuci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275557260100866026)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_language=>'es'
,p_message_text=>'Selector de Idioma'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276294740977866484)
,p_name=>'CA.LAST.NAME'
,p_message_language=>'es'
,p_message_text=>'Apellido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275411759809865930)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_language=>'es'
,p_message_text=>unistr('Duraci\00F3n de \00DAltima Ejecuci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275411825080865930)
,p_name=>'CA.LAST.START.DATE'
,p_message_language=>'es'
,p_message_text=>unistr('\00DAltima Fecha de Inicio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276325623607866503)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_language=>'es'
,p_message_text=>unistr('Actividad m\00E1s reciente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276321526624866500)
,p_name=>'CA.LISTOFVALUES'
,p_message_language=>'es'
,p_message_text=>'Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276316924161866498)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_language=>'es'
,p_message_text=>'Cargar plan detallado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275414105086865931)
,p_name=>'CA.LOG.DATE'
,p_message_language=>'es'
,p_message_text=>'Fecha de Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275414348264865931)
,p_name=>'CA.LOG.ID'
,p_message_language=>'es'
,p_message_text=>'Identificador de Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275408336759865928)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_language=>'es'
,p_message_text=>'Nivel de Registro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275195538826865790)
,p_name=>'CA.LOOKUP.COLUMNS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Columnas de consulta</strong>: ampl\00EDe para ver los atributos para definir una consulta de otra tabla. Utilice las columnas de consulta para sustituir los identificadores por una columna de visualizaci\00F3n (por ejemplo, puede mostrar el nom')
||unistr('bre de departamento en lugar del n\00FAmero de departamento).<br>'),
unistr('<em><strong>Nota:</strong>: Las columnas de consulta solo aparecen si la p\00E1gina actual se basa en una tabla o vista y tiene restricciones de clave ajena en otra tabla.'),
'  <ul>',
unistr('    <li><strong>Clave de consulta</strong>: seleccione la columna que desea modificar para que muestre la columna de visualizaci\00F3n.</li>'),
unistr('    <li><strong>Columna de visualizaci\00F3n</strong>: seleccione la columna (de la tabla de consulta) que desea que se muestre.</li>'),
'    &nbsp;<br>',
'    <em><strong>Nota:</strong>: Seleccione solo las columnas que hagan referencia a otra tabla (con una clave ajena).</em></li>',
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276298762495866486)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_language=>'es'
,p_message_text=>unistr('Gestionar plantillas de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276296781533866485)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_language=>'es'
,p_message_text=>'Gestionar Comentarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276292850450866483)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_language=>'es'
,p_message_text=>'Gestionar acceso de usuarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276326224970866503)
,p_name=>'CA.MASTER'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar p\00E1gina maestro/detalle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276326389340866503)
,p_name=>'CA.MASTER.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cree una p\00E1gina que muestre una p\00E1gina maestro-detalle que permita a los usuarios finales mantener los datos.<br>'),
'&nbsp;</p>',
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre de la p\00E1gina</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione el icono que se mostrar\00E1 en el men\00FA de navegaci\00F3n de esta p\00E1gina.</li>'),
unistr('  <li><strong>Tipo de p\00E1gina</strong>: seleccione el tipo de p\00E1gina [En paralelo, Apilado].<br>'),
'    <strong>En paralelo</strong>: <br>',
unistr('<em>Una \00FAnica p\00E1gina maestro-detalle que utiliza dise\00F1o en paralelo y regiones de informe con ventanas de edici\00F3n modal.</em>'),
'    <ul>',
unistr('      <li><strong>Tabla</strong> (obligatorio): seleccione la tabla maestra para la p\00E1gina.</li>'),
unistr('      <li><strong>Columna de visualizaci\00F3n primaria</strong> (obligatorio): seleccione la columna que desea mostrar en la lista de registros maestros.</li>'),
unistr('      <li><strong>Columna de visualizaci\00F3n secundaria</strong> (obligatorio): seleccione la columna que desea mostrar en la lista de registros maestros, en Columna de visualizaci\00F3n primaria.</li>.</li>'),
unistr('      <li><strong>Tabla de detalle 1</strong> (obligatorio): seleccione la primera tabla de detalle para la p\00E1gina.</li>'),
unistr('      <li><strong>Tabla de detalle 2</strong>: seleccione la segunda tabla de detalle para la p\00E1gina.</li>'),
unistr('      <li><strong>Tabla de detalle 3</strong>: seleccione la tercera tabla de detalle para la p\00E1gina.</li>'),
unistr('      <li><strong>Tabla de detalle 4</strong>: seleccione la cuarta tabla de detalle para la p\00E1gina.</li>'),
'    </ul>',
'   <strong>Apilado</strong>: <br>',
unistr('<em>Una \00FAnica p\00E1gina maestro-detalle que utiliza cuadr\00EDculas interactivas editables.</em>'),
'    <ul>',
unistr('      <li><strong>Tabla</strong> (obligatorio): seleccione la tabla maestra para la cuadr\00EDcula interactiva editable.</li>'),
unistr('      <li><strong>Tabla de detalles</strong> (obligatorio): seleccione la tabla de detalles para la p\00E1gina.</li>'),
unistr('      <em><strong>Nota:</strong> Solo se puede agregar una tabla de detalles (cuadr\00EDcula interactiva editable) con el asistente. Tras la generaci\00F3n, se pueden agregar m\00E1s tablas de detalles f\00E1cilmente.</em>'),
'    </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275557106094866026)
,p_name=>'CA.MASTER_RECORDS'
,p_message_language=>'es'
,p_message_text=>'Registros maestros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276289093813866480)
,p_name=>'CA.MAX.ELAPSED'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1ximo transcurrido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275408886117865928)
,p_name=>'CA.MAX.FAILURES'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1ximo de Fallos')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275408450960865928)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_language=>'es'
,p_message_text=>unistr('Duraci\00F3n m\00E1xima de ejecuci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275408949652865928)
,p_name=>'CA.MAX.RUNS'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1ximo de Ejecuciones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276320569429866500)
,p_name=>'CA.MAXIMUMROWS'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1ximo de Filas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276323595770866502)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_language=>'es'
,p_message_text=>unistr('Ancho M\00E1ximo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276314114696866496)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_language=>'es'
,p_message_text=>'Agregar filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276314557255866496)
,p_name=>'CA.MD.ADD.ROW'
,p_message_language=>'es'
,p_message_text=>'Agregar %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276314001867866496)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_language=>'es'
,p_message_text=>'Aplicar Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276314947472866496)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_language=>'es'
,p_message_text=>'Valor de Fecha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276315039407866496)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_language=>'es'
,p_message_text=>'Valor de Fecha 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276314234452866496)
,p_name=>'CA.MD.EDIT'
,p_message_language=>'es'
,p_message_text=>'Editar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276313623323866496)
,p_name=>'CA.MD.FILTER'
,p_message_language=>'es'
,p_message_text=>'Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276313539538866495)
,p_name=>'CA.MD.FILTERS'
,p_message_language=>'es'
,p_message_text=>'Filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276314626421866496)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_language=>'es'
,p_message_text=>'Sin filtros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276313927071866496)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha seleccionado ning\00FAn registro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276313880610866496)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_language=>'es'
,p_message_text=>'No se han encontrado registros'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276314432560866496)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_language=>'es'
,p_message_text=>'%0 suprimido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276314370678866496)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_language=>'es'
,p_message_text=>'%0 actualizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276313751583866496)
,p_name=>'CA.MD.SEARCH'
,p_message_language=>'es'
,p_message_text=>'Buscar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276314721372866496)
,p_name=>'CA.MD.VALUE'
,p_message_language=>'es'
,p_message_text=>'Valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276314843127866496)
,p_name=>'CA.MD.VALUE.2'
,p_message_language=>'es'
,p_message_text=>'Valor 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276288586879866480)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_language=>'es'
,p_message_text=>'Mediana Transcurrida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276297682147866486)
,p_name=>'CA.MESSAGE'
,p_message_language=>'es'
,p_message_text=>'Mensaje'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276323032485866501)
,p_name=>'CA.METRIC'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E9trica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276289492863866480)
,p_name=>'CA.MIN.ELAPSED'
,p_message_language=>'es'
,p_message_text=>unistr('M\00EDnimo transcurrido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276292219685866482)
,p_name=>'CA.MOBILE.PHONE'
,p_message_language=>'es'
,p_message_text=>unistr('Tel\00E9fono m\00F3vil')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276288046257866480)
,p_name=>'CA.MODE'
,p_message_language=>'es'
,p_message_text=>'Modo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276301802902866488)
,p_name=>'CA.MORE'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276291480565866482)
,p_name=>'CA.MOST RECENT'
,p_message_language=>'es'
,p_message_text=>'Most_Recent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276325448454866503)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1ginas con Mayor Actividad')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275195613041865790)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_language=>'es'
,p_message_text=>'Informes varios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275195780227865790)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Marque uno o m\00E1s nombres de tabla o vista. Tambi\00E9n puede hacer clic en la casilla de control de la cabecera para seleccionar o anular la selecci\00F3n de todos los objetos de base de datos mostrados.</p>'),
unistr('<p>Se agregar\00E1 una p\00E1gina con un informe interactivo para cada objeto de base de datos marcado.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276285443783866478)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_language=>'es'
,p_message_text=>unistr('#LABEL# debe ser un registro de hora v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276322884494866501)
,p_name=>'CA.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276276946876866473)
,p_name=>'CA.NAVIGATION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276277008218866473)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Seleccione si el men\00FA se muestra en el lateral de la aplicaci\00F3n o en la parte superior de la misma.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276329595983866505)
,p_name=>'CA.NEGATIVE'
,p_message_language=>'es'
,p_message_text=>'Negativa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276329499357866505)
,p_name=>'CA.NEUTRAL'
,p_message_language=>'es'
,p_message_text=>'Normal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276315568035866497)
,p_name=>'CA.NEXT'
,p_message_language=>'es'
,p_message_text=>'Siguiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275408621364865928)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_language=>'es'
,p_message_text=>unistr('Fecha de la Siguiente Ejecuci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275407579566865927)
,p_name=>'CA.NLS.ENV'
,p_message_language=>'es'
,p_message_text=>'Entorno NLS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275505348277865994)
,p_name=>'CA.NO'
,p_message_language=>'es'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276296375762866485)
,p_name=>'CA.NO.ACTION'
,p_message_language=>'es'
,p_message_text=>unistr('Ninguna Acci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276307978305866492)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_language=>'es'
,p_message_text=>unistr('No hay ayuda disponible para esta p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275194818357865790)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'es'
,p_message_text=>unistr('No existen usuarios v\00E1lidos - Informaci\00F3n de p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276316595880866497)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se han encontrado usuarios nuevos no v\00E1lidos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276312632044866495)
,p_name=>'CA.NONE'
,p_message_language=>'es'
,p_message_text=>'Ninguno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276292550794866482)
,p_name=>'CA.NOTE'
,p_message_language=>'es'
,p_message_text=>'Nota'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276268038635866467)
,p_name=>'CA.NOTIFICATION'
,p_message_language=>'es'
,p_message_text=>'Notificaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276266828642866466)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Mostrar notificaciones en la p\00E1gina inicial')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276268111158866467)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite a los administradores de la aplicaci\00F3n especificar alertas (amarillo) o errores (rojo) que se muestran a todos los usuarios finales en la p\00E1gina inicial de la aplicaci\00F3n. Esta funci\00F3n es \00FAtil para transmitir informaci\00F3n importante a su com')
||'unidad de usuarios finales.</p>',
'<p>Incluye los siguientes componentes:<ul>',
'<li>Capacidad de definir notificaciones</li>',
unistr('<li>Visualizaci\00F3n de notificaci\00F3n en la p\00E1gina inicial de la aplicaci\00F3n</li>'),
unistr('<li>Capacidad de controlar la ventana de tiempo de la visualizaci\00F3n de notificaciones</li>'),
unistr('<li>Soporte de codificaci\00F3n de color de notificaciones por tipo</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276284742008866478)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276288285152866480)
,p_name=>'CA.NUM.ROWS'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de Filas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275410733830865929)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de argumentos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275407338401865927)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de Destinos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276321029374866500)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1scara Formato Num\00E9rico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276289741278866481)
,p_name=>'CA.OCCURRENCE'
,p_message_language=>'es'
,p_message_text=>'Incidencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276329762473866506)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('No puede realizar esta acci\00F3n a menos que haya otro administrador.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276296502703866485)
,p_name=>'CA.OPEN'
,p_message_language=>'es'
,p_message_text=>'Abrir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276269582264866468)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('Organizaci\00F3n de p\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276269889665866468)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Organice las p\00E1ginas en el orden en el que desea que aparezcan en la aplicaci\00F3n. <br>'),
unistr('Para reordenar las p\00E1ginas en la lista, haga clic y pulse el icono <em>Arrastrar para reordenar p\00E1gina</em> ( <span class="fa fa-bars" aria-hidden="true"></span> ) al final de cada listado de p\00E1ginas y, a continuaci\00F3n, arrastre y suelte esa p\00E1gina ha')
||'cia arriba o hacia abajo.</p>',
unistr('<p>La p\00E1gina inicial siempre aparece primero y no se puede reordenar.<br>'),
unistr('Las p\00E1ginas administrativas siempre aparecen al final de la lista y el orden indicar\00E1 el orden en el que aparecen en la lista Administraci\00F3n de aplicaciones de la p\00E1gina Administraci\00F3n.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275412853782865930)
,p_name=>'CA.OUTPUT'
,p_message_language=>'es'
,p_message_text=>'Salida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275414038725865931)
,p_name=>'CA.OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276287953904866480)
,p_name=>'CA.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276291191112866482)
,p_name=>'CA.PAGE.EVENTS'
,p_message_language=>'es'
,p_message_text=>unistr('Eventos de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276303662849866489)
,p_name=>'CA.PAGE.HELP'
,p_message_language=>'es'
,p_message_text=>unistr('Ayuda de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276290273739866481)
,p_name=>'CA.PAGE.ITEM'
,p_message_language=>'es'
,p_message_text=>unistr('Elemento de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275559157111866028)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_language=>'es'
,p_message_text=>'Editar registro maestro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275559305660866028)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_language=>'es'
,p_message_text=>unistr('Realizar B\00FAsqueda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276287525099866479)
,p_name=>'CA.PAGE.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de la P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276302971507866489)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegaci\00F3n de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276289639981866481)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_language=>'es'
,p_message_text=>unistr('Rendimiento de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276315686663866497)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_language=>'es'
,p_message_text=>unistr('El tipo de p\00E1gina "%0" no es de un tipo v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276288961725866480)
,p_name=>'CA.PAGE.VIEWS'
,p_message_language=>'es'
,p_message_text=>unistr('Vistas de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276270045033866468)
,p_name=>'CA.PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276270154302866468)
,p_name=>'CA.PAGES.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Defina p\00E1ginas para incluirlas en su aplicaci\00F3n inicial. Debe definir al menos una p\00E1gina para poder crear posteriormente la aplicaci\00F3n.</p>'),
unistr('<p>Puede eliminar la aplicaci\00F3n si crea cualquier cantidad de p\00E1ginas con este asistente. Una vez que haya creado la aplicaci\00F3n, utilice el asistente de creaci\00F3n de p\00E1ginas para agregar m\00E1s p\00E1ginas.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276320989922866500)
,p_name=>'CA.PAGINATIONMETHOD'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E9todo de paginaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276289234957866480)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_language=>'es'
,p_message_text=>unistr('Vistas de p\00E1ginas parciales')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276295077342866484)
,p_name=>'CA.PHOTO'
,p_message_language=>'es'
,p_message_text=>'Foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276295688331866484)
,p_name=>'CA.PHOTO.DELETED'
,p_message_language=>'es'
,p_message_text=>unistr('Fotograf\00EDa suprimida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276295171877866484)
,p_name=>'CA.PHOTO.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de fotograf\00EDa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276294854341866484)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_language=>'es'
,p_message_text=>unistr('Carga de fotograf\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276299692537866487)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla de texto sin formato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276329372312866505)
,p_name=>'CA.POSITIVE'
,p_message_language=>'es'
,p_message_text=>'Positiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276282466910866476)
,p_name=>'CA.PREFERENCES'
,p_message_language=>'es'
,p_message_text=>'Preferencias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276326950597866504)
,p_name=>'CA.PREVIOUS'
,p_message_language=>'es'
,p_message_text=>'Anterior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276321639654866501)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna de visualizaci\00F3n primaria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276322574433866501)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna de Clave Primaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276322638797866501)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_language=>'es'
,p_message_text=>'Tabla principal primaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276289877188866481)
,p_name=>'CA.PROCEDURE'
,p_message_language=>'es'
,p_message_text=>'Procedimiento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276283029603866477)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_language=>'es'
,p_message_text=>unistr('La preferencia de correo electr\00F3nico se ha actualizado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275558773006866027)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_language=>'es'
,p_message_text=>'Recuperar fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276284246527866477)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha guardado la configuraci\00F3n de aspecto de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276282991759866476)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_language=>'es'
,p_message_text=>'La preferencia de zona horaria se ha actualizado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276295480779866484)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'es'
,p_message_text=>unistr('Descarga de fotograf\00EDa de perfil')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275411006255865929)
,p_name=>'CA.PROGRAM.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre del Programa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275411135724865929)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario del Programa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276321913059866501)
,p_name=>'CA.QUERY'
,p_message_language=>'es'
,p_message_text=>'Consulta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275407874036865927)
,p_name=>'CA.RAISE.EVENTS'
,p_message_language=>'es'
,p_message_text=>'Iniciar Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275039656074865688)
,p_name=>'CA.RATING'
,p_message_language=>'es'
,p_message_text=>unistr('Calificaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276293307238866483)
,p_name=>'CA.READERS'
,p_message_language=>'es'
,p_message_text=>'Lectores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276282784728866476)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_language=>'es'
,p_message_text=>unistr('Recibir correos electr\00F3nicos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276325513971866503)
,p_name=>'CA.RECENT.ERRORS'
,p_message_language=>'es'
,p_message_text=>'Errores Recientes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276065934609866340)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276066049366866341)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_language=>'es'
,p_message_text=>'Valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276284985648866478)
,p_name=>'CA.RED'
,p_message_language=>'es'
,p_message_text=>'Rojo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276298572861866486)
,p_name=>'CA.REFERENCED'
,p_message_language=>'es'
,p_message_text=>'Con Referencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275557870129866027)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Refrescar p\00E1gina de administraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275175278620865777)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_language=>'es'
,p_message_text=>unistr('Refrescar al cerrar el cuadro de di\00E1logo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275559201146866028)
,p_name=>'CA.REFRESH_REPORT'
,p_message_language=>'es'
,p_message_text=>'Informe de Refrescamiento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276284466432866477)
,p_name=>'CA.REGION.BUTTONS'
,p_message_language=>'es'
,p_message_text=>unistr('Regi\00F3n de botones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276284307040866477)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('Regi\00F3n de elementos de pantalla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276290341801866481)
,p_name=>'CA.REGION.ID'
,p_message_language=>'es'
,p_message_text=>unistr('Identificador de Regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276302362320866488)
,p_name=>'CA.RELEASE'
,p_message_language=>'es'
,p_message_text=>unistr('Versi\00F3n %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276269697342866468)
,p_name=>'CA.REMOVING.PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('Eliminaci\00F3n de p\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276269737259866468)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Haga clic en <strong>Editar</strong> para seleccionar la p\00E1gina y, a continuaci\00F3n, en <strong>Suprimir p\00E1gina</strong> para eliminar una p\00E1gina de la aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275412404380865930)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_language=>'es'
,p_message_text=>unistr('Intervalo de Repetici\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275273923310865841)
,p_name=>'CA.REPLY.TO'
,p_message_language=>'es'
,p_message_text=>'Responder a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276275400067866472)
,p_name=>'CA.REPORT'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar p\00E1gina de informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276275345854866471)
,p_name=>'CA.REPORT.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cree una p\00E1gina que se muestre como informe interactivo o informe cl\00E1sico.</p>'),
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre de la p\00E1gina</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione el icono que desea mostrar en el men\00FA de navegaci\00F3n de la p\00E1gina.</li>'),
'  <li><strong>Tipo de consulta</strong>: seleccione el origen del informe [<strong>Tabla o vista</strong> o <strong>Consulta SQL</strong>]:<br>',
'    <strong>Tabla o vista</strong>:',
'    <ul>',
'      <li>Tabla o vista (obligatorio): seleccione el objeto de base de datos para el informe.</li>',
unistr('      <li>Incluir pantalla: active esta opci\00F3n si desea que se genere una p\00E1gina de pantalla enlazada que permita a los usuarios mantener los valores de la tabla.</li>'),
'    </ul>',
'    <strong>Consulta SQL</strong>:',
'    <ul>',
unistr('      <li>Consulta SQL (obligatorio): introduzca una sentencia SQL v\00E1lida que devuelva columnas distintas.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>Tipo de informe</strong>: seleccione el tipo de informe (<strong>Informe interactivo</strong> o <strong>Informe cl\00E1sico</strong>).</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276267144096866466)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_language=>'es'
,p_message_text=>'%0 con pantalla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276111982659866369)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_language=>'es'
,p_message_text=>'Informe %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276324637184866502)
,p_name=>'CA.REPORT.VIEW'
,p_message_language=>'es'
,p_message_text=>'Vista de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276323212739866502)
,p_name=>'CA.REPORTS'
,p_message_language=>'es'
,p_message_text=>'Informes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275413890518865931)
,p_name=>'CA.REQ.START.DATE'
,p_message_language=>'es'
,p_message_text=>'Fecha de Inicio Solicitada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276323467861866502)
,p_name=>'CA.REQUIRED'
,p_message_language=>'es'
,p_message_text=>'Necesario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276300473389866487)
,p_name=>'CA.RESET'
,p_message_language=>'es'
,p_message_text=>'Restablecer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276296473365866485)
,p_name=>'CA.RESOLVED'
,p_message_language=>'es'
,p_message_text=>'Resuelta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276296128637866485)
,p_name=>'CA.RESPONSE'
,p_message_language=>'es'
,p_message_text=>'Respuesta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275409172263865928)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_language=>'es'
,p_message_text=>'Reiniciar si Hay Fallos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275409278512865928)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_language=>'es'
,p_message_text=>'Reiniciar si Hay Recuperaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275406415169865926)
,p_name=>'CA.RESTARTABLE'
,p_message_language=>'es'
,p_message_text=>'Reiniciable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275408782987865928)
,p_name=>'CA.RETRY.COUNT'
,p_message_language=>'es'
,p_message_text=>'Recuento de Reintentos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276318448479866499)
,p_name=>'CA.ROLE'
,p_message_language=>'es'
,p_message_text=>'Rol'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276290520653866481)
,p_name=>'CA.ROW.NUMBER'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de Fila')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276299884633866487)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla de Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276317893629866498)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_language=>'es'
,p_message_text=>'HTML de plantilla de fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276319147635866499)
,p_name=>'CA.ROWS.CONTENT'
,p_message_language=>'es'
,p_message_text=>'Contenido de filas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276291228204866482)
,p_name=>'CA.ROWS.FETCHED'
,p_message_language=>'es'
,p_message_text=>'Filas Recuperadas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276320834654866500)
,p_name=>'CA.ROWSPERPAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Filas por P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275412069652865930)
,p_name=>'CA.RUN.COUNT'
,p_message_language=>'es'
,p_message_text=>'Recuento de Ejecuciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275413643179865931)
,p_name=>'CA.RUN.DURATION'
,p_message_language=>'es'
,p_message_text=>unistr('Duraci\00F3n de Ejecuci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275408583466865928)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_language=>'es'
,p_message_text=>unistr('L\00EDmite de Programaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275410520047865929)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de Programaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275410637425865929)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_language=>'es'
,p_message_text=>unistr('Propietario de Programaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275410470898865929)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de Programaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276277996960866473)
,p_name=>'CA.SCHEMA'
,p_message_language=>'es'
,p_message_text=>'Esquema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276278037134866473)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Seleccione el esquema de base de datos que almacena los objetos de base de datos que desea utilizar en esta aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276319908606866499)
,p_name=>'CA.SCOPE'
,p_message_language=>'es'
,p_message_text=>unistr('\00C1mbito')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276300592987866487)
,p_name=>'CA.SEARCH'
,p_message_language=>'es'
,p_message_text=>'Buscar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276300628016866487)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Buscar Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276300751502866487)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_language=>'es'
,p_message_text=>unistr('B\00FAsqueda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276324857145866503)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_language=>'es'
,p_message_text=>unistr('Filtros de B\00FAsqueda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276307428157866492)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Esta p\00E1gina se controla desde la lista Componentes compartidos denominada Tablas buscadas.'),
'',
unistr('Cualquier p\00E1gina Informe interactivo inicialmente generada desde el Asistente de creaci\00F3n de aplicaciones se agregar\00E1 autom\00E1ticamente a la lista. '),
unistr('Para agregar sus propias tablas a la lista, vaya a Componentes compartidos, seleccione Listas y, a continuaci\00F3n, haga clic en Tablas buscadas.'),
'  Introduzca los siguientes atributos:',
'    Entrada: Etiqueta de entrada de lista - introduzca el nombre mostrado de la tabla.',
unistr('    Destino: P\00E1gina - seleccione la p\00E1gina adecuada a la que acceder (preferiblemente Informe interactivo)'),
unistr('    Destino: Borrar cach\00E9 - introduzca cualquier p\00E1gina que sea necesario borrar (generalmente el mismo n\00FAmero introducido en P\00E1gina).'),
unistr('       Si accede a la p\00E1gina Informe interactivo, a continuaci\00F3n, agregue CIR,RIR para borrar cualquier filtro existente y as\00ED sucesivamente.'),
unistr('    Destino: Definir estos elementos - seleccione (o introduzca) el elemento de p\00E1gina adecuado que se va a rellenar.'),
unistr('       Si accede a la p\00E1gina Informe interactivo, introduzca IR_[COLUMN_NAME].'),
'    Destino: Con estos valores - introduzca =PK=',
unistr('    Atributos definidos por el usuario: 1 - introduzca el nombre de la tabla que desea buscar en may\00FAsculas.'),
unistr('    Atributos definidos por el usuario: 2 - introduzca el nombre de la columna principal en may\00FAsculas.'),
'    Atributos definidos por el usuario: 3 (opcional) - lista separada por comas de las columnas que se van a buscar.',
unistr('       Si no se especifica ninguna columna, se buscar\00E1 todo el texto (varchar2) y las columnas de objeto grande de caracteres (clob).'),
'',
unistr('Nota: solo aparecer\00E1 para los usuarios una lista de las tablas disponibles para la b\00FAsqueda si aparece m\00E1s de una tabla.')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276300241904866487)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_language=>'es'
,p_message_text=>unistr('Resultados de la B\00FAsqueda')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276322496553866501)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna de visualizaci\00F3n secundaria')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276296811501866485)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla Seleccionada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275273201856865840)
,p_name=>'CA.SEND.BEGIN'
,p_message_language=>'es'
,p_message_text=>unistr('Inicio de env\00EDo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275273657675865840)
,p_name=>'CA.SEND.COUNT'
,p_message_language=>'es'
,p_message_text=>unistr('Recuento de env\00EDos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275273111085865840)
,p_name=>'CA.SEND.END'
,p_message_language=>'es'
,p_message_text=>unistr('Final de env\00EDo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275273521119865840)
,p_name=>'CA.SEND.ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error de env\00EDo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276328426046866505)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_language=>'es'
,p_message_text=>unistr('Enviar mensajes de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276328529884866505)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_language=>'es'
,p_message_text=>'Determina si se deben enviar mensajes si se reciben nuevos comentarios.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276325137611866503)
,p_name=>'CA.SEND.FROM'
,p_message_language=>'es'
,p_message_text=>unistr('Origen de env\00EDo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276317631401866498)
,p_name=>'CA.SEND.TO'
,p_message_language=>'es'
,p_message_text=>unistr('Destino de env\00EDo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276302143089866488)
,p_name=>'CA.SERIES'
,p_message_language=>'es'
,p_message_text=>'Series %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275413578037865931)
,p_name=>'CA.SESSION.ID'
,p_message_language=>'es'
,p_message_text=>unistr('Identificador de Sesi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276320104004866500)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_language=>'es'
,p_message_text=>unistr('Protecci\00F3n de Estado de la Sesi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276277352753866473)
,p_name=>'CA.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276277468150866473)
,p_name=>'CA.SETTINGS.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Especifique la configuraci\00F3n utilizada en la generaci\00F3n de la aplicaci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276301721253866488)
,p_name=>'CA.SHOW.ALL'
,p_message_language=>'es'
,p_message_text=>'Mostrar Todo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275174433368865777)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_language=>'es'
,p_message_text=>unistr('Mostrar/ocultar \00E1mbito')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276302874145866489)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_language=>'es'
,p_message_text=>'Mostrar zona horaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276302692880866489)
,p_name=>'CA.SIGN.IN'
,p_message_language=>'es'
,p_message_text=>'Conectar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276303842834866489)
,p_name=>'CA.SIGN.OUT'
,p_message_language=>'es'
,p_message_text=>'Desconectar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275413413199865931)
,p_name=>'CA.SLAVE.PID'
,p_message_language=>'es'
,p_message_text=>'PID Esclavo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275407498997865927)
,p_name=>'CA.SOURCE'
,p_message_language=>'es'
,p_message_text=>'Origen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276315701378866497)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_language=>'es'
,p_message_text=>unistr('El tipo de origen no es de un tipo v\00E1lido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276307535415866492)
,p_name=>'CA.SOURCES'
,p_message_language=>'es'
,p_message_text=>unistr('Or\00EDgenes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275410325955865929)
,p_name=>'CA.START.DATE'
,p_message_language=>'es'
,p_message_text=>'Fecha de Inicio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275412196672865930)
,p_name=>'CA.STATE'
,p_message_language=>'es'
,p_message_text=>'Estado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276323364926866502)
,p_name=>'CA.STATICDEFAULT'
,p_message_language=>'es'
,p_message_text=>unistr('Valor est\00E1tico por defecto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276286574878866479)
,p_name=>'CA.STATUS'
,p_message_language=>'es'
,p_message_text=>'Estado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275408198663865927)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_language=>'es'
,p_message_text=>'Parar al Cerrar Ventana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275408207798865928)
,p_name=>'CA.STORE.OUTPUT'
,p_message_language=>'es'
,p_message_text=>'Almacenar salida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276297032972866485)
,p_name=>'CA.SUBJECT'
,p_message_language=>'es'
,p_message_text=>'Asunto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276295786650866484)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_language=>'es'
,p_message_text=>'Enviar Comentarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276320407346866500)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_language=>'es'
,p_message_text=>unistr('Visualizaci\00F3n sugerida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276312313603866495)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_language=>'es'
,p_message_text=>'Objetos de Soporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276312429249866495)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('<p>Introduzca el c\00F3digo en el script de instalaci\00F3n, generalmente para crear o manipular los objetos de base de datos o realizar inserciones / actualizaciones / supresiones en los registros existentes. Introduzca el c\00F3digo en la desinstalaci\00F3n, gener')
||unistr('almente para eliminar (borrar) objetos de base de datos. Estos scripts se incorporar\00E1n a los objetos de compatibilidad para que cuando se exporte la aplicaci\00F3n, se realicen estas mismas actualizaciones en los entornos de prueba y producci\00F3n.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276312577586866495)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Introduzca sentencias SQL y/o PL/SQL v\00E1lidas en el script de instalaci\00F3n que se ejecutan al importar la aplicaci\00F3n.</p>'),
unistr('<p>Si desea que estas sentencias tambi\00E9n se ejecuten en el entorno actual y no solo cuando la aplicaci\00F3n se importe a otro entorno, haga clic en <strong>Ejecutar al crear la aplicaci\00F3n</strong>.</p>'),
unistr('<p>Introduzca sentencias SQL y/o PL/SQL v\00E1lidas en el script de desinstalaci\00F3n que se ejecutan cuando la aplicaci\00F3n se suprime del Creador de aplicaciones.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275407782870865927)
,p_name=>'CA.SYSTEM'
,p_message_language=>'es'
,p_message_text=>'Sistema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276321870223866501)
,p_name=>'CA.TABLE'
,p_message_language=>'es'
,p_message_text=>'Tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276278148590866473)
,p_name=>'CA.TABLE.PREFIX'
,p_message_language=>'es'
,p_message_text=>'Prefijo de objeto de marco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276278265081866473)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Introduzca el prefijo de objeto que utilizar\00E1 la aplicaci\00F3n. Algunas funciones agregan este prefijo a los objetos de base de datos que crean (incluidos los paquetes y las tablas).</p>'),
unistr('<p>Advertencia: Aseg\00FArese de que introduce un prefijo \00FAnico que no est\00E9n utilizando otras aplicaciones. Si no es \00FAnico, la aplicaci\00F3n puede detectar errores cuando se est\00E9n creando y no funcionar correctamente.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276322712263866501)
,p_name=>'CA.TABLECOLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna de tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276317713897866498)
,p_name=>'CA.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276300117599866487)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('Este nombre de plantilla ya est\00E1 en uso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276296955542866485)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de la Plantilla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276285680830866478)
,p_name=>'CA.TEXT'
,p_message_language=>'es'
,p_message_text=>'Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275273414511865840)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('Tama\00F1o de cuerpo de texto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276298127925866486)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla de texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276283841923866477)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_language=>'es'
,p_message_text=>'Preferencia de tema de usuario final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276284080137866477)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_language=>'es'
,p_message_text=>'Si se activa, los usuarios finales pueden seleccionar su propio estilo con el enlace Personalizar.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276283953032866477)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_language=>'es'
,p_message_text=>'Permitir a los usuarios finales seleccionar el estilo de tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276268223460866467)
,p_name=>'CA.THEME.SELECTOR'
,p_message_language=>'es'
,p_message_text=>unistr('Selecci\00F3n de estilo de tema')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276266604512866466)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_language=>'es'
,p_message_text=>unistr('Actualizar interfaz de usuario por defecto de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276268303204866467)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite a los administradores seleccionar un esquema de color (estilo de tema) por defecto para la aplicaci\00F3n. Los administradores tambi\00E9n pueden elegir si permitir a los usuarios finales seleccionar su propio estilo de tema. Los usuarios finales ')
||unistr('pueden simplemente hacer clic en el bot\00F3n <em>Personalizar</em> de la parte inferior de la p\00E1gina inicial y seleccionar uno de los estilos de tema disponibles. Por ejemplo, los usuarios con discapacidad visual tal vez prefieran utilizar el estilo de ')
||'tema <em>Vista</em> que tiene un contraste de color mucho mayor.</p>',
'<p>Incluye los siguientes componentes:',
'<ul>',
'<li>Permite a los administradores definir el estilo de tema por defecto</li>',
'<li>Permite a los usuarios finales seleccionar varios estilos de tema</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276276741642866472)
,p_name=>'CA.THEME.STYLE'
,p_message_language=>'es'
,p_message_text=>'Estilo de Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276276853882866472)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Seleccione el estilo de tema por defecto utilizado para mostrar la aplicaci\00F3n.</p>'),
unistr('<p>El estilo se puede cambiar f\00E1cilmente por otro estilo predefinido o modificarse tras la generaci\00F3n. Para cambiar el estilo, ejecute la aplicaci\00F3n y, a continuaci\00F3n, haga clic en <strong>Acumulador de tema</strong> en la barra de herramientas del d')
||'esarrollador.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276290832197866481)
,p_name=>'CA.TIME'
,p_message_language=>'es'
,p_message_text=>'Hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276282559175866476)
,p_name=>'CA.TIME.ZONE'
,p_message_language=>'es'
,p_message_text=>'Zona Horaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276269380834866468)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_language=>'es'
,p_message_text=>'Soporte de Zona Horaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276266239643866466)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_language=>'es'
,p_message_text=>'Definir zonas horarias por defecto y del usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276269023528866467)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite a los usuarios finales definir su zona horaria local. Es importante si en las tablas de aplicaci\00F3n se utilizan los tipos de fecha que aplican zona horaria (como Registro de hora con zona horaria local) para que los informes y la entrada de')
||unistr(' datos reflejen d\00F3nde est\00E1n los usuarios finales.</p>'),
'<p>Incluye los siguientes componentes:',
'<ul>',
'<li>Permite a los administradores definir la zona horaria por defecto</li>',
'<li>Permite a los usuarios finales seleccionar su preferencia de zona horaria</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276325792336866503)
,p_name=>'CA.TIMEFRAME'
,p_message_language=>'es'
,p_message_text=>'Marco temporal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276326042649866503)
,p_name=>'CA.TIMELINE'
,p_message_language=>'es'
,p_message_text=>unistr('Agregar p\00E1gina de cronolog\00EDa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276326190691866503)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cree una p\00E1gina que muestre una cronolog\00EDa especialmente \00FAtil para mostrar actualizaciones.</p>'),
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre de p\00E1gina</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione un icono para mostrar en el men\00FA de navegaci\00F3n de la p\00E1gina.</li>'),
unistr('  <li><strong>Tabla o vista</strong> (obligatorio): seleccione el objeto de base de datos para la cronolog\00EDa.</li>'),
unistr('  <li><strong>Nombre de usuario</strong> (obligatorio): seleccione la columna de la tabla o vista que se va a utilizar como usuario mostrado para las entradas de cronolog\00EDa.</li>'),
unistr('  <li><strong>Fecha</strong> (obligatorio): seleccione la columna de la tabla o vista que se va a utilizar como t\00EDtulo de las entradas de cronolog\00EDa.</li>'),
unistr('  <li><strong>Nombre de evento</strong> (obligatorio): seleccione la columna de la tabla o vista que se va a utilizar como t\00EDtulo de las entradas de cronolog\00EDa.</li>'),
unistr('  <li><strong>Descripci\00F3n</strong>: seleccione la columna de la tabla o vista que se va a utilizar como descripci\00F3n de las entradas de cronolog\00EDa.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276287776024866479)
,p_name=>'CA.TIMESTAMP'
,p_message_language=>'es'
,p_message_text=>'Registro de hora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276292356280866482)
,p_name=>'CA.TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275274013873865841)
,p_name=>'CA.TO'
,p_message_language=>'es'
,p_message_text=>'Para'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276291529715866482)
,p_name=>'CA.TOP.USERS'
,p_message_language=>'es'
,p_message_text=>'Usuarios Principales'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276291676794866482)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1fico de usuarios principales')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276289126474866480)
,p_name=>'CA.TOTAL.ROWS'
,p_message_language=>'es'
,p_message_text=>'Total de Filas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276293595034866483)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_language=>'es'
,p_message_text=>unistr('Rol por defecto para los usuarios que no est\00E1n en la lista de control de acceso:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276285793178866478)
,p_name=>'CA.TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275504637407865994)
,p_name=>'CA.UI.DEFAULTS'
,p_message_language=>'es'
,p_message_text=>'Valores por Defecto de Interfaz de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275504713576865994)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Defina valores por defecto para la configuraci\00F3n de la interfaz de usuario (como filas por p\00E1gina) y agregue una lista de definiciones de valores. Esta configuraci\00F3n se utiliza para generar componentes en la aplicaci\00F3n. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276285931238866478)
,p_name=>'CA.UNTIL'
,p_message_language=>'es'
,p_message_text=>'Hasta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275557632966866027)
,p_name=>'CA.UPDATE'
,p_message_language=>'es'
,p_message_text=>'Actualizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276295314287866484)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_language=>'es'
,p_message_text=>'Actualizar Perfil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276286299626866479)
,p_name=>'CA.UPDATED'
,p_message_language=>'es'
,p_message_text=>'Actualizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276286325507866479)
,p_name=>'CA.UPDATED.BY'
,p_message_language=>'es'
,p_message_text=>'Actualizado por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276287603859866479)
,p_name=>'CA.USER'
,p_message_language=>'es'
,p_message_text=>'Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276315222358866497)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_language=>'es'
,p_message_text=>'Agregar varios usuarios: paso 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276315346448866497)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_language=>'es'
,p_message_text=>'Agregar varios usuarios: paso 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276315402314866497)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_language=>'es'
,p_message_text=>'Agregar varios usuarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276290007457866481)
,p_name=>'CA.USER.AGENT'
,p_message_language=>'es'
,p_message_text=>'Agente de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276303463763866489)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_language=>'es'
,p_message_text=>'Informe de recuentos de usuarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276291844920866482)
,p_name=>'CA.USER.NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276294311721866484)
,p_name=>'CA.USER.PROFILE'
,p_message_language=>'es'
,p_message_text=>'Perfil de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276269256773866468)
,p_name=>'CA.USER.PROFILES'
,p_message_language=>'es'
,p_message_text=>'Perfiles de usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276266149958866466)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_language=>'es'
,p_message_text=>'Permitir a los usuarios actualizar sus perfiles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276269104702866467)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permite a los usuarios finales introducir informaci\00F3n adicional sobre ellos mismos, incluida una imagen o avatar, para personalizar su cuenta.</p>'),
'<p>Incluye los siguientes componentes:',
'<ul>',
unistr('<li>P\00E1gina de configuraci\00F3n para que los usuarios finales puedan definir su perfil</li>'),
'<li>Capacidad de cargar una foto o un avatar</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276294537557866484)
,p_name=>'CA.USERNAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276293661712866483)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_language=>'es'
,p_message_text=>'Formato de nombre de usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276316113843866497)
,p_name=>'CA.USERNAMES'
,p_message_language=>'es'
,p_message_text=>'Nombres de usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275512369109865999)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_language=>'es'
,p_message_text=>'Formato de nombre de usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276316777800866497)
,p_name=>'CA.USERS.ADDED'
,p_message_language=>'es'
,p_message_text=>'Usuarios agregados.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276318275885866498)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_language=>'es'
,p_message_text=>'Usuarios por rol'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276297717088866486)
,p_name=>'CA.USERS.INCLUDED'
,p_message_language=>'es'
,p_message_text=>'Usuarios incluidos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276316433113866497)
,p_name=>'CA.USERS.TO.ADD'
,p_message_language=>'es'
,p_message_text=>'Usuarios que Agregar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276293833070866483)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_language=>'es'
,p_message_text=>'El formato de nombre de usuario se ha actualizado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275194670722865790)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'es'
,p_message_text=>unistr('Existen usuarios v\00E1lidos - Informaci\00F3n de p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276309438231866493)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_language=>'es'
,p_message_text=>unistr('Ya existe el ID de aplicaci\00F3n o est\00E1 reservado para otra aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275452936082865959)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_language=>'es'
,p_message_text=>unistr('Se debe especificar el nombre de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276318855932866499)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('Debe proporcionar las direcciones de correo electr\00F3nico a las que enviar el correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276318635049866499)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('Debe proporcionar las direcciones de correo electr\00F3nico o seleccionar un juego de usuarios al que enviar el correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276318774973866499)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_language=>'es'
,p_message_text=>unistr('Debe proporcionar un juego de usuarios al que enviar el correo electr\00F3nico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276309525290866493)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_language=>'es'
,p_message_text=>unistr('El prefijo de tabla no debe tener m\00E1s de seis caracteres, debe empezar por una letra y contener solo letras, n\00FAmeros o guiones bajos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276309677638866493)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_language=>'es'
,p_message_text=>'Introduzca otro prefijo de tabla. Los siguientes objetos de base de datos ya existen: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276294259122866483)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('El nombre de usuario no es un formato de direcci\00F3n de correo electr\00F3nico v\00E1lido. Tenga en cuenta el siguiente formato de nombre de usuario de la aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276294167166866483)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_language=>'es'
,p_message_text=>unistr('Verificar formato de correo electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276291751976866482)
,p_name=>'CA.VIEW.AS'
,p_message_language=>'es'
,p_message_text=>'Ver como'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276313166026866495)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_language=>'es'
,p_message_text=>'Ver plan detallado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276301600550866488)
,p_name=>'CA.VIEW.DETAILS'
,p_message_language=>'es'
,p_message_text=>'Ver Detalles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276319019568866499)
,p_name=>'CA.VIEW.EMAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Ver Correo Electr\00F3nico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276303746259866489)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_language=>'es'
,p_message_text=>'Ver Mi Perfil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276288688759866480)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_language=>'es'
,p_message_text=>'Rendimiento Ponderado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276323674703866502)
,p_name=>'CA.WIDTH'
,p_message_language=>'es'
,p_message_text=>'Ancho'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276327857931866504)
,p_name=>'CA.WIZARD'
,p_message_language=>'es'
,p_message_text=>unistr('Crear p\00E1ginas del asistente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275194546943865790)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_language=>'es'
,p_message_text=>'Contenedor de asistente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276327990393866504)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cree una recopilaci\00F3n de p\00E1ginas que se utilice como asistente. Normalmente, los asistentes se utilizan para introducir datos en varios pasos</p>'),
'<p>Introduzca los siguientes atributos:</p>',
'<ul>',
unistr('  <li><strong>Nombre del asistente</strong> (obligatorio): introduzca un nombre para esta p\00E1gina.</li>'),
unistr('  <li><strong>Definir icono</strong>: seleccione un icono para mostrarlo en el men\00FA de navegaci\00F3n de la p\00E1gina.</li>'),
unistr('  <li><strong>Modo de p\00E1gina</strong> (obligatorio): seleccione si los pasos del asistente se deben mostrar como p\00E1ginas modales o normales. Seleccione <strong>P\00E1gina modal</strong> o <strong>P\00E1gina completa</strong>.</li>'),
unistr('  <li><strong>Paso 1 ... 8</strong>: introduzca el nombre de la p\00E1gina para los pasos del asistente.<br><em><strong>Nota:</strong> Los pasos 5 - 8 se muestran al introducir un nombre para cada paso previo.</em></li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276292178354866482)
,p_name=>'CA.WORK.PHONE'
,p_message_language=>'es'
,p_message_text=>unistr('Tel\00E9fono de trabajo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276284850675866478)
,p_name=>'CA.YELLOW'
,p_message_language=>'es'
,p_message_text=>'Amarillo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275505231441865994)
,p_name=>'CA.YES'
,p_message_language=>'es'
,p_message_text=>unistr('S\00ED')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275039570782865688)
,p_name=>'CACHED'
,p_message_language=>'es'
,p_message_text=>unistr('Almacenado en Cach\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274923256881865615)
,p_name=>'CACHE_CREATED'
,p_message_language=>'es'
,p_message_text=>unistr('Cach\00E9 Creada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274910754409865607)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_language=>'es'
,p_message_text=>unistr('La funcionalidad de supresi\00F3n de datos est\00E1 desactivada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274895238876865597)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_language=>'es'
,p_message_text=>unistr('La funcionalidad de adici\00F3n de datos est\00E1 desactivada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274895344525865597)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_language=>'es'
,p_message_text=>unistr('La funcionalidad de actualizaci\00F3n de datos est\00E1 desactivada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275078562852865715)
,p_name=>'CALENDAR.NEXT'
,p_message_language=>'es'
,p_message_text=>'Siguiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275078468016865715)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_language=>'es'
,p_message_text=>'Anterior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274936144962865623)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_language=>'es'
,p_message_text=>'Calendario Sencillo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276099693678866361)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_language=>'es'
,p_message_text=>'Editar Entrada de Calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274883811073865590)
,p_name=>'CALENDAR_POPUP'
,p_message_language=>'es'
,p_message_text=>'Calendario emergente de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275034333407865685)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_language=>'es'
,p_message_text=>'El calendario se ha creado correctamente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275437106504865947)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla de Calendario Heredado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274936004663865623)
,p_name=>'CALENDAR_TYPE'
,p_message_language=>'es'
,p_message_text=>'Calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275287688156865850)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado ninguna plantilla de calendario al intentar copiar desde la aplicaci\00F3n %0 y el identificador de plantilla %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275438518308865948)
,p_name=>'CANCEL'
,p_message_language=>'es'
,p_message_text=>'Cancelar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274876913977865585)
,p_name=>'CANDLESTICK'
,p_message_language=>'es'
,p_message_text=>'Vela'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275773210945866160)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_language=>'es'
,p_message_text=>'Hojas de Estilo en Cascada'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275494665053865987)
,p_name=>'CENTER'
,p_message_language=>'es'
,p_message_text=>'Centro'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275528757166866009)
,p_name=>'CHANGES'
,p_message_language=>'es'
,p_message_text=>'Cambios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276158805375866398)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Cambiar Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275432993979865943)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('Cambiar Tama\00F1o de Base de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275051137472865697)
,p_name=>'CHANGE_PW_REQUEST'
,p_message_language=>'es'
,p_message_text=>'Solicitud de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275432777148865943)
,p_name=>'CHANGE_REQUEST'
,p_message_language=>'es'
,p_message_text=>'Solicitud de Cambio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275720405226866128)
,p_name=>'CHANGE_WORKSPACE'
,p_message_language=>'es'
,p_message_text=>'Cambiar Espacio de Trabajo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275404758377865925)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna de Juego de Caracteres'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275130022137865748)
,p_name=>'CHART'
,p_message_language=>'es'
,p_message_text=>unistr('gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274882272266865589)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Consulta de gr\00E1fico no v\00E1lida: %0<br><br>'),
'Utilice la siguiente sintaxis:',
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>Texto incluido con la barra</td></tr>',
unistr('<tr><td>VALUE</td><td>Columna num\00E9rica que define el tama\00F1o de barra</td></tr>'),
'</table>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275073342527865711)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Consulta de gr\00E1fico no v\00E1lida.<br /><br /> Utilice la siguiente sintaxis: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'),
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
unistr('<td>Columna num\00E9rica que define el valor de dial.</td>'),
'</tr>',
'<tr>',
'<td>MAX</td>',
unistr('<td>Columna num\00E9rica que define el valor m\00E1ximo de dial.</td>'),
'</tr>',
'<tr>',
'<td>LOW (opcional)</td>',
unistr('<td>Columna num\00E9rica que define el valor m\00EDnimo previo de dial.</td>'),
'</tr>',
'<tr>',
'<td>HIGH (opcional)</td>',
unistr('<td>Columna num\00E9rica que define el valor m\00E1ximo previo de dial.</td>'),
'</tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275148280108865760)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de gr\00E1fico no v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274882194786865589)
,p_name=>'CHART.INVALID_QUERY'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Fallo al analizar la consulta SQL.',
'<p>%0</p>',
unistr('Algunas consultas s\00F3lo se pueden realizar si se ejecuta la aplicaci\00F3n, si la consulta es sint\00E1cticamente correcta, se puede guardar sin validaci\00F3n (consulte las opciones a continuaci\00F3n del origen de la consulta).')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276214098401866432)
,p_name=>'CHART_DEGREES'
,p_message_language=>'es'
,p_message_text=>'grados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275381621030865910)
,p_name=>'CHART_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1fico de %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274911584614865607)
,p_name=>'CHART_SERIES'
,p_message_language=>'es'
,p_message_text=>unistr('Serie de Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275429271741865941)
,p_name=>'CHART_SERIES_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Error de serie de gr\00E1fico %0 para %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275027523242865681)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_language=>'es'
,p_message_text=>unistr('El gr\00E1fico se ha creado correctamente.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274986862970865655)
,p_name=>'CHECK$'
,p_message_language=>'es'
,p_message_text=>'selector de filas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276146543962866390)
,p_name=>'CHECKED'
,p_message_language=>'es'
,p_message_text=>'activado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275385545649865913)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Total de Control Necesario: Nivel de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275202070487865794)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_language=>'es'
,p_message_text=>unistr('Total de Control Necesario: Nivel de Sesi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275201976806865794)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_language=>'es'
,p_message_text=>'Total de Control Necesario: Nivel de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275201890191865794)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_language=>'es'
,p_message_text=>unistr('Total de Control Necesario: Nivel de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276216495941866434)
,p_name=>'CHECK_ALL'
,p_message_language=>'es'
,p_message_text=>'Activar Todo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275369504915865903)
,p_name=>'CLASSIC_CALENDAR'
,p_message_language=>'es'
,p_message_text=>unistr('Calendario Cl\00E1sico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275372501535865905)
,p_name=>'CLASSIC_REPORT'
,p_message_language=>'es'
,p_message_text=>unistr('Informe Cl\00E1sico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275071894334865710)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_language=>'es'
,p_message_text=>unistr('Columnas de informe cl\00E1sico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275370117164865903)
,p_name=>'CLASSIC_TREE'
,p_message_language=>'es'
,p_message_text=>unistr('\00C1rbol Cl\00E1sico')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275368386906865902)
,p_name=>'CLEAN_UP'
,p_message_language=>'es'
,p_message_text=>unistr('Limpiar P\00E1gina')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274905774354865604)
,p_name=>'CLEAR_COMMAND'
,p_message_language=>'es'
,p_message_text=>'Borrar Comando'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275378224689865908)
,p_name=>'CLOSED'
,p_message_language=>'es'
,p_message_text=>'Cerrado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275425849317865939)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('Cerrados en los \00DAltimos 7 D\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275191556205865788)
,p_name=>'CLOSE_WINDOW'
,p_message_language=>'es'
,p_message_text=>'Cerrar Ventana'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276310002589866493)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'es'
,p_message_text=>'Cerrar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276311773606866494)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'es'
,p_message_text=>'Buscar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276309950392866493)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'es'
,p_message_text=>'Buscar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276311682113866494)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'es'
,p_message_text=>'Buscar Siguiente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276311549359866494)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'es'
,p_message_text=>'Buscar Anterior'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276311376593866494)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'es'
,p_message_text=>unistr('Terminar Autom\00E1ticamente')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276310691243866494)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('Tama\00F1o de Sangr\00EDa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276310889664866494)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'es'
,p_message_text=>unistr('Espacios Insertados en Tabulaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276310285127866493)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'es'
,p_message_text=>unistr('Coincidir May\00FAsculas/Min\00FAsculas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276310102656866493)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'es'
,p_message_text=>unistr('Expresi\00F3n Regular')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276315164651866496)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_language=>'es'
,p_message_text=>'Generador de Consultas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276311855542866494)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'es'
,p_message_text=>'Rehacer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276311414183866494)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'es'
,p_message_text=>'Sustituir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276309755376866493)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'es'
,p_message_text=>'Sustituir Todo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276309832992866493)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'es'
,p_message_text=>'Sustituir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276312187745866495)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'es'
,p_message_text=>'Omitir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276311156894866494)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276310498051866494)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'es'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276310982371866494)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'es'
,p_message_text=>unistr('Mostrar N\00FAmeros de L\00EDnea')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276310347432866493)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'es'
,p_message_text=>'Mostrar Regla'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276310757739866494)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('Tama\00F1o de Tabulaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276310522074866494)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'es'
,p_message_text=>'Temas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276311990153866495)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'es'
,p_message_text=>'Deshacer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276311036901866494)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'es'
,p_message_text=>'Usar Editor de Texto sin Formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276311292961866494)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'es'
,p_message_text=>'Validar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276312098290866495)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Validaci\00F3n Correcta')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275308463848865863)
,p_name=>'COLLAPSE'
,p_message_language=>'es'
,p_message_text=>'Reducir '
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274919015547865612)
,p_name=>'COLOR_PALETTE'
,p_message_language=>'es'
,p_message_text=>'Paleta de Colores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275144800294865758)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_language=>'es'
,p_message_text=>unistr('Anal\00F3gico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275144430782865757)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_language=>'es'
,p_message_text=>'Complementario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275145081892865758)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_language=>'es'
,p_message_text=>'Colores Complementarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275144993396865758)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_language=>'es'
,p_message_text=>'Monotono'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275144596236865757)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_language=>'es'
,p_message_text=>'Dividir Complementario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275144799144865757)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00E9trada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275144605860865757)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_language=>'es'
,p_message_text=>unistr('Tr\00EDada')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275765364959866155)
,p_name=>'COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276201466441866425)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_language=>'es'
,p_message_text=>'Nombre Mostrado: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275300722944865858)
,p_name=>'COLUMN_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Columna'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275506480801865995)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_language=>'es'
,p_message_text=>unistr('Todos los usuarios autenticados pueden acceder a esta aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275506527786865995)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_language=>'es'
,p_message_text=>unistr('Solo se permite el acceso a la aplicaci\00F3n a los usuarios definidos en la lista de control de acceso de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275506616741865995)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('Valor de configuraci\00F3n de control de acceso no esperado: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274912438053865608)
,p_name=>'COMING_SOON'
,p_message_language=>'es'
,p_message_text=>unistr('Pr\00F3ximamente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275301259749865858)
,p_name=>'COMMENT'
,p_message_language=>'es'
,p_message_text=>'Comentario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275438726011865948)
,p_name=>'COMMENTS'
,p_message_language=>'es'
,p_message_text=>'Comentarios'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275192741976865788)
,p_name=>'COMPILE_FAILURE'
,p_message_language=>'es'
,p_message_text=>unistr('Fallo de compilaci\00F3n, l\00EDnea <a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275522775349866005)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_language=>'es'
,p_message_text=>unistr('Fallo de compilaci\00F3n, l\00EDnea %0 (%2). Los n\00FAmeros de l\00EDneas asociados a errores de compilaci\00F3n son relativos a la primera sentencia BEGIN. Esto s\00F3lo afecta a la compilaci\00F3n de disparadores de bases de datos.<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275192655777865788)
,p_name=>'COMPILE_SUCCESS'
,p_message_language=>'es'
,p_message_text=>unistr('C\00F3digo PL/SQL compilado correctamente (%0)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275375596978865906)
,p_name=>'COMPLETE'
,p_message_language=>'es'
,p_message_text=>'Terminado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275382981327865911)
,p_name=>'COMPLETED'
,p_message_language=>'es'
,p_message_text=>'Terminado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275389999382865916)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_language=>'es'
,p_message_text=>'Terminado / Sin Problemas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275426400713865939)
,p_name=>'COMPONENT'
,p_message_language=>'es'
,p_message_text=>'Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275583200657866043)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_language=>'es'
,p_message_text=>'Nombre del Componente: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275854529757866210)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_language=>'es'
,p_message_text=>'Componente no activado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275031037055865683)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_language=>'es'
,p_message_text=>'El componente se ha creado correctamente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276196737933866422)
,p_name=>'COMPONENT_SUMMARY'
,p_message_language=>'es'
,p_message_text=>'Resumen del Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274974245542865647)
,p_name=>'COMPUTATIONS'
,p_message_language=>'es'
,p_message_text=>unistr('C\00E1lculos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275449994323865957)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_language=>'es'
,p_message_text=>unistr('Los componentes de la aplicaci\00F3n se han instalado correctamente.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275193379142865789)
,p_name=>'CONDITIONAL'
,p_message_language=>'es'
,p_message_text=>'Condicional'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275283288364865847)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_language=>'es'
,p_message_text=>'lista de valores emergente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275367068915865901)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_language=>'es'
,p_message_text=>'siempre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275103068234865731)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275102529560865730)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_language=>'es'
,p_message_text=>'elemento / columna=valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275102645230865730)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_language=>'es'
,p_message_text=>'elemento / columna no nulo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276068681513866342)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_language=>'es'
,p_message_text=>'elemento/columna nulo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275103161419865731)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_language=>'es'
,p_message_text=>'nunca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275103226331865731)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_language=>'es'
,p_message_text=>'ninguno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275102879487865730)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_language=>'es'
,p_message_text=>unistr('p\00E1gina en')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275102997673865731)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_language=>'es'
,p_message_text=>unistr('la p\00E1gina no est\00E1 en')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275102438369865730)
,p_name=>'CONDITIONS_SHORTCUT_PLSQL'
,p_message_language=>'es'
,p_message_text=>'PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275102744496865730)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_language=>'es'
,p_message_text=>'solicitar=e1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275114357389865738)
,p_name=>'CONDITION_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de Condici\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275328451528865876)
,p_name=>'CONFIRM'
,p_message_language=>'es'
,p_message_text=>'Confirmar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274878789628865587)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Dos p\00E1ginas maestras/de detalles')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274878689354865586)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Tres p\00E1ginas maestras/de detalles')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275089090133865722)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre Real'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275374796306865906)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_language=>'es'
,p_message_text=>'Agregado por Columnas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275374884242865906)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_language=>'es'
,p_message_text=>'Funciones de agregado a Usar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275086451983865720)
,p_name=>'CONFIRM.APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275099817586865729)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_language=>'es'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275099935742865729)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_language=>'es'
,p_message_text=>'Idioma por Defecto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275099754609865729)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274980917251865651)
,p_name=>'CONFIRM.ARRAY'
,p_message_language=>'es'
,p_message_text=>unistr('\00C1rbol de Resultados para Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274981022079865651)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_language=>'es'
,p_message_text=>unistr('Par\00E1metros de Resultado para Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275100045773865729)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275566420758866032)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_language=>'es'
,p_message_text=>unistr('Bifurcar a P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275290634330865851)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas Divisorias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275088815438865721)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_language=>'es'
,p_message_text=>unistr('Bifurcaci\00F3n de Bot\00F3n %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275088762543865721)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Texto de Visualizaci\00F3n del Bot\00F3n %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274892455147865595)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_language=>'es'
,p_message_text=>unistr('Activar Adici\00F3n de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274892391781865595)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_language=>'es'
,p_message_text=>'Activar Arrastrar y Soltar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275508848376865996)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_language=>'es'
,p_message_text=>unistr('Cancelar Bifurcaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275566240121866032)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Etiqueta de Bot\00F3n Cancelar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275556749325866026)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_language=>'es'
,p_message_text=>unistr('Sensible a May\00FAsculas/Min\00FAsculas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275191056874865787)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado cambiar la consulta de informe interactivo. Si ha eliminado alguna columna de la consulta, se desactivar\00E1n los filtros, las reglas para resaltar y otros valores existentes del informe que hacen referencia a esas columnas. Confirme la so')
||'licitud.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275089958554865722)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_language=>'es'
,p_message_text=>unistr('Eje del Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275439090841865948)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_language=>'es'
,p_message_text=>'Dial'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275439168062865948)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_language=>'es'
,p_message_text=>'Dial (con Barrido)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275090648621865723)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_language=>'es'
,p_message_text=>'Barra Horizontal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275090836046865723)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_language=>'es'
,p_message_text=>unistr('L\00EDnea')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275090197660865722)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E1scara de N\00FAmero')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275090732861865723)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_language=>'es'
,p_message_text=>'Tarta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275089815147865722)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_language=>'es'
,p_message_text=>unistr('Consulta de Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275090092433865722)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_language=>'es'
,p_message_text=>'Escala'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275090942552865723)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_language=>'es'
,p_message_text=>unistr('Dispersi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275090417072865722)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('Tama\00F1o de Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275090382958865722)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo del Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275090267601865722)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de Gr\00E1fico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275090540147865722)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_language=>'es'
,p_message_text=>'Barra Vertical'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274981152023865651)
,p_name=>'CONFIRM.COLLECTION'
,p_message_language=>'es'
,p_message_text=>'Nombre de Juego de Resultados Temporal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275087257357865720)
,p_name=>'CONFIRM.COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275290428486865851)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_language=>'es'
,p_message_text=>'Cabeceras de Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275466321294865969)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275509017749865997)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_language=>'es'
,p_message_text=>'Nombres de Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275099530640865728)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_language=>'es'
,p_message_text=>unistr('Usar Ordenaci\00F3n de Cabecera de Columna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275206210392865797)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la copia de una aplicaci\00F3n con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275098172705865727)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la copia de una p\00E1gina con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275087795683865721)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_language=>'es'
,p_message_text=>unistr('Se crear\00E1 el nuevo juego de separadores "%0" y se utilizar\00E1 para esta p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275099672316865728)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una aplicaci\00F3n con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275092206099865724)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de calendario con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275095462077865726)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de informe desplegable con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275155131866865764)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de informe interactivo con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275098409703865728)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de informe con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274886076539865591)
,p_name=>'CONFIRM.CREATE_FLASH_CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de gr\00E1fico flash con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276172359377866407)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado crear una aplicaci\00F3n de base de datos con el mismo identificador que la aplicaci\00F3n de base de datos existente en el espacio de trabajo actual. La aplicaci\00F3n de base de datos existente se suprimir\00E1 y se sustituir\00E1 por la nueva aplicaci\00F3n')
||' de base de datos. Confirme las selecciones. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275463191132865967)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de p\00E1ginas de pantalla y vista de lista con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275374416996865906)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una pantalla y una p\00E1gina de informe con p\00E1ginas de an\00E1lisis. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275091873953865723)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una pantalla basada en la consulta SQL con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275091799948865723)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una pantalla basada en el procedimiento almacenado con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275091610952865723)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una pantalla en la p\00E1gina de tabla con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274937164390865623)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una pantalla basada en una p\00E1gina de referencia de servicio Web con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274993996042865659)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una pantalla y un informe basados en una p\00E1gina de referencia de servicio Web con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275403767392865925)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de Mapa con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274876186937865585)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de p\00E1ginas maestras/de detalles con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275093460243865724)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una regi\00F3n de ruta de navegaci\00F3n y una opci\00F3n de ruta de navegaci\00F3n con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275381719170865910)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_language=>'es'
,p_message_text=>'Crear Modo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275091445180865723)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276247874084866454)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_language=>'es'
,p_message_text=>unistr('Crear P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276247937494866454)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Crear Nombre de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275094217661865725)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de p\00E1ginas de pantalla e informe con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276168247486866404)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275098250192865728)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de informe con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275091947415865723)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de gr\00E1fico de barras HTML con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275097859090865727)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de resumen con los siguientes atributos. Haga clic en el bot\00F3n "Agregar M\00E1s" para agregar m\00E1s elementos de otras p\00E1ginas y/o regiones. Haga clic en "Terminar" para crear los elementos de resumen.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275092085193865723)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de gr\00E1fico SVG con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275091373630865723)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de pantalla tabular con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275092532884865724)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de una p\00E1gina de \00E1rbol con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275091553240865723)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado la creaci\00F3n de un asistente con los siguientes atributos. Confirme las selecciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276171918269866406)
,p_name=>'CONFIRM.CREATE_WS_APP_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado crear una aplicaci\00F3n de hoja de c\00E1lculo web con el mismo identificador que la aplicaci\00F3n de hoja de c\00E1lculo web existente en el espacio de trabajo actual. La aplicaci\00F3n de hoja de c\00E1lculo web existente se suprimir\00E1 y se sustituir\00E1 por l')
||unistr('a nueva aplicaci\00F3n de hoja de c\00E1lculo web. Confirme las selecciones. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275286270946865849)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_language=>'es'
,p_message_text=>'Etiqueta de Enlace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276104999107866365)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de Definici\00F3n de Carga de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276179509748866411)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_language=>'es'
,p_message_text=>unistr('Esta definici\00F3n de carga de datos se volver\00E1 a crear con las consultas de tabla existentes y las reglas de transformaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275556828943866026)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275092355196865724)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna de Fecha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275381872998865910)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_language=>'es'
,p_message_text=>unistr('Esquema de Autenticaci\00F3n por Defecto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275091260554865723)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_language=>'es'
,p_message_text=>'Suprimir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275096134632865726)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_language=>'es'
,p_message_text=>'Detalle %0: Columnas Mostradas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274879140504865587)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_language=>'es'
,p_message_text=>unistr('Columnas de Visualizaci\00F3n de Detalles')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275097789942865727)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_language=>'es'
,p_message_text=>unistr('Columna de Ruta de Navegaci\00F3n de Detalle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275096913282865727)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_language=>'es'
,p_message_text=>'Tabla de Detalles %0: Ordenar por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275095696437865726)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina de Detalles %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274879025301865587)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_language=>'es'
,p_message_text=>'Tabla de Detalles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275095946048865726)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Tabla de Detalles %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275095793885865726)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta de Separador de Detalle %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275509398405865997)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Cargar Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275089320108865722)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas Mostradas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275466091287865969)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_language=>'es'
,p_message_text=>'Cargar Columna 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275466110202865969)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_language=>'es'
,p_message_text=>'Cargar Columna 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275093690822865725)
,p_name=>'CONFIRM.DISPLAY_POINT'
,p_message_language=>'es'
,p_message_text=>unistr('Punto de Visualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276256730983866459)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Editar P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276256830486866460)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Editar el Nombre de la P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275279140440865844)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_language=>'es'
,p_message_text=>'Salida de CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275279830694865844)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_language=>'es'
,p_message_text=>unistr('Salida de Impresi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275280490433865845)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_language=>'es'
,p_message_text=>unistr('Activar Ordenaci\00F3n de Cabecera de Columna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275330322433865877)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Se agregar\00E1 una regi\00F3n a la p\00E1gina Administraci\00F3n existente:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275508957961865996)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_language=>'es'
,p_message_text=>unistr('Terminar Bifurcaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275094762724865725)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina de Pantalla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275094826259865725)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de P\00E1gina de Pantalla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275095004641865725)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Etiqueta de Separador de P\00E1gina de Pantalla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275094916353865725)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_language=>'es'
,p_message_text=>unistr('Juego de Separadores de P\00E1gina de Pantalla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275381939388865911)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_language=>'es'
,p_message_text=>'Importar Componentes Compartidos de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275839422468866201)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_language=>'es'
,p_message_text=>'Incluir Calendario Personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274879316854865587)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_language=>'es'
,p_message_text=>unistr('\00BFIncluir Informe Maestro?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275097431418865727)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_language=>'es'
,p_message_text=>unistr('Incluir Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275088548907865721)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla de Informaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275088695934865721)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Texto de Informaci\00F3n por Defecto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274937302564865623)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_language=>'es'
,p_message_text=>'Elementos de Pantalla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274981373305865651)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla de Regi\00F3n de Pantalla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274981239276865651)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo de Regi\00F3n de Pantalla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275091009469865723)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_language=>'es'
,p_message_text=>'Insertar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275088326400865721)
,p_name=>'CONFIRM.ITEMS'
,p_message_language=>'es'
,p_message_text=>'Elementos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275509239395865997)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Devolver Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275508155723865996)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_language=>'es'
,p_message_text=>'Columna de Clave de Consulta 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275508255019865996)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_language=>'es'
,p_message_text=>'Columna de Clave 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275508371096865996)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_language=>'es'
,p_message_text=>'Columna de Clave 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275092468893865724)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna de etiquetas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275466274791865969)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario de Consulta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275509117239865997)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_language=>'es'
,p_message_text=>'Tabla de Consulta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274879444258865587)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_language=>'es'
,p_message_text=>unistr('Dise\00F1o de Maestro/Detalle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274878949679865587)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_language=>'es'
,p_message_text=>unistr('Columnas de Visualizaci\00F3n Maestras')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274879258405865587)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_language=>'es'
,p_message_text=>'Navegar a Registro Maestro por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274878887692865587)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_language=>'es'
,p_message_text=>'Tabla Maestra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275290595237865851)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero M\00E1ximo de Columnas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275286043183865848)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_language=>'es'
,p_message_text=>unistr('Filas por P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275163885124865770)
,p_name=>'CONFIRM.MENU'
,p_message_language=>'es'
,p_message_text=>unistr('Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275093947821865725)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_language=>'es'
,p_message_text=>unistr('Enlace de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275097508876865727)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_language=>'es'
,p_message_text=>unistr('Ra\00EDz de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275093748228865725)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275094024954865725)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Texto de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275011605116865671)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado actualizar el gr\00E1fico flash al nuevo gr\00E1fico Flash6. Confirme la solicitud.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275375693481865907)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6_XML'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado actualizar un gr\00E1fico flash basado en XML personalizado al nuevo gr\00E1fico Flash 6. Debido a las diferencias en la estructura XML entre el gr\00E1fico actual y el gr\00E1fico Flash 6, no se visualizar\00E1 el gr\00E1fico actualizado. Necesitar\00E1 modificar')
||unistr(' el XML personalizado del gr\00E1fico actualizado para utilizar la nueva estructura XML. Confirme la solicitud.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274949955866865632)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado actualizar el gr\00E1fico flash al nuevo gr\00E1fico HTML5. Confirme la solicitud.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274950085432865632)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5_XML'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado actualizar un gr\00E1fico flash basado en XML personalizado al nuevo gr\00E1fico HTML5. Debido a las diferencias en la estructura XML entre el gr\00E1fico actual y el gr\00E1fico HTML5, no se visualizar\00E1 el gr\00E1fico actualizado. Necesitar\00E1 modificar el ')
||unistr('XML personalizado del gr\00E1fico actualizado para utilizar la nueva estructura XML. Confirme la solicitud.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274949812800865631)
,p_name=>'CONFIRM.MIGRATE_HTML_TO_HTML5'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado actualizar el gr\00E1fico HTML al nuevo gr\00E1fico HTML5. Confirme la solicitud.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276192779664866419)
,p_name=>'CONFIRM.MIGRATE_JSTREE_TO_APEXTREE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado actualizar jsTree al nuevo \00E1rbol. Confirme la solicitud.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275077747107865714)
,p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('El gr\00E1fico SVG se actualizar\00E1 con las siguientes restricciones:  '),
'<ul>',
'<li>',
unistr('S\00F3lo se migrar\00E1n los formatos de n\00FAmero definidos en cadenas de formato de eje. Se ignorar\00E1n los formatos de fecha y hora.'),
'</li>',
'<li>',
unistr('Se migrar\00E1n los elementos de formato de n\00FAmero que contienen:'),
'<br />',
'0,9,D,G,, (coma),. (punto),$,C,L,FM',
'</li>',
'<li>',
unistr('La etiqueta de cada serie del gr\00E1fico flash se derivar\00E1 del alias de columna de cada serie.  '),
unistr('Esto es diferente en los gr\00E1ficos SVG, donde la etiqueta de cada serie se deriva del atributo Nombre de la Serie.'),
'</li>',
'<li>',
unistr('Los gr\00E1ficos de dial flash muestran valores reales en lugar de porcentajes.'),
'</li>',
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275032845678865684)
,p_name=>'CONFIRM.MIGRATE_SVG_TO_HTML5'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado actualizar el gr\00E1fico SVG a HTML5. Confirme la solicitud.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276168001811866404)
,p_name=>'CONFIRM.NAVIGATION'
,p_message_language=>'es'
,p_message_text=>unistr('Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275100380534865729)
,p_name=>'CONFIRM.NAV_BAR'
,p_message_language=>'es'
,p_message_text=>unistr('Barra de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275818220123866188)
,p_name=>'CONFIRM.NAV_LIST'
,p_message_language=>'es'
,p_message_text=>unistr('Lista de Men\00FA de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275393504053865918)
,p_name=>'CONFIRM.NEW_ADMIN_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Se agregar\00E1 una nueva p\00E1gina Administraci\00F3n. P\00E1gina:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275191274278865787)
,p_name=>'CONFIRM.NEW_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas Nuevas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275089100840865722)
,p_name=>'CONFIRM.NEW_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Nueva Plantilla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275566095402866032)
,p_name=>'CONFIRM.NEXT_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Etiqueta de Bot\00F3n Siguiente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275087677128865721)
,p_name=>'CONFIRM.NO.TABSET.SELECTED'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha seleccionado ning\00FAn juego de separadores para esta p\00E1gina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275088287901865721)
,p_name=>'CONFIRM.NO_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Sin Plantilla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274937412289865624)
,p_name=>'CONFIRM.OUTPUT_ITEMS'
,p_message_language=>'es'
,p_message_text=>'Elementos de Salida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275089504192865722)
,p_name=>'CONFIRM.OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275086536611865720)
,p_name=>'CONFIRM.PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275100120113865729)
,p_name=>'CONFIRM.PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275086633238865720)
,p_name=>'CONFIRM.PAGE_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de la P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275087554834865721)
,p_name=>'CONFIRM.PAGE_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275096058710865726)
,p_name=>'CONFIRM.PARENT_DISPLAY_COLS'
,p_message_language=>'es'
,p_message_text=>unistr('Columnas de Visualizaci\00F3n Principales')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275094169637865725)
,p_name=>'CONFIRM.PARENT_MENU'
,p_message_language=>'es'
,p_message_text=>unistr('Ruta de Navegaci\00F3n Principal')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275097612585865727)
,p_name=>'CONFIRM.PARENT_MENU_COL'
,p_message_language=>'es'
,p_message_text=>unistr('Columna de Ruta de Navegaci\00F3n Principal')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275096273541865726)
,p_name=>'CONFIRM.PARENT_ORDER_BY'
,p_message_language=>'es'
,p_message_text=>'Tabla Principal: Ordenar por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275095542687865726)
,p_name=>'CONFIRM.PARENT_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina Principal')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275095872680865726)
,p_name=>'CONFIRM.PARENT_TABLE_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Tabla Principal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275088145686865721)
,p_name=>'CONFIRM.PARENT_TAB_LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta de Separador Principal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275088046943865721)
,p_name=>'CONFIRM.PARENT_TAB_SET'
,p_message_language=>'es'
,p_message_text=>'Juego de Separadores Principales'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275190944300865787)
,p_name=>'CONFIRM.PARSING_SCHEMA'
,p_message_language=>'es'
,p_message_text=>unistr('Esquema de An\00E1lisis')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275199908832865793)
,p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR'
,p_message_language=>'es'
,p_message_text=>unistr('Refrescamiento de P\00E1gina Parcial')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275566144656866032)
,p_name=>'CONFIRM.PREVIOUS_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Etiqueta de Bot\00F3n Anterior')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275087449030865721)
,p_name=>'CONFIRM.PRIMARY_KEY'
,p_message_language=>'es'
,p_message_text=>'Columna de Clave Primaria %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275095105057865726)
,p_name=>'CONFIRM.PRIMARY_KEY_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna de Clave Primaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275286337846865849)
,p_name=>'CONFIRM.PRINT_FORMAT'
,p_message_language=>'es'
,p_message_text=>'Formato de Salida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275290742373865852)
,p_name=>'CONFIRM.PRINT_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Etiqueta de Enlace de Impresi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275286421346865849)
,p_name=>'CONFIRM.PRINT_OUTPUT'
,p_message_language=>'es'
,p_message_text=>unistr('Impresi\00F3n de Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275089442858865722)
,p_name=>'CONFIRM.PROCESS_OPTIONS'
,p_message_language=>'es'
,p_message_text=>'Opciones de Proceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275286137175865849)
,p_name=>'CONFIRM.REGION_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna de Regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275088457938865721)
,p_name=>'CONFIRM.REGION_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla de Regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275086794681865720)
,p_name=>'CONFIRM.REGION_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo de la Regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275093557165865724)
,p_name=>'CONFIRM.REGION_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de Regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275191147819865787)
,p_name=>'CONFIRM.REMOVED_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas Eliminadas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275095233694865726)
,p_name=>'CONFIRM.REPORT_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275308535857865863)
,p_name=>'CONFIRM.REPORT_IMPLEMENTATION'
,p_message_language=>'es'
,p_message_text=>unistr('Implantaci\00F3n de Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275094392660865725)
,p_name=>'CONFIRM.REPORT_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina de Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275094498047865725)
,p_name=>'CONFIRM.REPORT_PAGE_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de P\00E1gina de Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275094611794865725)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Etiqueta de Separador de P\00E1gina de Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275094555298865725)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_SET'
,p_message_language=>'es'
,p_message_text=>unistr('Juego de Separadores de P\00E1gina de Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274981538891865652)
,p_name=>'CONFIRM.REPORT_REGION_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla de Regi\00F3n de Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274981465899865652)
,p_name=>'CONFIRM.REPORT_REGION_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('T\00EDtulo de Regi\00F3n de Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275098587923865728)
,p_name=>'CONFIRM.REPORT_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274984077478865653)
,p_name=>'CONFIRM.ROW_VERSION_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna de Versi\00F3n de Fila')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275098731560865728)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME1'
,p_message_language=>'es'
,p_message_text=>unistr('valor por defecto: HTML (est\00E1ndar)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275099067874865728)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME11'
,p_message_language=>'es'
,p_message_text=>'valor por defecto: Aspecto 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275099177271865728)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME12'
,p_message_language=>'es'
,p_message_text=>'valor por defecto: Aspecto 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275190759897865787)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME13'
,p_message_language=>'es'
,p_message_text=>'valor por defecto: Aspecto 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275190835996865787)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME14'
,p_message_language=>'es'
,p_message_text=>'valor por defecto: Aspecto 4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274982066106865652)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME15'
,p_message_language=>'es'
,p_message_text=>'valor por defecto: Aspecto 5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275098826590865728)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME2'
,p_message_language=>'es'
,p_message_text=>'valor por defecto: informe vertical'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275099283209865728)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME21'
,p_message_language=>'es'
,p_message_text=>'exportar: CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275099360935865728)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME22'
,p_message_language=>'es'
,p_message_text=>'exportar: XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275098936867865728)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME3'
,p_message_language=>'es'
,p_message_text=>'valor por defecto: informe vertical, aspecto 1 (incluir columnas nulas)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275190587807865787)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME4'
,p_message_language=>'es'
,p_message_text=>'valor por defecto: informe vertical, aspecto 2 (excluir columnas nulas)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275190681560865787)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME5'
,p_message_language=>'es'
,p_message_text=>'valor por defecto: informe vertical, aspecto 2 (incluir columnas nulas)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275509467600865997)
,p_name=>'CONFIRM.RULE_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Regla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275509657719865997)
,p_name=>'CONFIRM.RULE_SEQUENCE'
,p_message_language=>'es'
,p_message_text=>'Secuencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275509780885865997)
,p_name=>'CONFIRM.RULE_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Regla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274911227561865607)
,p_name=>'CONFIRM.RUN_SCRIPT'
,p_message_language=>'es'
,p_message_text=>'Ha solicitado ejecutar el siguiente script. Confirme la solicitud.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275093869053865725)
,p_name=>'CONFIRM.SEQUENCE'
,p_message_language=>'es'
,p_message_text=>'Secuencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275098653934865728)
,p_name=>'CONFIRM.SORT_OPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Opci\00F3n de Ordenaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275089786479865722)
,p_name=>'CONFIRM.SQL_QUERY'
,p_message_language=>'es'
,p_message_text=>'Consulta SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275199839132865793)
,p_name=>'CONFIRM.STANDARD_CALENDAR'
,p_message_language=>'es'
,p_message_text=>unistr('Est\00E1ndar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275328052186865876)
,p_name=>'CONFIRM.STARTING_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Se crear\00E1n varias p\00E1ginas, empezando por la p\00E1gina:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275089627912865722)
,p_name=>'CONFIRM.STORED_PROCEDURE_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre del Procedimiento Almacenado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275192508619865788)
,p_name=>'CONFIRM.STORED_PROCEDURE_OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario de Procedimiento Almacenado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275566320369866032)
,p_name=>'CONFIRM.SUBMIT_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Etiqueta de Bot\00F3n Terminar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276183523382866414)
,p_name=>'CONFIRM.SUBSCRIBE_THEME'
,p_message_language=>'es'
,p_message_text=>'Suscribirse a Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275088917507865721)
,p_name=>'CONFIRM.SUGGESTED_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre Sugerido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275374524392865906)
,p_name=>'CONFIRM.TABLE'
,p_message_language=>'es'
,p_message_text=>'Tabla/Vista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275374640189865906)
,p_name=>'CONFIRM.TABLE_COLS'
,p_message_language=>'es'
,p_message_text=>'Resumir por Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275593567268866049)
,p_name=>'CONFIRM.TABLE_LOOKUPS'
,p_message_language=>'es'
,p_message_text=>'Consultas de Tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275087113993865720)
,p_name=>'CONFIRM.TABLE_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de la Tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275087027978865720)
,p_name=>'CONFIRM.TABLE_OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario de Tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275765664550866155)
,p_name=>'CONFIRM.TABLE_RULE'
,p_message_language=>'es'
,p_message_text=>unistr('Regla de Transformaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275509839818865997)
,p_name=>'CONFIRM.TABLE_RULES'
,p_message_language=>'es'
,p_message_text=>unistr('Reglas de Transformaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275191487827865788)
,p_name=>'CONFIRM.TABLE_VIEW_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Tabla/Vista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275191371951865787)
,p_name=>'CONFIRM.TABLE_VIEW_OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario de Tabla/Vista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275100204891865729)
,p_name=>'CONFIRM.TABS'
,p_message_language=>'es'
,p_message_text=>'Separadores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275087944177865721)
,p_name=>'CONFIRM.TABSET.INCOMPLETE'
,p_message_language=>'es'
,p_message_text=>unistr('Advertencia: La informaci\00F3n del juego de separadores est\00E1 incompleta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275086954116865720)
,p_name=>'CONFIRM.TAB_LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta de Separador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275098356512865728)
,p_name=>'CONFIRM.TAB_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Separador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275086845058865720)
,p_name=>'CONFIRM.TAB_SET'
,p_message_language=>'es'
,p_message_text=>'Juego de Separadores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275099498515865728)
,p_name=>'CONFIRM.TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'plantilla:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275093162487865724)
,p_name=>'CONFIRM.TREE_LOV'
,p_message_language=>'es'
,p_message_text=>'Basado en el nuevo elemento con una lista de valores emergente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275092875420865724)
,p_name=>'CONFIRM.TREE_MAX_LEVEL'
,p_message_language=>'es'
,p_message_text=>unistr('Niveles M\00E1ximos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275092600173865724)
,p_name=>'CONFIRM.TREE_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre de \00C1rbol')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275093084568865724)
,p_name=>'CONFIRM.TREE_QUERY'
,p_message_language=>'es'
,p_message_text=>unistr('Consulta de \00C1rbol')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275093221129865724)
,p_name=>'CONFIRM.TREE_SQL'
,p_message_language=>'es'
,p_message_text=>'Basado en Consulta SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275092985701865724)
,p_name=>'CONFIRM.TREE_START'
,p_message_language=>'es'
,p_message_text=>unistr('Iniciar \00C1rbol')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275093304732865724)
,p_name=>'CONFIRM.TREE_STATIC'
,p_message_language=>'es'
,p_message_text=>unistr('Valor Est\00E1tico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275092749322865724)
,p_name=>'CONFIRM.TREE_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de \00C1rbol')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275100464893865729)
,p_name=>'CONFIRM.UI_THEME'
,p_message_language=>'es'
,p_message_text=>'Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275100532870865729)
,p_name=>'CONFIRM.UI_THEME1'
,p_message_language=>'es'
,p_message_text=>unistr('Azul y Marr\00F3n Claro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275100690661865729)
,p_name=>'CONFIRM.UI_THEME2'
,p_message_language=>'es'
,p_message_text=>'Rojo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275100754579865729)
,p_name=>'CONFIRM.UI_THEME4'
,p_message_language=>'es'
,p_message_text=>'Azul Marino y Gris'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275100882852865729)
,p_name=>'CONFIRM.UI_THEME5'
,p_message_language=>'es'
,p_message_text=>'Verde Oliva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275100906216865729)
,p_name=>'CONFIRM.UI_THEME6'
,p_message_language=>'es'
,p_message_text=>'Granate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275101008739865729)
,p_name=>'CONFIRM.UI_THEME7'
,p_message_language=>'es'
,p_message_text=>unistr('Azul B\00E1sico y Marr\00F3n Claro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275101153957865729)
,p_name=>'CONFIRM.UI_THEME8'
,p_message_language=>'es'
,p_message_text=>'Azul'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275101209475865729)
,p_name=>'CONFIRM.UI_THEME_NONE'
,p_message_language=>'es'
,p_message_text=>'Ninguno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275087314796865720)
,p_name=>'CONFIRM.UPDATEABLE_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas Actualizables'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275091168536865723)
,p_name=>'CONFIRM.UPDATE_PROCESS'
,p_message_language=>'es'
,p_message_text=>'Actualizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275087832419865721)
,p_name=>'CONFIRM.USE.EXISTING.TABSET'
,p_message_language=>'es'
,p_message_text=>unistr('Esta p\00E1gina utilizar\00E1 el juego de separadores existente "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274937288417865623)
,p_name=>'CONFIRM.WEB_SERVICE_REF'
,p_message_language=>'es'
,p_message_text=>unistr('Referencia de Servicio Web, Operaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275095345091865726)
,p_name=>'CONFIRM.WHERE_CLAUSE'
,p_message_language=>'es'
,p_message_text=>unistr('Cl\00E1usula WHERE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275363910421865899)
,p_name=>'CONFIRMATION_ICON'
,p_message_language=>'es'
,p_message_text=>unistr('Icono de Confirmaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275376084374865907)
,p_name=>'CONFIRMED'
,p_message_language=>'es'
,p_message_text=>'Confirmado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275376323169865907)
,p_name=>'CONFIRMED_BY_QA'
,p_message_language=>'es'
,p_message_text=>'Confirmado por Preguntas y Respuestas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275286613595865849)
,p_name=>'CONFIRM_BREAK_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columnas Divisorias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275286599964865849)
,p_name=>'CONFIRM_PRINT_FORMAT'
,p_message_language=>'es'
,p_message_text=>unistr('Formato de Impresi\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275404854657865925)
,p_name=>'CONTENT_DISPOSITION'
,p_message_language=>'es'
,p_message_text=>unistr('Disposici\00F3n del Contenido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275440092814865949)
,p_name=>'CONTENT_SERVED_IN_KBYTES'
,p_message_language=>'es'
,p_message_text=>'Contenido Entregado'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275277564737865843)
,p_name=>'CONTINUE'
,p_message_language=>'es'
,p_message_text=>'Continuar'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276317111866866498)
,p_name=>'CONTRIBUTORS'
,p_message_language=>'es'
,p_message_text=>'Contribuyentes'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276209740211866430)
,p_name=>'COPY.PAGE.NEW_STATIC_ID'
,p_message_language=>'es'
,p_message_text=>unistr('Nuevo Identificador Est\00E1tico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274973910899865647)
,p_name=>'COPYRIGHT'
,p_message_language=>'es'
,p_message_text=>'Copyright &copy; %0, Todos los derechos reservados.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275032329981865684)
,p_name=>'COPY_APP_SUCCESS_MSG'
,p_message_language=>'es'
,p_message_text=>unistr('La aplicaci\00F3n se ha copiado.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275167949734865772)
,p_name=>'COPY_BUTTON.EXECUTION_ERR'
,p_message_language=>'es'
,p_message_text=>unistr('Error durante la ejecuci\00F3n de copy_button: %0 >> %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275206818606865797)
,p_name=>'COPY_DEPLOYMENT'
,p_message_language=>'es'
,p_message_text=>unistr('Copiar Atributos de Definici\00F3n de Objeto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275005664522865667)
,p_name=>'COPY_EXISTING_APP'
,p_message_language=>'es'
,p_message_text=>unistr('Copiar Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275463985997865967)
,p_name=>'COPY_FEATURE'
,p_message_language=>'es'
,p_message_text=>unistr('Funci\00F3n de Copia: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275206446810865797)
,p_name=>'COPY_FROM_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Copiar de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275640671870866078)
,p_name=>'COPY_FROM_APP_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Basado en Aplicaci\00F3n de Plantilla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275206510698865797)
,p_name=>'COPY_FROM_NAME'
,p_message_language=>'es'
,p_message_text=>'Copiar de Nombre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275034515753865685)
,p_name=>'COPY_LIST_ENTRY'
,p_message_language=>'es'
,p_message_text=>'Copiar Entrada de Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275168386063865773)
,p_name=>'COPY_NAMED_LOV.EXECUTION_ERR'
,p_message_language=>'es'
,p_message_text=>unistr('Error durante la ejecuci\00F3n de copy_named_lov: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275168206597865773)
,p_name=>'COPY_NAMED_LOV.NOT_FOUND_ERR'
,p_message_language=>'es'
,p_message_text=>'No se ha encontrado el identificador de lista de valores "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275168156299865773)
,p_name=>'COPY_NAMED_LOV.NUMERIC_ERR'
,p_message_language=>'es'
,p_message_text=>unistr('El identificador de lista de valores "%0" no es num\00E9rico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275444944988865953)
,p_name=>'COPY_PAGE.COPY_FROM_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Copiar de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275445055172865953)
,p_name=>'COPY_PAGE.COPY_TO_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Copiar en P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275443926644865952)
,p_name=>'COPY_PAGE.SELECT_AUTHORIZATION'
,p_message_language=>'es'
,p_message_text=>unistr('- Seleccionar Autorizaci\00F3n-')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275443859699865952)
,p_name=>'COPY_PAGE.SELECT_LIST'
,p_message_language=>'es'
,p_message_text=>'- Seleccionar Lista -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275443712605865952)
,p_name=>'COPY_PAGE.SELECT_NAMED_LOV'
,p_message_language=>'es'
,p_message_text=>'- Seleccionar Lista de Valores -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275515821002866001)
,p_name=>'COPY_TABLE'
,p_message_language=>'es'
,p_message_text=>'Copiar %0 en la Tabla %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275206635101865797)
,p_name=>'COPY_TO_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Copiar a Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275206749382865797)
,p_name=>'COPY_TO_NAME'
,p_message_language=>'es'
,p_message_text=>'Copiar a Nombre'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275132193992865749)
,p_name=>'CORE'
,p_message_language=>'es'
,p_message_text=>unistr('n\00FAcleo')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275299065410865857)
,p_name=>'COUNT'
,p_message_language=>'es'
,p_message_text=>'Recuento'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275356840713865894)
,p_name=>'CREATE'
,p_message_language=>'es'
,p_message_text=>'Crear'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275603081893866055)
,p_name=>'CREATE APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Crear Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275603111911866055)
,p_name=>'CREATE OBJECT'
,p_message_language=>'es'
,p_message_text=>'Crear Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275812759845866184)
,p_name=>'CREATED'
,p_message_language=>'es'
,p_message_text=>'Creado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275812864069866184)
,p_name=>'CREATED_BY'
,p_message_language=>'es'
,p_message_text=>'Creado por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275463652747865967)
,p_name=>'CREATED_LAST_7_DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('Creaci\00F3n en los \00DAltimos 7 D\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275169076135865773)
,p_name=>'CREATED_ON'
,p_message_language=>'es'
,p_message_text=>'Creado el'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275005751528865667)
,p_name=>'CREATE_APP_FROM_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('De una plantilla de aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276106968666866366)
,p_name=>'CREATE_APP_WIZ.CANDLE_CHARTS'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos de Vela')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276106703889866366)
,p_name=>'CREATE_APP_WIZ.COL_CHARTS'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos de Barras Apiladas con Columnas 2D y 3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276107402189866366)
,p_name=>'CREATE_APP_WIZ.GAUGE_CHARTS'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos de Dial y Dial (Porcentaje)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276106811317866366)
,p_name=>'CREATE_APP_WIZ.PIE_CHARTS'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos de Tarta y Donut 2D y 3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276107136907866366)
,p_name=>'CREATE_APP_WIZ.PROJECTGANTT_CHARTS'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos de Gantt de Proyecto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276107381202866366)
,p_name=>'CREATE_APP_WIZ.RANGE_CHARTS'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos de Rango 2D y 3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276107206612866366)
,p_name=>'CREATE_APP_WIZ.RESOURCEGANTT_CHARTS'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos de Gantt de Recursos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276107067060866366)
,p_name=>'CREATE_APP_WIZ.SCATTER_CHARTS'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos de Marcador de Dispersi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275124027968865744)
,p_name=>'CREATE_CONDITION.AND'
,p_message_language=>'es'
,p_message_text=>'AND'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275123898173865744)
,p_name=>'CREATE_CONDITION.ARROW_DOWN'
,p_message_language=>'es'
,p_message_text=>'Flecha hacia Abajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275123994801865744)
,p_name=>'CREATE_CONDITION.ARROW_RIGHT'
,p_message_language=>'es'
,p_message_text=>'Flecha a la Derecha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275123688249865744)
,p_name=>'CREATE_CONDITION.COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275123703106865744)
,p_name=>'CREATE_CONDITION.CONDITIONS'
,p_message_language=>'es'
,p_message_text=>'Condiciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275124196638865744)
,p_name=>'CREATE_CONDITION.OR'
,p_message_language=>'es'
,p_message_text=>'OR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275124254217865744)
,p_name=>'CREATE_CONDITION.PREVIEW'
,p_message_language=>'es'
,p_message_text=>unistr('Condici\00F3n de Vista Previa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275464413584865968)
,p_name=>'CREATE_DEMO_APP.GRANT'
,p_message_language=>'es'
,p_message_text=>unistr('Haga clic en el bot\00F3n Otorgar Privilegios a continuaci\00F3n para otorg\00E1rselos ahora a %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275464291719865968)
,p_name=>'CREATE_DEMO_APP.NO_CREATE_PRIV'
,p_message_language=>'es'
,p_message_text=>unistr('%0 no tiene los privilegios CREATE TABLE, CREATE VIEW, CREATE TRIGGER, CREATE SEQUENCE o CREATE PROCEDURE y no podr\00E1 instalar la aplicaci\00F3n de demostraci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275464341290865968)
,p_name=>'CREATE_DEMO_APP.NO_EXEC_PRIV'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('%0 no dispone de privilegios de ejecuci\00F3n en CTX_DOC ni CTX_DDL y no podr\00E1 instalar la demostraci\00F3n de Discurso Inaugural del Presidente. Ejecute los siguientes permisos como usuario con privilegios: '),
'<pre>',
'GRANT EXECUTE ON CTXSYS.CTX_DDL TO %0; ',
'GRANT EXECUTE ON CTXSYS.CTX_DOC TO %0;',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275810804067866183)
,p_name=>'CREATE_DIALOG_CLOSED_DA'
,p_message_language=>'es'
,p_message_text=>unistr('Crear Bot\00F3n: Cuadro de Di\00E1logo Cerrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274908153640865605)
,p_name=>'CREATE_DYNAMIC_LIST'
,p_message_language=>'es'
,p_message_text=>unistr('Crear Lista Din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275192217389865788)
,p_name=>'CREATE_DYNAMIC_LOV'
,p_message_language=>'es'
,p_message_text=>unistr('Crear Lista de Valores Din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274886150430865591)
,p_name=>'CREATE_FLOW.CLOUD_IDM'
,p_message_language=>'es'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274925649284865616)
,p_name=>'CREATE_FLOW.DBACCOUNT'
,p_message_language=>'es'
,p_message_text=>'Cuenta de Base de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275629218672866071)
,p_name=>'CREATE_FLOW.HTMLDB_AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Autenticaci\00F3n de Application Express')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275464803042865968)
,p_name=>'CREATE_FLOW.LDAP'
,p_message_language=>'es'
,p_message_text=>'LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276168170214866404)
,p_name=>'CREATE_FLOW.NAVIGATION_LIST'
,p_message_language=>'es'
,p_message_text=>unistr('Lista de Men\00FA de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275629344543866071)
,p_name=>'CREATE_FLOW.NO_AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Sin Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275628916251866071)
,p_name=>'CREATE_FLOW.NO_TABS'
,p_message_language=>'es'
,p_message_text=>unistr('Ning\00FAn Separador')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275629099670866071)
,p_name=>'CREATE_FLOW.ONE_LEVEL_TABS'
,p_message_language=>'es'
,p_message_text=>'Un Nivel de Separadores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275464945805865968)
,p_name=>'CREATE_FLOW.SSO'
,p_message_language=>'es'
,p_message_text=>'Single Sign-On (SSO)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275629101114866071)
,p_name=>'CREATE_FLOW.TWO_LEVEL_TABS'
,p_message_language=>'es'
,p_message_text=>'Dos Niveles de Separadores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275005594114865667)
,p_name=>'CREATE_FROM_SPREADSHEET'
,p_message_language=>'es'
,p_message_text=>unistr('Desde una Hoja de C\00E1lculo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274882503639865589)
,p_name=>'CREATE_GLOBAL_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Los componentes de la p\00E1gina global se muestran en todas las p\00E1ginas si el punto de visualizaci\00F3n de su regi\00F3n est\00E1 incluido dentro de la plantilla de p\00E1gina seleccionada. Los atributos de visualizaci\00F3n condicional se pueden utilizar para suprimir la')
||unistr(' visualizaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275157207964865766)
,p_name=>'CREATE_INDEX'
,p_message_language=>'es'
,p_message_text=>unistr('Crear \00CDndice')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275312814666865866)
,p_name=>'CREATE_ITEM_WIZ.NO_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('no hay ninguna regi\00F3n asociada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275131870496865749)
,p_name=>'CREATE_NEW_LOGIN_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Crear Nueva P\00E1gina de Conexi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275125785472865745)
,p_name=>'CREATE_PACKAGE.BACK'
,p_message_language=>'es'
,p_message_text=>unistr('Volver al Asistente de Creaci\00F3n de Tablas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275125276558865745)
,p_name=>'CREATE_PACKAGE.BROWSE'
,p_message_language=>'es'
,p_message_text=>'Examinar Paquete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275125147140865745)
,p_name=>'CREATE_PACKAGE.CREATED'
,p_message_language=>'es'
,p_message_text=>'Se ha creado el paquete "%0" en el esquema"%1".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275125878301865745)
,p_name=>'CREATE_PACKAGE.FAILED'
,p_message_language=>'es'
,p_message_text=>'Fallo al crear la tabla "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275125637126865745)
,p_name=>'CREATE_PACKAGE.HOME'
,p_message_language=>'es'
,p_message_text=>'Inicio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275125473392865745)
,p_name=>'CREATE_PACKAGE.RETURN_TO'
,p_message_language=>'es'
,p_message_text=>'Volver a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275125531595865745)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP'
,p_message_language=>'es'
,p_message_text=>'Taller&nbsp;de&nbsp;SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275125344712865745)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina Inicial de Taller de SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275121086630865742)
,p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado ning\00FAn elemento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275120662997865742)
,p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('Elementos de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275120960794865742)
,p_name=>'CREATE_PAGE_ITEM.PROMPT'
,p_message_language=>'es'
,p_message_text=>unistr('Petici\00F3n de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275120761124865742)
,p_name=>'CREATE_PAGE_ITEM.REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275120882755865742)
,p_name=>'CREATE_PAGE_ITEM.SET_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('haga clic para definir la regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275118773145865741)
,p_name=>'CREATE_PROCESS.PAGE_ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('Elementos de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275118811968865741)
,p_name=>'CREATE_PROCESS.REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275125052345865745)
,p_name=>'CREATE_TABLE.HOME'
,p_message_language=>'es'
,p_message_text=>'Inicio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275124852165865745)
,p_name=>'CREATE_TABLE.RETURN_TO'
,p_message_language=>'es'
,p_message_text=>'Volver a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275124718597865745)
,p_name=>'CREATE_TABLE.RUN_SCRIPT'
,p_message_language=>'es'
,p_message_text=>'Ejecutar Script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275124493530865744)
,p_name=>'CREATE_TABLE.SCRIPT_CREATED'
,p_message_language=>'es'
,p_message_text=>unistr('La creaci\00F3n de archivos de comandos de la tabla %0 se ha realizado en el repositorio de archivos de comandos SQL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275124598484865744)
,p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY'
,p_message_language=>'es'
,p_message_text=>'Ir a Repositorio de Archivos de Comandos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275124948093865745)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP'
,p_message_language=>'es'
,p_message_text=>'Taller&nbsp;de&nbsp;SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275124648055865745)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina Inicial de Taller de SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275581893858866042)
,p_name=>'CREATE_TABULAR_FORM'
,p_message_language=>'es'
,p_message_text=>'Pantalla Tabular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276187490566866416)
,p_name=>'CREATE_TO_DO'
,p_message_language=>'es'
,p_message_text=>'Crear Tarea'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275516659635866001)
,p_name=>'CREATE_TRIGGER'
,p_message_language=>'es'
,p_message_text=>'Crear Disparador %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275454814377865960)
,p_name=>'CREATE_WS_OBJ_SUCCESS_MSG'
,p_message_language=>'es'
,p_message_text=>unistr('Los objetos de base de datos de hoja de c\00E1lculo web se han creado.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275407055181865927)
,p_name=>'CREDENTIAL.OWNER'
,p_message_language=>'es'
,p_message_text=>'Propietario de Credencial'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275369483332865903)
,p_name=>'CSS_CALENDAR'
,p_message_language=>'es'
,p_message_text=>'Calendario'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275282350019865846)
,p_name=>'CURRENT'
,p_message_language=>'es'
,p_message_text=>'Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275361276875865897)
,p_name=>'CURRENT ENTRY'
,p_message_language=>'es'
,p_message_text=>'Entrada Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275360942669865897)
,p_name=>'CURRENT FORM ELEMENT'
,p_message_language=>'es'
,p_message_text=>'Elemento de Pantalla Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275145124103865758)
,p_name=>'CURRENT ITEM HELP TEXT'
,p_message_language=>'es'
,p_message_text=>'Texto de Ayuda de Elemento Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275361021267865897)
,p_name=>'CURRENT ITEM IDENTIFICATION NUMBER'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de Identificaci\00F3n del Elemento Actual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275361175307865897)
,p_name=>'CURRENT ITEM LABEL NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Etiqueta del Elemento Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275420156063865935)
,p_name=>'CURRENT TAB'
,p_message_language=>'es'
,p_message_text=>'Separador Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275106953616865733)
,p_name=>'CURRENT_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n Actual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275113917789865738)
,p_name=>'CURRENT_IMAGE'
,p_message_language=>'es'
,p_message_text=>'Imagen Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275720699798866128)
,p_name=>'CURRENT_ITEM_CONTAINER_ID'
,p_message_language=>'es'
,p_message_text=>'ID que se puede utilizar en un elemento de contenedor que encapsula el campo actual, en el atributo Antes de Etiqueta y Elemento.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276195988471866421)
,p_name=>'CURRENT_ITEM_HELP_LABEL'
,p_message_language=>'es'
,p_message_text=>'Etiqueta de Ayuda de Elemento Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275072715597865711)
,p_name=>'CURRENT_MILESTONE'
,p_message_language=>'es'
,p_message_text=>'Hito Actual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275113094256865737)
,p_name=>'CURRENT_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina Actual')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275387770777865914)
,p_name=>'CURRENT_PAGE_CONTAINS_NO_ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('La p\00E1gina actual no contiene ning\00FAn elemento.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275278185024865843)
,p_name=>'CUSTOM'
,p_message_language=>'es'
,p_message_text=>'Personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275320876139865871)
,p_name=>'CUSTOMIZE'
,p_message_language=>'es'
,p_message_text=>'Personalizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275356774612865894)
,p_name=>'CUSTOMIZE LINK'
,p_message_language=>'es'
,p_message_text=>'Enlace Personalizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275366320065865900)
,p_name=>'CUSTOMIZE.USER_PAGE_PREFS_RESET'
,p_message_language=>'es'
,p_message_text=>unistr('Restablecimiento de las preferencias de p\00E1gina para el usuario %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275366467530865901)
,p_name=>'CUSTOMIZE.USER_PREFS_CHANGED'
,p_message_language=>'es'
,p_message_text=>'Las preferencias han cambiado para el usuario %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275366211566865900)
,p_name=>'CUSTOMIZE.USER_PREFS_RESET'
,p_message_language=>'es'
,p_message_text=>unistr('Restablecimiento de las preferencias de p\00E1gina para el usuario %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276070636956866343)
,p_name=>'CUSTOM_APPLICATIONS'
,p_message_language=>'es'
,p_message_text=>'Aplicaciones Personalizadas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274907037570865604)
,p_name=>'CUSTOM_AUTH_SCHEME_DESC'
,p_message_language=>'es'
,p_message_text=>'Desarrollador Definido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275161464747865768)
,p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR'
,p_message_language=>'es'
,p_message_text=>'Error en %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275072949127865711)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca una cadena que se utilizar\00E1 como identificador de usuario para esta sesi\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275073088416865711)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca el nombre de usuario y la contrase\00F1a de %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275073195223865711)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca el nombre de usuario y la contrase\00F1a para su verificaci\00F3n por el host LDAP: %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275073222302865711)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca el nombre de usuario y la contrase\00F1a del esquema de base de datos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275839724876866201)
,p_name=>'CUSTOM_CALENDAR'
,p_message_language=>'es'
,p_message_text=>'Recargar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275844818876866204)
,p_name=>'CUSTOM_CALENDAR.END_DATE'
,p_message_language=>'es'
,p_message_text=>unistr('Fecha de Finalizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275844766965866204)
,p_name=>'CUSTOM_CALENDAR.START_DATE'
,p_message_language=>'es'
,p_message_text=>'Fecha de Inicio'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275517586809866002)
,p_name=>'DA.SET_VALUE.SQL.HELP_MSG'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cuando Acci\00F3n Verdadera es Definir Valor con Definir Tipo como Sentencia SQL, necesita definir los elementos afectados en el mismo orden que el de la columna de la sentencia SQL. La sentencia SQL que ha definido es:</p>'),
'<pre>%0</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275078334332865715)
,p_name=>'DAILY'
,p_message_language=>'es'
,p_message_text=>'Diario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275295555874865855)
,p_name=>'DATA'
,p_message_language=>'es'
,p_message_text=>'Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275602600355866055)
,p_name=>'DATA WORKSHOP'
,p_message_language=>'es'
,p_message_text=>'Taller de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275173071123865776)
,p_name=>'DATA.LOAD.ALL_COL_MAPPED'
,p_message_language=>'es'
,p_message_text=>unistr('Todas las columnas %0 se han asignado autom\00E1ticamente a la tabla %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275173883486865776)
,p_name=>'DATA.LOAD.APPEND_INCOMPLETE'
,p_message_language=>'es'
,p_message_text=>'Los datos de la tabla <code>%0</code> se han agregado a <b id="incompl_success_row_count"></b> nuevas filas. <b class="u-danger-text" id="incompl_fail_row_count"></b> filas rechazadas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275173478009865776)
,p_name=>'DATA.LOAD.APPEND_SUCCESS'
,p_message_language=>'es'
,p_message_text=>'Los datos de la tabla <code>%0</code> se han agregado a <b id="success_row_count"></b> nuevas filas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275173650417865776)
,p_name=>'DATA.LOAD.APPEND_WARNING'
,p_message_language=>'es'
,p_message_text=>'Los datos de la tabla <code>%0</code> se han agregado a <b id="err_success_row_count"></b> nuevas filas. <b class="u-danger-text" id="err_fail_row_count"></b> filas rechazadas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274883003519865589)
,p_name=>'DATA.LOAD.CHOOSE_FILE'
,p_message_language=>'es'
,p_message_text=>'Seleccionar Archivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274920665467865613)
,p_name=>'DATA.LOAD.CONFIGURATION_SAVED'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n guardada')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275173198106865776)
,p_name=>'DATA.LOAD.DEFINE_COL_MAPPING'
,p_message_language=>'es'
,p_message_text=>unistr('Defina la asignaci\00F3n de columnas para cargar los datos en la tabla %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274882947555865589)
,p_name=>'DATA.LOAD.DRAG_DROP_FILE_HERE'
,p_message_language=>'es'
,p_message_text=>unistr('Arrastre y suelte un archivo aqu\00ED o')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274882853581865589)
,p_name=>'DATA.LOAD.FILE_FORMATS'
,p_message_language=>'es'
,p_message_text=>'Los formatos soportados son CSV, XLSX, TXT, XML, JSON'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274883981927865590)
,p_name=>'DATA.LOAD.INVALID_FILE'
,p_message_language=>'es'
,p_message_text=>unistr('El archivo cargado no es v\00E1lido o tiene una extensi\00F3n incorrecta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275052242110865698)
,p_name=>'DATA.LOAD.INVALID_SELECTOR'
,p_message_language=>'es'
,p_message_text=>unistr('Se han utilizado selectores XML o JSON no v\00E1lidos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275600568492866053)
,p_name=>'DATA.LOAD.JOB_INTERMITTENTLY_FAILED'
,p_message_language=>'es'
,p_message_text=>unistr('La ejecuci\00F3n del trabajo de carga de datos se ha detenido de forma inesperada.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275524786076866006)
,p_name=>'DATA.LOAD.JOB_NAME'
,p_message_language=>'es'
,p_message_text=>'Trabajo de carga de datos del espacio de trabajo %0: Cargar en la tabla %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275173260281865776)
,p_name=>'DATA.LOAD.MAP_REMAINING_COLS'
,p_message_language=>'es'
,p_message_text=>unistr('%0 de %1 columnas se han asignado autom\00E1ticamente a la tabla %2. Configure las %3 columnas restantes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275518369299866002)
,p_name=>'DATA.LOAD.NO_FILE_CONTENTS'
,p_message_language=>'es'
,p_message_text=>'No se han encontrado datos en el archivo cargado.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275518403485866002)
,p_name=>'DATA.LOAD.NO_WORKSHEET_CONTENTS'
,p_message_language=>'es'
,p_message_text=>'No se han encontrado datos en la hoja de trabajo "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274883337685865589)
,p_name=>'DATA.LOAD.NO_XLSX_FILE'
,p_message_language=>'es'
,p_message_text=>'El archivo especificado no es un archivo XLSX.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275565119803866031)
,p_name=>'DATA.LOAD.PASTED_DATA'
,p_message_language=>'es'
,p_message_text=>'Datos pegados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275173946804865776)
,p_name=>'DATA.LOAD.REPLACE_INCOMPLETE'
,p_message_language=>'es'
,p_message_text=>'Los datos de la tabla <code>%0</code> se han reemplazado por <b id="incompl_success_row_count"></b> nuevas filas. <b class="u-danger-text" id="incompl_fail_row_count"></b> filas rechazadas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275173525069865776)
,p_name=>'DATA.LOAD.REPLACE_SUCCESS'
,p_message_language=>'es'
,p_message_text=>'Los datos de la tabla <code>%0</code> se han reemplazado por <b id="success_row_count"></b> nuevas filas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275173701815865776)
,p_name=>'DATA.LOAD.REPLACE_WARNING'
,p_message_language=>'es'
,p_message_text=>'Los datos de la tabla <code>%0</code> se han reemplazado por <b id="err_success_row_count"></b> nuevas filas. <b class="u-danger-text" id="err_fail_row_count"></b> filas rechazadas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275173376716865776)
,p_name=>'DATA.LOAD.SELECT_COLS'
,p_message_language=>'es'
,p_message_text=>'Seleccione las columnas que se van a cargar.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276180271151866411)
,p_name=>'DATABASE'
,p_message_language=>'es'
,p_message_text=>'Base de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275603278776866055)
,p_name=>'DATABASE BROWSER'
,p_message_language=>'es'
,p_message_text=>'Explorador de Base de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276118829828866373)
,p_name=>'DATABASE.DEMO.SAMPLE.APP'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n de Base de Datos de Ejemplo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276180351048866412)
,p_name=>'DATABASE_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n de Base de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274927363088865617)
,p_name=>'DATABASE_APPLICATIONS'
,p_message_language=>'es'
,p_message_text=>'Aplicaciones de Base de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274955100194865635)
,p_name=>'DATABASE_APPS'
,p_message_language=>'es'
,p_message_text=>'Aplicaciones de Base de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275449735556865956)
,p_name=>'DATABASE_APP_SUCCESS_MSG'
,p_message_language=>'es'
,p_message_text=>unistr('La aplicaci\00F3n <strong>%0</strong> se ha instalado correctamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275346624155865888)
,p_name=>'DATABASE_LINK'
,p_message_language=>'es'
,p_message_text=>'Enlace de Base de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275399446367865922)
,p_name=>'DATABASE_OBJECT_COUNTS_BY_TYPE'
,p_message_language=>'es'
,p_message_text=>'Recuento de Objetos de Base de Datos por Tipo de Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275402627487865924)
,p_name=>'DATABASE_ROLE_PRIVILEGES'
,p_message_language=>'es'
,p_message_text=>'Privilegios de Rol de Base de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274949637850865631)
,p_name=>'DATABASE_USERS'
,p_message_language=>'es'
,p_message_text=>'Base de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275510322944865997)
,p_name=>'DATA_GRID'
,p_message_language=>'es'
,p_message_text=>unistr('Cuadr\00EDcula de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276109418218866367)
,p_name=>'DATA_GRIDS'
,p_message_language=>'es'
,p_message_text=>unistr('Cuadr\00EDculas de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276109975844866368)
,p_name=>'DATA_GRID_DATA'
,p_message_language=>'es'
,p_message_text=>unistr('Datos de Cuadr\00EDcula de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276099906618866362)
,p_name=>'DATA_LOAD.ADVANCED_SETTINGS_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n Avanzada de Carga de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275036564345865686)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT'
,p_message_language=>'es'
,p_message_text=>unistr('Formatos de Fecha/N\00FAmero que Usar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275036653116865686)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT_HELP'
,p_message_language=>'es'
,p_message_text=>unistr('Elija si desea proporcionar m\00E1scaras de formato personalizadas o est\00E1ndar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274951047212865632)
,p_name=>'DATA_LOAD.CHARSET'
,p_message_language=>'es'
,p_message_text=>'Juego de Caracteres de Archivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275591299038866048)
,p_name=>'DATA_LOAD.COLUMN_NAMES'
,p_message_language=>'es'
,p_message_text=>'Nombres de Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275589787077866047)
,p_name=>'DATA_LOAD.COLUMN_NAMES_MAPPING'
,p_message_language=>'es'
,p_message_text=>'Columna de Destino'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275447847869865955)
,p_name=>'DATA_LOAD.COLUMN_NAME_ALIASES'
,p_message_language=>'es'
,p_message_text=>'Alias de Nombres de Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275804250888866179)
,p_name=>'DATA_LOAD.CONFIRM'
,p_message_language=>'es'
,p_message_text=>'Los datos se han cargado correctamente en la tabla.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275811563107866184)
,p_name=>'DATA_LOAD.COPY_PASTE'
,p_message_language=>'es'
,p_message_text=>'Copiar y Pegar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275797890174866175)
,p_name=>'DATA_LOAD.COPY_PASTE_TEXTAREA'
,p_message_language=>'es'
,p_message_text=>'Copiar y Pegar Datos Delimitados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276140276498866386)
,p_name=>'DATA_LOAD.CURRENCY_ITEM'
,p_message_language=>'es'
,p_message_text=>unistr('S\00EDmbolo de Divisa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276140360973866386)
,p_name=>'DATA_LOAD.CURRENCY_ITEM_HELP'
,p_message_language=>'es'
,p_message_text=>unistr('Si los datos contienen un s\00EDmbolo de moneda internacional, introd\00FAzcalo aqu\00ED. Por ejemplo, si los datos tienen "1.234,56 &euro;" o "1.234,56 &yen;", introduzca "&euro;" o "&yen;". De lo contrario, los datos no se cargar\00E1n correctamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274956002217865635)
,p_name=>'DATA_LOAD.DATA_LOADING'
,p_message_language=>'es'
,p_message_text=>'Carga de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276100089465866362)
,p_name=>'DATA_LOAD.DATE_FORMAT_APP'
,p_message_language=>'es'
,p_message_text=>unistr('Usar M\00E1scaras de Formato Est\00E1ndar de la Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276100186480866362)
,p_name=>'DATA_LOAD.DATE_FORMAT_CUSTOM'
,p_message_language=>'es'
,p_message_text=>'Proporcionar Formatos Personalizados para Columnas Cargadas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276141866434866387)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_HELP'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>El car\00E1cter decimal separa la parte entera de la decimal de un n\00FAmero.</p>'),
unistr('<p> Cualquier car\00E1cter puede ser el car\00E1cter decimal. El car\00E1cter especificado debe ser de un solo byte y ser diferente del separador de grupo. Puede ser un espacio pero no puede ser un car\00E1cter num\00E9rico ni los siguientes caracteres:</p>'),
'<ul class="noIndent">',
unistr('<li>m\00E1s (+)</li>'),
'<li>menos (-)</li> ',
'<li>menor que (<)</li>',
'<li>mayor que (>)</li> ',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276140989675866387)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_ITEM'
,p_message_language=>'es'
,p_message_text=>unistr('Car\00E1cter Decimal')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275448086316865955)
,p_name=>'DATA_LOAD.DISPLAY'
,p_message_language=>'es'
,p_message_text=>'Mostrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275591176716866048)
,p_name=>'DATA_LOAD.DO_NOT_LOAD'
,p_message_language=>'es'
,p_message_text=>'No Cargar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276135837536866384)
,p_name=>'DATA_LOAD.FAILED'
,p_message_language=>'es'
,p_message_text=>'Error de preprocesamiento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276048329799866330)
,p_name=>'DATA_LOAD.FAILED_COUNT'
,p_message_language=>'es'
,p_message_text=>'Fila(s) con Fallos:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276119860311866374)
,p_name=>'DATA_LOAD.FAILED_RECORD'
,p_message_language=>'es'
,p_message_text=>'Registros con Fallos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276139829181866386)
,p_name=>'DATA_LOAD.FILE_NAME_ITEM'
,p_message_language=>'es'
,p_message_text=>'Nombre del archivo que desea cargar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275590052985866047)
,p_name=>'DATA_LOAD.FIRST_COLUMN_NAMES'
,p_message_language=>'es'
,p_message_text=>'Columna de Origen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275808277749866182)
,p_name=>'DATA_LOAD.FIRST_ROW'
,p_message_language=>'es'
,p_message_text=>'La Primera Fila Tiene Nombres de Columnas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276139993648866386)
,p_name=>'DATA_LOAD.FIRST_ROW_HELP'
,p_message_language=>'es'
,p_message_text=>'Active esta casilla si los datos contienen nombres de columna en la primera fila.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275591357535866048)
,p_name=>'DATA_LOAD.FORMAT'
,p_message_language=>'es'
,p_message_text=>unistr('Formato de Fecha/N\00FAmero')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276140188788866386)
,p_name=>'DATA_LOAD.GLOBALIZATION_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Globalizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276140894957866387)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_HELP'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Un separador de grupos es un car\00E1cter que separa los grupos de enteros, por ejemplo, para mostrar los miles y millones.</p>'),
unistr('<p>Cualquier car\00E1cter puede ser el separador de grupos. El car\00E1cter especificado debe ser de un solo byte y ser diferente del car\00E1cter decimal. Puede ser un espacio pero no puede ser un car\00E1cter num\00E9rico ni los siguientes caracteres:</p>'),
'<ul class="noIndent">',
unistr('<li>m\00E1s (+)</li>'),
'<li>menos (-)</li> ',
'<li>menor que (<)</li>',
'<li>mayor que (>)</li> ',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276140463215866387)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_ITEM'
,p_message_language=>'es'
,p_message_text=>'Separador de Grupos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276135591352866384)
,p_name=>'DATA_LOAD.INSERT'
,p_message_language=>'es'
,p_message_text=>'Insertar Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276048120563866330)
,p_name=>'DATA_LOAD.INSERTED_COUNT'
,p_message_language=>'es'
,p_message_text=>'Fila(s) Insertada(s):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276137345898866385)
,p_name=>'DATA_LOAD.IR_MAX_ROW_COUNT'
,p_message_language=>'es'
,p_message_text=>unistr('Esta consulta devuelve m\00E1s de #MAX_ROW_COUNT# filas; filtre los datos para asegurar resultados completos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275446743940865954)
,p_name=>'DATA_LOAD.JUSTCHANGED_RECORD'
,p_message_language=>'es'
,p_message_text=>'Registros Cargados por Otro Usuario.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275063079438865705)
,p_name=>'DATA_LOAD.LABEL_CASE_SENSITIVE'
,p_message_language=>'es'
,p_message_text=>unistr('Sensible a May\00FAsculas/Min\00FAsculas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275062912470865705)
,p_name=>'DATA_LOAD.LABEL_UNIQUE_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna \00DAnica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275771390749866159)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'es'
,p_message_text=>'Fallo de Carga de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275771462008866159)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Acci\00F3n Procesada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275797028260866175)
,p_name=>'DATA_LOAD.LOAD_TO'
,p_message_language=>'es'
,p_message_text=>'Importar de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276200967840866424)
,p_name=>'DATA_LOAD.LOOKUP_FAILED'
,p_message_language=>'es'
,p_message_text=>'Fallo al recuperar el valor de consulta.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275817416821866187)
,p_name=>'DATA_LOAD.MAPPING'
,p_message_language=>'es'
,p_message_text=>unistr('Asignaci\00F3n de Datos/Tabla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275508582536865996)
,p_name=>'DATA_LOAD.MAPPING_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Paso 2: Nombre de la P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276199694742866423)
,p_name=>'DATA_LOAD.NO_PREVIEW'
,p_message_language=>'es'
,p_message_text=>'No hay disponible ninguna vista previa del archivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276139042281866386)
,p_name=>'DATA_LOAD.OPTIONAL_ENCLOSE_ITEM'
,p_message_language=>'es'
,p_message_text=>'Delimitado Opcionalmente por'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276103385650866364)
,p_name=>'DATA_LOAD.PROGRESS_TITLE'
,p_message_language=>'es'
,p_message_text=>'Progreso de Asistente de Carga de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275508768910865996)
,p_name=>'DATA_LOAD.RESULTS_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Paso 4: Nombre de la P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275447956985865955)
,p_name=>'DATA_LOAD.RETURN'
,p_message_language=>'es'
,p_message_text=>'Volver'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275446254567865954)
,p_name=>'DATA_LOAD.REVIEW_COUNT'
,p_message_language=>'es'
,p_message_text=>'Filas para Revisar:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275591486600866048)
,p_name=>'DATA_LOAD.ROW'
,p_message_language=>'es'
,p_message_text=>'Fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275587977229866046)
,p_name=>'DATA_LOAD.RULES_PLSQL_EXPRESSION_EXAMPLES'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'to_char(sysdate)',
'',
'my_func (',
'    p_1 => :SAL,',
'    p_2 => :COMM)',
'',
'donde SAL y COMM son nombres de columna de los datos cargados',
unistr('y my_func es la funci\00F3n que devuelve el valor que ser\00E1 el nuevo valor'),
unistr('para la columna para la que se ha definido esta regla de transformaci\00F3n.'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275588118659866046)
,p_name=>'DATA_LOAD.RULES_PLSQL_FUNCTION_EXAMPLES'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'declare',
'    l_result number;',
'begin',
'   l_result := :SAL * :COMM',
'   return l_result;',
'end;',
'',
unistr('El resultado devuelto ser\00E1 el nuevo valor de la columna para la que se ha definido esta regla de transformaci\00F3n.'),
'',
'Y :SAL y :COMM hacen referencia a los nombres de columna SAL y COMM de los datos cargados.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275588027612866046)
,p_name=>'DATA_LOAD.RULES_SQL_QUERY_EXAMPLES'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'select depno',
' from dept',
'donde dname = :DEPTNAME',
'  y  oc = :LOC',
'',
'donde :DEPNAME y :LOC hacen referencia a los nombres de columna DEPNAME y LOC de los datos cargados.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276138866518866386)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_HELP'
,p_message_language=>'es'
,p_message_text=>unistr('Identifique un car\00E1cter separador de columnas. Utilice <code>\005Ct</code> como separador de tabulador.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276138970203866386)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_LABEL'
,p_message_language=>'es'
,p_message_text=>'Separador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275448113092865955)
,p_name=>'DATA_LOAD.SEQUENCE'
,p_message_language=>'es'
,p_message_text=>'Secuencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276192652973866419)
,p_name=>'DATA_LOAD.SEQUENCE_ACTION'
,p_message_language=>'es'
,p_message_text=>unistr('Secuencia: Acci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276099775557866361)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Usar Configuraci\00F3n Avanzada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276099853525866362)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS_HELP'
,p_message_language=>'es'
,p_message_text=>unistr('Muestra la configuraci\00F3n avanzada para la carga de datos: S\00EDmbolo de Moneda, Caracteres Decimales, Codificaci\00F3n de Archivo o Formatos de Fecha')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275816892613866187)
,p_name=>'DATA_LOAD.SOURCE'
,p_message_language=>'es'
,p_message_text=>'Origen de Carga de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275508476886865996)
,p_name=>'DATA_LOAD.SOURCE_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Paso 1: Nombre de la P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276180592613866412)
,p_name=>'DATA_LOAD.TAB_SEPARTOR_NOTE'
,p_message_language=>'es'
,p_message_text=>'(\t para separador)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275521563261866004)
,p_name=>'DATA_LOAD.TRANSFORMATION_FAILED'
,p_message_language=>'es'
,p_message_text=>unistr('Fallo de la regla de transformaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276137637677866385)
,p_name=>'DATA_LOAD.UNIQUE_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('Columna \00DAnica %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276135627112866384)
,p_name=>'DATA_LOAD.UPDATE'
,p_message_language=>'es'
,p_message_text=>'Actualizar fila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276048245498866330)
,p_name=>'DATA_LOAD.UPDATED_COUNT'
,p_message_language=>'es'
,p_message_text=>'Fila(s) Actualizada(s):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276248388513866454)
,p_name=>'DATA_LOAD.UPLOADED_NULL_VALUE'
,p_message_language=>'es'
,p_message_text=>'Se ha cargado un valor nulo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275811431799866184)
,p_name=>'DATA_LOAD.UPLOAD_FILE'
,p_message_language=>'es'
,p_message_text=>'Cargar Archivo, Separado por Comas (*.csv) o Delimitado por Tabuladores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275817068524866187)
,p_name=>'DATA_LOAD.UPLOAD_RESULTS'
,p_message_language=>'es'
,p_message_text=>'Resultados de Carga de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275816957890866187)
,p_name=>'DATA_LOAD.VALIDATION'
,p_message_language=>'es'
,p_message_text=>unistr('Validaci\00F3n de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275508698684865996)
,p_name=>'DATA_LOAD.VALIDATION_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Paso 3: Nombre de la P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275512754898865999)
,p_name=>'DATA_LOAD_WIZARD_CREATED_SUCCESSFULLY'
,p_message_language=>'es'
,p_message_text=>unistr('Las p\00E1ginas del asistente de carga de datos se han creado correctamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275771512283866159)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Fallo de Asignaci\00F3n de Datos/Tabla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275771600469866159)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Acci\00F3n Procesada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275370964897865903)
,p_name=>'DATA_UPLOAD_COLUMN_MAPPING'
,p_message_language=>'es'
,p_message_text=>unistr('Carga de Datos: Asignaci\00F3n de Columna')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275296462640865855)
,p_name=>'DATE'
,p_message_language=>'es'
,p_message_text=>'Fecha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275501033255865991)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID'
,p_message_language=>'es'
,p_message_text=>'El valor de atributo de fecha resaltado %0 introducido para el elemento %1 no coincide con el formato %2.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275506891084865995)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID_RELATIVE'
,p_message_language=>'es'
,p_message_text=>'El valor de atributo de fecha resaltado %0 introducido para el elemento %1 no es una fecha relativa.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275501210157865992)
,p_name=>'DATEPICKER.MAX_DATE_INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('El valor de atributo de fecha m\00E1ximo %0 introducido para el elemento %1 no coincide con el formato %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275507007147865995)
,p_name=>'DATEPICKER.MAX_DATE_INVALID_RELATIVE'
,p_message_language=>'es'
,p_message_text=>unistr('El valor de atributo de fecha m\00E1ximo %0 introducido para el elemento %1 no es una fecha relativa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275501126308865991)
,p_name=>'DATEPICKER.MIN_DATE_INVALID'
,p_message_language=>'es'
,p_message_text=>unistr('Introduzca el valor de atributo de fecha m\00EDnimo %0 para el elemento %1 que no coincide con el formato %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275506977917865995)
,p_name=>'DATEPICKER.MIN_DATE_INVALID_RELATIVE'
,p_message_language=>'es'
,p_message_text=>unistr('El valor de atributo de fecha m\00EDnimo %0 introducido para el elemento %1 no es una fecha relativa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275634984844866075)
,p_name=>'DATE_ADDED'
,p_message_language=>'es'
,p_message_text=>unistr('Fecha de Adici\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276107715240866366)
,p_name=>'DATE_OF_LAST_RUN'
,p_message_language=>'es'
,p_message_text=>unistr('Hora de \00FAltima ejecuci\00F3n de trabajos de la base de datos de Oracle Application Express')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275126916542865746)
,p_name=>'DAY'
,p_message_language=>'es'
,p_message_text=>unistr('d\00EDa')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275127029579865746)
,p_name=>'DAYS'
,p_message_language=>'es'
,p_message_text=>unistr('d\00EDas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275423611183865937)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE'
,p_message_language=>'es'
,p_message_text=>'en el hito final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275423778493865937)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE_OF_RELASE'
,p_message_language=>'es'
,p_message_text=>unistr('en el hito final de la versi\00F3n %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275506106920865995)
,p_name=>'DA_NAME.NATIVE_ADD_CLASS'
,p_message_language=>'es'
,p_message_text=>'Agregar Clase'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276112702510866369)
,p_name=>'DA_NAME.NATIVE_ALERT'
,p_message_language=>'es'
,p_message_text=>'Alerta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276111433627866369)
,p_name=>'DA_NAME.NATIVE_CANCEL_EVENT'
,p_message_language=>'es'
,p_message_text=>'Cancelar Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276112934906866370)
,p_name=>'DA_NAME.NATIVE_CLEAR'
,p_message_language=>'es'
,p_message_text=>'Borrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276112860592866369)
,p_name=>'DA_NAME.NATIVE_CONFIRM'
,p_message_language=>'es'
,p_message_text=>'Confirmar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274872567492865583)
,p_name=>'DA_NAME.NATIVE_DIALOG_CANCEL'
,p_message_language=>'es'
,p_message_text=>unistr('Cancelar Cuadro de Di\00E1logo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274872681220865583)
,p_name=>'DA_NAME.NATIVE_DIALOG_CLOSE'
,p_message_language=>'es'
,p_message_text=>unistr('Cerrar Recuadro de Di\00E1logo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275032269290865684)
,p_name=>'DA_NAME.NATIVE_DISABLE'
,p_message_language=>'es'
,p_message_text=>'Desactivar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275032118847865683)
,p_name=>'DA_NAME.NATIVE_ENABLE'
,p_message_language=>'es'
,p_message_text=>'Activar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276105031842866365)
,p_name=>'DA_NAME.NATIVE_EXECUTE_PLSQL_CODE'
,p_message_language=>'es'
,p_message_text=>unistr('Ejecutar C\00F3digo PL/SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275032037519865683)
,p_name=>'DA_NAME.NATIVE_HIDE'
,p_message_language=>'es'
,p_message_text=>'Ocultar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275418403871865934)
,p_name=>'DA_NAME.NATIVE_JAVASCRIPT_CODE'
,p_message_language=>'es'
,p_message_text=>unistr('Ejecutar C\00F3digo JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275778469956866163)
,p_name=>'DA_NAME.NATIVE_REFRESH'
,p_message_language=>'es'
,p_message_text=>'Refrescar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275506265173865995)
,p_name=>'DA_NAME.NATIVE_REMOVE_CLASS'
,p_message_language=>'es'
,p_message_text=>'Eliminar Clase'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275506375990865995)
,p_name=>'DA_NAME.NATIVE_SET_CSS'
,p_message_language=>'es'
,p_message_text=>'Definir Estilo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275751365776866147)
,p_name=>'DA_NAME.NATIVE_SET_FOCUS'
,p_message_language=>'es'
,p_message_text=>'Definir Foco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275418394154865934)
,p_name=>'DA_NAME.NATIVE_SET_VALUE'
,p_message_language=>'es'
,p_message_text=>'Definir Valor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275031977181865683)
,p_name=>'DA_NAME.NATIVE_SHOW'
,p_message_language=>'es'
,p_message_text=>'Mostrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275751465348866147)
,p_name=>'DA_NAME.NATIVE_SUBMIT_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Ejecutar P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275688923280866108)
,p_name=>'DA_NAME.NATIVE_TREE_COLLAPSE'
,p_message_language=>'es'
,p_message_text=>unistr('Reducir \00C1rbol')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275688875183866108)
,p_name=>'DA_NAME.NATIVE_TREE_EXPAND'
,p_message_language=>'es'
,p_message_text=>unistr('Ampliar \00C1rbol')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274909475861865606)
,p_name=>'DBACCOUNT_AUTH_SCHEME_DESC'
,p_message_language=>'es'
,p_message_text=>'Cuenta de Base de Datos'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275414511379865932)
,p_name=>'DB_COLS_CASE_SEN'
,p_message_language=>'es'
,p_message_text=>unistr('Los nombres de columna y tabla de base de datos son sensibles a may\00FAsculas y min\00FAsculas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275526803854866008)
,p_name=>'DB_OBJECT_CREATION_EXCEPTION'
,p_message_language=>'es'
,p_message_text=>unistr('excepci\00F3n de creaci\00F3n de objeto de base de datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274923158568865615)
,p_name=>'DB_PRODUCT_NAME'
,p_message_language=>'es'
,p_message_text=>'Oracle Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276170789758866406)
,p_name=>'DB_SERVICES_ALIAS'
,p_message_language=>'es'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276167106905866403)
,p_name=>'DB_SERVICES_ALL_MIMES'
,p_message_language=>'es'
,p_message_text=>'Todos los Tipos MIME'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276170686485866405)
,p_name=>'DB_SERVICES_CREATE_HANDLER'
,p_message_language=>'es'
,p_message_text=>'Crear manejador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276167489324866403)
,p_name=>'DB_SERVICES_CREATE_METHOD'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E9todo de Creaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276167255456866403)
,p_name=>'DB_SERVICES_CREATE_PARAMETER'
,p_message_language=>'es'
,p_message_text=>unistr('Crear Par\00E1metro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276167320759866403)
,p_name=>'DB_SERVICES_CREATE_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Crear Plantilla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276174401687866408)
,p_name=>'DB_SERVICES_DB_SERVICES_MODULE'
,p_message_language=>'es'
,p_message_text=>unistr('M\00F3dulo de Servicio RESTful')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276170513447866405)
,p_name=>'DB_SERVICES_HANDLER'
,p_message_language=>'es'
,p_message_text=>'Manejador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276174983396866408)
,p_name=>'DB_SERVICES_HANDLER_BIND_VARIABLE'
,p_message_language=>'es'
,p_message_text=>'Variable de Enlace del Manejador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276144346917866389)
,p_name=>'DB_SERVICES_HANDLER_METHOD'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E9todo de Manejador')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276175292869866408)
,p_name=>'DB_SERVICES_HANDLER_SOURCE'
,p_message_language=>'es'
,p_message_text=>'Origen del Manejador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276144442800866389)
,p_name=>'DB_SERVICES_HANDLER_SRC_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Origen de Manejador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276166914065866403)
,p_name=>'DB_SERVICES_METHOD'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E9todo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276174526178866408)
,p_name=>'DB_SERVICES_MODULE_NAME'
,p_message_language=>'es'
,p_message_text=>unistr('Nombre del M\00F3dulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276175080811866408)
,p_name=>'DB_SERVICES_MODULE_URI'
,p_message_language=>'es'
,p_message_text=>unistr('Prefijo URI de M\00F3dulo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276167507618866403)
,p_name=>'DB_SERVICES_NO_SOURCE'
,p_message_language=>'es'
,p_message_text=>unistr('Ning\00FAn Origen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276166860426866403)
,p_name=>'DB_SERVICES_PARAMETER'
,p_message_language=>'es'
,p_message_text=>unistr('Par\00E1metro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276174752602866408)
,p_name=>'DB_SERVICES_RESTFUL_SERVICES'
,p_message_language=>'es'
,p_message_text=>'Servicios RESTful'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276167090192866403)
,p_name=>'DB_SERVICES_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276175136871866408)
,p_name=>'DB_SERVICES_TEMPLATE_URI'
,p_message_language=>'es'
,p_message_text=>'Plantilla de URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276144207696866389)
,p_name=>'DB_SERVICES_URI'
,p_message_language=>'es'
,p_message_text=>'Identificador de Recursos Uniforme (URI)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276174251939866408)
,p_name=>'DB_SERVICES_URI_PRIFIX'
,p_message_language=>'es'
,p_message_text=>'Prefijo de URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276174327814866408)
,p_name=>'DB_SERVICES_URI_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla de URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276144582403866389)
,p_name=>'DB_SERVICE_QUERY_ONE_ROW'
,p_message_language=>'es'
,p_message_text=>'Consultar Una Fila'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275319906154865871)
,p_name=>'DEBUG'
,p_message_language=>'es'
,p_message_text=>'Depurar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275434929278865945)
,p_name=>'DEBUGGING_OFF'
,p_message_language=>'es'
,p_message_text=>unistr('La depuraci\00F3n no est\00E1 activada para esta aplicaci\00F3n.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275431615348865942)
,p_name=>'DECLINED'
,p_message_language=>'es'
,p_message_text=>'Rechazado'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276246267632866453)
,p_name=>'DEFAULT_DIALOGBTNR_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla de Regi\00F3n de Bot\00F3n de Cuadro de Di\00E1logo por Defecto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276246146620866453)
,p_name=>'DEFAULT_DIALOGR_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla de Regi\00F3n de Contenido de Cuadro de Di\00E1logo por Defecto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275772316900866160)
,p_name=>'DEFAULT_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina por Defecto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275300833938865858)
,p_name=>'DEFAULT_TABLESPACE'
,p_message_language=>'es'
,p_message_text=>'tablespace por defecto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275302521081865859)
,p_name=>'DEFAULT_TABLESPACE_INIT'
,p_message_language=>'es'
,p_message_text=>'Tablespace por defecto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275590242779866047)
,p_name=>'DEFAULT_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla por Defecto'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274905112453865603)
,p_name=>'DEFINED_BY_DA'
,p_message_language=>'es'
,p_message_text=>unistr('Definida por Acci\00F3n Din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275835927763866199)
,p_name=>'DEFINED_TABS'
,p_message_language=>'es'
,p_message_text=>unistr('Esta aplicaci\00F3n tiene %0 separadores organizados en %1 juegos de separadores y tiene definidos %2 separadores principales.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275192145647865788)
,p_name=>'DEFINE_LOV'
,p_message_language=>'es'
,p_message_text=>'Definir Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275357036644865895)
,p_name=>'DEFINITION'
,p_message_language=>'es'
,p_message_text=>unistr('Definici\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275524603977866006)
,p_name=>'DEINSTALLATION_SCRIPT'
,p_message_language=>'es'
,p_message_text=>unistr('Script de Desinstalaci\00F3n')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275128709089865747)
,p_name=>'DELETE'
,p_message_language=>'es'
,p_message_text=>'suprimir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275020348801865676)
,p_name=>'DELETED'
,p_message_language=>'es'
,p_message_text=>'Suprimido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276108991498866367)
,p_name=>'DELETE_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Suprimir Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275581932068866042)
,p_name=>'DELETE_LABEL'
,p_message_language=>'es'
,p_message_text=>'Suprimir: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275557747155866027)
,p_name=>'DELETE_LINK_TEXT'
,p_message_language=>'es'
,p_message_text=>'Suprimir %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274933790797865621)
,p_name=>'DELETE_MSG'
,p_message_language=>'es'
,p_message_text=>unistr('\00BFDesea realizar esta acci\00F3n de supresi\00F3n?')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274971488450865645)
,p_name=>'DEMO.COLLECT.DESCR'
,p_message_language=>'es'
,p_message_text=>unistr('Muestra de Recopilaciones le permite almacenar filas de datos para su uso en una sesi\00F3n de Oracle Application Express. Esta aplicaci\00F3n de base de datos ilustra c\00F3mo utilizar PL/SQL para crear y gestionar el estado de la sesi\00F3n basada en recopilacione')
||'s.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274971214987865645)
,p_name=>'DEMO.SAMPLE.APP'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n de Ejemplo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274971381263865645)
,p_name=>'DEMO.SAMPLE.APP.DESCR'
,p_message_language=>'es'
,p_message_text=>unistr('Product Portal es una aplicaci\00F3n de ejemplo que resalta los conceptos de dise\00F1o comunes. Incluye p\00E1ginas dedicadas para clientes, productos y \00F3rdenes, adem\00E1s de demostrar el uso de los informes, los gr\00E1ficos, el calendario, el mapa y el \00E1rbol.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275379707021865909)
,p_name=>'DEMONSTRABLE'
,p_message_language=>'es'
,p_message_text=>'Demostrable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275109509821865735)
,p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK'
,p_message_language=>'es'
,p_message_text=>unistr('Ejemplos de informes robustos y conceptos de paginaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275109248464865735)
,p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE'
,p_message_language=>'es'
,p_message_text=>unistr('Ejemplo del almac\00E9n en l\00EDnea creado mediante %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275109949639865735)
,p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL'
,p_message_language=>'es'
,p_message_text=>unistr('Aprenda c\00F3mo utilizar Oracle Text con %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275110303340865735)
,p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING'
,p_message_language=>'es'
,p_message_text=>unistr('Ejemplo de aplicaci\00F3n de seguimiento de estado del proyecto creada con %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275109753094865735)
,p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES'
,p_message_language=>'es'
,p_message_text=>'Aprenda a utilizar los servicios Web con %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275108094077865734)
,p_name=>'DEMO_APPLICATION.ACTION'
,p_message_language=>'es'
,p_message_text=>unistr('Acci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275105802910865732)
,p_name=>'DEMO_APPLICATION.APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275105573723865732)
,p_name=>'DEMO_APPLICATION.BASIC_LEXER'
,p_message_language=>'es'
,p_message_text=>'BASIC_LEXER'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275109469462865735)
,p_name=>'DEMO_APPLICATION.BUSINESS_LOOK'
,p_message_language=>'es'
,p_message_text=>'Aspecto de Negocio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275108195111865734)
,p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE'
,p_message_language=>'es'
,p_message_text=>'Muestra de Recopilaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275105632144865732)
,p_name=>'DEMO_APPLICATION.CONTEXT_INDEX'
,p_message_language=>'es'
,p_message_text=>unistr('\00CDndice CONTEXT')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275105071111865732)
,p_name=>'DEMO_APPLICATION.CREATE_BASIC'
,p_message_language=>'es'
,p_message_text=>unistr('Va a crear la aplicaci\00F3n de demostraci\00F3n de Ejemplos B\00E1sicos.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275103600808865731)
,p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK'
,p_message_language=>'es'
,p_message_text=>unistr('Va a volver a crear la aplicaci\00F3n de demostraci\00F3n de aspecto de negocio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275105160260865732)
,p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE'
,p_message_language=>'es'
,p_message_text=>unistr('Va a crear la aplicaci\00F3n de demostraci\00F3n de Muestra de Recopilaciones.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275105281782865732)
,p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE'
,p_message_language=>'es'
,p_message_text=>'crear o volver a crear en el esquema %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275103562610865731)
,p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES'
,p_message_language=>'es'
,p_message_text=>unistr('Cree una aplicaci\00F3n de ejemplo para mostrar los servicios Web.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275103711273865731)
,p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA'
,p_message_language=>'es'
,p_message_text=>unistr('Va a crear la aplicaci\00F3n de demostraci\00F3n Worldcup Mania.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274913684810865609)
,p_name=>'DEMO_APPLICATION.DEINSTALL'
,p_message_language=>'es'
,p_message_text=>'Eliminar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275107888147865734)
,p_name=>'DEMO_APPLICATION.DEMO_APP'
,p_message_language=>'es'
,p_message_text=>unistr('Aplicaci\00F3n de Demostraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275106153698865733)
,p_name=>'DEMO_APPLICATION.FREE_SPACE'
,p_message_language=>'es'
,p_message_text=>'Tiene aproximadamente %0 MB libres.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275108630414865734)
,p_name=>'DEMO_APPLICATION.INSTALL'
,p_message_language=>'es'
,p_message_text=>'Instalar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275108302720865734)
,p_name=>'DEMO_APPLICATION.INSTALLED'
,p_message_language=>'es'
,p_message_text=>'Instalado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275223391611865808)
,p_name=>'DEMO_APPLICATION.INSTALL_DEMO_APP'
,p_message_language=>'es'
,p_message_text=>unistr('Va a instalar la aplicaci\00F3n de ejemplo que le expondr\00E1 una demostraci\00F3n las funciones clave de %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275109387783865735)
,p_name=>'DEMO_APPLICATION.INSTALL_NOW'
,p_message_language=>'es'
,p_message_text=>'Instalar Ahora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275108232449865734)
,p_name=>'DEMO_APPLICATION.LEARN_ABOUT'
,p_message_language=>'es'
,p_message_text=>'Aprenda los conceptos sobre el carro de la compra de %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275561942570866029)
,p_name=>'DEMO_APPLICATION.LOCKED'
,p_message_language=>'es'
,p_message_text=>'Bloqueado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275105904191865732)
,p_name=>'DEMO_APPLICATION.NEED_7M'
,p_message_language=>'es'
,p_message_text=>unistr('La demostraci\00F3n de Discurso Inaugural del Presidente necesita alrededor de 7 MB de espacio libre en disco y puede tardar dos minutos en instalarse en el esquema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275223099624865808)
,p_name=>'DEMO_APPLICATION.NOT_ENOUGH_SPACE_ERR'
,p_message_language=>'es'
,p_message_text=>unistr('No hay suficiente espacio para crear esta demostraci\00F3n. Solicite almacenamiento adicional en la p\00E1gina de administraci\00F3n, accediendo a la secci\00F3n de servicios de provisionamiento y haciendo clic en el enlace para solicitar almacenamiento adicional. %')
||'0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275108578006865734)
,p_name=>'DEMO_APPLICATION.NOT_INSTALLED'
,p_message_language=>'es'
,p_message_text=>'No Instalado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275104455839865731)
,p_name=>'DEMO_APPLICATION.OBJECT_EXIST'
,p_message_language=>'es'
,p_message_text=>'Existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275103380899865731)
,p_name=>'DEMO_APPLICATION.OBJECT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275104397346865731)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275105435178865732)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME2'
,p_message_language=>'es'
,p_message_text=>'Nombre del Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275103472449865731)
,p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS'
,p_message_language=>'es'
,p_message_text=>'no existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275104009333865731)
,p_name=>'DEMO_APPLICATION.OBJECT_RECREATE'
,p_message_language=>'es'
,p_message_text=>unistr('Se volver\00E1n a crear los siguientes objetos de base de datos si \00E9stos existen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275104276845865731)
,p_name=>'DEMO_APPLICATION.OBJECT_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Objeto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275104917771865732)
,p_name=>'DEMO_APPLICATION.PACKAGE'
,p_message_language=>'es'
,p_message_text=>'Paquete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275109127940865734)
,p_name=>'DEMO_APPLICATION.PETSTORE'
,p_message_language=>'es'
,p_message_text=>'Tienda de Animales'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275109836451865735)
,p_name=>'DEMO_APPLICATION.PRESIDENTIAL'
,p_message_language=>'es'
,p_message_text=>'Discursos Inaugurales del Presidente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275110140329865735)
,p_name=>'DEMO_APPLICATION.PROJECT_TRACKING'
,p_message_language=>'es'
,p_message_text=>'Seguimiento de Proyectos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275306523922865862)
,p_name=>'DEMO_APPLICATION.RE_INSTALL'
,p_message_language=>'es'
,p_message_text=>'Volver a Instalar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275108465394865734)
,p_name=>'DEMO_APPLICATION.RUN'
,p_message_language=>'es'
,p_message_text=>'Ejecutar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275104157896865731)
,p_name=>'DEMO_APPLICATION.SCHEMA'
,p_message_language=>'es'
,p_message_text=>'Esquema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275104716636865732)
,p_name=>'DEMO_APPLICATION.SEQUENCE'
,p_message_language=>'es'
,p_message_text=>'Secuencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275107942425865734)
,p_name=>'DEMO_APPLICATION.STATUS'
,p_message_language=>'es'
,p_message_text=>'Estado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275104543659865732)
,p_name=>'DEMO_APPLICATION.TABLE'
,p_message_language=>'es'
,p_message_text=>'Tabla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275107781764865734)
,p_name=>'DEMO_APPLICATION.TABLE_SUMMARY'
,p_message_language=>'es'
,p_message_text=>unistr('Informe de Estado de Instalaci\00F3n de Aplicaci\00F3n de Demostraci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275104827330865732)
,p_name=>'DEMO_APPLICATION.TRIGGER'
,p_message_language=>'es'
,p_message_text=>'Disparador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275562108246866030)
,p_name=>'DEMO_APPLICATION.UNLOCKED'
,p_message_language=>'es'
,p_message_text=>'Desbloqueado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274950687863865632)
,p_name=>'DEMO_APPLICATION.UPDATE_AVAILABLE'
,p_message_language=>'es'
,p_message_text=>unistr('Actualizaci\00F3n Disponible')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276200676754866424)
,p_name=>'DEMO_APPLICATION.WEBSHEET_OBJECT_VALIDATE'
,p_message_language=>'es'
,p_message_text=>unistr('Es necesario corregir los siguientes objetos no v\00E1lidos para ejecutar las hojas web correctamente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275109622459865735)
,p_name=>'DEMO_APPLICATION.WEB_SERVICES'
,p_message_language=>'es'
,p_message_text=>'Servicios Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275106290559865733)
,p_name=>'DEMO_APPLICATION.WILL_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('Se puede producir un error si no vuelve a crear esta demostraci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275039182711865688)
,p_name=>'DEMO_FLOW.CREATED_ERROR'
,p_message_language=>'es'
,p_message_text=>unistr('No hay suficiente espacio para crear esta demostraci\00F3n. Solicite almacenamiento adicional en la p\00E1gina de administraci\00F3n, haciendo clic en el enlace "Solicitar Cambios en Servicio Actual".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275039099990865688)
,p_name=>'DEMO_FLOW.CREATED_SUCCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Se ha creado aplicaci\00F3n de demostraci\00F3n de %0.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275810154846866183)
,p_name=>'DEPRECATED'
,p_message_language=>'es'
,p_message_text=>'En desuso'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274987042085865655)
,p_name=>'DERIVED$'
,p_message_language=>'es'
,p_message_text=>'columna derivada'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275379681420865909)
,p_name=>'DESIRABLE'
,p_message_language=>'es'
,p_message_text=>'Aconsejable'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275455587164865961)
,p_name=>'DETAIL'
,p_message_language=>'es'
,p_message_text=>'Detalle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275522318871866005)
,p_name=>'DETAILS_FOR_ALT_TAG'
,p_message_language=>'es'
,p_message_text=>'Detalles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275455670894865961)
,p_name=>'DETAIL_2'
,p_message_language=>'es'
,p_message_text=>'Detalle 2'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274921713199865614)
,p_name=>'DEVELOPER'
,p_message_language=>'es'
,p_message_text=>'Desarrollador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275528545398866009)
,p_name=>'DEVELOPERS'
,p_message_language=>'es'
,p_message_text=>'Desarrolladores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275400053343865922)
,p_name=>'DEVELOPER_ACTIVITY_SUMMARY'
,p_message_language=>'es'
,p_message_text=>'Resumen de Actividad del Desarrollador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275424915109865938)
,p_name=>'DEVELOPER_SUMMARY'
,p_message_language=>'es'
,p_message_text=>'Resumen de Desarrollador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275605452191866056)
,p_name=>'DEVELOPER_TOOLBAR_CLEAR'
,p_message_language=>'es'
,p_message_text=>'Borrar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275605321806866056)
,p_name=>'DEVELOPER_TOOLBAR_COPY'
,p_message_language=>'es'
,p_message_text=>'Copiar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275634041608866074)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LABEL'
,p_message_language=>'es'
,p_message_text=>'Depurar (%0)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275633534792866074)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL'
,p_message_language=>'es'
,p_message_text=>unistr('Nivel de Depuraci\00F3n por Defecto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275633709042866074)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL4'
,p_message_language=>'es'
,p_message_text=>'Info (por defecto)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275633839048866074)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL6'
,p_message_language=>'es'
,p_message_text=>'Rastreo de Aplicaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275633941612866074)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL9'
,p_message_language=>'es'
,p_message_text=>'Rastreo Completo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275593086377866049)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS'
,p_message_language=>'es'
,p_message_text=>unistr('Se han producido uno o m\00E1s errores desde la carga de la p\00E1gina. Abra la consola de JavaScript del explorador para ver los errores.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275593615774866049)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS_BTN'
,p_message_language=>'es'
,p_message_text=>'Errores de JavaScript'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275688545325866108)
,p_name=>'DEVELOPER_TOOLBAR_NO_BUILDER'
,p_message_language=>'es'
,p_message_text=>unistr('Esta funcionalidad requiere que se abra la ventana del creador de aplicaciones de Application Express. \00BFDesea abrir el creador en esta ventana?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275668467305866095)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS'
,p_message_language=>'es'
,p_message_text=>'Opciones de Barra de Herramientas de Desarrollador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275676718680866101)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_AUTO_HIDE'
,p_message_language=>'es'
,p_message_text=>unistr('Ocultar Autom\00E1ticamente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275676957190866101)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_DISPLAY'
,p_message_language=>'es'
,p_message_text=>unistr('Posici\00F3n de Visualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275676820610866101)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_ICONS_ONLY'
,p_message_language=>'es'
,p_message_text=>'Solo Mostrar Iconos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275677127374866101)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_BOTTOM'
,p_message_language=>'es'
,p_message_text=>'Inferior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275677087540866101)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_LEFT'
,p_message_language=>'es'
,p_message_text=>'Izquierda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275677279108866101)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_RIGHT'
,p_message_language=>'es'
,p_message_text=>'Derecha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275684818021866106)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_TOP'
,p_message_language=>'es'
,p_message_text=>'Superior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275599794930866053)
,p_name=>'DEVELOPER_TOOLBAR_PAGE_INFO'
,p_message_language=>'es'
,p_message_text=>unistr('Informaci\00F3n de p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275599929364866053)
,p_name=>'DEVELOPER_TOOLBAR_PERF_TITLE'
,p_message_language=>'es'
,p_message_text=>unistr('Temporizaci\00F3n del rendimiento de p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275668503113866095)
,p_name=>'DEVELOPER_TOOLBAR_QUICK_EDIT'
,p_message_language=>'es'
,p_message_text=>unistr('Edici\00F3n R\00E1pida')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275599895363866053)
,p_name=>'DEVELOPER_TOOLBAR_SHOW_PERF'
,p_message_language=>'es'
,p_message_text=>unistr('Mostrar temporizaci\00F3n de la p\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276216694282866434)
,p_name=>'DEVELOPER_TOOLBAR_THEME_ROLLER'
,p_message_language=>'es'
,p_message_text=>'Acumulador de Temas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275676633298866101)
,p_name=>'DEVELOPER_TOOLBAR_TITLE'
,p_message_language=>'es'
,p_message_text=>'Barra de Herramientas de Desarrollador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275373111041865905)
,p_name=>'DEVELOPMENT_TASK'
,p_message_language=>'es'
,p_message_text=>'Tarea de Desarrollo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275556208311866026)
,p_name=>'DIAL_CHART_ALERT_VALUE'
,p_message_language=>'es'
,p_message_text=>'Alerta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275556161336866026)
,p_name=>'DIAL_CHART_HIGH_VALUE'
,p_message_language=>'es'
,p_message_text=>'Superior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275556011738866026)
,p_name=>'DIAL_CHART_LOW_VALUE'
,p_message_language=>'es'
,p_message_text=>'Valor Inferior'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274876368395865585)
,p_name=>'DIAL_PCT'
,p_message_language=>'es'
,p_message_text=>'Dial (Porcentaje)'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274957861432865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATIONS'
,p_message_language=>'es'
,p_message_text=>'Aplicaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274960489473865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTH'
,p_message_language=>'es'
,p_message_text=>unistr('Esquemas de Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274960513446865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTHORIZATION'
,p_message_language=>'es'
,p_message_text=>unistr('Esquemas de Autorizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274959690695865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BC_ENTRIES'
,p_message_language=>'es'
,p_message_text=>'Entradas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274959548833865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BREADCRUMBS'
,p_message_language=>'es'
,p_message_text=>unistr('Rutas de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276258467695866461)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BUILD_OPTIONS'
,p_message_language=>'es'
,p_message_text=>unistr('Opciones de Creaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274959241392865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_COMPUTATIONS'
,p_message_language=>'es'
,p_message_text=>unistr('C\00E1lculos de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274959458692865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('Elementos de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274959747090865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LISTS'
,p_message_language=>'es'
,p_message_text=>'Listas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274959891647865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LIST_ENTRIES'
,p_message_language=>'es'
,p_message_text=>'Entradas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274959972979865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOVS'
,p_message_language=>'es'
,p_message_text=>'Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274895987003865597)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_COLS'
,p_message_language=>'es'
,p_message_text=>'Columnas de Listas de Valores:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274960070120865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_ENTRIES'
,p_message_language=>'es'
,p_message_text=>'Entradas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274960194567865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_NAV_BAR'
,p_message_language=>'es'
,p_message_text=>unistr('Barras de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274957994207865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274959185526865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BRANCHES'
,p_message_language=>'es'
,p_message_text=>'Bifurcaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274958382230865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BUTTONS'
,p_message_language=>'es'
,p_message_text=>'Botones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275346153057865888)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHARTS'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275346357693865888)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_A'
,p_message_language=>'es'
,p_message_text=>'Ejes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275346295645865888)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_S'
,p_message_language=>'es'
,p_message_text=>'Serie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274958862385865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_COMP'
,p_message_language=>'es'
,p_message_text=>unistr('C\00E1lculos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275005011078865666)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA'
,p_message_language=>'es'
,p_message_text=>unistr('Acciones Din\00E1micas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275005194157865666)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA_ACTS'
,p_message_language=>'es'
,p_message_text=>unistr('Acci\00F3n Din\00E1mica: Acciones')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275777731449866163)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos Flash 5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275777838692866163)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5_S'
,p_message_language=>'es'
,p_message_text=>'Serie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274958483057865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_CH'
,p_message_language=>'es'
,p_message_text=>unistr('Gr\00E1ficos Flash')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274958575968865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_S'
,p_message_language=>'es'
,p_message_text=>'Serie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274958696196865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR'
,p_message_language=>'es'
,p_message_text=>'Regiones IR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274958747829865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR_COL'
,p_message_language=>'es'
,p_message_text=>'Columnas de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274958139734865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('Elementos de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274959017210865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_PROC'
,p_message_language=>'es'
,p_message_text=>'Procesos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274958082034865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REGIONS'
,p_message_language=>'es'
,p_message_text=>'Regiones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276069801658866343)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REG_COLS'
,p_message_language=>'es'
,p_message_text=>'Columnas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274958214204865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_RPT_COLS'
,p_message_language=>'es'
,p_message_text=>'Columnas de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276165373648866402)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_TREES'
,p_message_language=>'es'
,p_message_text=>unistr('\00C1rboles')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274958948830865637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_VAL'
,p_message_language=>'es'
,p_message_text=>'Validaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274960202354865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PARENT_TABS'
,p_message_language=>'es'
,p_message_text=>'Separadores Principales'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274959371818865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PROCESSES'
,p_message_language=>'es'
,p_message_text=>unistr('Procesos de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276196551775866422)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_LAYOUTS'
,p_message_language=>'es'
,p_message_text=>unistr('Dise\00F1os de Informe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197385044866422)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QRY_STMTS'
,p_message_language=>'es'
,p_message_text=>'Sentencias SQL de consulta de informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276196483727866421)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QUERIES'
,p_message_language=>'es'
,p_message_text=>'Consultas de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276135401439866383)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n de la aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274960687205865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SHORTCUTS'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E9todos Abreviados')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274955822416865635)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_STATIC_FILES'
,p_message_language=>'es'
,p_message_text=>unistr('Archivos de la Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274962179175865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUBSTITUTIONS'
,p_message_language=>'es'
,p_message_text=>'Sustituciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276258105075866460)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJECTS'
,p_message_language=>'es'
,p_message_text=>'Objetos de Soporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276258277329866460)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_BOPT'
,p_message_language=>'es'
,p_message_text=>unistr('Opciones de Creaci\00F3n de Objetos de Soporte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274961946069865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_CHCK'
,p_message_language=>'es'
,p_message_text=>'Objetos de Soporte: Validaciones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274962030757865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_SCR'
,p_message_language=>'es'
,p_message_text=>'Objetos de Soporte: Scripts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274960325204865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TABS'
,p_message_language=>'es'
,p_message_text=>'Separadores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274961034672865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BC'
,p_message_language=>'es'
,p_message_text=>unistr('Plantillas de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274961169989865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BUTTON'
,p_message_language=>'es'
,p_message_text=>unistr('Plantillas de Bot\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274961271498865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_CALENDAR'
,p_message_language=>'es'
,p_message_text=>'Plantillas de Calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275031547868865683)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_GRID'
,p_message_language=>'es'
,p_message_text=>unistr('Plantillas de Cuadr\00EDcula')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274961348398865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LABEL'
,p_message_language=>'es'
,p_message_text=>'Plantillas de Etiqueta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274961473304865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LIST'
,p_message_language=>'es'
,p_message_text=>'Plantillas de Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274961575586865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Plantillas de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274961657042865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_POPUPLOV'
,p_message_language=>'es'
,p_message_text=>'Plantillas de Lista de Valores Emergente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274961783552865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Plantillas de Regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274961800617865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REPORT'
,p_message_language=>'es'
,p_message_text=>'Plantillas de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274960982932865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEMES'
,p_message_language=>'es'
,p_message_text=>'Temas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274938099715865624)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_FILES'
,p_message_language=>'es'
,p_message_text=>'Archivos de Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274884121617865590)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_STYLES'
,p_message_language=>'es'
,p_message_text=>'Estilos de Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275405247055865926)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANSLATIONS'
,p_message_language=>'es'
,p_message_text=>'Mensajes de Texto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274930535146865619)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_DYNAMIC'
,p_message_language=>'es'
,p_message_text=>unistr('Traducciones Din\00E1micas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274930624518865619)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_REPOS'
,p_message_language=>'es'
,p_message_text=>'Texto Traducible'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274960807665865639)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TREES'
,p_message_language=>'es'
,p_message_text=>unistr('\00C1rboles')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274960775543865638)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_WEB_SERVICES'
,p_message_language=>'es'
,p_message_text=>'Servicios Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276156538165866396)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_ROLES'
,p_message_language=>'es'
,p_message_text=>'Roles de Control de Acceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276156602075866397)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USERS'
,p_message_language=>'es'
,p_message_text=>'Usuarios de control de acceso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275446937048865954)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USER_ROLES'
,p_message_language=>'es'
,p_message_text=>unistr('Asignaci\00F3n de rol de usuario de control de acceso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276200201224866424)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_CONCATENATED_FILES'
,p_message_language=>'es'
,p_message_text=>'Archivos Concatenados'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275354177442865893)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILES'
,p_message_language=>'es'
,p_message_text=>unistr('Perfiles de an\00E1lisis de datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275354251135865893)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILE_COLS'
,p_message_language=>'es'
,p_message_text=>unistr('Columnas de perfil de an\00E1lisis de datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276229948943866442)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DEVELOPER_COMMENTS'
,p_message_language=>'es'
,p_message_text=>'Comentarios del Desarrollador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275765506221866155)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE'
,p_message_language=>'es'
,p_message_text=>'Tabla de Carga de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275753703061866148)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLES'
,p_message_language=>'es'
,p_message_text=>'Tablas de Carga de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275753845070866148)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_LOOKUPS'
,p_message_language=>'es'
,p_message_text=>'Consultas de Tabla de Carga de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275753961622866148)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_RULES'
,p_message_language=>'es'
,p_message_text=>unistr('Reglas de Transformaci\00F3n de Tabla de Carga de Datos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274890953288865594)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CALENDARS'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1ginas de Calendario')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275669324363866096)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IGS'
,p_message_language=>'es'
,p_message_text=>unistr('Regiones de Cuadr\00EDcula Interactiva')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275669472179866096)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COLUMNS'
,p_message_language=>'es'
,p_message_text=>'Columnas de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275669518109866096)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COL_GROUPS'
,p_message_language=>'es'
,p_message_text=>'Grupos de Columnas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274978260246865650)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGINS'
,p_message_language=>'es'
,p_message_text=>'Plugins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274978335258865650)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTRIBUTES'
,p_message_language=>'es'
,p_message_text=>'Atributos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275403814191865925)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTR_VALUES'
,p_message_language=>'es'
,p_message_text=>'Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275036319431865686)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_EVENTS'
,p_message_language=>'es'
,p_message_text=>'Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274980729885865651)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_FILES'
,p_message_language=>'es'
,p_message_text=>'Archivos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275456221708865961)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ITEM_FILTERS'
,p_message_language=>'es'
,p_message_text=>'Operadores de Filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276258335518866460)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_SETTINGS'
,p_message_language=>'es'
,p_message_text=>'Valores de Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276171144070866406)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_STD_ATTRS'
,p_message_language=>'es'
,p_message_text=>unistr('Metadatos de Atributo Est\00E1ndar de Plugin')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275354094254865893)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_REMOTE_SQL'
,p_message_language=>'es'
,p_message_text=>'Servidores de SQL activado para REST'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276069730201866343)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPTIONS'
,p_message_language=>'es'
,p_message_text=>'Opciones de Plantilla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276258057723866460)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GROUPS'
,p_message_language=>'es'
,p_message_text=>'Grupos de Opciones de Plantilla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276142339288866388)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GRP'
,p_message_language=>'es'
,p_message_text=>'Grupo de Opciones de Plantilla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276213443556866432)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_PAGE_DP'
,p_message_language=>'es'
,p_message_text=>unistr('Puntos de Visualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276213587568866432)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_REGION_DP'
,p_message_language=>'es'
,p_message_text=>unistr('Puntos de Visualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275034769886865685)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_THEME_DISPLAY_POINTS'
,p_message_language=>'es'
,p_message_text=>unistr('Puntos de Visualizaci\00F3n de Tema')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274955776706865635)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_USER_INTERFACES'
,p_message_language=>'es'
,p_message_text=>'Interfaces de Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275354749971865893)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_COMP_PARAMS'
,p_message_language=>'es'
,p_message_text=>unistr('Par\00E1metros de componente de origen web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275354421532865893)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_MODULES'
,p_message_language=>'es'
,p_message_text=>unistr('M\00F3dulos de origen web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275354503309865893)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_OPERATIONS'
,p_message_language=>'es'
,p_message_text=>'Operaciones de origen web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275354657424865893)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_PARAMETERS'
,p_message_language=>'es'
,p_message_text=>unistr('Par\00E1metros de origen web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275354314571865893)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_SERVERS'
,p_message_language=>'es'
,p_message_text=>'Servidores remotos de origen web'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276173632826866407)
,p_name=>'DISABLED_NEXT_BUTTON'
,p_message_language=>'es'
,p_message_text=>unistr('Bot\00F3n Siguiente Desactivado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276173554607866407)
,p_name=>'DISABLED_PREVIOUS_BUTTON'
,p_message_language=>'es'
,p_message_text=>unistr('Bot\00F3n Anterior Desactivado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275516949849866001)
,p_name=>'DISABLE_TRIGGER'
,p_message_language=>'es'
,p_message_text=>'Desactivar Disparador %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275114270310865738)
,p_name=>'DISPLAY_CONDITION'
,p_message_language=>'es'
,p_message_text=>unistr('Condici\00F3n de Visualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275114436183865738)
,p_name=>'DISPLAY_CONDITION_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Mostrar Texto de Condici\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275582127224866042)
,p_name=>'DISPLAY_ORDER_LABEL'
,p_message_language=>'es'
,p_message_text=>unistr('Orden de Visualizaci\00F3n: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274984739379865654)
,p_name=>'DISPLAY_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de Visualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276257731127866460)
,p_name=>'DISPLAY_VALUE.N'
,p_message_language=>'es'
,p_message_text=>unistr('Valor de Visualizaci\00F3n: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276168995506866404)
,p_name=>'DISTINCT_PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1ginas Distintas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276169076724866404)
,p_name=>'DISTINCT_USERS'
,p_message_language=>'es'
,p_message_text=>'Usuarios Distintos'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274895609066865597)
,p_name=>'DML_FORM'
,p_message_language=>'es'
,p_message_text=>'Pantalla DML'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275202558843865795)
,p_name=>'DO NOT UPDATE PAGE ITEMS'
,p_message_language=>'es'
,p_message_text=>'DO_NOT_UPDATE_PAGE_ITEMS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275395620649865919)
,p_name=>'DOC_IMPACT'
,p_message_language=>'es'
,p_message_text=>unistr('Impacto de Documentaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275396841489865920)
,p_name=>'DOC_STATUS'
,p_message_language=>'es'
,p_message_text=>unistr('Estado de Documentaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275397064883865920)
,p_name=>'DOC_WRITER'
,p_message_language=>'es'
,p_message_text=>unistr('Escritor de Documentaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275274520723865841)
,p_name=>'DOWN'
,p_message_language=>'es'
,p_message_text=>'Descendente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274906095793865604)
,p_name=>'DOWNLOAD'
,p_message_language=>'es'
,p_message_text=>'Descargar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275405027452865925)
,p_name=>'DOWNLOAD_LINK_TEXT'
,p_message_language=>'es'
,p_message_text=>'Texto de Enlace de Descarga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275202248679865795)
,p_name=>'DO_NOT_UPDATE_APPLICATION_ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('No Actualizar Elementos de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275202393868865795)
,p_name=>'DO_NOT_UPDATE_DATA_ENTRY_ITEMS'
,p_message_language=>'es'
,p_message_text=>'No Actualizar Elementos de Entrada de Datos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275202446331865795)
,p_name=>'DO_NOT_UPDATE_DISPLAY_ONLY_ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('No Actualizar Elementos de S\00F3lo Visualizaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275202160510865794)
,p_name=>'DO_NOT_UPDATE_PAGES'
,p_message_language=>'es'
,p_message_text=>unistr('No Actualizar P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275203774132865796)
,p_name=>'DO_NOT_UPDATE_PAGE_ITEMS'
,p_message_language=>'es'
,p_message_text=>unistr('No Actualizar Elementos de P\00E1gina')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275082795067865717)
,p_name=>'DRAG_AND_DROP'
,p_message_language=>'es'
,p_message_text=>'Arrastrar y Soltar'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274975482249865648)
,p_name=>'DRILLDOWN'
,p_message_language=>'es'
,p_message_text=>'Aumentar Detalle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274975354272865648)
,p_name=>'DRILLUP'
,p_message_language=>'es'
,p_message_text=>'Reducir Detalle'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275131012053865749)
,p_name=>'DRIVEN'
,p_message_language=>'es'
,p_message_text=>'controlado'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275516730916866001)
,p_name=>'DROP TRIGGER'
,p_message_language=>'es'
,p_message_text=>'Borrar Disparador %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275515611490866001)
,p_name=>'DROP_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Borrar Columna %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275749092138866145)
,p_name=>'DS_ACCESS_METHOD'
,p_message_language=>'es'
,p_message_text=>unistr('M\00E9todo de Acceso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275748899738866145)
,p_name=>'DS_BIND_VARIABLE_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Variable de Enlace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275749239199866145)
,p_name=>'DS_HANDLER'
,p_message_language=>'es'
,p_message_text=>'Manejador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275749622651866146)
,p_name=>'DS_ITEMS_PER_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Elementos por P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275749404900866146)
,p_name=>'DS_MIME_TYPES_ALLOWED'
,p_message_language=>'es'
,p_message_text=>'Tipos MIME Permitidos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275749560380866146)
,p_name=>'DS_ORIGINS_ALLOWED'
,p_message_language=>'es'
,p_message_text=>unistr('Or\00EDgenes Permitidos')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275749169622866145)
,p_name=>'DS_PARAMETER_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('Tipo de Par\00E1metro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275749791931866146)
,p_name=>'DS_SECURITY_CONSTRAINT'
,p_message_language=>'es'
,p_message_text=>unistr('Restricci\00F3n de Seguridad')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275748930489866145)
,p_name=>'DS_SOURCE'
,p_message_language=>'es'
,p_message_text=>'Origen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275749389721866146)
,p_name=>'DS_SOURCE_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo de Origen'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275749874979866146)
,p_name=>'DS_URI_PREFIX'
,p_message_language=>'es'
,p_message_text=>'Prefijo de URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275748588643866145)
,p_name=>'DS_URI_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>'Plantilla de URI'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197469647866422)
,p_name=>'DUE'
,p_message_language=>'es'
,p_message_text=>'Pendiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275396670948865920)
,p_name=>'DUE_DATE'
,p_message_language=>'es'
,p_message_text=>'Fecha de Vencimiento'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275376449258865907)
,p_name=>'DUPLICATE'
,p_message_language=>'es'
,p_message_text=>'Duplicado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276169865893866405)
,p_name=>'DUPLICATE_USER'
,p_message_language=>'es'
,p_message_text=>'Usuario Duplicado en la Lista'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275819031642866188)
,p_name=>'DUP_USER'
,p_message_language=>'es'
,p_message_text=>'Nombre de usuario duplicado en la lista.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274884578912865590)
,p_name=>'DYNAMIC ACTION'
,p_message_language=>'es'
,p_message_text=>unistr('Acci\00F3n Din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274884442502865590)
,p_name=>'DYNAMIC ACTIONS'
,p_message_language=>'es'
,p_message_text=>unistr('Acciones Din\00E1micas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274894293454865596)
,p_name=>'DYNAMIC_FORM'
,p_message_language=>'es'
,p_message_text=>unistr('Pantalla Din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275020420657865676)
,p_name=>'DYNAMIC_HTML'
,p_message_language=>'es'
,p_message_text=>unistr('HTML din\00E1mico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275081500489865717)
,p_name=>'DYNAMIC_QUERY'
,p_message_language=>'es'
,p_message_text=>'Informe Interactivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274882007343865589)
,p_name=>'DYNAMIC_REFERENCE'
,p_message_language=>'es'
,p_message_text=>unistr('Referencia Din\00E1mica')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275190437834865787)
,p_name=>'EASY_REPORT.INVALID_CONDITION'
,p_message_language=>'es'
,p_message_text=>unistr('La condici\00F3n que est\00E1 agregando ha provocado que la consulta sea no v\00E1lida.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274975586288865648)
,p_name=>'EDIT'
,p_message_language=>'es'
,p_message_text=>'Editar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274889767305865593)
,p_name=>'EDIT PAGE GROUP'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Grupo de P\00E1ginas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275439939342865949)
,p_name=>'EDITOR_EXIT'
,p_message_language=>'es'
,p_message_text=>unistr('Si hace clic en Aceptar se perder\00E1n los cambios no guardados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274921036950865613)
,p_name=>'EDIT_ALL'
,p_message_language=>'es'
,p_message_text=>'Editar Todo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275191610841865788)
,p_name=>'EDIT_ALL_PAGE_DEFINITION_ATTRIBUTES'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Todos los Atributos de Definici\00F3n de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275434111325865944)
,p_name=>'EDIT_ALL_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Editar todos los elementos de esta regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275360256778865897)
,p_name=>'EDIT_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275454319030865960)
,p_name=>'EDIT_ATTRIBUTE'
,p_message_language=>'es'
,p_message_text=>'Editar Atributo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276109111536866367)
,p_name=>'EDIT_AUTHENTICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Autenticaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275444385111865952)
,p_name=>'EDIT_COMPONENT'
,p_message_language=>'es'
,p_message_text=>'Editar Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275454404484865960)
,p_name=>'EDIT_COMPONENT_DEF'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Definici\00F3n de Componente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275556937627866026)
,p_name=>'EDIT_LINK_TEXT'
,p_message_language=>'es'
,p_message_text=>'Editar %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275454219817865960)
,p_name=>'EDIT_LIST_DEV'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Definici\00F3n de Lista')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276183895315866414)
,p_name=>'EDIT_LOCK'
,p_message_language=>'es'
,p_message_text=>'Editar Bloqueo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275319722251865871)
,p_name=>'EDIT_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Editar P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275194186971865789)
,p_name=>'EDIT_PAGE_ATTRIBUTES'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Atributos de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275817587339866187)
,p_name=>'EDIT_PROFILE'
,p_message_language=>'es'
,p_message_text=>'Editar Perfil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275838451080866200)
,p_name=>'EDIT_PROFILE.USER_NO_PRIV_ERR'
,p_message_language=>'es'
,p_message_text=>unistr('El usuario 0% no tiene privilegios para actualizar la informaci\00F3n de otro usuario.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275444105884865952)
,p_name=>'EDIT_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Regi\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275529304407866009)
,p_name=>'EDIT_REPORTING_TIMEFRAME'
,p_message_language=>'es'
,p_message_text=>'Editar Marco Temporal de Informes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275444206179865952)
,p_name=>'EDIT_REPORT_COLS'
,p_message_language=>'es'
,p_message_text=>'Editar Columnas de Informe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275810936520866183)
,p_name=>'EDIT_REPORT_DIALOG_CLOSED_DA'
,p_message_language=>'es'
,p_message_text=>unistr('Editar Informe: Cuadro de Di\00E1logo Cerrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275433197818865944)
,p_name=>'EDIT_SYSTEM_MESSAGE'
,p_message_language=>'es'
,p_message_text=>'Editar Mensaje de Sistema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275772141277866159)
,p_name=>'EDIT_TAB'
,p_message_language=>'es'
,p_message_text=>'Editar Separador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275455986915865961)
,p_name=>'EDIT_THIS_ATTRIBUTE'
,p_message_language=>'es'
,p_message_text=>'Editar este atributo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275296869985865855)
,p_name=>'ELAPSED_TIME'
,p_message_language=>'es'
,p_message_text=>'Tiempo Transcurrido'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275383815560865912)
,p_name=>'EMAIL.TEMPLATE.FOOTER_EXAMPLE'
,p_message_language=>'es'
,p_message_text=>unistr('<a href="#MY_APPLICATION_LINK#">Visite Mi aplicaci\00F3n y gestione las preferencias de correo electr\00F3nico</a>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275391097509865916)
,p_name=>'EMAIL.TEMPLATE.HEADER_EXAMPLE'
,p_message_language=>'es'
,p_message_text=>unistr('<b style="font-size: 24px;">Mi aplicaci\00F3n</b>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275516069546866001)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.EV'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>Hola, #INVITEE#:</b><br>',
'<br>',
unistr('Esto es el recordatorio de un evento pr\00F3ximo al que se le ha invitado.  A continuaci\00F3n se muestran los detalles del evento:<br>'),
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Organizador</th>',
'    <td>#ORGANIZER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Fecha del evento</th>',
'    <td>#EVENT_DATE#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Hora de inicio</th>',
'    <td>#START_TIME#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left">Duraci\00F3n</th>'),
'    <td>#DURATION#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left" valign="top">Ubicaci\00F3n</th>'),
'    <td>#LOCATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">URL</th>',
'    <td><a href="#URL_LINK#">#URL_NAME#</a></td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Notas</th>',
'    <td>#NOTES#</td>',
'  </tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275383728801865912)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.OD'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>Hola, #CUSTOMER_NAME#</b>:<br>',
'<br>',
'Gracias por su orden.<br>',
'<br>',
'<b>Detalles de la orden</b><br>',
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Fecha de la orden</th>',
'    <td>#ORDER_DATE#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left">N\00FAmero del orden</th>'),
'    <td>#ORDER_NUMBER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Enviar a</th>',
'    <td>#SHIP_TO#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left" valign="top">Direcci\00F3n de env\00EDo</th>'),
'    <td>',
'      #SHIPPING_ADDRESS_LINE_1#<br>',
'      #SHIPPING_ADDRESS_LINE_2#',
'    </td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Productos solicitados</th>',
'    <td>#ITEMS_ORDERED#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Total de orden</th>',
'    <td>#ORDER_TOTAL#</td>',
'  </tr>',
'</table>',
'<br>',
'<br>',
unistr('\00BFTiene que realizar alg\00FAn cambio en su orden? <a href="#ORDER_URL#">Gestione su orden #ORDER_NUMBER# aqu\00ED.</a>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275811290997866183)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.SO'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hola, #SERVICE_USER#:<br>',
'<br>',
unistr('Tenga en cuenta que el servicio #SERVICE_NAME# tiene pr\00F3xima una interrupci\00F3n programada.<br>'),
unistr('La interrupci\00F3n est\00E1 programada para empezar a las #OUTAGE_START# y se estima que no estar\00E1 disponible durante #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.<br>'),
'<br>',
unistr('Mientras se ejecuta esta interrupci\00F3n programada, se realizar\00E1 lo siguiente:<br>'),
'#OUTAGE_REASON#<br>',
'<br>',
'<br>',
unistr('Si tiene cualquier problema relacionado con esta interrupci\00F3n, contacte con #OUTAGE_CONTACT#.<br>'),
'<br>',
unistr('Gracias por su comprensi\00F3n.<br>'),
'#SERVICE_TEAM#',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275810696681866183)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.EV'
,p_message_language=>'es'
,p_message_text=>'Recordatorio de evento: #EVENT_NAME#'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275810762518866183)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.OD'
,p_message_language=>'es'
,p_message_text=>'Orden (#ORDER_NUMBER#) confirmada.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275516257671866001)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.EV'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hola, #INVITEE#:',
'',
unistr('Le escribimos para recordarle que pr\00F3ximamente tendr\00E1 lugar un evento al que est\00E1 asociado.'),
'',
'Fecha del evento: #EVENT_DATE#',
'Hora de inicio: #START_TIME#',
unistr('Duraci\00F3n:   #DURATION#'),
'Organizador:  #ORGANIZER#',
unistr('Ubicaci\00F3n:   #LOCATION#'),
'URL:        #URL_NAME# (#URL_LINK#)',
'Notas:      #NOTES#',
'',
unistr('Consulte informaci\00F3n adicional del evento aqu\00ED: #EVENT_LINK#')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275516127232866001)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.OD'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hola, #CUSTOMER_NAME#:',
'',
'Gracias por su orden.',
'',
'Detalles de orden',
'--------------------------------------------------------------------------------',
'  Fecha de orden:       #ORDER_DATE#',
unistr('  N\00FAmero de orden:     #ORDER_NUMBER#'),
'  Enviar a:          #SHIP_TO#',
unistr('  Direcci\00F3n de env\00EDo: #SHIPPING_ADDRESS_LINE_1#'),
'                    #SHIPPING_ADDRESS_LINE_2#',
'  Productos solicitados:    #ITEMS_ORDERED#',
'  Total de orden:      #ORDER_TOTAL#',
'--------------------------------------------------------------------------------',
'',
unistr('\00BFTiene que realizar alg\00FAn cambio en su orden? Gestione su orden #ORDER_NUMBER# aqu\00ED: #ORDER_URL#')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275811152100866183)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.SO'
,p_message_language=>'es'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hola, #SERVICE_USER#:',
'',
unistr('Tenga en cuenta que el servicio #SERVICE_NAME# tiene pr\00F3xima una interrupci\00F3n programada.'),
unistr('La interrupci\00F3n est\00E1 programada para empezar a las #OUTAGE_START# y se estima que no estar\00E1 disponible durante #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.'),
'',
unistr('Mientras se ejecuta esta interrupci\00F3n programada, se realizar\00E1 lo siguiente:'),
'#OUTAGE_REASON#',
'',
unistr('Si tiene cualquier problema relacionado con esta interrupci\00F3n, contacte con #OUTAGE_CONTACT#.'),
'',
unistr('Gracias por su comprensi\00F3n.'),
'#SERVICE_TEAM#',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275051052562865697)
,p_name=>'EMAIL_NOT_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado la direcci\00F3n de correo electr\00F3nico "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274922097210865614)
,p_name=>'EMAIL_SENT_BY'
,p_message_language=>'es'
,p_message_text=>unistr('Este correo electr\00F3nico lo ha enviado %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275819234274866188)
,p_name=>'EMAIL_TOO_LONG'
,p_message_language=>'es'
,p_message_text=>unistr('La direcci\00F3n de correo electr\00F3nico es demasiado larga. El l\00EDmite es de 240 caracteres.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275438010901865947)
,p_name=>'ENABLE_DEBUGGING'
,p_message_language=>'es'
,p_message_text=>unistr('Activar Depuraci\00F3n (S\00ED o No)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275516812917866001)
,p_name=>'ENABLE_TRIGGER'
,p_message_language=>'es'
,p_message_text=>'Activar Disparador %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274923665558865615)
,p_name=>'ENCRYPTION_INPUT_TOO_LONG'
,p_message_language=>'es'
,p_message_text=>'La longitud del valor que se va a cifrar no puede exceder los 4000 bytes.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274921875001865614)
,p_name=>'END_USER'
,p_message_language=>'es'
,p_message_text=>'Usuario Final'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275372786623865905)
,p_name=>'ENHANCEMENT_REQUEST'
,p_message_language=>'es'
,p_message_text=>'Solicitud de Mejora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275839136300866201)
,p_name=>'ENHANCEMENT_REQUEST_DASH'
,p_message_language=>'es'
,p_message_text=>'Solicitudes de Mejora: %1 de %0 cerradas'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275375940676865907)
,p_name=>'ENTERED'
,p_message_language=>'es'
,p_message_text=>'Introducido '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274888323022865593)
,p_name=>'ENTER_WEBSHEETS_CREDENTIALS'
,p_message_language=>'es'
,p_message_text=>'Introduzca las credenciales de las hojas web.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275361956849865898)
,p_name=>'ENTRY LINK'
,p_message_language=>'es'
,p_message_text=>'Enlace de Entrada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275361855569865898)
,p_name=>'ENTRY TEXT'
,p_message_language=>'es'
,p_message_text=>'Texto de Entrada'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275276853869865842)
,p_name=>'ERROR'
,p_message_language=>'es'
,p_message_text=>'Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275420589502865935)
,p_name=>'ERROR PAGE TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Plantilla de P\00E1gina de Error')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275272243425865839)
,p_name=>'ERRORPAGE'
,p_message_language=>'es'
,p_message_text=>unistr('En P\00E1gina de Error')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275434737728865945)
,p_name=>'ERRORS'
,p_message_language=>'es'
,p_message_text=>'Errores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275363129010865898)
,p_name=>'ERROR_ICON'
,p_message_language=>'es'
,p_message_text=>'Icono de Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276195819814866421)
,p_name=>'ERROR_MESSAGE'
,p_message_language=>'es'
,p_message_text=>'Mensaje de Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275522552161866005)
,p_name=>'ERROR_SET_ITEM_STATE_FOR_PPR_REGION'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha podido definir el valor de origen del elemento de la p\00E1gina para la regi\00F3n de refrescamiento de la p\00E1gina parcial')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275355291350865893)
,p_name=>'ESCAPED_COL_TOO_LARGE'
,p_message_language=>'es'
,p_message_text=>unistr('<br><b>Los datos de escape exceden el l\00EDmite permitido, los resultados se han recortado a 32 K</b>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275130252545865748)
,p_name=>'ESCAPE_SC'
,p_message_language=>'es'
,p_message_text=>unistr('caracteres especiales de identificaci\00F3n')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275398116950865921)
,p_name=>'ESTIMATED_EFFORT_IN_HOURS'
,p_message_language=>'es'
,p_message_text=>'Esfuerzo Estimado en Horas'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275748788998866145)
,p_name=>'ETAG_QUERY'
,p_message_language=>'es'
,p_message_text=>'Consulta ETAG'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275748629757866145)
,p_name=>'ETAG_TYPE'
,p_message_language=>'es'
,p_message_text=>'Tipo ETAG'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275373387731865905)
,p_name=>'EVENT'
,p_message_language=>'es'
,p_message_text=>'Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275815742147866186)
,p_name=>'EVENT.APEX.APEXAFTERREFRESH'
,p_message_language=>'es'
,p_message_text=>unistr('Despu\00E9s de Refrescamiento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275816348331866187)
,p_name=>'EVENT.APEX.APEXBEFOREPAGESUBMIT'
,p_message_language=>'es'
,p_message_text=>unistr('Antes de Ejecuci\00F3n de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275815612267866186)
,p_name=>'EVENT.APEX.APEXBEFOREREFRESH'
,p_message_language=>'es'
,p_message_text=>'Antes de Refrescamiento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275819995024866189)
,p_name=>'EVENT.BROWSER'
,p_message_language=>'es'
,p_message_text=>'Eventos de Explorador'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275186788251865785)
,p_name=>'EVENT.BROWSER.APEXDOUBLETAP'
,p_message_language=>'es'
,p_message_text=>'Tocar dos veces'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275186964022865785)
,p_name=>'EVENT.BROWSER.APEXPAN'
,p_message_language=>'es'
,p_message_text=>'Desplazar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275186849223865785)
,p_name=>'EVENT.BROWSER.APEXPRESS'
,p_message_language=>'es'
,p_message_text=>'Pulsar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275187008283865785)
,p_name=>'EVENT.BROWSER.APEXSWIPE'
,p_message_language=>'es'
,p_message_text=>'Deslizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275186678592865784)
,p_name=>'EVENT.BROWSER.APEXTAP'
,p_message_language=>'es'
,p_message_text=>'Pulsar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275815145638866186)
,p_name=>'EVENT.BROWSER.CHANGE'
,p_message_language=>'es'
,p_message_text=>'Cambiar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275814437613866185)
,p_name=>'EVENT.BROWSER.CLICK'
,p_message_language=>'es'
,p_message_text=>'Clic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275814580361866185)
,p_name=>'EVENT.BROWSER.DBLCLICK'
,p_message_language=>'es'
,p_message_text=>'Doble Clic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275813974694866185)
,p_name=>'EVENT.BROWSER.FOCUSIN'
,p_message_language=>'es'
,p_message_text=>'Obtener Enfoque'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275813810164866185)
,p_name=>'EVENT.BROWSER.FOCUSOUT'
,p_message_language=>'es'
,p_message_text=>'Perder Enfoque'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275815336274866186)
,p_name=>'EVENT.BROWSER.KEYDOWN'
,p_message_language=>'es'
,p_message_text=>'Tecla Abajo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275815442555866186)
,p_name=>'EVENT.BROWSER.KEYPRESS'
,p_message_language=>'es'
,p_message_text=>unistr('Pulsaci\00F3n de Tecla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275815504968866186)
,p_name=>'EVENT.BROWSER.KEYUP'
,p_message_language=>'es'
,p_message_text=>unistr('Liberaci\00F3n de Tecla')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275814097113866185)
,p_name=>'EVENT.BROWSER.LOAD'
,p_message_language=>'es'
,p_message_text=>'Carga de Recurso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275814623435866186)
,p_name=>'EVENT.BROWSER.MOUSEDOWN'
,p_message_language=>'es'
,p_message_text=>unistr('Pulsaci\00F3n del Bot\00F3n del Mouse')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275814990259866186)
,p_name=>'EVENT.BROWSER.MOUSEENTER'
,p_message_language=>'es'
,p_message_text=>'Acercamiento del Mouse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275815085322866186)
,p_name=>'EVENT.BROWSER.MOUSELEAVE'
,p_message_language=>'es'
,p_message_text=>'Alejamiento del Mouse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275814828205866186)
,p_name=>'EVENT.BROWSER.MOUSEMOVE'
,p_message_language=>'es'
,p_message_text=>'Movimiento de Mouse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275814726900866186)
,p_name=>'EVENT.BROWSER.MOUSEUP'
,p_message_language=>'es'
,p_message_text=>unistr('Liberaci\00F3n del Bot\00F3n del Mouse')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274887302045865592)
,p_name=>'EVENT.BROWSER.ORIENTATIONCHANGE'
,p_message_language=>'es'
,p_message_text=>unistr('Cambio de Orientaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275824821269866192)
,p_name=>'EVENT.BROWSER.READY'
,p_message_language=>'es'
,p_message_text=>unistr('Carga de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275814152343866185)
,p_name=>'EVENT.BROWSER.RESIZE'
,p_message_language=>'es'
,p_message_text=>unistr('Cambiar Tama\00F1o')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275814273263866185)
,p_name=>'EVENT.BROWSER.SCROLL'
,p_message_language=>'es'
,p_message_text=>'Desplazar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274887494897865592)
,p_name=>'EVENT.BROWSER.SCROLLSTART'
,p_message_language=>'es'
,p_message_text=>'Desplazar Inicio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274887547526865592)
,p_name=>'EVENT.BROWSER.SCROLLSTOP'
,p_message_language=>'es'
,p_message_text=>'Desplazar Parada'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275815297305866186)
,p_name=>'EVENT.BROWSER.SELECT'
,p_message_language=>'es'
,p_message_text=>'Seleccionar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274886549419865591)
,p_name=>'EVENT.BROWSER.SWIPE'
,p_message_language=>'es'
,p_message_text=>'Deslizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274886606533865591)
,p_name=>'EVENT.BROWSER.SWIPELEFT'
,p_message_language=>'es'
,p_message_text=>'Deslizar a la Izquierda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274886791991865592)
,p_name=>'EVENT.BROWSER.SWIPERIGHT'
,p_message_language=>'es'
,p_message_text=>'Deslizar a la Derecha'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274886311141865591)
,p_name=>'EVENT.BROWSER.TAP'
,p_message_language=>'es'
,p_message_text=>'Pulsar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274886402378865591)
,p_name=>'EVENT.BROWSER.TAPHOLD'
,p_message_language=>'es'
,p_message_text=>'Pulsar y Mantener'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275814351581866185)
,p_name=>'EVENT.BROWSER.UNLOAD'
,p_message_language=>'es'
,p_message_text=>unistr('Anulaci\00F3n de Carga de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274887179916865592)
,p_name=>'EVENT.BROWSER.VCLICK'
,p_message_language=>'es'
,p_message_text=>'Clic Virtual'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274887269520865592)
,p_name=>'EVENT.BROWSER.VMOUSECANCEL'
,p_message_language=>'es'
,p_message_text=>'Tocar Cancelar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274886842306865592)
,p_name=>'EVENT.BROWSER.VMOUSEDOWN'
,p_message_language=>'es'
,p_message_text=>'Tocar Inicio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274886940927865592)
,p_name=>'EVENT.BROWSER.VMOUSEMOVE'
,p_message_language=>'es'
,p_message_text=>'Tocar Mover'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274887026773865592)
,p_name=>'EVENT.BROWSER.VMOUSEUP'
,p_message_language=>'es'
,p_message_text=>'Tocar Finalizar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275820177746866189)
,p_name=>'EVENT.COMPONENT'
,p_message_language=>'es'
,p_message_text=>'Eventos de Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274883180134865589)
,p_name=>'EVENT.CUSTOM'
,p_message_language=>'es'
,p_message_text=>'Evento Personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274883251307865589)
,p_name=>'EVENT.CUSTOM.CUSTOM'
,p_message_language=>'es'
,p_message_text=>'Personalizado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275820053415866189)
,p_name=>'EVENT.FRAMEWORK'
,p_message_language=>'es'
,p_message_text=>'Eventos de Marco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275444047196865952)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERCLOSEDIALOG'
,p_message_language=>'es'
,p_message_text=>unistr('Cuadro de Di\00E1logo Cerrado')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276210296498866430)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERREFRESH'
,p_message_language=>'es'
,p_message_text=>unistr('Despu\00E9s de Refrescamiento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276210390657866430)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREPAGESUBMIT'
,p_message_language=>'es'
,p_message_text=>unistr('Antes de Ejecuci\00F3n de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276210124674866430)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREREFRESH'
,p_message_language=>'es'
,p_message_text=>'Antes de Refrescamiento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275357119447865895)
,p_name=>'EVENTS'
,p_message_language=>'es'
,p_message_text=>'Eventos'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275396772269865920)
,p_name=>'EVENT_ID'
,p_message_language=>'es'
,p_message_text=>unistr('N\00FAmero de Hito')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275440347872865949)
,p_name=>'EXACT_SUBS'
,p_message_language=>'es'
,p_message_text=>'Sustituciones Exactas'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275581199574866041)
,p_name=>'EXAMPLE_1'
,p_message_language=>'es'
,p_message_text=>'Ejemplo 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275581245581866041)
,p_name=>'EXAMPLE_2'
,p_message_language=>'es'
,p_message_text=>'Ejemplo 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276114334809866370)
,p_name=>'EXAMPLE_OF_XML_COLUMN'
,p_message_language=>'es'
,p_message_text=>unistr('\00C9ste es un ejemplo de los datos incluidos en una columna de base de datos XML.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276169738703866405)
,p_name=>'EXAMPLE_URI'
,p_message_language=>'es'
,p_message_text=>'URI de Ejemplo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275517994756866002)
,p_name=>'EXCLUDE'
,p_message_language=>'es'
,p_message_text=>'Excluir'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275492037337865986)
,p_name=>'EXISTING_SCHEMA_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Esquema Existente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275430533534865942)
,p_name=>'EXISTS'
,p_message_language=>'es'
,p_message_text=>'Existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274969176506865644)
,p_name=>'EXISTS_SQL_QUERY'
,p_message_language=>'es'
,p_message_text=>'Consulta SQL EXISTS'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275803009806866178)
,p_name=>'EXPANDED'
,p_message_language=>'es'
,p_message_text=>'Ampliado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276164450766866401)
,p_name=>'EXPAND_ALL'
,p_message_language=>'es'
,p_message_text=>'Ampliar Todo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275039826740865688)
,p_name=>'EXPIRED'
,p_message_language=>'es'
,p_message_text=>'Vencido'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275360411913865897)
,p_name=>'EXPLAIN PLAN'
,p_message_language=>'es'
,p_message_text=>unistr('Explicaci\00F3n del Plan')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275357480096865895)
,p_name=>'EXPORT'
,p_message_language=>'es'
,p_message_text=>'Exportar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275773498893866160)
,p_name=>'EXPORT REPOSITORY'
,p_message_language=>'es'
,p_message_text=>unistr('Repositorio de Exportaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275444711276865953)
,p_name=>'EXPORTED_FROM_ANOTHER_WORKSPACE'
,p_message_language=>'es'
,p_message_text=>unistr('Exportado de otro espacio de trabajo o aplicaci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275444822631865953)
,p_name=>'EXPORTED_FROM_CURRENT_WORKSPACE'
,p_message_language=>'es'
,p_message_text=>'Exportado del espacio de trabajo actual.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275524316731866006)
,p_name=>'EXPORT_APPLICATION'
,p_message_language=>'es'
,p_message_text=>unistr('Exportar Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275528927327866009)
,p_name=>'EXPORT_PKG_APP_FOR_DEPLOYMENT'
,p_message_language=>'es'
,p_message_text=>unistr('Utilice estos enlaces para descargar esta aplicaci\00F3n y sus objetos de soporte de base de datos correspondientes para el despliegue en una instalaci\00F3n de Oracle Application Express diferente. Los archivos descargados ser\00E1n scripts SQL que se pueden ej')
||'ecutar desde SQL*Plus, SQL Developer o scripts SQL dentro de Oracle Application Express.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275524419226866006)
,p_name=>'EXPORT_SUPPORTING_OBJECTS'
,p_message_language=>'es'
,p_message_text=>'Exportar Objetos de Soporte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275357733034865895)
,p_name=>'EXPORT_TYPES.APP_EXPORT'
,p_message_language=>'es'
,p_message_text=>unistr('Exportaci\00F3n de Aplicaci\00F3n  ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275357906423865895)
,p_name=>'EXPORT_TYPES.CSS_EXPORT'
,p_message_language=>'es'
,p_message_text=>unistr('Exportaci\00F3n de Hojas de Estilo en Cascada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275358152732865895)
,p_name=>'EXPORT_TYPES.FILE_EXPORT'
,p_message_language=>'es'
,p_message_text=>unistr('Exportaci\00F3n de Archivo Est\00E1tico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275358053200865895)
,p_name=>'EXPORT_TYPES.IMAGE_EXPORT'
,p_message_language=>'es'
,p_message_text=>unistr('Exportaci\00F3n de Imagen')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275357830588865895)
,p_name=>'EXPORT_TYPES.PAGE_EXPORT'
,p_message_language=>'es'
,p_message_text=>unistr('Exportaci\00F3n de P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275358266756865895)
,p_name=>'EXPORT_TYPES.SCRIPT_FILE_EXPORT'
,p_message_language=>'es'
,p_message_text=>unistr('Exportaci\00F3n de Script')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275353950602865893)
,p_name=>'EXPORT_TYPES.UI_DEFAULTS'
,p_message_language=>'es'
,p_message_text=>'Valores por Defecto de Interfaz de Usuario'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275279931907865844)
,p_name=>'F4000.APPLICATION_COMPUTATION'
,p_message_language=>'es'
,p_message_text=>unistr('C\00E1lculo de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275277717737865843)
,p_name=>'F4000.APPLICATION_ITEM'
,p_message_language=>'es'
,p_message_text=>unistr('Elemento de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275279753060865844)
,p_name=>'F4000.APPLICATION_PROCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Proceso de Aplicaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275104677963865732)
,p_name=>'F4000.APPLICATION_RESERVED'
,p_message_language=>'es'
,p_message_text=>unistr('Los identificadores de aplicaci\00F3n del 3000 al 8999 est\00E1n reservados.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274970402414865645)
,p_name=>'F4000.APP_EXPORT_CURR_WS'
,p_message_language=>'es'
,p_message_text=>unistr('Esta aplicaci\00F3n se ha exportado desde el espacio de trabajo actual.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274970511675865645)
,p_name=>'F4000.APP_EXPORT_NON_CURR_WS'
,p_message_language=>'es'
,p_message_text=>unistr('Esta aplicaci\00F3n se ha exportado desde otro espacio de trabajo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275279688640865844)
,p_name=>'F4000.BRANCH'
,p_message_language=>'es'
,p_message_text=>unistr('Bifurcaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275292208058865852)
,p_name=>'F4000.BRANCH_FROM_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Bifurcar desde P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275292431671865853)
,p_name=>'F4000.BRANCH_TO_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('Bifurcar a P\00E1gina')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275279247128865844)
,p_name=>'F4000.BUTTON'
,p_message_language=>'es'
,p_message_text=>unistr('Bot\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275429421410865941)
,p_name=>'F4000.BUTTON.ITEM'
,p_message_language=>'es'
,p_message_text=>unistr('Elemento de Bot\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275031494282865683)
,p_name=>'F4000.CALENDAR'
,p_message_language=>'es'
,p_message_text=>'Calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275176922192865778)
,p_name=>'F4000.CALENDAR_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna de calendario.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275292890901865853)
,p_name=>'F4000.COLUMN_ATTRIBUTES'
,p_message_language=>'es'
,p_message_text=>'Atributos de Columna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276127256783866378)
,p_name=>'F4000.COLUMN_NAME_RESERVED_WORD'
,p_message_language=>'es'
,p_message_text=>'El nombre de columna identificado es una palabra reservada de Oracle. Seleccione otro nombre.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275306872339865862)
,p_name=>'F4000.DYNAMIC'
,p_message_language=>'es'
,p_message_text=>unistr('Din\00E1mico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274986317387865655)
,p_name=>'F4000.DYNAMIC ACTION'
,p_message_language=>'es'
,p_message_text=>unistr('Acci\00F3n Din\00E1mica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274970340375865645)
,p_name=>'F4000.EXPORT'
,p_message_language=>'es'
,p_message_text=>'Exportar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275309181469865864)
,p_name=>'F4000.FIX_ME'
,p_message_language=>'es'
,p_message_text=>'Corregirme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275306401104865862)
,p_name=>'F4000.FOR_USER'
,p_message_language=>'es'
,p_message_text=>'Para el Usuario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275306366171865862)
,p_name=>'F4000.FOR_USER_SESSION'
,p_message_language=>'es'
,p_message_text=>unistr('Para Sesi\00F3n de Usuario')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275292597079865853)
,p_name=>'F4000.FROM'
,p_message_language=>'es'
,p_message_text=>'de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275105774466865732)
,p_name=>'F4000.HEADER_VALIDATION1'
,p_message_language=>'es'
,p_message_text=>'La cabecera debe incluir las etiquetas <b> &lt;head&gt;</b> y <b>&lt;/head&gt;</b>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275106017396865732)
,p_name=>'F4000.HEADER_VALIDATION2'
,p_message_language=>'es'
,p_message_text=>unistr('La cadena de sustituci\00F3n <b>#HEAD#</b> debe aparecer entre las etiquetas <b> &lt;head&gt;</b> y <b>&lt;/head&gt;</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275370788817865903)
,p_name=>'F4000.INVALID_FILE_TYPE'
,p_message_language=>'es'
,p_message_text=>unistr('El archivo "%0" es de tipo no v\00E1lido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275278936374865844)
,p_name=>'F4000.ITEM_DISPLAY'
,p_message_language=>'es'
,p_message_text=>unistr('Visualizaci\00F3n de Elemento')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275279008518865844)
,p_name=>'F4000.ITEM_READ_ONLY'
,p_message_language=>'es'
,p_message_text=>unistr('Elemento de S\00F3lo Lectura')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274903119621865602)
,p_name=>'F4000.LEGACY_SQL'
,p_message_language=>'es'
,p_message_text=>'SQL heredado'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275458552617865963)
,p_name=>'F4000.LINK_COLUMN'
,p_message_language=>'es'
,p_message_text=>'Columna de Enlace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275311691487865865)
,p_name=>'F4000.LIST_INITCAP'
,p_message_language=>'es'
,p_message_text=>'Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275280398266865845)
,p_name=>'F4000.LIST_ITEM'
,p_message_language=>'es'
,p_message_text=>'Elemento de Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274903094491865602)
,p_name=>'F4000.LOCAL'
,p_message_language=>'es'
,p_message_text=>'Local'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275280692035865845)
,p_name=>'F4000.LOV_ENTRY'
,p_message_language=>'es'
,p_message_text=>'Entrada de Lista de Valores'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275292699535865853)
,p_name=>'F4000.MENU'
,p_message_language=>'es'
,p_message_text=>unistr('Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275280567710865845)
,p_name=>'F4000.MENU_OPTION'
,p_message_language=>'es'
,p_message_text=>unistr('Entrada de Ruta de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275327974237865876)
,p_name=>'F4000.MUST_SELECT_AT_LEAST_ONE_TO_COPY'
,p_message_language=>'es'
,p_message_text=>unistr('Debe seleccionar al menos uno para la copia o suscripci\00F3n.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275280015482865845)
,p_name=>'F4000.NAVIGATION_BAR_ENTRY'
,p_message_language=>'es'
,p_message_text=>unistr('Entrada de Barra de Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275201585156865794)
,p_name=>'F4000.NAVIGATION_BAR_ICON'
,p_message_language=>'es'
,p_message_text=>unistr('Icono&nbsp;de&nbsp;Barra&nbsp;de&nbsp;Navegaci\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275277445062865843)
,p_name=>'F4000.NO'
,p_message_language=>'es'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275306953255865862)
,p_name=>'F4000.NOT_REFERENCED'
,p_message_language=>'es'
,p_message_text=>'Sin Referencia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275289921608865851)
,p_name=>'F4000.NO_DATA_FOUND'
,p_message_language=>'es'
,p_message_text=>unistr('No se ha encontrado ning\00FAn dato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276200388538866424)
,p_name=>'F4000.P1.APP_DOES_NOT_EXIST'
,p_message_language=>'es'
,p_message_text=>unistr('La aplicaci\00F3n %0 no existe en el espacio de trabajo actual.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275836302119866199)
,p_name=>'F4000.P1000.UPDATE_CHECK_DISABLED'
,p_message_language=>'es'
,p_message_text=>unistr('Comprobaci\00F3n de Actualizaci\00F3n desactivada')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275320911316865871)
,p_name=>'F4000.P104.PARENT_TAB_NAME'
,p_message_language=>'es'
,p_message_text=>'Nombre de Separador Principal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274973330483865646)
,p_name=>'F4000.P111.CANCEL_BUTTON_BRANCH'
,p_message_language=>'es'
,p_message_text=>unistr('Cancelar Bifurcaci\00F3n de Bot\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274972916171865646)
,p_name=>'F4000.P111.CANCEL_BUTTON_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Texto de Visualizaci\00F3n del Bot\00F3n Cancelar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274973422718865647)
,p_name=>'F4000.P111.FINISH_BUTTON_BRANCH'
,p_message_language=>'es'
,p_message_text=>unistr('Terminar Bifurcaci\00F3n de Bot\00F3n')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274973001712865646)
,p_name=>'F4000.P111.FINISH_BUTTON_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Texto de Visualizaci\00F3n del Bot\00F3n Terminar')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274973274609865646)
,p_name=>'F4000.P111.NEXT_BUTTON_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Texto de Visualizaci\00F3n del Bot\00F3n Siguiente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(274973163397865646)
,p_name=>'F4000.P111.PREVIOUS_BUTTON_TEXT'
,p_message_language=>'es'
,p_message_text=>unistr('Texto de Visualizaci\00F3n del Bot\00F3n Anterior')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275321058882865871)
,p_name=>'F4000.P112.TREE_PAGE'
,p_message_language=>'es'
,p_message_text=>unistr('P\00E1gina de \00C1rbol')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275321169747865872)
,p_name=>'F4000.P119.GO'
,p_message_language=>'es'
,p_message_text=>'Ir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275321266992865872)
,p_name=>'F4000.P130.USING_SAME_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Utiliza las mismas plantillas que la aplicaci\00F3n existente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276203365774866426)
,p_name=>'F4000.P135.COPY'
,p_message_language=>'es'
,p_message_text=>'Copiar %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276208978181866429)
,p_name=>'F4000.P149.PUBLISH_AUTHORIZATION'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 los siguientes esquemas de autorizaci\00F3n:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276209206833866429)
,p_name=>'F4000.P149.PUBLISH_BREADCRUMB_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes plantillas de ruta de navegaci\00F3n:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276209340084866429)
,p_name=>'F4000.P149.PUBLISH_BUTTON_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes plantillas de bot\00F3n:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276209443760866429)
,p_name=>'F4000.P149.PUBLISH_CALENDAR_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes plantillas de calendario:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276208814351866429)
,p_name=>'F4000.P149.PUBLISH_FIELD_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes plantillas de etiqueta:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276208668175866429)
,p_name=>'F4000.P149.PUBLISH_LIST_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes plantillas de lista:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276208370744866429)
,p_name=>'F4000.P149.PUBLISH_LOV'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes listas de valores:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276209171594866429)
,p_name=>'F4000.P149.PUBLISH_NAVBAR'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes entradas de la barra de navegaci\00F3n:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276208438025866429)
,p_name=>'F4000.P149.PUBLISH_PAGE_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes plantillas de p\00E1gina:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276209544894866429)
,p_name=>'F4000.P149.PUBLISH_PLUGIN'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 los siguientes plugins:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276209655062866430)
,p_name=>'F4000.P149.PUBLISH_POPUP_LOV_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes plantillas de lista de valores emergente:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276208536416866429)
,p_name=>'F4000.P149.PUBLISH_REGION_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes plantillas de regi\00F3n:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276208712746866429)
,p_name=>'F4000.P149.PUBLISH_REPORT_TEMPLATE'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 las siguientes plantillas de informe:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276209040355866429)
,p_name=>'F4000.P149.PUBLISH_SHORTCUT'
,p_message_language=>'es'
,p_message_text=>unistr('Ha solicitado publicar <strong>%0</strong>. Esta acci\00F3n refrescar\00E1 los siguientes accesos directos:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275493358371865987)
,p_name=>'F4000.P149.PUBLISH_WEB_SRC_MODULE'
,p_message_language=>'es'
,p_messa