prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4651
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4651 - Oracle APEX Feedback
--
-- Application Export:
--   Application:     4651
--   Name:            Oracle APEX Feedback
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                     12
--       Items:                  132
--       Computations:             4
--       Processes:               28
--       Regions:                 60
--       Buttons:                 24
--       Dynamic Actions:         10
--     Shared Components:
--       Logic:
--         Items:                 23
--         Processes:              2
--         Computations:           3
--         Build Options:          3
--       Navigation:
--         Lists:                 17
--         Breadcrumbs:            2
--           Entries:             18
--       Security:
--         Authentication:         1
--         Authorization:         12
--       User Interface:
--         Templates:
--           Page:                11
--           Region:              40
--           Label:               11
--           List:                14
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           2
--           Button:              14
--           Report:              10
--         LOVs:                  12
--         Shortcuts:              2
--         Plug-ins:              17
--       Globalization:
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Feedback')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286629813750934394')
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20191024135347'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'es'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(546448889396214216.4651)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_vpd=>'wwv_flow_ws_auth.init_schema;'
,p_security_scheme=>wwv_flow_api.id(185442186271292656)
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'MSG_LANGUAGE'
,p_substitution_value_01=>'Idioma'
,p_substitution_string_02=>'MSG_USER'
,p_substitution_value_02=>'Usuario'
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>'Espacio de Trabajo: &COMPANY.'
,p_substitution_string_04=>'DELETE_MSG'
,p_substitution_value_04=>unistr('\00BFDesea realizar esta acci\00F3n de supresi\00F3n?')
,p_substitution_string_05=>'PRODUCT_NAME'
,p_substitution_value_05=>'Application Express'
,p_substitution_string_06=>'HELP'
,p_substitution_value_06=>'Ayuda'
,p_substitution_string_07=>'EDIT'
,p_substitution_value_07=>'Editar'
,p_substitution_string_08=>'TOP'
,p_substitution_value_08=>'Superior'
,p_substitution_string_09=>'CLOSE'
,p_substitution_value_09=>'Cerrar'
,p_substitution_string_10=>'MSG_COPYRIGHT'
,p_substitution_value_10=>'Copyright &copy; 1999, 2019, Oracle. Todos los derechos reservados.'
,p_substitution_string_11=>'DATE_FORMAT'
,p_substitution_value_11=>'dd/mm/rr'
,p_substitution_string_12=>'MSG_JSCRIPT'
,p_substitution_value_12=>'Debe ejecutar este producto con JavaScript activado.'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141342'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(6552444832780127.4651)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Creador de Aplicaciones'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW::'
,p_list_item_icon_alt_attribute=>'Aumento de detalle del creador de aplicaciones'
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_api.id(185441288973292654)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6553029889780128.4651)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Aplicaciones de Base de Datos'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:DATABASE:'
,p_parent_list_item_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6553448858780129.4651)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('Aplicaciones de Hoja de C\00E1lculo Web')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:WEBSHEET:'
,p_parent_list_item_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6553832952780129.4651)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6554230129780129.4651)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Crear'
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID:'
,p_parent_list_item_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6554662453780129.4651)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Importar'
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:F4000_P56_CREATE_OPTION,P460_FILE_TYPE:IMP,FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6555057506780129.4651)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Exportar'
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6555479185780129.4651)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6555810566780130.4651)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Utilidades del Espacio de Trabajo'
,p_parent_list_item_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6556216171780130.4651)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>'Todas las Utilidades del Espacio de Trabajo'
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(6555810566780130.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6556604967780130.4651)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(6555810566780130.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6557045409780130.4651)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>'Valores por defecto del creador de aplicaciones'
,p_list_item_link_target=>'f?p=4000:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(6555810566780130.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6557464582780130.4651)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>'Temas de Espacio de Trabajo'
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(6555810566780130.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6557829377780130.4651)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>'Grupos de Aplicaciones'
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_api.id(6555810566780130.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6558265248780131.4651)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>'Vistas de Application Express'
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(6555810566780130.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6558615351780131.4651)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>unistr('Informes de Aplicaci\00F3n Cruzados')
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(6555810566780130.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6559051151780131.4651)
,p_list_item_display_sequence=>169
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6559452731780131.4651)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Migraciones'
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6552680406780127.4651)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6559826645780131.4651)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'Taller de SQL'
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>'Aumentar Detalle de Taller de SQL'
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_api.id(185441697843292655)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6560273581780132.4651)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Explorador de Objetos'
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6559826645780131.4651)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6560688848780132.4651)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'Comandos SQL'
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6559826645780131.4651)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6561078707780132.4651)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Scripts SQL'
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6559826645780131.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Utilidades'
,p_parent_list_item_id=>wwv_flow_api.id(6559826645780131.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6561825520780132.4651)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>'Todas las Utilidades'
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6562251856780132.4651)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6562627173780133.4651)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>'Taller de datos'
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6563030434780133.4651)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>'Generador de Consultas'
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6563462532780133.4651)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>unistr('SQL r\00E1pido')
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6563854262780133.4651)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>'Juegos de datos de ejemplo'
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6564205967780133.4651)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>'Generar DDL'
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6564646234780134.4651)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>'Valores por Defecto de Interfaz de Usuario'
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6565048016780134.4651)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>unistr('Comparaci\00F3n de Esquema')
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6565467410780134.4651)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('M\00E9todos de las Tablas')
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6565806035780134.4651)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>'Papelera de Reciclaje'
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6566215767780134.4651)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>'Informes de Objeto'
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6566608568780134.4651)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>'Acerca de la base de datos'
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6567087949780135.4651)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>'Control de Base de Datos'
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(6561479079780132.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6567451057780135.4651)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>'Servicios RESTful'
,p_list_item_link_target=>'f?p=4850:500:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(6559826645780131.4651)
,p_security_scheme=>wwv_flow_api.id(809588105312343619)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6567847019780135.4651)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Desarrollo de Equipos'
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>'Aumentar Detalle de Incidencia'
,p_list_text_01=>'tab-team-dev'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6568296945780135.4651)
,p_list_item_display_sequence=>301
,p_list_item_link_text=>'Etiquetas'
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(6567847019780135.4651)
,p_security_scheme=>wwv_flow_api.id(19014885373808980)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6568636312780136.4651)
,p_list_item_display_sequence=>302
,p_list_item_link_text=>'Hitos'
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(6567847019780135.4651)
,p_security_scheme=>wwv_flow_api.id(19014885373808980)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6569023646780136.4651)
,p_list_item_display_sequence=>303
,p_list_item_link_text=>'Plantillas'
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(6567847019780135.4651)
,p_security_scheme=>wwv_flow_api.id(19014885373808980)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6569433967780136.4651)
,p_list_item_display_sequence=>304
,p_list_item_link_text=>'Utilidades'
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(6567847019780135.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6569824024780136.4651)
,p_list_item_display_sequence=>308
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(6567847019780135.4651)
,p_security_scheme=>wwv_flow_api.id(19014885373808980)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6570277908780136.4651)
,p_list_item_display_sequence=>309
,p_list_item_link_text=>'Comentarios'
,p_list_item_link_target=>'f?p=&APP_ID.:8012:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>'Aumentar Detalle de Desarrollo de Equipos'
,p_parent_list_item_id=>wwv_flow_api.id(6567847019780135.4651)
,p_list_text_01=>'tab-team-dev'
,p_security_scheme=>wwv_flow_api.id(19014885373808980)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6570658889780136.4651)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('Galer\00EDa de aplicaciones')
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_text_01=>'tab-apps'
,p_security_scheme=>wwv_flow_api.id(770236485972215505)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6571046957780137.4651)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>'Aplicaciones de productividad'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:PACKAGE'
,p_parent_list_item_id=>wwv_flow_api.id(6570658889780136.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6571487128780137.4651)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>'Aplicaciones de ejemplo'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:SAMPLE'
,p_parent_list_item_id=>wwv_flow_api.id(6570658889780136.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6571840542780137.4651)
,p_list_item_display_sequence=>425
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(6570658889780136.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6572250788780137.4651)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>unistr('Administraci\00F3n')
,p_list_item_link_target=>'f?p=4750:6:&SESSION.::&DEBUG.:6:'
,p_parent_list_item_id=>wwv_flow_api.id(6570658889780136.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/navigation_icons
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(183873395194737719.4651)
,p_name=>'navigation icons'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183875295836737736.4651)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Comentarios'
,p_list_item_link_target=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/comment.gif'
,p_list_text_01=>'feedback'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'8000'
);
end;
/
prompt --application/shared_components/navigation/lists/navigation_icons_dashboard
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(183892999331937539.4651)
,p_name=>'navigation icons / dashboard'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(183894899015937544.4651)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Comentarios'
,p_list_item_link_target=>'f?p=&APP_ID.:8012:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/comment.gif'
,p_list_text_01=>'feedback'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'8012'
);
end;
/
prompt --application/shared_components/navigation/lists/tasks_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(186750499630485354.4651)
,p_name=>'tasks tabs'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_task_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(186961506868578060.4651)
,p_name=>'Edit Task Actions'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/team
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(187305388135212889.4651)
,p_name=>'Team'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(187439920161634625.4651)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Comentarios'
,p_list_item_link_target=>'f?p=&APP_ID.:8012:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'team-dev-feedback'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/events_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(187448905681160262.4651)
,p_name=>'events tabs'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/team_development_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(187720495709879883.4651)
,p_name=>'Team Development Utilities'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/feature_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(187761296054930199.4651)
,p_name=>'Feature Tabs'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/bug_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(187892701127714718.4651)
,p_name=>'Bug Tabs'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/feedback_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(188228600364085362.4651)
,p_name=>'Feedback Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(189507995768831929.4651)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Panel de control'
,p_list_item_link_target=>'f?p=&APP_ID.:8012:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'8012'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(188228799304085371.4651)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Informe'
,p_list_item_link_target=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'8000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(189008403625092036.4651)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Calendario'
,p_list_item_link_target=>'f?p=&APP_ID.:8011:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'8011'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(188229407853085384.4651)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Por Usuario'
,p_list_item_link_target=>'f?p=&APP_ID.:8005:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'8005'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_bug_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(330195004095908635.4651)
,p_name=>'Edit Bug Actions'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_feature_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(331674799388342537.4651)
,p_name=>'Edit Feature Actions'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(704128726002003936.4651)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704128889353003939.4651)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('Administraci\00F3n')
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704129182327003940.4651)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704129518290003940.4651)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'Gestionar Servicio'
,p_security_scheme=>wwv_flow_api.id(19027996399058141)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704129829532003940.4651)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Gestionar Servicio'
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(704129518290003940.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704130085696003940.4651)
,p_list_item_display_sequence=>215
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(704129518290003940.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704130442814003941.4651)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'Realizar una Solicitud de Servicio'
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(704129518290003940.4651)
,p_security_scheme=>wwv_flow_api.id(19027996399058141)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704131030506003941.4651)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Editar Anuncio'
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(704129518290003940.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704131357914003941.4651)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>'Uso de Espacio de Trabajo'
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(704129518290003940.4651)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704131635045003941.4651)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Gestionar Usuarios y Grupos'
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(19027996399058141)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704131885647003941.4651)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Supervisar actividad'
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(17100680668766728)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704132222469003942.4651)
,p_list_item_display_sequence=>500
,p_list_item_link_text=>'Paneles de control'
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(17100680668766728)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(704133729983005466.4651)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704133911516005467.4651)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Documentaci\00F3n')
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2112462657213593705.4651)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Foro de Discusi\00F3n')
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2192007899943120724.4651)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Oracle Technology Network'
,p_list_item_link_target=>'http://otn.oracle.com/apex'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(704134809327005468.4651)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/to_do_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1273635293832132327.4651)
,p_name=>'To Do Utilities'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/bug_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1273640947705143091.4651)
,p_name=>'Bug Utilities'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(917039639340555.4651)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(8572915507951071.4651)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(21354998114480992.4651)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(98489556254112433.4651)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(275965713197945116.4651)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.D3.BARCHART'
,p_attribute_01=>'3'
,p_attribute_02=>'1.333'
,p_attribute_03=>'480'
,p_attribute_04=>'WINDOW'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1771579147742252115.4651)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1838228900013533939.4651)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1924144112996479973.4651)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2017489143332659140.4651)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.FLOTLINECHART2'
,p_attribute_01=>'3'
,p_attribute_02=>'1.333'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(17100680668766728.4651)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>unistr('No est\00E1 autorizado para acceder a los paneles de control y la actividad de supervisi\00F3n.')
,p_reference_id=>786936829326142579.4651
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(19014885373808980.4651)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('No est\00E1 autorizado para editar aplicaciones')
,p_reference_id=>12480509677812756.4651
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(19027996399058141.4651)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>unistr('No est\00E1 autorizado para administrar aplicaciones')
,p_reference_id=>12511219858301010.4651
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(185441288973292654.4651)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('No tiene privilegios para realizar esta operaci\00F3n')
,p_reference_id=>786516029127697713.4651
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(185441697843292655.4651)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('No est\00E1 autorizado a utilizar Taller de SQL.')
,p_reference_id=>786516265251697717.4651
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(185442186271292656.4651)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>'No se ha activado el desarrollo de equipos para este espacio de trabajo'
,p_reference_id=>786516861027697723.4651
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(185442704279292656.4651)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('No tiene privilegios para realizar esta operaci\00F3n')
,p_reference_id=>786517166823697723.4651
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/team_dev_file_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(330155780902809283.4651)
,p_name=>'Team Dev File Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_team_file.team_dev_file_enabled then',
'   return true;',
'else',
'   return false;',
'end if;'))
,p_error_message=>unistr('Para acceder a esta p\00E1gina es necesario activar los archivos de desarrollo de equipos.')
,p_reference_id=>786943600005207200.4651
,p_caching=>'NOCACHE'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(340808806444504291.4651)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>unistr('SSO de creador no est\00E1 activado')
,p_reference_id=>6738410669854771.4651
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_packaged_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(770236485972215505.4651)
,p_name=>'APEX 5.0 Packaged App Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('No est\00E1 autorizado a instalar aplicaciones empaquetadas')
,p_reference_id=>786517456817697723.4651
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_restful_services_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(809588105312343619.4651)
,p_name=>'APEX 5.0 RESTful Services Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies',
'where ALLOW_RESTFUL_SERVICES_YN = ''Y'' and ',
'      PROVISIONING_COMPANY_ID = :flow_security_group_id',
'and exists (select 1',
'                  from wwv_flow_platform_prefs',
'                 where name  = ''RESTFUL_SERVICES_ENABLED''',
'                   and value = ''Y'')'))
,p_error_message=>unistr('No tiene privilegios para realizar esta operaci\00F3n')
,p_reference_id=>786519856057734816.4651
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/service_requests_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(924142799474578284.4651)
,p_name=>'Service Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'' then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>unistr('No tiene privilegios para realizar esta operaci\00F3n.')
,p_reference_id=>786932326296107981.4651
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(116921624226775084.4651)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(240228498534092429.4651)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'   p_app_id           => wwv_flow.g_x01,',
'   p_get_apps_list    => wwv_flow.g_x02);'))
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(39659194176253998.4651)
,p_name=>'AJAX_WS_ACTION'
,p_protection_level=>'N'
,p_item_comment=>'FILTER,SEARCH,SORT'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(39687302085502294.4651)
,p_name=>'AJAX_WS_COLUMN'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(39686519615497868.4651)
,p_name=>'AJAX_WS_FILTER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(39685106455494105.4651)
,p_name=>'AJAX_WS_FILTER_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(40589212087879993.4651)
,p_name=>'AJAX_WS_NUM'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(40434815287196905.4651)
,p_name=>'APPROVAL_STATUS'
,p_data_type=>'NUMBER'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(808157289945989781.4651)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(176320593212726240.4651)
,p_name=>'F4800_LAST_VIEW'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(187164401829658401.4651)
,p_name=>'FOLDER_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(169965497689755953.4651)
,p_name=>'FSP_AFTER_LOGIN_URL'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(23116113790163063.4651)
,p_name=>'ITEM_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(212601704559973757.4651)
,p_name=>'MSG_COMPANY'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(191826710535164637.4651)
,p_name=>'OWNER_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(194987598169980229.4651)
,p_name=>'RPT_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(187311995341113436.4651)
,p_name=>'SHOWNAV'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(23147208603287312.4651)
,p_name=>'TEMPORARY_ACTION'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(38269819333150352.4651)
,p_name=>'TEMPORARY_FILTER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(23146805140286315.4651)
,p_name=>'TEMPORARY_FOLDER'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(23120618657315808.4651)
,p_name=>'TEMPORARY_ITEM'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(19223200152826192.4651)
,p_name=>'WORKGROUP'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(19230816718477186.4651)
,p_name=>'WORKGROUP_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(38983191458297230.4651)
,p_name=>'WORKSHEET_FILTER_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(94100308836307541.4651)
,p_name=>'WORKSHEET_NAME'
,p_protection_level=>'I'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(808157680380996522.4651)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>'No se ha podido calcular el nombre del espacio de trabajo.'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(40434983588201729.4651)
,p_computation_sequence=>10
,p_computation_item=>'APPROVAL_STATUS'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'QUERY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'select default_rpt_feature_type_id from wwv_flow_task_defaults'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(187312600881115097.4651)
,p_computation_sequence=>10
,p_computation_item=>'SHOWNAV'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'Y'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/bug_severity
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187921520437089316.4651)
,p_lov_name=>'BUG SEVERITY'
,p_lov_query=>'select id||''. ''||the_name the_name, id from wwv_flow_bug_severity order by 1'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_desirability
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(437469591876658122.4651)
,p_lov_name=>'FEATURE DESIRABILITY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name d, id',
'from wwv_flow_feature_desirability',
'order by id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_priority
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(188710018848744469.4651)
,p_lov_name=>'FEATURE PRIORITY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name d, id',
'from   wwv_flow_feature_priorities',
'order by id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187758496344826158.4651)
,p_lov_name=>'FEATURE STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select status_name ||'' - ''||pct_complete||''%'' d, pct_complete r',
'from wwv_flow_feature_def_st_codes',
'order by pct_complete'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feature_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(40236611672304480.4651)
,p_lov_name=>'FEATURE TYPE'
,p_lov_query=>'select type_name, id from wwv_flow_feature_types'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(188485712678162256.4651)
,p_lov_name=>'FEEDBACK STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name the_name, id ',
'from wwv_flow_feedback_status ',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(188542606751974885.4651)
,p_lov_name=>'FEEDBACK TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select the_name, id ',
'from WWV_FLOW_FEEDBACK_TYPES',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/owner_tasks_assigned_to_todo_milestones_features_bugs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187121519511019767.4651)
,p_lov_name=>'OWNER - TASKS, ASSIGNED TO (TODO, MILESTONES, FEATURES, BUGS)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lower(user_name) d, lower(user_name) r ',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'union',
'select lower(d) d, lower(r) r from (',
'    select distinct assigned_to d, assigned_to r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and ',
'         assigned_to is not null',
'    union',
'    select distinct CONTRIBUTOR d, CONTRIBUTOR r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and CONTRIBUTOR is not null',
'    union',
'    select distinct EVENT_OWNER d, EVENT_OWNER r ',
'    from wwv_flow_events ',
'    where security_group_id = :flow_security_group_id and ',
'          event_owner is not null',
'    union',
'    select distinct feature_OWNER d, feature_OWNER r ',
'    from wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_owner is not null',
'    union ',
'    select distinct feature_contributor d, feature_contributor r ',
'    from  wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_contributor is not null',
'    union',
'    select distinct assigned_to d, assigned_to r ',
'    from wwv_flow_bugs',
'    where security_group_id = :flow_security_group_id and ',
'          assigned_to is not null',
') ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/release_task_events_bugs_features
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(186954819803515587.4651)
,p_lov_name=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/task_category
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(186954010106512732.4651)
,p_lov_name=>'TASK CATEGORY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct task_category, task_category r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/workspace_developers
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(681074921907529445.4651)
,p_lov_name=>'WORKSPACE_DEVELOPERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'       case ',
'            when first_name||last_name is null then "USER"',
'            else first_name||'' ''||last_name',
'        end display,',
'         a."USER" return ',
'from wwv_flow_workspace_users a',
'where workspace_id = :flow_security_group_id',
' and dev_type != ''End User'''))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'RETURN'
,p_display_column_name=>'DISPLAY'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'DISPLAY'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/workspace_users
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(484063270104924526.4651)
,p_lov_name=>'WORKSPACE_USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'       case ',
'            when first_name||last_name is null then "USER"',
'            else first_name||'' ''||last_name',
'        end display,',
'         a."USER" return ',
'from wwv_flow_workspace_users a',
'where workspace_id = :flow_security_group_id'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'RETURN'
,p_display_column_name=>'DISPLAY'
,p_default_sort_column_name=>'DISPLAY'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/feedback_breadcrumb
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(6597377151972039.4651)
,p_name=>'Feedback Breadcrumb'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6597846814990224.4651)
,p_parent_id=>wwv_flow_api.id(.4651)
,p_short_name=>'<span class="u-VisuallyHidden">Problemas</span><span class="a-Icon icon-breadcrumb-previous" title="Issues"></span>'
,p_link=>'f?p=4600:999:&APP_SESSION.'
,p_page_id=>0
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6598070160992348.4651)
,p_parent_id=>wwv_flow_api.id(6597846814990224.4651)
,p_short_name=>'Comentarios'
,p_link=>'f?p=&APP_ID.:8012:&SESSION.::&DEBUG.:::'
,p_page_id=>8012
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6598248790001070.4651)
,p_parent_id=>wwv_flow_api.id(6598070160992348.4651)
,p_short_name=>'Calendario'
,p_link=>'f?p=&APP_ID.:8011:&SESSION.::&DEBUG.:::'
,p_page_id=>8011
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6598414745005626.4651)
,p_parent_id=>wwv_flow_api.id(6598070160992348.4651)
,p_short_name=>'Informe'
,p_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:::'
,p_page_id=>8000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6598672174009747.4651)
,p_parent_id=>wwv_flow_api.id(6598070160992348.4651)
,p_short_name=>'Ver/Editar Comentarios'
,p_link=>'f?p=&APP_ID.:8001:&SESSION.::&DEBUG.:::'
,p_page_id=>8001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6598816026012533.4651)
,p_parent_id=>wwv_flow_api.id(6598672174009747.4651)
,p_short_name=>'Editar Seguimiento de Comentarios'
,p_link=>'f?p=&APP_ID.:8014:&SESSION.::&DEBUG.:::'
,p_page_id=>8014
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6599042686018183.4651)
,p_parent_id=>wwv_flow_api.id(6598070160992348.4651)
,p_short_name=>'por Usuario'
,p_link=>'f?p=&APP_ID.:8005:&SESSION.::&DEBUG.:::'
,p_page_id=>8005
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/worksheet_standard
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(94078305196268627.4651)
,p_name=>'worksheet standard'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(118729785765681082.4651)
,p_parent_id=>wwv_flow_api.id(.4651)
,p_short_name=>'<span class="u-VisuallyHidden">Problemas</span><span class="a-Icon icon-breadcrumb-previous" title="Issues"></span>'
,p_link=>'f?p=4600:999:&SESSION.'
,p_page_id=>999
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(120629898535546685.4651)
,p_parent_id=>wwv_flow_api.id(188166605479270547.4651)
,p_short_name=>'Editar Seguimiento de Comentarios'
,p_link=>'f?p=&FLOW_ID.:8014:&SESSION.'
,p_page_id=>8014
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(188141192895137966.4651)
,p_parent_id=>wwv_flow_api.id(189506688383825864.4651)
,p_short_name=>'Informe'
,p_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:::'
,p_page_id=>8000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(188166605479270547.4651)
,p_parent_id=>wwv_flow_api.id(189506688383825864.4651)
,p_short_name=>'Ver/Editar Comentarios'
,p_link=>'f?p=&APP_ID.:8001:&SESSION.::&DEBUG.:::'
,p_page_id=>8001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(188208300232910893.4651)
,p_parent_id=>wwv_flow_api.id(189506688383825864.4651)
,p_short_name=>'Registrar como Bug'
,p_link=>'f?p=&APP_ID.:8002:&SESSION.::&DEBUG.:::'
,p_page_id=>8002
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(188212496839934597.4651)
,p_parent_id=>wwv_flow_api.id(189506688383825864.4651)
,p_short_name=>unistr('Registrar como Funci\00F3n')
,p_link=>'f?p=&APP_ID.:8003:&SESSION.::&DEBUG.:::'
,p_page_id=>8003
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(188237788028166599.4651)
,p_parent_id=>wwv_flow_api.id(189506688383825864.4651)
,p_short_name=>'por Usuario'
,p_link=>'f?p=&APP_ID.:8005:&SESSION.::&DEBUG.:::'
,p_page_id=>8005
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(188242000499206389.4651)
,p_parent_id=>wwv_flow_api.id(189506688383825864.4651)
,p_short_name=>'Convertir Comentarios en Tarea'
,p_link=>'f?p=&APP_ID.:8006:&SESSION.::&DEBUG.:::'
,p_page_id=>8006
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(189008194222089847.4651)
,p_parent_id=>wwv_flow_api.id(189506688383825864.4651)
,p_short_name=>'Calendario'
,p_link=>'f?p=&APP_ID.:8011:&SESSION.::&DEBUG.:::'
,p_page_id=>8011
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(189506688383825864.4651)
,p_parent_id=>wwv_flow_api.id(186485216863096905.4651)
,p_short_name=>'Comentarios'
,p_link=>'f?p=&APP_ID.:8012:&SESSION.::&DEBUG.:::'
,p_page_id=>8012
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(197510784728881814.4651)
,p_parent_id=>wwv_flow_api.id(186485216863096905.4651)
,p_short_name=>unistr('Resultados de la B\00FAsqueda')
,p_link=>'f?p=&FLOW_ID.:8800:&SESSION.'
,p_page_id=>8800
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_0_right_sidebar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(44348405975788762.4651)
,p_theme_id=>3
,p_name=>'APEX 4.0 - Right SideBar.es'
,p_internal_name=>'APEX_4.0_RIGHT_SIDEBAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-two-col">',
'      <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-splash"><div id="BB">#BODY#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'  <div>#REGION_POSITION_04#</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>18525411970780075.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_popup
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(189910623938725087.4651)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Popup.es'
,p_internal_name=>'APEX_4.2_POPUP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title><link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head><body #ONLOAD# style="padding:5px;min-width:380px;"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>',
'  <div id="RP2">#REGION_POSITION_02#</div>',
'  <div id="RP3">#REGION_POSITION_03#</div>',
'  <div id="RP4">#REGION_POSITION_04#</div>',
'  <div id="RP5">#REGION_POSITION_05#</div>',
'  <div class="popupContent" id="ContentArea">#BODY#</div>',
'</div>',
'<div id="RP8" style="text-align:middle;">#REGION_POSITION_08#</div>',
'<br />',
'<br />',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>36144306570651063.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_no_sidebar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(193961792794416180.4651)
,p_theme_id=>3
,p_name=>'APEX 4.2 - No SideBar.es'
,p_internal_name=>'APEX_4.2_NO_SIDEBAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-content">#REGION_POSITION_02#',
'      <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion failRegion #REGION_CSS_CLASSES#" id="ERROR">',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    <p><strong>#MESSAGE#</strong></p>',
'    #ADDITIONAL_INFO#',
'    #TECHNICAL_INFO#',
'  </div>',
'  <span class="aButtonContainer">',
'    <button onclick="#BACK_LINK#" class="aButton hotButton"><span>#RETURN_TO_APPLICATION#</span></button>',
'  </span>',
'</section>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>187453329378870285.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_wizard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(215147989021747864.4651)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Wizard .es'
,p_internal_name=>'APEX_4.2_WIZARD_'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="aWizard">',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'<div class="wizardOuterContainer">',
'#REGION_POSITION_01#',
'<div class="wizardContainer">',
'    <h1 class="visuallyhidden">#TITLE#</h1>',
'    #REGION_POSITION_03#',
'    #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="wizardBody">',
'    #BODY#',
'    #REGION_POSITION_04#',
'    #REGION_POSITION_05#',
'  </div>',
'</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'<script>',
'function loadWizardTrain() {',
'	var currentStep = $("li.current,li.first-current,li.last-current",''div.wizardProgress'');',
'	if (currentStep.prev().length > 0) {',
'		currentStep.prevAll().find(''span'').addClass("pastCurrent");',
'	}',
'}',
'$(document).ready(function(){',
'loadWizardTrain();',
'})',
'</script>',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aWizardMessage successMessage" id="aSuccessMessage" role="alert">',
'  <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'  <a href="javascript:void(0)" onclick="$x_Remove(''aSuccessMessage'')" class="aCloseNotification"><span class="visuallyhidden">#CLOSE_NOTIFICATION#</span></a>',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aWizardMessage errorMessage" id="aErrorMessage" role="alert">',
'  <a href="javascript:void(0)" onclick="$x_Remove(''aErrorMessage'')" class="aCloseNotification"><span class="visuallyhidden">#CLOSE_NOTIFICATION#</span></a>',
'  <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'  #MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>16
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>42231511193339128.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(320889393894602055.4651)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Edit Screen.es'
,p_internal_name=>'APEX_4.2_EDIT_SCREEN'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-two-col">',
'      <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-edit-screen">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>244139901565747496.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(395644842192767482.4651)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Right Side Bar.es'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222.4651
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(165823512427912951.4651)
,p_page_template_id=>wwv_flow_api.id(395644842192767482.4651)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(165824063556912951.4651)
,p_page_template_id=>wwv_flow_api.id(395644842192767482.4651)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(165824510622912952.4651)
,p_page_template_id=>wwv_flow_api.id(395644842192767482.4651)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(165824991548912952.4651)
,p_page_template_id=>wwv_flow_api.id(395644842192767482.4651)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(165825562035912952.4651)
,p_page_template_id=>wwv_flow_api.id(395644842192767482.4651)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(165826046049912953.4651)
,p_page_template_id=>wwv_flow_api.id(395644842192767482.4651)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(165826507020912953.4651)
,p_page_template_id=>wwv_flow_api.id(395644842192767482.4651)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(643947460795988298.4651)
,p_theme_id=>3
,p_name=>'APEX 5.0 - No Side Bar.es'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(676701755252252907.4651)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog.es'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(700757386426987576.4651)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Edit Screen.es'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4651
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(165828752188912955.4651)
,p_page_template_id=>wwv_flow_api.id(700757386426987576.4651)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(165829215688912956.4651)
,p_page_template_id=>wwv_flow_api.id(700757386426987576.4651)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(700758032440987611.4651)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Dialog.es'
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.builder.initWizardModal();',
'apex.builder.initWizardProgressBar();'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="utf-8">  ',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--wizard'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689061037088924910.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(783936135557333953.4651)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Page.es'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_icon_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(52847904441713695.4651)
,p_template_name=>'APEX 4.2 - Icon Button'
,p_internal_name=>'APEX_4.2_ICON_BUTTON'
,p_template=>'<a href="#LINK#" class="aIconButton" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES# role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" /></a>'
,p_hot_template=>'<a href="#LINK#" class="aIconButton" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES# role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" /></a>'
,p_reference_id=>46198532248154431.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>0
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="xpbutton" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tbody class="FFFFFF">',
'<tr>',
'<td class="L" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'<td class="C"><a href="#LINK#">#LABEL#</a></td>',
'<td class="R" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'</tr>',
'</tbody>',
'</table>'))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/xp_square_c5d5c5
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(188465439437178873.4651)
,p_template_name=>'XP Square (C5D5C5)'
,p_internal_name=>'XP_SQUARE_C5D5C5'
,p_template=>'<input type="button" onclick="#LINK#" value="#LABEL!ATTR#" class="htmldbButton" />'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="xpbutton" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tbody class="C5D5C5">',
'<tr>',
'<td class="L" width="4"><img src="#IMAGE_PREFIX#htmldb/buttons/button_xp_left.gif" alt="" height="24" width="4"/></td>',
'<td class="C"><a href="#LINK#">#LABEL#</a></td>',
'<td class="R" width="4"><img src="#IMAGE_PREFIX#htmldb/buttons/button_xp_right.gif" alt="" height="24" width="4"/></td>',
'</tr>',
'</tbody>',
'</table>'))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_next_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(207940091359480439.4651)
,p_template_name=>'APEX 4.2 - Next Button'
,p_internal_name=>'APEX_4.2_NEXT_BUTTON'
,p_template=>'<button class="aButton nextButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" class="nextBlack" alt=""/></span></button>'
,p_hot_template=>'<button class="aButton hotButton nextButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" class="nextWhite" alt=""/></span></button>'
,p_reference_id=>40780910892272674.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_previous_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(207940289776480439.4651)
,p_template_name=>'APEX 4.2 - Previous Button'
,p_internal_name=>'APEX_4.2_PREVIOUS_BUTTON'
,p_template=>'<button title="#LABEL!ATTR#" class="aButton prevButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevBlack" alt="#LABEL!ATTR#" /></span></button>'
,p_hot_template=>'<button title="#LABEL!ATTR#" class="aButton hotButton prevButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevWhite" alt="#LABEL!ATTR#" /></span></button>'
,p_reference_id=>40781222929295107.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_1_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(308205889752201939.4651)
,p_template_name=>'APEX 4.1 - Button'
,p_internal_name=>'APEX_4.1_BUTTON'
,p_template=>'<button class="aButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_hot_template=>'<button class="aButton hotButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_reference_id=>275775519061831382.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="button-gray" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> ',
'',
'',
'<a href="#LINK#" class="button-orange" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> '))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(395010736604687693.4651)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(395010959526687694.4651)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(411369261610169638.4651)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_large
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(411369470801169643.4651)
,p_template_name=>'APEX 5.0 - Button (Large)'
,p_internal_name=>'APEX_5.0_BUTTON_LARGE'
,p_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--large #BUTTON_CSS_CLASSES#" type="button" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--large a-Button--hot #BUTTON_CSS_CLASSES#" type="button" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174756119980565636.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_small
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(411369734082169643.4651)
,p_template_name=>'APEX 5.0 - Button (Small)'
,p_internal_name=>'APEX_5.0_BUTTON_SMALL'
,p_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--small #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--small a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174755910284562884.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(411397931291349067.4651)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_0_next_gray_bg
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(499402697948958678.4651)
,p_template_name=>'APEX 4.0 - Next (gray bg)'
,p_internal_name=>'APEX_4.0_NEXT_GRAY_BG'
,p_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton nextButton rightPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="nextBlack" alt="#LABEL!ATTR#" /></span></but'
||'ton> '
,p_hot_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton hotButton nextButton rightPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="nextWhite" alt="#LABEL!ATTR#" /></'
||'span></button> '
,p_reference_id=>430240008284905073.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_0_previous_gray_bg
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(499402896063958684.4651)
,p_template_name=>'APEX 4.0 - Previous (gray bg)'
,p_internal_name=>'APEX_4.0_PREVIOUS_GRAY_BG'
,p_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton prevButton leftPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevBlack" alt="#LABEL!ATTR#" /></span></butt'
||'on>'
,p_hot_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton hotButton prevButton leftPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevWhite" alt="#LABEL!ATTR#" /></s'
||'pan></button>'
,p_reference_id=>430240500796912446.4651
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_button_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(635747177427497172.4651)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_BUTTON_LEGACY_APEX_5_MIGRATION'
,p_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_no_topbar_no_title
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(25235801195590655.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion noHeading #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <h1 class="visuallyhidden">#TITLE#</h1>',
'  <div class="aRegionContent clearfix">',
'  #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner (No Top-Bar No Title)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_NO_TOPBAR_NO_TITLE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>18729014377038660.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_message_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(44609818978948791.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-SystemMessage #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Message Region'
,p_internal_name=>'APEX_5.0_MESSAGE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>29333927116050844.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(44920011425855551.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar (Gray Header)'
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_float_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(62138891989715890.4651)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# style="float:left;clear:both;">#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div (Float Left)'
,p_internal_name=>'APEX_4.0_DIV_FLOAT_LEFT'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>35964702876463547.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(62139511251715892.4651)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #COMPONENT_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Page Anchors'
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17354206769599941.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_large
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(62140203187715892.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Large'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_LARGE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>27763613494297374.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(62141710374715893.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box'
,p_internal_name=>'APEX_4.0_WIZARD_BOX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box_confirm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(62142309916715893.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box (Confirm)'
,p_internal_name=>'APEX_4.0_WIZARD_BOX_CONFIRM'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/gray_box_worksheet
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(169967419851504809.4651)
,p_layout=>'TABLE'
,p_template=>'<table class="htmldbGBR" cellspacing="0" cellpadding="0" border="0" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="T">#TITLE#</th><th class="BT">#CLOSE#&nbsp;#EDIT##EXPAND##HELP##DELETE##COPY##CREATE#<img src="#IMAGE_PREFIX#up_arrow.gif" al'
||'t="&TOP." class="pb" onclick="uF()"/></th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>'
,p_page_plug_template_name=>'Gray Box (worksheet)'
,p_internal_name=>'GRAY_BOX_WORKSHEET'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/breadcrumb_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(169972595154818636.4651)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#">#BODY#</div>'
,p_page_plug_template_name=>'Breadcrumb Region'
,p_internal_name=>'BREADCRUMB_REGION'
,p_theme_id=>3
,p_theme_class_id=>6
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar_100
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(186745810195475637.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar (100%)'
,p_internal_name=>'APEX_4.0_TOP_BAR_100%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17357218626599946.4651
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar_99
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(186746202608475682.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="topbar" style="width:99%;clear:both;" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="topbar-top"><div class="topbar-top-r"></div></div>',
'  <div class="topbar-body"><div class="topbar-body-r"><div class="topbar-content">',
'      <div style="float:left">#BODY#</div>',
'      <div style="float:right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</div>',
'   </div></div></div>',
'  <div class="topbar-bottom"><div class="topbar-bottom-r"></div></div>',
'</div>',
'<br />'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar (99%)'
,p_internal_name=>'APEX_4.0_TOP_BAR_99%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>169048010062038708.4651
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/gray_box_c_htmldbgbr_100
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(186805016733933893.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading editRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'      <a href="#" class="aIconButton" onclick="uF();return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" class="upIcon" alt="&TOP." /></a>',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Gray Box (c:htmldbGBR) (100%)'
,p_internal_name=>'GRAY_BOX_C:HTMLDBGBR_100%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17353903289599940.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_gray_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(186833193687011642.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideNavRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner (Gray Top)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_GRAY_TOP'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>29053509612942271.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_small_gray_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(186905897464204984.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Small (Gray Top)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_SMALL_GRAY_TOP'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>32612420016685806.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/dhtml_hidden_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(188517350330087537.4651)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#" style="display:none;">#BODY#</div>'
,p_page_plug_template_name=>'(DHTML) Hidden with ID (c:htmldbHID)'
,p_internal_name=>'DHTML_HIDDEN_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(197560605041176246.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar'
,p_internal_name=>'APEX_4.0_TOP_BAR'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>191052627601630142.4651
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(197577184540233756.4651)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div  with ID (c:htmldbHID)'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>245224629509817478.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(215153199785752378.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body'
,p_internal_name=>'APEX_4.2_WIZARD_BODY'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209615589242480.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_buttons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(215154583982752380.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardButtonsContainer" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="leftButtons">',
'    #PREVIOUS##DELETE##CHANGE##CLOSE#',
'  </div>',
'  <div class="rightButtons">',
'    #EDIT##CREATE##NEXT#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Buttons'
,p_internal_name=>'APEX_4.2_WIZARD_BUTTONS'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210411889242480.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/info_c_htmldbinfo
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(249022840020543624.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Info (c:htmldbInfo) '
,p_internal_name=>'INFO_C:HTMLDBINFO_'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(385710610077012267.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="aRegionIR #REGION_CSS_CLASSES#">',
'<h1 class="visuallyhidden">#TITLE#</h1>',
'#BODY#',
'#EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##NEXT##PREVIOUS#',
'</div>'))
,p_page_plug_template_name=>'APEX 4.2 - Interactive Report Region'
,p_internal_name=>'APEX_4.2_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>379198415794456058.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(394867304186881833.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174748721787471587.4651
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(394873728911883775.4651)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/div_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(415202027252589471.4651)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#">#BODY#</div>'
,p_page_plug_template_name=>'Div  with ID (c:htmldbHID)'
,p_internal_name=>'DIV_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>7
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_navigation
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(473213802990752028.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion sideNavRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar Navigation'
,p_internal_name=>'APEX_4.0_SIDEBAR_NAVIGATION'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>456726627253419549.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_hide_and_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(508696982154118073.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title"><h3>',
'      <a href="#" onclick="htmldb_ToggleTableBody(''i#REGION_STATIC_ID#'',''body#REGION_STATIC_ID#''); return false;">',
'        <img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" class="pseudoButtonActive" id="i#REGION_STATIC_ID#" alt="" />',
'        #TITLE#',
'      </a></h3>    ',
'    </div>',
'  </div>',
'  <div class="hide-show-body" style="display:none;" id="body#REGION_STATIC_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.0 - Hide and Show Region'
,p_internal_name=>'APEX_4.0_HIDE_AND_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18662712241194598.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(684869836739871122.4651)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(695168763283587043.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>698829239393878937.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(697044757239351357.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>687153470345619376.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(697050653416351401.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'      <button class="a-Button a-Button--icon a-Button--hideShow" type="button"></button>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>689955986849128825.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_accordion
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(700763479128999013.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUBREGIONS#',
'</div>',
'<script type="text/javascript">',
'  apex.jQuery( "#accordion" ).accordion({',
'    icons: false,',
'    header: ".a-Region-header",',
'    heightStyle: ''content'',',
'    collapsible: true',
'  });',
'</script>'))
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion-item">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Accordion'
,p_internal_name=>'APEX_5.0_ACCORDION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174746301430371105.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(700764213343999023.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-PageColumn-header">',
'    <h2 class="a-PageColumn-heading">#TITLE#</h2>',
'  </div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613223222362440.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(700764942929999024.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn-body #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column (Body)'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN_BODY'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174630015632506596.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(700765678547999024.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUB_REGION_HEADERS#',
'  #SUB_REGIONS#',
'</div>',
'<script type="text/javascript">',
'    $("##REGION_STATIC_ID#").tabs({',
'      create: function() {',
'        $(this).addClass(''ui-tabs--simpleInset'')',
'      }',
'    });',
'</script>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#">#SUB_REGION_TITLE#</a></li>'
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer-item" id="#SUB_REGION_ID#">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Tabs'
,p_internal_name=>'APEX_5.0_TABS'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>183211208341566300.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(700766407172999024.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Toolbar-items a-Toolbar-items--left">#PREVIOUS#</div>',
'  <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar'
,p_internal_name=>'APEX_5.0_TOOLBAR'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613705533399534.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(700767147709999025.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--left #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Left)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_LEFT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174628415239478085.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_right
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(700767825232999025.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--right #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Right)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_RIGHT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174629130392501406.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(700768560594999026.4651)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(813554394221812426.4651)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div with ID and Region Attributes'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>2974803291668087.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_image_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(23735196180806583.4651)
,p_list_template_current=>'<li><a href="#LINK#" title="#TEXT#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />#TEXT#</a></li>'
,p_list_template_name=>'Simple Image List'
,p_internal_name=>'SIMPLE_IMAGE_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="listwithicon">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_large_icons_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(26666984607144851.4651)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX#f_spacer.gif" #IMAGE_ATTR# class="gi-Icon-#IMAGE#" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX#f_spacer.gif" #IMAGE_ATTR# class="gi-Icon-#IMAGE#" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_name=>'[EBA] Large Icons List'
,p_internal_name=>'[EBA]_LARGE_ICONS_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table class="ebaLargeIcons" width="100%" cellspacing="0" cellpadding="0" border="0" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_reference_id=>20148806760577112.4651
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/quicklinks
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(177148219705406006.4651)
,p_list_template_current=>'<td><a href="#LINK#" onclick="qF(this,''#LINK#'');return false;" id="#A01#" class="htmldbButtonListCurrent" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_noncurrent=>'<td><a href="#LINK#" onclick="qF(this,''#LINK#'');return false;" id="#A01#"  class="htmldbButtonList" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_name=>'Quicklinks'
,p_internal_name=>'QUICKLINKS'
,p_theme_id=>3
,p_theme_class_id=>3
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'.htmldbButtonListCurrent:link,.htmldbButtonListCurrent:visited,#ALL:hover,a.htmldbButtonList:hover,a.htmldbButtonListCurrent:link{padding:1px 3px;font-weight:bold;text-decoration:none;background:#aaaaaa!important;border:1px solid #999;color:#fff !imp'
||'ortant;}',
'</style>',
'<table class="htmldbButtonList" summary="" border="0" cellpadding="0" cellspacing="3" id="ql"><tr>'))
,p_list_template_after_rows=>'</tr></table><script>addLoadEvent(propTest)</script>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_second_level_tabs_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(188948529125031038.4651)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 4.0 second level tabs navigation'
,p_internal_name=>'APEX_4.0_SECOND_LEVEL_TABS_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4651
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_pull_down_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(193632009704546435.4651)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_name=>'APEX 4.0 - Pull Down Tabs'
,p_internal_name=>'APEX_4.0_PULL_DOWN_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div id="tabs" class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul id="S#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="aTabs dhtmlSubMenu pulldown-tabs" style="display:none;">',
''))
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_reference_id=>9651611091899590.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(205034121246397307.4651)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_wizard_progress_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(215159999381754637.4651)
,p_list_template_current=>'<li class="#LIST_STATUS#"><span>#TEXT#</span></li>'
,p_list_template_noncurrent=>'<li class="#LIST_STATUS#"><span>#TEXT#</span></li>'
,p_list_template_name=>'APEX 4.2 - Wizard Progress Bar'
,p_internal_name=>'APEX_4.2_WIZARD_PROGRESS_BAR'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardProgress">',
'<ul>'))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'</div>'))
,p_reference_id=>42216127932260877.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_run_edit_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(216948000482610776.4651)
,p_list_template_current=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_noncurrent=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_name=>'APEX 4.2 - Run / Edit Bar'
,p_internal_name=>'APEX_4.2_RUN_/_EDIT_BAR'
,p_theme_id=>3
,p_theme_class_id=>3
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="aRunEditBar">',
'  <li><span class="currentPage">&PAGE. &FB_FLOW_PAGE_ID.</span></li>'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>210390516819756900.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/list/horizontal_list_with_images_fixed_width_30pxc_htmldblistimageshfw
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(244726335168133894.4651)
,p_list_template_current=>'<td align="center" valign="bottom"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon" /></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a><br />Default</td>'
,p_list_template_noncurrent=>'<td align="center" valign="bottom"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon"/></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_name=>'Horizontal List with Images Fixed Width 30px(c:htmldbListImagesHFW)'
,p_internal_name=>'HORIZONTAL_LIST_WITH_IMAGES_FIXED_WIDTH_30PXC:HTMLDBLISTIMAGESHFW'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="htmldbListImages30px" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(394878284873890296.4651)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(394878606759890298.4651)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(395640290513433908.4651)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508.4651
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(694410403055228602.4651)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(705132100057297693.4651)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060.4651
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(12080207088206014.4651)
,p_row_template_name=>'APEX 4.0 - Standard Report'
,p_internal_name=>'APEX_4.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4651
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(12080207088206014.4651)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(26536607305126866.4651)
,p_row_template_name=>'[EBA] Standard Report'
,p_internal_name=>'[EBA]_STANDARD_REPORT'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#',
'<tr>',
'<td><table class="ebaStandardReport" cellspacing="0" cellpadding="0" summary="#REGION_TITLE#" width="100%">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table><div class="CSV">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="#LINK#" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="#LINK#" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="#LINK#" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="#LINK#" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>20327811817377113.4651
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(26536607305126866.4651)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(176568047789263777.4651)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report from 4999'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#"><div class="of">#COLUMN_VALUE#</div></td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#"><div class="of">#COLUMN_HEADER#</div></th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(176568047789263777.4651)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/quick_pick_list_items
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(181635329842110151.4651)
,p_row_template_name=>'quick_pick_list_items'
,p_internal_name=>'QUICK_PICK_LIST_ITEMS'
,p_row_template1=>'<li>#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="htmldbUl">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(181635329842110151.4651)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(186827396907902067.4651)
,p_row_template_name=>'APEX 4.0 - Portlet Column Template'
,p_internal_name=>'APEX_4.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(186827809170902096.4651)
,p_row_template_name=>'APEX 4.0 - Portlet Row Template'
,p_internal_name=>'APEX_4.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(395652746647870440.4651)
,p_row_template_name=>'APEX 5.0 - Badge List'
,p_internal_name=>'APEX_5.0_BADGE_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>488487951233692049.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_date_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(395653048191870446.4651)
,p_row_template_name=>'APEX 5.0 - Date List'
,p_internal_name=>'APEX_5.0_DATE_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="a-DateList-item">',
'    <div class="a-MediaBlock">',
'      <div class="a-MediaBlock-graphic">',
'        <span class="a-DateList-date">',
'          <span class="a-DateList-day">#DAY#</span>',
'          <span class="a-DateList-month">#MONTH#</span>',
'        </span>',
'      </div>',
'      <div class="a-MediaBlock-content">',
'        <span class="a-DateList-desc">#TEXT#</span>',
'        <span class="a-DateList-attribute">#CREATED_BY#</span>',
'        <span class="a-DateList-attribute">#CREATED_ON#</span>',
'      </div>',
'    </div>',
'  </li>'))
,p_row_template_before_rows=>'<ul class="a-DateList">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(703372107153632568.4651)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4651
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(703372107153632568.4651)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(703376939640632578.4651)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4651
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(703376939640632578.4651)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/label_tag_only
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(11436607399317360.4651)
,p_template_name=>'LABEL Tag Only'
,p_internal_name=>'LABEL_TAG_ONLY'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/htmldb_greenarealabel_c_htmldbgalabel
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(227699045965618787.4651)
,p_template_name=>'htmldb_GreenAreaLabel (c:htmldbGALabel)'
,p_internal_name=>'HTMLDB_GREENAREALABEL_C:HTMLDBGALABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="htmldbGALabel" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(263340242321347374.4651)
,p_template_name=>'FormField_Optional'
,p_internal_name=>'FORMFIELD_OPTIONAL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_required
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(263341940374356326.4651)
,p_template_name=>'FormField_Required'
,p_internal_name=>'FORMFIELD_REQUIRED'
,p_template_body1=>'<em>*</em><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aRequired"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>' <span class="hideMeButHearMe">(#VALUE_REQUIRED#)</span></a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>2
,p_reference_id=>17388508175892042.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional_no_link
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(408093938801503146.4651)
,p_template_name=>'FormField_Optional No Link'
,p_internal_name=>'FORMFIELD_OPTIONAL_NO_LINK'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><span class="htmldbLabelOptional">'
,p_template_body2=>'</span></label>'
,p_theme_id=>3
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_4_0_top_bar_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(474833281367609401.4651)
,p_template_name=>'APEX 4.0 - Top Bar Label'
,p_internal_name=>'APEX_4.0_TOP_BAR_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(493950867964259075.4651)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487444299516703815.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(493950978277259098.4651)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487443659585685414.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(694415461746261220.4651)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492676964457041934.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(694415638329261221.4651)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492677038682043223.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(694416725694263392.4651)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>687907221148719616.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumbs_c_htmldbbreadcrumb
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(183701840519666652.4651)
,p_name=>'Breadcrumbs (c:htmldbBreadcrumb) '
,p_internal_name=>'BREADCRUMBS_C:HTMLDBBREADCRUMB_'
,p_current_page_option=>'<span class="htmldbBreadcrumb">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#" class="htmldbBreadcrumb" title="#NAME#">#NAME#</a>'
,p_between_levels=>'<span class="htmldbBreadcrumbSep"><img alt="" src="#IMAGE_PREFIX#apex/apex_top_sep.gif"></span>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>60115300853820165.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(394880309395892667.4651)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>689285808648404711.4651
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(180184739606372703.4651)
,p_page_name=>'winlov'
,p_page_title=>unistr('Cuadro de di\00E1logo de b\00FAsqueda')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>'Buscar'
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>'Cerrar'
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>'Siguiente &gt;'
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>'&lt; Anterior'
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>'<div class="a-PopupLOV-pagination">Filas #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17343114994581872.4651
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/default_calender
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(218713441324738082.4651)
,p_cal_template_name=>'Default Calender'
,p_internal_name=>'DEFAULT_CALENDER'
,p_day_of_week_format=>'<th scope="col" class="aCalDayCol">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aCal">',
'<h1 class="aMonth">#IMONTH# <span>#YYYY#</span></h1>'))
,p_month_open_format=>'<table class="aCal" cellpadding="0" cellspacing="0" border="0" summary="#IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></div>',
'',
''))
,p_day_title_format=>'<span class="aDayTitle">#DD#</span>'
,p_day_open_format=>'<td class="aDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="aDay today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<span class="aDayTitle weekendday">#DD#</span>'
,p_weekend_open_format=>'<td class="aDay weekendday">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<span class="aDayTitle nonday">#DD#</span>'
,p_nonday_open_format=>'<td class="aDay nonday">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(78840186844083825.4651)
,p_theme_id=>3
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(210531387365324264.4651)
,p_theme_id=>3
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(693437730767568160.4651)
,p_theme_id=>101
,p_name=>'REGION_HEIGHT'
,p_display_name=>'Region Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(693438672424568161.4651)
,p_theme_id=>101
,p_name=>'BODY_PADDING'
,p_display_name=>'Body Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(693440202068568161.4651)
,p_theme_id=>101
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697045387842351371.4651)
,p_theme_id=>101
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697046454352351372.4651)
,p_theme_id=>101
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697054449869351406.4651)
,p_theme_id=>101
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697055438734351407.4651)
,p_theme_id=>101
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697236983795192856.4651)
,p_theme_id=>101
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697237088104192858.4651)
,p_theme_id=>101
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697237205186192858.4651)
,p_theme_id=>101
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697237358462192858.4651)
,p_theme_id=>101
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697237404763192858.4651)
,p_theme_id=>101
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697237568618192858.4651)
,p_theme_id=>101
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697237650199192858.4651)
,p_theme_id=>101
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697237747369192858.4651)
,p_theme_id=>101
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697237840919192858.4651)
,p_theme_id=>101
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697237936650192859.4651)
,p_theme_id=>101
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697238001197192859.4651)
,p_theme_id=>101
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697238137627192859.4651)
,p_theme_id=>101
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697238213668192859.4651)
,p_theme_id=>101
,p_name=>'MAX_HEIGHT'
,p_display_name=>'Max Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'No Max Height'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697238313939192859.4651)
,p_theme_id=>101
,p_name=>'MIN_HEIGHT'
,p_display_name=>'Min Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'No Min Height'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697238388379192859.4651)
,p_theme_id=>101
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(703120149933578335.4651)
,p_theme_id=>101
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Hidden (but accessible)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(703754804407248924.4651)
,p_theme_id=>101
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(705132502554297699.4651)
,p_theme_id=>101
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752965663325972701.4651)
,p_theme_id=>3
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752966961011972701.4651)
,p_theme_id=>3
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752967240437972701.4651)
,p_theme_id=>3
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752967503447972701.4651)
,p_theme_id=>3
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752968625073972702.4651)
,p_theme_id=>3
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752968916066972702.4651)
,p_theme_id=>3
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752969246994972702.4651)
,p_theme_id=>3
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752969523829972702.4651)
,p_theme_id=>3
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752969816508972703.4651)
,p_theme_id=>3
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752970373928972703.4651)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(752970610131972703.4651)
,p_theme_id=>3
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(757216252300959709.4651)
,p_theme_id=>3
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(757217027408959709.4651)
,p_theme_id=>3
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(757217561984959709.4651)
,p_theme_id=>3
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(757217841787959709.4651)
,p_theme_id=>3
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(757218501215959709.4651)
,p_theme_id=>3
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(757230369532962928.4651)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(793628286525489784.4651)
,p_theme_id=>3
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(793628595521489784.4651)
,p_theme_id=>3
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(793628907307489784.4651)
,p_theme_id=>3
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(793629694305489785.4651)
,p_theme_id=>3
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1027581746419114496.4651)
,p_theme_id=>3
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(705136091795297720.4651)
,p_theme_id=>101
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(705132100057297693.4651)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(705132502554297699)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(705136475424297721.4651)
,p_theme_id=>101
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(705132100057297693.4651)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(705132502554297699)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(705136713435297721.4651)
,p_theme_id=>101
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(705132100057297693.4651)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(705132502554297699)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(705137018578297721.4651)
,p_theme_id=>101
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(705132100057297693.4651)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(705132502554297699)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(705137359585297721.4651)
,p_theme_id=>101
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(705132100057297693.4651)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(705132502554297699)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(705137580273297721.4651)
,p_theme_id=>101
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(705132100057297693.4651)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(705137932439297722.4651)
,p_theme_id=>101
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(705132100057297693.4651)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(705138188065297722.4651)
,p_theme_id=>101
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(705132100057297693.4651)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(705138486446297722.4651)
,p_theme_id=>101
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(705132100057297693.4651)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(705138789420297724.4651)
,p_theme_id=>101
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(705132100057297693.4651)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752965768025972701.4651)
,p_theme_id=>3
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_api.id(752965663325972701)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752965949536972701.4651)
,p_theme_id=>3
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_api.id(752965663325972701)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752966124463972701.4651)
,p_theme_id=>3
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_api.id(752965663325972701)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752966311131972701.4651)
,p_theme_id=>3
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_api.id(752965663325972701)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752966557880972701.4651)
,p_theme_id=>3
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_api.id(752965663325972701)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752966759495972701.4651)
,p_theme_id=>3
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_api.id(752965663325972701)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752966993524972701.4651)
,p_theme_id=>3
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(752966961011972701)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752967357282972701.4651)
,p_theme_id=>3
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_api.id(752967240437972701)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752967632517972701.4651)
,p_theme_id=>3
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_api.id(752967503447972701)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752967847470972702.4651)
,p_theme_id=>3
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_api.id(752967240437972701)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752968045227972702.4651)
,p_theme_id=>3
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_api.id(752967240437972701)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752968270759972702.4651)
,p_theme_id=>3
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_api.id(752967240437972701)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752968384078972702.4651)
,p_theme_id=>3
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_api.id(752967503447972701)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752968730135972702.4651)
,p_theme_id=>3
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_api.id(752968625073972702)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752969015558972702.4651)
,p_theme_id=>3
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(752968916066972702)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752969365387972702.4651)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_api.id(752969246994972702)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752969647302972702.4651)
,p_theme_id=>3
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(752969523829972702)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752969888473972703.4651)
,p_theme_id=>3
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_api.id(752969816508972703)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752970126233972703.4651)
,p_theme_id=>3
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(752967503447972701)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752970404302972703.4651)
,p_theme_id=>3
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(752970373928972703)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752970729154972703.4651)
,p_theme_id=>3
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_api.id(752970610131972703)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752970828723972703.4651)
,p_theme_id=>3
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752971067643972703.4651)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_api.id(752969246994972702)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752971248289972703.4651)
,p_theme_id=>3
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_api.id(752969523829972702)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752971412563972703.4651)
,p_theme_id=>3
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_api.id(752969816508972703)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752971486301972703.4651)
,p_theme_id=>3
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752971590342972703.4651)
,p_theme_id=>3
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793628379686489784.4651)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(12080207088206014.4651)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(793628286525489784)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793628760749489784.4651)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(12080207088206014.4651)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(793628595521489784)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793629007882489784.4651)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(12080207088206014.4651)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(793628907307489784)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793629245040489785.4651)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(12080207088206014.4651)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(793628907307489784)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793629473847489785.4651)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(12080207088206014.4651)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(793628907307489784)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793629555202489785.4651)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(12080207088206014.4651)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793629791467489785.4651)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(12080207088206014.4651)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(793629694305489785)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793637915221489802.4651)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(703372107153632568.4651)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(793628286525489784)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793638135830489802.4651)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(703372107153632568.4651)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(793628595521489784)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793638353930489802.4651)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(703372107153632568.4651)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(793628907307489784)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793638482055489803.4651)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(703372107153632568.4651)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(793628907307489784)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793638736443489806.4651)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(703372107153632568.4651)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(793628907307489784)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793638825903489806.4651)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(703372107153632568.4651)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(793639056671489806.4651)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(703372107153632568.4651)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(793629694305489785)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(804039850748664666.4651)
,p_theme_id=>3
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697044757239351357.4651)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(804040047598664667.4651)
,p_theme_id=>3
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697044757239351357.4651)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(757217841787959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(804040227714664667.4651)
,p_theme_id=>3
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697044757239351357.4651)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(757217841787959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(804040425333664668.4651)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697044757239351357.4651)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(757217027408959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(804040608630664668.4651)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697044757239351357.4651)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(757217027408959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(804040773255664668.4651)
,p_theme_id=>3
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697044757239351357.4651)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(804040903463664668.4651)
,p_theme_id=>3
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697044757239351357.4651)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_api.id(757216252300959709)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(804041170030664668.4651)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697044757239351357.4651)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_api.id(757216252300959709)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(932903997746247585.4651)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(394878606759890298.4651)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(932904093639247586.4651)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(394878606759890298.4651)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(947203208588881643.4651)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(694410403055228602.4651)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1206067706551572487.4651)
,p_theme_id=>3
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(411397931291349067.4651)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(752970373928972703)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1532164284640722153.4651)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(205034121246397307.4651)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1532164381268722153.4651)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(205034121246397307.4651)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1532164504697722153.4651)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(205034121246397307.4651)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1532164672594722153.4651)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(205034121246397307.4651)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1532164873933722153.4651)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(205034121246397307.4651)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(1027581746419114496)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1532165023409722154.4651)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(205034121246397307.4651)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(1027581746419114496)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1551323683134018073.4651)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(703376939640632578.4651)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1551323839353018073.4651)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(703376939640632578.4651)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1551323909014018073.4651)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(703376939640632578.4651)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561321039672948443.4651)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(757216252300959709)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561321253855948443.4651)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(757216252300959709)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561321417403948443.4651)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(757217027408959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561321628882948443.4651)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(757217027408959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561321862621948443.4651)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(757217561984959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561322014141948443.4651)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(757217841787959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561322240097948443.4651)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(757218501215959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561322457641948444.4651)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(757218501215959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561322646198948444.4651)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(757217027408959709)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561322694314948444.4651)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561322975290948444.4651)
,p_theme_id=>3
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(394867304186881833.4651)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(757217841787959709)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561341112407066888.4651)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(684869836739871122.4651)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561341186254066888.4651)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(684869836739871122.4651)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561341370269066888.4651)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(684869836739871122.4651)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561346951801082320.4651)
,p_theme_id=>3
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697050653416351401.4651)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561347020555082320.4651)
,p_theme_id=>3
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697050653416351401.4651)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561347264747082320.4651)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697050653416351401.4651)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(757217027408959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561347465808082320.4651)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697050653416351401.4651)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(757217027408959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561347673790082320.4651)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697050653416351401.4651)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(757217561984959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561347832081082320.4651)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697050653416351401.4651)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(757217841787959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561347989907082320.4651)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697050653416351401.4651)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(757218501215959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561348236951082320.4651)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697050653416351401.4651)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(757218501215959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561348469902082320.4651)
,p_theme_id=>3
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_api.id(697050653416351401.4651)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(757230369532962928)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561348606942082320.4651)
,p_theme_id=>3
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(697050653416351401.4651)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(757230369532962928)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561372507314090874.4651)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695168763283587043.4651)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561372751152090874.4651)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695168763283587043.4651)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(757216252300959709)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561372965620090874.4651)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695168763283587043.4651)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(757218501215959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561373159771090874.4651)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695168763283587043.4651)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(757217841787959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561373280775090874.4651)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(695168763283587043.4651)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(757217027408959709)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561373505424090874.4651)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695168763283587043.4651)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(757216252300959709)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561373700954090874.4651)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(695168763283587043.4651)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(757217027408959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561373974864090874.4651)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695168763283587043.4651)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(757218501215959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561374166389090874.4651)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(695168763283587043.4651)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(757217561984959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1561374334798090874.4651)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(695168763283587043.4651)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(757217027408959709)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(39617993240769231.4651)
,p_build_option_name=>'Enable Approval Status'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(320919295971935424.4651)
,p_build_option_name=>'file attachments'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(699952074310045895.4651)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(22358093777479555.4651)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\00BFSeguro que desea salir de esta p\00E1gina sin guardar?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(170338901610649539.4651)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\00BFDesea realizar esta acci\00F3n de supresi\00F3n?')
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(546448889396214216.4651)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040.4651
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(19015092593808981.4651)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>unistr('Autorizaci\00F3n de Desarrollador')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(793407002933052935.4651)
,p_plugin_id=>wwv_flow_api.id(19015092593808981.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793407379053052935.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793407976942052937.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793408467913052937.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793408958661052937.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793409394187052937.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793409901080052938.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793410416272052940.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793410947865052940.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793411472081052941.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793411953500052941.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793412444814052942.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(793412894193052942.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(793407002933052935.4651)
,p_display_sequence=>120
,p_display_value=>'PKG_APPS: Ability to install packaged applications'
,p_return_value=>'PKG_APPS'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_searchbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(80399334057909071.4651)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.SEARCHBOX'
,p_display_name=>unistr('Cuadro de B\00FAsqueda')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.SEARCHBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_searchbox'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT'
,p_substitute_attributes=>true
,p_reference_id=>42609120788689442.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1519674605118770086.4651)
,p_plugin_id=>wwv_flow_api.id(80399334057909071.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Redirect URL'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:<target page>:&SESSION.::&DEBUG.::<target item>:'
,p_display_length=>80
,p_max_length=>4000
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1519675068153770086.4651)
,p_plugin_id=>wwv_flow_api.id(80399334057909071.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Search Text'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Search'
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
''))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(120253183546205493.4651)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>unistr('Autenticaci\00F3n de Apex')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(125112662381475171.4651)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>unistr('INTERNAL: Inicio de sesi\00F3n en medios sociales')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(125112787672475172.4651)
,p_plugin_id=>wwv_flow_api.id(125112662381475171.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(125114750873475172.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(125112787672475172.4651)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(125113238363475172.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(125112787672475172.4651)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(125113778125475172.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(125112787672475172.4651)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(125114273468475172.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(125112787672475172.4651)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(125115178968475173.4651)
,p_plugin_id=>wwv_flow_api.id(125112662381475171.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(125112787672475172.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(125115655770475173.4651)
,p_plugin_id=>wwv_flow_api.id(125112662381475171.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(125112787672475172.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(125116010654475173.4651)
,p_plugin_id=>wwv_flow_api.id(125112662381475171.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(125112787672475172.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(125116391898475173.4651)
,p_plugin_id=>wwv_flow_api.id(125112662381475171.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(125112787672475172.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(125116850663475173.4651)
,p_plugin_id=>wwv_flow_api.id(125112662381475171.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Application Express automatically adds the "openid" scope. The authent'
||'ication provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(125117274609475173.4651)
,p_plugin_id=>wwv_flow_api.id(125112662381475171.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(125117602934475174.4651)
,p_plugin_id=>wwv_flow_api.id(125112662381475171.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(125118051281475174.4651)
,p_plugin_id=>wwv_flow_api.id(125112662381475171.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(363179900279987746.4651)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>'INTERNA: Oracle Cloud Identity Management'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749806821809026.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(363182688189987750.4651)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>'INTERNA: Cuentas de Base de Datos'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749511183746276.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(363214584124987785.4651)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>'INTERNA: Variable de Cabecera HTTP'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>708795120396802284.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363214797615987785.4651)
,p_plugin_id=>wwv_flow_api.id(363214584124987785.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363215178529987785.4651)
,p_plugin_id=>wwv_flow_api.id(363214584124987785.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363215591502987785.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363215178529987785.4651)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363216109956987786.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363215178529987785.4651)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363216596937987786.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363215178529987785.4651)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363217090503987786.4651)
,p_plugin_id=>wwv_flow_api.id(363214584124987785.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(363215178529987785.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>',
'<p>',
'<h3>Example:</h3>',
'<pre>http://sso.mycompany.com/?success=#CALLBACK#</pre>',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363217479901987787.4651)
,p_plugin_id=>wwv_flow_api.id(363214584124987785.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(363215178529987785.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363217884338987787.4651)
,p_plugin_id=>wwv_flow_api.id(363214584124987785.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(363215178529987785.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'BUILTIN_URL,URL'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363218303778987787.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363217884338987787.4651)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363218795722987788.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363217884338987787.4651)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363219280248987788.4651)
,p_plugin_id=>wwv_flow_api.id(363214584124987785.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(363284985190987839.4651)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>'INTERNA: Directorio LDAP'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>863910941135523528.4651
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Introduzca el nombre de usuario y la contrase\00F1a para la autenticaci\00F3n en el directorio LDAP identificado en la p\00E1gina de conexi\00F3n. Recuerde que las contrase\00F1as pueden ser sensibles a may\00FAsculas/min\00FAsculas.</p>'),
''))
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363285304610987839.4651)
,p_plugin_id=>wwv_flow_api.id(363284985190987839.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363285690700987839.4651)
,p_plugin_id=>wwv_flow_api.id(363284985190987839.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363286102167987839.4651)
,p_plugin_id=>wwv_flow_api.id(363284985190987839.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363286482756987839.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363286102167987839.4651)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363286994210987839.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363286102167987839.4651)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363287495524987840.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363286102167987839.4651)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363287988453987840.4651)
,p_plugin_id=>wwv_flow_api.id(363284985190987839.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363288403380987841.4651)
,p_plugin_id=>wwv_flow_api.id(363284985190987839.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363288779793987841.4651)
,p_plugin_id=>wwv_flow_api.id(363284985190987839.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(363288403380987841.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363289193175987841.4651)
,p_plugin_id=>wwv_flow_api.id(363284985190987839.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(363289601107987841.4651)
,p_plugin_id=>wwv_flow_api.id(363284985190987839.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363290010979987841.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363289601107987841.4651)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363290491461987842.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363289601107987841.4651)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(363290998391987842.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(363289601107987841.4651)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(363326507272987869.4651)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'INTERNA: Oracle Application Server Single Sign-On'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113750429890071859.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_html5_bar_chart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(637620824431401115.4651)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_display_name=>unistr('Gr\00E1fico de Barras HTML 5 ***')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.HTML5_BAR_CHART'),'#IMAGE_PREFIX#plugins/com.oracle.apex.html5_bar_chart/1.0/')
,p_javascript_file_urls=>'#PLUGIN_FILES#com_oracle_apex_html5_bar_chart.js'
,p_css_file_urls=>'#PLUGIN_FILES#com_oracle_apex_html5_bar_chart.css'
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'FUNCTION RENDER (',
'    P_REGION IN APEX_PLUGIN.T_REGION,',
'    P_PLUGIN IN APEX_PLUGIN.T_PLUGIN,',
'    P_IS_PRINTER_FRIENDLY IN BOOLEAN',
') RETURN APEX_PLUGIN.T_REGION_RENDER_RESULT IS',
'BEGIN',
'    sys.HTP.PRN(''<div id="''||APEX_ESCAPE.HTML_ATTRIBUTE(P_REGION.STATIC_ID)||''_chart" class="hbc">'');',
'    sys.HTP.PRN(''</div>'');',
'    ',
'    APEX_JAVASCRIPT.ADD_ONLOAD_CODE (',
'        P_CODE => ''com_oracle_apex_html5_bar_chart(''||',
'            APEX_JAVASCRIPT.ADD_VALUE(P_REGION.STATIC_ID)||',
'            ''{''||',
'                -- Why is this attribute needed if is not used?',
'                APEX_JAVASCRIPT.ADD_ATTRIBUTE(',
'                    ''pageItems'', ',
'                    APEX_PLUGIN_UTIL.PAGE_ITEM_NAMES_TO_JQUERY(P_REGION.AJAX_ITEMS_TO_SUBMIT)',
'                )||',
'                APEX_JAVASCRIPT.ADD_ATTRIBUTE(',
'                    ''ajaxIdentifier'', ',
'                    APEX_PLUGIN.GET_AJAX_IDENTIFIER, ',
'                    FALSE, ',
'                    FALSE',
'                )||',
'            ''}''||',
'        '');''',
'    );',
'    ',
'    RETURN NULL;',
'END RENDER;',
'',
'FUNCTION AJAX (',
'    P_REGION IN APEX_PLUGIN.T_REGION,',
'    P_PLUGIN IN APEX_PLUGIN.T_PLUGIN',
') RETURN APEX_PLUGIN.T_REGION_AJAX_RESULT IS',
'    -- Map region attributes to function constants',
'    -- MODERN, CLASSIC',
'    C_CHART_TYPE CONSTANT VARCHAR2(7) := P_REGION.ATTRIBUTE_15;',
'    -- MODERN, MODERN_2, SOLAR, METRO, CUSTOM, COLUMN',
'    C_COLOR_SCHEME CONSTANT VARCHAR2(8) := P_REGION.ATTRIBUTE_17;',
'    C_CUSTOM_CHART_COLORS CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_10;',
'    C_COLOR_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_19;',
'    -- NONE, IMAGE, ICON, INITIALS',
'    C_ICON_TYPE CONSTANT VARCHAR2(8) := case when C_CHART_TYPE = ''ICON'' then P_REGION.ATTRIBUTE_01 end;',
'    C_LABEL_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_02;',
'    C_LABEL_LINK CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_03;',
'    C_VALUE_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_04;',
'    C_VALUE_LINK CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_05;',
'    -- ABOVE, AROUND',
'    C_TEXT_POSITION VARCHAR2(6) := P_REGION.ATTRIBUTE_18;',
'    C_CHART_CSS_CLASSES CONSTANT VARCHAR2(32767) := P_REGION.ATTRIBUTE_06;',
'    C_IMAGE_URL CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_07;',
'    C_CSS_ICON_CLASS_NAME CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_08;',
'    C_INITIALS_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_09;',
'    -- ABSOLUTE, RELATIVE',
'    C_BAR_WIDTH_CALCULATION CONSTANT VARCHAR2(8) := P_REGION.ATTRIBUTE_16;',
'    C_DISPLAY CONSTANT VARCHAR2(19) := P_REGION.ATTRIBUTE_11;',
'    C_PREFIX_FOR_VALUE CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_12;',
'    C_POSTFIX_FOR_VALUE CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_13;',
'    C_MAXIMUM_ROWS CONSTANT NUMBER := P_REGION.ATTRIBUTE_14;',
'    C_MESSAGE_WHEN_NO_DATA_FOUND CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_20;',
'    ',
'    L_COLOR_COLUMN_NUMBER PLS_INTEGER;',
'    L_LABEL_COLUMN_NUMBER PLS_INTEGER;',
'    L_VALUE_COLUMN_NUMBER PLS_INTEGER;',
'    L_INITIALS_COLUMN_NUMBER PLS_INTEGER;',
'    ',
'    L_COLUMN_VALUE_LIST APEX_PLUGIN_UTIL.T_COLUMN_VALUE_LIST2;',
'    ',
'    L_COLOR VARCHAR2(4000) := NULL;',
'    L_LABEL VARCHAR2(4000) := NULL;',
'    L_LABEL_LINK VARCHAR2(4000) := NULL;',
'    L_VALUE VARCHAR2(4000) := NULL;',
'    L_VALUE_LINK VARCHAR2(4000) := NULL;',
'    L_IMAGE_URL VARCHAR2(4000) := NULL;',
'    L_CSS_ICON_CLASS_NAME VARCHAR2(4000) := NULL;',
'    L_INITIALS VARCHAR2(4000) := NULL;',
'    L_MESSAGE_WHEN_NO_DATA_FOUND VARCHAR2(4000) := NULL;',
'',
'    L_CUSTOM_CHART_COLORS_TABLE APEX_APPLICATION_GLOBAL.VC_ARR2;',
'    L_CUSTOM_CHART_COLORS VARCHAR2(32767) := NULL;',
'BEGIN',
'    L_COLUMN_VALUE_LIST := APEX_PLUGIN_UTIL.GET_DATA2(',
'        P_SQL_STATEMENT  => P_REGION.SOURCE,',
'        P_MIN_COLUMNS    => 1,',
'        P_MAX_COLUMNS    => NULL,',
'        P_COMPONENT_NAME => P_REGION.NAME,',
'        P_MAX_ROWS => C_MAXIMUM_ROWS',
'    );',
'',
'    L_COLOR_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Color Column'',',
'        P_COLUMN_ALIAS      => C_COLOR_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => C_COLOR_SCHEME = ''COLUMN'',',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    L_LABEL_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Label Column'',',
'        P_COLUMN_ALIAS      => C_LABEL_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => TRUE,',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    L_VALUE_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Value Column'',',
'        P_COLUMN_ALIAS      => C_VALUE_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => TRUE,',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    if C_ICON_TYPE = ''INITIALS'' then',
'        L_INITIALS_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'            P_ATTRIBUTE_LABEL   => ''Initials Column'',',
'            P_COLUMN_ALIAS      => C_INITIALS_COLUMN,',
'            P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'            P_IS_REQUIRED       => true,',
'            P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'        );',
'    end if;',
'    -- Begin output as JSON',
'    sys.OWA_UTIL.MIME_HEADER(''application/json'', FALSE);',
'    sys.HTP.P(''Cache-Control: no-cache'');',
'    sys.HTP.P(''Pragma: no-cache'');',
'    sys.OWA_UTIL.HTTP_HEADER_CLOSE;',
'    ',
'    IF C_COLOR_SCHEME = ''CUSTOM'' THEN',
'        L_CUSTOM_CHART_COLORS_TABLE := APEX_UTIL.STRING_TO_TABLE(CASE WHEN C_CUSTOM_CHART_COLORS IS NOT NULL THEN TRIM(BOTH '''''''' FROM APEX_ESCAPE.JS_LITERAL(C_CUSTOM_CHART_COLORS)) END, '':'');',
'        L_CUSTOM_CHART_COLORS := ''"color_scheme":['';',
'        FOR I IN L_CUSTOM_CHART_COLORS_TABLE.FIRST .. L_CUSTOM_CHART_COLORS_TABLE.LAST LOOP',
'            IF I > 1 THEN',
'                L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||'','';',
'            END IF;',
'            L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||''"''||L_CUSTOM_CHART_COLORS_TABLE(I)||''"'';',
'        END LOOP;',
'        L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||''],'';',
'    END IF;',
'',
'    L_MESSAGE_WHEN_NO_DATA_FOUND := APEX_ESCAPE.HTML_WHITELIST(',
'        APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                P_VALUE  => C_MESSAGE_WHEN_NO_DATA_FOUND,',
'                P_ESCAPE => FALSE',
'            )',
'        );',
'',
'    sys.HTP.PRN(',
'        ''{''||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''chart_type'',',
'                C_CHART_TYPE,',
'                FALSE,',
'                TRUE',
'            )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''message_when_no_data_found'',',
'            L_MESSAGE_WHEN_NO_DATA_FOUND,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''chart_css_class_names'',',
'            C_CHART_CSS_CLASSES,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''icon_type'',',
'            C_ICON_TYPE,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    IF C_COLOR_SCHEME = ''CUSTOM'' THEN',
'        sys.HTP.PRN(',
'            L_CUSTOM_CHART_COLORS',
'        );',
'    ELSE',
'        sys.HTP.PRN(',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''color_scheme'',',
'                C_COLOR_SCHEME,',
'                TRUE,',
'                TRUE',
'            )',
'        );',
'    END IF;',
'    sys.HTP.PRN(',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''text_position'',',
'                C_TEXT_POSITION,',
'                FALSE,',
'                TRUE',
'            )||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''bar_width_calculation'',',
'                C_BAR_WIDTH_CALCULATION,',
'                FALSE,',
'                TRUE',
'            )||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''display'',',
'                C_DISPLAY,',
'                FALSE,',
'                TRUE',
'            )||',
'            CASE ',
'            	WHEN C_DISPLAY IN (''VALUE'') THEN',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''prefix_for_value'',',
'						C_PREFIX_FOR_VALUE,',
'						TRUE,',
'						TRUE',
'					)||',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''postfix_for_value'',',
'						C_POSTFIX_FOR_VALUE,',
'						TRUE,',
'						TRUE',
'					)',
'			END||',
'            ''"items":[''',
'    );',
'    ',
'    --FOR L_ROW_NUMBER IN L_COLUMN_VALUE_LIST(1).VALUE_LIST.FIRST .. L_COLUMN_VALUE_LIST(1).VALUE_LIST.LAST LOOP',
'    FOR L_ROW_NUMBER IN 1 .. L_COLUMN_VALUE_LIST(1).VALUE_LIST.COUNT LOOP',
'        BEGIN',
'            APEX_PLUGIN_UTIL.SET_COMPONENT_VALUES (',
'                P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'                P_ROW_NUM => L_ROW_NUMBER ',
'            );',
'            ',
'            IF L_ROW_NUMBER > 1 THEN',
'            	sys.HTP.PRN('', '');',
'            END IF;',
'            ',
'            sys.HTP.PRN(''{'');',
'            ',
'            L_LABEL := APEX_PLUGIN_UTIL.ESCAPE (',
'                APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                    P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_LABEL_COLUMN_NUMBER).DATA_TYPE,',
'                    P_VALUE => L_COLUMN_VALUE_LIST(L_LABEL_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'                ),',
'                P_REGION.ESCAPE_OUTPUT',
'            );',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''label'',',
'                    L_LABEL,',
'                    FALSE',
'            	)',
'            );',
'            L_LABEL_LINK := ',
'                CASE ',
'                    WHEN C_LABEL_LINK IS NOT NULL THEN ',
'                        APEX_UTIL.PREPARE_URL (',
'                            APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                P_VALUE  => C_LABEL_LINK,',
'                                P_ESCAPE => FALSE',
'                            )',
'                        )',
'                END;',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''label_link'',',
'                    L_LABEL_LINK',
'                )',
'            );',
'            L_VALUE := APEX_PLUGIN_UTIL.ESCAPE (',
'               APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                   P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_VALUE_COLUMN_NUMBER).DATA_TYPE,',
'                   P_VALUE => L_COLUMN_VALUE_LIST(L_VALUE_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'               ),',
'               P_REGION.ESCAPE_OUTPUT',
'            );',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''value'',',
'                    L_VALUE,',
'                    FALSE,',
'                    C_VALUE_LINK IS NOT NULL OR L_COLOR_COLUMN_NUMBER IS NOT NULL OR C_CHART_TYPE = ''ICON''',
'                )',
'            );',
'            L_VALUE_LINK := ',
'                CASE ',
'                    WHEN C_VALUE_LINK IS NOT NULL THEN ',
'                        APEX_UTIL.PREPARE_URL (',
'                            APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                P_VALUE  => C_VALUE_LINK,',
'                                P_ESCAPE => FALSE',
'                            )',
'                        )',
'                END;',
'             sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''value_link'',',
'                    L_VALUE_LINK,',
'                    TRUE,',
'                    L_COLOR_COLUMN_NUMBER IS NOT NULL OR C_CHART_TYPE = ''ICON''',
'                )',
'            );',
'            IF L_COLOR_COLUMN_NUMBER IS NOT NULL THEN',
'                L_COLOR := APEX_PLUGIN_UTIL.ESCAPE (',
'                   APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                       P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_COLOR_COLUMN_NUMBER).DATA_TYPE,',
'                       P_VALUE => L_COLUMN_VALUE_LIST(L_COLOR_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'                   ),',
'                   P_REGION.ESCAPE_OUTPUT',
'                );',
'                sys.HTP.PRN(',
'                    APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                        ''color'',',
'                        L_COLOR,',
'                        FALSE,',
'                        C_CHART_TYPE = ''ICON''',
'                    )',
'                );',
'            END IF;',
'            IF C_ICON_TYPE = ''IMAGE'' THEN',
'				L_IMAGE_URL := ',
'                    CASE ',
'                        WHEN C_IMAGE_URL IS NOT NULL THEN ',
'                            APEX_UTIL.PREPARE_URL (',
'                                APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                    P_VALUE  => C_IMAGE_URL,',
'                                    P_ESCAPE => FALSE',
'                                )',
'                            )',
'                    END;',
'				sys.HTP.PRN(',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''image_url'',',
'						L_IMAGE_URL,',
'						FALSE,',
'						FALSE',
'					)',
'				);',
'			ELSIF C_ICON_TYPE = ''ICON'' THEN',
'				L_CSS_ICON_CLASS_NAME := APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                    P_VALUE  => C_CSS_ICON_CLASS_NAME,',
'                    P_ESCAPE => TRUE',
'                );',
'				sys.HTP.PRN(',
'                	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''icon_css_class_name'',',
'						L_CSS_ICON_CLASS_NAME,',
'						FALSE,',
'						FALSE',
'					)',
'				);',
'			ELSIF C_ICON_TYPE = ''INITIALS'' THEN',
'				L_INITIALS := APEX_PLUGIN_UTIL.ESCAPE (',
'					APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'						P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_INITIALS_COLUMN_NUMBER).DATA_TYPE,',
'						P_VALUE => L_COLUMN_VALUE_LIST(L_INITIALS_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'					),',
'					P_REGION.ESCAPE_OUTPUT',
'				);',
'				sys.HTP.PRN(',
'                	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    	''initials'',',
'	                    L_INITIALS,',
'	                    FALSE,',
'	                    FALSE',
'    	            )',
'    	        );',
'            END IF;',
'            ',
'			sys.HTP.PRN(''}'');',
'            ',
'            APEX_PLUGIN_UTIL.CLEAR_COMPONENT_VALUES;',
'        EXCEPTION',
'            WHEN OTHERS THEN',
'                APEX_PLUGIN_UTIL.CLEAR_COMPONENT_VALUES;',
'                RAISE;',
'        END;',
'    END LOOP;',
'    sys.HTP.PRN(',
'            '']''||',
'        ''}''',
'    );',
'    ',
'    RETURN NULL;',
'END AJAX;'))
,p_api_version=>1
,p_render_function=>'RENDER'
,p_ajax_function=>'AJAX'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT:ESCAPE_OUTPUT'
,p_substitute_attributes=>false
,p_reference_id=>5610141522737396215.4651
,p_subscribe_plugin_settings=>true
,p_help_text=>unistr('<p>Este plugin crea gr\00E1ficos de barras horizontales que contienen etiquetas, valores e incluso iconos</p>')
,p_version_identifier=>'1.0'
,p_files_version=>16
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708882027568788162.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Icon Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'INITIALS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1708890161503788168.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ICON'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'    <li><strong>Image</strong>: Adds an image HTML element on the left side of the chart.</li>',
'    <li><strong>CSS Icon</strong>: Unlike the &quot;Image&quot; icon, instead of displaying an image HTML element, it displays an icon with the given CSS class.</li>',
'    <li><strong>Initials</strong>: Opposed to both, the &quot;Image&quot; and &quot;CSS Icon&quot; icons, this one displays a colored circle containing the given initials.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708882456315788163.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708882027568788162.4651)
,p_display_sequence=>10
,p_display_value=>'Image'
,p_return_value=>'IMAGE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708882908025788163.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708882027568788162.4651)
,p_display_sequence=>20
,p_display_value=>'CSS Icon'
,p_return_value=>'ICON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708883385946788163.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708882027568788162.4651)
,p_display_sequence=>30
,p_display_value=>'Initials'
,p_return_value=>'INITIALS'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708883913265788164.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Label Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'<p>A query column from which the label to be displayed is given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708884308602788164.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Label Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
,p_help_text=>'<p>A URL to be opened whenever the label is clicked. This attribute supports substitution strings.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708884738587788164.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'<p>A query column from which the label to be displayed is given. Notice that this value is not displayed on the chart items when the chart has been configured to display the bar width percentage instead.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708885102368788165.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Value Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
,p_help_text=>'<p>A URL to be opened whenever the displayed value is clicked. This attribute supports substitution strings.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708885558870788165.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>5
,p_prompt=>'Chart CSS Class Names'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'<p>CSS class names to be added to the root element of the chart separated with spaces.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708885924214788165.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>13
,p_prompt=>'Image URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1708882027568788162.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'IMAGE'
,p_help_text=>'<p>The Image URL to be displayed as the chart icon. This attribute supports Substitution strings referring to som query column like in <strong>&amp;IMAGE_URL.</strong> which would reference the <strong>IMAGE_URL</strong> column value for each of the '
||'bars presented on the char. Notice that substitutions with no value will be replaced with an empty string.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708886364744788166.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>12
,p_prompt=>'CSS Icon Class Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1708882027568788162.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ICON'
,p_help_text=>'<p>The Icon CSS Class Name.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708886708045788166.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>14
,p_prompt=>'Initials Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1708882027568788162.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'INITIALS'
,p_help_text=>'<p>A query column from which initials to be displayed as an icon are given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708887118777788166.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>7
,p_prompt=>'Custom Chart Colors'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1708892893261788171.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'<p>A list of CSS supported colors separated by colons.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708887552870788166.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Display'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VALUE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'<p>Displays either the item value or the calculated bar width on the right most text in the chart item.</p>'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708887969287788167.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708887552870788166.4651)
,p_display_sequence=>10
,p_display_value=>'Value'
,p_return_value=>'VALUE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708888449760788167.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708887552870788166.4651)
,p_display_sequence=>20
,p_display_value=>'Bar Width'
,p_return_value=>'BAR_WIDTH'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708888931742788167.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Prefix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1708887552870788166.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE'
,p_help_text=>'<p>When the value is displayed on the right most side of the chart item. The value of this attribute is prepended to it.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708889353381788168.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Postfix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1708887552870788166.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE'
,p_help_text=>'<p>When the value is displayed on the right most side of the chart item. The value of this attribute is appended to it.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708889718148788168.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Maximum Rows'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'5'
,p_is_translatable=>false
,p_help_text=>'<p>The maximum number of items to be displayed inside the region. Notice bar width calculations are made based on the number of items displayed.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708890161503788168.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>4
,p_prompt=>'Chart Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'TEXT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Defines how the chart will be displayed. There are two types of chart: </p>',
'<ul>',
'    <li><strong>Icon Chart</strong>: Displays bars with the label and value above and add an icon on the left.</li>',
'    <li><strong>Text Chart</strong>: Displays bars with the label and value either above or inline with the bar.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708890493945788168.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708890161503788168.4651)
,p_display_sequence=>10
,p_display_value=>'Icon Chart'
,p_return_value=>'ICON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708890990973788169.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708890161503788168.4651)
,p_display_sequence=>20
,p_display_value=>'Text Chart'
,p_return_value=>'TEXT'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708891577616788169.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>105
,p_prompt=>'Bar Width Calculation'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ABSOLUTE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Bar widths for each one of the chart items can be calculated in two ways:</p>',
'<ul>',
'    <li><strong>Absolute</strong>: 100% bar width is represented by the maximum value on the displayed chart items.</li>',
'    <li><strong>Relative</strong>: 100% bar width is represented by the sum of the values of all the displayed chart items.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708891951707788169.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708891577616788169.4651)
,p_display_sequence=>10
,p_display_value=>'Absolute'
,p_return_value=>'ABSOLUTE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708892408961788170.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708891577616788169.4651)
,p_display_sequence=>20
,p_display_value=>'Relative'
,p_return_value=>'RELATIVE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708892893261788171.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>6
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'MODERN'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The colors to be used in the chart bars. There are two special types of configuration: </p>',
'<ul>',
'    <li><strong>Custom</strong>: Provides a text box to receive a colon separated list of css supported colors.</li>',
'</ul>',
'<ul>',
'    <li><strong>Query Column</strong>: Provides a select list with the query columns which expects a css valid color.</li>',
'</ul>',
''))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708893367551788172.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708892893261788171.4651)
,p_display_sequence=>5
,p_display_value=>'Default'
,p_return_value=>'DEFAULT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708893822893788172.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708892893261788171.4651)
,p_display_sequence=>10
,p_display_value=>'Modern'
,p_return_value=>'MODERN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708894354160788173.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708892893261788171.4651)
,p_display_sequence=>20
,p_display_value=>'Modern 2'
,p_return_value=>'MODERN_2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708894875437788173.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708892893261788171.4651)
,p_display_sequence=>30
,p_display_value=>'Solar'
,p_return_value=>'SOLAR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708895324925788173.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708892893261788171.4651)
,p_display_sequence=>40
,p_display_value=>'Metro'
,p_return_value=>'METRO'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708895816036788174.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708892893261788171.4651)
,p_display_sequence=>50
,p_display_value=>'Custom'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708896332346788174.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708892893261788171.4651)
,p_display_sequence=>60
,p_display_value=>'Query Column'
,p_return_value=>'COLUMN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708896850110788174.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>55
,p_prompt=>'Text Position'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'AROUND'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1708890161503788168.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'TEXT'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When displaying a text chart, two options are available for displaying the label and value texts:</p>',
'<ul>',
'    <li><strong>Above the bar</strong>: The label and value texts are displayed above the bar at the left and right most sides of it respectively.</li>',
'    <li><strong>Inline with the bar</strong>: The label, the bar and the value are displayed in one line on that order.</li>',
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708897216124788175.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708896850110788174.4651)
,p_display_sequence=>10
,p_display_value=>'Above the bar'
,p_return_value=>'ABOVE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1708897756955788175.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1708896850110788174.4651)
,p_display_sequence=>20
,p_display_value=>'Inline with the bar'
,p_return_value=>'AROUND'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708898247285788176.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>8
,p_prompt=>'Chart Colors Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1708892893261788171.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'COLUMN'
,p_help_text=>'<p>A query column from which CSS supported colors are given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1708898490590788176.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>200
,p_prompt=>'Message When No Data Found'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_default_value=>'No data found.'
,p_is_translatable=>true
,p_help_text=>'<p>Message to be displayed when no data was found.</p>'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(1708906125156788184.4651)
,p_plugin_id=>wwv_flow_api.id(637620824431401115.4651)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>1
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_listcalendar
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.LISTCALENDAR'
,p_display_name=>'Calendario de Lista (Creador)'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.LISTCALENDAR'),'#IMAGE_PREFIX#plugins/com.oracle.apex.listcalendar/')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'procedure render_list_calendar( p_region in apex_plugin.t_region ) is',
'    c_date_col           constant varchar2(255) := p_region.attribute_01;',
'    c_color_col          constant varchar2(255) := p_region.attribute_02;',
'    c_title_col          constant varchar2(255) := p_region.attribute_03;',
'    c_link_col           constant varchar2(255) := p_region.attribute_04;',
'    c_row1_attr1_lbl_col constant varchar2(255) := p_region.attribute_05;',
'    c_row1_attr1_val_col constant varchar2(255) := p_region.attribute_06;',
'    c_row1_attr2_lbl_col constant varchar2(255) := p_region.attribute_07;',
'    c_row1_attr2_val_col constant varchar2(255) := p_region.attribute_08;',
'    c_row2_attr1_lbl_col constant varchar2(255) := p_region.attribute_09;',
'    c_row2_attr1_val_col constant varchar2(255) := p_region.attribute_10;',
'    c_row2_attr2_lbl_col constant varchar2(255) := p_region.attribute_11;',
'    c_row2_attr2_val_col constant varchar2(255) := p_region.attribute_12;',
'    c_description_1_col  constant varchar2(255) := p_region.attribute_13;',
'    c_description_2_col  constant varchar2(255) := p_region.attribute_14;',
'    c_description_3_col  constant varchar2(255) := p_region.attribute_15;',
'',
'    l_date_col_no           pls_integer;',
'    l_color_col_no          pls_integer;',
'    l_title_col_no          pls_integer;',
'    l_link_col_no           pls_integer;',
'    l_row1_attr1_lbl_col_no pls_integer;',
'    l_row1_attr1_val_col_no pls_integer;',
'    l_row1_attr2_lbl_col_no pls_integer;',
'    l_row1_attr2_val_col_no pls_integer;',
'    l_row2_attr1_lbl_col_no pls_integer;',
'    l_row2_attr1_val_col_no pls_integer;',
'    l_row2_attr2_lbl_col_no pls_integer;',
'    l_row2_attr2_val_col_no pls_integer;',
'    l_description_1_col_no  pls_integer;',
'    l_description_2_col_no  pls_integer;',
'    l_description_3_col_no  pls_integer;',
'',
'    l_date           timestamp with local time zone;',
'    l_color          varchar2(4000);',
'    l_color_hex      varchar2(4000);',
'    l_title          varchar2(4000);',
'    l_link           varchar2(4000);',
'    l_row1_attr1_lbl varchar2(4000);',
'    l_row1_attr1_val varchar2(4000);',
'    l_row1_attr2_lbl varchar2(4000);',
'    l_row1_attr2_val varchar2(4000);',
'    l_row2_attr1_lbl varchar2(4000);',
'    l_row2_attr1_val varchar2(4000);',
'    l_row2_attr2_lbl varchar2(4000);',
'    l_row2_attr2_val varchar2(4000);',
'    l_description_1  varchar2(4000);',
'    l_description_2  varchar2(4000);',
'    l_description_3  varchar2(4000);',
'',
'    --',
'    l_no_data_found     varchar2(32767) := p_region.no_data_found_message;',
'    l_num_rows          pls_integer     := p_region.fetched_rows;',
'    --',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_region_source        varchar2(32767) := p_region.source;',
'',
'    --',
'    l_last_month  varchar2(255) := ''x'';',
'    l_this_year   varchar2(4)   := ''x'';',
'',
'    l_found boolean;',
'    l_count pls_integer := 0;',
'begin',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => l_region_source,',
'                               p_min_columns    => 3,',
'                               p_max_columns    => null,',
'                               p_component_name => p_region.name,',
'                               p_max_rows       => null );',
'',
'    -- Get the actual column number for the fields we want.',
'    l_date_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Date column'',',
'                        p_column_alias      => c_date_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => null -- might be date, timestamp, etc.',
'                    );',
'',
'    l_color_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Color column'',',
'                        p_column_alias      => c_color_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_title_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Title column'',',
'                        p_column_alias      => c_title_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_link_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Link column'',',
'                        p_column_alias      => c_link_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr1_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Attribute Label column'',',
'                        p_column_alias      => c_row1_attr1_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr1_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Attribute Value column'',',
'                        p_column_alias      => c_row1_attr1_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr2_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Attribute Label column'',',
'                        p_column_alias      => c_row1_attr2_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr2_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Attribute Value column'',',
'                        p_column_alias      => c_row1_attr2_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr1_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Attribute Label column'',',
'                        p_column_alias      => c_row2_attr1_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr1_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Attribute Value column'',',
'                        p_column_alias      => c_row2_attr1_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr2_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Fourth Attribute Label column'',',
'                        p_column_alias      => c_row2_attr2_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr2_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Fourth Attribute Value column'',',
'                        p_column_alias      => c_row2_attr2_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_1_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Description column'',',
'                        p_column_alias      => c_description_1_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_2_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Description column'',',
'                        p_column_alias      => c_description_2_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_3_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Description column (allows HTML)'',',
'                        p_column_alias      => c_description_3_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    -- Loop through the data',
'',
'    sys.htp.p(''<div class="a-StatusList a-StatusList--dates">'');',
'',
'    for l_row_num in 1..l_column_value_list(1).value_list.count loop',
'        l_found := true;',
'',
'        if l_column_value_list(l_date_col_no).value_list(l_row_num).date_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).date_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_tz_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_tz_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_ltz_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_ltz_value;',
'        else',
'            -- Couldn''t get a usable date value; ignore this row.',
'            l_found := false;',
'        end if;',
'        if l_found = true and l_count < nvl(l_num_rows,l_count) then',
'            l_count := l_count + 1;',
'            if l_color_col_no is not null then',
'                l_color := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_color_col_no).data_type,',
'                                p_value     => l_column_value_list(l_color_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_title_col_no is not null then',
'                l_title := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_title_col_no).data_type,',
'                                p_value     => l_column_value_list(l_title_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_link_col_no is not null then',
'                l_link := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_link_col_no).data_type,',
'                                p_value     => l_column_value_list(l_link_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr1_lbl_col_no is not null then',
'                l_row1_attr1_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr1_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr1_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr1_val_col_no is not null then',
'                l_row1_attr1_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr1_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr1_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr2_lbl_col_no is not null then',
'                l_row1_attr2_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr2_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr2_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr2_val_col_no is not null then',
'                l_row1_attr2_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr2_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr2_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr1_lbl_col_no is not null then',
'                l_row2_attr1_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr1_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr1_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr1_val_col_no is not null then',
'                l_row2_attr1_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr1_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr1_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr2_lbl_col_no is not null then',
'                l_row2_attr2_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr2_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr2_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr2_val_col_no is not null then',
'                l_row2_attr2_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr2_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr2_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_1_col_no is not null then',
'                l_description_1 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_1_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_1_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_2_col_no is not null then',
'                l_description_2 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_2_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_2_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_3_col_no is not null then',
'                l_description_3 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_3_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_3_col_no).value_list(l_row_num) ),',
'                            false );',
'            end if;',
'',
'            -- Limit it down to the colors we support.',
'            l_color := initcap(l_color);',
'            if l_color not in (''Red'',''Black'',''Yellow'',''Green'') then',
'                l_color_hex := l_color;',
'                l_color     := '''';',
'            else',
'                l_color_hex := '''';',
'            end if;',
'',
'            if l_color = ''Red'' then',
'                l_color := ''is-error'';',
'            elsif l_color = ''Black'' then',
'                l_color := ''is-complete'';',
'            elsif l_color = ''Yellow'' then',
'                l_color := ''is-warning'';',
'            elsif l_color = ''Green'' then',
'                l_color := ''is-open'';',
'            end if;',
'',
'            -- Start of the actual rendering code.',
'',
'            if l_last_month != to_char(l_date,''YYYYMM'') then',
'                l_last_month := to_char(l_date,''YYYYMM'');',
'',
'                if l_count > 1 then',
'                    -- Not the first row; close the previous group.',
'                    sys.htp.p(''</ul></div>'');',
'                end if;',
'',
'                sys.htp.p(''<div class="a-StatusList-block">'');',
'                -- if to_char(l_date,''YYYY'') != l_this_year then',
'                sys.htp.p(''<h3 class="a-StatusList-blockHeader"><span class="a-StatusList-headerTextPrimary">''||trim(to_char(l_date,''Month''))||',
'                    ''</span><span class="a-StatusList-headerTextAlt">''||to_char(l_date,''YYYY'')||''</span></h3>'');',
'                l_this_year := to_char(l_date,''YYYY'');',
'                -- else',
'                    -- sys.htp.p(''<h3>''||to_char(l_date,''Month'')||''</h3>'');',
'                -- end if;',
'                sys.htp.p(''<ul class="a-StatusList-list">'');',
'            end if;',
'',
'            sys.htp.p(''<li class="a-StatusList-item ''||l_color||''"><div class="a-StatusList-itemMarker"><span class="a-StatusList-marker" role="presentation">''',
'                ||to_char(l_date,''fmDD'')||''</span></div>'');',
'            -- if l_color is not null then',
'                -- sys.htp.p(''<div class="status''||l_color||''">'');',
'            -- else',
'                -- sys.htp.p(''<div style="border-left-color: ''||l_color_hex||''">'');',
'            -- end if;',
'            sys.htp.p(''<div class="a-StatusList-itemBody">'');',
'            sys.htp.p(''<p class="a-StatusList-itemTitle"><a href="''||apex_util.prepare_url(l_link)||''">''||l_title||''</a></p>'');',
'',
'            if l_row1_attr1_lbl is not null or l_row1_attr1_val is not null',
'                    or l_row1_attr2_lbl is not null or l_row1_attr2_val is not null then',
'                sys.htp.prn(''<div class="a-StatusList-itemAttrs">'');',
'                if l_row1_attr1_lbl is not null and l_row1_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr1_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row1_attr1_val||''</span></span>'');',
'                elsif l_row1_attr1_lbl is null and l_row1_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row1_attr1_val||''</span></span>'');',
'                elsif l_row1_attr1_lbl is not null and l_row1_attr1_val is null then',
'                    sys.htp.prn(''<span><span class="a-StatusList-attrLabel">''||l_row1_attr1_lbl||''</span></span>'');',
'                else',
'                    -- No attr1.',
'                    null;',
'                end if;',
'',
'                if l_row1_attr2_lbl is not null and l_row1_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr2_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row1_attr2_val||''</span></span>'');',
'                elsif l_row1_attr2_lbl is null and l_row1_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row1_attr2_val||''</span></span>'');',
'                elsif l_row1_attr2_lbl is not null and l_row1_attr2_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr2_lbl||''</span></span>'');',
'                else',
'                    -- No attr2.',
'                    null;',
'                end if;',
'                -- sys.htp.prn(''</div>'');',
'            end if;',
'',
'            if l_row2_attr1_lbl is not null or l_row2_attr1_val is not null',
'                    or l_row2_attr2_lbl is not null or l_row2_attr2_val is not null then',
'                -- sys.htp.prn(''<p>'');',
'                if l_row2_attr1_lbl is not null and l_row2_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr1_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row2_attr1_val||''</span></span>'');',
'                elsif l_row2_attr1_lbl is null and l_row2_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row2_attr1_val||''</span></span>'');',
'                elsif l_row2_attr1_lbl is not null and l_row2_attr1_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr1_lbl||''</span></span>'');',
'                else',
'                    -- No attr3.',
'                    null;',
'                end if;',
'',
'                if l_row2_attr2_lbl is not null and l_row2_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr2_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row2_attr2_val||''</span></span>'');',
'                elsif l_row2_attr2_lbl is null and l_row2_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row2_attr2_val||''</span></span>'');',
'                elsif l_row2_attr2_lbl is not null and l_row2_attr2_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr2_lbl||''</span></span>'');',
'                else',
'                    -- No attr4.',
'                    null;',
'                end if;',
'                sys.htp.prn(''</div>'');',
'            end if;',
'',
'            if l_description_1 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_1||''</p>'');',
'            end if;',
'',
'            if l_description_2 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_2||''</p>'');',
'            end if;',
'',
'            if l_description_3 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_3||''</p>'');',
'            end if;',
'',
'            sys.htp.prn(''</div></li>'');',
'        end if;',
'    end loop;',
'    if l_count > 0 then',
'        -- Close the HTML.',
'        sys.htp.p(''</ul></div>'');',
'    else',
'        sys.htp.p(''<span class="nodatafound">''||l_no_data_found||''</span>'');',
'    end if;',
'    sys.htp.p(''</div>'');',
'end render_list_calendar;',
'',
'function render ( p_region in apex_plugin.t_region,',
'    p_plugin in apex_plugin.t_plugin, p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result is',
'begin',
'    render_list_calendar( p_region );',
'    return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render'
,p_standard_attributes=>'SOURCE_SQL:FETCHED_ROWS:NO_DATA_FOUND_MESSAGE:ESCAPE_OUTPUT'
,p_substitute_attributes=>true
,p_reference_id=>1517592169582192572.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
,p_files_version=>3
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397820664413465022.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Date column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'DATE:TIMESTAMP:TIMESTAMP_TZ:TIMESTAMP_LTZ'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397821055837465022.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Color column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397821379146465022.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Title column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397821789566465022.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Link column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397822203255465022.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'First Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397822650396465024.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'First Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397822982443465025.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Second Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397823379472465025.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Second Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397823877364465025.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Third Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397824199294465026.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Third Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397824621786465026.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Fourth Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397825010572465026.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Fourth Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
end;
/
begin
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397825337465465026.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'First Description column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397825775644465026.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Second Description column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2397826103144465026.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>150
,p_prompt=>'Third Description column (allows HTML)'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(851664399498374640.4651)
,p_plugin_id=>wwv_flow_api.id(1524140959408925227.4651)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>3
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_d3_barchart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.D3.BARCHART'
,p_display_name=>unistr('Gr\00E1fico de Barras D3 ***')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.D3.BARCHART'),'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.barchart/')
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/d3/3.3.11/d3.min.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3/d3.oracle.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3/oracle.jql.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3/jquery.getScrollbarWidth.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.tooltip/d3.oracle.tooltip.js',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.ary/d3.oracle.ary.js',
'#PLUGIN_FILES#d3.oracle.barchart.js',
'#PLUGIN_FILES#d3.oracle.barchart.apex.js',
'#PLUGIN_FILES#com.oracle.apex.d3.barchart.js'))
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.tooltip/d3.oracle.tooltip.css',
'#IMAGE_PREFIX#plugins/com.oracle.apex.d3.ary/d3.oracle.ary.css',
'#PLUGIN_FILES#d3.oracle.barchart.css'))
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render ',
'(',
'    p_region                in  apex_plugin.t_region,',
'    p_plugin                in  apex_plugin.t_plugin,',
'    p_is_printer_friendly   in  boolean ',
')',
'return apex_plugin.t_region_render_result',
'is',
'    c_region_static_id      constant varchar2(255)  := apex_escape.html_attribute( p_region.static_id );',
'',
'-- Assign readable names to plugin attributes. Omit data attributes, they''ll be handled in ajax function.',
'    -- Dimensions',
'    c_height_mode           constant varchar2(200)  := p_region.attribute_21;',
'    c_min_height            constant number         := nvl(p_region.attribute_18, 100);',
'    c_max_height            constant number         := nvl(p_region.attribute_19, 500);',
'    c_spacing               constant number         := nvl(p_region.attribute_16, 20);',
'    c_inner_spacing         constant number         := nvl(p_region.attribute_17, 20);',
'',
'    -- Axis titles',
'    c_x_axis_title          constant varchar2(200)  := p_region.attribute_08;',
'    c_y_axis_title          constant varchar2(200)  := p_region.attribute_09;',
'',
'    -- Axis grid',
'    c_x_axis_grid           constant boolean        := instr('':'' || p_region.attribute_22 || '':'', '':X:'') > 0;',
'    c_y_axis_grid           constant boolean        := instr('':'' || p_region.attribute_22 || '':'', '':Y:'') > 0;',
'',
'    -- Tooltip configuration',
'    c_show_tooltip          constant boolean        := p_region.attribute_10 is not null;',
'    c_series_tooltip        constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':SERIES:'') > 0;',
'    c_x_tooltip             constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':X:'') > 0;',
'    c_y_tooltip             constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':Y:'') > 0;',
'    c_custom_tooltip        constant boolean        := instr('':'' || p_region.attribute_10 || '':'', '':CUSTOM:'') > 0;',
'',
'    -- Legend',
'    c_show_legend           constant boolean        := p_region.attribute_12 is not null;',
'    c_legend_position       constant varchar2(200)  := p_region.attribute_12;',
'',
'    -- Display modes',
'    c_value_template        constant varchar2(200)  := nvl(p_region.attribute_15, p_region.attribute_25);',
'    c_horizontal            constant boolean        := substr(p_region.attribute_06, 1, instr(p_region.attribute_06, '','') - 1) = ''HORIZONTAL'';',
'    c_display               constant varchar2(200)  := substr(p_region.attribute_06, instr(p_region.attribute_06, '','') + 1);',
'    c_responsive            constant boolean        := p_plugin.attribute_06 = ''Y'';',
'    c_transitions           constant boolean        := p_plugin.attribute_05 = ''Y'';',
'',
'    -- Colors',
'    c_color_scheme          constant varchar2(200)  := p_region.attribute_13;',
'    l_colors                varchar2(200)           := p_region.attribute_14;',
'    c_multiple_colors       constant boolean        := p_region.attribute_24 = ''Y'';',
'',
'    -- Aspect ratios',
'    c_min_ar                constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_plugin.attribute_02, ''Min Aspect Radio'' ), 1.333);',
'    c_max_ar                constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_plugin.attribute_01, ''Max Aspect Radio'' ), 3);',
'    c_threshold             constant number         := p_plugin.attribute_03;',
'    c_threshold_of          constant varchar2(200)  := p_plugin.attribute_04;',
'',
'    -- Function constants',
'    c_rgb_list_regex        constant varchar2(200)  := ''^#[0-9a-fA-F]{6}(,#[0-9a-fA-F]{6})*$'';',
'begin',
'    -- Add placeholder div',
'    sys.htp.p (',
'        ''<div class="a-D3BarChart" id="'' || c_region_static_id || ''_region">'' ||',
'            ''<div class="a-D3BarChart-container" id="'' || c_region_static_id || ''_chart"></div>'' ||',
'        ''</div>'' );',
'',
'',
'    -- Color scheme',
'    case c_color_scheme',
'        when ''MODERN'' then',
'            l_colors := ''#FF3B30:#FF9500:#FFCC00:#4CD964:#34AADC:#007AFF:#5856D6:#FF2D55:#8E8E93:#C7C7CC'';',
'        when ''MODERN2'' then',
'            l_colors := ''#1ABC9C:#2ECC71:#4AA3DF:#9B59B6:#3D566E:#F1C40F:#E67E22:#E74C3C'';',
'        when ''SOLAR'' then',
'            l_colors := ''#B58900:#CB4B16:#DC322F:#D33682:#6C71C4:#268BD2:#2AA198:#859900'';',
'        when ''METRO'' then',
'            l_colors := ''#E61400:#19A2DE:#319A31:#EF9608:#8CBE29:#A500FF:#00AAAD:#FF0094:#9C5100:#E671B5'';',
'        else',
'            null;',
'    end case;',
'',
'    -- Build the initial chart. Data will be loaded with ajax.',
'    apex_javascript.add_onload_code (',
'        p_code => ''com_oracle_apex_d3_barchart('' ||',
'            apex_javascript.add_value(p_region.static_id) ||',
'            ''{'' ||',
'                apex_javascript.add_attribute(''chartRegionId'',  p_region.static_id || ''_chart'') ||',
'                apex_javascript.add_attribute(''xAxisTitle'',     c_x_axis_title) || ',
'                apex_javascript.add_attribute(''yAxisTitle'',     c_y_axis_title) || ',
'                apex_javascript.add_attribute(''showTooltip'',    c_show_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipSeries'',  c_series_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipX'',       c_x_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipY'',       c_y_tooltip) || ',
'                apex_javascript.add_attribute(''tooltipCustom'',  c_custom_tooltip) || ',
'                apex_javascript.add_attribute(''spacing'',        c_spacing) || ',
'                apex_javascript.add_attribute(''innerSpacing'',   c_inner_spacing) || ',
'                apex_javascript.add_attribute(''horizontal'',     c_horizontal) || ',
'                apex_javascript.add_attribute(''display'',        c_display) || ',
'                apex_javascript.add_attribute(''responsive'',     c_responsive) || ',
'                apex_javascript.add_attribute(''transitions'',    c_transitions) || ',
'                apex_javascript.add_attribute(''valueTemplate'',  c_value_template) || ',
'                apex_javascript.add_attribute(''showLegend'',     c_show_legend) || ',
'                apex_javascript.add_attribute(''legendPosition'', c_legend_position) || ',
'                apex_javascript.add_attribute(''colors'',         l_colors) || ',
'                apex_javascript.add_attribute(''xGrid'',          c_x_axis_grid) || ',
'                apex_javascript.add_attribute(''yGrid'',          c_y_axis_grid) || ',
'                apex_javascript.add_attribute(''multipleColors'', c_multiple_colors) || ',
'                apex_javascript.add_attribute(''heightMode'',     c_height_mode) || ',
'                apex_javascript.add_attribute(''minHeight'',      c_min_height) || ',
'                apex_javascript.add_attribute(''maxHeight'',      c_max_height) || ',
'                apex_javascript.add_attribute(''threshold'',      c_threshold) || ',
'                apex_javascript.add_attribute(''thresholdOf'',    c_threshold_of) || ',
'                apex_javascript.add_attribute(''minAR'',          c_min_ar) || ',
'                apex_javascript.add_attribute(''maxAR'',          c_max_ar) || ',
'                apex_javascript.add_attribute(''noDataFoundMessage'', p_region.no_data_found_message) || ',
'                apex_javascript.add_attribute(''pageItems'',      apex_plugin_util.page_item_names_to_jquery(p_region.ajax_items_to_submit)) ||',
'                apex_javascript.add_attribute(''ajaxIdentifier'', apex_plugin.get_ajax_identifier, false, false) ||',
'            ''});'' );',
'    return null;',
'end;',
'',
'function ajax',
'(',
'    p_region    in  apex_plugin.t_region,',
'    p_plugin    in  apex_plugin.t_plugin ',
')',
'return apex_plugin.t_region_ajax_result',
'is',
'    -- It''s better to have named variables instead of using the generic ones, ',
'    -- makes the code more readable. ',
'',
'    c_has_multiple_series   constant boolean := ( p_region.attribute_03 = ''Y'' );',
'',
'    -- Column names',
'    c_x_column              constant varchar2(255) := p_region.attribute_01;',
'    c_y_column              constant varchar2(255) := p_region.attribute_02;',
'    c_series_column         constant varchar2(255) := case when c_has_multiple_series then p_region.attribute_04 end;',
'    c_tooltip_column        constant varchar2(255) := p_region.attribute_11;',
'    c_link_target           constant varchar2(255) := p_region.attribute_20;',
'',
'    -- Series name, for single series configuration',
'    c_series_name           constant varchar2(200) := case when not c_has_multiple_series then p_region.attribute_05 end;',
'    c_use_sql_color         constant boolean       := p_region.attribute_13 = ''COLUMN'';',
'',
'    -- Column numbers for fetching',
'    l_x_column_no           pls_integer;',
'    l_y_column_no           pls_integer;',
'    l_series_column_no      pls_integer;',
'    l_tooltip_column_no     pls_integer;',
'    l_column_value_list     apex_plugin_util.t_column_value_list2;',
'',
'    -- Holders for row data',
'    l_x                     varchar2(200);',
'    l_y                     number;',
'    l_series                varchar2(4000);',
'    l_color                 varchar2(4000);',
'    l_tooltip               varchar2(4000);',
'    l_link                  varchar2(4000);',
'',
'begin',
'',
'    apex_json.initialize_output (',
'        p_http_cache => false );',
'',
'    apex_json.open_object;',
'',
'    -- First, we must get the color mapping if the color scheme requires it.',
'    if c_use_sql_color then',
'        l_column_value_list := apex_plugin_util.get_data2 (',
'            p_sql_statement     => p_region.attribute_23,',
'            p_min_columns       => 2,',
'            p_max_columns       => 2,',
'            p_component_name    => p_region.name );',
'',
'        apex_json.open_array(''colors'');',
'        for l_row_num in 1 .. l_column_value_list(1).value_list.count loop',
'            -- Series, optional',
'            l_series := apex_plugin_util.get_value_as_varchar2 (',
'                p_data_type => l_column_value_list(1).data_type,',
'                p_value     => l_column_value_list(1).value_list(l_row_num) );',
'            l_color := apex_plugin_util.get_value_as_varchar2 (',
'                p_data_type => l_column_value_list(2).data_type,',
'                p_value     => l_column_value_list(2).value_list(l_row_num) );',
'            ',
'            apex_json.open_object;',
'            apex_json.write(''series'', l_series);',
'            apex_json.write(''color'',  l_color);',
'            apex_json.close_object;',
'',
'        end loop;',
'        apex_json.close_array;',
'',
'        l_series := null;',
'    end if;',
'',
'    -- Then, we get the actual data points.',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'        p_sql_statement  => p_region.source,',
'        p_min_columns    => 2,',
'        p_max_columns    => 5,',
'        p_component_name => p_region.name );',
'',
'    -- Get the actual column # for faster access and also verify that the data type',
'    -- of the column matches with what we are looking for',
'    l_x_column_no := apex_plugin_util.get_column_no (',
'                p_attribute_label       => ''x column'',',
'                p_column_alias          => c_x_column,',
'                p_column_value_list     => l_column_value_list,',
'                p_is_required           => true,',
'                p_data_type             => apex_plugin_util.c_data_type_varchar2 );',
'',
'    l_y_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''y column'',',
'        p_column_alias          => c_y_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => true,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    l_series_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''series column'',',
'        p_column_alias          => c_series_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_varchar2 );',
'',
'    l_tooltip_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''tooltip column'',',
'        p_column_alias          => c_tooltip_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_varchar2 );',
'',
'    apex_json.open_array(''data'');',
'',
'    -- Fetch data',
'    for l_row_num in 1 .. l_column_value_list(1).value_list.count loop',
'        begin',
'            apex_plugin_util.set_component_values (',
'                p_column_value_list => l_column_value_list,',
'                p_row_num => l_row_num ',
'            );',
'',
'            -- X is a string, required',
'            if l_x_column_no is not null then',
'                l_x := apex_plugin_util.get_value_as_varchar2 (',
'                    p_data_type => l_column_value_list(l_x_column_no).data_type,',
'                    p_value     => l_column_value_list(l_x_column_no).value_list(l_row_num) );',
'            end if;',
'',
'            -- Y is a number, required',
'            l_y := l_column_value_list(l_y_column_no).value_list(l_row_num).number_value;',
'',
'            -- Series, optional',
'            if l_series_column_no is not null then',
'                l_series := apex_plugin_util.get_value_as_varchar2 (',
'                    p_data_type => l_column_value_list(l_series_column_no).data_type,',
'                    p_value     => l_column_value_list(l_series_column_no).value_list(l_row_num) );',
'            end if;',
'',
'            -- Tooltip, optional',
'            if l_tooltip_column_no is not null then',
'                l_tooltip := apex_plugin_util.get_value_as_varchar2 (',
'                    p_data_type => l_column_value_list(l_tooltip_column_no).data_type,',
'                    p_value     => l_column_value_list(l_tooltip_column_no).value_list(l_row_num) );',
'            end if;',
'',
'            -- Link, optional',
'            if c_link_target is not null then',
'                l_link := wwv_flow_utilities.prepare_url (',
'                    apex_plugin_util.replace_substitutions (',
'                        p_value  => c_link_target,',
'                        p_escape => false ) );',
'            end if;',
'',
'            apex_json.open_object;',
'            apex_json.write(''series'',  nvl(l_series, c_series_name));',
'            apex_json.write(''tooltip'', l_tooltip);',
'            apex_json.write(''link'',    l_link);',
'            apex_json.write(''x'',       l_x);',
'            apex_json.write(''y'',       l_y);',
'            apex_json.close_object;',
'',
'            apex_plugin_util.clear_component_values;',
'        exception when others then',
'            apex_plugin_util.clear_component_values;',
'            raise;',
'        end;',
'    end loop;',
'    apex_json.close_array;',
'    apex_json.close_object;',
'',
'    return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render'
,p_ajax_function=>'ajax'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT:NO_DATA_FOUND_MESSAGE'
,p_substitute_attributes=>false
,p_reference_id=>8312108105074277335.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'0.1'
,p_files_version=>58
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275934272049945089.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Max Aspect Ratio'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'3'
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The maximum aspect ratio that Flot line charts use to recommend a height. A max aspect ratio of 3 means that the chart''s width should be no greater than 3 times its height. It can be overridden by the ''Max Height'' setting on each region.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275934653983945089.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Min Aspect Ratio'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'1.333'
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The minimum aspect ratio that Flot line charts use to recommend a height. A min aspect ratio of 1.333 means that the chart''s width should be no less than 1.333 times its height. It can be overridden by the ''Min Height'' setting on each region.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275934999903945089.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Responsive Behavior Threshold'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'480'
,p_display_length=>5
,p_max_length=>5
,p_is_translatable=>false
,p_help_text=>'The threshold (in pixels) at which the responsive behavior will be activated.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275935424967945090.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Responsive Behavior Measure'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'WINDOW'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Whether the responsive behavior threshold will be compared to the window or the region''s width.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275935850349945090.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275935424967945090.4651)
,p_display_sequence=>10
,p_display_value=>'Window'
,p_return_value=>'WINDOW'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275936283314945090.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275935424967945090.4651)
,p_display_sequence=>20
,p_display_value=>'Region'
,p_return_value=>'REGION'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275936855775945091.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Enable Transitions'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275937195915945091.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'APPLICATION'
,p_attribute_sequence=>6
,p_display_sequence=>25
,p_prompt=>'Responsive Behavior'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275937664233945091.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'X Values Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'X'
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'The column of the region SQL query to use as X values.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275938037266945092.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Y Values Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'Y'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column of the region SQL query to use as Y values.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275938461944945092.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Multiple Series'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Enable multi-series functionality on the chart. If selected, you must select a column to use as a series identifier.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275938798030945092.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275938461944945092.4651)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275939307619945093.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Series Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'SERIES'
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(275938461944945092.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The column of the region SQL query to use as a series identifier. The values on this column will become the series'' names.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275939711544945093.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Series Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(275938461944945092.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
,p_help_text=>'The name of the single data series to be shown on the legend.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275940119009945093.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>2
,p_prompt=>'Display'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VERTICAL,SIDE-BY-SIDE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275940549698945093.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275940119009945093.4651)
,p_display_sequence=>10
,p_display_value=>'Vertical, Side by Side'
,p_return_value=>'VERTICAL,SIDE-BY-SIDE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275940987588945094.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275940119009945093.4651)
,p_display_sequence=>20
,p_display_value=>'Horizontal, Side by Side'
,p_return_value=>'HORIZONTAL,SIDE-BY-SIDE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275941496664945094.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275940119009945093.4651)
,p_display_sequence=>30
,p_display_value=>'Vertical, Stacked'
,p_return_value=>'VERTICAL,STACKED'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275942030823945094.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275940119009945093.4651)
,p_display_sequence=>40
,p_display_value=>'Horizontal, Stacked'
,p_return_value=>'HORIZONTAL,STACKED'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275942488066945095.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'X Axis Title'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_help_text=>'The label for the X axis.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275942921966945095.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Y Axis Title'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_help_text=>'The label for the Y axis.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275943290779945095.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Tooltips'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Customize what is shown on the tooltip for each data point. The ''Custom column'' option allows you to specify text for each individual data point as an additional column in the region SQL query. Leave all options unselected to disable the tooltips.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275943704949945096.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275943290779945095.4651)
,p_display_sequence=>0
,p_display_value=>'Show series name'
,p_return_value=>'SERIES'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275944244700945096.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275943290779945095.4651)
,p_display_sequence=>10
,p_display_value=>'Show X value'
,p_return_value=>'X'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275944616766945096.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275943290779945095.4651)
,p_display_sequence=>20
,p_display_value=>'Show Y value'
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275945123569945097.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275943290779945095.4651)
,p_display_sequence=>30
,p_display_value=>'Custom column'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275945665091945097.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Tooltip Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(275943290779945095.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'SERIES:X:Y:CUSTOM,SERIES:X:CUSTOM,SERIES:Y:CUSTOM,X:Y:CUSTOM,SERIES:CUSTOM,X:CUSTOM,Y:CUSTOM,CUSTOM'
,p_help_text=>'The column of the region SQL query to use as custom tooltip values.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275945996999945097.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Legend'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_default_value=>'TOP'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_null_text=>'None'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275946417455945097.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275945996999945097.4651)
,p_display_sequence=>10
,p_display_value=>'Above chart'
,p_return_value=>'TOP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275946916150945098.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275945996999945097.4651)
,p_display_sequence=>20
,p_display_value=>'Below chart'
,p_return_value=>'BOTTOM'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275947407763945098.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'MODERN'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_null_text=>'Theme Default'
,p_help_text=>'The color scheme used to render the chart. A different color will be assigned to each series.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275947810467945098.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275947407763945098.4651)
,p_display_sequence=>10
,p_display_value=>'Modern'
,p_return_value=>'MODERN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275948327782945099.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275947407763945098.4651)
,p_display_sequence=>20
,p_display_value=>'Modern 2'
,p_return_value=>'MODERN2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275948833072945099.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275947407763945098.4651)
,p_display_sequence=>30
,p_display_value=>'Solar'
,p_return_value=>'SOLAR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275949342553945099.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275947407763945098.4651)
,p_display_sequence=>40
,p_display_value=>'Metro'
,p_return_value=>'METRO'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275949857207945100.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275947407763945098.4651)
,p_display_sequence=>50
,p_display_value=>'Custom'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275950356822945100.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275947407763945098.4651)
,p_display_sequence=>60
,p_display_value=>'SQL Query'
,p_return_value=>'COLUMN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275950833000945100.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Colors'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(275947407763945098.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'A colon-separated list of color strings (e.g. #FF3377, rgba(0,25,47,0.5), blue) to use as a color scheme for the chart.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275951220217945101.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>60
,p_prompt=>'Custom Value Formatting'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'FRIENDLY'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'<li><b>,d</b> = 14,435</li>',
'<li><b>d</b> = 14435</li>',
'<li><b>,.2f</b> = 14,435.49</li>',
'<li><b>.2f</b> = 14435.49</li>',
'<li><b>.3s</b> = 14.4k</li>',
'<li><b>$,d</b> = $14,435</li>',
'<li><b>$d</b> = $14435</li>',
'<li><b>$,.2f</b> = $14,435.49</li>',
'<li><b>$.2f</b> = $14435.49</li>',
'<li><b>$.3s</b> = $14.4k</li>',
'<li><b>n" ft."</b> = 14435.49 ft. **</li>',
'<li><b>"[["$.3s"]]"</b> = [[$14.4k]] **</li>',
'<li>Refer to https://github.com/mbostock/d3/wiki/Formatting#d3_format for the full syntax specification</li>',
'</ul>',
'<br/>',
'** You may use leading and trailing double-quoted literals, but this feature is not part of the standard D3 specification'))
,p_help_text=>'The D3 format string used to format the "Y" values on axes, tooltips and legends. Write "FRIENDLY" to use sensible formatting defaults for your data.'
);
end;
/
begin
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275951637458945101.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>61
,p_prompt=>'Spacing Between Categories'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'10'
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The spacing between categories, expressed as an integer percentage (1-100).'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275952043642945101.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>62
,p_prompt=>'Spacing Between Series'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'10'
,p_display_length=>5
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(275938461944945092.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NOT_NULL'
,p_help_text=>'This spacing applies between bars of different series on the same category (X value). It is represented as an integer percentage (0-100). Affects only "Side by Side" display modes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275952402595945102.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>1
,p_prompt=>'Min Height'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The minimum height, in pixels, of the chart. Chart width will adapt to the size of the region. Defaults to 100px.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275952820548945102.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>2
,p_prompt=>'Max Height'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The maximum height, in pixels, of the chart. Chart width will adapt to the size of the region. Defaults to 500px.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275953180806945102.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>115
,p_prompt=>'Link Target'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275953620532945102.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>21
,p_display_sequence=>0
,p_prompt=>'Height Measure'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BARS'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275954006363945104.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275953620532945102.4651)
,p_display_sequence=>10
,p_display_value=>'Bars Area'
,p_return_value=>'BARS'
,p_help_text=>'Min and max height for the area where the bars are drawn. Axis labels may take additional space.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275954479825945104.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275953620532945102.4651)
,p_display_sequence=>20
,p_display_value=>'Chart Area'
,p_return_value=>'CHART'
,p_help_text=>'Min and max height will include the axes'' dimensions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275955020678945104.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>22
,p_display_sequence=>220
,p_prompt=>'Show Grid Lines'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275955436359945105.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275955020678945104.4651)
,p_display_sequence=>10
,p_display_value=>'X Axis'
,p_return_value=>'X'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275955977414945106.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275955020678945104.4651)
,p_display_sequence=>20
,p_display_value=>'Y Axis'
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275956400943945106.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>23
,p_display_sequence=>230
,p_prompt=>'Color SQL Query'
,p_attribute_type=>'SQL'
,p_is_required=>true
,p_is_common=>false
,p_show_in_wizard=>false
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(275947407763945098.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'COLUMN'
,p_help_text=>'A SQL query that maps a series name to an RGB color. The first column must contain the series names (and those values must match the ones returned from the region SQL) and the second column must have the RGB color for the series. Both columns must be'
||' VARCHAR2.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275956825749945106.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>24
,p_display_sequence=>60
,p_prompt=>'Multiple Colors'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(275938461944945092.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'NULL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(275957206971945106.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>25
,p_display_sequence=>59
,p_prompt=>'Value Formatting'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'.3s'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_null_text=>'Custom'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275957665940945107.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_display_sequence=>30
,p_display_value=>'14,435'
,p_return_value=>',.0f'
,p_help_text=>'Comma-separated thousands, integers'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275958144958945107.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_display_sequence=>40
,p_display_value=>'14435'
,p_return_value=>'.0f'
,p_help_text=>'Integer'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275958637987945107.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_display_sequence=>60
,p_display_value=>'14,435.49'
,p_return_value=>',.2f'
,p_help_text=>'Comma-separated thousands, 2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275959172799945108.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_display_sequence=>70
,p_display_value=>'14435.49'
,p_return_value=>'.2f'
,p_help_text=>'2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275959634857945108.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_display_sequence=>71
,p_display_value=>'14.4k'
,p_return_value=>'.3s'
,p_help_text=>'Precision 3, SI suffixes'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275960106962945108.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_display_sequence=>80
,p_display_value=>'$14,435'
,p_return_value=>'$,.0f'
,p_help_text=>'Currency, comma-separated thousands, integer'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275960669785945109.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_display_sequence=>90
,p_display_value=>'$14435'
,p_return_value=>'$.0f'
,p_help_text=>'Currency, integer'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275961096758945109.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_display_sequence=>99
,p_display_value=>'$14,435.49'
,p_return_value=>'$,.2f'
,p_help_text=>'Currency, comma-separated thousands, 2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275961593725945109.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_display_sequence=>100
,p_display_value=>'$14435.49'
,p_return_value=>'$.2f'
,p_help_text=>'Currency, 2 decimals'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(275962149613945110.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(275957206971945106.4651)
,p_display_sequence=>120
,p_display_value=>'$14.4k'
,p_return_value=>'$.3s'
,p_help_text=>'Currency, precison 3, SI suffixes'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(851664550218374642.4651)
,p_plugin_id=>wwv_flow_api.id(1551233413469846021.4651)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>2
,p_sql_max_column_count=>5
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_css_bar_chart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1816546838189755555.4651)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.CSS_BAR_CHART'
,p_display_name=>unistr('Gr\00E1fico de Barras CSS')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.CSS_BAR_CHART'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'procedure render_bar_chart (',
'    p_region in apex_plugin.t_region )',
'is',
'    -- constants for the columns of our region source query',
'    c_label_col constant pls_integer := 1;',
'    c_value_col constant pls_integer := 2;',
'    c_url_col   constant pls_integer := 3;',
'    c_color_col constant pls_integer := 4;',
'',
'    -- attributes of the plug-in',
'    l_display_as           varchar2(20)    := nvl(p_region.attribute_01, ''VALUE_ABSOLUTE'');',
'    l_value_prefix         varchar2(40)    := p_region.attribute_02;',
'    l_value_postfix        varchar2(40)    := p_region.attribute_03;',
'    -- page items to submit = p_region.attribute_09',
'    l_max_rows             number          := to_number(p_region.attribute_10);',
'    l_region_source        varchar2(32767) := p_region.source;',
'',
'    l_valid_data_type_list wwv_flow_global.vc_arr2;',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_max_value            number;',
'    l_total_value          number;',
'    l_label                varchar2(4000);',
'    l_value                number;',
'    l_url                  varchar2(4000);',
'    l_color                varchar2(4000);',
'    l_width                number;',
'    l_display_value        varchar2(4000);',
'begin',
'',
'    -- if percentage is displayed then the value will always have % as postfix',
'    if l_display_as like ''PERCENTAGE%'' then',
'        l_value_postfix := '' %'';',
'    end if;',
'',
'    -- define the valid column data types for the region query',
'    l_valid_data_type_list(c_label_col) := apex_plugin_util.c_data_type_varchar2;',
'    l_valid_data_type_list(c_value_col) := apex_plugin_util.c_data_type_number;',
'    l_valid_data_type_list(c_url_col)   := apex_plugin_util.c_data_type_varchar2;',
'    l_valid_data_type_list(c_color_col) := apex_plugin_util.c_data_type_varchar2;',
'',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => l_region_source,',
'                               p_min_columns    => 2,',
'                               p_max_columns    => 4,',
'                               p_data_type_list => l_valid_data_type_list,',
'                               p_component_name => p_region.name,',
'                               p_max_rows       => l_max_rows );',
'',
'    -- calculate the total or max value depending on "Display As"',
'    -- We could rewrite the region query with SUM(xxx) over ()',
'    -- but that would require that we know how the columns are named in the query.',
'    -- That''s why we just do a simple loop of the tiny array to get the',
'    -- total/max value which is probably faster anyway',
'    if l_display_as like ''%RELATIVE'' then',
'        l_total_value := 0;',
'        for i in 1 .. l_column_value_list(c_value_col).value_list.count loop',
'            -- $$$ what should we do if VALUE is NULL??? Set l_total_value to NULL as well?',
'            l_total_value := l_total_value + l_column_value_list(c_value_col).value_list(i).number_value;',
'        end loop;',
'    else',
'        l_max_value := 0;',
'        for i in 1 .. l_column_value_list(c_value_col).value_list.count loop',
'            -- $$$ what should we do if VALUE is NULL??? Set l_max_value to NULL as well?',
'            if l_column_value_list(c_value_col).value_list(i).number_value > l_max_value then',
'                l_max_value := l_column_value_list(c_value_col).value_list(i).number_value;',
'            end if;',
'        end loop;',
'    end if;',
'',
'    -- print our bar chart',
'    sys.htp.p(''<table class="cbc" border="0" cellspacing="0" cellpadding="0" ''||wwv_flow_utilities.get_layout_table_attributes||''>'');',
'',
'    for i in 1 .. l_column_value_list(c_label_col).value_list.count loop',
'        l_label := sys.htf.escape_sc(l_column_value_list(c_label_col).value_list(i).varchar2_value);',
'        l_value := l_column_value_list(c_value_col).value_list(i).number_value;',
'',
'        -- get the value of the URL and color only if the column exists in the SQL statement',
'        if l_column_value_list.exists(c_url_col) then',
'            l_url := wwv_flow_utilities.prepare_url (',
'                         apex_application.do_substitutions (',
'                             l_column_value_list(c_url_col).value_list(i).varchar2_value ));',
'        end if;',
'        if l_column_value_list.exists(c_color_col) then',
'            l_color := lower(l_column_value_list(c_color_col).value_list(i).varchar2_value);',
'            -- map a few of the standard colors to better looking ones',
'            l_color := case l_color',
'                         when ''red''     then ''#e10''',
'                         when ''yellow''  then ''#fd0''',
'                         when ''green''   then ''#0c0''',
'                         when ''black''   then ''#555''',
'                         when ''default'' then ''#ddd''',
'                         else l_color',
'                       end;',
'        end if;',
'',
'        -- calculate how long the chart bar should be',
'        if l_display_as like ''%RELATIVE'' then',
'            if l_total_value = 0 then',
'                l_width := 0;',
'            else',
'                l_width := round(l_value * 100 / l_total_value);',
'            end if;',
'        else',
'            if l_max_value = 0 then',
'                l_width := 0;',
'            else',
'                l_width := round(l_value * 100 / l_max_value);',
'            end if;',
'        end if;',
'',
'        if l_display_as like ''PERCENTAGE%'' then',
'            l_value := l_width;',
'        end if;',
'',
'        l_display_value := case when l_value_prefix is not null then l_value_prefix||'' '' end||',
'                           trim(to_char(l_value, ''999G999G999G990''))||',
'                           case when l_value_postfix is not null then '' ''||l_value_postfix end;',
'',
'        sys.htp.p(''<tr>'');',
'',
'        -- print label column and add link if an URL has been specified in the SQL statement',
'        -- otherwise just print the label',
'        sys.htp.p(''<td class="label"><span class="cbc_label">'');',
'        if l_url is not null then',
'            sys.htp.p(''<a href="''||l_url||''">''||l_label||''</a>'');',
'        else',
'            sys.htp.p(l_label);',
'        end if;',
'        sys.htp.p(''</span></td>'');',
'',
'        -- print chart bar',
'        sys.htp.p(''<td>'');',
'        sys.htp.p(''<span class="cbc_bar_background">'');',
'',
'        -- add link if an URL has been specified in the SQL statement otherwise just print the value',
'        if l_url is not null then',
'            sys.htp.p(''<span class="cbc_value"><a href="''||l_url||''">''||l_display_value||''</a></span>'');',
'        else',
'            sys.htp.p(''<span class="cbc_value">''||l_display_value||''</span>'');',
'        end if;',
'        ',
'        sys.htp.p (',
'            ''<span class="cbc_bar" style="width:''||l_width||''%;''||',
'            case when l_color is not null then ''background-color:''||l_color end||',
'            ''"></span>'' );',
'        sys.htp.p(''</span>'');',
'        sys.htp.p(''</td>'');',
'',
'        sys.htp.p(''</tr>'');',
'    end loop;',
'',
'    sys.htp.p(''</table>'');',
'end render_bar_chart;',
'',
'',
'function render (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result',
'is',
'    l_page_items_to_submit varchar2(4000)  := p_region.attribute_09;',
'begin',
'    apex_css.add_file (',
'        p_name      => ''css_bar_chart'',',
'        p_directory => p_plugin.file_prefix,',
'        p_version   => null );',
'',
'    sys.htp.p (''',
'<!--[if IE]> ',
'<style type="text/css" media="screen">',
'.cbc .cbc_bar_background {',
'  background-color: #FFF;',
'  border: 1px solid #AAA;',
'}',
'.cbc .cbc_value {',
'  color: #000;',
'  border-right: 1px solid #AAA;',
'}',
'.cbc .cbc_value a {',
'  color: #000;',
'}',
'.cbc .cbc_value a:hover {',
'  text-decoration: underline',
'}',
'</style>',
'<![endif]-->'');',
'',
'    -- print our region data',
'    sys.htp.p(''<div id="''||p_region.static_id||''_chart" class="cbc">'');',
'',
'    render_bar_chart (',
'        p_region => p_region );',
'',
'    sys.htp.p(''</div>'');',
'',
'    apex_javascript.add_library (',
'        p_name      => ''com_oracle_apex_css_bar_chart'',',
'        p_directory => p_plugin.file_prefix,',
'        p_version   => null );',
'',
'    apex_javascript.add_onload_code (',
'        p_code => ''com_oracle_apex_css_bar_chart(''||',
'                      apex_javascript.add_value(p_region.static_id)||',
'                      ''{''||',
'                      apex_javascript.add_attribute(''pageItemsToSubmit'', apex_plugin_util.page_item_names_to_jquery(l_page_items_to_submit))||',
'                      apex_javascript.add_attribute(''ajaxIdentifier'',    apex_plugin.get_ajax_identifier, false, false)||',
'                      ''});'' );',
'',
'    return null;',
'end render;',
'',
'function ajax (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin )',
'    return apex_plugin.t_region_ajax_result',
'is',
'begin',
'    sys.owa_util.mime_header(''text/html'', false);',
'    sys.htp.p(''Cache-Control: no-cache'');',
'    sys.htp.p(''Pragma: no-cache'');',
'    sys.owa_util.http_header_close;',
'',
'    render_bar_chart (',
'        p_region => p_region );',
'',
'    return null;',
'exception when others then',
'    sys.htp.p(''Error: ''||sqlerrm);',
'end ajax;'))
,p_api_version=>1
,p_render_function=>'render'
,p_ajax_function=>'ajax'
,p_standard_attributes=>'SOURCE_SQL'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'0.9'
,p_about_url=>'http://apex.oracle.com/plugins'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1816547151003759272.4651)
,p_plugin_id=>wwv_flow_api.id(1816546838189755555.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Display As'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VALUE_ABSOLUTE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(918438625362325151.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1816547151003759272.4651)
,p_display_sequence=>1
,p_display_value=>'Percentage with absolute bar width'
,p_return_value=>'PERCENTAGE_ABSOLUT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(918439139214329198.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1816547151003759272.4651)
,p_display_sequence=>1
,p_display_value=>'Percentage with relative bar width'
,p_return_value=>'PERCENTAGE_RELATIVE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(918439714411331424.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1816547151003759272.4651)
,p_display_sequence=>1
,p_display_value=>'Value with absolute bar width'
,p_return_value=>'VALUE_ABSOLUTE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(918440221337333410.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(1816547151003759272.4651)
,p_display_sequence=>1
,p_display_value=>'Value with relative bar width'
,p_return_value=>'VALUE_RELATIVE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1816547630009762665.4651)
,p_plugin_id=>wwv_flow_api.id(1816546838189755555.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Prefix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>10
,p_max_length=>40
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1816547151003759272.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE_ABSOLUTE,VALUE_RELATIVE'
,p_help_text=>'Specify the prefix which should be added to the displayed value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1816548136935764738.4651)
,p_plugin_id=>wwv_flow_api.id(1816546838189755555.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Postfix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>10
,p_max_length=>40
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1816547151003759272.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE_ABSOLUTE,VALUE_RELATIVE'
,p_help_text=>'Specify the postfix which should be added to the displayed value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(918443034412356141.4651)
,p_plugin_id=>wwv_flow_api.id(1816546838189755555.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Page Items to Submit'
,p_attribute_type=>'PAGE ITEMS'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Specify a comma separated list of page items that will be submitted to the server and thus, available for use from within your region source SQL statement.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1816548753904769595.4651)
,p_plugin_id=>wwv_flow_api.id(1816546838189755555.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Maximum Rows'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'5'
,p_display_length=>3
,p_max_length=>3
,p_is_translatable=>false
,p_help_text=>'Defines the maximum number of rows to query and to display.'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(851664603556374644.4651)
,p_plugin_id=>wwv_flow_api.id(1816546838189755555.4651)
,p_name=>'SOURCE_SQL'
,p_is_required=>false
,p_sql_min_column_count=>2
,p_sql_max_column_count=>4
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The region source has to be in the following format:',
'<pre>',
'select label,',
'       value,',
'       [link,]',
'       [color]',
'  from table',
' order by value',
'</pre>',
'<ul>',
'<li><strong>Label</strong> is the label ...</li>',
'<li><strong>Value</strong> is the value ... and has to be of type NUMBER</li>',
'<li><strong>Link</strong> is optional and can allow a user to navigate to another page within the application or a provided URL, and is activated by clicking on the chart bar of the record.</li>',
'<li><strong>Color</strong> is optional and is the background color of the chart bar for the record. The color is a hex value (for example #ff0000) or one of the standard web colors like red, green, ...</li>',
'</ul>',
'<h5>Example with a link column</h5>',
'<pre>',
'select ename,',
'       sal,',
'       ''f?p=&APP_ID.:300:''||:APP_SESSION||''::::P300_EMPNO:''||empno as link',
'  from emp',
' order by sal desc',
'</pre>'))
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_tag_cloud
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1823567055267032277.4651)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.TAG_CLOUD'
,p_display_name=>'Conjunto de Etiquetas 2'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.TAG_CLOUD'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result',
'is',
'    -- Constants for the columns of our region source query',
'    c_tag_col   constant pls_integer := 1;',
'    c_count_col constant pls_integer := 2;',
'',
'    -- attributes of the plug-in',
'    l_target_url           varchar2(4000)  := p_region.attribute_01;',
'    l_max_display_tags     number          := p_region.attribute_02;',
'    l_show_count           boolean         := nvl(p_region.attribute_03,''Y'') = ''Y'';',
'',
'',
'    l_valid_data_type_list wwv_flow_global.vc_arr2;',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_printed_records    number := 0;',
'    l_available_records  number := 20;',
'    l_max                number;',
'    l_min                number;',
'    l_total              number := 0;',
'    l_cnts               number;',
'    l_tag                varchar2(4000);',
'',
'    l_class_size         number;',
'    l_class              varchar2(30);',
'',
'begin',
'    -- don''t need to load css file, styles are contained within theme_42',
'    ',
'    -- apex_css.add_file (',
'    --     p_name      => ''tag_cloud'',',
'    --     p_directory => p_plugin.file_prefix,',
'    --     p_version   => null );',
'',
'',
'    -- define the valid column data types for the region query',
'    l_valid_data_type_list(c_tag_col) := apex_plugin_util.c_data_type_varchar2;',
'    l_valid_data_type_list(c_count_col) := apex_plugin_util.c_data_type_number;',
'',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => p_region.source,',
'                               p_min_columns    => 2,',
'                               p_max_columns    => 2,',
'                               p_data_type_list => l_valid_data_type_list,',
'                               p_component_name => p_region.name );',
'',
'   l_available_records := l_column_value_list(c_tag_col).value_list.count;',
'',
'   -----------------------------------------------',
'   -- Determine total count and maximum tag counts',
'   --',
'   l_max := 0;',
'   l_min := 1000;',
'   FOR i in 1.. l_column_value_list(c_count_col).value_list.count loop',
'      l_cnts := l_column_value_list(c_count_col).value_list(i).number_value;',
'      l_total := l_total + l_cnts;',
'      if l_cnts > l_max then',
'         l_max := l_cnts;',
'      end if;',
'      if l_cnts < l_min then',
'         l_min := l_cnts;',
'      end if;',
'   end loop;',
'   if l_max = 0 then l_max := 1; end if;',
'',
'',
'   l_class_size := round((l_max-l_min)/6);',
'',
'   ------------------------',
'   -- Generate tag cloud --',
'   --',
'   ',
'   sys.htp.prn(''<ul class="a-TagCloud">'');',
'',
'   for i in 1.. l_column_value_list(c_tag_col).value_list.count loop',
'       l_printed_records := l_printed_records + 1;',
'       l_tag := sys.htf.escape_sc(l_column_value_list(c_tag_col).value_list(i).varchar2_value);',
'       l_cnts := l_column_value_list(c_count_col).value_list(i).number_value;',
'       if l_cnts < l_min + l_class_size then',
'          l_class := ''size1'';',
'       elsif l_cnts < l_min + (l_class_size*2) then',
'          l_class := ''size2'';',
'       elsif l_cnts < l_min + (l_class_size*3) then',
'          l_class := ''size3'';',
'       elsif l_cnts < l_min + (l_class_size*4) then',
'          l_class := ''size4'';',
'       elsif l_cnts < l_min + (l_class_size*5) then',
'          l_class := ''size5'';',
'       else l_class := ''size6'';',
'       end if;      ',
'       ',
'        sys.htp.prn(''<li class="a-TagCloud-item">''',
'            ||apex_plugin_util.get_link(',
'                p_url  => replace(l_target_url,''#TAG#'',l_tag),',
'                p_text => l_tag',
'                            ||case when l_show_count then',
'                                '' <span class="a-TagCloud-count">''||l_cnts||''</span>''',
'                            end,',
'                p_escape_text => false,',
'                p_attributes => ''class="a-TagCloud-link a-TagCloud-link--''',
'                    ||l_class||''"'')',
'            ||''</li>'');',
'',
'       if  l_printed_records > l_max_display_tags then',
'           exit;',
'       end if;',
'   end loop;',
'',
'   sys.htp.prn(''</ul>'');',
'',
'   return null;',
'end render;'))
,p_api_version=>1
,p_render_function=>'render'
,p_standard_attributes=>'SOURCE_SQL'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1823599236052064538.4651)
,p_plugin_id=>wwv_flow_api.id(1823567055267032277.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Target URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:2:&APP_SESSION.::::P2_FILTER:#TAG#'
,p_display_length=>60
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1823600635837073993.4651)
,p_plugin_id=>wwv_flow_api.id(1823567055267032277.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Maximum Displayed Tags'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>4
,p_max_length=>4
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1823601446572077108.4651)
,p_plugin_id=>wwv_flow_api.id(1823567055267032277.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Show Count'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(851664682476374645.4651)
,p_plugin_id=>wwv_flow_api.id(1823567055267032277.4651)
,p_name=>'SOURCE_SQL'
,p_is_required=>false
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2081986255421507394.4651)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>'Agregar Casilla de Control Activar Todo'
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512.4651
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>La acci\00F3n din\00E1mica "Agregar casilla de control Activar todo" convierte una cabecera de columna que contiene la cadena #CHECK_ALL_CHECKBOX# en una casilla de control de estilo Activar todo accesible, que permite activar y desactivar todas las casil')
||'las de control en su columna correspondiente.<p>',
'<p>',
unistr('Para utilizar este plugin, aseg\00FArese de que est\00E1n definidos los siguientes atributos:'),
'<ol>',
'<li>En la columna de informe, ''#CHECK_ALL_CHECKBOX#'' definido como el valor de cabecera.</li>',
unistr('<li>Para el atributo Cu\00E1ndo de Acci\00F3n din\00E1mica, seleccione la regi\00F3n de informe que contenga la columna.</li>'),
unistr('<li>Defina la acci\00F3n din\00E1mica para que dispare "Despu\00E9s de refrescamiento" y la acci\00F3n en "Arrancar al cargar p\00E1gina". (Ambos se definir\00E1n por defecto de forma adecuada si la acci\00F3n din\00E1mica se crea mediante la selecci\00F3n de la regi\00F3n en la secci\00F3n "P')
||unistr('resentaci\00F3n" del Dise\00F1ador de p\00E1ginas y la creaci\00F3n de la acci\00F3n din\00E1mica desde ah\00ED.</li>'),
unistr('<li>Con esto no se manejar\00E1 la accesibilidad de las casillas de control que se presentan en cada fila. Esto se debe realizar por separado en el origen de regi\00F3n. (Consulte la regi\00F3n 4000:656 "Regiones" para obtener un ejemplo).</li>'),
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_raphael_justgage
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.RAPHAEL.JUSTGAGE'
,p_display_name=>'Indicador JustGage ***'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.RAPHAEL.JUSTGAGE'),'#IMAGE_PREFIX#plugins/com.oracle.apex.raphael.justgage/1.0/')
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#PLUGIN_FILES#plugin.js',
'#PLUGIN_FILES#justgage.js',
'#IMAGE_PREFIX#libraries/raphaeljs/2.1.2/apex.raphael.min.js'))
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render ',
'(',
'    p_region                in  apex_plugin.t_region,',
'    p_plugin                in  apex_plugin.t_plugin,',
'    p_is_printer_friendly   in  boolean ',
')',
'return apex_plugin.t_region_render_result',
'is',
'    -- Assign readable names to plugin attributes. Omit data attributes, they''ll be handled in ajax function.',
'    -- Label configuration',
'    c_show_labels           constant boolean        := p_region.attribute_04 = ''Y'';',
'    l_title                 varchar(200)            := nvl(p_region.attribute_05, '''');',
'    l_units                 varchar(200)            := nvl(p_region.attribute_06, '''');',
'    l_value_prefix          varchar(200)            := nvl(p_region.attribute_07, '''');',
'    l_value_suffix          varchar(200)            := nvl(p_region.attribute_08, '''');',
'    l_show_min_max          boolean                 := nvl(p_region.attribute_09, ''N'') = ''Y'';',
'    c_description_template  constant varchar(2000)  := apex_plugin_util.replace_substitutions(',
'                                                           nvl(p_region.attribute_20, ''''));',
'    l_heading               varchar(200)            := apex_plugin_util.replace_substitutions(',
'                                                           nvl(p_region.attribute_21, ''''));',
'',
'    -- Shadow configuration',
'    c_show_shadow           constant boolean        := nvl(p_region.attribute_10, ''N'') = ''Y'';',
'    c_shadow_opacity        constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_region.attribute_11, ''Shadow Opacity'' ), 0 );',
'    c_shadow_offset         constant number         := to_number(nvl(p_region.attribute_12, 0));',
'',
'    -- Gauge configuration',
'    c_gauge_width           constant number         := nvl( apex_plugin_util.get_attribute_as_number( p_region.attribute_13, ''Gauge Width Scale'' ), 1 );',
'    c_gauge_color_scheme    constant varchar(200)   := p_region.attribute_14;',
'    l_gauge_colors          varchar(200)            := p_region.attribute_15;',
'    l_gauge_bg_color        varchar(200)            := p_region.attribute_16;',
'    c_gauge_mode            constant varchar(200)   := p_region.attribute_17;',
'    c_width                 constant number         := p_region.attribute_18;',
'    c_height                constant number         := p_region.attribute_19;',
'    c_decimals              constant number         := greatest(nvl(p_region.attribute_24, 0), 0);',
'    l_width_style           varchar(200)            := '''';',
'    l_height_style          varchar(200)            := '''';',
'',
'    -- Function constants',
'    c_rgb_single_regex      constant varchar2(200)  := ''^#[0-9a-fA-F]{6}$'';',
'    c_rgb_list_regex        constant varchar2(200)  := ''^#[0-9a-fA-F]{6}(,#[0-9a-fA-F]{6})*$'';',
'begin',
'    -- Size style settings',
'    if c_width is not null then ',
'        l_width_style := ''width:'' || c_width || ''px;'';',
'    end if;',
'    if c_height is not null then ',
'        l_height_style := ''height:'' || c_height || ''px;'';',
'    end if;',
'',
'    -- Add placeholder div',
'    sys.htp.p (',
'        ''<div class="a-BadgeChart a-BadgeChart--justGage" id="'' || p_region.static_id || ''_container">'' ||',
'            ''<div class="a-JustGage-desc"></div>'' ||',
'            ''<div id="'' || p_region.static_id || ''_gauge" class="a-JustGage-chart" style="'' || l_width_style || l_height_style || ''"></div>'' ||',
'            ''<div class="a-BadgeChart-text">'' ||',
'                ''<span class="a-BadgeChart-label"></span>'' ||',
'                ''<span class="a-BadgeChart-desc"></span>'' ||',
'            ''</div>'' ||',
'        ''</div>'');',
'',
'    -- Labels defaults',
'    if not c_show_labels then',
'        l_title := '''';',
'        l_units := '''';',
'        l_value_prefix := '''';',
'        l_value_suffix := '''';',
'        l_show_min_max := false;',
'    end if;',
'',
'    -- Donut mode has no min/max value labels',
'    l_show_min_max := l_show_min_max and c_gauge_mode <> ''donut'';',
'',
'    -- Validate shadow configuration',
'    if c_show_shadow then',
'        if c_shadow_opacity < 0 or c_shadow_opacity > 1 then',
'            -- invalid option',
'            null;',
'        end if; ',
'    end if;',
'',
'    -- Validate gauge configuration',
'    if c_gauge_width <= 0 then',
'        -- invalid option',
'        null;',
'    end if;',
'    case c_gauge_color_scheme',
'        when ''GTR'' then',
'            l_gauge_colors := ''#56bd0d,#f0dc05,#f52900'';',
'        when ''RTG'' then',
'            l_gauge_colors := ''#f52900,#f0dc05,#56bd0d'';',
'        else',
'            l_gauge_colors := replace(l_gauge_colors, '' '', '''');',
'            if not regexp_like(l_gauge_colors, c_rgb_list_regex) then',
'                -- invalid option',
'                null;',
'            end if;',
'    end case;',
'    l_gauge_bg_color := replace(l_gauge_bg_color, '' '', '''');',
'    if not regexp_like(l_gauge_bg_color, c_rgb_single_regex) then',
'        -- invalid option',
'        null;',
'    end if;',
'',
'    -- Build the initial chart. Data will be loaded with ajax.',
'    apex_javascript.add_onload_code (',
'        p_code => ''com_oracle_apex_raphael_justgage('' ||',
'            apex_javascript.add_value(p_region.static_id) ||',
'            ''{'' ||',
'                apex_javascript.add_attribute(''regionId'',       p_region.static_id || ''_gauge'') || ',
'                apex_javascript.add_attribute(''title'',          l_title) || ',
'                apex_javascript.add_attribute(''units'',          l_units) || ',
'                apex_javascript.add_attribute(''valuePrefix'',    l_value_prefix) || ',
'                apex_javascript.add_attribute(''valueSuffix'',    l_value_suffix) || ',
'                apex_javascript.add_attribute(''roundTo'',        c_decimals) || ',
'                apex_javascript.add_attribute(''showMinMax'',     l_show_min_max) || ',
'                apex_javascript.add_attribute(''showShadow'',     c_show_shadow) || ',
'                apex_javascript.add_attribute(''shadowOpacity'',  c_shadow_opacity) || ',
'                apex_javascript.add_attribute(''shadowOffset'',   c_shadow_offset) || ',
'                apex_javascript.add_attribute(''gaugeWidth'',     c_gauge_width) || ',
'                apex_javascript.add_attribute(''gaugeColors'',    l_gauge_colors) || ',
'                apex_javascript.add_attribute(''gaugeBgColor'',   l_gauge_bg_color) || ',
'                apex_javascript.add_attribute(''gaugeMode'',      c_gauge_mode) || ',
'                apex_javascript.add_attribute(''heading'',        l_heading) || ',
'                apex_javascript.add_attribute(''description'',    c_description_template) || ',
'                apex_javascript.add_attribute(''pageItems'',      apex_plugin_util.page_item_names_to_jquery(p_region.ajax_items_to_submit)) ||',
'                apex_javascript.add_attribute(''ajaxIdentifier'', apex_plugin.get_ajax_identifier, false, false) ||',
'            ''});'' );',
'    return null;',
'end;',
'',
'',
'function ajax ',
'(',
'    p_region    in  apex_plugin.t_region,',
'    p_plugin    in  apex_plugin.t_plugin ',
')',
'return apex_plugin.t_region_ajax_result',
'is',
'    -- It''s better to have named variables instead of using the generic ones, ',
'    -- makes the code more readable. ',
'    c_value_column          constant varchar2(255) := p_region.attribute_01;',
'    c_min_column            constant varchar2(255) := p_region.attribute_02;',
'    c_max_column            constant varchar2(255) := p_region.attribute_03;',
'    c_heading_link          constant varchar2(4000) := p_region.attribute_22;',
'    c_description_link      constant varchar2(4000) := p_region.attribute_23;',
'',
'    l_value_column_no       pls_integer;',
'    l_min_column_no         pls_integer;',
'    l_max_column_no         pls_integer;',
'    l_column_value_list     apex_plugin_util.t_column_value_list2;',
'',
'    l_value                 number;',
'    l_min                   number;',
'    l_max                   number;',
'    l_heading_link          varchar2(4000);',
'    l_description_link      varchar2(4000);',
'begin',
'    apex_plugin_util.print_json_http_header;',
'',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'        p_sql_statement     => p_region.source,',
'        p_min_columns       => 1,',
'        p_max_columns       => 3,',
'        p_component_name    => p_region.name );',
'',
'    -- Get the actual column # for faster access and also verify that the data type',
'    -- of the column matches with what we are looking for',
'    l_value_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''value column'',',
'        p_column_alias          => c_value_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => true,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    l_min_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''min value column'',',
'        p_column_alias          => c_min_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    l_max_column_no := apex_plugin_util.get_column_no (',
'        p_attribute_label       => ''min value column'',',
'        p_column_alias          => c_max_column,',
'        p_column_value_list     => l_column_value_list,',
'        p_is_required           => false,',
'        p_data_type             => apex_plugin_util.c_data_type_number );',
'',
'    -- Fetch the data',
'    if l_column_value_list(1).value_list.count = 1 then',
'        apex_plugin_util.set_component_values (',
'            p_column_value_list => l_column_value_list,',
'            p_row_num => 1 ',
'        );',
'    ',
'        l_heading_link := case',
'            when c_heading_link is not null then',
'                apex_util.prepare_url (',
'                    apex_plugin_util.replace_substitutions (',
'                        p_value  => c_heading_link,',
'                        p_escape => false',
'                    )',
'                )',
'        end;',
'        ',
'        l_description_link := case',
'            when c_description_link is not null then',
'                apex_util.prepare_url (',
'                    apex_plugin_util.replace_substitutions (',
'                        p_value  => c_description_link,',
'                        p_escape => false',
'                    )',
'                )',
'        end;',
'        ',
'        l_value := l_column_value_list(l_value_column_no).value_list(1).number_value;',
'        if l_min_column_no is not null then',
'            l_min := l_column_value_list(l_min_column_no).value_list(1).number_value;',
'        end if;',
'        if l_max_column_no is not null then',
'            l_max := l_column_value_list(l_max_column_no).value_list(1).number_value;',
'        end if;',
'        ',
'        apex_plugin_util.clear_component_values;',
'    else',
'        --invalid number of rows',
'        null;',
'    end if;',
'',
'    -- Default value to 0.',
'    l_value := nvl(l_value, 0);',
'',
'    -- Default min value to 0.',
'    l_min := nvl(l_min, 0);',
'',
'    -- Default max value to the smallest power of 10 equal to or greater than the value, starting with 100.',
'    if l_max is null then',
'        l_max := 100;',
'        loop',
'            exit when l_max >= l_value;',
'            l_max := l_max * 10;',
'        end loop;',
'    end if;',
'',
'    -- Print the actual, max and min values',
'    sys.htp.prn (',
'        ''[{'' ||',
'            apex_javascript.add_attribute(''headingLink'',  l_heading_link) ||',
'            apex_javascript.add_attribute(''descriptionLink'',  l_description_link) ||',
'            apex_javascript.add_attribute(''value'',  l_value) ||',
'            apex_javascript.add_attribute(''min'',    l_min) ||',
'            apex_javascript.add_attribute(''max'',    l_max, false, false) ||',
'        ''}]'' );',
'',
'    return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render'
,p_ajax_function=>'ajax'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT'
,p_substitute_attributes=>false
,p_reference_id=>7534122046207970661.4651
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
,p_files_version=>7
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031071985297757557.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_default_value=>'VALUE'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column that contains the value to be represented on the gauge.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031072437850757557.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Min Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_default_value=>'MIN'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column containing the minimum value represented by the gauge. When the value is equal or lesser than the minimum, the gauge will be shown as completely empty empty. If left empty, the minimum value defaults to 0.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031072799163757557.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Max Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_default_value=>'MAX'
,p_column_data_types=>'NUMBER'
,p_is_translatable=>false
,p_help_text=>'The column containing the maximum value represented by the gauge. When the value is equal or greater than the minimum, the gauge will be shown as completely full. If left blank, the maximum value defaults to the lesser power of 10 greater than the va'
||'lue.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031073205357757557.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Show Labels'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2031073673020757558.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2031073205357757557.4651)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031074157630757558.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Title'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2031073205357757557.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The text for the label above the gauge.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031074550417757558.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Units'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2031073205357757557.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The text for the label immediately below the gauge value.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031074951412757558.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Value Prefix'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>2
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2031073205357757557.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The value label will be prefixed with this text.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031075307317757558.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Value Suffix'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>2
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(2031073205357757557.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'This text will be appended to the value label.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031075684418757559.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Show Min and Max Values'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2031081415026757562.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'GAUGE'
,p_lov_type=>'STATIC'
,p_help_text=>'Whether to the actual minimum and maximum values on the gauge.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2031076153702757560.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2031075684418757559.4651)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031076592665757560.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Show Shadow'
,p_attribute_type=>'CHECKBOXES'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Whether to render a shadow gradient on the gauge.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2031077046178757560.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2031076592665757560.4651)
,p_display_sequence=>10
,p_display_value=>' '
,p_return_value=>'Y'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031077573403757560.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Shadow Opacity'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_default_value=>'0.5'
,p_display_length=>5
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2031076592665757560.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The opacity of the shadow, measured between 0 and 1.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031077904400757560.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Shadow Offset'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'0'
,p_display_length=>5
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2031076592665757560.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
,p_help_text=>'The vertical offset of the shadow, in pixels.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031078309902757561.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Gauge Width Scale'
,p_attribute_type=>'NUMBER'
,p_is_required=>true
,p_default_value=>'1'
,p_display_length=>5
,p_max_length=>5
,p_is_translatable=>false
,p_help_text=>'The scale of the gauge''s width.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031078699004757561.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'GTR'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2031079144398757561.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2031078699004757561.4651)
,p_display_sequence=>10
,p_display_value=>'Dynamic Green-to-Red'
,p_return_value=>'GTR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2031079673229757562.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2031078699004757561.4651)
,p_display_sequence=>20
,p_display_value=>'Dynamic Red-to-Green'
,p_return_value=>'RTG'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2031080112037757562.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2031078699004757561.4651)
,p_display_sequence=>30
,p_display_value=>'Custom Color(s)'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031080621724757562.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>150
,p_prompt=>'Gauge Color(s)'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'#144485'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(2031078699004757561.4651)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'A comma-separated list of RGB colors to be used on the gauge. The first color will be used when the value is near the minimum and the last color will be used when the value is near the maximum. Leave only one color for a solid fill.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031081076761757562.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>160
,p_prompt=>'Empty Color'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'#d9d9d9'
,p_display_length=>10
,p_is_translatable=>false
,p_help_text=>'The color to be used on the ''empty'' sector of the gauge.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031081415026757562.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>1
,p_prompt=>'Gauge Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'GAUGE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Whether to render the gauge as a half circle or as a full circle.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2031081789155757563.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2031081415026757562.4651)
,p_display_sequence=>10
,p_display_value=>'Normal'
,p_return_value=>'GAUGE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2031082333543757563.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2031081415026757562.4651)
,p_display_sequence=>20
,p_display_value=>'Donut'
,p_return_value=>'DONUT'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031082820449757563.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>2
,p_prompt=>'Width'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The fixed width of the gauge, in pixels. Leave blank for automatic/responsive.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031083271981757563.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>3
,p_prompt=>'Height'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>5
,p_is_translatable=>false
,p_help_text=>'The fixed height of the gauge, in pixels. Leave blank for automatic/responsive.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031083593611757564.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>91
,p_prompt=>'Description'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'To be shown under the Gauge. You may use the following text replacements:',
'<ul>',
'<li>:MIN:</li>',
'<li>:MAX:</li>',
'<li>:VALUE:</li>',
'</ul>',
'Example:<br/>',
'The actual value is :VALUE: (out of :MAX:)'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031083995045757564.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>21
,p_display_sequence=>95
,p_prompt=>'Heading'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>20
,p_max_length=>200
,p_is_translatable=>true
,p_help_text=>'The heading is displayed directly above the description and is commonly set to the label for the chart.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031084397165757564.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>22
,p_display_sequence=>96
,p_prompt=>'Heading Link Target'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'A URL to which the user will be redirected when the heading gets clicked. This attribute supports substitution strings.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031084778476757564.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>23
,p_display_sequence=>92
,p_prompt=>'Description Link Target'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'A URL to which the user will be redirected when the description gets clicked. This attribute supports substitution strings.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2031085182572757565.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>24
,p_display_sequence=>240
,p_prompt=>'Decimals'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_default_value=>'0'
,p_display_length=>5
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(851664799225374647.4651)
,p_plugin_id=>wwv_flow_api.id(2367771717811580444.4651)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>1
,p_sql_max_column_count=>3
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_advanced_auto_complete
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2691525227710316053.4651)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM_ORACLE_APEX_ADVANCED_AUTO_COMPLETE'
,p_display_name=>unistr('Terminaci\00F3n Autom\00E1tica Avanzada')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM_ORACLE_APEX_ADVANCED_AUTO_COMPLETE'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_advanced_auto_complete'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_advanced_auto_complete'
,p_validation_function=>'wwv_flow_f4000_plugins.validate_advanced_auto_compl'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:READONLY:ESCAPE_OUTPUT:SOURCE:ELEMENT:WIDTH:ENCRYPT:LOV:CASCADING_LOV'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_help_text=>'<br />'
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2691534418734540516.4651)
,p_plugin_id=>wwv_flow_api.id(2691525227710316053.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Search'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'CONTAINS_IGNORE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'<p>Defines how the search with the entered value should be performed. When using &quot;Lazy Loading&quot; this setting can have an impact on query performance. Contains and/or Ignore Case will prevent the use of an existing index on the column.</p>'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2342584773353561555.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2691534418734540516.4651)
,p_display_sequence=>10
,p_display_value=>'Contains & Case Sensitive'
,p_return_value=>'CONTAINS_CASE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2342584865963561555.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2691534418734540516.4651)
,p_display_sequence=>20
,p_display_value=>'Exact & Case Sensitive'
,p_return_value=>'EXACT_CASE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2342584959400561555.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2691534418734540516.4651)
,p_display_sequence=>30
,p_display_value=>'Contains & Ignore Case'
,p_return_value=>'CONTAINS_IGNORE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2342585064891561556.4651)
,p_plugin_attribute_id=>wwv_flow_api.id(2691534418734540516.4651)
,p_display_sequence=>40
,p_display_value=>'Exact & Ignore Case'
,p_return_value=>'EXACT_IGNORE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2691535316095549256.4651)
,p_plugin_id=>wwv_flow_api.id(2691525227710316053.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Only Values from List'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_help_text=>'<p>If set to yes, the autocompleter will only allow to enter values which are returned by the SQL statement. Not existing values will result in an empty input box when leaving the field.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2691536100988554389.4651)
,p_plugin_id=>wwv_flow_api.id(2691525227710316053.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Separator for Multi-Selection'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>2
,p_max_length=>2
,p_is_translatable=>false
,p_help_text=>'<p>If defined, the textfield allows to select multiple values. The entered value will be used as a separator  between the values.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2691538313586567411.4651)
,p_plugin_id=>wwv_flow_api.id(2691525227710316053.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Lazy Loading'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_help_text=>'<p>If set to yes, the matching values will be read from the database each time the user types a character. If set to no, all values will be read only once when the page is rendered.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2691539328131571627.4651)
,p_plugin_id=>wwv_flow_api.id(2691525227710316053.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Maximum Values in List'
,p_attribute_type=>'NUMBER'
,p_is_required=>false
,p_display_length=>3
,p_max_length=>3
,p_is_translatable=>false
,p_help_text=>'<p>Limits the number of items in the select box to avoid performance problems by returning to many rows.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2691536714148558120.4651)
,p_plugin_id=>wwv_flow_api.id(2691525227710316053.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Automatic Fill'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_help_text=>'<p>Fill the textfield while still selecting a value, replacing the value if more is typed or something else is selected.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2691537603544564576.4651)
,p_plugin_id=>wwv_flow_api.id(2691525227710316053.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Select First'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'<p>If this is set, the first autocomplete value will be automatically selected on tab/return, even if it has not been handpicked by keyboard or mouse action. If there is a handpicked (highlighted) result, that result will take precedence.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2691539909215575615.4651)
,p_plugin_id=>wwv_flow_api.id(2691525227710316053.4651)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Highlight Search'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'<p>Defines if the entered value is highlighted in the select box of matching entries.</p>'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(851664953702374648.4651)
,p_plugin_id=>wwv_flow_api.id(2691525227710316053.4651)
,p_name=>'LOV'
,p_sql_min_column_count=>1
,p_sql_max_column_count=>2
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'<strong>Example 1: Display and store same value in page item</strong>',
'<pre>',
'SELECT ename FROM emp ORDER by 1',
'</pre>',
'</p>',
'',
'<p>',
'<strong>Example 2: Display ENAME but store EMPNO in page item</strong>',
'<pre>',
'SELECT ename d, empno r FROM emp ORDER BY 1',
'</pre>',
'</p>',
'',
'<p>',
'<b>Example 3: Display employees of a specific department by using a bind variable</b>',
'<pre>',
'SELECT ename FROM emp WHERE deptno = :P3_DEPTNO ORDER by 1',
'</pre>',
'</p>',
'',
'<p>',
'<b>Example 4: Static list examples</b>',
'<ul>',
'<li>STATIC:Cow,Dog,Cat,Lion (will be sorted alphabetically)</li>',
'<li>STATIC2:10,15,20,25,50,100,200,500,1000,10000 (sorted in order of creation)</li>',
'</ul>',
'</p>',
''))
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(11475107821842402.4651)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>'Escritorio'
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>3
,p_home_url=>'f?p=&APP_ID.:8012:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4651
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>unistr('P\00E1gina Global')
,p_step_title=>'0'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(394908475076949551.4651)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-team-dev'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(394908594122949551.4651)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(394908475076949551.4651)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(44351113134799252.4651)
,p_plug_name=>'APEX 5 - Tabs'
,p_region_name=>'a_Header_menu'
,p_parent_plug_id=>wwv_flow_api.id(394908594122949551.4651)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(6552444832780127.4651)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(394878284873890296.4651)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(394909071035949551.4651)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(394908594122949551.4651)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="''||apex_util.prepare_url(''f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::'')||''" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(394908817654949551.4651)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(394908475076949551.4651)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(394909456432949552.4651)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_api.id(394908817654949551.4651)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395026786198758463.4651)
,p_plug_name=>'APEX 5 - Administration Menu'
,p_region_name=>'adminMenu'
,p_parent_plug_id=>wwv_flow_api.id(394909456432949552.4651)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(704128726002003936.4651)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(394878606759890298.4651)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(493278321674841793.4651)
,p_plug_name=>'APEX 5 - Help Menu'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_api.id(394909456432949552.4651)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(704133729983005466.4651)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(394878606759890298.4651)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(394909624886949552.4651)
,p_plug_name=>'APEX 5 - Account'
,p_parent_plug_id=>wwv_flow_api.id(394908817654949551.4651)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395027587170767222.4651)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-team-dev'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>310
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395028410318768653.4651)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_api.id(395027587170767222.4651)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>320
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395030356752782532.4651)
,p_plug_name=>'APEX 5 - Breadcrumb'
,p_parent_plug_id=>wwv_flow_api.id(395028410318768653.4651)
,p_plug_display_sequence=>1
,p_plug_display_point=>'BODY'
,p_menu_id=>wwv_flow_api.id(6597377151972039.4651)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(394880309395892667.4651)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395028617538768653.4651)
,p_plug_name=>'APEX 5 - Control Bar Right'
,p_parent_plug_id=>wwv_flow_api.id(395027587170767222.4651)
,p_region_css_classes=>'a-ControlBar-col'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>330
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(240106685644619666.4651)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(394909456432949552.4651)
,p_button_name=>'SPOTLIGHT'
,p_button_static_id=>'header-spotlightSearch'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(395010959526687694.4651)
,p_button_image_alt=>unistr('B\00FAsqueda Spotlight')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-actionButton a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-search'
,p_button_cattributes=>'data-action="spotlight-search"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(391195356511472868.4651)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(394909456432949552.4651)
,p_button_name=>'ADMINISTRATION'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(395010736604687693.4651)
,p_button_image_alt=>unistr('Administraci\00F3n')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(391195420544472869.4651)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(394909456432949552.4651)
,p_button_name=>'FEEDBACK'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(395010959526687694.4651)
,p_button_image_alt=>'Comentarios'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
,p_required_patch=>wwv_flow_api.id(699952074310045895.4651)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(391195572456472870.4651)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(394909456432949552.4651)
,p_button_name=>'HELP'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(395010736604687693.4651)
,p_button_image_alt=>'Ayuda'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
end;
/
prompt --application/pages/page_08000
begin
wwv_flow_api.create_page(
 p_id=>8000.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>'Comentarios'
,p_step_title=>'Comentarios'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_javascript_file_urls=>'[require requirejs]#IMAGE_PREFIX#libraries/apex/widget.jetChart.js'
,p_step_template=>wwv_flow_api.id(643947460795988298.4651)
,p_help_text=>'td_fb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(183879507146779002.4651)
,p_plug_name=>unistr('iconos de navegaci\00F3n')
,p_region_name=>'apex-control-icons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(415202027252589471.4651)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(183873395194737719.4651)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(216948000482610776.4651)
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188229705449085384.4651)
,p_plug_name=>'Separadores de Comentarios'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(813554394221812426.4651)
,p_plug_display_sequence=>10
,p_plug_new_grid=>true
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(188228600364085362.4651)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(188948529125031038.4651)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(786390949359884461.4651)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(684869836739871122.4651)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P8000a */',
'    f.ID,',
'    USER_EMAIL email,',
'    nvl2(deployment_system, deployment_system||''-''||feedback_id, feedback_id) feedback_number,',
'    f.feedback_comment,',
'    f.feedback_type,',
'    f.feedback_rating,',
'    case f.feedback_rating',
'      when 1 then ''<span class="a-Icon icon-feedback-negative" aria-hidden="true" title="''|| ',
'                    wwv_flow_lang.system_message(''CA.NEGATIVE'') ||''"></span>'' ',
'      when 2 then ''<span class="a-Icon icon-feedback-neutral" aria-hidden="true" title="''|| ',
'                    wwv_flow_lang.system_message(''CA.NEUTRAL'') ||''"></span>'' ',
'      when 3 then ''<span class="a-Icon icon-feedback-positive" aria-hidden="true" title="''|| ',
'                    wwv_flow_lang.system_message(''CA.POSITIVE'') ||''"></span>'' ',
'      end feedback_rating_icon,',
'    f.feedback_status,',
'    f.tags,',
'    f.developer_comment,',
'    f.public_response,',
'    f.APPLICATION_ID,',
'    f.APPLICATION_NAME,',
'    f.PAGE_ID,',
'    f.PAGE_NAME,',
'    f.PAGE_LAST_UPDATED_BY,',
'    f.PAGE_LAST_UPDATED_ON,',
'    f.SESSION_ID,',
'    lower(f.APEX_USER) apex_user,',
'    f.APPLICATION_VERSION,',
'    f.SESSION_STATE,',
'    f.PARSING_SCHEMA,',
'    f.deployment_system,',
'    f.HTTP_USER_AGENT,',
'    f.REMOTE_ADDR,',
'    f.REMOTE_USER,',
'    f.HTTP_HOST,',
'    f.SERVER_NAME,',
'    f.SERVER_PORT,',
'    --',
'    lower(f.CREATED_BY) created_by,',
'    f.CREATED_ON,',
'    to_char(f.CREATED_ON,''YYYYMMDD'') created_on_YYYYMMDD,',
'    case',
'    when f.CREATED_ON > (localtimestamp - 1) then',
'        ''Y''',
'    else',
'        ''N''',
'    end created_today_yn,',
'    case',
'    when f.CREATED_ON > (localtimestamp - 7) then',
'        ''Y''',
'    else',
'        ''N''',
'    end created_this_week_yn,',
'    lower(f.UPDATED_BY) updated_by,',
'    f.UPDATED_ON,',
'   --',
'   replace(replace(ltrim(substr(HTTP_USER_AGENT,',
'   instr(HTTP_USER_AGENT,''('',1),',
'   instr(HTTP_USER_AGENT,'')'',1) - instr(HTTP_USER_AGENT,''('',1)',
'   ),'' (''),''Windows; U; Windows'',''Windows''),''Macintosh; U; Intel Mac'',''Macintosh; Intel'') OS,',
'   --',
'   case',
'   when instr(HTTP_USER_AGENT,'' Safari/'') > 0 and instr(HTTP_USER_AGENT,'' Version/'') > 0 then',
'         substr(',
'              substr (HTTP_USER_AGENT, instr(HTTP_USER_AGENT,'')'',1) + 1 ) ,',
'              instr(substr (HTTP_USER_AGENT, instr(HTTP_USER_AGENT,'')'',1) + 1 ),'' Version/''))',
'   when instr(HTTP_USER_AGENT,'' Firefox/'') > 0 and instr(HTTP_USER_AGENT,'' Gecko/'') > 0 then',
'         substr(',
'              substr (HTTP_USER_AGENT, instr(HTTP_USER_AGENT,'')'',1) + 1 ) ,',
'              instr(substr (HTTP_USER_AGENT, instr(HTTP_USER_AGENT,'')'',1) + 1 ),'' Firefox/''))',
'     when instr(http_user_agent,''MSIE 6.0;'') > 0 then',
'              ''MSIE 6.0''',
'     when instr(http_user_agent,''MSIE 7.0;'') > 0 then',
'              ''MSIE 7.0''',
'     when instr(http_user_agent,''MSIE 8.0;'') > 0 then',
'              ''MSIE 8.0''',
'     else',
'         substr (HTTP_USER_AGENT, instr(HTTP_USER_AGENT,'')'',1) + 1 ) ',
'     end  Browser,',
'    (select count(*) from wwv_flow_feedback_followup where feedback_id = f.id) followups,',
'    attribute_01,',
'    attribute_02,',
'    attribute_03,',
'    attribute_04,',
'    attribute_05,',
'    attribute_06,',
'    attribute_07,',
'    attribute_08,',
'    label_01,',
'    label_02,',
'    label_03,',
'    label_04,',
'    label_05,',
'    label_06,',
'    label_07,',
'    label_08',
'from WWV_FLOW_FEEDBACK f',
'where f.security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IG'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>11
,p_prn_height=>8.5
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(648830527108355777.4651)
,p_name=>'FEEDBACK_RATING'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'FEEDBACK_RATING'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('Puntuaci\00F3n de calificaci\00F3n')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>80
,p_value_alignment=>'CENTER'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>true
,p_escape_on_http_output=>true
,p_column_comment=>'<span class="fa #FEEDBACK_RATING_ICON#" aria-hidden="true" title="#FEEDBACK_RATING#"></span>'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(648830847622355780.4651)
,p_name=>'FEEDBACK_RATING_ICON'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'FEEDBACK_RATING_ICON'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('Calificaci\00F3n')
,p_heading_alignment=>'CENTER'
,p_display_sequence=>90
,p_value_alignment=>'CENTER'
,p_attribute_02=>'VALUE'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786391081625884463.4651)
,p_name=>'ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>30
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786391239547884464.4651)
,p_name=>'EMAIL'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'EMAIL'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>40
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786391303803884465.4651)
,p_name=>'FEEDBACK_NUMBER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'FEEDBACK_NUMBER'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('N\00FAmero')
,p_heading_alignment=>'CENTER'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_link_target=>'f?p=&APP_ID.:8001:&SESSION.::&DEBUG.:8001:P8001_ID:&ID.'
,p_link_text=>'&FEEDBACK_NUMBER.'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786391462196884466.4651)
,p_name=>'FEEDBACK_COMMENT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'FEEDBACK_COMMENT'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Comentarios'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786391529279884467.4651)
,p_name=>'FEEDBACK_TYPE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'FEEDBACK_TYPE'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_SELECT_LIST'
,p_heading=>'Tipo'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_is_required=>false
,p_lov_type=>'SQL_QUERY'
,p_lov_source=>'select the_name, id from WWV_FLOW_FEEDBACK_TYPES'
,p_lov_display_extra=>true
,p_lov_display_null=>true
,p_lov_null_text=>'- seleccionar tipo - '
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786391714557884469.4651)
,p_name=>'FEEDBACK_STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'FEEDBACK_STATUS'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_SELECT_LIST'
,p_heading=>'Estado'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>100
,p_value_alignment=>'LEFT'
,p_is_required=>false
,p_lov_type=>'SHARED'
,p_lov_id=>wwv_flow_api.id(188485712678162256)
,p_lov_display_extra=>true
,p_lov_display_null=>true
,p_lov_null_text=>'- seleccionar estado - '
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786392005177884472.4651)
,p_name=>'TAGS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TAGS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Etiquetas'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>110
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786392267442884474.4651)
,p_name=>'DEVELOPER_COMMENT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DEVELOPER_COMMENT'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Comentario del desarrollador'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>120
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786392575396884477.4651)
,p_name=>'PUBLIC_RESPONSE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PUBLIC_RESPONSE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>unistr('Respuesta P\00FAblica')
,p_heading_alignment=>'CENTER'
,p_display_sequence=>130
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786392634730884478.4651)
,p_name=>'APPLICATION_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'APPLICATION_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('Aplicaci\00F3n')
,p_heading_alignment=>'CENTER'
,p_display_sequence=>140
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786392736377884479.4651)
,p_name=>'APPLICATION_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'APPLICATION_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>150
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786392840095884480.4651)
,p_name=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PAGE_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>unistr('P\00E1gina')
,p_heading_alignment=>'CENTER'
,p_display_sequence=>160
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786392948020884481.4651)
,p_name=>'PAGE_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PAGE_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>170
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393046058884482.4651)
,p_name=>'PAGE_LAST_UPDATED_BY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PAGE_LAST_UPDATED_BY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>180
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393080350884483.4651)
,p_name=>'PAGE_LAST_UPDATED_ON'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PAGE_LAST_UPDATED_ON'
,p_data_type=>'DATE'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>190
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393234214884484.4651)
,p_name=>'SESSION_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SESSION_ID'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>200
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393374178884485.4651)
,p_name=>'APEX_USER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'APEX_USER'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Archivado por'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>210
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393475816884486.4651)
,p_name=>'APPLICATION_VERSION'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'APPLICATION_VERSION'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>220
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393518532884487.4651)
,p_name=>'SESSION_STATE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SESSION_STATE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>230
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393622015884488.4651)
,p_name=>'PARSING_SCHEMA'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARSING_SCHEMA'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>240
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393700675884489.4651)
,p_name=>'DEPLOYMENT_SYSTEM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DEPLOYMENT_SYSTEM'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>250
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393790483884490.4651)
,p_name=>'HTTP_USER_AGENT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'HTTP_USER_AGENT'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>260
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393887236884491.4651)
,p_name=>'REMOTE_ADDR'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'REMOTE_ADDR'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>270
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786393982023884492.4651)
,p_name=>'REMOTE_USER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'REMOTE_USER'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>280
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786394161216884493.4651)
,p_name=>'HTTP_HOST'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'HTTP_HOST'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>290
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786394228378884494.4651)
,p_name=>'SERVER_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SERVER_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>300
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786394295712884495.4651)
,p_name=>'SERVER_PORT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SERVER_PORT'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>310
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786394445914884496.4651)
,p_name=>'CREATED_BY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_BY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>330
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786394539782884497.4651)
,p_name=>'CREATED_ON'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_ON'
,p_data_type=>'TIMESTAMP_TZ'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Creado'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>340
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_format_mask=>'SINCE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786394674246884498.4651)
,p_name=>'CREATED_ON_YYYYMMDD'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_ON_YYYYMMDD'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>350
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786394738235884499.4651)
,p_name=>'CREATED_TODAY_YN'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_TODAY_YN'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>360
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786394805236884500.4651)
,p_name=>'CREATED_THIS_WEEK_YN'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_THIS_WEEK_YN'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>370
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786394951870884501.4651)
,p_name=>'UPDATED_BY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'UPDATED_BY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>380
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786394987929884502.4651)
,p_name=>'UPDATED_ON'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'UPDATED_ON'
,p_data_type=>'TIMESTAMP_TZ'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Actualizado'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>390
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_format_mask=>'SINCE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786395158032884503.4651)
,p_name=>'OS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'OS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>400
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786395202835884504.4651)
,p_name=>'BROWSER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'BROWSER'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>410
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786395348622884505.4651)
,p_name=>'FOLLOWUPS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'FOLLOWUPS'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Seguimientos'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>320
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786395444873884506.4651)
,p_name=>'ATTRIBUTE_01'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ATTRIBUTE_01'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>420
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786395525667884507.4651)
,p_name=>'ATTRIBUTE_02'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ATTRIBUTE_02'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>430
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786395584388884508.4651)
,p_name=>'ATTRIBUTE_03'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ATTRIBUTE_03'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>440
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786395697333884509.4651)
,p_name=>'ATTRIBUTE_04'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ATTRIBUTE_04'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>450
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786395823540884510.4651)
,p_name=>'ATTRIBUTE_05'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ATTRIBUTE_05'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>460
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786396378173888161.4651)
,p_name=>'ATTRIBUTE_06'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ATTRIBUTE_06'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>470
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
end;
/
begin
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786396410566888162.4651)
,p_name=>'ATTRIBUTE_07'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ATTRIBUTE_07'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>480
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786396572247888163.4651)
,p_name=>'ATTRIBUTE_08'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ATTRIBUTE_08'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>490
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786396646624888164.4651)
,p_name=>'LABEL_01'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_01'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>500
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786396721524888165.4651)
,p_name=>'LABEL_02'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_02'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>510
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786396815378888166.4651)
,p_name=>'LABEL_03'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_03'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>520
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786396913466888167.4651)
,p_name=>'LABEL_04'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_04'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>530
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786396981156888168.4651)
,p_name=>'LABEL_05'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_05'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>540
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786397155151888169.4651)
,p_name=>'LABEL_06'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_06'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>550
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786397240598888170.4651)
,p_name=>'LABEL_07'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_07'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>560
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786397335789888171.4651)
,p_name=>'LABEL_08'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_08'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>570
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786397469953888172.4651)
,p_name=>'APEX$ROW_ACTION'
,p_item_type=>'NATIVE_ROW_ACTION'
,p_label=>'Acciones'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>20
,p_value_alignment=>'CENTER'
,p_enable_hide=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(786397563724888173.4651)
,p_name=>'APEX$ROW_SELECTOR'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_enable_hide=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(786390987270884462.4651)
,p_internal_uid=>779885008895344402
,p_is_editable=>true
,p_edit_operations=>'u:d'
,p_lost_update_check_type=>'VALUES'
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_max_row_count=>100000
,p_show_nulls_as=>'-'
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>true
,p_show_toolbar=>true
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>true
,p_define_chart_view=>true
,p_enable_download=>true
,p_download_formats=>'CSV:HTML:XLS:PDF:RTF'
,p_enable_mail_download=>true
,p_fixed_header=>'PAGE'
,p_show_icon_view=>false
,p_show_detail_view=>false
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(188148712767209171.4651)
,p_branch_action=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(188148919347211016.4651)
,p_computation_sequence=>10
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'8000'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(796740903850267464.4651)
,p_name=>'Refresh'
,p_event_sequence=>20
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(786390949359884461.4651)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(796741074661267465.4651)
,p_event_id=>wwv_flow_api.id(796740903850267464.4651)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(786390949359884461.4651)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(786397662560888174.4651)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_api.id(786390949359884461.4651)
,p_process_type=>'NATIVE_IG_DML'
,p_process_name=>'Feedback - Save Interactive Grid Data'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_08001
begin
wwv_flow_api.create_page(
 p_id=>8001.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>'Ver/Editar Comentarios'
,p_page_mode=>'MODAL'
,p_step_title=>'Ver/Editar Comentarios'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'//-->',
'</script>'))
,p_step_template=>wwv_flow_api.id(700758032440987611.4651)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'600'
,p_dialog_width=>'980'
,p_dialog_attributes=>'resizable:true'
,p_protection_level=>'C'
,p_help_text=>'td_fb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(52802303312219147.4651)
,p_plug_name=>unistr('Selector de Visualizaci\00F3n de Regi\00F3n')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(62139511251715892.4651)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188159097794270530.4651)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188167088881277892.4651)
,p_plug_name=>'Detalles de comentarios'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(697044757239351357.4651)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188167711045284350.4651)
,p_plug_name=>'Entorno'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188167920049286931.4651)
,p_plug_name=>unistr('Contexto de Aplicaci\00F3n')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188168202518291361.4651)
,p_plug_name=>'Registro de hora'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>100
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188172406636339828.4651)
,p_plug_name=>unistr('Estado de la Sesi\00F3n')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(189568612980104568.4651)
,p_plug_name=>unistr('Disposici\00F3n')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(208469999102865510.4651)
,p_plug_name=>'Atributos Adicionales'
,p_region_css_classes=>'a-Form--floatColsLeft'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(441741688554040550.4651)
,p_name=>'Seguimiento'
,p_region_name=>'abc'
,p_template=>wwv_flow_api.id(394867304186881833.4651)
,p_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--horizontalBorders:a-Report--stretch:a-Report--rowHighlight'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id,',
'       replace(',
'           wwv_flow_escape.html_trunc(follow_up, 4000),',
'           chr(10),',
'           ''<br>'') as follow_up,',
'       created_on,',
'       lower(created_by) as created_by',
'  from wwv_flow_feedback_followup',
' where feedback_id = :P8001_ID',
' order by created_on desc'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(703372107153632568.4651)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>25
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(441742000838040564.4651)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=&APP_ID.:8014:&SESSION.::&DEBUG.:8014:P8014_ID:#ID#'
,p_column_linktext=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="Editar">'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(441742110535040566.4651)
,p_query_column_id=>2
,p_column_alias=>'FOLLOW_UP'
,p_column_display_sequence=>2
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(441742209509040566.4651)
,p_query_column_id=>3
,p_column_alias=>'CREATED_ON'
,p_column_display_sequence=>3
,p_column_format=>'SINCE'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(441742286382040566.4651)
,p_query_column_id=>4
,p_column_alias=>'CREATED_BY'
,p_column_display_sequence=>4
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(188159592358270532.4651)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(188167088881277892.4651)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_execute_validations=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(188159408440270532.4651)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(188167088881277892.4651)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_condition=>'P8001_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(188159316393270532.4651)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(188167088881277892.4651)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P8001_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(189561298491854461.4651)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_button_name=>'APPLY_CHANGES_LOG_AS_BUG'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Registrar como Bug'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P8001_BUG_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(189561517191859848.4651)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_button_name=>'APPLY_CHANGES_LOG_AS_TODO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Registrar como Tarea'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P8001_TASK_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(189562107972866659.4651)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_button_name=>'APPLY_CHANGES_LOG_AS_FEATURE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>unistr('Registrar como Funci\00F3n')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P8001_FEATURE_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6446290793807319.4651)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_button_name=>'APPLY_CHANGES_LOG_AS_ISSUE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Registrar como problema'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P8001_ISSUE_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(833256255833925567.4651)
,p_branch_name=>'Log as Bug'
,p_branch_action=>'f?p=&APP_ID.:8002:&SESSION.::&DEBUG.:RP,8002:P8002_ID:&P8001_ID.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(189561298491854461.4651)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(833256430546925569.4651)
,p_branch_name=>'Log as Feature'
,p_branch_action=>'f?p=&APP_ID.:8003:&SESSION.::&DEBUG.:RP,8003:P8003_ID:&P8001_ID.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(189562107972866659.4651)
,p_branch_sequence=>20
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(598394689578929771.4651)
,p_branch_name=>'Log as To Do'
,p_branch_action=>'f?p=&APP_ID.:8006:&SESSION.::&DEBUG.:RP,8006:P8006_ID:&P8001_ID.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(189561517191859848.4651)
,p_branch_sequence=>30
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(156403182605150734.4651)
,p_branch_name=>'Log as Issue'
,p_branch_action=>'f?p=&APP_ID.:8004:&SESSION.::&DEBUG.:RP,8004:P8004_ID:&P8001_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(6446290793807319.4651)
,p_branch_sequence=>40
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(156403524363150738.4651)
,p_name=>'P8001_ISSUE_ID'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Registrado como problema'
,p_source=>'ISSUE_ID'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>'wwv_flow_team.get_feedback_logged_as_info (p_id=>:P8001_ISSUE_ID,p_type=>''ISSUE'')'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_ISSUE_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Funci\00F3n que se cre\00F3 bas\00E1ndose en esta entrada de comentarios, si procede.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188160313626270538.4651)
,p_name=>'P8001_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188160518810270538.4651)
,p_name=>'P8001_FEEDBACK_COMMENT'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios Proporcionados por el Usuario:'
,p_source=>'FEEDBACK_COMMENT'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cHeight=>8
,p_tag_attributes=>'readonly'
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>'Comentarios proporcionados por el usuario'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188160891682270539.4651)
,p_name=>'P8001_FEEDBACK_TYPE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tipo:'
,p_source=>'FEEDBACK_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FEEDBACK TYPE'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select the_name, id ',
'from WWV_FLOW_FEEDBACK_TYPES',
'order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- seleccionar tipo - '
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950978277259098.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188161107343270540.4651)
,p_name=>'P8001_APPLICATION_ID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'APPLICATION_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Aplicaci\00F3n sobre la que se proporcionaron los comentarios.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188161303385270540.4651)
,p_name=>'P8001_APPLICATION_NAME'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'APPLICATION_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188161501862270540.4651)
,p_name=>'P8001_PAGE_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('P\00E1gina de la aplicaci\00F3n sobre la que se proporcionaron los comentarios.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188161699990270540.4651)
,p_name=>'P8001_PAGE_NAME'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'PAGE_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188161910335270541.4651)
,p_name=>'P8001_PAGE_LAST_UPDATED_BY'
,p_item_sequence=>400
,p_item_plug_id=>wwv_flow_api.id(188167920049286931.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('P\00E1gina Actualizada por:')
,p_source=>'PAGE_LAST_UPDATED_BY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Desarrollador que actualiz\00F3 por \00FAltima vez la p\00E1gina de referencia.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188162088570270541.4651)
,p_name=>'P8001_PAGE_LAST_UPDATED_ON'
,p_item_sequence=>410
,p_item_plug_id=>wwv_flow_api.id(188167920049286931.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('P\00E1gina Actualizada:')
,p_source=>'PAGE_LAST_UPDATED_ON'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Fecha de \00FAltima actualizaci\00F3n de la p\00E1gina de referencia.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188162312580270541.4651)
,p_name=>'P8001_SESSION_ID'
,p_item_sequence=>420
,p_item_plug_id=>wwv_flow_api.id(188167920049286931.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Sesi\00F3n:')
,p_source=>'SESSION_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Identificador de la sesi\00F3n al crear los comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188162519115270542.4651)
,p_name=>'P8001_APEX_USER'
,p_item_sequence=>430
,p_item_plug_id=>wwv_flow_api.id(188167920049286931.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Usuario de aplicaci\00F3n:')
,p_source=>'APEX_USER'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>'Nombre del usuario que proporciona los comentarios.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188162716849270542.4651)
,p_name=>'P8001_APPLICATION_VERSION'
,p_item_sequence=>440
,p_item_plug_id=>wwv_flow_api.id(188167920049286931.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Versi\00F3n de la Aplicaci\00F3n:')
,p_source=>'APPLICATION_VERSION'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Versi\00F3n de la aplicaci\00F3n asociada.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188162917810270542.4651)
,p_name=>'P8001_SESSION_STATE'
,p_item_sequence=>530
,p_item_plug_id=>wwv_flow_api.id(188172406636339828.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Estado de la Sesi\00F3n:')
,p_pre_element_text=>'<pre>'
,p_post_element_text=>'</pre>'
,p_source=>'SESSION_STATE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_css_classes=>'a-Form-fieldContainer--largeDisplayOnlyText'
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Estado de la sesi\00F3n al crear los comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188163119374270542.4651)
,p_name=>'P8001_PARSING_SCHEMA'
,p_item_sequence=>450
,p_item_plug_id=>wwv_flow_api.id(188167920049286931.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Esquema de An\00E1lisis:')
,p_source=>'PARSING_SCHEMA'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Esquema de an\00E1lisis de la aplicaci\00F3n al crear los comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188163317405270543.4651)
,p_name=>'P8001_HTTP_USER_AGENT'
,p_item_sequence=>460
,p_item_plug_id=>wwv_flow_api.id(188167711045284350.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Agente de Usuario de HTTP:'
,p_source=>'HTTP_USER_AGENT'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Agente de usuario de HTTP en el que se proporcionaron los comentarios (puede ser distinto al de la revisi\00F3n de los comentarios).')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188163508924270543.4651)
,p_name=>'P8001_REMOTE_ADDR'
,p_item_sequence=>470
,p_item_plug_id=>wwv_flow_api.id(188167711045284350.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Direcci\00F3n Remota:')
,p_source=>'REMOTE_ADDR'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Direcci\00F3n remota en la que se proporcionaron los comentarios (puede ser distinta a la de la revisi\00F3n de los comentarios).')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188163714101270543.4651)
,p_name=>'P8001_REMOTE_USER'
,p_item_sequence=>480
,p_item_plug_id=>wwv_flow_api.id(188167711045284350.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Usuario Remoto:'
,p_source=>'REMOTE_USER'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>'Usuario remoto en el que se proporcionaron los comentarios.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188163909298270543.4651)
,p_name=>'P8001_HTTP_HOST'
,p_item_sequence=>490
,p_item_plug_id=>wwv_flow_api.id(188167711045284350.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Host HTTP:'
,p_source=>'HTTP_HOST'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Host HTTP en el que se proporcionaron los comentarios (puede ser distinto al de la revisi\00F3n de los comentarios).')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188164113713270544.4651)
,p_name=>'P8001_SERVER_NAME'
,p_item_sequence=>500
,p_item_plug_id=>wwv_flow_api.id(188167711045284350.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nombre del Servidor:'
,p_source=>'SERVER_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Nombre del servidor en el que se proporcionaron los comentarios (puede ser distinto al de la revisi\00F3n de los comentarios).')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188164306557270544.4651)
,p_name=>'P8001_SERVER_PORT'
,p_item_sequence=>510
,p_item_plug_id=>wwv_flow_api.id(188167711045284350.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Puerto del Servidor:'
,p_source=>'SERVER_PORT'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Puerto del servidor en el que se proporcionaron los comentarios (puede ser distinto al de la revisi\00F3n de los comentarios).')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188164499938270544.4651)
,p_name=>'P8001_CREATED_BY'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Usuario:'
,p_pre_element_text=>' '
,p_source=>'CREATED_BY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188165503258270545.4651)
,p_name=>'P8001_UPDATED_ON'
,p_item_sequence=>540
,p_item_plug_id=>wwv_flow_api.id(188168202518291361.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Actualizado el:'
,p_format_mask=>'fmDay, DD Month, YYYY fmHH24:MI'
,p_source=>'UPDATED_ON'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Fecha de \00FAltima actualizaci\00F3n de los comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188182117727418652.4651)
,p_name=>'P8001_FEEDBACK_STATUS'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_use_cache_before_default=>'NO'
,p_item_default=>'0'
,p_prompt=>'Estado'
,p_source=>'FEEDBACK_STATUS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FEEDBACK STATUS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name the_name, id ',
'from wwv_flow_feedback_status ',
'order by 2'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Estado de los comentarios seg\00FAn la asignaci\00F3n de los desarrolladores revisores.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188189308995510758.4651)
,p_name=>'P8001_UPDATED_BY'
,p_item_sequence=>550
,p_item_plug_id=>wwv_flow_api.id(188168202518291361.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Actualizado por:'
,p_source=>'UPDATED_BY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Desarrollador que actualiz\00F3 por \00FAltima vez los comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188189520076513942.4651)
,p_name=>'P8001_CREATED_ON'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Creado:'
,p_format_mask=>'SINCE'
,p_source=>'CREATED_ON'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188192389264580763.4651)
,p_name=>'P8001_SESSION_INFO'
,p_item_sequence=>520
,p_item_plug_id=>wwv_flow_api.id(188172406636339828.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Informaci\00F3n de Cabecera de Sesi\00F3n:')
,p_source=>'SESSION_INFO'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Informaci\00F3n de sesi\00F3n recopilada al proporcionar los comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188498293509572948.4651)
,p_name=>'P8001_DEVELOPER_COMMENT'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentario del desarrollador'
,p_source=>'DEVELOPER_COMMENT'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('Los comentarios del desarrollador aumentan los comentarios suministrados por el usuario y no pueden verse p\00FAblicamente.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(189567615488086436.4651)
,p_name=>'P8001_BUG_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Registrado como Bug'
,p_source=>'BUG_ID'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team.get_feedback_logged_as_info (',
'    p_id     => :P8001_BUG_ID,',
'    p_type => ''BUG''',
'    );'))
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_BUG_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Bug que se cre\00F3 bas\00E1ndose en esta entrada de comentarios, si procede.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(189567800728091570.4651)
,p_name=>'P8001_TASK_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Registrado como Tarea'
,p_source=>'TASK_ID'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team.get_feedback_logged_as_info (',
'    p_id     =>  :P8001_TASK_ID,',
'    p_type => ''TODO''',
'    );'))
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_TASK_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Entrada de la tarea que se cre\00F3 bas\00E1ndose en este comentario, si procede.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(189568413888095466.4651)
,p_name=>'P8001_FEATURE_ID'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Registrado como Funci\00F3n')
,p_source=>'FEATURE_ID'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team.get_feedback_logged_as_info (',
'    p_id     =>  :P8001_FEATURE_ID,',
'    p_type => ''FEATURE''',
'    );'))
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_FEATURE_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Funci\00F3n que se cre\00F3 bas\00E1ndose en esta entrada de comentarios, si procede.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(208474578586878506.4651)
,p_name=>'P8001_ATTRIBUTE_01'
,p_item_sequence=>250
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'ATTRIBUTE_01'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(208475305036895604.4651)
,p_name=>'P8001_ATTRIBUTE_02'
,p_item_sequence=>270
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'ATTRIBUTE_02'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_display_when=>'P8001_ATTRIBUTE_02'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(208475478848897532.4651)
,p_name=>'P8001_ATTRIBUTE_03'
,p_item_sequence=>290
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'ATTRIBUTE_03'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_display_when=>'P8001_ATTRIBUTE_03'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(208475688891900409.4651)
,p_name=>'P8001_ATTRIBUTE_04'
,p_item_sequence=>310
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'ATTRIBUTE_04'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_display_when=>'P8001_ATTRIBUTE_04'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(208475897549902937.4651)
,p_name=>'P8001_ATTRIBUTE_05'
,p_item_sequence=>330
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'ATTRIBUTE_05'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_display_when=>'P8001_ATTRIBUTE_05'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(208476101358904028.4651)
,p_name=>'P8001_ATTRIBUTE_06'
,p_item_sequence=>350
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'ATTRIBUTE_06'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_display_when=>'P8001_ATTRIBUTE_06'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(208476405167905160.4651)
,p_name=>'P8001_ATTRIBUTE_07'
,p_item_sequence=>370
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'ATTRIBUTE_07'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_display_when=>'P8001_ATTRIBUTE_07'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(208476610016906588.4651)
,p_name=>'P8001_ATTRIBUTE_08'
,p_item_sequence=>390
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'ATTRIBUTE_08'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_display_when=>'P8001_ATTRIBUTE_08'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(210204482275456228.4651)
,p_name=>'P8001_USER_EMAIL'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Correo electr\00F3nico:')
,p_pre_element_text=>'<a href="mailto:&P8001_USER_EMAIL.?subject=En respuesta a sus comentarios #&P8001_FEEDBACK_NUMBER.&body=&P8001_PUBLIC_RESPONSE.">'
,p_post_element_text=>'</a>'
,p_source=>'USER_EMAIL'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(299750702299378231.4651)
,p_name=>'P8001_PUBLIC_RESPONSE'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Respuesta P\00FAblica')
,p_source=>'PUBLIC_RESPONSE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('Respuesta que se puede ver p\00FAblicamente.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(299754794297423312.4651)
,p_name=>'P8001_LABEL_01'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'LABEL_01'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>':P8001_LABEL_01 || '':'''
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_css_classes=>'a-Form-fieldContainer--valueAsLabel'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(299755491096441310.4651)
,p_name=>'P8001_LABEL_02'
,p_item_sequence=>260
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'LABEL_02'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>':P8001_LABEL_02 || '':'''
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_LABEL_02'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_css_classes=>'a-Form-fieldContainer--valueAsLabel'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(299755902178444505.4651)
,p_name=>'P8001_LABEL_03'
,p_item_sequence=>280
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'LABEL_03'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>':P8001_LABEL_03 || '':'''
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_LABEL_03'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_css_classes=>'a-Form-fieldContainer--valueAsLabel'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(299756288803450056.4651)
,p_name=>'P8001_LABEL_04'
,p_item_sequence=>300
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'LABEL_04'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>':P8001_LABEL_04 || '':'''
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_LABEL_04'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_css_classes=>'a-Form-fieldContainer--valueAsLabel'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(299756599884453304.4651)
,p_name=>'P8001_LABEL_05'
,p_item_sequence=>320
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'LABEL_05'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>':P8001_LABEL_05 || '':'''
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_LABEL_05'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_css_classes=>'a-Form-fieldContainer--valueAsLabel'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(299756909927456148.4651)
,p_name=>'P8001_LABEL_06'
,p_item_sequence=>340
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'LABEL_06'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>':P8001_LABEL_06 || '':'''
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_LABEL_06'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_css_classes=>'a-Form-fieldContainer--valueAsLabel'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(299757186856458951.4651)
,p_name=>'P8001_LABEL_07'
,p_item_sequence=>360
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'LABEL_07'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>':P8001_LABEL_07 || '':'''
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_LABEL_07'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_css_classes=>'a-Form-fieldContainer--valueAsLabel'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(299757505556464405.4651)
,p_name=>'P8001_LABEL_08'
,p_item_sequence=>380
,p_item_plug_id=>wwv_flow_api.id(208469999102865510.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'LABEL_08'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>':P8001_LABEL_08 || '':'''
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P8001_LABEL_08'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(694416725694263392.4651)
,p_item_css_classes=>'a-Form-fieldContainer--valueAsLabel'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(299758186210487165.4651)
,p_name=>'P8001_TAGS'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(189568612980104568.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Etiquetas'
,p_source=>'TAGS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct tag as d',
'  from wwv_flow_team_tags',
' where security_group_id = to_number(:WORKSPACE_ID)',
' order by 1'))
,p_lov_display_null=>'YES'
,p_cSize=>60
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>'Las etiquetas son palabras clave que describen estos comentarios. Separe las distintas etiquetas con comas. Las etiquetas se muestran en una columna independiente en la vista de informe.'
,p_attribute_01=>'POPUP'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_03=>'Y'
,p_attribute_04=>'Y'
,p_attribute_05=>'Y'
,p_attribute_06=>'0'
,p_attribute_11=>','
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(436386503779193988.4651)
,p_name=>'P8001_FEEDBACK_NUMBER'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('N\00FAmero:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'case when :P8001_DEPLOYMENT_SYSTEM is not null then :P8001_DEPLOYMENT_SYSTEM||''-'' end||',
':P8001_FEEDBACK_ID'))
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(441743007170064809.4651)
,p_name=>'P8001_FOLLOW_UP'
,p_item_sequence=>230
,p_item_plug_id=>wwv_flow_api.id(441741688554040550.4651)
,p_prompt=>'Introducir nuevo seguimiento:'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>'Nuevos comentarios de seguimiento.'
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(479251886768025308.4651)
,p_name=>'P8001_DEPLOYMENT_SYSTEM'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'DEPLOYMENT_SYSTEM'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(479252702352029777.4651)
,p_name=>'P8001_FEEDBACK_ID'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'FEEDBACK_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(648831064414355782.4651)
,p_name=>'P8001_FEEDBACK_RATING'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Calificaci\00F3n:')
,p_source=>'FEEDBACK_RATING'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'case :P8001_FEEDBACK_RATING',
'  when 1 then ''<span class="a-Icon icon-feedback-negative" aria-hidden="true" title="''|| ',
'                wwv_flow_lang.system_message(''CA.NEGATIVE'') ||''"></span>'' ',
'  when 2 then ''<span class="a-Icon icon-feedback-neutral" aria-hidden="true" title="''|| ',
'                wwv_flow_lang.system_message(''CA.NEUTRAL'') ||''"></span>'' ',
'  when 3 then ''<span class="a-Icon icon-feedback-positive" aria-hidden="true" title="''|| ',
'                wwv_flow_lang.system_message(''CA.POSITIVE'') ||''"></span>'' ',
'end'))
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(796741107538267466.4651)
,p_name=>'P8001_APPLICATION_DISPLAY'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_prompt=>unistr('Aplicaci\00F3n:')
,p_source=>':P8001_APPLICATION_ID || '' - '' || :P8001_APPLICATION_NAME'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(796741180037267467.4651)
,p_name=>'P8001_PAGE_NAME_DISPLAY'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(188159097794270530.4651)
,p_prompt=>unistr('P\00E1gina')
,p_source=>':P8001_PAGE_ID || '' - '' || :P8001_PAGE_NAME'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(705088135329070564.4651)
,p_name=>'Log as Bug Dialog Close'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(189561298491854461.4651)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(705088227583070565.4651)
,p_event_id=>wwv_flow_api.id(705088135329070564.4651)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'location.reload();'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(705164260990547330.4651)
,p_name=>'Log as To Do Dialog Close'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(189561517191859848.4651)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(705164514812547352.4651)
,p_event_id=>wwv_flow_api.id(705164260990547330.4651)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'location.reload();'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(796740607232267461.4651)
,p_name=>'Cancel Dialog'
,p_event_sequence=>30
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(188159592358270532.4651)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(796740702919267462.4651)
,p_event_id=>wwv_flow_api.id(796740607232267461.4651)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(188165817323270546.4651)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_FEEDBACK'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_FEEDBACK'
,p_attribute_03=>'P8001_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_process_error_message=>'No se ha podido recuperar la fila.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(11896626345815992.4651)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Delete'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_feedback_int.delete_feedback (',
'   p_feedback_id => :P8001_ID );'))
,p_process_error_message=>'No se puede suprimir la fila de la tabla WWV_FLOW_FEEDBACK.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(188159408440270532.4651)
,p_process_success_message=>'Se han suprimido los comentarios.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(188166019668270546.4651)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_FEEDBACK'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_FEEDBACK'
,p_attribute_03=>'P8001_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'U'
,p_attribute_12=>'Y'
,p_process_error_message=>'No se ha podido procesar la fila de la tabla WWV_FLOW_FEEDBACK.'
,p_process_when=>'DELETE'
,p_process_when_type=>'REQUEST_NOT_EQUAL_CONDITION'
,p_process_success_message=>unistr('Acci\00F3n procesada.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(441743186307077669.4651)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'process Follow up'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P8001_FOLLOW_UP is not null then',
'  apex_util.submit_feedback_followup (',
'	p_feedback_id  => :P8001_ID,',
'	p_follow_up => :P8001_FOLLOW_UP);',
'end if;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(188166199532270546.4651)
,p_process_sequence=>60
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'8001'
,p_process_when_button_id=>wwv_flow_api.id(188159408440270532.4651)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(796740853284267463.4651)
,p_process_sequence=>70
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(188159316393270532.4651)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(833256295190925568.4651)
,p_process_sequence=>80
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog on Delete'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(188159408440270532.4651)
);
end;
/
prompt --application/pages/page_08002
begin
wwv_flow_api.create_page(
 p_id=>8002.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>'Convertir Comentarios en Bug'
,p_page_mode=>'MODAL'
,p_step_title=>'Convertir Comentarios en Bug'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(700758032440987611.4651)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'td_fb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188208597659914296.4651)
,p_plug_name=>'Detalles del Bug'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>21
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p></p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188545492170017949.4651)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(697044757239351357.4651)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(833256076821925565.4651)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('La conversi\00F3n de comentarios en un bug definir\00E1 el estado de los comentarios en cerrado. Introduzca una respuesta p\00FAblica para el comentario.')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(796741466816267469.4651)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(188545492170017949.4651)
,p_button_name=>'Cancel'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(188209297498919155.4651)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(188545492170017949.4651)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear Bug'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188209798829924116.4651)
,p_name=>'P8002_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188485006529141582.4651)
,p_name=>'P8002_FEEDBACK'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEEDBACK_COMMENT ',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8002_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_colspan=>6
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188485292808147008.4651)
,p_name=>'P8002_FEEDBACK_TYPE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tipo:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEEDBACK_TYPE',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8002_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'FEEDBACK TYPE'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select the_name, id ',
'from WWV_FLOW_FEEDBACK_TYPES',
'order by 2'))
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_colspan=>6
,p_grid_column=>7
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188508117065405683.4651)
,p_name=>'P8002_ASSIGNED_TO'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_prompt=>'Asignar a'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'OWNER - TASKS, ASSIGNED TO (TODO, MILESTONES, FEATURES, BUGS)'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lower(user_name) d, lower(user_name) r ',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'union',
'select lower(d) d, lower(r) r from (',
'    select distinct assigned_to d, assigned_to r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and ',
'         assigned_to is not null',
'    union',
'    select distinct CONTRIBUTOR d, CONTRIBUTOR r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and CONTRIBUTOR is not null',
'    union',
'    select distinct EVENT_OWNER d, EVENT_OWNER r ',
'    from wwv_flow_events ',
'    where security_group_id = :flow_security_group_id and ',
'          event_owner is not null',
'    union',
'    select distinct feature_OWNER d, feature_OWNER r ',
'    from wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_owner is not null',
'    union ',
'    select distinct feature_contributor d, feature_contributor r ',
'    from  wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_contributor is not null',
'    union',
'    select distinct assigned_to d, assigned_to r ',
'    from wwv_flow_bugs',
'    where security_group_id = :flow_security_group_id and ',
'          assigned_to is not null',
') ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleccionar Persona asignada -'
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_colspan=>6
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>'Persona responsable de este bug. Para agregar valores a esta lista, introduzca un nombre en el campo Nueva Persona asignada.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188508290071405684.4651)
,p_name=>'P8002_SEVERITY'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_item_default=>'0'
,p_prompt=>'Gravedad'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'BUG SEVERITY'
,p_lov=>'select id||''. ''||the_name the_name, id from wwv_flow_bug_severity order by 1'
,p_cHeight=>1
,p_colspan=>6
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>'Gravedad del bug.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188509196333428136.4651)
,p_name=>'P8002_NEW_ASSIGNEE'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nueva Persona asignada'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>18
,p_cMaxlength=>4000
,p_begin_on_new_line=>'N'
,p_colspan=>6
,p_grid_column=>7
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Agregue una persona asignada que no est\00E9 disponible en la lista de selecci\00F3n <b>Asignado a</b>.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188509794433465378.4651)
,p_name=>'P8002_BUG_TITLE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('T\00EDtulo de Bug')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select substr(FEEDBACK_COMMENT,1,60)',
'from wwv_flow_feedback',
'where id = :p8002_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>4000
,p_colspan=>6
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188511590025520936.4651)
,p_name=>'P8002_RELEASE'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Versi\00F3n')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_team.get_default_release (',
'   p_security_group_id => :flow_security_group_id,',
'   p_return_null_as    => null);'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Seleccionar Versi\00F3n -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_colspan=>6
,p_grid_column=>7
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Restrinja el informe a una versi\00F3n determinada o muestre todas las versiones. ')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188544795370999906.4651)
,p_name=>'P8002_CREATED_BY'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Creado por:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select created_by',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8002_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_colspan=>6
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188545195156009319.4651)
,p_name=>'P8002_FEEDBACK_DATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios Registrados:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select to_char(created_on,''Day Month DD, YYYY HH24:MI'') d',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8002_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_colspan=>6
,p_grid_column=>7
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188566496707072214.4651)
,p_name=>'P8002_APPLICATION_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Aplicaci\00F3n:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d from wwv_flows where id = (',
'select application_id',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8002_id) and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_colspan=>6
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188569212655228226.4651)
,p_name=>'P8002_PAGE_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(188208597659914296.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('P\00E1gina:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.page_id||''. ''||p.name d',
'from WWV_FLOW_FEEDBACK f, wwv_flow_steps p',
'where f.id = :p8002_id and ',
'   f.application_id = p.flow_id and',
'   f.page_id = p.id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_colspan=>6
,p_grid_column=>7
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(833256123183925566.4651)
,p_name=>'P8002_PUBLIC_RESPONSE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(833256076821925565.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Respuesta P\00FAblica')
,p_source=>'nvl(:P8001_PUBLIC_RESPONSE,wwv_flow_lang.system_message(''LOG_FEEDBACK_AS_BUG_CONFIRM''))'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cHeight=>3
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('Respuesta que se puede ver p\00FAblicamente.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(188509416765434020.4651)
,p_computation_sequence=>10
,p_computation_item=>'P8002_ASSIGNED_TO'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P8002_NEW_ASSIGNEE is not null then',
'   return :P8002_NEW_ASSIGNEE;',
'else',
'   return :P8002_ASSIGNED_TO;',
'end if;'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(796741570096267470.4651)
,p_name=>'Close Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(796741466816267469.4651)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(796741631277267471.4651)
,p_event_id=>wwv_flow_api.id(796741570096267470.4651)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(188513400601637481.4651)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create bug'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team.log_feedback_as_bug (',
'  p_feedback_id  => :P8002_ID,',
'  p_workspace_id => :flow_security_group_id,',
'  P_ASSIGNED_TO  => nvl(replace(:P8002_ASSIGNED_TO,''%''||''null%'',null), :P8002_NEW_ASSIGNEE),',
'  P_BUG_TITLE    => :P8002_BUG_TITLE,',
'  P_SEVERITY     => :P8002_SEVERITY,',
'  P_RELEASE      => :P8002_RELEASE);'))
,p_process_when_button_id=>wwv_flow_api.id(188209297498919155.4651)
,p_process_success_message=>'Bug creado'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(833255833237925563.4651)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_08003
begin
wwv_flow_api.create_page(
 p_id=>8003.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>unistr('Registrar como Funci\00F3n')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('Registrar como Funci\00F3n')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(700758032440987611.4651)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'600'
,p_dialog_width=>'800'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'td_fb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188211019944928373.4651)
,p_plug_name=>'Hidden Items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188551199190076732.4651)
,p_plug_name=>'Detalles de Funciones'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(215167289434807220.4651)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(697044757239351357.4651)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(833256725898925572.4651)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('La conversi\00F3n de comentarios en una funci\00F3n definir\00E1 el estado de los comentarios en cerrado. Introduzca una respuesta p\00FAblica para el comentario.')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(833256950605925574.4651)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(215167289434807220.4651)
,p_button_name=>'Cancel'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(188211408576928373.4651)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(215167289434807220.4651)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Crear Funci\00F3n')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188211590290928374.4651)
,p_name=>'P8003_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(188211019944928373.4651)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188551390987076734.4651)
,p_name=>'P8003_FEEDBACK_LOGGED'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Registrado:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select apex_util.get_since(created_on) d',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8003_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188551619882076735.4651)
,p_name=>'P8003_FEEDBACK'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEEDBACK_COMMENT ',
'from WWV_FLOW_FEEDBACK ',
'where id = :P8003_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188552092153076736.4651)
,p_name=>'P8003_ID2'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188552318796076736.4651)
,p_name=>'P8003_FEATURE_NAME'
,p_is_required=>true
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Nombre de la Funci\00F3n')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>50
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(493950978277259098.4651)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('T\00EDtulo de la funci\00F3n. Por defecto, se visualizan los primeros 50 caracteres de la entrada de comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188552815166076736.4651)
,p_name=>'P8003_RELEASE'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Versi\00F3n')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select default_release',
'from wwv_flow_task_defaults',
'where security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Seleccionar Versi\00F3n -')
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Restrinja el informe a una versi\00F3n determinada o muestre todas las versiones. Para agregar valores a esta lista, introduzca un valor en los campos Nuevas Versiones.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188553003300076737.4651)
,p_name=>'P8003_ASSIGNED_TO'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_prompt=>'Asignado a'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'OWNER - TASKS, ASSIGNED TO (TODO, MILESTONES, FEATURES, BUGS)'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lower(user_name) d, lower(user_name) r ',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'union',
'select lower(d) d, lower(r) r from (',
'    select distinct assigned_to d, assigned_to r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and ',
'         assigned_to is not null',
'    union',
'    select distinct CONTRIBUTOR d, CONTRIBUTOR r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and CONTRIBUTOR is not null',
'    union',
'    select distinct EVENT_OWNER d, EVENT_OWNER r ',
'    from wwv_flow_events ',
'    where security_group_id = :flow_security_group_id and ',
'          event_owner is not null',
'    union',
'    select distinct feature_OWNER d, feature_OWNER r ',
'    from wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_owner is not null',
'    union ',
'    select distinct feature_contributor d, feature_contributor r ',
'    from  wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_contributor is not null',
'    union',
'    select distinct assigned_to d, assigned_to r ',
'    from wwv_flow_bugs',
'    where security_group_id = :flow_security_group_id and ',
'          assigned_to is not null',
') ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleccionar Persona asignada -'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Persona responsable de esta funci\00F3n. Para agregar valores a esta lista, introduzca un nombre en el campo Nueva Persona asignada.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188553219428076737.4651)
,p_name=>'P8003_NEW_ASSIGNEE'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nueva Persona asignada'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>20
,p_cMaxlength=>255
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Agregue una persona asignada que no est\00E9 disponible en la lista de selecci\00F3n <b>Asignado a</b>.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188553416451076738.4651)
,p_name=>'P8003_FEEDBACK_TYPE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tipo:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEEDBACK_TYPE',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8003_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'FEEDBACK TYPE'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select the_name, id ',
'from WWV_FLOW_FEEDBACK_TYPES',
'order by 2'))
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188553916898076739.4651)
,p_name=>'P8003_CREATED_BY'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Creado por:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select created_by',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8003_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(437447785540523851.4651)
,p_name=>'P8003_NEW_RELEASE'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_prompt=>unistr('Nueva Versi\00F3n')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>20
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Agregue una versi\00F3n que no est\00E9 disponible en la lista de selecci\00F3n <b>Versi\00F3n</b>.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(437466500524584930.4651)
,p_name=>'P8003_FEATURE_DESCRIPTION'
,p_item_sequence=>230
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Descripci\00F3n de la Funci\00F3n')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEEDBACK_COMMENT',
'from wwv_flow_feedback',
'where id = :p8003_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>32767
,p_cHeight=>8
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('Descripci\00F3n de la funci\00F3n.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(437467508405606086.4651)
,p_name=>'P8003_START_DATE'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_prompt=>'Fecha de Inicio'
,p_source=>'select sysdate from dual'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DATE_PICKER'
,p_cSize=>14
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Fecha de inicio de la implantaci\00F3n de la funci\00F3n.')
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(437467908190615474.4651)
,p_name=>'P8003_DUE_DATE'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_prompt=>'Fecha de Vencimiento'
,p_display_as=>'NATIVE_DATE_PICKER'
,p_cSize=>14
,p_cMaxlength=>4000
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Fecha de terminaci\00F3n planificada. '),
''))
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(437469983396693472.4651)
,p_name=>'P8003_DESIRABILITY'
,p_data_type=>'NUMBER'
,p_is_required=>true
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_use_cache_before_default=>'NO'
,p_item_default=>'4'
,p_prompt=>'Conveniencia'
,p_source=>'3'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FEATURE DESIRABILITY'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name d, id',
'from wwv_flow_feature_desirability',
'order by id'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Conveniencia (o importancia) de la funci\00F3n.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(437470399111707456.4651)
,p_name=>'P8003_DEVELOPMENT_PRIORITY'
,p_data_type=>'NUMBER'
,p_is_required=>true
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_item_default=>'3'
,p_prompt=>'Prioridad de Desarrollo'
,p_source=>'3'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FEATURE PRIORITY'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name d, id',
'from   wwv_flow_feature_priorities',
'order by id'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Importancia de esta funci\00F3n.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(437473201713746089.4651)
,p_name=>'P8003_APPLICATION_ID'
,p_data_type=>'NUMBER'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select application_id',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8002_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(437474098034754493.4651)
,p_name=>'P8003_PAGE_ID'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select page_id',
'from WWV_FLOW_FEEDBACK',
'where id = :p8002_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(437481092512904299.4651)
,p_name=>'P8003_FEATURE_STATUS'
,p_data_type=>'NUMBER'
,p_is_required=>true
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_item_default=>'0'
,p_prompt=>unistr('Estado de Funci\00F3n')
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FEATURE STATUS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select status_name ||'' - ''||pct_complete||''%'' d, pct_complete r',
'from wwv_flow_feature_def_st_codes',
'order by pct_complete'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Estado de la funci\00F3n. Indica si la funci\00F3n se va a implantar y el progreso actual.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(763601039865439272.4651)
,p_name=>'P8003_PUBLIC_RESPONSE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(833256725898925572.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Respuesta p\00FAblica')
,p_source=>'nvl(:P8001_PUBLIC_RESPONSE,wwv_flow_lang.system_message(''LOG_FEEDBACK_AS_FEATURE_CONFIRM''))'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cHeight=>3
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(833256547972925570.4651)
,p_name=>'P8003_APPLICATION_DISPLAY'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_prompt=>unistr('Aplicaci\00F3n:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d from wwv_flows where id = (',
'select application_id',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8002_id) and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(833256582802925571.4651)
,p_name=>'P8003_PAGE_DISPLAY'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_prompt=>unistr('P\00E1gina:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.page_id||''. ''||p.name d',
'from WWV_FLOW_FEEDBACK f, wwv_flow_steps p',
'where f.id = :p8002_id and ',
'   f.application_id = p.flow_id and',
'   f.page_id = p.id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(833257221292925577.4651)
,p_name=>'P8003_FEATURE_TYPE_ID'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(188551199190076732.4651)
,p_prompt=>unistr('Estado de Aprobaci\00F3n')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FEATURE TYPE'
,p_lov=>'select type_name, id from wwv_flow_feature_types'
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Seleccionar Estado de Aprobaci\00F3n -')
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(705088717999070570.4651)
,p_name=>'New'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P8003_RELEASE'
,p_condition_element=>'P8003_RELEASE'
,p_triggering_condition_type=>'NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(705088785558070571.4651)
,p_event_id=>wwv_flow_api.id(705088717999070570.4651)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P8003_NEW_RELEASE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(705088954231070572.4651)
,p_event_id=>wwv_flow_api.id(705088717999070570.4651)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P8003_NEW_RELEASE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(705088986363070573.4651)
,p_name=>'New_1'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P8003_ASSIGNED_TO'
,p_condition_element=>'P8003_ASSIGNED_TO'
,p_triggering_condition_type=>'NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(705089081541070574.4651)
,p_event_id=>wwv_flow_api.id(705088986363070573.4651)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P8003_NEW_ASSIGNEE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(705089249111070575.4651)
,p_event_id=>wwv_flow_api.id(705088986363070573.4651)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P8003_NEW_ASSIGNEE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(833256982239925575.4651)
,p_name=>'Cancel'
,p_event_sequence=>30
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(833256950605925574.4651)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(833257158685925576.4651)
,p_event_id=>wwv_flow_api.id(833256982239925575.4651)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(437441797858366581.4651)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Log as feature'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team.log_feedback_as_feature (',
'    p_feedback_id          => :P8003_ID,',
'    p_app_id               => :P8003_APPLICATION_ID,',
'    p_feature_name         => :P8003_FEATURE_NAME,',
'    p_feature_description  => :P8003_FEATURE_DESCRIPTION,',
'    p_feature_status       => :P8003_FEATURE_STATUS,',
'    p_new_release          => :P8003_NEW_RELEASE, ',
'    p_release              => :P8003_RELEASE,',
'    p_new_assignee         => :P8003_NEW_ASSIGNEE,',
'    p_assigned_to          => :P8003_ASSIGNED_TO,',
'    p_development_priority => :P8003_DEVELOPMENT_PRIORITY,',
'    p_desirability         => :P8003_DESIRABILITY,',
'    p_due_date             => :P8003_DUE_DATE,',
'    p_start_date           => :P8003_START_DATE,',
'    p_feature_type_id      => :P8003_FEATURE_TYPE_ID,',
'    p_public_response      => :P8003_PUBLIC_RESPONSE',
'    );'))
,p_process_when_button_id=>wwv_flow_api.id(188211408576928373.4651)
,p_process_success_message=>unistr('Funci\00F3n creada')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(833256843754925573.4651)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_08004
begin
wwv_flow_api.create_page(
 p_id=>8004.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>'Convertir comentarios en problema'
,p_page_mode=>'MODAL'
,p_step_title=>'Convertir comentarios en problema'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(700758032440987611.4651)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'td_fb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(669041394654726555.4651)
,p_plug_name=>'Detalles del Problema'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>21
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p></p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(669378289164830208.4651)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(697044757239351357.4651)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1314088873816737824.4651)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('La conversi\00F3n de comentarios en un problema definir\00E1 el estado de los comentarios en cerrado. Introduzca una respuesta p\00FAblica para el comentario.')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(480840454893812322.4651)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(669378289164830208.4651)
,p_button_name=>'Cancel'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(480840896504812326.4651)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(669378289164830208.4651)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear problema'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(156403361748150736.4651)
,p_name=>'P8004_ISSUE_TEXT'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(669041394654726555.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Texto de Incidencia'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_issue_text     clob;',
'    l_feedback_type  varchar2(4000);',
'begin ',
'    select the_name',
'      into l_feedback_type',
'    from WWV_FLOW_FEEDBACK_TYPES',
'    where id = :P8004_FEEDBACK_TYPE;',
'    ',
'    l_issue_text := ''## Details: ''||chr(10)||',
'',
'                     ''Feedback Type : ''||l_feedback_type||chr(10)||',
'                     ''Logged By     : ''||:P8004_CREATED_BY||chr(10)||',
'                     ''Logged On     : ''||:P8004_FEEDBACK_DATE||chr(10)||',
'                     chr(10)||',
'                     ''## Feedback Text''||chr(10)||',
'                     ''>''||replace(:P8004_FEEDBACK, chr(10), chr(10)||''>'');',
'return l_issue_text;',
'end;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_MARKDOWN_EDITOR'
,p_cSize=>60
,p_cHeight=>12
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_css_classes=>'a-IssueComments'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'SIMPLE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(480833378598812303.4651)
,p_name=>'P8004_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(669041394654726555.4651)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(480833737137812307.4651)
,p_name=>'P8004_FEEDBACK'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(669041394654726555.4651)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEEDBACK_COMMENT ',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8004_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(480834157941812308.4651)
,p_name=>'P8004_FEEDBACK_TYPE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(669041394654726555.4651)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEEDBACK_TYPE',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8004_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(480834501275812310.4651)
,p_name=>'P8004_CREATED_BY'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(669041394654726555.4651)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select created_by',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8004_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(480834930520812310.4651)
,p_name=>'P8004_FEEDBACK_DATE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(669041394654726555.4651)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select to_char(created_on,''Day Month DD, YYYY HH24:MI'') d',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8004_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(480835399469812311.4651)
,p_name=>'P8004_APPLICATION_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(669041394654726555.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Aplicaci\00F3n:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d from wwv_flows where id = (',
'select application_id',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8004_id) and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(480835723561812312.4651)
,p_name=>'P8004_PAGE_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(669041394654726555.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('P\00E1gina:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.page_id||''. ''||p.name d',
'from WWV_FLOW_FEEDBACK f, wwv_flow_steps p',
'where f.id = :p8004_id and ',
'   f.application_id = p.flow_id and',
'   f.page_id = p.id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(480836106130812312.4651)
,p_name=>'P8004_ISSUE_TITLE'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(669041394654726555.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('T\00EDtulo del problema')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''Feedback #''||feedback_id||'' - ''||substr(FEEDBACK_COMMENT,1,60)',
'from wwv_flow_feedback',
'where id = :p8004_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>80
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(480838300786812315.4651)
,p_name=>'P8004_ASSIGNED_TO'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(669041394654726555.4651)
,p_prompt=>'Asignar a'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'WORKSPACE_DEVELOPERS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'       case ',
'            when first_name||last_name is null then "USER"',
'            else first_name||'' ''||last_name',
'        end display,',
'         a."USER" return ',
'from wwv_flow_workspace_users a',
'where workspace_id = :flow_security_group_id',
' and dev_type != ''End User'''))
,p_lov_display_null=>'YES'
,p_cHeight=>5
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Persona o personas que deber\00EDan estar asignadas a este problema. ')
,p_attribute_01=>'NONE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(480841511020812328.4651)
,p_name=>'P8004_PUBLIC_RESPONSE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1314088873816737824.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Respuesta P\00FAblica')
,p_source=>'nvl(:P8001_PUBLIC_RESPONSE,wwv_flow_lang.system_message(''LOG_FEEDBACK_AS_ISSUE_CONFIRM''))'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cHeight=>3
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('Respuesta que se puede ver p\00FAblicamente.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(480843630638812345.4651)
,p_name=>'Close Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(480840454893812322.4651)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(480844126329812346.4651)
,p_event_id=>wwv_flow_api.id(480843630638812345.4651)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(480842882492812340.4651)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create bug'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team.log_feedback_as_bug (',
'  p_feedback_id  => :P8004_ID,',
'  p_workspace_id => :flow_security_group_id,',
'  P_ASSIGNED_TO  => nvl(replace(:P8004_ASSIGNED_TO,''%''||''null%'',null), :P8004_NEW_ASSIGNEE),',
'  P_BUG_TITLE    => :P8004_BUG_TITLE,',
'  P_SEVERITY     => :P8004_SEVERITY,',
'  P_RELEASE      => :P8004_RELEASE);'))
,p_process_when_type=>'NEVER'
,p_process_success_message=>'Bug creado'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(156403485807150737.4651)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Issue'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_id                    number;',
'    l_app_id                      number;',
'    l_page_id                     number;',
'    l_feedback_status_closed      number;',
'    ',
'BEGIN ',
'-- Get the app and page associated to the feedback',
'    select application_id, ',
'           page_id',
'      into l_app_id, ',
'           l_page_id ',
'      from wwv_flow_feedback ',
'     where id = :P8004_ID',
'       and security_group_id = :flow_security_group_id;',
'       ',
'-- Get Team Dev Feedback Status Closed',
'        select id',
'          into l_feedback_status_closed',
'          from wwv_flow_feedback_status',
'         where the_name = wwv_flow_lang.system_message(''CLOSED'');',
'',
'-- Insert the issue details',
'insert into wwv_flow_issues (',
'    security_group_id,',
'    title,',
'    slug,',
'    issue_text,',
'    application_id,',
'    page_id,',
'    status',
') values (',
'    :flow_security_group_id,',
'    :P8004_ISSUE_TITLE,',
'    wwv_flow_issue_int.gen_slug(:P8004_ISSUE_TITLE),',
'    :P8004_ISSUE_TEXT, ',
'    l_app_id, ',
'    l_page_id, ',
'    ''OPEN''',
') returning id into l_issue_id;',
'',
'-- Add the assignments.',
'wwv_flow_issue_int.add_assignees(p_issue_id => l_issue_id, p_assignee_ids => :P8004_ASSIGNED_TO);',
'',
'-- Update Feedback with issue ID',
'update wwv_flow_feedback ',
'   set issue_id = l_issue_id, ',
'       public_response = :P8004_PUBLIC_RESPONSE,',
'       feedback_status = l_feedback_status_closed',
' where id = :P8004_ID',
'   and security_group_id = :flow_security_group_id;',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(480840896504812326.4651)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(480843285261812342.4651)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_08005
begin
wwv_flow_api.create_page(
 p_id=>8005.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>'Comentarios por Usuario'
,p_step_title=>'Comentarios por Usuario'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(643947460795988298.4651)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'td_fb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188237012174163760.4651)
,p_plug_name=>'Feedback Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(813554394221812426.4651)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(188228600364085362.4651)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(188948529125031038.4651)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(638522961229835782.4651)
,p_plug_name=>'Comentarios por Usuario'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_plug_template=>wwv_flow_api.id(684869836739871122.4651)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P8005a42 */ ',
'    lower(apex_user) filing_user,',
'    count(*) feedback,',
'    count(distinct application_id) applications,',
'    round( 100 * count(*) / (select count(*) from wwv_flow_feedback), 1 ) feedback_pct,',
'    round( 100 * count(distinct application_id)',
'        / (select count(distinct application_id) from wwv_flow_feedback), 1 ) apps_pct',
'from wwv_flow_feedback f',
'where security_group_id = :flow_security_group_id ',
'group by apex_user'))
,p_plug_source_type=>'NATIVE_IR'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>11
,p_prn_height=>8.5
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(638523033329835783.4651)
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('Esta consulta devuelve m\00E1s de 10.000 filas, filtre los datos para asegurar resultados completos.')
,p_no_data_found_message=>unistr('No se ha encontrado ning\00FAn dato.')
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y_OF_Z'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_owner=>'DAVID.GALE'
,p_internal_uid=>632017054954295723
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(638523104947835784.4651)
,p_db_column_name=>'FILING_USER'
,p_display_order=>10
,p_column_identifier=>'A'
,p_column_label=>'Usuario'
,p_column_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:RP,RIR:IR_APEX_USER:#FILING_USER#:'
,p_column_linktext=>'#FILING_USER#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(638523224211835785.4651)
,p_db_column_name=>'FEEDBACK'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>'Comentarios'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(638523299506835786.4651)
,p_db_column_name=>'APPLICATIONS'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>'Aplicaciones'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(638523399552835787.4651)
,p_db_column_name=>'FEEDBACK_PCT'
,p_display_order=>40
,p_column_identifier=>'D'
,p_column_label=>'Comentarios %'
,p_column_type=>'NUMBER'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'PCT_GRAPH:cccccc:777777:150'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(638523555620835788.4651)
,p_db_column_name=>'APPS_PCT'
,p_display_order=>50
,p_column_identifier=>'E'
,p_column_label=>'Aplicaciones %'
,p_column_type=>'NUMBER'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'PCT_GRAPH:cccccc:777777:150'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(189940683950984914.4651)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(638522961229835782.4651)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Restablecer'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:8005:&SESSION.::&DEBUG.:8005,RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(188494915083361628.4651)
,p_branch_action=>'f?p=&APP_ID.:8005:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
end;
/
prompt --application/pages/page_08006
begin
wwv_flow_api.create_page(
 p_id=>8006.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>'Convertir Comentarios en Tarea'
,p_page_mode=>'MODAL'
,p_step_title=>'Convertir Comentarios en Tarea'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(700758032440987611.4651)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'600'
,p_dialog_width=>'800'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'td_fb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188240293077202779.4651)
,p_plug_name=>'Detalles de Tarea'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>21
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(188547913426033565.4651)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(697044757239351357.4651)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(598394481630929769.4651)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('La conversi\00F3n de comentarios en una tarea definir\00E1 el estado de los comentarios en cerrado. Introduzca una respuesta p\00FAblica para el comentario.')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(188240690632202780.4651)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(188547913426033565.4651)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear Tarea'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188240906528202781.4651)
,p_name=>'P8006_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188548190701036400.4651)
,p_name=>'P8006_FEEDBACK'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEEDBACK_COMMENT ',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8006_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188548699704039066.4651)
,p_name=>'P8006_FEEDBACK_TYPE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tipo:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEEDBACK_TYPE',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8006_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'FEEDBACK TYPE'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select the_name, id ',
'from WWV_FLOW_FEEDBACK_TYPES',
'order by 2'))
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188549206284040962.4651)
,p_name=>'P8006_CREATED_BY'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Creado por:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select created_by',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8006_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188549415981043755.4651)
,p_name=>'P8006_FEEDBACK_LOGGED'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios Registrados:'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select to_char(created_on,''Day Month DD, YYYY HH24:MI'') d',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8006_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188549599143048383.4651)
,p_name=>'P8006_NAME'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nombre de Tarea'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select substr(FEEDBACK_COMMENT,1,60)',
'from wwv_flow_feedback',
'where id = :p8006_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('T\00EDtulo de la tarea. Por defecto, se visualizan los primeros 50 caracteres de la entrada de comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188550108839051104.4651)
,p_name=>'P8006_RELEASE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_prompt=>unistr('Versi\00F3n')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select default_release',
'from wwv_flow_task_defaults',
'where security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RELEASE TASK, EVENTS, BUGS, FEATURES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct release d, release r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct release d, release r',
'from wwv_flow_events',
'where security_group_id = :flow_security_group_id and release is not null ',
'union',
'select distinct FIX_BY_RELEASE d, FIX_BY_RELEASE r',
'from wwv_flow_bugs',
'where security_group_id = :flow_security_group_id and FIX_BY_RELEASE is not null ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Seleccionar Versi\00F3n -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Restrinja el informe a una versi\00F3n determinada o muestre todas las versiones. ')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188550318190053838.4651)
,p_name=>'P8006_ASSIGNED_TO'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_prompt=>'Asignado a'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'OWNER - TASKS, ASSIGNED TO (TODO, MILESTONES, FEATURES, BUGS)'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lower(user_name) d, lower(user_name) r ',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'union',
'select lower(d) d, lower(r) r from (',
'    select distinct assigned_to d, assigned_to r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and ',
'         assigned_to is not null',
'    union',
'    select distinct CONTRIBUTOR d, CONTRIBUTOR r',
'    from wwv_flow_tasks',
'    where security_group_id = :flow_security_group_id and CONTRIBUTOR is not null',
'    union',
'    select distinct EVENT_OWNER d, EVENT_OWNER r ',
'    from wwv_flow_events ',
'    where security_group_id = :flow_security_group_id and ',
'          event_owner is not null',
'    union',
'    select distinct feature_OWNER d, feature_OWNER r ',
'    from wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_owner is not null',
'    union ',
'    select distinct feature_contributor d, feature_contributor r ',
'    from  wwv_flow_features ',
'    where security_group_id = :flow_security_group_id and ',
'          feature_contributor is not null',
'    union',
'    select distinct assigned_to d, assigned_to r ',
'    from wwv_flow_bugs',
'    where security_group_id = :flow_security_group_id and ',
'          assigned_to is not null',
') ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleccionar Persona asignada -'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>'Persona responsable de esta tarea. Para agregar valores a esta lista, introduzca un nombre en el campo Nueva Persona asignada.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188550491655055649.4651)
,p_name=>'P8006_NEW_ASSIGNEE'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nueva Persona asignada'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>18
,p_cMaxlength=>4000
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Agregue una persona asignada que no est\00E9 disponible en la lista de selecci\00F3n <b>Asignado a</b>.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188569715210238466.4651)
,p_name=>'P8006_APPLICATION'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Aplicaci\00F3n:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d from wwv_flows where id = (',
'select application_id',
'from WWV_FLOW_FEEDBACK ',
'where id = :p8006_id) and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188569888330240092.4651)
,p_name=>'P8006_PAGE'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('P\00E1gina:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.page_id||''. ''||p.name d',
'from WWV_FLOW_FEEDBACK f, wwv_flow_steps p',
'where f.id = :p8006_id and ',
'   f.application_id = p.flow_id and',
'   f.page_id = p.id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188573588826401103.4651)
,p_name=>'P8006_STATUS'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_prompt=>'Estado de Tarea'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'FEATURE STATUS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select status_name ||'' - ''||pct_complete||''%'' d, pct_complete r',
'from wwv_flow_feature_def_st_codes',
'order by pct_complete'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Sin estado -'
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>'Estado de la tarea.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188573814106408410.4651)
,p_name=>'P8006_CATEGORY'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_prompt=>unistr('Categor\00EDa')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TASK CATEGORY'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct task_category, task_category r',
'from wwv_flow_tasks ',
'where security_group_id = :flow_security_group_id ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Ninguna Categor\00EDa -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Categor\00EDa asociada.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(188575419048466599.4651)
,p_name=>'P8006_DESCRIPTION'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(188240293077202779.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Descripci\00F3n')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FEEDBACK_COMMENT',
'from wwv_flow_feedback ',
'where id = :p8006_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>32767
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_help_text=>unistr('Descripci\00F3n de la tarea.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(598394657650929770.4651)
,p_name=>'P8006_PUBLIC_RESPONSE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(598394481630929769.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Respuesta P\00FAblica')
,p_source=>'nvl(:P8001_PUBLIC_RESPONSE,wwv_flow_lang.system_message(''LOG_FEEDBACK_AS_TODO_CONFIRM''))'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cHeight=>3
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(188563114359001626.4651)
,p_computation_sequence=>10
,p_computation_item=>'P8006_ASSIGNED_TO'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P8006_NEW_ASSIGNEE is not null then',
'  return :P8006_NEW_ASSIGNEE;',
'else',
'  return :P8006_ASSIGNED_TO;',
'end if;'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(705088303581070566.4651)
,p_name=>'New'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P8006_ASSIGNED_TO'
,p_condition_element=>'P8006_ASSIGNED_TO'
,p_triggering_condition_type=>'NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(705088423020070567.4651)
,p_event_id=>wwv_flow_api.id(705088303581070566.4651)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P8006_NEW_ASSIGNEE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(705088546904070568.4651)
,p_event_id=>wwv_flow_api.id(705088303581070566.4651)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P8006_NEW_ASSIGNEE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(188571516867333540.4651)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create to do'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_team.log_feedback_as_todo (',
'    p_feedback_id        => :P8006_ID,',
'    p_assigned_to        => :P8006_ASSIGNED_TO,',
'    p_description        => :P8006_DESCRIPTION,',
'    p_name               => :P8006_NAME,',
'    p_release            => :P8006_RELEASE,',
'    p_status             => :P8006_STATUS,',
'    p_category           => :P8006_CATEGORY',
'    );'))
,p_process_success_message=>'Tarea creada'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(796741360662267468.4651)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_08011
begin
wwv_flow_api.create_page(
 p_id=>8011.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>'Calendario de Comentarios'
,p_step_title=>'Calendario de Comentarios'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(643947460795988298.4651)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'td_fb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(189006196529072390.4651)
,p_plug_name=>'Feedback Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(188228600364085362.4651)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(188948529125031038.4651)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(652741910848752619.4651)
,p_plug_name=>unistr('Comentarios por D\00EDa')
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding:a-Region--accessibleHeader'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P8011a */ trunc(CREATED_ON) created_on, ',
'    application_id,',
'    count(*) feedback_entries,',
'    application_id||'' (''||count(*)||'')'' label_text,',
'    to_char(trunc(created_on),''YYYYMMDD'') created_on_yyyymmdd',
'from wwv_flow_feedback f',
'where security_group_id = :flow_security_group_id',
'group by trunc(CREATED_ON), application_id'))
,p_plug_source_type=>'NATIVE_CSS_CALENDAR'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'CREATED_ON'
,p_attribute_03=>'LABEL_TEXT'
,p_attribute_05=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:RP,RIR:IR_CREATED_ON_YYYYMMDD,IR_APPLICATION_ID:&CREATED_ON_YYYYMMDD.,&APPLICATION_ID.'
,p_attribute_07=>'N'
,p_attribute_13=>'date'
,p_attribute_17=>'Y'
,p_attribute_19=>'N'
,p_attribute_21=>'10'
,p_attribute_22=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(189009913949097289.4651)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Adjust Calendar Date -Monthly'
,p_process_sql_clob=>' apex_util.month_calendar(''P8011_CALENDAR_TYPE'');'
,p_process_error_message=>'Error al cambiar la fecha del calendario.'
,p_process_comment=>'Generated 31-AUG-09'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(189010317350097292.4651)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Adjust Calendar Date -Weekly'
,p_process_sql_clob=>' apex_util.weekly_calendar(''P8011_CALENDAR_TYPE'');'
,p_process_error_message=>'Error al cambiar la fecha del calendario.'
,p_process_comment=>'Generated 31-AUG-09'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(189011903736097293.4651)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Adjust Calendar Date -Next'
,p_process_sql_clob=>' apex_util.increment_calendar;'
,p_process_error_message=>'Error al cambiar la fecha del calendario.'
,p_process_comment=>'Generated 31-AUG-09'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(189011502040097293.4651)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Adjust Calendar Date -Today'
,p_process_sql_clob=>' apex_util.today_calendar;'
,p_process_error_message=>'Error al cambiar la fecha del calendario.'
,p_process_comment=>'Generated 31-AUG-09'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(189011107025097292.4651)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Adjust Calendar Date -Previous'
,p_process_sql_clob=>' apex_util.decrement_calendar;'
,p_process_error_message=>'Error al cambiar la fecha del calendario.'
,p_process_comment=>'Generated 31-AUG-09'
);
end;
/
prompt --application/pages/page_08012
begin
wwv_flow_api.create_page(
 p_id=>8012.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>'Panel de Control de Comentarios'
,p_step_title=>'Panel de Control de Comentarios'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(395644842192767482.4651)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'td_fb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(15581443644474518.4651)
,p_plug_name=>'Comentarios Abiertos'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_session varchar2(255) := :APP_SESSION;',
'    l_security_group_id number := :FLOW_SECURITY_GROUP_ID;',
'begin',
'    -- feedback entries',
'    for c1 in (select count(*) entries',
'from wwv_flow_feedback f',
'where security_group_id = :FLOW_SECURITY_GROUP_ID',
'  and feedback_status != 4',
'            ) loop',
'        sys.htp.p(''<div class="a-BadgeChart a-BadgeChart--justGageLike">'');',
'        sys.htp.p(''  <a href="''||apex_util.prepare_url(''f?p=&APP_ID.:8000:''||l_session)||''" title="View Feedback Entries" class="a-BadgeChart-link">'');',
'        sys.htp.p(''    <span class="a-BadgeChart-value">''||c1.entries||'' </span> '');',
'        sys.htp.p(''  <div class="a-BadgeChart-text">'');',
'        sys.htp.p(''    <span class="a-BadgeChart-label">''||wwv_flow_lang.system_message(''APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'')||''</span>'');',
'        sys.htp.p(''    <span class="a-BadgeChart-desc">'');',
'        sys.htp.p(''    </span>'');',
'        sys.htp.p(''  </div>'');',
'        sys.htp.p(''  </a>'');',
'        sys.htp.p(''</div>'');',
'    end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(183898105527986684.4651)
,p_plug_name=>unistr('iconos de navegaci\00F3n')
,p_region_name=>'apex-control-icons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(415202027252589471.4651)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(183892999331937539.4651)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(216948000482610776.4651)
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(189502805888823452.4651)
,p_plug_name=>'Feedback Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(188228600364085362.4651)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(188948529125031038.4651)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(189503001435823453.4651)
,p_plug_name=>'Top Bar'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(198426105113535390.4651)
,p_plug_name=>'Acerca de'
,p_region_template_options=>'#DEFAULT#:a-Region--padded:u-Height:a-Region--sideRegion:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Los enlaces de comentarios se pueden embeber en aplicaciones mediante barras de navegaci\00F3n o mediante la codificaci\00F3n de un enlace. Los usuarios que ejecutan una aplicaci\00F3n pueden proporcionar comentarios, mientras que los usuarios con acceso al m')
||unistr('\00F3dulo de desarrollo del equipo de &PRODUCT_NAME. pueden gestionar los comentarios y convertirlos en un problema.</p>'),
'',
unistr('<p><a target="_blank" href="&SYSTEM_HELP_URL./htmdb/managing-feedback.html">Obtener m\00E1s informaci\00F3n...</a></p>')))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(243191786516347065.4651)
,p_plug_name=>'Por Estado'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P8000b42 */',
'    s.the_name,',
'    (select count(*) ',
'     from wwv_flow_feedback f',
'     where f.security_group_id = :flow_security_group_id and',
'     nvl(f.feedback_status,0) = s.id) feedback_count,',
'     apex_util.prepare_url(''f?p=&APP_ID.:8000:''||:APP_SESSION||'':::8000,RIR:IR_FEEDBACK_STATUS_ID:''||s.id) link_url',
'from wwv_flow_feedback_status s',
'order by id'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_02=>'THE_NAME'
,p_attribute_03=>'&LINK_URL.'
,p_attribute_04=>'FEEDBACK_COUNT'
,p_attribute_11=>'VALUE'
,p_attribute_14=>'5'
,p_attribute_15=>'TEXT'
,p_attribute_16=>'ABSOLUTE'
,p_attribute_17=>'MODERN'
,p_attribute_18=>'ABOVE'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(437288102003925282.4651)
,p_name=>'Resumen'
,p_template=>wwv_flow_api.id(394867304186881833.4651)
,p_display_sequence=>100
,p_region_sub_css_classes=>'a-BadgeList--cols a-BadgeList--3col a-BadgeList--xlarge a-BadgeList--responsive a-BadgeList--bottomBorder'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding'
,p_display_point=>'BODY'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  /* APEX4800P8012a */',
'    count(*) total_feedback_entries,',
'    sum(decode(developer_comment,null,0,1)) developer_comments,',
'    sum(decode(PUBLIC_RESPONSE,null,0,1)) PUBLIC_RESPONSEs,',
'    sum(decode(PUBLIC_RESPONSE,null,1,0)) no_PUBLIC_RESPONSE,',
'    count(distinct security_group_id||created_by) distinct_filers,',
'    sum(decode(greatest(created_on,sysdate-1),created_on,1,0)) feedback_last_24_hours,',
'    sum(decode(greatest(created_on,sysdate-7),created_on,1,0)) feedback_last_week',
'from WWV_FLOW_FEEDBACK f',
'where f.security_group_id = :flow_security_group_id'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(395652746647870440.4651)
,p_query_num_rows=>10
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('El informe no contiene ning\00FAn dato')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>10
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(437288102003925282.4651)
,p_plug_column_width=>'apex-col--topBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(437290285857930008.4651)
,p_query_column_id=>1
,p_column_alias=>'TOTAL_FEEDBACK_ENTRIES'
,p_column_display_sequence=>1
,p_column_heading=>'Total Entries'
,p_column_format=>'999G999G999G999G999G990'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(437294004951963907.4651)
,p_query_column_id=>2
,p_column_alias=>'DEVELOPER_COMMENTS'
,p_column_display_sequence=>2
,p_column_heading=>'Entradas con Comentarios del Desarrollador'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:RP,RIR:IRNN_DEVELOPER_COMMENT:'
,p_column_linktext=>'#DEVELOPER_COMMENTS#'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(437294104902963907.4651)
,p_query_column_id=>3
,p_column_alias=>'PUBLIC_RESPONSES'
,p_column_display_sequence=>3
,p_column_heading=>unistr('Entradas con Respuestas P\00FAblicas')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:RP,RIR:IRNN_PUBLIC_RESPONSE:'
,p_column_linktext=>'#PUBLIC_RESPONSES#'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(437294390799988260.4651)
,p_query_column_id=>4
,p_column_alias=>'NO_PUBLIC_RESPONSE'
,p_column_display_sequence=>4
,p_column_heading=>unistr('Entradas sin Respuesta P\00FAblica')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:RP,RIR:IRN_PUBLIC_RESPONSE:'
,p_column_linktext=>'#NO_PUBLIC_RESPONSE#'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(437310684844557022.4651)
,p_query_column_id=>5
,p_column_alias=>'DISTINCT_FILERS'
,p_column_display_sequence=>5
,p_column_heading=>'Usuarios distintos'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:8005:&SESSION.::&DEBUG.:::'
,p_column_linktext=>'#DISTINCT_FILERS#'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(441218196716021605.4651)
,p_query_column_id=>6
,p_column_alias=>'FEEDBACK_LAST_24_HOURS'
,p_column_display_sequence=>6
,p_column_heading=>unistr('Comentarios de las \00DAltimas 24 Horas')
,p_column_format=>'999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:RP,8000,RIR:IREQ_CREATED_TODAY_YN:Y:'
,p_column_linktext=>'#FEEDBACK_LAST_24_HOURS#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(441218298037021606.4651)
,p_query_column_id=>7
,p_column_alias=>'FEEDBACK_LAST_WEEK'
,p_column_display_sequence=>7
,p_column_heading=>'Comentarios de la Semana Pasada'
,p_column_format=>'999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:RP,8000,RIR:IREQ_CREATED_THIS_WEEK_YN:Y:'
,p_column_linktext=>'#FEEDBACK_LAST_WEEK#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(637727722500778262.4651)
,p_plug_name=>'Usuarios de comentarios'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_session varchar2(255) := :APP_SESSION;',
'    l_security_group_id number := :FLOW_SECURITY_GROUP_ID;',
'begin',
'    -- feedback entries',
'    for c1 in ( select /* APEX4d004e42 */',
'                    count(distinct security_group_id||created_by) filers',
'                from wwv_flow_feedback f',
'                where f.security_group_id = l_security_group_id',
'            ) loop',
'        sys.htp.p(''<div class="a-BadgeChart a-BadgeChart--justGageLike">'');',
'        sys.htp.p(''  <a href="''||apex_util.prepare_url(''f?p=&APP_ID.:8005:''||l_session)||''" title="View Feedback Users" class="a-BadgeChart-link">'');',
'        sys.htp.p(''    <span class="a-BadgeChart-value">''||c1.filers||'' </span> '');',
'        sys.htp.p(''    <div class="a-BadgeChart-text">'');',
'        sys.htp.p(''      <span class="a-BadgeChart-label">''||wwv_flow_lang.system_message(''APEX.FEEDBACK.USERS'')||''</span>'');',
'        sys.htp.p(''      <span class="a-BadgeChart-desc">'');',
'        sys.htp.p(''      </span>'');',
'        sys.htp.p(''    </div>'');',
'        sys.htp.p(''  </a>'');',
'        sys.htp.p(''</div>'');',
'    end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(637728780217823379.4651)
,p_plug_name=>'Entradas de comentarios'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_session varchar2(255) := :APP_SESSION;',
'    l_security_group_id number := :FLOW_SECURITY_GROUP_ID;',
'begin',
'    -- feedback entries',
'    for c1 in ( select /* APEX4d004e42 */',
'                    count(security_group_id||created_by) entries',
'                from wwv_flow_feedback f',
'                where f.security_group_id = l_security_group_id',
'            ) loop',
'        sys.htp.p(''<div class="a-BadgeChart a-BadgeChart--justGageLike">'');',
'        sys.htp.p(''  <a href="''||apex_util.prepare_url(''f?p=&APP_ID.:8000:''||l_session)||''" title="View Feedback Entries" class="a-BadgeChart-link">'');',
'        sys.htp.p(''    <span class="a-BadgeChart-value">''||c1.entries||'' </span> '');',
'        sys.htp.p(''  <div class="a-BadgeChart-text">'');',
'        sys.htp.p(''    <span class="a-BadgeChart-label">''||wwv_flow_lang.system_message(''APEX.FEEDBACK.FEEDBACK_ENTRIES'')||''</span>'');',
'        sys.htp.p(''    <span class="a-BadgeChart-desc">'');',
'        sys.htp.p(''    </span>'');',
'        sys.htp.p(''  </div>'');',
'        sys.htp.p(''  </a>'');',
'        sys.htp.p(''</div>'');',
'    end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(643943110948981847.4651)
,p_plug_name=>unistr('Por Aplicaci\00F3n')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P8004a */',
'    application_id||''. ''||substr(application_name,1,40) label,',
'    count(*) value,',
'    apex_util.prepare_url(''f?p=&APP_ID.:8000:''||:APP_SESSION||'':::8000,RIR:IR_APPLICATION_ID:''||application_id) link_url',
'from wwv_flow_feedback f',
'where security_group_id = :flow_security_group_id',
'group by application_id, application_name',
'order by count(*) desc'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_attribute_02=>'LABEL'
,p_attribute_03=>'&LINK_URL.'
,p_attribute_04=>'VALUE'
,p_attribute_11=>'VALUE'
,p_attribute_14=>'5'
,p_attribute_15=>'TEXT'
,p_attribute_16=>'ABSOLUTE'
,p_attribute_17=>'MODERN'
,p_attribute_18=>'ABOVE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(643949967181020618.4651)
,p_plug_name=>'Por archivador'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4800P8012b */',
'    lower(CREATED_BY) filer,',
'    count(*) c,',
'    apex_util.prepare_url(''f?p=&APP_ID.:8000:''||:APP_SESSION||''::NO:8000,RIR:IR_APEX_USER:''||created_by) link_url',
'from WWV_FLOW_FEEDBACK f',
'where f.security_group_id = :flow_security_group_id ',
'group by lower(CREATED_BY), created_by',
'order by 2 desc'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_attribute_02=>'FILER'
,p_attribute_03=>'&LINK_URL.'
,p_attribute_04=>'C'
,p_attribute_11=>'VALUE'
,p_attribute_14=>'5'
,p_attribute_15=>'TEXT'
,p_attribute_16=>'ABSOLUTE'
,p_attribute_17=>'MODERN'
,p_attribute_18=>'ABOVE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(186679682569512687.4651)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(189503001435823453.4651)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(308205889752201939.4651)
,p_button_image_alt=>'Refrescar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:8012:&SESSION.::&DEBUG.:RP,8012::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(189506207222823462.4651)
,p_branch_action=>'f?p=&APP_ID.:8012:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
end;
/
prompt --application/pages/page_08014
begin
wwv_flow_api.create_page(
 p_id=>8014.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>'Editar Seguimiento de Comentarios'
,p_page_mode=>'MODAL'
,p_step_title=>'Editar Seguimiento de Comentarios'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(676701755252252907.4651)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'600'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_protection_level=>'C'
,p_help_text=>'td_fb.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(120624590485546673.4651)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(697044757239351357.4651)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(120625190471546675.4651)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394873728911883775.4651)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(120628796802546678.4651)
,p_name=>'Seguimiento Existente'
,p_template=>wwv_flow_api.id(697050653416351401.4651)
,p_display_sequence=>60
,p_region_template_options=>'#DEFAULT#:is-expanded:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select FOLLOW_UP, created_on, created_by',
'from wwv_flow_feedback_followup',
'where feedback_id = :P8014_FEEDBACK_ID',
'  and id != :P8014_ID',
'order by created_on desc'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_feedback_followup',
'where feedback_id = :P8014_FEEDBACK_ID',
'  and id != :P8014_ID'))
,p_display_condition_type=>'EXISTS'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(703372107153632568.4651)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>1500
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_no_data_found=>unistr('no se ha encontrado ning\00FAn dato')
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(120629009062546679.4651)
,p_query_column_id=>1
,p_column_alias=>'FOLLOW_UP'
,p_column_display_sequence=>2
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(120629083416546680.4651)
,p_query_column_id=>2
,p_column_alias=>'CREATED_ON'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_column_format=>'SINCE'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(120629202780546680.4651)
,p_query_column_id=>3
,p_column_alias=>'CREATED_BY'
,p_column_display_sequence=>3
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(120756782151569464.4651)
,p_plug_name=>'Seguimiento'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(394867304186881833.4651)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(976558551665280673.4651)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(120624590485546673.4651)
,p_button_name=>'CANCEL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(120757089022569465.4651)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(120624590485546673.4651)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P8014_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(120756998059569465.4651)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(120624590485546673.4651)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P8014_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120625385175546675.4651)
,p_name=>'P8014_FEEDBACK'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(120625190471546675.4651)
,p_prompt=>'Comentarios:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(694415461746261220.4651)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Comentarios proporcionados.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120625909068546675.4651)
,p_name=>'P8014_FEEDBACK_CREATED_ON'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(120625190471546675.4651)
,p_prompt=>'Creado:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap'
,p_tag_css_classes=>'fielddatabold'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Identifica cu\00E1ndo se proporcionaron los comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120626386669546676.4651)
,p_name=>'P8014_FEEDBACK_CREATED_BY'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(120625190471546675.4651)
,p_prompt=>'Archivado por:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Usuario que proporcion\00F3 los comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120626898484546676.4651)
,p_name=>'P8014_APPLICATION'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(120625190471546675.4651)
,p_prompt=>unistr('Aplicaci\00F3n:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap'
,p_tag_css_classes=>'fielddatabold'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Aplicaci\00F3n asociada.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120627394783546677.4651)
,p_name=>'P8014_PAGE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(120625190471546675.4651)
,p_prompt=>unistr('P\00E1gina:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('P\00E1gina asociada a los comentarios.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120758004158569468.4651)
,p_name=>'P8014_ID'
,p_item_sequence=>1
,p_item_plug_id=>wwv_flow_api.id(120756782151569464.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120758181571569474.4651)
,p_name=>'P8014_FEEDBACK_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(120756782151569464.4651)
,p_use_cache_before_default=>'NO'
,p_source=>'FEEDBACK_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WEB_SAFE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120758392033569476.4651)
,p_name=>'P8014_FOLLOW_UP'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(120756782151569464.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Seguimiento:'
,p_source=>'FOLLOW_UP'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(493950978277259098.4651)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Edite esta entrada de seguimiento de comentarios.'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120758591771569476.4651)
,p_name=>'P8014_EMAIL'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(120756782151569464.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Correo electr\00F3nico')
,p_source=>'EMAIL'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Correo electr\00F3nico de la persona que proporciona el seguimiento.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'EMAIL'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120758781884569476.4651)
,p_name=>'P8014_CREATED_BY'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(120756782151569464.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Creado por:'
,p_source=>'CREATED_BY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Usuario que cre\00F3 esta entrada de seguimiento.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120759010214569476.4651)
,p_name=>'P8014_CREATED_ON'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(120756782151569464.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Creado:'
,p_format_mask=>'&DATE_FORMAT.'
,p_source=>'CREATED_ON'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Fecha en la que se cre\00F3 esta entrada de seguimiento.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120759379158569478.4651)
,p_name=>'P8014_UPDATED_BY'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(120756782151569464.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Actualizado por:'
,p_source=>'UPDATED_BY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Usuario que actualiz\00F3 por \00FAltima vez esta entrada de seguimiento.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(120759598066569479.4651)
,p_name=>'P8014_UPDATED_ON'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(120756782151569464.4651)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Actualizado:'
,p_format_mask=>'&DATE_FORMAT.'
,p_source=>'UPDATED_ON'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(493950867964259075.4651)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('Fecha en la que se actualiz\00F3 por \00FAltima vez esta entrada de seguimiento.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(120760091879569479.4651)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_FEEDBACK_FOLLOWUP'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_FEEDBACK_FOLLOWUP'
,p_attribute_03=>'P8014_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(120630194421546687.4651)
,p_process_sequence=>20
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'get feedback data'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'   select FEEDBACK_COMMENT, ',
'            created_on, ',
'            created_by, ',
'            application_id, ',
'            page_id, ',
'            application_name, ',
'            page_name',
'   from wwv_flow_feedback',
'   where id = :P8014_FEEDBACK_ID) loop',
'   :P8014_FEEDBACK_CREATED_ON := apex_util.get_since(c1.created_on);',
'   :P8014_FEEDBACK_CREATED_BY := c1.created_by;',
'   :P8014_FEEDBACK := c1.FEEDBACK_COMMENT;',
'   :P8014_APPLICATION := c1.application_id||'' - ''||c1.application_name;',
'   :P8014_PAGE := c1.page_id||'' - ''||c1.page_name;',
'end loop;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(120760307864569479.4651)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_FEEDBACK_FOLLOWUP'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_FEEDBACK_FOLLOWUP'
,p_attribute_03=>'P8014_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('Acci\00F3n procesada.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(120760503471569480.4651)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'8014'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(120757089022569465.4651)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(761803538295376901.4651)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'New'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(976558582481280674.4651)
,p_process_sequence=>60
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close on Cancel'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(976558551665280673.4651)
);
end;
/
prompt --application/pages/page_08800
begin
wwv_flow_api.create_page(
 p_id=>8800.4651
,p_user_interface_id=>wwv_flow_api.id(11475107821842402.4651)
,p_name=>unistr('Resultados de la B\00FAsqueda')
,p_step_title=>unistr('Resultados de la B\00FAsqueda')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(643947460795988298.4651)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'teamdev.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(197511195707906544.4651)
,p_plug_name=>unistr('Resultados de la B\00FAsqueda')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(684869836739871122.4651)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select y.component_name component_type,',
'       x.name,',
'       x.component_owner,',
'       x.release,',
'       x.tags,',
'       x.created_on,',
'       x.created_by,',
'       x.updated_on,',
'       x.updated_by,',
'       x.id,',
'       x.edit_link,',
'       x.component_id',
'from',
'(',
'select ''Feature''     component_type,',
'       FEATURE_NAME  name,',
'       FEATURE_OWNER component_owner,',
'       RELEASE       RELEASE,',
'       FEATURE_TAGS  tags,',
'       created_on    created_on,',
'       created_by    created_by,',
'       updated_on    updated_on,',
'       updated_by    updated_by,',
'       id            id,',
'       feature_id    component_id,',
'       apex_util.prepare_url(''f?p=4800:9001:''||:app_session||'':::9001:P9001_ID:''||id) edit_link',
'from wwv_flow_features',
'where security_group_id = :flow_security_group_id',
'union all',
'select ''Milestone''   component_type,',
'       event_NAME    name,',
'       event_OWNER   component_owner,',
'       RELEASE       RELEASE,',
'       tags          tags,',
'       created_on    created_on,',
'       created_by    created_by,',
'       updated_on    updated_on,',
'       updated_by    updated_by,',
'       id            id,',
'       event_id      component_id,',
'       apex_util.prepare_url(''f?p=4800:6001:''||:app_session||'':::6001:P6001_ID:''||id) edit_link',
'from WWV_FLOW_EVENTS',
'where security_group_id = :flow_security_group_id',
'union all',
'select ''Feedback''                      component_type,',
'       substr(FEEDBACK_COMMENT,1,100)  name,',
'       lower(CREATED_BY )              component_owner,',
'       null           RELEASE,',
'       tags           tags,',
'       created_on     created_on,',
'       created_by     created_by,',
'       updated_on     updated_on,',
'       updated_by     updated_by,',
'       id             id,',
'       feedback_id    component_id,',
'       apex_util.prepare_url(''f?p=&APP_ID.:8001:''||:app_session||'':::8001:P8001_ID:''||id) edit_link',
'from WWV_FLOW_FEEDBACK',
'where security_group_id = :flow_security_group_id',
'union all',
'select ''Todo''        component_type,',
'       TASK_NAME     name,',
'       ASSIGNED_TO   component_owner,',
'       RELEASE       RELEASE,',
'       TASK_TAGS     tags,',
'       created_on    created_on,',
'       created_by    created_by,',
'       updated_on    updated_on,',
'       updated_by    updated_by,',
'       id            id,',
'       FRIENDLY_ID   component_id,',
'       apex_util.prepare_url(''f?p=4800:3010:''||:app_session||'':::3010:P3010_ID:''||id) edit_link',
'from WWV_FLOW_TASKS',
'where security_group_id = :flow_security_group_id',
'union all',
'select ''Bug''          component_type,',
'       BUG_TITLE      name,',
'       ASSIGNED_TO    component_owner,',
'       FIX_BY_RELEASE RELEASE,',
'       TAGS           tags,',
'       created_on     created_on,',
'       created_by     created_by,',
'       updated_on     updated_on,',
'       updated_by     updated_by,',
'       bug_id         component_id,',
'       id             id,',
'       apex_util.prepare_url(''f?p=4800:3502:''||:app_session||'':::3502:P3502_ID:''||id) edit_link',
'from WWV_FLOW_BUGS',
'where security_group_id = :flow_security_group_id',
'union all',
'select ''Link''         component_type,',
'       link_name      name,',
'       lower(created_by)    component_owner,',
'       null           RELEASE,',
'       TAGS           tags,',
'       created_on     created_on,',
'       created_by     created_by,',
'       updated_on     updated_on,',
'       updated_by     updated_by,',
'       id             component_id,',
'       id             id,',
'       apex_util.prepare_url(''f?p=4800:5001:''||:app_session||'':::5001:P5001_ID:''||id) edit_link',
'from WWV_FLOW_LINKS',
'where security_group_id = :flow_security_group_id',
') x,',
'(select component_type, component_name ',
'from (',
'select ''Feature'' component_type, wwv_flow_lang.system_message(''FEATURE'') component_name ',
'from dual ',
'union all',
'select ''Milestone'' component_type,wwv_flow_lang.system_message(''MILESTONE'') component_name ',
'from dual ',
'union all',
'select ''Feedback'' component_type, wwv_flow_lang.system_message(''FEEDBACK'') component_name ',
'from dual ',
'union all',
'select ''Bug'' component_type,wwv_flow_lang.system_message(''BUG'') component_name ',
'from dual ',
'union all',
'select ''Todo'' component_type,wwv_flow_lang.system_message(''TODO'') component_name ',
'from dual',
'union all',
'select ''Link'' component_type,wwv_flow_lang.system_message(''LINK'') component_name ',
'from dual',
')) y',
'where x.component_type = y.component_type',
''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(197511303130906544.4651)
,p_name=>'Search Results'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('Esta consulta devuelve m\00E1s de 10.000 filas, filtre los datos para asegurar resultados completos.')
,p_no_data_found_message=>unistr('No se ha encontrado ning\00FAn dato.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(449403495757643294.4651)
,p_db_column_name=>'COMPONENT_ID'
,p_display_order=>1
,p_column_identifier=>'L'
,p_column_label=>unistr('N\00FAmero')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197511489172906554.4651)
,p_db_column_name=>'COMPONENT_TYPE'
,p_display_order=>2
,p_column_identifier=>'A'
,p_column_label=>'Componente'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197511581080906558.4651)
,p_db_column_name=>'NAME'
,p_display_order=>3
,p_column_identifier=>'B'
,p_column_label=>'Nombre'
,p_column_link=>'#EDIT_LINK#'
,p_column_linktext=>'#NAME#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197511697263906559.4651)
,p_db_column_name=>'COMPONENT_OWNER'
,p_display_order=>4
,p_column_identifier=>'C'
,p_column_label=>'Propietario'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197511801509906560.4651)
,p_db_column_name=>'RELEASE'
,p_display_order=>5
,p_column_identifier=>'D'
,p_column_label=>unistr('Versi\00F3n')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197512609590931874.4651)
,p_db_column_name=>'TAGS'
,p_display_order=>6
,p_column_identifier=>'E'
,p_column_label=>'Etiquetas'
,p_column_type=>'STRING'
,p_rpt_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct tag ',
'from WWV_FLOW_TEAM_TAGS ',
'where security_group_id = :flow_security_group_id ',
'order by 1'))
,p_rpt_show_filter_lov=>'C'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197512786088953447.4651)
,p_db_column_name=>'ID'
,p_display_order=>7
,p_column_identifier=>'F'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197512892867953448.4651)
,p_db_column_name=>'EDIT_LINK'
,p_display_order=>8
,p_column_identifier=>'G'
,p_column_label=>'Editar enlace'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197516779996036851.4651)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>9
,p_column_identifier=>'H'
,p_column_label=>'Creado'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197519578489102597.4651)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>10
,p_column_identifier=>'I'
,p_column_label=>'Creado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197519698782102598.4651)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>11
,p_column_identifier=>'J'
,p_column_label=>'Actualizado el'
,p_column_type=>'DATE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(197519784454102599.4651)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>12
,p_column_identifier=>'K'
,p_column_label=>'Actualizado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(448858386907284338.4651)
,p_plug_name=>unistr('iconos de navegaci\00F3n')
,p_region_name=>'apex-control-icons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(415202027252589471.4651)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(183873395194737719.4651)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(216948000482610776.4651)
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(705089418208070577.4651)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(197511195707906544.4651)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(411369261610169638.4651)
,p_button_image_alt=>'Restablecer'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:8800:&SESSION.::&DEBUG.:RP,RIR,8800:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(199296504277348025.4651)
,p_branch_action=>'f?p=&APP_ID.:8800:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(197513896870984997.4651)
,p_computation_sequence=>10
,p_computation_item=>'F4800_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'8800'
);
end;
/
prompt --application/end_environment
begin
wwv_flow_api.import_end(p_auto_install_sup_obj => nvl(wwv_flow_application_install.get_auto_install_sup_obj, false));
commit;
end;
/
set verify on feedback on define on
prompt  ...done
