prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4851
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4851 - Oracle APEX RESTful Services
--
-- Application Export:
--   Application:     4851
--   Name:            Oracle APEX RESTful Services
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                     37
--       Items:                  171
--       Computations:            22
--       Validations:             40
--       Processes:               69
--       Regions:                135
--       Buttons:                107
--       Dynamic Actions:         41
--     Shared Components:
--       Logic:
--         Items:                 10
--         Processes:             13
--         Computations:           9
--         Build Options:          2
--       Navigation:
--         Lists:                  8
--         Breadcrumbs:            1
--           Entries:             32
--         NavBar Entries:         3
--       Security:
--         Authentication:         1
--         Authorization:         12
--       User Interface:
--         Templates:
--           Page:                14
--           Region:              33
--           Label:               10
--           List:                12
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           2
--           Button:              11
--           Report:              10
--         LOVs:                  26
--         Shortcuts:              2
--         Plug-ins:              13
--       Globalization:
--         Messages:              25
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX RESTful Services')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286633465071938135')
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20191024135357'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'es'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(540039604917681918.4851)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'S'
,p_deep_linking=>'Y'
,p_security_scheme=>wwv_flow_api.id(803273801918815227)
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'MSG_LANGUAGE'
,p_substitution_value_01=>'Idioma'
,p_substitution_string_02=>'MSG_USER'
,p_substitution_value_02=>'Usuario'
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>'Espacio de Trabajo: &COMPANY.'
,p_substitution_string_04=>'WS_APP_OWNER'
,p_substitution_value_04=>'APEX_050200'
,p_substitution_string_05=>'DELETE_MSG'
,p_substitution_value_05=>unistr('\00BFDesea realizar esta acci\00F3n de supresi\00F3n?')
,p_substitution_string_06=>'PRODUCT_TYPE'
,p_substitution_value_06=>unistr('Hojas de C\00E1lculo Web')
,p_substitution_string_07=>'PRODUCT_NAME'
,p_substitution_value_07=>'Application Express'
,p_substitution_string_08=>'HELP'
,p_substitution_value_08=>'Ayuda'
,p_substitution_string_09=>'EDIT'
,p_substitution_value_09=>'Editar'
,p_substitution_string_10=>'MSG_COPYRIGHT'
,p_substitution_value_10=>'Copyright &copy; 1999, 2019, Oracle. Todos los derechos reservados.'
,p_substitution_string_11=>'DATE_FORMAT'
,p_substitution_value_11=>'dd/mm/rr'
,p_substitution_string_12=>'CLOSE'
,p_substitution_value_12=>'Cerrar'
,p_substitution_string_13=>'CONFIRM'
,p_substitution_value_13=>'Confirmar'
,p_substitution_string_14=>'MSG_JSCRIPT'
,p_substitution_value_14=>'Debe ejecutar este producto con JavaScript activado.'
,p_substitution_string_15=>'TOP'
,p_substitution_value_15=>'Superior'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141419'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/restful_serivice_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(510815015887059019.4851)
,p_name=>'RESTful Serivice List'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(510815374112073189.4851)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Servicios RESTful basados en APEX'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'sample-apex'
,p_list_text_01=>'Ver y migrar servicios RESTful basados en APEX al repositorio REST de ORDS.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(510815684261079572.4851)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Servicios RESTful basados en ORDS'
,p_list_item_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.::P0_SELECTED_NODE:RS-10:'
,p_list_item_icon=>'icon-rest-services'
,p_list_text_01=>'Crear y gestionar servicios RESTful con el repositorio basado en ORDS.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/restful_services_home_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(604619958834115055.4851)
,p_name=>'RESTful Services Home Page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(604620111019115066.4851)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Crear un Servicio Nuevo RESTful'
,p_list_item_link_target=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:RP,3:::'
,p_list_item_icon=>'icon-check-circle'
,p_list_text_01=>'Empiece a crear su primer servicio RESTful en &PRODUCT_NAME..'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(604620558191115068.4851)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Instalar un Servicio RESTful de Ejemplo'
,p_list_item_link_target=>'javascript:apex.submit({request:''RESET_SAMPLE_DATA''});'
,p_list_item_icon=>'icon-util-install'
,p_list_text_01=>unistr('Instale nuestro ejemplo Servicios RESTful de Ejemplo de demostraci\00F3n.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697672714234539780.4851)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697672931942539782.4851)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('Administraci\00F3n')
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697673242694539782.4851)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697673509734539782.4851)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'Gestionar Servicio'
,p_security_scheme=>wwv_flow_api.id(852575108977939507)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697673887665539782.4851)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Gestionar Servicio'
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697673509734539782.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697674127826539782.4851)
,p_list_item_display_sequence=>215
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(697673509734539782.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697674400346539783.4851)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'Realizar una Solicitud de Servicio'
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(697673509734539782.4851)
,p_security_scheme=>wwv_flow_api.id(852575108977939507)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697674737416539784.4851)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Definir Preferencias de Espacio de Trabajo'
,p_list_item_link_target=>'f?p=4350:17:&SESSION.::NO:RP::'
,p_parent_list_item_id=>wwv_flow_api.id(697673509734539782.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697675002004539785.4851)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Editar Anuncio'
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697673509734539782.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697675352821539785.4851)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>'Uso de Espacio de Trabajo'
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697673509734539782.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697675698018539786.4851)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Gestionar Usuarios y Grupos'
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(852575108977939507)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697675965880539786.4851)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Supervisar Actividad'
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(10759203169791179)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697676290030539786.4851)
,p_list_item_display_sequence=>500
,p_list_item_link_text=>'Paneles de Control'
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(10759203169791179)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1250965925147232831.4851)
,p_list_item_display_sequence=>600
,p_list_item_link_text=>unistr('Cambiar Mi Contrase\00F1a')
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_security_scheme=>wwv_flow_api.id(10759203169791179)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697677732086541316.4851)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697677972603541317.4851)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Documentaci\00F3n')
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2105957308761058240.4851)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Foro de Discusi\00F3n')
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2185502966910586903.4851)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Oracle Technology Network'
,p_list_item_link_target=>'http://otn.oracle.com/apex'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697678894738541317.4851)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697679129392541317.4851)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Acerca de'
,p_list_item_link_target=>'f?p=4350:9:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(719172975581246435.4851)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Creador de Aplicaciones'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW::'
,p_list_item_icon_alt_attribute=>'Aumentar Detalle de Creador de Aplicaciones'
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_api.id(6685808796641112)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719173467509246436.4851)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Aplicaciones de Base de Datos'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:DATABASE:'
,p_parent_list_item_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719173722390246436.4851)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('Aplicaciones de Hoja de C\00E1lculo Web')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:WEBSHEET:'
,p_parent_list_item_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719174096423246437.4851)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719174338146246437.4851)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Crear'
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID:'
,p_parent_list_item_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719174652049246437.4851)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Importar'
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719174913009246437.4851)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Exportar'
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719175228969246437.4851)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719175552037246438.4851)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Utilidades del Espacio de Trabajo'
,p_parent_list_item_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719175891312246438.4851)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>'Todas las Utilidades del Espacio de Trabajo'
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719175552037246438.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719176144909246438.4851)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719175552037246438.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719176402390246438.4851)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>'Valores por Defecto del Creador de Aplicaciones'
,p_list_item_link_target=>'f?p=4000:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719175552037246438.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719176704666246438.4851)
,p_list_item_display_sequence=>164
,p_list_item_link_text=>'Gestionar Noticias'
,p_list_item_link_target=>'f?p=4800:7000:&SESSION.:'
,p_parent_list_item_id=>wwv_flow_api.id(719175552037246438.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719177037967246438.4851)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>'Temas de Espacio de Trabajo'
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719175552037246438.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719177364622246439.4851)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>'Grupos de Aplicaciones'
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_api.id(719175552037246438.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719177622562246439.4851)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>'Vistas de &PRODUCT_NAME.'
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719175552037246438.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719177921227246439.4851)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>unistr('Informes de Aplicaci\00F3n Cruzados')
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719175552037246438.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719178248125246439.4851)
,p_list_item_display_sequence=>169
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719178543463246439.4851)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Migraciones'
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719173110379246436.4851)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719178829971246440.4851)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'Taller de SQL'
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>'Aumentar Detalle de Taller de SQL'
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_api.id(6685907847641114)
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719179191283246440.4851)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Explorador de Objetos'
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719178829971246440.4851)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719179422661246440.4851)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'Comandos SQL'
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719178829971246440.4851)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719179772704246442.4851)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Scripts SQL'
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719178829971246440.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Utilidades'
,p_parent_list_item_id=>wwv_flow_api.id(719178829971246440.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719180367219246442.4851)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>'Todas las Utilidades'
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719180648018246442.4851)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719180966936246443.4851)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>'Taller de Datos'
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719181251634246443.4851)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>'Generador de Consultas'
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713697957161458429.4851)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>unistr('SQL r\00E1pido')
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(671559325166058450.4851)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>'Juegos de datos de ejemplo'
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719181595820246443.4851)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>'Generar DDL'
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719181851272246443.4851)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>'Valores por Defecto de Interfaz de Usuario'
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719183394998246444.4851)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>unistr('Comparaci\00F3n de Esquema')
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719182177219246443.4851)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('M\00E9todos de las Tablas')
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719183663877246444.4851)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>'Papelera de Reciclaje'
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719182775397246444.4851)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>'Informes de Objeto'
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719182443645246443.4851)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>'Acerca de la Base de Datos'
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719183082670246444.4851)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>'Control de Base de Datos'
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(719180043659246442.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719183987271246444.4851)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>'Servicios RESTful'
,p_list_item_link_target=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719178829971246440.4851)
,p_security_scheme=>wwv_flow_api.id(803273801918815227)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719184267590246444.4851)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Desarrollo de Equipos'
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>'Aumentar Detalle de Desarrollo de Equipos'
,p_list_text_01=>'tab-team-dev'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719184545609246444.4851)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>'Etiquetas'
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719184267590246444.4851)
,p_security_scheme=>wwv_flow_api.id(852581401782939524)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719184871457246444.4851)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'Hitos'
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719184267590246444.4851)
,p_security_scheme=>wwv_flow_api.id(852581401782939524)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719185125506246444.4851)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>'Plantillas'
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719184267590246444.4851)
,p_security_scheme=>wwv_flow_api.id(852581401782939524)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719185476979246445.4851)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>'Utilidades'
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719184267590246444.4851)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719186065984246445.4851)
,p_list_item_display_sequence=>355
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719184267590246444.4851)
,p_security_scheme=>wwv_flow_api.id(852581401782939524)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719186321307246445.4851)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>'Comentarios'
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719184267590246444.4851)
,p_security_scheme=>wwv_flow_api.id(852581401782939524)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719190530504246449.4851)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('Galer\00EDa de aplicaciones')
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_text_01=>'tab-apps'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719190862410246449.4851)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>'Aplicaciones de Productividad'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:PACKAGE'
,p_parent_list_item_id=>wwv_flow_api.id(719190530504246449.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719191141951246449.4851)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>'Aplicaciones de Ejemplo'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:SAMPLE'
,p_parent_list_item_id=>wwv_flow_api.id(719190530504246449.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(780161561916374627.4851)
,p_list_item_display_sequence=>425
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719190530504246449.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719191421386246450.4851)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>unistr('Administraci\00F3n')
,p_list_item_link_target=>'f?p=4750:6:&SESSION.::&DEBUG.:6:'
,p_parent_list_item_id=>wwv_flow_api.id(719190530504246449.4851)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/icon_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(873550610677863830.4851)
,p_name=>'icon navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(873550831158863831.4851)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Explorador de Objetos'
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_list_item_icon=>'htmldb/icons/ob_browser.gif'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(873551124330863831.4851)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Comandos SQL'
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_list_item_icon=>'htmldb/icons/sqlcmd.gif'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(873551403588863831.4851)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Scripts SQL'
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_list_item_icon=>'htmldb/icons/sqlscrpt.gif'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(873831932541898524.4851)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Generador de Consultas'
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_list_item_icon=>'htmldb/icons/qbuilder.gif'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(873551715997863831.4851)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Utilidades'
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_list_item_icon=>'htmldb/icons/shared_comp_small.gif'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(873552006687863831.4851)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Servicios RESTful'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/dbservice.png'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/rest_privs_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1493530200311490901.4851)
,p_name=>'REST_PRIVS_LIST'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3144413854938363873.4851)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Privilegios del Servicio RESTful'
,p_list_item_link_target=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1493530405217490901.4851)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Registro de Cliente'
,p_list_item_link_target=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:RIR:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'GROUPS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1646563629182384932.4851)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Aprobaciones del Servicio RESTful'
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2488269555599673580.4851)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Exportar'
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:2:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1  from WWV_FLOW_RT$MODULES',
'where SECURITY_GROUP_ID = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2498818148769125606.4851)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Importar'
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:5:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(366350517809482707.4851)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Restablecer Datos de Ejemplo'
,p_list_item_link_target=>'javascript:apex.submit({request:''RESET_SAMPLE_DATA''});'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1  from WWV_FLOW_RT$MODULES',
'where SECURITY_GROUP_ID = :flow_security_group_id'))
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/approval_updates
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1655184530741291898.4851)
,p_name=>'Approval_Updates'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1655184723489291899.4851)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Aprobaciones'
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:RIR,CIR:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1655185011991291900.4851)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Actualizar Varias Aprobaciones'
,p_list_item_link_target=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:RIR,CIR:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1151747999346335.4851)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2111722406411941.4851)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859207420941042.4851)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(92013235259572466.4851)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765073360593712056.4851)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780697822994156.4851)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917672636565940088.4851)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(6685808796641112.4851)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('No tiene privilegios para realizar esta operaci\00F3n')
,p_reference_id=>786516029127697713.4851
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(6685907847641114.4851)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('No tiene privilegios para realizar esta operaci\00F3n')
,p_reference_id=>786516265251697717.4851
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(6686010157641115.4851)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>'No se ha activado el desarrollo de equipos para este espacio de trabajo'
,p_reference_id=>786516861027697723.4851
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(6686108619641115.4851)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('No tiene privilegios para realizar esta operaci\00F3n')
,p_reference_id=>786517166823697723.4851
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(10759203169791179.4851)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>unistr('No est\00E1 autorizado para acceder a los paneles de control y la actividad de supervisi\00F3n.')
,p_reference_id=>786936829326142579.4851
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/ords_access_allowed
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(538579044595390057.4851)
,p_name=>'ORDS_ACCESS_ALLOWED'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_min_ver_met varchar2(10) := ''FALSE'';',
'begin ',
'    l_min_ver_met := wwv_flow_rest_ws.ords_min_ver_met(p_current_version => wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema));',
'    --',
'    if l_min_ver_met = ''TRUE'' then ',
'       return TRUE; ',
'    else',
'       return FALSE;',
'    end if;',
'end;'))
,p_error_message=>unistr('La secci\00F3n ORDS del taller REST no est\00E1 disponible. Es probable que la causa sea que la versi\00F3n de ORDS sea inferior a la requerida.')
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_access_allowed
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(538586328567551330.4851)
,p_name=>'APEX_ACCESS_ALLOWED'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- This has been commented out for the time being as we don''t want to limit access until it has been ',
'-- decided that APEX REST will be deprecated',
'--',
'--declare ',
'--    l_ords_is_18       varchar2(10) := ''FALSE'';',
'--',
'--begin ',
'--    ',
'--    l_ords_is_18 := wwv_flow_rest_ws.ords_is_18_plus(p_current_version => wwv_flow_rest_ws.get_ord_version);    ',
'--    -- ',
'--    if l_ords_is_18 = ''TRUE'' then ',
'--       return FALSE; ',
'--    else ',
'--       return TRUE;',
'--    end if;',
'--end;',
'RETURN TRUE;'))
,p_error_message=>unistr('La secci\00F3n APEX del taller REST no est\00E1 disponible al ejecutar la versi\00F3n 18 y versiones posteriores de ORDS.')
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_packaged_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(763730718028679365.4851)
,p_name=>'APEX 5.0 Packaged App Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'    for c1 in (select 1 from wwv_flow_companies w',
'                     where nvl(w.ALLOW_PACKAGED_APP_INS_YN,''Y'') = ''Y'' ',
'                         and w.PROVISIONING_COMPANY_ID = :flow_security_group_id) ',
'    loop',
'        return',
'            ( wwv_flow_authorization.is_authorized_developer(',
'                  p_developer_authorization => ''ADMIN''',
'            )',
'           or wwv_flow_authorization.is_authorized_developer(',
'                    p_developer_authorization => ''EDIT''',
'           ) and wwv_flow_platform.get_preference(''PKG_APP_ENABLED'') = ''Y'' );',
'',
'    end loop;',
'    return false;',
'end;'))
,p_error_message=>unistr('No tiene privilegios para realizar esta operaci\00F3n')
,p_reference_id=>786517456817697723.4851
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(803273801918815227.4851)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>unistr('No tiene privilegios para realizar esta operaci\00F3n')
,p_reference_id=>786519856057734816.4851
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(852575108977939507.4851)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>unistr('No est\00E1 autorizado para administrar las aplicaciones')
,p_reference_id=>12511219858301010.4851
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(852581401782939524.4851)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('No est\00E1 autorizado para editar aplicaciones')
,p_reference_id=>12480509677812756.4851
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(873288123790839255.4851)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>unistr('SSO de creador no est\00E1 activado')
,p_reference_id=>6738410669854771.4851
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(872399403957776718.4851)
,p_icon_sequence=>1
,p_icon_image=>'Workspace &COMPANY.'
,p_icon_subtext=>'Espacio de Trabajo de &COMPANY.'
,p_icon_target=>'#'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(873191312015835823.4851)
,p_icon_sequence=>2
,p_icon_subtext=>'( <span style="text-decoration:underline;">Cambiar Espacio de Trabajo</span> )'
,p_icon_target=>'f?p=4550:20'
,p_icon_image_alt=>'Cambiar Espacio de Trabajo'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
,p_security_scheme=>wwv_flow_api.id(873288123790839255)
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(6685705047641105.4851)
,p_icon_sequence=>99
,p_icon_subtext=>'( <span style="text-decoration:underline;">Desconectar</span> )'
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>'Desconectar'
,p_icon_height=>32
,p_icon_width=>32
,p_icon_height2=>24
,p_icon_width2=>24
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(110420270357243976.4851)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_schemas_collection
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(387283337600871893.4851)
,p_process_sequence=>5
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_SCHEMAS Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_SCHEMAS'');',
'    -- Loop through and fill the collection',
'    for m in (select id, parsing_schema, type, pattern, status, auto_rest_auth, ops_allowed, pre_hook',
'               from USER_ORDS_SCHEMAS)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_SCHEMAS'',',
'               p_n001 => m.id,                  ',
'               p_c001 => m.parsing_schema,              ',
'               p_c002 => m.type,           ',
'               p_c003 => m.pattern,',
'               p_c004 => m.status,',
'               p_c005 => m.auto_rest_auth,',
'               p_n002 => m.ops_allowed,',
'               p_c006 => m.pre_hook',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'        ',
'        ',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;',
'',
'',
'END;'))
,p_process_error_message=>'No se pueden recuperar los esquemas de ORDS disponibles.'
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_modules_collection
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(342554284537280704.4851)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_MODULES Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_MODULES'');',
'    -- Loop through and fill the collection',
'    for m in (select id, name, uri_prefix, items_per_page, status, comments, pre_hook, schema_id, created_by, created_on, updated_by, updated_on, origins_allowed',
'               from USER_ORDS_MODULES)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_MODULES'',',
'               p_n001 => m.id,                  ',
'               p_c001 => m.name,              ',
'               p_c002 => m.uri_prefix,           ',
'               p_n002 => m.items_per_page,',
'               p_c003 => m.status,',
'               p_c004 => m.comments, ',
'               p_c005 => m.pre_hook,',
'               p_c006 => m.origins_allowed,',
'               p_n005 => m.schema_id,',
'               p_c049 => m.created_by,',
'               p_d001 => m.created_on,',
'               p_c050 => m.updated_by,',
'               p_d002 => m.updated_on',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'        ',
'        ',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;',
'',
'',
'END;'))
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_templates_collection
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(342554481588284030.4851)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_TEMPLATES collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'    APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_TEMPLATES'');',
'    -- Loop through and fill the collection',
'    for t in (select id, module_id, uri_template, priority, etag_type, etag_query, comments, schema_id, created_by, created_on, updated_by, updated_on',
'               from USER_ORDS_TEMPLATES)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_TEMPLATES'',',
'               p_n001 => t.id, ',
'               p_n002 => t.module_id,',
'               p_c001 => t.uri_template, ',
'               p_n003 => t.priority,',
'               p_c002 => t.etag_type,',
'               p_c003 => t.etag_query,',
'               p_c004 => t.comments,',
'               p_n005 => t.schema_id,',
'               p_c049 => t.created_by,',
'               p_d001 => t.created_on,',
'               p_c050 => t.updated_by,',
'               p_d002 => t.updated_on',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;',
'',
'END;'))
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_handlers_collection
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(342555258750286853.4851)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_HANDLERS Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'    APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_HANDLERS'');',
'    -- Loop through and fill the collection',
'    for h in (select id, template_id, source_type, method, mimes_allowed, items_per_page, source, comments, schema_id, created_by, created_on, updated_by, updated_on',
'               from USER_ORDS_HANDLERS)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_HANDLERS'',',
'               p_n001 => h.id, ',
'               p_n002 => h.template_id, ',
'               p_c001 => h.source_type,',
'               p_c002 => h.method,',
'               p_c003 => h.mimes_allowed,',
'               p_n003 => h.items_per_page,',
'               p_clob001 => h.source,',
'               p_c004 => h.comments,',
'               p_n005 => h.schema_id,',
'               p_c049 => h.created_by,',
'               p_d001 => h.created_on,',
'               p_c050 => h.updated_by,',
'               p_d002 => h.updated_on',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLCODE ||'' : ''||SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'        ',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;    ',
'',
'END;'))
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_parameters_collection
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(342902393800317708.4851)
,p_process_sequence=>40
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_PARAMETERS Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'    APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_PARAMETERS'');',
'    -- Loop through and fill the collection',
'    for p in (select id, handler_id, name,bind_variable_name, source_type, access_method, param_type, comments, schema_id, created_by, created_on, updated_by, updated_on',
'               from USER_ORDS_PARAMETERS)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_PARAMETERS'',',
'               p_n001 => p.id, ',
'               p_n002 => p.handler_id, ',
'               p_c001 => p.name,',
'               p_c002 => p.bind_variable_name,',
'               p_c003 => p.source_type,',
'               p_c004 => p.access_method,',
'               p_c005 => p.param_type,',
'               p_c006 => p.comments,',
'               p_n005 => p.schema_id,',
'               p_c049 => p.created_by,',
'               p_d001 => p.created_on,',
'               p_c050 => p.updated_by,',
'               p_d002 => p.updated_on',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'   ',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;',
'',
'END;'))
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_privileges_collection
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(342902617244328148.4851)
,p_process_sequence=>50
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_PRIVILEGES Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'    APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_PRIVILEGES'');',
'    -- Loop through and fill the collection',
'    for p in (select id, label, name, comments, description, schema_id, created_by, created_on, updated_by, updated_on',
'               from USER_ORDS_PRIVILEGES)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_PRIVILEGES'',',
'               p_n001 => p.id, ',
'               p_c001 => p.label,',
'               p_c002 => p.name,',
'               p_c003 => p.comments,',
'               p_c004 => p.description,',
'               p_n005 => p.schema_id,',
'               p_c049 => p.created_by,',
'               p_d001 => p.created_on,',
'               p_c050 => p.updated_by,',
'               p_d002 => p.updated_on',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'        ',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;',
'    ',
'END;'))
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_roles_collection
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(342902880674332236.4851)
,p_process_sequence=>60
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_ROLES Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'    APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_ROLES'');',
'    -- Loop through and fill the collection',
'    for p in (select id, name, schema_id, created_by, created_on, updated_by, updated_on',
'               from USER_ORDS_ROLES)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_ROLES'',',
'               p_n001 => p.id, ',
'               p_c001 => p.name,',
'               p_n005 => p.schema_id,',
'               p_c049 => p.created_by,',
'               p_d001 => p.created_on,',
'               p_c050 => p.updated_by,',
'               p_d002 => p.updated_on',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;',
'END;'))
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_enabled_objects_collections
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(387286517798930675.4851)
,p_process_sequence=>70
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_ENABLED_OBJECTS collections'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_ENABLED_OBJECTS'');',
'    -- Loop through and fill the collection',
'    for m in (select id, schema_id, parsing_schema, parsing_object, object_alias, type, status, auto_rest_auth, ops_allowed, type_path, pre_hook',
'               from USER_ORDS_ENABLED_OBJECTS)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_ENABLED_OBJECTS'',',
'               p_n001 => m.id, ',
'               p_n002 => m.schema_id,',
'               p_c001 => m.parsing_schema,',
'               p_c002 => m.parsing_object,',
'               p_c003 => m.object_alias,',
'               p_c004 => m.type,',
'               p_c005 => m.status,',
'               p_c006 => m.auto_rest_auth,',
'               p_n003 => m.ops_allowed,',
'               p_c007 => m.type_path,',
'               p_c008 => m.pre_hook',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'        ',
'        ',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;',
'',
'',
'END;'))
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_privilege_roles_collection
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(395762687572540683.4851)
,p_process_sequence=>80
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_PRIVILEGE_ROLES Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_PRIVILEGE_ROLES'');',
'    -- Loop through and fill the collection',
'    for m in (select privilege_id, privilege_name, role_id, role_name',
'               from USER_ORDS_privilege_roles)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_PRIVILEGE_ROLES'',',
'               p_n001 => m.privilege_id, ',
'               p_c001 => m.privilege_name,',
'               p_n002 => m.role_id,',
'               p_c002 => m.role_name',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'        ',
'        ',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;',
'',
'',
'END;'))
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_privilege_modules
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(395763036035566814.4851)
,p_process_sequence=>90
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_PRIVILEGE_MODULES'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_PRIVILEGE_MODULES'');',
'    -- Loop through and fill the collection',
'    for m in (select privilege_id, privilege_name, module_id, module_name',
'               from USER_ORDS_privilege_modules)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_PRIVILEGE_MODULES'',',
'               p_n001 => m.privilege_id, ',
'               p_c001 => m.privilege_name,',
'               p_n002 => m.module_id,',
'               p_c002 => m.module_name',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'        ',
'        ',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;',
'',
'',
'END;'))
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/load_ords_privilege_mappings
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(395763867379598393.4851)
,p_process_sequence=>100
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_PRIVILEGE_MAPPINGS'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_PRIVILEGE_MAPPINGS'');',
'    -- Loop through and fill the collection',
'    for m in (select rowid ID, privilege_id, name, pattern',
'               from USER_ORDS_PRIVILEGE_MAPPINGS)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_PRIVILEGE_MAPPINGS'',',
'               p_n001 => m.privilege_id,',
'               p_c003 => m.id,',
'               p_c001 => m.name,',
'               p_c002 => m.pattern',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'        ',
'        ',
'if l_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_return);',
'END IF;',
'',
'',
'END;'))
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(234081675618075338.4851)
,p_process_sequence=>999
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'    p_app_id           => wwv_flow.g_x01,',
'    p_get_apps_list    => wwv_flow.g_x02);'))
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(1534926119072175978.4851)
,p_name=>'ACTIVE_NODE'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(872498331315784584.4851)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(6688329890650779.4851)
,p_name=>'FSP_AFTER_LOGIN_URL'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(619028059341783290.4851)
,p_name=>'G_HTTP_HOST'
,p_protection_level=>'I'
,p_item_comment=>'HTTP Host from the CGI ENV'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(342543249375838636.4851)
,p_name=>'G_ORDS_PAGES'
,p_protection_level=>'I'
,p_item_comment=>'List of pages where we want the ORDS tree to appear'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(619027817002780643.4851)
,p_name=>'G_PROTOCOL'
,p_protection_level=>'I'
,p_item_comment=>'The Protocol (http or https) that is being used to access APEX (and therefore ORDS RESTful services)'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(619028934552791108.4851)
,p_name=>'G_SCHEMA_ALIAS'
,p_protection_level=>'I'
,p_item_comment=>'Schema alias - used to build ORDS URLS'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(619028747767787342.4851)
,p_name=>'G_SCRIPT_NAME'
,p_protection_level=>'I'
,p_item_comment=>'SCRIPT_NAME from cgi_env - Used to build ORDS URLS'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(511289752140240918.4851)
,p_name=>'MIN_ORDS_VERSION'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(511289541307239726.4851)
,p_name=>'REPO_ORDS_VERSION'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(619030612276813903.4851)
,p_computation_sequence=>10
,p_computation_item=>'G_SCHEMA_ALIAS'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'QUERY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  select c003',
'    from wwv_flow_collections',
'   where collection_name = ''ORDS_SCHEMAS'';',
''))
,p_computation_error_message=>'No se ha podido recuperar el alias de esquema para el esquema seleccionado actualmente'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(511290384160259564.4851)
,p_computation_sequence=>3
,p_computation_item=>'MIN_ORDS_VERSION'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_min_ords_version  varchar2(255);',
'BEGIN ',
'    l_min_ords_version := wwv_flow_rest_ws.c_ords_major||''.''||',
'                          wwv_flow_rest_ws.c_ords_minor||''.''||',
'                          wwv_flow_rest_ws.c_ords_patch||''.''||',
'                          wwv_flow_rest_ws.c_ords_day||''.0.0'';',
'    return l_min_ords_version;',
'',
'END;',
''))
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(872544309629787776.4851)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>'No se ha podido calcular el nombre del espacio de trabajo.'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(538556025090330445.4851)
,p_computation_sequence=>1
,p_computation_item=>'P0_SCHEMA'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_user_api.get_default_schema'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(511290164367246038.4851)
,p_computation_sequence=>2
,p_computation_item=>'REPO_ORDS_VERSION'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'    l_schema    VARCHAR2(32767);',
'    l_ords_installed     NUMBER;',
'',
'BEGIN ',
'-- Check to see if there is an ORDS_METADATA SCHEMA ',
'select count(*)',
'  into l_ords_installed',
'  from all_users',
' where username = ''ORDS_METADATA'';',
'--',
'IF l_ords_installed > 0 THEN  ',
'    l_schema := nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema);',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'  l_schema  varchar2(255) := ''||l_schema||'';',
'  l_version varchar2(255);',
'BEGIN',
'  l_version := ords_metadata.ords.installed_version;  ',
'RETURN l_version;',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN ''0.0.0.0.0.0'';',
'END;  ',
'#'';',
'',
'--',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => l_schema',
'        );',
'        ',
'ELSE ',
'  l_return := ''0.0.0.0.0.0'';',
'END IF;',
'',
'return l_return;',
'END;'))
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(342543645888848725.4851)
,p_computation_sequence=>10
,p_computation_item=>'G_ORDS_PAGES'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>':100:110:120:130:140:150:160:170:180:190:200:'
,p_computation_comment=>'Make sure that each page is surrounded by : (i.e. :100:200:300: ) This is used to make sure that 100 and 1000 aren''t both caught by the pattern matching as the same thing.'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(619029707519802116.4851)
,p_computation_sequence=>10
,p_computation_item=>'G_HTTP_HOST'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'sys.owa_util.get_cgi_env(''HTTP_HOST'')'
,p_computation_error_message=>'No se puede calcular HTTP_HOST'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(619030458629806194.4851)
,p_computation_sequence=>10
,p_computation_item=>'G_PROTOCOL'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'sys.owa_util.get_cgi_env(''REQUEST_PROTOCOL'')'
,p_computation_error_message=>'No se ha podido calcular REQUEST PROTOCOL.'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(619030852128818077.4851)
,p_computation_sequence=>10
,p_computation_item=>'G_SCRIPT_NAME'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'sys.owa_util.get_cgi_env(''SCRIPT_NAME'')'
,p_computation_error_message=>'No se ha podido calcular SCRIPT NAME.'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/database_schemas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(948796511932598687.4851)
,p_lov_name=>'DATABASE SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4850L1 */ wwv_flow_escape.html(upper(c.schema)) d, upper(c.schema) v',
'from   wwv_flow_company_schemas c,',
'       wwv_flow_fnd_user u',
'where  c.security_group_id = :flow_security_group_id and',
'       u.security_group_id = :flow_security_group_id and',
'       u.user_name = :flow_user and',
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or',
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/etag_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(792100407834275994.4851)
,p_lov_name=>'ETAG_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(792100407834275994.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792100610608275996.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'HASH Seguro'
,p_lov_return_value=>'HASH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792100820783275997.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Consulta'
,p_lov_return_value=>'QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792101014833275997.4851)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Ninguno'
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/file_export_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(914883828990434889.4851)
,p_lov_name=>'FILE EXPORT TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(914883828990434889.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(914884011226434892.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Archivo XML'
,p_lov_return_value=>'XML'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(914884227962434893.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Script SQL'
,p_lov_return_value=>'SQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/handler
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(776540711317147315.4851)
,p_lov_name=>'HANDLER'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(method,''No method'') x, id',
'from wwv_flow_rt$handlers'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/handler_methods
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(793208615430277767.4851)
,p_lov_name=>'HANDLER_METHODS'
,p_lov_query=>'.'||wwv_flow_api.id(793208615430277767.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793208825198277771.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'GET'
,p_lov_return_value=>'GET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793209415292277772.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'POST'
,p_lov_return_value=>'POST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793209014774277772.4851)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'PUT'
,p_lov_return_value=>'PUT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793209204809277772.4851)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'DELETE'
,p_lov_return_value=>'DELETE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/handler_query_format
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(793264406688294176.4851)
,p_lov_name=>'HANDLER_QUERY_FORMAT'
,p_lov_query=>'.'||wwv_flow_api.id(793264406688294176.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793264622598294176.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'JSON'
,p_lov_return_value=>'DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793264825009294176.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'CSV'
,p_lov_return_value=>'CSV'
);
end;
/
prompt --application/shared_components/user_interface/lovs/handler_secure_access
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1488736008597865790.4851)
,p_lov_name=>'HANDLER_SECURE_ACCESS'
,p_lov_query=>'.'||wwv_flow_api.id(1488736008597865790.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1488736303736865793.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('S\00ED')
,p_lov_return_value=>'YES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1488736530845865794.4851)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No'
,p_lov_return_value=>'NO'
);
end;
/
prompt --application/shared_components/user_interface/lovs/handler_security
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(793284611321304933.4851)
,p_lov_name=>'HANDLER_SECURITY'
,p_lov_query=>'.'||wwv_flow_api.id(793284611321304933.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793284832075304933.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('P\00FAblico')
,p_lov_return_value=>'NONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793285017364304933.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Seguro'
,p_lov_return_value=>'SECURE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_iana_charset
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1671084505895948418.4851)
,p_lov_name=>'I18N_IANA_CHARSET'
,p_reference_id=>144796827445692396.4851
,p_lov_query=>'.'||wwv_flow_api.id(1671084505895948418.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671093901719948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Little Endian de Unicode UTF-16'
,p_lov_return_value=>'utf-16le'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671094124464948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Big Endian de Unicode UTF-16'
,p_lov_return_value=>'utf-16be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671094300393948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'US-ASCII'
,p_lov_return_value=>'us-ascii'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671094520466948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\00C1rabe (ISO-8859-6)')
,p_lov_return_value=>'iso-8859-6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671094700871948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\00C1rabe (Windows 1256)')
,p_lov_return_value=>'windows-1256'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671094921688948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Chino (Big5)'
,p_lov_return_value=>'big5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671095110740948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Chino (GBK)'
,p_lov_return_value=>'gbk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671095331933948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Cir\00EDlico (ISO-8859-5)')
,p_lov_return_value=>'iso-8859-5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671095502169948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Cir\00EDlico (KOI8-R)')
,p_lov_return_value=>'koi8-r'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671095705442948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Cir\00EDlico (KOI8-U)')
,p_lov_return_value=>'koi8-u'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671095932299948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Cir\00EDlico (Windows 1251)')
,p_lov_return_value=>'windows-1251'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671096121544948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Europeo Oriental (ISO-8859-2)'
,p_lov_return_value=>'iso-8859-2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671096329393948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Europeo Oriental (Windows 1250)'
,p_lov_return_value=>'windows-1250'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671096502409948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Griego (ISO-8859-7)'
,p_lov_return_value=>'iso-8859-7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671096725054948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Griego (Windows 1253)'
,p_lov_return_value=>'windows-1253'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671096913527948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hebreo (ISO-8859-8-i)'
,p_lov_return_value=>'iso-8859-8-i'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671097100860948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hebreo (Windows 1255)'
,p_lov_return_value=>'windows-1255'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671097315673948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Japon\00E9s (EUC)')
,p_lov_return_value=>'euc-jp'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671097520272948439.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Japon\00E9s (Shift JIS)')
,p_lov_return_value=>'shift_jis'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671097709314948440.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Coreano (EUC)'
,p_lov_return_value=>'euc-kr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671097923215948440.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Noreuropeo (ISO-8859-4)'
,p_lov_return_value=>'iso-8859-4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671098132735948440.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Noreuropeo (Windows 1257)'
,p_lov_return_value=>'windows-1257'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671098331088948440.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Sudeuropeo (ISO-8859-3)'
,p_lov_return_value=>'iso-8859-3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671098518496948441.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Tailand\00E9s (TIS-620)')
,p_lov_return_value=>'tis-620'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671098727107948441.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Turco (ISO-8859-9)'
,p_lov_return_value=>'iso-8859-9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671098918742948441.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Turco (Windows 1254)'
,p_lov_return_value=>'windows-1254'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671099131511948441.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode (UTF-8)'
,p_lov_return_value=>'utf-8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671099313041948441.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vietnamita (Windows 1258)'
,p_lov_return_value=>'windows-1258'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671099521679948441.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Europeo Occidental (ISO-8859-1)'
,p_lov_return_value=>'iso-8859-1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1671099704494948441.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Europeo Occidental (Windows 1252)'
,p_lov_return_value=>'windows-1252'
);
end;
/
prompt --application/shared_components/user_interface/lovs/methods
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(321119108469325958.4851)
,p_lov_name=>'METHODS'
,p_lov_query=>'.'||wwv_flow_api.id(321119108469325958.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(321119402415325959.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'PUT'
,p_lov_return_value=>'PUT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(321119614070325960.4851)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'GET'
,p_lov_return_value=>'GET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(321119810979325960.4851)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'POST'
,p_lov_return_value=>'POST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(321120019210325960.4851)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'DELETE'
,p_lov_return_value=>'DELETE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/modules
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(414537600634127531.4851)
,p_lov_name=>'MODULES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'from   wwv_flow_rt$modules',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/module_names
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1501629904585944475.4851)
,p_lov_name=>'MODULE_NAMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id d, name r',
'from   wwv_flow_rt$modules',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p3_handler_source_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1484087224479961236.4851)
,p_lov_name=>'P3_HANDLER_SOURCE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(1484087224479961236.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1484087529294961238.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Consulta'
,p_lov_return_value=>'QUERY'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P3_METHOD'
,p_lov_disp_cond2=>'GET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1484087728312961238.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Consultar Una Fila'
,p_lov_return_value=>'QUERY_1_ROW'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P3_METHOD'
,p_lov_disp_cond2=>'GET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1484087920223961238.4851)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Fuente'
,p_lov_return_value=>'FEED'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P3_METHOD'
,p_lov_disp_cond2=>'GET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1484088114901961238.4851)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'PL/SQL'
,p_lov_return_value=>'PLSQL'
,p_lov_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_lov_disp_cond=>'P3_METHOD'
,p_lov_disp_cond2=>'DELETE:POST:PUT:GET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1484088322527961238.4851)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Recurso de Medios'
,p_lov_return_value=>'MEDIA'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P3_METHOD'
,p_lov_disp_cond2=>'GET'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p9_handler_source_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(793236521795289048.4851)
,p_lov_name=>'P9_HANDLER_SOURCE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(793236521795289048.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793236700829289051.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Consulta'
,p_lov_return_value=>'QUERY'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P9_METHOD'
,p_lov_disp_cond2=>'GET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793236928620289051.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Consultar Una Fila'
,p_lov_return_value=>'QUERY_1_ROW'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P9_METHOD'
,p_lov_disp_cond2=>'GET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1438482126999310901.4851)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Fuente'
,p_lov_return_value=>'FEED'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P9_METHOD'
,p_lov_disp_cond2=>'GET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793237101153289052.4851)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'PL/SQL'
,p_lov_return_value=>'PLSQL'
,p_lov_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_lov_disp_cond=>'P9_METHOD'
,p_lov_disp_cond2=>'DELETE:POST:PUT:GET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793237329580289052.4851)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Recurso de Medios'
,p_lov_return_value=>'MEDIA'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P9_METHOD'
,p_lov_disp_cond2=>'GET'
);
end;
/
prompt --application/shared_components/user_interface/lovs/parameter_access
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(793423420718336071.4851)
,p_lov_name=>'PARAMETER_ACCESS'
,p_lov_query=>'.'||wwv_flow_api.id(793423420718336071.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793423630540336072.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'IN'
,p_lov_return_value=>'IN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793423817192336072.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'OUT'
,p_lov_return_value=>'OUT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_rt$handlers',
'where id = :P12_HANDLER_ID',
'and source_type = ''PLSQL''',
'and security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793424005083336072.4851)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'IN/OUT'
,p_lov_return_value=>'INOUT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_rt$handlers',
'where id = :P12_HANDLER_ID',
'and source_type = ''PLSQL''',
'and security_group_id = :flow_security_group_id'))
,p_lov_disp_cond2=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/parameter_source
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(793403203749331167.4851)
,p_lov_name=>'PARAMETER_SOURCE'
,p_lov_query=>'.'||wwv_flow_api.id(793403203749331167.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793403408340331167.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cabecera HTTP'
,p_lov_return_value=>'HEADER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1422794016916942828.4851)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Cuerpo de la Respuesta'
,p_lov_return_value=>'RESPONSE'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'V(''P12_ACCESS_METHOD'') = ''OUT'' or :APP_PAGE_ID = 9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793403609738331167.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'URI'
,p_lov_return_value=>'URI'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'V(''P12_ACCESS_METHOD'') = ''IN'' or :APP_PAGE_ID = 9'
);
end;
/
prompt --application/shared_components/user_interface/lovs/parameter_source_no_conditions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1423989032583278480.4851)
,p_lov_name=>'PARAMETER_SOURCE_NO_CONDITIONS'
,p_lov_query=>'.'||wwv_flow_api.id(1423989032583278480.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1423989323415278482.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cabecera HTTP'
,p_lov_return_value=>'HEADER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1423989504373278483.4851)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Cuerpo de la Respuesta'
,p_lov_return_value=>'RESPONSE'
,p_lov_disp_cond2=>'OUT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1423989720951278484.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'URI'
,p_lov_return_value=>'URI'
,p_lov_disp_cond2=>'IN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/parameter_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(793443816001344104.4851)
,p_lov_name=>'PARAMETER_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(793443816001344104.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793444013072344105.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cadena'
,p_lov_return_value=>'STRING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793444211458344105.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Entero'
,p_lov_return_value=>'INT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793444423050344105.4851)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Doble'
,p_lov_return_value=>'DOUBLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793444618634344105.4851)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Largo'
,p_lov_return_value=>'LONG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(793444812427344105.4851)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Registro de Hora'
,p_lov_return_value=>'TIMESTAMP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pick_module
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(826059223722614454.4851)
,p_lov_name=>'PICK MODULE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''All Services'' d, 999 r from sys.dual',
'union all',
'select name d, id r from WWV_FLOW_RT$MODULES ',
'where security_group_id = :flow_security_group_id',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/privileges
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1481196731126092675.4851)
,p_lov_name=>'PRIVILEGES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select label d, id r',
'  from wwv_flow_rt$privileges',
' where security_group_id = :flow_security_group_id',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/published_not_published
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(316762018242533973.4851)
,p_lov_name=>'PUBLISHED NOT PUBLISHED'
,p_lov_query=>'.'||wwv_flow_api.id(316762018242533973.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(316762306509533979.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Fecha de Publicaci\00F3n')
,p_lov_return_value=>'PUBLISHED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(316762517698533983.4851)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No Publicado'
,p_lov_return_value=>'NOT_PUBLISHED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/restful_approval_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1646678615030409311.4851)
,p_lov_name=>'RESTFUL_APPROVAL_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(1646678615030409311.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1646678927075409312.4851)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Aprobado'
,p_lov_return_value=>'APPROVED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1646679121350409312.4851)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Pendiente'
,p_lov_return_value=>'PENDING'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'14,16'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1646679301282409312.4851)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Denegado'
,p_lov_return_value=>'DENIED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/restful_service_clients
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1646424605586349771.4851)
,p_lov_name=>'RESTFUL_SERVICE_CLIENTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r ',
'from wwv_flow_rt$clients',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/source_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(317434812233598482.4851)
,p_lov_name=>'SOURCE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(317434812233598482.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(317435304805598483.4851)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Consulta'
,p_lov_return_value=>'QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(317435514983598483.4851)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Consultar una Fila'
,p_lov_return_value=>'QUERY_1_ROW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(317435726705598483.4851)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'PL/SQL'
,p_lov_return_value=>'PLSQL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(317435916084598483.4851)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Medio'
,p_lov_return_value=>'MEDIA'
);
end;
/
prompt --application/shared_components/user_interface/lovs/user_groups
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1504722425110707335.4851)
,p_lov_name=>'USER_GROUPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select group_name d, id r',
'from   wwv_flow_fnd_user_groups_noapp',
'where  security_group_id = :flow_security_group_id',
'union all',
'select group_name d, id r',
'from wwv_flow_fnd_user_groups_noapp',
'where  security_group_id = 10',
'and :flow_security_group_id <> 10',
'and group_name = ''RESTful Services'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/zero_through_9
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(792033515275240381.4851)
,p_lov_name=>'ZERO THROUGH 9'
,p_lov_query=>'.'||wwv_flow_api.id(792033515275240381.4851)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792033722063240383.4851)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'0'
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792033913288240384.4851)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792034107246240384.4851)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'2'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792034319315240384.4851)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'3'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792034525773240385.4851)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'4'
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792034719819240385.4851)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792034916654240385.4851)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'6'
,p_lov_return_value=>'6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792035120319240385.4851)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'7'
,p_lov_return_value=>'7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792035332044240385.4851)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'8'
,p_lov_return_value=>'8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(792035529692240385.4851)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'9'
,p_lov_return_value=>'9'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(6687412253641141.4851)
,p_name=>' Breadcrumb'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6687804718641149.4851)
,p_parent_id=>wwv_flow_api.id(510823694272243103.4851)
,p_short_name=>'Servicios RESTful de APEX'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6690617516703988.4851)
,p_parent_id=>wwv_flow_api.id(.4851)
,p_short_name=>'Inicio'
,p_link=>'f?p=4500:1000:&SESSION.'
,p_page_id=>99999
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(304474918819443056.4851)
,p_parent_id=>wwv_flow_api.id(6687804718641149.4851)
,p_short_name=>unistr('Crear M\00F3dulo de Servicio RESTful')
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315395905415249299.4851)
,p_parent_id=>wwv_flow_api.id(6687804718641149.4851)
,p_short_name=>unistr('M\00F3dulo de Servicio RESTful')
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(325184318717294081.4851)
,p_parent_id=>wwv_flow_api.id(.4851)
,p_short_name=>'<span class="u-VisuallyHidden">Taller de SQL</span><span class="a-Icon icon-breadcrumb-previous" title="SQL Workshop"></span>'
,p_link=>'f?p=4500:3002:&SESSION.'
,p_page_id=>99998
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(334837230638272011.4851)
,p_parent_id=>wwv_flow_api.id(510823694272243103.4851)
,p_short_name=>'Servicios RESTful de ORDS'
,p_link=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:::'
,p_page_id=>100
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(342528825537616663.4851)
,p_parent_id=>wwv_flow_api.id(334837230638272011.4851)
,p_short_name=>unistr('M\00F3dulos')
,p_link=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:::'
,p_page_id=>110
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(344951402392612486.4851)
,p_parent_id=>wwv_flow_api.id(342528825537616663.4851)
,p_short_name=>unistr('Definici\00F3n de m\00F3dulo')
,p_link=>'f?p=&APP_ID.:120:&SESSION.'
,p_page_id=>120
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(358073020837129150.4851)
,p_parent_id=>wwv_flow_api.id(344951402392612486.4851)
,p_short_name=>'Plantilla de Recurso'
,p_link=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:::'
,p_page_id=>130
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(358791994314621921.4851)
,p_parent_id=>wwv_flow_api.id(358073020837129150.4851)
,p_short_name=>'Manejador de Recursos'
,p_link=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:::'
,p_page_id=>140
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(358828713671891802.4851)
,p_parent_id=>wwv_flow_api.id(334837230638272011.4851)
,p_short_name=>'Privilegios'
,p_link=>'f?p=&APP_ID.:150:&SESSION.'
,p_page_id=>150
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(358835567773896740.4851)
,p_parent_id=>wwv_flow_api.id(358828713671891802.4851)
,p_short_name=>unistr('Definici\00F3n de privilegio')
,p_link=>'f?p=&APP_ID.:160:&SESSION.'
,p_page_id=>160
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(358836167207899890.4851)
,p_parent_id=>wwv_flow_api.id(334837230638272011.4851)
,p_short_name=>'Roles'
,p_link=>'f?p=&APP_ID.:170:&SESSION.'
,p_page_id=>170
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(358839507350906219.4851)
,p_parent_id=>wwv_flow_api.id(358836167207899890.4851)
,p_short_name=>unistr('Definici\00F3n de Rol')
,p_link=>'f?p=&APP_ID.:180:&SESSION.'
,p_page_id=>180
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(381633302716441851.4851)
,p_parent_id=>wwv_flow_api.id(334837230638272011.4851)
,p_short_name=>'Objetos activados ORDS'
,p_link=>'f?p=&APP_ID.:190:&SESSION.'
,p_page_id=>190
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(388804142472871280.4851)
,p_parent_id=>wwv_flow_api.id(.4851)
,p_short_name=>'0'
,p_link=>'f?p=&FLOW_ID.:0:&SESSION.'
,p_page_id=>0
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(413824715640010611.4851)
,p_parent_id=>wwv_flow_api.id(315395905415249299.4851)
,p_short_name=>'Plantilla de Recurso'
,p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(413930227369017548.4851)
,p_parent_id=>wwv_flow_api.id(415722322040309103.4851)
,p_short_name=>unistr('Par\00E1metro de Manejador de Recursos')
,p_link=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::'
,p_page_id=>12
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(415722322040309103.4851)
,p_parent_id=>wwv_flow_api.id(413824715640010611.4851)
,p_short_name=>'Manejador de Recursos'
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(510823694272243103.4851)
,p_parent_id=>wwv_flow_api.id(325184318717294081.4851)
,p_short_name=>'Servicios RESTful'
,p_link=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.:::'
,p_page_id=>500
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(533276487619496213.4851)
,p_parent_id=>wwv_flow_api.id(334837230638272011.4851)
,p_short_name=>'Exportar servicios RESTful de ORDS'
,p_link=>'f?p=&APP_ID.:108:&SESSION.::&DEBUG.:::'
,p_page_id=>108
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(533287497265532718.4851)
,p_parent_id=>wwv_flow_api.id(334837230638272011.4851)
,p_short_name=>'Importar servicios RESTful de ORDS'
,p_link=>'f?p=&APP_ID.:109:&SESSION.'
,p_page_id=>109
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(825236215533488467.4851)
,p_parent_id=>wwv_flow_api.id(6687804718641149.4851)
,p_short_name=>'Exportar Servicios RESTful'
,p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
,p_page_id=>2
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(835826920508943696.4851)
,p_parent_id=>wwv_flow_api.id(6687804718641149.4851)
,p_short_name=>'Importar Servicios RESTful'
,p_link=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::'
,p_page_id=>5
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1481433909665180242.4851)
,p_parent_id=>wwv_flow_api.id(1481503026042187892.4851)
,p_short_name=>'Detalles de Privilegios del Servicio RESTful'
,p_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
,p_page_id=>6
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1481503026042187892.4851)
,p_parent_id=>wwv_flow_api.id(6687804718641149.4851)
,p_short_name=>'Privilegios del Servicio RESTful'
,p_link=>'f?p=&FLOW_ID.:4:&SESSION.'
,p_page_id=>4
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1504438624052636603.4851)
,p_parent_id=>wwv_flow_api.id(6687804718641149.4851)
,p_short_name=>'Registros de Clientes'
,p_link=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
,p_page_id=>13
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1504612710885657958.4851)
,p_parent_id=>wwv_flow_api.id(1504438624052636603.4851)
,p_short_name=>'Registro de Cliente'
,p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1646510922571380988.4851)
,p_parent_id=>wwv_flow_api.id(6687804718641149.4851)
,p_short_name=>'Aprobaciones del Servicio RESTful'
,p_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
,p_page_id=>14
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1647082920975488070.4851)
,p_parent_id=>wwv_flow_api.id(1646510922571380988.4851)
,p_short_name=>'Crear/Editar Aprobaciones del Servicio RESTful'
,p_link=>'f?p=&FLOW_ID.:15:&SESSION.'
,p_page_id=>15
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1655767024290367492.4851)
,p_parent_id=>wwv_flow_api.id(1646510922571380988.4851)
,p_short_name=>'Actualizar Varias Aprobaciones'
,p_link=>'f?p=&FLOW_ID.:16:&SESSION.'
,p_page_id=>16
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1746949323661635358.4851)
,p_parent_id=>wwv_flow_api.id(415722322040309103.4851)
,p_short_name=>'Probar Manejador de Recursos'
,p_link=>'f?p=&FLOW_ID.:8:&SESSION.'
,p_page_id=>8
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_0_left_sidebar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(6672820488641033.4851)
,p_theme_id=>3
,p_name=>'APEX 4.0 - Left SideBar.es'
,p_internal_name=>'APEX_4.0_LEFT_SIDEBAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div id="apex-main">',
'    <div id="ContentBody">',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-splash">',
'          <div id="RP4">#REGION_POSITION_04#</div>',
'          <div id="BB">#BODY#</div>',
'        </div>',
'      </div>',
'    </div>',
'    <div id="apex-left-sidebar">#REGION_POSITION_01#</div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>16
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>35947117597242898.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_no_sidebar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(6672920821641033.4851)
,p_theme_id=>3
,p_name=>'APEX 4.2 - No SideBar.es'
,p_internal_name=>'APEX_4.2_NO_SIDEBAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-content">#REGION_POSITION_02#',
'      <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion failRegion #REGION_CSS_CLASSES#" id="ERROR">',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    <p><strong>#MESSAGE#</strong></p>',
'    #ADDITIONAL_INFO#',
'    #TECHNICAL_INFO#',
'  </div>',
'  <span class="aButtonContainer">',
'    <button onclick="#BACK_LINK#" class="aButton hotButton"><span>#RETURN_TO_APPLICATION#</span></button>',
'  </span>',
'</section>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>187453329378870285.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_0_right_sidebar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(6673001550641034.4851)
,p_theme_id=>3
,p_name=>'APEX 4.0 - Right SideBar.es'
,p_internal_name=>'APEX_4.0_RIGHT_SIDEBAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-two-col">',
'      <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-splash"><div id="BB">#BODY#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'  <div>#REGION_POSITION_04#</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>18525411970780075.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_wizard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(348171001889489868.4851)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Wizard .es'
,p_internal_name=>'APEX_4.2_WIZARD_'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="aWizard">',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'<div class="wizardOuterContainer">',
'#REGION_POSITION_01#',
'<div class="wizardContainer">',
'    <h1 class="visuallyhidden">#TITLE#</h1>',
'    #REGION_POSITION_03#',
'    #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="wizardBody">',
'    #BODY#',
'    #REGION_POSITION_04#',
'    #REGION_POSITION_05#',
'  </div>',
'</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'<script>',
'function loadWizardTrain() {',
'	var currentStep = $("li.current,li.first-current,li.last-current",''div.wizardProgress'');',
'	if (currentStep.prev().length > 0) {',
'		currentStep.prevAll().find(''span'').addClass("pastCurrent");',
'	}',
'}',
'$(document).ready(function(){',
'loadWizardTrain();',
'})',
'</script>',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aWizardMessage successMessage" id="aSuccessMessage" role="alert">',
'  <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'  <a href="javascript:void(0)" onclick="$x_Remove(''aSuccessMessage'')" class="aCloseNotification"><span class="visuallyhidden">#CLOSE_NOTIFICATION#</span></a>',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aWizardMessage errorMessage" id="aErrorMessage" role="alert">',
'  <a href="javascript:void(0)" onclick="$x_Remove(''aErrorMessage'')" class="aCloseNotification"><span class="visuallyhidden">#CLOSE_NOTIFICATION#</span></a>',
'  <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'  #MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>16
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>42231511193339128.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(348183913031531541.4851)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Edit Screen.es'
,p_internal_name=>'APEX_4.2_EDIT_SCREEN'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-two-col">',
'      <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-edit-screen">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>244139901565747496.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sql_workshop_iframe_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(366073392769530321.4851)
,p_theme_id=>3
,p_name=>'APEX 5.0 - ORDS iFrame Page.es'
,p_internal_name=>'APEX_5.0_SQL_WORKSHOP_IFRAME_PAGE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="sql-workshop-iframe-page a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(719669719239933042.4851)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog.es'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(719670183563933079.4851)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Edit Screen.es'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4851
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159371820089539049.4851)
,p_page_template_id=>wwv_flow_api.id(719670183563933079.4851)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159372336205539049.4851)
,p_page_template_id=>wwv_flow_api.id(719670183563933079.4851)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(719672364834933087.4851)
,p_theme_id=>3
,p_name=>'APEX 5.0 - No Side Bar.es'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(719672816683933088.4851)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Right Side Bar.es'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222.4851
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159376268725539054.4851)
,p_page_template_id=>wwv_flow_api.id(719672816683933088.4851)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159376739193539054.4851)
,p_page_template_id=>wwv_flow_api.id(719672816683933088.4851)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159377285437539054.4851)
,p_page_template_id=>wwv_flow_api.id(719672816683933088.4851)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159377702975539055.4851)
,p_page_template_id=>wwv_flow_api.id(719672816683933088.4851)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159378201174539055.4851)
,p_page_template_id=>wwv_flow_api.id(719672816683933088.4851)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159378742541539055.4851)
,p_page_template_id=>wwv_flow_api.id(719672816683933088.4851)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159379260026539056.4851)
,p_page_template_id=>wwv_flow_api.id(719672816683933088.4851)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sign_up_wizard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(719674293388933089.4851)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Sign Up Wizard.es'
,p_internal_name=>'APEX_5.0_SIGN_UP_WIZARD'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--simpleWizard" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'<div class="u-Layout u-Layout--centerVertically">',
'  #BODY#',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702692008314080052.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(719674703062933090.4851)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Page.es'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(719678839350933097.4851)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Dialog.es'
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.builder.initWizardModal();',
'apex.builder.initWizardProgressBar();'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="utf-8">  ',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--wizard'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689061037088924910.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_restful_web_services
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(754939123056928433.4851)
,p_theme_id=>3
,p_name=>'APEX 5.0 - RESTful Web Services.es'
,p_internal_name=>'APEX_5.0_RESTFUL_WEB_SERVICES'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="a-Page--webservices #PAGE_CSS_CLASSES#">',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <aside class="a-Side a-Side--left a-Side--large">',
'        #REGION_POSITION_03#',
'    </aside>',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>754942495369044641.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_next_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(232195217185455150.4851)
,p_template_name=>'APEX 4.2 - Next Button'
,p_internal_name=>'APEX_4.2_NEXT_BUTTON'
,p_template=>'<button class="aButton nextButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" class="nextBlack" alt=""/></span></button>'
,p_hot_template=>'<button class="aButton hotButton nextButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" class="nextWhite" alt=""/></span></button>'
,p_reference_id=>40780910892272674.4851
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_1_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(302280313173718795.4851)
,p_template_name=>'APEX 4.1 - Button'
,p_internal_name=>'APEX_4.1_BUTTON'
,p_template=>'<button class="aButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_hot_template=>'<button class="aButton hotButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_reference_id=>275775519061831382.4851
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="button-gray" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> ',
'',
'',
'<a href="#LINK#" class="button-orange" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> '))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button_2
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(388776568320789175.4851)
,p_template_name=>'APEX 5.0 - Icon Menu Button (2)'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON_2'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4851
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button_2
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(388776713638789177.4851)
,p_template_name=>'APEX 5.0 - Icon Only Button (2)'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON_2'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4851
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_button_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(629187503480957071.4851)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_BUTTON_LEGACY_APEX_5_MIGRATION'
,p_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(719734705014947853.4851)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4851
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(719734932326947858.4851)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233.4851
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(719735277951947858.4851)
,p_template_name=>'APEX 5.0 - Icon Badge Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><span class="a-But'
||'ton-badge"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><spa'
||'n class="a-Button-badge"></span></button>'
,p_reference_id=>631020282344854024.4851
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(719735508683947859.4851)
,p_template_name=>'APEX 5.0 - Icon Badge Menu Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_reference_id=>631020159860848910.4851
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(719735863923947860.4851)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4851
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(719736129383947861.4851)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4851
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6673713929641045.4851)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div  with ID (c:htmldbHID)'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>245224629509817478.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6673907217641045.4851)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div with ID and Region Attributes'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>2974803291668087.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_hide_and_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6674010598641046.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title"><h3>',
'      <a href="#" onclick="htmldb_ToggleTableBody(''i#REGION_STATIC_ID#'',''body#REGION_STATIC_ID#''); return false;">',
'        <img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" class="pseudoButtonActive" id="i#REGION_STATIC_ID#" alt="" />',
'        #TITLE#',
'      </a></h3>    ',
'    </div>',
'  </div>',
'  <div class="hide-show-body" style="display:none;" id="body#REGION_STATIC_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.0 - Hide and Show Region'
,p_internal_name=>'APEX_4.0_HIDE_AND_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18662712241194598.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_gray_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6674313033641046.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideNavRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner (Gray Top)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_GRAY_TOP'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>29053509612942271.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_large
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6674714399641047.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Large'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_LARGE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>27763613494297374.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6675116240641047.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar (Gray Header)'
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_navigation
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6675215817641047.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion sideNavRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar Navigation'
,p_internal_name=>'APEX_4.0_SIDEBAR_NAVIGATION'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>456726627253419549.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6675304951641047.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar'
,p_internal_name=>'APEX_4.0_TOP_BAR'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>191052627601630142.4851
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar_100
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6675421676641048.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar (100%)'
,p_internal_name=>'APEX_4.0_TOP_BAR_100%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17357218626599946.4851
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/breadcrumb_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6675929305641049.4851)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#">#BODY#</div>'
,p_page_plug_template_name=>'Breadcrumb Region'
,p_internal_name=>'BREADCRUMB_REGION'
,p_theme_id=>3
,p_theme_class_id=>6
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/gray_box_worksheet
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(6676416472641049.4851)
,p_layout=>'TABLE'
,p_template=>'<table class="htmldbGBR" cellspacing="0" cellpadding="0" border="0" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="T">#TITLE#</th><th class="BT">#CLOSE#&nbsp;#EDIT##EXPAND##HELP##DELETE##COPY##CREATE#<img src="#IMAGE_PREFIX#up_arrow.gif" al'
||'t="&TOP." class="pb" onclick="uF()"/></th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>'
,p_page_plug_template_name=>'Gray Box (worksheet)'
,p_internal_name=>'GRAY_BOX_WORKSHEET'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(348176930747494218.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body'
,p_internal_name=>'APEX_4.2_WIZARD_BODY'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209615589242480.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_buttons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(348178315010494220.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardButtonsContainer" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="leftButtons">',
'    #PREVIOUS##DELETE##CHANGE##CLOSE#',
'  </div>',
'  <div class="rightButtons">',
'    #EDIT##CREATE##NEXT#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Buttons'
,p_internal_name=>'APEX_4.2_WIZARD_BUTTONS'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210411889242480.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(388770208095784265.4851)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(410842408391417181.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>746362351042209764.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_accordion
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719684209410942721.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUBREGIONS#',
'</div>',
'<script type="text/javascript">',
'  apex.jQuery( "#accordion" ).accordion({',
'    icons: false,',
'    header: ".a-Region-header",',
'    heightStyle: ''content'',',
'    collapsible: true',
'  });',
'</script>'))
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion-item">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Accordion'
,p_internal_name=>'APEX_5.0_ACCORDION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174746301430371105.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719684836837942735.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>687153470345619376.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719691677138942761.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'      <button class="a-Button a-Button--icon a-Button--hideShow" type="button"></button>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>689955986849128825.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719702549794942779.4851)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719704379601942780.4851)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #COMPONENT_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Page Anchors'
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17354206769599941.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719705012309942781.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-PageColumn-header">',
'    <h2 class="a-PageColumn-heading">#TITLE#</h2>',
'  </div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613223222362440.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719705787384942781.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn-body #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column (Body)'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN_BODY'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174630015632506596.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719706437830942782.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174748721787471587.4851
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_hidden_heading
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719716763420942796.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region (Hidden Heading)'
,p_internal_name=>'APEX_5.0_REGION_HIDDEN_HEADING'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>717832816842067694.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719717435785942797.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>698829239393878937.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719727766130942804.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUB_REGION_HEADERS#',
'  #SUB_REGIONS#',
'</div>',
'<script type="text/javascript">',
'    $("##REGION_STATIC_ID#").tabs({',
'      create: function() {',
'        $(this).addClass(''ui-tabs--simpleInset'')',
'      }',
'    });',
'</script>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#">#SUB_REGION_TITLE#</a></li>'
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer-item" id="#SUB_REGION_ID#">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Tabs'
,p_internal_name=>'APEX_5.0_TABS'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>183211208341566300.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719728426095942807.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Toolbar-items a-Toolbar-items--left">#PREVIOUS#</div>',
'  <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar'
,p_internal_name=>'APEX_5.0_TOOLBAR'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613705533399534.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719729116465942807.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--left #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Left)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_LEFT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174628415239478085.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_right
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719729865365942808.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--right #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Right)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_RIGHT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174629130392501406.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719730593079942808.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719731261318942809.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Wizard-region a-Form #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Wizard-regionHeader">#REGION_HEADER#</div>',
'  <div class="a-Wizard-regionBody">#BODY#</div>',
'  <div class="a-Wizard-regionFooter">#REGION_FOOTER#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Region'
,p_internal_name=>'APEX_5.0_WIZARD_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>702777601713950915.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_title_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(719731990154942810.4851)
,p_layout=>'TABLE'
,p_template=>'<div class="#REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#><h1 class="a-Wizard-title">#TITLE#</h1></div>'
,p_page_plug_template_name=>'APEX 5.0 - Wizard Title Region'
,p_internal_name=>'APEX_5.0_WIZARD_TITLE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>703469000349150769.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(725723925684227744.4851)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>',
'<h1 class="u-VisuallyHidden">#TITLE#</h1>#PREVIOUS##BODY##NEXT#</div>'))
,p_page_plug_template_name=>'APEX 5.2 - H1 Region with Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>725712004402219465.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_pull_down_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(6681909853641062.4851)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_name=>'APEX 4.0 - Pull Down Tabs'
,p_internal_name=>'APEX_4.0_PULL_DOWN_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div id="tabs" class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul id="S#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="aTabs dhtmlSubMenu pulldown-tabs" style="display:none;">',
''))
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_reference_id=>9651611091899590.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_c_htmldbul_from_4999
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(6683027032641069.4851)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'Unordered List (c:htmldbUl) From 4999'
,p_internal_name=>'UNORDERED_LIST_C:HTMLDBUL_FROM_4999'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(388773697797786787.4851)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5 - Navigation List'
,p_internal_name=>'APEX_5_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(388773934841786788.4851)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(719740035822969345.4851)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508.4851
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(719740644210969351.4851)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(719744974422969355.4851)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(719752075880969362.4851)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sub_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(719752749945969363.4851)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Sub Tabs'
,p_internal_name=>'APEX_5.0_SUB_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4851
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(719753408696969364.4851)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/list/run_edit_page
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(873644613350880195.4851)
,p_list_template_current=>'<a href="#LINK#" title="#TEXT_ESC_SC#" class="runediticons"><img src="#IMAGE_PREFIX##IMAGE#" alt="#TEXT#" title="#TEXT#" /></a>'
,p_list_template_noncurrent=>'<a href="#LINK#" title="#TEXT_ESC_SC#" class="runediticons"><img src="#IMAGE_PREFIX##IMAGE#" alt="#TEXT#" title="#TEXT#" /></a>'
,p_list_template_name=>'Run / Edit Page'
,p_internal_name=>'RUN_/_EDIT_PAGE'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table summary="" cellpadding="0" cellspacing="0" border="0" id="htmldbRunEdit"><tr><td class="htmldbRunEdit">&PAGE.&nbsp;&FB_FLOW_PAGE_ID.</td><td>'
,p_list_template_after_rows=>'</td></tr></table>'
,p_reference_id=>21869428576987437.4851
,p_list_template_comment=>'run edit page with icons shown in the top right corner'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_mike_region_tabbed_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1655476716389340490.4851)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="current"><div class="tbl"><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></div><div class="tbr"><img alt="" src="#IMAGE_PREFIX#1px_trans.gif"></div></div>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="non-current"><div class="tbl"><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></div><div class="tbr"><img alt="" src="#IMAGE_PREFIX#1px_trans.gif"></div></div>',
''))
,p_list_template_name=>'APEX 4.0 MIKE Region Tabbed Navigation'
,p_internal_name=>'APEX_4.0_MIKE_REGION_TABBED_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div id="subtabs" style="padding-left:6px;">'
,p_list_template_after_rows=>'</div>'
,p_reference_id=>168712225287236339.4851
);
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_100
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(6679518318641053.4851)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report 100%'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_100%'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#" href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:" style="width:100%;">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'#CSV_LINK#',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(6679518318641053.4851)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(6679925011641056.4851)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report from 4999'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#"><div class="of">#COLUMN_VALUE#</div></td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#"><div class="of">#COLUMN_HEADER#</div></th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(6679925011641056.4851)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(6680513762641056.4851)
,p_row_template_name=>'APEX 4.0 - Standard Report'
,p_internal_name=>'APEX_4.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4851
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(6680513762641056.4851)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(410824020274284659.4851)
,p_row_template_name=>'APEX 5.0 - Portlet Column Template'
,p_internal_name=>'APEX_5.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(410824639895284680.4851)
,p_row_template_name=>'APEX 5.0 - Portlet Row Template'
,p_internal_name=>'APEX_5.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_vertical_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(410825361296284681.4851)
,p_row_template_name=>'APEX 5.0 - Vertical Report'
,p_internal_name=>'APEX_5.0_VERTICAL_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr>',
'  <td class="a-Report-cell a-Report-cell--header" scope="row">#COLUMN_HEADER#</td>',
'  <td class="a-Report-cell">#COLUMN_VALUE#</td>',
'</tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report a-Report--vertical a-Report--staticRowColors #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" summary="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>1126924627125205941.4851
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(410825361296284681.4851)
,p_row_template_before_first=>' '
,p_row_template_after_last=>' '
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_named_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(719756401064973260.4851)
,p_row_template_name=>'APEX 5.0 - Badge List (Named Column)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_NAMED_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(719765686149973274.4851)
,p_row_template_name=>'APEX 5.0 - Badge List (Row)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
'  <span class="t-BadgeList-label">#1#</span>',
'  <span class="t-BadgeList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>6
,p_reference_id=>689060248369886348.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(719766306083973274.4851)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4851
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(719766306083973274.4851)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(719768854998973277.4851)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4851
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(719768854998973277.4851)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_4_0_top_bar_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(6683302430641069.4851)
,p_template_name=>'APEX 4.0 - Top Bar Label'
,p_internal_name=>'APEX_4.0_TOP_BAR_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(6683429755641072.4851)
,p_template_name=>'FormField_Optional'
,p_internal_name=>'FORMFIELD_OPTIONAL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional_no_link
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(6683514682641072.4851)
,p_template_name=>'FormField_Optional No Link'
,p_internal_name=>'FORMFIELD_OPTIONAL_NO_LINK'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><span class="htmldbLabelOptional">'
,p_template_body2=>'</span></label>'
,p_theme_id=>3
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_required
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(6683627983641072.4851)
,p_template_name=>'FormField_Required'
,p_internal_name=>'FORMFIELD_REQUIRED'
,p_template_body1=>'<em>*</em><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aRequired"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>' <span class="hideMeButHearMe">(#VALUE_REQUIRED#)</span></a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>2
,p_reference_id=>17388508175892042.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_dynamic_attribute
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(719737144024952633.4851)
,p_template_name=>'APEX 5.0 - Dynamic Attribute'
,p_internal_name=>'APEX_5.0_DYNAMIC_ATTRIBUTE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-dynamicItemHelp" data-itemname="#CURRENT_ITEM_NAME#" data-appid="&FB_FLOW_ID." title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help"></span><span cl'
||'ass="u-VisuallyHidden">#CURRENT_ITEM_HELP_LABEL#</span></button>#ERROR_TEMPLATE#</div>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>692681574974429799.4851
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(719737202731952639.4851)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>687907221148719616.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(719737377976952639.4851)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487444299516703815.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(719737479015952640.4851)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492676964457041934.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(719737577300952641.4851)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487443659585685414.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(719737671382952642.4851)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492677038682043223.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumbs_c_htmldbbreadcrumb
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(6685028533641078.4851)
,p_name=>'Breadcrumbs (c:htmldbBreadcrumb) '
,p_internal_name=>'BREADCRUMBS_C:HTMLDBBREADCRUMB_'
,p_current_page_option=>'<span class="htmldbBreadcrumb">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#" class="htmldbBreadcrumb" title="#NAME#">#NAME#</a>'
,p_between_levels=>'<span class="htmldbBreadcrumbSep"><img alt="" src="#IMAGE_PREFIX#apex/apex_top_sep.gif"></span>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>60115300853820165.4851
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(388777204236790831.4851)
,p_name=>'APEX 5 - Breadcrumbs'
,p_internal_name=>'APEX_5_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>7
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(6685219659641084.4851)
,p_page_name=>'winlov'
,p_page_title=>unistr('Cuadro de Di\00E1logo de B\00FAsqueda')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>'Buscar'
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>'Cerrar'
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>'Siguiente &gt;'
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>'&lt; Anterior'
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>'<div class="a-PopupLOV-pagination">Filas #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17343114994581872.4851
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/default_calander
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(6685118440641079.4851)
,p_cal_template_name=>'Default Calander'
,p_internal_name=>'DEFAULT_CALANDER'
,p_day_of_week_format=>'<th scope="col" width="14%" class="htmldbDayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbCalendarHolder" cellpadding="0" cellspacing="0" border="0" width="100%" summary="" role="presentation"><tr>',
'<td class="htmldbMonthTitle">#IMONTH# #YYYY#</td>',
'</tr>',
'<tr><td>'))
,p_month_open_format=>'<table class="htmldbCalendar" cellpadding="0" cellspacing="3" border="0" width="100%" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td></tr></table>',
'',
''))
,p_day_title_format=>'<div class="htmldbDayTitle">#DD#</div>'
,p_day_open_format=>'<td class="htmldbDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="htmldbToday">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="htmldbWeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td class="htmldbWeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="htmldbNonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="htmldbNonDay">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(72334735125547461.4851)
,p_theme_id=>3
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(204025807133792433.4851)
,p_theme_id=>3
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(410842861136417204.4851)
,p_theme_id=>3
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(604902705499438118.4851)
,p_theme_id=>3
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697251294722708867.4851)
,p_theme_id=>101
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698694776128187820.4851)
,p_theme_id=>101
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698695498474187821.4851)
,p_theme_id=>101
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698696193838187821.4851)
,p_theme_id=>101
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698697787201187821.4851)
,p_theme_id=>101
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(719685315860942741.4851)
,p_theme_id=>101
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(719686065595942753.4851)
,p_theme_id=>101
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(719687083065942754.4851)
,p_theme_id=>101
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(719693321199942765.4851)
,p_theme_id=>101
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(719694346985942765.4851)
,p_theme_id=>101
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(719696520421942771.4851)
,p_theme_id=>101
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(719745438780969357.4851)
,p_theme_id=>101
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(719756857955973266.4851)
,p_theme_id=>101
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(719759344431973269.4851)
,p_theme_id=>101
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746522780970832157.4851)
,p_theme_id=>3
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746524032352832160.4851)
,p_theme_id=>3
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746524354430832160.4851)
,p_theme_id=>3
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746524636021832160.4851)
,p_theme_id=>3
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746525736498832161.4851)
,p_theme_id=>3
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746526003025832161.4851)
,p_theme_id=>3
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746526303910832162.4851)
,p_theme_id=>3
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746526607241832162.4851)
,p_theme_id=>3
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746526976589832162.4851)
,p_theme_id=>3
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746527492206832162.4851)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746527712264832162.4851)
,p_theme_id=>3
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750698972347419636.4851)
,p_theme_id=>3
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750699786949419639.4851)
,p_theme_id=>3
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750700275488419640.4851)
,p_theme_id=>3
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750700521792419640.4851)
,p_theme_id=>3
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750701252020419640.4851)
,p_theme_id=>3
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750721754465422866.4851)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(787120436131949721.4851)
,p_theme_id=>3
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(787120733611949723.4851)
,p_theme_id=>3
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(787121012780949723.4851)
,p_theme_id=>3
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(787121853109949723.4851)
,p_theme_id=>3
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1021077947236574443.4851)
,p_theme_id=>3
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410825804183284695.4851)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(410825361296284681.4851)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(787120733611949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410826226966284700.4851)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(410825361296284681.4851)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(787121012780949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410826663105284701.4851)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(410825361296284681.4851)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410827025024284701.4851)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(410825361296284681.4851)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(787121012780949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410827468202284702.4851)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(410825361296284681.4851)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(787121853109949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410827865197284702.4851)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(410825361296284681.4851)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(787121012780949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410843276773417204.4851)
,p_theme_id=>3
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(410842408391417181.4851)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_api.id(410842861136417204)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410843608096417205.4851)
,p_theme_id=>3
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(410842408391417181.4851)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(750721754465422866)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410844086444417207.4851)
,p_theme_id=>3
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(410842408391417181.4851)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_api.id(410842861136417204)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410844477602417207.4851)
,p_theme_id=>3
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(410842408391417181.4851)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410844862990417208.4851)
,p_theme_id=>3
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(410842408391417181.4851)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_api.id(410842861136417204)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410845297101417208.4851)
,p_theme_id=>3
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(410842408391417181.4851)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410845655793417209.4851)
,p_theme_id=>3
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(410842408391417181.4851)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410846061900417209.4851)
,p_theme_id=>3
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(410842408391417181.4851)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_api.id(410842861136417204)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(410846435114417209.4851)
,p_theme_id=>3
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(410842408391417181.4851)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_api.id(750721754465422866)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719749095572969359.4851)
,p_theme_id=>101
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(719745438780969357)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719749378327969359.4851)
,p_theme_id=>101
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(719745438780969357)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719749632408969359.4851)
,p_theme_id=>101
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(719745438780969357)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719749999172969359.4851)
,p_theme_id=>101
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(719745438780969357)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719750270888969359.4851)
,p_theme_id=>101
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(719745438780969357)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719750521283969360.4851)
,p_theme_id=>101
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719750827622969360.4851)
,p_theme_id=>101
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719751139188969360.4851)
,p_theme_id=>101
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719751444164969360.4851)
,p_theme_id=>101
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719751746273969360.4851)
,p_theme_id=>101
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719761756589973270.4851)
,p_theme_id=>101
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_api.id(719756857955973266)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719762074209973270.4851)
,p_theme_id=>101
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(719756857955973266)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719762347743973271.4851)
,p_theme_id=>101
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(719756857955973266)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719762657912973271.4851)
,p_theme_id=>101
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_api.id(719759344431973269)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719762981452973271.4851)
,p_theme_id=>101
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(719759344431973269)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719763261799973271.4851)
,p_theme_id=>101
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_api.id(719759344431973269)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719763565151973271.4851)
,p_theme_id=>101
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(719759344431973269)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719763866645973271.4851)
,p_theme_id=>101
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(719759344431973269)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719764136152973271.4851)
,p_theme_id=>101
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(719756857955973266)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719764457918973271.4851)
,p_theme_id=>101
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(719756857955973266)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719764796759973272.4851)
,p_theme_id=>101
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(719756857955973266)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719765079854973272.4851)
,p_theme_id=>101
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(719756857955973266)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(719765336086973272.4851)
,p_theme_id=>101
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719756401064973260.4851)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(719756857955973266)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747447930745062680.4851)
,p_theme_id=>3
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(746526607241832162)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747448195284062681.4851)
,p_theme_id=>3
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_api.id(746526976589832162)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747448314100062681.4851)
,p_theme_id=>3
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746527492206832162)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747448512100062681.4851)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_api.id(746526303910832162)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747448789732062681.4851)
,p_theme_id=>3
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_api.id(746526607241832162)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747448938441062681.4851)
,p_theme_id=>3
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_api.id(746526976589832162)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747449123999062681.4851)
,p_theme_id=>3
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_api.id(746524636021832160)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747449340190062681.4851)
,p_theme_id=>3
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(746524636021832160)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747449571553062681.4851)
,p_theme_id=>3
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_api.id(746524636021832160)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747449731770062681.4851)
,p_theme_id=>3
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_api.id(746527712264832162)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747449891888062681.4851)
,p_theme_id=>3
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747450089546062681.4851)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_api.id(746526303910832162)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747450122219062681.4851)
,p_theme_id=>3
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747450323348062681.4851)
,p_theme_id=>3
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_api.id(746524354430832160)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747450579040062682.4851)
,p_theme_id=>3
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_api.id(746524354430832160)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747450779854062682.4851)
,p_theme_id=>3
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(746526003025832161)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747450942414062682.4851)
,p_theme_id=>3
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(746524032352832160)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747451165030062682.4851)
,p_theme_id=>3
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_api.id(746525736498832161)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747451224088062682.4851)
,p_theme_id=>3
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747451425091062682.4851)
,p_theme_id=>3
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_api.id(746524354430832160)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747451600479062682.4851)
,p_theme_id=>3
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_api.id(746524354430832160)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747451867827062682.4851)
,p_theme_id=>3
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_api.id(746522780970832157)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747452046306062685.4851)
,p_theme_id=>3
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_api.id(746522780970832157)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747452223243062685.4851)
,p_theme_id=>3
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_api.id(746522780970832157)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747452449216062685.4851)
,p_theme_id=>3
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_api.id(746522780970832157)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747452689227062685.4851)
,p_theme_id=>3
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_api.id(746522780970832157)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747452829858062685.4851)
,p_theme_id=>3
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_api.id(746522780970832157)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754946063015083320.4851)
,p_theme_id=>3
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719684836837942735.4851)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754946286739083320.4851)
,p_theme_id=>3
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719684836837942735.4851)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(750700521792419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754946482307083320.4851)
,p_theme_id=>3
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719684836837942735.4851)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(750700521792419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754946616505083322.4851)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719684836837942735.4851)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(750699786949419639)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754946893486083322.4851)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719684836837942735.4851)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(750699786949419639)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754946959496083322.4851)
,p_theme_id=>3
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719684836837942735.4851)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754947190105083322.4851)
,p_theme_id=>3
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719684836837942735.4851)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_api.id(750698972347419636)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754947398925083322.4851)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719684836837942735.4851)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_api.id(750698972347419636)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787120568119949722.4851)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(6680513762641056.4851)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(787120436131949721)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787120860598949723.4851)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(6680513762641056.4851)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(787120733611949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787121118010949723.4851)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(6680513762641056.4851)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(787121012780949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787121347377949723.4851)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(6680513762641056.4851)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(787121012780949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787121505745949723.4851)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(6680513762641056.4851)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(787121012780949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787121668141949723.4851)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(6680513762641056.4851)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787121959886949723.4851)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(6680513762641056.4851)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(787121853109949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787125838975949728.4851)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719768854998973277.4851)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(787120436131949721)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787126056332949729.4851)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719768854998973277.4851)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(787120733611949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787126250641949729.4851)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719768854998973277.4851)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(787121012780949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787126475470949729.4851)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719768854998973277.4851)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(787121012780949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787126699665949729.4851)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719768854998973277.4851)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(787121012780949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787126737679949729.4851)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719768854998973277.4851)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787126986708949729.4851)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719768854998973277.4851)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(787121853109949723)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(940696364380341577.4851)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719753408696969364.4851)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1019608729798657537.4851)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(388773934841786788.4851)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1019608842503657537.4851)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(388773934841786788.4851)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1199562177116032430.4851)
,p_theme_id=>3
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746527492206832162)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525660373773182102.4851)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(6683027032641069.4851)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525660453236182102.4851)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(6683027032641069.4851)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525660576207182102.4851)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(6683027032641069.4851)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525660668772182102.4851)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(6683027032641069.4851)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525660853485182102.4851)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(6683027032641069.4851)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(1021077947236574443)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525661000539182102.4851)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(6683027032641069.4851)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(1021077947236574443)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525663443196182118.4851)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719740644210969351.4851)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525663555494182118.4851)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719740644210969351.4851)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525663691914182118.4851)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719740644210969351.4851)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525663701680182118.4851)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719740644210969351.4851)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525663988048182118.4851)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719740644210969351.4851)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(1021077947236574443)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525664122904182118.4851)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(719740644210969351.4851)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(1021077947236574443)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544816183566477996.4851)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719766306083973274.4851)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544816239334477996.4851)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719766306083973274.4851)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544816346635477997.4851)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(719766306083973274.4851)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554808167201408361.4851)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(750698972347419636)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554808376461408362.4851)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(750698972347419636)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554808538958408362.4851)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(750699786949419639)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554808702062408362.4851)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(750699786949419639)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554808992281408362.4851)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750700275488419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554809198122408362.4851)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(750700521792419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554809350418408362.4851)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750701252020419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554809541904408363.4851)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750701252020419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554809723181408363.4851)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(750699786949419639)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554809868131408363.4851)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554810080669408363.4851)
,p_theme_id=>3
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719706437830942782.4851)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(750700521792419640)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554831128435526790.4851)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(719702549794942779.4851)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554831281587526791.4851)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719702549794942779.4851)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554831398178526791.4851)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719702549794942779.4851)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554838902558542255.4851)
,p_theme_id=>3
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719691677138942761.4851)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554839044958542255.4851)
,p_theme_id=>3
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719691677138942761.4851)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554839293090542255.4851)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719691677138942761.4851)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(750699786949419639)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554839447434542255.4851)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719691677138942761.4851)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(750699786949419639)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554839629067542255.4851)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719691677138942761.4851)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750700275488419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554839801508542255.4851)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719691677138942761.4851)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(750700521792419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554840011745542255.4851)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719691677138942761.4851)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750701252020419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554840202523542255.4851)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719691677138942761.4851)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750701252020419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554840441586542256.4851)
,p_theme_id=>3
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_api.id(719691677138942761.4851)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(750721754465422866)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554840668183542256.4851)
,p_theme_id=>3
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719691677138942761.4851)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(750721754465422866)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554860289631550796.4851)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719717435785942797.4851)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554860417345550796.4851)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719717435785942797.4851)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(750698972347419636)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554860625063550796.4851)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719717435785942797.4851)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750701252020419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554860834521550796.4851)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719717435785942797.4851)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(750700521792419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554861036468550796.4851)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(719717435785942797.4851)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(750699786949419639)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554861239925550796.4851)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719717435785942797.4851)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(750698972347419636)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554861401068550796.4851)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(719717435785942797.4851)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(750699786949419639)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554861664175550796.4851)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719717435785942797.4851)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750701252020419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554861870266550796.4851)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(719717435785942797.4851)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750700275488419640)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554862010703550796.4851)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(719717435785942797.4851)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(750699786949419639)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(693462905220662747.4851)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(865700153074085752.4851)
,p_build_option_name=>'Enable check for duplicate null modules'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
,p_on_upgrade_keep_status=>true
,p_build_option_comment=>'Used to control whether the warning dialog appears telling people about duplicate null Module URIs in the APEX REST metadata.'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286572302889881352)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'es'
,p_message_text=>'Cerrar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286574072028881353)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'es'
,p_message_text=>'Buscar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286572235464881352)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'es'
,p_message_text=>'Buscar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286573922314881353)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'es'
,p_message_text=>'Buscar Siguiente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286573829081881353)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'es'
,p_message_text=>'Buscar Anterior'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286573693361881353)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'es'
,p_message_text=>unistr('Terminar Autom\00E1ticamente')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286572923981881353)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('Tama\00F1o de Sangr\00EDa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286573105802881353)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'es'
,p_message_text=>unistr('Espacios Insertados en Tabulaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286572544729881352)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'es'
,p_message_text=>unistr('Coincidir May\00FAsculas/Min\00FAsculas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286572472807881352)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'es'
,p_message_text=>unistr('Expresi\00F3n Regular')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286574182910881353)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'es'
,p_message_text=>'Rehacer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286573750075881353)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'es'
,p_message_text=>'Sustituir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286572059965881352)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'es'
,p_message_text=>'Sustituir Todo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286572191523881352)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'es'
,p_message_text=>'Sustituir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286571946363881352)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'es'
,p_message_text=>'Omitir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286573464061881353)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'es'
,p_message_text=>unistr('Configuraci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286572737806881352)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'es'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286573278059881353)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'es'
,p_message_text=>unistr('Mostrar N\00FAmeros de L\00EDnea')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286572668618881352)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'es'
,p_message_text=>'Mostrar Regla'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286573075972881353)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'es'
,p_message_text=>unistr('Tama\00F1o de Tabulaci\00F3n')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286572844246881352)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'es'
,p_message_text=>'Temas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286574249557881354)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'es'
,p_message_text=>'Deshacer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286573330146881353)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'es'
,p_message_text=>'Usar Editor de Texto sin Formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286573579696881353)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'es'
,p_message_text=>'Validar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286574343741881354)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'es'
,p_message_text=>unistr('Validaci\00F3n Correcta')
,p_is_js_message=>true
);
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(315392728012249274.4851)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\00BFDesea realizar esta acci\00F3n de supresi\00F3n?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(1420362217001980473.4851)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\00BFSeguro que desea salir de esta p\00E1gina sin guardar?')
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(540039604917681918.4851)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040.4851
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(113747616193665437.4851)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>unistr('Autenticaci\00F3n Apex')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425.4851
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(118613601621937846.4851)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>unistr('INTERNAL: Inicio de sesi\00F3n en medios sociales')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086.4851
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118613837302937847.4851)
,p_plugin_id=>wwv_flow_api.id(118613601621937846.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118615603325937848.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(118613837302937847.4851)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118614262871937847.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(118613837302937847.4851)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118614762757937847.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(118613837302937847.4851)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118615162837937847.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(118613837302937847.4851)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118616154318937848.4851)
,p_plugin_id=>wwv_flow_api.id(118613601621937846.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118613837302937847.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118616516522937848.4851)
,p_plugin_id=>wwv_flow_api.id(118613601621937846.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118613837302937847.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118616917895937848.4851)
,p_plugin_id=>wwv_flow_api.id(118613601621937846.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118613837302937847.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118617311328937848.4851)
,p_plugin_id=>wwv_flow_api.id(118613601621937846.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118613837302937847.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118617712470937849.4851)
,p_plugin_id=>wwv_flow_api.id(118613601621937846.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Application Express automatically adds the "openid" scope. The authent'
||'ication provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118618186739937849.4851)
,p_plugin_id=>wwv_flow_api.id(118613601621937846.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118618537883937849.4851)
,p_plugin_id=>wwv_flow_api.id(118613601621937846.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118618962932937849.4851)
,p_plugin_id=>wwv_flow_api.id(118613601621937846.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_group_select_list
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(156397842989136966.4851)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.GROUP_SELECT_LIST'
,p_display_name=>unistr('Lista de Selecci\00F3n de Grupos')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.GROUP_SELECT_LIST'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- The render procedure is responsible for the rendering of the actual HTML control',
'-- of the new widget. APEX still takes care of the table cell for the layout,',
'-- the label, pre- and post element text. Only the html code between the pre- and',
'-- post element text is rendered by the plug-in. The render procedure has a',
'-- defined interface which every plug-in has to implement. It''s designed in a way',
'-- that future enhancements to the interface will not break existing plug-ins.',
'function render_group_selectlist (',
'    p_item                in apex_plugin.t_page_item,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_value               in varchar2,',
'    p_is_readonly         in boolean,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_page_item_render_result',
'is',
'    -- value without the lov null value',
'    l_value             varchar2(32767) := case when p_value = p_item.lov_null_value then null else p_value end;',
'',
'    l_name              varchar2(30);',
'    l_display_value     varchar2(32767);',
'    l_is_selected       boolean := false;',
'    l_value_found       boolean := false;',
'    l_column_value_list wwv_flow_plugin_util.t_column_value_list;',
'    l_group_value       varchar2(4000);',
'    l_last_group_value  varchar2(4000);',
'    l_open_group        boolean := false;',
'    l_result            wwv_flow_plugin_api.t_page_item_render_result;',
'    ',
'    procedure print_option_local (',
'        p_display_value in varchar2,',
'        p_return_value  in varchar2,',
'        p_compare_value in varchar2 )',
'    is',
'        l_is_selected boolean := false;',
'    begin',
'        if not l_value_found and',
'           (  p_return_value = p_compare_value',
'           or p_return_value is null and p_compare_value is null',
'           )',
'        then',
'            l_value_found := true;',
'            l_is_selected := true;',
'        end if;',
'        -- add list entry',
'        apex_plugin_util.print_option (',
'            p_display_value => p_display_value,',
'            p_return_value  => p_return_value,',
'            p_is_selected   => l_is_selected,',
'            p_attributes    => p_item.element_option_attributes );',
'    end print_option_local;',
'begin',
'    -- During plug-in development it''s very helpful to have some debug information',
'    if wwv_flow.g_debug then',
'        apex_plugin_util.debug_page_item (',
'            p_plugin              => p_plugin,',
'            p_page_item           => p_item,',
'            p_value               => p_value,',
'            p_is_readonly         => p_is_readonly,',
'            p_is_printer_friendly => p_is_printer_friendly );',
'    end if;',
'',
'    -- Based on the flags we normally generate different HTML code, but that',
'    -- depends on the plug-in.',
'    if p_is_readonly or p_is_printer_friendly then',
'        apex_plugin_util.print_hidden_if_readonly (',
'            p_item_name           => p_item.name,',
'            p_value               => p_value,',
'            p_is_readonly         => p_is_readonly,',
'            p_is_printer_friendly => p_is_printer_friendly );',
'',
'        -- get the display value',
'        l_display_value := apex_plugin_util.get_display_data (',
'                               p_sql_statement     => p_item.lov_definition,',
'                               p_min_columns       => 3, -- LOV requires 3 column',
'                               p_max_columns       => 3,',
'                               p_component_name    => p_item.name,',
'                               p_display_column_no => 1,',
'                               p_search_column_no  => 2,',
'                               p_search_string     => l_value,',
'                               p_display_extra     => p_item.lov_display_extra );',
'',
'        -- emit display span with the value',
'        apex_plugin_util.print_display_only (',
'            p_item_name        => p_item.name,',
'            p_display_value    => l_display_value,',
'            p_show_line_breaks => false,',
'            p_escape           => true,',
'            p_attributes       => p_item.element_attributes );',
'    else',
'        -- If a page item saves state, we have to call the get_input_name_for_page_item',
'        -- to render the internal hidden p_arg_names field. It will also return the',
'        -- HTML field name which we have to use when we render the HTML input field.',
'        l_name := apex_plugin.get_input_name_for_page_item(false);',
'        sys.htp.prn(''<select name="''||l_name||''" id="''||p_item.name||''" ''||',
'                  coalesce(p_item.element_attributes, ''class="group_selectlist"'')||''>'');',
'',
'        -- add display null entry',
'        if p_item.lov_display_null then',
'            --wwv_flow_utilities.add_null_value_entry(''ITEM'', l_name, p_item.lov_null_value);',
'            -- add list entry',
'            print_option_local (',
'                    p_display_value => p_item.lov_null_text,',
'                    p_return_value  => p_item.lov_null_value,',
'                    p_compare_value => nvl(l_value, p_item.lov_null_value) );',
'        end if;',
'',
'        -- get all values',
'        l_column_value_list := apex_plugin_util.get_data (',
'                                   p_sql_statement      => p_item.lov_definition,',
'                                   p_min_columns        => 3,',
'                                   p_max_columns        => 3,',
'                                   p_component_name     => p_item.name );',
'',
'        -- loop through the result',
'        for i in 1 .. l_column_value_list(1).count /* display value */',
'        loop',
'            l_group_value := l_column_value_list(3)(i); /* group column */',
'            -- has the group changed?',
'            if (l_group_value <> l_last_group_value) or',
'               (l_group_value is     null and l_last_group_value is not null) or',
'               (l_group_value is not null and l_last_group_value is     null)',
'            then',
'                if l_open_group then',
'                    sys.htp.p(''</optgroup>'');',
'                    l_open_group := false;',
'                end if;',
'                if l_group_value is not null then',
'                    sys.htp.p (''<optgroup label="''||wwv_flow_escape.html(l_group_value)||''">'');',
'                    l_open_group := true;',
'                end if;',
'                l_last_group_value := l_group_value;',
'            end if;',
'            -- add list entry',
'            print_option_local (',
'                p_display_value => l_column_value_list(1)(i),',
'                p_return_value  => l_column_value_list(2)(i),',
'                p_compare_value => l_value );',
'        end loop;',
'',
'        if l_open_group then',
'            sys.htp.p(''</optgroup>'');',
'        end if;',
'        -- Show at least the value if it hasn''t been found in the database',
'        if not l_value_found and l_value is not null and p_item.lov_display_extra then',
'            print_option_local (',
'                p_display_value => l_value,',
'                p_return_value  => l_value,',
'                p_compare_value => l_value );',
'        end if;',
'        -- close our select list',
'        sys.htp.p(''</select>'');',
'       ',
'        wwv_flow_javascript.add_onload_code (',
'            p_code => ''apex.builder.plugin.groupSelectList(''||',
'                wwv_flow_javascript.add_value(''#''||p_item.name)||',
'                ''{''||',
'                wwv_flow_javascript.add_attribute(''nullValue'',      p_item.lov_null_value, false, false)||',
'                ''});'' );',
'        ',
'        -- Tell APEX that this field is navigable',
'        l_result.is_navigable := true;',
'    end if;',
'    return l_result;',
'end render_group_selectlist;'))
,p_api_version=>1
,p_render_function=>'render_group_selectlist'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:READONLY:QUICKPICK:SOURCE:ELEMENT:HEIGHT:ELEMENT_OPTION:ENCRYPT:LOV:LOV_DISPLAY_NULL'
,p_substitute_attributes=>true
,p_reference_id=>1484532036002681868.4851
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
,p_about_url=>'http://www.oracleapex.info/'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(156398003741136975.4851)
,p_plugin_id=>wwv_flow_api.id(156397842989136966.4851)
,p_name=>'LOV'
,p_sql_min_column_count=>3
,p_sql_max_column_count=>3
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'select e.ename as d,',
'       e.empno as r,',
'       d.dname as grp',
'  from emp e,',
'       dept d',
' where d.deptno = e.deptno',
' order by d.dname, e.ename',
'</pre>'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356674103679447686.4851)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>'INTERNA: Oracle Cloud Identity Management'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749806821809026.4851
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356677018501447690.4851)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>'INTERNA: Cuentas de Base de Datos'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749511183746276.4851
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356714620431447729.4851)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>'INTERNA: Variable de Cabecera HTTP'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>708795120396802284.4851
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356714826109447729.4851)
,p_plugin_id=>wwv_flow_api.id(356714620431447729.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356715226328447729.4851)
,p_plugin_id=>wwv_flow_api.id(356714620431447729.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356715625060447730.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356715226328447729.4851)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356716102777447730.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356715226328447729.4851)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356716812982447731.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356715226328447729.4851)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356717301112447732.4851)
,p_plugin_id=>wwv_flow_api.id(356714620431447729.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356715226328447729.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>',
'<p>',
'<h3>Example:</h3>',
'<pre>http://sso.mycompany.com/?success=#CALLBACK#</pre>',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356717723010447732.4851)
,p_plugin_id=>wwv_flow_api.id(356714620431447729.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(356715226328447729.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356718117275447732.4851)
,p_plugin_id=>wwv_flow_api.id(356714620431447729.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356715226328447729.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'BUILTIN_URL,URL'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356718523646447732.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356718117275447732.4851)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356719006191447733.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356718117275447732.4851)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356719524049447733.4851)
,p_plugin_id=>wwv_flow_api.id(356714620431447729.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356785826007447783.4851)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>'INTERNA: Directorio LDAP'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>863910941135523528.4851
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Introduzca el nombre de usuario y la contrase\00F1a para la autenticaci\00F3n en el directorio LDAP identificado en la p\00E1gina de conexi\00F3n. Recuerde que las contrase\00F1as pueden ser sensibles a may\00FAsculas/min\00FAsculas.</p>'),
''))
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356786126109447783.4851)
,p_plugin_id=>wwv_flow_api.id(356785826007447783.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356786512722447783.4851)
,p_plugin_id=>wwv_flow_api.id(356785826007447783.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356786924086447785.4851)
,p_plugin_id=>wwv_flow_api.id(356785826007447783.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356787310773447789.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356786924086447785.4851)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356787811096447789.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356786924086447785.4851)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356788327860447789.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356786924086447785.4851)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356788802127447789.4851)
,p_plugin_id=>wwv_flow_api.id(356785826007447783.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356789212920447789.4851)
,p_plugin_id=>wwv_flow_api.id(356785826007447783.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356789604423447789.4851)
,p_plugin_id=>wwv_flow_api.id(356785826007447783.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356789212920447789.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356790016159447790.4851)
,p_plugin_id=>wwv_flow_api.id(356785826007447783.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356790429871447790.4851)
,p_plugin_id=>wwv_flow_api.id(356785826007447783.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356790826964447790.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356790429871447790.4851)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356791330010447790.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356790429871447790.4851)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356791830303447791.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(356790429871447790.4851)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356820723668447809.4851)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'INTERNA: Oracle Application Server Single Sign-On'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113750429890071859.4851
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/process_type/com_oracle_apex_proc_internal_run_as
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(358049287019022430.4851)
,p_plugin_type=>'PROCESS TYPE'
,p_name=>'COM.ORACLE.APEX.PROC.INTERNAL.RUN_AS'
,p_display_name=>'INTERNA: Ejecutar PLSQL como PARSE_AS'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('PROCESS TYPE','COM.ORACLE.APEX.PROC.INTERNAL.RUN_AS'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function  run_plsql_as_parse_as_exec (',
'    p_process in apex_plugin.t_process,',
'    p_plugin  in apex_plugin.t_plugin )',
'    return apex_plugin.t_process_exec_result',
'IS',
'-- VARIABLES',
'    l_return       apex_plugin.t_process_exec_result;',
'    l_exec_return  varchar2(32767); -- return from dynamic exec',
'    L_SQL          varchar2(32767); -- SQL STATEMENT',
'    l_plsql        varchar2(32767) := p_process.attribute_01; -- PL/SQL to Run',
'    l_parse_as     varchar2(32767) := p_process.attribute_02; -- Parse As Schema',
'',
'BEGIN',
'-- DEBUG',
'IF apex_application.g_debug then ',
'   apex_plugin_util.debug_process( p_plugin => p_plugin,',
'                                   p_process => p_process);',
'END IF;',
'--',
'-- Initialize the return message;',
'--',
'   l_return.success_message := p_process.success_message;',
'--',
'-- START',
'--',
'l_exec_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(l_parse_as, wwv_flow_user_api.get_default_schema)',
'        );',
'        ',
'if l_exec_return != ''SUCCESS'' then ',
'  RAISE_APPLICATION_ERROR (-20000, l_exec_return);',
'END IF;    ',
'--',
'-- END',
'--',
'RETURN l_return;',
'  EXCEPTION',
'    WHEN OTHERS THEN',
'      RAISE; ',
'END;'))
,p_api_version=>2
,p_execution_function=>'run_plsql_as_parse_as_exec'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(358049433955022432.4851)
,p_plugin_id=>wwv_flow_api.id(358049287019022430.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'PL/SQL '
,p_attribute_type=>'PLSQL'
,p_is_required=>true
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(358049808170022434.4851)
,p_plugin_id=>wwv_flow_api.id(358049287019022430.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Parse As Schama'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>20
,p_max_length=>255
,p_is_translatable=>false
,p_examples=>'&P0_SCHEMA.'
,p_help_text=>'Enter the name for the Pares As schema to run this PL/SQL as.'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_clob_code_editor
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(358990304554564248.4851)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.CLOB_CODE_EDITOR'
,p_display_name=>unistr('Editor de C\00F3digo CLOB')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.CLOB_CODE_EDITOR'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_clob_code_editor'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_clob_code_editor'
,p_standard_attributes=>'SOURCE_SQL:NO_DATA_FOUND_MESSAGE'
,p_substitute_attributes=>true
,p_reference_id=>1523790298062276372.4851
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(676977339973553465.4851)
,p_plugin_id=>wwv_flow_api.id(358990304554564248.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'SQL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676980777715553469.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676977339973553465.4851)
,p_display_sequence=>10
,p_display_value=>'SQL'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676981277541553469.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676977339973553465.4851)
,p_display_sequence=>20
,p_display_value=>'HTML'
,p_return_value=>'HTMLMIXED'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676977770635553466.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676977339973553465.4851)
,p_display_sequence=>30
,p_display_value=>'CSS'
,p_return_value=>'CSS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676978239833553468.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676977339973553465.4851)
,p_display_sequence=>40
,p_display_value=>'JavaScript'
,p_return_value=>'JAVASCRIPT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676978729233553468.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676977339973553465.4851)
,p_display_sequence=>45
,p_display_value=>'DDL'
,p_return_value=>'DDL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676979256651553468.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676977339973553465.4851)
,p_display_sequence=>50
,p_display_value=>'PL/SQL Block'
,p_return_value=>'PLSQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676979736413553468.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676977339973553465.4851)
,p_display_sequence=>70
,p_display_value=>'PL/SQL Expression'
,p_return_value=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676980259175553469.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676977339973553465.4851)
,p_display_sequence=>80
,p_display_value=>'PL/SQL Function Body'
,p_return_value=>'PL/SQL_FUNCTION_BODY'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(676981772220553469.4851)
,p_plugin_id=>wwv_flow_api.id(358990304554564248.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Height'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676982164262553470.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676981772220553469.4851)
,p_display_sequence=>1
,p_display_value=>'5'
,p_return_value=>'5'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676982645354553470.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676981772220553469.4851)
,p_display_sequence=>2
,p_display_value=>'10'
,p_return_value=>'10'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676983126689553470.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676981772220553469.4851)
,p_display_sequence=>3
,p_display_value=>'20'
,p_return_value=>'20'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676983690860553470.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676981772220553469.4851)
,p_display_sequence=>10
,p_display_value=>'30'
,p_return_value=>'30'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676984183466553470.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676981772220553469.4851)
,p_display_sequence=>20
,p_display_value=>'60'
,p_return_value=>'60'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676984682332553471.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676981772220553469.4851)
,p_display_sequence=>25
,p_display_value=>'80'
,p_return_value=>'80'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676985102281553471.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676981772220553469.4851)
,p_display_sequence=>30
,p_display_value=>'Automatic'
,p_return_value=>'AUTO'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(676985690696553471.4851)
,p_plugin_id=>wwv_flow_api.id(358990304554564248.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Read Only'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(676986072581553471.4851)
,p_plugin_id=>wwv_flow_api.id(358990304554564248.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>15
,p_prompt=>'Return Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(676977339973553465.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'PLSQL_EXPRESSION,PLSQL_FUNCTION_BODY'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676986457532553472.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676986072581553471.4851)
,p_display_sequence=>10
,p_display_value=>'VARCHAR2'
,p_return_value=>'VARCHAR2'
,p_help_text=>'VARCHAR2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(676986983941553472.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(676986072581553471.4851)
,p_display_sequence=>20
,p_display_value=>'BOOLEAN'
,p_return_value=>'BOOLEAN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(676987471598553472.4851)
,p_plugin_id=>wwv_flow_api.id(358990304554564248.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Remote Database ID item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>false
,p_is_common=>false
,p_is_translatable=>false
,p_help_text=>'Specify the an item containing the ID of the remote database to use for code validation.'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(676988705621553477.4851)
,p_plugin_id=>wwv_flow_api.id(358990304554564248.4851)
,p_name=>'SOURCE_SQL'
,p_is_required=>false
,p_sql_min_column_count=>1
,p_sql_max_column_count=>1
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select clob_content',
'from demo_scripts'))
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_simple_staus
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(430010507045639589.4851)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.SIMPLE_STAUS'
,p_display_name=>'Placa de estado simple'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.SIMPLE_STAUS'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function simple_status( p_region              in apex_plugin.t_region,',
'                        p_plugin              in apex_plugin.t_plugin,',
'                        p_is_printer_friendly in boolean ) return apex_plugin.t_region_render_result is',
'    l_retval         apex_plugin.t_region_render_result;',
'    --',
'    --',
'    c_result_alias    constant varchar2(255)  := p_region.attribute_01;',
'    c_label_alias     constant varchar2(255)  := p_region.attribute_02;',
'    c_status_alias    constant varchar2(255)  := p_region.attribute_03;',
'    c_link            constant varchar2(4000) := p_region.attribute_04;',
'    c_link_label      constant varchar2(255)  := p_region.attribute_05;',
'    --',
'    l_column_value_list apex_plugin_util.t_column_value_list2;',
'    l_label_column_number    pls_integer;',
'    l_result_column_number   pls_integer;',
'    l_status_column_number  pls_integer;',
'    --',
'    l_app_id            varchar2(255) := :APP_ID;',
'    l_session_id        varchar2(255) := :APP_SESSION;',
'    l_label             varchar2(255);',
'    l_result            varchar2(20);',
'    l_status            varchar2(255);',
'    l_link              varchar2(4000);',
'',
'BEGIN',
'    -- Get data from the ',
'    l_column_value_list := apex_plugin_util.get_data2(',
'        p_sql_statement  => p_region.source,',
'        p_min_columns    => 3,',
'        p_max_columns    => null,',
'        p_component_name => p_region.name',
'    );',
'',
'    l_label_column_number := apex_plugin_util.get_column_no (',
'        p_attribute_label   => ''LABEL'',',
'        p_column_alias      => c_label_alias,',
'        p_column_value_list => l_column_value_list,',
'        p_is_required       => true,',
'        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'    );',
'    l_result_column_number := apex_plugin_util.get_column_no (',
'        p_attribute_label   => ''RESULT'',',
'        p_column_alias      => c_result_alias,',
'        p_column_value_list => l_column_value_list,',
'        p_is_required       => true,',
'        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'    );',
'    l_status_column_number := apex_plugin_util.get_column_no (',
'        p_attribute_label   => ''STATUS'',',
'        p_column_alias      => c_status_alias,',
'        p_column_value_list => l_column_value_list,',
'        p_is_required       => true,',
'        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'    );',
'',
'    for l_row_number in 1 .. l_column_value_list(1).value_list.count loop',
'        l_label  := l_column_value_list(l_label_column_number).value_list(l_row_number).varchar2_value;',
'        l_result := l_column_value_list(l_result_column_number).value_list(l_row_number).varchar2_value;',
'        l_status := l_column_value_list(l_status_column_number).value_list(l_row_number).varchar2_value;',
'    end loop;',
'',
'    -- Generate ',
'    sys.htp.p(''<div class="a-IconPanel">'');',
'    sys.htp.p(''  <span class="a-IconPanel-icon a-Icon'');',
'      if  l_result = ''SUCCESS'' then',
'        sys.htp.prn(''icon-status-success" aria-label="''||wwv_flow_lang.system_message(''REST_WS.SIMPLE_STATUS_SUCCESS'')||''"'');',
'      elsif l_result = ''FAILURE'' then',
'        sys.htp.prn(''icon-status-failure" aria-label="''||wwv_flow_lang.system_message(''REST_WS.SIMPLE_STATUS_FAILURE'')||''"'');',
'      else ',
'        sys.htp.prn(''icon-status-warning" aria-label="''||wwv_flow_lang.system_message(''REST_WS.SIMPLE_STATUS_WARNING'')||''"'');',
'      end if;',
'    sys.htp.p(''></span>'');',
'    sys.htp.p(''  <span class="a-IconPanel-setting">''||apex_plugin_util.escape(l_label, TRUE)||''</span>'');',
'    sys.htp.p(''  <span class="a-IconPanel-status">''||apex_plugin_util.escape(l_status, TRUE)||''</span>'');',
'   -- sys.htp.p(''          <span class="a-IconPanel-actions">'');',
'   -- sys.htp.p(''            <a href="''||apex_util.prepare_url(c_link)||''">'');',
'   -- sys.htp.p(''              <button class="a-Button" type="button">''||apex_plugin_util.escape(c_link_label, TRUE)||''</button>'');',
'   -- sys.htp.p(''            </a>'');',
'   -- sys.htp.p(''          </span>'');',
'    sys.htp.p(''  </span>'');',
'    sys.htp.p(''  </span>'');',
'    sys.htp.p(''</div>'');',
'    ',
'    return l_retval;    ',
'END;'))
,p_api_version=>2
,p_render_function=>'simple_status'
,p_standard_attributes=>'SOURCE_LOCATION'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_help_text=>unistr('<p>El estado simple se dise\00F1a para mostrar un estado simple en verde o rojo en funci\00F3n de un valor TRUE o FALSE.</p>')
,p_version_identifier=>'5.2.0'
,p_files_version=>2
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(460317866107496515.4851)
,p_plugin_id=>wwv_flow_api.id(430010507045639589.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Result'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'Result value must be one of the following: SUCCESS, FAILURE, WARNING'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(460319023465506482.4851)
,p_plugin_id=>wwv_flow_api.id(430010507045639589.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Label'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(460320220356509585.4851)
,p_plugin_id=>wwv_flow_api.id(430010507045639589.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Status'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(460321404029511456.4851)
,p_plugin_id=>wwv_flow_api.id(430010507045639589.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(460325854825654129.4851)
,p_plugin_id=>wwv_flow_api.id(430010507045639589.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Link Label'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(430010795499639591.4851)
,p_plugin_id=>wwv_flow_api.id(430010507045639589.4851)
,p_name=>'SOURCE_LOCATION'
,p_supported_ui_types=>'DESKTOP'
,p_depending_on_has_to_exist=>true
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(852575313487939509.4851)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>unistr('Autorizaci\00F3n de Desarrollador')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494.4851
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(786859129856512840.4851)
,p_plugin_id=>wwv_flow_api.id(852575313487939509.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786859582059512840.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786860016578512841.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786860517600512841.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786861062823512842.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786861576769512842.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786862070345512842.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786862507250512842.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786863065493512843.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786863571025512843.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786864096990512843.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786864588869512843.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786865010547512844.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(786859129856512840.4851)
,p_display_sequence=>120
,p_display_value=>'PKG_APPS: Ability to install packaged applications'
,p_return_value=>'PKG_APPS'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_code_editor
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2638440060724883493.4851)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.CODE_EDITOR'
,p_display_name=>unistr('Editor de C\00F3digos')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.CODE_EDITOR'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_code_editor'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_code_editor'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:READONLY:SOURCE:ELEMENT:WIDTH:HEIGHT:ENCRYPT'
,p_substitute_attributes=>true
,p_reference_id=>1510773430399830292.4851
,p_subscribe_plugin_settings=>true
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359514210872120253.4851)
,p_plugin_id=>wwv_flow_api.id(2638440060724883493.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'SQL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359514615111120253.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_display_sequence=>10
,p_display_value=>'SQL'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359515192442120253.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_display_sequence=>20
,p_display_value=>'HTML'
,p_return_value=>'HTMLMIXED'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359515604171120255.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_display_sequence=>30
,p_display_value=>'CSS'
,p_return_value=>'CSS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359516100752120256.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_display_sequence=>40
,p_display_value=>'JavaScript'
,p_return_value=>'JAVASCRIPT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359516619645120256.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_display_sequence=>45
,p_display_value=>'DDL'
,p_return_value=>'DDL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359517145529120257.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_display_sequence=>50
,p_display_value=>'PL/SQL Block'
,p_return_value=>'PLSQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359517682117120257.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_display_sequence=>60
,p_display_value=>'PL/SQL Functions/Procedures'
,p_return_value=>'PLSQL_FUNCTIONS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359518123182120258.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_display_sequence=>70
,p_display_value=>'PL/SQL Expression'
,p_return_value=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359518619291120258.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_display_sequence=>80
,p_display_value=>'PL/SQL Function Body'
,p_return_value=>'PLSQL_FUNCTION_BODY'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359519104029120259.4851)
,p_plugin_id=>wwv_flow_api.id(2638440060724883493.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Return Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'PLSQL_EXPRESSION,PLSQL_FUNCTION_BODY'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359519540166120259.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359519104029120259.4851)
,p_display_sequence=>10
,p_display_value=>'VARCHAR2'
,p_return_value=>'VARCHAR2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359520050676120259.4851)
,p_plugin_attribute_id=>wwv_flow_api.id(359519104029120259.4851)
,p_display_sequence=>20
,p_display_value=>'BOOLEAN'
,p_return_value=>'BOOLEAN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359520553519120259.4851)
,p_plugin_id=>wwv_flow_api.id(2638440060724883493.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Show Query Builder'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(359514210872120253.4851)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'SQL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359520981820120260.4851)
,p_plugin_id=>wwv_flow_api.id(2638440060724883493.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Adjustable Height'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_supported_ui_types=>'DESKTOP'
,p_is_translatable=>false
,p_help_text=>'If Yes the user can adjust the height of the code editor.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359521347283120260.4851)
,p_plugin_id=>wwv_flow_api.id(2638440060724883493.4851)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Remote  Database ID item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_is_translatable=>false
,p_help_text=>'Specify a page item containing the remote database ID to use for code validation.'
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(4971601142302345.4851)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>'Escritorio'
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>3
,p_home_url=>'f?p=&APP_ID.:500:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4851
,p_navigation_list_id=>wwv_flow_api.id(719172975581246435.4851)
,p_navigation_list_position=>'TOP'
,p_navigation_list_template_id=>wwv_flow_api.id(719752075880969362.4851)
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'CERO'
,p_autocomplete_on_off=>'OFF'
,p_protection_level=>'D'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(54182919367062219.4851)
,p_plug_name=>'JavaScript for Spinner on Tree Click'
,p_region_name=>'ordsTreeCSS'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BEFORE_FOOTER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script>',
'    $(document).ready(function() {',
'',
'var $wP;',
'',
'$( "#Tree_tree" ).treeView({',
'          activateNode: function( event ) {',
'                $wP = apex.widget.waitPopup();',
'          }',
'});',
'        //$("[role=''treeitem'']").click(function(){',
'        //    $wP = apex.widget.waitPopup();',
'        //});',
'        ',
unistr('        // En el siguiente c\00F3digo: '),
unistr('        //El c\00F3digo del primer m\00E9todo setTimeout tiene un retraso de 1 ms. Esto tiene como \00FAnico objetivo agregar la funci\00F3n a la cola de la interfaz de usuario '),
unistr('        //Puesto que setTimeout se ejecuta de forma as\00EDncrona, el int\00E9rprete de Javascript seguir\00E1 llamando directamente a la sentencia return, '),
unistr('        //que, a su vez, dispara el cuadro de di\00E1logo modal de los exploradores. Esto bloquear\00E1 la cola de la interfaz de usuario y el c\00F3digo del primer setTimeout '),
unistr('        //no se ejecuta hasta que se haya cerrado el modal. Si el usuario pulsa cancelar, disparar\00E1 otro setTimeout que se activa '),
unistr('        //en aproximadamente 1 segundo. Si el usuario ha confirmado con aceptar, se redireccionar\00E1 al usuario y no se activar\00E1 nunca el segundo setTimeout '),
'',
'        $(window).bind(''beforeunload'', function() {',
'            setTimeout(function() { ',
'                setTimeout(function() {',
'                    $wP.remove();',
'                }, 500);',
'            }, 1);',
'            return ; ',
'        });',
'',
'    });',
'</script>'))
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388765343250781060.4851)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-sql-workshop'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388765545527781060.4851)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(388765343250781060.4851)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6690019401688459.4851)
,p_plug_name=>'APEX Tabs'
,p_region_name=>'a_Header_menu'
,p_parent_plug_id=>wwv_flow_api.id(388765545527781060.4851)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(719172975581246435.4851)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388773697797786787.4851)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388765715263781060.4851)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(388765545527781060.4851)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388765918985781061.4851)
,p_plug_name=>'APEX 5 - Home Link'
,p_parent_plug_id=>wwv_flow_api.id(388765545527781060.4851)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388766163882781061.4851)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(388765343250781060.4851)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388766385158781061.4851)
,p_plug_name=>'APEX 5 - Search'
,p_parent_plug_id=>wwv_flow_api.id(388766163882781061.4851)
,p_region_css_classes=>'a-Header-search'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-SearchBox a-SearchBox--noGoButton a-SearchBox--autoExpand a-SearchBox--fill">'');',
'sys.htp.p(''  <div class="a-SearchBox-field">'');',
'sys.htp.p(''    <span class="a-SearchBox-icon"><span class="a-Icon icon-search"></span></span>'');',
'sys.htp.p(''    <label for="P0_SEARCH" class="visuallyhidden">Search</label>'');',
'sys.htp.p(''    <input type="text" class="a-SearchBox-input" id="P0_SEARCH" placeholder="''||wwv_flow_lang.system_message(''WWV_FLOW_QUICK_FLOW.SEARCH'')||''">'');',
'sys.htp.p(''  </div>'');',
'sys.htp.p(''</div>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388766531252781061.4851)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_api.id(388766163882781061.4851)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388802482283857068.4851)
,p_plug_name=>'APEX 5 - Administration Menu'
,p_region_name=>'adminMenu'
,p_parent_plug_id=>wwv_flow_api.id(388766531252781061.4851)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>120
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697672714234539780.4851)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388773934841786788.4851)
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(486772471745301734.4851)
,p_plug_name=>'APEX 5 - Help Menu'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_api.id(388766531252781061.4851)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>130
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697677732086541316.4851)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388773934841786788.4851)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388766724611781061.4851)
,p_plug_name=>'APEX 5 - Header Account'
,p_parent_plug_id=>wwv_flow_api.id(388766163882781061.4851)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388766982392781062.4851)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-sql-workshop'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>90
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388767112596781062.4851)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_api.id(388766982392781062.4851)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>100
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388803868206871278.4851)
,p_plug_name=>'APEX 5 - Breadcrumb'
,p_parent_plug_id=>wwv_flow_api.id(388767112596781062.4851)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_display_point=>'BODY'
,p_menu_id=>wwv_flow_api.id(6687412253641141.4851)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(388777204236790831.4851)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388767384999781062.4851)
,p_plug_name=>'APEX 5 - Control Bar Right'
,p_parent_plug_id=>wwv_flow_api.id(388766982392781062.4851)
,p_region_css_classes=>'a-ControlBar-col'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>110
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(334841282133279702.4851)
,p_plug_name=>'Esquema'
,p_region_name=>'apex-control-icons'
,p_parent_plug_id=>wwv_flow_api.id(388767384999781062.4851)
,p_region_css_classes=>'a-Form a-Form--small a-Form--schemaSelect'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(521638462089366446.4851)
,p_plug_name=>'CSS Override for ORDS Side'
,p_region_name=>'ordsTreeCSS'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'.a-Side--large {',
'    width: 400px;',
'    min-width: 400px;',
'}',
'</style>'))
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1070722020037074959.4851)
,p_plug_name=>unistr('Definiciones de servicio RESTful de ORDS (esta selecci\00F3n causa navegaci\00F3n en la p\00E1gina)')
,p_region_name=>'Tree'
,p_region_css_classes=>'a-PageDesigner-treeWrap a-TreeView--ords'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with nodes as ',
'(',
'-- MAIN PARENT NODE',
'SELECT -10 as ID, ''RESTful Data Services'' as name, -99 as node, ''RS'' as type, ''RS''||-10 as tree_id',
'from sys.dual',
'UNION',
'-- MODULES NODE',
'select -3 as ID, wwv_flow_lang.system_message(''REST_WS.TREE_MODULES'') as name, -10 as node, ''MD'' as type, ''MD''||-3 as tree_id',
'from sys.dual',
'UNION',
'-- Individual Modules',
'select n001 as ID, c001 as name, -3 as node, ''MM'' as type, ''MM''||n001 as tree_id',
'  from wwv_flow_collections ',
' where collection_name = ''ORDS_MODULES''',
'',
'UNION',
'-- Individual Templates',
'select n001 as ID ,  c001 as name , n002 as node, ''MT'' as type, ''MT''||n001 as tree_id',
'  from wwv_flow_collections ',
' where collection_name = ''ORDS_TEMPLATES''',
'UNION ',
'-- Individual Handlers',
'select n001 as ID , c002 as name, n002 as node, ''TH'' as type, ''TH''||n001 as tree_id',
'  from wwv_flow_collections ',
' where collection_name = ''ORDS_HANDLERS''',
'UNION ',
'-- Individual Parmeters',
'select n001 as ID, c001 as name, n002 as node, ''HP'' as type, ''HP''||n001 as tree_id',
'  from wwv_flow_collections ',
' where collection_name = ''ORDS_PARAMETERS''',
'UNION',
'-- PRIVILEGE NODE',
'SELECT -2 as ID, wwv_flow_lang.system_message(''REST_WS.TREE_PRIVILEGES'') as name, -10 as node, ''PR'' as type, ''PR''||-2 as tree_id',
'from sys.dual',
'UNION ',
'-- Individual Privileges',
'select n001 as ID, c002 as name, -2 as node, ''PP'' as type, ''PP''||n001 as tree_id',
'from wwv_flow_collections ',
' where collection_name = ''ORDS_PRIVILEGES''',
'UNION',
'-- ROLES NODE',
'SELECT -1 as ID, wwv_flow_lang.system_message(''REST_WS.TREE_ROLES'') as name, -10 as node, ''RO'' as type, ''RO''||-1 as tree_id',
'from sys.dual',
'UNION ',
'-- Individual Roles',
'select n001 as ID, c001 as name, -1 as node, ''RR'' as type, ''RR''||n001 as tree_id',
'from wwv_flow_collections ',
' where collection_name = ''ORDS_ROLES''',
'UNION ',
'-- OBJECTS NODE',
'SELECT 0 as ID, wwv_flow_lang.system_message(''REST_WS.TREE_ENABLED_OBJECTS'') as name, -10 as node, ''OB'' as type, ''OB''||0 as tree_id',
'from sys.dual',
'',
')',
'select ',
'        case when connect_by_isleaf = 1 then 0 ',
'              when level = 1 then 1 ',
'              else -1 ',
'        end as status,',
'        level,',
'        name as title,',
'        case when type = ''RS'' then ''icon-rest-services''',
'             when type = ''MD'' then ''icon-rest-modules''',
'             when type = ''MM''  then ''icon-rest-module''',
'             when type = ''MT''  then ''icon-rest-template''',
'             when type = ''TH''  then ''icon-rest-handler''',
'             when type = ''HP''  then ''icon-rest-parameter''',
'             when type = ''PR'' then ''icon-rest-privileges''',
'             when type = ''PP''  then ''icon-rest-privilege''',
'             when type = ''RO'' then ''icon-rest-roles''',
'             when type = ''RR''  then ''icon-rest-role''',
'             when type = ''OB''  then ''icon-rest-object''',
'             else null',
'       end as icon, ',
'       tree_id as value,',
'       name as tooltip,',
'        case when type = ''RS'' then apex_util.prepare_url(''f?p=''||:app_id||'':100:''||:app_session||'':::100:P0_SELECTED_NODE:''||tree_id)',
'             when type = ''MD'' then apex_util.prepare_url(''f?p=''||:app_id||'':110:''||:app_session||''::110:RP,RIR:P0_SELECTED_NODE:''||tree_id)',
'             when type = ''MM''  then apex_util.prepare_url(''f?p=''||:app_id||'':120:''||:app_session||'':::120:P0_SELECTED_NODE,P120_MODULE_ID:''||tree_id||'',''||id)',
'             when type = ''MT''  then apex_util.prepare_url(''f?p=''||:app_id||'':130:''||:app_session||'':::130:P0_SELECTED_NODE,P130_TEMPLATE_ID:''||tree_id||'',''||id)',
'             when type = ''TH''  then apex_util.prepare_url(''f?p=''||:app_id||'':140:''||:app_session||'':::140:P0_SELECTED_NODE,P140_HANDLER_ID:''||tree_id||'',''||id)',
'             when type = ''HP''  then apex_util.prepare_url(''f?p=''||:app_id||'':140:''||:app_session||'':::140:P0_SELECTED_NODE,P140_HANDLER_ID:''||tree_id||'',''||node)',
'             when type = ''PR'' then apex_util.prepare_url(''f?p=''||:app_id||'':150:''||:app_session||'':::150:P0_SELECTED_NODE:''||tree_id)',
'             when type = ''PP''  then apex_util.prepare_url(''f?p=''||:app_id||'':160:''||:app_session||'':::160:P0_SELECTED_NODE,P160_PRIVILEGE_ID:''||tree_id||'',''||id)',
'             when type = ''RO'' then apex_util.prepare_url(''f?p=''||:app_id||'':170:''||:app_session||'':::170:P0_SELECTED_NODE:''||tree_id)',
'             when type = ''RR''  then apex_util.prepare_url(''f?p=''||:app_id||'':180:''||:app_session||'':::180:P0_SELECTED_NODE,P180_ROLE_ID:''||tree_id||'',''||id)',
'             when type = ''OB''  then apex_util.prepare_url(''f?p=''||:app_id||'':190:''||:app_session||'':::RP,RIR:P0_SELECTED_NODE:''||tree_id)',
'             else null',
'       end as link',
'from nodes',
'connect by prior ID = node',
'start with node = -99',
'order siblings by upper(title)',
'',
''))
,p_plug_source_type=>'NATIVE_JSTREE'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_plugin_init_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(options) {',
'    options.makeNodeAdapter = function(data, types, hasIdentity) {',
'        var a,',
'            ids = apex.storage.getScopedSessionStorage( { usePageId: false, useAppId: true} ).getItem("_rwsTreeState");',
'        if ( ids ) {',
'            ids = ids.split(":");',
'        }',
'        a = $.apex.treeView.makeDefaultNodeAdapter( data, types, hasIdentity, ids );',
'        return a;',
'    }',
'    return options;',
'}'))
,p_attribute_02=>'S'
,p_attribute_03=>'P0_SELECTED_NODE'
,p_attribute_04=>'DB'
,p_attribute_08=>'a-Icon'
,p_attribute_10=>'TITLE'
,p_attribute_11=>'LEVEL'
,p_attribute_12=>'ICON'
,p_attribute_15=>'STATUS'
,p_attribute_20=>'VALUE'
,p_attribute_22=>'TOOLTIP'
,p_attribute_23=>'LEVEL'
,p_attribute_24=>'LINK'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1430615932721831909.4851)
,p_plug_name=>'RESTful Service'
,p_region_name=>'sideTree'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_c1_cnt           pls_integer := 0;',
'  l_c2_cnt           pls_integer := 0;',
'  l_c3_cnt           pls_integer := 0;',
'  l_active_module    varchar2(20) := null;',
'  l_active_template  varchar2(20) := null;',
'  l_active_handler   varchar2(20) := null;',
'  l_active_new_temp  varchar2(20) := null;',
'  l_active_new_hand  varchar2(20) := null;',
'',
'begin',
'',
'  sys.htp.p(''<style>'');',
'  sys.htp.p(''#sideTree {width: 400px;}'');',
'  sys.htp.p(''#sideTree .rc-content-main {min-height: 600px;}'');',
'  sys.htp.p(''#apex-left-sidebar {width: 400px; margin-left: -410px;}'');',
'  sys.htp.p(''#apex-main {padding-left: 410px;}'');',
'  sys.htp.p(''</style>'');',
'  sys.htp.p(''<ul class="databaseServicesTree">'');',
'  ------------',
'  -- module',
'  --',
'  for c4 in ( select max(name) name from WWV_FLOW_RT$MODULES',
'                where id = :P10_ID',
'  ',
'  ) ',
'  loop',
'      l_c3_cnt := l_c3_cnt + 1;',
'      if :P10_ID = :ACTIVE_NODE then',
'          l_active_module := '' class="active"'';',
'      else',
'          l_active_module := null;',
'      end if;',
'      sys.htp.p(''<li''||l_active_module||''><a href="f?p=''||:app_id||'':10:''||:app_session||''::::P10_ID,ACTIVE_NODE:''||:P10_ID||'',''||:P10_ID||''" title="''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_NAME'')||'': ''||',
'                wwv_flow_escape.html(c4.name)||''" alt="''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_NAME'')||'': ''||',
'                wwv_flow_escape.html(c4.name)||''"><span class="visuallyhidden">''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_NAME'')||'':</span>''||',
'                wwv_flow_escape.html(c4.name)||''</a>'');',
'     ',
'      -- NEW',
'      sys.htp.p(''<ul>'');',
'      -- NEw  ',
'',
'      ------------',
'      -- templates',
'      -- ',
'      l_c1_cnt := 0;',
'      for c1 in (select id,',
'                        module_id,',
'                        uri_template,',
'                        priority,',
'                        etag_type,',
'                        etag_query,',
'                        created_by,',
'                        created_on,',
'                        updated_by,',
'                        updated_on,',
'                        (select max(uri_prefix) from WWV_FLOW_RT$MODULES m',
'                         where m.id = t.module_id) uri_prefix',
'                  from wwv_flow_rt$templates t',
'                 where module_id = :P10_ID',
'                   and security_group_id = :flow_security_group_id',
'                 order by uri_template)',
'      loop',
'          l_c1_cnt := l_c1_cnt + 1;',
'          if c1.id = :ACTIVE_NODE then',
'              l_active_template := '' active'';',
'          else',
'              l_active_template := null;',
'          end if;',
'          sys.htp.p(''<li class="method''||l_active_template||''"><a href="f?p=''||:app_id||'':11:''||:app_session||''::::P11_ID,ACTIVE_NODE:''||c1.id||'',''||c1.id||''" title="''||wwv_flow_lang.system_message(''DB_SERVICES_URI_TEMPLATE'')||'': ''||',
'                wwv_flow_escape.html(c1.uri_template)||''"><span class="visuallyhidden">''||wwv_flow_lang.system_message(''DB_SERVICES_URI_TEMPLATE'')||'':</span>''||wwv_flow_escape.html(c1.uri_template)||',
'              ''</a>'');',
'',
'          -- NEW',
'          sys.htp.p(''<ul>'');',
'          -- NEw',
'      ',
'          l_c2_cnt := 0;     ',
'          for c2 in (select id,',
'                            template_id,',
'                            source_type,',
'                            format,',
'                            method,',
'                            mimes_allowed,',
'                            items_per_page,',
'                            source,',
'                            created_by,',
'                            created_on,',
'                            updated_by,',
'                            updated_on',
'                     from wwv_flow_rt$handlers',
'                    where template_id = c1.id',
'                      and security_group_id = :flow_security_group_id',
'                    order by method)',
'          loop',
'              l_c2_cnt := l_c2_cnt + 1;',
'              if c2.id = :ACTIVE_NODE then',
'                  l_active_handler := '' active'';',
'              else',
'                  l_active_handler := null;',
'              end if;',
'/*              sys.htp.p(''<li class="parameter''||l_active_handler||''"><a href="f?p=''||:app_id||'':9:''||:app_session||'':::9:P9_ID,ACTIVE_NODE:''||c2.id||'',''||c2.id||''" title="''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER'')||'': ''||',
'                wwv_flow_escape.html(c2.method)||''" alt="''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER'')||'': ''||',
'                wwv_flow_escape.html(c2.method)||''">''||',
'                wwv_flow_escape.html(c2.method)||''</a></li>''); */',
'',
'               sys.htp.p(''<li class="parameter''||l_active_handler||''"><a href="f?p=''||:app_id||'':9:''||:app_session||'':::9:P9_ID,ACTIVE_NODE:''||c2.id||'',''||c2.id||''" title="''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER'')||'': ''||',
'                wwv_flow_escape.html(c2.method)||''" ><span class="visuallyhidden">''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER'')||'':</span>''||',
'                wwv_flow_escape.html(c2.method)||''</a></li>'');',
'               ',
'          end loop; -- c2 ',
'',
'          if :ACTIVE_NODE = 1 and :P9_TEMPLATE_ID = c1.id then',
'              l_active_new_hand := '' active'';',
'          else',
'              l_active_new_hand := null;',
'          end if;',
'         if not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'') then -- If we can access ORDS then we don''t want to allow them to create new ones',
'            sys.htp.p(''<li class="createLink parameter''||l_active_new_hand||''"><a href="f?p=''||:app_id||'':9:''||:app_session||',
'            '':::9:P9_TEMPLATE_ID,ACTIVE_NODE:''||c1.id||'',1" title="''||wwv_flow_lang.system_message(''db_services_create_handler'')||''" >''||wwv_flow_lang.system_message(''db_services_create_handler'')||''</a></li>'');',
'         end if;',
'--NEW',
'          sys.htp.p(''</ul>'');',
'          sys.htp.p(''</li>'');',
'--NEW',
'      end loop; -- c1',
'  ',
'      if :ACTIVE_NODE = 2 then',
'          l_active_new_temp := '' active'';',
'      else',
'          l_active_new_temp := null;',
'      end if;',
'',
'      if not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'') then -- If we can access ORDS then we don''t want to allow them to create new ones',
'          sys.htp.p(''<li class="createLink method''||l_active_new_temp||''"><a href="f?p=''||:app_id||'':11:''||:app_session||',
'                    '':::11:P11_MODULE_ID,ACTIVE_NODE:''||:P10_ID||'',2" title="''||wwv_flow_lang.system_message(''db_services_create_template'')||''" >''||wwv_flow_lang.system_message(''db_services_create_template'')||''</a></li>'');',
'      END IF;',
'',
'--NEW ',
'      sys.htp.p(''</ul>'');',
'      sys.htp.p(''</li>'');',
'--NEW',
'  end loop; -- c4',
'  sys.htp.p(''</ul>'');',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_IN_CONDITION'
,p_plug_display_when_condition=>'9,10,11,12'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1652096011106668228.4851)
,p_plug_name=>'Ejemplo'
,p_region_template_options=>'#DEFAULT#:is-collapsed:a-Region--noPadding:a-Region--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719691677138942761.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.prn(''<br /><b>''||wwv_flow_lang.system_message(''DB_SERVICES_URI'')||''</b>'');',
'sys.htp.prn(''<pre>'');',
'sys.htp.prn(''hr/employees/{ID}''||chr(10));',
'sys.htp.prn(''|_|_________|____|''||chr(10));',
'sys.htp.prn('' |     |      |''||chr(10));',
'sys.htp.prn('' |     |       -''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER_BIND_VARIABLE'')||chr(10));',
'sys.htp.prn('' |     | ''||chr(10));',
'sys.htp.prn('' |      - ''||wwv_flow_lang.system_message(''DB_SERVICES_TEMPLATE_URI'')||chr(10));',
'sys.htp.prn('' |''||chr(10));',
'sys.htp.prn(''  - ''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_URI'')||chr(10));',
'sys.htp.prn('' </pre>'');',
'',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_NAME'')||''</b>'');',
'sys.htp.prn(''<pre>oracle.example.hr</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_URI_PRIFIX'')||''</b>'');',
'sys.htp.prn(''<pre>hr/</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_TEMPLATE_URI'')||''</b>'');',
'sys.htp.prn(''<pre>employees/{ID}</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER_METHOD'')||''</b>'');',
'sys.htp.prn(''<pre>GET</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER_SRC_TYPE'')||''</b>'');',
'sys.htp.prn(''<pre>Query One Row</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER_SOURCE'')||''</b>'');',
'sys.htp.prn(''<pre>select EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO                 ',
' from EMP where EMPNO = :ID</pre>'');',
'sys.htp.prn(''<br/><b>JSON</b><br/>'');',
'sys.htp.prn(''<pre>'');',
'sys.htp.prn(''{"items":[{"empno":7839,"ename":"KING","job":"PRESIDENT","hiredate":"1981-11-17T08:00:00Z"<br/>'');',
'sys.htp.prn('',"sal":5000,"deptno":10}]}'');',
'sys.htp.prn(''</pre>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_IN_CONDITION'
,p_plug_display_when_condition=>'3,10,11'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388782753453839938.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(388765918985781061.4851)
,p_button_name=>'Home'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388776713638789177.4851)
,p_button_image_alt=>'Inicio'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4500:1000:&SESSION.::&DEBUG.::::'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-home'
);
end;
/
begin
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3773582590058301548.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(388766531252781061.4851)
,p_button_name=>'SPOTLIGHT'
,p_button_static_id=>'header-spotlightSearch'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719736129383947861.4851)
,p_button_image_alt=>unistr('B\00FAsqueda Spotlight')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-actionButton a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-search'
,p_button_cattributes=>'data-action="spotlight-search"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388782965786839939.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(388766531252781061.4851)
,p_button_name=>'Administration'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388776568320789175.4851)
,p_button_image_alt=>unistr('Administraci\00F3n')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388783141974839939.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(388766531252781061.4851)
,p_button_name=>'Feedback'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388776713638789177.4851)
,p_button_image_alt=>'Comentarios'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
,p_required_patch=>wwv_flow_api.id(693462905220662747.4851)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388783358311839939.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(388766531252781061.4851)
,p_button_name=>'Help'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388776568320789175.4851)
,p_button_image_alt=>'Ayuda'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(243401953198037106.4851)
,p_name=>'P0_EXPANDED_NODES'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1070722020037074959.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(334841331685279703.4851)
,p_name=>'P0_SCHEMA'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(334841282133279702.4851)
,p_prompt=>'Esquema'
,p_source=>'wwv_flow_user_api.get_default_schema'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'DATABASE SCHEMAS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4850L1 */ wwv_flow_escape.html(upper(c.schema)) d, upper(c.schema) v',
'from   wwv_flow_company_schemas c,',
'       wwv_flow_fnd_user u',
'where  c.security_group_id = :flow_security_group_id and',
'       u.security_group_id = :flow_security_group_id and',
'       u.user_name = :flow_user and',
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or',
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)',
'order by 1'))
,p_cHeight=>1
,p_tag_css_classes=>'a-Form-select'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
,p_display_when_type=>'FUNCTION_BODY'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>'Identifica el nombre del propietario del esquema de base de datos.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(370120781439653727.4851)
,p_name=>'P0_SELECTED_NODE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1070722020037074959.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(619047997355969825.4851)
,p_name=>'Navigate on Change'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P0_SCHEMA'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(619048054572969826.4851)
,p_event_id=>wwv_flow_api.id(619047997355969825.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.navigation.redirect(''f?p=4850:100:''+ $v(''pInstance'')+'':::100:P0_SELECTED_NODE,P0_SCHEMA:RS-10,''+$v(''P0_SCHEMA''));'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(243402045691037107.4851)
,p_name=>'SAVE Expanded Items'
,p_event_sequence=>40
,p_bind_type=>'bind'
,p_bind_event_type=>'unload'
,p_display_when_type=>'FUNCTION_BODY'
,p_display_when_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    if instr(:G_ORDS_PAGES,'':''||:APP_PAGE_ID||'':'') != 0 then ',
'        return true;',
'    else',
'         return false;',
'    end if;',
'end;'))
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(243402154992037108.4851)
,p_event_id=>wwv_flow_api.id(243402045691037107.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var ids = apex.region("Tree").call("getExpandedNodeIds").join(":");',
'apex.storage.getScopedSessionStorage({usePageId: false, useAppId: true}).setItem("_rwsTreeState", ids);'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(340329744285995117.4851)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load ORDS_MODULES Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_plsql     VARCHAR2(32767);',
'    l_return    VARCHAR2(32767);',
'BEGIN ',
'',
'    --',
'    -- Build the PL/SQL to fill the collecitons from the ORDS_METADATA Schema',
'    -- ',
'    -- First the ORDS Modules',
'    l_plsql := ',
'q''#',
'DECLARE',
'    l_seq    number;',
'BEGIN',
'    -- Create/Truncate the collection',
'    APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(''ORDS_MODULES'');',
'    -- Loop through and fill the collection',
'    for m in (select id, name, uri_prefix, items_per_page, status, comments, pre_hook, schema_id, created_by, created_on, updated_by, updated_on, origins_allowed',
'               from USER_ORDS_MODULES)',
'    LOOP',
'        l_seq := apex_collection.add_member(',
'               p_collection_name => ''ORDS_MODULES'',',
'               p_n001 => m.id,                  ',
'               p_c001 => m.name,              ',
'               p_c002 => m.uri_prefix,           ',
'               p_n002 => m.items_per_page,',
'               p_c003 => m.status,',
'               p_c004 => m.comments, ',
'               p_c005 => m.pre_hook,',
'               p_n003 => m.schema_id,',
'               p_c006 => m.created_by,',
'               p_d001 => m.created_on,',
'               p_c007 => m.updated_by,',
'               p_d002 => m.updated_on,',
'               p_c008 => m.origins_allowed',
'               );',
'    END LOOP;',
'RETURN ''SUCCESS'';',
'EXCEPTION ',
'    WHEN OTHERS THEN ',
'        RETURN SQLERRM;',
'END;  ',
'#'';',
'',
'l_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'            p_plsql_function  => l_plsql,',
'            p_parse_as_schema => nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema)',
'        );',
'    ',
'END;',
'    '))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Servicios RESTful'
,p_step_title=>'Servicios RESTful'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_step_template=>wwv_flow_api.id(719672816683933088.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(314849921026177831.4851)
,p_plug_name=>'Servicios RESTful de APEX'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719702549794942779.4851)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'    ''icon-sc-web-service'' the_icon,',
'    ''f?p=''||:APP_ID||'':10:''||:APP_SESSION||'':::10:P10_ID,ACTIVE_NODE:''||id||'',''||id the_link,',
'    ID,',
'    NAME,',
'    URI_PREFIX,',
'    ORIGINS_ALLOWED,',
'    ITEMS_PER_PAGE,',
'    STATUS,',
'    privilege_id,',
'    lower(CREATED_BY) CREATED_BY,',
'    CREATED_ON,',
'    lower(UPDATED_BY) UPDATED_BY,',
'    UPDATED_ON',
'from WWV_FLOW_RT$MODULES',
'where SECURITY_GROUP_ID = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from WWV_FLOW_RT$MODULES',
'where SECURITY_GROUP_ID = :flow_security_group_id'))
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(314850029566177831.4851)
,p_name=>'Database Services'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('Esta consulta devuelve m\00E1s de #MAX_ROW_COUNT# filas, filtre los datos para asegurar resultados completos.')
,p_no_data_found_message=>unistr('No se ha definido ning\00FAn servicio RESTful.')
,p_allow_report_categories=>'N'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_icon_view_enabled_yn=>'Y'
,p_icon_view_use_custom=>'Y'
,p_icon_view_custom_link=>'<a href="#THE_LINK#" class="a-IRR-icon"><span class="a-Icon #THE_ICON#"></span><span class="a-IRR-iconName">#NAME#</span></a>'
,p_icon_view_columns_per_row=>5
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314850214245177834.4851)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Identificador'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314850408116177836.4851)
,p_db_column_name=>'NAME'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('Nombre del M\00F3dulo')
,p_column_link=>'#THE_LINK#'
,p_column_linktext=>'#NAME#'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314850505583177836.4851)
,p_db_column_name=>'URI_PREFIX'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Prefijo de URI'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314850626484177836.4851)
,p_db_column_name=>'ORIGINS_ALLOWED'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('Or\00EDgenes Permitidos')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314850710899177837.4851)
,p_db_column_name=>'ITEMS_PER_PAGE'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('Elementos por P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314850829662177837.4851)
,p_db_column_name=>'STATUS'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Estado'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_column_alignment=>'CENTER'
,p_rpt_named_lov=>wwv_flow_api.id(316762018242533973)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314850920562177837.4851)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Creado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314851029320177837.4851)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('Fecha de Creaci\00F3n')
,p_column_type=>'DATE'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314851116142177837.4851)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Actualizado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314851223860177837.4851)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'Actualizado'
,p_column_type=>'DATE'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315042220928203591.4851)
,p_db_column_name=>'THE_ICON'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>'Imagen'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315121931102216035.4851)
,p_db_column_name=>'THE_LINK'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>'Enlace'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1477786324163087649.4851)
,p_db_column_name=>'PRIVILEGE_ID'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>'Privilegio'
,p_column_type=>'NUMBER'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(1481196731126092675)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(411297928453027842.4851)
,p_plug_name=>unistr('Servicios RESTful de APEX - No se han cumplido los requisitos m\00EDnimos de ORDS')
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--horizontal'
,p_plug_template=>wwv_flow_api.id(410842408391417181.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- If we didn''t find ORDS or We''re runnin in the CDB ',
'IF    wwv_flow_rest_ws.get_db_type = ''CDB'' THEN ',
'    wwv_flow_lang.system_message_p(''REST_WS.NO_REST_IN_CDB'', :MIN_ORDS_VERSION);',
'ELSIF wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema) = ''0.0.0.0.0.0'' THEN ',
'   -- If the server is running EPG ',
'   IF owa_util.get_cgi_env(''SERVER_SOFTWARE'') like ''Oracle Embedded PL/SQL Gateway%'' THEN',
'        wwv_flow_lang.system_message_p(''REST_WS.PLSQL_GATEWAY'', :MIN_ORDS_VERSION);',
'   -- Otherwise we didn''t find ORDS so tell them. ',
'   else ',
'        wwv_flow_lang.system_message_p(''REST_WS.ORDS_NOT_FOUND'');',
'   END IF;',
'-- We''re running an old version ',
'ELSE ',
'    wwv_flow_lang.system_message_p(''REST_WS.OLD_ORDS_VERSION'', wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema), :MIN_ORDS_VERSION);',
'END IF;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_rest_ws.ords_min_ver_met(p_current_version => wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema)) = ''FALSE'' then ',
'    return true;',
'else ',
'   return false;',
'end if;'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(431036115543701113.4851)
,p_plug_name=>'Acerca de'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Los servicios RESTful soportan la asignaci\00F3n de la especificaci\00F3n declarativa de servicios RESTful a SQL y PL/SQL. Cada uno de los servicios RESTful llama a un m\00F3dulo e identifica un prefijo de URI. Cada m\00F3dulo puede tener una o varias plantillas.')
||'</p>',
unistr('<p><a target="_blank" href="&SYSTEM_HELP_URL./aeutl/using-RESTful-services.html">Obtener m\00E1s informaci\00F3n...</a></p>')))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(521637489065366436.4851)
,p_plug_name=>'Servicios RESTful de APEX - SOLO LECTURA'
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--horizontal'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(410842408391417181.4851)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
' wwv_flow_lang.system_message_p(''REST_WS.APEX_READ_ONLY'');',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_rest_ws.ords_min_ver_met(p_current_version => wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema)) = ''TRUE'' then ',
'    return true;',
'else ',
'   return false;',
'end if;'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(589113964806812226.4851)
,p_plug_name=>'Get Started Now'
,p_region_css_classes=>'u-Block--hero'
,p_region_sub_css_classes=>'a-MediaList--buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-MediaList--noBadge:a-MediaList--cols a-MediaList--2cols'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(604619958834115055.4851)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(719744974422969355.4851)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NOT_EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from WWV_FLOW_RT$MODULES',
'where SECURITY_GROUP_ID = :flow_security_group_id'))
,p_plug_header=>'<h1 class="u-Block-title">Comenzar Ahora</h1>'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1663039516185193367.4851)
,p_plug_name=>'Tareas'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>70
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(1493530200311490901.4851)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(6683027032641069.4851)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(317018302836567417.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(314849921026177831.4851)
,p_button_name=>'RESET_REPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Restablecer'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(303564928182336535.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(314849921026177831.4851)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:RP,3::'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF  (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(521636942136366431.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(314849921026177831.4851)
,p_button_name=>'MIGRATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Migrar a servicios RESTful de ORDS'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:20:&SESSION.:MIGRATE:&DEBUG.:RP,20::'
,p_button_condition=>'apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')'
,p_button_condition_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(366350325573479076.4851)
,p_branch_name=>'Reset Sample Data'
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'RESET_SAMPLE_DATA'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(619046728876969813.4851)
,p_branch_name=>'to ORDS when no Services'
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'FUNCTION_BODY'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_service_count number := 0;',
'    l_ords_installed number;',
'    l_schema             VARCHAR2(32767) := nvl(:P0_SCHEMA, wwv_flow_user_api.get_default_schema);',
'begin ',
'-- ',
'select count(*) ',
'  into l_ords_installed ',
'  from all_users',
' where username = ''ORDS_METADATA'';',
'--',
'if l_ords_installed > 0 THEN ',
'',
'    select count(*)',
'      into l_service_count',
'    from WWV_FLOW_RT$MODULES',
'    where SECURITY_GROUP_ID = :flow_security_group_id;',
'    --',
'    if l_service_count = 0 and wwv_flow_rest_ws.ords_min_ver_met(p_current_version => wwv_flow_rest_ws.get_ords_version(l_schema)) = ''TRUE''  ',
'    then ',
'       return true;',
'    else ',
'       return false;',
'    end if;',
'ELSE ',
'   RETURN FALSE; ',
'END IF;',
'end;'))
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(865347345088614203.4851)
,p_name=>'P1_HAS_DUP_NULL_MODULES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(314849921026177831.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_warn_on_unsaved_changes=>'I'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(865347414929614204.4851)
,p_computation_sequence=>10
,p_computation_item=>'P1_HAS_DUP_NULL_MODULES'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*)',
'from WWV_FLOW_RT$MODULES',
'where SECURITY_GROUP_ID = :flow_security_group_id',
'  and URI_PREFIX is null;'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(932665420312561004.4851)
,p_validation_name=>'Check RESTful schema'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    c_schema constant wwv_flow_companies.first_schema_provisioned%type := wwv_flow_security.find_first_schema( p_security_group_id => :flow_security_group_id );',
'begin',
'    for c1 in ( select null',
'                  from sys.dba_users',
'                 where username = c_schema )',
'    loop',
'        return null;',
'    end loop;',
'',
'    return wwv_flow_lang.system_message( p_name => ''F4850.P1.SCHEMA_DOES_NOT_EXIST'',',
'                                         p0     => wwv_flow_escape.html( c_schema ) );',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>'Error'
,p_validation_condition=>'RESET_SAMPLE_DATA'
,p_validation_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_associated_item=>wwv_flow_api.id(.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(366350028809474473.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Reset Sample Data'
,p_process_sql_clob=>'wwv_flow_listener.reset_sample_data;'
,p_process_error_message=>'Error al restablecer los datos de los servicios RESTful de ejemplo.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'RESET_SAMPLE_DATA'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
,p_process_success_message=>'Los datos de los servicios RESTful de ejemplo se han restablecido correctamente.'
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_api.create_page(
 p_id=>2.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Exportar Servicios RESTful'
,p_step_title=>'Exportar Servicios RESTful'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_step_template=>wwv_flow_api.id(719674703062933090.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(348181302763503934.4851)
,p_plug_name=>'Botones del Asistente'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752122217336695898.4851)
,p_plug_name=>'Exportar Servicios RESTful'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719731990154942810.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(825514210852506690.4851)
,p_plug_name=>'Exportar Servicio RESTful'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:800px;"'
,p_plug_template=>wwv_flow_api.id(719731261318942809.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>'<p>Exporte los metadatos de servicio RESTful a un archivo con formato de script SQL. Puede importar el script SQL en esta instancia o en otra instancia compatible de &PRODUCT_NAME..<p/>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(825549419164509031.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(348181302763503934.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(825549624897509032.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(348181302763503934.4851)
,p_button_name=>'Export'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Exportar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(825700400725522665.4851)
,p_name=>'P2_RESTFUL_SERVICE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(825514210852506690.4851)
,p_prompt=>'Servicio RESTful'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PICK MODULE'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''All Services'' d, 999 r from sys.dual',
'union all',
'select name d, id r from WWV_FLOW_RT$MODULES ',
'where security_group_id = :flow_security_group_id',
''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleccionar Servicio -'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Identifique los servicios RESTful que desea exportar. Para exportar todos los servicios RESTful al espacio de trabajo, seleccione <b>Todos los Servicios</b>.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(835737417692928010.4851)
,p_name=>'P2_EXPORT_FILE_TYPE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(825514210852506690.4851)
,p_item_default=>'SQL'
,p_source=>'SQL'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>'Este atributo determina el formato de archivo que se va a exportar. Los archivos XML pueden importarse a otro espacio de trabajo de Oracle &PRODUCT_NAME..'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1670990205226936919.4851)
,p_name=>'P2_FILE_CHARSET'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(825514210852506690.4851)
,p_item_default=>'nvl(lower(trim(sys.owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))),''utf-8'')'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Juego de Caracteres de Archivo:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'I18N_IANA_CHARSET'
,p_lov=>'.'||wwv_flow_api.id(1671084505895948418.4851)||'.'
,p_cattributes_element=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('El archivo de exportaci\00F3n se codificar\00E1 con el juego de caracteres especificado.')
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1671361912030005092.4851)
,p_name=>'P2_SERVICE_COUNT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(825514210852506690.4851)
,p_prompt=>unistr('Recuento de servicios RESTful disponibles para su exportaci\00F3n:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*) c ',
'from WWV_FLOW_RT$MODULES ',
'where security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica el n\00FAmero de servicios RESTful definidos en el espacio de trabajo actual.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1671262700686982930.4851)
,p_validation_name=>'RESTful Service Not Null'
,p_validation_sequence=>10
,p_validation=>'P2_RESTFUL_SERVICE'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Debe seleccionar un servicio RESTful para exportarlo.'
,p_when_button_pressed=>wwv_flow_api.id(825549624897509032.4851)
,p_associated_item=>wwv_flow_api.id(825700400725522665.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(933767018114277671.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Export File'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'    -- Export All RESTful Services in Workspace',
'    if :P2_RESTFUL_SERVICE = 999 then',
'',
'        sys.htp.init;',
'        wwv_flow.g_page_text_generated := true;',
'        wwv_flow_gen_api2.g_mime_shown := true;',
'        ',
'        wwv_flow_utilities.print_download_header(',
'            p_mime_type =>     ''application/x-sql'',',
'            p_file_name =>     replace(lower(replace(wwv_flow_lang.system_message(''DB_SERVICES_RESTFUL_SERVICES''), ''.'', ''_'')), '' '', ''_'')||''_''||sysdate||''.sql'',',
'            p_is_attachment => true',
'        );               ',
'                ',
'        sys.owa_util.http_header_close;',
'',
'        wwv_flow_gen_api2.export_restful_services (',
'            p_commit    => ''YES'',',
'            p_format    => :P2_FORMAT );',
'',
'    else',
'',
'        -- Export Selected RESTful Service',
'        for c1 in (',
'            select name',
'              from wwv_flow_rt$modules',
'             where id = to_number(:P2_RESTFUL_SERVICE) )',
'        loop',
'            sys.htp.init;',
'            wwv_flow.g_page_text_generated := true;',
'            wwv_flow_gen_api2.g_mime_shown := true;',
'            ',
'            ',
'            wwv_flow_utilities.print_download_header(',
'                p_mime_type =>     ''application/x-sql'',',
'                p_file_name =>     replace(replace(lower(c1.name), ''.'', ''_''), '' '', ''_'')||''.sql'',',
'                p_is_attachment => true',
'            );               ',
'',
'            sys.owa_util.http_header_close;',
'',
'            wwv_flow_gen_api2.export_restful_service (',
'                p_module_id => :P2_RESTFUL_SERVICE,',
'                p_commit    => ''YES'',',
'                p_format    => :P2_FORMAT );',
'            exit;',
'        end loop;',
'    end if;',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(825549624897509032.4851)
,p_process_success_message=>'Los servicios RESTful se han exportado correctamente.'
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_api.create_page(
 p_id=>3.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>unistr('Crear M\00F3dulo de Servicios RESTful')
,p_step_title=>unistr('Crear M\00F3dulo de Servicios RESTful')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_step_template=>wwv_flow_api.id(719670183563933079.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(304327127776431653.4851)
,p_plug_name=>unistr('M\00F3dulo de Servicios RESTful')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_footer=>'<br/>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1472423006082058889.4851)
,p_plug_name=>'Plantilla de Recurso'
,p_parent_plug_id=>wwv_flow_api.id(304327127776431653.4851)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="border-top: 1px solid #cccccc;padding:10px 0 10px 0;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1472518827254093392.4851)
,p_plug_name=>'Manejador de Recursos'
,p_parent_plug_id=>wwv_flow_api.id(304327127776431653.4851)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="border-top: 1px solid #cccccc;padding:10px 0 10px 0;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(417180817350539207.4851)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_04'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(431576920438730918.4851)
,p_plug_name=>'Acerca de'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Los servicios RESTful permiten la asignaci\00F3n de la especificaci\00F3n declarativa de servicios RESTful a la base de datos. Se crean mediante la configuraci\00F3n de un juego de URI (Identificadores de Recursos Uniformes) con una consulta SQL o un bloque P')
||unistr('L/SQL an\00F3nimo. El juego de URI se identifica mediante una plantilla de URI.</p><p>Un m\00F3dulo de servicio RESTful es una agrupaci\00F3n de plantillas comunes, denominadas plantillas de recurso, con un prefijo de URI com\00FAn. Este prefijo se antepone a todas ')
||unistr('las plantillas. Una plantilla de URI es una sintaxis sencilla que describe los URI.</p><p>El manejador de recursos es una consulta o un bloque PL/SQL an\00F3nimo responsable del manejo de un determinado m\00E9todo HTTP. Se pueden definir varios manejadores p')
||unistr('ara una plantilla de recurso, sin embargo, s\00F3lo se permite un manejador por m\00E9todo HTTP.</p>'),
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(304327513110431653.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(417180817350539207.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(304327822910431653.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(417180817350539207.4851)
,p_button_name=>'create'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Crear M\00F3dulo')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(304328505737431654.4851)
,p_branch_action=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::P10_ID:&P3_MODULE.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(304327822910431653.4851)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(327533908504029252.4851)
,p_name=>'P3_MODULE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(304327127776431653.4851)
,p_prompt=>'Nombre'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>90
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Introduzca el nombre del m\00F3dulo de servicio RESTful. Los m\00F3dulos de servicio RESTful se utilizan para agrupar las plantillas de URI (Identificador de Recursos Uniforme) con un mismo prefijo.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(328242425267119175.4851)
,p_name=>'P3_STATUS'
,p_item_sequence=>35
,p_item_plug_id=>wwv_flow_api.id(304327127776431653.4851)
,p_prompt=>'Estado'
,p_source=>'PUBLISHED'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PUBLISHED NOT PUBLISHED'
,p_lov=>'.'||wwv_flow_api.id(316762018242533973.4851)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Los servicios p\00FAblicos se pueden utilizar, los no p\00FAblicos no.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(328279824706128489.4851)
,p_name=>'P3_MODULE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(304327127776431653.4851)
,p_item_default=>'0'
,p_prompt=>unistr('M\00F3dulo')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name, id ',
'from wwv_flow_rt$modules ',
'where security_group_id = :flow_security_group_id ',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Nuevo M\00F3dulo -')
,p_lov_null_value=>'0'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica el nombre del m\00F3dulo de servicio RESTful.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(829958421128351764.4851)
,p_name=>'P3_URI_PREFIX'
,p_is_required=>true
,p_item_sequence=>25
,p_item_plug_id=>wwv_flow_api.id(304327127776431653.4851)
,p_prompt=>'Prefijo de URI'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>90
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Esta es la base del identificador de recursos uniforme (URI) que se utilizar\00E1.  ')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1441198408541223455.4851)
,p_name=>'P3_ORIGINS_ALLOWED'
,p_item_sequence=>26
,p_item_plug_id=>wwv_flow_api.id(304327127776431653.4851)
,p_prompt=>unistr('Or\00EDgenes Permitidos')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>90
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Lista separada por comas de or\00EDgenes que tienen permitido el acceso a la plantilla de recurso como, por ejemplo:</p><p>'),
'',
'http://example1.org, https://*.example2.com',
'</p>'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1472304010060022224.4851)
,p_name=>'P3_URI_TEMPLATE'
,p_item_sequence=>45
,p_item_plug_id=>wwv_flow_api.id(1472423006082058889.4851)
,p_prompt=>'Plantilla de URI'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>81
,p_cMaxlength=>600
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Introduzca la plantilla de URI para identificar los URI (Identificadores de Recursos Uniformes). Una plantilla de URI es una sintaxis sencilla que describe los URI (por ejemplo, <b>example/get/{id}</b>).<p> La plantilla de URI puede contener varios p'
||unistr('ar\00E1metros o ninguno (por ejemplo, <b>{id}</b>) que pueden estar enlazados a par\00E1metros de una consulta SQL o un bloque PL/SQL an\00F3nimo. Se aplican las siguientes reglas gramaticales:</p>'),
'<ul>',
unistr('<li>Las plantillas de URI no deben empezar por un car\00E1cter de barra inclinada (/).</li>'),
unistr('<li>Las plantillas de URI pueden contender cualquier car\00E1cter Unicode.</li>'),
unistr('<li>Los par\00E1metros se declaran mediante corchetes angulares ({}).</li>'),
unistr('<li>Los nombres de par\00E1metros deben empezar con un car\00E1cter alfanum\00E9rico seguido de ninguno o varios caracteres alfanum\00E9ricos y los caracteres: subrayado(_) o gui\00F3n (-).</li>'),
unistr('<li>No hay soporte para los par\00E1metros de opci\00F3n.</li>'),
'</ul>'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1472323525644026730.4851)
,p_name=>'P3_PRIORITY'
,p_item_sequence=>55
,p_item_plug_id=>wwv_flow_api.id(1472423006082058889.4851)
,p_item_default=>'0'
,p_prompt=>'Prioridad'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ZERO THROUGH 9'
,p_lov=>'.'||wwv_flow_api.id(792033515275240381.4851)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica el orden de evaluaci\00F3n de las plantillas. Los n\00FAmeros m\00E1s altos se eval\00FAan primero. Por ejemplo, si coinciden dos plantillas, se seleccionar\00E1 la que tiene prioridad 9 sobre la que tiene prioridad 0. ')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1472343003265029730.4851)
,p_name=>'P3_ETAG_TYPE'
,p_item_sequence=>65
,p_item_plug_id=>wwv_flow_api.id(1472423006082058889.4851)
,p_item_default=>'HASH'
,p_prompt=>'Etiqueta de Entidad'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ETAG_TYPES'
,p_lov=>'.'||wwv_flow_api.id(792100407834275994.4851)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Identifica el tipo de etiqueta de entidad que utilizar\00E1 la plantilla de recurso. Una etiqueta de entidad es una cabecera HTTP que act\00FAa como identificador de versi\00F3n de un recurso. Utilice cabeceras de etiqueta de entidad para evitar la recuperaci\00F3n ')
||'de recursos recuperados previamente y realizar un bloqueo optimista al actualizar los recursos. Las opciones incluyen:<p/>',
'<ul>',
unistr('<li><b>HASH Seguro</b>: al contenido de la representaci\00F3n de recursos devuelta se le aplicar\00E1 un valor hash mediante una funci\00F3n de resumen segura para proporcionar una huella \00FAnica para una determinada versi\00F3n del recurso.</li>'),
unistr('<li><b>Consulta</b>: define una consulta que identifique de forma \00FAnica una versi\00F3n de recurso. Una consulta definida manualmente a menudo genera una etiqueta de entidad de forma m\00E1s eficaz que con la aplicaci\00F3n de un valor hash a toda la representac')
||unistr('i\00F3n de recursos.</li>'),
'<li><b>Ninguna</b>: no genera ninguna etiqueta de entidad.</li>',
'</ul>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1472362512615032426.4851)
,p_name=>'P3_ETAG_QUERY'
,p_item_sequence=>75
,p_item_plug_id=>wwv_flow_api.id(1472423006082058889.4851)
,p_prompt=>'Consulta de Etiqueta de Entidad'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>58
,p_cMaxlength=>4000
,p_cHeight=>8
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Sentencia SQL SELECT que devuelve una fila que se utilizar\00E1 para generar una etiqueta de entidad personalizada. El resultado de la sentencia SELET debe identificar de forma \00FAnica cada versi\00F3n del recurso. Por ejemplo.<p/>'),
'',
'<i>select updated_on, updated_by from my_table where id = :id</i>'))
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1482015622711307901.4851)
,p_name=>'P3_PRIVILEGE'
,p_item_sequence=>85
,p_item_plug_id=>wwv_flow_api.id(304327127776431653.4851)
,p_prompt=>'Privilegio Necesario'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PRIVILEGES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select label d, id r',
'  from wwv_flow_rt$privileges',
' where security_group_id = :flow_security_group_id',
' order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Asignar Privilegio - '
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Especifica el privilegio necesario para permitir el acceso a este m\00F3dulo de servicio RESTful.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1483954013566920227.4851)
,p_name=>'P3_METHOD'
,p_item_sequence=>95
,p_item_plug_id=>wwv_flow_api.id(1472518827254093392.4851)
,p_prompt=>unistr('M\00E9todo')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'HANDLER_METHODS'
,p_lov=>'.'||wwv_flow_api.id(793208615430277767.4851)||'.'
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- M\00E9todo de Selecci\00F3n -')
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Identifica el m\00E9todo HTTP que se utilizar\00E1 para el manejador de recursos. Las cuatro opciones son:<p/>'),
'<ul>',
unistr('<li><b>GET</b>: recupera una representaci\00F3n de un recurso</li>'),
'<li><b>DELETE</b>: suprime un recurso existente</li>',
unistr('<li><b>POST</b>: crea un nuevo recurso o agrega un recurso a una recopilaci\00F3n</li>'),
'<li><b>PUT</b>: actualiza un recurso existente</li>',
'</ul>',
unistr('<p>S\00F3lo se permite un manejador por m\00E9todo HTTP.</p>')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1483973520146922181.4851)
,p_name=>'P3_SOURCE_TYPE'
,p_item_sequence=>105
,p_item_plug_id=>wwv_flow_api.id(1472518827254093392.4851)
,p_prompt=>'Tipo de Origen'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'P3_HANDLER_SOURCE_TYPES'
,p_lov=>'.'||wwv_flow_api.id(1484087224479961236.4851)||'.'
,p_lov_cascade_parent_items=>'P3_METHOD'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>32
,p_cMaxlength=>30
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Define la implantaci\00F3n de origen para el m\00E9todo HTTP seleccionado. Las opciones incluyen:<p/>'),
'<ul>',
unistr('<li><b>Consulta</b>: ejecuta una consulta SQL y transforma el juego de resultados en una representaci\00F3n JSON (Notaci\00F3n de objetos JavaScript) o CSV, seg\00FAn el formato seleccionado. Tenga en cuenta que esta opci\00F3n solo est\00E1 disponible si se ha seleccio')
||unistr('nado el m\00E9todo HTTP GET.</li>'),
unistr('<li><b>Consultar una fila</b>: ejecuta una consulta SQL que devuelve una fila de datos en una representaci\00F3n JSON. Tenga en cuenta que esta opci\00F3n solo est\00E1 disponible si se ha seleccionado el m\00E9todo HTTP GET.</li>'),
unistr('<li><b>PL/SQL</b>: ejecuta un bloque PL/SQL an\00F3nimo y transforma los par\00E1metros OUT o IN/OUT en una representaci\00F3n JSON. Tenga en cuenta que \00E9sta es la \00FAnica opci\00F3n disponible si el m\00E9todo HTTP seleccionado es uno de los siguientes: DELETE, PUT o POS')
||'T.</li>',
unistr('<li><b>Fuente</b>: ejecuta una consulta SQL y transforma los resultados en una representaci\00F3n de fuente JSON. Cada elemento de la fuente contiene un resumen de un recurso y un hiperenlace a la representaci\00F3n completa del recurso. La primera columna d')
||unistr('e cada fila del juego de resultados debe ser un identificador \00FAnico para la fila y se debe utilizar para crear un hiperenlace con el siguiente formato: path/to/feed/{id}, en el que el valor de la primera columna se utilice como valor de {id}. Se supo')
||unistr('ne que las dem\00E1s columnas de la fila resumen el recurso y se incluyen en la fuente. Tambi\00E9n se debe definir una plantilla de recurso independiente para la representaci\00F3n completa del recurso.</li>'),
unistr('<li><b>Recurso de medios</b>: ejecuta una consulta SQL que cumpla un formato concreto y que devuelva el juego de resultados en una representaci\00F3n binaria con una cabecera HTTP Content-Type que identifique el tipo de medio f\00EDsico de Internet de la rep')
||unistr('resentaci\00F3n. El formato de la consulta SQL debe ser:<p><i>SELECT ''content_type'', column FROM . . .</i><br/><br/>'),
unistr('donde <i>''content_type''</i> es una cadena transferida al explorador para utilizarla en la identificaci\00F3n de los datos entrantes, por ejemplo <i>''image/jpeg''</i>, y <i>column</i> es el nombre de la columna que contiene el origen de los datos que se de')
||unistr('vuelven. El tipo Origen de recursos de medios normalmente se utiliza para los objetos de medios, como im\00E1genes, donde los datos los manejar\00E1 directamente el destinatario que realiza la llamada.</p>'),
'',
'</li>',
'',
'</ul>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1483993026726924065.4851)
,p_name=>'P3_FORMAT'
,p_is_required=>true
,p_item_sequence=>115
,p_item_plug_id=>wwv_flow_api.id(1472518827254093392.4851)
,p_prompt=>'Formato'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'HANDLER_QUERY_FORMAT'
,p_lov=>'.'||wwv_flow_api.id(793264406688294176.4851)||'.'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Define c\00F3mo se devuelven los resultados.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1484042122832941854.4851)
,p_name=>'P3_SOURCE'
,p_item_sequence=>125
,p_item_plug_id=>wwv_flow_api.id(1472518827254093392.4851)
,p_prompt=>'Origen'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>59
,p_cMaxlength=>32767
,p_cHeight=>8
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica la consulta SQL o el bloque PL/SQL responsable del manejo del m\00E9todo HTTP seleccionado. Se pueden definir varios manejadores de recursos para una plantilla de recurso. Para definir manejadores adicionales, edite el m\00F3dulo de servicio RESTf')
||unistr('ul reci\00E9n creado.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1487576707587042344.4851)
,p_name=>'P3_TEMPLATE_LABEL'
,p_item_sequence=>43
,p_item_plug_id=>wwv_flow_api.id(1472423006082058889.4851)
,p_prompt=>'Agregar Plantilla de Recurso'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap" class="fielddatabold" '
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1487765829236086368.4851)
,p_name=>'P3_HANDLER_LABEL'
,p_item_sequence=>91
,p_item_plug_id=>wwv_flow_api.id(1472518827254093392.4851)
,p_prompt=>'Agregar Manejador de Recursos'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap" class="fielddatabold" '
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1765477505857393079.4851)
,p_name=>'P3_ITEMS_PER_PAGE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(304327127776431653.4851)
,p_item_default=>'25'
,p_prompt=>unistr('Tama\00F1o de Paginaci\00F3n')
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>5
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica el tama\00F1o de la ventana de paginaci\00F3n. En las consultas de la base de datos, \00E9ste es el n\00FAmero de filas que se va a devolver.')
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(328305831285130369.4851)
,p_computation_sequence=>10
,p_computation_item=>'P3_MODULE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'0'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1484918031059313249.4851)
,p_validation_name=>'Handler Source Must be Specified - When Method Selected'
,p_validation_sequence=>10
,p_validation=>'P3_SOURCE'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('Se debe especificar #LABEL# para el m\00E9todo de manejador de recursos seleccionado &P3_METHOD.')
,p_validation_condition=>'P3_METHOD'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(304327822910431653.4851)
,p_associated_item=>wwv_flow_api.id(1484042122832941854.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1485000520585329185.4851)
,p_validation_name=>'Module Name Must be Specified'
,p_validation_sequence=>20
,p_validation=>'P3_MODULE_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('#LABEL# debe tener alg\00FAn valor.')
,p_when_button_pressed=>wwv_flow_api.id(304327822910431653.4851)
,p_associated_item=>wwv_flow_api.id(327533908504029252.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1485181103448362038.4851)
,p_validation_name=>'UIR Template Must Be Specified When Method Selected'
,p_validation_sequence=>40
,p_validation=>'P3_URI_TEMPLATE'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('#LABEL# debe tener alg\00FAn valor.')
,p_validation_condition=>'P3_METHOD'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(304327822910431653.4851)
,p_associated_item=>wwv_flow_api.id(1472304010060022224.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1500815508610586058.4851)
,p_validation_name=>'Module Name Must be Unique per Workspace'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  for c1 in (select 1 from wwv_flow_rt$modules',
'             where name = :P3_MODULE_NAME',
'             and security_group_id = :flow_security_group_id)',
'  loop',
'      return false;',
'  end loop;',
'  return true;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('El nombre de m\00F3dulo, &P3_MODULE_NAME., ya lo est\00E1 utilizando un m\00F3dulo existente. El nombre de m\00F3dulo debe ser \00FAnico.')
,p_validation_condition=>'P3_MODULE_NAME'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(304327822910431653.4851)
,p_associated_item=>wwv_flow_api.id(327533908504029252.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1765596609676469803.4851)
,p_validation_name=>'Pagination Must be Specified'
,p_validation_sequence=>60
,p_validation=>'P3_ITEMS_PER_PAGE'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('#LABEL# debe tener alg\00FAn valor.')
,p_associated_item=>wwv_flow_api.id(1765477505857393079.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(2544541212596667024.4851)
,p_validation_name=>'Validate URI Template'
,p_validation_sequence=>80
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_listener.is_valid_template(p_template=> :P3_URI_TEMPLATE) then',
'  return true;',
'else',
'  return false;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Las plantillas de URI no pueden contener nombres de par\00E1metro con una longitud superior a los 100 caracteres y los par\00E1metros deben cumplir con el siguiente patr\00F3n:'),
'<br/><br/>',
unistr('Una llave ''{'' seguida de un car\00E1cter alfab\00E9tico, a continuaci\00F3n, hasta 99 caracteres alfanum\00E9ricos o los caracteres especiales _, - o . y terminado con una llave de cierre ''}''. ')))
,p_validation_condition=>'P3_URI_TEMPLATE'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(304327822910431653.4851)
,p_associated_item=>wwv_flow_api.id(1472304010060022224.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(328339719988136574.4851)
,p_name=>'show hide new module'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P3_MODULE'
,p_condition_element=>'P3_MODULE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'0'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(328340029831136575.4851)
,p_event_id=>wwv_flow_api.id(328339719988136574.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3_MODULE_NAME'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(328340221159136575.4851)
,p_event_id=>wwv_flow_api.id(328339719988136574.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3_MODULE_NAME'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(328421310685162257.4851)
,p_name=>'show hide format'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P3_SOURCE_TYPE'
,p_condition_element=>'P3_SOURCE_TYPE'
,p_triggering_condition_type=>'IN_LIST'
,p_triggering_expression=>'QUERY'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1484401026482056468.4851)
,p_event_id=>wwv_flow_api.id(328421310685162257.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3_FORMAT'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1484409032716058223.4851)
,p_event_id=>wwv_flow_api.id(328421310685162257.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3_FORMAT'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1472465509330069367.4851)
,p_name=>'Etag Query Display'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P3_ETAG_TYPE'
,p_condition_element=>'P3_ETAG_TYPE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'QUERY'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1472465820168069367.4851)
,p_event_id=>wwv_flow_api.id(1472465509330069367.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3_ETAG_QUERY'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1472466011487069368.4851)
,p_event_id=>wwv_flow_api.id(1472465509330069367.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3_ETAG_QUERY'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1484537332762086656.4851)
,p_name=>'Handler Source Type Display'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P3_METHOD'
,p_condition_element=>'P3_METHOD'
,p_triggering_condition_type=>'NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1484537621000086657.4851)
,p_event_id=>wwv_flow_api.id(1484537332762086656.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3_SOURCE_TYPE,P3_FORMAT,P3_SOURCE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1484537805073086657.4851)
,p_event_id=>wwv_flow_api.id(1484537332762086656.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P3_SOURCE_TYPE,P3_FORMAT,P3_SOURCE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(327787501279055539.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create RESTful Service'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_module_id    number;',
'   l_template_id  number;',
'begin',
'',
'',
'if :P3_MODULE = ''0'' then',
'   insert into wwv_flow_rt$modules(',
'        name, ',
'        uri_prefix, ',
'        origins_allowed,',
'        items_per_page, ',
'        status,',
'        privilege_id',
'    ) ',
'    values (',
'        :P3_MODULE_NAME, ',
'        :P3_URI_PREFIX, ',
'        null,',
'        :P3_ITEMS_PER_PAGE, ',
'        :P3_STATUS,',
'        :P3_PRIVILEGE)',
'    returning id into l_module_id;',
'    :P3_MODULE   := l_module_id;',
'    :ACTIVE_NODE := l_module_id;',
'',
'    if :P3_URI_TEMPLATE is not null then',
'        insert into wwv_flow_rt$templates (',
'             module_id,',
'             uri_template,',
'             priority,',
'             etag_type,',
'             etag_query',
'        ) ',
'        values (',
'            l_module_id,',
'            :P3_URI_TEMPLATE,',
'            :P3_PRIORITY,',
'            :P3_ETAG_TYPE,',
'            :P3_ETAG_QUERY)',
'        returning id into l_template_id;',
' ',
'    end if;',
' ',
'    if :P3_METHOD is not null then',
'        insert into wwv_flow_rt$handlers (',
'            template_id,',
'            method,',
'            format,',
'            source_type,',
'            source,',
'            require_https',
'        )',
'        values (',
'            l_template_id,',
'            :P3_METHOD,',
'            :P3_FORMAT,',
'            :P3_SOURCE_TYPE,',
'            :P3_SOURCE,',
'            ''YES'');',
'    end if;',
'',
'    commit;',
'',
'    -- Grant Connection to Oracle REST Data Services',
'    wwv_flow_security.grant_restful_connect;',
'else',
'   l_module_id := :P3_MODULE;',
'end if;',
'',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(304327822910431653.4851)
,p_process_success_message=>'El servicio RESTful se ha creado correctamente.'
);
end;
/
prompt --application/pages/page_00004
begin
wwv_flow_api.create_page(
 p_id=>4.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Privilegios del Servicio RESTful'
,p_step_title=>'Privilegios del Servicio RESTful'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_step_template=>wwv_flow_api.id(719672816683933088.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1481362602354168216.4851)
,p_plug_name=>'Privilegios del Servicio RESTful'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719702549794942779.4851)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''icon-util-webservice'' the_icon,',
'    ''f?p=''||:APP_ID||'':6:''||:APP_SESSION||'':::6:P6_ID:''||id the_link,',
'a.id, ',
'a.name,',
'a.label,',
'(select count(id) from wwv_flow_rt$modules where privilege_id = a.id) modules,',
'wwv_flow_escape.html(substr(a.description,1,100)) description,',
'a.comments,',
'a.security_group_id,',
'a.created_by,',
'a.created_on,',
'a.updated_by,',
'a.updated_on,',
'a.row_version_number',
'from wwv_flow_rt$privileges a',
'where security_group_id = :flow_security_group_id',
'  ',
''))
,p_plug_source_type=>'NATIVE_IR'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1481362824788168217.4851)
,p_name=>'RESTful Service Privileges'
,p_max_row_count=>'100000'
,p_max_row_count_message=>unistr('Esta consulta devuelve m\00E1s de #MAX_ROW_COUNT# filas, filtre los datos para asegurar resultados completos.')
,p_no_data_found_message=>unistr('No se ha encontrado ning\00FAn dato.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_icon_view_enabled_yn=>'Y'
,p_icon_view_use_custom=>'Y'
,p_icon_view_custom_link=>'<a href="#THE_LINK#" class="a-IRR-icon"><span class="a-Icon #THE_ICON#"></span><span class="a-IRR-iconName">#NAME#</span></a>'
,p_icon_view_columns_per_row=>5
,p_owner=>'HILARY'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481362909554168221.4851)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481363006248168222.4851)
,p_db_column_name=>'NAME'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Nombre'
,p_column_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::P6_ID:#ID#'
,p_column_linktext=>'#NAME#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481363113610168226.4851)
,p_db_column_name=>'LABEL'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Etiqueta'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481363217930168226.4851)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('Descripci\00F3n')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481363324751168226.4851)
,p_db_column_name=>'COMMENTS'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Comentarios'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481363418674168226.4851)
,p_db_column_name=>'SECURITY_GROUP_ID'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Identificador de Grupo de Seguridad'
,p_column_type=>'NUMBER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481363522707168226.4851)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Creado por'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481363623212168226.4851)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('Fecha de Creaci\00F3n')
,p_column_type=>'DATE'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481363702848168227.4851)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Actualizado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481363816718168227.4851)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Actualizado'
,p_column_type=>'DATE'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1481363924702168227.4851)
,p_db_column_name=>'ROW_VERSION_NUMBER'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>unistr('N\00FAmero de Versi\00F3n de Fila')
,p_column_type=>'NUMBER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1482212409430370283.4851)
,p_db_column_name=>'THE_ICON'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>'Icono'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1482212525894370286.4851)
,p_db_column_name=>'THE_LINK'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>'Enlace'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1499159212842792392.4851)
,p_db_column_name=>'MODULES'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>unistr('M\00F3dulos Asociados')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1493364107883464751.4851)
,p_plug_name=>'Acerca de'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Los privilegios del servicio RESTful permiten la creaci\00F3n de privilegios basados usuarios y grupos, que se utilizar\00E1n en la asignaci\00F3n de restricciones de seguridad en los servicios RESTful.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1493583821090496910.4851)
,p_plug_name=>'Tareas'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(1493530200311490901.4851)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(6683027032641069.4851)
,p_plug_display_condition_type=>'NEVER'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_rt$privileges a',
'where security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1481618806379199064.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1481362602354168216.4851)
,p_button_name=>'RESET_REPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Restablecer'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:RP,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1481364107551168228.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1481362602354168216.4851)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:6::'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_icon_css_classes=>'icon-right-chevron'
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Importar Servicios RESTful'
,p_step_title=>'Importar Servicios RESTful'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_step_template=>wwv_flow_api.id(719674703062933090.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(348182004972513994.4851)
,p_plug_name=>'Botones del Asistente'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>21
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752122312856695898.4851)
,p_plug_name=>'Importar Servicios RESTful'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719731990154942810.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(835936732499951225.4851)
,p_plug_name=>'Importar Servicio RESTful'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:800px;"'
,p_plug_template=>wwv_flow_api.id(719731261318942809.4851)
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<br/>Seleccione el archivo que desea importar.<p/>Si el archivo importado contiene un nombre de servicio RESTful que ya est\00E1 en uso en este espacio de trabajo, se suprimir\00E1 el servicio RESTful existente y se sustituir\00E1 por la nueva definici\00F3n del arc')
||'hivo.'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(836073906788962700.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(348182004972513994.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(836074103020962702.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(348182004972513994.4851)
,p_button_name=>'import'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Importar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1676495700514539251.4851)
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(836000914622955500.4851)
,p_name=>'P5_SQL_SCRIPT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(835936732499951225.4851)
,p_prompt=>'Archivo a Importar'
,p_display_as=>'NATIVE_FILE'
,p_cSize=>40
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Seleccione el archivo que desea importar.'
,p_attribute_01=>'WWV_FLOW_FILES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1671777721268149657.4851)
,p_name=>'P5_FILE_CHARSET'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(835936732499951225.4851)
,p_item_default=>'nvl(lower(trim(sys.owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))),''utf-8'')'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Juego de Caracteres de Archivo:'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'I18N_IANA_CHARSET'
,p_lov=>'.'||wwv_flow_api.id(1671084505895948418.4851)||'.'
,p_cHeight=>1
,p_cattributes_element=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('El archivo de exportaci\00F3n se codificar\00E1 con el juego de caracteres especificado.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1672375317393318867.4851)
,p_name=>'P5_FILE_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(835936732499951225.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1671872825901160455.4851)
,p_validation_name=>'Import file Not Null'
,p_validation_sequence=>10
,p_validation=>'P5_SQL_SCRIPT'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('#LABEL# debe tener alg\00FAn valor.')
,p_when_button_pressed=>wwv_flow_api.id(836074103020962702.4851)
,p_associated_item=>wwv_flow_api.id(836000914622955500.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1672300517262309428.4851)
,p_validation_name=>'Not a valid export file'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_imp_parser.is_restful_export(:P4450_FILE_ID) then',
'   return false;',
'else',
'   return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Debe seleccionar un archivo de exportaci\00F3n de servicios RESTful v\00E1lido.')
,p_validation_condition_type=>'NEVER'
,p_when_button_pressed=>wwv_flow_api.id(836074103020962702.4851)
,p_associated_item=>wwv_flow_api.id(836000914622955500.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1688815914323158180.4851)
,p_validation_name=>'P5_SQL_SCRIPT Not a Valid RESTful Service Export File'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_clob     clob;',
'    l_string   varchar2(32767);',
'    l_delim    varchar2(10) := chr(10)||''/'';',
'    l_last     number := 1;',
'    n          number := 0;',
'begin',
'',
'    for c1 in (select blob_content, file_charset',
'                 from wwv_flow_file_objects$',
'                where id = :P5_FILE_ID) loop',
'',
'        l_clob := wwv_flow_utilities.blob_to_clob(',
'                    p_blob    => c1.blob_content,',
'                    p_charset => :P5_FILE_CHARSET);',
'    end loop;',
'',
'    if instr(l_clob, ''wwv_flow_api.remove_restful_service'') > 0 then',
'        sys.dbms_lob.freetemporary( lob_loc => l_clob );',
'        return true;',
'    else',
'        sys.dbms_lob.freetemporary( lob_loc => l_clob );',
'        return false;',
'    end if;',
'exception when others then',
'    sys.dbms_lob.freetemporary( lob_loc => l_clob );',
'    return false;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('#LABEL# no es un archivo de exportaci\00F3n de servicios RESTful v\00E1lido.')
,p_validation_condition_type=>'NEVER'
,p_when_button_pressed=>wwv_flow_api.id(836074103020962702.4851)
,p_associated_item=>wwv_flow_api.id(836000914622955500.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(914174503223342309.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'upload file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_title     varchar2(4000) := null;',
'  l_file_type varchar2(4000) := null;',
'  l_flow_id   number := 0;',
'  l_file_id   number := 0;',
'  l_start     number := 0;',
'  l_owner     varchar2(100);',
'  l_blob blob;',
'  l_clob clob;',
'',
'begin',
'  l_start := instr(:P5_SQL_SCRIPT,''/'',1)+1;',
'  l_title := substr(:P5_SQL_SCRIPT,l_start);',
'  l_file_type := ''RESTFUL_EXPORT''; ',
'  ',
'  --',
'  -- save file attributes',
'  --',
'  update wwv_flow_file_objects$ ',
'  set    title = l_title, ',
'         description = l_title||'' upload'',',
'         security_group_id = :flow_security_group_id,      ',
'         mime_type = ''application/text'',',
'         created_by = :flow_user,',
'         file_charset = :P5_FILE_CHARSET',
'  where name = :P5_SQL_SCRIPT;',
'  ',
'  for c1 in (select id,',
'                    blob_content',
'             from wwv_flow_file_objects$',
'             where name = :P5_SQL_SCRIPT',
'             and security_group_id = :flow_security_group_id)',
'  loop',
'     l_file_id := c1.id;',
'     l_blob := c1.blob_content;',
'  end loop;   ',
'  ',
'  --',
'  l_clob := wwv_flow_utilities.blob_to_clob (',
'                          p_blob    => l_blob,',
'                          p_charset => :P5_FILE_CHARSET );  ',
'    ',
'  -- update flow id in wwv_flow_file_objects$',
'  update wwv_flow_file_objects$',
'  set file_type = l_file_type',
'  where name = :P5_SQL_SCRIPT;',
'',
'  l_owner := wwv_flow_security.find_first_schema(p_security_group_id => wwv_flow_security.g_security_group_id);',
'  ',
'  if instr(l_clob, ''ORDS.DEFINE_'',1,1) > 0 then ',
'',
'     raise_application_error( -20851, wwv_flow_lang.system_message(''REST_WS.WRONG_SCRIPT_TYPE_APEX''));',
'',
'  else ',
'        wwv_flow_imp_parser.parse (',
'            p_file_id          => l_file_id,',
'            p_parse_as_schema  => l_owner,',
'            p_install_as_flow  => null,',
'            p_original_flow_id => null,',
'            p_adjust_offset    => true );',
'',
'  end if;',
'',
'  -- Delete uploaded file from wwv_flow_file_objects$',
'  delete from wwv_flow_file_objects$',
'   where file_type = l_file_type',
'     and name = :P5_SQL_SCRIPT;',
'',
'end;'))
,p_process_error_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Error al importar servicios RESTful.<br/>',
'#SQLERRM_TEXT#'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'Los servicios RESTful se han importado correctamente.'
);
end;
/
prompt --application/pages/page_00006
begin
wwv_flow_api.create_page(
 p_id=>6.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Detalles de Privilegios del Servicio RESTful'
,p_step_title=>'Detalles de Privilegios del Servicio RESTful'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(719670183563933079.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(348186514931535843.4851)
,p_plug_name=>'Barra Superior'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_04'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1481359110874168192.4851)
,p_plug_name=>'Detalles de Privilegios del Servicio RESTful'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_read_only_when_type=>'PLSQL_EXPRESSION'
,p_plug_read_only_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1502577210987258576.4851)
,p_plug_name=>'Acerca de'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Los privilegios del servicio RESTful permiten la creaci\00F3n de privilegios basados en usuarios y grupos, que se utilizar\00E1n en la asignaci\00F3n de restricciones de seguridad en los servicios RESTful.</p>'),
unistr('<p>Para asignar un privilegio a un grupo de usuarios existente, seleccione los grupos a trav\00E9s de <b>Grupos Asignados</b>.</p>'),
unistr('<p>Utilice el selector de <b>M\00F3dulos Protegidos</b> para seleccionar los m\00F3dulos de servicio RESTful a los que se deben asignar los privilegios. S\00F3lo se puede asignar un privilegio a un m\00F3dulo.</p>')))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1503988405960569372.4851)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1481359725287168196.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(348186514931535843.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1481359509686168196.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(348186514931535843.4851)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P6_ID is not null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1481359405275168196.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(348186514931535843.4851)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P6_ID is not null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1481359325157168196.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(348186514931535843.4851)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P6_ID is  null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1481360315897168198.4851)
,p_branch_action=>'f?p=&APP_ID.:4:&SESSION.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1481360521739168199.4851)
,p_name=>'P6_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1481359110874168192.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Id'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1481360715399168205.4851)
,p_name=>'P6_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1481359110874168192.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nombre'
,p_source=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Introduzca un nombre para identificar el privilegio de servicio RESTful.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1481360913225168206.4851)
,p_name=>'P6_LABEL'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1481359110874168192.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Etiqueta'
,p_source=>'LABEL'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>100
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Introduzca un valor de etiqueta para identificar el privilegio de servicio RESTful.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1481361126755168206.4851)
,p_name=>'P6_DESCRIPTION'
,p_item_sequence=>45
,p_item_plug_id=>wwv_flow_api.id(1481359110874168192.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Descripci\00F3n')
,p_source=>'DESCRIPTION'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>43
,p_cMaxlength=>4000
,p_cHeight=>2
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Introduzca una breve descripci\00F3n del privilegio de servicio RESTful.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1481361326853168207.4851)
,p_name=>'P6_COMMENTS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(1503988405960569372.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios'
,p_source=>'COMMENTS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>90
,p_cMaxlength=>4000
,p_cHeight=>3
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Introduzca comentarios opcionales.'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1499741302780338342.4851)
,p_name=>'P6_MODULES'
,p_item_sequence=>47
,p_item_plug_id=>wwv_flow_api.id(1481359110874168192.4851)
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_column      varchar2(32767) := null;',
'    l_all_columns varchar2(32767) := null;',
'begin',
'    for c1 in (',
'       select name',
'         from wwv_flow_rt$modules',
'        where security_group_id = :flow_security_group_id',
'          and privilege_id = :P6_ID',
'       order by name',
'    ) loop',
'        l_all_columns := l_all_columns||c1.name||'':'';',
'    end loop;',
'',
'    return rtrim(l_all_columns,'':'');',
' ',
'end;'))
,p_item_default_type=>'PLSQL_FUNCTION_BODY'
,p_prompt=>unistr('M\00F3dulos Protegidos')
,p_display_as=>'NATIVE_SHUTTLE'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r from (',
'select name d, id r',
'from wwv_flow_rt$modules',
'where security_group_id = :flow_security_group_id',
'and privilege_id is null)'))
,p_cSize=>150
,p_cMaxlength=>4000
,p_cHeight=>10
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Seleccione uno o m\00E1s m\00F3dulos a los que asignar este privilegio. Un m\00F3dulo s\00F3lo puede tener un privilegio asignado.')
,p_attribute_01=>'MOVE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1511194715694592616.4851)
,p_name=>'P6_GROUP'
,p_item_sequence=>35
,p_item_plug_id=>wwv_flow_api.id(1481359110874168192.4851)
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  for c1 in (select id from wwv_flow_fnd_user_groups',
'              where group_name = ''RESTful Services''',
'                and security_group_id = 10)',
'  loop',
'      return c1.id;',
'  end loop;',
'end;'))
,p_item_default_type=>'PLSQL_FUNCTION_BODY'
,p_prompt=>'Grupos Asignados'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select user_group_id from wwv_flow_rt$privilege_groups',
'where security_group_id = :flow_security_group_id',
'and privilege_id = :P6_ID'))
,p_source_type=>'QUERY_COLON'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'USER_GROUPS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select group_name d, id r',
'from   wwv_flow_fnd_user_groups_noapp',
'where  security_group_id = :flow_security_group_id',
'union all',
'select group_name d, id r',
'from wwv_flow_fnd_user_groups_noapp',
'where  security_group_id = 10',
'and :flow_security_group_id <> 10',
'and group_name = ''RESTful Services'''))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>6
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Identifica los grupos de usuarios a los que est\00E1 asignado este privilegio. Un privilegio se debe asignar al menos a un grupo. Por defecto, un privilegio se asignar\00E1 al grupo de servicios RESTful. Si los usuarios desean acceder a un m\00F3dulo de servicio')
||' RESTful protegido por un privilegio asignado al grupo de servicios RESTful, el administrador del espacio de trabajo debe asignar usuarios al grupo de servicios RESTful.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1481361702962168210.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_RT$PRIVILEGES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$PRIVILEGES'
,p_attribute_03=>'P6_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1503104607842380669.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Remove Associations to Removed Privilege'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  -- Remove association to Modules',
'  update wwv_flow_rt$modules',
'     set privilege_id = null',
'   where privilege_id = :P6_ID;',
'',
'  -- Remove association to User Groups',
'  delete from wwv_flow_rt$privilege_groups',
'   where privilege_id = :P6_ID',
'     and security_group_id = :flow_security_group_id;',
'',
'   commit;',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1481359509686168196.4851)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1481361926344168210.4851)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_RT$PRIVILEGES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$PRIVILEGES'
,p_attribute_03=>'P6_ID'
,p_attribute_04=>'ID'
,p_attribute_09=>'P6_ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('Acci\00F3n Procesada.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1495911220134895657.4851)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Module-Privilege Relationship'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    j int := 0;',
'    c wwv_flow_global.vc_arr2;',
'begin',
'',
'    c := wwv_flow_utilities.string_to_table2(:P6_MODULES);',
'',
'    -- Insert New Module-Privilege Relationships',
'    for j in 1..c.count loop',
'        update wwv_flow_rt$modules',
'           set privilege_id = :P6_ID',
'         where id = c(j)',
'           and security_group_id = :flow_security_group_id;',
'    end loop;',
'    commit;',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1481359325157168196.4851)
,p_process_when=>'P8_MODULES'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1495926525675897195.4851)
,p_process_sequence=>60
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Module-Privilege Relationship'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    j int := 0;',
'    k int := 0;',
'    l_existing_modules   varchar2(4000) := null;',
'    l_selected_modules   varchar2(4000) := null;',
'    c wwv_flow_global.vc_arr2;',
'    d wwv_flow_global.vc_arr2;',
'    e wwv_flow_global.vc_arr2;',
'begin',
'',
'    l_selected_modules := :P6_MODULES;',
'    c := wwv_flow_utilities.string_to_table2(:P6_MODULES);',
'',
'    for j in 1..c.count loop',
'        if not wwv_flow_utilities.is_numeric(c(j)) then',
'            select id into e(j) from wwv_flow_rt$modules where name = c(j)',
'               and security_group_id = :flow_security_group_id;',
'            l_selected_modules := replace(l_selected_modules,c(j),e(j));',
'        else',
'            e(j) := c(j); ',
'        end if;',
'    end loop;',
'',
'    -- Retrieve List of Existing Protected Modules',
'    for c1 in (select id from wwv_flow_rt$modules',
'                where privilege_id = :P6_ID)',
'    loop',
'        l_existing_modules := l_existing_modules||c1.id||'':'';',
'    end loop;',
'',
'    -- No Modules Available for Selection',
'    if l_existing_modules is null and l_selected_modules is null then',
'        null;',
'',
'    -- New Modules Selected',
'    elsif l_existing_modules is null and l_selected_modules is not null then',
'',
'        -- Insert New Module-Privilege Relationships',
'        for j in 1..e.count loop',
'',
'            update wwv_flow_rt$modules',
'               set privilege_id = :P6_ID',
'             where id = e(j)',
'               and security_group_id = :flow_security_group_id;',
'        end loop;',
'        commit;',
'',
'    -- Remove Existing Module-Privilege Relationships',
'    elsif l_existing_modules is not null and l_selected_modules is null then',
'',
'        update wwv_flow_rt$modules',
'           set privilege_id = null',
'         where privilege_id = :P6_ID',
'           and security_group_id = :flow_security_group_id;',
'            ',
'        commit;',
'',
'    -- Existing Modules and New Modules Selected - Update Accordingly',
'    elsif l_existing_modules is not null and l_selected_modules is not null then',
'',
'        for j in 1..e.count loop',
'',
'            -- Newly Selected Module',
'            if instr(l_existing_modules,e(j)) = 0 then',
'                update wwv_flow_rt$modules',
'                   set privilege_id = :P6_ID',
'                 where id = e(j)',
'                   and security_group_id = :flow_security_group_id;',
'                commit;',
'',
'            -- Selected Module Already Associated to Privilege',
'            elsif instr(l_existing_modules,e(j)) > 0 then',
'                l_existing_modules := replace(l_existing_modules,e(j));',
'            end if;',
'            commit;',
'        end loop;',
'',
'        -- Delete Any Removed Relationships',
'        d := wwv_flow_utilities.string_to_table2(l_existing_modules);',
'',
'        for k in 1..d.count loop',
'          update wwv_flow_rt$modules',
'             set privilege_id = null',
'           where privilege_id = :P6_ID',
'             and id = d(k)',
'             and security_group_id = :flow_security_group_id;',
'          commit;',
'        end loop;',
'    end if;',
'',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1481359405275168196.4851)
,p_process_when=>'P8_MODULES'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1511859820477764368.4851)
,p_process_sequence=>64
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Privilege-Group Assignments'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  j int := 0;',
'  c wwv_flow_global.vc_arr2;',
'begin',
'',
'    c := wwv_flow_utilities.string_to_table2(:P6_GROUP);',
'',
'    -- Insert New Privilege-Group Assignment',
'    for j in 1..c.count loop',
'        insert into wwv_flow_rt$privilege_groups(privilege_id,user_group_id)',
'                   values(:P6_ID,c(j));',
'    end loop;',
'    commit;',
'',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1481359325157168196.4851)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1511605603583664825.4851)
,p_process_sequence=>65
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Privilege-Group Assignments'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  j int := 0;',
'  k int := 0;',
'  l_selected_grps    varchar2(4000) := null;',
'  l_existing_grps    varchar2(4000) := null;',
'  c wwv_flow_global.vc_arr2;',
'  d wwv_flow_global.vc_arr2;',
'begin',
'    l_selected_grps := :P6_GROUP;',
'    c := wwv_flow_utilities.string_to_table2(:P6_GROUP);',
'',
'    -- Retrieve List of Existing Privilege-Group Assignments',
'    for c1 in (select distinct user_group_id from wwv_flow_rt$privilege_groups',
'                where privilege_id = :P6_ID)',
'    loop',
'        l_existing_grps := l_existing_grps||c1.user_group_id||'':'';',
'    end loop;',
'',
'    -- No Groups Selected',
'    if l_existing_grps is null and l_selected_grps is null then',
'        null;',
'',
'    -- New Group Selected',
'    elsif l_existing_grps is null and l_selected_grps is not null then',
'',
'        -- Insert New Privilege-Group Assignment',
'        for j in 1..c.count loop',
'',
'            insert into wwv_flow_rt$privilege_groups(privilege_id,user_group_id)',
'                       values(:P6_ID,c(j));',
'        end loop;',
'        commit;',
'',
'    -- Remove Existing Privilege-Group Assignments',
'    elsif l_existing_grps is not null and l_selected_grps is null then',
'',
'        delete from wwv_flow_rt$privilege_groups',
'         where privilege_id = :P6_ID',
'           and security_group_id = :flow_security_group_id;',
'            ',
'        commit;',
'',
'    -- Existing Groups and New Group Selected - Update Accordingly',
'    elsif l_existing_grps is not null and l_selected_grps is not null then',
'',
'        for j in 1..c.count loop',
'',
'            -- Newly Selected Group',
'            if instr(l_existing_grps,c(j)) = 0 then',
'                insert into wwv_flow_rt$privilege_groups (privilege_id, user_group_id)',
'                          values(:P6_ID,c(j));',
'                commit;',
'',
'            -- Selected Group Already Associated to Privilege',
'            elsif instr(l_existing_grps,c(j)) > 0 then',
'                l_existing_grps := replace(l_existing_grps,c(j));',
'            end if;',
'            commit;',
'        end loop;',
'',
'        -- Delete Any Removed Assignments',
'        d := wwv_flow_utilities.string_to_table2(l_existing_grps);',
'',
'        for k in 1..d.count loop',
'          delete from wwv_flow_rt$privilege_groups',
'           where privilege_id = :P6_ID',
'             and user_group_id = d(k)',
'             and security_group_id = :flow_security_group_id;',
'          commit;',
'        end loop;',
'    end if;',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1481359405275168196.4851)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1481362110253168210.4851)
,p_process_sequence=>70
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'6'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1481359509686168196.4851)
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Registro de Cliente'
,p_step_title=>'Registro de Cliente'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(719672816683933088.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
,p_protection_level=>'D'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_plug_name=>'Registro de Cliente'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(6674714399641047.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_2'
,p_plug_item_display_point=>'BELOW'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1504542129313651862.4851)
,p_plug_name=>'Acerca de'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(6674010598641046.4851)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_3'
,p_plug_source=>unistr('<p>El registro de cliente permite la asociaci\00F3n de privilegios del servicio RESTful a aplicaciones de &PRODUCT_NAME., que se utilizar\00E1n en la asignaci\00F3n de restricciones de seguridad en los servicios RESTful.<br/>Utilice el desplazador de <b>Privileg')
||unistr('ios</b> para seleccionar los privilegios del servicio RESTful que desea asociar a la aplicaci\00F3n seleccionada.</p>')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1504542329439651862.4851)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(6674714399641047.4851)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_3'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1504538922478651854.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1504539519555651854.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P7_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1504539320140651854.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_condition=>'P7_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1504539111714651854.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P7_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1504544332492651869.4851)
,p_branch_action=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1504539726779651855.4851)
,p_name=>'P7_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1504539923994651857.4851)
,p_name=>'P7_APPLICATIONS'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_prompt=>unistr('Aplicaci\00F3n')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name||decode(build_status,''RUN_ONLY'','' - ''||sm.run_only,null)',
'      app_name, id r',
'from   wwv_flows f,',
'      (select wwv_flow_lang.system_message(''RUN'') run,',
'              wwv_flow_lang.system_message(''RUN_ONLY'') run_only,',
'              wwv_flow_lang.system_message(''RUN_AND_BUILD'') run_and_build,',
'              wwv_flow_lang.system_message(''F4000.YES'') t_yes,',
'              wwv_flow_lang.system_message(''F4000.NO'') t_no,',
'              wwv_flow_lang.system_message(''Unassigned'') t_unassigned',
'       from sys.dual) sm',
'where',
'       security_group_id = :flow_security_group_id and',
'       f.build_status != ''RUN_AND_HIDDEN'' and',
'       not exists (',
'       select null from wwv_flow_language_map',
'       where translation_flow_id = f.id and',
'         security_group_id = :flow_security_group_id) and',
'       not exists (',
'       select null from wwv_flow_rt$clients',
'       where name = f.name and',
'         security_group_id = :flow_security_group_id) and',
'       (',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and',
'             flow_id is null and',
'             security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and',
'             flow_id = f.id and',
'             security_group_id = :flow_security_group_id ))'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- Seleccionar Aplicaci\00F3n -')
,p_cHeight=>1
,p_display_when=>'P7_ID'
,p_display_when_type=>'ITEM_IS_NULL'
,p_field_template=>wwv_flow_api.id(6683627983641072.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Seleccione la aplicaci\00F3n &PRODUCT_NAME. para registrar los privilegios.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1504541411354651859.4851)
,p_name=>'P7_PRIVS'
,p_item_sequence=>75
,p_item_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_column      varchar2(32767) := null;',
'    l_all_columns varchar2(32767) := null;',
'begin',
'    for c1 in (',
'       select b.label',
'         from wwv_flow_rt$privileges b, wwv_flow_rt$client_privileges a',
'        where a.security_group_id = :flow_security_group_id',
'          and b.security_group_id = a.security_group_id',
'          and b.id = a.privilege_id',
'          and a.client_id = :P7_ID',
'        order by b.label',
'    ) loop',
'        l_all_columns := l_all_columns||c1.label||'':'';',
'    end loop;',
'',
'    return rtrim(l_all_columns,'':'');',
' ',
'end;'))
,p_item_default_type=>'PLSQL_FUNCTION_BODY'
,p_prompt=>'Privilegios'
,p_display_as=>'NATIVE_SHUTTLE'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r from (',
'select label d, id r',
'from wwv_flow_rt$privileges',
'where security_group_id = :flow_security_group_id',
'and id not in (select privilege_id from wwv_flow_rt$client_privileges where security_group_id = :flow_security_group_id and client_id = :P7_ID))'))
,p_cHeight=>10
,p_field_template=>wwv_flow_api.id(6683627983641072.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Seleccione uno o m\00E1s privilegios para registrar con la aplicaci\00F3n seleccionada. Un privilegio se puede asignar a uno o m\00E1s grupos.')
,p_attribute_01=>'MOVE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1504542510412651862.4851)
,p_name=>'P7_COMMENTS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(1504542329439651862.4851)
,p_prompt=>'Comentarios'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>90
,p_cMaxlength=>4000
,p_cHeight=>3
,p_field_template=>wwv_flow_api.id(6683429755641072.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Introduzca comentarios opcionales.'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1514914507643009675.4851)
,p_name=>'P7_APP_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_prompt=>unistr('Aplicaci\00F3n:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''Third Party Application'' r, 0 d from sys.dual',
'union all',
'select id||''. ''||name||decode(build_status,''RUN_ONLY'','' - ''||sm.run_only,null)',
'      app_name, id r',
'from   wwv_flows f,',
'      (select wwv_flow_lang.system_message(''RUN'') run,',
'              wwv_flow_lang.system_message(''RUN_ONLY'') run_only,',
'              wwv_flow_lang.system_message(''RUN_AND_BUILD'') run_and_build,',
'              wwv_flow_lang.system_message(''F4000.YES'') t_yes,',
'              wwv_flow_lang.system_message(''F4000.NO'') t_no,',
'              wwv_flow_lang.system_message(''Unassigned'') t_unassigned',
'       from sys.dual) sm',
'where',
'       security_group_id = :flow_security_group_id and',
'       f.build_status != ''RUN_AND_HIDDEN'' and',
'       not exists (',
'       select null from wwv_flow_language_map',
'       where translation_flow_id = f.id and',
'         security_group_id = :flow_security_group_id) and',
'       (',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and',
'             flow_id is null and',
'             security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and',
'             flow_id = f.id and',
'             security_group_id = :flow_security_group_id ))'))
,p_cattributes_element=>'class="fielddatabold"'
,p_display_when=>'P7_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(6683429755641072.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica la aplicaci\00F3n registrada con el cliente. La aplicaci\00F3n puede ser una aplicaci\00F3n de &PRODUCT_NAME. o una aplicaci\00F3n de terceros.')
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1645007507449009677.4851)
,p_name=>'P7_CLIENT_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_item_default=>'return to_char(wwv_flow_id.next_val);'
,p_item_default_type=>'PLSQL_FUNCTION_BODY'
,p_prompt=>'Identificador de Cliente'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>32
,p_field_template=>wwv_flow_api.id(6683627983641072.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Identifica el ID del cliente.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1645034518877013003.4851)
,p_name=>'P7_CLIENT_SECRET'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_prompt=>'Secreto del Cliente'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>32
,p_field_template=>wwv_flow_api.id(6683429755641072.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica la contrase\00F1a para el ID del cliente.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1654095522420863644.4851)
,p_name=>'P7_CLIENT_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(1504538706569651852.4851)
,p_prompt=>'Cliente:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold"'
,p_display_when=>'P7_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(6683429755641072.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Identifica el nombre del cliente registrado.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1515947531659300436.4851)
,p_computation_sequence=>10
,p_computation_item=>'P7_APP_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(apex_application_id,0) from wwv_flow_rt$clients',
'where id = :P7_ID',
'and security_group_id = :flow_security_group_id'))
,p_compute_when=>'P7_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1645079623510023770.4851)
,p_computation_sequence=>10
,p_computation_item=>'P7_CLIENT_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select client_id from wwv_flow_rt$clients',
'where id = :P7_ID',
'and security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1645165519832032208.4851)
,p_computation_sequence=>10
,p_computation_item=>'P7_CLIENT_SECRET'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select client_secret from wwv_flow_rt$clients',
'where id = :P7_ID',
'and security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1654142807314868799.4851)
,p_computation_sequence=>10
,p_computation_item=>'P7_CLIENT_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name from wwv_flow_rt$clients',
'where id = :P7_ID',
'and security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1515011724397023926.4851)
,p_validation_name=>'Application Must Be Selected'
,p_validation_sequence=>10
,p_validation=>'P7_APPLICATIONS'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Se debe seleccionar #LABEL#.'
,p_validation_condition=>'P7_ID'
,p_validation_condition_type=>'ITEM_IS_NULL'
,p_when_button_pressed=>wwv_flow_api.id(1504539519555651854.4851)
,p_associated_item=>wwv_flow_api.id(1504539923994651857.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1515090611153039024.4851)
,p_validation_name=>'At Least One Privilege Must Be Selected'
,p_validation_sequence=>20
,p_validation=>'P7_PRIVS'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('Debe seleccionar al menos un m\00F3dulo.')
,p_associated_item=>wwv_flow_api.id(1504541411354651859.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1656728706405578188.4851)
,p_validation_name=>'Client ID Cannot Be Null'
,p_validation_sequence=>30
,p_validation=>'P7_CLIENT_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('#LABEL# debe tener alg\00FAn valor.')
,p_associated_item=>wwv_flow_api.id(1645007507449009677.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1504543420356651866.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Remove Client-Privilege Associations'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  delete from wwv_flow_rt$clients',
'   where id = :P7_ID',
'     and security_group_id = :flow_security_group_id;',
'     --and apex_application_id = :P7_APP_ID;',
'',
'   commit;',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1504539111714651854.4851)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1504543226350651866.4851)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Client-Privilege Association'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    j                    int                       := 0;',
'    l_client_id          number                    := null;',
'    l_app_id             number                    := null;',
'    l_app_name           varchar2(255)             := null;',
'    l_email_address      varchar2(255)             := null;',
'    c                    wwv_flow_global.vc_arr2;',
'begin',
'',
'    -- Retrieve user''s email address',
'    select email_address into l_email_address ',
'    from wwv_flow_fnd_user where user_name = :flow_user',
'     and security_group_id = :flow_security_group_id;',
'',
'    -- Retrieve Application Name',
'    select name into l_app_name from wwv_flows',
'     where id = :P7_APPLICATIONS',
'       and security_group_id = :flow_security_group_id;',
'',
'    -- Set Application Id',
'    l_app_id := :P7_APPLICATIONS;',
'',
'    insert into wwv_flow_rt$clients (auth_flow,',
'                                     response_type,',
'                                     name,',
'                                     apex_application_id,',
'                                     client_id,',
'                                     client_secret,',
'                                     support_email)',
'                              values(',
'                                     ''EXCHANGE'',',
'                                     ''TOKEN'',',
'                                     l_app_name,',
'                                     l_app_id,',
'                                     :P7_CLIENT_ID,--to_char(wwv_flow_id.next_val),',
'                                     :P7_CLIENT_SECRET,',
'                                     l_email_address)',
'                              returning id into l_client_id;    ',
'',
'    -- Insert New Client-Privileges',
'    c := wwv_flow_utilities.string_to_table2(:P7_PRIVS);',
'',
'    for j in 1..c.count loop',
'        insert into wwv_flow_rt$client_privileges (client_id, ',
'                                                   privilege_id) ',
'                                           values (',
'                                                   l_client_id,',
'                                                   c(j));',
'    end loop;',
'    commit;',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1504539519555651854.4851)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1504543003374651865.4851)
,p_process_sequence=>60
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Module-Privilege Relationship'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    j int := 0;',
'    k int := 0;',
'    l_existing_privs   varchar2(4000) := null;',
'    l_selected_privs   varchar2(4000) := null;',
'    c wwv_flow_global.vc_arr2;',
'    d wwv_flow_global.vc_arr2;',
'    e wwv_flow_global.vc_arr2;',
'begin',
'',
'    l_selected_privs := :P7_PRIVS;',
'    c := wwv_flow_utilities.string_to_table2(:P7_PRIVS);',
'',
'    -- Update Client ID & Secret',
'    update wwv_flow_rt$clients',
'       set client_id = :P7_CLIENT_ID,',
'           client_secret = :P7_CLIENT_SECRET',
'     where id = :P7_ID;',
'',
'    for j in 1..c.count loop',
'        if not wwv_flow_utilities.is_numeric(c(j)) then',
'            select id into e(j) from wwv_flow_rt$privileges where label = c(j)',
'               and security_group_id = :flow_security_group_id;',
'            l_selected_privs := replace(l_selected_privs,c(j),e(j));',
'        else',
'            e(j) := c(j); ',
'        end if;',
'    end loop;',
'',
'    -- Retrieve List of Existing Privileges Associated with Client',
'    for c1 in (select privilege_id from wwv_flow_rt$client_privileges',
'                where client_id = :P7_ID',
'                  and security_group_id = :flow_security_group_id)',
'    loop',
'        l_existing_privs := l_existing_privs||c1.privilege_id||'':'';',
'    end loop;',
'',
'    -- No Privileges Available for Selection',
'    if l_existing_privs is null and l_selected_privs is null then',
'        null;',
'',
'    -- New Privileges Selected',
'    elsif l_existing_privs is null and l_selected_privs is not null then',
'',
'        -- Insert New Privilege-Group Assignment',
'        for j in 1..e.count loop',
'            insert into wwv_flow_rt$client_privileges(client_id,privilege_id) values(:P7_ID,e(j));',
'        end loop;',
'        commit;',
'',
'    -- Remove Existing Client-Privilege Assignments',
'    elsif l_existing_privs is not null and l_selected_privs is null then',
'',
'        delete from wwv_flow_rt$client_privileges',
'         where client_id = :P7_ID',
'           and security_group_id = :flow_security_group_id;',
'            ',
'        commit;',
'',
'    -- Existing Privileges and New Privileges Selected - Update Accordingly',
'    elsif l_existing_privs is not null and l_selected_privs is not null then',
'',
'        for j in 1..e.count loop',
'',
'            -- Newly Selected Privilege',
'            if instr(l_existing_privs,e(j)) = 0 then',
'                insert into wwv_flow_rt$client_privileges(client_id, privilege_id) values(:P7_ID, e(j));',
'                commit;',
'',
'            -- Selected Privilege Already Associated to Client',
'            elsif instr(l_existing_privs,e(j)) > 0 then',
'                l_existing_privs := replace(l_existing_privs,e(j));',
'            end if;',
'            commit;',
'        end loop;',
'',
'        -- Delete Any Removed Assignments',
'        d := wwv_flow_utilities.string_to_table2(l_existing_privs);',
'',
'        for k in 1..d.count loop',
'            delete from wwv_flow_rt$client_privileges',
'             where client_id = :P7_ID',
'               and privilege_id = d(k)',
'               and security_group_id = :flow_security_group_id;',
'',
'          commit;',
'        end loop;',
'    end if;',
'',
'',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1504539320140651854.4851)
,p_process_when=>'P8_MODULES'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1504544004783651867.4851)
,p_process_sequence=>70
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'6'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1504539111714651854.4851)
);
end;
/
prompt --application/pages/page_00008
begin
wwv_flow_api.create_page(
 p_id=>8.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Probar Manejador de Recursos'
,p_step_title=>'Probar Manejador de Recursos'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script type="text/javascript">',
'',
'function saveBinds(){',
'  var c = 0;',
'  var arr1 = new Array();',
'  var arr2 = new Array();',
'  var get = new htmldb_Get(null,4850,''SAVE_BINDS'',8, null, ''wwv_flow.accept'');',
'  var url = $x(''P8_TEST_URL'').value; ',
'',
'  apex.jQuery("[name=f01]").each(function(){',
'    get.addParam(''f01'', this.value);',
'    arr1[c] = this.value;',
'    c = c+1;',
'  });',
'',
'  c = 0;',
'  apex.jQuery("[name=f02]").each(function(){',
'    get.addParam(''f02'', this.value);',
'    arr2[c] = this.value;',
'    c = c+1;',
'  });    ',
'  	        ',
'  var x = get.get(''FULL'');',
'  for (var i=0;i<arr1.length;i++) {',
'      url = url.replace(''{''+arr1[i].toLowerCase().replace('':'','''')+''}'',arr2[i]);',
'  }',
'  popUp2(url,''800'',''600'');',
'}',
'',
'function testQuery(){',
'  if (document.wwv_flow.f01) {',
'    saveBinds();',
'  }',
' ',
'}    ',
'            ',
'</script>',
''))
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
''))
,p_step_template=>wwv_flow_api.id(719672364834933087.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1733770413928176715.4851)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1733772827846176722.4851)
,p_plug_name=>'Origen'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1746459609587553150.4851)
,p_name=>'Definir Variables de Enlace'
,p_parent_plug_id=>wwv_flow_api.id(1733772827846176722.4851)
,p_template=>wwv_flow_api.id(388770208095784265.4851)
,p_display_sequence=>90
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'FUNC_BODY_RETURNING_SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_binds sys.dbms_sql.varchar2_table;',
'begin',
'    if (htmldb_collection.collection_exists(''SET_BINDS'')=false) then',
'',
'        htmldb_collection.create_or_truncate_collection(p_collection_name => ''SET_BINDS'');',
'        l_binds := wwv_flow_utilities.get_binds(:P9_SOURCE);',
'',
'        for i in 1 .. l_binds.count ',
'        loop',
'            htmldb_collection.add_member(',
'                p_collection_name => ''SET_BINDS'',',
'                p_c001            => l_binds(i),',
'                p_generate_md5    => ''YES'' );',
'        end loop;',
'',
'    end if;',
'',
'    return ''',
'        select c001||wwv_flow_item.hidden(1,c001) c001, wwv_flow_item.text(2,c002) ',
'        from wwv_flow_collections ',
'        where collection_name = ''''SET_BINDS'''''';',
'end;'))
,p_display_when_condition=>'SET_BINDS'
,p_ajax_items_to_submit=>'P9_SOURCE'
,p_query_row_template=>wwv_flow_api.id(719768854998973277.4851)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>'No se ha encontrado ninguna variable de enlace.'
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image=>'apex/builder/dup.gif'
,p_query_asc_image_attr=>'width="16" height="16" alt="" '
,p_query_desc_image=>'apex/builder/ddown.gif'
,p_query_desc_image_attr=>'width="16" height="16" alt="" '
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1746459804326553155.4851)
,p_query_column_id=>1
,p_column_alias=>'C001'
,p_column_display_sequence=>1
,p_column_heading=>'Variable de Enlace'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1746459927708553155.4851)
,p_query_column_id=>2
,p_column_alias=>'WWV_FLOW_ITEM.TEXT(2,C002)'
,p_column_display_sequence=>2
,p_column_heading=>'Valor'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1733770616928176715.4851)
,p_button_sequence=>11
,p_button_plug_id=>wwv_flow_api.id(1733770413928176715.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::P9_TEMPLATE_ID:&P8_TEMPLATE_ID.'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1733771009972176718.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(1733770413928176715.4851)
,p_button_name=>'TEST'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Probar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:testQuery();'
,p_button_condition=>'P8_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1733780410256176751.4851)
,p_branch_action=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(1733770616928176715.4851)
,p_branch_sequence=>30
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1733773023324176722.4851)
,p_name=>'P8_SOURCE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1733772827846176722.4851)
,p_item_default=>'&P9_SOURCE.'
,p_prompt=>'Origen'
,p_source=>'P9_SOURCE'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>70
,p_cMaxlength=>32767
,p_cHeight=>12
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica la consulta SQL o el bloque PL/SQL responsable del manejo del m\00E9todo HTTP seleccionado. Se pueden definir varios manejadores de recursos para una plantilla de recurso. Para definir manejadores adicionales, edite el m\00F3dulo de servicio RESTf')
||unistr('ul reci\00E9n creado.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1733774909651176726.4851)
,p_name=>'P8_TEST_URL'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(1733772827846176722.4851)
,p_prompt=>'Test Resource Handler'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1746819013490611074.4851)
,p_name=>'P8_TEMPLATE_ID'
,p_item_sequence=>275
,p_item_plug_id=>wwv_flow_api.id(1733772827846176722.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1747198221895670291.4851)
,p_name=>'P8_ID'
,p_item_sequence=>300
,p_item_plug_id=>wwv_flow_api.id(1733772827846176722.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1748829401612175403.4851)
,p_name=>'P8_WS_DISPLAY_NAME'
,p_item_sequence=>310
,p_item_plug_id=>wwv_flow_api.id(1733772827846176722.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1747540208183751477.4851)
,p_computation_sequence=>10
,p_computation_item=>'P8_SOURCE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'P9_SOURCE'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1748721200658156203.4851)
,p_computation_sequence=>50
,p_computation_item=>'P8_WS_DISPLAY_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>'select display_name from wwv_flow_companies where provisioning_company_id = :flow_security_group_id'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1739972501689962650.4851)
,p_name=>'Set Source to Read Only'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P8_SOURCE'
,p_condition_element=>'P8_SOURCE'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1739972812731962651.4851)
,p_event_id=>wwv_flow_api.id(1739972501689962650.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P8_SOURCE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1748672211262149779.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Test URL Setting'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  for i in 1..wwv_flow.g_f01.count loop   	   ',
'      htmldb_collection.update_member(',
'        p_collection_name => ''SET_BINDS'',',
'        p_seq             => i,',
'        p_c001            => wwv_flow.g_f01(i),',
'        p_c002            => wwv_flow.g_f02(i)',
'    );',
'  end loop;',
'',
'  htmldb_collection.update_member(',
'    p_collection_name => ''REST_QUERIES'',',
'    p_seq             => :P8_ID,',
'    p_clob001         => :P8_SOURCE,',
'    p_c002            => wwv_flow_utilities.table_to_string2(wwv_flow.g_f01,''|''),',
'    p_c003            => wwv_flow_utilities.table_to_string2(wwv_flow.g_f02,''|'')',
'  ); ',
'',
'  commit;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'SET_BINDS'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00009
begin
wwv_flow_api.create_page(
 p_id=>9.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Manejador de Recursos'
,p_step_title=>'Manejador de Recursos'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(754939123056928433.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(415717831389309088.4851)
,p_plug_name=>'Manejador de Recursos'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_read_only_when_type=>'PLSQL_EXPRESSION'
,p_plug_read_only_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')',
''))
,p_plug_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Un manejador de recursos es una consulta o un bloque PL/SQL an\00F3nimo responsable del'),
unistr('manejo de un m\00E9todo concreto HTTP. Aunque es posible definir varios manejadores de'),
unistr('recursos para una plantilla de recurso, s\00F3lo se permite un manejador de recursos por cada m\00E9todo HTTP.</p>'),
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(417550318651558505.4851)
,p_plug_name=>'Manejador de Recursos: &P9_CONTEXT2.'
,p_region_css_classes=>'a-Region--noTopBorder'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--showTitle'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1421455001426645001.4851)
,p_name=>unistr('Par\00E1metros')
,p_template=>wwv_flow_api.id(719706437830942782.4851)
,p_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'a-Region--stacked:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--stretch'
,p_region_attributes=>'style="width: 100%"'
,p_new_grid_row=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id,',
'       name,',
'       bind_variable_name,',
'       access_method,',
'       source_type,',
'       param_type',
'  from wwv_flow_rt$parameters',
' where security_group_id = to_number(:flow_security_group_id)',
'   and handler_id = to_number(:P9_ID)'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(6680513762641056.4851)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_no_data_found=>unistr('No se ha definido ning\00FAn par\00E1metro')
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image=>'apex/builder/dup.gif'
,p_query_asc_image_attr=>'width="16" height="16" alt="" '
,p_query_desc_image=>'apex/builder/ddown.gif'
,p_query_desc_image_attr=>'width="16" height="16" alt="" '
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1421886809831704196.4851)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_column_heading=>'Edit'
,p_use_as_row_header=>'N'
,p_column_link=>'javascript:apex.submit({request:''UPDATE'',set:{''P9_HANDLER_ID'':''#ID#''}});'
,p_column_linktext=>'<img width="16" height="16" border="0" alt="Editar" src="#IMAGE_PREFIX#menu/pencil16x16.gif"/>'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1421455313367645006.4851)
,p_query_column_id=>2
,p_column_alias=>'NAME'
,p_column_display_sequence=>2
,p_column_heading=>'Nombre'
,p_column_link=>'javascript:apex.submit({request:''UPDATE'',set:{''P9_HANDLER_ID'':''#ID#''}});'
,p_column_linktext=>'#NAME#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1479086417854530566.4851)
,p_query_column_id=>3
,p_column_alias=>'BIND_VARIABLE_NAME'
,p_column_display_sequence=>3
,p_column_heading=>'Nombre de Variable de Enlace'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1421455500048645006.4851)
,p_query_column_id=>4
,p_column_alias=>'ACCESS_METHOD'
,p_column_display_sequence=>4
,p_column_heading=>unistr('M\00E9todo de Acceso')
,p_use_as_row_header=>'N'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(793423420718336071)
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1479086501785530567.4851)
,p_query_column_id=>5
,p_column_alias=>'SOURCE_TYPE'
,p_column_display_sequence=>5
,p_column_heading=>'Tipo de Origen'
,p_use_as_row_header=>'N'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(793403203749331167)
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1421455703240645006.4851)
,p_query_column_id=>6
,p_column_alias=>'PARAM_TYPE'
,p_column_display_sequence=>6
,p_column_heading=>unistr('Tipo de Par\00E1metro')
,p_use_as_row_header=>'N'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(793443816001344104)
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1423464203260128067.4851)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(6674714399641047.4851)
,p_plug_display_sequence=>100
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1423652610972187103.4851)
,p_plug_name=>'Origen'
,p_region_template_options=>'a-Region--flush:a-Region--noPadding:a-Region--sideRegion:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_read_only_when_type=>'PLSQL_EXPRESSION'
,p_plug_read_only_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(871840316452657306.4851)
,p_plug_name=>'Ejemplo'
,p_parent_plug_id=>wwv_flow_api.id(1423652610972187103.4851)
,p_region_template_options=>'#DEFAULT#:is-collapsed:a-Region--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719691677138942761.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.prn(''<br /><b>Uniform Resource Identifier (URI)</b>'');',
'sys.htp.prn(''<pre>'');',
'sys.htp.prn(''hr/employees/{ID}''||chr(10));',
'sys.htp.prn(''|_|_________|____|''||chr(10));',
'sys.htp.prn('' |     |      |''||chr(10));',
'sys.htp.prn('' |     |       -''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER_BIND_VARIABLE'')||chr(10));',
'sys.htp.prn('' |     | ''||chr(10));',
'sys.htp.prn('' |      - ''||wwv_flow_lang.system_message(''DB_SERVICES_TEMPLATE_URI'')||chr(10));',
'sys.htp.prn('' |''||chr(10));',
'sys.htp.prn(''  - ''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_URI'')||chr(10));',
'sys.htp.prn('' </pre>'');',
'',
'sys.htp.prn(''<br/><b>Module Name</b>'');',
'sys.htp.prn(''<pre>oracle.example.hr</pre>'');',
'sys.htp.prn(''<br/><b>URI Prefix</b>'');',
'sys.htp.prn(''<pre>hr/</pre>'');',
'sys.htp.prn(''<br/><b>URI Template</b>'');',
'sys.htp.prn(''<pre>employees/{ID}</pre>'');',
'sys.htp.prn(''<br/><b>Handler Method</b>'');',
'sys.htp.prn(''<pre>GET</pre>'');',
'sys.htp.prn(''<br/><b>Handler Source Type</b>'');',
'sys.htp.prn(''<pre>Query One Row</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER_SOURCE'')||''</b>'');',
'sys.htp.prn(''<pre>select EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO                 ',
' from EMP where EMPNO = :ID</pre>'');',
'sys.htp.prn(''<br/><b>JSON</b><br/>'');',
'sys.htp.prn(''<pre>{"items":[{"empno":7839,"ename":"KING","job":"PRESIDENT","hiredate":"1981-11-17T08:00:00Z","sal":5000,"deptno":10}]}</pre>'');',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1553816020133253411.4851)
,p_plug_name=>'Probar'
,p_parent_plug_id=>wwv_flow_api.id(1423652610972187103.4851)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P9_ID is not null',
'and wwv_flow_listener.is_required_version',
'and :P9_METHOD = ''GET'''))
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Para probar el comportamiento del manejador de servicios RESTful, haga clic en el bot\00F3n Probar. Si el manejador de servicios de RESTful'),
unistr('    utiliza par\00E1metros, haga clic en el bot\00F3n Definir Variables de Enlace para definir valores de prueba para los par\00E1metros. Antes de probar,'),
unistr('    aseg\00FArese de que han guardado todos los cambios en esta p\00E1gina haciendo clic en Aplicar Cambios. Para obtener mejores resultados, aseg\00FArese de que'),
'    tiene un visor JSON instalado en el explorador.',
'</p>'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1430003820639430990.4851)
,p_plug_name=>'Region Display Selector'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719704379601942780.4851)
,p_plug_display_sequence=>15
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_translate_title=>'N'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1732541115320381853.4851)
,p_button_sequence=>260
,p_button_plug_id=>wwv_flow_api.id(1553816020133253411.4851)
,p_button_name=>'P9_TEST_BTN'
,p_button_static_id=>'P9_TEST_BTN'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Probar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'javascript:redirect(''&P9_TEST_URL.'');'
,p_button_execute_validations=>'N'
,p_button_cattributes=>'alt="Test Handler"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1733536230473105314.4851)
,p_button_sequence=>264
,p_button_plug_id=>wwv_flow_api.id(1553816020133253411.4851)
,p_button_name=>'P9_BIND_VARS'
,p_button_static_id=>'P9_BIND_VARS'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_button_image_alt=>'Definir Variables de Enlace'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_icon_css_classes=>'icon-right-chevron'
,p_button_cattributes=>'nowrap="nowrap"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1421556901688663938.4851)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(1421455001426645001.4851)
,p_button_name=>'CREATE_PARAMETER'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_button_image_alt=>unistr('Crear Par\00E1metro')
,p_button_position=>'REGION_TEMPLATE_HELP'
,p_button_redirect_url=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:12:P12_HANDLER_ID:&P9_ID.'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P9_ID is not null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(415718401230309089.4851)
,p_button_sequence=>11
,p_button_plug_id=>wwv_flow_api.id(417550318651558505.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::P11_ID:&P9_TEMPLATE_ID.'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(415718224764309088.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(417550318651558505.4851)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P9_ID is not null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(415718123163309088.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(417550318651558505.4851)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P9_ID is not null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(415718014389309088.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(417550318651558505.4851)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P9_ID is null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1747904716158829506.4851)
,p_branch_action=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.::P8_ID,P8_TEMPLATE_ID:&P9_ID.,&P9_TEMPLATE_ID.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(1733536230473105314.4851)
,p_branch_sequence=>1
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'P9_BIND_VARS'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1422108524638727404.4851)
,p_branch_action=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:12:P12_ID:&P9_HANDLER_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>5
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'UPDATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(415719030255309090.4851)
,p_branch_action=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::ACTIVE_NODE:&P10_ID.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'DELETE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1419956720632884447.4851)
,p_branch_action=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::ACTIVE_NODE:&P9_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>15
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(313203204327299052.4851)
,p_name=>'P9_MODULE_ID'
,p_item_sequence=>275
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(415719210986309091.4851)
,p_name=>'P9_ID'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(415719609228309098.4851)
,p_name=>'P9_TEMPLATE_ID'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_use_cache_before_default=>'NO'
,p_source=>'TEMPLATE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(415719826088309099.4851)
,p_name=>'P9_SOURCE_TYPE'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tipo de Origen'
,p_source=>'SOURCE_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'P9_HANDLER_SOURCE_TYPES'
,p_lov=>'.'||wwv_flow_api.id(793236521795289048.4851)||'.'
,p_lov_cascade_parent_items=>'P9_METHOD'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Define la implantaci\00F3n de origen para el m\00E9todo HTTP seleccionado. Las opciones incluyen:<p/>'),
'<ul>',
unistr('<li><b>Consulta</b>: ejecuta una consulta SQL y transforma el juego de resultados en una representaci\00F3n JSON (Notaci\00F3n de Objetos JavaScript) o CSV, seg\00FAn el formato seleccionado. Tenga en cuenta que esta opci\00F3n solo est\00E1 disponible si se ha seleccio')
||unistr('nado el m\00E9todo HTTP GET.</li>'),
unistr('<li><b>Consultar Una Fila</b>: ejecuta una consulta SQL que devuelve una fila de datos en una representaci\00F3n JSON. Tenga en cuenta que esta opci\00F3n solo est\00E1 disponible si se ha seleccionado el m\00E9todo HTTP GET.</li>'),
unistr('<li><b>PL/SQL</b>: ejecuta un bloque PL/SQL an\00F3nimo y transforma los par\00E1metros OUT o IN/OUT en una representaci\00F3n JSON. Tenga en cuenta que \00E9sta es la \00FAnica opci\00F3n disponible si el m\00E9todo HTTP seleccionado es uno de los siguientes: DELETE, PUT, POST')
||'.</li>',
unistr('<li><b>Fuente</b>: ejecuta una consulta SQL y transforma los resultados en una representaci\00F3n de fuente JSON. Cada elemento de la fuente contiene un resumen de un recurso y un hiperenlace a la representaci\00F3n completa del recurso. La primera columna d')
||unistr('e cada fila del juego de resultados debe ser un identificador \00FAnico para la fila y se debe utilizar para crear un hiperenlace con el siguiente formato: path/to/feed/{id}, en el que el valor de la primera columna se utilice como valor de {id}. Se supo')
||unistr('ne que las dem\00E1s columnas de la fila resumen el recurso y se incluyen en la fuente. Tambi\00E9n se debe definir una plantilla de recurso independiente para la representaci\00F3n completa del recurso.</li>'),
unistr('<li><b>Recurso de Medios</b>: ejecuta una consulta SQL que cumpla un formato concreto y que devuelva el juego de resultados en una representaci\00F3n binaria con una cabecera HTTP Content-Type que identifique el tipo de medio f\00EDsico de Internet de la rep')
||unistr('resentaci\00F3n. El formato de la consulta SQL debe ser:<p><i>SELECT ''content_type'', columna FROM . . .</i><br/><br/>'),
unistr('donde <i>''content_type''</i> es una cadena transferida al explorador para utilizarla en la identificaci\00F3n de los datos entrantes, por ejemplo <i>''image/jpeg''</i>, y <i>column</i> es el nombre de la columna que contiene el origen de los datos que se de')
||unistr('vuelven. El tipo Origen de Recursos de Medios normalmente se utiliza para los objetos de medios, como im\00E1genes, donde los datos los manejar\00E1 directamente el destinatario que realiza la llamada.</p>'),
'',
'</li>',
'',
'</ul>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(415720010022309099.4851)
,p_name=>'P9_FORMAT'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Formato'
,p_source=>'FORMAT'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'HANDLER_QUERY_FORMAT'
,p_lov=>'.'||wwv_flow_api.id(793264406688294176.4851)||'.'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Seleccione el formato que se va a utilizar para el juego de resultados.</p>',
'<p>Estas son las opciones disponibles:',
'<ul>',
unistr('    <li><strong>JSON</strong>: la salida se transforma en el formato de documento de notaci\00F3n de objetos de JavaScript</li>'),
unistr('    <li><strong>CSV</strong>: la salida se transforma en una representaci\00F3n de valores separada por comas</li>'),
'</ul>',
'',
'',
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(415720221233309099.4851)
,p_name=>'P9_METHOD'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_use_cache_before_default=>'NO'
,p_item_default=>'GET'
,p_prompt=>unistr('M\00E9todo')
,p_source=>'METHOD'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'HANDLER_METHODS'
,p_lov=>'.'||wwv_flow_api.id(793208615430277767.4851)||'.'
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Identifica el m\00E9todo HTTP que se utilizar\00E1 para el manejador de recursos. Las cuatro opciones son:<p/>'),
'<ul>',
unistr('<li><b>GET</b>: recupera una representaci\00F3n de un recurso</li>'),
'<li><b>DELETE</b>: suprime un recurso existente</li>',
unistr('<li><b>POST</b>: crea un nuevo recurso o agrega un recurso a una recopilaci\00F3n</li>'),
'<li><b>PUT</b>: actualiza un recurso existente</li>',
'</ul>',
unistr('<p>S\00F3lo se permite un manejador por m\00E9todo HTTP.</p>')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(415720400481309100.4851)
,p_name=>'P9_MIMES_ALLOWED'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tipos MIME Permitidos'
,p_source=>'MIMES_ALLOWED'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>90
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Lista de tipos MIME separados por comas permitidos en la solicitud HTTP.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(415720826157309101.4851)
,p_name=>'P9_ITEMS_PER_PAGE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Tama\00F1o de Paginaci\00F3n')
,p_source=>'ITEMS_PER_PAGE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>5
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Introduzca el tama\00F1o de la ventana de paginaci\00F3n.</p>'),
unistr('<p>La paginaci\00F3n del m\00E9todo GET de operaciones HTTP del manejador de recursos equivale al n\00FAmero de filas que se deben devolver en cada p\00E1gina de un juego de resultados de formato JSON basado en una consulta de la base de datos.</p>'),
unistr('<p>Nota: Se proporcionar\00E1n enlaces para obtener los juegos de registros anteriores y posteriores. Estos enlaces utilizan las variables <code>:row_offset</code> y <code>:row_count</code> del origen para implantar la paginaci\00F3n especificada.</p>')))
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(415721201271309101.4851)
,p_name=>'P9_SOURCE'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1423652610972187103.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Origen'
,p_source=>'SOURCE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.CODE_EDITOR'
,p_cSize=>70
,p_cMaxlength=>32767
,p_cHeight=>12
,p_field_template=>wwv_flow_api.id(719737671382952642.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica la consulta SQL o el bloque PL/SQL responsable del manejo del m\00E9todo HTTP seleccionado. Se pueden definir varios manejadores de recursos para una plantilla de recurso. Para definir manejadores adicionales, edite el m\00F3dulo de servicio RESTf')
||unistr('ul reci\00E9n creado.')
,p_attribute_01=>'DDL'
,p_attribute_02=>'VARCHAR2'
,p_attribute_03=>'Y'
,p_attribute_04=>'Y'
,p_item_comment=>'Mode has been set to DDL to disable the validation functionality. The reason is that the mode would have to be dynamic based on the "Source Type" of the Resource Handler and that''s currently not supported by the plug-in.'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(415807630613325449.4851)
,p_name=>'P9_MODULE'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('Identifica el m\00F3dulo de servicio RESTful seleccionado.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(827027518761754993.4851)
,p_name=>'P9_URI_PREFIX'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>'Identifica el prefijo de la plantilla de URI.'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(830884219537436467.4851)
,p_name=>'P9_URI_TEMPLATE'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>'Identifica la plantilla de URI.'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(832232305525546032.4851)
,p_name=>'P9_COMMENTS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1423464203260128067.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios'
,p_source=>'COMMENTS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>70
,p_cMaxlength=>4000
,p_cHeight=>3
,p_colspan=>2
,p_label_alignment=>'ABOVE'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(6683429755641072.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Introduzca comentarios opcionales.'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1422069832125720033.4851)
,p_name=>'P9_HANDLER_ID'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1433796730285856069.4851)
,p_name=>'P9_CONTEXT'
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('M\00F3dulo de Servicio RESTful:')
,p_source=>':P9_URI_PREFIX'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica el nombre del m\00F3dulo de servicio RESTful.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1488238422347387234.4851)
,p_name=>'P9_REQUIRES_HTTPS'
,p_item_sequence=>45
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_use_cache_before_default=>'NO'
,p_item_default=>'YES'
,p_prompt=>'Necesita Acceso Seguro'
,p_source=>'REQUIRE_HTTPS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'HANDLER_SECURE_ACCESS'
,p_lov=>'.'||wwv_flow_api.id(1488736008597865790.4851)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica si se debe acceder a los recursos a trav\00E9s de un canal seguro, por ejemplo, HTTPS. Defina esta opci\00F3n en <b>S\00ED</b> si es necesario un acceso seguro.<p/>')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1490230600257336469.4851)
,p_name=>'P9_CONTEXT2'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(417550318651558505.4851)
,p_use_cache_before_default=>'NO'
,p_source=>':P9_METHOD'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when=>'P9_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1490285926576344125.4851)
,p_name=>'P9_RESOURCE_TEMPLATE'
,p_item_sequence=>7
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Plantilla de URI:'
,p_source=>':P9_URI_TEMPLATE'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Identifica la plantilla de URI.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1579347520455738754.4851)
,p_name=>'P9_WS_DISPLAY_NAME'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(415717831389309088.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1581475214165982868.4851)
,p_name=>'P9_TEST_URL'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1553816020133253411.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(776271912777053047.4851)
,p_computation_sequence=>10
,p_computation_item=>'P9_MODULE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    r varchar2(500) := null;',
'begin',
'    if :P9_ID is not null then',
'        for c1 in (select name',
'                     from WWV_FLOW_RT$MODULES m',
'                    where id = (select module_id',
'                                  from wwv_flow_rt$templates t',
'                                 where t.id = (select max(nvl(template_id , 0 )) x',
'                                                 from WWV_FLOW_RT$HANDLERS H',
'                                                where ID = :P9_ID',
'                                                  and security_group_id = :FLOW_SECURITY_GROUP_ID',
'                                               )',
'                               )',
'                  )',
'        loop',
'            r := c1.name;',
'        end loop;',
'    else',
'        for c1 in (select name',
'                     from WWV_FLOW_RT$MODULES m',
'                    where id = (select module_id',
'                                  from wwv_flow_rt$templates t',
'                                 where id = :P9_TEMPLATE_ID',
'                                   and security_group_id = :FLOW_SECURITY_GROUP_ID',
'                               )',
'                  )',
'        loop',
'           r := c1.name;',
'        end loop;',
'    end if;',
'    return r;',
'end;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1482723122262525332.4851)
,p_computation_sequence=>10
,p_computation_item=>'P9_TEMPLATE_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select template_id from wwv_flow_rt$handlers',
'where id = :P9_ID',
'and security_group_id = :flow_security_group_id'))
,p_compute_when=>'P9_TEMPLATE_ID'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1579374101886742786.4851)
,p_computation_sequence=>10
,p_computation_item=>'P9_WS_DISPLAY_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>'select display_name from wwv_flow_companies where provisioning_company_id = :flow_security_group_id'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(827061405040760464.4851)
,p_computation_sequence=>20
,p_computation_item=>'P9_URI_PREFIX'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   r varchar2(500) := null;',
'begin',
'if :P9_ID is not null then',
'    for c1 in (',
'    select uri_prefix ',
'    from WWV_FLOW_RT$MODULES m',
'    where  ',
'              id = (',
'    select module_id ',
'    from wwv_flow_rt$templates t ',
'    where  t.id = (',
'    select max(nvl(template_id , 0 )) x',
'    from WWV_FLOW_RT$HANDLERS H',
'    where ID = :P9_ID and security_group_id = :FLOW_SECURITY_GROUP_ID',
'    )',
'    )',
'    ) loop',
'        r := c1.uri_prefix;',
'    end loop;',
'else',
'    for c1 in (',
'    select uri_prefix ',
'    from WWV_FLOW_RT$MODULES m',
'    where  ',
'              id = (',
'    select module_id ',
'    from wwv_flow_rt$templates t ',
'    where id = :P9_TEMPLATE_ID and security_group_id = :FLOW_SECURITY_GROUP_ID)) loop',
'       r := c1.uri_prefix;',
'    end loop;',
'end if;',
'return r;',
'end;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(830907727848438834.4851)
,p_computation_sequence=>30
,p_computation_item=>'P9_URI_TEMPLATE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   r varchar2(500) := null;',
'begin',
'if :P9_ID is not null then',
'    for c1 in (',
'    select uri_template',
'    from wwv_flow_rt$templates t ',
'    where  t.id = (',
'    select max(nvl(template_id , 0 )) x',
'    from WWV_FLOW_RT$HANDLERS H',
'    where ID = :P9_ID and security_group_id = :FLOW_SECURITY_GROUP_ID',
'    )',
'    ) loop',
'        r := c1.uri_template;',
'    end loop;',
'else',
'    for c1 in (',
'    select uri_template ',
'    from wwv_flow_rt$templates t ',
'    where id = :P9_TEMPLATE_ID and security_group_id = :FLOW_SECURITY_GROUP_ID) loop',
'       r := c1.uri_template;',
'    end loop;',
'end if;',
'return r;',
'end;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(17155305412903044.4851)
,p_computation_sequence=>35
,p_computation_item=>'P9_REQUIRES_HTTPS'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select require_https from wwv_flow_rt$handlers',
'where id = :P9_ID',
'and template_id = :P9_TEMPLATE_ID',
'and security_group_id = :flow_security_group_id'))
,p_compute_when=>'P9_TEMPLATE_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1582267716907106725.4851)
,p_computation_sequence=>40
,p_computation_item=>'P9_TEST_URL'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_path_prefix  varchar2(255);',
'    l_url          varchar2(4000);',
'begin',
'',
'    -- Obtain path prefix',
'    if not wwv_flow_global.g_cloud then',
'        for c1 in (select path_prefix',
'                     from wwv_flow_companies',
'                    where provisioning_company_id = wwv_flow_security.g_security_group_id)',
'        loop',
'          if c1.path_prefix is not null then',
'              l_path_prefix := lower(c1.path_prefix)|| ''/'';',
'          end if;',
'          exit;',
'        end loop;',
'    end if;',
'',
'    l_url := wwv_flow_utilities.host_url( p_option => ''SCRIPT'' );',
'',
'    ',
'    if v(''P9_REQUIRES_HTTPS'') = ''YES'' then',
'        l_url := replace( l_url, ''http://'', ''https://'');',
'    end if;',
'    ',
'    --',
'    -- Account for the case if SERVER_PORT is not properly set.  In Oracle REST Data Services 2.0 and greater,',
'    -- HTTP_HOST will not contain port # if not the default for the given protocol.',
'    --',
'    if instr(sys.owa_util.get_cgi_env(''HTTP_HOST''),'':'') = 0 then',
'        l_url := replace( l_url, '':443/'', ''/'');',
'        l_url := replace( l_url, '':80/'', ''/'');',
'    end if;',
'    ',
'    l_url := l_url || l_path_prefix || :P9_URI_PREFIX || :P9_URI_TEMPLATE;    ',
'',
'    return l_url;',
'',
'end;',
''))
,p_computation_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Original code, which may change:',
'declare',
'  l_port     varchar2(10);',
'  l_url      varchar2(4000);',
'begin',
'  if v(''P9_REQUIRES_HTTPS'') = ''YES'' then',
'      l_port := sys.owa_util.get_cgi_env(''SERVER_PORT'');',
'',
'      if l_port not in (80,443) then ',
'          l_url := ''http://''||sys.owa_util.get_cgi_env(''HTTP_HOST'')||sys.owa_util.get_cgi_env(''SCRIPT_NAME'') ||''/''||:P9_URI_PREFIX||:P9_URI_TEMPLATE;',
'',
'      else',
'          l_url := ''https://''||replace(sys.owa_util.get_cgi_env(''HTTP_HOST''),'':''||l_port)||sys.owa_util.get_cgi_env(''SCRIPT_NAME'') ||''/''||:P9_URI_PREFIX||:P9_URI_TEMPLATE;',
'',
'      end if;',
'',
'  else',
'      l_url := ''http://''||sys.owa_util.get_cgi_env(''HTTP_HOST'')||sys.owa_util.get_cgi_env(''SCRIPT_NAME'') ||''/''||:P9_URI_PREFIX||:P9_URI_TEMPLATE;',
'',
'  end if;',
'',
'  return l_url;',
'',
'end;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(313203509275312014.4851)
,p_computation_sequence=>60
,p_computation_item=>'P9_MODULE_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select module_id ',
'from wwv_flow_rt$templates t ',
'where id = :P9_TEMPLATE_ID ',
'and security_group_id = :FLOW_SECURITY_GROUP_ID'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1466521523382744169.4851)
,p_validation_name=>'Cannot have multiple Methods of the same type'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'  for c1 in (select 1 from wwv_flow_rt$handlers',
'              where method = :P9_METHOD',
'                and template_id = :P9_TEMPLATE_ID',
'                and security_group_id = :flow_security_group_id)',
'  loop',
'      return false;',
'  end loop;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Ya hay un m\00E9todo &P9_METHOD. definido para la plantilla de recurso &P9_URI_TEMPLATE. Debe seleccionar un nuevo m\00E9todo.')
,p_when_button_pressed=>wwv_flow_api.id(415718014389309088.4851)
,p_associated_item=>wwv_flow_api.id(415720221233309099.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(793353017339316137.4851)
,p_name=>'Query_Format'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P9_SOURCE_TYPE'
,p_condition_element=>'P9_SOURCE_TYPE'
,p_triggering_condition_type=>'IN_LIST'
,p_triggering_expression=>'QUERY'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(793353307921316139.4851)
,p_event_id=>wwv_flow_api.id(793353017339316137.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P9_FORMAT'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(793353520357316140.4851)
,p_event_id=>wwv_flow_api.id(793353017339316137.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P9_FORMAT'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1421591224890670728.4851)
,p_name=>'Mime Type Allowed - Visibility'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P9_METHOD'
,p_condition_element=>'P9_METHOD'
,p_triggering_condition_type=>'IN_LIST'
,p_triggering_expression=>'POST,PUT'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1421591523478670730.4851)
,p_event_id=>wwv_flow_api.id(1421591224890670728.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P9_MIMES_ALLOWED'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1421591708671670730.4851)
,p_event_id=>wwv_flow_api.id(1421591224890670728.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P9_MIMES_ALLOWED'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1421633313593676856.4851)
,p_name=>'Pagination Size - Visibility'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P9_METHOD'
,p_condition_element=>'P9_METHOD'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'GET'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1421633610107676857.4851)
,p_event_id=>wwv_flow_api.id(1421633313593676856.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P9_ITEMS_PER_PAGE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1421633826127676857.4851)
,p_event_id=>wwv_flow_api.id(1421633313593676856.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P9_ITEMS_PER_PAGE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1441044614727196819.4851)
,p_name=>'Parameters Region Visibility'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P9_ID'
,p_condition_element=>'P9_ID'
,p_triggering_condition_type=>'NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1441044907662196820.4851)
,p_event_id=>wwv_flow_api.id(1441044614727196819.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(1421455001426645001.4851)
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1441045128148196820.4851)
,p_event_id=>wwv_flow_api.id(1441044614727196819.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(1421455001426645001.4851)
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1553853809528259751.4851)
,p_name=>'Test Link Visibility'
,p_event_sequence=>50
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P9_METHOD'
,p_condition_element=>'P9_METHOD'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'GET'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1553854110562259753.4851)
,p_event_id=>wwv_flow_api.id(1553853809528259751.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P9_XXX'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1553854315143259753.4851)
,p_event_id=>wwv_flow_api.id(1553853809528259751.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P9_XXX'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(415721708151309102.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_RT$HANDLERS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$HANDLERS'
,p_attribute_03=>'P9_ID'
,p_attribute_04=>'ID'
,p_attribute_05=>'P9_TEMPLATE_ID'
,p_attribute_06=>'TEMPLATE_ID'
,p_attribute_09=>'P9_ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('Acci\00F3n Procesada.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1747633016672791821.4851)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Source Value in Session'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'apex_util.set_session_state(p_name  => ''P9_SOURCE'',',
'                            p_value => v(''P9_SOURCE''));',
'',
'apex_util.set_session_state(p_name  => ''P9_URI_TEMPLATE'',',
'                            p_value => v(''P9_URI_TEMPLATE''));',
'',
'apex_util.set_session_state(p_name  => ''P9_URI_PREFIX'',',
'                            p_value => v(''P9_URI_PREFIX''));',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1733536230473105314.4851)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1737996921785343966.4851)
,p_process_sequence=>35
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Binds Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if htmldb_collection.collection_exists(''SET_BINDS'') then',
'    htmldb_collection.delete_collection(''SET_BINDS'');',
'end if;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1733536230473105314.4851)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1758495531925339285.4851)
,p_process_sequence=>37
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Test URL'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_path_prefix  varchar2(255);',
'    l_test_url     varchar2(4000);',
'begin',
'',
'    -- Obtain path prefix',
'    if not wwv_flow_global.g_cloud then',
'        for c1 in (select path_prefix',
'                     from wwv_flow_companies',
'                    where provisioning_company_id = wwv_flow_security.g_security_group_id)',
'        loop',
'          if c1.path_prefix is not null then',
'              l_path_prefix := lower(c1.path_prefix)|| ''/'';',
'          end if;',
'          exit;',
'        end loop;',
'    end if;',
'',
'    l_test_url := wwv_flow_utilities.host_url( p_option => ''SCRIPT'' );',
'    ',
'    if v(''P9_REQUIRES_HTTPS'') = ''YES'' then',
'        l_test_url := replace( l_test_url, ''http://'', ''https://'');',
'    end if;',
'',
'    --',
'    -- Account for the case if SERVER_PORT is not properly set.  In Oracle REST Data Services 2.0 and greater,',
'    -- HTTP_HOST will not contain port # if not the default for the given protocol.',
'    --    ',
'    if instr(sys.owa_util.get_cgi_env(''HTTP_HOST''),'':'') = 0 then',
'        l_test_url := replace( l_test_url, '':443/'', ''/'');',
'        l_test_url := replace( l_test_url, '':80/'', ''/'');',
'    end if;',
'        ',
'    l_test_url := l_test_url || l_path_prefix || :P9_URI_PREFIX || :P9_URI_TEMPLATE;',
'',
'    :P8_TEST_URL := l_test_url;',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1733536230473105314.4851)
,p_process_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_protocol  varchar2(10);',
'    l_port      varchar2(10);',
'    l_test_url  varchar2(4000);',
'begin',
'',
'    if v(''P9_REQUIRES_HTTPS'') = ''YES'' then',
'',
'        l_port := sys.owa_util.get_cgi_env(''SERVER_PORT'');',
'        if l_port not in (80,443) then',
'            l_test_url := ''http://''||sys.owa_util.get_cgi_env(''HTTP_HOST'')||sys.owa_util.get_cgi_env(''SCRIPT_NAME'') ||''/''||:P9_URI_PREFIX||:P9_URI_TEMPLATE;',
'        else',
'            l_test_url := ''http://''||replace(sys.owa_util.get_cgi_env(''HTTP_HOST''),'':''||l_port)||sys.owa_util.get_cgi_env(''SCRIPT_NAME'') ||''/''||:P9_URI_PREFIX||:P9_URI_TEMPLATE;',
'        end if;',
'    else',
'        l_test_url := ''http://''||sys.owa_util.get_cgi_env(''HTTP_HOST'')||sys.owa_util.get_cgi_env(''SCRIPT_NAME'') ||''/''||:P9_URI_PREFIX||:P9_URI_TEMPLATE;',
'    end if;',
'',
'    :P8_TEST_URL := l_test_url;',
'',
'end;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(415721927341309102.4851)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'9'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(415718224764309088.4851)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(415721528225309102.4851)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_RT$HANDLERS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$HANDLERS'
,p_attribute_03=>'P9_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
);
end;
/
prompt --application/pages/page_00010
begin
wwv_flow_api.create_page(
 p_id=>10.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>unistr('M\00F3dulo de Servicio RESTful')
,p_step_title=>unistr('M\00F3dulo de Servicio RESTful')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(754939123056928433.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(315391922639249269.4851)
,p_plug_name=>unistr('M\00F3dulo de Servicio RESTful')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--hideHeader'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_read_only_when_type=>'PLSQL_EXPRESSION'
,p_plug_read_only_when=>'apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')'
,p_plug_header=>unistr('<p>Un m\00F3dulo de servicio RESTful es una agrupaci\00F3n de plantillas comunes con un prefijo URI com\00FAn. Este prefijo se antepone a todas las plantillas.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(315442028856253198.4851)
,p_plug_name=>unistr('M\00F3dulo RESTful: &P10_CONTEXT.')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder:a-ButtonRegion--showTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1508093406935757443.4851)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'a-Region--stacked:a-Region--noPadding:a-Region--sideRegion:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(315392526204249272.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(315442028856253198.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(315392306728249271.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(315442028856253198.4851)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P10_ID is not null) ',
'   -- and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) ',
'THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(315392227681249271.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(315442028856253198.4851)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P10_ID is not null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(315393403045249276.4851)
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(315392306728249271.4851)
,p_branch_sequence=>1
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1417582023322935236.4851)
,p_branch_action=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(315393611151249279.4851)
,p_name=>'P10_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(315391922639249269.4851)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(315394002929249292.4851)
,p_name=>'P10_NAME'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(315391922639249269.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nombre'
,p_source=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>64
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica el nombre del m\00F3dulo de servicio RESTful. Utilice m\00F3dulos para agrupar las plantillas de URI.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(315394224459249293.4851)
,p_name=>'P10_URI_PREFIX'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(315391922639249269.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Prefijo de URI'
,p_source=>'URI_PREFIX'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>64
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Identifica el prefijo de la plantilla URI. El prefijo es la base del URI que se utiliza para acceder a este servicio RESTful.</p>',
unistr('<p>Por ejemplo, <strong>hr/</strong> significa que este m\00F3dulo de recursos atender\00E1 a todos los URI que comiencen por hr/.')))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(315394401252249293.4851)
,p_name=>'P10_ORIGINS_ALLOWED'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(315391922639249269.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Or\00EDgenes Permitidos')
,p_source=>'ORIGINS_ALLOWED'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>64
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Lista separada por comas de or\00EDgenes que tienen permitido el acceso a la plantilla de recursos</p>'),
'<p>Por ejemplo:<br>',
'http://example1.org,https://*.example2.com',
'</p>'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(315394601423249294.4851)
,p_name=>'P10_ITEMS_PER_PAGE'
,p_is_required=>true
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(315391922639249269.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Tama\00F1o de Paginaci\00F3n')
,p_source=>'ITEMS_PER_PAGE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>5
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Introduzca el tama\00F1o de la ventana de paginaci\00F3n.</p>'),
unistr('<p>La paginaci\00F3n del m\00E9todo GET de operaciones HTTP del manejador de recursos equivale al n\00FAmero de filas que se deben devolver en cada p\00E1gina de un juego de resultados de formato JSON basado en una consulta de la base de datos.</p>'),
unistr('<p>Nota: Se proporcionar\00E1n enlaces para obtener los juegos de registros anteriores y posteriores. Estos enlaces utilizan las variables <code>:row_offset</code> y <code>:row_count</code> del origen para implantar la paginaci\00F3n especificada.</p>')))
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(315394822820249295.4851)
,p_name=>'P10_STATUS'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(315391922639249269.4851)
,p_use_cache_before_default=>'NO'
,p_item_default=>'PUBLISHED'
,p_prompt=>'Estado'
,p_source=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PUBLISHED NOT PUBLISHED'
,p_lov=>'.'||wwv_flow_api.id(316762018242533973.4851)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Los m\00F3dulos de servicios RESTful publicados se pueden utilizar, los no publicados no.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1434359723247996035.4851)
,p_name=>'P10_CONTEXT'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(315442028856253198.4851)
,p_use_cache_before_default=>'NO'
,p_source=>'P10_NAME'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1481151617573060319.4851)
,p_name=>'P10_PRIVILEGE'
,p_item_sequence=>55
,p_item_plug_id=>wwv_flow_api.id(315391922639249269.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Privilegio Necesario'
,p_source=>'PRIVILEGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PRIVILEGES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select label d, id r',
'  from wwv_flow_rt$privileges',
' where security_group_id = :flow_security_group_id',
' order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Asignar Privilegio - '
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Seleccione el privilegio de usuario que se necesita para acceder a este m\00F3dulo de servicio RESTful.</p>'),
unistr('<p>Si un usuario no tiene el privilegio necesario, se recibir\00E1 un mensaje <code>401 No Autorizado</code> al intentar acceder al m\00F3dulo de servicio.</p>')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1508154331176764410.4851)
,p_name=>'P10_COMMENTS'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(1508093406935757443.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios'
,p_source=>'COMMENTS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>3
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Introduzca comentarios opcionales.'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1405176819617701319.4851)
,p_name=>'Handler - Source Type'
,p_event_sequence=>60
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P10_SOURCE_TYPE'
,p_condition_element=>'P10_SOURCE_TYPE'
,p_triggering_condition_type=>'IN_LIST'
,p_triggering_expression=>'QUERY'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1410286913587782850.4851)
,p_name=>'Template - Etag Type'
,p_event_sequence=>70
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P10_ETAG_TYPE'
,p_condition_element=>'P10_ETAG_TYPE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'QUERY'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1411621224761543103.4851)
,p_name=>'Mime Type Allowed - Visibility'
,p_event_sequence=>80
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P10_METHOD'
,p_condition_element=>'P10_METHOD'
,p_triggering_condition_type=>'IN_LIST'
,p_triggering_expression=>'POST,PUT'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1412467600668397192.4851)
,p_name=>'GET Method Settings'
,p_event_sequence=>90
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P10_METHOD'
,p_condition_element=>'P10_METHOD'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'GET'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(315395124185249296.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_RT$MODULES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$MODULES'
,p_attribute_03=>'P10_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(315395301314249297.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_RT$MODULES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$MODULES'
,p_attribute_03=>'P10_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P10_NODE_TYPE'
,p_process_when2=>'M'
,p_process_success_message=>unistr('Acci\00F3n Procesada.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(315395519441249297.4851)
,p_process_sequence=>80
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'10'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(315392306728249271.4851)
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_api.create_page(
 p_id=>11.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Plantilla de Recurso'
,p_step_title=>'Plantilla de Recurso'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(754939123056928433.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(413821013331010603.4851)
,p_plug_name=>'Plantilla de Recurso'
,p_region_template_options=>'a-Region--noPadding:a-Region--sideRegion:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_read_only_when_type=>'PLSQL_EXPRESSION'
,p_plug_read_only_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(414725128124144902.4851)
,p_plug_name=>'Plantilla de URI: &P11_CONTEXT2.'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder:a-ButtonRegion--showTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(431495829658724106.4851)
,p_plug_name=>'Acerca de'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Una plantilla de recurso es un archivo de configuraci\00F3n que enlaza un juego de URI (Identificadores de Recursos Uniformes) con una consulta SQL o un bloque PL/SQL an\00F3nimo. El juego de URI se identifica mediante una plantilla de URI. Una plantilla ')
||'de URI es una sintaxis sencilla que describe los URI; por ejemplo:</p>',
'<p/>',
'people/{userid}',
'</p><p>',
unistr('La plantilla de URI puede contener varios par\00E1metros o ninguno (por ejemplo, {userid}) que, junto a las cabeceras HTTP, se env\00EDan con una solicitud HTTP.'),
'</p>',
''))
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1507986129051735426.4851)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(413821618027010604.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(414725128124144902.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::P10_ID:&P10_ID.'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(413821407871010604.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(414725128124144902.4851)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P11_ID is not null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(413821307050010604.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(414725128124144902.4851)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P11_ID is not null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(413821217315010604.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(414725128124144902.4851)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P11_ID is null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1765902015675679728.4851)
,p_branch_action=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::ACTIVE_NODE:&P10_ID.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(413821407871010604.4851)
,p_branch_sequence=>1
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(413822212647010605.4851)
,p_branch_action=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::ACTIVE_NODE:&P11_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413822407340010606.4851)
,p_name=>'P11_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(413821013331010603.4851)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413822815255010608.4851)
,p_name=>'P11_MODULE_ID'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(413821013331010603.4851)
,p_use_cache_before_default=>'NO'
,p_source=>'MODULE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('Identifica el m\00F3dulo de servicio RESTful seleccionado.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413823027195010608.4851)
,p_name=>'P11_URI_TEMPLATE'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(413821013331010603.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Plantilla de URI'
,p_source=>'URI_TEMPLATE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>84
,p_cMaxlength=>600
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Introduzca la plantilla de URI para identificar los URI (Identificadores de Recursos Uniformes). Una plantilla de URI es una sintaxis sencilla que describe los URI (por ejemplo, <b>example/get/{id}</b>).<p> La plantilla de URI puede contener varios p'
||unistr('ar\00E1metros o ninguno (por ejemplo, <b>{id}</b>) que pueden estar enlazados a par\00E1metros de una consulta SQL o un bloque PL/SQL an\00F3nimo. Se aplican las siguientes reglas gramaticales:</p>'),
'<ul>',
unistr('<li>Las plantillas de URI no deben empezar por un car\00E1cter de barra inclinada (/).</li>'),
unistr('<li>Las plantillas de URI pueden contender cualquier car\00E1cter Unicode.</li>'),
unistr('<li>Los par\00E1metros se declaran mediante corchetes angulares ({}).</li>'),
unistr('<li>Los nombres de par\00E1metros deben empezar con un car\00E1cter alfanum\00E9rico seguido de ninguno o varios caracteres alfanum\00E9ricos y los caracteres: subrayado(_) o gui\00F3n (-).</li>'),
unistr('<li>No hay soporte para los par\00E1metros de opci\00F3n.</li>'),
'</ul>'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413823206696010608.4851)
,p_name=>'P11_PRIORITY'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(413821013331010603.4851)
,p_use_cache_before_default=>'NO'
,p_item_default=>'0'
,p_prompt=>'Prioridad'
,p_source=>'PRIORITY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ZERO THROUGH 9'
,p_lov=>'.'||wwv_flow_api.id(792033515275240381.4851)||'.'
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica el orden de evaluaci\00F3n de las plantillas. Los n\00FAmeros m\00E1s altos se eval\00FAan primero. Por ejemplo, si coinciden dos plantillas, se seleccionar\00E1 la que tiene prioridad 9 sobre la que tiene prioridad 0. ')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413823424646010609.4851)
,p_name=>'P11_ETAG_TYPE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(413821013331010603.4851)
,p_use_cache_before_default=>'NO'
,p_item_default=>'HASH'
,p_prompt=>'Etiqueta de Entidad'
,p_source=>'ETAG_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ETAG_TYPES'
,p_lov=>'.'||wwv_flow_api.id(792100407834275994.4851)||'.'
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Identifica el tipo de etiqueta de entidad que utilizar\00E1 la plantilla de recurso. Una etiqueta de entidad es una cabecera HTTP que act\00FAa como identificador de versi\00F3n de un recurso. Utilice cabeceras de etiqueta de entidad para evitar la recuperaci\00F3n ')
||'de recursos recuperados previamente y realizar un bloqueo optimista al actualizar los recursos. Las opciones incluyen:<p/>',
'<ul>',
unistr('<li><b>HASH Seguro</b>: al contenido de la representaci\00F3n de recursos devuelta se le aplicar\00E1 un valor hash mediante una funci\00F3n de resumen segura para proporcionar una huella \00FAnica para una determinada versi\00F3n del recurso.</li>'),
unistr('<li><b>Consulta</b>: define una consulta que identifique de forma \00FAnica una versi\00F3n de recurso. Una consulta definida manualmente a menudo genera una etiqueta de entidad de forma m\00E1s eficaz que con la aplicaci\00F3n de un valor hash a toda la representac')
||unistr('i\00F3n de recursos.</li>'),
'<li><b>Ninguna</b>: no genera ninguna etiqueta de entidad.</li>',
'</ul>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413823622365010609.4851)
,p_name=>'P11_ETAG_QUERY'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(413821013331010603.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Consulta de Etiqueta de Entidad'
,p_source=>'ETAG_QUERY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>10
,p_label_alignment=>'RIGHT-TOP'
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Sentencia SQL SELECT que devuelve una fila que se utilizar\00E1 para generar una etiqueta de entidad personalizada. El resultado de la sentencia SELET debe identificar de forma \00FAnica cada versi\00F3n del recurso. Por ejemplo,<p/>'),
'',
'<i>select updated_on, updated_by from my_table where id = :id</i>'))
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(829420818133284650.4851)
,p_name=>'P11_COMMENTS'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(1507986129051735426.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios'
,p_source=>'COMMENTS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>3
,p_label_alignment=>'ABOVE'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Introduzca comentarios opcionales.'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(830528716373407135.4851)
,p_name=>'P11_URI_PREFIX'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(413821013331010603.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>'Identifica el prefijo de la plantilla de URI.'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1434018604537914883.4851)
,p_name=>'P11_MODULE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(413821013331010603.4851)
,p_prompt=>unistr('M\00F3dulo de Servicio RESTful:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica el nombre del m\00F3dulo de servicio RESTful.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1434238826878959234.4851)
,p_name=>'P11_MODULE'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(413821013331010603.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('Identifica el m\00F3dulo de servicio RESTful seleccionado.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1489941516571293940.4851)
,p_name=>'P11_CONTEXT2'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(414725128124144902.4851)
,p_use_cache_before_default=>'NO'
,p_source=>':P11_URI_TEMPLATE'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when=>'P11_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(831111718067455020.4851)
,p_computation_sequence=>10
,p_computation_item=>'P11_URI_PREFIX'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   r varchar2(500) := null;',
'begin',
'if :P11_ID is not null then',
'    for c1 in ( select uri_prefix',
'                  from WWV_FLOW_RT$MODULES m',
'                 where ID = (select module_id ',
'                               from wwv_flow_rt$templates ',
'                              where id = :P11_ID ',
'                                and security_group_id = :FLOW_SECURITY_GROUP_ID)',
'    ) loop',
'        r := c1.uri_prefix;',
'    end loop;',
'else',
'    for c2 in (',
'        select uri_prefix ',
'        from WWV_FLOW_RT$MODULES m',
'        where id = :P11_MODULE_ID)',
'    loop',
'       r := c2.uri_prefix;',
'    end loop;',
'end if;',
'return r;',
'end;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1434254332419960854.4851)
,p_computation_sequence=>40
,p_computation_item=>'P11_MODULE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    r varchar2(500) := null;',
'begin',
'',
'if :P11_ID is not null then',
'    for c1 in (select name',
'                 from WWV_FLOW_RT$MODULES m',
'                where id = (select module_id',
'                              from wwv_flow_rt$templates t',
'                             where t.id = :P11_ID',
'                           )',
'              )',
'    loop',
'        r := c1.name;',
'    end loop;',
'else',
'for c2 in (',
'        select name ',
'        from WWV_FLOW_RT$MODULES m',
'        where id = :P11_MODULE_ID)',
'    loop',
'       r := c2.name;',
'    end loop;',
'end if;',
'return r;',
'end;'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1440907827148172058.4851)
,p_validation_name=>'ETAG Query Must Be Specified'
,p_validation_sequence=>10
,p_validation=>'P11_ETAG_QUERY'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('#LABEL# debe tener alg\00FAn valor.')
,p_validation_condition=>'P11_ETAG_TYPE'
,p_validation_condition2=>'QUERY'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_when_button_pressed=>wwv_flow_api.id(413821307050010604.4851)
,p_associated_item=>wwv_flow_api.id(413823622365010609.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(2544541829696681480.4851)
,p_validation_name=>'Validate URI Template'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_listener.is_valid_template(p_template=> :P11_URI_TEMPLATE) then',
'  return true;',
'else',
'  return false;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Las plantillas de URI no pueden contener nombres de par\00E1metro con una longitud superior a los 100 caracteres y los par\00E1metros deben cumplir con el siguiente patr\00F3n:'),
'<br/><br/>',
unistr('Una llave ''{'' seguida de un car\00E1cter alfab\00E9tico, a continuaci\00F3n, hasta 99 caracteres alfanum\00E9ricos o los caracteres especiales _, - o . y terminado con una llave de cierre ''}''. ')))
,p_validation_condition=>'P11_URI_TEMPLATE'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(413821307050010604.4851)
,p_associated_item=>wwv_flow_api.id(413823027195010608.4851)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(792175609959305079.4851)
,p_name=>'Show/Hide Query'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P11_ETAG_TYPE'
,p_condition_element=>'P11_ETAG_TYPE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'QUERY'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(792175913603305081.4851)
,p_event_id=>wwv_flow_api.id(792175609959305079.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P11_ETAG_QUERY'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(792176122098305081.4851)
,p_event_id=>wwv_flow_api.id(792175609959305079.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P11_ETAG_QUERY'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(413823918098010610.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_RT$TEMPLATES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$TEMPLATES'
,p_attribute_03=>'P11_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(413824123123010610.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_RT$TEMPLATES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$TEMPLATES'
,p_attribute_03=>'P11_ID'
,p_attribute_04=>'ID'
,p_attribute_09=>'P11_ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('Acci\00F3n Procesada.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(413824304724010610.4851)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'11'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(413821407871010604.4851)
);
end;
/
prompt --application/pages/page_00012
begin
wwv_flow_api.create_page(
 p_id=>12.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>unistr('Par\00E1metro de Manejador de Recursos')
,p_step_title=>unistr('Par\00E1metro de Manejador de Recursos')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(754939123056928433.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(413926308446017538.4851)
,p_plug_name=>unistr('Par\00E1metro de Manejador de Recursos')
,p_region_template_options=>'a-Region--flush:a-Region--noPadding:a-Region--sideRegion:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_read_only_when_type=>'PLSQL_EXPRESSION'
,p_plug_read_only_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')',
''))
,p_plug_header=>unistr('<p>Los par\00E1metros de un manejador de recurso tambi\00E9n pueden definirse manualmente para enlazar las cabeceras HTTP al manejador de recurso o para difundir un par\00E1metro de plantilla de URI a un tipo de dato espec\00EDfico. Por ejemplo, es posible que un ma')
||unistr('nejador de recurso deba conocer el valor de la cabecera HTTP Aceptar: Idioma para localizar la representaci\00F3n generada.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(415049901982175222.4851)
,p_plug_name=>'Button Bar'
,p_region_css_classes=>'a-Region--noTopBorder'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1508409614825854375.4851)
,p_plug_name=>'Comentarios'
,p_region_template_options=>'a-Region--flush:a-Region--noPadding:a-Region--sideRegion:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>25
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(413926920108017540.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(415049901982175222.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(413926722356017540.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(415049901982175222.4851)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P12_ID is not null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) ',
'THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(413926615195017540.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(415049901982175222.4851)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'IF (:P10_ID is not null) and (not apex_authorization.is_authorized(''ORDS_ACCESS_ALLOWED'')) THEN',
'   RETURN TRUE;',
'ELSE ',
'   RETURN FALSE;',
'END IF;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(413926522912017540.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(415049901982175222.4851)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P12_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(413927527643017541.4851)
,p_branch_action=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413927701266017542.4851)
,p_name=>'P12_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413928128947017543.4851)
,p_name=>'P12_NAME'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nombre de Variable de Enlace'
,p_source=>'BIND_VARIABLE_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>100
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica el nombre de la variable de enlace del par\00E1metro utilizado en SQL o PL/SQL.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413928317224017543.4851)
,p_name=>'P12_ALIAS'
,p_is_required=>true
,p_item_sequence=>55
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nombre'
,p_source=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>100
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica el nombre del par\00E1metro.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413928502228017544.4851)
,p_name=>'P12_SOURCE_TYPE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tipo de Origen'
,p_source=>'SOURCE_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PARAMETER_SOURCE'
,p_lov=>'.'||wwv_flow_api.id(793403203749331167.4851)||'.'
,p_lov_cascade_parent_items=>'P12_ACCESS_METHOD'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica el tipo de origen del par\00E1metro.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413928713436017544.4851)
,p_name=>'P12_ACCESS_METHOD'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('M\00E9todo de Acceso')
,p_source=>'ACCESS_METHOD'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PARAMETER_ACCESS'
,p_lov=>'.'||wwv_flow_api.id(793423420718336071.4851)||'.'
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Identifique el m\00E9todo HTTP com\00FAn. Las opciones incluyen <b>IN</b>, <b>IN/OUT</b> o <b>OUT</b>. Los par\00E1metros de plantilla de URI s\00F3lo pueden ser IN. El valor IN para un par\00E1metro de cabecera implica que la cabecera estar\00E1 presente en la solicitud HT')
||unistr('TP. El valor IN/OUT indica que el valor estar\00E1 presente tanto en la solicitud como en la respuesta HTTP. El valor OUT indica que el calor s\00F3lo estar\00E1 presente'),
'en la respuesta HTTP.'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413928914548017544.4851)
,p_name=>'P12_PARAM_TYPE'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Tipo de Par\00E1metro')
,p_source=>'PARAM_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PARAMETER_TYPE'
,p_lov=>'.'||wwv_flow_api.id(793443816001344104.4851)||'.'
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica el tipo de dato del par\00E1metro.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(413929115668017544.4851)
,p_name=>'P12_HANDLER_ID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_use_cache_before_default=>'NO'
,p_source=>'HANDLER_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>'Manejador seleccionado.'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(831503412835500777.4851)
,p_name=>'P12_MODULE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('Identifica el m\00F3dulo de servicio RESTful seleccionado.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(831574923225503795.4851)
,p_name=>'P12_URI_PREFIX'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>'Identifica el prefijo de la plantilla de URI.'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(831706424395513558.4851)
,p_name=>'P12_URI_TEMPLATE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>'Identifica la plantilla de URI.'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(831938624872523179.4851)
,p_name=>'P12_TEMPLATE_SOURCE'
,p_item_sequence=>54
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_prompt=>'Origen del Manejador'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>6
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_css_classes=>'fielddatabold'
,p_label_alignment=>'RIGHT-TOP'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica la consulta SQL del manejador de recursos o el bloque PL/SQL responsable del manejo del m\00E9todo HTTP seleccionado.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(832078207819537181.4851)
,p_name=>'P12_COMMENTS'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(1508409614825854375.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Comentarios'
,p_source=>'COMMENTS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>3
,p_label_alignment=>'ABOVE'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Introduzca comentarios opcionales.'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1438965424547433182.4851)
,p_name=>'P12_CONTEXT'
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('M\00F3dulo de Servicio RESTful:')
,p_source=>':P12_MODULE'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica el nombre del m\00F3dulo de servicio RESTful.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1482979623581696066.4851)
,p_name=>'P12_HANDLER_SOURCE'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1490378423029362010.4851)
,p_name=>'P12_RESOURCE_TEMPLATE'
,p_item_sequence=>6
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Plantilla de URI:'
,p_source=>':P12_URI_TEMPLATE'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Identifica la plantilla de URI.'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1490412018311370063.4851)
,p_name=>'P12_RESOURCE_HANDLER'
,p_item_sequence=>7
,p_item_plug_id=>wwv_flow_api.id(413926308446017538.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Manejador de Recursos:'
,p_source=>'P12_HANDLER_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'HANDLER'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(method,''No method'') x, id',
'from wwv_flow_rt$handlers'))
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Identifica si se debe utilizar el m\00E9todo HTTP de manejador de recursos. ')
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1491751332528875757.4851)
,p_name=>'P12_CONTEXT2'
,p_item_sequence=>1
,p_item_plug_id=>wwv_flow_api.id(415049901982175222.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('Par\00E1metros del Manejador de Recursos:')
,p_source=>':P12_ALIAS'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'class="fielddatabold"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P12_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1439054629872444237.4851)
,p_computation_sequence=>40
,p_computation_item=>'P12_MODULE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    r varchar2(500) := null;',
'begin',
'    if :P9_ID is not null then',
'        for c1 in (select name',
'                     from WWV_FLOW_RT$MODULES m',
'                    where id = (select module_id',
'                                  from wwv_flow_rt$templates t',
'                                 where t.id = (select max(nvl(template_id , 0 )) x',
'                                                 from WWV_FLOW_RT$HANDLERS H',
'                                                where ID = :P9_ID',
'                                                  and security_group_id = :FLOW_SECURITY_GROUP_ID',
'                                               )',
'                               )',
'                  )',
'        loop',
'            r := c1.name;',
'        end loop;',
'    else',
'        for c1 in (select name',
'                     from WWV_FLOW_RT$MODULES m',
'                    where id = (select module_id',
'                                  from wwv_flow_rt$templates t',
'                                 where id = :P9_TEMPLATE_ID',
'                                   and security_group_id = :FLOW_SECURITY_GROUP_ID',
'                               )',
'                  )',
'        loop',
'           r := c1.name;',
'        end loop;',
'    end if;',
'    return r;',
'end;'))
,p_compute_when_type=>'NEVER'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1439069908879447568.4851)
,p_computation_sequence=>40
,p_computation_item=>'P12_URI_PREFIX'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   r varchar2(500) := null;',
'begin',
'if :P9_ID is not null then',
'    for c1 in (',
'    select uri_prefix ',
'    from WWV_FLOW_RT$MODULES m',
'    where  ',
'              id = (',
'    select module_id ',
'    from wwv_flow_rt$templates t ',
'    where  t.id = (',
'    select max(nvl(template_id , 0 )) x',
'    from WWV_FLOW_RT$HANDLERS H',
'    where ID = :P9_ID and security_group_id = :FLOW_SECURITY_GROUP_ID',
'    )',
'    )',
'    ) loop',
'        r := c1.uri_prefix;',
'    end loop;',
'else',
'    for c1 in (',
'    select uri_prefix ',
'    from WWV_FLOW_RT$MODULES m',
'    where  ',
'              id = (',
'    select module_id ',
'    from wwv_flow_rt$templates t ',
'    where id = :P9_TEMPLATE_ID and security_group_id = :FLOW_SECURITY_GROUP_ID)) loop',
'       r := c1.uri_prefix;',
'    end loop;',
'end if;',
'return r;',
'end;'))
,p_compute_when_type=>'NEVER'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1439085214420449233.4851)
,p_computation_sequence=>40
,p_computation_item=>'P12_URI_TEMPLATE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   r varchar2(500) := null;',
'begin',
'if :P9_ID is not null then',
'    for c1 in (',
'    select uri_template',
'    from wwv_flow_rt$templates t ',
'    where  t.id = (',
'    select max(nvl(template_id , 0 )) x',
'    from WWV_FLOW_RT$HANDLERS H',
'    where ID = :P9_ID and security_group_id = :FLOW_SECURITY_GROUP_ID',
'    )',
'    ) loop',
'        r := c1.uri_template;',
'    end loop;',
'else',
'    for c1 in (',
'    select uri_template ',
'    from wwv_flow_rt$templates t ',
'    where id = :P9_TEMPLATE_ID and security_group_id = :FLOW_SECURITY_GROUP_ID) loop',
'       r := c1.uri_template;',
'    end loop;',
'end if;',
'return r;',
'end;'))
,p_compute_when_type=>'NEVER'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1483268128701792175.4851)
,p_computation_sequence=>40
,p_computation_item=>'P12_HANDLER_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select handler_id from wwv_flow_rt$parameters',
'where id = :P12_ID',
'and security_group_id = :flow_security_group_id'))
,p_compute_when=>'P12_HANDLER_ID'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1491603025555845341.4851)
,p_name=>'Disable Source Item'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P12_TEMPLATE_SOURCE'
,p_condition_element=>'P12_TEMPLATE_SOURCE'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1491603321263845342.4851)
,p_event_id=>wwv_flow_api.id(1491603025555845341.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P12_TEMPLATE_SOURCE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(413929407780017546.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_RT$PARAMETERS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$PARAMETERS'
,p_attribute_03=>'P12_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(834248230441751846.4851)
,p_process_sequence=>40
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set display only values'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'    select template_id, sys.dbms_lob.substr(SOURCE,500,1) source',
'    from WWV_FLOW_RT$HANDLERS H',
'    where ID = :P12_HANDLER_ID and security_group_id = :FLOW_SECURITY_GROUP_ID) ',
'    loop',
'    :P12_TEMPLATE_SOURCE := c1.source;',
'    for c2 in (',
'       select module_id, uri_template',
'       from wwv_flow_rt$templates t ',
'       where id = c1.template_id and security_group_id = :FLOW_SECURITY_GROUP_ID) loop',
'           :P12_URI_TEMPLATE := c2.uri_template;',
'       for c3 in (',
'           select name, uri_prefix, id',
'           from WWV_FLOW_RT$MODULES m',
'           where id = c2.module_id and security_group_id = :FLOW_SECURITY_GROUP_ID) loop',
'              :P12_MODULE := wwv_flow_escape.html(c3.name);',
'              :P12_URI_PREFIX := wwv_flow_escape.html(c3.uri_prefix);',
'       end loop;',
'       ',
'    end loop;',
'end loop;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(413929600454017546.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_RT$PARAMETERS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$PARAMETERS'
,p_attribute_03=>'P12_ID'
,p_attribute_04=>'ID'
,p_attribute_05=>'P12_HANDLER_ID'
,p_attribute_06=>'HANDLER_ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('Acci\00F3n Procesada.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(413929830939017547.4851)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'12'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(413926722356017540.4851)
);
end;
/
prompt --application/pages/page_00013
begin
wwv_flow_api.create_page(
 p_id=>13.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Registros de Clientes'
,p_step_title=>'Registros de Clientes'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_step_template=>wwv_flow_api.id(6673001550641034.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
,p_protection_level=>'D'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1493765414286523358.4851)
,p_plug_name=>'Registros de Clientes'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719702549794942779.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.id,',
'       nvl2(a.apex_application_id,a.apex_application_id||''.''||(select name from wwv_flows ',
'         where id = a.apex_application_id ',
'           and security_group_id = a.security_group_id),''Third Party Application'') app_name,',
'       a.name client_name,',
'       a.updated_by,',
'       a.updated_on,',
'       wwv_flow_escape.html(substr(a.description,1,100)) description,',
'       decode(a.apex_application_id,null,:IMAGE_PREFIX||''menu/dbshare_64.gif'',:IMAGE_PREFIX||''apex/builder/db_app_64x64.gif'') the_icon,',
'       ''f?p=''||:APP_ID||'':7:''||:APP_SESSION||'':::7:P7_ID:''||id the_link',
'from wwv_flow_rt$clients a',
'where a.security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1493765612692523359.4851)
,p_name=>'RESTful Service Privilege Groups'
,p_max_row_count=>'100000'
,p_max_row_count_message=>unistr('Esta consulta devuelve m\00E1s de #MAX_ROW_COUNT# filas, filtre los datos para asegurar resultados completos.')
,p_no_data_found_message=>unistr('No se ha encontrado ning\00FAn dato.')
,p_allow_report_categories=>'N'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_enabled_yn=>'Y'
,p_icon_view_link_column=>'THE_LINK'
,p_icon_view_img_src_column=>'THE_ICON'
,p_icon_view_label_column=>'CLIENT_NAME'
,p_icon_view_columns_per_row=>5
,p_owner=>'HILARY'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1493766315141523363.4851)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Actualizado por'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1510965911492563071.4851)
,p_db_column_name=>'THE_ICON'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Icono'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1510966006055563071.4851)
,p_db_column_name=>'THE_LINK'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Enlace'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1513974106408820041.4851)
,p_db_column_name=>'ID'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1513974413044820044.4851)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>'Actualizado'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1516151509028360174.4851)
,p_db_column_name=>'APP_NAME'
,p_display_order=>15
,p_column_identifier=>'O'
,p_column_label=>unistr('Aplicaci\00F3n')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1643550722257332632.4851)
,p_db_column_name=>'CLIENT_NAME'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>'Cliente'
,p_column_link=>'#THE_LINK#'
,p_column_linktext=>'#CLIENT_NAME#'
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1665202832469041740.4851)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>17
,p_column_identifier=>'Q'
,p_column_label=>unistr('Descripci\00F3n')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1504318002245625065.4851)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(6675421676641048.4851)
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1646756928320422616.4851)
,p_plug_name=>'Acerca de'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(6675116240641047.4851)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Los registros de cliente permiten el registro de clientes autorizados en el espacio de trabajo actual, la revocaci\00F3n de registros de cliente existentes y el restablecimiento de credenciales del cliente.</p><p/>Se puede ver la informaci\00F3n de client')
||'e de las aplicaciones de &PRODUCT_NAME. y de terceros, pero <b>solo</b> se pueden registrar las aplicaciones de &PRODUCT_NAME..</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1504337307785626669.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(1504318002245625065.4851)
,p_button_name=>'RESET_REPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_image_alt=>'Restablecer'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:RP,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1493766730178523366.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1504318002245625065.4851)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Registrar Aplicaci\00F3n >')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:7::'
);
end;
/
prompt --application/pages/page_00014
begin
wwv_flow_api.create_page(
 p_id=>14.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Aprobaciones del Servicio RESTful'
,p_step_title=>'Aprobaciones del Servicio RESTful'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538586328567551330)
,p_nav_list_template_options=>'#DEFAULT#'
,p_protection_level=>'D'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1646010406456239414.4851)
,p_plug_name=>'Aprobaciones del Servicio RESTful'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719702549794942779.4851)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.ID, ',
'a.CLIENT_ID,',
'a.USER_NAME,',
'apex_item.hidden(1,a.ID)||apex_item.select_list_from_lov(2,a.STATUS,''RESTFUL_APPROVAL_TYPES'',null,''NO'') status,',
'a.SECURITY_GROUP_ID,',
'a.CREATED_BY,',
'a.CREATED_ON,',
'a.UPDATED_BY,',
'a.UPDATED_ON,',
':IMAGE_PREFIX||''htmldb/icons/icon_auth_default.gif'' the_icon,',
'--''f?p=''||:APP_ID||'':15:''||:APP_SESSION||'':::15:P15_ID:''||a.id the_link',
'''f?p=''||:APP_ID||'':14:''||:APP_SESSION||'':::'' the_link',
'from #OWNER#.WWV_FLOW_RT$APPROVALS a',
'  ',
''))
,p_plug_source_type=>'NATIVE_IR'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1646010626906239415.4851)
,p_name=>'RESTful Service Approvals'
,p_max_row_count=>'100000'
,p_max_row_count_message=>unistr('Esta consulta devuelve m\00E1s de #MAX_ROW_COUNT# filas, filtre los datos para asegurar resultados completos.')
,p_no_data_found_message=>unistr('No se ha encontrado ning\00FAn dato.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_actions_menu=>'N'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_link_column=>'THE_LINK'
,p_icon_view_img_src_column=>'THE_ICON'
,p_icon_view_label_column=>'USER_NAME'
,p_icon_view_columns_per_row=>5
,p_owner=>'HILARY'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646010728336239416.4851)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646010803515239417.4851)
,p_db_column_name=>'CLIENT_ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Cliente'
,p_column_type=>'NUMBER'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(1646424605586349771)
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646010909522239417.4851)
,p_db_column_name=>'USER_NAME'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Nombre de Usuario'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646011006306239417.4851)
,p_db_column_name=>'STATUS'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Estado'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(1646678615030409311)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646011119004239417.4851)
,p_db_column_name=>'SECURITY_GROUP_ID'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Identificador de Grupo de Seguridad'
,p_column_type=>'NUMBER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646011221324239418.4851)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Creado por'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646011308706239418.4851)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('Fecha de Creaci\00F3n')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646011401620239418.4851)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Actualizado por'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646011517428239418.4851)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Actualizado'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646258411249285138.4851)
,p_db_column_name=>'THE_ICON'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Icono'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1646258532566285139.4851)
,p_db_column_name=>'THE_LINK'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'Enlace'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1646157302891254340.4851)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(6675421676641048.4851)
,p_plug_display_sequence=>2
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1646895316031456904.4851)
,p_plug_name=>'Acerca de'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(6675116240641047.4851)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Las aprobaciones del servicio RESTful permiten la gesti\00F3n de aprobaciones asociadas a clientes del servicio RESTful.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_name=>'Pantalla Tabular'
,p_template=>wwv_flow_api.id(6674714399641047.4851)
,p_display_sequence=>15
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_TABFORM'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'"ID",',
'"ID" ID_DISPLAY,',
'"CLIENT_ID",',
'"USER_NAME",',
'"STATUS",',
'"SECURITY_GROUP_ID",',
'"CREATED_BY",',
'"CREATED_ON",',
'"UPDATED_BY",',
'"UPDATED_ON",',
'"ROW_VERSION_NUMBER"',
'from "#OWNER#"."WWV_FLOW_RT$APPROVALS"',
''))
,p_display_condition_type=>'NEVER'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(6679518318641053.4851)
,p_query_num_rows=>10
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'(null)'
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('No se ha encontrado ning\00FAn dato.')
,p_query_num_rows_type=>'ROW_RANGES_IN_SELECT_LIST'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_query_asc_image=>'apex/builder/dup.gif'
,p_query_asc_image_attr=>'width="16" height="16" alt="" '
,p_query_desc_image=>'apex/builder/ddown.gif'
,p_query_desc_image_attr=>'width="16" height="16" alt="" '
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648063800327695219.4851)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_column_heading=>'Id'
,p_disable_sort_column=>'N'
,p_hidden_column=>'Y'
,p_display_as=>'HIDDEN'
,p_column_width=>16
,p_pk_col_source_type=>'T'
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'ID'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648063915559695219.4851)
,p_query_column_id=>2
,p_column_alias=>'ID_DISPLAY'
,p_column_display_sequence=>2
,p_column_heading=>'Id'
,p_disable_sort_column=>'N'
,p_hidden_column=>'Y'
,p_column_width=>16
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'ID_DISPLAY'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648064032300695219.4851)
,p_query_column_id=>3
,p_column_alias=>'CLIENT_ID'
,p_column_display_sequence=>3
,p_column_heading=>'Cliente'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(1646424605586349771)
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_lov_display_extra=>'NO'
,p_include_in_export=>'Y'
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'CLIENT_ID'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648064116646695219.4851)
,p_query_column_id=>4
,p_column_alias=>'USER_NAME'
,p_column_display_sequence=>4
,p_column_heading=>'Nombre de Usuario'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'USER_NAME'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648064226050695219.4851)
,p_query_column_id=>5
,p_column_alias=>'STATUS'
,p_column_display_sequence=>5
,p_column_heading=>'Estado'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_display_as=>'SELECT_LIST_FROM_LOV'
,p_named_lov=>wwv_flow_api.id(1646678615030409311)
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_lov_display_extra=>'NO'
,p_include_in_export=>'Y'
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'STATUS'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648064313937695219.4851)
,p_query_column_id=>6
,p_column_alias=>'SECURITY_GROUP_ID'
,p_column_display_sequence=>6
,p_column_heading=>'Security Group Id'
,p_disable_sort_column=>'N'
,p_hidden_column=>'Y'
,p_display_as=>'TEXT'
,p_column_width=>16
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'SECURITY_GROUP_ID'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648064431515695219.4851)
,p_query_column_id=>7
,p_column_alias=>'CREATED_BY'
,p_column_display_sequence=>7
,p_column_heading=>'Creado por'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'CREATED_BY'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648064502988695219.4851)
,p_query_column_id=>8
,p_column_alias=>'CREATED_ON'
,p_column_display_sequence=>8
,p_column_heading=>unistr('Fecha de Creaci\00F3n')
,p_use_as_row_header=>'N'
,p_column_format=>'SINCE'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_column_width=>12
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'CREATED_ON'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648064614899695219.4851)
,p_query_column_id=>9
,p_column_alias=>'UPDATED_BY'
,p_column_display_sequence=>9
,p_column_heading=>'Actualizado por'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'UPDATED_BY'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648064727477695219.4851)
,p_query_column_id=>10
,p_column_alias=>'UPDATED_ON'
,p_column_display_sequence=>10
,p_column_heading=>'Actualizado'
,p_use_as_row_header=>'N'
,p_column_format=>'SINCE'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_column_width=>12
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'UPDATED_ON'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1648064817375695219.4851)
,p_query_column_id=>11
,p_column_alias=>'ROW_VERSION_NUMBER'
,p_column_display_sequence=>11
,p_column_heading=>'Row Version Number'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_hidden_column=>'Y'
,p_display_as=>'HIDDEN'
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
,p_ref_schema=>'APEX_040200'
,p_ref_table_name=>'WWV_FLOW_RT$APPROVALS'
,p_ref_column_name=>'ROW_VERSION_NUMBER'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648109108010700613.4851)
,p_column_sequence=>1
,p_query_column_name=>'ID'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648109221449700615.4851)
,p_column_sequence=>2
,p_query_column_name=>'ID_DISPLAY'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648109311736700615.4851)
,p_column_sequence=>3
,p_query_column_name=>'CLIENT_ID'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648109422434700615.4851)
,p_column_sequence=>4
,p_query_column_name=>'USER_NAME'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648109530143700615.4851)
,p_column_sequence=>5
,p_query_column_name=>'STATUS'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648109610317700615.4851)
,p_column_sequence=>6
,p_query_column_name=>'SECURITY_GROUP_ID'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648109722690700615.4851)
,p_column_sequence=>7
,p_query_column_name=>'CREATED_BY'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648109817607700615.4851)
,p_column_sequence=>8
,p_query_column_name=>'CREATED_ON'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648109911057700615.4851)
,p_column_sequence=>9
,p_query_column_name=>'UPDATED_BY'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648110030503700615.4851)
,p_column_sequence=>10
,p_query_column_name=>'UPDATED_ON'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(1648110112548700615.4851)
,p_column_sequence=>11
,p_query_column_name=>'ROW_VERSION_NUMBER'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1655185314733291900.4851)
,p_plug_name=>unistr('Navegaci\00F3n')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(6673907217641045.4851)
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(1655184530741291898.4851)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1655476716389340490.4851)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1648064930974695225.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1646176608085255847.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(1646157302891254340.4851)
,p_button_name=>'RESET_REPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_image_alt=>'Restablecer'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:RP,RIR,CIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1646011801025239419.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1646157302891254340.4851)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.:15::'
,p_button_condition_type=>'NEVER'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1648065021794695225.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1646157302891254340.4851)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1648067522021695229.4851)
,p_branch_action=>'f?p=&APP_ID.:14:&SESSION.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1648065625738695227.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_validation_name=>'CLIENT_ID not null'
,p_validation_sequence=>30
,p_validation=>'CLIENT_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#COLUMN_HEADER# debe tener un valor.'
,p_when_button_pressed=>wwv_flow_api.id(1648065021794695225.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'CLIENT_ID'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1648065829230695227.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_validation_name=>'CLIENT_ID must be numeric'
,p_validation_sequence=>30
,p_validation=>'CLIENT_ID'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('#COLUMN_HEADER# debe ser num\00E9rica.')
,p_when_button_pressed=>wwv_flow_api.id(1648065021794695225.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'CLIENT_ID'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1648066014923695227.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_validation_name=>'USER_NAME not null'
,p_validation_sequence=>40
,p_validation=>'USER_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#COLUMN_HEADER# debe tener un valor.'
,p_when_button_pressed=>wwv_flow_api.id(1648065021794695225.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'USER_NAME'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1648066210742695227.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_validation_name=>'STATUS not null'
,p_validation_sequence=>50
,p_validation=>'STATUS'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#COLUMN_HEADER# debe tener un valor.'
,p_when_button_pressed=>wwv_flow_api.id(1648065021794695225.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'STATUS'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1648066414329695227.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_validation_name=>'SECURITY_GROUP_ID not null'
,p_validation_sequence=>60
,p_validation=>'SECURITY_GROUP_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#COLUMN_HEADER# debe tener un valor.'
,p_when_button_pressed=>wwv_flow_api.id(1648065021794695225.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'SECURITY_GROUP_ID'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1648066601565695227.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_validation_name=>'SECURITY_GROUP_ID must be numeric'
,p_validation_sequence=>60
,p_validation=>'SECURITY_GROUP_ID'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('#COLUMN_HEADER# debe ser num\00E9rica.')
,p_when_button_pressed=>wwv_flow_api.id(1648065021794695225.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'SECURITY_GROUP_ID'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1648066818534695227.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_validation_name=>'CREATED_ON must be a valid date'
,p_validation_sequence=>80
,p_validation=>'CREATED_ON'
,p_validation_type=>'ITEM_IS_DATE'
,p_error_message=>unistr('#COLUMN_HEADER# debe ser una fecha v\00E1lida.')
,p_when_button_pressed=>wwv_flow_api.id(1648065021794695225.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'CREATED_ON'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1648067014517695229.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_validation_name=>'UPDATED_ON must be a valid date'
,p_validation_sequence=>100
,p_validation=>'UPDATED_ON'
,p_validation_type=>'ITEM_IS_DATE'
,p_error_message=>unistr('#COLUMN_HEADER# debe ser una fecha v\00E1lida.')
,p_when_button_pressed=>wwv_flow_api.id(1648065021794695225.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'UPDATED_ON'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1648067210667695229.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(1648063522077695211.4851)
,p_validation_name=>'ROW_VERSION_NUMBER must be numeric'
,p_validation_sequence=>110
,p_validation=>'ROW_VERSION_NUMBER'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('#COLUMN_HEADER# debe ser num\00E9rica.')
,p_when_button_pressed=>wwv_flow_api.id(1648065021794695225.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'ROW_VERSION_NUMBER'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1648817128329848402.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Manage Approvals'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'    -- Update wwv_flow_rt$approvals table to approve/deny access',
'    for i in 1 .. HTMLDB_APPLICATION.g_f01.count',
'    loop',
'',
'        -- Set Status Only For Changed Values',
'        update wwv_flow_rt$approvals',
'           set status = wwv_flow.g_f02(i)',
'         where id = wwv_flow.g_f01(i)',
'           and status <> wwv_flow.g_f02(i);',
'',
'        -- Delete Existing User Sessions',
'        if wwv_flow.g_f02(i) = ''DENIED'' then',
'            delete from wwv_flow_rt$user_sessions',
'             where approval_id = wwv_flow.g_f01(i);',
'        end if;',
'',
'    end loop;',
'  ',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1648065021794695225.4851)
,p_process_success_message=>'Los estados se han actualizado correctamente.'
);
end;
/
prompt --application/pages/page_00015
begin
wwv_flow_api.create_page(
 p_id=>15.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Crear/Editar Aprobaciones del Servicio RESTful'
,p_step_title=>'Crear/Editar Aprobaciones del Servicio RESTful'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1646007103991239390.4851)
,p_branch_action=>'f?p=&APP_ID.:14:&SESSION.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1646009523673239406.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_RT$APPROVALS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$APPROVALS'
,p_attribute_03=>'P15_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1646009729618239406.4851)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_RT$APPROVALS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_RT$APPROVALS'
,p_attribute_03=>'P15_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('Acci\00F3n Procesada.')
);
end;
/
prompt --application/pages/page_00016
begin
wwv_flow_api.create_page(
 p_id=>16.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Actualizar Varias Aprobaciones'
,p_step_title=>'Actualizar Varias Aprobaciones'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_step_template=>wwv_flow_api.id(719672816683933088.4851)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_protection_level=>'D'
,p_help_text=>'bldapp_item_pg_edit.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1654447920552002311.4851)
,p_plug_name=>'button bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(6675421676641048.4851)
,p_plug_display_sequence=>91
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_2'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1654540109279011339.4851)
,p_plug_name=>'Aprobaciones del Servicio RESTful'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719702549794942779.4851)
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_2'
,p_plug_item_display_point=>'BELOW'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'apex_item.checkbox2(1,a.id,null,null,'':'',null,''Select item'') c, ',
'a.ID, ',
'a.CLIENT_ID,',
'a.USER_NAME,',
'a.status,',
'a.SECURITY_GROUP_ID,',
'a.CREATED_BY,',
'a.CREATED_ON,',
'a.UPDATED_BY,',
'a.UPDATED_ON,',
':IMAGE_PREFIX||''htmldb/icons/icon_auth_default.gif'' the_icon,',
'--''f?p=''||:APP_ID||'':15:''||:APP_SESSION||'':::15:P15_ID:''||a.id the_link',
'''f?p=''||:APP_ID||'':14:''||:APP_SESSION||'':::'' the_link',
'from #OWNER#.WWV_FLOW_RT$APPROVALS a',
'  ',
''))
,p_plug_source_type=>'NATIVE_IR'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1654540306040011341.4851)
,p_name=>'RESTful Service Approvals'
,p_max_row_count=>'100000'
,p_max_row_count_message=>unistr('Esta consulta devuelve m\00E1s de #MAX_ROW_COUNT# filas, filtre los datos para asegurar resultados completos.')
,p_no_data_found_message=>unistr('No se ha encontrado ning\00FAn dato.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_link_column=>'THE_LINK'
,p_icon_view_img_src_column=>'THE_ICON'
,p_icon_view_label_column=>'USER_NAME'
,p_icon_view_columns_per_row=>5
,p_owner=>'HILARY'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654540403106011343.4851)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654540516507011343.4851)
,p_db_column_name=>'CLIENT_ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Cliente'
,p_column_type=>'NUMBER'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(1646424605586349771)
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654540612928011343.4851)
,p_db_column_name=>'USER_NAME'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Nombre de Usuario'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654540712711011343.4851)
,p_db_column_name=>'STATUS'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Estado'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(1646678615030409311)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654540827723011344.4851)
,p_db_column_name=>'SECURITY_GROUP_ID'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Identificador de Grupo de Seguridad'
,p_column_type=>'NUMBER'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654540924130011344.4851)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Creado por'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654541026547011344.4851)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('Fecha de Creaci\00F3n')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654541102869011344.4851)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Actualizado por'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654541204892011344.4851)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Actualizado'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654541326296011345.4851)
,p_db_column_name=>'THE_ICON'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Icono'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654541402424011345.4851)
,p_db_column_name=>'THE_LINK'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'Enlace'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1654672604262047707.4851)
,p_db_column_name=>'C'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>'<input type="checkbox" onclick="$f_CheckFirstColumn(this)" name="Seleccionar Todo" title="Check All"/>'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1655531818367345111.4851)
,p_plug_name=>unistr('Navegaci\00F3n')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(6673907217641045.4851)
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_2'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(1655184530741291898.4851)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1655476716389340490.4851)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1656558608998541091.4851)
,p_plug_name=>'Acerca de'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(6675116240641047.4851)
,p_plug_display_sequence=>130
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Para actualizar varias aprobaciones, utilice <b>Actualizar a Estado</b> para definir el estado deseado, active la casilla de control situada junto a las aprobaciones que desea actualizar y haga clic en <b>Actualizar</b></p>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1657380930272708144.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1654447920552002311.4851)
,p_button_name=>'RESET_REPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_image_alt=>'Restablecer'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:RP,RIR,CIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1655988208418398947.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1654447920552002311.4851)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(302280313173718795.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Actualizar Estado'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1654451519268002325.4851)
,p_branch_action=>'16'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>119
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1654448818143002316.4851)
,p_name=>'P16_STATUS'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1654447920552002311.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Actualizar a Estado'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RESTFUL_APPROVAL_TYPES'
,p_lov=>'.'||wwv_flow_api.id(1646678615030409311.4851)||'.'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(6683302430641069.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Identifique el estado al que desea actualizar las aprobaciones comprobadas.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1654450000473002317.4851)
,p_name=>'P16_SPACE'
,p_item_sequence=>18
,p_item_plug_id=>wwv_flow_api.id(1654447920552002311.4851)
,p_source=>'&nbsp;'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1654450719223002321.4851)
,p_validation_name=>'AtLeastOneSelected'
,p_validation_sequence=>10
,p_validation=>'wwv_flow.g_f01.count > 0'
,p_validation_type=>'PLSQL_EXPRESSION'
,p_error_message=>'Debe seleccionar al menos un elemento.'
,p_when_button_pressed=>wwv_flow_api.id(1655988208418398947.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1654451232336002321.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Approval Statuses'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for i in 1..wwv_flow.g_f01.count loop',
'    -- Update Approvals Table ',
'    update wwv_flow_rt$approvals ',
'       set status = :P16_STATUS',
'     where id = wwv_flow.g_f01(i)',
'       and status <> :P16_STATUS;',
'  ',
'    -- Update User_Sessions Table',
'    if :P16_STATUS = ''DENIED'' then',
'        delete from wwv_flow_rt$user_sessions',
'         where approval_id = wwv_flow.g_f01(i);',
'    end if;',
'   ',
'end loop;'))
,p_process_error_message=>unistr('Error al actualizar el estado de aprobaci\00F3n.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(1655988208418398947.4851)
,p_process_success_message=>'Los estados se han actualizado.'
);
end;
/
prompt --application/pages/page_00020
begin
wwv_flow_api.create_page(
 p_id=>20.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>unistr('Advertencia de la migraci\00F3n de REST de APEX')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('Advertencia de la migraci\00F3n de REST de APEX')
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(381633879669445608)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(865348123365614211.4851)
,p_plug_name=>'18.2 + Warning Text'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_lang.system_message_p(''REST_WS.MIGRATION_WARNING_18_2_PLUS'');',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_version      APEX_APPLICATION_GLOBAL.vc_arr2;',
'BEGIN ',
'    -- Break down the component parts',
'    l_version := apex_util.string_to_table(wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema) , ''.'');',
'    -- Is the version 18.2 or greater',
'    if  to_number(l_version(1)) >= 18  ',
'        and  ',
'        to_number(l_version(2)) >= 2 ',
'        and ',
'        :P1_HAS_DUP_NULL_MODULES > 1 ',
'    then',
'       RETURN TRUE;',
'    else ',
'       RETURN FALSE;',
'    end if;',
'END;'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(865348995171614219.4851)
,p_plug_name=>'Button Region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(865349561974614225.4851)
,p_plug_name=>'Confirm Migration'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_lang.system_message_p(''REST_WS.MIGRATION_CONFIRMATION'');',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_version      APEX_APPLICATION_GLOBAL.vc_arr2;',
'BEGIN ',
'    -- Break down the component parts',
'    l_version := apex_util.string_to_table(wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema) , ''.'');',
'    -- ',
'    IF (:P1_HAS_DUP_NULL_MODULES < 2) OR  (to_number(l_version(1)) >=18 and to_number(l_version(2)) >=2) THEN ',
'        return true;',
'    ELSE',
'        return false;',
'    END IF;',
'END;'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(865349756636614227.4851)
,p_plug_name=>'Pre 18.2 Warning Text'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_lang.system_message_p(''REST_WS.MIGRATION_WARNING_PRE_18_2'');',
'',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_version      APEX_APPLICATION_GLOBAL.vc_arr2;',
'BEGIN ',
'    -- Break down the component parts',
'    l_version := apex_util.string_to_table(wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema), ''.'');',
'    -- Is the version 18.2 or greater',
'',
'--  IF    Dup Null modeule URIs      AND  Either ORDS is 18.1.X  OR ORDS is a version less than 17)',
'    if  :P1_HAS_DUP_NULL_MODULES > 1 AND ((to_number(l_version(1)) = 18  and to_number(l_version(2)) < 2   ) OR   (to_number(l_version(1)) < 18))',
'    then',
'       RETURN TRUE;',
'    else ',
'       RETURN FALSE;',
'    end if;',
'END;'))
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(865349051108614220.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(865348995171614219.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(865348800823614218.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(865348995171614219.4851)
,p_button_name=>'MIGRATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Migrar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_version      APEX_APPLICATION_GLOBAL.vc_arr2;',
'BEGIN ',
'    -- Break down the component parts',
'    l_version := apex_util.string_to_table(wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema) , ''.'');',
'    -- ',
'    IF (:P1_HAS_DUP_NULL_MODULES < 2) OR  (to_number(l_version(1)) >=18 and to_number(l_version(2)) >=2) THEN ',
'        return true;',
'    ELSE',
'        return false;',
'    END IF;',
'END;'))
,p_button_condition_type=>'FUNCTION_BODY'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(865349689390614226.4851)
,p_branch_name=>'Branch to Page 1'
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(865349199362614221.4851)
,p_name=>'Close Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(865349051108614220.4851)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(865349234308614222.4851)
,p_event_id=>wwv_flow_api.id(865349199362614221.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(928927341385901569.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Migrate Services'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_workspace varchar2(32767);',
'BEGIN ',
'	l_workspace :=  wwv_flow_security.find_company_name( p_security_group_id => :flow_security_group_id ); ',
'	ords_metadata.ords_migrate.migrate_apex_workspace_rest(p_workspace_name => l_workspace);',
'END;'))
,p_process_error_message=>'No se han podido migrar los servicios. #SQLERRM_TEXT#'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'Los servicios RESTful basados en APEX se han migrado. Compruebe la consola de servicios RESTful de ORDS.'
);
end;
/
prompt --application/pages/page_00100
begin
wwv_flow_api.create_page(
 p_id=>100.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Servicios RESTful de ORDS'
,p_step_title=>'Servicios RESTful de ORDS'
,p_allow_duplicate_submissions=>'N'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(344911404961486242)
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
''))
,p_step_template=>wwv_flow_api.id(754939123056928433.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538579044595390057)
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395803830429090628.4851)
,p_plug_name=>'Esquema no registrado con ORDS'
,p_region_template_options=>'#DEFAULT#:a-Alert--colorBG:a-Alert--warning:a-Alert--horizontal'
,p_plug_template=>wwv_flow_api.id(410842408391417181.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'wwv_flow_lang.system_message_p(''REST_WS.NOT_ORDS_ENABLED'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NOT_EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''X''',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_SCHEMAS''',
'   and c001 = :P0_SCHEMA'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_plug_name=>'Dashboard'
,p_region_name=>'ordsDashboard'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(725723925684227744.4851)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''X''',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_SCHEMAS''',
'   and c001 = :P0_SCHEMA'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395802139138090611.4851)
,p_plug_name=>'Objetos activados'
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_css_classes=>'u-Height h220'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_session           varchar2(255) := :APP_SESSION;',
'   l_security_group_id number := :FLOW_SECURITY_GROUP_ID;',
'   l_count             number := 0;',
'begin',
'',
'-- milestones',
'for c1 in (',
' select /* APEX4850100ENOBJ */',
'           count(*) c',
'   from  wwv_flow_collections ',
' where collection_name = ''ORDS_ENABLED_OBJECTS''',
') loop',
'  l_count := c1.c;',
'',
'  sys.htp.p(''<div class="a-BadgeChart a-BadgeChart--justGageLike">'');',
'  sys.htp.p(''  <a href="f?p=4850:190:''||l_session||'':::RIR:P0_SELECTED_NODE:OB0"  class="a-BadgeChart-link">'');',
'  sys.htp.p(''    <span class="a-BadgeChart-value">''||to_char(l_count,''999G999G999G990'')||'' </span> '');',
'  sys.htp.p(''  </a>'');',
'  sys.htp.p(''  <div class="a-BadgeChart-text">'');',
'  sys.htp.p(''    <span class="a-BadgeChart-label">''||wwv_flow_lang.system_message(''REST_WS.ENABLED_OBJECT_COUNT_LABEL'')||''</span>'');',
'  sys.htp.p(''    <span class="a-BadgeChart-desc">'');',
'  sys.htp.p(''    </span>'');',
'  sys.htp.p(''  </div>'');',
'  sys.htp.p(''</div>'');',
'',
'end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395804032743090630.4851)
,p_plug_name=>unistr('Estado de m\00F3dulo')
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>100
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'NATIVE_JET_CHART'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_jet_chart(
 p_id=>wwv_flow_api.id(395804155777090631.4851)
,p_region_id=>wwv_flow_api.id(395804032743090630.4851)
,p_chart_type=>'pie'
,p_animation_on_display=>'none'
,p_animation_on_data_change=>'none'
,p_data_cursor=>'on'
,p_data_cursor_behavior=>'auto'
,p_hide_and_show_behavior=>'none'
,p_hover_behavior=>'none'
,p_stack=>'off'
,p_stack_label=>'off'
,p_connect_nulls=>'Y'
,p_value_position=>'auto'
,p_value_format_type=>'decimal'
,p_value_decimal_places=>0
,p_value_format_scaling=>'auto'
,p_sorting=>'label-asc'
,p_fill_multi_series_gaps=>true
,p_tooltip_rendered=>'Y'
,p_show_series_name=>true
,p_show_group_name=>true
,p_show_value=>true
,p_show_label=>true
,p_show_row=>true
,p_show_start=>true
,p_show_end=>true
,p_show_progress=>true
,p_show_baseline=>true
,p_legend_rendered=>'on'
,p_legend_position=>'bottom'
,p_overview_rendered=>'off'
,p_pie_other_threshold=>0
,p_pie_selection_effect=>'highlight'
,p_no_data_found_message=>unistr('No se ha definido ning\00FAn m\00F3dulo')
,p_horizontal_grid=>'auto'
,p_vertical_grid=>'auto'
,p_gauge_orientation=>'circular'
,p_gauge_plot_area=>'on'
,p_show_gauge_value=>true
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(395804241869090632.4851)
,p_chart_id=>wwv_flow_api.id(395804155777090631.4851)
,p_seq=>10
,p_name=>unistr('Fecha de Publicaci\00F3n')
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT ',
'    wwv_flow_lang.system_message(''REST_WS.PUBLISHED'') name,',
'    COUNT(*) the_value',
'FROM',
'    wwv_flow_collections',
'WHERE',
'    collection_name = ''ORDS_MODULES''',
'    AND   c003 = ''PUBLISHED''',
''))
,p_series_name_column_name=>'NAME'
,p_items_value_column_name=>'THE_VALUE'
,p_items_label_column_name=>'NAME'
,p_color=>'#60CCB5'
,p_items_label_rendered=>false
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
,p_link_target=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,RIR:IREQ_PUBLISHED_STATUS,P0_SELECTED_NODE:PUBLISHED,MD-3'
,p_link_target_type=>'REDIRECT_PAGE'
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(395804528626090635.4851)
,p_chart_id=>wwv_flow_api.id(395804155777090631.4851)
,p_seq=>20
,p_name=>'No publicado'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT',
'    wwv_flow_lang.system_message(''REST_WS.UNPUBLISHED'') name,',
'    COUNT(*) the_value',
'FROM',
'    wwv_flow_collections',
'WHERE',
'    collection_name = ''ORDS_MODULES''',
'    AND   c003 = ''NOT_PUBLISHED''',
''))
,p_series_name_column_name=>'NAME'
,p_items_value_column_name=>'THE_VALUE'
,p_items_label_column_name=>'NAME'
,p_color=>'#EC7A71'
,p_items_label_rendered=>false
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
,p_link_target=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,RIR:IREQ_PUBLISHED_STATUS,P0_SELECTED_NODE:NOT_PUBLISHED,MD-3'
,p_link_target_type=>'REDIRECT_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395804659971090636.4851)
,p_plug_name=>unistr('Seguridad de m\00F3dulo')
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'NATIVE_JET_CHART'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder apex-col--bottomBorder'
);
wwv_flow_api.create_jet_chart(
 p_id=>wwv_flow_api.id(395804743932090637.4851)
,p_region_id=>wwv_flow_api.id(395804659971090636.4851)
,p_chart_type=>'pie'
,p_animation_on_display=>'none'
,p_animation_on_data_change=>'none'
,p_data_cursor=>'auto'
,p_data_cursor_behavior=>'auto'
,p_hide_and_show_behavior=>'none'
,p_hover_behavior=>'none'
,p_stack=>'off'
,p_stack_label=>'off'
,p_connect_nulls=>'Y'
,p_value_position=>'auto'
,p_value_format_type=>'decimal'
,p_value_decimal_places=>0
,p_value_format_scaling=>'auto'
,p_sorting=>'label-asc'
,p_fill_multi_series_gaps=>true
,p_tooltip_rendered=>'Y'
,p_show_series_name=>true
,p_show_group_name=>true
,p_show_value=>true
,p_show_label=>true
,p_show_row=>true
,p_show_start=>true
,p_show_end=>true
,p_show_progress=>true
,p_show_baseline=>true
,p_legend_rendered=>'on'
,p_legend_position=>'bottom'
,p_overview_rendered=>'off'
,p_pie_other_threshold=>0
,p_pie_selection_effect=>'highlight'
,p_no_data_found_message=>unistr('No se ha definido ning\00FAn m\00F3dulo')
,p_horizontal_grid=>'auto'
,p_vertical_grid=>'auto'
,p_gauge_orientation=>'circular'
,p_gauge_plot_area=>'on'
,p_show_gauge_value=>true
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(395804822621090638.4851)
,p_chart_id=>wwv_flow_api.id(395804743932090637.4851)
,p_seq=>10
,p_name=>'Seguro'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT',
'    wwv_flow_lang.system_message(''REST_WS.SECURED'') name,',
'    COUNT(*) the_value',
'FROM',
'    wwv_flow_collections m',
'WHERE m.collection_name = ''ORDS_MODULES''',
'  and  wwv_flow_rest_ws.module_is_protected(m.n001) = ''F'''))
,p_series_name_column_name=>'NAME'
,p_items_value_column_name=>'THE_VALUE'
,p_items_label_column_name=>'NAME'
,p_color=>'#50CCB5'
,p_items_label_rendered=>false
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
,p_link_target=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,RIR:P0_SELECTED_NODE,IREQ_PROTECTED_FILTER:MD-3,F'
,p_link_target_type=>'REDIRECT_PAGE'
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(395804984412090639.4851)
,p_chart_id=>wwv_flow_api.id(395804743932090637.4851)
,p_seq=>20
,p_name=>'No seguro'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT',
'    wwv_flow_lang.system_message(''REST_WS.UNSECURED'') name,',
'    COUNT(*) the_value',
'FROM',
'    wwv_flow_collections m',
'WHERE m.collection_name = ''ORDS_MODULES''',
'  and  wwv_flow_rest_ws.module_is_protected(m.n001) = ''N'''))
,p_series_name_column_name=>'NAME'
,p_items_value_column_name=>'THE_VALUE'
,p_items_label_column_name=>'NAME'
,p_color=>'#EC7A71'
,p_items_label_rendered=>false
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
,p_link_target=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,RIR:P0_SELECTED_NODE,IREQ_PROTECTED_FILTER:MD-3,N'
,p_link_target_type=>'REDIRECT_PAGE'
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(54184436014062234.4851)
,p_chart_id=>wwv_flow_api.id(395804743932090637.4851)
,p_seq=>30
,p_name=>'Partially_Secured'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT',
'    wwv_flow_lang.system_message(''REST_WS.PARTIALLY_SECURED'') name,',
'    COUNT(*) the_value',
'FROM',
'    wwv_flow_collections m',
'WHERE m.collection_name = ''ORDS_MODULES''',
'  and  wwv_flow_rest_ws.module_is_protected(m.n001) = ''P'''))
,p_items_value_column_name=>'THE_VALUE'
,p_items_label_column_name=>'NAME'
,p_color=>'#F4D26F'
,p_items_label_rendered=>false
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
,p_link_target=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,RIR:P0_SELECTED_NODE,IREQ_PROTECTED_FILTER:MD-3,P'
,p_link_target_type=>'REDIRECT_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395805169489090641.4851)
,p_plug_name=>'Privilegios'
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_css_classes=>'u-Height h220'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_session           varchar2(255) := :APP_SESSION;',
'   l_security_group_id number := :FLOW_SECURITY_GROUP_ID;',
'   l_count             number := 0;',
'begin',
'',
'-- milestones',
'for c1 in (',
' select /* APEX4850100SVCCNT */',
'           count(*) c',
'   from  wwv_flow_collections ',
' where collection_name = ''ORDS_PRIVILEGES''',
') loop',
'  l_count := c1.c;',
'',
'  sys.htp.p(''<div class="a-BadgeChart a-BadgeChart--justGageLike">'');',
'  sys.htp.p(''  <a href="f?p=4850:150:''||l_session||'':::RIR:P0_SELECTED_NODE:PR-2"  class="a-BadgeChart-link">'');',
'  sys.htp.p(''    <span class="a-BadgeChart-value">''||to_char(l_count,''999G999G999G990'')||'' </span> '');',
'  sys.htp.p(''  </a>'');',
'  sys.htp.p(''  <div class="a-BadgeChart-text">'');',
'  sys.htp.p(''    <span class="a-BadgeChart-label">''||wwv_flow_lang.system_message(''REST_WS.PRIVILEGE_COUNT_LABEL'')||''</span>'');',
'  sys.htp.p(''    <span class="a-BadgeChart-desc">'');',
'  sys.htp.p(''    </span>'');',
'  sys.htp.p(''  </div>'');',
'  sys.htp.p(''</div>'');',
'',
'end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395805203518090642.4851)
,p_plug_name=>'Roles'
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_css_classes=>'u-Height h220'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_session           varchar2(255) := :APP_SESSION;',
'   l_security_group_id number := :FLOW_SECURITY_GROUP_ID;',
'   l_count             number := 0;',
'begin',
'',
'-- milestones',
'for c1 in (',
' select /* APEX4850100SVCCNT */',
'           count(*) c',
'   from  wwv_flow_collections ',
' where collection_name = ''ORDS_ROLES''',
') loop',
'  l_count := c1.c;',
'',
'  sys.htp.p(''<div class="a-BadgeChart a-BadgeChart--justGageLike">'');',
'  sys.htp.p(''  <a href="f?p=4850:170:''||l_session||'':::RIR:P0_SELECTED_NODE:RO-1"  class="a-BadgeChart-link">'');',
'  sys.htp.p(''    <span class="a-BadgeChart-value">''||to_char(l_count,''999G999G999G990'')||'' </span> '');',
'  sys.htp.p(''  </a>'');',
'  sys.htp.p(''  <div class="a-BadgeChart-text">'');',
'  sys.htp.p(''    <span class="a-BadgeChart-label">''||wwv_flow_lang.system_message(''REST_WS.ROLE_COUNT_LABEL'')||''</span>'');',
'  sys.htp.p(''    <span class="a-BadgeChart-desc">'');',
'  sys.htp.p(''    </span>'');',
'  sys.htp.p(''  </div>'');',
'  sys.htp.p(''</div>'');',
'',
'end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395805380789090643.4851)
,p_plug_name=>'Alias de objeto'
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>120
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'NATIVE_JET_CHART'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder apex-col--bottomBorder'
);
wwv_flow_api.create_jet_chart(
 p_id=>wwv_flow_api.id(395805426455090644.4851)
,p_region_id=>wwv_flow_api.id(395805380789090643.4851)
,p_chart_type=>'pie'
,p_animation_on_display=>'none'
,p_animation_on_data_change=>'none'
,p_data_cursor=>'auto'
,p_data_cursor_behavior=>'auto'
,p_hide_and_show_behavior=>'none'
,p_hover_behavior=>'none'
,p_stack=>'off'
,p_stack_label=>'off'
,p_connect_nulls=>'Y'
,p_value_position=>'auto'
,p_value_format_type=>'decimal'
,p_value_decimal_places=>0
,p_value_format_scaling=>'auto'
,p_sorting=>'label-asc'
,p_fill_multi_series_gaps=>true
,p_tooltip_rendered=>'Y'
,p_show_series_name=>true
,p_show_group_name=>true
,p_show_value=>true
,p_show_label=>true
,p_show_row=>true
,p_show_start=>true
,p_show_end=>true
,p_show_progress=>true
,p_show_baseline=>true
,p_legend_rendered=>'on'
,p_legend_position=>'bottom'
,p_overview_rendered=>'off'
,p_pie_other_threshold=>0
,p_pie_selection_effect=>'highlight'
,p_no_data_found_message=>unistr('No se ha encontrado ning\00FAn objeto activado para RESTful')
,p_horizontal_grid=>'auto'
,p_vertical_grid=>'auto'
,p_gauge_orientation=>'circular'
,p_gauge_plot_area=>'on'
,p_show_gauge_value=>true
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(395805523114090645.4851)
,p_chart_id=>wwv_flow_api.id(395805426455090644.4851)
,p_seq=>10
,p_name=>'Con alias'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''REST_WS.ALIASED'') name, ',
'        count(*) the_value',
'   from  wwv_flow_collections ',
' where collection_name = ''ORDS_ENABLED_OBJECTS''',
'   and upper(c002) != upper(c003)'))
,p_series_name_column_name=>'NAME'
,p_items_value_column_name=>'THE_VALUE'
,p_items_label_column_name=>'NAME'
,p_color=>'#60CCB5'
,p_items_label_rendered=>false
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
,p_link_target=>'f?p=&APP_ID.:190:&SESSION.:IR_REPORT_ALIASED:&DEBUG.:RP,RIR:P0_SELECTED_NODE:OB0'
,p_link_target_type=>'REDIRECT_PAGE'
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(395805625562090646.4851)
,p_chart_id=>wwv_flow_api.id(395805426455090644.4851)
,p_seq=>20
,p_name=>'Sin alias'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''REST_WS.UNALIASED'') name, ',
'        count(*) the_value',
'   from  wwv_flow_collections ',
' where collection_name = ''ORDS_ENABLED_OBJECTS''',
'   and upper(c002) = upper(c003)',
' '))
,p_series_name_column_name=>'NAME'
,p_items_value_column_name=>'THE_VALUE'
,p_items_label_column_name=>'NAME'
,p_color=>'#EC7A71'
,p_items_label_rendered=>false
,p_items_label_display_as=>'PERCENT'
,p_threshold_display=>'onIndicator'
,p_link_target=>'f?p=&APP_ID.:190:&SESSION.:IR_REPORT_UNALIASED:&DEBUG.:RP,RIR:P0_SELECTED_NODE:OB0'
,p_link_target_type=>'REDIRECT_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(411295240347027815.4851)
,p_plug_name=>unistr('M\00F3dulos')
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_css_classes=>'u-Height h220'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_session           varchar2(255) := :APP_SESSION;',
'   l_security_group_id number := :FLOW_SECURITY_GROUP_ID;',
'   l_count             number := 0;',
'begin',
'',
'-- milestones',
'for c1 in (',
' select /* APEX4850100SVCCNT */',
'           count(*) c',
'   from  wwv_flow_collections ',
' where collection_name = ''ORDS_MODULES''',
') loop',
'  l_count := c1.c;',
'',
'  sys.htp.p(''<div class="a-BadgeChart a-BadgeChart--justGageLike">'');',
'  sys.htp.p(''  <a href="f?p=4850:110:''||l_session||'':::RIR:P0_SELECTED_NODE:MD-3"  class="a-BadgeChart-link">'');',
'  sys.htp.p(''    <span class="a-BadgeChart-value">''||to_char(l_count,''999G999G999G990'')||'' </span> '');',
'  sys.htp.p(''  </a>'');',
'  sys.htp.p(''  <div class="a-BadgeChart-text">'');',
'  sys.htp.p(''    <span class="a-BadgeChart-label">''||wwv_flow_lang.system_message(''REST_WS.MODULE_COUNT_LABEL'')||''</span>'');',
'  sys.htp.p(''    <span class="a-BadgeChart-desc">'');',
'  sys.htp.p(''    </span>'');',
'  sys.htp.p(''  </div>'');',
'  sys.htp.p(''</div>'');',
'',
'end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(411295301244027816.4851)
,p_plug_name=>'Acceso al esquema'
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select decode(c004, ''ENABLED'',''SUCCESS'',''FAILURE'') result,',
'       wwv_flow_lang.system_message(''REST_WS.SCHEMA_ACCESS_LABEL'') label,',
'       decode(c004, ''ENABLED'', UPPER(wwv_flow_lang.system_message(''REST_WS.ENABLED'')),UPPER(wwv_flow_lang.system_message(''REST_WS.DISABLED'')))  status',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_SCHEMAS''',
'   and c001 = :P0_SCHEMA;'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.SIMPLE_STAUS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'RESULT'
,p_attribute_02=>'LABEL'
,p_attribute_03=>'STATUS'
,p_attribute_04=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:RP::'
,p_attribute_05=>'Configure'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(411295479703027817.4851)
,p_plug_name=>'Acceso a metadatos'
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select decode(c005, ''ENABLED'',''SUCCESS'',''WARNING'') result,',
'       wwv_flow_lang.system_message(''REST_WS.METADATA_ACCESS_LABEL'') label,',
'       decode(c005, ''ENABLED'', UPPER(wwv_flow_lang.system_message(''REST_WS.ENABLED'')),UPPER(wwv_flow_lang.system_message(''REST_WS.DISABLED'')))  status',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_SCHEMAS''',
'   and c001 = :P0_SCHEMA;'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.SIMPLE_STAUS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_attribute_01=>'RESULT'
,p_attribute_02=>'LABEL'
,p_attribute_03=>'STATUS'
,p_attribute_04=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:RP::'
,p_attribute_05=>'Configure'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(411295559201027818.4851)
,p_plug_name=>'Esquema con alias'
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select case',
'          when  upper(c001) = upper(c003) then ''WARNING''',
'          else  ''SUCCESS''',
'          end result,',
'         wwv_flow_lang.system_message(''REST_WS.SCHEMA_ALIAS_LABEL'') label,',
'       c003 status',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_SCHEMAS''',
'   and c001 = :P0_SCHEMA;'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.SIMPLE_STAUS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--leftBorder'
,p_attribute_01=>'RESULT'
,p_attribute_02=>'LABEL'
,p_attribute_03=>'STATUS'
,p_attribute_04=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:RP::'
,p_attribute_05=>'Configure'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(411298470130027847.4851)
,p_plug_name=>'Button Bar'
,p_parent_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(411298371719027846.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(411298470130027847.4851)
,p_button_name=>'DROP_REST_SERVICES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Anular registro de esquema de ORDS'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'f?p=&APP_ID.:107:&SESSION.::&DEBUG.:RP::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(54182366961062213.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(395805169489090641.4851)
,p_button_name=>'ADD_PRIVILEGE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(719736129383947861.4851)
,p_button_image_alt=>'Agregar Privilegio'
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:160:&SESSION.::&DEBUG.:RP,160::'
,p_icon_css_classes=>'icon-plus'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(54182482115062214.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(395805203518090642.4851)
,p_button_name=>'ADD_ROLE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(719736129383947861.4851)
,p_button_image_alt=>'Agregar rol'
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:180:&SESSION.::&DEBUG.:RP,180::'
,p_icon_css_classes=>'icon-plus'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(54182897696062218.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(395802139138090611.4851)
,p_button_name=>'VIEW_OBJECTS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(719736129383947861.4851)
,p_button_image_alt=>'Ver objetos activados'
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:190:&SESSION.::&DEBUG.:RP,190:P0_SELECTED_NODE:OB0'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(693723825032042149.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(411295240347027815.4851)
,p_button_name=>'ADD_MODULE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(719736129383947861.4851)
,p_button_image_alt=>unistr('Agregar M\00F3dulo')
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:RP,120::'
,p_icon_css_classes=>'icon-plus'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(54182523224062215.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(411295240347027815.4851)
,p_button_name=>'VIEW_MODULES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(719736129383947861.4851)
,p_button_image_alt=>unistr('Ver m\00F3dulos')
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,110:P0_SELECTED_NODE:MD-3'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(54182609179062216.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(395805169489090641.4851)
,p_button_name=>'VIEW_PRIVILEGES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(719736129383947861.4851)
,p_button_image_alt=>unistr('Privilegios de Visualizaci\00F3n')
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:150:&SESSION.::&DEBUG.:RP,150:P0_SELECTED_NODE:PR-2'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(54182709832062217.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(395805203518090642.4851)
,p_button_name=>'VIEW_ROLES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(719736129383947861.4851)
,p_button_image_alt=>'Ver Roles'
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:170:&SESSION.::&DEBUG.:RP,170:P0_SELECTED_NODE:RO-1'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(521637037513366432.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(411298470130027847.4851)
,p_button_name=>'RESET_SAMPLE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Restablecer servicio de ejemplo'
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.:RP::'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''x'' ',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_MODULES''',
'   and c002 = ''/hr/'''))
,p_button_condition_type=>'EXISTS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(521637230858366434.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(411298470130027847.4851)
,p_button_name=>'INSTALL_SAMPLE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Instalar servicio de ejemplo'
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''x'' ',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_MODULES''',
'   and c002 = ''/hr/'''))
,p_button_condition_type=>'NOT_EXISTS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(370128398086680753.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(395803830429090628.4851)
,p_button_name=>'ENABLE_SCHEMA'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Registrar esquema con ORDS'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:RP,105::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(521633997504366401.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(411298470130027847.4851)
,p_button_name=>'IMPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--iconLeft:a-Button--gapLeft'
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_button_image_alt=>'Importar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:109:&SESSION.::&DEBUG.:RP,109::'
,p_icon_css_classes=>'icon-upload'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(411298548428027848.4851)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(411298470130027847.4851)
,p_button_name=>'EXPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_button_image_alt=>'Exportar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:108:&SESSION.::&DEBUG.:RP,108::'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''X'' ',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_MODULES'''))
,p_button_condition_type=>'EXISTS'
,p_icon_css_classes=>'icon-download'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(619046299163969808.4851)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(411298470130027847.4851)
,p_button_name=>'CONFIGURE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--iconLeft:a-Button--gapLeft'
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_button_image_alt=>'Configurar'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:RP,105::'
,p_icon_css_classes=>'icon-util'
);
end;
/
begin
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(334840708680272021.4851)
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(411298276648027845.4851)
,p_name=>'ORDS_VERSION'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1386162789082360524.4851)
,p_prompt=>unistr('Versi\00F3n de ORDS')
,p_source=>'wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(334838669419272019.4851)
,p_name=>'Handler - Source Type'
,p_event_sequence=>60
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P100_SOURCE_TYPE'
,p_condition_element=>'P100_SOURCE_TYPE'
,p_triggering_condition_type=>'IN_LIST'
,p_triggering_expression=>'QUERY'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(334839012878272020.4851)
,p_name=>'Template - Etag Type'
,p_event_sequence=>70
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P100_ETAG_TYPE'
,p_condition_element=>'P100_ETAG_TYPE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'QUERY'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(334839404182272020.4851)
,p_name=>'Mime Type Allowed - Visibility'
,p_event_sequence=>80
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P100_METHOD'
,p_condition_element=>'P100_METHOD'
,p_triggering_condition_type=>'IN_LIST'
,p_triggering_expression=>'POST,PUT'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(334839863378272020.4851)
,p_name=>'GET Method Settings'
,p_event_sequence=>90
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P100_METHOD'
,p_condition_element=>'P100_METHOD'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'GET'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(521637113860366433.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'install Sample Service'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'   l_exec_return        varchar2(32767);',
'   l_fnd                boolean := FALSE;',
'   l_owner              varchar2(255) := v(''P0_SCHEMA'');',
'   l_service_definition varchar2(32767) :=',
'q''!',
'BEGIN',
'  ORDS.DEFINE_MODULE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_base_path      => ''/hr/'',',
'      p_items_per_page => 25,',
'      p_status         => ''PUBLISHED'',',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsec/:empname'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsec/:empname'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select empno, ename, deptno, job from emp ',
'	where ((select job from emp where ename = :empname) IN (''''PRESIDENT'''', ''''MANAGER'''')) ',
'    OR  ',
'    (deptno = (select deptno from emp where ename = :empname)) ',
'order by deptno, ename',
''');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsecformat/:empname'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsecformat/:empname'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''plsql/block'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''DECLARE',
'  prevdeptno     number;',
'  total_rows     number;',
'  deptloc        varchar2(20);',
'  deptname       varchar2(20);',
'  ',
'  CURSOR         getemps is select * from emp ',
'                             start with ename = :empname',
'                           connect by prior empno = mgr',
'                             order siblings by deptno, ename;',
'BEGIN',
'  sys.htp.htmlopen;',
'  sys.htp.headopen;',
'  sys.htp.title(''''Hierarchical Department Report for Employee ''''||apex_escape.html(:empname));',
'  sys.htp.headclose;',
'  sys.htp.bodyopen;',
' ',
'  for l_employee in getemps ',
'  loop',
'      if l_employee.deptno != prevdeptno or prevdeptno is null then',
'          select dname, loc ',
'            into deptname, deptloc ',
'            from dept ',
'           where deptno = l_employee.deptno;',
'           ',
'          if prevdeptno is not null then',
'              sys.htp.print(''''</ul>'''');',
'          end if;',
'',
'          sys.htp.print(''''Department '''' || apex_escape.html(deptname) || '''' located in '''' || apex_escape.html(deptloc) || ''''<p/>'''');',
'          sys.htp.print(''''<ul>'''');',
'      end if;',
'',
'      sys.htp.print(''''<li>'''' || apex_escape.html(l_employee.ename) || '''', ''''  || apex_escape.html(l_employee.empno) || '''', '''' || ',
'                        apex_escape.html(l_employee.job) || '''', '''' || apex_escape.html(l_employee.sal) || ''''</li>'''');',
'',
'      prevdeptno := l_employee.deptno;',
'      total_rows := getemps%ROWCOUNT;',
'      ',
'  end loop;',
'',
'  if total_rows > 0 then',
'      sys.htp.print(''''</ul>'''');',
'  end if;',
'',
'  sys.htp.bodyclose;',
'  sys.htp.htmlclose;',
'END;'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query'',',
'      p_items_per_page => 7,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select empno "$uri", rn, empno, ename, job, hiredate, mgr, sal, comm, deptno',
'  from (',
'       select emp.*',
'            , row_number() over (order by empno) rn',
'         from emp',
'       ) tmp'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''version/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''version/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''plsql/block'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''begin ',
' sys.htp.p(''''{"version": "19.2"}'''');',
'end;'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/:id'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/:id'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query;type=single'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select * from emp ',
'where empno = :id'');',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/:id'',',
'      p_method         => ''PUT'',',
'      p_source_type    => ''plsql/block'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''begin',
'    update emp set ename = :ename, job = :job, hiredate = :hiredate, mgr = :mgr, sal = :sal, comm = :comm, deptno = :deptno',
'    where empno = :id;',
'    :status := 200;',
'    :location := :id;',
'exception',
'    when others then',
'        :status := 400;',
'end;'');',
'',
'  ORDS.DEFINE_PARAMETER(',
'      p_module_name        => ''oracle.example.hr'',',
'      p_pattern            => ''employees/:id'',',
'      p_method             => ''PUT'',',
'      p_name               => ''X-APEX-FORWARD'',',
'      p_bind_variable_name => ''location'',',
'      p_source_type        => ''HEADER'',',
'      p_param_type         => ''STRING'',',
'      p_access_method      => ''OUT'',',
'      p_comments           => NULL);',
'',
'  ORDS.DEFINE_PARAMETER(',
'      p_module_name        => ''oracle.example.hr'',',
'      p_pattern            => ''employees/:id'',',
'      p_method             => ''PUT'',',
'      p_name               => ''ID'',',
'      p_bind_variable_name => ''id'',',
'      p_source_type        => ''HEADER'',',
'      p_param_type         => ''STRING'',',
'      p_access_method      => ''IN'',',
'      p_comments           => NULL);',
'',
'  ORDS.DEFINE_PARAMETER(',
'      p_module_name        => ''oracle.example.hr'',',
'      p_pattern            => ''employees/:id'',',
'      p_method             => ''PUT'',',
'      p_name               => ''X-APEX-STATUS-CODE'',',
'      p_bind_variable_name => ''status'',',
'      p_source_type        => ''HEADER'',',
'      p_param_type         => ''INT'',',
'      p_access_method      => ''OUT'',',
'      p_comments           => NULL);',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empinfo/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empinfo/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''csv/query'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select * from emp'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query;type=feed'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select empno, ename from emp order by deptno, ename'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/:id'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/:id'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''csv/query'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select * from emp where empno = :id'');',
'',
'    ',
'    ',
'COMMIT;',
'',
'END;',
'!'';',
'',
'BEGIN',
'    -- Install EMP & DEPT Tables if none exist',
'    for c2 in (select null',
'                 from sys.dba_tables',
'                where owner = l_owner',
'                  and table_name in (''EMP'',''DEPT'') ) loop',
'        l_fnd := true;',
'        exit;',
'    end loop;',
'',
'    if l_fnd then',
'        -- Remove existing tables, to ensure examples work with clean seed data - bug #21153228',
'        wwv_flow_provisioning.remove_demo_tables( p_security_group_id => wwv_flow_security.g_security_group_id, p_schema => :P0_SCHEMA);',
'    end if;',
'    wwv_flow_provisioning.install_demo_tables( p_security_group_id => wwv_flow_security.g_security_group_id, p_schema => :P0_SCHEMA);',
'    --',
'    l_exec_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'                p_plsql_function  => l_service_definition,',
'                p_parse_as_schema => l_owner',
'            );',
'            ',
'END;',
'',
''))
,p_process_error_message=>'No se ha podido instalar el servicio RESTful de ejemplo.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(521637230858366434.4851)
,p_process_success_message=>'El servicio RESTful de ejemplo se ha instalado correctamente.'
);
end;
/
prompt --application/pages/page_00102
begin
wwv_flow_api.create_page(
 p_id=>102.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>unistr('Verificaci\00F3n de restablecimiento de servicio de ejemplo')
,p_page_mode=>'MODAL'
,p_step_title=>'Restablecer servicio de ejemplo'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(344911404961486242)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'350'
,p_dialog_width=>'600'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(865350638512614236.4851)
,p_plug_name=>'ACTIONS'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(967562983280037569.4851)
,p_plug_name=>'Advertencia '
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--horizontal'
,p_plug_template=>wwv_flow_api.id(410842408391417181.4851)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_lang.system_message_p(''REST_WS.RESET_SAMPLE_WARNING'');',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(865350727512614237.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(865350638512614236.4851)
,p_button_name=>'Cancel'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(865350850483614238.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(865350638512614236.4851)
,p_button_name=>'RESET_SERVICE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Restablecer servicio de ejemplo'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(865350908058614239.4851)
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(865351066425614240.4851)
,p_name=>'Close'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(865350727512614237.4851)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(865351141182614241.4851)
,p_event_id=>wwv_flow_api.id(865351066425614240.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(50135611810683253.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Reset Sample Service'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'   l_sample_name        varchar2(32767);',
'   l_exec_return        varchar2(32767);',
'   l_fnd                boolean := FALSE;',
'   l_owner              varchar2(255) := v(''P0_SCHEMA'');',
'   l_service_definition varchar2(32767) :=',
'q''!',
'BEGIN',
'  ORDS.DEFINE_MODULE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_base_path      => ''/hr/'',',
'      p_items_per_page => 25,',
'      p_status         => ''PUBLISHED'',',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsec/:empname'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsec/:empname'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select empno, ename, deptno, job from emp ',
'	where ((select job from emp where ename = :empname) IN (''''PRESIDENT'''', ''''MANAGER'''')) ',
'    OR  ',
'    (deptno = (select deptno from emp where ename = :empname)) ',
'order by deptno, ename',
''');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsecformat/:empname'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsecformat/:empname'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''plsql/block'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''DECLARE',
'  prevdeptno     number;',
'  total_rows     number;',
'  deptloc        varchar2(20);',
'  deptname       varchar2(20);',
'  ',
'  CURSOR         getemps is select * from emp ',
'                             start with ename = :empname',
'                           connect by prior empno = mgr',
'                             order siblings by deptno, ename;',
'BEGIN',
'  sys.htp.htmlopen;',
'  sys.htp.headopen;',
'  sys.htp.title(''''Hierarchical Department Report for Employee ''''||apex_escape.html(:empname));',
'  sys.htp.headclose;',
'  sys.htp.bodyopen;',
' ',
'  for l_employee in getemps ',
'  loop',
'      if l_employee.deptno != prevdeptno or prevdeptno is null then',
'          select dname, loc ',
'            into deptname, deptloc ',
'            from dept ',
'           where deptno = l_employee.deptno;',
'           ',
'          if prevdeptno is not null then',
'              sys.htp.print(''''</ul>'''');',
'          end if;',
'',
'          sys.htp.print(''''Department '''' || apex_escape.html(deptname) || '''' located in '''' || apex_escape.html(deptloc) || ''''<p/>'''');',
'          sys.htp.print(''''<ul>'''');',
'      end if;',
'',
'      sys.htp.print(''''<li>'''' || apex_escape.html(l_employee.ename) || '''', ''''  || apex_escape.html(l_employee.empno) || '''', '''' || ',
'                        apex_escape.html(l_employee.job) || '''', '''' || apex_escape.html(l_employee.sal) || ''''</li>'''');',
'',
'      prevdeptno := l_employee.deptno;',
'      total_rows := getemps%ROWCOUNT;',
'      ',
'  end loop;',
'',
'  if total_rows > 0 then',
'      sys.htp.print(''''</ul>'''');',
'  end if;',
'',
'  sys.htp.bodyclose;',
'  sys.htp.htmlclose;',
'END;'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query'',',
'      p_items_per_page => 7,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select empno "$uri", rn, empno, ename, job, hiredate, mgr, sal, comm, deptno',
'  from (',
'       select emp.*',
'            , row_number() over (order by empno) rn',
'         from emp',
'       ) tmp'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''version/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''version/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''plsql/block'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''begin ',
' sys.htp.p(''''{"version": "19.2"}'''');',
'end;'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/:id'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/:id'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query;type=single'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select * from emp ',
'where empno = :id'');',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/:id'',',
'      p_method         => ''PUT'',',
'      p_source_type    => ''plsql/block'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''begin',
'    update emp set ename = :ename, job = :job, hiredate = :hiredate, mgr = :mgr, sal = :sal, comm = :comm, deptno = :deptno',
'    where empno = :id;',
'    :status := 200;',
'    :location := :id;',
'exception',
'    when others then',
'        :status := 400;',
'end;'');',
'',
'  ORDS.DEFINE_PARAMETER(',
'      p_module_name        => ''oracle.example.hr'',',
'      p_pattern            => ''employees/:id'',',
'      p_method             => ''PUT'',',
'      p_name               => ''X-APEX-FORWARD'',',
'      p_bind_variable_name => ''location'',',
'      p_source_type        => ''HEADER'',',
'      p_param_type         => ''STRING'',',
'      p_access_method      => ''OUT'',',
'      p_comments           => NULL);',
'',
'  ORDS.DEFINE_PARAMETER(',
'      p_module_name        => ''oracle.example.hr'',',
'      p_pattern            => ''employees/:id'',',
'      p_method             => ''PUT'',',
'      p_name               => ''ID'',',
'      p_bind_variable_name => ''id'',',
'      p_source_type        => ''HEADER'',',
'      p_param_type         => ''STRING'',',
'      p_access_method      => ''IN'',',
'      p_comments           => NULL);',
'',
'  ORDS.DEFINE_PARAMETER(',
'      p_module_name        => ''oracle.example.hr'',',
'      p_pattern            => ''employees/:id'',',
'      p_method             => ''PUT'',',
'      p_name               => ''X-APEX-STATUS-CODE'',',
'      p_bind_variable_name => ''status'',',
'      p_source_type        => ''HEADER'',',
'      p_param_type         => ''INT'',',
'      p_access_method      => ''OUT'',',
'      p_comments           => NULL);',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empinfo/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empinfo/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''csv/query'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select * from emp'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query;type=feed'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select empno, ename from emp order by deptno, ename'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/:id'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/:id'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''csv/query'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select * from emp where empno = :id'');',
'',
'    ',
'    ',
'COMMIT;',
'',
'END;',
'!'';',
'',
'BEGIN',
'    -- Install EMP & DEPT Tables if none exist',
'    for c2 in (select null',
'                 from sys.dba_tables',
'                where owner = l_owner',
'                  and table_name in (''EMP'',''DEPT'') ) loop',
'        l_fnd := true;',
'        exit;',
'    end loop;',
'',
'    if l_fnd then',
'        -- Remove existing tables, to ensure examples work with clean seed data - bug #21153228',
'        wwv_flow_provisioning.remove_demo_tables( p_security_group_id => wwv_flow_security.g_security_group_id, p_schema=>:P0_SCHEMA);',
'    end if;',
'    --',
'    wwv_flow_provisioning.install_demo_tables( p_security_group_id => wwv_flow_security.g_security_group_id, p_schema=> :P0_SCHEMA);',
'    --',
'    -- delete existing service at UIR /hr/',
'    for x in (select c001 module_name',
'                from wwv_flow_collections',
'               where collection_name = ''ORDS_MODULES''',
'                 and c002 = ''/hr/'') ',
'    LOOP',
'    l_exec_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'                p_plsql_function  => ',
'''BEGIN ',
'    ORDS.DELETE_MODULE(p_module_name => ''''''||x.module_name||'''''');',
'    COMMIT;',
'END;'',',
'                p_parse_as_schema => l_owner);',
'    END LOOP; ',
'    -- Install sample service',
'    l_exec_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'                p_plsql_function  => l_service_definition,',
'                p_parse_as_schema => l_owner',
'            );',
'            ',
'END;',
'',
''))
,p_process_error_message=>'No se ha podido restablecer el servicio RESTful de ejemplo.<br/>#SQLERRM_TEXT#'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(865350850483614238.4851)
,p_process_success_message=>'El servicio RESTful de ejemplo se ha restablecido correctamente.'
);
end;
/
prompt --application/pages/page_00105
begin
wwv_flow_api.create_page(
 p_id=>105.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Atributos de esquema de ORDS'
,p_page_mode=>'MODAL'
,p_step_title=>'Atributos de esquema de ORDS'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(344911404961486242)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538579044595390057)
,p_dialog_height=>'350'
,p_dialog_width=>'600'
,p_dialog_chained=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(395806081109090650.4851)
,p_plug_name=>'Activar Esquema'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(411294717631027810.4851)
,p_plug_name=>'Actions'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noUI:a-ButtonRegion--accessibleTitle'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(411294685201027809.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(411294717631027810.4851)
,p_button_name=>'Cancel'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(411294516512027808.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(411294717631027810.4851)
,p_button_name=>'ENABLE_SCHEMA'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Guardar atributos de esquema'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(411295133235027814.4851)
,p_branch_name=>'Page 100'
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(411293837089027801.4851)
,p_name=>'P105_ENABLE_REST_ACCESS'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(395806081109090650.4851)
,p_item_default=>'Y'
,p_prompt=>'Activar Acceso RESTful'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Activa o desactiva el acceso a todos y cada uno de los servicios REST definidos en el esquema. La desactivaci\00F3n del acceso no afecta a la definici\00F3n de m\00F3dulos, sino que simplemente restringe el acceso.')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(411293975785027802.4851)
,p_name=>'P105_SCHEMA_ALIAS'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(395806081109090650.4851)
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
' 	l_alias_default wwv_flow_companies.path_prefix%TYPE;',
'',
'BEGIN ',
'',
'-- start with a NULL default',
'l_alias_default := null;',
'',
'-- IF and only IF we are working with the default schema ',
'if :P0_SCHEMA = wwv_flow_user_api.get_default_schema then ',
'	-- get the current value of he path_prefix ',
'	select lower(path_prefix)',
'	  into l_alias_default',
'	  from wwv_flow_companies ',
'	 where provisioning_company_id = wwv_flow_api.get_security_group_id;',
'end if;',
'',
'-- If the value is still null then either this is not the default schema or the PATH_PREFIX is not set.',
'-- Set the default to the lower case schema name.',
'if l_alias_default is null then ',
'    l_alias_default := lower(:P0_SCHEMA);',
'end if;',
'',
'RETURN l_alias_default;',
'',
'END;',
''))
,p_item_default_type=>'PLSQL_FUNCTION_BODY'
,p_prompt=>'Alias de Esquema'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>50
,p_cMaxlength=>266
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Define el alias <em>sensible a may\00FAsculas/min\00FAsculas</em> del esquema actual que se utilizar\00E1 en la formaci\00F3n de la URL que hace referencia a servicios RESTful del esquema.<br/>'),
'<br/>',
unistr('<B>Oracle recomienda que el alias de esquema sea diferente del nombre de esquema para garantizar la protecci\00F3n contra posibles ataques de inyecci\00F3n SQL o scripts de sitios.<br/>'),
'<br/>',
'Ejemplo: <br/><br/>',
'<pre>',
'http://server.com/ords/<B>mySchema</B>/hr/employees/{ID}',
'|________________|____|________|_|_________|____|',
'           |        |     |     |     |      |',
'           |        |     |     |     |       - Variable de enlace',
'           |        |     |     |     | ',
'           |        |     |     |      - Plantilla de URI',
'           |        |     |     |',
unistr('           |        |     |      - Ruta de acceso base de m\00F3dulo'),
'           |        |     |',
'           |        |      - <B>Alias de esquema</B>',
'           |        |      ',
'           |         - Alias de ORDS',
'           |               ',
'            - URL del servidor               ',
' </pre>',
'',
unistr('Nota: Al editar el alias para el esquema por defecto del espacio de trabajo, el prefijo de ruta de acceso en el nivel del espacio de trabajo se definir\00E1 con el mismo valor. Esto afectar\00E1 a la URL de cualquier servicio RESTful basado en APEX que ya ha')
||'ya definido.'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(411294086525027803.4851)
,p_name=>'P105_AUTH_REQUIRED'
,p_is_required=>true
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(395806081109090650.4851)
,p_item_default=>'N'
,p_prompt=>unistr('Autorizaci\00F3n requerida para el acceso a metadatos')
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Controla si Oracle REST Data Services debe solicitar la autorizaci\00F3n del usuario antes de permitir el acceso al cat\00E1logo de metadatos de ORDS del esquema.')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(411294135265027804.4851)
,p_name=>'AUTH_NAME'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(395806081109090650.4851)
,p_item_default=>'Required Role Name: oracle.dbtools.role.autorest.&P0_SCHEMA.'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(619048141801969827.4851)
,p_name=>'P105_INSTALL_SAMPLE_SERVICE'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(395806081109090650.4851)
,p_item_default=>'Y'
,p_prompt=>'Instalar servicio de ejemplo'
,p_display_as=>'NATIVE_YES_NO'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''X''',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_SCHEMAS''',
'   and c001 = :P0_SCHEMA'))
,p_display_when_type=>'NOT_EXISTS'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Controla si el servicio RESTful oracle.example.hr de ejemplo se instalar\00E1. ')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(619048356251969829.4851)
,p_name=>'P105_DEFAULT_SCHEMA_WARNING'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(395806081109090650.4851)
,p_source=>'wwv_flow_lang.system_message(''APEX.REST.DEFAULT_SCHEMA_WARNING'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P0_SCHEMA = wwv_flow_user_api.get_default_schema then ',
'   return true;',
'else',
'   return false;',
'end if;'))
,p_display_when_type=>'FUNCTION_BODY'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(865351598258614245.4851)
,p_validation_name=>'Check for unique PATH_PREFIX'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'-- Only run this check if this is the default schema',
'if :P0_SCHEMA = wwv_flow_user_api.get_default_schema then ',
'    -- First check to see if there is an APEX PATH_PREFIX that already exists.',
'    for c1 in (select 1',
'                 from wwv_flow_companies',
'                where path_prefix = upper(:P105_SCHEMA_ALIAS)',
'                 and provisioning_company_id <> :flow_security_group_id ) loop',
'       return wwv_flow_lang.system_message(''REST_WS.DUPLICATE_PATH_PREFIX'') ;',
'       exit;',
'    end loop;',
'end if;',
'',
'return null;',
'',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_when_button_pressed=>wwv_flow_api.id(411294516512027808.4851)
,p_associated_item=>wwv_flow_api.id(.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(411294202145027805.4851)
,p_name=>'Hide/Show Auth Name'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P105_AUTH_REQUIRED'
,p_condition_element=>'P105_AUTH_REQUIRED'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(411294346994027806.4851)
,p_event_id=>wwv_flow_api.id(411294202145027805.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'AUTH_NAME'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(411294476501027807.4851)
,p_event_id=>wwv_flow_api.id(411294202145027805.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'AUTH_NAME'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(411294875777027811.4851)
,p_name=>'Close'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(411294685201027809.4851)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(411294997347027812.4851)
,p_event_id=>wwv_flow_api.id(411294875777027811.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(54184746281062237.4851)
,p_name=>'toLowerCase'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P105_SCHEMA_ALIAS'
,p_bind_type=>'bind'
,p_bind_event_type=>'keyup'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(54184828101062238.4851)
,p_event_id=>wwv_flow_api.id(54184746281062237.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P105_SCHEMA_ALIAS'
,p_attribute_01=>'$x(''P105_SCHEMA_ALIAS'').value = $v(''P105_SCHEMA_ALIAS'').toLowerCase();'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(411295047939027813.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Enable Schema'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_enable_access varchar2(20);',
'    l_auth_required  varchar2(20);',
'    l_security_group_id number;',
'',
'BEGIN ',
'select decode(:P105_ENABLE_REST_ACCESS, ''Y'',''TRUE'',''FALSE''),',
'       decode(:P105_AUTH_REQUIRED, ''Y'',''TRUE'',''FALSE'')',
'  into l_enable_access,',
'       l_auth_required',
'  from sys.dual;',
'',
'wwv_flow_rest_ws.enable_schema (p_schema => :P0_SCHEMA, ',
'                                p_enable_access => l_enable_access, ',
'                                p_schema_alias => lower(:P105_SCHEMA_ALIAS), ',
'                                p_auth_required => l_auth_required);',
'--',
'-- If this is the default schema for the workspace, change the workspace level Base Path to match the schema alias.',
'--',
'if :P0_SCHEMA = wwv_flow_user_api.get_default_schema then ',
'    ',
'    update wwv_flow_companies ',
'       set path_prefix = :P105_SCHEMA_ALIAS',
'     where provisioning_company_id = wwv_flow_api.get_security_group_id;',
'   ',
'end if;',
'',
'EXCEPTION',
'    WHEN DUP_VAL_ON_INDEX THEN',
'    apex_error.add_error(',
'      p_message => wwv_flow_lang.system_message(''REST_WS.DUPLICATE_SCHEMA_ALIAS'')',
'    , p_display_location => apex_error.c_inline_in_notification',
'    );',
'',
'',
'END;                             '))
,p_process_error_message=>'No se ha podido activar el esquema para los servicios RESTful de ORDS.<br/>#SQLERRM#'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(411294516512027808.4851)
,p_process_success_message=>'Esquema activado para el uso con servicios RESTful de ORDS '
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1964389068403904.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'install Sample Service'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'   l_exec_return        varchar2(32767);',
'   l_fnd                boolean := FALSE;',
'   l_owner              varchar2(255) := v(''P0_SCHEMA'');',
'   l_service_definition varchar2(32767) :=',
'q''!',
'BEGIN',
'  ORDS.DEFINE_MODULE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_base_path      => ''/hr/'',',
'      p_items_per_page => 25,',
'      p_status         => ''PUBLISHED'',',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsec/:empname'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsec/:empname'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select empno, ename, deptno, job from emp ',
'	where ((select job from emp where ename = :empname) IN (''''PRESIDENT'''', ''''MANAGER'''')) ',
'    OR  ',
'    (deptno = (select deptno from emp where ename = :empname)) ',
'order by deptno, ename',
''');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsecformat/:empname'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empsecformat/:empname'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''plsql/block'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''DECLARE',
'  prevdeptno     number;',
'  total_rows     number;',
'  deptloc        varchar2(20);',
'  deptname       varchar2(20);',
'  ',
'  CURSOR         getemps is select * from emp ',
'                             start with ename = :empname',
'                           connect by prior empno = mgr',
'                             order siblings by deptno, ename;',
'BEGIN',
'  sys.htp.htmlopen;',
'  sys.htp.headopen;',
'  sys.htp.title(''''Hierarchical Department Report for Employee ''''||apex_escape.html(:empname));',
'  sys.htp.headclose;',
'  sys.htp.bodyopen;',
' ',
'  for l_employee in getemps ',
'  loop',
'      if l_employee.deptno != prevdeptno or prevdeptno is null then',
'          select dname, loc ',
'            into deptname, deptloc ',
'            from dept ',
'           where deptno = l_employee.deptno;',
'           ',
'          if prevdeptno is not null then',
'              sys.htp.print(''''</ul>'''');',
'          end if;',
'',
'          sys.htp.print(''''Department '''' || apex_escape.html(deptname) || '''' located in '''' || apex_escape.html(deptloc) || ''''<p/>'''');',
'          sys.htp.print(''''<ul>'''');',
'      end if;',
'',
'      sys.htp.print(''''<li>'''' || apex_escape.html(l_employee.ename) || '''', ''''  || apex_escape.html(l_employee.empno) || '''', '''' || ',
'                        apex_escape.html(l_employee.job) || '''', '''' || apex_escape.html(l_employee.sal) || ''''</li>'''');',
'',
'      prevdeptno := l_employee.deptno;',
'      total_rows := getemps%ROWCOUNT;',
'      ',
'  end loop;',
'',
'  if total_rows > 0 then',
'      sys.htp.print(''''</ul>'''');',
'  end if;',
'',
'  sys.htp.bodyclose;',
'  sys.htp.htmlclose;',
'END;'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query'',',
'      p_items_per_page => 7,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select empno "$uri", rn, empno, ename, job, hiredate, mgr, sal, comm, deptno',
'  from (',
'       select emp.*',
'            , row_number() over (order by empno) rn',
'         from emp',
'       ) tmp'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''version/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''version/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''plsql/block'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''begin ',
' sys.htp.p(''''{"version": "19.2"}'''');',
'end;'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/:id'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/:id'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query;type=single'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select * from emp ',
'where empno = :id'');',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employees/:id'',',
'      p_method         => ''PUT'',',
'      p_source_type    => ''plsql/block'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''begin',
'    update emp set ename = :ename, job = :job, hiredate = :hiredate, mgr = :mgr, sal = :sal, comm = :comm, deptno = :deptno',
'    where empno = :id;',
'    :status := 200;',
'    :location := :id;',
'exception',
'    when others then',
'        :status := 400;',
'end;'');',
'',
'  ORDS.DEFINE_PARAMETER(',
'      p_module_name        => ''oracle.example.hr'',',
'      p_pattern            => ''employees/:id'',',
'      p_method             => ''PUT'',',
'      p_name               => ''X-APEX-FORWARD'',',
'      p_bind_variable_name => ''location'',',
'      p_source_type        => ''HEADER'',',
'      p_param_type         => ''STRING'',',
'      p_access_method      => ''OUT'',',
'      p_comments           => NULL);',
'',
'  ORDS.DEFINE_PARAMETER(',
'      p_module_name        => ''oracle.example.hr'',',
'      p_pattern            => ''employees/:id'',',
'      p_method             => ''PUT'',',
'      p_name               => ''ID'',',
'      p_bind_variable_name => ''id'',',
'      p_source_type        => ''HEADER'',',
'      p_param_type         => ''STRING'',',
'      p_access_method      => ''IN'',',
'      p_comments           => NULL);',
'',
'  ORDS.DEFINE_PARAMETER(',
'      p_module_name        => ''oracle.example.hr'',',
'      p_pattern            => ''employees/:id'',',
'      p_method             => ''PUT'',',
'      p_name               => ''X-APEX-STATUS-CODE'',',
'      p_bind_variable_name => ''status'',',
'      p_source_type        => ''HEADER'',',
'      p_param_type         => ''INT'',',
'      p_access_method      => ''OUT'',',
'      p_comments           => NULL);',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empinfo/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''empinfo/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''csv/query'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select * from emp'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''json/query;type=feed'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select empno, ename from emp order by deptno, ename'');',
'',
'  ORDS.DEFINE_TEMPLATE(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/:id'',',
'      p_priority       => 0,',
'      p_etag_type      => ''HASH'',',
'      p_etag_query     => NULL,',
'      p_comments       => NULL);',
'',
'  ORDS.DEFINE_HANDLER(',
'      p_module_name    => ''oracle.example.hr'',',
'      p_pattern        => ''employeesfeed/:id'',',
'      p_method         => ''GET'',',
'      p_source_type    => ''csv/query'',',
'      p_items_per_page => 25,',
'      p_mimes_allowed  => '''',',
'      p_comments       => NULL,',
'      p_source         => ',
'''select * from emp where empno = :id'');',
'',
'    ',
'    ',
'COMMIT;',
'',
'END;',
'!'';',
'',
'BEGIN',
'    -- Install EMP & DEPT Tables if none exist',
'    for c2 in (select null',
'                 from sys.dba_tables',
'                where owner = l_owner',
'                  and table_name in (''EMP'',''DEPT'') ) loop',
'        l_fnd := true;',
'        exit;',
'    end loop;',
'',
'    if l_fnd then',
'        -- Remove existing tables, to ensure examples work with clean seed data - bug #21153228',
'        wwv_flow_provisioning.remove_demo_tables( p_security_group_id => wwv_flow_security.g_security_group_id, p_schema => :P0_SCHEMA);',
'    end if;',
'    wwv_flow_provisioning.install_demo_tables( p_security_group_id => wwv_flow_security.g_security_group_id, p_schema => :P0_SCHEMA);',
'    --',
'    l_exec_return := wwv_flow_dynamic_exec.get_plsql_func_result_varchar2(',
'                p_plsql_function  => l_service_definition,',
'                p_parse_as_schema => l_owner',
'            );',
'            ',
'END;',
'',
''))
,p_process_error_message=>'No se ha podido instalar el servicio RESTful de ejemplo.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P105_INSTALL_SAMPLE_SERVICE'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'Y'
,p_process_success_message=>' y el servicio RESTful de ejemplo se ha instalado correctamente.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(411295716068027820.4851)
,p_process_sequence=>10
,p_process_point=>'BEFORE_BOX_BODY'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fetch row for ORDS_SCHEMAS Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'    for c in (select c003 schema_alias, ',
'                     c004 status, ',
'                     c005 auto_rest_auth',
'                from wwv_flow_collections ',
'               where collection_name = ''ORDS_SCHEMAS''',
'                 and c001 = :P0_SCHEMA)',
'    LOOP',
'    if c.status = ''ENABLED'' then ',
'        :P105_ENABLE_REST_ACCESS := ''Y'';',
'    else ',
'        :P105_ENABLE_REST_ACCESS := ''N'';',
'    end if;',
'    --',
'    :P105_SCHEMA_ALIAS := lower(nvl(c.schema_alias, :P0_SCHEMA));',
'    --',
'    if c.auto_rest_auth = ''ENABLED'' then ',
'        :P105_AUTH_REQUIRED := ''Y'';',
'    else',
'        :P105_AUTH_REQUIRED := ''N'';',
'    end if;',
'    ',
'    END LOOP;',
'END;',
'   '))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00107
begin
wwv_flow_api.create_page(
 p_id=>107.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Anular registro de esquema'
,p_page_mode=>'MODAL'
,p_step_title=>'Anular registro de esquema'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(344911404961486242)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538579044595390057)
,p_dialog_height=>'350'
,p_dialog_width=>'600'
,p_dialog_chained=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(917428488645386798.4851)
,p_plug_name=>'Advertencia '
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--horizontal'
,p_plug_template=>wwv_flow_api.id(410842408391417181.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_lang.system_message_p(''REST_WS.DROP_REST_WARNING'');',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(932917125167323958.4851)
,p_plug_name=>'Actions'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noUI:a-ButtonRegion--accessibleTitle'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(521623582306296155.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(932917125167323958.4851)
,p_button_name=>'Cancel'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(521623103706296154.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(932917125167323958.4851)
,p_button_name=>'DREGISTER_SCHEMA'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Anular registro de esquema'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(521629030825296177.4851)
,p_branch_name=>'Page 100'
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(521627533825296176.4851)
,p_name=>'Hide/Show Auth Name'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P107_AUTH_REQUIRED'
,p_condition_element=>'P107_AUTH_REQUIRED'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(521628056777296176.4851)
,p_event_id=>wwv_flow_api.id(521627533825296176.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'AUTH_NAME'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(521628597446296177.4851)
,p_event_id=>wwv_flow_api.id(521627533825296176.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'AUTH_NAME'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(521626604079296175.4851)
,p_name=>'Close'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(521623582306296155.4851)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(521627100322296176.4851)
,p_event_id=>wwv_flow_api.id(521626604079296175.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(521625822919296174.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'DROP_SCHEMA'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN',
'    wwv_flow_rest_ws.drop_rest(:P0_SCHEMA);',
'',
'-- Clear out collections so they are empty ',
'   wwv_flow_collection.delete_collection(''ORDS_SCHEMAS'');',
'   wwv_flow_collection.delete_collection(''ORDS_MODULES'');',
'   wwv_flow_collection.delete_collection(''ORDS_TEMPLATES'');',
'   wwv_flow_collection.delete_collection(''ORDS_HANDLERS'');',
'   wwv_flow_collection.delete_collection(''ORDS_PARAMETERS'');',
'   wwv_flow_collection.delete_collection(''ORDS_PRIVILEGES'');',
'   wwv_flow_collection.delete_collection(''ORDS_ROLES'');',
'   wwv_flow_collection.delete_collection(''ORDS_ENABLED_OBJECTS'');',
'   wwv_flow_collection.delete_collection(''ORDS_PRIVILEGE_ROLES'');',
'   wwv_flow_collection.delete_collection(''ORDS_PRIVILEGE_MODULES'');',
'   wwv_flow_collection.delete_collection(''ORDS_PRIVILEGE_MAPPINGS'');',
'-- ',
'  :P105_SCHEMA_ALIAS := null;',
'END;'))
,p_process_error_message=>'No se ha podido desactivar el esquema.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(521623103706296154.4851)
,p_process_success_message=>'Esquema desactivado para el uso con servicios RESTful de ORDS.'
);
end;
/
prompt --application/pages/page_00108
begin
wwv_flow_api.create_page(
 p_id=>108.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Exportar servicios RESTful de ORDS'
,p_step_title=>'Exportar servicios RESTful de ORDS'
,p_reload_on_submit=>'A'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(344911404961486242)
,p_step_template=>wwv_flow_api.id(719674703062933090.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538579044595390057)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(521634858019366410.4851)
,p_plug_name=>'Exportar servicios RESTful de ORDS'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719731990154942810.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(928751631834883775.4851)
,p_plug_name=>'Export RESTful Service Definitions'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:800px;"'
,p_plug_template=>wwv_flow_api.id(719731261318942809.4851)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
''))
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_header=>'Exporte los metadatos del servicio RESTful basado en ORDS a un archivo con formato de script SQL. Puede importar el script SQL en esta instancia o en otra instancia compatible de ORDS.'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1465859648625102030.4851)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noUI:a-ButtonRegion--accessibleTitle'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(532943232357778080.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1465859648625102030.4851)
,p_button_name=>'Cancel'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP,108::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(532942855566778079.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1465859648625102030.4851)
,p_button_name=>'EXPORT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Exportar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(521634672804366408.4851)
,p_name=>'P108_MODULES'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(928751631834883775.4851)
,p_prompt=>'Servicio RESTful'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'from ',
'(select 1 ord1, upper(c001) ord2, c001 d, c001 r ',
'  from wwv_flow_collections ',
' where collection_name = ''ORDS_MODULES''',
'union ',
'select 0 ord1, ''ALL SERVICES'' ord2, ''All Services'' d ,''ALL'' r',
'  from sys.dual',
'order by ord1 asc, ord2 asc)'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'Seleccionar un servicio'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(521634799000366409.4851)
,p_name=>'P108_MODULE_COUNT'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(928751631834883775.4851)
,p_prompt=>unistr('N\00FAmero de servicios RESTful disponibles para su exportaci\00F3n')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*)',
'from wwv_flow_collections',
'where collection_name = ''ORDS_MODULES'''))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Identifica el n\00FAmero de servicios RESTful definidos en el esquema actual.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(521636728407366429.4851)
,p_name=>'P108_SCHEMA'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(928751631834883775.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Esquema'
,p_source=>'P0_SCHEMA'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(532950998098899104.4851)
,p_name=>'P108_FILE_CHARSET'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(928751631834883775.4851)
,p_item_default=>'nvl(lower(trim(sys.owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))),''utf-8'')'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Juego de Caracteres de Archivo:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'I18N_IANA_CHARSET'
,p_lov=>'.'||wwv_flow_api.id(1671084505895948418.4851)||'.'
,p_cattributes_element=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('El archivo de exportaci\00F3n se codificar\00E1 con el juego de caracteres especificado.')
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(865350335067614233.4851)
,p_name=>'P108_INCLUDE_ENABLE_SCHEMA'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(928751631834883775.4851)
,p_item_default=>'Y'
,p_prompt=>'Incluir Activar esquema'
,p_display_as=>'NATIVE_YES_NO'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if (wwv_flow_rest_ws.ords_is_183_plus(wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema)) = ''TRUE'') then ',
'    RETURN TRUE;',
'else',
'    RETURN FALSE;',
'end if;'))
,p_display_when_type=>'FUNCTION_BODY'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Exporta la definici\00F3n de Activar esquema. Activar esquema controla si el acceso a Oracle REST Data Services est\00E1 habilitado para el esquema u objeto espec\00EDfico.')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(865350453730614234.4851)
,p_name=>'P108_INCLUDE_PRIVILEGES'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(928751631834883775.4851)
,p_item_default=>'Y'
,p_prompt=>'Incluir privilegios'
,p_display_as=>'NATIVE_YES_NO'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if (wwv_flow_rest_ws.ords_is_183_plus(wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema)) = ''TRUE'') then ',
'    RETURN TRUE;',
'else',
'    RETURN FALSE;',
'end if;'))
,p_display_when_type=>'FUNCTION_BODY'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Exporta las definiciones de privilegios asociadas al m\00F3dulo (incluye m\00F3dulo protegido, roles y patrones de recursos).')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(521634388040366405.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'DOWNLOAD'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_clob                     clob;',
'    l_str_length               pls_integer;',
'    l_str                      varchar2(32767);',
'    l_offset                   pls_integer := 1;',
'    l_include_enable_schema    varchar2(10);',
'    l_include_privileges       varchar2(20);',
'',
'BEGIN',
'    l_clob := NULL;',
'    --',
'    if :P108_INCLUDE_ENABLE_SCHEMA = ''Y'' THEN ',
'        l_include_enable_schema := ''TRUE'';',
'    else ',
'        l_include_enable_schema := ''FALSE'';',
'    end if;',
'    --',
'    if :P108_INCLUDE_PRIVILEGES = ''Y'' THEN ',
'        l_include_privileges := ''TRUE'';',
'    else',
'        l_include_privileges := ''FALSE'';',
'    end if;',
'    --',
'    if :P108_MODULES = ''ALL'' then',
'      if (wwv_flow_rest_ws.ords_is_183_plus(wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema)) = ''TRUE'') then ',
'        l_clob := wwv_flow_dynamic_exec.get_plsql_func_result_clob(',
'            p_plsql_function    => ''',
'        BEGIN',
'            return ords_metadata.ords_export.export_schema(p_include_enable_schema => ''||l_include_enable_schema||'', p_include_privs => ''||l_include_privileges||'');',
'        END;'',',
'            p_parse_as_schema   => nvl(:P0_SCHEMA,wwv_flow_user_api.get_default_schema));',
'',
'      else ',
'        l_clob := wwv_flow_dynamic_exec.get_plsql_func_result_clob(',
'            p_plsql_function    => ''',
'        BEGIN',
'            return ords_metadata.ords_export.export_schema;',
'        END;'',',
'            p_parse_as_schema   => nvl(:P0_SCHEMA,wwv_flow_user_api.get_default_schema));',
'      end if;',
'    else ',
'      if (wwv_flow_rest_ws.ords_is_183_plus(wwv_flow_rest_ws.get_ords_version(wwv_flow_user_api.get_default_schema)) = ''TRUE'') then',
'        l_clob := wwv_flow_dynamic_exec.get_plsql_func_result_clob(',
'            p_plsql_function    => ''',
'        BEGIN',
'            return ords_metadata.ords_export.export_module(p_module_name => ''''''||:P108_MODULES||'''''', p_include_enable_schema => ''||l_include_enable_schema||'', p_include_privs => ''||l_include_privileges||'');',
'        END;'',',
'            p_parse_as_schema   => nvl(:P0_SCHEMA,wwv_flow_user_api.get_default_schema));',
'      else',
'        l_clob := wwv_flow_dynamic_exec.get_plsql_func_result_clob(',
'            p_plsql_function    => ''',
'        BEGIN',
'            return ords_metadata.ords_export.export_module(p_module_name => ''''''||:P108_MODULES||'''''');',
'        END;'',',
'            p_parse_as_schema   => nvl(:P0_SCHEMA,wwv_flow_user_api.get_default_schema));',
'      end if;',
'    end if;',
'    --',
'',
'    sys.htp.init;',
'    wwv_flow.g_page_text_generated   := true;',
'    wwv_flow.g_unrecoverable_error   := true;',
'',
'    wwv_flow_utilities.print_download_header(',
'        p_mime_type       => ''application/x-sql'',',
'        p_file_name       => ''ORDS_REST_''||:P0_SCHEMA||''_''||:P108_MODULES||''_''||to_char(sysdate, ''yyyy_mm_dd'')||''.sql'',',
'        p_is_attachment   => true);',
'',
'    sys.owa_util.http_header_close;',
'    ',
'    l_str_length  := nvl(sys.dbms_lob.getlength(l_clob),0);',
'    LOOP',
'        l_offset   := l_offset + nvl(length(l_str),0);',
'        EXIT WHEN l_offset >= l_str_length;',
'        l_str := sys.dbms_lob.substr(l_clob,4000,l_offset);',
'        sys.htp.prn(l_str);',
'    END LOOP;',
'',
' END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(532942855566778079.4851)
);
end;
/
prompt --application/pages/page_00109
begin
wwv_flow_api.create_page(
 p_id=>109.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Importar servicios RESTful de ORDS'
,p_step_title=>'Importar servicios RESTful de ORDS'
,p_reload_on_submit=>'A'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(344911404961486242)
,p_step_template=>wwv_flow_api.id(719674703062933090.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538579044595390057)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1054917940458899121.4851)
,p_plug_name=>'Importar servicios RESTful de ORDS'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719731990154942810.4851)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1462034714274416486.4851)
,p_plug_name=>'Import RESTful Service Definitions'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:800px;"'
,p_plug_template=>wwv_flow_api.id(719731261318942809.4851)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
''))
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_header=>'Importe las definiciones de servicio RESTful basado en ORDS desde un script generado por SQL Developer o &PRODUCT_NAME..'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1999142731064634741.4851)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noUI:a-ButtonRegion--accessibleTitle'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(533284472661532714.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1999142731064634741.4851)
,p_button_name=>'Cancel'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP,108::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(533284064988532714.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1999142731064634741.4851)
,p_button_name=>'IMPORT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Importar'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(521636612133366428.4851)
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP,109::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(521636853113366430.4851)
,p_name=>'P109_SCHEMA'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1462034714274416486.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Esquema'
,p_source=>'P0_SCHEMA'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(533286069458532717.4851)
,p_name=>'P109_FILE'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1462034714274416486.4851)
,p_prompt=>'Archivo a Importar'
,p_display_as=>'NATIVE_FILE'
,p_cSize=>30
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'APEX_APPLICATION_TEMP_FILES'
,p_attribute_09=>'SESSION'
,p_attribute_10=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(533286474521532717.4851)
,p_name=>'P109_FILE_CHARSET'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1462034714274416486.4851)
,p_item_default=>'nvl(lower(trim(sys.owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))),''utf-8'')'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Juego de Caracteres de Archivo:'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'I18N_IANA_CHARSET'
,p_lov=>'.'||wwv_flow_api.id(1671084505895948418.4851)||'.'
,p_lov_display_null=>'YES'
,p_cHeight=>1
,p_cattributes_element=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('El archivo de exportaci\00F3n se codificar\00E1 con el juego de caracteres especificado.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(521636367736366425.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check PRIV'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_api.check_priv (',
'    p_schema => :P0_SCHEMA',
'    );'))
,p_process_error_message=>'El esquema seleccionado no incluye privilegios.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(521636566576366427.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check Length of Script'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_length number;',
'BEGIN',
'',
'select dbms_lob.getlength(blob_content)',
'      into l_length',
'      from wwv_flow_file_objects$',
'     where name = :P109_FILE;',
'--',
'IF l_length > 32767 then ',
'   -- Delete the script so it doesn''t hang around',
'   delete from wwv_flow_file_objects$',
'    where name = :P109_FILE;',
'   -- Raise an error to the user.',
'   raise_application_error( -20850, wwv_flow_lang.system_message(''REST_WS.SCRIPT_TOO_LONG''));',
'END IF;',
'END;',
'',
''))
,p_process_error_message=>'#SQLERRM_TEXT#'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_type=>'NEVER'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(54184980787062239.4851)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check if Script is APEX EXPORT'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_blob blob;',
'    l_clob clob;',
'BEGIN',
'    -- Get the file content to execute.',
'    select blob_content',
'      into l_blob',
'      from wwv_flow_file_objects$',
'     where name = :P109_FILE;',
'    -- Convert the BLOB to a CLOB using the characterset chosen',
'    l_clob := wwv_flow_utilities.blob_to_clob (',
'                          p_blob    => l_blob,',
'                          p_charset => :P109_CHARSET );',
'',
'   if instr(l_clob,''wwv_flow_api'',1,1) > 0 then ',
'       raise_application_error( -20851, wwv_flow_lang.system_message(''REST_WS.WRONG_SCRIPT_TYPE''));',
'    END IF;',
'END;',
'',
''))
,p_process_error_message=>'#SQLERRM_TEXT#'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(533294511104607661.4851)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'UPLOAD AND EXECUTE'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_clob    clob := empty_clob;',
'    l_blob    blob;',
'    l_result  varchar2(32767);',
'BEGIN',
'    -- Get the file content to execute.',
'    select blob_content',
'      into l_blob',
'      from wwv_flow_file_objects$',
'     where name = :P109_FILE;',
'    -- Convert the BLOB to a CLOB using the characterset chosen',
'    l_clob := wwv_flow_utilities.blob_to_clob (',
'                          p_blob    => l_blob,',
'                          p_charset => :P109_CHARSET );',
'    -- Strip Trailing slash from the end of the file or it won''t execute.',
'    l_clob := rtrim (l_clob, ''/ '');',
'    -- Execut the script using the selected Parse As Schema',
'    l_result := wwv_flow_rest_ws.run_plsql_as_parse_as_exec(',
'            p_code     => l_clob,',
'            p_parse_as => nvl(:P0_SCHEMA,wwv_flow_user_api.get_default_schema));',
'   -- Delete uploaded file from wwv_flow_file_objects$',
'   delete from wwv_flow_file_objects$',
'    where name = :P109_FILE;',
'',
'END;'))
,p_process_error_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('No se ha podido procesar la importaci\00F3n.<BR/>'),
'#SQLERRM_TEXT#'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(533284064988532714.4851)
,p_process_success_message=>'Los servicios RESTful de ORDS se han importado correctamente.'
);
end;
/
prompt --application/pages/page_00110
begin
wwv_flow_api.create_page(
 p_id=>110.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>unistr('M\00F3dulos ORDS')
,p_step_title=>unistr('M\00F3dulos de servicio RESTful de ORDS')
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(344911404961486242)
,p_step_template=>wwv_flow_api.id(754939123056928433.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538579044595390057)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(243332167743719621.4851)
,p_plug_name=>'Leyenda'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</br><div style="line-height:25px">',
'&nbsp;&nbsp;&nbsp;&nbsp;<b>Leyenda:</b>',
unistr('&nbsp;&nbsp;&nbsp;&nbsp;<span class="a-Icon icon-status-success" aria-hidden="true" style="background-color:#60ccb5;color:#fff;border-radius:26px;width:26px;height:26px;padding:5px;"></span> M\00F3dulo totalmente protegido por un privilegio '),
unistr('&nbsp;&nbsp;&nbsp;&nbsp;<span class="a-Icon icon-status-warning" aria-hidden="true" style="background-color:#F4d26f;color:#fff;border-radius:26px;width:26px;height:26px;padding:4px;"></span> M\00F3dulo parcialmente protegido por un privilegio '),
unistr(' &nbsp;&nbsp;&nbsp;&nbsp;<span class="a-Icon icon-status-failure" aria-hidden="true" style="background-color:#ec7a71;color:#fff;border-radius:26px;width:26px;height:26px;padding:5px;"></span> M\00F3dulo no protegido por ning\00FAn privilegio '),
'</div>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(345304595186156444.4851)
,p_plug_name=>unistr('M\00F3dulos RESTful de ORDS')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select n001 id,',
'       c001 name, ',
'       c002 uri_prefix,',
'       n002 items_per_page,',
'       c003 published_status,',
'       case when length(c004) > 50 then ',
'                substr(c004,1,50)||'' ...''',
'            else ',
'                 c004',
'            end comments,',
'       c005 pre_hook,',
'       c006 origins_allowed,',
'       n005 schema_id,',
'       c049 created_by,',
'       d001 created_on,',
'       c050 updated_by,',
'       d002 updated_on, ',
'       case  wwv_flow_rest_ws.module_is_protected(n001)',
'       when ''F'' then ''<span class="a-Icon icon-status-success" aria-hidden="true" style="background-color:#60ccb5;color:#fff;border-radius:26px;width:26px;height:26px;padding:5px;"></span>''',
'       when ''P'' then ''<span class="a-Icon icon-status-warning" aria-hidden="true" style="background-color:#F4d26f;color:#fff;border-radius:26px;width:26px;height:26px;padding:4px;"></span>''',
'       when ''N'' then ''<span class="a-Icon icon-status-failure" aria-hidden="true" style="background-color:#ec7a71;color:#fff;border-radius:26px;width:26px;height:26px;padding:5px;"></span>''',
'       end protected, ',
'       wwv_flow_rest_ws.module_is_protected(n001) protected_filter',
'from wwv_flow_collections ',
'where collection_name = ''ORDS_MODULES'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(345304742814156446.4851)
,p_max_row_count=>'1000000'
,p_no_data_found_message=>unistr('Actualmente, no hay ning\00FAn m\00F3dulo RESTful definido para el esquema seleccionado.')
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_owner=>'DOUG'
,p_internal_uid=>345304742814156446
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(345304827635156447.4851)
,p_db_column_name=>'ID'
,p_display_order=>10
,p_column_identifier=>'A'
,p_column_label=>'Identificador'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(345304993730156448.4851)
,p_db_column_name=>'NAME'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>'Nombre'
,p_column_link=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:120:P120_MODULE_ID,P0_SELECTED_NODE:#ID#,MM#ID#'
,p_column_linktext=>'#NAME#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(345305017259156449.4851)
,p_db_column_name=>'URI_PREFIX'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>'Prefijo de URI'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(345305179932156450.4851)
,p_db_column_name=>'ITEMS_PER_PAGE'
,p_display_order=>40
,p_column_identifier=>'D'
,p_column_label=>unistr('Elementos por P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349777972537459201.4851)
,p_db_column_name=>'PUBLISHED_STATUS'
,p_display_order=>50
,p_column_identifier=>'E'
,p_column_label=>unistr('Estado de publicaci\00F3n')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349778024950459202.4851)
,p_db_column_name=>'COMMENTS'
,p_display_order=>60
,p_column_identifier=>'F'
,p_column_label=>'Comentarios'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349778198420459203.4851)
,p_db_column_name=>'PRE_HOOK'
,p_display_order=>70
,p_column_identifier=>'G'
,p_column_label=>unistr('Previo a la conexi\00F3n')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349778217011459204.4851)
,p_db_column_name=>'ORIGINS_ALLOWED'
,p_display_order=>80
,p_column_identifier=>'H'
,p_column_label=>unistr('Or\00EDgenes Permitidos')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349778340747459205.4851)
,p_db_column_name=>'SCHEMA_ID'
,p_display_order=>90
,p_column_identifier=>'I'
,p_column_label=>'Identificador de Esquema'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349778492918459206.4851)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>100
,p_column_identifier=>'J'
,p_column_label=>'Creado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349778529053459207.4851)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>110
,p_column_identifier=>'K'
,p_column_label=>'Creado el'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'DD-MON-YYYY HH24:MI:SS'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349778668565459208.4851)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>120
,p_column_identifier=>'L'
,p_column_label=>'Actualizado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349778794416459209.4851)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>130
,p_column_identifier=>'M'
,p_column_label=>'Actualizado el'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'DD-MON-YYYY HH24:MI:SS'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(54183910735062229.4851)
,p_db_column_name=>'PROTECTED'
,p_display_order=>140
,p_column_identifier=>'N'
,p_column_label=>'Protegidos por privilegio'
,p_allow_filtering=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(54184565506062235.4851)
,p_db_column_name=>'PROTECTED_FILTER'
,p_display_order=>150
,p_column_identifier=>'O'
,p_column_label=>'Filtro protegido'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(345304648811156445.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(345304595186156444.4851)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Crear M\00F3dulo')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:RP,120::'
,p_icon_css_classes=>'icon-right-chevron'
);
end;
/
prompt --application/pages/page_00120
begin
wwv_flow_api.create_page(
 p_id=>120.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>unistr('Definici\00F3n de m\00F3dulo')
,p_step_title=>unistr('Definici\00F3n de m\00F3dulo')
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(344911404961486242)
,p_step_template=>wwv_flow_api.id(754939123056928433.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538579044595390057)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(243332224074719622.4851)
,p_plug_name=>'LEGEND'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388770208095784265.4851)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</br><div style="line-height:26px">',
'&nbsp;&nbsp;&nbsp;&nbsp;<b>Leyenda:</b>',
'&nbsp;&nbsp;&nbsp;&nbsp;<span class="a-Icon icon-status-success" aria-hidden="true" style="background-color:#60ccb5;color:#fff;border-radius:26px;width:26px;height:26px;padding:5px"></span> Plantilla totalmente protegida por un privilegio ',
unistr('&nbsp;&nbsp;&nbsp;&nbsp;<span class="a-Icon icon-status-failure" aria-hidden="true" style="background-color:#ec7a71;color:#fff;border-radius:26px;width:26px;height:26px;padding:5px"></span> Plantilla no protegida por ning\00FAn privilegio '),
'</div>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(349778848692459210.4851)
,p_plug_name=>unistr('Definici\00F3n de m\00F3dulo ORDS')
,p_region_name=>'ords_module_definition'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding:a-Form--fixedLabels'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(521637980963366441.4851)
,p_plug_name=>'Button Holder'
,p_parent_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719684836837942735.4851)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P120_MODULE_ID'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(349779837571459220.4851)
,p_plug_name=>'Plantillas de recursos'
,p_region_name=>'ords_module_templates'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select n001 id,',
'       n002 module_id,',
'       c001 uri_template,',
'       n003 priority,',
'       c002 etag_type,',
'       c003 etag_query,',
'       case when length(c004) > 50 then ',
'                substr(c004,1,50)||'' ...''',
'            else ',
'                 c004',
'            end comments,',
'       n005 schema_id,',
'       c049 created_by,',
'       d001 created_on,',
'       c050 updated_by,',
'       d002 updated_on,',
'       case  wwv_flow_rest_ws.template_is_protected(n001)',
'       when ''F'' then ''<span class="a-Icon icon-status-success" aria-hidden="true" style="background-color:#60ccb5;color:#fff;border-radius:26px;width:26px;height:26px;padding:5px;"></span>''',
'       when ''P'' then ''<span class="a-Icon icon-status-warning" aria-hidden="true" style="background-color:#F4d26f;color:#fff;border-radius:26px;width:26px;height:26px;padding:4px;"></span>''',
'       when ''N'' then ''<span class="a-Icon icon-status-failure" aria-hidden="true" style="background-color:#ec7a71;color:#fff;border-radius:26px;width:26px;height:26px;padding:5px;"></span>''',
'       end protected',
'from wwv_flow_collections ',
'where collection_name = ''ORDS_TEMPLATES''',
'and n002 = :P120_MODULE_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P120_MODULE_ID'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(349780070697459222.4851)
,p_max_row_count=>'1000000'
,p_no_data_found_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Actualmente no hay ninguna plantilla definida para el m\00F3dulo seleccionado.'),
''))
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_owner=>'DOUG'
,p_internal_uid=>349780070697459222
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349780177693459223.4851)
,p_db_column_name=>'ID'
,p_display_order=>10
,p_column_identifier=>'A'
,p_column_label=>'Identificador'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349780220087459224.4851)
,p_db_column_name=>'MODULE_ID'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>unistr('Identificador de M\00F3dulo')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349780360621459225.4851)
,p_db_column_name=>'URI_TEMPLATE'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>'Plantilla de URI'
,p_column_link=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:130:P130_TEMPLATE_ID,P0_SELECTED_NODE:#ID#,MT#ID#'
,p_column_linktext=>'#URI_TEMPLATE#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349780420292459226.4851)
,p_db_column_name=>'PRIORITY'
,p_display_order=>40
,p_column_identifier=>'D'
,p_column_label=>'Prioridad'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349780547255459227.4851)
,p_db_column_name=>'ETAG_TYPE'
,p_display_order=>50
,p_column_identifier=>'E'
,p_column_label=>'Tipo ETag'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349780682662459228.4851)
,p_db_column_name=>'ETAG_QUERY'
,p_display_order=>60
,p_column_identifier=>'F'
,p_column_label=>'Consulta ETag'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349780752550459229.4851)
,p_db_column_name=>'COMMENTS'
,p_display_order=>70
,p_column_identifier=>'G'
,p_column_label=>'Comentarios'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349780838961459230.4851)
,p_db_column_name=>'SCHEMA_ID'
,p_display_order=>80
,p_column_identifier=>'H'
,p_column_label=>'Identificador de Esquema'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349780906782459231.4851)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>90
,p_column_identifier=>'I'
,p_column_label=>'Creado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349781072272459232.4851)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>100
,p_column_identifier=>'J'
,p_column_label=>'Creado el'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'DD-MON-YYYY HH24:MI:SS'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349781180416459233.4851)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>110
,p_column_identifier=>'K'
,p_column_label=>'Actualizado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(349781224629459234.4851)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>120
,p_column_identifier=>'L'
,p_column_label=>'Actualizado el'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'DD-MON-YYYY HH24:MI:SS'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(54184173558062231.4851)
,p_db_column_name=>'PROTECTED'
,p_display_order=>130
,p_column_identifier=>'M'
,p_column_label=>'Protegidos por privilegio'
,p_allow_filtering=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(349779573726459217.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CHANGE'
,p_button_redirect_url=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,120:P0_SELECTED_NODE:MD-3'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(349779964301459221.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(349779837571459220.4851)
,p_button_name=>'CREATE_TEMPLATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_button_image_alt=>'Crear Plantilla'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:RP,130:P130_MODULE_ID:&P120_MODULE_ID.'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(521637866351366440.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(521637980963366441.4851)
,p_button_name=>'GEN_DOC'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Generar documento de Swagger'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(349779454075459216.4851)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_button_name=>'CREATE_MODULE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('Crear M\00F3dulo')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P120_MODULE_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(349779742733459219.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_button_name=>'UPDATE_MODULE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_condition=>'P120_MODULE_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(349779602666459218.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_button_name=>'DELETE_MODULE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_warn_on_unsaved_changes=>null
,p_button_condition=>'P120_MODULE_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(395801668524090606.4851)
,p_branch_name=>'Branch to 120'
,p_branch_action=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>40
,p_branch_condition_type=>'REQUEST_IN_CONDITION'
,p_branch_condition=>'CREATE_MODULE,UPDATE_MODULE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(619047465418969820.4851)
,p_branch_name=>'Branch to 110'
,p_branch_action=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP:P0_SELECTED_NODE:MD-3&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>50
,p_branch_condition_type=>'REQUEST_IN_CONDITION'
,p_branch_condition=>'DELETE_MODULE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(342536924115632643.4851)
,p_name=>'P120_MODULE_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(349778931181459211.4851)
,p_name=>'P120_MODULE_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_prompt=>unistr('Nombre del M\00F3dulo')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>90
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Nombre del m\00F3dulo de servicio RESTful. Este nombre debe ser \00FAnico en el esquema propietario.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(349779001981459212.4851)
,p_name=>'P120_URI_PREFIX'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_prompt=>'Ruta de Acceso Base'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>90
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Ruta de acceso base <em>sensible a may\00FAsculas/min\00FAsculas</em> que se utiliza para acceder al servicio RESTful. Esta ruta base para el m\00F3dulo se agrega a la ruta de acceso del servidor para el espacio de trabajo. La ruta de acceso base debe ser \00FAnica ')
||'en el esquema. <br/>',
'<br/>',
'Ejemplo: <br/><br/>',
'<pre>',
'http://server.com/ords/mySchema<B>/hr/</B>employees/:id',
'|________________|____|________|_|_________|____|',
'           |        |     |     |     |      |',
'           |        |     |     |     |       - <B>Variable de enlace</B>',
'           |        |     |     |     | ',
'           |        |     |     |      - <B>Plantilla de URI</B>',
'           |        |     |     |',
unistr('           |        |     |      - Ruta base del m\00F3dulo'),
'           |        |     |',
'           |        |      - Alias de esquema',
'           |        |      ',
'           |         - Alias de ORDS',
'           |               ',
'            - URL del servidor              ',
' </pre>'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(349779143830459213.4851)
,p_name=>'P120_IS_PUBLISHED'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_item_default=>'Y'
,p_prompt=>'Publicado'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Hacer que este servicio RESTful est\00E9 disponible para su uso.')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(349779258055459214.4851)
,p_name=>'P120_PAGINATION_SIZE'
,p_is_required=>true
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_item_default=>'25'
,p_prompt=>unistr('Tama\00F1o de Paginaci\00F3n')
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>10
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('N\00FAmero de registros que se devolver\00E1n en una llamada del servicio.')
,p_attribute_01=>'0'
,p_attribute_02=>'10000'
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(349779390521459215.4851)
,p_name=>'P120_ORIGINS_ALLOWED'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_prompt=>unistr('Or\00EDgenes Permitidos')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>90
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Lista separada por comas de prefijos de URL que se permiten para acceder al m\00F3dulo. Si la lista est\00E1 vac\00EDa, no se aplicar\00E1n restricciones.<br/><br/>'),
'',
'Un origen se define por el protocolo, el nombre de host y el puerto de un sitio web. Por ejemplo, <b>https://example.com</b> es un origen y <b>https://another.example.com</b> es otro, ya que el nombre de host es diferente. Del mismo modo, <b>http://e'
||unistr('xample.com</b> no es el mismo origen que <b>https://example.com</b>, ya que el protocolo es diferente. Por \00FAltimo, <b>http://example.com</b> no es el mismo origen que <b>http://example.com:8080</b>, porque el puerto no coincide.')))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358043076068998601.4851)
,p_name=>'P120_STATUS'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358044051699998611.4851)
,p_name=>'P120_COMMENTS'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_prompt=>'Comentarios'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'Y'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(521638353736366445.4851)
,p_name=>'P120_DOC_URL'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(521637980963366441.4851)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_path varchar2(32767);',
'  l_swagger varchar2(32767);',
'',
' ',
'BEGIN ',
'  l_path := '''';',
'',
'  l_swagger := wwv_flow_platform.get_preference( p_preference_name => ''SWAGGER_UI_URL'' );',
'--  ',
'  if l_swagger is not null then ',
'      l_path := l_path ||l_swagger||''?url='';',
'  end if;',
' --    ',
'  l_path := l_path ||:G_PROTOCOL||''://''||:G_HTTP_HOST||:G_SCRIPT_NAME||''/''||:G_SCHEMA_ALIAS||''/open-api-catalog''||:P120_URI_PREFIX;',
'  ',
'   --l_path := ''z?p_cat=swagger&p_url=''|| wwv_flow_utilities.urlencode(l_path);',
'--',
'return l_path;',
'END;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(521638629904366448.4851)
,p_name=>'P120_URI'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(349778848692459210.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'URL completa'
,p_post_element_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--small" onclick="void(0);" aria-label="&APP_TEXT$REST_WS_COPY_TO_CLIPBOARD_ARIA." type="button"  title="&APP_TEXT$REST_WS_COPY_TO_CLIPBOARD." data-clipboard-source="#P120_URI" styl'
||'e="margin-left:5px;"><span class="a-Icon icon-copy" aria-hidden="true"></span></button>',
''))
,p_source=>'&G_PROTOCOL.://&G_HTTP_HOST.&G_SCRIPT_NAME./&G_SCHEMA_ALIAS.<font color="#EE0000">&P120_URI_PREFIX.</font>'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P120_MODULE_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(381674957633069425.4851)
,p_validation_name=>'Valid Characters Only'
,p_validation_sequence=>10
,p_validation=>'P120_MODULE_NAME'
,p_validation2=>'^([a-zA-Z0-9/_\. \-]*)$'
,p_validation_type=>'REGULAR_EXPRESSION'
,p_error_message=>unistr('#LABEL# solo debe contener caracteres alfab\00E9ticos, num\00E9ricos, de guion, de subrayado, de punto o de espacio.')
,p_always_execute=>'Y'
,p_associated_item=>wwv_flow_api.id(349778931181459211.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(619046825635969814.4851)
,p_validation_name=>'CREATE - Name is Unique'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_MODULES''',
'   and c001 = :P120_module_name'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('#LABEL# ya existe. #LABEL# debe ser \00FAnico en el esquema. ')
,p_validation_condition=>'CREATE_MODULE'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(349778931181459211.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(619047030576969816.4851)
,p_validation_name=>'UPDATE - Name is Unique'
,p_validation_sequence=>40
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_MODULES''',
'   and c001 = :P120_module_name',
'   and n001 != :P120_MODULE_ID'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('#LABEL# ya existe. #LABEL# debe ser \00FAnico en el esquema. ')
,p_validation_condition=>'UPDATE_MODULE'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(349778931181459211.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(619046929551969815.4851)
,p_validation_name=>'CREATE - Base Path is unique'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_MODULES''',
'   and c002 = :P120_URI_PREFIX'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('#LABEL# ya existe. #LABEL# debe ser \00FAnico en el esquema.')
,p_validation_condition=>'CREATE_MODULE'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(349779001981459212.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(619047183534969817.4851)
,p_validation_name=>'UPDATE - Base Path is unique'
,p_validation_sequence=>60
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_MODULES''',
'   and c002 = :P120_URI_PREFIX',
'   and n001 != :P120_MODULE_ID'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('#LABEL# ya existe. #LABEL# debe ser \00FAnico en el esquema.')
,p_validation_condition=>'UPDATE_MODULE'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(349779001981459212.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(349782578465459247.4851)
,p_name=>'Process Delete'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(349779602666459218.4851)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(349782877063459250.4851)
,p_event_id=>wwv_flow_api.id(349782578465459247.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.confirm(''Are you sure you wish to delete this Module and all children?'',''DELETE_MODULE'');'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(521638080826366442.4851)
,p_name=>'Show SWAGGER'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(521637866351366440.4851)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(521638159086366443.4851)
,p_event_id=>wwv_flow_api.id(521638080826366442.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'window.open($v(''P120_DOC_URL''));',
'',
''))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(342537341309632647.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fetch row from ORDS_MODULE Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_id                number;',
'    l_name              varchar2(4000);',
'    l_uri_prefix        varchar2(4000);',
'    l_items_per_page    number;',
'    l_published_status  varchar2(4000);',
'    l_origins_allowed   varchar2(4000);',
'    l_comments          varchar2(4000);',
'    ',
'BEGIN',
'   select ',
'       n001 id,',
'       c001 name, ',
'       c002 uri_prefix,',
'       n002 items_per_page,',
'       c003 published_status,',
'       c006 origins_allowed,',
'       c004 comments',
'  INTO ',
'       l_id,',
'       l_name,',
'       l_uri_prefix,',
'       l_items_per_page,',
'       l_published_status,',
'       l_origins_allowed,',
'       l_comments',
'  from wwv_flow_collections ',
' where collection_name = ''ORDS_MODULES''',
'   and (n001 = :P120_MODULE_ID ',
'        OR',
'        c001 = :P120_MODULE_NAME);',
'   ',
'   :P120_MODULE_ID       := l_id;',
'   :P120_MODULE_NAME     := l_name;',
'   if substr(l_uri_prefix,1,1) = ''/'' then ',
'       :P120_URI_PREFIX      := l_uri_prefix;',
'   else ',
'       :P120_URI_PREFIX    := ''/''||l_uri_prefix;',
'   end if;',
'   :P120_STATUS          := l_published_status;',
'   :P120_IS_PUBLISHED    := case l_published_status ',
'                            when ''PUBLISHED'' then ''Y''',
'                            else ''N''',
'                            end;',
'   :P120_PAGINATION_SIZE := l_items_per_page;',
'   :P120_ORIGINS_ALLOWED := l_origins_allowed;',
'   :P120_COMMENTS        := l_comments;',
'--',
'   :P0_SELECTED_NODE     := ''MM''||l_id;',
'   ',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P120_MODULE_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(349782047840459242.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Value of P120_STATUS'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If :P120_IS_PUBLISHED = ''Y'' then ',
'   :P120_STATUS := ''PUBLISHED'';',
'else ',
'    :P120_STATUS := ''NOT_PUBLISHED'';',
'end if;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(395801788790090607.4851)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Process_module_changes'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'  wwv_flow_rest_ws.process_rest_ws_request(p_request=> :REQUEST, p_parse_as => :P0_SCHEMA);',
'  -- Force a value into module id (even though its wrong) to force loading the record on return to page',
'  :P120_MODULE_ID := -1;',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00130
begin
wwv_flow_api.create_page(
 p_id=>130.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Plantilla de recursos'
,p_step_title=>'Plantilla de Recurso'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(344911404961486242)
,p_step_template=>wwv_flow_api.id(754939123056928433.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538579044595390057)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(707870035522701452.4851)
,p_plug_name=>unistr('Definici\00F3n de plantilla ORDS ')
,p_region_name=>'ords_template_definition'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding:a-Form--fixedLabels'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(708529628674941072.4851)
,p_plug_name=>'Manejadores de recursos'
,p_region_name=>'ords_template_handlers'
,p_region_template_options=>'a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width: 100%"'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select n001 id,',
'       n002 template_id,',
'       c001 source_type,',
'       c002 method,',
'       c003 mimes_allowed,',
'       n003 items_per_page,',
'       case ',
'           when dbms_lob.getlength(clob001) > 50 then',
'                substr(clob001,1,50)||'' ...''',
'           else ',
'                clob001',
'       end source,',
'       case when length(c004) > 50 then ',
'                substr(c004,1,50)||'' ...''',
'            else ',
'                 c004',
'            end comments,',
'       n005 schema_id, ',
'       c049 created_by,',
'       d001 created_on,',
'       c050 updated_by,',
'       d002 updated_on  ',
'from wwv_flow_collections ',
'where collection_name = ''ORDS_HANDLERS''',
'and n002 = :P130_TEMPLATE_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P130_TEMPLATE_ID'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(708529861800941074.4851)
,p_max_row_count=>'1000000'
,p_no_data_found_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Actualmente no hay ninguna plantilla definida para el m\00F3dulo seleccionado.'),
''))
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_owner=>'DOUG'
,p_internal_uid=>708529861800941074
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358750096972481861.4851)
,p_db_column_name=>'ID'
,p_display_order=>10
,p_column_identifier=>'A'
,p_column_label=>'Identificador'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358752404367481866.4851)
,p_db_column_name=>'COMMENTS'
,p_display_order=>70
,p_column_identifier=>'G'
,p_column_label=>'Comentarios'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358752810833481866.4851)
,p_db_column_name=>'SCHEMA_ID'
,p_display_order=>80
,p_column_identifier=>'H'
,p_column_label=>'ID de esquema'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358753260953481866.4851)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>90
,p_column_identifier=>'I'
,p_column_label=>'Creado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358753605576481867.4851)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>100
,p_column_identifier=>'J'
,p_column_label=>'Creado el'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'DD-MON-YYYY HH24:MI:SS'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358754037494481867.4851)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>110
,p_column_identifier=>'K'
,p_column_label=>'Actualizado por'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358754486787481867.4851)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>120
,p_column_identifier=>'L'
,p_column_label=>'Actualizado el'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'DD-MON-YYYY HH24:MI:SS'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358044647463998617.4851)
,p_db_column_name=>'TEMPLATE_ID'
,p_display_order=>130
,p_column_identifier=>'M'
,p_column_label=>'ID de plantilla'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358044703088998618.4851)
,p_db_column_name=>'SOURCE_TYPE'
,p_display_order=>140
,p_column_identifier=>'N'
,p_column_label=>'Tipo de Origen'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358044823056998619.4851)
,p_db_column_name=>'METHOD'
,p_display_order=>150
,p_column_identifier=>'O'
,p_column_label=>unistr('M\00E9todo HTTP')
,p_column_link=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:140:P140_HANDLER_ID,P0_SELECTED_NODE:#ID#,TH#ID#'
,p_column_linktext=>'#METHOD#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358044978011998620.4851)
,p_db_column_name=>'MIMES_ALLOWED'
,p_display_order=>160
,p_column_identifier=>'P'
,p_column_label=>'Tipos MIME permitidos'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(358045008942998621.4851)
,p_db_column_name=>'ITEMS_PER_PAGE'
,p_display_order=>170
,p_column_identifier=>'Q'
,p_column_label=>unistr('Elementos por P\00E1gina')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(411297122721027834.4851)
,p_db_column_name=>'SOURCE'
,p_display_order=>180
,p_column_identifier=>'T'
,p_column_label=>'Origen'
,p_allow_sorting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_column_type=>'CLOB'
,p_rpt_show_filter_lov=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(358091863089242250.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CHANGE'
,p_button_redirect_url=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:RP:P0_SELECTED_NODE,P120_MODULE_ID:MM&P130_MODULE_ID.,&P130_MODULE_ID.'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(358755262474481876.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(708529628674941072.4851)
,p_button_name=>'CREATE_HANDLER'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(719734932326947858.4851)
,p_button_image_alt=>'Crear manejador'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:RP,140:P140_MODULE_ID,P140_TEMPLATE_ID:&P130_MODULE_ID.,&P130_TEMPLATE_ID.'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(358091494079242250.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_button_name=>'CREATE_TEMPLATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear Plantilla'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P130_TEMPLATE_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(358092646976242251.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_button_name=>'UPDATE_TEMPLATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_condition=>'P130_TEMPLATE_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(358092202296242251.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_button_name=>'DELETE_TEMPLATE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_warn_on_unsaved_changes=>null
,p_button_condition=>'P130_TEMPLATE_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(358117541424396782.4851)
,p_branch_name=>'Branch to Page 120'
,p_branch_action=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:RP:P0_SELECTED_NODE,P120_MODULE_ID:MM&P130_MODULE_ID.,&P130_MODULE_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(358092202296242251.4851)
,p_branch_sequence=>30
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(619047686202969822.4851)
,p_branch_name=>'Branch to Page 120'
,p_branch_action=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>40
,p_branch_condition_type=>'REQUEST_IN_CONDITION'
,p_branch_condition=>'CREATE_TEMPLATE,UPDATE_TEMPLATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358043156051998602.4851)
,p_name=>'P130_ETAG_TYPE'
,p_is_required=>true
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_item_default=>'HASH'
,p_prompt=>'Tipo de etiqueta de entidad HTTP'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>'STATIC2:Secure Hash;HASH,Query;QUERY,None;NONE'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Tipo de etiqueta de entidad que se usar\00E1 para identificar de forma \00FAnica la versi\00F3n del recurso.'),
'<BR/>',
'<UL>',
unistr('<LI><B>HASH seguro</B>: genera el ID de versi\00F3n mediante un hash seguro.</LI>'),
unistr('<LI><B>Consulta</B>: utiliza una consulta especificada por el usuario para identificar de forma \00FAnica la versi\00F3n del recurso.</LI>'),
'<LI><B>Ninguna</B>: no se utiliza ninguna etiqueta de entidad.</li>',
'</UL>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358043237764998603.4851)
,p_name=>'P130_PRIORITY'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_item_default=>'0'
,p_prompt=>'Prioridad'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>'STATIC:0,1,2,3,4,5,6,7,8,9'
,p_lov_display_null=>'YES'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Prioridad que se dar\00E1 a esta plantilla en caso de colisi\00F3n de recursos. 0 es la m\00E1s baja y 9 la m\00E1s alta. ')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358043325916998604.4851)
,p_name=>'P130_ETAG_QUERY'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_prompt=>'Consulta ETag'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358043865640998609.4851)
,p_name=>'P130_TEMPLATE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358044103570998612.4851)
,p_name=>'P130_COMMENTS'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_prompt=>'Comentarios'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'Y'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358045290840998623.4851)
,p_name=>'P130_MODULE_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_prompt=>unistr('M\00F3dulo de Servicio RESTful')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_read_only_when_type=>'ALWAYS'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358045405212998625.4851)
,p_name=>'P130_MODULE_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358093447685242264.4851)
,p_name=>'P130_URI_PATTERN'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_prompt=>'Plantilla de URI'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>90
,p_cMaxlength=>600
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Plantilla de URI <em>sensible a may\00FAsculas/min\00FAsculas</em>que se utiliza para acceder al recurso espec\00EDfico. La plantilla de URI para el recurso se agrega a la ruta de acceso del servidor y la ruta de acceso base del m\00F3dulo. <br/>'),
'<br/>',
unistr('La plantilla de URI puede incluir tambi\00E9n una variable de enlace agregada despu\00E9s de una barra inclinada. Esta acci\00F3n permite transferir un valor al servicio como parte de la URI. La sintaxis de la variable de enlace agrega al nombre de la variable d')
||'os puntos (:) como prefijo.<BR/>',
'<br/>',
'Ejemplo: <br/><br/>',
'<pre>',
'http://server.com/ords/mySchema/hr/<B>employees/:id</B>',
'|________________|____|________|_|_________|____|',
'           |        |     |     |     |      |',
'           |        |     |     |     |       - <B>Variable de enlace</B>',
'           |        |     |     |     | ',
'           |        |     |     |      - <B>Plantilla de URI</B>',
'           |        |     |     |',
unistr('           |        |     |      - Ruta base del m\00F3dulo'),
'           |        |     |',
'           |        |      - Alias de esquema',
'           |        |      ',
'           |         - Alias de ORDS',
'           |               ',
'            - URL del servidor              ',
' </pre>',
'<br/>',
unistr('<strong>Nota:</strong> Los par\00E1metros <strong>PAGE</strong>, <strong>LIMIT</strong> y <strong>OFFSET</strong> est\00E1n restringidos, ya que los utiliza ORDS para la paginaci\00F3n.')))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(521638788660366449.4851)
,p_name=>'P130_URI'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'URL completa'
,p_post_element_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--small" onclick="void(0);" aria-label="&APP_TEXT$REST_WS_COPY_TO_CLIPBOARD_ARIA." type="button"  title="&APP_TEXT$REST_WS_COPY_TO_CLIPBOARD." data-clipboard-source="#P130_URI" styl'
||'e="margin-left:5px;"><span class="a-Icon icon-copy" aria-hidden="true"></span></button>',
''))
,p_source=>'&G_PROTOCOL.://&G_HTTP_HOST.&G_SCRIPT_NAME./&G_SCHEMA_ALIAS.&P130_MODULE_BASE_PATH.<font color="#EE0000">&P130_URI_PATTERN.</font>'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P130_TEMPLATE_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(619045630941969802.4851)
,p_name=>'P130_MODULE_BASE_PATH'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(707870035522701452.4851)
,p_prompt=>unistr('Ruta de acceso base de m\00F3dulo')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_read_only_when_type=>'ALWAYS'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(411295932193027822.4851)
,p_validation_name=>'Validate URI'
,p_validation_sequence=>10
,p_validation=>'RETURN wwv_flow_rest_ws.validate_uri(:P130_URI_PATTERN);'
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_always_execute=>'Y'
,p_validation_condition=>'CREATE_TEMPLATE,UPDATE_TEMPLATE'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(358093447685242264.4851)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(358043492907998605.4851)
,p_name=>'Hide/Show Query'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P130_ETAG_TYPE'
,p_condition_element=>'P130_ETAG_TYPE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'QUERY'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358043519701998606.4851)
,p_event_id=>wwv_flow_api.id(358043492907998605.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P130_ETAG_QUERY'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358043615009998607.4851)
,p_event_id=>wwv_flow_api.id(358043492907998605.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P130_ETAG_QUERY'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(358148364203965601.4851)
,p_name=>'Process Delete'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(358092202296242251.4851)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358149251094965603.4851)
,p_event_id=>wwv_flow_api.id(358148364203965601.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.confirm(''Are you sure you wish to delete this Template and all children?'',''DELETE_TEMPLATE'');'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(358135449087847330.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fetch row from ORDS_TEMPLATES Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_template_id       number;',
'    l_module_id         number;',
'    l_uri_pattern       varchar2(4000);',
'    l_priority          number;',
'    l_etag_type         varchar2(4000);',
'    l_etag_query        varchar2(4000);',
'    l_comments          varchar2(4000);',
'BEGIN',
'   select ',
'       n001 template_id,',
'       n002 module_id,',
'       c001 uri_pattern, ',
'       n003 priority,',
'       c002 etag_type,',
'       c003 etag_query,',
'       c004 comments',
'  INTO ',
'       l_template_id,',
'       l_module_id,',
'       l_uri_pattern,',
'       l_priority,  ',
'       l_etag_type, ',
'       l_etag_query,',
'       l_comments  ',
'  from wwv_flow_collections ',
' where collection_name = ''ORDS_TEMPLATES''',
'   and (n001 = :P130_TEMPLATE_ID',
'        OR',
'        (c001 = :P130_URI_PATTERN',
'         AND ',
'         n002 = :P130_MODULE_ID));',
'  ',
'   :P130_TEMPLATE_ID     := l_template_id;',
'   :P130_MODULE_ID       := l_module_id;',
'   :P130_URI_PATTERN     := l_uri_pattern;',
'   :P130_PRIORITY        := l_priority;',
'   :P130_etag_type       := l_etag_type;',
'   :P130_etag_query      := l_etag_query;',
'   :P130_comments        := l_comments;',
'   --',
'   :P0_SELECTED_NODE := ''MT''||l_template_id;',
'   ',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P130_TEMPLATE_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(358045304011998624.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Module Name and Base Path'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001 module_name, ',
'       case when substr(c002,1,1) = ''/'' then c002',
'            else ''/''||c002',
'       end base_path ',
'  into :P130_MODULE_NAME,',
'       :P130_MODULE_BASE_PATH',
'  from wwv_flow_collections',
' where COLLECTION_NAME= ''ORDS_MODULES''',
'   and n001 = :P130_MODULE_ID;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P130_MODULE_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(395801931891090609.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Process_template_changes'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'  wwv_flow_rest_ws.process_rest_ws_request(p_request=> :REQUEST, p_parse_as => :P0_SCHEMA);',
'  -- Set Template ID to -1 to force a refresh of the details when we are creating a new Template.',
'  :P130_TEMPLATE_ID := -1;',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00140
begin
wwv_flow_api.create_page(
 p_id=>140.4851
,p_user_interface_id=>wwv_flow_api.id(4971601142302345.4851)
,p_name=>'Manejador de Recursos'
,p_step_title=>'Manejador de Recursos'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(344911404961486242)
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var g_run = false;',
'htmldb_null_script=''The Source may not be empty.'';',
'htmldb_max_script_size=''Maximum Script size of 32767 exceeded.'';',
'',
'function gStoreScript(req, run, cb) {',
'  var plsqlCode, scriptLength, ',
'      saveNew = false,',
'      maxLength = $v("P140_MAX_LENGTH");',
'',
'  function doSave() {',
'    apex.builder.plugin.codeEditor.saveProcess("#codeEditor_widget", "STORE_SCRIPT", "f01")',
'      .always(function() {',
'          cb(saveNew);',
'      });',
'  }',
'',
'  plsqlCode = $("#codeEditor_widget").codeEditor("getValue");',
'  scriptLength = plsqlCode.length;',
'',
'  if (!plsqlCode) {',
'    alert(htmldb_null_script);',
'    return false;',
'  }',
'',
'  if (scriptLength > maxLength) {',
'    alert(htmldb_max_script_size);',
'    return false;',
'  }',
'',
'  if (req == ''SAVE'' || req == ''CREATE'') {',
'',
'      doSave()',
'      return true;',
'  }',
'}'))
,p_step_template=>wwv_flow_api.id(754939123056928433.4851)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(538579044595390057)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(358045544097998626.4851)
,p_plug_name=>unistr('Definici\00F3n de manejador de ORDS')
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding:a-Form--fixedLabels'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(358904035641530218.4851)
,p_plug_name=>'FORMAT'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding:a-Region--noBorder:a-Region--hideHeader:a-Form--fixedLabels'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(358904551627530223.4851)
,p_plug_name=>'OTHER'
,p_region_name=>'other_region_items'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding:a-Region--noBorder:a-Region--hideHeader:a-Form--fixedLabels'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(358905213997530230.4851)
,p_plug_name=>'Origen'
,p_region_name=>'codeEditor'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select clob001 ',
'  from wwv_flow_collections',
' where COLLECTION_NAME = ''ORDS_HANDLERS''',
'   and n001 = :P140_HANDLER_ID'))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.CLOB_CODE_EDITOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'PLSQL'
,p_attribute_02=>'20'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(359175352067742002.4851)
,p_plug_name=>unistr('Par\00E1metros')
,p_region_name=>'parameters'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(719706437830942782.4851)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select n001 id,',
'       c001 name,',
'       c002 bind_variable_name,',
'       c003 source_type,',
'       c004 access_method,',
'       c005 param_type,',
'       c006 comments',
'  from wwv_flow_collections',
' where COLLECTION_NAME = ''ORDS_PARAMETERS''',
'   and n002 = :P140_HANDLER_ID'))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P140_HANDLER_ID'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(359175554518742004.4851)
,p_name=>'ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>30
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(359175621703742005.4851)
,p_name=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Nombre'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>40
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>100
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_help_text=>unistr('Nombre del par\00E1metro que aparece en la plantilla de URI o la cabecera HTTP. Se utiliza para asignar nombres que no son nombres de par\00E1metro SQL v\00E1lidos.')
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(359175776444742006.4851)
,p_name=>'BIND_VARIABLE_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'BIND_VARIABLE_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Variable de Enlace'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>30
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_help_text=>unistr('Nombre del par\00E1metro al que se har\00E1 referencia en SQL. Si se especifica NULL, el par\00E1metro no se enlaza.')
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(359175879349742007.4851)
,p_name=>'SOURCE_TYPE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SOURCE_TYPE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_SELECT_LIST'
,p_heading=>'Tipo de Origen'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_is_required=>true
,p_lov_type=>'SQL_QUERY'
,p_lov_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''HTTP HEADER'' d,',
'       ''HEADER'' r',
'  from sys.dual',
'UNION',
'select ''URI'' d,',
'       ''URI'' r',
'  from sys.dual',
'where :ACCESS_METHOD = ''IN''',
'UNION',
'select ''RESPONSE'' d,',
'       ''RESPONSE'' r',
'  from sys.dual',
'where :ACCESS_METHOD = ''OUT''',
''))
,p_lov_display_extra=>false
,p_lov_display_null=>false
,p_lov_cascade_parent_items=>'ACCESS_METHOD'
,p_ajax_items_to_submit=>'ACCESS_METHOD'
,p_ajax_optimize_refresh=>true
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_help_text=>unistr('Identifica si el par\00E1metro procede de la plantilla de URI o la cabecera HTTP. Valores v\00E1lidos: HEADER, RESPONSE, URI.')
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(359175902308742008.4851)
,p_name=>'ACCESS_METHOD'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ACCESS_METHOD'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_SELECT_LIST'
,p_heading=>unistr('M\00E9todo de Acceso')
,p_heading_alignment=>'LEFT'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_is_required=>true
,p_lov_type=>'STATIC'
,p_lov_source=>'STATIC:IN;IN,OUT;OUT,IN/OUT;INOUT'
,p_lov_display_extra=>false
,p_lov_display_null=>false
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_help_text=>unistr('Indica si el par\00E1metro es un valor de entrada, un valor de salida o ambos. Valores v\00E1lidos: IN, OUT, INOUT.')
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(359176028902742009.4851)
,p_name=>'PARAM_TYPE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_TYPE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_SELECT_LIST'
,p_heading=>'Tipo de dato'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>80
,p_value_alignment=>'LEFT'
,p_is_required=>true
,p_lov_type=>'STATIC'
,p_lov_source=>'STATIC2:STRING;STRING,INTEGER;INT,LONG;LONG,DOUBLE;DOUBLE,BOOLEAN;BOOLEAN,TIMESTAMP;TIMESTAMP,RESULTSET;RESULTSET'
,p_lov_display_extra=>false
,p_lov_display_null=>false
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Tipo de dato nativo del par\00E1metro. Valores v\00E1lidos: STRING, INT, DOUBLE, BOOLEAN, LONG, TIMESTAMP.</p>'),
'',
unistr('<p><b>Nota</b>: Los tipos de dato <B><I>no</I></B> son tipos de dato de Oracle. STRING representa cadenas de cualquier longitud. INT, DOUBLE y LONG representan valores num\00E9ricos de distinta precisi\00F3n. BOOLEAN representa True o False l\00F3gicos.</p>')))
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(359176171968742010.4851)
,p_name=>'COMMENTS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'COMMENTS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Comentarios'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>90
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'Y'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_help_text=>'Texto de comentario.'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(359176263401742011.4851)
,p_name=>'APEX$ROW_ACTION'
,p_item_type=>'NATIVE_ROW_ACTION'
,p_display_sequence=>20
,p_enable_hide=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(359176396795742012.4851)
,p_name=>'APEX$ROW_SELECTOR'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_enable_hide=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(359175469963742003.4851)
,p_internal_uid=>359175469963742003
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_add_row_if_empty=>false
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_max_row_count=>100000
,p_show_nulls_as=>'-'
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SET'
,p_show_total_row_count=>true
,p_no_data_found_message=>unistr('No se ha definido ning\00FAn par\00E1metro')
,p_show_toolbar=>true
,p_toolbar_buttons=>'SEARCH_COLUMN:SEARCH_FIELD:ACTIONS_MENU:RESET'
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>true
,p_define_chart_view=>true
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'NONE'
,p_show_icon_view=>false
,p_show_detail_view=>false
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(359177630131742025.4851)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Cancelar'
,p_button_position=>'REGION_TEMPLATE_CHANGE'
,p_button_redirect_url=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:RP:P0_SELECTED_NODE,P130_TEMPLATE_ID:MT&P140_TEMPLATE_ID.,&P140_TEMPLATE_ID.'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(359177342683742022.4851)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_button_name=>'CREATE_HANDLER'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crear manejador'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_warn_on_unsaved_changes=>null
,p_button_condition=>'P140_HANDLER_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(359177472235742023.4851)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_button_name=>'UPDATE_HANDLER'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aplicar Cambios'
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_warn_on_unsaved_changes=>null
,p_button_condition=>'P140_HANDLER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(359177528743742024.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_button_name=>'DELETE_HANDLER'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719734705014947853.4851)
,p_button_image_alt=>'Suprimir'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_warn_on_unsaved_changes=>null
,p_button_condition=>'P140_HANDLER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(619045789122969803.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(358905213997530230.4851)
,p_button_name=>'SOURCE_HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719735277951947858.4851)
,p_button_image_alt=>'Ayuda de origen'
,p_button_position=>'REGION_TEMPLATE_HELP'
,p_button_redirect_url=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.:RP::'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(619045845793969804.4851)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(359175352067742002.4851)
,p_button_name=>'PARAMETERS_HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(719735277951947858.4851)
,p_button_image_alt=>unistr('Ayuda de par\00E1metros')
,p_button_position=>'REGION_TEMPLATE_HELP'
,p_button_redirect_url=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.:RP::'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(381672726867069403.4851)
,p_branch_name=>'Branch to 130'
,p_branch_action=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:RP:P0_SELECTED_NODE,P130_TEMPLATE_ID:MT&P140_TEMPLATE_ID.,&P140_TEMPLATE_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(359177528743742024.4851)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(619047708251969823.4851)
,p_branch_name=>'Branch to 140'
,p_branch_action=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'REQUEST_IN_CONDITION'
,p_branch_condition=>'UPDATE_HANDLER,CREATE_HANDLER'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358045687642998627.4851)
,p_name=>'P140_TEMPLATE_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358045728205998628.4851)
,p_name=>'P140_MODULE_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358045857977998629.4851)
,p_name=>'P140_METHOD'
,p_is_required=>true
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_prompt=>unistr('M\00E9todo')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT d, r ',
'from ',
'(select 1 ord, ''GET'' d, ''GET''r',
'  from sys.dual',
' UNION ',
' select 2 ord, ''POST'' d, ''POST''r',
'  from sys.dual',
' UNION ',
' select 3 ord, ''PUT'' d, ''PUT''r',
'  from sys.dual',
' UNION ',
' select 4 ord, ''DELETE'' d, ''DELETE''r',
'  from sys.dual',
') a',
'where a.d not in (',
'SELECT c002',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_HANDLERS''',
'   and n002 = :P140_TEMPLATE_ID)',
'order by ord asc'))
,p_cHeight=>1
,p_read_only_when=>'P140_HANDLER_ID'
,p_read_only_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Identifica el m\00E9todo HTTP que se utilizar\00E1 para el manejador de recursos. Las cuatro opciones son:<p/>'),
'<ul>',
unistr('<li><b>GET</b>: recupera una representaci\00F3n de un recurso</li>'),
unistr('<li><b>POST</b>: crea un nuevo recurso o agrega un recurso a una recopilaci\00F3n</li>'),
'<li><b>PUT</b>: actualiza un recurso existente</li>',
'<li><b>DELETE</b>: suprime un recurso existente</li>',
'</ul>',
unistr('<p>Solo se permite un manejador por m\00E9todo HTTP.</p>'),
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358045950760998630.4851)
,p_name=>'P140_SOURCE_TYPE'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_prompt=>'Tipo de Origen'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.GROUP_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''Collection Query'' d, ''collection'' r, null grp',
'  from dual ',
'UNION ALL',
'select ''Collection Query Item'' d, ''item'' r, null grp',
'  from dual ',
'UNION ALL',
'select ''PL/SQL'' d, ''plsql'' r, null grp',
'  from dual ',
'UNION ALL',
'select ''Media Resource'' d, ''media'' r, null grp',
'  from dual ',
'UNION ALL',
'select  ''Query'' d, ''query'' r, ''Deprecated'' grp',
'  from dual ',
'UNION ALL',
'select  ''Query One Row'' d, ''onerow'' r, ''Deprecated'' grp',
'  from dual ',
'UNION ALL',
'select  ''Feed'' d, ''feed'' r, ''Deprecated'' grp',
'  from dual '))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737577300952641.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Define la implantaci\00F3n de origen para el m\00E9todo HTTP seleccionado.<p/>'),
'Las opciones incluyen:<p/>',
'<ul>',
unistr('<li><b>Consulta de recopilaci\00F3n</b>: ejecuta una consulta SQL y transforma el juego de resultados en una representaci\00F3n JSON est\00E1ndar de ORDS. Disponible cuando se ha seleccionado el m\00E9todo HTTP GET. Formato de resultado: JSON</li>'),
unistr('<li><b>Elemento de consulta de recopilaci\00F3n</b>: ejecuta una consulta SQL que devuelve una fila de datos en una representaci\00F3n JSON est\00E1ndar de ORDS. Disponible cuando se ha seleccionado el m\00E9todo HTTP GET. Formato de resultado: JSON</li>'),
unistr('<li><b>PL/SQL</b>: ejecuta un bloque PL/SQL an\00F3nimo y transforma los par\00E1metros OUT o IN/OUT en una representaci\00F3n JSON. La funci\00F3n htp.p se puede utilizar tambi\00E9n para emitir un JSON personalizado. Formato de resultado: JSON</li>'),
unistr('<li><b>Recurso de medios</b>: ejecuta una consulta SQL que cumpla un formato concreto y que devuelva el juego de resultados en una representaci\00F3n binaria con una cabecera HTTP Content-Type que identifique el tipo de medio de Internet de la representa')
||unistr('ci\00F3n. El formato de la consulta SQL debe ser:<p/><br/><i>SELECT ''content_type'', column FROM . . .</i><br/><br/>'),
unistr('donde <i>''content_type''</i> es una cadena transferida al explorador para utilizarla en la identificaci\00F3n de los datos entrantes, por ejemplo <i>''image/jpeg''</i>, y <i>column</i> es el nombre de la columna que contiene el origen de los datos que se de')
||unistr('vuelven. El tipo origen de recursos de medios normalmente se utiliza para los objetos de medios, como im\00E1genes, donde los datos los manejar\00E1 directamente el destinatario que realiza la llamada.</p>'),
'</ul>',
'<br/>',
'<p/>',
unistr('<B>NOTA:</B> Las opciones a continuaci\00F3n se encuentran en desuso, ya que son opciones espec\00EDficas de los servicios REST basados en APEX.<p/>'),
'<ul>',
unistr('<li><b>Consulta</b>: ejecuta una consulta SQL y transforma el juego de resultados en una representaci\00F3n de notaciones de objetos de JavaScript (JSON) heredada de ORDS o una representaci\00F3n CSV, seg\00FAn el formato seleccionado. Disponible cuando se ha se')
||unistr('leccionado el m\00E9todo HTTP GET. Formato de resultado: JSON o CSV</li>'),
unistr('<li><b>Consultar una fila</b>: ejecuta una consulta SQL que devuelve una fila de datos en una representaci\00F3n JSON heredada de ORDS. Disponible cuando se ha seleccionado el m\00E9todo HTTP GET. Formato de resultado: JSON</li>'),
unistr('<li><b>Fuente</b>: ejecuta una consulta SQL y transforma los resultados en una representaci\00F3n de fuente JSON. Cada elemento de la fuente contiene un resumen de un recurso y un hiperenlace a la representaci\00F3n completa del recurso. La primera columna d')
||unistr('e cada fila del juego de resultados debe ser un identificador \00FAnico para la fila y se debe utilizar para crear un hiperenlace con el siguiente formato: <em>path/to/feed/{id}</em>, en el que el valor de la primera columna se utilice como valor de <em>')
||unistr('{id}</em>. Se supone que las dem\00E1s columnas de la fila resumen el recurso y se incluyen en la fuente. Tambi\00E9n se debe definir una plantilla de recurso independiente para la representaci\00F3n completa del recurso. Formato de resultado: JSON</li>'),
'',
'</ul>',
''))
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358046019038998631.4851)
,p_name=>'P140_FORMAT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(358904035641530218.4851)
,p_item_default=>'json'
,p_prompt=>'Formato'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>'STATIC2:JSON;json,CSV;csv'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Seleccione el formato que se va a utilizar para el juego de resultados.</p>',
'<p>Estas son las opciones disponibles:',
'<ul>',
unistr('    <li><strong>JSON</strong>: la salida se transforma en el formato de documento de notaci\00F3n de objetos de JavaScript</li>'),
unistr('    <li><strong>CSV</strong>: la salida se transforma en una representaci\00F3n de valores separada por comas</li>'),
'</ul>',
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358046193262998632.4851)
,p_name=>'P140_MIME_TYPES_ALLOWED'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(358904551627530223.4851)
,p_prompt=>'Tipos MIME permitidos'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>80
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Lista separada por comas de tipos MIME que acepta el manejador. Solo se aplica a PUT y POST.<br/>',
'<br/>',
'Ejemplo:<br/>',
'<br/>',
'application/json</br>',
'text/csv <br/>',
'...'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358046204754998633.4851)
,p_name=>'P140_ITEMS_PER_PAGE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(358904551627530223.4851)
,p_prompt=>unistr('Tama\00F1o de Paginaci\00F3n')
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>10
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Introduzca el tama\00F1o de la ventana de paginaci\00F3n.</p>'),
unistr('<p>La paginaci\00F3n del m\00E9todo GET de operaciones HTTP del manejador de recursos equivale al n\00FAmero de filas que se deben devolver en cada p\00E1gina de un juego de resultados de formato JSON basado en una consulta de la base de datos. Si no se especifica e')
||unistr('l valor, se utiliza el valor de la configuraci\00F3n del m\00F3dulo de recursos.</p>'),
unistr('<p>Nota: Se proporcionar\00E1n enlaces para obtener los juegos de registros anteriores y posteriores. Estos enlaces utilizan las variables <code>:row_offset</code> y <code>:row_count</code> del origen para implantar la paginaci\00F3n especificada.</p>')))
,p_attribute_01=>'0'
,p_attribute_02=>'10000'
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358046342741998634.4851)
,p_name=>'P140_MODULE_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_prompt=>unistr('M\00F3dulo de Servicio RESTful')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_read_only_when_type=>'ALWAYS'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358046419296998635.4851)
,p_name=>'P140_MODULE_BASE_PATH'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_prompt=>unistr('Ruta de acceso base de m\00F3dulo')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_read_only_when_type=>'ALWAYS'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358046849970998639.4851)
,p_name=>'P140_SOURCE_TYPE_PLSQL'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_item_default=>'PL/SQL'
,p_prompt=>'Tipo de Origen'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358047101854998642.4851)
,p_name=>'P140_FORMAT_JSON'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(358904035641530218.4851)
,p_item_default=>'JSON'
,p_prompt=>'Formato'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358902388021530201.4851)
,p_name=>'P140_FORMAT_BINARY'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(358904035641530218.4851)
,p_item_default=>'Binary Representation'
,p_prompt=>'Formato'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358904995250530227.4851)
,p_name=>'P140_HANDLER_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(358905029352530228.4851)
,p_name=>'P140_COMMENTS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(358904551627530223.4851)
,p_prompt=>'Comentarios'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'Y'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(359179769296742046.4851)
,p_name=>'P140_MAX_LENGTH'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(358905213997530230.4851)
,p_source=>'32767'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(619047399820969819.4851)
,p_name=>'P140_URI_TEMPLATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_prompt=>'Plantilla de URI'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_read_only_when_type=>'ALWAYS'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(662196643155087013.4851)
,p_name=>'P140_URI'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(358045544097998626.4851)
,p_use_cache_before_default=>'NO'
,p_prompt=>'URL completa'
,p_post_element_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--small" onclick="void(0);" aria-label="&APP_TEXT$REST_WS_COPY_TO_CLIPBOARD_ARIA." type="button"  title="&APP_TEXT$REST_WS_COPY_TO_CLIPBOARD." data-clipboard-source="#P140_URI" styl'
||'e="margin-left:5px;"><span class="a-Icon icon-copy" aria-hidden="true"></span></button>',
''))
,p_source=>'&G_PROTOCOL.://&G_HTTP_HOST.&G_SCRIPT_NAME./&G_SCHEMA_ALIAS.&P140_MODULE_BASE_PATH.&P140_URI_TEMPLATE.'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P140_HANDLER_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(719737377976952639.4851)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(411296062415027823.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(359175352067742002.4851)
,p_validation_name=>'Validate Param Name'
,p_validation_sequence=>10
,p_validation=>'NAME'
,p_validation2=>'^([-a-zA-Z0-9_\.]*)$'
,p_validation_type=>'REGULAR_EXPRESSION'
,p_error_message=>unistr('#COLUMN_HEADER# solo debe contener caracteres alfab\00E9ticos, num\00E9ricos, de guion, de subrayado o de punto.')
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'NAME'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
begin
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(411296102786027824.4851)
,p_tabular_form_region_id=>wwv_flow_api.id(359175352067742002.4851)
,p_validation_name=>'Validate Bind Variable Name'
,p_validation_sequence=>20
,p_validation=>'BIND_VARIABLE_NAME'
,p_validation2=>'^([a-zA-Z0-9_]*)$'
,p_validation_type=>'REGULAR_EXPRESSION'
,p_error_message=>unistr('#COLUMN_HEADER# solo puede tener caracteres alfab\00E9ticos, num\00E9ricos y de subrayado.')
,p_associated_item=>wwv_flow_api.id(.4851)
,p_associated_column=>'BIND_VARIABLE_NAME'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(358902408339530202.4851)
,p_name=>'Toggle Items METHOD=GET'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P140_METHOD'
,p_condition_element=>'P140_METHOD'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'GET'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358902553955530203.4851)
,p_event_id=>wwv_flow_api.id(358902408339530202.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P140_SOURCE_TYPE,P140_ITEMS_PER_PAGE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358902657141530204.4851)
,p_event_id=>wwv_flow_api.id(358902408339530202.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P140_SOURCE_TYPE,P140_ITEMS_PER_PAGE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358904237955530220.4851)
,p_event_id=>wwv_flow_api.id(358902408339530202.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(358904035641530218.4851)
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358904380671530221.4851)
,p_event_id=>wwv_flow_api.id(358902408339530202.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(358904035641530218.4851)
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358902762912530205.4851)
,p_event_id=>wwv_flow_api.id(358902408339530202.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P140_SOURCE_TYPE_PLSQL'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358902843634530206.4851)
,p_event_id=>wwv_flow_api.id(358902408339530202.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P140_SOURCE_TYPE_PLSQL'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(359179660607742045.4851)
,p_event_id=>wwv_flow_api.id(358902408339530202.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>40
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P140_SOURCE_TYPE'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'plsql'
,p_attribute_09=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(358902927743530207.4851)
,p_name=>'Toggle Items METHOD in PUT,POST'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P140_METHOD'
,p_condition_element=>'P140_METHOD'
,p_triggering_condition_type=>'IN_LIST'
,p_triggering_expression=>'PUT,POST'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358903033381530208.4851)
,p_event_id=>wwv_flow_api.id(358902927743530207.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P140_MIME_TYPES_ALLOWED'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358903175300530209.4851)
,p_event_id=>wwv_flow_api.id(358902927743530207.4851)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P140_MIME_TYPES_ALLOWED'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(358903407006530212.4851)
,p_name=>'Change of SOURCE TYPE'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P140_SOURCE_TYPE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(358904432601530222.4851)
,p_event_id=>wwv_flow_api.id(358903407006530212.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if ($(''#P140_METHOD'').find(":selected").val() == ''GET''|| $(''#P140_METHOD'').val() == ''GET'') {',
'   if  ($(''#P140_SOURCE_TYPE'').find(":selected").val() == ''query'') {',
'       $x_Show(''P140_FORMAT'');',
'       $x_Hide(''P140_FORMAT_JSON'');',
'       $x_Hide(''P140_FORMAT_BINARY'');',
'   } else if ($(''#P140_SOURCE_TYPE'').find(":selected").val() == ''media'') {',
'       $x_Show(''P140_FORMAT_BINARY'');',
'       $x_Hide(''P140_FORMAT_JSON'');',
'       $x_Hide(''P140_FORMAT'');',
'   } else {',
'       $x_Show(''P140_FORMAT_JSON'');',
'       $x_Hide(''P140_FORMAT_BINARY'');',
'       $x_Hide(''P140_FORMAT'');',
'   }  ',
'    ',
'}'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(359179962554742048.4851)
,p_name=>'Save'
,p_event_sequence=>50
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(359177472235742023.4851)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(359180039959742049.4851)
,p_event_id=>wwv_flow_api.id(359179962554742048.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'gStoreScript(''SAVE'', false, function(saveNew) {',
'      apex.submit(''UPDATE_HANDLER'');',
'});',
''))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(359180132867742050.4851)
,p_name=>'CREATE'
,p_event_sequence=>60
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(359177342683742022.4851)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(381672523658069401.4851)
,p_event_id=>wwv_flow_api.id(359180132867742050.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'gStoreScript(''CREATE'', false, function() {',
'      apex.submit(''CREATE_HANDLER'');',
'});'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(395744443646448605.4851)
,p_name=>'Process Delete'
,p_event_sequence=>70
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(359177528743742024.4851)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(395745334271448644.4851)
,p_event_id=>wwv_flow_api.id(395744443646448605.4851)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.confirm(''Are you sure you wish to delete this Handler and all children?'',''DELETE_HANDLER'');'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(358960799518334105.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fetch row from ORDS_HANDLERS Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE ',
'    l_handler_id          number;',
'    l_template_id         number;',
'    l_source_type         varchar2(255);',
'    l_method              varchar2(10);',
'    l_mimes_allowed       varchar2(255);',
'    l_items_per_page      number;',
'    l_comments            varchar2(4000);',
'    l_module_id           number;',
'BEGIN',
'',
'-- Get the Handler information from the collection',
'   select ',
'       n001 handler_id,',
'       n002 template_id,',
'       c001 source_type, ',
'       c002 method,',
'       c003 mimes_allowed,',
'       n003 items_per_page,',
'       c004 comments',
'  INTO ',
'      l_handler_id,',
'      l_template_id,   ',
'      l_source_type,   ',
'      l_method,        ',
'      l_mimes_allowed, ',
'      l_items_per_page,',
'      l_comments    ',
'  from wwv_flow_collections ',
' where collection_name = ''ORDS_HANDLERS''',
'   and (n001 = :P140_HANDLER_ID',
'        OR',
'        (c002 = :P140_METHOD',
'         and',
'         n002 = :P140_TEMPLATE_ID)',
'       );',
'  ',
'-- Assign the values to the page items',
'   :P140_HANDLER_ID      := l_handler_id;',
'   :P140_TEMPLATE_ID     := l_template_id;',
'   :P140_METHOD          := l_method;',
'   :P140_SOURCE_TYPE     := case l_source_type',
'                            when ''json/collection'' then ''collection''',
'                            when ''json/item'' then ''item''',
'                            when ''json/query''then ''query''',
'                            when ''csv/query'' then ''query''',
'                            when ''json/query;type=single'' then ''onerow''',
'                            when ''json/query;type=feed'' then ''feed''',
'                            when ''plsql/block'' then ''plsql''',
'                            when ''resource/lob''then ''media''',
'                            end;',
'   :P140_FORMAT          := case l_source_type ',
'                            when ''csv/query'' then ''csv''',
'                            else ''json''',
'                            end;',
'   :P140_MIME_TYPES_ALLOWED   := l_mimes_allowed;',
'   :P140_ITEMS_PER_PAGE  := l_items_per_page;',
'   :P140_COMMENTS        := l_comments;',
'   ',
'-- Now we need to get the MODULE name',
'select n001 id',
'  into l_module_id ',
'  from wwv_flow_collections',
' where collection_name = ''ORDS_MODULES''',
'   and n001 = (select n002 ',
'                 from wwv_flow_collections',
'                where collection_name = ''ORDS_TEMPLATES''',
'                  and n001 = l_template_id);',
'           ',
':P140_MODULE_ID := l_module_id;',
'-- ',
':P0_SELECTED_NODE := ''TH''||l_handler_id;',
'   ',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P140_HANDLER_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(381691470012193485.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Module Name'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
' select c001 module_name, ',
'       case when substr(c002,1,1) = ''/'' then c002',
'            else ''/''||c002',
'       end base_path ',
'  into :P140_MODULE_NAME,',
'       :P140_MODULE_BASE_PATH',
'  from wwv_flow_collections',
' where COLLECTION_NAME= ''ORDS_MODULES''',
'   and n001 = :P140_MODULE_ID;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P140_MODULE_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(381672938639069405.4851)
,p_process_sequence=>30
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Template Name'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001',
'  into :P140_URI_TEMPLATE',
'  from wwv_flow_collections',
' where COLLECTION_NAME= ''ORDS_TEMPLATES''',
'   and n001 = :P140_TEMPLATE_ID;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P140_TEMPLATE_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(381676227444069438.4851)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create CHANGED_PARAMS collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'apex_collection.create_or_truncate_collection(''CHANGED_PARAMS'');',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(359176414738742013.4851)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_api.id(359175352067742002.4851)
,p_process_type=>'NATIVE_IG_DML'
,p_process_name=>'Parameters - Save Interactive Grid Data'
,p_attribute_01=>'PLSQL_CODE'
,p_attribute_04=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'  apex_collection.add_member(p_collection_name => ''CHANGED_PARAMS'',',
'                             p_n001            => :ID,',
'                             p_c001            => :NAME,',
'                             p_c002            => :BIND_VARIABLE_NAME,',
'                             p_c003            => :SOURCE_TYPE,',
'                             p_c004            => :ACCESS_METHOD,',
'                             p_c005            => :PARAM_TYPE,',
'                             p_c006            => :COMMENTS,',
'                             p_c007            => :APEX$ROW_STATUS);',
'end;'))
,p_attribute_05=>'N'
,p_attribute_06=>'N'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_only_for_changed_rows=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(395802048748090610.4851)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Process Changed Handler'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'  wwv_flow_rest_ws.process_rest_ws_request(p_request=> :REQUEST, p_parse_as => :P0_SCHEMA);',
'  -- Set Handler ID to -1 to force refresh of details after creating new handler',
'  :P140_HANDLER_ID := -1;',
'END;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(359179889405742047.4851)
,p_process_sequence=>10
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'STO