prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.17'
,p_default_workspace_id=>10
,p_default_application_id=>4411
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4411 - Oracle APEX  System Messages and Native Types
--
-- Application Export:
--   Application:     4411
--   Name:            Oracle APEX  System Messages and Native Types
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Themes:                 1
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             124
--       Globalization:
--         Messages:          14,593
--       Reports:
--       E-Mail:
--     Supporting Objects:  Included
--   Version:         19.2.0.00.17
--   Instance ID:     248353129556926
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX  System Messages and Native Types')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'4411')
,p_application_group=>91050719712959059
,p_application_group_name=>'APEX Product'
,p_application_group_comment=>'Applications shipped with the APEX product distribution'
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191025005115'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'en'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_documentation_banner=>'Oracle Application Express (APEX) User interface messages used to support translation of strings that are not defined as part of the core APEX user interface.'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(91645213681389498)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.17'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20191025005115'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562090986404402217)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48650898565635010)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Sign out'
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>'Sign out of Application Express'
,p_list_text_09=>'Y'
,p_list_text_10=>'logout exit quit :q'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(281916990329150760)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Create an application on a spreadsheet'
,p_list_item_link_target=>'f?p=4000:447:&APP_SESSION.::NO:448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT::'
,p_list_text_01=>'Import your excel or csv files and create an application'
,p_list_text_09=>'Y'
,p_list_text_10=>'excel csv xsl xslx spreadsheet data paste load import'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(282255839842182292)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Oracle APEX Home'
,p_list_item_link_target=>'f?p=4500:1000:&APP_SESSION.'
,p_list_text_10=>'homepage start '
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(296033420364984683)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Browse Font APEX Icons'
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>'Browse Font APEX icons, add modifiers, and copy CSS or HTML you need.'
,p_list_text_09=>'Y'
,p_list_text_10=>'icons font apex library graphics'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562091518091404815)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562091727563404815)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Export Application'
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>'Export Application {APP_ID} as SQL File'
,p_list_text_09=>'Y'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562093357853428158)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Unused Lists'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562092153904409717)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48392393581618193)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Console Log'
,p_list_item_link_target=>'javascript:console.log(''hello friend'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14843831009863117)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859012524941040)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(86380554411225400)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91997339122572414)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(460407779408652225)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(497671453666914719)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attribute_01=>'fa-star'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082458703597614427)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082517678315623391)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072678475712055)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831649180083980462)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780276458994154)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1832884277947217587)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1840861033969283097)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917665913120940054)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1990227023531717243)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626406749381989)
,p_theme_id=>1
,p_name=>'One Level Tabs'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE# ',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626529080381989)
,p_theme_id=>1
,p_name=>'Printer Friendly'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(91626823864381990)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(91632832228382001)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(91636711305382010)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(91638400927382012)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(91638400927382012)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(91641225667382016)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641730492382017)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641814330382017)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(91642503902382024)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>'Search Dialog'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Search'
,p_close_button_text=>'Close'
,p_next_button_text=>'Next >'
,p_prev_button_text=>'< Previous'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91641910982382018)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642102481382020)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642303533382020)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
wwv_flow_api.create_theme(
 p_id=>wwv_flow_api.id(91642708702382024)
,p_theme_id=>1
,p_theme_name=>'Red'
,p_theme_internal_name=>'RED'
,p_ui_type_name=>'DESKTOP'
,p_navigation_type=>'T'
,p_nav_bar_type=>'NAVBAR'
,p_is_locked=>false
,p_default_page_template=>wwv_flow_api.id(91626406749381989)
,p_error_template=>wwv_flow_api.id(91626406749381989)
,p_printer_friendly_template=>wwv_flow_api.id(91626529080381989)
,p_breadcrumb_display_point=>'REGION_POSITION_01'
,p_sidebar_display_point=>'REGION_POSITION_02'
,p_login_template=>wwv_flow_api.id(91625820476381987)
,p_default_button_template=>wwv_flow_api.id(91626823864381990)
,p_default_region_template=>wwv_flow_api.id(91632832228382001)
,p_default_chart_template=>wwv_flow_api.id(91631622717381999)
,p_default_form_template=>wwv_flow_api.id(91630725782381998)
,p_default_reportr_template=>wwv_flow_api.id(91632832228382001)
,p_default_tabform_template=>wwv_flow_api.id(91632832228382001)
,p_default_wizard_template=>wwv_flow_api.id(91632204784382001)
,p_default_menur_template=>wwv_flow_api.id(91633105066382001)
,p_default_listr_template=>wwv_flow_api.id(91627727983381992)
,p_default_report_template=>wwv_flow_api.id(91638400927382012)
,p_default_label_template=>wwv_flow_api.id(91641225667382016)
,p_default_menu_template=>wwv_flow_api.id(91641814330382017)
,p_default_calendar_template=>wwv_flow_api.id(91642102481382020)
,p_default_list_template=>wwv_flow_api.id(91636711305382010)
,p_default_option_label=>wwv_flow_api.id(91641225667382016)
,p_default_required_label=>wwv_flow_api.id(91641529261382017)
,p_default_page_transition=>'NONE'
,p_default_popup_transition=>'NONE'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(1),'')
);
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
wwv_flow_api.create_language_map(
 p_id=>wwv_flow_api.id(72245617218976155)
,p_translation_flow_id=>4412
,p_translation_flow_language_cd=>'es'
,p_translation_comments=>'APEX System Messages and Native Types - Spanish'
,p_direction_right_to_left=>'N'
);
wwv_flow_api.create_language_map(
 p_id=>wwv_flow_api.id(72245702935976155)
,p_translation_flow_id=>4413
,p_translation_flow_language_cd=>'fr'
,p_translation_comments=>'APEX System Messages and Native Types - French'
,p_direction_right_to_left=>'N'
);
wwv_flow_api.create_language_map(
 p_id=>wwv_flow_api.id(72245830838976155)
,p_translation_flow_id=>4414
,p_translation_flow_language_cd=>'de'
,p_translation_comments=>'APEX System Messages and Native Types - German'
,p_direction_right_to_left=>'N'
);
wwv_flow_api.create_language_map(
 p_id=>wwv_flow_api.id(72245929066976155)
,p_translation_flow_id=>4415
,p_translation_flow_language_cd=>'it'
,p_translation_comments=>'APEX System Messages and Native Types - Italian'
,p_direction_right_to_left=>'N'
);
wwv_flow_api.create_language_map(
 p_id=>wwv_flow_api.id(72246029698976155)
,p_translation_flow_id=>4416
,p_translation_flow_language_cd=>'pt-br'
,p_translation_comments=>'APEX System Messages and Native Types - Brazilian Portuguese'
,p_direction_right_to_left=>'N'
);
wwv_flow_api.create_language_map(
 p_id=>wwv_flow_api.id(72246123317976155)
,p_translation_flow_id=>4417
,p_translation_flow_language_cd=>'zh-cn'
,p_translation_comments=>'APEX System Messages and Native Types - Simplified Chinese'
,p_direction_right_to_left=>'N'
);
wwv_flow_api.create_language_map(
 p_id=>wwv_flow_api.id(72246228444976155)
,p_translation_flow_id=>4418
,p_translation_flow_language_cd=>'zh-tw'
,p_translation_comments=>'APEX System Messages and Native Types - Traditional Chinese'
,p_direction_right_to_left=>'N'
);
wwv_flow_api.create_language_map(
 p_id=>wwv_flow_api.id(72246319589976155)
,p_translation_flow_id=>4419
,p_translation_flow_language_cd=>'ko'
,p_translation_comments=>'APEX System Messages and Native Types - Korean'
,p_direction_right_to_left=>'N'
);
wwv_flow_api.create_language_map(
 p_id=>wwv_flow_api.id(72246430201976155)
,p_translation_flow_id=>4420
,p_translation_flow_language_cd=>'ja'
,p_translation_comments=>'HTML DB System Messages - Japanese'
,p_direction_right_to_left=>'N'
);
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1814227314326251)
,p_name=>'2DCOLUMN'
,p_message_text=>'2D Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1816526316326253)
,p_name=>'2DCOLUMN_LINE'
,p_message_text=>'2D Column Line'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1814413427326252)
,p_name=>'2DDOUGHNUT'
,p_message_text=>'2D Doughnut'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1816323524326253)
,p_name=>'2DHSTACKED_PCT'
,p_message_text=>'Stacked Horizontal 2D Column (Percent)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1814513062326252)
,p_name=>'2DLINE'
,p_message_text=>'2D Line'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1814632268326252)
,p_name=>'2DPIE'
,p_message_text=>'2D Pie'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1816109684326252)
,p_name=>'2DSTACKED_PCT'
,p_message_text=>'Stacked 2D Column (Percent)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1814703346326252)
,p_name=>'3DCOLUMN'
,p_message_text=>'3D Column'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1816420921326253)
,p_name=>'3DHSTACKED_PCT'
,p_message_text=>'Stacked Horizontal 3D Column (Percent)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1814811711326252)
,p_name=>'3DPIE'
,p_message_text=>'3D Pie'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1816210234326253)
,p_name=>'3DSTACKED_PCT'
,p_message_text=>'Stacked 3D Column (Percent)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455039001641343152)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_text=>'0 Items for insert into the Attribute Dictionary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455037830590266387)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_text=>'0 Items for update'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455053331966541163)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_text=>'0 Items for update of the Attribute Dictionary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455058806180647209)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_text=>'0 Report Columns for insert into the Attribute Dictionary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455059408735657438)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_text=>'0 Report Columns for update of the Attribute Dictionary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455037519855263300)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_text=>'Review %0 Items for update'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455057508903619572)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_text=>'0 Report Columns for update'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455038728175341364)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_text=>'Review %0 Items for insert into the Attribute Dictionary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455039712077374539)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_text=>'Review %0 Items for update of the Attribute Dictionary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455058528559644236)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_text=>'Review %0 Report Columns for insert into the Attribute Dictionary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455057100246617113)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_text=>'Review %0 Report Columns for update'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455059100424655013)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_text=>'Review %0 Report Columns for update of the Attribute Dictionary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(237332502821717106)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_text=>'Value must be numeric.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(218854722491089205)
,p_name=>'4000_639_SEQ_MESG'
,p_message_text=>'<span class="fielddata"> Cannot reorder because Region sequences are not unique.</span>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(218862500140319382)
,p_name=>'4000_641_SEQ_MESG'
,p_message_text=>'<span class="fielddata">Cannot reorder because Button sequences are not unique.</span>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(218862911568322684)
,p_name=>'4000_646_SEQ_MESG'
,p_message_text=>'<span class="fielddata">Cannot reorder because Navigation Bar sequences are not unique.</span>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(218863320572325259)
,p_name=>'4000_749_SEQ_MESG'
,p_message_text=>'<span class="fielddata">Cannot reorder because Region Item sequences are not unique.</span>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(294714627951753160)
,p_name=>'4000_APPLICATION_ID'
,p_message_text=>'Application ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(42641015751974682)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_text=>'Edit Application: %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(190191216789904908)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_text=>'The specified date format is invalid.  The calendar requires a date in YYYYMMDD format.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(244160625121134779)
,p_name=>'4000_TREE'
,p_message_text=>'Tree'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(294716021025786683)
,p_name=>'4000_WORKSPACE_ID'
,p_message_text=>'Workspace ID'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145516618269340884)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the name of the new schema to be created.  Choose',
'         a password for the schema, and choose the default tablespace',
'         and temporary tablespace.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145518524503342700)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_text=>'Enter the name of the existing schema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145538114591349291)
,p_name=>'4050_106_WHEN_DONE'
,p_message_text=>'When done, click the "Next &gt;" button'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109980301694498629)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_text=>'Drop tablespaces and associated datafiles: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109979522687495285)
,p_name=>'4050_110_DROP_USERS'
,p_message_text=>'Drop database users: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(620830686957124301)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_text=>'Web Service Activity Log entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145045413871421848)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_text=>'Developer activity log entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15389030604151768)
,p_name=>'4050_31_LOG_COUNT'
,p_message_text=>'Login Access Log entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145015920573357494)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_text=>'Change Requests'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145018106852362972)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_text=>'Runtime Requests'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145005228968340997)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_text=>'Workspace Requests'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145168805550693769)
,p_name=>'4050_46_AD_HOC'
,p_message_text=>'SQL Command Processor history entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145168027236690625)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_text=>'Control File execution log entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145163630915682190)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_text=>'Script File execution log entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145171026328699838)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_text=>'SQL Archives entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145297613131093383)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_text=>'Active Log Information'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145299932178098938)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_text=>'Current Log Number'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145301013262102934)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_text=>'Current Log Timestamp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145352109200158478)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_text=>'Hours until next log switch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145337722051114944)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_text=>'Interval in days (constant)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145351432618155852)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_text=>'Next log switch scheduled for'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145357628378173480)
,p_name=>'4050_70_DEV_ACT'
,p_message_text=>'Developer activity log entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145361831972183993)
,p_name=>'4050_71_CLICK'
,p_message_text=>'Click through log entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145413101375241443)
,p_name=>'4050_75_AD_HOC'
,p_message_text=>'SQL Command Processor history entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145412628602239809)
,p_name=>'4050_75_CTRL_FILE'
,p_message_text=>'Control File execution log entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145409911633234875)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_text=>'Script File execution log entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145417806701252460)
,p_name=>'4050_75_SQL_ARCH'
,p_message_text=>'SQL Archives entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145477428995268293)
,p_name=>'4050_82_WORKSPACE'
,p_message_text=>'Workspace %1 has %2 applications and %3 user(s).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145511106017327963)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_text=>'Click Counting log entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(254832409736047670)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_text=>'Productivity and Sample Apps'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(254879209723062815)
,p_name=>'4050_PACKAGED_WEBSHEETS'
,p_message_text=>'Sample Websheets'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(254079723483458269)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_text=>'Workspace Count'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(51155503034194159)
,p_name=>'4150_COLUMN_NUMBER'
,p_message_text=>'Column %0'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(122877330359500032)
,p_name=>'4350_APPLICATION'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(122913011490532448)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_text=>'Edit Application'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20432100261357601)
,p_name=>'4500 800 HD DBA'
,p_message_text=>'Oracle Database Express Edition 2 Day DBA.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20432505802359273)
,p_name=>'4500 800 HD DEV'
,p_message_text=>'Oracle Database Express Edition 2 Day Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20429928742346966)
,p_name=>'4500 800 HD HTMLDB'
,p_message_text=>'Oracle Application Express 2 Day Plus Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20433018615362986)
,p_name=>'4500 800 HD JAVA'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus Java Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20433423810364408)
,p_name=>'4500 800 HD NET'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus .NET Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20433828658365814)
,p_name=>'4500 800 HD PHP'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus PHP Developer.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20434315976371693)
,p_name=>'4500 800 MSG DBA'
,p_message_text=>'Discusses common day-to-day administrative tasks.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20434826711374726)
,p_name=>'4500 800 MSG DEV'
,p_message_text=>'Explains how to take advantage of the Oracle Database Express Edition development environment.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20435308834379034)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_text=>'Offers a series to tutorials that describe how to build database-centric Web applications.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20436611043389140)
,p_name=>'4500 800 MSG JAVA'
,p_message_text=>'This document provides a tutorial that shows you how to use Java and JDBC to connect to Oracle Database XE, and demonstrates how to use to develop a simple Java application that accesses and modifies data.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20437122471392467)
,p_name=>'4500 800 MSG NET'
,p_message_text=>'This document describes the key features of Oracle Data Provider for .NET and Oracle Developer Tools for Visual Studio .NET. It leads you through installation and configuration, shows how to build basic applications using Oracle Data Provider for .NE'
||'T and Oracle Developer Tools for Visual Studio .NET, and how to create and use both PL/SQL and .NET stored procedures.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20435718185381740)
,p_name=>'4500 800 MSG PHP'
,p_message_text=>'This document provides a tutorial that shows you how to download and install Apache and the Zend Core PHP drivers, and then how to use PHP to connect to Oracle Database XE, and demonstrates how to use PHP to develop a simple application that accesses'
||' and modifies data.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9769223806175173)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9768218827164295)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_text=>'Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9770107314179814)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_text=>'Condition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(164969022563427041)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_text=>'Delete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9772910562190200)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_text=>'Function'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9773819913192934)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_text=>'Group By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9769730386177026)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_text=>'Object'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9771831902186993)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_text=>'Show'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9770515280182137)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_text=>'Sort Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9771224630184824)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_text=>'Sort Order'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10964410371662927)
,p_name=>'4500_1002_QB_JOIN'
,p_message_text=>'Join'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9296531469510943)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_text=>'Click here to select column for join'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11155203668127634)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_text=>'A maximum of 60 columns may be selected.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9295919348507481)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_text=>'Remove'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9295405496503444)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_text=>'Show/Hide Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10964702537670191)
,p_name=>'4500_1002_QB_TO'
,p_message_text=>'to'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(8942925019019788)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_text=>'Results of %0, run %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(110293223052704114)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_text=>'Return to Original Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14084928671830801)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_text=>'First %0 columns displayed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(180129026087321856)
,p_name=>'4500_SESS_EVENT'
,p_message_text=>'Event'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(180128316737319102)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_text=>'Kilobytes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(180127911196317514)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_text=>'Megabytes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21299607759967144)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_text=>'User Interface Defaults are used by the App Builder to populate initial values for region and item properties providing consistency across multiple pages in an application or multiple applications.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(27776610928855106)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_text=>'This application requires cookies to be enabled.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(27747406874537909)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_text=>'This application requires JavaScript to be enabled.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103207632130908587)
,p_name=>'4800_9015_UPDATE_OVERDUE_FEATURES'
,p_message_text=>'%0 overdue feature(s) will be updated to the selected new milestone.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(188057516467537629)
,p_name=>'ABOUT'
,p_message_text=>'About'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(907030700283981973)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_text=>'Please confirm adding the following %0 user(s) to your workspace.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(195669319386995168)
,p_name=>'ACCEPTED'
,p_message_text=>'Accepted'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184002513763630549)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_text=>'Accessibility Assignee'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183995707136600262)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_text=>'Accessibility Impact'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184004003505637013)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_text=>'Accessibility Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2040478723215461769)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_text=>'Accessibility Tested'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13171516960524093)
,p_name=>'ACCESS_CONTROL_ADMIN'
,p_message_text=>'Administrator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66768901771821180)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_text=>'Administration Rights'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13038822941882315)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_text=>'Access Control Administration Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(155070400433342171)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_text=>'Administrator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(232263043267802089)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_text=>'Role assigned to application administrators.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13164129717423676)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_text=>'Application Administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13167830503480662)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_text=>'Application Mode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13167215958476490)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_text=>'Identify how access to this application will be controlled.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13190231008067472)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_text=>'Unable to process set application mode request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13190621789074218)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_text=>'Application Mode Set.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67427815913071208)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_text=>'You may not delete yourself.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67430621023091671)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_text=>'You may not remove administrator privilege from yourself.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13047625590949379)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_text=>'Create Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(155069799286334366)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_text=>'Contribution Rights'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(155070692180345306)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_text=>'Contributor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(232263370382804234)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_text=>'Role assigned to application contributors.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(181826015286466071)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_text=>'The following Application Setting(s) will be created:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(155071206201353888)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_text=>'The following Application Access Role(s) will be created:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19726902022653116)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_text=>'The following Authorization Scheme(s) will be created:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39652705194868521)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_text=>'Unable to create access control page. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39651309219860229)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_text=>'Unable to create access control tables. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(69251416022747608)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_text=>'You may not enter duplicate username.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66770728090828700)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_text=>'access control - edit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13175605925549284)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_text=>'Enter case insensitive query criteria, then press the <b>Go</b> button.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13183519140007243)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_text=>'Unable to get application administration mode.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13174505447539669)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_text=>'Last Changed By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13169100290490889)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_text=>'Access Control List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13164713572428457)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_text=>'Full access to all, access control list not used.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13165400543434154)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_text=>'Restricted access. Only users defined in the access control list are allowed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13166015088438389)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_text=>'Public read only. Edit and administrative privileges controlled by access control list.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13166623100469024)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_text=>'Administrative access only.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13188211353042819)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_text=>'No privilege for attempted action.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13170831374518767)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_text=>'Privilege'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(181819236830426340)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_text=>'Reader Rights'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(181819006172424408)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_text=>'Reader'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(232263806108806288)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_text=>'Role assigned to application readers.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19873728462944627)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_text=>'Identify usernames which correspond to this application''s authentication scheme.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13168516436486095)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_text=>'Set Application Mode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(44642222810423676)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_text=>'The access control pages have been created successfully.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13169925917498281)
,p_name=>'ACCESS_CONTROL_USERNAME'
,p_message_text=>'Username'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(155071510027356455)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_text=>'Use Existing Access Control Role'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19825416155827552)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_text=>'Use Existing Authorization Scheme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19726026001641114)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_text=>'Use Existing Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66771912075843074)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_text=>'access control - view'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(165227926946634514)
,p_name=>'ACCESS_DENIED_SIMPLE'
,p_message_text=>'Access Denied'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20472403022632871)
,p_name=>'ACCOUNT_CREATED'
,p_message_text=>'Account created.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60533207866610929)
,p_name=>'ACCOUNT_HAS_BEEN_CREATED'
,p_message_text=>'Your %0 account has been created.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20152105108981523)
,p_name=>'ACCOUNT_LOCKED'
,p_message_text=>'The account is locked.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(389048005730370199)
,p_name=>'ACCOUNT_MENU'
,p_message_text=>'Account Menu'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(173001212090777484)
,p_name=>'ACKNOWLEDGED'
,p_message_text=>'Acknowledged'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(173007316901826204)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_text=>'Acknowledged, no action'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(205915321720818630)
,p_name=>'ACL_ADD_USER'
,p_message_text=>'Add User'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623904200121647964)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_text=>'Access Dashboard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623904728172656022)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_text=>'Access Monitor Activity'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623899814488614244)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_text=>'Add / Modify'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623903020768644500)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_text=>'Administration when Running Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623893122790541004)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_text=>'Administration from within App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623896920244606431)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_text=>'Annotations (files, tags, notes)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623890708283489468)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_text=>'Application Express Account Authentication without Access Control List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623890406074479441)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_text=>'Authentication with Access Control List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623896318120577480)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_text=>'Edit SQL Access and Suggested Objects'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(628482831215278735)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_text=>'Once authenticated to an application, access control specifies what users can do within the application. The table below identifies what capabilities different types of users will have based on the authentication being used within this application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623904901768667361)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_text=>'Maintain Access Control List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623896523445588443)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_text=>'Run and View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623895629071571156)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_text=>'Update Application Properties'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(442738628681346793)
,p_name=>'ACTIONS'
,p_message_text=>'Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(622852123755935803)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_text=>'Action Menu Settings'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23004506192614313)
,p_name=>'ACTIVE'
,p_message_text=>'Active'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160800423410678999)
,p_name=>'ACTIVITY'
,p_message_text=>'Activity'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184162618020814333)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Activity Summary',
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(367642914624521833)
,p_name=>'ADDED_BY'
,p_message_text=>'Added By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(617128321947502667)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_text=>'Added to Purge List'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(435244708193906718)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_text=>'Additional information requested'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146309201279652859)
,p_name=>'ADD_ARGUEMENT'
,p_message_text=>'Add Argument'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145295524643077859)
,p_name=>'ADD_COLUMN'
,p_message_text=>'Add Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270356309633834871)
,p_name=>'ADD_COLUMN_NAME'
,p_message_text=>'Add Column %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(96747802282607912)
,p_name=>'ADD_CONSTRAINT'
,p_message_text=>'Add Constraint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145158415069658752)
,p_name=>'ADD_MORE...'
,p_message_text=>'Add More...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(170150827202818987)
,p_name=>'ADD_ROW'
,p_message_text=>'Add Row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278104512676327727)
,p_name=>'ADD_USER_INTERFACE'
,p_message_text=>'Add User Interface'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(290106114414522846)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_text=>'Adjust provisioned space by %0 megabytes'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145049818158432512)
,p_name=>'ADMIN'
,p_message_text=>'Admin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(17810000592953257)
,p_name=>'ADMINISTRATOR'
,p_message_text=>'Workspace Administrator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184039402886242283)
,p_name=>'ADMINISTRATORS'
,p_message_text=>'Administrators'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145601307809214859)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_text=>'Administrators email must be provided'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240625155773891491)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_text=>'Accessibility'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25296814352073057)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_text=>'Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25297430975077855)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_text=>'Performance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25297709306582514)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_text=>'Quality Assurance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25297021278075098)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_text=>'Security'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25297915540584280)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_text=>'Usability'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25297225434076270)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_text=>'Warning'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(356767707912315557)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_text=>'Item "%1" is protected and can not be set via an Ajax call.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(356770604517514650)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_text=>'Item "%1" is protected and can not be set via an Ajax call.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(362665601326910853)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_text=>'Item "%1" is protected and can not be set via an Ajax call.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37150127533471770)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_text=>'Missing SYS schema prefix'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(480431173835158437)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_text=>'Usage of WWV_FLOW APIs (use APEX APIs instead)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(420868258611572443)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_text=>'Column %0 does not exist in Region Source SQL Statement!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25318319241869637)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_text=>'Interactive Report column %0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25316006670869634)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_text=>'%0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21580909857697783)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_text=>'Column %0 does not exist in Region Source SQL Statement!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(500053531887502655)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_text=>'Tabular Form column %0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25316122214869634)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_text=>'%0 cannot be referenced as application or page item name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(931576377428421039)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_text=>'Ajax Callback application process is not protected by an authorization scheme.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(931430218509929499)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_text=>'Page is not protected by an authorization scheme.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25317007970869636)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_text=>'Target page %1 (within application %0) has no authorization scheme defined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(932274342204661069)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_text=>'Authorization of this page is different to authorization "%1" of parent page %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25317132477869636)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_text=>'Authorization "%0" on target page is different to "%1".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25315632635869633)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_text=>'%0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25315516938869633)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_text=>'Could not perform bind variable syntax check. Error: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25315705427869634)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_text=>'%0 cannot be referenced with bind variable syntax.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25317711275869636)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_text=>'Unconditional branch before other branches.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(931429660986921496)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_text=>'Autocomplete is set to "On" for a page that contains password items.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(931430051637925888)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_text=>'"Cache" allows the browser to cache sensitive data.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(573558501444704314)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_text=>'"Embed in Frames" leaves the application vulnerable to clickjacking attacks.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(573558744556709386)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_text=>'"HTML Escaping Mode" only escapes a limited set of characters.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6723418373787727)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'ID found in the Button Attributes, for a button referenced in a Dynamic Action (%0). ',
'',
'When an ID is defined in Button Attributes, this will cause Dynamic Actions referencing the button not to work. Please consider removing this ID, as the button will generate an ID by default.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6725910839116736)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Button Template used by a button, that itself is referenced in a Dynamic Action (%0) does not contain the #BUTTON_ID# substitution string.',
'',
'Template:',
'%1',
'',
'Please consider either adding the #BUTTON_ID# substitution string to this template or changing the button template to one that includes the #BUTTON_ID# substitution string.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(8469915985140202)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_text=>'Button ''Action'' is not ''Defined by Dynamic Action'', for a button referenced in a Dynamic Action (%0).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9969927715808840)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_text=>'Button (%0) has an ''Action'' of ''Defined by Dynamic Action'', but there is no corresponding Dynamic Action referencing this button.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(241852555211147676)
,p_name=>'ADVISOR.CHECK.CHART_TYPE_IS_ACCESSIBLE.MSG_ANYCHART_CHART'
,p_message_text=>'This is an old AnyChart chart type. You should use the ''Application Upgrade'' facility to migrate this chart to use the new Oracle JET based charts, for greatly improved usability and accessibility.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25316715973869635)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_text=>'Clear Cache Page %0 is not the current or target page %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25315402063869633)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_text=>'%0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(728339641269994550)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_text=>'This attribute value has been deprecated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(746093378228936520)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_text=>'This component type has been deprecated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(357364128938707207)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_text=>'Protected items in Ajax calls'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37149914027467871)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_text=>'Code Smell (APEX internal)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25308004897688115)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_text=>'Declarative References of Application Items, Page Items, Columns or Interactive Report Filters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(931429261300900875)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_text=>'Authorization'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25307421042683345)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_text=>'References with Bind Variable Syntax'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25310407929707996)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_text=>'Unconditional Branch before other Branches'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(931510289991221548)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_text=>'Browser Security Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6723215257786814)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_text=>'Button is not compatible with Dynamic Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9946705897802612)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_text=>'Inconsistent references between Dynamic Actions and Buttons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(241851518070125610)
,p_name=>'ADVISOR.CHECK.DESC_CHART_TYPE_IS_ACCESSIBLE'
,p_message_text=>'Chart type supports accessibility'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25308620827692711)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_text=>'Clear Cache Page Number equals Target or Current Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25307213423681147)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_text=>'References with Column Syntax'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(728337360892970978)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_text=>'Deprecated attribute values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25309409530699006)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_text=>'Fetch, DML, MR* Processes are Valid'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25310201349706076)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_text=>'Hardcoded Application ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172104812234201851)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_text=>'Page Item has Help Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240623156551821000)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_text=>'Page has page title'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(247063415322317717)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_text=>'Display Image item has image ALT text defined'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(573557583616659864)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_text=>'Application attributes that can be locked down'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25307626583684954)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_text=>'Referenced Item is on Current Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25307832470686658)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_text=>'Referenced Item is Page Item of Target Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240679264181063844)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_text=>'Page item does not cause an unexpected context change'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(241922259823281882)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_text=>'Page item has label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25310820396711546)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_text=>'Length of Item or Tabular Form Column Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25308210437689788)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_text=>'References of Page Item in a String'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25308415632691218)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_text=>'Referenced Page Number Exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240626832540486067)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_text=>'Region has Row Header'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25311216072748119)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_text=>'Report has Default Order'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(931536764055366995)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_text=>'Session State Protection'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25309614378700349)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_text=>'Inappropriate use of Substitution Syntax'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25307007536679465)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_text=>'References with Substitution Syntax'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25309205028697628)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_text=>'Target Page Authorization is also set for Current Component'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240672089207637382)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_text=>'Theme Style tested for accessibility'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(342223406255329137)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_text=>'User Interface includes compatibility JavaScript'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25310614163709730)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_text=>'Associated Item or Column of Validations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25308826021694302)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_text=>'Is Valid SQL or PL/SQL Code'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25310028923704534)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_text=>'Verify Clob Property'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25309819572701829)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_text=>'V Function used in SQL Statements'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25311026976713451)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_text=>'Referenced Button in When Button Pressed exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25317305682869636)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_text=>'Compilation error - %0 Statement: %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25317630457869636)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_text=>'Link contains the current Application ID as hardcoded value.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172102828679168744)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_text=>'No help text defined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240623793173854740)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_text=>'This page has no page title. Meaningful page titles are important for accessibility, to help users understand the content and purpose of the current page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(247072235389367899)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_text=>'The item is missing the alternative text required for the image. Good text to use for this should adequately describe the contents of the image, and also should not duplicate any information that is visible on the page displayed in the context of the'
||' image (to avoid possible duplication). Note: If the image is provided by users, then so too should the image alternative text be, with appropriate guidance to help your users provide high quality text.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(573558319384695449)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_text=>'"Runtime API Usage" allows application and workspace modification.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25315805182869634)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_text=>'%0 is not an item on page %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25315906592869634)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_text=>'%0 is not an item on target page %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240679667246079314)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_text=>'The setting ''Page Action on Selection'' for the page item could cause an unexpected change of context for the user. Consider switching to ''None'' so there is no change of context and replacing the functionality with Dynamic Actions or Cascading LOVs (i'
||'f you need to stay on the same page). Alternatively consider providing some information for the user so that they know what will happen, for example, adding ''Launches new page'' in the label. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(247038837204790392)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_text=>'A label for the item must be defined. If you prefer not to display a visible label, you should still define a label and then select the ''Hidden'' label template.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(241922654885316313)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_text=>'The item defines a ''Value Placeholder'' value, but no label. Placeholder text should not be used solely to label the item, as this causes accessibility issues. For better accessibility, an item label should be defined. If you prefer not to display a v'
||'isible label, you should still define a label and then select the ''Hidden'' label template.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25318029024869637)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_text=>'Name has a length of %0 characters, but should have a maximum of 30 characters.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25316221549869634)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_text=>'%0 might not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25316300225869634)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_text=>'%0 might not be a page or application item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25316611810869635)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_text=>'Clear Cache Page %1 (within application %0) does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25316431363869635)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_text=>'Page %0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25316509183869635)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_text=>'Target Page %1 (within application %0) does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(181842959358531832)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_text=>'This Column Toggle region does not have a column with ''Use as Row Header'' set to ''Yes''. The Row Header column should be the column that best identifies the current row (for example a customer name in a report of customer information).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(181867445444623902)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_text=>'This Reflow region does not have a column with ''Use as Row Header'' set to ''Yes''. The Row Header column should be the column that best identifies the current row (for example a customer name in a report of customer information).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240627431814514759)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_text=>'This Tabular Form region does not have a column with "Use as Row Header" set to Yes. The Row Header column should be the column that best identifies the current row (for example a customer name in a table of customer information). This information is'
||' then used when rendering the Tabular Form, to provide unique labels for each row''s form fields.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25318203115869637)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_text=>'Report does not have a default order.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(573559261376727748)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_text=>'"Bookmark Hash Function" is set to a legacy algorithm.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(573559477274733790)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_text=>'"Session State Protection" is disabled.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(931498729821018872)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_text=>'On a page with a fetch process, you should use Page Access Protection and enable protection for the items that you pass via the URL.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(18961442298586347)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_text=>'Region contains "f?p" URL that is not passed through APEX_UTIL.PREPARE_URL.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25317402787869636)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_text=>'Possible SQL Injection detected. %0 is used with substitution syntax in SQL, PL/SQL code or process table name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25315216700869633)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_text=>'%0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25315312914869633)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_text=>'%0 cannot be referenced with substitution syntax.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25317228758869636)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_text=>'Target page %1 (within application %0) has an authorization scheme defined, but current component does not.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240672444358656828)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_text=>'The current Theme Style for the application has not been tested for accessibility. Please either switch to a Theme Style that has Accessibility Tested set to Yes, or if your current Theme Style has been tested, set its Accessibility Tested attribute '
||'to Yes under your Theme settings.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(342370355471829199)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'User Interface includes jQuery Migrate. jQuery Migrate helps when migrating to a newer version of jQuery by restoring removed APIs and shows warnings in the browser console when removed or deprecated APIs are used. This includes an extra JavaScript f'
||'ile on every page in your app. To help remove this, please review the jQuery Migrate upgrade guide for details of APIs which should be changed, then once you are confident you no longer rely on any of these APIs, set Include jQuery Migrate to No.',
'',
'https://github.com/jquery/jquery-migrate'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(342223808924402055)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_text=>'User Interface includes Deprecated or Desupported JavaScript functions. This includes an extra JavaScript file on every page in your app. To help remove this, please review the ''Deprecated Features'' section of the Release Notes, where you will find i'
||'nstructions on how to check for dependencies to deprecated or desupported functions, and work towards no longer including this in your app.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25317928647869637)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_text=>'Associated Item or Column is not defined, but "Error Message Display Location" would require it.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25317812276869637)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_text=>'Associated Item or Column is not equal to "%0" specified in Validation Expression 1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25316800142869635)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_text=>'Compilation error - %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25316910802869636)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_text=>'No SQL or PL/SQL code defined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25315110849869633)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_text=>'Is longer than 32767. Only the first 32767 are checked. Length: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25317518541869636)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_text=>'Contains V/NV/DV function call in SQL statement (can be a performance problem).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25318106109869637)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_text=>'Referenced button does not exist anymore.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166097224445033723)
,p_name=>'AFTER'
,p_message_text=>'After'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145542516335207895)
,p_name=>'AGREEMENT_MISSING'
,p_message_text=>'Agreement missing'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86584014582220650)
,p_name=>'ALIAS'
,p_message_text=>'Alias'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484877215940188465)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_text=>'Allow application building'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(403370385927921636)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Allow installation of productivity and sample applications.',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(320716805963100795)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_text=>'Allow Use of RESTful Services'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484878120789189881)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_text=>'Allow SQL Workshop Use'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484878800488193470)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_text=>'Allow Use of Team Development'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484869812038130500)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_text=>'Allow workspace to be purged'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484878626676191574)
,p_name=>'ALLOW_WEBSHEET_DEV'
,p_message_text=>'Allow Websheet Development'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87983805377032963)
,p_name=>'ALL_APPLICATIONS'
,p_message_text=>'All Applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14632001252651677)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_text=>'- All - '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14574000363462192)
,p_name=>'ALL_CATEGORIES'
,p_message_text=>'All Categories'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14632516489656103)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_text=>'- All Categories -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485076117219856761)
,p_name=>'ALL_MILESTONES'
,p_message_text=>'All Milestones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(251172702018475751)
,p_name=>'ALL_RELEASES'
,p_message_text=>'All Releases'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88269320723696242)
,p_name=>'ALL_STATIC_FILES'
,p_message_text=>'all static files'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88150006909944679)
,p_name=>'ALL_THEMES'
,p_message_text=>'all themes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(495226290774101568)
,p_name=>'ALL_TYPES'
,p_message_text=>'All Types'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(495248866860596614)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_text=>'- All Types -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88002619472254588)
,p_name=>'ALL_USERS'
,p_message_text=>'All Users'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(907031286000990559)
,p_name=>'ALREADY_IN_ACL'
,p_message_text=>'User is already has an APEX account'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(829735640879014301)
,p_name=>'ALREADY_IN_WS'
,p_message_text=>'User already exists in workspace'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(653851581838798040)
,p_name=>'ALWAYS'
,p_message_text=>'Always'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4289917863847367)
,p_name=>'AM_PM'
,p_message_text=>'AM / PM'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172941223450974103)
,p_name=>'ANALYSIS'
,p_message_text=>'%0 Analysis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172950716749038434)
,p_name=>'ANALYZE'
,p_message_text=>'Analyze by %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270684517232453645)
,p_name=>'ANALYZE_TABLE'
,p_message_text=>'Analyze using %0 method'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(33307807248938181)
,p_name=>'ANCHOR.SHOW_ALL'
,p_message_text=>'Show All'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88139419358796943)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_text=>'anonymous block'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26172702490478302)
,p_name=>'ANSWERS'
,p_message_text=>'Answers'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(18929017490190454)
,p_name=>'ANY_DEVELOPER'
,p_message_text=>'(Any Developer)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(698828197778860023)
,p_name=>'APEX.ACTIONS.TOGGLE'
,p_message_text=>'Toggle %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(930998725733423971)
,p_name=>'APEX.ACTIVE_STATE'
,p_message_text=>'(Active)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1813973379818556359)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_text=>'Application Changes:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1813920029513387028)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_text=>'Hour:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1834499481255569864)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_text=>'%0 K'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1813974106561558043)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_text=>'Page Views: '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(451141508450122968)
,p_name=>'APEX.AJAX_SERVER_ERROR'
,p_message_text=>'Ajax call returned server error %0 for %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(566012924313444410)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'An API call has been prohibited.',
'Contact your administrator.',
'Details about this incident are available via debug id "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106475728798332122)
,p_name=>'APEX.APPLICATION.ALIAS.NON_UNIQUE'
,p_message_text=>'The application alias "%0" can not be converted to a unique application ID.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106476623042339876)
,p_name=>'APEX.APPLICATION.ALIAS.NOT_FOUND'
,p_message_text=>'Application with the alias "%0" does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88273305533720195)
,p_name=>'APEX.APPLICATION.ALIAS.UNHANDLED_ERROR'
,p_message_text=>'ERR-1816 Unexpected error converting application alias p_flow_alias_or_id (%0).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39872803540444214)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_text=>'The API call "%0" has been desupported in Application Express version %1. Details about this incident are available via debug id "%2".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40690514015892568)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNC.UNHANDLED_ERROR'
,p_message_text=>'Error processing authentication function.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9135721868360556)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNCTION.UNHANDLED_ERROR'
,p_message_text=>'Error processing authentication function.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2150212318674594786)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.HOST_PREFIX_MISMATCH'
,p_message_text=>'Tenant Name %0 returned by Oracle Cloud Identity Management isn''t authorized for the domain %1!<br/>Please <a href="&LOGOUT_URL.">re-login</a> and specify an authorized tenant name or change your URL.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5721610337697560)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.USER_IS_NOT_DEVELOPER'
,p_message_text=>'Your account "%0" does not have the necessary development privileges (DB_DEVELOPER or DB_ADMINISTRATOR)<br/>for workspace "%1"! Please <a href="&LOGOUT_URL.">re-login</a> after privileges have been provided.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4371710867584719)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.WRONG_GROUP_NAME'
,p_message_text=>'Tenant Name returned by Oracle Cloud Identity Management isn''t authorized for current workspace!<br/>Please <a href="&LOGOUT_URL.">re-login</a> and specify an authorized tenant name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(42882491343010755)
,p_name=>'APEX.AUTHENTICATION.HEADER.DUPLICATE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The HTTP header %0 was sent twice, this could be an attack.',
'<ul>',
'<li>1st value: "%1"</li>',
'<li>2nd value: "%2"</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5740626203812907)
,p_name=>'APEX.AUTHENTICATION.HOST_PREFIX_MISMATCH'
,p_message_text=>'For security reasons, running applications of this workspace via the domain in the URL is not allowed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40689907724892515)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.ASK_FOR_INSTALLATION'
,p_message_text=>'Please ask your DBA to run $OH/rdbms/admin/catldap.sql.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40689700343892497)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.MISSING'
,p_message_text=>'SYS.DBMS_LDAP package does not exist or is invalid.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40689521565892479)
,p_name=>'APEX.AUTHENTICATION.LDAP.EDIT_USER_FUNCTION.UNHANDLED_ERROR'
,p_message_text=>'Error processing edit LDAP user function.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40690125759892533)
,p_name=>'APEX.AUTHENTICATION.LDAP.UNHANDLED_ERROR'
,p_message_text=>'Error processing LDAP authentication.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40693914827892897)
,p_name=>'APEX.AUTHENTICATION.LOGIN.ILLEGAL_PAGE_ARG'
,p_message_text=>'Error in p_flow_page argument to login_page procedure.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40691927486892694)
,p_name=>'APEX.AUTHENTICATION.LOGIN.INVALID_ARG'
,p_message_text=>'Invalid p_session in wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40691113117892622)
,p_name=>'APEX.AUTHENTICATION.LOGIN.MALFORMED_ARGS'
,p_message_text=>'Malformed argument to wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40692522089892760)
,p_name=>'APEX.AUTHENTICATION.LOGIN.NULL_USER'
,p_message_text=>'Null username passed to login procedure.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12946822629088045)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.COUNTER'
,p_message_text=>'Please wait <span id="apex_login_throttle_sec">%0</span> seconds to login again.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14687417938886622)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.ERROR'
,p_message_text=>'The login attempt has been blocked.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(155899900117938935)
,p_name=>'APEX.AUTHENTICATION.NOT_FOUND'
,p_message_text=>'Authentication "%0" not found'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(17907628863168637)
,p_name=>'APEX.AUTHENTICATION.NO_SECURITY_GROUP_ID'
,p_message_text=>'Security group ID is null.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40690904166892604)
,p_name=>'APEX.AUTHENTICATION.POST_AUTH_PROC.UNHANDLED_ERROR'
,p_message_text=>'Error executing post-authentication process.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40690325337892551)
,p_name=>'APEX.AUTHENTICATION.PRE_AUTH_PROC.UNHANDLED_ERROR'
,p_message_text=>'Error processing pre-authentication process.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(44051638199470109)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD.INSTRUCTIONS'
,p_message_text=>'Please open the URL in the same browser where you initiated the Reset Password request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1670105559928364548)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD_URL'
,p_message_text=>'Reset Password URL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5740920114349485)
,p_name=>'APEX.AUTHENTICATION.RM_GROUP_NOT_GRANTED'
,p_message_text=>'Resource Manager consumer group %0 has not been granted to %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5741021181362284)
,p_name=>'APEX.AUTHENTICATION.RM_INFO_TO_GRANT'
,p_message_text=>'Please use DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP to grant the missing privilege.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(79172732436693997)
,p_name=>'APEX.AUTHENTICATION.SESSION_SENTRY_FUNCTION.UNHANDLED_ERROR'
,p_message_text=>'Error processing session sentry function.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(79173121832700399)
,p_name=>'APEX.AUTHENTICATION.SESSION_VERIFY_FUNCTION.UNHANDLED_ERROR'
,p_message_text=>'Error processing session verification function.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(79173901578732375)
,p_name=>'APEX.AUTHENTICATION.SSO.ASK_FOR_INSTALLATION'
,p_message_text=>'Please ask your %0 administrator to configure the engine for Oracle Application Server Single Sign-On.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100935918718000178)
,p_name=>'APEX.AUTHENTICATION.SSO.BAD_URLC'
,p_message_text=>'Illegal %0 in %1 token returned by sso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40693123284892826)
,p_name=>'APEX.AUTHENTICATION.SSO.FIX_PARTNER_APP'
,p_message_text=>'Please edit the authentication scheme and add the application name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100933316706829275)
,p_name=>'APEX.AUTHENTICATION.SSO.ILLEGAL_CALLER'
,p_message_text=>'Illegal caller of %0 procedure:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100935131176928136)
,p_name=>'APEX.AUTHENTICATION.SSO.INVALID_APP_SESSION'
,p_message_text=>'Invalid app session in urlc token: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100931501852777682)
,p_name=>'APEX.AUTHENTICATION.SSO.MISSING_APP_REGISTRATION'
,p_message_text=>'Error in portal_sso_redirect: missing application registration information: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(79173525688729948)
,p_name=>'APEX.AUTHENTICATION.SSO.PACKAGE_MISSING'
,p_message_text=>'WWSEC_SSO_ENABLER_PRIVATE package does not exist or is invalid.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40692914409892809)
,p_name=>'APEX.AUTHENTICATION.SSO.PARTNER_APP_IS_NULL'
,p_message_text=>'Unable to find registered partner application name in authentication scheme.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100932020206782969)
,p_name=>'APEX.AUTHENTICATION.SSO.REGISTER_APP'
,p_message_text=>'Please register this application as described in the installation guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(79174630452750203)
,p_name=>'APEX.AUTHENTICATION.SSO.UNHANDLED_ERROR'
,p_message_text=>'Error processing SSO authentication.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(799806132696038883)
,p_name=>'APEX.AUTHENTICATION.UNAUTHORIZED_URL'
,p_message_text=>'Unauthorized URL:  %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(79171002345638006)
,p_name=>'APEX.AUTHENTICATION.UNHANDLED_ERROR'
,p_message_text=>'Error processing authentication.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5740824967294546)
,p_name=>'APEX.AUTHENTICATION.WORKSPACE_NOT_ASSIGNED'
,p_message_text=>'Workspace "%0" is inactive. Contact your administrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5989311818506329)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED'
,p_message_text=>'%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13966207550271697)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.APPLICATION'
,p_message_text=>'Access denied by Application security check'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13966829714278051)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.PAGE'
,p_message_text=>'Access denied by Page security check'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13968714317387138)
,p_name=>'APEX.AUTHORIZATION.UNHANDLED_ERROR'
,p_message_text=>'Error processing authorization.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(180071718656895367)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_text=>'#LABEL# does not exist in list.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(447793064593724800)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_text=>'Show Only branches are not supported if the page attribute "Reload on Submit" is set to "Only for Success".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88359402284059953)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_text=>'Error processing branch.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(228902921022110575)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX'
,p_message_text=>'Built with %0 using %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(228903391513113068)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX.ACCESSIBLE.LOVE'
,p_message_text=>'love'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(246624823219699674)
,p_name=>'APEX.CALCULATOR.ICON_TEXT'
,p_message_text=>'Popup Calculator: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(643378897162797830)
,p_name=>'APEX.CALENDAR.EVENT_DESCRIPTION'
,p_message_text=>'Event Description'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(643378428282788989)
,p_name=>'APEX.CALENDAR.EVENT_END'
,p_message_text=>'End Date'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(643379036907799035)
,p_name=>'APEX.CALENDAR.EVENT_ID'
,p_message_text=>'Event ID'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(643378226297787858)
,p_name=>'APEX.CALENDAR.EVENT_START'
,p_message_text=>'Start Date'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(643378679568790214)
,p_name=>'APEX.CALENDAR.EVENT_TITLE'
,p_message_text=>'Event Title'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(339656274527285148)
,p_name=>'APEX.CLIPBOARD.COPIED'
,p_message_text=>'Copied to clipboard.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(328231522956808260)
,p_name=>'APEX.CLIPBOARD.NOTSUP'
,p_message_text=>'This browser does not support copy from a button or menu. Try Ctrl+C or Command+C.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(232058807483085715)
,p_name=>'APEX.CLOSE_NOTIFICATION'
,p_message_text=>'Close Notification'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1997828914881204)
,p_name=>'APEX.COLOR_PICKER.ICON_TEXT'
,p_message_text=>'Popup Color Picker: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475788463539232651)
,p_name=>'APEX.COMBOBOX.LIST_OF_VALUES'
,p_message_text=>'List of Values'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475790865654264259)
,p_name=>'APEX.COMBOBOX.SHOW_ALL_VALUES'
,p_message_text=>'Open list for: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(931214598024427227)
,p_name=>'APEX.COMPLETED_STATE'
,p_message_text=>'(Completed)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6102403194325087)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_text=>'Error processing computation.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86839409490701736)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_text=>'Error processing condition.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106572910593837829)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_text=>'Unknown condition type "%0"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88386509585289082)
,p_name=>'APEX.CONTACT_ADMIN'
,p_message_text=>'Contact your application administrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(120878626231900703)
,p_name=>'APEX.CONTACT_ADMIN.DEBUG'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Contact your application administrator.',
'Details about this incident are available via debug id "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(619030758078664777)
,p_name=>'APEX.CORRECT_ERRORS'
,p_message_text=>'Correct errors before saving.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(937686590251125216)
,p_name=>'APEX.CURRENT_PROGRESS'
,p_message_text=>'Current Progress'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(478434417196253607)
,p_name=>'APEX.DATA_HAS_CHANGED'
,p_message_text=>'Current version of data in database has changed since user initiated update process.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(246623924575623096)
,p_name=>'APEX.DATEPICKER.ICON_TEXT'
,p_message_text=>'Popup Calendar: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(256090702884742274)
,p_name=>'APEX.DATEPICKER_VALUE_GREATER_MAX_DATE'
,p_message_text=>'#LABEL# is greater than specified maximum date %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261691404725928457)
,p_name=>'APEX.DATEPICKER_VALUE_INVALID'
,p_message_text=>'#LABEL# does not match format %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(256090525955739426)
,p_name=>'APEX.DATEPICKER_VALUE_LESS_MIN_DATE'
,p_message_text=>'#LABEL# is less than specified minimum date %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(256091613619745375)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_text=>'#LABEL# is not between the valid range of %0 and %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(257684010343284698)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_IN_YEAR_RANGE'
,p_message_text=>'#LABEL# is not within valid year range of %0 and %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(622853037686069288)
,p_name=>'APEX.DIALOG.CANCEL'
,p_message_text=>'Cancel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1141574914152086146)
,p_name=>'APEX.DIALOG.CLOSE'
,p_message_text=>'Close'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317595751743049086)
,p_name=>'APEX.DIALOG.HELP'
,p_message_text=>'Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(622852433456064895)
,p_name=>'APEX.DIALOG.OK'
,p_message_text=>'OK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148432930458802696)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_text=>'Application %0 Dialog page %1 cannot be rendered successfully.  Ensure the page template in use on page %1 is of template type "Dialog page", with appropriate JavaScript dialog initialization, dialog closure and dialog cancel code defined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(622852683918067029)
,p_name=>'APEX.DIALOG.SAVE'
,p_message_text=>'Save'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502116932934915858)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_text=>'Copyright &copy; %0, All rights reserved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502124066455975274)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_text=>'Create Workspace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502114784898909741)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_text=>'This is a system generated message. Do not reply to this message.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613712881630550691)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_text=>'Environment'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1967442919973765677)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_text=>'Oracle Application Express User'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502212088742654552)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_text=>'Get Started'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502117332712920703)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_text=>'Hello %0,'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502149330315258964)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_text=>'Password'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613713006899553480)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_text=>'Prevent Workspace Purge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502204926674566759)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_text=>'You can prevent your workspace from being purged by clicking the button below and following the on-screen instructions. If you do not act in %0 day(s), your workspace will automatically be removed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613712296050542306)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_text=>'No action is necessary if you no longer require your workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613713484429562581)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_text=>'Your workspace is about to be purged!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613657056143871428)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_text=>'Your workspace %0 has not shown any recent activity and is scheduled to be purged soon.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613656545025863893)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_text=>'Warning! Your workspace "%0" is about to be purged.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613712651034549844)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_text=>'Purge Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613742878448803925)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_text=>'Please complete your workspace request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613742454843790049)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_text=>'Your workspace "%0" is ready!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613743107291808807)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_text=>'Your workspace "%0" has been approved!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613742623658795476)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_text=>'Your workspace request has been declined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502121240784948033)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_text=>'Username'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613713229763560062)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_text=>'Warning!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502121035475947160)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_text=>'Workspace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502118841897926686)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_text=>'Workspace Request Approved'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502124299811978438)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_text=>'Click the button below to complete the approval process and set your password.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502119253893931555)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_text=>'Your workspace request has been approved!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502148776991221459)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_text=>'Click the button below to get started.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502149978894274097)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_text=>'Your workspace is ready!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502119014367928428)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_text=>'Workspace Request Declined'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1502119682600937556)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_text=>'Sorry, your workspace request has been declined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88360625618076097)
,p_name=>'APEX.ERROR'
,p_message_text=>'Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4931900987762602)
,p_name=>'APEX.ERROR.CALLBACK_FAILED'
,p_message_text=>'The following error has occurred while executing the error handling callback: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19931017514208460)
,p_name=>'APEX.ERROR.ERROR_PAGE.UNHANDLED_ERROR'
,p_message_text=>'Error occurred while painting error page: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5947530396184044)
,p_name=>'APEX.ERROR.INTERNAL'
,p_message_text=>'Internal Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(888207622853346793)
,p_name=>'APEX.ERROR.INTERNAL.CONTACT_ADMINISTRATOR'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Contact your administrator.',
'Details about this incident are available via debug id "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2026538193185817588)
,p_name=>'APEX.ERROR.ORA-28353'
,p_message_text=>'ORA-28353: Failed to open wallet. Application data currently not accessible.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(790162199062386158)
,p_name=>'APEX.ERROR.PAGE_NOT_AVAILABLE'
,p_message_text=>'Sorry, this page isn''t available'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9047130835710266)
,p_name=>'APEX.ERROR.TECHNICAL_INFO'
,p_message_text=>'Technical Info (only visible for developers)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(394626025444107510)
,p_name=>'APEX.ERROR_MESSAGE_HEADING'
,p_message_text=>'Error Message'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(464263453605979983)
,p_name=>'APEX.EXPECTED_FORMAT'
,p_message_text=>'Expected format: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276365061398053155)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.ALREADY_IN_ACL'
,p_message_text=>'User is already in Access Control List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276364876592051643)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.CREATE_CONFIRM'
,p_message_text=>'Please confirm adding the following %0 <strong>%1</strong> user(s) to your access control list.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276365800433057617)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.DUPLICATE_USE'
,p_message_text=>'Duplicate user exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276365266604054311)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_AT_SIGN'
,p_message_text=>'Missing at-sign (@) in Email address'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276365414904055467)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_DO'
,p_message_text=>'Missing period (.) in Email address'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276365622188056498)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.USERNAME_TOO_LONG'
,p_message_text=>'Username is too long'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366238736059875)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_ONLY'
,p_message_text=>'Only users defined in the application access control list may access this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366464077060995)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_VALUE_INVALID'
,p_message_text=>'Unexpected Access Control Setting Value: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366010567058665)
,p_name=>'APEX.FEATURE.ACL.INFO.ALL_USERS'
,p_message_text=>'All authenticated users can access this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(562353207904351743)
,p_name=>'APEX.FEATURE.CONFIG.DISABLED'
,p_message_text=>'Disabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(562352858532347464)
,p_name=>'APEX.FEATURE.CONFIG.ENABLED'
,p_message_text=>'Enabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(564505432763712063)
,p_name=>'APEX.FEATURE.CONFIG.IS_DISABLED'
,p_message_text=>'%0: Is Disabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(562353449653354905)
,p_name=>'APEX.FEATURE.CONFIG.IS_ENABLED'
,p_message_text=>'%0: Is Enabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(230785551309946848)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_text=>'Queued'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(230785723092947749)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_text=>'Sent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(561775681620287538)
,p_name=>'APEX.FEATURE.TOP_USERS.USERNAME.NOT_IDENTIFIED'
,p_message_text=>'not identified'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(16215668814939242)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_text=>'Feedback Entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(16215867669940917)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_text=>'Open Feedback Entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(16216741984949755)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_text=>'Users'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(480881129624931954)
,p_name=>'APEX.FILE_BROWSE.DOWNLOAD_LINK_TEXT'
,p_message_text=>'Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472559453998840506)
,p_name=>'APEX.FS.BATCH_APPLY'
,p_message_text=>'Apply'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472560704816840697)
,p_name=>'APEX.FS.CLEAR'
,p_message_text=>'Clear'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472560977407840730)
,p_name=>'APEX.FS.CLEAR_ALL'
,p_message_text=>'Clear All'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472561286834840762)
,p_name=>'APEX.FS.CLEAR_VALUE'
,p_message_text=>'Clear %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(658004385893566842)
,p_name=>'APEX.FS.COLUMN_UNAUTHORIZED'
,p_message_text=>'Column %1, referenced by facet %0, is not available or unauthorized.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(645135241167191471)
,p_name=>'APEX.FS.FACET_VALUE_LIMIT_EXCEEDED'
,p_message_text=>'Distinct value limit (%0) exceeded for facet %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472564915239841226)
,p_name=>'APEX.FS.FC_TYPE_UNSUPPORTED_FOR_DATE_COLUMNS'
,p_message_text=>'Facet %0 is not supported for DATE or TIMESTAMP columns.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472559699812840567)
,p_name=>'APEX.FS.FILTER'
,p_message_text=>'Filter %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472559931805840600)
,p_name=>'APEX.FS.GO'
,p_message_text=>'Go'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472563962810841096)
,p_name=>'APEX.FS.INPUT_CURRENT_LABEL'
,p_message_text=>'equals %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472564495799841162)
,p_name=>'APEX.FS.NO_SEARCH_COLUMNS_PROVIDED'
,p_message_text=>'No search columns have been provided for facet %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472563140327840991)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL'
,p_message_text=>'%0 to %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472563395614841023)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_HI'
,p_message_text=>'Above %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472563691938841063)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_LO'
,p_message_text=>'Below %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(698742887263143685)
,p_name=>'APEX.FS.RANGE_LOV_ITEM_INVALID'
,p_message_text=>'LOV item #%2 ("%1") for range facet %0 is invalid ("|" separator missing).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472564176512841129)
,p_name=>'APEX.FS.RANGE_MANUAL_NOT_SUPPORTED'
,p_message_text=>'Manual Input for Range facet %0 is currently not supported, since the column is DATE or TIMESTAMP.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472562037048840860)
,p_name=>'APEX.FS.RANGE_TEXT'
,p_message_text=>'to'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472560484915840665)
,p_name=>'APEX.FS.SEARCH_LABEL'
,p_message_text=>'Search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472560155111840632)
,p_name=>'APEX.FS.SEARCH_PLACEHOLDER'
,p_message_text=>'Search...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472562551511840925)
,p_name=>'APEX.FS.SELECT_PLACEHOLDER'
,p_message_text=>'- Select -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472561540192840795)
,p_name=>'APEX.FS.SHOW_LESS'
,p_message_text=>'Show Less'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472561766803840827)
,p_name=>'APEX.FS.SHOW_MORE'
,p_message_text=>'Show More'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472562331391840892)
,p_name=>'APEX.FS.STAR_RATING_LABEL'
,p_message_text=>'%0 stars and up'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472564744437841194)
,p_name=>'APEX.FS.TEXT_FIELD_ONLY_FOR_NUMBER_COLUMNS'
,p_message_text=>'Text Field facet %0 is currently only supported for NUMBER columns.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(658727806749125048)
,p_name=>'APEX.FS.UNSUPPORTED_DATA_TYPE'
,p_message_text=>'The %0 data type (%1) is not supported for faceted search.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(569329013877349787)
,p_name=>'APEX.GO_TO_ERROR'
,p_message_text=>'Go to error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135860124558880754)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_text=>'Group "%0" could not be found'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(290826604554653767)
,p_name=>'APEX.GV.AGG_CONTEXT'
,p_message_text=>'Aggregate.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370478627979527482)
,p_name=>'APEX.GV.BREAK_COLLAPSE'
,p_message_text=>'Collapse control break'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(290826881492656552)
,p_name=>'APEX.GV.BREAK_CONTEXT'
,p_message_text=>'Control break.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370478422903525522)
,p_name=>'APEX.GV.BREAK_EXPAND'
,p_message_text=>'Expand control break'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2199727822654413790)
,p_name=>'APEX.GV.COLUMN_CONTEXT'
,p_message_text=>'Column %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370477958319520295)
,p_name=>'APEX.GV.DELETED_COUNT'
,p_message_text=>'%0 rows deleted'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1342378298209919296)
,p_name=>'APEX.GV.DUP_REC_ID'
,p_message_text=>'Duplicate identity'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269201436690836601)
,p_name=>'APEX.GV.FIRST_PAGE'
,p_message_text=>'First'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(290827258737661261)
,p_name=>'APEX.GV.GROUP_CONTEXT'
,p_message_text=>'Group header.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(290827074061659148)
,p_name=>'APEX.GV.HEADER_CONTEXT'
,p_message_text=>'Header.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269201610040837444)
,p_name=>'APEX.GV.LAST_PAGE'
,p_message_text=>'Last'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382440658981228514)
,p_name=>'APEX.GV.LOAD_MORE'
,p_message_text=>'Load More Rows'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269201035043834554)
,p_name=>'APEX.GV.NEXT_PAGE'
,p_message_text=>'Next'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(291042874389857317)
,p_name=>'APEX.GV.PAGE_RANGE'
,p_message_text=>'Page rows'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269201807004839486)
,p_name=>'APEX.GV.PAGE_RANGE_XY'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269202046686841204)
,p_name=>'APEX.GV.PAGE_RANGE_XYZ'
,p_message_text=>'%0 - %1 of %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269201275461835627)
,p_name=>'APEX.GV.PREV_PAGE'
,p_message_text=>'Previous'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1341949951903817834)
,p_name=>'APEX.GV.ROW_ADDED'
,p_message_text=>'Added'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1341950103101821804)
,p_name=>'APEX.GV.ROW_CHANGED'
,p_message_text=>'Changed'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2199727423378410167)
,p_name=>'APEX.GV.ROW_COLUMN_CONTEXT'
,p_message_text=>'Row %0, Column %1.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2199727650756412304)
,p_name=>'APEX.GV.ROW_CONTEXT'
,p_message_text=>'Row %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1341949770715813160)
,p_name=>'APEX.GV.ROW_DELETED'
,p_message_text=>'Deleted'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(296179677712570497)
,p_name=>'APEX.GV.ROW_HEADER'
,p_message_text=>'Row header'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(268429337089386217)
,p_name=>'APEX.GV.SELECTION_CELL_COUNT'
,p_message_text=>'%0 cells selected'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269202211879842444)
,p_name=>'APEX.GV.SELECTION_COUNT'
,p_message_text=>'%0 rows selected'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(511466055042527671)
,p_name=>'APEX.GV.SELECT_ALL'
,p_message_text=>'Select All'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370478205264523330)
,p_name=>'APEX.GV.SELECT_PAGE_N'
,p_message_text=>'Page %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(296132260794565912)
,p_name=>'APEX.GV.SELECT_ROW'
,p_message_text=>'Select Row'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(306083706088278910)
,p_name=>'APEX.GV.SORTED_ASCENDING'
,p_message_text=>'Sorted Ascending %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(306083917210282253)
,p_name=>'APEX.GV.SORTED_DESCENDING'
,p_message_text=>'Sorted Descending %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269199232752827426)
,p_name=>'APEX.GV.SORT_ASCENDING'
,p_message_text=>'Sort Ascending'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269200627843832575)
,p_name=>'APEX.GV.SORT_ASCENDING_ORDER'
,p_message_text=>'Sort Ascending %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269199638560829162)
,p_name=>'APEX.GV.SORT_DESCENDING'
,p_message_text=>'Sort Descending'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269200803368833870)
,p_name=>'APEX.GV.SORT_DESCENDING_ORDER'
,p_message_text=>'Sort Descending %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(269200356765830191)
,p_name=>'APEX.GV.SORT_OFF'
,p_message_text=>'Don''t Sort'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370477767826517194)
,p_name=>'APEX.GV.TOTAL_PAGES'
,p_message_text=>'Total %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1007658038863784512)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_text=>'View Documentation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1301556372959453932)
,p_name=>'APEX.ICON_LIST.GRID_DIM'
,p_message_text=>'Grid Select List %0 columns %1 rows. Use arrow keys'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366830231481244976)
,p_name=>'APEX.ICON_LIST.LIST_DIM'
,p_message_text=>'Select List %0 rows. Use arrow keys'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2199727008650406202)
,p_name=>'APEX.IG.ACC_LABEL'
,p_message_text=>'Interactive Grid %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253103864012428183)
,p_name=>'APEX.IG.ACTIONS'
,p_message_text=>'Actions'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253105840842435569)
,p_name=>'APEX.IG.ADD'
,p_message_text=>'Add'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253105611716434939)
,p_name=>'APEX.IG.ADD_ROW'
,p_message_text=>'Add Row'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475688796693070101)
,p_name=>'APEX.IG.AGGREGATE'
,p_message_text=>'Aggregate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(949343041237860865)
,p_name=>'APEX.IG.AGGREGATION'
,p_message_text=>'Aggregation'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(994489767765554444)
,p_name=>'APEX.IG.ALL'
,p_message_text=>'All'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436639481545568300)
,p_name=>'APEX.IG.ALL_TEXT_COLUMNS'
,p_message_text=>'All Text Columns'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436645049387673679)
,p_name=>'APEX.IG.ALTERNATIVE'
,p_message_text=>'Alternative'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436648901178731701)
,p_name=>'APEX.IG.AND'
,p_message_text=>'and'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(611469940913292197)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT'
,p_message_text=>'Approx. Count Distinct'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475737733205956325)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT_OVERALL'
,p_message_text=>'Overal Approx. Count Distinct'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942330819617625580)
,p_name=>'APEX.IG.AREA'
,p_message_text=>'Area'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(973821678450621800)
,p_name=>'APEX.IG.ASCENDING'
,p_message_text=>'Ascending'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436645360194678104)
,p_name=>'APEX.IG.AUTHORIZATION'
,p_message_text=>'Authorization'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475688878746097167)
,p_name=>'APEX.IG.AUTO'
,p_message_text=>'Auto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(611470761668296689)
,p_name=>'APEX.IG.AVG'
,p_message_text=>'Average'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475736755355944218)
,p_name=>'APEX.IG.AVG_OVERALL'
,p_message_text=>'Overall Average'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942329234206617776)
,p_name=>'APEX.IG.AXIS_LABEL_TITLE'
,p_message_text=>'Label Axis Title'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942330055649621809)
,p_name=>'APEX.IG.AXIS_VALUE_DECIMAL'
,p_message_text=>'Decimal Places'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942329844822620743)
,p_name=>'APEX.IG.AXIS_VALUE_TITLE'
,p_message_text=>'Value Axis Title'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1049329031271359425)
,p_name=>'APEX.IG.BACKGROUND_COLOR'
,p_message_text=>'Background Color'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942331013847626672)
,p_name=>'APEX.IG.BAR'
,p_message_text=>'Bar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404796891446524989)
,p_name=>'APEX.IG.BETWEEN'
,p_message_text=>'between'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054979169972955538)
,p_name=>'APEX.IG.BOTH'
,p_message_text=>'Both'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942331293757627905)
,p_name=>'APEX.IG.BUBBLE'
,p_message_text=>'Bubble'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253106266772436990)
,p_name=>'APEX.IG.CANCEL'
,p_message_text=>'Cancel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436648567971727953)
,p_name=>'APEX.IG.CASE_SENSITIVE'
,p_message_text=>'Case Sensitive'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1476076547261910683)
,p_name=>'APEX.IG.CASE_SENSITIVE_WITH_BRACKETS'
,p_message_text=>'(Case Sensitive)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(692775040984539171)
,p_name=>'APEX.IG.CHANGES_SAVED'
,p_message_text=>'Changes saved'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253107063654440462)
,p_name=>'APEX.IG.CHANGE_VIEW'
,p_message_text=>'Change View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436651900434787842)
,p_name=>'APEX.IG.CHART'
,p_message_text=>'Chart'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(432467991973453048)
,p_name=>'APEX.IG.CHART_MAX_DATAPOINT_CNT'
,p_message_text=>'Your query exceeds the maximum of %0 data points per chart. Please apply a filter to reduce the number of records in your base query.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253103659308427301)
,p_name=>'APEX.IG.CHART_VIEW'
,p_message_text=>'Chart View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(309954981793459365)
,p_name=>'APEX.IG.CLEAR'
,p_message_text=>'Clear'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942327892549613277)
,p_name=>'APEX.IG.CLOSE_COLUMN'
,p_message_text=>'Close'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1049330773441377496)
,p_name=>'APEX.IG.COLORS'
,p_message_text=>'Colors'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1049330559943369182)
,p_name=>'APEX.IG.COLOR_BLUE'
,p_message_text=>'Blue'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1049330339752368286)
,p_name=>'APEX.IG.COLOR_GREEN'
,p_message_text=>'Green'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1049329952425366532)
,p_name=>'APEX.IG.COLOR_ORANGE'
,p_message_text=>'Orange'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1049330112806367329)
,p_name=>'APEX.IG.COLOR_RED'
,p_message_text=>'Red'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1049329702820365482)
,p_name=>'APEX.IG.COLOR_YELLOW'
,p_message_text=>'Yellow'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436646496316700188)
,p_name=>'APEX.IG.COLUMN'
,p_message_text=>'Column'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253104093145428930)
,p_name=>'APEX.IG.COLUMNS'
,p_message_text=>'Columns'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1093431636145038353)
,p_name=>'APEX.IG.COLUMN_TYPE'
,p_message_text=>'Column Purpose'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436646677069701196)
,p_name=>'APEX.IG.COMPLEX'
,p_message_text=>'Complex'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253104432983430353)
,p_name=>'APEX.IG.COMPUTE'
,p_message_text=>'Compute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404798072037535094)
,p_name=>'APEX.IG.CONTAINS'
,p_message_text=>'contains'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436886419447046162)
,p_name=>'APEX.IG.CONTROL_BREAK'
,p_message_text=>'Control Break'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(309954539712448807)
,p_name=>'APEX.IG.COPY_CB'
,p_message_text=>'Copy to Clipboard'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(309954709405451342)
,p_name=>'APEX.IG.COPY_DOWN'
,p_message_text=>'Copy Down'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(611469443659288373)
,p_name=>'APEX.IG.COUNT'
,p_message_text=>'Count'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(611469692144290436)
,p_name=>'APEX.IG.COUNT_DISTINCT'
,p_message_text=>'Count Distinct'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475737542105951541)
,p_name=>'APEX.IG.COUNT_DISTINCT_OVERALL'
,p_message_text=>'Overall Count Distinct'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475737002912948105)
,p_name=>'APEX.IG.COUNT_OVERALL'
,p_message_text=>'Overall Count'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1344104320513159198)
,p_name=>'APEX.IG.CREATE_X'
,p_message_text=>'Create %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436640316242583633)
,p_name=>'APEX.IG.DATA'
,p_message_text=>'Data'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1055157748391759234)
,p_name=>'APEX.IG.DATA_TYPE'
,p_message_text=>'Data Type'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054979626302022784)
,p_name=>'APEX.IG.DATE'
,p_message_text=>'Date'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(692264194497294060)
,p_name=>'APEX.IG.DATE_INVALID_VALUE'
,p_message_text=>'Invalid Date Value'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404803561175870412)
,p_name=>'APEX.IG.DAYS'
,p_message_text=>'days'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436644169838660601)
,p_name=>'APEX.IG.DEFAULT_SETTINGS'
,p_message_text=>'Default Settings'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436643467391644512)
,p_name=>'APEX.IG.DEFAULT_TYPE'
,p_message_text=>'Default Type'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253106000993436358)
,p_name=>'APEX.IG.DELETE'
,p_message_text=>'Delete'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107141776583682897)
,p_name=>'APEX.IG.DELETE_REPORT_CONFIRM'
,p_message_text=>'Are you sure you would like to delete this report?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436892898066134059)
,p_name=>'APEX.IG.DELETE_ROW'
,p_message_text=>'Delete Row'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436888264441061854)
,p_name=>'APEX.IG.DELETE_ROWS'
,p_message_text=>'Delete Rows'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(973821809428623592)
,p_name=>'APEX.IG.DESCENDING'
,p_message_text=>'Descending'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436651280631783562)
,p_name=>'APEX.IG.DETAIL'
,p_message_text=>'Detail'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253103012371424462)
,p_name=>'APEX.IG.DETAIL_VIEW'
,p_message_text=>'Detail View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(757930753783791758)
,p_name=>'APEX.IG.DIRECTION'
,p_message_text=>'Direction'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436650555195771612)
,p_name=>'APEX.IG.DISABLED'
,p_message_text=>'Disabled'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404798280030536858)
,p_name=>'APEX.IG.DOES_NOT_CONTAIN'
,p_message_text=>'does not contain'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404798691673539475)
,p_name=>'APEX.IG.DOES_NOT_START_WITH'
,p_message_text=>'does not start with'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942331445831629116)
,p_name=>'APEX.IG.DONUT'
,p_message_text=>'Donut'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436887061361052135)
,p_name=>'APEX.IG.DOWNLOAD'
,p_message_text=>'Download'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107370036857102366)
,p_name=>'APEX.IG.DOWNLOAD_FORMAT'
,p_message_text=>'Choose Format'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(994447117359980355)
,p_name=>'APEX.IG.DUPLICATE_AGGREGATION'
,p_message_text=>'Duplicate Aggregation'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(994447756355996349)
,p_name=>'APEX.IG.DUPLICATE_CONTROLBREAK'
,p_message_text=>'Duplicate Control Break'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436892533101131795)
,p_name=>'APEX.IG.DUPLICATE_ROW'
,p_message_text=>'Duplicate Row'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436887981343059441)
,p_name=>'APEX.IG.DUPLICATE_ROWS'
,p_message_text=>'Duplicate Rows'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253105256188433312)
,p_name=>'APEX.IG.EDIT'
,p_message_text=>'Edit'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(972179588508261076)
,p_name=>'APEX.IG.EDIT_CHART'
,p_message_text=>'Edit Chart'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317788439135890817)
,p_name=>'APEX.IG.EDIT_GROUP_BY'
,p_message_text=>'Edit Group By'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107294677075835011)
,p_name=>'APEX.IG.EMAIL_BCC'
,p_message_text=>'Blind Copy (bcc)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107295038395837985)
,p_name=>'APEX.IG.EMAIL_BODY'
,p_message_text=>'Message'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107294481006834214)
,p_name=>'APEX.IG.EMAIL_CC'
,p_message_text=>'Copy (cc)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107293797874826580)
,p_name=>'APEX.IG.EMAIL_SENT'
,p_message_text=>'Email sent.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107294804978835859)
,p_name=>'APEX.IG.EMAIL_SUBJECT'
,p_message_text=>'Subject'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107294146675833592)
,p_name=>'APEX.IG.EMAIL_TO'
,p_message_text=>'Recipient (to)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436649394574735086)
,p_name=>'APEX.IG.ENABLED'
,p_message_text=>'Enabled'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404794263529469999)
,p_name=>'APEX.IG.EQUALS'
,p_message_text=>'equals'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1094712452306551049)
,p_name=>'APEX.IG.EXAMPLE'
,p_message_text=>'Example'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436649830451741092)
,p_name=>'APEX.IG.EXPRESSION'
,p_message_text=>'Expression'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1094702084393516937)
,p_name=>'APEX.IG.FD_TYPE'
,p_message_text=>'Type'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(511401956878762569)
,p_name=>'APEX.IG.FILE_PREPARED'
,p_message_text=>'File prepared. Starting download.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(309955146216461354)
,p_name=>'APEX.IG.FILL'
,p_message_text=>'Fill'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(328215598128319769)
,p_name=>'APEX.IG.FILL_LABEL'
,p_message_text=>'Fill selection with'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(328215343904317132)
,p_name=>'APEX.IG.FILL_TITLE'
,p_message_text=>'Fill Selection'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253104236202429670)
,p_name=>'APEX.IG.FILTER'
,p_message_text=>'Filter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436646935400706550)
,p_name=>'APEX.IG.FILTERS'
,p_message_text=>'Filters'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475733004599733933)
,p_name=>'APEX.IG.FILTER_WITH_DOTS'
,p_message_text=>'Filter...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(973825733022680386)
,p_name=>'APEX.IG.FIRST'
,p_message_text=>'First'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253104640261431100)
,p_name=>'APEX.IG.FLASHBACK'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436640573770594996)
,p_name=>'APEX.IG.FORMAT'
,p_message_text=>'Format'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054978274388934102)
,p_name=>'APEX.IG.FORMATMASK'
,p_message_text=>'Format Mask'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107130667843109867)
,p_name=>'APEX.IG.FORMAT_CSV'
,p_message_text=>'CSV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107090780901108163)
,p_name=>'APEX.IG.FORMAT_HTML'
,p_message_text=>'HTML'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436890912297104559)
,p_name=>'APEX.IG.FREEZE'
,p_message_text=>'Freeze'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436650114902767367)
,p_name=>'APEX.IG.FUNCTIONS_AND_OPERATORS'
,p_message_text=>'Functions and Operators'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942331689990630260)
,p_name=>'APEX.IG.FUNNEL'
,p_message_text=>'Funnel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(610738829829264773)
,p_name=>'APEX.IG.GO'
,p_message_text=>'Go'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404796066486517182)
,p_name=>'APEX.IG.GREATER_THAN'
,p_message_text=>'greater than'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404796202906519207)
,p_name=>'APEX.IG.GREATER_THAN_OR_EQUALS'
,p_message_text=>'greater than or equals'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436651024300782524)
,p_name=>'APEX.IG.GRID'
,p_message_text=>'Grid'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253102650304422439)
,p_name=>'APEX.IG.GRID_VIEW'
,p_message_text=>'Grid View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(994488740298390122)
,p_name=>'APEX.IG.GROUP'
,p_message_text=>'Group'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436651440509784940)
,p_name=>'APEX.IG.GROUP_BY'
,p_message_text=>'Group By'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253103225479425550)
,p_name=>'APEX.IG.GROUP_BY_VIEW'
,p_message_text=>'Group By View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054980303037041411)
,p_name=>'APEX.IG.HD_TYPE'
,p_message_text=>'Condition Type'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054976477380908181)
,p_name=>'APEX.IG.HEADING'
,p_message_text=>'Heading'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054977250872914475)
,p_name=>'APEX.IG.HEADING_ALIGN'
,p_message_text=>'Heading Alignment'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475689533774151886)
,p_name=>'APEX.IG.HELP'
,p_message_text=>'Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1302771363919223694)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can insert, update, and delete data directly within this interactive grid.</p>',
'',
'<p>Insert a new row by clicking the Add Row button.</p>',
'',
'<p>Edit existing data by double-clicking a specific cell. For larger editing work, click Edit to enter editing mode. In editing mode, you can single-click or use the keyboard to edit specific cells.</p>',
'',
'<p>Use the Change menu to duplicate and delete rows. To enable the Change menu, use the check boxes to select one or more rows.</p>',
'',
'<p>Duplicate a selected row by clicking the Change menu and selecting Duplicate Rows. Delete a selected row by clicking the Change menu and selecting Delete Row.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1326810589199597587)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING_HEADING'
,p_message_text=>'Editing Capabilities'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1326810830568645356)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>An interactive grid presents a set of data in a searchable, customizable report. You can perform numerous operations to limit the records returned, and change the way the data is displayed.</p>',
'',
'<p>Use the Search field to filter the records returned. Click Actions to access numerous options for modifying the report layout, or use the Column Heading menus on displayed columns.</p>',
'',
'<p>Use Report Settings to save your customizations to a report. You can also download the data from the report to an external file or email the data to yourself or others.</p>',
'',
'<p>To learn more, see "Using Interactive Grids" in <em>Oracle Application Express End User''s Guide</em>.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1326808631831517283)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO_HEADING'
,p_message_text=>'Overview'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1302771121045221993)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can customize the interactive grid to display data in various different ways using the built-in capabilities.</p>',
'',
'<p>Use the Column Heading menus or the Actions menu to determine which columns to display, in what sequence, and freeze columns. You can also define various data filters and sort the data returned.</p>',
'',
'<p>Use the View button (adjacent to the Search field) to access other data views that may have been defined by the application developer. You can also create a chart or view an existing chart.</p>  ',
'',
'<p><em>Note: Click <strong>Help</strong> in the interactive grid dialogs to obtain more detailed information on the selected function.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1326810321343595694)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING_HEADING'
,p_message_text=>'Reporting Capabilities'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436887665000056779)
,p_name=>'APEX.IG.HELP.ACTIONS_TITLE'
,p_message_text=>'Interactive Grid Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1159206922700336839)
,p_name=>'APEX.IG.HELP.AGGREGATE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to aggregate columns. Aggregated values display at the bottom of the data, or if Control Breaks are defined, at the bottom of each break.</p>',
'',
'<p><strong>Aggregation List</strong><br>',
'The Aggregation list displays defined aggregations. Disable an existing aggregation by deselecting it.<br>',
'Click Add ( &plus; ) to create a new aggregation, or Delete ( &minus; ) to remove an existing aggregation.</p>',
'',
'<p><strong>Aggregation Settings</strong><br>',
'Use the form on the right to define the aggregation.<br>',
'Select the Column name and Aggregation type.<br>',
'Optionally, enter a tooltip for the aggregation.<br>',
'If you have defined a Control Break, selecting <strong>Show Overall Value</strong> displays the overall average, total, or similar value at the bottom of the data.</p>',
'',
'<p><em>Note: Access the Aggregation dialog in the Actions menu or by clicking the column heading and sum ( &sum; ).</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317745596144816435)
,p_name=>'APEX.IG.HELP.AGGREGATE_TITLE'
,p_message_text=>'Aggregation Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1160147484677766675)
,p_name=>'APEX.IG.HELP.CHART'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to define a chart which displays as a separate data view.<br> ',
'Select a chart Type, configure the chart settings, and click <strong>Save.</strong></p>',
'',
'<p><strong>Chart Settings</strong></br>',
'The chart attributes that display vary depending on the chart type. A number of attributes can be entered to define the chart. Attributes marked with a red asterisk are mandatory.</p>',
'',
'<p>Below are all available attributes across the different chart types (in alphabetical order):',
'<ul>',
'  <li>Aggregation - Select how to aggregate the associated chart values.</li> ',
'  <li>Close - Select the column that contains the daily stock close price (Stock chart only).</li> ',
'  <li>Decimal Places - Enter the number of decimal places to which the values are rounded.</li> ',
'  <li>Direction -  In relation to the Sort By attribute, specify whether the data is sorted in ascending or descending values.</li> ',
'  <li>High - Select the column that contains the high value (Range and Stock charts only).</li> ',
'  <li>Label - Select the column that contains the text for each data point.</li> ',
'  <li>Label Axis Title - Enter the title that displays on the label axis.</li> ',
'  <li>Low - Select the column that contains the low value (Range and Stock charts only).</li> ',
'  <li>Nulls - In relation to the Sort By attribute, specify how you want records with null values to be sorted in relation to records with non null values.</li> ',
'  <li>Open - Select the column that contains the daily stock openning price (Stock chart only).</li> ',
'  <li>Orientation - Select whether the chart elements, such as bars, display vertically or horizontally.</li> ',
'  <li>Series - Select the column used for defining your multi-series dynamic query.</li> ',
'  <li>Stack - Specify whether the data items are stacked.</li> ',
'  <li>Sort By - Select whether the chart is sorted by the label or the value(s).</li> ',
'  <li>Target - Select the column to be used for defining the target value on this chart. When set, the Value attribute defines the filled area within the slice and the Target represents the value of the whole slice (Funnel chart only).</li> ',
'  <li>Value - Select the column that contains the data to be plotted.</li> ',
'  <li>Value Axis Title - Enter the title that displays on the value axis.</li> ',
'  <li>Volume - Select the column that contains the daily stock volume (Stock chart only).</li> ',
'  <li>X - Select the column that contains the x-axis value for this chart (Bubble and Scatter charts only).</li> ',
'  <li>Y - Select the column that contains the y-axis value for this chart (Bubble and Scatter charts only).</li> ',
'  <li>Z - Select the column that contains the bar width or bubble radius (Bar, Bubble, and Range charts only)</li> ',
'</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317746538366820644)
,p_name=>'APEX.IG.HELP.CHART_TITLE'
,p_message_text=>'Chart Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1159206275728334546)
,p_name=>'APEX.IG.HELP.COLUMNS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to choose which columns display and in what order.</p>',
'',
'<p>Hide a column by deselecting it.<br>',
'Reorder columns by clicking Move Up ( &uarr; ) or Move Down ( &darr; ).<br>',
'Use the drop down selector to list All columns, Displayed columns, or Not Displayed columns.</p>',
'',
'<p>Optionally, use the form to specify the minimum width of a column in pixels.</p>',
'',
'<p><em>Note: You can also reorder displayed columns by clicking the drag handle (at the start of the column heading) and dragging the column left or right. You can also change the column width of displayed columns by selecting the column separator, b'
||'etween headings, and moving it left or right.</em</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317746377678819574)
,p_name=>'APEX.IG.HELP.COLUMNS_TITLE'
,p_message_text=>'Columns Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1159207284050337571)
,p_name=>'APEX.IG.HELP.COMPUTE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to define additional columns based on mathematical and functional computations performed against existing columns.</p>',
'',
'<p><strong>Computation List</strong><br>',
'The Computation list displays defined computations. Disable an existing computation by deselecting it.<br>',
'Click Add ( &plus; ) to add a new computation, or Delete ( &minus; ) to remove an existing computation.</p>',
'',
'<p><strong>Computation Settings</strong><br>',
'Use the form to define the computation.<br>',
'Enter the column details such as heading, label, and select alignment settings.<br> ',
'Use the Expression textarea to enter the column(s) and associated functions for the computation.<br>',
'Select the appropriate data type, and optionally a format mask, for the new column.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317745192997815080)
,p_name=>'APEX.IG.HELP.COMPUTE_TITLE'
,p_message_text=>'Compute Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1159208060834340135)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to define a control break on one or more columns.</p>',
'',
'<p><strong>Control Break List</strong><br>',
'The Control Break list displays defined control breaks. Disable an existing control break column by deselecting it.<br>',
'Click Add ( &plus; ) to include a new column in the control break, or Delete ( &minus; ) to remove an existing column from the control break.<br>',
'To reorder columns, click Move Up ( &uarr; ) or Move Down ( &darr; ) to move the selected column up and down relative to other columns.</p>',
'',
'<p><strong>Control Break Settings</strong><br>',
'Use the form to define the control break column.<br>',
'Selected a control break column, the sort direction, and how to order null columns (columns with no value).</p>',
'',
'<p><em>Note: When viewing the interactive grid, you can define a control break by clicking a Column Heading and selecting the control break icon.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317744195610811180)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK_TITLE'
,p_message_text=>'Control Break Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1159208463119341659)
,p_name=>'APEX.IG.HELP.DOWNLOAD'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to download all the current rows to an external file. The file will contain only the currently displayed columns, using any filters and sorts applied to the data.</p>',
'',
'<p>Select the file format and click Download.<br>',
'Note: CSV will not include text formatting such as aggregates and control breaks.</p>',
'',
'<p>To email the file, select Send as Email and enter the email details (Recipient, Subject and Message).</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317743590401807908)
,p_name=>'APEX.IG.HELP.DOWNLOAD_TITLE'
,p_message_text=>'Download Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1159206543190335483)
,p_name=>'APEX.IG.HELP.FILTER'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to configure data filters which limit the rows returned.</p>',
'',
'<p><strong>Filter List</strong><br>',
'The Filter list displays defined filters. Disable an existing filter by deselecting it.<br>',
'Click Add ( &plus; ) to create a new filter, or Delete ( &minus; ) to remove an existing filter.</p>',
'',
'<p><strong>Filter Settings</strong><br>',
'Use the form to define the filter properties.<br>',
'Select the appropriate filter type:<br>',
'&nbsp;&nbsp;&nbsp;Row - filter for a term in any filterable column.<br>',
'&nbsp;&nbsp;&nbsp;Column - filter a specific column with a specified operator and value.</p>',
'',
'<p><em>Note: When viewing the interactive grid, you can define row filters by typing directly into the Search field. Click Select Columns to Search to limit the search to a specific column. Alternately, open a Column Heading menu and select a value t'
||'o create a column filter.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317746178658818309)
,p_name=>'APEX.IG.HELP.FILTER_TITLE'
,p_message_text=>'Filter Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1159207456842338185)
,p_name=>'APEX.IG.HELP.FLASHBACK'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to view the data as it existed at a previous point in time.</p>',
'<p>Enter the number of minutes in the past to execute the flashback query.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317744874529813936)
,p_name=>'APEX.IG.HELP.FLASHBACK_TITLE'
,p_message_text=>'Flashback Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317746765893821800)
,p_name=>'APEX.IG.HELP.GROUP_BY_TITLE'
,p_message_text=>'Group By Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1159207803119338874)
,p_name=>'APEX.IG.HELP.HIGHLIGHT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to highlight rows or columns of data based on the condition entered.</p>',
'',
'<p><strong>Highlight List</strong><br>',
'The Highlight list displays defined highlights. Disable an existing highlight by deselecting it.<br>',
'Click Add ( &plus; ) to create a new highlight, or Delete ( &minus; ) to remove an existing highlight.</p>',
'',
'<p><strong>Highlight Settings</strong><br>',
'Use the form to define the highlight properties.<br>',
'Enter the name, select Row or Column, and select the HTML color codes for the background and text.<br>',
'Select the appropriate <strong>Condition Type</strong> to highlight specific data:<br>',
'&nbsp;&nbsp;&nbsp;Row - highlight the term in any column.<br>',
'&nbsp;&nbsp;&nbsp;Column - highlight within a specific column based on the specified operator and value.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317744636733812631)
,p_name=>'APEX.IG.HELP.HIGHLIGHT_TITLE'
,p_message_text=>'Highlight Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1159208297566340829)
,p_name=>'APEX.IG.HELP.REPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to save changes you have made to the current grid layout and configuration.<br>',
'Application developers can define multiple alternate report layouts. Where permissible, you and other end users can save a report as Public, which makes the report available to all other users of the grid. You can also save a report as a Private repo'
||'rt that only you can view.</p>',
'<p>Select from the available types and enter a name for the saved report.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317743855107809940)
,p_name=>'APEX.IG.HELP.REPORT_TITLE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Report Help',
''))
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1159206753419336137)
,p_name=>'APEX.IG.HELP.SORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this dialog to set the display order.</p>',
'',
'<p><strong>Sort List</strong><br>',
'The Sort dialog displays a list of configured sorting rules.<br>',
'Click Add ( &plus; ) to create a sort column, or Delete ( &minus; ) to remove a sort column.<br>',
'Click Move Up ( &uarr; ) and Move Down ( &darr; ) to move the selected sort column up and down relative to the other sort columns.</p>',
'',
'<p><strong>Sort Settings</strong><br>',
'Select a sort column, the sort direction, and how to order null columns (columns with no value).</p>',
'',
'<p><em>Note: Data can be sorted by columns which are not displayed; however, not all columns may be sortable.</em><br>',
'<em>Displayed columns can be sorted by pressing the up (ascending) or down (descending) arrows at the end of the column headings. To add a subsequent column to an existing sort, hold the Shift key and click the up or down arrow.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317745734142817317)
,p_name=>'APEX.IG.HELP.SORT_TITLE'
,p_message_text=>'Sort Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1317743340591806330)
,p_name=>'APEX.IG.HELP.SUBSCRIPTION_TITLE'
,p_message_text=>'Subscription Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436890584824101871)
,p_name=>'APEX.IG.HIDE'
,p_message_text=>'Hide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253105098467432574)
,p_name=>'APEX.IG.HIGHLIGHT'
,p_message_text=>'Highlight'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942328021569614121)
,p_name=>'APEX.IG.HIGH_COLUMN'
,p_message_text=>'High'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942330678133624297)
,p_name=>'APEX.IG.HORIZONTAL'
,p_message_text=>'Horizontal'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404803368145869767)
,p_name=>'APEX.IG.HOURS'
,p_message_text=>'hours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436650893457781656)
,p_name=>'APEX.IG.ICON'
,p_message_text=>'Icon'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253102862831423517)
,p_name=>'APEX.IG.ICON_VIEW'
,p_message_text=>'Icon View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404795665572514384)
,p_name=>'APEX.IG.IN'
,p_message_text=>'in'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436889253916081660)
,p_name=>'APEX.IG.INACTIVE_SETTING'
,p_message_text=>'Inactive Setting'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436889413069083164)
,p_name=>'APEX.IG.INACTIVE_SETTINGS'
,p_message_text=>'Inactive Settings'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(482900488999245266)
,p_name=>'APEX.IG.INTERNAL_ERROR'
,p_message_text=>'An internal error has occurred while processing the Interactive Grid request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1302908840610021706)
,p_name=>'APEX.IG.INVALID_DATE_FORMAT'
,p_message_text=>'Invalid Date Format'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1361322172544070615)
,p_name=>'APEX.IG.INVALID_SETTING'
,p_message_text=>'Invalid Setting'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1361322327986072559)
,p_name=>'APEX.IG.INVALID_SETTINGS'
,p_message_text=>'Invalid Settings'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1048091640010697283)
,p_name=>'APEX.IG.INVALID_SORT_BY'
,p_message_text=>'Sort By has been set to %0, but no column as been selected for %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(994448126332016743)
,p_name=>'APEX.IG.INVALID_VALUE'
,p_message_text=>'Invalid Value'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(932008083257271078)
,p_name=>'APEX.IG.INVISIBLE'
,p_message_text=>'Not Displayed'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404797241768529254)
,p_name=>'APEX.IG.IN_THE_LAST'
,p_message_text=>'in the last'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404797661797531688)
,p_name=>'APEX.IG.IN_THE_NEXT'
,p_message_text=>'in the next'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404795453167513465)
,p_name=>'APEX.IG.IS_NOT_NULL'
,p_message_text=>'is not empty'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404795250103512254)
,p_name=>'APEX.IG.IS_NULL'
,p_message_text=>'is empty'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054976912831911572)
,p_name=>'APEX.IG.LABEL'
,p_message_text=>'Label'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942326072605608093)
,p_name=>'APEX.IG.LABEL_COLUMN'
,p_message_text=>'Label'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(973826061038681470)
,p_name=>'APEX.IG.LAST'
,p_message_text=>'Last'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370792149803626119)
,p_name=>'APEX.IG.LAST.DAY'
,p_message_text=>'Last Day'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370792373253626120)
,p_name=>'APEX.IG.LAST.HOUR'
,p_message_text=>'Last Hour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370799595813722477)
,p_name=>'APEX.IG.LAST.MINUTE'
,p_message_text=>'Last Minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370791898737626119)
,p_name=>'APEX.IG.LAST.MONTH'
,p_message_text=>'Last Month'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370791917636626119)
,p_name=>'APEX.IG.LAST.WEEK'
,p_message_text=>'Last Week'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370792050980626119)
,p_name=>'APEX.IG.LAST.X_DAYS'
,p_message_text=>'Last %0 Days'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370792299341626120)
,p_name=>'APEX.IG.LAST.X_HOURS'
,p_message_text=>'Last %0 Hours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370799798794723960)
,p_name=>'APEX.IG.LAST.X_MINUTES'
,p_message_text=>'Last %0 Minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370798573629714357)
,p_name=>'APEX.IG.LAST.X_MONTHS'
,p_message_text=>'Last %0 Months'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370798320950712741)
,p_name=>'APEX.IG.LAST.X_WEEKS'
,p_message_text=>'Last %0 Weeks'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370791628064626118)
,p_name=>'APEX.IG.LAST.X_YEARS'
,p_message_text=>'Last %0 Years'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370791743411626119)
,p_name=>'APEX.IG.LAST.YEAR'
,p_message_text=>'Last Year'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054977408774922263)
,p_name=>'APEX.IG.LAYOUT_ALIGN'
,p_message_text=>'Cell Alignment'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054977893245928397)
,p_name=>'APEX.IG.LAYOUT_USEGROUPFOR'
,p_message_text=>'Use Group For'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404796499192522476)
,p_name=>'APEX.IG.LESS_THAN'
,p_message_text=>'less than'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404796694662523747)
,p_name=>'APEX.IG.LESS_THAN_OR_EQUALS'
,p_message_text=>'less than or equals'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942331839259631356)
,p_name=>'APEX.IG.LINE'
,p_message_text=>'Line'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942332064430632572)
,p_name=>'APEX.IG.LINE_WITH_AREA'
,p_message_text=>'Line with Area'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054979393387019261)
,p_name=>'APEX.IG.LISTAGG'
,p_message_text=>'Listagg'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942328268912614934)
,p_name=>'APEX.IG.LOW_COLUMN'
,p_message_text=>'Low'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107296133634884322)
,p_name=>'APEX.IG.MAILADDRESSES_COMMASEP'
,p_message_text=>'Separate multiple addresses with commas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404798810111542378)
,p_name=>'APEX.IG.MATCHES_REGULAR_EXPRESSION'
,p_message_text=>'matches regular expression'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(611470501472295929)
,p_name=>'APEX.IG.MAX'
,p_message_text=>'Maximum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475738429565965453)
,p_name=>'APEX.IG.MAX_OVERALL'
,p_message_text=>'Overall Maximum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(611470977135297514)
,p_name=>'APEX.IG.MEDIAN'
,p_message_text=>'Median'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475738756828969933)
,p_name=>'APEX.IG.MEDIAN_OVERALL'
,p_message_text=>'Overall Median'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(611470368378294684)
,p_name=>'APEX.IG.MIN'
,p_message_text=>'Minimum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404803148109868773)
,p_name=>'APEX.IG.MINUTES'
,p_message_text=>'minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(617543543269810371)
,p_name=>'APEX.IG.MINUTES_AGO'
,p_message_text=>'Minutes ago'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475738168592962321)
,p_name=>'APEX.IG.MIN_OVERALL'
,p_message_text=>'Overall Minimum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404803977589871929)
,p_name=>'APEX.IG.MONTHS'
,p_message_text=>'months'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436890157703095967)
,p_name=>'APEX.IG.MORE_DATA_FOUND'
,p_message_text=>'The data contains more than %0 rows which exceeds the maximum allowed. Please apply additional filters in order to view the results.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436643745713647879)
,p_name=>'APEX.IG.NAME'
,p_message_text=>'Name'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436644493900664730)
,p_name=>'APEX.IG.NAMED_REPORT'
,p_message_text=>'Named Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370791056347624894)
,p_name=>'APEX.IG.NEXT.DAY'
,p_message_text=>'Next Day'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370790873207624893)
,p_name=>'APEX.IG.NEXT.HOUR'
,p_message_text=>'Next Hour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370799973680725581)
,p_name=>'APEX.IG.NEXT.MINUTE'
,p_message_text=>'Next Minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370791300449624894)
,p_name=>'APEX.IG.NEXT.MONTH'
,p_message_text=>'Next Month'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370791246795624894)
,p_name=>'APEX.IG.NEXT.WEEK'
,p_message_text=>'Next Week'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370791166014624894)
,p_name=>'APEX.IG.NEXT.X_DAYS'
,p_message_text=>'Next %0 Days'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370790969813624893)
,p_name=>'APEX.IG.NEXT.X_HOURS'
,p_message_text=>'Next %0 Hours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370800179174727409)
,p_name=>'APEX.IG.NEXT.X_MINUTES'
,p_message_text=>'Next %0 Minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370794559494665673)
,p_name=>'APEX.IG.NEXT.X_MONTHS'
,p_message_text=>'Next %0 Months'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370794719214674295)
,p_name=>'APEX.IG.NEXT.X_WEEKS'
,p_message_text=>'Next %0 Weeks'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370791542595624895)
,p_name=>'APEX.IG.NEXT.X_YEARS'
,p_message_text=>'Next %0 Years'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(370791482541624894)
,p_name=>'APEX.IG.NEXT.YEAR'
,p_message_text=>'Next Year'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404797058477527630)
,p_name=>'APEX.IG.NOT_BETWEEN'
,p_message_text=>'not between'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404795044166510316)
,p_name=>'APEX.IG.NOT_EQUALS'
,p_message_text=>'not equals'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2015519456814021000)
,p_name=>'APEX.IG.NOT_EXIST'
,p_message_text=>'Region with ID %0 is not an Interactive Grid region or does not exist in application %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404795833888515465)
,p_name=>'APEX.IG.NOT_IN'
,p_message_text=>'not in'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404797441289530252)
,p_name=>'APEX.IG.NOT_IN_THE_LAST'
,p_message_text=>'not in the last'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404797807680533599)
,p_name=>'APEX.IG.NOT_IN_THE_NEXT'
,p_message_text=>'not in the next'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436889846807093500)
,p_name=>'APEX.IG.NO_DATA_FOUND'
,p_message_text=>'No data found'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(973824090213656889)
,p_name=>'APEX.IG.NULLS'
,p_message_text=>'Nulls'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054979888988023971)
,p_name=>'APEX.IG.NUMBER'
,p_message_text=>'Numeric'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(982600887110579242)
,p_name=>'APEX.IG.OFF'
,p_message_text=>'Off'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(982601022621580365)
,p_name=>'APEX.IG.ON'
,p_message_text=>'On'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(392705597849066818)
,p_name=>'APEX.IG.ONE_MINUTE_AGO'
,p_message_text=>'1 minute ago'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1155408954374189289)
,p_name=>'APEX.IG.OPEN_COLORPICKER'
,p_message_text=>'Open Color Picker: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942327648391612587)
,p_name=>'APEX.IG.OPEN_COLUMN'
,p_message_text=>'Open'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436647625712719359)
,p_name=>'APEX.IG.OPERATOR'
,p_message_text=>'Operator'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942325754863606936)
,p_name=>'APEX.IG.ORIENTATION'
,p_message_text=>'Orientation'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942332500521633588)
,p_name=>'APEX.IG.PIE'
,p_message_text=>'Pie'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436651705380786949)
,p_name=>'APEX.IG.PIVOT'
,p_message_text=>'Pivot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253103487137426393)
,p_name=>'APEX.IG.PIVOT_VIEW'
,p_message_text=>'Pivot View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1155123709546580666)
,p_name=>'APEX.IG.PLACEHOLDER_INVALUES'
,p_message_text=>'Separate values with "%0"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942332765819636083)
,p_name=>'APEX.IG.POLAR'
,p_message_text=>'Polar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054880008749858677)
,p_name=>'APEX.IG.POSITION_CENTER'
,p_message_text=>'Center'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054880242622859339)
,p_name=>'APEX.IG.POSITION_END'
,p_message_text=>'End'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054879818158857530)
,p_name=>'APEX.IG.POSITION_START'
,p_message_text=>'Start'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436644891754670574)
,p_name=>'APEX.IG.PRIMARY'
,p_message_text=>'Primary'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436645782872691039)
,p_name=>'APEX.IG.PRIMARY_DEFAULT'
,p_message_text=>'Primary Default'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(537701974984676361)
,p_name=>'APEX.IG.PRIMARY_REPORT'
,p_message_text=>'Primary Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942333213903637449)
,p_name=>'APEX.IG.RADAR'
,p_message_text=>'Radar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942333422167639310)
,p_name=>'APEX.IG.RANGE'
,p_message_text=>'Range'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1163359191867029133)
,p_name=>'APEX.IG.REFRESH'
,p_message_text=>'Refresh'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436893191871135971)
,p_name=>'APEX.IG.REFRESH_ROW'
,p_message_text=>'Refresh Row'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436888629761065089)
,p_name=>'APEX.IG.REFRESH_ROWS'
,p_message_text=>'Refresh Rows'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253106488058438288)
,p_name=>'APEX.IG.REMOVE_CONTROL'
,p_message_text=>'Remove %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436642959576638718)
,p_name=>'APEX.IG.REPORT'
,p_message_text=>'Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1815758117835027474)
,p_name=>'APEX.IG.REPORT.DELETED'
,p_message_text=>'Report deleted'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1815757548843013008)
,p_name=>'APEX.IG.REPORT.SAVED.ALTERNATIVE'
,p_message_text=>'Alternative report saved for all users'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1815757005330000590)
,p_name=>'APEX.IG.REPORT.SAVED.DEFAULT'
,p_message_text=>'Default report saved for all users'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1815757909406021772)
,p_name=>'APEX.IG.REPORT.SAVED.PRIVATE'
,p_message_text=>'Private report saved'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1815757790734018205)
,p_name=>'APEX.IG.REPORT.SAVED.PUBLIC'
,p_message_text=>'Public report saved for all users'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(392705385453044397)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF.X.MINUTES_AGO'
,p_message_text=>'Report data as of %0 minutes ago'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(392705114775041923)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF_ONE_MINUTE_AGO'
,p_message_text=>'Report data as of 1 minute ago'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1326762232346092281)
,p_name=>'APEX.IG.REPORT_EDIT'
,p_message_text=>'Report - Edit'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1326762020520089106)
,p_name=>'APEX.IG.REPORT_SAVE_AS'
,p_message_text=>'Report - Save As'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253106663897439057)
,p_name=>'APEX.IG.REPORT_SETTINGS'
,p_message_text=>'Report Settings'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2015519732569359060)
,p_name=>'APEX.IG.REPORT_STATIC_ID_DOES_NOT_EXIST'
,p_message_text=>'Saved Interactive Grid with static ID %0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475733412334807654)
,p_name=>'APEX.IG.REPORT_VIEW'
,p_message_text=>'Report View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253104874689431832)
,p_name=>'APEX.IG.RESET'
,p_message_text=>'Reset'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436893404354138823)
,p_name=>'APEX.IG.REVERT_CHANGES'
,p_message_text=>'Revert Changes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436888849868066279)
,p_name=>'APEX.IG.REVERT_ROWS'
,p_message_text=>'Revert Rows'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436646237613698343)
,p_name=>'APEX.IG.ROW'
,p_message_text=>'Row'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436640738472599290)
,p_name=>'APEX.IG.ROWS_PER_PAGE'
,p_message_text=>'Rows Per Page'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1922047733969401965)
,p_name=>'APEX.IG.ROW_ACTIONS'
,p_message_text=>'Row Actions'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2199701897603048458)
,p_name=>'APEX.IG.ROW_ACTIONS_FOR'
,p_message_text=>'Actions for row %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253105492018434006)
,p_name=>'APEX.IG.SAVE'
,p_message_text=>'Save'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(498555375783219654)
,p_name=>'APEX.IG.SAVED'
,p_message_text=>'saved'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253101855943418320)
,p_name=>'APEX.IG.SAVED_REPORTS'
,p_message_text=>'Saved Reports'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253102095015419355)
,p_name=>'APEX.IG.SAVED_REPORT_DEFAULT'
,p_message_text=>'Default'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253102285506420394)
,p_name=>'APEX.IG.SAVED_REPORT_PRIVATE'
,p_message_text=>'Private'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253102458792421372)
,p_name=>'APEX.IG.SAVED_REPORT_PUBLIC'
,p_message_text=>'Public'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475689217503115735)
,p_name=>'APEX.IG.SAVE_AS'
,p_message_text=>'Save As'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436886760070049795)
,p_name=>'APEX.IG.SAVE_REPORT_SETTINGS'
,p_message_text=>'Save Report Settings'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942333612003640837)
,p_name=>'APEX.IG.SCATTER'
,p_message_text=>'Scatter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253101633445417120)
,p_name=>'APEX.IG.SEARCH'
,p_message_text=>'Search'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1102333501644064230)
,p_name=>'APEX.IG.SEARCH.ALL_COLUMNS'
,p_message_text=>'Search: All Text Columns'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253101202071414619)
,p_name=>'APEX.IG.SEARCH.COLUMN'
,p_message_text=>'Search: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1082589981930085442)
,p_name=>'APEX.IG.SEARCH.ORACLE_TEXT'
,p_message_text=>'Search: Full Text'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(392704898638969443)
,p_name=>'APEX.IG.SEARCH_FOR.X'
,p_message_text=>'Search for ''%0'''
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(931968379610053142)
,p_name=>'APEX.IG.SELECT'
,p_message_text=>'- Select -'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(309956341143862219)
,p_name=>'APEX.IG.SELECTION'
,p_message_text=>'Selection'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(738648437242360324)
,p_name=>'APEX.IG.SELECT_1_ROW_IN_MASTER'
,p_message_text=>'Select 1 row in the master region'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253101015887413102)
,p_name=>'APEX.IG.SELECT_COLUMNS_TO_SEARCH'
,p_message_text=>'Select columns to search'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1853978627372041157)
,p_name=>'APEX.IG.SEL_ACTIONS'
,p_message_text=>'Selection Actions'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(309956765605872724)
,p_name=>'APEX.IG.SEL_MODE_CELL'
,p_message_text=>'Cell Selection'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(309956574413870170)
,p_name=>'APEX.IG.SEL_MODE_ROW'
,p_message_text=>'Row Selection'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107293919152828938)
,p_name=>'APEX.IG.SEND_AS_EMAIL'
,p_message_text=>'Send as Email'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(949346833084031756)
,p_name=>'APEX.IG.SERIES_COLUMN'
,p_message_text=>'Series'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(230122436194091558)
,p_name=>'APEX.IG.SHOW'
,p_message_text=>'Show'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(582849405846815319)
,p_name=>'APEX.IG.SHOW_OVERALL_VALUE'
,p_message_text=>'Show Overall Value'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436892123328128970)
,p_name=>'APEX.IG.SINGLE_ROW_VIEW'
,p_message_text=>'Single Row View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436652408082806049)
,p_name=>'APEX.IG.SORT'
,p_message_text=>'Sort'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(949347060677033130)
,p_name=>'APEX.IG.SORT_BY'
,p_message_text=>'Sort By'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1922048548788589345)
,p_name=>'APEX.IG.SORT_ONLY_ONE_PER_COLUMN'
,p_message_text=>'You can define only one sort per column.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1855715169847720287)
,p_name=>'APEX.IG.SRV_CHANGE_MENU'
,p_message_text=>'Change Menu'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(982601294199581471)
,p_name=>'APEX.IG.STACK'
,p_message_text=>'Stack'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404798477468538053)
,p_name=>'APEX.IG.STARTS_WITH'
,p_message_text=>'starts with'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942333950655642023)
,p_name=>'APEX.IG.STOCK'
,p_message_text=>'Stock'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177975007259589305)
,p_name=>'APEX.IG.STRETCH_COLUMNS'
,p_message_text=>'Stretch Column Widths'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436887300185054454)
,p_name=>'APEX.IG.SUBSCRIPTION'
,p_message_text=>'Subscription'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(611470140186293498)
,p_name=>'APEX.IG.SUM'
,p_message_text=>'Sum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2199727297111408409)
,p_name=>'APEX.IG.SUMMARY'
,p_message_text=>'Interactive Grid. Report: %0, View: %1.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1475735820903940106)
,p_name=>'APEX.IG.SUM_OVERALL'
,p_message_text=>'Overall Sum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942329018935616633)
,p_name=>'APEX.IG.TARGET_COLUMN'
,p_message_text=>'Target'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1049329229616360742)
,p_name=>'APEX.IG.TEXT_COLOR'
,p_message_text=>'Text Color'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(253106881522439789)
,p_name=>'APEX.IG.TOGGLE'
,p_message_text=>'Toggle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(582849147873808293)
,p_name=>'APEX.IG.TOOLTIP'
,p_message_text=>'Tooltip'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436643220260641671)
,p_name=>'APEX.IG.TYPE'
,p_message_text=>'Type'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436891184596106666)
,p_name=>'APEX.IG.UNFREEZE'
,p_message_text=>'Unfreeze'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436648217778725151)
,p_name=>'APEX.IG.UNIT'
,p_message_text=>'Unit'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1107239918670882547)
,p_name=>'APEX.IG.UNSAVED_CHANGES_CONTINUE_CONFIRM'
,p_message_text=>'There are unsaved changes. Do you want to continue?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436647923235721837)
,p_name=>'APEX.IG.VALUE'
,p_message_text=>'Value'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942326298694609141)
,p_name=>'APEX.IG.VALUE_COLUMN'
,p_message_text=>'Value'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1008022159557286347)
,p_name=>'APEX.IG.VALUE_REQUIRED'
,p_message_text=>'A value is required.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(692281872005819616)
,p_name=>'APEX.IG.VALUE_TIMESTAMP_TZ'
,p_message_text=>'Value (time zone cannot be changed)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1054980048502024996)
,p_name=>'APEX.IG.VARCHAR2'
,p_message_text=>'Text'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942330295739623120)
,p_name=>'APEX.IG.VERTICAL'
,p_message_text=>'Vertical'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(436639974099577061)
,p_name=>'APEX.IG.VIEW'
,p_message_text=>'View'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(932007364564253658)
,p_name=>'APEX.IG.VISIBLE'
,p_message_text=>'Displayed'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942328695378615749)
,p_name=>'APEX.IG.VOLUME_COLUMN'
,p_message_text=>'Volume'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404803745702871164)
,p_name=>'APEX.IG.WEEKS'
,p_message_text=>'weeks'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(932007590648255273)
,p_name=>'APEX.IG.WIDTH'
,p_message_text=>'Minimum Column Width (Pixel)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382403887030219061)
,p_name=>'APEX.IG.X.BETWEEN.Y.AND.Z'
,p_message_text=>'%0 between %1 and %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382403213358215207)
,p_name=>'APEX.IG.X.CONTAINS.Y'
,p_message_text=>'%0 contains %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382403434757216304)
,p_name=>'APEX.IG.X.DOES_NOT_CONTAIN.Y'
,p_message_text=>'%0 does not contain %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(225659523230958197)
,p_name=>'APEX.IG.X.DOES_NOT_START_WITH.Y'
,p_message_text=>'%0 does not start with %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382400865718193282)
,p_name=>'APEX.IG.X.EQUALS.Y'
,p_message_text=>'%0 equals %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382401220702197939)
,p_name=>'APEX.IG.X.GREATER_THAN.Y'
,p_message_text=>'%0 greater than %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382401439721200696)
,p_name=>'APEX.IG.X.GREATER_THAN_OR_EQUALS.Y'
,p_message_text=>'%0 greater than or equal to %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382402885824212764)
,p_name=>'APEX.IG.X.IN.Y'
,p_message_text=>'%0 in %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382405267712231560)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.DAYS'
,p_message_text=>'%0 in the last %1 days'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382404848314228851)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.HOURS'
,p_message_text=>'%0 in the last %1 hours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382404459172226397)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MINUTES'
,p_message_text=>'%0 in the last %1 minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382406093561237316)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MONTHS'
,p_message_text=>'%0 in the last %1 months'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382405688486233755)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.WEEKS'
,p_message_text=>'%0 in the last %1 weeks'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382406482077241333)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.YEARS'
,p_message_text=>'%0 in the last %1 years'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382405027269230385)
,p_name=>'APEX.IG.X.IN_THE_LAST_DAY'
,p_message_text=>'%0 in the last day'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382404661294227737)
,p_name=>'APEX.IG.X.IN_THE_LAST_HOUR'
,p_message_text=>'%0 in the last hour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382404224714225176)
,p_name=>'APEX.IG.X.IN_THE_LAST_MINUTE'
,p_message_text=>'%0 in the last minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382405809345235214)
,p_name=>'APEX.IG.X.IN_THE_LAST_MONTH'
,p_message_text=>'%0 in the last month'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382405474795232658)
,p_name=>'APEX.IG.X.IN_THE_LAST_WEEK'
,p_message_text=>'%0 in the last week'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382406262318239722)
,p_name=>'APEX.IG.X.IN_THE_LAST_YEAR'
,p_message_text=>'%0 in the last year'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382410031531274099)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.DAYS'
,p_message_text=>'%0 in the next %1 days'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382409696605268271)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.HOURS'
,p_message_text=>'%0 in the next %1 hours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382409212302265744)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MINUTES'
,p_message_text=>'%0 in the next %1 minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382410844664280159)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MONTHS'
,p_message_text=>'%0 in the next %1 months'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382410420156276661)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.WEEKS'
,p_message_text=>'%0 in the next %1 weeks'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382411244782284062)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.YEARS'
,p_message_text=>'%0 in the next %1 years'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382409824832272569)
,p_name=>'APEX.IG.X.IN_THE_NEXT_DAY'
,p_message_text=>'%0 in the next day'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382409487131266858)
,p_name=>'APEX.IG.X.IN_THE_NEXT_HOUR'
,p_message_text=>'%0 in the next hour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382409073583264092)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MINUTE'
,p_message_text=>'%0 in the next minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382410636567278860)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MONTH'
,p_message_text=>'%0 in the next month'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382410212268275535)
,p_name=>'APEX.IG.X.IN_THE_NEXT_WEEK'
,p_message_text=>'%0 in the next week'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382411047889281937)
,p_name=>'APEX.IG.X.IN_THE_NEXT_YEAR'
,p_message_text=>'%0 in the next year'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382402217303206905)
,p_name=>'APEX.IG.X.IS_NOT_NULL'
,p_message_text=>'%0 is not empty'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382402070695205379)
,p_name=>'APEX.IG.X.IS_NULL'
,p_message_text=>'%0 is empty'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382401647638202728)
,p_name=>'APEX.IG.X.LESS_THAN.Y'
,p_message_text=>'%0 less than %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382401854722204063)
,p_name=>'APEX.IG.X.LESS_THAN_OR_EQUALS.Y'
,p_message_text=>'%0 less than or equal to %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382402415481210159)
,p_name=>'APEX.IG.X.LIKE.Y'
,p_message_text=>'%0 like %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382403612102217588)
,p_name=>'APEX.IG.X.MATCHES_REGULAR_EXPRESSION.Y'
,p_message_text=>'%0 matches regular expression %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(392705771422068755)
,p_name=>'APEX.IG.X.MINUTES_AGO'
,p_message_text=>'%0 minutes ago'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382404033282220088)
,p_name=>'APEX.IG.X.NOT_BETWEEN.Y.AND.Z'
,p_message_text=>'%0 not between %1 and %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382401002267195016)
,p_name=>'APEX.IG.X.NOT_EQUALS.Y'
,p_message_text=>'%0 not equals %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382403023376213798)
,p_name=>'APEX.IG.X.NOT_IN.Y'
,p_message_text=>'%0 not in %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382407656651251467)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.DAYS'
,p_message_text=>'%0 not in the last %1 days'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382407223984249263)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.HOURS'
,p_message_text=>'%0 not in the last %1 hours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382406838481245245)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MINUTES'
,p_message_text=>'%0 not in the last %1 minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382408418018258152)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MONTHS'
,p_message_text=>'%0 not in the last %1 months'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382408024644255075)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.WEEKS'
,p_message_text=>'%0 not in the last %1 weeks'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382408804059261335)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.YEARS'
,p_message_text=>'%0 not in the last %1 years'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382407485496250479)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_DAY'
,p_message_text=>'%0 not in the last day'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382407077546247396)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_HOUR'
,p_message_text=>'%0 not in the last hour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382406601254242573)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MINUTE'
,p_message_text=>'%0 not in the last minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382408255103256403)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MONTH'
,p_message_text=>'%0 not in the last month'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382407832895253623)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_WEEK'
,p_message_text=>'%0 not in the last week'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382408693718259757)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_YEAR'
,p_message_text=>'%0 not in the last year'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382412466384294656)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.DAYS'
,p_message_text=>'%0 not in the next %1 days'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382412062003292565)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.HOURS'
,p_message_text=>'%0 not in the next %1 hours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382411668556288907)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MINUTES'
,p_message_text=>'%0 not in the next %1 minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382413227340300896)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MONTHS'
,p_message_text=>'%0 not in the next %1 months '
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382412832878297692)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.WEEKS'
,p_message_text=>'%0 not in the next %1 weeks'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382413624905304130)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.YEARS'
,p_message_text=>'%0 not in the next %1 years'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382412203141293547)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_DAY'
,p_message_text=>'%0 not in the next day'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382411856070290243)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_HOUR'
,p_message_text=>'%0 not in the next hour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382411462429287780)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MINUTE'
,p_message_text=>'%0 not in the next minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382413016592299415)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MONTH'
,p_message_text=>'%0 not in the next month'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382412651807295946)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_WEEK'
,p_message_text=>'%0 not in the next week'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382413431400301950)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_YEAR'
,p_message_text=>'%0 not in the next year'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382402688672211435)
,p_name=>'APEX.IG.X.NOT_LIKE.Y'
,p_message_text=>'%0 not like %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404446650908657043)
,p_name=>'APEX.IG.X.STARTS_WITH.Y'
,p_message_text=>'%0 starts with %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942326683027610260)
,p_name=>'APEX.IG.X_COLUMN'
,p_message_text=>'X'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(404804146887872738)
,p_name=>'APEX.IG.YEARS'
,p_message_text=>'years'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942327273005611004)
,p_name=>'APEX.IG.Y_COLUMN'
,p_message_text=>'Y'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942327461407611678)
,p_name=>'APEX.IG.Z_COLUMN'
,p_message_text=>'Z'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1094566075165687231)
,p_name=>'APEX.IG_FORMAT_SAMPLE_1'
,p_message_text=>'Monday, 12 January, 2016'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1094566285019691450)
,p_name=>'APEX.IG_FORMAT_SAMPLE_2'
,p_message_text=>'January'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1094566476468694062)
,p_name=>'APEX.IG_FORMAT_SAMPLE_3'
,p_message_text=>'16 hours ago'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1094566696931694955)
,p_name=>'APEX.IG_FORMAT_SAMPLE_4'
,p_message_text=>'in 16h'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66173618008083723)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_text=>'Printing support must be either STANDARD or ADVANCED'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66174023549085299)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_text=>'Cannot remove first schema provisioned'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(24557818073907060)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_text=>'Invalid application ID.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(249468900103202117)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_text=>'Invalid Email address'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21961906187835010)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_text=>'Value must be zero or a positive integer.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66174529782087088)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_text=>'Invalid port number'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(295567327400638221)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_text=>'Invalid subscription ID.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66174904979089370)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_text=>'Wallet path must be in the form file:<filesystempath>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(98891620098834899)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_text=>'The workspace was not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(98882701388753837)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_text=>'Invalid workspace ID.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(79475304028561473)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_text=>'The value "%1" of instance parameter "%0" does not match regular expression "%2"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(79475223911236089)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_text=>'The instance parameter "%0" must have a value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66175510866091123)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_text=>'Instance parameter not found'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(288077407792782328)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_text=>'Password'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6115905511977304)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(480992070311969668)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(362586005740005181)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(118624798306312512)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(288073403983781233)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_text=>'Password (For authentication against workspace user account repository only)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66312611523315675)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_text=>'Print server protocol must be either http or https'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66313020874318381)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_text=>'Schema does not exist'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66313428492320660)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_text=>'Schema is restricted'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15755597969243546)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15755119993235451)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_text=>'Application no longer exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(510501949159987765)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_text=>'Assign'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(681640508284272117)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_text=>'Cards'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15763795466715114)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_text=>'Commented'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15762404351690795)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_text=>'comments'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6788125556287759)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_text=>'Delete'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6787551832283275)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_text=>'Are you sure you want to delete this comment?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(500030975775711386)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_text=>'Delete Issue'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10546849968035579)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_text=>'Are you sure you want to delete this issue?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15769641748946864)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_text=>'Document'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15765460435759253)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_text=>'Documents'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6787823569286241)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_text=>'Edit'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(563176259568667423)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_text=>'Edit Comment'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(563176612274669818)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_text=>'Edit Issue'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15757514978409950)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_text=>'Application specified does not exist in this workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15758386464439501)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_text=>'Error attempting to delete comment.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15758128174434701)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_text=>'Comment not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15758928743451732)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_text=>'Issue not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15759119813458689)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_text=>'Error attempting to mark issue for delete.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15757721148415641)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_text=>'Page specified does not exist in this workspace or in the provided application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15758560186445720)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_text=>'User is not authorized to delete this comment.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15759330510464873)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_text=>'User not authorized to delete this issue.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15757977766430563)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_text=>'User is not authorized to change the visibility of this comment.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(598679943579795070)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_text=>'There was a problem checking file sizes. Please contact your system administrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(598679623924784998)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_text=>'One of these files is larger than the max file size of %0 bytes.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(598669656884776816)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_text=>'This file is larger than the maximum file size of %0 bytes.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6788392375288492)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_text=>'Hide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15769212667944478)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_text=>'Image'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15765090237756188)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_text=>'Images'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15754321445205293)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_text=>'an issue that was not found in the system'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1659503297613032)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_text=>'Add Preference for User'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15763984156734988)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_text=>'Attach Files'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15761764932646517)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_text=>'Closed'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(698743093683144194)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_text=>'Heading'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15767952903890575)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_text=>'is empty.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15767555285843328)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_text=>'One of these files is'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15761331822642524)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_text=>'Open'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15776591708128695)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_text=>'Permanently Delete Selected'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(500417367361378905)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_text=>'Purge All'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15776301247123383)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_text=>'Reinstate Selected'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15764105164737383)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_text=>'Response Templates'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15767745366885392)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_text=>'too large to upload. <br>Files must be less than'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15768686319917121)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_text=>'Supported file types are: '
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(586263564801423122)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_text=>'Select a Response Template'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15767379936829231)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_text=>'This file is'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15768144002899184)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_text=>'not a supported file type.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459414268865169612)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459415474770182851)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_text=>'Documentation Issue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459414410540173125)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_text=>'Enhancement Request'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459414695207174891)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_text=>'Feature Request'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459415270051180858)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_text=>'Installation Issue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459415061051178881)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_text=>'Performance Issue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459414826096176730)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_text=>'Security Issue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459415630553184166)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_text=>'Training Issue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459417047404196234)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_text=>'Administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459416482013191574)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_text=>'CSS / HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459416658696194018)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_text=>'Dynamic Actions / JavaScript'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459416028114188787)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_text=>'Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459417246817198623)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_text=>'External System Integration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459416251897190299)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_text=>'REST Integration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459416861408194923)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_text=>'Security'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459415881988187616)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_text=>'UI / UX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459414055537163639)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_text=>'Category assigned to the issue.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459412139945138517)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_text=>'Category'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459413873260160868)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_text=>'Functional area affected by the issue.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459412387728141273)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_text=>'Functional Area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459413600296157679)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_text=>'Level of importance assigned to the issue.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459412515948143780)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_text=>'Importance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459413402585154504)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_text=>'Level of effort to address the issue.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459412757477145573)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_text=>'Level of Effort'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459413219977151330)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_text=>'Progress against the issue.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459412999120146808)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_text=>'Progress'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459418006306205982)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_text=>'Backlog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459417411926202503)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_text=>'Critical'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459417695263203303)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_text=>'Important'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459417800739204284)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_text=>'Normal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459418285551207449)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_text=>'Will Not Address'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459418454661211243)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_text=>'Easy Fix'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459418874349214088)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_text=>'Large Development Effort'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459418678569212348)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_text=>'Moderate Effort'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459419670793223855)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_text=>'Can Not Fix'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459419855083225058)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_text=>'Complete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459419224245220503)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_text=>'Requires More Info'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459419450587222758)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_text=>'Waiting on Third Party'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459419098647218464)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_text=>'Working On It'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461681272756449089)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_text=>'This Label Group may not be deleted because one or more of its members is assigned to an issue.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15760115651579953)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_text=>'Marked duplicate of'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(500032458659723624)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_text=>'Assignees'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(500032225975723007)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_text=>'Labels'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(500194278431059049)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_text=>'Milestones'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(500032000488721930)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_text=>'Status'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15752717890152350)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_text=>'milestones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(460427799520556560)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_text=>'Code Freeze'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(460428113883562989)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_text=>'Final Release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(460427974831560195)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_text=>'UI Freeze'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15775324805078948)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_text=>'%0 added a comment to %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1420753918636510)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_text=>'has changed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471455708555167362)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_text=>'Issue number %0 in workspace %1 has changed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(598636091558730275)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_text=>'No Labels have been defined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15765842514763884)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_text=>'Other'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15755764899244576)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_text=>'Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15755321856237326)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_text=>'Page no longer exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(673260390160512570)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_text=>'Purge All'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(510502185254988762)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_text=>'Remove'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15754762488223719)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_text=>'Removed the Application and Page association from'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15756510522271058)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_text=>'Removed the attachment'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(625055880474785986)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_text=>'Do you want to replace your current comment with this template?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(627065760940319955)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hi there! ',
'',
'This is your very first issue! You can create issues to keep track of tasks, features, bugs, and feedback for all of your APEX projects!  You can add labels to issues, add assignees, set milestones, and even apply formatting using Markdown shorthand!'
||'  ',
'',
'Below is a quick sample of what you can do with Markdown:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(627020434793279507)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_text=>'Welcome to Team Development in Oracle APEX!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(514603986874946476)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_text=>'- Select -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15756749342273960)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_text=>'Set status to'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6824529888322728)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_text=>'Show actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(626969010413120433)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_text=>'Show More...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15755933081249428)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_text=>'Subscribed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(598752029318567239)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_text=>'%0 in workspace %1 has %2 new notifications.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459406070959977425)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_text=>'Template used to log a bug.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459405325950965248)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_text=>'Bug Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459404851388926104)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Expected Behavior**',
'- Tell us what you believe should happen.',
'',
'',
'**Current Behavior**',
'- Tell us what happens.',
'',
'',
'**Who is affected**',
'- Tell us who/what is affected. ',
'',
'**Possible Solution**',
'- If you can, suggest how you would fix this bug.',
'',
'**Steps to Reproduce**',
'- Provide an unambiguous set of steps to reproduce, including screen shots and code snippets if appropriate.',
'1.',
'2.',
'3.',
'',
'**Context**',
'- What were you trying to accomplish when the bug occurred. Does the bug only occur under certain conditions, or at certain times of day, and so forth.',
'',
'**Environment**',
'',
'- Version: ',
'- Platform: ',
'- Subsystem:',
'',
'______',
'',
'_**NOTE:** To associate an issue with an application and/or page, first log the issue, then use the **ACTIONS** drop down to associate the App and Page._'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459408795010070233)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_text=>'A bug has been raised.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459408570739066912)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_text=>'Bug Raised'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459408946397074008)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'A **Bug** has been filed in the appropriate external system.',
'',
'- Bug Tracking System: ',
'- Bug ID: ',
'- URL to bug: ',
'',
'Comments:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459406805249027008)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_text=>'Template used to log a feature request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459406654637024303)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_text=>'Feature Request Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459407083603031574)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Feature Summary**',
' - Provide a one paragraph general overview of the feature request.',
'',
'',
'**Context**',
' - Does this request relate to a specific situation or process? For example, "I am always frustrated when [...]"',
'',
'',
' - Please provide any supporting information, including screenshots, use cases, and so forth.',
'',
'',
'**Preferred Solution**',
'- Provide a clear description of what you would like to see implemented.',
'',
'',
'**Alternative Solutions**',
'- Provide a description of alternative solutions or features considered, or workarounds used.',
'',
'',
'______',
'_**NOTE:** To associate an issue with an application and/or page, first log the issue, then use the **ACTIONS** drop down to associate the App and Page._'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459409339680081921)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_text=>'A feature request has been filed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459409110641078448)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_text=>'Feature Request Filed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459409590453084860)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'A **Feature Request** has been filed in the appropriate external system.',
'',
'- Feature Tracking System: ',
'- Feature ID: ',
'- URL to Feature Definition: ',
'',
'Comments:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459411166280106591)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_text=>'A followup action is required.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459410914872104152)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_text=>'Followup Action Required'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459411342342109166)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Please perform the following actions: ',
'',
'1.',
'2.',
'3.',
'4.',
'',
'Comments: '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459407429811046820)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_text=>'Template used to ask a procedural question.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459407251548044622)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_text=>'How Do I ...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459407693725049491)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Question**',
'- State your question or request as succinctly as possible.',
'',
'**General Context**',
'- What are you trying to do? ',
'',
'',
'- Where else have you looked or who else have you contacted to find an answer? ',
'',
'',
'**Environment** ',
'Is this question specific to an environment, programming language or other area?',
'',
'______',
'_**NOTE:** To associate an issue with an application and/or page, first log the issue, then use the **ACTIONS** drop down to associate the App and Page._'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459410582957099400)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_text=>'Reference a known issue.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459410349696095617)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_text=>'Known Issue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459410743655101136)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'After review, it has been determined that this is a known issue, see details below.',
'',
'- Bug Tracking System: ',
'- Bug ID: ',
'- URL to bug: ',
'',
'Comments: '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459409972722090704)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_text=>'Request for more information.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459409725735088140)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_text=>'Need More Information'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459410136474093077)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**More information is needed for this issue:**',
'',
'Please provide the information requested below. Without this information it will be difficult to triage and address the issue further.',
'',
'',
'Comments:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459408193962060440)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_text=>'This issue will not be actioned'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459407948488057034)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_text=>'Won''t Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(459408349341062954)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'After careful consideration, **no further action will be taken on this issue**. ',
'',
'Comments:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15769868452948224)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_text=>'Text File'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15765698960761153)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_text=>'Text Files'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15751914666135585)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_text=>'this issue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471458196903192063)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_text=>'added the attachment %0 to %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471456152071174289)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_text=>'added %0 to %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471483680554268589)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_text=>'added %0 to %1 %2				'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471456581311177879)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_text=>'assigned %0 to %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471457387041185245)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_text=>'associated %0 with %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15774956500066416)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_text=>'edited a comment for %0	%1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471474151956907146)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_text=>'This issue has been hidden.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471456914764181877)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_text=>'marked %0 as a duplicate of %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471470290824653152)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_text=>'Opened %0 by'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471458397968193844)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_text=>'removed the attachment %0 from %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471456382600176139)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_text=>'removed %0 from %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471483888072272586)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_text=>'removed %0 from %1 %2 			'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471458569323195583)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_text=>'set status for %0 to %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471457701231188763)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_text=>'subscribed to %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471456715018179929)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_text=>'unassigned %0 from %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471457507348186925)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_text=>'removed the Application and Page association from %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471457138248183693)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_text=>'unmarked %0 as duplicate %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471457944217190420)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_text=>'unsubscribed from %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471470035188651331)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_text=>'marked duplicate of %0 %1 by %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15753369414170235)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_text=>'Unassigned'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6788575618289773)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_text=>'Unhide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15756187320259859)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_text=>'Unsubscribed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(500031837979718118)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_text=>'Update...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15769451818945593)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_text=>'Zip File'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15765200525758181)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_text=>'Zip Files'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(716731963153285100)
,p_name=>'APEX.ITEM.FILE.BROWSE'
,p_message_text=>'Browse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(713114456014218471)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILE'
,p_message_text=>'Choose file'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(713114699698219263)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILES'
,p_message_text=>'Choose files'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1840599593386561400)
,p_name=>'APEX.ITEM.HELP_TEXT'
,p_message_text=>'Help Text: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(618179493321995456)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_text=>'Item %0 not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10713920655357983)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_text=>'#LABEL# is not between the valid range of %0 and %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10714105895363214)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_MULTIPLE_OF_STEP'
,p_message_text=>'#LABEL# is not a multiple of %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10585816697145762)
,p_name=>'APEX.ITEM_TYPE.YES_NO.INVALID_VALUE'
,p_message_text=>'#LABEL# must match the values %0 and %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10586225701148335)
,p_name=>'APEX.ITEM_TYPE.YES_NO.NO_LABEL'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(311814916612801507)
,p_name=>'APEX.ITEM_TYPE.YES_NO.OFF_LABEL'
,p_message_text=>'Off'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(311815137469802084)
,p_name=>'APEX.ITEM_TYPE.YES_NO.ON_LABEL'
,p_message_text=>'On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10586022238147350)
,p_name=>'APEX.ITEM_TYPE.YES_NO.YES_LABEL'
,p_message_text=>'Yes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3783001897424)
,p_name=>'APEX.LIST_MANAGER.ADD_ENTRY'
,p_message_text=>'Add Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(486963902987827356)
,p_name=>'APEX.LIST_MANAGER.BUTTON_ADD'
,p_message_text=>'Add'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(486964607835828783)
,p_name=>'APEX.LIST_MANAGER.BUTTON_REMOVE'
,p_message_text=>'Remove'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3783003901244)
,p_name=>'APEX.LIST_MANAGER.SELECTED_ENTRY'
,p_message_text=>'Selected entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(530227565276081238)
,p_name=>'APEX.LTO.ADVANCED'
,p_message_text=>'Advanced'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(530228576622090246)
,p_name=>'APEX.LTO.CANCEL'
,p_message_text=>'Cancel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(530227788879082067)
,p_name=>'APEX.LTO.COMMON'
,p_message_text=>'Common'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(530228815699113691)
,p_name=>'APEX.LTO.LIVE_TEMPLATE_OPTIONS'
,p_message_text=>'Live Template Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(537684588433148944)
,p_name=>'APEX.LTO.NOT_APPLICABLE'
,p_message_text=>'Template Options are not available because this component is not rendered on the page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(530227067847065179)
,p_name=>'APEX.LTO.NO_OPTIONS_FOUND'
,p_message_text=>'No Template Options found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(530228377395089241)
,p_name=>'APEX.LTO.SAVE'
,p_message_text=>'Save'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(517489609116856475)
,p_name=>'APEX.MARKDOWN.BOLD'
,p_message_text=>'Bold'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(524429846250209949)
,p_name=>'APEX.MARKDOWN.IMAGE'
,p_message_text=>'Image'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(524428592912193705)
,p_name=>'APEX.MARKDOWN.INLINE_CODE'
,p_message_text=>'Inline Code'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(695193682071764838)
,p_name=>'APEX.MARKDOWN.INSERT_IMAGE'
,p_message_text=>'Insert Image'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(695193807886768084)
,p_name=>'APEX.MARKDOWN.INSERT_LINK'
,p_message_text=>'Insert Link'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(517489874871860559)
,p_name=>'APEX.MARKDOWN.ITALIC'
,p_message_text=>'Italic'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(698741668249134149)
,p_name=>'APEX.MARKDOWN.LINK'
,p_message_text=>'Link'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(524429136896203593)
,p_name=>'APEX.MARKDOWN.LIST'
,p_message_text=>'List'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(524428981279201843)
,p_name=>'APEX.MARKDOWN.ORDERED_LIST'
,p_message_text=>'Ordered List'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(518671269662928983)
,p_name=>'APEX.MARKDOWN.PREVIEW'
,p_message_text=>'Preview'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(524428069099161600)
,p_name=>'APEX.MARKDOWN.PREVIEW_EMPTY'
,p_message_text=>'Nothing To Preview'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(524428283119180724)
,p_name=>'APEX.MARKDOWN.STRIKETHROUGH'
,p_message_text=>'Strikethrough'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(524428772007199667)
,p_name=>'APEX.MARKDOWN.UNORDERED_LIST'
,p_message_text=>'Unordered List'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382653571976420669)
,p_name=>'APEX.MENU.CURRENT_MENU'
,p_message_text=>'current'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1205049669878717801)
,p_name=>'APEX.MENU.OVERFLOW_LABEL'
,p_message_text=>'More...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382652971617412878)
,p_name=>'APEX.MENU.PROCESSING'
,p_message_text=>'Loading'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(649203826404196144)
,p_name=>'APEX.NOTIFICATION_MESSAGE_HEADING'
,p_message_text=>'Notification Message'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(50065207995395664)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_text=>'Notification message checksum content error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(50064830027392530)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_text=>'Notification message checksum format error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(429302907737212206)
,p_name=>'APEX.NUMBER_FIELD.VALUE_GREATER_MAX_VALUE'
,p_message_text=>'#LABEL# is greater than specified maximum %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(429303300596219604)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID'
,p_message_text=>'#LABEL# must be Numeric.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(429303625530226755)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID2'
,p_message_text=>'#LABEL# does not match number format %0 (Example: %1).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(429302629077208828)
,p_name=>'APEX.NUMBER_FIELD.VALUE_LESS_MIN_VALUE'
,p_message_text=>'#LABEL# is less than specified minimum %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(429302304490201806)
,p_name=>'APEX.NUMBER_FIELD.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_text=>'#LABEL# is not between the valid range of %0 and %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(134759704981991167)
,p_name=>'APEX.PAGE.DUPLICATE_SUBMIT'
,p_message_text=>'This page was already submitted and can not be re-submitted.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88385723652283701)
,p_name=>'APEX.PAGE.NOT_FOUND'
,p_message_text=>'Application "%0" Page "%1" not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(190382422629374195)
,p_name=>'APEX.PAGE_ITEM_IS_REQUIRED'
,p_message_text=>'#LABEL# must have some value.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(727452646001026597)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_text=>'About this Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(727278751559955251)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_text=>'Configuration Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(727289478035981358)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_text=>'Theme Style Selection'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(486969520911851418)
,p_name=>'APEX.POPUP_LOV.BUTTON_CLOSE'
,p_message_text=>'Close'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(486969007405847585)
,p_name=>'APEX.POPUP_LOV.BUTTON_FIND'
,p_message_text=>'Find%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(486972327275862714)
,p_name=>'APEX.POPUP_LOV.BUTTON_NEXT'
,p_message_text=>'Next'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(486970332685854800)
,p_name=>'APEX.POPUP_LOV.BUTTON_PREV'
,p_message_text=>'Previous'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9204033806877837)
,p_name=>'APEX.POPUP_LOV.FILTER_REQ'
,p_message_text=>'Enter a search term of at least %0 characters.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(244202723691302596)
,p_name=>'APEX.POPUP_LOV.ICON_TEXT'
,p_message_text=>'Popup List of Values: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9204281959879931)
,p_name=>'APEX.POPUP_LOV.INITIAL_FILTER_REQ'
,p_message_text=>'Enter a search term.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9203813920873916)
,p_name=>'APEX.POPUP_LOV.NO_RESULTS'
,p_message_text=>'No results found.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9203613993869345)
,p_name=>'APEX.POPUP_LOV.REMOVE_VALUE'
,p_message_text=>'Remove %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(373435905063801717)
,p_name=>'APEX.POPUP_LOV.SEARCH'
,p_message_text=>'Search Term'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(486967716624840718)
,p_name=>'APEX.POPUP_LOV.TITLE'
,p_message_text=>'Search Dialog'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9335300046801064)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_text=>'Unable to get next or previous primary key value.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(362308404356075090)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_text=>'The web service was not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88422025627501910)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_text=>'Error processing process.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(624278081015358229)
,p_name=>'APEX.PROCESSING'
,p_message_text=>'Processing'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19248021403301631)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Application Express could not process the request because of database session resource limitations. Please try again later.',
'<p/>',
'Details about this incident are available via debug id "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(818403400599716783)
,p_name=>'APEX.REGION.CSSCALENDAR.ADD'
,p_message_text=>'Add'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(345023003948195760)
,p_name=>'APEX.REGION.CSSCALENDAR.ALL_DAY'
,p_message_text=>'All Day'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1569876846352725312)
,p_name=>'APEX.REGION.CSSCALENDAR.BUTTON.SENDEMAIL'
,p_message_text=>'Send Invitation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1569423504970171714)
,p_name=>'APEX.REGION.CSSCALENDAR.CHOOSE_ACTION'
,p_message_text=>'Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(360042500367349041)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_ALLDAY'
,p_message_text=>'Daily view for all day '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(360042114182327448)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_TIME_SPECIFIC'
,p_message_text=>'Daily view for data with time '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(651374621292753232)
,p_name=>'APEX.REGION.CSSCALENDAR.DAY'
,p_message_text=>'Day'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(599506184874552378)
,p_name=>'APEX.REGION.CSSCALENDAR.DESCRIPTION'
,p_message_text=>'Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37018413508386693)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.CSV'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37018019762383834)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.ICALENDAR'
,p_message_text=>'iCal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37004327095380425)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.PDF'
,p_message_text=>'PDF'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37018216743385235)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.XML'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37003614814370926)
,p_name=>'APEX.REGION.CSSCALENDAR.ENDDATE'
,p_message_text=>'End Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37004005541375177)
,p_name=>'APEX.REGION.CSSCALENDAR.EVENTNAME'
,p_message_text=>'Event Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1569424429566212197)
,p_name=>'APEX.REGION.CSSCALENDAR.INVITATION'
,p_message_text=>'Invitation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(651374855451755318)
,p_name=>'APEX.REGION.CSSCALENDAR.LIST'
,p_message_text=>'List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(651374213511750760)
,p_name=>'APEX.REGION.CSSCALENDAR.MONTH'
,p_message_text=>'Month'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(697004398931996216)
,p_name=>'APEX.REGION.CSSCALENDAR.NEXT'
,p_message_text=>'Next'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1000695137592203724)
,p_name=>'APEX.REGION.CSSCALENDAR.NOEVENTS'
,p_message_text=>'No Events'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1574931529420889987)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.FORM'
,p_message_text=>'Edit an Existing Event.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1574931332232887139)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.SEND'
,p_message_text=>'Sending an Invitation through Email.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(697004568287997253)
,p_name=>'APEX.REGION.CSSCALENDAR.PREVIOUS'
,p_message_text=>'Previous'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(926875890193286451)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL'
,p_message_text=>'Send Email'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(926696712399934446)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.BUTTON'
,p_message_text=>'Send Email'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1645817708828456765)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.REQUIRED'
,p_message_text=>'All fields are required.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1645817120198443008)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.TITLE'
,p_message_text=>'Send Invitation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1568143073940269291)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.SUBJECT'
,p_message_text=>'Subject'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(926866700832284826)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.TO'
,p_message_text=>'To'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37003810933372668)
,p_name=>'APEX.REGION.CSSCALENDAR.STARTDATE'
,p_message_text=>'Start Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(801476654884688818)
,p_name=>'APEX.REGION.CSSCALENDAR.TABLEFORM'
,p_message_text=>'Form on %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(359998619873896543)
,p_name=>'APEX.REGION.CSSCALENDAR.TIME'
,p_message_text=>'Time'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(697115993157599829)
,p_name=>'APEX.REGION.CSSCALENDAR.TODAY'
,p_message_text=>'Today'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(655714275475588239)
,p_name=>'APEX.REGION.CSSCALENDAR.VIEW'
,p_message_text=>'View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(651374466490752276)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEK'
,p_message_text=>'Week'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(360042327756336304)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_ALLDAY'
,p_message_text=>'Weekly view for all day'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(360041821946323808)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_TIME_SPECIFIC'
,p_message_text=>'Weekly view for data with time'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(652237706323747746)
,p_name=>'APEX.REGION.CSSCALENDAR.YEAR'
,p_message_text=>'Year'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9427814386962148)
,p_name=>'APEX.REGION.FLASH_CHART.INITIALIZING'
,p_message_text=>'Initializing...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(99425201877114408)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_DATA'
,p_message_text=>'Loading data...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(825840403730827256)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_RESOURCES'
,p_message_text=>'Loading resources...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(825843009103866685)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_TEMPLATES'
,p_message_text=>'Loading templates...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9443315902971966)
,p_name=>'APEX.REGION.FLASH_CHART.NO_DATA_FOUND'
,p_message_text=>'No data found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(63364731340343571)
,p_name=>'APEX.REGION.FLASH_CHART.SHOW_XML'
,p_message_text=>'Show XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(99442500417208615)
,p_name=>'APEX.REGION.FLASH_CHART.WAITING'
,p_message_text=>'Loading data. Please wait.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(651383067195893048)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.COLUMNS'
,p_message_text=>'Columns...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(651443111336238570)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.LOAD_MORE'
,p_message_text=>'Load more...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150967610028831199)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.BACK'
,p_message_text=>'Back'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20142519502787493)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.LOAD_MORE'
,p_message_text=>'Load more...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(24030217886277957)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.SEARCH'
,p_message_text=>'Search...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(651443360745240800)
,p_name=>'APEX.REGION.JQM_REFLOW.LOAD_MORE'
,p_message_text=>'Load more...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(695823050339773628)
,p_name=>'APEX.REGION.NOT_FOUND'
,p_message_text=>'Region ID %0 not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22580411792191275)
,p_name=>'APEX.REGION.NO_DATA_FOUND_MESSAGE'
,p_message_text=>'No Data Found'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(90971500041141999)
,p_name=>'APEX.REGION.PAGINATION.RESET_ERROR'
,p_message_text=>'Unable to reset region pagination.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9427009266865989)
,p_name=>'APEX.REGION.PAGINATION.UNHANDLED_ERROR'
,p_message_text=>'Error setting region pagination.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(585083987340530599)
,p_name=>'APEX.REGION.RESPONSIVE_TABLE.COLUMNS'
,p_message_text=>'Columns...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(695822417279753343)
,p_name=>'APEX.REGION.TYPE_NOT_SUPPORTED'
,p_message_text=>'Region Type %0 is not supported.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9426404923751244)
,p_name=>'APEX.REGION.UNHANDLED_ERROR'
,p_message_text=>'Error during rendering of region "#COMPONENT_NAME#".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(190459615244864075)
,p_name=>'APEX.REGION_COLUMN_IS_REQUIRED'
,p_message_text=>'#COLUMN_HEADER# must have some value.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(358729193892838276)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_text=>'Authentication failed for REST Enabled SQL service.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19707705727680031)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_text=>'Authentication failure. List of Values uses a REST Enabled SQL data source that references invalid web credentials, which will prevent you from editing column information for this LOV. Please check authentication credentials. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(681124897300108628)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_text=>'Communication failure. There was a problem invoking the REST Enabled SQL data source referenced by the List of Values, which will prevent you from editing column information for the LOV. Please check the REST Enabled SQL data source is working correc'
||'tly, and also the corresponding authentication credentials are correct.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(381663683965881601)
,p_name=>'APEX.REMOTESQL.OAUTH_IS_RECOMMENDED'
,p_message_text=>'Warning: Oracle recommends the use of OAuth Client Credentials for authentication with REST enabled SQL.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(359290872198939253)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_text=>'Error on Remote Server: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(309252727957636603)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_text=>'Specified ORDS REST Enabled SQL instance not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100611171647129283)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_text=>'Server sent a redirection to: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(218215259070608118)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_text=>'SQL Statement is longer than 32.767 bytes.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(241923994125388733)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hello, Application Express! You are connected as #USER#.',
'The local database timestamp is: #SYSDATE#.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461678196397341941)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_text=>'You are editing the alias for the workspace''s default schema. Setting this alias will also change the Path Prefix at the workspace level. This will affect the URL for any APEX Based RESTful services you may have defined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(229353044543457331)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ORDS'
,p_message_text=>'The current ORDS version does not support the REST Administration interface.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(229353203463464280)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ROLE'
,p_message_text=>'The given client role is not supported by the REST administration interface.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1500071714507300629)
,p_name=>'APEX.RICH_TEXT_EDITOR.ACCESSIBLE_LABEL'
,p_message_text=>'%0, rich text editor'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(212664925798954792)
,p_name=>'APEX.RICH_TEXT_EDITOR.MAXIMUM_LENGTH_EXCEEDED'
,p_message_text=>'The Rich Text HTML markup exceeds the item''s maximum length (actual %0, allowed %1 characters)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(650911878305738762)
,p_name=>'APEX.RV.DELETE'
,p_message_text=>'Delete'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(541341629662273573)
,p_name=>'APEX.RV.DUPLICATE'
,p_message_text=>'Duplicate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(529556005482770942)
,p_name=>'APEX.RV.EXCLUDE_HIDDEN'
,p_message_text=>'Displayed Columns'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(529555737485768353)
,p_name=>'APEX.RV.EXCLUDE_NULL'
,p_message_text=>'Exclude Null Values'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(650912085870741224)
,p_name=>'APEX.RV.INSERT'
,p_message_text=>'Add'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(342221495638312066)
,p_name=>'APEX.RV.MOVE_DOWN'
,p_message_text=>'Move Down'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(342221687713313237)
,p_name=>'APEX.RV.MOVE_UP'
,p_message_text=>'Move Up'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(529555371065764678)
,p_name=>'APEX.RV.NEXT_RECORD'
,p_message_text=>'Next'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(529556869124782266)
,p_name=>'APEX.RV.NOT_GROUPED_LABEL'
,p_message_text=>'Other Columns'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(529555536987766470)
,p_name=>'APEX.RV.PREV_RECORD'
,p_message_text=>'Previous'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(529556218803773081)
,p_name=>'APEX.RV.REC_X'
,p_message_text=>'Row %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(529556405350775357)
,p_name=>'APEX.RV.REC_XY'
,p_message_text=>'Row %0 of %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(541341848855276495)
,p_name=>'APEX.RV.REFRESH'
,p_message_text=>'Refresh'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(541342011477278417)
,p_name=>'APEX.RV.REVERT'
,p_message_text=>'Revert Changes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(529553726356701078)
,p_name=>'APEX.RV.SETTINGS_MENU'
,p_message_text=>'Settings Menu'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279977374567349822)
,p_name=>'APEX.SAMPLE_FORMAT'
,p_message_text=>'For example, %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(212724747305602464)
,p_name=>'APEX.SC.REFERENCES'
,p_message_text=>'%0 references'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461360095208526401)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_text=>'Utilities'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461360200313526418)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_text=>'Navigate to: Application Utilities \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461381863818527075)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_text=>'Go to page'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461381592546527067)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_text=>'Go to Shared Components'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461360571624526427)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_text=>'App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461360866509526435)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_text=>'App Builder Tasks > '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461361163014526444)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_text=>'Application Items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461361437528526452)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Application Items \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461361727720526461)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_text=>'Application Logic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461362051439526469)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_text=>'Authentication Schemes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461362310854526478)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Security Authentication Schemes \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461362578180526486)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_text=>'Authorization Schemes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461362809891526495)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Security Authorization Schemes \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461363190129526503)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_text=>'Breadcrumbs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461363459173526512)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Breadcrumbs \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461363785862526520)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_text=>'Build Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461364079937526529)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Build Options \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461364361400526537)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_text=>'Component Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461364617319526546)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Component Settings \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461364987961526554)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_text=>'Computations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461365210329526562)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Application Computations \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461365559294526571)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_text=>'Create Application Item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461365842706526579)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_text=>'Create Authentication Scheme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461366047952526587)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_text=>'Create Build Option'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461366350794526596)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_text=>'Create Application Computation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461366629942526604)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_text=>'Create Email Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461366932786526613)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_text=>'Create Plug-in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461367200861526621)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_text=>'Create Theme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461367545659526630)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_text=>'Create Web Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461367871873526645)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_text=>'Data Load Definitions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461368118423526660)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Data Load Definitions \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461368431050526671)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_text=>'Data Sources'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461368733741526679)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_text=>'Definition Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461368939897526690)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_text=>'Email Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461369238599526699)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_text=>'Report Layouts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461369549889526707)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Report Layouts \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461369821500526715)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_text=>'Legacy Web Services'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461370179061526724)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Legacy Web Services \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461370420527526732)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_text=>'Navigation Lists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461370710464526741)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Classic Navigation Lists \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461371003867526751)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_text=>'List of Values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461371368501526759)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ List of Values \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461371681971526768)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_text=>'Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461371942600526777)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_text=>'Other Components'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461372139782526785)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_text=>'Plug-ins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461372413791526793)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Plug-ins \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461372749803526802)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_text=>'Processes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461373012959526810)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Application Processes \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461373307855526828)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_text=>'Report Queries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461373622189526836)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Report Queries \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461373988321526845)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_text=>'Reports'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461374204636526853)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_text=>'REST Enabled SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461374524416526862)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ REST Enabled SQL \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461374895502526870)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_text=>'Security'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461375108211526878)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_text=>'Session State Protection'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461375366418526887)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_text=>'Set Application State Protection'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461375638234526895)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_text=>'Shared Components'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461375938330526904)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461376296119526912)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_text=>'Shortcuts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461376550556526921)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Shortcuts \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461376850620526929)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_text=>'Tabs (Legacy)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461377423883526949)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_text=>'Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461377739997526957)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ UI Templates \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461378003791526966)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_text=>'Themes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461378355217526974)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ UI Themes \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461378510250526982)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_text=>'User Interface'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461378880743526991)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_text=>'Web Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461379155251526999)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Security Web Credentials \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461379440989527008)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_text=>'Web Source Modules'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461379751305527016)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_text=>'Navigate to: Shared Components \ Web Source Modules \ %LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461380073505527025)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_text=>'SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461380350406527033)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_text=>'Create Object'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461380609146527042)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_text=>'Create %LIST_ITEM_NAME% in SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461380957058527050)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_text=>'Script Editor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461381245873527059)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_text=>'SQL Workshop Tasks'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(887272622695452483)
,p_name=>'APEX.SESSION.DB_SESSION_CLEANUP.UNHANDLED_ERROR'
,p_message_text=>'Error processing database session cleanup code.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88383307245269544)
,p_name=>'APEX.SESSION.DB_SESSION_INIT.UNHANDLED_ERROR'
,p_message_text=>'Error processing database session setup code.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15060014210037190)
,p_name=>'APEX.SESSION.EXPIRED'
,p_message_text=>'Your session has expired'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(826760907254550246)
,p_name=>'APEX.SESSION.EXPIRED.CLOSE_DIALOG'
,p_message_text=>'Please close this dialog and press your browser''s reload button to obtain a new session.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1398603948573978328)
,p_name=>'APEX.SESSION.EXPIRED.NEW_SESSION'
,p_message_text=>'Click <a href="%0">here</a> to create a new session.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(353629704788111686)
,p_name=>'APEX.SESSION.RAS.NO_DYNAMIC_ROLES'
,p_message_text=>'No Dynamic Roles could be enabled in the Real Application Security session for user "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88290709698797097)
,p_name=>'APEX.SESSION.UNHANDLED_ERROR'
,p_message_text=>'ERR-99900 Could not create unique session ID: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1582027430515961721)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_text=>'Page Item %0 is based on a Database Column but the attribute ''Source Used'' is set to ''Only when current value in session state is null''. This is very dangerous and can result in accidentally overwriting data when viewing and saving multiple records. '
||'Always set ''Source Used'' to ''Always, replacing any existing value in session state''.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(716454763684253965)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_text=>'Access to session state is disabled, attempt to read/write was blocked.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23680232504124313)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_text=>'Attempt to save item %0 in session state during show processing, item has Internal Only protection.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21006331518737908)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_text=>'Attempt to save item %0 in session state during accept processing, item has Internal Only protection or is not a form item that can be POSTed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(116868631324477829)
,p_name=>'APEX.SESSION_STATE.ITEM_VALUE_PROTECTION'
,p_message_text=>'Session state protection violation: This may be caused by manual alteration of protected page item %0. If you are unsure what caused this error, please contact the application administrator for assistance.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2456070606638875009)
,p_name=>'APEX.SESSION_STATE.PAGE_PROTECTION'
,p_message_text=>'Page protection violation: This may be caused by submitting a page that had not yet finished loading or by manual alteration of protected page items. For further assistance, please contact the application administrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2136240830381305650)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR'
,p_message_text=>'%0 contains one of the following invalid characters &<>"/;,*|=% or --'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2136244912504309950)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR_NL'
,p_message_text=>'%0 contains one of the following invalid characters &<>"/;,*|=% or -- or new line.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2136232601291297248)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.US_ONLY'
,p_message_text=>'%0 contains special characters. Only the characters a-Z, 0-9 and spaces are allowed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2136236717222301832)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_text=>'%0 contains <, > or " which are invalid characters.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21004705976711696)
,p_name=>'APEX.SESSION_STATE.SSP_CHECKSUM_MISSING'
,p_message_text=>'No checksum was provided to show processing for a page that requires a checksum when one or more request, clear cache, or argument values are passed as parameters.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109444001725110520)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION'
,p_message_text=>'Session state protection violation: This may be caused by manual alteration of a URL containing a checksum or by using a link with an incorrect or missing checksum. If you are unsure what caused this error, please contact the application administrato'
||'r for assistance.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21005116019714586)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The checksum computed on the request, clear cache, argument names, and argument values (%0) did not match the checksum passed into the show procedure (%1).',
'',
'Note: End users get a different error message.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20999902634644494)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Attempt to save item %0 in session state during show processing. Item protection level indicates:',
'  %1',
'',
'No checksum was passed in or the checksum passed in would be suitable for an item with protection level "%2".',
'',
'Note: End users get a different error message.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88416518916490500)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_text=>'ERR-1022 Unable to save attributes.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(533535725698287445)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_OFF'
,p_message_text=>'Set High Contrast Mode Off'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(533543528468288294)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_ON'
,p_message_text=>'Set High Contrast Mode On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101570118683033179)
,p_name=>'APEX.SHUTTLE.CONTROL_BOTTOM'
,p_message_text=>'Bottom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101571102192037891)
,p_name=>'APEX.SHUTTLE.CONTROL_DOWN'
,p_message_text=>'Down'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101573222717100578)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE'
,p_message_text=>'Move'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101573630682102900)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE_ALL'
,p_message_text=>'Move All'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101574002070104098)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE'
,p_message_text=>'Remove'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101574407611105704)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE_ALL'
,p_message_text=>'Remove All'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101576614846155070)
,p_name=>'APEX.SHUTTLE.CONTROL_RESET'
,p_message_text=>'Reset'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101569303792028866)
,p_name=>'APEX.SHUTTLE.CONTROL_TOP'
,p_message_text=>'Top'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101570627687035778)
,p_name=>'APEX.SHUTTLE.CONTROL_UP'
,p_message_text=>'Up'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045734248439358692)
,p_name=>'APEX.SINCE.SHORT.DAYS_AGO'
,p_message_text=>'%0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045746385590467383)
,p_name=>'APEX.SINCE.SHORT.DAYS_FROM_NOW'
,p_message_text=>'in %0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045734052904357219)
,p_name=>'APEX.SINCE.SHORT.HOURS_AGO'
,p_message_text=>'%0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045746765571468818)
,p_name=>'APEX.SINCE.SHORT.HOURS_FROM_NOW'
,p_message_text=>'in %0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045733323871353098)
,p_name=>'APEX.SINCE.SHORT.MINUTES_AGO'
,p_message_text=>'%0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045746913516470768)
,p_name=>'APEX.SINCE.SHORT.MINUTES_FROM_NOW'
,p_message_text=>'in %0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045734877392363334)
,p_name=>'APEX.SINCE.SHORT.MONTHS_AGO'
,p_message_text=>'%0mo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045745588911464763)
,p_name=>'APEX.SINCE.SHORT.MONTHS_FROM_NOW'
,p_message_text=>'in %0mo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045733780519355712)
,p_name=>'APEX.SINCE.SHORT.SECONDS_AGO'
,p_message_text=>'%0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045745966895466310)
,p_name=>'APEX.SINCE.SHORT.SECONDS_FROM_NOW'
,p_message_text=>'in %0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045734481452359990)
,p_name=>'APEX.SINCE.SHORT.WEEKS_AGO'
,p_message_text=>'%0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045748375858473977)
,p_name=>'APEX.SINCE.SHORT.WEEKS_FROM_NOW'
,p_message_text=>'in %0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045734678363362153)
,p_name=>'APEX.SINCE.SHORT.YEARS_AGO'
,p_message_text=>'%0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1045743539071455675)
,p_name=>'APEX.SINCE.SHORT.YEARS_FROM_NOW'
,p_message_text=>'in %0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(174694807074578792)
,p_name=>'APEX.SPLITTER.COLLAPSE_TEXT'
,p_message_text=>'Collapse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(174694611388576802)
,p_name=>'APEX.SPLITTER.RESTORE_TEXT'
,p_message_text=>'Restore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(460404935420350701)
,p_name=>'APEX.STAR_RATING.CLEAR_RATING'
,p_message_text=>'Clear Rating'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(427336401112555798)
,p_name=>'APEX.STAR_RATING.INVALID_RATING_RANGE'
,p_message_text=>'%0 is not in the valid rating range of 1 - %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(427336654390558060)
,p_name=>'APEX.STAR_RATING.IS_NOT_NUMERIC'
,p_message_text=>'%0 is not numeric'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(394625828679106099)
,p_name=>'APEX.SUCCESS_MESSAGE_HEADING'
,p_message_text=>'Success Message'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(50066027734401392)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_text=>'Success message checksum content error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(50065620116399137)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_text=>'Success message checksum format error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1498100561382375898)
,p_name=>'APEX.TABS.NEXT'
,p_message_text=>'Next'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1498100320440373991)
,p_name=>'APEX.TABS.PREVIOUS'
,p_message_text=>'Previous'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5994227411936586)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_text=>'Error computing default value for column #COMPONENT_NAME#.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6224418492659112)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_text=>'Error processing Multi Row Delete process.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106583016405934090)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_text=>'Checksum column ("FCS") is required and was not supplied'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106584209264941524)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_text=>'No primary key values were supplied, at least one row must be supplied for updates to occur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106613731493127723)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_text=>'No secondary values were supplied for the identified secondary key column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143444531694195363)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_text=>'no data found in tabular form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106582623201926606)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_text=>'Primary key column was not specified'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106611710368121624)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_text=>'Secondary key column identified was not located in the select list of the query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106581428957918814)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_text=>'Table Name was not specified'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106580518568915814)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_text=>'Table Owner was not specified'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112132616702429999)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_text=>'Error processing Multi Row Update process.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1007087409724471246)
,p_name=>'APEX.TB.TOOLBAR'
,p_message_text=>'Toolbar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60730423486143159)
,p_name=>'APEX.TEAM.COMMITTED'
,p_message_text=>'Committed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60730073372141437)
,p_name=>'APEX.TEAM.CONTRIBUTOR'
,p_message_text=>'Contributor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60998224583785943)
,p_name=>'APEX.TEAM.CREATE'
,p_message_text=>'Feature %0 added.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60998478580787369)
,p_name=>'APEX.TEAM.DELETE'
,p_message_text=>'Feature %0 deleted.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2107920673071294)
,p_name=>'APEX.TEAM.DEPRECATED'
,p_message_text=>'APEX Team Development has been deprecated as of version 19.2 and will be removed from a future release. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60730646205144133)
,p_name=>'APEX.TEAM.ESTIMATED_EFFORT'
,p_message_text=>'Estimated Effort'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60731274945146661)
,p_name=>'APEX.TEAM.FEATURE_DESCRIPTION'
,p_message_text=>'Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60729695830139604)
,p_name=>'APEX.TEAM.FEATURE_NAME'
,p_message_text=>'Feature'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60730800171145046)
,p_name=>'APEX.TEAM.FEATURE_STATUS'
,p_message_text=>'Feature Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60731057139145783)
,p_name=>'APEX.TEAM.MILESTONE'
,p_message_text=>'Milestone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60732569436233425)
,p_name=>'APEX.TEAM.NO'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60729861656140583)
,p_name=>'APEX.TEAM.OWNER'
,p_message_text=>'Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60730209571142314)
,p_name=>'APEX.TEAM.RELEASE'
,p_message_text=>'Release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60722090064533702)
,p_name=>'APEX.TEAM.SAVE'
,p_message_text=>'Feature %0 updated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60732335106232502)
,p_name=>'APEX.TEAM.YES'
,p_message_text=>'Yes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1532550110018432833)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_NAV_LABEL'
,p_message_text=>'Expand / Collapse Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1532550374224434636)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_SIDE_COL_LABEL'
,p_message_text=>'Expand / Collapse Side Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15456502223871318)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_text=>'Can not copy theme "%0" in application "%1".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1429533317665073149)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The imported theme is not compatible with the current theme.',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(968205231756292138)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_text=>'Theme number is invalid or theme is not a current UI theme.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197738016063719)
,p_name=>'APEX.TIME.DAY'
,p_message_text=>'1 day'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197359319061779)
,p_name=>'APEX.TIME.HOUR'
,p_message_text=>'1 hour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197934911064704)
,p_name=>'APEX.TIME.N_DAYS'
,p_message_text=>'%0 days'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197580470062743)
,p_name=>'APEX.TIME.N_HOURS'
,p_message_text=>'%0 hours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276197190830059485)
,p_name=>'APEX.TIME.N_MINUTES'
,p_message_text=>'%0 minutes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276198677296066812)
,p_name=>'APEX.TIME.N_WEEKS'
,p_message_text=>'%0 weeks'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276198107718065621)
,p_name=>'APEX.TIME.WEEK'
,p_message_text=>'1 week'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(715870652181741385)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_text=>'Primary Key and Parent Key Columns required to compute hierarchy.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(715870894672745390)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_text=>'Node Level and Node Status Columns required when hierarchy is not computed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1922632899732860545)
,p_name=>'APEX.UI.BACK_TO_TOP'
,p_message_text=>'Start of page'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(72345618085017415)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_text=>'Dark Mode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(72346399126023116)
,p_name=>'APEX.UI.DISABLED'
,p_message_text=>'Disabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(72346184187022435)
,p_name=>'APEX.UI.ENABLED'
,p_message_text=>'Enabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270258602496592818)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.DESCRIPTION'
,p_message_text=>'Please select a user interface from the list below:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(271520124489506317)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.TITLE'
,p_message_text=>'%0 - User Interface Selection'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6139627949062416)
,p_name=>'APEX.UNHANDLED_ERROR'
,p_message_text=>'Error processing request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(48282408156372544)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_text=>'Unauthorized access (security group package variable not set).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(48286710328429891)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_text=>'Cannot fetch find user information. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(43150918940160201)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_text=>'User %0 requires ADMIN privilege to perform this operation.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(48286117469422535)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_text=>'User %0 has not supplied an e-mail address.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(38396719225016778)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_text=>'Unauthorized access.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(48285131190417009)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_text=>'User %0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88419200693494703)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_text=>'Error processing validation.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280295659358440925)
,p_name=>'APEX.VALUE_REQUIRED'
,p_message_text=>'Value Required'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1622814592863002092)
,p_name=>'APEX.WAIT_UNTIL_PAGE_LOADED'
,p_message_text=>'Please wait until the page is fully loaded and try again.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(582353484005936597)
,p_name=>'APEX.WARN_ON_UNSAVED_CHANGES'
,p_message_text=>'This page has unsaved changes.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(718365479485605501)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_text=>'Application Express cannot compute a data profile from the response data of type: %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(328258143932001598)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_text=>'Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(328257912987000826)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_text=>'Row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(658173211885075774)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_text=>'Filter expression is not valid JSON.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(644535835248888446)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_text=>'Filter is not supported by Oracle REST Data Services.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(241852096464137932)
,p_name=>'APEX.WEBSRC.HIDE_COLUMNS'
,p_message_text=>'Hide Selected Columns'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(310129990065948603)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_text=>'HTTP 200: Success'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(310130179567949413)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_text=>'HTTP 201: Created'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(310128919460940749)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_text=>'HTTP 400: Bad request'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(310128547530938849)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_text=>'HTTP 401: Unauthorized'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(310129108827942513)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_text=>'HTTP 403: Forbidden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(310128736779939806)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_text=>'HTTP 404: Not found'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(310129360298943614)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_text=>'HTTP 405: Method not allowed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2033978997579515)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_text=>'HTTP 407: Proxy Authentication required'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2035038201600950)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_text=>'HTTP 409: Conflict'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2034494541587302)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_text=>'HTTP 412: Precondition failed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2034839697594944)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_text=>'HTTP 428: Precondition Required'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(310129593388944751)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_text=>'HTTP 500: Internal Server Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(310129705571947828)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_text=>'HTTP 502: Bad Gateway'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(719239318137040446)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_text=>'HTTP 503: Service Unavailable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(719239519188043065)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_text=>'HTTP 504: Gateway Timeout'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(580953514844599291)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_text=>'Web Source returned an HTTP error: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(309252214290620546)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_text=>'Web source module not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86184817819805672)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_text=>'Row Selector "%0" did not select an array of objects to be treated as a Table.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86185855899815153)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_text=>'Row Selector "%0" did not select an object to be treated as a Single Row.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(580953317951585160)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_text=>'Required Web Source IN parameter "%0" of type "%1" must have a value.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(538482188904946926)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_text=>'The response body is too large to display.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(241852836899152391)
,p_name=>'APEX.WEBSRC.SHOW_COLUMNS'
,p_message_text=>'Show Selected Columns'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280176385690444441)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_text=>'Legacy ORDS REST service uses a small Fixed Page Size.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(242132451615743610)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_text=>'Timeout exceeded when fetching all web source data.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(206935809388034186)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_text=>'The current local SQL filters require too many "Next Page" requests to the REST service.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(280176141272441818)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_text=>'Fixed Page Size for Legacy ORDS REST Service is unknown.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(873307975274722518)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_text=>'Interactive Grid Column ''%0'' specified for Dynamic Action ''#COMPONENT_NAME#'' does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(879103136883340544)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_text=>'Process ''%0'' raised ''%1'' while performing row locking. This error can occur when the process issues a SELECT FOR UPDATE on a complex view with an instead-of trigger, to lock the row. Set the process attribute ''Lock Row'' to No or PL/SQL Code.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(879102909220329261)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_text=>'Process ''%0'' raised ''%1'' while executing a DML command. This error can occur if a column is based on an aggregation or SQL expression. Set column attribute ''Query Only'' to Yes to exclude the column from the INSERT and UPDATE statement.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(497340504568985648)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_text=>'The master detail column ''%0'' does not contain a value. Please make sure that the process ''%1'' is executed after the corresponding process of the master region.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(727791972487724320)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_text=>'Interactive Grid ''%0'' doesn''t have a master column defined which is required for a master detail relationship.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(268382530378995588)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_text=>'Interactive Grid ''%0'' doesn''t have a primary key column defined which is required for editing or in a master detail relationship.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(651045564097108671)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_text=>'For an Editable Interactive Grid, the Page attribute ''Reload on Submit'' must be set to ''Only for Success''.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(651047747543155674)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_text=>'For a Tabular Form, the Page attribute ''Reload on Submit'' must be set to ''Always''.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67560903880357065)
,p_name=>'APEXIR_3D'
,p_message_text=>'3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795705001803519569)
,p_name=>'APEXIR_ACTIONS'
,p_message_text=>'Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141731413888941765)
,p_name=>'APEXIR_ACTIONS_MENU'
,p_message_text=>'Actions Menu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112052218889463208)
,p_name=>'APEXIR_ADD'
,p_message_text=>'Add'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135797704135807871)
,p_name=>'APEXIR_ADD_FUNCTION'
,p_message_text=>'Add Function'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135797527427797009)
,p_name=>'APEXIR_ADD_GROUP_BY_COLUMN'
,p_message_text=>'Add Group By Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(360321018056844688)
,p_name=>'APEXIR_ADD_PIVOT_COLUMN'
,p_message_text=>'Add Pivot Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(360321212018847479)
,p_name=>'APEXIR_ADD_ROW_COLUMN'
,p_message_text=>'Add Row Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(444781311433192374)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_text=>'Add Subscription'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67562016132370060)
,p_name=>'APEXIR_AGGREGATE'
,p_message_text=>'Aggregate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147600119386132087)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_text=>'Aggregates are displayed after each control break and at the end of the report.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148143217203749212)
,p_name=>'APEXIR_AGGREGATION'
,p_message_text=>'Aggregation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112077414311906522)
,p_name=>'APEXIR_AGG_AVG'
,p_message_text=>'Average'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114930610294251134)
,p_name=>'APEXIR_AGG_COUNT'
,p_message_text=>'Count'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(121294162436905517)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_text=>'Count Distinct'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112077817774907486)
,p_name=>'APEXIR_AGG_MAX'
,p_message_text=>'Maximum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112078623662909240)
,p_name=>'APEXIR_AGG_MEDIAN'
,p_message_text=>'Median'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112078220891908448)
,p_name=>'APEXIR_AGG_MIN'
,p_message_text=>'Minimum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112079230934911338)
,p_name=>'APEXIR_AGG_MODE'
,p_message_text=>'Mode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112077010502905437)
,p_name=>'APEXIR_AGG_SUM'
,p_message_text=>'Sum %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112698631876372047)
,p_name=>'APEXIR_ALL'
,p_message_text=>'All'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67384418248556324)
,p_name=>'APEXIR_ALL_COLUMNS'
,p_message_text=>'All Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(17314500293251221)
,p_name=>'APEXIR_ALL_ROWS'
,p_message_text=>'All Rows'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791237420010196773)
,p_name=>'APEXIR_ALTERNATIVE'
,p_message_text=>'Alternative'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791248906223372577)
,p_name=>'APEXIR_ALTERNATIVE_DEFAULT_NAME'
,p_message_text=>'Alternative Default:  %0 '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(96129531770428410)
,p_name=>'APEXIR_AND'
,p_message_text=>'and'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(73414320431887353)
,p_name=>'APEXIR_APPLY'
,p_message_text=>'Apply'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(644585214705381401)
,p_name=>'APEXIR_AREA'
,p_message_text=>'Area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56121529817331496)
,p_name=>'APEXIR_ASCENDING'
,p_message_text=>'Ascending'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103942030470234494)
,p_name=>'APEXIR_AS_OF'
,p_message_text=>'As of %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795668617789278258)
,p_name=>'APEXIR_AVERAGE_X'
,p_message_text=>'Average %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(644585085686380031)
,p_name=>'APEXIR_BAR'
,p_message_text=>'Bar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(71283707575987937)
,p_name=>'APEXIR_BETWEEN'
,p_message_text=>'between'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55205511867680078)
,p_name=>'APEXIR_BGCOLOR'
,p_message_text=>'Background Color'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(439756463016811486)
,p_name=>'APEXIR_BLACK'
,p_message_text=>'Black'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56653623769210273)
,p_name=>'APEXIR_BLUE'
,p_message_text=>'blue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137173229164988337)
,p_name=>'APEXIR_BOTTOM'
,p_message_text=>'Bottom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112498219214129041)
,p_name=>'APEXIR_CALENDAR'
,p_message_text=>'Calendar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56829327541258698)
,p_name=>'APEXIR_CANCEL'
,p_message_text=>'Cancel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78487518065976490)
,p_name=>'APEXIR_CATEGORY'
,p_message_text=>'Category'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55204220740673262)
,p_name=>'APEXIR_CELL'
,p_message_text=>'Cell'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112497432589123502)
,p_name=>'APEXIR_CHART'
,p_message_text=>'Chart'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138675402851573624)
,p_name=>'APEXIR_CHART_INITIALIZING'
,p_message_text=>'Initializing...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(380016024248158072)
,p_name=>'APEXIR_CHART_LABEL_NOT_NULL'
,p_message_text=>'Chart label must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(432429528710620298)
,p_name=>'APEXIR_CHART_MAX_DATAPOINT_CNT'
,p_message_text=>'Your query exceeds the maximum of %0 data points per chart. Please apply a filter to reduce the number of records in your base query.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(411139011605572408)
,p_name=>'APEXIR_CHART_MAX_ROW_CNT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The maximum row count for a Chart query limits the number of rows in the base query, not the number of rows displayed.  ',
'Your base query exceeds the maximum row count of %0.  Please apply a filter to reduce the number of records in your base query.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67558422880334096)
,p_name=>'APEXIR_CHART_TYPE'
,p_message_text=>'Chart Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(397266617361688313)
,p_name=>'APEXIR_CHECK_ALL'
,p_message_text=>'Check All'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103946910047304286)
,p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT'
,p_message_text=>'Choose report download format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(124740303006801945)
,p_name=>'APEXIR_CLEAR'
,p_message_text=>'clear'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56667712650254418)
,p_name=>'APEXIR_COLUMN'
,p_message_text=>'Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147609619180217166)
,p_name=>'APEXIR_COLUMNS'
,p_message_text=>'Columns'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(688293662229697220)
,p_name=>'APEXIR_COLUMN_FILTER'
,p_message_text=>'Filter...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(136484730494817722)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_text=>'Column Heading'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131720526938972055)
,p_name=>'APEXIR_COLUMN_HEADING_MENU'
,p_message_text=>'Column Heading Menu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138531104817366040)
,p_name=>'APEXIR_COLUMN_INFO'
,p_message_text=>'Column Information'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(724036399175708813)
,p_name=>'APEXIR_COLUMN_LABEL'
,p_message_text=>'Column Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135909207785744989)
,p_name=>'APEXIR_COLUMN_N'
,p_message_text=>'Column %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(91841703439014435)
,p_name=>'APEXIR_COMPARISON_CONTAINS'
,p_message_text=>'contains'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(95711715731115353)
,p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN'
,p_message_text=>'does not contain'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55347016369031442)
,p_name=>'APEXIR_COMPARISON_IN'
,p_message_text=>'in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(95716705735140886)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST'
,p_message_text=>'is not in the last'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(113972807669134977)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT'
,p_message_text=>'is not in the next'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(95715014261133828)
,p_name=>'APEXIR_COMPARISON_IS_IN_LAST'
,p_message_text=>'is in the last'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(113970531433132368)
,p_name=>'APEXIR_COMPARISON_IS_IN_NEXT'
,p_message_text=>'is in the next'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55319901038970318)
,p_name=>'APEXIR_COMPARISON_IS_NOT_NULL'
,p_message_text=>'is not null'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55318611989964021)
,p_name=>'APEXIR_COMPARISON_IS_NULL'
,p_message_text=>'is null'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55315230774950512)
,p_name=>'APEXIR_COMPARISON_LIKE'
,p_message_text=>'like'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55575725934374869)
,p_name=>'APEXIR_COMPARISON_NOT_IN'
,p_message_text=>'not in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55316921208957189)
,p_name=>'APEXIR_COMPARISON_NOT_LIKE'
,p_message_text=>'not like'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(91881922486369978)
,p_name=>'APEXIR_COMPARISON_REGEXP_LIKE'
,p_message_text=>'matches regular expression'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103944510909266740)
,p_name=>'APEXIR_COMPUTATION'
,p_message_text=>'Computation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(407340830400934392)
,p_name=>'APEXIR_COMPUTATION_EXPRESSION'
,p_message_text=>'Computation Expression'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147625329962248695)
,p_name=>'APEXIR_COMPUTATION_FOOTER'
,p_message_text=>'Create a computation using column aliases.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147625911393252712)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E1'
,p_message_text=>'(B+C)*100'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147627415333263379)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E2'
,p_message_text=>'INITCAP(B)||'', ''||INITCAP(C)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147627925722266395)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E3'
,p_message_text=>'CASE WHEN A = 10 THEN B + C ELSE B END'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12945676389178553)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E4'
,p_message_text=>'ROUND(C / 1000000)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112839504460310212)
,p_name=>'APEXIR_COMPUTE'
,p_message_text=>'Compute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137094928706780072)
,p_name=>'APEXIR_CONTROL_BREAK'
,p_message_text=>'Control Break'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141663824034727161)
,p_name=>'APEXIR_CONTROL_BREAKS'
,p_message_text=>'Control Breaks'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(836480851356913087)
,p_name=>'APEXIR_CONTROL_BREAK_COLUMNS'
,p_message_text=>'Control Break Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9842503745744521)
,p_name=>'APEXIR_COUNT_DISTINCT'
,p_message_text=>'Count Distinct'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795670828787300321)
,p_name=>'APEXIR_COUNT_DISTINCT_X'
,p_message_text=>'Count Distinct'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795670015627296574)
,p_name=>'APEXIR_COUNT_X'
,p_message_text=>'Count %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(441141115610879450)
,p_name=>'APEXIR_DAILY'
,p_message_text=>'Daily'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1855588807632561795)
,p_name=>'APEXIR_DATA'
,p_message_text=>'Data'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138565924481466401)
,p_name=>'APEXIR_DATA_AS_OF'
,p_message_text=>'Report data as of %0 minutes ago.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(631086406001611601)
,p_name=>'APEXIR_DATA_GRID_HELP'
,p_message_text=>'Data Grid Help'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67616027671281542)
,p_name=>'APEXIR_DATE'
,p_message_text=>'Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791245704267305762)
,p_name=>'APEXIR_DAY'
,p_message_text=>'Day'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147215606978132301)
,p_name=>'APEXIR_DEFAULT'
,p_message_text=>'Default'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791236602218182194)
,p_name=>'APEXIR_DEFAULT_REPORT_TYPE'
,p_message_text=>'Default Report Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56831711873273118)
,p_name=>'APEXIR_DELETE'
,p_message_text=>'Delete'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(113562124088824615)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_text=>'Delete Checked'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(68506219426846545)
,p_name=>'APEXIR_DELETE_CONFIRM'
,p_message_text=>'Would you like to delete these report settings?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147696903858581672)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_text=>'Would you like to perform this delete action?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(534017127084331885)
,p_name=>'APEXIR_DELETE_DEFAULT_REPORT'
,p_message_text=>'Delete Default Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137089323118750054)
,p_name=>'APEXIR_DELETE_REPORT'
,p_message_text=>'Delete Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56122013325336209)
,p_name=>'APEXIR_DESCENDING'
,p_message_text=>'Descending'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78495212617031609)
,p_name=>'APEXIR_DESCRIPTION'
,p_message_text=>'Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131719030139954075)
,p_name=>'APEXIR_DETAIL_VIEW'
,p_message_text=>'Single Row View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147508921015650072)
,p_name=>'APEXIR_DIRECTION'
,p_message_text=>'Direction %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141701322705830797)
,p_name=>'APEXIR_DISABLE'
,p_message_text=>'Disable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147598108042109835)
,p_name=>'APEXIR_DISABLED'
,p_message_text=>'Disabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67616512564286660)
,p_name=>'APEXIR_DISPLAY'
,p_message_text=>'Display'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56656312734235446)
,p_name=>'APEXIR_DISPLAYED'
,p_message_text=>'Displayed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67383828160549754)
,p_name=>'APEXIR_DISPLAYED_COLUMNS'
,p_message_text=>'Displayed Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147473130207416178)
,p_name=>'APEXIR_DISPLAY_IN_REPORT'
,p_message_text=>'Display in Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(57099547077721312)
,p_name=>'APEXIR_DONUT'
,p_message_text=>'Donut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137171815312984248)
,p_name=>'APEXIR_DOWN'
,p_message_text=>'Down'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112840532296327706)
,p_name=>'APEXIR_DOWNLOAD'
,p_message_text=>'Download'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67562512107378287)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_text=>'- Do not aggregate -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147472712199410983)
,p_name=>'APEXIR_DO_NOT_DISPLAY'
,p_message_text=>'Do Not Display'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(850282539889136958)
,p_name=>'APEXIR_DUPLICATE_PIVOT_COLUMN'
,p_message_text=>'Duplicate pivot column.  Pivot column list must be unique.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(852087009386397624)
,p_name=>'APEXIR_EDIT'
,p_message_text=>'Edit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623927411493897229)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_text=>'Edit Alternative Default'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138788511555954552)
,p_name=>'APEXIR_EDIT_CHART'
,p_message_text=>'Edit Chart Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147671805140449609)
,p_name=>'APEXIR_EDIT_CHART2'
,p_message_text=>'Edit Chart'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147803330766807110)
,p_name=>'APEXIR_EDIT_FILTER'
,p_message_text=>'Edit Filter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484937605504507045)
,p_name=>'APEXIR_EDIT_GROUP_BY'
,p_message_text=>'Edit Group By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147802024533805297)
,p_name=>'APEXIR_EDIT_HIGHLIGHT'
,p_message_text=>'Edit Highlight'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361755122312729691)
,p_name=>'APEXIR_EDIT_PIVOT'
,p_message_text=>'Edit Pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791237921527206757)
,p_name=>'APEXIR_EMAIL'
,p_message_text=>'Email'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(34366324184386201)
,p_name=>'APEXIR_EMAIL_ADDRESS'
,p_message_text=>'Email Address'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791238708283221847)
,p_name=>'APEXIR_EMAIL_BCC'
,p_message_text=>'Bcc'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791239302873229745)
,p_name=>'APEXIR_EMAIL_BODY'
,p_message_text=>'Body'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791238427545217901)
,p_name=>'APEXIR_EMAIL_CC'
,p_message_text=>'Cc'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791244410108279062)
,p_name=>'APEXIR_EMAIL_FREQUENCY'
,p_message_text=>'Frequency'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(42642130221073470)
,p_name=>'APEXIR_EMAIL_NOT_CONFIGURED'
,p_message_text=>'Email has not been configured for this application.  Please contact your administrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(439500612737168830)
,p_name=>'APEXIR_EMAIL_REQUIRED'
,p_message_text=>'Email Address must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791239620188234715)
,p_name=>'APEXIR_EMAIL_SEE_ATTACHED'
,p_message_text=>'See attached'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791239021789225748)
,p_name=>'APEXIR_EMAIL_SUBJECT'
,p_message_text=>'Subject'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(441505032219375986)
,p_name=>'APEXIR_EMAIL_SUBJECT_REQUIRED'
,p_message_text=>'Email Subject must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791238217156214942)
,p_name=>'APEXIR_EMAIL_TO'
,p_message_text=>'To'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141700107467826356)
,p_name=>'APEXIR_ENABLE'
,p_message_text=>'Enable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55197630736647713)
,p_name=>'APEXIR_ENABLED'
,p_message_text=>'Enabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147759712581763946)
,p_name=>'APEXIR_ENABLE_DISABLE_ALT'
,p_message_text=>'Enable/Disable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147668709942422626)
,p_name=>'APEXIR_ERROR'
,p_message_text=>'Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147628606460270233)
,p_name=>'APEXIR_EXAMPLES'
,p_message_text=>'Examples'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147673915445471519)
,p_name=>'APEXIR_EXAMPLES_WITH_COLON'
,p_message_text=>'Examples:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67383311884544977)
,p_name=>'APEXIR_EXCLUDE_NULL'
,p_message_text=>'Exclude Null Values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147837614031944113)
,p_name=>'APEXIR_EXPAND_COLLAPSE_ALT'
,p_message_text=>'Expand/Collapse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147592430805059674)
,p_name=>'APEXIR_EXPRESSION'
,p_message_text=>'Expression'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112779026924588204)
,p_name=>'APEXIR_FILTER'
,p_message_text=>'Filter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141662814684724381)
,p_name=>'APEXIR_FILTERS'
,p_message_text=>'Filters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172498722149538385)
,p_name=>'APEXIR_FILTER_EXPRESSION'
,p_message_text=>'Filter Expression'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1555310516211929341)
,p_name=>'APEXIR_FILTER_EXPR_TOO_LONG'
,p_message_text=>'The filter expression is too long.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172477830835417956)
,p_name=>'APEXIR_FILTER_TYPE'
,p_message_text=>'Filter Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148054918926324007)
,p_name=>'APEXIR_FINDER_ALT'
,p_message_text=>'Select columns to search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112831300258280667)
,p_name=>'APEXIR_FLASHBACK'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147531823804802269)
,p_name=>'APEXIR_FLASHBACK_DESCRIPTION'
,p_message_text=>'A flashback query allows you to view the data as it existed at a previous point in time.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147667208426412771)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_text=>'Unable to perform flashback request'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(439756861331812874)
,p_name=>'APEXIR_FLASHBACK_LABEL'
,p_message_text=>'Flashback Duration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455229109465327136)
,p_name=>'APEXIR_FORMAT'
,p_message_text=>'Format'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103943829132262564)
,p_name=>'APEXIR_FORMAT_MASK'
,p_message_text=>'Format Mask %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(136488513010850442)
,p_name=>'APEXIR_FUNCTION'
,p_message_text=>'Function'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147617626237228665)
,p_name=>'APEXIR_FUNCTIONS'
,p_message_text=>'Functions %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791076506262625152)
,p_name=>'APEXIR_FUNCTIONS_OPERATORS'
,p_message_text=>'Functions / Operators'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(411213431260597045)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_text=>'Function Column %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135908803700731673)
,p_name=>'APEXIR_FUNCTION_N'
,p_message_text=>'Function %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112701330622381179)
,p_name=>'APEXIR_GO'
,p_message_text=>'Go'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(439756626969811971)
,p_name=>'APEXIR_GRAY'
,p_message_text=>'Gray'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55207521349692280)
,p_name=>'APEXIR_GREEN'
,p_message_text=>'green'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9860005822095226)
,p_name=>'APEXIR_GROUP_BY'
,p_message_text=>'Group By'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791239903696239401)
,p_name=>'APEXIR_GROUP_BY_COLUMN'
,p_message_text=>'Group By Column %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(380017487297195724)
,p_name=>'APEXIR_GROUP_BY_COL_NOT_NULL'
,p_message_text=>'Group by column must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(410973308525524174)
,p_name=>'APEXIR_GROUP_BY_MAX_ROW_CNT'
,p_message_text=>'The maximum row count for a Group By query limits the number of rows in the base query, not the number of rows displayed.  Your base query exceeds the maximum row count of %0.  Please apply a filter to reduce the number of records in your base query.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(313673121169388128)
,p_name=>'APEXIR_GROUP_BY_SORT'
,p_message_text=>'Group By Sort'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(836481613371929256)
,p_name=>'APEXIR_GROUP_BY_SORT_ORDER'
,p_message_text=>'Group By Sort Order'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67558910890340090)
,p_name=>'APEXIR_HCOLUMN'
,p_message_text=>'Horizontal Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146210524183462011)
,p_name=>'APEXIR_HELP'
,p_message_text=>'Help'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(130964403262088439)
,p_name=>'APEXIR_HELP_01'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Interactive reports enable end users to customize reports. Users can alter the layout of report data by selecting columns, applying filters, highlighting, and sorting. Users can also define breaks, aggregations, charts, group bys, and add their own c'
||'omputations. Users can also set up a subscription so that an HTML version of the report will be emailed to them at a designated interval. Users can create multiple variations of a report and save them as named reports, for either public or private vi'
||'ewing. ',
'<p/>',
'The sections that follow summarize ways you can customize an interactive report. To learn more, see "Using Interactive Reports" in <i>Oracle Application Express End User''s Guide</i></a>.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141734006054949019)
,p_name=>'APEXIR_HELP_ACTIONS_MENU'
,p_message_text=>'The Actions menu appears to the right of the Go button on the Search bar. Use this menu to customize an interactive report.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131696001255860548)
,p_name=>'APEXIR_HELP_AGGREGATE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Aggregates are mathematical computations performed against a column. Aggregates display after each control break and at the end of the report within the column they are defined. Options include:',
'<p>',
'</p><ul>',
'<li><b>Aggregation</b> enables you to select a previously',
'defined aggregation to edit.</li>',
'<li><b>Function</b> is the function to be performed (for example, SUM, MIN).</li>',
'<li><b>Column</b> is used to select the column to apply the mathematical function to. Only numeric',
'columns display.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131698818571865576)
,p_name=>'APEXIR_HELP_CHART'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'You can define one chart per saved report. Once',
'defined, you can switch between the chart and report views using view icons the Search bar.',
'Options include:  ',
'<p>',
'</p><ul>',
'<li><b>Chart Type</b> identifies the chart type to include.',
'Select from horizontal bar, vertical bar, pie, or line.</li>',
'<li><b>Label</b> enables you to select the column to be used as the label.</li>',
'<li><b>Axis Title for Label</b> is the title that displays on the axis associated with the column selected for',
'Label. This is not available for pie chart.</li>',
'<li><b>Value</b> enables you to select the column to be used as the value.  If your function',
'is a COUNT, a Value does not need to be selected.</li>',
'<li><b>Axis Title for Value</b> is the title that displays on the axis associated with the column selected for',
'Value. This is not available for pie chart.</li>',
'<li><b>Function</b> is an optional function to be performed on the column selected for Value.</li>',
'<li><b>Sort</b> allows you to sort your result set.</li></ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131687815491817393)
,p_name=>'APEXIR_HELP_COLUMN_HEADING_MENU'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Clicking on any column heading exposes a column heading menu.Options include:',
'<p></p>',
'<ul>',
'<li><b>Sort Ascending</b> icon sorts the report by the column in ascending order.</li>',
'<li><b>Sort Descending</b> icon sorts the report by the column in descending order.</li>',
'<li><b>Hide Column</b> hides the column.  Not all columns can be hidden.  If a column cannot be hidden, there will be no Hide Column icon.</li>',
'<li><b>Break Column</b> creates a break group on the column.  This pulls the column out of the report as a master record.</li>',
'<li><b>Column Information</b> displays help text about the column, if available.</li>',
'<li><b>Text Area</b> is used to enter case insensitive search criteria',
'(no need for wild cards). Entering a value  reduces the list of',
'values at the bottom of the menu. You can then select a value from the',
'bottom and the selected value will be created as a filter using ''=''',
'(for example, <code>column = ''ABC''</code>). Alternatively, you can click the Flashlight icon and enter a value to be created as a filter with the ''LIKE''',
'modifier (for example, <code>column LIKE ''%ABC%''</code>).</li>',
'<li><b>List of Unique Values</b> contains the first 500 unique',
'values that meets your filter criteria. If the column is a date, a list of date',
'ranges is displayed instead. If you select a value, a filter will be',
'created using ''='' (for example, <code>column = ''ABC''</code>).</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131695520864856747)
,p_name=>'APEXIR_HELP_COMPUTE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enables you to add computed columns to your report. These can be mathematical computations (for example, <code>NBR_HOURS/24</code>) or standard Oracle',
'functions applied to existing columns. Some display as examples and others (such as <code>TO_DATE)</code> can also be used). Options include:',
'<p></p>',
'<ul>',
'<li><b>Computation</b> enables you to select a previously defined computation to edit.</li>',
'<li><b>Column Heading</b> is the column heading for the new column.</li>',
'<li><b>Format Mask</b> is an Oracle format mask to be applied against the column (for example,S9999).</li>',
'<li><b>Computation</b> is the computation to be performed. Within the computation, columns are referenced using the aliases displayed.</li>',
'</ul>',
'<p>Below computation, the columns in your query display with',
'their associated alias. Clicking on the column name or alias includes',
'them in the Computation. Next to Columns is a keypad. This keypad functions as',
'a shortcut to commonly used keys. On the far right are Functions.</p>',
'<p>The following  example computation demonstrates how to display total compensation:</p>',
'<pre>CASE WHEN A = ''SALES'' THEN B + C ELSE B END</pre>',
'(where A is ORGANIZATION, B is SALARY and C is COMMISSION)</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141735821638953441)
,p_name=>'APEXIR_HELP_CONTROL_BREAK'
,p_message_text=>'Used to create a break group on one or several columns. This pulls the columns out of the interactive report and displays them as a master record.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131703528183887319)
,p_name=>'APEXIR_HELP_DETAIL_VIEW'
,p_message_text=>'To view the details of a single row at a time, click the single row view icon on the row you wish to view. If available, the single row view will always be the first column. Depending on the customization of the interactive report, the single row vie'
||'w may be the standard view or a custom page that may allow update.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131703106712881081)
,p_name=>'APEXIR_HELP_DOWNLOAD'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enables the current result set to be downloaded. The download formats',
'differ depending upon your installation and report definition but',
'may include CSV, HTML, Email, XLS, PDF, or RTF.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131690618870837323)
,p_name=>'APEXIR_HELP_FILTER'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Focuses the report by adding or modifying the <code>WHERE</code> clause on the query. You can filter on a column or by row.  ',
'<p>If you filter by column, select a column (it does not need to',
'be one that displays), select a standard Oracle operator  (=, !=, not in, between), and enter an expression to compare against. Expressions are case sensitive. Use % as a wild card (for example, <code>STATE_NAME',
'like A%)</code>.</p>',
'<p>If you filter by row, you can create complex <code>WHERE</code> clauses using',
'column aliases and any Oracle functions or operators (for example, <code>G = ''VA'' or G = ''CT''</code>, where',
'<code>G</code> is the alias for <code>CUSTOMER_STATE</code>).</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131699901386870068)
,p_name=>'APEXIR_HELP_FLASHBACK'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'A flashback query enables you to view the data as it existed at a previous point',
'in time. The default amount of time that you can flashback is 3 hours (or 180',
'minutes) but the actual amount will differ for each database.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455228732190324275)
,p_name=>'APEXIR_HELP_FORMAT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Format enable you to customize the display of the report.',
'Format contains the following submenu:</p>',
'<ul><li>Sort</li>',
'<li>Control Break</li>',
'<li>Highlight</li>',
'<li>Compute</li>',
'<li>Aggregate</li>',
'<li>Chart</li>',
'<li>Group By</li>',
'<li>Pivot</li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(439318506271908041)
,p_name=>'APEXIR_HELP_GROUP_BY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'You can define one Group By view per saved',
'report. Once defined, you can switch between the group by and report',
'views using view icons on the Search bar. To create a Group By view,',
'you select:',
'<p></p><ul>',
'<li>the columns on which to group</li>',
'<li>the columns to aggregate along with the function to be performed (average, sum, count, etc.)</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131693416923846207)
,p_name=>'APEXIR_HELP_HIGHLIGHT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enables you to define a filter. The rows that meet the filter criteria display as highlighted using the characteristics associated with the filter. Options include:</p>',
'<ul>',
'<li><b>Name</b> is used only for display.</li>',
'<li><b>Sequence</b> identifies the sequence in which the rules are evaluated.</li>',
'<li><b>Enabled</b> identifies if a rule is enabled or disabled.</li>',
'<li><b>Highlight Type</b> identifies whether the row or cell should be',
'highlighted. If Cell is selected, the column referenced in the',
'Highlight Condition is highlighted.</li>',
'<li><b>Background Color</b> is the new color for the background of the highlighted area.</li>',
'<li><b>Text Color</b> is the new color for the text in the highlighted area.</li>',
'<li><b>Highlight Condition</b>  defines your filter condition.</li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3709080100398)
,p_name=>'APEXIR_HELP_PIVOT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'You can define one Pivot view per saved report. Once defined, you can switch between the pivot and report views using view icons on the Search bar. To create a Pivot view, you select: ',
'<p></p>',
'<ul>',
'<li>the columns on which to pivot</li>',
'<li>the columns to display as rows</li>',
'<li>the columns to aggregate along with the function to be performed (average, sum, count, etc.)</li>',
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147649601621344512)
,p_name=>'APEXIR_HELP_REPORT_SETTINGS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If you customize an interactive report, the report settings display',
'below the Search bar and above the report. This area can be collapsed and expanded using the icon on the left.',
'<p>',
'For each report setting, you can:',
'</p><ul>',
'<li>Edit a setting by clicking the name.</li>',
'<li>Disable/Enable a setting by unchecking or checking the Enable/Disable check box. Use this control to temporarily turn a setting off and on.</li>',
'<li>Remove a setting by clicking the Remove icon.</li>',
'</ul>',
'<p>If you have created a chart, group by or pivot, you can toggle between them',
'and the base report using the Report View, Chart View, Group By View, and Pivot View',
'links shown on the right. If you are viewing the chart, group by or pivot, you',
'can also use the Edit link to edit the settings.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131702530822878558)
,p_name=>'APEXIR_HELP_RESET'
,p_message_text=>'Resets the report back to the default settings, removing any customizations that you have made.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455233524965350564)
,p_name=>'APEXIR_HELP_ROWS_PER_PAGE'
,p_message_text=>'Sets the number of records to display per page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131701118009874893)
,p_name=>'APEXIR_HELP_SAVE_REPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Saves the customized report for future use. You provide a name and optional description and can make the report accessible to the public (that is, all users who can access the primary default report). You can save four types of interactive reports'
||':</p>',
'<ul>',
'<li><strong>Primary Default</strong> (Developer Only). The Primary Default is the report that initially displays. Primary Default reports cannot be renamed or deleted.</li>',
'<li><strong>Alternative Report</strong> (Developer Only). Enables developers to create multiple report layouts. Only developers can save, rename, or delete an Alternative Report.</li>',
'<li><strong>Public Report</strong> (End user). Can be saved, renamed, or deleted by the end user who created it. Other users can view and save the layout as another report.</li>',
'<li><strong>Private Report</strong> (End user). Only the end user that created the report can view, save, rename or delete the report.</li>',
'</ul>',
'<p>If you save customized reports, a Reports selector displays in the Search bar to the left of the Rows selector (if this feature is enabled).</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131667531291812479)
,p_name=>'APEXIR_HELP_SEARCH_BAR'
,p_message_text=>'At the top of each report page is a search region. This region (or Search bar) provides the following features:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455263831890702599)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ACTIONS_MENU'
,p_message_text=>'<li><b>Actions Menu</b> enables you to customize a report. See the sections that follow.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455259726471634782)
,p_name=>'APEXIR_HELP_SEARCH_BAR_FINDER'
,p_message_text=>'<li><b>Select columns icon</b> enables you to identify which column to search (or all).</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455262302885675316)
,p_name=>'APEXIR_HELP_SEARCH_BAR_REPORTS'
,p_message_text=>'<li><b>Reports</b> displays alternate default and saved private or public reports.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455261511758668398)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ROWS'
,p_message_text=>'<li><b>Rows</b> sets the number of records to display per page.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455260708510657991)
,p_name=>'APEXIR_HELP_SEARCH_BAR_TEXTBOX'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li><b>Text area</b> enables you to enter case insensitive search criteria (wild card characters are implied).</li>',
'<li><b>Go button</b> executes the search. Hitting the enter key will also execute the search when the cursor is in the search text area.</li>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455263104186694622)
,p_name=>'APEXIR_HELP_SEARCH_BAR_VIEW'
,p_message_text=>'<li><b>View Icons</b> switches between the icon, report, detail, chart, group by, and pivot views of the report if they are defined.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(631086815959633401)
,p_name=>'APEXIR_HELP_SEARCH_BAR_WS_MANAGE'
,p_message_text=>'<li><b>Manage</b> enables you to manage the properties, columns, rows, and view history for the report or data grid.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131688617354827372)
,p_name=>'APEXIR_HELP_SELECT_COLUMNS'
,p_message_text=>'Used to modify the columns displayed. The columns on the right display. The columns on the left are hidden. You can reorder the displayed columns using the arrows on the far right. Computed columns are prefixed with <b>**</b>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131692103418842252)
,p_name=>'APEXIR_HELP_SORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Used to change the columns to sort on and determines whether',
'to sort in ascending or descending order. You can also specify how to handle',
'<code>NULLs</code>. The default setting always displays <code>NULLs</code> last or always display them first. The resulting sorting displays to the right of',
'column headings in the report.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(437452923093001825)
,p_name=>'APEXIR_HELP_SUBSCRIPTION'
,p_message_text=>'When you add a subscription, you provide an email address (or multiple email addresses, separated by commas), email subject, frequency, and start and end dates. The resulting emails include an HTML version of the interactive report containing the cur'
||'rent data using the report setting that were present when the subscription was added.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(629302027277661484)
,p_name=>'APEXIR_HELP_WS_01'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Data grids are basically editable reports that are highly customizable.  Users can alter the layout of report data by selecting columns, applying filters, highlighting, and sorting. Users can also define breaks, aggregations, charts, group bys, and a'
||'dd their own computations. Users can create multiple variations of a report and save them as named reports, for private viewing. ',
'<p/>',
'A Data grid can be customized using the Search bar, Actions menu, Manage menu or Column Heading menu.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(830220223599380901)
,p_name=>'APEXIR_HELP_WS_ACTIONS_MENU'
,p_message_text=>'The Actions menu appears to the right of the Go button on the Search bar. Use this menu to customize a data grid report.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(631126027312731269)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT'
,p_message_text=>'Add / Edit Row Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(631137825216929352)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT_ROW'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>To add a row to the data grid click Add Row. To edit the details of a row click the edit row icon (first column) on the row you wish to edit. The Add/Edit Row page will be displayed showing the columns of the data grid. </p>',
'',
'<p>When editing a row you can:</p>',
'',
'<p><ul>',
'<li><b>Delete</b> the row.</li>',
'<li><b>Apply Changes</b> to save the changes made to the row.</li>',
'<li>Within <b>Actions</b>, add a row, add files, notes, links, or tags, and review the history.</li>',
'<li>Navigate to the <b>Next and Previous</b> rows.</li>',
'<li>Within <b>Manage</b>, set column properties, column groups, validations and lists of values.</li>',
'</ul></p>',
'',
'<p>The Annotations region at the bottom of the page will display any files, notes, links, or tags that are associated with the current row.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(830553618105407652)
,p_name=>'APEXIR_HELP_WS_CONTROL_BREAK'
,p_message_text=>'Used to create a break group on one or several columns. This pulls the columns out of the data grid and displays them as a master record.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(631121022848682693)
,p_name=>'APEXIR_HELP_WS_DOWNLOAD'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enables the current result set to be downloaded. The download formats',
'include CSV, HTML, or Email.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(830908027848438862)
,p_name=>'APEXIR_HELP_WS_REPORT_SETTINGS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If you customize a data grid report, the report settings display',
'below the Search bar and above the report. This area can be collapsed and expanded using the icon on the left.',
'<p>',
'For each report setting, you can:',
'</p><ul>',
'<li>Edit a setting by clicking the name.</li>',
'<li>Disable/Enable a setting by unchecking or checking the Enable/Disable check box. Use this control to temporarily turn a setting off and on.</li>',
'<li>Remove a setting by clicking the Remove icon.</li>',
'</ul>',
'<p>If you have created a chart or group by, you can toggle between them',
'and the base report using the Report View, Chart View, and Group By View',
'links shown on the right. If you are viewing the chart or group by, you',
'can also use the Edit link to edit the settings.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(631120815445671042)
,p_name=>'APEXIR_HELP_WS_SAVE_REPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Saves the customized data grid report layout for future use. You provide a name and optional description. You can save three types of data grid report layouts:</p>',
'<ul>',
'<li><strong>Primary Default</strong> (Administrator Only). The Primary Default is the layout that initially displays. Primary Default reports cannot be renamed or deleted.</li>',
'<li><strong>Alternative Report</strong> (Administrator Only). Enables administrators to create multiple report layouts. Only administrators can save, rename, or delete an Alternative Report.</li>',
'<li><strong>Private Report</strong> (All users). The user that created the report layout can view, save, rename or delete the report.</li>',
'</ul>',
'<p>If you save customized reports, a Reports selector displays in the Search bar to the left of the Rows selector (if this feature is enabled).</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138526725679353196)
,p_name=>'APEXIR_HIDE_COLUMN'
,p_message_text=>'Hide Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112781308963611447)
,p_name=>'APEXIR_HIGHLIGHT'
,p_message_text=>'Highlight'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141664631999729465)
,p_name=>'APEXIR_HIGHLIGHTS'
,p_message_text=>'Highlights'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147663027641380433)
,p_name=>'APEXIR_HIGHLIGHT_CONDITION'
,p_message_text=>'Highlight Condition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(439756288559810936)
,p_name=>'APEXIR_HIGHLIGHT_STYLE'
,p_message_text=>'Highlight Style'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55201524765664909)
,p_name=>'APEXIR_HIGHLIGHT_TYPE'
,p_message_text=>'Highlight Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55272404660857836)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_text=>'Highlight When'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(644585798428384246)
,p_name=>'APEXIR_HORIZONTAL'
,p_message_text=>'Horizontal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1434157528684349547)
,p_name=>'APEXIR_INACTIVE_SETTING'
,p_message_text=>'1 inactive setting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1434160909460351386)
,p_name=>'APEXIR_INACTIVE_SETTINGS'
,p_message_text=>'%0 inactive settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131723308415004602)
,p_name=>'APEXIR_INTERACTIVE_REPORT_HELP'
,p_message_text=>'Interactive Report Help'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147808904279837268)
,p_name=>'APEXIR_INVALID'
,p_message_text=>'Invalid'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139690204252825678)
,p_name=>'APEXIR_INVALID_COMPUTATION'
,p_message_text=>'Invalid computation expression. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(36983722382078745)
,p_name=>'APEXIR_INVALID_END_DATE'
,p_message_text=>'The end date must be greater than the start date.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(200610302445165579)
,p_name=>'APEXIR_INVALID_FILTER'
,p_message_text=>'Invalid filter expression. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795662420850175011)
,p_name=>'APEXIR_INVALID_FILTER_QUERY'
,p_message_text=>'Invalid filter query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1434161121899354201)
,p_name=>'APEXIR_INVALID_SETTING'
,p_message_text=>'1 invalid setting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1434161384116357458)
,p_name=>'APEXIR_INVALID_SETTINGS'
,p_message_text=>'%0 invalid settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(439757083850813941)
,p_name=>'APEXIR_IN_MINUTES'
,p_message_text=>'(in minutes)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623902023969626495)
,p_name=>'APEXIR_IS_IN_THE_LAST'
,p_message_text=>'%0 is in the last %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623902618213634271)
,p_name=>'APEXIR_IS_IN_THE_NEXT'
,p_message_text=>'%0 is in the next %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623902405746630690)
,p_name=>'APEXIR_IS_NOT_IN_THE_LAST'
,p_message_text=>'%0 is not in the last %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623902800683638663)
,p_name=>'APEXIR_IS_NOT_IN_THE_NEXT'
,p_message_text=>'%0 is not in the next %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147616816887225917)
,p_name=>'APEXIR_KEYPAD'
,p_message_text=>'Keypad'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67561417732360999)
,p_name=>'APEXIR_LABEL'
,p_message_text=>'Label %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137371525551876586)
,p_name=>'APEXIR_LABEL_AXIS_TITLE'
,p_message_text=>'Axis Title for Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(362416425067891251)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_text=>'Label Prefix'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114474904691269411)
,p_name=>'APEXIR_LAST_DAY'
,p_message_text=>'Last Day'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114476515081272362)
,p_name=>'APEXIR_LAST_HOUR'
,p_message_text=>'Last Hour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114472015642263093)
,p_name=>'APEXIR_LAST_MONTH'
,p_message_text=>'Last Month'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114473427763266591)
,p_name=>'APEXIR_LAST_WEEK'
,p_message_text=>'Last Week'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114474432611268023)
,p_name=>'APEXIR_LAST_X_DAYS'
,p_message_text=>'Last %0 Days'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114475410579271098)
,p_name=>'APEXIR_LAST_X_HOURS'
,p_message_text=>'Last %0 Hours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114471107331260713)
,p_name=>'APEXIR_LAST_X_YEARS'
,p_message_text=>'Last %0 Years'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114471711833261987)
,p_name=>'APEXIR_LAST_YEAR'
,p_message_text=>'Last Year'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67560421064352551)
,p_name=>'APEXIR_LINE'
,p_message_text=>'Line'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(57043572533656352)
,p_name=>'APEXIR_LINE_WITH_AREA'
,p_message_text=>'Line with Area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(419523509375811302)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_text=>'Please click <a href=''%0''>here</a> to manage your subscription.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795660918033145841)
,p_name=>'APEXIR_MAP_IT'
,p_message_text=>'Map it'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138834724555071853)
,p_name=>'APEXIR_MAX_QUERY_COST'
,p_message_text=>'The query is estimated to exceed the maximum allowed resources.  Please modify your report settings and try again.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(95467716029550046)
,p_name=>'APEXIR_MAX_ROW_CNT'
,p_message_text=>'The maximum row count for this report is %0 rows.  Please apply a filter to reduce the number of records in your query.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795668910301285509)
,p_name=>'APEXIR_MAX_X'
,p_message_text=>'Maximum %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795669602121292668)
,p_name=>'APEXIR_MEDIAN_X'
,p_message_text=>'Median %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103942907530246790)
,p_name=>'APEXIR_MIN_AGO'
,p_message_text=>'%0 minutes ago'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795669223807289397)
,p_name=>'APEXIR_MIN_X'
,p_message_text=>'Minimum %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791245908423306957)
,p_name=>'APEXIR_MONTH'
,p_message_text=>'Month'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(441141931540884022)
,p_name=>'APEXIR_MONTHLY'
,p_message_text=>'Monthly'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147809928997853860)
,p_name=>'APEXIR_MORE_DATA'
,p_message_text=>'More Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137160608817963523)
,p_name=>'APEXIR_MOVE'
,p_message_text=>'Move'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137158424962958699)
,p_name=>'APEXIR_MOVE_ALL'
,p_message_text=>'Move All'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1814992979737063426)
,p_name=>'APEXIR_MULTIIR_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_text=>'Region Static ID must be specified as the page contains multiple interactive reports.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56650124284172631)
,p_name=>'APEXIR_NAME'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(127136721432879938)
,p_name=>'APEXIR_NEW_AGGREGATION'
,p_message_text=>'New Aggregation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(63857427647172147)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_text=>'- New Category -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1449450948451022801)
,p_name=>'APEXIR_NEW_CATEGORY_LABEL'
,p_message_text=>'New Category'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(127162803012044820)
,p_name=>'APEXIR_NEW_COMPUTATION'
,p_message_text=>'New Computation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112094425805089540)
,p_name=>'APEXIR_NEXT'
,p_message_text=>'Next'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114523712843385305)
,p_name=>'APEXIR_NEXT_DAY'
,p_message_text=>'Next Day'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114522924141379109)
,p_name=>'APEXIR_NEXT_HOUR'
,p_message_text=>'Next Hour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114525726349389122)
,p_name=>'APEXIR_NEXT_MONTH'
,p_message_text=>'Next Month'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114525222886388123)
,p_name=>'APEXIR_NEXT_WEEK'
,p_message_text=>'Next Week'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114524217345386569)
,p_name=>'APEXIR_NEXT_X_DAYS'
,p_message_text=>'Next %0 Days'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114523302801382365)
,p_name=>'APEXIR_NEXT_X_HOURS'
,p_message_text=>'Next %0 Hours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114526802932391838)
,p_name=>'APEXIR_NEXT_X_YEARS'
,p_message_text=>'Next %0 Years'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114526430851390461)
,p_name=>'APEXIR_NEXT_YEAR'
,p_message_text=>'Next Year'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56652429741193065)
,p_name=>'APEXIR_NO'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147972914153227972)
,p_name=>'APEXIR_NONE'
,p_message_text=>'- None -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(439501418371227297)
,p_name=>'APEXIR_NOT_VALID_EMAIL'
,p_message_text=>'Not a valid email address.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(113562810367830112)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_text=>'No aggregation defined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(92168806416507513)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_text=>'No column information available.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(113563622141833542)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_text=>'No computation defined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791245424915302275)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_text=>'- No End Date -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147220931004148710)
,p_name=>'APEXIR_NULLS_ALWAYS_FIRST'
,p_message_text=>'Nulls Always First'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147220017152144693)
,p_name=>'APEXIR_NULLS_ALWAYS_LAST'
,p_message_text=>'Nulls Always Last'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147509831751653133)
,p_name=>'APEXIR_NULL_SORTING'
,p_message_text=>'Null Sorting %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139691231956833720)
,p_name=>'APEXIR_NUMERIC_FLASHBACK_TIME'
,p_message_text=>'Flashback time must be numeric.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139683620351792506)
,p_name=>'APEXIR_NUMERIC_SEQUENCE'
,p_message_text=>'Sequence must be numeric.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147591500330050899)
,p_name=>'APEXIR_OPERATOR'
,p_message_text=>'Operator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55210215939700214)
,p_name=>'APEXIR_ORANGE'
,p_message_text=>'orange'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(644585489247382981)
,p_name=>'APEXIR_ORIENTATION'
,p_message_text=>'Orientation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56656925201239065)
,p_name=>'APEXIR_OTHER'
,p_message_text=>'Other'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795672626194337461)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_COUNT_X'
,p_message_text=>'Percent of Total Count %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795667731033263167)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_SUM_X'
,p_message_text=>'Percent of Total Sum %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791240727723255853)
,p_name=>'APEXIR_PERCENT_TOTAL_COUNT'
,p_message_text=>'Percent of Total Count'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791240413524251729)
,p_name=>'APEXIR_PERCENT_TOTAL_SUM'
,p_message_text=>'Percent of Total Sum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67559907558348614)
,p_name=>'APEXIR_PIE'
,p_message_text=>'Pie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(360238408574247355)
,p_name=>'APEXIR_PIVOT'
,p_message_text=>'Pivot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366500324290417815)
,p_name=>'APEXIR_PIVOT_AGG_NOT_NULL'
,p_message_text=>'Aggregate must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366591528781035116)
,p_name=>'APEXIR_PIVOT_AGG_NOT_ON_ROW_COL'
,p_message_text=>'You cannot aggregate on a column selected to as row column.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361758832404044016)
,p_name=>'APEXIR_PIVOT_COLUMNS'
,p_message_text=>'Pivot Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361758108718009471)
,p_name=>'APEXIR_PIVOT_COLUMN_N'
,p_message_text=>'Pivot Column %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366499912010408276)
,p_name=>'APEXIR_PIVOT_COLUMN_NOT_NULL'
,p_message_text=>'Pivot column must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3709046862403)
,p_name=>'APEXIR_PIVOT_MAX_ROW_CNT'
,p_message_text=>'The maximum row count for a Pivot query limits the number of rows in the base query, not the number of rows displayed. Your base query exceeds the maximum row count of %0. Please apply a filter to reduce the number of records in your base query.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1613435287230446315)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_text=>'Please select different row column.  The HTML expression or link in the row column contains column defined as pivot or aggregate column.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(362417721074029905)
,p_name=>'APEXIR_PIVOT_SORT'
,p_message_text=>'Pivot Sort'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(439756065431809723)
,p_name=>'APEXIR_PREVIEW'
,p_message_text=>'Preview'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112095619010097072)
,p_name=>'APEXIR_PREVIOUS'
,p_message_text=>'Previous'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791237121611187781)
,p_name=>'APEXIR_PRIMARY'
,p_message_text=>'Primary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(445581803499127121)
,p_name=>'APEXIR_PRIMARY_REPORT'
,p_message_text=>'Primary Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(194290521142235310)
,p_name=>'APEXIR_PRIVATE'
,p_message_text=>'Private'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(68505405658823689)
,p_name=>'APEXIR_PUBLIC'
,p_message_text=>'Public'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56654520784218910)
,p_name=>'APEXIR_RED'
,p_message_text=>'red'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1814041034484189894)
,p_name=>'APEXIR_REGION_STATIC_ID_DOES_NOT_EXIST'
,p_message_text=>'Region Static ID %0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137162923708967814)
,p_name=>'APEXIR_REMOVE'
,p_message_text=>'Remove'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112052717597519521)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_text=>'Remove Aggregate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137164602368971139)
,p_name=>'APEXIR_REMOVE_ALL'
,p_message_text=>'Remove All'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1439341109260914002)
,p_name=>'APEXIR_REMOVE_CHART'
,p_message_text=>'Remove Chart'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137097107713783419)
,p_name=>'APEXIR_REMOVE_CONTROL_BREAK'
,p_message_text=>'Remove Control Break'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137092404118772937)
,p_name=>'APEXIR_REMOVE_FILTER'
,p_message_text=>'Remove Filter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137093720049777547)
,p_name=>'APEXIR_REMOVE_FLASHBACK'
,p_message_text=>'Remove Flashback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1439341335284915353)
,p_name=>'APEXIR_REMOVE_GROUP_BY'
,p_message_text=>'Remove Group By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137099619141786761)
,p_name=>'APEXIR_REMOVE_HIGHLIGHT'
,p_message_text=>'Remove Highlight'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1439341547929916455)
,p_name=>'APEXIR_REMOVE_PIVOT'
,p_message_text=>'Remove Pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(852087688948430845)
,p_name=>'APEXIR_REMOVE_REPORT'
,p_message_text=>'Remove Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(534016888377327986)
,p_name=>'APEXIR_RENAME_DEFAULT_REPORT'
,p_message_text=>'Rename Default Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148144209023756291)
,p_name=>'APEXIR_RENAME_REPORT'
,p_message_text=>'Rename Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112497021853120340)
,p_name=>'APEXIR_REPORT'
,p_message_text=>'Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795702629414470790)
,p_name=>'APEXIR_REPORTS'
,p_message_text=>'Reports'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46131720626808988)
,p_name=>'APEXIR_REPORT_ALIAS_DOES_NOT_EXIST'
,p_message_text=>'Saved Interactive report with alias %0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(327439527633801368)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_text=>'The number of display columns in the report reached the limit.  Please click Select Columns under Actions menu to minimize the report display column list.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(196185902703753597)
,p_name=>'APEXIR_REPORT_DOES_NOT_EXIST'
,p_message_text=>'Report does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46132519503827597)
,p_name=>'APEXIR_REPORT_ID_DOES_NOT_EXIST'
,p_message_text=>'Saved Interactive Report ID %0 does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147647815342339094)
,p_name=>'APEXIR_REPORT_SETTINGS'
,p_message_text=>'Report Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103965629374830199)
,p_name=>'APEXIR_REPORT_VIEW'
,p_message_text=>'Report View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112841515458332370)
,p_name=>'APEXIR_RESET'
,p_message_text=>'Reset'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(68506600164850479)
,p_name=>'APEXIR_RESET_CONFIRM'
,p_message_text=>'Restore report to the default settings.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56652902298204065)
,p_name=>'APEXIR_ROW'
,p_message_text=>'Row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(725960179332697988)
,p_name=>'APEXIR_ROWID_NOT_SUPPORTED_FOR_WEBSOURCE'
,p_message_text=>'You cannot use ROWID as the primary key column for a web source.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135895305179757408)
,p_name=>'APEXIR_ROWS'
,p_message_text=>'Rows'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455232615614347868)
,p_name=>'APEXIR_ROWS_PER_PAGE'
,p_message_text=>'Rows Per Page'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361759030032045199)
,p_name=>'APEXIR_ROW_COLUMNS'
,p_message_text=>'Row Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361758532644013524)
,p_name=>'APEXIR_ROW_COLUMN_N'
,p_message_text=>'Row Column %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366500103815412125)
,p_name=>'APEXIR_ROW_COLUMN_NOT_NULL'
,p_message_text=>'Row column must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366504631154460221)
,p_name=>'APEXIR_ROW_COL_DIFF_FROM_PIVOT_COL'
,p_message_text=>'Row column must be different from the pivot column.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(173216916488413272)
,p_name=>'APEXIR_ROW_FILTER'
,p_message_text=>'Row Filter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103966601932841254)
,p_name=>'APEXIR_ROW_OF'
,p_message_text=>'Row %0 of %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103919323340917461)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_text=>'Row Order'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(113961216280109095)
,p_name=>'APEXIR_ROW_TEXT_CONTAINS'
,p_message_text=>'Row text contains'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6748409827923181)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_text=>'The number of display columns in the report reached the limit.  Please click Select Columns under Actions menu to minimize the report display column list.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56101209095079534)
,p_name=>'APEXIR_SAVE'
,p_message_text=>'Save'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141689831054785956)
,p_name=>'APEXIR_SAVED_REPORT'
,p_message_text=>'Saved Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141682911183770705)
,p_name=>'APEXIR_SAVED_REPORT_MSG'
,p_message_text=>'Saved Report = "%0"'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(113540030003703334)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_text=>'Save as Default'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146830000933477072)
,p_name=>'APEXIR_SAVE_DEFAULT_CONFIRM'
,p_message_text=>'The current report settings will be used as the default for all users.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(534016447676323851)
,p_name=>'APEXIR_SAVE_DEFAULT_REPORT'
,p_message_text=>'Save Default Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112841113034331594)
,p_name=>'APEXIR_SAVE_REPORT'
,p_message_text=>'Save Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1449443983164984240)
,p_name=>'APEXIR_SAVE_REPORT_DEFAULT'
,p_message_text=>'Save Report *'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(460374318700654079)
,p_name=>'APEXIR_SEARCH'
,p_message_text=>'Search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131720913910977792)
,p_name=>'APEXIR_SEARCH_BAR'
,p_message_text=>'Search Bar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1449340263744712896)
,p_name=>'APEXIR_SEARCH_COLUMN'
,p_message_text=>'Search: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(492798114569932891)
,p_name=>'APEXIR_SEARCH_REPORT'
,p_message_text=>'Search Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(409023115536157236)
,p_name=>'APEXIR_SELECTED_COLUMNS'
,p_message_text=>'Selected Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56145302739843998)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_text=>'- Select Category -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(57104706042725473)
,p_name=>'APEXIR_SELECT_COLUMN'
,p_message_text=>'- Select Column -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112703531792390987)
,p_name=>'APEXIR_SELECT_COLUMNS'
,p_message_text=>'Select Columns'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148092507292405773)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_text=>'Computed columns are prefixed with **.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67617018583297858)
,p_name=>'APEXIR_SELECT_FUNCTION'
,p_message_text=>'- Select Function -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135797015806772068)
,p_name=>'APEXIR_SELECT_GROUP_BY_COLUMN'
,p_message_text=>'- Select Group By Column -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361757521023988575)
,p_name=>'APEXIR_SELECT_PIVOT_COLUMN'
,p_message_text=>'- Select Pivot Column -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795664920120222174)
,p_name=>'APEXIR_SELECT_ROW'
,p_message_text=>'Select Row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361757700751998009)
,p_name=>'APEXIR_SELECT_ROW_COLUMN'
,p_message_text=>'- Select Row Column -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791243729239265742)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_text=>'- Select Sort Column -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147809506488847342)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_text=>'Select Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2196506871436097)
,p_name=>'APEXIR_SEND'
,p_message_text=>'Send'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56650811256178248)
,p_name=>'APEXIR_SEQUENCE'
,p_message_text=>'Sequence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112779923939596837)
,p_name=>'APEXIR_SORT'
,p_message_text=>'Sort'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138523507887338609)
,p_name=>'APEXIR_SORT_ASCENDING'
,p_message_text=>'Sort Ascending'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791241818157262484)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_text=>'Sort Column %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138523913428340129)
,p_name=>'APEXIR_SORT_DESCENDING'
,p_message_text=>'Sort Descending'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(836480296247905181)
,p_name=>'APEXIR_SORT_ORDER'
,p_message_text=>'Sort Order'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(124738716035796307)
,p_name=>'APEXIR_SPACE_AS_IN_ONE_EMPTY_STRING'
,p_message_text=>'space'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147597529382106599)
,p_name=>'APEXIR_STATUS'
,p_message_text=>'Status %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(441137300017799287)
,p_name=>'APEXIR_SUBSCRIPTION'
,p_message_text=>'Subscription'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791244906214296868)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING'
,p_message_text=>'Ending'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(408433823707074435)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_text=>'Ending Unit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791244608161287957)
,p_name=>'APEXIR_SUBSCRIPTION_STARTING_FROM'
,p_message_text=>'Starting From'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(795668307400275243)
,p_name=>'APEXIR_SUM_X'
,p_message_text=>'Sum %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(626810603993712970)
,p_name=>'APEXIR_TABLE_SUMMARY'
,p_message_text=>'Region = %0, Report = %1, View = %2, Displayed Rows Start = %3, Displayed Rows End = %4, Total Rows = %5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(120461244863590388)
,p_name=>'APEXIR_TABLE_SUMMARY_NO_TOTAL'
,p_message_text=>'Region = %0, Report = %1, View = %2, Displayed Rows Start = %3, Displayed Rows End = %4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55268503144847900)
,p_name=>'APEXIR_TEXT_COLOR'
,p_message_text=>'Text Color'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(95728903619187590)
,p_name=>'APEXIR_TIME_DAYS'
,p_message_text=>'days'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(95727930500185877)
,p_name=>'APEXIR_TIME_HOURS'
,p_message_text=>'hours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(95727122881183611)
,p_name=>'APEXIR_TIME_MINS'
,p_message_text=>'minutes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(95730313316190320)
,p_name=>'APEXIR_TIME_MONTHS'
,p_message_text=>'months'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(95729808814189019)
,p_name=>'APEXIR_TIME_WEEKS'
,p_message_text=>'weeks'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(95730717818191682)
,p_name=>'APEXIR_TIME_YEARS'
,p_message_text=>'years'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(851779236477083158)
,p_name=>'APEXIR_TOGGLE'
,p_message_text=>'Toggle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137167318991975849)
,p_name=>'APEXIR_TOP'
,p_message_text=>'Top'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147668206479421636)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_text=>'Unauthorized'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(699333651185299950)
,p_name=>'APEXIR_UNGROUPED_COLUMN'
,p_message_text=>'Ungrouped Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139688810701818118)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_text=>'Column Heading must be unique.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139681700134777222)
,p_name=>'APEXIR_UNIQUE_HIGHLIGHT_NAME'
,p_message_text=>'Highlight Name must be unique.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67350725400574412)
,p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE'
,p_message_text=>'unsupported data type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137170002499980609)
,p_name=>'APEXIR_UP'
,p_message_text=>'Up'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139686812994809325)
,p_name=>'APEXIR_VALID_COLOR'
,p_message_text=>'Please enter a valid color.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139689522129821437)
,p_name=>'APEXIR_VALID_FORMAT_MASK'
,p_message_text=>'Please enter a valid format mask.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56658211480244598)
,p_name=>'APEXIR_VALUE'
,p_message_text=>'Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137466309293023209)
,p_name=>'APEXIR_VALUE_AXIS_TITLE'
,p_message_text=>'Axis Title for Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147808432198835895)
,p_name=>'APEXIR_VALUE_REQUIRED'
,p_message_text=>'Value Required'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(67559429591345531)
,p_name=>'APEXIR_VCOLUMN'
,p_message_text=>'Vertical Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(644586007014385311)
,p_name=>'APEXIR_VERTICAL'
,p_message_text=>'Vertical'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147670212282442216)
,p_name=>'APEXIR_VIEW_CHART'
,p_message_text=>'View Chart'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485065818549403011)
,p_name=>'APEXIR_VIEW_DETAIL'
,p_message_text=>'View Detail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1498167500367864995)
,p_name=>'APEXIR_VIEW_DOES_NOT_EXIST'
,p_message_text=>'The report does not have %0 view defined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485066109330409776)
,p_name=>'APEXIR_VIEW_GROUP_BY'
,p_message_text=>'View Group By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485064019110393670)
,p_name=>'APEXIR_VIEW_ICONS'
,p_message_text=>'View Icons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361753203367902719)
,p_name=>'APEXIR_VIEW_PIVOT'
,p_message_text=>'View Pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147671024402445694)
,p_name=>'APEXIR_VIEW_REPORT'
,p_message_text=>'View Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791246325392311859)
,p_name=>'APEXIR_WEEK'
,p_message_text=>'Week'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(441141623921881832)
,p_name=>'APEXIR_WEEKLY'
,p_message_text=>'Weekly'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112496631765113761)
,p_name=>'APEXIR_WORKING_REPORT'
,p_message_text=>'Working Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(803507520899051384)
,p_name=>'APEXIR_X_DAYS'
,p_message_text=>'%0 days'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(803507212588048887)
,p_name=>'APEXIR_X_HOURS'
,p_message_text=>'%0 hours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(803506901853045812)
,p_name=>'APEXIR_X_MINS'
,p_message_text=>'%0 minutes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(803508213758058782)
,p_name=>'APEXIR_X_MONTHS'
,p_message_text=>'%0 months'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(803507730942054276)
,p_name=>'APEXIR_X_WEEKS'
,p_message_text=>'%0 weeks'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(803508418953060256)
,p_name=>'APEXIR_X_YEARS'
,p_message_text=>'%0 years'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(791246119158310074)
,p_name=>'APEXIR_YEAR'
,p_message_text=>'Year'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(55206607150688197)
,p_name=>'APEXIR_YELLOW'
,p_message_text=>'yellow'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(56651405499186098)
,p_name=>'APEXIR_YES'
,p_message_text=>'Yes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5726119032631729)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_text=>'Application Express Administration Services'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(624801124779296459)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_text=>'There is no authentication configured for this application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137286321156741732)
,p_name=>'APEX_GROUP.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_text=>'%0 contains < or > which are invalid characters.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(256665332220204438)
,p_name=>'APEX_REGION'
,p_message_text=>'Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(164806130198109254)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_text=>'The following database objects will be %0 into the selected schema:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(164812283120259655)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_text=>'The following database objects were successfully %0:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(502640933259223682)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_text=>'Scroll down'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(502641259368224775)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_text=>'Scroll to top'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(8485712413560636)
,p_name=>'APEX_WIZARD_FORM'
,p_message_text=>'Navigation Form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623926632702884462)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_text=>'Edit Row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(295234610322901649)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_text=>'Invalid Objects'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(820480710316844869)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_text=>'No peer pages exist'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(628754359011688580)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_text=>'Objects to create'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(628832820607735495)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_text=>'Delete from Tables'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(628883040615235507)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_text=>'Drop Objects'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456464013544333518)
,p_name=>'APEX_WS_SETUP_DROP_TABLES'
,p_message_text=>'Drop Tables'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456445326901176593)
,p_name=>'APEX_WS_SETUP_MSG1'
,p_message_text=>'These objects will be created in the <b>%0</b> schema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(629132630714685121)
,p_name=>'APEX_WS_SETUP_MSG10'
,p_message_text=>'These objects already exist in the <b>%0</b> schema and are used by other workspaces. If you continue, the existing Websheet objects owned by <b>%0</b> will be associated with this workspace as well.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(629132811106688949)
,p_name=>'APEX_WS_SETUP_MSG11'
,p_message_text=>'Please select the schema to use for these objects:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(629247131864943773)
,p_name=>'APEX_WS_SETUP_MSG12'
,p_message_text=>'Existing tables to be used'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(629248622907969594)
,p_name=>'APEX_WS_SETUP_MSG13'
,p_message_text=>'Websheet database objects will be reused using the following information. Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456452706384189581)
,p_name=>'APEX_WS_SETUP_MSG2'
,p_message_text=>'If you would rather create the Websheet objects in a new schema use the <a href=%0>Request Database Schema</a> wizard.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456453431318196818)
,p_name=>'APEX_WS_SETUP_MSG3'
,p_message_text=>'In order to run Websheets, the following objects are required:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456461511073304486)
,p_name=>'APEX_WS_SETUP_MSG5'
,p_message_text=>'Websheet database objects will be created using the following information.  Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456461824579308390)
,p_name=>'APEX_WS_SETUP_MSG6'
,p_message_text=>'Tables to create'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456463004409321496)
,p_name=>'APEX_WS_SETUP_MSG7'
,p_message_text=>'You are about to remove Websheet database objects.  This will drop Websheet database objects as well as internal data that contain Websheet components in your workspace.  Would you like to continue?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456465403417349578)
,p_name=>'APEX_WS_SETUP_MSG8'
,p_message_text=>'The following invalid objects need to be corrected in order to run Websheets properly'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(628830127964718717)
,p_name=>'APEX_WS_SETUP_MSG9'
,p_message_text=>'You are about to remove the Websheet definitions for this workspace. The Websheet database objects are also used by other workspaces so will not be dropped. Records associated with this workspace will be deleted. Would you like to continue?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456465923849355411)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_text=>'Object Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456466728005356617)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_text=>'Object Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(456463701077329978)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_text=>'Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(628753580952682996)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_text=>'Existing objects to be used'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11992502511417241)
,p_name=>'API_PRECONDITION_VIOLATED'
,p_message_text=>'API precondition violated'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(63070357422745898)
,p_name=>'APP.SETTING.CANNOT.GET'
,p_message_text=>'Cannot get value for Application Setting %0 as associated build option is disabled.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(63070149280740789)
,p_name=>'APP.SETTING.CANNOT.SET'
,p_message_text=>'Cannot set value for Application Setting %0 as associated build option is disabled.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(682004241434672463)
,p_name=>'APP.SETTING.INVALID.VALUE'
,p_message_text=>'Application Setting %0 value is invalid'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(682003942724667459)
,p_name=>'APP.SETTING.NOT.DEFINED'
,p_message_text=>'Requested Application Setting %0 is not defined'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(682005515172679271)
,p_name=>'APP.SETTING.VALUE.NOT.NULL'
,p_message_text=>'Application Setting %0 may not be set to a null value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25119900774841915)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_text=>'Application Computations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25119502543795150)
,p_name=>'APPLICACTION_PROCESS'
,p_message_text=>'Application Processes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276935211336777527)
,p_name=>'APPLICATION'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(359248313170152671)
,p_name=>'APPLICATION BUILDER'
,p_message_text=>'App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(192771330479976314)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_text=>'Application Computation Condition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(193925322687230689)
,p_name=>'APPLICATION IMAGE'
,p_message_text=>'Application Image'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(192771710178979905)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_text=>'Application Process Condition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160743812928269079)
,p_name=>'APPLICATIONS'
,p_message_text=>'applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(254103219723839878)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_text=>'Applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184171506479952922)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_text=>'Application Activity'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(204326431260698780)
,p_name=>'APPLICATION_ALIAS'
,p_message_text=>'Application Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(201888924075925886)
,p_name=>'APPLICATION_DELETED'
,p_message_text=>'Application Deleted'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5715305985486099)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_text=>'Application Development'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(203483230134875810)
,p_name=>'APPLICATION_HELP'
,p_message_text=>'Identifies Application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183997123759605032)
,p_name=>'APPLICATION_ID'
,p_message_text=>'Application Number'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137890104814220249)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_text=>'Application ID is reserved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137688617384138471)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_text=>'Application ID must be a positive, whole number.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(486385824784572064)
,p_name=>'APPLICATION_IMAGES'
,p_message_text=>'Application Images'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(244155829077041830)
,p_name=>'APPLICATION_ITEM'
,p_message_text=>'Application Item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(34139202594701700)
,p_name=>'APPLICATION_ITEMS'
,p_message_text=>'Application Items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23824317961115621)
,p_name=>'APPLICATION_LABEL'
,p_message_text=>'Application: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(204325926066697215)
,p_name=>'APPLICATION_NAME'
,p_message_text=>'Application Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(820473101406548964)
,p_name=>'APPLICATION_NAMES'
,p_message_text=>'Application Names'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(315871028643575093)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_text=>'Application Override ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(201792407780421040)
,p_name=>'APPLICATION_OWNER'
,p_message_text=>'Application Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(820472102875530500)
,p_name=>'APPLICATION_PAGES'
,p_message_text=>'Application Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(72038406986033206)
,p_name=>'APPLICATION_SETTINGS'
,p_message_text=>'Application Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(201793217823423985)
,p_name=>'APPLICATION_STATUS'
,p_message_text=>'Application Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282817600879195063)
,p_name=>'APPLICATION_VERSION'
,p_message_text=>'Application Version'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11212531906149315)
,p_name=>'APPLICATION_X'
,p_message_text=>'Application %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(176999305714750057)
,p_name=>'APPROVED'
,p_message_text=>'Approved'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(209403007313600972)
,p_name=>'APP_SUCCESS_MSG'
,p_message_text=>'The application has been successfully created.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(836388413761993110)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_text=>'Template Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22592528732319119)
,p_name=>'APP_TYPE_DATABASE'
,p_message_text=>'Database Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22593232542320275)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_text=>'Productivity or Sample Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(239896131673947664)
,p_name=>'APP_TYPE_PACKAGED_WS'
,p_message_text=>'Sample Websheet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22592324230317877)
,p_name=>'APP_TYPE_WEBSHEET'
,p_message_text=>'Websheet Application'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(176657314673029861)
,p_name=>'ARCHIVED'
,p_message_text=>'Archived'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23929717128314457)
,p_name=>'ARCHIVELOG'
,p_message_text=>'Log Archiving: On'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114403831934115900)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_text=>'Arguments Must Have Checksum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145291012953055509)
,p_name=>'ARGUMENT_NAME'
,p_message_text=>'Argument Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145291931654060896)
,p_name=>'ARGUMENT_TYPE'
,p_message_text=>'Argument Type'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172768009090484269)
,p_name=>'ASAP'
,p_message_text=>'As soon as possible'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(171872404945931328)
,p_name=>'ASSIGNED'
,p_message_text=>'Assigned'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(68117228795073143)
,p_name=>'ASSIGNEE'
,p_message_text=>'Assignee'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(969138433284014825)
,p_name=>'ASSIGN_LABEL'
,p_message_text=>'Assign  %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88270128342698420)
,p_name=>'ASSOCIATED'
,p_message_text=>'associated'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(70744921953402322)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_text=>'Associated Features'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184527917540507627)
,p_name=>'ATTACHMENT'
,p_message_text=>'Attachment'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1116469627795891689)
,p_name=>'AT_RISK_LABEL'
,p_message_text=>'At Risk'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84980113452412986)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_text=>'You are about to migrate this application''s custom authentication options to an authentication scheme.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84975628165379446)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_text=>'Current Authentication Method'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84979308473402072)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_text=>'Custom Authentication Function'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84977318253386052)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_text=>'Login Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84978925657397584)
,p_name=>'AUTH.LOGIN_URL'
,p_message_text=>'Login URL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84978002454390895)
,p_name=>'AUTH.NONE'
,p_message_text=>'none'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86590502377236028)
,p_name=>'AUTHENTICATION'
,p_message_text=>'Authentication'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(192776815943047895)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_text=>'Authentication Function'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(192775618929039286)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_text=>'Authentication Scheme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87208221048414695)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_text=>'You are about to delete an authentication scheme from application %0. If the application is not currently using SCHEME authentication or if the scheme is not the current authentication scheme, deleting the scheme has no effect on the operation of the'
||' application. If the application is using SCHEME authentication and this is the current authentication scheme, the application will continue to run using SCHEME authentication, but with a default authentication scheme. This will use a built-in login '
||'page with "open door" credentials verification (that is, anyone will be allowed to run the application). '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87889804014093209)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_text=>'Click the Make Current button to have your application use this authentication scheme.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(363427413736982258)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_text=>'Application Express Accounts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4770420113873080)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(363435219276983864)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_text=>'Custom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(363483002438988511)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_text=>'No Authentication'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(363443124471985374)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_text=>'Database Accounts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(556006715508818492)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_text=>'HTTP Header Variable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(363511814559991981)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_text=>'Oracle Application Server Single Sign-On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(363462329319986727)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_text=>'LDAP Directory'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(363499006940989801)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_text=>'Open Door Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1382586340020134)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_text=>'SAML Sign-In'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15243204618976010)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_text=>'Social Sign-In'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(244213402938372976)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_text=>'Authentication Scheme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(192775001960034392)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_text=>'Authorization Scheme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4774527732875201)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11261109462457047)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_text=>'Exists SQL Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11261314310458385)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_text=>'PL/SQL Function Returning Boolean'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135867122178687109)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_text=>'Is In Role or Group'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135867319806688244)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_text=>'Is Not In Role or Group'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11261519158459818)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_text=>'Value of Item in Expression 1 Equals Expression 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11261724007461158)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_text=>'Item in Expression1 is NOT NULL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11262006822465716)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_text=>'Item in Expression 1 is NULL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11262210632466812)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_text=>'Value of Item in Expression 1 Does NOT Equal Expression 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11262414441467901)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_text=>'NOT Exists SQL Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11262618943469182)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_text=>'Value of Preference in Expression 1 Equals Expression 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11262823099470416)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_text=>'Value of Preference in Expression 1 Does NOT Equal Expression 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25598506881464331)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_text=>'Evaluate for every page view'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25598915885466909)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_text=>'Evaluate once per session'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12752907900044741)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_text=>'Account Expired'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12752503051043328)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_text=>'Account Locked'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12754102836052690)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_text=>'Maximum Login Attempts Exceeded'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12754509762054706)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_text=>'Unknown Internal Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12753725561049781)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_text=>'Password First Use'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12753318289047745)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_text=>'Incorrect Password'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12751723006039634)
,p_name=>'AUTH_SUCCESS'
,p_message_text=>'Normal, successful authentication'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12752130279041717)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_text=>'Unknown User Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(42835024888575920)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_text=>'Unknown Workspace Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46712915547065819)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_text=>'Unknown Workspace Name: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106601517552404527)
,p_name=>'AUTOCOMMIT'
,p_message_text=>'Commit statement not applicable.  All statements are automatically committed.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(254984219822103682)
,p_name=>'AUTOPROVISION_MODE'
,p_message_text=>'Provisioning Mode'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3611510058039936)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_text=>'First Item'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(290093313947238895)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_text=>'Availability'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14633025624668156)
,p_name=>'AVAILABLE'
,p_message_text=>'Available'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(402732328872676693)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_text=>'Available to Developers Only'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(402716131434667851)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_text=>'Available with Developer Toolbar'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184176217280135809)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_text=>'Average Rendering Time (Seconds)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25708712654726011)
,p_name=>'BACK'
,p_message_text=>'Back'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(175289809867113949)
,p_name=>'BAR_CHART'
,p_message_text=>'Bar Chart'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471700515483089456)
,p_name=>'BASIC'
,p_message_text=>'Basic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19748000349798134)
,p_name=>'BASIC_DEVELOPER'
,p_message_text=>'Basic Developer'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166096519250032238)
,p_name=>'BEFORE'
,p_message_text=>'Before'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(858434258584172426)
,p_name=>'BEFORE LIST ENTRY'
,p_message_text=>'Before List Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(946323974268547532)
,p_name=>'BEFORE_FIRST'
,p_message_text=>'Before First'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(194638714428741225)
,p_name=>'BIND_LABEL'
,p_message_text=>'Bind Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(194225607253578559)
,p_name=>'BIND_VARIABLE'
,p_message_text=>'Bind Variable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(194226113964589955)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_text=>'Bind Variable Label'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(211008925787727306)
,p_name=>'BLACK_TEXT'
,p_message_text=>'Black Text'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5910016279942038)
,p_name=>'BLANK'
,p_message_text=>'Blank'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184523023896443249)
,p_name=>'BLOB_COLUMN'
,p_message_text=>'BLOB Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(317487424096621745)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_text=>'Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22989702805390350)
,p_name=>'BLOB_FORMAT'
,p_message_text=>'Blob Format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(317510018014943651)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_text=>'Attachment'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(317506415691883968)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_text=>'DOWNLOAD'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(317506612887885269)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_text=>'IMAGE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(317509821249942086)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_text=>'Inline'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184536305681873179)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_text=>'BLOB Format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184526705719475860)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_text=>'BLOB Last Updated Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184522708181429296)
,p_name=>'BLOB_TABLE'
,p_message_text=>'BLOB Table'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(211008521978726251)
,p_name=>'BLUE_TEXT'
,p_message_text=>'Blue Text'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(190201810387940994)
,p_name=>'BRANCH CONDITION'
,p_message_text=>'Branch Condition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26574026263306547)
,p_name=>'BRANCHES'
,p_message_text=>'Branches'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112649114174331879)
,p_name=>'BREADCRUMB'
,p_message_text=>'Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166156511706285586)
,p_name=>'BREADCRUMB LABEL'
,p_message_text=>'Breadcrumb Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166157216208286830)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_text=>'Breadcrumb Long Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(112652500584346879)
,p_name=>'BREADCRUMBS'
,p_message_text=>'Breadcrumbs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(227313332167417545)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_text=>'Breadcrumb Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(244159817585123126)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_text=>'Breadcrumb Entry: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138291118408684695)
,p_name=>'BREADCRUMB_PAGES'
,p_message_text=>'Breadcrumb Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(170067405116549071)
,p_name=>'BREADCRUMB_REGION'
,p_message_text=>'Breadcrumb Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(47749016267868812)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_text=>'The breadcrumb has been created successfully.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166879626973629620)
,p_name=>'BROWSE_ICON'
,p_message_text=>'Browse Icon'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166350003385352802)
,p_name=>'BROWSE_PACKAGE'
,p_message_text=>'Browse Package'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145279924934973828)
,p_name=>'BROWSE_TABLE'
,p_message_text=>'Browse Table'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(7691925242338300)
,p_name=>'BUFFER CACHE'
,p_message_text=>'Buffer Cache'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172902200721777965)
,p_name=>'BUG'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184179708585180614)
,p_name=>'BUGS'
,p_message_text=>'Bugs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(191842801468313387)
,p_name=>'BUGS_ASSIGNED'
,p_message_text=>'bugs assigned'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236539728609554422)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_text=>'Bugs Assigned'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(17736421345477258)
,p_name=>'BUGS_CLOSED'
,p_message_text=>'Bugs closed (%0 / %1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(496363927958523300)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_text=>'Bugs percent closed (%0/%1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236540021493557674)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_text=>'Bugs Unassigned'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236544023637571892)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_text=>'No Fix By Dates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(496735400777253310)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_text=>'Bugs: %1 of %0 closed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1036814214998182732)
,p_name=>'BUG_LABEL'
,p_message_text=>'Bug: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(185507901218425453)
,p_name=>'BUILD QUERY'
,p_message_text=>'Build Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4659903166223659)
,p_name=>'BUILDER'
,p_message_text=>'Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279427301631085873)
,p_name=>'BUILDER.PLUGINS'
,p_message_text=>'Plug-ins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275007606818926902)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_text=>'[Unsupported]'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484879007067195370)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_text=>'Workspace Message'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86867914216769358)
,p_name=>'BUILD_OPTION'
,p_message_text=>'Build Option'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(337598917473396386)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_text=>'Build Option: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1034832221991964130)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_text=>'Build Status: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(342012314841257514)
,p_name=>'BUILD_VERSION'
,p_message_text=>'Build Version'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(231303217767143013)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_text=>'Built in Report Template'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(165836317894003951)
,p_name=>'BUTTON'
,p_message_text=>'button'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166095209076019858)
,p_name=>'BUTTON LABEL'
,p_message_text=>'Button Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(324872079304916555)
,p_name=>'BUTTON.ADD'
,p_message_text=>'Add'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10465811136933132)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_text=>'The selected Button''s Button Attributes must not contain an ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10465526804918707)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_text=>'The selected button must be a button with an Action set to ''Defined by Dynamic Action'''
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10517831315345828)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_text=>'The selected button uses a ''Button Template'' that does not contain the #BUTTON_ID# substitution string'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(324871665525913142)
,p_name=>'BUTTON.DELETE'
,p_message_text=>'Delete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26585521658835522)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_text=>'Page must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23646206473246698)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_text=>'Report Query must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22557715752175614)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_text=>'Button Request must be specified for all the Button Request Source Types, unless Button Request Source Type is "Always Null".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22641822294574881)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_text=>'Button Request Source Type must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26585724775836349)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_text=>'URL Target must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11131426025055486)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_text=>'When the Action is ''Defined by Dynamic Action'', the Button Attributes must not contain an ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(27028915636625079)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_text=>'Image must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(27029127757628555)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_text=>'Style must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(27027908710623121)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_text=>'Template must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11128929433952372)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_text=>'When the Button Style is ''Template Based Button'' and Action is ''Defined by Dynamic Action'', the selected Button Template must contain the #BUTTON_ID# substitution string'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6700327932133912)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_text=>'Button cannot be deleted because it is referenced in a Dynamic Action (Page: %0, Dynamic Action: ''%1'', Action: ''%2'', Attribute: ''Affected Element'').'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6699904678099115)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_text=>'Button cannot be deleted because it is referenced in a Dynamic Action (Page: %0, Dynamic Action: ''%1'', Attribute: ''When'').'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(324871850640915087)
,p_name=>'BUTTON.SUBMIT'
,p_message_text=>'Submit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(313215230634932044)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_text=>'To be used in an "onclick" attribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(320371216069176796)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_text=>'To be used in an "href" attribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26575631804308135)
,p_name=>'BUTTONS'
,p_message_text=>'Buttons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(195521424962048000)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_text=>'Button Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4014216900444054)
,p_name=>'BUTTON_CSS_CLASSES'
,p_message_text=>'Button CSS Classes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(77390125296098295)
,p_name=>'BUTTON_ID'
,p_message_text=>'Generated button ID will be either the button''s Static ID if defined, or if not will be an internally generated ID in the format ''B'' || [Internal Button ID]'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1034739606398883849)
,p_name=>'BUTTON_LABEL'
,p_message_text=>'Button: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(200661619685415091)
,p_name=>'BUTTON_TEMPLATE'
,p_message_text=>'Button Template'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26057215633754454)
,p_name=>'BYTES'
,p_message_text=>'bytes'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172768215323486103)
,p_name=>'BY_NEXT_PATCH'
,p_message_text=>'By next patch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172768419133487142)
,p_name=>'BY_NEXT_RELEASE'
,p_message_text=>'By next release'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922460531074056574)
,p_name=>'CA.ABOUT'
,p_message_text=>'About'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2645711118768334914)
,p_name=>'CA.ABOUT.PAGE'
,p_message_text=>'About Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2645703065337281803)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Include an about this application page which features a description of the application, the application version, and a page count.',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84023937671947678)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_text=>'Content Container'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922460986216066186)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_text=>'About Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922461179966070662)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_text=>'Text about this application can be placed here.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922460399157049710)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_text=>'About this Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3108275218294181249)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_text=>'About this preview release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646689428037471242)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_text=>'Access Control'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2936352154493906864)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_text=>'Access Control Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921862982160185411)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_text=>'Access Control Configuration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621197543015395554)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_text=>'Enable role-based user authorization'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646691137910499236)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Incorporate role based user authentication within your application.',
'Users can be defined as Administrators, Contributors, or Readers.',
'You can then readily define different access to different roles for various components throughout your application, such as pages, menu entries, regions, columns, items, buttons and so forth.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Administrative page region with links to access control features</li>',
'<li>Users table to manage access control</li>',
'<li>Configuration page to set access level of authenticated users</li>',
'<li>Configuration page to specify if usernames are email addresses or not</li>',
'<li>Manage users access page to report and edit user access</li>',
'<li>Add user page with ability to add a single user</li>',
'<li>Add multiple users page with ability to add multiple users (email usernames only)</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921457360963067999)
,p_name=>'CA.ACCESS.ROLE'
,p_message_text=>'Role'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921458928124083758)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_text=>'Access Role ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40777121249534403)
,p_name=>'CA.ACCESS.ROLES'
,p_message_text=>'Roles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921457568177069383)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_text=>'Account Locked'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(51097352111856095)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_text=>'Acknowledged'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2936348073694895278)
,p_name=>'CA.ACL.INFORMATION'
,p_message_text=>'ACL Information'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2939101723648525336)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_text=>'Insufficient privileges, user is not an Administrator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2939101924183534294)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_text=>'You are not authorized to view this application, either because you have not been granted access, or your account has been locked. Please contact the application administrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2939102140061539543)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_text=>'Insufficient privileges, user is not a Contributor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922000798241226929)
,p_name=>'CA.ACL.SAVED'
,p_message_text=>'Access Control settings saved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922444182764816692)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_text=>'Action Button HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922438254857756049)
,p_name=>'CA.ACTION.LABEL'
,p_message_text=>'Action Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922438458821758338)
,p_name=>'CA.ACTION.LINK'
,p_message_text=>'Action Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922457162389968680)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_text=>'Action Link HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921391448582703368)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_text=>'Action Processed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921454434670019772)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_text=>'Activity by Hour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3431138782265996762)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_text=>'Activity Dashboard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646811269044516004)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_text=>'Activity Reporting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621235814173596267)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_text=>'Include user activity and error reports'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646812353061526776)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Include numerous reports on end user activity for your application. Determine the most active users, the most used pages, the performance of pages, and errors raised, to better understand how your application is being utilized and areas for improv'
||'ement.</p>',
'<p>Includes the following:',
'<ul>',
'<li>Top Users report</li>',
'<li>Application Error Log report</li>',
'<li>Page Performance, activity and performance by page</li>',
'<li>Application activity by page report</li>',
'<li>Page Views detail report</li>',
'',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184722752668855322)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_text=>'Actual Start Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2936347375766890525)
,p_name=>'CA.ADD'
,p_message_text=>'Add'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922445037810823657)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_text=>'Add Email Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3207348376277304563)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_text=>'Add Multiple Users - Step 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2928845970974696196)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_text=>'Add New %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921243212875092122)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_text=>'Add Notification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(727736448010205713)
,p_name=>'CA.ADD.PAGE'
,p_message_text=>'Add Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921459160717086449)
,p_name=>'CA.ADD.USER'
,p_message_text=>'Add User'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3207350475634336341)
,p_name=>'CA.ADD.USERS'
,p_message_text=>'Add Users'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2647110565840280585)
,p_name=>'CA.ADDING.PAGES'
,p_message_text=>'Adding Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2647115246828353695)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_text=>'<p>Click <strong>Add Page</strong> to add a page to your application. Then, select a page type (such as Blank, Chart, Form, Report, and so on) and define its attributes. You may also need to specify a valid table or view or use SQL Workshop to prepar'
||'e database objects in your workspace.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922455409080934735)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_text=>'Advanced'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184716749547844868)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_text=>'Additional Information'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921458512102079691)
,p_name=>'CA.ADDRESS'
,p_message_text=>'Address'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717719947844869664)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_text=>'Access Control'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717723231890882455)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_text=>'Set level of access for authenticated users of this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717555357248833976)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_text=>'Activity Reports'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717720390087870685)
,p_name=>'CA.ADMIN.ADD'
,p_message_text=>'Add'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717729259651943829)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_text=>'Administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717721582582875378)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_text=>'Administrators'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(218159415342551405)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_text=>'Application Configuration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(306458550608649433)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_text=>'User Interface'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3019487861416921306)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_text=>'Application Administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3019490170988923820)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_text=>'Manage component'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717553734035817062)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_text=>'Theme Style Selection'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717554215113824357)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_text=>'Set the default application look and feel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717552658117808643)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_text=>'Configuration Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717552297279805154)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_text=>'Enable or disable application features'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717556275937838498)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_text=>'Application Error Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717716478535842068)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_text=>'Report of errors logged by this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717554498319826140)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_text=>'Application Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717554945167831899)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_text=>'Set application name and short description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717553237079811577)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_text=>'Application Updates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717553533218813726)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_text=>'Maintain the list of application updates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717547491399784980)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_text=>'Configuration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717721396161874155)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_text=>'Contributors'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3392601437263297482)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_text=>'Dashboard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3392590633246194854)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_text=>'View application activity metrics'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722746696365755572)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_text=>'Default Time Zone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722746819091756827)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_text=>'Set the default time zone for this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717725912407903634)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_text=>'Email'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722747909848810687)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_text=>'Email Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722748121389812242)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_text=>'Set if email should be sent and if so, who reply to should be'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717723695986888474)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_text=>'Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717725181560895461)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_text=>'Feedback Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717725523559899912)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_text=>'Manage if attachments should be allowed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717723847939889886)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_text=>'User Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717724817879894153)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_text=>'Report of all feedback submitted by application users'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717726183260905316)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_text=>'Email Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717726618186923296)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_text=>'Manage email template HTML and CSS used by this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717548659596787143)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_text=>'Notifications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717550305849793439)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_text=>'Display notifications on the home page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3035872367426225072)
,p_name=>'CA.ADMIN.PAGE'
,p_message_text=>'Administration Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717717207875843699)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_text=>'Page Performance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717719105964859008)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_text=>'Report of activity and performance by application page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717719385461860347)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_text=>'Page Views'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717719758392867742)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_text=>'Report of each page view by user including date of access and elapsed time'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717721161023872634)
,p_name=>'CA.ADMIN.READERS'
,p_message_text=>'Readers'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3310571738092096812)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_text=>'Send Email'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3310572131363099669)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_text=>'Send template based email from this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717555596528834943)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_text=>'Top Users'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717555811498837126)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_text=>'Report of page views aggregated by user'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717720726482871503)
,p_name=>'CA.ADMIN.USERS'
,p_message_text=>'Users'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717723416783887135)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_text=>'Change access control settings and disable access control'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717726827352924308)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_text=>'Email Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717727766757934617)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_text=>'View log of emails sent by this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(110372878183239212)
,p_name=>'CA.ADVANCED'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
' <li><strong>Advanced</strong> - Expand to see advanced options.',
'    <ul>',
'      <li><strong>Set as Home Page</strong> - Make this page the home page for the application.<br>',
'      &nbsp;&nbsp;&nbsp;Any page previously defined as the home page will be updated.</li>',
'      <li><strong>Set as Administration Page</strong> - Add this page under Administration, rather than as a normal page in the application. Access by clicking Administration in the main menu and then selecting it the Application Administration list.'
||'<br>',
'        <em><strong>Note:</strong> A page cannot be both a Home page and a page under Administration.</em></li>',
'      &nbsp;<br>',
'      <li><strong>Page Help</strong> - Enter text to be added to the Help Text for the page.</li>',
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(64584832806113113)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
' <li><strong>Advanced</strong> - Expand to see advanced options.',
'    <ul>',
'      <li><strong>Page Help</strong> - Enter text to be added to the Help Text for the page.</li>',
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3052392383106533190)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_text=>'Advanced Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3052392567103548693)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_text=>'<p>Set additional definition, security and globalization settings.  These settings can be applied when creating the application, and can also be edited post application creation.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3092808948029652851)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_text=>'<p>Read the item help ( <span class="fa fa-question-circle" aria-hidden="true"></span> ) for each setting for more information.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3320760499135365754)
,p_name=>'CA.AFTER.ROWS'
,p_message_text=>'After Rows'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922443838328813787)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_text=>'After Rows HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2928144744429905785)
,p_name=>'CA.ALL.COLS'
,p_message_text=>'All Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922438636653760184)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_text=>'Allow Opt Out'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184691704616764705)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_text=>'Allow Runs in Restricted Mode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921453849792975963)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_text=>'Application Error Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921400527629957834)
,p_name=>'CA.APP.NAME'
,p_message_text=>'Application Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(233821681918498873)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_text=>'Whether access control is turned on or not'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(233821822833504115)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_text=>'The default access level given to authenticated users who are not in the access control list'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921401775764976317)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_text=>'Application settings updated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921400908323967781)
,p_name=>'CA.APP.SUBTITLE'
,p_message_text=>'Short Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921401599826971628)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_text=>'The text entered here is displayed under the application name on the home page of the application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731729267645868096)
,p_name=>'CA.APPEARANCE'
,p_message_text=>'Appearance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731729722265875812)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_text=>'<p>Define the default application color scheme (theme style), where the navigation is located, and the icon used for the application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922385481311487392)
,p_name=>'CA.APPLICATION'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921186348271773302)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_text=>'Application Appearance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731730776907899030)
,p_name=>'CA.APPLICATION.ICON'
,p_message_text=>'Application Icon'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731730993846908989)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_text=>'<p>Click <strong>Choose New Icon</strong> to select the icon color and one of the available icons. Your selection displays on the home page of the application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731732224492951587)
,p_name=>'CA.APPLICATION.ID'
,p_message_text=>'Application ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731732489462955168)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_text=>'<p>Enter a unique, numeric identifier for your application. This field contains an automatically generated identifier by default.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922429791141503646)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_text=>'Application Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921423639339335319)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_text=>'Application Sessions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2645716370102357080)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_text=>'Application Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621227754822543935)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_text=>'Set application name and short description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2645718519823378422)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Allow application administrators to update various settings such as the application name and a description, default time zone and so forth.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Administrative page list entry and form</li>',
'<li>Ability to set application name</li>',
'<li>Ability to set home page hero region subtitle</li>',
'<li>Ability to set feedback recipients if using feedback</li>',
'<li>Ability to set application default time zone</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390027690448893810)
,p_name=>'CA.APPLICATIONITEM'
,p_message_text=>'Application Item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3408615440855126793)
,p_name=>'CA.APPLY'
,p_message_text=>'Apply'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3624523424892738244)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_text=>'Applying application defaults'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2920367821485526287)
,p_name=>'CA.APPLY.CHANGES'
,p_message_text=>'Apply Changes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3405575241848661420)
,p_name=>'CA.APPLY.FILTERS'
,p_message_text=>'Apply Filters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(304994381923568234)
,p_name=>'CA.APP_BANNER'
,p_message_text=>'Application created from create application wizard %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305939287495202897)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_text=>'Save Setting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3803963485747413355)
,p_name=>'CA.ATTACHMENT'
,p_message_text=>'Attachment'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129922908435085660)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_text=>'Attachment Count'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3804208091347651202)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_text=>'Attachment Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129922795760084322)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_text=>'Attachment Size'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3414637955199571242)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_text=>'Attribute Defaults already defined for this %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921926912899196438)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_text=>'Any authenticated user may access this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731733847212007055)
,p_name=>'CA.AUTHENTICATION'
,p_message_text=>'Authentication'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731734047687010010)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_text=>'<p>Select how you want users to authenticate into your application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184700898371810810)
,p_name=>'CA.AUTO.DROP'
,p_message_text=>'Auto Drop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921449510700926462)
,p_name=>'CA.AVG.ELAPSED'
,p_message_text=>'Avg Elapsed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(230792902824132322)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_text=>'Back to Jobs Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129924690458096670)
,p_name=>'CA.BCC'
,p_message_text=>'BCC'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3320760221853364271)
,p_name=>'CA.BEFORE.ROWS'
,p_message_text=>'Before Rows'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922443528620807726)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_text=>'Before Rows HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922456491173956711)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_text=>'Before Rows Content'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2720804498703514355)
,p_name=>'CA.BLANK'
,p_message_text=>'Add Blank Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2720808457568539034)
,p_name=>'CA.BLANK.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a blank page as a placeholder. Once you create the application, you can readily create regions on the page from Page Designer.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'<!--  <li><strong>Include Page Navigation</strong> - Check this option to display a card list of all other pages defined in your application.<br>',
'      &nbsp;&nbsp;&nbsp;This option is typically used on your application home page.</li>',
'-->',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3021697125256794594)
,p_name=>'CA.BLUEPRINT'
,p_message_text=>'Application Blueprint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3021697330957833605)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The blueprint lists the application definition in JSON format.</p>',
'<p>When first entering this screen, the current application definition is transformed into a JSON document and displayed. You can edit the document to update application properties, and then click <strong>Apply Blueprint</strong> to change the curren'
||'t application details.</p>',
'<p>&nbsp;</p>',
'<p>If you need to create a large number of similar pages, copying the relevant JSON code for one page and pasting numerous times, and making small adjustments to the JSON, is significantly quicker than manually using the <strong>Add Page</strong> for'
||' each page.</p>',
'<p>Click <strong>Load a Previous Blueprint</strong> to replace the blueprint with the definition from a previously generated application. In this way you can very easily iterate an application design by adding additional pages, changing the features,'
||' or tweaking the settings, before generating the application again.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922437002669748757)
,p_name=>'CA.BODY1.TEXT'
,p_message_text=>'Body1 Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922438006633753421)
,p_name=>'CA.BODY2.TEXT'
,p_message_text=>'Body2 Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3350902159699397964)
,p_name=>'CA.BOTH'
,p_message_text=>'Both'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921193976387893274)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_text=>'Branch to Admin Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109844703095809152)
,p_name=>'CA.BUTTON.BAR'
,p_message_text=>'Button Bar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921187467439787711)
,p_name=>'CA.BUTTONS'
,p_message_text=>'Buttons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722694106915896175)
,p_name=>'CA.CALENDAR'
,p_message_text=>'Add Calendar Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722694311431897355)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays a calendar.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Table or View</strong> (Mandatory) - Select the database object for the calendar.</li>',
'  <li><strong>Display Column</strong> (Mandatory) - Select the column from the table or view to display in the calendar events.</li>',
'  <li><strong>Start Date Column</strong> (Mandatory) - Select the date column from the table or view to use as the start date for calendar events.</li>',
'  <li><strong>End Date Column</strong> - Select the date column from the table or view to use as the end date for calendar events.<br>',
'      &nbsp;&nbsp;&nbsp;If End Date is specified then duration based events will be displayed. </li>',
'  <li><strong>Show Time</strong> - Select <strong>Yes</strong> to show the time portion for events and also enable the Weekly and Daily calendar views. Select <strong>No</strong> to only show the dates for events.</li>',
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2920367133497520875)
,p_name=>'CA.CANCEL'
,p_message_text=>'Cancel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921195282534923399)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_text=>'Cancel Dialog'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106119627586788824)
,p_name=>'CA.CANCEL.MODAL'
,p_message_text=>'Cancel Modal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922005558903296781)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_text=>'You cannot remove administration rights from your own record.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3471170273687779427)
,p_name=>'CA.CARD'
,p_message_text=>'Add Card Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3471170009562777626)
,p_name=>'CA.CARD.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays cards.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Table or View</strong> (Mandatory) - Select the database object for the card.</li>',
'  <li><strong>Card Title</strong> (Mandatory) - Select the column from the table or view to use as the title for the card.</li>',
'  <li><strong>Description Column</strong> (Mandatory) - Select the column from the table or view to use as the description for the card.</li>',
'  <li><strong>Additional Text Column</strong> - Select the column from the table or view to use as the secondary description for the card.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3404904849331246267)
,p_name=>'CA.CARDS'
,p_message_text=>'Cards'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3405070856175412381)
,p_name=>'CA.CARDS.VIEW'
,p_message_text=>'Cards View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129924807358097534)
,p_name=>'CA.CC'
,p_message_text=>'CC'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305933134724073997)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_text=>'Change Filters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2720772664103393591)
,p_name=>'CA.CHART'
,p_message_text=>'Add Chart Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2720792603908461083)
,p_name=>'CA.CHART.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays either an area, bar, line, or pie chart.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Chart Type</strong> - Select the type of chart to display [<strong>Area</strong>, <strong>Bar</strong>, <strong>Line</strong>, <strong>Pie</strong>].</li>',
'  <li><strong>Table or View</strong> (Mandatory) - Select the database object for the chart.</li>',
'  <li><strong>Label Column</strong> (Mandatory) - Select the column from the table or view to use as the label for the chart.</li>',
'  <li><strong>Value Aggregation</strong> - Select how the value column should be displayed or aggregated<br>',
'      &nbsp;&nbsp;&nbsp;[Column Value, Sum, Count].</li>',
'  <li><strong>Value Column</strong> (Mandatory) - Select a numeric column from the table or view which is used to calculate the chart values displayed.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722683176199660378)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h3>Examples</h3>',
'<p>Review the examples for how to utilize the different <strong>Summarization</strong> types:</p>',
'<p><strong>Example 1:</strong> Display a chart on Employees with the manager''s employee number for each employee.',
'<code><ul>',
'  <li>Table or View - Select EMP.</li>',
'  <li>Label Column - Select ENAME.</li>',
'  <li>Summarization - Select <u><strong>Column Value</strong></u>.</li>',
'  <li>Value Column - Select MGR.</li>',
'</ul></code>',
'</p>',
'<p><strong>Example 2:</strong> Display a chart on Employees with the total salary for each job.',
'<code><ul>',
'  <li>Table or View - Select EMP.</li>',
'  <li>Label Column - Select JOB.</li>',
'  <li>Summarization - Select <u><strong>Sum</strong></u>.</li>',
'  <li>Value Column - Select SAL.</li>',
'</ul></code>',
'</p>',
'<p><strong>Example 3:</strong> Display a chart on Employees with the number of employees in each department.',
'<code><ul>',
'  <li>Table or View - Select EMP.</li>',
'  <li>Label Column - Select DEPTNO.</li>',
'  <li>Summarization - Select <u><strong>Count</strong></u>.</li>',
'  <li>Value Column - Select EMPNO.</li>',
'</ul></code>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184711409013830011)
,p_name=>'CA.CLIENT.ID'
,p_message_text=>'Client ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3931848816964656859)
,p_name=>'CA.CLOSE'
,p_message_text=>'Close'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(51097114481854864)
,p_name=>'CA.CLOSED'
,p_message_text=>'Closed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3628834624970853082)
,p_name=>'CA.COLUMN'
,p_message_text=>'Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935898713692867147)
,p_name=>'CA.COLUMN.1'
,p_message_text=>'Column 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935898929609870618)
,p_name=>'CA.COLUMN.2'
,p_message_text=>'Column 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921451907304958627)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_text=>'Column Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390026801759883432)
,p_name=>'CA.COMMENTS'
,p_message_text=>'Comments'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921418031609203832)
,p_name=>'CA.COMPONENT.NAME'
,p_message_text=>'Component Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921861447729181071)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_text=>'Configure Access Control'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921189270060793987)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_text=>'Configure Appearance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921191411900800568)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_text=>'<p>The appearance of your application is defined by the Theme Style.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921397652305911899)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_text=>'Configuration Options updated. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646825012651935509)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_text=>'Configuration Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621234057644591678)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_text=>'Enable or disable application features'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646825268230950532)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enables application administrators to enable or disable specific functionality within the application. This feature is useful if you select features that need additional development effort before they can be used by end users.<br>',
'This feature can also be expanded to application-specific features. If developers define additional build options and associate them with specific functionality throughout the application, then they can be added to the configuration settings for admi'
||'nistrators. For example, within the Customer Tracker App administrators can turn on or off such features as Contacts, Data Loading, Geography, and more.',
'</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Allows application functionality to be enabled and disabled</li>',
'<li>Use feature to allow selective functionality per deployment</li>',
'<li>Supports the grouping of related application settings</li>',
'<li>Enables application developers to control components using build options</li>',
'<li>Available from Administration page</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184690340593757039)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_text=>'Connect Credential Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184690646599758844)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_text=>'Connect Credential Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(670893901978008019)
,p_name=>'CA.CONTEXT'
,p_message_text=>'Context'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921935063428206817)
,p_name=>'CA.CONTRIBUTOR'
,p_message_text=>'Contributor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184718650637850656)
,p_name=>'CA.CPU.USED'
,p_message_text=>'CPU Used'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935878295891721656)
,p_name=>'CA.CREATE'
,p_message_text=>'Create'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975429714523414709)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_text=>'Creating administration page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974175639516293722)
,p_name=>'CA.CREATE.APP'
,p_message_text=>'Creating application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974911565411389030)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_text=>'Creating application computations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974178012038343010)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_text=>'Creating application icon'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974911332271387043)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_text=>'Creating application items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975289900755390741)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_text=>'Creating application processes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(710418805308096201)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_text=>'Creating application settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3108274879338177214)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_text=>'Create an Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(232262836269801979)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_text=>'Creating application roles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974178433477347065)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_text=>'Creating authorization schemes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975427059359396482)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_text=>'Creating blank page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974178217743344570)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_text=>'Creating build options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975427949754402872)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_text=>'Creating calendar page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3363922963561060287)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_text=>'Creating cards page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975427510302400084)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_text=>'Creating chart page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975429183583407386)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_text=>'Creating classic report page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975427797806401473)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_text=>'Creating dashboard page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974175247369286615)
,p_name=>'CA.CREATE.END'
,p_message_text=>'Finishing up'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3624518963432702473)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_text=>'Creating faceted search page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2978204717848121381)
,p_name=>'CA.CREATE.FEATURES'
,p_message_text=>'Creating features'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3391781818698593736)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_text=>'Creating Filtered Content Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975427233148397916)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_text=>'Creating form page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974175893097295268)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_text=>'Creating global page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975429577697413153)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_text=>'Creating home page navigation list'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975429335893410783)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_text=>'Creating interactive grid page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975428717007405619)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_text=>'Creating interactive report page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3093502464147626788)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_text=>'Creating master detail pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974178899770352749)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_text=>'Creating navigation bars'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3034950084088983278)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_text=>'Creating page group'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2978068722766114663)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_text=>'Performing translation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2978065590085061858)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_text=>'Performing translation for %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975428532600404337)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_text=>'Creating report and form page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3096937512007065559)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_text=>'Saving blue print'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974179033665354309)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_text=>'Creating shortcut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2975290481439394542)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_text=>'Creating sign in page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974174255912266882)
,p_name=>'CA.CREATE.START'
,p_message_text=>'Start'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974176094563300536)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_text=>'Creating supporting object scripts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974178651312351338)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_text=>'Creating text messages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3385748405957524703)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_text=>'Creating timeline page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3624523825618755124)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_text=>'Creating wizard page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921392704693750112)
,p_name=>'CA.CREATED'
,p_message_text=>'Created'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921392990109752323)
,p_name=>'CA.CREATED.BY'
,p_message_text=>'Created By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2717730367415961728)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_text=>'Creating Application ...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184692957177788983)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_text=>'Credential Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184717867125849687)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_text=>'Credential Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921396834686900329)
,p_name=>'CA.CURRENT.STATUS'
,p_message_text=>'Current Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2984816748850813136)
,p_name=>'CA.CUSTOM.QRY'
,p_message_text=>'Custom Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(257378415276681194)
,p_name=>'CA.CUSTOM.THEME'
,p_message_text=>'Use Custom Theme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(257672159768690707)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Switch the wizard to use a custom theme instead of the Universal Theme.</p>',
'',
'<p>Select a Workspace Theme for the application. If the theme supports Theme Styles, then the style can also be selected.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106076891433259654)
,p_name=>'CA.CUSTOM_THEME'
,p_message_text=>'Custom Theme'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3021097598749298066)
,p_name=>'CA.DASHBOARD'
,p_message_text=>'Add Dashboard Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(657370579407842769)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_text=>'Chart %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3021097738613299739)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a dashboard page with multiple charts.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  </ul>',
'</ul>',
'&nbsp;<br>',
'<p>Each chart (Chart 1, Chart 2, Chart 3, and Chart 4) defaults to different chart types and is based on <em>Sample Data</em>. ',
'  As such you do not need to enter any further details to add this page.',
'  However, you can customize each chart be replacing the default values wih your own selections.<br>',
'  To customize a chart enter the following attributes:</p>',
'<ul>',
'  <li><strong>Chart Name</strong> (Mandatory) - Enter the name for the chart.</li>',
'  <li><strong>Chart Type</strong> - Select the type of chart to display [<strong>Area</strong>, <strong>Bar</strong>, <strong>Line</strong>, <strong>Pie</strong>].</li>',
'  <li><strong>Table or View</strong> (Mandatory) - Select the database object for the chart.</li>',
'  <li><strong>Label Column</strong> (Mandatory) - Select the column from the table or view to use as the label for the chart.</li>',
'  <li><strong>Value Aggregation</strong> - Select how the value column should be displayed or aggregated<br>',
'      &nbsp;&nbsp;&nbsp;[Column Value, Sum, Count].</li>',
'  <li><strong>Value Column</strong> (Mandatory) - Select a numeric column from the table or view which is used to calculate the chart values displayed.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390018403696804042)
,p_name=>'CA.DATATYPE'
,p_message_text=>'Data Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390023045002834607)
,p_name=>'CA.DATEFORMATMASK'
,p_message_text=>'Date Format Mask'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921410575114006885)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_text=>'Default Time Zone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921412991886040815)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_text=>'Default time zone updated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3052392075133524538)
,p_name=>'CA.DEFAULTS'
,p_message_text=>'Application Attribute Defaults'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3052393369990606396)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_text=>'This JSON document allows for fine grain control over the generation of report and form columns names, format masks etc.  You can also define lists of values and other shared components. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3503659197691398606)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_text=>'List of Values Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3503659329568401157)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Add a list of values (LOV) attribute. LOVs can be used in table column definitions.</p>',
'<p>Enter the following attributes:',
'  <ul>',
'    <li><strong>Name</strong> (Mandatory) - Enter the name for the list of values.</li>',
'    <li><strong>Type</strong> - Select the list of values type [Structured, Dynamic, Static].<br>',
'      For Type of <u>Structured</u> - ',
'      <ul>',
'          <li><strong>Table</strong> (Mandatory) - Select the table or view to base the list of values on.</li>',
'          <li><strong>Display Column</strong> (Mandatory) - Select the column to display to end users.</li>',
'          <li><strong>Key Column</strong> (Mandatory) - Select the column value to return. This is generally the primary key for the table.</li>',
'      </ul>',
'      &nbsp;<br>',
'      For Type of <u>Dynamic</u> -',
'      <ul>',
'          <li><strong>SQL Query</strong> (Mandatory) - Enter a valid SQL select statement that returns two values (display value and return value).</li>',
'      </ul>',
'      &nbsp;<br>',
'      For Type of <u>Static</u> -',
'      <ul>',
'          <li><strong>Static List of Values</strong> (Mandatory) - Enter a valid static list of the form:',
'          <ul>',
'            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>List displayed in the order entered</li>',
'            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>List ordered alphabetically</li>',
'            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>Display value and return value the same</li>',
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3639060884968310767)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_text=>'Report Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3639061093818312202)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edit the attributes for all reports.</p>',
'<p>Enter the following attributes:',
'  <ul>',
'    <li><strong>Rows Per Page</strong> - Enter the number of report rows to display by default.</li>',
'    <li><strong>Pagination Method</strong> - Select how report pagination will be displayed.</li>',
'    <li><strong>Numeric Format Mask</strong> - Enter the format mask to apply to number columns and items.</li>',
'    <li><strong>Date Format Mask</strong> - Enter the format mask to apply to date columns and items.</li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3636987998735639033)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_text=>'Table Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3635989190637543353)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_text=>'Table Column Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3635994429757612321)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edit the attributes for the selected table column.</p>',
'<p>Enter the following attributes:',
'  <ul>',
'    <li><strong>Table</strong> (Display Only) - The associated table.</li>',
'    <li><strong>Column</strong> (Display Only) - The column that the attributes are defined against.</li>',
'    <li><strong>Label</strong> - Enter the label to use in report headings and form labels.</li>',
'    <li><strong>Form Control</strong> - Select the item type to use on forms.</li>',
'    <li><strong>List of Values</strong> - Select an existing List of Values to use to display user friendly names as appropriate.</li>',
'    <li><strong>Format Mask</strong> - Enter an appropriate format mask based on the column type (text, number, date, and so forth).</li>',
'    <li><strong>Static Default Value</strong> - Enter a text default value for the column.</li>',
'    <li><strong>Include on Forms</strong> - Click Yes if the column should be included on forms.</li>',
'    <li><strong>Include on Reports</strong> - Click Yes if the column should be included on reports.</li>',
'    <li><strong>Required</strong> - Click Yes if data must be entered into this column on forms.</li>',
'    <li><strong>Help</strong> - Enter help text that is added to the item help attribute.</li>',
'  </ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3636988189411640116)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Edit the attributes for the selected table.</p>',
'<p>Enter the following attributes:',
'  <ul>',
'    <li><strong>Table</strong> (Display Only) - The associated table.</li>',
'    <li><strong>Label, Singular</strong> (Mandatory) - Enter the label to use on form pages.</li>',
'    <li><strong>Label, Plural</strong> (Mandatory) - Enter the label to use in region headings and page names.</li>',
'    <li><strong>Primary Display Column</strong> - Select the first column to display, for example in card regions.</li>',
'    <li><strong>Secondary Display Column</strong> - Select the second column to display, for example in card regions.</li>',
'    <li><strong>Primary Key Column</strong> - Select the unique primary key column for the table.</li>',
'    <li><strong>Description</strong> - Enter a description for the table.</li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184691961294765624)
,p_name=>'CA.DEFERRED.DROP'
,p_message_text=>'Deferred Drop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390024443305853537)
,p_name=>'CA.DEFINITION'
,p_message_text=>'Definition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2939102544288551506)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_text=>'Deinstallation complete.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921243510178096153)
,p_name=>'CA.DELETE'
,p_message_text=>'Delete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2939100809220509997)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_text=>'Would you like to perform this delete action?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2647192229855853394)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_text=>'Are you sure you want to delete this page?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922145937187621898)
,p_name=>'CA.DELETE.PHOTO'
,p_message_text=>'Delete Photo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921315510019364314)
,p_name=>'CA.DESCRIPTION'
,p_message_text=>'Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935891867249795744)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_text=>'Desktop Navigation Bar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935890832413787232)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_text=>'Desktop Navigation Menu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921194181113900856)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_text=>'Desktop Theme Style'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921194344438905421)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_text=>'The default Theme Style applies to all users.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184693322210790821)
,p_name=>'CA.DESTINATION'
,p_message_text=>'Destination'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184693528489791916)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_text=>'Destination Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106119013745756930)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_text=>'Dialog Buttons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922446556500839801)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_text=>'Dispatch Emails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3352231935537078117)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_text=>'Determines whether emails should be sent out from the Email Framework.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921269318491672617)
,p_name=>'CA.DISPLAY.FROM'
,p_message_text=>'Display From'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921269156969666950)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_text=>'Display Sequence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921269572902675399)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_text=>'Display Until'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390018865083807380)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_text=>'Display Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921423432814333455)
,p_name=>'CA.DISTINCT .USERS'
,p_message_text=>'Distinct Users'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935881616764748047)
,p_name=>'CA.DOWNLOAD'
,p_message_text=>'Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3035873878412250184)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_text=>'Drag to reorder page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(110394392780365303)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
'  <li><strong>Drill Down Link</strong> - Expand to see attributes for defining a drill down link.',
'&nbsp;<br>',
'    <em><strong>Note:</strong> Drill Down Link only appears if the current page is based on a table or view and has a report type of Interactive Report, and you have defined a report (Interactive Report) or a master detail (Master Detail) page.</em>',
'  <ul>',
'    <li><strong>Link Column</strong> - Select the column to change to a link column in the report.</li>',
'    <li><strong>Link Key</strong> - Select the link key (foreign key) column used to identify the specific record in the page being linked to.</li>',
'    <li><strong>Link to Page</strong> - Select the report or form page that the link navigates to.</li>',
'    <li><strong>Target Key</strong> - Select the target key (primary key) column from the table that the report page, that the link navigates to and is based on.',
'  </ul>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921417470815198164)
,p_name=>'CA.ELAPSED'
,p_message_text=>'Elapsed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2671540709864246637)
,p_name=>'CA.EMAIL'
,p_message_text=>'Email Framework'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3350901500303395171)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_text=>'Email Addresses'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3739449055677845738)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_text=>'Default'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2671540444507243498)
,p_name=>'CA.EMAIL.DESC'
,p_message_text=>'Add ability to configure and send emails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2671540976528256725)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Include the ability to send emails from your application. Using the example email template, send professional looking emails to users. The emails sent are logged so that administrators can keep track of email activity.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Extensible HTML Email template system</li>',
'<li>PL/SQL package for sending mail via APEX packages</li>',
'<li>Logging of email activity and status</li>',
'<li>Administrative UI to manage templates</li>',
'<li>Administrative UI to view email logs</li>',
'<li>Administrative UI to send emails</li>',
'</ul>',
'</p>',
'<p><em>Note: This feature will be enabled when Feedback is selected</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390859682915675372)
,p_name=>'CA.EMAIL.FROM'
,p_message_text=>'Email From'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922439519597770694)
,p_name=>'CA.EMAIL.LOG'
,p_message_text=>'Email Log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3767022200183606826)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_text=>'Email setting details required.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3760905119087160301)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_text=>'From Address is not a valid email.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3388520364122380768)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_text=>'From Address is not a valid email.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3353767397093620646)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_text=>'Email processed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129926256783106143)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_text=>'Email Reporting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(234215567763914736)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_text=>'Report of all email queued to be sent and those already sent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922446340050833283)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_text=>'Email Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922454998629926366)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_text=>'Email settings updated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3400496899899092919)
,p_name=>'CA.EMAIL.STATUS'
,p_message_text=>'Email Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922455213995930769)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_text=>'Email Template Details'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(481856201298619432)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_text=>'Scheduled Outage for #SERVICE_NAME#'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(262724643767207906)
,p_name=>'CA.EMAIL2'
,p_message_text=>'Email'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922439326309766645)
,p_name=>'CA.EMAILS.SENT'
,p_message_text=>'Emails Sent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3760906388661232426)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_text=>'Enable Attachments'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184713248642837561)
,p_name=>'CA.ENABLED'
,p_message_text=>'Enabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184701022555811514)
,p_name=>'CA.END.DATE'
,p_message_text=>'End Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922456858628964211)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_text=>'After Rows Content'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3207347751119292418)
,p_name=>'CA.ENTER.USERNAME'
,p_message_text=>'Enter usernames here'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921418733860210549)
,p_name=>'CA.ERROR'
,p_message_text=>'Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921453065781966085)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_text=>'Error Backtrace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921452866471962209)
,p_name=>'CA.ERROR.CODE'
,p_message_text=>'Error Code'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921450342033943642)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_text=>'Error Message'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184723655639857031)
,p_name=>'CA.ERROR.NUMBER'
,p_message_text=>'Error Number'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184714990123843872)
,p_name=>'CA.ERRORS'
,p_message_text=>'Errors'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184706076858815927)
,p_name=>'CA.EVENT.CONDITION'
,p_message_text=>'Event Condition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184707255429817260)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_text=>'Event Queue Agent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184707449591818273)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_text=>'Event Queue Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184707695219819290)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_text=>'Event Queue Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184705747231815059)
,p_name=>'CA.EVENT.RULE'
,p_message_text=>'Event Rule'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3207348597027306223)
,p_name=>'CA.EXCEPTIONS'
,p_message_text=>'Exceptions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3966760498355221622)
,p_name=>'CA.EXPERIENCE'
,p_message_text=>'Experience'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184712688908835181)
,p_name=>'CA.FAILURE.COUNT'
,p_message_text=>'Failure Count'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921395473639888511)
,p_name=>'CA.FEATURE'
,p_message_text=>'Feature'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(561195827579186579)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_text=>'Application Version'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(561196076362226278)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_text=>'Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305936502942156065)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_text=>'Add Users to Access Control List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305934807138124786)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_text=>'Go To Next Step'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305935959311136574)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_text=>'Create Collections'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305933494274094984)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_text=>'Cannot change the last administrator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(561194921446129497)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_text=>'Last Activity'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305932508063063298)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_text=>'No activities found'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(561195648695158233)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_text=>'Reason'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305937462914177580)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_text=>'At least One Feedback Required'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(306083508867274967)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_text=>'Get File ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305007294530755768)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_text=>'Save Theme Style'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305007428270760100)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_text=>'Save End User Style Preference'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(561195176647134446)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_text=>'Username'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2720709756240298547)
,p_name=>'CA.FEATURES'
,p_message_text=>'Features'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2720710407905304212)
,p_name=>'CA.FEATURES.DESC'
,p_message_text=>'Features provide application-level functionality and are typically added once per application. Choose features to include with your application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646824705764929499)
,p_name=>'CA.FEEDBACK'
,p_message_text=>'Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621228749364562962)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_text=>'Allow users to provide feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646821110719623802)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Provide a mechanism for end users to post general comments back to the application administrators and developers. The posts include useful session state information to help determine where the end user sent the feedback from. Providing such an eas'
||'y feedback loop enhances communication between the user community and the application owners, which leads to greatly improved end user satisfaction.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Ability for end users to leave feedback by clicking on a navigation bar icon</li>',
'<li>Administrative report for viewing and updating feedback</li>',
'<li>Feedback will capture the user, date and time, and user agent information</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3966762365367350420)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_text=>'Please provide feedback or your experience.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3761377816500363838)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_text=>'Send To'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3739423828750477590)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_text=>'Feedback Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922385185869439518)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_text=>'Feedback settings updated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3785661030236089620)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_text=>'Feedback Submitted'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184704061824812867)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_text=>'File Watcher Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184704728813814393)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_text=>'File Watcher Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(63498757191799437)
,p_name=>'CA.FILED'
,p_message_text=>'Filed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(63498989612801416)
,p_name=>'CA.FILED.BY'
,p_message_text=>'Filed By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3404904320926232993)
,p_name=>'CA.FILTER.REPORT'
,p_message_text=>'Filter Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922457869659993430)
,p_name=>'CA.FILTERS'
,p_message_text=>'Filters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3628792688080383632)
,p_name=>'CA.FINISH'
,p_message_text=>'Finish'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922146699005630764)
,p_name=>'CA.FIRST.NAME'
,p_message_text=>'First Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184691347946762229)
,p_name=>'CA.FLAGS'
,p_message_text=>'Flags'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722695911234992491)
,p_name=>'CA.FORM'
,p_message_text=>'Add Form Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722695767589991082)
,p_name=>'CA.FORM.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays a form page to enable end users to maintain data.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Table</strong> (Mandatory) - Select the table for the form.</li>',
'<li><strong>Include Report</strong> (Mandatory) - Select this option to create a report and form. The first page is an interactive report. Each row provides a link to a form where users can update the record. </li>',
'  &nbsp;<br>',
'<li><strong>Advanced</strong> - Expand to see advanced options.',
'     <ul>',
'      <li><strong>Page Help</strong> - Enter text to be added to the Help Text for the page.</li>',
'      </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109862772238948209)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_text=>'Form Items Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935888332193771559)
,p_name=>'CA.FORM.ON'
,p_message_text=>'Form on %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3206409487718057694)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_text=>'The form type is not a valid type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390025418889861472)
,p_name=>'CA.FORMATMASK'
,p_message_text=>'Format Mask'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390023206494838483)
,p_name=>'CA.FORMCONTROL'
,p_message_text=>'Form Control'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921392351593745165)
,p_name=>'CA.FROM'
,p_message_text=>'From'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922446820735842211)
,p_name=>'CA.FROM.ADDRESS'
,p_message_text=>'From Address'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390858037266661839)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_text=>'"From Address" Email Setting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3387540893130642366)
,p_name=>'CA.FROM.EMAIL'
,p_message_text=>'From Email'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3387540699161641470)
,p_name=>'CA.FROM.WHO'
,p_message_text=>'From Who'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(567275634790675126)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_text=>'%0 Search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921449149049921504)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_text=>'Full Page Views'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922442837744801280)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_text=>'Full Template HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390022169332822845)
,p_name=>'CA.FUNCTION'
,p_message_text=>'Function'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646825640139962257)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_text=>'Global Search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621233646828586613)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_text=>'Provide application search capability'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646825422944960553)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Allow end users to search for text across key tables or views within the application. The advanced search page includes filters to make it simple for end users to narrow down the results.<br>',
'This very powerful feature does require some development effort to define the SQL (based on provided examples).</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Displays a search icon in the header bar</li>',
'<li>Includes a detail search results page with side bar filter</li>',
'<li>Requires developer implement the SQL to define the App search</li>',
'<li>Includes sample data for illustration</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184711224596829124)
,p_name=>'CA.GLOBAL.UID'
,p_message_text=>'Global Unique ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(304941654983395022)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_text=>'Global Page - Desktop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106119350254774772)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_text=>'Go To Admin Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722692398960864407)
,p_name=>'CA.GRID'
,p_message_text=>'Add Interactive Grid Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722692521388865538)
,p_name=>'CA.GRID.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays as an interactive grid which is similar to a spreadsheet. When editable, users can edit multiple rows directly on the page (that is, when Allow Editing is enabled).</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Query Type</strong> - Select the source for the report [<strong>Table or View</strong> or <strong>SQL Query</strong>].<br>',
'    <strong>Table or View</strong>:',
'    <ul>',
'      <li><strong>Table or View</strong> (Mandatory) - Select the database object for the grid.</li>',
'    </ul>',
'    <strong>SQL Query</strong>:',
'    <ul>',
'      <li><strong>SQL Query</strong> (Mandatory) - Enter a valid SQL statement which returns distinct columns.</li>',
'    </ul>',
'  </li>',
'  <li><strong>Grid Type</strong> - Select if users can edit the rows in the grid [<strong>Allow Editing</strong> or <strong>Read Only</strong>]. To enable editing, select <strong>Allow Editing</strong>.</li>',
'  &nbsp;<br>',
'  <em><strong>Warning:</strong> If you select a Query Type of <strong>SQL Query</strong> plus a Grid Type of <strong>Allow Editing</strong> and your query joins two or more tables, then the interactive grid generated will fail when users try and upda'
||'te records.',
'Also, if you select Grid Type of <strong>Allow Editing</strong> and the query (or selected Table or View) uses a view that is not updateable, then the Interactive Grid generated will fail when users try and update records.</em><br>',
'  </li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922460172950046745)
,p_name=>'CA.HELP'
,p_message_text=>'Help'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921934660894202889)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_text=>'Choose <strong>No</strong> if all users are defined in the access control list. Choose <strong>Yes</strong> if authenticated users not in the access control list may also use this application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921400789661964062)
,p_name=>'CA.HELP.APP.NAME'
,p_message_text=>'The text entered here is used throughout the application, most notably, in the upper left-hand corner of every page. The change will take effect immediately for the administrator making the change, but other users will only see the change when they g'
||'et a new session (e.g. at next login).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2885894799020330828)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_text=>'<p>Click the feedback icon ( <span class="fa fa-comment-o" aria-hidden="true"></span> ) in the navigation bar, from any page in the application, to leave feedback for the application administrators.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2885894141152310496)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_text=>'<p>This is the home page of the application. Click on the cards to access different pages in the application, or use the navigation menu on the side of the page.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2885894503977315342)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_text=>'<p>This is the home page of the application. Click on the cards to access different pages in the application, or use the navigation menu at the top of the page.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2885894911225351459)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_text=>'<p>Enter a search term in to the <strong>Search Application</strong> field on this page, or click the search icon ( <span class="fa fa-search" aria-hidden="true"></span> ) in the navigation bar from any page, to search for the term within your applic'
||'ation.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2885895784447393918)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_text=>'<p>Click your name dropdown in the navigation bar to sign out of the application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2885895335593384290)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_text=>'<p>Click the user menu ( <span class="fa fa-user" aria-hidden="true"></span> ) in the navigation bar to update your time zone preference, and sign out of the application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2885894331206312070)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_text=>'Home Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2885896091182396660)
,p_name=>'CA.HELP.HOME.USER'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Click the user menu ( <span class="fa fa-user" aria-hidden="true"></span> ) in the navigation bar (top right of the page) to access your user profile, and sign out of the application.<br>',
'If you click <strong>View My Profile</strong> you can then click <strong>Update Profile</strong> to enter your personal details and upload a photo or avatar.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2885895157473382298)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Click the user menu ( <span class="fa fa-user" aria-hidden="true"></span> ) in the navigation bar to access your user profile, update your time zone preference, and sign out of the application.<br>',
'If you click <strong>View My Profile</strong> you can then click <strong>Update Profile</strong> to enter your personal details and upload a photo or avatar.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2986105093693789094)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>To find data enter a search term into the search dialog, or click on the column headings to limit the records returned.</p>',
'',
'<p>You can perform numerous functions by clicking the <strong>Actions</strong> button. This includes selecting the columns that are displayed / hidden and their display sequence, plus numerous data and format functions.  You can also define an additi'
||'onal view of the data using the chart option.</p>',
'',
'<p>If you want to save your customizations select report, or click download to unload the data.<p>',
'<br>',
'<p>For additional information click Help at the bottom of the Actions menu.</p> ',
'',
'<p>Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2985284595924932808)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can insert, update, and delete data directly within this interactive grid.<br>',
'  Insert a new row by clicking the Add Row button.<br>',
'  Double click into a cell, or click the <strong>Edit</strong> button to update data values, similar to editing data in a spreadsheet.</p>',
'',
'<p>Use the Row Actions menu ( <span class="fa fa-bars" aria-hidden="true"></span> ) at the top of the report to duplicate, delete, refresh or revert selected rows.<br> ',
'  Use the Row Actions menu on individual rows to also access the single row view or add a new row.</p>',
'',
'<p>To find data enter a search term into the search dialog, or click on the column headings to limit the records returned.</p>',
'',
'<p>You can perform numerous functions by clicking the <strong>Actions</strong> button. This includes selecting the columns that are displayed / hidden and their display sequence, plus numerous data and format functions.  You can also define an additi'
||'onal view of the data using the chart option.</p>',
'',
'<p>If you want to save your customizations select report, or click download to unload the data.<p>',
'',
'<p>For additional information click Help at the bottom of the Actions menu.</p> ',
'',
'<p>Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2885093087026229212)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>To find data enter a search term into the search dialog, or click on the column headings to limit the records returned.</p>',
'',
'<p>You can perform numerous functions by clicking the <strong>Actions</strong> button. This includes selecting the columns that are displayed / hidden and their display sequence, plus numerous data and format functions.  You can also define additiona'
||'l views of the data using the chart, group by, and pivot options.</p>',
'',
'<p>If you want to save your customizations select report, or click download to unload the data. Enter you email address and time frame under subscription to be sent the data on a regular basis.<p>',
'',
'<p>For additional information click Help at the bottom of the Actions menu.</p> ',
'',
'<p>Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3209928781454624792)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This report page displays primary records in a selector on the side of the page. ',
'  Select a record to see the master record and any detail records defined.<br> ',
'  Click the edit icon ( <span class="fa fa-pencil-square-o" aria-hidden="true"></span> ) to edit the master record.',
'  For detail records, click the pencil, at the beginning of each row, to edit that record.</p>',
'<p>To limit the data displayed in the selector enter a search term into the search dialog.</p>',
'',
'<p>To add a new master record click <strong>Create</strong> at the top of the page.',
'  For detail records, click the plus icon ( + ) at the top of the detail region to add a detail record.</p>',
'',
'<p>Click <strong>Reset</strong> at the top of the page to reset the page back to the default settings, removing any search term previously defined.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2815566880196749620)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The administration page allows application owners (Administrators) to configure the application and maintain common data used across the application.',
'By selecting one of the available settings, administrators can potentially change how the application is displayed and/or features available to the end users.</p>',
'<p>Access to this page should be limited to Administrators only.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826976181712610040)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select the appropriate choice for any authenticated users.<br> ',
'Selecting <strong>No</strong> makes the application more secure as only specified users can access the application. ',
'However, if your application has a large user community then maintaining users may be onerous, and you may prefer to choose <strong>Yes</strong> and only enter application Administrators, and possibly Contributors.<br>',
'If you select <strong>Yes</strong> then you must also select how users not included in the users list are treated.</p>',
'<p>Select between requiring email addresses and any alphanumeric value for Usernames.<br>',
'Generally, you should set this setting to <strong>E-mail Address</strong> if your application uses (or will be configured to use) a centralized authentication scheme such as Oracle Access Manager, or SSO.</p>',
'<p><em><strong>Note:</strong> This application supports the following 3 access levels: Reader, Contributor, and Administrator.',
'<ul>',
'  <li><strong>Readers</strong> have read-only access to all information and can also view reports.</li>',
'  <li><strong>Contributors</strong> can create, edit and delete information and view reports.</li>',
'  <li><strong>Administrators</strong>, in addition to Contributors capability, can also perform configuration of the application by accessing the Administration section of the application.</li>',
'</ul>',
'</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826976581162615244)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this form to enter users, their email address and set their access level. ',
'The settings defined under <em>Configure Access Control</em> will determine whether the username must be their email address or can be any alphanumeric entry.</p>',
'<p>This application supports the following 3 access levels: Reader, Contributor, and Administrator.</p>',
'<ul>',
'  <li><strong>Readers</strong> have read-only access to all information and can also view reports.</li>',
'  <li><strong>Contributors</strong> can create, edit and delete information and view reports.</li>',
'  <li><strong>Administrators</strong>, in addition to Contributors capability, can also perform configuration of the application by accessing the Administration section of the application.</li>',
'</ul>',
'<p>When editing an existing user you can lock their account which will prevent them from accessing the application.</p>',
'<p><em><strong>Note:</strong>   If using Oracle Application Express accounts then users entered here must also be defined as end users by a Workspace Administrator, who can also set their password.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826976342638612479)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page shows a report of the application users and the access level granted.</p>',
'<p>Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features.<br>',
'Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>',
'<p>Click the edit icon (yellow pencil) to edit the user details and access level, or to delete the user.</p>',
'<p>Click <strong>Add User</strong>, at the top of the report, to add a new user and their access level.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922004835723286611)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When Access Control is enabled, Administrators have the ability to restrict access to certain application features for authenticated users. This application supports the following 3 roles: Reader, Contributor, and Administrator.<p>',
'<ul>',
'  <li><strong>Readers</strong> have read-only access to all information and can also view reports.</li>',
'  <li><strong>Contributors</strong> can create,edit and delete information and view reports.</li>',
'  <li><strong>Administrators</strong>,in addition to Contributors capability,can also perform configuration of the application.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3207347434988285326)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_text=>'Enter usernames separated by commas, semicolons, or whitespace. Existing or duplicate usernames will automatically be ignored.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2825367579878446008)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Configuration settings allow you to make specific functionality either available (enabled) or unavailable (disabled) to end users.</p>',
'<p>If a specific function is not 100% ready, or needs to be temporarily removed, click <strong>Disabled</strong>. ',
'Once it should be made available, simply click <strong>Enabled</strong>.</p>',
'<p><em><strong>Note:</strong> Changes made here will not be reflected for individual end users currently running the application. Once the end user signs out and then signs back in the revised feature settings will be invoked.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826423433179501985)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select the default color scheme used to display the application.</p>',
'<p>If <strong>Allow End Users to choose Theme Style</strong> is checked, then each end user can select from the available theme styles by clicking the <em>Customize</em> link in the bottom left corner of the Home page.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826830998694577812)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of all unexpected errors logged by this application.</p>',
'<p>Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features. Click the <strong>Reset</strong> button to reset the interactive report back t'
||'o the default settings.</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826830096634558140)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use this report and chart to see the users with the most page views for the specified timeframe.</p>',
'<p>Select the reporting timeframe (Default = 1 day) and choose between the report and chart icons at the top of the page.</p>',
'<p>For the interactive report, use the search field, or select the <strong>User</strong> column heading, to select a specific user. You can perform numerous functions by clicking the <strong>Actions</strong> button, such as columns displayed / hidden'
||', rows per page, filter, and so forth. Click the <strong>Reset</strong> button to reset the interactive report back to the default settings.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826831104027582004)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of the page performance and popularity. The report is ordered by <strong>Weighted Performance</strong> which is calculated by multiplying the Median Elapsed time and number of Page Views.</p>',
'<p>Select the reporting timeframe (Default = 1 day) at the top of the page as necessary.<br>',
'Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features. Click the <strong>Reset</strong> button to reset the interactive report back to t'
||'he default settings.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826831322945585747)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page provides an interactive report of the most recent page views.</p>',
'<p>Select the reporting timeframe (Default = 1 day) at the top of the page as necessary.<br>',
'Click on the column headings to sort and filter data, or click on the <strong>Actions</strong> button to customize column display and many additional advanced features. Click the <strong>Reset</strong> button to reset the interactive report back to t'
||'he default settings.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2825217243422439757)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Notifications are displayed on the home page when active.</p>',
'<p>This report shows the notifications defined and the time period when they are displayed.</p>',
'<p>Click the edit icon (yellow pencil) to edit an existing notification or click <strong>Add Notification</strong> to insert a new notification.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826423921463504398)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the application name and short description for the application.</p>',
'<p>The application name is displayed on home page. The short description is displayed below the application name.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826826501142523824)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Feedback can be entered by end users from any normal page within the application.</p>',
'<p>This report shows the feedback entered, any response enter by administrators, and the status of the feedback.</p>',
'<p>Click the edit icon (yellow pencil) to enter a response or update the feedback status.</p>',
'<p><em><strong>Note:</strong> If feedback recipients have been defined then feedback submissions will also be emailed to the email addresses in the feedback recipients list.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922384937268434693)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_text=>'Provide a comma-separated list of the email addresses.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826827842013539431)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_text=>'<p><strong>Enable Attachments</strong> - If yes, users will be able to upload an attachment in support of their feedback.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2827122248767651394)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page lists the email templates defined and how many times the template has been referenced in emails sent.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2827121313728645843)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page lists the emails sent.</p>',
'<p>Click the Magnifying Glass icon to view more details on the emails sent.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2827121708983648776)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the following fields to define an email template:</p>',
'<ul>',
'  <li><strong>Template Name</strong> (Mandatory) - Enter a meaningful name for the template.</li>',
'  <li><strong>HTML Template</strong> (Mandatory) - Enter the HTML code used to construct the email sent to recipients that allow the delivery of HTML-based emails.',
'    Substitution values include:',
'    <ul>',
'        <li><strong>#APP_NAME#</strong> - will be replaced by the name of the application</li>',
'        <li><strong>#BODY1#</strong> - will be replaced by the value passed in as p_body1_text</li> ',
'        <li><strong>#TABLE#</strong> - will be replaced by the value passed in as p_table_content, using the the Table Open HTML, Table Row HTML and Table Close HTML</li> ',
'        <li><strong>#BODY2#</strong> - will be replaced by the value passed in as p_body2_text</li> ',
'        <li><strong>#ACTION#</strong> - will be replaced by the value passed in as p_action_label and p_action_link, using the Action Link template</li>',
'     </ul></li>',
'  <li><strong>Plain Text Template</strong> (Mandatory) - Enter the plain text used to construct the email sent to recipients that do not accept HTML-based emails.  This uses the same substitutions as the HTML Template except the #TABLE# and #ACTION# '
||'will be rendered as plain text.</li>',
'<ul>',
'<p>Additional HTML Templates allow for more advanced emails.  These items include:</p>',
'<ul>',
'  <li><strong>Before Rows</strong> - Enter HTML to replace #TABLE# in the HTML Template.  Only used if p_table_content is passed.</li>',
'  <li><strong>Row Template</strong> - Enter HTML to render each row of the table.  This includes the row open/close and data open/close using the #LABEL# and #VALUE# substitutions.    Only used if p_table_content is passed.</li>',
'  <li><strong>After Rows</strong> - Enter HTML to close the table or div.  Only used if p_table_content is passed.</li>',
'  <li><strong>Action Link HTML</strong> - Enter HTML to replace #ACTION# in the HTML Template.  It should contain #ACTION_LINK# and #ACTION_TEXT#.  Only used if p_action_label and p_action_link are passed.</li>',
'</ul>',
'<p><em><strong>Note:</strong> Use the entries within the <strong>default template</strong> as an example for developing your own template. The default template uses all of the substitution variables which you may or may not want to include within you'
||'r own email template.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2827122660400653788)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enable or disable the sending of emails by selecting one of the <strong>Dispatch Emails</strong> options.</p>',
'<p>Enter the <strong>Emails Sent From</strong> using the email address of the primary contact for application issues.  This value can be used or overwritten when using the email feature.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922447627444850849)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_text=>'This is the from address that will be used to send emails. It can be overwritten when using the email feature.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3310998165895557234)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Populate the following items and click [Send Email].  All emails sent are logged in the Email Log.',
'    <ul>',
'        <li><strong>From</strong> - If a "From Address" is set within Email Settings, that email address will be an option to send from.  If this application uses Email Addresses as username, you can select to send emails from your email.  Lastly, yo'
||'u can always have the Send From be the same as the Send To.</li>',
'        <li><strong>Send To</strong> - If this application uses Email Addresses as username, you can select to send emails to Email Addresses and/or Users.</li>',
'        <li><strong>Email Addresses</strong> - Comma separated list of email addresses to receive the email. Those found to be invalid, will not be included.</li>',
'        <li><strong>Role</strong> - Send email to all users of a selected role or to all defined users.  Select list includes a list of roles and the count of users within that role.</li>',
'        <li><strong>Template</strong> - Select the email template to use to create the body of the email.</li>',
'        <li><strong>Subject</strong> - The subject of the email.</li>',
'        <li><strong>Email Body</strong> - Text to be included as the body of the email.</li>',
'        <li><strong>Allow Opt Out</strong> - Some emails should be sent regardless of the user opting out of receiving emails. These include outage messages, etc. This flag identifies if this email should be allowed to be opted out of or if it should'
||' be sent regardless of the user''s preference.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3362798694332746063)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Populate the following items and click [Send Email].  All emails sent are logged in the Email Log.',
'    <ul>',
'        <li><strong>From</strong> - If a "From Address" is set within Email Settings, that email address will be an option to send from.  Otherwise, you can always have the Send From be the same as the Send To.</li>',
'        <li><strong>Email Addresses</strong> - Comma separated list of email addresses to receive the email. Those found to be invalid, will not be included.</li>',
'        <li><strong>Template</strong> - Select the email template to use to create the body of the email.</li>',
'        <li><strong>Subject</strong> - The subject of the email.</li>',
'        <li><strong>Email Body</strong> - Text to be included as the body of the email.</li>',
'        <li><strong>Allow Opt Out</strong> - Some emails should be sent regardless of the user opting out of receiving emails. These include outage messages, etc. This flag identifies if this email should be allowed to be opted out of or if it should'
||' be sent regardless of the user''s preference.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2826825625683510454)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select the default time zone for all users of this application.</p>',
'<p>Individual users can override this setting by clicking their user name (top right) and selecting <strong>Preferences</strong>. Alternatively, they can click the time zone link displayed at the bottom of the home page.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922151157122767119)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_text=>'This page is not accessible directly through the UI. It is used to facilitate profile photo downloading.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922148619304676217)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_text=>'The User Profile Page allows you to see relevant information about a user in one easy to use screen.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922147937487653460)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_text=>'Please upload a photo with a square aspect ratio otherwise it may be distorted. The preferred image size is 250x250 pixels.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2845154884735575084)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This form allows you to update your personal details and upload a photo or avatar.</p>',
'<p>To upload an image, click <strong>Browse</strong> or drag and drop the image over the button.<br>',
'Please upload a photo with a square aspect ratio otherwise it may be distorted. The preferred image size is 250x250 pixels.</p>',
'<p>Click <strong>Delete Photo</strong> to remove the image.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922460710567062320)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_text=>'All application help text can be accessed from this page. The links in the "Documentation" region give a much more in-depth explanation of the application''s features and functionality.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2919482571627912253)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_text=>'You can set application preferences for your account from this page. The preferences can affect several aspects of the application such as time zone. Click the item-level help icons to learn what each preference does.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129926839055109215)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_text=>'<p>This report shows all email queued to be sent and those already sent.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184690119298754624)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_text=>'<p>This report includes all the jobs selected to be monitored by this application.  More details of each job can be viewed by clicking on the job name.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184714203018842404)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_text=>'<p>This report includes the run details about the jobs selected to be monitored by this application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621228429576558138)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_text=>'Add about this application page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2920780735107596548)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_text=>'Set this option to No if you do not want to receive emails from this application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3214738171028737188)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter a search term into the search dialog and click <strong>Search</strong>.<br>',
'Click on any of the result headings to navigate to that specific record.</p>',
'<p>To limit the search uncheck one or more Sources, which removes that report from the search results.</p>',
'<p>Click <strong>Reset</strong> to remove the current search term and check all Sources.</p> '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2920779829770579930)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_text=>'Set your preferred time zone for use throughout the application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109929974733353866)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_text=>'Hidden Items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935892872459804960)
,p_name=>'CA.HOME'
,p_message_text=>'Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3035873643356247183)
,p_name=>'CA.HOME.PAGE'
,p_message_text=>'Home Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3431138501538994244)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_text=>'Hourly Page Events'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129923857503088605)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_text=>'HTML Body Size'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922455608816950097)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_text=>'HTML Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922403438085948059)
,p_name=>'CA.IN.PROGRESS'
,p_message_text=>'In Progress'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390023617312842111)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_text=>'Include on Forms'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390023464598840999)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_text=>'Include on Reports'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2974177521902325138)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_text=>'Installing supporting object scripts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184692122033767485)
,p_name=>'CA.INSTANCE.ID'
,p_message_text=>'Instance ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184695173855799041)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_text=>'Instance Stickiness'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2762518213840408889)
,p_name=>'CA.INTRO.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Welcome to this cloud-only preview of a new and improved way to create a more fully-featured application. The standard Create Application Wizard only allows you to select pages to generate, while this wizard also allows you to quickly pre-load a n'
||'umber of additional features into your application.</p>',
'<p>Applications generated using this wizard will be fully supported and may also include Supporting Objects for selected features, such as Access Control, Email Framework, Feedback, and more.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2762781533965438228)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Start by entering an application name. Next add one or more pages to your application. Check the features you want included. Make choices about the application appearance and then review the settings.<br>',
'That is it - Click <strong>Create Application</strong> and you are away!</p>',
'<p>Click on <strong>View Blueprint</strong> to reuse the model from a previously generated application or to quickly replicate pages.</p>',
'<p><em><strong>Note:</strong> Each section and each ''Add Page'' includes detailed help to assist you further.</em></p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2762518563345411939)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_text=>'How To Use This Wizard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3123825716879847807)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Significant issues at the time of release are listed below:',
'<ol>',
'  <li>The Create Application from Blueprint Wizard is not translated.</li>',
'  <li>Translated applications generated with this wizard are only partially translated.</li>',
'  <li>Report Drill Down only allows one drill down column.</li>',
'  <li>Filter report pages can not be generated.</li>',
'  <li>Email feature provides the low level API, but does not yet include higher level email features.</li>',
'  <li>Generating an application from a Blueprint that references missing tables will fail ungracefully.</li>',
'  <li>Advanced Settings - Date Formats are not applied to the generated application.</li>',
'</ol>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3123823976605830310)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_text=>'Known Issues'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2762782109910444519)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Released %0.</p>',
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2762781751817439821)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_text=>'Release Details'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2762108118828369911)
,p_name=>'CA.INTRO.TITLE'
,p_message_text=>'Create Application from a Blueprint Wizard {Cloud-Only Preview}'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921451320341951949)
,p_name=>'CA.IP.ADDRESS'
,p_message_text=>'IP Address'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921418434810209193)
,p_name=>'CA.IR.SEARCH'
,p_message_text=>'IR Search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921455137119030743)
,p_name=>'CA.IR.SEARCHES'
,p_message_text=>'IR Searches'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390018003835801799)
,p_name=>'CA.ITEMNAME'
,p_message_text=>'Item Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184709829957825012)
,p_name=>'CA.JOB.ACTION'
,p_message_text=>'Job Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184713488151838482)
,p_name=>'CA.JOB.CLASS'
,p_message_text=>'Job Class'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184711641220830824)
,p_name=>'CA.JOB.CREATOR'
,p_message_text=>'Job Creator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184713852932840370)
,p_name=>'CA.JOB.NAME'
,p_message_text=>'Job Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184699372032808033)
,p_name=>'CA.JOB.PRIORITY'
,p_message_text=>'Job Priority'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184689941217752204)
,p_name=>'CA.JOB.REPORTING'
,p_message_text=>'Job Reporting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(218155149841501964)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_text=>'View status and run details of jobs supporting this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184714091500841721)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_text=>'Job Run Details'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184711817021831828)
,p_name=>'CA.JOB.STYLE'
,p_message_text=>'Job Style'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184712090408832630)
,p_name=>'CA.JOB.SUBNAME'
,p_message_text=>'Job Subname'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184710133093825908)
,p_name=>'CA.JOB.TYPE'
,p_message_text=>'Job Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184694387399796291)
,p_name=>'CA.JOB.WEIGHT'
,p_message_text=>'Job Weight'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390020401533811054)
,p_name=>'CA.KEYCOLUMN'
,p_message_text=>'Key Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390025200674859796)
,p_name=>'CA.LABEL'
,p_message_text=>'Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390021044358816377)
,p_name=>'CA.LABELCOLUMN'
,p_message_text=>'Label Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390025684829862973)
,p_name=>'CA.LABELPLURAL'
,p_message_text=>'Label Plural'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390025024442858169)
,p_name=>'CA.LABELSINGULAR'
,p_message_text=>'Label Singular'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731732681309956661)
,p_name=>'CA.LANGUAGE'
,p_message_text=>'Language'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731732870762978363)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_text=>'Select the primary language for this application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3096535189070950803)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_text=>'<p>The primary language dictates the language used to display the pages and components generated in the App Builder. Selecting multiple translations will provide choices for your end users as to what language the runtime application is rendered using'
||'.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(304974196731546192)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_text=>'Language Selector'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922146882170633130)
,p_name=>'CA.LAST.NAME'
,p_message_text=>'Last Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184712213357833565)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_text=>'Last Run Duration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184712494729834384)
,p_name=>'CA.LAST.START.DATE'
,p_message_text=>'Last Start Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3431139308858001384)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_text=>'Latest Activity'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390023818625843976)
,p_name=>'CA.LISTOFVALUES'
,p_message_text=>'List of Values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3213478521559499976)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_text=>'Load Blueprint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184724822262861368)
,p_name=>'CA.LOG.DATE'
,p_message_text=>'Log Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184725241717862425)
,p_name=>'CA.LOG.ID'
,p_message_text=>'Log ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184696288660801521)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_text=>'Logging Level'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(110394909713400600)
,p_name=>'CA.LOOKUP.COLUMNS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
' <li><strong>Lookup Columns</strong> - Expand to see attributes for defining a lookup to another table. Use Lookup Columns to replace identifiers with a display column, such as showing the department name instead of the department number.<br>',
'<em><strong>Note:</strong> Lookup Columns only appears if the current page is based on a table or view and has foreign key constraints to another table.',
'  <ul>',
'    <li><strong>Lookup Key</strong> - Select the column to change to output the display column.</li>',
'    <li><strong>Display Column</strong> - Select the column (from the lookup table) to be displayed.</li>',
'    &nbsp;<br>',
'    <em><strong>Note:</strong> Only select columns that have a reference to another table (using a foreign key).</em></li>',
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922445733354828314)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_text=>'Manage Email Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922430379075523813)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_text=>'Manage Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921459552802091145)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_text=>'Manage User Access'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3471280999731244121)
,p_name=>'CA.MASTER'
,p_message_text=>'Add Master Detail Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3471288414436303902)
,p_name=>'CA.MASTER.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays a master-detail page to enable end users to view and maintain data.<br>',
'&nbsp;</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Page Type</strong> - Select the type of page [Side by Side, Stacked].<br>',
'    <strong>Side by Side</strong>: <br>',
'<em>A single page master-detail utilizing side by side layout and report regions with modal edit windows.</em>',
'    <ul>',
'      <li><strong>Table</strong> (Mandatory) - Select the master table for the page.</li>',
'      <li><strong>Primary Display Column</strong> (Mandatory) - Select the column to display in the list of master records.</li>',
'      <li><strong>Secondary Display Column</strong> (Mandatory) - Select the descriptive column to display in the list of master records, under the Primary Display Column.</li>',
'      <li><strong>Detail Table 1</strong> (Mandatory) - Select the first detail table for the page.</li>',
'      <li><strong>Detail Table 2</strong> - Select the second detail table for the page.</li>',
'      <li><strong>Detail Table 3</strong> - Select the third detail table for the page.</li>',
'      <li><strong>Detail Table 4</strong> - Select the forth detail table for the page.</li>',
'    </ul>',
'   <strong>Stacked</strong>: <br>',
'<em>A single page master-detail utilizing editable Interactive Grids.</em>',
'    <ul>',
'      <li><strong>Table</strong> (Mandatory) - Select the master table for the editable interactive grid.</li>',
'      <li><strong>Detail Table</strong> (Mandatory) - Select the detail table for the page.</li>',
'      <em><strong>Note:</strong> Only one detail table (editable interactive grid) can be added using the wizard. Additional detail tables can easily be added post-generation.</em>',
'    </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(304973226369525794)
,p_name=>'CA.MASTER_RECORDS'
,p_message_text=>'Master Records'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921424035363339579)
,p_name=>'CA.MAX.ELAPSED'
,p_message_text=>'Max Elapsed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184698972208806077)
,p_name=>'CA.MAX.FAILURES'
,p_message_text=>'Maximum Failures'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184697284873802829)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_text=>'Maximum Run Duration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184699122360806963)
,p_name=>'CA.MAX.RUNS'
,p_message_text=>'Maximum Runs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390020826046814187)
,p_name=>'CA.MAXIMUMROWS'
,p_message_text=>'Maximum Rows'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390698185596533926)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_text=>'Maximum Width'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126181581180824016)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_text=>'Add Filter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126183593259837085)
,p_name=>'CA.MD.ADD.ROW'
,p_message_text=>'Add %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126180843980820882)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_text=>'Apply Filters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126412896618976531)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_text=>'Date Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126413378707980665)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_text=>'Date Value 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126181945758825467)
,p_name=>'CA.MD.EDIT'
,p_message_text=>'Edit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126178240841813052)
,p_name=>'CA.MD.FILTER'
,p_message_text=>'Filter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126178059153811617)
,p_name=>'CA.MD.FILTERS'
,p_message_text=>'Filters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126183758217839342)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_text=>'No Filters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126179509905818776)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_text=>'No Record Selected'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126178976405816668)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_text=>'No Records Found'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126183137366832711)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_text=>'%0 deleted'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126182568075829043)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_text=>'%0 updated'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126178493426813829)
,p_name=>'CA.MD.SEARCH'
,p_message_text=>'Search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126183974645840770)
,p_name=>'CA.MD.VALUE'
,p_message_text=>'Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3126184169832841956)
,p_name=>'CA.MD.VALUE.2'
,p_message_text=>'Value 2'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921423074548329461)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_text=>'Median Elapsed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922438936143762653)
,p_name=>'CA.MESSAGE'
,p_message_text=>'Message'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390027217290886941)
,p_name=>'CA.METRIC'
,p_message_text=>'Metric'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921449350927924856)
,p_name=>'CA.MIN.ELAPSED'
,p_message_text=>'Min Elapsed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921458107697077121)
,p_name=>'CA.MOBILE.PHONE'
,p_message_text=>'Mobile Phone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921417804849202115)
,p_name=>'CA.MODE'
,p_message_text=>'Mode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2928846548085702402)
,p_name=>'CA.MORE'
,p_message_text=>'More'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921455368325032970)
,p_name=>'CA.MOST RECENT'
,p_message_text=>'Most_Recent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3431138963487998239)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_text=>'Most Active Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(110399486977448504)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_text=>'Multiple Reports'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(110399647658472955)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Check one or more table or view names. Alternatively, click the check box in the header to select or deselect all the database objects listed.</p>',
'<p>A page with an interactive report will be added for each checked database object.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921386496226526275)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_text=>'#LABEL# must be a valid timestamp.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390026603542880599)
,p_name=>'CA.NAME'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731730321516892380)
,p_name=>'CA.NAVIGATION'
,p_message_text=>'Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731730586046897188)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_text=>'<p>Select if the menu displays on the side of the application or across the top of the application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3966761056345225423)
,p_name=>'CA.NEGATIVE'
,p_message_text=>'Negative'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3966760844908224457)
,p_name=>'CA.NEUTRAL'
,p_message_text=>'Neutral'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3197576405458479166)
,p_name=>'CA.NEXT'
,p_message_text=>'Next'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184697835825804376)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_text=>'Next Run Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184694197799795488)
,p_name=>'CA.NLS.ENV'
,p_message_text=>'NLS Environment'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(259441579847037601)
,p_name=>'CA.NO'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922403644428949108)
,p_name=>'CA.NO.ACTION'
,p_message_text=>'No Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2987455550476259206)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_text=>'No help is available for this page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109933953007368985)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_text=>'No Valid Users Exist - Page Info'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3207348955022315319)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_text=>'No valid new users found'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3093033482716995036)
,p_name=>'CA.NONE'
,p_message_text=>'None'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921458734477080901)
,p_name=>'CA.NOTE'
,p_message_text=>'Note'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646817348406583711)
,p_name=>'CA.NOTIFICATION'
,p_message_text=>'Notifications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621233833044589005)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_text=>'Display notifications on the home page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646818500323599480)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enables application administrators to specify either alerts (yellow) or errors (red) that display to all end users on the application home page. This feature is useful for relaying important information to your end user community.</p>',
'<p>Includes the following components:<ul>',
'<li>Ability to define notifications</li>',
'<li>Display of notification on application home page</li>',
'<li>Ability control the time window of notification display</li>',
'<li>Support for color coding of notifications by type</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921244095427102267)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921418279248207207)
,p_name=>'CA.NUM.ROWS'
,p_message_text=>'Num Rows'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184709632159824117)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_text=>'Number of Arguements'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184693717345792827)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_text=>'Number of Destinations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390022812404832999)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_text=>'Number Format Mask'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921449947643933379)
,p_name=>'CA.OCCURRENCE'
,p_message_text=>'Occurrence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4055153107580160784)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_text=>'You cannot perform this action unless there is another administrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922404223592955005)
,p_name=>'CA.OPEN'
,p_message_text=>'Open'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2647111031373283020)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_text=>'Organizing Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2647114832697344347)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Arrange the pages in the order that you want them to appear in your application. <br>',
'To reorder pages in the list, click and hold the <em>Drag to reorder page</em> icon ( <span class="fa fa-bars" aria-hidden="true"></span> ) at the end of each page listing, and then drag and drop that page up or down.</p>',
'<p>The Home page always displays first and cannot be reordered.<br>',
'Administrative pages always display at the bottom of the list and the order dictates the order they appear in the Application Administration list on the Administration page.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184714613184843219)
,p_name=>'CA.OUTPUT'
,p_message_text=>'Output'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184724638770860473)
,p_name=>'CA.OWNER'
,p_message_text=>'Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921417645579199082)
,p_name=>'CA.PAGE'
,p_message_text=>'Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921454613194022715)
,p_name=>'CA.PAGE.EVENTS'
,p_message_text=>'Page Events'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2938835944705259860)
,p_name=>'CA.PAGE.HELP'
,p_message_text=>'Page Help'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921451503098955061)
,p_name=>'CA.PAGE.ITEM'
,p_message_text=>'Page Item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(306084580369305986)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_text=>'Edit Master Record'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(306085151364316004)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_text=>'Perform Search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921416824294189829)
,p_name=>'CA.PAGE.NAME'
,p_message_text=>'Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935898000767860540)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_text=>'Page Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921449719036928183)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_text=>'Page Performance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3206408857016053819)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_text=>'The page type "%0" is not a valid type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921423836679337395)
,p_name=>'CA.PAGE.VIEWS'
,p_message_text=>'Page Views'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2647122505941384402)
,p_name=>'CA.PAGES'
,p_message_text=>'Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2647124679145403885)
,p_name=>'CA.PAGES.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Define page(s) to include in your initial application. You must define at least one page before you can create your application.</p>',
'<p>You can stub out your application by creating any number of pages using this wizard. After you create your application, use the Create Page Wizard to add more pages.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390022507496830842)
,p_name=>'CA.PAGINATIONMETHOD'
,p_message_text=>'Pagination Method'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921448964769917006)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_text=>'Partial Page Views'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922148130990659903)
,p_name=>'CA.PHOTO'
,p_message_text=>'Photo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922161316240161037)
,p_name=>'CA.PHOTO.DELETED'
,p_message_text=>'Photo deleted.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922148318819662307)
,p_name=>'CA.PHOTO.NAME'
,p_message_text=>'Photo Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922147703988645764)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_text=>'Photo Upload'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922456249113954248)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_text=>'Plain Text Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3966760656261222915)
,p_name=>'CA.POSITIVE'
,p_message_text=>'Positive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2920379632736563641)
,p_name=>'CA.PREFERENCES'
,p_message_text=>'Preferences'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3628792320592380959)
,p_name=>'CA.PREVIOUS'
,p_message_text=>'Previous'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390024006095846922)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_text=>'Primary Display Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390026050362867650)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_text=>'Primary Key Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390026294670870095)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_text=>'Primary Parent Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921450107191942687)
,p_name=>'CA.PROCEDURE'
,p_message_text=>'Procedure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921186111635760269)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_text=>'Email preference updated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(306081884568225546)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_text=>'Fetch Row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921196362084932673)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_text=>'Application Appearance Settings Saved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921184726999736101)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_text=>'Time zone preference updated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922150930242763343)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_text=>'Profile Photo Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184710544504827181)
,p_name=>'CA.PROGRAM.NAME'
,p_message_text=>'Program Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184711049660828195)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_text=>'Program Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390024824586855924)
,p_name=>'CA.QUERY'
,p_message_text=>'Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184694772184797913)
,p_name=>'CA.RAISE.EVENTS'
,p_message_text=>'Raise Events'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(51353868030904935)
,p_name=>'CA.RATING'
,p_message_text=>'Rating'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921934855677205460)
,p_name=>'CA.READERS'
,p_message_text=>'Readers'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2920780137439587848)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_text=>'Receive Emails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3431139186824999439)
,p_name=>'CA.RECENT.ERRORS'
,p_message_text=>'Recent Errors'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(561194524277112528)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_text=>'Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(561194741717116834)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_text=>'Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921244536718109466)
,p_name=>'CA.RED'
,p_message_text=>'Red'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922444587124818185)
,p_name=>'CA.REFERENCED'
,p_message_text=>'Referenced'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305931329303042545)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_text=>'Refresh Admin Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106496011282431005)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_text=>'Refresh on Dialog Close'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(306084859968311072)
,p_name=>'CA.REFRESH_REPORT'
,p_message_text=>'Refresh Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921242785371085147)
,p_name=>'CA.REGION.BUTTONS'
,p_message_text=>'Buttons Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921242506708082584)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_text=>'Form Items Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921451787738957119)
,p_name=>'CA.REGION.ID'
,p_message_text=>'Region ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935889526988777728)
,p_name=>'CA.RELEASE'
,p_message_text=>'Release %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2647112026204284365)
,p_name=>'CA.REMOVING.PAGES'
,p_message_text=>'Removing Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2647113862303314729)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_text=>'<p>Click <strong>Edit</strong> to select the page, then click <strong>Delete Page</strong> to remove a page from your application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184713690066839655)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_text=>'Repeat Interval'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129925254742099427)
,p_name=>'CA.REPLY.TO'
,p_message_text=>'Reply To'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722690195303784669)
,p_name=>'CA.REPORT'
,p_message_text=>'Add Report Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2722689894579782954)
,p_name=>'CA.REPORT.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays either as an interactive report or a classic report.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Query Type</strong> - Select the source for the report [<strong>Table or View</strong> or <strong>SQL Query</strong>]:<br>',
'    <strong>Table or View</strong>:',
'    <ul>',
'      <li>Table or View (Mandatory) - Select the database object for the report.</li>',
'      <li>Include Form - Select to include a linked form page to enable users to maintain the table values.</li>',
'    </ul>',
'    <strong>SQL Query</strong>:',
'    <ul>',
'      <li>SQL Query (Mandatory) - Enter a valid SQL statement which returns distinct columns.</li>',
'    </ul>',
'  </li>',
'  <li><strong>Report Type</strong> - Select the type of report (<strong>Interactive Report</strong> or <strong>Classic Report</strong>).</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2639505674780625869)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_text=>'%0 with Form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(626527526045993891)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_text=>'%0 Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3405071059508413435)
,p_name=>'CA.REPORT.VIEW'
,p_message_text=>'Report View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390028597888900267)
,p_name=>'CA.REPORTS'
,p_message_text=>'Reports'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184723207341856267)
,p_name=>'CA.REQ.START.DATE'
,p_message_text=>'Requested Start Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390697972613532537)
,p_name=>'CA.REQUIRED'
,p_message_text=>'Required'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922458096978996863)
,p_name=>'CA.RESET'
,p_message_text=>'Reset'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922403834124950043)
,p_name=>'CA.RESOLVED'
,p_message_text=>'Resolved'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922403192123945882)
,p_name=>'CA.RESPONSE'
,p_message_text=>'Response'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184699991090809019)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_text=>'Restart on Failure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184700217011810026)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_text=>'Restart on Recovery'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184691195850760870)
,p_name=>'CA.RESTARTABLE'
,p_message_text=>'Restartable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184698734822805108)
,p_name=>'CA.RETRY.COUNT'
,p_message_text=>'Retry Count'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3351725351649654702)
,p_name=>'CA.ROLE'
,p_message_text=>'Role'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921452624642961195)
,p_name=>'CA.ROW.NUMBER'
,p_message_text=>'Row Number'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922456676511960168)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_text=>'Row Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3320295483017269069)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_text=>'Row Template HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3358847878805966412)
,p_name=>'CA.ROWS.CONTENT'
,p_message_text=>'Rows Content'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921454937448029010)
,p_name=>'CA.ROWS.FETCHED'
,p_message_text=>'Rows Fetched'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390022382213828818)
,p_name=>'CA.ROWSPERPAGE'
,p_message_text=>'Rows Per Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184712836848835869)
,p_name=>'CA.RUN.COUNT'
,p_message_text=>'Run Count'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184720942320854525)
,p_name=>'CA.RUN.DURATION'
,p_message_text=>'Run Duration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184697604379803639)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_text=>'Schedule Limit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184709079948822077)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_text=>'Schedule Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184709439332823002)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_text=>'Schedule Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184708472719820986)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_text=>'Schedule Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731733063481980184)
,p_name=>'CA.SCHEMA'
,p_message_text=>'Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731733228397992154)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_text=>'<p>Select the database schema which stores the database objects you want to use in this application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390018252112802925)
,p_name=>'CA.SCOPE'
,p_message_text=>'Scope'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922458366526000876)
,p_name=>'CA.SEARCH'
,p_message_text=>'Search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922458581105002968)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_text=>'Search Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922458795420013267)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_text=>'Search Dialog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3407190128711818051)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_text=>'Search Filters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2979318503405336246)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'This page is driven off of the Shared Component list called Searched Tables.',
'',
'Any Interactive Report pages initially generated from the Create Application wizard will automatically be added to the list. ',
'To add your own tables to the list then navigate to Shared Components, select Lists, and then click on Searched Tables.',
'  Enter the following attributes:',
'    Entry: List Entry Label - enter the dispaly name for the table.',
'    Target: Page - select the appropriate page to navigate to (preferably an Interactive Report)',
'    Target: Clear Cache - enter any pages that need to be cleared (generally the same number as entered under Page).',
'       If navigating to an Interactive Report page then add CIR,RIR to clear any existing filters, and so forth.',
'    Target: Set these items - select (or enter) the appropriate page item to be populated.',
'       If navigating to an Interactive Report page then enter IR_[COLUMN_NAME].',
'    Target: With these values - enter =PK=',
'    User Defined Attributes: 1 - enter the table name to search in upper case.',
'    User Defined Attributes: 2 - enter the primary column name in upper case.',
'    User Defined Attributes: 3 (Optional) -  comma separated list of columns to search.',
'       If no columns are specified then all text (varchar2) and character large object (clob) columns are searched.',
'',
'Note: A list of available tables to search will only be displayed to users if more than one table is listed.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922457606955990007)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_text=>'Search Results'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390025862465865497)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_text=>'Secondary Display Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922435318931719505)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_text=>'Selected Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129923640465087400)
,p_name=>'CA.SEND.BEGIN'
,p_message_text=>'Send Begin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129924419500094269)
,p_name=>'CA.SEND.COUNT'
,p_message_text=>'Send Count'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129923113039086608)
,p_name=>'CA.SEND.END'
,p_message_text=>'Send End'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129924204648093248)
,p_name=>'CA.SEND.ERROR'
,p_message_text=>'Send Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3760906540923234721)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_text=>'Send Emails'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3761376521066295477)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_text=>'Determines whether emails should be sent out when new feedback is received.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3414689778981199651)
,p_name=>'CA.SEND.FROM'
,p_message_text=>'Send From'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3313145483929833340)
,p_name=>'CA.SEND.TO'
,p_message_text=>'Send To'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935882209558754856)
,p_name=>'CA.SERIES'
,p_message_text=>'Series %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184720323546852349)
,p_name=>'CA.SESSION.ID'
,p_message_text=>'Session ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390018621208805615)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_text=>'Session State Protection'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731731806713947526)
,p_name=>'CA.SETTINGS'
,p_message_text=>'Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731732040025949725)
,p_name=>'CA.SETTINGS.DESC'
,p_message_text=>'<p>Specify the settings used in the generation of the application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2928846372034701001)
,p_name=>'CA.SHOW.ALL'
,p_message_text=>'Show All'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106120380074794251)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_text=>'Show/Hide Scope'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935896827679836189)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_text=>'Show Timezone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2935892113919800507)
,p_name=>'CA.SIGN.IN'
,p_message_text=>'Sign In'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2939100174148497967)
,p_name=>'CA.SIGN.OUT'
,p_message_text=>'Sign Out'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184719716051851508)
,p_name=>'CA.SLAVE.PID'
,p_message_text=>'Slave PID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184693965233793882)
,p_name=>'CA.SOURCE'
,p_message_text=>'Source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3206409269930056506)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_text=>'The source type is not a valid type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2979319378053356626)
,p_name=>'CA.SOURCES'
,p_message_text=>'Sources'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184708229509820188)
,p_name=>'CA.START.DATE'
,p_message_text=>'Start Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184713038749836550)
,p_name=>'CA.STATE'
,p_message_text=>'State'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390697770980531635)
,p_name=>'CA.STATICDEFAULT'
,p_message_text=>'Static Default'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921396060126891486)
,p_name=>'CA.STATUS'
,p_message_text=>'Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184695682815799995)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_text=>'Stop on Window Close'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184696057595800681)
,p_name=>'CA.STORE.OUTPUT'
,p_message_text=>'Store Output'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922436841225744965)
,p_name=>'CA.SUBJECT'
,p_message_text=>'Subject'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922162868348185141)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_text=>'Submit Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390020645932812421)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_text=>'Suggested Visualization'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3092809477868655287)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_text=>'Supporting Objects'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3092810345861672837)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_text=>'<p>Enter code into the installation script, generally to create or manipulate database objects, or perform inserts / updates / deletes on existing records. Enter code into deinstallation, generally to remove (drop) database objects. These scripts wil'
||'l be incorporated into the Supporting Objects so that when you export the application it will perform these same updates in your test and production environments.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3092815282060745232)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter valid SQL and/or PL/SQL statements into Installation Script which are run when the application is imported.</p>',
'<p>If you want these statements also run in the current environment, and not just when the application is imported into another environment, click <strong>Run when creating application</strong>.</p>',
'<p>Enter valid SQL and/or PL/SQL statements into Deinstallation Script which are run when the application is deleted from App Builder.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184694588562797200)
,p_name=>'CA.SYSTEM'
,p_message_text=>'System'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390024649542854875)
,p_name=>'CA.TABLE'
,p_message_text=>'Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731733474202994238)
,p_name=>'CA.TABLE.PREFIX'
,p_message_text=>'Framework Object Prefix'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731733627770005594)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter an object prefix for use by the application. Some features add this prefix to database objects that they create (including packages and tables).</p>',
'<p>Warning: Ensure you enter a unique prefix that is not used by other applications. If not unique, the application may raise errors when being created and not function correctly.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390026492417877892)
,p_name=>'CA.TABLECOLUMN'
,p_message_text=>'Table Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3313145601333834668)
,p_name=>'CA.TEMPLATE'
,p_message_text=>'Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922457454361978717)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_text=>'This template name is already being used.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922436605700742409)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_text=>'Template Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921391954075741175)
,p_name=>'CA.TEXT'
,p_message_text=>'Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129924099151089768)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_text=>'Text Body Size'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922443385126804940)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_text=>'Text Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921194528874912239)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_text=>'End User Theme Preference'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921195095555919908)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_text=>'If checked, end users may choose their own Theme Style using the Customize link.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921194874305916813)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_text=>'Allow End Users to choose Theme Style'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646819143387604543)
,p_name=>'CA.THEME.SELECTOR'
,p_message_text=>'Theme Style Selection'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621229113321566682)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_text=>'Update default application look and feel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646819960845612088)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enables administrators to select a default color scheme (theme style) for the application. Administrators can also choose to allow end users to choose their own theme style. End users can simply click on the <em>Customize</em> button at the bottom'
||' of the home page, and select from the available theme styles. For example, users with visual impairment may prefer to utilize the <em>Vista</em> theme style which has a much higher color contrast.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Allows administrators can define the default theme style</li>',
'<li>Enables end users to select various theme styles</li>',
'</ul>',
'</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731729942366878282)
,p_name=>'CA.THEME.STYLE'
,p_message_text=>'Theme Style'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2731730121275890778)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select the default theme style used to display the application.</p>',
'<p>The style can readily be changed to another pre-defined style, or modified post generation. To change the style run the application and then click <strong>Theme Roller</strong> in the Developer toolbar.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921453283701967288)
,p_name=>'CA.TIME'
,p_message_text=>'Time'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2920380645020574978)
,p_name=>'CA.TIME.ZONE'
,p_message_text=>'Time Zone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646826518738991527)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_text=>'Time Zone Support'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621227560179541334)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_text=>'Set default and user time zones'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646825849153970053)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Allow end users to set their local time zone. This is important if your application tables utilize time zone aware date types (such as Timestamp with Local Time Zone) so that the reports and data entry reflect where end users are located.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Allow administrators to set the default time zone</li>',
'<li>Allow end users to select their time zone preference</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3431140134673030776)
,p_name=>'CA.TIMEFRAME'
,p_message_text=>'Timeframe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3471198075494170547)
,p_name=>'CA.TIMELINE'
,p_message_text=>'Add Timeline Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3471263289412222102)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a page which displays a timeline which is especially useful for displaying updates.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Page Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Table or View</strong> (Mandatory) - Select the database object for the timeline.</li>',
'  <li><strong>User Name</strong> (Mandatory) - Select the column from the table or view to use as the user displayed for the timeline entries.</li>',
'  <li><strong>Date</strong> (Mandatory) - Select the column from the table or view to use as the date for the timeline entries.</li>',
'  <li><strong>Event Name</strong> (Mandatory) - Select the column from the table or view to use as the title for the timeline entries.</li>',
'  <li><strong>Description</strong> - Select the column from the table or view to use as the description for the timeline entries.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921417259937197070)
,p_name=>'CA.TIMESTAMP'
,p_message_text=>'Timestamp'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921458393197078619)
,p_name=>'CA.TITLE'
,p_message_text=>'Title'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(129925677711102175)
,p_name=>'CA.TO'
,p_message_text=>'To'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921455540828037265)
,p_name=>'CA.TOP.USERS'
,p_message_text=>'Top Users'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921455762663042343)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_text=>'Top Users Chart'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921448735460914737)
,p_name=>'CA.TOTAL.ROWS'
,p_message_text=>'Total Rows'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921935562871212226)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_text=>'Default role for users not in access control list:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921392107428743788)
,p_name=>'CA.TYPE'
,p_message_text=>'Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(257374300535647357)
,p_name=>'CA.UI.DEFAULTS'
,p_message_text=>'User Interface Defaults'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(257375130198663952)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_text=>'Set defaults for user interface settings, such as rows per page, and add list of values definitions. These settings are used when generating components within the application. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921392548960746848)
,p_name=>'CA.UNTIL'
,p_message_text=>'Until'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305009607760777247)
,p_name=>'CA.UPDATE'
,p_message_text=>'Update'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922150790998731722)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_text=>'Update Profile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921393275486754997)
,p_name=>'CA.UPDATED'
,p_message_text=>'Updated'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921393414512757711)
,p_name=>'CA.UPDATED.BY'
,p_message_text=>'Updated By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921417094747195980)
,p_name=>'CA.USER'
,p_message_text=>'User'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3195379971078958197)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_text=>'Add Multiple Users - Step 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3195380265360959518)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_text=>'Add Multiple Users - Step 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3195380600243961060)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_text=>'Add Multiple Users'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921451161914950682)
,p_name=>'CA.USER.AGENT'
,p_message_text=>'User Agent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2936351423782899523)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_text=>'User Counts Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921457046707065611)
,p_name=>'CA.USER.NAME'
,p_message_text=>'Username'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922144971884615710)
,p_name=>'CA.USER.PROFILE'
,p_message_text=>'User Profile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646826254388983218)
,p_name=>'CA.USER.PROFILES'
,p_message_text=>'User Profiles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2621225210234534185)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_text=>'Allow users to update their profile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2646826025625981905)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Allow end users to enter in additional information about themselves, including a picture or avatar, to personalize their account.</p>',
'<p>Includes the following components:',
'<ul>',
'<li>Setting page for end users to set their profile</li>',
'<li>Ability to upload photo / avatar</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922146356654627051)
,p_name=>'CA.USERNAME'
,p_message_text=>'Username'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921936309585217163)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_text=>'Username format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3207348034031295734)
,p_name=>'CA.USERNAMES'
,p_message_text=>'Usernames'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(262698262181125779)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_text=>'Username Format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3207350632665341464)
,p_name=>'CA.USERS.ADDED'
,p_message_text=>'User(s) added.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3350901784067397175)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_text=>'Users by Role'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922439174861764791)
,p_name=>'CA.USERS.INCLUDED'
,p_message_text=>'Users Included'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3207348797143310587)
,p_name=>'CA.USERS.TO.ADD'
,p_message_text=>'Users to Add'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922003303237247880)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_text=>'Username format updated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109886988000332582)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_text=>'Valid Users Exist - Page Info'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3056992948347852373)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_text=>'Application ID already exists, or is reserved for another application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(225738885909472966)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_text=>'Application name must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3353766588815615887)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_text=>'Must provide email addresses to send your email to.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3353765604996603820)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_text=>'Must provide email addresses or select a set of users to send your email to.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3353766169610610955)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_text=>'Must select a set of users to send your email to.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3057526203131860182)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_text=>'Table prefix must not be greater than six characters, must start with a letter, and only contain letters, numbers, and underscores.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3057936114198871699)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_text=>'Please enter a different Table Prefix. The following Database Objects already exist: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922005918770308922)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_text=>'Username is not in a valid email address format. Please note the application''''s username format below.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2922005735362304681)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_text=>'Verify Email Format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921456602216051989)
,p_name=>'CA.VIEW.AS'
,p_message_text=>'View As'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3108275020233179174)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_text=>'View Blueprint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2928846164943698203)
,p_name=>'CA.VIEW.DETAILS'
,p_message_text=>'View Details'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3354911907549227891)
,p_name=>'CA.VIEW.EMAIL'
,p_message_text=>'View Email'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2938962816876268130)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_text=>'View My Profile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921423268594331404)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_text=>'Weighted Performance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3390698320925534642)
,p_name=>'CA.WIDTH'
,p_message_text=>'Width'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3649990863111799259)
,p_name=>'CA.WIZARD'
,p_message_text=>'Create Wizard Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109885017554270299)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_text=>'Wizard Container'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3649996196165836832)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Create a collection of pages to be used as a wizard. Generally wizards are used for entering data across multiple steps.</p>',
'<p>Enter the following attributes:</p>',
'<ul>',
'  <li><strong>Wizard Name</strong> (Mandatory) - Enter a name for this page.</li>',
'  <li><strong>Set Icon</strong> - Select an icon to display in the navigation menu for this page.</li>',
'  <li><strong>Page Mode</strong> (Mandatory) - Select whether the wizard steps display as modal or normal pages. Select either <strong>Modal Page</strong> or <strong>Full page</strong>.</li>',
'  <li><strong>Step 1 ... 8</strong> - Enter the page name for the steps of the wizard.<br><em><strong>Note:</strong> Steps 5 - 8 are displayed as a name is entered for each previous step.</em></li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921457975337075480)
,p_name=>'CA.WORK.PHONE'
,p_message_text=>'Work phone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2921244318988109066)
,p_name=>'CA.YELLOW'
,p_message_text=>'Yellow'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(259432601146036795)
,p_name=>'CA.YES'
,p_message_text=>'Yes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(51319200328373190)
,p_name=>'CACHED'
,p_message_text=>'Cached'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(18836621004672418)
,p_name=>'CACHE_CREATED'
,p_message_text=>'Cache Created'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13865615425766823)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_text=>'Delete Data functionality is disabled.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9010606424108252)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_text=>'Add data functionality is disabled.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9010817506111448)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_text=>'Update data functionality is disabled.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(73699120857866662)
,p_name=>'CALENDAR.NEXT'
,p_message_text=>'Next'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(73697304580861976)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_text=>'Previous'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21777513516626683)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_text=>'Easy Calendar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(599926506288337367)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_text=>'Edit Calendar Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4305321288245834)
,p_name=>'CALENDAR_POPUP'
,p_message_text=>'Calendar pop-up for %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(47221208998715794)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_text=>'The calendar has been created successfully.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(200695312104715640)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_text=>'Legacy Calendar Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21776104512624097)
,p_name=>'CALENDAR_TYPE'
,p_message_text=>'Calendar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138974622964506611)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_text=>'No calendar templates found when attempting to copy from application %0 and template ID %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(202296720265917598)
,p_name=>'CANCEL'
,p_message_text=>'Cancel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1814930124326252)
,p_name=>'CANDLESTICK'
,p_message_text=>'Candlestick'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455022416486968962)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_text=>'Cascading Style Sheets'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(251505106698531708)
,p_name=>'CENTER'
,p_message_text=>'Center'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(293195619978388103)
,p_name=>'CHANGES'
,p_message_text=>'Changes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(740659070554031061)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_text=>'Change Authentication'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(195800222275030115)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_text=>'Change Database Size'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60161303637564471)
,p_name=>'CHANGE_PW_REQUEST'
,p_message_text=>'%0 Request'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(195796420020991565)
,p_name=>'CHANGE_REQUEST'
,p_message_text=>'Change Request'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(389072450102661347)
,p_name=>'CHANGE_WORKSPACE'
,p_message_text=>'Change Workspace'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184527231000483165)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_text=>'Character Set Column'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88140824815817440)
,p_name=>'CHART'
,p_message_text=>'chart'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2958109427171268)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid chart query: %0<br><br>',
'Use the following syntax:',
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>Text that goes with the bar</td></tr>',
'<tr><td>VALUE</td><td>Numeric column that defines bar size</td></tr>',
'</table>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(69504705708239462)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid chart query.<br /><br /> Use the following syntax: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>',
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
'<td>Numeric column that defines dial value.</td>',
'</tr>',
'<tr>',
'<td>MAX</td>',
'<td>Numeric column that defines Maximum dial value.</td>',
'</tr>',
'<tr>',
'<td>LOW (optional)</td>',
'<td>Numeric column that defines Minimum previous dial value.</td>',
'</tr>',
'<tr>',
'<td>HIGH (optional)</td>',
'<td>Numeric column that defines Maximum previous dial value.</td>',
'</tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(91347420304253520)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_text=>'Invalid chart type.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2953401799093358)
,p_name=>'CHART.INVALID_QUERY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Failed to parse SQL query!',
'<p>%0</p>',
'Certain queries can only be executed when running your application, if your query appears syntactically correct, you can save your query without validation (see options below query source).'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1142980177132061296)
,p_name=>'CHART_DEGREES'
,p_message_text=>'degrees'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(175290602904159247)
,p_name=>'CHART_PAGE'
,p_message_text=>'%0 Chart'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14515306749524246)
,p_name=>'CHART_SERIES'
,p_message_text=>'Chart Series'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(193582863065333859)
,p_name=>'CHART_SERIES_ERROR'
,p_message_text=>'Chart series error %0 for %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(44579130448227170)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_text=>'The chart has been created successfully.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(36719205200406055)
,p_name=>'CHECK$'
,p_message_text=>'row selector'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(708579510672261953)
,p_name=>'CHECKED'
,p_message_text=>'checked'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179146631742550328)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_text=>'Checksum Required - Application Level'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114385932590813391)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_text=>'Checksum Required - Session Level'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114385521854810236)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_text=>'Checksum Required - User Level'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114385122416800939)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_text=>'Checksum Required - Application Level'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1198925881914331852)
,p_name=>'CHECK_ALL'
,p_message_text=>'Check All'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(170067226467546740)
,p_name=>'CLASSIC_CALENDAR'
,p_message_text=>'Classic Calendar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(171347196809995472)
,p_name=>'CLASSIC_REPORT'
,p_message_text=>'Classic Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(68338261711239053)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_text=>'Classic Report Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(170214869730857302)
,p_name=>'CLASSIC_TREE'
,p_message_text=>'Classic Tree'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(169454129488056891)
,p_name=>'CLEAN_UP'
,p_message_text=>'Clean Up Page'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12272112996747369)
,p_name=>'CLEAR_COMMAND'
,p_message_text=>'Clear Command'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(173214002327361890)
,p_name=>'CLOSED'
,p_message_text=>'Closed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(192598428012185091)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_text=>'Closed Last 7 Days'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108366527719365876)
,p_name=>'CLOSE_WINDOW'
,p_message_text=>'Close Window'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070519427711217189)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_text=>'Close'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070522899432239079)
,p_name=>'CODE_EDITOR.FIND'
,p_message_text=>'Find'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070519240443215989)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_text=>'Find'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070522656051238183)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_text=>'Find Next'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070522453898237210)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_text=>'Find Prev'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070522074151233947)
,p_name=>'CODE_EDITOR.HINT'
,p_message_text=>'Auto Complete'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070520692065225426)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_text=>'Indent Size'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070521006143228002)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_text=>'Tab Inserts Spaces'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070519852567219789)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_text=>'Match Case'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070519684823218551)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_text=>'Regular Expression'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3128836128978446134)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_text=>'Query Builder'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070523095943240568)
,p_name=>'CODE_EDITOR.REDO'
,p_message_text=>'Redo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070522250626235523)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_text=>'Replace'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070518809282210117)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_text=>'Replace All'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070519055598212495)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_text=>'Replace'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070523672708243476)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_text=>'Skip'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070521611692231539)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_text=>'Settings'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070520215784221842)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070521269331229061)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_text=>'Show Line Numbers'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070520035602220881)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_text=>'Show Ruler'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070520878632226491)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_text=>'Tab Size'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070520470054223867)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_text=>'Themes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070523290278241609)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_text=>'Undo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070521413144230126)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_text=>'Use Plain Text Editor'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070521842786232830)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_text=>'Validate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3070523400641242424)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_text=>'Validation successful'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146148925494206871)
,p_name=>'COLLAPSE'
,p_message_text=>'Collapse '
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15772413581087385)
,p_name=>'COLOR_PALETTE'
,p_message_text=>'Color Palette'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(89774508950852044)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_text=>'Analogic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(89772822887837167)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_text=>'Complementary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(89780016578929941)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_text=>'Complementary Colors'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(89774922456855939)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_text=>'Monotone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(89773231544839616)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_text=>'Split complementary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(89774118516845404)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_text=>'Tetrade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(89773606395841873)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_text=>'Triad'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(437388811254118533)
,p_name=>'COLUMN'
,p_message_text=>'Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1034586128171471312)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_text=>'Display Name: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145364716519189011)
,p_name=>'COLUMN_NAME'
,p_message_text=>'Column Name'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261398804665946972)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_text=>'All authenticated users can access this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261399021093949653)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_text=>'Only users defined in the application access control list may access this application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261400110339952687)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_text=>'Unexpected Access Control Setting Value: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14634122985676876)
,p_name=>'COMING_SOON'
,p_message_text=>'Coming Soon'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145411825832238970)
,p_name=>'COMMENT'
,p_message_text=>'Comment'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(202523216319760295)
,p_name=>'COMMENTS'
,p_message_text=>'Comments'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108970405030089481)
,p_name=>'COMPILE_FAILURE'
,p_message_text=>'Compilation failed,line <a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277637601187810539)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_text=>'Compilation failed, line %0 (%2) The line numbers associated with compilation errors are relative to the first BEGIN statement. This only affects the compilation of database triggers.<br />%1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108963117188045685)
,p_name=>'COMPILE_SUCCESS'
,p_message_text=>'PL/SQL code successfully compiled (%0)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172549003438857500)
,p_name=>'COMPLETE'
,p_message_text=>'Complete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(176657008786028133)
,p_name=>'COMPLETED'
,p_message_text=>'Completed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(180834903635975007)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_text=>'Complete / No issues'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(192600716855276486)
,p_name=>'COMPONENT'
,p_message_text=>'Component'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(336418909105289891)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_text=>'Component Name: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(503109925131716571)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_text=>'Component not enabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(45312630174882950)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_text=>'The component has been successfully created.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(973696800733323792)
,p_name=>'COMPONENT_SUMMARY'
,p_message_text=>'Component Summary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26573222107305330)
,p_name=>'COMPUTATIONS'
,p_message_text=>'Computations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(219338505351768650)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_text=>'Application components successfully installed.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109160603009082215)
,p_name=>'CONDITIONAL'
,p_message_text=>'Conditional'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137153030635601954)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_text=>'popup list of values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167846322494167848)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_text=>'always'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(85091907321893783)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_text=>'exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(85072900647835157)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_text=>'item / column=value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(85074028352843071)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_text=>'item / column not null'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(572077911133276296)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_text=>'item / column null'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(85094624290898694)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_text=>'never'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(85097002603901871)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_text=>'none'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(85085927837880849)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_text=>'page in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(85090223120888950)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_text=>'page not in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(85053030944806028)
,p_name=>'CONDITIONS_SHORTCUT_PLSQL'
,p_message_text=>'PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(85075315669848918)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_text=>'request=e1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86865826552763427)
,p_name=>'CONDITION_TYPE'
,p_message_text=>'Condition Type'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150820922375135385)
,p_name=>'CONFIRM'
,p_message_text=>'Confirm'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1819119104278786)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_text=>'Two page master detail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1818612871276983)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_text=>'Three page master detail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83741621054145676)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_text=>'Actual Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172150321712797363)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_text=>'Aggregate by Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172153114009814070)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_text=>'Aggregate Functions to Use'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83629211143452101)
,p_name=>'CONFIRM.APPLICATION'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84960224553217479)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84960619143225429)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_text=>'Default Language'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84959603774211504)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(30326603162445855)
,p_name=>'CONFIRM.ARRAY'
,p_message_text=>'Result Tree to Report On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(30327010434447956)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_text=>'Result Parameters to Report On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84962917542234410)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_text=>'Authentication'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(326398824931494617)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_text=>'Branch to Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(140245428775019902)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_text=>'Break Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83716430002044177)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_text=>'%0 Button Branch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83715032641035557)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_text=>'%0 Button Display Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(7012400231928635)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_text=>'Enable Adding Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(7012215768904715)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_text=>'Enable Drag and Drop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261944706055469953)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_text=>'Cancel Branch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(326330706923489354)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_text=>'Cancel Button Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(297298419264914724)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_text=>'Case Sensitive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108082004628024380)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_text=>'You have requested to change the Interactive Report query. If you removed any columns from the query, it will disable existing filters, highlight rules, and other report settings referencing those columns. Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83890404206424749)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_text=>'Chart Axis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(203473409705410233)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_text=>'Dial'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(203474817324412439)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_text=>'Dial (Sweep)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83959621325590507)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_text=>'Horizontal Bar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83961310028596692)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_text=>'Line'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83898511263436179)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_text=>'Number Mask'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83960431021593278)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_text=>'Pie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83885909270416759)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_text=>'Chart Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83894412864427252)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_text=>'Scale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83964025611601184)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_text=>'Scatter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83947427380554416)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_text=>'Chart Size'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83946611104549672)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_text=>'Chart Title'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83945731059546010)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_text=>'Chart Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83952810327568385)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_text=>'Vertical Bar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(30342710322589858)
,p_name=>'CONFIRM.COLLECTION'
,p_message_text=>'Temporary Result Set Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83637803318535041)
,p_name=>'CONFIRM.COLUMNS'
,p_message_text=>'Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(140179508287559813)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_text=>'Column Headings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240029700019433381)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_text=>'Column Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261994626271485277)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_text=>'Column Name(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84312222269584337)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_text=>'Use Column Heading Sorting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(115383228802117267)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_text=>'You have requested to copy an application with the following attributes. Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84220229111255163)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_text=>'You have requested to copy a page with the following attributes.  Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83681504750913953)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_text=>'A new tab set "%0" will be created and used by this page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84958832256200806)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_text=>'You have requested to create an application with the following attributes.  Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84032115287777986)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_text=>'You have requested to create a calendar page with the following attributes.   Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84155707575069111)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_text=>'You have requested to create a drill down report page with the following attributes.   Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(93460706616689925)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_text=>'You have requested to create an Interactive Report page with the following attributes. Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84279810401524144)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_text=>'You have requested to create a report page with the following attributes.   Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5019508618462728)
,p_name=>'CONFIRM.CREATE_FLASH_CHART'
,p_message_text=>'You have requested to create a Flash chart page with the following attributes. Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(852521928585935732)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_text=>'You have requested to create a Database application using the same ID as an existing Database application in the current workspace. The existing Database application will be deleted and then replaced by the new Database application. Please confirm yo'
||'ur selections. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236526520020512770)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_text=>'You have requested to create form and list view pages with the following attributes. Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172121326589675702)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_text=>'You have requested to create a form and a report page with analysis pages. Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84013706452737578)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_text=>'You have requested to create a form on SQL query with the following attributes.   Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84012121212732461)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_text=>'You have requested to create a form on stored procedure with the following attributes.   Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84009924198723832)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_text=>'You have requested to create a form on a table page with the following attributes.   Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22395309050346102)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_text=>'You have requested to create a form on a Web service reference page with the following attributes.   Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(38956009470728152)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_text=>'You have requested to create a form and report on a Web service reference page with the following attributes.   Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184230915971057577)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_text=>'You have requested to create a Map page with the following attributes. Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1807521688165980)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_text=>'You have requested to create master detail pages with the following attributes. Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84064716513891867)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_text=>'You have requested to create a breadcrumb region and breadcrumb option with the following attributes.  Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(175431427677330268)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_text=>'Create Mode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83996527399705856)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_text=>'You have requested to create a page with the following attributes.  Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1728744384958605947)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_text=>'Create Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1728745182668609740)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_text=>'Create Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84110608342974700)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_text=>'You have requested to create form and report pages with the following attributes.  Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(819414604293905684)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_text=>'You have requested to create a page with the following attributes. Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84229312367316547)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_text=>'You have requested to create a report page with the following attributes.  Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84015121343741885)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_text=>'You have requested to create an HTML Bar Chart Page with the following attributes.  Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84210505862220035)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_text=>'You have requested to create a summary page with the following attributes.  Press the "Add More" button to add additional items from other pages and/or regions. Press "Finish" to create the summary items.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84022417665750334)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_text=>'You have requested to create a SVG chart page with the following attributes.  Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83993721381694591)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_text=>'You have requested to create a tabular form page with the following attributes.   Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84043324815818579)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_text=>'You have requested to create a tree page with the following attributes. Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83997719911713164)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_text=>'You have requested to create a wizard with the following attributes.  Please confirm your selections.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(851321706328872469)
,p_name=>'CONFIRM.CREATE_WS_APP_TEMPLATE'
,p_message_text=>'You have requested to create a Websheet application using the same ID as an existing Websheet application in the current workspace. The existing Websheet application will be deleted and then replaced by the new Websheet application. Please confirm yo'
||'ur selections. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138426605418559284)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_text=>'Link Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(615639618994709511)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_text=>'Data Load Definition Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(902243418172050374)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_text=>'This Data Load Definition will be recreated with the existing table lookups and transformation rules.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(297302425498916480)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_text=>'Page Number'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84032629271791502)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_text=>'Date Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(175991709779651307)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_text=>'Default Authentication Scheme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83974520248637528)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_text=>'Delete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84198211094174194)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_text=>'Detail %0 Display Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1821022698289204)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_text=>'Detail Display Column(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84206614257203482)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_text=>'Detail Breadcrumb Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84201925770187894)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_text=>'Detail Table %0 Order By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84186212994136871)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_text=>'Detail Page %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1820614733286910)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_text=>'Detail Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84195110963164711)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_text=>'Detail Table Name %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84190831825151808)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_text=>'Detail Tab Label %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(262006612550490724)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_text=>'Upload Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83806217048305430)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_text=>'Display Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(239986813742259852)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_text=>'Upload Column 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(239987010938261114)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_text=>'Upload Column 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84073108810908627)
,p_name=>'CONFIRM.DISPLAY_POINT'
,p_message_text=>'Display Point'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1859452456201370626)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_text=>'Edit Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1859453093801372063)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_text=>'Edit Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135403411593346752)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_text=>'CSV Output'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135411721280973906)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_text=>'Print Output'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135417522066030987)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_text=>'Enable Column Heading Sorting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150950888417606320)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_text=>'A region will be added to the existing Administration Page:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261948711249471482)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_text=>'Finish Branch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84127322588007244)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_text=>'Form Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84127802979011040)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_text=>'Form Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84131125143017377)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_text=>'Form Page Tab Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84130613022013946)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_text=>'Form Page Tab Set'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(176126223883648900)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_text=>'Import Shared Components From'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(497202016211813883)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_text=>'Include Custom Calendar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1821807592294307)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_text=>'Include master report?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84204814126194016)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_text=>'Include a Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83712923160023286)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_text=>'Information Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83714207361028258)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_text=>'Information Default Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22397929884456194)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_text=>'Form Items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(30345527815632745)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_text=>'Form Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(30344620542630727)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_text=>'Form Region Title'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83972424965629402)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_text=>'Insert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83701300173007240)
,p_name=>'CONFIRM.ITEMS'
,p_message_text=>'Items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(262002604239488343)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_text=>'Return Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261859323014399107)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_text=>'Lookup Key Column 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261863529248400974)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_text=>'Key Column 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261867500636402127)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_text=>'Key Column 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84035014164796574)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_text=>'Label Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(239994016865395131)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_text=>'Lookup Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261998631812486824)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_text=>'Lookup Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1822214518296327)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_text=>'Master Detail Layout'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1820208846285276)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_text=>'Master Display Column(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1821400320292291)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_text=>'Navigate master record by'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1819830532282011)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_text=>'Master Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(140201620240601092)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_text=>'Maximum Number of Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138409209802536157)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_text=>'Rows Per Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101146608951668706)
,p_name=>'CONFIRM.MENU'
,p_message_text=>'Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84078523140922214)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_text=>'Breadcrumb Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84205224169196952)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_text=>'Breadcrumb Root'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84076825779913529)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_text=>'Breadcrumb Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84081702839925828)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_text=>'Breadcrumb Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40971311312532524)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6'
,p_message_text=>'You have requested to upgrade the Flash chart to a new Flash 6 chart. Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172607228149115140)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6_XML'
,p_message_text=>'You have requested to upgrade a Flash chart based on custom XML to a new Flash 6 chart.  Due to differences in XML structure between the current and Flash 6 chart, the upgraded chart will not display. You will need to modify the custom XML of the upg'
||'raded chart to use the new XML structure. Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23178110815188985)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5'
,p_message_text=>'You have requested to upgrade the Flash chart to a new HTML5 chart. Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23178623629192693)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5_XML'
,p_message_text=>'You have requested to upgrade a Flash chart based on custom XML to a new HTML5 chart. Due to differences in XML structure between the current and HTML5 chart, the upgraded chart will not display. You will need to modify the custom XML of the upgraded'
||' chart to use the new XML structure. Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23172706604083715)
,p_name=>'CONFIRM.MIGRATE_HTML_TO_HTML5'
,p_message_text=>'You have requested to upgrade the HTML chart to a new HTML5 chart. Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(945251552534553999)
,p_name=>'CONFIRM.MIGRATE_JSTREE_TO_APEXTREE'
,p_message_text=>'You have requested to upgrade the jsTree to a new Tree. Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(73484029469295415)
,p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SVG chart will be upgraded with the following restrictions:  ',
'<ul>',
'<li>',
'Only number formats defined in axis format strings will be migrated.  Date and time formats will be ignored.',
'</li>',
'<li>',
'Number format elements containing the following will be migrated:',
'<br />',
'0,9,D,G,, (comma),. (period),$,C,L,FM',
'</li>',
'<li>',
'The label for each series in the Flash chart will be derived from each series'' column alias.  ',
'This differs from SVG charts, where the label for each series was derived from the Series Name attribute.',
'</li>',
'<li>',
'Flash Dial charts display actual values instead of percentages.',
'</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46897809780048121)
,p_name=>'CONFIRM.MIGRATE_SVG_TO_HTML5'
,p_message_text=>'You have requested to upgrade the SVG chart to a HTML5 chart.  Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(818412717795920577)
,p_name=>'CONFIRM.NAVIGATION'
,p_message_text=>'Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84964129232256696)
,p_name=>'CONFIRM.NAV_BAR'
,p_message_text=>'Navigation Bar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(486936856312805010)
,p_name=>'CONFIRM.NAV_LIST'
,p_message_text=>'Navigation Menu List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183300219613419824)
,p_name=>'CONFIRM.NEW_ADMIN_PAGE'
,p_message_text=>'A new Administration page will be added, Page:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108086300603032691)
,p_name=>'CONFIRM.NEW_COLUMNS'
,p_message_text=>'New Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83743214259153187)
,p_name=>'CONFIRM.NEW_TEMPLATE'
,p_message_text=>'New Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(326296424454484962)
,p_name=>'CONFIRM.NEXT_LABEL'
,p_message_text=>'Next Button label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83681105658904732)
,p_name=>'CONFIRM.NO.TABSET.SELECTED'
,p_message_text=>'No tab set has been selected for this page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83697102466998390)
,p_name=>'CONFIRM.NO_TEMPLATE'
,p_message_text=>'No Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22398303004457852)
,p_name=>'CONFIRM.OUTPUT_ITEMS'
,p_message_text=>'Output Items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83830823459345159)
,p_name=>'CONFIRM.OWNER'
,p_message_text=>'Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83630915907472398)
,p_name=>'CONFIRM.PAGE'
,p_message_text=>'Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84963301528248741)
,p_name=>'CONFIRM.PAGES'
,p_message_text=>'Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83631600108477324)
,p_name=>'CONFIRM.PAGE_NAME'
,p_message_text=>'Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83680707604895771)
,p_name=>'CONFIRM.PAGE_TITLE'
,p_message_text=>'Page Title'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84197231048170548)
,p_name=>'CONFIRM.PARENT_DISPLAY_COLS'
,p_message_text=>'Parent Display Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84083520501930905)
,p_name=>'CONFIRM.PARENT_MENU'
,p_message_text=>'Parent Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84205803176200356)
,p_name=>'CONFIRM.PARENT_MENU_COL'
,p_message_text=>'Parent Breadcrumb Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84199705684182098)
,p_name=>'CONFIRM.PARENT_ORDER_BY'
,p_message_text=>'Parent Table Order By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84185527408131648)
,p_name=>'CONFIRM.PARENT_PAGE'
,p_message_text=>'Parent Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84194218450157460)
,p_name=>'CONFIRM.PARENT_TABLE_NAME'
,p_message_text=>'Parent Table Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83683732501950333)
,p_name=>'CONFIRM.PARENT_TAB_LABEL'
,p_message_text=>'Parent Tab Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83682916224945610)
,p_name=>'CONFIRM.PARENT_TAB_SET'
,p_message_text=>'Parent Tab Set'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108037800020416014)
,p_name=>'CONFIRM.PARSING_SCHEMA'
,p_message_text=>'Parsing Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(113109016577114145)
,p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR'
,p_message_text=>'Partial Page Refresh'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(326300431034486939)
,p_name=>'CONFIRM.PREVIOUS_LABEL'
,p_message_text=>'Previous Button label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83639108990546076)
,p_name=>'CONFIRM.PRIMARY_KEY'
,p_message_text=>'Primary Key Column %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84134515924024248)
,p_name=>'CONFIRM.PRIMARY_KEY_COLUMN'
,p_message_text=>'Primary Key Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138427015115562017)
,p_name=>'CONFIRM.PRINT_FORMAT'
,p_message_text=>'Output Format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(140263022260197709)
,p_name=>'CONFIRM.PRINT_LABEL'
,p_message_text=>'Print Link Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138432405212644324)
,p_name=>'CONFIRM.PRINT_OUTPUT'
,p_message_text=>'Report Printing'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83810010945313161)
,p_name=>'CONFIRM.PROCESS_OPTIONS'
,p_message_text=>'Process Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138411310541564744)
,p_name=>'CONFIRM.REGION_COLUMN'
,p_message_text=>'Region Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83706502382017360)
,p_name=>'CONFIRM.REGION_TEMPLATE'
,p_message_text=>'Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83634724050512649)
,p_name=>'CONFIRM.REGION_TITLE'
,p_message_text=>'Region Title'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84070419415902174)
,p_name=>'CONFIRM.REGION_TYPE'
,p_message_text=>'Region Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108084024021029996)
,p_name=>'CONFIRM.REMOVED_COLUMNS'
,p_message_text=>'Removed Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84140229907037727)
,p_name=>'CONFIRM.REPORT_COLUMNS'
,p_message_text=>'Report Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146155504163285903)
,p_name=>'CONFIRM.REPORT_IMPLEMENTATION'
,p_message_text=>'Report Implementation'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84122401678991717)
,p_name=>'CONFIRM.REPORT_PAGE'
,p_message_text=>'Report Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84123216223995906)
,p_name=>'CONFIRM.REPORT_PAGE_NAME'
,p_message_text=>'Report Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84126911852004107)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL'
,p_message_text=>'Report Page Tab Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84125830768000098)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_SET'
,p_message_text=>'Report Page Tab Set'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(30346630024642892)
,p_name=>'CONFIRM.REPORT_REGION_TEMPLATE'
,p_message_text=>'Report Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(30346223790641127)
,p_name=>'CONFIRM.REPORT_REGION_TITLE'
,p_message_text=>'Report Region Title'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84290214818544312)
,p_name=>'CONFIRM.REPORT_TEMPLATE'
,p_message_text=>'Report Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(32197317394970783)
,p_name=>'CONFIRM.ROW_VERSION_COLUMN'
,p_message_text=>'Row Version Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84295815296553924)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME1'
,p_message_text=>'default: HTML (standard)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84300617505563987)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME11'
,p_message_text=>'default: Look 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84303328240567119)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME12'
,p_message_text=>'default: Look 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(107705726948742483)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME13'
,p_message_text=>'default: Look 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(107707500760744404)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME14'
,p_message_text=>'default: Look 4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(31532527800826069)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME15'
,p_message_text=>'default: Look 5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84297930533558343)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME2'
,p_message_text=>'default: vertical report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84305108285570856)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME21'
,p_message_text=>'export: CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84306817636573518)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME22'
,p_message_text=>'export: XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84299206769560958)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME3'
,p_message_text=>'default: vertical report, look 1 (include null columns)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(107696406385727073)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME4'
,p_message_text=>'default: vertical report, look 2 (exclude null columns)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(107703919330740339)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME5'
,p_message_text=>'default: vertical report, look 2 (include null columns)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(262104926880504309)
,p_name=>'CONFIRM.RULE_NAME'
,p_message_text=>'Rule Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(262128900345506131)
,p_name=>'CONFIRM.RULE_SEQUENCE'
,p_message_text=>'Sequence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(262132904847507404)
,p_name=>'CONFIRM.RULE_TYPE'
,p_message_text=>'Rule Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14409918408338346)
,p_name=>'CONFIRM.RUN_SCRIPT'
,p_message_text=>'You have requested to run the following script.  Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84077510673918613)
,p_name=>'CONFIRM.SEQUENCE'
,p_message_text=>'Sequence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84293027285547888)
,p_name=>'CONFIRM.SORT_OPTION'
,p_message_text=>'Sort Option'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83866207707378452)
,p_name=>'CONFIRM.SQL_QUERY'
,p_message_text=>'SQL Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(113107824411106963)
,p_name=>'CONFIRM.STANDARD_CALENDAR'
,p_message_text=>'Standard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150744926557143983)
,p_name=>'CONFIRM.STARTING_PAGE'
,p_message_text=>'Multiple pages will be created, starting with Page:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83837400041347840)
,p_name=>'CONFIRM.STORED_PROCEDURE_NAME'
,p_message_text=>'Stored Procedure Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108747129005840662)
,p_name=>'CONFIRM.STORED_PROCEDURE_OWNER'
,p_message_text=>'Stored Procedure Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(326383316273492066)
,p_name=>'CONFIRM.SUBMIT_LABEL'
,p_message_text=>'Finish Button Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(926588757347489760)
,p_name=>'CONFIRM.SUBSCRIBE_THEME'
,p_message_text=>'Subscribe Theme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83739605816141345)
,p_name=>'CONFIRM.SUGGESTED_NAME'
,p_message_text=>'Suggested Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172146718334777420)
,p_name=>'CONFIRM.TABLE'
,p_message_text=>'Table / View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172147430454780949)
,p_name=>'CONFIRM.TABLE_COLS'
,p_message_text=>'Summarize By Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(355173116897830984)
,p_name=>'CONFIRM.TABLE_LOOKUPS'
,p_message_text=>'Table Lookups'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83636820502530530)
,p_name=>'CONFIRM.TABLE_NAME'
,p_message_text=>'Table Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83635906650526508)
,p_name=>'CONFIRM.TABLE_OWNER'
,p_message_text=>'Table Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(438030407548222259)
,p_name=>'CONFIRM.TABLE_RULE'
,p_message_text=>'Transformation Rule'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(262136920431511936)
,p_name=>'CONFIRM.TABLE_RULES'
,p_message_text=>'Transformation Rules'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108113313936798447)
,p_name=>'CONFIRM.TABLE_VIEW_NAME'
,p_message_text=>'Table / View Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108112908049796749)
,p_name=>'CONFIRM.TABLE_VIEW_OWNER'
,p_message_text=>'Table / View Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84963718151253552)
,p_name=>'CONFIRM.TABS'
,p_message_text=>'Tabs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83682414708935691)
,p_name=>'CONFIRM.TABSET.INCOMPLETE'
,p_message_text=>'Warning, tabset information is incomplete.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83635525566522484)
,p_name=>'CONFIRM.TAB_LABEL'
,p_message_text=>'Tab Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84231926696330131)
,p_name=>'CONFIRM.TAB_NAME'
,p_message_text=>'Tab Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83635112060518636)
,p_name=>'CONFIRM.TAB_SET'
,p_message_text=>'Tab Set'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84308130103577082)
,p_name=>'CONFIRM.TEMPLATE'
,p_message_text=>'template:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84056714735863028)
,p_name=>'CONFIRM.TREE_LOV'
,p_message_text=>'Based on new item with popup list of values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84054528672848151)
,p_name=>'CONFIRM.TREE_MAX_LEVEL'
,p_message_text=>'Max Levels'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84048902221830992)
,p_name=>'CONFIRM.TREE_NAME'
,p_message_text=>'Tree Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84055323954856200)
,p_name=>'CONFIRM.TREE_QUERY'
,p_message_text=>'Tree Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84057626856866535)
,p_name=>'CONFIRM.TREE_SQL'
,p_message_text=>'Based on a SQL Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84054911141852527)
,p_name=>'CONFIRM.TREE_START'
,p_message_text=>'Start Tree'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84058207940870527)
,p_name=>'CONFIRM.TREE_STATIC'
,p_message_text=>'Static value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84050018151835644)
,p_name=>'CONFIRM.TREE_TYPE'
,p_message_text=>'Tree Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84964508239260082)
,p_name=>'CONFIRM.UI_THEME'
,p_message_text=>'Theme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84964904214268381)
,p_name=>'CONFIRM.UI_THEME1'
,p_message_text=>'Blue and Tan'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84965424300274208)
,p_name=>'CONFIRM.UI_THEME2'
,p_message_text=>'Red'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84965830880276110)
,p_name=>'CONFIRM.UI_THEME4'
,p_message_text=>'Navy and Gray'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84966203306277655)
,p_name=>'CONFIRM.UI_THEME5'
,p_message_text=>'Olive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84966608501279118)
,p_name=>'CONFIRM.UI_THEME6'
,p_message_text=>'Maroon'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84967013349280524)
,p_name=>'CONFIRM.UI_THEME7'
,p_message_text=>'Simple Blue and Tan'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84967421660282932)
,p_name=>'CONFIRM.UI_THEME8'
,p_message_text=>'Blue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84967827894284732)
,p_name=>'CONFIRM.UI_THEME_NONE'
,p_message_text=>'None'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83638722019540369)
,p_name=>'CONFIRM.UPDATEABLE_COLUMNS'
,p_message_text=>'Updateable Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83973806050633440)
,p_name=>'CONFIRM.UPDATE_PROCESS'
,p_message_text=>'Update'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(83681906612923875)
,p_name=>'CONFIRM.USE.EXISTING.TABSET'
,p_message_text=>'This page will use the existing tab set "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22396020094396573)
,p_name=>'CONFIRM.WEB_SERVICE_REF'
,p_message_text=>'Web Service Reference, Operation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84141114454042698)
,p_name=>'CONFIRM.WHERE_CLAUSE'
,p_message_text=>'Where Clause'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166873618268598741)
,p_name=>'CONFIRMATION_ICON'
,p_message_text=>'Confirmation Icon'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172716023045270728)
,p_name=>'CONFIRMED'
,p_message_text=>'Confirmed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172716804476274747)
,p_name=>'CONFIRMED_BY_QA'
,p_message_text=>'Confirmed by QA'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138433303265653176)
,p_name=>'CONFIRM_BREAK_COLUMN'
,p_message_text=>'Break Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(138432816987647720)
,p_name=>'CONFIRM_PRINT_FORMAT'
,p_message_text=>'Print Format'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184527530092492358)
,p_name=>'CONTENT_DISPOSITION'
,p_message_text=>'Content Disposition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(203709630611302300)
,p_name=>'CONTENT_SERVED_IN_KBYTES'
,p_message_text=>'Content Served'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(134758916493975573)
,p_name=>'CONTINUE'
,p_message_text=>'Continue'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3302267252408311822)
,p_name=>'CONTRIBUTORS'
,p_message_text=>'Contributors'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066442187509685842)
,p_name=>'COPY.PAGE.NEW_STATIC_ID'
,p_message_text=>'New Static ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26569212233264608)
,p_name=>'COPYRIGHT'
,p_message_text=>'Copyright &copy; %0, All rights reserved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46517020668056138)
,p_name=>'COPY_APP_SUCCESS_MSG'
,p_message_text=>'Your application has been copied.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(102720203089575632)
,p_name=>'COPY_BUTTON.EXECUTION_ERR'
,p_message_text=>'Error during execution of copy_button: %0 >> %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(115671112908765514)
,p_name=>'COPY_DEPLOYMENT'
,p_message_text=>'Copy Object Definition Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40669212803910647)
,p_name=>'COPY_EXISTING_APP'
,p_message_text=>'Copy Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236701410487836285)
,p_name=>'COPY_FEATURE'
,p_message_text=>'Copy Feature: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(115665011607746282)
,p_name=>'COPY_FROM_APPLICATION'
,p_message_text=>'Copy From Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(377458612114590405)
,p_name=>'COPY_FROM_APP_TEMPLATE'
,p_message_text=>'Based on Template Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(115665825460750295)
,p_name=>'COPY_FROM_NAME'
,p_message_text=>'Copy from Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(47542815619438356)
,p_name=>'COPY_LIST_ENTRY'
,p_message_text=>'Copy List Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(102751817942627200)
,p_name=>'COPY_NAMED_LOV.EXECUTION_ERR'
,p_message_text=>'Error during execution of copy_named_lov: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(102747529932621210)
,p_name=>'COPY_NAMED_LOV.NOT_FOUND_ERR'
,p_message_text=>'List of Values ID "%0" not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(102741206383614374)
,p_name=>'COPY_NAMED_LOV.NUMERIC_ERR'
,p_message_text=>'List of Values ID "%0" is not numeric.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(210014620633797439)
,p_name=>'COPY_PAGE.COPY_FROM_PAGE'
,p_message_text=>'Copy From Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(210015401371801385)
,p_name=>'COPY_PAGE.COPY_TO_PAGE'
,p_message_text=>'Copy To Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(208515000750011720)
,p_name=>'COPY_PAGE.SELECT_AUTHORIZATION'
,p_message_text=>'- Select Authorization-'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(208498619909875377)
,p_name=>'COPY_PAGE.SELECT_LIST'
,p_message_text=>'- Select List -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(208331327285592030)
,p_name=>'COPY_PAGE.SELECT_NAMED_LOV'
,p_message_text=>'- Select List of Values -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270368600686936356)
,p_name=>'COPY_TABLE'
,p_message_text=>'Copy %0 to table %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(115666500657752567)
,p_name=>'COPY_TO_APPLICATION'
,p_message_text=>'Copy To Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(115669012777756014)
,p_name=>'COPY_TO_NAME'
,p_message_text=>'Copy to Name'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88198422380441257)
,p_name=>'CORE'
,p_message_text=>'core'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145295017371075684)
,p_name=>'COUNT'
,p_message_text=>'Count'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(162758813552367449)
,p_name=>'CREATE'
,p_message_text=>'Create'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(359347306899198143)
,p_name=>'CREATE APPLICATION'
,p_message_text=>'Create Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(359353919067230028)
,p_name=>'CREATE OBJECT'
,p_message_text=>'Create Object'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484706413411088670)
,p_name=>'CREATED'
,p_message_text=>'Created'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484706618952090281)
,p_name=>'CREATED_BY'
,p_message_text=>'Created By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236544221265573001)
,p_name=>'CREATED_LAST_7_DAYS'
,p_message_text=>'Created last 7 days'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103917813250886146)
,p_name=>'CREATED_ON'
,p_message_text=>'Created On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40669423885913852)
,p_name=>'CREATE_APP_FROM_TEMPLATE'
,p_message_text=>'From an application template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(618908211023219939)
,p_name=>'CREATE_APP_WIZ.CANDLE_CHARTS'
,p_message_text=>'Candlestick Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(618907814355211391)
,p_name=>'CREATE_APP_WIZ.COL_CHARTS'
,p_message_text=>'2D and 3D Column, Bar and Stacked Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(618915511772324226)
,p_name=>'CREATE_APP_WIZ.GAUGE_CHARTS'
,p_message_text=>'Dial and Dial (Percent) Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(618908025437214669)
,p_name=>'CREATE_APP_WIZ.PIE_CHARTS'
,p_message_text=>'2D and 3D Pie and Doughnut Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(618910226738233977)
,p_name=>'CREATE_APP_WIZ.PROJECTGANTT_CHARTS'
,p_message_text=>'Project Gantt Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(618915202422321555)
,p_name=>'CREATE_APP_WIZ.RANGE_CHARTS'
,p_message_text=>'2D and 3D Range Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(618910903320236649)
,p_name=>'CREATE_APP_WIZ.RESOURCEGANTT_CHARTS'
,p_message_text=>'Resource Gantt Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(618908802497226975)
,p_name=>'CREATE_APP_WIZ.SCATTER_CHARTS'
,p_message_text=>'Scatter Marker Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87880010753981624)
,p_name=>'CREATE_CONDITION.AND'
,p_message_text=>'AND'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87879208544971469)
,p_name=>'CREATE_CONDITION.ARROW_DOWN'
,p_message_text=>'Arrow Down'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87879626552976677)
,p_name=>'CREATE_CONDITION.ARROW_RIGHT'
,p_message_text=>'Arrow Right'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87878327197948501)
,p_name=>'CREATE_CONDITION.COLUMNS'
,p_message_text=>'Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87878820056955889)
,p_name=>'CREATE_CONDITION.CONDITIONS'
,p_message_text=>'Conditions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87880424951985732)
,p_name=>'CREATE_CONDITION.OR'
,p_message_text=>'OR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87881504089998606)
,p_name=>'CREATE_CONDITION.PREVIEW'
,p_message_text=>'Preview Condition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236985217260207312)
,p_name=>'CREATE_DEMO_APP.GRANT'
,p_message_text=>'Click on the Grant Privileges button below to grant these privileges now to %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236982701330202732)
,p_name=>'CREATE_DEMO_APP.NO_CREATE_PRIV'
,p_message_text=>'%0 does not have CREATE TABLE, CREATE VIEW, CREATE TRIGGER, CREATE SEQUENCE or CREATE PROCEDURE privilege and will not be able to install the demonstration application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236984208948204945)
,p_name=>'CREATE_DEMO_APP.NO_EXEC_PRIV'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'%0 does not have execute privilege on CTX_DOC and CTX_DDL and will not be able to install the President''s Inaugural demonstration.  Perform the following grants as a privileged user: ',
'<pre>',
'GRANT EXECUTE ON CTXSYS.CTX_DDL TO %0; ',
'GRANT EXECUTE ON CTXSYS.CTX_DOC TO %0;',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(481306458436268516)
,p_name=>'CREATE_DIALOG_CLOSED_DA'
,p_message_text=>'Create Button - Dialog Closed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12822302047712450)
,p_name=>'CREATE_DYNAMIC_LIST'
,p_message_text=>'Create Dynamic List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108620632556503516)
,p_name=>'CREATE_DYNAMIC_LOV'
,p_message_text=>'Create Dynamic List of Values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5020515591120823)
,p_name=>'CREATE_FLOW.CLOUD_IDM'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19313909795983710)
,p_name=>'CREATE_FLOW.DBACCOUNT'
,p_message_text=>'Database Account'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361689301600139463)
,p_name=>'CREATE_FLOW.HTMLDB_AUTH'
,p_message_text=>'Application Express Authentication'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(238410706844459393)
,p_name=>'CREATE_FLOW.LDAP'
,p_message_text=>'LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(818415061995974022)
,p_name=>'CREATE_FLOW.NAVIGATION_LIST'
,p_message_text=>'Navigation Menu List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361689915106143338)
,p_name=>'CREATE_FLOW.NO_AUTH'
,p_message_text=>'No Authentication'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361686817259049333)
,p_name=>'CREATE_FLOW.NO_TABS'
,p_message_text=>'No Tabs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361687330765053241)
,p_name=>'CREATE_FLOW.ONE_LEVEL_TABS'
,p_message_text=>'One Level of Tabs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(238413104204468005)
,p_name=>'CREATE_FLOW.SSO'
,p_message_text=>'Single Sign On (SSO)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(361687810810056919)
,p_name=>'CREATE_FLOW.TWO_LEVEL_TABS'
,p_message_text=>'Two Levels of Tabs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40669031373906620)
,p_name=>'CREATE_FROM_SPREADSHEET'
,p_message_text=>'From a spreadsheet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3267030017882614)
,p_name=>'CREATE_GLOBAL_PAGE'
,p_message_text=>'Global page components are displayed on all pages if their region''s display point is contained within the selected page template.  Conditional Display attributes can be used to suppress display.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(96878610610811768)
,p_name=>'CREATE_INDEX'
,p_message_text=>'Create Index'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146974531694708406)
,p_name=>'CREATE_ITEM_WIZ.NO_REGION'
,p_message_text=>'no region associated'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88192610381371516)
,p_name=>'CREATE_NEW_LOGIN_PAGE'
,p_message_text=>'Create new login page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87906532513233934)
,p_name=>'CREATE_PACKAGE.BACK'
,p_message_text=>'Back to Create Table Wizard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87903006147197894)
,p_name=>'CREATE_PACKAGE.BROWSE'
,p_message_text=>'Browse Package'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87902231166186180)
,p_name=>'CREATE_PACKAGE.CREATED'
,p_message_text=>'The package "%0" has been created in the "%1" schema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87908128751261177)
,p_name=>'CREATE_PACKAGE.FAILED'
,p_message_text=>'Creating table "%0" failed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87904608141217443)
,p_name=>'CREATE_PACKAGE.HOME'
,p_message_text=>'Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87903804547206903)
,p_name=>'CREATE_PACKAGE.RETURN_TO'
,p_message_text=>'Return to'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87904223940212505)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP'
,p_message_text=>'SQL&nbsp;Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87903418614201542)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME'
,p_message_text=>'SQL Workshop Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87126316003224021)
,p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND'
,p_message_text=>'No items found'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87120925438207806)
,p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS'
,p_message_text=>'Page Items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87125001805219905)
,p_name=>'CREATE_PAGE_ITEM.PROMPT'
,p_message_text=>'Prompt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87122506522211862)
,p_name=>'CREATE_PAGE_ITEM.REGION'
,p_message_text=>'Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87123920721215917)
,p_name=>'CREATE_PAGE_ITEM.SET_REGION'
,p_message_text=>'click to set region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87075818708044990)
,p_name=>'CREATE_PROCESS.PAGE_ITEMS'
,p_message_text=>'Page Items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87077500485049266)
,p_name=>'CREATE_PROCESS.REGION'
,p_message_text=>'Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87899628002156915)
,p_name=>'CREATE_TABLE.HOME'
,p_message_text=>'Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87898129256147797)
,p_name=>'CREATE_TABLE.RETURN_TO'
,p_message_text=>'Return to'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87897407785141651)
,p_name=>'CREATE_TABLE.RUN_SCRIPT'
,p_message_text=>'Run Script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87894509255123107)
,p_name=>'CREATE_TABLE.SCRIPT_CREATED'
,p_message_text=>'The create table script for table %0 has been created in the SQL script repository.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87895703499130887)
,p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY'
,p_message_text=>'Go to Script Repository'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87899117959154028)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP'
,p_message_text=>'SQL&nbsp;Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87896421853136195)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME'
,p_message_text=>'SQL Workshop Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(328774415577711156)
,p_name=>'CREATE_TABULAR_FORM'
,p_message_text=>'Tabular Form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(932215187057657001)
,p_name=>'CREATE_TO_DO'
,p_message_text=>'Create To Do'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270686816240481789)
,p_name=>'CREATE_TRIGGER'
,p_message_text=>'Create trigger %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(227923504193175885)
,p_name=>'CREATE_WS_OBJ_SUCCESS_MSG'
,p_message_text=>'Websheet database objects created.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184693178038789934)
,p_name=>'CREDENTIAL.OWNER'
,p_message_text=>'Credential Owner'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(170067083232545137)
,p_name=>'CSS_CALENDAR'
,p_message_text=>'Calendar'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(136638301939904394)
,p_name=>'CURRENT'
,p_message_text=>'Current'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166135932213196828)
,p_name=>'CURRENT ENTRY'
,p_message_text=>'Current Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166097702412036871)
,p_name=>'CURRENT FORM ELEMENT'
,p_message_text=>'Current form element'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(90151232732051153)
,p_name=>'CURRENT ITEM HELP TEXT'
,p_message_text=>'Current Item Help Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166098106222037924)
,p_name=>'CURRENT ITEM IDENTIFICATION NUMBER'
,p_message_text=>'Current Item Identification Number'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166098819381041767)
,p_name=>'CURRENT ITEM LABEL NAME'
,p_message_text=>'Current Item Label Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(190185901636881615)
,p_name=>'CURRENT TAB'
,p_message_text=>'Current Tab'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86583305232217917)
,p_name=>'CURRENT_APPLICATION'
,p_message_text=>'Current Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86861115339750755)
,p_name=>'CURRENT_IMAGE'
,p_message_text=>'Current Image'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(390643202413553513)
,p_name=>'CURRENT_ITEM_CONTAINER_ID'
,p_message_text=>'ID that can be used on a container element that wraps the current field, in the Before Label and Item attribute.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(955847408211879160)
,p_name=>'CURRENT_ITEM_HELP_LABEL'
,p_message_text=>'Current Item Help Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(69205826774176619)
,p_name=>'CURRENT_MILESTONE'
,p_message_text=>'Current Milestone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86841910313711400)
,p_name=>'CURRENT_PAGE'
,p_message_text=>'Current Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179939314231236701)
,p_name=>'CURRENT_PAGE_CONTAINS_NO_ITEMS'
,p_message_text=>'Current Page Contains No Items.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135121023330680609)
,p_name=>'CUSTOM'
,p_message_text=>'Custom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148956105885348850)
,p_name=>'CUSTOMIZE'
,p_message_text=>'Customize'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(162226704929487232)
,p_name=>'CUSTOMIZE LINK'
,p_message_text=>'Customize Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167528920006287142)
,p_name=>'CUSTOMIZE.USER_PAGE_PREFS_RESET'
,p_message_text=>'Page preferences reset for user %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167529313903294802)
,p_name=>'CUSTOMIZE.USER_PREFS_CHANGED'
,p_message_text=>'Preferences changed for user %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167528513988275909)
,p_name=>'CUSTOMIZE.USER_PREFS_RESET'
,p_message_text=>'Page preferences reset for user %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(573712549030153071)
,p_name=>'CUSTOM_APPLICATIONS'
,p_message_text=>'Custom Applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12749202396995794)
,p_name=>'CUSTOM_AUTH_SCHEME_DESC'
,p_message_text=>'Developer Defined'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100935527759955492)
,p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR'
,p_message_text=>'Error in %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(69336821132118100)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1'
,p_message_text=>'Enter any string to be used as your user identifier for this session.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(69337502909122300)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2'
,p_message_text=>'Enter your %0 username and password.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(69338606157132723)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3'
,p_message_text=>'Enter your username and password for verification by LDAP host: %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(69354024782232780)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4'
,p_message_text=>'Enter your database schema username and password.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(497765815001951590)
,p_name=>'CUSTOM_CALENDAR'
,p_message_text=>'Reload'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(500101730575457743)
,p_name=>'CUSTOM_CALENDAR.END_DATE'
,p_message_text=>'End Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(500101522610455453)
,p_name=>'CUSTOM_CALENDAR.START_DATE'
,p_message_text=>'Start Date'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(272511924560338779)
,p_name=>'DA.SET_VALUE.SQL.HELP_MSG'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When the True Action is Set Value with a Set Type of SQL Statement, you need to define the Affected Elements in the same order as the column order of your SQL statement. The SQL Statement you defined was:</p>',
'<pre>%0</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(73695111722854518)
,p_name=>'DAILY'
,p_message_text=>'Daily'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145056710932458773)
,p_name=>'DATA'
,p_message_text=>'Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(359249325983156343)
,p_name=>'DATA WORKSHOP'
,p_message_text=>'Data Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(105840611346370368)
,p_name=>'DATA.LOAD.ALL_COL_MAPPED'
,p_message_text=>'All %0 columns have been automatically mapped to the %1 table.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(105991816286974911)
,p_name=>'DATA.LOAD.APPEND_INCOMPLETE'
,p_message_text=>'Data in table <code>%0</code> appended with <b id="incompl_success_row_count"></b> new rows. <b class="u-danger-text" id="incompl_fail_row_count"></b> rows rejected.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(105985239488554324)
,p_name=>'DATA.LOAD.APPEND_SUCCESS'
,p_message_text=>'Data in table <code>%0</code> appended with <b id="success_row_count"></b> new rows!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(105987278022579060)
,p_name=>'DATA.LOAD.APPEND_WARNING'
,p_message_text=>'Data in table <code>%0</code> appended with <b id="err_success_row_count"></b> new rows. <b class="u-danger-text" id="err_fail_row_count"></b> rows rejected.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3781904745619163)
,p_name=>'DATA.LOAD.CHOOSE_FILE'
,p_message_text=>'Choose File'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(17030734026113679)
,p_name=>'DATA.LOAD.CONFIGURATION_SAVED'
,p_message_text=>'Configuration Saved!'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(105842173837380473)
,p_name=>'DATA.LOAD.DEFINE_COL_MAPPING'
,p_message_text=>'Please define the column mapping in order to load this data into the %0 table.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3781631818614078)
,p_name=>'DATA.LOAD.DRAG_DROP_FILE_HERE'
,p_message_text=>'Drag and drop file here or'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3781056923595660)
,p_name=>'DATA.LOAD.FILE_FORMATS'
,p_message_text=>'Supported formats csv, xlsx, txt, xml, json'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4334623025332221)
,p_name=>'DATA.LOAD.INVALID_FILE'
,p_message_text=>'Uploaded file is invalid or has wrong extension.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60420631021025987)
,p_name=>'DATA.LOAD.INVALID_SELECTOR'
,p_message_text=>'Invalid XML or JSON selector used.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(358297367813091201)
,p_name=>'DATA.LOAD.JOB_INTERMITTENTLY_FAILED'
,p_message_text=>'Data Loading job execution stopped unexpectedly.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(284069980792277983)
,p_name=>'DATA.LOAD.JOB_NAME'
,p_message_text=>'Data Loading Job in Workspace %0: Load into Table %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(105842359685390468)
,p_name=>'DATA.LOAD.MAP_REMAINING_COLS'
,p_message_text=>'%0 out of %1 columns have been automatically mapped to the %2 table. Please configure the remaining %3 columns.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273683682253831497)
,p_name=>'DATA.LOAD.NO_FILE_CONTENTS'
,p_message_text=>'No data found in uploaded file.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273683824387836303)
,p_name=>'DATA.LOAD.NO_WORKSHEET_CONTENTS'
,p_message_text=>'No data found in worksheet "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3851391954261787)
,p_name=>'DATA.LOAD.NO_XLSX_FILE'
,p_message_text=>'The specified file is not an XLSX file.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(319504465141049485)
,p_name=>'DATA.LOAD.PASTED_DATA'
,p_message_text=>'Pasted Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(105992381678977349)
,p_name=>'DATA.LOAD.REPLACE_INCOMPLETE'
,p_message_text=>'Data in table <code>%0</code> replaced with <b id="incompl_success_row_count"></b> new rows. <b class="u-danger-text" id="incompl_fail_row_count"></b> rows rejected.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(105985431991555679)
,p_name=>'DATA.LOAD.REPLACE_SUCCESS'
,p_message_text=>'Data in table <code>%0</code> replaced with <b id="success_row_count"></b> new rows!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(105987494697581361)
,p_name=>'DATA.LOAD.REPLACE_WARNING'
,p_message_text=>'Data in table <code>%0</code> replaced with <b id="err_success_row_count"></b> new rows. <b class="u-danger-text" id="err_fail_row_count"></b> rows rejected.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(105842513595401913)
,p_name=>'DATA.LOAD.SELECT_COLS'
,p_message_text=>'Please select the columns to load.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(910329911394909439)
,p_name=>'DATABASE'
,p_message_text=>'Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(359354426685232224)
,p_name=>'DATABASE BROWSER'
,p_message_text=>'Database Browser'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(631148003295140550)
,p_name=>'DATABASE.DEMO.SAMPLE.APP'
,p_message_text=>'Sample Database Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(910662500275953503)
,p_name=>'DATABASE_APPLICATION'
,p_message_text=>'Database Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20146512622163987)
,p_name=>'DATABASE_APPLICATIONS'
,p_message_text=>'Database Applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(24283832499156801)
,p_name=>'DATABASE_APPS'
,p_message_text=>'Database Applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(219194119339534265)
,p_name=>'DATABASE_APP_SUCCESS_MSG'
,p_message_text=>'Application <strong>%0</strong> successfully installed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(154784408351737294)
,p_name=>'DATABASE_LINK'
,p_message_text=>'Database Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184168709502897083)
,p_name=>'DATABASE_OBJECT_COUNTS_BY_TYPE'
,p_message_text=>'Database Object Counts by Object Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184183131665253510)
,p_name=>'DATABASE_ROLE_PRIVILEGES'
,p_message_text=>'Database Role Privileges'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23063210655713253)
,p_name=>'DATABASE_USERS'
,p_message_text=>'Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(262591928380410954)
,p_name=>'DATA_GRID'
,p_message_text=>'Data Grid'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623896725654598603)
,p_name=>'DATA_GRIDS'
,p_message_text=>'Data Grids'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623902205054630439)
,p_name=>'DATA_GRID_DATA'
,p_message_text=>'Data Grid Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(600627792229524564)
,p_name=>'DATA_LOAD.ADVANCED_SETTINGS_REGION'
,p_message_text=>'Data Load Advanced Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(48760530208123501)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT'
,p_message_text=>'Date / Number Formats to use'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(48760808858133339)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT_HELP'
,p_message_text=>'Choose whether to provide custom or to use standard format masks'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23680003820515412)
,p_name=>'DATA_LOAD.CHARSET'
,p_message_text=>'File Character Set'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(352821406088222317)
,p_name=>'DATA_LOAD.COLUMN_NAMES'
,p_message_text=>'Column Names'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(344315230805508403)
,p_name=>'DATA_LOAD.COLUMN_NAMES_MAPPING'
,p_message_text=>'Target Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(217696968023180455)
,p_name=>'DATA_LOAD.COLUMN_NAME_ALIASES'
,p_message_text=>'Column Names Aliases'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(472561420018638399)
,p_name=>'DATA_LOAD.CONFIRM'
,p_message_text=>'The data has been successfully uploaded to your table.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(483373612463447211)
,p_name=>'DATA_LOAD.COPY_PASTE'
,p_message_text=>'Copy and Paste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(467703824232343283)
,p_name=>'DATA_LOAD.COPY_PASTE_TEXTAREA'
,p_message_text=>'Copy and Paste Delimited Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(681885100754374518)
,p_name=>'DATA_LOAD.CURRENCY_ITEM'
,p_message_text=>'Currency Symbol'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(681908532530402583)
,p_name=>'DATA_LOAD.CURRENCY_ITEM_HELP'
,p_message_text=>'If your data contains international currency symbol, enter it here. For example, if your data has "&euro;1,234.56" or "&yen;1,234.56", enter "&euro;" or "&yen;".  Otherwise the data will not load correctly.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(24810990922019773)
,p_name=>'DATA_LOAD.DATA_LOADING'
,p_message_text=>'Data Loading'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(600628629324535918)
,p_name=>'DATA_LOAD.DATE_FORMAT_APP'
,p_message_text=>'Use application standard format masks'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(600628881994537859)
,p_name=>'DATA_LOAD.DATE_FORMAT_CUSTOM'
,p_message_text=>'Provide custom formats for uploaded columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(682792718612568932)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The decimal character separates the integer and decimal parts of a number.</p>',
'<p> Any character can be the decimal character. The character specified must be single-byte, and the decimal character must be different from group separator. The character can be a space, but cannot be any numeric character or any of the following c'
||'haracters:</p>',
'<ul class="noIndent">',
'<li>plus (+)</li>',
'<li>hyphen (-)</li> ',
'<li>less than sign (<)</li>',
'<li>greater than sign (>)</li> ',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(682080417648474055)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_ITEM'
,p_message_text=>'Decimal Character'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(217697333751184030)
,p_name=>'DATA_LOAD.DISPLAY'
,p_message_text=>'Display'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(352809701239220907)
,p_name=>'DATA_LOAD.DO_NOT_LOAD'
,p_message_text=>'Do Not Load'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(660541357770378234)
,p_name=>'DATA_LOAD.FAILED'
,p_message_text=>'Preprocessing error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(520162010741385667)
,p_name=>'DATA_LOAD.FAILED_COUNT'
,p_message_text=>'Failed Row(s):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(635274905916505129)
,p_name=>'DATA_LOAD.FAILED_RECORD'
,p_message_text=>'Failed Records'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(681387730293165407)
,p_name=>'DATA_LOAD.FILE_NAME_ITEM'
,p_message_text=>'Name of the file to upload'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(344430615245351315)
,p_name=>'DATA_LOAD.FIRST_COLUMN_NAMES'
,p_message_text=>'Source Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(477689322403086759)
,p_name=>'DATA_LOAD.FIRST_ROW'
,p_message_text=>'First Row has Column Names'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(681539003075242760)
,p_name=>'DATA_LOAD.FIRST_ROW_HELP'
,p_message_text=>'Select this box if your data contains column names in the first row.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(352891732192239287)
,p_name=>'DATA_LOAD.FORMAT'
,p_message_text=>'Date / Number Format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(681726426203344026)
,p_name=>'DATA_LOAD.GLOBALIZATION_REGION'
,p_message_text=>'Globalization'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(682038212191453463)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>A group separator is a character that separates integer groups, for example to show thousands and millions.</p>',
'<p>Any character can be the group separator. The character specified must be single-byte, and the group separator must be different from any other decimal character. The character can be a space, but cannot be a numeric character or any of the follow'
||'ing:</p>',
'<ul class="noIndent">',
'<li>plus (+)</li>',
'<li>hyphen (-)</li> ',
'<li>less than sign (<)</li>',
'<li>greater than sign (>)</li> ',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(681957409374424333)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_ITEM'
,p_message_text=>'Group Separator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(660361174740301619)
,p_name=>'DATA_LOAD.INSERT'
,p_message_text=>'Insert row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(520154029310381614)
,p_name=>'DATA_LOAD.INSERTED_COUNT'
,p_message_text=>'Inserted Row(s):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(672741732280358756)
,p_name=>'DATA_LOAD.IR_MAX_ROW_COUNT'
,p_message_text=>'This query returns more than #MAX_ROW_COUNT# rows, please filter your data to ensure complete results.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(212988505490822595)
,p_name=>'DATA_LOAD.JUSTCHANGED_RECORD'
,p_message_text=>'Records Changed by Another User.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61681511868525395)
,p_name=>'DATA_LOAD.LABEL_CASE_SENSITIVE'
,p_message_text=>'Case Sensitive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61681162300520983)
,p_name=>'DATA_LOAD.LABEL_UNIQUE_COLUMN'
,p_message_text=>'Unique Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(453900718524261345)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_ERROR'
,p_message_text=>'Data Loading Failed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(453969811729268858)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_SUCCESS'
,p_message_text=>'Action Processed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(462491823887292821)
,p_name=>'DATA_LOAD.LOAD_TO'
,p_message_text=>'Import From'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1030462914427048454)
,p_name=>'DATA_LOAD.LOOKUP_FAILED'
,p_message_text=>'Failed to retrieve the lookup value.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485618016749158110)
,p_name=>'DATA_LOAD.MAPPING'
,p_message_text=>'Data / Table Mapping'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261883123670446611)
,p_name=>'DATA_LOAD.MAPPING_PAGE'
,p_message_text=>'Step 2 - Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1013410410856554995)
,p_name=>'DATA_LOAD.NO_PREVIEW'
,p_message_text=>'No file preview available'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(679228403862599545)
,p_name=>'DATA_LOAD.OPTIONAL_ENCLOSE_ITEM'
,p_message_text=>'Optionally Enclosed By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(609913253811028253)
,p_name=>'DATA_LOAD.PROGRESS_TITLE'
,p_message_text=>'Data Load Wizard Progress'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261933530165467476)
,p_name=>'DATA_LOAD.RESULTS_PAGE'
,p_message_text=>'Step 4 - Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(217697116091181686)
,p_name=>'DATA_LOAD.RETURN'
,p_message_text=>'Return'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(212028923407671941)
,p_name=>'DATA_LOAD.REVIEW_COUNT'
,p_message_text=>'To be Reviewed Row(s):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(353255717665386559)
,p_name=>'DATA_LOAD.ROW'
,p_message_text=>'Row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(338393819195613097)
,p_name=>'DATA_LOAD.RULES_PLSQL_EXPRESSION_EXAMPLES'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'to_char(sysdate)',
'',
'my_func (',
'    p_1 => :SAL,',
'    p_2 => :COMM)',
'',
'where SAL and COMM are column names of the uploaded data',
'and my_func is the function that returns the value which will be the new value',
'for the column for which this transformation rule is defined.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(338404200420637003)
,p_name=>'DATA_LOAD.RULES_PLSQL_FUNCTION_EXAMPLES'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'declare',
'    l_result number;',
'begin',
'    l_result := :SAL * :COMM;',
'    return l_result;',
'end;',
'',
'The returned result will be the new value of the column for which this transformation rule is defined.',
'',
':SAL and :COMM refer to the SAL and COMM column names of the uploaded data.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(338404005812634447)
,p_name=>'DATA_LOAD.RULES_SQL_QUERY_EXAMPLES'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'select depno',
' from dept',
'where dname = :DEPTNAME',
'  and loc   = :LOC',
'',
'where :DEPNAME and :LOC refer to DEPNAME and LOC columns names of the uploaded data.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(678828814411489009)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_HELP'
,p_message_text=>'Identify a column separator character. Use <code>\t</code> for tab separators.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(678851330125503058)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_LABEL'
,p_message_text=>'Separator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(217697508301185501)
,p_name=>'DATA_LOAD.SEQUENCE'
,p_message_text=>'Sequence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(942960922324150972)
,p_name=>'DATA_LOAD.SEQUENCE_ACTION'
,p_message_text=>'Sequence : Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(600627395300521656)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS'
,p_message_text=>'Use Advanced Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(600627505257523102)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS_HELP'
,p_message_text=>'Display advanced settings for data loading: Currency Symbol, Decimal Characters, File Encoding or Date Formats'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485545329169133312)
,p_name=>'DATA_LOAD.SOURCE'
,p_message_text=>'Data Load Source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261879115358444253)
,p_name=>'DATA_LOAD.SOURCE_PAGE'
,p_message_text=>'Step 1 - Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(914275118591356269)
,p_name=>'DATA_LOAD.TAB_SEPARTOR_NOTE'
,p_message_text=>'(\t for tab)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276493223165623868)
,p_name=>'DATA_LOAD.TRANSFORMATION_FAILED'
,p_message_text=>'The transformation rule failed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(676794115993978533)
,p_name=>'DATA_LOAD.UNIQUE_COLUMN'
,p_message_text=>'Unique Column %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(660361313874302630)
,p_name=>'DATA_LOAD.UPDATE'
,p_message_text=>'Update row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(520158004854383976)
,p_name=>'DATA_LOAD.UPDATED_COUNT'
,p_message_text=>'Updated Row(s):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1793617060337370917)
,p_name=>'DATA_LOAD.UPLOADED_NULL_VALUE'
,p_message_text=>'Null value was uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(483293503328435147)
,p_name=>'DATA_LOAD.UPLOAD_FILE'
,p_message_text=>'Upload file, comma separated (*.csv) or tab delimited'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485583620774149853)
,p_name=>'DATA_LOAD.UPLOAD_RESULTS'
,p_message_text=>'Data Load Results'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485575713155147603)
,p_name=>'DATA_LOAD.VALIDATION'
,p_message_text=>'Data Validation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261887130942448730)
,p_name=>'DATA_LOAD.VALIDATION_PAGE'
,p_message_text=>'Step 3 - Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(264373716326245308)
,p_name=>'DATA_LOAD_WIZARD_CREATED_SUCCESSFULLY'
,p_message_text=>'The data load wizard pages have been created successfully.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(454005026620273118)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_ERROR'
,p_message_text=>'Data / Table Mapping Failed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(454012800086274968)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_SUCCESS'
,p_message_text=>'Action Processed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(171085145560947445)
,p_name=>'DATA_UPLOAD_COLUMN_MAPPING'
,p_message_text=>'Data Upload Column Mapping'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145135220301612869)
,p_name=>'DATE'
,p_message_text=>'Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(256038129446617484)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID'
,p_message_text=>'Entered Highlighted Date attribute value %0 for item %1 does not match %2 format.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261691912045958964)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID_RELATIVE'
,p_message_text=>'Entered Highlighted Date attribute value %0 for item %1 is not a relative date.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(256038704082629114)
,p_name=>'DATEPICKER.MAX_DATE_INVALID'
,p_message_text=>'Entered Maximum Date attribute value %0 for item %1 does not match %2 format.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261692512176968453)
,p_name=>'DATEPICKER.MAX_DATE_INVALID_RELATIVE'
,p_message_text=>'Entered Maximum Date attribute value %0 for item %1 is not a relative date.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(256038419188623995)
,p_name=>'DATEPICKER.MIN_DATE_INVALID'
,p_message_text=>'Entered Minimum Date attribute value %0 for item %1 does not match %2 format.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261692201786965402)
,p_name=>'DATEPICKER.MIN_DATE_INVALID_RELATIVE'
,p_message_text=>'Entered Minimum Date attribute value %0 for item %1 is not a relative date.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(367650718087522898)
,p_name=>'DATE_ADDED'
,p_message_text=>'Date Added'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(620843423495516542)
,p_name=>'DATE_OF_LAST_RUN'
,p_message_text=>'Oracle Application Express database jobs with time of last run'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87998701979211749)
,p_name=>'DAY'
,p_message_text=>'day'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87999105096212650)
,p_name=>'DAYS'
,p_message_text=>'days'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(191632027649118825)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE'
,p_message_text=>'to final milestone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(191632830550129092)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE_OF_RELASE'
,p_message_text=>'to final milestone of release %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261342003959605902)
,p_name=>'DA_NAME.NATIVE_ADD_CLASS'
,p_message_text=>'Add Class'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(626835418833839278)
,p_name=>'DA_NAME.NATIVE_ALERT'
,p_message_text=>'Alert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(626382321884216912)
,p_name=>'DA_NAME.NATIVE_CANCEL_EVENT'
,p_message_text=>'Cancel Event'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(626835803380844283)
,p_name=>'DA_NAME.NATIVE_CLEAR'
,p_message_text=>'Clear'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(626835628876842210)
,p_name=>'DA_NAME.NATIVE_CONFIRM'
,p_message_text=>'Confirm'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3734450541724)
,p_name=>'DA_NAME.NATIVE_DIALOG_CANCEL'
,p_message_text=>'Cancel Dialog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3734453545253)
,p_name=>'DA_NAME.NATIVE_DIALOG_CLOSE'
,p_message_text=>'Close Dialog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46427217426725881)
,p_name=>'DA_NAME.NATIVE_DISABLE'
,p_message_text=>'Disable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46427011539724180)
,p_name=>'DA_NAME.NATIVE_ENABLE'
,p_message_text=>'Enable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(616985332312478260)
,p_name=>'DA_NAME.NATIVE_EXECUTE_PLSQL_CODE'
,p_message_text=>'Execute PL/SQL Code'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46426628377719504)
,p_name=>'DA_NAME.NATIVE_HIDE'
,p_message_text=>'Hide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(187267306245892988)
,p_name=>'DA_NAME.NATIVE_JAVASCRIPT_CODE'
,p_message_text=>'Execute JavaScript Code'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(457604812163620493)
,p_name=>'DA_NAME.NATIVE_REFRESH'
,p_message_text=>'Refresh'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261353428565764316)
,p_name=>'DA_NAME.NATIVE_REMOVE_CLASS'
,p_message_text=>'Remove Class'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(261353731682765225)
,p_name=>'DA_NAME.NATIVE_SET_CSS'
,p_message_text=>'Set Style'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(427397516319148902)
,p_name=>'DA_NAME.NATIVE_SET_FOCUS'
,p_message_text=>'Set Focus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(187267031740890834)
,p_name=>'DA_NAME.NATIVE_SET_VALUE'
,p_message_text=>'Set Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46426320758717324)
,p_name=>'DA_NAME.NATIVE_SHOW'
,p_message_text=>'Show'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(427397820475150050)
,p_name=>'DA_NAME.NATIVE_SUBMIT_PAGE'
,p_message_text=>'Submit Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(388636357727758698)
,p_name=>'DA_NAME.NATIVE_TREE_COLLAPSE'
,p_message_text=>'Collapse Tree'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(388636132255757718)
,p_name=>'DA_NAME.NATIVE_TREE_EXPAND'
,p_message_text=>'Expand Tree'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(13168625276730447)
,p_name=>'DBACCOUNT_AUTH_SCHEME_DESC'
,p_message_text=>'Database Account'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184824631064713110)
,p_name=>'DB_COLS_CASE_SEN'
,p_message_text=>'Database table and column names are case sensitive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(290111727752564563)
,p_name=>'DB_OBJECT_CREATION_EXCEPTION'
,p_message_text=>'db object creation exception'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(18826730502410402)
,p_name=>'DB_PRODUCT_NAME'
,p_message_text=>'Oracle Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(834494811225784137)
,p_name=>'DB_SERVICES_ALIAS'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(808752222882635106)
,p_name=>'DB_SERVICES_ALL_MIMES'
,p_message_text=>'All Mimes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(833299123196626797)
,p_name=>'DB_SERVICES_CREATE_HANDLER'
,p_message_text=>'Create Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(808768400503638047)
,p_name=>'DB_SERVICES_CREATE_METHOD'
,p_message_text=>'Create Method'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(808760227038636224)
,p_name=>'DB_SERVICES_CREATE_PARAMETER'
,p_message_text=>'Create Parameter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(808764329808637094)
,p_name=>'DB_SERVICES_CREATE_TEMPLATE'
,p_message_text=>'Create Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(860747615097133487)
,p_name=>'DB_SERVICES_DB_SERVICES_MODULE'
,p_message_text=>'RESTful Service Module'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(833053106096612430)
,p_name=>'DB_SERVICES_HANDLER'
,p_message_text=>'Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(870162814936297257)
,p_name=>'DB_SERVICES_HANDLER_BIND_VARIABLE'
,p_message_text=>'Handler Bind Variable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(696578318379108703)
,p_name=>'DB_SERVICES_HANDLER_METHOD'
,p_message_text=>'Handler Method'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(870718429228358187)
,p_name=>'DB_SERVICES_HANDLER_SOURCE'
,p_message_text=>'Handler Source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(696578605312111849)
,p_name=>'DB_SERVICES_HANDLER_SRC_TYPE'
,p_message_text=>'Handler Source Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(808744016995633348)
,p_name=>'DB_SERVICES_METHOD'
,p_message_text=>'Method'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(860774119252134704)
,p_name=>'DB_SERVICES_MODULE_NAME'
,p_message_text=>'Module Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(870555215114335219)
,p_name=>'DB_SERVICES_MODULE_URI'
,p_message_text=>'Module URI Prefix'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(808772503274638831)
,p_name=>'DB_SERVICES_NO_SOURCE'
,p_message_text=>'No Source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(808739914225632553)
,p_name=>'DB_SERVICES_PARAMETER'
,p_message_text=>'Parameter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(867090327207111610)
,p_name=>'DB_SERVICES_RESTFUL_SERVICES'
,p_message_text=>'RESTful Services'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(808748119766634193)
,p_name=>'DB_SERVICES_TEMPLATE'
,p_message_text=>'Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(870585832083340069)
,p_name=>'DB_SERVICES_TEMPLATE_URI'
,p_message_text=>'URI Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(696576048769091661)
,p_name=>'DB_SERVICES_URI'
,p_message_text=>'Uniform Resource Identifier (URI)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(860641311503122959)
,p_name=>'DB_SERVICES_URI_PRIFIX'
,p_message_text=>'URI Prefix'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(860686619814125421)
,p_name=>'DB_SERVICES_URI_TEMPLATE'
,p_message_text=>'URI Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(696578939566114715)
,p_name=>'DB_SERVICE_QUERY_ONE_ROW'
,p_message_text=>'Query One Row'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148729725448916262)
,p_name=>'DEBUG'
,p_message_text=>'Debug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(198604901502478591)
,p_name=>'DEBUGGING_OFF'
,p_message_text=>'Debugging is not enabled for this application.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(195676708098077056)
,p_name=>'DECLINED'
,p_message_text=>'Declined'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1614996593681258700)
,p_name=>'DEFAULT_DIALOGBTNR_TEMPLATE'
,p_message_text=>'Default Dialog Button Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1614996349518256716)
,p_name=>'DEFAULT_DIALOGR_TEMPLATE'
,p_message_text=>'Default Dialog Content Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(454925418312976152)
,p_name=>'DEFAULT_PAGE'
,p_message_text=>'Default Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145392019551208775)
,p_name=>'DEFAULT_TABLESPACE'
,p_message_text=>'default tablespace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145568814637377715)
,p_name=>'DEFAULT_TABLESPACE_INIT'
,p_message_text=>'Default Tablespace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(345031628101716386)
,p_name=>'DEFAULT_TEMPLATE'
,p_message_text=>'Default Template'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(11582712872251962)
,p_name=>'DEFINED_BY_DA'
,p_message_text=>'Defined by Dynamic Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(492149208444795988)
,p_name=>'DEFINED_TABS'
,p_message_text=>'This application has %0 tabs organized into %1 tab sets, and has defined %2 parent tabs.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108559622945131752)
,p_name=>'DEFINE_LOV'
,p_message_text=>'Define List of Values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(163582030440385864)
,p_name=>'DEFINITION'
,p_message_text=>'Definition'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282818412512204797)
,p_name=>'DEINSTALLATION_SCRIPT'
,p_message_text=>'Deinstallation Script'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88056620604661839)
,p_name=>'DELETE'
,p_message_text=>'delete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(42403117645694538)
,p_name=>'DELETED'
,p_message_text=>'Deleted'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623895004006554445)
,p_name=>'DELETE_APPLICATION'
,p_message_text=>'Delete Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(330209506788980954)
,p_name=>'DELETE_LABEL'
,p_message_text=>'Delete: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(305245848343039293)
,p_name=>'DELETE_LINK_TEXT'
,p_message_text=>'Delete %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21614331722420760)
,p_name=>'DELETE_MSG'
,p_message_text=>'Would you like to perform this delete action?'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25832517547574167)
,p_name=>'DEMO.COLLECT.DESCR'
,p_message_text=>'Collections Showcase enables you to store rows of data for use within a Oracle Application Express session. This database application illustrates how to use PL/SQL to create and manage collection-based session state.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25831504818551543)
,p_name=>'DEMO.SAMPLE.APP'
,p_message_text=>'Sample Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25831920055555978)
,p_name=>'DEMO.SAMPLE.APP.DESCR'
,p_message_text=>'Product Portal is a sample application that highlights common design concepts. It includes dedicated pages for customers, products, and orders as well as demonstrates the use of reports, charts, calendar, map, and tree.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(174644812235660365)
,p_name=>'DEMONSTRABLE'
,p_message_text=>'Demonstrable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86639518073448693)
,p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK'
,p_message_text=>'Examples of robust reports and pagination concepts.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86633502920425421)
,p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE'
,p_message_text=>'Example of on-line store built using %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86647610978484497)
,p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL'
,p_message_text=>'Learn about using Oracle Text with %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86653513318504148)
,p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING'
,p_message_text=>'Example of project status tracking application built with %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86642316257467134)
,p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES'
,p_message_text=>'Learn to use webservices with %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86623500533377424)
,p_name=>'DEMO_APPLICATION.ACTION'
,p_message_text=>'Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86525609238058166)
,p_name=>'DEMO_APPLICATION.APPLICATION'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86521617764051253)
,p_name=>'DEMO_APPLICATION.BASIC_LEXER'
,p_message_text=>'BASIC_LEXER'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86638504913444896)
,p_name=>'DEMO_APPLICATION.BUSINESS_LOOK'
,p_message_text=>'Business Look'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86624401010387021)
,p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE'
,p_message_text=>'Collection Showcase'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86522827461054037)
,p_name=>'DEMO_APPLICATION.CONTEXT_INDEX'
,p_message_text=>'CONTEXT INDEX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86510714124012310)
,p_name=>'DEMO_APPLICATION.CREATE_BASIC'
,p_message_text=>'You are about to create Basic Examples Demo Application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86100731729913303)
,p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK'
,p_message_text=>'You are about to (re)create business look Demo Application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86512630746017160)
,p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE'
,p_message_text=>'You are about to create the Collections Showcase Demo Application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86515319927032940)
,p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE'
,p_message_text=>'create or recreate in schema %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86097707488906306)
,p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES'
,p_message_text=>'Create an example application to demonstrate web services.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86102321471919779)
,p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA'
,p_message_text=>'You are about to create WorldCup Mania Demo Application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15092706680478500)
,p_name=>'DEMO_APPLICATION.DEINSTALL'
,p_message_text=>'Remove'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86622409060370419)
,p_name=>'DEMO_APPLICATION.DEMO_APP'
,p_message_text=>'Demo Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86535014910069267)
,p_name=>'DEMO_APPLICATION.FREE_SPACE'
,p_message_text=>'You have about %0 MB free.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86628122743412220)
,p_name=>'DEMO_APPLICATION.INSTALL'
,p_message_text=>'Install'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86625514647400427)
,p_name=>'DEMO_APPLICATION.INSTALLED'
,p_message_text=>'Installed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(122982709993673959)
,p_name=>'DEMO_APPLICATION.INSTALL_DEMO_APP'
,p_message_text=>'You are about to install the Sample Application, which demonstrates the key features of %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86637510323437040)
,p_name=>'DEMO_APPLICATION.INSTALL_NOW'
,p_message_text=>'Install Now'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86624920403392658)
,p_name=>'DEMO_APPLICATION.LEARN_ABOUT'
,p_message_text=>'Learn about %0 shopping cart concepts.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(313624608662862080)
,p_name=>'DEMO_APPLICATION.LOCKED'
,p_message_text=>'Locked'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86531228977063909)
,p_name=>'DEMO_APPLICATION.NEED_7M'
,p_message_text=>'The Presidential Inaugural Address Demonstration requires about 7 MB of free disk space and may take up to two minutes to install in your schema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(122831228619423792)
,p_name=>'DEMO_APPLICATION.NOT_ENOUGH_SPACE_ERR'
,p_message_text=>'There was not enough space to create this demonstration.  Request additional storage by going to the administration page, go to provisioning services and click the link to request additional storage. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86627209584408409)
,p_name=>'DEMO_APPLICATION.NOT_INSTALLED'
,p_message_text=>'Not Installed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86484212645955102)
,p_name=>'DEMO_APPLICATION.OBJECT_EXIST'
,p_message_text=>'Exist'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86096209088897267)
,p_name=>'DEMO_APPLICATION.OBJECT_EXISTS'
,p_message_text=>'exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86473730175950682)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86517915902041262)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME2'
,p_message_text=>'Object Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86096825711902091)
,p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS'
,p_message_text=>'not exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86467506711925047)
,p_name=>'DEMO_APPLICATION.OBJECT_RECREATE'
,p_message_text=>'The following database objects will be recreated if they exist'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86472916323946682)
,p_name=>'DEMO_APPLICATION.OBJECT_TYPE'
,p_message_text=>'Object Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86507026806006531)
,p_name=>'DEMO_APPLICATION.PACKAGE'
,p_message_text=>'Package'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86631413870419120)
,p_name=>'DEMO_APPLICATION.PETSTORE'
,p_message_text=>'Pet store'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86646724353478911)
,p_name=>'DEMO_APPLICATION.PRESIDENTIAL'
,p_message_text=>'Presidential Inaugural Addresses'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86652229463499345)
,p_name=>'DEMO_APPLICATION.PROJECT_TRACKING'
,p_message_text=>'Project Tracking'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145933418006022093)
,p_name=>'DEMO_APPLICATION.RE_INSTALL'
,p_message_text=>'Re-install'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86626029192404645)
,p_name=>'DEMO_APPLICATION.RUN'
,p_message_text=>'Run'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86468720217928959)
,p_name=>'DEMO_APPLICATION.SCHEMA'
,p_message_text=>'Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86503729445997814)
,p_name=>'DEMO_APPLICATION.SEQUENCE'
,p_message_text=>'Sequence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86622922219374241)
,p_name=>'DEMO_APPLICATION.STATUS'
,p_message_text=>'Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86492611391964173)
,p_name=>'DEMO_APPLICATION.TABLE'
,p_message_text=>'Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86620423127364980)
,p_name=>'DEMO_APPLICATION.TABLE_SUMMARY'
,p_message_text=>'Demonstration Application Install Status Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86505108452001239)
,p_name=>'DEMO_APPLICATION.TRIGGER'
,p_message_text=>'Trigger'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(313676104908502024)
,p_name=>'DEMO_APPLICATION.UNLOCKED'
,p_message_text=>'Unlocked'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23242703577590357)
,p_name=>'DEMO_APPLICATION.UPDATE_AVAILABLE'
,p_message_text=>'Update Available'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1029914158067751753)
,p_name=>'DEMO_APPLICATION.WEBSHEET_OBJECT_VALIDATE'
,p_message_text=>'The following invalid objects need to be corrected in order to run Websheets properly'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86640725476460289)
,p_name=>'DEMO_APPLICATION.WEB_SERVICES'
,p_message_text=>'Web Services'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86537630971083428)
,p_name=>'DEMO_APPLICATION.WILL_ERROR'
,p_message_text=>'You may experience an error if you are not recreating this demonstration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(50836014165298463)
,p_name=>'DEMO_FLOW.CREATED_ERROR'
,p_message_text=>'There was not enough space to create this demonstration.  Request additional storage by going to the administration page, and clicking on the "Request Changes to Current Service" link.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(50835403776295415)
,p_name=>'DEMO_FLOW.CREATED_SUCCESS'
,p_message_text=>'The %0 demonstration application was created.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(480758127693408050)
,p_name=>'DEPRECATED'
,p_message_text=>'Deprecated'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(36720023900411452)
,p_name=>'DERIVED$'
,p_message_text=>'derived column'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(174644425610654818)
,p_name=>'DESIRABLE'
,p_message_text=>'Desirable'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(228702619717448415)
,p_name=>'DETAIL'
,p_message_text=>'Detail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277486928313626173)
,p_name=>'DETAILS_FOR_ALT_TAG'
,p_message_text=>'Details'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(228739531108499058)
,p_name=>'DETAIL_2'
,p_message_text=>'Detail 2'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(17810404748954428)
,p_name=>'DEVELOPER'
,p_message_text=>'Developer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(293190322524322629)
,p_name=>'DEVELOPERS'
,p_message_text=>'Developers'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184172513415030584)
,p_name=>'DEVELOPER_ACTIVITY_SUMMARY'
,p_message_text=>'Developer Activity Summary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(192133732493924765)
,p_name=>'DEVELOPER_SUMMARY'
,p_message_text=>'Developer Summary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(360140386507888882)
,p_name=>'DEVELOPER_TOOLBAR_CLEAR'
,p_message_text=>'Clear'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(360140125773885528)
,p_name=>'DEVELOPER_TOOLBAR_COPY'
,p_message_text=>'Copy'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366642448785309569)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LABEL'
,p_message_text=>'Debug (%0)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366641626667300575)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL'
,p_message_text=>'Default Debug Level'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366641861195302368)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL4'
,p_message_text=>'Info (default)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366642012920304246)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL6'
,p_message_text=>'App Trace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(366642200394306469)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL9'
,p_message_text=>'Full Trace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(353746132583436489)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS'
,p_message_text=>'One or more errors have occurred since the page loaded. Open the Browser''s JavaScript console to see the errors.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(355175192670438833)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS_BTN'
,p_message_text=>'JavaScript Errors'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(386897861761240703)
,p_name=>'DEVELOPER_TOOLBAR_NO_BUILDER'
,p_message_text=>'This functionality requires the Application Express App Builder window to be open. Do you want to open the Builder in this window?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(381273200466580477)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS'
,p_message_text=>'Developer Toolbar Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(384555059549864274)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_AUTO_HIDE'
,p_message_text=>'Auto Hide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(384555419711870333)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_DISPLAY'
,p_message_text=>'Display Position'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(384555291942867299)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_ICONS_ONLY'
,p_message_text=>'Show Icons Only'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(384555814973874379)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_BOTTOM'
,p_message_text=>'Bottom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(384555656409872765)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_LEFT'
,p_message_text=>'Left'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(384556064886876117)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_RIGHT'
,p_message_text=>'Right'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(385761552293309631)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_TOP'
,p_message_text=>'Top'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(355989664736465271)
,p_name=>'DEVELOPER_TOOLBAR_PAGE_INFO'
,p_message_text=>'Page Info'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(356002468951508889)
,p_name=>'DEVELOPER_TOOLBAR_PERF_TITLE'
,p_message_text=>'Page Performance Timing'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(381358960615424454)
,p_name=>'DEVELOPER_TOOLBAR_QUICK_EDIT'
,p_message_text=>'Quick Edit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(355999028492503322)
,p_name=>'DEVELOPER_TOOLBAR_SHOW_PERF'
,p_message_text=>'Show Page Timing'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1204379270876804968)
,p_name=>'DEVELOPER_TOOLBAR_THEME_ROLLER'
,p_message_text=>'Theme Roller'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382663032436820803)
,p_name=>'DEVELOPER_TOOLBAR_TITLE'
,p_message_text=>'Developer Toolbar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(171867412470876722)
,p_name=>'DEVELOPMENT_TASK'
,p_message_text=>'Development Task'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(296084422964260258)
,p_name=>'DIAL_CHART_ALERT_VALUE'
,p_message_text=>'Alert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(296083516385258328)
,p_name=>'DIAL_CHART_HIGH_VALUE'
,p_message_text=>'High'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(296083010497256643)
,p_name=>'DIAL_CHART_LOW_VALUE'
,p_message_text=>'Low Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1814327920326252)
,p_name=>'DIAL_PCT'
,p_message_text=>'Dial (Percent)'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25298122802560928)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATIONS'
,p_message_text=>'Applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25303424842608773)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTH'
,p_message_text=>'Authentication Schemes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25303600732611242)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTHORIZATION'
,p_message_text=>'Authorization Schemes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25301813283595956)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BC_ENTRIES'
,p_message_text=>'Entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25301607742594383)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BREADCRUMBS'
,p_message_text=>'Breadcrumbs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1980048219402510376)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BUILD_OPTIONS'
,p_message_text=>'Build Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25300910035585579)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_COMPUTATIONS'
,p_message_text=>'Application Computations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25301403240593082)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_ITEMS'
,p_message_text=>'Application Items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25302018824597563)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LISTS'
,p_message_text=>'Lists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25302223672598958)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LIST_ENTRIES'
,p_message_text=>'Entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25302430252600892)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOVS'
,p_message_text=>'List of Values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9202606977180731)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_COLS'
,p_message_text=>'List of Value Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25302603025602424)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_ENTRIES'
,p_message_text=>'Entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25302808566604098)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_NAV_BAR'
,p_message_text=>'Navigation Bars'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25298327650562264)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGES'
,p_message_text=>'Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25300700685582832)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BRANCHES'
,p_message_text=>'Branches'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25299121201569922)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BUTTONS'
,p_message_text=>'Buttons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(153864276128707774)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHARTS'
,p_message_text=>'Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(153864632540710785)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_A'
,p_message_text=>'Axes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(153864490797709415)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_S'
,p_message_text=>'Series'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25300116830578077)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_COMP'
,p_message_text=>'Computations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40262323537603241)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA'
,p_message_text=>'Dynamic Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40262510855609094)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA_ACTS'
,p_message_text=>'Dynamic Action - Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(457139809817357979)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5'
,p_message_text=>'Flash 5 Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(457140116743359964)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5_S'
,p_message_text=>'Series'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25299327435571679)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_CH'
,p_message_text=>'Flash Charts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25299532283573041)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_S'
,p_message_text=>'Series'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25299705402574756)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR'
,p_message_text=>'IR Regions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25299911982576690)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR_COL'
,p_message_text=>'Report Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25298709080566394)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_ITEMS'
,p_message_text=>'Page Items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25300528258581348)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_PROC'
,p_message_text=>'Processes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25298500077563817)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REGIONS'
,p_message_text=>'Regions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(573536325941511679)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REG_COLS'
,p_message_text=>'Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25298916007568367)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_RPT_COLS'
,p_message_text=>'Report Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(803509317745097730)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_TREES'
,p_message_text=>'Trees'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25300322025579558)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_VAL'
,p_message_text=>'Validations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25303014799605856)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PARENT_TABS'
,p_message_text=>'Parent Tabs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25301122502589172)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PROCESSES'
,p_message_text=>'Application Processes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(972898512937938103)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_LAYOUTS'
,p_message_text=>'Report Layouts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(978742247507281708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QRY_STMTS'
,p_message_text=>'Report Query SQL Statements'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(972898399932936898)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QUERIES'
,p_message_text=>'Report Queries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(659977078006490487)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SETTINGS'
,p_message_text=>'Application Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25303806273612922)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SHORTCUTS'
,p_message_text=>'Shortcuts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(24585407027078375)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_STATIC_FILES'
,p_message_text=>'Application Files'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25306831122638922)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUBSTITUTIONS'
,p_message_text=>'Substitutions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1980047693313506828)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJECTS'
,p_message_text=>'Supporting Objects'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1980047862409507939)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_BOPT'
,p_message_text=>'Supporting Objects-Build Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25306420387635911)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_CHCK'
,p_message_text=>'Supporting Objects-Validations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25306626274637532)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_SCR'
,p_message_text=>'Supporting Objects-Scripts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25303219301607190)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TABS'
,p_message_text=>'Tabs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25304629475619537)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BC'
,p_message_text=>'Breadcrumb Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25304801902621117)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BUTTON'
,p_message_text=>'Button Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25305012291624108)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_CALENDAR'
,p_message_text=>'Calendar Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46096213775712442)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_GRID'
,p_message_text=>'Grid Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25305217139625509)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LABEL'
,p_message_text=>'Label Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25305422334626928)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LIST'
,p_message_text=>'List Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25305626836628302)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_PAGE'
,p_message_text=>'Page Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25305832723630018)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_POPUPLOV'
,p_message_text=>'Popup LOV Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25306007573632140)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REGION'
,p_message_text=>'Region Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25306213807633997)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REPORT'
,p_message_text=>'Report Templates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25304423588617828)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEMES'
,p_message_text=>'Themes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22471918393334546)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_FILES'
,p_message_text=>'Theme Files'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4404910736916502)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_STYLES'
,p_message_text=>'Theme Styles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184622614836817675)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANSLATIONS'
,p_message_text=>'Text Messages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20700923873719648)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_DYNAMIC'
,p_message_text=>'Dynamic Translations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20701132184722136)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_REPOS'
,p_message_text=>'Translatable Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25304218047616285)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TREES'
,p_message_text=>'Trees'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25304012506614625)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_WEB_SERVICES'
,p_message_text=>'Web Services'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(726145854627236327)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_ROLES'
,p_message_text=>'Access Control Roles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(726167576938240101)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USERS'
,p_message_text=>'Access Control Users'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(213698187815497496)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USER_ROLES'
,p_message_text=>'Access Control User Role Assignment'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1018712666401555678)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_CONCATENATED_FILES'
,p_message_text=>'Concatenated Files'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160793077882317301)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILES'
,p_message_text=>'Data Parsing Profiles'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160793203513318786)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILE_COLS'
,p_message_text=>'Data Parsing Profile Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1412618625300025145)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DEVELOPER_COMMENTS'
,p_message_text=>'Developer Comments'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(438005425079217783)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE'
,p_message_text=>'Data Load Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(431147405285707613)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLES'
,p_message_text=>'Data Load Tables'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(431207111519709450)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_LOOKUPS'
,p_message_text=>'Data Load Table Lookups'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(431254819137711646)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_RULES'
,p_message_text=>'Data Load Table Transformation Rules'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6355510169032202)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CALENDARS'
,p_message_text=>'Calendar Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382292046190893480)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IGS'
,p_message_text=>'Interactive Grid Regions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382292212545898262)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COLUMNS'
,p_message_text=>'Report Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(382292498099900066)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COL_GROUPS'
,p_message_text=>'Column Groups'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(28180907816420685)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGINS'
,p_message_text=>'Plug-ins'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(28181119244423990)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTRIBUTES'
,p_message_text=>'Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184246512825879782)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTR_VALUES'
,p_message_text=>'Values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(48607312036937762)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_EVENTS'
,p_message_text=>'Events'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(29914022361373053)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_FILES'
,p_message_text=>'Files'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(229787870621608090)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ITEM_FILTERS'
,p_message_text=>'Filter Operators'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1980048074915509101)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_SETTINGS'
,p_message_text=>'Component Settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(835956048613350616)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_STD_ATTRS'
,p_message_text=>'Plug-In Standard Attribute Meta Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160792862016313926)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_REMOTE_SQL'
,p_message_text=>'REST Enabled SQL Servers'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(573146723726150452)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPTIONS'
,p_message_text=>'Template Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1980047452063505090)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GROUPS'
,p_message_text=>'Template Option Groups'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(686997998172447583)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GRP'
,p_message_text=>'Template Option Group'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1133443428743194825)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_PAGE_DP'
,p_message_text=>'Display Points'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1133443614551196137)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_REGION_DP'
,p_message_text=>'Display Points'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(47715223352407140)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_THEME_DISPLAY_POINTS'
,p_message_text=>'Theme Display Points'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(24584931612066917)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_USER_INTERFACES'
,p_message_text=>'User Interfaces'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160794298871328000)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_COMP_PARAMS'
,p_message_text=>'Component Web Source Parameters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160793662266322576)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_MODULES'
,p_message_text=>'Web Source Modules'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160793812375324171)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_OPERATIONS'
,p_message_text=>'Web Source Operations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160794059255325819)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_PARAMETERS'
,p_message_text=>'Web Source Parameters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160793463285320890)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_SERVERS'
,p_message_text=>'Web Source Remote Servers'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(856780615481386063)
,p_name=>'DISABLED_NEXT_BUTTON'
,p_message_text=>'Disabled Next Button'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(856768711672384969)
,p_name=>'DISABLED_PREVIOUS_BUTTON'
,p_message_text=>'Disabled Previous Button'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270691318496520205)
,p_name=>'DISABLE_TRIGGER'
,p_message_text=>'Disable trigger %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86865117548760809)
,p_name=>'DISPLAY_CONDITION'
,p_message_text=>'Display Condition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86866805212766707)
,p_name=>'DISPLAY_CONDITION_TEXT'
,p_message_text=>'Display Condition Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(330745710183192592)
,p_name=>'DISPLAY_ORDER_LABEL'
,p_message_text=>'Display Order: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(32496506841842752)
,p_name=>'DISPLAY_TYPE'
,p_message_text=>'Display Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1959701514123060257)
,p_name=>'DISPLAY_VALUE.N'
,p_message_text=>'Display Value: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(820473830149557306)
,p_name=>'DISTINCT_PAGES'
,p_message_text=>'Distinct Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(820474114696562256)
,p_name=>'DISTINCT_USERS'
,p_message_text=>'Distinct Users'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9200522165667512)
,p_name=>'DML_FORM'
,p_message_text=>'DML Form'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114391602227012711)
,p_name=>'DO NOT UPDATE PAGE ITEMS'
,p_message_text=>'DO_NOT_UPDATE_PAGE_ITEMS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183994729169597113)
,p_name=>'DOC_IMPACT'
,p_message_text=>'Documentation Impact'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183998807744619317)
,p_name=>'DOC_STATUS'
,p_message_text=>'Documentation Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183999415709621603)
,p_name=>'DOC_WRITER'
,p_message_text=>'Documentation Writer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131525828309214179)
,p_name=>'DOWN'
,p_message_text=>'Down'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12363527035828372)
,p_name=>'DOWNLOAD'
,p_message_text=>'Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184528229792520693)
,p_name=>'DOWNLOAD_LINK_TEXT'
,p_message_text=>'Download Link Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114388432440002543)
,p_name=>'DO_NOT_UPDATE_APPLICATION_ITEMS'
,p_message_text=>'Do not update application items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114390109714005492)
,p_name=>'DO_NOT_UPDATE_DATA_ENTRY_ITEMS'
,p_message_text=>'Do not update data entry items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114391022528009163)
,p_name=>'DO_NOT_UPDATE_DISPLAY_ONLY_ITEMS'
,p_message_text=>'Do not update display-only items'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114387304950985129)
,p_name=>'DO_NOT_UPDATE_PAGES'
,p_message_text=>'Do not update pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114499007559840034)
,p_name=>'DO_NOT_UPDATE_PAGE_ITEMS'
,p_message_text=>'Do not update page items'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(77645421757592088)
,p_name=>'DRAG_AND_DROP'
,p_message_text=>'Drag and Drop'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26822732038167865)
,p_name=>'DRILLDOWN'
,p_message_text=>'Drill Down'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26822328574166869)
,p_name=>'DRILLUP'
,p_message_text=>'Drill Up'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88171105019057676)
,p_name=>'DRIVEN'
,p_message_text=>'driven'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270689520312501856)
,p_name=>'DROP TRIGGER'
,p_message_text=>'Drop trigger %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270362200161898315)
,p_name=>'DROP_COLUMN'
,p_message_text=>'Drop Column %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(418847524033673598)
,p_name=>'DS_ACCESS_METHOD'
,p_message_text=>'Access Method'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(418819928057665325)
,p_name=>'DS_BIND_VARIABLE_NAME'
,p_message_text=>'Bind Variable Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(418893519662681756)
,p_name=>'DS_HANDLER'
,p_message_text=>'Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(419019521655701272)
,p_name=>'DS_ITEMS_PER_PAGE'
,p_message_text=>'Items Per Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(418976600877695258)
,p_name=>'DS_MIME_TYPES_ALLOWED'
,p_message_text=>'MIME Types Allowed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(419007813690698969)
,p_name=>'DS_ORIGINS_ALLOWED'
,p_message_text=>'Origins Allowed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(418855400615676314)
,p_name=>'DS_PARAMETER_TYPE'
,p_message_text=>'Parameter Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(419027432391704379)
,p_name=>'DS_SECURITY_CONSTRAINT'
,p_message_text=>'Security Constraint'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(418839615375671058)
,p_name=>'DS_SOURCE'
,p_message_text=>'Source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(418926904555686898)
,p_name=>'DS_SOURCE_TYPE'
,p_message_text=>'Source Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(419039413821708472)
,p_name=>'DS_URI_PREFIX'
,p_message_text=>'URI Prefix'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(418738202300648453)
,p_name=>'DS_URI_TEMPLATE'
,p_message_text=>'URI Template'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(980680785332625341)
,p_name=>'DUE'
,p_message_text=>'Due'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183998228738615949)
,p_name=>'DUE_DATE'
,p_message_text=>'Due Date'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172717500236292467)
,p_name=>'DUPLICATE'
,p_message_text=>'Duplicate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(829735346009007045)
,p_name=>'DUPLICATE_USER'
,p_message_text=>'Duplicate user in list'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(487075712102088261)
,p_name=>'DUP_USER'
,p_message_text=>'Duplicate Username within list.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4521519772939447)
,p_name=>'DYNAMIC ACTION'
,p_message_text=>'Dynamic Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4521314577937997)
,p_name=>'DYNAMIC ACTIONS'
,p_message_text=>'Dynamic Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(8483313274523015)
,p_name=>'DYNAMIC_FORM'
,p_message_text=>'Dynamic Form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(42485347173711860)
,p_name=>'DYNAMIC_HTML'
,p_message_text=>'Dynamic HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(75583618448331157)
,p_name=>'DYNAMIC_QUERY'
,p_message_text=>'Interactive Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2482320333924478)
,p_name=>'DYNAMIC_REFERENCE'
,p_message_text=>'Dynamic Reference'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(107656122999656198)
,p_name=>'EASY_REPORT.INVALID_CONDITION'
,p_message_text=>'The condition you are adding has caused the query to be invalid.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26824420525183413)
,p_name=>'EDIT'
,p_message_text=>'Edit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5961703297676406)
,p_name=>'EDIT PAGE GROUP'
,p_message_text=>'Edit Page Group'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(203707602014515361)
,p_name=>'EDITOR_EXIT'
,p_message_text=>'You will loose unsaved changes if you choose OK.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(17524809329912576)
,p_name=>'EDIT_ALL'
,p_message_text=>'Edit All'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108520607008660982)
,p_name=>'EDIT_ALL_PAGE_DEFINITION_ATTRIBUTES'
,p_message_text=>'Edit all page definition attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(196571121853984806)
,p_name=>'EDIT_ALL_REGION'
,p_message_text=>'Edit all items in this region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(165849123481033944)
,p_name=>'EDIT_APPLICATION'
,p_message_text=>'Edit Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(227298415750327626)
,p_name=>'EDIT_ATTRIBUTE'
,p_message_text=>'Edit Attribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(623896109116574858)
,p_name=>'EDIT_AUTHENTICATION'
,p_message_text=>'Edit Authentication'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(209279114711024779)
,p_name=>'EDIT_COMPONENT'
,p_message_text=>'Edit Component'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(227304624024377369)
,p_name=>'EDIT_COMPONENT_DEF'
,p_message_text=>'Edit Component Definition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(304860839623544861)
,p_name=>'EDIT_LINK_TEXT'
,p_message_text=>'Edit %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(227290119035290700)
,p_name=>'EDIT_LIST_DEV'
,p_message_text=>'Edit List Definition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(926816628335129335)
,p_name=>'EDIT_LOCK'
,p_message_text=>'Edit Lock'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148724424971906642)
,p_name=>'EDIT_PAGE'
,p_message_text=>'Edit Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109823904326721164)
,p_name=>'EDIT_PAGE_ATTRIBUTES'
,p_message_text=>'Edit page attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485854150589995875)
,p_name=>'EDIT_PROFILE'
,p_message_text=>'Edit Profile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(495340620321711192)
,p_name=>'EDIT_PROFILE.USER_NO_PRIV_ERR'
,p_message_text=>'User 0% has no privileges to update the information for another user.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(209252912352853733)
,p_name=>'EDIT_REGION'
,p_message_text=>'Edit Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(295258003666132616)
,p_name=>'EDIT_REPORTING_TIMEFRAME'
,p_message_text=>'Edit Reporting Timeframe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(209256117678864784)
,p_name=>'EDIT_REPORT_COLS'
,p_message_text=>'Edit Report Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(481306729733270553)
,p_name=>'EDIT_REPORT_DIALOG_CLOSED_DA'
,p_message_text=>'Edit Report - Dialog Closed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(195816020534303963)
,p_name=>'EDIT_SYSTEM_MESSAGE'
,p_message_text=>'Edit System Message'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(454859202056072704)
,p_name=>'EDIT_TAB'
,p_message_text=>'Edit Tab'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(228986309599775173)
,p_name=>'EDIT_THIS_ATTRIBUTE'
,p_message_text=>'Edit this attribute'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145151519309641028)
,p_name=>'ELAPSED_TIME'
,p_message_text=>'Elapsed Time'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177293525864118220)
,p_name=>'EMAIL.TEMPLATE.FOOTER_EXAMPLE'
,p_message_text=>'<a href="#MY_APPLICATION_LINK#">Visit My Application and manage your email preferences</a>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(182816204436193767)
,p_name=>'EMAIL.TEMPLATE.HEADER_EXAMPLE'
,p_message_text=>'<b style="font-size: 24px;">My Application</b>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270605954832606075)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.EV'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>Hello #INVITEE#,</b><br>',
'<br>',
'This is a reminder of an upcoming event you have been invited to.  Please see the event details below:<br>',
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Organizer</th>',
'    <td>#ORGANIZER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Event Date</th>',
'    <td>#EVENT_DATE#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Start Time</th>',
'    <td>#START_TIME#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Duration</th>',
'    <td>#DURATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Location</th>',
'    <td>#LOCATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">URL</th>',
'    <td><a href="#URL_LINK#">#URL_NAME#</a></td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Notes</th>',
'    <td>#NOTES#</td>',
'  </tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177292894284112303)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.OD'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>Hello #CUSTOMER_NAME#</b>,<br>',
'<br>',
'Thank you for placing your order!<br>',
'<br>',
'<b>Order Details</b><br>',
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Order Date</th>',
'    <td>#ORDER_DATE#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Order Number</th>',
'    <td>#ORDER_NUMBER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Ship To</th>',
'    <td>#SHIP_TO#</td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Shipping Address</th>',
'    <td>',
'      #SHIPPING_ADDRESS_LINE_1#<br>',
'      #SHIPPING_ADDRESS_LINE_2#',
'    </td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Items Ordered</th>',
'    <td>#ITEMS_ORDERED#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Order Total</th>',
'    <td>#ORDER_TOTAL#</td>',
'  </tr>',
'</table>',
'<br>',
'<br>',
'Need to make a change to your order? <a href="#ORDER_URL#">Manage your order #ORDER_NUMBER# here.</a>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(481899083519669572)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.SO'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hello #SERVICE_USER#,<br>',
'<br>',
'Please be aware that your service #SERVICE_NAME# has an upcoming scheduled outage.<br>',
'The outage is scheduled to begin at #OUTAGE_START# and is planned to be unavailable for #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.<br>',
'<br>',
'The following will be performed during this scheduled outage:<br>',
'#OUTAGE_REASON#<br>',
'<br>',
'<br>',
'For any issues relating to this outage please contact #OUTAGE_CONTACT#.<br>',
'<br>',
'Thank you for your understanding,<br>',
'#SERVICE_TEAM#'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(481191972391345551)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.EV'
,p_message_text=>'Event Reminder: #EVENT_NAME#'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(481192170701355144)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.OD'
,p_message_text=>'Order (#ORDER_NUMBER#) Confirmed!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270669368302907263)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.EV'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hello #INVITEE#,',
'',
'This email is to remind you of an upcoming event you are associated with.',
'',
'Event Date: #EVENT_DATE#',
'Start Time: #START_TIME#',
'Duration:   #DURATION#',
'Organizer:  #ORGANIZER#',
'Location:   #LOCATION#',
'URL:        #URL_NAME# (#URL_LINK#)',
'Notes:      #NOTES#',
'',
'View additional event details here: #EVENT_LINK#'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270653521379861150)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.OD'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hello #CUSTOMER_NAME#,',
'',
'Thank you for placing your order!',
'',
'Order Details',
'--------------------------------------------------------------------------------',
'  Order Date:       #ORDER_DATE#',
'  Order Number:     #ORDER_NUMBER#',
'  Ship To:          #SHIP_TO#',
'  Shipping Address: #SHIPPING_ADDRESS_LINE_1#',
'                    #SHIPPING_ADDRESS_LINE_2#',
'  Items Ordered:    #ITEMS_ORDERED#',
'  Order Total:      #ORDER_TOTAL#',
'--------------------------------------------------------------------------------',
'',
'Need to make a change to your order? Manage your order #ORDER_NUMBER# here: #ORDER_URL#'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(481898621288667766)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.SO'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Hello #SERVICE_USER#,',
'',
'Please be aware that your service #SERVICE_NAME# has an upcoming scheduled outage.',
'The outage is scheduled to begin at #OUTAGE_START# and is planned to be unavailable for #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.',
'',
'The following will be performed during this scheduled outage:',
'#OUTAGE_REASON#',
'',
'For any issues relating to this outage please contact #OUTAGE_CONTACT#.',
'',
'Thank you for your understanding,',
'#SERVICE_TEAM#',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(60160128393533808)
,p_name=>'EMAIL_NOT_FOUND'
,p_message_text=>'Email address "%0" was not found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(18310020176542314)
,p_name=>'EMAIL_SENT_BY'
,p_message_text=>'This email sent by %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(487076420890100228)
,p_name=>'EMAIL_TOO_LONG'
,p_message_text=>'Email Address is too long.  The limit is 240 characters.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(201793625095426060)
,p_name=>'ENABLE_DEBUGGING'
,p_message_text=>'Enable Debugging Yes or No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270690907760517124)
,p_name=>'ENABLE_TRIGGER'
,p_message_text=>'Enable trigger %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(18886617136177889)
,p_name=>'ENCRYPTION_INPUT_TOO_LONG'
,p_message_text=>'Length of value to be encrypted may not exceed 4000 bytes.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(17810808211955434)
,p_name=>'END_USER'
,p_message_text=>'End User'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(171861228091833861)
,p_name=>'ENHANCEMENT_REQUEST'
,p_message_text=>'Enhancement Request'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(496735014367238388)
,p_name=>'ENHANCEMENT_REQUEST_DASH'
,p_message_text=>'Enhancement Requests: %1 of %0 closed'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172715819582269695)
,p_name=>'ENTERED'
,p_message_text=>'Entered'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5701313127778628)
,p_name=>'ENTER_WEBSHEETS_CREDENTIALS'
,p_message_text=>'Enter Websheets credentials.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166184219961533935)
,p_name=>'ENTRY LINK'
,p_message_text=>'Entry Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166183715459532695)
,p_name=>'ENTRY TEXT'
,p_message_text=>'Entry Text'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(133640811552207318)
,p_name=>'ERROR'
,p_message_text=>'Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(190189622892897230)
,p_name=>'ERROR PAGE TEMPLATE'
,p_message_text=>'Error Page Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(123652919513837836)
,p_name=>'ERRORPAGE'
,p_message_text=>'On Error Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(198245516383523130)
,p_name=>'ERRORS'
,p_message_text=>'Errors'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166305326513104029)
,p_name=>'ERROR_ICON'
,p_message_text=>'Error Icon'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(955846819150853709)
,p_name=>'ERROR_MESSAGE'
,p_message_text=>'Error Message'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277570623146201861)
,p_name=>'ERROR_SET_ITEM_STATE_FOR_PPR_REGION'
,p_message_text=>'Unable to set page item source value for partial page refresh region'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(161111212984184120)
,p_name=>'ESCAPED_COL_TOO_LARGE'
,p_message_text=>'<br><b>Escaped Data exceeds allowed limit, results trimmed to 32k</b>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88141602698839382)
,p_name=>'ESCAPE_SC'
,p_message_text=>'escape special characters'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184003428654634768)
,p_name=>'ESTIMATED_EFFORT_IN_HOURS'
,p_message_text=>'Estimated Effort in Hours'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(418761822732654339)
,p_name=>'ETAG_QUERY'
,p_message_text=>'ETAG Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(418753915459652239)
,p_name=>'ETAG_TYPE'
,p_message_text=>'ETAG Type'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(171868306368884342)
,p_name=>'EVENT'
,p_message_text=>'Event'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484995317511352603)
,p_name=>'EVENT.APEX.APEXAFTERREFRESH'
,p_message_text=>'After Refresh'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485076930987879656)
,p_name=>'EVENT.APEX.APEXBEFOREPAGESUBMIT'
,p_message_text=>'Before Page Submit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484995113356351362)
,p_name=>'EVENT.APEX.APEXBEFOREREFRESH'
,p_message_text=>'Before Refresh'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(487346700888842532)
,p_name=>'EVENT.BROWSER'
,p_message_text=>'Browser Events'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(107041629257271653)
,p_name=>'EVENT.BROWSER.APEXDOUBLETAP'
,p_message_text=>'Double Tap'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(107042007054274843)
,p_name=>'EVENT.BROWSER.APEXPAN'
,p_message_text=>'Pan'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(107041864275273550)
,p_name=>'EVENT.BROWSER.APEXPRESS'
,p_message_text=>'Press'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(107042283230276155)
,p_name=>'EVENT.BROWSER.APEXSWIPE'
,p_message_text=>'Swipe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(107041495807269483)
,p_name=>'EVENT.BROWSER.APEXTAP'
,p_message_text=>'Tap'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484993411147341273)
,p_name=>'EVENT.BROWSER.CHANGE'
,p_message_text=>'Change'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484992011362331854)
,p_name=>'EVENT.BROWSER.CLICK'
,p_message_text=>'Click'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484992216557333343)
,p_name=>'EVENT.BROWSER.DBLCLICK'
,p_message_text=>'Double Click'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484991025083326382)
,p_name=>'EVENT.BROWSER.FOCUSIN'
,p_message_text=>'Get Focus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484990210538322163)
,p_name=>'EVENT.BROWSER.FOCUSOUT'
,p_message_text=>'Lose Focus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484994021882344390)
,p_name=>'EVENT.BROWSER.KEYDOWN'
,p_message_text=>'Key Down'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484994702966348336)
,p_name=>'EVENT.BROWSER.KEYPRESS'
,p_message_text=>'Key Press'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484994906083349294)
,p_name=>'EVENT.BROWSER.KEYUP'
,p_message_text=>'Key Release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484991228200327247)
,p_name=>'EVENT.BROWSER.LOAD'
,p_message_text=>'Resource Load'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484992422098334933)
,p_name=>'EVENT.BROWSER.MOUSEDOWN'
,p_message_text=>'Mouse Button Press'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484993002489338794)
,p_name=>'EVENT.BROWSER.MOUSEENTER'
,p_message_text=>'Mouse Enter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484993207684340316)
,p_name=>'EVENT.BROWSER.MOUSELEAVE'
,p_message_text=>'Mouse Leave'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484992831448337683)
,p_name=>'EVENT.BROWSER.MOUSEMOVE'
,p_message_text=>'Mouse Move'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484992626946336349)
,p_name=>'EVENT.BROWSER.MOUSEUP'
,p_message_text=>'Mouse Button Release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5281515968954667)
,p_name=>'EVENT.BROWSER.ORIENTATIONCHANGE'
,p_message_text=>'Orientation Change'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(488323623842199026)
,p_name=>'EVENT.BROWSER.READY'
,p_message_text=>'Page Load'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484991431317328187)
,p_name=>'EVENT.BROWSER.RESIZE'
,p_message_text=>'Resize'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484991602012329168)
,p_name=>'EVENT.BROWSER.SCROLL'
,p_message_text=>'Scroll'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5281720470956028)
,p_name=>'EVENT.BROWSER.SCROLLSTART'
,p_message_text=>'Scroll Start'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5281923240956833)
,p_name=>'EVENT.BROWSER.SCROLLSTOP'
,p_message_text=>'Scroll Stop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484993613917342070)
,p_name=>'EVENT.BROWSER.SELECT'
,p_message_text=>'Select'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5279908565943120)
,p_name=>'EVENT.BROWSER.SWIPE'
,p_message_text=>'Swipe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5280113067944340)
,p_name=>'EVENT.BROWSER.SWIPELEFT'
,p_message_text=>'Swipe Left'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5280316876945479)
,p_name=>'EVENT.BROWSER.SWIPERIGHT'
,p_message_text=>'Swipe Right'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5279530251939881)
,p_name=>'EVENT.BROWSER.TAP'
,p_message_text=>'Tap'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5279703024941527)
,p_name=>'EVENT.BROWSER.TAPHOLD'
,p_message_text=>'Tap and Hold'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(484991805821330322)
,p_name=>'EVENT.BROWSER.UNLOAD'
,p_message_text=>'Page Unload'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5281106618951950)
,p_name=>'EVENT.BROWSER.VCLICK'
,p_message_text=>'Virtual Click'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5281311466953400)
,p_name=>'EVENT.BROWSER.VMOUSECANCEL'
,p_message_text=>'Touch Cancel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5280525880948113)
,p_name=>'EVENT.BROWSER.VMOUSEDOWN'
,p_message_text=>'Touch Start'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5280730036949270)
,p_name=>'EVENT.BROWSER.VMOUSEMOVE'
,p_message_text=>'Touch Move'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5280901770950630)
,p_name=>'EVENT.BROWSER.VMOUSEUP'
,p_message_text=>'Touch End'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(487347110238845223)
,p_name=>'EVENT.COMPONENT'
,p_message_text=>'Component Events'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3782325278158105)
,p_name=>'EVENT.CUSTOM'
,p_message_text=>'Custom Event'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(3782529434159334)
,p_name=>'EVENT.CUSTOM.CUSTOM'
,p_message_text=>'Custom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(487346905390843830)
,p_name=>'EVENT.FRAMEWORK'
,p_message_text=>'Framework Events'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(208944027692720500)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERCLOSEDIALOG'
,p_message_text=>'Dialog Closed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1083319309501404155)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERREFRESH'
,p_message_text=>'After Refresh'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1083323413657405386)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREPAGESUBMIT'
,p_message_text=>'Before Page Submit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1083309305345403011)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREREFRESH'
,p_message_text=>'Before Refresh'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(163582301828387091)
,p_name=>'EVENTS'
,p_message_text=>'Events'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183998503589618131)
,p_name=>'EVENT_ID'
,p_message_text=>'Milestone Number'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(204379610360758976)
,p_name=>'EXACT_SUBS'
,p_message_text=>'Exact Substitutions'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(327980106735075998)
,p_name=>'EXAMPLE_1'
,p_message_text=>'Example 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(327995209506076788)
,p_name=>'EXAMPLE_2'
,p_message_text=>'Example 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(628864827214314488)
,p_name=>'EXAMPLE_OF_XML_COLUMN'
,p_message_text=>'This is an example of the data contained within an XML database column.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(826875932566730545)
,p_name=>'EXAMPLE_URI'
,p_message_text=>'Example URI'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(272959522903959120)
,p_name=>'EXCLUDE'
,p_message_text=>'Exclude'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(246234331235507934)
,p_name=>'EXISTING_SCHEMA_NAME'
,p_message_text=>'Existing Schema Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(194470031998589246)
,p_name=>'EXISTS'
,p_message_text=>'Exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25594709605436753)
,p_name=>'EXISTS_SQL_QUERY'
,p_message_text=>'EXISTS SQL Query'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(471700213058088753)
,p_name=>'EXPANDED'
,p_message_text=>'Expanded'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(799702405779687700)
,p_name=>'EXPAND_ALL'
,p_message_text=>'Expand All'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(51596623304413900)
,p_name=>'EXPIRED'
,p_message_text=>'Expired'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(165989729388391701)
,p_name=>'EXPLAIN PLAN'
,p_message_text=>'Explain Plan'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(163584313949390509)
,p_name=>'EXPORT'
,p_message_text=>'Export'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455023324582980796)
,p_name=>'EXPORT REPOSITORY'
,p_message_text=>'Export Repository'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(209771217779765237)
,p_name=>'EXPORTED_FROM_ANOTHER_WORKSPACE'
,p_message_text=>'Exported from another workspace or application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(209771622628766627)
,p_name=>'EXPORTED_FROM_CURRENT_WORKSPACE'
,p_message_text=>'Exported from current workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282817829765196826)
,p_name=>'EXPORT_APPLICATION'
,p_message_text=>'Export Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(294712132733705328)
,p_name=>'EXPORT_PKG_APP_FOR_DEPLOYMENT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Use these links to download this application and its corresponding database supporting objects for deployment in a different Oracle Application Express installation.  The downloaded files will be SQL Scripts that can be run from SQL*Plus, SQL Develop'
||'er or SQL Scripts within Oracle Application Express.',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282818018119202181)
,p_name=>'EXPORT_SUPPORTING_OBJECTS'
,p_message_text=>'Export Supporting Objects'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(164662110029806941)
,p_name=>'EXPORT_TYPES.APP_EXPORT'
,p_message_text=>'Application Export  '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(164662929422812474)
,p_name=>'EXPORT_TYPES.CSS_EXPORT'
,p_message_text=>'Cascading Style Sheets Export'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(164663712238817049)
,p_name=>'EXPORT_TYPES.FILE_EXPORT'
,p_message_text=>'Static File Export'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(164663305658815160)
,p_name=>'EXPORT_TYPES.IMAGE_EXPORT'
,p_message_text=>'Image Export'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(164662516609808862)
,p_name=>'EXPORT_TYPES.PAGE_EXPORT'
,p_message_text=>'Page Export'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(164664118818818925)
,p_name=>'EXPORT_TYPES.SCRIPT_FILE_EXPORT'
,p_message_text=>'Script File Export'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(160761125861699548)
,p_name=>'EXPORT_TYPES.UI_DEFAULTS'
,p_message_text=>'User Interface Defaults'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135413608989368289)
,p_name=>'F4000.APPLICATION_COMPUTATION'
,p_message_text=>'Application Computation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(134836429599062018)
,p_name=>'F4000.APPLICATION_ITEM'
,p_message_text=>'Application Item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135411426173363818)
,p_name=>'F4000.APPLICATION_PROCESS'
,p_message_text=>'Application Process'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86495111868973829)
,p_name=>'F4000.APPLICATION_RESERVED'
,p_message_text=>'Application ID''s 3000 through 8999 are reserved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25626813971569587)
,p_name=>'F4000.APP_EXPORT_CURR_WS'
,p_message_text=>'This application was exported from the current workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25627206137576727)
,p_name=>'F4000.APP_EXPORT_NON_CURR_WS'
,p_message_text=>'This application was exported from another workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135410214053360310)
,p_name=>'F4000.BRANCH'
,p_message_text=>'Branch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141818720379119145)
,p_name=>'F4000.BRANCH_FROM_PAGE'
,p_message_text=>'Branch from page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141820528475130880)
,p_name=>'F4000.BRANCH_TO_PAGE'
,p_message_text=>'Branch to page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135404306649348711)
,p_name=>'F4000.BUTTON'
,p_message_text=>'Button'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(193801311939283265)
,p_name=>'F4000.BUTTON.ITEM'
,p_message_text=>'Button Item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(45554027073404674)
,p_name=>'F4000.CALENDAR'
,p_message_text=>'Calendar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106621422382604572)
,p_name=>'F4000.CALENDAR_COLUMN'
,p_message_text=>'Calendar column.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(142828325976224854)
,p_name=>'F4000.COLUMN_ATTRIBUTES'
,p_message_text=>'Column Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(646544751779955187)
,p_name=>'F4000.COLUMN_NAME_RESERVED_WORD'
,p_message_text=>'The identified column name is an Oracle reserved word.  Please choose another name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145989127122232867)
,p_name=>'F4000.DYNAMIC'
,p_message_text=>'Dynamic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(34968010896570877)
,p_name=>'F4000.DYNAMIC ACTION'
,p_message_text=>'Dynamic Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25624919110466918)
,p_name=>'F4000.EXPORT'
,p_message_text=>'Export'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146312323752706572)
,p_name=>'F4000.FIX_ME'
,p_message_text=>'Fix Me'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145925525101986300)
,p_name=>'F4000.FOR_USER'
,p_message_text=>'For User'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145924317136984010)
,p_name=>'F4000.FOR_USER_SESSION'
,p_message_text=>'For User Session'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141821031938131926)
,p_name=>'F4000.FROM'
,p_message_text=>'from'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86524303351056557)
,p_name=>'F4000.HEADER_VALIDATION1'
,p_message_text=>'Header must contain <b> &lt;head&gt;</b> and <b>&lt;/head&gt;</b> tags.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86532909715067781)
,p_name=>'F4000.HEADER_VALIDATION2'
,p_message_text=>'<b>#HEAD#</b> substitution string must appear between the <b> &lt;head&gt;</b> and <b>&lt;/head&gt;</b> tags.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(170819532610079591)
,p_name=>'F4000.INVALID_FILE_TYPE'
,p_message_text=>'File "%0" is of invalid type.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135393920586333770)
,p_name=>'F4000.ITEM_DISPLAY'
,p_message_text=>'Item Display'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135398623141343968)
,p_name=>'F4000.ITEM_READ_ONLY'
,p_message_text=>'Item Read-only'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10901814504383528)
,p_name=>'F4000.LEGACY_SQL'
,p_message_text=>'Legacy SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(232345120989008657)
,p_name=>'F4000.LINK_COLUMN'
,p_message_text=>'Link Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146365627176455163)
,p_name=>'F4000.LIST_INITCAP'
,p_message_text=>'List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135417011675388059)
,p_name=>'F4000.LIST_ITEM'
,p_message_text=>'List Item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10901630852381990)
,p_name=>'F4000.LOCAL'
,p_message_text=>'Local'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135420311937406967)
,p_name=>'F4000.LOV_ENTRY'
,p_message_text=>'List of Values Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141823628952140566)
,p_name=>'F4000.MENU'
,p_message_text=>'Breadcrumb'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135417523103391279)
,p_name=>'F4000.MENU_OPTION'
,p_message_text=>'Breadcrumb Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150692517959064941)
,p_name=>'F4000.MUST_SELECT_AT_LEAST_ONE_TO_COPY'
,p_message_text=>'Must select at least one to copy or subscribe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135414900809375430)
,p_name=>'F4000.NAVIGATION_BAR_ENTRY'
,p_message_text=>'Navigation Bar Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114115418066509874)
,p_name=>'F4000.NAVIGATION_BAR_ICON'
,p_message_text=>'Navigation&nbsp;Bar&nbsp;Icon'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(134491109598687258)
,p_name=>'F4000.NO'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145989606128236359)
,p_name=>'F4000.NOT_REFERENCED'
,p_message_text=>'Not Referenced'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139984404907972703)
,p_name=>'F4000.NO_DATA_FOUND'
,p_message_text=>'No data found.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1020631059651763715)
,p_name=>'F4000.P1.APP_DOES_NOT_EXIST'
,p_message_text=>'Application %0 does not exist in the current workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(493069300808102739)
,p_name=>'F4000.P1000.UPDATE_CHECK_DISABLED'
,p_message_text=>'Update Check disabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149230005333451280)
,p_name=>'F4000.P104.PARENT_TAB_NAME'
,p_message_text=>'Parent Tab Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26435015781196447)
,p_name=>'F4000.P111.CANCEL_BUTTON_BRANCH'
,p_message_text=>'Cancel Button Branch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26432930710153401)
,p_name=>'F4000.P111.CANCEL_BUTTON_TEXT'
,p_message_text=>'Cancel Button Display Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26435510718204416)
,p_name=>'F4000.P111.FINISH_BUTTON_BRANCH'
,p_message_text=>'Finish Button Branch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26433415388167940)
,p_name=>'F4000.P111.FINISH_BUTTON_TEXT'
,p_message_text=>'Finish Button Display Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26434516343187176)
,p_name=>'F4000.P111.NEXT_BUTTON_TEXT'
,p_message_text=>'Next Button Display Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26433829241171919)
,p_name=>'F4000.P111.PREVIOUS_BUTTON_TEXT'
,p_message_text=>'Previous Button Display Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149233800401468822)
,p_name=>'F4000.P112.TREE_PAGE'
,p_message_text=>'Tree Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149240430661487065)
,p_name=>'F4000.P119.GO'
,p_message_text=>'Go'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149249501271506953)
,p_name=>'F4000.P130.USING_SAME_TEMPLATE'
,p_message_text=>'Using the same templates as an existing application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1040898274196574090)
,p_name=>'F4000.P135.COPY'
,p_message_text=>'Copy %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066332894463410440)
,p_name=>'F4000.P149.PUBLISH_AUTHORIZATION'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Authorization Schemes:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066338985104492247)
,p_name=>'F4000.P149.PUBLISH_BREADCRUMB_TEMPLATE'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Breadcrumb Templates:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066339300234502522)
,p_name=>'F4000.P149.PUBLISH_BUTTON_TEMPLATE'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Button Templates:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066340415941513880)
,p_name=>'F4000.P149.PUBLISH_CALENDAR_TEMPLATE'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Calendar Templates:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066331765783387762)
,p_name=>'F4000.P149.PUBLISH_FIELD_TEMPLATE'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Label Templates:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066327301658364110)
,p_name=>'F4000.P149.PUBLISH_LIST_TEMPLATE'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following List Templates:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1063461869007966419)
,p_name=>'F4000.P149.PUBLISH_LOV'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Lists of Values:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066336159168440336)
,p_name=>'F4000.P149.PUBLISH_NAVBAR'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Navigation Bar Entries:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1063528582243238150)
,p_name=>'F4000.P149.PUBLISH_PAGE_TEMPLATE'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Page Templates:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066341554964534518)
,p_name=>'F4000.P149.PUBLISH_PLUGIN'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Plug-ins:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066436179289617388)
,p_name=>'F4000.P149.PUBLISH_POPUP_LOV_TEMPLATE'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Popup List of Values Templates:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1063533597707279189)
,p_name=>'F4000.P149.PUBLISH_REGION_TEMPLATE'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Region Templates:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066330233179377218)
,p_name=>'F4000.P149.PUBLISH_REPORT_TEMPLATE'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Report Templates:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1066333934417423253)
,p_name=>'F4000.P149.PUBLISH_SHORTCUT'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Shortcuts:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(247779366717215288)
,p_name=>'F4000.P149.PUBLISH_WEB_SRC_MODULE'
,p_message_text=>'You have requested to publish <strong>%0</strong>. This will refresh the following Web Source Modules:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150848527560411361)
,p_name=>'F4000.P158.COPY_OF'
,p_message_text=>'Copy of %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1040435196889019226)
,p_name=>'F4000.P1701.LOOKUP_DEFINITION'
,p_message_text=>'Lookup Definition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1029863567640079754)
,p_name=>'F4000.P1704.REGION_NAME'
,p_message_text=>'Region Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86515621658033438)
,p_name=>'F4000.P19.VALIDATION'
,p_message_text=>'Must specify at least one item to create not null validation.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(508402824680318750)
,p_name=>'F4000.P2.UPDATE_EXPORT_SETTINGS'
,p_message_text=>'Update default export settings'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167455724744518449)
,p_name=>'F4000.P203.COMMENT='
,p_message_text=>'comment='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166938900897839755)
,p_name=>'F4000.P203.COMP.MSG'
,p_message_text=>'Used to run computation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1289127918514452972)
,p_name=>'F4000.P203.CONCATENATED_FILE'
,p_message_text=>'Concatenated File'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167101902712171368)
,p_name=>'F4000.P203.DISPVAL='
,p_message_text=>'display value='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1289127654267446487)
,p_name=>'F4000.P203.FILE='
,p_message_text=>'file='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166956827618951511)
,p_name=>'F4000.P203.ICONBAR'
,p_message_text=>'Icon Bar'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167110015656184621)
,p_name=>'F4000.P203.LOV='
,p_message_text=>'List of Values='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167098431193160737)
,p_name=>'F4000.P203.LOVDATA'
,p_message_text=>'List of Values Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167077602272114512)
,p_name=>'F4000.P203.NAME='
,p_message_text=>'name='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166926719766807309)
,p_name=>'F4000.P203.PAGE.MSG'
,p_message_text=>'Used to display page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167425213653439494)
,p_name=>'F4000.P203.PAGEBRANCH'
,p_message_text=>'Page Branch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167129103021218788)
,p_name=>'F4000.P203.PGTEMP'
,p_message_text=>'Page Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166947509648899048)
,p_name=>'F4000.P203.PROC.MSG'
,p_message_text=>'Used to run process'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166944719990873578)
,p_name=>'F4000.P203.PROCESSING'
,p_message_text=>'Processing'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(167107825222177930)
,p_name=>'F4000.P203.RETVAL='
,p_message_text=>'return value='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1080731868950026785)
,p_name=>'F4000.P2222.REPARENT_LIST_ENTRY'
,p_message_text=>'Reparent List Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106605231530080434)
,p_name=>'F4000.P254.VALIDATION'
,p_message_text=>'Must specify at least one region to create.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(134484504919647981)
,p_name=>'F4000.P277.WORKSPACE_NOT_CREATED_ALREADY_EXISTS'
,p_message_text=>'Workspace will not be created because it already exists.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(134484919117652104)
,p_name=>'F4000.P277.WORKSPACE_WILL_BE_CREATED'
,p_message_text=>'Workspace will be created.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1127352654100000526)
,p_name=>'F4000.P291.VIEW_LOCK'
,p_message_text=>'View Lock'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(106605707420082902)
,p_name=>'F4000.P295.VALIDATION'
,p_message_text=>'Must specify at least one page to create.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1127569218931270327)
,p_name=>'F4000.P337.PAGE_UNLOCKED'
,p_message_text=>'This page is currently unlocked.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(468676428466077911)
,p_name=>'F4000.P371.POPUP_LOV'
,p_message_text=>'Popup LOV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149505327392725640)
,p_name=>'F4000.P374.POS.1'
,p_message_text=>'Pos.1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149506512979730884)
,p_name=>'F4000.P374.POS.2'
,p_message_text=>'Pos.2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149507032372736471)
,p_name=>'F4000.P374.POS.3'
,p_message_text=>'Pos.3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149508511378739875)
,p_name=>'F4000.P374.POS.4'
,p_message_text=>'Pos.4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(7839310130588292)
,p_name=>'F4000.P374.POS.5'
,p_message_text=>'Pos.5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(255932528799792494)
,p_name=>'F4000.P374.POS.6'
,p_message_text=>'Pos.6'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(255972625348794093)
,p_name=>'F4000.P374.POS.7'
,p_message_text=>'Pos.7'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(255972823408794978)
,p_name=>'F4000.P374.POS.8'
,p_message_text=>'Pos.8'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149510900212755588)
,p_name=>'F4000.P381_XBUTTON_HELP'
,p_message_text=>'DML and pagination buttons require specific button names, reference help text.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1041684749433736848)
,p_name=>'F4000.P386.CLASS_MATCHES'
,p_message_text=>'%0 (Class Matches)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149518811902777873)
,p_name=>'F4000.P4001.AUTH_HOME'
,p_message_text=>'manage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1289357884789314569)
,p_name=>'F4000.P4001.ORIGINAL_VALUE'
,p_message_text=>'Original Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149523324500791042)
,p_name=>'F4000.P4001.SUBSTITUTION_STR'
,p_message_text=>'Substitution String'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149528111256806092)
,p_name=>'F4000.P4001.SUBSTITUTION_VALUE'
,p_message_text=>'Substitution Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139954013622729248)
,p_name=>'F4000.P4017.HELP_REGION_SOURCE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<font class="instructiontext">This region will display page and item help for the current page when called using following syntax:<br>',
'<pre><escape sc>f?p=&AMP;APP_ID.:Page:Session:&APP_PAGE_ID.</pre></font>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149536101653860162)
,p_name=>'F4000.P4039.FORM_ON'
,p_message_text=>'Form on %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149541611958882055)
,p_name=>'F4000.P404.VALUES'
,p_message_text=>'Values'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(57889413654278690)
,p_name=>'F4000.P4045.BRANCH='
,p_message_text=>'Branch='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146344712257223683)
,p_name=>'F4000.P4045.BUTTON='
,p_message_text=>'Button='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14568120262354348)
,p_name=>'F4000.P4045.CHART_SERIES='
,p_message_text=>'Chart Series='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146347025548236976)
,p_name=>'F4000.P4045.COMPUTATION='
,p_message_text=>'Computation='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146336912716081944)
,p_name=>'F4000.P4045.ICON_SUBTEXT='
,p_message_text=>'Icon Subtext='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146336506136080033)
,p_name=>'F4000.P4045.IMAGE='
,p_message_text=>'Image='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146346315505234156)
,p_name=>'F4000.P4045.ITEM='
,p_message_text=>'Item='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146341400090191825)
,p_name=>'F4000.P4045.LIST='
,p_message_text=>'List='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(57890528545282953)
,p_name=>'F4000.P4045.MENU_OPTION='
,p_message_text=>'Breadcrumb Entry='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146344205678221776)
,p_name=>'F4000.P4045.PAGE='
,p_message_text=>'Page='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146347429011238050)
,p_name=>'F4000.P4045.PROCESS='
,p_message_text=>'Process='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14567428133299857)
,p_name=>'F4000.P4045.REGION='
,p_message_text=>'Region='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146012920645363561)
,p_name=>'F4000.P4045.REQUIRED_BY_EVERY_PAGE'
,p_message_text=>'Required by every page of application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146327228628935067)
,p_name=>'F4000.P4045.REQUIRED_TO_DISPLAY_PAGE'
,p_message_text=>'Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146330800802993330)
,p_name=>'F4000.P4045.REQUIRED_TO_RUN_APP_COMPUTATION'
,p_message_text=>'Application Computation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146332320457017891)
,p_name=>'F4000.P4045.REQUIRED_TO_RUN_APP_PROCESS'
,p_message_text=>'Application Process'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146348411827242508)
,p_name=>'F4000.P4045.TAB_NAME='
,p_message_text=>'Tab Name='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146348915983243760)
,p_name=>'F4000.P4045.TAB_SET='
,p_message_text=>'Tab Set='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146341804246193034)
,p_name=>'F4000.P4045.TEXT='
,p_message_text=>'Text='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146347801438239488)
,p_name=>'F4000.P4045.VALIDATION='
,p_message_text=>'Validation='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149738521316010734)
,p_name=>'F4000.P420.CSV_EXPORT'
,p_message_text=>'Download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149742009720045217)
,p_name=>'F4000.P420.CVS'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149736631790994858)
,p_name=>'F4000.P420.DEFAULT_LOOK1'
,p_message_text=>'Default Look 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149737314259999238)
,p_name=>'F4000.P420.DEFAULT_LOOK2'
,p_message_text=>'Default Look 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149737728804003390)
,p_name=>'F4000.P420.DEFAULT_LOOK3'
,p_message_text=>'Default Look 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149738109196007207)
,p_name=>'F4000.P420.DEFAULT_LOOK4'
,p_message_text=>'Default Look 4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149724227016898855)
,p_name=>'F4000.P420.EXTERNAL_PAGINATION'
,p_message_text=>'Use externally created pagination buttons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149735608110978485)
,p_name=>'F4000.P420.HTML_STD'
,p_message_text=>'HTML standard look'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149740227812031526)
,p_name=>'F4000.P420.LOOK1'
,p_message_text=>'Look 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149740719285038548)
,p_name=>'F4000.P420.LOOK2'
,p_message_text=>'Look 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149741123441039740)
,p_name=>'F4000.P420.LOOK3'
,p_message_text=>'Look 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149741527597040876)
,p_name=>'F4000.P420.LOOK4'
,p_message_text=>'Look 4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149728923254926132)
,p_name=>'F4000.P420.ROWS_X_TO_Y'
,p_message_text=>'Rows X to Y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149727506500911832)
,p_name=>'F4000.P420.ROW_RANGE'
,p_message_text=>'Row Ranges 1-15 16-30 in select list'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149730606547940228)
,p_name=>'F4000.P420.SEARCH_ENGINE'
,p_message_text=>'Search Engine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149727919660915626)
,p_name=>'F4000.P420.SEARCH_ENGINE_123'
,p_message_text=>'Search Engine 1,2,3,4 (set based pagination)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149729512303932421)
,p_name=>'F4000.P420.SELECT_LIST'
,p_message_text=>'Select List'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149717203543797450)
,p_name=>'F4000.P420.SET_DEFAULTS'
,p_message_text=>'set defaults'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149723518920887018)
,p_name=>'F4000.P420.TURN_OFF_PAGINATION'
,p_message_text=>'turn off pagination'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149728508709921939)
,p_name=>'F4000.P420.USE_PAGINATION'
,p_message_text=>'Use pagination buttons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149742524611049547)
,p_name=>'F4000.P420.XML'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149739006556015915)
,p_name=>'F4000.P420.XML_EXPORT'
,p_message_text=>'XML Export'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149936809432979586)
,p_name=>'F4000.P422.GEN_LINK'
,p_message_text=>'Generate Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149726518490905829)
,p_name=>'F4000.P429.ROWS_X_TO_Y'
,p_message_text=>'Row Ranges X to Y (with next and previous links)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1755110288040792178)
,p_name=>'F4000.P4311.P371.ALWAYS_NULL'
,p_message_text=>'Null'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(228670025726383922)
,p_name=>'F4000.P4311.P371.DB_COLUMN'
,p_message_text=>'DB Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(228676627720403406)
,p_name=>'F4000.P4311.P371.PLSQL_EXP'
,p_message_text=>'PL/SQL expression'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(228688627289422265)
,p_name=>'F4000.P4311.P371.PLSQL_FUNC_BODY'
,p_message_text=>'PL/SQL function body'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(228673321009392089)
,p_name=>'F4000.P4311.P371.SQL_QUERY'
,p_message_text=>'SQL Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(228664318669372478)
,p_name=>'F4000.P4311.P371.STATIC_TEXT'
,p_message_text=>'static text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149952704864148621)
,p_name=>'F4000.P4314_XBUTTON_HELP'
,p_message_text=>'DML buttons require specific button names, reference help text.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(30529711806817998)
,p_name=>'F4000.P4450.ACTION_CREATE'
,p_message_text=>'New plug-in will be created in application %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(30529302802815350)
,p_name=>'F4000.P4450.ACTION_REPLACE'
,p_message_text=>'Existing plug-in in application %0 will be replaced.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149965911809302066)
,p_name=>'F4000.P4651.HTML_W_SHORTCUTS'
,p_message_text=>'HTML w/shortcuts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149967128562316298)
,p_name=>'F4000.P4651.PLSQL'
,p_message_text=>'PLSQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146364809168449931)
,p_name=>'F4000.P4656.DEFAULT_BUTTON_TEMPLATE'
,p_message_text=>'Default Button Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(45552716768382833)
,p_name=>'F4000.P4656.DEFAULT_CALENDAR_TEMPLATE'
,p_message_text=>'Default Calendar Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593341632279897777)
,p_name=>'F4000.P4656.DEFAULT_CHART_TEMPLATE'
,p_message_text=>'Default Chart Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(45362930554309485)
,p_name=>'F4000.P4656.DEFAULT_DIALOG_TEMPLATE'
,p_message_text=>'Default Dialog Page Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593341848341898777)
,p_name=>'F4000.P4656.DEFAULT_FORM_TEMPLATE'
,p_message_text=>'Default Form Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593342642256904297)
,p_name=>'F4000.P4656.DEFAULT_IRR_TEMPLATE'
,p_message_text=>'Default Interactive Report Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146364431894446989)
,p_name=>'F4000.P4656.DEFAULT_LABEL_TEMPLATE'
,p_message_text=>'Default Label Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593342049589900227)
,p_name=>'F4000.P4656.DEFAULT_LISTR_TEMPLATE'
,p_message_text=>'Default List Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146364024621444875)
,p_name=>'F4000.P4656.DEFAULT_LIST_TEMPLATE'
,p_message_text=>'Default List Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593343215016907111)
,p_name=>'F4000.P4656.DEFAULT_MENUR_TEMPLATE'
,p_message_text=>'Default Breadcrumb Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146365217133452230)
,p_name=>'F4000.P4656.DEFAULT_MENU_TEMPLATE'
,p_message_text=>'Default Breadcrumb Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593245256645659962)
,p_name=>'F4000.P4656.DEFAULT_NAV_BAR_LIST_TEMPLATE'
,p_message_text=>'Default Navigation Bar List Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593244678295655997)
,p_name=>'F4000.P4656.DEFAULT_NAV_LIST_TEMPLATE'
,p_message_text=>'Default Navigation Menu List Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593108425581398352)
,p_name=>'F4000.P4656.DEFAULT_OPTION_LABEL'
,p_message_text=>'Default Optional Label Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146362026914436109)
,p_name=>'F4000.P4656.DEFAULT_PAGE_TEMPLATE'
,p_message_text=>'Default Page Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146362432109437626)
,p_name=>'F4000.P4656.DEFAULT_REGION_TEMPLATE'
,p_message_text=>'Default Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593342237419901266)
,p_name=>'F4000.P4656.DEFAULT_REPORTR_TEMPLATE'
,p_message_text=>'Default Report Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146363616656442610)
,p_name=>'F4000.P4656.DEFAULT_REPORT_TEMPLATE'
,p_message_text=>'Default Report Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593108645137399815)
,p_name=>'F4000.P4656.DEFAULT_REQUIRED_LABEL'
,p_message_text=>'Default Required Label Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593245086817658499)
,p_name=>'F4000.P4656.DEFAULT_SIDE_NAV_LIST_TEMPLATE'
,p_message_text=>'Default Side Navigation Menu List Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593342442356902776)
,p_name=>'F4000.P4656.DEFAULT_TABFORM_TEMPLATE'
,p_message_text=>'Default Tabular Form Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593244806041657610)
,p_name=>'F4000.P4656.DEFAULT_TOP_NAV_LIST_TEMPLATE'
,p_message_text=>'Default Top Navigation Menu List Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593342830241905787)
,p_name=>'F4000.P4656.DEFAULT_WIZARD_TEMPLATE'
,p_message_text=>'Default Wizard Region Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146361621720434569)
,p_name=>'F4000.P4656.ERROR_PAGE_TEMPLATE'
,p_message_text=>'Default Error Page Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1593261710164753148)
,p_name=>'F4000.P4656.LOGIN_PAGE_TEMPLATE'
,p_message_text=>'Default Login Page Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146361214101432431)
,p_name=>'F4000.P4656.PRINT_MODE_PAGE_TEMPLATE'
,p_message_text=>'Default Print Mode Page Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149544215552892476)
,p_name=>'F4000.P4703.REPORT_ON'
,p_message_text=>'Report on %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148347221649290645)
,p_name=>'F4000.P4717.ALERT_INFO'
,p_message_text=>'alert information'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148362209453381735)
,p_name=>'F4000.P4717.NEW_REGION'
,p_message_text=>'new region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148339400393274977)
,p_name=>'F4000.P4717.REGION_MUST_EXIST'
,p_message_text=>'You must create at least one region before you can create a page item.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148348525243301165)
,p_name=>'F4000.P4717.USE_WIZARD'
,p_message_text=>'Use a wizard to create a new region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148772917932046521)
,p_name=>'F4000.P4719.ALPHABETIC_SORT'
,p_message_text=>'will be sorted alphabetically'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148774425682058235)
,p_name=>'F4000.P4719.BIND_VAR_LOV'
,p_message_text=>'Example 4: List of values with bind variable'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148774009752053598)
,p_name=>'F4000.P4719.CREATION_SORT'
,p_message_text=>'sorted in order of creation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148769121480028654)
,p_name=>'F4000.P4719.D_R_LOV'
,p_message_text=>'Example 2: List of values with same display and return value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(185570731231446623)
,p_name=>'F4000.P4719.INLINE'
,p_message_text=>'Example 5: Query contains in-line query, must ensure first FROM clause in the SQL statement is not part of the in-line query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148767928275021129)
,p_name=>'F4000.P4719.SQL_QUERY_LOV'
,p_message_text=>'Example 1: List of values based on SQL query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148771529229040279)
,p_name=>'F4000.P4719.STATIC_LOV'
,p_message_text=>'Example 3: Static list examples'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(148770411221035114)
,p_name=>'F4000.P4719.USE_ALIAS'
,p_message_text=>'When selecting the same column for both the display and return values use a column alias.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(29880115309879630)
,p_name=>'F4000.P4719.YN'
,p_message_text=>'show Yes / No, return Y and N'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149984926980476737)
,p_name=>'F4000.P4728.AFTER_PROCESSING'
,p_message_text=>'After Processing'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149981712304463018)
,p_name=>'F4000.P4728.BEFORE_COMPUTATIONS'
,p_message_text=>'Before Computations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149984414513473075)
,p_name=>'F4000.P4728.BEFORE_PROCESSING'
,p_message_text=>'Before Processing'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149983901354469348)
,p_name=>'F4000.P4728.BEFORE_VALIDATIONS'
,p_message_text=>'Before Validations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37390900837540334)
,p_name=>'F4000.P4731.ADD'
,p_message_text=>'Add Row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149988123349513502)
,p_name=>'F4000.P4731.APPLY'
,p_message_text=>'Apply'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(32126726517376064)
,p_name=>'F4000.P4731.DELETE'
,p_message_text=>'Delete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149990018763531084)
,p_name=>'F4000.P4731.FINISH'
,p_message_text=>'Finish'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149989419324521804)
,p_name=>'F4000.P4731.SUBMIT'
,p_message_text=>'Submit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150001112145576532)
,p_name=>'F4000.P4735_RP_ALL'
,p_message_text=>'Pagination will be reset for all pages in this application when this procedure runs.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(151070807826999856)
,p_name=>'F4000.P4738.REGEXP_WARNING'
,p_message_text=>'WARNING: You have chosen a validation of type Regular Expression, however your version of the database does not support them.  This validation will always return true.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(694731901671470687)
,p_name=>'F4000.P4761.TRANSLATIONS_NOT_USED'
,p_message_text=>'Translations for this application are currently not enabled. See <em>Application Language Derived From</em> setting in <a href="%0">Globalization Attributes</a>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1447898339712914164)
,p_name=>'F4000.P509.INSTANCE_MAX_SESSION_IDLE_SEC'
,p_message_text=>'When Maximum Session Idle Time is not set, the workspace level or instance level value will be used (currently, %0 seconds).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1448056361887120303)
,p_name=>'F4000.P509.INSTANCE_MAX_SESSION_LENGTH_SEC'
,p_message_text=>'When Maximum Session Length is not set, the workspace level or instance level value will be used (currently, %0 seconds).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1137633130163109359)
,p_name=>'F4000.P593.NEW_BRANCH'
,p_message_text=>'New Branch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(210925907127579087)
,p_name=>'F4000.P598.EXPORTED_FROM_ANOTHER_APP_OR_WORKSPACE'
,p_message_text=>'These components were exported from a different application or from an application in a different workspace. The components cannot be installed in this application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(218892327152677275)
,p_name=>'F4000.P612.EXPORTED_FROM_ANOTHER_WORKSPACE'
,p_message_text=>'These files were exported from a different workspace. The files cannot be installed in this workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1137639903389218635)
,p_name=>'F4000.P622.TO_TEMPLATE'
,p_message_text=>'To Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1155933732255449972)
,p_name=>'F4000.P623.COPY_OPTION'
,p_message_text=>'Copy Option: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1155933920906451468)
,p_name=>'F4000.P623.EXISTING_LOV'
,p_message_text=>'Existing List of Values: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(176939516372005878)
,p_name=>'F4000.P67.EXPORTED_FROM_ANOTHER_APP_OR_WORKSPACE'
,p_message_text=>'This page was exported from a different application or from an application in different workspace. Page cannot be installed in this application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(134002813305555778)
,p_name=>'F4000.P67.EXPORTED_FROM_ANOTHER_WORKSPACE'
,p_message_text=>'This page was exported from an application in another workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(134002220793548534)
,p_name=>'F4000.P67.EXPORTED_FROM_CURRENT_WORKSPACE'
,p_message_text=>'This page was exported from an application in the current workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(479778329505464176)
,p_name=>'F4000.P67.PAGE_LOCKED'
,p_message_text=>'This page is currently locked.  You cannot import over a locked page.  Please unlock the page and then install.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1080734751826151865)
,p_name=>'F4000.P712.CLEAR_PARENT_ENTRY'
,p_message_text=>'Clear Parent Entry'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1146536660443540035)
,p_name=>'F4000.P765.SELECT_PARAM'
,p_message_text=>'Select Parameter %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86538323137090640)
,p_name=>'F4000.P818.VALIDATION'
,p_message_text=>'Must select at least one scheme to be copied.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1146562096651816614)
,p_name=>'F4000.P875.HTTP_HEADER_VAL'
,p_message_text=>'Value for HTTP Header %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1146560263847762174)
,p_name=>'F4000.P875.INPUT_PARAM_VAL'
,p_message_text=>'Value for Input Parameter %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1146738627667596028)
,p_name=>'F4000.P876.DELETE_HEADER'
,p_message_text=>'Delete Header'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1146735277742558688)
,p_name=>'F4000.P876.DELETE_PARAM'
,p_message_text=>'Delete Parameter: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150805707213036461)
,p_name=>'F4000.P904.REQUIRED_STYLE_SHEET'
,p_message_text=>'Required Style Sheet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141775604963076853)
,p_name=>'F4000.PAGE'
,p_message_text=>'Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146036105342529459)
,p_name=>'F4000.PAGE_BUTTON'
,p_message_text=>'Page Button'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135406121887353083)
,p_name=>'F4000.PAGE_COMPUTATION'
,p_message_text=>'Page Computation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(46902724637541315)
,p_name=>'F4000.PAGE_DYNAMIC_ACTION'
,p_message_text=>'Page Dynamic Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(134837703065063771)
,p_name=>'F4000.PAGE_ITEM'
,p_message_text=>'Page Item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146366009299459372)
,p_name=>'F4000.PAGE_MAYBE_PLURAL'
,p_message_text=>'page(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141779320894081452)
,p_name=>'F4000.PAGE_NAME'
,p_message_text=>'Page Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135408332622356237)
,p_name=>'F4000.PAGE_PROCESS'
,p_message_text=>'Page Process'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146035627028526237)
,p_name=>'F4000.PAGE_REGION'
,p_message_text=>'Page Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146037732485546724)
,p_name=>'F4000.PAGE_VALIDATION'
,p_message_text=>'Page Validation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135416601632385149)
,p_name=>'F4000.PARENT_TAB'
,p_message_text=>'Parent Tab'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(142982813471268544)
,p_name=>'F4000.POPUP_LOV_TEMPLATE'
,p_message_text=>'Popup List of Values template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143419401285016250)
,p_name=>'F4000.PUBLISH'
,p_message_text=>'Publish'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135391130497327247)
,p_name=>'F4000.REGION'
,p_message_text=>'Region'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(573545839995573569)
,p_name=>'F4000.REGION_COLUMNS'
,p_message_text=>'Region Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141780228166083471)
,p_name=>'F4000.RELATED_PAGES_AND_COMPONENTS'
,p_message_text=>'Related Page(s) and Components'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(185377920813253892)
,p_name=>'F4000.REPORT_COLUMN'
,p_message_text=>'Report Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10902036710385063)
,p_name=>'F4000.REST_ENABLED_SQL'
,p_message_text=>'REST Enabled SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143418725049013645)
,p_name=>'F4000.SEED'
,p_message_text=>'Seed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135416223319381907)
,p_name=>'F4000.STANDARD_TAB'
,p_message_text=>'Standard Tab'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145988612924228808)
,p_name=>'F4000.STATIC'
,p_message_text=>'Static'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141824409690144388)
,p_name=>'F4000.TAB'
,p_message_text=>'Tab'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143022808632342861)
,p_name=>'F4000.TEMPLATE'
,p_message_text=>'Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(93404031792355486)
,p_name=>'F4000.TEMPLATE_NAME_ALREADY_EXISTS'
,p_message_text=>'Template Name(s) %0 already exists.  Enter a new name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86544517989117530)
,p_name=>'F4000.TEMPLATE_NAME_MAND'
,p_message_text=>'Template Name must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143385830084036014)
,p_name=>'F4000.THEME_IMPORT_CREATE'
,p_message_text=>'New theme will be created in application %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143386508051039115)
,p_name=>'F4000.THEME_IMPORT_REPLACE'
,p_message_text=>'Existing theme in application %0 will be replaced.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(141819305965124455)
,p_name=>'F4000.TO'
,p_message_text=>'to'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135421219902409341)
,p_name=>'F4000.UNKNOWN_APPLICATION_ELEMENT'
,p_message_text=>'Unknown Application Element'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143422611290066454)
,p_name=>'F4000.UPDATEABLE_COLUMN'
,p_message_text=>'Updateable Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(193724713542174017)
,p_name=>'F4000.UTILITIES.INFO'
,p_message_text=>'Utilities include Grid Edit pages and Reports across all pages within the selected application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(135409204702357576)
,p_name=>'F4000.VALIDATION'
,p_message_text=>'Validation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10902201050386055)
,p_name=>'F4000.WEB_SOURCE'
,p_message_text=>'Web Source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(134489925744682388)
,p_name=>'F4000.YES'
,p_message_text=>'Yes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(165249714489706664)
,p_name=>'F4000_4738_DATE_MMDDYYY'
,p_message_text=>'Date MMDDYYYY'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(293191102915326473)
,p_name=>'F4000_APPLICATIONS'
,p_message_text=>'Applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(62016702554585619)
,p_name=>'F4000_AS_APP_ON_EXIST_TABLE'
,p_message_text=>'As an application on a database table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147088014969938712)
,p_name=>'F4000_AS_APP_ON_EXIST_TABLES'
,p_message_text=>'As an application on database tables'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150808127645042322)
,p_name=>'F4000_BUTTON_POS_NOT_IN_REGION'
,p_message_text=>'This button position is not in your region template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(196123526297493115)
,p_name=>'F4000_CHART'
,p_message_text=>'Chart'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150822203721158394)
,p_name=>'F4000_CLOSE'
,p_message_text=>'Close'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(153549405181508295)
,p_name=>'F4000_COPY_AND_SUBSCRIBE'
,p_message_text=>'Copy and Subscribe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150859819567532022)
,p_name=>'F4000_DATE_NOT_REC'
,p_message_text=>'Date format not recognized.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37271124481000772)
,p_name=>'F4000_F1500_LOCKED'
,p_message_text=>'Locked'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(196125709113497656)
,p_name=>'F4000_HELP_TEXT'
,p_message_text=>'Help Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(291143926462938285)
,p_name=>'F4000_LOV_NAME_EXISTS'
,p_message_text=>'List of Values Name(s) %0 already exists. Enter a new name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(156325827764888435)
,p_name=>'F4000_NONE_SELECTED'
,p_message_text=>'None Selected'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145735912185499985)
,p_name=>'F4000_NO_APP_ASSOC'
,p_message_text=>'No Application Associated'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15607427552526611)
,p_name=>'F4000_OFF'
,p_message_text=>'Off'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(15607022704525241)
,p_name=>'F4000_ON'
,p_message_text=>'On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(38660710153584840)
,p_name=>'F4000_P122_CAL_TEMPL'
,p_message_text=>'Calendar templates referencing this, template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177585711524722102)
,p_name=>'F4000_P128.VIEW_PAGES'
,p_message_text=>'view pages of this type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86879717249789116)
,p_name=>'F4000_P173_NO_HELP'
,p_message_text=>'no help exists for this item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86594326618242992)
,p_name=>'F4000_P1_AUTHENTICATION_HOME'
,p_message_text=>'authentication home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86593321078241432)
,p_name=>'F4000_P1_EDIT_THIS_TEMPLATE'
,p_message_text=>'Edit this template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87403413025738167)
,p_name=>'F4000_P232_RESET_CSS'
,p_message_text=>'Reset CSS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(493109316682353244)
,p_name=>'F4000_P295_PAGE_EXISTS'
,p_message_text=>'Page already exists in this application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37546123750494308)
,p_name=>'F4000_P295_PAGE_MUST_BE_NUMERIC'
,p_message_text=>'Page must be numeric.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37576114661510664)
,p_name=>'F4000_P295_PAGE_MUST_BE_POSITIVE'
,p_message_text=>'Page must be positive numbers.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(37578007866518198)
,p_name=>'F4000_P295_PAGE_MUST_BE_WHOLE_NUMBER'
,p_message_text=>'Page must be whole numbers.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(199283731134650209)
,p_name=>'F4000_P3005.IMPORT_AUTHORIZATION SCHEME'
,p_message_text=>'Import Authorization Scheme(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(176127115356655918)
,p_name=>'F4000_P3005.IMPORT_AUTH_SCHEME'
,p_message_text=>'Import Authentication Scheme(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(199285221568656902)
,p_name=>'F4000_P3005.IMPORT_NAVBAR'
,p_message_text=>'Import Navigation Bar(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(176128100596661105)
,p_name=>'F4000_P3005.IMPORT_THEME'
,p_message_text=>'Import Theme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150024016787662983)
,p_name=>'F4000_P33_REGION_TITLE'
,p_message_text=>'Tabular Form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(165127624242113325)
,p_name=>'F4000_P3890_AUTHENTICATED'
,p_message_text=>'Authenticated!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(165129712599119454)
,p_name=>'F4000_P3890_AUTH_FAILED'
,p_message_text=>'Authentication failed!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(155993209664776110)
,p_name=>'F4000_P395_NO_COLUMN'
,p_message_text=>'No Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150902908689494047)
,p_name=>'F4000_P4001_UNAVAIL'
,p_message_text=>'This application is currently unavailable at this time.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78815025925985832)
,p_name=>'F4000_P430_DATE'
,p_message_text=>'Date: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78815409087990462)
,p_name=>'F4000_P430_DATE2'
,p_message_text=>'Date, flexible: %0 with any separator'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78819131428034683)
,p_name=>'F4000_P430_DATE2_ERR'
,p_message_text=>'Date format not recognized'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78818708226028033)
,p_name=>'F4000_P430_DATE_ERR'
,p_message_text=>'Date must be in the form %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78813004622941846)
,p_name=>'F4000_P430_IP'
,p_message_text=>'IP Address'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78816821685003558)
,p_name=>'F4000_P430_IP_ERR'
,p_message_text=>'Invalid IP Address'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78813422284946942)
,p_name=>'F4000_P430_PHONE'
,p_message_text=>'Phone Number, US: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78813810425962453)
,p_name=>'F4000_P430_PHONE2'
,p_message_text=>'Phone Number, US flexible: 999.999.9999, (999)-999-9999, 999 999 9999, etc...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78817929781015296)
,p_name=>'F4000_P430_PHONE2_ERR'
,p_message_text=>'Phone number format not recognized'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78817210388009717)
,p_name=>'F4000_P430_PHONE_ERR'
,p_message_text=>'Phone number must be in the form %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78812622499937542)
,p_name=>'F4000_P430_URL'
,p_message_text=>'URL: http(s)://domain/path/doc.(pdf)(html)(etc...)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78816106794999238)
,p_name=>'F4000_P430_URL_ERR'
,p_message_text=>'Invalid URL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78814215405973269)
,p_name=>'F4000_P430_ZIP'
,p_message_text=>'ZIP Code: 99999'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78814602030978955)
,p_name=>'F4000_P430_ZIP2'
,p_message_text=>'ZIP + 4: 99999-9999'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78818323678023037)
,p_name=>'F4000_P430_ZIP_ERR'
,p_message_text=>'ZIP code must be in the form %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39886304819402862)
,p_name=>'F4000_P4495.COPIED_FROM'
,p_message_text=>'Copied from application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39886714515405621)
,p_name=>'F4000_P4495.MASTER'
,p_message_text=>'This is the "master" copy of this authentication scheme.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39887530792410336)
,p_name=>'F4000_P4495.NO_SUBSCRIPTION'
,p_message_text=>'There are no subscribers to this authentication scheme.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39887124904408640)
,p_name=>'F4000_P4495.REFERENCE'
,p_message_text=>'Schemes subscribing to this authentication scheme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(65386729108453214)
,p_name=>'F4000_P4495_LOV_NO_SCHEME'
,p_message_text=>'- no scheme -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149969411509330281)
,p_name=>'F4000_P4701_PAGE_NAME'
,p_message_text=>'Report 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150905031246528923)
,p_name=>'F4000_P4705_FORM_ON_A_PROC'
,p_message_text=>'Form on Stored Procedure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149974304499347243)
,p_name=>'F4000_P4710_PAGE_NAME'
,p_message_text=>'Chart 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150890108147954553)
,p_name=>'F4000_P4717_DISPLAY'
,p_message_text=>'Display Only'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150889802953953043)
,p_name=>'F4000_P4717_HIDDEN'
,p_message_text=>'Hidden'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150886413248899195)
,p_name=>'F4000_P4734_CLEAR_ITEMS'
,p_message_text=>'Clear Item(s) Cache'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150886001474895803)
,p_name=>'F4000_P4734_CLEAR_PAGE'
,p_message_text=>'Clear Page(s) Cache'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(157352628773779755)
,p_name=>'F4000_P4734_RESET_PAG'
,p_message_text=>'Reset Pagination'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150887300912905126)
,p_name=>'F4000_P4734_SET_ITEM'
,p_message_text=>'Set Item using PL/SQL function body'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150886824330902446)
,p_name=>'F4000_P4734_STATIC_ITEM'
,p_message_text=>'Static Item Assignment'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(149995323311560818)
,p_name=>'F4000_P4735_INITIALIZE'
,p_message_text=>'All page items that are not cached in the current application will be initialized to null.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150893117656193812)
,p_name=>'F4000_P4737_EXISTS'
,p_message_text=>'Exists'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150892218564184591)
,p_name=>'F4000_P4737_ITEM_NOT_NULL'
,p_message_text=>'Item Not Null'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150892528261187430)
,p_name=>'F4000_P4737_ITEM_NOT_ZERO'
,p_message_text=>'Item Not Zero'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150892809345191433)
,p_name=>'F4000_P4737_PLSQL_EXP'
,p_message_text=>'PL/SQL Expression'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(165258818906726794)
,p_name=>'F4000_P4738_DATE_DDMMYYYY'
,p_message_text=>'Date DDMMYYYY'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(165254621546718068)
,p_name=>'F4000_P4738_PHONE_NUM'
,p_message_text=>'Phone Number'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(818285481791031268)
,p_name=>'F4000_P473_DATABASE_OBJECT'
,p_message_text=>'Database Object'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150010202411621032)
,p_name=>'F4000_P4759_VIEW'
,p_message_text=>'In Browser'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150012031501629445)
,p_name=>'F4000_P4785_REGION_NAME'
,p_message_text=>'Calendar 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(65785219203598803)
,p_name=>'F4000_P4790_DATE_TIMESTAMP_NOTE'
,p_message_text=>'(containing Date or Timestamp column)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(317085609887212421)
,p_name=>'F4000_P4790_SYNTAX_HEADING'
,p_message_text=>'Syntax: select id, name, date from ...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(317086313972225763)
,p_name=>'F4000_P4790_SYNTAX_HELP_EXAMPLE1'
,p_message_text=>'Example using ROWID pseudo column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(317086506855229082)
,p_name=>'F4000_P4790_SYNTAX_HELP_EXAMPLE2'
,p_message_text=>'Example using the source table Primary Key'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(317085801476216309)
,p_name=>'F4000_P4790_SYNTAX_HELP_LINE1'
,p_message_text=>'1. You must include at least two columns, one of which must be a DATE column.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(317086029500218505)
,p_name=>'F4000_P4790_SYNTAX_HELP_LINE2'
,p_message_text=>'2. The first column should identify the primary key column to be used for managing data manipulation language (DML) operation.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150018910769651786)
,p_name=>'F4000_P4810_PAGE_NAME'
,p_message_text=>'Form 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(211657623650073328)
,p_name=>'F4000_P48_MANIFEST'
,p_message_text=>'Component Export Manifest    '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177572209400693131)
,p_name=>'F4000_P497.VIEW_PAGE_DEF'
,p_message_text=>'View page definition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150029603544678159)
,p_name=>'F4000_P5100_PAGE_NAME'
,p_message_text=>'Summary Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(153666831463913325)
,p_name=>'F4000_P52_TAB_LINK_TITLE'
,p_message_text=>'click to set tab set'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(379173801566229476)
,p_name=>'F4000_P643_NO_PARENT'
,p_message_text=>'Page template supports two level tabs, however standard tab does not identify a parent tab set'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(379173616878222387)
,p_name=>'F4000_P643_NO_TAB'
,p_message_text=>'No tabs, this page will not display tabs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(379173203760182882)
,p_name=>'F4000_P643_ONE_LVL'
,p_message_text=>'This page will show one level of tabs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(379177301086290484)
,p_name=>'F4000_P643_PAGE_NO_TAB'
,p_message_text=>'Pages with no tabs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(379178819189297290)
,p_name=>'F4000_P643_PAGE_NO_TAB_TTL'
,p_message_text=>'A total of %0 pages have no tabs defined.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(379172919503175595)
,p_name=>'F4000_P643_TAB_DISPLAY'
,p_message_text=>'Tab Display'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(379173411499209702)
,p_name=>'F4000_P643_TWO_LVL'
,p_message_text=>'This page will show two levels of tabs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39873601724462645)
,p_name=>'F4000_P801_ACTION'
,p_message_text=>'Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39879230099059985)
,p_name=>'F4000_P801_ACTIVATE1'
,p_message_text=>'Make this scheme current'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39879605297062332)
,p_name=>'F4000_P801_ACTIVATE2'
,p_message_text=>'make current'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(64444629386160793)
,p_name=>'F4000_P801_CURRENT'
,p_message_text=>'current'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39878415424046270)
,p_name=>'F4000_P801_DEACTIVATE'
,p_message_text=>'Change status to inactive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39871228211432447)
,p_name=>'F4000_P801_DETAILS'
,p_message_text=>'Details'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39871607910435989)
,p_name=>'F4000_P801_DETAILS_BI1'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Built-in session management logic, a built-in login page and user authentication against the internal "cookie user" account repository.',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39872426957441515)
,p_name=>'F4000_P801_DETAILS_OBS1'
,p_message_text=>'This method has been replaced with SCHEME authentication.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61409019186790889)
,p_name=>'F4000_P801_EDIT_DEPRECATED1'
,p_message_text=>'Edit deprecated authentication attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61409427628802834)
,p_name=>'F4000_P801_EDIT_DEPRECATED2'
,p_message_text=>'deprecated attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61409831700822962)
,p_name=>'F4000_P801_EDIT_DEPRECATED3'
,p_message_text=>'or leave them in place until you are ready to change the authentication method to %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61412206737938755)
,p_name=>'F4000_P801_EDIT_DEPRECATED4'
,p_message_text=>'Specifies one or more deprecated authentication attributes.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61413803583985128)
,p_name=>'F4000_P801_EDIT_DEPRECATED5'
,p_message_text=>'or migrate them to an authentication scheme.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61406830577491461)
,p_name=>'F4000_P801_FLOW'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39876016053476210)
,p_name=>'F4000_P801_MANAGE'
,p_message_text=>'Manage authentication schemes using the report above.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39870811589427647)
,p_name=>'F4000_P801_METHOD'
,p_message_text=>'Method'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(64444024838131113)
,p_name=>'F4000_P801_NO_EDIT'
,p_message_text=>'(Not Editable)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39878821442057486)
,p_name=>'F4000_P801_PAREN_CURRENT'
,p_message_text=>'(current)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61407218634525803)
,p_name=>'F4000_P801_PAREN_DEPRECATED'
,p_message_text=>'(deprecated)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39875609127474192)
,p_name=>'F4000_P801_PAREN_NONE'
,p_message_text=>'(none)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39873231590452290)
,p_name=>'F4000_P801_PUBLIC_PAGES'
,p_message_text=>'Public Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39874012113465584)
,p_name=>'F4000_P801_REVIEW1'
,p_message_text=>'Review or edit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39874420078467963)
,p_name=>'F4000_P801_REVIEW2'
,p_message_text=>'or edit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39874828043470260)
,p_name=>'F4000_P801_REVIEW3'
,p_message_text=>'session management attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39875201508472017)
,p_name=>'F4000_P801_REVIEW4'
,p_message_text=>'of this application on the application attributes page, or use the report above to create and manage authentication schemes that can be used when you change the authentication method to %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61410307851844396)
,p_name=>'F4000_P801_REVIEW5'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Review or edit session management attributes',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61413104575957016)
,p_name=>'F4000_P801_REVIEW6'
,p_message_text=>'Review or edit these'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61407622275564684)
,p_name=>'F4000_P801_SCHEME_CONVERT'
,p_message_text=>'%0 authentication is a deprecated method. We recommend that you click the "make current" link (shown above) on one of the authentication schemes in this application, or create a new authentication scheme and make it current. The INTERNAL-SETUP authen'
||'tication scheme is functionally equivalent to the %0 method.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61411327422887901)
,p_name=>'F4000_P801_SCHEME_DESC'
,p_message_text=>'Uses authentication schemes to control user authentication and all other aspects of session management for your application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150206009663872154)
,p_name=>'F4000_P805_X'
,p_message_text=>'You specified a page sentry function in the previous step. That function will be responsible for session verification on each page, so a session verification function may not be entered here. If this is not what you want, you may step backward throug'
||'h this wizard and make changes.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66222117896903331)
,p_name=>'F4000_P806_BUILTIN_LOGIN_PG'
,p_message_text=>'Built-in Login Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66223700066935976)
,p_name=>'F4000_P806_NONE'
,p_message_text=>'None'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66222528070915744)
,p_name=>'F4000_P806_PAGE_IN_THIS_FLOW'
,p_message_text=>'Page in This Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66223311363929820)
,p_name=>'F4000_P806_SSO_SERVER'
,p_message_text=>'Oracle Application Server Single Sign-On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66222921275923177)
,p_name=>'F4000_P806_URL'
,p_message_text=>'URL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66225200675955094)
,p_name=>'F4000_P808_AUTH_TYPE'
,p_message_text=>'Use %0 account username and password to authenticate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19804220938385447)
,p_name=>'F4000_P808_DBAUTH_TYPE'
,p_message_text=>'Use database account username and password to authenticate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66225621930970736)
,p_name=>'F4000_P808_NO_VERIFY_CRED'
,p_message_text=>'Do not verify credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66226423793980669)
,p_name=>'F4000_P808_USE_CUSTOM'
,p_message_text=>'Use my custom function to authenticate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66226003361974800)
,p_name=>'F4000_P808_USE_LDAP'
,p_message_text=>'Use an LDAP server to authenticate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150906329646537882)
,p_name=>'F4000_P80_NO_PAGE_NAME'
,p_message_text=>'- No page name -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39893331774656582)
,p_name=>'F4000_P811_AUTH'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Authentication Function',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39896502731676578)
,p_name=>'F4000_P811_C_DOMAIN'
,p_message_text=>'Cookie Domain'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39895724417673388)
,p_name=>'F4000_P811_C_NAME'
,p_message_text=>'Cookie Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39896130651675166)
,p_name=>'F4000_P811_C_PATH'
,p_message_text=>'Cookie Path'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(18869930610961583)
,p_name=>'F4000_P811_C_SECURE'
,p_message_text=>'Secure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39892514459651575)
,p_name=>'F4000_P811_INV_SESS_TGT'
,p_message_text=>'Invalid Session Target'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39894526364664499)
,p_name=>'F4000_P811_LDAP_DN'
,p_message_text=>'LDAP Search Base'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39894908487668811)
,p_name=>'F4000_P811_LDAP_EDIT'
,p_message_text=>'LDAP Username Edit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39893709742659693)
,p_name=>'F4000_P811_LDAP_HOST'
,p_message_text=>'LDAP Host'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39894118053662100)
,p_name=>'F4000_P811_LDAP_PORT'
,p_message_text=>'LDAP Port'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39896908272678205)
,p_name=>'F4000_P811_LOGOUT_URL'
,p_message_text=>'Logout URL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39891318137643177)
,p_name=>'F4000_P811_NAME'
,p_message_text=>'Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39890910865641131)
,p_name=>'F4000_P811_PAREN_BUILTIN'
,p_message_text=>'(Built-In)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39897316237680472)
,p_name=>'F4000_P811_PAREN_DBAUTH'
,p_message_text=>'(Database Authentication)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39891724024644884)
,p_name=>'F4000_P811_PG_SENTRY'
,p_message_text=>'Page Sentry Function'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39895316106670984)
,p_name=>'F4000_P811_POST_AUTH'
,p_message_text=>'Post-Authentication Process'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39892921731653672)
,p_name=>'F4000_P811_PRE_AUTH'
,p_message_text=>'Pre-Authentication Process'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39892106147649238)
,p_name=>'F4000_P811_SESS_VERIFY'
,p_message_text=>'Session Verification Function'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66229313582015577)
,p_name=>'F4000_P815_COPY'
,p_message_text=>'As a copy of an existing authentication scheme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66229703670022247)
,p_name=>'F4000_P815_GALLERY'
,p_message_text=>'Based on a pre-configured scheme from the gallery'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66228911719005572)
,p_name=>'F4000_P815_SCRATCH'
,p_message_text=>'Based on a pre-configured scheme from the gallery'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(41469703149528409)
,p_name=>'F4000_P817_REFRESH_AUTH_SCHEME_ERR'
,p_message_text=>'Error in refreshing authentication schemes.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39900332654770449)
,p_name=>'F4000_P819_AUTH_METHOD'
,p_message_text=>'Authentication Method'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(78913212633022862)
,p_name=>'F4000_P819_CURR_WARN'
,p_message_text=>'Warning: You are about to delete the current authentication scheme for this application!'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39901117547775466)
,p_name=>'F4000_P819_DESCRIPTION'
,p_message_text=>'Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39899926767768765)
,p_name=>'F4000_P819_FLOW_ID'
,p_message_text=>'Application ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39900709236773101)
,p_name=>'F4000_P819_SCHEME_NAME'
,p_message_text=>'Scheme Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66234300562097054)
,p_name=>'F4000_P820_MY_PARTNER'
,p_message_text=>'Oracle Application Server Single Sign-On (My Application as Partner App)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66232732245068270)
,p_name=>'F4000_P820_SHOW_ACCOUNT_CRED'
,p_message_text=>'Show Login Page and Use %0 Account Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66233124757075644)
,p_name=>'F4000_P820_SHOW_BUILTIN_PG_OPEN'
,p_message_text=>'Show Built-In Login Page and Use Open Door Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66233507919080219)
,p_name=>'F4000_P820_SHOW_USE_LDAP'
,p_message_text=>'Show Login Page and Use LDAP Directory Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66233902509088076)
,p_name=>'F4000_P820_SSO_HTMLDB_PARTNER'
,p_message_text=>'Oracle Application Server Single Sign-On (%0 Engine as Partner App)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40267217392815769)
,p_name=>'F4000_P822_CURR_METHOD'
,p_message_text=>'Current Authentication Method'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(41470109728530360)
,p_name=>'F4000_P826_CREATE1'
,p_message_text=>'Single Sign-On (Oracle Use Only)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(41470515616531998)
,p_name=>'F4000_P826_CREATE2'
,p_message_text=>'Oracle Application Server Single Sign-On (%0 as Partner Application)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(41470923234534243)
,p_name=>'F4000_P826_CREATE3'
,p_message_text=>'Oracle Application Server Single Sign-On (My Application as Partner Application)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(41471330160536239)
,p_name=>'F4000_P826_CREATE4'
,p_message_text=>'Built-in Login Page: Use %0 Account Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(58961322020257300)
,p_name=>'F4000_P826_CREATE4A'
,p_message_text=>'Newly Created Login Page: Use %0 Account Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(58961731717260145)
,p_name=>'F4000_P826_CREATE4B'
,p_message_text=>'Existing Login Page: Use %0 Account Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(41471704319538227)
,p_name=>'F4000_P826_CREATE5'
,p_message_text=>'Built-in Login Page: Open Door Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(41472110206539962)
,p_name=>'F4000_P826_CREATE6'
,p_message_text=>'Built-in Login Page: Use LDAP Directory Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(58960510807244588)
,p_name=>'F4000_P826_CREATE6A'
,p_message_text=>'Newly Created Login Page: Use LDAP Directory Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(58960929854250135)
,p_name=>'F4000_P826_CREATE6B'
,p_message_text=>'Existing Login Page: Use LDAP Directory Credentials'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(41472515747541468)
,p_name=>'F4000_P826_CREATE7'
,p_message_text=>'Based on authentication scheme from gallery'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(66235709959128137)
,p_name=>'F4000_P826_NEW'
,p_message_text=>'New'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86652803275501185)
,p_name=>'F4000_P88_FLASHBACK_QUERY'
,p_message_text=>'The undo feature of %0 uses a built in database feature called "Flashback Query", allowing you to query data as of a certain time.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86651009724493635)
,p_name=>'F4000_P88_SELECT_TIME'
,p_message_text=>'Select a time you want to go back to, then click "Apply" to write the source back to the region edit page and close this dialog.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86654430980509247)
,p_name=>'F4000_P88_UNDO_RETENTION'
,p_message_text=>'Based on the database parameter "UNDO_RETENTION", you may only undo changes that occured within the last %0 hour(s).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86681816790580831)
,p_name=>'F4000_P92_CONFIRM_CREATE_STD_TAB'
,p_message_text=>'Confirm Create-Standard Tab in Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86691826187611948)
,p_name=>'F4000_P92_NEW_TABSET_WILL_BE_CREATED'
,p_message_text=>'A new tab set %0 will be created.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86690108872606883)
,p_name=>'F4000_P92_PAGE_WILL_USE_EXISTNG_TABSET'
,p_message_text=>'Page %0 will use the existing tab set "%1".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86685428696593735)
,p_name=>'F4000_P92_TABSET_INFO_INCOMPLETE'
,p_message_text=>'Warning, tabset information in incomplete.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(324108200335061668)
,p_name=>'F4000_P975_VALUE_FOR'
,p_message_text=>'Value for %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150827706538187616)
,p_name=>'F4000_PREV'
,p_message_text=>'Prev.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147096621081006667)
,p_name=>'F4000_QUICK_APP_FINISH'
,p_message_text=>'Click <b>Finish</b> to create or extend your application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147092208221974630)
,p_name=>'F4000_QUICK_APP_OPT_DISP1'
,p_message_text=>'Include breadcrumb navigation aids'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(147092703157982623)
,p_name=>'F4000_QUICK_APP_OPT_DISP2'
,p_message_text=>'Hide primary key in report page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(244166318158214050)
,p_name=>'F4000_SHORTCUT'
,p_message_text=>'Shortcut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(118129716703327549)
,p_name=>'F4000_SVG_CHART'
,p_message_text=>'SVG Chart'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150809716694048608)
,p_name=>'F4000_TOP'
,p_message_text=>'Top'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(196129728553531633)
,p_name=>'F4000_TREE'
,p_message_text=>'Tree'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(315847010134538103)
,p_name=>'F4000_WORKSPACE'
,p_message_text=>'Workspace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25361907636262929)
,p_name=>'F4000_WS_ENTIRE_RESPONSE_DOC'
,p_message_text=>'Entire Response Document'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(29864930406798821)
,p_name=>'F400_P107_STEP'
,p_message_text=>'Step %0'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22139822636023550)
,p_name=>'F4050.ACCEPTED'
,p_message_text=>'DELETE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(316820306488089637)
,p_name=>'F4050.ACCEPTED_MSG'
,p_message_text=>'Accepted'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(188645923081160381)
,p_name=>'F4050.ACTION_ASSIGN'
,p_message_text=>'Schema will be assigned to the workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(188646512823166833)
,p_name=>'F4050.ACTION_NO_ASSIGN'
,p_message_text=>'Schema will not be assigned to the workspace for the following reasons:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(188027029567105422)
,p_name=>'F4050.ADDITIONAL_SCHEMA'
,p_message_text=>'Additional Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145831423697834506)
,p_name=>'F4050.ADJUST'
,p_message_text=>'Adjust'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145812814038784444)
,p_name=>'F4050.ALL'
,p_message_text=>'All'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(316795309915586679)
,p_name=>'F4050.APPROVED'
,p_message_text=>'Approved'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23911325230448901)
,p_name=>'F4050.APPROVED_ACCOUNT_REQ_DISPLAY'
,p_message_text=>'Your request for a workspace has been approved and credentials sent to the email address you provided during registration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179820507844497340)
,p_name=>'F4050.APPROVED_ACCOUNT_REQ_EMAIL_BODY'
,p_message_text=>'Your request for an account has been approved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179819727321484036)
,p_name=>'F4050.APPROVED_ACCOUNT_REQ_EMAIL_SUBJ'
,p_message_text=>'Approved: account request for %0 '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179825711288697031)
,p_name=>'F4050.APPROVE_ADD_STORAGE_EMAIL'
,p_message_text=>'Your request for an additional %0 megabytes of storage in workspace %1 has been approved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(316794322942474215)
,p_name=>'F4050.ASSIGNED'
,p_message_text=>'Assigned'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(639421725872867422)
,p_name=>'F4050.AUTOMATIC'
,p_message_text=>'Automatic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(316794127470472124)
,p_name=>'F4050.AVAILABLE'
,p_message_text=>'Available'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1352007997049892192)
,p_name=>'F4050.BROKEN'
,p_message_text=>'Broken'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1352009045827898915)
,p_name=>'F4050.CHAIN_STALLED'
,p_message_text=>'Chain Stalled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179828309565772240)
,p_name=>'F4050.CHANGE_APPROVED_EMAIL'
,p_message_text=>'Change request approved'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179828708658781461)
,p_name=>'F4050.CHANGE_DENIED_EMAIL'
,p_message_text=>'Change request denied'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1352007723440891074)
,p_name=>'F4050.COMPLETED'
,p_message_text=>'Completed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(188044408228108792)
,p_name=>'F4050.CREATE_SCHEMA'
,p_message_text=>'Schema will be created.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(316795505602588615)
,p_name=>'F4050.DECLINED'
,p_message_text=>'Declined'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179824828641654723)
,p_name=>'F4050.DECLINED_ACCOUNT_REQ_EMAIL_SUBJ'
,p_message_text=>'Declined: account request for %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179827921209766125)
,p_name=>'F4050.DENY_ADD_STORAGE_EMAIL'
,p_message_text=>'Your request for an additional %0 megabytes of storage in workspace %1 has been denied.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179826503716723282)
,p_name=>'F4050.DENY_NEW_SCHEMA_EMAIL'
,p_message_text=>'Your request for database schema %0 in workspace %1 has been denied.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179826926010739155)
,p_name=>'F4050.DENY_REMOVE_SERVICE_EMAIL'
,p_message_text=>'Your request to terminate service for workspace %0 has been denied.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1352006553209885915)
,p_name=>'F4050.DISABLED'
,p_message_text=>'Disabled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22123827073845070)
,p_name=>'F4050.EMAIL_CLICK_ON_LINK'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Click the link below to complete the approval process. Once complete, you will receive your workspace credentials in a follow-up email.',
'',
'%0'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179821613431527317)
,p_name=>'F4050.EMAIL_GETSTARTED'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Click the link below to get started.',
'',
'%0'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1352008107720893694)
,p_name=>'F4050.FAILED'
,p_message_text=>'Failed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(28982224117920311)
,p_name=>'F4050.HTML_EMAIL_CLICK_ON_LINK'
,p_message_text=>'Please click <a href=''%0''>here</a> to complete the approval process and receive your credentials.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143453901312243350)
,p_name=>'F4050.INFORMATION'
,p_message_text=>'Information'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145886730417921579)
,p_name=>'F4050.INSTALL'
,p_message_text=>'Install'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(316795709663632342)
,p_name=>'F4050.IN_PROGRESS'
,p_message_text=>'In Progress'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145820428152807406)
,p_name=>'F4050.NO_ACTION'
,p_message_text=>'No Action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150244918601045060)
,p_name=>'F4050.P23.USE'
,p_message_text=>'Use'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1494434304923541669)
,p_name=>'F4050.P3.UPDATE_CHECK_DISABLED'
,p_message_text=>'Update Check disabled for the entire instance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150249223496074851)
,p_name=>'F4050.P39_OPEN'
,p_message_text=>'Open'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(187988215369101348)
,p_name=>'F4050.PRIMARY_SCHEMA'
,p_message_text=>'Primary Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145830117810832777)
,p_name=>'F4050.PROVISION'
,p_message_text=>'Provision'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179766225640071194)
,p_name=>'F4050.PROV_CHANGE_REQ_APPROVED'
,p_message_text=>'Change request approved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179765815251068180)
,p_name=>'F4050.PROV_SCHEMA_REQ_APPROVED'
,p_message_text=>'Your request for database schema %0 in workspace %1 has been approved.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1352008426242895159)
,p_name=>'F4050.REMOTE'
,p_message_text=>'Remote'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(316795904487634686)
,p_name=>'F4050.REQUESTED'
,p_message_text=>'Requested'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145809818063776106)
,p_name=>'F4050.RESET'
,p_message_text=>'Reset'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179776000303659950)
,p_name=>'F4050.RESTRICTED_ADMIN'
,p_message_text=>'Warning: The requested schema is restricted because it is an Oracle default schema or because of site-specific policies. Restricted schemas cannot be assigned to workspaces.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1352007116191888317)
,p_name=>'F4050.RETRY SCHEDULED'
,p_message_text=>'Retry Scheduled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(188138128791124106)
,p_name=>'F4050.REUSE_SCHEMA'
,p_message_text=>'Existing schema will be reused.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1352007562054889992)
,p_name=>'F4050.RUNNING'
,p_message_text=>'Running'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1352003976178884132)
,p_name=>'F4050.SCHEDULED'
,p_message_text=>'Scheduled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179625214726302594)
,p_name=>'F4050.SCHEMA_ASSIGNED'
,p_message_text=>'Warning: The requested schema is already assigned to one or more workspaces. Please ensure that giving multiple workspaces access to the same schema is permitted by the security policies at your site before approving this request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179624806930262446)
,p_name=>'F4050.SCHEMA_EXISTS'
,p_message_text=>'Warning: The requested schema already exists.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(188647530485171964)
,p_name=>'F4050.SCHEMA_NOT_EXIST'
,p_message_text=>'The schema does not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(188836903866192677)
,p_name=>'F4050.SCHEMA_RESERVED_NO_WARN'
,p_message_text=>'The schema is reserved and may not be assigned to workspaces.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179625623384305073)
,p_name=>'F4050.SCHEMA_RESTRICTED'
,p_message_text=>'Warning: The requested schema is restricted because it is an Oracle default schema or because of site-specific policies. If you assign this schema to the workspace by proceeding, you will be giving developers in that workspace full access to the sche'
||'ma. Please ensure that this action is consistent with the security policies at your site before approving this request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(188836024167189086)
,p_name=>'F4050.SCHEMA_RESTRICTED_NO_WARN'
,p_message_text=>'The schema is restricted by security policies. Restricted schemas cannot be assigned to workspaces.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179830107665809594)
,p_name=>'F4050.SERVICE_TERMINATED_EMAIL'
,p_message_text=>'Service terminated'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(179830505719818485)
,p_name=>'F4050.SERVICE_TERMINATED_EMAIL_BODY'
,p_message_text=>'Your development service "%0" has been terminated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1352008772171897383)
,p_name=>'F4050.SUCCEEDED'
,p_message_text=>'Succeeded'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(316794518413476363)
,p_name=>'F4050.SUSPENDED'
,p_message_text=>'Suspended'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(316794714099478341)
,p_name=>'F4050.TERMINATE'
,p_message_text=>'Terminate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(316796132510636918)
,p_name=>'F4050.TERMINATED'
,p_message_text=>'Terminated'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1351978525323738372)
,p_name=>'F4050.TERMINATION_IN_PROGRESS'
,p_message_text=>'Termination in Progress'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145836812316859611)
,p_name=>'F4050.VIEW_REQUEST'
,p_message_text=>'View Request'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145882728208911522)
,p_name=>'F4050.WORKSPACE_EXPORT'
,p_message_text=>'Workspace Export'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(75206101896338943)
,p_name=>'F4050.WORKSPACE_HOME'
,p_message_text=>'Workspace Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(75206509861341219)
,p_name=>'F4050.WORKSPACE_LOGIN'
,p_message_text=>'Workspace Login'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(176891429814779648)
,p_name=>'F4050.WSID_EXISTS'
,p_message_text=>'Workspace will not be created because a workspace with the same ID already exists.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(176890818386776368)
,p_name=>'F4050.WSNAME_EXISTS'
,p_message_text=>'Workspace will not be created because a workspace with the same name already exists.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(102929930842706242)
,p_name=>'F4050.WS_CREATED'
,p_message_text=>'Workspace %0 was created at %1 and confirmation sent to the email address you provided during registration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25628922114609795)
,p_name=>'F4050.WS_EXISTS'
,p_message_text=>'Workspace will not be created because it already exists.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25629303891613922)
,p_name=>'F4050.WS_TOBE_CREATED'
,p_message_text=>'Workspace will be created.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114747300497047211)
,p_name=>'F4050_EMAIL_BODY_NEW_PASSWORD'
,p_message_text=>'New Password'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114746927247035998)
,p_name=>'F4050_EMAIL_BODY_PASSWORD_CHANGED'
,p_message_text=>'Account password changed for user %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114745431917999567)
,p_name=>'F4050_EMAIL_SUBJECT_PASSWORD_CHANGED'
,p_message_text=>'Your password has been changed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(24593407723308270)
,p_name=>'F4050_P74_PROVISION'
,p_message_text=>'Database user %0 created with default tablespace %1 using datafile %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26640504268629944)
,p_name=>'F4050_P74_PROVISION1'
,p_message_text=>'Workspace %0 provisioned with administrator %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87844101253467937)
,p_name=>'F4050_SHOW_ALL_WORKSPACES'
,p_message_text=>'Show All Workspaces'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86870432570774655)
,p_name=>'F4300.COL_LENGTH_NOT_NULL'
,p_message_text=>'Column length cannot be null.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86869726683772874)
,p_name=>'F4300.COL_LENGTH_NOT_ZERO'
,p_message_text=>'Column length cannot be zero.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86871506036776399)
,p_name=>'F4300.COL_NAMES_NOT_LONGER_THAN_30'
,p_message_text=>'Column names cannot be longer than %0 characters.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86873212269778193)
,p_name=>'F4300.COL_NAMES_NOT_NULL'
,p_message_text=>'Column names cannot be null.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86881724521791243)
,p_name=>'F4300.F4500.NAME_ALREADY_USED'
,p_message_text=>'<b>%0</b> is already used by an existing object.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86935724306800603)
,p_name=>'F4300.F4500.NOT_VALID_SEQ_NAME'
,p_message_text=>'<b>%0</b> is not a valid sequence name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86867509368767945)
,p_name=>'F4300.F4500.TABLE_ALREADY_EXISTS'
,p_message_text=>'Table name already exists.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86877900626784292)
,p_name=>'F4300.NOT_VALID_PK_NAME'
,p_message_text=>'<b>%0</b> is not a valid primary key name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150255008867089512)
,p_name=>'F4300.P180_FILE_FORMAT'
,p_message_text=>'DOS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143330408052431553)
,p_name=>'F4300.SPREADSHEET_IMPORT'
,p_message_text=>'Spreadsheet Import'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86874519542780298)
,p_name=>'F4300.TABLE_NAMES_NOT_LONGER_THAN_30'
,p_message_text=>'Table names must be less than %0 characters.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87938425952733481)
,p_name=>'F4300_INSTRUCT_TEXT'
,p_message_text=>'First row contains column names.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(224226903173180696)
,p_name=>'F4300_TEXT_IMPORT'
,p_message_text=>'Text Import'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100134429029480686)
,p_name=>'F4350.APPLICATION_OWNER'
,p_message_text=>'Application Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145757327432580123)
,p_name=>'F4350.AVAILABLE'
,p_message_text=>'(available)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145739715779510525)
,p_name=>'F4350.CHANGE'
,p_message_text=>'Change'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(246268318693598982)
,p_name=>'F4350.CONFIRM_SCHEMA_EXISTING'
,p_message_text=>'You have requested that the existing schema %0 be assigned to the workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(246303322896628524)
,p_name=>'F4350.CONFIRM_SCHEMA_NEW'
,p_message_text=>'You have requested that the schema %0 be created and assigned to the workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145735108722498983)
,p_name=>'F4350.CREATE'
,p_message_text=>'Create'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101842816264248805)
,p_name=>'F4350.CREATING_WORKSPACE'
,p_message_text=>'Creating Workspace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145756919813577935)
,p_name=>'F4350.CURRENT'
,p_message_text=>'(current)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100139928252499393)
,p_name=>'F4350.CURRENT_TIME_ON_SERVER'
,p_message_text=>'Current Time (on server)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100137907128493307)
,p_name=>'F4350.CURRENT_USER'
,p_message_text=>'Current User'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145738108160508338)
,p_name=>'F4350.DELETE'
,p_message_text=>'Delete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103022404831297823)
,p_name=>'F4350.DISABLE.WORK.PROV'
,p_message_text=>'Workspace creation has been disabled temporarily.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100132516562477137)
,p_name=>'F4350.HOST_SCHEMA'
,p_message_text=>'Host Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145721801880478113)
,p_name=>'F4350.INSERTED'
,p_message_text=>'Inserted'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100139015439495682)
,p_name=>'F4350.LANGUAGE_PREFERENCE'
,p_message_text=>'Language Preference'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100131603749473450)
,p_name=>'F4350.LAST_DDL_TIME'
,p_message_text=>'Last DDL Time'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20145930490083989)
,p_name=>'F4350.MORE'
,p_message_text=>'%0 more...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100127609936446841)
,p_name=>'F4350.PRODUCT_BUILD'
,p_message_text=>'Product Build'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(461033010354392251)
,p_name=>'F4350.RESET'
,p_message_text=>'Reset'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100128726212451531)
,p_name=>'F4350.SCHEMA_COMPATIBILITY'
,p_message_text=>'Schema Compatibility'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20145609225992720)
,p_name=>'F4350.TRANSLATED_APPLICATIONS'
,p_message_text=>'(+%0 translated applications)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145732306513488953)
,p_name=>'F4350.UNKNOWN'
,p_message_text=>'Unknown'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145728020581483525)
,p_name=>'F4350.UPDATED'
,p_message_text=>'Updated'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100135610113484733)
,p_name=>'F4350.WORKSPACE_ID'
,p_message_text=>'Workspace ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(100136520849487821)
,p_name=>'F4350.WORKSPACE_NAME'
,p_message_text=>'Workspace Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145827801187828057)
,p_name=>'F4350_CLICKTHRU_LOG_ENTRIES'
,p_message_text=>'Click through log entries:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145825206943820255)
,p_name=>'F4350_DEV_LOG_ENTRIES'
,p_message_text=>'Developer activity log entries:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145842000242884497)
,p_name=>'F4350_DISTINCT_USERS'
,p_message_text=>'Distinct Users over all sessions = %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145884207561915021)
,p_name=>'F4350_NO_USER_SELECTED'
,p_message_text=>'no user selected'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145890525353929584)
,p_name=>'F4350_PREFS_EXISTS_FOR'
,p_message_text=>'%0 Preferences exist for %1 users in workspace "%2"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10376412599011993)
,p_name=>'F4350_PREFS_EXISTS_FOR2'
,p_message_text=>'%0 Preferences exist for %1 users'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145816323865796666)
,p_name=>'F4350_RESET_PREFS'
,p_message_text=>'Reset your preferences if you wish to run your application without any preset values.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26373928259575502)
,p_name=>'F4350_RESET_SESSION'
,p_message_text=>'Reset your session state if you wish to run your application without any preset values.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145897527216939654)
,p_name=>'F4350_SELECTED_USER'
,p_message_text=>'Selected User'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145843927600892400)
,p_name=>'F4350_SESSIONS_OLDER_THAN'
,p_message_text=>'Sessions older than %0 day(s) = %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145876518381899229)
,p_name=>'F4350_SESSIONS_OLDER_THAN_MINS'
,p_message_text=>'Sessions older than %0 minute(s) = %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145776530857628394)
,p_name=>'F4350_SESSION_STATE'
,p_message_text=>'Your session is identified by %0 and contains %1 entries.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145933821815023259)
,p_name=>'F4350_SQL'
,p_message_text=>'SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145887300419922455)
,p_name=>'F4350_SUMMARY'
,p_message_text=>'Summary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145832207205839257)
,p_name=>'F4350_TOTAL_SESSIONS'
,p_message_text=>'Total Sessions for workspace "%0" is %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10370229736979001)
,p_name=>'F4350_TOTAL_SESSIONS2'
,p_message_text=>'Total Sessions: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145901825269948512)
,p_name=>'F4350_USER_HAS_X_PREFS'
,p_message_text=>'User %0 has %1 preferences.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145814803780790907)
,p_name=>'F4350_USER_PREFS'
,p_message_text=>'The current user %0 has %1 preferences set.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145920226570967814)
,p_name=>'F4350_WORKSPACE_SCHEMAS'
,p_message_text=>'Workspace Schemas'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1164088521059799755)
,p_name=>'F4400.XML_PARSING_ERROR'
,p_message_text=>'Error in parsing XML: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1164084593598695746)
,p_name=>'F4400.XML_PROCESSING_ERROR'
,p_message_text=>'Error in XML processing: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(423964612803159766)
,p_name=>'F4400_12_ACCESS_MAP1'
,p_message_text=>'Select a Microsoft Access database for migration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(423965116397170271)
,p_name=>'F4400_12_ACCESS_MAP2'
,p_message_text=>'Export Microsoft Access metadata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(423967130858193359)
,p_name=>'F4400_12_ACCESS_MAP3'
,p_message_text=>'Migrate Microsoft Access database to Oracle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(423965624016172423)
,p_name=>'F4400_12_ACCESS_MAP4'
,p_message_text=>'Analyze Microsoft Access Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(423965929211173951)
,p_name=>'F4400_12_ACCESS_MAP5'
,p_message_text=>'Review migrated database schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(423966214450179132)
,p_name=>'F4400_12_ACCESS_MAP6'
,p_message_text=>'Generate Oracle Application Express Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(103684504081754141)
,p_name=>'F4400_ADD_CONSTRAINT'
,p_message_text=>'Add Constraint %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23039222608054691)
,p_name=>'F4400_ATTRIBUTE_ALERTS'
,p_message_text=>'Alerts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23039403692058682)
,p_name=>'F4400_ATTRIBUTE_ATTACHED_LIBRARY'
,p_message_text=>'Attached Libraries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22876616803346632)
,p_name=>'F4400_ATTRIBUTE_BLOCK'
,p_message_text=>'Block'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23039619968063374)
,p_name=>'F4400_ATTRIBUTE_BLOCKS'
,p_message_text=>'Blocks'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22876825807349205)
,p_name=>'F4400_ATTRIBUTE_CANVAS'
,p_message_text=>'Canvas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23039830011066321)
,p_name=>'F4400_ATTRIBUTE_COORDINATES'
,p_message_text=>'Coordinates'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23040006593069046)
,p_name=>'F4400_ATTRIBUTE_EDITOR'
,p_message_text=>'Editor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23040214558071299)
,p_name=>'F4400_ATTRIBUTE_GRAPHICS'
,p_message_text=>'Graphics'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23040422177073564)
,p_name=>'F4400_ATTRIBUTE_ITEM'
,p_message_text=>'Item'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23040602223077226)
,p_name=>'F4400_ATTRIBUTE_MENU'
,p_message_text=>'Menus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23040810880079705)
,p_name=>'F4400_ATTRIBUTE_MODULE_PARAMETER'
,p_message_text=>'Module Parameters'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23041132005085800)
,p_name=>'F4400_ATTRIBUTE_OBJECTGROUP'
,p_message_text=>'Object Group'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22877004813352598)
,p_name=>'F4400_ATTRIBUTE_OBJECTLIBRARYTAB'
,p_message_text=>'Object Library Tab'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23041310319089063)
,p_name=>'F4400_ATTRIBUTE_OBJECT_GROUP'
,p_message_text=>'Object Groups'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22877216241355891)
,p_name=>'F4400_ATTRIBUTE_PROGRAMUNIT'
,p_message_text=>'Program Unit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23041523955102440)
,p_name=>'F4400_ATTRIBUTE_PROGRAMUNITS'
,p_message_text=>'Program Units'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22877426284358800)
,p_name=>'F4400_ATTRIBUTE_PROPERTYCLASS'
,p_message_text=>'Property Class'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23041710581108011)
,p_name=>'F4400_ATTRIBUTE_RECGRPS'
,p_message_text=>'Record Groups'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23041928588113212)
,p_name=>'F4400_ATTRIBUTE_REPORT'
,p_message_text=>'Reports'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23042106556116281)
,p_name=>'F4400_ATTRIBUTE_TRIGGERS'
,p_message_text=>'Triggers'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23042317638119496)
,p_name=>'F4400_ATTRIBUTE_VISUALATTRIBUTE'
,p_message_text=>'Visual Attribute'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23042502531124600)
,p_name=>'F4400_ATTRIBUTE_VISUALATTRIBUTES'
,p_message_text=>'Visual Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23042700874379622)
,p_name=>'F4400_ATTRIBUTE_WINDOW'
,p_message_text=>'Window'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23042908493381785)
,p_name=>'F4400_ATTRIBUTE_WINDOWS'
,p_message_text=>'Windows'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23043102737389589)
,p_name=>'F4400_BLOCK_COMMENT'
,p_message_text=>'Generated from Forms Conversion by %0 on %1 - Project: %2, File Name: %3, Block: %4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22874923551310704)
,p_name=>'F4400_BREADCRUMB'
,p_message_text=>'Generate Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23043315550393246)
,p_name=>'F4400_CHKBOX_DESELECTALL'
,p_message_text=>'Deselect All'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23043523862395646)
,p_name=>'F4400_CHKBOX_SELECTALL'
,p_message_text=>'Select All'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23043732173398060)
,p_name=>'F4400_CUSTOM_QRY'
,p_message_text=>'Custom Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23043909794401106)
,p_name=>'F4400_ENHANCED_QRY'
,p_message_text=>'Enhanced Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23044117413403296)
,p_name=>'F4400_ENHANCED_QRY_NOTE'
,p_message_text=>'Incorporating Enhanced Query.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23044327933415748)
,p_name=>'F4400_ENHANCED_QRY_TRIG_NOTE'
,p_message_text=>'The POST-QUERY trigger logic has been incorporated into the Enhanced Query for the block.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(49084600130135399)
,p_name=>'F4400_FORMMENU_LOAD_ERROR'
,p_message_text=>'Forms Menu XML file is not uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(49083930904115866)
,p_name=>'F4400_FORM_LOAD_ERROR'
,p_message_text=>'Forms XML file is not uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23044507286419315)
,p_name=>'F4400_GENERIC_COMMENT'
,p_message_text=>'Generated from Forms Conversion by %0 on %1 - Project: %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23044716636421937)
,p_name=>'F4400_INCLUDE_LABEL'
,p_message_text=>'Include'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23044926332424727)
,p_name=>'F4400_ITEM_PROMPT_LABEL'
,p_message_text=>'Item Prompt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23045110533429666)
,p_name=>'F4400_MIGRATE_TO_LABEL'
,p_message_text=>'Migrate To'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(49085318615150181)
,p_name=>'F4400_OBJECTLIB_LOAD_ERROR'
,p_message_text=>'Forms Object Library XML file is not uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23045322654433185)
,p_name=>'F4400_OBJECT_LIBRARY_FILE_TYPE'
,p_message_text=>'Object Library'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22875625067320614)
,p_name=>'F4400_P108_MENU_FILE_TYPE'
,p_message_text=>'Menu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22876104420324112)
,p_name=>'F4400_P108_PROG_FILE_TYPE'
,p_message_text=>'Program Unit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23194305479740580)
,p_name=>'F4400_P10_QUERIES_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Use the far left column to select the queries you want to include in the migration. ',
'<br><br>',
'To include a query, it must have a status of Valid. By default, all queries with a Valid status are selected.',
'<br><br>',
'If you do not select a query for inclusion, any forms or reports based on this query will not be included in the migration.',
'<br><br>',
'Click the <b>Attempt to compile invalid queries</b> link to run a bulk process that tries to compile all the queries.',
'<br><br>',
'Click <b>Apply Changes</b> to save your selections or updates.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23038005611699829)
,p_name=>'F4400_P12_HOWTO_STEP1'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>1. Export Microsoft Access metadata.</b><br />',
'Run the Exporter for Microsoft Access and extract the metadata from the .mdb file. This creates database (.xml) and application (.sql) output files.',
'<p />'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23041516824712514)
,p_name=>'F4400_P12_HOWTO_STEP2'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>2. Migrate the Microsoft Access database to Oracle.</b><br />',
'Run the Oracle SQL Developer Migration Workbench and load the database metadata from Step 1. This migrates the schema and data to Oracle.',
'<p />'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23042704834718509)
,p_name=>'F4400_P12_HOWTO_STEP3'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>3. Create an Oracle Application Express Workspace.</b><br />',
'Run Oracle Application Express and create a workspace. Associate the workspace with the newly created schema from Step 2.',
'<p />'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23043216262721840)
,p_name=>'F4400_P12_HOWTO_STEP4'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>4. Create a migration project.</b><br />',
'Log in to the workspace created in Step 3 and run the Application Migration Workshop. Create a migration project and load the application metadata from Step 1.',
'<p />'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23044427606743947)
,p_name=>'F4400_P12_HOWTO_STEP5'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>5. Analyze the Microsoft Access application.</b><br />',
'From the Application Migration Workshop, verify and adjust the Access application metadata. Refine the scope of migration and fix any invalid objects. ',
'<p />'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23045806266747267)
,p_name=>'F4400_P12_HOWTO_STEP6'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>6. Generate the Oracle Application Express Application.</b><br />',
'Create either an application based on valid forms and reports or a maintenance application based on valid tables and views.',
'<p />'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23046724967752688)
,p_name=>'F4400_P12_HOWTO_STEP7'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>7. Customize your Application Express application.</b><br />',
'Open your application in the App Builder part of Application Express, and customize your migrated application. You can change application attributes or add new pages to the application.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61758013522651580)
,p_name=>'F4400_P13_DBNAME'
,p_message_text=>'Database Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61775905632904693)
,p_name=>'F4400_P13_LINKED'
,p_message_text=>'Linked'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(61757126897645969)
,p_name=>'F4400_P13_VERSION'
,p_message_text=>'Version'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23045508849457595)
,p_name=>'F4400_P17_ATTRIBS_INFO'
,p_message_text=>'Visual Attributes retrieved from an Oracle Forms application are not included in the scope of a Forms Migration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22874702773304663)
,p_name=>'F4400_P18_SCRIPT_MMB_NAME'
,p_message_text=>'Forms Menu XML File Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23046300284511823)
,p_name=>'F4400_P18_SCRIPT_NAME'
,p_message_text=>'Forms XML File Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22875413986317416)
,p_name=>'F4400_P18_SCRIPT_OLB_NAME'
,p_message_text=>'Forms Object Library XML File Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22873900433285122)
,p_name=>'F4400_P18_SCRIPT_PLD_NAME'
,p_message_text=>'PL/SQL Library File Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22873718656280865)
,p_name=>'F4400_P18_SCRIPT_RPT_NAME'
,p_message_text=>'Oracle Report XML File Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23046631452520851)
,p_name=>'F4400_P18_SCRIPT_SIZE'
,p_message_text=>'Size in Bytes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23046821325536864)
,p_name=>'F4400_P19_TRIGGERS_INFO'
,p_message_text=>'Triggers retrieved from an Oracle Forms application are not included in the scope of a Forms Migration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23204224488793368)
,p_name=>'F4400_P20_REPORTS_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Use the far left column to select the reports you want to include in the migration.',
'<br><br>',
'To include a report, the source of the report must have a status of Valid. By default, all reports based on valid source objects are selected.',
'<br><br>',
'Click the <b>Attempt to compile invalid SQL queries</b> link to run a bulk process that tries to compile all invalid SQL queries.',
'<br><br>',
'Click <b>Apply Changes</b> to save your selections or updates.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(24499616247914891)
,p_name=>'F4400_P22_NO_TABLE'
,p_message_text=>'The associated Microsoft Access table was not successfully migrated to Oracle.  Review the Oracle Migration Workbench logfile for further information.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23133330338492253)
,p_name=>'F4400_P22_OBJ_CREATED'
,p_message_text=>'"%0" has been successfully created.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23199412667761560)
,p_name=>'F4400_P22_TABLE_INFO'
,p_message_text=>'If a table does not have a primary key, click the <b>Create Primary Key</b> link to add one. All tables should have a primary key before they are migrated.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(64809603781013715)
,p_name=>'F4400_P2_DATABASES'
,p_message_text=>'Databases'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(64798827143906899)
,p_name=>'F4400_P2_INCLUDED'
,p_message_text=>'Included'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(64798307750901265)
,p_name=>'F4400_P2_INVALID'
,p_message_text=>'Invalid'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22947104612901728)
,p_name=>'F4400_P30_NO_VIEW'
,p_message_text=>'An Oracle view has not been found to correspond with the Microsoft Access query.  The Microsoft Access query syntax has been loaded into the edit window.  Modify this syntax in order to create an Oracle view.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22951700026919334)
,p_name=>'F4400_P30_VIEW_HELP'
,p_message_text=>'A view must have a status of VALID before it can be used during the migration process.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(96718930895256629)
,p_name=>'F4400_P31_BREADCRUMB'
,p_message_text=>'Generate Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(96713921320187686)
,p_name=>'F4400_P33_BREADCRUMB'
,p_message_text=>'Generate Maintenance Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23033703140670650)
,p_name=>'F4400_P3_FIND_FILE'
,p_message_text=>'Locate the file generated by the Exporter Tool'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23459302826663687)
,p_name=>'F4400_P3_FIND_FORMS_FILE'
,p_message_text=>'Locate the Forms Module XML file generated by the Forms2XML conversion tool.  Click <a href="%0">here</a> for information on how to generate a Forms Module XML file.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2436202536544449)
,p_name=>'F4400_P42_CODE_COMPILED'
,p_message_text=>'Code successfully compiled'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2435903555544446)
,p_name=>'F4400_P42_SQL_VALID'
,p_message_text=>'Valid'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(24820631746638468)
,p_name=>'F4400_P42_VALIDATE'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'To validate the syntax of the SQL query, click <b>Validate</b>. The displayed syntax has been extracted from your Microsoft Access database.',
'<br><br>',
'Ensure that the query uses valid Oracle syntax. Only SQL queries with a status of Valid can be included in the migration process. '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(97417719752999856)
,p_name=>'F4400_P49_APP_DEFS'
,p_message_text=>'Application Defaults'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23297107622920952)
,p_name=>'F4400_P49_DEFS_HELP'
,p_message_text=>'When new applications are created, these defaults will be used.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23047009251561787)
,p_name=>'F4400_P51_MIGPROJ_INFO'
,p_message_text=>'Use the far left column to select the Forms XML files you want to include in the migration. <br><br> To include a file, it must be selected. By default, all files are included. If you do not select a file for inclusion, it will be excluded from the m'
||'igration. <br><br>Click <b>Apply Changes</b> to save your selections or updates.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22874122250291354)
,p_name=>'F4400_P52_FMB_CONTENT_INVALID'
,p_message_text=>'The file you attempted to upload to your Forms migration project is not a valid Forms Module (_fmb.XML) file.  Only Forms Module XML files, generated by the Forms2XML Conversion Tool included with Oracle Forms can be uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22874520650300366)
,p_name=>'F4400_P52_MMB_CONTENT_INVALID'
,p_message_text=>'The file you attempted to upload to your Forms migration project is not a valid Forms Menu (_mmb.XML) file. Only Forms Menu XML files, generated by the Form2XML Conversion tool included with Oracle Forms can be uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22876407452343879)
,p_name=>'F4400_P52_OLB_CONTENT_INVALID'
,p_message_text=>'The file you attempted to upload to your Forms migration project is not a valid Object Library (_olb.XML) file. Only Object Library XML files, generated by the Form2XML Conversion tool included with Oracle Forms can be uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22874310607297447)
,p_name=>'F4400_P52_RPT_CONTENT_INVALID'
,p_message_text=>'The file you attempted to upload to your Forms migration project is not a valid Report (.XML) file. Only Report XML files, generated by the File Conversion utility included with Oracle Reports Builder can be uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23047230376567876)
,p_name=>'F4400_P53_ALERTS_INFO'
,p_message_text=>'An alert message can be stored as a Text Message in the Shared Components of an Oracle Application Express application.  Text Messages can be used to build translatable text strings with substitution variables that can be called from PL/SQL packages,'
||' procedures, and functions.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23047405226570064)
,p_name=>'F4400_P53_ATTACHLIBS_INFO'
,p_message_text=>'In Oracle Forms, generic PL/SQL code can be stored in libraries, and incorporated into applications as attached libraries.  Such libraries would need to be modified to remove Forms-specific functions and references, in order to integrate them with an'
||' Oracle Application Express application either as a PL/SQL page process or package saved to the database.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23047615269572992)
,p_name=>'F4400_P53_BLOCKS_INFO'
,p_message_text=>'A single block can be mapped to a region in Oracle Application Express.  Based upon the block type and data source type (table/view) identified in the Forms XML file, some default mappings are defined.  For example, a report block which is based upon'
||' an Oracle view, will be mapped to an Interactive report in Oracle Application Express.  A form block based upon a table, will be mapped to an Interactive report and form in Oracle Application Express.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23047824619575657)
,p_name=>'F4400_P53_CANVAS_INFO'
,p_message_text=>'In Oracle Forms, the canvas is the object on which the GUI is drawn, the "background" of the form.   In Oracle Application Express, the engine constructs the appearance of each page in a application using Templates. Templates define how pages, page c'
||'ontrols, and page components display.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23048020248583823)
,p_name=>'F4400_P53_COORDINATES_INFO'
,p_message_text=>'Depending on the Coordinate System used in the Oracle Forms application, coordinates can be expressed in real units such as inches, centimeters, and pixels.  One unit in an Oracle Application Express item position might not be equal to one physical p'
||'ixel in an Oracle Forms application.  Therefore the coordinate values cannot be automatically applied to the generated application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23048227175585815)
,p_name=>'F4400_P53_EDITORS_INFO'
,p_message_text=>'In Oracle Forms, Editors provide standard editing features, including search/replace and cut, copy, and paste, for text items. For a selected text item, an Editor can be mapped to a HTML Editor in Oracle Application Express.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23050512489846555)
,p_name=>'F4400_P53_LOVS_INFO'
,p_message_text=>'A List of Values can be mapped to an equivalent List of Values in Oracle Application Express.  When LOVs are selected for inclusion in the migration to Oracle Application Express their associated record group will also be included in the migration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23050728765851234)
,p_name=>'F4400_P53_MENUS_INFO'
,p_message_text=>'Popup menus can be associated with canvases and items on an Oracle Form, allowing the user to access common functions and commands.  As part of a post-generation process, CSS or JavaScript can be used to incorporate menus in an Oracle Application Exp'
||'ress application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23051015044856684)
,p_name=>'F4400_P53_MODPARAMS_INFO'
,p_message_text=>'Module Parameters allow for the definition and setting of input values, required by an Oracle Form on startup.  Application and page-level items in Oracle Application Express can provide similar capabilities.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23051222317858822)
,p_name=>'F4400_P53_OBJECTS_HELP'
,p_message_text=>'This page provides a list of the Objects retrieved from an Oracle Forms Module (.fmb.XML) file.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23051432013861593)
,p_name=>'F4400_P53_OBJGRPS_INFO'
,p_message_text=>'In Oracle Forms, an object group can be defined to package related objects for use in other parts of an application or other projects.  Navigation, User Interface, and logic can be easily shared by multiple applications in Oracle Application Express '
||'via Shared Components.  Also the export/import utility allows for the easy movement of pages between applications.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23051605825863546)
,p_name=>'F4400_P53_PROGUNITS_INFO'
,p_message_text=>'In the post-generation phase of a Forms Conversion process, Program Units can be incorporated into your Oracle Application Express application as a PL/SQL package, page process, computation or validation.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23051821755868080)
,p_name=>'F4400_P53_PROPERTY_CLASS_INFO'
,p_message_text=>'In Oracle Forms, a Property Class is a named object that contains a list of properties and their settings.  An object based on a property class can inherit the settings of any property in that class that make sense for the object.  Similarly, in Orac'
||'le Application Express, a Theme is a named collection of templates used to define the user interface of an application.  Oracle Application Express has a repository of 20 themes, and you can also create your own custom themes.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23052029720870398)
,p_name=>'F4400_P53_RECGRPS_INFO'
,p_message_text=>'In Oracle Forms, LOV values are derived from a record group. When an LOV is defined, it is associated with a named record group.  When an LOV is included in the migration, its associated Record Group will also be included in the migration to Oracle A'
||'pplication Express.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23052311497874635)
,p_name=>'F4400_P53_REPORTS_INFO'
,p_message_text=>'Oracle Reports can be integrated into Oracle Forms, requiring access to the Oracle Application Server 10g Reports Service.  In Oracle Application Express, reports can be easily created in your application, as new pages or simply as regions on existin'
||'g pages within the generated application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23052519116876755)
,p_name=>'F4400_P53_TRIGGERS_INFO'
,p_message_text=>'An Oracle Forms trigger is an event-handler written in PL/SQL to augment the default processing behavior.  The trigger logic can be incorporated into an Oracle Application Express application as a computation, validation or PL/SQL process at post-gen'
||'eration phase.  Where feasible, POST-QUERY block trigger logic can be automatically incorporated in the generated Oracle Application Express application, as part of the Enhanced Query generation.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23052726388878891)
,p_name=>'F4400_P53_VISUAL ATTRIBS_INFO'
,p_message_text=>'Visual attributes are the font, color, and pattern properties that you can set for form and menu objects that appear in an Oracle Forms application''s interface.  Using the default Cascading Style Sheets (CSS) installed with Oracle Application Express'
||', or by uploading your own CSS files, style can be applied to your Oracle Application Express application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23052932621880666)
,p_name=>'F4400_P53_WINDOWS_INFO'
,p_message_text=>'A window is the container for all visual objects that make up a Oracle Forms application, including canvases.  In Oracle Application Express, a Page holds all of the visual objects for an application.  Pages can also have application logic;perform ca'
||'lculation;perform validations;and display reports, calendars, and charts.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23053108165883063)
,p_name=>'F4400_P54_BLOCKS_HELP'
,p_message_text=>'1. Use the far left column to select the Blocks you want to include in the migration. <br><br> To include a block, it must be selected. By default, all Blocks are included. If you do not select a block for inclusion, it will be excluded from the migr'
||'ation. <br><br> 2. In the <b>Title</b> column, enter a value to be associated with the block.  Blocks are migrated to Oracle Application Express Regions.  The title will be used as the name of the migrated region. <br><br>3. Click <b>Apply Changes</b'
||'> to save your selections or updates.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23053308043949321)
,p_name=>'F4400_P55_BLOCKITEMS_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'1. Use the far left column to select the Block Items you want to include in the migration. <br><br> To include a block item, it must be selected. By default, all Block Items are included. If you do not select a block item for inclusion, it will be ex'
||'cluded from the migration. <br><br> 2. In the <b>Prompt</b> column, enter a value to be associated with the block. Blocks are migrated to Oracle Application Express Regions. This value will be used as the name of the migrated Region.',
'<br><br> 3. Click <b>Apply Changes</b> to save your selections or updates.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23053627090954786)
,p_name=>'F4400_P57_LOVS_HELP'
,p_message_text=>'Use the far left column to select the Lists of Values (LOVs) you want to include in the migration. <br><br> To include a column, it must be selected. By default, all LOVs are included. <br><br> If you do not select an LOV for inclusion, it will be ex'
||'cluded from the migration. <br><br>Click <b>Apply Changes</b> to save your selections or updates.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23053802633957144)
,p_name=>'F4400_P58_LOVCOLS_HELP'
,p_message_text=>'Use the far left column to select the columns you want to include in the List of Values for your migration. <br><br> To include a column, it must be selected. By default, all columns are selected. <br><br> If you do not select a column for inclusion,'
||' it will be excluded from the List of Values for your migration. <br><br>Click <b>Apply Changes</b> to save your selections or updates.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23054011983959926)
,p_name=>'F4400_P59_CANVAS_INFO'
,p_message_text=>'Canvasses retrieved from an Oracle Forms application are not included in the scope of a Forms Migration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23054223412963214)
,p_name=>'F4400_P61_HOWTO_FORMS_STEP1'
,p_message_text=>'<p><b>1. Convert Oracle Forms to XML.</b><br /> Run the Forms to XML Conversion tool, Forms2XML, to convert the Forms modules in your application. This creates XML output files.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23054400686966043)
,p_name=>'F4400_P61_HOWTO_FORMS_STEP2'
,p_message_text=>'<p><b>2. Create an Oracle Application Express Workspace.</b><br /> Run Oracle Application Express and create a workspace. Associate the workspace with the Oracle Forms application schema. </p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23054607266968038)
,p_name=>'F4400_P61_HOWTO_FORMS_STEP3'
,p_message_text=>'<p><b>3. Create a migration project.</b><br /> Log in to the workspace created in Step 2 and navigate to Application Migrations from the Migrations Tasks region. Create a migration project and load the application metadata from Step 1. </p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23054813846969852)
,p_name=>'F4400_P61_HOWTO_FORMS_STEP4'
,p_message_text=>'<p><b>4. Analyze the Oracle Forms application.</b><br /> From the Application Migration Workshop, verify and adjust the Forms application metadata. Identify business logic required in the new Application Express application. Refine the scope of your '
||'conversion. </p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23055020426971793)
,p_name=>'F4400_P61_HOWTO_FORMS_STEP5'
,p_message_text=>'<p><b>5. Generate the Oracle Application Express Application.</b><br /> Create a new application using the <em>Create Application Wizard</em>, in the App Builder part of Application Express, to cover the functionality being migrated. </p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23055227698973866)
,p_name=>'F4400_P61_HOWTO_FORMS_STEP6'
,p_message_text=>'<p><b>6. Customize your Application Express application.</b><br /> Open your application and customize your generated application. You can change application attributes or add new pages to the application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23055404973976825)
,p_name=>'F4400_P63_COORDS_INFO'
,p_message_text=>'Coordinates retrieved from an Oracle Forms application are not included in the scope of a Forms Migration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23055611553978694)
,p_name=>'F4400_P64_EDITOR_INFO'
,p_message_text=>'Editors retrieved from an Oracle Forms application are not included in the scope of a Forms Migration.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23055818825980743)
,p_name=>'F4400_P65_PROPCLASS_INFO'
,p_message_text=>'Property Classes retrieved from an Oracle Forms application are not included in the scope of a Forms Migration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23056025405982734)
,p_name=>'F4400_P66_RECGRPS_INFO'
,p_message_text=>'Record Groups retrieved from an Oracle Forms application are not included in the scope of a Forms Migration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23056232331984715)
,p_name=>'F4400_P67_WINDOWS_INFO'
,p_message_text=>'Windows retrieved from an Oracle Forms application are not included in the scope of a Forms Migration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23056406836986749)
,p_name=>'F4400_P69_PROGUNIT_INFO'
,p_message_text=>'Program Units retrieved from an Oracle Forms application are not included in the scope of a Forms Migration.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23056615147989226)
,p_name=>'F4400_P77_ORIGINAL_QRY'
,p_message_text=>'Original Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23201800462776957)
,p_name=>'F4400_P8_FORMS_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'1. Use the far left column to select the forms you want to include in the migration.',
'<br /><br />',
'To include a form, the source of the form must have a status of Valid. By default, all forms based on valid source objects are selected.',
'<br /><br />',
'2. Click the <b>Attempt to compile invalid SQL queries</b> link to run a bulk process that tries to compile all invalid SQL queries.',
'<br /><br />',
'3. In the <b>Migrate to</b> column, select the type of Oracle Application Express object that you want to migrate your Microsoft Access form to:  ',
'<li>Form (default option)</li>',
'<li>Tabular Form</li>',
'<li>Report and Form</li>',
'<br><br>',
'These options appear for valid tables and queries.',
'<br><br>',
'4. Click <b>Apply Changes</b> to save your selections or updates. ',
'<p />',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23198212189751931)
,p_name=>'F4400_P9_TABLES_HELP'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Use the far left column to select the tables you want to include in the migration.',
'<br><br>',
'To include a table, it must have a status of Valid. By default, all tables with a Valid status are selected.',
'<br><br>',
'If you do not select a table for inclusion, all forms and reports based on this table are excluded from the migration.',
'<br><br>Click <b>Apply Changes</b> to save your selections or updates.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(23056826575992510)
,p_name=>'F4400_REPORT_COMMENT'
,p_message_text=>'Generated from Forms Conversion by %0 on %1 - Project: %2, File Name: %3, Report: %4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(49082202844032117)
,p_name=>'F4400_REPORT_LOAD_ERROR'
,p_message_text=>'Reports XML file is not uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(478353110365608341)
,p_name=>'F4400_UNKNOWN_DBSRC_NOTE'
,p_message_text=>'The Datasource associated with the block is not a table or view in the schema associated with your Conversion project.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146267100756264668)
,p_name=>'F4500.DISPLAY_SEQ_IN_FORM_NUMERIC'
,p_message_text=>'Display Seq in Forms must be numeric.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146280202019331291)
,p_name=>'F4500.DISPLAY_SEQ_IN_REPORT_NUMERIC'
,p_message_text=>'Display Seq in Reports must be numeric.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87301303321579921)
,p_name=>'F4500.DUP_ARG_NAMES'
,p_message_text=>'The argument name <b>%0</b> is used more than once in this function.<br />'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146551424274794926)
,p_name=>'F4500.EXECUTION_ORDER_MAND'
,p_message_text=>'Execution Order must be specified.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146546516478754859)
,p_name=>'F4500.EXECUTION_ORDER_NUMERIC'
,p_message_text=>'Execution Order must be numeric.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143557202398271997)
,p_name=>'F4500.FIND'
,p_message_text=>'Find'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150265600818106080)
,p_name=>'F4500.HIDE_SQL'
,p_message_text=>'Hide SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(144539404728565975)
,p_name=>'F4500.MAGNIFY'
,p_message_text=>'Magnify'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143584926995354787)
,p_name=>'F4500.MOVE_COLUMN_DOWN'
,p_message_text=>'Move Column Down'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143584321454353171)
,p_name=>'F4500.MOVE_COLUMN_UP'
,p_message_text=>'Move Column Up'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86944204960823452)
,p_name=>'F4500.NEED_UNIQUE_EXECUTION_ORDER'
,p_message_text=>'Enter unique execution order number.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4961911062856252)
,p_name=>'F4500.NEW_COLUMNS'
,p_message_text=>'New Columns to Add'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86937925129810271)
,p_name=>'F4500.NOT_VALID_OBJECT_NAME'
,p_message_text=>'<b>%0</b> is not a valid object name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86936905044804536)
,p_name=>'F4500.NOT_VALID_TABLE_NAME'
,p_message_text=>'<b>%0</b> is not a valid table name.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(143577900498309295)
,p_name=>'F4500.NO_IMAGE'
,p_message_text=>'No Image'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(144544805814594736)
,p_name=>'F4500.NULLABLE'
,p_message_text=>'nullable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(185608217403771413)
,p_name=>'F4500.P40.PREVIOUS.RUNS'
,p_message_text=>'Previous Runs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87227127113454296)
,p_name=>'F4500.P602.DUP_COL_NAME'
,p_message_text=>'The column names <b>%0</b> are used more than once in this table.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87252419934509031)
,p_name=>'F4500.P602.ENTER_AT_LEAST_ONE_COL'
,p_message_text=>'Must enter the name of at least one column.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87249017379498849)
,p_name=>'F4500.P602.INVALID_COL_NAME'
,p_message_text=>'The column name <b>%0</b> is invalid.<br />'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87240403049485169)
,p_name=>'F4500.P602.INVALID_PRECISION'
,p_message_text=>'The precision for the column <b>%0</b> is invalid.<br />'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87241207551486541)
,p_name=>'F4500.P602.INVALID_SCALE'
,p_message_text=>'The scale for the column <b>%0</b> is invalid.<br />'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(24233212357857302)
,p_name=>'F4500.P602.SCALE_REQUIRED'
,p_message_text=>'The scale for the column <b>%0</b> is required.<br />'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150298824647283291)
,p_name=>'F4500.P99.CREATE_SYNONYM_ON'
,p_message_text=>'Create synonym on'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150264420773102430)
,p_name=>'F4500.SHOW_SQL'
,p_message_text=>'Show SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86939707599814700)
,p_name=>'F4500.TABLE_NOT_FOUND_IN_SCHEMA'
,p_message_text=>'Table <b>%0</b> not found in schema <b>%1</b>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(6153518682252669)
,p_name=>'F4500.WARNING_STATEMENTS'
,p_message_text=>'Warning Statements'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146099910602710759)
,p_name=>'F4500_BROKEN'
,p_message_text=>'Broken'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146136610695767564)
,p_name=>'F4500_BYTES'
,p_message_text=>'Bytes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146134327879763063)
,p_name=>'F4500_CARD'
,p_message_text=>'Card'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146048107345624604)
,p_name=>'F4500_CHECK'
,p_message_text=>'Check'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145347023829143851)
,p_name=>'F4500_CLICK_POP_QUERY'
,p_message_text=>'Click to populate query field'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146133714027759013)
,p_name=>'F4500_COST'
,p_message_text=>'Cost'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145297307936091921)
,p_name=>'F4500_CREATE_SUCCESS'
,p_message_text=>'The create operation was successful.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(719539727706485054)
,p_name=>'F4500_DICTIONARY_OBJECTS_WO_DEFAULTS'
,p_message_text=>'Objects without defaults'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(719539567651483175)
,p_name=>'F4500_DICTIONARY_OBJECTS_W_DEFAULTS'
,p_message_text=>'Objects with defaults'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145286019917010171)
,p_name=>'F4500_DROP_SUCCESS'
,p_message_text=>'The drop operation was successful.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20617205117621379)
,p_name=>'F4500_FOREIGN'
,p_message_text=>'Foreign'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(115221323309093715)
,p_name=>'F4500_FOREIGN_KEY'
,p_message_text=>'Foreign Key'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87772822417376371)
,p_name=>'F4500_NATIVE'
,p_message_text=>'Native file format.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145208513674932676)
,p_name=>'F4500_NOT_AVAIL_EDIT'
,p_message_text=>'not available to edit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146115004630727899)
,p_name=>'F4500_NOT_AVAIL_SEARCH'
,p_message_text=>'not available to search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146064507869662636)
,p_name=>'F4500_OF'
,p_message_text=>'Of'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146133000175755050)
,p_name=>'F4500_OPTIMIZER'
,p_message_text=>'Optimizer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145353215087160173)
,p_name=>'F4500_OP_SUCCESS'
,p_message_text=>'The operation was successful.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(222942624645486615)
,p_name=>'F4500_P101_NO_VARCHAR'
,p_message_text=>'VARCHAR column types do not exist.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(29685025840567465)
,p_name=>'F4500_P1023_PARSING'
,p_message_text=>'Parsing script - please wait.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108651212594587181)
,p_name=>'F4500_P10_CREATED_BY'
,p_message_text=>'Created By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14417206166401083)
,p_name=>'F4500_P10_NUM_STMTS'
,p_message_text=>'Number of Statements'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(111190222010213705)
,p_name=>'F4500_P10_ON_BY'
,p_message_text=>'on %0 by %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145039831617407999)
,p_name=>'F4500_P10_PARAMETERS'
,p_message_text=>'If you have parameters in the script, please define them before running.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(14415329106388731)
,p_name=>'F4500_P10_SCRIPT_NAME'
,p_message_text=>'Script Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(111187805256199440)
,p_name=>'F4500_P10_SCRIPT_SIZE'
,p_message_text=>'Script Size in Bytes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108648409693576820)
,p_name=>'F4500_P10_UPDATED_BY'
,p_message_text=>'Updated By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145049516426432058)
,p_name=>'F4500_P10_VALUE'
,p_message_text=>'Value'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240424019155921125)
,p_name=>'F4500_P115.CONFIRM'
,p_message_text=>'You have requested to import the following script(s). Please confirm your request.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240441423104007467)
,p_name=>'F4500_P115.ERROR'
,p_message_text=>'The script(s) you have requested to import exceed the maximum storage allowed.  Please contact the %0 administrator.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(240683129649023879)
,p_name=>'F4500_P115.SCRIPTS_TO_INSTALL'
,p_message_text=>'Script to Import'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145067700459474699)
,p_name=>'F4500_P11_NO_ERROR'
,p_message_text=>'No Error'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145063421668461909)
,p_name=>'F4500_P11_NUM'
,p_message_text=>'Num'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(131409305258381399)
,p_name=>'F4500_P1224_VIEW_OUTPUT'
,p_message_text=>'View Output'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166297025988065990)
,p_name=>'F4500_P129_BROWSE_SEQ'
,p_message_text=>'Browse Sequences'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166304107119098442)
,p_name=>'F4500_P129_NO_SUCCESS'
,p_message_text=>'The create sequence operation was not successful for the following reason:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166295206118050807)
,p_name=>'F4500_P129_SEQUENCE_CREATED'
,p_message_text=>'The sequence "%0" has been created in the "%1" schema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145088703622504043)
,p_name=>'F4500_P12_STATEMENT'
,p_message_text=>'Statement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166319227645161114)
,p_name=>'F4500_P130_BROWSE_DB_SYN'
,p_message_text=>'Browse Database Synonyms'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166326200596200655)
,p_name=>'F4500_P130_CREATE_NOT_SUCCESS'
,p_message_text=>'The create synonym operation was not successful for the following reason:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166316432709153136)
,p_name=>'F4500_P130_SYNONYM_CREATE_SUCCESS'
,p_message_text=>'The synonym "%0" has been created in the "%1" schema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166336503067229683)
,p_name=>'F4500_P132_CREATE_FAILED'
,p_message_text=>'The create package operation was not successful for the following reason:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166349504508334202)
,p_name=>'F4500_P132_PACKAGE_CREATED'
,p_message_text=>'The package "%0" has been created in the "%1" schema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(98506619730365793)
,p_name=>'F4500_P24_SAVE_TO_WORKSHEET'
,p_message_text=>'Save to Worksheet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145129513459592038)
,p_name=>'F4500_P25_BY'
,p_message_text=>'By'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145124220254584530)
,p_name=>'F4500_P25_CREATED'
,p_message_text=>'Created'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145120031898578382)
,p_name=>'F4500_P25_FILE_NAME'
,p_message_text=>'File Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21304229377805231)
,p_name=>'F4500_P2610_EXPIRED'
,p_message_text=>'Expired'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21304600896815983)
,p_name=>'F4500_P2610_EXPIRED_AND_LOCKED'
,p_message_text=>'Expired and Locked'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21303718988802297)
,p_name=>'F4500_P2610_LOCKED'
,p_message_text=>'Locked'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21303313793800716)
,p_name=>'F4500_P2610_OPEN'
,p_message_text=>'Open'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19164605018620778)
,p_name=>'F4500_P2613_EXPIRED'
,p_message_text=>'Password Expired'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166294905079050480)
,p_name=>'F4500_P402_OPERATION_FAILED'
,p_message_text=>'The operation was not successful for the following reason:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(151500305009038413)
,p_name=>'F4500_P51_NOT_AVAIL_INSERT'
,p_message_text=>'not available to insert data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166287900615001934)
,p_name=>'F4500_P54_BROWSE_VIEW'
,p_message_text=>'Browse Database View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166277531689954160)
,p_name=>'F4500_P54_NOT_SUCCESS'
,p_message_text=>'The create view operation was not successful for the following reason:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166281603207964850)
,p_name=>'F4500_P54_SQL_WORKSHOP_HOME'
,p_message_text=>'SQL Workshop Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(166286500830992559)
,p_name=>'F4500_P54_VIEW_CREATED'
,p_message_text=>'The view "%0" has been created in the "%1" schema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(150901620754393463)
,p_name=>'F4500_P553_GET_COLUMN_COMMENT'
,p_message_text=>'Get Column Comment'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(254185229264096515)
,p_name=>'F4500_P602_IDENTITY'
,p_message_text=>'Identity'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(28545002787003941)
,p_name=>'F4500_P602_NO_DATATYPE'
,p_message_text=>'No datatype specified for %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145279405887968360)
,p_name=>'F4500_P68_TABLE_OP_SUCCESS'
,p_message_text=>'The table operation was successful.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145019719665366670)
,p_name=>'F4500_P6_STATEMENT_CNT'
,p_message_text=>'This file has %0 statements.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145027231917379739)
,p_name=>'F4500_P6_USER_DEFINED'
,p_message_text=>'User has defined following %0 parameter(s):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87775006880400316)
,p_name=>'F4500_PARSE'
,p_message_text=>'Parse this script.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146047030416621864)
,p_name=>'F4500_PRIMARY'
,p_message_text=>'Primary'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(8662002623439149)
,p_name=>'F4500_REFERENTIAL'
,p_message_text=>'Referential'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87774310212391770)
,p_name=>'F4500_TEXT_FILE_FORMAT'
,p_message_text=>'View document as text.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(146047502150623094)
,p_name=>'F4500_UNIQUE'
,p_message_text=>'Unique'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(2358690750438193077)
,p_name=>'F4550.STATIC_FILES_NOT_CONFIGURED'
,p_message_text=>'There are issues with the configuration of the Static Files in your environment. Please consult the "Configuring Static File Support" section in the Application Express Installation Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(275883433348136277)
,p_name=>'F4550.WELCOME_TO_APEX_ADB'
,p_message_text=>'Welcome to Oracle APEX! Please sign in using the administrator (ADMIN) password of your Autonomous Database.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1883643949316343761)
,p_name=>'F4700.ACCOUNT_REQ_EMAIL_BODY'
,p_message_text=>'You are receiving this email because you requested an Oracle Application Express workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1883643490032314793)
,p_name=>'F4700.ACCOUNT_REQ_EMAIL_SUBJ'
,p_message_text=>'Action required: account request for %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177810622932624330)
,p_name=>'F4700.EMAIL_NOTE'
,p_message_text=>'(used to email your credentials)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177842811092791262)
,p_name=>'F4700.EXISTING_SCHEMA_HINT'
,p_message_text=>'Please enter a database schema that currently exists in your Oracle database.  For security reasons, a list of values is not provided.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177835513601773076)
,p_name=>'F4700.NEW_SCHEMA_HINT'
,p_message_text=>'Please enter the name of the Oracle database schema you would like to have created for your workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177452818985137617)
,p_name=>'F4700.P26_JUSTIFY_RESTRICTED_SCHEMA'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'In your description below, please explain why you are requesting a restricted schema.',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177453227296140032)
,p_name=>'F4700.P26_JUSTIFY_SHARED_SCHEMA'
,p_message_text=>'In your description below, please explain why you are requesting a schema that is already in use by one or more other workspaces.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177723125292095133)
,p_name=>'F4700.P26_WARN_RESTRICTED_SCHEMA'
,p_message_text=>'Warning: The schema you are requesting is restricted for security reasons. The %0 administrator may deny your request to assign this schema to your workspace.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177722707630090001)
,p_name=>'F4700.P26_WARN_SHARED_SCHEMA'
,p_message_text=>'Warning: The schema you are requesting is already used by other workspace(s). The %0 administrator may deny your request to assign this schema to your workspace. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(175016213507057623)
,p_name=>'F4700.SCHEMA_RESTRICTED'
,p_message_text=>'The new schema that you have requested for your workspace is an Oracle default schema or may be specifically restricted at your site for security reasons and may not eligible for assignment to a workspace. The site administrator may reject your provi'
||'sioning request if this violates a security policy at your site.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(175015705280036394)
,p_name=>'F4700.SCHEMA_USED_BY_WORKSPACES'
,p_message_text=>'The schema that you have requested for your workspace is already assigned to %0 workspace(s). The site administrator may reject your provisioning request if this violates a security policy at your site.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20376230637286985)
,p_name=>'F4700P1_A'
,p_message_text=>'Oracle Application Express provides access to an Oracle database and browser based development tools.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20376522803294173)
,p_name=>'F4700P1_B'
,p_message_text=>'Declaratively build web applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20377100209306659)
,p_name=>'F4700P1_C'
,p_message_text=>'Create and manage database objects'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20377421680312781)
,p_name=>'F4700P1_D'
,p_message_text=>'Track milestones, bugs, features and todos<'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(774107484047717728)
,p_name=>'F4750.P209.DB_APP_USER_SETUP'
,p_message_text=>'The application installed successfully. However, in order to run the application with Application Express account authentication, an Application Express user account must be set up.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(774109021300748692)
,p_name=>'F4750.P209.WEBSHEET_ADMIN_SETUP'
,p_message_text=>'The Websheet installed successfully. However, in order to run the Websheet with Application Express account authentication, an administrator with Application Express account must be set up.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(940818159815905787)
,p_name=>'F4850.P1.SCHEMA_DOES_NOT_EXIST'
,p_message_text=>'Unable to reset sample RESTful Services data: schema <code>%0</code> does not exist.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(468710109484602182)
,p_name=>'F4900_P11_AUTH_TYPE_MESSAGE'
,p_message_text=>'This application uses %0 authentication scheme.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(497070198305366360)
,p_name=>'FACETED_SEARCH'
,p_message_text=>'Faceted Search'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(473482670721129506)
,p_name=>'FACETED_SEARCH.INVALID.SOURCE'
,p_message_text=>'The wizard cannot create a faceted search using the report source.  There are no columns to search.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(290123702722891054)
,p_name=>'FAILURE'
,p_message_text=>'failure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145140532337635325)
,p_name=>'FAILURES'
,p_message_text=>'Failures'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(173614400185012397)
,p_name=>'FDASH1'
,p_message_text=>'%0 Features'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(191517916887838475)
,p_name=>'FEATURE'
,p_message_text=>'Feature'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1397683851852755265)
,p_name=>'FEATURE OWNERS'
,p_message_text=>'Feature Owners'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84200705203356904)
,p_name=>'FEATURE.ABOUT_PAGE'
,p_message_text=>'About Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84201952224370403)
,p_name=>'FEATURE.ABOUT_PAGE.DESCRIPTION'
,p_message_text=>'About this application page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84200995203358854)
,p_name=>'FEATURE.ACCESS_CONTROL'
,p_message_text=>'Access Control'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84203680172383309)
,p_name=>'FEATURE.ACCESS_CONTROL.DESCRIPTION'
,p_message_text=>'Incorporate role based user authentication within your application and manage username mappings to application roles.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84201123246360046)
,p_name=>'FEATURE.ACTIVITY_REPORTING'
,p_message_text=>'Activity Reporting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84204130716386721)
,p_name=>'FEATURE.ACTIVITY_REPORTING.DESCRIPTION'
,p_message_text=>'Include numerous reports and charts on end user activity.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84201381991361273)
,p_name=>'FEATURE.CONFIGURATION_OPTIONS'
,p_message_text=>'Configuration Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84219433920465509)
,p_name=>'FEATURE.CONFIGURATION_OPTIONS.DESCRIPTION'
,p_message_text=>'Allow application administrators to enable or disable specific functionality, associated with an Application Express build option, from within the application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183301178307521710)
,p_name=>'FEATURE.CREATE_BUILD_OPTION'
,p_message_text=>'The following Build Option(s) will be created:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(231894282222679540)
,p_name=>'FEATURE.EMAIL_REPORT'
,p_message_text=>'Email Reporting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(231895170003687078)
,p_name=>'FEATURE.EMAIL_REPORT.DESCRIOTION'
,p_message_text=>'Includes a report on the APEX_SEND() email queue.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(282644396285664209)
,p_name=>'FEATURE.EMAIL_REPORT.DESCRIPTION'
,p_message_text=>'Includes a report displaying the mail to be sent joined with the log of emails already sent.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84201562179363041)
,p_name=>'FEATURE.FEEDBACK'
,p_message_text=>'Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84204379551407363)
,p_name=>'FEATURE.FEEDBACK.DESCRIPTION'
,p_message_text=>'Provide a mechanism for end users to post general comments back to the application administrators and developers.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(231895348983688353)
,p_name=>'FEATURE.JOB_REPORT'
,p_message_text=>'Job Reporting'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(231895511104694051)
,p_name=>'FEATURE.JOB_REPORT.DESCRIPTION'
,p_message_text=>'Includes a report on database jobs, with the ability to drill down on a specific job to see additional details.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84201747465364726)
,p_name=>'FEATURE.THEME_STYLE_SELECTION'
,p_message_text=>'Theme Style Selection'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(84219048821446127)
,p_name=>'FEATURE.THEME_STYLE_SELECTION.DESCRIPTION'
,p_message_text=>'Allow administrators to select a default color scheme (theme style) for the application. Administrators can also choose to allow end users to choose their own theme style. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184180325554185504)
,p_name=>'FEATURES'
,p_message_text=>'Features'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485078731951974562)
,p_name=>'FEATURES_100_PCT'
,p_message_text=>'Features 100%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(234853120204102803)
,p_name=>'FEATURES_100_PERCENT'
,p_message_text=>'Features 100% (%0/%1)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(192145719707498175)
,p_name=>'FEATURES_80_PCT'
,p_message_text=>'Features 80%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(18577520238762949)
,p_name=>'FEATURES_AT_LEAST_80'
,p_message_text=>' %0 >= 80%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(17728012725427410)
,p_name=>'FEATURES_COMPLETE'
,p_message_text=>'Features Complete (%0 / %1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(18575220800753718)
,p_name=>'FEATURES_COMPLETED'
,p_message_text=>'%0 Completed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(487513045802053287)
,p_name=>'FEATURES_FOR_RELEASE'
,p_message_text=>'Features for Release %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(234854220992193558)
,p_name=>'FEATURES_PAST_DUE'
,p_message_text=>'Past Due (%0/%1)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(496362715660481844)
,p_name=>'FEATURES_PERCENT_COMPLETE'
,p_message_text=>'Percent of features functionally complete (%0/%1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(234853610018168240)
,p_name=>'FEATURES_WITH_DATES'
,p_message_text=>'With dates (%0/%1)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(254149506154089255)
,p_name=>'FEATURE_CONFIGURATION'
,p_message_text=>'Feature Configuration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183999820904623129)
,p_name=>'FEATURE_CONTRIBUTOR'
,p_message_text=>'Contributor'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(234852831418097601)
,p_name=>'FEATURE_COUNT'
,p_message_text=>'Feature Count'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(483990512251943978)
,p_name=>'FEATURE_DASH_01'
,p_message_text=>'%0 features, %1 fully completed, in %2 release(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(483991303780055107)
,p_name=>'FEATURE_DASH_02'
,p_message_text=>'%0 top level features'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(483991707028065508)
,p_name=>'FEATURE_DASH_03'
,p_message_text=>'%0 have no due date, %1 are past due and < 80% complete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(483992006467074756)
,p_name=>'FEATURE_DASH_04'
,p_message_text=>'%0 features are functionally complete, %1 are not'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(485023122808836612)
,p_name=>'FEATURE_DASH_05'
,p_message_text=>'%0% of features are 100% completed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183993919818594387)
,p_name=>'FEATURE_DESC'
,p_message_text=>'Feature Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183997427914606213)
,p_name=>'FEATURE_DESIRABILITY'
,p_message_text=>'Desirability'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1036768914043163496)
,p_name=>'FEATURE_LABEL'
,p_message_text=>'Feature: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183991802849589534)
,p_name=>'FEATURE_NAME'
,p_message_text=>'Feature Name'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183992407005590747)
,p_name=>'FEATURE_OWNER'
,p_message_text=>'Feature Owner'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183996316140602799)
,p_name=>'FEATURE_PRIORITY'
,p_message_text=>'Priority'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183996719603603851)
,p_name=>'FEATURE_STATUS'
,p_message_text=>'Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183996010599601201)
,p_name=>'FEATURE_TAGS'
,p_message_text=>'Tags'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1397687342451860888)
,p_name=>'FEATURE_WITHOUT_OWNERS'
,p_message_text=>'Unassigned'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1498532887395479413)
,p_name=>'FEEBACK.LOGGED.AS'
,p_message_text=>'logged %0 and assigned to %1'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(191517304074834773)
,p_name=>'FEEDBACK'
,p_message_text=>'Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(203490604863944127)
,p_name=>'FEEDBACK_ATTRIBUTE'
,p_message_text=>'Please supply this information to be logged as feedback.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273112208343519070)
,p_name=>'FEEDBACK_DASHBOARD'
,p_message_text=>'Feedback Dashboard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184179103605169719)
,p_name=>'FEEDBACK_ENTRIES'
,p_message_text=>'Feedback Entries'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(17736721130486692)
,p_name=>'FEEDBACK_ENTRIES_CLOSED'
,p_message_text=>'%2 Feedback Entries Open (%0 Closed)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(203483808364897872)
,p_name=>'FEEDBACK_HELP'
,p_message_text=>'Enter your feedback and press the submit feedback button.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(496402817419709480)
,p_name=>'FEEDBACK_PERCENT_CLOSED'
,p_message_text=>'Feedback percent closed (%0/%1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(196350621297426902)
,p_name=>'FEEDBACK_TYPE'
,p_message_text=>'Feedback Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(203490319839929578)
,p_name=>'FEEDBACK_TYPE_HELP'
,p_message_text=>'Please identify the type of feedback you are providing.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(367347618256485030)
,p_name=>'FILENAME'
,p_message_text=>'Filename'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184526415977469382)
,p_name=>'FILENAME_COLUMN'
,p_message_text=>'Filename Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(396342026929807355)
,p_name=>'FILENAME_LABEL'
,p_message_text=>'File Name: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184184631581272338)
,p_name=>'FILES'
,p_message_text=>'Files'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(713111144147176087)
,p_name=>'FILES_WITH_COUNT'
,p_message_text=>'%0 files'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184182407162227502)
,p_name=>'FILES_WITH_COUNT_AND_SIZE'
,p_message_text=>'%0 Files, consuming %1K'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(8773431671668311)
,p_name=>'FILE_EMPTY'
,p_message_text=>'The file is empty.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1036652000312093327)
,p_name=>'FILE_LABEL'
,p_message_text=>'File: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9947229840693675)
,p_name=>'FILE_TOO_BIG'
,p_message_text=>'This text file is too large to edit. To change the content, you must edit the file on your local machine and upload it again.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(314431408852809718)
,p_name=>'FILE_TOO_LARGE'
,p_message_text=>'The size of the uploaded file was over %0 MB. Please upload a smaller file.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21798730141180674)
,p_name=>'FILE_UPLOAD_AUTHENTICATION_ERR'
,p_message_text=>'User authentication failed and one or more files were uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21798905684183104)
,p_name=>'FILE_UPLOAD_NOSESSION_ERR'
,p_message_text=>'No valid session exists and one or more files were uploaded.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21799111917184924)
,p_name=>'FILE_UPLOAD_PUBLICUSER_ERR'
,p_message_text=>'This instance does not allow unauthenticated users to upload files.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(21798521829178273)
,p_name=>'FILE_UPLOAD_TOOMANYFILES_ERR'
,p_message_text=>'More files were uploaded in this request than the number of file item types defined on the page.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(232261032177001109)
,p_name=>'FIND_MY_WORKSPACE'
,p_message_text=>'Find My Workspace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(12272820961749624)
,p_name=>'FIND_TABLES'
,p_message_text=>'Find Tables'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1996935978571961857)
,p_name=>'FINISH'
,p_message_text=>'Finish'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145292201310061618)
,p_name=>'FIRST_ENTRY'
,p_message_text=>'First Entry'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236578201387627808)
,p_name=>'FIXBY_PAST_DUE'
,p_message_text=>'Fix by date past due'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172716600667273722)
,p_name=>'FIXED_IN_DEVELOPMENT'
,p_message_text=>'Fixed in development'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(170207650738817284)
,p_name=>'FLASHMAP'
,p_message_text=>'Flash Map'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172469309776241573)
,p_name=>'FLASH_CHART.GANTT_DAYS'
,p_message_text=>'Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172471523544264483)
,p_name=>'FLASH_CHART.GANTT_DAYS_SHORT'
,p_message_text=>'Sun,Mon,Tue,Wed,Thu,Fri,Sat'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172471906014268858)
,p_name=>'FLASH_CHART.GANTT_MONTHS'
,p_message_text=>'January,February,March,April,May,June,July,August,September,October,November,December'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172472418135272325)
,p_name=>'FLASH_CHART.GANTT_MONTHS_SHORT'
,p_message_text=>'Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(77633412528523163)
,p_name=>'FLASH_CHART.INVALID_CANDLESTICK_CHART_QUERY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid Candlestick chart query: %0<br /><br />',
'Use the following syntax:',
'<pre>',
'SELECT LINK, LABEL, OPEN, HIGH, LOW, CLOSE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>Text that displays along a chart axis.</td></tr>',
'<tr><td>OPEN</td><td>Numeric column that specifies the start of the candlestick.</td></tr>',
'<tr><td>HIGH</td><td>Numeric column that specifies the maximum of the candlestick.</td></tr>',
'<tr><td>LOW</td><td>Numeric column that specifies the minimum of the candlestick.</td></tr>',
'<tr><td>CLOSE</td><td>Numeric column that specifies the end of the candlestick.</td></tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(77597720297336181)
,p_name=>'FLASH_CHART.INVALID_CHART_QUERY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid chart query: %0<br /><br />',
'Use the following syntax:',
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'Or use the following syntax for a query returning multiple series:',
'<pre>',
'SELECT LINK, LABEL, VALUE1 [, VALUE2 [, VALUE3...]]',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>Text that displays along a chart axis.</td></tr>',
'<tr><td>VALUE1, VALUE2, VALUE3...</td><td>Numeric columns that define the data values.</td></tr>',
'</table>',
'Note: The series names for Column and Line charts are derived from the column aliases used in the query.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(77637525950545943)
,p_name=>'FLASH_CHART.INVALID_DIAL_CHART_QUERY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid Dial chart query: %0<br /><br /> Use the following syntax:',
'<pre> SELECT VALUE, MAX [, LOW, HIGH] VALUE FROM ... </pre>',
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
'<td>Numeric column that defines dial value.</td>',
'</tr>',
'<tr>',
'<td>MAX</td>',
'<td>Numeric column that defines Maximum dial value.</td>',
'</tr>',
'<tr>',
'<td>LOW (optional)</td>',
'<td>Numeric column that defines the low value of a range to display on the dial. If this value is defined, a HIGH value is required.</td>',
'</tr>',
'<tr>',
'<td>HIGH (optional)</td>',
'<td>Numeric column that defines the high value of a range to display on the dial. If this value is defined, a LOW value is required.</td>',
'</tr>',
'</table>',
'This query should return one row.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(10517310274320838)
,p_name=>'FLASH_CHART.INVALID_MAP_QUERY'
,p_message_text=>'Invalid map query: %0<br /><br /> Use the following syntax: <pre> SELECT LINK, LABEL, VALUE FROM ... </pre> <table class="instructiontext"> <tr><td>LINK</td><td>URL</td></tr> <tr><td>LABEL</td><td>Text that displays on the map data point, referencing'
||' information from the REGION_NAME column of the AnyChart Map Reference Information for the selected map.</td></tr> <tr><td>VALUE1 </td><td>Columns that define the data values.</td></tr> </table>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(77644013314580164)
,p_name=>'FLASH_CHART.INVALID_PIE_CHART_QUERY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid chart query: %0<br /><br />',
'Use the following syntax:',
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>Text that displays in legend text, hint text, and pie slice labels.</td></tr>',
'<tr><td>VALUE</td><td>Numeric column that defines the data values.</td></tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(47586920412315382)
,p_name=>'FLASH_CHART.INVALID_PROJECT_GANTT_QUERY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid Project Gantt chart query: %0<br /><br /> Use the following syntax: <pre> SELECT LINK, TASK_NAME, ID, PARENT_ID, START_DATE, END_DATE, STATUS FROM ... </pre> <table class="instructiontext"> <tr><td>LINK</td><td>Action Link. Can be set to NULL'
||'.</td></tr> <tr><td>TASK_NAME</td><td>Text that displays along a chart task.</td></tr> <tr><td>ID</td><td>Task ID</td></tr> <tr><td>PARENT_ID</td><td>ID associated with the Parent Task. Can be set to NULL.</td></tr>  <tr><td>START_DATE</td><td>Date o'
||'r Timestamp column that specifies the actual start date of the task.</td></tr> <tr><td>END_DATE</td><td>Date or Timestamp column that specifies the actual end date of the task.</td></tr> <tr><td>STATUS</td><td>Numeric column that specifies the percen'
||'tage of progress made for the task.</td></tr> </table><br/>',
'or <pre> SELECT LINK, TASK_NAME, ID, PARENT_ID, START_DATE, END_DATE, STATUS, <br/> PLANNED_START_DATE, PLANNED_END_DATE FROM ... </pre> <table class="instructiontext"> <tr><td>LINK</td><td>Action Link. Can be set to NULL.</td></tr> <tr><td>TASK_NAME'
||'</td><td>Text that displays along a chart task.</td></tr> <tr><td>ID</td><td>Task ID</td></tr> <tr><td>PARENT_ID</td><td>ID associated with the Parent Task. Can be set to NULL.</td></tr> <tr><td>START_DATE</td><td>Date or Timestamp column that specif'
||'ies the actual start date of the task.</td></tr> <tr><td>END_DATE</td><td>Date or Timestamp column that specifies the actual end date of the task.</td></tr> <tr><td>STATUS</td><td>Numeric column that specifies the percentage of progress made for the '
||'task.</td></tr><tr><td>PLANNED_START_DATE</td><td>Date or Timestamp column that specifies the planned start date of the task.</td></tr><tr><td>PLANNED_END_DATE</td><td>Date or Timestamp column that specifies the planned end date of the task.</td></tr'
||'> </table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(77611904123463963)
,p_name=>'FLASH_CHART.INVALID_RANGE_CHART_QUERY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid Range chart query: %0<br /><br />',
'Use the following syntax:',
'<pre>',
'SELECT LINK, LABEL, OPEN_VALUE, CLOSE_VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>Text that displays along a chart axis.</td></tr>',
'<tr><td>OPEN_VALUE</td><td>Numeric column that specifies the start of the range.</td></tr>',
'<tr><td>CLOSE_VALUE</td><td>Numeric column that specifies the end of the range.</td></tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1844502749306703)
,p_name=>'FLASH_CHART.INVALID_RESOURCE_GANTT_QUERY'
,p_message_text=>'Invalid Resource Gantt chart query: %0<br /><br /> Use the following syntax: <pre> SELECT LINK, ID, TASK_NAME, PARENT_ID, START_DATE, END_DATE FROM ... </pre> <table class="instructiontext"> <tr><td>LINK</td><td>Action Link. Can be set to NULL.</td><'
||'/tr><tr><td>ID</td><td>Task ID</td></tr> <tr><td>TASK_NAME</td><td>Text that displays along a chart task.</td></tr> <tr><td>PARENT_ID</td><td>ID associated with Parent Task. Can be set to NULL.</td></tr> <tr><td>START_DATE</td><td>Date or Timestamp c'
||'olumn that specifies the actual start date of the task.</td></tr> <tr><td>END_DATE</td><td>Date or Timestamp column that specifies the actual end date of the task.</td></tr> </table>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(77607926109432456)
,p_name=>'FLASH_CHART.INVALID_SCATTER_CHART_QUERY'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Invalid Scatter chart query: %0<br /><br />',
'Use the following syntax:',
'<pre>',
'SELECT LINK, LABEL, X_VALUE, Y_VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>Text that displays in hints.</td></tr>',
'<tr><td>X_VALUE</td><td>Numeric column that specifies X coordinate values.</td></tr>',
'<tr><td>Y_VALUE</td><td>Numeric column that specifies Y coordinate values.</td></tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(170210541140848068)
,p_name=>'FLASH_CHART5'
,p_message_text=>'AnyChart Flash'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(445006221785259443)
,p_name=>'FLASH_CHART5.MIGRATE_FLASH_TO_FLASH_ERR'
,p_message_text=>'Migrate Flash chart to new Flash chart error. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(945254021834886334)
,p_name=>'FLASH_CHART5.UPGRADE_JSTREE_ERR'
,p_message_text=>'Upgrade jsTree to new Tree error. %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(163300503656516489)
,p_name=>'FLOW.SINGLE_VALIDATION_ERROR'
,p_message_text=>'1 error has occurred'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(152450220776607209)
,p_name=>'FLOW.VALIDATION_ERROR'
,p_message_text=>'%0 errors have occurred'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183992911507592070)
,p_name=>'FOCUS_AREA'
,p_message_text=>'Focus Area'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108524816844748937)
,p_name=>'FOOTER'
,p_message_text=>'Footer Text'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5373709776864896)
,p_name=>'FORM'
,p_message_text=>'Form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1034598021160488225)
,p_name=>'FORMAT_MASK_LABEL'
,p_message_text=>'Format Mask: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236488210803182787)
,p_name=>'FORM_AND_LIST_VIEW'
,p_message_text=>'Form and List View'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(236489817464210045)
,p_name=>'FORM_AND_REPORT'
,p_message_text=>'Report with Form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26443419609348986)
,p_name=>'FORM_OF'
,p_message_text=>'%0 of %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(137275415556534344)
,p_name=>'FORM_ON'
,p_message_text=>'Form in %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(44321031109540358)
,p_name=>'FORM_ON_A_TABLE'
,p_message_text=>'Form on a Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(204696925514770887)
,p_name=>'FORM_QUERY_SUCCESS_MSG'
,p_message_text=>'The form on a query has been created successfully.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(204764429445240132)
,p_name=>'FORM_REPORT_WS_SUCCESS_MSG'
,p_message_text=>'The form and report on a Web service reference has been created successfully.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(202521832506737634)
,p_name=>'FORM_SUCCESS_MSG'
,p_message_text=>'The form has been created successfully.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(204710515089866880)
,p_name=>'FORM_SUMMARY_SUCCESS_MSG'
,p_message_text=>'The summary page has been created successfully.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(204671002711447234)
,p_name=>'FORM_TABLE_SUCCESS_MSG'
,p_message_text=>'The form on a table has been created successfully.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(204738017313048171)
,p_name=>'FORM_WS_SUCCESS_MSG'
,p_message_text=>'The form on a Web service reference has been created successfully.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25709701357732201)
,p_name=>'FORWARD'
,p_message_text=>'Forward'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(256977111726608594)
,p_name=>'FROM_ATTRIBUTE_DICTIONARY'
,p_message_text=>'from Attribute Dictionary'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88048600163580167)
,p_name=>'FUNCTION'
,p_message_text=>'function'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(178053005824935732)
,p_name=>'FUNCTIONALLY_COMPLETE'
,p_message_text=>'Functionally complete'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(171874408801960728)
,p_name=>'FUNCTIONAL_IMPLEMENTATION'
,p_message_text=>'Functional Implementation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(109286116578316206)
,p_name=>'FUNCTION_BODY'
,p_message_text=>'PL/SQL Function Body'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88138201088772751)
,p_name=>'FUNCTION_BODY_RETURNING_QUERY'
,p_message_text=>'PL/SQL function body returning SQL query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(202011106817617558)
,p_name=>'FUNCTION_RETURNING_REF_CURSOR'
,p_message_text=>'PL/SQL function body returning Ref Cursor'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(194246309705806257)
,p_name=>'FUNC_BODY_RETURNING_BOOLEAN	'
,p_message_text=>'PL/SQL Function body returning boolean'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(25596327398451371)
,p_name=>'FUNC_RET_BOOLEAN'
,p_message_text=>'PL/SQL Function Returning Boolean'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(191640729315289585)
,p_name=>'FUTURE_MILESTONES'
,p_message_text=>'Future milestones'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(677442406557096297)
,p_name=>'GANTT_BASELINEDATE'
,p_message_text=>'Baseline Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(677442220803094736)
,p_name=>'GANTT_BASELINEEND'
,p_message_text=>'Baseline End'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(677442031727093092)
,p_name=>'GANTT_BASELINESTART'
,p_message_text=>'Baseline Start'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(194105111354775484)
,p_name=>'GANTT_CHART.END_DATE'
,p_message_text=>'End Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(194103009837765603)
,p_name=>'GANTT_CHART.START_DATE'
,p_message_text=>'Start Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(439398906545969347)
,p_name=>'GANTT_CHART.TASK'
,p_message_text=>'Task'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(677441487888089338)
,p_name=>'GANTT_DATE'
,p_message_text=>'Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(677441275596086495)
,p_name=>'GANTT_END'
,p_message_text=>'End'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(677441625319090139)
,p_name=>'GANTT_LABEL'
,p_message_text=>'Label'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(677441824522091096)
,p_name=>'GANTT_PROGRESS'
,p_message_text=>'Progress'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(677440741570084354)
,p_name=>'GANTT_ROW'
,p_message_text=>'Row'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(677440941235085379)
,p_name=>'GANTT_START'
,p_message_text=>'Start'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(556062580523572273)
,p_name=>'GATHER_TABLE_STATS'
,p_message_text=>'Gather Table Statistics'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(172901823792775202)
,p_name=>'GENERAL_COMMENT'
,p_message_text=>'General Comment'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(496734709818208693)
,p_name=>'GENERAL_COMMENT_DASH'
,p_message_text=>'General Comments: %1 of %0 closed'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26824806027207686)
,p_name=>'GENERATED_TABLE'
,p_message_text=>'This table was created using the table wizard.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(177245309457396800)
,p_name=>'GET_STATIC_LOV'
,p_message_text=>'Create or edit static List of Values'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184000930254625811)
,p_name=>'GLOBALIZATION_ASSIGNEE'
,p_message_text=>'Globalization Assignee'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(183994324667595831)
,p_name=>'GLOBALIZATION_IMPACT'
,p_message_text=>'Globalization Impact'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(184004307314638146)
,p_name=>'GLOBALIZATION_STATUS'
,p_message_text=>'Globalization Status'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(5825203972474852)
,p_name=>'GLOBAL_PAGE'
,p_message_text=>'Global Page'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(115167131621746086)
,p_name=>'GO'
,p_message_text=>'Go'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(211007614705724106)
,p_name=>'GRAY_TEXT'
,p_message_text=>'Gray Text'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(187805525089702071)
,p_name=>'GRID_DEBUG_OFF'
,p_message_text=>'Hide Layout Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(187804521972701110)
,p_name=>'GRID_DEBUG_ON'
,p_message_text=>'Show Layout Columns'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(40285632067856520)
,p_name=>'GRID_TEMPLATE'
,p_message_text=>'Grid Template'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(163584817412391536)
,p_name=>'GROUPS'
,p_message_text=>'Groups'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(333692300401908936)
,p_name=>'GROUP_LABEL'
,p_message_text=>'Group: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108524009787737497)
,p_name=>'HEADER'
,p_message_text=>'Header Text'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(333300231260870499)
,p_name=>'HEADING_LABEL'
,p_message_text=>'Heading: %0'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1015317514152959207)
,p_name=>'HELP'
,p_message_text=>'Help'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(955848469602909019)
,p_name=>'HELP_TEMPLATE'
,p_message_text=>'Help Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88140020874806833)
,p_name=>'HELP_TEXT'
,p_message_text=>'help text'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(114861606711916090)
,p_name=>'HIDDEN_AND_PROTECTED'
,p_message_text=>'Hidden and Protected'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(173505325783539251)
,p_name=>'HIGHLY_DESIRABLE'
,p_message_text=>'Highly desirable'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(712641721359637072)
,p_name=>'HIGH_CONTRAST'
,p_message_text=>'High Contrast'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(533547531238289090)
,p_name=>'HIGH_CONTRAST_TOGGLE'
,p_message_text=>'High Contrast Toggle'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(163583810139389489)
,p_name=>'HISTORY'
,p_message_text=>'History'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4660510092225697)
,p_name=>'HOME'
,p_message_text=>'Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(201797807031666802)
,p_name=>'HOME_LINK'
,p_message_text=>'Home Link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(4685131422496765)
,p_name=>'HOME_NAV'
,p_message_text=>'Oracle APEX Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(22961825480170112)
,p_name=>'HOME_PAGE_USERS'
,p_message_text=>'Users:'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(101039603448269690)
,p_name=>'HORIZONTAL'
,p_message_text=>'horizontal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1815014715326252)
,p_name=>'HORIZONTAL2DCOLUMN'
,p_message_text=>'Horizontal 2D Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1815100562326252)
,p_name=>'HORIZONTAL3DCOLUMN'
,p_message_text=>'Horizontal 3D Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1815232025326252)
,p_name=>'HORIZONTALRANGE2DCOLUMN'
,p_message_text=>'Horizontal Range 2D Column'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1815317988326252)
,p_name=>'HORIZONTALRANGE3DCOLUMN'
,p_message_text=>'Horizontal Range 3D Column'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(946331723042693021)
,p_name=>'HOT_TEMPLATE'
,p_message_text=>'Hot Template'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87997925051208938)
,p_name=>'HOUR'
,p_message_text=>'hour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(87998329206210072)
,p_name=>'HOURS'
,p_message_text=>'hours'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(20387325317948551)
,p_name=>'HR_ACCOUNT_UNLOCKED'
,p_message_text=>'HR account unlocked.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88170724842044532)
,p_name=>'HTML'
,p_message_text=>'HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(93580118576507001)
,p_name=>'HTMLWITHSHORTCUTS'
,p_message_text=>'HTML with Shortcuts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(92482917543552046)
,p_name=>'HTML_BODY'
,p_message_text=>'HTML Body'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(26503403314893043)
,p_name=>'HTML_BUTTON'
,p_message_text=>'HTML Button'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(32272117814837371)
,p_name=>'HTML_CHART'
,p_message_text=>'HTML Chart'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(108528620878816332)
,p_name=>'HTML_HEADER'
,p_message_text=>'HTML Header'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(32273732144850984)
,p_name=>'HTML_SLASH_TEXT'
,p_message_text=>'HTML/Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88138621997788233)
,p_name=>'HTML_TEXT'
,p_message_text=>'HTML Text'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(32281719031875559)
,p_name=>'HTML_TEXT_WITH_SHORTCUTS'
,p_message_text=>'HTML Text with shortcuts'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(36685910742707444)
,p_name=>'ICON'
,p_message_text=>'Icon %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(955812439808160524)
,p_name=>'ICON_CSS_CLASSES'
,p_message_text=>'Icon CSS Classes'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(631587323575452741)
,p_name=>'IE6_COMPATIBLE'
,p_message_text=>'Indicates theme is IE 6 compatible'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(242848040662032447)
,p_name=>'IG_ALLOW_EDITING'
,p_message_text=>'Allow Editing'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(242849375082044723)
,p_name=>'IG_READ_ONLY'
,p_message_text=>'Read Only'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88171504111066905)
,p_name=>'IMAGE'
,p_message_text=>'image'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(455022723065970877)
,p_name=>'IMAGES'
,p_message_text=>'Images'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(86863605081757188)
,p_name=>'IMAGE_ATTRIBUTES'
,p_message_text=>'Image Attributes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(201791628427417589)
,p_name=>'IMAGE_PREFIX'
,p_message_text=>'Image Prefix'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(171265523549112036)
,p_name=>'IMPORT FROM APPLICATION'
,p_message_text=>'Import from application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1289208578817461225)
,p_name=>'IMPORT_APP_NEW_SUBSTRING'
,p_message_text=>'New Value for Substitution String %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(379115324171942682)
,p_name=>'IMPORT_APP_SUCCESS_MSG'
,p_message_text=>'Your imported file is located in the <a href="%0">Export Repository</a>.  Unless you plan to install it again, you should remove it.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(145339904866119459)
,p_name=>'IN/OUT'
,p_message_text=>'In/Out'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(8804725089048621)
,p_name=>'INACTIVE'
,p_message_text=>'Inactive'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(272958517362957576)
,p_name=>'INCLUDE'
,p_message_text=>'Include'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(1036299821363843933)
,p_name=>'INCLUDE_LABEL'
,p_message_text=>'Include: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88049007435582316)
,p_name=>'INDEX'
,p_message_text=>'index'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(270308402287577214)
,p_name=>'INDEX_NOUN'
,p_message_text=>'Index'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(65392128733576156)
,p_name=>'INITCAP_REFRESH'
,p_message_text=>'Refresh'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(123651810855835370)
,p_name=>'INLINE'
,p_message_text=>'Inline'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(659796271089373997)
,p_name=>'INLINE_HELP_TEMPLATE'
,p_message_text=>'Inline Help Template'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(123651306700834167)
,p_name=>'INLINE_NOTIFICATION'
,p_message_text=>'Inline and in Notification'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(194225331710576145)
,p_name=>'INPUT_TYPE'
,p_message_text=>'Input Type'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(88055813678659792)
,p_name=>'INSERT'
,p_message_text=>'insert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(290113018532571365)
,p_name=>'INSERT_EXCEPTION'
,p_message_text=>'insert into wwv_flow_companies exception:'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(213906322982468604)
,p_name=>'INSTALLER.APPLICATION_CSS'
,p_message_text=>'CSS (Application)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(213905506706463998)
,p_name=>'INSTALLER.APPLICATION_IMAGE'
,p_message_text=>'Image (Application)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(213907407529473623)
,p_name=>'INSTALLER.APPLICATION_STATIC'
,p_message_text=>'Static File (Application)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19138931693035629)
,p_name=>'INSTALLER.BUILD_OPTIONS'
,p_message_text=>'Build Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39814211838750490)
,p_name=>'INSTALLER.BUILD_OPTIONS_MESSAGE'
,p_message_text=>'You can choose to include the following build options.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19138426498034185)
,p_name=>'INSTALLER.CONFIGURATION'
,p_message_text=>'Application Substitutions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39809119326743151)
,p_name=>'INSTALLER.CONFIGURATION_MESSAGE'
,p_message_text=>'You can configure the following attributes of your application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19140908621038448)
,p_name=>'INSTALLER.CONFIRMATION'
,p_message_text=>'Install Confirmation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39817825129763771)
,p_name=>'INSTALLER.CONFIRMATION_MESSAGE'
,p_message_text=>'Please confirm that you would like to install this application''s supporting objects.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19145418103050626)
,p_name=>'INSTALLER.CONFIRM_DEINSTALL'
,p_message_text=>'Deinstall Confirmation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(9745431570194925)
,p_name=>'INSTALLER.DEINSTALL'
,p_message_text=>'Deinstall Script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19146124336052424)
,p_name=>'INSTALLER.DEINSTALL_SUCCESS'
,p_message_text=>'Deinstall Success'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39821608422777847)
,p_name=>'INSTALLER.DEINSTALL_SUCCESS_MESSAGE'
,p_message_text=>'Deinstallation complete.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139327225008143048)
,p_name=>'INSTALLER.ERROR.IN_CHECK'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Error when performing install check "%0":',
'<pre>%1</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(139327418310161349)
,p_name=>'INSTALLER.ERROR.IN_SCRIPT'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Error when running install script "%0":',
'<pre>%1</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19137918533031875)
,p_name=>'INSTALLER.EXISTENCE'
,p_message_text=>'Existence Check Failure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19142219703041632)
,p_name=>'INSTALLER.FAILURE'
,p_message_text=>'Post Install Failure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39820328723774297)
,p_name=>'INSTALLER.FAILURE_MESSAGE'
,p_message_text=>'Installation of database objects and seed data has failed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(164982584877642830)
,p_name=>'INSTALLER.INSTALL_FAILURE_MESSAGE'
,p_message_text=>'The application installer has detected that this application''s supporting objects were previously installed. The objects must be removed via SQL Workshop before this application can be installed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19144411869048877)
,p_name=>'INSTALLER.LICENSE'
,p_message_text=>'License'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(16173009195286580)
,p_name=>'INSTALLER.SCRIPT.FAIL'
,p_message_text=>'Errors'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(16172528111282569)
,p_name=>'INSTALLER.SCRIPT.SUCCESS'
,p_message_text=>'Success'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(19141413816039978)
,p_name=>'INSTALLER.SUCCESS'
,p_message_text=>'Post Install Success'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(39818911062769191)
,p_name=>'INSTALLER.SUCCESS_MESSAGE'
,p_message_text=>'Your application''s supporting objects have been installed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(58033415386456711)
,p_name=>'INSTALLER.UPGRADE_CONFIRM_MESSAGE'
,p_message_text=>'Please confirm that you would like to upgrade this application''s supporting objects.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(58031908460454743)
,p_name=>'INSTALLER.UPGRADE_FAILURE_MESSAGE'
,p_message_text=>'The upgrade of this application''s supporting objects has failed.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(57756131411818027)
,p_name=>'INSTALLER.UPGRADE_MESSAGE'
,p_message_text=>'The application installer has detected that this application''s supporting objects were previously installed.  This wizard will guide you through the process of upgrading these supporting objects.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(58028724952450028)
,p_name=>'INSTALLER.UPGRADE_SUCCESS_MESSAGE'
,p_message_text=>'Your application''s supporting obj