prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4413
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4413 - Oracle APEX  System Messages and Native Types
--
-- Application Export:
--   Application:     4413
--   Name:            Oracle APEX  System Messages and Native Types
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             124
--       Globalization:
--         Messages:          14,593
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX  System Messages and Native Types')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286625630742927058')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135328'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'fr'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(91645213681389498.4413)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141228'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562090986404402217.4413)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48650898565635010.4413)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('D\00E9connexion')
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>unistr('Se d\00E9connecter d''Application Express')
,p_list_text_09=>'O'
,p_list_text_10=>'logout exit quit :q'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(281916990329150760.4413)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Cr\00E9er une application sur une feuille de calcul')
,p_list_item_link_target=>'f?p=4000:447:&APP_SESSION.::NO:448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT::'
,p_list_text_01=>unistr('Importez vos fichiers Excel ou CSV et cr\00E9ez une application')
,p_list_text_09=>'O'
,p_list_text_10=>'excel csv xsl xslx spreadsheet data paste load import'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(282255839842182292.4413)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Page d''accueil Oracle APEX'
,p_list_item_link_target=>'f?p=4500:1000:&APP_SESSION.'
,p_list_text_10=>unistr('page d''accueil d\00E9marrer ')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(296033420364984683.4413)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Parcourir les ic\00F4nes Police APEX')
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>unistr('Parcourez les ic\00F4nes Police APEX, ajoutez des modificateurs et copiez le code CSS ou HTML dont vous avez besoin.')
,p_list_text_09=>'O'
,p_list_text_10=>unistr('Graphiques de la biblioth\00E8que d''ic\00F4nes Police APEX')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562091518091404815.4413)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562091727563404815.4413)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Exporter une application'
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>'Exporter l''application {APP_ID} sous forme de fichier SQL'
,p_list_text_09=>'O'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562093357853428158.4413)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Listes inutilis\00E9es')
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562092153904409717.4413)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48392393581618193.4413)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Journal de console'
,p_list_item_link_target=>'javascript:console.log(''hello friend'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14843831009863117.4413)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859012524941040.4413)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(86380554411225400.4413)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91997339122572414.4413)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(460407779408652225.4413)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(497671453666914719.4413)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attribute_01=>'fa-star'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082458703597614427.4413)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082517678315623391.4413)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072678475712055.4413)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831649180083980462.4413)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780276458994154.4413)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1832884277947217587.4413)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1840861033969283097.4413)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917665913120940054.4413)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1990227023531717243.4413)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626406749381989.4413)
,p_theme_id=>1
,p_name=>'One Level Tabs.fr'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE# ',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626529080381989.4413)
,p_theme_id=>1
,p_name=>'Printer Friendly.fr'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(91626823864381990.4413)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(91632832228382001.4413)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(91636711305382010.4413)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(91638400927382012.4413)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(91638400927382012.4413)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(91641225667382016.4413)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641730492382017.4413)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641814330382017.4413)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(91642503902382024.4413)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>'Dialogue de recherche'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Rechercher'
,p_close_button_text=>'Fermer'
,p_next_button_text=>'Suivant >'
,p_prev_button_text=>unistr('< Pr\00E9c\00E9dent')
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Ligne(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91641910982382018.4413)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642102481382020.4413)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642303533382020.4413)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276335444413866655)
,p_name=>'2DCOLUMN'
,p_message_language=>'fr'
,p_message_text=>'A colonnes 2D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276337773379866657)
,p_name=>'2DCOLUMN_LINE'
,p_message_language=>'fr'
,p_message_text=>'A courbes de colonnes 2D'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276335648463866655)
,p_name=>'2DDOUGHNUT'
,p_message_language=>'fr'
,p_message_text=>'En anneau 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276337529188866656)
,p_name=>'2DHSTACKED_PCT'
,p_message_language=>'fr'
,p_message_text=>unistr('A colonnes 2D, horizontales, empil\00E9es (%)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276335759933866655)
,p_name=>'2DLINE'
,p_message_language=>'fr'
,p_message_text=>'A courbes 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276335849862866655)
,p_name=>'2DPIE'
,p_message_language=>'fr'
,p_message_text=>'A secteurs 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276337344617866656)
,p_name=>'2DSTACKED_PCT'
,p_message_language=>'fr'
,p_message_text=>unistr('A colonnes 2D, empil\00E9es (%)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276335988220866655)
,p_name=>'3DCOLUMN'
,p_message_language=>'fr'
,p_message_text=>'A colonnes 3D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276337676498866657)
,p_name=>'3DHSTACKED_PCT'
,p_message_language=>'fr'
,p_message_text=>unistr('A colonnes 3D, horizontales, empil\00E9es (%)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276336067186866656)
,p_name=>'3DPIE'
,p_message_language=>'fr'
,p_message_text=>'A secteurs 3D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276337484288866656)
,p_name=>'3DSTACKED_PCT'
,p_message_language=>'fr'
,p_message_text=>unistr('A colonnes 3D, empil\00E9es (%)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277233370155867235)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'fr'
,p_message_text=>unistr('0 \00E9l\00E9ment pour l''insertion dans le dictionnaire d''attributs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277233189520867235)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_language=>'fr'
,p_message_text=>unistr('0 \00E9l\00E9ment pour la mise \00E0 jour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277233547430867236)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'fr'
,p_message_text=>unistr('0 \00E9l\00E9ment pour la mise \00E0 jour du dictionnaire d''attributs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277233905010867236)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'fr'
,p_message_text=>unistr('0 colonne d''\00E9tat pour l''insertion dans le dictionnaire d''attributs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277234162847867236)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'fr'
,p_message_text=>unistr('0 colonne d''\00E9tat pour la mise \00E0 jour du dictionnaire d''attributs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277233097553867235)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_language=>'fr'
,p_message_text=>unistr('V\00E9rifier %0 \00E9l\00E9ments pour la mise \00E0 jour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277233775590867236)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_language=>'fr'
,p_message_text=>unistr('0 colonne d''\00E9tat pour la mise \00E0 jour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277233287390867235)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'fr'
,p_message_text=>unistr('V\00E9rifier %0 \00E9l\00E9ments pour l''insertion dans le dictionnaire d''attributs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277233446739867236)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'fr'
,p_message_text=>unistr('V\00E9rifier %0 \00E9l\00E9ments pour la mise \00E0 jour du dictionnaire d''attributs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277233885266867236)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'fr'
,p_message_text=>unistr('V\00E9rifier %0 colonnes d''\00E9tat pour l''insertion dans le dictionnaire d''attributs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277233679173867236)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_language=>'fr'
,p_message_text=>unistr('V\00E9rifier %0 colonnes d''\00E9tat pour la mise \00E0 jour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277234036659867236)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'fr'
,p_message_text=>unistr('V\00E9rifier %0 colonnes d''\00E9tat pour la mise \00E0 jour du dictionnaire d''attributs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276923839333867034)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur doit \00EAtre num\00E9rique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276908385893867024)
,p_name=>'4000_639_SEQ_MESG'
,p_message_language=>'fr'
,p_message_text=>unistr('<span class="fielddata"> Impossible de r\00E9organiser car les s\00E9quences de r\00E9gions ne sont pas uniques.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276908499593867024)
,p_name=>'4000_641_SEQ_MESG'
,p_message_language=>'fr'
,p_message_text=>unistr('<span class="fielddata">Impossible de r\00E9organiser car les s\00E9quences de boutons ne sont pas uniques.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276908527042867024)
,p_name=>'4000_646_SEQ_MESG'
,p_message_language=>'fr'
,p_message_text=>unistr('<span class="fielddata">Impossible de r\00E9organiser car les s\00E9quences de barres de navigation ne sont pas uniques.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276908697749867024)
,p_name=>'4000_749_SEQ_MESG'
,p_message_language=>'fr'
,p_message_text=>unistr('<span class="fielddata"> Impossible de r\00E9organiser car les s\00E9quences d''\00E9l\00E9ments de r\00E9gion ne sont pas uniques.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276988230524867075)
,p_name=>'4000_APPLICATION_ID'
,p_message_language=>'fr'
,p_message_text=>'ID d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276479951736866749)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Modifier l''application : %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276879960296867006)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_language=>'fr'
,p_message_text=>unistr('Le format de date indiqu\00E9 n''est pas valide. Le calendrier requiert une date au format YYYYMMDD.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276929073530867037)
,p_name=>'4000_TREE'
,p_message_language=>'fr'
,p_message_text=>'Arborescence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276988374420867075)
,p_name=>'4000_WORKSPACE_ID'
,p_message_language=>'fr'
,p_message_text=>'ID d''espace de travail'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276761069770866930)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Saisissez le nom du sch\00E9ma \00E0 cr\00E9er. Choisissez'),
unistr('         un mot de passe pour ce sch\00E9ma et s\00E9lectionnez les tablespaces par d\00E9faut'),
'         et temporaire.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276761181693866930)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_language=>'fr'
,p_message_text=>unistr('Saisissez le nom d''un sch\00E9ma existant.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276761256883866930)
,p_name=>'4050_106_WHEN_DONE'
,p_message_language=>'fr'
,p_message_text=>unistr('Lorsque vous avez termin\00E9, cliquez sur le bouton "Suivant &gt;"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276654284000866862)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_language=>'fr'
,p_message_text=>unistr('Supprimer les tablespaces et les fichiers de donn\00E9es associ\00E9s : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276654175277866862)
,p_name=>'4050_110_DROP_USERS'
,p_message_language=>'fr'
,p_message_text=>unistr('Supprimer les utilisateurs de base de donn\00E9es : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277566896118867451)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es du journal des activit\00E9s de service Web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276754403412866926)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es du journal des activit\00E9s de d\00E9veloppeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276373023325866678)
,p_name=>'4050_31_LOG_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es du journal de connexions \00E0 Access')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276753949662866926)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_language=>'fr'
,p_message_text=>'Demandes de modification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276754011047866926)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_language=>'fr'
,p_message_text=>'Demandes runtime'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276753769718866925)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_language=>'fr'
,p_message_text=>'Demandes d''espace de travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276756452053866927)
,p_name=>'4050_46_AD_HOC'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es de l''historique du processeur de commandes SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276756334867866927)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es du journal d''ex\00E9cution du fichier de contr\00F4le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276756288586866927)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es de journal d''ex\00E9cution de fichier de script')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276756596980866927)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es des archives SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276758521610866928)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_language=>'fr'
,p_message_text=>'Informations sur le fichier journal actif'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276758657896866928)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_language=>'fr'
,p_message_text=>unistr('Num\00E9ro de journal en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276758719838866929)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_language=>'fr'
,p_message_text=>'Horodatage de journal en cours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276759309913866929)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_language=>'fr'
,p_message_text=>'Heures jusqu''au prochain changement de fichier de journalisation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276758956188866929)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_language=>'fr'
,p_message_text=>'Intervalle en jours (constante)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276759214646866929)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_language=>'fr'
,p_message_text=>unistr('Prochain changement de fichier de journalisation pr\00E9vu pour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276759657837866929)
,p_name=>'4050_70_DEV_ACT'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es du journal des activit\00E9s de d\00E9veloppeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276759806187866929)
,p_name=>'4050_71_CLICK'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es du journal des clics')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276760673789866930)
,p_name=>'4050_75_AD_HOC'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es de l''historique du processeur de commandes SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276760538387866930)
,p_name=>'4050_75_CTRL_FILE'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es du journal d''ex\00E9cution du fichier de contr\00F4le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276760375201866930)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es de journal d''ex\00E9cution de fichier de script')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276760786250866930)
,p_name=>'4050_75_SQL_ARCH'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es des archives SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276760868254866930)
,p_name=>'4050_82_WORKSPACE'
,p_message_language=>'fr'
,p_message_text=>'L''espace de travail %1 contient %2 applications et %3 utilisateurs.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276760936882866930)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es du journal des clics')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276959010638867056)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Applications \00E9chantillon et de productivit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276959139072867056)
,p_name=>'4050_PACKAGED_WEBSHEETS'
,p_message_language=>'fr'
,p_message_text=>unistr('Feuilles Web \00E9chantillon')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276958303561867056)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_language=>'fr'
,p_message_text=>'Nombre d''espaces de travail'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276498645306866761)
,p_name=>'4150_COLUMN_NUMBER'
,p_message_language=>'fr'
,p_message_text=>'Colonne %0'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276682336478866880)
,p_name=>'4350_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276682472275866880)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Modifier l''application'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276388149016866687)
,p_name=>'4500 800 HD DBA'
,p_message_language=>'fr'
,p_message_text=>'Oracle Database Express Edition 2 Day DBA.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276388258649866687)
,p_name=>'4500 800 HD DEV'
,p_message_language=>'fr'
,p_message_text=>'Oracle Database Express Edition 2 Day Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276388058403866687)
,p_name=>'4500 800 HD HTMLDB'
,p_message_language=>'fr'
,p_message_text=>'Oracle Application Express 2 Day Plus Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276388321494866687)
,p_name=>'4500 800 HD JAVA'
,p_message_language=>'fr'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus Java Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276388444566866687)
,p_name=>'4500 800 HD NET'
,p_message_language=>'fr'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus .NET Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276388511612866687)
,p_name=>'4500 800 HD PHP'
,p_message_language=>'fr'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus PHP Developer.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276388605061866687)
,p_name=>'4500 800 MSG DBA'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce document traite des t\00E2ches d''administration courantes au jour le jour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276388702770866687)
,p_name=>'4500 800 MSG DEV'
,p_message_language=>'fr'
,p_message_text=>'Ce document explique comment tirer parti de l''environnement Oracle Database Express Edition.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276388845079866688)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce document fournit une s\00E9rie de tutoriels qui d\00E9crivent comment construire des applications Web centr\00E9es sur une base de donn\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276389010176866688)
,p_name=>'4500 800 MSG JAVA'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce document fournit un tutoriel qui vous explique comment utiliser Java et JDBC pour vous connecter \00E0 Oracle Database XE et comment d\00E9velopper une application Java simple qui acc\00E8de aux donn\00E9es et les modifie.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276389150570866688)
,p_name=>'4500 800 MSG NET'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce document d\00E9crit les fonctionnalit\00E9s-cl\00E9s d''Oracle Data Provider for .NET et d''Oracle Developer Tools for Visual Studio .NET. Il traite de l''installation et de la configuration, vous explique comment construire des applications de base au moyen d''O')
||unistr('racle Data Provider for .NET et d''Oracle Developer Tools for Visual Studio .NET et comment cr\00E9er et utiliser les proc\00E9dures stock\00E9es PL/SQL et .NET.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276388908366866688)
,p_name=>'4500 800 MSG PHP'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce document fournit un tutoriel qui vous explique comment t\00E9l\00E9charger et installer Apache et les pilotes Zend Core PHP et comment utiliser PHP pour vous connecter \00E0 Oracle Database XE puis pour d\00E9velopper une application simple qui acc\00E8de aux donn\00E9es')
||' et les modifie.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276358883057866669)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_language=>'fr'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276358780644866669)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276359084182866670)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_language=>'fr'
,p_message_text=>'Condition'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276817715058866966)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_language=>'fr'
,p_message_text=>'Supprimer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276359410214866670)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_language=>'fr'
,p_message_text=>'Fonction'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276359566112866670)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_language=>'fr'
,p_message_text=>'Grouper par'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276358946263866669)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_language=>'fr'
,p_message_text=>'Objet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276359381431866670)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_language=>'fr'
,p_message_text=>'Afficher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276359134353866670)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_language=>'fr'
,p_message_text=>'Type de tri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276359244601866670)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_language=>'fr'
,p_message_text=>'Ordre de tri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276362603386866672)
,p_name=>'4500_1002_QB_JOIN'
,p_message_language=>'fr'
,p_message_text=>'Jointure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276356176624866668)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_language=>'fr'
,p_message_text=>unistr('Cliquez ici pour s\00E9lectionner une colonne pour la jointure.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276363012484866672)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_language=>'fr'
,p_message_text=>unistr('Un maximum de 60 colonnes peut \00EAtre s\00E9lectionn\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276356037190866668)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_language=>'fr'
,p_message_text=>'Enlever'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276355991407866668)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_language=>'fr'
,p_message_text=>'Afficher/Masquer les colonnes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276362711713866672)
,p_name=>'4500_1002_QB_TO'
,p_message_language=>'fr'
,p_message_text=>'vers'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276354355756866667)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9sultats de %0, ex\00E9cution %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276654453873866862)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Retour \00E0 la requ\00EAte initiale')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276370352720866676)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_language=>'fr'
,p_message_text=>unistr('Les %0 premi\00E8res colonnes sont affich\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276847442473866985)
,p_name=>'4500_SESS_EVENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Ev\00E9nement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276847336319866985)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_language=>'fr'
,p_message_text=>'kilo-octets'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276847299095866985)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9ga-octets')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276392062238866690)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('App Builder utilise les valeurs par d\00E9faut de l''interface utilisateur pour remplir les valeurs initiales des propri\00E9t\00E9s de r\00E9gion et d''\00E9l\00E9ment, ce qui assure une coh\00E9rence entre les pages dans une ou plusieurs applications.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276436478740866720)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_language=>'fr'
,p_message_text=>'Cette application requiert l''activation des cookies.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276436382055866719)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_language=>'fr'
,p_message_text=>'Cette application requiert l''activation de JavaScript.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276628040002866845)
,p_name=>'4800_9015_UPDATE_OVERDUE_FEATURES'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 fonctionnalit\00E9s en retard seront mises \00E0 jour vers le nouveau jalon s\00E9lectionn\00E9.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276878265134867005)
,p_name=>'ABOUT'
,p_message_language=>'fr'
,p_message_text=>'A propos de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277639071030867498)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_language=>'fr'
,p_message_text=>unistr('Confirmez l''ajout des %0 utilisateurs suivants \00E0 l''espace de travail.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276890667067867013)
,p_name=>'ACCEPTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Accept\00E9')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276857069470866991)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_language=>'fr'
,p_message_text=>unistr('Destinataire de l''accessibilit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276855168354866990)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_language=>'fr'
,p_message_text=>unistr('Impact de l''accessibilit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276857555203866991)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_language=>'fr'
,p_message_text=>unistr('Statut d''accessibilit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277718155338867549)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Accessibilit\00E9 test\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276369161055866676)
,p_name=>'ACCESS_CONTROL_ADMIN'
,p_message_language=>'fr'
,p_message_text=>'Administrateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276528558084866781)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_language=>'fr'
,p_message_text=>'Droits d''administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276367663392866675)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Page d''administration de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276806290986866959)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_language=>'fr'
,p_message_text=>'Administrateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276917361109867030)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00F4le affect\00E9 aux administrateurs d''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276367833912866675)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_language=>'fr'
,p_message_text=>'Administration des applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276368432633866675)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_language=>'fr'
,p_message_text=>'Mode d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276368325437866675)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Identifiez le mode de contr\00F4le d''acc\00E8s \00E0 cette application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276369614052866676)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de traiter la demande de d\00E9finition du mode d''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276369740056866676)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Mode d''application d\00E9fini.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276529478300866782)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_language=>'fr'
,p_message_text=>'Vous ne pouvez pas vous supprimer.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276529507789866782)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous ne pouvez pas vous enlever le privil\00E8ge d''administration.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276367795767866675)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er une table')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276806129957866959)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_language=>'fr'
,p_message_text=>'Droits de contribution'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276806360409866959)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_language=>'fr'
,p_message_text=>'Contributeur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276917484730867030)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00F4le affect\00E9 aux contributeurs d''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276849809309866987)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Les param\00E8tres d''application suivants seront cr\00E9\00E9s :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276806454583866959)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Les r\00F4les d''acc\00E8s aux applications suivants seront cr\00E9\00E9s :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276385215898866685)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Les mod\00E8les d''autorisation suivants seront cr\00E9\00E9s :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276458908115866735)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de cr\00E9er la page de contr\00F4le d''acc\00E8s. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276458891934866735)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de cr\00E9er les tables de contr\00F4le d''acc\00E8s. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276532014917866783)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_language=>'fr'
,p_message_text=>'Vous ne pouvez saisir un nom utilisateur en double.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276528611619866781)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_language=>'fr'
,p_message_text=>unistr('contr\00F4le d''acc\00E8s - modification')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276369327959866676)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Saisissez des crit\00E8res de requ\00EAte sans distinction entre les majuscules et les minuscules, puis cliquez sur <b>OK</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276369411414866676)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Impossible d''obtenir le mode d''administration de l''application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276369255844866676)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_language=>'fr'
,p_message_text=>unistr('Derni\00E8re modification par')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276368772313866675)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_language=>'fr'
,p_message_text=>unistr('Liste de contr\00F4le d''acc\00E8s (ACL)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276367963293866675)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E8s complet \00E0 tous ; liste de contr\00F4le d''acc\00E8s non utilis\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276368098454866675)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E8s restreint. Seuls les utilisateurs d\00E9finis dans la liste de contr\00F4le d''acc\00E8s sont autoris\00E9s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276368159976866675)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E8s public en lecture seule. Privil\00E8ges de modification et d''administration contr\00F4l\00E9s par la liste de contr\00F4le d''acc\00E8s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276368277328866675)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E8s administratif uniquement.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276369598967866676)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous n''\00EAtes pas autoris\00E9 \00E0 effectuer cette op\00E9ration.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276369035246866676)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_language=>'fr'
,p_message_text=>unistr('Privil\00E8ge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276849730816866987)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_language=>'fr'
,p_message_text=>'Droits de lecteur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276849683120866987)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_language=>'fr'
,p_message_text=>'Lecteur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276917537242867030)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00F4le affect\00E9 aux lecteurs d''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276386034953866686)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_language=>'fr'
,p_message_text=>unistr('Identifiez les noms utilisateur correspondant \00E0 ce mod\00E8le d''authentification de l''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276368509815866675)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir le mode d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276487027181866754)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('La cr\00E9ation des pages de contr\00F4le d''acc\00E8s a r\00E9ussi.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276368954891866676)
,p_name=>'ACCESS_CONTROL_USERNAME'
,p_message_language=>'fr'
,p_message_text=>'Nom utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276806580124866959)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Utiliser un r\00F4le de contr\00F4le d''acc\00E8s existant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276385904859866686)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Utiliser un mod\00E8le d''autorisation existant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276385187011866685)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_language=>'fr'
,p_message_text=>'Utiliser une table existante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276528745399866781)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_language=>'fr'
,p_message_text=>unistr('contr\00F4le d''acc\00E8s - vue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276818463356866966)
,p_name=>'ACCESS_DENIED_SIMPLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E8s refus\00E9')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276389431599866688)
,p_name=>'ACCOUNT_CREATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Compte cr\00E9\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276512376432866770)
,p_name=>'ACCOUNT_HAS_BEEN_CREATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre compte %0 a \00E9t\00E9 cr\00E9\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276386857833866686)
,p_name=>'ACCOUNT_LOCKED'
,p_message_language=>'fr'
,p_message_text=>unistr('Compte verrouill\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277179418096867201)
,p_name=>'ACCOUNT_MENU'
,p_message_language=>'fr'
,p_message_text=>'Menu de compte'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276836958220866978)
,p_name=>'ACKNOWLEDGED'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9ception confirm\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276837181957866979)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9ception confirm\00E9e, aucune action')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276901009520867019)
,p_name=>'ACL_ADD_USER'
,p_message_language=>'fr'
,p_message_text=>'Ajouter un utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277569638350867453)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9der au tableau de bord')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277569771667867453)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9der \00E0 la surveillance de l''activit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277568883271867453)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_language=>'fr'
,p_message_text=>'Ajouter/Modifier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277569597473867453)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_language=>'fr'
,p_message_text=>unistr('Administration lors de l''ex\00E9cution de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277568067927867452)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_language=>'fr'
,p_message_text=>'Administration depuis App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277568728144867452)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_language=>'fr'
,p_message_text=>'Annotations (fichiers, balises, remarques)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277567798185867452)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_language=>'fr'
,p_message_text=>unistr('Authentification du compte Application Express sans liste de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277567665110867452)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_language=>'fr'
,p_message_text=>unistr('Authentification avec liste de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277568498164867452)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier l''acc\00E8s SQL et les objets sugg\00E9r\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277572745955867455)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Une fois l''authentification aupr\00E8s d''une application effectu\00E9e, le contr\00F4le d''acc\00E8s indique les op\00E9rations que les utilisateurs sont autoris\00E9s \00E0 effectuer dans l''application. La table ci-dessous identifie les diff\00E9rents droits accord\00E9s aux utilisateu')
||unistr('rs en fonction de l''authentification utilis\00E9e dans cette application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277569867508867453)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_language=>'fr'
,p_message_text=>unistr('G\00E9rer la liste de contr\00F4le d''acc\00E8s (ACL)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277568539419867452)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Ex\00E9cuter et visualiser')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277568263168867452)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre \00E0 jour les propri\00E9t\00E9s d''application')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277227948578867232)
,p_name=>'ACTIONS'
,p_message_language=>'fr'
,p_message_text=>'Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277567120908867451)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres du menu Actions')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276400539399866695)
,p_name=>'ACTIVE'
,p_message_language=>'fr'
,p_message_text=>'Actif'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276814019226866964)
,p_name=>'ACTIVITY'
,p_message_language=>'fr'
,p_message_text=>unistr('Activit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276858576979866992)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('R\00E9capitulatif de l''activit\00E9'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277094029217867145)
,p_name=>'ADDED_BY'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajout\00E9 par')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277564678648867450)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajout\00E9 \00E0 la liste des \00E9l\00E9ments \00E0 purger')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277213645331867223)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Informations suppl\00E9mentaires demand\00E9es')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276768278740866935)
,p_name=>'ADD_ARGUEMENT'
,p_message_language=>'fr'
,p_message_text=>'Ajouter un argument'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276758398048866928)
,p_name=>'ADD_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une colonne :'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276974528224867066)
,p_name=>'ADD_COLUMN_NAME'
,p_message_language=>'fr'
,p_message_text=>'Ajouter la colonne %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276616342434866838)
,p_name=>'ADD_CONSTRAINT'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une contrainte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276756192383866927)
,p_name=>'ADD_MORE...'
,p_message_language=>'fr'
,p_message_text=>'Ajouter d''autres...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276828977294866973)
,p_name=>'ADD_ROW'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276982001519867071)
,p_name=>'ADD_USER_INTERFACE'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une interface utilisateur'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276985669709867073)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajuster l''espace provisionn\00E9 de %0 Mo')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276754671003866926)
,p_name=>'ADMIN'
,p_message_language=>'fr'
,p_message_text=>'Admin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276380816777866683)
,p_name=>'ADMINISTRATOR'
,p_message_language=>'fr'
,p_message_text=>'Administrateur d''espace de travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276858386618866992)
,p_name=>'ADMINISTRATORS'
,p_message_language=>'fr'
,p_message_text=>'Administrateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276761967961866931)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous devez indiquer les adresses \00E9lectroniques des administrateurs')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276926042309867035)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_language=>'fr'
,p_message_text=>unistr('Accessibilit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276416416776866706)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276416762281866706)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_language=>'fr'
,p_message_text=>'Performances'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276416835739866706)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_language=>'fr'
,p_message_text=>unistr('Assurance qualit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276416561369866706)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9curit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276416954927866706)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_language=>'fr'
,p_message_text=>unistr('Utilisabilit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276416657157866706)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_language=>'fr'
,p_message_text=>'Avertissement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277059372273867123)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment "%1" est prot\00E9g\00E9 et ne peut pas \00EAtre d\00E9fini via un appel AJAX.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277059474153867123)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment "%1" est prot\00E9g\00E9 et ne peut pas \00EAtre d\00E9fini via un appel AJAX.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277091336320867143)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment "%1" est prot\00E9g\00E9 et ne peut pas \00EAtre d\00E9fini via un appel AJAX.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276447239551866727)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9fixe de sch\00E9ma SYS manquant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277269266048867259)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_language=>'fr'
,p_message_text=>unistr('Utilisation des API WWV_FLOW (utiliser des API APEX \00E0 la place)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277209375034867220)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne %0 n''existe pas dans l''instruction SQL de source de r\00E9gion.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276426756058866713)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne %0 de l''\00E9tat interactif n''existe pas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276424410460866711)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'%0 n''existe pas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276392835086866690)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne %0 n''existe pas dans l''instruction SQL de source de r\00E9gion.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277303865126867282)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'La colonne %0 du panneau tabulaire n''existe pas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276424541384866711)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 ne peut pas \00EAtre r\00E9f\00E9renc\00E9 comme nom d''\00E9l\00E9ment d''application/de page.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277645044094867501)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Le processus d''application Fonction callback AJAX n''est pas prot\00E9g\00E9 par un mod\00E8le d''autorisation.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277644664647867501)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_language=>'fr'
,p_message_text=>unistr('La page n''est pas prot\00E9g\00E9e par un mod\00E8le d''autorisation.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276425438961866712)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('La page cible %1 (dans l''application %0) n''a aucun mod\00E8le d''autorisation d\00E9fini.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277646720637867503)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_language=>'fr'
,p_message_text=>unistr('L''autorisation de cette page est diff\00E9rente de l''autorisation "%1" de la page parent %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276425535563866712)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_language=>'fr'
,p_message_text=>unistr('L''autorisation "%0" sur la page cible est diff\00E9rente de "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276424010547866711)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'%0 n''existe pas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276423994355866711)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de v\00E9rifier la syntaxe de variable attach\00E9e. Erreur : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276424160019866711)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 ne peut pas \00EAtre r\00E9f\00E9renc\00E9 avec la syntaxe de variable attach\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276426194329866712)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_language=>'fr'
,p_message_text=>'Branchement inconditionnel avant les autres branchements'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277644474293867501)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9criture automatique est d\00E9finie sur Activ\00E9 pour une page contenant des \00E9l\00E9ments de mot de passe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277644513372867501)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_language=>'fr'
,p_message_text=>unistr('L''option Cache autorise le navigateur \00E0 mettre en m\00E9moire cache des donn\00E9es confidentielles.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277529402514867427)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_language=>'fr'
,p_message_text=>unistr('L''option Imbriquer dans des cadres rend l''application vuln\00E9rable aux attaques de d\00E9tournement de clics.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277529554874867427)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_language=>'fr'
,p_message_text=>unistr('L''option Mode d''\00E9chappement HTML proc\00E8de uniquement \00E0 l''\00E9chappement d''un ensemble limit\00E9 de caract\00E8res.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276350645972866664)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('ID trouv\00E9 dans les attributs de bouton, pour un bouton r\00E9f\00E9renc\00E9 dans une action dynamique (%0). '),
'',
unistr('La d\00E9finition d''un ID dans les attributs de bouton emp\00EAche le fonctionnement des actions dynamiques r\00E9f\00E9ren\00E7ant le bouton. Envisagez la suppression de cet ID car le bouton g\00E9n\00E9rera un ID par d\00E9faut.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276350708360866665)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Le mod\00E8le de bouton utilis\00E9 par un bouton, lui-m\00EAme r\00E9f\00E9renc\00E9 dans une action dynamique (%0), ne contient pas la cha\00EEne de substitution #BUTTON_ID#.'),
'',
unistr('Mod\00E8le :'),
'%1',
'',
unistr('Ajoutez la cha\00EEne de substitution #BUTTON_ID# \00E0 ce mod\00E8le ou choisissez un mod\00E8le de bouton contenant d\00E9j\00E0 la cha\00EEne #BUTTON_ID#.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276353383016866666)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_language=>'fr'
,p_message_text=>unistr('L''action de bouton n''est pas de type D\00E9fini par une action dynamique pour un bouton r\00E9f\00E9renc\00E9 dans une action dynamique (%0).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276360006358866670)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_language=>'fr'
,p_message_text=>unistr('Le bouton (%0) contient une action de type D\00E9fini par une action dynamique, mais aucune action dynamique correspondante ne r\00E9f\00E9rence ce bouton.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276927520616867036)
,p_name=>'ADVISOR.CHECK.CHART_TYPE_IS_ACCESSIBLE.MSG_ANYCHART_CHART'
,p_message_language=>'fr'
,p_message_text=>unistr('Il s''agit d''un ancien type de graphique AnyChart. Vous devriez utiliser la fonctionnalit\00E9 ''Mise \00E0 niveau de l''application'' pour migrer ce graphique et utiliser les nouveaux graphiques Oracle JET, dont l''utilit\00E9 et l''accessibilit\00E9 ont \00E9t\00E9 grandement a')
||unistr('m\00E9lior\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276425160176866712)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_language=>'fr'
,p_message_text=>'La page Effacer le cache %0 n''est pas la page en cours ou la page cible %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276423825306866711)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'%0 n''existe pas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277616670980867483)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur d''attribut est obsol\00E8te.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277618157152867484)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Ce type de composant est en phase d''abandon.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277059581815867123)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments prot\00E9g\00E9s dans les appels AJAX')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276447150656866727)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_language=>'fr'
,p_message_text=>unistr('Probl\00E8me de code (APEX interne)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276421960312866709)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9f\00E9rences d\00E9claratives d''\00E9l\00E9ments d''application, d''\00E9l\00E9ments de page, de colonnes ou de filtres d''\00E9tat interactif')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277644308893867501)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_language=>'fr'
,p_message_text=>'Autorisation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276421671408866709)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9f\00E9rences avec syntaxe de variable attach\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276423067456866710)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_language=>'fr'
,p_message_text=>'Branchement inconditionnel avant les autres branchements'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277644808054867501)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de s\00E9curit\00E9 de navigateur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276350574137866664)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_language=>'fr'
,p_message_text=>'Le bouton n''est pas compatible avec les actions dynamiques'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276359849861866670)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9f\00E9rences incoh\00E9rentes entre les actions dynamiques et les boutons')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276927369146867036)
,p_name=>'ADVISOR.CHECK.DESC_CHART_TYPE_IS_ACCESSIBLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Le type de graphique prend en charge l''accessibilit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276422249123866710)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_language=>'fr'
,p_message_text=>unistr('Le num\00E9ro de la page Effacer le cache est le m\00EAme que celui de la page cible ou en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276421566352866709)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9f\00E9rences avec syntaxe de colonne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277616507016867483)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_language=>'fr'
,p_message_text=>unistr('Valeurs d''attribut obsol\00E8tes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276422537333866710)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_language=>'fr'
,p_message_text=>'Les processus d''extraction, DML et MR* sont valides'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276422997219866710)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_language=>'fr'
,p_message_text=>unistr('ID d''application cod\00E9 en dur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276833515031866976)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment de page poss\00E8de un texte d''aide')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276925819673867035)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_language=>'fr'
,p_message_text=>'La page a un titre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276951941050867052)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_language=>'fr'
,p_message_text=>unistr('Du texte alternatif d''image est d\00E9fini pour l''\00E9l\00E9ment Afficher l''image')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277529262815867427)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Attributs d''application pouvant \00EAtre verrouill\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276421727618866709)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment r\00E9f\00E9renc\00E9 est sur la page en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276421864917866709)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment r\00E9f\00E9renc\00E9 est l''\00E9l\00E9ment de page de la page cible')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276926542376867036)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment de page n''entra\00EEne aucune modification de contexte inattendue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276927722547867036)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment de page poss\00E8de un libell\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276423241674866710)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_language=>'fr'
,p_message_text=>unistr('Longueur de l''\00E9l\00E9ment ou du nom de colonne de panneau tabulaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276422075259866709)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9f\00E9rences d''\00E9l\00E9ment de page dans une cha\00EEne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276422156077866710)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Le num\00E9ro de page r\00E9f\00E9renc\00E9 existe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276926102472867035)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_language=>'fr'
,p_message_text=>unistr('La r\00E9gion a un en-t\00EAte de ligne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276423492170866710)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9tat suit l''ordre par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277644995125867501)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_language=>'fr'
,p_message_text=>'Protection de statut de session'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276422693209866710)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_language=>'fr'
,p_message_text=>'Utilisation incorrecte de la syntaxe de substitution'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276421413377866709)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9f\00E9rences avec syntaxe de substitution')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276422412312866710)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_language=>'fr'
,p_message_text=>unistr('L''autorisation de page cible est \00E9galement d\00E9finie pour le composant en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276926356118867035)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Style de th\00E8me test\00E9 en mati\00E8re d''accessibilit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277048258486867115)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_language=>'fr'
,p_message_text=>unistr('L''interface utilisateur inclut la compatibilit\00E9 avec JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276423162624866710)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ment ou colonne associ\00E9 des validations')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276422306966866710)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_language=>'fr'
,p_message_text=>'Est un code SQL ou PL/SQL valide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276422890369866710)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_language=>'fr'
,p_message_text=>unistr('V\00E9rifier la propri\00E9t\00E9 Clob')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276422701798866710)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonction V utilis\00E9e dans les instructions SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276423364002866710)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le bouton r\00E9f\00E9renc\00E9 dans l''op\00E9ration Lors de l''activation du bouton existe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276425705046866712)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_language=>'fr'
,p_message_text=>'Erreur de compilation - %0 Instruction : %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276426068509866712)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Le lien contient l''ID d''application en cours sous forme de valeur cod\00E9e en dur.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276833456835866976)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun texte d''aide d\00E9fini.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276925997025867035)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('La page n''a pas de titre. L''utilisation de titres de page significatifs est importante en mati\00E8re d''accessibilit\00E9, afin d''aider les utilisateurs \00E0 comprendre le contenu et l''objectif de la page en cours.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276952096681867052)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment ne contient pas le texte alternatif requis pour l''image. Un texte adapt\00E9 \00E0 cet usage doit d\00E9crire de mani\00E8re ad\00E9quate le contenu de l''image et ne doit dupliquer aucune information visible sur la page affich\00E9e dans le contexte de l''image (af')
||unistr('in d''\00E9viter toute duplication). Remarque : si l''image est fournie par des utilisateurs, le texte alternatif de l''image doit l''\00EAtre aussi, avec des conseils appropri\00E9s qui aideront vos utilisateurs \00E0 fournir un texte de haute qualit\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277529318842867427)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('L''option Syntaxe d''API d''ex\00E9cution autorise la modification d''espace de travail et d''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276424231370866711)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 n''est pas un \00E9l\00E9ment de la page %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276424394460866711)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 n''est pas un \00E9l\00E9ment de la page cible %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276926667730867036)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Le param\00E8tre ''Action de page lors de la s\00E9lection'' de l''\00E9l\00E9ment de page peut entra\00EEner une modification de contexte inattendue pour l''utilisateur. Envisagez de basculer sur ''Aucune'' afin d''\00E9viter toute modification de contexte et de remplacer la fonc')
||unistr('tionnalit\00E9 par Actions dynamiques ou Listes de valeurs en cascade (si vous devez rester sur la m\00EAme page). Envisagez \00E9galement de fournir des informations \00E0 l''utilisateur afin qu''il sache ce qu''il se passera, par exemple en ajoutant ''Lance une nouvel')
||unistr('le page'' dans le libell\00E9. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276951874439867052)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous devez d\00E9finir un libell\00E9 pour l''\00E9l\00E9ment. Si vous pr\00E9f\00E9rez que le libell\00E9 ne soit pas visible, vous pouvez tout de m\00EAme d\00E9finir un libell\00E9, puis s\00E9lectionner le mod\00E8le de libell\00E9 ''Masqu\00E9''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276927886363867036)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment d\00E9finit une valeur ''Valeur de r\00E9serve'', mais aucun libell\00E9. Un texte de r\00E9serve ne doit pas \00EAtre utilis\00E9 uniquement pour libeller l''\00E9l\00E9ment, car il entra\00EEne des probl\00E8mes d''accessibilit\00E9. Pour optimiser l''accessibilit\00E9, vous devez d\00E9finir u')
||unistr('n libell\00E9 d''\00E9l\00E9ment. Si vous pr\00E9f\00E9rez que le libell\00E9 ne soit pas visible, vous pouvez tout de m\00EAme d\00E9finir un libell\00E9, puis s\00E9lectionner le mod\00E8le de libell\00E9 ''Masqu\00E9''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276426472867866713)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nom contient %0 caract\00E8res, alors que la limite maximale autoris\00E9e est de 30 caract\00E8res.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276424645292866711)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 n''existe peut-\00EAtre pas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276424711966866711)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 n''est peut-\00EAtre pas un \00E9l\00E9ment de page ou d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276425087669866712)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'La page Effacer le cache %1 (dans l''application %0) n''existe pas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276424812356866712)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'La page %0 n''existe pas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276424960080866712)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'La page cible %1 (dans l''application %0) n''existe pas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276849956412866987)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('La r\00E9gion Activation/d\00E9sactivation de colonne ne comporte pas de colonne dont la valeur Utiliser comme en-t\00EAte de ligne est d\00E9finie sur Oui. La colonne En-t\00EAte de ligne doit \00EAtre la colonne qui identifie au mieux la ligne en cours (par exemple, le no')
||unistr('m d''un client dans un \00E9tat d''informations sur les clients).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276850055491866987)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('La r\00E9gion Reflux ne comporte pas de colonne dont la valeur pour Utiliser comme en-t\00EAte de ligne est d\00E9finie sur Oui. La colonne En-t\00EAte de ligne doit \00EAtre la colonne qui identifie au mieux la ligne en cours (par exemple, le nom d''un client dans un \00E9t')
||'at d''informations sur les clients).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276926257377867035)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('La r\00E9gion de ce panneau tabulaire n''a pas de colonne dont la valeur de "Utiliser comme en-t\00EAte de ligne" est d\00E9finie sur Oui. La colonne En-t\00EAte de ligne doit \00EAtre la colonne qui identifie au mieux la ligne en cours (par exemple, le nom d''un client d')
||unistr('ans une table d''informations sur les clients). Ces informations sont ensuite utilis\00E9es lors de l''affichage du panneau tabulaire, afin de fournir un libell\00E9 unique pour les champs de panneau de chaque ligne.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276426669848866713)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_language=>'fr'
,p_message_text=>unistr('Il n''existe aucun ordre par d\00E9faut pour l''\00E9tat.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277529605962867427)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_language=>'fr'
,p_message_text=>unistr('L''option Fonction de hachage de signet est d\00E9finie sur un algorithme h\00E9rit\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277529798899867427)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_language=>'fr'
,p_message_text=>unistr('La protection de statut de session est d\00E9sactiv\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277644718578867501)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Sur une page avec un processus d''extraction, vous devez utiliser la protection d''acc\00E8s de page et l''activer pour les \00E9l\00E9ments que vous transmettez via l''URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276383386856866684)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_language=>'fr'
,p_message_text=>unistr('La r\00E9gion contient une URL "f?p" qui n''a pas \00E9t\00E9 transmise par APEX_UTIL.PREPARE_URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276425803114866712)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Injection SQL possible d\00E9tect\00E9e. %0 est utilis\00E9 avec la syntaxe de substitution dans le code SQL et PL/SQL, ou le nom de table de processus.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276423662139866711)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'%0 n''existe pas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276423772995866711)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 ne peut pas \00EAtre r\00E9f\00E9renc\00E9 avec la syntaxe de substitution.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276425624262866712)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('La page cible %1 (dans l''application %0) a un mod\00E8le d''autorisation d\00E9fini, mais le composant en cours n''en a pas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276926438953867035)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_language=>'fr'
,p_message_text=>unistr('L''accessibilit\00E9 du style de th\00E8me en cours de l''application n''a pas \00E9t\00E9 test\00E9e. Vous pouvez basculer vers un style de th\00E8me dont la valeur de l''attribut Accessibilit\00E9 test\00E9e est d\00E9finie sur Oui ou, si votre style de th\00E8me en cours a \00E9t\00E9 test\00E9, d\00E9fini')
||unistr('r la valeur de l''attribut Accessibilit\00E9 test\00E9e sur Oui dans vos param\00E8tres de th\00E8me.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277048417694867115)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('L''interface utilisateur inclut la migration jQuery. La migration jQuery vous aide \00E0 migrer vers une nouvelle version de jQuery en restaurant les API enlev\00E9es, et affiche des avertissements dans la console du navigateur lorsque des API enlev\00E9es ou en ')
||unistr('phase d''abandon sont utilis\00E9es. Elle inclut un fichier JavaScript suppl\00E9mentaire sur chaque page de votre application. Pour l''enlever, consultez le guide de mise \00E0 niveau de la migration jQuery afin d''obtenir plus de d\00E9tails sur les API qui doivent \00EA')
||unistr('tre modifi\00E9es puis, lorsque vous \00EAtes certain que vous ne vous appuyez plus sur aucune de ces API, d\00E9finissez Inclure la migration jQuery sur Non.'),
'',
'https://github.com/jquery/jquery-migrate'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277048340307867115)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_language=>'fr'
,p_message_text=>unistr('L''interface utilisateur inclut des fonctions JavaScript APEX en phase d''abandon ou qui ne sont plus prises en charge. Elle inclut un fichier JavaScript suppl\00E9mentaire sur chaque page de votre application. Pour l''enlever, consultez la section ''Fonctio')
||unistr('nnalit\00E9s en phase d''abandon'' dans les notes de version, dans laquelle vous trouverez des instructions permettant de v\00E9rifier les d\00E9pendances \00E0 des fonctionnalit\00E9s en phase d''abandon ou qui ne sont plus prises en charge, afin qu''\00E0 terme votre applicat')
||'ion n''en contienne plus.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276426367638866713)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment ou la colonne associ\00E9 n''est pas d\00E9fini, mais l''emplacement d''affichage du message d''erreur en a besoin.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276426204300866712)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment ou la colonne associ\00E9 n''est pas \00E9gal \00E0 la valeur "%0" indiqu\00E9e dans l''expression de validation 1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276425235207866712)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_language=>'fr'
,p_message_text=>'Erreur de compilation - %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276425350956866712)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun code SQL ou PL/SQL d\00E9fini.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276423569469866711)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_language=>'fr'
,p_message_text=>unistr('Est sup\00E9rieur \00E0 32 767. Seuls les 32 767 premiers caract\00E8res sont v\00E9rifi\00E9s. Longueur : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276425966609866712)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_language=>'fr'
,p_message_text=>unistr('Contient l''appel de fonction V/NV/DV dans l''instruction SQL (cela peut entra\00EEner des probl\00E8mes de performances).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276426560476866713)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Le bouton r\00E9f\00E9renc\00E9 n''existe plus.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276820031929866967)
,p_name=>'AFTER'
,p_message_language=>'fr'
,p_message_text=>unistr('Apr\00E8s')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276761363504866930)
,p_name=>'AGREEMENT_MISSING'
,p_message_language=>'fr'
,p_message_text=>'Accord manquant'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276566262888866806)
,p_name=>'ALIAS'
,p_message_language=>'fr'
,p_message_text=>'Alias'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277272472522867261)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_language=>'fr'
,p_message_text=>'Autoriser la construction de l''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277189219538867207)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Autorisez l''installation d''applications \00E9chantillon et de productivit\00E9.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277024546596867098)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_language=>'fr'
,p_message_text=>'Autoriser l''utilisation des services RESTful'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277272510927867261)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_language=>'fr'
,p_message_text=>'Autoriser l''utilisation de SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277272722189867261)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Autoriser l''utilisation du d\00E9veloppement d''\00E9quipe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277272386309867261)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_language=>'fr'
,p_message_text=>'Autoriser la purge de l''espace de travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277272637026867261)
,p_name=>'ALLOW_WEBSHEET_DEV'
,p_message_language=>'fr'
,p_message_text=>'Autoriser Websheet Development'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276585516005866819)
,p_name=>'ALL_APPLICATIONS'
,p_message_language=>'fr'
,p_message_text=>'Toutes les applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276371355686866677)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_language=>'fr'
,p_message_text=>'- Tout - '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276371188767866677)
,p_name=>'ALL_CATEGORIES'
,p_message_language=>'fr'
,p_message_text=>unistr('Toutes les cat\00E9gories')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276371484023866677)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_language=>'fr'
,p_message_text=>unistr('- Toutes les cat\00E9gories -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277275493037867263)
,p_name=>'ALL_MILESTONES'
,p_message_language=>'fr'
,p_message_text=>'Tous les jalons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276953489548867053)
,p_name=>'ALL_RELEASES'
,p_message_language=>'fr'
,p_message_text=>'Toutes les versions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276591485922866822)
,p_name=>'ALL_STATIC_FILES'
,p_message_language=>'fr'
,p_message_text=>'tous les fichiers statiques'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276590064800866821)
,p_name=>'ALL_THEMES'
,p_message_language=>'fr'
,p_message_text=>unistr('tous les th\00E8mes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277297139238867277)
,p_name=>'ALL_TYPES'
,p_message_language=>'fr'
,p_message_text=>'Tous les types'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277297583476867278)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_language=>'fr'
,p_message_text=>'- Tous les types -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276586633779866819)
,p_name=>'ALL_USERS'
,p_message_language=>'fr'
,p_message_text=>'Tous les utilisateurs'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277639287179867498)
,p_name=>'ALREADY_IN_ACL'
,p_message_language=>'fr'
,p_message_text=>unistr('L''utilisateur dispose d\00E9j\00E0 d''un compte APEX')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277629190382867491)
,p_name=>'ALREADY_IN_WS'
,p_message_language=>'fr'
,p_message_text=>unistr('L''utilisateur existe d\00E9j\00E0 dans l''espace de travail')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277589828117867466)
,p_name=>'ALWAYS'
,p_message_language=>'fr'
,p_message_text=>'Toujours'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276342868011866660)
,p_name=>'AM_PM'
,p_message_language=>'fr'
,p_message_text=>'AM / PM'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276836740352866978)
,p_name=>'ANALYSIS'
,p_message_language=>'fr'
,p_message_text=>'Analyse de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276836823369866978)
,p_name=>'ANALYZE'
,p_message_language=>'fr'
,p_message_text=>'Analyse par %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276975799747867067)
,p_name=>'ANALYZE_TABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Analyse \00E0 l''aide de la m\00E9thode %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276444411369866725)
,p_name=>'ANCHOR.SHOW_ALL'
,p_message_language=>'fr'
,p_message_text=>'Afficher tout'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276588952050866821)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_language=>'fr'
,p_message_text=>'bloc anonyme'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276431302378866716)
,p_name=>'ANSWERS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9ponses')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276383065578866684)
,p_name=>'ANY_DEVELOPER'
,p_message_language=>'fr'
,p_message_text=>unistr('(N''importe quel d\00E9veloppeur)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277604977182867476)
,p_name=>'APEX.ACTIONS.TOGGLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer/d\00E9sactiver %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277644180994867501)
,p_name=>'APEX.ACTIVE_STATE'
,p_message_language=>'fr'
,p_message_text=>'(Actif)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277707765961867542)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_language=>'fr'
,p_message_text=>'Modifications d''application:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277707647517867542)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_language=>'fr'
,p_message_text=>'Heure :'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277712499800867545)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_language=>'fr'
,p_message_text=>'%0 K'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277707836040867542)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_language=>'fr'
,p_message_text=>'Vues de page: '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277229825094867233)
,p_name=>'APEX.AJAX_SERVER_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('L''appel d''AJAX a renvoy\00E9 une erreur de serveur %0 pour %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277527287114867426)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Un appel d''API a \00E9t\00E9 interdit.'),
'Contactez l''administrateur.',
unistr('Des d\00E9tails relatifs \00E0 cet incident sont disponibles via l''ID de d\00E9bogage "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276633938306866849)
,p_name=>'APEX.APPLICATION.ALIAS.NON_UNIQUE'
,p_message_language=>'fr'
,p_message_text=>unistr('L''alias d''application "%0" ne peut pas \00EAtre converti en ID d''application unique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276634054651866849)
,p_name=>'APEX.APPLICATION.ALIAS.NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>'L''application portant l''alias "%0" n''existe pas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276591671760866822)
,p_name=>'APEX.APPLICATION.ALIAS.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'ERR-1816 Erreur inattendue lors de la conversion de l''alias d''application p_flow_alias_or_id (%0).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276460484657866736)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_language=>'fr'
,p_message_text=>unistr('L''appel d''API "%0" n''est plus pris en charge dans la version %1 d''Application Express. Pour obtenir des d\00E9tails concernant cet incident, vous pouvez utiliser l''ID de d\00E9bogage "%2".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276467141496866741)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNC.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement de la fonction d''authentification.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276354712450866667)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement de la fonction d''authentification.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277722506351867551)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.HOST_PREFIX_MISMATCH'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nom de locataire %0 renvoy\00E9 par Oracle Cloud Identity Management n''est pas autoris\00E9 pour le domaine %1.<br/><a href="&LOGOUT_URL.">Reconnectez-vous</a>, puis indiquez un nom de locataire autoris\00E9 ou modifiez l''URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276347847261866663)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.USER_IS_NOT_DEVELOPER'
,p_message_language=>'fr'
,p_message_text=>unistr('Le compte "%0" ne dispose pas des privil\00E8ges de d\00E9veloppement n\00E9cessaires (DB_DEVELOPER ou DB_ADMINISTRATOR)<br/>pour l''espace de travail "%1". <a href="&LOGOUT_URL.">Reconnectez-vous</a> une fois les privil\00E8ges obtenus.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276343215650866660)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.WRONG_GROUP_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nom de locataire renvoy\00E9 par Oracle Cloud Identity Management n''est pas autoris\00E9 pour l''espace de travail en cours.<br/><a href="&LOGOUT_URL.">Reconnectez-vous</a> et indiquez un nom de locataire autoris\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276481484711866750)
,p_name=>'APEX.AUTHENTICATION.HEADER.DUPLICATE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('L''en-t\00EAte HTTP %0 a \00E9t\00E9 envoy\00E9 deux fois, il pourrait s''agir d''une attaque.'),
'<ul>',
unistr('<li>Premi\00E8re valeur : "%1"</li>'),
unistr('<li>Deuxi\00E8me valeur : "%2"</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276348077016866663)
,p_name=>'APEX.AUTHENTICATION.HOST_PREFIX_MISMATCH'
,p_message_language=>'fr'
,p_message_text=>unistr('Pour des raisons de s\00E9curit\00E9, l''ex\00E9cution des applications de cet espace de travail via le domaine de l''URL n''est pas autoris\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276466819594866741)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.ASK_FOR_INSTALLATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Demandez \00E0 votre administrateur de base de donn\00E9es d''ex\00E9cuter $OH/rdbms/admin/catldap.sql.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276466774661866741)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.MISSING'
,p_message_language=>'fr'
,p_message_text=>'Le package SYS.DBMS_LDAP n''existe pas ou n''est pas valide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276466665026866740)
,p_name=>'APEX.AUTHENTICATION.LDAP.EDIT_USER_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur lors du traitement de la fonction de mise \00E0 jour de l''utilisateur LDAP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276466955627866741)
,p_name=>'APEX.AUTHENTICATION.LDAP.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement de l''authentification LDAP.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276468150292866741)
,p_name=>'APEX.AUTHENTICATION.LOGIN.ILLEGAL_PAGE_ARG'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur dans l''argument p_flow_page de la proc\00E9dure login_page.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276467673026866741)
,p_name=>'APEX.AUTHENTICATION.LOGIN.INVALID_ARG'
,p_message_language=>'fr'
,p_message_text=>'p_session non valide dans wwv_flow_custom_auth_std.login--p_flow_page : %0 p_session_id : %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276467483062866741)
,p_name=>'APEX.AUTHENTICATION.LOGIN.MALFORMED_ARGS'
,p_message_language=>'fr'
,p_message_text=>'Argument incorrect pour wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276467810963866741)
,p_name=>'APEX.AUTHENTICATION.LOGIN.NULL_USER'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom utilisateur Null transmis \00E0 la proc\00E9dure de connexion.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276367514568866675)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.COUNTER'
,p_message_language=>'fr'
,p_message_text=>'Veuillez patienter pendant <span id="apex_login_throttle_sec">%0</span> secondes avant de vous reconnecter.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276372547249866678)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('La tentative de connexion a \00E9t\00E9 bloqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276807882489866960)
,p_name=>'APEX.AUTHENTICATION.NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>'Authentification "%0" introuvable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276381115500866683)
,p_name=>'APEX.AUTHENTICATION.NO_SECURITY_GROUP_ID'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ID de groupe de s\00E9curit\00E9 est Null.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276467303827866741)
,p_name=>'APEX.AUTHENTICATION.POST_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur d''ex\00E9cution du processus de postauthentification')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276467050829866741)
,p_name=>'APEX.AUTHENTICATION.PRE_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur lors du traitement du processus de pr\00E9authentification.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276486551566866754)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD.INSTRUCTIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ouvrez l''URL dans le navigateur que vous avez utilis\00E9 pour lancer la demande de r\00E9initialisation de mot de passe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277706916848867542)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD_URL'
,p_message_language=>'fr'
,p_message_text=>unistr('URL de r\00E9initialisation du mot de passe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276348228916866663)
,p_name=>'APEX.AUTHENTICATION.RM_GROUP_NOT_GRANTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le groupe de consommateurs Resource Manager %0 n''a pas \00E9t\00E9 accord\00E9 \00E0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276348386429866663)
,p_name=>'APEX.AUTHENTICATION.RM_INFO_TO_GRANT'
,p_message_language=>'fr'
,p_message_text=>unistr('Utilisez DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP pour octroyer le privil\00E8ge manquant.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276544395793866792)
,p_name=>'APEX.AUTHENTICATION.SESSION_SENTRY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement de la fonction de sentinelle de session.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276544414455866792)
,p_name=>'APEX.AUTHENTICATION.SESSION_VERIFY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur lors du traitement de la fonction de v\00E9rification de session.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276544652282866792)
,p_name=>'APEX.AUTHENTICATION.SSO.ASK_FOR_INSTALLATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Demandez \00E0 votre administrateur %0 de configurer le moteur pour Oracle Application Server Single Sign-On.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276620714271866841)
,p_name=>'APEX.AUTHENTICATION.SSO.BAD_URLC'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 non valide dans le token %1 renvoy\00E9 par SSO.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276468010022866741)
,p_name=>'APEX.AUTHENTICATION.SSO.FIX_PARTNER_APP'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifiez le mod\00E8le d''authentification et ajoutez le nom d''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276620312042866840)
,p_name=>'APEX.AUTHENTICATION.SSO.ILLEGAL_CALLER'
,p_message_language=>'fr'
,p_message_text=>unistr('Appelant de la proc\00E9dure %0 non valide :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276620597578866840)
,p_name=>'APEX.AUTHENTICATION.SSO.INVALID_APP_SESSION'
,p_message_language=>'fr'
,p_message_text=>'Session d''application non valide dans le token URLC : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276620107769866840)
,p_name=>'APEX.AUTHENTICATION.SSO.MISSING_APP_REGISTRATION'
,p_message_language=>'fr'
,p_message_text=>'Erreur dans portal_sso_redirect : informations d''inscription d''application absentes : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276544571537866792)
,p_name=>'APEX.AUTHENTICATION.SSO.PACKAGE_MISSING'
,p_message_language=>'fr'
,p_message_text=>'Le package WWSEC_SSO_ENABLER_PRIVATE n''existe pas ou n''est pas valide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276467989094866741)
,p_name=>'APEX.AUTHENTICATION.SSO.PARTNER_APP_IS_NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de trouver le nom d''application partenaire inscrit dans le mod\00E8le d''authentification.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276620245469866840)
,p_name=>'APEX.AUTHENTICATION.SSO.REGISTER_APP'
,p_message_language=>'fr'
,p_message_text=>unistr('Inscrivez cette application comme indiqu\00E9 dans le guide d''installation.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276544775125866793)
,p_name=>'APEX.AUTHENTICATION.SSO.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement de l''authentification SSO.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277623732226867488)
,p_name=>'APEX.AUTHENTICATION.UNAUTHORIZED_URL'
,p_message_language=>'fr'
,p_message_text=>unistr('URL non autoris\00E9e : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276544109395866792)
,p_name=>'APEX.AUTHENTICATION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement de l''authentification.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276348106748866663)
,p_name=>'APEX.AUTHENTICATION.WORKSPACE_NOT_ASSIGNED'
,p_message_language=>'fr'
,p_message_text=>'L''espace de travail "%0" est inactif. Contactez l''administrateur.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276349336870866664)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED'
,p_message_language=>'fr'
,p_message_text=>'%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276370087212866676)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.APPLICATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E8s refus\00E9 par le contr\00F4le de s\00E9curit\00E9 de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276370118220866676)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E8s refus\00E9 par le contr\00F4le de s\00E9curit\00E9 de la page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276370260664866676)
,p_name=>'APEX.AUTHORIZATION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement de l''autorisation.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276847089743866985)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_language=>'fr'
,p_message_text=>'La valeur #LABEL# n''existe pas dans la liste.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277229468933867233)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Les branchements en affichage seul ne sont pas pris en charge si l''attribut de page Recharger apr\00E8s soumission est d\00E9fini sur Seulement en cas de succ\00E8s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276594470447866824)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement du branchement.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276914995124867028)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX'
,p_message_language=>'fr'
,p_message_text=>unistr('Construit avec %0 \00E0 l''aide de %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276915080007867028)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX.ACCESSIBLE.LOVE'
,p_message_language=>'fr'
,p_message_text=>'amour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276951642972867052)
,p_name=>'APEX.CALCULATOR.ICON_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Calculatrice instantan\00E9e : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277579793975867459)
,p_name=>'APEX.CALENDAR.EVENT_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Description d''\00E9v\00E9nement')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277579558898867459)
,p_name=>'APEX.CALENDAR.EVENT_END'
,p_message_language=>'fr'
,p_message_text=>'Date de fin'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277579826796867460)
,p_name=>'APEX.CALENDAR.EVENT_ID'
,p_message_language=>'fr'
,p_message_text=>unistr('ID d''\00E9v\00E9nement')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277579415941867459)
,p_name=>'APEX.CALENDAR.EVENT_START'
,p_message_language=>'fr'
,p_message_text=>unistr('Date de d\00E9but')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277579646945867459)
,p_name=>'APEX.CALENDAR.EVENT_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Titre d''\00E9v\00E9nement')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277047783067867115)
,p_name=>'APEX.CLIPBOARD.COPIED'
,p_message_language=>'fr'
,p_message_text=>unistr('Copi\00E9 dans le presse-papiers.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277040771671867111)
,p_name=>'APEX.CLIPBOARD.NOTSUP'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce navigateur ne prend pas en charge la copie \00E0 partir d''un bouton ou d''un menu. Essayez la combinaison Ctrl+C ou Commande+C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276917051812867029)
,p_name=>'APEX.CLOSE_NOTIFICATION'
,p_message_language=>'fr'
,p_message_text=>'Fermer la notification'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276338879365866657)
,p_name=>'APEX.COLOR_PICKER.ICON_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lecteur de couleur instantan\00E9 : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277692926769867533)
,p_name=>'APEX.COMBOBOX.LIST_OF_VALUES'
,p_message_language=>'fr'
,p_message_text=>'Liste de valeurs (LOV)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277693022018867533)
,p_name=>'APEX.COMBOBOX.SHOW_ALL_VALUES'
,p_message_language=>'fr'
,p_message_text=>'Ouvrir la liste pour : %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277644248557867501)
,p_name=>'APEX.COMPLETED_STATE'
,p_message_language=>'fr'
,p_message_text=>unistr('(Termin\00E9)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276349536887866664)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement du calcul.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276571816408866810)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement de la condition.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276634514137866849)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type de condition "%0" inconnu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276599754269866827)
,p_name=>'APEX.CONTACT_ADMIN'
,p_message_language=>'fr'
,p_message_text=>'Contactez l''administrateur de l''application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276682000067866880)
,p_name=>'APEX.CONTACT_ADMIN.DEBUG'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Contactez l''administrateur de l''application.',
unistr('Les d\00E9tails relatifs \00E0 cet incident sont disponibles via l''ID de d\00E9bogage "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277566737948867451)
,p_name=>'APEX.CORRECT_ERRORS'
,p_message_language=>'fr'
,p_message_text=>'Corrigez les erreurs avant l''enregistrement.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277648424034867504)
,p_name=>'APEX.CURRENT_PROGRESS'
,p_message_language=>'fr'
,p_message_text=>'Progression'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277267736791867258)
,p_name=>'APEX.DATA_HAS_CHANGED'
,p_message_language=>'fr'
,p_message_text=>unistr('La version en cours des donn\00E9es dans la base a chang\00E9 depuis que l''utilisateur a lanc\00E9 le traitement de mise \00E0 jour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276951532167867052)
,p_name=>'APEX.DATEPICKER.ICON_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Calendrier instantan\00E9 : %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276960629875867057)
,p_name=>'APEX.DATEPICKER_VALUE_GREATER_MAX_DATE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur #LABEL# est sup\00E9rieure \00E0 la date maximale indiqu\00E9e %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276965918818867061)
,p_name=>'APEX.DATEPICKER_VALUE_INVALID'
,p_message_language=>'fr'
,p_message_text=>'La valeur #LABEL# ne concorde pas avec le format %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276960573481867057)
,p_name=>'APEX.DATEPICKER_VALUE_LESS_MIN_DATE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur #LABEL# est inf\00E9rieure \00E0 la date minimale indiqu\00E9e %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276960734766867058)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'fr'
,p_message_text=>'La valeur #LABEL# ne figure pas dans la plage valide comprise entre %0 et %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276964298870867060)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_IN_YEAR_RANGE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur #LABEL# ne figure pas dans la plage d''ann\00E9es valide comprise entre %0 et %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277567499853867452)
,p_name=>'APEX.DIALOG.CANCEL'
,p_message_language=>'fr'
,p_message_text=>'Annuler'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277673131840867520)
,p_name=>'APEX.DIALOG.CLOSE'
,p_message_language=>'fr'
,p_message_text=>'Fermer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277678194065867523)
,p_name=>'APEX.DIALOG.HELP'
,p_message_language=>'fr'
,p_message_text=>'Aide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277567227380867452)
,p_name=>'APEX.DIALOG.OK'
,p_message_language=>'fr'
,p_message_text=>'OK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276778669493866941)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Dans l''application %0, la page de bo\00EEte de dialogue %1 ne peut pas \00EAtre affich\00E9e. Assurez-vous que le mod\00E8le de page utilis\00E9 sur la page %1 est du type Page de bo\00EEte de dialogue, avec le code appropri\00E9 d\00E9fini pour l''initialisation de bo\00EEte de dialogu')
||unistr('e JavaScript, ainsi que la fermeture et l''annulation de bo\00EEte de dialogue.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277567317541867452)
,p_name=>'APEX.DIALOG.SAVE'
,p_message_language=>'fr'
,p_message_text=>'Enregistrer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277694877646867534)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_language=>'fr'
,p_message_text=>unistr('Copyright &copy; %0, Tous droits r\00E9serv\00E9s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277695659424867534)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un espace de travail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277694750560867534)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_language=>'fr'
,p_message_text=>unistr('Ceci est un message g\00E9n\00E9r\00E9 par le syst\00E8me. N''y r\00E9pondez pas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277704513386867540)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_language=>'fr'
,p_message_text=>'Environnement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277717106481867548)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_language=>'fr'
,p_message_text=>'Utilisateur Oracle Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277696294355867535)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_language=>'fr'
,p_message_text=>'Mise en route'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277694905000867534)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_language=>'fr'
,p_message_text=>'Bonjour %0,'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277695964954867535)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_language=>'fr'
,p_message_text=>'Mot de passe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277704611309867540)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Emp\00EAcher la purge de l''espace de travail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277696121133867535)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_language=>'fr'
,p_message_text=>unistr('Pour emp\00EAcher la purge de votre espace de travail, cliquez sur le bouton ci-dessous et suivez les instructions \00E0 l''\00E9cran. Si vous n''effectuez aucune action d''ici %0 jour(s), votre espace de travail sera automatiquement enlev\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277704324378867540)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune action n''est n\00E9cessaire si vous n''avez plus besoin de votre espace de travail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277704827741867540)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre espace de travail va \00EAtre purg\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277704106644867540)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre espace de travail %0 n''a montr\00E9 aucune activit\00E9 r\00E9cente et sera bient\00F4t purg\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277704040371867540)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_language=>'fr'
,p_message_text=>unistr('Avertissement : votre espace de travail "%0" va \00EAtre purg\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277704428887867540)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_language=>'fr'
,p_message_text=>'Date de purge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277705188284867540)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_language=>'fr'
,p_message_text=>'Terminez votre demande d''espace de travail.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277704963999867540)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre espace de travail "%0" est pr\00EAt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277705263120867540)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre espace de travail "%0" a \00E9t\00E9 approuv\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277705007259867540)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre demande d''espace de travail a \00E9t\00E9 refus\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277695525131867534)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_language=>'fr'
,p_message_text=>'Nom utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277704746115867540)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_language=>'fr'
,p_message_text=>'Avertissement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277695448454867534)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_language=>'fr'
,p_message_text=>'Espace de travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277695002979867534)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_language=>'fr'
,p_message_text=>unistr('Demande d''espace de travail approuv\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277695759143867534)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_language=>'fr'
,p_message_text=>unistr('Cliquez sur le bouton ci-dessous pour terminer le processus d''approbation et d\00E9finir le mot de passe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277695230009867534)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre demande d''espace de travail a \00E9t\00E9 approuv\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277695833283867534)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_language=>'fr'
,p_message_text=>unistr('Cliquez sur le bouton ci-dessous pour d\00E9marrer.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277696027605867535)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre espace de travail est pr\00EAt.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277695109849867534)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_language=>'fr'
,p_message_text=>unistr('Demande d''espace de travail refus\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277695334777867534)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sol\00E9, votre demande d''espace de travail a \00E9t\00E9 refus\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276594738847866824)
,p_name=>'APEX.ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276345001510866661)
,p_name=>'APEX.ERROR.CALLBACK_FAILED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''erreur suivante est survenue lors de l''ex\00E9cution du callback de gestion des erreurs : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276386198810866686)
,p_name=>'APEX.ERROR.ERROR_PAGE.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors de l''affichage de la page d''erreur : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276348869195866663)
,p_name=>'APEX.ERROR.INTERNAL'
,p_message_language=>'fr'
,p_message_text=>'Erreur interne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277637244838867496)
,p_name=>'APEX.ERROR.INTERNAL.CONTACT_ADMINISTRATOR'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Contactez l''administrateur.',
unistr('Les d\00E9tails relatifs \00E0 cet incident sont disponibles via l''ID de d\00E9bogage "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277718091863867549)
,p_name=>'APEX.ERROR.ORA-28353'
,p_message_language=>'fr'
,p_message_text=>unistr('ORA-28353 : \00E9chec de l''ouverture du portefeuille. Les donn\00E9es d''application sont actuellement inaccessibles.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277619401681867485)
,p_name=>'APEX.ERROR.PAGE_NOT_AVAILABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sol\00E9, cette page n''est pas disponible')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276354647062866667)
,p_name=>'APEX.ERROR.TECHNICAL_INFO'
,p_message_language=>'fr'
,p_message_text=>unistr('Informations techniques (visibles uniquement par les d\00E9veloppeurs)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277182442029867202)
,p_name=>'APEX.ERROR_MESSAGE_HEADING'
,p_message_language=>'fr'
,p_message_text=>'Message d''erreur'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277256320435867250)
,p_name=>'APEX.EXPECTED_FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Format attendu : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276979993544867070)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.ALREADY_IN_ACL'
,p_message_language=>'fr'
,p_message_text=>unistr('L''utilisateur figure d\00E9j\00E0 dans la liste de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276979849979867070)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.CREATE_CONFIRM'
,p_message_language=>'fr'
,p_message_text=>unistr('Confirmez l''ajout des %0 utilisateurs <strong>%1</strong> suivants \00E0 la liste de contr\00F4le d''acc\00E8s.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276980367257867070)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.DUPLICATE_USE'
,p_message_language=>'fr'
,p_message_text=>'Utilisateur en double'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276980020830867070)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_AT_SIGN'
,p_message_language=>'fr'
,p_message_text=>unistr('Arobase manquante (@) dans l''adresse \00E9lectronique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276980145683867070)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_DO'
,p_message_language=>'fr'
,p_message_text=>unistr('Point manquant (.) dans l''adresse \00E9lectronique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276980256317867070)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.USERNAME_TOO_LONG'
,p_message_language=>'fr'
,p_message_text=>'Le nom utilisateur est trop long'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276980590646867070)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_ONLY'
,p_message_language=>'fr'
,p_message_text=>unistr('Seuls les utilisateurs d\00E9finis dans la liste de contr\00F4le d''acc\00E8s de l''application peuvent acc\00E9der \00E0 l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276980632921867070)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_VALUE_INVALID'
,p_message_language=>'fr'
,p_message_text=>unistr('Valeur de param\00E8tre de contr\00F4le d''acc\00E8s inattendue : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276980470189867070)
,p_name=>'APEX.FEATURE.ACL.INFO.ALL_USERS'
,p_message_language=>'fr'
,p_message_text=>unistr('Tous les utilisateurs authentifi\00E9s peuvent acc\00E9der \00E0 cette application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277526040457867425)
,p_name=>'APEX.FEATURE.CONFIG.DISABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactiv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277525951862867425)
,p_name=>'APEX.FEATURE.CONFIG.ENABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('Activ\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277527076431867426)
,p_name=>'APEX.FEATURE.CONFIG.IS_DISABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 : est d\00E9sactiv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277526189698867425)
,p_name=>'APEX.FEATURE.CONFIG.IS_ENABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 : est activ\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276915773852867029)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_language=>'fr'
,p_message_text=>'Mis en file d''attente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276915800644867029)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Envoy\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277525839183867425)
,p_name=>'APEX.FEATURE.TOP_USERS.USERNAME.NOT_IDENTIFIED'
,p_message_language=>'fr'
,p_message_text=>unistr('non identifi\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276379486807866682)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es d''informations en retour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276379555672866682)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es d''informations en retour ouvertes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276379652145866682)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_language=>'fr'
,p_message_text=>'Utilisateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277269451177867259)
,p_name=>'APEX.FILE_BROWSE.DOWNLOAD_LINK_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9charger en local')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277262680872867254)
,p_name=>'APEX.FS.BATCH_APPLY'
,p_message_language=>'fr'
,p_message_text=>'Appliquer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277263164045867255)
,p_name=>'APEX.FS.CLEAR'
,p_message_language=>'fr'
,p_message_text=>'Effacer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277263247251867255)
,p_name=>'APEX.FS.CLEAR_ALL'
,p_message_language=>'fr'
,p_message_text=>'Tout effacer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277263361807867255)
,p_name=>'APEX.FS.CLEAR_VALUE'
,p_message_language=>'fr'
,p_message_text=>'Effacer %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277593907419867469)
,p_name=>'APEX.FS.COLUMN_UNAUTHORIZED'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne %1, r\00E9f\00E9renc\00E9e par le facet %0, n''est pas disponible ou n''est pas autoris\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277586312055867464)
,p_name=>'APEX.FS.FACET_VALUE_LIMIT_EXCEEDED'
,p_message_language=>'fr'
,p_message_text=>unistr('Limite de valeur distincte (%0) d\00E9pass\00E9e pour le facet %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277264848907867256)
,p_name=>'APEX.FS.FC_TYPE_UNSUPPORTED_FOR_DATE_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Le facet %0 n''est pas pris en charge pour les colonnes de type DATE ou TIMESTAMP.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277262784296867254)
,p_name=>'APEX.FS.FILTER'
,p_message_language=>'fr'
,p_message_text=>'Filtrer %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277262891167867255)
,p_name=>'APEX.FS.GO'
,p_message_language=>'fr'
,p_message_text=>'OK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277264490144867256)
,p_name=>'APEX.FS.INPUT_CURRENT_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('est \00E9gal \00E0 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277264698601867256)
,p_name=>'APEX.FS.NO_SEARCH_COLUMNS_PROVIDED'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune colonne de recherche n''a \00E9t\00E9 fournie pour le facet %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277264176022867255)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 \00E0 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277264250777867256)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_HI'
,p_message_language=>'fr'
,p_message_text=>'Au-dessus de %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277264399222867256)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_LO'
,p_message_language=>'fr'
,p_message_text=>'En dessous de %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277604739640867475)
,p_name=>'APEX.FS.RANGE_LOV_ITEM_INVALID'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment de liste de valeurs (LOV) #%2 ("%1") du facet de plage %0 n''est pas valide (s\00E9parateur "|" manquant).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277264581922867256)
,p_name=>'APEX.FS.RANGE_MANUAL_NOT_SUPPORTED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''entr\00E9e manuelle n''est actuellement pas prise en charge pour le facet de plage %0, car la colonne est de type DATE ou TIMESTAMP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277263761436867255)
,p_name=>'APEX.FS.RANGE_TEXT'
,p_message_language=>'fr'
,p_message_text=>'vers'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277263015986867255)
,p_name=>'APEX.FS.SEARCH_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Rechercher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277262976704867255)
,p_name=>'APEX.FS.SEARCH_PLACEHOLDER'
,p_message_language=>'fr'
,p_message_text=>'Rechercher...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277263925704867255)
,p_name=>'APEX.FS.SELECT_PLACEHOLDER'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277263504917867255)
,p_name=>'APEX.FS.SHOW_LESS'
,p_message_language=>'fr'
,p_message_text=>'Afficher moins'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277263612235867255)
,p_name=>'APEX.FS.SHOW_MORE'
,p_message_language=>'fr'
,p_message_text=>'Afficher plus'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277263854333867255)
,p_name=>'APEX.FS.STAR_RATING_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 \00E9toiles et plus')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277264763504867256)
,p_name=>'APEX.FS.TEXT_FIELD_ONLY_FOR_NUMBER_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Le facet de champ de texte %0 n''est actuellement pris en charge que pour les colonnes de type NUMBER.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277594195959867469)
,p_name=>'APEX.FS.UNSUPPORTED_DATA_TYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Le type de donn\00E9es %0 (%1) n''est pas pris en charge pour la recherche \00E0 facets.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277527658661867426)
,p_name=>'APEX.GO_TO_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9der \00E0 l''erreur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276740516013866917)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>'Groupe "%0" introuvable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276986475444867074)
,p_name=>'APEX.GV.AGG_CONTEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Agr\00E9ger.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277095062139867146)
,p_name=>'APEX.GV.BREAK_COLLAPSE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9duire la commande BREAK')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276986577672867074)
,p_name=>'APEX.GV.BREAK_CONTEXT'
,p_message_language=>'fr'
,p_message_text=>'Commande BREAK.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277094904215867146)
,p_name=>'APEX.GV.BREAK_EXPAND'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9velopper la commande BREAK')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277724253740867553)
,p_name=>'APEX.GV.COLUMN_CONTEXT'
,p_message_language=>'fr'
,p_message_text=>'Colonne %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277094715923867146)
,p_name=>'APEX.GV.DELETED_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 lignes supprim\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277683787782867527)
,p_name=>'APEX.GV.DUP_REC_ID'
,p_message_language=>'fr'
,p_message_text=>unistr('Dupliquer l''identit\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276973418186867066)
,p_name=>'APEX.GV.FIRST_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Premier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276986733609867074)
,p_name=>'APEX.GV.GROUP_CONTEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('En-t\00EAte de groupe.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276986678143867074)
,p_name=>'APEX.GV.HEADER_CONTEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('En-t\00EAte .')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276973580076867066)
,p_name=>'APEX.GV.LAST_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Dernier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277135330703867172)
,p_name=>'APEX.GV.LOAD_MORE'
,p_message_language=>'fr'
,p_message_text=>'Charger plus de lignes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276973298202867066)
,p_name=>'APEX.GV.NEXT_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Suivant'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276986800310867074)
,p_name=>'APEX.GV.PAGE_RANGE'
,p_message_language=>'fr'
,p_message_text=>'Lignes de page'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276973686248867066)
,p_name=>'APEX.GV.PAGE_RANGE_XY'
,p_message_language=>'fr'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276973762421867066)
,p_name=>'APEX.GV.PAGE_RANGE_XYZ'
,p_message_language=>'fr'
,p_message_text=>'%0 - %1 de %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276973383740867066)
,p_name=>'APEX.GV.PREV_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9c\00E9dent')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277683578605867527)
,p_name=>'APEX.GV.ROW_ADDED'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajout\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277683663436867527)
,p_name=>'APEX.GV.ROW_CHANGED'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifi\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277724067279867552)
,p_name=>'APEX.GV.ROW_COLUMN_CONTEXT'
,p_message_language=>'fr'
,p_message_text=>'Ligne %0, colonne %1.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277724133066867552)
,p_name=>'APEX.GV.ROW_CONTEXT'
,p_message_language=>'fr'
,p_message_text=>'Ligne %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277683413482867526)
,p_name=>'APEX.GV.ROW_DELETED'
,p_message_language=>'fr'
,p_message_text=>unistr('Supprim\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277015628924867093)
,p_name=>'APEX.GV.ROW_HEADER'
,p_message_language=>'fr'
,p_message_text=>unistr('En-t\00EAte de ligne')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276972548652867065)
,p_name=>'APEX.GV.SELECTION_CELL_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 cellules s\00E9lectionn\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276973804685867066)
,p_name=>'APEX.GV.SELECTION_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 lignes s\00E9lectionn\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277319247291867292)
,p_name=>'APEX.GV.SELECT_ALL'
,p_message_language=>'fr'
,p_message_text=>unistr('Tout s\00E9lectionner')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277094833209867146)
,p_name=>'APEX.GV.SELECT_PAGE_N'
,p_message_language=>'fr'
,p_message_text=>'Page %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277015553531867093)
,p_name=>'APEX.GV.SELECT_ROW'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionner une ligne')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277018148040867094)
,p_name=>'APEX.GV.SORTED_ASCENDING'
,p_message_language=>'fr'
,p_message_text=>unistr('Tri\00E9 par ordre croissant %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277018238889867094)
,p_name=>'APEX.GV.SORTED_DESCENDING'
,p_message_language=>'fr'
,p_message_text=>unistr('Tri\00E9 par ordre d\00E9croissant %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276972793367867065)
,p_name=>'APEX.GV.SORT_ASCENDING'
,p_message_language=>'fr'
,p_message_text=>'Trier par ordre croissant'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276973053181867065)
,p_name=>'APEX.GV.SORT_ASCENDING_ORDER'
,p_message_language=>'fr'
,p_message_text=>'Trier par ordre croissant %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276972810565867065)
,p_name=>'APEX.GV.SORT_DESCENDING'
,p_message_language=>'fr'
,p_message_text=>unistr('Trier par ordre d\00E9croissant')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276973195403867065)
,p_name=>'APEX.GV.SORT_DESCENDING_ORDER'
,p_message_language=>'fr'
,p_message_text=>unistr('Trier par ordre d\00E9croissant %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276972928377867065)
,p_name=>'APEX.GV.SORT_OFF'
,p_message_language=>'fr'
,p_message_text=>'Ne pas trier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277094662735867146)
,p_name=>'APEX.GV.TOTAL_PAGES'
,p_message_language=>'fr'
,p_message_text=>'Total %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277657996740867510)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_language=>'fr'
,p_message_text=>'Visualiser la documentation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277677465961867523)
,p_name=>'APEX.ICON_LIST.GRID_DIM'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 colonnes et %1 lignes de la liste de s\00E9lection de grille. Utiliser les touches fl\00E9ch\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277093730643867145)
,p_name=>'APEX.ICON_LIST.LIST_DIM'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 lignes de la liste de s\00E9lection. Utiliser les touches fl\00E9ch\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277723825725867552)
,p_name=>'APEX.IG.ACC_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Grille interactive %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276955923270867054)
,p_name=>'APEX.IG.ACTIONS'
,p_message_language=>'fr'
,p_message_text=>'Actions'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276956947011867055)
,p_name=>'APEX.IG.ADD'
,p_message_language=>'fr'
,p_message_text=>'Ajouter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276956899944867055)
,p_name=>'APEX.IG.ADD_ROW'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une ligne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277691516287867532)
,p_name=>'APEX.IG.AGGREGATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Agr\00E9ger')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277654413920867508)
,p_name=>'APEX.IG.AGGREGATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Agr\00E9gation')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277657415329867510)
,p_name=>'APEX.IG.ALL'
,p_message_language=>'fr'
,p_message_text=>'Tout'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277214631016867223)
,p_name=>'APEX.IG.ALL_TEXT_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Toutes les colonnes de texte'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277215853400867224)
,p_name=>'APEX.IG.ALTERNATIVE'
,p_message_language=>'fr'
,p_message_text=>'Remplacement'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277216959410867225)
,p_name=>'APEX.IG.AND'
,p_message_language=>'fr'
,p_message_text=>'et'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277562943376867449)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT'
,p_message_language=>'fr'
,p_message_text=>'Nombre approximatif de valeurs distinctes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277692570465867532)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT_OVERALL'
,p_message_language=>'fr'
,p_message_text=>'Nombre approximatif global de valeurs distinctes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277650557055867505)
,p_name=>'APEX.IG.AREA'
,p_message_language=>'fr'
,p_message_text=>'En aires'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277656057375867509)
,p_name=>'APEX.IG.ASCENDING'
,p_message_language=>'fr'
,p_message_text=>'Croissant'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277215931780867224)
,p_name=>'APEX.IG.AUTHORIZATION'
,p_message_language=>'fr'
,p_message_text=>'Autorisation'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277691645447867532)
,p_name=>'APEX.IG.AUTO'
,p_message_language=>'fr'
,p_message_text=>'Auto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277563386940867449)
,p_name=>'APEX.IG.AVG'
,p_message_language=>'fr'
,p_message_text=>'Moyenne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277692291745867532)
,p_name=>'APEX.IG.AVG_OVERALL'
,p_message_language=>'fr'
,p_message_text=>'Moyenne globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277650022922867505)
,p_name=>'APEX.IG.AXIS_LABEL_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Titre d''axe de libell\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277650216096867505)
,p_name=>'APEX.IG.AXIS_VALUE_DECIMAL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9cimales')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277650185738867505)
,p_name=>'APEX.IG.AXIS_VALUE_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Titre d''axe de valeur'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277664200973867514)
,p_name=>'APEX.IG.BACKGROUND_COLOR'
,p_message_language=>'fr'
,p_message_text=>unistr('Couleur d''arri\00E8re-plan')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277650680439867505)
,p_name=>'APEX.IG.BAR'
,p_message_language=>'fr'
,p_message_text=>'Barre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277198367764867213)
,p_name=>'APEX.IG.BETWEEN'
,p_message_language=>'fr'
,p_message_text=>'entre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277665934181867515)
,p_name=>'APEX.IG.BOTH'
,p_message_language=>'fr'
,p_message_text=>'Les deux'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277650744339867505)
,p_name=>'APEX.IG.BUBBLE'
,p_message_language=>'fr'
,p_message_text=>'Bulle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276957167518867055)
,p_name=>'APEX.IG.CANCEL'
,p_message_language=>'fr'
,p_message_text=>'Annuler'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277216829260867225)
,p_name=>'APEX.IG.CASE_SENSITIVE'
,p_message_language=>'fr'
,p_message_text=>'Distinction maj/min'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277693118980867533)
,p_name=>'APEX.IG.CASE_SENSITIVE_WITH_BRACKETS'
,p_message_language=>'fr'
,p_message_text=>'(Distinction maj/min)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277602695010867474)
,p_name=>'APEX.IG.CHANGES_SAVED'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifications enregistr\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276957554398867055)
,p_name=>'APEX.IG.CHANGE_VIEW'
,p_message_language=>'fr'
,p_message_text=>'Modifier la vue'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277217913615867225)
,p_name=>'APEX.IG.CHART'
,p_message_language=>'fr'
,p_message_text=>'Graphique'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277213350881867223)
,p_name=>'APEX.IG.CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre requ\00EAte d\00E9passe la valeur maximale de %0 points de donn\00E9es par graphique. Appliquez un filtre pour r\00E9duire le nombre d''enregistrements dans votre requ\00EAte de base.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276955891020867054)
,p_name=>'APEX.IG.CHART_VIEW'
,p_message_language=>'fr'
,p_message_text=>'Vue graphique'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277019165102867095)
,p_name=>'APEX.IG.CLEAR'
,p_message_language=>'fr'
,p_message_text=>'Effacer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277649534158867504)
,p_name=>'APEX.IG.CLOSE_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Fermer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277664917957867514)
,p_name=>'APEX.IG.COLORS'
,p_message_language=>'fr'
,p_message_text=>'Couleurs'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277664808542867514)
,p_name=>'APEX.IG.COLOR_BLUE'
,p_message_language=>'fr'
,p_message_text=>'Bleu'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277664767700867514)
,p_name=>'APEX.IG.COLOR_GREEN'
,p_message_language=>'fr'
,p_message_text=>'Vert'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277664576988867514)
,p_name=>'APEX.IG.COLOR_ORANGE'
,p_message_language=>'fr'
,p_message_text=>'Orange'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277664668716867514)
,p_name=>'APEX.IG.COLOR_RED'
,p_message_language=>'fr'
,p_message_text=>'Rouge'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277664438294867514)
,p_name=>'APEX.IG.COLOR_YELLOW'
,p_message_language=>'fr'
,p_message_text=>'Jaune'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277216232588867224)
,p_name=>'APEX.IG.COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276956006993867054)
,p_name=>'APEX.IG.COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277669764312867518)
,p_name=>'APEX.IG.COLUMN_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Objectif de la colonne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277216322877867224)
,p_name=>'APEX.IG.COMPLEX'
,p_message_language=>'fr'
,p_message_text=>'Complexe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276956202926867055)
,p_name=>'APEX.IG.COMPUTE'
,p_message_language=>'fr'
,p_message_text=>'Calculer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277198927969867213)
,p_name=>'APEX.IG.CONTAINS'
,p_message_language=>'fr'
,p_message_text=>'contient'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277222286328867228)
,p_name=>'APEX.IG.CONTROL_BREAK'
,p_message_language=>'fr'
,p_message_text=>'Commande BREAK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277018960468867095)
,p_name=>'APEX.IG.COPY_CB'
,p_message_language=>'fr'
,p_message_text=>'Copier dans le presse-papiers'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277019044680867095)
,p_name=>'APEX.IG.COPY_DOWN'
,p_message_language=>'fr'
,p_message_text=>'Copier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277562738891867449)
,p_name=>'APEX.IG.COUNT'
,p_message_language=>'fr'
,p_message_text=>'Nombre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277562879174867449)
,p_name=>'APEX.IG.COUNT_DISTINCT'
,p_message_language=>'fr'
,p_message_text=>'Nombre de valeurs distinctes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277692474330867532)
,p_name=>'APEX.IG.COUNT_DISTINCT_OVERALL'
,p_message_language=>'fr'
,p_message_text=>'Nombre global de valeurs distinctes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277692345264867532)
,p_name=>'APEX.IG.COUNT_OVERALL'
,p_message_language=>'fr'
,p_message_text=>'Nombre global'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277683805316867527)
,p_name=>'APEX.IG.CREATE_X'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277214819696867223)
,p_name=>'APEX.IG.DATA'
,p_message_language=>'fr'
,p_message_text=>unistr('Donn\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277667128440867516)
,p_name=>'APEX.IG.DATA_TYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Type de donn\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277666142188867515)
,p_name=>'APEX.IG.DATE'
,p_message_language=>'fr'
,p_message_text=>'Date'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277602487552867474)
,p_name=>'APEX.IG.DATE_INVALID_VALUE'
,p_message_language=>'fr'
,p_message_text=>'Valeur de date non valide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277199894392867214)
,p_name=>'APEX.IG.DAYS'
,p_message_language=>'fr'
,p_message_text=>'jours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277215536193867224)
,p_name=>'APEX.IG.DEFAULT_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres par d\00E9faut')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277215347760867224)
,p_name=>'APEX.IG.DEFAULT_TYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Type par d\00E9faut')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276957004041867055)
,p_name=>'APEX.IG.DELETE'
,p_message_language=>'fr'
,p_message_text=>'Supprimer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277670744531867518)
,p_name=>'APEX.IG.DELETE_REPORT_CONFIRM'
,p_message_language=>'fr'
,p_message_text=>unistr('Voulez-vous supprimer cet \00E9tat ?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277224037857867229)
,p_name=>'APEX.IG.DELETE_ROW'
,p_message_language=>'fr'
,p_message_text=>'Supprimer une ligne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277222876971867229)
,p_name=>'APEX.IG.DELETE_ROWS'
,p_message_language=>'fr'
,p_message_text=>'Supprimer des lignes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277656129498867509)
,p_name=>'APEX.IG.DESCENDING'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9croissant')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277217637651867225)
,p_name=>'APEX.IG.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9tail')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276955549682867054)
,p_name=>'APEX.IG.DETAIL_VIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Vue d\00E9tail')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277618379644867484)
,p_name=>'APEX.IG.DIRECTION'
,p_message_language=>'fr'
,p_message_text=>'Direction'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277217380502867225)
,p_name=>'APEX.IG.DISABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactiv\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277199039067867213)
,p_name=>'APEX.IG.DOES_NOT_CONTAIN'
,p_message_language=>'fr'
,p_message_text=>'ne contient pas'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277199269053867213)
,p_name=>'APEX.IG.DOES_NOT_START_WITH'
,p_message_language=>'fr'
,p_message_text=>'ne commence pas par'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277650871645867505)
,p_name=>'APEX.IG.DONUT'
,p_message_language=>'fr'
,p_message_text=>'Anneau'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277222414563867228)
,p_name=>'APEX.IG.DOWNLOAD'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9charger en local')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277671771293867519)
,p_name=>'APEX.IG.DOWNLOAD_FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Choisir un format'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277657085461867509)
,p_name=>'APEX.IG.DUPLICATE_AGGREGATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Dupliquer l''agr\00E9gation')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277657157556867509)
,p_name=>'APEX.IG.DUPLICATE_CONTROLBREAK'
,p_message_language=>'fr'
,p_message_text=>'Dupliquer la commande BREAK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277223936118867229)
,p_name=>'APEX.IG.DUPLICATE_ROW'
,p_message_language=>'fr'
,p_message_text=>'Ligne en double'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277222716510867229)
,p_name=>'APEX.IG.DUPLICATE_ROWS'
,p_message_language=>'fr'
,p_message_text=>'Lignes en double'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276956696503867055)
,p_name=>'APEX.IG.EDIT'
,p_message_language=>'fr'
,p_message_text=>'Modifier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277655555109867508)
,p_name=>'APEX.IG.EDIT_CHART'
,p_message_language=>'fr'
,p_message_text=>'Modifier un graphique'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277679578041867524)
,p_name=>'APEX.IG.EDIT_GROUP_BY'
,p_message_language=>'fr'
,p_message_text=>'Modifier le groupement'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277671357056867519)
,p_name=>'APEX.IG.EMAIL_BCC'
,p_message_language=>'fr'
,p_message_text=>'Copie conforme invisible (Cci)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277671538718867519)
,p_name=>'APEX.IG.EMAIL_BODY'
,p_message_language=>'fr'
,p_message_text=>'Message'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277671219869867519)
,p_name=>'APEX.IG.EMAIL_CC'
,p_message_language=>'fr'
,p_message_text=>'Copie (Cc)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277670965447867518)
,p_name=>'APEX.IG.EMAIL_SENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Courriel envoy\00E9.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277671487534867519)
,p_name=>'APEX.IG.EMAIL_SUBJECT'
,p_message_language=>'fr'
,p_message_text=>'Objet'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277671141626867519)
,p_name=>'APEX.IG.EMAIL_TO'
,p_message_language=>'fr'
,p_message_text=>'Destinataire (A)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277217046495867225)
,p_name=>'APEX.IG.ENABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('Activ\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277197372822867212)
,p_name=>'APEX.IG.EQUALS'
,p_message_language=>'fr'
,p_message_text=>unistr('est \00E9gal \00E0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277670348592867518)
,p_name=>'APEX.IG.EXAMPLE'
,p_message_language=>'fr'
,p_message_text=>'Exemple'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277217151292867225)
,p_name=>'APEX.IG.EXPRESSION'
,p_message_language=>'fr'
,p_message_text=>'Expression'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277670211973867518)
,p_name=>'APEX.IG.FD_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277319159031867291)
,p_name=>'APEX.IG.FILE_PREPARED'
,p_message_language=>'fr'
,p_message_text=>unistr('Fichier pr\00E9par\00E9. D\00E9marrage du t\00E9l\00E9chargement.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277019280543867095)
,p_name=>'APEX.IG.FILL'
,p_message_language=>'fr'
,p_message_text=>'Remplir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277040632336867110)
,p_name=>'APEX.IG.FILL_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Remplir la s\00E9lection avec')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277040500797867110)
,p_name=>'APEX.IG.FILL_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Remplir la s\00E9lection')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276956197262867055)
,p_name=>'APEX.IG.FILTER'
,p_message_language=>'fr'
,p_message_text=>'Filtrer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277216479833867224)
,p_name=>'APEX.IG.FILTERS'
,p_message_language=>'fr'
,p_message_text=>'Filtres'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277691986918867532)
,p_name=>'APEX.IG.FILTER_WITH_DOTS'
,p_message_language=>'fr'
,p_message_text=>'Filtrer...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277656380268867509)
,p_name=>'APEX.IG.FIRST'
,p_message_language=>'fr'
,p_message_text=>'Premier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276956305297867055)
,p_name=>'APEX.IG.FLASHBACK'
,p_message_language=>'fr'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277214963836867224)
,p_name=>'APEX.IG.FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Format'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277665859345867515)
,p_name=>'APEX.IG.FORMATMASK'
,p_message_language=>'fr'
,p_message_text=>'Masque de format'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277670676890867518)
,p_name=>'APEX.IG.FORMAT_CSV'
,p_message_language=>'fr'
,p_message_text=>'CSV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277670516523867518)
,p_name=>'APEX.IG.FORMAT_HTML'
,p_message_language=>'fr'
,p_message_text=>'HTML'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277223696567867229)
,p_name=>'APEX.IG.FREEZE'
,p_message_language=>'fr'
,p_message_text=>'Figer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277217259769867225)
,p_name=>'APEX.IG.FUNCTIONS_AND_OPERATORS'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctions et op\00E9rateurs')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277650997392867505)
,p_name=>'APEX.IG.FUNNEL'
,p_message_language=>'fr'
,p_message_text=>'En entonnoir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277562665447867449)
,p_name=>'APEX.IG.GO'
,p_message_language=>'fr'
,p_message_text=>'OK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277197977386867212)
,p_name=>'APEX.IG.GREATER_THAN'
,p_message_language=>'fr'
,p_message_text=>unistr('sup\00E9rieur \00E0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277198089416867213)
,p_name=>'APEX.IG.GREATER_THAN_OR_EQUALS'
,p_message_language=>'fr'
,p_message_text=>unistr('sup\00E9rieur ou \00E9gal \00E0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277217579744867225)
,p_name=>'APEX.IG.GRID'
,p_message_language=>'fr'
,p_message_text=>'Grille'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276955334442867054)
,p_name=>'APEX.IG.GRID_VIEW'
,p_message_language=>'fr'
,p_message_text=>'Grille'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277657351183867510)
,p_name=>'APEX.IG.GROUP'
,p_message_language=>'fr'
,p_message_text=>'Groupe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277217758112867225)
,p_name=>'APEX.IG.GROUP_BY'
,p_message_language=>'fr'
,p_message_text=>'Grouper par'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276955683819867054)
,p_name=>'APEX.IG.GROUP_BY_VIEW'
,p_message_language=>'fr'
,p_message_text=>'Vue Grouper par'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277666463363867515)
,p_name=>'APEX.IG.HD_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type de condition'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277665398918867515)
,p_name=>'APEX.IG.HEADING'
,p_message_language=>'fr'
,p_message_text=>unistr('En-t\00EAte')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277665555076867515)
,p_name=>'APEX.IG.HEADING_ALIGN'
,p_message_language=>'fr'
,p_message_text=>unistr('Alignement d''en-t\00EAte')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277691818405867532)
,p_name=>'APEX.IG.HELP'
,p_message_language=>'fr'
,p_message_text=>'Aide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277677615646867523)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Vous pouvez ins\00E9rer, mettre \00E0 jour et supprimer des donn\00E9es directement dans cette grille interactive.</p>'),
'',
unistr('<p>Ins\00E9rez une nouvelle ligne en cliquant sur le bouton Ajouter une ligne.</p>'),
'',
unistr('<p>Modifiez des donn\00E9es existantes en double-cliquant sur une cellule sp\00E9cifique. Pour effectuer des modifications plus importantes, cliquez sur Modifier pour entrer en mode \00E9dition. Dans ce mode, vous pouvez effectuer un seul clic ou utiliser le cla')
||unistr('vier pour modifier des cellules sp\00E9cifiques.</p>'),
'',
unistr('<p>Utilisez le menu Modifier pour dupliquer et supprimer des lignes. Pour activer le menu Modifier, utilisez les cases \00E0 cocher pour s\00E9lectionner des lignes.</p>'),
'',
unistr('<p>Dupliquez une ligne s\00E9lectionn\00E9e en cliquant sur le menu Modifier et en s\00E9lectionnant Lignes en double. Supprimez une ligne s\00E9lectionn\00E9e en cliquant sur le menu Modifier et en s\00E9lectionnant Supprimer une ligne.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277680043204867524)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING_HEADING'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctionnalit\00E9s de modification')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277680108033867524)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Une grille interactive pr\00E9sente un ensemble de donn\00E9es dans un \00E9tat pouvant faire l''objet d''une recherche et d''une personnalisation. Vous pouvez effectuer de nombreuses op\00E9rations pour limiter les enregistrements renvoy\00E9s et modifier la fa\00E7on dont')
||unistr(' les donn\00E9es sont affich\00E9es.</p>'),
'',
unistr('<p>Utilisez le champ de recherche pour filtrer les enregistrements renvoy\00E9s. Cliquez sur Actions pour acc\00E9der aux nombreuses options de modification de la mise en page de l''\00E9tat, ou utilisez les menus d''en-t\00EAte de colonne sur les colonnes affich\00E9es.<')
||'/p>',
'',
unistr('<p>Utilisez les param\00E8tres d''\00E9tat pour enregistrer les personnalisations d''un \00E9tat. Vous pouvez \00E9galement t\00E9l\00E9charger les donn\00E9es de l''\00E9tat vers un fichier externe, ou les envoyer par courriel \00E0 vous-m\00EAme ou \00E0 d''autres utilisateurs.</p>'),
'',
unistr('<p>Pour en savoir plus, reportez-vous \00E0 "Using Interactive Grids" dans le manuel <em>Oracle Application Express End User''s Guide</em>.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277679868869867524)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO_HEADING'
,p_message_language=>'fr'
,p_message_text=>unistr('Aper\00E7u')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277677541429867523)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Vous pouvez personnaliser la grille interactive de sorte qu''elle affiche les donn\00E9es de diverses fa\00E7ons \00E0 l''aide de capacit\00E9s int\00E9gr\00E9es.</p>'),
'',
unistr('<p>Utilisez les menus d''en-t\00EAte de colonne ou le menu Actions pour d\00E9terminer les colonnes \00E0 afficher, dans quel ordre, et pour figer les colonnes. Vous pouvez \00E9galement d\00E9finir divers filtres de donn\00E9es et trier les donn\00E9es renvoy\00E9es.</p>'),
'',
unistr('<p>Utilisez le bouton Vue (adjacent au champ de recherche) pour acc\00E9der \00E0 d''autres vues de donn\00E9es qui peuvent avoir \00E9t\00E9 d\00E9finies par le d\00E9veloppeur d''application. Vous pouvez \00E9galement cr\00E9er un graphique ou visualiser un graphique existant.</p>  '),
'',
unistr('<p><em>Remarque : cliquez sur <strong>Aide</strong> dans les bo\00EEtes de dialogue de la grille interactive pour obtenir des informations plus d\00E9taill\00E9es sur la fonction s\00E9lectionn\00E9e.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277679925162867524)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING_HEADING'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctionnalit\00E9s de g\00E9n\00E9ration d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277222613768867229)
,p_name=>'APEX.IG.HELP.ACTIONS_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Aide de la grille interactive'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277674500483867521)
,p_name=>'APEX.IG.HELP.AGGREGATE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour agr\00E9ger des colonnes. Les valeurs agr\00E9g\00E9es s''affichent en bas des donn\00E9es ou, si des commandes BREAK sont d\00E9finies, en bas de chaque commande.</p>'),
'',
unistr('<p><strong>Liste Agr\00E9gation</strong><br>'),
unistr('La liste Agr\00E9gation affiche les agr\00E9gations d\00E9finies. D\00E9sactivez une agr\00E9gation existante en la d\00E9s\00E9lectionnant.<br>'),
unistr('Cliquez sur Ajouter ( &plus; ) pour cr\00E9er une agr\00E9gation ou sur Supprimer ( &minus; ) pour enlever une agr\00E9gation existante.</p>'),
'',
unistr('<p><strong>Param\00E8tres d''agr\00E9gation</strong><br>'),
unistr('Utilisez le panneau \00E0 droite pour d\00E9finir l''agr\00E9gation.<br>'),
unistr('S\00E9lectionnez le nom de colonne et le type d''agr\00E9gation.<br>'),
unistr('Saisissez \00E9ventuellement une info-bulle pour l''agr\00E9gation.<br>'),
unistr('Si vous avez d\00E9fini une commande BREAK, la s\00E9lection de <strong>Afficher la valeur globale</strong> affiche la moyenne globale, le total ou une valeur similaire en bas des donn\00E9es.</p>'),
'',
unistr('<p><em>Remarque : acc\00E9dez \00E0 la bo\00EEte de dialogue Agr\00E9gation dans le menu Actions ou en cliquant sur l''en-t\00EAte de colonne et la somme ( &sum; ).</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277678974066867524)
,p_name=>'APEX.IG.HELP.AGGREGATE_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Aide sur l''agr\00E9gation')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277675274207867521)
,p_name=>'APEX.IG.HELP.CHART'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour d\00E9finir un graphique qui s''affiche comme une vue de donn\00E9es distincte.<br> '),
unistr('S\00E9lectionnez un type de graphique, configurez ses param\00E8tres et cliquez sur <strong>Enregistrer.</strong></p>'),
'',
unistr('<p><strong>Param\00E8tres de graphique</strong></br>'),
unistr('Les attributs de graphique qui s''affichent varient selon le type de graphique. De nombreux attributs peuvent \00EAtre saisis pour d\00E9finir le graphique. Les attributs marqu\00E9s d''un ast\00E9risque rouge sont obligatoires.</p>'),
'',
unistr('<p>Ci-dessous figurent tous les attributs disponibles dans les diff\00E9rents types de graphique (par ordre alphab\00E9tique) :'),
'<ul>',
unistr('  <li>Agr\00E9gation : s\00E9lectionnez le mode d''agr\00E9gation des valeurs de graphique associ\00E9es.</li> '),
unistr('  <li>Fermeture : s\00E9lectionnez la colonne qui contient le prix de cl\00F4ture boursi\00E8re quotidien (graphique boursier uniquement).</li> '),
unistr('  <li>D\00E9cimales : entrez le nombre de d\00E9cimales auxquelles les valeurs sont arrondies.</li> '),
unistr('  <li>Direction : relatif \00E0 l''attribut Trier par, indiquez si les donn\00E9es sont tri\00E9es par ordre croissant ou d\00E9croissant de valeurs.</li> '),
unistr('  <li>Elev\00E9 : s\00E9lectionnez la colonne qui contient la valeur \00E9lev\00E9e (graphiques \00E0 plages et boursiers uniquement).</li> '),
unistr('  <li>Libell\00E9 : s\00E9lectionnez la colonne qui contient le texte pour chaque point de donn\00E9es.</li> '),
unistr('  <li>Titre de l''axe de libell\00E9 : entrez le titre qui s''affiche sur l''axe de libell\00E9.</li> '),
unistr('  <li>Faible : s\00E9lectionnez la colonne qui contient la valeur basse (graphiques \00E0 plages et boursiers uniquement).</li> '),
unistr('  <li>Valeurs Null : relatif \00E0 l''attribut Trier par, indiquez la fa\00E7on dont vous voulez que les enregistrements avec des valeurs Null soient tri\00E9s par rapport aux enregistrements avec des valeurs non NULL.</li> '),
unistr('  <li>Ouverture : s\00E9lectionnez la colonne qui contiennent le prix d''ouverture boursi\00E8re quotidien (graphique boursier uniquement).</li> '),
unistr('  <li>Orientation : d\00E9terminez si les \00E9l\00E9ments de graphique, tels que les barres, s''affichent verticalement ou horizontalement.</li> '),
unistr('  <li>S\00E9rie : s\00E9lectionnez la colonne utilis\00E9e pour d\00E9finir votre requ\00EAte dynamique \00E0 plusieurs s\00E9ries.</li> '),
unistr('  <li>Pile : indiquez si les \00E9l\00E9ments de donn\00E9es sont empil\00E9s.</li> '),
unistr('  <li>Trier par : d\00E9terminez si le graphique est tri\00E9 par libell\00E9 ou valeur.</li> '),
unistr('  <li>Cible : s\00E9lectionnez la colonne utilis\00E9e pour d\00E9finir la valeur cible sur ce graphique. Lorsqu''elle est d\00E9finie, l''attribut Valeur d\00E9finit la zone remplie dans le secteur, la cible repr\00E9sentant la valeur du secteur entier (graphique en entonnoi')
||'r uniquement).</li> ',
unistr('  <li>Valeur : s\00E9lectionnez la colonne qui contient les donn\00E9es \00E0 tracer.</li> '),
'  <li>Titre de l''axe de valeur : entrez le titre qui s''affiche sur l''axe de valeur.</li> ',
unistr('  <li>Volume : s\00E9lectionnez la colonne qui contient le volume boursier quotidien (graphique boursier uniquement).</li> '),
unistr('  <li>X : s\00E9lectionnez la colonne qui contient la valeur de l''axe des X pour ce graphique (graphiques \00E0 bulles et en nuage de points uniquement).</li> '),
unistr('  <li>Y : s\00E9lectionnez la colonne qui contient la valeur de l''axe de Y pour ce graphique (graphiques \00E0 bulles et en nuage de points uniquement).</li> '),
unistr('  <li>Z : s\00E9lectionnez la colonne qui contient la largeur des barres ou le rayon des bulles (graphiques \00E0 barres, \00E0 bulles et \00E0 plages uniquement).</li> '),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277679312039867524)
,p_name=>'APEX.IG.HELP.CHART_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Aide sur le graphique'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277674265671867520)
,p_name=>'APEX.IG.HELP.COLUMNS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour d\00E9terminer les colonnes \00E0 afficher et leur ordre d''affichage.</p>'),
'',
unistr('<p>Masquez une colonne en la d\00E9s\00E9lectionnant.<br>'),
unistr('R\00E9organisez les colonnes en cliquant sur D\00E9placer vers le haut ( &uarr; ) ou D\00E9placer vers le bas ( &darr; ).<br>'),
unistr('Utilisez le s\00E9lecteur d\00E9roulant pour r\00E9pertorier toutes les colonnes, les colonnes affich\00E9es ou les colonnes non affich\00E9es.</p>'),
'',
unistr('<p>Utilisez \00E9ventuellement le panneau pour indiquer la largeur minimale d''une colonne en pixels.</p>'),
'',
unistr('<p><em>Remarque : vous pouvez \00E9galement r\00E9organiser les colonnes affich\00E9es en cliquant sur la poign\00E9e de glissement (au d\00E9but de l''en-t\00EAte de colonne) et en d\00E9pla\00E7ant la colonne \00E0 gauche ou \00E0 droite. Vous pouvez \00E9galement modifier la largeur des colo')
||unistr('nnes affich\00E9es en s\00E9lectionnant le s\00E9parateur de colonnes, entre les en-t\00EAtes, et en le d\00E9pla\00E7ant vers la gauche ou la droite.</em</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277679273705867524)
,p_name=>'APEX.IG.HELP.COLUMNS_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Aide sur les colonnes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277674605961867521)
,p_name=>'APEX.IG.HELP.COMPUTE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour d\00E9finir des colonnes suppl\00E9mentaires en fonction des calculs math\00E9matiques et fonctionnels r\00E9alis\00E9s par rapport aux colonnes existantes.</p>'),
'',
'<p><strong>Liste Calcul</strong><br>',
unistr('La liste Calcul affiche les calculs d\00E9finis. D\00E9sactivez un calcul existant en le d\00E9s\00E9lectionnant.<br>'),
'Cliquez sur Ajouter ( &plus; ) pour ajouter un nouveau calcul ou sur Supprimer ( &minus; ) pour enlever un calcul existant.</p>',
'',
unistr('<p><strong>Param\00E8tres de calcul</strong><br>'),
unistr('Utilisez le panneau pour d\00E9finir le calcul.<br>'),
unistr('Entrez les d\00E9tails de colonne, tels qu''un en-t\00EAte ou un libell\00E9, et s\00E9lectionnez des param\00E8tres d''alignement.<br> '),
unistr('Utilisez la zone de texte Expression pour entrer les colonnes et les fonctions associ\00E9es pour le calcul.<br>'),
unistr('S\00E9lectionnez le type de donn\00E9es ad\00E9quat et \00E9ventuellement un masque de format pour la nouvelle colonne.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277678867105867524)
,p_name=>'APEX.IG.HELP.COMPUTE_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Aide sur le calcul'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277674981120867521)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour d\00E9finir une commande BREAK sur des colonnes.</p>'),
'',
'<p><strong>Liste Commande BREAK</strong><br>',
unistr('La liste Commande BREAK affiche les commandes BREAK d\00E9finies. D\00E9sactivez une colonne de commande BREAK existante en la d\00E9s\00E9lectionnant.<br>'),
'Cliquez sur Ajouter ( &plus; ) pour inclure une nouvelle colonne dans la commande BREAK ou sur Supprimer ( &minus; ) pour enlever une colonne existante de la commande BREAK.<br>',
unistr('Pour r\00E9organiser les colonnes, cliquez sur D\00E9placer vers le haut ( &uarr; ) ou D\00E9placer vers le bas ( &darr; ) pour d\00E9placer la colonne s\00E9lectionn\00E9e vers le haut et vers le bas par rapport aux autres colonnes.</p>'),
'',
unistr('<p><strong>Param\00E8tres de commande BREAK</strong><br>'),
unistr('Utilisez le panneau pour d\00E9finir la colonne de commande BREAK.<br>'),
unistr('S\00E9lectionnez une colonne de commande BREAK, le sens de tri et le mode d''organisation des colonnes NULL (colonnes sans valeur).</p>'),
'',
unistr('<p><em>Remarque : lorsque vous affichez la grille interactive, vous pouvez d\00E9finir une commande BREAK en cliquant sur un en-t\00EAte de colonne et en s\00E9lectionnant l''ic\00F4ne de commande BREAK.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277678539187867523)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Aide sur les commandes BREAK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277675163604867521)
,p_name=>'APEX.IG.HELP.DOWNLOAD'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour t\00E9l\00E9charger toutes les lignes en cours vers un fichier externe. Le fichier comportera uniquement les colonnes actuellement affich\00E9es, utilisant tous les filtres et les tris appliqu\00E9s aux donn\00E9es.</p>'),
'',
unistr('<p>S\00E9lectionnez le format de fichier et cliquez sur T\00E9l\00E9charger.<br>'),
unistr('Remarque : le format CSV n''inclura pas le formatage de texte tel que les agr\00E9gats et les commandes BREAK.</p>'),
'',
unistr('<p>Pour envoyer le fichier par courriel, s\00E9lectionnez Envoyer en tant que courriel et entrez les d\00E9tails de courriel (Destinataire, Objet et Message).</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277678388574867523)
,p_name=>'APEX.IG.HELP.DOWNLOAD_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Aide sur le t\00E9l\00E9chargement')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277674309857867521)
,p_name=>'APEX.IG.HELP.FILTER'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour configurer des filtres de donn\00E9es qui limitent le nombre de lignes renvoy\00E9es.</p>'),
'',
'<p><strong>Liste Filtre</strong><br>',
unistr('La liste Filtre affiche les filtres d\00E9finis. Pour d\00E9sactiver un filtre existant, d\00E9s\00E9lectionnez-le.<br>'),
unistr('Cliquez sur Ajouter (&plus;) pour cr\00E9er un filtre ou sur Supprimer (&minus;) pour enlever un filtre existant.</p>'),
'',
unistr('<p><strong>Param\00E8tres de filtre</strong><br>'),
unistr('Utilisez le panneau pour d\00E9finir les propri\00E9t\00E9s de filtre.<br>'),
unistr('S\00E9lectionnez le type de filtre ad\00E9quat :<br>'),
'&nbsp;&nbsp;&nbsp;Ligne : filtrer sur un terme dans toute colonne filtrable.<br>',
unistr('&nbsp;&nbsp;&nbsp;Colonne : filtrer sur une colonne sp\00E9cifique avec un op\00E9rateur et une valeur indiqu\00E9s.<br>'),
'',
unistr('<p><em>Remarque : lorsque vous affichez une grille interactive, vous pouvez d\00E9finir des filtres de ligne en les saisissant directement dans le champ de recherche. Cliquez sur S\00E9lectionner les colonnes \00E0 rechercher pour limiter la recherche \00E0 une cert')
||unistr('aine colonne. Vous pouvez \00E9galement ouvrir un menu En-t\00EAte de colonne et s\00E9lectionner une valeur pour cr\00E9er un filtre de colonne.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277679133034867524)
,p_name=>'APEX.IG.HELP.FILTER_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Aide sur le filtre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277674745032867521)
,p_name=>'APEX.IG.HELP.FLASHBACK'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour visualiser les donn\00E9es telles qu''elles existaient \00E0 un moment donn\00E9.</p>'),
unistr('<p>Entrez le nombre de minutes pass\00E9es pour ex\00E9cuter la requ\00EAte Flashback.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277678715630867523)
,p_name=>'APEX.IG.HELP.FLASHBACK_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Aide sur Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277679481788867524)
,p_name=>'APEX.IG.HELP.GROUP_BY_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Aide sur le regroupement'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277674839456867521)
,p_name=>'APEX.IG.HELP.HIGHLIGHT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour mettre en \00E9vidence des lignes ou des colonnes de donn\00E9es en fonction de la condition entr\00E9e.</p>'),
'',
unistr('<p><strong>Liste Mise en \00E9vidence</strong><br>'),
unistr('La liste Mise en \00E9vidence affiche les mises en \00E9vidence d\00E9finies. Pour d\00E9sactiver une mise en \00E9vidence existante, d\00E9s\00E9lectionnez-la.<br>'),
unistr('Cliquez sur Ajouter (&plus;) pour cr\00E9er une mise en \00E9vidence ou sur Supprimer (&minus;) pour enlever une mise en \00E9vidence existante.</p>'),
'',
unistr('<p><strong>Param\00E8tres de mise en \00E9vidence</strong><br>'),
unistr('Utilisez le panneau pour d\00E9finir les propri\00E9t\00E9s de mise en \00E9vidence.<br>'),
unistr('Entrez le nom, s\00E9lectionnez Ligne ou Colonne, puis s\00E9lectionnez les codes couleur HTML pour le texte et l''arri\00E8re-plan.<br>'),
unistr('S\00E9lectionnez le <strong>type de condition</strong> ad\00E9quat pour mettre en \00E9vidence des donn\00E9es sp\00E9cifiques :<br>'),
unistr('&nbsp;&nbsp;&nbsp;Ligne : mise en \00E9vidence du terme dans toute colonne.<br>'),
unistr('&nbsp;&nbsp;&nbsp;Colonne : mise en \00E9vidence dans une colonne sp\00E9cifique selon l''op\00E9rateur et la valeur sp\00E9cifi\00E9s.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277678659654867523)
,p_name=>'APEX.IG.HELP.HIGHLIGHT_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Aide sur la mise en \00E9vidence')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277675028790867521)
,p_name=>'APEX.IG.HELP.REPORT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour enregistrer les modifications que vous avez apport\00E9es \00E0 la configuration et \00E0 la mise en page de la grille en cours.<br>'),
unistr('Les d\00E9veloppeurs d''application peuvent d\00E9finir plusieurs mises en page d''\00E9tat de remplacement. Lorsque cela est autoris\00E9, vous et d''autres utilisateurs finals pouvez enregistrer un \00E9tat comme Public, le mettant ainsi \00E0 la disposition de tous les autr')
||unistr('es utilisateurs de la grille. Vous pouvez \00E9galement enregistrer un \00E9tat comme Priv\00E9 ; vous seul pouvez alors le consulter.</p>'),
unistr('<p>Effectuez une s\00E9lection parmi les types disponibles et entrez le nom de l''\00E9tat enregistr\00E9.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277678404641867523)
,p_name=>'APEX.IG.HELP.REPORT_TITLE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Aide sur l''\00E9tat'),
''))
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277674413094867521)
,p_name=>'APEX.IG.HELP.SORT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cette bo\00EEte de dialogue pour d\00E9finir l''ordre d''affichage.</p>'),
'',
'<p><strong>Liste Trier</strong><br>',
unistr('La bo\00EEte de dialogue Trier affiche la liste des r\00E8gles de tri configur\00E9es.<br>'),
unistr('Cliquez sur Ajouter ( &plus; ) pour cr\00E9er une colonne de tri ou sur Supprimer ( &minus; ) pour enlever une colonne de tri.<br>'),
unistr('Cliquez sur D\00E9placer vers le haut ( &uarr; ) et D\00E9placer vers le bas ( &darr; ) pour d\00E9placer la colonne de tri s\00E9lectionn\00E9e vers le haut et vers le bas par rapport aux autres colonnes de tri.</p>'),
'',
unistr('<p><strong>Param\00E8tres de tri</strong><br>'),
unistr('S\00E9lectionnez une colonne de tri, le sens du tri et le mode d''organisation des colonnes NULL (colonnes sans valeur).</p>'),
'',
unistr('<p><em>Remarque : les donn\00E9es peuvent \00EAtre tri\00E9es par des colonnes qui ne sont pas affich\00E9es. Cependant, les colonnes ne sont peut-\00EAtre pas toutes triables.</em><br>'),
unistr('<em>Les colonnes affich\00E9es peuvent \00EAtre tri\00E9es en appuyant sur les fl\00E8ches vers le haut (par ordre croissant) ou vers le bas (par ordre d\00E9croissant) \00E0 la fin des en-t\00EAtes de colonne. Pour ajouter une autre colonne \00E0 un tri existant, maintenez la touc')
||unistr('he Maj enfonc\00E9e et cliquez sur la fl\00E8che vers le haut ou vers le bas.</em></p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277679039920867524)
,p_name=>'APEX.IG.HELP.SORT_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Aide sur le tri'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277678218022867523)
,p_name=>'APEX.IG.HELP.SUBSCRIPTION_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Aide sur l''abonnement'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277223534182867229)
,p_name=>'APEX.IG.HIDE'
,p_message_language=>'fr'
,p_message_text=>'Masquer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276956530886867055)
,p_name=>'APEX.IG.HIGHLIGHT'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre en \00E9vidence')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277649664947867505)
,p_name=>'APEX.IG.HIGH_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Elev\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277650456652867505)
,p_name=>'APEX.IG.HORIZONTAL'
,p_message_language=>'fr'
,p_message_text=>'Horizontal'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277199734091867214)
,p_name=>'APEX.IG.HOURS'
,p_message_language=>'fr'
,p_message_text=>'heures'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277217487658867225)
,p_name=>'APEX.IG.ICON'
,p_message_language=>'fr'
,p_message_text=>unistr('Ic\00F4ne')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276955487637867054)
,p_name=>'APEX.IG.ICON_VIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Vue ic\00F4ne')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277197718629867212)
,p_name=>'APEX.IG.IN'
,p_message_language=>'fr'
,p_message_text=>'dans'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277223113466867229)
,p_name=>'APEX.IG.INACTIVE_SETTING'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tre inactif')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277223254513867229)
,p_name=>'APEX.IG.INACTIVE_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres inactifs')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277270512770867260)
,p_name=>'APEX.IG.INTERNAL_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Une erreur interne est survenue lors du traitement de la demande de grille interactive.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277677701343867523)
,p_name=>'APEX.IG.INVALID_DATE_FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Format de date non valide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277688344129867530)
,p_name=>'APEX.IG.INVALID_SETTING'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tre non valide')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277688411808867530)
,p_name=>'APEX.IG.INVALID_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres non valides')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277664160165867514)
,p_name=>'APEX.IG.INVALID_SORT_BY'
,p_message_language=>'fr'
,p_message_text=>unistr('Trier par a \00E9t\00E9 d\00E9fini sur %0, mais aucune colonne n''a \00E9t\00E9 s\00E9lectionn\00E9e pour %0.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277657251816867509)
,p_name=>'APEX.IG.INVALID_VALUE'
,p_message_language=>'fr'
,p_message_text=>'Valeur non valide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277645425097867502)
,p_name=>'APEX.IG.INVISIBLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Non affich\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277198535386867213)
,p_name=>'APEX.IG.IN_THE_LAST'
,p_message_language=>'fr'
,p_message_text=>'au cours des'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277198775944867213)
,p_name=>'APEX.IG.IN_THE_NEXT'
,p_message_language=>'fr'
,p_message_text=>'dans'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277197692297867212)
,p_name=>'APEX.IG.IS_NOT_NULL'
,p_message_language=>'fr'
,p_message_text=>'n''est pas vide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277197599631867212)
,p_name=>'APEX.IG.IS_NULL'
,p_message_language=>'fr'
,p_message_text=>'est vide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277665414916867515)
,p_name=>'APEX.IG.LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277648962838867504)
,p_name=>'APEX.IG.LABEL_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277656438311867509)
,p_name=>'APEX.IG.LAST'
,p_message_language=>'fr'
,p_message_text=>'Dernier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277096430114867147)
,p_name=>'APEX.IG.LAST.DAY'
,p_message_language=>'fr'
,p_message_text=>'Dernier jour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277096677389867147)
,p_name=>'APEX.IG.LAST.HOUR'
,p_message_language=>'fr'
,p_message_text=>unistr('Derni\00E8re heure')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277097180450867147)
,p_name=>'APEX.IG.LAST.MINUTE'
,p_message_language=>'fr'
,p_message_text=>unistr('Derni\00E8re minute')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277096156958867147)
,p_name=>'APEX.IG.LAST.MONTH'
,p_message_language=>'fr'
,p_message_text=>'Le mois dernier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277096221946867147)
,p_name=>'APEX.IG.LAST.WEEK'
,p_message_language=>'fr'
,p_message_text=>unistr('La semaine derni\00E8re')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277096339101867147)
,p_name=>'APEX.IG.LAST.X_DAYS'
,p_message_language=>'fr'
,p_message_text=>'Les %0 derniers jours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277096544893867147)
,p_name=>'APEX.IG.LAST.X_HOURS'
,p_message_language=>'fr'
,p_message_text=>unistr('Les %0 derni\00E8res heures')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277097252528867147)
,p_name=>'APEX.IG.LAST.X_MINUTES'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 derni\00E8res minutes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277097028986867147)
,p_name=>'APEX.IG.LAST.X_MONTHS'
,p_message_language=>'fr'
,p_message_text=>'%0 derniers mois'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277096950979867147)
,p_name=>'APEX.IG.LAST.X_WEEKS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 derni\00E8res semaines')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277095904429867147)
,p_name=>'APEX.IG.LAST.X_YEARS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 derni\00E8res ann\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277096041894867147)
,p_name=>'APEX.IG.LAST.YEAR'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ann\00E9e derni\00E8re')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277665689573867515)
,p_name=>'APEX.IG.LAYOUT_ALIGN'
,p_message_language=>'fr'
,p_message_text=>'Alignement des cellules'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277665728163867515)
,p_name=>'APEX.IG.LAYOUT_USEGROUPFOR'
,p_message_language=>'fr'
,p_message_text=>'Utiliser le groupe pour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277198103889867213)
,p_name=>'APEX.IG.LESS_THAN'
,p_message_language=>'fr'
,p_message_text=>unistr('inf\00E9rieur \00E0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277198254870867213)
,p_name=>'APEX.IG.LESS_THAN_OR_EQUALS'
,p_message_language=>'fr'
,p_message_text=>unistr('inf\00E9rieur ou \00E9gal \00E0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277651006285867505)
,p_name=>'APEX.IG.LINE'
,p_message_language=>'fr'
,p_message_text=>'A courbes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277651179464867505)
,p_name=>'APEX.IG.LINE_WITH_AREA'
,p_message_language=>'fr'
,p_message_text=>'A courbes avec aires'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277666044887867515)
,p_name=>'APEX.IG.LISTAGG'
,p_message_language=>'fr'
,p_message_text=>'Listagg'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277649734336867505)
,p_name=>'APEX.IG.LOW_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Faible'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277671673674867519)
,p_name=>'APEX.IG.MAILADDRESSES_COMMASEP'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9parez les adresses par des virgules')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277199317088867213)
,p_name=>'APEX.IG.MATCHES_REGULAR_EXPRESSION'
,p_message_language=>'fr'
,p_message_text=>unistr('recherche une expression r\00E9guli\00E8re')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277563236415867449)
,p_name=>'APEX.IG.MAX'
,p_message_language=>'fr'
,p_message_text=>'Maximum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277692789145867533)
,p_name=>'APEX.IG.MAX_OVERALL'
,p_message_language=>'fr'
,p_message_text=>'Maximum global'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277563483709867449)
,p_name=>'APEX.IG.MEDIAN'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9diane')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277692878299867533)
,p_name=>'APEX.IG.MEDIAN_OVERALL'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9diane globale')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277563145361867449)
,p_name=>'APEX.IG.MIN'
,p_message_language=>'fr'
,p_message_text=>'Minimum'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277199680644867214)
,p_name=>'APEX.IG.MINUTES'
,p_message_language=>'fr'
,p_message_text=>'minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277564965507867450)
,p_name=>'APEX.IG.MINUTES_AGO'
,p_message_language=>'fr'
,p_message_text=>'Minutes auparavant'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277692686323867532)
,p_name=>'APEX.IG.MIN_OVERALL'
,p_message_language=>'fr'
,p_message_text=>'Minimum global'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277200275650867214)
,p_name=>'APEX.IG.MONTHS'
,p_message_language=>'fr'
,p_message_text=>'mois'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277223463758867229)
,p_name=>'APEX.IG.MORE_DATA_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Les donn\00E9es contiennent plus de %0 lignes, ce qui d\00E9passe le nombre maximal autoris\00E9. Appliquez des filtres suppl\00E9mentaires pour visualiser les r\00E9sultats.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277215496114867224)
,p_name=>'APEX.IG.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277215616480867224)
,p_name=>'APEX.IG.NAMED_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat nomm\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277095392982867146)
,p_name=>'APEX.IG.NEXT.DAY'
,p_message_language=>'fr'
,p_message_text=>'Jour suivant'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277095179336867146)
,p_name=>'APEX.IG.NEXT.HOUR'
,p_message_language=>'fr'
,p_message_text=>'Heure suivante'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277097390560867147)
,p_name=>'APEX.IG.NEXT.MINUTE'
,p_message_language=>'fr'
,p_message_text=>'Prochaine minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277095691627867146)
,p_name=>'APEX.IG.NEXT.MONTH'
,p_message_language=>'fr'
,p_message_text=>'Mois suivant'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277095525943867146)
,p_name=>'APEX.IG.NEXT.WEEK'
,p_message_language=>'fr'
,p_message_text=>'Semaine suivante'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277095453700867146)
,p_name=>'APEX.IG.NEXT.X_DAYS'
,p_message_language=>'fr'
,p_message_text=>'%0 prochains jours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277095229806867146)
,p_name=>'APEX.IG.NEXT.X_HOURS'
,p_message_language=>'fr'
,p_message_text=>'%0 prochaines heures'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277097433023867148)
,p_name=>'APEX.IG.NEXT.X_MINUTES'
,p_message_language=>'fr'
,p_message_text=>'%0 prochaines minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277096766563867147)
,p_name=>'APEX.IG.NEXT.X_MONTHS'
,p_message_language=>'fr'
,p_message_text=>'%0 prochains mois'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277096826332867147)
,p_name=>'APEX.IG.NEXT.X_WEEKS'
,p_message_language=>'fr'
,p_message_text=>'%0 prochaines semaines'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277095817299867146)
,p_name=>'APEX.IG.NEXT.X_YEARS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 prochaines ann\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277095735769867146)
,p_name=>'APEX.IG.NEXT.YEAR'
,p_message_language=>'fr'
,p_message_text=>unistr('Ann\00E9e suivante')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277198480893867213)
,p_name=>'APEX.IG.NOT_BETWEEN'
,p_message_language=>'fr'
,p_message_text=>'non compris entre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277197414324867212)
,p_name=>'APEX.IG.NOT_EQUALS'
,p_message_language=>'fr'
,p_message_text=>unistr('est diff\00E9rent de')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277717866531867548)
,p_name=>'APEX.IG.NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>unistr('La r\00E9gion portant l''ID %0 n''est pas une r\00E9gion de grille interactive ou n''existe pas dans l''application %1.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277197867075867212)
,p_name=>'APEX.IG.NOT_IN'
,p_message_language=>'fr'
,p_message_text=>'n''est pas dans'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277198624705867213)
,p_name=>'APEX.IG.NOT_IN_THE_LAST'
,p_message_language=>'fr'
,p_message_text=>'pas au cours des'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277198821364867213)
,p_name=>'APEX.IG.NOT_IN_THE_NEXT'
,p_message_language=>'fr'
,p_message_text=>'pas dans'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277223312791867229)
,p_name=>'APEX.IG.NO_DATA_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune donn\00E9e n''a \00E9t\00E9 trouv\00E9e')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277656249609867509)
,p_name=>'APEX.IG.NULLS'
,p_message_language=>'fr'
,p_message_text=>'Valeurs NULL'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277666209554867515)
,p_name=>'APEX.IG.NUMBER'
,p_message_language=>'fr'
,p_message_text=>unistr('Num\00E9rique')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277656752475867509)
,p_name=>'APEX.IG.OFF'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactiv\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277656808236867509)
,p_name=>'APEX.IG.ON'
,p_message_language=>'fr'
,p_message_text=>unistr('Activ\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277180846982867201)
,p_name=>'APEX.IG.ONE_MINUTE_AGO'
,p_message_language=>'fr'
,p_message_text=>'Il y a 1 minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277673997305867520)
,p_name=>'APEX.IG.OPEN_COLORPICKER'
,p_message_language=>'fr'
,p_message_text=>unistr('Ouvrir le s\00E9lecteur de couleur : %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277649425245867504)
,p_name=>'APEX.IG.OPEN_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Ouvrir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277216570093867225)
,p_name=>'APEX.IG.OPERATOR'
,p_message_language=>'fr'
,p_message_text=>unistr('Op\00E9rateur')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277648867707867504)
,p_name=>'APEX.IG.ORIENTATION'
,p_message_language=>'fr'
,p_message_text=>'Orientation'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277651242569867506)
,p_name=>'APEX.IG.PIE'
,p_message_language=>'fr'
,p_message_text=>'A secteurs'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277217800878867225)
,p_name=>'APEX.IG.PIVOT'
,p_message_language=>'fr'
,p_message_text=>'Permutation lignes vers colonnes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276955737069867054)
,p_name=>'APEX.IG.PIVOT_VIEW'
,p_message_language=>'fr'
,p_message_text=>'Vue de pivot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277673838760867520)
,p_name=>'APEX.IG.PLACEHOLDER_INVALUES'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9parer les valeurs par "%0"')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277651362024867506)
,p_name=>'APEX.IG.POLAR'
,p_message_language=>'fr'
,p_message_text=>'Polaire'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277665181979867515)
,p_name=>'APEX.IG.POSITION_CENTER'
,p_message_language=>'fr'
,p_message_text=>'Au centre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277665294122867515)
,p_name=>'APEX.IG.POSITION_END'
,p_message_language=>'fr'
,p_message_text=>'Fin'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277665014583867515)
,p_name=>'APEX.IG.POSITION_START'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9but')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277215799382867224)
,p_name=>'APEX.IG.PRIMARY'
,p_message_language=>'fr'
,p_message_text=>'Principal'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277216028719867224)
,p_name=>'APEX.IG.PRIMARY_DEFAULT'
,p_message_language=>'fr'
,p_message_text=>unistr('Val. par d\00E9faut du principal')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277511080788867415)
,p_name=>'APEX.IG.PRIMARY_REPORT'
,p_message_language=>'fr'
,p_message_text=>'Etat principal'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277651466344867506)
,p_name=>'APEX.IG.RADAR'
,p_message_language=>'fr'
,p_message_text=>'Radar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277651505925867506)
,p_name=>'APEX.IG.RANGE'
,p_message_language=>'fr'
,p_message_text=>'Plage'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277675393621867521)
,p_name=>'APEX.IG.REFRESH'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9g\00E9n\00E9rer')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277224118456867229)
,p_name=>'APEX.IG.REFRESH_ROW'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9g\00E9n\00E9rer la ligne')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277222967629867229)
,p_name=>'APEX.IG.REFRESH_ROWS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9g\00E9n\00E9rer les lignes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276957280253867055)
,p_name=>'APEX.IG.REMOVE_CONTROL'
,p_message_language=>'fr'
,p_message_text=>'Enlever %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277215180760867224)
,p_name=>'APEX.IG.REPORT'
,p_message_language=>'fr'
,p_message_text=>'Etat'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277708565863867543)
,p_name=>'APEX.IG.REPORT.DELETED'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat supprim\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277708255179867542)
,p_name=>'APEX.IG.REPORT.SAVED.ALTERNATIVE'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat de remplacement enregistr\00E9 pour tous les utilisateurs')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277708120087867542)
,p_name=>'APEX.IG.REPORT.SAVED.DEFAULT'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat par d\00E9faut enregistr\00E9 pour tous les utilisateurs')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277708488883867542)
,p_name=>'APEX.IG.REPORT.SAVED.PRIVATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat priv\00E9 enregistr\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277708303390867542)
,p_name=>'APEX.IG.REPORT.SAVED.PUBLIC'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat public enregistr\00E9 pour tous les utilisateurs')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277180795025867201)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF.X.MINUTES_AGO'
,p_message_language=>'fr'
,p_message_text=>unistr('Donn\00E9es d''\00E9tat datant d''il y a %0 minutes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277180651500867201)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF_ONE_MINUTE_AGO'
,p_message_language=>'fr'
,p_message_text=>unistr('Donn\00E9es d''\00E9tat datant d''il y a 1 minute')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277679762376867524)
,p_name=>'APEX.IG.REPORT_EDIT'
,p_message_language=>'fr'
,p_message_text=>'Etat - Modifier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277679695784867524)
,p_name=>'APEX.IG.REPORT_SAVE_AS'
,p_message_language=>'fr'
,p_message_text=>'Etat - Enregistrer sous'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276957359454867055)
,p_name=>'APEX.IG.REPORT_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres d''\00E9tat')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277717971279867548)
,p_name=>'APEX.IG.REPORT_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>unistr('La grille interactive enregistr\00E9e avec l''ID statique %0 n''existe pas.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277692079760867532)
,p_name=>'APEX.IG.REPORT_VIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Vue d''\00E9tat')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276956412536867055)
,p_name=>'APEX.IG.RESET'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9initialiser')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277224284114867230)
,p_name=>'APEX.IG.REVERT_CHANGES'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9tablir les modifications')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277223046325867229)
,p_name=>'APEX.IG.REVERT_ROWS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9tablir les lignes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277216162651867224)
,p_name=>'APEX.IG.ROW'
,p_message_language=>'fr'
,p_message_text=>'Ligne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277215089983867224)
,p_name=>'APEX.IG.ROWS_PER_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Lignes par page'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277716581013867548)
,p_name=>'APEX.IG.ROW_ACTIONS'
,p_message_language=>'fr'
,p_message_text=>'Actions de ligne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277723719059867552)
,p_name=>'APEX.IG.ROW_ACTIONS_FOR'
,p_message_language=>'fr'
,p_message_text=>'Actions pour la ligne %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276956730664867055)
,p_name=>'APEX.IG.SAVE'
,p_message_language=>'fr'
,p_message_text=>'Enregistrer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277299107648867279)
,p_name=>'APEX.IG.SAVED'
,p_message_language=>'fr'
,p_message_text=>unistr('enregistr\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276954994126867054)
,p_name=>'APEX.IG.SAVED_REPORTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Etats enregistr\00E9s')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276955075887867054)
,p_name=>'APEX.IG.SAVED_REPORT_DEFAULT'
,p_message_language=>'fr'
,p_message_text=>unistr('Valeur par d\00E9faut')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276955116988867054)
,p_name=>'APEX.IG.SAVED_REPORT_PRIVATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Priv\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276955240343867054)
,p_name=>'APEX.IG.SAVED_REPORT_PUBLIC'
,p_message_language=>'fr'
,p_message_text=>'Public'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277691731252867532)
,p_name=>'APEX.IG.SAVE_AS'
,p_message_language=>'fr'
,p_message_text=>'Enregistrer sous'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277222321467867228)
,p_name=>'APEX.IG.SAVE_REPORT_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrer les param\00E8tres d''\00E9tat')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277651686067867506)
,p_name=>'APEX.IG.SCATTER'
,p_message_language=>'fr'
,p_message_text=>'En nuage de points'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276954831300867054)
,p_name=>'APEX.IG.SEARCH'
,p_message_language=>'fr'
,p_message_text=>'Rechercher'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277670470178867518)
,p_name=>'APEX.IG.SEARCH.ALL_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Rechercher : Toutes les colonnes de texte'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276954794245867054)
,p_name=>'APEX.IG.SEARCH.COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Rechercher : %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277669291877867517)
,p_name=>'APEX.IG.SEARCH.ORACLE_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Rechercher : Texte int\00E9gral')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277180548525867201)
,p_name=>'APEX.IG.SEARCH_FOR.X'
,p_message_language=>'fr'
,p_message_text=>'Rechercher ''%0'''
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277645168976867502)
,p_name=>'APEX.IG.SELECT'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner -')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277019362041867095)
,p_name=>'APEX.IG.SELECTION'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lection')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277617948371867484)
,p_name=>'APEX.IG.SELECT_1_ROW_IN_MASTER'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionner 1 ligne dans la r\00E9gion ma\00EEtre')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276954626582867054)
,p_name=>'APEX.IG.SELECT_COLUMNS_TO_SEARCH'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionner les colonnes \00E0 rechercher')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277715553140867547)
,p_name=>'APEX.IG.SEL_ACTIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Actions de s\00E9lection')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277019582316867095)
,p_name=>'APEX.IG.SEL_MODE_CELL'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lection de cellule')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277019496382867095)
,p_name=>'APEX.IG.SEL_MODE_ROW'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lection de ligne')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277671071664867518)
,p_name=>'APEX.IG.SEND_AS_EMAIL'
,p_message_language=>'fr'
,p_message_text=>'Envoyer en tant que courriel'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277654567441867508)
,p_name=>'APEX.IG.SERIES_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9rie')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276915599832867028)
,p_name=>'APEX.IG.SHOW'
,p_message_language=>'fr'
,p_message_text=>'Afficher'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277530436936867428)
,p_name=>'APEX.IG.SHOW_OVERALL_VALUE'
,p_message_language=>'fr'
,p_message_text=>'Afficher la valeur globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277223854756867229)
,p_name=>'APEX.IG.SINGLE_ROW_VIEW'
,p_message_language=>'fr'
,p_message_text=>'Vue monoligne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277218063112867226)
,p_name=>'APEX.IG.SORT'
,p_message_language=>'fr'
,p_message_text=>'Trier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277654671863867508)
,p_name=>'APEX.IG.SORT_BY'
,p_message_language=>'fr'
,p_message_text=>'Trier par'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277716652710867548)
,p_name=>'APEX.IG.SORT_ONLY_ONE_PER_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous ne pouvez d\00E9finir qu''un seul tri par colonne.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277715754718867547)
,p_name=>'APEX.IG.SRV_CHANGE_MENU'
,p_message_language=>'fr'
,p_message_text=>'Modifier le menu'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277656951203867509)
,p_name=>'APEX.IG.STACK'
,p_message_language=>'fr'
,p_message_text=>'Empiler'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277199100629867213)
,p_name=>'APEX.IG.STARTS_WITH'
,p_message_language=>'fr'
,p_message_text=>'commence par'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277651730648867506)
,p_name=>'APEX.IG.STOCK'
,p_message_language=>'fr'
,p_message_text=>'Boursier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276844204931866983)
,p_name=>'APEX.IG.STRETCH_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Etirer les largeurs de colonne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277222586165867228)
,p_name=>'APEX.IG.SUBSCRIPTION'
,p_message_language=>'fr'
,p_message_text=>'Abonnement'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277563004676867449)
,p_name=>'APEX.IG.SUM'
,p_message_language=>'fr'
,p_message_text=>'Total'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277723986472867552)
,p_name=>'APEX.IG.SUMMARY'
,p_message_language=>'fr'
,p_message_text=>'Grille interactive. Etat : %0, vue : %1.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277692107899867532)
,p_name=>'APEX.IG.SUM_OVERALL'
,p_message_language=>'fr'
,p_message_text=>'Somme globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277649976785867505)
,p_name=>'APEX.IG.TARGET_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Cible'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277664372253867514)
,p_name=>'APEX.IG.TEXT_COLOR'
,p_message_language=>'fr'
,p_message_text=>'Couleur du texte'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276957482729867055)
,p_name=>'APEX.IG.TOGGLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer/d\00E9sactiver')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277530326696867428)
,p_name=>'APEX.IG.TOOLTIP'
,p_message_language=>'fr'
,p_message_text=>'Info-bulle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277215247961867224)
,p_name=>'APEX.IG.TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277223732703867229)
,p_name=>'APEX.IG.UNFREEZE'
,p_message_language=>'fr'
,p_message_text=>unistr('Lib\00E9rer')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277216795904867225)
,p_name=>'APEX.IG.UNIT'
,p_message_language=>'fr'
,p_message_text=>unistr('Unit\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277670862188867518)
,p_name=>'APEX.IG.UNSAVED_CHANGES_CONTINUE_CONFIRM'
,p_message_language=>'fr'
,p_message_text=>unistr('Certaines modifications n''ont pas \00E9t\00E9 enregistr\00E9es. Voulez-vous continuer ?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277216632835867225)
,p_name=>'APEX.IG.VALUE'
,p_message_language=>'fr'
,p_message_text=>'Valeur'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277649031353867504)
,p_name=>'APEX.IG.VALUE_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Valeur'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277658051960867510)
,p_name=>'APEX.IG.VALUE_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>'La valeur est obligatoire.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277602561228867474)
,p_name=>'APEX.IG.VALUE_TIMESTAMP_TZ'
,p_message_language=>'fr'
,p_message_text=>'Valeur (impossible de modifier le fuseau horaire)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277666310436867515)
,p_name=>'APEX.IG.VARCHAR2'
,p_message_language=>'fr'
,p_message_text=>'Texte'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277650380783867505)
,p_name=>'APEX.IG.VERTICAL'
,p_message_language=>'fr'
,p_message_text=>'Vertical'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277214770834867223)
,p_name=>'APEX.IG.VIEW'
,p_message_language=>'fr'
,p_message_text=>'Vue'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277645228932867502)
,p_name=>'APEX.IG.VISIBLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Affich\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277649808990867505)
,p_name=>'APEX.IG.VOLUME_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Volume'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277200130613867214)
,p_name=>'APEX.IG.WEEKS'
,p_message_language=>'fr'
,p_message_text=>'semaines'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277645302548867502)
,p_name=>'APEX.IG.WIDTH'
,p_message_language=>'fr'
,p_message_text=>'Largeur de colonne minimale (pixels)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277130335642867169)
,p_name=>'APEX.IG.X.BETWEEN.Y.AND.Z'
,p_message_language=>'fr'
,p_message_text=>'%0 compris entre %1 et %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277130011692867169)
,p_name=>'APEX.IG.X.CONTAINS.Y'
,p_message_language=>'fr'
,p_message_text=>'%0 contient %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277130126345867169)
,p_name=>'APEX.IG.X.DOES_NOT_CONTAIN.Y'
,p_message_language=>'fr'
,p_message_text=>'%0 ne contient pas %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276911716282867026)
,p_name=>'APEX.IG.X.DOES_NOT_START_WITH.Y'
,p_message_language=>'fr'
,p_message_text=>'%0 ne commence pas par %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277128881872867168)
,p_name=>'APEX.IG.X.EQUALS.Y'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 est \00E9gal \00E0 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277129025978867168)
,p_name=>'APEX.IG.X.GREATER_THAN.Y'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 est sup\00E9rieur \00E0 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277129179233867168)
,p_name=>'APEX.IG.X.GREATER_THAN_OR_EQUALS.Y'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 sup\00E9rieur ou \00E9gal \00E0 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277129818591867169)
,p_name=>'APEX.IG.X.IN.Y'
,p_message_language=>'fr'
,p_message_text=>'%0 dans %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277131026385867169)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.DAYS'
,p_message_language=>'fr'
,p_message_text=>'%0 au cours des %1 derniers jours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277130878339867169)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.HOURS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 au cours des %1 derni\00E8res heures')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277130614585867169)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MINUTES'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 au cours des %1 derni\00E8res minutes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277131434682867170)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MONTHS'
,p_message_language=>'fr'
,p_message_text=>'%0 au cours des %1 derniers mois'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277131200796867169)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.WEEKS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 au cours des %1 derni\00E8res semaines')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277131610775867170)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.YEARS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 au cours des %1 derni\00E8res ann\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277130962355867169)
,p_name=>'APEX.IG.X.IN_THE_LAST_DAY'
,p_message_language=>'fr'
,p_message_text=>'%0 au cours du dernier jour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277130739716867169)
,p_name=>'APEX.IG.X.IN_THE_LAST_HOUR'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 au cours de la derni\00E8re heure')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277130527926867169)
,p_name=>'APEX.IG.X.IN_THE_LAST_MINUTE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 au cours de la derni\00E8re minute')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277131361115867170)
,p_name=>'APEX.IG.X.IN_THE_LAST_MONTH'
,p_message_language=>'fr'
,p_message_text=>'%0 au cours du dernier mois'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277131184961867169)
,p_name=>'APEX.IG.X.IN_THE_LAST_WEEK'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 au cours de la derni\00E8re semaine')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277131566480867170)
,p_name=>'APEX.IG.X.IN_THE_LAST_YEAR'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 au cours de la derni\00E8re ann\00E9e')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277133490043867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.DAYS'
,p_message_language=>'fr'
,p_message_text=>'%0 au cours des %1 prochains jours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277133223327867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.HOURS'
,p_message_language=>'fr'
,p_message_text=>'%0 dans les %1 prochaines heures'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277133027292867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'fr'
,p_message_text=>'%0 dans les %1 prochaines minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277133897533867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'fr'
,p_message_text=>'%0 au cours des %1 prochains mois'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277133614512867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'fr'
,p_message_text=>'%0 au cours des %1 prochaines semaines'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277134000255867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.YEARS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 dans les %1 prochaines ann\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277133376737867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT_DAY'
,p_message_language=>'fr'
,p_message_text=>'%0 au cours du prochain jour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277133103984867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT_HOUR'
,p_message_language=>'fr'
,p_message_text=>'%0 dans l''heure suivante'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277132995219867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MINUTE'
,p_message_language=>'fr'
,p_message_text=>'%0 dans la prochaine minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277133790523867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MONTH'
,p_message_language=>'fr'
,p_message_text=>'%0 au cours du prochain mois'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277133540843867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT_WEEK'
,p_message_language=>'fr'
,p_message_text=>'%0 au cours de la prochaine semaine'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277133974906867171)
,p_name=>'APEX.IG.X.IN_THE_NEXT_YEAR'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 dans l''ann\00E9e prochaine')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277129532513867168)
,p_name=>'APEX.IG.X.IS_NOT_NULL'
,p_message_language=>'fr'
,p_message_text=>'%0 n''est pas vide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277129442866867168)
,p_name=>'APEX.IG.X.IS_NULL'
,p_message_language=>'fr'
,p_message_text=>'%0 est vide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277129259340867168)
,p_name=>'APEX.IG.X.LESS_THAN.Y'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 inf\00E9rieur \00E0 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277129326853867168)
,p_name=>'APEX.IG.X.LESS_THAN_OR_EQUALS.Y'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 inf\00E9rieur ou \00E9gal \00E0 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277129616269867168)
,p_name=>'APEX.IG.X.LIKE.Y'
,p_message_language=>'fr'
,p_message_text=>'%0 comme %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277130279315867169)
,p_name=>'APEX.IG.X.MATCHES_REGULAR_EXPRESSION.Y'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 recherche une expression r\00E9guli\00E8re %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277180975465867202)
,p_name=>'APEX.IG.X.MINUTES_AGO'
,p_message_language=>'fr'
,p_message_text=>'Il y a %0 minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277130445522867169)
,p_name=>'APEX.IG.X.NOT_BETWEEN.Y.AND.Z'
,p_message_language=>'fr'
,p_message_text=>'%0 n''est pas compris entre %1 et %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277128971192867168)
,p_name=>'APEX.IG.X.NOT_EQUALS.Y'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 est diff\00E9rent de %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277129916068867169)
,p_name=>'APEX.IG.X.NOT_IN.Y'
,p_message_language=>'fr'
,p_message_text=>'%0 n''est pas dans %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277132240726867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.DAYS'
,p_message_language=>'fr'
,p_message_text=>'%0 pas au cours des %1 derniers jours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277132089182867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.HOURS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 pas au cours des %1 derni\00E8res heures')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277131863602867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MINUTES'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 pas au cours des %1 derni\00E8res minutes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277132640137867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MONTHS'
,p_message_language=>'fr'
,p_message_text=>'%0 pas au cours des %1 derniers mois'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277132482225867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.WEEKS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 pas au cours des %1 derni\00E8res semaines')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277132839397867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.YEARS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 pas au cours des %1 derni\00E8res ann\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277132152771867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_DAY'
,p_message_language=>'fr'
,p_message_text=>'%0 pas au cours du dernier jour'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277131939337867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_HOUR'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 pas au cours de la derni\00E8re heure')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277131704657867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MINUTE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 pas au cours de la derni\00E8re minute')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277132535422867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MONTH'
,p_message_language=>'fr'
,p_message_text=>'%0 pas au cours du dernier mois'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277132314891867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_WEEK'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 pas au cours de la derni\00E8re semaine')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277132771883867170)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_YEAR'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 pas au cours de la derni\00E8re ann\00E9e')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277134683577867172)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.DAYS'
,p_message_language=>'fr'
,p_message_text=>'%0 pas au cours des %1 prochains jours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277134405016867172)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.HOURS'
,p_message_language=>'fr'
,p_message_text=>'%0 pas dans les %1 prochaines heures'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277134278598867171)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'fr'
,p_message_text=>'%0 pas dans les %1 prochaines minutes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277135086886867172)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'fr'
,p_message_text=>'%0 pas dans les %1 prochains mois '
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277134892720867172)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'fr'
,p_message_text=>'%0 pas au cours des %1 prochaines semaines'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277135289846867172)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.YEARS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 pas dans les %1 prochaines ann\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277134593712867172)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_DAY'
,p_message_language=>'fr'
,p_message_text=>'%0 pas le jour suivant'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277134332238867171)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_HOUR'
,p_message_language=>'fr'
,p_message_text=>'%0 pas dans la prochaine heure'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277134114255867171)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MINUTE'
,p_message_language=>'fr'
,p_message_text=>'%0 pas dans la prochaine minute'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277134909023867172)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MONTH'
,p_message_language=>'fr'
,p_message_text=>'%0 pas dans le prochain mois'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277134729984867172)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_WEEK'
,p_message_language=>'fr'
,p_message_text=>'%0 pas au cours de la semaine prochaine'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277135192828867172)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_YEAR'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 pas l''ann\00E9e prochaine')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277129723197867168)
,p_name=>'APEX.IG.X.NOT_LIKE.Y'
,p_message_language=>'fr'
,p_message_text=>'%0 n''est pas comme %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277190808736867208)
,p_name=>'APEX.IG.X.STARTS_WITH.Y'
,p_message_language=>'fr'
,p_message_text=>'%0 commence par %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277649125502867504)
,p_name=>'APEX.IG.X_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'X'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277200368619867214)
,p_name=>'APEX.IG.YEARS'
,p_message_language=>'fr'
,p_message_text=>unistr('ann\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277649266750867504)
,p_name=>'APEX.IG.Y_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'O'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277649356489867504)
,p_name=>'APEX.IG.Z_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Z'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277669857814867518)
,p_name=>'APEX.IG_FORMAT_SAMPLE_1'
,p_message_language=>'fr'
,p_message_text=>'Lundi 12 janvier 2016'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277669959146867518)
,p_name=>'APEX.IG_FORMAT_SAMPLE_2'
,p_message_language=>'fr'
,p_message_text=>'Janvier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277670090609867518)
,p_name=>'APEX.IG_FORMAT_SAMPLE_3'
,p_message_language=>'fr'
,p_message_text=>'Il y a 16 heures'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277670140587867518)
,p_name=>'APEX.IG_FORMAT_SAMPLE_4'
,p_message_language=>'fr'
,p_message_text=>'dans 16 h'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276525955385866779)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('La prise en charge de l''impression doit \00EAtre de type Standard ou Avanc\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276526072265866779)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible d''enlever le premier sch\00E9ma provisionn\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276414859495866705)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'ID d''application non valide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276952898205867052)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Adresse \00E9lectronique non valide')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276395990461866692)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur doit \00EAtre z\00E9ro ou un entier positif.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276526151122866779)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Num\00E9ro de port non valide')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276988609977867075)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_language=>'fr'
,p_message_text=>'ID d''abonnement non valide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276526209947866779)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_language=>'fr'
,p_message_text=>unistr('Le chemin de portefeuille doit figurer dans le fichier d''application Forms : <chemin du syst\00E8me de fichiers>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276617673928866839)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_language=>'fr'
,p_message_text=>'L''espace de travail est introuvable.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276617565241866839)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_language=>'fr'
,p_message_text=>'ID d''espace de travail non valide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276545117195866793)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur "%1" du param\00E8tre d''instance "%0" ne correspond pas \00E0 l''expression r\00E9guli\00E8re "%2"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276545042383866793)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le param\00E8tre d''instance "%0" doit avoir une valeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276526307132866780)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tre d''instance introuvable')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276984264670867073)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_language=>'fr'
,p_message_text=>'Mot de passe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276349676174866664)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_language=>'fr'
,p_message_text=>unistr('Mot de passe (pour authentification par rapport au r\00E9f\00E9rentiel de comptes utilisateur de l''espace de travail uniquement)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277269795855867259)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_language=>'fr'
,p_message_text=>unistr('Mot de passe (pour authentification par rapport au r\00E9f\00E9rentiel de comptes utilisateur de l''espace de travail uniquement)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277091248644867143)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_language=>'fr'
,p_message_text=>unistr('Mot de passe (pour authentification par rapport au r\00E9f\00E9rentiel de comptes utilisateur de l''espace de travail uniquement)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276671414644866873)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_language=>'fr'
,p_message_text=>unistr('Mot de passe (pour authentification par rapport au r\00E9f\00E9rentiel de comptes utilisateur de l''espace de travail uniquement)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276984185824867072)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_language=>'fr'
,p_message_text=>unistr('Mot de passe (pour authentification par rapport au r\00E9f\00E9rentiel de comptes utilisateur de l''espace de travail uniquement)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276528202913866781)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_language=>'fr'
,p_message_text=>unistr('Le protocole du serveur d''impression doit \00EAtre HTTP ou HTTPS')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276528356991866781)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>unistr('Le sch\00E9ma n''existe pas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276528468938866781)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le sch\00E9ma est restreint')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276374591928866679)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276374305512866679)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'L''application n''existe plus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277318980251867291)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_language=>'fr'
,p_message_text=>'Affecter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277599277576867472)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_language=>'fr'
,p_message_text=>'Cartes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276376491252866680)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Comment\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276376349586866680)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_language=>'fr'
,p_message_text=>'commentaires'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276351100846866665)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_language=>'fr'
,p_message_text=>'Supprimer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276350993024866665)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_language=>'fr'
,p_message_text=>'Voulez-vous supprimer ce commentaire ?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277303329125867281)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_language=>'fr'
,p_message_text=>unistr('Supprimer le probl\00E8me')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276360720560866671)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_language=>'fr'
,p_message_text=>unistr('Voulez-vous supprimer ce probl\00E8me ?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276378004315866681)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_language=>'fr'
,p_message_text=>'Document'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276376936442866680)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_language=>'fr'
,p_message_text=>'Documents'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276351064926866665)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_language=>'fr'
,p_message_text=>'Modifier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277526820354867425)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_language=>'fr'
,p_message_text=>'Modifier un commentaire'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277526980824867426)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier le probl\00E8me')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276375185257866679)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>unistr('L''application indiqu\00E9e n''existe pas dans cet espace de travail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276375543310866680)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors de la tentative de suppression du commentaire.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276375489261866679)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>'Commentaire introuvable.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276375717422866680)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Probl\00E8me introuvable.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276375849126866680)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur lors de la tentative de marquage du probl\00E8me pour suppression.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276375257325866679)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>unistr('La page indiqu\00E9e n''existe pas dans cet espace de travail ni dans l''application fournie.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276375672017866680)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('L''utilisateur n''est pas autoris\00E9 \00E0 supprimer ce commentaire.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276375925734866680)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_language=>'fr'
,p_message_text=>unistr('L''utilisateur n''est pas autoris\00E9 \00E0 supprimer ce probl\00E8me.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276375352886866679)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_language=>'fr'
,p_message_text=>unistr('L''utilisateur n''est pas autoris\00E9 \00E0 modifier la visibilit\00E9 de ce commentaire.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277535729730867431)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Un probl\00E8me s''est produit lors de la v\00E9rification de la taille des fichiers. Contactez l''administrateur syst\00E8me.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277535660093867431)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_language=>'fr'
,p_message_text=>unistr('La taille d''un des fichiers est sup\00E9rieure \00E0 la limite maximale de %0 octets.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277535503029867431)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_language=>'fr'
,p_message_text=>unistr('La taille du fichier est sup\00E9rieure \00E0 la limite maximale de %0 octets.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276351286207866665)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_language=>'fr'
,p_message_text=>'Masquer'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276377853500866681)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_language=>'fr'
,p_message_text=>'Image'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276376799816866680)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_language=>'fr'
,p_message_text=>'Images'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276374146972866679)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('un probl\00E8me non trouv\00E9 dans le syst\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276334896653866655)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajouter une pr\00E9f\00E9rence pour l''utilisateur')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276376596368866680)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_language=>'fr'
,p_message_text=>'Joindre des fichiers'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276376258683866680)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Ferm\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277604899208867476)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_language=>'fr'
,p_message_text=>unistr('En-t\00EAte')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276377568110866681)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_language=>'fr'
,p_message_text=>'est vide.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276377335998866681)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_language=>'fr'
,p_message_text=>'Un de ces fichiers est'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276376157274866680)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_language=>'fr'
,p_message_text=>'Ouvrir'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276378646601866681)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Supprimer d\00E9finitivement les \00E9l\00E9ments s\00E9lectionn\00E9s')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277304252293867282)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_language=>'fr'
,p_message_text=>'Purger tout'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276378581918866681)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9tablir la s\00E9lection')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276376630790866680)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de r\00E9ponse')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276377428293866681)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_language=>'fr'
,p_message_text=>unistr('trop volumineux pour \00EAtre t\00E9l\00E9charg\00E9. <br>Les fichiers ne doivent pas d\00E9passer')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276377758512866681)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_language=>'fr'
,p_message_text=>'Types de fichier pris en charge : '
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277530784071867428)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionner un mod\00E8le de r\00E9ponse')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276377272958866681)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_language=>'fr'
,p_message_text=>'Ce fichier est'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276377679267866681)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_language=>'fr'
,p_message_text=>'n''est pas un type de fichier pris en charge.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277243036557867242)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_language=>'fr'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277243624396867242)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_language=>'fr'
,p_message_text=>unistr('Probl\00E8me li\00E9 \00E0 la documentation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277243178778867242)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_language=>'fr'
,p_message_text=>unistr('Demande d''am\00E9lioration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277243274113867242)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_language=>'fr'
,p_message_text=>unistr('Demande de fonctionnalit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277243540293867242)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_language=>'fr'
,p_message_text=>unistr('Probl\00E8me li\00E9 \00E0 l''installation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277243411602867242)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_language=>'fr'
,p_message_text=>unistr('Probl\00E8me li\00E9 aux performances')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277243338192867242)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_language=>'fr'
,p_message_text=>unistr('Probl\00E8me li\00E9 \00E0 la s\00E9curit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277243708696867242)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_language=>'fr'
,p_message_text=>unistr('Probl\00E8me li\00E9 \00E0 la formation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277244412022867243)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_language=>'fr'
,p_message_text=>'Administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277244109250867242)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_language=>'fr'
,p_message_text=>'CSS / HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277244277849867242)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_language=>'fr'
,p_message_text=>'Actions dynamiques/JavaScript'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277243921161867242)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_language=>'fr'
,p_message_text=>unistr('Base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277244508835867243)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Int\00E9gration syst\00E8me externe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277244073428867242)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Int\00E9gration REST')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277244382811867243)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9curit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277243827633867242)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_language=>'fr'
,p_message_text=>'UI / UX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277242966382867242)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Cat\00E9gorie affect\00E9e au probl\00E8me.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277242048644867241)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Cat\00E9gorie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277242804475867242)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Zone fonctionnelle affect\00E9e par le probl\00E8me.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277242172664867241)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_language=>'fr'
,p_message_text=>'Zone fonctionnelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277242748498867242)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Importance accord\00E9e au probl\00E8me.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277242275497867241)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_language=>'fr'
,p_message_text=>'Importance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277242650175867241)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Efforts mis en oeuvre pour r\00E9soudre le probl\00E8me.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277242381187867241)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_language=>'fr'
,p_message_text=>'Niveau d''effort'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277242582365867241)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Avancement par rapport au probl\00E8me.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277242405262867241)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_language=>'fr'
,p_message_text=>'Progression'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277244981301867243)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_language=>'fr'
,p_message_text=>unistr('Non trait\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277244690462867243)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_language=>'fr'
,p_message_text=>'Critique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277244749806867243)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_language=>'fr'
,p_message_text=>'Important'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277244826342867243)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_language=>'fr'
,p_message_text=>'Normal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277245097536867243)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Pas de r\00E9solution')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277245117269867243)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_language=>'fr'
,p_message_text=>'Correction facile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277245326126867243)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Efforts de d\00E9veloppement importants')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277245213289867243)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Efforts mod\00E9r\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277245740694867243)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_language=>'fr'
,p_message_text=>'Correction impossible'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277245888434867244)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_language=>'fr'
,p_message_text=>unistr('Termin\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277245540551867243)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_language=>'fr'
,p_message_text=>unistr('Informations compl\00E9mentaires requises')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277245611218867243)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_language=>'fr'
,p_message_text=>'En attente d''un tiers'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277245425835867243)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_language=>'fr'
,p_message_text=>'En cours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277256157460867250)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce groupe de libell\00E9s ne peut pas \00EAtre supprim\00E9, car au moins un de ses membres est affect\00E9 \00E0 un probl\00E8me.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276376070591866680)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_language=>'fr'
,p_message_text=>unistr('A marqu\00E9 le doublon de')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277303717360867282)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_language=>'fr'
,p_message_text=>'Destinataires'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277303638296867281)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9s')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277304155072867282)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_language=>'fr'
,p_message_text=>'Jalons'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277303514382867281)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_language=>'fr'
,p_message_text=>'Statut'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276373965524866679)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_language=>'fr'
,p_message_text=>'jalons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277246457238867244)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_language=>'fr'
,p_message_text=>'Blocage du code'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277246688087867244)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_language=>'fr'
,p_message_text=>'Version finale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277246584097867244)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_language=>'fr'
,p_message_text=>'Gel IU'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276378475529866681)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 a ajout\00E9 un commentaire \00E0 %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276334522593866655)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_language=>'fr'
,p_message_text=>unistr('a \00E9t\00E9 modifi\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277260371057867253)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le probl\00E8me num\00E9ro %0 dans l''espace de travail %1 a \00E9t\00E9 modifi\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277535479747867431)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun libell\00E9 n''a \00E9t\00E9 d\00E9fini.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276377144172866680)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_language=>'fr'
,p_message_text=>'Autre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276374697750866679)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_language=>'fr'
,p_message_text=>'Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276374447315866679)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'La page n''existe plus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277596724311867470)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_language=>'fr'
,p_message_text=>'Purger tout'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277319009119867291)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_language=>'fr'
,p_message_text=>'Enlever'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276374289949866679)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_language=>'fr'
,p_message_text=>unistr('A enlev\00E9 l''association d''application et de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276374919199866679)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Pi\00E8ce jointe enlev\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277570593095867454)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_language=>'fr'
,p_message_text=>unistr('Voulez-vous remplacer le commentaire en cours par ce mod\00E8le ?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277572532850867455)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Bonjour ! ',
'',
unistr('C''est votre tout premier probl\00E8me. Vous pouvez cr\00E9er des probl\00E8mes afin de suivre des t\00E2ches, des fonctionnalit\00E9s, des bugs et des informations en retour pour tous vos projets APEX. Vous pouvez ajouter des libell\00E9s \00E0 des probl\00E8mes, ajouter des destin')
||unistr('ataires, d\00E9finir des jalons et m\00EAme appliquer un formatage \00E0 l''aide des raccourcis Markdown.  '),
'',
'Voici un exemple de ce que permet Markdown :'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277572412655867455)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Bienvenue dans le d\00E9veloppement d''\00E9quipe dans Oracle APEX.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277319394622867292)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276375085054866679)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir le statut sur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276351411731866665)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_language=>'fr'
,p_message_text=>'Afficher les actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277572310075867455)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_language=>'fr'
,p_message_text=>'Afficher plus...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276374796774866679)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_language=>'fr'
,p_message_text=>unistr('Abonn\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277535867949867431)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_language=>'fr'
,p_message_text=>'%0 dans l''espace de travail %1 comporte %2 nouvelles notifications.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277239526086867239)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le utilis\00E9 pour consigner un bug.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277239426672867239)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de bug')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277239304357867239)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Comportement attendu**',
unistr('- Dites-nous ce qui doit se produire \00E0 votre avis.'),
'',
'',
'**Comportement en cours**',
'- Dites-nous ce qui se produit.',
'',
'',
unistr('**Personnes affect\00E9es**'),
unistr('- Dites-nous qui/ce qui est affect\00E9. '),
'',
'**Solution possible**',
unistr('- Si vous le pouvez, proposez une mani\00E8re de r\00E9soudre le bug.'),
'',
unistr('**Etapes \00E0 reproduire**'),
unistr('- Indiquez une s\00E9rie d''\00E9tapes claires \00E0 reproduire, avec des captures d''\00E9cran et des fragments de code si n\00E9cessaire.'),
'1.',
'2.',
'3.',
'',
'**Contexte**',
unistr('- Que tentiez-vous de faire quand le bug s''est produit. Le bug ne se produit-il que dans certaines circonstances, \00E0 des moments pr\00E9cis de la journ\00E9e, etc.'),
'',
'**Environnement**',
'',
'- Version : ',
'- Plate-forme : ',
unistr('- Sous-syst\00E8me :'),
'',
'______',
'',
unistr('_**Remarque :** pour associer un probl\00E8me \00E0 une application et/ou une page, consignez tout d''abord le probl\00E8me, puis utilisez la liste d\00E9roulante **ACTIONS** pour associer l''application et la page._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277240652114867240)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Un bug a \00E9t\00E9 signal\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277240548707867240)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Bug signal\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277240770928867240)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Un **bug** a \00E9t\00E9 enregistr\00E9 dans le syst\00E8me externe appropri\00E9.'),
'',
unistr('- Syst\00E8me de suivi des bugs : '),
'- ID du bug : ',
'- URL du bug : ',
'',
'Commentaires :'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277239768182867240)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le utilis\00E9 pour consigner une demande de fonctionnalit\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277239614827867240)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de demande de fonctionnalit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277239877298867240)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**R\00E9capitulatif de la fonctionnalit\00E9**'),
unistr(' - Donnez, en un paragraphe, un aper\00E7u g\00E9n\00E9ral de la fonctionnalit\00E9 demand\00E9e.'),
'',
'',
'**Contexte**',
unistr(' - Cette demande est-elle en rapport avec une situation ou un processus sp\00E9cifique ? Par exemple, "C''est toujours frustrant de [...]"'),
'',
'',
unistr(' - Fournissez d''\00E9ventuelles informations compl\00E9mentaires, y compris des captures d''\00E9cran, des cas d''emploi, etc.'),
'',
'',
unistr('**Solution privil\00E9gi\00E9e**'),
unistr('- D\00E9crivez pr\00E9cis\00E9ment la solution que vous aimeriez voir mise en oeuvre.'),
'',
'',
'**Autres solutions**',
unistr('- D\00E9crivez les autres solutions ou fonctionnalit\00E9s envisag\00E9es, ou les solutions de contournement utilis\00E9es.'),
'',
'',
'______',
unistr('_**Remarque :** pour associer un probl\00E8me \00E0 une application et/ou une page, consignez tout d''abord le probl\00E8me, puis utilisez la liste d\00E9roulante **ACTIONS** pour associer l''application et la page._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277240910856867240)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Une demande de fonctionnalit\00E9 a \00E9t\00E9 enregistr\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277240838780867240)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Demande de fonctionnalit\00E9 enregistr\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277241066744867240)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Une **demande de fonctionnalit\00E9** a \00E9t\00E9 enregistr\00E9e dans le syst\00E8me externe appropri\00E9.'),
'',
unistr('- Syst\00E8me de suivi des fonctionnalit\00E9s : '),
unistr('- ID de la fonctionnalit\00E9 : '),
unistr('- URL de la d\00E9finition de la fonctionnalit\00E9 : '),
'',
'Commentaires :'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277241859023867241)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Une action de suivi est n\00E9cessaire.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277241750161867241)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_language=>'fr'
,p_message_text=>'Action de suivi requise'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277241942982867241)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Effectuez les actions suivantes : ',
'',
'1.',
'2.',
'3.',
'4.',
'',
'Commentaires : '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277240054114867240)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le utilis\00E9 pour poser une question de proc\00E9dure.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277239974202867240)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Proc\00E9dure ...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277240151374867240)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Question**',
unistr('- Enoncez votre question ou votre demande aussi bri\00E8vement que possible.'),
'',
unistr('**Contexte g\00E9n\00E9ral**'),
'- Que tentez-vous de faire ? ',
'',
'',
unistr('- O\00F9 avez-vous regard\00E9 ou qui avez-vous contact\00E9 pour trouver une r\00E9ponse ? '),
'',
'',
'**Environnement** ',
unistr('Cette question est-elle propre \00E0 un environnement, \00E0 un langage de programmation ou \00E0 un autre \00E9l\00E9ment ?'),
'',
'______',
unistr('_**Remarque :** pour associer un probl\00E8me \00E0 une application et/ou une page, consignez tout d''abord le probl\00E8me, puis utilisez la liste d\00E9roulante **ACTIONS** pour associer l''application et la page._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277241564160867241)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9f\00E9rence \00E0 un probl\00E8me connu.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277241469733867241)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Probl\00E8me connu')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277241622349867241)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Apr\00E8s examen, il s''av\00E8re que ce probl\00E8me est d\00E9j\00E0 connu. Consultez les d\00E9tails ci-dessous.'),
'',
unistr('- Syst\00E8me de suivi des bugs : '),
'- ID du bug : ',
'- URL du bug : ',
'',
'Commentaires : '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277241213480867241)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Demande d''informations compl\00E9mentaires.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277241191643867240)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_language=>'fr'
,p_message_text=>'Plus d''informations requises'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277241362190867241)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**Des informations compl\00E9mentaires sont requises pour ce probl\00E8me :**'),
'',
unistr('Merci de fournir les informations demand\00E9es ci-dessous. Sans ces informations, il sera difficile de classifier le probl\00E8me et de poursuivre sa r\00E9solution.'),
'',
'',
'Commentaires :'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277240361178867240)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce probl\00E8me ne sera pas trait\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277240263946867240)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_language=>'fr'
,p_message_text=>'Sans traitement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277240448309867240)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Apr\00E8s r\00E9flexion, **aucune action ult\00E9rieure ne sera entreprise concernant ce probl\00E8me**. '),
'',
'Commentaires :'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276378162793866681)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_language=>'fr'
,p_message_text=>'Fichier texte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276377053258866680)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_language=>'fr'
,p_message_text=>'Fichiers texte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276373863987866678)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_language=>'fr'
,p_message_text=>unistr('ce probl\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277261449711867254)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('a ajout\00E9 la pi\00E8ce jointe %0 \00E0 %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277260420274867253)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_language=>'fr'
,p_message_text=>unistr('a ajout\00E9 %0 \00E0 %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277262022092867254)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_language=>'fr'
,p_message_text=>unistr('a ajout\00E9 %0 \00E0 %1 %2				')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277260672531867253)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_language=>'fr'
,p_message_text=>unistr('a affect\00E9 %0 \00E0 %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277261051548867253)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_language=>'fr'
,p_message_text=>unistr('a associ\00E9 %0 \00E0 %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276378342175866681)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_language=>'fr'
,p_message_text=>unistr('a modifi\00E9 un commentaire pour %0	%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277261904353867254)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce probl\00E8me a \00E9t\00E9 masqu\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277260869021867253)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_language=>'fr'
,p_message_text=>unistr('a marqu\00E9 %0 en tant que doublon de %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277261859762867254)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_language=>'fr'
,p_message_text=>'A ouvert %0 par'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277261551121867254)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('a enlev\00E9 la pi\00E8ce jointe %0 de %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277260500311867253)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_language=>'fr'
,p_message_text=>unistr('a enlev\00E9 %0 de %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277262148198867254)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_language=>'fr'
,p_message_text=>unistr('a enlev\00E9 %0 de %1 %2 			')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277261649919867254)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_language=>'fr'
,p_message_text=>unistr('a d\00E9fini le statut de %0 sur %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277261283987867253)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_language=>'fr'
,p_message_text=>unistr('a abonn\00E9 \00E0 %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277260728994867253)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_language=>'fr'
,p_message_text=>unistr('a annul\00E9 l''affectation de %0 de %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277261122223867253)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_language=>'fr'
,p_message_text=>unistr('a enlev\00E9 l''association d''application et de page de %0 %1')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277260945560867253)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_language=>'fr'
,p_message_text=>unistr('a annul\00E9 le marquage de %0 en tant que doublon de %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277261353251867254)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_language=>'fr'
,p_message_text=>unistr('a annul\00E9 l''abonnement \00E0 %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277261754691867254)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_language=>'fr'
,p_message_text=>unistr('a marqu\00E9 le doublon de %0 %1 par %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276374093117866679)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_language=>'fr'
,p_message_text=>unistr('Non affect\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276351311372866665)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_language=>'fr'
,p_message_text=>'Afficher'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276374806553866679)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_language=>'fr'
,p_message_text=>unistr('Non abonn\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277303495685867281)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre \00E0 jour...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276377928841866681)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_language=>'fr'
,p_message_text=>'Fichier ZIP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276376894912866680)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_language=>'fr'
,p_message_text=>'Fichiers ZIP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277609752085867479)
,p_name=>'APEX.ITEM.FILE.BROWSE'
,p_message_language=>'fr'
,p_message_text=>'Parcourir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277607675865867477)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILE'
,p_message_language=>'fr'
,p_message_text=>'Choisir un fichier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277607783420867477)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILES'
,p_message_language=>'fr'
,p_message_text=>'Choisir des fichiers'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277712699134867545)
,p_name=>'APEX.ITEM.HELP_TEXT'
,p_message_language=>'fr'
,p_message_text=>'Texte d''aide : %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277565765515867451)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ment %0 introuvable.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276361429248866671)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'fr'
,p_message_text=>'La valeur #LABEL# ne figure pas dans la plage valide comprise entre %0 et %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276361551529866671)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_MULTIPLE_OF_STEP'
,p_message_language=>'fr'
,p_message_text=>'#LABEL# n''est pas un multiple de %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276360840175866671)
,p_name=>'APEX.ITEM_TYPE.YES_NO.INVALID_VALUE'
,p_message_language=>'fr'
,p_message_text=>'#LABEL# doit correspondre aux valeurs %0 et %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276361099745866671)
,p_name=>'APEX.ITEM_TYPE.YES_NO.NO_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Non'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277020690698867096)
,p_name=>'APEX.ITEM_TYPE.YES_NO.OFF_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactiv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277020790009867096)
,p_name=>'APEX.ITEM_TYPE.YES_NO.ON_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Activ\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276360902975866671)
,p_name=>'APEX.ITEM_TYPE.YES_NO.YES_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Oui'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276332064704866653)
,p_name=>'APEX.LIST_MANAGER.ADD_ENTRY'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajouter une entr\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277277550738867264)
,p_name=>'APEX.LIST_MANAGER.BUTTON_ADD'
,p_message_language=>'fr'
,p_message_text=>'Ajouter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277277627892867264)
,p_name=>'APEX.LIST_MANAGER.BUTTON_REMOVE'
,p_message_language=>'fr'
,p_message_text=>'Enlever'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276332168834866653)
,p_name=>'APEX.LIST_MANAGER.SELECTED_ENTRY'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es s\00E9lectionn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277509393797867414)
,p_name=>'APEX.LTO.ADVANCED'
,p_message_language=>'fr'
,p_message_text=>unistr('Avanc\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277509689660867415)
,p_name=>'APEX.LTO.CANCEL'
,p_message_language=>'fr'
,p_message_text=>'Annuler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277509434404867414)
,p_name=>'APEX.LTO.COMMON'
,p_message_language=>'fr'
,p_message_text=>'Commun'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277509707816867415)
,p_name=>'APEX.LTO.LIVE_TEMPLATE_OPTIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Options de mod\00E8le en service')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277510900582867415)
,p_name=>'APEX.LTO.NOT_APPLICABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Les options de mod\00E8le ne sont pas disponibles car ce composant n''est pas affich\00E9 sur la page.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277509206433867414)
,p_name=>'APEX.LTO.NO_OPTIONS_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune option de mod\00E8le n''a \00E9t\00E9 trouv\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277509563561867414)
,p_name=>'APEX.LTO.SAVE'
,p_message_language=>'fr'
,p_message_text=>'Enregistrer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277507000195867413)
,p_name=>'APEX.MARKDOWN.BOLD'
,p_message_language=>'fr'
,p_message_text=>'Gras'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277508329579867414)
,p_name=>'APEX.MARKDOWN.IMAGE'
,p_message_language=>'fr'
,p_message_text=>'Image'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277507917171867413)
,p_name=>'APEX.MARKDOWN.INLINE_CODE'
,p_message_language=>'fr'
,p_message_text=>unistr('Code incorpor\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277602824340867474)
,p_name=>'APEX.MARKDOWN.INSERT_IMAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Ins\00E9rer une image')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277602933878867474)
,p_name=>'APEX.MARKDOWN.INSERT_LINK'
,p_message_language=>'fr'
,p_message_text=>unistr('Ins\00E9rer un lien')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277507199429867413)
,p_name=>'APEX.MARKDOWN.ITALIC'
,p_message_language=>'fr'
,p_message_text=>'Italique'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277604669530867475)
,p_name=>'APEX.MARKDOWN.LINK'
,p_message_language=>'fr'
,p_message_text=>'Lien'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277508240283867414)
,p_name=>'APEX.MARKDOWN.LIST'
,p_message_language=>'fr'
,p_message_text=>'Liste'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277508130309867414)
,p_name=>'APEX.MARKDOWN.ORDERED_LIST'
,p_message_language=>'fr'
,p_message_text=>unistr('Liste tri\00E9e')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277507262470867413)
,p_name=>'APEX.MARKDOWN.PREVIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Aper\00E7u')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277507727727867413)
,p_name=>'APEX.MARKDOWN.PREVIEW_EMPTY'
,p_message_language=>'fr'
,p_message_text=>unistr('Il n''y a rien \00E0 pr\00E9visualiser')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277507887149867413)
,p_name=>'APEX.MARKDOWN.STRIKETHROUGH'
,p_message_language=>'fr'
,p_message_text=>unistr('Barr\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277508061149867414)
,p_name=>'APEX.MARKDOWN.UNORDERED_LIST'
,p_message_language=>'fr'
,p_message_text=>unistr('Liste non tri\00E9e')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277135776607867172)
,p_name=>'APEX.MENU.CURRENT_MENU'
,p_message_language=>'fr'
,p_message_text=>'en cours'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277675909266867522)
,p_name=>'APEX.MENU.OVERFLOW_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Plus...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277135685414867172)
,p_name=>'APEX.MENU.PROCESSING'
,p_message_language=>'fr'
,p_message_text=>'Chargement'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277586562180867464)
,p_name=>'APEX.NOTIFICATION_MESSAGE_HEADING'
,p_message_language=>'fr'
,p_message_text=>'Message de notification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276497802204866761)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur de contenu de checksum de message de notification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276497739115866761)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur de format de checksum de message de notification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277211215638867221)
,p_name=>'APEX.NUMBER_FIELD.VALUE_GREATER_MAX_VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur #LABEL# est sup\00E9rieure \00E0 la valeur maximale indiqu\00E9e %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277211343983867221)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur #LABEL# doit \00EAtre num\00E9rique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277211481873867221)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID2'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur #LABEL# ne correspond pas au format num\00E9rique %0 (exemple : %1).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277211104844867221)
,p_name=>'APEX.NUMBER_FIELD.VALUE_LESS_MIN_VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur #LABEL# est inf\00E9rieure \00E0 la valeur minimale indiqu\00E9e %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277211082574867221)
,p_name=>'APEX.NUMBER_FIELD.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'fr'
,p_message_text=>'La valeur #LABEL# ne figure pas dans la plage valide comprise entre %0 et %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276736858499866915)
,p_name=>'APEX.PAGE.DUPLICATE_SUBMIT'
,p_message_language=>'fr'
,p_message_text=>unistr('Cette page a d\00E9j\00E0 \00E9t\00E9 soumise ; elle ne peut pas l''\00EAtre de nouveau.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276599593912866827)
,p_name=>'APEX.PAGE.NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>'L''application "%0", page "%1", est introuvable.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276880435650867006)
,p_name=>'APEX.PAGE_ITEM_IS_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>'Le champ #LABEL# doit contenir une valeur.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277616173123867483)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_language=>'fr'
,p_message_text=>'A propos de cette application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277615936887867483)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_language=>'fr'
,p_message_text=>'Options de configuration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277616012280867483)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lection du style de th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277277936797867264)
,p_name=>'APEX.POPUP_LOV.BUTTON_CLOSE'
,p_message_language=>'fr'
,p_message_text=>'Fermer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277277828252867264)
,p_name=>'APEX.POPUP_LOV.BUTTON_FIND'
,p_message_language=>'fr'
,p_message_text=>'Rechercher %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277278146726867265)
,p_name=>'APEX.POPUP_LOV.BUTTON_NEXT'
,p_message_language=>'fr'
,p_message_text=>'Suivant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277278099987867265)
,p_name=>'APEX.POPUP_LOV.BUTTON_PREV'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9c\00E9dent')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276355463544866667)
,p_name=>'APEX.POPUP_LOV.FILTER_REQ'
,p_message_language=>'fr'
,p_message_text=>unistr('Saisissez un terme de recherche comportant au moins %0 caract\00E8res.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276929788721867038)
,p_name=>'APEX.POPUP_LOV.ICON_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Liste de valeurs (LOV) instantan\00E9e : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276355562192866667)
,p_name=>'APEX.POPUP_LOV.INITIAL_FILTER_REQ'
,p_message_language=>'fr'
,p_message_text=>'Saisissez un terme de recherche.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276355346014866667)
,p_name=>'APEX.POPUP_LOV.NO_RESULTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun r\00E9sultat trouv\00E9.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276355264725866667)
,p_name=>'APEX.POPUP_LOV.REMOVE_VALUE'
,p_message_language=>'fr'
,p_message_text=>'Enlever %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277097949240867148)
,p_name=>'APEX.POPUP_LOV.SEARCH'
,p_message_language=>'fr'
,p_message_text=>'Terme de recherche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277277755936867264)
,p_name=>'APEX.POPUP_LOV.TITLE'
,p_message_language=>'fr'
,p_message_text=>'Dialogue de recherche'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276358001319866669)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible d''obtenir la valeur de la cl\00E9 primaire suivante ou pr\00E9c\00E9dente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277090964346867143)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>'Le service Web est introuvable.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276601007880866828)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur de traitement du processus.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277570191057867453)
,p_name=>'APEX.PROCESSING'
,p_message_language=>'fr'
,p_message_text=>'Traitement'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276384710554866685)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Application Express n''a pas pu traiter la demande en raison de limitations de ressources de session de base de donn\00E9es. R\00E9essayez plus tard.'),
'<p/>',
unistr('Pour obtenir des d\00E9tails concernant cet incident, vous pouvez utiliser l''ID de d\00E9bogage "%0".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277627199197867490)
,p_name=>'APEX.REGION.CSSCALENDAR.ADD'
,p_message_language=>'fr'
,p_message_text=>'Ajouter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277049309648867116)
,p_name=>'APEX.REGION.CSSCALENDAR.ALL_DAY'
,p_message_language=>'fr'
,p_message_text=>unistr('Toute la journ\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277699466428867537)
,p_name=>'APEX.REGION.CSSCALENDAR.BUTTON.SENDEMAIL'
,p_message_language=>'fr'
,p_message_text=>'Envoyer une invitation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277699138079867537)
,p_name=>'APEX.REGION.CSSCALENDAR.CHOOSE_ACTION'
,p_message_language=>'fr'
,p_message_text=>'Options'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277064434802867126)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_ALLDAY'
,p_message_language=>'fr'
,p_message_text=>unistr('Vue quotidienne pour toute la journ\00E9e ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277064221719867126)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_TIME_SPECIFIC'
,p_message_language=>'fr'
,p_message_text=>unistr('Vue quotidienne pour les donn\00E9es avec l''heure ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277589094363867465)
,p_name=>'APEX.REGION.CSSCALENDAR.DAY'
,p_message_language=>'fr'
,p_message_text=>'jour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277535974938867431)
,p_name=>'APEX.REGION.CSSCALENDAR.DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>'Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276447015378866727)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.CSV'
,p_message_language=>'fr'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276446865499866727)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.ICALENDAR'
,p_message_language=>'fr'
,p_message_text=>'iCal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276446745572866727)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.PDF'
,p_message_language=>'fr'
,p_message_text=>'PDF'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276446926706866727)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.XML'
,p_message_language=>'fr'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276446486817866726)
,p_name=>'APEX.REGION.CSSCALENDAR.ENDDATE'
,p_message_language=>'fr'
,p_message_text=>'Date de fin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276446617127866727)
,p_name=>'APEX.REGION.CSSCALENDAR.EVENTNAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom d''\00E9v\00E9nement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277699254275867537)
,p_name=>'APEX.REGION.CSSCALENDAR.INVITATION'
,p_message_language=>'fr'
,p_message_text=>'Invitation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277589110290867465)
,p_name=>'APEX.REGION.CSSCALENDAR.LIST'
,p_message_language=>'fr'
,p_message_text=>'Liste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277588828432867465)
,p_name=>'APEX.REGION.CSSCALENDAR.MONTH'
,p_message_language=>'fr'
,p_message_text=>'Mois'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277603844926867475)
,p_name=>'APEX.REGION.CSSCALENDAR.NEXT'
,p_message_language=>'fr'
,p_message_text=>'Suivant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277657518457867510)
,p_name=>'APEX.REGION.CSSCALENDAR.NOEVENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun \00E9v\00E9nement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277699893008867537)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.FORM'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifiez un \00E9v\00E9nement existant.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277699762956867537)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.SEND'
,p_message_language=>'fr'
,p_message_text=>'Envoi d''une invitation par courriel.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277603929191867475)
,p_name=>'APEX.REGION.CSSCALENDAR.PREVIOUS'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9c\00E9dent')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277643299340867500)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL'
,p_message_language=>'fr'
,p_message_text=>'Envoyer un courriel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277642820274867500)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.BUTTON'
,p_message_language=>'fr'
,p_message_text=>'Envoyer un courriel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277706804020867541)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.REQUIRED'
,p_message_language=>'fr'
,p_message_text=>'Tous les champs sont obligatoires.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277706726883867541)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.TITLE'
,p_message_language=>'fr'
,p_message_text=>'Envoyer une invitation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277698895195867536)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.SUBJECT'
,p_message_language=>'fr'
,p_message_text=>'Objet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277643166691867500)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.TO'
,p_message_language=>'fr'
,p_message_text=>'A'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276446507319866727)
,p_name=>'APEX.REGION.CSSCALENDAR.STARTDATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Date de d\00E9but')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277623847246867488)
,p_name=>'APEX.REGION.CSSCALENDAR.TABLEFORM'
,p_message_language=>'fr'
,p_message_text=>'Panneau sur %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277064012450867126)
,p_name=>'APEX.REGION.CSSCALENDAR.TIME'
,p_message_language=>'fr'
,p_message_text=>'Temps'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277604545932867475)
,p_name=>'APEX.REGION.CSSCALENDAR.TODAY'
,p_message_language=>'fr'
,p_message_text=>'Aujourd''hui'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277589907461867466)
,p_name=>'APEX.REGION.CSSCALENDAR.VIEW'
,p_message_language=>'fr'
,p_message_text=>'Vue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277588991020867465)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEK'
,p_message_language=>'fr'
,p_message_text=>'semaine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277064315136867126)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_ALLDAY'
,p_message_language=>'fr'
,p_message_text=>unistr('Vue hebdomadaire pour toute la journ\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277064111662867126)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_TIME_SPECIFIC'
,p_message_language=>'fr'
,p_message_text=>unistr('Vue hebdomadaire pour les donn\00E9es avec l''heure')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277589580753867466)
,p_name=>'APEX.REGION.CSSCALENDAR.YEAR'
,p_message_language=>'fr'
,p_message_text=>unistr('Ann\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276358387244866669)
,p_name=>'APEX.REGION.FLASH_CHART.INITIALIZING'
,p_message_language=>'fr'
,p_message_text=>'Initialisation...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276617750528866839)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_DATA'
,p_message_language=>'fr'
,p_message_text=>unistr('Chargement des donn\00E9es...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277628614391867491)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_RESOURCES'
,p_message_language=>'fr'
,p_message_text=>'Chargement des ressources...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277628749826867491)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_TEMPLATES'
,p_message_language=>'fr'
,p_message_text=>unistr('Chargement des mod\00E8les...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276358474815866669)
,p_name=>'APEX.REGION.FLASH_CHART.NO_DATA_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune donn\00E9e n''a \00E9t\00E9 trouv\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276523230703866777)
,p_name=>'APEX.REGION.FLASH_CHART.SHOW_XML'
,p_message_language=>'fr'
,p_message_text=>'Afficher XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276617812043866839)
,p_name=>'APEX.REGION.FLASH_CHART.WAITING'
,p_message_language=>'fr'
,p_message_text=>unistr('Chargement des donn\00E9es. Veuillez patienter.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277589206319867465)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277589356898867466)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.LOAD_MORE'
,p_message_language=>'fr'
,p_message_text=>unistr('Charger plus d''\00E9l\00E9ments...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276790117382866948)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.BACK'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9c\00E9dent')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276386270817866686)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.LOAD_MORE'
,p_message_language=>'fr'
,p_message_text=>unistr('Charger plus d''\00E9l\00E9ments...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276411235624866702)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.SEARCH'
,p_message_language=>'fr'
,p_message_text=>'Rechercher...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277589412688867466)
,p_name=>'APEX.REGION.JQM_REFLOW.LOAD_MORE'
,p_message_language=>'fr'
,p_message_text=>unistr('Charger plus d''\00E9l\00E9ments...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277603171150867474)
,p_name=>'APEX.REGION.NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('ID de r\00E9gion %0 introuvable.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276397476999866693)
,p_name=>'APEX.REGION.NO_DATA_FOUND_MESSAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune donn\00E9e d\00E9tect\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276605439362866831)
,p_name=>'APEX.REGION.PAGINATION.RESET_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de r\00E9initialiser la pagination de r\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276358231513866669)
,p_name=>'APEX.REGION.PAGINATION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur lors de la d\00E9finition de pagination de r\00E9gion.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277530623399867428)
,p_name=>'APEX.REGION.RESPONSIVE_TABLE.COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277603012765867474)
,p_name=>'APEX.REGION.TYPE_NOT_SUPPORTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le type de r\00E9gion %0 n''est pas pris en charge.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276358192426866669)
,p_name=>'APEX.REGION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur lors de l''affichage de la r\00E9gion "#COMPONENT_NAME#".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276880569065867006)
,p_name=>'APEX.REGION_COLUMN_IS_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>'Le champ #COLUMN_HEADER# doit contenir une valeur.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277060627381867123)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_language=>'fr'
,p_message_text=>'Echec de l''authentification pour le service SQL compatible REST.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276385037801866685)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_language=>'fr'
,p_message_text=>unistr('Echec de l''authentification. La liste de valeurs utilise une source de donn\00E9es de type SQL compatible REST qui fait r\00E9f\00E9rence \00E0 des informations d''identification Web non valides. Vous ne pourrez pas modifier les informations de colonne de cette liste')
||unistr(' de valeurs. V\00E9rifiez les informations d''identification d''authentification. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277598998890867472)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_language=>'fr'
,p_message_text=>unistr('Echec de la communication. Un probl\00E8me s''est produit lors de l''appel de la source de donn\00E9es de type SQL compatible REST r\00E9f\00E9renc\00E9e par la liste de valeurs (LOV). Vous ne pourrez pas modifier les informations de colonne de la liste de valeurs. V\00E9rifi')
||unistr('ez que la source de donn\00E9es de type SQL compatible REST fonctionne correctement et que les informations d''identification d''authentification correspondantes sont correctes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277128384732867168)
,p_name=>'APEX.REMOTESQL.OAUTH_IS_RECOMMENDED'
,p_message_language=>'fr'
,p_message_text=>'Avertissement : Oracle recommande d''utiliser des informations d''identification de client OAuth pour l''authentification avec le SQL compatible REST.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277062039442867124)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur sur le serveur distant : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277018831493867095)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Instance SQL compatible REST ORDS indiqu\00E9e introuvable.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276620098328866840)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_language=>'fr'
,p_message_text=>unistr('Le serveur a envoy\00E9 une redirection vers : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276908063193867024)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_language=>'fr'
,p_message_text=>unistr('L''instruction SQL est sup\00E9rieure \00E0 32,767 octets.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276927929344867036)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Bonjour, Application Express ! Vous \00EAtes connect\00E9 en tant que #USER#.'),
unistr('L''horodatage de la base de donn\00E9e locale est : #SYSDATE#.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277256074261867250)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous modifiez l''alias du sch\00E9ma par d\00E9faut de l''espace de travail. En d\00E9finissant cet alias, vous modifiez \00E9galement le pr\00E9fixe de chemin au niveau de l''espace de travail. Cela aura une incidence sur l''URL des services RESTful bas\00E9s sur APEX que vous')
||unistr(' avez peut-\00EAtre d\00E9finie.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276915260422867028)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ORDS'
,p_message_language=>'fr'
,p_message_text=>'La version d''ORDS en cours ne prend pas en charge l''interface d''administration REST.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276915397607867028)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ROLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Le r\00F4le de client donn\00E9 n''est pas pris en charge par l''interface d''administration REST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277694666168867534)
,p_name=>'APEX.RICH_TEXT_EDITOR.ACCESSIBLE_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('%0, \00E9diteur de texte enrichi')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276905619662867022)
,p_name=>'APEX.RICH_TEXT_EDITOR.MAXIMUM_LENGTH_EXCEEDED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le balisage HTML de texte enrichi d\00E9passe la longueur maximale de l''\00E9l\00E9ment (r\00E9elle : %0, autoris\00E9e : %1 caract\00E8res)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277587805007867465)
,p_name=>'APEX.RV.DELETE'
,p_message_language=>'fr'
,p_message_text=>'Supprimer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277513602276867417)
,p_name=>'APEX.RV.DUPLICATE'
,p_message_language=>'fr'
,p_message_text=>'Dupliquer'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277508896237867414)
,p_name=>'APEX.RV.EXCLUDE_HIDDEN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes affich\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277508782047867414)
,p_name=>'APEX.RV.EXCLUDE_NULL'
,p_message_language=>'fr'
,p_message_text=>'Exclure les valeurs NULL'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277587980292867465)
,p_name=>'APEX.RV.INSERT'
,p_message_language=>'fr'
,p_message_text=>'Ajouter'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277048094466867115)
,p_name=>'APEX.RV.MOVE_DOWN'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9placer vers le bas')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277048149863867115)
,p_name=>'APEX.RV.MOVE_UP'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9placer vers le haut')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277508515558867414)
,p_name=>'APEX.RV.NEXT_RECORD'
,p_message_language=>'fr'
,p_message_text=>'Suivant'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277509121259867414)
,p_name=>'APEX.RV.NOT_GROUPED_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Autres colonnes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277508649361867414)
,p_name=>'APEX.RV.PREV_RECORD'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9c\00E9dent')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277508934940867414)
,p_name=>'APEX.RV.REC_X'
,p_message_language=>'fr'
,p_message_text=>'Ligne %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277509079986867414)
,p_name=>'APEX.RV.REC_XY'
,p_message_language=>'fr'
,p_message_text=>'Ligne %0 sur %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277513766633867417)
,p_name=>'APEX.RV.REFRESH'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9g\00E9n\00E9rer')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277513876322867417)
,p_name=>'APEX.RV.REVERT'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9tablir les modifications')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277508469620867414)
,p_name=>'APEX.RV.SETTINGS_MENU'
,p_message_language=>'fr'
,p_message_text=>unistr('Menu Param\00E8tres')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276982843692867072)
,p_name=>'APEX.SAMPLE_FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Par exemple, %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276905760473867022)
,p_name=>'APEX.SC.REFERENCES'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 r\00E9f\00E9rences')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277247332416867244)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_language=>'fr'
,p_message_text=>'Utilitaires'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277247476894867245)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Utilitaires d''application \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277254841541867249)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Aller \00E0 la page')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277254778823867249)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9der aux composants partag\00E9s')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277247560718867245)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_language=>'fr'
,p_message_text=>'App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277247664895867245)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E2ches d''App Builder > ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277247723469867245)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277247889080867245)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C El\00E9ments d''application \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277247949899867245)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_language=>'fr'
,p_message_text=>'Logique d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277248036567867245)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les d''authentification')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277248166830867245)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Mod\00E8les d''authentification de s\00E9curit\00E9 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277248254332867245)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les d''autorisation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277248384274867245)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Mod\00E8les d''autorisation de s\00E9curit\00E9 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277248464908867245)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_language=>'fr'
,p_message_text=>'Chemins de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277248507024867245)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Chemins de navigation \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277248669811867245)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_language=>'fr'
,p_message_text=>'Options de construction'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277248701667867245)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Options de construction \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277248887753867245)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de composant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277248900366867246)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Param\00E8tres de composant \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277249017437867246)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_language=>'fr'
,p_message_text=>'Calculs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277249120593867246)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Calculs d''application \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277249239338867246)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un \00E9l\00E9ment d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277249311416867246)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un mod\00E8le d''authentification')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277249431071867246)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er une option de construction')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277249511161867246)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un calcul d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277249612704867246)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un mod\00E8le de courriel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277249786514867246)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un module d''extension')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277249824767867246)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277249959119867246)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er des informations d''identification Web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277250070709867246)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finitions de chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277250126548867246)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C D\00E9finitions de chargement des donn\00E9es \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277250242446867246)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_language=>'fr'
,p_message_text=>unistr('Sources de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277250386184867247)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_language=>'fr'
,p_message_text=>unistr('Attributs de d\00E9finition')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277250456423867247)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de courriel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277250543973867247)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Mises en page d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277250651833867247)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Mises en page d''\00E9tat \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277250706919867247)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_language=>'fr'
,p_message_text=>unistr('Services Web h\00E9rit\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277250852634867247)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Services Web h\00E9rit\00E9s \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277250974328867247)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_language=>'fr'
,p_message_text=>'Listes de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277251080909867247)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Listes de navigation classiques \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277251129575867247)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_language=>'fr'
,p_message_text=>'Liste de valeurs (LOV)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277251291490867247)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Liste de valeurs (LOV) \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277251333931867247)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_language=>'fr'
,p_message_text=>'Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277251424123867247)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_language=>'fr'
,p_message_text=>'Autres composants'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277251543048867247)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_language=>'fr'
,p_message_text=>'Modules d''extension'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277251666159867247)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Modules d''extension \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277251724021867247)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_language=>'fr'
,p_message_text=>'Processus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277251872252867247)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Processus d''application \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277251926944867248)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAtes d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277252090910867248)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Requ\00EAtes d''\00E9tat \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277252149116867248)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_language=>'fr'
,p_message_text=>'Etats'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277252240983867248)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_language=>'fr'
,p_message_text=>'SQL compatible REST'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277252346283867248)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C SQL compatible REST \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277252407168867248)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9curit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277252564246867248)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_language=>'fr'
,p_message_text=>'Protection de statut de session'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277252677867867248)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir la protection de statut d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277252870955867248)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Composants partag\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277252939702867248)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277253010052867248)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_language=>'fr'
,p_message_text=>'Raccourcis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277253122395867248)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Raccourcis \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277253208946867248)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_language=>'fr'
,p_message_text=>unistr('Onglets (h\00E9rit\00E9)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277253392650867248)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277253474023867248)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Mod\00E8les d''IU \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277253556216867249)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_language=>'fr'
,p_message_text=>unistr('Th\00E8mes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277253611914867249)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Th\00E8mes d''IU \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277253761946867249)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_language=>'fr'
,p_message_text=>'Interface utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277253899356867249)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_language=>'fr'
,p_message_text=>'Informations d''identification Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277253919052867249)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Informations d''identification Web de s\00E9curit\00E9 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277254075795867249)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_language=>'fr'
,p_message_text=>'Modules de source Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277254183072867249)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9dez \00E0 : Composants partag\00E9s \005C Modules de source Web \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277254208107867249)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_language=>'fr'
,p_message_text=>'SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277254349906867249)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un objet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277254436367867249)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er %LIST_ITEM_NAME% dans SQL Workshop')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277254593094867249)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_language=>'fr'
,p_message_text=>'Editeur de script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277254631893867249)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E2ches de SQL Workshop')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277637167600867496)
,p_name=>'APEX.SESSION.DB_SESSION_CLEANUP.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur lors du traitement du code de nettoyage de session de base de donn\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276599080075866827)
,p_name=>'APEX.SESSION.DB_SESSION_INIT.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur lors du traitement du code de configuration de session de base de donn\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276372712030866678)
,p_name=>'APEX.SESSION.EXPIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre session a expir\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277628863865867491)
,p_name=>'APEX.SESSION.EXPIRED.CLOSE_DIALOG'
,p_message_language=>'fr'
,p_message_text=>unistr('Fermez cette bo\00EEte de dialogue et appuyez sur le bouton Recharger de votre navigateur pour obtenir une nouvelle session.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277689046447867530)
,p_name=>'APEX.SESSION.EXPIRED.NEW_SESSION'
,p_message_language=>'fr'
,p_message_text=>unistr('Cliquez <a href="%0">ici</a> pour cr\00E9er une session.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277052115163867118)
,p_name=>'APEX.SESSION.RAS.NO_DYNAMIC_ROLES'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun r\00F4le dynamique n''a pu \00EAtre activ\00E9 dans la session Real Application Security pour l''utilisateur "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276591993475866823)
,p_name=>'APEX.SESSION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('ERR-99900 Impossible de cr\00E9er l''ID de session unique : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277700142673867537)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment de page %0 repose sur une colonne de base de donn\00E9es, mais l''attribut ''Source utilis\00E9e'' est d\00E9fini sur ''Uniquement lorsque la valeur en cours dans le statut de session est NULL''. Ceci est tr\00E8s dangereux et peut entra\00EEner l''\00E9crasement accide')
||unistr('ntel des donn\00E9es lors de l''affichage et de l''enregistrement de plusieurs enregistrements. D\00E9finissez toujours ''Source utilis\00E9e'' sur ''Toujours, en rempla\00E7ant les valeurs existantes dans le statut de session''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277609691702867479)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''acc\00E8s au statut de session est d\00E9sactiv\00E9. La tentative de lecture/\00E9criture a \00E9t\00E9 bloqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276410319737866701)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Tentative d''enregistrement de l''\00E9l\00E9ment %0 dans le statut de session lors du traitement de l''affichage. L''\00E9l\00E9ment a une protection de niveau "Interne uniquement".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276391710575866689)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_language=>'fr'
,p_message_text=>unistr('Tentative d''enregistrement de l''\00E9l\00E9ment %0 dans le statut de session lors du traitement de l''acceptation. L''\00E9l\00E9ment a une protection de niveau "Interne uniquement" ou n''est pas un \00E9l\00E9ment de panneau pouvant \00EAtre envoy\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276666229612866870)
,p_name=>'APEX.SESSION_STATE.ITEM_VALUE_PROTECTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Violation de protection de l''\00E9tat de session. Cause possible : modification manuelle de l''\00E9l\00E9ment de page prot\00E9g\00E9 %0. Si vous n''\00EAtes pas s\00FBr de la cause de l''erreur, contactez l''administrateur de l''application pour obtenir de l''aide.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277725190451867553)
,p_name=>'APEX.SESSION_STATE.PAGE_PROTECTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Violation de protection de page. Cause possible : soumission d''une page dont le chargement n''est pas encore termin\00E9 ou modification manuelle d''\00E9l\00E9ments de page prot\00E9g\00E9s. Pour obtenir de l''aide, contactez l''administrateur de l''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277722050165867551)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 contient l''un des caract\00E8res non valides suivants : &<>"/;,*|=% ou --')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277722197723867551)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR_NL'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 contient l''un des caract\00E8res non valides suivants : &<>"/;,*|=% ou --, ou un saut de ligne.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277721817057867551)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.US_ONLY'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 contient des caract\00E8res sp\00E9ciaux. Seuls les caract\00E8res a-Z, 0-9 et les espaces sont autoris\00E9s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277721955431867551)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 contient <, > ou ", qui ne sont pas des caract\00E8res valides.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276391373439866689)
,p_name=>'APEX.SESSION_STATE.SSP_CHECKSUM_MISSING'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun checksum n''a \00E9t\00E9 fourni au traitement de l''affichage d''une page exigeant un checksum lorsqu''une ou plusieurs demandes, suppressions de cache ou valeurs d''argument sont transmises en tant que param\00E8tres.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276653280569866861)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Violation de protection du statut de session. Cause possible : modification manuelle d''une URL contenant un checksum ou utilisation d''un lien dont le checksum est incorrect ou absent. Si vous n''\00EAtes pas s\00FBr de la cause de l''erreur, contactez votre ad')
||'ministrateur pour obtenir de l''aide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276391458705866689)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Le checksum calcul\00E9 sur la demande, l''effacement du cache, les noms d''argument et les valeurs d''argument (%0) ne concordent pas avec le checksum transmis \00E0 la proc\00E9dure d''affichage (%1).'),
'',
'Remarque : les utilisateurs finals obtiennent un message d''erreur distinct.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276390389981866688)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Tentative d''enregistrement de l''\00E9l\00E9ment %0 dans l''\00E9tat de session au cours du traitement de l''affichage. Le niveau de protection de l''\00E9l\00E9ment est :'),
'  %1',
'',
unistr('Aucun checksum n''a \00E9t\00E9 transmis ou celui qui a \00E9t\00E9 transmis conviendrait \00E0 un \00E9l\00E9ment de niveau de protection "%2".'),
'',
unistr('Remarque : les utilisateurs finals obtiennent un message d''erreur diff\00E9rent.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276600859873866828)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'ERR-1022 Impossible d''enregistrer les attributs.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277509874832867415)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_OFF'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactiver le mode de contraste \00E9lev\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277509961168867415)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_ON'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer le mode de contraste \00E9lev\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276625608200866844)
,p_name=>'APEX.SHUTTLE.CONTROL_BOTTOM'
,p_message_language=>'fr'
,p_message_text=>'Tout en bas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276625866260866844)
,p_name=>'APEX.SHUTTLE.CONTROL_DOWN'
,p_message_language=>'fr'
,p_message_text=>'Bas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276625923736866844)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9placer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276626066407866844)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE_ALL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9placer tout')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276626194218866844)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE'
,p_message_language=>'fr'
,p_message_text=>'Enlever'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276626242093866844)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE_ALL'
,p_message_language=>'fr'
,p_message_text=>'Enlever tout'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276626308506866844)
,p_name=>'APEX.SHUTTLE.CONTROL_RESET'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9initialiser')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276625515246866844)
,p_name=>'APEX.SHUTTLE.CONTROL_TOP'
,p_message_language=>'fr'
,p_message_text=>'Tout en haut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276625723189866844)
,p_name=>'APEX.SHUTTLE.CONTROL_UP'
,p_message_language=>'fr'
,p_message_text=>'Haut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277663042152867513)
,p_name=>'APEX.SINCE.SHORT.DAYS_AGO'
,p_message_language=>'fr'
,p_message_text=>'%0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277663734090867514)
,p_name=>'APEX.SINCE.SHORT.DAYS_FROM_NOW'
,p_message_language=>'fr'
,p_message_text=>'dans %0 jours(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277662999256867513)
,p_name=>'APEX.SINCE.SHORT.HOURS_AGO'
,p_message_language=>'fr'
,p_message_text=>'%0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277663806062867514)
,p_name=>'APEX.SINCE.SHORT.HOURS_FROM_NOW'
,p_message_language=>'fr'
,p_message_text=>'dans %0 h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277662701372867513)
,p_name=>'APEX.SINCE.SHORT.MINUTES_AGO'
,p_message_language=>'fr'
,p_message_text=>'%0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277663954961867514)
,p_name=>'APEX.SINCE.SHORT.MINUTES_FROM_NOW'
,p_message_language=>'fr'
,p_message_text=>'dans %0 min'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277663382672867513)
,p_name=>'APEX.SINCE.SHORT.MONTHS_AGO'
,p_message_language=>'fr'
,p_message_text=>'%0 mois'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277663595858867514)
,p_name=>'APEX.SINCE.SHORT.MONTHS_FROM_NOW'
,p_message_language=>'fr'
,p_message_text=>'dans %0 mois'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277662866313867513)
,p_name=>'APEX.SINCE.SHORT.SECONDS_AGO'
,p_message_language=>'fr'
,p_message_text=>'%0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277663603461867514)
,p_name=>'APEX.SINCE.SHORT.SECONDS_FROM_NOW'
,p_message_language=>'fr'
,p_message_text=>'dans %0 s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277663157976867513)
,p_name=>'APEX.SINCE.SHORT.WEEKS_AGO'
,p_message_language=>'fr'
,p_message_text=>'%0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277664042044867514)
,p_name=>'APEX.SINCE.SHORT.WEEKS_FROM_NOW'
,p_message_language=>'fr'
,p_message_text=>'dans %0 semaine(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277663269234867513)
,p_name=>'APEX.SINCE.SHORT.YEARS_AGO'
,p_message_language=>'fr'
,p_message_text=>'%0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277663480574867514)
,p_name=>'APEX.SINCE.SHORT.YEARS_FROM_NOW'
,p_message_language=>'fr'
,p_message_text=>'dans %0 an(s)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276839402896866980)
,p_name=>'APEX.SPLITTER.COLLAPSE_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9duire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276839338795866980)
,p_name=>'APEX.SPLITTER.RESTORE_TEXT'
,p_message_language=>'fr'
,p_message_text=>'Restaurer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277246375284867244)
,p_name=>'APEX.STAR_RATING.CLEAR_RATING'
,p_message_language=>'fr'
,p_message_text=>unistr('Effacer l''\00E9valuation')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277210371028867221)
,p_name=>'APEX.STAR_RATING.INVALID_RATING_RANGE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur %0 ne figure pas dans la plage d''\00E9valuation valide comprise entre 1 et %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277210415174867221)
,p_name=>'APEX.STAR_RATING.IS_NOT_NUMERIC'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 n''est pas une valeur num\00E9rique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277182363665867202)
,p_name=>'APEX.SUCCESS_MESSAGE_HEADING'
,p_message_language=>'fr'
,p_message_text=>unistr('Message de succ\00E8s')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276498061678866761)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur de contenu de checksum de message de succ\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276497944992866761)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur de format de checksum de message de succ\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277694225545867533)
,p_name=>'APEX.TABS.NEXT'
,p_message_language=>'fr'
,p_message_text=>'Suivant'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277694179133867533)
,p_name=>'APEX.TABS.PREVIOUS'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9c\00E9dent')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276349492748866664)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur lors du calcul de la valeur par d\00E9faut de la colonne #COMPONENT_NAME#.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276350072079866664)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement du processus de suppression multiligne.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276635099787866850)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne de checksum ("FCS") est obligatoire ; elle n''a pas \00E9t\00E9 indiqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276635281771866850)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune valeur de cl\00E9 primaire n''a \00E9t\00E9 indiqu\00E9e. Au moins une ligne doit \00EAtre indiqu\00E9e pour que les mises \00E0 jour puissent avoir lieu.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276636093665866850)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune valeur secondaire n''a \00E9t\00E9 indiqu\00E9e pour la colonne de cl\00E9 secondaire identifi\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276752991928866925)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_language=>'fr'
,p_message_text=>unistr('aucune donn\00E9e trouv\00E9e dans le panneau tabulaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276634993393866850)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne de cl\00E9 primaire n''a pas \00E9t\00E9 indiqu\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276635949680866850)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne de cl\00E9 secondaire identifi\00E9e ne se trouve pas dans la liste SELECT de la requ\00EAte.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276634814233866850)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nom de table n''est pas indiqu\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276634722116866850)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le propri\00E9taire de la table n''est pas indiqu\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276657037564866864)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur lors du traitement du processus de mise \00E0 jour multiligne.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277657622620867510)
,p_name=>'APEX.TB.TOOLBAR'
,p_message_language=>'fr'
,p_message_text=>'Barre d''outils'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276518391628866774)
,p_name=>'APEX.TEAM.COMMITTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Valid\00E9 (commit)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276518185803866774)
,p_name=>'APEX.TEAM.CONTRIBUTOR'
,p_message_language=>'fr'
,p_message_text=>'Contributeur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276520094890866775)
,p_name=>'APEX.TEAM.CREATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctionnalit\00E9 %0 ajout\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276520197283866775)
,p_name=>'APEX.TEAM.DELETE'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctionnalit\00E9 %0 supprim\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276340420054866658)
,p_name=>'APEX.TEAM.DEPRECATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le d\00E9veloppement d''\00E9quipe APEX est en phase d''abandon depuis la version 19.2 et sera enlev\00E9 des versions ult\00E9rieures. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276518415591866774)
,p_name=>'APEX.TEAM.ESTIMATED_EFFORT'
,p_message_language=>'fr'
,p_message_text=>'Estimation des efforts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276518749950866774)
,p_name=>'APEX.TEAM.FEATURE_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>'Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276517943958866774)
,p_name=>'APEX.TEAM.FEATURE_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctionnalit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276518516591866774)
,p_name=>'APEX.TEAM.FEATURE_STATUS'
,p_message_language=>'fr'
,p_message_text=>unistr('Statut de fonctionnalit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276518686530866774)
,p_name=>'APEX.TEAM.MILESTONE'
,p_message_language=>'fr'
,p_message_text=>'Jalon'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276518912471866775)
,p_name=>'APEX.TEAM.NO'
,p_message_language=>'fr'
,p_message_text=>'Non'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276518010582866774)
,p_name=>'APEX.TEAM.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276518218352866774)
,p_name=>'APEX.TEAM.RELEASE'
,p_message_language=>'fr'
,p_message_text=>'Version'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276517012487866773)
,p_name=>'APEX.TEAM.SAVE'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctionnalit\00E9 %0 mise \00E0 jour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276518808496866775)
,p_name=>'APEX.TEAM.YES'
,p_message_language=>'fr'
,p_message_text=>'Oui'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277697022877867535)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_NAV_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9velopper/R\00E9duire la navigation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277697172860867535)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_SIDE_COL_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9velopper/R\00E9duire la colonne lat\00E9rale')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276373154244866678)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de copier le th\00E8me "%0" dans l''application "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277689533477867530)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Le th\00E8me import\00E9 n''est pas compatible avec le th\00E8me en cours.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277655330859867508)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_language=>'fr'
,p_message_text=>unistr('Le num\00E9ro de th\00E8me n''est pas valide ou le th\00E8me pas un th\00E8me d''interface utilisateur en cours.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276979206747867069)
,p_name=>'APEX.TIME.DAY'
,p_message_language=>'fr'
,p_message_text=>'1 jour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276979073956867069)
,p_name=>'APEX.TIME.HOUR'
,p_message_language=>'fr'
,p_message_text=>'1 heure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276979320634867069)
,p_name=>'APEX.TIME.N_DAYS'
,p_message_language=>'fr'
,p_message_text=>'%0 jours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276979171927867069)
,p_name=>'APEX.TIME.N_HOURS'
,p_message_language=>'fr'
,p_message_text=>'%0 heures'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276978956515867069)
,p_name=>'APEX.TIME.N_MINUTES'
,p_message_language=>'fr'
,p_message_text=>'%0 minutes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276979573446867070)
,p_name=>'APEX.TIME.N_WEEKS'
,p_message_language=>'fr'
,p_message_text=>'%0 semaines'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276979473056867069)
,p_name=>'APEX.TIME.WEEK'
,p_message_language=>'fr'
,p_message_text=>'1 semaine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277608762963867478)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('Des colonnes de cl\00E9 primaire et de cl\00E9 parent sont requises pour calculer la hi\00E9rarchie.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277608808741867478)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes de niveau de noeud et de statut de noeud requises lorsque la hi\00E9rarchie n''est pas calcul\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277716746580867548)
,p_name=>'APEX.UI.BACK_TO_TOP'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9but de la page')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276534466998866785)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mode fonc\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276534689550866785)
,p_name=>'APEX.UI.DISABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactiv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276534535909866785)
,p_name=>'APEX.UI.ENABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('Activ\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276974126646867066)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionnez une interface utilisateur dans la liste ci-dessous :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276976612663867068)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 - S\00E9lection d''une interface utilisateur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276349761022866664)
,p_name=>'APEX.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement de la demande.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276494609752866759)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E8s non autoris\00E9 (variable de package de groupe de s\00E9curit\00E9 non d\00E9finie).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276495229674866759)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Impossible d''extraire les informations utilisateur. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276482498821866751)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_language=>'fr'
,p_message_text=>unistr('L''utilisateur %0 a besoin du privil\00E8ge ADMIN pour r\00E9aliser cette op\00E9ration.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276495127720866759)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('L''utilisateur %0 n''a pas indiqu\00E9 d''adresse \00E9lectronique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276450699684866729)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E8s non autoris\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276495029418866759)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>'L''utilisateur %0 n''existe pas.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276600965697866828)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur lors du traitement de la validation.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276983151676867072)
,p_name=>'APEX.VALUE_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>'Valeur obligatoire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277706397538867541)
,p_name=>'APEX.WAIT_UNTIL_PAGE_LOADED'
,p_message_language=>'fr'
,p_message_text=>unistr('Attendez la fin du chargement de la page et r\00E9essayez.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277530222461867428)
,p_name=>'APEX.WARN_ON_UNSAVED_CHANGES'
,p_message_language=>'fr'
,p_message_text=>unistr('Cette page comporte des modifications non enregistr\00E9es.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277610137593867479)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_language=>'fr'
,p_message_text=>unistr('Application Express ne peut pas calculer un profil de donn\00E9es \00E0 partir des donn\00E9es de r\00E9ponse de type : %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277040943025867111)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_language=>'fr'
,p_message_text=>'Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277040858351867111)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_language=>'fr'
,p_message_text=>'Ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277594020146867469)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_language=>'fr'
,p_message_text=>'L''expression de filtre n''est pas une expression JSON valide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277585761568867463)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_language=>'fr'
,p_message_text=>'Le filtre n''est pas pris en charge par Oracle REST Data Services.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276927482578867036)
,p_name=>'APEX.WEBSRC.HIDE_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Masquer les colonnes s\00E9lectionn\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277020340333867096)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_language=>'fr'
,p_message_text=>unistr('HTTP 200 : Succ\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277020473533867096)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_language=>'fr'
,p_message_text=>unistr('HTTP 201 : Cr\00E9\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277019840659867095)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_language=>'fr'
,p_message_text=>'HTTP 400 : Demande incorrecte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277019684777867095)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_language=>'fr'
,p_message_text=>unistr('HTTP 401 : Non autoris\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277019923507867095)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_language=>'fr'
,p_message_text=>'HTTP 403 : Interdit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277019734938867095)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_language=>'fr'
,p_message_text=>'HTTP 404 : Introuvable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277020068189867095)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_language=>'fr'
,p_message_text=>unistr('HTTP 405 : M\00E9thode non autoris\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276339635123866658)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_language=>'fr'
,p_message_text=>'HTTP 407 : Authentification par proxy obligatoire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276339946072866658)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_language=>'fr'
,p_message_text=>'HTTP 409 : Conflit'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276339719285866658)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_language=>'fr'
,p_message_text=>unistr('HTTP 412 : Echec de la condition pr\00E9alable')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276339831538866658)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_language=>'fr'
,p_message_text=>unistr('HTTP 428 : Condition pr\00E9alable obligatoire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277020151293867095)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_language=>'fr'
,p_message_text=>'HTTP 500 : Erreur interne du serveur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277020245304867096)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_language=>'fr'
,p_message_text=>'HTTP 502 : Passerelle incorrecte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277610550334867479)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_language=>'fr'
,p_message_text=>'HTTP 503 : Service non disponible'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277610694180867479)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_language=>'fr'
,p_message_text=>'HTTP 504 : Expiration de la passerelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277530192308867428)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_language=>'fr'
,p_message_text=>unistr('La source Web a renvoy\00E9 une erreur HTTP : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277018727114867095)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>'Module de source Web introuvable.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276563003892866804)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le s\00E9lecteur de ligne "%0" n''a s\00E9lectionn\00E9 aucun tableau d''objets \00E0 traiter comme une table.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276563103297866805)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le s\00E9lecteur de ligne "%0" n''a s\00E9lectionn\00E9 aucun objet \00E0 traiter comme une ligne unique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277530038749867428)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_language=>'fr'
,p_message_text=>unistr('Le param\00E8tre IN de source Web obligatoire "%0" de type "%1" doit avoir une valeur.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277512600839867416)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Le corps de r\00E9ponse est trop volumineux pour \00EAtre affich\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276927657834867036)
,p_name=>'APEX.WEBSRC.SHOW_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Afficher les colonnes s\00E9lectionn\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276983001333867072)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'fr'
,p_message_text=>unistr('Le service REST ORDS h\00E9rit\00E9 utilise une petite taille de page fixe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276928004238867037)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9lai d''expiration d\00E9pass\00E9 lors de l''extraction de toutes les donn\00E9es de source Web.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276902736305867020)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Les filtres SQL locaux en cours requi\00E8rent un trop grand nombre de demandes de page suivante au service REST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276982994378867072)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'fr'
,p_message_text=>unistr('La taille de page fixe pour le service REST ORDS h\00E9rit\00E9 est inconnue.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277634558795867495)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne de grille interactive ''%0'' indiqu\00E9e pour l''action dynamique ''#COMPONENT_NAME#'' n''existe pas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277634741978867495)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_language=>'fr'
,p_message_text=>unistr('Le processus ''%0'' a g\00E9n\00E9r\00E9 ''%1'' lors du verrouillage de ligne. Cette erreur peut survenir lorsque le processus \00E9met une instruction SELECT FOR UPDATE sur une vue complexe avec un d\00E9clencheur instead-of, pour verrouiller la ligne. D\00E9finissez l''attribu')
||'t de processus Verrouiller la ligne sur Non ou Code PL/SQL.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277634687799867495)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Le processus ''%0'' a g\00E9n\00E9r\00E9 ''%1'' lors de l''ex\00E9cution d''une commande DML. Cette erreur peut survenir si une colonne repose sur une agr\00E9gation ou sur une expression SQL. D\00E9finissez l''attribut de colonne Requ\00EAte uniquement sur Oui pour exclure la colonne')
||' des instructions INSERT et UPDATE.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277298706533867278)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne ma\00EEtre-d\00E9tail ''%0'' ne contient aucune valeur. Assurez-vous que le processus ''%1'' est ex\00E9cut\00E9 apr\00E8s le processus correspondant de la r\00E9gion ma\00EEtre.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277616326146867483)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune colonne ma\00EEtre n''est d\00E9finie pour la grille interactive ''%0'', ce qui est obligatoire pour la relation ma\00EEtre-d\00E9tail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276972482236867065)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune colonne de cl\00E9 primaire n''est d\00E9finie pour la grille interactive ''%0'', ce qui est obligatoire pour la modification ou dans une relation ma\00EEtre-d\00E9tail.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277588054527867465)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Pour une grille interactive modifiable, l''attribut de page Recharger apr\00E8s soumission doit \00EAtre d\00E9fini sur Seulement en cas de succ\00E8s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277588131569867465)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_language=>'fr'
,p_message_text=>unistr('Pour un panneau tabulaire, l''attribut de page Recharger apr\00E8s soumission doit \00EAtre d\00E9fini sur Toujours.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276530132962866782)
,p_name=>'APEXIR_3D'
,p_message_language=>'fr'
,p_message_text=>'3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277623461396867487)
,p_name=>'APEXIR_ACTIONS'
,p_message_language=>'fr'
,p_message_text=>'Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276750891259866924)
,p_name=>'APEXIR_ACTIONS_MENU'
,p_message_language=>'fr'
,p_message_text=>'Menu Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276655781468866863)
,p_name=>'APEXIR_ADD'
,p_message_language=>'fr'
,p_message_text=>'Ajouter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276740476868866917)
,p_name=>'APEXIR_ADD_FUNCTION'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une fonction'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276740343467866917)
,p_name=>'APEXIR_ADD_GROUP_BY_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une colonne de regroupement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277064868050867126)
,p_name=>'APEXIR_ADD_PIVOT_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une colonne pour la permutation lignes vers colonnes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277064912071867126)
,p_name=>'APEXIR_ADD_ROW_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une ligne /colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277228657812867232)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_language=>'fr'
,p_message_text=>'Ajouter l''abonnement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276530345920866782)
,p_name=>'APEXIR_AGGREGATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Agr\00E9ger')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276774818816866939)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Les agr\00E9gats s''affichent apr\00E8s chaque commande BREAK et \00E0 la fin de l''\00E9tat.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276777913478866941)
,p_name=>'APEXIR_AGGREGATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Agr\00E9gation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276656268581866863)
,p_name=>'APEXIR_AGG_AVG'
,p_message_language=>'fr'
,p_message_text=>'Moyenne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276665100764866869)
,p_name=>'APEXIR_AGG_COUNT'
,p_message_language=>'fr'
,p_message_text=>'Nombre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276682100729866880)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_language=>'fr'
,p_message_text=>'Nombre de valeurs distinctes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276656343699866863)
,p_name=>'APEXIR_AGG_MAX'
,p_message_language=>'fr'
,p_message_text=>'Maximum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276656531998866863)
,p_name=>'APEXIR_AGG_MEDIAN'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9diane')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276656436886866863)
,p_name=>'APEXIR_AGG_MIN'
,p_message_language=>'fr'
,p_message_text=>'Minimum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276656627832866864)
,p_name=>'APEXIR_AGG_MODE'
,p_message_language=>'fr'
,p_message_text=>'Mode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276656185926866863)
,p_name=>'APEXIR_AGG_SUM'
,p_message_language=>'fr'
,p_message_text=>'Total de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276657930240866864)
,p_name=>'APEXIR_ALL'
,p_message_language=>'fr'
,p_message_text=>'Tout'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276529315179866782)
,p_name=>'APEXIR_ALL_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Toutes les colonnes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276380145017866682)
,p_name=>'APEXIR_ALL_ROWS'
,p_message_language=>'fr'
,p_message_text=>'Toutes les lignes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277619942371867485)
,p_name=>'APEXIR_ALTERNATIVE'
,p_message_language=>'fr'
,p_message_text=>'Remplacement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277622046239867487)
,p_name=>'APEXIR_ALTERNATIVE_DEFAULT_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Autre valeur par d\00E9faut : %0 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276616014172866838)
,p_name=>'APEXIR_AND'
,p_message_language=>'fr'
,p_message_text=>'et'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276536871356866786)
,p_name=>'APEXIR_APPLY'
,p_message_language=>'fr'
,p_message_text=>'Appliquer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277585924554867463)
,p_name=>'APEXIR_AREA'
,p_message_language=>'fr'
,p_message_text=>'En aires'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276500738185866763)
,p_name=>'APEXIR_ASCENDING'
,p_message_language=>'fr'
,p_message_text=>'Croissant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276628535119866846)
,p_name=>'APEXIR_AS_OF'
,p_message_language=>'fr'
,p_message_text=>'Il y a %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277622698746867487)
,p_name=>'APEXIR_AVERAGE_X'
,p_message_language=>'fr'
,p_message_text=>'Moyenne de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277585867612867463)
,p_name=>'APEXIR_BAR'
,p_message_language=>'fr'
,p_message_text=>'Barre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276533266748866784)
,p_name=>'APEXIR_BETWEEN'
,p_message_language=>'fr'
,p_message_text=>'entre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276499448636866762)
,p_name=>'APEXIR_BGCOLOR'
,p_message_language=>'fr'
,p_message_text=>unistr('Couleur d''arri\00E8re-plan')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277225635933867230)
,p_name=>'APEXIR_BLACK'
,p_message_language=>'fr'
,p_message_text=>'Noir'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276501576531866763)
,p_name=>'APEXIR_BLUE'
,p_message_language=>'fr'
,p_message_text=>'bleu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276743253573866919)
,p_name=>'APEXIR_BOTTOM'
,p_message_language=>'fr'
,p_message_text=>'Tout en bas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276657564304866864)
,p_name=>'APEXIR_CALENDAR'
,p_message_language=>'fr'
,p_message_text=>'Calendrier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276502144447866764)
,p_name=>'APEXIR_CANCEL'
,p_message_language=>'fr'
,p_message_text=>'Annuler'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276542257452866791)
,p_name=>'APEXIR_CATEGORY'
,p_message_language=>'fr'
,p_message_text=>unistr('Cat\00E9gorie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276499300668866762)
,p_name=>'APEXIR_CELL'
,p_message_language=>'fr'
,p_message_text=>'Cellule'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276657446324866864)
,p_name=>'APEXIR_CHART'
,p_message_language=>'fr'
,p_message_text=>'Graphique'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276746413578866921)
,p_name=>'APEXIR_CHART_INITIALIZING'
,p_message_language=>'fr'
,p_message_text=>'Initialisation...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277100724635867150)
,p_name=>'APEXIR_CHART_LABEL_NOT_NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('Le libell\00E9 de graphique doit \00EAtre indiqu\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277213200019867222)
,p_name=>'APEXIR_CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Votre requ\00EAte d\00E9passe la valeur maximale de %0 points de donn\00E9es par graphique. Appliquez un filtre pour r\00E9duire le nombre d''enregistrements dans votre requ\00EAte de base.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277207232137867218)
,p_name=>'APEXIR_CHART_MAX_ROW_CNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nombre maximal de lignes pour la requ\00EAte Graphique limite le nombre de lignes dans la requ\00EAte de base, et non le nombre de lignes affich\00E9es. Votre requ\00EAte de base d\00E9passe le nombre de lignes maximal de %0. Appliquez un filtre pour r\00E9duire le nombr')
||unistr('e d''enregistrements dans votre requ\00EAte de base.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276529610726866782)
,p_name=>'APEXIR_CHART_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type de graphique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277183074586867203)
,p_name=>'APEXIR_CHECK_ALL'
,p_message_language=>'fr'
,p_message_text=>'Cocher tout'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276628951010866846)
,p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT'
,p_message_language=>'fr'
,p_message_text=>unistr('Choisir le format de t\00E9l\00E9chargement d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276731676399866911)
,p_name=>'APEXIR_CLEAR'
,p_message_language=>'fr'
,p_message_text=>'effacer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276502096803866764)
,p_name=>'APEXIR_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276774937485866939)
,p_name=>'APEXIR_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277602146323867474)
,p_name=>'APEXIR_COLUMN_FILTER'
,p_message_language=>'fr'
,p_message_text=>'Filtrer...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276741308416866918)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_language=>'fr'
,p_message_text=>unistr('En-t\00EAte de colonne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276735314053866914)
,p_name=>'APEXIR_COLUMN_HEADING_MENU'
,p_message_language=>'fr'
,p_message_text=>unistr('Menu d''en-t\00EAte de colonne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276746203458866921)
,p_name=>'APEXIR_COLUMN_INFO'
,p_message_language=>'fr'
,p_message_text=>'Informations de colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277612306983867480)
,p_name=>'APEXIR_COLUMN_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 de colonne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276741042964866917)
,p_name=>'APEXIR_COLUMN_N'
,p_message_language=>'fr'
,p_message_text=>'Colonne %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276610350731866834)
,p_name=>'APEXIR_COMPARISON_CONTAINS'
,p_message_language=>'fr'
,p_message_text=>'contient'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276615024834866837)
,p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN'
,p_message_language=>'fr'
,p_message_text=>'ne contient pas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276500453224866763)
,p_name=>'APEXIR_COMPARISON_IN'
,p_message_language=>'fr'
,p_message_text=>'dans'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276615221282866837)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST'
,p_message_language=>'fr'
,p_message_text=>'n''est pas dans les dern.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276660677656866866)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT'
,p_message_language=>'fr'
,p_message_text=>'ne figure pas sur la ligne suivante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276615148139866837)
,p_name=>'APEXIR_COMPARISON_IS_IN_LAST'
,p_message_language=>'fr'
,p_message_text=>'est dans les dern.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276660527242866866)
,p_name=>'APEXIR_COMPARISON_IS_IN_NEXT'
,p_message_language=>'fr'
,p_message_text=>'figure sur la ligne suivante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276500372497866763)
,p_name=>'APEXIR_COMPARISON_IS_NOT_NULL'
,p_message_language=>'fr'
,p_message_text=>'n''est pas NULL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276500248285866762)
,p_name=>'APEXIR_COMPARISON_IS_NULL'
,p_message_language=>'fr'
,p_message_text=>'est NULL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276500054761866762)
,p_name=>'APEXIR_COMPARISON_LIKE'
,p_message_language=>'fr'
,p_message_text=>'est comme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276500504075866763)
,p_name=>'APEXIR_COMPARISON_NOT_IN'
,p_message_language=>'fr'
,p_message_text=>'n''est pas dans'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276500164126866762)
,p_name=>'APEXIR_COMPARISON_NOT_LIKE'
,p_message_language=>'fr'
,p_message_text=>'n''est pas comme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276611086093866835)
,p_name=>'APEXIR_COMPARISON_REGEXP_LIKE'
,p_message_language=>'fr'
,p_message_text=>unistr('recherche une expression r\00E9guli\00E8re')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276628856468866846)
,p_name=>'APEXIR_COMPUTATION'
,p_message_language=>'fr'
,p_message_text=>'Calcul'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277206832048867218)
,p_name=>'APEXIR_COMPUTATION_EXPRESSION'
,p_message_language=>'fr'
,p_message_text=>'Expression de calcul'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276775245090866939)
,p_name=>'APEXIR_COMPUTATION_FOOTER'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un calcul en utilisant les alias de colonne.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276775368371866939)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E1'
,p_message_language=>'fr'
,p_message_text=>'(B+C)*100'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276775423906866939)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E2'
,p_message_language=>'fr'
,p_message_text=>'INITCAP(B)||'', ''||INITCAP(C)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276775519373866939)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E3'
,p_message_language=>'fr'
,p_message_text=>'CASE WHEN A = 10 THEN B + C ELSE B END'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276367494823866675)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E4'
,p_message_language=>'fr'
,p_message_text=>'ROUND(C / 1000000)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276658616651866865)
,p_name=>'APEXIR_COMPUTE'
,p_message_language=>'fr'
,p_message_text=>'Calculer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276742088267866918)
,p_name=>'APEXIR_CONTROL_BREAK'
,p_message_language=>'fr'
,p_message_text=>'Commande BREAK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276750234510866923)
,p_name=>'APEXIR_CONTROL_BREAKS'
,p_message_language=>'fr'
,p_message_text=>'Commandes BREAK'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277630795519867492)
,p_name=>'APEXIR_CONTROL_BREAK_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes de commande BREAK'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276359694471866670)
,p_name=>'APEXIR_COUNT_DISTINCT'
,p_message_language=>'fr'
,p_message_text=>'Nombre de valeurs distinctes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277623176083867487)
,p_name=>'APEXIR_COUNT_DISTINCT_X'
,p_message_language=>'fr'
,p_message_text=>'Nombre de valeurs distinctes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277623023782867487)
,p_name=>'APEXIR_COUNT_X'
,p_message_language=>'fr'
,p_message_text=>'Nombre de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277226153174867231)
,p_name=>'APEXIR_DAILY'
,p_message_language=>'fr'
,p_message_text=>'Quotidien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277715655922867547)
,p_name=>'APEXIR_DATA'
,p_message_language=>'fr'
,p_message_text=>unistr('Donn\00E9es')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276746377105866921)
,p_name=>'APEXIR_DATA_AS_OF'
,p_message_language=>'fr'
,p_message_text=>unistr('Donn\00E9es d''\00E9tat datant d''il y a %0 minutes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277577437943867458)
,p_name=>'APEXIR_DATA_GRID_HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Aide sur les grilles de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276530577406866782)
,p_name=>'APEXIR_DATE'
,p_message_language=>'fr'
,p_message_text=>'Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277621644773867486)
,p_name=>'APEXIR_DAY'
,p_message_language=>'fr'
,p_message_text=>'jour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276772595079866937)
,p_name=>'APEXIR_DEFAULT'
,p_message_language=>'fr'
,p_message_text=>unistr('Valeur par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277619782361867485)
,p_name=>'APEXIR_DEFAULT_REPORT_TYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Type d''\00E9tat par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276502233134866764)
,p_name=>'APEXIR_DELETE'
,p_message_language=>'fr'
,p_message_text=>'Supprimer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276659432529866865)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_language=>'fr'
,p_message_text=>unistr('Supprimer ce qui est coch\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276531452417866783)
,p_name=>'APEXIR_DELETE_CONFIRM'
,p_message_language=>'fr'
,p_message_text=>unistr('Voulez-vous supprimer ces param\00E8tres d''\00E9tat ?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276776722290866940)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_language=>'fr'
,p_message_text=>'Voulez-vous effectuer cette action de suppression ?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277510428499867415)
,p_name=>'APEXIR_DELETE_DEFAULT_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Supprimer l''\00E9tat par d\00E9faut')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276741770819866918)
,p_name=>'APEXIR_DELETE_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Supprimer l''\00E9tat')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276500860679866763)
,p_name=>'APEXIR_DESCENDING'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9croissant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276542303664866791)
,p_name=>'APEXIR_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>'Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276735234574866914)
,p_name=>'APEXIR_DETAIL_VIEW'
,p_message_language=>'fr'
,p_message_text=>'Vue monoligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276773596087866938)
,p_name=>'APEXIR_DIRECTION'
,p_message_language=>'fr'
,p_message_text=>'Direction %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276750728701866924)
,p_name=>'APEXIR_DISABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactiver')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276774744716866939)
,p_name=>'APEXIR_DISABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactiv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276530663765866782)
,p_name=>'APEXIR_DISPLAY'
,p_message_language=>'fr'
,p_message_text=>'Afficher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276501722465866763)
,p_name=>'APEXIR_DISPLAYED'
,p_message_language=>'fr'
,p_message_text=>unistr('Affich\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276529204547866781)
,p_name=>'APEXIR_DISPLAYED_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes affich\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276773415917866938)
,p_name=>'APEXIR_DISPLAY_IN_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Afficher dans l''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276502404867866764)
,p_name=>'APEXIR_DONUT'
,p_message_language=>'fr'
,p_message_text=>'Anneau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276743199328866919)
,p_name=>'APEXIR_DOWN'
,p_message_language=>'fr'
,p_message_text=>'Bas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276658770191866865)
,p_name=>'APEXIR_DOWNLOAD'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9charger en local')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276530424749866782)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_language=>'fr'
,p_message_text=>unistr('- Ne pas agr\00E9ger -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276773394340866938)
,p_name=>'APEXIR_DO_NOT_DISPLAY'
,p_message_language=>'fr'
,p_message_text=>'Ne pas afficher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277630962270867492)
,p_name=>'APEXIR_DUPLICATE_PIVOT_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de pivot en double. La liste de colonnes de pivot doit \00EAtre unique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277631306950867493)
,p_name=>'APEXIR_EDIT'
,p_message_language=>'fr'
,p_message_text=>'Modifier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277570024965867453)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier l''autre valeur par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276746551226866921)
,p_name=>'APEXIR_EDIT_CHART'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier les param\00E8tres du graphique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276776577324866940)
,p_name=>'APEXIR_EDIT_CHART2'
,p_message_language=>'fr'
,p_message_text=>'Modifier un graphique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276777089348866940)
,p_name=>'APEXIR_EDIT_FILTER'
,p_message_language=>'fr'
,p_message_text=>'Modifier le filtre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277272934326867261)
,p_name=>'APEXIR_EDIT_GROUP_BY'
,p_message_language=>'fr'
,p_message_text=>'Modifier le groupement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276776946689866940)
,p_name=>'APEXIR_EDIT_HIGHLIGHT'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier la mise en \00E9vidence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277089685078867142)
,p_name=>'APEXIR_EDIT_PIVOT'
,p_message_language=>'fr'
,p_message_text=>'Modifier le pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277620074026867485)
,p_name=>'APEXIR_EMAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Adresse \00E9lectronique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276445309048866726)
,p_name=>'APEXIR_EMAIL_ADDRESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Adresse \00E9lectronique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277620305255867485)
,p_name=>'APEXIR_EMAIL_BCC'
,p_message_language=>'fr'
,p_message_text=>'Cci'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277620548758867486)
,p_name=>'APEXIR_EMAIL_BODY'
,p_message_language=>'fr'
,p_message_text=>'Corps'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277620215365867485)
,p_name=>'APEXIR_EMAIL_CC'
,p_message_language=>'fr'
,p_message_text=>'Cc'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277621248193867486)
,p_name=>'APEXIR_EMAIL_FREQUENCY'
,p_message_language=>'fr'
,p_message_text=>unistr('Fr\00E9quence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276480143173866749)
,p_name=>'APEXIR_EMAIL_NOT_CONFIGURED'
,p_message_language=>'fr'
,p_message_text=>unistr('La messagerie \00E9lectronique n''a pas \00E9t\00E9 configur\00E9e pour cette application. Contactez l''administrateur.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277225213623867230)
,p_name=>'APEXIR_EMAIL_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''adresse \00E9lectronique doit \00EAtre indiqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277620653019867486)
,p_name=>'APEXIR_EMAIL_SEE_ATTACHED'
,p_message_language=>'fr'
,p_message_text=>unistr('Consulter la pi\00E8ce jointe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277620439977867486)
,p_name=>'APEXIR_EMAIL_SUBJECT'
,p_message_language=>'fr'
,p_message_text=>'Objet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277227170147867231)
,p_name=>'APEXIR_EMAIL_SUBJECT_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''objet du courriel doit \00EAtre indiqu\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277620191918867485)
,p_name=>'APEXIR_EMAIL_TO'
,p_message_language=>'fr'
,p_message_text=>'A'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276750670356866923)
,p_name=>'APEXIR_ENABLE'
,p_message_language=>'fr'
,p_message_text=>'Activer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276499148464866762)
,p_name=>'APEXIR_ENABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('Activ\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276776867929866940)
,p_name=>'APEXIR_ENABLE_DISABLE_ALT'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer/D\00E9sactiver')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276776229805866940)
,p_name=>'APEXIR_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276775669708866939)
,p_name=>'APEXIR_EXAMPLES'
,p_message_language=>'fr'
,p_message_text=>'Exemples'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276776653491866940)
,p_name=>'APEXIR_EXAMPLES_WITH_COLON'
,p_message_language=>'fr'
,p_message_text=>'Exemples :'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276529147317866781)
,p_name=>'APEXIR_EXCLUDE_NULL'
,p_message_language=>'fr'
,p_message_text=>'Exclure les valeurs NULL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276777553994866940)
,p_name=>'APEXIR_EXPAND_COLLAPSE_ALT'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9velopper/R\00E9duire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276774494819866938)
,p_name=>'APEXIR_EXPRESSION'
,p_message_language=>'fr'
,p_message_text=>'Expression'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276658284978866865)
,p_name=>'APEXIR_FILTER'
,p_message_language=>'fr'
,p_message_text=>'Filtrer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276750193071866923)
,p_name=>'APEXIR_FILTERS'
,p_message_language=>'fr'
,p_message_text=>'Filtres'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276834601510866977)
,p_name=>'APEXIR_FILTER_EXPRESSION'
,p_message_language=>'fr'
,p_message_text=>'Expression de filtre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277697551874867536)
,p_name=>'APEXIR_FILTER_EXPR_TOO_LONG'
,p_message_language=>'fr'
,p_message_text=>'L''expression de filtre est trop longue.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276834550355866977)
,p_name=>'APEXIR_FILTER_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type de filtre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276777705568866941)
,p_name=>'APEXIR_FINDER_ALT'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionner les colonnes \00E0 rechercher')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276658565721866865)
,p_name=>'APEXIR_FLASHBACK'
,p_message_language=>'fr'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276774182804866938)
,p_name=>'APEXIR_FLASHBACK_DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Une requ\00EAte Flashback permet de visualiser les donn\00E9es telles qu''elles existaient \00E0 un moment donn\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276776047410866940)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible d''ex\00E9cuter la demande de Flashback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277225829256867231)
,p_name=>'APEXIR_FLASHBACK_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Dur\00E9e de l''op\00E9ration Flashback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277234484885867236)
,p_name=>'APEXIR_FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Format'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276628749582866846)
,p_name=>'APEXIR_FORMAT_MASK'
,p_message_language=>'fr'
,p_message_text=>'Masque de format %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276741489574866918)
,p_name=>'APEXIR_FUNCTION'
,p_message_language=>'fr'
,p_message_text=>'Fonction'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276775117516866939)
,p_name=>'APEXIR_FUNCTIONS'
,p_message_language=>'fr'
,p_message_text=>'Fonctions %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277619689798867485)
,p_name=>'APEXIR_FUNCTIONS_OPERATORS'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctions/Op\00E9rateurs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277207313505867219)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne de fonction %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276740905136866917)
,p_name=>'APEXIR_FUNCTION_N'
,p_message_language=>'fr'
,p_message_text=>'Fonction %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276658010180866864)
,p_name=>'APEXIR_GO'
,p_message_language=>'fr'
,p_message_text=>'OK'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277225731543867231)
,p_name=>'APEXIR_GRAY'
,p_message_language=>'fr'
,p_message_text=>'Gris'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276499692811866762)
,p_name=>'APEXIR_GREEN'
,p_message_language=>'fr'
,p_message_text=>'vert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276359731840866670)
,p_name=>'APEXIR_GROUP_BY'
,p_message_language=>'fr'
,p_message_text=>'Grouper par'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277620756114867486)
,p_name=>'APEXIR_GROUP_BY_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Grouper par colonne %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277100848038867150)
,p_name=>'APEXIR_GROUP_BY_COL_NOT_NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne de regroupement doit \00EAtre indiqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277207122622867218)
,p_name=>'APEXIR_GROUP_BY_MAX_ROW_CNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nombre maximal de lignes pour la requ\00EAte Grouper par limite le nombre de lignes dans la requ\00EAte de base, et non le nombre le lignes affich\00E9es. Votre requ\00EAte de base d\00E9passe le nombre de lignes maximal de %0. Appliquez un filtre pour r\00E9duire le nom')
||unistr('bre d''enregistrements dans votre requ\00EAte de base.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277021296862867096)
,p_name=>'APEXIR_GROUP_BY_SORT'
,p_message_language=>'fr'
,p_message_text=>'Grouper par tri'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277630870987867492)
,p_name=>'APEXIR_GROUP_BY_SORT_ORDER'
,p_message_language=>'fr'
,p_message_text=>'Grouper par ordre de tri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276529781824866782)
,p_name=>'APEXIR_HCOLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne horizontale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276767966451866934)
,p_name=>'APEXIR_HELP'
,p_message_language=>'fr'
,p_message_text=>'Aide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276733549410866913)
,p_name=>'APEXIR_HELP_01'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Les \00E9tats interactifs permettent aux utilisateurs finals de personnaliser les \00E9tats. Les utilisateurs peuvent modifier la mise en page des donn\00E9es d''\00E9tat en choisissant des colonnes, en appliquant des filtres, en mettant des valeurs en \00E9vidence et en')
||unistr(' les triant. Ils peuvent \00E9galement d\00E9finir des sections, des agr\00E9gations, des graphiques, ainsi que des regroupements et ajouter des calculs personnalis\00E9s. Ils peuvent aussi d\00E9finir un abonnement pour l''envoi par courriel d''une version HTML de l''\00E9tat')
||unistr(' \00E0 un intervalle d\00E9fini. Il est possible de cr\00E9er plusieurs versions d''un \00E9tat et de les enregistrer sous forme d''\00E9tats nomm\00E9s, pour une utilisation publique ou priv\00E9e. '),
'<p/>',
unistr('Les sections qui suivent r\00E9capitulent les m\00E9thodes de personnalisation d''un \00E9tat interactif. Pour en savoir plus, reportez-vous \00E0 "Using Interactive Reports" dans le manuel <i>Oracle Application Express End User''s Guide</i></a>.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276750996934866924)
,p_name=>'APEXIR_HELP_ACTIONS_MENU'
,p_message_language=>'fr'
,p_message_text=>unistr('Le menu Actions se trouve \00E0 droite du bouton Ex\00E9cuter dans la barre de recherche. Utilisez ce menu pour personnaliser un \00E9tat interactif.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276734597685866913)
,p_name=>'APEXIR_HELP_AGGREGATE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Les agr\00E9gats sont des calculs math\00E9matiques r\00E9alis\00E9s sur une colonne. Ils sont affich\00E9s apr\00E8s chaque commande BREAK et \00E0 la fin de l''\00E9tat dans la colonne o\00F9 ils sont d\00E9finis. Les options disponibles sont les suivantes :'),
'<p>',
'</p><ul>',
unistr('<ul><li><b>Agr\00E9gation</b> permet de s\00E9lectionner un agr\00E9gat'),
unistr('pr\00E9d\00E9fini \00E0 modifier.</li>'),
unistr('<li><b>Fonction</b> est la fonction \00E0 ex\00E9cuter (exemple : SUM, MIN).</li>'),
unistr('<li><b>Colonne</b> permet de s\00E9lectionner la colonne \00E0 laquelle appliquer la fonction math\00E9matique. Seules les colonnes num\00E9riques'),
unistr('seront affich\00E9es.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276734690554866913)
,p_name=>'APEXIR_HELP_CHART'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Vous pouvez d\00E9finir un graphique par \00E9tat interactif. Une fois'),
unistr('que vous l''avez d\00E9fini, vous pouvez basculer de la vue du graphique \00E0 celle de l''\00E9tat \00E0 l''aide des ic\00F4nes de vue situ\00E9s sous la barre de recherche.'),
'Les options disponibles sont les suivantes :  ',
'<p>',
'</p><ul>',
unistr('<li><b>Type de graphique</b> indique le type de graphique \00E0 inclure.'),
unistr('S\00E9lectionnez A barres horizontales, A barres verticales, A secteurs ou A courbes.</li>'),
unistr('<li><b>Libell\00E9</b> permet de s\00E9lectionner la colonne \00E0 utiliser comme libell\00E9.</li>'),
unistr('<li><b>Titre de l''axe pour le libell\00E9</b> indique le titre qui appara\00EEtra sur l''axe associ\00E9 \00E0 la colonne d\00E9finie'),
unistr('comme libell\00E9. Cette option n''est pas disponible pour les graphiques \00E0 secteurs.</li>'),
unistr('<li><b>Valeur</b> permet de s\00E9lectionner la colonne \00E0 utiliser comme valeur. Si votre fonction'),
unistr('est de type COUNT, il est inutile de s\00E9lectionner une valeur.</li>'),
unistr('<li><b>Titre de l''axe pour la valeur</b> indique le titre qui appara\00EEtra sur l''axe associ\00E9 \00E0 la colonne d\00E9finie'),
unistr('comme valeur. Cette option n''est pas disponible pour les graphiques \00E0 secteurs.</li>'),
unistr('<li><b>Fonction</b> est une fonction facultative \00E0 ex\00E9cuter sur la colonne s\00E9lectionn\00E9e comme valeur.</li>'),
unistr('<li><b>Trier</b> permet de trier l''ensemble de r\00E9sultats.</li></ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276733942885866913)
,p_name=>'APEXIR_HELP_COLUMN_HEADING_MENU'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Si vous cliquez sur un en-t\00EAte de colonne, cela affiche un menu d''en-t\00EAte de colonne. Les options disponibles sont les suivantes :'),
'<p></p>',
'<ul>',
unistr('<li><b>Ic\00F4ne de tri par ordre croissant</b> : permet de trier les \00E9tats par ordre croissant.</li>'),
unistr('<li><b>Ic\00F4ne de tri par ordre d\00E9croissant</b> : permet de trier les \00E9tats par ordre d\00E9croissant.</li>'),
unistr('<li><b>Masquer la colonne</b> : permet de masquer une colonne. Les colonnes ne peuvent pas toutes \00EAtre masqu\00E9es. Si une colonne ne peut pas l''\00EAtre, cette ic\00F4ne n''est pas disponible.</li>'),
unistr('<li><b>Colonne de section (BREAK)</b> : permet de cr\00E9er un groupe de section sur la colonne, ce qui extrait la colonne de l''\00E9tat comme enregistrement ma\00EEtre.</li>'),
'<li><b>Informations de colonne</b> : permet d''afficher l''aide de la colonne, si elle existe.</li>',
unistr('<li><b>Zone de texte</b> : permet de saisir des crit\00E8res de recherche,'),
unistr('sans distinction entre les majuscules et les minuscules (caract\00E8res g\00E9n\00E9riques inutiles). Si vous saisissez une valeur, cela r\00E9duira '),
unistr('la liste de valeurs au bas du menu. Vous pourrez ensuite s\00E9lectionner une valeur du '),
unistr('bas du menu et cette valeur sera cr\00E9\00E9e en tant que filtre gr\00E2ce \00E0 l''op\00E9rateur ''='''),
unistr('(par exemple, <code>colonne = ''ABC''</code>). Vous pouvez \00E9galement cliquer sur l''ic\00F4ne repr\00E9sentant une torche pour que la valeur saisie soit cr\00E9\00E9e en tant que filtre avec le modificateur ''LIKE'''),
'(par exemple, <code>colonne LIKE ''%ABC%''</code>).</li>',
unistr('<li>La <b>liste de valeurs uniques</b> contient les 500 premi\00E8res valeurs uniques'),
unistr('correspondant \00E0 vos filtres. Si la colonne est une date, une liste de'),
unistr(' plages de dates s''affiche \00E0 la place. Si vous s\00E9lectionnez une valeur, un filtre sera cr\00E9\00E9 avec'),
unistr('l''op\00E9rateur ''='' (par exemple, <code>colonne = ''ABC''</code>).</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276734412482866913)
,p_name=>'APEXIR_HELP_COMPUTE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Permet d''ajouter des colonnes calcul\00E9es \00E0 votre \00E9tat. Il peut s''agir de calculs math\00E9matiques (comme <code>NBR_HOURS/24</code>) ou de fonctions Oracle'),
unistr('standard appliqu\00E9es \00E0 des colonnes existantes (certaines sont affich\00E9es comme exemple tandis que d''autres, telles que <code>TO_DATE</code>, peuvent \00E9galement \00EAtre utilis\00E9es).'),
'Les options disponibles sont les suivantes :',
'<p></p>',
'<ul>',
unistr('<li><b>Calcul</b> permet de s\00E9lectionner un calcul pr\00E9d\00E9fini \00E0 modifier.</li>'),
unistr('<li><b>En-t\00EAte de colonne</b> d\00E9signe l''en-t\00EAte de la nouvelle colonne.</li>'),
unistr('<li><b>Masque de format</b> d\00E9signe un masque de format Oracle \00E0 appliquer \00E0 la colonne (par exemple, S9999).</li>'),
unistr('<li><b>Calcul</b> d\00E9signe le calcul \00E0 ex\00E9cuter. Dans le calcul, les colonnes sont r\00E9f\00E9renc\00E9es \00E0 l''aide des alias affich\00E9s.</li>'),
'</ul>',
unistr('<p>Sous le calcul, les colonnes de votre requ\00EAte sont affich\00E9es avec'),
unistr('leur alias associ\00E9. Si vous cliquez sur un nom de colonne ou un alias,'),
'celui-ci sera inscrit dans le calcul. En regard des colonnes, un clavier fournit simplement',
unistr('des raccourcis pour les touches fr\00E9quemment utilis\00E9es. A droite se trouvent les fonctions.</p>'),
unistr('<p>Voici un exemple de calcul permettant d''afficher la r\00E9mun\00E9ration totale :</p>'),
'<pre>CASE WHEN A = ''SALES'' THEN B + C ELSE B END</pre>',
unistr('(o\00F9 A est ORGANIZATION, B est SALARY et C, COMMISSION)</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276751059038866924)
,p_name=>'APEXIR_HELP_CONTROL_BREAK'
,p_message_language=>'fr'
,p_message_text=>unistr('Utilis\00E9 pour cr\00E9er un groupe de section sur une ou plusieurs colonnes, ce qui extrait les colonnes de l''\00E9tat interactif et les affiche comme enregistrements ma\00EEtre.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276735153699866914)
,p_name=>'APEXIR_HELP_DETAIL_VIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Pour afficher les d\00E9tails d''une seule ligne \00E0 la fois, cliquez sur l''ic\00F4ne de vue monoligne sur la ligne que vous souhaitez visualiser. Si l''option est disponible, la vue monoligne sera toujours la premi\00E8re colonne. En fonction de la personnalisation')
||unistr(' de l''\00E9tat interactif, la vue monoligne peut \00EAtre la vue standard ou une page personnalis\00E9e pouvant \00EAtre mise \00E0 jour.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276735078518866914)
,p_name=>'APEXIR_HELP_DOWNLOAD'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Permet le t\00E9l\00E9chargement de l''ensemble de r\00E9sultats en cours. Les formats de t\00E9l\00E9chargement'),
unistr('seront diff\00E9rents en fonction de votre installation et de la d\00E9finition d''\00E9tat,'),
'et pourront inclure CSV, HTML, courriel, XLS, PDF ou RTF.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276734111966866913)
,p_name=>'APEXIR_HELP_FILTER'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Active l''\00E9tat en ajoutant ou modifiant la clause <code>WHERE</code> de la requ\00EAte. Vous pouvez filtrer par colonne ou par ligne.  '),
unistr('<p>Si vous filtrez par colonne, vous devez s\00E9lectionner une colonne (pas n\00E9cessairement'),
unistr('une de celles affich\00E9es), choisir un op\00E9rateur Oracle standard (=, !=, n''est pas dans, entre), puis saisir une expression \00E0 comparer. Les expressions font la distinction entre les majuscules et les minuscules. Vous pouvez utiliser le caract\00E8re g\00E9n\00E9ri')
||'que % (par exemple, <code>STATE_NAME',
'like A%)</code>.</p>',
unistr('<p>Si vous filtrez par ligne, vous pouvez cr\00E9er des clauses <code>WHERE</code> complexes \00E0 l''aide'),
unistr('d''alias de colonne et de toute fonction ou tout op\00E9rateur Oracle (par exemple, <code>G = ''VA'' ou G = ''CT''</code>, o\00F9'),
'<code>G</code> est l''alias de <code>CUSTOMER_STATE</code>).</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276734768993866913)
,p_name=>'APEXIR_HELP_FLASHBACK'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Une requ\00EAte Flashback vous permet de visualiser les donn\00E9es telles qu''elles existaient'),
unistr('\00E0 un moment donn\00E9. Par d\00E9faut, l''op\00E9ration Flashback permet de remonter \00E0 3 heures (ou 180 minutes)'),
unistr('mais la dur\00E9e r\00E9elle sera diff\00E9rente en fonction de la base de donn\00E9es.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277234377119867236)
,p_name=>'APEXIR_HELP_FORMAT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>L''\00E9l\00E9ment Format permet de personnaliser l''affichage d''un \00E9tat.'),
'Il comprend les sous-menus suivants :</p>',
'<ul><li>Trier</li>',
'<li>Commande BREAK</li>',
unistr('<li>Mise en \00E9vidence</li>'),
'<li>Calculer</li>',
unistr('<li>Agr\00E9gat</li>'),
'<li>Graphique</li>',
'<li>Grouper par</li>',
'<li>Pivot</li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277225022914867230)
,p_name=>'APEXIR_HELP_GROUP_BY'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Vous pouvez d\00E9finir une vue Grouper par pour chaque \00E9tat'),
unistr('enregistr\00E9. Une fois d\00E9fini, vous pouvez basculer entre la vue Grouper par et la vue'),
unistr('d''\00E9tat \00E0 l''aide des ic\00F4nes de vue situ\00E9es en dessous de la barre de recherche. Pour cr\00E9er une vue Grouper par,'),
unistr('vous s\00E9lectionnez :'),
'<p></p><ul>',
'<li>les colonnes sur la base desquelles former le groupe</li>',
unistr('<li>les colonnes \00E0 agr\00E9ger, ainsi que la fonction \00E0 ex\00E9cuter (moyenne, somme, nombre, etc.)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276734379306866913)
,p_name=>'APEXIR_HELP_HIGHLIGHT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permet de d\00E9finir un filtre. Les lignes correspondant aux crit\00E8res du filtre sont mises en \00E9vidence \00E0 l''aide des caract\00E9ristiques associ\00E9es au filtre. Les options disponibles sont les suivantes :</p>'),
'<ul>',
unistr('<li><b>Nom</b> est utilis\00E9 uniquement pour l''affichage.</li>'),
unistr('<li><b>S\00E9quence</b> identifie la s\00E9quence utilis\00E9e pour l''\00E9valuation des r\00E8gles.</li>'),
unistr('<li><b>Activ\00E9</b> indique si la r\00E8gle est activ\00E9e ou non.</li>'),
unistr('<li><b>Mettre le type en \00E9vidence</b> indique si la ligne ou la cellule doit \00EAtre'),
unistr('mise en \00E9vidence. Si vous s\00E9lectionnez la cellule, la colonne r\00E9f\00E9renc\00E9e sous'),
unistr('Conditions de mise en \00E9vidence sera mise en \00E9vidence.</li>'),
unistr('<li><b>Couleur d''arri\00E8re-plan</b> indique la nouvelle couleur d''arri\00E8re-plan pour les zones mises en \00E9vidence.</li>'),
unistr('<li><b>Couleur du texte</b> indique la nouvelle couleur de texte pour les zones mises en \00E9vidence.</li>'),
unistr('<li><b>Conditions de mise en \00E9vidence</b> d\00E9finit vos conditions de filtrage.</li>'),
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276331059245866652)
,p_name=>'APEXIR_HELP_PIVOT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Vous pouvez d\00E9finir une vue de permutation lignes vers colonnes pour chaque \00E9tat enregistr\00E9. Cela permet ensuite de basculer entre la vue de permutation lignes vers colonnes et la vue d''\00E9tat \00E0 l''aide des ic\00F4nes d''affichage de la barre de recherche. P')
||unistr('our cr\00E9er une vue de permutation lignes vers colonnes, vous devez s\00E9lectionner : '),
'<p></p>',
'<ul>',
'<li>les colonnes sur lesquelles effectuer la permutation lignes vers colonnes ;</li>',
unistr('<li>les colonnes \00E0 afficher en tant que lignes ; </li>'),
unistr('<li>les colonnes \00E0 agr\00E9ger, ainsi que la fonction \00E0 ex\00E9cuter (moyenne, somme, d\00E9compte, etc.).</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276775806845866939)
,p_name=>'APEXIR_HELP_REPORT_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Si vous personnalisez un \00E9tat interactif, les param\00E8tres d''\00E9tat seront affich\00E9s'),
unistr('en dessous de la barre de recherche et au-dessus de l''\00E9tat. Cette zone peut \00EAtre r\00E9duite et d\00E9velopp\00E9e \00E0 l''aide de l''ic\00F4ne de gauche.'),
'<p>',
unistr('Pour chaque param\00E8tre d''\00E9tat, vous pouvez effectuer les op\00E9rations suivantes :'),
'</p><ul>',
unistr('<li>Modifier un param\00E8tre en cliquant sur le nom.</li>'),
unistr('<li>D\00E9sactiver/Activer un param\00E8tre en cochant ou en d\00E9s\00E9lectionnant la case Activer/D\00E9sactiver. Ceci permet d''activer et de d\00E9sactiver temporairement le param\00E8tre.</li>'),
unistr('<li>Enlever un param\00E8tre en cliquant sur l''ic\00F4ne Enlever.</li>'),
'</ul>',
unistr('<p>Si vous avez cr\00E9\00E9 un graphique, un regroupement ou un pivot, vous pouvez basculer entre eux'),
unistr('et l''\00E9tat de base via les liens de vue d''\00E9tat, Vue de graphique, Vue Grouper par et Vue de pivot'),
'sur la droite. Si vous visualisez le graphique, le regroupement ou le pivot, vous',
unistr('pouvez \00E9galement utiliser le lien Modifier pour modifier les param\00E8tres.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276734928662866914)
,p_name=>'APEXIR_HELP_RESET'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9initialise l''\00E9tat pour retrouver les param\00E8tres par d\00E9faut, ce qui enl\00E8ve toute personnalisation effectu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277234635572867236)
,p_name=>'APEXIR_HELP_ROWS_PER_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finit le nombre d''enregistrements \00E0 afficher par page.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276734841100866913)
,p_name=>'APEXIR_HELP_SAVE_REPORT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Enregistre l''\00E9tat personnalis\00E9 en vue d''une utilisation ult\00E9rieure. Vous devez indiquer un nom, pouvez entrer une description et rendre l''\00E9tat accessible au public (\00E0 savoir, \00E0 tous les utilisateurs pouvant acc\00E9der \00E0 l''\00E9tat par d\00E9faut principal). ')
||unistr('Vous pouvez enregistrer quatre types d''\00E9tat interactif :</p>'),
'<ul>',
unistr('<li><strong>Val. par d\00E9faut du principal</strong> (d\00E9veloppeur uniquement) : l''\00E9tat par d\00E9faut principal est celui qui est affich\00E9 initialement. Les \00E9tats de ce type ne peuvent \00EAtre ni renomm\00E9s, ni supprim\00E9s.</li>'),
unistr('<li><strong>Etat de remplacement</strong> (d\00E9veloppeur uniquement) : permet aux d\00E9veloppeurs de cr\00E9er diff\00E9rentes mises en page d''\00E9tat. Seuls les d\00E9veloppeurs sont autoris\00E9s \00E0 enregistrer, renommer et supprimer ce type d''\00E9tat.</li>'),
unistr('<li><strong>Etat public</strong> (utilisateur final) : ce type d''\00E9tat peut \00EAtre enregistr\00E9, renomm\00E9 et supprim\00E9 par l''utilisateur final l''ayant cr\00E9\00E9. Les autres utilisateurs peuvent visualiser et enregistrer la mise en page, comme pour les autres \00E9ta')
||'ts.</li>',
unistr('<li><strong>Etat priv\00E9</strong> (utilisateur final) : seul l''utilisateur final ayant cr\00E9\00E9 l''\00E9tat est autoris\00E9 \00E0 le visualiser, l''enregistrer, le renommer et le supprimer.</li>'),
'</ul>',
unistr('<p>Lorsque vous enregistrez des \00E9tats personnalis\00E9s, un s\00E9lecteur d''\00E9tats appara\00EEt dans la barre de recherche \00E0 gauche du s\00E9lecteur de lignes (\00E0 condition que cette fonctionnalit\00E9 soit activ\00E9e).</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276733869123866913)
,p_name=>'APEXIR_HELP_SEARCH_BAR'
,p_message_language=>'fr'
,p_message_text=>unistr('Une r\00E9gion de recherche se trouve dans la partie sup\00E9rieure de chaque page d''\00E9tat. Cette r\00E9gion (ou barre de recherche) fournit les fonctionnalit\00E9s suivantes :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277235200371867237)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ACTIONS_MENU'
,p_message_language=>'fr'
,p_message_text=>unistr('<li>Le <b>menu Actions</b> permet de personnaliser un \00E9tat. Reportez-vous aux sections qui suivent.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277234743511867236)
,p_name=>'APEXIR_HELP_SEARCH_BAR_FINDER'
,p_message_language=>'fr'
,p_message_text=>unistr('<li>L''<b>ic\00F4ne S\00E9lectionner des colonnes</b> permet d''indiquer les colonnes sur lesquelles doit porter la recherche (ou toutes les colonnes).</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277235006269867237)
,p_name=>'APEXIR_HELP_SEARCH_BAR_REPORTS'
,p_message_language=>'fr'
,p_message_text=>unistr('<li>L''option <b>Etats</b> permet d''afficher les autres \00E9tats par d\00E9faut, et les \00E9tats enregistr\00E9s priv\00E9s ou publics.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277234965223867237)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ROWS'
,p_message_language=>'fr'
,p_message_text=>unistr('<li>Le champ <b>Lignes</b> permet de d\00E9finir le nombre d''enregistrements \00E0 afficher par page.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277234817801867236)
,p_name=>'APEXIR_HELP_SEARCH_BAR_TEXTBOX'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li>La <b>zone de texte</b> permet d''entrer des crit\00E8res de recherche sans distinction entre les majuscules et les minuscules (les caract\00E8res g\00E9n\00E9riques sont implicites).</li>'),
unistr('<li>Le <b>bouton OK</b> permet de lancer la recherche. Si vous appuyez sur la touche Entr\00E9e, la recherche sera \00E9galement ex\00E9cut\00E9e lorsque le curseur se trouve dans la zone de recherche de texte.</li>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277235116311867237)
,p_name=>'APEXIR_HELP_SEARCH_BAR_VIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('<li>L''option <b>Ic\00F4nes Vue</b> permet de basculer entre les vues d''ic\00F4ne, d''\00E9tat, de d\00E9tail, de graphique, de regroupement et de pivot de l''\00E9tat si elles sont d\00E9finies.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277577553774867458)
,p_name=>'APEXIR_HELP_SEARCH_BAR_WS_MANAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('<li>L''\00E9l\00E9ment <b>G\00E9rer</b> permet de g\00E9rer les propri\00E9t\00E9s, les colonnes et les lignes, et de visualiser l''historique de l''\00E9tat ou de la grille de donn\00E9es.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276734046765866913)
,p_name=>'APEXIR_HELP_SELECT_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Utilis\00E9 pour modifier les colonnes affich\00E9es. Les colonnes situ\00E9es sur la droite sont affich\00E9es, tandis que celles situ\00E9es sur la gauche sont masqu\00E9es. Vous pouvez re-trier les colonnes affich\00E9es \00E0 l''aide de la fl\00E8che situ\00E9e \00E0 droite. Les colonnes ca')
||unistr('lcul\00E9es sont pr\00E9c\00E9d\00E9es par <b>**</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276734250097866913)
,p_name=>'APEXIR_HELP_SORT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilis\00E9 pour modifier les colonnes \00E0 utiliser pour trier et d\00E9terminer si'),
unistr('le tri doit \00EAtre croissant ou d\00E9croissant. Vous pouvez \00E9galement indiquer comment g\00E9rer'),
unistr('les valeurs <code>NULL</code>. Le param\00E8tre par d\00E9faut affiche toujours les valeurs <code>NULL</code> en premier ou en dernier. Le tri r\00E9sultant est affich\00E9 \00E0 droite'),
unistr('des en-t\00EAtes de colonnes dans l''\00E9tat.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277224698186867230)
,p_name=>'APEXIR_HELP_SUBSCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Lorsque vous ajoutez un abonnement, vous fournissez une adresse \00E9lectronique (ou plusieurs adresses \00E9lectroniques s\00E9par\00E9es par des virgules), un objet de courriel, une fr\00E9quence, et des dates de d\00E9but et de fin. Les courriels obtenus seront une versi')
||unistr('on HTML de l''\00E9tat interactif contenant les donn\00E9es en cours utilisant les param\00E8tres d''\00E9tat pr\00E9sents lors de l''ajout de l''abonnement.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277577057627867458)
,p_name=>'APEXIR_HELP_WS_01'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Les grilles de donn\00E9es sont essentiellement des \00E9tats modifiables dont la plupart des \00E9l\00E9ments peuvent \00EAtre personnalis\00E9s. Les utilisateurs peuvent ainsi modifier la mise en page des donn\00E9es de l''\00E9tat en choisissant des colonnes, en appliquant des fi')
||unistr('ltres, en mettant les valeurs en \00E9vidence et en les triant. Ils peuvent \00E9galement d\00E9finir des sections, des agr\00E9gations, des graphiques ainsi que des regroupements et ajouter des calculs personnalis\00E9s. Il est possible de cr\00E9er diff\00E9rentes versions d''')
||unistr('un \00E9tat et les enregistrer en tant qu''\00E9tats nomm\00E9s, pour une utilisation priv\00E9e. '),
'<p/>',
unistr('Vous pouvez personnaliser une grille de donn\00E9es via la barre de recherche, le menu Actions et le menu d''en-t\00EAte de colonne.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277629414158867491)
,p_name=>'APEXIR_HELP_WS_ACTIONS_MENU'
,p_message_language=>'fr'
,p_message_text=>unistr('Le menu Actions se trouve \00E0 droite du bouton Ex\00E9cuter dans la barre de recherche. Utilisez ce menu pour personnaliser un \00E9tat de grille de donn\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277577878601867458)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT'
,p_message_language=>'fr'
,p_message_text=>'Page Ajouter/Modifier une ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277577951021867458)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT_ROW'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Pour ajouter une ligne \00E0 la grille de donn\00E9es, cliquez sur Ajouter une ligne. Pour modifier les d\00E9tails d''une ligne, cliquez sur l''ic\00F4ne Modifier une ligne (dans la premi\00E8re colonne) de la ligne \00E0 modifier. La page Ajouter/Modifier une ligne est a')
||unistr('ffich\00E9e avec les colonnes de la grille de donn\00E9es. </p>'),
'',
unistr('<p>Lors de la modification d''une ligne, vous pouvez effectuer les op\00E9rations suivantes :</p>'),
'',
'<p><ul>',
'<li><b>Supprimer</b> la ligne.</li>',
unistr('<li><b>Appliquer les modifications</b> pour enregistrer les modifications apport\00E9es \00E0 la ligne.</li>'),
unistr('<li>Dans l''\00E9l\00E9ment <b>Actions</b>, ajouter une ligne, des fichiers, des remarques, des liens ou des balises et v\00E9rifier l''historique.</li>'),
unistr('<li>Acc\00E9der aux lignes <b>pr\00E9c\00E9dente et suivante</b>.</li>'),
unistr('<li>Dans l''\00E9l\00E9ment <b>G\00E9rer</b>, d\00E9finir les propri\00E9t\00E9s des colonnes, les groupes de colonnes, les validations et les listes de valeurs.</li>'),
'</ul></p>',
'',
unistr('<p>La r\00E9gion Annotations situ\00E9e au bas de la page affiche les fichiers, remarques, liens ou balises associ\00E9s \00E0 la ligne en cours.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277629590257867491)
,p_name=>'APEXIR_HELP_WS_CONTROL_BREAK'
,p_message_language=>'fr'
,p_message_text=>unistr('Utilis\00E9 pour cr\00E9er un groupe de section pour une ou plusieurs colonnes, ce qui extrait les colonnes de la grille de donn\00E9es et les affiche comme enregistrements ma\00EEtre.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277577786270867458)
,p_name=>'APEXIR_HELP_WS_DOWNLOAD'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Permet le t\00E9l\00E9chargement de l''ensemble de r\00E9sultats en cours. Les formats de t\00E9l\00E9chargement'),
'sont les suivants : CSV, HTML ou courriel.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277629616331867491)
,p_name=>'APEXIR_HELP_WS_REPORT_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Si vous personnalisez un \00E9tat de grille de donn\00E9es, les param\00E8tres d''\00E9tat seront affich\00E9s'),
unistr('au-dessous de la barre de recherche et au-dessus de l''\00E9tat. Cette zone peut \00EAtre r\00E9duite et d\00E9velopp\00E9e \00E0 l''aide de l''ic\00F4ne de gauche.'),
'<p>',
unistr('Pour chaque param\00E8tre d''\00E9tat, vous pouvez effectuer les op\00E9rations suivantes :'),
'</p><ul>',
unistr('<li>Modifier un param\00E8tre en cliquant sur son nom.</li>'),
unistr('<li>D\00E9sactiver/activer un param\00E8tre en cochant ou en d\00E9s\00E9lectionnant la case Activer/D\00E9sactiver. Ceci permet d''activer et de d\00E9sactiver temporairement le param\00E8tre.</li>'),
unistr('<li>Enlever un param\00E8tre en cliquant sur l''ic\00F4ne Enlever.</li></ul>'),
'</ul>',
unistr('<p>Si vous avez cr\00E9\00E9 un graphique ou un regroupement, vous pouvez basculer entre eux'),
unistr('et l''\00E9tat de base via les liens de vue d''\00E9tat, de graphique et de regroupement'),
'sur la droite. Si vous visualisez le graphique ou le regroupement, vous',
unistr('pouvez \00E9galement utiliser le lien Modifier pour modifier leurs param\00E8tres.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277577613629867458)
,p_name=>'APEXIR_HELP_WS_SAVE_REPORT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Enregistre la mise en page personnalis\00E9e de l''\00E9tat de grille de donn\00E9es en vue d''une utilisation ult\00E9rieure. Vous devez indiquer un nom et pouvez entrer une description. Vous pouvez enregistrer trois types de mise en page d''\00E9tat de grille de donn\00E9')
||'es :</p>',
'<ul>',
unistr('<li><strong>Val. par d\00E9faut du principal</strong> (administrateur uniquement) : la mise en page par d\00E9faut principale est celle qui est affich\00E9e initialement. Les \00E9tats de ce type ne peuvent \00EAtre ni renomm\00E9s, ni supprim\00E9s.</li>'),
unistr('<li><strong>Etat de remplacement</strong> (administrateur uniquement) : permet aux administrateurs de cr\00E9er diff\00E9rentes mises en page d''\00E9tat. Seuls les administrateurs sont autoris\00E9s \00E0 enregistrer, renommer et supprimer ce type d''\00E9tat.</li>'),
unistr('<li><strong>Etat priv\00E9</strong> (tous les utilisateurs) : seul l''utilisateur ayant cr\00E9\00E9 la mise en page d''\00E9tat est autoris\00E9 \00E0 visualiser, enregistrer, renommer et supprimer l''\00E9tat.</li>'),
'</ul>',
unistr('<p>Lorsque vous enregistrez des \00E9tats personnalis\00E9s, un s\00E9lecteur d''\00E9tats appara\00EEt dans la barre de recherche \00E0 gauche du s\00E9lecteur de lignes (\00E0 condition que cette fonctionnalit\00E9 soit activ\00E9e).</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276746186021866921)
,p_name=>'APEXIR_HIDE_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Masquer la colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276658410812866865)
,p_name=>'APEXIR_HIGHLIGHT'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre en \00E9vidence')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276750398757866923)
,p_name=>'APEXIR_HIGHLIGHTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Mises en \00E9vidence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276775961216866939)
,p_name=>'APEXIR_HIGHLIGHT_CONDITION'
,p_message_language=>'fr'
,p_message_text=>unistr('Conditions de mises en \00E9vidence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277225578942867230)
,p_name=>'APEXIR_HIGHLIGHT_STYLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Style de mise en \00E9vidence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276499271625866762)
,p_name=>'APEXIR_HIGHLIGHT_TYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre le type en \00E9vidence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276499924413866762)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre en \00E9vidence lorsque')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277586149089867464)
,p_name=>'APEXIR_HORIZONTAL'
,p_message_language=>'fr'
,p_message_text=>'Horizontal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277689689411867531)
,p_name=>'APEXIR_INACTIVE_SETTING'
,p_message_language=>'fr'
,p_message_text=>unistr('1 param\00E8tre inactif')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277689792291867531)
,p_name=>'APEXIR_INACTIVE_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 param\00E8tres inactifs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276735584455866914)
,p_name=>'APEXIR_INTERACTIVE_REPORT_HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Aide de l''\00E9tat interactif')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276777274027866940)
,p_name=>'APEXIR_INVALID'
,p_message_language=>'fr'
,p_message_text=>'Non valide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276748888683866922)
,p_name=>'APEXIR_INVALID_COMPUTATION'
,p_message_language=>'fr'
,p_message_text=>'Expression de calcul non valide. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276446351306866726)
,p_name=>'APEXIR_INVALID_END_DATE'
,p_message_language=>'fr'
,p_message_text=>unistr('La date de fin doit \00EAtre post\00E9rieure \00E0 la date de d\00E9but.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276895655552867016)
,p_name=>'APEXIR_INVALID_FILTER'
,p_message_language=>'fr'
,p_message_text=>'Expression de filtre non valide. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277622269901867487)
,p_name=>'APEXIR_INVALID_FILTER_QUERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAte de filtrage non valide')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277689820699867531)
,p_name=>'APEXIR_INVALID_SETTING'
,p_message_language=>'fr'
,p_message_text=>unistr('1 param\00E8tre non valide')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277689968352867531)
,p_name=>'APEXIR_INVALID_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 param\00E8tres non valides')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277225943841867231)
,p_name=>'APEXIR_IN_MINUTES'
,p_message_language=>'fr'
,p_message_text=>'(en minutes)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277569012082867453)
,p_name=>'APEXIR_IS_IN_THE_LAST'
,p_message_language=>'fr'
,p_message_text=>'%0 est dans les derniers %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277569395918867453)
,p_name=>'APEXIR_IS_IN_THE_NEXT'
,p_message_language=>'fr'
,p_message_text=>'%0 est dans les %1 suivants'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277569206751867453)
,p_name=>'APEXIR_IS_NOT_IN_THE_LAST'
,p_message_language=>'fr'
,p_message_text=>'%0 n''est pas dans les derniers %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277569444667867453)
,p_name=>'APEXIR_IS_NOT_IN_THE_NEXT'
,p_message_language=>'fr'
,p_message_text=>'%0 n''est pas dans les %1 suivants'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276775050234866939)
,p_name=>'APEXIR_KEYPAD'
,p_message_language=>'fr'
,p_message_text=>'Clavier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276530251923866782)
,p_name=>'APEXIR_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276743718445866919)
,p_name=>'APEXIR_LABEL_AXIS_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Titre de l''axe pour le libell\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277091099024867143)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9fixe de libell\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276662655553866867)
,p_name=>'APEXIR_LAST_DAY'
,p_message_language=>'fr'
,p_message_text=>'Dernier jour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276662827354866867)
,p_name=>'APEXIR_LAST_HOUR'
,p_message_language=>'fr'
,p_message_text=>unistr('Derni\00E8re heure')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276662311869866867)
,p_name=>'APEXIR_LAST_MONTH'
,p_message_language=>'fr'
,p_message_text=>'Le mois dernier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276662458889866867)
,p_name=>'APEXIR_LAST_WEEK'
,p_message_language=>'fr'
,p_message_text=>unistr('La semaine derni\00E8re')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276662505369866867)
,p_name=>'APEXIR_LAST_X_DAYS'
,p_message_language=>'fr'
,p_message_text=>'Les %0 derniers jours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276662731518866867)
,p_name=>'APEXIR_LAST_X_HOURS'
,p_message_language=>'fr'
,p_message_text=>unistr('Les %0 derni\00E8res heures')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276662160320866867)
,p_name=>'APEXIR_LAST_X_YEARS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 derni\00E8res ann\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276662213349866867)
,p_name=>'APEXIR_LAST_YEAR'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ann\00E9e derni\00E8re')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276530008229866782)
,p_name=>'APEXIR_LINE'
,p_message_language=>'fr'
,p_message_text=>'Ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276502390638866764)
,p_name=>'APEXIR_LINE_WITH_AREA'
,p_message_language=>'fr'
,p_message_text=>'A courbes avec aires'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277209243456867220)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Cliquez <a href=''%0''>ici</a> pour g\00E9rer votre abonnement.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277622112368867487)
,p_name=>'APEXIR_MAP_IT'
,p_message_language=>'fr'
,p_message_text=>'Mise en correspondance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276746719130866921)
,p_name=>'APEXIR_MAX_QUERY_COST'
,p_message_language=>'fr'
,p_message_text=>unistr('Selon les estimations, la requ\00EAte d\00E9passe les ressources maximales autoris\00E9es. Modifiez les param\00E8tres de votre \00E9tat et r\00E9essayez.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276614933207866837)
,p_name=>'APEXIR_MAX_ROW_CNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nombre maximal de lignes pour cet \00E9tat est de %0 lignes. Appliquez un filtre pour r\00E9duire le nombre d''enregistrements dans votre requ\00EAte.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277622705950867487)
,p_name=>'APEXIR_MAX_X'
,p_message_language=>'fr'
,p_message_text=>'Maximum de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277622904657867487)
,p_name=>'APEXIR_MEDIAN_X'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9diane de %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276628609397866846)
,p_name=>'APEXIR_MIN_AGO'
,p_message_language=>'fr'
,p_message_text=>'%0 minutes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277622800583867487)
,p_name=>'APEXIR_MIN_X'
,p_message_language=>'fr'
,p_message_text=>'Minimum de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277621740181867486)
,p_name=>'APEXIR_MONTH'
,p_message_language=>'fr'
,p_message_text=>'Mois'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277226317210867231)
,p_name=>'APEXIR_MONTHLY'
,p_message_language=>'fr'
,p_message_text=>'Mensuel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276777464245866940)
,p_name=>'APEXIR_MORE_DATA'
,p_message_language=>'fr'
,p_message_text=>unistr('Donn\00E9es suppl\00E9mentaires')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276742689841866918)
,p_name=>'APEXIR_MOVE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9placer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276742574005866918)
,p_name=>'APEXIR_MOVE_ALL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9placer tout')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277708010072867542)
,p_name=>'APEXIR_MULTIIR_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ID statique de r\00E9gion doit \00EAtre indiqu\00E9, car la page contient plusieurs \00E9tats interactifs.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276501090529866763)
,p_name=>'APEXIR_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276731913979866912)
,p_name=>'APEXIR_NEW_AGGREGATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Nouvelle agr\00E9gation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276524286387866778)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_language=>'fr'
,p_message_text=>unistr('- Nouvelle cat\00E9gorie -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277691393514867532)
,p_name=>'APEXIR_NEW_CATEGORY_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Nouvelle cat\00E9gorie')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276732079964866912)
,p_name=>'APEXIR_NEW_COMPUTATION'
,p_message_language=>'fr'
,p_message_text=>'Nouveau calcul'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276656779699866864)
,p_name=>'APEXIR_NEXT'
,p_message_language=>'fr'
,p_message_text=>'Suivant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276663221404866868)
,p_name=>'APEXIR_NEXT_DAY'
,p_message_language=>'fr'
,p_message_text=>'Jour suivant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276663093159866868)
,p_name=>'APEXIR_NEXT_HOUR'
,p_message_language=>'fr'
,p_message_text=>'Heure suivante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276663569791866868)
,p_name=>'APEXIR_NEXT_MONTH'
,p_message_language=>'fr'
,p_message_text=>'Mois suivant'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276663412793866868)
,p_name=>'APEXIR_NEXT_WEEK'
,p_message_language=>'fr'
,p_message_text=>'Semaine suivante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276663395722866868)
,p_name=>'APEXIR_NEXT_X_DAYS'
,p_message_language=>'fr'
,p_message_text=>'%0 prochains jours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276663161254866868)
,p_name=>'APEXIR_NEXT_X_HOURS'
,p_message_language=>'fr'
,p_message_text=>'%0 prochaines heures'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276663715521866868)
,p_name=>'APEXIR_NEXT_X_YEARS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 prochaines ann\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276663622864866868)
,p_name=>'APEXIR_NEXT_YEAR'
,p_message_language=>'fr'
,p_message_text=>unistr('Ann\00E9e suivante')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276501317394866763)
,p_name=>'APEXIR_NO'
,p_message_language=>'fr'
,p_message_text=>'Non'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276777638624866941)
,p_name=>'APEXIR_NONE'
,p_message_language=>'fr'
,p_message_text=>'- Aucun -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277225392964867230)
,p_name=>'APEXIR_NOT_VALID_EMAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Adresse \00E9lectronique non valide.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276659567845866865)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune agr\00E9gation d\00E9finie.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276613772718866836)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_language=>'fr'
,p_message_text=>'Aucune information de colonne disponible.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276659647662866865)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun calcul d\00E9fini.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277621501248867486)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_language=>'fr'
,p_message_text=>'- Aucune date de fin -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276772741059866937)
,p_name=>'APEXIR_NULLS_ALWAYS_FIRST'
,p_message_language=>'fr'
,p_message_text=>'Valeurs NULL toujours en premier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276772689969866937)
,p_name=>'APEXIR_NULLS_ALWAYS_LAST'
,p_message_language=>'fr'
,p_message_text=>'Valeurs NULL toujours en dernier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276773639015866938)
,p_name=>'APEXIR_NULL_SORTING'
,p_message_language=>'fr'
,p_message_text=>'Tri des valeurs NULL %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276748937493866922)
,p_name=>'APEXIR_NUMERIC_FLASHBACK_TIME'
,p_message_language=>'fr'
,p_message_text=>unistr('L''heure de l''op\00E9ration Flashback doit \00EAtre une valeur num\00E9rique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276748431377866922)
,p_name=>'APEXIR_NUMERIC_SEQUENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('La s\00E9quence doit \00EAtre num\00E9rique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276774373398866938)
,p_name=>'APEXIR_OPERATOR'
,p_message_language=>'fr'
,p_message_text=>unistr('Op\00E9rateur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276499781245866762)
,p_name=>'APEXIR_ORANGE'
,p_message_language=>'fr'
,p_message_text=>'orange'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277586078349867463)
,p_name=>'APEXIR_ORIENTATION'
,p_message_language=>'fr'
,p_message_text=>'Orientation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276501884645866763)
,p_name=>'APEXIR_OTHER'
,p_message_language=>'fr'
,p_message_text=>'Autre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277623275172867487)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_COUNT_X'
,p_message_language=>'fr'
,p_message_text=>'Pourcentage du nombre total de %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277622428505867487)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_SUM_X'
,p_message_language=>'fr'
,p_message_text=>'Pourcentage de la somme totale de %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277620952012867486)
,p_name=>'APEXIR_PERCENT_TOTAL_COUNT'
,p_message_language=>'fr'
,p_message_text=>'Pourcentage du nombre total'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277620861025867486)
,p_name=>'APEXIR_PERCENT_TOTAL_SUM'
,p_message_language=>'fr'
,p_message_text=>'Pourcentage de la somme totale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276529918414866782)
,p_name=>'APEXIR_PIE'
,p_message_language=>'fr'
,p_message_text=>'A secteurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277064741390867126)
,p_name=>'APEXIR_PIVOT'
,p_message_language=>'fr'
,p_message_text=>'Permutation lignes vers colonnes'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277092361600867144)
,p_name=>'APEXIR_PIVOT_AGG_NOT_NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('L''agr\00E9gation doit \00EAtre indiqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277092651618867144)
,p_name=>'APEXIR_PIVOT_AGG_NOT_ON_ROW_COL'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous ne pouvez pas effectuer l''agr\00E9gation sur une colonne s\00E9lectionn\00E9e en tant que colonne de ligne.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277090124193867143)
,p_name=>'APEXIR_PIVOT_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes de pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277089916735867143)
,p_name=>'APEXIR_PIVOT_COLUMN_N'
,p_message_language=>'fr'
,p_message_text=>'Colonne de pivot %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277092112920867144)
,p_name=>'APEXIR_PIVOT_COLUMN_NOT_NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne de pivot doit \00EAtre indiqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276330989565866652)
,p_name=>'APEXIR_PIVOT_MAX_ROW_CNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nombre maximal de lignes pour la requ\00EAte Permutation ligne vers colonnes limite le nombre de lignes dans la requ\00EAte de base, et non le nombre de lignes affich\00E9es. La requ\00EAte de base d\00E9passe le nombre de lignes maximal de %0. Appliquez un filtre po')
||unistr('ur r\00E9duire le nombre d''enregistrements dans la requ\00EAte de base.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277703907602867540)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionnez une colonne de ligne diff\00E9rente. L''expression ou le lien HTML dans la colonne de ligne contient une colonne d\00E9finie en tant que colonne de pivot ou d''agr\00E9gat.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277091181827867143)
,p_name=>'APEXIR_PIVOT_SORT'
,p_message_language=>'fr'
,p_message_text=>'Tri de pivot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277225467106867230)
,p_name=>'APEXIR_PREVIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Aper\00E7u')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276656846097866864)
,p_name=>'APEXIR_PREVIOUS'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9c\00E9dent')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277619871372867485)
,p_name=>'APEXIR_PRIMARY'
,p_message_language=>'fr'
,p_message_text=>'Principal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277229179945867233)
,p_name=>'APEXIR_PRIMARY_REPORT'
,p_message_language=>'fr'
,p_message_text=>'Etat principal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276889640701867012)
,p_name=>'APEXIR_PRIVATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Priv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276531375265866783)
,p_name=>'APEXIR_PUBLIC'
,p_message_language=>'fr'
,p_message_text=>'Public'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276501691770866763)
,p_name=>'APEXIR_RED'
,p_message_language=>'fr'
,p_message_text=>'rouge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277707946590867542)
,p_name=>'APEXIR_REGION_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ID statique de r\00E9gion %0 n''existe pas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276742713905866918)
,p_name=>'APEXIR_REMOVE'
,p_message_language=>'fr'
,p_message_text=>'Enlever'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276655871269866863)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Enlever un agr\00E9gat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276742806651866919)
,p_name=>'APEXIR_REMOVE_ALL'
,p_message_language=>'fr'
,p_message_text=>'Enlever tout'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277690046481867531)
,p_name=>'APEXIR_REMOVE_CHART'
,p_message_language=>'fr'
,p_message_text=>'Enlever le graphique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276742123542866918)
,p_name=>'APEXIR_REMOVE_CONTROL_BREAK'
,p_message_language=>'fr'
,p_message_text=>'Enlever la commande BREAK'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276741869358866918)
,p_name=>'APEXIR_REMOVE_FILTER'
,p_message_language=>'fr'
,p_message_text=>'Enlever le filtre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276741913331866918)
,p_name=>'APEXIR_REMOVE_FLASHBACK'
,p_message_language=>'fr'
,p_message_text=>unistr('Enlever l''op\00E9ration Flashback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277690155568867531)
,p_name=>'APEXIR_REMOVE_GROUP_BY'
,p_message_language=>'fr'
,p_message_text=>'Enlever le regroupement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276742298297866918)
,p_name=>'APEXIR_REMOVE_HIGHLIGHT'
,p_message_language=>'fr'
,p_message_text=>unistr('Enlever la mise en \00E9vidence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277690280825867531)
,p_name=>'APEXIR_REMOVE_PIVOT'
,p_message_language=>'fr'
,p_message_text=>'Enlever le pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277631417065867493)
,p_name=>'APEXIR_REMOVE_REPORT'
,p_message_language=>'fr'
,p_message_text=>'Enlever le rapport'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277510324129867415)
,p_name=>'APEXIR_RENAME_DEFAULT_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Renommer l''\00E9tat par d\00E9faut')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276778079240866941)
,p_name=>'APEXIR_RENAME_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Renommer un \00E9tat')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276657305453866864)
,p_name=>'APEXIR_REPORT'
,p_message_language=>'fr'
,p_message_text=>'Etat'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277623372954867487)
,p_name=>'APEXIR_REPORTS'
,p_message_language=>'fr'
,p_message_text=>'Etats'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276490899660866756)
,p_name=>'APEXIR_REPORT_ALIAS_DOES_NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9tat interactif enregistr\00E9 portant l''alias %0 n''existe pas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277040270104867110)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nombre maximal de colonnes d''affichage de l''\00E9tat a \00E9t\00E9 atteint. Cliquez sur S\00E9lectionner des colonnes dans le menu Actions pour r\00E9duire la liste de colonnes d''affichage de l''\00E9tat.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276892976552867014)
,p_name=>'APEXIR_REPORT_DOES_NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9tat n''existe pas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276490982127866756)
,p_name=>'APEXIR_REPORT_ID_DOES_NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ID d''\00E9tat interactif enregistr\00E9, %0, n''existe pas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276775765193866939)
,p_name=>'APEXIR_REPORT_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276629169166866846)
,p_name=>'APEXIR_REPORT_VIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Vue d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276658922822866865)
,p_name=>'APEXIR_RESET'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9initialiser')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276531582607866783)
,p_name=>'APEXIR_RESET_CONFIRM'
,p_message_language=>'fr'
,p_message_text=>unistr('Restaurer les param\00E8tres par d\00E9faut de l''\00E9tat.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276501497691866763)
,p_name=>'APEXIR_ROW'
,p_message_language=>'fr'
,p_message_text=>'Ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277615682739867482)
,p_name=>'APEXIR_ROWID_NOT_SUPPORTED_FOR_WEBSOURCE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous ne pouvez pas utiliser ROWID en tant que colonne de cl\00E9 primaire pour une source Web.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276740802724866917)
,p_name=>'APEXIR_ROWS'
,p_message_language=>'fr'
,p_message_text=>'Lignes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277234597388867236)
,p_name=>'APEXIR_ROWS_PER_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Lignes par page'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277090207313867143)
,p_name=>'APEXIR_ROW_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes de ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277090068532867143)
,p_name=>'APEXIR_ROW_COLUMN_N'
,p_message_language=>'fr'
,p_message_text=>'Colonne de ligne %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277092232164867144)
,p_name=>'APEXIR_ROW_COLUMN_NOT_NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne de ligne doit \00EAtre indiqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277092419964867144)
,p_name=>'APEXIR_ROW_COL_DIFF_FROM_PIVOT_COL'
,p_message_language=>'fr'
,p_message_text=>unistr('La colonne de ligne doit \00EAtre diff\00E9rente de la colonne de pivot.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276837526195866979)
,p_name=>'APEXIR_ROW_FILTER'
,p_message_language=>'fr'
,p_message_text=>'Filtre de ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276629206102866846)
,p_name=>'APEXIR_ROW_OF'
,p_message_language=>'fr'
,p_message_text=>'Ligne %0 sur %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276628454340866846)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_language=>'fr'
,p_message_text=>'Tri des lignes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276660453940866866)
,p_name=>'APEXIR_ROW_TEXT_CONTAINS'
,p_message_language=>'fr'
,p_message_text=>'Le texte de ligne contient'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276350815973866665)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nombre maximal de colonnes d''affichage de l''\00E9tat a \00E9t\00E9 atteint. Cliquez sur S\00E9lectionner des colonnes dans le menu Actions pour r\00E9duire la liste de colonnes d''affichage de l''\00E9tat.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276500604166866763)
,p_name=>'APEXIR_SAVE'
,p_message_language=>'fr'
,p_message_text=>'Enregistrer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276750536562866923)
,p_name=>'APEXIR_SAVED_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat enregistr\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276750408916866923)
,p_name=>'APEXIR_SAVED_REPORT_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat enregistr\00E9 = "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276659391544866865)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrer en tant que valeur par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276771967593866937)
,p_name=>'APEXIR_SAVE_DEFAULT_CONFIRM'
,p_message_language=>'fr'
,p_message_text=>unistr('Les param\00E8tres en cours de l''\00E9tat seront utilis\00E9s comme param\00E8tres par d\00E9faut pour tous les utilisateurs.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277510277597867415)
,p_name=>'APEXIR_SAVE_DEFAULT_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrer l''\00E9tat par d\00E9faut')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276658819389866865)
,p_name=>'APEXIR_SAVE_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrer un \00E9tat')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277691298029867532)
,p_name=>'APEXIR_SAVE_REPORT_DEFAULT'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrer un \00E9tat *')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277246151935867244)
,p_name=>'APEXIR_SEARCH'
,p_message_language=>'fr'
,p_message_text=>'Rechercher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276735460588866914)
,p_name=>'APEXIR_SEARCH_BAR'
,p_message_language=>'fr'
,p_message_text=>'Barre de recherche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277691152168867531)
,p_name=>'APEXIR_SEARCH_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Rechercher : %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277295477573867276)
,p_name=>'APEXIR_SEARCH_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Rechercher un \00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277207074081867218)
,p_name=>'APEXIR_SELECTED_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes s\00E9lectionn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276500969797866763)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner une cat\00E9gorie -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276502521998866764)
,p_name=>'APEXIR_SELECT_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner une colonne -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276658194737866864)
,p_name=>'APEXIR_SELECT_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionner des colonnes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276777849929866941)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_language=>'fr'
,p_message_text=>unistr('Les colonnes calcul\00E9es sont pr\00E9c\00E9d\00E9es par **.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276530706031866782)
,p_name=>'APEXIR_SELECT_FUNCTION'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner une fonction -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276740231180866917)
,p_name=>'APEXIR_SELECT_GROUP_BY_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner une colonne de regroupement -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277089772314867142)
,p_name=>'APEXIR_SELECT_PIVOT_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner la colonne de pivot -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277622381635867487)
,p_name=>'APEXIR_SELECT_ROW'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionner une ligne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277089866244867142)
,p_name=>'APEXIR_SELECT_ROW_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner la colonne de ligne -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277621106859867486)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner une colonne de tri -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276777357383866940)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionner une valeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276340605665866658)
,p_name=>'APEXIR_SEND'
,p_message_language=>'fr'
,p_message_text=>'Envoyer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276501154633866763)
,p_name=>'APEXIR_SEQUENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9quence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276658362341866865)
,p_name=>'APEXIR_SORT'
,p_message_language=>'fr'
,p_message_text=>'Trier'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276745932432866920)
,p_name=>'APEXIR_SORT_ASCENDING'
,p_message_language=>'fr'
,p_message_text=>'Trier par ordre croissant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277621034998867486)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne de tri %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276746036601866921)
,p_name=>'APEXIR_SORT_DESCENDING'
,p_message_language=>'fr'
,p_message_text=>unistr('Trier par ordre d\00E9croissant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277630621592867492)
,p_name=>'APEXIR_SORT_ORDER'
,p_message_language=>'fr'
,p_message_text=>'Ordre de tri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276731561083866911)
,p_name=>'APEXIR_SPACE_AS_IN_ONE_EMPTY_STRING'
,p_message_language=>'fr'
,p_message_text=>'espace'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276774610616866939)
,p_name=>'APEXIR_STATUS'
,p_message_language=>'fr'
,p_message_text=>'Statut %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277226031024867231)
,p_name=>'APEXIR_SUBSCRIPTION'
,p_message_language=>'fr'
,p_message_text=>'Abonnement'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277621499707867486)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING'
,p_message_language=>'fr'
,p_message_text=>'Fin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277206903588867218)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_language=>'fr'
,p_message_text=>unistr('Unit\00E9 de fin')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277621340202867486)
,p_name=>'APEXIR_SUBSCRIPTION_STARTING_FROM'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9but')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277622514057867487)
,p_name=>'APEXIR_SUM_X'
,p_message_language=>'fr'
,p_message_text=>'Total de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277571851429867454)
,p_name=>'APEXIR_TABLE_SUMMARY'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gion = %0, \00E9tat = %1, vue = %2, d\00E9but des lignes affich\00E9es = %3, fin des lignes affich\00E9es = %4, nombre total de lignes = %5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276681974724866880)
,p_name=>'APEXIR_TABLE_SUMMARY_NO_TOTAL'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gion = %0, \00E9tat = %1, vue = %2, d\00E9but des lignes affich\00E9es = %3, fin des lignes affich\00E9es = %4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276499881892866762)
,p_name=>'APEXIR_TEXT_COLOR'
,p_message_language=>'fr'
,p_message_text=>'Couleur du texte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276615587919866837)
,p_name=>'APEXIR_TIME_DAYS'
,p_message_language=>'fr'
,p_message_text=>'jours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276615405534866837)
,p_name=>'APEXIR_TIME_HOURS'
,p_message_language=>'fr'
,p_message_text=>'heures'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276615381551866837)
,p_name=>'APEXIR_TIME_MINS'
,p_message_language=>'fr'
,p_message_text=>'minutes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276615726433866837)
,p_name=>'APEXIR_TIME_MONTHS'
,p_message_language=>'fr'
,p_message_text=>'mois'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276615643417866837)
,p_name=>'APEXIR_TIME_WEEKS'
,p_message_language=>'fr'
,p_message_text=>'semaines'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276615835506866837)
,p_name=>'APEXIR_TIME_YEARS'
,p_message_language=>'fr'
,p_message_text=>unistr('ann\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277631220553867492)
,p_name=>'APEXIR_TOGGLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer/d\00E9sactiver')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276742976941866919)
,p_name=>'APEXIR_TOP'
,p_message_language=>'fr'
,p_message_text=>'Tout en haut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276776180122866940)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_language=>'fr'
,p_message_text=>unistr('Non autoris\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277605078719867476)
,p_name=>'APEXIR_UNGROUPED_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne sans groupe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276748695473866922)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_language=>'fr'
,p_message_text=>unistr('L''en-t\00EAte de colonne doit \00EAtre unique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276748308768866922)
,p_name=>'APEXIR_UNIQUE_HIGHLIGHT_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nom de mise en \00E9vidence doit \00EAtre unique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276529064163866781)
,p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('type de donn\00E9es non pris en charge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276743057072866919)
,p_name=>'APEXIR_UP'
,p_message_language=>'fr'
,p_message_text=>'Haut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276748551541866922)
,p_name=>'APEXIR_VALID_COLOR'
,p_message_language=>'fr'
,p_message_text=>'Entrez une couleur valide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276748748854866922)
,p_name=>'APEXIR_VALID_FORMAT_MASK'
,p_message_language=>'fr'
,p_message_text=>'Entrez un masque de format valide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276501914160866764)
,p_name=>'APEXIR_VALUE'
,p_message_language=>'fr'
,p_message_text=>'Valeur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276743849126866919)
,p_name=>'APEXIR_VALUE_AXIS_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Titre de l''axe pour la valeur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276777196626866940)
,p_name=>'APEXIR_VALUE_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>'Valeur obligatoire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276529875383866782)
,p_name=>'APEXIR_VCOLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne verticale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277586206730867464)
,p_name=>'APEXIR_VERTICAL'
,p_message_language=>'fr'
,p_message_text=>'Vertical'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276776387793866940)
,p_name=>'APEXIR_VIEW_CHART'
,p_message_language=>'fr'
,p_message_text=>'Visualiser le graphique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277275286001867263)
,p_name=>'APEXIR_VIEW_DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Visualiser les d\00E9tails')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277694332801867534)
,p_name=>'APEXIR_VIEW_DOES_NOT_EXIST'
,p_message_language=>'fr'
,p_message_text=>unistr('La vue %0 n''est pas d\00E9finie pour l''\00E9tat.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277275316489867263)
,p_name=>'APEXIR_VIEW_GROUP_BY'
,p_message_language=>'fr'
,p_message_text=>'Visualiser le groupement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277275120270867263)
,p_name=>'APEXIR_VIEW_ICONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ic\00F4nes Vue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277089503794867142)
,p_name=>'APEXIR_VIEW_PIVOT'
,p_message_language=>'fr'
,p_message_text=>'Afficher le pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276776470641866940)
,p_name=>'APEXIR_VIEW_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Voir l''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277621903828867487)
,p_name=>'APEXIR_WEEK'
,p_message_language=>'fr'
,p_message_text=>'semaine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277226221553867231)
,p_name=>'APEXIR_WEEKLY'
,p_message_language=>'fr'
,p_message_text=>'Hebdomadaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276657207272866864)
,p_name=>'APEXIR_WORKING_REPORT'
,p_message_language=>'fr'
,p_message_text=>'Etat de travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277624149746867488)
,p_name=>'APEXIR_X_DAYS'
,p_message_language=>'fr'
,p_message_text=>'%0 jours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277624000212867488)
,p_name=>'APEXIR_X_HOURS'
,p_message_language=>'fr'
,p_message_text=>'%0 heures'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277623972557867488)
,p_name=>'APEXIR_X_MINS'
,p_message_language=>'fr'
,p_message_text=>'%0 minutes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277624362801867488)
,p_name=>'APEXIR_X_MONTHS'
,p_message_language=>'fr'
,p_message_text=>'%0 mois'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277624210485867488)
,p_name=>'APEXIR_X_WEEKS'
,p_message_language=>'fr'
,p_message_text=>'%0 semaines'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277624489857867488)
,p_name=>'APEXIR_X_YEARS'
,p_message_language=>'fr'
,p_message_text=>'%0 ans'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277621860356867486)
,p_name=>'APEXIR_YEAR'
,p_message_language=>'fr'
,p_message_text=>unistr('Ann\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276499576221866762)
,p_name=>'APEXIR_YELLOW'
,p_message_language=>'fr'
,p_message_text=>'jaune'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276501232834866763)
,p_name=>'APEXIR_YES'
,p_message_language=>'fr'
,p_message_text=>'Oui'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276347987499866663)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_language=>'fr'
,p_message_text=>'Services d''administration Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277570458752867454)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune authentification n''est configur\00E9e pour cette application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276743669456866919)
,p_name=>'APEX_GROUP.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 contient < ou >, qui ne sont pas des caract\00E8res valides.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276960868734867058)
,p_name=>'APEX_REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276817501344866966)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_language=>'fr'
,p_message_text=>unistr('Les objets de base de donn\00E9es suivants seront %0 dans le sch\00E9ma s\00E9lectionn\00E9 :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276817687545866966)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Les objets de base de donn\00E9es suivants ont \00E9t\00E9 %0 :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277305500797867283)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_language=>'fr'
,p_message_text=>unistr('Faire d\00E9filer vers le bas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277305615510867283)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_language=>'fr'
,p_message_text=>unistr('Faire d\00E9filer jusqu''en haut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276353571743866666)
,p_name=>'APEX_WIZARD_FORM'
,p_message_language=>'fr'
,p_message_text=>'Panneau de navigation'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277569977824867453)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_language=>'fr'
,p_message_text=>'Modifier une ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276988475958867075)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_language=>'fr'
,p_message_text=>'Objets non valides'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277628365379867491)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_language=>'fr'
,p_message_text=>'Il n''existe aucune page homologue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277573250733867455)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_language=>'fr'
,p_message_text=>unistr('Objets \00E0 cr\00E9er')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277573477236867455)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_language=>'fr'
,p_message_text=>'Supprimer des tables'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277573638191867456)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_language=>'fr'
,p_message_text=>'Supprimer les objets'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277236332071867237)
,p_name=>'APEX_WS_SETUP_DROP_TABLES'
,p_message_language=>'fr'
,p_message_text=>'Supprimer des tables'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277235632055867237)
,p_name=>'APEX_WS_SETUP_MSG1'
,p_message_language=>'fr'
,p_message_text=>unistr('Ces objets seront cr\00E9\00E9s dans le sch\00E9ma <b>%0</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277573728700867456)
,p_name=>'APEX_WS_SETUP_MSG10'
,p_message_language=>'fr'
,p_message_text=>unistr('Ces objets existent d\00E9j\00E0 dans le sch\00E9ma <b>%0</b> et sont utilis\00E9es par d''autres espaces de travail. Si vous continuez, les objets de feuille Web existants appartenant \00E0 <b>%0</b> seront associ\00E9s \00E0 cet espace de travail \00E9galement.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277573894793867456)
,p_name=>'APEX_WS_SETUP_MSG11'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionnez le sch\00E9ma \00E0 utiliser pour ces objets :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277573952381867456)
,p_name=>'APEX_WS_SETUP_MSG12'
,p_message_language=>'fr'
,p_message_text=>unistr('Tables existantes \00E0 utiliser')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277574852226867456)
,p_name=>'APEX_WS_SETUP_MSG13'
,p_message_language=>'fr'
,p_message_text=>unistr('Les objets de base de donn\00E9es de feuille Web seront r\00E9utilis\00E9s \00E0 l''aide des informations suivantes. Confirmez votre demande.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277235792813867237)
,p_name=>'APEX_WS_SETUP_MSG2'
,p_message_language=>'fr'
,p_message_text=>unistr('Si vous souhaitez cr\00E9er ces objets de feuille Web dans un nouveau sch\00E9ma, utilisez l''assistant <a href=%0>Demander un sch\00E9ma de base de donn\00E9es</a>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277235811869867237)
,p_name=>'APEX_WS_SETUP_MSG3'
,p_message_language=>'fr'
,p_message_text=>unistr('Pour ex\00E9cuter les feuilles Web, les objets suivants sont obligatoires :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277235938598867237)
,p_name=>'APEX_WS_SETUP_MSG5'
,p_message_language=>'fr'
,p_message_text=>unistr('Les objets de base de donn\00E9es de feuille Web seront cr\00E9\00E9s \00E0 l''aide des informations suivantes. Confirmez votre demande.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277236089718867237)
,p_name=>'APEX_WS_SETUP_MSG6'
,p_message_language=>'fr'
,p_message_text=>unistr('Tables \00E0 cr\00E9er')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277236146934867237)
,p_name=>'APEX_WS_SETUP_MSG7'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous \00EAtes sur le point d''enlever des objets de base de donn\00E9es de feuille Web. Ceci entra\00EEnera la suppression de ces objets et des donn\00E9es internes contenant les composants de feuille Web de votre espace de travail. Voulez-vous continuer ?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277236497422867237)
,p_name=>'APEX_WS_SETUP_MSG8'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous devez corriger les objets non valides suivants pour pouvoir ex\00E9cuter les feuilles Web correctement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277573355623867455)
,p_name=>'APEX_WS_SETUP_MSG9'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous \00EAtes sur le point d''enlever les d\00E9finitions de feuille Web pour cet espace de travail. Les objets de base de donn\00E9es de feuille Web sont \00E9galement utilis\00E9s dans d''autres espaces de travail et ne seront pas supprim\00E9s. Les enregistrements associ\00E9s')
||unistr(' \00E0 cet espace de travail seront supprim\00E9s. Voulez-vous continuer ?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277236516222867238)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom d''objet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277236620140867238)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type d''objet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277236241283867237)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_language=>'fr'
,p_message_text=>unistr('Sch\00E9ma')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277573192002867455)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_language=>'fr'
,p_message_text=>unistr('Objets existants \00E0 utiliser')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276364821368866673)
,p_name=>'API_PRECONDITION_VIOLATED'
,p_message_language=>'fr'
,p_message_text=>unistr('La condition pr\00E9alable de l''API n''a pas \00E9t\00E9 respect\00E9e')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276523167042866777)
,p_name=>'APP.SETTING.CANNOT.GET'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible d''obtenir la valeur du param\00E8tre d''application %0 car l''option de construction associ\00E9e est d\00E9sactiv\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276523044017866777)
,p_name=>'APP.SETTING.CANNOT.SET'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de d\00E9finir la valeur du param\00E8tre d''application %0 car l''option de construction associ\00E9e est d\00E9sactiv\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277599875352867472)
,p_name=>'APP.SETTING.INVALID.VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur du param\00E8tre d''application %0 n''est pas valide')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277599701737867472)
,p_name=>'APP.SETTING.NOT.DEFINED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le param\00E8tre d''application demand\00E9 %0 n''est pas d\00E9fini')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277599922200867472)
,p_name=>'APP.SETTING.VALUE.NOT.NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('Le param\00E8tre d''application %0 ne peut pas \00EAtre d\00E9fini sur une valeur NULL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276416247171866705)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_language=>'fr'
,p_message_text=>'Calculs d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276416153287866705)
,p_name=>'APPLICACTION_PROCESS'
,p_message_language=>'fr'
,p_message_text=>'Processus d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276981498232867071)
,p_name=>'APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277061666101867124)
,p_name=>'APPLICATION BUILDER'
,p_message_language=>'fr'
,p_message_text=>'App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276886160810867010)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_language=>'fr'
,p_message_text=>'Condition de calcul d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276888894189867011)
,p_name=>'APPLICATION IMAGE'
,p_message_language=>'fr'
,p_message_text=>'Image d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276886273243867010)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_language=>'fr'
,p_message_text=>'Condition de processus d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276812988204866963)
,p_name=>'APPLICATIONS'
,p_message_language=>'fr'
,p_message_text=>'applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276958616098867056)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_language=>'fr'
,p_message_text=>'Applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276858959404866992)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_language=>'fr'
,p_message_text=>unistr('Activit\00E9 de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276899490546867018)
,p_name=>'APPLICATION_ALIAS'
,p_message_language=>'fr'
,p_message_text=>'Alias d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276897436669867017)
,p_name=>'APPLICATION_DELETED'
,p_message_language=>'fr'
,p_message_text=>unistr('Application supprim\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276347689255866663)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9veloppement d''applications')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276898401114867018)
,p_name=>'APPLICATION_HELP'
,p_message_language=>'fr'
,p_message_text=>'Identifie l''application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276855520753866990)
,p_name=>'APPLICATION_ID'
,p_message_language=>'fr'
,p_message_text=>unistr('Num\00E9ro d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276744804259866920)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ID d''application est r\00E9serv\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276744794478866920)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ID d''application doit \00EAtre un entier positif.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277276990558867264)
,p_name=>'APPLICATION_IMAGES'
,p_message_language=>'fr'
,p_message_text=>'Images d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276928757377867037)
,p_name=>'APPLICATION_ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ment d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276445271959866726)
,p_name=>'APPLICATION_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276410686773866702)
,p_name=>'APPLICATION_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Application : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276899344020867018)
,p_name=>'APPLICATION_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277627943060867490)
,p_name=>'APPLICATION_NAMES'
,p_message_language=>'fr'
,p_message_text=>'Noms d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277021783701867097)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_language=>'fr'
,p_message_text=>'ID de remplacement d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276896998898867017)
,p_name=>'APPLICATION_OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277627873397867490)
,p_name=>'APPLICATION_PAGES'
,p_message_language=>'fr'
,p_message_text=>'Pages d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276533313350866784)
,p_name=>'APPLICATION_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276897178616867017)
,p_name=>'APPLICATION_STATUS'
,p_message_language=>'fr'
,p_message_text=>'Statut de l''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276983429251867072)
,p_name=>'APPLICATION_VERSION'
,p_message_language=>'fr'
,p_message_text=>'Version de l''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276363211385866672)
,p_name=>'APPLICATION_X'
,p_message_language=>'fr'
,p_message_text=>'Application %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276842757631866982)
,p_name=>'APPROVED'
,p_message_language=>'fr'
,p_message_text=>unistr('Approuv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276903621596867021)
,p_name=>'APP_SUCCESS_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('La cr\00E9ation de l''application a r\00E9ussi.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277630548102867492)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Application mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276397660983866693)
,p_name=>'APP_TYPE_DATABASE'
,p_message_language=>'fr'
,p_message_text=>unistr('Application de base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276397773156866693)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_language=>'fr'
,p_message_text=>unistr('Application \00E9chantillon ou de productivit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276925129851867035)
,p_name=>'APP_TYPE_PACKAGED_WS'
,p_message_language=>'fr'
,p_message_text=>unistr('Feuille Web \00E9chantillon')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276397512152866693)
,p_name=>'APP_TYPE_WEBSHEET'
,p_message_language=>'fr'
,p_message_text=>'Application Web'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276842228485866982)
,p_name=>'ARCHIVED'
,p_message_language=>'fr'
,p_message_text=>unistr('Archiv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276410959166866702)
,p_name=>'ARCHIVELOG'
,p_message_language=>'fr'
,p_message_text=>unistr('Archivage de journaux : Activ\00E9')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276661811404866867)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_language=>'fr'
,p_message_text=>'Les arguments doivent avoir un checksum.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276757682166866928)
,p_name=>'ARGUMENT_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom d''argument'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276757849421866928)
,p_name=>'ARGUMENT_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type d''argument'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276836197829866978)
,p_name=>'ASAP'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E8s que possible')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276832790404866976)
,p_name=>'ASSIGNED'
,p_message_language=>'fr'
,p_message_text=>unistr('Affect\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276530992538866783)
,p_name=>'ASSIGNEE'
,p_message_language=>'fr'
,p_message_text=>'Destinataire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277655462584867508)
,p_name=>'ASSIGN_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Affecter %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276591572960866822)
,p_name=>'ASSOCIATED'
,p_message_language=>'fr'
,p_message_text=>unistr('associ\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276532824174866784)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctionnalit\00E9s associ\00E9es')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276864116645866996)
,p_name=>'ATTACHMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Pi\00E8ce jointe')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277671861839867519)
,p_name=>'AT_RISK_LABEL'
,p_message_language=>'fr'
,p_message_text=>'A risque'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276561427681866803)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous \00EAtes sur le point de faire migrer les options d''authentification personnalis\00E9e de cette application vers un mod\00E8le d''authentification.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276560984030866803)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9thode d''authentification en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276561326722866803)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonction d''authentification personnalis\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276561058737866803)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Page de connexion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276561264269866803)
,p_name=>'AUTH.LOGIN_URL'
,p_message_language=>'fr'
,p_message_text=>'URL de connexion'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276561114178866803)
,p_name=>'AUTH.NONE'
,p_message_language=>'fr'
,p_message_text=>'aucun'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276566557703866807)
,p_name=>'AUTHENTICATION'
,p_message_language=>'fr'
,p_message_text=>'Authentification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276887189820867010)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_language=>'fr'
,p_message_text=>'Fonction d''authentification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276886874383867010)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le d''authentification')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276581688774866816)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous \00EAtes sur le point de supprimer un mod\00E8le d''authentification pour l''application %0. Si l''application n''utilise pas actuellement l''authentification SCHEME ou si le mod\00E8le consid\00E9r\00E9 n''est pas le mod\00E8le d''authentification en cours, la suppression n''')
||unistr('a pas d''incidence sur le fonctionnement de l''application. Si l''application utilise l''authentification SCHEME et que ce mod\00E8le est le mod\00E8le d''authentification en cours, l''application va continuer \00E0 fonctionner avec l''authentification SCHEME, mais ell')
||unistr('e utilisera un mod\00E8le d''authentification par d\00E9faut. Ce dernier utilisera une page de connexion int\00E9gr\00E9e avec v\00E9rification des informations d''identification "porte ouverte" (autrement dit,  tout le monde sera autoris\00E9 \00E0 ex\00E9cuter l''application). ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276583596906866817)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Cliquez sur le bouton Rendre en cours pour que votre application utilise ce mod\00E8le d''authentification.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277091460520867144)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_language=>'fr'
,p_message_text=>'Comptes Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276344228250866661)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'fr'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277091521557867144)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_language=>'fr'
,p_message_text=>'Personnalisation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277091858978867144)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_language=>'fr'
,p_message_text=>'Aucune authentification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277091635600867144)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Comptes de base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277524886869867424)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Variable d''en-t\00EAte HTTP')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277092070522867144)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_language=>'fr'
,p_message_text=>'Oracle Application Server Single Sign-On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277091733501867144)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_language=>'fr'
,p_message_text=>'Annuaire LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277091950587867144)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_language=>'fr'
,p_message_text=>'Informations d''identification porte ouverte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276334432468866655)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_language=>'fr'
,p_message_text=>'Connexion SAML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276372989371866678)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_language=>'fr'
,p_message_text=>'Connexion sociale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276929805077867038)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le d''authentification')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276886723219867010)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le d''autorisation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276344354332866661)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'fr'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276363489868866672)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAte SQL Existe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276363532072866672)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonction PL/SQL renvoyant une valeur bool\00E9enne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276740690906866917)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_language=>'fr'
,p_message_text=>unistr('Est dans un r\00F4le ou un groupe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276740773887866917)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_language=>'fr'
,p_message_text=>unistr('N''est pas dans un r\00F4le ou un groupe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276363616237866672)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur de l''\00E9l\00E9ment dans Expression 1 = Expression 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276363750645866672)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment dans Expression1 est NOT NULL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276363875878866672)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('L''\00E9l\00E9ment dans Expression 1 est NULL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276363999419866673)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur de l''\00E9l\00E9ment dans Expression 1 != Expression 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276364088778866673)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAte SQL N''existe pas.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276364159389866673)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur de la pr\00E9f\00E9rence dans Expression 1 = Expression 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276364282130866673)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur de la pr\00E9f\00E9rence dans Expression 1 != Expression 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276429242749866715)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Effectuer l''\00E9valuation pour chaque vue de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276429397019866715)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_language=>'fr'
,p_message_text=>unistr('Effectuer l''\00E9valuation une fois par session')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366681232866674)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('Compte expir\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366543692866674)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_language=>'fr'
,p_message_text=>unistr('Compte verrouill\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366922126866674)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_language=>'fr'
,p_message_text=>unistr('Nombre maximal de tentatives de connexion d\00E9pass\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276367027181866674)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur interne inconnue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366860840866674)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_language=>'fr'
,p_message_text=>unistr('Premi\00E8re utilisation du mot de passe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366792534866674)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_language=>'fr'
,p_message_text=>'Mot de passe incorrect'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366387985866674)
,p_name=>'AUTH_SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Authentification normale, r\00E9ussie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366410083866674)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_language=>'fr'
,p_message_text=>'Nom utilisateur inconnu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276481202024866750)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_language=>'fr'
,p_message_text=>'Nom d''espace de travail inconnu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276491761202866757)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_language=>'fr'
,p_message_text=>'Nom d''espace de travail inconnu : %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276635511191866850)
,p_name=>'AUTOCOMMIT'
,p_message_language=>'fr'
,p_message_text=>unistr('Instruction de validation (commit) non applicable. Toutes les instructions sont valid\00E9es automatiquement.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276959244369867057)
,p_name=>'AUTOPROVISION_MODE'
,p_message_language=>'fr'
,p_message_text=>'Mode de provisionnement'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276341960340866659)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('Premier \00E9l\00E9ment')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276985163400867073)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_language=>'fr'
,p_message_text=>unistr('Disponibilit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276371574631866677)
,p_name=>'AVAILABLE'
,p_message_language=>'fr'
,p_message_text=>'Disponible'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277188818946867207)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_language=>'fr'
,p_message_text=>unistr('Accessible aux d\00E9veloppeurs uniquement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277188766979867207)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_language=>'fr'
,p_message_text=>unistr('Disponible avec la barre d''outils de d\00E9veloppeur')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276859726151866993)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_language=>'fr'
,p_message_text=>'Temps moyen d''affichage (secondes)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276430060725866715)
,p_name=>'BACK'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9c\00E9dent')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276840602567866981)
,p_name=>'BAR_CHART'
,p_message_language=>'fr'
,p_message_text=>unistr('Graphique \00E0 barres')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277262368146867254)
,p_name=>'BASIC'
,p_message_language=>'fr'
,p_message_text=>'Standard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276385377140866685)
,p_name=>'BASIC_DEVELOPER'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9veloppeur de base')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276819960671866967)
,p_name=>'BEFORE'
,p_message_language=>'fr'
,p_message_text=>'Avant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277633264075867494)
,p_name=>'BEFORE LIST ENTRY'
,p_message_language=>'fr'
,p_message_text=>unistr('Avant l''entr\00E9e de liste')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277654110841867507)
,p_name=>'BEFORE_FIRST'
,p_message_language=>'fr'
,p_message_text=>'Avant le premier'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276890083572867012)
,p_name=>'BIND_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 Bind')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276889327161867012)
,p_name=>'BIND_VARIABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Variable attach\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276889425705867012)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 de variable attach\00E9e')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276905206485867022)
,p_name=>'BLACK_TEXT'
,p_message_language=>'fr'
,p_message_text=>'Texte noir'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276348767093866663)
,p_name=>'BLANK'
,p_message_language=>'fr'
,p_message_text=>'Vierge'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276863377293866995)
,p_name=>'BLOB_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277023485554867098)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9charger en local')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276400413384866695)
,p_name=>'BLOB_FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Format BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277023878575867098)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Pi\00E8ce jointe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277023584212867098)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_language=>'fr'
,p_message_text=>'DOWNLOAD'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277023673598867098)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_language=>'fr'
,p_message_text=>'IMAGE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277023737099867098)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_language=>'fr'
,p_message_text=>'Incorporation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276864345647866996)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_language=>'fr'
,p_message_text=>'Format BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276863874537866995)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('BLOB - Derni\00E8re colonne mise \00E0 jour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276863213528866995)
,p_name=>'BLOB_TABLE'
,p_message_language=>'fr'
,p_message_text=>'Table BLOB'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276905107745867022)
,p_name=>'BLUE_TEXT'
,p_message_language=>'fr'
,p_message_text=>'Texte bleu'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276880376335867006)
,p_name=>'BRANCH CONDITION'
,p_message_language=>'fr'
,p_message_text=>'Condition de branchement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276433663949866718)
,p_name=>'BRANCHES'
,p_message_language=>'fr'
,p_message_text=>'Branchements'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276657784726866864)
,p_name=>'BREADCRUMB'
,p_message_language=>'fr'
,p_message_text=>'Chemin de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276820688414866968)
,p_name=>'BREADCRUMB LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 de chemin de navigation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276820703700866968)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom long de chemin de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276657862835866864)
,p_name=>'BREADCRUMBS'
,p_message_language=>'fr'
,p_message_text=>'Chemins de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276913790804867027)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9e de chemin de navigation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276928955591867037)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9e de chemin de navigation : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276745020870866920)
,p_name=>'BREADCRUMB_PAGES'
,p_message_language=>'fr'
,p_message_text=>'Pages de chemin de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276828841179866973)
,p_name=>'BREADCRUMB_REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gion de chemin de navigation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276494008908866758)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('La cr\00E9ation de le chemin de navigation a r\00E9ussi.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276823212435866970)
,p_name=>'BROWSE_ICON'
,p_message_language=>'fr'
,p_message_text=>unistr('Ic\00F4ne d''exploration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276823018304866969)
,p_name=>'BROWSE_PACKAGE'
,p_message_language=>'fr'
,p_message_text=>'Parcourir un package'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276757341843866928)
,p_name=>'BROWSE_TABLE'
,p_message_language=>'fr'
,p_message_text=>'Parcourir une table'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276352006662866665)
,p_name=>'BUFFER CACHE'
,p_message_language=>'fr'
,p_message_text=>'Cache de tampon'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276836642768866978)
,p_name=>'BUG'
,p_message_language=>'fr'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276860839923866994)
,p_name=>'BUGS'
,p_message_language=>'fr'
,p_message_text=>'Bugs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276883334309867008)
,p_name=>'BUGS_ASSIGNED'
,p_message_language=>'fr'
,p_message_text=>unistr('bugs attribu\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276922511385867033)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Bugs affect\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276380628208866683)
,p_name=>'BUGS_CLOSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Bugs ferm\00E9s (%0/%1) :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277298028897867278)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Pourcentage de bugs ferm\00E9s (%0/%1) :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276922635472867033)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Bugs non affect\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276922765104867033)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_language=>'fr'
,p_message_text=>'Aucune date de correction'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277298444906867278)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_language=>'fr'
,p_message_text=>unistr('Bugs : %1 sur %0 ferm\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277662314384867513)
,p_name=>'BUG_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Bug : %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276876663231867004)
,p_name=>'BUILD QUERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Construire une requ\00EAte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276343849313866660)
,p_name=>'BUILDER'
,p_message_language=>'fr'
,p_message_text=>'Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276982668257867072)
,p_name=>'BUILDER.PLUGINS'
,p_message_language=>'fr'
,p_message_text=>'Modules d''extension'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276978192498867069)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_language=>'fr'
,p_message_text=>'[Non pris en charge]'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277272812429867261)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_language=>'fr'
,p_message_text=>'Message d''espace de travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276573870913866811)
,p_name=>'BUILD_OPTION'
,p_message_language=>'fr'
,p_message_text=>'Option de construction'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277047049131867115)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Option de construction : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277661099647867512)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Statut de construction : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277047902461867115)
,p_name=>'BUILD_VERSION'
,p_message_language=>'fr'
,p_message_text=>'Version du build'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276916134292867029)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le d''\00E9tat int\00E9gr\00E9')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276819114261866967)
,p_name=>'BUTTON'
,p_message_language=>'fr'
,p_message_text=>'bouton'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276819839652866967)
,p_name=>'BUTTON LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 de bouton')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277025155778867099)
,p_name=>'BUTTON.ADD'
,p_message_language=>'fr'
,p_message_text=>'Ajouter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276360437742866670)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_language=>'fr'
,p_message_text=>unistr('Les attributs du bouton s\00E9lectionn\00E9 ne doivent pas contenir d''ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276360307986866670)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_language=>'fr'
,p_message_text=>unistr('Le bouton s\00E9lectionn\00E9 doit comporter une action de type D\00E9fini par une action dynamique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276360616268866670)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_language=>'fr'
,p_message_text=>unistr('Le bouton s\00E9lectionn\00E9 utilise un mod\00E8le de bouton qui ne contient pas la cha\00EEne de substitution #BUTTON_ID#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277024982038867099)
,p_name=>'BUTTON.DELETE'
,p_message_language=>'fr'
,p_message_text=>'Supprimer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276433910021866718)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('La page doit \00EAtre indiqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276410122191866701)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_language=>'fr'
,p_message_text=>unistr('La requ\00EAte d''\00E9tat doit \00EAtre indiqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276397335802866693)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_language=>'fr'
,p_message_text=>unistr('La demande de bouton doit \00EAtre indiqu\00E9e pour tous les types de source de demande de bouton, sauf si le type de source de demande de bouton est Toujours NULL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276398018046866693)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Vous devez indiquer le type de source de demande de bouton.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276434096471866718)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_language=>'fr'
,p_message_text=>unistr('La cible d''URL doit \00EAtre indiqu\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276362996726866672)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_language=>'fr'
,p_message_text=>unistr('Lorsque l''action est de type D\00E9fini par une action dynamique, les attributs de bouton ne doivent pas contenir d''ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276435674860866719)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_language=>'fr'
,p_message_text=>'Vous devez indiquer l''image.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276435799851866719)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_language=>'fr'
,p_message_text=>'Vous devez indiquer le style.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276435543693866719)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Le mod\00E8le doit \00EAtre indiqu\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276362828734866672)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_language=>'fr'
,p_message_text=>unistr('Lorsque le style de bouton est bas\00E9 sur un mod\00E8le et que l''action est de type D\00E9fini par une action dynamique, le mod\00E8le de bouton s\00E9lectionn\00E9 doit contenir la cha\00EEne de substitution #BUTTON_ID#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276350469103866664)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de supprimer le bouton car il est r\00E9f\00E9renc\00E9 dans une action dynamique (page : %0, action dynamique : ''%1'', action : ''%2'', attribut : ''El\00E9ment affect\00E9'').')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276350398344866664)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de supprimer le bouton car il est r\00E9f\00E9renc\00E9 dans une action dynamique (page : %0, action dynamique : ''%1'', attribut : ''Quand'').')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277025057021867099)
,p_name=>'BUTTON.SUBMIT'
,p_message_language=>'fr'
,p_message_text=>'Soumettre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277020934733867096)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_language=>'fr'
,p_message_text=>'A utiliser dans un attribut "onclick"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277024401403867098)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_language=>'fr'
,p_message_text=>'A utiliser dans un attribut "href"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276433891084866718)
,p_name=>'BUTTONS'
,p_message_language=>'fr'
,p_message_text=>'Boutons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276890536406867013)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_language=>'fr'
,p_message_text=>'Attributs de bouton'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276342712260866660)
,p_name=>'BUTTON_CSS_CLASSES'
,p_message_language=>'fr'
,p_message_text=>'Classes CSS de bouton'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276541286934866790)
,p_name=>'BUTTON_ID'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ID de bouton g\00E9n\00E9r\00E9 sera l''ID statique du bouton, s''il est d\00E9fini ; dans le cas contraire il s''agira d''un ID g\00E9n\00E9r\00E9 en interne au format ''B'' || [ID de bouton interne]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277660862231867512)
,p_name=>'BUTTON_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Bouton : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276895768063867016)
,p_name=>'BUTTON_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de bouton')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276430703749866716)
,p_name=>'BYTES'
,p_message_language=>'fr'
,p_message_text=>'octets'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276836219820866978)
,p_name=>'BY_NEXT_PATCH'
,p_message_language=>'fr'
,p_message_text=>'Au prochain patch'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276836372881866978)
,p_name=>'BY_NEXT_RELEASE'
,p_message_language=>'fr'
,p_message_text=>'A la prochaine version'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277760269374867576)
,p_name=>'CA.ABOUT'
,p_message_language=>'fr'
,p_message_text=>'A propos de'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277726587087867554)
,p_name=>'CA.ABOUT.PAGE'
,p_message_language=>'fr'
,p_message_text=>'A propos de la page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277726430036867554)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Inclure une page A propos de cette application qui contient une description de l''application, sa version et un nombre de pages.',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276551321633866797)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_language=>'fr'
,p_message_text=>'Conteneur de contenu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277760474266867576)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'A propos de la page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277760569753867576)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Le texte concernant cette application peut \00EAtre ins\00E9r\00E9 ici.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277760189092867576)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_language=>'fr'
,p_message_text=>'A propos de cette page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277772444939867584)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_language=>'fr'
,p_message_text=>unistr('A propos de la version b\00EAta')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277726826519867554)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_language=>'fr'
,p_message_text=>unistr('Contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277762788303867577)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Actions de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277752239439867571)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Configuration du contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277725264020867553)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer l''autorisation utilisateur bas\00E9e sur les r\00F4les')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277726931320867554)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Incorporer l''authentification utilisateur bas\00E9e sur les r\00F4les dans votre application.'),
unistr('Les utilisateurs peuvent \00EAtre d\00E9finis en tant qu''administrateurs, contributeurs ou lecteurs.'),
unistr('Vous pouvez ensuite facilement d\00E9finir diff\00E9rents acc\00E8s en fonction des diff\00E9rents r\00F4les pour divers composants au sein de votre application, tels que des pages, des entr\00E9es de menu, des r\00E9gions, des colonnes, des \00E9l\00E9ments, des boutons, etc.</p>'),
'<p>Comprend les composants suivants :',
'<ul>',
unistr('<li>R\00E9gion de page administrative comportant des liens permettant d''acc\00E9der aux fonctions de contr\00F4le</li>'),
unistr('<li>Table d''utilisateurs permettant de g\00E9rer le contr\00F4le d''acc\00E8s</li>'),
unistr('<li>Page de configuration permettant de d\00E9finir le niveau d''acc\00E8s des utilisateurs authentifi\00E9s</li>'),
unistr('<li>Page de configuration permettant d''indiquer si les noms utilisateur sont des adresses \00E9lectroniques ou non</li>'),
unistr('<li>Page de gestion de l''acc\00E8s des utilisateurs permettant de signaler et de modifier l''acc\00E8s utilisateur</li>'),
'<li>Page d''ajout d''utilisateur permettant d''ajouter un seul utilisateur</li>',
'<li>Page d''ajout de plusieurs utilisateurs permettant d''ajouter plusieurs utilisateurs (noms utilisateur de messagerie uniquement)</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277751141210867570)
,p_name=>'CA.ACCESS.ROLE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00F4le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277751854809867570)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_language=>'fr'
,p_message_text=>unistr('ID de r\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276470773546866743)
,p_name=>'CA.ACCESS.ROLES'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00F4les')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277751218123867570)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_language=>'fr'
,p_message_text=>unistr('Compte verrouill\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276498576505866761)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9ception confirm\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277762534428867577)
,p_name=>'CA.ACL.INFORMATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Informations sur la liste de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277763227597867578)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_language=>'fr'
,p_message_text=>unistr('Privil\00E8ges insuffisants, l''utilisateur n''est pas un administrateur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277763314554867578)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous n''\00EAtes pas autoris\00E9 \00E0 afficher cette application, car vous ne disposez pas des droits d''acc\00E8s ou votre compte a \00E9t\00E9 verrouill\00E9. Contactez l''administrateur de l''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277763446931867578)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_language=>'fr'
,p_message_text=>unistr('Privil\00E8ges insuffisants, l''utilisateur n''est pas un contributeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277752964532867571)
,p_name=>'CA.ACL.SAVED'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de contr\00F4le d''acc\00E8s enregistr\00E9s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277757627819867574)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_language=>'fr'
,p_message_text=>'HTML de bouton d''action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277756520362867573)
,p_name=>'CA.ACTION.LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 d''action')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277756630381867573)
,p_name=>'CA.ACTION.LINK'
,p_message_language=>'fr'
,p_message_text=>'Lien d''action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277759244200867575)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_language=>'fr'
,p_message_text=>'HTML de lien d''action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277744722694867566)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Action trait\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277750233072867569)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_language=>'fr'
,p_message_text=>unistr('Activit\00E9 par heure')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277784521425867592)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_language=>'fr'
,p_message_text=>unistr('Tableau de bord des activit\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277727016353867554)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_language=>'fr'
,p_message_text=>unistr('G\00E9n\00E9ration d''\00E9tats d''activit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277726284282867554)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Inclure l''activit\00E9 utilisateur et les \00E9tats d''erreur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277727141884867554)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Inclure de nombreux \00E9tats relatifs \00E0 l''activit\00E9 des utilisateurs finals de votre application. Identifier les utilisateurs les plus actifs, les pages les plus visit\00E9es, les performances des pages et les erreurs g\00E9n\00E9r\00E9es afin de mieux comprendre l''u')
||unistr('tilisation de votre application en vue d''apporter des am\00E9liorations.</p>'),
unistr('<p>Comprend les \00E9l\00E9ments suivants :'),
'<ul>',
'<li>Etat sur les principaux utilisateurs</li>',
'<li>Etat sur le journal des erreurs de l''application</li>',
unistr('<li>Performances de page, activit\00E9 et performances par page</li>'),
unistr('<li>Etat sur l''activit\00E9 de l''application par page</li>'),
unistr('<li>Etat d\00E9taill\00E9 sur les vues de page</li>'),
'',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276872934978867001)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Date de d\00E9but r\00E9elle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277762409196867577)
,p_name=>'CA.ADD'
,p_message_language=>'fr'
,p_message_text=>'Ajouter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277757833222867574)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajouter un mod\00E8le de courriel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277775478259867586)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_language=>'fr'
,p_message_text=>'Ajouter plusieurs utilisateurs - Etape 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277760717290867576)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajouter un nouvel \00E9l\00E9ment %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277743799410867565)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une notification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277616220128867483)
,p_name=>'CA.ADD.PAGE'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277751912429867570)
,p_name=>'CA.ADD.USER'
,p_message_language=>'fr'
,p_message_text=>'Ajouter un utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277775846960867586)
,p_name=>'CA.ADD.USERS'
,p_message_language=>'fr'
,p_message_text=>'Ajouter des utilisateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277728670852867555)
,p_name=>'CA.ADDING.PAGES'
,p_message_language=>'fr'
,p_message_text=>'Ajout de pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277729196507867556)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Pour ajouter une page \00E0 votre application, cliquez sur <strong>Ajouter une page</strong>. S\00E9lectionnez ensuite un type de page (vierge, graphique, formulaire, \00E9tat, etc.) et d\00E9finissez ses attributs. Vous pouvez \00E9galement \00EAtre amen\00E9 \00E0 indiquer une')
||unistr(' table ou une vue valide. Utilisez SQL Workshop pour pr\00E9parer les objets de base de donn\00E9es dans votre espace de travail.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277758660612867575)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_language=>'fr'
,p_message_text=>unistr('Avanc\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276872209802867001)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_language=>'fr'
,p_message_text=>unistr('Informations suppl\00E9mentaires')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277751609148867570)
,p_name=>'CA.ADDRESS'
,p_message_language=>'fr'
,p_message_text=>'Adresse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277731827732867557)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_language=>'fr'
,p_message_text=>unistr('Contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277732494118867558)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir le niveau d''acc\00E8s des utilisateurs authentifi\00E9s de cette application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277730980993867557)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Etats d''activit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277731928236867557)
,p_name=>'CA.ADMIN.ADD'
,p_message_language=>'fr'
,p_message_text=>'Ajouter'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277733629460867559)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_language=>'fr'
,p_message_text=>'Administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277732399273867558)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_language=>'fr'
,p_message_text=>'Administrateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276907949382867024)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_language=>'fr'
,p_message_text=>'Configuration de l''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277018687507867095)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_language=>'fr'
,p_message_text=>'Interface utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277767253046867580)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_language=>'fr'
,p_message_text=>'Administration des applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277767324992867580)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('G\00E9rer le composant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277730556220867557)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lection du style de th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277730619964867557)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir la pr\00E9sentation par d\00E9faut de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277730205639867556)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_language=>'fr'
,p_message_text=>'Options de configuration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277730121426867556)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer ou d\00E9sactiver des fonctionnalit\00E9s de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277731245646867557)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_language=>'fr'
,p_message_text=>'Journal des erreurs de l''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277731342789867557)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat des erreurs consign\00E9es par cette application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277730784358867557)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277730851110867557)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir le nom d''application et une br\00E8ve description')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277730303929867556)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_language=>'fr'
,p_message_text=>unistr('Mises \00E0 jour de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277730485812867557)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Tenir \00E0 jour la liste des mises \00E0 jour de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277729893838867556)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_language=>'fr'
,p_message_text=>'Configuration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277732254471867558)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_language=>'fr'
,p_message_text=>'Contributeurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277783311365867591)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_language=>'fr'
,p_message_text=>'Tableau de bord'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277783227649867591)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Consulter les mesures d''activit\00E9 d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277735388310867560)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_language=>'fr'
,p_message_text=>unistr('Fuseau horaire par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277735468818867560)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir le fuseau horaire par d\00E9faut pour cette application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277733150904867558)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Adresse \00E9lectronique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277735582990867560)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de messagerie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277735697785867560)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Indiquer si le courriel doit \00EAtre envoy\00E9 et, le cas \00E9ch\00E9ant, le destinataire de la r\00E9ponse')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277732657460867558)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_language=>'fr'
,p_message_text=>'Informations en retour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277732930882867558)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres d''informations en retour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277733018942867558)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Choisissez si les pi\00E8ces jointes doivent \00EAtre autoris\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277732795760867558)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_language=>'fr'
,p_message_text=>'Informations en retour des utilisateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277732877812867558)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat de l''ensemble des informations en retour envoy\00E9es par les utilisateurs de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277733275963867558)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de courriel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277733366554867558)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('G\00E9rer les mod\00E8les de courriels HTML et CSS utilis\00E9s par cette application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277729988921867556)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_language=>'fr'
,p_message_text=>'Notifications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277730092942867556)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_language=>'fr'
,p_message_text=>'Afficher les notifications sur la page d''accueil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277767912612867581)
,p_name=>'CA.ADMIN.PAGE'
,p_message_language=>'fr'
,p_message_text=>'Page d''administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277731433708867557)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_language=>'fr'
,p_message_text=>'Performances de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277731561595867557)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat de l''activit\00E9 et des performances par page d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277731695985867557)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_language=>'fr'
,p_message_text=>'Vues de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277731721850867557)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat de chaque vue de page par utilisateur comportant la date d''acc\00E8s et le temps \00E9coul\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277732187050867558)
,p_name=>'CA.ADMIN.READERS'
,p_message_language=>'fr'
,p_message_text=>'Lecteurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277776535902867586)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_language=>'fr'
,p_message_text=>'Envoyer un courriel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277776639275867586)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Envoyer un courriel bas\00E9 sur un mod\00E8le \00E0 partir de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277731007593867557)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_language=>'fr'
,p_message_text=>'Principaux utilisateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277731147171867557)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat des vues de page consolid\00E9es par utilisateur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277732050244867558)
,p_name=>'CA.ADMIN.USERS'
,p_message_language=>'fr'
,p_message_text=>'Utilisateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277732525539867558)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier les param\00E8tres de contr\00F4le d''acc\00E8s et d\00E9sactiver le contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277733414623867558)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_language=>'fr'
,p_message_text=>'Journal de courriels'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277733546341867559)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Afficher le journal des courriels envoy\00E9s par cette application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276654563949866862)
,p_name=>'CA.ADVANCED'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Avanc\00E9</strong> : d\00E9veloppez pour voir les options avanc\00E9es.'),
'    <ul>',
unistr('      <li><strong>D\00E9finir comme page d''accueil</strong> : d\00E9finir cette page comme page d''accueil de l''application.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;Toute page pr\00E9c\00E9demment d\00E9finie comme page d''accueil sera mise \00E0 jour.</li>'),
unistr('      <li><strong>D\00E9finir comme page d''administration</strong> : ajoutez cette page sous Administration plut\00F4t qu''en tant que page normale dans l''application. Pour y acc\00E9der, cliquez sur Administration dans le menu principal et s\00E9lectionnez-la dans l')
||'a liste Administration des applications.<br>',
unistr('        <em><strong>Remarque :</strong> une page ne peut pas \00EAtre \00E0 la fois une page d''accueil et une page sous Administration.</em></li>'),
'      &nbsp;<br>',
unistr('      <li><strong>Aide de la page</strong> : saisissez du texte \00E0 ajouter au texte d''aide de la page.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276524873316866779)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Avanc\00E9</strong> : d\00E9veloppez pour voir les options avanc\00E9es.'),
'    <ul>',
unistr('      <li><strong>Aide de la page</strong> : saisissez le texte \00E0 ajouter au texte d''aide de la page.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277768389449867581)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres avanc\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277768496184867581)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>D\00E9finissez des param\00E8tres suppl\00E9mentaires de d\00E9finition, de s\00E9curit\00E9 et de globalisation. Ces param\00E8tres peuvent \00EAtre appliqu\00E9s lors de la cr\00E9ation de l''application et peuvent \00E9galement \00EAtre modifi\00E9s une fois l''application cr\00E9\00E9e.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277771402704867583)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Pour obtenir plus d''informations, lisez l''aide d''\00E9l\00E9ment ( <span class="fa fa-question-circle" aria-hidden="true"></span> ) de chaque param\00E8tre.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277777290495867587)
,p_name=>'CA.AFTER.ROWS'
,p_message_language=>'fr'
,p_message_text=>unistr('Apr\00E8s lignes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277757553531867574)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_language=>'fr'
,p_message_text=>unistr('Apr\00E8s lignes - HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277760682260867576)
,p_name=>'CA.ALL.COLS'
,p_message_language=>'fr'
,p_message_text=>'Toutes les colonnes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277756700784867573)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_language=>'fr'
,p_message_text=>unistr('Autoriser le d\00E9sabonnement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276865812745866997)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_language=>'fr'
,p_message_text=>unistr('Autoriser les ex\00E9cutions en mode restreint')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277750130914867569)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_language=>'fr'
,p_message_text=>'Journal des erreurs de l''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277746034482867567)
,p_name=>'CA.APP.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276918886140867031)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Indique si le contr\00F4le d''acc\00E8s est activ\00E9 ou non')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276918904687867031)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Niveau d''acc\00E8s par d\00E9faut attribu\00E9 aux utilisateurs authentifi\00E9s qui ne figurent pas dans la liste de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277746462517867567)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de l''application mis \00E0 jour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277746295477867567)
,p_name=>'CA.APP.SUBTITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Br\00E8ve description')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277746302015867567)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Le texte entr\00E9 ici est affich\00E9 en dessous du nom de l''application sur la page d''accueil de l''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277735786328867560)
,p_name=>'CA.APPEARANCE'
,p_message_language=>'fr'
,p_message_text=>'Apparence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277735893440867560)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>D\00E9finissez le sch\00E9ma de couleur (style de th\00E8me) par d\00E9faut de l''application, l''emplacement de la navigation et l''ic\00F4ne utilis\00E9e pour l''application.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277755287541867572)
,p_name=>'CA.APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277742385319867564)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_language=>'fr'
,p_message_text=>'Apparence de l''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277736389087867560)
,p_name=>'CA.APPLICATION.ICON'
,p_message_language=>'fr'
,p_message_text=>unistr('Ic\00F4ne de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277736415031867560)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Cliquez sur <strong>Choisir une nouvelle ic\00F4ne</strong> pour s\00E9lectionner la couleur de l''ic\00F4ne et l''une des ic\00F4nes disponibles. Votre s\00E9lection est affich\00E9e sur la page d''accueil de l''application.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277736752165867561)
,p_name=>'CA.APPLICATION.ID'
,p_message_language=>'fr'
,p_message_text=>'ID d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277736871843867561)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Entrez un identificateur num\00E9rique unique pour votre application. Ce champ contient un identificateur g\00E9n\00E9r\00E9 automatiquement par d\00E9faut.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277755887978867573)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_language=>'fr'
,p_message_text=>'Page d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277748037452867568)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_language=>'fr'
,p_message_text=>'Sessions d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277726667280867554)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277725585331867553)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir le nom d''application et une br\00E8ve description')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277726709741867554)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Autoriser les administrateurs de l''application \00E0 mettre \00E0 jour diff\00E9rents param\00E8tres, tels que le nom de l''application et sa description, le fuseau horaire par d\00E9faut, etc.</p>'),
'<p>Comprend les composants suivants :',
'<ul>',
unistr('<li>Panneau et entr\00E9e de liste de page administrative</li>'),
unistr('<li>Possibilit\00E9 de d\00E9finir le nom de l''application</li>'),
unistr('<li>Possibilit\00E9 de d\00E9finir le sous-titre de r\00E9gion Hero de la page d''accueil</li>'),
unistr('<li>Possibilit\00E9 de d\00E9finir les destinataires des commentaires, si cette fonction est utilis\00E9e</li>'),
unistr('<li>Possibilit\00E9 de d\00E9finir le fuseau horaire par d\00E9faut de l''application</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277782303052867590)
,p_name=>'CA.APPLICATIONITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ment d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277784170950867591)
,p_name=>'CA.APPLY'
,p_message_language=>'fr'
,p_message_text=>'Appliquer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277785954568867592)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Application des valeurs par d\00E9faut d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277741545120867564)
,p_name=>'CA.APPLY.CHANGES'
,p_message_language=>'fr'
,p_message_text=>'Appliquer les modifications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277783956623867591)
,p_name=>'CA.APPLY.FILTERS'
,p_message_language=>'fr'
,p_message_text=>'Appliquer des filtres'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277016515834867093)
,p_name=>'CA.APP_BANNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Application cr\00E9\00E9e \00E0 l''aide de l''assistant Cr\00E9ation d''application %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277017889814867094)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrer le param\00E8tre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277788152589867594)
,p_name=>'CA.ATTACHMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Pi\00E8ce jointe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276732289131866912)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Nombre de pi\00E8ces jointes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277788211773867594)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de pi\00E8ce jointe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276732193821866912)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_language=>'fr'
,p_message_text=>unistr('Taille de pi\00E8ce jointe')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277784292085867591)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Les valeurs par d\00E9faut de l''attribut sont d\00E9j\00E0 d\00E9finies pour l''\00E9l\00E9ment %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277752364806867571)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Tous les utilisateurs authentifi\00E9s peuvent acc\00E9der \00E0 cette application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277737581842867561)
,p_name=>'CA.AUTHENTICATION'
,p_message_language=>'fr'
,p_message_text=>'Authentification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277737638675867561)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Indiquez le mode d''authentification souhait\00E9e pour les utilisateurs dans votre application.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276868552037866998)
,p_name=>'CA.AUTO.DROP'
,p_message_language=>'fr'
,p_message_text=>'Suppression automatique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277748793740867568)
,p_name=>'CA.AVG.ELAPSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Temps moyen \00E9coul\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276915993953867029)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Retour \00E0 l''\00E9tat sur les travaux')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276732994887866912)
,p_name=>'CA.BCC'
,p_message_language=>'fr'
,p_message_text=>'CCI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277777125644867587)
,p_name=>'CA.BEFORE.ROWS'
,p_message_language=>'fr'
,p_message_text=>'Avant lignes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277757408299867574)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_language=>'fr'
,p_message_text=>'Avant lignes - HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277758919535867575)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>'Avant lignes - Contenu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277734249268867559)
,p_name=>'CA.BLANK'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une page vierge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277734304714867559)
,p_name=>'CA.BLANK.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une page vierge en tant qu''espace r\00E9serv\00E9. Une fois l''application cr\00E9\00E9e, vous pouvez facilement cr\00E9er des r\00E9gions sur la page dans le concepteur de page.</p>'),
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de page</strong> (obligatoire) : saisissez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
unistr('<!--  <li><strong>Inclure une navigation de page</strong> : cochez cette option pour afficher une liste des cartes de toutes les autres pages d\00E9finies dans votre application.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;Cette option est g\00E9n\00E9ralement utilis\00E9e sur la page d''accueil de votre application.</li>'),
'-->',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277767686468867581)
,p_name=>'CA.BLUEPRINT'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de base d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277767750935867581)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Le mod\00E8le de base r\00E9pertorie la d\00E9finition d''application au format JSON.</p>'),
unistr('<p>La premi\00E8re fois que vous acc\00E9dez \00E0 cet \00E9cran, la d\00E9finition d''application en cours est transform\00E9e en document JSON et est affich\00E9e. Vous pouvez modifier le document afin de mettre \00E0 jour les propri\00E9t\00E9s d''application, puis cliquer sur <strong>App')
||unistr('liquer le mod\00E8le de base</strong> pour modifier les d\00E9tails d''application en cours.</p>'),
'<p>&nbsp;</p>',
unistr('<p>Si vous devez cr\00E9er un grand nombre de pages similaires, copier le code JSON appropri\00E9 pour une page, le coller plusieurs fois et y apporter quelques modifications est consid\00E9rablement plus rapide que d''utiliser manuellement l''option <strong>Ajout')
||'er une page</strong> pour chaque page.</p>',
unistr('<p>Cliquez sur <strong>Charger un mod\00E8le de base pr\00E9c\00E9dent</strong> pour remplacer le mod\00E8le de base par la d\00E9finition d''une application pr\00E9c\00E9demment g\00E9n\00E9r\00E9e. Vous pouvez ainsi it\00E9rer tr\00E8s facilement une conception d''application en ajoutant des pages')
||unistr(' suppl\00E9mentaires, en modifiant les fonctionnalit\00E9s ou en r\00E9glant les param\00E8tres, avant de reg\00E9n\00E9rer l''application.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277756377103867573)
,p_name=>'CA.BODY1.TEXT'
,p_message_language=>'fr'
,p_message_text=>'Texte Corps1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277756451963867573)
,p_name=>'CA.BODY2.TEXT'
,p_message_language=>'fr'
,p_message_text=>'Texte Corps2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277777590116867587)
,p_name=>'CA.BOTH'
,p_message_language=>'fr'
,p_message_text=>'Les deux'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277742702244867564)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_language=>'fr'
,p_message_text=>'Branchement sur la page d''administration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276653432803866861)
,p_name=>'CA.BUTTON.BAR'
,p_message_language=>'fr'
,p_message_text=>'Barre de boutons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277742412570867564)
,p_name=>'CA.BUTTONS'
,p_message_language=>'fr'
,p_message_text=>'Boutons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277734974369867559)
,p_name=>'CA.CALENDAR'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une page de calendrier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277735090402867560)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une page qui affiche un calendrier.</p>'),
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de la page</strong> (obligatoire) : indiquez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
unistr('  <li><strong>Table ou vue</strong> (obligatoire) : s\00E9lectionnez l''objet de base de donn\00E9es du calendrier.</li>'),
unistr('  <li><strong>Colonne d''affichage</strong> (obligatoire) : s\00E9lectionnez dans la table ou la vue la colonne \00E0 afficher dans les \00E9v\00E9nements de calendrier.</li>'),
unistr('  <li><strong>Colonne de date de d\00E9but</strong> (obligatoire) : s\00E9lectionnez dans la table ou la vue la colonne de date \00E0 utiliser en tant que date de d\00E9but pour les \00E9v\00E9nements de calendrier.</li>'),
unistr('  <li><strong>Colonne de date de fin</strong> : s\00E9lectionnez dans la table ou la vue la colonne de date \00E0 utiliser en tant que date de fin pour les \00E9v\00E9nements de calendrier.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;Si la date de fin est sp\00E9cifi\00E9e, les \00E9v\00E9nements bas\00E9s sur la dur\00E9e seront affich\00E9s. </li>'),
unistr('  <li><strong>Afficher l''heure</strong> : s\00E9lectionnez <strong>Oui</strong> pour afficher la p\00E9riode des \00E9v\00E9nements et activer \00E9galement les vues de calendrier Hebdomadaire et Quotidienne. S\00E9lectionnez <strong>Non</strong> pour afficher uniquement le')
||unistr('s dates des \00E9v\00E9nements.</li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277741416817867564)
,p_name=>'CA.CANCEL'
,p_message_language=>'fr'
,p_message_text=>'Annuler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277743344401867565)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_language=>'fr'
,p_message_text=>unistr('Annuler la bo\00EEte de dialogue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276633516962866849)
,p_name=>'CA.CANCEL.MODAL'
,p_message_language=>'fr'
,p_message_text=>'Annuler Modal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277753270321867571)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_language=>'fr'
,p_message_text=>'Vous ne pouvez pas enlever les droits d''administration de votre propre enregistrement.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277785181703867592)
,p_name=>'CA.CARD'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une page de carte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277785084553867592)
,p_name=>'CA.CARD.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une page qui affiche des cartes.</p>'),
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de page</strong> (obligatoire) : saisissez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
unistr('  <li><strong>Table ou vue</strong> (obligatoire) : s\00E9lectionnez l''objet de base de donn\00E9es pour la carte.</li>'),
unistr('  <li><strong>Titre de carte</strong> (obligatoire) : s\00E9lectionnez la colonne dans la table ou la vue \00E0 utiliser comme titre pour la carte.</li>'),
unistr('  <li><strong>Colonne de description</strong> (obligatoire) : s\00E9lectionnez la colonne dans la table ou la vue \00E0 utiliser comme description pour la carte.</li>'),
unistr('  <li><strong>Colonne de texte suppl\00E9mentaire</strong> : s\00E9lectionnez la colonne dans la table ou la vue \00E0 utiliser comme description secondaire pour la carte.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277783682482867591)
,p_name=>'CA.CARDS'
,p_message_language=>'fr'
,p_message_text=>'Cartes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277783752486867591)
,p_name=>'CA.CARDS.VIEW'
,p_message_language=>'fr'
,p_message_text=>'Vue Cartes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276733075680866912)
,p_name=>'CA.CC'
,p_message_language=>'fr'
,p_message_text=>'CC'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277017273669867094)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_language=>'fr'
,p_message_text=>'Modifier les filtres'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277734027783867559)
,p_name=>'CA.CHART'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une page de graphique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277734133806867559)
,p_name=>'CA.CHART.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une page qui affiche un graphique \00E0 aires, \00E0 barres, \00E0 courbes ou \00E0 secteurs.</p>'),
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de la page</strong> (obligatoire) : indiquez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
unistr('  <li><strong>Type de graphique</strong> : s\00E9lectionnez le type de graphique \00E0 afficher [<strong>A aires</strong>, <strong>A barres</strong>, <strong>A courbes</strong>, <strong>A secteurs</strong>].</li>'),
unistr('  <li><strong>Table ou vue</strong> (obligatoire) : s\00E9lectionnez l''objet de base de donn\00E9es du graphique.</li>'),
unistr('  <li><strong>Colonne de libell\00E9</strong> (obligatoire) : s\00E9lectionnez dans la table ou la vue la colonne \00E0 utiliser en tant que libell\00E9 du graphique.</li>'),
unistr('  <li><strong>Agr\00E9gation de valeurs</strong> : s\00E9lectionnez la mani\00E8re dont la colonne de valeurs doit \00EAtre affich\00E9e ou agr\00E9g\00E9e<br>'),
'      &nbsp;&nbsp;&nbsp;[Column Value, Sum, Count].</li>',
unistr('  <li><strong>Colonne de valeurs</strong> (obligatoire) : s\00E9lectionnez dans la table ou la vue une colonne num\00E9rique \00E0 utiliser pour calculer les valeurs de graphique affich\00E9es.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277734467110867559)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h3>Exemples</h3>',
unistr('<p>Consultez les exemples pour savoir comment utiliser les diff\00E9rents types d''<strong>agr\00E9gation</strong> :</p>'),
unistr('<p><strong>Exemple 1 :</strong> Afficher un graphique sur les employ\00E9s comportant le num\00E9ro d''employ\00E9 du responsable pour chaque employ\00E9.'),
'<code><ul>',
unistr('  <li>Table ou vue - S\00E9lectionnez EMP.</li>'),
unistr('  <li>Colonne de libell\00E9 - S\00E9lectionnez ENAME.</li>'),
unistr('  <li>Agr\00E9gation - S\00E9lectionnez <u><strong>Valeur de colonne</strong></u>.</li>'),
unistr('  <li>Colonne de valeurs - S\00E9lectionnez MGR.</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>Exemple 2 :</strong> Afficher un graphique sur les employ\00E9s comportant le salaire total pour chaque poste.'),
'<code><ul>',
unistr('  <li>Table ou vue - S\00E9lectionnez EMP.</li>'),
unistr('  <li>Colonne de libell\00E9 - S\00E9lectionnez JOB.</li>'),
unistr('  <li>Agr\00E9gation - S\00E9lectionnez <u><strong>Somme</strong></u>.</li>'),
unistr('  <li>Colonne de valeurs - S\00E9lectionnez SAL.</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>Exemple 3 :</strong> Afficher un graphique sur les employ\00E9s comportant le nombre d''employ\00E9s dans chaque service.'),
'<code><ul>',
unistr('  <li>Table ou vue - S\00E9lectionnez EMP.</li>'),
unistr('  <li>Colonne de libell\00E9 - S\00E9lectionnez DEPTNO.</li>'),
unistr('  <li>Agr\00E9gation - S\00E9lectionnez <u><strong>Nombre</strong></u>.</li>'),
unistr('  <li>Colonne de valeurs - S\00E9lectionnez EMPNO.</li>'),
'</ul></code>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276870570864867000)
,p_name=>'CA.CLIENT.ID'
,p_message_language=>'fr'
,p_message_text=>'ID de client'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277788384635867594)
,p_name=>'CA.CLOSE'
,p_message_language=>'fr'
,p_message_text=>'Fermer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276498485336866761)
,p_name=>'CA.CLOSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Ferm\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277786315945867593)
,p_name=>'CA.COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277762253013867577)
,p_name=>'CA.COLUMN.1'
,p_message_language=>'fr'
,p_message_text=>'Colonne 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277762355557867577)
,p_name=>'CA.COLUMN.2'
,p_message_language=>'fr'
,p_message_text=>'Colonne 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277749646795867569)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_language=>'fr'
,p_message_text=>'Alias de colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277782181191867590)
,p_name=>'CA.COMMENTS'
,p_message_language=>'fr'
,p_message_text=>'Commentaires'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277747347009867567)
,p_name=>'CA.COMPONENT.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de composant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277752196365867571)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_language=>'fr'
,p_message_text=>unistr('Configurer le contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277742525220867564)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_language=>'fr'
,p_message_text=>'Configurer l''apparence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277742695265867564)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>L''apparence de votre application est d\00E9finie par le style de th\00E8me.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277745909139867567)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Options de configuration mises \00E0 jour. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277727839907867555)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>'Options de configuration'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277726118190867554)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer ou d\00E9sactiver des fonctionnalit\00E9s de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277727937652867555)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permet aux administrateurs de l''application d''activer ou de d\00E9sactiver des fonctionnalit\00E9s sp\00E9cifiques dans l''application. Cette fonction est tr\00E8s utile si vous s\00E9lectionnez des fonctionnalit\00E9s qui requi\00E8rent des efforts suppl\00E9mentaires en mati\00E8re')
||unistr(' de d\00E9veloppement pour qu''elles puissent \00EAtre utilis\00E9es par les utilisateurs finals.<br>'),
unistr('Cette fonction peut \00E9galement \00EAtre \00E9tendue \00E0 des fonctionnalit\00E9s propres \00E0 l''application. Si les d\00E9veloppeurs d\00E9finissent des options de construction suppl\00E9mentaires et les associent \00E0 des fonctionnalit\00E9s sp\00E9cifiques dans l''application, elles peuvent')
||unistr(' alors \00EAtre ajout\00E9es aux param\00E8tres de configuration pour les administrateurs. Par exemple, dans l''application Suivi des clients, les administrateurs peuvent activer ou d\00E9sactiver les fonctionnalit\00E9s telles que Contacts, Chargement des donn\00E9es, G\00E9ogr')
||'aphie, et plus encore.',
'</p>',
'<p>Comprend les composants suivants :',
'<ul>',
unistr('<li>Possibilit\00E9 d''activer ou de d\00E9sactiver les fonctionnalit\00E9s de l''application</li>'),
unistr('<li>Utilisation de cette fonction pour permettre la s\00E9lection des fonctionnalit\00E9s par d\00E9ploiement</li>'),
unistr('<li>Prise en charge du regroupement des param\00E8tres d''application associ\00E9s</li>'),
unistr('<li>Permet aux d\00E9veloppeurs d''application de contr\00F4ler les composants \00E0 l''aide d''options de construction</li>'),
'<li>Disponible sur la page d''administration</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276865476101866996)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom des informations d''identification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276865515428866997)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire des informations d''identification')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277595472371867470)
,p_name=>'CA.CONTEXT'
,p_message_language=>'fr'
,p_message_text=>'Contexte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277752614344867571)
,p_name=>'CA.CONTRIBUTOR'
,p_message_language=>'fr'
,p_message_text=>'Contributeur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276872468235867001)
,p_name=>'CA.CPU.USED'
,p_message_language=>'fr'
,p_message_text=>unistr('UC utilis\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277761170145867576)
,p_name=>'CA.CREATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277766278572867580)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de la page d''administration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277763806999867578)
,p_name=>'CA.CREATE.APP'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277764957001867579)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation des calculs de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277764222577867578)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de l''ic\00F4ne de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277764812381867579)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''\00E9l\00E9ments d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277765008603867579)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de processus d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277606488554867477)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de param\00E8tres d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277772280728867584)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er une application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276917286252867030)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de r\00F4les d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277764458113867578)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de mod\00E8les d''autorisation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277765209191867579)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page vierge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277764344153867578)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''options de construction')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277765639032867579)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page de calendrier')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277778517101867588)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de la page de cartes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277765495925867579)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page de graphique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277765987127867579)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page d''\00E9tat classique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277765559163867579)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page de tableau de bord')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277763706275867578)
,p_name=>'CA.CREATE.END'
,p_message_language=>'fr'
,p_message_text=>'Finalisation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277785835196867592)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page de recherche \00E0 facets')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277766552628867580)
,p_name=>'CA.CREATE.FEATURES'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de fonctionnalit\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277783124066867591)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page de contenu filtr\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277765345170867579)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page de panneau')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277763965003867578)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page globale')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277766114208867580)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de la liste de navigation de la page d''accueil')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277766064876867579)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de la page de grille interactive')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277765827356867579)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page d''\00E9tat interactif')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277771908943867583)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de pages ma\00EEtre-d\00E9tail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277764603563867579)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de barres de navigation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277767805590867581)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''un groupe de pages')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277766446027867580)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Ex\00E9cution de la traduction')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277766330008867580)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_language=>'fr'
,p_message_text=>unistr('Ex\00E9cution de la traduction pour %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277765797103867579)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de la page d''\00E9tat et de panneau')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277772117857867583)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrement du mod\00E8le de base')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277764778220867579)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''un raccourci')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277765111445867579)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page de connexion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277763615132867578)
,p_name=>'CA.CREATE.START'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9but')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277764092009867578)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de scripts d''objet de prise en charge')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277764593075867578)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de messages texte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277778615595867588)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation de la page de cadre temporel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277786054823867593)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''une page d''assistant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277745268726867566)
,p_name=>'CA.CREATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277745301919867566)
,p_name=>'CA.CREATED.BY'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation par')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277733796604867559)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation d''application ...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276866185212866997)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom des informations d''identification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276872372129867001)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire des informations d''identification')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277745885688867566)
,p_name=>'CA.CURRENT.STATUS'
,p_message_language=>'fr'
,p_message_text=>'Statut en cours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277766875563867580)
,p_name=>'CA.CUSTOM.QRY'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAte personnalis\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276964003858867060)
,p_name=>'CA.CUSTOM.THEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Utiliser un th\00E8me personnalis\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276964171756867060)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Basculez l''assistant pour utiliser un th\00E8me personnalis\00E9 au lieu du th\00E8me universel.</p>'),
'',
unistr('<p>S\00E9lectionnez un th\00E8me d''espace de travail pour l''application. S''il prend en charge les styles de th\00E8me, le style peut \00E9galement \00EAtre utilis\00E9.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276633251209866849)
,p_name=>'CA.CUSTOM_THEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Th\00E8me personnalis\00E9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277767403516867580)
,p_name=>'CA.DASHBOARD'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une page de tableau de bord'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277593804286867468)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_language=>'fr'
,p_message_text=>'Graphique %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277767540173867580)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une page de tableau de bord avec plusieurs graphiques.</p>'),
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de page</strong> (obligatoire) : saisissez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
'  </ul>',
'</ul>',
'  &nbsp;<br>',
unistr('<p>Chaque graphique (Graphique 1, Graphique 2, Graphique 3 et Graphique 4) est d\00E9fini par d\00E9faut sur des types de graphique diff\00E9rents et reposent sur des <em>donn\00E9es \00E9chantillon</em>. '),
'  Ainsi, vous n''avez pas besoin de saisir d''autres informations pour ajouter cette page.',
unistr('  Toutefois, vous pouvez personnaliser chaque graphique en rempla\00E7ant les valeurs par d\00E9faut par vos propres s\00E9lections.<br>'),
'  Pour personnaliser un graphique, indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de graphique</strong> (obligatoire) : saisissez le nom du graphique.</li>',
unistr('  <li><strong>Type de graphique</strong> : s\00E9lectionnez le type de graphique \00E0 afficher [<strong>A aires</strong>, <strong>A barres</strong>, <strong>A courbes</strong>, <strong>A secteurs</strong>].</li>'),
unistr('  <li><strong>Table ou vue</strong> (obligatoire) : s\00E9lectionnez l''objet de base de donn\00E9es du graphique.</li>'),
unistr('  <li><strong>Colonne de libell\00E9</strong> (obligatoire) : s\00E9lectionnez dans la table ou la vue la colonne \00E0 utiliser en tant que libell\00E9 du graphique.</li>'),
unistr('  <li><strong>Agr\00E9gation de valeurs</strong> : s\00E9lectionnez la mani\00E8re dont la colonne de valeurs doit \00EAtre affich\00E9e ou agr\00E9g\00E9e.<br>'),
'      &nbsp;&nbsp;&nbsp;[Valeur de colonne, Somme, Nombre].</li>',
unistr('  <li><strong>Colonne de valeurs</strong> (obligatoire) : s\00E9lectionnez dans la table ou la vue une colonne num\00E9rique \00E0 utiliser pour calculer les valeurs de graphique affich\00E9es.</li>'),
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277779205987867588)
,p_name=>'CA.DATATYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Type de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277780378244867589)
,p_name=>'CA.DATEFORMATMASK'
,p_message_language=>'fr'
,p_message_text=>'Masque de format de date '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277746582545867567)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_language=>'fr'
,p_message_text=>unistr('Fuseau horaire par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277746674396867567)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Fuseau horaire par d\00E9faut mis \00E0 jour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277768234396867581)
,p_name=>'CA.DEFAULTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Valeurs par d\00E9faut d''attribut d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277768522456867581)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Le document JSON permet d''exercer un contr\00F4le pr\00E9cis sur la g\00E9n\00E9ration des noms de colonne d''\00E9tat et de formulaire, des masques de format, etc. Vous pouvez \00E9galement d\00E9finir des listes de valeurs et d''autres composants partag\00E9s. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277785638080867592)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_language=>'fr'
,p_message_text=>'Attribut de liste de valeurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277785782127867592)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Ajoutez un attribut de liste de valeurs. Les listes de valeurs peuvent \00EAtre utilis\00E9es dans les d\00E9finitions de colonne de table.</p>'),
'<p>Indiquez les attributs suivants :',
'  <ul>',
'    <li><strong>Nom</strong> (obligatoire) : saisissez le nom de la liste de valeurs.</li>',
unistr('    <li><strong>Type</strong> : s\00E9lectionnez le type de la liste de valeurs [Structur\00E9e, Dynamique, Statique].<br>'),
unistr('      Pour le type <u>Structur\00E9e</u> : '),
'      <ul>',
unistr('          <li><strong>Table</strong> (obligatoire) : s\00E9lectionnez la table ou la vue sur laquelle fonder la liste de valeurs.</li>'),
unistr('          <li><strong>Colonne d''affichage</strong> (obligatoire) : s\00E9lectionnez la colonne \00E0 afficher pour les utilisateurs finals.</li>'),
unistr('          <li><strong>Colonne de cl\00E9</strong> (obligatoire) : s\00E9lectionnez la valeur de colonne \00E0 renvoyer. Il s''agit en g\00E9n\00E9ral de la cl\00E9 primaire de la table.</li>'),
'      </ul>',
'      &nbsp;<br>',
'      Pour le type <u>Dynamique</u> :',
'      <ul>',
unistr('          <li><strong>Requ\00EAte SQL</strong> (obligatoire) : saisissez une instruction SQL SELECT valide qui renvoie deux valeurs (valeur d''affichage et valeur renvoy\00E9e).</li>'),
'      </ul>',
'      &nbsp;<br>',
'      Pour le type <u>Statique</u> :',
'      <ul>',
'          <li><strong>Liste de valeurs statique</strong> (obligatoire) : entrez une liste statique valide du formulaire :',
'          <ul>',
unistr('            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>Liste affich\00E9e dans l''ordre saisi</li>'),
unistr('            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>Liste organis\00E9e par ordre alphab\00E9tique</li>'),
unistr('            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>La valeur d''affichage et la valeur renvoy\00E9e sont identiques</li>'),
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277786820906867593)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Attributs d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277786902454867593)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Modifiez les attributs pour tous les \00E9tats.</p>'),
'<p>Indiquez les attributs suivants :',
'  <ul>',
unistr('    <li><strong>Lignes par page</strong> : entrez le nombre de lignes d''\00E9tat \00E0 afficher par d\00E9faut.</li>'),
unistr('    <li><strong>M\00E9thode de pagination</strong> : s\00E9lectionnez le mode d''affichage de la pagination d''\00E9tat.</li>'),
unistr('    <li><strong>Masque de format num\00E9rique</strong> : entrez le masque de format \00E0 appliquer aux \00E9l\00E9ments et colonnes de nombres.</li>'),
unistr('    <li><strong>Masque de format de date</strong> : entrez le masque de format \00E0 appliquer aux \00E9l\00E9ments et colonnes de dates.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277786663990867593)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_language=>'fr'
,p_message_text=>'Attributs de table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277786449104867593)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Attributs de colonne de table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277786539585867593)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Modifiez les attributs de la colonne de table s\00E9lectionn\00E9e.</p>'),
'<p>Indiquez les attributs suivants :',
'  <ul>',
unistr('    <li><strong>Table</strong> (Afficher uniquement) : table associ\00E9e.</li>'),
unistr('    <li><strong>Colonne</strong> (Afficher uniquement) : colonne par rapport \00E0 laquelle les attributs sont d\00E9finis.</li>'),
unistr('    <li><strong>Libell\00E9</strong> : indiquez le libell\00E9 \00E0 utiliser dans les en-t\00EAtes de rapport et les libell\00E9s de formulaire.</li>'),
unistr('    <li><strong>Contr\00F4le de formulaire</strong> : s\00E9lectionnez un type d''\00E9l\00E9ment \00E0 utiliser dans les formulaires.</li>'),
unistr('    <li><strong>Liste de valeurs</strong> : s\00E9lectionnez une liste de valeurs existantes \00E0 utiliser pour afficher des noms conviviaux appropri\00E9s.</li>'),
unistr('    <li><strong>Masque de format</strong> : indiquez un masque de format appropri\00E9 en fonction du type de colonne (texte, nombre, date, etc.).</li>'),
unistr('    <li><strong>Valeur par d\00E9faut statique</strong> : indiquez une valeur par d\00E9faut de texte pour la colonne.</li>'),
unistr('    <li><strong>Inclure dans les formulaires</strong> : cliquez sur Oui si la colonne doit \00EAtre incluse dans des formulaires.</li>'),
unistr('    <li><strong>Inclure dans les \00E9tats</strong> : cliquez sur Oui si la colonne doit \00EAtre incluse dans des \00E9tats.</li>'),
unistr('    <li><strong>Obligatoire</strong> : cliquez sur Oui si les donn\00E9es doivent \00EAtre saisies dans cette colonne sur les formulaires.</li>'),
unistr('    <li><strong>Aide</strong> : saisissez le texte d''aide qui est ajout\00E9 \00E0 l''attribut d''aide de l''\00E9l\00E9ment.</li>'),
'  </ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277786715863867593)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Modifiez les attributs pour la table s\00E9lectionn\00E9e.</p>'),
'<p>Indiquez les attributs suivants :',
'  <ul>',
unistr('    <li><strong>Table</strong> (Afficher uniquement) : table associ\00E9e.</li>'),
unistr('    <li><strong>Libell\00E9, Singulier</strong> (obligatoire) : indiquez le libell\00E9 \00E0 utiliser dans les pages de formulaire.</li>'),
unistr('    <li><strong>Libell\00E9, Pluriel</strong> (obligatoire) : indiquez le libell\00E9 \00E0 utiliser dans les en-t\00EAtes de r\00E9gion et dans les noms de page.</li>'),
unistr('    <li><strong>Colonne d''affichage principale</strong> : s\00E9lectionnez la premi\00E8re colonne \00E0 afficher, dans les r\00E9gions de carte par exemple.</li>'),
unistr('    <li><strong>Colonne d''affichage secondaire</strong> : s\00E9lectionnez la deuxi\00E8me colonne \00E0 afficher, dans les r\00E9gions de carte par exemple.</li>'),
unistr('    <li><strong>Colonne de cl\00E9 primaire</strong> : s\00E9lectionnez la colonne de cl\00E9 primaire unique pour la table.</li>'),
'    <li><strong>Description</strong> : saisissez la description de la table.</li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276865995572866997)
,p_name=>'CA.DEFERRED.DROP'
,p_message_language=>'fr'
,p_message_text=>unistr('Suppression diff\00E9r\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277780912948867589)
,p_name=>'CA.DEFINITION'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finition')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277763593102867578)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sinstallation termin\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277743859033867565)
,p_name=>'CA.DELETE'
,p_message_language=>'fr'
,p_message_text=>'Supprimer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277763197629867578)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_language=>'fr'
,p_message_text=>'Voulez-vous effectuer cette action de suppression ?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277729405685867556)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_language=>'fr'
,p_message_text=>'Voulez-vous supprimer cette page ?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277753638001867571)
,p_name=>'CA.DELETE.PHOTO'
,p_message_language=>'fr'
,p_message_text=>'Supprimer la photo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277744563945867566)
,p_name=>'CA.DESCRIPTION'
,p_message_language=>'fr'
,p_message_text=>'Description'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277761749595867577)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_language=>'fr'
,p_message_text=>'Barre de navigation du bureau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277761690378867577)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_language=>'fr'
,p_message_text=>'Menu de navigation du bureau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277742833113867564)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Style de th\00E8me du bureau')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277742942146867565)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Le style de th\00E8me par d\00E9faut s''applique \00E0 tous les utilisateurs.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276866331934866997)
,p_name=>'CA.DESTINATION'
,p_message_language=>'fr'
,p_message_text=>'Destination'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276866456631866997)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire de destination')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276633361271866849)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Boutons de bo\00EEte de dialogue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277758122695867574)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9partir les courriels')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277777770261867587)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9termine si les courriels doivent \00EAtre envoy\00E9s \00E0 partir de la structure de courriel.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277744364667867565)
,p_name=>'CA.DISPLAY.FROM'
,p_message_language=>'fr'
,p_message_text=>unistr('Afficher \00E0 partir du')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277744256084867565)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9quence d''affichage')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277744492472867565)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_language=>'fr'
,p_message_text=>'Afficher jusqu''au'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277779496571867588)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne d''affichage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277747957865867568)
,p_name=>'CA.DISTINCT .USERS'
,p_message_language=>'fr'
,p_message_text=>'Utilisateurs distincts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277761298859867576)
,p_name=>'CA.DOWNLOAD'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9charger en local')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277768104156867581)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_language=>'fr'
,p_message_text=>unistr('Faire glisser pour r\00E9organiser la page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276654623096866862)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr('  <li><strong>Lien d''analyse descendante</strong> : d\00E9veloppez pour voir les attributs permettant de d\00E9finir un lien d''analyse descendante.'),
'&nbsp;<br>',
unistr('    <em><strong>Remarque :</strong> un lien d''analyse descendante appara\00EEt uniquement si la page actuelle est bas\00E9e sur une table ou une vue, si son type d''\00E9tat est Etat interactif, et si vous avez d\00E9fini un \00E9tat (Etat interactif) ou une page ma\00EEtre ')
||unistr('d\00E9tails (Ma\00EEtre-d\00E9tails).</em>'),
'  <ul>',
unistr('    <li><strong>Colonne de lien</strong> : s\00E9lectionnez la colonne \00E0 remplacer par une colonne de lien dans l''\00E9tat.</li>'),
unistr('    <li><strong>Cl\00E9 de lien</strong> : s\00E9lectionnez la colonne de cl\00E9 de lien (cl\00E9 \00E9trang\00E8re) utilis\00E9e pour identifier l''enregistrement sp\00E9cifique dans la page \00E0 laquelle il est li\00E9.</li>'),
unistr('    <li><strong>Lien vers la page</strong> : s\00E9lectionnez l''\00E9tat ou la page de panneau vers laquelle le lien pointe.</li>'),
unistr('    <li><strong>Cl\00E9 cible</strong> : s\00E9lectionnez la colonne de cl\00E9 cible (cl\00E9 primaire) dans la table sur laquelle repose la page d''\00E9tat, vers laquelle le lien pointe.'),
'  </ul>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277747087593867567)
,p_name=>'CA.ELAPSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Ecoul\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277729618246867556)
,p_name=>'CA.EMAIL'
,p_message_language=>'fr'
,p_message_text=>'Structure de courriel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277777320545867587)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_language=>'fr'
,p_message_text=>unistr('Adresses \00E9lectroniques')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277787312663867593)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_language=>'fr'
,p_message_text=>unistr('Valeur par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277729529427867556)
,p_name=>'CA.EMAIL.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajouter la possibilit\00E9 de configurer et d''envoyer des courriels')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277729790449867556)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Incluez la possibilit\00E9 d''envoyer des courriels \00E0 partir de votre application. Gr\00E2ce au mod\00E8le de courriel, envoyez des courriels professionnels aux utilisateurs. Les courriels envoy\00E9s sont consign\00E9s de mani\00E8re \00E0 ce que les administrateurs puissent')
||unistr(' suivre l''activit\00E9 de messagerie.</p>'),
'<p>Comprend les composants suivants :',
'<ul>',
unistr('<li>Syst\00E8me de mod\00E8les de courriel HTML extensible</li>'),
'<li>Package PL/SQL pour l''envoi de courriels via des packages APEX</li>',
unistr('<li>Journalisation de l''activit\00E9 et des statuts des courriels</li>'),
unistr('<li>Interface utilisateur d''administration permettant de g\00E9rer les mod\00E8les</li>'),
'<li>Interface utilisateur d''administration permettant d''afficher les journaux de courriels</li>',
'<li>Interface utilisateur d''administration permettant d''envoyer des courriels</li>',
'</ul>',
'</p>',
unistr('<p><em>Remarque : cette fonctionnalit\00E9 est activ\00E9e en cas de s\00E9lection de l''option Informations en retour</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277783074070867591)
,p_name=>'CA.EMAIL.FROM'
,p_message_language=>'fr'
,p_message_text=>unistr('Exp\00E9diteur du courriel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277757182529867574)
,p_name=>'CA.EMAIL.LOG'
,p_message_language=>'fr'
,p_message_text=>'Journal de courriels'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277787900079867594)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9tails de param\00E8tre de messagerie obligatoires.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277787404441867593)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_language=>'fr'
,p_message_text=>unistr('L''adresse d''exp\00E9diteur n''est pas une adresse valide.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277778928180867588)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_language=>'fr'
,p_message_text=>unistr('L''adresse d''exp\00E9diteur n''est pas une adresse valide.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277778144886867587)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Courriel trait\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276733305219866912)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_language=>'fr'
,p_message_text=>unistr('G\00E9n\00E9ration d''\00E9tats de courriel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276919122890867031)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat de tous les courriels mis en file d''attente d''envoi et de ceux d\00E9j\00E0 envoy\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277758005657867574)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de messagerie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277758430253867575)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de messagerie mis \00E0 jour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277783479332867591)
,p_name=>'CA.EMAIL.STATUS'
,p_message_language=>'fr'
,p_message_text=>'Statut de courriel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277758553161867575)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9tails du mod\00E8le de courriel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277270267986867259)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_language=>'fr'
,p_message_text=>unistr('Coupure programm\00E9e pour #SERVICE_NAME#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276971677133867064)
,p_name=>'CA.EMAIL2'
,p_message_language=>'fr'
,p_message_text=>unistr('Adresse \00E9lectronique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277757019627867574)
,p_name=>'CA.EMAILS.SENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Courriels envoy\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277787576714867594)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer les pi\00E8ces jointes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276871412123867000)
,p_name=>'CA.ENABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('Activ\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276868671620866999)
,p_name=>'CA.END.DATE'
,p_message_language=>'fr'
,p_message_text=>'Date de fin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277759194527867575)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Apr\00E8s lignes - Contenu')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277775273714867586)
,p_name=>'CA.ENTER.USERNAME'
,p_message_language=>'fr'
,p_message_text=>'Saisir les noms utilisateur ici'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277747628745867568)
,p_name=>'CA.ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277749948763867569)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_language=>'fr'
,p_message_text=>'Trace des erreurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277749832906867569)
,p_name=>'CA.ERROR.CODE'
,p_message_language=>'fr'
,p_message_text=>'Code d''erreur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277749139386867569)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_language=>'fr'
,p_message_text=>'Message d''erreur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276873192692867001)
,p_name=>'CA.ERROR.NUMBER'
,p_message_language=>'fr'
,p_message_text=>unistr('Num\00E9ro d''erreur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276872197817867001)
,p_name=>'CA.ERRORS'
,p_message_language=>'fr'
,p_message_text=>'Erreurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276869035552866999)
,p_name=>'CA.EVENT.CONDITION'
,p_message_language=>'fr'
,p_message_text=>unistr('Condition d''\00E9v\00E9nement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276869180582866999)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Agent de la file d''attente des \00E9v\00E9nements')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276869271502866999)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de la file d''attente des \00E9v\00E9nements')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276869313868866999)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire de la file d''attente des \00E9v\00E9nements')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276868963368866999)
,p_name=>'CA.EVENT.RULE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E8gle d''\00E9v\00E9nement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277775510394867586)
,p_name=>'CA.EXCEPTIONS'
,p_message_language=>'fr'
,p_message_text=>'Exceptions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277788422965867594)
,p_name=>'CA.EXPERIENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('Exp\00E9rience')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276871162234867000)
,p_name=>'CA.FAILURE.COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Nombre d''\00E9checs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277745641339867566)
,p_name=>'CA.FEATURE'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctionnalit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277525688304867425)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_language=>'fr'
,p_message_text=>'Version de l''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277525725918867425)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_language=>'fr'
,p_message_text=>'Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277017651940867094)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajouter des utilisateurs \00E0 la liste de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277017473943867094)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9der \00E0 l''\00E9tape suivante')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277017539229867094)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er des collections')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277017386755867094)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_language=>'fr'
,p_message_text=>'Impossible de modifier le dernier administrateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277525357577867425)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_language=>'fr'
,p_message_text=>unistr('Derni\00E8re activit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277017167079867094)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune activit\00E9 n''a \00E9t\00E9 trouv\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277525506426867425)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_language=>'fr'
,p_message_text=>'Raison'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277017712295867094)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('Au moins une information en retour doit \00EAtre indiqu\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277018062325867094)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_language=>'fr'
,p_message_text=>'Obtenir l''ID de fichier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277016643622867093)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrer le style de th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277016735074867093)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrer la pr\00E9f\00E9rence de style de l''utilisateur final')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277525486029867425)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_language=>'fr'
,p_message_text=>'Nom utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277733801894867559)
,p_name=>'CA.FEATURES'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctionnalit\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277733992486867559)
,p_name=>'CA.FEATURES.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Les fonctionnalit\00E9s s''appliquent au niveau de l''application et sont g\00E9n\00E9ralement ajout\00E9es une fois par application. Choisissez les fonctionnalit\00E9s \00E0 inclure avec votre application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277727707262867555)
,p_name=>'CA.FEEDBACK'
,p_message_language=>'fr'
,p_message_text=>'Informations en retour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277725701132867553)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Autoriser les utilisateurs \00E0 fournir des commentaires')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277727687934867555)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Fournir un m\00E9canisme permettant aux utilisateurs finals de publier des commentaires g\00E9n\00E9raux \00E0 l''attention des administrateurs et des d\00E9veloppeurs de l''application. Ces publications comportent des informations utiles relatives \00E0 l''\00E9tat de session ')
||unistr('permettant de d\00E9terminer la provenance des informations en retour de l''utilisateur final. L''existence d''une boucle d''informations en retour aussi simple favorise la communication entre la communaut\00E9 d''utilisateurs et les propri\00E9taires de l''applicatio')
||unistr('n, ce qui entra\00EEne une am\00E9lioration significative de la satisfaction de l''utilisateur final.</p>'),
'<p>Comprend les composants suivants :',
'<ul>',
unistr('<li>Possibilit\00E9 pour les utilisateurs finals de donner leur avis en cliquant sur une ic\00F4ne dans la barre de navigation</li>'),
unistr('<li>Etat administratif relatif \00E0 l''affichage et \00E0 la mise \00E0 jour des informations en retour</li>'),
'<li>Les informations en retour indiqueront l''utilisateur, la date et l''heure ainsi que les informations sur l''agent utilisateur</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277788885134867594)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('Fournissez des informations en retour sur votre exp\00E9rience.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277787843863867594)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Envoyer \00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277787288136867593)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres d''informations en retour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277755170563867572)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres d''informations en retour mis \00E0 jour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277788013087867594)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_language=>'fr'
,p_message_text=>'Informations en retour soumises'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276868742543866999)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de contr\00F4leur de fichier')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276868877310866999)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire du contr\00F4leur de fichier')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276523993535866778)
,p_name=>'CA.FILED'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistr\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276524015721866778)
,p_name=>'CA.FILED.BY'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistr\00E9 par')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277783554598867591)
,p_name=>'CA.FILTER.REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Filtrer l''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277759534109867575)
,p_name=>'CA.FILTERS'
,p_message_language=>'fr'
,p_message_text=>'Filtres'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277786297203867593)
,p_name=>'CA.FINISH'
,p_message_language=>'fr'
,p_message_text=>'Fin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277753869144867572)
,p_name=>'CA.FIRST.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9nom')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276865718522866997)
,p_name=>'CA.FLAGS'
,p_message_language=>'fr'
,p_message_text=>'Indicateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277735242862867560)
,p_name=>'CA.FORM'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une page de formulaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277735115806867560)
,p_name=>'CA.FORM.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une page qui affiche une page de formulaire permettant aux utilisateurs finals de tenir les donn\00E9es \00E0 jour.</p>'),
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de page</strong> (obligatoire) : saisissez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
unistr('  <li><strong>Table</strong> (obligatoire) : s\00E9lectionnez la table du formulaire.</li>'),
unistr('<li><strong>Inclure l''\00E9tat</strong> (obligatoire) : s\00E9lectionnez cette option pour cr\00E9er un \00E9tat et un panneau. La premi\00E8re page est un \00E9tat interactif. Chaque ligne contient un lien vers un panneau dans lequel les utilisateurs peuvent mettre \00E0 jour ')
||'l''enregistrement. </li>',
'  &nbsp;<br>',
unistr('<li><strong>Avanc\00E9</strong> : d\00E9veloppez pour voir les options avanc\00E9es.'),
'     <ul>',
unistr('      <li><strong>Aide de la page</strong> : saisissez le texte \00E0 ajouter au texte d''aide de la page.</li>'),
'      </ul>',
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276653653563866862)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gion d''\00E9l\00E9ment de panneau')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277761416592867576)
,p_name=>'CA.FORM.ON'
,p_message_language=>'fr'
,p_message_text=>'Panneau sur %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277775093671867585)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_language=>'fr'
,p_message_text=>'Le type de formulaire n''est pas un type valide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277781492676867590)
,p_name=>'CA.FORMATMASK'
,p_message_language=>'fr'
,p_message_text=>'Masque de format'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277780489569867589)
,p_name=>'CA.FORMCONTROL'
,p_message_language=>'fr'
,p_message_text=>unistr('Contr\00F4le de panneau')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277745074305867566)
,p_name=>'CA.FROM'
,p_message_language=>'fr'
,p_message_text=>'De'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277758208360867574)
,p_name=>'CA.FROM.ADDRESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Adresse de l''exp\00E9diteur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277782931610867591)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tre de messagerie "Adresse d''exp\00E9diteur"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277778862441867588)
,p_name=>'CA.FROM.EMAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Adresse \00E9lectronique de l''exp\00E9diteur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277778769012867588)
,p_name=>'CA.FROM.WHO'
,p_message_language=>'fr'
,p_message_text=>unistr('Exp\00E9diteur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277527535370867426)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_language=>'fr'
,p_message_text=>'%0 - Recherche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277748505448867568)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_language=>'fr'
,p_message_text=>unistr('Vues de page compl\00E8te')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277757229846867574)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_language=>'fr'
,p_message_text=>unistr('HTML de mod\00E8le complet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277779964691867589)
,p_name=>'CA.FUNCTION'
,p_message_language=>'fr'
,p_message_text=>'Fonction'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277728125498867555)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_language=>'fr'
,p_message_text=>'Recherche globale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277725941161867554)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_language=>'fr'
,p_message_text=>'Fournir une fonction de recherche dans l''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277728061708867555)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Autoriser les utilisateurs finals \00E0 rechercher du texte dans des tables ou des vues cl\00E9s dans l''application. La page de recherche avanc\00E9e inclut des filtres permettant aux utilisateurs finals d''affiner les r\00E9sultats plus facilement.<br>'),
unistr('Cette fonctionnalit\00E9 tr\00E8s puissante n\00E9cessite un effort de d\00E9veloppement afin de d\00E9finir le texte SQL (selon les exemples fournis).</p>'),
'<p>Comprend les composants suivants :',
'<ul>',
unistr('<li>Affiche une ic\00F4ne de recherche dans la barre d''en-t\00EAte</li>'),
unistr('<li>Inclut une page de r\00E9sultats de recherche d\00E9taill\00E9e comportant un filtre dans la barre lat\00E9rale</li>'),
unistr('<li>N\00E9cessite l''impl\00E9mentation de SQL par un d\00E9veloppeur pour d\00E9finir la recherche de l''application</li>'),
unistr('<li>Inclut des donn\00E9es \00E9chantillon pour l''illustration</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276870427400867000)
,p_name=>'CA.GLOBAL.UID'
,p_message_language=>'fr'
,p_message_text=>'ID unique global'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277016264331867093)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_language=>'fr'
,p_message_text=>'Page globale - Bureau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276633411478866849)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9der \00E0 la page d''administration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277734794512867559)
,p_name=>'CA.GRID'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une page de grille interactive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277734890589867559)
,p_name=>'CA.GRID.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une page qui s''affiche sous forme de grille interactive semblable \00E0 une feuille de calcul. Si elle peut \00EAtre modifi\00E9e, les utilisateurs peuvent modifier plusieurs lignes directement sur la page (c''est-\00E0-dire, lorsque l''option Autoriser la mo')
||unistr('dification est activ\00E9e).</p>'),
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de la page</strong> (obligatoire) : indiquez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
unistr('  <li><strong>Type de requ\00EAte</strong> : s\00E9lectionnez la source de l''\00E9tat [<strong>Table ou vue</strong> ou <strong>Requ\00EAte SQL</strong>].<br>'),
'    <strong>Table ou vue</strong> :',
'    <ul>',
unistr('      <li><strong>Table ou vue</strong> (obligatoire) : s\00E9lectionnez l''objet de base de donn\00E9es de la grille.</li>'),
'    </ul>',
unistr('    <strong>Requ\00EAte SQL</strong> :'),
'    <ul>',
unistr('      <li><strong>Requ\00EAte SQL</strong> (obligatoire) : entrez une instruction SQL valide qui renvoie des colonnes distinctes.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>Type de grille</strong> : indiquez si les utilisateurs finals sont autoris\00E9s \00E0 modifier les lignes dans la grille [<strong>Autoriser la modification</strong> ou <strong>Lecture seule</strong>]. Pour autoriser la modification, s\00E9lectionn')
||'ez <strong>Autoriser la modification</strong>.</li>',
'  &nbsp;<br>',
unistr('  <em><strong>Avertissement :</strong> si vous s\00E9lectionnez le type de requ\00EAte <strong>Requ\00EAte SQL</strong> et le type de grille <strong>Autoriser la modification</strong>, et que votre requ\00EAte associe au moins deux tables, la grille interactive g\00E9n\00E9')
||unistr('r\00E9e \00E9chouera lorsque les utilisateurs tenteront de mettre \00E0 jour les enregistrements.'),
unistr('Par ailleurs, si vous s\00E9lectionnez le type de grille <strong>Autoriser la modification</strong> et que la requ\00EAte (ou la table ou vue s\00E9lectionn\00E9e) utilise une vue qui ne peut pas \00EAtre mise \00E0 jour, la grille interactive g\00E9n\00E9r\00E9e \00E9chouera lorsque les u')
||unistr('tilisateurs tenteront de mettre \00E0 jour les enregistrements.</em><br>'),
'  </li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277760030875867576)
,p_name=>'CA.HELP'
,p_message_language=>'fr'
,p_message_text=>'Aide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277752456998867571)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionnez <strong>Non</strong> si tous les utilisateurs sont d\00E9finis dans la liste de contr\00F4le d''acc\00E8s. S\00E9lectionnez <strong>Oui</strong> si les utilisateurs authentifi\00E9s ne figurant pas dans la liste de contr\00F4le d''acc\00E8s peuvent \00E9galement utiliser')
||' cette application.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277746104870867567)
,p_name=>'CA.HELP.APP.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Le texte entr\00E9 ici est utilis\00E9 dans l''ensemble de l''application, plus particuli\00E8rement, dans l''angle sup\00E9rieur gauche de chaque page. La modification prendra effet imm\00E9diatement pour l''administrateur qui l''applique, mais elle ne sera visible par les ')
||unistr('autres utilisateurs que lors de la prochaine session (c''est-\00E0-dire lors de leur prochaine connexion).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277740771673867563)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Cliquez sur l''ic\00F4ne des informations en retour ( <span class="fa fa-comment-o" aria-hidden="true"></span>) dans la barre de navigation, \00E0 partir de n''importe quelle page de l''application, afin de transmettre des informations en retour aux administ')
||'rateurs de l''application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277740496047867563)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Il s''agit de la page d''accueil de l''application. Cliquez sur les cartes pour acc\00E9der aux diff\00E9rentes pages de l''application, ou utilisez le menu de navigation sur le c\00F4t\00E9 de la page.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277740689376867563)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Il s''agit de la page d''accueil de l''application. Cliquez sur les cartes pour acc\00E9der aux diff\00E9rentes pages de l''application, ou utilisez le menu de navigation en haut de la page.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277740885515867563)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Entrez un terme de recherche dans le champ <strong>Application de recherche</strong> sur cette page, ou cliquez sur l''ic\00F4ne de recherche (<span class="fa fa-search" aria-hidden="true"></span>) dans la barre de navigation \00E0 partir de n''importe quel')
||'le page pour rechercher le terme dans votre application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277741176356867563)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Cliquez sur la liste d\00E9roulante de votre nom dans la barre de navigation pour vous d\00E9connecter de l''application.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277741032607867563)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Cliquez sur le menu utilisateur (<span class="fa fa-user" aria-hidden="true"></span>) dans la barre de navigation pour mettre \00E0 jour votre pr\00E9f\00E9rence de fuseau horaire et vous d\00E9connecter de l''application.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277740533520867563)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_language=>'fr'
,p_message_text=>'Page d''accueil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277741286840867563)
,p_name=>'CA.HELP.HOME.USER'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cliquez sur le menu utilisateur (<span class="fa fa-user" aria-hidden="true"></span>) dans la barre de navigation (en haut \00E0 droite de la page) pour acc\00E9der \00E0 votre profil utilisateur et vous d\00E9connecter de l''application.<br>'),
unistr('Si vous cliquez sur <strong>Afficher mon profil</strong>, vous pouvez ensuite cliquer sur <strong>Mettre \00E0 jour le profil</strong> pour entrer vos d\00E9tails personnels et t\00E9l\00E9charger une photo ou un avatar.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277740944579867563)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cliquez sur le menu utilisateur (<span class="fa fa-user" aria-hidden="true"></span>) dans la barre de navigation pour acc\00E9der \00E0 votre profil utilisateur, mettre \00E0 jour votre pr\00E9f\00E9rence de fuseau horaire et vous d\00E9connecter de l''application.<br>'),
unistr('Si vous cliquez sur <strong>Afficher mon profil</strong>, vous pouvez ensuite cliquer sur <strong>Mettre \00E0 jour le profil</strong> pour entrer vos d\00E9tails personnels et t\00E9l\00E9charger une photo ou un avatar.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277767082334867580)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Pour rechercher des donn\00E9es, entrez un terme de recherche dans la bo\00EEte de dialogue de recherche, ou cliquez sur les en-t\00EAtes de colonne pour limiter les enregistrements renvoy\00E9s.</p>'),
'',
unistr('<p>Vous pouvez ex\00E9cuter de nombreuses fonctions en cliquant sur le bouton <strong>Actions</strong>. Ainsi, vous pouvez s\00E9lectionner les colonnes \00E0 afficher/masquer et leur ordre d''affichage, mais aussi de nombreuses fonctions relatives aux donn\00E9es et')
||unistr(' aux formats. Vous pouvez \00E9galement d\00E9finir des vues de donn\00E9es suppl\00E9mentaires \00E0 l''aide de l''option de graphique.</p>'),
'',
unistr('<p>Pour enregistrer vos personnalisations, s\00E9lectionnez l''\00E9tat ou cliquez sur le bouton de t\00E9l\00E9chargement pour d\00E9charger les donn\00E9es.<p>'),
'<br>',
'<p>Pour plus d''informations, cliquez sur Aide au bas du menu Actions.</p>',
'',
unistr('<p>Pour r\00E9tablir les param\00E8tres par d\00E9faut de l''\00E9tat interactif, cliquez sur le bouton <strong>R\00E9initialiser</strong>.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277766925661867580)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Vous pouvez ins\00E9rer, mettre \00E0 jour et supprimer des donn\00E9es directement dans cette grille interactive.<br>'),
unistr('  Ins\00E9rez une nouvelle ligne en cliquant sur le bouton Ajouter une ligne.<br>'),
unistr('  Cliquez deux fois dans une cellule, ou cliquez sur le bouton <strong>Modifier</strong> pour mettre \00E0 jour les valeurs de donn\00E9es, comme lorsque vous modifiez des donn\00E9es dans une feuille de calcul.</p>'),
'',
unistr('<p>Utilisez le menu Actions de ligne ( <span class="fa fa-bars" aria-hidden="true"></span> ) en haut de l''\00E9tat pour dupliquer, supprimer, actualiser ou r\00E9tablir les lignes s\00E9lectionn\00E9es.<br> '),
unistr('  Utilisez le menu Actions de ligne sur les lignes individuelles pour acc\00E9der \00E9galement \00E0 la vue monoligne ou pour ajouter une nouvelle ligne.</p>'),
'',
unistr('<p>Pour rechercher des donn\00E9es, entrez un terme de recherche dans la bo\00EEte de dialogue de recherche, ou cliquez sur les en-t\00EAtes de colonne pour limiter les enregistrements renvoy\00E9s.</p>'),
'',
unistr('<p>Vous pouvez ex\00E9cuter de nombreuses fonctions en cliquant sur le bouton <strong>Actions</strong>. Ainsi, vous pouvez s\00E9lectionner les colonnes \00E0 afficher/masquer et leur ordre d''affichage, mais aussi de nombreuses fonctions relatives aux donn\00E9es et')
||unistr(' aux formats. Vous pouvez \00E9galement d\00E9finir une vue suppl\00E9mentaire des donn\00E9es \00E0 l''aide de l''option de graphique.</p>'),
'',
unistr('<p>Pour enregistrer vos personnalisations, s\00E9lectionnez l''\00E9tat, ou cliquez sur le bouton de t\00E9l\00E9chargement pour d\00E9charger les donn\00E9es.<p>'),
'',
'<p>Pour plus d''informations, cliquez sur Aide au bas du menu Actions.</p> ',
'',
unistr('<p>Pour r\00E9tablir les param\00E8tres par d\00E9faut de l''\00E9tat interactif, cliquez sur le bouton <strong>R\00E9initialiser</strong>.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277740304899867563)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Pour rechercher des donn\00E9es, entrez un terme de recherche dans la bo\00EEte de dialogue de recherche, ou cliquez sur les en-t\00EAtes de colonne pour limiter les enregistrements renvoy\00E9s.</p>'),
'',
unistr('<p>Vous pouvez ex\00E9cuter de nombreuses fonctions en cliquant sur le bouton <strong>Actions</strong>. Ainsi, vous pouvez s\00E9lectionner les colonnes \00E0 afficher/masquer et leur s\00E9quence d''affichage, mais aussi de nombreuses fonctions relatives aux donn\00E9es')
||unistr(' et aux formats. Vous pouvez \00E9galement d\00E9finir des vues de donn\00E9es suppl\00E9mentaires \00E0 l''aide des options Graphique, Grouper par et Permuter.</p>'),
'',
unistr('<p>Pour enregistrer vos personnalisations, s\00E9lectionnez l''\00E9tat ou cliquez sur le bouton de t\00E9l\00E9chargement pour d\00E9charger les donn\00E9es. Entrez votre adresse \00E9lectronique et l''intervalle de temps dans l''abonnement selon lequel envoyer les donn\00E9es r\00E9guli')
||unistr('\00E8rement.<p>'),
'',
'<p>Pour plus d''informations, cliquez sur Aide au bas du menu Actions.</p>',
'',
unistr('<p>Pour r\00E9tablir les param\00E8tres par d\00E9faut de l''\00E9tat interactif, cliquez sur le bouton <strong>R\00E9initialiser</strong>.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277776084212867586)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>La page d''\00E9tat affiche les enregistrements principaux dans un s\00E9lecteur sur le c\00F4t\00E9 de la page. '),
unistr('  S\00E9lectionnez un enregistrement pour voir l''enregistrement ma\00EEtre et les enregistrements d\00E9tails d\00E9finis.<br> '),
unistr('  Cliquez sur l''ic\00F4ne de modification (<span class="fa fa-pencil-square-o" aria-hidden="true"></span>) pour modifier l''enregistrement ma\00EEtre.'),
unistr('  Pour les enregistrements d\00E9tails, cliquez sur l''ic\00F4ne en forme de crayon, au d\00E9but de chaque ligne, pour les modifier.</p>'),
unistr('<p>Pour limiter les donn\00E9es affich\00E9es dans le s\00E9lecteur, saisissez un terme de recherche dans la bo\00EEte de dialogue de recherche.</p>'),
'',
unistr('<p>Pour ajouter un nouvel enregistrement ma\00EEtre, cliquez sur <strong>Cr\00E9er</strong> en haut de la page.'),
unistr('  Pour les enregistrements d\00E9tails, cliquez sur l''ic\00F4ne plus (+) situ\00E9e en haut de la r\00E9gion de d\00E9tails pour ajouter un enregistrement d\00E9tails.</p>'),
'',
unistr('<p>Cliquez sur <strong>R\00E9initialiser</strong> en haut de la page pour r\00E9tablir les param\00E8tres par d\00E9faut de la page, en enlevant tous les termes de recherche pr\00E9c\00E9demment d\00E9finis.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277738320125867562)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>La page d''administration permet aux propri\00E9taires de l''application (administrateurs) de configurer l''application et de tenir \00E0 jour les donn\00E9es communes qu''elle utilise.'),
unistr('En s\00E9lectionnant l''un des param\00E8tres disponibles, les administrateurs peuvent potentiellement modifier l''affichage de l''application et/ou les fonctions disponibles pour les utilisateurs finals.</p>'),
unistr('<p>L''acc\00E8s \00E0 cette page doit \00EAtre exclusivement limit\00E9 aux administrateurs.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277739565342867562)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>S\00E9lectionnez l''option appropri\00E9e pour tous les utilisateurs authentifi\00E9s.<br>'),
unistr('Si vous s\00E9lectionnez <strong>Non</strong>, l''application sera plus s\00E9curis\00E9e, car seuls les utilisateurs sp\00E9cifi\00E9s peuvent y acc\00E9der.'),
unistr('Toutefois, si votre application compte de nombreux utilisateurs, tenir \00E0 jour les utilisateurs peut s''av\00E9rer complexe, et vous pr\00E9f\00E9rerez peut-\00EAtre choisir <strong>Oui</strong> et entrer uniquement des administrateurs d''application, et \00E9ventuellement')
||' des contributeurs.<br>',
unistr('Si vous s\00E9lectionnez <strong>Oui</strong>, vous devez \00E9galement indiquer le mode de traitement des utilisateurs qui ne figurent pas sur la liste des utilisateurs.</p>'),
unistr('<p>Indiquez si une adresse \00E9lectronique ou une valeur alphanum\00E9rique est requise pour les noms utilisateur.<br>'),
unistr('G\00E9n\00E9ralement, vous devrez d\00E9finir ce param\00E8tre sur <strong>Adresse \00E9lectronique</strong> si votre application utilise (ou sera configur\00E9e pour utiliser) un mod\00E8le d''authentification centralis\00E9 tel qu''Oracle Access Manager ou l''acc\00E8s avec connexion un')
||'ique.</p>',
unistr('<p><em><strong>Remarque :</strong> cette application prend en charge les 3 niveaux d''acc\00E8s suivants : Lecteur, Contributeur et Administrateur.'),
'<ul>',
unistr('  <li>Les <strong>lecteurs</strong> disposent d''un acc\00E8s en lecture seule \00E0 toutes les informations et peuvent \00E9galement consulter les \00E9tats.</li>'),
unistr('  <li>Les <strong>contributeurs</strong> peuvent cr\00E9er, modifier et supprimer des informations et consulter les \00E9tats.</li>'),
unistr('  <li>Les <strong>administrateurs</strong>, outre les capacit\00E9s des contributeurs, peuvent \00E9galement ex\00E9cuter la configuration de l''application en acc\00E9dant \00E0 sa section Administration.</li>'),
'</ul>',
'</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277739789236867563)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez ce formulaire pour entrer des utilisateurs et leur adresse \00E9lectronique, et d\00E9finir leur niveau d''acc\00E8s.'),
unistr('Les param\00E8tres d\00E9finis dans <em>Configurer le contr\00F4le d''acc\00E8s</em> d\00E9termineront si le nom utilisateur doit \00EAtre leur adresse \00E9lectronique ou s''il peut s''agir de n''importe quelle entr\00E9e alphanum\00E9rique.</p>'),
unistr('<p>Cette application prend en charge les 3 niveaux d''acc\00E8s suivants : Lecteur, Contributeur et Administrateur.</p>'),
'<ul>',
unistr('  <li>Les <strong>lecteurs</strong> disposent d''un acc\00E8s en lecture seule \00E0 toutes les informations et peuvent \00E9galement consulter les \00E9tats.</li>'),
unistr('  <li>Les <strong>contributeurs</strong> peuvent cr\00E9er, modifier et supprimer des informations et consulter les \00E9tats.</li>'),
unistr('  <li>Les <strong>administrateurs</strong>, outre les capacit\00E9s des contributeurs, peuvent \00E9galement ex\00E9cuter la configuration de l''application en acc\00E9dant \00E0 sa section Administration.</li>'),
'</ul>',
unistr('<p>Lorsque vous modifiez un utilisateur existant, vous pouvez verrouiller son compte, ce qui l''emp\00EAchera d''acc\00E9der \00E0 l''application.</p>'),
unistr('<p><em><strong>Remarque :</strong>   si vous utilisez des comptes Oracle Application Express, les utilisateurs entr\00E9s ici doivent \00E9galement \00EAtre d\00E9finis en tant qu''utilisateurs finals par un administrateur d''espace de travail, qui peut aussi d\00E9finir ')
||'leur mot de passe.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277739690965867562)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cette page fournit un \00E9tat des utilisateurs de l''application et du niveau d''acc\00E8s octroy\00E9.</p>'),
unistr('<p>Pour trier et filtrer les donn\00E9es, cliquez sur les en-t\00EAtes de colonne, ou cliquez sur le bouton <strong>Actions</strong> pour personnaliser l''affichage des colonnes et de nombreuses fonctionnalit\00E9s avanc\00E9es suppl\00E9mentaires.<br>'),
unistr('Pour r\00E9tablir les param\00E8tres par d\00E9faut de l''\00E9tat interactif, cliquez sur le bouton <strong>R\00E9initialiser</strong>.</p>'),
unistr('<p>Cliquez sur l''ic\00F4ne de modification (crayon jaune) pour modifier les d\00E9tails et le niveau d''acc\00E8s de l''utilisateur, ou pour supprimer ce dernier.</p>'),
unistr('<p>Pour ajouter un nouvel utilisateur et son niveau d''acc\00E8s, cliquez sur <strong>Ajouter un utilisateur</strong>, en haut de l''\00E9tat.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277753163341867571)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Lorsque le contr\00F4le d''acc\00E8s est activ\00E9, les administrateurs ont la possibilit\00E9 de restreindre l''acc\00E8s \00E0 certaines fonctionnalit\00E9s d''application pour les utilisateurs authentifi\00E9s. Cette application prend en charge les 3 r\00F4les suivants : Lecteur, C')
||'ontributeur et Administrateur.<p>',
'<ul>',
unistr('  <li>Les <strong>lecteurs</strong> disposent d''un acc\00E8s en lecture seule \00E0 toutes les informations et peuvent \00E9galement consulter les \00E9tats.</li>'),
unistr('  <li>Les <strong>contributeurs</strong> peuvent cr\00E9er, modifier et supprimer des informations et consulter les \00E9tats.</li>'),
unistr('  <li>Les <strong>administrateurs</strong>, outre les capacit\00E9s des contributeurs, peuvent \00E9galement ex\00E9cuter la configuration de l''application.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277775163102867585)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_language=>'fr'
,p_message_text=>unistr('Saisissez des noms utilisateur s\00E9par\00E9s par des virgules, des points-virgules ou des caract\00E8res non imprimables. Les noms utilisateurs existants ou en double sont automatiquement ignor\00E9s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277738561394867562)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Les param\00E8tres de configuration vous permettent de rendre des fonctionnalit\00E9s sp\00E9cifiques disponibles (activ\00E9es) ou indisponibles (d\00E9sactiv\00E9es) pour les utilisateurs finals.</p>'),
unistr('<p>Si une fonction sp\00E9cifique n''est pas int\00E9gralement pr\00EAte ou n\00E9cessite d''\00EAtre enlev\00E9e temporairement, cliquez sur <strong>D\00E9sactiv\00E9</strong>.'),
unistr('Une fois qu''elle doit \00EAtre rendue disponible, cliquez simplement sur <strong>Activ\00E9</strong>.</p>'),
unistr('<p><em><strong>Remarque :</strong> les modifications apport\00E9es ici ne seront pas refl\00E9t\00E9es pour les utilisateurs finals individuels qui ex\00E9cutent actuellement l''application. Lorsque l''utilisateur final se d\00E9connecte, puis se reconnecte, le param\00E8tre ')
||unistr('r\00E9vis\00E9 de la fonction sera appel\00E9.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277738698715867562)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>S\00E9lectionnez le sch\00E9ma de couleur par d\00E9faut utilis\00E9 pour afficher l''application.</p>'),
unistr('<p>Si l''option <strong>Autoriser les utilisateurs finals \00E0 choisir un style de th\00E8me</strong> est s\00E9lectionn\00E9e, chaque utilisateur final peut choisir parmi les styles de th\00E8me disponibles en cliquant sur le lien <em>Personnaliser</em> dans l''angle in')
||unistr('f\00E9rieur gauche de la page d''accueil.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277739213117867562)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cette page fournit un \00E9tat interactif de toutes les erreurs inattendues consign\00E9es par cette application.</p>'),
unistr('<p>Pour trier et filtrer les donn\00E9es, cliquez sur les en-t\00EAtes de colonne, ou cliquez sur le bouton <strong>Actions</strong> pour personnaliser l''affichage des colonnes et de nombreuses fonctionnalit\00E9s avanc\00E9es suppl\00E9mentaires. Pour r\00E9tablir les para')
||unistr('m\00E8tres par d\00E9faut de l''\00E9tat interactif, cliquez sur le bouton <strong>R\00E9initialiser</strong>.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277739103280867562)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilisez cet \00E9tat et ce graphique pour afficher les utilisateurs comportant le plus de vues de page pour la tanche de temps sp\00E9cifi\00E9e.</p>'),
unistr('<p>S\00E9lectionnez la tranche de temps de g\00E9n\00E9ration d''\00E9tat (par d\00E9faut = 1 jour) et choisissez l''ic\00F4ne d''\00E9tat ou de graphique en haut de la page.</p>'),
unistr('<p>Pour l''\00E9tat interactif, utilisez le champ de recherche ou s\00E9lectionnez l''en-t\00EAte de colonne <strong>Utilisateur</strong> pour s\00E9lectionner un utilisateur sp\00E9cifique. Vous pouvez ex\00E9cuter de nombreuses fonctions en cliquant sur le bouton <strong>Ac')
||unistr('tions</strong>, telles que les colonnes affich\00E9es/masqu\00E9es, les lignes par page, les filtres, etc. Pour r\00E9tablir les param\00E8tres par d\00E9faut de l''\00E9tat interactif, cliquez sur le bouton <strong>R\00E9initialiser</strong>.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277739387564867562)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cette page fournit un \00E9tat interactif des performances et de la popularit\00E9 de la page. L''\00E9tat est tri\00E9 par <strong>Performances pond\00E9r\00E9es</strong> qui sont calcul\00E9es en multipliant le temps \00E9coul\00E9 m\00E9dian et le nombre de vues de page.</p>'),
unistr('<p>S\00E9lectionnez la tranche de temps de g\00E9n\00E9ration d''\00E9tat (par d\00E9faut = 1 jour) en haut de la page si n\00E9cessaire.<br>'),
unistr('Pour trier et filtrer les donn\00E9es, cliquez sur les en-t\00EAtes de colonne, ou cliquez sur le bouton <strong>Actions</strong> pour personnaliser l''affichage des colonnes et de nombreuses fonctionnalit\00E9s avanc\00E9es suppl\00E9mentaires. Pour r\00E9tablir les param\00E8t')
||unistr('res par d\00E9faut de l''\00E9tat interactif, cliquez sur le bouton <strong>R\00E9initialiser</strong>.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277739440678867562)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cette page fournit un \00E9tat interactif des vues de page les plus r\00E9centes.</p>'),
unistr('<p>S\00E9lectionnez la tranche de temps de g\00E9n\00E9ration d''\00E9tat (par d\00E9faut = 1 jour) en haut de la page si n\00E9cessaire.<br>'),
unistr('Pour trier et filtrer les donn\00E9es, cliquez sur les en-t\00EAtes de colonne, ou cliquez sur le bouton <strong>Actions</strong> pour personnaliser l''affichage des colonnes et de nombreuses fonctionnalit\00E9s avanc\00E9es suppl\00E9mentaires. Pour r\00E9tablir les param\00E8t')
||unistr('res par d\00E9faut de l''\00E9tat interactif, cliquez sur le bouton <strong>R\00E9initialiser</strong>.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277738481068867562)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Les notifications sont affich\00E9es sur la page d''accueil, lorsque cette fonction est activ\00E9e.</p>'),
unistr('<p>Cet \00E9tat affiche les notifications d\00E9finies et la dur\00E9e d''affichage.</p>'),
unistr('<p>Cliquez sur l''ic\00F4ne de modification (crayon jaune) pour modifier une notification existante ou cliquez sur <strong>Ajouter une notification</strong> pour ins\00E9rer une nouvelle notification.</p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277738776398867562)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Saisissez le nom de l''application et une br\00E8ve description.</p>'),
unistr('<p>Le nom de l''application est affich\00E9 sur la page d''accueil. La br\00E8ve description figure en dessous du nom de l''application.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277738941784867562)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Les informations en retour peuvent \00EAtre saisies par les utilisateurs finals \00E0 partir de n''importe quelle page normale dans l''application.</p>'),
unistr('<p>Cet \00E9tat affiche les informations en retour saisies, les r\00E9ponses transmises par les administrateurs et le statut des informations en retour.</p>'),
unistr('<p>Cliquez sur l''ic\00F4ne de modification (crayon jaune) pour saisir une r\00E9ponse ou mettre \00E0 jour le statut des informations en retour.</p>'),
unistr('<p><em><strong>Remarque :</strong> si des destinataires ont \00E9t\00E9 d\00E9finis pour les informations en retour, ces derniers seront \00E9galement envoy\00E9s par courriel aux adresses \00E9lectroniques figurant dans la liste des destinataires des informations en retour')
||'.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277755082106867572)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Indiquez la liste des adresses \00E9lectroniques s\00E9par\00E9es par une virgule.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277739014088867562)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('<p><strong>Activer les pi\00E8ces jointes :</strong> si l''option est d\00E9finie sur Oui, les utilisateurs pourront t\00E9l\00E9charger une pi\00E8ce jointe et l''ajouter \00E0 leurs informations en retour.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277740087723867563)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cette page r\00E9pertorie les mod\00E8les de courriel d\00E9finis et le nombre de fois o\00F9 le mod\00E8le a \00E9t\00E9 r\00E9f\00E9renc\00E9 dans les courriels envoy\00E9s.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277739873838867563)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cette page r\00E9pertorie les courriels envoy\00E9s.</p>'),
unistr('<p>Pour afficher plus de d\00E9tails sur les courriels envoy\00E9s, cliquez sur l''ic\00F4ne en forme de loupe.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277739929315867563)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Pour d\00E9finir un mod\00E8le de courriel, indiquez les champs suivants :</p>'),
'<ul>',
unistr('  <li><strong>Nom de mod\00E8le</strong> (obligatoire) - Saisissez un nom explicite pour le mod\00E8le.</li>'),
unistr('  <li><strong>Mod\00E8le HTML</strong> (obligatoire) - Saisissez le code HTML utilis\00E9 pour construire le courriel envoy\00E9 aux destinataires qui autorisent la distribution de courriels HTML.'),
'    Les valeurs de substitution incluent :',
'    <ul>',
unistr('        <li><strong>#APP_NAME#</strong> - Valeur remplac\00E9e par le nom de l''application</li>'),
unistr('        <li><strong>#BODY1#</strong> - Valeur remplac\00E9e par la valeur transmise en tant que p_body1_text</li> '),
unistr('        <li><strong>#TABLE#</strong> - Valeur remplac\00E9e par la valeur transmise en tant que p_table_content, \00E0 l''aide de HTML de table ouverte, HTML de ligne de table et HTML de table ferm\00E9e</li> '),
unistr('        <li><strong>#BODY2#</strong> - Valeur remplac\00E9e par la valeur transmise en tant que p_body2_text</li> '),
unistr('        <li><strong>#ACTION#</strong> - Valeur remplac\00E9e par la valeur transmise en tant que p_action_label et p_action_link, \00E0 l''aide du mod\00E8le Lien de l''action</li>'),
'     </ul></li>',
unistr('  <li><strong>Mod\00E8le de texte brut</strong> (obligatoire) - Entrez le texte brut utilis\00E9 pour construire le courriel envoy\00E9 aux destinataires qui n''acceptent pas les courriels HTML. Il utilise les m\00EAmes valeurs de substitution que le mod\00E8le HTML, sau')
||'f #TABLE# et #ACTION# qui s''affichent en tant que texte brut.</li>',
'<ul>',
unistr('<p>Des mod\00E8les HTML suppl\00E9mentaires permettent des courriels plus avanc\00E9s. Ces \00E9l\00E9ments incluent :</p>'),
'<ul>',
unistr('  <li><strong>Avant lignes</strong> - Saisissez le code HTML permettant de remplacer #TABLE# dans le mod\00E8le HTML. Uniquement utilis\00E9 si p_table_content est transmis.</li>'),
unistr('  <li><strong>Mod\00E8le de ligne</strong> - Saisissez le code HTML permettant d''afficher chaque ligne de la table. Cela inclut l''ouverture/la fermeture de ligne et l''ouverture/la fermeture de donn\00E9es \00E0 l''aide des valeurs de substitution #LABEL# et #VALU')
||unistr('E#. Uniquement utilis\00E9 si p_table_content est transmis.</li>'),
unistr('  <li><strong>Apr\00E8s lignes</strong> - Saisissez le code HTML permettant de fermer la table ou la balise div. Uniquement utilis\00E9 si p_table_content est transmis.</li>'),
unistr('  <li><strong>HTML de lien d''action</strong> - Saisissez le code HTML permettant de remplacer #ACTION# dans le mod\00E8le HTML. Il doit contenir #ACTION_LINK# et #ACTION_TEXT#. Uniquement utilis\00E9 si p_action_label et p_action_link sont transmis.</li>'),
'</ul>',
unistr('<p><em><strong>Remarque :</strong> utilisez les entr\00E9es du <strong>mod\00E8le par d\00E9faut</strong> comme exemple pour d\00E9velopper votre propre mod\00E8le. Le mod\00E8le par d\00E9faut utilise toutes les variables de substitution que vous pouvez inclure ou non dans vot')
||unistr('re propre mod\00E8le de courriel.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277740160325867563)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Activez ou d\00E9sactivez l''envoi de courriels en s\00E9lectionnant l''une des options de <strong>r\00E9partition de courriels</strong>.</p>'),
unistr('<p>Indiquez l''<strong>exp\00E9diteur des courriels</strong> \00E0 l''aide de l''adresse \00E9lectronique du contact principal pour les probl\00E8mes d''application. Cette valeur peut \00EAtre utilis\00E9e ou \00E9cras\00E9e lors de l''utilisation de la fonctionnalit\00E9 de messagerie.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277758333815867574)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_language=>'fr'
,p_message_text=>unistr('Il s''agit de l''adresse d''exp\00E9diteur qui sera utilis\00E9e pour envoyer les courriels. Elle peut \00EAtre \00E9cras\00E9e lors de l''utilisation de la fonctionnalit\00E9 de messagerie.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277776740272867587)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Renseignez les \00E9l\00E9ments suivants et cliquez sur [Envoyer un courriel]. Tous les courriels envoy\00E9s sont consign\00E9s dans le journal de courriels.'),
'    <ul>',
unistr('        <li><strong>De</strong> : si une "adresse d''exp\00E9diteur" est d\00E9finie dans les param\00E8tres de messagerie, l''adresse \00E9lectronique constitue une option d''exp\00E9dition. Si l''application utilise des adresses \00E9lectroniques comme noms utilisateur, vous ')
||unistr('pouvez choisir d''envoyer des courriels \00E0 partir de votre adresse \00E9lectronique. Enfin, l''exp\00E9diteur peut \00EAtre identique au destinataire.</li>'),
unistr('        <li><strong>Envoyer \00E0</strong> : si cette application utilise des adresses \00E9lectroniques comme noms utilisateur, vous pouvez choisir d''envoyer des courriels aux adresses \00E9lectroniques et/ou aux utilisateurs.</li>'),
unistr('        <li><strong>Adresses \00E9lectroniques</strong> : liste d''adresses \00E9lectroniques s\00E9par\00E9es par des virgules pour recevoir le courriel. Les adresses non valides ne sont pas incluses.</li>'),
unistr('        <li><strong>R\00F4le</strong> : envoyez un courriel \00E0 tous les utilisateurs d''un r\00F4le s\00E9lectionn\00E9 ou \00E0 tous les utilisateurs d\00E9finis. La liste de s\00E9lection inclut une liste de r\00F4les et le nombre d''utilisateurs dot\00E9s de ce r\00F4le.</li>'),
unistr('        <li><strong>Mod\00E8le</strong> : s\00E9lectionnez le mod\00E8le de courriel \00E0 utiliser pour cr\00E9er le corps du courriel.</li>'),
'        <li><strong>Objet</strong> : objet du courriel.</li>',
unistr('        <li><strong>Corps de courriel</strong> : texte \00E0 inclure en tant que corps du courriel.</li>'),
unistr('        <li><strong>Autoriser le d\00E9sabonnement</strong> : certains courriels doivent \00EAtre envoy\00E9s m\00EAme si l''utilisateur a choisi de se d\00E9sabonner de la r\00E9ception des courriels. Cela inclut les messages de coupure, etc. Cet indicateur sp\00E9cifie si un d')
||unistr('\00E9sabonnement est possible pour le courriel ou si l''envoi est effectu\00E9 ind\00E9pendamment des pr\00E9f\00E9rences de l''utilisateur.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277778458811867588)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Renseignez les \00E9l\00E9ments suivants et cliquez sur [Envoyer un courriel]. Tous les courriels envoy\00E9s sont consign\00E9s dans le journal de courriels.'),
'    <ul>',
unistr('        <li><strong>De</strong> - Si une "adresse d''exp\00E9diteur" est d\00E9finie dans les param\00E8tres de messagerie, l''adresse \00E9lectronique constitue une option d''exp\00E9dition. Sinon, l''exp\00E9diteur peut \00EAtre identique au destinataire.</li>'),
unistr('        <li><strong>Adresses \00E9lectroniques</strong> - Liste d''adresses \00E9lectroniques s\00E9par\00E9es par des virgules pour recevoir le courriel. Les adresses non valides ne sont pas incluses.</li>'),
unistr('        <li><strong>Mod\00E8le</strong> - S\00E9lectionnez le mod\00E8le de courriel \00E0 utiliser pour cr\00E9er le corps du courriel.</li>'),
'        <li><strong>Objet</strong> - Objet du courriel.</li>',
unistr('        <li><strong>Corps de courriel</strong> - Texte \00E0 inclure en tant que corps du courriel.</li>'),
unistr('        <li><strong>Autoriser le d\00E9sabonnement</strong> - Certains courriels doivent \00EAtre envoy\00E9s m\00EAme si l''utilisateur a choisi de se d\00E9sabonner de la r\00E9ception des courriels. Cela inclut les messages de coupure, etc. Cet indicateur sp\00E9cifie si un d')
||unistr('\00E9sabonnement est possible pour le courriel ou si l''envoi est effectu\00E9 ind\00E9pendamment des pr\00E9f\00E9rences de l''utilisateur.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277738807304867562)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>S\00E9lectionnez le fuseau horaire par d\00E9faut pour tous les utilisateurs de cette application.</p>'),
unistr('<p>Les utilisateurs individuels peuvent remplacer ce param\00E8tre en cliquant sur leur nom utilisateur (en haut \00E0 droite) et en s\00E9lectionnant <strong>Pr\00E9f\00E9rences</strong>. Ils peuvent \00E9galement cliquer sur le lien de fuseau horaire affich\00E9 en bas de la ')
||'page d''accueil.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277754709271867572)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'fr'
,p_message_text=>unistr('Cette page n''est pas accessible directement via l''interface utilisateur. Elle sert \00E0 faciliter le t\00E9l\00E9chargement de la photo de profil.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277754471273867572)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_language=>'fr'
,p_message_text=>unistr('La page de profil utilisateur vous permet de consulter les informations pertinentes concernant un utilisateur sur un \00E9cran unique facile \00E0 utiliser.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277754124640867572)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9chargez une photo pr\00E9sentant un rapport hauteur/largeur carr\00E9, sinon elle risque d''\00EAtre d\00E9form\00E9e. Taille d''image recommand\00E9e : 250 x 250 pixels.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277740256405867563)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Ce formulaire vous permet de mettre \00E0 jour vos d\00E9tails personnels et de t\00E9l\00E9charger une photo ou un avatar.</p>'),
unistr('<p>Pour t\00E9l\00E9charger une image, cliquez sur <strong>Parcourir</strong> ou effectuez un glisser-d\00E9placer de l''image sur le bouton.<br>'),
unistr('T\00E9l\00E9chargez une photo avec un rapport hauteur/largeur carr\00E9, sinon elle risque d''\00EAtre d\00E9form\00E9e. Taille d''image recommand\00E9e : 250 x 250 pixels.</p>'),
'<p>Pour enlever l''image, cliquez sur <strong>Supprimer la photo</strong>.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277760305015867576)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ensemble du texte d''aide de l''application est accessible \00E0 partir de cette page. Les liens figurant dans la r\00E9gion "Documentation" fournissent une explication bien plus approfondie des fonctions et fonctionnalit\00E9s de l''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277741388792867564)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous pouvez d\00E9finir les pr\00E9f\00E9rences d''application pour votre compte \00E0 partir de cette page. Les pr\00E9f\00E9rences peuvent avoir une incidence sur diff\00E9rents aspects de l''application tels que le fuseau horaire. Cliquez sur les ic\00F4nes d''aide au niveau des \00E9l')
||unistr('\00E9ments pour savoir \00E0 quoi correspond chaque pr\00E9f\00E9rence.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276733474870866913)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Cet \00E9tat pr\00E9sente tous les courriels en attente d''envoi et ceux d\00E9j\00E0 envoy\00E9s.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276865370905866996)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Cet \00E9tat comprend tous les travaux s\00E9lectionn\00E9s pour \00EAtre surveill\00E9s par cette application. Vous pouvez obtenir plus de d\00E9tails sur chaque travail en cliquant sur son nom.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276871988425867001)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Cet \00E9tat comprend les d\00E9tails d''ex\00E9cution concernant les travaux s\00E9lectionn\00E9s pour \00EAtre surveill\00E9s par cette application.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277725619294867553)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_language=>'fr'
,p_message_text=>'Ajouter la page A propos de cette application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277742073906867564)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finissez cette option sur Non si vous ne voulez pas recevoir de courriels de cette application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277776298591867586)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Saisissez un terme de recherche dans la bo\00EEte de dialogue de recherche et cliquez sur <strong>Rechercher</strong>.<br>'),
unistr('Cliquez sur n''importe quel en-t\00EAte de r\00E9sultat pour acc\00E9der \00E0 l''enregistrement sp\00E9cifique.</p>'),
unistr('<p>Pour limiter la recherche, d\00E9s\00E9lectionnez des sources, ce qui enl\00E8ve l''\00E9tat des r\00E9sultats de recherche.</p>'),
unistr('<p>Cliquez sur <strong>R\00E9initialiser</strong> pour enlever le terme de recherche en cours et s\00E9lectionner toutes les sources.</p> ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277741856469867564)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finissez votre fuseau horaire pr\00E9f\00E9r\00E9 \00E0 utiliser dans l''ensemble de l''application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276653925958866862)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments masqu\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277761985328867577)
,p_name=>'CA.HOME'
,p_message_language=>'fr'
,p_message_text=>'Page d''accueil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277768057481867581)
,p_name=>'CA.HOME.PAGE'
,p_message_language=>'fr'
,p_message_text=>'Page d''accueil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277784487957867592)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ev\00E9nements de la page Horaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276732586051866912)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_language=>'fr'
,p_message_text=>'Taille du corps HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277758782624867575)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277755465935867573)
,p_name=>'CA.IN.PROGRESS'
,p_message_language=>'fr'
,p_message_text=>unistr('En cours d''ex\00E9cution')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277780697602867589)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_language=>'fr'
,p_message_text=>'Inclure dans les formulaires'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277780564084867589)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Inclure dans les \00E9tats')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277764177669867578)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_language=>'fr'
,p_message_text=>'Installation de scripts d''objet de prise en charge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276866095031866997)
,p_name=>'CA.INSTANCE.ID'
,p_message_language=>'fr'
,p_message_text=>'ID d''instance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276867258915866998)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_language=>'fr'
,p_message_text=>'Affectation d''instance'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277737847196867561)
,p_name=>'CA.INTRO.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Bienvenue dans cet aper\00E7u disponible uniquement sur le cloud d''une nouvelle m\00E9thode am\00E9lior\00E9e permettant de cr\00E9er une application plus compl\00E8te. L''assistant Cr\00E9ation d''application standard vous permet uniquement de s\00E9lectionner les pages \00E0 g\00E9n\00E9rer')
||unistr(', tandis que cet assistant vous donne \00E9galement l''opportunit\00E9 de pr\00E9charger rapidement de nombreuses fonctions suppl\00E9mentaires dans votre application.</p>'),
unistr('<p>Les applications g\00E9n\00E9r\00E9es \00E0 l''aide de cet assistant seront int\00E9gralement prises en charge et peuvent \00E9galement inclure des objets de prise en charge pour les fonctions s\00E9lectionn\00E9es, telles que le contr\00F4le d''acc\00E8s, la structure des courriels, les ')
||'informations en retour, etc.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277738014931867561)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Commencez par indiquer le nom de l''application. Ensuite, ajoutez au moins une page \00E0 votre application. S\00E9lectionnez les fonctions que vous souhaitez inclure. Faites des choix concernant l''apparence de l''application, puis passez en revue les param')
||unistr('\00E8tres.<br>'),
unistr('C''est tr\00E8s simple : il vous suffit de cliquer sur <strong>Cr\00E9er une application</strong>.</p>'),
unistr('<p>Cliquez sur <strong>Afficher le mod\00E8le de base</strong> pour r\00E9utiliser le mod\00E8le d''une application g\00E9n\00E9r\00E9e pr\00E9c\00E9demment ou pour r\00E9pliquer rapidement des pages.</p>'),
unistr('<p><em><strong>Remarque :</strong> chaque section et chaque \00E9l\00E9ment Ajouter une page comportent une aide d\00E9taill\00E9e pour vous accompagner.</em></p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277737947571867561)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Proc\00E9dure d''utilisation de l''assistant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277772686700867584)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Les probl\00E8mes importants survenant lors de la publication sont r\00E9pertori\00E9s ci-dessous :'),
'<ol>',
unistr('  <li>L''assistant Cr\00E9er une application \00E0 partir du mod\00E8le de base n''est pas traduit.</li>'),
unistr('  <li>Les applications traduites g\00E9n\00E9r\00E9es avec cet assistant ne sont que partiellement traduites.</li>'),
unistr('  <li>L''analyse descendante d''\00E9tat n''autorise qu''une seule colonne d''analyse descendante.</li>'),
unistr('  <li>Les pages d''\00E9tat de filtre ne peuvent pas \00EAtre g\00E9n\00E9r\00E9es.</li>'),
unistr('  <li>La fonctionnalit\00E9 de messagerie fournit l''API de bas niveau, mais n''inclut toujours pas de fonctionnalit\00E9s de messagerie de niveau sup\00E9rieur.</li>'),
unistr('  <li>La g\00E9n\00E9ration d''une application \00E0 partir d''un mod\00E8le de base qui r\00E9f\00E9rence des tables manquantes \00E9chouera avec une erreur.</li>'),
unistr('  <li>Param\00E8tres avanc\00E9s - Les formats de date ne sont pas appliqu\00E9s \00E0 l''application g\00E9n\00E9r\00E9e.</li>'),
'</ol>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277772586221867584)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Probl\00E8mes connus')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277738210877867562)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Version %0.</p>',
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277738156041867561)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9tails de version')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277737775943867561)
,p_name=>'CA.INTRO.TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er une application \00E0 partir de l''assistant Mod\00E8le de base {Aper\00E7u uniquement sur le cloud}')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277749383316867569)
,p_name=>'CA.IP.ADDRESS'
,p_message_language=>'fr'
,p_message_text=>'Adresse IP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277747594018867568)
,p_name=>'CA.IR.SEARCH'
,p_message_language=>'fr'
,p_message_text=>unistr('Recherche d''\00E9tat interactif')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277750596954867569)
,p_name=>'CA.IR.SEARCHES'
,p_message_language=>'fr'
,p_message_text=>unistr('Recherches d''\00E9tat interactif')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277779094003867588)
,p_name=>'CA.ITEMNAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom d''\00E9l\00E9ment')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276870005942866999)
,p_name=>'CA.JOB.ACTION'
,p_message_language=>'fr'
,p_message_text=>'Action de travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276871557766867000)
,p_name=>'CA.JOB.CLASS'
,p_message_language=>'fr'
,p_message_text=>'Classe de travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276870636367867000)
,p_name=>'CA.JOB.CREATOR'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ateur du travail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276871714538867001)
,p_name=>'CA.JOB.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276868202461866998)
,p_name=>'CA.JOB.PRIORITY'
,p_message_language=>'fr'
,p_message_text=>unistr('Priorit\00E9 de travail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276865202796866996)
,p_name=>'CA.JOB.REPORTING'
,p_message_language=>'fr'
,p_message_text=>unistr('G\00E9n\00E9ration d''\00E9tat sur les travaux')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276907826549867024)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Visualiser le statut et les d\00E9tails d''ex\00E9cution des travaux qui prennent en charge cette application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276871899874867001)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9tails d''ex\00E9cution de travail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276870702440867000)
,p_name=>'CA.JOB.STYLE'
,p_message_language=>'fr'
,p_message_text=>'Style du travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276870835310867000)
,p_name=>'CA.JOB.SUBNAME'
,p_message_language=>'fr'
,p_message_text=>'Sous-nom du travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276870165908866999)
,p_name=>'CA.JOB.TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type de travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276866810302866997)
,p_name=>'CA.JOB.WEIGHT'
,p_message_language=>'fr'
,p_message_text=>'Poids du travail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277779512098867588)
,p_name=>'CA.KEYCOLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de cl\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277781355016867590)
,p_name=>'CA.LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277779883384867589)
,p_name=>'CA.LABELCOLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de libell\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277781581932867590)
,p_name=>'CA.LABELPLURAL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 au pluriel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277781240666867589)
,p_name=>'CA.LABELSINGULAR'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 au singulier')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277736903879867561)
,p_name=>'CA.LANGUAGE'
,p_message_language=>'fr'
,p_message_text=>'Langue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277737093901867561)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionnez la langue principale de cette application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277772067397867583)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>La langue principale r\00E9git la langue utilis\00E9e pour afficher les pages et les composants g\00E9n\00E9r\00E9s dans App Builder. La s\00E9lection de plusieurs traductions permet aux utilisateurs finals de choisir la langue d''affichage de l''application d''ex\00E9cution.</')
||'p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277016430166867093)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lecteur de langue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277753994935867572)
,p_name=>'CA.LAST.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276870973592867000)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Dur\00E9e de la derni\00E8re ex\00E9cution')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276871049935867000)
,p_name=>'CA.LAST.START.DATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Date du dernier d\00E9marrage')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277784848954867592)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_language=>'fr'
,p_message_text=>unistr('Derni\00E8re activit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277780781234867589)
,p_name=>'CA.LISTOFVALUES'
,p_message_language=>'fr'
,p_message_text=>'Liste de valeurs (LOV)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277776176092867586)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_language=>'fr'
,p_message_text=>unistr('Charger le mod\00E8le de base')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276873393141867002)
,p_name=>'CA.LOG.DATE'
,p_message_language=>'fr'
,p_message_text=>'Consigner la date dans le journal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276873543825867002)
,p_name=>'CA.LOG.ID'
,p_message_language=>'fr'
,p_message_text=>'ID de journal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276867507773866998)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_language=>'fr'
,p_message_text=>'Niveau de journalisation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276654773104866862)
,p_name=>'CA.LOOKUP.COLUMNS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>Colonnes de recherche</strong> : d\00E9veloppez pour voir des attributs de d\00E9finition d''une recherche sur une autre table. Utilisez les colonnes de recherche pour remplacer les identificateurs par une colonne d''affichage, par exemple pour af')
||unistr('ficher le nom du d\00E9partement \00E0 la place de son num\00E9ro.<br>'),
unistr('<em><strong>Remarque :</strong> les colonnes de recherche apparaissent uniquement si la page en cours est bas\00E9e sur une table ou une vue et a des contraintes de cl\00E9 \00E9trang\00E8re sur une autre table.'),
'  <ul>',
unistr('    <li><strong>Cl\00E9 de recherche</strong> : s\00E9lectionnez la colonne qui sera modifi\00E9e pour g\00E9n\00E9rer la colonne d''affichage.</li>'),
unistr('    <li><strong>Colonne d''affichage</strong> : s\00E9lectionnez la colonne (dans la table de consultation) \00E0 afficher.</li>'),
'    &nbsp;<br>',
unistr('    <em><strong>Remarque :</strong> s\00E9lectionnez uniquement les colonnes qui ont une r\00E9f\00E9rence \00E0 une autre table (via une cl\00E9 \00E9trang\00E8re).</em></li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277757955554867574)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_language=>'fr'
,p_message_text=>unistr('G\00E9rer les mod\00E8les de courriel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277755971015867573)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_language=>'fr'
,p_message_text=>unistr('G\00E9rer les informations en retour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277752025813867570)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('G\00E9rer l''acc\00E8s utilisateur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277785452257867592)
,p_name=>'CA.MASTER'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajouter une page ma\00EEtre-d\00E9tail')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277785598331867592)
,p_name=>'CA.MASTER.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une page qui affiche une page ma\00EEtre-d\00E9tail pour permettre aux utilisateurs finals de visualiser et de tenir \00E0 jour les donn\00E9es.<br>'),
'&nbsp;</p>',
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de page</strong> (obligatoire) : saisissez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
unistr('  <li><strong>Type de page</strong> : s\00E9lectionnez le type de page [C\00F4te \00E0 c\00F4te, Empil\00E9].<br>'),
unistr('    <strong>C\00F4te \00E0 c\00F4te</strong> : <br>'),
unistr('<em>Ma\00EEtre-d\00E9tail de page utilisant une mise en page c\00F4te \00E0 c\00F4te et des r\00E9gions d''\00E9tat avec des fen\00EAtres de modification modales.</em>'),
'    <ul>',
unistr('      <li><strong>Table</strong> (obligatoire) : s\00E9lectionnez la table ma\00EEtre pour la page.</li>'),
unistr('      <li><strong>Colonne d''affichage principale</strong> (obligatoire) : s\00E9lectionnez la colonne \00E0 afficher dans la liste des enregistrements ma\00EEtre.</li>'),
unistr('      <li><strong>Colonne d''affichage secondaire</strong> (obligatoire) : s\00E9lectionnez la colonne descriptive \00E0 afficher dans la liste des enregistrements ma\00EEtre, sous la colonne d''affichage principale.</li>'),
unistr('      <li><strong>Table de d\00E9tails 1</strong> (obligatoire) : s\00E9lectionnez la premi\00E8re table de d\00E9tails pour la page.</li>'),
unistr('      <li><strong>Table de d\00E9tails 2</strong> - s\00E9lectionnez la deuxi\00E8me table de d\00E9tails pour la page.</li>'),
unistr('      <li><strong>Table de d\00E9tails 3</strong> - s\00E9lectionnez la troisi\00E8me table de d\00E9tails pour la page.</li>'),
unistr('      <li><strong>Table de d\00E9tails 4</strong> - s\00E9lectionnez la quatri\00E8me table de d\00E9tails pour la page.</li>'),
'    </ul>',
unistr('   <strong>Empil\00E9</strong> : <br>'),
unistr('<em>Ma\00EEtre-d\00E9tail de page utilisant des grilles interactives modifiables.</em>'),
'    <ul>',
unistr('      <li><strong>Table</strong> (obligatoire) : s\00E9lectionnez la table ma\00EEtre pour la grille interactive modifiable.</li>'),
unistr('      <li><strong>Table de d\00E9tails</strong> (obligatoire) : s\00E9lectionnez la table de d\00E9tails pour la page.</li>'),
unistr('      <em><strong>Remarque :</strong> une seule table de d\00E9tails (grille interactive modifiable) peut \00EAtre ajout\00E9e \00E0 l''aide de l''assistant. Vous pouvez ajouter facilement d''autres tables de d\00E9tails une fois la g\00E9n\00E9ration termin\00E9e.</em>'),
'    </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277016358203867093)
,p_name=>'CA.MASTER_RECORDS'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrements ma\00EEtre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277748231513867568)
,p_name=>'CA.MAX.ELAPSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Temps maximal \00E9coul\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276868024295866998)
,p_name=>'CA.MAX.FAILURES'
,p_message_language=>'fr'
,p_message_text=>unistr('Nombre maximal d''\00E9checs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276867683766866998)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Dur\00E9e maximale de l''ex\00E9cution')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276868130032866998)
,p_name=>'CA.MAX.RUNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Nombre maximal d''ex\00E9cutions')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277779712507867588)
,p_name=>'CA.MAXIMUMROWS'
,p_message_language=>'fr'
,p_message_text=>'Nombre maximum de lignes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277782761399867590)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_language=>'fr'
,p_message_text=>'Largeur maximum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277773389163867584)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_language=>'fr'
,p_message_text=>'Ajouter un filtre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277773728759867585)
,p_name=>'CA.MD.ADD.ROW'
,p_message_language=>'fr'
,p_message_text=>'Ajouter %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277773201288867584)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_language=>'fr'
,p_message_text=>'Appliquer des filtres'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277774166717867585)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_language=>'fr'
,p_message_text=>'Valeur de date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277774222128867585)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_language=>'fr'
,p_message_text=>'Valeur de date 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277773440340867584)
,p_name=>'CA.MD.EDIT'
,p_message_language=>'fr'
,p_message_text=>'Modifier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277772809100867584)
,p_name=>'CA.MD.FILTER'
,p_message_language=>'fr'
,p_message_text=>'Filtrer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277772798621867584)
,p_name=>'CA.MD.FILTERS'
,p_message_language=>'fr'
,p_message_text=>'Filtres'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277773838018867585)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_language=>'fr'
,p_message_text=>'Aucun filtre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277773152882867584)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun enregistrement s\00E9lectionn\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277773023586867584)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun enregistrement trouv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277773672475867584)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 supprim\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277773511990867584)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 mis \00E0 jour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277772900372867584)
,p_name=>'CA.MD.SEARCH'
,p_message_language=>'fr'
,p_message_text=>'Rechercher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277773906643867585)
,p_name=>'CA.MD.VALUE'
,p_message_language=>'fr'
,p_message_text=>'Valeur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277774022262867585)
,p_name=>'CA.MD.VALUE.2'
,p_message_language=>'fr'
,p_message_text=>'Valeur 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277747737549867568)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Temps m\00E9dian \00E9coul\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277756880251867573)
,p_name=>'CA.MESSAGE'
,p_message_language=>'fr'
,p_message_text=>'Message'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277782265464867590)
,p_name=>'CA.METRIC'
,p_message_language=>'fr'
,p_message_text=>'Mesure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277748691129867568)
,p_name=>'CA.MIN.ELAPSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Temps minimal \00E9coul\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277751454235867570)
,p_name=>'CA.MOBILE.PHONE'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9phone portable')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277747212977867567)
,p_name=>'CA.MODE'
,p_message_language=>'fr'
,p_message_text=>'Mode'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277761037466867576)
,p_name=>'CA.MORE'
,p_message_language=>'fr'
,p_message_text=>'Plus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277750658121867570)
,p_name=>'CA.MOST RECENT'
,p_message_language=>'fr'
,p_message_text=>'Most_Recent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277784639256867592)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_language=>'fr'
,p_message_text=>'Pages les plus actives'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276654802933866862)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_language=>'fr'
,p_message_text=>'Etats multiples'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276654964440866862)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cochez des noms de table ou de vue. Vous pouvez \00E9galement cocher la case de l''en-t\00EAte pour s\00E9lectionner ou d\00E9s\00E9lectionner tous les objets de base de donn\00E9es de la liste.</p>'),
unistr('<p>Une page avec \00E9tat interactif sera ajout\00E9e pour chaque objet de base de donn\00E9es coch\00E9.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277744658306867566)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur #LABEL# doit \00EAtre un horodatage valide.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277782085090867590)
,p_name=>'CA.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277736148857867560)
,p_name=>'CA.NAVIGATION'
,p_message_language=>'fr'
,p_message_text=>'Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277736252514867560)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Indiquez si le menu est affich\00E9 sur le c\00F4t\00E9 de l''application ou dans la partie sup\00E9rieure de celle-ci.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277788793971867594)
,p_name=>'CA.NEGATIVE'
,p_message_language=>'fr'
,p_message_text=>unistr('N\00E9gatif')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277788648134867594)
,p_name=>'CA.NEUTRAL'
,p_message_language=>'fr'
,p_message_text=>'Neutre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277774725654867585)
,p_name=>'CA.NEXT'
,p_message_language=>'fr'
,p_message_text=>'Suivant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276867899520866998)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Date de l''ex\00E9cution suivante')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276866722257866997)
,p_name=>'CA.NLS.ENV'
,p_message_language=>'fr'
,p_message_text=>'Environnement NLS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276964560047867060)
,p_name=>'CA.NO'
,p_message_language=>'fr'
,p_message_text=>'Non'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277755578626867573)
,p_name=>'CA.NO.ACTION'
,p_message_language=>'fr'
,p_message_text=>'Aucune action'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277767121790867580)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_language=>'fr'
,p_message_text=>'Il n''y a pas d''aide pour cette page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276654058970866862)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'fr'
,p_message_text=>'Il n''existe aucun utilisateur valide - Infos sur la page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277775765536867586)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun nouvel utilisateur valide trouv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277771827569867583)
,p_name=>'CA.NONE'
,p_message_language=>'fr'
,p_message_text=>'Aucun'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277751789997867570)
,p_name=>'CA.NOTE'
,p_message_language=>'fr'
,p_message_text=>'Remarque'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277727277938867554)
,p_name=>'CA.NOTIFICATION'
,p_message_language=>'fr'
,p_message_text=>'Notifications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277726015966867554)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_language=>'fr'
,p_message_text=>'Afficher les notifications sur la page d''accueil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277727323454867554)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permet aux administrateurs de l''application d''indiquer des alertes (en jaune) ou des erreurs (en rouge) visibles par tous les utilisateurs finals sur la page d''accueil de l''application. Cette fonctionnalit\00E9 est utile pour relayer des informations ')
||unistr('importantes \00E0 votre communaut\00E9 d''utilisateurs finals.</p>'),
'<p>Comprend les composants suivants :<ul>',
unistr('<li>Possibilit\00E9 de d\00E9finir les notifications</li>'),
'<li>Affichage des notifications sur la page d''accueil de l''application</li>',
unistr('<li>Possibilit\00E9 de contr\00F4ler la fen\00EAtre de dur\00E9e d''affichage de la notification</li>'),
'<li>Prise en charge du codage couleur des notifications par type</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277743963289867565)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277747436988867567)
,p_name=>'CA.NUM.ROWS'
,p_message_language=>'fr'
,p_message_text=>'Nombre de lignes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276869903279866999)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_language=>'fr'
,p_message_text=>'Nombre d''arguments'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276866584602866997)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_language=>'fr'
,p_message_text=>'Nombre de destinations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277780245496867589)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_language=>'fr'
,p_message_text=>unistr('Masque de format num\00E9rique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277748970624867568)
,p_name=>'CA.OCCURRENCE'
,p_message_language=>'fr'
,p_message_text=>'Occurrence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277788928565867594)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_language=>'fr'
,p_message_text=>'Vous ne pouvez pas effectuer cette action sans un autre administrateur.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277755761954867573)
,p_name=>'CA.OPEN'
,p_message_language=>'fr'
,p_message_text=>'Ouvert'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277728777833867555)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_language=>'fr'
,p_message_text=>'Organisation des pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277729075069867556)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Organisez les pages selon l''ordre dans lequel vous souhaitez qu''elles apparaissent dans votre application. <br>',
unistr('Pour r\00E9organiser les pages dans la liste, cliquez sur l''ic\00F4ne <em>Menu</em> ( <span class="fa fa-bars" aria-hidden="true"></span> ) \00E0 la fin de chaque liste de pages en maintenant le bouton de la souris enfonc\00E9, puis faites un glisser-d\00E9placer de cet')
||'te page vers le haut ou vers le bas.</p>',
unistr('<p>La page d''accueil est toujours affich\00E9e en premier et ne peut pas \00EAtre d\00E9plac\00E9e.<br>'),
unistr('Les pages administratives apparaissent toujours au bas de la liste. Cet ordre r\00E9git leur ordre d''apparition dans la liste Administration des applications sur la page Administration.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276872065191867001)
,p_name=>'CA.OUTPUT'
,p_message_language=>'fr'
,p_message_text=>'Sortie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276873299428867001)
,p_name=>'CA.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277747173588867567)
,p_name=>'CA.PAGE'
,p_message_language=>'fr'
,p_message_text=>'Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277750323917867569)
,p_name=>'CA.PAGE.EVENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ev\00E9nements de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277762881730867577)
,p_name=>'CA.PAGE.HELP'
,p_message_language=>'fr'
,p_message_text=>'Aide de la page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277749449734867569)
,p_name=>'CA.PAGE.ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ment de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277018303575867094)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier l''enregistrement ma\00EEtre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277018535863867094)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_language=>'fr'
,p_message_text=>'Effectuez la recherche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277746771334867567)
,p_name=>'CA.PAGE.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277762185431867577)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_language=>'fr'
,p_message_text=>'Navigation de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277748891573867568)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_language=>'fr'
,p_message_text=>'Performances de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277774852363867585)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_language=>'fr'
,p_message_text=>'Le type de page "%0" n''est pas un type valide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277748168219867568)
,p_name=>'CA.PAGE.VIEWS'
,p_message_language=>'fr'
,p_message_text=>'Vues de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277729275732867556)
,p_name=>'CA.PAGES'
,p_message_language=>'fr'
,p_message_text=>'Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277729376160867556)
,p_name=>'CA.PAGES.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>D\00E9finissez les pages \00E0 inclure dans votre application initiale. Vous devez d\00E9finir au moins une page pour pouvoir cr\00E9er votre application.</p>'),
unistr('<p>Vous pouvez enrichir votre application en cr\00E9ant autant de pages que vous le souhaitez \00E0 l''aide de cet assistant. Une fois votre application cr\00E9\00E9e, utilisez l''assistant Cr\00E9er une page pour ajouter des pages.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277780149782867589)
,p_name=>'CA.PAGINATIONMETHOD'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9thode de pagination')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277748402759867568)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_language=>'fr'
,p_message_text=>'Vues de page partielle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277754287160867572)
,p_name=>'CA.PHOTO'
,p_message_language=>'fr'
,p_message_text=>'Photo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277754895043867572)
,p_name=>'CA.PHOTO.DELETED'
,p_message_language=>'fr'
,p_message_text=>unistr('Photo supprim\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277754357789867572)
,p_name=>'CA.PHOTO.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de photo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277754003875867572)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9chargement de photo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277758818855867575)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de texte brut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277788547154867594)
,p_name=>'CA.POSITIVE'
,p_message_language=>'fr'
,p_message_text=>'Positif'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277741643781867564)
,p_name=>'CA.PREFERENCES'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9f\00E9rences')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277786153813867593)
,p_name=>'CA.PREVIOUS'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9c\00E9dent')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277780893139867589)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne d''affichage principale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277781789845867590)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de cl\00E9 primaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277781803847867590)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_language=>'fr'
,p_message_text=>'Table parent principale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277749061225867569)
,p_name=>'CA.PROCEDURE'
,p_message_language=>'fr'
,p_message_text=>unistr('Proc\00E9dure')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277742259237867564)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9f\00E9rence de messagerie mise \00E0 jour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277017984066867094)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_language=>'fr'
,p_message_text=>'Extraire la ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277743421400867565)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres d''apparence de l''application enregistr\00E9s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277742130039867564)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9f\00E9rence de fuseau horaire mise \00E0 jour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277754635766867572)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9chargement de photo de profil')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276870280337867000)
,p_name=>'CA.PROGRAM.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de programme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276870301811867000)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire du programme')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277781173679867589)
,p_name=>'CA.QUERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276867052026866998)
,p_name=>'CA.RAISE.EVENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9clencher des \00E9v\00E9nements')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276498871062866762)
,p_name=>'CA.RATING'
,p_message_language=>'fr'
,p_message_text=>'Evaluation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277752556265867571)
,p_name=>'CA.READERS'
,p_message_language=>'fr'
,p_message_text=>'Lecteurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277741948892867564)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_language=>'fr'
,p_message_text=>'Recevoir des courriels'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277784773994867592)
,p_name=>'CA.RECENT.ERRORS'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreurs r\00E9centes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277525179064867424)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277525251460867424)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_language=>'fr'
,p_message_text=>'Valeur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277744138737867565)
,p_name=>'CA.RED'
,p_message_language=>'fr'
,p_message_text=>'Rouge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277757720530867574)
,p_name=>'CA.REFERENCED'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9f\00E9renc\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277017090374867094)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9g\00E9n\00E9rer la page d''administration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276634414272866849)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9g\00E9n\00E9rer \00E0 la fermeture de la bo\00EEte de dialogue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277018411149867094)
,p_name=>'CA.REFRESH_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9g\00E9n\00E9rer l''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277743650130867565)
,p_name=>'CA.REGION.BUTTONS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gion de boutons')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277743572722867565)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gion d''\00E9l\00E9ment de panneau')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277749531641867569)
,p_name=>'CA.REGION.ID'
,p_message_language=>'fr'
,p_message_text=>unistr('ID de r\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277761556750867577)
,p_name=>'CA.RELEASE'
,p_message_language=>'fr'
,p_message_text=>'Version %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277728807729867555)
,p_name=>'CA.REMOVING.PAGES'
,p_message_language=>'fr'
,p_message_text=>'Suppression de pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277728989014867556)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Pour s\00E9lectionner la page, cliquez sur <strong>Modifier</strong>, puis, pour enlever une page de votre application, cliquez sur <strong>Supprimer la page</strong>.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276871654543867000)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_language=>'fr'
,p_message_text=>unistr('Intervalle de r\00E9p\00E9tition')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276733190508866912)
,p_name=>'CA.REPLY.TO'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9pondre \00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277734632746867559)
,p_name=>'CA.REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Ajouter une page d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277734545361867559)
,p_name=>'CA.REPORT.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une page qui affiche un \00E9tat interactif ou classique.</p>'),
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de page</strong> (obligatoire) : saisissez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
unistr('  <li><strong>Type de requ\00EAte</strong> : s\00E9lectionnez la source de l''\00E9tat [<strong>Table ou vue</strong> ou <strong>Requ\00EAte SQL</strong>] :<br>'),
'    <strong>Table ou vue</strong> :',
'    <ul>',
unistr('      <li>Table ou vue (Obligatoire) : s\00E9lectionnez l''objet de base de donn\00E9es de l''\00E9tat.</li>'),
unistr('      <li>Inclure le formulaire : s\00E9lectionnez cette option pour g\00E9n\00E9rer une page de formulaire associ\00E9e permettant aux utilisateurs de tenir \00E0 jour les valeurs de table.</li>'),
'    </ul>',
unistr('    <strong>Requ\00EAte SQL</strong> :'),
'    <ul>',
unistr('      <li>Requ\00EAte SQL (obligatoire) : saisissez une instruction SQL valide qui renvoie des colonnes distinctes.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>Type d''\00E9tat</strong> : s\00E9lectionnez le type d''\00E9tat (<strong>Etat interactif</strong> ou <strong>Etat classique</strong>).</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277726360725867554)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_language=>'fr'
,p_message_text=>'%0 avec le formulaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277571153991867454)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_language=>'fr'
,p_message_text=>'%0 - Etat'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277783805841867591)
,p_name=>'CA.REPORT.VIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Vue d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277782433244867590)
,p_name=>'CA.REPORTS'
,p_message_language=>'fr'
,p_message_text=>'Etats'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276873091412867001)
,p_name=>'CA.REQ.START.DATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Date de d\00E9but demand\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277782695961867590)
,p_name=>'CA.REQUIRED'
,p_message_language=>'fr'
,p_message_text=>'Obligatoire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277759692062867575)
,p_name=>'CA.RESET'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9initialiser')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277755687618867573)
,p_name=>'CA.RESOLVED'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9solu')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277755308517867573)
,p_name=>'CA.RESPONSE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9ponse')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276868311158866998)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_language=>'fr'
,p_message_text=>unistr('Red\00E9marrer en cas d''\00E9chec')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276868496839866998)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Red\00E9marrer en cas de r\00E9cup\00E9ration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276865666641866997)
,p_name=>'CA.RESTARTABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Peut \00EAtre red\00E9marr\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276867944297866998)
,p_name=>'CA.RETRY.COUNT'
,p_message_language=>'fr'
,p_message_text=>'Nombre de nouvelles tentatives'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277777638512867587)
,p_name=>'CA.ROLE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00F4le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277749758262867569)
,p_name=>'CA.ROW.NUMBER'
,p_message_language=>'fr'
,p_message_text=>unistr('Num\00E9ro de ligne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277759055837867575)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de ligne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277777033823867587)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_language=>'fr'
,p_message_text=>unistr('HTML de mod\00E8le de ligne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277778333060867588)
,p_name=>'CA.ROWS.CONTENT'
,p_message_language=>'fr'
,p_message_text=>'Contenu des lignes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277750415268867569)
,p_name=>'CA.ROWS.FETCHED'
,p_message_language=>'fr'
,p_message_text=>'Lignes extraites'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277780016958867589)
,p_name=>'CA.ROWSPERPAGE'
,p_message_language=>'fr'
,p_message_text=>'Lignes par page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276871269011867000)
,p_name=>'CA.RUN.COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Nombre d''ex\00E9cutions')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276872829149867001)
,p_name=>'CA.RUN.DURATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Dur\00E9e de l''ex\00E9cution')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276867705079866998)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_language=>'fr'
,p_message_text=>'Limite de la programmation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276869715585866999)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de programmation'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276869897190866999)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire de la programmation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276869645094866999)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type de programmation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277737115469867561)
,p_name=>'CA.SCHEMA'
,p_message_language=>'fr'
,p_message_text=>unistr('Sch\00E9ma')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277737250443867561)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>S\00E9lectionnez le sch\00E9ma de base de donn\00E9es qui stocke les objets de base de donn\00E9es \00E0 utiliser dans cette application.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277779115700867588)
,p_name=>'CA.SCOPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Port\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277759769401867575)
,p_name=>'CA.SEARCH'
,p_message_language=>'fr'
,p_message_text=>'Rechercher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277759851739867575)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Rechercher une application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277759942573867575)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_language=>'fr'
,p_message_text=>'Dialogue de recherche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277784031653867591)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_language=>'fr'
,p_message_text=>'Filtres de recherche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277766657650867580)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Cette page est g\00E9n\00E9r\00E9e \00E0 partir de la liste des composants partag\00E9s nomm\00E9e Tables recherch\00E9es.'),
'',
unistr('Toutes les pages Etat interactif g\00E9n\00E9r\00E9es initialement \00E0 partir de l''assistant Cr\00E9er une application sont automatiquement ajout\00E9es \00E0 la liste. '),
unistr('Pour ajouter vos propres tables \00E0 la liste et acc\00E9der aux composants partag\00E9s, s\00E9lectionnez Listes, puis cliquez sur Tables recherch\00E9es.'),
'  Saisissez les attributs suivants :',
unistr('    Entr\00E9e : Libell\00E9 d''entr\00E9e de liste - saisissez le nom d''affichage de la table.'),
unistr('    Cible : Page - s\00E9lectionnez la page appropri\00E9e \00E0 laquelle acc\00E9der (un \00E9tat interactif de pr\00E9f\00E9rence)'),
unistr('    Cible : Effacer le cache - saisissez les pages \00E0 effacer (g\00E9n\00E9ralement le m\00EAme nombre que celui entr\00E9 sous Page).'),
unistr('       Si vous acc\00E9dez \00E0 une page Etat interactif, ajoutez CIR,RIR pour effacer tout filtre existant, etc.'),
unistr('    Cible : D\00E9finir ces \00E9l\00E9ments - s\00E9lectionnez (ou saisissez) l''\00E9l\00E9ment de page appropri\00E9 \00E0 renseigner.'),
unistr('       Si vous acc\00E9dez \00E0 une page Etat interactif, saisissez IR_[COLUMN_NAME].'),
'    Cible : Avec ces valeurs - saisissez =PK=',
unistr('    Attributs d\00E9finis par l''utilisateur : 1 - saisissez le nom de table \00E0 rechercher en majuscules.'),
unistr('    Attributs d\00E9finis par l''utilisateur : 2 - saisissez le nom de colonne principale en majuscules.'),
unistr('    Attributs d\00E9finis par l''utilisateur : 3 (facultatif) - liste de colonnes \00E0 rechercher, s\00E9par\00E9es par des virgules.'),
unistr('       Si aucune colonne n''est indiqu\00E9e, toutes les colonnes de texte (varchar2) et CLOB sont recherch\00E9es.'),
'',
unistr('Remarque : les utilisateurs voient la liste des tables disponibles \00E0 rechercher uniquement si plusieurs tables sont r\00E9pertori\00E9es.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277759449581867575)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9sultats de la recherche')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277781699750867590)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne d''affichage secondaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277756028658867573)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le s\00E9lectionn\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276732444227866912)
,p_name=>'CA.SEND.BEGIN'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9but de l''envoi')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276732828173866912)
,p_name=>'CA.SEND.COUNT'
,p_message_language=>'fr'
,p_message_text=>'Nombre d''envois'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276732332089866912)
,p_name=>'CA.SEND.END'
,p_message_language=>'fr'
,p_message_text=>'Fin de l''envoi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276732774141866912)
,p_name=>'CA.SEND.ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur d''envoi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277787685655867594)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_language=>'fr'
,p_message_text=>'Envoyer des courriels'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277787777467867594)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9termine si des courriels doivent \00EAtre envoy\00E9s lors de la r\00E9ception de nouvelles informations en retour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277784325215867591)
,p_name=>'CA.SEND.FROM'
,p_message_language=>'fr'
,p_message_text=>'Adresse d''envoi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277776892895867587)
,p_name=>'CA.SEND.TO'
,p_message_language=>'fr'
,p_message_text=>unistr('Envoyer \00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277761347357867576)
,p_name=>'CA.SERIES'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9rie %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276872793039867001)
,p_name=>'CA.SESSION.ID'
,p_message_language=>'fr'
,p_message_text=>'ID de session'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277779373470867588)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_language=>'fr'
,p_message_text=>'Protection de statut de session'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277736564334867560)
,p_name=>'CA.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277736675519867561)
,p_name=>'CA.SETTINGS.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Sp\00E9cifiez les param\00E8tres utilis\00E9s dans la g\00E9n\00E9ration de l''application.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277760981607867576)
,p_name=>'CA.SHOW.ALL'
,p_message_language=>'fr'
,p_message_text=>'Afficher tout'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276633681552866849)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Afficher/Masquer la port\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277762088878867577)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_language=>'fr'
,p_message_text=>'Afficher le fuseau horaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277761887691867577)
,p_name=>'CA.SIGN.IN'
,p_message_language=>'fr'
,p_message_text=>'Ouvrir une session'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277763077313867578)
,p_name=>'CA.SIGN.OUT'
,p_message_language=>'fr'
,p_message_text=>'Fermer la session'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276872635536867001)
,p_name=>'CA.SLAVE.PID'
,p_message_language=>'fr'
,p_message_text=>'PID esclave'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276866639236866997)
,p_name=>'CA.SOURCE'
,p_message_language=>'fr'
,p_message_text=>'Source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277774956535867585)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_language=>'fr'
,p_message_text=>'Le type de source n''est pas un type valide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277766767118867580)
,p_name=>'CA.SOURCES'
,p_message_language=>'fr'
,p_message_text=>'Sources'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276869575415866999)
,p_name=>'CA.START.DATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Date de d\00E9but')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276871371271867000)
,p_name=>'CA.STATE'
,p_message_language=>'fr'
,p_message_text=>'Statut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277782574648867590)
,p_name=>'CA.STATICDEFAULT'
,p_message_language=>'fr'
,p_message_text=>unistr('Valeur par d\00E9faut statique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277745702782867566)
,p_name=>'CA.STATUS'
,p_message_language=>'fr'
,p_message_text=>'Statut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276867337742866998)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_language=>'fr'
,p_message_text=>unistr('Arr\00EAt \00E0 la fermeture de la fen\00EAtre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276867412850866998)
,p_name=>'CA.STORE.OUTPUT'
,p_message_language=>'fr'
,p_message_text=>'Sortie d''emplacement de stockage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277756239209867573)
,p_name=>'CA.SUBJECT'
,p_message_language=>'fr'
,p_message_text=>'Objet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277754950041867572)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_language=>'fr'
,p_message_text=>'Soumettre les informations en retour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277779655217867588)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Visualisation sugg\00E9r\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277771552492867583)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_language=>'fr'
,p_message_text=>'Objets de prise en charge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277771612480867583)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('<p>Saisissez le code dans le script d''installation, g\00E9n\00E9ralement pour cr\00E9er ou manipuler des objets de base de donn\00E9es ou effectuer des insertions/mises \00E0 jour/suppressions sur des enregistrements existants. Saisissez le code dans le script de d\00E9sins')
||unistr('tallation, g\00E9n\00E9ralement pour enlever (supprimer) des objets de base de donn\00E9es. Ces scripts sont incorpor\00E9s dans les objets de prise en charge afin que les m\00EAmes mises \00E0 jour soient r\00E9alis\00E9es dans vos environnements de test et de production lorsque v')
||'ous exportez l''application.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277771763680867583)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Saisissez dans le script d''installation des instructions SQL et/ou PL/SQL valides qui sont ex\00E9cut\00E9es lors de l''import de l''application.</p>'),
unistr('<p>Si vous voulez que les instructions soient \00E9galement ex\00E9cut\00E9es dans l''environnement en cours, et pas uniquement lorsque l''application est import\00E9e dans un autre environnement, cliquez sur <strong>Ex\00E9cuter lors de la cr\00E9ation de l''application</stro')
||'ng>.</p>',
unistr('<p>Saisissez dans le script de d\00E9sinstallation des instructions SQL et/ou PL/SQL qui sont ex\00E9cut\00E9es lors de la suppression de l''application d''App Builder.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276866975193866997)
,p_name=>'CA.SYSTEM'
,p_message_language=>'fr'
,p_message_text=>unistr('Syst\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277781005038867589)
,p_name=>'CA.TABLE'
,p_message_language=>'fr'
,p_message_text=>'Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277737338912867561)
,p_name=>'CA.TABLE.PREFIX'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9fixe d''objet de structure')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277737427600867561)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Entrez un pr\00E9fixe d''objet \00E0 utiliser dans l''application. Certaines fonctions ajoutent ce pr\00E9fixe aux objets de base de donn\00E9es qu''elles cr\00E9ent (y compris les packages et les tables).</p>'),
unistr('<p>Avertissement : assurez-vous que vous indiquez un pr\00E9fixe unique qui n''est pas utilis\00E9 par d''autres applications. S''il n''est pas unique, l''application est susceptible de g\00E9n\00E9rer des erreurs lors de sa cr\00E9ation et de ne pas fonctionner correctement')
||'.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277781902679867590)
,p_name=>'CA.TABLECOLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne de table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277776903884867587)
,p_name=>'CA.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277759364579867575)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce nom de mod\00E8le est d\00E9j\00E0 attribu\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277756143636867573)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277744884314867566)
,p_name=>'CA.TEXT'
,p_message_language=>'fr'
,p_message_text=>'Texte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276732655716866912)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_language=>'fr'
,p_message_text=>'Taille du corps de texte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277757338163867574)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de texte')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277743024657867565)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9f\00E9rence de th\00E8me de l''utilisateur final')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277743233709867565)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Si cette option est s\00E9lectionn\00E9e, les utilisateurs finals peuvent choisir leur propre style de th\00E8me \00E0 l''aide du lien Personnaliser.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277743102248867565)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_language=>'fr'
,p_message_text=>unistr('Autoriser les utilisateurs finals \00E0 choisir le style de th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277727482836867555)
,p_name=>'CA.THEME.SELECTOR'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lection du style de th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277725863718867554)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre \00E0 jour la pr\00E9sentation par d\00E9faut de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277727514890867555)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Permet aux administrateurs de s\00E9lectionner un sch\00E9ma de couleur (style de th\00E8me) par d\00E9faut pour l''application. Les administrateurs peuvent \00E9galement d\00E9cider de permettre aux utilisateurs finals de choisir leur propre style de th\00E8me. Il suffit aux')
||unistr(' utilisateurs finals de cliquer sur le bouton <em>Personnaliser</em> situ\00E9 en bas de la page d''accueil, et de choisir parmi les styles de th\00E8me disponibles. Par exemple, les utilisateurs souffrant d''une d\00E9ficience visuelle pourront pr\00E9f\00E9rer le style ')
||unistr('de th\00E8me <em>Vista</em> qui pr\00E9sente un contraste de couleurs tr\00E8s marqu\00E9.</p>'),
'<p>Comprend les composants suivants :',
'<ul>',
unistr('<li>Possibilit\00E9 pour les administrateurs de d\00E9finir le style de th\00E8me par d\00E9faut</li>'),
unistr('<li>Possibilit\00E9 pour les utilisateurs finals de s\00E9lectionner diff\00E9rents styles de th\00E8me</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277735957669867560)
,p_name=>'CA.THEME.STYLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Style de th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277736004479867560)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>S\00E9lectionnez le style de th\00E8me par d\00E9faut utilis\00E9 pour afficher l''application.</p>'),
unistr('<p>Le style peut facilement \00EAtre remplac\00E9 par un autre style pr\00E9d\00E9fini ou modifi\00E9 suite \00E0 la g\00E9n\00E9ration. Pour modifier le style, ex\00E9cutez l''application, puis cliquez sur <strong>Theme Roller</strong> dans la barre d''outils de d\00E9veloppeur.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277750043214867569)
,p_name=>'CA.TIME'
,p_message_language=>'fr'
,p_message_text=>'Temps'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277741708459867564)
,p_name=>'CA.TIME.ZONE'
,p_message_language=>'fr'
,p_message_text=>'Fuseau horaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277728537498867555)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_language=>'fr'
,p_message_text=>'Prise en charge de fuseaux horaires'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277725484242867553)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir le fuseau horaire par d\00E9faut et celui de l''utilisateur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277728200823867555)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Autoriser les utilisateurs finals \00E0 d\00E9finir leur fuseau horaire local. Cette fonction est importante si les tables de votre application utilisent des types de date d\00E9pendant des fuseaux horaires (tels que TIMESTAMP WITH LOCAL TIME ZONE) afin que l')
||unistr('es \00E9tats et les entr\00E9es de donn\00E9es indiquent l''emplacement des utilisateurs finals.</p>'),
'<p>Comprend les composants suivants :',
'<ul>',
unistr('<li>Possibilit\00E9 pour les administrateurs de d\00E9finir le fuseau horaire par d\00E9faut</li>'),
unistr('<li>Possibilit\00E9 pour les utilisateurs finals de s\00E9lectionner leur pr\00E9f\00E9rence de fuseau horaire</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277784961607867592)
,p_name=>'CA.TIMEFRAME'
,p_message_language=>'fr'
,p_message_text=>'Tranche de temps'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277785200257867592)
,p_name=>'CA.TIMELINE'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une page de cadre temporel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277785396719867592)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une page qui affiche une chronologie, particuli\00E8rement utile pour afficher les mises \00E0 jour.</p>'),
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de page</strong> (obligatoire) : saisissez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
unistr('  <li><strong>Table ou vue</strong> (obligatoire) : s\00E9lectionnez l''objet de base de donn\00E9es pour la chronologie.</li>'),
unistr('  <li><strong>Nom utilisateur</strong> (obligatoire) : s\00E9lectionnez la colonne dans la table ou la vue \00E0 utiliser en tant qu''utilisateur affich\00E9 pour les entr\00E9es de la chronologie.</li>'),
unistr('  <li><strong>Date</strong> (obligatoire) : s\00E9lectionnez la colonne dans la table ou la vue \00E0 utiliser en tant que date pour les entr\00E9es de la chronologie.</li>'),
unistr('  <li><strong>Nom d''\00E9v\00E9nement</strong> (obligatoire) : s\00E9lectionnez la colonne dans la table ou la vue \00E0 utiliser comme titre pour les entr\00E9es de la chronologie.</li>'),
unistr('  <li><strong>Description</strong> : s\00E9lectionnez la colonne dans la table ou la vue \00E0 utiliser comme description pour les entr\00E9es de la chronologie.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277746985329867567)
,p_name=>'CA.TIMESTAMP'
,p_message_language=>'fr'
,p_message_text=>'Horodatage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277751527059867570)
,p_name=>'CA.TITLE'
,p_message_language=>'fr'
,p_message_text=>'Titre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276733278541866912)
,p_name=>'CA.TO'
,p_message_language=>'fr'
,p_message_text=>'A'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277750784785867570)
,p_name=>'CA.TOP.USERS'
,p_message_language=>'fr'
,p_message_text=>'Principaux utilisateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277750885911867570)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_language=>'fr'
,p_message_text=>'Graphique des principaux utilisateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277748370991867568)
,p_name=>'CA.TOTAL.ROWS'
,p_message_language=>'fr'
,p_message_text=>'Nombre total de lignes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277752758750867571)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00F4le par d\00E9faut pour les utilisateurs ne figurant pas dans la liste de contr\00F4le d''acc\00E8s :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277744934308867566)
,p_name=>'CA.TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276963856556867060)
,p_name=>'CA.UI.DEFAULTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Valeurs par d\00E9faut d''interface utilisateur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276963998605867060)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finissez des valeurs par d\00E9faut pour les param\00E8tres d''interface utilisateur, tels que le nombre de lignes par page, et ajoutez la liste des d\00E9finitions de valeur. Ces param\00E8tres sont utilis\00E9s lors de la g\00E9n\00E9ration de composants au sein de l''applica')
||'tion. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277745111843867566)
,p_name=>'CA.UNTIL'
,p_message_language=>'fr'
,p_message_text=>'A'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277016879293867093)
,p_name=>'CA.UPDATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre \00E0 jour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277754504628867572)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre \00E0 jour le profil')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277745417214867566)
,p_name=>'CA.UPDATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Mis \00E0 jour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277745524183867566)
,p_name=>'CA.UPDATED.BY'
,p_message_language=>'fr'
,p_message_text=>unistr('Mis \00E0 jour par')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277746852579867567)
,p_name=>'CA.USER'
,p_message_language=>'fr'
,p_message_text=>'Utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277774499840867585)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_language=>'fr'
,p_message_text=>'Ajouter plusieurs utilisateurs - Etape 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277774578972867585)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_language=>'fr'
,p_message_text=>'Ajouter plusieurs utilisateurs - Etape 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277774640798867585)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_language=>'fr'
,p_message_text=>'Ajouter plusieurs utilisateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277749221780867569)
,p_name=>'CA.USER.AGENT'
,p_message_language=>'fr'
,p_message_text=>'Agent utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277762666345867577)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_language=>'fr'
,p_message_text=>'Etat sur le nombre d''utilisateurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277751010871867570)
,p_name=>'CA.USER.NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277753583993867571)
,p_name=>'CA.USER.PROFILE'
,p_message_language=>'fr'
,p_message_text=>'Profil utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277728446118867555)
,p_name=>'CA.USER.PROFILES'
,p_message_language=>'fr'
,p_message_text=>'Profils utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277725389335867553)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Autoriser les utilisateurs \00E0 mettre \00E0 jour leur profil')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277728338834867555)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Autoriser les utilisateurs finals \00E0 indiquer des informations suppl\00E9mentaires les concernant, y compris une image ou un avatar, pour personnaliser leur compte.</p>'),
'<p>Comprend les composants suivants :',
'<ul>',
unistr('<li>Page de configuration permettant aux utilisateurs finals de param\00E9trer leur profil</li>'),
unistr('<li>Possibilit\00E9 de t\00E9l\00E9charger une photo/un avatar</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277753796203867571)
,p_name=>'CA.USERNAME'
,p_message_language=>'fr'
,p_message_text=>'Nom utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277752873149867571)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Format de nom utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277775362817867586)
,p_name=>'CA.USERNAMES'
,p_message_language=>'fr'
,p_message_text=>'Noms utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276971572123867064)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Format de nom utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277775988885867586)
,p_name=>'CA.USERS.ADDED'
,p_message_language=>'fr'
,p_message_text=>unistr('Utilisateurs ajout\00E9s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277777419378867587)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Utilisateurs par r\00F4le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277756987240867574)
,p_name=>'CA.USERS.INCLUDED'
,p_message_language=>'fr'
,p_message_text=>'Utilisateurs inclus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277775620778867586)
,p_name=>'CA.USERS.TO.ADD'
,p_message_language=>'fr'
,p_message_text=>unistr('Utilisateurs \00E0 ajouter')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277753089693867571)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Format de nom utilisateur mis \00E0 jour.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276653857514866862)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'fr'
,p_message_text=>'Il existe des utilisateurs valides - Infos sur la page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277768633729867581)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ID d''application existe d\00E9j\00E0 ou est r\00E9serv\00E9 pour une autre application.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276912128640867026)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('Le nom d''application doit \00EAtre indiqu\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277778065846867587)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('Doit fournir les adresses \00E9lectroniques auxquelles envoyer le courriel.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277777898303867587)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('Doit fournir les adresses \00E9lectroniques ou s\00E9lectionner un ensemble d''utilisateurs auquel envoyer le courriel.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277777984831867587)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_language=>'fr'
,p_message_text=>unistr('Doit s\00E9lectionner un ensemble d''utilisateurs auquel envoyer le courriel.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277768737746867581)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_language=>'fr'
,p_message_text=>unistr('Le pr\00E9fixe de table ne doit pas comporter plus de six caract\00E8res, doit commencer par une lettre et ne doit contenir que des lettres, des nombres et des traits de soulignement.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277768812780867581)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_language=>'fr'
,p_message_text=>unistr('Saisissez un autre pr\00E9fixe de table. Les objets de base de donn\00E9es suivants existent d\00E9j\00E0 : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277753404411867571)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Le format d''adresse \00E9lectronique du nom utilisateur n''est pas valide. Reportez-vous au format de nom utilisateur de l''application ci-dessous.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277753308832867571)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_language=>'fr'
,p_message_text=>unistr('V\00E9rifier le format de courriel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277750902806867570)
,p_name=>'CA.VIEW.AS'
,p_message_language=>'fr'
,p_message_text=>'Visualiser comme'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277772378763867584)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_language=>'fr'
,p_message_text=>unistr('Afficher le mod\00E8le de base')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277760858514867576)
,p_name=>'CA.VIEW.DETAILS'
,p_message_language=>'fr'
,p_message_text=>unistr('Voir les d\00E9tails')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277778220079867588)
,p_name=>'CA.VIEW.EMAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Visualiser les param\00E8tres de messagerie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277762962342867577)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_language=>'fr'
,p_message_text=>'Afficher mon profil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277747814090867568)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_language=>'fr'
,p_message_text=>unistr('Performances pond\00E9r\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277782828902867591)
,p_name=>'CA.WIDTH'
,p_message_language=>'fr'
,p_message_text=>'Largeur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277787060696867593)
,p_name=>'CA.WIZARD'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er des pages d''assistant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276653728421866862)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_language=>'fr'
,p_message_text=>'Conteneur d''assistant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277787161514867593)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Cr\00E9ez une collection de pages \00E0 utiliser en tant qu''assistant. Les assistants sont g\00E9n\00E9ralement utilis\00E9s pour la saisie de donn\00E9es dans plusieurs \00E9tapes.</p>'),
'<p>Indiquez les attributs suivants :</p>',
'<ul>',
'  <li><strong>Nom de l''assistant</strong> (obligatoire) : saisissez le nom de la page.</li>',
unistr('  <li><strong>D\00E9finir l''ic\00F4ne</strong> : s\00E9lectionnez une ic\00F4ne \00E0 afficher dans le menu de navigation pour cette page.</li>'),
unistr('  <li><strong>Mode de page</strong> (obligatoire) : d\00E9terminez si les \00E9tapes de l''assistant seront affich\00E9es comme des pages modales ou normales. S\00E9lectionnez <strong>Page modale</strong> ou <strong>Pleine page</strong>.</li>'),
unistr('  <li><strong>Etape 1 ... 8</strong> : saisissez le nom de la page pour les \00E9tapes de l''assistant.<br><em><strong>Remarque :</strong> les \00E9tapes 5 \00E0 8 s''affichent \00E0 mesure qu''un nom est saisi pour chaque \00E9tape pr\00E9c\00E9dente.</em></li>'),
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277751341540867570)
,p_name=>'CA.WORK.PHONE'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9phone professionnel')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277744054446867565)
,p_name=>'CA.YELLOW'
,p_message_language=>'fr'
,p_message_text=>'Jaune'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276964460161867060)
,p_name=>'CA.YES'
,p_message_language=>'fr'
,p_message_text=>'Oui'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276498784879866761)
,p_name=>'CACHED'
,p_message_language=>'fr'
,p_message_text=>unistr('Mis en m\00E9moire cache')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276382453580866684)
,p_name=>'CACHE_CREATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Cache cr\00E9\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276369997363866676)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('La fonction de suppression des donn\00E9es est d\00E9sactiv\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276354483399866667)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('La fonction d''ajout de donn\00E9es est d\00E9sactiv\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276354509656866667)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('La fonction de mise \00E0 jour des donn\00E9es est d\00E9sactiv\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276537791270866787)
,p_name=>'CALENDAR.NEXT'
,p_message_language=>'fr'
,p_message_text=>'Suivant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276537691837866787)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9c\00E9dent')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276395315000866692)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Calendrier simple'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277558815343867446)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier une entr\00E9e de calendrier')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276343077537866660)
,p_name=>'CALENDAR_POPUP'
,p_message_language=>'fr'
,p_message_text=>unistr('Calendrier instantan\00E9 pour %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276493558409866758)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('La cr\00E9ation du calendrier a r\00E9ussi.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276896354179867016)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de calendrier h\00E9rit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276395258706866691)
,p_name=>'CALENDAR_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Calendrier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276746858159866921)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun mod\00E8le de calendrier trouv\00E9 lors de la tentative de copie depuis l''application %0 et l''ID de mod\00E8le %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276897701205867017)
,p_name=>'CANCEL'
,p_message_language=>'fr'
,p_message_text=>'Annuler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276336132155866656)
,p_name=>'CANDLESTICK'
,p_message_language=>'fr'
,p_message_text=>'En chandelier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277232422564867235)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_language=>'fr'
,p_message_text=>'Feuilles de style CSS'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276953882595867053)
,p_name=>'CENTER'
,p_message_language=>'fr'
,p_message_text=>'Au centre'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276987963973867075)
,p_name=>'CHANGES'
,p_message_language=>'fr'
,p_message_text=>'Modifications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277618027326867484)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_language=>'fr'
,p_message_text=>'Modifier authentification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276892107749867014)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier la taille de la base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276510338233866769)
,p_name=>'CHANGE_PW_REQUEST'
,p_message_language=>'fr'
,p_message_text=>'Demande %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276891952006867013)
,p_name=>'CHANGE_REQUEST'
,p_message_language=>'fr'
,p_message_text=>'Demande de modification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277179675595867201)
,p_name=>'CHANGE_WORKSPACE'
,p_message_language=>'fr'
,p_message_text=>'Modifier l''espace de travail'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276863982912866995)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de jeu de caract\00E8res')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276589276114866821)
,p_name=>'CHART'
,p_message_language=>'fr'
,p_message_text=>'graphique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276341479117866659)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('La requ\00EAte de graphique n''est pas valide : %0<br><br>'),
'Utilisez la syntaxe suivante :',
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>Texte accompagnant la barre</td></tr>',
unistr('<tr><td>VALUE</td><td>Colonne num\00E9rique d\00E9finissant la taille de la barre</td></tr>'),
'</table>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276532564505866784)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Requ\00EAte de graphique non valide.<br /><br /> Utilisez la syntaxe suivante : <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'),
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
unistr('<td>Colonne num\00E9rique d\00E9finissant la valeur de cadran.</td>'),
'</tr>',
'<tr>',
'<td>MAX</td>',
unistr('<td>Colonne num\00E9rique d\00E9finissant la valeur maximale de cadran.</td>'),
'</tr>',
'<tr>',
'<td>LOW (facultatif)</td>',
unistr('<td>Colonne num\00E9rique d\00E9finissant la valeur minimale pr\00E9c\00E9dente de cadran.</td>'),
'</tr>',
'<tr>',
'<td>HIGH (facultatif)</td>',
unistr('<td>Colonne num\00E9rique d\00E9finissant la valeur maximale pr\00E9c\00E9dente de cadran.</td>'),
'</tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276607443145866832)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_language=>'fr'
,p_message_text=>'Type de graphique non valide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276341392763866659)
,p_name=>'CHART.INVALID_QUERY'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Echec de l''analyse de la requ\00EAte SQL.'),
'<p>%0</p>',
unistr('Certaines requ\00EAtes ne peuvent \00EAtre lanc\00E9es que lorsque votre application est en cours d''ex\00E9cution. Si la syntaxe de votre requ\00EAte est correcte, vous pouvez enregistrer celle-ci sans validation (voir les options sous la source de la requ\00EAte).')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277673264415867520)
,p_name=>'CHART_DEGREES'
,p_message_language=>'fr'
,p_message_text=>unistr('degr\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276840835756866981)
,p_name=>'CHART_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Graphique de %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276370775170866677)
,p_name=>'CHART_SERIES'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9rie de graphiques')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276888492457867011)
,p_name=>'CHART_SERIES_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur de s\00E9rie de graphiques %0 pour %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276486781055866754)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('La cr\00E9ation du graphique a r\00E9ussi.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276446072845866726)
,p_name=>'CHECK$'
,p_message_language=>'fr'
,p_message_text=>unistr('s\00E9lecteur de ligne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277605721014867476)
,p_name=>'CHECKED'
,p_message_language=>'fr'
,p_message_text=>unistr('s\00E9lectionn\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276844795688866983)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Checksum requis - niveau application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276661248303866866)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_language=>'fr'
,p_message_text=>'Checksum requis - niveau session'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276661196174866866)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_language=>'fr'
,p_message_text=>'Checksum requis - niveau utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276661007574866866)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_language=>'fr'
,p_message_text=>'Checksum requis - niveau application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277675657283867521)
,p_name=>'CHECK_ALL'
,p_message_language=>'fr'
,p_message_text=>'Cocher tout'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276828720732866973)
,p_name=>'CLASSIC_CALENDAR'
,p_message_language=>'fr'
,p_message_text=>'Calendrier classique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276831713636866975)
,p_name=>'CLASSIC_REPORT'
,p_message_language=>'fr'
,p_message_text=>'Etat classique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276531057911866783)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes d''\00E9tat classique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276829391719866973)
,p_name=>'CLASSIC_TREE'
,p_message_language=>'fr'
,p_message_text=>'Arborescence classique'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276827545992866972)
,p_name=>'CLEAN_UP'
,p_message_language=>'fr'
,p_message_text=>'Nettoyer la page'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276364902258866673)
,p_name=>'CLEAR_COMMAND'
,p_message_language=>'fr'
,p_message_text=>'Commande CLEAR'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276837436097866979)
,p_name=>'CLOSED'
,p_message_language=>'fr'
,p_message_text=>unistr('Ferm\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276885071045867009)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ferm\00E9 au cours des 7 derniers jours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276650713909866860)
,p_name=>'CLOSE_WINDOW'
,p_message_language=>'fr'
,p_message_text=>unistr('Fermer la fen\00EAtre')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277769213781867582)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'fr'
,p_message_text=>'Fermer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277770930589867583)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'fr'
,p_message_text=>'Rechercher'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277769192886867582)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'fr'
,p_message_text=>'Rechercher'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277770871080867583)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'fr'
,p_message_text=>'Rechercher le suivant'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277770771197867583)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'fr'
,p_message_text=>unistr('Rechercher pr\00E9c\00E9dent')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277770514748867582)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'fr'
,p_message_text=>unistr('Ex\00E9cution automatique')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277769881325867582)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'fr'
,p_message_text=>'Taille de retrait'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277770020797867582)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'fr'
,p_message_text=>'Espaces d''insertions de tabulation'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277769483969867582)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'fr'
,p_message_text=>'Respecter la casse'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277769351067867582)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'fr'
,p_message_text=>unistr('Expression r\00E9guli\00E8re')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277774355663867585)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_language=>'fr'
,p_message_text=>unistr('Concepteur de requ\00EAtes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277771061716867583)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9tablir')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277770663417867582)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'fr'
,p_message_text=>'Remplacer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277768951931867581)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'fr'
,p_message_text=>'Tout remplacer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277769076814867581)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'fr'
,p_message_text=>'Remplacer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277771316356867583)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'fr'
,p_message_text=>'Ignorer'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277770370313867582)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277769610346867582)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'fr'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277770174831867582)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'fr'
,p_message_text=>unistr('Afficher les num\00E9ros de ligne')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277769511442867582)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'fr'
,p_message_text=>unistr('Afficher la r\00E8gle')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277769980113867582)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'fr'
,p_message_text=>'Taille de tabulation'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277769721481867582)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'fr'
,p_message_text=>unistr('Th\00E8mes')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277771194995867583)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'fr'
,p_message_text=>'Annuler'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277770272410867582)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'fr'
,p_message_text=>unistr('Utiliser l''\00E9diteur de texte brut')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277770467940867582)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'fr'
,p_message_text=>'Valider'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277771258243867583)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Validation effectu\00E9e')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276767676002866934)
,p_name=>'COLLAPSE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9duire ')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276378206986866681)
,p_name=>'COLOR_PALETTE'
,p_message_language=>'fr'
,p_message_text=>'Combinaison de couleurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276604088904866830)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_language=>'fr'
,p_message_text=>'Analogique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276603602959866830)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_language=>'fr'
,p_message_text=>unistr('Compl\00E9mentaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276604240550866830)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_language=>'fr'
,p_message_text=>unistr('Couleurs compl\00E9mentaires')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276604162858866830)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_language=>'fr'
,p_message_text=>'Monotone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276603717391866830)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_language=>'fr'
,p_message_text=>unistr('Fractionnement compl\00E9mentaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276603987172866830)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9trade')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276603882048866830)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_language=>'fr'
,p_message_text=>'Triade'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277224512328867230)
,p_name=>'COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277660629792867512)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Nom d''affichage : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276759992708866929)
,p_name=>'COLUMN_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de colonne'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276965640027867061)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_language=>'fr'
,p_message_text=>unistr('Tous les utilisateurs authentifi\00E9s peuvent acc\00E9der \00E0 cette application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276965731272867061)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_language=>'fr'
,p_message_text=>unistr('Seuls les utilisateurs d\00E9finis dans la liste de contr\00F4le d''acc\00E8s de l''application peuvent acc\00E9der \00E0 l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276965856312867061)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_language=>'fr'
,p_message_text=>unistr('Valeur de param\00E8tre de contr\00F4le d''acc\00E8s inattendue : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276371667738866677)
,p_name=>'COMING_SOON'
,p_message_language=>'fr'
,p_message_text=>unistr('Bient\00F4t disponible')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276760471199866930)
,p_name=>'COMMENT'
,p_message_language=>'fr'
,p_message_text=>'Commentaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276897971944867017)
,p_name=>'COMMENTS'
,p_message_language=>'fr'
,p_message_text=>'Commentaires'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276651990273866861)
,p_name=>'COMPILE_FAILURE'
,p_message_language=>'fr'
,p_message_text=>unistr('La compilation a \00E9chou\00E9, ligne <a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276981913321867071)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_language=>'fr'
,p_message_text=>unistr('La compilation a \00E9chou\00E9, ligne %0 (%2). Les num\00E9ros de ligne associ\00E9s aux erreurs de compilation concernent la premi\00E8re instruction BEGIN. Seule la compilation des d\00E9clencheurs de base de donn\00E9es est affect\00E9e.<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276651849151866860)
,p_name=>'COMPILE_SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Le code PL/SQL a \00E9t\00E9 compil\00E9 avec succ\00E8s (%0).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276834746104866977)
,p_name=>'COMPLETE'
,p_message_language=>'fr'
,p_message_text=>unistr('Termin\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276842160267866982)
,p_name=>'COMPLETED'
,p_message_language=>'fr'
,p_message_text=>unistr('Termin\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276849183848866986)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_language=>'fr'
,p_message_text=>unistr('Termin\00E9/Aucun probl\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276885660917867009)
,p_name=>'COMPONENT'
,p_message_language=>'fr'
,p_message_text=>'Composant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277042477292867112)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Nom du composant : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277313785078867288)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_language=>'fr'
,p_message_text=>unistr('Composant non activ\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276490233741866756)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('Le composant a \00E9t\00E9 cr\00E9\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277655905434867509)
,p_name=>'COMPONENT_SUMMARY'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9capitulatif de composant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276433494847866717)
,p_name=>'COMPUTATIONS'
,p_message_language=>'fr'
,p_message_text=>'Calculs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276909181523867024)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('Les composants d''application ont \00E9t\00E9 install\00E9s.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276652595214866861)
,p_name=>'CONDITIONAL'
,p_message_language=>'fr'
,p_message_text=>'Conditionnel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276742468761866918)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_language=>'fr'
,p_message_text=>unistr('liste de valeurs (LOV) instantan\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276826293880866971)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_language=>'fr'
,p_message_text=>'toujours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276562252486866804)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276561716436866804)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_language=>'fr'
,p_message_text=>unistr('\00E9l\00E9ment/colonne = valeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276561890804866804)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('\00E9l\00E9ment/colonne NOT NULL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277527855016867426)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_language=>'fr'
,p_message_text=>unistr('\00E9l\00E9ment/colonne NULL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276562391421866804)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_language=>'fr'
,p_message_text=>'jamais'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276562481365866804)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_language=>'fr'
,p_message_text=>'aucun'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276562057338866804)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_language=>'fr'
,p_message_text=>'page dans'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276562155143866804)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_language=>'fr'
,p_message_text=>'la page n''est pas dans'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276561661808866804)
,p_name=>'CONDITIONS_SHORTCUT_PLSQL'
,p_message_language=>'fr'
,p_message_text=>'PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276561935927866804)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_language=>'fr'
,p_message_text=>'demande=e1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276573538804866811)
,p_name=>'CONDITION_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type de condition'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276787626514866947)
,p_name=>'CONFIRM'
,p_message_language=>'fr'
,p_message_text=>'Confirmer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276337917858866657)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Deux pages ma\00EEtre-d\00E9tail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276337849998866657)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Trois pages ma\00EEtre-d\00E9tail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276548282308866795)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom r\00E9el')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276833943098866977)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes d''agr\00E9gation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276834038840866977)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Fonctions d''agr\00E9gation \00E0 utiliser')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276545669687866793)
,p_name=>'CONFIRM.APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276559042444866802)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_language=>'fr'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276559146742866802)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_language=>'fr'
,p_message_text=>unistr('Langue par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276558914524866802)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276440118276866722)
,p_name=>'CONFIRM.ARRAY'
,p_message_language=>'fr'
,p_message_text=>unistr('Arborescence de r\00E9sultats \00E0 communiquer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276440291454866722)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de r\00E9sultats \00E0 communiquer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276559248286866802)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_language=>'fr'
,p_message_text=>'Authentification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277025604966867099)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_language=>'fr'
,p_message_text=>'Branchement sur une page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276749804666866923)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes de section (BREAK)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276548038314866795)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_language=>'fr'
,p_message_text=>'Branchement de bouton %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276547939781866795)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_language=>'fr'
,p_message_text=>'Texte d''affichage du bouton %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276351696264866665)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer l''ajout de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276351526758866665)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer la fonction de glisser-d\00E9placer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276968068367867062)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_language=>'fr'
,p_message_text=>'Annuler le branchement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277025412882867099)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 du bouton Annuler')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277015977047867093)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_language=>'fr'
,p_message_text=>'Distinction maj/min'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276650284635866859)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 \00E0 modifier la requ\00EAte d''\00E9tat interactif. Si vous avez enlev\00E9 des colonnes de la requ\00EAte, les filtres, les r\00E8gles de mise en \00E9vidence et autres param\00E8tres d''\00E9tat r\00E9f\00E9ren\00E7ant ces colonnes seront d\00E9sactiv\00E9s. Validez votre demande.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276549144379866796)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_language=>'fr'
,p_message_text=>'Axe de graphique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276898287276867017)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_language=>'fr'
,p_message_text=>'A cadran'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276898383883867018)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_language=>'fr'
,p_message_text=>unistr('A cadran (\00E0 secteurs)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276549818008866796)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_language=>'fr'
,p_message_text=>'A barres horizontales'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276550089294866796)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_language=>'fr'
,p_message_text=>'A courbes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276549387584866796)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_language=>'fr'
,p_message_text=>unistr('Masque num\00E9rique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276549968063866796)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_language=>'fr'
,p_message_text=>'A secteurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276549024665866796)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAte de graphique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276549224617866796)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_language=>'fr'
,p_message_text=>'Echelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276550122247866796)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_language=>'fr'
,p_message_text=>'En nuage de points'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276549616921866796)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_language=>'fr'
,p_message_text=>'Taille de graphique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276549500058866796)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Titre de graphique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276549445821866796)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type de graphique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276549737077866796)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_language=>'fr'
,p_message_text=>'A barres verticales'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276440307693866722)
,p_name=>'CONFIRM.COLLECTION'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom d''ensemble de r\00E9sultats temporaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276546463863866794)
,p_name=>'CONFIRM.COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276749654502866923)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_language=>'fr'
,p_message_text=>unistr('En-t\00EAtes de colonne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276925512218867035)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276968297336867062)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_language=>'fr'
,p_message_text=>'Nom(s) de colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276558714138866802)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_language=>'fr'
,p_message_text=>unistr('Utiliser le tri d''en-t\00EAtes de colonne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276665420563866869)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la copie d''une application avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276557382167866801)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la copie d''une page avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276546997016866794)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_language=>'fr'
,p_message_text=>unistr('Un nouveau jeu d''onglets, "%0", sera cr\00E9\00E9 et utilis\00E9 par cette page.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276558827770866802)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une application avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276551418277866797)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page de calendrier avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276554683819866799)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page d''\00E9tat d''analsye descendante avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276614323299866837)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page d''\00E9tat interactif avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276557631638866801)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page d''\00E9tat avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276345224053866661)
,p_name=>'CONFIRM.CREATE_FLASH_CHART'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page de graphique Flash avec les attributs ci-apr\00E8s. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277631560653867493)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une application de base de donn\00E9es utilisant le m\00EAme ID qu''une application de base de donn\00E9es existante dans l''espace de travail en cours. L''application de base de donn\00E9es existante sera supprim\00E9e et remplac\00E9e par la n')
||unistr('ouvelle application de base de donn\00E9es. Confirmez vos s\00E9lections. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276922381859867033)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation de pages de panneau et de vue de liste avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276833656721866976)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page de panneau et d''une page d''\00E9tat avec des pages d''analyse. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276551017321866797)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''un panneau sur une requ\00EAte SQL avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276550997826866797)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''un panneau sur une proc\00E9dure stock\00E9e avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276550850812866797)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''un panneau sur une page de table avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276396388201866692)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''un panneau sur une page de r\00E9f\00E9rence de service Web avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276453143165866731)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''un panneau et d''un \00E9tat sur une page de r\00E9f\00E9rence de service Web avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276862963747866995)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page Carte avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276335308319866655)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation de pages ma\00EEtre-d\00E9tail avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276552636788866798)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une r\00E9gion de chemin de navigation et d''une option de chemin de navigation avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276840978475866981)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un mode')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276550699008866797)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277707067107867542)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er une page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277707106171867542)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un nom de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276553435130866798)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation de pages de panneau et d''\00E9tat avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277627456904867490)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276557469083866801)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page d''\00E9tat avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276551120747866797)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page de graphique \00E0 barres HTML avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276557054693866801)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page r\00E9capitulative avec les attributs suivants. Cliquez sur le bouton Ajouter d''autres pour ajouter d''autres \00E9l\00E9ments provenant d''autres pages et/ou d''autres r\00E9gions. Cliquez sur Fin pour cr\00E9er les \00E9l\00E9ments r\00E9capi')
||'tulatifs.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276551242386866797)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page de graphique SVG avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276550515761866797)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page de panneau tabulaire avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276551716219866797)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une page d''arborescence avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276550795804866797)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''un assistant avec les attributs suivants. Confirmez vos s\00E9lections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277631163310867492)
,p_name=>'CONFIRM.CREATE_WS_APP_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la cr\00E9ation d''une application Web utilisant le m\00EAme ID qu''une application Web existante dans l''espace de travail en cours. L''application Web existante sera supprim\00E9e et remplac\00E9e par la nouvelle application Web. Confirmez vos s\00E9lect')
||'ions. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276745454862866920)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 de lien')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277564133756867450)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de d\00E9finition de chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277638777052867497)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Cette d\00E9finition de chargement des donn\00E9es sera recr\00E9\00E9e avec les recherches de table et les r\00E8gles de transformation existantes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277016077705867093)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Num\00E9ro de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276551533098866797)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne de date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276841045866866981)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le d''authentification par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276550458682866797)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_language=>'fr'
,p_message_text=>'Supprimer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276555372504866800)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes d''affichage de %0 d\00E9tail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276338390233866657)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne(s) d''affichage d\00E9tail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276556982975866801)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de chemin de navigation d\00E9tail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276556119764866800)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_language=>'fr'
,p_message_text=>unistr('Table d\00E9tail %0 - ORDER BY')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276554899376866799)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Page de d\00E9tail %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276338235035866657)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Table d\00E9tail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276555104889866800)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de table d\00E9tail %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276554900161866799)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 d''onglet d\00E9tail %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276968505427867063)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de t\00E9l\00E9chargement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276548579802866795)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes d''affichage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276925288254867035)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de t\00E9l\00E9chargement 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276925300184867035)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de t\00E9l\00E9chargement 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276552846534866798)
,p_name=>'CONFIRM.DISPLAY_POINT'
,p_message_language=>'fr'
,p_message_text=>'Point d''affichage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277715969958867547)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Modifier une page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277716038791867547)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_language=>'fr'
,p_message_text=>'Modifier le nom de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276738311566866916)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_language=>'fr'
,p_message_text=>'Sortie CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276739007119866916)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_language=>'fr'
,p_message_text=>'Sortie d''impression'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276739641565866916)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer le tri d''en-t\00EAtes de colonne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276789544606866948)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Une r\00E9gion sera ajout\00E9e \00E0 la page Administration existante :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276968140811867062)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_language=>'fr'
,p_message_text=>'Terminer le branchement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276553932725866799)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Page de panneau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276554043441866799)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de page de panneau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276554271240866799)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 d''onglet de page de panneau')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276554125196866799)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_language=>'fr'
,p_message_text=>'Jeu d''onglets de page de panneau'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276841165873866981)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_language=>'fr'
,p_message_text=>unistr('Importer des composants partag\00E9s depuis')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277298655725867278)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_language=>'fr'
,p_message_text=>unistr('Inclure le calendrier personnalis\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276338530739866657)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Inclure l''\00E9tat ma\00EEtre ?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276556685948866800)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_language=>'fr'
,p_message_text=>'Inclure un chemin de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276547720770866795)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le d''information')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276547854935866795)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Texte par d\00E9faut d''information')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276396581050866692)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments de panneau')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276440586405866722)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de r\00E9gion de panneau')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276440425793866722)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Titre de r\00E9gion de panneau')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276550269490866796)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ins\00E9rer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276547573678866795)
,p_name=>'CONFIRM.ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276968405405867062)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne renvoy\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276967342219867062)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne 1 de cl\00E9 de recherche')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276967421643867062)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de cl\00E9 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276967503565867062)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de cl\00E9 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276551605903866797)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de libell\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276925420735867035)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire de la recherche')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276968380172867062)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_language=>'fr'
,p_message_text=>'Table de consultation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276338617135866657)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9sentation ma\00EEtre-d\00E9tail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276338106402866657)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne(s) d''affichage ma\00EEtre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276338413495866657)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Atteindre l''enregistrement ma\00EEtre par')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276338047674866657)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Table ma\00EEtre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276749725774866923)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Nombre maximal de colonnes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276745266060866920)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_language=>'fr'
,p_message_text=>'Lignes par page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276623012795866842)
,p_name=>'CONFIRM.MENU'
,p_message_language=>'fr'
,p_message_text=>'Chemin de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276553103785866798)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_language=>'fr'
,p_message_text=>'Lien de chemin de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276556718288866801)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_language=>'fr'
,p_message_text=>'Racine de chemin de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276552990477866798)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de chemin de navigation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276553271353866798)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_language=>'fr'
,p_message_text=>'Texte de chemin de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276470800144866743)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la mise \00E0 niveau du graphique Flash vers un nouveau graphique Flash 6. Confirmez votre demande.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276834816546866977)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6_XML'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la mise \00E0 niveau du graphique Flash bas\00E9 sur un code XML personnalis\00E9 vers un nouveau graphique Flash 6. En raison de diff\00E9rences de structure XML entre le graphique en cours et le nouveau graphique Flash 6, le graphique mis \00E0 nivea')
||unistr('u ne sera pas affich\00E9. Pour pouvoir utiliser la nouvelle structure XML, vous devrez modifier le code XML personnalis\00E9 du graphique mis \00E0 niveau. Confirmez votre demande.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276409114142866701)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la mise \00E0 niveau du graphique Flash vers un nouveau graphique HTML5. Confirmez votre demande.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276409247553866701)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5_XML'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la mise \00E0 niveau du graphique Flash bas\00E9 sur un code XML personnalis\00E9 vers un nouveau graphique HTML5. En raison de diff\00E9rences de structure XML entre le graphique en cours et le graphique HTML5, le graphique mis \00E0 niveau ne sera pa')
||unistr('s affich\00E9. Pour pouvoir utiliser la nouvelle structure XML, vous devrez modifier le code XML personnalis\00E9 du graphique mis \00E0 niveau. Confirmez votre demande.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276409035667866700)
,p_name=>'CONFIRM.MIGRATE_HTML_TO_HTML5'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la mise \00E0 niveau du graphique HTML vers un nouveau graphique HTML5. Confirmez votre demande.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277651971728867506)
,p_name=>'CONFIRM.MIGRATE_JSTREE_TO_APEXTREE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la mise \00E0 niveau de jsTree vers une nouvelle arborescence. Confirmez votre demande.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276536913827866786)
,p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('La mise \00E0 niveau des graphiques SVG sera r\00E9alis\00E9e avec les restrictions suivantes :  '),
'<ul>',
'<li>',
unistr('Seuls les formats num\00E9riques d\00E9finis dans les cha\00EEnes de format des axes seront migr\00E9s. Les formats de date et d''heure seront ignor\00E9s.'),
'</li>',
'<li>',
unistr('Les \00E9l\00E9ments de format num\00E9rique contenant les \00E9l\00E9ments suivants seront migr\00E9s :'),
'<br />',
'0, 9, D, G, , (virgule), . (point), $, C, L, FM',
'</li>',
'<li>',
unistr('Le libell\00E9 de chaque s\00E9rie du graphique Flash sera d\00E9termin\00E9 \00E0 partir de l''alias de colonne de chaque s\00E9rie.  '),
unistr('C''est l\00E0 une diff\00E9rence par rapport aux graphiques SVG, o\00F9 le libell\00E9 de chaque s\00E9rie \00E9tait d\00E9termin\00E9 \00E0 partir de l''attribut Nom de s\00E9rie.'),
'</li>',
'<li>',
unistr('Les graphiques \00E0 cadran Flash affichent les valeurs elles-m\00EAmes et non des pourcentages.'),
'</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276492035970866757)
,p_name=>'CONFIRM.MIGRATE_SVG_TO_HTML5'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 la mise \00E0 niveau du graphique SVG vers un graphique HTML5. Confirmez votre demande.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277627281948867490)
,p_name=>'CONFIRM.NAVIGATION'
,p_message_language=>'fr'
,p_message_text=>'Navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276559579105866802)
,p_name=>'CONFIRM.NAV_BAR'
,p_message_language=>'fr'
,p_message_text=>'Barre de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277277498767867264)
,p_name=>'CONFIRM.NAV_LIST'
,p_message_language=>'fr'
,p_message_text=>'Liste de menu de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276852708398866989)
,p_name=>'CONFIRM.NEW_ADMIN_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Une nouvelle page Administration sera ajout\00E9e, Page :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276650495646866860)
,p_name=>'CONFIRM.NEW_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Nouvelles colonnes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276548356825866795)
,p_name=>'CONFIRM.NEW_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Nouveau mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277025292759867099)
,p_name=>'CONFIRM.NEXT_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 du bouton Suivant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276546810515866794)
,p_name=>'CONFIRM.NO.TABSET.SELECTED'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun jeu d''onglets n''a \00E9t\00E9 s\00E9lectionn\00E9 pour cette page.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276547443629866794)
,p_name=>'CONFIRM.NO_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276396623248866692)
,p_name=>'CONFIRM.OUTPUT_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments de sortie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276548735594866795)
,p_name=>'CONFIRM.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276545768666866793)
,p_name=>'CONFIRM.PAGE'
,p_message_language=>'fr'
,p_message_text=>'Page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276559364717866802)
,p_name=>'CONFIRM.PAGES'
,p_message_language=>'fr'
,p_message_text=>'Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276545828399866793)
,p_name=>'CONFIRM.PAGE_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276546712283866794)
,p_name=>'CONFIRM.PAGE_TITLE'
,p_message_language=>'fr'
,p_message_text=>'Titre de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276555235754866800)
,p_name=>'CONFIRM.PARENT_DISPLAY_COLS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes d''affichage parent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276553388689866798)
,p_name=>'CONFIRM.PARENT_MENU'
,p_message_language=>'fr'
,p_message_text=>'Chemin de navigation parent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276556857080866801)
,p_name=>'CONFIRM.PARENT_MENU_COL'
,p_message_language=>'fr'
,p_message_text=>'Colonne de chemin de navigation parent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276555414121866800)
,p_name=>'CONFIRM.PARENT_ORDER_BY'
,p_message_language=>'fr'
,p_message_text=>'Table parent - ORDER BY'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276554711366866799)
,p_name=>'CONFIRM.PARENT_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Page parent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276555045264866799)
,p_name=>'CONFIRM.PARENT_TABLE_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de table parent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276547394488866794)
,p_name=>'CONFIRM.PARENT_TAB_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 d''onglet parent')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276547214246866794)
,p_name=>'CONFIRM.PARENT_TAB_SET'
,p_message_language=>'fr'
,p_message_text=>'Jeu d''onglets parent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276650168308866859)
,p_name=>'CONFIRM.PARSING_SCHEMA'
,p_message_language=>'fr'
,p_message_text=>unistr('Sch\00E9ma d''analyse')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276659126471866865)
,p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9g\00E9n\00E9ration de page partielle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277025387335867099)
,p_name=>'CONFIRM.PREVIOUS_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 du bouton Pr\00E9c\00E9dent')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276546649212866794)
,p_name=>'CONFIRM.PRIMARY_KEY'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de cl\00E9 primaire %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276554338255866799)
,p_name=>'CONFIRM.PRIMARY_KEY_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de cl\00E9 primaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276745507706866920)
,p_name=>'CONFIRM.PRINT_FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Format de sortie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276749947591866923)
,p_name=>'CONFIRM.PRINT_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 de lien d''impression')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276745626158866920)
,p_name=>'CONFIRM.PRINT_OUTPUT'
,p_message_language=>'fr'
,p_message_text=>unistr('Impression d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276548653028866795)
,p_name=>'CONFIRM.PROCESS_OPTIONS'
,p_message_language=>'fr'
,p_message_text=>'Options de processus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276745395896866920)
,p_name=>'CONFIRM.REGION_COLUMN'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonne de r\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276547667283866795)
,p_name=>'CONFIRM.REGION_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de r\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276545994521866793)
,p_name=>'CONFIRM.REGION_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Titre de r\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276552712925866798)
,p_name=>'CONFIRM.REGION_TYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Type de r\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276650300119866859)
,p_name=>'CONFIRM.REMOVED_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes enlev\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276554453312866799)
,p_name=>'CONFIRM.REPORT_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276767728270866934)
,p_name=>'CONFIRM.REPORT_IMPLEMENTATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Impl\00E9mentation d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276553556339866798)
,p_name=>'CONFIRM.REPORT_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Page d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276553634314866799)
,p_name=>'CONFIRM.REPORT_PAGE_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de page d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276553807849866799)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 d''onglet de page d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276553757838866799)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_SET'
,p_message_language=>'fr'
,p_message_text=>unistr('Jeu d''onglets de page d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276440735605866723)
,p_name=>'CONFIRM.REPORT_REGION_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de r\00E9gion d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276440644924866722)
,p_name=>'CONFIRM.REPORT_REGION_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Titre de r\00E9gion d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276557707115866801)
,p_name=>'CONFIRM.REPORT_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276443216145866724)
,p_name=>'CONFIRM.ROW_VERSION_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne de version de ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276557971659866801)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME1'
,p_message_language=>'fr'
,p_message_text=>unistr('valeur par d\00E9faut : HTML (standard)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276558232406866801)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME11'
,p_message_language=>'fr'
,p_message_text=>unistr('valeur par d\00E9faut : aspect 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276558395361866802)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME12'
,p_message_language=>'fr'
,p_message_text=>unistr('valeur par d\00E9faut : aspect 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276649945460866859)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME13'
,p_message_language=>'fr'
,p_message_text=>unistr('valeur par d\00E9faut : aspect 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276650043785866859)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME14'
,p_message_language=>'fr'
,p_message_text=>unistr('valeur par d\00E9faut : aspect 4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276441223001866723)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME15'
,p_message_language=>'fr'
,p_message_text=>unistr('valeur par d\00E9faut : aspect 5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276558017841866801)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME2'
,p_message_language=>'fr'
,p_message_text=>unistr('valeur par d\00E9faut : \00E9tat vertical')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276558443042866802)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME21'
,p_message_language=>'fr'
,p_message_text=>'export : CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276558512212866802)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME22'
,p_message_language=>'fr'
,p_message_text=>'export : XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276558152382866801)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME3'
,p_message_language=>'fr'
,p_message_text=>unistr('valeur par d\00E9faut : \00E9tat vertical, aspect 1 (inclure les colonnes Null)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276649718777866859)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME4'
,p_message_language=>'fr'
,p_message_text=>unistr('valeur par d\00E9faut : \00E9tat vertical, aspect 2 (exclure les colonnes Null)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276649840605866859)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME5'
,p_message_language=>'fr'
,p_message_text=>unistr('valeur par d\00E9faut : \00E9tat vertical, aspect  2 (inclure les colonnes Null)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276968679131867063)
,p_name=>'CONFIRM.RULE_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de la r\00E8gle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276968863188867063)
,p_name=>'CONFIRM.RULE_SEQUENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9quence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276968905137867063)
,p_name=>'CONFIRM.RULE_TYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Type de r\00E8gle')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276370436558866676)
,p_name=>'CONFIRM.RUN_SCRIPT'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous avez demand\00E9 l''ex\00E9cution du script suivant. Confirmez votre demande.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276553077041866798)
,p_name=>'CONFIRM.SEQUENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9quence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276557850154866801)
,p_name=>'CONFIRM.SORT_OPTION'
,p_message_language=>'fr'
,p_message_text=>'Option de tri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276548986545866796)
,p_name=>'CONFIRM.SQL_QUERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAte SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276659012594866865)
,p_name=>'CONFIRM.STANDARD_CALENDAR'
,p_message_language=>'fr'
,p_message_text=>'Standard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276787215797866947)
,p_name=>'CONFIRM.STARTING_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Plusieurs pages seront cr\00E9\00E9es, \00E0 partir de la page :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276548854086866796)
,p_name=>'CONFIRM.STORED_PROCEDURE_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de proc\00E9dure stock\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276651755973866860)
,p_name=>'CONFIRM.STORED_PROCEDURE_OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire de proc\00E9dure stock\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277025551985867099)
,p_name=>'CONFIRM.SUBMIT_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 du bouton Fin')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277642727100867500)
,p_name=>'CONFIRM.SUBSCRIBE_THEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Abonner le th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276548141639866795)
,p_name=>'CONFIRM.SUGGESTED_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom sugg\00E9r\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276833718874866976)
,p_name=>'CONFIRM.TABLE'
,p_message_language=>'fr'
,p_message_text=>'Table/vue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276833848014866976)
,p_name=>'CONFIRM.TABLE_COLS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9capituler colonne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277052729819867118)
,p_name=>'CONFIRM.TABLE_LOOKUPS'
,p_message_language=>'fr'
,p_message_text=>'Recherches de table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276546390128866794)
,p_name=>'CONFIRM.TABLE_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276546243995866794)
,p_name=>'CONFIRM.TABLE_OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire de table')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277224863687867230)
,p_name=>'CONFIRM.TABLE_RULE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E8gle de transformation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276969073811867063)
,p_name=>'CONFIRM.TABLE_RULES'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E8gles de transformation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276650638318866860)
,p_name=>'CONFIRM.TABLE_VIEW_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de table/vue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276650536565866860)
,p_name=>'CONFIRM.TABLE_VIEW_OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire de table/vue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276559481004866802)
,p_name=>'CONFIRM.TABS'
,p_message_language=>'fr'
,p_message_text=>'Onglets'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276547140960866794)
,p_name=>'CONFIRM.TABSET.INCOMPLETE'
,p_message_language=>'fr'
,p_message_text=>unistr('Avertissement, les informations de jeu d''onglets sont incompl\00E8tes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276546169346866794)
,p_name=>'CONFIRM.TAB_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 d''onglet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276557572365866801)
,p_name=>'CONFIRM.TAB_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom d''onglet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276546069254866794)
,p_name=>'CONFIRM.TAB_SET'
,p_message_language=>'fr'
,p_message_text=>'Jeu d''onglets'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276558647135866802)
,p_name=>'CONFIRM.TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('mod\00E8le :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276552312026866798)
,p_name=>'CONFIRM.TREE_LOV'
,p_message_language=>'fr'
,p_message_text=>unistr('Bas\00E9e sur un nouvel \00E9l\00E9ment avec liste de valeurs (LOV) instantan\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276552054352866798)
,p_name=>'CONFIRM.TREE_MAX_LEVEL'
,p_message_language=>'fr'
,p_message_text=>'Nombre maximum de niveaux'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276551889184866797)
,p_name=>'CONFIRM.TREE_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom d''arborescence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276552221047866798)
,p_name=>'CONFIRM.TREE_QUERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAte d''arborescence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276552407031866798)
,p_name=>'CONFIRM.TREE_SQL'
,p_message_language=>'fr'
,p_message_text=>unistr('A partir d''une requ\00EAte SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276552198006866798)
,p_name=>'CONFIRM.TREE_START'
,p_message_language=>'fr'
,p_message_text=>unistr('Arborescence de d\00E9part')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276552531385866798)
,p_name=>'CONFIRM.TREE_STATIC'
,p_message_language=>'fr'
,p_message_text=>'Valeur statique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276551962551866798)
,p_name=>'CONFIRM.TREE_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type d''arborescence'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276559622989866802)
,p_name=>'CONFIRM.UI_THEME'
,p_message_language=>'fr'
,p_message_text=>unistr('Th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276559731301866802)
,p_name=>'CONFIRM.UI_THEME1'
,p_message_language=>'fr'
,p_message_text=>'Bleu et ocre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276559810851866802)
,p_name=>'CONFIRM.UI_THEME2'
,p_message_language=>'fr'
,p_message_text=>'Rouge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276559982861866803)
,p_name=>'CONFIRM.UI_THEME4'
,p_message_language=>'fr'
,p_message_text=>unistr('Bleu fonc\00E9 et gris clair')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276560019333866803)
,p_name=>'CONFIRM.UI_THEME5'
,p_message_language=>'fr'
,p_message_text=>'Marron clair'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276560133980866803)
,p_name=>'CONFIRM.UI_THEME6'
,p_message_language=>'fr'
,p_message_text=>unistr('Rouge fonc\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276560255072866803)
,p_name=>'CONFIRM.UI_THEME7'
,p_message_language=>'fr'
,p_message_text=>'Bleu et Ocre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276560390986866803)
,p_name=>'CONFIRM.UI_THEME8'
,p_message_language=>'fr'
,p_message_text=>'Bleu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276560450196866803)
,p_name=>'CONFIRM.UI_THEME_NONE'
,p_message_language=>'fr'
,p_message_text=>'Aucun'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276546585310866794)
,p_name=>'CONFIRM.UPDATEABLE_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes modifiables'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276550310229866797)
,p_name=>'CONFIRM.UPDATE_PROCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre \00E0 jour')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276547032566866794)
,p_name=>'CONFIRM.USE.EXISTING.TABSET'
,p_message_language=>'fr'
,p_message_text=>'Cette page utilisera le jeu d''onglets existant "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276396464960866692)
,p_name=>'CONFIRM.WEB_SERVICE_REF'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9f\00E9rence de service Web, op\00E9ration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276554549354866799)
,p_name=>'CONFIRM.WHERE_CLAUSE'
,p_message_language=>'fr'
,p_message_text=>'Clause WHERE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276823150763866969)
,p_name=>'CONFIRMATION_ICON'
,p_message_language=>'fr'
,p_message_text=>unistr('Ic\00F4ne de confirmation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276835211560866977)
,p_name=>'CONFIRMED'
,p_message_language=>'fr'
,p_message_text=>unistr('Confirm\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276835554521866978)
,p_name=>'CONFIRMED_BY_QA'
,p_message_language=>'fr'
,p_message_text=>unistr('Confirm\00E9 par QA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276745818592866920)
,p_name=>'CONFIRM_BREAK_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonnes de section (BREAK)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276745778649866920)
,p_name=>'CONFIRM_PRINT_FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Format d''impression'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276864059526866996)
,p_name=>'CONTENT_DISPOSITION'
,p_message_language=>'fr'
,p_message_text=>'Disposition du contenu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276899211233867018)
,p_name=>'CONTENT_SERVED_IN_KBYTES'
,p_message_language=>'fr'
,p_message_text=>unistr('Contenu trait\00E9')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276736724451866915)
,p_name=>'CONTINUE'
,p_message_language=>'fr'
,p_message_text=>'Continuer'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277776333832867586)
,p_name=>'CONTRIBUTORS'
,p_message_language=>'fr'
,p_message_text=>'Contributeurs'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277668925188867517)
,p_name=>'COPY.PAGE.NEW_STATIC_ID'
,p_message_language=>'fr'
,p_message_text=>'Nouvel ID statique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276433193155866717)
,p_name=>'COPYRIGHT'
,p_message_language=>'fr'
,p_message_text=>unistr('Copyright &copy; %0, Tous droits r\00E9serv\00E9s.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276491597390866757)
,p_name=>'COPY_APP_SUCCESS_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('L''application a \00E9t\00E9 copi\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276627127922866845)
,p_name=>'COPY_BUTTON.EXECUTION_ERR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur au cours de l''ex\00E9cution de copy_button : %0 >> %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276666065586866869)
,p_name=>'COPY_DEPLOYMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Copier les attributs de d\00E9finition d''objet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276464875830866739)
,p_name=>'COPY_EXISTING_APP'
,p_message_language=>'fr'
,p_message_text=>'Copier une application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276923138327867033)
,p_name=>'COPY_FEATURE'
,p_message_language=>'fr'
,p_message_text=>unistr('Copier la fonctionnalit\00E9 : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276665695883866869)
,p_name=>'COPY_FROM_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Copier \00E0 partir de l''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277099818930867149)
,p_name=>'COPY_FROM_APP_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Bas\00E9 sur l''application mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276665760301866869)
,p_name=>'COPY_FROM_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Copier \00E0 partir d''un nom')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276493724783866758)
,p_name=>'COPY_LIST_ENTRY'
,p_message_language=>'fr'
,p_message_text=>unistr('Copier une entr\00E9e de liste')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276627536252866845)
,p_name=>'COPY_NAMED_LOV.EXECUTION_ERR'
,p_message_language=>'fr'
,p_message_text=>unistr('Erreur au cours de l''ex\00E9cution de copy_named_lov : %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276627441089866845)
,p_name=>'COPY_NAMED_LOV.NOT_FOUND_ERR'
,p_message_language=>'fr'
,p_message_text=>'L''ID de liste de valeurs (LOV) "%0" est introuvable.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276627393792866845)
,p_name=>'COPY_NAMED_LOV.NUMERIC_ERR'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ID de liste de valeurs (LOV) "%0" n''est pas num\00E9rique.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276904160505867021)
,p_name=>'COPY_PAGE.COPY_FROM_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Copier \00E0 partir d''une page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276904254492867021)
,p_name=>'COPY_PAGE.COPY_TO_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Copier vers une page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276903190797867021)
,p_name=>'COPY_PAGE.SELECT_AUTHORIZATION'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner une autorisation -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276903023840867020)
,p_name=>'COPY_PAGE.SELECT_LIST'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner une liste -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276902960701867020)
,p_name=>'COPY_PAGE.SELECT_NAMED_LOV'
,p_message_language=>'fr'
,p_message_text=>unistr('- S\00E9lectionner une liste de valeurs -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276975007811867067)
,p_name=>'COPY_TABLE'
,p_message_language=>'fr'
,p_message_text=>'Copier %0 dans la table %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276665806178866869)
,p_name=>'COPY_TO_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Copier vers une application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276665927497866869)
,p_name=>'COPY_TO_NAME'
,p_message_language=>'fr'
,p_message_text=>'Copier vers un nom'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276591314055866822)
,p_name=>'CORE'
,p_message_language=>'fr'
,p_message_text=>'principal'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276758282460866928)
,p_name=>'COUNT'
,p_message_language=>'fr'
,p_message_text=>'Nombre'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276816001782866965)
,p_name=>'CREATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277062247547867124)
,p_name=>'CREATE APPLICATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er une application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277062340897867124)
,p_name=>'CREATE OBJECT'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un objet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277271938811867261)
,p_name=>'CREATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277272095984867261)
,p_name=>'CREATED_BY'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation par')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276922824628867033)
,p_name=>'CREATED_LAST_7_DAYS'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9\00E9 au cours des 7 derniers jours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276628206958866845)
,p_name=>'CREATED_ON'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ation le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276464943504866739)
,p_name=>'CREATE_APP_FROM_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('A partir d''un mod\00E8le d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277566151304867451)
,p_name=>'CREATE_APP_WIZ.CANDLE_CHARTS'
,p_message_language=>'fr'
,p_message_text=>'Graphiques en chandelier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277565961710867451)
,p_name=>'CREATE_APP_WIZ.COL_CHARTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Graphiques \00E0 colonnes 2D et 3D, \00E0 barres et \00E0 barres empil\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277566609481867451)
,p_name=>'CREATE_APP_WIZ.GAUGE_CHARTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Graphiques \00E0 cadran (pourcentage)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277566073427867451)
,p_name=>'CREATE_APP_WIZ.PIE_CHARTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Graphiques \00E0 secteurs et en anneau 2D et 3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277566323740867451)
,p_name=>'CREATE_APP_WIZ.PROJECTGANTT_CHARTS'
,p_message_language=>'fr'
,p_message_text=>'Graphiques de Gantt des projets'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277566590953867451)
,p_name=>'CREATE_APP_WIZ.RANGE_CHARTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Graphiques \00E0 plages 2D et 3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277566466033867451)
,p_name=>'CREATE_APP_WIZ.RESOURCEGANTT_CHARTS'
,p_message_language=>'fr'
,p_message_text=>'Graphiques de Gantt de ressources'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277566221477867451)
,p_name=>'CREATE_APP_WIZ.SCATTER_CHARTS'
,p_message_language=>'fr'
,p_message_text=>'Graphiques en nuage de points'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276583293469866817)
,p_name=>'CREATE_CONDITION.AND'
,p_message_language=>'fr'
,p_message_text=>'AND'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276583014228866817)
,p_name=>'CREATE_CONDITION.ARROW_DOWN'
,p_message_language=>'fr'
,p_message_text=>unistr('Fl\00E8che vers le bas')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276583179531866817)
,p_name=>'CREATE_CONDITION.ARROW_RIGHT'
,p_message_language=>'fr'
,p_message_text=>unistr('Fl\00E8che vers la droite')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276582881769866817)
,p_name=>'CREATE_CONDITION.COLUMNS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276582927104866817)
,p_name=>'CREATE_CONDITION.CONDITIONS'
,p_message_language=>'fr'
,p_message_text=>'Conditions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276583347334866817)
,p_name=>'CREATE_CONDITION.OR'
,p_message_language=>'fr'
,p_message_text=>'OR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276583473352866817)
,p_name=>'CREATE_CONDITION.PREVIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Aper\00E7u de condition')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276923664803867034)
,p_name=>'CREATE_DEMO_APP.GRANT'
,p_message_language=>'fr'
,p_message_text=>unistr('Cliquez sur le bouton Accorder des privil\00E8ges, ci-dessous, pour accorder ces privil\00E8ges maintenant \00E0 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276923489202867034)
,p_name=>'CREATE_DEMO_APP.NO_CREATE_PRIV'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 ne dispose pas du privil\00E8ge CREATE TABLE, CREATE VIEW, CREATE TRIGGER, CREATE SEQUENCE ou CREATE PROCEDURE, et ne pourra pas installer l''application de d\00E9monstration.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276923555595867034)
,p_name=>'CREATE_DEMO_APP.NO_EXEC_PRIV'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('%0 ne dispose pas de privil\00E8ge d''ex\00E9cution sur CTX_DOC et CTX_DDL, et ne pourra pas installer la d\00E9monstration de l''allocution d''ouverture pr\00E9sidentielle. Affectez les autorisations suivantes en tant qu''utilisateur privil\00E9gi\00E9 : '),
'<pre>',
'GRANT EXECUTE ON CTXSYS.CTX_DDL TO %0; ',
'GRANT EXECUTE ON CTXSYS.CTX_DOC TO %0;',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277270004267867259)
,p_name=>'CREATE_DIALOG_CLOSED_DA'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un bouton - Bo\00EEte de dialogue ferm\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276367369679866675)
,p_name=>'CREATE_DYNAMIC_LIST'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er une liste dynamique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276651427552866860)
,p_name=>'CREATE_DYNAMIC_LOV'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er une liste de valeurs (LOV) dynamique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276345327962866661)
,p_name=>'CREATE_FLOW.CLOUD_IDM'
,p_message_language=>'fr'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276384827747866685)
,p_name=>'CREATE_FLOW.DBACCOUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Compte de base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277088473739867142)
,p_name=>'CREATE_FLOW.HTMLDB_AUTH'
,p_message_language=>'fr'
,p_message_text=>'Authentification Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276924038540867034)
,p_name=>'CREATE_FLOW.LDAP'
,p_message_language=>'fr'
,p_message_text=>'LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277627336709867490)
,p_name=>'CREATE_FLOW.NAVIGATION_LIST'
,p_message_language=>'fr'
,p_message_text=>'Liste de menu de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277088570178867142)
,p_name=>'CREATE_FLOW.NO_AUTH'
,p_message_language=>'fr'
,p_message_text=>'Aucune authentification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277088180635867141)
,p_name=>'CREATE_FLOW.NO_TABS'
,p_message_language=>'fr'
,p_message_text=>'Aucun onglet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277088226090867141)
,p_name=>'CREATE_FLOW.ONE_LEVEL_TABS'
,p_message_language=>'fr'
,p_message_text=>'Un niveau d''onglets'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276924177114867034)
,p_name=>'CREATE_FLOW.SSO'
,p_message_language=>'fr'
,p_message_text=>unistr('SSO (Acc\00E8s avec connexion unique)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277088323696867141)
,p_name=>'CREATE_FLOW.TWO_LEVEL_TABS'
,p_message_language=>'fr'
,p_message_text=>'Deux niveaux d''onglets'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276464773111866739)
,p_name=>'CREATE_FROM_SPREADSHEET'
,p_message_language=>'fr'
,p_message_text=>'A partir d''une feuille de calcul'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276341714824866659)
,p_name=>'CREATE_GLOBAL_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Les composants de la page globale sont affich\00E9s sur toutes les pages si le point d''affichage de leur r\00E9gion est contenu dans le mod\00E8le de page s\00E9lectionn\00E9. Les attributs d''affichage conditionnel peuvent servir \00E0 supprimer l''affichage.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276616409437866838)
,p_name=>'CREATE_INDEX'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un index')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276772097291866937)
,p_name=>'CREATE_ITEM_WIZ.NO_REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('aucune r\00E9gion associ\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276591065043866822)
,p_name=>'CREATE_NEW_LOGIN_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ez une nouvelle page de connexion.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276584946063866818)
,p_name=>'CREATE_PACKAGE.BACK'
,p_message_language=>'fr'
,p_message_text=>unistr('Retour \00E0 l''assistant Cr\00E9ation de table')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276584419531866818)
,p_name=>'CREATE_PACKAGE.BROWSE'
,p_message_language=>'fr'
,p_message_text=>'Parcourir un package'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276584330821866818)
,p_name=>'CREATE_PACKAGE.CREATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le package "%0" a \00E9t\00E9 cr\00E9\00E9 dans le sch\00E9ma "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276585050134866818)
,p_name=>'CREATE_PACKAGE.FAILED'
,p_message_language=>'fr'
,p_message_text=>unistr('Echec de la cr\00E9ation de la table "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276584894811866818)
,p_name=>'CREATE_PACKAGE.HOME'
,p_message_language=>'fr'
,p_message_text=>'Page d''accueil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276584670264866818)
,p_name=>'CREATE_PACKAGE.RETURN_TO'
,p_message_language=>'fr'
,p_message_text=>unistr('Retour \00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276584713573866818)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP'
,p_message_language=>'fr'
,p_message_text=>'SQL&nbsp;Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276584592271866818)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME'
,p_message_language=>'fr'
,p_message_text=>'Page d''accueil de SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276580295244866815)
,p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun \00E9l\00E9ment trouv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276579813636866815)
,p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276580124120866815)
,p_name=>'CREATE_PAGE_ITEM.PROMPT'
,p_message_language=>'fr'
,p_message_text=>'Invite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276579961659866815)
,p_name=>'CREATE_PAGE_ITEM.REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276580079336866815)
,p_name=>'CREATE_PAGE_ITEM.SET_REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('cliquez ici pour d\00E9finir une r\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276577906312866814)
,p_name=>'CREATE_PROCESS.PAGE_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276578041853866814)
,p_name=>'CREATE_PROCESS.REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276584229187866818)
,p_name=>'CREATE_TABLE.HOME'
,p_message_language=>'fr'
,p_message_text=>'Page d''accueil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276584053894866818)
,p_name=>'CREATE_TABLE.RETURN_TO'
,p_message_language=>'fr'
,p_message_text=>unistr('Retour \00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276583950404866817)
,p_name=>'CREATE_TABLE.RUN_SCRIPT'
,p_message_language=>'fr'
,p_message_text=>unistr('Ex\00E9cuter un script')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276583678735866817)
,p_name=>'CREATE_TABLE.SCRIPT_CREATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Le script de cr\00E9ation de la table %0 a \00E9t\00E9 cr\00E9\00E9 dans le r\00E9f\00E9rentiel de scripts SQL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276583765821866817)
,p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY'
,p_message_language=>'fr'
,p_message_text=>unistr('Acc\00E9der au r\00E9f\00E9rentiel de scripts')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276584151415866818)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP'
,p_message_language=>'fr'
,p_message_text=>'SQL&nbsp;Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276583868553866817)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME'
,p_message_language=>'fr'
,p_message_text=>'Page d''accueil de SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277041079411867111)
,p_name=>'CREATE_TABULAR_FORM'
,p_message_language=>'fr'
,p_message_text=>'Panneau tabulaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277646623989867503)
,p_name=>'CREATE_TO_DO'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er une t\00E2che \00E0 effectuer')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276975828075867067)
,p_name=>'CREATE_TRIGGER'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er le d\00E9clencheur %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276914053350867028)
,p_name=>'CREATE_WS_OBJ_SUCCESS_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('Objets de base de donn\00E9es de feuille Web cr\00E9\00E9s.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276866268572866997)
,p_name=>'CREDENTIAL.OWNER'
,p_message_language=>'fr'
,p_message_text=>unistr('Propri\00E9taire des informations d''identification')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276828654516866973)
,p_name=>'CSS_CALENDAR'
,p_message_language=>'fr'
,p_message_text=>'Calendrier'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276741599378866918)
,p_name=>'CURRENT'
,p_message_language=>'fr'
,p_message_text=>'En cours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276820476942866968)
,p_name=>'CURRENT ENTRY'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9e en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276820195075866968)
,p_name=>'CURRENT FORM ELEMENT'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ment de panneau en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276604301257866830)
,p_name=>'CURRENT ITEM HELP TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Texte d''aide sur un \00E9l\00E9ment en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276820263389866968)
,p_name=>'CURRENT ITEM IDENTIFICATION NUMBER'
,p_message_language=>'fr'
,p_message_text=>unistr('Num\00E9ro d''identification d''\00E9l\00E9ment en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276820309085866968)
,p_name=>'CURRENT ITEM LABEL NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de libell\00E9 d''\00E9l\00E9ment en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276879308927867005)
,p_name=>'CURRENT TAB'
,p_message_language=>'fr'
,p_message_text=>'Onglet en cours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276566145280866806)
,p_name=>'CURRENT_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Application en cours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276573184076866811)
,p_name=>'CURRENT_IMAGE'
,p_message_language=>'fr'
,p_message_text=>'Image en cours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277179868879867201)
,p_name=>'CURRENT_ITEM_CONTAINER_ID'
,p_message_language=>'fr'
,p_message_text=>unistr('ID pouvant \00EAtre utilis\00E9 sur un \00E9l\00E9ment de conteneur qui encapsule le champ en cours, dans l''attribut Avant le libell\00E9 et l''\00E9l\00E9ment.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277655101665867508)
,p_name=>'CURRENT_ITEM_HELP_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Libell\00E9 d''aide sur un \00E9l\00E9ment en cours')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276531976237866783)
,p_name=>'CURRENT_MILESTONE'
,p_message_language=>'fr'
,p_message_text=>'Jalon en cours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276572266288866810)
,p_name=>'CURRENT_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Page en cours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276846954995866985)
,p_name=>'CURRENT_PAGE_CONTAINS_NO_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('La page en cours ne contient pas d''\00E9l\00E9ments.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276737373374866915)
,p_name=>'CUSTOM'
,p_message_language=>'fr'
,p_message_text=>'Personnalisation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276780000929866942)
,p_name=>'CUSTOMIZE'
,p_message_language=>'fr'
,p_message_text=>'Personnaliser'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276815945548866965)
,p_name=>'CUSTOMIZE LINK'
,p_message_language=>'fr'
,p_message_text=>'Personnaliser un lien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276825560113866971)
,p_name=>'CUSTOMIZE.USER_PAGE_PREFS_RESET'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9f\00E9rences de page r\00E9initialis\00E9es pour l''utilisateur %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276825624911866971)
,p_name=>'CUSTOMIZE.USER_PREFS_CHANGED'
,p_message_language=>'fr'
,p_message_text=>unistr('Les pr\00E9f\00E9rences ont \00E9t\00E9 modifi\00E9es pour l''utilisateur %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276825434549866971)
,p_name=>'CUSTOMIZE.USER_PREFS_RESET'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9f\00E9rences de page r\00E9initialis\00E9es pour l''utilisateur %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277529811702867427)
,p_name=>'CUSTOM_APPLICATIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Applications personnalis\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276366238211866674)
,p_name=>'CUSTOM_AUTH_SCHEME_DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9veloppeur d\00E9fini')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276620639978866840)
,p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR'
,p_message_language=>'fr'
,p_message_text=>'Erreur dans %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276532146890866783)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1'
,p_message_language=>'fr'
,p_message_text=>unistr('Saisissez votre ID utilisateur (n''importe quelle cha\00EEne) pour cette session.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276532265454866783)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2'
,p_message_language=>'fr'
,p_message_text=>'Saisissez votre nom utilisateur et votre mot de passe %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276532322132866783)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3'
,p_message_language=>'fr'
,p_message_text=>unistr('Saisissez votre nom utilisateur et votre mot de passe pour v\00E9rification par l''h\00F4te LDAP : %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276532464417866784)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4'
,p_message_language=>'fr'
,p_message_text=>unistr('Saisissez votre nom utilisateur et votre mot de passe de sch\00E9ma de base de donn\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277298962862867278)
,p_name=>'CUSTOM_CALENDAR'
,p_message_language=>'fr'
,p_message_text=>'Recharger'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277304025338867282)
,p_name=>'CUSTOM_CALENDAR.END_DATE'
,p_message_language=>'fr'
,p_message_text=>'Date de fin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277303943039867282)
,p_name=>'CUSTOM_CALENDAR.START_DATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Date de d\00E9but')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276976793883867068)
,p_name=>'DA.SET_VALUE.SQL.HELP_MSG'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Lorsque l''action True est D\00E9finir une valeur et que le type d\00E9fini est Instruction SQL, vous devez d\00E9finir les \00E9l\00E9ments affect\00E9s dans le m\00EAme ordre que celui de la colonne de l''instruction SQL. L''instruction SQL que vous avez d\00E9finie \00E9tait la suiv')
||'ante :</p>',
'<pre>%0</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276537536052866787)
,p_name=>'DAILY'
,p_message_language=>'fr'
,p_message_text=>'Quotidien'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276754717339866926)
,p_name=>'DATA'
,p_message_language=>'fr'
,p_message_text=>unistr('Donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277061823155867124)
,p_name=>'DATA WORKSHOP'
,p_message_language=>'fr'
,p_message_text=>unistr('Atelier de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276632243363866848)
,p_name=>'DATA.LOAD.ALL_COL_MAPPED'
,p_message_language=>'fr'
,p_message_text=>unistr('Les %0 colonnes ont toutes \00E9t\00E9 automatiquement mises en correspondance avec la table %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276633054711866848)
,p_name=>'DATA.LOAD.APPEND_INCOMPLETE'
,p_message_language=>'fr'
,p_message_text=>unistr('<b id="incompl_success_row_count"></b> nouvelles lignes ont \00E9t\00E9 ajout\00E9es \00E0 la fin des donn\00E9es de la table <code>%0</code>. <b class="u-danger-text" id="incompl_fail_row_count"></b> lignes ont \00E9t\00E9 rejet\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276632632774866848)
,p_name=>'DATA.LOAD.APPEND_SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('<b id="success_row_count"></b> nouvelles lignes ont \00E9t\00E9 ajout\00E9es \00E0 la fin des donn\00E9es de la table <code>%0</code>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276632870295866848)
,p_name=>'DATA.LOAD.APPEND_WARNING'
,p_message_language=>'fr'
,p_message_text=>unistr('<b id="err_success_row_count"></b> nouvelles lignes ont \00E9t\00E9 ajout\00E9es \00E0 la fin des donn\00E9es de la table <code>%0</code>. <b class="u-danger-text" id="err_fail_row_count"></b> lignes ont \00E9t\00E9 rejet\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276342219303866659)
,p_name=>'DATA.LOAD.CHOOSE_FILE'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionner un fichier')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276379802598866682)
,p_name=>'DATA.LOAD.CONFIGURATION_SAVED'
,p_message_language=>'fr'
,p_message_text=>unistr('Configuration enregistr\00E9e.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276632384229866848)
,p_name=>'DATA.LOAD.DEFINE_COL_MAPPING'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finissez le mapping de colonne afin de charger ces donn\00E9es dans la table %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276342107128866659)
,p_name=>'DATA.LOAD.DRAG_DROP_FILE_HERE'
,p_message_language=>'fr'
,p_message_text=>unistr('Glisser et d\00E9placer le fichier ici ou')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276342099271866659)
,p_name=>'DATA.LOAD.FILE_FORMATS'
,p_message_language=>'fr'
,p_message_text=>'Formats pris en charge : CSV, XLSX, TXT, XML, JSON'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276343138394866660)
,p_name=>'DATA.LOAD.INVALID_FILE'
,p_message_language=>'fr'
,p_message_text=>unistr('Le fichier charg\00E9 n''est pas valide ou son extension est incorrecte.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276511434177866770)
,p_name=>'DATA.LOAD.INVALID_SELECTOR'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lecteur JSON ou XML non valide utilis\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277059707741867123)
,p_name=>'DATA.LOAD.JOB_INTERMITTENTLY_FAILED'
,p_message_language=>'fr'
,p_message_text=>unistr('L''ex\00E9cution du travail de chargement des donn\00E9es s''est arr\00EAt\00E9e de mani\00E8re inattendue.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276983903070867072)
,p_name=>'DATA.LOAD.JOB_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Travail de chargement des donn\00E9es dans l''espace de travail %0 : chargement dans la table %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276632429647866848)
,p_name=>'DATA.LOAD.MAP_REMAINING_COLS'
,p_message_language=>'fr'
,p_message_text=>unistr('%0 colonnes sur %1 ont \00E9t\00E9 automatiquement mises en correspondance avec la table %2. Configurez les %3 colonnes restantes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276977590676867068)
,p_name=>'DATA.LOAD.NO_FILE_CONTENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune donn\00E9e n''a \00E9t\00E9 trouv\00E9e dans le fichier t\00E9l\00E9charg\00E9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276977629142867068)
,p_name=>'DATA.LOAD.NO_WORKSHEET_CONTENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucune donn\00E9e n''a \00E9t\00E9 trouv\00E9e dans la feuille de calcul "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276342592212866660)
,p_name=>'DATA.LOAD.NO_XLSX_FILE'
,p_message_language=>'fr'
,p_message_text=>unistr('Le fichier indiqu\00E9 n''est pas un fichier XLSX.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277024328408867098)
,p_name=>'DATA.LOAD.PASTED_DATA'
,p_message_language=>'fr'
,p_message_text=>unistr('Donn\00E9es coll\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276633153025866849)
,p_name=>'DATA.LOAD.REPLACE_INCOMPLETE'
,p_message_language=>'fr'
,p_message_text=>unistr('Les donn\00E9es de la table <code>%0</code> ont \00E9t\00E9 remplac\00E9es par <b id="incompl_success_row_count"></b> nouvelles lignes. <b class="u-danger-text" id="incompl_fail_row_count"></b> lignes ont \00E9t\00E9 rejet\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276632702750866848)
,p_name=>'DATA.LOAD.REPLACE_SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Les donn\00E9es de la table <code>%0</code> ont \00E9t\00E9 remplac\00E9es par <b id="success_row_count"></b> nouvelles lignes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276632982081866848)
,p_name=>'DATA.LOAD.REPLACE_WARNING'
,p_message_language=>'fr'
,p_message_text=>unistr('Les donn\00E9es de la table <code>%0</code> ont \00E9t\00E9 remplac\00E9es par <b id="err_success_row_count"></b> nouvelles lignes. <b class="u-danger-text" id="err_fail_row_count"></b> lignes ont \00E9t\00E9 rejet\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276632528412866848)
,p_name=>'DATA.LOAD.SELECT_COLS'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9lectionnez les colonnes \00E0 charger.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277639430277867498)
,p_name=>'DATABASE'
,p_message_language=>'fr'
,p_message_text=>unistr('Base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277062417546867125)
,p_name=>'DATABASE BROWSER'
,p_message_language=>'fr'
,p_message_text=>unistr('Navigateur de base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277578049476867458)
,p_name=>'DATABASE.DEMO.SAMPLE.APP'
,p_message_language=>'fr'
,p_message_text=>unistr('Application de base de donn\00E9es \00E9chantillon')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277639584233867498)
,p_name=>'DATABASE_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Application de base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276386537309866686)
,p_name=>'DATABASE_APPLICATIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Applications de base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276414312958866704)
,p_name=>'DATABASE_APPS'
,p_message_language=>'fr'
,p_message_text=>unistr('Applications de base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276908922728867024)
,p_name=>'DATABASE_APP_SUCCESS_MSG'
,p_message_language=>'fr'
,p_message_text=>unistr('L''application <strong>%0</strong> a \00E9t\00E9 install\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276805811866866959)
,p_name=>'DATABASE_LINK'
,p_message_language=>'fr'
,p_message_text=>unistr('Lien de base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276858696642866992)
,p_name=>'DATABASE_OBJECT_COUNTS_BY_TYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Nombre d''objets de base de donn\00E9es par type d''objet')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276861806445866994)
,p_name=>'DATABASE_ROLE_PRIVILEGES'
,p_message_language=>'fr'
,p_message_text=>unistr('Privil\00E8ges de r\00F4le de base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276408863839866700)
,p_name=>'DATABASE_USERS'
,p_message_language=>'fr'
,p_message_text=>unistr('Base de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276969599040867063)
,p_name=>'DATA_GRID'
,p_message_language=>'fr'
,p_message_text=>unistr('Grille de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277568696056867452)
,p_name=>'DATA_GRIDS'
,p_message_language=>'fr'
,p_message_text=>unistr('Grilles de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277569157264867453)
,p_name=>'DATA_GRID_DATA'
,p_message_language=>'fr'
,p_message_text=>unistr('Donn\00E9es de grille de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277559102271867446)
,p_name=>'DATA_LOAD.ADVANCED_SETTINGS_REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres avanc\00E9s de chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276495775040866759)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT'
,p_message_language=>'fr'
,p_message_text=>unistr('Formats date/nombre \00E0 utiliser')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276495874806866760)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT_HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Choisissez de fournir des masques de format personnalis\00E9s ou d''en utiliser des standard.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276410244540866701)
,p_name=>'DATA_LOAD.CHARSET'
,p_message_language=>'fr'
,p_message_text=>unistr('Jeu de caract\00E8res de fichier')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277050416878867117)
,p_name=>'DATA_LOAD.COLUMN_NAMES'
,p_message_language=>'fr'
,p_message_text=>'Noms de colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277048988139867116)
,p_name=>'DATA_LOAD.COLUMN_NAMES_MAPPING'
,p_message_language=>'fr'
,p_message_text=>'Colonne cible'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276907073799867023)
,p_name=>'DATA_LOAD.COLUMN_NAME_ALIASES'
,p_message_language=>'fr'
,p_message_text=>'Alias de noms de colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277263467434867255)
,p_name=>'DATA_LOAD.CONFIRM'
,p_message_language=>'fr'
,p_message_text=>unistr('Les donn\00E9es ont \00E9t\00E9 t\00E9l\00E9charg\00E9es vers la table.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277270742905867260)
,p_name=>'DATA_LOAD.COPY_PASTE'
,p_message_language=>'fr'
,p_message_text=>'Copier/coller'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277257003039867251)
,p_name=>'DATA_LOAD.COPY_PASTE_TEXTAREA'
,p_message_language=>'fr'
,p_message_text=>unistr('Copier/coller les donn\00E9es d\00E9limit\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277599465512867472)
,p_name=>'DATA_LOAD.CURRENCY_ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('Symbole mon\00E9taire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277599556341867472)
,p_name=>'DATA_LOAD.CURRENCY_ITEM_HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Si vos donn\00E9es contiennent un symbole mon\00E9taire international, saisissez-le ici. Par exemple, si vos donn\00E9es comportent "&euro;1,234.56" ou "&yen;1,234.56", saisissez "&euro;" ou "&yen;". Si vous ne le faites pas, les donn\00E9es ne se chargeront pas cor')
||'rectement.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276415219496866705)
,p_name=>'DATA_LOAD.DATA_LOADING'
,p_message_language=>'fr'
,p_message_text=>unistr('Chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277559240496867446)
,p_name=>'DATA_LOAD.DATE_FORMAT_APP'
,p_message_language=>'fr'
,p_message_text=>'Utiliser les masques de format d''application standard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277559398645867446)
,p_name=>'DATA_LOAD.DATE_FORMAT_CUSTOM'
,p_message_language=>'fr'
,p_message_text=>unistr('Indiquer des formats personnalis\00E9s pour les colonnes t\00E9l\00E9charg\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277601090309867473)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_HELP'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>La marque d\00E9cimale s\00E9pare la partie enti\00E8re de la partie d\00E9cimale des nombres.</p>'),
unistr('<p>La marque d\00E9cimale peut \00EAtre tout caract\00E8re mono-octet diff\00E9rent du s\00E9parateur de groupes. Ce peut \00EAtre un espace mais non un caract\00E8re num\00E9rique, ni aucun des caract\00E8res suivants :</p>'),
'<ul class="noIndent">',
'<li>plus (+)</li>',
'<li>tiret (-)</li> ',
unistr('<li>signe inf\00E9rieur (<)</li>'),
unistr('<li>signe sup\00E9rieur (>)</li> '),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277600116282867473)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('Marque d\00E9cimale')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276907282359867023)
,p_name=>'DATA_LOAD.DISPLAY'
,p_message_language=>'fr'
,p_message_text=>'Afficher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277050364047867117)
,p_name=>'DATA_LOAD.DO_NOT_LOAD'
,p_message_language=>'fr'
,p_message_text=>'Ne pas charger'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277595033036867469)
,p_name=>'DATA_LOAD.FAILED'
,p_message_language=>'fr'
,p_message_text=>'Erreur avant traitement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277507560977867413)
,p_name=>'DATA_LOAD.FAILED_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Lignes en \00E9chec :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277579009953867459)
,p_name=>'DATA_LOAD.FAILED_RECORD'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrements en \00E9chec')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277599023233867472)
,p_name=>'DATA_LOAD.FILE_NAME_ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom du fichier \00E0 t\00E9l\00E9charger vers le serveur.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277049230253867116)
,p_name=>'DATA_LOAD.FIRST_COLUMN_NAMES'
,p_message_language=>'fr'
,p_message_text=>'Colonne source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277267479598867258)
,p_name=>'DATA_LOAD.FIRST_ROW'
,p_message_language=>'fr'
,p_message_text=>unistr('La premi\00E8re ligne contient des noms de colonne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277599150244867472)
,p_name=>'DATA_LOAD.FIRST_ROW_HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Cochez cette case si la premi\00E8re ligne des donn\00E9es contient des noms de colonne.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277050528427867117)
,p_name=>'DATA_LOAD.FORMAT'
,p_message_language=>'fr'
,p_message_text=>'Format date/nombre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277599320566867472)
,p_name=>'DATA_LOAD.GLOBALIZATION_REGION'
,p_message_language=>'fr'
,p_message_text=>'Globalisation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277600017418867472)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_HELP'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Le s\00E9parateur de groupes est un caract\00E8re qui s\00E9pare les groupes d''entiers, par exemple les milliers et les millions.</p>'),
unistr('<p> Il peut \00EAtre repr\00E9sent\00E9 par n''importe quel caract\00E8re. Le caract\00E8re indiqu\00E9 doit \00EAtre mono-octet, et le s\00E9parateur de groupes doit \00EAtre diff\00E9rent de toute marque d\00E9cimale. Le caract\00E8re peut \00EAtre un espace, mais il ne peut pas \00EAtre repr\00E9sent\00E9 par u')
||unistr('n caract\00E8re num\00E9rique ni l''un des caract\00E8res suivants :</p>'),
'<ul class="noIndent">',
'<li>signe plus (+)</li>',
'<li>trait d''union (-)</li> ',
'<li>symbole plus petit que (<)</li>',
'<li>symbole plus grand que (>)</li> ',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277599618391867472)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9parateur de groupes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277594765768867469)
,p_name=>'DATA_LOAD.INSERT'
,p_message_language=>'fr'
,p_message_text=>unistr('Ins\00E9rer une ligne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277507390320867413)
,p_name=>'DATA_LOAD.INSERTED_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Lignes ins\00E9r\00E9es :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277596518668867470)
,p_name=>'DATA_LOAD.IR_MAX_ROW_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Cette requ\00EAte renvoie plus de #MAX_ROW_COUNT# lignes. Filtrez vos donn\00E9es pour \00EAtre s\00FBr d''obtenir des r\00E9sultats complets.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276905938056867022)
,p_name=>'DATA_LOAD.JUSTCHANGED_RECORD'
,p_message_language=>'fr'
,p_message_text=>unistr('Enregistrements modifi\00E9s par un autre utilisateur.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276522286578866777)
,p_name=>'DATA_LOAD.LABEL_CASE_SENSITIVE'
,p_message_language=>'fr'
,p_message_text=>'Distinction maj/min'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276522152434866777)
,p_name=>'DATA_LOAD.LABEL_UNIQUE_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne unique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277230527708867234)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Echec du chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277230678451867234)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Action trait\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277256268002867250)
,p_name=>'DATA_LOAD.LOAD_TO'
,p_message_language=>'fr'
,p_message_text=>unistr('Importer \00E0 partir de')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277660118697867511)
,p_name=>'DATA_LOAD.LOOKUP_FAILED'
,p_message_language=>'fr'
,p_message_text=>'Echec de l''extraction de la valeur de recherche.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277276691964867264)
,p_name=>'DATA_LOAD.MAPPING'
,p_message_language=>'fr'
,p_message_text=>unistr('Mapping de table/donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276967744739867062)
,p_name=>'DATA_LOAD.MAPPING_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Etape 2 - Nom de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277658844021867511)
,p_name=>'DATA_LOAD.NO_PREVIEW'
,p_message_language=>'fr'
,p_message_text=>unistr('Aucun aper\00E7u de fichier disponible')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277598240210867471)
,p_name=>'DATA_LOAD.OPTIONAL_ENCLOSE_ITEM'
,p_message_language=>'fr'
,p_message_text=>unistr('Eventuellement d\00E9limit\00E9 par')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277562579809867449)
,p_name=>'DATA_LOAD.PROGRESS_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Progression de l''assistant Chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276967909937867062)
,p_name=>'DATA_LOAD.RESULTS_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Etape 4 - Nom de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276907109662867023)
,p_name=>'DATA_LOAD.RETURN'
,p_message_language=>'fr'
,p_message_text=>'Renvoyer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276905481592867022)
,p_name=>'DATA_LOAD.REVIEW_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Ligne(s) \00E0 r\00E9viser :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277050690169867117)
,p_name=>'DATA_LOAD.ROW'
,p_message_language=>'fr'
,p_message_text=>'Ligne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277047187539867115)
,p_name=>'DATA_LOAD.RULES_PLSQL_EXPRESSION_EXAMPLES'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'to_char(sysdate)',
'',
'my_func (',
'    p_1 => :SAL,',
'    p_2 => :COMM)',
'',
unistr('o\00F9 SAL et COMM sont les noms de colonne des donn\00E9es t\00E9l\00E9charg\00E9es'),
'et my_func est la fonction qui renvoie la nouvelle valeur',
unistr('de la colonne pour laquelle cette r\00E8gle de transformation est d\00E9finie.'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277047325915867115)
,p_name=>'DATA_LOAD.RULES_PLSQL_FUNCTION_EXAMPLES'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'declare',
'    l_result number;',
'begin',
'    l_result := :SAL * :COMM;',
'    return l_result;',
'end;',
'',
unistr('Le r\00E9sultat renvoy\00E9 sera la nouvelle valeur de la colonne pour laquelle cette r\00E8gle de transformation est d\00E9finie.'),
'',
unistr(':SAL et :COMM renvoient aux noms de colonne SAL et COMM des donn\00E9es t\00E9l\00E9charg\00E9es.'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277047284552867115)
,p_name=>'DATA_LOAD.RULES_SQL_QUERY_EXAMPLES'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'select depno',
' from dept',
'where dname = :DEPTNAME',
'  and loc   = :LOC',
'',
unistr('o\00F9 :DEPNAME et :LOC renvoient aux noms de colonne DEPNAME et LOC des donn\00E9es t\00E9l\00E9charg\00E9es.'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277598007509867471)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Identifiez le caract\00E8re s\00E9parateur de colonnes. Utilisez <code>\005Ct</code> pour une s\00E9paration par des tabulations.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277598140083867471)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9parateur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276907339168867023)
,p_name=>'DATA_LOAD.SEQUENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9quence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277651884596867506)
,p_name=>'DATA_LOAD.SEQUENCE_ACTION'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9quence : action')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277558970628867446)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Utiliser les param\00E8tres avanc\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277559047685867446)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS_HELP'
,p_message_language=>'fr'
,p_message_text=>unistr('Afficher les param\00E8tres avanc\00E9s pour le chargement des donn\00E9es : Symbole mon\00E9taire, Caract\00E8res d\00E9cimaux, Encodage de fichier ou Formats de date')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277276035922867263)
,p_name=>'DATA_LOAD.SOURCE'
,p_message_language=>'fr'
,p_message_text=>unistr('Source de chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276967694119867062)
,p_name=>'DATA_LOAD.SOURCE_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Etape 1 - Nom de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277639785582867498)
,p_name=>'DATA_LOAD.TAB_SEPARTOR_NOTE'
,p_message_language=>'fr'
,p_message_text=>'(\t pour tabulation)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276980709615867070)
,p_name=>'DATA_LOAD.TRANSFORMATION_FAILED'
,p_message_language=>'fr'
,p_message_text=>unistr('Echec de la r\00E8gle de transformation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277596864903867470)
,p_name=>'DATA_LOAD.UNIQUE_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Colonne unique %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277594895742867469)
,p_name=>'DATA_LOAD.UPDATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mettre \00E0 jour une ligne')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277507430165867413)
,p_name=>'DATA_LOAD.UPDATED_COUNT'
,p_message_language=>'fr'
,p_message_text=>unistr('Lignes mises \00E0 jour :')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277707534558867542)
,p_name=>'DATA_LOAD.UPLOADED_NULL_VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur NULL a \00E9t\00E9 t\00E9l\00E9charg\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277270681505867260)
,p_name=>'DATA_LOAD.UPLOAD_FILE'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9charger un fichier vers le serveur (d\00E9limitation par des virgules (*.csv) ou des tabulations)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277276233439867263)
,p_name=>'DATA_LOAD.UPLOAD_RESULTS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9sultats de chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277276105421867263)
,p_name=>'DATA_LOAD.VALIDATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Validation des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276967880620867062)
,p_name=>'DATA_LOAD.VALIDATION_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Etape 3 - Nom de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276971937160867065)
,p_name=>'DATA_LOAD_WIZARD_CREATED_SUCCESSFULLY'
,p_message_language=>'fr'
,p_message_text=>unistr('Les pages de l''assistant Chargement des donn\00E9es ont \00E9t\00E9 cr\00E9\00E9es.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277230790954867234)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Echec du mapping de table/donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277230828917867234)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('Action trait\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276830152279866974)
,p_name=>'DATA_UPLOAD_COLUMN_MAPPING'
,p_message_language=>'fr'
,p_message_text=>unistr('Mapping de colonne de t\00E9l\00E9chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276755610624866927)
,p_name=>'DATE'
,p_message_language=>'fr'
,p_message_text=>'Date'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276960246713867057)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur de l''attribut de date mise en \00E9vidence %0 saisie pour l''\00E9l\00E9ment %1 ne correspond pas au format %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276966036038867061)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID_RELATIVE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur de l''attribut de date mise en \00E9vidence %0 saisie pour l''\00E9l\00E9ment %1 n''est pas une date relative.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276960441952867057)
,p_name=>'DATEPICKER.MAX_DATE_INVALID'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur de l''attribut de date maximale %0 saisie pour l''\00E9l\00E9ment %1 ne correspond pas au format %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276966244458867061)
,p_name=>'DATEPICKER.MAX_DATE_INVALID_RELATIVE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur de l''attribut de date maximale %0 saisie pour l''\00E9l\00E9ment %1 n''est pas une date relative.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276960399906867057)
,p_name=>'DATEPICKER.MIN_DATE_INVALID'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur de l''attribut de date minimale %0 saisie pour l''\00E9l\00E9ment %1 ne correspond pas au format %2.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276966114012867061)
,p_name=>'DATEPICKER.MIN_DATE_INVALID_RELATIVE'
,p_message_language=>'fr'
,p_message_text=>unistr('La valeur de l''attribut de date minimale %0 saisie pour l''\00E9l\00E9ment %1 n''est pas une date relative.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277094130130867145)
,p_name=>'DATE_ADDED'
,p_message_language=>'fr'
,p_message_text=>'Date d''ajout'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277566963281867451)
,p_name=>'DATE_OF_LAST_RUN'
,p_message_language=>'fr'
,p_message_text=>unistr('Travaux de base de donn\00E9es Oracle Application Express avec l''heure de leur derni\00E8re ex\00E9cution')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276586120241866819)
,p_name=>'DAY'
,p_message_language=>'fr'
,p_message_text=>'jour'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276586290608866819)
,p_name=>'DAYS'
,p_message_language=>'fr'
,p_message_text=>'jours'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276882852711867008)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE'
,p_message_language=>'fr'
,p_message_text=>'jusqu''au jalon final'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276882906287867008)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE_OF_RELASE'
,p_message_language=>'fr'
,p_message_text=>'jusqu''au jalon final de version %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276965301009867060)
,p_name=>'DA_NAME.NATIVE_ADD_CLASS'
,p_message_language=>'fr'
,p_message_text=>'Ajouter une classe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277571945872867454)
,p_name=>'DA_NAME.NATIVE_ALERT'
,p_message_language=>'fr'
,p_message_text=>'Alerte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277570689272867454)
,p_name=>'DA_NAME.NATIVE_CANCEL_EVENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Ev\00E9nement d''annulation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277572109183867455)
,p_name=>'DA_NAME.NATIVE_CLEAR'
,p_message_language=>'fr'
,p_message_text=>'Effacer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277572065258867455)
,p_name=>'DA_NAME.NATIVE_CONFIRM'
,p_message_language=>'fr'
,p_message_text=>'Confirmer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276331780722866653)
,p_name=>'DA_NAME.NATIVE_DIALOG_CANCEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Annuler la bo\00EEte de dialogue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276331828833866653)
,p_name=>'DA_NAME.NATIVE_DIALOG_CLOSE'
,p_message_language=>'fr'
,p_message_text=>unistr('Fermer la bo\00EEte de dialogue')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276491423795866757)
,p_name=>'DA_NAME.NATIVE_DISABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactiver')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276491381863866757)
,p_name=>'DA_NAME.NATIVE_ENABLE'
,p_message_language=>'fr'
,p_message_text=>'Activer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277564227686867450)
,p_name=>'DA_NAME.NATIVE_EXECUTE_PLSQL_CODE'
,p_message_language=>'fr'
,p_message_text=>unistr('Ex\00E9cuter le code PL/SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276491245152866757)
,p_name=>'DA_NAME.NATIVE_HIDE'
,p_message_language=>'fr'
,p_message_text=>'Masquer'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276877674010867004)
,p_name=>'DA_NAME.NATIVE_JAVASCRIPT_CODE'
,p_message_language=>'fr'
,p_message_text=>unistr('Ex\00E9cuter le code JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277237632969867238)
,p_name=>'DA_NAME.NATIVE_REFRESH'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9g\00E9n\00E9rer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276965474989867061)
,p_name=>'DA_NAME.NATIVE_REMOVE_CLASS'
,p_message_language=>'fr'
,p_message_text=>'Enlever la classe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276965561866867061)
,p_name=>'DA_NAME.NATIVE_SET_CSS'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir le style')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277210513063867221)
,p_name=>'DA_NAME.NATIVE_SET_FOCUS'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir le domaine d''attention')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276877571208867004)
,p_name=>'DA_NAME.NATIVE_SET_VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir une valeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276491131396866757)
,p_name=>'DA_NAME.NATIVE_SHOW'
,p_message_language=>'fr'
,p_message_text=>'Afficher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277210611465867221)
,p_name=>'DA_NAME.NATIVE_SUBMIT_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Soumettre une page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277148195471867180)
,p_name=>'DA_NAME.NATIVE_TREE_COLLAPSE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9duire l''arborescence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277148087082867180)
,p_name=>'DA_NAME.NATIVE_TREE_EXPAND'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9velopper l''arborescence')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276368628017866675)
,p_name=>'DBACCOUNT_AUTH_SCHEME_DESC'
,p_message_language=>'fr'
,p_message_text=>unistr('Compte de base de donn\00E9es')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276873704616867002)
,p_name=>'DB_COLS_CASE_SEN'
,p_message_language=>'fr'
,p_message_text=>unistr('Les noms de table et de colonne de base de donn\00E9es respectent les majuscules et les minuscules')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276986001138867074)
,p_name=>'DB_OBJECT_CREATION_EXCEPTION'
,p_message_language=>'fr'
,p_message_text=>unistr('exception de cr\00E9ation d''objet de BdD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276382390860866684)
,p_name=>'DB_PRODUCT_NAME'
,p_message_language=>'fr'
,p_message_text=>'Oracle Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277629990411867492)
,p_name=>'DB_SERVICES_ALIAS'
,p_message_language=>'fr'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277626358902867489)
,p_name=>'DB_SERVICES_ALL_MIMES'
,p_message_language=>'fr'
,p_message_text=>'Tous les types MIME'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277629896110867492)
,p_name=>'DB_SERVICES_CREATE_HANDLER'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un gestionnaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277626627328867489)
,p_name=>'DB_SERVICES_CREATE_METHOD'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er une m\00E9thode')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277626477746867489)
,p_name=>'DB_SERVICES_CREATE_PARAMETER'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un param\00E8tre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277626507020867489)
,p_name=>'DB_SERVICES_CREATE_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9er un mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277633634652867494)
,p_name=>'DB_SERVICES_DB_SERVICES_MODULE'
,p_message_language=>'fr'
,p_message_text=>'Module de service RESTful'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277629712268867492)
,p_name=>'DB_SERVICES_HANDLER'
,p_message_language=>'fr'
,p_message_text=>'Gestionnaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277634198688867494)
,p_name=>'DB_SERVICES_HANDLER_BIND_VARIABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Variable attach\00E9e de gestionnaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277603596907867475)
,p_name=>'DB_SERVICES_HANDLER_METHOD'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9thode de gestionnaire')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277634429613867495)
,p_name=>'DB_SERVICES_HANDLER_SOURCE'
,p_message_language=>'fr'
,p_message_text=>'Source de gestionnaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277603647953867475)
,p_name=>'DB_SERVICES_HANDLER_SRC_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type de source de gestionnaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277626151129867489)
,p_name=>'DB_SERVICES_METHOD'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9thode')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277633716446867494)
,p_name=>'DB_SERVICES_MODULE_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom de module'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277634238867867494)
,p_name=>'DB_SERVICES_MODULE_URI'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9fixe d''URI de module')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277626772722867490)
,p_name=>'DB_SERVICES_NO_SOURCE'
,p_message_language=>'fr'
,p_message_text=>'Aucune source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277626049721867489)
,p_name=>'DB_SERVICES_PARAMETER'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277633971996867494)
,p_name=>'DB_SERVICES_RESTFUL_SERVICES'
,p_message_language=>'fr'
,p_message_text=>'Services RESTful'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277626284646867489)
,p_name=>'DB_SERVICES_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277634316785867495)
,p_name=>'DB_SERVICES_TEMPLATE_URI'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le d''URI')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277603476675867475)
,p_name=>'DB_SERVICES_URI'
,p_message_language=>'fr'
,p_message_text=>'URI (Uniform Resource Identifier)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277633434142867494)
,p_name=>'DB_SERVICES_URI_PRIFIX'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9fixe d''URI')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277633532412867494)
,p_name=>'DB_SERVICES_URI_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le d''URI')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277603748417867475)
,p_name=>'DB_SERVICE_QUERY_ONE_ROW'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAte sur une ligne')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276779198356866941)
,p_name=>'DEBUG'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9boguer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276894160729867015)
,p_name=>'DEBUGGING_OFF'
,p_message_language=>'fr'
,p_message_text=>unistr('Le d\00E9bogage n''est pas activ\00E9 pour cette application.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276890892001867013)
,p_name=>'DECLINED'
,p_message_language=>'fr'
,p_message_text=>unistr('Refus\00E9')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277705410588867541)
,p_name=>'DEFAULT_DIALOGBTNR_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de r\00E9gion de bouton de bo\00EEte de dialogue par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277705349674867540)
,p_name=>'DEFAULT_DIALOGR_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de r\00E9gion de contenu de bo\00EEte de dialogue par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277231594244867234)
,p_name=>'DEFAULT_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Page par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276760026562866929)
,p_name=>'DEFAULT_TABLESPACE'
,p_message_language=>'fr'
,p_message_text=>unistr('tablespace par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276761718630866930)
,p_name=>'DEFAULT_TABLESPACE_INIT'
,p_message_language=>'fr'
,p_message_text=>unistr('Tablespace par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277049431704867116)
,p_name=>'DEFAULT_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le par d\00E9faut')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276364358658866673)
,p_name=>'DEFINED_BY_DA'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9fini par une action dynamique')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277295128784867276)
,p_name=>'DEFINED_TABS'
,p_message_language=>'fr'
,p_message_text=>unistr('Cette application contient %0 onglets, organis\00E9s en %1 ensembles, et comprend %2 onglets parent.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276651338789866860)
,p_name=>'DEFINE_LOV'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finir une liste de valeurs (LOV)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276816249207866965)
,p_name=>'DEFINITION'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9finition')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276983878596867072)
,p_name=>'DEINSTALLATION_SCRIPT'
,p_message_language=>'fr'
,p_message_text=>unistr('Script de d\00E9sinstallation')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276587985940866820)
,p_name=>'DELETE'
,p_message_language=>'fr'
,p_message_text=>'supprimer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276479546025866749)
,p_name=>'DELETED'
,p_message_language=>'fr'
,p_message_text=>unistr('Supprim\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277568178957867452)
,p_name=>'DELETE_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Supprimer une application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277041109594867111)
,p_name=>'DELETE_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Supprimer : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277016960261867093)
,p_name=>'DELETE_LINK_TEXT'
,p_message_language=>'fr'
,p_message_text=>'Supprimer %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276392976016866690)
,p_name=>'DELETE_MSG'
,p_message_language=>'fr'
,p_message_text=>'Voulez-vous effectuer cette action de suppression ?'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276430607951866716)
,p_name=>'DEMO.COLLECT.DESCR'
,p_message_language=>'fr'
,p_message_text=>unistr('La vitrine de collections vous permet de stocker des lignes de donn\00E9es afin de les utiliser dans une session Oracle Application Express. Cette application de base de donn\00E9es montre comment utiliser le code PL/SQL pour cr\00E9er et g\00E9rer les statuts de se')
||unistr('ssion bas\00E9s sur une collection.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276430404439866715)
,p_name=>'DEMO.SAMPLE.APP'
,p_message_language=>'fr'
,p_message_text=>unistr('Application \00E9chantillon')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276430535860866715)
,p_name=>'DEMO.SAMPLE.APP.DESCR'
,p_message_language=>'fr'
,p_message_text=>unistr('Product Portal est une application \00E9chantillon mettant en \00E9vidence des notions de conception standard. Elle inclut des pages d\00E9di\00E9es aux clients, aux produits et aux commandes, et indique comment utiliser les \00E9tats, les graphiques, les calendriers, l')
||'es cartes et les arborescences.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276838972460866980)
,p_name=>'DEMONSTRABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9montrable')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276568764718866808)
,p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK'
,p_message_language=>'fr'
,p_message_text=>unistr('Exemples d''\00E9tats structur\00E9s et de concepts de pagination')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276568459833866808)
,p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE'
,p_message_language=>'fr'
,p_message_text=>unistr('Exemple de magasin en ligne cr\00E9\00E9 \00E0 l''aide de %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276569113529866808)
,p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9couvrez l''utilisation d''Oracle Text avec %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276569579391866809)
,p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING'
,p_message_language=>'fr'
,p_message_text=>unistr('Exemple d''application de suivi de statut de projet cr\00E9\00E9e avec %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276568940911866808)
,p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES'
,p_message_language=>'fr'
,p_message_text=>unistr('Apprenez \00E0 utiliser les services Web avec %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276567248083866807)
,p_name=>'DEMO_APPLICATION.ACTION'
,p_message_language=>'fr'
,p_message_text=>'Action '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276565037737866806)
,p_name=>'DEMO_APPLICATION.APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276564788648866806)
,p_name=>'DEMO_APPLICATION.BASIC_LEXER'
,p_message_language=>'fr'
,p_message_text=>'BASIC_LEXER'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276568656051866808)
,p_name=>'DEMO_APPLICATION.BUSINESS_LOOK'
,p_message_language=>'fr'
,p_message_text=>'Aspect professionnel'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276567324364866807)
,p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE'
,p_message_language=>'fr'
,p_message_text=>'Vitrine de collections'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276564889612866806)
,p_name=>'DEMO_APPLICATION.CONTEXT_INDEX'
,p_message_language=>'fr'
,p_message_text=>'CONTEXT INDEX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276564283318866805)
,p_name=>'DEMO_APPLICATION.CREATE_BASIC'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous \00EAtes sur le point de cr\00E9er l''application de d\00E9mo Exemples de base.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276562882652866804)
,p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous \00EAtes sur le point de (re)cr\00E9er l''application de d\00E9monstration d''aspect professionnel.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276564351751866805)
,p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous \00EAtes sur le point de cr\00E9er l''application de d\00E9mo Vitrine de collections.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276564485805866805)
,p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE'
,p_message_language=>'fr'
,p_message_text=>unistr('cr\00E9er ou recr\00E9er dans le sch\00E9ma %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276562729931866804)
,p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES'
,p_message_language=>'fr'
,p_message_text=>unistr('Cr\00E9ez un exemple d''application pour pr\00E9senter les services Web.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276562991741866804)
,p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous \00EAtes sur le point de cr\00E9er l''application de d\00E9monstration Fans de la coupe du monde.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276372846996866678)
,p_name=>'DEMO_APPLICATION.DEINSTALL'
,p_message_language=>'fr'
,p_message_text=>'Enlever'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276567028574866807)
,p_name=>'DEMO_APPLICATION.DEMO_APP'
,p_message_language=>'fr'
,p_message_text=>unistr('Application de d\00E9mo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276565371537866806)
,p_name=>'DEMO_APPLICATION.FREE_SPACE'
,p_message_language=>'fr'
,p_message_text=>'Il vous reste environ %0 Mo d''espace libre.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276567886724866807)
,p_name=>'DEMO_APPLICATION.INSTALL'
,p_message_language=>'fr'
,p_message_text=>'Installer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276567520904866807)
,p_name=>'DEMO_APPLICATION.INSTALLED'
,p_message_language=>'fr'
,p_message_text=>unistr('Install\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276682599811866880)
,p_name=>'DEMO_APPLICATION.INSTALL_DEMO_APP'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous \00EAtes sur le point d''installer l''application \00E9chantillon, qui pr\00E9sente les principales fonctionnalit\00E9s de %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276568551220866808)
,p_name=>'DEMO_APPLICATION.INSTALL_NOW'
,p_message_language=>'fr'
,p_message_text=>'Installer maintenant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276567498095866807)
,p_name=>'DEMO_APPLICATION.LEARN_ABOUT'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9couvrez les concepts du chariot d''achats %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277021161910867096)
,p_name=>'DEMO_APPLICATION.LOCKED'
,p_message_language=>'fr'
,p_message_text=>unistr('Verrouill\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276565162970866806)
,p_name=>'DEMO_APPLICATION.NEED_7M'
,p_message_language=>'fr'
,p_message_text=>unistr('La d\00E9monstration de l''allocution d''ouverture pr\00E9sidentielle requiert environ 7 Mo d''espace disque libre ; son installation dans votre sch\00E9ma peut prendre jusqu''\00E0 deux minutes.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276682292072866880)
,p_name=>'DEMO_APPLICATION.NOT_ENOUGH_SPACE_ERR'
,p_message_language=>'fr'
,p_message_text=>unistr('Il n''y a pas assez d''espace pour cr\00E9er cette d\00E9monstration. Demandez de l''espace suppl\00E9mentaire en allant dans la page d''administration, dans les services de provisionnement, et en cliquant sur le lien permettant de demander de l''espace suppl\00E9mentair')
||'e. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276567739942866807)
,p_name=>'DEMO_APPLICATION.NOT_INSTALLED'
,p_message_language=>'fr'
,p_message_text=>unistr('Non install\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276563656738866805)
,p_name=>'DEMO_APPLICATION.OBJECT_EXIST'
,p_message_language=>'fr'
,p_message_text=>'Existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276562502163866804)
,p_name=>'DEMO_APPLICATION.OBJECT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'existe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276563542322866805)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME'
,p_message_language=>'fr'
,p_message_text=>'Nom'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276564623289866805)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME2'
,p_message_language=>'fr'
,p_message_text=>'Nom d''objet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276562690381866804)
,p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS'
,p_message_language=>'fr'
,p_message_text=>'n''existe pas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276563275559866805)
,p_name=>'DEMO_APPLICATION.OBJECT_RECREATE'
,p_message_language=>'fr'
,p_message_text=>unistr('S''ils existent d\00E9j\00E0, les objets de base de donn\00E9es suivants seront recr\00E9\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276563484865866805)
,p_name=>'DEMO_APPLICATION.OBJECT_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type d''objet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276564103361866805)
,p_name=>'DEMO_APPLICATION.PACKAGE'
,p_message_language=>'fr'
,p_message_text=>'Package'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276568314844866808)
,p_name=>'DEMO_APPLICATION.PETSTORE'
,p_message_language=>'fr'
,p_message_text=>'Pet Store'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276569038222866808)
,p_name=>'DEMO_APPLICATION.PRESIDENTIAL'
,p_message_language=>'fr'
,p_message_text=>unistr('Allocutions d''ouverture pr\00E9sidentielles')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276569355988866808)
,p_name=>'DEMO_APPLICATION.PROJECT_TRACKING'
,p_message_language=>'fr'
,p_message_text=>'Suivi de projet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276765772813866933)
,p_name=>'DEMO_APPLICATION.RE_INSTALL'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9installer')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276567654104866807)
,p_name=>'DEMO_APPLICATION.RUN'
,p_message_language=>'fr'
,p_message_text=>unistr('Ex\00E9cuter')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276563368157866805)
,p_name=>'DEMO_APPLICATION.SCHEMA'
,p_message_language=>'fr'
,p_message_text=>unistr('Sch\00E9ma')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276563973223866805)
,p_name=>'DEMO_APPLICATION.SEQUENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9quence')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276567150747866807)
,p_name=>'DEMO_APPLICATION.STATUS'
,p_message_language=>'fr'
,p_message_text=>'Statut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276563756462866805)
,p_name=>'DEMO_APPLICATION.TABLE'
,p_message_language=>'fr'
,p_message_text=>'Table'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276566974262866807)
,p_name=>'DEMO_APPLICATION.TABLE_SUMMARY'
,p_message_language=>'fr'
,p_message_text=>unistr('Etat Statut d''installation de l''application de d\00E9monstration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276564028091866805)
,p_name=>'DEMO_APPLICATION.TRIGGER'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9clencheur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277021316961867096)
,p_name=>'DEMO_APPLICATION.UNLOCKED'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9verrouill\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276409887553866701)
,p_name=>'DEMO_APPLICATION.UPDATE_AVAILABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mise \00E0 jour disponible')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277659871147867511)
,p_name=>'DEMO_APPLICATION.WEBSHEET_OBJECT_VALIDATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Vous devez corriger les objets non valides suivants pour pouvoir ex\00E9cuter les feuilles Web correctement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276568855506866808)
,p_name=>'DEMO_APPLICATION.WEB_SERVICES'
,p_message_language=>'fr'
,p_message_text=>'Services Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276565473722866806)
,p_name=>'DEMO_APPLICATION.WILL_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Une erreur risque de survenir si vous ne recr\00E9ez pas cette d\00E9monstration.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276498388507866761)
,p_name=>'DEMO_FLOW.CREATED_ERROR'
,p_message_language=>'fr'
,p_message_text=>unistr('Il n''y a pas assez d''espace pour cr\00E9er cette d\00E9monstration. Demandez de l''espace suppl\00E9mentaire en allant dans la page d''administration et en cliquant sur le ligne Demander des modifications du service en cours.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276498269192866761)
,p_name=>'DEMO_FLOW.CREATED_SUCCESS'
,p_message_language=>'fr'
,p_message_text=>unistr('L''application de d\00E9monstration %0 a \00E9t\00E9 cr\00E9\00E9e.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277269358387867259)
,p_name=>'DEPRECATED'
,p_message_language=>'fr'
,p_message_text=>unistr('Obsol\00E8te')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276446230691866726)
,p_name=>'DERIVED$'
,p_message_language=>'fr'
,p_message_text=>unistr('colonne d\00E9riv\00E9e')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276838870389866980)
,p_name=>'DESIRABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9f\00E9rable')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276914777216867028)
,p_name=>'DETAIL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9tail')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276981575199867071)
,p_name=>'DETAILS_FOR_ALT_TAG'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9tails')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276914885605867028)
,p_name=>'DETAIL_2'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9tail 2')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276380916345866683)
,p_name=>'DEVELOPER'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9veloppeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276987752943867075)
,p_name=>'DEVELOPERS'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9veloppeurs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276859283937866993)
,p_name=>'DEVELOPER_ACTIVITY_SUMMARY'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9capitulatif des activit\00E9s de d\00E9veloppeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276884161670867008)
,p_name=>'DEVELOPER_SUMMARY'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9capitulatif de d\00E9veloppeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277064681234867126)
,p_name=>'DEVELOPER_TOOLBAR_CLEAR'
,p_message_language=>'fr'
,p_message_text=>'Effacer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277064599649867126)
,p_name=>'DEVELOPER_TOOLBAR_COPY'
,p_message_language=>'fr'
,p_message_text=>'Copier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277093257717867145)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9boguer (%0)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277092723437867144)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Niveau de d\00E9bogage par d\00E9faut')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277092926222867145)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL4'
,p_message_language=>'fr'
,p_message_text=>unistr('Informations (par d\00E9faut)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277093043327867145)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL6'
,p_message_language=>'fr'
,p_message_text=>'Trace d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277093133696867145)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL9'
,p_message_language=>'fr'
,p_message_text=>unistr('Trace compl\00E8te')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277052228317867118)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS'
,p_message_language=>'fr'
,p_message_text=>'Des erreurs se sont produites depuis le chargement de la page. Ouvrez la console JavaScript du navigateur pour afficher ces erreurs.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277052863336867118)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS_BTN'
,p_message_language=>'fr'
,p_message_text=>'Erreurs JavaScript'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277147783372867180)
,p_name=>'DEVELOPER_TOOLBAR_NO_BUILDER'
,p_message_language=>'fr'
,p_message_text=>unistr('Cette fonctionnalit\00E9 exige que la fen\00EAtre Application Express App Builder soit ouverte. Voulez-vous ouvrir App Builder dans cette fen\00EAtre ?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277127606087867167)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Options de la barre d''outils de d\00E9veloppeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277135988607867172)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_AUTO_HIDE'
,p_message_language=>'fr'
,p_message_text=>'Masquer automatiquement'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277136118534867173)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_DISPLAY'
,p_message_language=>'fr'
,p_message_text=>'Position d''affichage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277136070234867172)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_ICONS_ONLY'
,p_message_language=>'fr'
,p_message_text=>unistr('Afficher les ic\00F4nes uniquement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277136339863867173)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_BOTTOM'
,p_message_language=>'fr'
,p_message_text=>'Bas'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277136207944867173)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_LEFT'
,p_message_language=>'fr'
,p_message_text=>'A gauche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277136466600867173)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_RIGHT'
,p_message_language=>'fr'
,p_message_text=>'A droite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277144098055867178)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_TOP'
,p_message_language=>'fr'
,p_message_text=>'Haut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277058920138867122)
,p_name=>'DEVELOPER_TOOLBAR_PAGE_INFO'
,p_message_language=>'fr'
,p_message_text=>'Infos sur la page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277059170135867122)
,p_name=>'DEVELOPER_TOOLBAR_PERF_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Dur\00E9e des performances de la page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277127705132867167)
,p_name=>'DEVELOPER_TOOLBAR_QUICK_EDIT'
,p_message_language=>'fr'
,p_message_text=>'Edition rapide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277059028078867122)
,p_name=>'DEVELOPER_TOOLBAR_SHOW_PERF'
,p_message_language=>'fr'
,p_message_text=>unistr('Dur\00E9e d''affichage de la page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277675801058867522)
,p_name=>'DEVELOPER_TOOLBAR_THEME_ROLLER'
,p_message_language=>'fr'
,p_message_text=>'Theme Roller'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277135864288867172)
,p_name=>'DEVELOPER_TOOLBAR_TITLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Barre d''outils de d\00E9veloppeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276832310016866975)
,p_name=>'DEVELOPMENT_TASK'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E2che de d\00E9veloppement')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277015463558867093)
,p_name=>'DIAL_CHART_ALERT_VALUE'
,p_message_language=>'fr'
,p_message_text=>'Alerte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277015326216867092)
,p_name=>'DIAL_CHART_HIGH_VALUE'
,p_message_language=>'fr'
,p_message_text=>unistr('Elev\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277015210768867092)
,p_name=>'DIAL_CHART_LOW_VALUE'
,p_message_language=>'fr'
,p_message_text=>'Valeur faible'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276335588272866655)
,p_name=>'DIAL_PCT'
,p_message_language=>'fr'
,p_message_text=>'Cadran (pourcentage)'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276417047865866706)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATIONS'
,p_message_language=>'fr'
,p_message_text=>'Applications'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276419614034866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTH'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les d''authentification')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276419712486866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTHORIZATION'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les d''autorisation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276418839948866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BC_ENTRIES'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276418790429866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BREADCRUMBS'
,p_message_language=>'fr'
,p_message_text=>'Chemins de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277717630808867548)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BUILD_OPTIONS'
,p_message_language=>'fr'
,p_message_text=>'Options de construction'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276418417833866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_COMPUTATIONS'
,p_message_language=>'fr'
,p_message_text=>'Calculs d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276418605760866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276418984290866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LISTS'
,p_message_language=>'fr'
,p_message_text=>'Listes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276419037868866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LIST_ENTRIES'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276419133950866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOVS'
,p_message_language=>'fr'
,p_message_text=>'Liste de valeurs (LOV)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276355137881866667)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_COLS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes de liste de valeurs (LOV)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276419230376866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_ENTRIES'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276419394431866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_NAV_BAR'
,p_message_language=>'fr'
,p_message_text=>'Barres de navigation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276417120543866706)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGES'
,p_message_language=>'fr'
,p_message_text=>'Pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276418363843866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BRANCHES'
,p_message_language=>'fr'
,p_message_text=>'Branchements'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276417595755866706)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BUTTONS'
,p_message_language=>'fr'
,p_message_text=>'Boutons'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276805355424866958)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHARTS'
,p_message_language=>'fr'
,p_message_text=>'Graphiques'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276805509835866958)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_A'
,p_message_language=>'fr'
,p_message_text=>'Axes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276805427491866958)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_S'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9rie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276418082230866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_COMP'
,p_message_language=>'fr'
,p_message_text=>'Calculs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276464248488866739)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA'
,p_message_language=>'fr'
,p_message_text=>'Actions dynamiques'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276464310333866739)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA_ACTS'
,p_message_language=>'fr'
,p_message_text=>'Action dynamique - Actions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277236981867867238)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5'
,p_message_language=>'fr'
,p_message_text=>'Graphiques Flash 5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277237057310867238)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5_S'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9rie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276417682693866706)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_CH'
,p_message_language=>'fr'
,p_message_text=>'Graphiques Flash'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276417779673866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_S'
,p_message_language=>'fr'
,p_message_text=>unistr('S\00E9rie')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276417838383866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gions de l''\00E9tat interactif')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276417999969866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR_COL'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276417379925866706)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ments de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276418287199866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_PROC'
,p_message_language=>'fr'
,p_message_text=>'Processus'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276417244689866706)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REGIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gions')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277529096014867427)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REG_COLS'
,p_message_language=>'fr'
,p_message_text=>'Colonnes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276417494284866706)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_RPT_COLS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277624576269867488)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_TREES'
,p_message_language=>'fr'
,p_message_text=>'Arborescences'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276418157494866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_VAL'
,p_message_language=>'fr'
,p_message_text=>'Validations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276419408419866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PARENT_TABS'
,p_message_language=>'fr'
,p_message_text=>'Onglets parent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276418560045866707)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PROCESSES'
,p_message_language=>'fr'
,p_message_text=>'Processus d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277655732680867508)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_LAYOUTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Mises en page d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277656519887867509)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QRY_STMTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Rapport sur les instructions de requ\00EAte SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277655681433867508)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QUERIES'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAtes d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277594681681867469)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276419823840866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SHORTCUTS'
,p_message_language=>'fr'
,p_message_text=>'Raccourcis'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276415099799866705)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_STATIC_FILES'
,p_message_language=>'fr'
,p_message_text=>'Fichiers d''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276421316158866709)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUBSTITUTIONS'
,p_message_language=>'fr'
,p_message_text=>'Substitutions'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277717316559867548)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJECTS'
,p_message_language=>'fr'
,p_message_text=>'Objets de prise en charge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277717426178867548)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_BOPT'
,p_message_language=>'fr'
,p_message_text=>'Options de construction d''objets de prise en charge'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276421136081866709)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_CHCK'
,p_message_language=>'fr'
,p_message_text=>'Prise en charge des objets/validations'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276421277131866709)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_SCR'
,p_message_language=>'fr'
,p_message_text=>'Prise en charge des objets/scripts'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276419505305866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TABS'
,p_message_language=>'fr'
,p_message_text=>'Onglets'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276420291421866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BC'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de chemin de navigation')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276420393756866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BUTTON'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de bouton')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276420440971866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_CALENDAR'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de calendrier')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276490706109866756)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_GRID'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de grille')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276420552141866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LABEL'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de libell\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276420620462866709)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LIST'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de liste')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276420725358866709)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_PAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276420869393866709)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_POPUPLOV'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de liste de valeurs (LOV) intantan\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276420926246866709)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les de r\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276421022817866709)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REPORT'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8les d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276420148116866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEMES'
,p_message_language=>'fr'
,p_message_text=>unistr('Th\00E8mes')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276397283666866693)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_FILES'
,p_message_language=>'fr'
,p_message_text=>unistr('Fichiers de th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276343375942866660)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_STYLES'
,p_message_language=>'fr'
,p_message_text=>unistr('Styles de th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276864498445866996)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANSLATIONS'
,p_message_language=>'fr'
,p_message_text=>'Messages texte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276389786611866688)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_DYNAMIC'
,p_message_language=>'fr'
,p_message_text=>'Traductions dynamiques'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276389819954866688)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_REPOS'
,p_message_language=>'fr'
,p_message_text=>'Texte traduisible'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276420082105866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TREES'
,p_message_language=>'fr'
,p_message_text=>'Arborescences'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276419998984866708)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_WEB_SERVICES'
,p_message_language=>'fr'
,p_message_text=>'Services Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277615788494867482)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_ROLES'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00F4les de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277615819878867483)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USERS'
,p_message_language=>'fr'
,p_message_text=>unistr('Utilisateurs de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276906139072867022)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USER_ROLES'
,p_message_language=>'fr'
,p_message_text=>unistr('Affectation de r\00F4le utilisateur de contr\00F4le d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277659447438867511)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_CONCATENATED_FILES'
,p_message_language=>'fr'
,p_message_text=>unistr('Fichiers concat\00E9n\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276813390202866963)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILES'
,p_message_language=>'fr'
,p_message_text=>unistr('Profils d''analyse de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276813478686866963)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILE_COLS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes de profil d''analyse de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277689197250867530)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DEVELOPER_COMMENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Commentaires de d\00E9veloppeur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277224780286867230)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE'
,p_message_language=>'fr'
,p_message_text=>unistr('Table de chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277212921650867222)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLES'
,p_message_language=>'fr'
,p_message_text=>unistr('Tables de chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277213025225867222)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_LOOKUPS'
,p_message_language=>'fr'
,p_message_text=>unistr('Recherches de table de chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277213165991867222)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_RULES'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E8gles de transformation de table de chargement des donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276350152511866664)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CALENDARS'
,p_message_language=>'fr'
,p_message_text=>'Pages de calendrier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277128503620867168)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IGS'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9gions de grille interactive')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277128689412867168)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COLUMNS'
,p_message_language=>'fr'
,p_message_text=>unistr('Colonnes d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277128790599867168)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COL_GROUPS'
,p_message_language=>'fr'
,p_message_text=>'Groupes de colonnes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276437490214866720)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGINS'
,p_message_language=>'fr'
,p_message_text=>'Modules d''extension'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276437584292866720)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTRIBUTES'
,p_message_language=>'fr'
,p_message_text=>'Attributs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276863096747866995)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTR_VALUES'
,p_message_language=>'fr'
,p_message_text=>'Valeurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276495553891866759)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_EVENTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ev\00E9nements')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276439949301866722)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_FILES'
,p_message_language=>'fr'
,p_message_text=>'Fichiers'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276915423063867028)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ITEM_FILTERS'
,p_message_language=>'fr'
,p_message_text=>unistr('Op\00E9rateurs de filtre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277717542140867548)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_SETTINGS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de composant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277630309195867492)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_STD_ATTRS'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9tadonn\00E9es d''attribut standard de module d''extension')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276813245198866963)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_REMOTE_SQL'
,p_message_language=>'fr'
,p_message_text=>'Serveurs SQL compatibles REST'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277528994369867427)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPTIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Options de mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277717241107867548)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GROUPS'
,p_message_language=>'fr'
,p_message_text=>unistr('Groupes d''options de mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277601597756867473)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GRP'
,p_message_language=>'fr'
,p_message_text=>unistr('Groupe d''options de mod\00E8le')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277672629506867519)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_PAGE_DP'
,p_message_language=>'fr'
,p_message_text=>'Points d''affichage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277672723000867520)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_REGION_DP'
,p_message_language=>'fr'
,p_message_text=>'Points d''affichage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276493969929866758)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_THEME_DISPLAY_POINTS'
,p_message_language=>'fr'
,p_message_text=>unistr('Points d''affichage de th\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276414969080866705)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_USER_INTERFACES'
,p_message_language=>'fr'
,p_message_text=>'Interfaces utilisateur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276813964249866964)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_COMP_PARAMS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de source Web de composant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276813622530866963)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_MODULES'
,p_message_language=>'fr'
,p_message_text=>'Modules de source Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276813765208866963)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_OPERATIONS'
,p_message_language=>'fr'
,p_message_text=>unistr('Op\00E9rations de source Web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276813825538866964)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_PARAMETERS'
,p_message_language=>'fr'
,p_message_text=>unistr('Param\00E8tres de source Web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276813541138866963)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_SERVERS'
,p_message_language=>'fr'
,p_message_text=>'Serveurs distants de source Web'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277632812942867494)
,p_name=>'DISABLED_NEXT_BUTTON'
,p_message_language=>'fr'
,p_message_text=>unistr('Bouton Suivant d\00E9sactiv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277632744783867493)
,p_name=>'DISABLED_PREVIOUS_BUTTON'
,p_message_language=>'fr'
,p_message_text=>unistr('Bouton Pr\00E9c\00E9dent d\00E9sactiv\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276976101514867067)
,p_name=>'DISABLE_TRIGGER'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactiver le d\00E9clencheur %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276573469531866811)
,p_name=>'DISPLAY_CONDITION'
,p_message_language=>'fr'
,p_message_text=>'Condition d''affichage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276573656110866811)
,p_name=>'DISPLAY_CONDITION_TEXT'
,p_message_language=>'fr'
,p_message_text=>'Texte de condition d''affichage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277041364060867111)
,p_name=>'DISPLAY_ORDER_LABEL'
,p_message_language=>'fr'
,p_message_text=>'Ordre d''affichage : %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276443974412866725)
,p_name=>'DISPLAY_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type d''affichage'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277716989206867548)
,p_name=>'DISPLAY_VALUE.N'
,p_message_language=>'fr'
,p_message_text=>'Valeur d''affichage : %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277628139930867490)
,p_name=>'DISTINCT_PAGES'
,p_message_language=>'fr'
,p_message_text=>'Pages distinctes'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277628278184867491)
,p_name=>'DISTINCT_USERS'
,p_message_language=>'fr'
,p_message_text=>'Utilisateurs distincts'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276354808959866667)
,p_name=>'DML_FORM'
,p_message_language=>'fr'
,p_message_text=>'Panneau DML'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276661747788866867)
,p_name=>'DO NOT UPDATE PAGE ITEMS'
,p_message_language=>'fr'
,p_message_text=>'DO_NOT_UPDATE_PAGE_ITEMS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276854820650866990)
,p_name=>'DOC_IMPACT'
,p_message_language=>'fr'
,p_message_text=>'Impact de la documentation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276856083698866991)
,p_name=>'DOC_STATUS'
,p_message_language=>'fr'
,p_message_text=>'Statut de documentation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276856254075866991)
,p_name=>'DOC_WRITER'
,p_message_language=>'fr'
,p_message_text=>'Auteur de la documentation'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276733747619866913)
,p_name=>'DOWN'
,p_message_language=>'fr'
,p_message_text=>unistr('Arr\00EAt\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276365273869866673)
,p_name=>'DOWNLOAD'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9charger en local')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276864276201866996)
,p_name=>'DOWNLOAD_LINK_TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('T\00E9l\00E9charger le texte de lien')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276661489252866867)
,p_name=>'DO_NOT_UPDATE_APPLICATION_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ne pas mettre \00E0 jour les \00E9l\00E9ments d''application')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276661528702866867)
,p_name=>'DO_NOT_UPDATE_DATA_ENTRY_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ne pas mettre \00E0 jour les \00E9l\00E9ments d''entr\00E9e de donn\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276661666859866867)
,p_name=>'DO_NOT_UPDATE_DISPLAY_ONLY_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ne pas mettre \00E0 jour les \00E9l\00E9ments non modifiables')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276661303964866866)
,p_name=>'DO_NOT_UPDATE_PAGES'
,p_message_language=>'fr'
,p_message_text=>unistr('Ne pas mettre \00E0 jour les pages')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276662937402866867)
,p_name=>'DO_NOT_UPDATE_PAGE_ITEMS'
,p_message_language=>'fr'
,p_message_text=>unistr('Ne pas mettre \00E0 jour les \00E9l\00E9ments de page')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276541959175866790)
,p_name=>'DRAG_AND_DROP'
,p_message_language=>'fr'
,p_message_text=>unistr('Glisser-d\00E9placer')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276434614408866718)
,p_name=>'DRILLDOWN'
,p_message_language=>'fr'
,p_message_text=>'Analyse descendante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276434594959866718)
,p_name=>'DRILLUP'
,p_message_language=>'fr'
,p_message_text=>'Analyse ascendante'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276590295230866821)
,p_name=>'DRIVEN'
,p_message_language=>'fr'
,p_message_text=>unistr('pilot\00E9')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276975932455867067)
,p_name=>'DROP TRIGGER'
,p_message_language=>'fr'
,p_message_text=>unistr('Supprimer le d\00E9clencheur %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276974835468867067)
,p_name=>'DROP_COLUMN'
,p_message_language=>'fr'
,p_message_text=>'Supprimer la colonne %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277208274387867219)
,p_name=>'DS_ACCESS_METHOD'
,p_message_language=>'fr'
,p_message_text=>unistr('M\00E9thode d''acc\00E8s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277208036491867219)
,p_name=>'DS_BIND_VARIABLE_NAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Nom de variable attach\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277208498192867219)
,p_name=>'DS_HANDLER'
,p_message_language=>'fr'
,p_message_text=>'Gestionnaire'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277208865956867220)
,p_name=>'DS_ITEMS_PER_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Nombre de questions par page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277208653105867219)
,p_name=>'DS_MIME_TYPES_ALLOWED'
,p_message_language=>'fr'
,p_message_text=>unistr('Types MIME autoris\00E9s')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277208766288867219)
,p_name=>'DS_ORIGINS_ALLOWED'
,p_message_language=>'fr'
,p_message_text=>unistr('Origines autoris\00E9es')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277208321583867219)
,p_name=>'DS_PARAMETER_TYPE'
,p_message_language=>'fr'
,p_message_text=>unistr('Type de param\00E8tre')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277208925752867220)
,p_name=>'DS_SECURITY_CONSTRAINT'
,p_message_language=>'fr'
,p_message_text=>unistr('Contrainte de s\00E9curit\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277208104539867219)
,p_name=>'DS_SOURCE'
,p_message_language=>'fr'
,p_message_text=>'Source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277208593534867219)
,p_name=>'DS_SOURCE_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type de source'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277209032196867220)
,p_name=>'DS_URI_PREFIX'
,p_message_language=>'fr'
,p_message_text=>unistr('Pr\00E9fixe d''URI')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277207738098867219)
,p_name=>'DS_URI_TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le d''URI')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277656618776867509)
,p_name=>'DUE'
,p_message_language=>'fr'
,p_message_text=>unistr('Ech\00E9ance')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276855860912866990)
,p_name=>'DUE_DATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Date d''\00E9ch\00E9ance')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276835646012866978)
,p_name=>'DUPLICATE'
,p_message_language=>'fr'
,p_message_text=>'Dupliquer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277629072581867491)
,p_name=>'DUPLICATE_USER'
,p_message_language=>'fr'
,p_message_text=>'Utilisateur en double dans la liste'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277278253852867265)
,p_name=>'DUP_USER'
,p_message_language=>'fr'
,p_message_text=>'Nom utilisateur en double dans la liste.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276343794005866660)
,p_name=>'DYNAMIC ACTION'
,p_message_language=>'fr'
,p_message_text=>'Action dynamique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276343683242866660)
,p_name=>'DYNAMIC ACTIONS'
,p_message_language=>'fr'
,p_message_text=>'Actions dynamiques'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276353453330866666)
,p_name=>'DYNAMIC_FORM'
,p_message_language=>'fr'
,p_message_text=>'Panneau dynamique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276479686190866749)
,p_name=>'DYNAMIC_HTML'
,p_message_language=>'fr'
,p_message_text=>'HTML dynamique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276540799452866790)
,p_name=>'DYNAMIC_QUERY'
,p_message_language=>'fr'
,p_message_text=>'Etat interactif'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276341225561866659)
,p_name=>'DYNAMIC_REFERENCE'
,p_message_language=>'fr'
,p_message_text=>unistr('R\00E9f\00E9rence dynamique')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276649624586866859)
,p_name=>'EASY_REPORT.INVALID_CONDITION'
,p_message_language=>'fr'
,p_message_text=>unistr('La condition que vous ajoutez rend la requ\00EAte non valide.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276434702795866718)
,p_name=>'EDIT'
,p_message_language=>'fr'
,p_message_text=>'Modifier'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276348951305866663)
,p_name=>'EDIT PAGE GROUP'
,p_message_language=>'fr'
,p_message_text=>'Modifier le groupe de pages'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276899192560867018)
,p_name=>'EDITOR_EXIT'
,p_message_language=>'fr'
,p_message_text=>unistr('Si vous choisissez OK, les modifications non enregistr\00E9es seront perdues.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276380273679866682)
,p_name=>'EDIT_ALL'
,p_message_language=>'fr'
,p_message_text=>'Modifier tout'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276650882233866860)
,p_name=>'EDIT_ALL_PAGE_DEFINITION_ATTRIBUTES'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier tous les attributs de d\00E9finition de page')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276893339125867014)
,p_name=>'EDIT_ALL_REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier tous les \00E9l\00E9ments de cette r\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276819498054866967)
,p_name=>'EDIT_APPLICATION'
,p_message_language=>'fr'
,p_message_text=>'Modifier l''application'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276913567745867027)
,p_name=>'EDIT_ATTRIBUTE'
,p_message_language=>'fr'
,p_message_text=>'Modifier un attribut'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277568394916867452)
,p_name=>'EDIT_AUTHENTICATION'
,p_message_language=>'fr'
,p_message_text=>'Modifier l''authentification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276903547439867021)
,p_name=>'EDIT_COMPONENT'
,p_message_language=>'fr'
,p_message_text=>'Modifier un composant'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276913632223867027)
,p_name=>'EDIT_COMPONENT_DEF'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier une d\00E9finition de composant')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277016149497867093)
,p_name=>'EDIT_LINK_TEXT'
,p_message_language=>'fr'
,p_message_text=>'Modifier %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276913480035867027)
,p_name=>'EDIT_LIST_DEV'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier une d\00E9finition de liste')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277643001986867500)
,p_name=>'EDIT_LOCK'
,p_message_language=>'fr'
,p_message_text=>'Modifier le verrou'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276778976607866941)
,p_name=>'EDIT_PAGE'
,p_message_language=>'fr'
,p_message_text=>'Modifier une page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276653381681866861)
,p_name=>'EDIT_PAGE_ATTRIBUTES'
,p_message_language=>'fr'
,p_message_text=>'Modifier des attributs de page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277276742075867264)
,p_name=>'EDIT_PROFILE'
,p_message_language=>'fr'
,p_message_text=>'Modifier le profil'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277297663897867278)
,p_name=>'EDIT_PROFILE.USER_NO_PRIV_ERR'
,p_message_language=>'fr'
,p_message_text=>unistr('L''utilisateur 0% ne dispose d''aucun privil\00E8ge de mise \00E0 jour des informations d''un autre utilisateur.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276903355550867021)
,p_name=>'EDIT_REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier une r\00E9gion')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276988505441867075)
,p_name=>'EDIT_REPORTING_TIMEFRAME'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier la tranche de temps de g\00E9n\00E9ration d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276903481207867021)
,p_name=>'EDIT_REPORT_COLS'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier des colonnes d''\00E9tat')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277270181915867259)
,p_name=>'EDIT_REPORT_DIALOG_CLOSED_DA'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier un \00E9tat - Bo\00EEte de dialogue ferm\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276892324362867014)
,p_name=>'EDIT_SYSTEM_MESSAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Modifier le message du syst\00E8me')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277231318810867234)
,p_name=>'EDIT_TAB'
,p_message_language=>'fr'
,p_message_text=>'Modifier un onglet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276915113451867028)
,p_name=>'EDIT_THIS_ATTRIBUTE'
,p_message_language=>'fr'
,p_message_text=>'Modifier cet attribut'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276756092600866927)
,p_name=>'ELAPSED_TIME'
,p_message_language=>'fr'
,p_message_text=>unistr('Temps \00E9coul\00E9')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276843099133866982)
,p_name=>'EMAIL.TEMPLATE.FOOTER_EXAMPLE'
,p_message_language=>'fr'
,p_message_text=>unistr('<a href="#MY_APPLICATION_LINK#">Acc\00E9dez \00E0 Mon application et g\00E9rez vos pr\00E9f\00E9rences de messagerie</a>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276850298546866987)
,p_name=>'EMAIL.TEMPLATE.HEADER_EXAMPLE'
,p_message_language=>'fr'
,p_message_text=>'<b style="font-size: 24px;">Mon application</b>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276975227654867067)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.EV'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>Bonjour #INVITEE#,</b><br>',
'<br>',
unistr('Ceci est un rappel d''un \00E9v\00E9nement \00E0 venir auquel vous avez \00E9t\00E9 invit\00E9. Les d\00E9tails de cet \00E9v\00E9nement sont indiqu\00E9s ci-dessous :<br>'),
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Organisateur</th>',
'    <td>#ORGANIZER#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left">Date de l''\00E9v\00E9nement</th>'),
'    <td>#EVENT_DATE#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left">Heure de d\00E9but</th>'),
'    <td>#START_TIME#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left">Dur\00E9e</th>'),
'    <td>#DURATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Lieu</th>',
'    <td>#LOCATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">URL</th>',
'    <td><a href="#URL_LINK#">#URL_NAME#</a></td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Remarques</th>',
'    <td>#NOTES#</td>',
'  </tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276842944017866982)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.OD'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>Bonjour #CUSTOMER_NAME#</b>,<br>',
'<br>',
'Merci pour votre commande.<br>',
'<br>',
unistr('<b>D\00E9tails de la commande</b><br>'),
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Date de la commande</th>',
'    <td>#ORDER_DATE#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left">Num\00E9ro de commande</th>'),
'    <td>#ORDER_NUMBER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Destinataire</th>',
'    <td>#SHIP_TO#</td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left" valign="top">Adresse d''exp\00E9dition</th>'),
'    <td>',
'      #SHIPPING_ADDRESS_LINE_1#<br>',
'      #SHIPPING_ADDRESS_LINE_2#',
'    </td>',
'  </tr>',
'  <tr>',
unistr('    <th align="left" valign="top">Articles command\00E9s</th>'),
'    <td>#ITEMS_ORDERED#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Total de la commande</th>',
'    <td>#ORDER_TOTAL#</td>',
'  </tr>',
'</table>',
'<br>',
'<br>',
unistr('Vous souhaitez modifier votre commande ? <a href="#ORDER_URL#">G\00E9rez votre commande #ORDER_NUMBER# ici.</a>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277270404190867260)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.SO'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Bonjour #SERVICE_USER#,<br>',
'<br>',
unistr('Nous allons bient\00F4t proc\00E9der \00E0 une coupure programm\00E9e du service #SERVICE_NAME#.<br>'),
unistr('Le d\00E9but de cette coupure est pr\00E9vu \00E0 #OUTAGE_START# et le service devrait \00EAtre indisponible pendant #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.<br>'),
'<br>',
unistr('L''op\00E9ration suivante sera effectu\00E9e lors de cette coupure programm\00E9e :<br>'),
'#OUTAGE_REASON#<br>',
'<br>',
'<br>',
unistr('Pour tout probl\00E8me relatif \00E0 cette coupure, contactez #OUTAGE_CONTACT#.<br>'),
'<br>',
unistr('Merci de votre compr\00E9hension,<br>'),
'#SERVICE_TEAM#'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277269801316867259)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.EV'
,p_message_language=>'fr'
,p_message_text=>unistr('Rappel d''\00E9v\00E9nement : #EVENT_NAME#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277269957561867259)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.OD'
,p_message_language=>'fr'
,p_message_text=>unistr('Commande (#ORDER_NUMBER#) confirm\00E9e.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276975482841867067)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.EV'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Bonjour #INVITEE#,',
'',
unistr('Nous vous envoyons ce courriel pour vous rappeler un \00E9v\00E9nement \00E0 venir auquel vous \00EAtes associ\00E9.'),
'',
unistr('Date de l''\00E9v\00E9nement : #EVENT_DATE#'),
unistr('Heure de d\00E9but : #START_TIME#'),
unistr('Dur\00E9e :   #DURATION#'),
'Organisateur :  #ORGANIZER#',
'Lieu :   #LOCATION#',
'URL :        #URL_NAME# (#URL_LINK#)',
'Remarques :      #NOTES#',
'',
unistr('Des d\00E9tails suppl\00E9mentaires sur l''\00E9v\00E9nement sont disponibles ici : #EVENT_LINK#')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276975304599867067)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.OD'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Bonjour #CUSTOMER_NAME#,',
'',
'Merci pour votre commande.',
'',
unistr('D\00E9tails de la commande'),
'--------------------------------------------------------------------------------',
'  Date de la commande :       #ORDER_DATE#',
unistr('  Num\00E9ro de commande :     #ORDER_NUMBER#'),
'  Destinataire :          #SHIP_TO#',
unistr('  Adresse d''exp\00E9dition : #SHIPPING_ADDRESS_LINE_1#'),
'                    #SHIPPING_ADDRESS_LINE_2#',
unistr('  Articles command\00E9s :    #ITEMS_ORDERED#'),
'  Total de la commande :      #ORDER_TOTAL#',
'--------------------------------------------------------------------------------',
'',
unistr('Vous souhaitez modifier votre commande ? G\00E9rez votre commande #ORDER_NUMBER# ici : #ORDER_URL#')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277270337108867260)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.SO'
,p_message_language=>'fr'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Bonjour #SERVICE_USER#,',
'',
unistr('Nous allons bient\00F4t proc\00E9der \00E0 une coupure programm\00E9e du service #SERVICE_NAME#.'),
unistr('Le d\00E9but de cette coupure est pr\00E9vu \00E0 #OUTAGE_START# et le service devrait \00EAtre indisponible pendant #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.'),
'',
unistr('L''op\00E9ration suivante sera effectu\00E9e lors de cette coupure programm\00E9e :'),
'#OUTAGE_REASON#',
'',
unistr('Pour tout probl\00E8me relatif \00E0 cette coupure, contactez #OUTAGE_CONTACT#.'),
'',
unistr('Merci de votre compr\00E9hension,'),
'#SERVICE_TEAM#',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276510226132866769)
,p_name=>'EMAIL_NOT_FOUND'
,p_message_language=>'fr'
,p_message_text=>unistr('L''adresse \00E9lectronique "%0" est introuvable.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276381217966866683)
,p_name=>'EMAIL_SENT_BY'
,p_message_language=>'fr'
,p_message_text=>unistr('Ce courriel a \00E9t\00E9 envoy\00E9 par %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277278447623867265)
,p_name=>'EMAIL_TOO_LONG'
,p_message_language=>'fr'
,p_message_text=>unistr('L''adresse \00E9lectronique est trop longue. La limite est de 240 caract\00E8res.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276897252052867017)
,p_name=>'ENABLE_DEBUGGING'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer le d\00E9bogage Oui ou Non')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276976078087867067)
,p_name=>'ENABLE_TRIGGER'
,p_message_language=>'fr'
,p_message_text=>unistr('Activer le d\00E9clencheur %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276382886997866684)
,p_name=>'ENCRYPTION_INPUT_TOO_LONG'
,p_message_language=>'fr'
,p_message_text=>unistr('La longueur de la valeur \00E0 crypter ne doit pas d\00E9passer 4 000 octets.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276381012606866683)
,p_name=>'END_USER'
,p_message_language=>'fr'
,p_message_text=>'Utilisateur final'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276831904142866975)
,p_name=>'ENHANCEMENT_REQUEST'
,p_message_language=>'fr'
,p_message_text=>unistr('Demande d''am\00E9lioration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277298374310867278)
,p_name=>'ENHANCEMENT_REQUEST_DASH'
,p_message_language=>'fr'
,p_message_text=>unistr('Demandes d''am\00E9lioration : %1 sur %0 ferm\00E9es')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276835142722866977)
,p_name=>'ENTERED'
,p_message_language=>'fr'
,p_message_text=>unistr('Entr\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276347599479866663)
,p_name=>'ENTER_WEBSHEETS_CREDENTIALS'
,p_message_language=>'fr'
,p_message_text=>'Entrez les informations d''identification des feuilles Web.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276821158512866968)
,p_name=>'ENTRY LINK'
,p_message_language=>'fr'
,p_message_text=>unistr('Lien d''entr\00E9e')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276821009378866968)
,p_name=>'ENTRY TEXT'
,p_message_language=>'fr'
,p_message_text=>unistr('Texte d''entr\00E9e')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276736087677866914)
,p_name=>'ERROR'
,p_message_language=>'fr'
,p_message_text=>'Erreur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276879707573867006)
,p_name=>'ERROR PAGE TEMPLATE'
,p_message_language=>'fr'
,p_message_text=>unistr('Mod\00E8le de page d''erreurs')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276731431695866911)
,p_name=>'ERRORPAGE'
,p_message_language=>'fr'
,p_message_text=>unistr('Page d''\00E9v\00E9nement d''erreur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276893937530867015)
,p_name=>'ERRORS'
,p_message_language=>'fr'
,p_message_text=>'Erreurs'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276822332926866969)
,p_name=>'ERROR_ICON'
,p_message_language=>'fr'
,p_message_text=>unistr('Ic\00F4ne d''erreur')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277655050829867508)
,p_name=>'ERROR_MESSAGE'
,p_message_language=>'fr'
,p_message_text=>'Message d''erreur'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276981776637867071)
,p_name=>'ERROR_SET_ITEM_STATE_FOR_PPR_REGION'
,p_message_language=>'fr'
,p_message_text=>unistr('Impossible de d\00E9finir la valeur de source de l''\00E9l\00E9ment de page pour la r\00E9gion de r\00E9g\00E9n\00E9ration de page partielle.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276814422402866964)
,p_name=>'ESCAPED_COL_TOO_LARGE'
,p_message_language=>'fr'
,p_message_text=>unistr('<br><b>Les donn\00E9es d''\00E9chappement d\00E9passent le maximum autoris\00E9 ; les r\00E9sultats sont tronqu\00E9s \00E0 32 ko</b>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276589431607866821)
,p_name=>'ESCAPE_SC'
,p_message_language=>'fr'
,p_message_text=>unistr('caract\00E8res sp\00E9ciaux d''\00E9chappement')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276857387297866991)
,p_name=>'ESTIMATED_EFFORT_IN_HOURS'
,p_message_language=>'fr'
,p_message_text=>'Estimation des efforts en heures'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277207987225867219)
,p_name=>'ETAG_QUERY'
,p_message_language=>'fr'
,p_message_text=>unistr('Requ\00EAte ETAG')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277207806373867219)
,p_name=>'ETAG_TYPE'
,p_message_language=>'fr'
,p_message_text=>'Type ETAG'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276832525121866976)
,p_name=>'EVENT'
,p_message_language=>'fr'
,p_message_text=>unistr('Ev\00E9nement')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277274918365867263)
,p_name=>'EVENT.APEX.APEXAFTERREFRESH'
,p_message_language=>'fr'
,p_message_text=>unistr('Apr\00E8s r\00E9g\00E9n\00E9ration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277275577803867263)
,p_name=>'EVENT.APEX.APEXBEFOREPAGESUBMIT'
,p_message_language=>'fr'
,p_message_text=>'Avant soumission de la page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277274899628867262)
,p_name=>'EVENT.APEX.APEXBEFOREREFRESH'
,p_message_language=>'fr'
,p_message_text=>unistr('Avant r\00E9g\00E9n\00E9ration')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277279145149867265)
,p_name=>'EVENT.BROWSER'
,p_message_language=>'fr'
,p_message_text=>unistr('Ev\00E9nements du navigateur Web')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276645985484866857)
,p_name=>'EVENT.BROWSER.APEXDOUBLETAP'
,p_message_language=>'fr'
,p_message_text=>'Toucher deux fois'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276646177531866857)
,p_name=>'EVENT.BROWSER.APEXPAN'
,p_message_language=>'fr'
,p_message_text=>'Panoramique'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276646030956866857)
,p_name=>'EVENT.BROWSER.APEXPRESS'
,p_message_language=>'fr'
,p_message_text=>'Appuyer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276646242788866857)
,p_name=>'EVENT.BROWSER.APEXSWIPE'
,p_message_language=>'fr'
,p_message_text=>'Faire glisser'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276645878666866857)
,p_name=>'EVENT.BROWSER.APEXTAP'
,p_message_language=>'fr'
,p_message_text=>'Toucher'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277274327571867262)
,p_name=>'EVENT.BROWSER.CHANGE'
,p_message_language=>'fr'
,p_message_text=>'Modification'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277273642485867262)
,p_name=>'EVENT.BROWSER.CLICK'
,p_message_language=>'fr'
,p_message_text=>'Clic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277273746508867262)
,p_name=>'EVENT.BROWSER.DBLCLICK'
,p_message_language=>'fr'
,p_message_text=>'Double-clic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277273186277867261)
,p_name=>'EVENT.BROWSER.FOCUSIN'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ment actif s\00E9lectionn\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277273075670867261)
,p_name=>'EVENT.BROWSER.FOCUSOUT'
,p_message_language=>'fr'
,p_message_text=>unistr('El\00E9ment actif d\00E9s\00E9lectionn\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277274508993867262)
,p_name=>'EVENT.BROWSER.KEYDOWN'
,p_message_language=>'fr'
,p_message_text=>'Saisie de texte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277274616410867262)
,p_name=>'EVENT.BROWSER.KEYPRESS'
,p_message_language=>'fr'
,p_message_text=>'Activation de la touche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277274749289867262)
,p_name=>'EVENT.BROWSER.KEYUP'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9sactivation de la touche')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277273272741867261)
,p_name=>'EVENT.BROWSER.LOAD'
,p_message_language=>'fr'
,p_message_text=>'Chargement de la ressource'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277273883868867262)
,p_name=>'EVENT.BROWSER.MOUSEDOWN'
,p_message_language=>'fr'
,p_message_text=>unistr('Bouton de la souris enfonc\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277274154076867262)
,p_name=>'EVENT.BROWSER.MOUSEENTER'
,p_message_language=>'fr'
,p_message_text=>'Positionnement de la souris'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277274256015867262)
,p_name=>'EVENT.BROWSER.MOUSELEAVE'
,p_message_language=>'fr'
,p_message_text=>'Eloignement de la souris'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277274036325867262)
,p_name=>'EVENT.BROWSER.MOUSEMOVE'
,p_message_language=>'fr'
,p_message_text=>unistr('D\00E9placement de la souris')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277273984096867262)
,p_name=>'EVENT.BROWSER.MOUSEUP'
,p_message_language=>'fr'
,p_message_text=>unistr('Bouton de la souris rel\00E2ch\00E9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(276346584049866662)
,p_name=>'EVENT.BROWSER.ORIENTATIONCHANGE'
,p_message_language=>