prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4024
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4024 - Oracle APEX - Create App Wizard
--
-- Application Export:
--   Application:     4024
--   Name:            Oracle APEX - Create App Wizard
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                     40
--       Items:                  363
--       Computations:            12
--       Validations:             73
--       Processes:              124
--       Regions:                212
--       Buttons:                187
--       Dynamic Actions:        138
--     Shared Components:
--       Logic:
--         Items:                 58
--         Processes:              2
--         Computations:           3
--         Build Options:         13
--       Navigation:
--         Parent Tabs:            1
--         Lists:                  5
--       Security:
--         Authentication:         1
--         Authorization:         11
--       User Interface:
--         Templates:
--           Page:                21
--           Region:              44
--           Label:               14
--           List:                27
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           1
--           Button:              10
--           Report:              15
--         LOVs:                  46
--         Shortcuts:              3
--         Plug-ins:              12
--       Globalization:
--         Messages:               3
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX - Create App Wizard')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286620148496916452')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20191024135255'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.1'
,p_flow_language=>'it'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(3324722473421190676.4024)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_runtime_api_usage=>'O'
,p_security_scheme=>wwv_flow_api.id(2876432045198950826)
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'PRODUCT_NAME'
,p_substitution_value_01=>'Application Express'
,p_substitution_string_02=>'DONE'
,p_substitution_value_02=>'Fine'
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>'Area di lavoro: &COMPANY.'
,p_substitution_string_04=>'CLOSE'
,p_substitution_value_04=>'Chiudi'
,p_substitution_string_05=>'DATE_FORMAT'
,p_substitution_value_05=>'dd/mm/yyyy'
,p_substitution_string_06=>'LONG_DATE_FORMAT'
,p_substitution_value_06=>'fmDay dd Month yyyy'
,p_substitution_string_07=>'TIME_FORMAT'
,p_substitution_value_07=>'hh24:mi:ss'
,p_substitution_string_08=>'DATE_TIME_FORMAT'
,p_substitution_value_08=>'dd/mm/yyyy hh24:mi:ss'
,p_substitution_string_09=>'RETURN_TO_APPLICATION'
,p_substitution_value_09=>'Torna all''applicazione'
,p_substitution_string_10=>'MSG_LANGUAGE'
,p_substitution_value_10=>'Lingua'
,p_substitution_string_12=>'MSG_COPYRIGHT'
,p_substitution_value_12=>unistr('Copyright \00A9 1999-2019, Oracle e/o relative consociate. Tutti i diritti riservati.')
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141042'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_files_version=>5
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/additional_page_types
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(599891668290343112.4024)
,p_name=>'Additional Page Types'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(599891860611343113.4024)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Report classico'
,p_list_item_link_target=>'REPORT'
,p_list_item_current_for_pages=>'REPORT'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(599892201246343114.4024)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Controllo temporale'
,p_list_item_link_target=>'TIMELINE'
,p_list_item_current_for_pages=>'TIMELINE'
);
end;
/
prompt --application/shared_components/navigation/lists/create_app_wizard
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2558503318577318905.4024)
,p_name=>'Create App Wizard'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(3078131037146643152.4024)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078131330088643190.4024)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Amministrazione'
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078131706125643192.4024)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078132165904643193.4024)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'Gestisci servizio'
,p_security_scheme=>wwv_flow_api.id(477032281289042219)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078132505153643193.4024)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Gestisci servizio'
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078132165904643193.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078132924385643194.4024)
,p_list_item_display_sequence=>215
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(3078132165904643193.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078133367058643194.4024)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'Effettua una richiesta di servizio'
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(3078132165904643193.4024)
,p_security_scheme=>wwv_flow_api.id(477032281289042219)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078133750052643195.4024)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Imposta preferenze area di lavoro'
,p_list_item_link_target=>'f?p=4350:17:&SESSION.::NO:RP::'
,p_parent_list_item_id=>wwv_flow_api.id(3078132165904643193.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078134173371643195.4024)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Modifica annuncio'
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078132165904643193.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078134568371643195.4024)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>'Utilizzo area di lavoro'
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078132165904643193.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078134932669643196.4024)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Gestisci utenti e gruppi'
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(477032281289042219)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078135328636643196.4024)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('Controlla attivit\00E0')
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(477074727917083066)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078135799834643196.4024)
,p_list_item_display_sequence=>500
,p_list_item_link_text=>'Dashboard'
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(477074727917083066)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078136195160643196.4024)
,p_list_item_display_sequence=>600
,p_list_item_link_text=>'Modifica password personale'
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_security_scheme=>wwv_flow_api.id(477074727917083066)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(3078138630465643203.4024)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078138974356643203.4024)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Documentazione'
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_02=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078139307044643204.4024)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Forum di discussione'
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078139708135643204.4024)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Oracle Technology Network'
,p_list_item_link_target=>'http://otn.oracle.com/apex'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078140162161643204.4024)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078140539384643204.4024)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Informazioni'
,p_list_item_link_target=>'f?p=4350:9:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(3078141213440643205.4024)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'App Builder'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW::'
,p_list_item_icon_alt_attribute=>'Drill-down App Builder'
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_api.id(477075720994096449)
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078159105583643220.4024)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Applicazioni di database'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:DATABASE:'
,p_parent_list_item_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078159560569643220.4024)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Applicazioni Websheet'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:WEBSHEET:'
,p_parent_list_item_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078159989275643221.4024)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078160350925643221.4024)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Crea'
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID:'
,p_parent_list_item_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078160769374643230.4024)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Importa'
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078161069192643230.4024)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Esporta'
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078161487249643231.4024)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078161868785643231.4024)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Utility area di lavoro'
,p_parent_list_item_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078162240228643231.4024)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>'Tutte le utility area di lavoro'
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(3078161868785643231.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078162630383643232.4024)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(3078161868785643231.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078163040097643232.4024)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>'Impostazioni predefinite di App Builder'
,p_list_item_link_target=>'f?p=4000:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(3078161868785643231.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078163425417643232.4024)
,p_list_item_display_sequence=>164
,p_list_item_link_text=>'Gestisci notizie'
,p_list_item_link_target=>'f?p=4800:7000:&SESSION.:'
,p_parent_list_item_id=>wwv_flow_api.id(3078161868785643231.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078163837405643232.4024)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>'Temi area di lavoro'
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(3078161868785643231.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078164275460643233.4024)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>'Gruppi di applicazioni'
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_api.id(3078161868785643231.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078164613494643233.4024)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>'Viste Application Express'
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(3078161868785643231.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078141528445643206.4024)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>unistr('Report tra pi\00F9 applicazioni')
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(3078161868785643231.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078141956352643207.4024)
,p_list_item_display_sequence=>169
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078142315487643207.4024)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Migrazioni'
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078158764400643220.4024)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078142705697643207.4024)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'SQL Workshop'
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>'Espansione SQL Workshop'
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_api.id(477077192833096450)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078143128111643207.4024)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Browser oggetti'
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078142705697643207.4024)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078143529916643208.4024)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'Comandi SQL'
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078142705697643207.4024)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078143937072643209.4024)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Script SQL'
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078142705697643207.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Utility'
,p_parent_list_item_id=>wwv_flow_api.id(3078142705697643207.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078144706995643209.4024)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>'Tutte le utility'
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078145128474643210.4024)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078145586826643210.4024)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>'Data Workshop'
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078145948828643210.4024)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>'Query Builder'
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(31854611787430473.4024)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>'Quick SQL'
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(670879766511904790.4024)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>'Data set di esempio'
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078146321304643210.4024)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>'Genera DDL'
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078146722860643211.4024)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>'Valori predefiniti interfaccia utente'
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078148775937643212.4024)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>'Confronto degli schemi'
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078147198629643211.4024)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>'Metodi sulle tabelle'
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078149179229643212.4024)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>'Cestino'
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078147910858643212.4024)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>'Report oggetti'
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078147534907643211.4024)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>'Informazioni sul database'
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078148308650643212.4024)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>'Controllo database'
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(3078144388250643209.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078149561859643213.4024)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>'Servizi RESTful'
,p_list_item_link_target=>'f?p=4850:500:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(3078142705697643207.4024)
,p_security_scheme=>wwv_flow_api.id(477076806710096450)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078149987941643213.4024)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Team Development'
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>'Espansione Team Development'
,p_list_text_01=>'tab-team-dev'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078150391370643213.4024)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>'Etichette'
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(3078149987941643213.4024)
,p_security_scheme=>wwv_flow_api.id(438801654750439842)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078150783002643213.4024)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'Milestone'
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(3078149987941643213.4024)
,p_security_scheme=>wwv_flow_api.id(438801654750439842)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078151130796643215.4024)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>'Modelli'
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(3078149987941643213.4024)
,p_security_scheme=>wwv_flow_api.id(438801654750439842)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078151583423643215.4024)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>'Utility'
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(3078149987941643213.4024)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078152307541643215.4024)
,p_list_item_display_sequence=>355
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(3078149987941643213.4024)
,p_security_scheme=>wwv_flow_api.id(438801654750439842)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078152786311643216.4024)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>'Feedback'
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(3078149987941643213.4024)
,p_security_scheme=>wwv_flow_api.id(438801654750439842)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078158358931643220.4024)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Galleria applicazioni'
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_text_01=>'tab-apps'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078165011252643233.4024)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>unistr('Applicazioni di produttivit\00E0')
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:PACKAGE'
,p_parent_list_item_id=>wwv_flow_api.id(3078158358931643220.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078165422066643233.4024)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>'Applicazioni di esempio'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:SAMPLE'
,p_parent_list_item_id=>wwv_flow_api.id(3078158358931643220.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078166258011643234.4024)
,p_list_item_display_sequence=>425
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(3078158358931643220.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3078165842051643234.4024)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>'Amministrazione'
,p_list_item_link_target=>'f?p=4750:6:&SESSION.::&DEBUG.:6:'
,p_parent_list_item_id=>wwv_flow_api.id(3078158358931643220.4024)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(804756795337189.4024)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(92008920644572450.4024)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2560293801380540643.4024)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2573352228768076373.4024)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(4323576260494847496.4024)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(4390226133792129319.4024)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(4476138239762075339.4024)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(438801654750439842.4024)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>'Non si dispone dell''autorizzazione per modificare le applicazioni'
,p_reference_id=>786942708067207200.4024
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(477032281289042219.4024)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>'Non si dispone dell''autorizzazione per amministrare le applicazioni'
,p_reference_id=>12511219858301010.4024
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(477074727917083066.4024)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>unistr('Non si \00E8 autorizzati ad accedere ai dashboard e a Controlla attivit\00E0.')
,p_reference_id=>786936829326142579.4024
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(477075720994096449.4024)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>'Nessun privilegio per l''operazione tentata'
,p_reference_id=>786516029127697713.4024
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_packaged_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(477076241954096450.4024)
,p_name=>'APEX 5.0 Packaged App Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('Non si \00E8 autorizzati a installare le applicazioni preparate')
,p_reference_id=>786517456817697723.4024
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(477076806710096450.4024)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>'Nessun privilegio per l''operazione tentata'
,p_reference_id=>786519856057734816.4024
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(477077192833096450.4024)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>'Non si dispone dell''autorizzazione per utilizzare SQL Workshop'
,p_reference_id=>786516265251697717.4024
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(477077791361096450.4024)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>'Team Development non abilitato per questa area di lavoro'
,p_reference_id=>786516861027697723.4024
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(477078061640096451.4024)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>'Nessun privilegio per l''operazione tentata'
,p_reference_id=>786517166823697723.4024
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_create
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(2876432045198950826.4024)
,p_name=>'Flow: CREATE'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'CREATE'
,p_error_message=>unistr('Non \00E8 consentito creare o eliminare applicazioni')
,p_reference_id=>786942708067207200.4024
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/workspace_requests_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(3069175640501838711.4024)
,p_name=>'Workspace Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_platform.get_preference(''SERVICE_REQUEST_FLOW''),''MANUAL'') in (''EMAIL'',''4700'') then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>'Le richieste di area di lavoro non sono abilitate.'
,p_reference_id=>786950454140282960.4024
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(110371398198128890.4024)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/set_translatable_text_strings
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(2621206058206470363.4024)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set translatable text strings'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- Set globals used to select features',
':f01 := wwv_flow_lang.custom_runtime_message (''CA.ACCESS.CONTROL.DESC'');',
':f02 := wwv_flow_lang.custom_runtime_message (''CA.USER.PROFILES.DESC'');',
':f03 := wwv_flow_lang.custom_runtime_message (''CA.TIME.ZONE.SUPPORT.DESC'');',
':f04 := wwv_flow_lang.custom_runtime_message (''CA.APPLICATION.SETTINGS.DESC'');',
':f05 := wwv_flow_lang.custom_runtime_message (''CA.HELP.PAGE.DESC'');',
':f06 := wwv_flow_lang.custom_runtime_message (''CA.FEEDBACK.DESC'');',
':f07 := wwv_flow_lang.custom_runtime_message (''CA.THEME.SELECTOR.DESC'');',
':f08 := wwv_flow_lang.custom_runtime_message (''CA.ERROR.REPORTING.DESC'');',
':f09 := wwv_flow_lang.custom_runtime_message (''CA.GLOBAL.SEARCH.DESC'');',
':f10 := wwv_flow_lang.custom_runtime_message (''CA.NOTIFICATION.DESC'');',
':f11 := wwv_flow_lang.custom_runtime_message (''CA.CONFIGURATION.SETTINGS.DESC'');',
':f12 := wwv_flow_lang.custom_runtime_message (''CA.ACTIVITY.REPORTING.DESC'');',
':f13 := wwv_flow_lang.custom_runtime_message (''CA.EMAIL.DESC'');'))
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584216820885702150.4024)
,p_name=>'A1'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584218615128709924.4024)
,p_name=>'A10'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584217023655702873.4024)
,p_name=>'A2'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584217226079703596.4024)
,p_name=>'A3'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584217429542704562.4024)
,p_name=>'A4'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584217633005705638.4024)
,p_name=>'A5'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584217835776706395.4024)
,p_name=>'A6'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584218038893707321.4024)
,p_name=>'A7'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584218240970707886.4024)
,p_name=>'A8'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584218443395708587.4024)
,p_name=>'A9'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2702550841505091143.4024)
,p_name=>'AGREEMENT_ACCEPTED'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2902063034370738006.4024)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620215367360222577.4024)
,p_name=>'F01'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620215652031223082.4024)
,p_name=>'F02'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620215829177223685.4024)
,p_name=>'F03'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620216091988224476.4024)
,p_name=>'F04'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620216456074224980.4024)
,p_name=>'F05'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620216646666227625.4024)
,p_name=>'F06'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620217066393228071.4024)
,p_name=>'F07'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620217228781228533.4024)
,p_name=>'F08'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620217428034229023.4024)
,p_name=>'F09'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620217784983229567.4024)
,p_name=>'F10'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620219234048254897.4024)
,p_name=>'F11'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620219635595255705.4024)
,p_name=>'F12'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620219819242256225.4024)
,p_name=>'F13'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620220096038256766.4024)
,p_name=>'F14'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620220261351257355.4024)
,p_name=>'F15'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620220436881257902.4024)
,p_name=>'F16'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620220658380258493.4024)
,p_name=>'F17'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620220815400259098.4024)
,p_name=>'F18'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620221028508259608.4024)
,p_name=>'F19'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620221249854260094.4024)
,p_name=>'F20'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2620221440494260571.4024)
,p_name=>'F21'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2661750939169313165.4024)
,p_name=>'F4700_REQ_NEW_SCHEMA'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2927198502727722283.4024)
,p_name=>'FB_FLOW_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2558503632761292870.4024)
,p_name=>'HELP_PAGE'
,p_item_comment=>'flow page that you would like help for.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2567087316471967564.4024)
,p_name=>'LOGIN_MESSAGE'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584285823811390169.4024)
,p_name=>'LOV_1'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584297318990615933.4024)
,p_name=>'LOV_10'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584295638252612025.4024)
,p_name=>'LOV_2'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584295939638612442.4024)
,p_name=>'LOV_3'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584296141369612948.4024)
,p_name=>'LOV_4'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584296343101613453.4024)
,p_name=>'LOV_5'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584296544832613908.4024)
,p_name=>'LOV_6'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584296714142614506.4024)
,p_name=>'LOV_7'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584296915873614982.4024)
,p_name=>'LOV_8'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584297117605615467.4024)
,p_name=>'LOV_9'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2567136018491564134.4024)
,p_name=>'PAGES_VISITED'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584203839503026155.4024)
,p_name=>'Q1'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584205636863034871.4024)
,p_name=>'Q10'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584204043312027280.4024)
,p_name=>'Q2'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584204245736027992.4024)
,p_name=>'Q3'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584204416085028877.4024)
,p_name=>'Q4'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584204619202029839.4024)
,p_name=>'Q5'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584204829591032793.4024)
,p_name=>'Q6'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584205031322033327.4024)
,p_name=>'Q7'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584205233054033832.4024)
,p_name=>'Q8'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2584205434786034333.4024)
,p_name=>'Q9'
,p_protection_level=>'N'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(2567153515861648505.4024)
,p_computation_sequence=>1
,p_computation_item=>'PAGES_VISITED'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if instr(:PAGES_VISITED,'':''||wwv_flow.g_flow_step_id) > 0 then',
'   return :PAGES_VISITED;',
'else',
'   return :PAGES_VISITED||'':''||wwv_flow.g_flow_step_id;',
'end if;'))
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(2902063566051747804.4024)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>'Impossibile calcolare il nome dell''area di lavoro.'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(2661751515882325367.4024)
,p_computation_sequence=>10
,p_computation_item=>'F4700_REQ_NEW_SCHEMA'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_platform.get_preference(''REQ_NEW_SCHEMA'')'
,p_compute_when=>'nvl(wwv_flow_platform.get_preference(''SERVICE_REQUEST_FLOW''),''MANUAL'') <> ''MANUAL'''
,p_compute_when_type=>'PLSQL_EXPRESSION'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
wwv_flow_api.create_toplevel_tab(
 p_id=>wwv_flow_api.id(2569953317150029943.4024)
,p_tab_set=>'TOP'
,p_tab_sequence=>20
,p_tab_name=>'T_TOP'
,p_tab_text=>'&PRODUCT_NAME.'
,p_tab_target=>'f?p=&APP_ID.:10:&SESSION.:'
,p_current_on_tabset=>'HOME'
);
end;
/
prompt --application/shared_components/user_interface/lovs/accept_terms
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2638960435990153554.4024)
,p_lov_name=>'ACCEPT TERMS'
,p_lov_query=>'.'||wwv_flow_api.id(2638960435990153554.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2638960640110153556.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Accetto i termini'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_item_protection_level
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3348521895514426469.4024)
,p_lov_name=>'APP ITEM PROTECTION LEVEL'
,p_lov_query=>'.'||wwv_flow_api.id(3348521895514426469.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3348522133089426483.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Non limitato'
,p_lov_return_value=>'UNRESTRICTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3348522559714426488.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Limitato: non pu\00F2 essere impostato dal browser')
,p_lov_return_value=>'RESTRICTED_NO_SET_FROM_BROWSER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_features
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2584581350475987525.4024)
,p_lov_name=>'APPLICATION FEATURES'
,p_lov_query=>'.'||wwv_flow_api.id(2584581350475987525.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2584585288683050797.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Pagina delle informazioni'
,p_lov_return_value=>'HELP_PAGE'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-question-circle-o"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F05.</span>',
'</span>'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2584581554892987529.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Controllo dell''accesso'
,p_lov_return_value=>'ACCESS_CONTROL'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-key"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F01.</span>',
'</span>'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595265355306643813.4024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('Generazione report su attivit\00E0')
,p_lov_return_value=>'ACTIVITY_REPORTING'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-user-chart"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F12.</span>',
'</span>'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595262246977607538.4024)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Impostazioni applicazione'
,p_lov_return_value=>'RENAME_APP'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-window-wrench"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F04.</span>',
'</span>'))
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595261094105593761.4024)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Opzioni di configurazione'
,p_lov_return_value=>'BUILD_OPTIONS'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-sliders"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F11.</span>',
'</span>'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2588944153945294189.4024)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Framework posta elettronica'
,p_lov_return_value=>'EMAIL_FRAMEWORK'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-envelope-o"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F13.</span>',
'</span>'))
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2588943841508289264.4024)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Feedback'
,p_lov_return_value=>'APP_FEEDBACK'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-comment-o"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F06.</span>',
'</span>'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2584585688224050797.4024)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Ricerca globale'
,p_lov_return_value=>'GLOBAL_SEARCH'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-search"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F09.</span>',
'</span>'))
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2588944406109298885.4024)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Notifiche'
,p_lov_return_value=>'APP_NOTIFICATIONS'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-bullhorn"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F10.</span>',
'</span>'))
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2588945090900315875.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Selezione stile tema'
,p_lov_return_value=>'THEME_SELECTOR'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-paint-brush"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F07.</span>',
'</span>'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2588944772713304631.4024)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Supporto fuso orario'
,p_lov_return_value=>'TIMEZONE'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-globe"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F03.</span>',
'</span>'))
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2584586099877050798.4024)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Profili utente'
,p_lov_return_value=>'USER_PROFILES'
,p_lov_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-CBList-icon fa fa-user"></span>',
'<span class="a-CBList-details">',
'  <span class="a-CBList-title">#DISPLAY_VALUE#</span>',
'  <span class="a-CBList-desc">&F02.</span>',
'</span>'))
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/attribute_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3174322299274441758.4024)
,p_lov_name=>'ATTRIBUTE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(3174322299274441758.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3174322524978441759.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Elemento applicazione'
,p_lov_return_value=>'APPLICATION_ITEM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-sc-app-item'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3174323392321441760.4024)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Lista di valori'
,p_lov_return_value=>'LOV'
,p_lov_template=>'#DISPLAY_VALUE#| icon-region-native-list'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3398687230162762158.4024)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Tabella'
,p_lov_return_value=>'TABLE'
,p_lov_template=>'#DISPLAY_VALUE#| icon-region-native-sql-report'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3174322962526441760.4024)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Colonna tabella'
,p_lov_return_value=>'TABLE_COLUMN'
,p_lov_template=>'#DISPLAY_VALUE#| icon-item-native-text-field'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3174324146228441761.4024)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Valori predefiniti report'
,p_lov_return_value=>'REPORT'
,p_lov_template=>'#DISPLAY_VALUE#| icon-region-native-sql-report'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3174323770579441760.4024)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Report interattivo'
,p_lov_return_value=>'IR'
,p_lov_template=>'#DISPLAY_VALUE#| icon-region-native-ir'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3398698226509801187.4024)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Metrica'
,p_lov_return_value=>'METRIC'
,p_lov_template=>'#DISPLAY_VALUE#| icon-region-native-sql-report'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authentication_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2928849837754784932.4024)
,p_lov_name=>'AUTHENTICATION OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(2928849837754784932.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2928850170148784937.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'APEX'
,p_lov_return_value=>'APEX'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authentication_options_002
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2935038601795333561.4024)
,p_lov_name=>'AUTHENTICATION.OPTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, v from (',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.CLOUD_IDM'') d ,''CLOUD_IDM'' v from dual',
'where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'')d ,:PRODUCT_NAME v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.SSO'') d ,''SSO'' v from dual',
'where wwv_flow_authentication_dev.can_use_sso_yn = ''Y''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'') d,''DBACCOUNT'' v',
'from dual',
'where wwv_flow_authentication_dev.get_internal_authentication <> ''CLOUD_IDM''',
')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/available_table_views
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2922437884276753046.4024)
,p_lov_name=>'AVAILABLE_TABLE_VIEWS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, object_name v',
'  from sys.dba_objects',
' where object_type in (''TABLE'',''VIEW'')',
'   and object_name not like ''BIN$%''',
'   and owner = :P1_SCHEMA',
'   and owner in (select schema',
'                     from wwv_flow_company_schemas',
'                    where security_group_id = :flow_security_group_id)',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/card_link
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3407941302600627214.4024)
,p_lov_name=>'CARD_LINK'
,p_lov_query=>'.'||wwv_flow_api.id(3407941302600627214.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3407941652601627216.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Collegamento scheda'
,p_lov_return_value=>'CARD_LINK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_aggregations
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2647168809994648252.4024)
,p_lov_name=>'CHART_AGGREGATIONS'
,p_lov_query=>'.'||wwv_flow_api.id(2647168809994648252.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2647169148117648254.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Valore colonna'
,p_lov_return_value=>'COLVALUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2647169545024648256.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Somma'
,p_lov_return_value=>'SUM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2647169964630648256.4024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Conteggio'
,p_lov_return_value=>'COUNT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/content_delivery_network
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3052348132285494888.4024)
,p_lov_name=>'CONTENT DELIVERY NETWORK'
,p_reference_id=>16362507680404890.4024
,p_lov_query=>'.'||wwv_flow_api.id(3052348132285494888.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052350732124494891.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Google'
,p_lov_return_value=>'GOOGLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052351106236494891.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Microsoft'
,p_lov_return_value=>'MICROSOFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052351554849494891.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'jQuery'
,p_lov_return_value=>'JQUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/default_error_display_location
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3022423575129113550.4024)
,p_lov_name=>'DEFAULT_ERROR_DISPLAY_LOCATION'
,p_lov_query=>'.'||wwv_flow_api.id(3022423575129113550.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3022423851399113560.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'In linea con campo e nella notifica'
,p_lov_return_value=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3022424234362113562.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'In linea con campo'
,p_lov_return_value=>'INLINE_WITH_FIELD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3022424644160115611.4024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'In linea nella notifica'
,p_lov_return_value=>'INLINE_WITH_FIELD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/event_name
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3407942220250638520.4024)
,p_lov_name=>'EVENT_NAME'
,p_lov_query=>'.'||wwv_flow_api.id(3407942220250638520.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3407942559318638520.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Nome evento'
,p_lov_return_value=>'EVENT_TITLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3661865821826250603.4024)
,p_lov_name=>'FORMAT MASK DYNAMIC'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from wwv_flow_format_masks'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/form_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2942439030918347706.4024)
,p_lov_name=>'FORM_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(2942439030918347706.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2942440176587347735.4024)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Affiancate'
,p_lov_return_value=>'MD_ON_TABLE_WITH_SELECTOR'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-side-md'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3314917601050455348.4024)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'In pila'
,p_lov_return_value=>'MD_GRID'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-one-md'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_iana_charset
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3032407450767161075.4024)
,p_lov_name=>'I18N_IANA_CHARSET'
,p_reference_id=>144796827445692396.4024
,p_lov_query=>'.'||wwv_flow_api.id(3032407450767161075.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032428899875161137.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-16 Little Endian'
,p_lov_return_value=>'utf-16le'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032429263656161137.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-16 Big Endian'
,p_lov_return_value=>'utf-16be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032429694795161137.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'US-ASCII'
,p_lov_return_value=>'us-ascii'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032430094554161138.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Arabic ISO-8859-6'
,p_lov_return_value=>'iso-8859-6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032430415842161138.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Arabic Windows 1256'
,p_lov_return_value=>'windows-1256'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032430845699161138.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Chinese Big5'
,p_lov_return_value=>'big5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032431286916161138.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Chinese GBK'
,p_lov_return_value=>'gbk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032431625249161139.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic ISO-8859-5'
,p_lov_return_value=>'iso-8859-5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032432039358161139.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic KOI8-R'
,p_lov_return_value=>'koi8-r'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032432431696161139.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic KOI8-U'
,p_lov_return_value=>'koi8-u'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032432804722161139.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic Windows 1251'
,p_lov_return_value=>'windows-1251'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032433258813161140.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Eastern European ISO-8859-2'
,p_lov_return_value=>'iso-8859-2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032433604528161140.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Eastern European Windows 1250'
,p_lov_return_value=>'windows-1250'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032434018695161140.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Greek ISO-8859-7'
,p_lov_return_value=>'iso-8859-7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032434461200161140.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Greek Windows 1253'
,p_lov_return_value=>'windows-1253'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032434883722161141.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hebrew ISO-8859-8-i'
,p_lov_return_value=>'iso-8859-8-i'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032435277346161141.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hebrew Windows 1255'
,p_lov_return_value=>'windows-1255'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032435678437161141.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Japanese EUC'
,p_lov_return_value=>'euc-jp'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032436066715161141.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Japanese Shift JIS'
,p_lov_return_value=>'shift_jis'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032436419408161142.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Korean EUC'
,p_lov_return_value=>'euc-kr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032436830183161142.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Northern European ISO-8859-4'
,p_lov_return_value=>'iso-8859-4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032437259126161142.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Northern European Windows 1257'
,p_lov_return_value=>'windows-1257'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032437659909161143.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Southern European ISO-8859-3'
,p_lov_return_value=>'iso-8859-3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032438037143161143.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Thai TIS-620'
,p_lov_return_value=>'tis-620'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032438462570161143.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Turkish ISO-8859-9'
,p_lov_return_value=>'iso-8859-9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032438818622161143.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Turkish Windows 1254'
,p_lov_return_value=>'windows-1254'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032439229309161144.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-8'
,p_lov_return_value=>'utf-8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032439689379161144.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vietnamese Windows 1258'
,p_lov_return_value=>'windows-1258'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032440086280161144.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Western European ISO-8859-1'
,p_lov_return_value=>'iso-8859-1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3032440420737161144.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Western European Windows 1252'
,p_lov_return_value=>'windows-1252'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_languages_locales
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(261035724719892504.4024)
,p_lov_name=>'I18N_LANGUAGES_LOCALES'
,p_reference_id=>107899321117195063.4024
,p_lov_query=>'.'||wwv_flow_api.id(261035724719892504.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698883713289179941.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Azero (az)'
,p_lov_return_value=>'az'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698884126619179942.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Afrikaans (af)'
,p_lov_return_value=>'af'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698884565244179942.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (ar)'
,p_lov_return_value=>'ar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698884924134179942.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Algeria) (ar-dz)'
,p_lov_return_value=>'ar-dz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698885318864179942.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Bahrein) (ar-bh)'
,p_lov_return_value=>'ar-bh'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698885766887179943.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Egitto) (ar-eg)'
,p_lov_return_value=>'ar-eg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698886108263179943.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Iraq) (ar-iq)'
,p_lov_return_value=>'ar-iq'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698886545881179943.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Giordania) (ar-jo)'
,p_lov_return_value=>'ar-jo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698886921018179943.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Kuwait) (ar-kw)'
,p_lov_return_value=>'ar-kw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698887365957179944.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Libano) (ar-lb)'
,p_lov_return_value=>'ar-lb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698887727399179944.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Libia) (ar-ly)'
,p_lov_return_value=>'ar-ly'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698888113690179944.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Marocco) (ar-ma)'
,p_lov_return_value=>'ar-ma'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698888532027179944.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Oman) (ar-om)'
,p_lov_return_value=>'ar-om'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698888913277179944.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Qatar) (ar-qa)'
,p_lov_return_value=>'ar-qa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698889384107179945.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Arabia Saudita) (ar-sa)'
,p_lov_return_value=>'ar-sa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698889722411179945.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Siria) (ar-sy)'
,p_lov_return_value=>'ar-sy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698890160425179945.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Tunisia) (ar-tn)'
,p_lov_return_value=>'ar-tn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698890523219179945.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (U.A.E.) (ar-ae)'
,p_lov_return_value=>'ar-ae'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698890950741179946.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Yemen) (ar-ye)'
,p_lov_return_value=>'ar-ye'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698891320266179946.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Assamese (as)'
,p_lov_return_value=>'as'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698891715182179946.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Basco (eu)'
,p_lov_return_value=>'eu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698892149923179946.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bielorusso (be)'
,p_lov_return_value=>'be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698892562723179947.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bengali (bn)'
,p_lov_return_value=>'bn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698892921433179947.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bulgaro (bg)'
,p_lov_return_value=>'bg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698893393986179947.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Catalano (ca)'
,p_lov_return_value=>'ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698893787129179947.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (zh)'
,p_lov_return_value=>'zh'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698894178492179947.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (Cina) (zh-cn)'
,p_lov_return_value=>'zh-cn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698894581951179948.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (Hong Kong) (zh-hk)'
,p_lov_return_value=>'zh-hk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698894957707179948.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (Macau SAR) (zh-mo)'
,p_lov_return_value=>'zh-mo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698895331642179948.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (Singapore) (zh-sg)'
,p_lov_return_value=>'zh-sg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698895764458179948.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (Taiwan) (zh-tw)'
,p_lov_return_value=>'zh-tw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698896174577179949.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Croato (hr)'
,p_lov_return_value=>'hr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698896507626179949.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ceco (cs)'
,p_lov_return_value=>'cs'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698896934202179949.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Danese (da)'
,p_lov_return_value=>'da'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698897308037179949.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Olandese (Belgio) (nl-be)'
,p_lov_return_value=>'nl-be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698897764862179949.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Olandese (Paesi Bassi) (nl)'
,p_lov_return_value=>'nl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698898198702179950.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (en)'
,p_lov_return_value=>'en'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698898563982179950.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Australia) (en-au)'
,p_lov_return_value=>'en-au'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698898964515179950.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Belize) (en-bz)'
,p_lov_return_value=>'en-bz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698899303545179950.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Canada) (en-ca)'
,p_lov_return_value=>'en-ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698899789641179951.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Irlanda) (en-ie)'
,p_lov_return_value=>'en-ie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698900147536179951.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Giamaica) (en-jm)'
,p_lov_return_value=>'en-jm'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698900587369179951.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Nuova Zelanda) (en-nz)'
,p_lov_return_value=>'en-nz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698900925652179951.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Filippine) (en-ph)'
,p_lov_return_value=>'en-ph'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698901376681179951.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Sudafrica) (en-za)'
,p_lov_return_value=>'en-za'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698901701857179952.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Trinidad) (en-tt)'
,p_lov_return_value=>'en-tt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698902138960179952.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Regno Unito) (en-gb)'
,p_lov_return_value=>'en-gb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698902559619179952.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Stati Uniti) (en-us)'
,p_lov_return_value=>'en-us'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698902952613179952.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Zimbabwe) (en-zw)'
,p_lov_return_value=>'en-zw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698903363355179953.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Estone (et)'
,p_lov_return_value=>'et'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698903759460179953.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'FYRO Macedone (mk)'
,p_lov_return_value=>'mk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698904125547179953.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Faeroese (fo)'
,p_lov_return_value=>'fo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698904583222179953.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Farsi (fa)'
,p_lov_return_value=>'fa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698904951521179954.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Svizzera) (fr-ch)'
,p_lov_return_value=>'fr-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698905355527179954.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Finlandese (fi)'
,p_lov_return_value=>'fi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698905780550179954.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Belgio) (fr-be)'
,p_lov_return_value=>'fr-be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698906104962179954.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Canada) (fr-ca)'
,p_lov_return_value=>'fr-ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698906552426179956.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Francia) (fr)'
,p_lov_return_value=>'fr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698906978320179956.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Lussemburgo) (fr-lu)'
,p_lov_return_value=>'fr-lu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698907342846179956.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Monaco) (fr-mc)'
,p_lov_return_value=>'fr-mc'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698907754177179956.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Gaelico (gd)'
,p_lov_return_value=>'gd'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698908113975179957.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Galiziano (gl)'
,p_lov_return_value=>'gl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698908532895179957.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tedesco (Austria) (de-at)'
,p_lov_return_value=>'de-at'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698908910242179957.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tedesco (Germania) (de)'
,p_lov_return_value=>'de'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698909392615179957.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tedesco (Liechtenstein) (de-li)'
,p_lov_return_value=>'de-li'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698909777265179958.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tedesco (Lussemburgo) (de-lu)'
,p_lov_return_value=>'de-lu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698910143726179958.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tedesco (Svizzera) (de-ch)'
,p_lov_return_value=>'de-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698910501253179958.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Greco (el)'
,p_lov_return_value=>'el'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698910916781179958.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Gujarati (gu)'
,p_lov_return_value=>'gu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698911366329179958.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ebraico (he)'
,p_lov_return_value=>'he'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698911707115179959.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hindi (hi)'
,p_lov_return_value=>'hi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698912139872179959.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ungherese (hu)'
,p_lov_return_value=>'hu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698912538551179959.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Islandese (is)'
,p_lov_return_value=>'is'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698912985780179959.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Indonesiano (id)'
,p_lov_return_value=>'id'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698913394987179960.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Italiano (Italia) (it)'
,p_lov_return_value=>'it'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698913744652179960.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Italiano (Svizzera) (it-ch)'
,p_lov_return_value=>'it-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698914118619179960.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Giapponese (ja)'
,p_lov_return_value=>'ja'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698914556956179960.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Kannada (kn)'
,p_lov_return_value=>'kn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698914999046179961.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cazaco (kk)'
,p_lov_return_value=>'kk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698915329936179961.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Konkani (kok)'
,p_lov_return_value=>'kok'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698915752211179961.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Coreano (ko)'
,p_lov_return_value=>'ko'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698916194109179961.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chirghiso (kz)'
,p_lov_return_value=>'kz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698916565719179961.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lettone (lv)'
,p_lov_return_value=>'lv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698916984728179962.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lituano (lt)'
,p_lov_return_value=>'lt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698917365042179962.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Malese (Malaysia) (ms)'
,p_lov_return_value=>'ms'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698917756432179962.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Malayalam (ml)'
,p_lov_return_value=>'ml'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698918186430179962.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Maltese (mt)'
,p_lov_return_value=>'mt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698918528206179963.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Marathi (mr)'
,p_lov_return_value=>'mr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698918903873179963.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Nepalese (India) (ne)'
,p_lov_return_value=>'ne'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698919374435179963.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norvegese (Bokmal) (nb-no)'
,p_lov_return_value=>'nb-no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698919716607179963.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norvegese (Bokmal) (no)'
,p_lov_return_value=>'no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698920168842179964.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norvegese (Nynorsk) (nn-no)'
,p_lov_return_value=>'nn-no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698920524856179964.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Oriya (or)'
,p_lov_return_value=>'or'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698920926726179964.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Polacco (pl)'
,p_lov_return_value=>'pl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698921316735179964.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portoghese (Brasile) (pt-br)'
,p_lov_return_value=>'pt-br'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698921760269179964.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portoghese (Portogallo) (pt)'
,p_lov_return_value=>'pt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698922109878179965.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Punjabi (pa)'
,p_lov_return_value=>'pa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698922512073179965.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Romeno (ro)'
,p_lov_return_value=>'ro'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698922992444179965.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Russo (ru)'
,p_lov_return_value=>'ru'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698923353711179965.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Russo (Moldavia) (ru-md)'
,p_lov_return_value=>'ru-md'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698923782122179966.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Serbo (sr)'
,p_lov_return_value=>'sr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698924130152179966.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Slovacco (sk)'
,p_lov_return_value=>'sk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698924543081179966.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Sloveno (sl)'
,p_lov_return_value=>'sl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698924977947179967.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Argentina) (es-ar)'
,p_lov_return_value=>'es-ar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698925338639179967.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Bolivia) (es-bo)'
,p_lov_return_value=>'es-bo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698925713684179967.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Cile) (es-cl)'
,p_lov_return_value=>'es-cl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698926177585179967.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Colombia) (es-co)'
,p_lov_return_value=>'es-co'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698926587236179967.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Costa Rica) (es-cr)'
,p_lov_return_value=>'es-cr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698926914058179968.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Repubblica Dominicana) (es-do)'
,p_lov_return_value=>'es-do'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698927318637179968.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Ecuador) (es-ec)'
,p_lov_return_value=>'es-ec'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698927737159179968.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (El Salvador) (es-sv)'
,p_lov_return_value=>'es-sv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698928109603179968.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Guatemala) (es-gt)'
,p_lov_return_value=>'es-gt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698928508849179969.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Honduras) (es-hn)'
,p_lov_return_value=>'es-hn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698928952284179969.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Messico) (es-mx)'
,p_lov_return_value=>'es-mx'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698929341044179969.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Nicaragua) (es-ni)'
,p_lov_return_value=>'es-ni'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698929700283179969.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Panama) (es-pa)'
,p_lov_return_value=>'es-pa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698930111118179970.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Paraguay) (es-py)'
,p_lov_return_value=>'es-py'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698930553605179970.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Spagnolo (Per\00F9) (es-pe)')
,p_lov_return_value=>'es-pe'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698930938034179970.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Portorico) (es-pr)'
,p_lov_return_value=>'es-pr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698931394992179970.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (tradizionale) (es)'
,p_lov_return_value=>'es'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698931743130179970.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Stati Uniti) (es-us)'
,p_lov_return_value=>'es-us'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698932191621179971.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Uruguay) (es-uy)'
,p_lov_return_value=>'es-uy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698932521498179971.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Venezuela) (es-ve)'
,p_lov_return_value=>'es-ve'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698932948369179971.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Svedese (sv)'
,p_lov_return_value=>'sv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698933249493179971.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Svedese (Finlandia) (sv-fi)'
,p_lov_return_value=>'sv-fi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698933608506179971.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tamil (ta)'
,p_lov_return_value=>'ta'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698934056501179972.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Telugu (te)'
,p_lov_return_value=>'te'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698934436991179972.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Thailandese (th)'
,p_lov_return_value=>'th'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698934811700179972.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Turco (tr)'
,p_lov_return_value=>'tr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698935235483179972.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ucraino (uk)'
,p_lov_return_value=>'uk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698935620939179973.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Urdu (ur)'
,p_lov_return_value=>'ur'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698936051330179973.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Uzbeco (uz)'
,p_lov_return_value=>'uz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698936467742179973.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Vietnamita (vi)'
,p_lov_return_value=>'vi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698936864835179973.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Irlandese (ga)'
,p_lov_return_value=>'ga'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698937247802179973.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Gallese (cy)'
,p_lov_return_value=>'cy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698937616681179974.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Swahili (sw)'
,p_lov_return_value=>'sw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698938064029179974.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Albanese'
,p_lov_return_value=>'sq'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698938437113179974.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Armeno'
,p_lov_return_value=>'hy'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_form_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2595628838376488076.4024)
,p_lov_name=>'INCLUDE_FORM_Y'
,p_lov_query=>'.'||wwv_flow_api.id(2595628838376488076.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595629167546488077.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Includi form'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_report_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(353723515527117365.4024)
,p_lov_name=>'INCLUDE_REPORT_Y'
,p_lov_query=>'.'||wwv_flow_api.id(353723515527117365.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(353723818904117366.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Includi report'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/is_administrative
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2996645622600931087.4024)
,p_lov_name=>'IS ADMINISTRATIVE'
,p_lov_query=>'.'||wwv_flow_api.id(2996645622600931087.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2996645967177931093.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Imposta come pagina di amministrazione'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/is_homepage
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2639480030873536264.4024)
,p_lov_name=>'IS_HOMEPAGE'
,p_lov_query=>'.'||wwv_flow_api.id(2639480030873536264.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2639480370023536266.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Imposta come home page'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_display_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3428075204157397882.4024)
,p_lov_name=>'ITEM_DISPLAY_TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select display_name d, name_with_prefix r',
'from wwv_flow_native_plugins',
'where plugin_type = ''ITEM TYPE''',
'and name_with_prefix in (',
'    ''NATIVE_TEXT_FIELD'',',
'    ''NATIVE_TEXTAREA'',',
'    ''NATIVE_SELECT_LIST'',',
'    ''NATIVE_POPUP_LOV'',',
'    ''NATIVE_RADIOGROUP'',',
'    ''NATIVE_CHECKBOX'',',
'    ''NATIVE_YES_NO'',',
'    ''NATIVE_HIDDEN'',',
'    ''NATIVE_DATE_PICKER'',',
'    ''NATIVE_NUMBER_FIELD'',',
'    ''NATIVE_TEXTAREA'',',
'    ''NATIVE_FILE'')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/jet_chart_gallery
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2639572067402672315.4024)
,p_lov_name=>'JET_CHART_GALLERY'
,p_lov_query=>'.'||wwv_flow_api.id(2639572067402672315.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2639572308217672319.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Ad aree'
,p_lov_return_value=>'area'
,p_lov_template=>'#DISPLAY_VALUE#|chart-area'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2639572724969672320.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'A barre'
,p_lov_return_value=>'bar'
,p_lov_template=>'#DISPLAY_VALUE#|chart-bar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2639574313919672321.4024)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'A ciambella'
,p_lov_return_value=>'donut'
,p_lov_template=>'#DISPLAY_VALUE#|chart-donut'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2639575505658672323.4024)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'A linee'
,p_lov_return_value=>'line'
,p_lov_template=>'#DISPLAY_VALUE#|chart-line'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2639575903894672325.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'A linee con area'
,p_lov_return_value=>'lineWithArea'
,p_lov_template=>'#DISPLAY_VALUE#|chart-line-area'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2639576794816672326.4024)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'A torta'
,p_lov_return_value=>'pie'
,p_lov_template=>'#DISPLAY_VALUE#|chart-pie'
);
end;
/
prompt --application/shared_components/user_interface/lovs/jet_chart_gallery_select
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2646907365505462337.4024)
,p_lov_name=>'JET_CHART_GALLERY_SELECT'
,p_lov_query=>'.'||wwv_flow_api.id(2646907365505462337.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2646907697589462341.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Ad aree'
,p_lov_return_value=>'area'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2646908033307462344.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'A barre'
,p_lov_return_value=>'bar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2646908742159462345.4024)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'A linee'
,p_lov_return_value=>'line'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2646909596402462345.4024)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'A torta'
,p_lov_return_value=>'pie'
);
end;
/
prompt --application/shared_components/user_interface/lovs/language_derived_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3030571620235275777.4024)
,p_lov_name=>'LANGUAGE_DERIVED_FROM'
,p_lov_query=>'.'||wwv_flow_api.id(3030571620235275777.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3030571910025275781.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Nessun NLS (applicazione non tradotta)'
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3030572315095275783.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Lingua primaria dell''applicazione'
,p_lov_return_value=>'FLOW_PRIMARY_LANGUAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3030572762231275784.4024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Browser (utilizza preferenza lingua del browser)'
,p_lov_return_value=>'BROWSER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3030573197044275784.4024)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Preferenza applicazione (utilizza FSP_LANGUAGE_PREFERENCE)'
,p_lov_return_value=>'FLOW_PREFERENCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3030573587174275784.4024)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Preferenza elemento (utilizza elemento contenente preferenza)'
,p_lov_return_value=>'ITEM_PREFERENCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3030573997459275784.4024)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Sessione'
,p_lov_return_value=>'SESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_flows
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3674102416840483201.4024)
,p_lov_name=>'LIST FLOWS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'from   wwv_flow_visible_flows f',
'where  build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'')',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2583404809878256688.4024)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(schema) a, schema b',
'from   wwv_flow_company_schemas',
'where  security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lov_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3363550887091219855.4024)
,p_lov_name=>'LOV TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(3363550887091219855.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3363551930042219856.4024)
,p_lov_disp_sequence=>0
,p_lov_disp_value=>'Strutturato'
,p_lov_return_value=>'STRUCTURED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3363551185259219856.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Dinamico'
,p_lov_return_value=>'DYNAMIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3363551549294219856.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Statico'
,p_lov_return_value=>'STATIC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/nav_position
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2595597506957104820.4024)
,p_lov_name=>'NAV_POSITION'
,p_lov_query=>'.'||wwv_flow_api.id(2595597506957104820.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595597823255104834.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Laterale'
,p_lov_return_value=>'SIDE'
,p_lov_template=>'<span class="a-Icon icon-nav-side" aria-hidden="true"></span> #DISPLAY_VALUE#'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595598259378104835.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'In alto'
,p_lov_return_value=>'TOP'
,p_lov_template=>'<span class="a-Icon icon-nav-top" aria-hidden="true"></span> #DISPLAY_VALUE#'
);
end;
/
prompt --application/shared_components/user_interface/lovs/new_or_existing_schema
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2709274728272946842.4024)
,p_lov_name=>'NEW_OR_EXISTING_SCHEMA'
,p_lov_query=>'.'||wwv_flow_api.id(2709274728272946842.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2709275016281946843.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Utilizza uno schema esistente nel database'
,p_lov_return_value=>'NO'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_lov_disp_cond=>'F4700_REQ_NEW_SCHEMA'
,p_lov_disp_cond2=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2709275215977946843.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Richiedi un nuovo schema'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1000_more_page_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(599910129386444402.4024)
,p_lov_name=>'P1000_MORE_PAGE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(599910129386444402.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(599919494157448944.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Report classico'
,p_lov_return_value=>'CLASSIC_REPORT'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-classic-rpt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(599914473819444406.4024)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Controllo temporale'
,p_lov_return_value=>'TIMELINE'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-timeline'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_lov_disp_cond=>':P1_THEME_TYPE'
,p_lov_disp_cond2=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1000_page_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2595619325504357130.4024)
,p_lov_name=>'P1000_PAGE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(2595619325504357130.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595619721367357132.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vuota'
,p_lov_return_value=>'BLANK'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-blank'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595622554281357135.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Calendario'
,p_lov_return_value=>'CALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-calendar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3314495786637316189.4024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Schede'
,p_lov_return_value=>'CARDS'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-cards'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_lov_disp_cond=>'P1_THEME_TYPE'
,p_lov_disp_cond2=>'CUSTOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595620547567357132.4024)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Grafico'
,p_lov_return_value=>'CHART'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-chart'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595620169572357132.4024)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Dashboard'
,p_lov_return_value=>'DASHBOARD'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-dashboard'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(599817715593042666.4024)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Ricerca con facet'
,p_lov_return_value=>'FACETED_SEARCH'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-faceted-search'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3314495333442316187.4024)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Form'
,p_lov_return_value=>'FORM'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-form'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595621784230357135.4024)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Griglia interattiva'
,p_lov_return_value=>'INTERACTIVE_GRID'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-interactive-grid'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595621327200357134.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Report interattivo'
,p_lov_return_value=>'REPORT'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-interactive-rpt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595622950759357135.4024)
,p_lov_disp_sequence=>10.4
,p_lov_disp_value=>'Master-Detail'
,p_lov_return_value=>'MASTER_DETAIL'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-master-detail'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3315107505714939185.4024)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Procedura guidata'
,p_lov_return_value=>'WIZARD'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-wizard'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(483394707665175300.4024)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>unistr('Pi\00F9 report')
,p_lov_return_value=>'MULTI_RPT'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-interactive-rpt'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1140_report_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(599933630533543253.4024)
,p_lov_name=>'P1140_REPORT_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(599933630533543253.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(599934700887543254.4024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Report'
,p_lov_return_value=>'CR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(599935195629543254.4024)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Schede'
,p_lov_return_value=>'CARD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p120_app_colors
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2698004887684998460.4024)
,p_lov_name=>'P120_APP_COLORS'
,p_lov_query=>'.'||wwv_flow_api.id(2698004887684998460.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2698005120905998460.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Colore 1'
,p_lov_return_value=>'#309FDB'
,p_lov_template=>'<span class="app-color app-color-1"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2698005566340998461.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Colore 2'
,p_lov_return_value=>'#2EBFBC'
,p_lov_template=>'<span class="app-color app-color-2"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2698005902074998461.4024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Colore 3'
,p_lov_return_value=>'#81BB5F'
,p_lov_template=>'<span class="app-color app-color-3"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2698006373906998463.4024)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Colore 4'
,p_lov_return_value=>'#ED813E'
,p_lov_template=>'<span class="app-color app-color-4"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2698006700015998463.4024)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Colore 5'
,p_lov_return_value=>'#E95B54'
,p_lov_template=>'<span class="app-color app-color-5"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2698008277439008881.4024)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Colore 6'
,p_lov_return_value=>'#CA589D'
,p_lov_template=>'<span class="app-color app-color-6"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2698008693252008882.4024)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Colore 7'
,p_lov_return_value=>'#5A68AD'
,p_lov_template=>'<span class="app-color app-color-7"></span>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2698009071872008882.4024)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Colore 8'
,p_lov_return_value=>'#6E8598'
,p_lov_template=>'<span class="app-color app-color-8"></span>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p120_app_icons
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2672360045214033881.4024)
,p_lov_name=>'P120_APP_ICONS'
,p_lov_query=>'.'||wwv_flow_api.id(2672360045214033881.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2672360783542033891.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Cartella'
,p_lov_return_value=>'folder'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-folder'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2672361118269033891.4024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Foglio di calcolo'
,p_lov_return_value=>'spreadsheet'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-spreadsheet'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2672361590756033892.4024)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Messaggi'
,p_lov_return_value=>'talk-bubbles'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-talk-bubbles'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699145586411626416.4024)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Analitica'
,p_lov_return_value=>'analytics'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-analytics'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699146013974630462.4024)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>'Grafico a barre'
,p_lov_return_value=>'bar-line-chart'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-bar-line-chart'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699146300507631479.4024)
,p_lov_disp_sequence=>34
,p_lov_disp_value=>'Calendario'
,p_lov_return_value=>'calendar'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-calendar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699147272435638605.4024)
,p_lov_disp_sequence=>44
,p_lov_disp_value=>'Cloud'
,p_lov_return_value=>'cloud'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-cloud'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699147530894639704.4024)
,p_lov_disp_sequence=>54
,p_lov_disp_value=>'Cubi'
,p_lov_return_value=>'cubes'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-cubes'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2672360336003033886.4024)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Posta'
,p_lov_return_value=>'email'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-email'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699147943869640428.4024)
,p_lov_disp_sequence=>64
,p_lov_disp_value=>'Database'
,p_lov_return_value=>'database'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-database'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699148332077641373.4024)
,p_lov_disp_sequence=>74
,p_lov_disp_value=>'Ingranaggio'
,p_lov_return_value=>'gear'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-gear'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699148765248642204.4024)
,p_lov_disp_sequence=>84
,p_lov_disp_value=>'Elementi grafici'
,p_lov_return_value=>'graphs'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-graphs'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699149018852643303.4024)
,p_lov_disp_sequence=>94
,p_lov_disp_value=>'Mappa'
,p_lov_return_value=>'map'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-map'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699149413407644014.4024)
,p_lov_disp_sequence=>104
,p_lov_disp_value=>'Persone'
,p_lov_return_value=>'people'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-people'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699150110351645207.4024)
,p_lov_disp_sequence=>114
,p_lov_disp_value=>'Smiley'
,p_lov_return_value=>'smiley'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-smiley'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2699150731371656095.4024)
,p_lov_disp_sequence=>124
,p_lov_disp_value=>unistr('Attivit\00E0')
,p_lov_return_value=>'todo'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-todo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2702987570335615680.4024)
,p_lov_disp_sequence=>134
,p_lov_disp_value=>'Bug'
,p_lov_return_value=>'bug'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-bug'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2702988039145618805.4024)
,p_lov_disp_sequence=>144
,p_lov_disp_value=>'Punti'
,p_lov_return_value=>'dots'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-dots'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2702988335963620469.4024)
,p_lov_disp_sequence=>154
,p_lov_disp_value=>'Misuratore'
,p_lov_return_value=>'gauge'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-gauge'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2702989530631642963.4024)
,p_lov_disp_sequence=>164
,p_lov_disp_value=>'Griglia'
,p_lov_return_value=>'grid'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-grid'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2702990096402645004.4024)
,p_lov_disp_sequence=>174
,p_lov_disp_value=>'Matita e carta'
,p_lov_return_value=>'pencil-paper'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-pencil-paper'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2702990316302646280.4024)
,p_lov_disp_sequence=>184
,p_lov_disp_value=>'Casella strumenti'
,p_lov_return_value=>'toolbox'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-toolbox'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2702990629320647262.4024)
,p_lov_disp_sequence=>194
,p_lov_disp_value=>'Chiave inglese'
,p_lov_return_value=>'wrench'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-wrench'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2702994227074670326.4024)
,p_lov_disp_sequence=>204
,p_lov_disp_value=>unistr('Attivit\00E0')
,p_lov_return_value=>'activity'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-activity'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174262117726416555.4024)
,p_lov_disp_sequence=>300
,p_lov_disp_value=>'Cronometro'
,p_lov_return_value=>'stopwatch'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-stopwatch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174262563826416555.4024)
,p_lov_disp_sequence=>301
,p_lov_disp_value=>'Grafico a torta'
,p_lov_return_value=>'pie-chart'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-pie-chart'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174262934715416555.4024)
,p_lov_disp_sequence=>302
,p_lov_disp_value=>'Segno di spunta'
,p_lov_return_value=>'check-circle'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-check-circle'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174263328775416556.4024)
,p_lov_disp_sequence=>303
,p_lov_disp_value=>'Razzo'
,p_lov_return_value=>'rocket'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-rocket'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174263755285416556.4024)
,p_lov_disp_sequence=>304
,p_lov_disp_value=>'Scudo'
,p_lov_return_value=>'shield'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-shield'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174264105771416556.4024)
,p_lov_disp_sequence=>305
,p_lov_disp_value=>'Lampadina'
,p_lov_return_value=>'lightbulb'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-lightbulb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174264503042416556.4024)
,p_lov_disp_sequence=>306
,p_lov_disp_value=>'Lucchetto'
,p_lov_return_value=>'lock'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-lock'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174264993774416557.4024)
,p_lov_disp_sequence=>307
,p_lov_disp_value=>'Nave'
,p_lov_return_value=>'ship'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-ship'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1_navigation_position
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2621239147915611502.4024)
,p_lov_name=>'P1_NAVIGATION_POSITION'
,p_lov_query=>'.'||wwv_flow_api.id(2621239147915611502.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2621239461519611503.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Menu laterale'
,p_lov_return_value=>'SIDE'
,p_lov_template=>'#DISPLAY_VALUE# | ca-Icon nav-icon nav-side'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2621239868592611505.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Menu superiore'
,p_lov_return_value=>'TOP'
,p_lov_template=>'#DISPLAY_VALUE# | ca-Icon nav-icon nav-top'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1_theme_styles
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2595731361215290332.4024)
,p_lov_name=>'P1_THEME_STYLES'
,p_lov_query=>'.'||wwv_flow_api.id(2595731361215290332.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595731647478290334.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Vita'
,p_lov_return_value=>'Vita'
,p_lov_template=>'#DISPLAY_VALUE# | theme-icon theme-vita'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595732072323290334.4024)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Vita - Scuro'
,p_lov_return_value=>'Vita - Dark'
,p_lov_template=>'#DISPLAY_VALUE# | theme-icon theme-vita-dark'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595732485910290335.4024)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Vita - Rosso'
,p_lov_return_value=>'Vita - Red'
,p_lov_template=>'#DISPLAY_VALUE# | theme-icon theme-vita-red'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595732890474290335.4024)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Vita - Ardesia'
,p_lov_return_value=>'Vita - Slate'
,p_lov_template=>'#DISPLAY_VALUE# | theme-icon theme-vita-slate'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595733222928290335.4024)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Vista'
,p_lov_return_value=>'Vista'
,p_lov_template=>'#DISPLAY_VALUE# | theme-icon theme-vista'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3286815898649753964.4024)
,p_lov_name=>'PAGE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(3286815898649753964.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3286816136407753971.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Vuota'
,p_lov_return_value=>'BLANK'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-blank'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3286816423426753976.4024)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Dashboard'
,p_lov_return_value=>'DASHBOARD'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-dashboard'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595567847775637051.4024)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Grafico'
,p_lov_return_value=>'CHART'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-dashboard'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2561899148127324757.4024)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Report classico'
,p_lov_return_value=>'CLASSIC_RPT'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-classic-rpt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2561902001788398153.4024)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Report interattivo'
,p_lov_return_value=>'INTERACTIVE_RPT'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-interactive-rpt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2577864430538034696.4024)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Griglia interattiva'
,p_lov_return_value=>'INTERACTIVE_GRID'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-interactive-grid'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2577864810590034698.4024)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Ricerca con facet'
,p_lov_return_value=>'FACETED_SEARCH'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-card-faceted-search'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2588628706152153910.4024)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Calendario'
,p_lov_return_value=>'CALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-calendar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2588629041652155067.4024)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Form'
,p_lov_return_value=>'FORM'
,p_lov_template=>'#DISPLAY_VALUE#| page-icon page-form'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3345504345772661039.4024)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Master-Detail'
,p_lov_return_value=>'MASTER_DETAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3447755827550882639.4024)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'Schede'
,p_lov_return_value=>'CARDS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3447756177637884382.4024)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'Controllo temporale'
,p_lov_return_value=>'TIMELINE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3447917238443966847.4024)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'Procedura guidata'
,p_lov_return_value=>'WIZARD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pagination
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3348566714295666169.4024)
,p_lov_name=>'PAGINATION'
,p_lov_query=>'.'||wwv_flow_api.id(3348566714295666169.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3348567074901666172.4024)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Intervalli di righe da X a Y di Z'
,p_lov_return_value=>'ROWS_X_TO_Y_OF_Z'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3348567471986666172.4024)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>'Intervalli di righe da X a Y'
,p_lov_return_value=>'ROWS_X_TO_Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/report_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2595616854306352005.4024)
,p_lov_name=>'REPORT_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(2595616854306352005.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595617121416352006.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Report interattivo'
,p_lov_return_value=>'INTERACTIVE_RPT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2595617998727352007.4024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Report classico'
,p_lov_return_value=>'CLASSIC_RPT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/right_to_left
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(560908550288645029.4024)
,p_lov_name=>'RIGHT-TO-LEFT'
,p_lov_query=>'.'||wwv_flow_api.id(560908550288645029.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(560908890865645033.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Da sinistra a destra'
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(560909229625645034.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Da destra a sinistra'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/run_when_creating_app
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3011477941821019938.4024)
,p_lov_name=>'RUN WHEN CREATING APP'
,p_lov_query=>'.'||wwv_flow_api.id(3011477941821019938.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3011478276914019939.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esegui durante la creazione dell''applicazione'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/seconds
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3052299639682461644.4024)
,p_lov_name=>'SECONDS'
,p_reference_id=>218750809842831008.4024
,p_lov_query=>'.'||wwv_flow_api.id(3052299639682461644.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052313333207461705.4024)
,p_lov_disp_sequence=>0
,p_lov_disp_value=>'10 secondi'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052313763928461705.4024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'1 minuto'
,p_lov_return_value=>'60'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052314194318461706.4024)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'10 minuti'
,p_lov_return_value=>'600'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052314561907461706.4024)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'30 minuti'
,p_lov_return_value=>'1800'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052314905802461706.4024)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'1 ora'
,p_lov_return_value=>'3600'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052315380890461706.4024)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'2 ore'
,p_lov_return_value=>'7200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052315720757461707.4024)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'3 ore'
,p_lov_return_value=>'10800'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052316192741461707.4024)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'4 ore'
,p_lov_return_value=>'14400'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052316593027461707.4024)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'6 ore'
,p_lov_return_value=>'21600'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052316902496461707.4024)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'12 ore'
,p_lov_return_value=>'43200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052317383400461708.4024)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'1 giorno'
,p_lov_return_value=>'86400'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052317744167461708.4024)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'2 giorni'
,p_lov_return_value=>'172800'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052318196277461708.4024)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'3 giorni'
,p_lov_return_value=>'259200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052318503570461709.4024)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'4 giorni'
,p_lov_return_value=>'345600'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052318964100461709.4024)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>'1 settimana'
,p_lov_return_value=>'604800'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052319386375461709.4024)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>'2 settimane'
,p_lov_return_value=>'1209600'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052319724314461709.4024)
,p_lov_disp_sequence=>155
,p_lov_disp_value=>'4 settimane'
,p_lov_return_value=>'2419200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052320114213461710.4024)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>'10 settimane'
,p_lov_return_value=>'6048000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3052320587074461710.4024)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>'1 anno'
,p_lov_return_value=>'31536000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/source_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2593539478572840546.4024)
,p_lov_name=>'SOURCE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(2593539478572840546.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2593540111329840547.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Tabella o vista'
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2593539775589840547.4024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Query SQL'
,p_lov_return_value=>'SQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/translations
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2928230523118997204.4024)
,p_lov_name=>'TRANSLATIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select l.translated_lang_name as lang_name, f.flow_language',
'from ( select flow_language',
'          from wwv_flows f',
'         where id = :APP_ID',
'         union',
'        select flow_language',
'          from wwv_flows f',
'         where id in ( select translation_flow_id',
'                         from wwv_flow_language_map',
'                        where primary_language_flow_id = :APP_ID )',
'      ) f,',
'      wwv_flow_languages l',
'where f.flow_language = l.lang_id',
'order by nlssort( l.translated_lang_name, ''NLS_SORT=binary'' )'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/wizard_page_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(3315174268901073640.4024)
,p_lov_name=>'WIZARD_PAGE_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(3315174268901073640.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3315174580312073643.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Finestra di dialogo modale'
,p_lov_return_value=>'MODAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3315174903811073644.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Pagina normale'
,p_lov_return_value=>'NORMAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2660244068801532757.4024)
,p_lov_name=>'YES_NO'
,p_lov_query=>'.'||wwv_flow_api.id(2660244068801532757.4024)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2660244358492532761.4024)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('S\00EC')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2660244720718532764.4024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_1_iframe_for_object_browser
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2591718988900841732.4024)
,p_theme_id=>101
,p_name=>'APEX 4.1 - Iframe for Object Browser.it'
,p_internal_name=>'APEX_4.1_IFRAME_FOR_OBJECT_BROWSER'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'<title>#TITLE#</title><link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#</head><body class="#PAGE_CSS_CLASSES#" #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <table id="apex-page-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'      <tbody>',
'        <tr>',
'          <td class="apex-page-content" width="100%">',
'            #REGION_POSITION_02#',
'            <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>	    ',
'	      </td>',
'          <td class="apex-page-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</td>     ',
'        </tr>',
'      </tbody>',
'    </table>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#<a name="END"></a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/done_minimal_for_ppr_pulls
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2598417890427334950.4024)
,p_theme_id=>101
,p_name=>'(Done) Minimal For PPR Pulls.it'
,p_internal_name=>'DONE_MINIMAL_FOR_PPR_PULLS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'',
'<head>',
'',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<title>#TITLE#</title>',
'</head>',
'<body onload="parent.htmldb_PageLoaded(this)">#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<htmldb:SUCCESS_MESSAGE><div id="SUCCESS_MESSAGE">#SUCCESS_MESSAGE#</div></htmldb:SUCCESS_MESSAGE>',
'<htmldb:NOTIFICATION_MESSAGE><div id="NOTIFICATION_MESSAGE">#NOTIFICATION_MESSAGE#</div></htmldb:NOTIFICATION_MESSAGE>',
'<htmldb:GLOBAL_NOTIFICATION><div id="GLOBAL_NOTIFICATION">#GLOBAL_NOTIFICATION#</div></htmldb:GLOBAL_NOTIFICATION>',
'<htmldb:REGION_POSITION_01><div id="REGION_POSITION_01">#REGION_POSITION_01#</div></htmldb:REGION_POSITION_01>',
'<htmldb:REGION_POSITION_02><div id="REGION_POSITION_02">#REGION_POSITION_02#</div></htmldb:REGION_POSITION_02>',
'<htmldb:REGION_POSITION_03><div id="REGION_POSITION_03">#REGION_POSITION_03#</div></htmldb:REGION_POSITION_03>',
'<htmldb:REGION_POSITION_04><div id="REGION_POSITION_04">#REGION_POSITION_04#</div></htmldb:REGION_POSITION_04>',
'<htmldb:REGION_POSITION_05><div id="REGION_POSITION_05">#REGION_POSITION_05#</div></htmldb:REGION_POSITION_05>',
'<htmldb:REGION_POSITION_06><div id="REGION_POSITION_06">#REGION_POSITION_06#</div></htmldb:REGION_POSITION_06>',
'<htmldb:REGION_POSITION_08><div id="REGION_POSITION_08">#REGION_POSITION_08#</div></htmldb:REGION_POSITION_08>',
'<htmldb:BOX_BODY><div id="BOX_BODY">#BODY#</div></htmldb:BOX_BODY>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/done_popup
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2603855610882355837.4024)
,p_theme_id=>101
,p_name=>'(Done) Popup.it'
,p_internal_name=>'DONE_POPUP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'    <title>#TITLE#</title>',
'    <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'    ',
'    #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="aPopupPage">',
'    <noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>#REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##BODY#</div>',
'<div style="text-align:middle;">#REGION_POSITION_08#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_1_query_builder
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2606943813583767007.4024)
,p_theme_id=>101
,p_name=>'APEX 4.1 - Query Builder .it'
,p_internal_name=>'APEX_4.1_QUERY_BUILDER_'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin" style="overflow:auto;">',
'    <table summary="" cellpadding="0" cellspacing="0" border="0" id="qbTable" width="98%" height="70%">',
'      <tr>',
'        <td id="qbSideBar" valign="top" width="200" style="width:200px;"><div id="qbLeftHeader">#REGION_POSITION_02#</div>',
'          <div id="dbaseObjectsSlider"><br />',
'          </div></td>',
'        <td id="v_slide" class="obSlideBar" valign="middle" width="5" style="width:5px;"><span id="qbSideBartoggle" onclick="qb_toggleSideBar();"><img id="qbSideBar_toggle" src="#IMAGE_PREFIX#qb/close.png" alt="" class="htmldbPseudoButton" /></span><'
||'/td>',
'        <td valign="top" class="qbFrameHolder" id="qbFrameHolder"><div id="qbRightHeader">#REGION_POSITION_03#</div>',
'          <div id="qbTableHolder" class="d1">',
'            <div align="right">',
'              <div id="qbLinkHolder"></div>',
'            </div>',
'          </div>',
'          <div id="h_slide" onmousedown="qb_hPosition(this);">&nbsp;</div>',
'          <div id="qbBottomHolder" class="d2">#REGION_POSITION_04#',
'            <div id="htmlTabHolder" class="qbTabHolder">#REGION_POSITION_05#</div>',
'            <br />',
'            <br />',
'          </div></td>',
'      </tr>',
'    </table>',
'  <div>#REGION_POSITION_01##BODY#</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>16
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/done_sql_command_popup
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2606944106213767008.4024)
,p_theme_id=>101
,p_name=>'(Done) SQL Command ( Popup ).it'
,p_internal_name=>'DONE_SQL_COMMAND_POPUP_'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<script src="#IMAGE_PREFIX#sc/sc_slider.js" type="text/javascript"></script>',
'<script src="#IMAGE_PREFIX#sc/sc_core.js" type="text/javascript"></script>',
'<script type="text/javascript">',
'document.onkeypress  = sc_quickKeys;',
'</script>',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbBreadcrumbTop"><br /></div>',
'<table class="htmldbLayout" cellpadding="0" cellspacing="0" border="0" summary="">',
'<tr>',
'<td class="htmldbBreadcrumbRegion"><div class="htmldbBreadcrumbs"><br /></td>',
'<td rowspan="2" class="htmldbRunEditRegion">#REGION_POSITION_06#</td></tr>',
'<tr>',
'<td id="htmldbRunEditZag"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" width="1" height="6" /></td>',
'</tr>',
'</table><a name="SkipRepNav"></a><div id="htmldbMessageHolder" style="padding:0px;margin:0px;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<table border="0" cellspacing="0"  cellpadding="0" align="center" summary="" id="SqlAndResults" width="100%">',
'<tr>',
'<td valign="top">',
'<div id="scRightHeader">#REGION_POSITION_01#</div>',
'<div id="scCommandHolder" class="d1">#REGION_POSITION_03#</div>',
'<div id="h_slide"><br /></div>',
'<div id="scBottomHolder">#REGION_POSITION_04#<div id="htmlTabHolder" >#REGION_POSITION_05#</div></div>  ',
'</td>',
'</tr>',
'</table>',
'#BOX_BODY##REGION_POSITION_02#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'<a name="END"><br /></a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>13
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2664790393372442842.4024)
,p_theme_id=>101
,p_name=>'Printer Friendly.it'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<title>#TITLE#</title><link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#</head><body class="#PAGE_CSS_CLASSES#" #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>'<br />#BODY#'
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="hideMeButHearMe">#NOTIFICATION_MESSAGE_HEADING#</h2>',
'<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>5
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/done_login_and_logout_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2664881609444819744.4024)
,p_theme_id=>101
,p_name=>'(Done) Login and Logout Page.it'
,p_internal_name=>'DONE_LOGIN_AND_LOGOUT_PAGE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbLogo2"></div>',
'<div class="htmldbSep"><br/></div>',
'<div id="htmldbBreadcrumbTop"><br /></div>',
'<div class="htmldbBreadcrumbRegion"><br /></div>',
'<a name="SkipRepNav"></a>',
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'<table summary="" cellpadding="0" cellspacing="0" border="0" height="70%">',
'<tr>',
'<td valign="top">#REGION_POSITION_01#</td>',
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>',
'<td valign="top">#REGION_POSITION_02##REGION_POSITION_04##BODY#</td>',
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>',
'<td valign="top" style="width:100%"><div style="float:right;">#REGION_POSITION_03##REGION_POSITION_05#</div></td>',
'</tr>',
'</table>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="htmldbFlowL">&MSG_LANGUAGE.: &BROWSER_LANGUAGE.</div>',
'<div class="htmldbFlowV">#FLOW_VERSION#</div>',
'<div class="htmldbNewBottom">',
'<div class="htmldbNewBottom1"><br /></div>',
'<div class="htmldbNewBottom2">&MSG_COPYRIGHT.</div>',
'<br />',
'</div>',
'#FORM_CLOSE#',
'<a name="END"><br /></a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>6
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2704744005996589822.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Dialog.it'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_1_iframe_object_browser_wizard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2733694518999627226.4024)
,p_theme_id=>101
,p_name=>'APEX 4.1 - Iframe Object Browser (Wizard).it'
,p_internal_name=>'APEX_4.1_IFRAME_OBJECT_BROWSER_WIZARD'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'<title>#TITLE#</title><link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#</head><body class="#PAGE_CSS_CLASSES#" #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'<table summary="" cellpadding="0" border="0" cellspacing="0" width="100%">',
'<tr>',
'<td valign="top">#REGION_POSITION_01#<br /></td>',
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>',
'<td width="100%" valign="top" nowrap="nowrap">#BODY#</td>',
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#<a name="END"></a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2970811450590621114.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Right Side Bar.it'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(4482336506897000055.4024)
,p_page_template_id=>wwv_flow_api.id(2970811450590621114.4024)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(4482336688063000055.4024)
,p_page_template_id=>wwv_flow_api.id(2970811450590621114.4024)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(4482336765466000055.4024)
,p_page_template_id=>wwv_flow_api.id(2970811450590621114.4024)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(4482336872711000055.4024)
,p_page_template_id=>wwv_flow_api.id(2970811450590621114.4024)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(4482336976448000055.4024)
,p_page_template_id=>wwv_flow_api.id(2970811450590621114.4024)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(4482337049696000055.4024)
,p_page_template_id=>wwv_flow_api.id(2970811450590621114.4024)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(4482337131179000055.4024)
,p_page_template_id=>wwv_flow_api.id(2970811450590621114.4024)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3221353480673840388.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - No Side Bar.it'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3272976625713321802.4024)
,p_theme_id=>101
,p_name=>'APEX 5.1.1 - Page Wizard Dialog.it'
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7]><html class="no-js lt-ie10 lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7]><html class="no-js lt-ie10 lt-ie9 lt-ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8]><html class="no-js lt-ie10 lt-ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9]><html class="no-js lt-ie10" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if gt IE 9]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'',
'<head>',
'',
'  <meta charset="utf-8">  ',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'#TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'#PAGE_CSS#',
'',
'    ',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'    ',
'    ',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'auto'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--wizard'
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3273510885686244662.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Edit Screen.it'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(4482336307736000055.4024)
,p_page_template_id=>wwv_flow_api.id(3273510885686244662.4024)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(4482336471391000055.4024)
,p_page_template_id=>wwv_flow_api.id(3273510885686244662.4024)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3286599848719423369.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Wizard Page.it'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sign_up_wizard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3286607596938476944.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Sign Up Wizard.it'
,p_internal_name=>'APEX_5.0_SIGN_UP_WIZARD'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--simpleWizard" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'<div class="u-Layout u-Layout--centerVertically">',
'  #BODY#',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sql_workshop_iframe_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3335020656196012965.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - SQL Workshop iFrame Page.it'
,p_internal_name=>'APEX_5.0_SQL_WORKSHOP_IFRAME_PAGE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="sql-workshop-iframe-page a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_restful_web_services
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3338858083993441533.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - RESTful Web Services.it'
,p_internal_name=>'APEX_5.0_RESTFUL_WEB_SERVICES'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="a-Page--webservices #PAGE_CSS_CLASSES#">',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <aside class="a-Side a-Side--left a-Side--large">',
'        #REGION_POSITION_03#',
'    </aside>',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_object_browser_to_be_deleted
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3339417198456536654.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Object Browser (to be deleted).it'
,p_internal_name=>'APEX_5.0_OBJECT_BROWSER_TO_BE_DELETED'
,p_is_popup=>false
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.jQuery(''#P1003_SQL_COMMAND1'').bind(''keydown'', function(e){',
'  sc_quickKeys(e);',
'});'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <script src="#IMAGE_PREFIX#sw/minified/htmldb_data.min.js" type="text/javascript" defer="defer"></script>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Body">',
'    <main class="a-Main">     ',
'    <table summary="" cellpadding="0" cellspacing="0" border="0" id="obTable" style="margin:5px;">',
'      <tr>',
'        <td width="200" id="obLeftColumn" valign="top"><div id="obLeftHeader" style="border-left:none;">#REGION_POSITION_01#</div>',
'          <div id="ob_ObjectsSlider">#REGION_POSITION_03#<br />',
'          </div></td>',
'        <td id="v_slide" class="obSlideBar" valign="middle" width="2px"><span id="qbSideBartoggle" onclick="html_ToggleElement(''obLeftColumn'')"><img id="qbSideBar_toggle" src="#IMAGE_PREFIX#qb/close.png" class="htmldbPseudoButton" /></span></td>',
'        <td valign="top" class="dbaseFrameHolder" width="100%" id="dbaseFrameHolder"><table id="obRightHeader" width="100%" summary="" cellpadding="0" border="0" cellspacing="0">',
'            <tr>',
'              <td id="ob_ObjectsDetail" width="100%"><br /></td>',
'              <td>#REGION_POSITION_02#</td>',
'            </tr>',
'          </table>',
'          #REGION_POSITION_04#</td>',
'      </tr>',
'    </table>',
'        #BODY#  ',
'    </main>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_workspace_login
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3365548215818617994.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Workspace Login.it'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN'
,p_is_popup=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$(function() {',
'  $(''a[href*="#"]:not([href="#"])'').click(function() {',
'    if (location.pathname.replace(/^\//,'''') == this.pathname.replace(/^\//,'''') && location.hostname == this.hostname) {',
'      var target = $(this.hash);',
'      target = target.length ? target : $(''[name='' + this.hash.slice(1) +'']'');',
'      if (target.length) {',
'        $(''html,body'').animate({',
'          scrollTop: target.offset().top',
'        }, 500);',
'        return false;',
'      }',
'    }',
'  });',
'});'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'  ',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--login #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'<div class="u-Layout u-Layout--centerVertically a-Login-slide" id="top">',
'  #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Login-container">',
'  #BODY#',
'  </div>',
'  <div class="a-Login-slideNav a-Login-slideNav--down">',
'    <a href="#info" class="a-Login-slideNavLink"><span class="a-Icon icon-shuttle-down"></span></a>',
'  </div>',
'</div>',
'<div class="u-Layout u-Layout--centerVertically a-Login-slide a-Login-slide--secondary" id="info">',
'  <div class="a-Login-secondaryContent">',
'  #REGION_POSITION_03#',
'  </div>',
'  <div class="a-Login-slideNav  a-Login-slideNav--up">',
'    <a href="#top" class="a-Login-slideNavLink"><span class="a-Icon icon-shuttle-up"></span></a>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_query_builder_pop_up_to_be_deleted
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3371529743867403942.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Query Builder Pop Up (to be deleted).it'
,p_internal_name=>'APEX_5.0_QUERY_BUILDER_POP_UP_TO_BE_DELETED'
,p_is_popup=>false
,p_inline_css=>'.a-Header, #R387929284740561918 {display: none;}'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <script src="#IMAGE_PREFIX#sw/minified/htmldb_data.min.js" type="text/javascript" defer="defer"></script>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sql_commands_popup_to_be_deleted
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3381410010169001132.4024)
,p_theme_id=>101
,p_name=>'APEX 5.0 - SQL Commands Popup (to be deleted).it'
,p_internal_name=>'APEX_5.0_SQL_COMMANDS_POPUP_TO_BE_DELETED'
,p_is_popup=>false
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#sc/sc_slider.js',
'#IMAGE_PREFIX#sc/sc_core.js'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.jQuery(''#P1003_SQL_COMMAND1'').bind(''keydown'', function(e){',
'  sc_quickKeys(e);',
'});'))
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-Header{',
'    display: none !important;',
'}',
'.a-Breadcrumb {',
'    display: none !important;',
'}',
'',
'.a-ControlBar .a-Form-inputContainer {',
'    float: left;',
'}'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Body">',
'    <main class="a-Main">     ',
'      <table border="0" cellspacing="0"  cellpadding="0" align="center" summary="" id="SqlAndResults" width="100%">',
'        <tr>',
'          <td valign="top"><div id="scRightHeader">#REGION_POSITION_01#</div>',
'            <div id="scCommandHolder" class="d1">#REGION_POSITION_03#</div>',
'            <div id="h_slide"><br />',
'            </div>',
'            <div id="scBottomHolder">#REGION_POSITION_04#',
'              <div id="htmlTabHolder" >#REGION_POSITION_05#</div>',
'            </div></td>',
'        </tr>',
'      </table>',
'        #BODY##REGION_POSITION_02#   ',
'    </main>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(2583919293963280507.4024)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/a_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(2610383412116095734.4024)
,p_template_name=>'<a> button'
,p_internal_name=>'<A>_BUTTON'
,p_template=>'<a href="#LINK#" title="#LABEL!ATTR#" style="font-size:10px;margin:2px;">#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>0
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="xpbutton" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tbody class="FFFFFF">',
'<tr>',
'<td class="L" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'<td class="C"><a href="#LINK#">#LABEL#</a></td>',
'<td class="R" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'</tr>',
'</tbody>',
'</table>'))
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_1_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(2859691107686228274.4024)
,p_template_name=>'APEX 4.1 - Button'
,p_internal_name=>'APEX_4.1_BUTTON'
,p_template=>'<button class="aButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_hot_template=>'<button class="aButton hotButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="button-gray" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> ',
'',
'',
'<a href="#LINK#" class="button-orange" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> '))
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(2988804730938183125.4024)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/dialog_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(3012517609439119859.4024)
,p_template_name=>'Dialog Button'
,p_internal_name=>'DIALOG_BUTTON'
,p_template=>'"#LABEL!ATTR#":#BUTTON_ATTRIBUTES#'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(3214935748485245802.4024)
,p_template_name=>'APEX 5.0 - Icon Badge Menu Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(3214935870969250916.4024)
,p_template_name=>'APEX 5.0 - Icon Badge Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><span class="a-But'
||'ton-badge"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><spa'
||'n class="a-Button-badge"></span></button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_text_link
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(3365552764774679721.4024)
,p_template_name=>'APEX 5.0 - Text Link'
,p_internal_name=>'APEX_5.0_TEXT_LINK'
,p_template=>'<a href="#LINK#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</a>'
,p_hot_template=>'<a href="#LINK#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_1_1_page_wizard_section
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2584574193315975428.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageWizard-section #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2>#TITLE##HELP#</h2>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.1.1 - Page Wizard Section'
,p_internal_name=>'APEX_5.1.1_PAGE_WIZARD_SECTION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2586890391916064979.4024)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div with ID and Region Attributes'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2601269795393996833.4024)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #COMPONENT_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Page Anchors'
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/top_bar_c_htmldbtopbarm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2601271888770996836.4024)
,p_layout=>'TABLE'
,p_template=>'<table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class="'
||'R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>'
,p_page_plug_template_name=>'Top Bar (c:htmldbTopBarM)'
,p_internal_name=>'TOP_BAR_C:HTMLDBTOPBARM'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_translate_this_template=>'N'
,p_template_comment=>'<table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td width="10"><img src="#IMAGE_PREFIX#htmldb/builder/bar_top.png" width="10" height="8" alt="" /></td><'
||'td rowspan="3" valign="middle" class="L">#BODY#</td><td rowspan="3" width="30" class="C"><br /></td><td rowspan="3" valign="middle" class="R" align="right" style="white-space:nowrap;"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHAN'
||'GE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr><tr><td style="background-image:url(#IMAGE_PREFIX#htmldb/builder/bar_bg.png)"><br /></td></tr><tr><td><img src="#IMAGE_PREFIX#htmldb/builder/bar_bottom.png" width="10" height="8"  alt="" /></td></tr>'
||'</tbody></table>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/top_bar_white_collapsed
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2601501911896508337.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" class="top-bar" #REGION_ATTRIBUTES#><div style="float: left">#BODY#</div><div style="float: left">#CLOSE##EDIT##DELETE##CREATE##CREATE2##PREVIOUS##NEXT#</div></div>',
''))
,p_page_plug_template_name=>'Top Bar (white) (collapsed)'
,p_internal_name=>'TOP_BAR_WHITE_COLLAPSED'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>21
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/dhtml_hidden_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2602459589575700630.4024)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" style="display:none;">#BODY#</div>'
,p_page_plug_template_name=>'(DHTML) Hidden with ID (c:htmldbHID)'
,p_internal_name=>'DHTML_HIDDEN_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_message_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2613249515740447736.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-SystemMessage #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Message Region'
,p_internal_name=>'APEX_5.0_MESSAGE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2626126299499639372.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardHeader" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Header'
,p_internal_name=>'APEX_5.0_WIZARD_HEADER'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/ppr_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2664982500969247843.4024)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#"><htmldb:PPR_#REGION_ID#>#BODY#</htmldb:PPR_#REGION_ID#></div>'
,p_page_plug_template_name=>'PPR Region'
,p_internal_name=>'PPR_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/no_buttons_no_title
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2674461889133348159.4024)
,p_layout=>'TABLE'
,p_template=>'<table class="htmldbRR" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#"><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>'
,p_page_plug_template_name=>'No Buttons No Title'
,p_internal_name=>'NO_BUTTONS_NO_TITLE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/popup_dialog
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2724541718684288181.4024)
,p_layout=>'TABLE'
,p_template=>'<table style="display:none;position:absolute;background-color:#EEEEEE;border:#000000 solid 1px;padding:0px;text-align:center;font-size:12px;color:#000000;" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><tr><td class="h'
||'tmldbWizardHeader"><h2>#TITLE#</h2></td><td class="htmldbWizardHeader" align="right"><span onClick="dhtml_CloseDialog(this);"><img src="#IMAGE_PREFIX#qb/vertical_close.png" /></span></td></tr><tr><td colspan="2" class="htmldbWizardBody">#BODY#</td></'
||'tr><tr><td colspan="2" align="right">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</td></tr></table>'
,p_page_plug_template_name=>'Popup Dialog'
,p_internal_name=>'POPUP_DIALOG'
,p_theme_id=>101
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/horizontal_body_and_button_positions
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2733855215457005326.4024)
,p_layout=>'TABLE'
,p_template=>'<table  cellpadding="0" cellspacing="0" border="0" summary="" class="htmldbButtonPositionsOnly" id="#REGION_STATIC_ID#"><tbody><tr><td>#BODY#</td><td style="padding-right:25px;">#CLOSE#</td><td>#PREVIOUS#</td><td>#NEXT#</td><td>#DELETE#</td><td>#CHAN'
||'GE##EDIT#</td><td>#CREATE#</td><td>#CREATE2#</td><td>#HELP#</td></tr></tbody></table>'
,p_page_plug_template_name=>'Horizontal Body and Button Positions'
,p_internal_name=>'HORIZONTAL_BODY_AND_BUTTON_POSITIONS'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2758528811846759332.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-PageColumn-header">',
'    <h2 class="a-PageColumn-heading">#TITLE#</h2>',
'  </div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2758529294157796426.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Toolbar-items a-Toolbar-items--left">#PREVIOUS#</div>',
'  <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar'
,p_internal_name=>'APEX_5.0_TOOLBAR'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2758544003863874977.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--left #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Left)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_LEFT'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_right
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2758544719016898298.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--right #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Right)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_RIGHT'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2758545604256903488.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn-body #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column (Body)'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN_BODY'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_accordion
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2758661890054767997.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUBREGIONS#',
'</div>',
'<script type="text/javascript">',
'  apex.jQuery( "#accordion" ).accordion({',
'    icons: false,',
'    header: ".a-Region-header",',
'    heightStyle: ''content'',',
'    collapsible: true',
'  });',
'</script>'))
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Accordion-item">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Accordion'
,p_internal_name=>'APEX_5.0_ACCORDION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2767126796965963192.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUB_REGION_HEADERS#',
'  #SUB_REGIONS#',
'</div>',
'<script type="text/javascript">',
'    $("##REGION_STATIC_ID#").tabs({',
'      create: function() {',
'        $(this).addClass(''ui-tabs--simpleInset'')',
'      }',
'    });',
'</script>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#">#SUB_REGION_TITLE#</a></li>'
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer-item" id="#SUB_REGION_ID#">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Tabs'
,p_internal_name=>'APEX_5.0_TABS'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/tree_context_menu
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2789923400863815363.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script type="text/javascript">',
'var #REGION_STATIC_ID#=#BODY#;',
'</script>'))
,p_page_plug_template_name=>'Tree Context Menu'
,p_internal_name=>'TREE_CONTEXT_MENU'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/loading_region_hidden_by_default
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2811142913752487499.4024)
,p_layout=>'TABLE'
,p_template=>'<div class="htmldbLoadingRegion" id="#REGION_STATIC_ID#" style="display:none;">#BODY#<br /><img src="#IMAGE_PREFIX#htmldb/icons/wait.gif"  id="loadingIcon" alt="" /></div>'
,p_page_plug_template_name=>'Loading Region (Hidden by Default)'
,p_internal_name=>'LOADING_REGION_HIDDEN_BY_DEFAULT'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/4500_results_region_template
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2938888314478328196.4024)
,p_layout=>'TABLE'
,p_template=>'<table cellspacing="2" cellpadding="2" border="0" width="100%" bgcolor="#C5D5C5" summary="" id="#REGION_STATIC_ID#"><tr><td align=left bgcolor="#C5D5C5"><font class="regionheader" face=aria color=white>&nbsp;<h2>#TITLE#</h2></font></td><td width="1%"'
||' align="right"  bgcolor="#C5D5C5">#EXPAND#</td><td width="1%" align="right"  bgcolor="#C5D5C5">#CLOSE#</td></tr></table>#BODY#<p/>'
,p_page_plug_template_name=>'(4500) results_region_template'
,p_internal_name=>'4500_RESULTS_REGION_TEMPLATE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/4500_simple_small_box
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2938888500664328199.4024)
,p_layout=>'TABLE'
,p_template=>'<table width="400" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><tr><td>#BODY#</td></tr></table>'
,p_page_plug_template_name=>'(4500) simple small box'
,p_internal_name=>'4500_SIMPLE_SMALL_BOX'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_translate_this_template=>'N'
,p_template_comment=>'No region formatting'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2983766147992137991.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_dialog
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3012513290302116971.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#"  class="a-DialogRegion js-regionDialog #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# style="display:none" title="#TITLE#">',
'  <div class="a-DialogRegion-body">',
'#BODY#',
'  </div>',
'  <div class="a-DialogRegion-buttons">',
'     <div class="a-ButtonRegion a-ButtonRegion--dialogRegion">',
'       <div class="a-ButtonRegion-wrap">',
'         <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'         <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'       </div>',
'     </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region Dialog'
,p_internal_name=>'APEX_5.0_REGION_DIALOG'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_template_options=>'js-draggable:js-modal:js-resizable'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3262269949210718587.4024)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3271069058970016268.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'      <button class="a-Button a-Button--icon a-Button--hideShow" type="button"></button>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>101
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3286693190338347807.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Wizard-region a-Form #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Wizard-regionHeader">#REGION_HEADER#</div>',
'  <div class="a-Wizard-regionBody">#BODY#</div>',
'  <div class="a-Wizard-regionFooter">#REGION_FOOTER#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Region'
,p_internal_name=>'APEX_5.0_WIZARD_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_title_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3287384588973547661.4024)
,p_layout=>'TABLE'
,p_template=>'<div class="#REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#><h1 class="a-Wizard-title">#TITLE#</h1></div>'
,p_page_plug_template_name=>'APEX 5.0 - Wizard Title Region'
,p_internal_name=>'APEX_5.0_WIZARD_TITLE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3300810815961795652.4024)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>208928010704475743.4024
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_hidden_heading
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3301748405466464586.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region (Hidden Heading)'
,p_internal_name=>'APEX_5.0_REGION_HIDDEN_HEADING'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_iframe_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3321664782165928798.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--iframe #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'  <div class="a-Region-iframeButtons">',
'    <div class="a-ButtonRegion">',
'      <div class="a-ButtonRegion-wrap">',
'        <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'        <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'          <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'        </div>',
'        <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - iFrame Region'
,p_internal_name=>'APEX_5.0_IFRAME_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--paddedBody'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3330277939666606656.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>101
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_accordion_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Accordion Region'
,p_internal_name=>'APEX_5.0_ACCORDION_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_workspace_login_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3365552953046687584.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Login-region a-Form--stretchInputs #REGION_CSS_CLASSES#" id="#REGION_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Login-header">',
'    <span class="a-Login-logo gi-icon-apex-logo-icon"></span>',
'    <h1 class="a-Login-title">#TITLE#</h1>',
'  </div>',
'  <div class="a-Login-body">',
'    #BODY#',
'  </div>',
'  <div class="a-Login-buttons">',
'    #NEXT#',
'  </div>',
'  <div class="a-Login-links">',
'    #EDIT##CREATE#',
'  </div>',
'  #SUB_REGIONS#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Workspace Login Region'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_workspace_login_content_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3365628682004899102.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Login-infoRegion #REGION_CSS_CLASSES#" id="#REGION_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Login-infoRegion-header">',
'    <h2 class="a-Login-infoRegion-title">#TITLE#</h2>',
'  </div>',
'  <div class="a-Login-infoRegion-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Workspace Login Content Region'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_CONTENT_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_1_tabs_with_icons_text
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3678578060703653018.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Tabs-toolbar a-Toolbar">',
'    #SUB_REGION_HEADERS#',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  #SUB_REGIONS#',
'</div>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#"><span title="#SUB_REGION_TITLE#" class="a-Icon #SUB_REGION_ICON_CSS_CLASSES#"></span><span class="a-Tabs-label">#SUB_REGION_TITLE#</span></a></li>'
,p_sub_plug_template=>'#SUB_REGION#'
,p_page_plug_template_name=>'APEX 5.1 - Tabs with Icons + Text'
,p_internal_name=>'APEX_5.1_TABS_WITH_ICONS_+_TEXT'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_processing_spinner_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3731195891703350618.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ProcessingRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <span class="u-Processing"><span class="u-Processing-spinner"></span></span>',
'  <div class="a-ProcessingRegion-title">#TITLE#</div>',
'  <div class="a-ProcessingRegion-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Processing Spinner Region'
,p_internal_name=>'APEX_5.0_PROCESSING_SPINNER_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_grouping_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#" role="group" aria-labelledby="#REGION_STATIC_ID#_label">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title" id="#REGION_STATIC_ID#_label">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Grouping Region'
,p_internal_name=>'APEX_5.0_GROUPING_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--paddedBody:a-Region--simple'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_tree_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(4077427275300064682.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" class="a-PageDesigner-treeRegion resize #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>',
'  <div class="a-Toolbar a-Toolbar-pageColumn a-Toolbar--treeRegion">',
'    <div class="a-Toolbar-items a-Toolbar-items--left">',
'      <h3 class="a-PageDesigner-treeTitle">#TITLE#</h3>',
'    </div>',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  <div class="a-PageDesigner-treeWrap u-ScrollingViewport resize">',
'    #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Tree Region'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_TREE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs_with_icons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(4630165380147676460.4024)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Tabs-toolbar a-Toolbar">',
'    #SUB_REGION_HEADERS#',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  #SUB_REGIONS#',
'</div>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#"><span title="#SUB_REGION_TITLE#" class="a-Icon #SUB_REGION_ICON_CSS_CLASSES#"></span><span class="u-VisuallyHidden">#SUB_REGION_TITLE#</span></a></li>'
,p_sub_plug_template=>'#SUB_REGION#'
,p_page_plug_template_name=>'APEX 5.0 - Tabs with Icons'
,p_internal_name=>'APEX_5.0_TABS_WITH_ICONS'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/done_standard_list_table_based
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2601300913516285374.4024)
,p_list_template_current=>'<tr><td class="htmldbStandardList1"><a href="#LINK#" class="itemLink" title="#TEXT_ESC_SC#">#TEXT#</a></td></tr>'
,p_list_template_noncurrent=>'<tr><td class="htmldbStandardList2"><a href="#LINK#" class="itemLink" title="#TEXT_ESC_SC#">#TEXT#</a></td></tr>'
,p_list_template_name=>'(Done) Standard List (Table Based)'
,p_internal_name=>'DONE_STANDARD_LIST_TABLE_BASED'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbStandardList" cellpadding="0" cellspacing="0" border="0" summary="">',
'<tbody>'))
,p_list_template_after_rows=>'</tbody></table>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/dhtml_list_button_with_sublist
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2602098713851789269.4024)
,p_list_template_current=>'<li>#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" class="dList" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_list_template_name=>'DHTML List Button with Sublist'
,p_internal_name=>'DHTML_LIST_BUTTON_WITH_SUBLIST'
,p_theme_id=>101
,p_theme_class_id=>10
,p_list_template_before_rows=>'<ul class="dList">'
,p_list_template_after_rows=>'</ul>'
,p_item_templ_curr_w_child=>'<li>#TEXT#</li>'
,p_item_templ_noncurr_w_child=>'<li><a href="#LINK#" class="dList" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/done_page_tab_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2602893399962651103.4024)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="current"><div class="tbl"><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></div><div class="tbr"><img src="#IMAGE_PREFIX#1px_trans.gif"></div></div>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="non-current"><div class="tbl"><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></div><div class="tbr"><img src="#IMAGE_PREFIX#1px_trans.gif"></div></div>',
''))
,p_list_template_name=>'(Done) Page Tab Navigation'
,p_internal_name=>'DONE_PAGE_TAB_NAVIGATION'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div id="tabs">'
,p_list_template_after_rows=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_large_icons_list_5_icons
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2604064395384974004.4024)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX#f_spacer.gif" #IMAGE_ATTR# class="gi-Icon-#IMAGE#" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX#f_spacer.gif" #IMAGE_ATTR# class="gi-Icon-#IMAGE#" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_name=>'[EBA] Large Icons List (5 icons)'
,p_internal_name=>'[EBA]_LARGE_ICONS_LIST_5_ICONS'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table class="ebaLargeIcons" width="100%" cellspacing="0" cellpadding="0" border="0" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_image_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2616337216247383620.4024)
,p_list_template_current=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_name=>'Simple Image List'
,p_internal_name=>'SIMPLE_IMAGE_LIST'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="listwithicon">'
,p_list_template_after_rows=>'</ul>'
,p_list_template_comment=>'<img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_wizard_progress_sidebar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2644133919427537952.4024)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-wiz-current"><span>#TEXT#</span></div>',
''))
,p_list_template_noncurrent=>'<div class="apex-wiz-non"><span>#TEXT#</span></div>'
,p_list_template_name=>'APEX 4. 0 - Wizard Progress Sidebar'
,p_internal_name=>'APEX_4._0_WIZARD_PROGRESS_SIDEBAR'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="apex-wiz-bar">'
,p_list_template_after_rows=>'</div>'
,p_between_items=>'<div class="apex-wiz-arrow"></div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2644135096780537975.4024)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>101
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/done_quick_items
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2667754110651746870.4024)
,p_list_template_current=>'<div><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_list_template_noncurrent=>'<div><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_list_template_name=>'(Done) Quick Items'
,p_internal_name=>'DONE_QUICK_ITEMS'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="htmldbQuickItems">'
,p_list_template_after_rows=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/done_simple_tabbed_navigation_list_ppr
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2692764710625953880.4024)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="javascript:ob_PPR_TAB(''#LINK#'')" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="javascript:ob_PPR_TAB(''#LINK#'')" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
'',
''))
,p_list_template_name=>'(Done) Simple Tabbed Navigation List (PPR)'
,p_internal_name=>'DONE_SIMPLE_TABBED_NAVIGATION_LIST_PPR'
,p_theme_id=>101
,p_theme_class_id=>7
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbTabbedNavigationList" border="0" cellpadding="0" cellspacing="0" summary=""><tr>',
'',
''))
,p_list_template_after_rows=>'<td width="100%"><br /></td></tr></table>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/done_simple_tabbed_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2692769817191963631.4024)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
'',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_list_template_name=>'(Done) Simple Tabbed Navigation List'
,p_internal_name=>'DONE_SIMPLE_TABBED_NAVIGATION_LIST'
,p_theme_id=>101
,p_theme_class_id=>7
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbTabbedNavigationList" border="0" cellpadding="0" cellspacing="0"><tr>',
'',
''))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td width="100%"><br /></td></tr></table>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
'',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sub_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2752624110726590597.4024)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Sub Tabs'
,p_internal_name=>'APEX_5.0_SUB_TABS'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/tree_context_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2789926011585822220.4024)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_ATTR#:{',
'  is_separator:true,',
'  visible:#A01#',
'}',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_ATTR#:{',
'  label:"#TEXT#", ',
'  icon: "#IMAGE#",',
'  visible:#A01#,',
'  action: #LINK#',
'}',
''))
,p_list_template_name=>'Tree Context Menu'
,p_internal_name=>'TREE_CONTEXT_MENU'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'{items:{create:false,rename:false,remove:false,'
,p_list_template_after_rows=>'}}'
,p_between_items=>','
);
end;
/
prompt --application/shared_components/user_interface/templates/list/image_list_legend
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2821773603397513050.4024)
,p_list_template_current=>'<li><img src="#IMAGE_PREFIX##IMAGE#" style="margin-right:10px;" alt="" />#TEXT#</li>'
,p_list_template_noncurrent=>'<li><img src="#IMAGE_PREFIX##IMAGE#" style="margin-right:10px;" alt="" />#TEXT#</li>'
,p_list_template_name=>'Image List (Legend)'
,p_internal_name=>'IMAGE_LIST_LEGEND'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="htmldbSessionLegend">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_wizard_progress_sidebar_clickable
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2824062405654685023.4024)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-wiz-current">',
'  <div class="apex-wiz-top"></div>',
'  <div class="apex-wiz-body">#TEXT#</div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-wiz-non">',
'  <div class="apex-wiz-top"></div>',
'  <div class="apex-wiz-body"><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'APEX 4. 0 - Wizard Progress Sidebar (Clickable)'
,p_internal_name=>'APEX_4._0_WIZARD_PROGRESS_SIDEBAR_CLICKABLE'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="apex-wiz-bar">'
,p_list_template_after_rows=>'</div>'
,p_between_items=>'<div class="apex-wiz-arrow-small"></div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/horizontal_list_with_images_30px_c_htmldblistimages30px
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2922135290041147207.4024)
,p_list_template_current=>'<td align="center" valign="top"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon" /></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_noncurrent=>'<td align="center" valign="top"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon"/></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_name=>'Horizontal List with Images 30px (c:htmldbListImages30px)'
,p_internal_name=>'HORIZONTAL_LIST_WITH_IMAGES_30PX_C:HTMLDBLISTIMAGES30PX'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="htmldbListImages30px" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/done_unordered_list_omit_current
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2937959307089632175.4024)
,p_list_template_current=>' '
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_list_template_name=>'(Done) Unordered List  (Omit Current)'
,p_internal_name=>'DONE_UNORDERED_LIST_OMIT_CURRENT'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="noIndent">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3065206012515940400.4024)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3157523106769548315.4024)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>101
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3271817654182082202.4024)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>101
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>101
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3331503598779942021.4024)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>101
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3509379333604010550.4024)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_name=>'APEX 5.0 - Menu Bar'
,p_internal_name=>'APEX_5.0_MENU_BAR'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menubar", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup( e );',
'}',
'e.menu({',
'  behaveLikeTabs: e.hasClass("js-tablike"),',
'  menubarShowSubMenuIcon: e.hasClass("js-showSubMenuIcon") || null,',
'  slide: e.hasClass("js-slide"),',
'  menubar: true,',
'});',
''))
,p_theme_id=>101
,p_theme_class_id=>7
,p_default_template_options=>'js-tabLike'
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menubar" class="#COMPONENT_CSS_CLASSES#"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_websheets_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3510331064015224024.4024)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Websheets Menu'
,p_internal_name=>'APEX_5.0_WEBSHEETS_MENU'
,p_theme_id=>101
,p_theme_class_id=>7
,p_list_template_before_rows=>' '
,p_list_template_after_rows=>' '
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_app_cards
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3516165623956683100.4024)
,p_list_template_name=>'APEX 5.0 - App Cards'
,p_internal_name=>'APEX_5.0_APP_CARDS'
,p_theme_id=>101
,p_theme_class_id=>9
,p_list_template_before_rows=>' '
,p_list_template_after_rows=>' '
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_basic_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3725901971624487519.4024)
,p_list_template_current=>'<li class="a-List-item is-current"><a href="#LINK#" class="a-Links-link" #A02#>#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-List-item"><a href="#LINK#" class="a-Links-link" #A02#>#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Basic List'
,p_internal_name=>'APEX_5.0_BASIC_LIST'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="a-List #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_basic_list_no_links
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3725904394519503812.4024)
,p_list_template_current=>'<li class="a-List-item is-current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li class="a-List-item">#TEXT#</li>'
,p_list_template_name=>'APEX 5.0 - Basic List (no links)'
,p_internal_name=>'APEX_5.0_BASIC_LIST_NO_LINKS'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="a-List a-List--basic #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sql_workshop_buttons_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(3825565596067563070.4024)
,p_list_template_current=>'<button type="button" onclick="apex.navigation.redirect(''#LINK#'')" class="a-Button">#TEXT#</button>'
,p_list_template_noncurrent=>'<button type="button" onclick="apex.navigation.redirect(''#LINK#'')" class="a-Button">#TEXT#</button>'
,p_list_template_name=>'APEX 5.0 - SQL Workshop Buttons List'
,p_internal_name=>'APEX_5.0_SQL_WORKSHOP_BUTTONS_LIST'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-Button-list">'
,p_list_template_after_rows=>'</div>'
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/report/pages
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2583678044278335201.4024)
,p_row_template_name=>'Pages'
,p_internal_name=>'PAGES'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-PWList-item #PAGE_LI_CLASS# #PAGE_DRAGGABLE#" data-seq="#SORT_ORDER#">',
'  <span class="a-PWList-icon">#PAGE_ICON#</span>',
'  <span class="a-PWList-name">#PAGE_TITLE#</span>',
'  <span class="a-PWList-desc">#PAGE_DESC#</span>',
'  <span class="a-PWList-actions">#PAGE_ACTIONS#</span>',
'  #PAGE_DRAG_HANDLE#',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-PWList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2601299300702281738.4024)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(2601299300702281738.4024)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2604243400441774005.4024)
,p_row_template_name=>'[EBA] Standard Report'
,p_internal_name=>'[EBA]_STANDARD_REPORT'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#',
'<tr>',
'<td><table class="ebaStandardReport" cellspacing="0" cellpadding="0" summary="#REGION_TITLE#" width="100%">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table><div class="CSV">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="#LINK#" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="#LINK#" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="#LINK#" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="#LINK#" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>101
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(2604243400441774005.4024)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2626935888845593317.4024)
,p_row_template_name=>'APEX 5.0 - Portlet Column Template'
,p_internal_name=>'APEX_5.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>0
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2630679288769520822.4024)
,p_row_template_name=>'APEX 5.0 - Portlet Row Template'
,p_internal_name=>'APEX_5.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/vertical_standard_c_htmldbverticalregion2
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2665894019428237001.4024)
,p_row_template_name=>'Vertical Standard (c:htmldbVerticalRegion2)'
,p_internal_name=>'VERTICAL_STANDARD_C:HTMLDBVERTICALREGION2'
,p_row_template1=>'<tr><td scope="row" class="label">#COLUMN_HEADER#</td><td class="data">#COLUMN_VALUE#</td></tr>'
,p_row_template_before_rows=>'#CSV_LINK#<table class="htmldbVerticalRegion2"  summary="#REGION_TITLE#" cellpadding="0" cellspacing="0" border="0">'
,p_row_template_after_rows=>'</table>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>101
,p_theme_class_id=>0
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(2665894019428237001.4024)
,p_row_template_before_first=>' '
,p_row_template_after_last=>'<tr><td class="blank"><br /></td><td class="blank"><br /></td></tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2707641403506668051.4024)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>101
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(2707641403506668051.4024)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/icon_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2718432304985775346.4024)
,p_row_template_name=>'Icon Report'
,p_internal_name=>'ICON_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100" style="float:left;margin:10px;">',
'<tr><td align="center"><a href="#3#"><img src="#IMAGE_PREFIX##1#" title="#2#" alt="#2#" style="display:block;"/></a></td></tr>',
'<tr><td align="center"><a href="#3#" class="htmldbIconName">#4#</a></td></tr>',
'</table>',
'<br style="clear:both;" />'))
,p_row_template_condition1=>'mod (#ROWNUM#, 5) = 0'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100" style="float:left;margin:10px;">',
'<tr><td align="center"><a href="#3#"><img src="#IMAGE_PREFIX##1#" title="#2#" alt="#2#" style="display:block;"/></a></td></tr>',
'<tr><td align="center"><a href="#3#" class="htmldbIconName">#4#</a></td></tr>',
'</table>'))
,p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table class="htmldbListIconHolder" border="0" cellpadding="0" cellpadding="0" summary="">#TOP_PAGINATION#<tr><td>'
,p_row_template_after_rows=>'</td></tr>#PAGINATION#</table></htmldb:#REGION_ID#></div>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_theme_id=>101
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/vertical_no_background
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2756563315870700241.4024)
,p_row_template_name=>'Vertical - No Background'
,p_internal_name=>'VERTICAL_NO_BACKGROUND'
,p_row_template1=>'<tr><th scope="row" align="right">#COLUMN_HEADER#</th><td>#COLUMN_VALUE#</td></tr>'
,p_row_template_before_rows=>'#CSV_LINK#<table class="htmldbVerticalRptPlain" summary="#REGION_TITLE#" cellpadding="0" cellspacing="0" border="0">'
,p_row_template_after_rows=>'</table>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>101
,p_theme_class_id=>0
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(2756563315870700241.4024)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/no_background
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2821784192166554137.4024)
,p_row_template_name=>'No Background'
,p_internal_name=>'NO_BACKGROUND'
,p_row_template1=>'<td#ALIGNMENT# id="td#ROWNUM#_#COLNUM#" headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" class="htmldbRptNoBackground" summary="#REGION_TITLE#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(2821784192166554137.4024)
,p_row_template_before_first=>'<tr id="row#ROWNUM#">'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/4500_database_browser_trigger_body
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2938873490424743044.4024)
,p_row_template_name=>'(4500) Database Browser Trigger Body'
,p_internal_name=>'4500_DATABASE_BROWSER_TRIGGER_BODY'
,p_row_template1=>'<pre>#TRIGGER_BODY#</pre>'
,p_row_template_before_rows=>'<table><tr><td>'
,p_row_template_after_rows=>'</td></tr></table>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_named_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_row_template_name=>'APEX 5.0 - Badge List (Named Column)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_NAMED_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(3272975836994283240.4024)
,p_row_template_name=>'APEX 5.0 - Badge List (Row)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
'  <span class="t-BadgeList-label">#1#</span>',
'  <span class="t-BadgeList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>6
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_app_cards_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(3516183932083974422.4024)
,p_row_template_name=>'APEX 5.0 - App Cards Report'
,p_internal_name=>'APEX_5.0_APP_CARDS_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AppCards-item #ID#">',
'  <div class="a-AppCards-itemContainer">',
'    <div class="a-AppCards-iconContainer">',
'      <span class="a-AppCards-icon #ICON_CLASS#"></span>',
'    </div>',
'    <div class="a-AppCards-contentContainer" id="#ID#_name">',
'      <h2 class="a-AppCards-name">#APP_NAME#</h2>',
'      <div class="a-AppCards-info">#APP_INFO#</div>',
'    </div>',
'    <div class="a-AppCards-actionsContainer">',
'        #MODIFY_APP_BUTTON#',
'        #RUN_APP_BUTTON#',
'    </div>',
'  </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AppCards a-AppCards--slim  a-AppCards--stacked">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_vertical_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(3710840215749602833.4024)
,p_row_template_name=>'APEX 5.0 - Vertical Report'
,p_internal_name=>'APEX_5.0_VERTICAL_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr>',
'  <td class="a-Report-cell a-Report-cell--header" scope="row">#COLUMN_HEADER#</td>',
'  <td class="a-Report-cell">#COLUMN_VALUE#</td>',
'</tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report a-Report--vertical a-Report--staticRowColors #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" summary="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>101
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(3710840215749602833.4024)
,p_row_template_before_first=>' '
,p_row_template_after_last=>' '
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/outline_label_optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(2584586946052082315.4024)
,p_template_name=>'Outline Label - Optional'
,p_internal_name=>'OUTLINE_LABEL_OPTIONAL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="field-label__container field-col-3">',
'<label class="field-label" id="#CURRENT_ITEM_ID#_LABEL" for="#CURRENT_ITEM_NAME#">',
'<label for="#CURRENT_ITEM_NAME#" tabindex="999">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="field field--style--boxed #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="field-input__container field-col-9">',
'<div class="field-input__wrap">'))
,p_after_element=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</div>',
'</div>',
'#ERROR_TEMPLATE#',
'#HELP_TEMPLATE#',
'#INLINE_HELP_TEMPLATE#'))
,p_inline_help_text=>'<span class="inline-help">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<div class="field-error-message">#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(2588818597804368344.4024)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>101
,p_theme_class_id=>13
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/outline_label_required
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(2716804030064502999.4024)
,p_template_name=>'Outline Label - Required'
,p_internal_name=>'OUTLINE_LABEL_-_REQUIRED'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="field-label__container field-col-3">',
'<label class="field-label" id="#CURRENT_ITEM_ID#_LABEL" for="#CURRENT_ITEM_NAME#">',
'<label for="#CURRENT_ITEM_NAME#" tabindex="999">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="field field--style--boxed field--required #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="field-input__container field-col-9">',
'<div class="field-input__wrap">'))
,p_after_element=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</div>',
'</div>',
'#ERROR_TEMPLATE#',
'#HELP_TEMPLATE#',
'#INLINE_HELP_TEMPLATE#'))
,p_inline_help_text=>'<span class="inline-help">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<div class="field-error-message">#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/dynamic_attribute
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(2764373305086284113.4024)
,p_template_name=>'Dynamic Attribute'
,p_internal_name=>'DYNAMIC_ATTRIBUTE'
,p_template_body1=>'<em>*</em><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aRequired"><a href="javascript:apex.builder.dynamicAttributes.help(''&FB_FLOW_ID.'',''#CURRENT_ITEM_NAME#'');" tabindex="999">'
,p_template_body2=>' <span class="hideMeButHearMe">(#VALUE_REQUIRED#)</span></a></label>'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional_with_br
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(2771230409799238960.4024)
,p_template_name=>'FormField_Optional with BR'
,p_internal_name=>'FORMFIELD_OPTIONAL_WITH_BR'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="help optional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label><br />&nbsp;'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_required_with_br
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(2771230604641238960.4024)
,p_template_name=>'FormField_Required with BR'
,p_internal_name=>'FORMFIELD_REQUIRED_WITH_BR'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="help required" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999"><img alt="#VALUE_REQUIRED#" src="#IMAGE_PREFIX#requiredicon_status2.gif" />'
,p_template_body2=>'</a></label><br />&nbsp;'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(3071359248210082306.4024)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(3071359888141100707.4024)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(3076592553081438826.4024)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(3076592627306440115.4024)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(3271822809773116508.4024)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_dynamic_attribute
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(3276597163598826691.4024)
,p_template_name=>'APEX 5.0 - Dynamic Attribute'
,p_internal_name=>'APEX_5.0_DYNAMIC_ATTRIBUTE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-dynamicItemHelp" data-itemname="#CURRENT_ITEM_NAME#" data-appid="&FB_FLOW_ID." title="" aria-label="" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span>'
||'</button>#ERROR_TEMPLATE#</div>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_workspace_login_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(3365552608730662744.4024)
,p_template_name=>'APEX 5.0 - Workspace Login Label'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Icon a-Login-iconLabel">'
,p_template_body2=>'</label>'
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#"><div class="a-Form-inputContainer">'
,p_after_item=>'</div></div>'
,p_after_element=>'<span class="a-Login-iconValidation a-Icon icon-check"></span>#ERROR_TEMPLATE#'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help"></span><span class="u-VisuallyHidden">#CURRENT_ITE'
||'M_HELP_LABEL#</span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader_with_span
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(3835008919990537112.4024)
,p_template_name=>'Hidden label, read by screen reader with SPAN'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER_WITH_SPAN'
,p_template_body1=>'<span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label></span>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>101
,p_theme_class_id=>13
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(3273201397272801603.4024)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(2601258703618978764.4024)
,p_page_name=>'winlov'
,p_page_title=>'Finestra di dialogo di ricerca'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>'Cerca'
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>'Chiudi'
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>'Successivo &gt;'
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>'&lt; Precedente'
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>'<div class="a-PopupLOV-pagination">Righe #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/default_calander
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(2937825491492752143.4024)
,p_cal_template_name=>'Default Calander'
,p_internal_name=>'DEFAULT_CALANDER'
,p_day_of_week_format=>'<th scope="col" width="14%">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table> ',
' <tr>',
'   <td> ',
'     <table width="100%" class="htmldbGrayBox" cellspacing="0" cellpadding="0" border="0" summary="layout">',
'       <tr><td align="center" class="htmldbGrayBoxHeader">#IMONTH#</td></td></tr>',
'     </table>',
'   </td>',
' </tr>'))
,p_month_open_format=>'<table summary="#CALENDAR_TITLE# #IMONTH# #YYYY#"  border="0" cellpadding="0" cellspacing="0" class="htmldbRowWithBorders" width="100%"><tr>'
,p_month_close_format=>'</tr></table></table>'
,p_day_title_format=>'<div class="calday">#DD#</div>'
,p_day_open_format=>'<td valign="top" class="calweekday">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="caltoday" style="background:#c5d5c5">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="calday">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="calweekend">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'&nbsp;'
,p_nonday_open_format=>'<td class="calnotmonth">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</td></tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>.4024
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/htmldb_calendar_from_4350
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(2937840903200925859.4024)
,p_cal_template_name=>'HTMLDB Calendar from 4350'
,p_internal_name=>'HTMLDB_CALENDAR_FROM_4350'
,p_day_of_week_format=>'<th scope="col" width="14%" class="htmldbDayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbCalendarHolder" cellpadding="0" cellspacing="0" border="0" width="100%" summary="" role="presentation"><tr>',
'<td class="htmldbMonthTitle">#IMONTH# #YYYY#</td>',
'</tr>',
'<tr><td>'))
,p_month_open_format=>'<table class="htmldbCalendar" cellpadding="0" cellspacing="3" border="0" width="100%" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td></tr></table>',
'',
''))
,p_day_title_format=>'<div class="htmldbDayTitle">#DD#</div>'
,p_day_open_format=>'<td class="htmldbDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="htmldbToday">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="htmldbWeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td class="htmldbWeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="htmldbNonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="htmldbNonDay">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>.4024
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/subscribe_of_htmldb_calendar_from_4350
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(2938985015947681963.4024)
,p_cal_template_name=>'subscribe of HTMLDB Calendar from 4350'
,p_internal_name=>'SUBSCRIBE_OF_HTMLDB_CALENDAR_FROM_4350'
,p_day_of_week_format=>'<th scope="col" width="14%" class="htmldbDayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbCalendarHolder" cellpadding="0" cellspacing="0" border="0" width="100%" summary="" role="presentation"><tr>',
'<td class="htmldbMonthTitle">#IMONTH# #YYYY#</td>',
'</tr>',
'<tr><td>'))
,p_month_open_format=>'<table class="htmldbCalendar" cellpadding="0" cellspacing="3" border="0" width="100%" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td></tr></table>',
'',
''))
,p_day_title_format=>'<div class="htmldbDayTitle">#DD#</div>'
,p_day_open_format=>'<td class="htmldbDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="htmldbToday">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="htmldbWeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td class="htmldbWeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="htmldbNonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="htmldbNonDay">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>.4024
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(72329795312505899.4024)
,p_theme_id=>101
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(2787940904864180601.4024)
,p_theme_id=>101
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272947108403853347.4024)
,p_theme_id=>101
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272948091579864086.4024)
,p_theme_id=>101
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272952033767924344.4024)
,p_theme_id=>101
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272954073059959815.4024)
,p_theme_id=>101
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272956807976997233.4024)
,p_theme_id=>101
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272957635263003437.4024)
,p_theme_id=>101
,p_name=>'MIN_HEIGHT'
,p_display_name=>'Min Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'No Min Height'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272957927201004807.4024)
,p_theme_id=>101
,p_name=>'MAX_HEIGHT'
,p_display_name=>'Max Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'No Max Height'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272966786960085403.4024)
,p_theme_id=>101
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272966998825101372.4024)
,p_theme_id=>101
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272967382281109834.4024)
,p_theme_id=>101
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272969904335143676.4024)
,p_theme_id=>101
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272971965975243949.4024)
,p_theme_id=>101
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3272972266905244890.4024)
,p_theme_id=>101
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3273503711535111804.4024)
,p_theme_id=>101
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3273504100166113788.4024)
,p_theme_id=>101
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3273504670519116433.4024)
,p_theme_id=>101
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3273504927909124382.4024)
,p_theme_id=>101
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3273505268873125534.4024)
,p_theme_id=>101
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3273505950760134683.4024)
,p_theme_id=>101
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3273878259726558568.4024)
,p_theme_id=>101
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3276635722597176199.4024)
,p_theme_id=>101
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3280531346127474880.4024)
,p_theme_id=>101
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3281138953904089269.4024)
,p_theme_id=>101
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3286594514783296583.4024)
,p_theme_id=>101
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3286594887959299057.4024)
,p_theme_id=>101
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3286595166349303494.4024)
,p_theme_id=>101
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3286597037907377132.4024)
,p_theme_id=>101
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3286597541894380105.4024)
,p_theme_id=>101
,p_name=>'TEXT_ALIGNMENT'
,p_display_name=>'Text Alignment'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3330283282906664432.4024)
,p_theme_id=>101
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3554578106749597184.4024)
,p_theme_id=>101
,p_name=>'FORM_ITEM_ALIGNMENT'
,p_display_name=>'Form Item Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'This option controls how form items are aligned.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(3725370028670731644.4024)
,p_theme_id=>101
,p_name=>'DIALOG_SIZE'
,p_display_name=>'Dialog Size'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Predefined dialog sizes'
,p_null_text=>'Default Size'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3262270231652718591.4024)
,p_theme_id=>101
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(3262269949210718587.4024)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3262270571570718591.4024)
,p_theme_id=>101
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3262269949210718587.4024)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272945950492849549.4024)
,p_theme_id=>101
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3271069058970016268.4024)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272947553810857499.4024)
,p_theme_id=>101
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3271069058970016268.4024)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(3272947108403853347)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272947826253860428.4024)
,p_theme_id=>101
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3271069058970016268.4024)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(3272947108403853347)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272948903374868569.4024)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3271069058970016268.4024)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272949699167870094.4024)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3271069058970016268.4024)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272950049203873528.4024)
,p_theme_id=>101
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3271069058970016268.4024)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272951079760914115.4024)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272951692319920329.4024)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272952701469928429.4024)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(3272952033767924344)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272952954669936274.4024)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(3272947108403853347)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272954255910963039.4024)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272954430217969881.4024)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272961138986029754.4024)
,p_theme_id=>101
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_api.id(3272956807976997233)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272961370887030558.4024)
,p_theme_id=>101
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_api.id(3272956807976997233)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272961542151031342.4024)
,p_theme_id=>101
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_api.id(3272956807976997233)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272962358006037974.4024)
,p_theme_id=>101
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_api.id(3272956807976997233)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272962503845038900.4024)
,p_theme_id=>101
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_api.id(3272956807976997233)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272962747536039753.4024)
,p_theme_id=>101
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_api.id(3272956807976997233)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272967834831123581.4024)
,p_theme_id=>101
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2707641403506668051.4024)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(3272966998825101372)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272968057448126165.4024)
,p_theme_id=>101
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2707641403506668051.4024)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(3272967382281109834)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272968191501129345.4024)
,p_theme_id=>101
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2707641403506668051.4024)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(3272966786960085403)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272968445819130771.4024)
,p_theme_id=>101
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2707641403506668051.4024)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(3272966786960085403)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272968608246132125.4024)
,p_theme_id=>101
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2707641403506668051.4024)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(3272966786960085403)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272968919298136815.4024)
,p_theme_id=>101
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2707641403506668051.4024)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272970278790147380.4024)
,p_theme_id=>101
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2707641403506668051.4024)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(3272969904335143676)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272972869034260434.4024)
,p_theme_id=>101
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(3272971965975243949)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272973086671262192.4024)
,p_theme_id=>101
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(3272971965975243949)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272973253261263303.4024)
,p_theme_id=>101
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(3272971965975243949)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272973474743265141.4024)
,p_theme_id=>101
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(3272971965975243949)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272973618033266123.4024)
,p_theme_id=>101
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(3272971965975243949)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272973800081267332.4024)
,p_theme_id=>101
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_api.id(3272971965975243949)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272974009431268450.4024)
,p_theme_id=>101
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(3272971965975243949)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272974260327270307.4024)
,p_theme_id=>101
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(3272971965975243949)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272974443197272653.4024)
,p_theme_id=>101
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_api.id(3272972266905244890)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272974653554274369.4024)
,p_theme_id=>101
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(3272972266905244890)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272974882723275389.4024)
,p_theme_id=>101
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_api.id(3272972266905244890)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272975023683276305.4024)
,p_theme_id=>101
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(3272972266905244890)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3272975227337277311.4024)
,p_theme_id=>101
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3072403539858088941.4024)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(3272972266905244890)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273718461755706170.4024)
,p_theme_id=>101
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_api.id(3273503711535111804)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273718623962707342.4024)
,p_theme_id=>101
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_api.id(3273503711535111804)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273718890233708711.4024)
,p_theme_id=>101
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(3273503711535111804)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273719305891709940.4024)
,p_theme_id=>101
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_api.id(3273504100166113788)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273719586640711433.4024)
,p_theme_id=>101
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_api.id(3273504100166113788)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273719839810712886.4024)
,p_theme_id=>101
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_api.id(3273504670519116433)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273720340946719858.4024)
,p_theme_id=>101
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_api.id(3273504927909124382)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273720525579721240.4024)
,p_theme_id=>101
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(3273504927909124382)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273720760921722468.4024)
,p_theme_id=>101
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_api.id(3273505268873125534)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273720931877723703.4024)
,p_theme_id=>101
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_api.id(3273505268873125534)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273721140780728323.4024)
,p_theme_id=>101
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273871817323525718.4024)
,p_theme_id=>101
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273872411843525718.4024)
,p_theme_id=>101
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273872723948525718.4024)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273873057755525719.4024)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273873290844525719.4024)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(3272952033767924344)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273873638536525720.4024)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(3272947108403853347)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273875126148525721.4024)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273875409775525721.4024)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273878789688562715.4024)
,p_theme_id=>101
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(3273878259726558568)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3273879016540564402.4024)
,p_theme_id=>101
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3273871575473525717.4024)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(3273878259726558568)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3276607386083938689.4024)
,p_theme_id=>101
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3271817654182082202.4024)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3276636838044198487.4024)
,p_theme_id=>101
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(3276635722597176199)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3276637064796202531.4024)
,p_theme_id=>101
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(3276635722597176199)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3276637209671203375.4024)
,p_theme_id=>101
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(3276635722597176199)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3276637476000204461.4024)
,p_theme_id=>101
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(3276635722597176199)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3276637736156208731.4024)
,p_theme_id=>101
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(3276635722597176199)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3276637961098212818.4024)
,p_theme_id=>101
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3276638122293218782.4024)
,p_theme_id=>101
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3276638304849219441.4024)
,p_theme_id=>101
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3276638548238221517.4024)
,p_theme_id=>101
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3277479810838089753.4024)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3280532169788485511.4024)
,p_theme_id=>101
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3271069058970016268.4024)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3280694720327105304.4024)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3271069058970016268.4024)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3280963863176791327.4024)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3280964065307793861.4024)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3281117036334023852.4024)
,p_theme_id=>101
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3276636485845180952.4024)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3281139167748092929.4024)
,p_theme_id=>101
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(2644135096780537975.4024)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3281139506990094782.4024)
,p_theme_id=>101
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(2644135096780537975.4024)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3281140071999096157.4024)
,p_theme_id=>101
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(2644135096780537975.4024)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3281141078804098444.4024)
,p_theme_id=>101
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(2644135096780537975.4024)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3281141213641100590.4024)
,p_theme_id=>101
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(2644135096780537975.4024)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(3281138953904089269)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3281141448555102030.4024)
,p_theme_id=>101
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(2644135096780537975.4024)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(3281138953904089269)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3281266536726867367.4024)
,p_theme_id=>101
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2601299300702281738.4024)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3281266773648869208.4024)
,p_theme_id=>101
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2601299300702281738.4024)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3281266966728871945.4024)
,p_theme_id=>101
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(2601299300702281738.4024)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282714713448775707.4024)
,p_theme_id=>101
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282745129348275835.4024)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282746679230275837.4024)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282746942441275837.4024)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(3272947108403853347)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282747278902275837.4024)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282747839142275838.4024)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282748118484275838.4024)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282748411243275838.4024)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282749059124275838.4024)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(3272952033767924344)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282749318955275838.4024)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3282842053625616201.4024)
,p_theme_id=>101
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3286595597781327418.4024)
,p_theme_id=>101
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(3286594514783296583)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3286595827879334751.4024)
,p_theme_id=>101
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(3286595166349303494)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3286596084244340067.4024)
,p_theme_id=>101
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_api.id(3286594887959299057)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3286596280219344757.4024)
,p_theme_id=>101
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_api.id(3286594887959299057)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3286596436853346451.4024)
,p_theme_id=>101
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_api.id(3286594887959299057)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3286596758659356442.4024)
,p_theme_id=>101
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_api.id(3286594887959299057)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3286598178674389540.4024)
,p_theme_id=>101
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_api.id(3286597037907377132)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3321665041873928813.4024)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3321664782165928798.4024)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3321665488779928817.4024)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3321664782165928798.4024)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3321665693602928818.4024)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(3321664782165928798.4024)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3321665940405928818.4024)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3321664782165928798.4024)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3321666009451928818.4024)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(3321664782165928798.4024)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3321666098572928818.4024)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3321664782165928798.4024)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3321666463761928818.4024)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(3321664782165928798.4024)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3324985134819362058.4024)
,p_theme_id=>101
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3262269949210718587.4024)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3330280566372621950.4024)
,p_theme_id=>101
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3330277939666606656.4024)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3330280598646623793.4024)
,p_theme_id=>101
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3330277939666606656.4024)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3330280783108625349.4024)
,p_theme_id=>101
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3330277939666606656.4024)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3330284462355675023.4024)
,p_theme_id=>101
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3330277939666606656.4024)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_api.id(3330283282906664432)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3330284727365676939.4024)
,p_theme_id=>101
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3330277939666606656.4024)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_api.id(3330283282906664432)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3330285032641678042.4024)
,p_theme_id=>101
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3330277939666606656.4024)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_api.id(3330283282906664432)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3330285174248679384.4024)
,p_theme_id=>101
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3330277939666606656.4024)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_api.id(3330283282906664432)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3330286246965689845.4024)
,p_theme_id=>101
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3330277939666606656.4024)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(3273878259726558568)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3330286358960690808.4024)
,p_theme_id=>101
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3330277939666606656.4024)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_api.id(3273878259726558568)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331512237109010498.4024)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331512316830010502.4024)
,p_theme_id=>101
,p_name=>'ADDBOTTOMBORDER'
,p_display_name=>'Add Bottom Border'
,p_display_sequence=>13
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--bottomBorder'
,p_template_types=>'REGION'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331512405035010502.4024)
,p_theme_id=>101
,p_name=>'ADDLEFTBORDER'
,p_display_name=>'Add Left Border'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--borderLeft'
,p_template_types=>'REGION'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331512520332010502.4024)
,p_theme_id=>101
,p_name=>'ADDRIGHTBORDER'
,p_display_name=>'Add Right Border'
,p_display_sequence=>11
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--rightBorder'
,p_template_types=>'REGION'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331512588720010502.4024)
,p_theme_id=>101
,p_name=>'ADDTOPBORDER'
,p_display_name=>'Add Top Border'
,p_display_sequence=>12
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--borderTop'
,p_template_types=>'REGION'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331512751548010502.4024)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331512886222010502.4024)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(3272947108403853347)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331512929493010502.4024)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331513066778010502.4024)
,p_theme_id=>101
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331513163911010502.4024)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331513197967010502.4024)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331513365716010502.4024)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3331513444572010502.4024)
,p_theme_id=>101
,p_name=>'SHOWTOPBUTTON'
,p_display_name=>'Show Top Button'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3331511935591010485.4024)
,p_css_classes=>'a-Region--showTopButton'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3334695364652936397.4024)
,p_theme_id=>101
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3335163087575149954.4024)
,p_theme_id=>101
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3282744828018275829.4024)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3342634157267201409.4024)
,p_theme_id=>101
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(2988804730938183125.4024)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(3273505950760134683)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3509387538140015679.4024)
,p_theme_id=>101
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3509379333604010550.4024)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3509387639047016742.4024)
,p_theme_id=>101
,p_name=>'BEHAVE_LIKE_TABS'
,p_display_name=>'Behave Like Tabs'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3509379333604010550.4024)
,p_css_classes=>'js-tabLike'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3509387743072017994.4024)
,p_theme_id=>101
,p_name=>'SHOW_SUB_MENU_ICON'
,p_display_name=>'Show Sub Menu Icon'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3509379333604010550.4024)
,p_css_classes=>'js-showSubMenuIcon'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3509387792807019253.4024)
,p_theme_id=>101
,p_name=>'ENABLE_SLIDE_ANIMATION'
,p_display_name=>'Enable Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3509379333604010550.4024)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3509438556564410728.4024)
,p_theme_id=>101
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3331503598779942021.4024)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3509438684549411763.4024)
,p_theme_id=>101
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(3331503598779942021.4024)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3554588139973710662.4024)
,p_theme_id=>101
,p_name=>'FLOAT_ITEMS_LEFT'
,p_display_name=>'Float Items Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--floatFieldsLeft'
,p_group_id=>wwv_flow_api.id(3554578106749597184)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to float fields within a region to the left. The width of the field container will be calculated automatically. This option will allow you to position a button or other items immediately after other items.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3554588421152717051.4024)
,p_theme_id=>101
,p_name=>'FLOAT_COLUMNS_LEFT'
,p_display_name=>'Float Columns Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--floatColsLeft'
,p_group_id=>wwv_flow_api.id(3554578106749597184)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to align grid columns within the region to the left. This option will allow you to align multiple columns of items next to each other.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3557616757869674565.4024)
,p_theme_id=>101
,p_name=>'INLINE_FIELD'
,p_display_name=>'Inline Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--floatLeft'
,p_template_types=>'FIELD'
,p_help_text=>'Makes the field container for this item appear inline, so buttons or other objects immediately after show up on same line.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3650400464957171179.4024)
,p_theme_id=>101
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(2758664310411868479.4024)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(3272947108403853347)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3710840678302602842.4024)
,p_theme_id=>101
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3710840215749602833.4024)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(3272967382281109834)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3710840717632602842.4024)
,p_theme_id=>101
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3710840215749602833.4024)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(3272966786960085403)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3710840865939602843.4024)
,p_theme_id=>101
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3710840215749602833.4024)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3710840901494602844.4024)
,p_theme_id=>101
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3710840215749602833.4024)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(3272966786960085403)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3710841004886602845.4024)
,p_theme_id=>101
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3710840215749602833.4024)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(3272969904335143676)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3710841122695602846.4024)
,p_theme_id=>101
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(3710840215749602833.4024)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(3272966786960085403)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3721723635433266832.4024)
,p_theme_id=>101
,p_name=>'RESIZABLE'
,p_display_name=>'Resizable'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(3012513290302116971.4024)
,p_css_classes=>'js-resizable'
,p_template_types=>'REGION'
,p_help_text=>'Allow dialog to be resized.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3721729533748272817.4024)
,p_theme_id=>101
,p_name=>'DRAGGABLE'
,p_display_name=>'Draggable'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3012513290302116971.4024)
,p_css_classes=>'js-draggable'
,p_template_types=>'REGION'
,p_help_text=>'Allow dialog to be moved.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3725370863738746403.4024)
,p_theme_id=>101
,p_name=>'SMALL_480X320'
,p_display_name=>'Small (480x320)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3012513290302116971.4024)
,p_css_classes=>'js-dialog-size480x320'
,p_group_id=>wwv_flow_api.id(3725370028670731644)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3725371274535749580.4024)
,p_theme_id=>101
,p_name=>'LARGE_720X480'
,p_display_name=>'Large (720x480)'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_api.id(3012513290302116971.4024)
,p_css_classes=>'js-dialog-size720x480'
,p_group_id=>wwv_flow_api.id(3725370028670731644)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3725374150645793950.4024)
,p_theme_id=>101
,p_name=>'MODAL'
,p_display_name=>'Modal'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_api.id(3012513290302116971.4024)
,p_css_classes=>'js-modal'
,p_template_types=>'REGION'
,p_help_text=>'Display as modal.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3726150615094251075.4024)
,p_theme_id=>101
,p_name=>'MEDIUM_600X400'
,p_display_name=>'Medium (600x400)'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(3012513290302116971.4024)
,p_css_classes=>'js-dialog-size600x400'
,p_group_id=>wwv_flow_api.id(3725370028670731644)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741610224559929677.4024)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741610384701929678.4024)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741610396048929678.4024)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(3272947108403853347)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741610528314929678.4024)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741610624572929678.4024)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(3280531346127474880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741610694805929678.4024)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741610807878929679.4024)
,p_theme_id=>101
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741610894122929679.4024)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(3272954073059959815)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741611021915929679.4024)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(3272952033767924344)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741611178660929679.4024)
,p_theme_id=>101
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(3272947108403853347)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3741611246435929679.4024)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(3741609957292929669.4024)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(3272948091579864086)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(3825581410111791772.4024)
,p_theme_id=>101
,p_name=>'USED_IN_DIALOG'
,p_display_name=>'Used in Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(3731195891703350618.4024)
,p_css_classes=>'a-ProcessingRegion--dialog'
,p_template_types=>'REGION'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(246928993153707476.4024)
,p_build_option_name=>'NEVER'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
,p_on_upgrade_keep_status=>true
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(366100516974803533.4024)
,p_build_option_name=>'email style master detail'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(641974235841696132.4024)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(2605452072303844293.4024)
,p_build_option_name=>'company address'
,p_build_option_status=>'EXCLUDE'
,p_build_option_comment=>'we can avoid asking internal Oracle folks for address info'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(2698024371153404344.4024)
,p_build_option_name=>'Advanced Form'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>'Include the ability to define advanced master detail forms.'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(2698024578226405812.4024)
,p_build_option_name=>'Language Selection'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(2698024775220408056.4024)
,p_build_option_name=>'Authentication Selection'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>'Allow developer to select application at time of application creation'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(2746942411136297678.4024)
,p_build_option_name=>'Dashboard'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>'Include the ability to create dashboard pages.'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(3027829547778015556.4024)
,p_build_option_name=>'Advanced Application Settings'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>'Include the advanced application options as part of the create application wizard.'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(3027830547707021532.4024)
,p_build_option_name=>'application defaults'
,p_build_option_status=>'INCLUDE'
,p_on_upgrade_keep_status=>true
,p_build_option_comment=>'ability to specify user interface defaults, lists of values etc.'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(3027985170417035432.4024)
,p_build_option_name=>'Blueprints'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>'Allow for viewing and editing of application blue prints.'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(3124271964326242195.4024)
,p_build_option_name=>'supporting objects'
,p_build_option_status=>'EXCLUDE'
,p_build_option_comment=>'when creating a new application, allow the inclusion of supporting object scripts'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(3145295462075987142.4024)
,p_build_option_name=>'drill down reporting'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>'ability to link a column on one report to another report'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273409673355856484)
,p_name=>'ADMINISTRATORS'
,p_message_language=>'it'
,p_message_text=>'Amministratori'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273409751254856484)
,p_name=>'ALL_USERS'
,p_message_language=>'it'
,p_message_text=>'Tutti gli utenti'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(273409850114856484)
,p_name=>'REPORT'
,p_message_language=>'it'
,p_message_text=>'Report'
);
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_page_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(2647222231143044328.4024)
,p_shortcut_name=>'DELETE_PAGE_CONFIRM_MSG'
,p_shortcut_type=>'FUNCTION_BODY'
,p_shortcut=>'return replace( wwv_flow_lang.custom_runtime_message( p_name => ''CA.DELETE.CONFIRM'' ),'''''''',''\'''''');'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/creating_application
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(2717735057626016839.4024)
,p_shortcut_name=>'CREATING_APPLICATION'
,p_shortcut_type=>'FUNCTION_BODY'
,p_shortcut=>'return replace( wwv_flow_lang.custom_runtime_message( p_name => ''CA.CREATING.APPLICATION'' ),'''''''',''\'''''');'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/item_help
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(2745706623582705225.4024)
,p_shortcut_name=>'ITEM_HELP'
,p_shortcut_type=>'HTML_TEXT'
,p_error_text=>'Impossibile visualizzare la Guida.'
,p_reference_id=>24184979678.4024
,p_shortcut=>'<a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999" title="Guida su questo elemento."><img src="#IMAGE_PREFIX#infoicon_status_gray.gif" width="16" height="16" /></a>'
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(3324722473421190676.4024)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040.4024
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(118549832896910933.4024)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>'INTERNAL - Social Sign-In'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086.4024
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118550071792910933.4024)
,p_plugin_id=>wwv_flow_api.id(118549832896910933.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118551916041910934.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(118550071792910933.4024)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118550487283910933.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(118550071792910933.4024)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118550963095910933.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(118550071792910933.4024)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118551400674910934.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(118550071792910933.4024)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118552474006910934.4024)
,p_plugin_id=>wwv_flow_api.id(118549832896910933.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118550071792910933.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118552861068910934.4024)
,p_plugin_id=>wwv_flow_api.id(118549832896910933.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118550071792910933.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118553290368910935.4024)
,p_plugin_id=>wwv_flow_api.id(118549832896910933.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118550071792910933.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118553696930910935.4024)
,p_plugin_id=>wwv_flow_api.id(118549832896910933.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118550071792910933.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118554018063910935.4024)
,p_plugin_id=>wwv_flow_api.id(118549832896910933.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Application Express automatically adds the "openid" scope. The authent'
||'ication provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118554496624910935.4024)
,p_plugin_id=>wwv_flow_api.id(118549832896910933.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118554823499910935.4024)
,p_plugin_id=>wwv_flow_api.id(118549832896910933.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118555275798910935.4024)
,p_plugin_id=>wwv_flow_api.id(118549832896910933.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(505938009162025794.4024)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>'Aggiungi casella di controllo Seleziona tutto'
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512.4024
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>L''azione dinamica "Aggiungi casella di controllo Seleziona tutto" converte un''intestazione di colonna contenente la stringa #CHECK_ALL_CHECKBOX# in una casella di controllo accessibile di tipo Seleziona tutto, ovvero tutte le caselle di controllo '
||'nella colonna corrispondente verranno selezionate o deselezionate.<p>',
'<p>',
'Per utilizzare questo plugin, assicurarsi che siano impostati gli attributi riportati di seguito.',
'<ol>',
'<li>Nella colonna di report, ''#CHECK_ALL_CHECKBOX#'' deve essere definito come valore di intestazione.</li>',
'<li>Per l''attributo Quando dell''azione dinamica, selezionare l''area del report contenente la colonna.</li>',
'<li>Definire l''azione dinamica in modo che si attivi ''Dopo l''aggiornamento'', mentre l''azione deve essere impostata su ''Attiva al caricamento della pagina''. Entrambe le azioni verranno preimpostate in modo adeguato se l''azione dinamica viene creata se'
||'lezionando l''area nella sezione ''Rendering'' di Page Designer e creando l''azione dinamica da qui.</li>',
unistr('<li>Non verr\00E0 gestito l''accesso facilitato delle caselle di controllo visualizzate in ogni riga. Ci\00F2 dovr\00E0 essere eseguito separatamente nell''origine dell''area. Per un esempio, vedere 4000:656 ''Aree''.</li>'),
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2876432243634950829.4024)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>'Autorizzazione sviluppatore'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494.4024
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_plugin_id=>wwv_flow_api.id(2876432243634950829.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876432920391950839.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876433462543950843.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876433962698950843.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876434432041950844.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876434954850950844.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876435459487950844.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876435968703950844.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876436475353950845.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876436973752950845.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876437409361950845.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876437949162950846.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2876438432350950846.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(2876432507210950834.4024)
,p_display_sequence=>120
,p_display_value=>'PKG_APPS: Ability to install packaged applications'
,p_return_value=>'PKG_APPS'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_code_editor
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2985465796466205447.4024)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.CODE_EDITOR'
,p_display_name=>'Editor di codice'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.CODE_EDITOR'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_code_editor'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_code_editor'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:READONLY:SOURCE:ELEMENT:WIDTH:HEIGHT:ENCRYPT'
,p_substitute_attributes=>true
,p_reference_id=>1510773430399830292.4024
,p_subscribe_plugin_settings=>true
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359522768319120272.4024)
,p_plugin_id=>wwv_flow_api.id(2985465796466205447.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'SQL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359523137517120272.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_display_sequence=>10
,p_display_value=>'SQL'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359523669261120273.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_display_sequence=>20
,p_display_value=>'HTML'
,p_return_value=>'HTMLMIXED'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359524149003120273.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_display_sequence=>30
,p_display_value=>'CSS'
,p_return_value=>'CSS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359524654310120273.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_display_sequence=>40
,p_display_value=>'JavaScript'
,p_return_value=>'JAVASCRIPT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359525134236120273.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_display_sequence=>45
,p_display_value=>'DDL'
,p_return_value=>'DDL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359525643169120274.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_display_sequence=>50
,p_display_value=>'PL/SQL Block'
,p_return_value=>'PLSQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359526128481120274.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_display_sequence=>60
,p_display_value=>'PL/SQL Functions/Procedures'
,p_return_value=>'PLSQL_FUNCTIONS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359526642957120274.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_display_sequence=>70
,p_display_value=>'PL/SQL Expression'
,p_return_value=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359527193800120274.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_display_sequence=>80
,p_display_value=>'PL/SQL Function Body'
,p_return_value=>'PLSQL_FUNCTION_BODY'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359527663310120275.4024)
,p_plugin_id=>wwv_flow_api.id(2985465796466205447.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Return Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'PLSQL_EXPRESSION,PLSQL_FUNCTION_BODY'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359528023843120275.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359527663310120275.4024)
,p_display_sequence=>10
,p_display_value=>'VARCHAR2'
,p_return_value=>'VARCHAR2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359528598307120275.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359527663310120275.4024)
,p_display_sequence=>20
,p_display_value=>'BOOLEAN'
,p_return_value=>'BOOLEAN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359529004123120275.4024)
,p_plugin_id=>wwv_flow_api.id(2985465796466205447.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Show Query Builder'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(359522768319120272.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'SQL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359529434997120275.4024)
,p_plugin_id=>wwv_flow_api.id(2985465796466205447.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Adjustable Height'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_supported_ui_types=>'DESKTOP'
,p_is_translatable=>false
,p_help_text=>'If Yes the user can adjust the height of the code editor.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359529820989120276.4024)
,p_plugin_id=>wwv_flow_api.id(2985465796466205447.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Remote  Database ID item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>false
,p_is_common=>false
,p_show_in_wizard=>false
,p_is_translatable=>false
,p_help_text=>'Specify a page item containing the remote database ID to use for code validation.'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(3324699829921132577.4024)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>'Account di Application Express INTERNAL'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425.4024
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(3324700073692132611.4024)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>'Account di database INTERNAL'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749511183746276.4024
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(3324700335694132612.4024)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>'Variabile di intestazione HTTP INTERNAL'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>708795120396802284.4024
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324700679263132613.4024)
,p_plugin_id=>wwv_flow_api.id(3324700335694132612.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324701109931132616.4024)
,p_plugin_id=>wwv_flow_api.id(3324700335694132612.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324701450621132616.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324701109931132616.4024)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324701921591132620.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324701109931132616.4024)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324702455638132620.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324701109931132616.4024)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324702993329132620.4024)
,p_plugin_id=>wwv_flow_api.id(3324700335694132612.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(3324701109931132616.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>',
'<p>',
'<h3>Example:</h3>',
'<pre>http://sso.mycompany.com/?success=#CALLBACK#</pre>',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324703392517132621.4024)
,p_plugin_id=>wwv_flow_api.id(3324700335694132612.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(3324701109931132616.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324703715711132621.4024)
,p_plugin_id=>wwv_flow_api.id(3324700335694132612.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(3324701109931132616.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'BUILTIN_URL,URL'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324704199740132622.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324703715711132621.4024)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324704693017132622.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324703715711132621.4024)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324705208399132623.4024)
,p_plugin_id=>wwv_flow_api.id(3324700335694132612.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(3324706481652132628.4024)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>'Directory LDAP INTERNAL'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>863910941135523528.4024
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Immettere il nome utente e la password per l''autenticazione rispetto alla directory LDAP identificata nella pagina di login. Le password possono distinguere tra maiuscole e minuscole.</p>',
''))
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324706669002132628.4024)
,p_plugin_id=>wwv_flow_api.id(3324706481652132628.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324707056596132628.4024)
,p_plugin_id=>wwv_flow_api.id(3324706481652132628.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324707506505132629.4024)
,p_plugin_id=>wwv_flow_api.id(3324706481652132628.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324707815545132629.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324707506505132629.4024)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324708404097132631.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324707506505132629.4024)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324708840184132631.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324707506505132629.4024)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324709400834132631.4024)
,p_plugin_id=>wwv_flow_api.id(3324706481652132628.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324709739771132632.4024)
,p_plugin_id=>wwv_flow_api.id(3324706481652132628.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324710148854132632.4024)
,p_plugin_id=>wwv_flow_api.id(3324706481652132628.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(3324709739771132632.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324710599897132632.4024)
,p_plugin_id=>wwv_flow_api.id(3324706481652132628.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3324710980739132632.4024)
,p_plugin_id=>wwv_flow_api.id(3324706481652132628.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324711316335132633.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324710980739132632.4024)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324711846150132633.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324710980739132632.4024)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3324712402550132633.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3324710980739132632.4024)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(3324713153644132635.4024)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'Oracle Application Server Single Sign-On INTERNAL'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113750429890071859.4024
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(3324713486560132636.4024)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>'Oracle Cloud Identity Management INTERNAL'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749806821809026.4024
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_wizard_selection
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(3364064701836787185.4024)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.WIZARD_SELECTION'
,p_display_name=>'Selezione procedura guidata'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.WIZARD_SELECTION'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_wizard_selection'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_wizard_selection'
,p_standard_attributes=>'VISIBLE:SESSION_STATE:SOURCE:ELEMENT:LOV:CASCADING_LOV'
,p_substitute_attributes=>true
,p_reference_id=>805558538998648898.4024
,p_subscribe_plugin_settings=>true
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3364064996228787343.4024)
,p_plugin_id=>wwv_flow_api.id(3364064701836787185.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Icon Size'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'S'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3364065405041787344.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3364064996228787343.4024)
,p_display_sequence=>10
,p_display_value=>'Small'
,p_return_value=>'S'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3364065866700787344.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3364064996228787343.4024)
,p_display_sequence=>20
,p_display_value=>'Medium'
,p_return_value=>'M'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(3364066315358787344.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(3364064996228787343.4024)
,p_display_sequence=>30
,p_display_value=>'Large'
,p_return_value=>'L'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(3364066821322787346.4024)
,p_plugin_id=>wwv_flow_api.id(3364064701836787185.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Submit Page'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
,p_help_text=>'Select whether or not to submit the page when making a selection'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(3403659208803969971.4024)
,p_plugin_id=>wwv_flow_api.id(3364064701836787185.4024)
,p_name=>'LOV'
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_clob_code_editor
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(3503624151937027104.4024)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.CLOB_CODE_EDITOR'
,p_display_name=>'Editor di codice CLOB'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.CLOB_CODE_EDITOR'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_clob_code_editor'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_clob_code_editor'
,p_standard_attributes=>'SOURCE_SQL:NO_DATA_FOUND_MESSAGE'
,p_substitute_attributes=>true
,p_reference_id=>1523790298062276372.4024
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359558961539122105.4024)
,p_plugin_id=>wwv_flow_api.id(3503624151937027104.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Mode'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'SQL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359559350527122105.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359558961539122105.4024)
,p_display_sequence=>10
,p_display_value=>'SQL'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359559896430122106.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359558961539122105.4024)
,p_display_sequence=>20
,p_display_value=>'HTML'
,p_return_value=>'HTMLMIXED'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359560363445122106.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359558961539122105.4024)
,p_display_sequence=>30
,p_display_value=>'CSS'
,p_return_value=>'CSS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359560881856122107.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359558961539122105.4024)
,p_display_sequence=>40
,p_display_value=>'JavaScript'
,p_return_value=>'JAVASCRIPT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359561393030122107.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359558961539122105.4024)
,p_display_sequence=>45
,p_display_value=>'DDL'
,p_return_value=>'DDL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359561886281122107.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359558961539122105.4024)
,p_display_sequence=>50
,p_display_value=>'PL/SQL Block'
,p_return_value=>'PLSQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359562343127122108.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359558961539122105.4024)
,p_display_sequence=>70
,p_display_value=>'PL/SQL Expression'
,p_return_value=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359562836869122108.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359558961539122105.4024)
,p_display_sequence=>80
,p_display_value=>'PL/SQL Function Body'
,p_return_value=>'PL/SQL_FUNCTION_BODY'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359563375012122108.4024)
,p_plugin_id=>wwv_flow_api.id(3503624151937027104.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Height'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359563754391122108.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359563375012122108.4024)
,p_display_sequence=>1
,p_display_value=>'5'
,p_return_value=>'5'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359564262486122109.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359563375012122108.4024)
,p_display_sequence=>2
,p_display_value=>'10'
,p_return_value=>'10'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359564793573122109.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359563375012122108.4024)
,p_display_sequence=>3
,p_display_value=>'20'
,p_return_value=>'20'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359565270127122109.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359563375012122108.4024)
,p_display_sequence=>10
,p_display_value=>'30'
,p_return_value=>'30'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359565755141122109.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359563375012122108.4024)
,p_display_sequence=>20
,p_display_value=>'60'
,p_return_value=>'60'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359566292948122110.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359563375012122108.4024)
,p_display_sequence=>25
,p_display_value=>'80'
,p_return_value=>'80'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359566796378122110.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359563375012122108.4024)
,p_display_sequence=>30
,p_display_value=>'Automatic'
,p_return_value=>'AUTO'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359567230537122110.4024)
,p_plugin_id=>wwv_flow_api.id(3503624151937027104.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Read Only'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359567620112122110.4024)
,p_plugin_id=>wwv_flow_api.id(3503624151937027104.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>15
,p_prompt=>'Return Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(359558961539122105.4024)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'PLSQL_EXPRESSION,PLSQL_FUNCTION_BODY'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359568005842122110.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359567620112122110.4024)
,p_display_sequence=>10
,p_display_value=>'VARCHAR2'
,p_return_value=>'VARCHAR2'
,p_help_text=>'VARCHAR2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(359568508303122111.4024)
,p_plugin_attribute_id=>wwv_flow_api.id(359567620112122110.4024)
,p_display_sequence=>20
,p_display_value=>'BOOLEAN'
,p_return_value=>'BOOLEAN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(359569017958122111.4024)
,p_plugin_id=>wwv_flow_api.id(3503624151937027104.4024)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Remote Database ID item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>false
,p_is_common=>false
,p_is_translatable=>false
,p_help_text=>'Specify the an item containing the ID of the remote database to use for code validation.'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(359570669651122124.4024)
,p_plugin_id=>wwv_flow_api.id(3503624151937027104.4024)
,p_name=>'SOURCE_SQL'
,p_is_required=>false
,p_sql_min_column_count=>1
,p_sql_max_column_count=>1
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select clob_content',
'from demo_scripts'))
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>'Desktop'
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>101
,p_home_url=>'f?p=4020:1:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4024
,p_nav_list_template_options=>'#DEFAULT#'
,p_css_file_urls=>'#IMAGE_PREFIX#libraries/font-apex/2.0/css/font-apex.min.css?v=#APP_VERSION#'
,p_javascript_file_urls=>'#IMAGE_PREFIX#apex_ui/js/#MIN_DIRECTORY#ui.core#MIN#.js'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'0'
,p_step_title=>'0'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(3286607596938476944.4024)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2943195795875068280.4024)
,p_plug_name=>'APEX 5 - Header Old'
,p_region_css_classes=>'a-Header'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="f?p=4000:1500:&APP_SESSION." class="a-Header-logo" title="Home">',
'  <span class="a-Header-apexLogo"></span>',
'</a>'))
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6545080822676071207.4024)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-app-builder'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6545081024953071207.4024)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(6545080822676071207.4024)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6163005498826978606.4024)
,p_plug_name=>'APEX Tabs'
,p_region_name=>'a_Header_menu'
,p_parent_plug_id=>wwv_flow_api.id(6545081024953071207.4024)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(3078141213440643205.4024)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(3157523106769548315.4024)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6545081194689071207.4024)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(6545081024953071207.4024)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6545081398411071208.4024)
,p_plug_name=>'APEX 5 - Home Link'
,p_parent_plug_id=>wwv_flow_api.id(6545081024953071207.4024)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6545081643308071208.4024)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(6545080822676071207.4024)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6545081864584071208.4024)
,p_plug_name=>'APEX 5 - Search'
,p_parent_plug_id=>wwv_flow_api.id(6545081643308071208.4024)
,p_region_css_classes=>'a-Header-search'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-SearchBox a-SearchBox--noGoButton a-SearchBox--autoExpand a-SearchBox--fill">'');',
'sys.htp.p(''  <div class="a-SearchBox-field">'');',
'sys.htp.p(''    <span class="a-SearchBox-icon"><span class="a-Icon icon-search"></span></span>'');',
'sys.htp.p(''    <label for="P0_SEARCH" class="visuallyhidden">Search</label>'');',
'sys.htp.p(''    <input type="text" class="a-SearchBox-input" id="P0_SEARCH" placeholder="''||wwv_flow_lang.system_message(''WWV_FLOW_QUICK_FLOW.SEARCH'')||''">'');',
'sys.htp.p(''  </div>'');',
'sys.htp.p(''</div>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6545082010678071208.4024)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_api.id(6545081643308071208.4024)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6545117961709147215.4024)
,p_plug_name=>'APEX 5 - Administration Menu'
,p_region_name=>'adminMenu'
,p_parent_plug_id=>wwv_flow_api.id(6545082010678071208.4024)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>120
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(3078131037146643152.4024)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(3331503598779942021.4024)
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6643087951170591881.4024)
,p_plug_name=>'APEX 5 - Help Menu'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_api.id(6545082010678071208.4024)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>130
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(3078138630465643203.4024)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(3331503598779942021.4024)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6545082204037071208.4024)
,p_plug_name=>'APEX 5 - Header Account'
,p_parent_plug_id=>wwv_flow_api.id(6545081643308071208.4024)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078194876396647079.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(6545081398411071208.4024)
,p_button_name=>'Home'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Home'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4500:1000:&SESSION.::&DEBUG.::::'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-home'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078196131874647081.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(6545082010678071208.4024)
,p_button_name=>'Administration'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2583919293963280507.4024)
,p_button_image_alt=>'Amministrazione'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078196573562647081.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(6545082010678071208.4024)
,p_button_name=>'Feedback'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Feedback'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
,p_required_patch=>wwv_flow_api.id(641974235841696132.4024)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078196996191647082.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(6545082010678071208.4024)
,p_button_name=>'Help'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2583919293963280507.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Crea applicazione'
,p_step_title=>'Crea applicazione'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var MSG_CREATING_APPLICATION = ''"CREATING_APPLICATION"'';',
'',
'(function( $ ){',
'    apex.create_app_wizard = apex.create_app_wizard || {};',
'',
'    apex.create_app_wizard.pageSort = function () {',
'        var prevSeq,',
'            currentSeq,',
'            moveCount,',
'            action,',
'            pageId;',
'',
'        var getSeq = function ( elem$ ) {',
'            return $( ''li.a-PWList-item'' ).index( elem$ );',
'        };',
'',
'        var move = function( page_id, move_count, v_action ) {',
'            apex.server.process( ''sortPage'', {',
'                x01: page_id,',
'                x02: move_count,',
'                x03: v_action',
'            }, {',
'                success: function( pData ) {',
'                    $( ''#pages'' ).trigger( ''apexrefresh'' );',
'                },',
'                error: function( pData ) {',
'                    alert( pData.responseText );',
'                }',
'            });',
'        };',
'',
'        $(".a-PWList").sortable({',
'            handle: ".a-PWList-dragHandle",',
'            items: "> li.is-draggable",',
'            placeholder: "a-PWList-item is-placeholder",',
'',
'            activate: function( event, ui ) {',
'                pageId = prevSeq = getSeq( ui.item.first() );',
'            },',
'',
'            update: function( event, ui ) {',
'                currentSeq = getSeq( ui.item.first() );',
'',
'                if ( currentSeq > prevSeq ) {',
'                    action = ''down'';',
'                    moveCount = currentSeq - prevSeq;',
'                } else {',
'                    action = ''up'';',
'                    moveCount = prevSeq - currentSeq;',
'                }',
'',
'                move(pageId, moveCount, action );',
'            }',
'',
'        });',
'',
'    };',
'})( apex.jQuery );'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'(function( $ ){',
'    $("#choose_icon").appendTo(".a-PageWizard-appIconContainer .a-Form-inputContainer");',
'})( apex.jQuery );',
'',
'apex.item( "P1_STATUS" ).setValue( "" );',
'apex.item( "P1_PCT_COMPLETE" ).setValue( "" );',
'apex.item( "P1_CURRENT_STATUS" ).setValue( "" );'))
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.field.item-app-name { margin-bottom: 0; }',
'.field--style--boxed .display_only { line-height: 24px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }',
'.apex-col .field.field-item-button-grouping { margin-right: -1px; }',
'.lang-button { padding-top: 19px; padding-bottom: 19px; width: calc(100% - 16px); margin-right: 16px; }',
'.advanced-button { padding-top: 19px; padding-bottom: 19px; width: calc(100% - 16px); margin-right: 16px; }',
'.attribute-button { padding-top: 19px; padding-bottom: 19px; width: calc(100% - 16px); margin-right: 16px; }',
'.a-BoxedForms .field-item-button-grouping .field-input__wrap { border-radius: 2px 0 0 2px; }',
'html.no-js .a-BoxedForms .field--style--boxed.label-only .field-label { padding-top: 1.8rem; padding-bottom: 1.8rem; }',
'.page-source-table { font-family: monospace; font-size: 11px; line-height: 21px; margin: 0 4px; }',
'.features-checkbox .apex-item-grid {width: 100%;table-layout: fixed;}',
'.field--style--boxed.last-item {margin-right: 16px !important;}'))
,p_step_template=>wwv_flow_api.id(3221353480673840388.4024)
,p_page_css_classes=>'a-PageWizard-page'
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1007567025794031530.4024)
,p_plug_name=>'Avanzamento della creazione dell''applicazione'
,p_region_name=>'createAppProgress'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3012513290302116971.4024)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(8119582015725719321.4024)
,p_plug_name=>'Crea un''applicazione'
,p_region_css_classes=>'a-PageWizard '
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_plug_name=>'Aspetto'
,p_region_name=>'appearance'
,p_parent_plug_id=>wwv_flow_api.id(8119582015725719321.4024)
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display:none;"'
,p_plug_template=>wwv_flow_api.id(2584574193315975428.4024)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(5170953344043764457.4024)
,p_name=>'Pagine'
,p_region_name=>'pages'
,p_parent_plug_id=>wwv_flow_api.id(8119582015725719321.4024)
,p_template=>wwv_flow_api.id(2584574193315975428.4024)
,p_display_sequence=>40
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  0 sort_order,',
'  null id,',
'  ''a-PWList-item--add is-not-draggable'' page_li_class,',
'  ''<a href="''||apex_page.get_url(p_page => 1000, p_clear_cache => 1000)||''" class="a-PageWizard-icon page-icon page-add"></a>'' page_icon,',
'  ''<a href="''||apex_page.get_url(p_page => 1000, p_clear_cache => 1000)||''">'' || wwv_flow_lang.custom_runtime_message(''CA.ADD.PAGE'') || ''</a>'' page_title,',
'  '' '' page_desc,',
'  null edit_link,',
'  '' '' page_actions,',
'  apex_page.get_url(p_page => 1000, p_clear_cache => 1000) page_link,',
'  ''n'' admin_page_yn,',
'  ''n'' homepage_yn,',
'  '' '' drag_icon,',
'  '' '' page_draggable,',
'  '' '' page_drag_handle',
'from sys.dual ',
'union all',
'select',
'  seq_id sort_order,',
'  seq_id id,',
'  case when c015 = ''Y'' then ''is-admin-page''',
'       else '' ''',
'  end page_li_class,',
'  ''<span class="a-PageWizard-icon page-icon page-'' || replace(lower(c002), ''_'', ''-'')||''"></span>'' page_icon,',
'  ''<span class="a-PWList-navIcon fa ''||c013||''" aria-hidden="true"></span> ''||c001 page_title,',
'  case when c012 = ''Y'' then',
'      wwv_flow_lang.custom_runtime_message(''CA.REPORT.N.WITH.FORM'', apex_item.text_from_lov( p_value => c002, p_lov => ''PAGE_TYPES'') )',
'  else',
'      apex_item.text_from_lov( p_value => c002, p_lov => ''PAGE_TYPES'')',
'  end||',
'  case when c003 = ''TABLE'' then '' (<span class="page-source-table">''',
'            ||lower(c005) ',
'            || nvl2(c025, ''; '' || lower(c025), null)',
'            || nvl2(c026, '' ...'', null)',
'            || ''</span>)''',
'       when c003 = ''SQL'' then '' (<span class="page-source-table">''||wwv_flow_lang.custom_runtime_message(''CA.CUSTOM.QRY'')||''</span>)''',
'       when c015 = ''Y'' then '' (''||wwv_flow_lang.custom_runtime_message(''CA.ADMIN.PAGE'')||'')''',
'  end page_desc,',
'  case when c002 = ''BLANK'' then ',
'           apex_page.get_url(p_page => 1010, p_items => ''P1010_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1010'')',
'       when c002 in ( ''INTERACTIVE_RPT'', ''CLASSIC_RPT'' ) then',
'           apex_page.get_url(p_page => 1020, p_items => ''P1020_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1020'')',
'       when c002 = ''FACETED_SEARCH'' then',
'           apex_page.get_url(p_page => 1140, p_items => ''P1140_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1140'')',
'       when c002 = ''INTERACTIVE_GRID'' then',
'           apex_page.get_url(p_page => 1030, p_items => ''P1030_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1030'')',
'       when c002 = ''FORM'' then',
'           apex_page.get_url(p_page => 1100, p_items => ''P1100_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1100'')',
'       when c002 = ''MASTER_DETAIL'' then',
'           apex_page.get_url(p_page => 1040, p_items => ''P1040_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1040'')',
'       when c002 = ''CHART'' then',
'           apex_page.get_url(p_page => 1050, p_items => ''P1050_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1050'')',
'       when c002 = ''DASHBOARD'' then',
'           apex_page.get_url(p_page => 1060, p_items => ''P1060_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1060'')',
'       when c002 = ''CALENDAR'' then',
'           apex_page.get_url(p_page => 1070, p_items => ''P1070_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1070'')',
'       when c002 = ''CARDS'' then',
'           apex_page.get_url(p_page => 1090, p_items => ''P1090_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1090'')',
'       when c002 = ''TIMELINE'' then',
'           apex_page.get_url(p_page => 1110, p_items => ''P1110_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1110'')',
'       when c002 = ''WIZARD'' then',
'           apex_page.get_url(p_page => 1120, p_items => ''P1120_SEQ_ID'', p_values => seq_id, p_clear_cache => ''1120'')',
'  end edit_link,',
'  '''' page_actions,',
'  '' '' page_link,',
'  c015 admin_page_yn,',
'  c010 homepage_yn,',
'  case when c015 = ''Y'' then ''<span class="fa fa-wrench" aria-hidden="true" title="''||wwv_flow_lang.custom_runtime_message(''CA.ADMIN.PAGE'')||''"></span>'' -- is admin page',
'       when c010 = ''Y'' then ''<span class="fa fa-home" aria-hidden="true" title="''||wwv_flow_lang.custom_runtime_message(''CA.HOME.PAGE'')||''"></span>'' -- is homepage',
'       else ''<span class="fa fa-bars" aria-hidden="true" title="''||wwv_flow_lang.custom_runtime_message(''CA.DRAG.TO.REORDER'')||''"></span>''',
'  end drag_icon,',
'  -- case c010 when ''Y'' then ''<span class="fa fa-home" aria-hidden="true"></span>''',
'  --           else ''<span class="fa fa-bars" aria-hidden="true"></span>''',
'  --           end drag_icon,',
'  case c015 when ''Y'' then ''is-not-draggable''',
'            else case c010 when ''Y'' then ''is-not-draggable'' ',
'                 else ''is-draggable'' ',
'            end',
'  end page_draggable,',
'  '' '' page_drag_handle',
'from apex_collections',
'where collection_name = ''APEX$CREATE_APP_PAGE''',
'order by sort_order'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(2583678044278335201.4024)
,p_query_num_rows=>1000
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592733388174337004.4024)
,p_query_column_id=>1
,p_column_alias=>'SORT_ORDER'
,p_column_display_sequence=>6
,p_column_heading=>'Criterio di ordinamento'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592730594146337001.4024)
,p_query_column_id=>2
,p_column_alias=>'ID'
,p_column_display_sequence=>8
,p_column_heading=>'ID'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592728590024336998.4024)
,p_query_column_id=>3
,p_column_alias=>'PAGE_LI_CLASS'
,p_column_display_sequence=>1
,p_column_heading=>'Classe list item pagina'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592728956532337000.4024)
,p_query_column_id=>4
,p_column_alias=>'PAGE_ICON'
,p_column_display_sequence=>2
,p_column_heading=>'Icona di pagina'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592729394433337000.4024)
,p_query_column_id=>5
,p_column_alias=>'PAGE_TITLE'
,p_column_display_sequence=>3
,p_column_heading=>'Titolo pagina'
,p_use_as_row_header=>'N'
,p_column_html_expression=>'#PAGE_TITLE#'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592729720491337001.4024)
,p_query_column_id=>6
,p_column_alias=>'PAGE_DESC'
,p_column_display_sequence=>4
,p_column_heading=>'Descrizione pagina'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592731346485337002.4024)
,p_query_column_id=>7
,p_column_alias=>'EDIT_LINK'
,p_column_display_sequence=>10
,p_column_heading=>'Modifica collegamento'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592730198916337001.4024)
,p_query_column_id=>8
,p_column_alias=>'PAGE_ACTIONS'
,p_column_display_sequence=>5
,p_column_heading=>'Azioni pagina'
,p_use_as_row_header=>'N'
,p_column_html_expression=>'<button class="a-Button" type="button" onclick="#EDIT_LINK#">Modifica</button>'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592732981583337004.4024)
,p_query_column_id=>9
,p_column_alias=>'PAGE_LINK'
,p_column_display_sequence=>7
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2934949213997675417.4024)
,p_query_column_id=>10
,p_column_alias=>'ADMIN_PAGE_YN'
,p_column_display_sequence=>14
,p_column_heading=>'Pagina Amministrazione'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592730987527337002.4024)
,p_query_column_id=>11
,p_column_alias=>'HOMEPAGE_YN'
,p_column_display_sequence=>9
,p_column_heading=>'Home page'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592732119674337003.4024)
,p_query_column_id=>12
,p_column_alias=>'DRAG_ICON'
,p_column_display_sequence=>12
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592732504457337003.4024)
,p_query_column_id=>13
,p_column_alias=>'PAGE_DRAGGABLE'
,p_column_display_sequence=>13
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2592731761742337003.4024)
,p_query_column_id=>14
,p_column_alias=>'PAGE_DRAG_HANDLE'
,p_column_display_sequence=>11
,p_column_heading=>'Quadratino di trascinamento della pagina'
,p_use_as_row_header=>'N'
,p_column_html_expression=>'<span class="a-PWList-dragHandle #PAGE_DRAGGABLE#">#DRAG_ICON#</span>'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5170954103611764465.4024)
,p_plug_name=>'Intestazione procedura guidata'
,p_parent_plug_id=>wwv_flow_api.id(8119582015725719321.4024)
,p_region_css_classes=>'a-PageWizard-header'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_blueprint_count number := 0;',
'begin',
'',
'    -- get count of blueprints',
'    select count(*)',
'    into l_blueprint_count',
'    from WWV_FLOW_BLUEPRINT_REPO',
'    where created_by = :APP_USER and security_group_id = :FLOW_SECURITY_GROUP_ID;',
'',
'    sys.htp.p(''<div class="a-PageWizard-preview">'');',
'    -- sys.htp.prn(''<a href="''||apex_util.prepare_url(''f?p=4020:900:''||:APP_SESSION||''::::P900_HELP_SECTION:INTRO'')||''">'');',
'    -- sys.htp.prn(wwv_flow_lang.custom_runtime_message(''CA.ABOUT.THIS.PREVIEW.RELEASE''));',
'    -- sys.htp.prn(''</a>'');',
'    sys.htp.prn(''<a href="''||apex_util.prepare_url(''f?p=4020:150:''||:APP_SESSION||'':LOAD_CURRENT::150'')||''" id="view_blueprint">'');',
'    sys.htp.prn(wwv_flow_lang.custom_runtime_message(''CA.VIEW.BLUEPRINT''));',
'    sys.htp.prn(''</a>'');',
'    if l_blueprint_count > 0 then',
'      sys.htp.prn(''<a href="''||apex_page.get_url(p_page => 160, p_session => :APP_SESSION, p_request => ''LOAD'', p_items => ''P160_RETURN_TYPE'', p_values => ''LOAD'')||''" class="a-PageWizard-returnLink" id="load_blueprint">'');',
'      sys.htp.prn(wwv_flow_lang.custom_runtime_message(''CA.LOAD.BLUEPRINT''));',
'      sys.htp.prn(''</a>'');',
'    end if;',
'    sys.htp.prn(''</div><h1>''||wwv_flow_lang.custom_runtime_message(''CA.CREATE.APPLICATION'')||''</h1>'');',
'    exception when others then null;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5170954341225764467.4024)
,p_plug_name=>'Funzioni'
,p_region_name=>'features'
,p_parent_plug_id=>wwv_flow_api.id(8119582015725719321.4024)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(2584574193315975428.4024)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5170955245543764476.4024)
,p_plug_name=>'Varie'
,p_parent_plug_id=>wwv_flow_api.id(8119582015725719321.4024)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_plug_name=>'Impostazioni'
,p_region_name=>'advanced'
,p_parent_plug_id=>wwv_flow_api.id(8119582015725719321.4024)
,p_region_css_classes=>'a-BoxedForms'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(2584574193315975428.4024)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(8119582248366719323.4024)
,p_plug_name=>'Application'
,p_region_name=>'app_info'
,p_parent_plug_id=>wwv_flow_api.id(8119582015725719321.4024)
,p_region_css_classes=>'a-BoxedForms a-BoxedForms--large'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(8119582824709719329.4024)
,p_plug_name=>'Wizard Buttons'
,p_parent_plug_id=>wwv_flow_api.id(8119582015725719321.4024)
,p_region_css_classes=>'a-PageWizard-buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(161343362574782313.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(8119582248366719323.4024)
,p_button_name=>'SET_UI'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Imposta aspetto'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:170:&SESSION.::&DEBUG.:RP::'
,p_button_css_classes=>'lang-button'
,p_icon_css_classes=>'icon-open-in-dialog'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2929370093940839432.4024)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_button_name=>'SELECT_ADV_SETTINGS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Definisci impostazioni avanzate'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:RP::'
,p_button_css_classes=>'advanced-button'
,p_icon_css_classes=>'icon-open-in-dialog'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_required_patch=>wwv_flow_api.id(3027829547778015556.4024)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2929370286352839434.4024)
,p_button_sequence=>100
,p_button_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_button_name=>'SELECT_ATT_DEF'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Definisci impostazioni predefinite attributi'
,p_button_position=>'BODY'
,p_button_execute_validations=>'N'
,p_button_css_classes=>'attribute-button is-last'
,p_icon_css_classes=>'icon-open-in-dialog'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_required_patch=>wwv_flow_api.id(3027830547707021532.4024)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2796574865702751032.4024)
,p_button_sequence=>120
,p_button_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_button_name=>'SET_SUPOBJ'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Imposta oggetti di supporto'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:RP::'
,p_button_css_classes=>'lang-button'
,p_icon_css_classes=>'icon-open-in-dialog'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_required_patch=>wwv_flow_api.id(3124271964326242195.4024)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2588925400019150548.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_button_name=>'HELP_SETTINGS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader:a-Button--small'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Visualizza la Guida per Impostazioni'
,p_button_position=>'REGION_TEMPLATE_HELP'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:SETTINGS'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2595754447069422204.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_button_name=>'HELP_UI'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader:a-Button--small'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Visualizza la Guida per Impostazioni'
,p_button_position=>'REGION_TEMPLATE_HELP'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:UI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2595754509287422205.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5170954341225764467.4024)
,p_button_name=>'HELP_FEATURES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader:a-Button--small'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Visualizza la Guida per Funzioni'
,p_button_position=>'REGION_TEMPLATE_HELP'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:FEATURES'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2595755773975422217.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5170953344043764457.4024)
,p_button_name=>'HELP_PAGES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader:a-Button--small'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Visualizza la Guida per Pagine'
,p_button_position=>'REGION_TEMPLATE_HELP'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:PAGES'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2816364410490843901.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(5170954341225764467.4024)
,p_button_name=>'CHECK_ALL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Seleziona tutto'
,p_button_position=>'REGION_TEMPLATE_HELP'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2698020678343126341.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(8119582824709719329.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_APP'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=4000:1500:&SESSION.::&DEBUG.:RP::'
,p_button_css_classes=>'a-Button--xlarge'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2592727824404336994.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(8119582824709719329.4024)
,p_button_name=>'CREATE_APPLICATION'
,p_button_static_id=>'CREATE_APP'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea applicazione'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_css_classes=>'a-Button--xlarge a-Button--createApp'
,p_button_cattributes=>'disabled'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(63351936853934416.4024)
,p_branch_name=>'Create Application Error'
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'CREATE_APP_ERROR'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2878625357225257309.4024)
,p_branch_name=>'sup obj install failed'
,p_branch_action=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'EXISTS'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_collections',
'where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P1_APP_ID',
'and c002 = ''FAIL'''))
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2592737935823337026.4024)
,p_branch_name=>'application home'
,p_branch_action=>'f?p=4000:1:&SESSION.::&DEBUG.:RP:FB_FLOW_ID,F4000_P1_FLOW:&P1_APP_ID.,&P1_APP_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
,p_branch_condition_type=>'NOT_EXISTS'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_collections',
'where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P1_APP_ID',
'and c002 = ''FAIL'''))
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3398688211863765508.4024)
,p_branch_name=>'attribute defaults'
,p_branch_action=>'f?p=&APP_ID.:260:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_COMPUTATION'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(2929370286352839434.4024)
,p_branch_sequence=>40
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1699270756214123.4024)
,p_name=>'P1_NEW_TABLE_NAME'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(33865378214899629.4024)
,p_name=>'P1_SAMPLE_JSON_ID'
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(63351407823934411.4024)
,p_name=>'P1_STATUS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(8119582824709719329.4024)
,p_use_cache_before_default=>'NO'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(63351684305934413.4024)
,p_name=>'P1_CURRENT_STATUS'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(8119582824709719329.4024)
,p_use_cache_before_default=>'NO'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(63351739164934414.4024)
,p_name=>'P1_PCT_COMPLETE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(8119582824709719329.4024)
,p_use_cache_before_default=>'NO'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(63351864236934415.4024)
,p_name=>'P1_ERROR_MESSAGE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(8119582824709719329.4024)
,p_use_cache_before_default=>'NO'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(69711388331469934.4024)
,p_name=>'P1_SCRIPT_FILE_ID'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'S'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(84648867843905208.4024)
,p_name=>'P1_THEME_TYPE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_item_default=>'UT'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
,p_item_comment=>'UT, CUSTOM or CUSTOM_UT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(84648983889905209.4024)
,p_name=>'P1_THEME_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(101210628211869202.4024)
,p_name=>'P1_THEME_STYLE_CLASS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
,p_item_comment=>'Set in DA, used on Page 1 and 1000'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(161343206126782312.4024)
,p_name=>'P1_APPEARANCE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(8119582248366719323.4024)
,p_prompt=>'Aspetto'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field-item-button-grouping'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2574074743958843405.4024)
,p_name=>'P1_AUTHENTICATION'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_prompt=>'Autenticazione'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_default_auth_scheme varchar2(4000) := null;',
'begin',
'    if wwv_flow_authentication_dev.get_internal_authentication in (''CLOUD_IDM'', ''SSO'') then',
'        l_default_auth_scheme := wwv_flow_authentication_dev.get_internal_authentication;',
'    else',
'        l_default_auth_scheme := :PRODUCT_NAME;',
'    end if;',
'      ',
'    return l_default_auth_scheme;',
'end;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AUTHENTICATION.OPTIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, v from (',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.CLOUD_IDM'') d ,''CLOUD_IDM'' v from dual',
'where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'')d ,:PRODUCT_NAME v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.SSO'') d ,''SSO'' v from dual',
'where wwv_flow_authentication_dev.can_use_sso_yn = ''Y''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'') d,''DBACCOUNT'' v',
'from dual',
'where wwv_flow_authentication_dev.get_internal_authentication <> ''CLOUD_IDM''',
')'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'last-item'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_required_patch=>wwv_flow_api.id(2698024775220408056.4024)
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2588924959567150543.4024)
,p_name=>'P1_NAV_POSITION'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592720665139336973.4024)
,p_name=>'P1_FEATURES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5170954341225764467.4024)
,p_prompt=>'Funzioni'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'APPLICATION FEATURES'
,p_lov=>'.'||wwv_flow_api.id(2584581350475987525.4024)||'.'
,p_tag_css_classes=>'features-checkbox'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_css_classes=>'a-CBList'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'3'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592721384721336981.4024)
,p_name=>'P1_REMEMBER_WIZARD'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5170955245543764476.4024)
,p_prompt=>'Ricorda procedura guidata'
,p_display_as=>'NATIVE_CHECKBOX'
,p_lov=>'STATIC:Use this wizard next time I create an application;Y'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592722076041336984.4024)
,p_name=>'P1_APP_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_prompt=>'ID applicazione'
,p_source=>'wwv_flow_utilities.minimum_free_flow'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>12
,p_colspan=>4
,p_field_template=>wwv_flow_api.id(2716804030064502999.4024)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_03=>'left'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592722446739336985.4024)
,p_name=>'P1_PRIMARY_LANGUAGE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_item_default=>':BROWSER_LANGUAGE'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Lingua'
,p_source=>':BROWSER_LANGUAGE'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'I18N_LANGUAGES_LOCALES'
,p_lov=>'.'||wwv_flow_api.id(261035724719892504.4024)||'.'
,p_cHeight=>1
,p_colspan=>4
,p_field_template=>wwv_flow_api.id(2716804030064502999.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_required_patch=>wwv_flow_api.id(2698024578226405812.4024)
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Selezionare la lingua primaria per questa applicazione.<br /><br />',
unistr('Questo attributo identifica la lingua in cui viene sviluppata un''applicazione. Questa sar\00E0 la lingua di base dalla quale verranno effettuate tutte le traduzioni. ')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592723726162336986.4024)
,p_name=>'P1_SCHEMA'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_prompt=>'Schema'
,p_source=>'wwv_flow_user_api.get_default_schema'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LIST_AVAILABLE_SCHEMAS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(schema) a, schema b',
'from   wwv_flow_company_schemas',
'where  security_group_id = :flow_security_group_id',
'order by 1'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_colspan=>4
,p_field_template=>wwv_flow_api.id(2716804030064502999.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592725816442336990.4024)
,p_name=>'P1_APP_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(8119582248366719323.4024)
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>64
,p_colspan=>7
,p_field_template=>wwv_flow_api.id(2716804030064502999.4024)
,p_item_css_classes=>'item-app-name'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592726222702336990.4024)
,p_name=>'P1_THEME_APP_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(8119582248366719323.4024)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_theme_app_id number;',
'begin  ',
'    for c1 in (select t.id id',
'                from wwv_flows f, wwv_flow_user_interfaces ui, wwv_flow_app_build_pref p, wwv_flow_themes t',
'               where f.security_group_id = 12',
'                 and p.security_group_id = :flow_security_group_id',
'                 and f.application_type = ''THEME''',
'                 and f.id = ui.flow_id',
'                 and f.id = t.flow_id',
'                 and ui.theme_id = t.theme_id       ',
'                 and ui.ui_type_id = 1',
'                 and ui.theme_id = p.default_application_theme  )',
'    loop   ',
'        l_theme_app_id := c1.id;',
'    end loop;',
'    ',
'    if l_theme_app_id is null then',
'        for c2 in (select t.id id',
'                    from wwv_flows f, wwv_flow_user_interfaces ui, wwv_flow_themes t',
'                   where f.security_group_id = 12',
'                     and f.application_type = ''THEME''',
'                     and f.id = ui.flow_id',
'                     and f.id = t.flow_id',
'                     and ui.theme_id = t.theme_id',
'                     and ui.ui_type_id = 1',
'                     and instr('',''||wwv_flow_platform.get_preference(''DEFAULT_THEMES'')||'','','',''||t.theme_id||'','') > 0 )',
'        loop',
'            l_theme_app_id := c2.id;',
'        end loop;',
'    end if;',
'    ',
'    return l_theme_app_id;',
'end;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592726600519336991.4024)
,p_name=>'P1_THEME_STYLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2647105299483258112.4024)
,p_name=>'P1_APP_COLOR_CLASS'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'B'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2698020232651126337.4024)
,p_name=>'P1_APP_COLOR_HEX'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2698020453382126339.4024)
,p_name=>'P1_APP_ICON_CLASS'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2796574722343751031.4024)
,p_name=>'P1_SUPPORTING_OBJS'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_item_default=>'None'
,p_prompt=>'Oggetti di supporto'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_colspan=>3
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field-item-button-grouping'
,p_item_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3124271964326242195.4024)
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2927879450766772209.4024)
,p_name=>'P1_TRANSLATED_LANGS'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_required_patch=>wwv_flow_api.id(2698024578226405812.4024)
,p_help_text=>'Facoltativamente, identificare le lingue aggiuntive in cui si desidera tradurre questa applicazione. '
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929369916090839431.4024)
,p_name=>'P1_ADVANCED_SETTINGS'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_prompt=>'Impostazioni avanzate'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_colspan=>3
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field-item-button-grouping label-only'
,p_item_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3027829547778015556.4024)
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929370181863839433.4024)
,p_name=>'P1_APP_DEFAULTS'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_prompt=>'Valori predefiniti interfaccia utente'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_colspan=>3
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field-item-button-grouping label-only'
,p_item_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3027830547707021532.4024)
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3396254935956246644.4024)
,p_name=>'P1_NAV_POSITION_DISP'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(2588924839213150542.4024)
,p_item_default=>'SIDE'
,p_prompt=>'Nuovo'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'P1_NAVIGATION_POSITION'
,p_lov=>'.'||wwv_flow_api.id(2621239147915611502.4024)||'.'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
,p_item_comment=>'Used in DA "Set Appearance" to get displayed value only. Not saved.'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4032943218417342948.4024)
,p_name=>'P1_SCRIPT_RESULT_ID'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(7754217211232429554.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'S'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(3773582095982301543.4024)
,p_computation_sequence=>10
,p_computation_item=>'P1_THEME_STYLE'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'Vita'
,p_compute_when=>'P1_THEME_STYLE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(3773582128939301544.4024)
,p_computation_sequence=>20
,p_computation_item=>'P1_NAV_POSITION'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'SIDE'
,p_compute_when=>'P1_NAV_POSITION'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(2647106702696258127.4024)
,p_computation_sequence=>30
,p_computation_item=>'P1_APP_ICON_CLASS'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'app-icon-bar-line-chart'
,p_compute_when=>'P1_APP_ICON_CLASS'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(2647106838317258128.4024)
,p_computation_sequence=>40
,p_computation_item=>'P1_APP_COLOR_CLASS'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'QUERY'
,p_computation=>'SELECT ''app-color-'' || round( dbms_random.value( 1,8 ) ) as color_class FROM sys.dual;'
,p_compute_when=>'P1_APP_COLOR_CLASS'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(2707858906190463440.4024)
,p_computation_sequence=>50
,p_computation_item=>'P1_APP_COLOR_HEX'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select return_value ',
'from apex_application_lov_entries ',
'where application_id = :APP_ID and',
'      list_of_values_name = ''P120_APP_COLORS'' and',
'      display_value = ''Color '' || replace(:P1_APP_COLOR_CLASS, ''app-color-'');'))
,p_compute_when=>'P1_APP_COLOR_HEX'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(2934949192969675416.4024)
,p_computation_sequence=>60
,p_computation_item=>'P1_PRIMARY_LANGUAGE'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>':BROWSER_LANGUAGE'
,p_compute_when=>'P1_PRIMARY_LANGUAGE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(2796575014459751034.4024)
,p_computation_sequence=>70
,p_computation_item=>'P1_SUPPORTING_OBJS'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'QUERY'
,p_computation=>'select dbms_lob.substr(clob001,30,1) x from apex_collections where collection_name = ''APEX$CREATEAPPSUPPOBJ'''
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(3674119010657496428.4024)
,p_computation_sequence=>10
,p_computation_item=>'P1_SCHEMA'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select run_as',
'from wwv_flow_sw_results',
'where id = :P1_SCRIPT_RESULT_ID',
'and security_group_id = :flow_security_group_id'))
,p_compute_when=>'P1_SCRIPT_RESULT_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(63352257772934419.4024)
,p_validation_name=>'Validate application ID'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_utilities.is_valid_application_id (',
'         p_name => :P1_APP_ID);'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_validation_condition=>'CREATE_APP_ERROR'
,p_validation_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_associated_item=>wwv_flow_api.id(2592722076041336984.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(63352379251934420.4024)
,p_validation_name=>'Application ID available'
,p_validation_sequence=>20
,p_validation=>'select 1 from wwv_flows where id = :P1_APP_ID'
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('L''ID applicazione esiste gi\00E0 oppure \00E8 riservato per un''altra applicazione.')
,p_validation_condition=>'CREATE_APP_ERROR'
,p_validation_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_associated_item=>wwv_flow_api.id(2592722076041336984.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(63352452742934421.4024)
,p_validation_name=>'Validate Application Name'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_utilities.is_valid_application_name (',
'  p_name => :P1_APP_NAME);'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_validation_condition=>'CREATE_APP_ERROR'
,p_validation_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_associated_item=>wwv_flow_api.id(2592725816442336990.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(63352073466934417.4024)
,p_validation_name=>'Create Application Error'
,p_validation_sequence=>60
,p_validation=>'return false;'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'&P1_ERROR_MESSAGE.'
,p_validation_condition=>'CREATE_APP_ORA_ERROR'
,p_validation_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2592736931000337018.4024)
,p_name=>'Refresh Pages on Dialog Close'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(5170953344043764457.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2592737489815337024.4024)
,p_event_id=>wwv_flow_api.id(2592736931000337018.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(5170953344043764457.4024)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2588921638137150510.4024)
,p_name=>'Toggle Create App Btn and Sortable'
,p_event_sequence=>20
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(5170953344043764457.4024)
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'$(".a-PWList-item").length > 1'
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2588921719428150511.4024)
,p_event_id=>wwv_flow_api.id(2588921638137150510.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_api.id(2592727824404336994.4024)
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2588921847590150512.4024)
,p_event_id=>wwv_flow_api.id(2588921638137150510.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_api.id(2592727824404336994.4024)
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2025750319577536748.4024)
,p_event_id=>wwv_flow_api.id(2588921638137150510.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.create_app_wizard.pageSort();'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1917402761781338048.4024)
,p_name=>'Save Schema in Session'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1_SCHEMA'
,p_bind_type=>'bind'
,p_bind_event_type=>'focusout'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1917402832990338049.4024)
,p_event_id=>wwv_flow_api.id(1917402761781338048.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>'apex_util.set_session_state(''P1_SCHEMA'', :P1_SCHEMA);'
,p_attribute_02=>'P1_SCHEMA'
,p_wait_for_result=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2595755989816422219.4024)
,p_name=>'Set Appearance and Toggle Features'
,p_event_sequence=>50
,p_triggering_element_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_element=>'window'
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'( this.data && this.data.dialogPageId === 160 ) || ( this.data && this.data.dialogPageId === 170 ) || !this.data'
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2595756028896422220.4024)
,p_event_id=>wwv_flow_api.id(2595755989816422219.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var $ = apex.jQuery,',
'    ajaxData = this.data,',
'    themeType = $v(''P1_THEME_TYPE''),',
'    isCustomTheme = themeType === ''CUSTOM'',',
'    isCustomUT = themeType === ''CUSTOM_UT'',',
'    theme,',
'    nav,',
'    output,',
'    blueprintActions$ = $( ''.a-PageWizard-preview'' ),',
'    features$ = $( ''#features'' ),',
'    page$ = $( ''#pages'' ),',
'    tMapping = {',
'		"Vita": "theme-vita",',
'		"Vita - Slate": "theme-vita-slate",',
'		"Vita - Red": "theme-vita-red",',
'		"Vita - Dark": "theme-vita-dark",',
'		"Vista": "theme-vista",',
'	},',
'    // For P1_THEME_STYLE_CLASS that is used on both Page 1 and 1000',
'    themeClass,',
'    defaultThemeClass = tMapping.Vita;',
'',
'var getNavDisp = function( val ){',
'    var txt = $(''#P1_NAV_POSITION_DISP input'').filter(function(){ ',
'                  return this.value === val;',
'              }).next().text();',
'    ',
'    return txt.substr( 0, txt.indexOf(''|'') - 1 ); // remove everything after ''|''',
'};',
'',
'if ( ajaxData ) {',
'    theme = ajaxData.P170_THEME_STYLE;',
'    nav   = ajaxData.P170_NAV_POSITION;',
'    if ( ajaxData.P170_CUSTOM_THEME_YN === ''Y'' ) {',
'        theme = '''',',
'        nav = '''',',
'        isCustomTheme = true;',
'        isCustomUT = ajaxData.P1_THEME_TYPE === ''CUSTOM_UT''',
'    } else {',
'    	isCustomTheme = false;',
'    	isCustomUT = false;',
'    }',
'    ',
'} else {',
'    theme = $v( ''P1_THEME_STYLE'' );',
'    nav   = $v( ''P1_NAV_POSITION'' );',
'}',
'',
'// Display value of P1_APPEARANCE',
'if ( isCustomTheme ) {',
'    output = apex.lang.getMessage( ''CA.CUSTOM_THEME'' );',
'    if (!isCustomUT) {',
'        // clear all feature choices',
'        $( "[name=''P1_FEATURES'']" ).prop( ''checked'', false );',
'        features$.hide();',
'        blueprintActions$.hide();',
'        ',
'    } else {',
'        features$.show();',
'        blueprintActions$.show();',
'    }',
'} else {',
'	$s( ''P1_THEME_TYPE'', ''UT'' );',
'    output = theme + '', '' + getNavDisp( nav ); ',
'    features$.show();',
'    blueprintActions$.show();',
'}',
'',
'// Set P1_APPEARANCE',
'$s( ''P1_APPEARANCE'', output );',
'',
'// Save the class to be reused on Page 1000',
'themeClass = tMapping[ theme ] || defaultThemeClass;',
'$s(''P1_THEME_STYLE_CLASS'', themeClass );',
'',
'// Update icon theme in "Pages" Region',
'page$',
'	.removeClass( page$.attr(''class'').split('' '').pop() )',
'	.addClass( themeClass );'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2647107076010258130.4024)
,p_name=>'Click Create Application Button'
,p_event_sequence=>60
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(2592727824404336994.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2647107184363258131.4024)
,p_event_id=>wwv_flow_api.id(2647107076010258130.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_api.id(2592727824404336994.4024)
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2647107202426258132.4024)
,p_event_id=>wwv_flow_api.id(2647107076010258130.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var lProgressTxt, lProgressPct, lLastProgressTxt, lLastProgressPct, lOverlay$,lMessage$, lComplete$,',
'    $ = apex.jQuery,',
'    statusUpdCnt = 0;',
'',
'$(window).scrollTop(0);',
'',
'function updatePageItems(items) {',
'    var i, item;',
'    for (i = 0; i < items.length; i++) {',
'        item = items[i];',
'        $s(item.id, item.value, null, true );',
'    }',
'}',
'',
'var createApp = apex.server.process("createApplication", {',
'    pageItems:["P1_STATUS","P1_APP_ID","P1_APP_NAME","P1_SCHEMA","P1_PRIMARY_LANGUAGE","P1_AUTHENTICATION","P1_FEATURES","P1_TRANSLATED_LANGS"]',
'',
'});',
'',
'// add overlay',
'var lHtml =',
'    ''<div class="a-PWWait-overlay" id="progress_overlay" role="progressbar" aria-busy="true" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" tabindex="-1">''+',
'        ''<div class="a-PWWait-body">''+',
'            ''<div class="a-PWWait-progress">''+',
'                ''<span class="a-PWWait-bar" id="pct_complete"></span>''+',
'            ''</div>''+',
'        ''<div class="a-PWWait-label" id="progress_messages"></div>''+',
'    ''</div>'';',
'',
'$("body").append( lHtml );',
'',
'lOverlay$ = $( ''#progress_overlay'' );',
'lMessage$ = $( ''#progress_messages'', lOverlay$ );',
'lComplete$ = $( ''#pct_complete'', lOverlay$ );',
'',
'// set focus to overlay, this gives better results with screen readers in announcing the progress',
'lOverlay$.focus();',
'',
'createApp.done(function(data) {',
'    if (data && data.items) {',
'        updatePageItems(data.items);',
'    }',
'    currentStatus = $v("P1_STATUS");',
'',
'    if (currentStatus===''DONE'') {',
'        setTimeout(function(){ apex.submit(''CREATE_APP''); }, 500);',
'    } else {',
'        if (currentStatus===''ERROR'') {',
'            apex.submit(''CREATE_APP_ERROR'');',
'        } else {',
'            apex.submit(''CREATE_APP_ORA_ERROR'');',
'        }',
'    }',
'});',
'',
'function waitForStatus() {',
'    setTimeout(function(){',
'        statusUpdCnt = statusUpdCnt + 1;',
'',
'        var getCurrent = apex.server.process("getCurrentStatus", {',
'            pageItems:["P1_PCT_COMPLETE"]',
'        });',
'',
'        getCurrent.done(function(data) {',
'            var currentStatus;',
'',
'            if (data && data.items) {',
'                updatePageItems(data.items);',
'            }',
'',
'            lLastProgressTxt = lProgressTxt;',
'            lLastProgressPct = lProgressPct;',
'',
'            currentStatus = $v("P1_STATUS");',
'            lProgressTxt = $v("P1_CURRENT_STATUS");',
'            lProgressPct = $v("P1_PCT_COMPLETE");',
'',
'            if ((currentStatus!==''DONE'')&&(statusUpdCnt<20)) {',
'',
'                if ((currentStatus===''ERROR'')||(currentStatus===''ORA_ERROR'')) {',
'                    console.log("Error creating application...");',
'                } else {',
'                    waitForStatus();',
'',
'                    // Only update text if text has changed',
'                    if ( lLastProgressTxt !== lProgressTxt ) {',
'                        lMessage$.text( lProgressTxt );',
'                        lOverlay$.attr( ''aria-valuetext'', lProgressTxt );',
'                    }',
'',
'                    // Only update percent complete if it has changed',
'                    if ( lLastProgressPct !== lProgressPct ) {',
'                        lComplete$.css("width",lProgressPct + ''%'');',
'                        lOverlay$.attr( ''aria-valuenow'', lProgressPct );',
'                    }',
'                }',
'            } else {',
'                lMessage$.text($v("P1_CURRENT_STATUS"));',
'                lComplete$.css("width",''100%'');',
'                lOverlay$',
'                    .attr( ''aria-valuenow'', $v("P1_PCT_COMPLETE"))',
'                    .attr( ''aria-valuetext'', ''100'');',
'            }',
'        });',
'    },500);',
'}',
'',
'waitForStatus();',
''))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2816374247679877703.4024)
,p_name=>'Toggle All Features'
,p_event_sequence=>70
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(2816364410490843901.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2816374331769877704.4024)
,p_event_id=>wwv_flow_api.id(2816374247679877703.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var flag = apex.create_app_wizard.all_feature_checked;',
'',
'(function( $ ){',
'var c$ = $("[name=''P1_FEATURES'']");',
'	if ( typeof flag === ''undefined'' || !flag ) {',
'		c$.prop(''checked'', true);',
'	    apex.create_app_wizard.all_feature_checked = true;',
'	} else {',
'		c$.prop(''checked'', false);',
'		apex.create_app_wizard.all_feature_checked = false;',
'	}',
'})( apex.jQuery );'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2796575266245751036.4024)
,p_name=>'View Blueprint'
,p_event_sequence=>100
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'#view_blueprint'
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2796575328637751037.4024)
,p_event_id=>wwv_flow_api.id(2796575266245751036.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>'null;'
,p_attribute_02=>'P1_FEATURES,P1_THEME_STYLE,P1_NAV_POSITION,P1_APP_NAME,P1_AUTHENTICATION'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3055104896529555207.4024)
,p_name=>'Update Supporting Objects'
,p_event_sequence=>110
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(2796574865702751032.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3055104988372555208.4024)
,p_event_id=>wwv_flow_api.id(3055104896529555207.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1_SUPPORTING_OBJS'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>'select dbms_lob.substr(clob001,30,1) x from apex_collections where collection_name = ''APEX$CREATEAPPSUPPOBJ'''
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3772243895156101805.4024)
,p_name=>'sync ref integ info'
,p_event_sequence=>120
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1_SCHEMA'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3772243971417101806.4024)
,p_event_id=>wwv_flow_api.id(3772243895156101805.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>'wwv_flow_cons_sync.sync_schema_if_changed (p_schema=> :P1_SCHEMA);'
,p_attribute_02=>'P1_SCHEMA'
,p_wait_for_result=>'Y'
,p_da_action_comment=>'sync data dictionary info'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2594843814366086027.4024)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'initialize the wizard'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_define_app_v3.init_wizard;',
''))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'NEW'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(4032943314209342949.4024)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add pages from script result'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_define_app_v3.add_page_from_script(',
'    p_schema             => :P1_SCHEMA,',
'    p_script_result_id   => :P1_SCRIPT_RESULT_ID );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>':P1_SCRIPT_RESULT_ID is not null and :REQUEST = ''NEW'''
,p_process_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(69711448639469935.4024)
,p_process_sequence=>40
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add pages from script file'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_define_app_v3.add_page_from_script(',
'    p_schema  => coalesce( :P1_SCHEMA, wwv_flow_user_api.get_default_schema),',
'    p_file_id => :P1_SCRIPT_FILE_ID );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>':P1_SCRIPT_FILE_ID is not null and :REQUEST = ''NEW'''
,p_process_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1699344666214124.4024)
,p_process_sequence=>60
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add pages with new table'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_define_app_v3.add_page_with_new_table(',
'    p_schema     => :P1_SCHEMA,',
'    p_table_name => :P1_NEW_TABLE_NAME,',
'    -- out',
'    p_app_name   => :P1_APP_NAME );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>':P1_NEW_TABLE_NAME is not null and :REQUEST = ''NEW'''
,p_process_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(33865293426899628.4024)
,p_process_sequence=>70
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add pages from sample JSON'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_define_app_v3.add_page_from_sample_json(',
'    p_json_id               => :p1_sample_json_id,',
'    p_built_with_love       => :p5_built_with_love,',
'    p_learn_app_def         => :p5_learn_ui_def_yn,',
'    p_app_name              => :p1_app_name,',
'    p_app_short_desc        => :p5_app_short_desc,',
'    p_app_desc              => :p5_app_desc,',
'    p_features              => :p1_features,',
'    p_theme_style           => :p170_theme_style,',
'    p_nav_position          => :p170_nav_position,',
'    p_app_icon_class        => :p1_app_icon_class,',
'    p_app_color_class       => :p1_app_color_class,',
'    p_app_color_hex         => :p1_app_color_hex,',
'    p_base_table_prefix     => :p5_base_table_prefix,',
'    p_primary_language      => :p1_primary_language,',
'    p_translated_langs      => :p1_translated_langs,',
'    p_authentication        => :p1_authentication,',
'    p_app_version           => :p5_app_version,',
'    p_app_logging           => :p5_app_logging,',
'    p_app_debugging         => :p5_app_debugging,',
'    p_document_direction    => :p5_document_direction,',
'    p_date_format           => :p5_date_format,',
'    p_date_time_format      => :p5_date_time_format,',
'    p_timestamp_format      => :p5_timestamp_format,',
'    p_timestamp_tz_format   => :p5_timestamp_tz_format,',
'    p_deep_linking          => :p5_deep_linking,',
'    p_max_session_length    => :p5_max_session_length,',
'    p_max_session_idle_time => :p5_max_session_idle_time );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>':P1_SAMPLE_JSON_ID is not null and :REQUEST = ''NEW'''
,p_process_when_type=>'PLSQL_EXPRESSION'
);
end;
/
begin
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2025750408723536749.4024)
,p_process_sequence=>10
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sortPage'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_internal_page_id number;',
'    l_page_id        number         := apex_application.g_x01;',
'    l_moves_count    number         := apex_application.g_x02;',
'    l_action         varchar2(10)   := apex_application.g_x03;',
'    ',
'begin',
'    l_internal_page_id := wwv_flow_define_app_v3.get_internal_page_id( p_page_id => l_page_id );',
'    ',
'    if l_action = ''up'' then',
'    ',
'        for i in 1..l_moves_count',
'        loop',
'           wwv_flow_define_app_v3.move_page_up( p_page_id => l_page_id );',
'           l_page_id := wwv_flow_define_app_v3.get_page_id( p_internal_page_id => l_internal_page_id );',
'        end loop;',
'        sys.htp.p( ''{"moved_up":'' || l_moves_count ||''}'');',
'',
'    elsif l_action = ''down'' then',
'    ',
'        for j in 1..l_moves_count',
'        loop',
'           wwv_flow_define_app_v3.move_page_down( p_page_id => l_page_id );',
'           l_page_id := wwv_flow_define_app_v3.get_page_id( p_internal_page_id => l_internal_page_id );',
'        end loop;',
'        sys.htp.p( ''{"moved_down":'' || l_moves_count ||''}'');',
'        ',
'    end if;',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_comment=>'Called in JavaScript apex.create_app_wizard.pageSort() to allow user to drag and drop to sort pages.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(63351383807934410.4024)
,p_process_sequence=>20
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'createApplication'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_theme  wwv_flow_create_app_v3.t_theme;',
'begin',
'    l_theme.theme_type  := coalesce(:P1_THEME_TYPE, ''UT'');',
'    l_theme.id          := :P1_THEME_ID;',
'    l_theme.theme_style := :P1_THEME_STYLE;',
'    ',
'    wwv_flow_create_app_v3.create_app (',
'        p_app_id                   => :P1_APP_ID,',
'        p_app_name                 => :P1_APP_NAME,',
'        p_parsing_schema           => :P1_SCHEMA,',
'        p_app_language             => :P1_PRIMARY_LANGUAGE,',
'        p_theme                    => l_theme,',
'        p_authentication_name      => nvl(:P1_AUTHENTICATION, wwv_flow_authentication_api.c_type_apex_accounts),',
'        p_base_table_prefix        => :P5_BASE_TABLE_PREFIX,',
'        p_features                 => :P1_FEATURES,',
'        p_translated_langs         => :P1_TRANSLATED_LANGS,',
'        -- appearance',
'        p_nav_position             => :P1_NAV_POSITION, -- nvl(:P170_NAV_POSITION, :P1_NAV_POSITION),',
'        p_app_icon_class           => :P1_APP_ICON_CLASS, -- nvl(:P170_APP_ICON_CLASS, :P1_APP_ICON_CLASS),',
'        p_app_color_class          => :P1_APP_COLOR_CLASS, -- nvl(:P170_APP_COLOR_CLASS, :P1_APP_COLOR_CLASS),',
'        p_app_icon_color_hex       => :P1_APP_COLOR_HEX, -- nvl(:P170_APP_COLOR_HEX, :P1_APP_COLOR_HEX),',
'        -- advanced general',
'        p_built_with_love          => ( nvl(:P5_BUILT_WITH_LOVE, ''N'') = ''Y'' ),',
'        p_learn_app_def            => ( nvl(:P5_LEARN_UI_DEF_YN, ''N'') = ''Y'' ),',
'        p_learn_existing_apps      => ( nvl(:P5_LEARN_YN,''N'') = ''Y'' ),',
'        p_seed_from_app_id         => :P5_SEED_FROM_APP,',
'        p_short_description        => :P5_APP_SHORT_DESC,',
'        p_long_description         => :P5_APP_DESC,',
'        p_app_version              => :P5_APP_VERSION,',
'        p_app_logging              => ( coalesce(:P5_APP_LOGGING, ''Y'') = ''Y'' ),',
'        p_app_debugging            => ( coalesce(:P5_APP_DEBUGGING, ''Y'') = ''Y'' ),',
'        -- advanced security',
'        p_deep_linking             => ( coalesce(:P5_DEEP_LINKING, ''N'') = ''Y'' ),',
'        p_max_session_length_sec   => :P5_MAX_SESSION_LENGTH,',
'        p_max_session_idle_sec     => :P5_MAX_SESSION_IDLE_TIME,',
'        -- advanced globalization',
'        p_document_direction       => coalesce(:P5_DOCUMENT_DIRECTION, ''N''),',
'        p_date_format              => :P5_DATE_FORMAT,',
'        p_date_time_format         => :P5_DATE_TIME_FORMAT,',
'        p_timestamp_format         => :P5_TIMESTAMP_FORMAT,',
'        p_timestamp_tz_format      => :P5_TIMESTAMP_TZ_FORMAT );',
'',
'    htmldb_util.clear_app_cache(',
'        p_app_id => :P1_APP_ID);',
'',
'    if wwv_flow_error.have_errors_occurred then',
'        wwv_flow_debug.info(''... create_app input validation failed'');',
'        apex_json.open_object;',
'        apex_json.open_array(''items'');',
'        apex_json.open_object;',
'        apex_json.write(''id'', ''P1_STATUS'');',
'        apex_json.write(''value'', ''ERROR'');',
'        apex_json.close_object;',
'        apex_json.open_object;',
'        apex_json.write(''id'', ''P1_ERROR_MESSAGE'');',
'        apex_json.write(''value'', ''Error creating application.'');',
'        apex_json.close_object;',
'        apex_json.close_array;',
'        apex_json.close_object;',
'',
'    else',
'        apex_json.open_object;',
'        apex_json.open_array(''items'');',
'        apex_json.open_object;',
'        apex_json.write(''id'', ''P1_STATUS'');',
'        apex_json.write(''value'', ''DONE'');',
'        apex_json.close_object;',
'        apex_json.close_array;',
'        apex_json.close_object;',
'    end if;',
'',
'exception',
'    when others then',
'        apex_json.open_object;',
'        apex_json.open_array(''items'');',
'        apex_json.open_object;',
'        apex_json.write(''id'', ''P1_STATUS'');',
'        apex_json.write(''value'', ''ORA_ERROR'');',
'        apex_json.close_object;',
'        apex_json.open_object;',
'        apex_json.write(''id'', ''P1_ERROR_MESSAGE'');',
'        apex_json.write(''value'', sqlerrm||'' ''||sys.dbms_utility.format_error_backtrace);',
'        apex_json.close_object;',
'        apex_json.close_array;',
'        apex_json.close_object;',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(63351586647934412.4024)
,p_process_sequence=>30
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'getCurrentStatus'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_percent_comp    number;',
'    l_last_event_name varchar2(4000);',
'',
'begin',
'',
'    wwv_flow_create_app_log_v3.get_progress(',
'        p_last_event_name  => l_last_event_name,',
'        p_percent_complete => l_percent_comp ',
'    );',
'',
'    apex_json.open_object;',
'    apex_json.open_array(''items'');',
'    apex_json.open_object;',
'    apex_json.write(''id'', ''P1_CURRENT_STATUS'');',
'    apex_json.write(''value'', wwv_flow_lang.custom_runtime_message(l_last_event_name));',
'    apex_json.close_object;',
'    apex_json.open_object;',
'    apex_json.write(''id'', ''P1_PCT_COMPLETE'');',
'    apex_json.write(''value'', trunc(l_percent_comp));',
'    apex_json.close_object;',
'    apex_json.close_array;',
'    apex_json.close_object;',
'end;',
'  '))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_api.create_page(
 p_id=>2.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Applicazione creata con errori'
,p_step_title=>'Applicazione creata con errori'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>wwv_flow_api.id(3286599848719423369.4024)
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2878225923368187963.4024)
,p_plug_name=>'Errore durante l''installazione degli oggetti di supporto'
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--wizard'
,p_plug_template=>wwv_flow_api.id(3330277939666606656.4024)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NOT_EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_collections',
'where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P1_APP_ID',
'and c001 = ''PREREQ_CHECK'''))
,p_plug_header=>unistr('L''applicazione \00E8 stata creata, ma l''installazione degli oggetti di database e dei seeddata non \00E8 riuscita.')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(2878624699511257302.4024)
,p_name=>'Riepilogo installazione oggetti di supporto'
,p_parent_plug_id=>wwv_flow_api.id(2878225923368187963.4024)
,p_template=>wwv_flow_api.id(2983766147992137991.4024)
,p_display_sequence=>40
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_region_attributes=>'style="margin-top:16px"'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001 script_name, ',
'       decode(c002, ''SUCCESS'', ',
'                    wwv_flow_lang.system_message(''INSTALLER.SCRIPT.SUCCESS''),',
'                    ''FAIL'',',
'                    wwv_flow_lang.system_message(''INSTALLER.SCRIPT.FAIL'')) status,        ',
'       to_number(nvl(c003,0)) fail_count,',
'       to_number(nvl(c004,0)) success_count,',
'       c003 + c004 total_count',
'  from wwv_flow_collections',
' where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P1_APP_ID',
' and c001 != ''PREREQ_CHECK'''))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(2707641403506668051.4024)
,p_query_num_rows=>50
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'Nessun risultato di installazione trovato.'
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2878624700494257303.4024)
,p_query_column_id=>1
,p_column_alias=>'SCRIPT_NAME'
,p_column_display_sequence=>1
,p_column_heading=>'Nome script'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2878624845839257304.4024)
,p_query_column_id=>2
,p_column_alias=>'STATUS'
,p_column_display_sequence=>2
,p_column_heading=>'Stato'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2878624983291257305.4024)
,p_query_column_id=>3
,p_column_alias=>'FAIL_COUNT'
,p_column_display_sequence=>3
,p_column_heading=>'Errore di conteggio'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2878625003191257306.4024)
,p_query_column_id=>4
,p_column_alias=>'SUCCESS_COUNT'
,p_column_display_sequence=>4
,p_column_heading=>'Conteggio operazioni riuscite'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2878625138395257307.4024)
,p_query_column_id=>5
,p_column_alias=>'TOTAL_COUNT'
,p_column_display_sequence=>5
,p_column_heading=>'Conteggio totale'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2878625282128257308.4024)
,p_plug_name=>'Errori'
,p_parent_plug_id=>wwv_flow_api.id(2878225923368187963.4024)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(2983766147992137991.4024)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select c001 script_name, clob001 errors ',
'           from wwv_flow_collections ',
'           where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P1_APP_ID',
'           and c001 != ''PREREQ_CHECK''',
'           and length(clob001) > 0)',
'loop',
'  sys.htp.p(''<b>''||wwv_flow_escape.html(c1.script_name)||''</b>'');',
'  sys.htp.p(''<pre>'');',
'  wwv_flow_sw_script.escape_sc_clob(c1.errors);',
'  sys.htp.p(''</pre>'');',
'end loop;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2878226271378193901.4024)
,p_plug_name=>'Controllo dei prerequisiti non riuscito'
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--wizard'
,p_plug_template=>wwv_flow_api.id(3330277939666606656.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_collections',
'where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P1_APP_ID',
'and c001 = ''PREREQ_CHECK'''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2878624552166257301.4024)
,p_plug_name=>'Errori'
,p_parent_plug_id=>wwv_flow_api.id(2878226271378193901.4024)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3286693190338347807.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select c001 script_name, clob001 errors ',
'           from wwv_flow_collections ',
'           where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P1_APP_ID',
'           and c001 = ''PREREQ_CHECK''',
'           and length(clob001) > 0)',
'loop',
'    -- note: populates message is formatted with HTML tag if prerequisite check fails, don''t escape',
'    sys.htp.p( c1.errors );',
'end loop;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2796572679532751010.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(2878225923368187963.4024)
,p_button_name=>'GO_TO_APP'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Passa all''applicazione'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2881063456729709562.4024)
,p_branch_name=>'Redirect to Application Home'
,p_branch_action=>'f?p=4000:1:&SESSION.::&DEBUG.:RP:FB_FLOW_ID,F4000_P1_FLOW:&P1_APP_ID.,&P1_APP_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(2796572679532751010.4024)
,p_branch_sequence=>20
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Impostazioni avanzate'
,p_page_mode=>'MODAL'
,p_step_title=>'Impostazioni avanzate'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.field.item-app-name {margin-bottom:0;}',
'.field--style--boxed .display_only {',
'    line-height: 24px;',
'}',
'.apex-col .field.field-item-button-grouping {',
'    margin-right: -1px;',
'}',
'.lang-button {',
'    padding-top: 19px;',
'    padding-bottom: 19px;',
'    width: calc(100% - 16px);',
'    margin-right: 16px;',
'}',
'',
'.a-BoxedForms .field-item-button-grouping .field-input__wrap {',
'    border-radius: 2px 0 0 2px;',
'}'))
,p_step_template=>wwv_flow_api.id(3272976625713321802.4024)
,p_page_css_classes=>'a-PageWizard-page'
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3027829547778015556.4024)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2929370393401839435.4024)
,p_plug_name=>'Sicurezza'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(2758664310411868479.4024)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2929371486458839446.4024)
,p_plug_name=>'Globalizzazione'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(2758664310411868479.4024)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2940046733568003236.4024)
,p_plug_name=>'Impostazioni'
,p_region_name=>'general'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(2758664310411868479.4024)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3504377147071326201.4024)
,p_plug_name=>'Attributi interfaccia utente'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(2758664310411868479.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Copia gli attributi (ad esempio etichette, liste di valori, formati di visualizzazione e altro ancora) dalle altre applicazioni dell''area di lavoro e le applica a questa applicazione.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3504377748981326207.4024)
,p_plug_name=>'Descrizione'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(2758664310411868479.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11817120097807501405.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3025635143275097802.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(11817120097807501405.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3025635596494097804.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(11817120097807501405.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Salva modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3025635979593097804.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(11817120097807501405.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP:P900_HELP_SECTION:ADVANCED'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(33865152934899627.4024)
,p_name=>'P5_BUILT_WITH_LOVE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2940046733568003236.4024)
,p_item_default=>'N'
,p_prompt=>unistr('Aggiungi "Creato con APEX" al pi\00E8 di pagina')
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Quando l''impostazione \00E8 <b>Attivo</b>, Oracle Application Express aggiunge il testo "Creato con amore utilizzando Oracle APEX" al pi\00E8 di pagina di ogni pagina.')
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929369566225839427.4024)
,p_name=>'P5_APP_SHORT_DESC'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(3504377748981326207.4024)
,p_prompt=>'Descrizione breve'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(2698024775220408056.4024)
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Immettere il testo da visualizzare come sottotitolo, sotto il nome dell''applicazione, nella home page.</p>',
unistr('<p><em><strong>Nota:</strong> questa impostazione richiede la selezione della funzione <strong>Impostazioni applicazione</strong>. Se la funzione non \00E8 selezionata, il sottotitolo non verr\00E0 visualizzato.</em></p>'),
''))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929369611036839428.4024)
,p_name=>'P5_APP_DESC'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(3504377748981326207.4024)
,p_prompt=>'Descrizione'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(2698024775220408056.4024)
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Immettere il testo da visualizzare nella pagina <strong>Informazioni sull''applicazione</strong>, a cui \00E8 possibile accedere facendo clic sull''icona della Guida nella barra di navigazione.</p>  '),
unistr('<p><em><strong>Nota:</strong> questa impostazione richiede la selezione della funzione <strong>Pagine della Guida</strong>. Se la funzione non \00E8 selezionata, la pagina di informazioni non verr\00E0 generata.</em></p>'),
''))
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929370594430839437.4024)
,p_name=>'P5_DEEP_LINKING'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(2929370393401839435.4024)
,p_item_default=>'N'
,p_prompt=>'Deep link'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_css_classes=>'item-app-name'
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Questo attributo consente o impedisce di specificare deep link a un''applicazione. Opzioni disponibili:</p>',
'<ul>',
'<li><b>Abilitato</b>: l''URL di una pagina specifica reindirizza direttamente alla pagina, possibilmente dopo che l''utente ha eseguito il login.</li>',
'<li><b>Disabilitato</b>: se l''URL non contiene un ID sessione valido, &PRODUCT_NAME. reindirizza l''utente alla home page dell''applicazione.</li>',
'</ul>',
unistr('<p>Ad esempio, i browser spesso salvano gli URL di schede aperte e tentano di ripristinare le sessioni dopo il riavvio, causando pertanto la creazione di un deep link. \00C8 possibile che questo funzionamento non sia quello desiderato, ad esempio se un U')
||unistr('RL punta a una pagina che si trova all''interno di una procedura guidata a pi\00F9 passi. Se si seleziona Disabilitato, &PRODUCT_NAME. avvia una nuova sessione e reindirizza l''utente alla home page dell''applicazione.</p>'),
unistr('<p>\00C8 possibile ignorare questa impostazione dell''applicazione a livello di pagina.</p>')))
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929370739829839439.4024)
,p_name=>'P5_MAX_SESSION_LENGTH'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(2929370393401839435.4024)
,p_prompt=>'Lunghezza massima sessione in secondi'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'SECONDS'
,p_lov=>'.'||wwv_flow_api.id(3052299639682461644.4024)||'.'
,p_lov_display_null=>'YES'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Definisce per quanto tempo (in secondi) le sessioni possono essere attive ed essere utilizzate dall''applicazione.',
'',
'<ul>',
unistr('    <li>Immettere un numero positivo intero per definire per quanto tempo pu\00F2 rimanere attiva una sessione.</li>'),
'    <li>Immettere 0 se le sessioni devono rimanere attive all''infinito.</li>',
'    <li>Lasciare vuoto il valore per utilizzare la durata della sessione definita a livello di area di lavoro o di istanza.</li>',
'</ul>',
'<br />',
'',
unistr('La durata della sessione pu\00F2 essere sostituita dal job eseguito orario del database che elimina le sessioni pi\00F9 vecchie di 12 ore.')))
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929370850688839440.4024)
,p_name=>'P5_MAX_SESSION_IDLE_TIME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(2929370393401839435.4024)
,p_prompt=>unistr('Tempo massimo di inattivit\00E0 sessione in secondi')
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'SECONDS'
,p_lov=>'.'||wwv_flow_api.id(3052299639682461644.4024)||'.'
,p_lov_display_null=>'YES'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Il tempo di inattivit\00E0 sessione \00E8 il tempo che intercorre tra l''ultima richiesta di pagina e la richiesta successiva.'),
'<ul>',
unistr('    <li>Immettere un numero intero positivo per controllare il tempo di inattivit\00E0 per le sessioni utilizzate da questa applicazione.</li>'),
unistr('    <li>Impostare il valore su 0 per non eseguire alcun controllo del tempo di inattivit\00E0 della sessione.</li>'),
unistr('    <li>Lasciare il valore vuoto per utilizzare il tempo di inattivit\00E0 definito a livello di area di lavoro o di istanza.</li>'),
'</ul>'))
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929371132330839443.4024)
,p_name=>'P5_APP_VERSION'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(2940046733568003236.4024)
,p_item_default=>'Release 1.0'
,p_prompt=>'Versione'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(2698024775220408056.4024)
,p_help_text=>'<p>Immettere la versione dell''applicazione. La versione viene visualizzata per impostazione predefinita nella parte inferiore di ogni pagina.</p>'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929371618618839448.4024)
,p_name=>'P5_DOCUMENT_DIRECTION'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(2929371486458839446.4024)
,p_item_default=>'N'
,p_prompt=>'Direzione documento'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RIGHT-TO-LEFT'
,p_lov=>'.'||wwv_flow_api.id(560908550288645029.4024)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Impostare la direzione documento, da sinistra a destra o da destra a sinistra.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929371717725839449.4024)
,p_name=>'P5_DATE_FORMAT'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(2929371486458839446.4024)
,p_prompt=>'Formato data'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Determina il formato data da utilizzare nell''applicazione.</p>',
unistr('<p>Il formato data specificato verr\00E0 utilizzato per modificare l''impostazione di sessione di database <code>NLS_DATE_FORMAT</code> prima di visualizzare o sottomettere qualsiasi pagina nell''applicazione. Il valore pu\00F2 essere una stringa di valori che')
||unistr(' contiene un formato di visualizzazione data Oracle valido o un elemento a cui viene fatto riferimento con una sintassi di sostituzione. Se non viene specificato alcun valore, il formato data predefinito verr\00E0 derivato dalla sessione del database in ')
||'runtime.</p>',
'Esempi:',
'<ul>',
'<li><code>Mese GG, AAAA</code></li>',
'<li><code>&amp;MY_DATE_FORMAT.</code></li>',
'</ul>'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2929371865789839450.4024)
,p_name=>'P5_DATE_TIME_FORMAT'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(2929371486458839446.4024)
,p_prompt=>'Formato data/ora'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specificare il formato di data/ora da utilizzare nell''applicazione.</p>',
unistr('<p>\00C8 possibile fare riferimento al formato data/ora specificato in un''applicazione mediante la sintassi di sostituzione <code>&amp;APP_DATE_TIME_FORMAT.</code> oppure in PL/SQL mediante la funzione <code>v(''APP_DATE_TIME_FORMAT'')</code>. Questo attri')
||unistr('buto non modifica le impostazioni NLS. Il valore pu\00F2 essere una stringa di valori che contiene un formato di visualizzazione data Oracle valido o un elemento a cui viene fatto riferimento con una sintassi di sostituzione. Se non si specifica alcun va')
||unistr('lore per questo attributo, un riferimento a <code>APP_DATE_TIME_FORMAT</code> restituir\00E0 il formato di data della sessione di database NLS e il formato orario NLS.</p>'),
'Esempi:',
'<ul>',
'<li><code>Month DD, RRRR HH24:MI</code></li>',
'<li><code>&amp;MY_DATE_TIME_FORMAT.</code></li>',
'</ul>'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2940046641169003235.4024)
,p_name=>'P5_APP_DEBUGGING'
,p_is_required=>true
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(2940046733568003236.4024)
,p_item_default=>'Y'
,p_prompt=>'Debug'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_css_classes=>'item-app-name'
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Determina se la modalit\00E0 debug pu\00F2 essere abilitata mediante il browser. Sono disponibili le opzioni riportate di seguito.<p>'),
'<ul>',
unistr('<li><b>Attivo</b>: consente all''applicazione di abilitare la modalit\00E0 debug mediante il browser in runtime.</li>'),
unistr('<li><b>Non attivo</b>: non consente all''applicazione di abilitare la modalit\00E0 debug da un browser.</li>'),
'</ul>',
unistr('<p>L''esecuzione di un''applicazione in modalit\00E0 debug \00E8 utile durante la fase di sviluppo dell''applicazione. Per le applicazioni di produzione \00E8 tuttavia preferibile disattivare il debug per impedire la visualizzazione della logica dell''applicazione d')
||'a parte degli utenti.</p>',
unistr('<p>La modalit\00E0 debug pu\00F2 essere abilitata a livello di programmazione indipendentemente da questa impostazione.</p>'),
unistr('<p>Se l''applicazione viene eseguita dall''ambiente di sviluppo di &PRODUCT_NAME., la funzione di debug pu\00F2 essere sempre abilitata.</p>')))
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2940046874787003237.4024)
,p_name=>'P5_COMPATABILITY'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(2940046733568003236.4024)
,p_prompt=>unistr('Modalit\00E0 di compatibilit\00E0')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_default_auth_scheme varchar2(4000) := null;',
'begin',
'    if wwv_flow_authentication_dev.get_internal_authentication in (''CLOUD_IDM'', ''SSO'') then',
'        l_default_auth_scheme := wwv_flow_authentication_dev.get_internal_authentication;',
'    else',
'        l_default_auth_scheme := :PRODUCT_NAME;',
'    end if;',
'      ',
'    return l_default_auth_scheme;',
'end;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>'STATIC:5.1;5.1;,Default;DEFAULT'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_required_patch=>wwv_flow_api.id(2698024775220408056.4024)
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
unistr('Questo attributo controlla la modalit\00E0 di compatibilit\00E0 del motore di runtime di Oracle Application Express. Alcuni funzionamenti di runtime differiscono a seconda della release. Utilizzare questo attributo per ottenere il funzionamento specifico per')
||unistr(' l''applicazione. Per definire un nuovo funzionamento in un''applicazione, impostare la modalit\00E0 di compatibilit\00E0 dell''applicazione sulla versione corrente.'),
'</p>',
'<p>',
'Per i dettagli, vedere il capitolo ''Changed Behavior - Compatibility Mode'' nelle Note di rilascio.',
'</p>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3022411239924971763.4024)
,p_name=>'P5_APP_LOGGING'
,p_is_required=>true
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(2940046733568003236.4024)
,p_item_default=>'Y'
,p_prompt=>'Log'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_css_classes=>'item-app-name'
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
unistr('Determina se l''attivit\00E0 utente viene o meno registrata nel log attivit\00E0. Se impostato su <b>Attivo</b>, viene registrata ogni visualizzazione pagina, consentendo a un amministratore di controllare l''attivit\00E0 utente per ogni applicazione.<p/>'),
'<p>',
'Potrebbe essere utile disabilitare il log per applicazioni che prevedono l''utilizzo di grandi volumi di dati.',
'</p>',
'<p>',
unistr('\00C8 possibile modificare questo attributo solo se la configurazione della funzione "Log attivit\00E0 applicazione" nell''amministrazione interna &PRODUCT_NAME. \00E8 impostata su "Usa impostazioni applicazione".'),
'</p>'))
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3028031392407628902.4024)
,p_name=>'P5_TIMESTAMP_FORMAT'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(2929371486458839446.4024)
,p_prompt=>'Formato indicatore orario'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Determina il formato di indicatore orario da utilizzare nell''applicazione.</p>',
unistr('<p>Il formato di indicatore orario specificato verr\00E0 utilizzato per modificare l''impostazione di sessione di database <code>NLS_TIMESTAMP_FORMAT</code> prima di visualizzare o sottomettere qualsiasi pagina nell''applicazione. Il valore pu\00F2 essere una ')
||'stringa di valori che contiene un formato di visualizzazione di indicatore orario Oracle valido o un elemento a cui viene fatto riferimento con una sintassi di sostituzione. Se non viene specificato alcun valore, il formato di indicatore orario prede'
||unistr('finito verr\00E0 derivato dalla sessione del database in runtime.</p>'),
'Esempi:',
'<ul>',
'<li><code>DD-MON-RR HH.MI.SSXFF AM</code></li>',
'<li><code>&amp;MY_TIMESTAMP_FORMAT.</code></li>',
'</ul>'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3028031441279628903.4024)
,p_name=>'P5_TIMESTAMP_TZ_FORMAT'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(2929371486458839446.4024)
,p_prompt=>'Formato indicatore orario con fuso orario'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Determina il formato di indicatore orario con fuso orario da utilizzare nell''applicazione.</p>',
unistr('<p>Il formato di data specificato verr\00E0 utilizzato per modificare l''impostazione di sessione di database <code>NLS_TIMESTAMP_TZ_FORMAT</code> prima di visualizzare o sottomettere qualsiasi pagina nell''applicazione. Il valore pu\00F2 essere una stringa di')
||' valori che contiene un formato di visualizzazione di indicatore orario con fuso orario Oracle valido o un elemento a cui viene fatto riferimento con una sintassi di sostituzione. Se non viene specificato alcun valore, il formato di indicatore orario'
||unistr(' con fuso orario predefinito verr\00E0 derivato dalla sessione del database in runtime.</p>'),
'Esempi:',
'<ul>',
'<li><code>DD-MON-RR HH.MI.SSXFF AM TZR</code></li>',
'<li><code>&amp;MY_TIMESTAMP_TZ_FORMAT.</code></li>',
'</ul>'))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3398688067867765506.4024)
,p_name=>'P5_BASE_TABLE_PREFIX'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(3504377147071326201.4024)
,p_prompt=>'Prefissi tabelle'
,p_placeholder=>'HR_, OE_'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(2698024775220408056.4024)
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Immettere i prefissi di tabella utilizzati attualmente dalle tabelle di database esistenti su cui si basano le pagine. Questi prefissi possono essere diversi dai prefissi di tabella del framework (per gli oggetti di database creati da questa appli'
||'cazione al momento della generazione).</p>',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3504377278993326202.4024)
,p_name=>'P5_LEARN_YN'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(3504377147071326201.4024)
,p_item_default=>'N'
,p_prompt=>'Copia da applicazioni esistenti'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Selezionare <b>Attivo</b> se si desidera che le impostazioni predefinite degli attributi siano basate sulle pagine <u>Form</u> esistenti, basate sulla stessa tabella, nelle applicazioni correnti definite in questa area di lavoro.</p>',
unistr('<p>Ad esempio, se si dispone di un''applicazione con una pagina form basata su <code>APEX$DEMO_PROJ_TASKS</code> e si definisce un report sulla stessa tabella, se questa opzione \00E8 impostata su <b>Attivo</b> le impostazioni predefinite degli attributi ')
||'si baseranno sulle definizioni degli elementi della pagina form.</p>',
unistr('<p><em><strong>Nota:</strong> se esistono pi\00F9 pagine form basate sulla stessa tabella, verranno utilizzate le definizioni della pagina aggiornata pi\00F9 di recente.</em></p>')))
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3504378824056326218.4024)
,p_name=>'P5_SEED_FROM_APP'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(3504377147071326201.4024)
,p_prompt=>'Copia attributi da'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LIST FLOWS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'from   wwv_flow_visible_flows f',
'where  build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'')',
'order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'Tutte le applicazioni'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_required_patch=>wwv_flow_api.id(2698024775220408056.4024)
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questa applicazione per copiare i metadati.</p>',
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3504379001911326220.4024)
,p_name=>'P5_LEARN_UI_DEF_YN'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(3504377147071326201.4024)
,p_item_default=>'N'
,p_prompt=>'Applica impostazioni predefinite interfaccia utente'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Selezionare <b>Attivo</b> se si desidera che le impostazioni predefinite degli attributi siano basate sulle impostazioni predefinite dell''interfaccia utente esistenti in questa area di lavoro.</p>',
''))
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3035688212550083801.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3025635143275097802.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3035688338214083802.4024)
,p_event_id=>wwv_flow_api.id(3035688212550083801.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2934952434131675449.4024)
,p_name=>'if learn, show copy from app'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P5_LEARN_YN'
,p_condition_element=>'P5_LEARN_YN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2934952547911675450.4024)
,p_event_id=>wwv_flow_api.id(2934952434131675449.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P5_SEED_FROM_APP'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3674116303730496401.4024)
,p_event_id=>wwv_flow_api.id(2934952434131675449.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P5_SEED_FROM_APP'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3035688413773083803.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Copia pagina globale'
,p_step_title=>'Copia pagina globale'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466887446141424130.4024)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-sql-workshop'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466887648418424130.4024)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(3466887446141424130.4024)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3084812122292331529.4024)
,p_plug_name=>'APEX Tabs'
,p_parent_plug_id=>wwv_flow_api.id(3466887648418424130.4024)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(3078141213440643205.4024)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(3157523106769548315.4024)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466887818154424130.4024)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(3466887648418424130.4024)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466888021876424131.4024)
,p_plug_name=>'APEX 5 - Home Link'
,p_parent_plug_id=>wwv_flow_api.id(3466887648418424130.4024)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466888266773424131.4024)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(3466887446141424130.4024)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466888488049424131.4024)
,p_plug_name=>'APEX 5 - Search'
,p_parent_plug_id=>wwv_flow_api.id(3466888266773424131.4024)
,p_region_css_classes=>'a-Header-search'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-SearchBox a-SearchBox--noGoButton a-SearchBox--autoExpand a-SearchBox--fill">'');',
'sys.htp.p(''  <div class="a-SearchBox-field">'');',
'sys.htp.p(''    <span class="a-SearchBox-icon"><span class="a-Icon icon-search"></span></span>'');',
'sys.htp.p(''    <label for="P7_SEARCH" class="visuallyhidden">Search</label>'');',
'sys.htp.p(''    <input type="text" class="a-SearchBox-input" id="P7_SEARCH" placeholder="''||wwv_flow_lang.system_message(''WWV_FLOW_QUICK_FLOW.SEARCH'')||''">'');',
'sys.htp.p(''  </div>'');',
'sys.htp.p(''</div>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466888634143424131.4024)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_api.id(3466888266773424131.4024)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466924585174500138.4024)
,p_plug_name=>'APEX 5 - Administration Menu'
,p_parent_plug_id=>wwv_flow_api.id(3466888634143424131.4024)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>120
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(3078131037146643152.4024)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(3331503598779942021.4024)
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3564894574635944804.4024)
,p_plug_name=>'APEX 5 - Help Menu'
,p_parent_plug_id=>wwv_flow_api.id(3466888634143424131.4024)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>130
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(3078138630465643203.4024)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(3331503598779942021.4024)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466888827502424131.4024)
,p_plug_name=>'APEX 5 - Header Account'
,p_parent_plug_id=>wwv_flow_api.id(3466888266773424131.4024)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466889085283424132.4024)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-sql-workshop'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>90
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466889215487424132.4024)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_api.id(3466889085283424132.4024)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>100
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3466889487890424132.4024)
,p_plug_name=>'APEX 5 - Control Bar Right'
,p_parent_plug_id=>wwv_flow_api.id(3466889085283424132.4024)
,p_region_css_classes=>'a-ControlBar-col'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>110
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4508738035612474979.4024)
,p_plug_name=>'RESTful Service'
,p_region_name=>'sideTree'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_c1_cnt           pls_integer := 0;',
'  l_c2_cnt           pls_integer := 0;',
'  l_c3_cnt           pls_integer := 0;',
'  l_active_module    varchar2(20) := null;',
'  l_active_template  varchar2(20) := null;',
'  l_active_handler   varchar2(20) := null;',
'  l_active_new_temp  varchar2(20) := null;',
'  l_active_new_hand  varchar2(20) := null;',
'',
'begin',
'',
'  sys.htp.p(''<style>'');',
'  sys.htp.p(''#sideTree {width: 400px;}'');',
'  sys.htp.p(''#sideTree .rc-content-main {min-height: 600px;}'');',
'  sys.htp.p(''#apex-left-sidebar {width: 400px; margin-left: -410px;}'');',
'  sys.htp.p(''#apex-main {padding-left: 410px;}'');',
'  sys.htp.p(''</style>'');',
'  sys.htp.p(''<ul class="databaseServicesTree">'');',
'  ------------',
'  -- module',
'  --',
'  for c4 in ( select max(name) name from WWV_FLOW_RT$MODULES',
'                where id = :P10_ID',
'  ',
'  ) ',
'  loop',
'      l_c3_cnt := l_c3_cnt + 1;',
'      if :P10_ID = :ACTIVE_NODE then',
'          l_active_module := '' class="active"'';',
'      else',
'          l_active_module := null;',
'      end if;',
'      sys.htp.p(''<li''||l_active_module||''><a href="f?p=''||:app_id||'':10:''||:app_session||''::::P10_ID,ACTIVE_NODE:''||:P10_ID||'',''||:P10_ID||''" title="''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_NAME'')||'': ''||',
'                wwv_flow_escape.html(c4.name)||''" alt="''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_NAME'')||'': ''||',
'                wwv_flow_escape.html(c4.name)||''"><span class="visuallyhidden">''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_NAME'')||'':</span>''||',
'                wwv_flow_escape.html(c4.name)||''</a>'');',
'     ',
'      -- NEW',
'      sys.htp.p(''<ul>'');',
'      -- NEw  ',
'',
'      ------------',
'      -- templates',
'      -- ',
'      l_c1_cnt := 0;',
'      for c1 in (select id,',
'                        module_id,',
'                        uri_template,',
'                        priority,',
'                        etag_type,',
'                        etag_query,',
'                        created_by,',
'                        created_on,',
'                        updated_by,',
'                        updated_on,',
'                        (select max(uri_prefix) from WWV_FLOW_RT$MODULES m',
'                         where m.id = t.module_id) uri_prefix',
'                  from wwv_flow_rt$templates t',
'                 where module_id = :P10_ID',
'                   and security_group_id = :flow_security_group_id',
'                 order by uri_template)',
'      loop',
'          l_c1_cnt := l_c1_cnt + 1;',
'          if c1.id = :ACTIVE_NODE then',
'              l_active_template := '' active'';',
'          else',
'              l_active_template := null;',
'          end if;',
'          sys.htp.p(''<li class="method''||l_active_template||''"><a href="f?p=''||:app_id||'':11:''||:app_session||''::::P11_ID,ACTIVE_NODE:''||c1.id||'',''||c1.id||''" title="''||wwv_flow_lang.system_message(''DB_SERVICES_URI_TEMPLATE'')||'': ''||',
'                wwv_flow_escape.html(c1.uri_template)||''"><span class="visuallyhidden">''||wwv_flow_lang.system_message(''DB_SERVICES_URI_TEMPLATE'')||'':</span>''||wwv_flow_escape.html(c1.uri_template)||',
'              ''</a>'');',
'',
'          -- NEW',
'          sys.htp.p(''<ul>'');',
'          -- NEw',
'      ',
'          l_c2_cnt := 0;     ',
'          for c2 in (select id,',
'                            template_id,',
'                            source_type,',
'                            format,',
'                            method,',
'                            mimes_allowed,',
'                            items_per_page,',
'                            source,',
'                            created_by,',
'                            created_on,',
'                            updated_by,',
'                            updated_on',
'                     from wwv_flow_rt$handlers',
'                    where template_id = c1.id',
'                      and security_group_id = :flow_security_group_id',
'                    order by method)',
'          loop',
'              l_c2_cnt := l_c2_cnt + 1;',
'              if c2.id = :ACTIVE_NODE then',
'                  l_active_handler := '' active'';',
'              else',
'                  l_active_handler := null;',
'              end if;',
'/*              sys.htp.p(''<li class="parameter''||l_active_handler||''"><a href="f?p=''||:app_id||'':9:''||:app_session||'':::9:P9_ID,ACTIVE_NODE:''||c2.id||'',''||c2.id||''" title="''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER'')||'': ''||',
'                wwv_flow_escape.html(c2.method)||''" alt="''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER'')||'': ''||',
'                wwv_flow_escape.html(c2.method)||''">''||',
'                wwv_flow_escape.html(c2.method)||''</a></li>''); */',
'',
'               sys.htp.p(''<li class="parameter''||l_active_handler||''"><a href="f?p=''||:app_id||'':9:''||:app_session||'':::9:P9_ID,ACTIVE_NODE:''||c2.id||'',''||c2.id||''" title="''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER'')||'': ''||',
'                wwv_flow_escape.html(c2.method)||''" ><span class="visuallyhidden">''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER'')||'':</span>''||',
'                wwv_flow_escape.html(c2.method)||''</a></li>'');',
'               ',
'          end loop; -- c2 ',
'',
'          if :ACTIVE_NODE = 1 and :P9_TEMPLATE_ID = c1.id then',
'              l_active_new_hand := '' active'';',
'          else',
'              l_active_new_hand := null;',
'          end if;',
'',
'          sys.htp.p(''<li class="createLink parameter''||l_active_new_hand||''"><a href="f?p=''||:app_id||'':9:''||:app_session||',
'          '':::9:P9_TEMPLATE_ID,ACTIVE_NODE:''||c1.id||'',1" title="''||wwv_flow_lang.system_message(''db_services_create_handler'')||''" >''||wwv_flow_lang.system_message(''db_services_create_handler'')||''</a></li>'');',
'',
'--NEW',
'          sys.htp.p(''</ul>'');',
'          sys.htp.p(''</li>'');',
'--NEW',
'      end loop; -- c1',
'  ',
'      if :ACTIVE_NODE = 2 then',
'          l_active_new_temp := '' active'';',
'      else',
'          l_active_new_temp := null;',
'      end if;',
'',
'      sys.htp.p(''<li class="createLink method''||l_active_new_temp||''"><a href="f?p=''||:app_id||'':11:''||:app_session||',
'                '':::11:P11_MODULE_ID,ACTIVE_NODE:''||:P10_ID||'',2" title="''||wwv_flow_lang.system_message(''db_services_create_template'')||''" >''||wwv_flow_lang.system_message(''db_services_create_template'')||''</a></li>'');',
'',
'--NEW ',
'      sys.htp.p(''</ul>'');',
'      sys.htp.p(''</li>'');',
'--NEW',
'  end loop; -- c4',
'  sys.htp.p(''</ul>'');',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_IN_CONDITION'
,p_plug_display_when_condition=>'9,10,11,12'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4730218113997311298.4024)
,p_plug_name=>'Esempio'
,p_region_template_options=>'#DEFAULT#:is-collapsed:a-Region--noPadding:a-Region--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3273871575473525717.4024)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.prn(''<br /><b>''||wwv_flow_lang.system_message(''DB_SERVICES_URI'')||''</b>'');',
'sys.htp.prn(''<pre>'');',
'sys.htp.prn(''hr/employees/{ID}''||chr(10));',
'sys.htp.prn(''|_|_________|____|''||chr(10));',
'sys.htp.prn('' |     |      |''||chr(10));',
'sys.htp.prn('' |     |       -''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER_BIND_VARIABLE'')||chr(10));',
'sys.htp.prn('' |     | ''||chr(10));',
'sys.htp.prn('' |      - ''||wwv_flow_lang.system_message(''DB_SERVICES_TEMPLATE_URI'')||chr(10));',
'sys.htp.prn('' |''||chr(10));',
'sys.htp.prn(''  - ''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_URI'')||chr(10));',
'sys.htp.prn('' </pre>'');',
'',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_MODULE_NAME'')||''</b>'');',
'sys.htp.prn(''<pre>oracle.example.hr</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_URI_PRIFIX'')||''</b>'');',
'sys.htp.prn(''<pre>hr/</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_TEMPLATE_URI'')||''</b>'');',
'sys.htp.prn(''<pre>employees/{ID}</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER_METHOD'')||''</b>'');',
'sys.htp.prn(''<pre>GET</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER_SRC_TYPE'')||''</b>'');',
'sys.htp.prn(''<pre>Query One Row</pre>'');',
'sys.htp.prn(''<br/><b>''||wwv_flow_lang.system_message(''DB_SERVICES_HANDLER_SOURCE'')||''</b>'');',
'sys.htp.prn(''<pre>select EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO                 ',
' from EMP where EMPNO = :ID</pre>'');',
'sys.htp.prn(''<br/><b>JSON</b><br/>'');',
'sys.htp.prn(''<pre>'');',
'sys.htp.prn(''{"items":[{"empno":7839,"ename":"KING","job":"PRESIDENT","hiredate":"1981-11-17T08:00:00Z"<br/>'');',
'sys.htp.prn('',"sal":5000,"deptno":10}]}'');',
'sys.htp.prn(''</pre>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_IN_CONDITION'
,p_plug_display_when_condition=>'3,10,11'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078124046517643108.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(3466888021876424131.4024)
,p_button_name=>'Home'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Home'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4500:1000:&SESSION.::&DEBUG.::::'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-home'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078129494285643138.4024)
,p_button_sequence=>10
,p_button_name=>'Home'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Home'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4500:1000:&SESSION.::&DEBUG.::::'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-home'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078125339636643113.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(3466888634143424131.4024)
,p_button_name=>'Administration'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2583919293963280507.4024)
,p_button_image_alt=>'Amministrazione'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078129867897643139.4024)
,p_button_sequence=>20
,p_button_name=>'Administration'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2583919293963280507.4024)
,p_button_image_alt=>'Amministrazione'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078125768837643114.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(3466888634143424131.4024)
,p_button_name=>'Feedback'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Feedback'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078130241691643139.4024)
,p_button_sequence=>30
,p_button_name=>'Feedback'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Feedback'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078126180089643114.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(3466888634143424131.4024)
,p_button_name=>'Help'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2583919293963280507.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3078130670977643139.4024)
,p_button_sequence=>40
,p_button_name=>'Help'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2583919293963280507.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
end;
/
prompt --application/pages/page_00110
begin
wwv_flow_api.create_page(
 p_id=>110.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Seleziona icona'
,p_page_mode=>'MODAL'
,p_step_title=>'Seleziona icona'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/* Init Modal */',
'initWizardModal = function() {',
'    function _initDialog() {',
'        var headerheight = $(''.a-Dialog-wizardSteps'').height(),',
'            footerheight = $(''.a-Dialog-footer'').height();',
'        $(''.a-Dialog-body'').css({',
'            ''top'':headerheight,',
'            ''bottom'':footerheight',
'        });',
'    }',
'    $(window).bind(''apexwindowresized'', function() {',
'        _initDialog();',
'    });',
'    _initDialog();',
'};',
'',
'',
'apex.create_app_wizard = apex.create_app_wizard || {};',
'',
'(function( $ ){',
'',
'	var icons = {},',
'		iconCont$;',
'',
'	var getIcons = function (){',
'        var data = {},',
'            links$ = $( ''a.a-PWIconPicker-link'' );',
'',
'        links$.each(function( index ) {',
'            var that$ = $( this )',
'            data[ that$.attr( ''id'' ) ] = that$.data( ''filters'' );',
'        });',
'',
'        return data;',
'    };',
'',
'    var search = function( key ){',
'    	var key = key.trim().toLowerCase(),',
'    		keyLen = key.length;',
'',
'    	var resetList = function(){',
'    		iconCont$',
'    			.removeClass( ''js-searching'' )',
'    			.find( ''.js-hit'' )',
'    			.removeClass( ''js-hit'' );',
'    	};',
'',
'    	resetList();',
'',
'    	if ( key.length >= 2 ) {',
'',
'    		iconCont$.addClass( ''js-searching'' );',
'',
'	    	for ( var k in icons ) {',
'	    		if ( icons.hasOwnProperty(k) ) {',
'	    			if ( k.indexOf( key ) != -1 || icons[k].indexOf( key ) != -1 ) {',
'	    				$( ''#'' + k )',
'	    					.parent()',
'	    					.addClass( ''js-hit'' );',
'	    			}',
'	    		}',
'	    	}',
'    	}',
'    };',
'',
'    var passBack = function( icon, passToUi, passToSave ) {',
'        ',
'        var jQueryInOtherDialog$ = parent.window.frames[0].apex.jQuery,',
'        	iconSpan$ = jQueryInOtherDialog$( ''#'' + passToUi ).find( ''span.a-Icon'' ),',
'        	lastClass = iconSpan$.attr(''class'').split('' '').pop();',
'',
'        iconSpan$',
'            .removeClass( lastClass )',
'            .addClass( ''fa '' + icon );',
'',
'        jQueryInOtherDialog$( ''#'' + passToSave ).val( icon );',
'        apex.util.getTopApex().navigation.dialog.cancel(true);',
'    };',
'',
'	apex.create_app_wizard.initIconSearch = function( options ){',
'',
'		icons = getIcons(),',
'',
'		iconCont$ = $( ''#'' + options.container || ''icons'' );',
'',
'		iconCont$.on( ''click'', ''a.a-PWIconPicker-link'', function(){',
'	        var iconName = $( this ).attr( ''id'' );',
'	        passBack( iconName, options.passToUi, options.passToSave );',
'	    } );',
'	    ',
'	    $( ''#'' + options.searchField ).on( ''keyup'', function(){',
'	    	var k = this.value;',
'		    setTimeout(function() {',
'	        	search( k );',
'	        }, 500);',
'	    })',
'	};',
'',
'})( apex.jQuery );'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'initWizardModal();',
'',
'apex.create_app_wizard.initIconSearch({',
'    "container":     "icons",',
'    "searchField":   "P110_SEARCH",',
'    "passToUi":      "&P110_PASS_BACK_TO_UI.",',
'    "passToSave":    "&P110_PASS_BACK_TO_SAVE."',
'});'))
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.js-searching li {',
'    display: none;',
'}',
'',
'.js-searching li.js-hit {',
'    display: block;',
'}'))
,p_page_css_classes=>'a-PageWizard-dialog a-PageWizard-dialog--icons'
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'440'
,p_dialog_width=>'400'
,p_dialog_attributes=>'resizable:true'
,p_dialog_chained=>'N'
,p_browser_cache=>'Y'
,p_cache_mode=>'CACHE'
,p_cache_timeout_seconds=>21600
,p_page_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#themes/theme_42/1.1/demo/demo#MIN#.js',
'#IMAGE_PREFIX#themes/theme_42/1.1/js/demo/icons#MIN#.js'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2025750057378536745.4024)
,p_plug_name=>'Barra di ricerca'
,p_region_css_classes=>'a-PWIconPicker-search'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2647104751646258107.4024)
,p_plug_name=>'Lista icone - PLSQL'
,p_region_name=>'icons'
,p_region_css_classes=>'icon-list'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'    sys.htp.p( ''<ul class="a-PWIconPicker">'' );',
'    ',
'    for c1 in ( ',
'        select icon_name, icon_filters',
'          from wwv_flow_standard_icons',
'         where icon_library = ''FONTAPEX''',
'         order by icon_name )',
'    loop',
'',
'        sys.htp.p( ''<li class="a-PWIconPicker-item"><a href="javascript:void(0)" class="a-PWIconPicker-link" id="'' || c1.icon_name || ''" data-filters="'' || c1.icon_filters || ''">''',
'                    || ''<span class="t-Icon fa '' || c1.icon_name || ''" aria-hidden="true"></span>''',
'                    || ''</a></li>'' );',
'    end loop;',
'    ',
'    sys.htp.p( ''</ul>'' );',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_caching=>'CACHE'
,p_plug_caching_max_age_in_sec=>21600
,p_plug_cache_depends_on_items=>'APP_REQUEST_DATA_HASH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2025750167049536746.4024)
,p_name=>'P110_SEARCH'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(2025750057378536745.4024)
,p_prompt=>'Icone di ricerca'
,p_placeholder=>'Cerca in tutte e &P110_COUNT. le icone...'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_tag_css_classes=>'a-PWIconPicker-searchInput'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2593478457378715617.4024)
,p_name=>'P110_SELECTED_ICON'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(2025750057378536745.4024)
,p_item_default=>'fa-cloud'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2647104883557258108.4024)
,p_name=>'P110_COUNT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2025750057378536745.4024)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*)',
' from wwv_flow_standard_icons',
'where icon_library = ''FONTAPEX'''))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2647105031292258110.4024)
,p_name=>'P110_PASS_BACK_TO_UI'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(2025750057378536745.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2647105144549258111.4024)
,p_name=>'P110_PASS_BACK_TO_SAVE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(2025750057378536745.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2595754895632422208.4024)
,p_name=>'Cancel Enter'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P110_SEARCH'
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'this.browserEvent.which === 13'
,p_bind_type=>'bind'
,p_bind_event_type=>'keypress'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2595754930833422209.4024)
,p_event_id=>wwv_flow_api.id(2595754895632422208.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CANCEL_EVENT'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2593478751056715620.4024)
,p_name=>'Close Dialog on Icon Selection'
,p_event_sequence=>20
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'.a-PWIconPicker-link'
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
,p_display_when_type=>'NEVER'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2593478824500715621.4024)
,p_event_id=>wwv_flow_api.id(2593478751056715620.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
,p_attribute_01=>'P110_SELECTED_ICON'
);
end;
/
prompt --application/pages/page_00120
begin
wwv_flow_api.create_page(
 p_id=>120.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Scegli icona applicazione'
,p_page_mode=>'MODAL'
,p_step_title=>'Scegli icona applicazione'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$.fn.removeClassWithPrefix = function (prefix) {',
'  $(this).removeClass(function (index, className) {',
'    return (className.match(new RegExp("\\S*" + prefix + "\\S*", ''g'')) || []).join('' '')',
'  });',
'  return this;',
'};'))
,p_page_css_classes=>'a-PageWizard-dialog a-PageWizard-dialog--appIconPicker'
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'580'
,p_dialog_width=>'760'
,p_dialog_attributes=>'resizable:true'
,p_dialog_chained=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2595758406326422244.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2661566014835000912.4024)
,p_plug_name=>'Icone'
,p_region_name=>'app_icons_gallery'
,p_region_css_classes=>'a-PageWizard-appIcons &P1_APP_COLOR_CLASS.'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2661566271179000914.4024)
,p_plug_name=>'Anteprima icona'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<div id="app_icon_preview" class="a-PageWizard-appIcon a-PageWizard-appIcon--preview &P1_APP_COLOR_CLASS. &P1_APP_ICON_CLASS."></div>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2595758618998422246.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(2595758406326422244.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2595758599738422245.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(2595758406326422244.4024)
,p_button_name=>'SET_APP_ICON'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Imposta icona applicazione'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2647106546767258125.4024)
,p_name=>'P120_ICON_CLASS'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(2661566014835000912.4024)
,p_source=>'P1_APP_ICON_CLASS'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'B'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2661566112535000913.4024)
,p_name=>'P120_ICON_PICKER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(2661566014835000912.4024)
,p_prompt=>'Selettore icone'
,p_source=>'select replace( :P1_APP_ICON_CLASS, ''app-icon-'', null) as icon from dual;'
,p_source_type=>'QUERY'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.WIZARD_SELECTION'
,p_named_lov=>'P120_APP_ICONS'
,p_lov=>'.'||wwv_flow_api.id(2672360045214033881.4024)||'.'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_css_classes=>'a-IconList--AppIcons'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_protection_level=>'B'
,p_attribute_01=>'S'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2661569781624000949.4024)
,p_name=>'P120_ICON_COLOR'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2661566014835000912.4024)
,p_prompt=>'Colore icona'
,p_source=>'P1_APP_COLOR_HEX'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'P120_APP_COLORS'
,p_lov=>'.'||wwv_flow_api.id(2698004887684998460.4024)||'.'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_css_classes=>'a-PageWizard-appIconColorPicker'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_protection_level=>'B'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'8'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2698019345534126328.4024)
,p_name=>'P120_ICON_COLOR_CLASS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(2661566014835000912.4024)
,p_source=>'P1_APP_COLOR_CLASS'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'B'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2595758737946422247.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(2595758618998422246.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2595758864422422248.4024)
,p_event_id=>wwv_flow_api.id(2595758737946422247.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2698019626181126331.4024)
,p_name=>'Set Color on Page Load'
,p_event_sequence=>20
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2698019765387126332.4024)
,p_event_id=>wwv_flow_api.id(2698019626181126331.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'(function( $ ){',
'    var iconColor = $v(''P120_ICON_COLOR_CLASS'');    ',
'    ',
'    $("#P120_ICON_COLOR span.app-color").each(function(){',
'      var curItem$ = $(this);',
'      if (curItem$.hasClass( iconColor )) {',
'        curItem$.parent().prev().prop("checked",true);',
'      }',
'    });',
'',
'})( apex.jQuery );'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2698019869993126333.4024)
,p_name=>'Change Color'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P120_ICON_COLOR'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2698019975244126334.4024)
,p_event_id=>wwv_flow_api.id(2698019869993126333.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'(function( $, that ){',
'    var colorClass = $(that.triggeringElement).find("input[type=''radio'']:checked + label span").attr("class").split(" ").pop();',
'    ',
'    /*',
'    $("#app_icon_preview")',
'        .removeClassWithPrefix("app-color")',
'        .addClass(colorClass);',
'    */',
'    ',
'    $("#app_icons_gallery")',
'        .removeClassWithPrefix("app-color")',
'        .addClass(colorClass);',
'    ',
'    $("#P120_ICON_COLOR_CLASS").val( colorClass );',
'})( apex.jQuery, this );'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2698020086425126335.4024)
,p_name=>'Change Icon'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P120_ICON_PICKER'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2698020187827126336.4024)
,p_event_id=>wwv_flow_api.id(2698020086425126335.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'(function( $, that ){',
'    var iconClass = ''app-icon-'' + $v(that.triggeringElement);',
'    ',
'    /*$("#app_icon_preview")',
'        .removeClassWithPrefix("app-icon-")',
'        .addClass(iconClass);',
'        */',
'    ',
'    $("#P120_ICON_CLASS").val( iconClass );',
'})( apex.jQuery, this );'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2647105680018258116.4024)
,p_name=>'Get App Icon'
,p_event_sequence=>50
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(2595758599738422245.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2647105755022258117.4024)
,p_event_id=>wwv_flow_api.id(2647105680018258116.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'(function( $ ){',
'',
'	var top$ = window.parent.frames[0].apex.jQuery;  //apex.util.getTopApex().jQuery;',
'',
'	var iconClass = ''app-icon-'' + $v(''P120_ICON_PICKER''),',
'		appColorClass = $v(''P120_ICON_COLOR_CLASS''),',
'		hexColor = $( ''#P120_ICON_COLOR'' ).find( ''.'' + appColorClass ).parent().prev().val();',
'',
'	top$( ''#P170_APP_COLOR_CLASS'' ).val( appColorClass );',
'	top$( ''#P170_APP_ICON_CLASS'' ).val( iconClass );',
'	top$( ''#P170_APP_COLOR_HEX'' ).val( hexColor );',
'',
'	top$( ''#app_icon'' )',
'		.removeClass()',
'		.addClass( ''a-PageWizard-appIcon '' + iconClass  + '' '' + appColorClass );',
'    ',
'    apex.submit();',
'    ',
'})( apex.jQuery );'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2647106425624258124.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Page 170 App Icon'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P170_APP_COLOR_CLASS := :P120_ICON_COLOR_CLASS;',
':P170_APP_ICON_CLASS  := :P120_ICON_PICKER;',
':P170_APP_COLOR_HEX   := :P120_ICON_COLOR;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2647106282983258122.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00130
begin
wwv_flow_api.create_page(
 p_id=>130.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Lingue applicazione'
,p_page_mode=>'MODAL'
,p_step_title=>'Lingue applicazione'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'fieldset.checkbox_group {',
'    width: 100%;',
'}',
'fieldset.checkbox_group table {',
'    width: 100%;',
'}',
'p.note {',
'margin: 0 8px;',
'color: #707070;',
'font-size: 11px;}',
'',
'.is-disabled {',
'    opacity: .5;',
'    pointer-events: none;',
'    cursor: not-allowed;',
'  }'))
,p_page_css_classes=>'a-PageWizard-dialog'
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(2698024578226405812.4024)
,p_dialog_height=>'360'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2796572808670751012.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2796573006579751014.4024)
,p_plug_name=>'Lingua primaria'
,p_region_css_classes=>'a-BoxedForms'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 24px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2796573473167751018.4024)
,p_plug_name=>'Traduzioni'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p class="note">L''applicazione verr\00E0 visualizzata nella lingua o nelle lingue selezionate. In caso di selezione di pi\00F9 lingue, gli utenti disporranno di collegamenti per le varie lingue nella pagina Collega.</p>')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2796573782624751021.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(2796572808670751012.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2796572933171751013.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(2796572808670751012.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Salva modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2996641060711931005.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(2796572808670751012.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP:P900_HELP_SECTION:LANG'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2796573199336751015.4024)
,p_name=>'P130_TRANSLATED_LANGS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2796573473167751018.4024)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Traduzioni'
,p_source=>'P1_TRANSLATED_LANGS'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'TRANSLATIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select l.translated_lang_name as lang_name, f.flow_language',
'from ( select flow_language',
'          from wwv_flows f',
'         where id = :APP_ID',
'         union',
'        select flow_language',
'          from wwv_flows f',
'         where id in ( select translation_flow_id',
'                         from wwv_flow_language_map',
'                        where primary_language_flow_id = :APP_ID )',
'      ) f,',
'      wwv_flow_languages l',
'where f.flow_language = l.lang_id',
'order by nlssort( l.translated_lang_name, ''NLS_SORT=binary'' )'))
,p_field_template=>wwv_flow_api.id(3076592553081438826.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'5'
,p_item_comment=>'P1_TRANSLATED_LANGS'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2939579793710578577.4024)
,p_name=>'P130_PRIMARY_LANGUAGE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2796573006579751014.4024)
,p_use_cache_before_default=>'NO'
,p_item_default=>'&BROWSER_LANGUAGE.'
,p_prompt=>'Lingua primaria'
,p_source=>'P1_PRIMARY_LANGUAGE'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TRANSLATIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select l.translated_lang_name as lang_name, f.flow_language',
'from ( select flow_language',
'          from wwv_flows f',
'         where id = :APP_ID',
'         union',
'        select flow_language',
'          from wwv_flows f',
'         where id in ( select translation_flow_id',
'                         from wwv_flow_language_map',
'                        where primary_language_flow_id = :APP_ID )',
'      ) f,',
'      wwv_flow_languages l',
'where f.flow_language = l.lang_id',
'order by nlssort( l.translated_lang_name, ''NLS_SORT=binary'' )'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(2716804030064502999.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_inline_help_text=>'Questo linguaggio viene usato per lo sviluppo e controlla il testo di una vasta gamma di componenti dell''applicazione.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2796573588692751019.4024)
,p_name=>'Toggle Language in Translations'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P130_PRIMARY_LANGUAGE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2796573610505751020.4024)
,p_event_id=>wwv_flow_api.id(2796573588692751019.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var $ = apex.jQuery,',
'    priLang = $(this.triggeringElement).val().toUpperCase(),',
'	transLang$ = $(''#P130_TRANSLATED_LANGS'');',
'',
'// Uncheck and make primary language in the translations item',
'transLang$',
'    .find(''input[type=checkbox]'')',
'    .each(function(){',
'        var that$ = $(this);',
'        if ( that$.hasClass(''is-disabled'') ){',
'            that$',
'                .prop(''checked'',false)',
'                .removeClass(''is-disabled'');',
'        }',
'});',
'',
'transLang$',
'    .find(''input[value='' + priLang + '']'')',
'	.prop(''checked'', true)',
'	.addClass(''is-disabled'');'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2796573852364751022.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(2796573782624751021.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2796573988240751023.4024)
,p_event_id=>wwv_flow_api.id(2796573852364751022.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2796574456153751028.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Language Items'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P1_TRANSLATED_LANGS := :P130_TRANSLATED_LANGS;',
':P1_PRIMARY_LANGUAGE := :P130_PRIMARY_LANGUAGE;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2796574031129751024.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_attribute_01=>'P130_TRANSLATED_LANGS,P130_PRIMARY_LANGUAGE'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00140
begin
wwv_flow_api.create_page(
 p_id=>140.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Oggetti di supporto'
,p_page_mode=>'MODAL'
,p_step_title=>'Oggetti di supporto'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'fieldset.checkbox_group {',
'    width: 100%;',
'}',
'fieldset.checkbox_group table {',
'    width: 100%;',
'}',
'p.note {',
'margin: 0 8px;',
'color: #707070;',
'font-size: 11px;}'))
,p_page_css_classes=>'a-PageWizard-dialog'
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3124271964326242195.4024)
,p_dialog_height=>'580'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5781861774452699579.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5781862438949699585.4024)
,p_plug_name=>'Oggetti di supporto'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2985289632294948581.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(5781861774452699579.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2985290062912948582.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(5781861774452699579.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Salva modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3035688502253083804.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(5781861774452699579.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP:P900_HELP_SECTION:SUPP_OBJS'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2796574958721751033.4024)
,p_name=>'P140_DEINSTALL_SCRIPT'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(5781862438949699585.4024)
,p_prompt=>'Script di disinstallazione'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.CODE_EDITOR'
,p_cSize=>30
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(3076592553081438826.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'SQL'
,p_attribute_02=>'VARCHAR2'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2940046372472003232.4024)
,p_name=>'P140_RUN_SCRIPT'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5781862438949699585.4024)
,p_prompt=>'Esegui durante la creazione dell''applicazione'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'RUN WHEN CREATING APP'
,p_lov=>'.'||wwv_flow_api.id(3011477941821019938.4024)||'.'
,p_lov_display_null=>'YES'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--floatLeft:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2985291424860948594.4024)
,p_name=>'P140_INSTALL_SCRIPT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(5781862438949699585.4024)
,p_prompt=>'Script di installazione'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.CODE_EDITOR'
,p_cSize=>30
,p_cHeight=>7
,p_field_template=>wwv_flow_api.id(3076592553081438826.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'SQL'
,p_attribute_02=>'VARCHAR2'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2985292689933948614.4024)
,p_name=>'Toggle Language in Translations'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P140_PRIMARY_LANGUAGE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2985293156154948616.4024)
,p_event_id=>wwv_flow_api.id(2985292689933948614.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/* Cache Elements */',
'var priLang = $(this.triggeringElement).val().toUpperCase();',
'var translatedItem$ = $(''#P140_TRANSLATED_LANGS'').find(''input[type=checkbox]'');',
'var translatedLangItem$ = $(''#P140_TRANSLATED_LANGS'').find(''input[value=''+priLang+'']'');',
'',
'/* Uncheck and make primary language in the translations item */',
'translatedItem$.each(function(){',
'  if ($(this).prop("disabled") === true){',
'    $(this).prop("checked",false);',
'    $(this).prop("disabled",false);',
'  }',
'});',
'translatedLangItem$.prop(''checked'',true).prop(''disabled'',true);'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2985293424223948616.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(2985289632294948581.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2985293903138948617.4024)
,p_event_id=>wwv_flow_api.id(2985293424223948616.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2940046107772003230.4024)
,p_process_sequence=>40
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Values from Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_install   clob;',
'   l_deinstall clob;',
'begin',
'    :P140_INSTALL_SCRIPT := null;',
'    :P140_DEINSTALL_SCRIPT := null;',
'    if APEX_COLLECTION.COLLECTION_EXISTS(p_collection_name => ''APEX$CREATEAPPSUPPOBJ'') then',
'       for c1 in (select CLOB001 from apex_collections where collection_name = ''APEX$CREATEAPPSUPPOBJ'' and c001 = ''Install Script'') loop',
'            l_install := c1.CLOB001;',
'            :P140_INSTALL_SCRIPT := l_install;',
'       end loop;',
'       for c1 in (select CLOB001 from apex_collections where collection_name = ''APEX$CREATEAPPSUPPOBJ'' and c001 = ''Deinstall Script'') loop',
'            l_deinstall := c1.CLOB001;',
'            :P140_DEINSTALL_SCRIPT := l_deinstall;',
'       end loop;',
'    end if;',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2940045987556003228.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Save Collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_install   clob;',
'   l_deinstall clob;',
'begin',
'    APEX_COLLECTION.CREATE_OR_TRUNCATE_COLLECTION(p_collection_name => ''APEX$CREATEAPPSUPPOBJ'');',
'    l_install := :P140_INSTALL_SCRIPT;',
'    l_deinstall := :P140_DEINSTALL_SCRIPT;',
'    APEX_COLLECTION.ADD_MEMBER (p_collection_name => ''APEX$CREATEAPPSUPPOBJ'', p_c001=>''Install Script'', p_clob001 => l_install);',
'    APEX_COLLECTION.ADD_MEMBER (p_collection_name => ''APEX$CREATEAPPSUPPOBJ'', p_c001=>''Deinstall Script'', p_clob001 => l_deinstall);',
'end;',
'        '))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2985291821695948611.4024)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_attribute_01=>'P140_INSTALL_SCRIPT'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00150
begin
wwv_flow_api.create_page(
 p_id=>150.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Progetto applicazione'
,p_page_mode=>'MODAL'
,p_step_title=>'Progetto applicazione'
,p_autocomplete_on_off=>'OFF'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function pageSubmit(req) {',
'  apex.builder.plugin.codeEditor.saveSubmit("#codeEditor_widget", "f01", {request: req, showWait: true});',
'}'))
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'fieldset.checkbox_group {',
'    width: 100%;',
'}',
'fieldset.checkbox_group table {',
'    width: 100%;',
'}',
'p.note {',
'margin: 0 8px;',
'color: #707070;',
'font-size: 11px;}'))
,p_page_css_classes=>'a-PageWizard-dialog'
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3027985170417035432.4024)
,p_dialog_height=>'660'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2934952369704675448.4024)
,p_plug_name=>'Modifica progetto'
,p_region_name=>'codeEditor'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select clob001',
'from wwv_flow_collections',
'where collection_name = ''TEMP_JSON'''))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.CLOB_CODE_EDITOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'JAVASCRIPT'
,p_attribute_02=>'30'
,p_attribute_03=>'N'
,p_attribute_04=>'VARCHAR2'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(8791485212424403619.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3009625244862704074.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(8791485212424403619.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3009625633237704076.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(8791485212424403619.4024)
,p_button_name=>'SAVE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica progetto'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3092828517095849801.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(8791485212424403619.4024)
,p_button_name=>'LOAD_BLUEPRINT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Carica un progetto precedente'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:160:&SESSION.::&DEBUG.:RP,160::'
,p_button_css_classes=>'a-Button--noUI'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2796575665900751040.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(8791485212424403619.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP:P900_HELP_SECTION:BLUEPRINT'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2940046237103003231.4024)
,p_branch_name=>'Reload Home Page'
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(3009625633237704076.4024)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3096983880958966805.4024)
,p_name=>'P150_BLUEPRINT_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2934952369704675448.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3009628557773704106.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3009625244862704074.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3009629083477704108.4024)
,p_event_id=>wwv_flow_api.id(3009628557773704106.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3096983605390966803.4024)
,p_name=>'Submit Page on Dialog Close'
,p_event_sequence=>30
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3092828517095849801.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3172047783258109033.4024)
,p_event_id=>wwv_flow_api.id(3096983605390966803.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P150_BLUEPRINT_ID'
,p_attribute_01=>'DIALOG_RETURN_ITEM'
,p_attribute_09=>'N'
,p_attribute_10=>'P160_BLUEPRINT_ID'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3172047817701109034.4024)
,p_event_id=>wwv_flow_api.id(3096983605390966803.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>'null;'
,p_attribute_02=>'P150_BLUEPRINT_ID'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3172047405728109030.4024)
,p_event_id=>wwv_flow_api.id(3096983605390966803.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3172047168618109027.4024)
,p_name=>'Save Blueprint'
,p_event_sequence=>50
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3009625633237704076.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3172047232011109028.4024)
,p_event_id=>wwv_flow_api.id(3172047168618109027.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'pageSubmit("SAVE");'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2940046596425003234.4024)
,p_process_sequence=>40
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load Blueprint JSON into collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    c_json_collection constant varchar2(255) := ''TEMP_JSON'';',
'    l_json            clob;',
'begin',
'    if :P150_BLUEPRINT_ID is null then',
'        l_json := wwv_flow_blueprint_v3.gen_json (',
'                    p_built_with_love       =>  :P5_BUILT_WITH_LOVE,',
'                    p_learn_app_def         =>  :P5_LEARN_UI_DEF_YN,',
'                    P_APP_NAME              =>  :P1_APP_NAME,',
'                    P_APP_SHORT_DESC        =>  :P5_APP_SHORT_DESC,',
'                    P_APP_DESC              =>  :P5_APP_DESC,',
'                    P_FEATURES              =>  :P1_FEATURES,',
'                    P_THEME_STYLE           =>  nvl(:P170_THEME_STYLE, :P1_THEME_STYLE),',
'                    P_NAV_POSITION          =>  nvl(:P170_NAV_POSITION, :P1_NAV_POSITION),',
'                    P_APP_ICON_CLASS        =>  :P1_APP_ICON_CLASS,',
'                    P_APP_COLOR_CLASS       =>  :P1_APP_COLOR_CLASS,',
'                    P_APP_COLOR_HEX         =>  :P1_APP_COLOR_HEX,',
'                    P_BASE_TABLE_PREFIX     =>  :P5_BASE_TABLE_PREFIX,',
'                    P_PRIMARY_LANGUAGE      =>  :P1_PRIMARY_LANGUAGE,',
'                    P_TRANSLATED_LANGS      =>  :P1_TRANSLATED_LANGS,',
'                    P_AUTHENTICATION        =>  :P1_AUTHENTICATION,',
'                    P_APP_VERSION           =>  :P5_APP_VERSION,',
'                    P_APP_LOGGING           =>  :P5_APP_LOGGING,',
'                    P_APP_DEBUGGING         =>  :P5_APP_DEBUGGING,',
'                    P_DOCUMENT_DIRECTION    =>  :P5_DOCUMENT_DIRECTION,',
'                    P_DATE_FORMAT           =>  :P5_DATE_FORMAT,',
'                    P_DATE_TIME_FORMAT      =>  :P5_DATE_TIME_FORMAT,',
'                    P_TIMESTAMP_FORMAT      =>  :P5_TIMESTAMP_FORMAT,',
'                    P_TIMESTAMP_TZ_FORMAT   =>  :P5_TIMESTAMP_TZ_FORMAT,',
'                    P_DEEP_LINKING          =>  :P5_DEEP_LINKING,',
'                    P_MAX_SESSION_LENGTH    =>  :P5_MAX_SESSION_LENGTH,',
'                    P_MAX_SESSION_IDLE_TIME =>  :P5_MAX_SESSION_IDLE_TIME,',
'                    p_schema                =>  :P1_SCHEMA',
'                    );',
'    else',
'        l_json := wwv_flow_blueprint_v3.load_named_blueprint(',
'	                p_blueprint_id => :P150_BLUEPRINT_ID,',
'	                p_app_user     => :APP_USER,',
'                    p_security_group_id => :FLOW_SECURITY_GROUP_ID);',
'    end if;',
'',
'    wwv_flow_collection.create_or_truncate_collection(',
'        p_collection_name => c_json_collection );',
'',
'    wwv_flow_collection.add_member(',
'        p_collection_name => c_json_collection,',
'        p_clob001         => l_json );',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3009626050886704100.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Parse JSON and Set Values'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_json clob;',
'begin    ',
'    sys.dbms_lob.createtemporary( l_json, false, sys.dbms_lob.SESSION );',
'   ',
'    for i in 1..wwv_flow.g_f01.count loop ',
'        sys.dbms_lob.writeappend( l_json, length(wwv_flow.g_f01(i)), wwv_flow.g_f01(i) );        ',
'    end loop;        ',
'    ',
'    wwv_flow_blueprint_v3.get_session_state_from_json (',
'    	P_JSON_BLUEPRINT        => l_json,',
'        p_schema                => :P1_SCHEMA,',
'        p_built_with_love       => :P5_BUILT_WITH_LOVE,',
'        p_learn_app_def         => :P5_LEARN_UI_DEF_YN,',
'        P_APP_NAME              => :P1_APP_NAME,',
'        P_APP_SHORT_DESC        => :P5_APP_SHORT_DESC,',
'        P_APP_DESC              => :P5_APP_DESC,',
'        P_FEATURES              => :P1_FEATURES,',
'        P_THEME_STYLE           => :P170_THEME_STYLE,',
'        P_NAV_POSITION          => :P170_NAV_POSITION,',
'        P_APP_ICON_CLASS        => :P1_APP_ICON_CLASS,',
'        P_APP_COLOR_CLASS       => :P1_APP_COLOR_CLASS,',
'        P_APP_COLOR_HEX         => :P1_APP_COLOR_HEX,',
'        P_BASE_TABLE_PREFIX     => :P5_BASE_TABLE_PREFIX,',
'        P_PRIMARY_LANGUAGE      => :P1_PRIMARY_LANGUAGE,',
'        P_TRANSLATED_LANGS      => :P1_TRANSLATED_LANGS,',
'        P_AUTHENTICATION        => :P1_AUTHENTICATION,',
'        P_APP_VERSION           => :P5_APP_VERSION,',
'        P_APP_LOGGING           => :P5_APP_LOGGING,',
'        P_APP_DEBUGGING         => :P5_APP_DEBUGGING,',
'        P_DOCUMENT_DIRECTION    => :P5_DOCUMENT_DIRECTION,',
'        P_DATE_FORMAT           => :P5_DATE_FORMAT,',
'        P_DATE_TIME_FORMAT      => :P5_DATE_TIME_FORMAT,',
'        P_TIMESTAMP_FORMAT      => :P5_TIMESTAMP_FORMAT,',
'        P_TIMESTAMP_TZ_FORMAT   => :P5_TIMESTAMP_TZ_FORMAT,',
'        P_DEEP_LINKING          => :P5_DEEP_LINKING,',
'        P_MAX_SESSION_LENGTH    => :P5_MAX_SESSION_LENGTH,',
'        P_MAX_SESSION_IDLE_TIME => :P5_MAX_SESSION_IDLE_TIME',
'        );',
'       ',
'    :P1_THEME_STYLE := :P170_THEME_STYLE;',
'    :P1_NAV_POSITION := :P170_NAV_POSITION;',
'    ',
'    wwv_flow_app_def_v3.sync_app_defaults (',
'        p_schema              => :P1_SCHEMA,',
'        p_learn_app_def       => ( nvl(:P5_LEARN_UI_DEF_YN, ''N'') = ''Y'' ),',
'        p_learn_existing_apps => ( nvl(:P5_LEARN_YN,''N'') = ''Y'' ),',
'        p_base_table_prefix   => :P5_BASE_TABLE_PREFIX );',
'        ',
'    :P130_PRIMARY_LANGUAGE := :P1_PRIMARY_LANGUAGE;',
'    :P130_TRANSLATED_LANGS := :P1_TRANSLATED_LANGS;',
'end;'))
,p_process_error_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Impossibile salvare i valori del progetto nella sessione APEX.',
'#SQLERRM#'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(3009625633237704076.4024)
);
end;
/
prompt --application/pages/page_00160
begin
wwv_flow_api.create_page(
 p_id=>160.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Carica progetto'
,p_page_mode=>'MODAL'
,p_step_title=>'Carica progetto'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.icon-preview {',
'width: 24px;',
'height: 24px;',
'display: block;',
'border-radius: 2px;',
'background-color: currentColor;',
'}',
'.a-Report-cell {',
'    line-height: 24px;',
'}',
'.delete-button {',
'    color: #FC181B;',
'}',
'.nodatafound {',
'    text-align: center;',
'    padding: 64px 0;',
'    font-size: 16px;',
'    background: #F8F8F8;',
'    margin: 16px;',
'    border-radius: 2px;',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'400'
,p_dialog_width=>'640'
,p_dialog_chained=>'N'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(3092828716344849803.4024)
,p_name=>'Progetti'
,p_region_name=>'blueprints_report'
,p_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--staticRowColors:a-Report--horizontalBorders:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  id,',
'  icon_class icon,',
'  icon_color_class,',
'  name,',
'  page_count,',
'  feature_count,',
'  created_on created,',
'  null select_action,',
'  null load_action,',
'  null delete_action,',
'  name clean_name',
'from WWV_FLOW_BLUEPRINT_REPO',
'where created_by = :APP_USER and security_group_id = :FLOW_SECURITY_GROUP_ID',
'order by created_on desc'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(2707641403506668051.4024)
,p_query_num_rows=>500
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'Nessun progetto trovato'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2940047222737003241.4024)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>7
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3092828828392849804.4024)
,p_query_column_id=>2
,p_column_alias=>'ICON'
,p_column_display_sequence=>1
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3092828993907849805.4024)
,p_query_column_id=>3
,p_column_alias=>'ICON_COLOR_CLASS'
,p_column_display_sequence=>2
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3092829049410849806.4024)
,p_query_column_id=>4
,p_column_alias=>'NAME'
,p_column_display_sequence=>3
,p_column_heading=>'Nome'
,p_use_as_row_header=>'N'
,p_column_html_expression=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-MediaBlock">',
'  <div class="a-MediaBlock-graphic icon-preview #ICON# #ICON_COLOR_CLASS#"></div>',
'  <div class="a-MediaBlock-content">#NAME#</div>',
'</div>'))
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2940047394433003242.4024)
,p_query_column_id=>5
,p_column_alias=>'PAGE_COUNT'
,p_column_display_sequence=>4
,p_column_heading=>'Conteggio pagine'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3040394562753894745.4024)
,p_query_column_id=>6
,p_column_alias=>'FEATURE_COUNT'
,p_column_display_sequence=>5
,p_column_heading=>'Funzioni'
,p_use_as_row_header=>'N'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3092829341232849809.4024)
,p_query_column_id=>7
,p_column_alias=>'CREATED'
,p_column_display_sequence=>6
,p_column_heading=>'Data creazione'
,p_use_as_row_header=>'N'
,p_column_format=>'SINCE'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3040394614917894746.4024)
,p_query_column_id=>8
,p_column_alias=>'SELECT_ACTION'
,p_column_display_sequence=>8
,p_column_heading=>'<span class="u-VisuallyHidden">Seleziona progetto</span>'
,p_use_as_row_header=>'N'
,p_column_html_expression=>'<button type="button" class="a-Button a-Button--small select-button" data-id="#ID#">Seleziona</button>'
,p_column_alignment=>'CENTER'
,p_display_when_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_display_when_condition=>'P160_RETURN_TYPE'
,p_display_when_condition2=>'LOAD'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_report_column_width=>24
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3210720416272760404.4024)
,p_query_column_id=>9
,p_column_alias=>'LOAD_ACTION'
,p_column_display_sequence=>9
,p_column_heading=>'<span class="u-VisuallyHidden">Carica progetto</span>'
,p_use_as_row_header=>'N'
,p_column_html_expression=>'<button type="button" class="a-Button a-Button--small load-button" data-id="#ID#">Carica</button>'
,p_display_when_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_when_condition=>'P160_RETURN_TYPE'
,p_display_when_condition2=>'LOAD'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3040394722705894747.4024)
,p_query_column_id=>10
,p_column_alias=>'DELETE_ACTION'
,p_column_display_sequence=>10
,p_column_heading=>'<span class="u-VisuallyHidden">Elimina progetto</span>'
,p_use_as_row_header=>'N'
,p_column_html_expression=>'<button type="button" title="Elimina progetto #CLEAN_NAME#" class="a-Button a-Button--small a-Button--noUI delete-button" data-id="#ID#"><span class="a-Icon icon-remove" aria-hidden="true"></span></button>'
,p_column_alignment=>'CENTER'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_report_column_width=>24
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3217864403847443003.4024)
,p_query_column_id=>11
,p_column_alias=>'CLEAN_NAME'
,p_column_display_sequence=>11
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3210721976980760419.4024)
,p_branch_name=>'Go to Create Wizard Home Page'
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'LOAD_BLUEPRINT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3040395074343894750.4024)
,p_name=>'P160_BLUEPRINT_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(3092828716344849803.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3217864528853443004.4024)
,p_name=>'P160_RETURN_TYPE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(3092828716344849803.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3040394824972894748.4024)
,p_name=>'Send Blueprint Back to Page'
,p_event_sequence=>10
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'.select-button'
,p_bind_type=>'live'
,p_bind_event_type=>'click'
,p_display_when_type=>'REQUEST_NOT_EQUAL_CONDITION'
,p_display_when_cond=>'LOAD'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3040394906737894749.4024)
,p_event_id=>wwv_flow_api.id(3040394824972894748.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P160_BLUEPRINT_ID'
,p_attribute_01=>'JAVASCRIPT_EXPRESSION'
,p_attribute_05=>'$(this.triggeringElement).data("id");'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3172047584383109031.4024)
,p_event_id=>wwv_flow_api.id(3040394824972894748.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
,p_attribute_01=>'P160_BLUEPRINT_ID'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3210720549847760405.4024)
,p_name=>'Load Blueprint'
,p_event_sequence=>20
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'.load-button'
,p_bind_type=>'live'
,p_bind_event_type=>'click'
,p_display_when_type=>'REQUEST_EQUALS_CONDITION'
,p_display_when_cond=>'LOAD'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3210720684856760406.4024)
,p_event_id=>wwv_flow_api.id(3210720549847760405.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P160_BLUEPRINT_ID'
,p_attribute_01=>'JAVASCRIPT_EXPRESSION'
,p_attribute_05=>'$(this.triggeringElement).data("id");'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3210720871116760408.4024)
,p_event_id=>wwv_flow_api.id(3210720549847760405.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_01=>'LOAD_BLUEPRINT'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3096984274263966809.4024)
,p_name=>'Delete Blueprint (Refresh Report)'
,p_event_sequence=>30
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'.delete-button'
,p_bind_type=>'live'
,p_bind_event_type=>'click'
,p_display_when_type=>'NEVER'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3096984318923966810.4024)
,p_event_id=>wwv_flow_api.id(3096984274263966809.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P160_BLUEPRINT_ID'
,p_attribute_01=>'JAVASCRIPT_EXPRESSION'
,p_attribute_05=>'$(this.triggeringElement).data("id");'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3217864239961443001.4024)
,p_event_id=>wwv_flow_api.id(3096984274263966809.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_blueprint_v3.remove_blueprint (',
'	p_blueprint_id => :P160_BLUEPRINT_ID, ',
'	p_app_user => :APP_USER,',
'    p_security_group_id => :FLOW_SECURITY_GROUP_ID);'))
,p_attribute_02=>'P160_BLUEPRINT_ID'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3217864378761443002.4024)
,p_event_id=>wwv_flow_api.id(3096984274263966809.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(3092828716344849803.4024)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3217864682642443005.4024)
,p_name=>'Delete Blueprint (AJAX)'
,p_event_sequence=>40
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'.delete-button'
,p_bind_type=>'live'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3217864778596443006.4024)
,p_event_id=>wwv_flow_api.id(3217864682642443005.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// cache common elements',
'var blueprint$    = $(this.triggeringElement),',
'    blueprintId   = blueprint$.data("id"),',
'    blueprintRow$ = blueprint$.parents("tr");',
'',
'// hide blueprint from UI',
'blueprint$.parents("tr").addClass("is-disabled");',
'',
'// run ajax process to remove blueprint',
'apex.server.process( "removeBlueprint", {',
'    x01: blueprintId',
'}, {',
'    success: function( commentID ) {',
'        blueprintRow$.remove();',
'    }',
'});'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3210720931436760409.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load Blueprint'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_blueprint clob;',
'begin',
'',
'l_blueprint := wwv_flow_blueprint_v3.load_named_blueprint(',
'	p_blueprint_id => :P160_BLUEPRINT_ID,',
'	p_app_user=> :APP_USER,',
'    p_security_group_id => :FLOW_SECURITY_GROUP_ID);',
'	',
'wwv_flow_blueprint_v3.get_session_state_from_json (',
'    P_JSON_BLUEPRINT        => l_blueprint,',
'    p_schema                => :P1_SCHEMA,',
'    p_built_with_love       => :P5_BUILT_WITH_LOVE,',
'    p_learn_app_def         => :P5_LEARN_UI_DEF_YN,',
'    P_APP_NAME              => :P1_APP_NAME,',
'    P_APP_SHORT_DESC        => :P5_APP_SHORT_DESC,',
'    P_APP_DESC              => :P5_APP_DESC,',
'    P_FEATURES              => :P1_FEATURES,',
'    P_THEME_STYLE           => :P170_THEME_STYLE,',
'    P_NAV_POSITION          => :P170_NAV_POSITION,',
'    P_APP_ICON_CLASS        => :P1_APP_ICON_CLASS,',
'    P_APP_COLOR_CLASS       => :P1_APP_COLOR_CLASS,',
'    P_APP_COLOR_HEX         => :P1_APP_COLOR_HEX,',
'    P_BASE_TABLE_PREFIX     => :P5_BASE_TABLE_PREFIX,',
'    P_PRIMARY_LANGUAGE      => :P1_PRIMARY_LANGUAGE,',
'    P_TRANSLATED_LANGS      => :P1_TRANSLATED_LANGS,',
'    P_AUTHENTICATION        => :P1_AUTHENTICATION,',
'    P_APP_VERSION           => :P5_APP_VERSION,',
'    P_APP_LOGGING           => :P5_APP_LOGGING,',
'    P_APP_DEBUGGING         => :P5_APP_DEBUGGING,',
'    P_DOCUMENT_DIRECTION    => :P5_DOCUMENT_DIRECTION,',
'    P_DATE_FORMAT           => :P5_DATE_FORMAT,',
'    P_DATE_TIME_FORMAT      => :P5_DATE_TIME_FORMAT,',
'    P_TIMESTAMP_FORMAT      => :P5_TIMESTAMP_FORMAT,',
'    P_TIMESTAMP_TZ_FORMAT   => :P5_TIMESTAMP_TZ_FORMAT,',
'    P_DEEP_LINKING          => :P5_DEEP_LINKING,',
'    P_MAX_SESSION_LENGTH    => :P5_MAX_SESSION_LENGTH,',
'    P_MAX_SESSION_IDLE_TIME => :P5_MAX_SESSION_IDLE_TIME',
'    );',
'    ',
'    :P1_THEME_STYLE := :P170_THEME_STYLE;',
'    :P1_NAV_POSITION := :P170_NAV_POSITION;',
'',
'exception when others then null;',
'',
'end;'))
,p_process_error_message=>'Errore durante il caricamento del progetto'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'LOAD_BLUEPRINT'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3117408439825935021.4024)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Delete Blueprint'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_blueprint_v3.remove_blueprint (',
'	p_blueprint_id => :P160_BLUEPRINT_ID, ',
'	p_app_user => :APP_USER,',
'    p_security_group_id => :FLOW_SECURITY_GROUP_ID);'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_type=>'NEVER'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3217865010876443009.4024)
,p_process_sequence=>10
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'removeBlueprint'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'  	wwv_flow_blueprint_v3.remove_blueprint (',
'    	p_blueprint_id => apex_application.g_x01, ',
'    	p_app_user => :APP_USER,',
'    	p_security_group_id => :FLOW_SECURITY_GROUP_ID);',
'		',
'	apex_plugin_util.print_json_http_header;',
'	apex_json.open_object;',
'	apex_json.write(''status'',''deleted'');',
'    apex_json.close_object;',
'	',
'exception when others then ',
'',
'	apex_plugin_util.print_json_http_header;',
'	apex_json.open_object;',
'	apex_json.write(''error'',''unable to delete blueprint'');',
'    apex_json.close_object;',
'	rollback;',
'	',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00170
begin
wwv_flow_api.create_page(
 p_id=>170.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Aspetto'
,p_page_mode=>'MODAL'
,p_step_title=>'Aspetto'
,p_autocomplete_on_off=>'OFF'
,p_javascript_code_onload=>'apex.jQuery("#choose_icon").appendTo(".a-PageWizard-appIconContainer .a-Form-inputContainer");'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.field.item-app-name { margin-bottom: 0; }',
'.field--style--boxed .display_only { line-height: 24px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }',
'.apex-col .field.field-item-button-grouping { margin-right: -1px; }',
'.lang-button { padding-top: 19px; padding-bottom: 19px; width: calc(100% - 16px); margin-right: 16px; }',
'.advanced-button { padding-top: 19px; padding-bottom: 19px; width: calc(100% - 16px); margin-right: 16px; }',
'.attribute-button { padding-top: 19px; padding-bottom: 19px; width: calc(100% - 16px); margin-right: 16px; }',
'.a-BoxedForms .field-item-button-grouping .field-input__wrap { border-radius: 2px 0 0 2px; }',
'html.no-js .a-BoxedForms .field--style--boxed.label-only .field-label { padding-top: 1.8rem; padding-bottom: 1.8rem; }',
'.page-source-table { font-family: monospace; font-size: 11px; line-height: 21px; margin: 0 4px; }'))
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'550'
,p_dialog_width=>'880'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(52409446028114501.4024)
,p_plug_name=>'Appearance - Custom Theme'
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P170_CUSTOM_THEME_YN'
,p_plug_display_when_cond2=>'Y'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(52409790570114504.4024)
,p_plug_name=>'Hidden Items'
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3718779288454226401.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6307699474464365654.4024)
,p_plug_name=>'Appearance - UT'
,p_region_name=>'appearance'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 24px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P170_CUSTOM_THEME_YN'
,p_plug_display_when_cond2=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3718774912062215130.4024)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(6307699474464365654.4024)
,p_button_name=>'CHOOSE_ICON'
,p_button_static_id=>'choose_icon'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Scegli nuova icona'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:RP,120::'
,p_button_css_classes=>'a-Button--chooseIcon'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3396254080746246635.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(3718779288454226401.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:a-Button--gapRight'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(645332378727941501.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(3718779288454226401.4024)
,p_button_name=>'CUSTOM_THEME'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Usa tema personalizzato'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P170_CUSTOM_THEME_YN'
,p_button_condition2=>'N'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(52410326133114510.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(3718779288454226401.4024)
,p_button_name=>'UNIVERSAL_THEME'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Usa tema universale'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P170_CUSTOM_THEME_YN'
,p_button_condition2=>'Y'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3396253804956246633.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(3718779288454226401.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Salva modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3718775307196215133.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(3718779288454226401.4024)
,p_button_name=>'HELP_UI'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader:a-Button--small'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Visualizza la Guida per Aspetto'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:UI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(52410470000114511.4024)
,p_branch_name=>'Reload Page'
,p_branch_action=>'f?p=&APP_ID.:170:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_IN_CONDITION'
,p_branch_condition=>'CUSTOM_THEME,UNIVERSAL_THEME'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(52409521057114502.4024)
,p_name=>'P170_CUSTOM_THEME_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(52409446028114501.4024)
,p_prompt=>'Tema area di lavoro'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'       t.theme_name,',
'       t.id',
'  from wwv_flow_themes t',
' where theme_security_group_id = :WORKSPACE_ID',
'   and security_group_id = 11'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona tema personalizzato -'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Selezionare il tema di area di lavoro da utilizzare durante la generazione dell''applicazione.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(52409663240114503.4024)
,p_name=>'P170_CUSTOM_THEME_STYLE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(52409446028114501.4024)
,p_prompt=>'Stile tema'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'   s.name || ',
'       case is_accessible',
'           when ''Y'' then '' ('' || wwv_flow_lang.system_message(''ACCESSIBILITY_TESTED'') || '')''',
'           else ''''',
'        end name,   ',
'   s.id ',
'from wwv_flow_themes t, wwv_flow_theme_styles s',
'where t.id = :P170_CUSTOM_THEME_ID',
'and t.theme_id = s.theme_id',
'and t.flow_id = s.flow_id',
''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona stile tema -'
,p_lov_cascade_parent_items=>'P170_CUSTOM_THEME_ID'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Se supportato dal tema personalizzato, selezionare lo stile da utilizzare durante la generazione dell''applicazione.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(52409875575114505.4024)
,p_name=>'P170_CUSTOM_THEME_YN'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(52409790570114504.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3396254608905246641.4024)
,p_name=>'P170_NAV_POSITION_DISP'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(6307699474464365654.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3718775740605215139.4024)
,p_name=>'P170_THEME_STYLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(6307699474464365654.4024)
,p_prompt=>'Stile tema'
,p_source=>'P1_THEME_STYLE'
,p_source_type=>'ITEM'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.WIZARD_SELECTION'
,p_named_lov=>'P1_THEME_STYLES'
,p_lov=>'.'||wwv_flow_api.id(2595731361215290332.4024)||'.'
,p_field_template=>wwv_flow_api.id(3076592553081438826.4024)
,p_item_css_classes=>'a-IconList--PageWizard a-IconList--LargeIcons'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'S'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3718776124351215148.4024)
,p_name=>'P170_NAV_POSITION'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(6307699474464365654.4024)
,p_prompt=>'Navigazione'
,p_source=>'P1_NAV_POSITION'
,p_source_type=>'ITEM'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.WIZARD_SELECTION'
,p_named_lov=>'P1_NAVIGATION_POSITION'
,p_lov=>'.'||wwv_flow_api.id(2621239147915611502.4024)||'.'
,p_colspan=>6
,p_field_template=>wwv_flow_api.id(3076592553081438826.4024)
,p_item_css_classes=>'a-IconList--PageWizard a-IconList--SmallIcons'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'S'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3718776562268215148.4024)
,p_name=>'P170_APP_COLOR_CLASS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(6307699474464365654.4024)
,p_source=>'P1_APP_COLOR_CLASS'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'B'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3718776912614215148.4024)
,p_name=>'P170_APP_ICON_CLASS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(6307699474464365654.4024)
,p_source=>'P1_APP_ICON_CLASS'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3718777733090215149.4024)
,p_name=>'P170_APP_ICON'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(6307699474464365654.4024)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Icona applicazione'
,p_source=>'<div class="a-PageWizard-appIcon &P1_APP_ICON_CLASS. &P1_APP_COLOR_CLASS." id="app_icon"></div>'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(3076592553081438826.4024)
,p_item_css_classes=>'a-PageWizard-appIconContainer'
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3733042812981281369.4024)
,p_name=>'P170_APP_COLOR_HEX'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(6307699474464365654.4024)
,p_source=>'P1_APP_COLOR_HEX'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(52410594310114512.4024)
,p_computation_sequence=>10
,p_computation_item=>'P170_CUSTOM_THEME_YN'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if ( :P1_THEME_TYPE in (''CUSTOM'',''CUSTOM_UT'') ) then',
'    return ''Y'';',
'else',
'    return ''N'';',
'end if;'))
,p_compute_when=>'P170_CUSTOM_THEME_YN'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(101210759019869203.4024)
,p_validation_name=>'Custom Theme not null'
,p_validation_sequence=>10
,p_validation=>'P170_CUSTOM_THEME_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>'P170_CUSTOM_THEME_YN'
,p_validation_condition2=>'Y'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_when_button_pressed=>wwv_flow_api.id(3396253804956246633.4024)
,p_associated_item=>wwv_flow_api.id(52409521057114502.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3396254181242246636.4024)
,p_name=>'Cancel'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3396254080746246635.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3396254200111246637.4024)
,p_event_id=>wwv_flow_api.id(3396254181242246636.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3396254707676246642.4024)
,p_name=>'Get Displayed Value'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P170_NAV_POSITION'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3396254800162246643.4024)
,p_event_id=>wwv_flow_api.id(3396254707676246642.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>':P170_NAV_POSITION_DISP := initCap( lower(:P170_NAV_POSITION) );'
,p_attribute_02=>'P170_NAV_POSITION'
,p_attribute_03=>'P170_NAV_POSITION_DISP'
,p_attribute_04=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(52410061763114507.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Use Custom Theme'
,p_process_sql_clob=>':P170_CUSTOM_THEME_YN := ''Y'';'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(645332378727941501.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(52410267134114509.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Use Universal Theme'
,p_process_sql_clob=>':P170_CUSTOM_THEME_YN := ''N'';'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(52410326133114510.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3396254345369246638.4024)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Page 1 Item Values'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P170_CUSTOM_THEME_YN = ''N'' then',
'',
'    :P1_THEME_TYPE      := ''UT'';',
'    :P1_THEME_STYLE     := :P170_THEME_STYLE;',
'    ',
'    :P1_NAV_POSITION    := :P170_NAV_POSITION;',
'    :P1_APP_COLOR_CLASS := :P170_APP_COLOR_CLASS;',
'    :P1_APP_ICON_CLASS  := :P170_APP_ICON_CLASS;',
'    :P1_APP_COLOR_HEX   := :P170_APP_COLOR_HEX;',
'',
'elsif :P170_CUSTOM_THEME_YN = ''Y'' then',
'',
'    if wwv_flow_theme_dev.is_universal_theme ( p_theme_id => :P170_CUSTOM_THEME_ID ) then',
'        :P1_THEME_TYPE  := ''CUSTOM_UT'';',
'    else',
'        :P1_THEME_TYPE  := ''CUSTOM'';',
'    end if;',
'    ',
'    :P1_THEME_ID    := :P170_CUSTOM_THEME_ID;',
'    :P1_THEME_STYLE := :P170_CUSTOM_THEME_STYLE_ID;',
'',
'    -- clean up',
'    :P170_NAV_POSITION      := '''';',
'    :P170_APP_COLOR_CLASS   := '''';',
'    :P170_APP_ICON_CLASS    := '''';',
'    :P170_APP_COLOR_HEX     := '''';',
'',
'    :P1_NAV_POSITION        := '''';',
'    :P1_APP_COLOR_CLASS     := '''';',
'    :P1_APP_ICON_CLASS      := '''';',
'    :P1_APP_COLOR_HEX       := '''';',
'    ',
'end if;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(3396253804956246633.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3396253968011246634.4024)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog for UT'
,p_attribute_01=>'P170_THEME_STYLE,P170_NAV_POSITION,P170_CUSTOM_THEME_YN,P1_THEME_TYPE'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(3396253804956246633.4024)
);
end;
/
prompt --application/pages/page_00250
begin
wwv_flow_api.create_page(
 p_id=>250.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Impostazioni predefinite attributi'
,p_page_mode=>'MODAL'
,p_step_title=>'Impostazioni predefinite attributi'
,p_autocomplete_on_off=>'OFF'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function pageSubmit(req) {',
'  apex.builder.plugin.codeEditor.saveSubmit("#codeEditor_widget", "f01", {request: req, showWait: true});',
'}'))
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'fieldset.checkbox_group {',
'    width: 100%;',
'}',
'fieldset.checkbox_group table {',
'    width: 100%;',
'}',
'p.note {',
'margin: 0 8px;',
'color: #707070;',
'font-size: 11px;}'))
,p_page_css_classes=>'a-PageWizard-dialog'
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3027830547707021532.4024)
,p_dialog_height=>'650'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11817121936578509579.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11817122601075509585.4024)
,p_plug_name=>'Modifica impostazioni predefinite attributi'
,p_region_name=>'codeEditor'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select clob001',
'from wwv_flow_collections',
'where collection_name = ''TEMP_JSON'''))
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.CLOB_CODE_EDITOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'SQL'
,p_attribute_02=>'30'
,p_attribute_03=>'N'
,p_attribute_04=>'VARCHAR2'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3025638933882105990.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(11817121936578509579.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP:P900_HELP_SECTION:DEFAULTS'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3025638183876105989.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(11817121936578509579.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3025638589266105990.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(11817121936578509579.4024)
,p_button_name=>'SAVE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica impostazioni predefinite attributi'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3025642886946106023.4024)
,p_branch_name=>'Reload attribute values page'
,p_branch_action=>'f?p=&APP_ID.:250:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'NEVER'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3025640911556106018.4024)
,p_name=>'Toggle Language in Translations'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P250_PRIMARY_LANGUAGE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3025641493679106020.4024)
,p_event_id=>wwv_flow_api.id(3025640911556106018.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/* Cache Elements */',
'var priLang = $(this.triggeringElement).val().toUpperCase();',
'var translatedItem$ = $(''#P250_TRANSLATED_LANGS'').find(''input[type=checkbox]'');',
'var translatedLangItem$ = $(''#P250_TRANSLATED_LANGS'').find(''input[value=''+priLang+'']'');',
'',
'/* Uncheck and make primary language in the translations item */',
'translatedItem$.each(function(){',
'  if ($(this).prop("disabled") === true){',
'    $(this).prop("checked",false);',
'    $(this).prop("disabled",false);',
'  }',
'});',
'translatedLangItem$.prop(''checked'',true).prop(''disabled'',true);'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3025641847966106021.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3025638183876105989.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3025642367939106021.4024)
,p_event_id=>wwv_flow_api.id(3025641847966106021.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3172047965255109035.4024)
,p_name=>'Save App Defaults'
,p_event_sequence=>30
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3025638589266105990.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3172048020273109036.4024)
,p_event_id=>wwv_flow_api.id(3172047965255109035.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'pageSubmit("SAVE");'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3025639737610106015.4024)
,p_process_sequence=>40
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load app def JSON into collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    c_json_collection constant varchar2(255) := ''TEMP_JSON'';',
'    l_json            clob;',
'begin',
'    l_json := wwv_flow_app_def_v3.gen_app_defaults_from_coll;',
'',
'    wwv_flow_collection.create_or_truncate_collection(',
'        p_collection_name => c_json_collection );',
'',
'    wwv_flow_collection.add_member(',
'        p_collection_name => c_json_collection,',
'        p_clob001         => l_json );',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3025640182714106016.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Parse JSON and Set Values'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_json clob;',
'begin',
'    sys.dbms_lob.createtemporary( l_json, false, sys.dbms_lob.SESSION );',
'    for i in 1..wwv_flow.g_f01.count loop ',
'        sys.dbms_lob.writeappend( l_json, length(wwv_flow.g_f01(i)), wwv_flow.g_f01(i) );        ',
'    end loop;',
'    ',
'    wwv_flow_app_def_v3.gen_apply_app_defaults_sql(',
'        p_app_defaults => l_json );',
'end;'))
,p_process_error_message=>'Impossibile salvare le impostazioni predefinite degli attributi nella raccolta.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3025640544461106016.4024)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00260
begin
wwv_flow_api.create_page(
 p_id=>260.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Valori predefiniti interfaccia utente'
,p_step_title=>'Valori predefiniti interfaccia utente'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-IRR-table tr:nth-child(even) td {',
'    background-color: inherit;',
'}',
'.a-IRR-table tr:hover td  .a-AVPList--blocks .a-AVPList-item, ',
'.a-IRR-table tr:nth-child(even):hover td .a-AVPList--blocks .a-AVPList-item,',
'.a-AVPList--blocks .a-AVPList-item:hover {',
'  background-color: #FFF;',
'}',
'',
'td[headers=attr_id],',
'td[headers=attr_settings] {',
'    padding: 0;',
'    vertical-align: top;',
'}',
'',
'.a-AVPList.a-AVPList--blocks {',
'    display: flex;',
'    flex-wrap: wrap;',
'    margin: 4px 0 0 4px;',
'}',
'',
'.a-AVPList--blocks .a-AVPList-item {',
'    display: block;',
'    padding: 8px;',
'    box-shadow: none;',
'    width: 160px;',
'    margin: 0 4px 4px 0;',
'    border-radius: 2px;',
'    background: #F8F8F8;',
'}',
'.a-AVPList--blocks .a-AVPList-item:last-child {',
'  margin-right: 0;',
'  border-right-width: 0;',
'}',
'',
'.a-AVPList--blocks .a-AVPList-label, ',
'.a-AVPList--blocks .a-AVPList-value {',
'    display: block;',
'    padding: 0;',
'    text-align: left;',
'}',
'',
'.a-AVPList--blocks .a-AVPList-label {',
'    font-size: 11px;',
'    color: #707070;',
'}',
'',
'.a-AVPList--blocks .a-AVPList-value {',
'    color: #404040;',
'    white-space: nowrap;',
'    text-overflow: ellipsis;',
'    overflow: hidden;',
'    font-family: monospace;',
'}',
'',
'/* Enable filtering / searching of settings, but do not allow click on header */',
'th#attr_settings > a {',
'    pointer-events: none;',
'    color: #404040;',
'}'))
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3145297382377009606.4024)
,p_plug_name=>'Application Defaults'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with lbls as (',
'    select ',
'        wwv_flow_lang.custom_runtime_message(''CA.table'')                  table_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.itemName'')               itemName_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.identification'')         identification_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.column'')                 column_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.name'')                   name_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.description'')            description_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.scope'')                  scope_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.dataType'')               dataType_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.sessionStateProtection'') sessionStateProtection_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.comments'')               comments_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.label'')                  label_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.formControl'')            formControl_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.includeOnForms'')         includeOnForms_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.includeOnReports'')       includeOnReports_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.listOfValues'')           listOfValues_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.formatMask'')             formatMask_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.staticDefault'')          staticDefault_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.type'')                   type_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.definition'')             definition_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.rowsPerPage'')            rowsPerPage_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.paginationMethod'')       paginationMeth_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.numberFormatMask'')       numberFormatMask_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.dateFormatMask'')         dateFormatMask_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.primaryDisplayColumn'')   primaryDisplayColumn_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.secondaryDisplayColumn'') secondaryDisplayColumn_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.suggestedVisulization'')  suggestedVisulization_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.labelSingular'')          labelSingular_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.labelPlural'')            labelPlural_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.primaryKeyColumn'')       primaryKeyColumn_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.labelColumn'')            labelColumn_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.primaryUse'')             primaryUse_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.primaryParentTable'')     primaryParentTable_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.tableColumn'')            tableColumn_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.general'')                general_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.displayColumn'')          displayColumn_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.keyColumn'')              keyColumn_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.function'')               function_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.valueColumn'')            valueColumn_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.maximumRows'')            maximumRows_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.query'')                  query_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.Form'')                   form_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.Reports'')                report_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.Metric'')                 metric_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.ApplicationItem'')        applicationItem_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.HELP'')                   help_l,',
'        wwv_flow_lang.custom_runtime_message(''CA.REQUIRED'')               required_l,',
'        --',
'       ''<span class="a-AVPList-item"><span class="a-AVPList-label">'' o1,',
'       ''</span>'' c1,',
'       ''<span class="a-AVPList-value">'' o2,',
'       ''</span></span>'' c2',
'    from dual',
')',
'select',
'    attribute_type,',
'    attribute_settings,',
'    last_updated,',
'    apex_page.get_url(p_page => edit_page, p_items => ''P''||edit_page||''_ID'', p_values => seq_id, p_clear_cache => edit_page) edit_link,',
'    OB,',
'    c040 sourced_from,',
'    wwv_flow_lang.system_message(''EDIT_LINK_TEXT'', wwv_flow_escape.html(attribute_type)) link_text',
'from (',
'    select ',
'        decode(upper(c002), ',
'              ''APPLICATION_ITEM'',l.applicationItem_l,',
'              ''TABLE_COLUMN'',l.tablecolumn_l,',
'              ''TABLE'',l.table_l,',
'              ''METRIC'',l.metric_l,',
'              ''LOV'',l.listOfValues_l,',
'              ''REPORT'',l.report_l,',
'              ''FORM'',l.form_l,',
'              apex_escape.html(c002)) attribute_type,',
'        decode(upper(c002), ',
'              ''APPLICATION_ITEM'',',
'                l.o1||l.itemName_l||l.c1||l.o2||apex_escape.html(c003)||l.c2||',
'                l.o1||l.scope_l||l.c1||l.o2||apex_escape.html(c004)||l.c2||',
'                l.o1||l.dataType_l||l.c1||l.o2||apex_escape.html(c005)||l.c2||',
'                l.o1||l.sessionStateProtection_l||l.c1||l.o2||apex_escape.html(c006)||l.c2||',
'                decode(trim(c007),null,null,l.o1||l.comments_l||l.c1||l.o2||apex_escape.html(c007)||l.c2),',
'              ''FORM'',',
'                l.o1||l.type_l||l.c1||l.o2||l.general_l||l.c2,',
'              ''TABLE_COLUMN'',',
'                l.o1||l.table_l||l.c1||l.o2||apex_escape.html(c003)||l.c2||',
'                l.o1||l.column_l||l.c1||l.o2||apex_escape.html(c004)||l.c2||',
'                l.o1||l.label_l||l.c1||l.o2||apex_escape.html(c005)||l.c2||',
'                decode(trim(c006),null,null,l.o1||l.formControl_l||l.c1||l.o2||apex_escape.html( wwv_flow_app_def_v3.get_json_page_component_name(c006) )||l.c2)||',
'                l.o1||l.includeOnForms_l||l.c1||l.o2||apex_escape.html(decode(c007,''Y'',''true'',''N'',''false'',c007))||l.c2||',
'                l.o1||l.includeOnReports_l||l.c1||l.o2||apex_escape.html(decode(c008,''Y'',''true'',''N'',''false'',c008))||l.c2||',
'                decode(trim(c009),null,null,l.o1||l.listOfValues_l||l.c1||l.o2||apex_escape.html(c009)||l.c2)||',
'                decode(trim(c010),null,null,l.o1||l.formatMask_l||l.c1||l.o2||apex_escape.html(c010)||l.c2)||',
'                decode(trim(c011),null,null,l.o1||l.staticDefault_l||l.c1||l.o2||apex_escape.html(c011)||l.c2)||',
'                decode(trim(c016),null,null,l.o1||l.required_l||l.c1||l.o2||apex_escape.html(decode(c016,''Y'',''true'',''N'',''false'',c016))||l.c2)||',
'                decode(trim(c014),null,null,l.o1||l.help_l||l.c1||l.o2||apex_escape.html(c014)||l.c2),',
'              ''LOV'',',
'                l.o1||l.name_l||l.c1||l.o2||apex_escape.html(c003)||l.c1||l.c1||',
'                l.o1||l.type_l||l.c1||l.o2||apex_escape.html(lower(c004))||l.c2||',
'                decode(trim(c005),null,null,l.o1||l.definition_l||l.c1||l.o2||apex_escape.html(c005)||l.c2)||',
'                decode(trim(c006),null,null,l.o1||l.table_l||l.c1||l.o2||apex_escape.html(c006)||l.c2)||',
'                decode(trim(c007),null,null,l.o1||l.displayColumn_l||l.c1||l.o2||apex_escape.html(c007)||l.c2)||',
'                decode(trim(c008),null,null,l.o1||l.keycolumn_l||l.c1||l.o2||apex_escape.html(c008)||l.c2),',
'              ''REPORT'',',
'                l.o1||l.rowsPerPage_l||l.c1||l.o2||apex_escape.html(c003)||l.c2||',
'                l.o1||l.paginationMeth_l||l.c1||l.o2||apex_escape.html(wwv_flow_app_def_v3.get_JSON_pagniation_type(c005))||l.c2||',
'                decode(trim(c006),null,null,l.o1||l.numberFormatMask_l||l.c1||l.o2||apex_escape.html(c006)||l.c2)||',
'                decode(trim(c009),null,null,l.o1||l.dateFormatMask_l||l.c1||l.o2||apex_escape.html(c009)||l.c2),',
'              ''TABLE'',',
'                l.o1||l.table_l||l.c1||l.o2||apex_escape.html(c003)||l.c2||',
'                l.o1||l.labelSingular_l||l.c1||l.o2||apex_escape.html(c004)||l.c2||',
'                l.o1||l.labelPlural_l||l.c1||l.o2||apex_escape.html(c005)||l.c2||',
'                decode(trim(c006),null,null,l.o1||l.primaryDisplayColumn_l||l.c1||l.o2||apex_escape.html(c006)||l.c2)||',
'                decode(trim(c007),null,null,l.o1||l.secondaryDisplayColumn_l||l.c1||l.o2||apex_escape.html(c007)||l.c2)||',
'                decode(trim(c008),null,null,l.o1||l.primaryKeyColumn_l||l.c1||l.o2||apex_escape.html(c008)||l.c2),',
'                --decode(trim(c009),null,null,l.o1||l.primaryParentTable_l||l.c1||l.o2||apex_escape.html(c009)||l.c2),',
'              ''METRIC'',',
'                l.o1||l.name_l||l.c1||l.o2||apex_escape.html(c003)||l.c2||',
'                l.o1||l.type_l||l.c1||l.o2||apex_escape.html(c004)||l.c2||',
'                l.o1||l.suggestedVisulization_l||l.c1||l.o2||apex_escape.html(c005)||l.c2||',
'                decode(trim(c006),null,null,l.o1||l.table_l||l.c1||l.o2||apex_escape.html(c006)||l.c2)||',
'                decode(trim(c007),null,null,l.o1||l.labelColumn_l||l.c1||l.o2||apex_escape.html(c007)||l.c2)||',
'                decode(trim(c008),null,null,l.o1||l.function_l||l.c1||l.o2||apex_escape.html(c008)||l.c2)||',
'                decode(trim(c009),null,null,l.o1||l.valueColumn_l||l.c1||l.o2||apex_escape.html(c009)||l.c2)||',
'                decode(trim(c010),null,null,l.o1||l.maximumRows_l||l.c1||l.o2||apex_escape.html(c010)||l.c2)||',
'                decode(trim(c011),null,null,l.o1||l.query_l||l.c1||l.o2||apex_escape.html(c011)||l.c2),',
'              c003) attribute_settings,',
'        decode(upper(c002), ',
'              ''DESCRIPTION'',''360'',',
'              ''APPLICATION_ITEM'',''350'',',
'              ''TABLE_COLUMN'', ''310'',',
'              ''LOV'',''320'',',
'              ''REPORT'',''340'',',
'              ''METRIC'',''370'',',
'              ''TABLE'',''430'',',
'              ''#'') edit_page,',
'        d001 last_updated,',
'        seq_id,',
'        decode(upper(c002), ',
'            ''TABLE'', ''01''||c003,',
'            ''TABLE_COLUMN'',''01''||c003||''.''||c004,',
'            ''02''||c002||''.''||c003) OB,',
'        c040',
'    from apex_collections c, lbls l',
'    where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and ',
'          c002 != ''DESCRIPTION'' and ',
'          c002 != ''LOV_DATA''',
') c',
'order by 5',
''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(3145297412606009607.4024)
,p_max_row_count=>'1000000'
,p_max_rows_per_page=>'100000'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_owner=>'MIKE'
,p_internal_uid=>3145297412606009607
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(2940047455175003243.4024)
,p_db_column_name=>'EDIT_LINK'
,p_display_order=>10
,p_column_identifier=>'V'
,p_column_label=>'<span class="u-VisuallyHidden">Modifica</span>'
,p_column_link=>'#EDIT_LINK#'
,p_column_linktext=>'<img src="#IMAGE_PREFIX#app_ui/img/icons/apex-edit-pencil.png" class="apex-edit-pencil" alt="#LINK_TEXT#">'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(3145299438285009627.4024)
,p_db_column_name=>'ATTRIBUTE_SETTINGS'
,p_display_order=>30
,p_column_identifier=>'R'
,p_column_label=>'Impostazioni'
,p_column_html_expression=>'<div class="a-AVPList a-AVPList--blocks">#ATTRIBUTE_SETTINGS#</div>'
,p_allow_sorting=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_heading_alignment=>'LEFT'
,p_static_id=>'attr_settings'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(3145299737570009630.4024)
,p_db_column_name=>'ATTRIBUTE_TYPE'
,p_display_order=>50
,p_column_identifier=>'U'
,p_column_label=>'Attributo'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(3302183738582908704.4024)
,p_db_column_name=>'LAST_UPDATED'
,p_display_order=>60
,p_column_identifier=>'W'
,p_column_label=>'Aggiornamento'
,p_column_type=>'DATE'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(3504378962894326219.4024)
,p_db_column_name=>'OB'
,p_display_order=>70
,p_column_identifier=>'X'
,p_column_label=>'Nome oggetto'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(3504379178256326221.4024)
,p_db_column_name=>'SOURCED_FROM'
,p_display_order=>80
,p_column_identifier=>'Y'
,p_column_label=>'Origine - Da'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(247044351762377608.4024)
,p_db_column_name=>'LINK_TEXT'
,p_display_order=>90
,p_column_identifier=>'Z'
,p_column_label=>'Testo collegamento'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3145298064428009613.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--slimPadding:a-ButtonRegion--noUI'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3302186513250908732.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(3145298064428009613.4024)
,p_button_name=>'EDIT_DEFAULTS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Modifica valori predefiniti'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:360:&SESSION.::&DEBUG.:RP,360:P360_ID:1'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3775764374844368406.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(3145298064428009613.4024)
,p_button_name=>'VIEW_JSON'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Visualizza JSON'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:250:&SESSION.::&DEBUG.:RP::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3504377853063326208.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(3145298064428009613.4024)
,p_button_name=>'Reset'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Reimposta'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3171727377240100414.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(3145298064428009613.4024)
,p_button_name=>'ADD'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aggiungi componente'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3165201469772852632.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(3145298064428009613.4024)
,p_button_name=>'RETURN'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(2988804730938183125.4024)
,p_button_image_alt=>'Torna alla creazione guidata applicazione'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP::'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3311213706143042513.4024)
,p_name=>'Refresh on Add / Edit JSON'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(3145298064428009613.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3311213808853042514.4024)
,p_event_id=>wwv_flow_api.id(3311213706143042513.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(3145297382377009606.4024)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3311213930056042515.4024)
,p_name=>'Refresh on Edit'
,p_event_sequence=>20
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(3145297382377009606.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3311214084567042516.4024)
,p_event_id=>wwv_flow_api.id(3311213930056042515.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(3145297382377009606.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3504378201458326212.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Reset App Defaults'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_app_def_v3.gen_apply_app_defaults_sql(',
'        p_app_defaults => wwv_flow_app_def_v3.gen_sample_app_defaults );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(3504377853063326208.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3398687947504765505.4024)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'sync_app_defaults'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_app_def_v3.sync_app_defaults (',
'    p_schema              => :P1_SCHEMA,',
'    p_learn_app_def       => ( nvl(:P5_LEARN_UI_DEF_YN, ''N'') = ''Y'' ),',
'    p_learn_existing_apps => ( nvl(:P5_LEARN_YN,''N'') = ''Y'' ),',
'    p_base_table_prefix   => :P5_BASE_TABLE_PREFIX,',
'    p_seed_from_app_id    => :P5_SEED_FROM_APP  );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00300
begin
wwv_flow_api.create_page(
 p_id=>300.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Aggiungi componente condiviso'
,p_page_mode=>'MODAL'
,p_step_title=>'Aggiungi componente condiviso'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3165201010909852628.4024)
,p_plug_name=>'Form'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3165201347779852631.4024)
,p_branch_name=>'Branch to Page Item Attribute'
,p_branch_action=>'f?p=&APP_ID.:310:&SESSION.::&DEBUG.:RP,310::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P300_ATTRIBUTE_TYPE'
,p_branch_condition_text=>'TABLE_COLUMN'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3302185675220908723.4024)
,p_branch_name=>'Branch to LOV'
,p_branch_action=>'f?p=&APP_ID.:320:&SESSION.::&DEBUG.:RP,320::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P300_ATTRIBUTE_TYPE'
,p_branch_condition_text=>'LOV'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3302185749229908724.4024)
,p_branch_name=>'Branch to application item'
,p_branch_action=>'f?p=&APP_ID.:350:&SESSION.::&DEBUG.:RP,350::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P300_ATTRIBUTE_TYPE'
,p_branch_condition_text=>'APPLICATION_ITEM'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3302185966975908726.4024)
,p_branch_name=>'Branch to report'
,p_branch_action=>'f?p=&APP_ID.:340:&SESSION.::&DEBUG.:RP,340::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>40
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P300_ATTRIBUTE_TYPE'
,p_branch_condition_text=>'REPORT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3398687563428765501.4024)
,p_branch_name=>'Branch to table'
,p_branch_action=>'f?p=&APP_ID.:430:&SESSION.::&DEBUG.:RP,430::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>50
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P300_ATTRIBUTE_TYPE'
,p_branch_condition_text=>'TABLE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3398687621164765502.4024)
,p_branch_name=>'Branch to metrics'
,p_branch_action=>'f?p=&APP_ID.:370:&SESSION.::&DEBUG.:RP,370::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>60
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P300_ATTRIBUTE_TYPE'
,p_branch_condition_text=>'METRIC'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165201104877852629.4024)
,p_name=>'P300_ATTRIBUTE_TYPE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(3165201010909852628.4024)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tipo di attributo'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.WIZARD_SELECTION'
,p_named_lov=>'ATTRIBUTE_TYPES'
,p_lov=>'.'||wwv_flow_api.id(3174322299274441758.4024)||'.'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'S'
,p_attribute_02=>'Y'
);
end;
/
prompt --application/pages/page_00310
begin
wwv_flow_api.create_page(
 p_id=>310.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Attributo colonna tabella'
,p_page_mode=>'MODAL'
,p_step_title=>'Attributo colonna tabella'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_dialog_width=>'640'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3165199154732852609.4024)
,p_plug_name=>'Identificazione'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_plug_name=>'Impostazioni'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3165200470552852622.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3348512942953385903.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(3165200470552852622.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:TABLE_COLUMN_ATTRIBUTE'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3165200574372852623.4024)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(3165200470552852622.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P310_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413428923693144818.4024)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(3165200470552852622.4024)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aggiungi impostazione predefinita attributo'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P310_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413425189221121582.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(3165200470552852622.4024)
,p_button_name=>'PREV'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Precedente'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::'
,p_button_condition=>'P310_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3165200697778852624.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(3165200470552852622.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3399173947389626661.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(3165200470552852622.4024)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--gapLeft'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Elimina attributo'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_condition_type=>'NEVER'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165199280082852610.4024)
,p_name=>'P310_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(3165199154732852609.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165199343513852611.4024)
,p_name=>'P310_TABLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(3165199154732852609.4024)
,p_prompt=>'Tabella'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'AVAILABLE_TABLE_VIEWS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, object_name v',
'  from sys.dba_objects',
' where object_type in (''TABLE'',''VIEW'')',
'   and object_name not like ''BIN$%''',
'   and owner = :P1_SCHEMA',
'   and owner in (select schema',
'                     from wwv_flow_company_schemas',
'                    where security_group_id = :flow_security_group_id)',
' order by 1'))
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165199490675852612.4024)
,p_name=>'P310_COLUMN'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(3165199154732852609.4024)
,p_prompt=>'Colonna'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) D, column_name R',
'from sys.dba_tab_columns',
'where  owner = :P1_SCHEMA',
'and owner in (select schema',
'                from wwv_flow_company_schemas',
'               where security_group_id = :flow_security_group_id)',
'  and table_name = :P310_TABLE',
'  and (data_type in (''VARCHAR2'',''NUMBER'',''FLOAT'',''DATE'') or data_type like (''TIMESTAMP%''))',
'order by column_id'))
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165199779910852615.4024)
,p_name=>'P310_LABEL'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_prompt=>'Etichetta'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165199881527852616.4024)
,p_name=>'P310_FORM_CONTROL'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_item_default=>'TEXT'
,p_prompt=>'Controllo form'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ITEM_DISPLAY_TYPES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select display_name d, name_with_prefix r',
'from wwv_flow_native_plugins',
'where plugin_type = ''ITEM TYPE''',
'and name_with_prefix in (',
'    ''NATIVE_TEXT_FIELD'',',
'    ''NATIVE_TEXTAREA'',',
'    ''NATIVE_SELECT_LIST'',',
'    ''NATIVE_POPUP_LOV'',',
'    ''NATIVE_RADIOGROUP'',',
'    ''NATIVE_CHECKBOX'',',
'    ''NATIVE_YES_NO'',',
'    ''NATIVE_HIDDEN'',',
'    ''NATIVE_DATE_PICKER'',',
'    ''NATIVE_NUMBER_FIELD'',',
'    ''NATIVE_TEXTAREA'',',
'    ''NATIVE_FILE'')',
'order by 1'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165199918382852617.4024)
,p_name=>'P310_INCLUDE_ON_FORMS'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_item_default=>'Y'
,p_prompt=>'Includi in form'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165200005104852618.4024)
,p_name=>'P310_INCLUDE_ON_REPORTS'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_item_default=>'Y'
,p_prompt=>'Includi in report'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165200188885852619.4024)
,p_name=>'P310_LIST_OF_VALUES'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_item_default=>'0'
,p_prompt=>'Lista di valori'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c003||'' - ''||c004 d,',
'       c003 r',
'from apex_collections ',
'where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and',
'      c002 = ''LOV''',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Non specificata o non applicabile -'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165200278962852620.4024)
,p_name=>'P310_FORMAT_MASK'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_prompt=>'Formato di visualizzazione'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'FORMAT MASK DYNAMIC'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from wwv_flow_format_masks'))
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_03=>'N'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165200367649852621.4024)
,p_name=>'P310_STATIC_DEFAULT'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_prompt=>'Valore predefinito statico'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302186977757908736.4024)
,p_name=>'P310_COMMENTS'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_prompt=>'Commenti'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cHeight=>5
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302187004171908737.4024)
,p_name=>'P310_HELP'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_prompt=>'?'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302187144353908738.4024)
,p_name=>'P310_WIDTH'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302187242801908739.4024)
,p_name=>'P310_MAXIMUM_WIDTH'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302187326328908740.4024)
,p_name=>'P310_REQUIRED'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(3165199598158852613.4024)
,p_item_default=>'N'
,p_prompt=>'Richiesto'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3172048171795109037.4024)
,p_validation_name=>'lov required'
,p_validation_sequence=>10
,p_validation=>'P310_LIST_OF_VALUES'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#'
,p_validation_condition=>':P310_FORM_CONTROL in (wwv_flow_native_item.c_select_list, wwv_flow_native_item.c_popup_lov, wwv_flow_native_item.c_yes_no, wwv_flow_native_item.c_radiogroup, wwv_flow_native_item.c_checkbox )'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3165200716200852625.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3165200697778852624.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3165200807942852626.4024)
,p_event_id=>wwv_flow_api.id(3165200716200852625.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3171727591584100416.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save back to collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'   l_name varchar2(4000) := null;',
'begin',
'    for c1 in (select c001 ',
'               from apex_collections ',
'               where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P310_ID) loop',
'       l_name := c1.c001;',
'    end loop;',
'    ',
'    if :REQUEST = ''DELETE'' then',
'        APEX_COLLECTION.DELETE_MEMBER (',
'            p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'            p_seq             => :P320_ID);',
'    else',
'        if :P310_ID is not null then',
'      ',
'            APEX_COLLECTION.UPDATE_MEMBER (',
'                p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'                p_seq             => :P310_ID,',
'                p_c001            => l_name,',
'                p_c002            => ''TABLE_COLUMN'',',
'                p_c003            => :P310_TABLE ,',
'                p_c004            => :p310_column,',
'                p_c005            => :p310_label,',
'                p_c006            => :p310_form_CONTROL,',
'                p_c007            => :P310_include_on_forms,',
'                p_c008            => :P310_include_on_reports,',
'                p_c009            => :P310_LIST_OF_VALUES,',
'                p_c010            => :p310_format_mask,',
'                p_c011            => :p310_static_default,',
'                p_c012            => :p310_comments,',
'                p_c013            => :p310_help,',
'                p_c014            => :P310_WIDTH,',
'                p_c015            => :P310_MAXIMUM_WIDTH,',
'                p_c016            => :P310_REQUIRED,',
'                p_d001            => sysdate',
'                );',
'                ',
'        else',
'        ',
'            APEX_COLLECTION.ADD_MEMBER (',
'                p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'                p_c001            => ''attribute defaults'',',
'                p_c002            => ''PAGE_ITEM'',',
'                p_c003            => :P310_TABLE ,',
'                p_c004            => :p310_column,',
'                p_c005            => :p310_label,',
'                p_c006            => :p310_form_CONTROL,',
'                p_c007            => :P310_include_on_forms,',
'                p_c008            => :P310_include_on_reports,',
'                p_c009            => :P310_LIST_OF_VALUES,',
'                p_c010            => :p310_format_mask,',
'                p_c011            => :p310_static_default,',
'                p_c012            => :p310_comments,',
'                p_c013            => :p310_help,',
'                p_c014            => :P310_WIDTH,',
'                p_c015            => :P310_MAXIMUM_WIDTH,',
'                 --p_c016            => :P310_REQUIRED,',
'                p_d001            => sysdate',
'                );',
'                ',
'        end if;',
'    end if;',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3311214178033042517.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3171727440794100415.4024)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch data from collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select * ',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P310_ID) loop',
'   :P310_TABLE              := C1.C003;',
'   :P310_COLUMN             := C1.C004;',
'   :P310_LABEL              := C1.C005;',
'   :P310_FORM_CONTROL       := C1.C006;',
'   :P310_INCLUDE_ON_FORMS   := C1.C007;',
'   :P310_INCLUDE_ON_REPORTS := C1.C008;',
'   :P310_LIST_OF_VALUES     := C1.C009;',
'   :P310_FORMAT_MASK        := C1.C010;',
'   :P310_STATIC_DEFAULT     := C1.C011;',
'   :P310_COMMENTS           := C1.C012;',
'   :P310_HELP               := C1.C013;',
'   :P310_WIDTH              := C1.C014;',
'   :P310_MAXIMUM_WIDTH      := C1.C015;',
'   :P310_required           := NVL(C1.C016,''N'');',
'end loop;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00320
begin
wwv_flow_api.create_page(
 p_id=>320.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Attributo lista di valori'
,p_page_mode=>'MODAL'
,p_step_title=>'Attributo lista di valori'
,p_autocomplete_on_off=>'OFF'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'(function( $ ){',
'',
'    var notAdded = function( elem ) {',
'        return $( elem ).closest( ''tr'' ).next()[0] ? false : true;',
'    };',
'',
'    var addRow = function( elem ){',
'        var tr$ = $( elem ).parent().parent(),',
'            seq = parseInt( tr$.find( ''[name=f01]'' ).val() );',
'        tr$',
'            .clone()',
'            .appendTo( tr$.parent() )',
'            .find( ''input'' )',
'            .val('''')',
'            .first()',
'            .val( seq + 10 );',
'    };',
'    // add row if return value field has value',
'    $( ''#static_lov_region'' )',
'        .on( ''input'', ''[name=f03]'', function(){',
'            if ( notAdded( this ) ) {',
'                addRow( this );',
'            }',
'        });',
'})( apex.jQuery );'))
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.stretch-input {',
'    width: 100%;',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_dialog_width=>'640'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(160013862315808234.4024)
,p_name=>'LOV statica'
,p_region_name=>'static_lov_region'
,p_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_region_attributes=>'style="margin: 12px 24px"'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'       APEX_ITEM.TEXT(p_idx => 1, p_value => NVL(n002,10), p_attributes => ''class="stretch-input u-tE"'') display_sequence, ',
'       APEX_ITEM.TEXT(p_idx => 2, p_value => c005, p_attributes => ''class="stretch-input"'') display_value, ',
'       APEX_ITEM.TEXT(p_idx => 3, p_value => c006, p_attributes => ''class="stretch-input"'') return_value',
'from   apex_collections ',
'where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and',
'      c002 = ''LOV_DATA'' and',
'      n001 in (',
'          select n001',
'            from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and',
'                 c002 = ''LOV'' and',
'                 seq_id = :P320_ID)',
'union all',
'-- extra row to add a new lov entry member',
'select ',
'       APEX_ITEM.TEXT(p_idx => 1, p_value => NVL( (select max(n002) + 10 from apex_collections ',
'               where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and',
'                     c002 = ''LOV_DATA'' and',
'                     n001 in (',
'                          select n001',
'                            from apex_collections ',
'                           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and',
'                                 c002 = ''LOV'' and',
'                                 seq_id = :P320_ID)), 10 ), p_attributes => ''class="stretch-input u-tE"'')   display_sequence,',
'       APEX_ITEM.TEXT(p_idx => 2, p_value => null, p_attributes => ''class="stretch-input"'') display_value,',
'       APEX_ITEM.TEXT(p_idx => 3, p_value => null, p_attributes => ''class="stretch-input"'') return_value',
'from  dual',
'order by 1, 2'))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(2707641403506668051.4024)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3504378521998326215.4024)
,p_query_column_id=>1
,p_column_alias=>'DISPLAY_SEQUENCE'
,p_column_display_sequence=>1
,p_column_heading=>'Sequenza'
,p_use_as_row_header=>'N'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_report_column_width=>64
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3504378620602326216.4024)
,p_query_column_id=>2
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>2
,p_column_heading=>'Valore visualizzato'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(160014072843808236.4024)
,p_query_column_id=>3
,p_column_alias=>'RETURN_VALUE'
,p_column_display_sequence=>3
,p_column_heading=>'Valore restituito'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3661793287320803714.4024)
,p_plug_name=>'Lista di valori strutturata'
,p_region_template_options=>'#DEFAULT#:a-Form--leftLabels:a-Form--fixedLabels'
,p_region_attributes=>'style="margin: 12px 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6512260336253636702.4024)
,p_plug_name=>'Lista di valori'
,p_region_template_options=>'#DEFAULT#:a-Form--autoWidthLabels'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6512261652073636715.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3348520762265408138.4024)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(6512261652073636715.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:LOV_ATTRIBUTE'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3347065349315784120.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(6512261652073636715.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P320_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3398990882243869202.4024)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(6512261652073636715.4024)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aggiungi impostazione predefinita attributo'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P320_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3347064994581784118.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(6512261652073636715.4024)
,p_button_name=>'PREV'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Precedente'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::'
,p_button_condition=>'P320_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3347065773578784121.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(6512261652073636715.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3398990937748869203.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(6512261652073636715.4024)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--gapLeft'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Elimina attributo'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_condition=>'P320_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302184199465908708.4024)
,p_name=>'P320_STATIC_VALUES'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(6512260336253636702.4024)
,p_item_default=>'static2:Display1,Value1;Display2,Value2'
,p_prompt=>'Lista di valori statica'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.CODE_EDITOR'
,p_cSize=>30
,p_cHeight=>5
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(3076592627306440115.4024)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'SQL'
,p_attribute_02=>'VARCHAR2'
,p_attribute_03=>'Y'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302184241493908709.4024)
,p_name=>'P320_LOV_NAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(6512260336253636702.4024)
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302185246688908719.4024)
,p_name=>'P320_TABLE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(3661793287320803714.4024)
,p_prompt=>'Tabella'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AVAILABLE_TABLE_VIEWS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, object_name v',
'  from sys.dba_objects',
' where object_type in (''TABLE'',''VIEW'')',
'   and object_name not like ''BIN$%''',
'   and owner = :P1_SCHEMA',
'   and owner in (select schema',
'                     from wwv_flow_company_schemas',
'                    where security_group_id = :flow_security_group_id)',
' order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona tabella o vista -'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302185342889908720.4024)
,p_name=>'P320_DISPLAY_COLUMN'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(3661793287320803714.4024)
,p_prompt=>'Colonna di visualizzazione'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) D, column_name R',
'from sys.dba_tab_columns',
'where  owner = :P1_SCHEMA',
'and owner in (select schema',
'                from wwv_flow_company_schemas',
'               where security_group_id = :flow_security_group_id)',
'  and table_name = :P320_TABLE',
'  and (data_type in (''VARCHAR2'',''NUMBER'',''FLOAT'',''DATE'') or data_type like (''TIMESTAMP%''))',
'order by column_id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P320_TABLE'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302185412215908721.4024)
,p_name=>'P320_ID_COLUMN'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(3661793287320803714.4024)
,p_prompt=>'Colonna chiave'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) D, column_name R',
'from sys.dba_tab_columns',
'where  owner = :P1_SCHEMA',
'and owner in (select schema',
'                from wwv_flow_company_schemas',
'               where security_group_id = :flow_security_group_id)',
'  and table_name = :P320_TABLE',
'  and (data_type in (''VARCHAR2'',''NUMBER'',''FLOAT'',''DATE'') or data_type like (''TIMESTAMP%''))',
'order by column_id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P320_TABLE'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3347061847342784108.4024)
,p_name=>'P320_SQL_QUERY'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(6512260336253636702.4024)
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ename as d, empno as r',
'from emp',
'order by 1'))
,p_prompt=>'Query SQL'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.CODE_EDITOR'
,p_cSize=>30
,p_cHeight=>5
,p_tag_attributes=>'style="margin-top: 12px;"'
,p_field_template=>wwv_flow_api.id(3076592627306440115.4024)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'SQL'
,p_attribute_02=>'VARCHAR2'
,p_attribute_03=>'Y'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3347066430417784121.4024)
,p_name=>'P320_ID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(6512260336253636702.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3347066894559784122.4024)
,p_name=>'P320_LOV_TYPE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(6512260336253636702.4024)
,p_item_default=>'STRUCTURED'
,p_prompt=>'Tipo'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'LOV TYPE'
,p_lov=>'.'||wwv_flow_api.id(3363550887091219855.4024)||'.'
,p_tag_css_classes=>'apex-button-group'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'3'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3661792982676803711.4024)
,p_name=>'P320_ORDER_COLUMN'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(3661793287320803714.4024)
,p_prompt=>'Ordina per colonna'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) D, column_name R',
'from sys.dba_tab_columns',
'where  owner = :P1_SCHEMA',
'and owner in (select schema',
'                from wwv_flow_company_schemas',
'               where security_group_id = :flow_security_group_id)',
'  and table_name = :P320_TABLE',
'  and (data_type in (''VARCHAR2'',''NUMBER'',''FLOAT'',''DATE'') or data_type like (''TIMESTAMP%''))',
'order by column_id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'Ordina per colonna di visualizzazione'
,p_lov_null_value=>'0'
,p_lov_cascade_parent_items=>'P320_TABLE'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3414639042759610188.4024)
,p_validation_name=>'Check for Duplicate structured LOVs'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_error_msg varchar2(255) := wwv_flow_lang.custom_runtime_message(''CA.ATTR.DEFAULT.DUPLICATE'',''structured list of values on this table'');',
'begin',
'  for c1 in (select c001',
'             from apex_collections ',
'             where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' ',
'             and   c004 = ''structured''',
'             and   c006 = :P320_TABLE',
'             and   seq_id <> nvl(:P430_ID,0)',
'            ) loop',
'     return l_error_msg; ',
'  end loop;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_validation_condition=>'DELETE'
,p_validation_condition_type=>'REQUEST_NOT_EQUAL_CONDITION'
,p_associated_item=>wwv_flow_api.id(3302185246688908719.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3019481208024899637.4024)
,p_validation_name=>'Table NN for Structured'
,p_validation_sequence=>20
,p_validation=>'P320_TABLE'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>'P320_LOV_TYPE'
,p_validation_condition2=>'STRUCTURED'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_associated_item=>wwv_flow_api.id(3302185246688908719.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3019481303250899638.4024)
,p_validation_name=>'Display Column NN for Structured'
,p_validation_sequence=>40
,p_validation=>'P320_DISPLAY_COLUMN'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>'P320_LOV_TYPE'
,p_validation_condition2=>'STRUCTURED'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_associated_item=>wwv_flow_api.id(3302185342889908720.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3019481407358899639.4024)
,p_validation_name=>'Key Column NN for Structured'
,p_validation_sequence=>50
,p_validation=>'P320_ID_COLUMN'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>'P320_LOV_TYPE'
,p_validation_condition2=>'STRUCTURED'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_associated_item=>wwv_flow_api.id(3302185412215908721.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3019481544009899640.4024)
,p_validation_name=>'SQL Query NN for Dynamic'
,p_validation_sequence=>60
,p_validation=>'P320_SQL_QUERY'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>'P320_LOV_TYPE'
,p_validation_condition2=>'DYNAMIC'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_associated_item=>wwv_flow_api.id(3347061847342784108.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3019481631577899641.4024)
,p_validation_name=>'Static Values NN for Static Values'
,p_validation_sequence=>70
,p_validation=>'P320_STATIC_VALUES'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition_type=>'NEVER'
,p_associated_item=>wwv_flow_api.id(3302184199465908708.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3347068736917784138.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3347065773578784121.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3347069231858784141.4024)
,p_event_id=>wwv_flow_api.id(3347068736917784138.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3661791977005803701.4024)
,p_name=>'Handle LOV Type'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P320_LOV_TYPE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3661792000458803702.4024)
,p_event_id=>wwv_flow_api.id(3661791977005803701.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var lovType = $v(''P320_LOV_TYPE'');',
'var stuctured_lov$ = $(''#P320_TABLE_CONTAINER, #P320_DISPLAY_COLUMN_CONTAINER, #P320_ID_COLUMN_CONTAINER, #P320_ORDER_COLUMN_CONTAINER'');',
'var dynamic_lov$ = $(''#P320_SQL_QUERY_CONTAINER'');',
'var static_lov$ = $(''#static_lov_region'');',
'',
'stuctured_lov$.hide();',
'dynamic_lov$.hide();',
'static_lov$.hide();',
'',
'if (lovType === ''STRUCTURED'') {',
'  stuctured_lov$.show();',
'} else if (lovType === ''DYNAMIC'') {',
'  dynamic_lov$.show();',
'} else if (lovType === ''STATIC'') {',
'  static_lov$.show();',
'}'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3347067944610784136.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save back to collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'   l_name           varchar2(4000) := null;',
'   l_lov            varchar2(32767) := null;',
'   l_n001           number := null;',
'   l_disp_seq       integer := 0;',
'   l_order_by       varchar2(255);',
'begin',
'for c1 in (select c001, n001',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P320_ID) loop',
'   l_name := c1.c001;',
'   l_n001 := c1.n001;',
'end loop;',
'',
'if :REQUEST = ''DELETE'' then',
'    APEX_COLLECTION.DELETE_MEMBER (',
'        p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'        p_seq             => :P320_ID);',
'else',
'    -- determine lov attributes',
'    if lower(:P320_LOV_TYPE) = ''dynamic'' then',
'       l_lov := :P320_SQL_QUERY;',
'    end if;',
'    ',
'    -- set collection values',
'    if lower(:P320_LOV_TYPE) = ''static'' then',
'        if :P320_ID is not null then',
'            -- remove existing static list of values collection members',
'            for c2 in (',
'               select seq_id ',
'               from  apex_collections ',
'               where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and ',
'                     c002 = ''LOV_DATA'' and ',
'                     n001 = l_n001) loop',
'                   APEX_COLLECTION.DELETE_MEMBER(p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'', p_seq=>c2.seq_id);',
'            end loop;',
'        end if;',
'        ',
'        -- add new static values',
'        if :P320_ID is null then',
'            -- add parent lov collection member',
'            l_n001 := wwv_flow_id.next_val;',
'            APEX_COLLECTION.ADD_MEMBER (',
'                p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'                p_c001            => l_name,',
'                p_c002            => ''LOV'',',
'                p_c003            => upper(:P320_LOV_NAME),',
'                p_c004            => ''STATIC'',',
'                p_c005            => null,',
'                P_c006            => null,',
'                p_c007            => null,',
'                p_c008            => null,',
'                p_n001            => l_n001, -- lov join key to join parent lov name with child lov entries',
'                p_d001            => sysdate',
'                );',
'        else',
'            APEX_COLLECTION.UPDATE_MEMBER (',
'                p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'                p_seq             => :P320_ID,',
'                p_c001            => l_name,',
'                p_c002            => ''LOV'',',
'                p_c003            => upper(:P320_LOV_NAME),',
'                p_c004            => ''STATIC'',',
'                p_c005            => null,',
'                P_c006            => null,',
'                p_c007            => null,',
'                p_c008            => null,',
'                p_n001            => l_n001,',
'                p_d001            => sysdate',
'                );',
'        end if;',
'        ',
'        for i in 1..wwv_flow.g_f01.count loop',
'            l_disp_seq := l_disp_seq + 10;',
'            -- add lov member child rows',
'            if apex_application.g_f03(i) is not null and apex_application.g_f02(i) is not null then',
'                apex_collection.add_member (',
'                    p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'                    p_c001 => l_name,',
'                    p_c002 => ''LOV_DATA'',',
'                    p_c005 => apex_application.g_f02(i),',
'                    p_c006 => apex_application.g_f03(i),',
'                    p_n001 => l_n001,',
'                    p_n002 => l_disp_seq,',
'                    p_d001 => sysdate',
'                    );',
'            end if;',
'        end loop;',
'    else',
'        if :P320_ID is not null then',
'            APEX_COLLECTION.UPDATE_MEMBER (',
'                p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'                p_seq             => :P320_ID,',
'                p_c001            => l_name,',
'                p_c002            => ''LOV'',',
'                p_c003            => upper(:P320_LOV_NAME),',
'                p_c004            => :P320_LOV_TYPE,',
'                p_c005            => l_lov,',
'                P_c006            => :P320_TABLE,',
'                p_c007            => :P320_DISPLAY_COLUMN,',
'                p_c008            => :P320_ID_COLUMN,',
'                p_c009            => :P320_ORDER_COLUMN,',
'                p_d001            => sysdate',
'                );',
'        else',
'            APEX_COLLECTION.ADD_MEMBER (',
'                p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'                p_c001            => l_name,',
'                p_c002            => ''LOV'',',
'                p_c003            => upper(:P320_LOV_NAME),',
'                p_c004            => :P320_LOV_TYPE,',
'                p_c005            => l_lov,',
'                P_c006            => :P320_TABLE,',
'                p_c007            => :P320_DISPLAY_COLUMN,',
'                p_c008            => :P320_ID_COLUMN,',
'                p_c009            => :P320_ORDER_COLUMN,',
'                p_d001            => sysdate',
'                );',
'        end if;',
'    end if;',
'',
'end if;',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3347068302818784137.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3347067640770784135.4024)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch data from collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'    select * ',
'    from apex_collections ',
'    where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and ',
'          seq_id = :P320_ID) loop',
'          ',
'   :P320_LOV_NAME := C1.C003; ',
'   :P320_LOV_TYPE := upper(C1.C004);',
'   if lower(C1.C004) = ''static'' then ',
'      --:P320_STATIC_VALUES         := C1.C005;',
'      :P320_SQL_QUERY             := null;',
'   elsif lower(C1.C004) = ''dynamic'' then ',
'      --:P320_STATIC_VALUES         := null;',
'      :P320_SQL_QUERY             := C1.C005;',
'   else',
'      :P320_TABLE                 := c1.c006;',
'      :P320_DISPLAY_COLUMN        := c1.c007;',
'      :P320_ID_COLUMN             := c1.c008;',
'      :P320_ORDER_COLUMN          := c1.c009;',
'   end if;',
'   ',
'end loop;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00340
begin
wwv_flow_api.create_page(
 p_id=>340.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Attributi report'
,p_page_mode=>'MODAL'
,p_step_title=>'Attributi report'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_dialog_width=>'640'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(16557748491182994796.4024)
,p_plug_name=>'Report'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(16557749807002994809.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413432445171186417.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(16557749807002994809.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:REPORT_ATTRIBUTE'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3348535073365543309.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(16557749807002994809.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P340_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413434096915203320.4024)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(16557749807002994809.4024)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aggiungi impostazione predefinita attributo'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P340_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3348535876220543315.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(16557749807002994809.4024)
,p_button_name=>'PREV'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Precedente'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::'
,p_button_condition=>'P340_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3348535421704543314.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(16557749807002994809.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3399172753722601202.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(16557749807002994809.4024)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--gapLeft'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Elimina attributo'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_condition_type=>'NEVER'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302184569021908712.4024)
,p_name=>'P340_NUMERIC_FORMAT_MASK'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(16557748491182994796.4024)
,p_item_default=>'VARCHAR'
,p_prompt=>'Formato di visualizzazione numerico'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302184673340908713.4024)
,p_name=>'P340_DATE_FORMAT_MASK'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(16557748491182994796.4024)
,p_item_default=>'VARCHAR'
,p_prompt=>'Formato di visualizzazione data'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3348536510841543325.4024)
,p_name=>'P340_ROWS_PER_PAGE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(16557748491182994796.4024)
,p_prompt=>'Righe per pagina'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3348536955681543334.4024)
,p_name=>'P340_PAGINATION_METHOD'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(16557748491182994796.4024)
,p_item_default=>'NEXT_PREVIOUS_LINKS'
,p_prompt=>'Metodo di impaginazione'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PAGINATION'
,p_lov=>'.'||wwv_flow_api.id(3348566714295666169.4024)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3348538127232543336.4024)
,p_name=>'P340_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(16557748491182994796.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3348539709689543350.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3348535421704543314.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3348540225331543354.4024)
,p_event_id=>wwv_flow_api.id(3348539709689543350.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3348538994862543348.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save back to collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'   l_name varchar2(4000) := null;',
'begin',
'for c1 in (select c001',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P340_ID) loop',
'   l_name := c1.c001;',
'end loop;',
'',
'if :REQUEST = ''DELETE'' then',
'    APEX_COLLECTION.DELETE_MEMBER (',
'        p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'        p_seq             => :P320_ID);',
'else',
'    if :P340_ID is not null then',
'        APEX_COLLECTION.UPDATE_MEMBER (',
'            p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'            p_seq             => :P340_ID,',
'            p_c001            => l_name,',
'            p_c002            => ''REPORT'',',
'            p_c003            => :P340_ROWS_PER_PAGE,',
'            p_c005            => :P340_PAGINATION_METHOD,',
'            p_c006            => :P340_NUMERIC_FORMAT_MASK,',
'            p_c009            => :P340_DATE_FORMAT_MASK,',
'            p_d001            => sysdate',
'            );',
'            ',
'    else',
'    ',
'        APEX_COLLECTION.ADD_MEMBER (',
'            p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'            p_c001            => l_name,',
'            p_c002            => ''REPORT'',',
'            p_c003            => :P340_ROWS_PER_PAGE,',
'            p_c005            => :P340_PAGINATION_METHOD,',
'            p_c006            => :P340_NUMERIC_FORMAT_MASK,',
'            p_c009            => :P340_DATE_FORMAT_MASK,',
'            p_d001            => sysdate',
'            );',
'    end if;',
'end if;',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3348539352524543349.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3348538515225543345.4024)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch data from collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select * ',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P340_ID) loop',
'   :P340_ROWS_PER_PAGE          := C1.C003; ',
'   :P340_PAGINATION_METHOD      := C1.C005;',
'   :P340_NUMERIC_FORMAT_MASK    := C1.C006;',
'   :P340_DATE_FORMAT_MASK       := C1.C009;',
'end loop;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00350
begin
wwv_flow_api.create_page(
 p_id=>350.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Attributo elemento applicazione'
,p_page_mode=>'MODAL'
,p_step_title=>'Attributo elemento applicazione'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'fieldset.textarea {',
'    width: 100%;',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_dialog_width=>'640'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(13209214060330451553.4024)
,p_plug_name=>'Identificazione'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(13209215376150451566.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413435103918209273.4024)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(13209215376150451566.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:APP_ITEM_ATTRIBUTE'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3348482906620943332.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(13209215376150451566.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P350_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413435465052210463.4024)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(13209215376150451566.4024)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aggiungi impostazione predefinita attributo'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P350_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413434588859206469.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(13209215376150451566.4024)
,p_button_name=>'PREV'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Precedente'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::'
,p_button_condition=>'P350_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3348483347387943333.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(13209215376150451566.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3399171947930582197.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(13209215376150451566.4024)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--gapLeft'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Elimina attributo'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_condition=>'P350_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302184386601908710.4024)
,p_name=>'P350_PROTECTION_LEVEL'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(13209214060330451553.4024)
,p_item_default=>'RESTRICTED_NO_SET_FROM_BROWSER'
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'APP ITEM PROTECTION LEVEL'
,p_lov=>'.'||wwv_flow_api.id(3348521895514426469.4024)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302184404464908711.4024)
,p_name=>'P350_DATA_TYPE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(13209214060330451553.4024)
,p_item_default=>'VARCHAR'
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>'STATIC2:NUMBER;NUMBER,VARCHAR;VARCHAR'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3348484492788943334.4024)
,p_name=>'P350_DESCRIPTION'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(13209214060330451553.4024)
,p_prompt=>'Descrizione'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>5
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3348485161446943335.4024)
,p_name=>'P350_NAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(13209214060330451553.4024)
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3348485563930943336.4024)
,p_name=>'P350_ID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(13209214060330451553.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3348487139406943338.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3348483347387943333.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3348487623366943338.4024)
,p_event_id=>wwv_flow_api.id(3348487139406943338.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3348486307197943337.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save back to collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'   l_name varchar2(4000) := null;',
'begin',
'for c1 in (select c001',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P350_ID) loop',
'   l_name := c1.c001;',
'end loop;',
'',
'if :REQUEST = ''DELETE'' then',
'    APEX_COLLECTION.DELETE_MEMBER (',
'        p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'        p_seq             => :P320_ID);',
'else',
'    if l_name is not null then',
'        APEX_COLLECTION.UPDATE_MEMBER (',
'            p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'            p_seq             => :P350_ID,',
'            p_c001            => l_name,',
'            p_c002            => ''APPLICATION_ITEM'',',
'            p_c003            => :P350_NAME ,',
'            p_c004            => :P350_DESCRIPTION,',
'            p_c005            => :P350_DATA_TYPE,',
'            p_c006            => :P350_PROTECTION_LEVEL,',
'            p_d001            => sysdate',
'            );',
'    else',
'        APEX_COLLECTION.ADD_MEMBER (',
'            p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'            p_c001            => l_name,',
'            p_c002            => ''APPLICATION_ITEM'',',
'            p_c003            => :P350_NAME ,',
'            p_c004            => :P350_DESCRIPTION,',
'            p_c005            => :P350_DATA_TYPE,',
'            p_c006            => :P350_PROTECTION_LEVEL,',
'            p_d001            => sysdate',
'            );',
'            ',
'    end if;',
'end if;',
'',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3348486702879943337.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3348485937407943337.4024)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch data from collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select * ',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P350_ID) loop',
'   :P350_NAME              := C1.C003; ',
'   :P350_DESCRIPTION       := C1.C004;',
'   :P350_PROTECTION_LEVEL  := c1.C006;',
'   :P350_DATA_TYPE         := c1.C005;',
'end loop;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00360
begin
wwv_flow_api.create_page(
 p_id=>360.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Impostazioni predefinite attributi'
,p_page_mode=>'MODAL'
,p_step_title=>'Impostazioni predefinite attributi'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'fieldset.textarea {',
'    width: 100%;',
'}'))
,p_page_css_classes=>'a-PageWizard-dialog'
,p_page_template_options=>'#DEFAULT#'
,p_dialog_width=>'640'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9860731784394508223.4024)
,p_plug_name=>'Valori predefiniti applicazione'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(9860733100214508236.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3348472554245871537.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(9860733100214508236.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3348472124424871535.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(9860733100214508236.4024)
,p_button_name=>'PREV'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Precedente'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::'
,p_button_condition_type=>'NEVER'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3348472949876871537.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(9860733100214508236.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3348473679834871547.4024)
,p_name=>'P360_DESCRIPTION'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(9860731784394508223.4024)
,p_prompt=>'Descrizione'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>5
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3348474395392871549.4024)
,p_name=>'P360_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(9860731784394508223.4024)
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3348474768226871550.4024)
,p_name=>'P360_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(9860731784394508223.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3398688431885765510.4024)
,p_name=>'P360_TABLE_PREFIX'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(9860731784394508223.4024)
,p_prompt=>'Prefissi tabelle'
,p_placeholder=>'HR_, OE_'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3348477337785871572.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3348472949876871537.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3348477811897871574.4024)
,p_event_id=>wwv_flow_api.id(3348477337785871572.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3348476532811871570.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save back to collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'   l_name varchar2(4000) := null;',
'begin',
'for c1 in (select c001',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P360_ID) loop',
'   l_name := c1.c001;',
'end loop;',
'',
'',
'if l_name is not null then',
'    APEX_COLLECTION.UPDATE_MEMBER (',
'        p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'        p_seq             => :P360_ID,',
'        p_c001            => l_name,',
'        p_c002            => ''DESCRIPTION'',',
'        p_c003            => :P360_NAME ,',
'        p_c004            => :P360_DESCRIPTION,',
'        p_c005            => :P360_TABLE_PREFIX,',
'        p_d001            => sysdate',
'        );',
'        ',
'else',
'    APEX_COLLECTION.ADD_MEMBER (',
'        p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'        p_c001            => l_name,',
'        p_c002            => ''DESCRIPTION'',',
'        p_c003            => :P360_NAME ,',
'        p_c004            => :P360_DESCRIPTION,',
'        p_c005            => :P360_TABLE_PREFIX,',
'        p_d001            => sysdate',
'        );',
'        ',
'end if;',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3348476925784871570.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3348476235977871569.4024)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch data from collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select * ',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P360_ID) loop',
'   :P360_NAME         := C1.C003; ',
'   :P360_DESCRIPTION  := C1.C004;',
'   :P360_TABLE_PREFIX := c1.c005;',
'end loop;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00370
begin
wwv_flow_api.create_page(
 p_id=>370.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Attributo metrica'
,p_page_mode=>'MODAL'
,p_step_title=>'Attributo metrica'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'fieldset.textarea {',
'    width: 100%;',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_dialog_width=>'640'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_plug_name=>'Identificazione'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19986846370939921225.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413437829392225465.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(19986846370939921225.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:METRIC_ATTRIBUTE'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3390655510072107123.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(19986846370939921225.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P370_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413438184903226621.4024)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(19986846370939921225.4024)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aggiungi impostazione predefinita attributo'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P370_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3390656395943107125.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(19986846370939921225.4024)
,p_button_name=>'PREV'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Precedente'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::'
,p_button_condition=>'P370_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3390655951355107124.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(19986846370939921225.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413437554209224194.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(19986846370939921225.4024)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--gapLeft'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Elimina attributo'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_condition=>'P370_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302186616857908733.4024)
,p_name=>'P370_MAX_ROWS'
,p_is_required=>true
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_item_default=>'RESTRICTED_NO_SET_FROM_BROWSER'
,p_prompt=>'Numero massimo di righe'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302186769395908734.4024)
,p_name=>'P370_QUERY'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_prompt=>'Query'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.CODE_EDITOR'
,p_cSize=>30
,p_cHeight=>5
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'SQL'
,p_attribute_02=>'VARCHAR2'
,p_attribute_03=>'Y'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3390657024350107137.4024)
,p_name=>'P370_NAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3390657483773107143.4024)
,p_name=>'P370_TYPE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_item_default=>'VARCHAR'
,p_prompt=>'Tipo'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3390657834687107144.4024)
,p_name=>'P370_VISUAL'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_item_default=>'RESTRICTED_NO_SET_FROM_BROWSER'
,p_prompt=>'Visualizzazione consigliata'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3390658259292107144.4024)
,p_name=>'P370_TABLE'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_item_default=>'RESTRICTED_NO_SET_FROM_BROWSER'
,p_prompt=>'Tabella'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3390658672796107144.4024)
,p_name=>'P370_LABEL_COLUMN'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_item_default=>'RESTRICTED_NO_SET_FROM_BROWSER'
,p_prompt=>'Colonna etichetta'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3390659000295107145.4024)
,p_name=>'P370_FUNCTION'
,p_is_required=>true
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_item_default=>'RESTRICTED_NO_SET_FROM_BROWSER'
,p_prompt=>'Funzione'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3390659475333107145.4024)
,p_name=>'P370_VALUE_COLUMN'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_item_default=>'RESTRICTED_NO_SET_FROM_BROWSER'
,p_prompt=>'Colonna valori'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3390659860641107145.4024)
,p_name=>'P370_DESCRIPTION'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_prompt=>'Descrizione'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>5
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3390660238480107146.4024)
,p_name=>'P370_ID'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(19986845055119921212.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3390661800831107158.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3390655951355107124.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3390662387399107162.4024)
,p_event_id=>wwv_flow_api.id(3390661800831107158.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3390661080178107156.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save back to collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'   l_name varchar2(4000) := null;',
'begin',
'for c1 in (select c001',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P370_ID) loop',
'   l_name := c1.c001;',
'end loop;',
'',
'if :P370_ID is not null then',
'    APEX_COLLECTION.UPDATE_MEMBER (',
'        p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'        p_seq             => :P370_ID,',
'        p_c001            => l_name,',
'        p_c002            => ''METRIC'',',
'        p_c003            => :P370_NAME ,',
'        p_c004            => :P370_TYPE,',
'        p_c005            => :P370_VISUAL,',
'        p_c006            => :P370_TABLE,',
'        p_c007            => :P370_LABEL_COLUMN,',
'        p_c008            => :P370_FUNCTION,',
'        p_c009            => :P370_VALUE_COLUMN,',
'        p_c010            => :P370_max_rows,',
'        p_c011            => :P370_query,',
'        p_c012            => :P370_DESCRIPTION,',
'        p_d001            => sysdate',
'        );',
'        ',
'else',
'',
'    APEX_COLLECTION.ADD_MEMBER (',
'        p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'        p_c001            => l_name,',
'        p_c002            => ''METRIC'',',
'        p_c003            => :P370_NAME ,',
'        p_c004            => :P370_TYPE,',
'        p_c005            => :P370_VISUAL,',
'        p_c006            => :P370_TABLE,',
'        p_c007            => :P370_LABEL_COLUMN,',
'        p_c008            => :P370_FUNCTION,',
'        p_c009            => :P370_VALUE_COLUMN,',
'        p_c010            => :P370_max_rows,',
'        p_c011            => :P370_query,',
'        p_c012            => :P370_DESCRIPTION,',
'        p_d001            => sysdate',
'        );',
'        ',
'end if;',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3390661441567107156.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3390660616365107155.4024)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch data from collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select * ',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P370_ID) loop',
'   :P370_NAME                := C1.C003; ',
'   :P370_TYPE                := C1.C004;',
'   :P370_VISUAL              := c1.C005;',
'   :P370_TABLE               := c1.C006;',
'   :P370_LABEL_COLUMN        := c1.C007;',
'   :P370_FUNCTION            := c1.C008;',
'   :P370_VALUE_COLUMN        := c1.C009;',
'   :P370_max_rows            := c1.C010;',
'   :P370_query               := c1.C011;',
'   :P370_DESCRIPTION         := c1.C012;',
'end loop;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00430
begin
wwv_flow_api.create_page(
 p_id=>430.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Attributi tabella'
,p_page_mode=>'MODAL'
,p_step_title=>'Attributi tabella'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'fieldset.textarea {',
'    width: 100%;',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_dialog_width=>'640'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(16596190157842814110.4024)
,p_plug_name=>'Identificazione'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(16596191473662814123.4024)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413432138761184593.4024)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(16596191473662814123.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:TABLE_ATTRIBUTE'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3386976797955362578.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(16596191473662814123.4024)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P430_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413430002096162654.4024)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(16596191473662814123.4024)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aggiungi impostazione predefinita attributo'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P430_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3413429752498161137.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(16596191473662814123.4024)
,p_button_name=>'PREV'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Precedente'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::'
,p_button_condition=>'P430_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3386977162047362581.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(16596191473662814123.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3399173202354615854.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(16596191473662814123.4024)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--gapLeft'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Elimina attributo'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_execute_validations=>'N'
,p_button_condition_type=>'NEVER'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302186049381908727.4024)
,p_name=>'P430_PRIMARY_DISP_COL'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(16596190157842814110.4024)
,p_prompt=>'Colonna di visualizzazione primaria'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) D, column_name R',
'from sys.dba_tab_columns',
'where  owner = :P1_SCHEMA',
'and owner in (select schema',
'                from wwv_flow_company_schemas',
'               where security_group_id = :flow_security_group_id)',
'  and table_name = :P430_TABLE',
'  and (data_type in (''VARCHAR2'',''NUMBER'',''FLOAT'',''DATE'') or data_type like (''TIMESTAMP%''))',
'order by column_id  '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P430_TABLE'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302186179851908728.4024)
,p_name=>'P430_SECONDARY_DISP_COL'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(16596190157842814110.4024)
,p_prompt=>'Colonna di visualizzazione secondaria'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) D, column_name R',
'from sys.dba_tab_columns',
'where  owner = :P1_SCHEMA',
'and owner in (select schema',
'                from wwv_flow_company_schemas',
'               where security_group_id = :flow_security_group_id)',
'  and table_name = :P430_TABLE',
'  and (data_type in (''VARCHAR2'',''NUMBER'',''FLOAT'',''DATE'') or data_type like (''TIMESTAMP%''))',
'order by column_id  '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P430_TABLE'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302186202907908729.4024)
,p_name=>'P430_PRIMARY_KEY_COL'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(16596190157842814110.4024)
,p_prompt=>'Colonna chiave primaria'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) D, column_name R',
'from sys.dba_tab_columns',
'where  owner = :P1_SCHEMA',
'and owner in (select schema',
'                from wwv_flow_company_schemas',
'               where security_group_id = :flow_security_group_id)',
'  and table_name = :P430_TABLE',
'  and (data_type in (''VARCHAR2'',''NUMBER'',''FLOAT'',''DATE'') or data_type like (''TIMESTAMP%''))',
'order by column_id  '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P430_TABLE'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3302186390183908730.4024)
,p_name=>'P430_PRIMARY_PARENT_TAB'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(16596190157842814110.4024)
,p_prompt=>'Tabella padre primaria'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'AVAILABLE_TABLE_VIEWS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, object_name v',
'  from sys.dba_objects',
' where object_type in (''TABLE'',''VIEW'')',
'   and object_name not like ''BIN$%''',
'   and owner = :P1_SCHEMA',
'   and owner in (select schema',
'                     from wwv_flow_company_schemas',
'                    where security_group_id = :flow_security_group_id)',
' order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona tabella o vista -'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3386978206250362593.4024)
,p_name=>'P430_TABLE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(16596190157842814110.4024)
,p_prompt=>'Tabella'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'AVAILABLE_TABLE_VIEWS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, object_name v',
'  from sys.dba_objects',
' where object_type in (''TABLE'',''VIEW'')',
'   and object_name not like ''BIN$%''',
'   and owner = :P1_SCHEMA',
'   and owner in (select schema',
'                     from wwv_flow_company_schemas',
'                    where security_group_id = :flow_security_group_id)',
' order by 1'))
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3386978692839362596.4024)
,p_name=>'P430_LABEL_SINGULAR'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(16596190157842814110.4024)
,p_prompt=>'Etichetta, singolare'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3386979044174362597.4024)
,p_name=>'P430_LABEL_PLURAL'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(16596190157842814110.4024)
,p_prompt=>'Etichetta, plurale'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(3071359248210082306.4024)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3386979477235362598.4024)
,p_name=>'P430_DESCRIPTION'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(16596190157842814110.4024)
,p_prompt=>'Descrizione'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>5
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(3071359888141100707.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3386979869914362599.4024)
,p_name=>'P430_ID'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(16596190157842814110.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3019481184533899636.4024)
,p_validation_name=>'Check for Duplicate table names'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_error_msg varchar2(255) := wwv_flow_lang.custom_runtime_message(''CA.ATTR.DEFAULT.DUPLICATE'',''table'');',
'begin',
'  for c1 in (select c001',
'             from apex_collections ',
'             where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' ',
'             and   c002 = ''TABLE''',
'             and   c003 = :P430_TABLE',
'             and   seq_id <> nvl(:P430_ID,0)',
'            ) loop',
'     return l_error_msg; ',
'  end loop;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3386981448432362612.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(3386977162047362581.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3386981912464362614.4024)
,p_event_id=>wwv_flow_api.id(3386981448432362612.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3386980650627362609.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save back to collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'   l_name varchar2(4000) := null;',
'begin',
'for c1 in (select c001',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P430_ID) loop',
'   l_name := c1.c001;',
'end loop;',
'',
'if :REQUEST = ''DELETE'' then',
'    APEX_COLLECTION.DELETE_MEMBER (',
'        p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'        p_seq             => :P320_ID);',
'else',
'    if :P430_ID is not null then',
'        APEX_COLLECTION.UPDATE_MEMBER (',
'            p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'            p_seq             => :P430_ID,',
'            p_c001            => l_name,',
'            p_c002            => ''TABLE'',',
'            p_c003            => :P430_TABLE ,',
'            p_c004            => :P430_LABEL_SINGULAR,',
'            p_c005            => :P430_LABEL_PLURAL,',
'            p_c006            => :P430_PRIMARY_DISP_COL,',
'            p_c007            => :P430_SECONDARY_DISP_COL,',
'            p_c008            => :P430_PRIMARY_KEY_COL,',
'            p_c009            => :P430_PRIMARY_PARENT_TAB,',
'            p_c011            => :P430_DESCRIPTION,',
'            p_d001            => sysdate',
'            );',
'            ',
'    else',
'    ',
'        APEX_COLLECTION.ADD_MEMBER (',
'            p_collection_name => ''APEX$ATTRIBUTE_DEFAULTS'',',
'            p_c001            => l_name,',
'            p_c002            => ''TABLE'',',
'            p_c003            => :P430_TABLE ,',
'            p_c004            => :P430_LABEL_SINGULAR,',
'            p_c005            => :P430_LABEL_PLURAL,',
'            p_c006            => :P430_PRIMARY_DISP_COL,',
'            p_c007            => :P430_SECONDARY_DISP_COL,',
'            p_c008            => :P430_PRIMARY_KEY_COL,',
'            p_c009            => :P430_PRIMARY_PARENT_TAB,',
'            p_c011            => :P430_DESCRIPTION,',
'            p_d001            => sysdate',
'            );',
'    end if;',
'end if;',
'end;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3386981046942362610.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3386980239265362609.4024)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch data from collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select * ',
'           from apex_collections ',
'           where collection_name = ''APEX$ATTRIBUTE_DEFAULTS'' and seq_id = :P430_ID) loop',
'   :P430_TABLE               := C1.C003; ',
'   :P430_LABEL_SINGULAR      := C1.C004;',
'   :P430_LABEL_PLURAL        := c1.C005;',
'   :P430_PRIMARY_DISP_COL    := c1.C006;',
'   :P430_SECONDARY_DISP_COL  := c1.C007;',
'   :P430_PRIMARY_KEY_COL     := c1.C008;',
'   :P430_PRIMARY_PARENT_TAB  := c1.C009;',
'   :P430_DESCRIPTION         := c1.C011;',
'end loop;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00900
begin
wwv_flow_api.create_page(
 p_id=>900.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'?'
,p_page_mode=>'MODAL'
,p_step_title=>'?'
,p_autocomplete_on_off=>'OFF'
,p_page_css_classes=>'a-PageWizard-dialog'
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'600'
,p_dialog_width=>'600'
,p_dialog_attributes=>'resizable:true'
,p_dialog_chained=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(784428987692840031.4024)
,p_plug_name=>'Guida introduttiva'
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.INTRO.TITLE'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.INTRO.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.INTRO.HOWTO.TITLE'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.INTRO.HOWTO.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.INTRO.RELEASE.TITLE'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.INTRO.RELEASE.DETAIL'',:RELEASE_DATE));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.INTRO.KNOWN.ISSUES.TITLE'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.INTRO.KNOWN.ISSUES.DETAIL''));',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'INTRO'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2588925584975150549.4024)
,p_plug_name=>'Guida sulle impostazioni'
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.SETTINGS'')||''</h3>'');',
'sys.htp.p(''<p>''||wwv_flow_lang.custom_runtime_message(''CA.SETTINGS.DESC'')||''</p>'');',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.APPLICATION.ID'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.APPLICATION.ID.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.SCHEMA'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.SCHEMA.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.LANGUAGE'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.LANGUAGE.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.AUTHENTICATION'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.AUTHENTICATION.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.ADVANCED.SETTINGS'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.ADVANCED.SETTINGS.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.UI.DEFAULTS'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.UI.DEFAULTS.DETAIL''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'SETTINGS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2588925676389150550.4024)
,p_plug_name=>'Elementi nascosti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2595754206267422202.4024)
,p_plug_name=>'Guida sull''aspetto'
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.APPEARANCE'')||''</h3>'');',
'sys.htp.p(''<p>''||wwv_flow_lang.custom_runtime_message(''CA.APPEARANCE.DESC'')||''</p>'');',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.THEME.STYLE'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.THEME.STYLE.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.NAVIGATION'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.NAVIGATION.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.APPLICATION.ICON'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.APPLICATION.ICON.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.CUSTOM.THEME'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.CUSTOM.THEME.DETAIL''));',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'UI'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2595754351455422203.4024)
,p_plug_name=>'Guida sulle funzioni'
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.FEATURES'')||''</h3>'');',
'sys.htp.p(''<p>''||wwv_flow_lang.custom_runtime_message(''CA.FEATURES.DESC'')||''</p>'');',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.ABOUT.PAGE'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ABOUT.PAGE.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.ACCESS.CONTROL'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.ACCESS.CONTROL.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.ACTIVITY.REPORTING'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ACTIVITY.REPORTING.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.CONFIGURATION.SETTINGS'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.CONFIGURATION.SETTINGS.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.FEEDBACK'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.FEEDBACK.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.THEME.SELECTOR'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.THEME.SELECTOR.DETAIL''));',
'',
'',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'FEATURES'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2595755838165422218.4024)
,p_plug_name=>'Guida sulle pagine'
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.PAGES'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.PAGES.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.ADDING.PAGES'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADDING.PAGES.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.ORGANIZING.PAGES'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ORGANIZING.PAGES.DETAIL''));',
'',
'sys.htp.p(''<h4>''||wwv_flow_lang.custom_runtime_message(''CA.REMOVING.PAGES'')||''</h4>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.REMOVING.PAGES.DETAIL''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'PAGES'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_plug_name=>'Guida sul livello di pagina'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(57830928122033942.4024)
,p_plug_name=>unistr('Guida della pagina Pi\00F9 report')
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>130
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.MULTIPLE.REPORTS'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.MULTIPLE.REPORTS.DETAILS''));',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'MULTIPLE_REPORTS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2698017996079126314.4024)
,p_plug_name=>'Guida sulla pagina vuota'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.BLANK'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.BLANK.DETAILS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADVANCED''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'BLANK_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2698018731554126322.4024)
,p_plug_name=>'Guida sulla pagina del grafico'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.CHART'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.CHART.DETAILS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADVANCED''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.CHART.EXAMPLES''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'CHART_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2698018814955126323.4024)
,p_plug_name=>'Guida sulla pagina del report'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>100
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.REPORT'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.REPORT.DETAILS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.DRILL.DOWN.LINK''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.LOOKUP.COLUMNS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADVANCED''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'REPORT_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2698019051695126325.4024)
,p_plug_name=>'Guida sulla pagina della griglia interattiva'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>90
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.GRID'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.GRID.DETAILS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADVANCED''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'IG_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2698019116640126326.4024)
,p_plug_name=>'Guida sulla pagina di calendario'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.CALENDAR'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.CALENDAR.DETAILS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADVANCED''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'CALENDAR_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2698019235455126327.4024)
,p_plug_name=>'Guida sulla pagina dashboard'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.DASHBOARD'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.DASHBOARD.DETAILS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADVANCED''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'DASHBOARD_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2707858861836463439.4024)
,p_plug_name=>'Guida sulla pagina del form'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.FORM'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.FORM.DETAILS''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'FORM_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3019481736029899642.4024)
,p_plug_name=>'Guida sulla pagina della scheda'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.CARD'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.CARD.DETAILS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.DRILL.DOWN.LINK''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADVANCED''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'CARD_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3019481836722899643.4024)
,p_plug_name=>'Guida sulla pagina del controllo temporale'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>110
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.TIMELINE'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.TIMELINE.DETAILS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.DRILL.DOWN.LINK''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADVANCED''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'TIMELINE_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3019481930301899644.4024)
,p_plug_name=>'Guida sulla pagina Master-Detail'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.MASTER'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.MASTER.DETAILS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADVANCED.PAGE_HELP''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'MASTER_DETAIL_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3613185396099513507.4024)
,p_plug_name=>'Guida sulla pagina della procedura guidata'
,p_parent_plug_id=>wwv_flow_api.id(2698018669168126321.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>120
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.WIZARD'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.WIZARD.DETAILS''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.ADVANCED''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'WIZARD_PAGE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2796575515210751039.4024)
,p_plug_name=>'Guida sul progetto'
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.BLUEPRINT'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message(''CA.BLUEPRINT.DETAIL''));',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'BLUEPRINT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3019480338579899628.4024)
,p_plug_name=>'Guida sulle lingue'
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>100
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.LANGUAGE'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.LANGUAGE.DETAIL''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.LANGUAGE.PAGE''));',
'',
'',
'',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3034953264948022701.4024)
,p_plug_name=>'Guida sulle impostazioni avanzate'
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>120
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.ADVANCED.SETTINGS'')||''</h3>'');',
'sys.htp.p(''<p>''||wwv_flow_lang.custom_runtime_message(''CA.ADVANCED.SETTINGS.DETAIL'')||''</p>'');',
'sys.htp.p(''<p>''||wwv_flow_lang.custom_runtime_message(''CA.ADVANCED.SETTINGS.PAGE'')||''</p>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'ADVANCED'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3035688619153083805.4024)
,p_plug_name=>'Guida su Oggetti di supporto'
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>110
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.SUPPORTING.OBJECTS'')||''</h3>'');',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.SUPPORTING.OBJECTS.DETAIL''));',
'sys.htp.p(wwv_flow_lang.custom_runtime_message (''CA.SUPPORTING.OBJECTS.PAGE''));',
'',
'',
'',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3613185016564513504.4024)
,p_plug_name=>'Livello impostazioni predefinite applicazione'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>140
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3034953327661022702.4024)
,p_plug_name=>'Guida sulle impostazioni predefinite applicazione'
,p_parent_plug_id=>wwv_flow_api.id(3613185016564513504.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.DEFAULTS'')||''</h3>'');',
'sys.htp.p(''<p>''||wwv_flow_lang.custom_runtime_message(''CA.DEFAULTS.DETAIL'')||''</p>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'DEFAULTS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3348513411644390602.4024)
,p_plug_name=>'Guida sull''attributo colonna tabella'
,p_parent_plug_id=>wwv_flow_api.id(3613185016564513504.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.DEFAULTS.TABLE.COLUMN'')||''</h3>'');',
'sys.htp.p(''<p>''||wwv_flow_lang.custom_runtime_message(''CA.DEFAULTS.TABLE.COLUMN.DETAIL'')||''</p>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'TABLE_COLUMN_ATTRIBUTE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3348513524697390603.4024)
,p_plug_name=>'Guida sull''attributo lista di valori'
,p_parent_plug_id=>wwv_flow_api.id(3613185016564513504.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.DEFAULTS.LOV'')||''</h3>'');',
'sys.htp.p(''<p>''||wwv_flow_lang.custom_runtime_message(''CA.DEFAULTS.LOV.DETAIL'')||''</p>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'LOV_ATTRIBUTE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3613185101621513505.4024)
,p_plug_name=>'Guida sugli attributi tabella'
,p_parent_plug_id=>wwv_flow_api.id(3613185016564513504.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.DEFAULTS.TABLE'')||''</h3>'');',
'sys.htp.p(''<p>''||wwv_flow_lang.custom_runtime_message(''CA.DEFAULTS.TABLE.DETAIL'')||''</p>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'TABLE_ATTRIBUTE'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3613185249191513506.4024)
,p_plug_name=>'Guida sugli attributi report'
,p_parent_plug_id=>wwv_flow_api.id(3613185016564513504.4024)
,p_region_css_classes=>'a-PageWizard-dialogHelp'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<h3>''||wwv_flow_lang.custom_runtime_message(''CA.DEFAULTS.REPORT'')||''</h3>'');',
'sys.htp.p(''<p>''||wwv_flow_lang.custom_runtime_message(''CA.DEFAULTS.REPORT.DETAIL'')||''</p>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P900_HELP_SECTION'
,p_plug_display_when_cond2=>'REPORT_ATTRIBUTE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2595754126973422201.4024)
,p_name=>'P900_HELP_SECTION'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2588925676389150550.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
end;
/
prompt --application/pages/page_01000
begin
wwv_flow_api.create_page(
 p_id=>1000.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Creazione guidata pagina'
,p_page_mode=>'MODAL'
,p_step_title=>'Aggiungi pagina'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-WizardSteps-step.is-active .a-WizardSteps-label {',
'    display: block;',
'}',
'.a-WizardSteps-step .a-WizardSteps-label {',
'    display: none;',
'}',
'.a-PageWizard-dialog--startWizard .a-Dialog-body {display: block;}'))
,p_step_template=>wwv_flow_api.id(3272976625713321802.4024)
,p_page_css_classes=>'a-PageWizard-dialog a-PageWizard-dialog--startWizard a-PageWizard-dialog--centeredContent'
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'640'
,p_dialog_width=>'800'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(597621241273219128.4024)
,p_plug_name=>'Pagine aggiuntive'
,p_region_template_options=>'#DEFAULT#:is-collapsed:a-Region--noPadding:a-Region--noBorder'
,p_plug_template=>wwv_flow_api.id(3273871575473525717.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5521047782961084873.4024)
,p_plug_name=>'Wizard Form'
,p_region_css_classes=>'a-BoxedForms'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3286693190338347807.4024)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2578235721023427523.4024)
,p_branch_name=>'Create Blank Page'
,p_branch_action=>'f?p=&APP_ID.:1010:&SESSION.::&DEBUG.:RP,1010::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'BLANK'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2698020755463126342.4024)
,p_branch_name=>'Create Faceted Search Page'
,p_branch_action=>'f?p=&APP_ID.:1140:&SESSION.::&DEBUG.:RP,1140::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'FACETED_SEARCH'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2588921964261150513.4024)
,p_branch_name=>'Create Interactive Report Page'
,p_branch_action=>'f?p=&APP_ID.:1020:&SESSION.::&DEBUG.:RP,1020:P1020_PAGE_TYPE:&P1000_PAGE_TYPE.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'REPORT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(597621458148219130.4024)
,p_branch_name=>'Create Classic Report Page'
,p_branch_action=>'f?p=&APP_ID.:1020:&SESSION.::&DEBUG.:RP,1020:P1020_PAGE_TYPE,P1020_REPORT_TYPE:REPORT,CLASSIC_RPT&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>40
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_ADDITIONAL_PAGE_TYPES'
,p_branch_condition_text=>'CLASSIC_REPORT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2594841882553086007.4024)
,p_branch_name=>'Create Interactive Grid Page'
,p_branch_action=>'f?p=&APP_ID.:1030:&SESSION.::&DEBUG.:RP,1030:P1030_PAGE_TYPE:&P1000_PAGE_TYPE.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>50
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'INTERACTIVE_GRID'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2594841993570086008.4024)
,p_branch_name=>'Create Master Detail Page'
,p_branch_action=>'f?p=&APP_ID.:1040:&SESSION.::&DEBUG.:RP,1040:P1040_PAGE_TYPE:&P1000_PAGE_TYPE.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>60
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'MASTER_DETAIL'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3314909449082435901.4024)
,p_branch_name=>'Create Form Page'
,p_branch_action=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.:RP,1100:P1100_PAGE_TYPE,P1100_FORM_TYPE:&P1000_PAGE_TYPE.,FORM_ON_PAGE&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>70
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'FORM'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3314909517129435902.4024)
,p_branch_name=>'Create Cards Page'
,p_branch_action=>'f?p=&APP_ID.:1090:&SESSION.::&DEBUG.:RP,1090:P1090_PAGE_TYPE:&P1000_PAGE_TYPE.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>80
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'CARDS'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2594842391030086012.4024)
,p_branch_name=>'Create Chart Page'
,p_branch_action=>'f?p=&APP_ID.:1050:&SESSION.::&DEBUG.:RP,1050:P1050_PAGE_TYPE:&P1000_PAGE_TYPE.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>90
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'CHART'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2595755545557422215.4024)
,p_branch_name=>'Create Dashboard Page'
,p_branch_action=>'f?p=&APP_ID.:1060:&SESSION.::&DEBUG.:RP,1060:P1060_PAGE_TYPE:&P1000_PAGE_TYPE.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>100
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'DASHBOARD'
,p_required_patch=>wwv_flow_api.id(2746942411136297678.4024)
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2593478104225715614.4024)
,p_branch_name=>'Create Calendar Page'
,p_branch_action=>'f?p=&APP_ID.:1070:&SESSION.::&DEBUG.:RP,1070:P1070_PAGE_TYPE:&P1000_PAGE_TYPE.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>110
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'CALENDAR'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3315107717051942901.4024)
,p_branch_name=>'Create Timeline Page'
,p_branch_action=>'f?p=&APP_ID.:1110:&SESSION.::&DEBUG.:RP,1110:P1110_PAGE_TYPE:&P1000_PAGE_TYPE.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>120
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_ADDITIONAL_PAGE_TYPES'
,p_branch_condition_text=>'TIMELINE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3315107867862942902.4024)
,p_branch_name=>'Create Wizard Page'
,p_branch_action=>'f?p=&APP_ID.:1120:&SESSION.::&DEBUG.:RP,1120:P1120_PAGE_TYPE:&P1000_PAGE_TYPE.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>130
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'WIZARD'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(4212071896991544845.4024)
,p_branch_name=>'Create Multiple Report Pages'
,p_branch_action=>'f?p=&APP_ID.:1130:&SESSION.::&DEBUG.:RP,1130::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>140
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P1000_PAGE_TYPE'
,p_branch_condition_text=>'MULTI_RPT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(597621334457219129.4024)
,p_name=>'P1000_ADDITIONAL_PAGE_TYPES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(597621241273219128.4024)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tipi di pagina aggiuntiva'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.WIZARD_SELECTION'
,p_named_lov=>'P1000_MORE_PAGE_TYPES'
,p_lov=>'.'||wwv_flow_api.id(599910129386444402.4024)||'.'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_css_classes=>'a-IconList--LargeIcons a-IconList--PageWizard a-IconList--AddPage'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'S'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2577830533539778509.4024)
,p_name=>'P1000_PAGE_TYPE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5521047782961084873.4024)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tipo pagina'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.WIZARD_SELECTION'
,p_named_lov=>'P1000_PAGE_TYPES'
,p_lov=>'.'||wwv_flow_api.id(2595619325504357130.4024)||'.'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_css_classes=>'a-IconList--LargeIcons a-IconList--PageWizard a-IconList--AddPage'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'S'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2647104303557258103.4024)
,p_name=>'Set Theme'
,p_event_sequence=>10
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2647104482047258104.4024)
,p_event_id=>wwv_flow_api.id(2647104303557258103.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.jQuery( ''.a-IconList--wizard'' ).addClass( apex.util.getTopApex().jQuery( ''#P1_THEME_STYLE_CLASS'' ).val() );'
);
end;
/
prompt --application/pages/page_01010
begin
wwv_flow_api.create_page(
 p_id=>1010.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Crea pagina vuota'
,p_page_mode=>'MODAL'
,p_step_title=>'Aggiungi pagina vuota'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_PAGE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_api.id(3272976625713321802.4024)
,p_page_css_classes=>'a-PageWizard-dialog'
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2714282414911099412.4024)
,p_plug_name=>'Avanzate'
,p_region_css_classes=>'a-PageWizard--collapsibleRegion'
,p_region_template_options=>'#DEFAULT#:is-collapsed:a-Region--noPadding:a-Region--noBorder'
,p_plug_template=>wwv_flow_api.id(3273871575473525717.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(8109678764558259639.4024)
,p_plug_name=>'Page Name and Icon Container'
,p_region_css_classes=>'a-BoxedForms'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 24px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(8109679340901259645.4024)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2595756247498422222.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(8109678764558259639.4024)
,p_button_name=>'SET_ICON'
,p_button_static_id=>'icon_picker'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(2988804730938183125.4024)
,p_button_image_alt=>'Imposta icona'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP:P110_PASS_BACK_TO_UI,P110_PASS_BACK_TO_SAVE:icon_picker,P1010_PAGE_ICON'
,p_button_css_classes=>'a-PWIconPicker-pickerButton'
,p_icon_css_classes=>'fa &P1010_PAGE_ICON.'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>2
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2595754753405422207.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(8109679340901259645.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_warn_on_unsaved_changes=>null
,p_button_condition=>'P1010_SEQ_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(7261709060772831.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(8109679340901259645.4024)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Elimina'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_condition=>'P1010_SEQ_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2595756425669422224.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(8109679340901259645.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:BLANK_PAGE'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2578237017465427536.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(8109679340901259645.4024)
,p_button_name=>'SAVE'
,p_button_static_id=>'P1_NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Salva modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P1010_SEQ_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2588632343330174811.4024)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(8109679340901259645.4024)
,p_button_name=>'CREATE'
,p_button_static_id=>'P1_NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aggiungi pagina'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P1010_SEQ_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2588632773127174813.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(8109679340901259645.4024)
,p_button_name=>'PREVIOUS'
,p_button_static_id=>'P1_CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Precedente'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:RP,1000::'
,p_button_condition=>'P1010_SEQ_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2588633535842174842.4024)
,p_branch_name=>'Redirect to Login Page'
,p_branch_action=>'f?p=4550:1'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(2588632773127174813.4024)
,p_branch_sequence=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2578235418160427520.4024)
,p_name=>'P1010_PAGE_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(8109678764558259639.4024)
,p_prompt=>'Nome pagina'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(2716804030064502999.4024)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2578236174264427527.4024)
,p_name=>'P1010_HOMEPAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2714282414911099412.4024)
,p_prompt=>'Home page'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_define_app_v3.is_home_page( p_page_id => :P1010_SEQ_ID ) then',
'    return ''Y'';',
'else',
'    return ''N'';',
'end if;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'IS_HOMEPAGE'
,p_lov=>'.'||wwv_flow_api.id(2639480030873536264.4024)||'.'
,p_read_only_when=>'return wwv_flow_define_app_v3.is_home_page( p_page_id => :P1010_SEQ_ID );'
,p_read_only_when_type=>'FUNCTION_BODY'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2578236647392427532.4024)
,p_name=>'P1010_SEQ_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(8109678764558259639.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2595756375058422223.4024)
,p_name=>'P1010_PAGE_ICON'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(8109678764558259639.4024)
,p_item_default=>'fa-file-o'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2940045201067003221.4024)
,p_name=>'P1010_ADMIN'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(2714282414911099412.4024)
,p_prompt=>'Amministrativo'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'IS ADMINISTRATIVE'
,p_lov=>'.'||wwv_flow_api.id(2996645622600931087.4024)||'.'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165198319373852601.4024)
,p_name=>'P1010_PAGE_HELP'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(2714282414911099412.4024)
,p_prompt=>'Guida sulla pagina'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(3076592553081438826.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2578238416659427550.4024)
,p_name=>'Focus on Page Load'
,p_event_sequence=>10
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2588920766832150501.4024)
,p_event_id=>wwv_flow_api.id(2578238416659427550.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_FOCUS'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1010_PAGE_NAME'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2647104509836258105.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(2595754753405422207.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2647104607860258106.4024)
,p_event_id=>wwv_flow_api.id(2647104509836258105.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(784429169065840033.4024)
,p_name=>'Disable Admin'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1010_HOMEPAGE'
,p_condition_element=>'P1010_HOMEPAGE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(784429296653840034.4024)
,p_event_id=>wwv_flow_api.id(784429169065840033.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1010_ADMIN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(784429321110840035.4024)
,p_event_id=>wwv_flow_api.id(784429169065840033.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1010_ADMIN'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(784430362487840045.4024)
,p_name=>'Disable Home Page'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1010_ADMIN'
,p_condition_element=>'P1010_ADMIN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(784430410144840046.4024)
,p_event_id=>wwv_flow_api.id(784430362487840045.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1010_HOMEPAGE'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(784430522821840047.4024)
,p_event_id=>wwv_flow_api.id(784430362487840045.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1010_HOMEPAGE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(7261168887772825.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_define_app_v3.add_page(',
'    p_page_name        => :P1010_PAGE_NAME,',
'    p_page_type        => wwv_flow_define_app_v3.c_page_blank,',
'    p_page_icon        => :P1010_PAGE_ICON,',
'    p_is_homepage      => ( :P1010_HOMEPAGE = ''Y'' ),',
'    p_is_admin_page    => ( :P1010_ADMIN = ''Y''),',
'    p_page_help        => :P1010_PAGE_HELP);'))
,p_process_error_message=>'errore durante l''aggiunta della pagina #SQLERRM#'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(2588632343330174811.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2578237153283427537.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Edit Page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_define_app_v3.edit_page(',
'    p_page_id          => :P1010_SEQ_ID,',
'    p_page_name        => :P1010_PAGE_NAME,',
'    p_page_type        => wwv_flow_define_app_v3.c_page_blank,',
'    p_page_icon        => :P1010_PAGE_ICON,',
'    p_is_homepage      => ( :P1010_HOMEPAGE = ''Y'' ),',
'    p_is_admin_page    => ( :P1010_ADMIN = ''Y'' ),',
'    p_page_help        => :P1010_PAGE_HELP);'))
,p_process_error_message=>'errore durante la modifica della pagina #SQLERRM#'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(2578237017465427536.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(7261877275772832.4024)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_define_app_v3.delete_page(',
'    p_page_id => :P1010_SEQ_ID );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(7261709060772831.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2588921336190150507.4024)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2650783314597687601.4024)
,p_process_sequence=>50
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fetch Page Attributes'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for l_page in (select c001 page_name,',
'                      c002 page_type,',
'                      c013 page_icon,',
'                      c015 is_admin_page,',
'                      c040 help',
'               from apex_collections',
'               where collection_name = ''APEX$CREATE_APP_PAGE''',
'               and seq_id = :P1010_SEQ_ID )',
'loop',
'    :P1010_PAGE_NAME := l_page.page_name;',
'    :P1010_PAGE_ICON := l_page.page_icon;',
'    :P1010_ADMIN     := l_page.is_admin_page;',
'    :P1010_PAGE_HELP := l_page.help;',
'end loop;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P1010_SEQ_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2816364515854843902.4024)
,p_process_sequence=>60
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Home Page Defaults'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P1010_PAGE_NAME := ''Home'';',
':P1010_PAGE_ICON := ''fa-home'';'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_define_app_v3.is_home_page( p_page_id => :P1010_SEQ_ID ) ',
'   and :P1010_PAGE_NAME is null ',
'then',
'    return true;',
'else',
'    return false;',
'end if;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
prompt --application/pages/page_01020
begin
wwv_flow_api.create_page(
 p_id=>1020.4024
,p_user_interface_id=>wwv_flow_api.id(2563473516491437785.4024)
,p_name=>'Crea pagina report'
,p_page_mode=>'MODAL'
,p_step_title=>'Aggiungi pagina report'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-PageWizard-dialog .a-PageWizard--collapsibleRegion.a-Region--hideShow.a-BoxedForms .a-Region-body {',
'    margin: -12px 12px 0 12px;',
'    padding-bottom: 24px;',
'}',
'.a-Region.a-BoxedForms .a-Region-body {',
'   	color: #000;',
'}'))
,p_step_template=>wwv_flow_api.id(3272976625713321802.4024)
,p_page_css_classes=>'a-PageWizard-dialog'
,p_page_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(161342234287782302.4024)
,p_plug_name=>'Colonne ricerca'
,p_region_name=>'lookup_column_region'
,p_region_css_classes=>'a-PageWizard--collapsibleRegion a-BoxedForms'
,p_region_template_options=>'#DEFAULT#:is-collapsed:a-Region--noPadding:a-Region--noBorder'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3273871575473525717.4024)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2588922374251150517.4024)
,p_plug_name=>'Contenitore di form SQL'
,p_region_name=>'page_source_sql'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 12px 16px 0 16px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2588922563259150519.4024)
,p_plug_name=>'Tabella o vista'
,p_region_name=>'page_source_table'
,p_region_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 24px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2588925184942150545.4024)
,p_plug_name=>'Contenitore di tabelle'
,p_parent_plug_id=>wwv_flow_api.id(2588922563259150519.4024)
,p_region_css_classes=>'a-BoxedForms'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2588925205406150546.4024)
,p_plug_name=>'Includi form'
,p_parent_plug_id=>wwv_flow_api.id(2588922563259150519.4024)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2588922930744150523.4024)
,p_plug_name=>'Contenitore di origine pagina'
,p_region_css_classes=>'a-BoxedLabels'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noPadding'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3096986813591966835.4024)
,p_plug_name=>'Avanzate'
,p_region_css_classes=>'a-PageWizard--collapsibleRegion'
,p_region_template_options=>'#DEFAULT#:is-collapsed:a-Region--noPadding:a-Region--noBorder'
,p_region_attributes=>'style="margin: 0 16px"'
,p_plug_template=>wwv_flow_api.id(3273871575473525717.4024)
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3210720104674760401.4024)
,p_plug_name=>'Collegamento drill-down'
,p_region_name=>'drill_down_link_region'
,p_region_css_classes=>'a-PageWizard--collapsibleRegion a-BoxedForms'
,p_region_template_options=>'#DEFAULT#:is-collapsed:a-Region--noPadding:a-Region--noBorder'
,p_plug_template=>wwv_flow_api.id(3273871575473525717.4024)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_collections',
'where collection_name = ''APEX$CREATE_APP_PAGE'' and',
'    c002 in ( ''INTERACTIVE_RPT'',  ''MASTER_DETAIL'' )'))
,p_required_patch=>wwv_flow_api.id(3145295462075987142.4024)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10702437105165739245.4024)
,p_plug_name=>'Page Name and Icon Container'
,p_region_css_classes=>'a-BoxedForms'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin: 0 24px"'
,p_plug_template=>wwv_flow_api.id(3300810815961795652.4024)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10702437681508739251.4024)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3271069058970016268.4024)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2671764041415861323.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(10702437105165739245.4024)
,p_button_name=>'SET_ICON'
,p_button_static_id=>'icon_picker'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(2988804730938183125.4024)
,p_button_image_alt=>'Imposta icona'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP:P110_PASS_BACK_TO_UI,P110_PASS_BACK_TO_SAVE:icon_picker,P1020_PAGE_ICON'
,p_button_css_classes=>'a-PWIconPicker-pickerButton'
,p_icon_css_classes=>'fa &P1020_PAGE_ICON.'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>2
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2698016791258126302.4024)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(10702437681508739251.4024)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_warn_on_unsaved_changes=>null
,p_button_condition=>'P1020_SEQ_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(7261489151772828.4024)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(10702437681508739251.4024)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_image_alt=>'Elimina'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_condition=>'P1020_SEQ_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2698315076305799695.4024)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(10702437681508739251.4024)
,p_button_name=>'HELP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'?'
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:RP,900:P900_HELP_SECTION:REPORT_PAGE'
,p_button_css_classes=>'a-Button--noUI'
,p_icon_css_classes=>'icon-help'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2592760790910479646.4024)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(10702437681508739251.4024)
,p_button_name=>'SAVE'
,p_button_static_id=>'P1_NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Salva modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P1020_SEQ_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2592761156064479648.4024)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(10702437681508739251.4024)
,p_button_name=>'CREATE'
,p_button_static_id=>'P1_NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(2758666493011882367.4024)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aggiungi pagina'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P1020_SEQ_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2592761502988479649.4024)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(10702437681508739251.4024)
,p_button_name=>'PREVIOUS'
,p_button_static_id=>'P1_CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2937736309958680193.4024)
,p_button_image_alt=>'Precedente'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:RP,1000::'
,p_button_condition=>'P1020_SEQ_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(7261992641772833.4024)
,p_name=>'P1020_REPORT_TYPE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(2588922930744150523.4024)
,p_item_default=>'INTERACTIVE_RPT'
,p_prompt=>'Tipo di report'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'REPORT_TYPES'
,p_lov=>'.'||wwv_flow_api.id(2595616854306352005.4024)||'.'
,p_tag_css_classes=>'apex-button-group report-type'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_css_classes=>'page-source-field'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'3'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(7262007597772834.4024)
,p_name=>'P1020_INCLUDE_FORM'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2588925205406150546.4024)
,p_prompt=>'Includi form'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'INCLUDE_FORM_Y'
,p_lov=>'.'||wwv_flow_api.id(2595628838376488076.4024)||'.'
,p_tag_attributes=>'disabled'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(164836609452930746.4024)
,p_name=>'P1020_FK_COUNT'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(2588925184942150545.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
,p_item_comment=>'field--marginTop field--noBottomPadding'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2588922023118150514.4024)
,p_name=>'P1020_PAGE_TYPE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(10702437105165739245.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2588922105431150515.4024)
,p_name=>'P1020_PAGE_SOURCE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2588922930744150523.4024)
,p_item_default=>'TABLE'
,p_prompt=>'Origine pagina'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'SOURCE_TYPE'
,p_lov=>'.'||wwv_flow_api.id(2593539478572840546.4024)||'.'
,p_tag_css_classes=>'apex-button-group page-source'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_css_classes=>'page-source-field'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2588922280227150516.4024)
,p_name=>'P1020_SQL'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(2588922374251150517.4024)
,p_prompt=>'Query SQL'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.CODE_EDITOR'
,p_cSize=>80
,p_cHeight=>14
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'SQL'
,p_attribute_02=>'VARCHAR2'
,p_attribute_03=>'Y'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2588922436215150518.4024)
,p_name=>'P1020_TABLE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2588925184942150545.4024)
,p_prompt=>'Tabella o vista'
,p_placeholder=>'- Seleziona tabella o vista -'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'AVAILABLE_TABLE_VIEWS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, object_name v',
'  from sys.dba_objects',
' where object_type in (''TABLE'',''VIEW'')',
'   and object_name not like ''BIN$%''',
'   and owner = :P1_SCHEMA',
'   and owner in (select schema',
'                     from wwv_flow_company_schemas',
'                    where security_group_id = :flow_security_group_id)',
' order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona tabella o vista -'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(2716804030064502999.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding field--noPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
,p_item_comment=>'field--marginTop field--noBottomPadding'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592759016419479632.4024)
,p_name=>'P1020_HOMEPAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(3096986813591966835.4024)
,p_prompt=>'Home page'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_define_app_v3.is_home_page( p_page_id => :P1020_SEQ_ID ) then',
'    return ''Y'';',
'else',
'    return ''N'';',
'end if;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'IS_HOMEPAGE'
,p_lov=>'.'||wwv_flow_api.id(2639480030873536264.4024)||'.'
,p_read_only_when=>'return wwv_flow_define_app_v3.is_home_page( p_page_id => :P1020_SEQ_ID );'
,p_read_only_when_type=>'FUNCTION_BODY'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592759685908479645.4024)
,p_name=>'P1020_SEQ_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(10702437105165739245.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2592760051591479645.4024)
,p_name=>'P1020_PAGE_NAME'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(10702437105165739245.4024)
,p_prompt=>'Nome pagina'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(2716804030064502999.4024)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2671764303864862891.4024)
,p_name=>'P1020_PAGE_ICON'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(10702437105165739245.4024)
,p_item_default=>'fa-table'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2714284610729099434.4024)
,p_name=>'P1020_OBJ_TYPE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(10702437105165739245.4024)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2940045540690003224.4024)
,p_name=>'P1020_ADMIN'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(3096986813591966835.4024)
,p_prompt=>'Amministrativo'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'IS ADMINISTRATIVE'
,p_lov=>'.'||wwv_flow_api.id(2996645622600931087.4024)||'.'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(3271822809773116508.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3145293105679922083.4024)
,p_name=>'P1020_LINK_COLUMN'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(3210720104674760401.4024)
,p_prompt=>'Colonna di collegamento'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) D, column_name R',
'from sys.dba_tab_columns',
'where  owner = :P1_SCHEMA',
'and owner in (select schema',
'                from wwv_flow_company_schemas',
'               where security_group_id = :flow_security_group_id)',
'  and table_name = :P1020_TABLE',
'  and (data_type in (''VARCHAR2'',''NUMBER'',''FLOAT'',''DATE''))',
'order by column_id  '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_TABLE'
,p_ajax_items_to_submit=>'P1_SCHEMA'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_required_patch=>wwv_flow_api.id(3145295462075987142.4024)
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3145296910442009602.4024)
,p_name=>'P1020_LINK_TO_PAGE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(3210720104674760401.4024)
,p_prompt=>'Collegamento alla pagina'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001 d, n002 r ',
'from apex_collections ',
'where collection_name = ''APEX$CREATE_APP_PAGE''',
'and (   ( c002 = ''INTERACTIVE_RPT'' )',
'     or ( c002 = ''MASTER_DETAIL'' and c014 =''MD_ON_TABLE_WITH_SELECTOR'' )',
'    )',
'and ( seq_id !=  :P1020_SEQ_ID or :P1020_SEQ_ID is null )'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona pagina -'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_required_patch=>wwv_flow_api.id(3145295462075987142.4024)
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3145297198215009604.4024)
,p_name=>'P1020_LINK_KEY'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(3210720104674760401.4024)
,p_prompt=>'Chiave di collegamento'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) D, column_name R',
'from sys.dba_tab_columns',
'where  owner = :P1_SCHEMA',
'and owner in (select schema',
'                from wwv_flow_company_schemas',
'               where security_group_id = :flow_security_group_id)',
'  and table_name = :P1020_TABLE',
'  and (data_type in (''VARCHAR2'',''NUMBER'',''FLOAT''))',
'order by column_id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_TABLE'
,p_ajax_items_to_submit=>'P1_SCHEMA'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_required_patch=>wwv_flow_api.id(3145295462075987142.4024)
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3145297249722009605.4024)
,p_name=>'P1020_LINK_TARGET_KEY'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(3210720104674760401.4024)
,p_prompt=>'Chiave di destinazione'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (',
'    select wwv_flow_escape.html(column_name) d, column_name r, column_id n',
'    from sys.dba_tab_columns',
'    where  owner = :P1_SCHEMA and',
'           owner in (select schema',
'                     from wwv_flow_company_schemas',
'                     where security_group_id = :flow_security_group_id) and',
'           table_name = (',
'                     select max(c005) table_name',
'                     from apex_collections ',
'                     where collection_name = ''APEX$CREATE_APP_PAGE''',
'                     and n002 = :P1020_LINK_TO_PAGE',
'                     and c002 = ''INTERACTIVE_RPT''',
'                     and c003 = ''TABLE''',
'           ) and ',
'           (data_type in (''VARCHAR2'',''NUMBER'',''FLOAT'',''DATE''))',
'    union all',
'    -- drill down to master detail',
'    select wwv_flow_escape.html(column_name) d, column_name r, column_id n',
'    from sys.dba_tab_columns',
'    where  owner = :P1_SCHEMA and',
'           owner in (select schema',
'                     from wwv_flow_company_schemas',
'                     where security_group_id = :flow_security_group_id) and',
'           table_name = (',
'                     select max(c005) table_name',
'                     from apex_collections ',
'                     where collection_name = ''APEX$CREATE_APP_PAGE''',
'                     and n002 = :P1020_LINK_TO_PAGE',
'                     and c002 = ''MASTER_DETAIL''',
'                     and c003 = ''TABLE''',
'           ) and ',
'           (data_type in (''CHAR'',''NCHAR'',''VARCHAR2'',''NVARCHAR2'',''NUMBER'',''BINARY_FLOAT'',''BINARY_DOUBLE''))',
'    union all ',
'    -- drill down to IR on SQL',
'    select wwv_flow_escape.html(c005) d, c005 r, seq_id n',
'    from apex_collections ',
'    where collection_name = ''APEX$CREATE_APP_PAGE_COLUMN''',
'    and n002 = :P1020_LINK_TO_PAGE',
'    and c002 = ''INTERACTIVE_RPT''',
'    and c006 in (''VARCHAR2'',''NUMBER'',''DATE'')',
'    and c003 = ''SQL'' ) x',
'order by x.n'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_LINK_TO_PAGE'
,p_ajax_items_to_submit=>'P1020_LINK_TO_PAGE'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_required_patch=>wwv_flow_api.id(3145295462075987142.4024)
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3165198538983852603.4024)
,p_name=>'P1020_PAGE_HELP'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(3096986813591966835.4024)
,p_prompt=>'Guida sulla pagina'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(3076592553081438826.4024)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3692630755407728891.4024)
,p_name=>'P1020_FK1_COL'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(161342234287782302.4024)
,p_prompt=>'Chiave di ricerca 1'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select s.column_name d, s.column_name r',
'from WWV_FLOW_CONS_SYNC$ s',
'where ',
'     s.table_name      = :P1020_TABLE and',
'     s.owner           = :P1_SCHEMA and',
'     s.constraint_type = ''R'' and',
'     s.owner in (select schema from wwv_flow_company_schemas where security_group_id = :flow_security_group_id)',
'order by s.position'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_TABLE'
,p_ajax_items_to_submit=>'P1_SCHEMA'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3692670700243918901.4024)
,p_name=>'P1020_FK1_DISPLAY'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(161342234287782302.4024)
,p_prompt=>'Colonna di visualizzazione 1'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with app as (',
'    select schema owner',
'    from wwv_flow_company_schemas',
'    where security_group_id = :flow_security_group_id),',
'fk as (',
'    select s.referenced_owner owner, s.r_constraint_name constraint_name',
'    from wwv_flow_cons_sync$ s',
'    where s.column_name = :P1020_FK1_COL',
'    and s.table_name = :P1020_TABLE',
'    and s.owner = :P1_SCHEMA',
'    and s.constraint_type = ''R''),',
'parent as (',
'    select s.owner, s.table_name',
'    from wwv_flow_cons_sync$ s, fk fk2',
'    where s.owner = fk2.owner',
'    and s.constraint_name = fk2.constraint_name )',
'select col.table_name||''.''||col.column_name d, col.table_name||''.''||col.column_name r',
'from sys.dba_tab_columns col, parent p, app',
'where col.owner = p.owner',
'and col.table_name = p.table_name',
'and col.owner = :P1_SCHEMA',
'and col.owner = app.owner',
'order by col.column_id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_FK1_COL'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3692670801628918902.4024)
,p_name=>'P1020_FK2_COL'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(161342234287782302.4024)
,p_prompt=>'Chiave di ricerca 2'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select s.column_name d, s.column_name r',
'from WWV_FLOW_CONS_SYNC$ s',
'where table_name      = :P1020_TABLE and',
'     s.owner           = :P1_SCHEMA and',
'     s.table_name      = :P1020_TABLE and',
'     s.constraint_type = ''R'' and',
'     s.owner in (select schema from wwv_flow_company_schemas where security_group_id = :flow_security_group_id)',
'order by s.position'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_TABLE'
,p_ajax_items_to_submit=>'P1_SCHEMA'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3692670984817918903.4024)
,p_name=>'P1020_FK2_DISPLAY'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(161342234287782302.4024)
,p_prompt=>'Colonna di visualizzazione 2'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with app as (',
'    select schema owner',
'    from wwv_flow_company_schemas',
'    where security_group_id = :flow_security_group_id),',
'fk as (',
'    select s.referenced_owner owner, s.r_constraint_name constraint_name',
'    from wwv_flow_cons_sync$ s',
'    where s.column_name = :P1020_FK2_COL',
'    and s.table_name = :P1020_TABLE',
'    and s.owner = :P1_SCHEMA',
'    and s.constraint_type = ''R'' ),',
'parent as (',
'    select s.owner, s.table_name',
'    from wwv_flow_cons_sync$ s, fk fk2',
'    where s.owner = fk2.owner',
'    and s.constraint_name = fk2.constraint_name )',
'select col.table_name||''.''||col.column_name d, col.table_name||''.''||col.column_name r',
'from sys.dba_tab_columns col, parent p, app',
'where col.owner = p.owner',
'and col.table_name = p.table_name',
'and col.owner = :P1_SCHEMA',
'and col.owner = app.owner',
'order by col.column_id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_TABLE,P1020_FK2_COL'
,p_ajax_items_to_submit=>'P1_SCHEMA'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4069895283933556140.4024)
,p_name=>'P1020_FK3_COL'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(161342234287782302.4024)
,p_prompt=>'Chiave di ricerca 3'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select s.column_name d, s.column_name r',
'from WWV_FLOW_CONS_SYNC$ s',
'where table_name      = :P1020_TABLE and',
'     s.owner           = :P1_SCHEMA and',
'     s.table_name      = :P1020_TABLE and',
'     s.constraint_type = ''R'' and',
'     s.owner in (select schema from wwv_flow_company_schemas where security_group_id = :flow_security_group_id)',
'order by s.position'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_TABLE'
,p_ajax_items_to_submit=>'P1_SCHEMA'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4069895336869556141.4024)
,p_name=>'P1020_FK3_DISPLAY'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(161342234287782302.4024)
,p_prompt=>'Colonna di visualizzazione 3'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with app as (',
'    select schema owner',
'    from wwv_flow_company_schemas',
'    where security_group_id = :flow_security_group_id),',
'fk as (',
'    select s.referenced_owner owner, s.r_constraint_name constraint_name',
'    from wwv_flow_cons_sync$ s',
'    where s.column_name = :P1020_FK3_COL',
'    and s.table_name = :P1020_TABLE',
'    and s.owner = :P1_SCHEMA',
'    and s.constraint_type = ''R'' ),',
'parent as (',
'    select s.owner, s.table_name',
'    from wwv_flow_cons_sync$ s, fk fk2',
'    where s.owner = fk2.owner',
'    and s.constraint_name = fk2.constraint_name )',
'select col.table_name||''.''||col.column_name d, col.table_name||''.''||col.column_name r',
'from sys.dba_tab_columns col, parent p, app',
'where col.owner = p.owner',
'and col.table_name = p.table_name',
'and col.owner = :P1_SCHEMA',
'and col.owner = app.owner',
'order by col.column_id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_TABLE,P1020_FK3_COL'
,p_ajax_items_to_submit=>'P1_SCHEMA'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4069895460860556142.4024)
,p_name=>'P1020_FK4_COL'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(161342234287782302.4024)
,p_prompt=>'Chiave di ricerca 4'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select s.column_name d, s.column_name r',
'from WWV_FLOW_CONS_SYNC$ s',
'where table_name      = :P1020_TABLE and',
'     s.owner           = :P1_SCHEMA and',
'     s.table_name      = :P1020_TABLE and',
'     s.constraint_type = ''R'' and',
'     s.owner in (select schema from wwv_flow_company_schemas where security_group_id = :flow_security_group_id)',
'order by s.position'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_TABLE'
,p_ajax_items_to_submit=>'P1_SCHEMA'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4069895531601556143.4024)
,p_name=>'P1020_FK4_DISPLAY'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(161342234287782302.4024)
,p_prompt=>'Colonna di visualizzazione 4'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with app as (',
'    select schema owner',
'    from wwv_flow_company_schemas',
'    where security_group_id = :flow_security_group_id),',
'fk as (',
'    select s.referenced_owner owner, s.r_constraint_name constraint_name',
'    from wwv_flow_cons_sync$ s',
'    where s.column_name = :P1020_FK4_COL',
'    and s.table_name = :P1020_TABLE',
'    and s.owner = :P1_SCHEMA',
'    and s.constraint_type = ''R'' ),',
'parent as (',
'    select s.owner, s.table_name',
'    from wwv_flow_cons_sync$ s, fk fk2',
'    where s.owner = fk2.owner',
'    and s.constraint_name = fk2.constraint_name )',
'select col.table_name||''.''||col.column_name d, col.table_name||''.''||col.column_name r',
'from sys.dba_tab_columns col, parent p, app',
'where col.owner = p.owner',
'and col.table_name = p.table_name',
'and col.owner = :P1_SCHEMA',
'and col.owner = app.owner',
'order by col.column_id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona colonna -'
,p_lov_cascade_parent_items=>'P1020_TABLE,P1020_FK4_COL'
,p_ajax_items_to_submit=>'P1_SCHEMA'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(2584586946052082315.4024)
,p_item_css_classes=>'field--marginTop field--noBottomPadding'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(1917402362739338044.4024)
,p_validation_name=>'SQL Not Null'
,p_validation_sequence=>10
,p_validation=>'P1020_SQL'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per SQL report.'
,p_validation_condition=>'P1020_PAGE_SOURCE'
,p_validation_condition2=>'SQL'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_associated_item=>wwv_flow_api.id(2588922280227150516.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(2594841332254086002.4024)
,p_validation_name=>'valid query'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_describe_result wwv_flow_exec_dev.t_describe_result;',
'begin',
'    l_describe_result := wwv_flow_exec_dev.check_and_describe (',
'                            p_location             => wwv_flow_exec_api.c_location_local_db,',
'                            p_query_type           => wwv_flow_exec_api.c_query_type_sql_query,',
'                            p_sql_query            => :P1020_SQL,',
'                            p_application_id       => null,',
'                            p_parse_as_schema      => :P1_SCHEMA );',
'                            ',
'    return l_describe_result.error_message;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_validation_condition=>':P1020_PAGE_SOURCE = ''SQL'' and :P1020_SQL is not null'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(2594841230551086001.4024)
,p_validation_name=>'P1020_TABLE not null'
,p_validation_sequence=>40
,p_validation=>'P1020_TABLE'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare il nome della tabella.'
,p_validation_condition=>'P1020_PAGE_SOURCE'
,p_validation_condition2=>'TABLE'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3674116603524496404.4024)
,p_validation_name=>'P1020_FK1_DISPLAY not null'
,p_validation_sequence=>60
,p_validation=>'P1020_FK1_DISPLAY'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>'P1020_FK1_COL'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3674116739747496405.4024)
,p_validation_name=>'P1020_FK2_DISPLAY not null'
,p_validation_sequence=>90
,p_validation=>'P1020_FK2_DISPLAY'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>'P1020_FK2_COL'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(2934951585068675440.4024)
,p_validation_name=>'P1020_LINK_COLUMN not null'
,p_validation_sequence=>100
,p_validation=>'P1020_LINK_COLUMN'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P1020_LINK_KEY is not null or',
':P1020_LINK_TO_PAGE is not null or',
':P1020_LINK_TARGET_KEY is not null'))
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3172045030132109006.4024)
,p_validation_name=>'P1020_LINK_KEY not null'
,p_validation_sequence=>110
,p_validation=>'P1020_LINK_KEY'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P1020_LINK_COLUMN is not null or',
':P1020_LINK_TO_PAGE is not null or',
':P1020_LINK_TARGET_KEY is not null'))
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3172045192137109007.4024)
,p_validation_name=>'P1020_LINK_TO_PAGE not null'
,p_validation_sequence=>120
,p_validation=>'P1020_LINK_TO_PAGE'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P1020_LINK_COLUMN is not null or',
':P1020_LINK_KEY is not null or',
':P1020_LINK_TARGET_KEY is not null'))
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(3172045272382109008.4024)
,p_validation_name=>'P1020_LINK_TARGET_KEY not null'
,p_validation_sequence=>130
,p_validation=>'P1020_LINK_TARGET_KEY'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P1020_LINK_COLUMN is not null or',
':P1020_LINK_KEY is not null or',
':P1020_LINK_TO_PAGE is not null'))
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(524767556610188203.4024)
,p_validation_name=>'P1020_FK3_DISPLAY not null'
,p_validation_sequence=>140
,p_validation=>'P1020_FK3_DISPLAY'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>'P1020_FK3_COL'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(4069895336869556141.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(524767657574188204.4024)
,p_validation_name=>'P1020_FK4_DISPLAY not null'
,p_validation_sequence=>150
,p_validation=>'P1020_FK4_DISPLAY'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare un valore per #LABEL#.'
,p_validation_condition=>'P1020_FK4_COL'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(4069895531601556143.4024)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2592763122022479681.4024)
,p_name=>'Initialize Page'
,p_event_sequence=>10
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(4028879176364133401.4024)
,p_event_id=>wwv_flow_api.id(2592763122022479681.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1020_FK_COUNT'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with app as (',
'    select schema owner',
'    from wwv_flow_company_schemas',
'    where security_group_id = :flow_security_group_id)',
'select count(''x'')',
'from wwv_flow_cons_sync$ s, app',
'where    s.table_name      = :P1020_TABLE',
'and      s.owner           = :P1_SCHEMA',
'and      s.owner           = app.owner',
'and      s.constraint_type = ''R'''))
,p_attribute_07=>'P1020_TABLE'
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2588922623166150520.4024)
,p_name=>'Show Page Source'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1020_PAGE_SOURCE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2588922714412150521.4024)
,p_event_id=>wwv_flow_api.id(2588922623166150520.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var page_source_sql$ = $("#page_source_sql"),',
'    page_source_table$ = $("#page_source_table"),',
'    drill_down_link_region$ = $("#drill_down_link_region"),',
'    lookup_column_region$ = $("#lookup_column_region"),',
'    rptType = $v(''P1020_REPORT_TYPE''),',
'    pageType = $v(''P1020_PAGE_SOURCE''),',
'    fkCount = $v(''P1020_FK_COUNT'');',
'',
'if (pageType === ''SQL'') {',
'    page_source_sql$.show();',
'    page_source_table$.hide();',
'    drill_down_link_region$.hide();',
'    lookup_column_region$.hide();',
'} else if (pageType === ''TABLE'') {',
'    page_source_sql$.hide();',
'    page_source_table$.show();',
'	if (rptType === ''INTERACTIVE_RPT'') {',
'		drill_down_link_region$.show();',
'	} else {',
'		drill_down_link_region$.hide();',
'	}',
'    if (fkCount === ''0'') {',
'        lookup_column_region$.hide();',
'    } else {',
'        lookup_column_region$.show();',
'    }',
'}'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2714284462652099432.4024)
,p_name=>'Check Object Type'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1020_TABLE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2714284589477099433.4024)
,p_event_id=>wwv_flow_api.id(2714284462652099432.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'select object_type ',
'from sys.dba_objects ',
'where owner = :P1_SCHEMA ',
'      and object_name = :P1020_TABLE',
') loop',
'    :P1020_OBJ_TYPE := c1.object_type;',
'end loop;'))
,p_attribute_02=>'P1020_TABLE'
,p_attribute_03=>'P1020_OBJ_TYPE'
,p_attribute_04=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2698016887785126303.4024)
,p_name=>'Cancel Dialog'
,p_event_sequence=>30
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(2698016791258126302.4024)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2698016913389126304.4024)
,p_event_id=>wwv_flow_api.id(2698016887785126303.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2714285100069099439.4024)
,p_name=>'Enable or Disable Include Form'
,p_event_sequence=>50
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1020_OBJ_TYPE'
,p_condition_element=>'P1020_OBJ_TYPE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'TABLE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2714285223777099440.4024)
,p_event_id=>wwv_flow_api.id(2714285100069099439.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1020_INCLUDE_FORM'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2714285556367099443.4024)
,p_event_id=>wwv_flow_api.id(2714285100069099439.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CLEAR'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1020_INCLUDE_FORM'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2714285429349099442.4024)
,p_event_id=>wwv_flow_api.id(2714285100069099439.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1020_INCLUDE_FORM'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(784430682090840048.4024)
,p_name=>'Disable Admin'
,p_event_sequence=>60
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1020_HOMEPAGE'
,p_condition_element=>'P1020_HOMEPAGE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(784430732956840049.4024)
,p_event_id=>wwv_flow_api.id(784430682090840048.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1020_ADMIN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(784430879070840050.4024)
,p_event_id=>wwv_flow_api.id(784430682090840048.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1020_ADMIN'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3019477620145899601.4024)
,p_name=>'Disable Home Page'
,p_event_sequence=>70
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1020_ADMIN'
,p_condition_element=>'P1020_ADMIN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3019477752300899602.4024)
,p_event_id=>wwv_flow_api.id(3019477620145899601.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1020_HOMEPAGE'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3019477891506899603.4024)
,p_event_id=>wwv_flow_api.id(3019477620145899601.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1020_HOMEPAGE'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3210720298049760402.4024)
,p_name=>'Show or Hide Drill Down'
,p_event_sequence=>80
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1020_REPORT_TYPE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3210720372779760403.4024)
,p_event_id=>wwv_flow_api.id(3210720298049760402.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var curItem = $v(this.triggeringElement);',
'var curType = $v(''P1020_PAGE_SOURCE'');',
'var drill_down_link_region$ = $("#drill_down_link_region");',
'',
'if (curType === ''TABLE'') {',
'	if (curItem === ''INTERACTIVE_RPT'') {',
'		drill_down_link_region$.show();',
'	} else {',
'		drill_down_link_region$.hide();',
'	}',
'}'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3674117008533496408.4024)
,p_name=>'show hide lookup columns'
,p_event_sequence=>90
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1020_TABLE'
,p_condition_element=>'P1020_TABLE'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(164836447770930744.4024)
,p_event_id=>wwv_flow_api.id(3674117008533496408.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(161342234287782302.4024)
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3775764773992368410.4024)
,p_event_id=>wwv_flow_api.id(3674117008533496408.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>40
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1020_FK_COUNT'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'0'
,p_attribute_09=>'N'
,p_wait_for_result=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3674117138145496409.4024)
,p_event_id=>wwv_flow_api.id(3674117008533496408.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>50
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P1020_FK_COUNT'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with app as (',
'    select schema owner',
'    from wwv_flow_company_schemas',
'    where security_group_id = :flow_security_group_id)',
'select count(''x'')',
'from wwv_flow_cons_sync$ s, app',
'where    s.table_name      = :P1020_TABLE',
'and      s.owner           = :P1_SCHEMA',
'and      s.owner           = app.owner',
'and      s.constraint_type = ''R'''))
,p_attribute_07=>'P1020_TABLE'
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(3775764849188368411.4024)
,p_name=>'Display Lookup Columns'
,p_event_sequence=>110
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1020_FK_COUNT'
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'$v("P1020_FK_COUNT") > 0 '
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3775764944238368412.4024)
,p_event_id=>wwv_flow_api.id(3775764849188368411.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(161342234287782302.4024)
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(3775765184854368414.4024)
,p_event_id=>wwv_flow_api.id(3775764849188368411.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(161342234287782302.4024)
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(484259742902237704.4024)
,p_name=>'show hide lookup'
,p_event_sequence=>120
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P1020_REPORT_TYPE'
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'$v("P1020_FK_COUNT") > 0'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(484259864213237705.4024)
,p_event_id=>wwv_flow_api.id(484259742902237704.4024)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(161342234287782302.4024)
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(484259965230237706.4024)
,p_event_id=>wwv_flow_api.id(484259742902237704.4024)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(161342234287782302.4024)
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2592761932386479677.4024)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_fk_list   wwv_flow_define_app_v3.t_fk_list;',
'begin',
'    if :P1020_FK1_COL is not null and :P1020_FK1_DISPLAY is not null then',
'        l_fk_list(l_fk_list.count + 1).fk_column := :P1020_FK1_COL;',
'        l_fk_list(l_fk_list.count).detail_table_display_col := :P1020_FK1_DISPLAY;',
'    end if;',
'    if :P1020_FK2_COL is not null and :P1020_FK2_DISPLAY is not null then',
'        l_fk_list(l_fk_list.count + 1).fk_column := :P1020_FK2_COL;',
'        l_fk_list(l_fk_list.count).detail_table_display_col := :P1020_FK2_DISPLAY;',
'    end if;',
'    if :P1020_FK3_COL is not null and :P1020_FK3_DISPLAY is not null then',
'        l_fk_list(l_fk_list.count + 1).fk_column := :P1020_FK3_COL;',
'        l_fk_list(l_fk_list.count).detail_table_display_col := :P1020_FK3_DISPLAY;',
'    end if;',
'    if :P1020_FK4_COL is not null and :P1020_FK4_DISPLAY is not null then',
'        l_fk_list(l_fk_list.count + 1).fk_column := :P1020_FK4_COL;',
'        l_fk_list(l_fk_list.count).detail_table_display_col := :P1020_FK4_DISPLAY;',
'    end if;',
'',
'    wwv_flow_define_app_v3.add_page(',
'         p_page_name        => :P1020_PAGE_NAME,',
'         p_page_type        => :P1020_REPORT_TYPE,',
'         p_page_icon        => :P1020_PAGE_ICON,',
'         p_schema           => :P1_SCHEMA,',
'         p_source_type      => :P1020_PAGE_SOURCE,',
'         p_source           => ( case when :P1020_PAGE_SOURCE = ''SQL'' then :P1020_SQL end ),',
'         p_table_name       => ( case when :P1020_PAGE_SOURCE = ''TABLE'' then :P1020_TABLE end ),',
'         p_include_form     => ( case when :P1020_PAGE_SOURCE = ''TABLE'' then :P1020_INCLUDE_FORM = ''Y'' end ),',
'         p_is_homepage      => ( :P1020_HOMEPAGE = ''Y'' ),',
'         p_is_admin_page    => ( :P1020_ADMIN = ''Y''),',
'         p_fk_list          => l_fk_list,',
'         --',
'         p_link_column      => :P1020_LINK_COLUMN,',
'         p_link_key         => :P1020_LINK_KEY,',
'         p_link_to_page     => :P1020_LINK_TO_PAGE,',
'         p_link_target_key  => :P1020_LINK_TARGET_KEY,',
'         p_page_help        => :P1020_PAGE_HELP );',
'end;'))
,p_process_error_message=>'errore durante l''aggiunta della pagina #SQLERRM#'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(2592761156064479648.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2592762301456479678.4024)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Edit Page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_fk_list   wwv_flow_define_app_v3.t_fk_list;',
'begin',
'    if :P1020_FK1_COL is not null and :P1020_FK1_DISPLAY is not null then',
'        l_fk_list(l_fk_list.count + 1).fk_column := :P1020_FK1_COL;',
'        l_fk_list(l_fk_list.count).detail_table_display_col := :P1020_FK1_DISPLAY;',
'    end if;',
'    if :P1020_FK2_COL is not null and :P1020_FK2_DISPLAY is not null then',
'        l_fk_list(l_fk_list.count + 1).fk_column := :P1020_FK2_COL;',
'        l_fk_list(l_fk_list.count).detail_table_display_col := :P1020_FK2_DISPLAY;',
'    end if;',
'    if :P1020_FK3_COL is not null and :P1020_FK3_DISPLAY is not null then',
'        l_fk_list(l_fk_list.count + 1).fk_column := :P1020_FK3_COL;',
'        l_fk_list(l_fk_list.count).detail_table_display_col := :P1020_FK3_DISPLAY;',
'    end if;',
'    if :P1020_FK4_COL is not null and :P1020_FK4_DISPLAY is not null then',
'        l_fk_list(l_fk_list.count + 1).fk_column := :P1020_FK4_COL;',
'        l_fk_list(l_fk_list.count).detail_table_display_col := :P1020_FK4_DISPLAY;',
'    end if;',
'',
'    wwv_flow_define_app_v3.edit_page(',
'        p_page_id          => :P1020_SEQ_ID,',
'        p_page_name        => :P1020_PAGE_NAME,',
'        p_page_type        => :P1020_REPORT_TYPE,',
'        p_page_icon        => :P1020_PAGE_ICON,',
'        p_schema           => :P1_SCHEMA,',
'        p_source_type      => :P1020_PAGE_SOURCE,',
'        p_source           => ( case when :P1020_PAGE_SOURCE = ''SQL''   then :P1020_SQL end ),',
'        p_table_name       => ( case when :P1020_PAGE_SOURCE = ''TABLE'' then :P1020_TABLE end ),',
'        p_include_form     => ( case when :P1020_PAGE_SOURCE = ''TABLE'' then :P1020_INCLUDE_FORM = ''Y'' end ),',
'        p_is_homepage      => ( :P1020_HOMEPAGE = ''Y'' ),',
'        p_is_admin_page    => ( :P1020_ADMIN = ''Y''),',
'        p_fk_list          => l_fk_list,',
'        --',
'        p_link_column      => :P1020_LINK_COLUMN,',
'        p_link_key         => :P1020_LINK_KEY,',
'        p_link_to_page     => :P1020_LINK_TO_PAGE,',
'        p_link_target_key  => :P1020_LINK_TARGET_KEY,',
'        --',
'        p_page_help        => :P1020_PAGE_HELP);',
'end;'))
,p_process_error_message=>'errore durante la modifica della pagina #SQLERRM#'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(2592760790910479646.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(7261597284772829.4024)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_define_app_v3.delete_page(',
'    p_page_id => :P1020_SEQ_ID );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(7261489151772828.4024)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_