prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4054
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4054 - Oracle APEX Internal Administration
--
-- Application Export:
--   Application:     4054
--   Name:            Oracle APEX Internal Administration
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                    168
--       Items:                  570
--       Computations:            59
--       Validations:            169
--       Processes:              167
--       Regions:                605
--       Buttons:                352
--       Dynamic Actions:         51
--     Shared Components:
--       Logic:
--         Items:                  5
--         Processes:              1
--         Computations:           3
--         Build Options:          3
--       Navigation:
--         Lists:                 39
--         Breadcrumbs:            1
--           Entries:            159
--         NavBar Entries:         4
--       Security:
--         Authentication:         8
--         Authorization:          9
--       User Interface:
--         Templates:
--           Page:                13
--           Region:              45
--           Label:               12
--           List:                15
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           2
--           Button:              12
--           Report:              13
--         LOVs:                 118
--         Shortcuts:              5
--         Plug-ins:              12
--       Globalization:
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Internal Administration')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286621089380918559')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135305'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'it'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(540226219724705040.4054)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_runtime_api_usage=>'O:W'
,p_security_scheme=>wwv_flow_api.id(1018002984071621)
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'LOGOUT'
,p_substitution_value_01=>'Logout'
,p_substitution_string_02=>'DELETE_MSG'
,p_substitution_value_02=>'Eseguire questa azione di eliminazione?'
,p_substitution_string_03=>'HELP'
,p_substitution_value_03=>'Guida'
,p_substitution_string_04=>'PRODUCT_NAME'
,p_substitution_value_04=>'Application Express'
,p_substitution_string_05=>'COMPANY_NAME'
,p_substitution_value_05=>'Area di lavoro'
,p_substitution_string_06=>'MSG_COMPANY'
,p_substitution_value_06=>'Area di lavoro: &COMPANY.'
,p_substitution_string_07=>'MSG_LANGUAGE'
,p_substitution_value_07=>'Lingua'
,p_substitution_string_08=>'MSG_COPYRIGHT'
,p_substitution_value_08=>unistr('Copyright \00A9 1999-2019, Oracle e/o relative consociate. Tutti i diritti riservati.')
,p_substitution_string_09=>'MSG_USER'
,p_substitution_value_09=>'Utente'
,p_substitution_string_10=>'MSG_JSCRIPT'
,p_substitution_value_10=>'Eseguire questo prodotto con JavaScript abilitato.'
,p_substitution_string_11=>'MSG_TBL_SUMMARY'
,p_substitution_value_11=>'Tabella di layout di pagina'
,p_substitution_string_12=>'EDIT'
,p_substitution_value_12=>'Modifica'
,p_substitution_string_13=>'DONE'
,p_substitution_value_13=>'Fine'
,p_substitution_string_14=>'TOP'
,p_substitution_value_14=>'Inizio pagina'
,p_substitution_string_15=>'CLOSE'
,p_substitution_value_15=>'Chiudi'
,p_substitution_string_16=>'DATE_FORMAT'
,p_substitution_value_16=>'dd/mm/yyyy'
,p_substitution_string_17=>'LONG_DATE_FORMAT'
,p_substitution_value_17=>'fmDay dd Month yyyy'
,p_substitution_string_18=>'TIME_FORMAT'
,p_substitution_value_18=>'hh24:mi:ss'
,p_substitution_string_19=>'DATE_TIME_FORMAT'
,p_substitution_value_19=>'dd/mm/yyyy hh24:mi:ss'
,p_substitution_string_20=>'RETURN_TO_APP'
,p_substitution_value_20=>'Torna all''applicazione'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141103'
,p_global_notification=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style type="text/css">',
'<!--',
'#htmldbWorkspace{display:none;}',
'-->',
'</style>'))
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/session_state_management
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(3417102067886535.4054)
,p_name=>'session.state.management'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3439527750998023.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Sessioni recenti'
,p_list_item_link_target=>'f?p=&APP_ID.:65:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-recent-sessions'
,p_list_text_01=>'Controllare le sessioni recenti in tutta l''istanza, compresi nome utente e area di lavoro.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3462301271103893.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Svuota sessioni'
,p_list_item_link_target=>'f?p=&APP_ID.:66:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-purge-sessions-age'
,p_list_text_01=>'Rimuovere le informazioni sullo stato della sessione in base alla durata della sessione.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3417616612890680.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Statistiche stato sessioni'
,p_list_item_link_target=>'f?p=&APP_ID.:64:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-session-state-statistics'
,p_list_text_01=>'Statistiche sul numero di sessioni e le voci inserite nella cache.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/log_management
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(5021913929565780.4054)
,p_name=>'log.management'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22612925776612371.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Log di SQL Workshop'
,p_list_item_link_target=>'f?p=&APP_ID.:46:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'46'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5024227220579151.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Log di attivit\00E0 delle visualizzazioni di pagina')
,p_list_item_link_target=>'f?p=&APP_ID.:61:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5032419648605291.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Log di attivit\00E0 dello sviluppatore')
,p_list_item_link_target=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5141329999655580.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Log di conteggio clic esterni'
,p_list_item_link_target=>'f?p=&APP_ID.:85:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(15382629387113488.4054)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Log degli accessi di login'
,p_list_item_link_target=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(217657516318353638.4054)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Gestisci intervallo di log'
,p_list_item_link_target=>'f?p=&APP_ID.:119:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1218056692025697508.4054)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('Archivia log attivit\00E0')
,p_list_item_link_target=>'f?p=&APP_ID.:34:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(620861715997218025.4054)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('Log di attivit\00E0 Web Service')
,p_list_item_link_target=>'f?p=&APP_ID.:139:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(10332318553893424.4054)
,p_name=>'workspace reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10336708903919077.4054)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Aree di lavoro esistenti'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10338404532927250.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Dettagli area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:RP,14:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(10335923317913792.4054)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Privilegi database area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25560113322884543.4054)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>'Aree di lavoro solo con applicazione di esempio'
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168488129805460181.4054)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'Gestisci utilizzo file'
,p_list_item_link_target=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1222568618805757405.4054)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>'Trova e invia via posta elettronica riepilogo area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(524767964229086348.4054)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>'Cache dizionario dati'
,p_list_item_link_target=>'f?p=&APP_ID.:150:&SESSION.::&DEBUG.:RP,150:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/auto_provision_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(12048115202363924.4054)
,p_name=>'auto.provision.progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12057805252417809.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Identifica area di lavoro'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'27'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12659809588228188.4054)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Identifica schema'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'79'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12058110447419334.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Identifica amministratore'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'72'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12058415642420858.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Conferma richiesta'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'73'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168860731992836215.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Conferma operazione riuscita'
,p_list_item_link_target=>'f?p=&APP_ID.:74:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'74'
);
end;
/
prompt --application/shared_components/navigation/lists/company_admin_remove
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(14571819699173520.4054)
,p_name=>'company.admin.remove'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14575726756185055.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Identifica area di lavoro'
,p_list_item_link_target=>'f?p=&FLOW_ID.:81:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'81'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14576220654192685.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Verifica applicazioni'
,p_list_item_link_target=>'f?p=&FLOW_ID.:82:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'82'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14576707972198542.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Conferma rimozione area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:83:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'83'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_activtiy_date_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(14738731575074699.4054)
,p_name=>'monitor.activtiy.date.reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14743211405087780.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Ultimo utilizzo area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_disp_cond_type=>'NOT_EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flows where id = 4000 and FLOW_VERSION like ''% 2.1.%'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14744721102090541.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Per giorno per applicazione e utente'
,p_list_item_link_target=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14745728374092653.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Per ora'
,p_list_item_link_target=>'f?p=&APP_ID.:69:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_activity_os_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(14750409028115431.4054)
,p_name=>'monitor.activity.os.reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14750617712115433.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Per sistema operativo'
,p_list_item_link_target=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14751517869115434.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Per browser'
,p_list_item_link_target=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14750901683115434.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Per User Agent'
,p_list_item_link_target=>'f?p=&APP_ID.:38:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14751217522115434.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Per sito esterno'
,p_list_item_link_target=>'f?p=&APP_ID.:45:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/company_admin_schema
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(18701007817245520.4054)
,p_name=>'company.admin.schema'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18701529288251758.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Nuovo o esistente'
,p_list_item_link_target=>'f?p=4050:105:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'105'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18702119030258176.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Scegli area di lavoro'
,p_list_item_link_target=>'f?p=4050:107:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'107'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18701805178254192.4054)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Identifica schema'
,p_list_item_link_target=>'f?p=&FLOW_ID.:106:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'106'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18702425610260147.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Conferma'
,p_list_item_link_target=>'f?p=4050:108:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'108'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_service
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(19017202882431374.4054)
,p_name=>'manage.service'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(75154318706107288.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Task specifici del sito'
,p_list_item_link_target=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:17:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_disp_cond_type=>'NEVER'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2584422400873819.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Stato sessione'
,p_list_item_link_target=>'f?p=&APP_ID.:63:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(50289618943123605.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Coda della posta'
,p_list_item_link_target=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2702728512959332.4054)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Gestisci richieste di download'
,p_list_item_link_target=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_disp_cond_type=>'HTTP_HOST_EQ_CONDITION'
,p_list_item_disp_condition=>'marvel.oracle.com'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3573418802449584.4054)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Autorizzazioni file'
,p_list_item_link_target=>'f?p=&APP_ID.:95:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_disp_cond_type=>'NEVER'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(201522704568695924.4054)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Traduzioni installate'
,p_list_item_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(274115211211763732.4054)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Sottoscrizioni a report interattivo'
,p_list_item_link_target=>'f?p=&APP_ID.:129:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_workspace
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(19017606691432489.4054)
,p_name=>'Manage Workspace'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2569313499653574.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Crea area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:27,79,72,73,74:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384629092101759662.4054)
,p_list_item_display_sequence=>10.5
,p_list_item_link_text=>'Crea area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.:142:LAST_VIEW:10:'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_required_patch=>-wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203140401722334966.4054)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>unistr('Crea pi\00F9 aree di lavoro')
,p_list_item_link_target=>'f?p=&APP_ID.:115:&SESSION.::&DEBUG.:115,116,117:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14538928292646129.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Rimuovi area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:81:&SESSION.::&DEBUG.:81,82:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(74659715539048394.4054)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'Blocca area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:89:&SESSION.::&DEBUG.:89,90:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19720903523535398.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Gestisci assegnazioni area di lavoro a schema'
,p_list_item_link_target=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14539719765653081.4054)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Gestisci sviluppatori e utenti'
,p_list_item_link_target=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(173286806863766271.4054)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('Gestisci disponibilit\00E0 componente')
,p_list_item_link_target=>'f?p=&APP_ID.:52:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(29722514446881924.4054)
,p_name=>'Workspace Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(29722732656881928.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Crea area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:27,79,72,73,74:::'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt=""'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(385021728151143594.4054)
,p_list_item_display_sequence=>10.5
,p_list_item_link_text=>'Crea area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.:142:LAST_VIEW:3:'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt=""'
,p_required_patch=>-wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203154302892486334.4054)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>unistr('Crea pi\00F9 aree di lavoro')
,p_list_item_link_target=>'f?p=&APP_ID.:115:&SESSION.::&DEBUG.:RP,115,116,117:::'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(29758112134439446.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Trova un''area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(29723016608881931.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Gestisci aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:81,82:::'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46460724791484872.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Crea utente'
,p_list_item_link_target=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:23,EDIT_USER_PRIVS:::'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt=""'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(46461311070490353.4054)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Trova un utente'
,p_list_item_link_target=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt=""'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168923102453062025.4054)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Reimposta password utente'
,p_list_item_link_target=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt=""'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(40102013671283832.4054)
,p_name=>'Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40120501775346610.4054)
,p_list_item_display_sequence=>0
,p_list_item_link_text=>'Home'
,p_list_item_link_target=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3,8000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40102417827285020.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Gestisci richieste'
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.::::'
,p_list_item_icon_alt_attribute=>'Gestisci espansione richieste'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4,5,6,7,8,26,28,55,56,110'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192003502869565470.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Tutte le richieste'
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(40102417827285020.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192008121139589728.4054)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Richieste di area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:RIR:::'
,p_parent_list_item_id=>wwv_flow_api.id(40102417827285020.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192008426680591330.4054)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Richieste di modifica'
,p_list_item_link_target=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:RIR:::'
,p_parent_list_item_id=>wwv_flow_api.id(40102417827285020.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168497310730577652.4054)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Gestisci istanza'
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::::'
,p_list_item_icon_alt_attribute=>'Gestisci espansione istanza'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9,16,17,18,19,42,46,47,48,51,57,58,61,62,63,64,65,66,67,70,75,85,97,100,103,109,112,120,121,125,130,131,132,133,555,104,126,127,128,129,139'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192009126119600562.4054)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Configurazione funzioni'
,p_list_item_link_target=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:16:::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192009404086603691.4054)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Sicurezza'
,p_list_item_link_target=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:RP,130:::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192021904535736262.4054)
,p_list_item_display_sequence=>91
,p_list_item_link_text=>unistr('...Gestisci complessit\00E0 password')
,p_list_item_link_target=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:130:::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192009919323608095.4054)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Impostazioni istanza'
,p_list_item_link_target=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.:RP,131:::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(505869000009873298.4054)
,p_list_item_display_sequence=>101
,p_list_item_link_text=>'Rimozione aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:133:&SESSION.::&DEBUG.:133:::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192010225903610036.4054)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Messaggio di login'
,p_list_item_link_target=>'f?p=&APP_ID.:41:&SESSION.::&DEBUG.:41:::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192010501793612513.4054)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Messaggio di sistema'
,p_list_item_link_target=>'f?p=&APP_ID.:132:&SESSION.::&DEBUG.:132:::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192010809065614604.4054)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Coda della posta'
,p_list_item_link_target=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:120:::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192011102270622092.4054)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Gestisci temi pubblici'
,p_list_item_link_target=>'f?p=&APP_ID.:555:&SESSION.::&DEBUG.:555:::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192011427682638942.4054)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Gestisci task del sito'
,p_list_item_link_target=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:RP,18,RIR:::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192011731491640037.4054)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Altro...'
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(168497310730577652.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40117612941330955.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Gestisci aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_icon_alt_attribute=>'Gestisci espansione aree di lavoro'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1,2,10,11,12,14,20,21,22,23,27,52,53,72,73,74,78,79,81,82,83,84,89,90,105,106,107,108,163,165,173,277,278,400,401,460,461,4001'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192012018809645759.4054)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Crea area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:RP,27,79,72,73,74:::'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(384636912354118367.4054)
,p_list_item_display_sequence=>175
,p_list_item_link_text=>'Crea area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.:RP,142:LAST_VIEW:&APP_PAGE_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_required_patch=>-wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192012326774648053.4054)
,p_list_item_display_sequence=>180
,p_list_item_link_text=>'Rimuovi area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:81:&SESSION.::&DEBUG.:81,82:::'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192012604395651102.4054)
,p_list_item_display_sequence=>190
,p_list_item_link_text=>'Blocca area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:89:&SESSION.::&DEBUG.:89,90:::'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192012915477654263.4054)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'Gestisci assegnazioni di schema'
,p_list_item_link_target=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:21:::'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192013221710656102.4054)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Gestisci sviluppatori e utenti'
,p_list_item_link_target=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:RP,RIR,12:::'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192013528290657957.4054)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('Disponibilit\00E0 componente')
,p_list_item_link_target=>'f?p=&APP_ID.:52:&SESSION.::&DEBUG.:52:::'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192013809374661985.4054)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Importa'
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.:460:::'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192014115261663655.4054)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Esporta'
,p_list_item_link_target=>'f?p=&APP_ID.:461:&SESSION.::&DEBUG.:461:::'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192037810881946241.4054)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>'Trova area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:8000,RIR:::'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192014424612666345.4054)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>'Altro...'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(40117612941330955.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(40118231988336452.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Controlla attivit\00E0')
,p_list_item_link_target=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.::::'
,p_list_item_icon_alt_attribute=>unistr('Monitoraggio espansione attivit\00E0')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'15,24,25,29,30,33,35,36,37,38,40,43,45,49,54,68,69,77,80,87,91,98,99,122,123,500,501,94,101'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192015123011675355.4054)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>'Per visualizzazione pagina'
,p_list_item_link_target=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:30,RIR:::'
,p_parent_list_item_id=>wwv_flow_api.id(40118231988336452.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192022507006765338.4054)
,p_list_item_display_sequence=>280
,p_list_item_link_text=>'Per applicazione e utente'
,p_list_item_link_target=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.:49,RIR:::'
,p_parent_list_item_id=>wwv_flow_api.id(40118231988336452.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192023224668770519.4054)
,p_list_item_display_sequence=>290
,p_list_item_link_text=>'Per utente'
,p_list_item_link_target=>'f?p=&APP_ID.:36:&SESSION.::&DEBUG.:RIR,36:::'
,p_parent_list_item_id=>wwv_flow_api.id(40118231988336452.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192023531594772458.4054)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Per applicazione'
,p_list_item_link_target=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.:44,RIR:::'
,p_parent_list_item_id=>wwv_flow_api.id(40118231988336452.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192023804367774121.4054)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>'Per area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:33,RIR:::'
,p_parent_list_item_id=>wwv_flow_api.id(40118231988336452.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192024111293776033.4054)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'Per giorno'
,p_list_item_link_target=>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.:54,RIR:::'
,p_parent_list_item_id=>wwv_flow_api.id(40118231988336452.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(505871428238919208.4054)
,p_list_item_display_sequence=>321
,p_list_item_link_text=>'Rimozione aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:99:&SESSION.::&DEBUG.:RP,99:::'
,p_parent_list_item_id=>wwv_flow_api.id(40118231988336452.4054)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(192024420643778774.4054)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>'Altro...'
,p_list_item_link_target=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(40118231988336452.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_import_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(44758222502979988.4054)
,p_name=>'workspace.import.progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(44758413648979994.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Specifica file'
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(44758705753979997.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Conferma importazione file'
,p_list_item_link_target=>'f?p=&APP_ID.:163:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(44772030609546251.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Installa'
,p_list_item_link_target=>'f?p=&APP_ID.:165:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_install_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(44806708563745373.4054)
,p_name=>'workspace.install.progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(44807506675745375.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Scegliere uno schema'
,p_list_item_link_target=>'f?p=&APP_ID.:277:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(44807814227745375.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Conferma'
,p_list_item_link_target=>'f?p=&APP_ID.:278:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(44808114099745375.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Installa'
,p_list_item_link_target=>'f?p=&APP_ID.:165:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_environment_settings
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47534314618390800.4054)
,p_name=>'Manage Environment Settings'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47534823276393319.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Configurazione funzioni'
,p_list_item_link_target=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47535207130398100.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Sicurezza'
,p_list_item_link_target=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47556700138566373.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Impostazioni istanza'
,p_list_item_link_target=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(499030206357384810.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Rimozione aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:133:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_disp_cond_type=>'NEVER'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(617444115874754241.4054)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Impostazioni rimozione aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:133:&SESSION.::&DEBUG.:RP,133:::'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(25757200722107116.4054)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Gestisci Iscrizione guidata nuovo servizio'
,p_list_item_link_target=>'f?p=&APP_ID.:111:&SESSION.::&DEBUG.::P111_ID:1:'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_disp_cond_type=>'NEVER'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(567115485135865871.4054)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Interfaccia di amministrazione REST'
,p_list_item_link_target=>'f?p=&APP_ID.:600:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(579807421489291896)
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_workspace_export_import
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(47558804136960608.4054)
,p_name=>'Manage Workspace Export Import'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47560509223960618.4054)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Importa area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47560826571960618.4054)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Esporta area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:461:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/login_attempts
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(49036204543378170.4054)
,p_name=>'Login Attempts'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(49037015450378171.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Tentativi di login'
,p_list_item_link_target=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(49037309244378171.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Ultimo login sviluppatore'
,p_list_item_link_target=>'f?p=&APP_ID.:35:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/export_install_navigate
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(79863815294295743.4054)
,p_name=>'export.install.navigate'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(166801801886544568.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Visualizza file di esportazione area di lavoro importata'
,p_list_item_link_target=>'f?p=&APP_ID.:173:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_app_temp_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(122623332344967000.4054)
,p_name=>'workspace_app_temp_progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(122623530898967003.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Specifica file'
,p_list_item_link_target=>'f?p=&APP_ID.:112:&SESSION.:'
,p_list_item_current_for_pages=>'112'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(122623817692967004.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Dettaglio applicazione'
,p_list_item_link_target=>'f?p=&APP_ID.:109:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(122624126430967004.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Conferma'
,p_list_item_link_target=>'f?p=&APP_ID.:103:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/service_requests
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(130557109467559465.4054)
,p_name=>'Service Requests'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(132554913295711981.4054)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Nuove richieste di servizio'
,p_list_item_link_target=>'f?p=&APP_ID.:114:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(130557304381559466.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Sondaggio iscrizione'
,p_list_item_link_target=>'f?p=&APP_ID.:113:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_public_themes
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(137961006165346808.4054)
,p_name=>'Manage Public Themes'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(254193210569287504.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Applicazioni di produttivit\00E0 e di esempio')
,p_list_item_link_target=>'f?p=&APP_ID.:104:&SESSION.::&DEBUG.:104:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'height="20" width="20" alt=""'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(137961613784349078.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Temi pubblici'
,p_list_item_link_target=>'f?p=&APP_ID.:555:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'height="20" width="20" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_theme_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(138045104803643281.4054)
,p_name=>'workspace theme progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(138155608448962419.4054)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:47:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'47'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(138156115720964594.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Applicazione'
,p_list_item_link_target=>'f?p=&APP_ID.:57:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'57'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(138045412824643282.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Tema'
,p_list_item_link_target=>'f?p=&APP_ID.:58:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'58'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(138045720718643283.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Nome'
,p_list_item_link_target=>'f?p=&APP_ID.:48:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'48'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(138046016071643283.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Conferma'
,p_list_item_link_target=>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'51'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_activity_page_views
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(159973015345793688.4054)
,p_name=>'monitor.activity.page.views'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1218051315822598819.4054)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Dashboard'
,p_list_item_link_target=>'f?p=&APP_ID.:40:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47119805406156631.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Per visualizzazione'
,p_list_item_link_target=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(159976029543797841.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Per applicazione e utente'
,p_list_item_link_target=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14732210619030758.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Per utente'
,p_list_item_link_target=>'f?p=&APP_ID.:36:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1813874215800004904.4054)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Visualizzazioni di pagina per utente per giorno'
,p_list_item_link_target=>'f?p=&APP_ID.:94:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(159984106949810197.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Per applicazione'
,p_list_item_link_target=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(159989500154817684.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Per area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(47158410057668832.4054)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Per giorno'
,p_list_item_link_target=>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(253974113497584304.4054)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Per accesso REST'
,p_list_item_link_target=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:RP:IR_APPLICATION_INFO:REST access:'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_messages
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(168505619846788416.4054)
,p_name=>'Manage Messages'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168505927811790760.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Definisci messaggio di login'
,p_list_item_link_target=>'f?p=&APP_ID.:41:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168506130928791641.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Definisci messaggio di sistema'
,p_list_item_link_target=>'f?p=&APP_ID.:132:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168524005844973626.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Gestisci task specifici del sito'
,p_list_item_link_target=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_service_requests
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(168703120343616153.4054)
,p_name=>'manage service requests'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168703604544621069.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Richieste aperte'
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168704030863628594.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Tutte le richieste di aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'26'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168704311255632456.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Tutte le richieste di modifica'
,p_list_item_link_target=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'28'
);
end;
/
prompt --application/shared_components/navigation/lists/home_page_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(168902912946497370.4054)
,p_name=>'home page list'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168917021744935171.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Gestisci richieste'
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-manage-requests'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168904404204513786.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Gestisci istanza'
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-manage-instance'
,p_list_item_icon_attributes=>'alt="" height="128" width="128"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168918009062940911.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Gestisci aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-manage-workspaces'
,p_list_item_icon_attributes=>'alt="" height="128" width="128"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(168918216334942988.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Controlla attivit\00E0')
,p_list_item_link_target=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-monitor-activity'
,p_list_item_icon_attributes=>'alt="" height="128" width="128"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/archived_activity_report
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(201292222959269624.4054)
,p_name=>'archived activity report'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(201292732309272286.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Attivit\00E0 per giorno')
,p_list_item_link_target=>'f?p=&APP_ID.:68:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(201293002658273224.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Attivit\00E0 per applicazione per giorno')
,p_list_item_link_target=>'f?p=&APP_ID.:77:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(219090408531367773.4054)
,p_list_item_display_sequence=>22
,p_list_item_link_text=>'Hash applicazione per giorno'
,p_list_item_link_target=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880162413033281115.4054)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('Attivit\00E0 per applicazione')
,p_list_item_link_target=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(201293307160274558.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Attivit\00E0 per area di lavoro per giorno')
,p_list_item_link_target=>'f?p=&APP_ID.:80:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(879916141112685248.4054)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('Attivit\00E0 per area di lavoro')
,p_list_item_link_target=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491858502361188089.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Grafico degli eventi di pagina per giorno'
,p_list_item_link_target=>'f?p=&APP_ID.:86:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(629291230431615041.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Grafico delle aree di lavoro attive per giorno'
,p_list_item_link_target=>'f?p=&APP_ID.:93:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/self_service_sign_up
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(203028225668057376.4054)
,p_name=>'Self Service Sign Up'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203028409925057378.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Gestisci Iscrizione guidata nuovo servizio'
,p_list_item_link_target=>'f?p=&APP_ID.:111:&SESSION.::&DEBUG.::P111_ID:1:'
,p_list_item_icon=>'menu/pt_process_20.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_icon_alt_attribute=>'target="_blank"'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203028703930057378.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Esegui Iscrizione guidata nuovo servizio'
,p_list_item_link_target=>'f?p=4700:1:0'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_icon_alt_attribute=>'target="_blank'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/create_multiple_workspaces
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(203141106443364145.4054)
,p_name=>'create multiple workspaces'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203141300332364146.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:115:&SESSION.:'
,p_list_item_current_for_pages=>'115'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203141609069364146.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Revisione e adeguamento'
,p_list_item_link_target=>'f?p=&APP_ID.:116:&SESSION.:'
,p_list_item_current_for_pages=>'116'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(203141924809364146.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Conferma'
,p_list_item_link_target=>'f?p=&APP_ID.:117:&SESSION.:'
,p_list_item_current_for_pages=>'117'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(388185523452601754.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Fornitura completata'
,p_list_item_link_target=>'f?p=&APP_ID.:135:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/create_workspace_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(204654810731392335.4054)
,p_name=>'create workspace tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(204655032658392336.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('Crea pi\00F9 aree di lavoro')
,p_list_item_link_target=>'f?p=&APP_ID.:115:&SESSION.::&DEBUG.:115,116,117:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/developer_activity_for_monitor_page
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(206097723808588940.4054)
,p_name=>'Developer.Activity for Monitor Page'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(206104006324621767.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Modifiche all''applicazione per sviluppatore'
,p_list_item_link_target=>'f?p=&APP_ID.:43:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(206104915674624470.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Modifiche all''applicazione per area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(155239711934611887.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Grafico utilizzo componenti nativi'
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.:RP,102:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(155378603841184844.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Report utilizzo componenti nativi'
,p_list_item_link_target=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:RP,140:::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="" width="20" height="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(284069028112259316.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Job di caricamento dati'
,p_list_item_link_target=>'f?p=&APP_ID.:144:&SESSION.::&DEBUG.:RP,144:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/manage_applications
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(244253103570784647.4054)
,p_name=>'Manage Applications'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(244660222438102395.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Attributi applicazione'
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(244631813556033582.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Schemi di analisi'
,p_list_item_link_target=>'f?p=&APP_ID.:401:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(244256510842786771.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Stato di creazione'
,p_list_item_link_target=>'f?p=&APP_ID.:400:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_tasks_002
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(254179102637013097.4054)
,p_name=>'workspace tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(254179620116013099.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Aggiungi schema'
,p_list_item_link_target=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:105,106,107:P107_SGID,P107_COMPANY:&P78_PROVISIONING_COMPANY_ID.,&P78_SN.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(254179909753013099.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Aggiungi utente APEX'
,p_list_item_link_target=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:23:F4050_P23_SECURITY_GROUP_ID:&P78_PROVISIONING_COMPANY_ID.:'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(254180228149013099.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Visualizza report dettagliato'
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:14:SGID:&P78_PROVISIONING_COMPANY_ID.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(44856918100412133.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Esporta area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:461:&SESSION.:EXPORT:&DEBUG.::P461_WORKSPACE:&P78_SN.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(254179324916013098.4054)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Rimuovi area di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:81:&SESSION.::&DEBUG.:81,82,83:P81_COMPANY:&P78_SN.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_purge_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(505826028978247783.4054)
,p_name=>'Workspace Purge Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(505851803884704060.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Dashboard'
,p_list_item_link_target=>'f?p=&APP_ID.:99:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'99'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(505826223784247787.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Aree di lavoro inattive'
,p_list_item_link_target=>'f?p=&APP_ID.:87:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(505826523106247841.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Aree di lavoro rimosse'
,p_list_item_link_target=>'f?p=&APP_ID.:91:&SESSION.::&DEBUG.::::'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(505826717378247841.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Aree di lavoro che sono diventate attive'
,p_list_item_link_target=>'f?p=&APP_ID.:92:&SESSION.::&DEBUG.::::'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(505827020036247842.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Log rimozione aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:98:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/pkg_app_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(517854829423895305.4054)
,p_name=>'pkg_app_tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(517855052505895308.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Gestisci categorie'
,p_list_item_link_target=>'f?p=&APP_ID.:125:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_activity_logs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(619447801744923075.4054)
,p_name=>'monitor.activity.logs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(619449225128923086.4054)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Log della posta'
,p_list_item_link_target=>'f?p=&APP_ID.:121:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(619989320793200782.4054)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('Log di attivit\00E0 Web Service')
,p_list_item_link_target=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(619449815929923087.4054)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Job'
,p_list_item_link_target=>'f?p=&APP_ID.:122:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(162310507366326382.4054)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Log eliminazione file automatica'
,p_list_item_link_target=>'f?p=&APP_ID.:124:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(279536922666729472.4054)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('Monitora installazioni di applicazioni di produttivit\00E0 e di esempio')
,p_list_item_link_target=>'f?p=&APP_ID.:128:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'alt="#LABEL#" height="20" width="20"'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/security_second_level_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(799821322334262935.4054)
,p_name=>'Security Second Level Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(799821514224262975.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Impostazioni sicurezza'
,p_list_item_link_target=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.::::'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(799821821208262984.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'URL autorizzati'
,p_list_item_link_target=>'f?p=&APP_ID.:95:&SESSION.::&DEBUG.::::'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/activity_summary
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(880586104026852286.4054)
,p_name=>'Activity Summary'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880586395598852287.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Prime applicazioni'
,p_list_item_link_target=>'f?p=&APP_ID.:71:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-top-apps'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880586795096852288.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Prime aree di lavoro'
,p_list_item_link_target=>'f?p=&APP_ID.:137:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-top-workspaces'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880587111792852289.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Riepilogo attivit\00E0')
,p_list_item_link_target=>'f?p=&APP_ID.:138:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-activity-summary'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880587536768852289.4054)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('Installazioni di applicazioni di produttivit\00E0 e di esempio')
,p_list_item_link_target=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-pkg-apps'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2105958267784095383.4054)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2105958451628095386.4054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Documentazione'
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2105958820660095393.4054)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Forum di discussione'
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2185440443171474333.4054)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Oracle Technology Network'
,p_list_item_link_target=>'http://otn.oracle.com/apex'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(845861672338730.4054)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1710403837403748.4054)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14858702119941037.4054)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91988217245572387.4054)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072144481712054.4054)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831779972543994153.4054)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917680565173940128.4054)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(3699181830199.4054)
,p_name=>'APEX authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication = ''APEX'';'
,p_error_message=>'Autenticazione APEX non abilitata'
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/user_is_internal
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(1018002984071621.4054)
,p_name=>'user_is_internal'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_security.user_is_internal;'
,p_error_message=>unistr('impossibile determinare se l''utente \00E8 un utente interno.')
,p_reference_id=>786938711256163276.4054
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(9398622791321084.4054)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>unistr('Builder SSO non \00E8 abilitato')
,p_reference_id=>6738410669854771.4054
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12523219193527909.4054)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>'Non si dispone dell''autorizzazione per amministrare le applicazioni'
,p_reference_id=>12511219858301010.4054
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/is_real_application_security_supported
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(125787708037171062.4054)
,p_name=>'Is Real Application Security supported'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return not wwv_flow_db_version.c_ver_le_12_1_0_1;'
,p_error_message=>unistr('Real Application Security \00E8 supportato solo a partire dalla versione 12.1.0.2')
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/is_dev
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(141670018067969246.4054)
,p_name=>'is_dev'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return not wwv_flow_isc.deployment_environment;'
,p_error_message=>unistr('non \00E8 un''istanza di sviluppo')
,p_reference_id=>786949644903267343.4054
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(517385971569230930.4054)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>unistr('Non si \00E8 autorizzati ad accedere ai dashboard e a Controlla attivit\00E0.')
,p_reference_id=>786936829326142579.4054
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_rest_instance_administration_available
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(579807421489291896.4054)
,p_name=>'APEX Rest Instance Administration available'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  return wwv_flow_instance_rest_admin.rest_services_available;',
'end;'))
,p_error_message=>'I servizi REST di amministrazione dell''istanza APEX non sono disponibili.'
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(1137280212017725373.4054)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>'Nessun privilegio per l''operazione tentata'
,p_reference_id=>786519856057734816.4054
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(652214800522885.4054)
,p_icon_sequence=>10
,p_icon_image=>'htmldb/icons/navbarhelp_25x25.gif'
,p_icon_subtext=>'Guida'
,p_icon_target=>'&SYSTEM_HELP_URL.'
,p_icon_image_alt=>'Guida'
,p_icon_height=>25
,p_icon_width=>25
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond_type=>'NEVER'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
,p_icon_bar_comment=>'Display same page with print view page template'
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(1365423778229905.4054)
,p_icon_sequence=>20
,p_icon_subtext=>'Benvenuto/a &APP_USER.'
,p_icon_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_icon_image_alt=>'Benvenuto/a &APP_USER.'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(333595616893904221.4054)
,p_icon_sequence=>30
,p_icon_image=>'htmldb/icons/navbarlogout_25x25.gif'
,p_icon_subtext=>'( <span style="text-decoration:underline;">Cambia area di lavoro</span> )'
,p_icon_target=>'f?p=4550:20'
,p_icon_image_alt=>'alt=""'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
,p_security_scheme=>wwv_flow_api.id(9398622791321084)
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(24559226221.4054)
,p_icon_sequence=>40
,p_icon_image=>'htmldb/icons/navbarlogout_25x25.gif'
,p_icon_image2=>'wwv_logout24.gif'
,p_icon_subtext=>'( <span style="text-decoration:underline;">Logout</span> )'
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>'Logout'
,p_icon_height=>25
,p_icon_width=>25
,p_icon_height2=>24
,p_icon_width2=>24
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond_type=>'CURRENT_LOOK_IS_1'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
,p_icon_bar_comment=>'Navigate to Flow Attribute LOGOUT_URL when pressed.'
);
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(477083880310257178.4054)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT, SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(24661497730.4054)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
,p_item_comment=>'company logged into flow'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(341498316040067852.4054)
,p_name=>'F4050_PASSWORD_REGION_TITLE'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(69693210447779230.4054)
,p_name=>'FSP_AFTER_LOGIN_URL'
,p_item_comment=>'Used by Custom2 authentication for deep linking support'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(144247012389386369.4054)
,p_name=>'IS_DEV'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(48673315869342015.4054)
,p_name=>'LAST_VIEW'
,p_data_type=>'NUMBER'
,p_item_comment=>'used for help'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(24663499759.4054)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name;'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>'Impossibile ottenere il nome dello spazio di lavoro.'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(341513728853071507.4054)
,p_computation_sequence=>10
,p_computation_item=>'F4050_PASSWORD_REGION_TITLE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_lang.system_message(''APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.''||replace(wwv_flow_authentication_dev.get_internal_authentication,''DB'',''LDAP'')||''-AUTH'')'
,p_compute_when=>'F4050_PASSWORD_REGION_TITLE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(144247705463419984.4054)
,p_computation_sequence=>10
,p_computation_item=>'IS_DEV'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if apex_util.public_check_authorization(''is_dev'') then ',
'  return ''Y'';',
'else',
'  return ''N'';',
'end if;'))
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/accessibility_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1141279207071321310.4054)
,p_lov_name=>'ACCESSIBILITY_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(1141279207071321310.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1141279512218321311.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Lettore di schermo'
,p_lov_return_value=>'SCREEN_READER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/account_lock_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12506800188785204.4054)
,p_lov_name=>'ACCOUNT_LOCK_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(12506800188785204.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12507123798785207.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bloccato'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12507312044785207.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Sbloccato'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/activity_log_request_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1582102292640264559.4054)
,p_lov_name=>'ACTIVITY_LOG.REQUEST_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(1582102292640264559.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1582102573870264598.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Altro'
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1582102817593264600.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Elaborazione'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1582103136401264600.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Rendering'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1582103436851264600.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'AJAX'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1582103735724264600.4054)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Logout'
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1582104088572264603.4054)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>'Callback di autenticazione'
,p_lov_return_value=>'5'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_instadmin_rest_roles
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(579803249013238802.4054)
,p_lov_name=>'APEX_INSTADMIN_REST_ROLES'
,p_lov_query=>'.'||wwv_flow_api.id(579803249013238802.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(579803542750238809.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Visualizza statistiche d''uso'
,p_lov_return_value=>'ApexStatsInfoRole'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(139570103313563167.4054)
,p_lov_name=>'APP STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(139570103313563167.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139570418445563171.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Disponibile'
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139570712580563173.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Di futura implementazione'
,p_lov_return_value=>'COMING_SOON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139571006146563174.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Nascosto'
,p_lov_return_value=>'HIDDEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_activity_logging
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(15203330831314824.4054)
,p_lov_name=>'APPLICATION ACTIVITY LOGGING'
,p_lov_query=>'.'||wwv_flow_api.id(15203330831314824.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15204014153314828.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Usa impostazioni applicazioni (predefinito)'
,p_lov_return_value=>'U'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15203630055314827.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Sempre'
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15203809369314828.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Mai'
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1820304753496015763.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('Disabilitata inizialmente per nuove applicazioni e applicazioni di produttivit\00E0')
,p_lov_return_value=>'O'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_logo_image_or_text
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(361753932557528086.4054)
,p_lov_name=>'APPLICATION LOGO IMAGE OR TEXT'
,p_reference_id=>210991102136588089.4054
,p_lov_query=>'.'||wwv_flow_api.id(361753932557528086.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(361754906572528090.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Immagine'
,p_lov_return_value=>'IMAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(361755120114528090.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Testo'
,p_lov_return_value=>'TEXT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_themes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(138044801783643280.4054)
,p_lov_name=>'APPLICATION THEMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select theme_id||''. '' ||wwv_flow_escape.html(theme_name) d, theme_id',
'from   wwv_flow_themes',
'where  flow_id = :fb_flow_id',
'order by theme_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(367884303048549801.4054)
,p_lov_name=>'APPLICATION TYPE'
,p_reference_id=>183877501727908015.4054
,p_lov_query=>'.'||wwv_flow_api.id(367884303048549801.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(367885627944549803.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Mostra tutto'
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(367885804716549803.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Websheet'
,p_lov_return_value=>'WEBSHEET'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(367886019467549803.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Database'
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_type_database_or_websheet
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(844667400578458000.4054)
,p_lov_name=>'APPLICATION_TYPE_DATABASE_OR_WEBSHEET'
,p_reference_id=>461305204810840905.4054
,p_lov_query=>'.'||wwv_flow_api.id(844667400578458000.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(844668432691458020.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Database'
,p_lov_return_value=>'Database'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(844668627244458020.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Websheet'
,p_lov_return_value=>'Websheet'
);
end;
/
prompt --application/shared_components/user_interface/lovs/audit_naming
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(192906504723933391.4054)
,p_lov_name=>'AUDIT_NAMING'
,p_lov_query=>'.'||wwv_flow_api.id(192906504723933391.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192906720941933395.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Attributi applicazione'
,p_lov_return_value=>'WWV_FLOWS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192906908350933397.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Modello di pagina'
,p_lov_return_value=>'WWV_FLOW_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192907100225933398.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Barra di navigazione'
,p_lov_return_value=>'WWV_FLOW_ICON_BAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192907329971933398.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Processo applicazione'
,p_lov_return_value=>'WWV_FLOW_PROCESSING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192907525100933398.4054)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Elemento applicazione'
,p_lov_return_value=>'WWV_FLOW_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192907723181933398.4054)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Calcolo applicazione'
,p_lov_return_value=>'WWV_FLOW_COMPUTATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192907918785933401.4054)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Schede'
,p_lov_return_value=>'WWV_FLOW_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192908101742933401.4054)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Scheda padre'
,p_lov_return_value=>'WWV_FLOW_TOPLEVEL_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192908312729933401.4054)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Lista di valori'
,p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES$'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192908508490933401.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Valori LOV statica'
,p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES_DATA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192908720172933401.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Voce di indicatore di percorso'
,p_lov_return_value=>'WWV_FLOW_MENU_OPTIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192917410258942992.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Temi'
,p_lov_return_value=>'WWV_FLOW_THEMES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192908929274933402.4054)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Attributi pagina'
,p_lov_return_value=>'WWV_FLOW_STEPS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192909112437933402.4054)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Pulsante di pagina'
,p_lov_return_value=>'WWV_FLOW_STEP_BUTTONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192909326218933402.4054)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Diramazione di pagina'
,p_lov_return_value=>'WWV_FLOW_STEP_BRANCHES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192909515542933402.4054)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Argomenti diramazione di pagina'
,p_lov_return_value=>'WWV_FLOW_STEP_BRANCH_ARGS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192909710968933403.4054)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Elemento pagina'
,p_lov_return_value=>'WWV_FLOW_STEP_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192909909431933403.4054)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Calcolo di pagina'
,p_lov_return_value=>'WWV_FLOW_STEP_COMPUTATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192910102627933403.4054)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Convalida pagina'
,p_lov_return_value=>'WWV_FLOW_STEP_VALIDATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192910304404933403.4054)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Processo di pagina'
,p_lov_return_value=>'WWV_FLOW_STEP_PROCESSING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192910501092933404.4054)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'Modello di area'
,p_lov_return_value=>'WWV_FLOW_PAGE_PLUG_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192910701238933404.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Modello di riga'
,p_lov_return_value=>'WWV_FLOW_ROW_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192910921309933404.4054)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'Modello di lista'
,p_lov_return_value=>'WWV_FLOW_LIST_TEMPLATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192911107468933404.4054)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>'Attributi area'
,p_lov_return_value=>'WWV_FLOW_PAGE_PLUGS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192911327453933408.4054)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>'Messaggi'
,p_lov_return_value=>'WWV_FLOW_MESSAGES$'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192911518683933408.4054)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>'Opzioni di creazione'
,p_lov_return_value=>'WWV_FLOW_PATCHES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192911719543933408.4054)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>'Sviluppatori di applicazioni (amministrazione)'
,p_lov_return_value=>'WWV_FLOW_DEVELOPERS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192911931458933408.4054)
,p_lov_disp_sequence=>26
,p_lov_disp_value=>'Liste'
,p_lov_return_value=>'WWV_FLOW_LISTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192912106135933409.4054)
,p_lov_disp_sequence=>27
,p_lov_disp_value=>'Elemento di lista'
,p_lov_return_value=>'WWV_FLOW_LIST_ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192912316871933409.4054)
,p_lov_disp_sequence=>28
,p_lov_disp_value=>'ID utente effettivo (amministrazione)'
,p_lov_return_value=>'WWV_FLOW_EFFECTIVE_USERID_MAP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192912501053933409.4054)
,p_lov_disp_sequence=>29
,p_lov_disp_value=>'Scorciatoie'
,p_lov_return_value=>'WWV_FLOW_SHORTCUTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192912709920933409.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Testo Guida dell''elemento di pagina'
,p_lov_return_value=>'WWV_FLOW_STEP_ITEM_HELP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192912922654933410.4054)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>'Schemi di autenticazione'
,p_lov_return_value=>'WWV_FLOW_AUTHENTICATIONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192913116096933410.4054)
,p_lov_disp_sequence=>32
,p_lov_disp_value=>'Punti di accesso'
,p_lov_return_value=>'WWV_FLOW_ENTRY_POINTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(192913326886933410.4054)
,p_lov_disp_sequence=>33
,p_lov_disp_value=>'Argomenti punti di accesso'
,p_lov_return_value=>'WWV_FLOW_ENTRY_POINT_ARGS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/auto_file_delete_file_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(164450631905355420.4054)
,p_lov_name=>'AUTO_FILE_DELETE_FILE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(164450631905355420.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164450903335355422.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esportazione applicazione'
,p_lov_return_value=>'FLOW_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164451116825355423.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esportazione area di lavoro'
,p_lov_return_value=>'COMPANY_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164451305638355423.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esportazione pagina'
,p_lov_return_value=>'PAGE_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164451531888355423.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esportazione Websheet'
,p_lov_return_value=>'WEBSHEET_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164451704038355423.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Importazione dati XML'
,p_lov_return_value=>'XML_DATA_IMPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(164451927196355423.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Importazione dati'
,p_lov_return_value=>'DATA_IMPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(172380721498781950.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Plugin'
,p_lov_return_value=>'PLUGIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(172384726000783329.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esportazione CSS'
,p_lov_return_value=>'CSS_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(172388731887784963.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esportazione immagini'
,p_lov_return_value=>'IMAGE_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(172392705352786807.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esportazione file statici'
,p_lov_return_value=>'FILE_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(172396718166790478.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Script'
,p_lov_return_value=>'SCRIPT_FILE_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(172400721975791606.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Temi'
,p_lov_return_value=>'THEME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(172404727169793117.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Valori predefiniti interfaccia utente'
,p_lov_return_value=>'UI_DEFAULTS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/bipublisher_support
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(66524307689014582.4054)
,p_lov_name=>'BIPUBLISHER_SUPPORT'
,p_lov_query=>'.'||wwv_flow_api.id(66524307689014582.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(309001880327416982.4054)
,p_lov_disp_sequence=>0
,p_lov_disp_value=>'Nessuno'
,p_lov_return_value=>'NONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8023414242765634.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Oracle REST Data Services (non pi\00F9 supportato)')
,p_lov_return_value=>'APEX_LISTENER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(66524606927014584.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Esterno (Apache FOP)'
,p_lov_return_value=>'STANDARD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(66524808931014584.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Oracle BI Publisher'
,p_lov_return_value=>'ADVANCED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(665784884034387187.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'APEX Office Print'
,p_lov_return_value=>'AOP'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/build_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(244320808989852457.4054)
,p_lov_name=>'BUILD_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(244320808989852457.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244321119544852463.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esegui applicazione'
,p_lov_return_value=>'RUN_ONLY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244321323574852464.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Esegui e costruisci applicazione'
,p_lov_return_value=>'RUN_AND_BUILD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3932329947881245316.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Eseguito e nascosto'
,p_lov_return_value=>'RUN_AND_HIDDEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_y_noprompt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(363978124517039324.4054)
,p_lov_name=>'CHECKBOX_Y_NOPROMPT'
,p_reference_id=>84715102189754797.4054
,p_lov_query=>'.'||wwv_flow_api.id(363978124517039324.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(363978829122039326.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'&nbsp;'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/clone_sessions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(924631310481901445.4054)
,p_lov_name=>'CLONE_SESSIONS'
,p_lov_query=>'.'||wwv_flow_api.id(924631310481901445.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(924631660343901447.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Disabilitato'
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(924632065917901449.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Abilitato'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/confirm_delete_denied_request
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87822015190102927.4054)
,p_lov_name=>'CONFIRM.DELETE.DENIED.REQUEST'
,p_lov_query=>'.'||wwv_flow_api.id(87822015190102927.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87822220071102927.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Eliminare questa richiesta in caso di rifiuto?'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/confirm_pwd_removal
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(35215801480283409.4054)
,p_lov_name=>'CONFIRM.PWD.REMOVAL'
,p_lov_query=>'.'||wwv_flow_api.id(35215801480283409.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(35216131980283418.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Selezionare per confermare che si desidera modificare la password del wallet'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/confirm_removal
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87818332243088870.4054)
,p_lov_name=>'CONFIRM.REMOVAL'
,p_lov_query=>'.'||wwv_flow_api.id(87818332243088870.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87818517495088870.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Selezionare per confermare che si desidera procedere con la rimozione.'
,p_lov_return_value=>'Yes'
);
end;
/
prompt --application/shared_components/user_interface/lovs/confirm_remove_request
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87819107787091340.4054)
,p_lov_name=>'CONFIRM.REMOVE.REQUEST'
,p_lov_query=>'.'||wwv_flow_api.id(87819107787091340.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87819312320091340.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Selezionare per rimuovere anche la richiesta per questa area di lavoro.'
,p_lov_return_value=>'Yes'
);
end;
/
prompt --application/shared_components/user_interface/lovs/confirm_smtp_pwd_removal
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(391596105997880413.4054)
,p_lov_name=>'CONFIRM.SMTP.PWD.REMOVAL'
,p_lov_query=>'.'||wwv_flow_api.id(391596105997880413.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(391596477310880416.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Selezionare per confermare che si desidera modificare la password per il nome utente di autenticazione SMTP'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/confirm_workspace_install
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(73876902692924600.4054)
,p_lov_name=>'CONFIRM.WORKSPACE_INSTALL'
,p_lov_query=>'.'||wwv_flow_api.id(73876902692924600.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(73877205249924603.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Selezionare per proseguire con l''installazione dell''area di lavoro che avr\00E0 accesso completo allo schema primario visualizzato e agli altri schemi indicati.')
,p_lov_return_value=>'Yes'
);
end;
/
prompt --application/shared_components/user_interface/lovs/date_format_lov
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(847446100928128573.4054)
,p_lov_name=>'DATE_FORMAT_LOV'
,p_reference_id=>460719917105668922.4054
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'  from wwv_flow_format_masks',
' where t=''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/db_tablespaces
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(161644121203686372.4054)
,p_lov_name=>'DB.TABLESPACES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select tablespace_name tname_disp, tablespace_name tname_ret',
'  from sys.dba_tablespaces'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/default_error_display_location
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(360596400783208409.4054)
,p_lov_name=>'DEFAULT_ERROR_DISPLAY_LOCATION'
,p_reference_id=>191207805708435328.4054
,p_lov_query=>'.'||wwv_flow_api.id(360596400783208409.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(360597710469208433.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'In linea con campo e nella notifica'
,p_lov_return_value=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(360597900558208433.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'In linea con campo'
,p_lov_return_value=>'INLINE_WITH_FIELD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(360598129380208433.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'In linea nella notifica'
,p_lov_return_value=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/developer_activity_action
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(110357115975241430.4054)
,p_lov_name=>'DEVELOPER ACTIVITY ACTION'
,p_lov_query=>'.'||wwv_flow_api.id(110357115975241430.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110357309735241430.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Crea'
,p_lov_return_value=>'I'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110357503716241431.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Elimina'
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110357728444241431.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Modifica'
,p_lov_return_value=>'U'
);
end;
/
prompt --application/shared_components/user_interface/lovs/developer_privs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(182796815771077530.4054)
,p_lov_name=>'DEVELOPER.PRIVS'
,p_lov_query=>'.'||wwv_flow_api.id(182796815771077530.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87840032028448399.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Amministrazione'
,p_lov_return_value=>'ADMIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87840228629448402.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Sfoglia'
,p_lov_return_value=>'BROWSE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87840406518448402.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Crea'
,p_lov_return_value=>'CREATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87840629693448402.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Data Loader'
,p_lov_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87840818626448402.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Controllo DB'
,p_lov_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87841009541448403.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Modifica'
,p_lov_return_value=>'EDIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87841204704448403.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Guida'
,p_lov_return_value=>'HELP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87841420783448403.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Controlla'
,p_lov_return_value=>'MONITOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87841623734448404.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'SQL'
,p_lov_return_value=>'SQL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87841806856448404.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'User Manager'
,p_lov_return_value=>'USER_MANAGER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enable_y_disable_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(484964000318931321.4054)
,p_lov_name=>'ENABLE Y, DISABLE N'
,p_lov_query=>'.'||wwv_flow_api.id(484964000318931321.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(484964223962931324.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Abilita'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(484964415569931326.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Disabilita'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enabled_true_false
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1351993194329853612.4054)
,p_lov_name=>'ENABLED_TRUE_FALSE'
,p_lov_query=>'.'||wwv_flow_api.id(1351993194329853612.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1351993418924853622.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'True'
,p_lov_return_value=>'TRUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1351993885783853625.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'False'
,p_lov_return_value=>'FALSE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/exact_subs_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(370686604633893239.4054)
,p_lov_name=>'EXACT_SUBS_Y_N'
,p_reference_id=>84908521896674445.4054
,p_lov_query=>'.'||wwv_flow_api.id(370686604633893239.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(370687632719893241.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'No - Esegui anche sostituzioni non esatte'
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(370687828235893241.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('S\00EC - Esegui solo sostituzioni esatte')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2046991831712786495.4054)
,p_lov_name=>'EXPORT_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(2046991831712786495.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2046992184705786498.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Completo'
,p_lov_return_value=>'FULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2046992509267786499.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Minimo'
,p_lov_return_value=>'MIN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/file_format
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(175743214959227187.4054)
,p_lov_name=>'FILE_FORMAT'
,p_lov_query=>'.'||wwv_flow_api.id(175743214959227187.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175743601146227192.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'UNIX'
,p_lov_return_value=>'UNIX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175743426983227191.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'DOS'
,p_lov_return_value=>'DOS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_no_since
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(348972227781434779.4054)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_NO_SINCE'
,p_reference_id=>170713321121898589.4054
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_timestamps_no_since
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(348972603598434786.4054)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_TIMESTAMPS_NO_SINCE'
,p_reference_id=>170713631164901556.4054
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''T''',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_timestamps_tzr_no_since
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(348973028981434786.4054)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_TIMESTAMPS_TZR_NO_SINCE'
,p_reference_id=>170713910516904980.4054
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''T''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''Z'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/hash_function
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(366796514610241309.4054)
,p_lov_name=>'HASH_FUNCTION'
,p_lov_query=>'.'||wwv_flow_api.id(366796514610241309.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(366797127072241312.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SHA-1'
,p_lov_return_value=>'SH1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(366797426883241313.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SHA-2, 256 bit (richiede 12c)'
,p_lov_return_value=>'SH256'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(366797730058241314.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'SHA-2, 384 bit (richiede 12c)'
,p_lov_return_value=>'SH384'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(366798016860241314.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'SHA-2, 512 bit (richiede 12c)'
,p_lov_return_value=>'SH512'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(366796820622241310.4054)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'MD5 (precedente)'
,p_lov_return_value=>'MD5'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_iana_charset
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(175798011541253458.4054)
,p_lov_name=>'I18N_IANA_CHARSET'
,p_reference_id=>144796827445692396.4054
,p_lov_query=>'.'||wwv_flow_api.id(175798011541253458.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9219501049925452.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Arabic ISO-8859-6'
,p_lov_return_value=>'iso-8859-6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9219717725925452.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Arabic Windows 1256'
,p_lov_return_value=>'windows-1256'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9219915396925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Chinese Big5'
,p_lov_return_value=>'big5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9220105075925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Chinese GBK'
,p_lov_return_value=>'gbk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9220309171925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic ISO-8859-5'
,p_lov_return_value=>'iso-8859-5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9220531506925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic KOI8-R'
,p_lov_return_value=>'koi8-r'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9220716176925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic KOI8-U'
,p_lov_return_value=>'koi8-u'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9220921806925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic Windows 1251'
,p_lov_return_value=>'windows-1251'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9221127254925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Eastern European ISO-8859-2'
,p_lov_return_value=>'iso-8859-2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9221328423925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Eastern European Windows 1250'
,p_lov_return_value=>'windows-1250'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9221530241925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Greek ISO-8859-7'
,p_lov_return_value=>'iso-8859-7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9221716263925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Greek Windows 1253'
,p_lov_return_value=>'windows-1253'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9221926948925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hebrew ISO-8859-8-i'
,p_lov_return_value=>'iso-8859-8-i'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9222100762925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hebrew Windows 1255'
,p_lov_return_value=>'windows-1255'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9222325282925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Japanese EUC'
,p_lov_return_value=>'euc-jp'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9222500466925453.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Japanese Shift JIS'
,p_lov_return_value=>'shift_jis'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9222730026925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Korean EUC'
,p_lov_return_value=>'euc-kr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9222922148925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Northern European ISO-8859-4'
,p_lov_return_value=>'iso-8859-4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9223125383925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Northern European Windows 1257'
,p_lov_return_value=>'windows-1257'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9223328804925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Southern European ISO-8859-3'
,p_lov_return_value=>'iso-8859-3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9223507735925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Thai TIS-620'
,p_lov_return_value=>'tis-620'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9223727278925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Turkish ISO-8859-9'
,p_lov_return_value=>'iso-8859-9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9223913742925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Turkish Windows 1254'
,p_lov_return_value=>'windows-1254'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9224108380925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-8'
,p_lov_return_value=>'utf-8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9224313943925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-16 Big Endian'
,p_lov_return_value=>'utf-16be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9224522296925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-16 Little Endian'
,p_lov_return_value=>'utf-16le'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9224717469925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'US-ASCII'
,p_lov_return_value=>'us-ascii'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9224917326925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vietnamese Windows 1258'
,p_lov_return_value=>'windows-1258'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9225110387925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Western European ISO-8859-1'
,p_lov_return_value=>'iso-8859-1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(9225332582925454.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Western European Windows 1252'
,p_lov_return_value=>'windows-1252'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_languages_locales
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(348975927644434787.4054)
,p_lov_name=>'I18N_LANGUAGES_LOCALES'
,p_reference_id=>107899321117195063.4054
,p_lov_query=>'.'||wwv_flow_api.id(348975927644434787.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698980652575180004.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Azero (az)'
,p_lov_return_value=>'az'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698981060553180004.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Afrikaans (af)'
,p_lov_return_value=>'af'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698981482653180005.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (ar)'
,p_lov_return_value=>'ar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698981843695180005.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Algeria) (ar-dz)'
,p_lov_return_value=>'ar-dz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698982247284180006.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Bahrein) (ar-bh)'
,p_lov_return_value=>'ar-bh'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698982685224180006.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Egitto) (ar-eg)'
,p_lov_return_value=>'ar-eg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698983034041180006.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Iraq) (ar-iq)'
,p_lov_return_value=>'ar-iq'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698983452340180006.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Giordania) (ar-jo)'
,p_lov_return_value=>'ar-jo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698983811981180006.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Kuwait) (ar-kw)'
,p_lov_return_value=>'ar-kw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698984287771180007.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Libano) (ar-lb)'
,p_lov_return_value=>'ar-lb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698984603186180007.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Libia) (ar-ly)'
,p_lov_return_value=>'ar-ly'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698985056221180007.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Marocco) (ar-ma)'
,p_lov_return_value=>'ar-ma'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698985436333180007.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Oman) (ar-om)'
,p_lov_return_value=>'ar-om'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698985890903180007.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Qatar) (ar-qa)'
,p_lov_return_value=>'ar-qa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698986218587180008.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Arabia Saudita) (ar-sa)'
,p_lov_return_value=>'ar-sa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698986694655180008.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Siria) (ar-sy)'
,p_lov_return_value=>'ar-sy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698987026669180008.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Tunisia) (ar-tn)'
,p_lov_return_value=>'ar-tn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698987468386180008.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (U.A.E.) (ar-ae)'
,p_lov_return_value=>'ar-ae'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698987847136180008.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabo (Yemen) (ar-ye)'
,p_lov_return_value=>'ar-ye'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698988259079180009.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Assamese (as)'
,p_lov_return_value=>'as'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698988680993180009.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Basco (eu)'
,p_lov_return_value=>'eu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698989064064180009.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bielorusso (be)'
,p_lov_return_value=>'be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698989442466180009.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bengali (bn)'
,p_lov_return_value=>'bn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698989876708180010.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bulgaro (bg)'
,p_lov_return_value=>'bg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698990212491180010.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Catalano (ca)'
,p_lov_return_value=>'ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698990679988180010.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (zh)'
,p_lov_return_value=>'zh'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698991043563180010.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (Cina) (zh-cn)'
,p_lov_return_value=>'zh-cn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698991467484180010.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (Hong Kong) (zh-hk)'
,p_lov_return_value=>'zh-hk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698991894788180011.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (Macau SAR) (zh-mo)'
,p_lov_return_value=>'zh-mo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698992229032180011.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (Singapore) (zh-sg)'
,p_lov_return_value=>'zh-sg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698992633206180011.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cinese (Taiwan) (zh-tw)'
,p_lov_return_value=>'zh-tw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698993085891180011.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Croato (hr)'
,p_lov_return_value=>'hr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698993494764180011.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ceco (cs)'
,p_lov_return_value=>'cs'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698993804687180012.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Danese (da)'
,p_lov_return_value=>'da'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698994284075180012.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Olandese (Belgio) (nl-be)'
,p_lov_return_value=>'nl-be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698994686095180012.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Olandese (Paesi Bassi) (nl)'
,p_lov_return_value=>'nl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698995058585180012.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (en)'
,p_lov_return_value=>'en'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698995479217180013.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Australia) (en-au)'
,p_lov_return_value=>'en-au'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698995893960180013.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Belize) (en-bz)'
,p_lov_return_value=>'en-bz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698996294187180013.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Canada) (en-ca)'
,p_lov_return_value=>'en-ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698996662648180013.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Irlanda) (en-ie)'
,p_lov_return_value=>'en-ie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698997058342180013.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Giamaica) (en-jm)'
,p_lov_return_value=>'en-jm'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698997421989180014.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Nuova Zelanda) (en-nz)'
,p_lov_return_value=>'en-nz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698997824995180014.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Filippine) (en-ph)'
,p_lov_return_value=>'en-ph'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698998226542180014.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Sudafrica) (en-za)'
,p_lov_return_value=>'en-za'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698998692810180014.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Trinidad) (en-tt)'
,p_lov_return_value=>'en-tt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698999070042180014.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Regno Unito) (en-gb)'
,p_lov_return_value=>'en-gb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698999420730180015.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Stati Uniti) (en-us)'
,p_lov_return_value=>'en-us'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698999869693180015.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inglese (Zimbabwe) (en-zw)'
,p_lov_return_value=>'en-zw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699000296040180015.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Estone (et)'
,p_lov_return_value=>'et'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699000661460180015.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'FYRO Macedone (mk)'
,p_lov_return_value=>'mk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699001056125180016.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Faeroese (fo)'
,p_lov_return_value=>'fo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699001467275180016.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Farsi (fa)'
,p_lov_return_value=>'fa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699001875056180016.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Svizzera) (fr-ch)'
,p_lov_return_value=>'fr-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699002266115180016.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Finlandese (fi)'
,p_lov_return_value=>'fi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699002624823180016.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Belgio) (fr-be)'
,p_lov_return_value=>'fr-be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699003029269180017.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Canada) (fr-ca)'
,p_lov_return_value=>'fr-ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699003480368180017.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Francia) (fr)'
,p_lov_return_value=>'fr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699003872158180017.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Lussemburgo) (fr-lu)'
,p_lov_return_value=>'fr-lu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699004228545180017.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francese (Monaco) (fr-mc)'
,p_lov_return_value=>'fr-mc'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699004698644180018.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Gaelico (gd)'
,p_lov_return_value=>'gd'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699005086270180018.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Galiziano (gl)'
,p_lov_return_value=>'gl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699005496944180018.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tedesco (Austria) (de-at)'
,p_lov_return_value=>'de-at'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699005888260180018.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tedesco (Germania) (de)'
,p_lov_return_value=>'de'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699006292651180018.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tedesco (Liechtenstein) (de-li)'
,p_lov_return_value=>'de-li'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699006603950180019.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tedesco (Lussemburgo) (de-lu)'
,p_lov_return_value=>'de-lu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699007072050180019.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tedesco (Svizzera) (de-ch)'
,p_lov_return_value=>'de-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699007483019180019.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Greco (el)'
,p_lov_return_value=>'el'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699007855371180019.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Gujarati (gu)'
,p_lov_return_value=>'gu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699008201241180021.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ebraico (he)'
,p_lov_return_value=>'he'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699008699410180022.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hindi (hi)'
,p_lov_return_value=>'hi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699009015461180022.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ungherese (hu)'
,p_lov_return_value=>'hu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699009475248180022.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Islandese (is)'
,p_lov_return_value=>'is'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699009868782180022.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Indonesiano (id)'
,p_lov_return_value=>'id'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699010221224180023.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Italiano (Italia) (it)'
,p_lov_return_value=>'it'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699010624781180023.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Italiano (Svizzera) (it-ch)'
,p_lov_return_value=>'it-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699011015052180023.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Giapponese (ja)'
,p_lov_return_value=>'ja'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699011418400180023.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Kannada (kn)'
,p_lov_return_value=>'kn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699011831586180024.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cazaco (kk)'
,p_lov_return_value=>'kk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699012278011180024.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Konkani (kok)'
,p_lov_return_value=>'kok'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699012610528180024.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Coreano (ko)'
,p_lov_return_value=>'ko'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699013093170180024.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chirghiso (kz)'
,p_lov_return_value=>'kz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699013418073180025.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lettone (lv)'
,p_lov_return_value=>'lv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699013826231180025.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lituano (lt)'
,p_lov_return_value=>'lt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699014259216180025.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Malese (Malaysia) (ms)'
,p_lov_return_value=>'ms'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699014637221180025.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Malayalam (ml)'
,p_lov_return_value=>'ml'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699015047378180026.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Maltese (mt)'
,p_lov_return_value=>'mt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699015417849180026.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Marathi (mr)'
,p_lov_return_value=>'mr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699015837389180026.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Nepalese (India) (ne)'
,p_lov_return_value=>'ne'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699016219550180026.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norvegese (Bokmal) (nb-no)'
,p_lov_return_value=>'nb-no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699016650282180026.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norvegese (Bokmal) (no)'
,p_lov_return_value=>'no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699017069718180027.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norvegese (Nynorsk) (nn-no)'
,p_lov_return_value=>'nn-no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699017459853180027.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Oriya (or)'
,p_lov_return_value=>'or'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699017804003180027.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Polacco (pl)'
,p_lov_return_value=>'pl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699018200480180027.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portoghese (Brasile) (pt-br)'
,p_lov_return_value=>'pt-br'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699018615797180028.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portoghese (Portogallo) (pt)'
,p_lov_return_value=>'pt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699019033109180028.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Punjabi (pa)'
,p_lov_return_value=>'pa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699019406601180028.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Romeno (ro)'
,p_lov_return_value=>'ro'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699019809056180028.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Russo (ru)'
,p_lov_return_value=>'ru'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699020294400180029.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Russo (Moldavia) (ru-md)'
,p_lov_return_value=>'ru-md'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699020615658180029.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Serbo (sr)'
,p_lov_return_value=>'sr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699021086498180029.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Slovacco (sk)'
,p_lov_return_value=>'sk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699021470020180029.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Sloveno (sl)'
,p_lov_return_value=>'sl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699021856577180029.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Argentina) (es-ar)'
,p_lov_return_value=>'es-ar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699022283486180030.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Bolivia) (es-bo)'
,p_lov_return_value=>'es-bo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699022650688180030.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Cile) (es-cl)'
,p_lov_return_value=>'es-cl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699023011653180030.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Colombia) (es-co)'
,p_lov_return_value=>'es-co'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699023499252180030.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Costa Rica) (es-cr)'
,p_lov_return_value=>'es-cr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699023824139180031.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Repubblica Dominicana) (es-do)'
,p_lov_return_value=>'es-do'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699024228978180031.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Ecuador) (es-ec)'
,p_lov_return_value=>'es-ec'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699024668580180031.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (El Salvador) (es-sv)'
,p_lov_return_value=>'es-sv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699025057003180032.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Guatemala) (es-gt)'
,p_lov_return_value=>'es-gt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699025484196180032.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Honduras) (es-hn)'
,p_lov_return_value=>'es-hn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699025858584180032.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Messico) (es-mx)'
,p_lov_return_value=>'es-mx'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699026243063180032.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Nicaragua) (es-ni)'
,p_lov_return_value=>'es-ni'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699026617351180033.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Panama) (es-pa)'
,p_lov_return_value=>'es-pa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699027088085180033.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Paraguay) (es-py)'
,p_lov_return_value=>'es-py'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699027417193180033.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Spagnolo (Per\00F9) (es-pe)')
,p_lov_return_value=>'es-pe'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699027879740180033.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Portorico) (es-pr)'
,p_lov_return_value=>'es-pr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699028291585180034.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (tradizionale) (es)'
,p_lov_return_value=>'es'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699028663606180034.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Stati Uniti) (es-us)'
,p_lov_return_value=>'es-us'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699029093982180034.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Uruguay) (es-uy)'
,p_lov_return_value=>'es-uy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699029477957180034.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagnolo (Venezuela) (es-ve)'
,p_lov_return_value=>'es-ve'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699029836983180034.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Svedese (sv)'
,p_lov_return_value=>'sv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699030291106180035.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Svedese (Finlandia) (sv-fi)'
,p_lov_return_value=>'sv-fi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699030638833180035.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tamil (ta)'
,p_lov_return_value=>'ta'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699031057927180035.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Telugu (te)'
,p_lov_return_value=>'te'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699031480481180035.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Thailandese (th)'
,p_lov_return_value=>'th'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699031847405180036.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Turco (tr)'
,p_lov_return_value=>'tr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699032254185180036.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ucraino (uk)'
,p_lov_return_value=>'uk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699032603795180036.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Urdu (ur)'
,p_lov_return_value=>'ur'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699033025378180036.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Uzbeco (uz)'
,p_lov_return_value=>'uz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699033427101180037.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Vietnamita (vi)'
,p_lov_return_value=>'vi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699033825013180037.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Irlandese (ga)'
,p_lov_return_value=>'ga'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699034250948180037.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Gallese (cy)'
,p_lov_return_value=>'cy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699034611796180037.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Swahili (sw)'
,p_lov_return_value=>'sw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699035089043180037.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Albanese'
,p_lov_return_value=>'sq'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699035490973180038.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Armeno'
,p_lov_return_value=>'hy'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_territories
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(788953931940024140.4054)
,p_lov_name=>'I18N_TERRITORIES'
,p_reference_id=>634612723768159258.4054
,p_lov_query=>'.'||wwv_flow_api.id(788953931940024140.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62829689894442518.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Azerbaigian'
,p_lov_return_value=>'AZERBAIJAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788980130880024177.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Algeria'
,p_lov_return_value=>'ALGERIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788980318501024177.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'America'
,p_lov_return_value=>'AMERICA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788980524096024178.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Argentina'
,p_lov_return_value=>'ARGENTINA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788980702992024178.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Australia'
,p_lov_return_value=>'AUSTRALIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788980909354024178.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Austria'
,p_lov_return_value=>'AUSTRIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788981104201024178.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bahrein'
,p_lov_return_value=>'BAHRAIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788981314054024178.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bangladesh'
,p_lov_return_value=>'BANGLADESH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788981506304024178.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Belgio'
,p_lov_return_value=>'BELGIUM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788981731301024178.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Brasile'
,p_lov_return_value=>'BRAZIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788981915417024179.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bulgaria'
,p_lov_return_value=>'BULGARIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788982112997024179.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Canada'
,p_lov_return_value=>'CANADA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788982320274024179.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Catalogna'
,p_lov_return_value=>'CATALONIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788982522979024182.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cile'
,p_lov_return_value=>'CHILE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788982702173024182.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Cina'
,p_lov_return_value=>'CHINA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788982929275024182.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Colombia'
,p_lov_return_value=>'COLOMBIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788983110411024182.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Costa Rica'
,p_lov_return_value=>'COSTA RICA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788983318760024182.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Croazia'
,p_lov_return_value=>'CROATIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788983519697024182.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Repubblica Ceca'
,p_lov_return_value=>'CZECH REPUBLIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788983711192024182.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Danimarca'
,p_lov_return_value=>'DENMARK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788983924185024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ecuador'
,p_lov_return_value=>'ECUADOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788984103258024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Egitto'
,p_lov_return_value=>'EGYPT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788984330459024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'El Salvador'
,p_lov_return_value=>'EL SALVADOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788984523371024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Estonia'
,p_lov_return_value=>'ESTONIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788984729453024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Finlandia'
,p_lov_return_value=>'FINLAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788984900811024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Francia'
,p_lov_return_value=>'FRANCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788985104013024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Macedonia'
,p_lov_return_value=>'FYR MACEDONIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788985318698024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Germania'
,p_lov_return_value=>'GERMANY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788985511253024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Grecia'
,p_lov_return_value=>'GREECE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788985730373024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Guatemala'
,p_lov_return_value=>'GUATEMALA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788985926875024183.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hong Kong'
,p_lov_return_value=>'HONG KONG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788986111750024187.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ungheria'
,p_lov_return_value=>'HUNGARY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788986314654024187.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Islanda'
,p_lov_return_value=>'ICELAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788986518997024187.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'India'
,p_lov_return_value=>'INDIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788986720030024188.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Indonesia'
,p_lov_return_value=>'INDONESIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788986901390024188.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Iraq'
,p_lov_return_value=>'IRAQ'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788987101545024188.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Irlanda'
,p_lov_return_value=>'IRELAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788987312858024188.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Israele'
,p_lov_return_value=>'ISRAEL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788987521480024188.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Italia'
,p_lov_return_value=>'ITALY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788987722466024188.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Giappone'
,p_lov_return_value=>'JAPAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788987928268024188.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Giordania'
,p_lov_return_value=>'JORDAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788988125327024189.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Kazakistan'
,p_lov_return_value=>'KAZAKHSTAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788988308841024189.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Corea'
,p_lov_return_value=>'KOREA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788988501979024189.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Kuwait'
,p_lov_return_value=>'KUWAIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788988722156024189.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lettonia'
,p_lov_return_value=>'LATVIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788988924887024189.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Libano'
,p_lov_return_value=>'LEBANON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788989122787024189.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Libia'
,p_lov_return_value=>'LIBYA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788989329016024189.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lituania'
,p_lov_return_value=>'LITHUANIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788989524312024189.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lussemburgo'
,p_lov_return_value=>'LUXEMBOURG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788989725001024189.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Malaysia'
,p_lov_return_value=>'MALAYSIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788989925098024190.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Messico'
,p_lov_return_value=>'MEXICO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788990125708024190.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Marocco'
,p_lov_return_value=>'MOROCCO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788990312872024190.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Nuova Zelanda'
,p_lov_return_value=>'NEW ZEALAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788990525052024190.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Nicaragua'
,p_lov_return_value=>'NICARAGUA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788990722751024190.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norvegia'
,p_lov_return_value=>'NORWAY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788990918310024190.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Oman'
,p_lov_return_value=>'OMAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788991110230024191.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Panama'
,p_lov_return_value=>'PANAMA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788991326612024191.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('Per\00F9')
,p_lov_return_value=>'PERU'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788991522861024191.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Filippine'
,p_lov_return_value=>'PHILIPPINES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788991728449024191.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Polonia'
,p_lov_return_value=>'POLAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788991914460024191.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portogallo'
,p_lov_return_value=>'PORTUGAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788992105229024191.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portorico'
,p_lov_return_value=>'PUERTO RICO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788992322244024195.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Qatar'
,p_lov_return_value=>'QATAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788992529965024195.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Romania'
,p_lov_return_value=>'ROMANIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788992732431024195.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Russia'
,p_lov_return_value=>'RUSSIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788992929223024196.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabia Saudita'
,p_lov_return_value=>'SAUDI ARABIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788993122388024196.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Serbia e Montenegro'
,p_lov_return_value=>'SERBIA AND MONTENEGRO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788993307197024196.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Singapore'
,p_lov_return_value=>'SINGAPORE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788993516987024196.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Slovacchia'
,p_lov_return_value=>'SLOVAKIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788993712467024196.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Slovenia'
,p_lov_return_value=>'SLOVENIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788993911470024196.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Sudafrica'
,p_lov_return_value=>'SOUTH AFRICA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788994103090024197.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spagna'
,p_lov_return_value=>'SPAIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788994318464024197.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Svezia'
,p_lov_return_value=>'SWEDEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788994513532024197.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Svizzera'
,p_lov_return_value=>'SWITZERLAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788994702487024197.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Siria'
,p_lov_return_value=>'SYRIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788994929127024197.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Taiwan'
,p_lov_return_value=>'TAIWAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788995125228024197.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Thailandia'
,p_lov_return_value=>'THAILAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788995311129024198.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Paesi Bassi'
,p_lov_return_value=>'THE NETHERLANDS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788995503628024198.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tunisia'
,p_lov_return_value=>'TUNISIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788995720383024198.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Turchia'
,p_lov_return_value=>'TURKEY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788995900122024198.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ucraina'
,p_lov_return_value=>'UKRAINE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788996102675024198.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Emirati Arabi Uniti'
,p_lov_return_value=>'UNITED ARAB EMIRATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788996309949024198.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Regno Unito'
,p_lov_return_value=>'UNITED KINGDOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788996502604024198.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Uzbekistan'
,p_lov_return_value=>'UZBEKISTAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788996713482024199.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Venezuela'
,p_lov_return_value=>'VENEZUELA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788996911281024199.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Vietnam'
,p_lov_return_value=>'VIETNAM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788997123524024199.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Yemen'
,p_lov_return_value=>'YEMEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_notify_interval
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(274103227902682659.4054)
,p_lov_name=>'IR_NOTIFY_INTERVAL'
,p_lov_query=>'.'||wwv_flow_api.id(274103227902682659.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(274103521636682659.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Giornaliero'
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(274103811250682659.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Settimanale'
,p_lov_return_value=>'W'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(274104111453682659.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Mensile'
,p_lov_return_value=>'M'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_notify_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(294656516286709966.4054)
,p_lov_name=>'IR_NOTIFY_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(294656516286709966.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(294656824018709967.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Sottomesso'
,p_lov_return_value=>'SUBMITTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(294657122464709967.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Inviato'
,p_lov_return_value=>'SENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(294657432339709967.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Errore'
,p_lov_return_value=>'ERROR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/languages_installed
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(502998721971236943.4054)
,p_lov_name=>'LANGUAGES_INSTALLED'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lang_name, flow_language from ',
'(select (select max( translated_lang_name) from wwv_flow_languages l where l.lang_id = f.flow_language) lang_name, flow_language',
'  from wwv_flows f',
' where id = 4411',
'   and security_group_id = 10',
' union',
' select (select max(translated_lang_name) from wwv_flow_languages l where l.lang_id = f.flow_language) lang_name, flow_language',
'   from wwv_flows f',
'  where security_group_id = 10',
'    and id in ',
'      ( select translation_flow_id',
'          from wwv_flow_language_map',
'         where security_group_id = 10',
'           and primary_language_flow_id = 4411)',
'  order by 1)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ldap_ssl_lov
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(795103713402787381.4054)
,p_lov_name=>'LDAP_SSL_LOV'
,p_reference_id=>487674627120619297.4054
,p_lov_query=>'.'||wwv_flow_api.id(795103713402787381.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(795105028361787385.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SSL'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(795105207558787386.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SSL con autenticazione'
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(795105423579787386.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Nessun SSL'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_workspaces
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(159434915946336703.4054)
,p_lov_name=>'LIST.WORKSPACES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select short_name d, short_name v',
'  from wwv_flow_companies',
' where (provisioning_company_id not in (0,10,11,12))',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_all_companies
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(41061332989455513.4054)
,p_lov_name=>'LIST_ALL_COMPANIES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||',
''' -'' d, 0 r from dual union all',
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,',
'       PROVISIONING_COMPANY_ID r',
'from   WWV_FLOW_COMPANIES',
'where  provisioning_company_id > 0',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_all_companies_escaped
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(33198215215866564.4054)
,p_lov_name=>'LIST_ALL_COMPANIES_ESCAPED'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||',
''' -'' d, 0 r from dual union all',
'select wwv_flow_escape.html(short_name)||'' (''||PROVISIONING_COMPANY_ID||'')'' d,',
'       PROVISIONING_COMPANY_ID r',
'from   WWV_FLOW_COMPANIES',
'where  provisioning_company_id > 0',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_all_companies_no_null_option
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(71982116125334375.4054)
,p_lov_name=>'LIST_ALL_COMPANIES_NO_NULL_OPTION'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,',
'       PROVISIONING_COMPANY_ID r',
'from   WWV_FLOW_COMPANIES',
'where  provisioning_company_id > 0',
'  and  provisioning_company_id != 11',
'  and  provisioning_company_id != 12',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_developer_workspaces
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(245468425022265187.4054)
,p_lov_name=>'LIST_DEVELOPER_WORKSPACES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||',
''' -'' d, 0 r from dual union all',
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,',
'       PROVISIONING_COMPANY_ID r',
'from   WWV_FLOW_COMPANIES',
'where  provisioning_company_id not in (0,10,11)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_developer_workspaces_no_null_option
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(201412507067809360.4054)
,p_lov_name=>'LIST_DEVELOPER_WORKSPACES_NO_NULL_OPTION'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,',
'       PROVISIONING_COMPANY_ID r',
'from   WWV_FLOW_COMPANIES',
'where  provisioning_company_id not in (0,10,11, 12)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_flow_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(85746300886317667.4054)
,p_lov_name=>'LIST_FLOW_STATUS'
,p_reference_id=>634347472712995.4054
,p_lov_query=>'.'||wwv_flow_api.id(85746300886317667.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741162715995290705.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Disponibile'
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741163096116290707.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Disponibile con barra degli strumenti sviluppatore'
,p_lov_return_value=>'AVAILABLE_W_EDIT_LINK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741163344386290707.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Disponibile solo per gli sviluppatori'
,p_lov_return_value=>'DEVELOPERS_ONLY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741163691224290707.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Accesso limitato'
,p_lov_return_value=>'RESTRICTED_ACCESS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741163965010290707.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Non disponibile'
,p_lov_return_value=>'UNAVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741164248206290708.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Non disponibile (stato mostrato con PL/SQL)'
,p_lov_return_value=>'UNAVAILABLE_PLSQL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(741164577629290708.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Non disponibile (reindirizzamento a URL)'
,p_lov_return_value=>'UNAVAILABLE_URL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/log_names
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(220529904687804674.4054)
,p_lov_name=>'LOG NAMES'
,p_lov_query=>'.'||wwv_flow_api.id(220529904687804674.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(220530223169804674.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Log degli accessi'
,p_lov_return_value=>'ACCESS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(220530529937804674.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Log attivit\00E0')
,p_lov_return_value=>'ACTIVITY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(220530813867804675.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Messaggi di debug'
,p_lov_return_value=>'DEBUG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(220531102895804675.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Log di conteggio clic esterni'
,p_lov_return_value=>'CLICKTHRU'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(642230510529647347.4054)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Web Service'
,p_lov_return_value=>'WEBSERVICE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/login_status_codes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(46388624571234535.4054)
,p_lov_name=>'LOGIN STATUS CODES'
,p_lov_query=>'.'||wwv_flow_api.id(46388624571234535.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46388926156234544.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Autenticazione riuscita'
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46389114667234544.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Nome utente sconosciuto'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46389305475234544.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Account bloccato'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46389507635234544.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Account scaduto'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46389702262234544.4054)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Password errata'
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46389924389234544.4054)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Primo utilizzo password'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46390117950234544.4054)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Numero massimo di tentativi di login superato'
,p_lov_return_value=>'6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(46390320270234545.4054)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Errore interno sconosciuto'
,p_lov_return_value=>'7'
);
end;
/
prompt --application/shared_components/user_interface/lovs/login_throttle_methods
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(244019724554013154.4054)
,p_lov_name=>'LOGIN THROTTLE METHODS'
,p_lov_query=>'.'||wwv_flow_api.id(244019724554013154.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244020024066013155.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Nome utente e indirizzo IP client'
,p_lov_return_value=>'USERNAME_IP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244020707400018951.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Nome utente'
,p_lov_return_value=>'USERNAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244021027221018951.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Indirizzo IP client'
,p_lov_return_value=>'IP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(245893700052641142.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Nome utente o indirizzo IP client'
,p_lov_return_value=>'USERNAME:IP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/login_message
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(138589612463299624.4054)
,p_lov_name=>'LOGIN_MESSAGE'
,p_lov_query=>'.'||wwv_flow_api.id(138589612463299624.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(138589828636299629.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Nessun messaggio'
,p_lov_return_value=>'NONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(138590030175299632.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Messaggio personalizzato'
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/login_remember_username
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(117703408573204417.4054)
,p_lov_name=>'LOGIN_REMEMBER_USERNAME'
,p_lov_query=>'.'||wwv_flow_api.id(117703408573204417.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(117703802213204418.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Memorizza nome utente'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/logo_attributes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(361197800293344621.4054)
,p_lov_name=>'LOGO ATTRIBUTES'
,p_reference_id=>461376702019738964.4054
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''BLACK_TEXT'') d, ''style="font-family:Arial; color:#000000; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''BLUE_TEXT'') d, ''style="font-family:Arial; color:#004C66; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''WHITE_TEXT'') d, ''style="font-family:Arial; color:#FFFFFF; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual',
'union all',
'select wwv_flow_lang.system_message(''GRAY_TEXT'') d, ''style="font-family:Arial; color:#303030; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''image_attributes'') d, ''alt="Application" title="Application"'' r from dual '))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_a
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87504531900192794.4054)
,p_lov_name=>'MAX_ROWS_A'
,p_lov_query=>'.'||wwv_flow_api.id(87504531900192794.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87504713683192797.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87504927403192799.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87505127136192799.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87505325056192799.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87505511346192800.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87505729136192800.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87505932223192800.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87506102365192800.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87506312795192801.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87506502410192801.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87506703570192801.4054)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87506912687192801.4054)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'10000'
,p_lov_return_value=>'10000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_b
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87717417968152000.4054)
,p_lov_name=>'MAX_ROWS_B'
,p_lov_query=>'.'||wwv_flow_api.id(87717417968152000.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87717608742152001.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87717807507152001.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87718000141152003.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87718209200152003.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87718403676152003.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87718622762152003.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87718817778152004.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87719020177152004.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87719230831152004.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87719426010152005.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87719614892152005.4054)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87719804628152005.4054)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'2000'
,p_lov_return_value=>'2000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_c
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87727319971247226.4054)
,p_lov_name=>'MAX_ROWS_C'
,p_lov_query=>'.'||wwv_flow_api.id(87727319971247226.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87727500041247227.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87727716571247227.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87727920372247227.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87728108070247227.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87728307878247228.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87728503519247228.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87728723800247228.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87728931351247228.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87729117092247229.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87729303121247229.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87729526911247229.4054)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87729730366247229.4054)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_d
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87730331399250507.4054)
,p_lov_name=>'MAX_ROWS_D'
,p_lov_query=>'.'||wwv_flow_api.id(87730331399250507.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87730525692250508.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87730714234250508.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87730921624250509.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87731129062250509.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87731321929250509.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87731521610250509.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87731715300250510.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87731919898250510.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87732124808250510.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87732326765250510.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87732513594250511.4054)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_e
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87733213522254832.4054)
,p_lov_name=>'MAX_ROWS_E'
,p_lov_query=>'.'||wwv_flow_api.id(87733213522254832.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87733416419254833.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87733622113254833.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87733822263254833.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87734024639254833.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87734223358254834.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87734413410254834.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87734626070254834.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87734809939254834.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87735015995254834.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87735225800254835.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87735423051254835.4054)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87735614522254835.4054)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'10000'
,p_lov_return_value=>'10000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_f
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87736221141257059.4054)
,p_lov_name=>'MAX_ROWS_F'
,p_lov_query=>'.'||wwv_flow_api.id(87736221141257059.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87736411674257059.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'2'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87736631478257060.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87736801252257060.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87737027711257060.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87737221803257060.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87737414548257062.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87737609481257062.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87737813226257062.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87738032062257063.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87738230641257063.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_g
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87738929453259457.4054)
,p_lov_name=>'MAX_ROWS_G'
,p_lov_query=>'.'||wwv_flow_api.id(87738929453259457.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87739106498259457.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87739329779259460.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87739525994259460.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87739719147259460.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87739911170259460.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87740103875259461.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87740303300259461.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87740516812259461.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87740731715259461.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87740924006259462.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87741116404259462.4054)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87741300621259463.4054)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_h
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87745327899296842.4054)
,p_lov_name=>'MAX_ROWS_H'
,p_lov_query=>'.'||wwv_flow_api.id(87745327899296842.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87745524146296844.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87745725148296845.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87745929261296845.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87746105830296845.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87746317502296845.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87746523232296846.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87746716198296846.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87746907159296846.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87747109934296846.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87747307992296846.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/new_workspace_request_storage_sizes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(388034003778139782.4054)
,p_lov_name=>'NEW WORKSPACE REQUEST STORAGE SIZES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select req_size d, req_size r',
'  from wwv_flow_workspace_req_size',
' where request_type = ''C''',
'order by to_number(req_size)',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/new_or_existing
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87820927180096887.4054)
,p_lov_name=>'NEW_OR_EXISTING'
,p_lov_query=>'.'||wwv_flow_api.id(87820927180096887.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87821100243096888.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Esistente'
,p_lov_return_value=>'Existing'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87821304136096888.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Nuovo'
,p_lov_return_value=>'New'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p104_report_row_per_page
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(786397812796590139.4054)
,p_lov_name=>'P104_Report Row Per Page'
,p_lov_query=>'.'||wwv_flow_api.id(786397812796590139.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(786398123613590140.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(786398320925590141.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(786398521498590141.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(786398729631590141.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(786398928953590141.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(786399112218590141.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(786399324445590141.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(786399515204590142.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(786399715492590142.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(786399932299590142.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p126_app_name
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(523374261553708976.4054)
,p_lov_name=>'P126_APP_NAME'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select case when app_type = ''DB'' then',
'         apex_application_id||'' - ''||app_name',
'       when app_type = ''WS'' then',
'         apex_websheet_id||'' - ''||app_name',
'       end d,',
'       id r',
'from wwv_flow_pkg_applications',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p131_smtp_tls_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(44180513498106696.4054)
,p_lov_name=>'P131_SMTP_TLS_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(44180513498106696.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(44180826675106699.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('S\00EC')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(44181001563106699.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Dopo che la connessione \00E8 stata stabilita')
,p_lov_return_value=>'STARTTLS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(44181213027106699.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p16_printsvr_protocol
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(41576101209699161.4054)
,p_lov_name=>'P16.PRINTSVR.PROTOCOL'
,p_lov_query=>'.'||wwv_flow_api.id(41576101209699161.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(41576425139699162.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'HTTP'
,p_lov_return_value=>'http'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(41576620353699162.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'HTTPS'
,p_lov_return_value=>'https'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p40_recent_time
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(858080230485699950.4054)
,p_lov_name=>'P40_RECENT_TIME'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, to_char(t) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5*60 t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15*60 t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 3600 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 2*3600  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3*3600  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4*3600  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6*3600 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8*3600 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12*3600 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 18*3600 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1*24*60*60 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2*24*60*60 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3*24*60*60 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4*24*60*60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5*24*60*60 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 6*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7*24*60*60 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14*24*60*60 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365*24*60*60 t from dual order by 2',
') q'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_view_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(131020216973707367.4054)
,p_lov_name=>'PAGE VIEW MODE'
,p_lov_query=>'.'||wwv_flow_api.id(131020216973707367.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131020902774707369.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Pagina dinamica'
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131020730367707369.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Elaborazione pagina'
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131020524068707368.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Pagina parziale'
,p_lov_return_value=>'P'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131023120221717730.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Cache creata'
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(131023727840719977.4054)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Pagina inserita nella cache'
,p_lov_return_value=>'R'
);
end;
/
prompt --application/shared_components/user_interface/lovs/password_generation
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(203295405272404658.4054)
,p_lov_name=>'PASSWORD GENERATION'
,p_lov_query=>'.'||wwv_flow_api.id(203295405272404658.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(203295628313404659.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Generazione casuale'
,p_lov_return_value=>'RANDOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(203295931728404663.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Valore specificato fisso'
,p_lov_return_value=>'FIXED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pkg_app_export_file_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(724744421387931965.4054)
,p_lov_name=>'PKG_APP_EXPORT_FILE_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(724744421387931965.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(724744704007931967.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Esportazione applicazione database'
,p_lov_return_value=>'FLOW_EXPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(724744920486931967.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Esportazione applicazione Websheet'
,p_lov_return_value=>'WEBSHEET_EXPORT'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'IS_DEV'
,p_lov_disp_cond2=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pkg_app_group
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(489214612081560300.4054)
,p_lov_name=>'PKG_APP_GROUP'
,p_lov_query=>'.'||wwv_flow_api.id(489214612081560300.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(489214935562560302.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Applicazione di produttivit\00E0')
,p_lov_return_value=>'PACKAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(489215221033560310.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Applicazione di esempio'
,p_lov_return_value=>'SAMPLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(489215520334560311.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Applicazione personalizzata'
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pkg_app_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(139567827161541660.4054)
,p_lov_name=>'PKG_APP_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(139567827161541660.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139568115253541663.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Database'
,p_lov_return_value=>'DB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(139568420816541670.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Websheet'
,p_lov_return_value=>'WS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/productivity_and_sample_application_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(255033227550969526.4054)
,p_lov_name=>'PRODUCTIVITY AND SAMPLE APPLICATION STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(255033227550969526.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(255033522048969526.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Disponibile'
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(255033800732969526.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Nascosto'
,p_lov_return_value=>'HIDDEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(255034107216969526.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Di futura implementazione'
,p_lov_return_value=>'COMING_SOON'
);
end;
/
prompt --application/shared_components/user_interface/lovs/project_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87715313766122404.4054)
,p_lov_name=>'PROJECT.STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(87715313766122404.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87715507041122405.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Rifiutato'
,p_lov_return_value=>'DECLINED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87715706617122406.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Richiesta'
,p_lov_return_value=>'REQUESTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87715911749122406.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Cessato'
,p_lov_return_value=>'TERMINATED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/provisioning_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87819917137094037.4054)
,p_lov_name=>'PROVISIONING.STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(87819917137094037.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87820106497094037.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Manuale - Un amministratore deve creare ciascuna area di lavoro manualmente'
,p_lov_return_value=>'MANUAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87820317112094038.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Richiesta - Collegamento visualizzato sulla pagina di login che consente agli utenti di richiedere aree di lavoro'
,p_lov_return_value=>'4700'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27774028242361017.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Richiesta - Collegamento visualizzato sulla pagina di login. Le richieste richiedono l''approvazione dell''amministratore.'
,p_lov_return_value=>'EMAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5680416359052583.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Automatico - Collegamento visualizzato sulla pagina di login. Le richieste vengono approvate automaticamente.'
,p_lov_return_value=>'AUTO'
);
end;
/
prompt --application/shared_components/user_interface/lovs/public_theme_app_selector
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(138968902616481833.4054)
,p_lov_name=>'PUBLIC.THEME.APP.SELECTOR'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id || '' - '' || name d, id v',
'  from WWV_FLOWS',
' where security_group_id = :P47_WORKSPACE',
'   and security_group_id not in (0,10,11)',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/public_app_templates_regiontemps
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(346773209253201282.4054)
,p_lov_name=>'PUBLIC_APP_TEMPLATES_REGIONTEMPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''NO_TEMPLATE'') d, 0 r from dual union all',
'select t.d, t.r from (',
'select wwv_flow_escape.html(page_plug_template_name) d, id r',
'from   wwv_flow_page_plug_templates',
'where  flow_id = :P125_ID and',
'       (:P125_THEME_ID is null or theme_id = :P125_THEME_ID)',
'order  by upper(page_plug_template_name) ) t'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/public_app_temp_defaults
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(340605730286750195.4054)
,p_lov_name=>'PUBLIC_APP_TEMP_DEFAULTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) name, id',
'from wwv_flow_templates',
'where flow_id = :P125_ID',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/public_app_temp_fielddefs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(340711321937795147.4054)
,p_lov_name=>'PUBLIC_APP_TEMP_FIELDDEFS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(template_name) d, id',
'from   wwv_flow_field_templates',
'where flow_id = :P125_ID',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/purge_days_list
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(615512721869254091.4054)
,p_lov_name=>'PURGE.DAYS_LIST'
,p_lov_query=>'.'||wwv_flow_api.id(615512721869254091.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615512924322254091.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'1 giorno'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615513111695254091.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'2 giorni'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615513323497254091.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'3 giorni'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615513531494254114.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'4 giorni'
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615513714171254114.4054)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5 giorni'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615513926201254115.4054)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'6 giorni '
,p_lov_return_value=>'6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615514125167254115.4054)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'7 giorni'
,p_lov_return_value=>'7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615514314553254115.4054)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'14 giorni'
,p_lov_return_value=>'14'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615514527430254115.4054)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'28 giorni'
,p_lov_return_value=>'28'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615514712006254115.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'180 giorni'
,p_lov_return_value=>'180'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615514906451254115.4054)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'365 giorni'
,p_lov_return_value=>'365'
);
end;
/
prompt --application/shared_components/user_interface/lovs/purge_log_codes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(615495005199220912.4054)
,p_lov_name=>'PURGE.LOG_CODES'
,p_lov_query=>'.'||wwv_flow_api.id(615495005199220912.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615495230385220912.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Aggiunto alla lista di rimozione'
,p_lov_return_value=>'NEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615495413353220912.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Rimosso alla lista di rimozione'
,p_lov_return_value=>'DELETE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615495630761220912.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Messaggio di posta elettronica inviato'
,p_lov_return_value=>'EMAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615495829822220912.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Non rimuovere'
,p_lov_return_value=>'RESPONSE_RETAIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615496013807220912.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Rimuovi'
,p_lov_return_value=>'RESPONSE_PURGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615496220933220912.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spostato nella lista di rimozione'
,p_lov_return_value=>'MOVED_TO_NEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615496401451220912.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Messaggio di posta elettronica completato'
,p_lov_return_value=>'EMAIL_COMPLETE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615496630482220913.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Messaggio di posta elettronica per promemoria completato'
,p_lov_return_value=>'REMINDER_EMAIL_COMPLETE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615496832221220915.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inizio della rimozione dell''area di lavoro'
,p_lov_return_value=>'BEGIN_PURGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615497016409220915.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Schema dell''area di lavoro valutato'
,p_lov_return_value=>'PURGE_SCHEMA_EVAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615497230209220915.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tablespace dell''area di lavoro valutata'
,p_lov_return_value=>'PURGE_TABLESPACE_EVAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615497410161220915.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Rimozione completata'
,p_lov_return_value=>'PURGE_COMPLETE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615497604761220915.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Errore durante l''eliminazione dell''utente'
,p_lov_return_value=>'ERROR_DROP_USER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615497814829220915.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Errore durante l''eliminazione della tablespace'
,p_lov_return_value=>'ERROR_DROP_TABLESPACE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615498029973220915.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inizio dell''eliminazione dell''utente del database'
,p_lov_return_value=>'BEGIN_DROP_USER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615500216627224175.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Fine dell''eliminazione dell''utente'
,p_lov_return_value=>'END_DROP_USER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615500722515225866.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inizio dell''eliminazione della tablespace'
,p_lov_return_value=>'BEGIN_DROP_TABLESPACE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615504427017227199.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Fine dell''eliminazione della tablespace'
,p_lov_return_value=>'END_DROP_TABLESPACE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615504631865228563.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Inizio dell''eliminazione dell''area di lavoro'
,p_lov_return_value=>'BEGIN_DELETE_WORKSPACE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615504903599229872.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Fine dell''eliminazione dell''area di lavoro'
,p_lov_return_value=>'END_DELETE_WORKSPACE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615505608101231192.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Errore durante l''eliminazione dell''area di lavoro'
,p_lov_return_value=>'ERROR_DELETE_WORKSPACE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/purge_workspace_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(615479015710157661.4054)
,p_lov_name=>'PURGE.WORKSPACE_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(615479015710157661.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615479202843157669.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Aggiunto alla lista di rimozione'
,p_lov_return_value=>'NEW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615479403481157676.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Da rimuovere (messaggio di posta elettronica inviato)'
,p_lov_return_value=>'STAGE1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615479623663157676.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Da rimuovere (messaggio di posta elettronica per promemoria inviato)'
,p_lov_return_value=>'STAGE2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615479804138157676.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Conservato'
,p_lov_return_value=>'RETAIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615480031669157676.4054)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'In fase di rimozione'
,p_lov_return_value=>'PURGING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615480218013157676.4054)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Rimosso'
,p_lov_return_value=>'PURGED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/recent_time
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88332700235936298.4054)
,p_lov_name=>'RECENT_TIME'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/recent_time_archive
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(879932532606742210.4054)
,p_lov_name=>'RECENT_TIME_ARCHIVE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MONTH'')) d, 31 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''MONTHS'')) d, 62 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''MONTHS'')) d, 93 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''YEARS'')) d, 730 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''YEARS'')) d, 1095 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''YEARS'')) d, 1460 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''YEARS'')) d, 1825 t from dual union all',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''YEARS'')) d, 3650 t from dual ',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/rejoin_existing_sessions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(492748357556507488.4054)
,p_lov_name=>'REJOIN_EXISTING_SESSIONS'
,p_lov_query=>'.'||wwv_flow_api.id(492748357556507488.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492748670516507489.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Disabilitato'
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492748976232507489.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Abilitato per le sessioni pubbliche'
,p_lov_return_value=>'P'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492749211223507489.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Abilitato per tutte le sessioni'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/reporting_period
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(180726228364333770.4054)
,p_lov_name=>'REPORTING PERIOD'
,p_lov_query=>'.'||wwv_flow_api.id(180726228364333770.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180726414372333772.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Giorno'
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180726626461333773.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Settimana'
,p_lov_return_value=>'W'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180726828392333773.4054)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>'2 settimane'
,p_lov_return_value=>'2W'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180727012432333773.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Mese'
,p_lov_return_value=>'M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180727220433333773.4054)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>'2 mesi'
,p_lov_return_value=>'2M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180727427905333773.4054)
,p_lov_disp_sequence=>31.5
,p_lov_disp_value=>'3 mesi'
,p_lov_return_value=>'3M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180727608631333773.4054)
,p_lov_disp_sequence=>32
,p_lov_disp_value=>'6 mesi'
,p_lov_return_value=>'6M'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180727828386333774.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Anno'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180728029949333774.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'2 anni'
,p_lov_return_value=>'2Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(180728214594333774.4054)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'5 anni'
,p_lov_return_value=>'5Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/request_status_show
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87760131282243533.4054)
,p_lov_name=>'REQUEST.STATUS.SHOW'
,p_lov_query=>'.'||wwv_flow_api.id(87760131282243533.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87760332362243533.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tutto'
,p_lov_return_value=>'All'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87760505501243533.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Approvato'
,p_lov_return_value=>'Approved'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87760729237243534.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Rifiutato'
,p_lov_return_value=>'Denied'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87760900898243534.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Aperto'
,p_lov_return_value=>'Open'
);
end;
/
prompt --application/shared_components/user_interface/lovs/require_https
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(403484377450328143.4054)
,p_lov_name=>'REQUIRE_HTTPS'
,p_lov_query=>'.'||wwv_flow_api.id(403484377450328143.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(403484695431328151.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Sempre'
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(403484928622328157.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Per sviluppo e amministrazione'
,p_lov_return_value=>'I'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(403485262310328157.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Specifico dell''applicazione'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/reset_password_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(25472316973371525.4054)
,p_lov_name=>'RESET PASSWORD TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(25472316973371525.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25472613858371526.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Generazione casuale'
,p_lov_return_value=>'G'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25472824725371527.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Fornito'
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/resource_consumer_groups_non_system
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(13874928060276355.4054)
,p_lov_name=>'RESOURCE CONSUMER GROUPS (NON  SYSTEM)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select consumer_group d, consumer_group r',
'  from sys.dba_rsrc_consumer_groups',
' where consumer_group not like ''ORA$%''',
'   and consumer_group <> ''SYS_GROUP''',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sample_and_productivity_application_category
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(141471800528473164.4054)
,p_lov_name=>'SAMPLE AND PRODUCTIVITY APPLICATION CATEGORY'
,p_lov_query=>'select category_name, id from wwv_flow_pkg_app_categories'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/scheduled_job_state
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1352009278507904884.4054)
,p_lov_name=>'SCHEDULED_JOB_STATE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    select wwv_flow_lang.system_message(''F4050.CHAIN_STALLED'') d,''CHAIN_STALLED'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.SUCCEEDED'') d,''SUCCEEDED'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.RETRY SCHEDULED'') d,''RETRY SCHEDULED'' r from dual where :APP_PAGE_ID <> 26',
'    union',
'    select wwv_flow_lang.system_message(''F4050.REMOTE'') d, ''REMOTE'' r  from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.FAILED'') d, ''FAILED'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.BROKEN'') d,''BROKEN'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.COMPLETED'') d, ''COMPLETED'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.RUNNING'') d, ''RUNNING'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.DISABLED'') d, ''DISABLED'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.SCHEDULED'') d, ''SCHEDULED'' r from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/seconds
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(15314811390892155.4054)
,p_lov_name=>'SECONDS'
,p_lov_query=>'.'||wwv_flow_api.id(15314811390892155.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15315103445892221.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'1 minuto'
,p_lov_return_value=>'60'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15315321205892225.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'5 minuti'
,p_lov_return_value=>'300'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15315517639892226.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'10 minuti'
,p_lov_return_value=>'600'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15315725224892226.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'30 minuti'
,p_lov_return_value=>'1800'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15315913935892226.4054)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'1 ora'
,p_lov_return_value=>'3600'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15316108518892226.4054)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'2 ore'
,p_lov_return_value=>'7200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15316322196892226.4054)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'5 ore'
,p_lov_return_value=>'18000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15316515182892228.4054)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'10 ore'
,p_lov_return_value=>'36000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/service_request_name
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(110368323210290856.4054)
,p_lov_name=>'SERVICE.REQUEST.NAME'
,p_lov_query=>'.'||wwv_flow_api.id(110368323210290856.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110368501503290856.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Nuovo schema'
,p_lov_return_value=>'NEW_SCHEMA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110368723358290857.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Rimuovi area di lavoro'
,p_lov_return_value=>'REMOVE_EXISTING_SERVICE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110368924348290857.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Rimuovi schema'
,p_lov_return_value=>'REMOVE_EXISTING_SCHEMA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110369132258290857.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Richiesta di memoria'
,p_lov_return_value=>'CHANGE_DB_SIZE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/service_request_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87755726864223308.4054)
,p_lov_name=>'SERVICE.REQUEST.STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(87755726864223308.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87755910389223309.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Approvato'
,p_lov_return_value=>'APPROVED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87756108879223309.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Rifiutato'
,p_lov_return_value=>'DECLINED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87756328524223309.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'In corso'
,p_lov_return_value=>'IN_PROGRESS'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_EQUAL_CONDITION'
,p_lov_disp_cond=>'26'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87756529293223310.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Richiesto'
,p_lov_return_value=>'REQUESTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87756716926223310.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Cessato'
,p_lov_return_value=>'TERMINATED'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_EQUAL_CONDITION'
,p_lov_disp_cond=>'7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22138608522000517.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Accettato'
,p_lov_return_value=>'ACCEPTED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/service_request_status_002
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(316820619150159698.4054)
,p_lov_name=>'SERVICE_REQUEST_STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    select wwv_flow_lang.system_message(''F4050.APPROVED'') d,''APPROVED'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.DECLINED'') d,''DECLINED'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.IN_PROGRESS'') d,''IN_PROGRESS'' r from dual where :APP_PAGE_ID <> 26',
'    union',
'    select wwv_flow_lang.system_message(''F4050.REQUESTED'') d, ''REQUESTED'' r  from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.TERMINATED'') d, ''TERMINATED'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.ACCEPTED_MSG'') d,''ACCEPTED'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.TERMINATION_IN_PROGRESS'') d, ''TERMINATION_IN_PROGRESS'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.TERMINATION_IN_PROGRESS'') d, ''TERMINATION_IN_PROGRESS2'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.TERMINATION_IN_PROGRESS'') d, ''TERMINATION_IN_PROGRESS3'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.TERMINATION_IN_PROGRESS'') d, ''TERMINATION_IN_PROGRESS4'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.TERMINATION_IN_PROGRESS'') d, ''TERMINATION_IN_PROGRESS5'' r from dual',
'    union',
'    select wwv_flow_lang.system_message(''F4050.TERMINATION_IN_PROGRESS'') d, ''TERMINATION_IN_PROGRESS6'' r from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/site_admin_password_option
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(25698924524085246.4054)
,p_lov_name=>'SITE ADMIN PASSWORD OPTION'
,p_lov_query=>'.'||wwv_flow_api.id(25698924524085246.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(89831430148813773.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Usa criteri specificati in Criteri password area di lavoro'
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25699227500085250.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Usa criteri password efficace predefiniti'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/task_display_location
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(75242612126455451.4054)
,p_lov_name=>'TASK_DISPLAY_LOCATION'
,p_lov_query=>'.'||wwv_flow_api.id(75242612126455451.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(75243106849455455.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Login ad area di lavoro'
,p_lov_return_value=>'WORKSPACE_LOGIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(75242903496455454.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Home area di lavoro'
,p_lov_return_value=>'WORKSPACE_HOME'
);
end;
/
prompt --application/shared_components/user_interface/lovs/team_dev_fs_limit
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(689538645438591983.4054)
,p_lov_name=>'TEAM_DEV_FS_LIMIT'
,p_reference_id=>689579484876680828.4054
,p_lov_query=>'.'||wwv_flow_api.id(689538645438591983.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(689584332672694643.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5242880'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(689584683398694643.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10485760'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(689584997130694643.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15728640'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(689585237571694643.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20971520'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(689585513830694643.4054)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'25'
,p_lov_return_value=>'26214400'
);
end;
/
prompt --application/shared_components/user_interface/lovs/time_intervals
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87720511660244788.4054)
,p_lov_name=>'TIME_INTERVALS'
,p_lov_query=>'.'||wwv_flow_api.id(87720511660244788.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87720705217244789.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87720918270244790.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'2'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87721128398244790.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'3'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87721316635244790.4054)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'4'
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87721518511244790.4054)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87721714192244790.4054)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'6'
,p_lov_return_value=>'6'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87721929981244791.4054)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'7'
,p_lov_return_value=>'7'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87722127765244791.4054)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'8'
,p_lov_return_value=>'8'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87722317438244791.4054)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'9'
,p_lov_return_value=>'9'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87722509755244791.4054)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87722724680244792.4054)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'11'
,p_lov_return_value=>'11'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87722931920244792.4054)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'12'
,p_lov_return_value=>'12'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87723110878244792.4054)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'13'
,p_lov_return_value=>'13'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87723310283244792.4054)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>'14'
,p_lov_return_value=>'14'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87723528574244793.4054)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87723715299244793.4054)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>'16'
,p_lov_return_value=>'16'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87723913501244793.4054)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>'17'
,p_lov_return_value=>'17'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87724129057244793.4054)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>'18'
,p_lov_return_value=>'18'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87724326333244793.4054)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>'19'
,p_lov_return_value=>'19'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87724500227244794.4054)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87724715549244794.4054)
,p_lov_disp_sequence=>210
,p_lov_disp_value=>'21'
,p_lov_return_value=>'21'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87724919187244794.4054)
,p_lov_disp_sequence=>220
,p_lov_disp_value=>'22'
,p_lov_return_value=>'22'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87725132288244794.4054)
,p_lov_disp_sequence=>230
,p_lov_disp_value=>'23'
,p_lov_return_value=>'23'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87725315196244795.4054)
,p_lov_disp_sequence=>240
,p_lov_disp_value=>'24'
,p_lov_return_value=>'24'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87725519222244795.4054)
,p_lov_disp_sequence=>250
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87725726981244795.4054)
,p_lov_disp_sequence=>260
,p_lov_disp_value=>'26'
,p_lov_return_value=>'26'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87725929193244795.4054)
,p_lov_disp_sequence=>270
,p_lov_disp_value=>'27'
,p_lov_return_value=>'27'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87726105331244796.4054)
,p_lov_disp_sequence=>280
,p_lov_disp_value=>'28'
,p_lov_return_value=>'28'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87726330087244796.4054)
,p_lov_disp_sequence=>290
,p_lov_disp_value=>'29'
,p_lov_return_value=>'29'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87726525128244796.4054)
,p_lov_disp_sequence=>300
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87726708945244797.4054)
,p_lov_disp_sequence=>310
,p_lov_disp_value=>'31'
,p_lov_return_value=>'31'
);
end;
/
prompt --application/shared_components/user_interface/lovs/unhandled_errors
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(818371130728427287.4054)
,p_lov_name=>'UNHANDLED ERRORS'
,p_lov_query=>'.'||wwv_flow_api.id(818371130728427287.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(818371498373427288.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Mostra pagina di errore'
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(818371769110427289.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Restituisci HTTP 400'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/user_groups
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(161727824824923998.4054)
,p_lov_name=>'USER.GROUPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(group_name) d, id r',
'from wwv_flow_fnd_user_groups_noapp',
'where security_group_id = :F4050_P23_SECURITY_GROUP_ID order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/view_as_list_or_icons
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(138021018445611867.4054)
,p_lov_name=>'VIEW AS LIST OR ICONS'
,p_lov_query=>'.'||wwv_flow_api.id(138021018445611867.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(138021303911611867.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Icone'
,p_lov_return_value=>'ICON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(138021517322611867.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Dettagli'
,p_lov_return_value=>'DETAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/webservice_logging
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(582428114482274404.4054)
,p_lov_name=>'WEBSERVICE LOGGING'
,p_lov_query=>'.'||wwv_flow_api.id(582428114482274404.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(582428454798274405.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Usa impostazioni area di lavoro (predefinito)'
,p_lov_return_value=>'U'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(582428895116274405.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Sempre'
,p_lov_return_value=>'A'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(582429260294274406.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Mai'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_authentication
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(789383217265083754.4054)
,p_lov_name=>'WEBSHEET AUTHENTICATION'
,p_reference_id=>460742018651713171.4054
,p_lov_query=>'.'||wwv_flow_api.id(789383217265083754.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(789384818977083756.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Account Application Express'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(789385020754083756.4054)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Single Sign-On'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(789385210266083756.4054)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'LDAP'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1959580205983105252.4054)
,p_lov_disp_sequence=>4.5
,p_lov_disp_value=>'Oracle Cloud Identity Management'
,p_lov_return_value=>'5'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(789385402302083756.4054)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Personalizzato'
,p_lov_return_value=>'4'
);
end;
/
prompt --application/shared_components/user_interface/lovs/workspace_name_computation
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(203194513911255730.4054)
,p_lov_name=>'WORKSPACE NAME COMPUTATION'
,p_lov_query=>'.'||wwv_flow_api.id(203194513911255730.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(203194724498255732.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Nomi aree di lavoro generati dal sistema'
,p_lov_return_value=>'GENERATED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(203195007395255734.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Nome area di lavoro con prefisso inserito in modo statico e suffisso intero sequenziale'
,p_lov_return_value=>'PREFIX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(203195313535255734.4054)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Nome dominio di posta elettronica come nome area di lavoro, con suffisso intero sequenziale per i duplicati'
,p_lov_return_value=>'DOMAIN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/workspace_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2379160755129464721.4054)
,p_lov_name=>'WORKSPACE STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(2379160755129464721.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2379161043169464735.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Disponibile'
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2379161436349464739.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Assegnato'
,p_lov_return_value=>'ASSIGNED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2379161846315464740.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Sospeso'
,p_lov_return_value=>'SUSPENDED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2379162230719464740.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cessato'
,p_lov_return_value=>'TERMINATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2379162625399464740.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Bloccato'
,p_lov_return_value=>'ASSIGN_LCK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_app_acl_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(789504612333102303.4054)
,p_lov_name=>'WS_APP_ACL_TYPE'
,p_reference_id=>460746220203713213.4054
,p_lov_query=>'.'||wwv_flow_api.id(789504612333102303.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(789505600468102306.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Valore predefinito'
,p_lov_return_value=>'DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(789505802137102306.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Personalizzato'
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_app_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(787558207696790415.4054)
,p_lov_name=>'WS_APP_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(787558207696790415.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(787558503193790416.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Disponibile'
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(787558723914790416.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Non disponibile'
,p_lov_return_value=>'UNAVAILABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_logo_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(788592429400938627.4054)
,p_lov_name=>'WS_LOGO_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(788592429400938627.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788592711265938628.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Nessuno'
,p_lov_return_value=>'NONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(788592917302938628.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Testo'
,p_lov_return_value=>'TEXT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_provisioning_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(113228404836854036.4054)
,p_lov_name=>'WS_PROVISIONING_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(113228404836854036.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113228711736854036.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Abilitato'
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113228921295854036.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Disabilitato'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_yes_or_no
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(110344620122166929.4054)
,p_lov_name=>'YES NO RETURNS YES OR NO'
,p_lov_query=>'.'||wwv_flow_api.id(110344620122166929.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110344806562166931.4054)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('S\00EC')
,p_lov_return_value=>'YES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(110345012767166934.4054)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No'
,p_lov_return_value=>'NO'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_1_or_0
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(87817312158083090.4054)
,p_lov_name=>'YES.NO.RETURNS.1_OR_0'
,p_lov_query=>'.'||wwv_flow_api.id(87817312158083090.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87817530004083091.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'No'
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(87817713905083091.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('S\00EC')
,p_lov_return_value=>'1'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_or_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(157992123774592395.4054)
,p_lov_name=>'YES_NO_RETURNS_Y_OR_N'
,p_lov_query=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157992405775592399.4054)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('S\00EC')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157992613021592401.4054)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/internal_admin_menu
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(4585800473139662.4054)
,p_name=>'internal.admin.menu'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2589300985659863.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per sistema operativo'
,p_link=>'f?p=&FLOW_ID.:13:&SESSION.'
,p_page_id=>13
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2600224886694329.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per browser'
,p_link=>'f?p=&FLOW_ID.:15:&SESSION.'
,p_page_id=>15
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4586800042158416.4054)
,p_parent_id=>wwv_flow_api.id(.4054)
,p_short_name=>'<span class="u-VisuallyHidden">Home</span><span class="a-Icon icon-breadcrumb-previous" title="Home"></span>'
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4587312509162011.4054)
,p_parent_id=>wwv_flow_api.id(6027506192823381.4054)
,p_short_name=>'Richieste di area di lavoro'
,p_link=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:::'
,p_page_id=>26
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4587825323165692.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Stato sessione'
,p_link=>'f?p=&APP_ID.:63:&SESSION.::&DEBUG.:::'
,p_page_id=>63
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4603211003239218.4054)
,p_parent_id=>wwv_flow_api.id(6027506192823381.4054)
,p_short_name=>'Richieste di modifica'
,p_link=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:::'
,p_page_id=>28
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4608012500253721.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Crea area di lavoro'
,p_link=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:::'
,p_page_id=>27
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4611726506262368.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Configurazione funzioni'
,p_link=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:::'
,p_page_id=>16
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4617723690278867.4054)
,p_parent_id=>wwv_flow_api.id(4586800042158416.4054)
,p_short_name=>unistr('Controlla attivit\00E0')
,p_link=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:::'
,p_page_id=>29
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4623831010290711.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per applicazione'
,p_link=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.:::'
,p_page_id=>44
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4626009659300609.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per applicazione e utente'
,p_link=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.:::'
,p_page_id=>49
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4645824047369956.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per User Agent'
,p_link=>'f?p=&APP_ID.:38:&SESSION.::&DEBUG.:::'
,p_page_id=>38
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4652116893418791.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>unistr('Log di attivit\00E0 delle visualizzazioni di pagina')
,p_link=>'f?p=&APP_ID.:61:&SESSION.::&DEBUG.:::'
,p_page_id=>61
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4653409561422233.4054)
,p_parent_id=>wwv_flow_api.id(4652116893418791.4054)
,p_short_name=>'Tronca log'
,p_link=>'f?p=&FLOW_ID.:62:&SESSION.'
,p_page_id=>62
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4720402234683880.4054)
,p_parent_id=>wwv_flow_api.id(4587825323165692.4054)
,p_short_name=>'Svuota sessioni'
,p_link=>'f?p=&FLOW_ID.:66:&SESSION.'
,p_page_id=>66
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4722132186700450.4054)
,p_parent_id=>wwv_flow_api.id(4587825323165692.4054)
,p_short_name=>'Sessioni recenti'
,p_link=>'f?p=&FLOW_ID.:65:&SESSION.'
,p_page_id=>65
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4728709418862901.4054)
,p_parent_id=>wwv_flow_api.id(4587825323165692.4054)
,p_short_name=>'Statistiche stato sessioni'
,p_link=>'f?p=&FLOW_ID.:64:&SESSION.'
,p_page_id=>64
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4737627256930650.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Log di SQL Workshop'
,p_link=>'f?p=&APP_ID.:46:&SESSION.::&DEBUG.:::'
,p_page_id=>46
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4738821217933374.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Aree di lavoro esistenti'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4742104180941272.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Dettagli area di lavoro'
,p_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
,p_page_id=>14
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4747925937961632.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Gestisci sviluppatori e utenti'
,p_link=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::'
,p_page_id=>12
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4754008241985056.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per area di lavoro'
,p_link=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:::'
,p_page_id=>33
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4756326991991493.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per sito esterno'
,p_link=>'f?p=&APP_ID.:45:&SESSION.::&DEBUG.:::'
,p_page_id=>45
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4760620508009758.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per giorno per applicazione e utente'
,p_link=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.:::'
,p_page_id=>37
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4762212745013281.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per visualizzazione'
,p_link=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:::'
,p_page_id=>30
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4764402609017998.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Eventi di pagina per giorno'
,p_link=>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.:::'
,p_page_id=>54
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4767612301028720.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per area di lavoro e utente'
,p_link=>'f?p=&APP_ID.:36:&SESSION.::&DEBUG.:::'
,p_page_id=>36
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4770921778039473.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Modifiche all''applicazione per sviluppatore'
,p_link=>'f?p=&APP_ID.:43:&SESSION.::&DEBUG.:::'
,p_page_id=>43
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5077608631625856.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>unistr('Log di attivit\00E0 dello sviluppatore')
,p_link=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.:::'
,p_page_id=>19
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5087818742651531.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Log di conteggio clic esterni'
,p_link=>'f?p=&APP_ID.:85:&SESSION.::&DEBUG.:::'
,p_page_id=>85
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6027506192823381.4054)
,p_parent_id=>wwv_flow_api.id(4586800042158416.4054)
,p_short_name=>'Gestisci richieste'
,p_link=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::'
,p_page_id=>5
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6052324602932730.4054)
,p_parent_id=>wwv_flow_api.id(4586800042158416.4054)
,p_short_name=>'Gestisci aree di lavoro'
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(8781730446978159.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Privilegi database area di lavoro'
,p_link=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::'
,p_page_id=>22
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(10132224222229347.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per ora'
,p_link=>'f?p=&FLOW_ID.:69:&SESSION.'
,p_page_id=>69
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(12733917471664461.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Tentativi di login'
,p_link=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:::'
,p_page_id=>24
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(13869232224656033.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Crea area di lavoro'
,p_link=>'f?p=&APP_ID.:72:&SESSION.::&DEBUG.:::'
,p_page_id=>72
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(13871226833658518.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Crea area di lavoro'
,p_link=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.:::'
,p_page_id=>73
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(13872723167660259.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Crea area di lavoro'
,p_link=>'f?p=&APP_ID.:74:&SESSION.::&DEBUG.:::'
,p_page_id=>74
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(13874119069662163.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Crea area di lavoro'
,p_link=>'f?p=&APP_ID.:79:&SESSION.::&DEBUG.:::'
,p_page_id=>79
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(14583119493258633.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Rimuovi area di lavoro'
,p_link=>'f?p=&APP_ID.:81:&SESSION.::&DEBUG.:::'
,p_page_id=>81
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(14583529882261640.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Rimuovi area di lavoro'
,p_link=>'f?p=&APP_ID.:82:&SESSION.::&DEBUG.:::'
,p_page_id=>82
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(14583906465264336.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Rimuovi area di lavoro'
,p_link=>'f?p=&APP_ID.:83:&SESSION.::&DEBUG.:::'
,p_page_id=>83
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(14584921356268633.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Rimuovi area di lavoro'
,p_link=>'f?p=&APP_ID.:84:&SESSION.::&DEBUG.:::'
,p_page_id=>84
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(15366805621981104.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Log degli accessi di login'
,p_link=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.:::'
,p_page_id=>31
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(15549610245678522.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Modifiche all''applicazione per area di lavoro'
,p_link=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.:::'
,p_page_id=>500
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(18703821024277695.4054)
,p_parent_id=>wwv_flow_api.id(19718719669530547.4054)
,p_short_name=>'Aggiungi schema'
,p_link=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:::'
,p_page_id=>105
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(18704130374280378.4054)
,p_parent_id=>wwv_flow_api.id(19718719669530547.4054)
,p_short_name=>'Aggiungi schema'
,p_link=>'f?p=&APP_ID.:106:&SESSION.::&DEBUG.:::'
,p_page_id=>106
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(18704412151284643.4054)
,p_parent_id=>wwv_flow_api.id(19718719669530547.4054)
,p_short_name=>'Aggiungi schema'
,p_link=>'f?p=&APP_ID.:107:&SESSION.::&DEBUG.:::'
,p_page_id=>107
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(18704723233287852.4054)
,p_parent_id=>wwv_flow_api.id(19718719669530547.4054)
,p_short_name=>'Aggiungi schema'
,p_link=>'f?p=&APP_ID.:108:&SESSION.::&DEBUG.:::'
,p_page_id=>108
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(19718719669530547.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Gestisci assegnazioni area di lavoro a schema'
,p_link=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::'
,p_page_id=>21
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(20501516629215230.4054)
,p_parent_id=>wwv_flow_api.id(4603211003239218.4054)
,p_short_name=>'Visualizza richiesta di modifica'
,p_link=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:110::'
,p_page_id=>110
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(22715826706534997.4054)
,p_parent_id=>wwv_flow_api.id(15549610245678522.4054)
,p_short_name=>unistr('Dettagli attivit\00E0 area di lavoro')
,p_link=>'f?p=&APP_ID.:501:&SESSION.::&DEBUG.:::'
,p_page_id=>501
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(23596724286518552.4054)
,p_parent_id=>wwv_flow_api.id(4737627256930650.4054)
,p_short_name=>'Cleanup log'
,p_link=>'f?p=&APP_ID.:75:&SESSION.::&DEBUG.:::'
,p_page_id=>75
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(25559802916879559.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Aree di lavoro solo con applicazione di esempio'
,p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
,p_page_id=>2
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(25769124953813347.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Iscrizione guidata servizio'
,p_link=>'f?p=&APP_ID.:111:&SESSION.::&DEBUG.:::'
,p_page_id=>111
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(29801815135014216.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Ricerca area di lavoro'
,p_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:::'
,p_page_id=>8000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(29817826940342994.4054)
,p_parent_id=>wwv_flow_api.id(29801815135014216.4054)
,p_short_name=>'Area di lavoro'
,p_link=>'f?p=&FLOW_ID.:8001:&SESSION.'
,p_page_id=>8001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(39295630191089140.4054)
,p_parent_id=>wwv_flow_api.id(4747925937961632.4054)
,p_short_name=>'Crea/Modifica utente'
,p_link=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:::'
,p_page_id=>23
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40438104699665664.4054)
,p_parent_id=>wwv_flow_api.id(4587312509162011.4054)
,p_short_name=>'Amministrazione della fornitura'
,p_link=>'f?p=&FLOW_ID.:4:&SESSION.'
,p_page_id=>4
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40439200601667531.4054)
,p_parent_id=>wwv_flow_api.id(4587312509162011.4054)
,p_short_name=>'Approva richiesta di fornitura'
,p_link=>'f?p=&FLOW_ID.:55:&SESSION.'
,p_page_id=>55
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40440327331670342.4054)
,p_parent_id=>wwv_flow_api.id(4587312509162011.4054)
,p_short_name=>'Rifiuta richiesta di fornitura'
,p_link=>'f?p=&FLOW_ID.:56:&SESSION.'
,p_page_id=>56
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(40441522370672659.4054)
,p_parent_id=>wwv_flow_api.id(4587312509162011.4054)
,p_short_name=>'Richiesta di fornitura'
,p_link=>'f?p=&FLOW_ID.:6:&SESSION.'
,p_page_id=>6
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47181408364860054.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Ultimo login sviluppatore'
,p_link=>'f?p=&FLOW_ID.:35:&SESSION.'
,p_page_id=>35
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(47636522749932000.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Sicurezza'
,p_link=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:::'
,p_page_id=>130
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(48366213770241935.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Coda della posta'
,p_long_name=>'Coda della posta'
,p_link=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.:::'
,p_page_id=>120
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(50513708160442260.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Log della posta'
,p_long_name=>'Log della posta'
,p_link=>'f?p=&APP_ID.:121:&SESSION.::&DEBUG.:::'
,p_page_id=>121
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(51163924477211254.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Impostazioni istanza'
,p_link=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.:::'
,p_page_id=>131
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(51281405952355975.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Imposta messaggio di sistema'
,p_link=>'f?p=&APP_ID.:132:&SESSION.::&DEBUG.:::'
,p_page_id=>132
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(63533206146931905.4054)
,p_parent_id=>wwv_flow_api.id(4747925937961632.4054)
,p_short_name=>'Reimposta password'
,p_link=>'f?p=&FLOW_ID.:53:&SESSION.'
,p_page_id=>53
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(63706904690661881.4054)
,p_parent_id=>wwv_flow_api.id(4722132186700450.4054)
,p_short_name=>'Dettagli sessioni'
,p_link=>'f?p=&FLOW_ID.:67:&SESSION.'
,p_page_id=>67
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(68357616835819088.4054)
,p_parent_id=>wwv_flow_api.id(4587312509162011.4054)
,p_short_name=>'Adegua richiesta'
,p_link=>'f?p=&FLOW_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(68369605800844354.4054)
,p_parent_id=>wwv_flow_api.id(4587312509162011.4054)
,p_short_name=>'Elimina richiesta'
,p_link=>'f?p=&FLOW_ID.:8:&SESSION.::&DEBUG.:::'
,p_page_id=>8
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(68455820429179669.4054)
,p_parent_id=>wwv_flow_api.id(4738821217933374.4054)
,p_short_name=>'Modifica informazioni sull''area di lavoro'
,p_link=>'f?p=&APP_ID.:78:&SESSION.::&DEBUG.:::'
,p_page_id=>78
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(74653816579025410.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Blocca area di lavoro'
,p_link=>'f?p=&FLOW_ID.:89:&SESSION.'
,p_page_id=>89
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(74669930632071892.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Blocca area di lavoro'
,p_link=>'f?p=&FLOW_ID.:90:&SESSION.'
,p_page_id=>90
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(75184116621221469.4054)
,p_parent_id=>wwv_flow_api.id(79867419412344264.4054)
,p_short_name=>'Installa area di lavoro'
,p_link=>'f?p=&APP_ID.:278:&SESSION.::&DEBUG.:::'
,p_page_id=>278
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(75265816075541761.4054)
,p_parent_id=>wwv_flow_api.id(75266632352546405.4054)
,p_short_name=>'Crea/Modifica task specifici del sito'
,p_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::'
,p_page_id=>17
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(75266632352546405.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Task specifici del sito'
,p_link=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:17::'
,p_page_id=>18
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(79867419412344264.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Importa area di lavoro'
,p_long_name=>'Importa area di lavoro'
,p_link=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.:::'
,p_page_id=>460
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(79869300066366991.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Importa area di lavoro'
,p_link=>'f?p=&APP_ID.:163:&SESSION.::&DEBUG.:::'
,p_page_id=>163
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(79871328247384629.4054)
,p_parent_id=>wwv_flow_api.id(79867419412344264.4054)
,p_short_name=>'Installa area di lavoro'
,p_long_name=>'Installa area di lavoro'
,p_link=>'f?p=&FLOW_ID.:277:&SESSION.::&DEBUG.:::'
,p_page_id=>277
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(79871614873390258.4054)
,p_parent_id=>wwv_flow_api.id(79867419412344264.4054)
,p_short_name=>'Installa area di lavoro'
,p_long_name=>'Installa area di lavoro'
,p_link=>'f?p=&FLOW_ID.:165:&SESSION.::&DEBUG.:::'
,p_page_id=>165
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(79871930110394643.4054)
,p_parent_id=>wwv_flow_api.id(79867419412344264.4054)
,p_short_name=>'File di esportazione area di lavoro importata'
,p_link=>'f?p=&APP_ID.:173:&SESSION.::&DEBUG.:::'
,p_page_id=>173
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(81363923500633767.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Esporta area di lavoro'
,p_link=>'f?p=&APP_ID.:461:&SESSION.::&DEBUG.:::'
,p_page_id=>461
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(98196930690236730.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Ultimo utilizzo area di lavoro'
,p_link=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::'
,p_page_id=>25
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(121237915211639980.4054)
,p_parent_id=>wwv_flow_api.id(254193629012291915.4054)
,p_short_name=>'Crea applicazione'
,p_link=>'f?p=&APP_ID.:112:&SESSION.::&DEBUG.:::'
,p_page_id=>112
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(121734014934716132.4054)
,p_parent_id=>wwv_flow_api.id(254193629012291915.4054)
,p_short_name=>'Crea applicazione'
,p_link=>'f?p=&APP_ID.:103:&SESSION.::&DEBUG.:::'
,p_page_id=>103
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(122519308926946754.4054)
,p_parent_id=>wwv_flow_api.id(254193629012291915.4054)
,p_short_name=>'Crea applicazione'
,p_link=>'f?p=&APP_ID.:109:&SESSION.::&DEBUG.:::'
,p_page_id=>109
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(130330112588540496.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Sondaggio iscrizione'
,p_link=>'f?p=&APP_ID.:113:&SESSION.::&DEBUG.:::'
,p_page_id=>113
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(132784419557719566.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Nuove richieste di servizio'
,p_link=>'f?p=&FLOW_ID.:114:&SESSION.'
,p_page_id=>114
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(138018800392611865.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Temi pubblici'
,p_link=>'f?p=&APP_ID.:555:&SESSION.::&DEBUG.:::'
,p_page_id=>555
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(138031613241631494.4054)
,p_parent_id=>wwv_flow_api.id(138018800392611865.4054)
,p_short_name=>'Modifica tema pubblico'
,p_link=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.:::'
,p_page_id=>42
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(138042916646643273.4054)
,p_parent_id=>wwv_flow_api.id(138018800392611865.4054)
,p_short_name=>'Crea tema pubblico'
,p_link=>'f?p=&APP_ID.:47:&SESSION.::&DEBUG.:::'
,p_page_id=>47
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(138053929247655080.4054)
,p_parent_id=>wwv_flow_api.id(138018800392611865.4054)
,p_short_name=>'Crea tema pubblico'
,p_link=>'f?p=&APP_ID.:48:&SESSION.::&DEBUG.:::'
,p_page_id=>48
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(138064613747663617.4054)
,p_parent_id=>wwv_flow_api.id(138018800392611865.4054)
,p_short_name=>'Crea tema pubblico'
,p_link=>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.:::'
,p_page_id=>51
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(138137024290914175.4054)
,p_parent_id=>wwv_flow_api.id(138018800392611865.4054)
,p_short_name=>'Crea tema pubblico'
,p_link=>'f?p=&FLOW_ID.:57:&SESSION.'
,p_page_id=>57
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(138141916090918467.4054)
,p_parent_id=>wwv_flow_api.id(138018800392611865.4054)
,p_short_name=>'Crea tema pubblico'
,p_link=>'f?p=&FLOW_ID.:58:&SESSION.'
,p_page_id=>58
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(141532803754060382.4054)
,p_parent_id=>wwv_flow_api.id(254193629012291915.4054)
,p_short_name=>'Dettagli applicazione'
,p_link=>'f?p=&APP_ID.:60:&SESSION.::&DEBUG.:::'
,p_page_id=>60
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(141709314755230984.4054)
,p_parent_id=>wwv_flow_api.id(47636522749932000.4054)
,p_short_name=>'Modifica schema'
,p_link=>'f?p=&APP_ID.:136:&SESSION.'
,p_page_id=>136
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(155227327828557571.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Grafico utilizzo componenti nativi'
,p_link=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.:::'
,p_page_id=>102
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(155371253393130044.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Report utilizzo componenti nativi'
,p_link=>'f?p=&APP_ID.:140:&SESSION.'
,p_page_id=>140
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(161279124919280651.4054)
,p_parent_id=>wwv_flow_api.id(19718719669530547.4054)
,p_short_name=>'Modifica assegnazione schema ad area di lavoro'
,p_link=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:::'
,p_page_id=>20
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(161577505898240777.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Log eliminazione file automatica'
,p_link=>'f?p=&FLOW_ID.:124:&SESSION.'
,p_page_id=>124
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(162274419076104279.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>unistr('Archivia log attivit\00E0')
,p_link=>'f?p=&FLOW_ID.:34:&SESSION.'
,p_page_id=>34
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(168488515060465304.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Utilizzo file per area di lavoro'
,p_link=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.:::'
,p_page_id=>39
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(168496516199569448.4054)
,p_parent_id=>wwv_flow_api.id(4586800042158416.4054)
,p_short_name=>'Gestisci istanza'
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(168519007394879035.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Dashboard'
,p_link=>'f?p=&FLOW_ID.:40:&SESSION.'
,p_page_id=>40
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(168811125378155218.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Messaggio di login'
,p_link=>'f?p=&FLOW_ID.:41:&SESSION.'
,p_page_id=>41
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(173287416442781913.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>unistr('Disponibilit\00E0 componente')
,p_link=>'f?p=&APP_ID.:52:&SESSION.::&DEBUG.:::'
,p_page_id=>52
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(173291712511844438.4054)
,p_parent_id=>wwv_flow_api.id(173287416442781913.4054)
,p_short_name=>'Impostazioni area di lavoro'
,p_link=>'f?p=&APP_ID.:59:&SESSION.::&DEBUG.:::'
,p_page_id=>59
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(184032326132147079.4054)
,p_parent_id=>wwv_flow_api.id(29817826940342994.4054)
,p_short_name=>'Posta elettronica'
,p_link=>'f?p=&FLOW_ID.:76:&SESSION.'
,p_page_id=>76
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(201319721952457221.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>unistr('Attivit\00E0 per giorno')
,p_link=>'f?p=&APP_ID.:68:&SESSION.::&DEBUG.:::'
,p_page_id=>68
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(201371611286583623.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>unistr('Attivit\00E0 per applicazione per giorno')
,p_link=>'f?p=&APP_ID.:77:&SESSION.::&DEBUG.:::'
,p_page_id=>77
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(201377704576617189.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>unistr('Attivit\00E0 per area di lavoro')
,p_link=>'f?p=&APP_ID.:80:&SESSION.::&DEBUG.:::'
,p_page_id=>80
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(201525025478711489.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Traduzioni installate'
,p_link=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::'
,p_page_id=>100
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(203154703095491475.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>unistr('Crea pi\00F9 aree di lavoro')
,p_link=>'f?p=&APP_ID.:115:&SESSION.::&DEBUG.:::'
,p_page_id=>115
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(204695329206748522.4054)
,p_parent_id=>wwv_flow_api.id(204699118900792039.4054)
,p_short_name=>'Modifica richiesta di fornitura area di lavoro'
,p_link=>'f?p=&APP_ID.:118:&SESSION.::&DEBUG.:::'
,p_page_id=>118
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(204698620127790065.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>unistr('Crea pi\00F9 aree di lavoro')
,p_link=>'f?p=&FLOW_ID.:117:&SESSION.'
,p_page_id=>117
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(204699118900792039.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>unistr('Crea pi\00F9 aree di lavoro')
,p_link=>'f?p=&FLOW_ID.:116:&SESSION.'
,p_page_id=>116
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(217657129689347489.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Gestisci intervallo di log'
,p_link=>'f?p=&APP_ID.:119:&SESSION.::&DEBUG.:::'
,p_page_id=>119
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(219091801243391095.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Hash applicazione per giorno'
,p_link=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.:RP::'
,p_page_id=>141
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(244316400794845905.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Stato di creazione'
,p_link=>'f?p=&APP_ID.:400:&SESSION.::&DEBUG.:::'
,p_page_id=>400
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(244555324646941283.4054)
,p_parent_id=>wwv_flow_api.id(244316400794845905.4054)
,p_short_name=>'Modifica stato di creazione'
,p_link=>'f?p=&FLOW_ID.:4001:&SESSION.'
,p_page_id=>4001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(244644212695071158.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Schemi di analisi'
,p_link=>'f?p=&APP_ID.:401:&SESSION.::&DEBUG.:::'
,p_page_id=>401
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(244652210402079945.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Attributi applicazione'
,p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(254193629012291915.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>unistr('Applicazioni di produttivit\00E0 e di esempio')
,p_link=>'f?p=&APP_ID.:104:&SESSION.::&DEBUG.:::'
,p_page_id=>104
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(256284005259887998.4054)
,p_parent_id=>wwv_flow_api.id(257504219172613037.4054)
,p_short_name=>'Dettagli log'
,p_link=>'f?p=&APP_ID.:127:&SESSION.::&DEBUG.:::'
,p_page_id=>127
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(257504219172613037.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>unistr('Installazioni di applicazioni di produttivit\00E0 e di esempio')
,p_link=>'f?p=&APP_ID.:128:&SESSION.::&DEBUG.:::'
,p_page_id=>128
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(274120800045824670.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Sottoscrizioni a report interattivo'
,p_link=>'f?p=&FLOW_ID.:129:&SESSION.'
,p_page_id=>129
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(284066358933239262.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Job di caricamento dati'
,p_link=>'f?p=&FLOW_ID.:144:&SESSION.'
,p_page_id=>144
);
end;
/
begin
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(388179526938368968.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>unistr('Crea pi\00F9 aree di lavoro')
,p_link=>'f?p=&APP_ID.:135:&SESSION.'
,p_page_id=>135
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(491859103758196049.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Eventi di pagina per giorno'
,p_link=>'f?p=&APP_ID.:86:&SESSION.::&DEBUG.:::'
,p_page_id=>86
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(499049929999448400.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Impostazioni rimozione aree di lavoro'
,p_link=>'f?p=&APP_ID.:133:&SESSION.::&DEBUG.:::'
,p_page_id=>133
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(505832201115288634.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Aree di lavoro inattive'
,p_link=>'f?p=&APP_ID.:87:&SESSION.::&DEBUG.:::'
,p_page_id=>87
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(505837505674514394.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Aree di lavoro rimosse'
,p_link=>'f?p=&APP_ID.:91:&SESSION.::&DEBUG.:::'
,p_page_id=>91
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(505839217307524193.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Aree di lavoro che sono diventate attive'
,p_link=>'f?p=&APP_ID.:92:&SESSION.::&DEBUG.:::'
,p_page_id=>92
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(505845507756604641.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Log rimozione aree di lavoro'
,p_link=>'f?p=&APP_ID.:98:&SESSION.::&DEBUG.:::'
,p_page_id=>98
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(505847206006635779.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Dashboard rimozione aree di lavoro'
,p_link=>'f?p=&APP_ID.:99:&SESSION.::&DEBUG.:::'
,p_page_id=>99
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(517854087351872839.4054)
,p_parent_id=>wwv_flow_api.id(254193629012291915.4054)
,p_short_name=>'Categorie'
,p_link=>'f?p=&FLOW_ID.:125:&SESSION.'
,p_page_id=>125
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(517956001437081463.4054)
,p_parent_id=>wwv_flow_api.id(517854087351872839.4054)
,p_short_name=>'Dettagli categoria'
,p_link=>'f?p=&APP_ID.:134:&SESSION.::&DEBUG.:::'
,p_page_id=>134
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(523373167257677873.4054)
,p_parent_id=>wwv_flow_api.id(141532803754060382.4054)
,p_short_name=>'Immagine applicazione'
,p_link=>'f?p=&FLOW_ID.:126:&SESSION.'
,p_page_id=>126
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(524767132718077538.4054)
,p_parent_id=>wwv_flow_api.id(525071413296326430.4054)
,p_short_name=>'Cache aree di lavoro'
,p_link=>'f?p=&APP_ID.:148:&SESSION.::&DEBUG.:::'
,p_page_id=>148
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(524799538487232706.4054)
,p_parent_id=>wwv_flow_api.id(524767132718077538.4054)
,p_short_name=>' Cache colonne tabella'
,p_link=>'f?p=&APP_ID.:149:&SESSION.::&DEBUG.:::'
,p_page_id=>149
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(525071413296326430.4054)
,p_parent_id=>wwv_flow_api.id(6052324602932730.4054)
,p_short_name=>'Cache dizionario dati'
,p_link=>'f?p=&APP_ID.:150:&SESSION.::&DEBUG.:::'
,p_page_id=>150
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(619289932752143228.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Job'
,p_link=>'f?p=&APP_ID.:122:&SESSION.::&DEBUG.:::'
,p_page_id=>122
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(619327423899379390.4054)
,p_parent_id=>wwv_flow_api.id(619289932752143228.4054)
,p_short_name=>'Dettagli job'
,p_link=>'f?p=&FLOW_ID.:123:&SESSION.'
,p_page_id=>123
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(619970453087121945.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>unistr('Log di attivit\00E0 Web Service')
,p_link=>'f?p=&APP_ID.:101:&SESSION.'
,p_page_id=>101
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(620805257997072192.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>unistr('Gestisci log di attivit\00E0 Web Service')
,p_link=>'f?p=&APP_ID.:139:&SESSION.::&DEBUG.:::'
,p_page_id=>139
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(629290306954602539.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Aree di lavoro attive per giorno'
,p_link=>'f?p=&APP_ID.:93:&SESSION.::&DEBUG.:::'
,p_page_id=>93
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(671302864762527341.4054)
,p_parent_id=>wwv_flow_api.id(254193629012291915.4054)
,p_short_name=>'Elimina applicazione'
,p_link=>'f?p=&APP_ID.:97:&SESSION.::&DEBUG.:::'
,p_page_id=>97
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(799823828864286581.4054)
,p_parent_id=>wwv_flow_api.id(168496516199569448.4054)
,p_short_name=>'Sicurezza'
,p_link=>'f?p=&FLOW_ID.:95:&SESSION.'
,p_page_id=>95
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(799824316355292355.4054)
,p_parent_id=>wwv_flow_api.id(799823828864286581.4054)
,p_short_name=>'URL autorizzato'
,p_link=>'f?p=&FLOW_ID.:96:&SESSION.'
,p_page_id=>96
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(879929448434711077.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>unistr('Attivit\00E0 per area di lavoro')
,p_link=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:::'
,p_page_id=>32
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(880163125476291015.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>unistr('Attivit\00E0 per applicazione')
,p_link=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:::'
,p_page_id=>50
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(880595981114924695.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Prime applicazioni'
,p_link=>'f?p=&APP_ID.:71:&SESSION.::&DEBUG.:::'
,p_page_id=>71
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(880632289691302686.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Prime aree di lavoro'
,p_link=>'f?p=&APP_ID.:137:&SESSION.::&DEBUG.:::'
,p_page_id=>137
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(880634492387323345.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>unistr('Riepilogo attivit\00E0')
,p_link=>'f?p=&APP_ID.:138:&SESSION.::&DEBUG.:::'
,p_page_id=>138
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(880730872948778541.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>unistr('Installazioni di applicazioni di produttivit\00E0 e di esempio')
,p_link=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.:::'
,p_page_id=>143
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1813869716370998260.4054)
,p_parent_id=>wwv_flow_api.id(4617723690278867.4054)
,p_short_name=>'Visualizzazioni di pagina per utente per giorno'
,p_link=>'f?p=&APP_ID.:94:&SESSION.'
,p_page_id=>94
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_0_left_and_right_sidebars_from_4999
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(12930201930057128.4054)
,p_theme_id=>3
,p_name=>'APEX 4.0 (Left And Right SideBars) From 4999.it'
,p_internal_name=>'APEX_4.0_LEFT_AND_RIGHT_SIDEBARS_FROM_4999'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div id="apex-main">',
'    <div id="ContentBody">',
'      <div id="apex-two-col">',
'        <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'        <div id="apex-content">#REGION_POSITION_02#',
'          <div id="apex-splash">',
'            <div id="RP4">#REGION_POSITION_04#</div>',
'            <div id="BB">#BODY#</div>',
'          </div>',
'        </div>',
'      </div>',
'    </div>',
'    <div id="apex-left-sidebar">#REGION_POSITION_01#</div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>16
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>18525205721780073.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_0_right_sidebar_from_4999
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(19236405723931959.4054)
,p_theme_id=>3
,p_name=>'APEX 4.0 (Right SideBar) From 4999.it'
,p_internal_name=>'APEX_4.0_RIGHT_SIDEBAR_FROM_4999'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <table id="apex-page-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'      <tbody>',
'        <tr>',
'          <td class="apex-page-content" width="100%">',
'            #REGION_POSITION_02#',
'            <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>	    ',
'	      </td>',
'          <td class="apex-page-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</td>     ',
'        </tr>',
'      </tbody>',
'    </table>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>18525411970780075.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/page/popup_info
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(20939016234587158.4054)
,p_theme_id=>3
,p_name=>'Popup Info.it'
,p_internal_name=>'POPUP_INFO'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'    <title>#TITLE#</title>',
'    <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'    ',
'    #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="aPopupPage">',
'    <noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>#REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##BODY#</div>',
'<div style="text-align:middle;">#REGION_POSITION_08#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>19940022257958945.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_no_sidebar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(192017709242711618.4054)
,p_theme_id=>3
,p_name=>'APEX 4.2 - No SideBar.it'
,p_internal_name=>'APEX_4.2_NO_SIDEBAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-content">#REGION_POSITION_02#',
'      <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion failRegion #REGION_CSS_CLASSES#" id="ERROR">',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    <p><strong>#MESSAGE#</strong></p>',
'    #ADDITIONAL_INFO#',
'    #TECHNICAL_INFO#',
'  </div>',
'  <span class="aButtonContainer">',
'    <button onclick="#BACK_LINK#" class="aButton hotButton"><span>#RETURN_TO_APPLICATION#</span></button>',
'  </span>',
'</section>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>187453329378870285.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_wizard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(202661821547388652.4054)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Wizard .it'
,p_internal_name=>'APEX_4.2_WIZARD_'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="aWizard">',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'<div class="wizardOuterContainer">',
'#REGION_POSITION_01#',
'<div class="wizardContainer">',
'    <h1 class="visuallyhidden">#TITLE#</h1>',
'    #REGION_POSITION_03#',
'    #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="wizardBody">',
'    #BODY#',
'    #REGION_POSITION_04#',
'    #REGION_POSITION_05#',
'  </div>',
'</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'<script>',
'function loadWizardTrain() {',
'	var currentStep = $("li.current,li.first-current,li.last-current",''div.wizardProgress'');',
'	if (currentStep.prev().length > 0) {',
'		currentStep.prevAll().find(''span'').addClass("pastCurrent");',
'	}',
'}',
'$(document).ready(function(){',
'loadWizardTrain();',
'})',
'</script>',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aWizardMessage successMessage" id="aSuccessMessage" role="alert">',
'  <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'  <a href="javascript:void(0)" onclick="$x_Remove(''aSuccessMessage'')" class="aCloseNotification"><span class="visuallyhidden">#CLOSE_NOTIFICATION#</span></a>',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aWizardMessage errorMessage" id="aErrorMessage" role="alert">',
'  <a href="javascript:void(0)" onclick="$x_Remove(''aErrorMessage'')" class="aCloseNotification"><span class="visuallyhidden">#CLOSE_NOTIFICATION#</span></a>',
'  <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'  #MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>16
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>42231511193339128.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(254111717898955159.4054)
,p_theme_id=>3
,p_name=>'APEX 4.2 - Edit Screen.it'
,p_internal_name=>'APEX_4.2_EDIT_SCREEN'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-two-col">',
'      <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-edit-screen">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>244139901565747496.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_0_optional_right_sidebar_table
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(472570002519580607.4054)
,p_theme_id=>3
,p_name=>'APEX 4.0 - Optional Right Sidebar (Table).it'
,p_internal_name=>'APEX_4.0_OPTIONAL_RIGHT_SIDEBAR_TABLE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <table id="apex-page-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'      <tbody>',
'        <tr>',
'          <td class="apex-page-content" width="100%">',
'            #REGION_POSITION_02#',
'            <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>	    ',
'	      </td>',
'          <td class="apex-page-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</td>     ',
'        </tr>',
'      </tbody>',
'    </table>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>450655205700156564.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(517336519765126407.4054)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Right Side Bar.it'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222.4054
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898412819287603153.4054)
,p_page_template_id=>wwv_flow_api.id(517336519765126407.4054)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898412996126603154.4054)
,p_page_template_id=>wwv_flow_api.id(517336519765126407.4054)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898413063612603154.4054)
,p_page_template_id=>wwv_flow_api.id(517336519765126407.4054)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898413155205603154.4054)
,p_page_template_id=>wwv_flow_api.id(517336519765126407.4054)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898413294817603154.4054)
,p_page_template_id=>wwv_flow_api.id(517336519765126407.4054)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898413367423603154.4054)
,p_page_template_id=>wwv_flow_api.id(517336519765126407.4054)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898413408026603154.4054)
,p_page_template_id=>wwv_flow_api.id(517336519765126407.4054)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(704456563630760825.4054)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Edit Screen.it'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4054
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898413599639603154.4054)
,p_page_template_id=>wwv_flow_api.id(704456563630760825.4054)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898413688332603154.4054)
,p_page_template_id=>wwv_flow_api.id(704456563630760825.4054)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(721098050798687927.4054)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog.it'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(721098416706687971.4054)
,p_theme_id=>3
,p_name=>'APEX 5.0 - No Side Bar.it'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(721099117305687972.4054)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard.it'
,p_internal_name=>'APEX_5.0_WIZARD'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477.4054
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898412455616603153.4054)
,p_page_template_id=>wwv_flow_api.id(721099117305687972.4054)
,p_name=>'Wizard Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898412520151603153.4054)
,p_page_template_id=>wwv_flow_api.id(721099117305687972.4054)
,p_name=>'Wizard Progress List'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898412622980603153.4054)
,p_page_template_id=>wwv_flow_api.id(721099117305687972.4054)
,p_name=>'Wizard Title'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898412708480603153.4054)
,p_page_template_id=>wwv_flow_api.id(721099117305687972.4054)
,p_name=>'Wizard Buttons'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(721103220819687982.4054)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Dialog.it'
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.builder.initWizardModal();',
'apex.builder.initWizardProgressBar();'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7]><html class="no-js lt-ie10 lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7]><html class="no-js lt-ie10 lt-ie9 lt-ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8]><html class="no-js lt-ie10 lt-ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9]><html class="no-js lt-ie10" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if gt IE 9]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'',
'<head>',
'',
'  <meta charset="utf-8">  ',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'#TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'#PAGE_CSS#',
'',
'    ',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'    ',
'    ',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--wizard'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689061037088924910.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_image_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(3791713542864.4054)
,p_template_name=>'HTML image (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_IMAGE_LEGACY_APEX_5_MIGRATION'
,p_template=>'<a href="#LINK#" id="#BUTTON_ID#" title="#LABEL!ATTR#"><img src="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" border="#" #BUTTON_ATTRIBUTES# /></a>'
,p_hot_template=>'<a href="#LINK#" id="#BUTTON_ID#" title="#LABEL!ATTR#"><img src="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" border="#" #BUTTON_ATTRIBUTES# /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_icon_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(202619211737261364.4054)
,p_template_name=>'APEX 4.2 - Icon Button'
,p_internal_name=>'APEX_4.2_ICON_BUTTON'
,p_template=>'<a href="#LINK#" class="aIconButton" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES# role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" /></a>'
,p_hot_template=>'<a href="#LINK#" class="aIconButton" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES# role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" /></a>'
,p_reference_id=>46198532248154431.4054
,p_translate_this_template=>'N'
,p_theme_class_id=>0
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="xpbutton" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tbody class="FFFFFF">',
'<tr>',
'<td class="L" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'<td class="C"><a href="#LINK#">#LABEL#</a></td>',
'<td class="R" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'</tr>',
'</tbody>',
'</table>'))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_next_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(202619414551261366.4054)
,p_template_name=>'APEX 4.2 - Next Button'
,p_internal_name=>'APEX_4.2_NEXT_BUTTON'
,p_template=>'<button class="aButton nextButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" class="nextBlack" alt=""/></span></button>'
,p_hot_template=>'<button class="aButton hotButton nextButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" class="nextWhite" alt=""/></span></button>'
,p_reference_id=>40780910892272674.4054
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_2_previous_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(202619726455261367.4054)
,p_template_name=>'APEX 4.2 - Previous Button'
,p_internal_name=>'APEX_4.2_PREVIOUS_BUTTON'
,p_template=>'<button title="#LABEL!ATTR#" class="aButton prevButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevBlack" alt="#LABEL!ATTR#" /></span></button>'
,p_hot_template=>'<button title="#LABEL!ATTR#" class="aButton hotButton prevButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevWhite" alt="#LABEL!ATTR#" /></span></button>'
,p_reference_id=>40781222929295107.4054
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_1_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(296326723097791037.4054)
,p_template_name=>'APEX 4.1 - Button'
,p_internal_name=>'APEX_4.1_BUTTON'
,p_template=>'<button class="aButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_hot_template=>'<button class="aButton hotButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_reference_id=>275775519061831382.4054
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="button-gray" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> ',
'',
'',
'<a href="#LINK#" class="button-orange" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> '))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_0_next_gray_bg
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(504434004298772014.4054)
,p_template_name=>'APEX 4.0 - Next (gray bg)'
,p_internal_name=>'APEX_4.0_NEXT_GRAY_BG'
,p_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton nextButton rightPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="nextBlack" alt="#LABEL!ATTR#" /></span></but'
||'ton> '
,p_hot_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton hotButton nextButton rightPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="nextWhite" alt="#LABEL!ATTR#" /></'
||'span></button> '
,p_reference_id=>430240008284905073.4054
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_0_previous_gray_bg
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(504434222085772019.4054)
,p_template_name=>'APEX 4.0 - Previous (gray bg)'
,p_internal_name=>'APEX_4.0_PREVIOUS_GRAY_BG'
,p_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton prevButton leftPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevBlack" alt="#LABEL!ATTR#" /></span></butt'
||'on>'
,p_hot_template=>'<button onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" class="aButton hotButton prevButton leftPill #BUTTON_CSS_CLASSES#" title="#LABEL!ATTR#" type="button"><span><img src="#IMAGE_PREFIX#f_spacer.gif" class="prevWhite" alt="#LABEL!ATTR#" /></s'
||'pan></button>'
,p_reference_id=>430240500796912446.4054
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(517372214551202759.4054)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4054
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(517372670814202760.4054)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233.4054
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(517372928661202760.4054)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4054
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(517373248988202760.4054)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4054
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_button_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(517849275695867600.4054)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_BUTTON_LEGACY_APEX_5_MIGRATION'
,p_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/hide_and_show_region_2
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24425502725250282.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title"><h3>',
'      <a href="#" onclick="htmldb_ToggleTableBody(''i#REGION_STATIC_ID#'',''body#REGION_STATIC_ID#''); return false;">',
'        <img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" class="pseudoButtonActive" id="i#REGION_STATIC_ID#" alt="" />',
'        #TITLE#',
'      </a></h3>    ',
'    </div>',
'  </div>',
'  <div class="hide-show-body" style="display:none;" id="body#REGION_STATIC_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Hide and Show Region (2)'
,p_internal_name=>'HIDE_AND_SHOW_REGION_2'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>106535103160611208.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_large_content
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(29320203159835418.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 Rounded Corner Large  (Content)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_LARGE_CONTENT'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>27763613494297374.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_small
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(29321105756835436.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 Rounded Corner Small'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_SMALL'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>26881811222918187.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_message_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(29446610665366048.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-SystemMessage #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Message Region'
,p_internal_name=>'APEX_5.0_MESSAGE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>29333927116050844.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(29794925290987920.4054)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 Div  with ID (c:htmldbHID)'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>245224629509817478.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_small_gray_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(46791917808357778.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Small (Gray Top)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_SMALL_GRAY_TOP'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>32612420016685806.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_c_htmldbhid_002
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(47529013609325628.4054)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div  with ID (c:htmldbHID)'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>245224629509817478.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(47530423486325747.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar '
,p_internal_name=>'APEX_4.0_TOP_BAR_'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17357218626599946.4054
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_float_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(47565030313994649.4054)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# style="float:left;clear:both;">#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div (Float Left)'
,p_internal_name=>'APEX_4.0_DIV_FLOAT_LEFT'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>35964702876463547.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(75821319588166981.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" style="width:100%">',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title"><h2>#TITLE#</h2></div>',
'    <div class="rc-buttons">#EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Report Region'
,p_internal_name=>'REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>17354512447599941.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/info_c_htmldbinfo_from_4999
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(79623830123907946.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Info (c:htmldbInfo)  From 4999'
,p_internal_name=>'INFO_C:HTMLDBINFO_FROM_4999'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/titleless_and_borderless
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(102441323786892882.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" style="width:100%">',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title"><h2>#TITLE#</h2></div>',
'    <div class="rc-buttons">#EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'titleless and borderless'
,p_internal_name=>'TITLELESS_AND_BORDERLESS'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>17354512447599941.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/loading_region_hidden_by_default
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(120649317132520102.4054)
,p_layout=>'TABLE'
,p_template=>'<div class="htmldbLoadingRegion" id="#REGION_STATIC_ID#" style="display:none;">#BODY#<br /><img src="#IMAGE_PREFIX#htmldb/icons/wait.gif"  id="loadingIcon" alt="" /></div>'
,p_page_plug_template_name=>'Loading Region (Hidden by Default)'
,p_internal_name=>'LOADING_REGION_HIDDEN_BY_DEFAULT'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>227227325128090607.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/graybox_no_top_link
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(159419508372158325.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading editRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'gray-box (no top link)'
,p_internal_name=>'GRAYBOX_NO_TOP_LINK'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17352808493599936.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box_success
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(160718619893151437.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion successRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box (Success)'
,p_internal_name=>'WIZARD_BOX_SUCCESS'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>149030901078827666.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box_confirm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(162417015526175958.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box (Confirm)'
,p_internal_name=>'WIZARD_BOX_CONFIRM'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(195768826832737518.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar (Gray Header)'
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(195775112470763477.4054)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #COMPONENT_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Page Anchors'
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17354206769599941.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(195777031029763479.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box'
,p_internal_name=>'APEX_4.0_WIZARD_BOX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box_800px
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(195777618558763486.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-wiz-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# style="width:100%;">',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title"><h2>#TITLE#</h2></div>',
'    <div class="rc-buttons">#CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box (800px)'
,p_internal_name=>'APEX_4.0_WIZARD_BOX_800PX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>35936104232216540.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_action_box
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(202652905551384773.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Action Box'
,p_internal_name=>'APEX_4.2_ACTION_BOX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_action_box_confirm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(202653318365384775.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Action Box (Confirm)'
,p_internal_name=>'APEX_4.2_ACTION_BOX_CONFIRM'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(202653921804384775.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body'
,p_internal_name=>'APEX_4.2_WIZARD_BODY'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209615589242480.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body_divider
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(202654431224384775.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion dividerTop" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'<div class="wizardRegionHeading">',
'  <h1>#TITLE#</h1>',
'  <div class="buttonContainer">',
'#EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'  </div>',
'</div>',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body (Divider)'
,p_internal_name=>'APEX_4.2_WIZARD_BODY_DIVIDER'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209811475242480.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(202654901374384775.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion dividerTop" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_4.2_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210116661242480.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_buttons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(202655418716384775.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardButtonsContainer" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="leftButtons">',
'    #PREVIOUS##DELETE##CHANGE##CLOSE#',
'  </div>',
'  <div class="rightButtons">',
'    #EDIT##CREATE##NEXT#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Buttons'
,p_internal_name=>'APEX_4.2_WIZARD_BUTTONS'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210411889242480.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box_confirm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(203640520174520127.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Wizard Box (Confirm)'
,p_internal_name=>'APEX_4.0_WIZARD_BOX_CONFIRM'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/copy_of_apex_4_2_edit_region_gray_box_c_htmldbgbr_100
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(254125117493020184.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading editRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'      <a href="#" class="aIconButton" onclick="uF();return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" class="upIcon" alt="&TOP." /></a>',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Copy of APEX 4.2 - Edit Region - Gray Box (c:htmldbGBR) (100%)'
,p_internal_name=>'COPY_OF_APEX_4.2_EDIT_REGION_GRAY_BOX_C:HTMLDBGBR_100%'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17353903289599940.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_navigation
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(466735715814370929.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion sideNavRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar Navigation'
,p_internal_name=>'APEX_4.0_SIDEBAR_NAVIGATION'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>456726627253419549.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/hide_and_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(472643325100618624.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title"><h3>',
'      <a href="#" onclick="htmldb_ToggleTableBody(''i#REGION_STATIC_ID#'',''body#REGION_STATIC_ID#''); return false;">',
'        <img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" class="pseudoButtonActive" id="i#REGION_STATIC_ID#" alt="" />',
'        #TITLE#',
'      </a></h3>    ',
'    </div>',
'  </div>',
'  <div class="hide-show-body" style="display:none;" id="body#REGION_STATIC_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Hide and Show Region'
,p_internal_name=>'HIDE_AND_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18662712241194598.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_large_blue
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(484944923953702457.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Large (Blue)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_LARGE_BLUE'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>27763613494297374.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(517376500704206647.4054)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>716895227337398760.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(517418631967368160.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174748721787471587.4054
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_top_buttons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(517418935080368162.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--left">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--right">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region (Top Buttons)'
,p_internal_name=>'APEX_5.0_REGION_TOP_BUTTONS'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174747104640428780.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(721110277025730268.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>687153470345619376.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(721115784857730284.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'      <button class="a-Button a-Button--icon a-Button--hideShow" type="button"></button>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>689955986849128825.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(721125879764730304.4054)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(721128767486730308.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(721129403626730309.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardHeader" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Header'
,p_internal_name=>'APEX_5.0_WIZARD_HEADER'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210710875242480.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(721130166613730309.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Wizard-region a-Form #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Wizard-regionHeader">#REGION_HEADER#</div>',
'  <div class="a-Wizard-regionBody">#BODY#</div>',
'  <div class="a-Wizard-regionFooter">#REGION_FOOTER#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Region'
,p_internal_name=>'APEX_5.0_WIZARD_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>702777601713950915.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_title_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(721130822791730313.4054)
,p_layout=>'TABLE'
,p_template=>'<div class="#REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#><h1 class="a-Wizard-title">#TITLE#</h1></div>'
,p_page_plug_template_name=>'APEX 5.0 - Wizard Title Region'
,p_internal_name=>'APEX_5.0_WIZARD_TITLE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>703469000349150769.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(810047731426039801.4054)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div with ID and Region Attributes'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>2974803291668087.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(829706609080810173.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>746362351042209764.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(966388705490342505.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>698829239393878937.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_processing_spinner_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1150740889542098395.4054)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ProcessingRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <span class="u-Processing"><span class="u-Processing-spinner"></span></span>',
'  <div class="a-ProcessingRegion-title">#TITLE#</div>',
'  <div class="a-ProcessingRegion-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Processing Spinner Region'
,p_internal_name=>'APEX_5.0_PROCESSING_SPINNER_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>1147280303078953726.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_image_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(15441414872198826.4054)
,p_list_template_current=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_name=>'Simple Image List'
,p_internal_name=>'SIMPLE_IMAGE_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="listwithicon">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>32421627622986728.4054
,p_list_template_comment=>'<img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_large_icons_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(20308202747121796.4054)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX#f_spacer.gif" #IMAGE_ATTR# class="gi-Icon-#IMAGE#" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX#f_spacer.gif" #IMAGE_ATTR# class="gi-Icon-#IMAGE#" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_name=>'[EBA] Large Icons List'
,p_internal_name=>'[EBA]_LARGE_ICONS_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table class="ebaLargeIcons" width="100%" cellspacing="0" cellpadding="0" border="0" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_reference_id=>20148806760577112.4054
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/basic_unordered_list1
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(27525012681104508.4054)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'Basic Unordered List1'
,p_internal_name=>'BASIC_UNORDERED_LIST1'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/list/page_tab_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(40112922633318119.4054)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'Page Tab Navigation'
,p_internal_name=>'PAGE_TAB_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4054
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/horizontal_with_images
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(82702000896937873.4054)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="current">',
'  <div class="image">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" /></a>',
'  </div>',
'  <div class="label">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'  </div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="noncurrent">',
'  <div class="image">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" /></a>',
'  </div>',
'  <div class="label">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'  </div>',
'</div>'))
,p_list_template_name=>'horizontal with images'
,p_internal_name=>'HORIZONTAL_WITH_IMAGES'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="apex-list-horizontal">'
,p_list_template_after_rows=>'</div>'
,p_reference_id=>17386714276888490.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_region_tab_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(169533626431592276.4054)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 4.0 - Region Tab List'
,p_internal_name=>'APEX_4.0_REGION_TAB_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4054
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_standard_tabs_with_pull_down
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(192005124361583785.4054)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_name=>'APEX Standard Tabs with pull down'
,p_internal_name=>'APEX_STANDARD_TABS_WITH_PULL_DOWN'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div id="tabs" class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul id="S#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="aTabs dhtmlSubMenu pulldown-tabs" style="display:none;">',
''))
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_reference_id=>9651611091899590.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_side_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(202626814415270397.4054)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 4.2 - Side List'
,p_internal_name=>'APEX_4.2_SIDE_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_wizard_progress_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(202627300168270397.4054)
,p_list_template_current=>'<li class="#LIST_STATUS#"><span>#TEXT#</span></li>'
,p_list_template_noncurrent=>'<li class="#LIST_STATUS#"><span>#TEXT#</span></li>'
,p_list_template_name=>'APEX 4.2 - Wizard Progress Bar'
,p_internal_name=>'APEX_4.2_WIZARD_PROGRESS_BAR'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardProgress">',
'<ul>'))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'</div>'))
,p_reference_id=>42216127932260877.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(517380133540212757.4054)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(517380464558212757.4054)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(517410251255325302.4054)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508.4054
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(517410627877325303.4054)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(721136580461780231.4054)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060.4054
);
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(6897002870390711.4054)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report  from 4999'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003.4054
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(6897002870390711.4054)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_1_eba_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(20400705845449628.4054)
,p_row_template_name=>'APEX 4.1 [EBA] Standard Report'
,p_internal_name=>'APEX_4.1_[EBA]_STANDARD_REPORT'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#',
'<tr>',
'<td><table class="ebaStandardReport" cellspacing="0" cellpadding="0" summary="#REGION_TITLE#" width="100%">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table><div class="CSV">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="#LINK#" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="#LINK#" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="#LINK#" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="#LINK#" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>20327811817377113.4054
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(20400705845449628.4054)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/vertical_plain_c_htmldbverticalregion
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(22621917280199870.4054)
,p_row_template_name=>'Vertical Plain (c:htmldbVerticalRegion)'
,p_internal_name=>'VERTICAL_PLAIN_C:HTMLDBVERTICALREGION'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr>',
'<th scope="row" style="text-align:right;" align="right">#COLUMN_HEADER#</th>',
'<td width="100%">#COLUMN_VALUE#</td>',
'</tr>'))
,p_row_template_before_rows=>'#CSV_LINK#<table class="apex-vertical-region"  summary="#REGION_TITLE#" cellpadding="0" cellspacing="0" border="0">'
,p_row_template_after_rows=>'</table>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>82057303211040344.4054
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(22621917280199870.4054)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(46450823627307947.4054)
,p_row_template_name=>'APEX 4.0 - Portlet Report'
,p_internal_name=>'APEX_4.0_PORTLET_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(47555718632924155.4054)
,p_row_template_name=>'APEX 4.0 - Portlet Row Template'
,p_internal_name=>'APEX_4.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/2_dhtml_automatic_ppr_pagination_report_from_4999
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(81008210556197147.4054)
,p_row_template_name=>'(2) (DHTML) Automatic PPR Pagination Report From 4999 '
,p_internal_name=>'2_DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999_'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003.4054
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(81008210556197147.4054)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_named_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(805663950138677747.4054)
,p_row_template_name=>'APEX 5.0 - Badge List (Named Column)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_NAMED_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(805668813229677842.4054)
,p_row_template_name=>'APEX 5.0 - Badge List (Row)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
'  <span class="t-BadgeList-label">#1#</span>',
'  <span class="t-BadgeList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>6
,p_reference_id=>689060248369886348.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(805669497254677844.4054)
,p_row_template_name=>' APEX 5.0 - Links List'
,p_internal_name=>'_APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4054
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(805669497254677844.4054)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(805670753642677848.4054)
,p_row_template_name=>'APEX 5.0 - Portlet Column Template'
,p_internal_name=>'APEX_5.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(805671421026677848.4054)
,p_row_template_name=>'APEX 5.0 - Portlet Row Template'
,p_internal_name=>'APEX_5.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(805672157251677851.4054)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4054
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(805672157251677851.4054)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(833359513519625692.4054)
,p_row_template_name=>'APEX 4.0 - Standard Report'
,p_internal_name=>'APEX_4.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4054
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(833359513519625692.4054)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/label_tag_only
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(4925632660752163.4054)
,p_template_name=>'LABEL Tag Only'
,p_internal_name=>'LABEL_TAG_ONLY'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/form_field_optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(111843720754869910.4054)
,p_template_name=>'Form Field Optional'
,p_internal_name=>'FORM_FIELD_OPTIONAL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17388415351892041.4054
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/f_fromfield_required
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(111844628719872228.4054)
,p_template_name=>'f: FromField_Required'
,p_internal_name=>'F:_FROMFIELD_REQUIRED'
,p_template_body1=>'<em>*</em><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aRequired"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>' <span class="hideMeButHearMe">(#VALUE_REQUIRED#)</span></a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>2
,p_reference_id=>17388508175892042.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/dynamic_attribute
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(143266721929021448.4054)
,p_template_name=>'Dynamic Attribute'
,p_internal_name=>'DYNAMIC_ATTRIBUTE'
,p_template_body1=>'<em>*</em><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aRequired"><a href="javascript:apex.builder.dynamicAttributes.help(''&FB_FLOW_ID.'',''#CURRENT_ITEM_NAME#'');" tabindex="999">'
,p_template_body2=>' <span class="hideMeButHearMe">(#VALUE_REQUIRED#)</span></a></label>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>180457716461887221.4054
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/done_label_optional_no_link
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(148842116797733609.4054)
,p_template_name=>'(Done) Label Optional (No Link)'
,p_internal_name=>'DONE_LABEL_OPTIONAL_NO_LINK'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><span class="htmldbLabelOptional">'
,p_template_body2=>'</span></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>238114715839717766.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/htmldb_greenarealabel_c_htmldbgalabel
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(343399818250317904.4054)
,p_template_name=>'htmldb_GreenAreaLabel (c:htmldbGALabel)'
,p_internal_name=>'HTMLDB_GREENAREALABEL_C:HTMLDBGALABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(452952500586130526.4054)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(721133390982759781.4054)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487444299516703815.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(721133403814759785.4054)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492676964457041934.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(721133598269759785.4054)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487443659585685414.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(721133686751759785.4054)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492677038682043223.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_dynamic_attribute
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1405202261752384510.4054)
,p_template_name=>'APEX 5.0 - Dynamic Attribute'
,p_internal_name=>'APEX_5.0_DYNAMIC_ATTRIBUTE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-dynamicItemHelp" data-itemname="#CURRENT_ITEM_NAME#" data-appid="&FB_FLOW_ID." title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help"></span><span cl'
||'ass="u-VisuallyHidden">#CURRENT_ITEM_HELP_LABEL#</span></button>#ERROR_TEMPLATE#</div>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>692681574974429799.4054
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(4589126493175495.4054)
,p_name=>'breadcrumbs'
,p_internal_name=>'BREADCRUMBS'
,p_current_page_option=>'<span class="htmldbBreadcrumb">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#" class="htmldbBreadcrumb" title="#NAME#">#NAME#</a>'
,p_between_levels=>'<span class="htmldbBreadcrumbSep"><img alt="" src="#IMAGE_PREFIX#apex/apex_top_sep.gif"></span>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>60115300853820165.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(517472004210010979.4054)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>689285808648404711.4054
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(19619131469326417.4054)
,p_page_name=>'winlov'
,p_page_title=>'Finestra di dialogo di ricerca'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>'Cerca'
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>'Chiudi'
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>'Successivo &gt;'
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>'&lt; Precedente'
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>'<div class="a-PopupLOV-pagination">Righe #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17343114994581872.4054
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/htmldb_calendar_from_4350
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(291623505663181263.4054)
,p_cal_template_name=>'HTMLDB Calendar from 4350'
,p_internal_name=>'HTMLDB_CALENDAR_FROM_4350'
,p_day_of_week_format=>'<th scope="col" width="14%" class="htmldbDayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbCalendarHolder" cellpadding="0" cellspacing="0" border="0" width="100%" summary="" role="presentation"><tr>',
'<td class="htmldbMonthTitle">#IMONTH# #YYYY#</td>',
'</tr>',
'<tr><td>'))
,p_month_open_format=>'<table class="htmldbCalendar" cellpadding="0" cellspacing="3" border="0" width="100%" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td></tr></table>',
'',
''))
,p_day_title_format=>'<div class="htmldbDayTitle">#DD#</div>'
,p_day_open_format=>'<td class="htmldbDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="htmldbToday">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="htmldbWeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td class="htmldbWeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="htmldbNonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="htmldbNonDay">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>353925314576528967.4054
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(72330278206509731.4054)
,p_theme_id=>3
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(204023405870765307.4054)
,p_theme_id=>3
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689622957538993961.4054)
,p_theme_id=>3
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689623969329993963.4054)
,p_theme_id=>3
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689624693980993963.4054)
,p_theme_id=>3
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(689626529804993964.4054)
,p_theme_id=>3
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697060993016402983.4054)
,p_theme_id=>3
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697230396344708843.4054)
,p_theme_id=>3
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698684569822187813.4054)
,p_theme_id=>3
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698685246722187813.4054)
,p_theme_id=>3
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698685982234187814.4054)
,p_theme_id=>3
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698687551302187815.4054)
,p_theme_id=>3
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(721118031100730295.4054)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741002786712616811.4054)
,p_theme_id=>3
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741003546630616812.4054)
,p_theme_id=>3
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741003881511616812.4054)
,p_theme_id=>3
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741004108847616813.4054)
,p_theme_id=>3
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741004885396616813.4054)
,p_theme_id=>3
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741005111768616813.4054)
,p_theme_id=>3
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741005400644616813.4054)
,p_theme_id=>3
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741005709269616813.4054)
,p_theme_id=>3
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741006077738616813.4054)
,p_theme_id=>3
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741006441348616813.4054)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741006771182616813.4054)
,p_theme_id=>3
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(805664352602677797.4054)
,p_theme_id=>3
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(805665239190677809.4054)
,p_theme_id=>3
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(829707024511810176.4054)
,p_theme_id=>3
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1104606929671216232.4054)
,p_theme_id=>3
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741058941526941269.4054)
,p_theme_id=>3
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_api.id(741002786712616811)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741059100079941270.4054)
,p_theme_id=>3
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_api.id(741002786712616811)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741059383377941271.4054)
,p_theme_id=>3
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_api.id(741002786712616811)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741059547362941271.4054)
,p_theme_id=>3
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_api.id(741002786712616811)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741059767574941271.4054)
,p_theme_id=>3
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_api.id(741002786712616811)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741059963746941271.4054)
,p_theme_id=>3
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_api.id(741002786712616811)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741060150257941271.4054)
,p_theme_id=>3
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(741003546630616812)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741060352743941271.4054)
,p_theme_id=>3
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_api.id(741003881511616812)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741060562611941271.4054)
,p_theme_id=>3
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_api.id(741004108847616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741060777764941272.4054)
,p_theme_id=>3
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_api.id(741003881511616812)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741060923252941272.4054)
,p_theme_id=>3
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_api.id(741003881511616812)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741061147880941272.4054)
,p_theme_id=>3
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_api.id(741003881511616812)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741061355608941272.4054)
,p_theme_id=>3
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_api.id(741004108847616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741061562454941272.4054)
,p_theme_id=>3
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_api.id(741004885396616813)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741061785251941272.4054)
,p_theme_id=>3
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(741005111768616813)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741061930408941272.4054)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_api.id(741005400644616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741062140679941272.4054)
,p_theme_id=>3
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(741005709269616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741062374659941272.4054)
,p_theme_id=>3
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_api.id(741006077738616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741062572126941272.4054)
,p_theme_id=>3
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(741004108847616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741062777866941272.4054)
,p_theme_id=>3
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(741006441348616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741062993093941272.4054)
,p_theme_id=>3
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_api.id(741006771182616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741063041165941273.4054)
,p_theme_id=>3
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741063226712941273.4054)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_api.id(741005400644616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741063478339941273.4054)
,p_theme_id=>3
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_api.id(741005709269616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741063652736941273.4054)
,p_theme_id=>3
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_api.id(741006077738616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741063738666941273.4054)
,p_theme_id=>3
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(741063868051941273.4054)
,p_theme_id=>3
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787115814178949708.4054)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(833359513519625692.4054)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(698684569822187813)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787116053276949708.4054)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(833359513519625692.4054)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(698685246722187813)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787116272015949709.4054)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(833359513519625692.4054)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(698685982234187814)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787116463221949709.4054)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(833359513519625692.4054)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(698685982234187814)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787116655041949709.4054)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(833359513519625692.4054)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(698685982234187814)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787116768540949709.4054)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(833359513519625692.4054)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787116930836949713.4054)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(833359513519625692.4054)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(698687551302187815)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926398446964707528.4054)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(517380464558212757.4054)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926398552870707528.4054)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(517380464558212757.4054)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(940696902849341582.4054)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(721136580461780231.4054)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967652406149899654.4054)
,p_theme_id=>3
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721110277025730268.4054)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967652677759899654.4054)
,p_theme_id=>3
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721110277025730268.4054)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(689624693980993963)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967652870869899654.4054)
,p_theme_id=>3
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721110277025730268.4054)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(689624693980993963)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967653049020899654.4054)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721110277025730268.4054)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(689622957538993961)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967653251462899654.4054)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721110277025730268.4054)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(689622957538993961)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967653316877899654.4054)
,p_theme_id=>3
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721110277025730268.4054)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967653518578899654.4054)
,p_theme_id=>3
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721110277025730268.4054)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_api.id(697060993016402983)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967653745948899654.4054)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721110277025730268.4054)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_api.id(697060993016402983)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967654517211901036.4054)
,p_theme_id=>3
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_api.id(805664352602677797)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967654725307901036.4054)
,p_theme_id=>3
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(805664352602677797)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967654990742901036.4054)
,p_theme_id=>3
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(805664352602677797)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967655151651901036.4054)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_api.id(805665239190677809)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967655310868901036.4054)
,p_theme_id=>3
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(805665239190677809)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967655531082901036.4054)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_api.id(805665239190677809)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967655733265901036.4054)
,p_theme_id=>3
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(805665239190677809)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967655999997901036.4054)
,p_theme_id=>3
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(805665239190677809)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967656143487901036.4054)
,p_theme_id=>3
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(805664352602677797)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967656346981901036.4054)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(805664352602677797)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967656530819901037.4054)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(805664352602677797)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967656779856901037.4054)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(805664352602677797)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967656945340901037.4054)
,p_theme_id=>3
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805663950138677747.4054)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(805664352602677797)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967717343742903434.4054)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805672157251677851.4054)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(698684569822187813)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967717571202903434.4054)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805672157251677851.4054)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(698685246722187813)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967717740507903435.4054)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805672157251677851.4054)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(698685982234187814)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967717902448903435.4054)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805672157251677851.4054)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(698685982234187814)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967718196465903435.4054)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805672157251677851.4054)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(698685982234187814)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967718265262903435.4054)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805672157251677851.4054)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967718461294903435.4054)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805672157251677851.4054)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(698687551302187815)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967719843756911507.4054)
,p_theme_id=>3
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829706609080810173.4054)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967719965533911507.4054)
,p_theme_id=>3
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829706609080810173.4054)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967720120106911508.4054)
,p_theme_id=>3
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829706609080810173.4054)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_api.id(829707024511810176)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967720327654911509.4054)
,p_theme_id=>3
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829706609080810173.4054)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_api.id(829707024511810176)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967720583879911509.4054)
,p_theme_id=>3
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829706609080810173.4054)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_api.id(829707024511810176)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967720733358911509.4054)
,p_theme_id=>3
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829706609080810173.4054)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(721118031100730295)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967720959540911509.4054)
,p_theme_id=>3
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829706609080810173.4054)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_api.id(721118031100730295)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967721004874911509.4054)
,p_theme_id=>3
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829706609080810173.4054)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(967721285604911509.4054)
,p_theme_id=>3
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(829706609080810173.4054)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_api.id(829707024511810176)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1104608494214216242.4054)
,p_theme_id=>3
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(1104606929671216232)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1104608656046216242.4054)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(1104606929671216232)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1104608867454216242.4054)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(1104606929671216232)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1104609040571216242.4054)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(1104606929671216232)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1104609259667216242.4054)
,p_theme_id=>3
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(1104606929671216232)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1104609398533216242.4054)
,p_theme_id=>3
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1104609436927216242.4054)
,p_theme_id=>3
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1104609518065216242.4054)
,p_theme_id=>3
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1104609672179216242.4054)
,p_theme_id=>3
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1104609733068216242.4054)
,p_theme_id=>3
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1104606511149216228.4054)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1199562374089032433.4054)
,p_theme_id=>3
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(517372670814202760.4054)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(741006441348616813)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1241666318933396953.4054)
,p_theme_id=>3
,p_name=>'USED_IN_DIALOG'
,p_display_name=>'Used in Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1150740889542098395.4054)
,p_css_classes=>'a-ProcessingRegion--dialog'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525651284559182055.4054)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(202626814415270397.4054)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525651360640182055.4054)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(202626814415270397.4054)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525651434587182055.4054)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(202626814415270397.4054)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525651525816182055.4054)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(202626814415270397.4054)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525651779626182055.4054)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(202626814415270397.4054)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(697230396344708843)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525651978926182055.4054)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(202626814415270397.4054)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(697230396344708843)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525653392112182064.4054)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(27525012681104508.4054)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525653440648182064.4054)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(27525012681104508.4054)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525653596475182064.4054)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(27525012681104508.4054)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525653658347182064.4054)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(27525012681104508.4054)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525653836168182064.4054)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(27525012681104508.4054)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(697230396344708843)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525654036872182064.4054)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(27525012681104508.4054)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(697230396344708843)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525657387923182087.4054)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525657473823182087.4054)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525657543497182087.4054)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525657663628182087.4054)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525657833692182087.4054)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(697230396344708843)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525658090172182088.4054)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(697230396344708843)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544818255170478020.4054)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805669497254677844.4054)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544818366864478020.4054)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805669497254677844.4054)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544818490278478020.4054)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805669497254677844.4054)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554805829158408352.4054)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(697060993016402983)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554806001590408352.4054)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(697060993016402983)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554806241730408352.4054)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(689622957538993961)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554806417746408352.4054)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689622957538993961)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554806699208408352.4054)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(689623969329993963)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554806824411408353.4054)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(689624693980993963)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554807043080408353.4054)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689626529804993964)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554807217289408353.4054)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689626529804993964)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554807484461408353.4054)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(689622957538993961)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554807578586408353.4054)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554807728864408353.4054)
,p_theme_id=>3
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(517418631967368160.4054)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(689624693980993963)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554832646705526808.4054)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(721125879764730304.4054)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554832743576526808.4054)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721125879764730304.4054)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554832892239526808.4054)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721125879764730304.4054)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554844990556542270.4054)
,p_theme_id=>3
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721115784857730284.4054)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554845094082542270.4054)
,p_theme_id=>3
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721115784857730284.4054)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554845229074542270.4054)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721115784857730284.4054)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(689622957538993961)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554845436412542270.4054)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721115784857730284.4054)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689622957538993961)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554845665255542270.4054)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721115784857730284.4054)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(689623969329993963)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554845827258542271.4054)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721115784857730284.4054)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(689624693980993963)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554846022920542271.4054)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721115784857730284.4054)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689626529804993964)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554846298269542271.4054)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721115784857730284.4054)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689626529804993964)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554846416962542271.4054)
,p_theme_id=>3
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_api.id(721115784857730284.4054)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(721118031100730295)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554846634990542271.4054)
,p_theme_id=>3
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(721115784857730284.4054)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(721118031100730295)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554858103728550790.4054)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(966388705490342505.4054)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554858341380550790.4054)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(966388705490342505.4054)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(697060993016402983)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554858589140550790.4054)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(966388705490342505.4054)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(689626529804993964)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554858747894550790.4054)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(966388705490342505.4054)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(689624693980993963)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554858923710550790.4054)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(966388705490342505.4054)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(689622957538993961)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554859100162550790.4054)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(966388705490342505.4054)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(697060993016402983)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554859327262550790.4054)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(966388705490342505.4054)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(689622957538993961)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554859544487550790.4054)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(966388705490342505.4054)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(689626529804993964)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554859732911550790.4054)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(966388705490342505.4054)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(689623969329993963)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554859906782550790.4054)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(966388705490342505.4054)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(689622957538993961)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(1082456635473282144.4054)
,p_build_option_name=>'To Be Deleted'
,p_build_option_status=>'EXCLUDE'
,p_build_option_comment=>'Components which should be deleted once verified that it is safe to do so.'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(3913175260740993520.4054)
,p_build_option_name=>'Full Access Only'
,p_build_option_status=>'INCLUDE'
,p_on_upgrade_keep_status=>true
,p_build_option_comment=>'Elements marked with this build option are only to be available to a full (aka on-prem) release of apex.'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(4226407758971148501.4054)
,p_build_option_name=>'Exclude on 5.1.4'
,p_build_option_status=>'INCLUDE'
,p_build_option_comment=>'This build option is used to exclude changes to 5.1.4''s 4050 which were actually made for 5.2 or newer. We are actively developing in 5.1.4 and at some time importing the patchset''s 4050 into trunk.'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/mon_sessions
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(3410213449861369.4054)
,p_shortcut_name=>'MON_SESSIONS'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<table class="instructiontext" ><tr><td>&nbsp;</td><td><table class="instructiontext" bgcolor="#ffffff" cellspacing=0 cellpadding=0 border="1"><tr><td><a href="f?p=&FLOW_ID.:63:&SESSION."><img src="#IMAGE_PREFIX#monitor_icons_pipes.gif" width="100" h'
||'eight="75" border="0"></a><br/><span class="tiny">&nbsp;Menu&nbsp;sessione...</span></td></tr></table></td></tr></table>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/item_help
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(181820822914271039.4054)
,p_shortcut_name=>'ITEM_HELP'
,p_shortcut_type=>'HTML_TEXT'
,p_error_text=>'Impossibile visualizzare la Guida.'
,p_reference_id=>24184979678.4054
,p_shortcut=>'<a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999"><img src="#IMAGE_PREFIX#infoicon_status_gray.gif" width=16 height=16 border=0></a>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/mon_home
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(190225219130761917.4054)
,p_shortcut_name=>'MON_HOME'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<table><tr><td>&nbsp;</td><td><table bgcolor="#ffffff" cellspacing=0 cellpadding=0 border="1"><tr><td><a href="f?p=4050:29:&SESSION."><img src="#IMAGE_PREFIX#flow_monitor2.gif" width="100" height="75" border="0"></a><br><font size="-2" face="arial">M'
||'enu&nbsp;di controllo...</font></td></tr></table></td></tr></table>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/install_svg_plugin
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(277012116764271142.4054)
,p_shortcut_name=>'INSTALL_SVG_PLUGIN'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>'Installare SVG Viewer per visualizzare il grafico. <a href=''http://www.adobe.com/svg/viewer/install/main.html''>Fare clic qui per scaricare il programma.</a>'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(277511229763806315.4054)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>'Eseguire questa azione di eliminazione?'
);
end;
/
prompt --application/shared_components/security/authentications/social_sign_in
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(117701201325189372.4054)
,p_name=>'Social Sign-In'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_attribute_02=>'OPENID_CONNECT'
,p_attribute_03=>'https://accounts.example.com/.well-known/openid-configuration'
,p_attribute_07=>'profile'
,p_attribute_09=>'email'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_help_text=>'Questo schema utilizza OAuth2 con un provider di autenticazione di terze parti, come Oracle Identity Cloud Service.'
);
end;
/
prompt --application/shared_components/security/authentications/database_accounts
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(141712901769416420.4054)
,p_name=>'Database Accounts'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_help_text=>'Questo schema utilizza le credenziali del database. Per autenticare l''utente vengono utilizzati il nome utente e la password dell''account del database.'
);
end;
/
prompt --application/shared_components/security/authentications/application_express_accounts
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(142379011979648757.4054)
,p_name=>'Application Express Accounts'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Questo \00E8 lo schema di autenticazione predefinito.'),
'Gli utenti vengono autenticati rispetto al repository utenti dell''area di lavoro.'))
);
end;
/
prompt --application/shared_components/security/authentications/http_header_variable
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(142379504646652140.4054)
,p_name=>'HTTP Header Variable'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_attribute_01=>'OAM_REMOTE_USER'
,p_attribute_02=>'BUILTIN_URL'
,p_attribute_06=>'ALWAYS'
,p_invalid_session_type=>'URL'
,p_invalid_session_url=>'f?p=4550:20:&SESSION.:::SESSION'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Questo schema si base su una variabile di intestazione HTTP per contenere il nome utente e su un metodo di login esterno per l''esecuzione del login.',
'Application Express presenta le aree di lavoro disponibili per l''utente.'))
);
end;
/
prompt --application/shared_components/security/authentications/oracle_application_server_single_sign_on
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(155904925460322166.4054)
,p_name=>'Oracle Application Server Single Sign-On'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_invalid_session_type=>'URL'
,p_invalid_session_url=>'f?p=4550:20:&SESSION.:::SESSION'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Questo schema autentica gli sviluppatori con Oracle Single Sign-On,',
'utilizzando la pagina di login esterno di SSO.',
'Dopo l''autenticazione, Application Express presenta le aree di lavoro disponibili per l''utente.'))
);
end;
/
prompt --application/shared_components/security/authentications/oracle_cloud_identity_management
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(155905406697330949.4054)
,p_name=>'Oracle Cloud Identity Management'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
);
end;
/
prompt --application/shared_components/security/authentications/ldap_directory
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(156147800875761157.4054)
,p_name=>'LDAP Directory'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_attribute_01=>'ldap.example.com'
,p_attribute_03=>'NO_SSL'
,p_attribute_04=>'dc=example,dc=com'
,p_attribute_05=>'N'
,p_attribute_06=>'uid=%LDAP_USER%'
,p_attribute_08=>'STD'
,p_invalid_session_type=>'LOGIN'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_help_text=>'Questo schema verifica le credenziali rispetto a un repository LDAP.'
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(540226219724705040.4054)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>142379011979648757.4054
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_searchbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1900106178348190.4054)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.SEARCHBOX'
,p_display_name=>'Casella di ricerca'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.SEARCHBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_searchbox'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT'
,p_substitute_attributes=>true
,p_reference_id=>42609120788689442.4054
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513165269066230017.4054)
,p_plugin_id=>wwv_flow_api.id(1900106178348190.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Redirect URL'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:<target page>:&SESSION.::&DEBUG.::<target item>:'
,p_display_length=>80
,p_max_length=>4000
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513165627970230017.4054)
,p_plugin_id=>wwv_flow_api.id(1900106178348190.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Search Text'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Search'
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
''))
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(12523412714527909.4054)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>'Autorizzazione sviluppatore'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494.4054
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(786851261267512829.4054)
,p_plugin_id=>wwv_flow_api.id(12523412714527909.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786851695445512829.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786852128106512829.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786852694313512834.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786853117306512834.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786853625702512836.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786854173413512836.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786854692330512836.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786855152849512838.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786855645741512838.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786856172533512838.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786856695045512839.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786857103315512839.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(786851261267512829.4054)
,p_display_sequence=>120
,p_display_value=>'PKG_APPS: Ability to install packaged applications'
,p_return_value=>'PKG_APPS'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(113737019268347425.4054)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>'Account di Application Express INTERNAL'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(113749511183746276.4054)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>'Account di database INTERNAL'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(113749806821809026.4054)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>'Oracle Cloud Identity Management INTERNAL'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(113750429890071859.4054)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'Oracle Application Server Single Sign-On INTERNAL'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(117694777698093086.4054)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>'INTERNAL - Social Sign-In'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(117695687338118595.4054)
,p_plugin_id=>wwv_flow_api.id(117694777698093086.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(117695928229119805.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(117695687338118595.4054)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(117696352639120891.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(117695687338118595.4054)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(117696783335121519.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(117695687338118595.4054)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(117697164316122317.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(117695687338118595.4054)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(117697531642127596.4054)
,p_plugin_id=>wwv_flow_api.id(117694777698093086.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(117695687338118595.4054)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(117697833997131789.4054)
,p_plugin_id=>wwv_flow_api.id(117694777698093086.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(117695687338118595.4054)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(117698773594144445.4054)
,p_plugin_id=>wwv_flow_api.id(117694777698093086.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(117695687338118595.4054)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(117699026040147499.4054)
,p_plugin_id=>wwv_flow_api.id(117694777698093086.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(117695687338118595.4054)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(117699383669150422.4054)
,p_plugin_id=>wwv_flow_api.id(117694777698093086.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Application Express automatically adds the "openid" scope. The authent'
||'ication provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(117699669144153515.4054)
,p_plugin_id=>wwv_flow_api.id(117694777698093086.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(117699930798156032.4054)
,p_plugin_id=>wwv_flow_api.id(117694777698093086.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(117700266287158350.4054)
,p_plugin_id=>wwv_flow_api.id(117694777698093086.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118714805380694539.4054)
,p_plugin_id=>wwv_flow_api.id(117694777698093086.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Logout URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Use this attribute to specify a URL to log out from your authentication provider.',
'For <em>OpenID Connect</em>, &PRODUCT_NAME. automatically uses the <em>end_session</em> endpoint, if that is defined in the <em>Discovery URL</em>.',
'For others, you can use #ID_TOKEN# and #REDIRECT_URI# in the URL, to substitute the ID token that was returned when logging in and the full URL to /apex on your instance, e.g. https://www.example.com/apex/apex.',
'Note that the redirect URI often has to be registered with your authentication provider.'))
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_plugin_dynamic_attribute
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(143089423556992866.4054)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_display_name=>'Attributo dinamico plugin'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_plugin_attribute'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_plugin_attribute'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:SOURCE'
,p_substitute_attributes=>true
,p_reference_id=>6480508142096556.4054
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_clob_textarea
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(202899010831671075.4054)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.CLOB_TEXTAREA'
,p_display_name=>'Area di testo CLOB'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.CLOB_TEXTAREA'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_clob_textarea'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_clob_textarea'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:ELEMENT:WIDTH:HEIGHT'
,p_substitute_attributes=>false
,p_reference_id=>200125518386793215.4054
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513354065429479108.4054)
,p_plugin_id=>wwv_flow_api.id(202899010831671075.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'SQL or PL/SQL to get CLOB value'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>false
,p_display_length=>80
,p_sql_min_column_count=>1
,p_sql_max_column_count=>1
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'This item supports sql statements, like',
'<pre>',
'select big_data',
'from my_table',
'where id=:P4711_ID',
'</pre>',
'and function results, like',
'<pre>',
'return wwv_flow_xxx.get_big_data(p_id => :P4711_ID);',
'</pre>',
'to get a clob value for rendering.',
'',
'To write the data back, the CLOB Textarea makes an AJAX call before the actual page submit, which stores the clob value in wwv_flow_collections.clob001, with a collection name that equals the item name.',
'Developers can then define a page process that stores the clob value where it belongs, either directly',
'<pre>',
'update my_table',
'   set big_data = (select clob001',
'                     from wwv_flow_collections',
'                    where collection_name=''P4711_BIG_DATA'')',
' where id = :P4711_ID;',
'</pre>',
'or via the built-in function wwv_flow_f4000_plugins.get_clob_textarea_value:',
'',
'<pre>',
'update my_table',
'   set agreement_text = wwv_flow_f4000_plugins.get_clob_textarea_value(''P4711_BIG_DATA'')',
' where id = :P4711_ID;',
'</pre>',
''))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513354489442479109.4054)
,p_plugin_id=>wwv_flow_api.id(202899010831671075.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Textarea Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'HTML'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1513354853142479110.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(1513354489442479109.4054)
,p_display_sequence=>10
,p_display_value=>'HTML Textarea'
,p_return_value=>'HTML'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1513355308079479110.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(1513354489442479109.4054)
,p_display_sequence=>20
,p_display_value=>'Rich Text Editor'
,p_return_value=>'CKEDITOR-Full'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(708795120396802284.4054)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>'Variabile di intestazione HTTP INTERNAL'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(708802916025810450.4054)
,p_plugin_id=>wwv_flow_api.id(708795120396802284.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(708807203689816438.4054)
,p_plugin_id=>wwv_flow_api.id(708795120396802284.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(708811517195820338.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(708807203689816438.4054)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(708823430832833673.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(708807203689816438.4054)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(708843733040843771.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(708807203689816438.4054)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(708855521528859444.4054)
,p_plugin_id=>wwv_flow_api.id(708795120396802284.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(708807203689816438.4054)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>',
'<p>',
'<h3>Example:</h3>',
'<pre>http://sso.mycompany.com/?success=#CALLBACK#</pre>',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(708859829493861703.4054)
,p_plugin_id=>wwv_flow_api.id(708795120396802284.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(708807203689816438.4054)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1035483720020538244.4054)
,p_plugin_id=>wwv_flow_api.id(708795120396802284.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(708807203689816438.4054)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'BUILTIN_URL,URL'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1035499301796542365.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(1035483720020538244.4054)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1035503608376544352.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(1035483720020538244.4054)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(195660709366291246.4054)
,p_plugin_id=>wwv_flow_api.id(708795120396802284.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(863910941135523528.4054)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>'Directory LDAP INTERNAL'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Immettere il nome utente e la password per l''autenticazione rispetto alla directory LDAP identificata nella pagina di login. Le password possono distinguere tra maiuscole e minuscole.</p>',
''))
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(864164037419579163.4054)
,p_plugin_id=>wwv_flow_api.id(863910941135523528.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(864172428546586063.4054)
,p_plugin_id=>wwv_flow_api.id(863910941135523528.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(864187751403592682.4054)
,p_plugin_id=>wwv_flow_api.id(863910941135523528.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(864195025907594763.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(864187751403592682.4054)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(864199231794596530.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(864187751403592682.4054)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(864203434218597234.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(864187751403592682.4054)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(864316046947619765.4054)
,p_plugin_id=>wwv_flow_api.id(863910941135523528.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(864250538851608010.4054)
,p_plugin_id=>wwv_flow_api.id(863910941135523528.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(864353444308628540.4054)
,p_plugin_id=>wwv_flow_api.id(863910941135523528.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(864250538851608010.4054)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(864446826908642374.4054)
,p_plugin_id=>wwv_flow_api.id(863910941135523528.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(194434206895698724.4054)
,p_plugin_id=>wwv_flow_api.id(863910941135523528.4054)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(194434514860701032.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(194434206895698724.4054)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(194434920747702762.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(194434206895698724.4054)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(194435325596704212.4054)
,p_plugin_attribute_id=>wwv_flow_api.id(194434206895698724.4054)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2446594583478207883.4054)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>'Aggiungi casella di controllo Seleziona tutto'
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512.4054
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>L''azione dinamica "Aggiungi casella di controllo Seleziona tutto" converte un''intestazione di colonna contenente la stringa #CHECK_ALL_CHECKBOX# in una casella di controllo accessibile di tipo Seleziona tutto, ovvero tutte le caselle di controllo '
||'nella colonna corrispondente verranno selezionate o deselezionate.<p>',
'<p>',
'Per utilizzare questo plugin, assicurarsi che siano impostati gli attributi riportati di seguito.',
'<ol>',
'<li>Nella colonna di report, ''#CHECK_ALL_CHECKBOX#'' deve essere definito come valore di intestazione.</li>',
'<li>Per l''attributo Quando dell''azione dinamica, selezionare l''area del report contenente la colonna.</li>',
'<li>Definire l''azione dinamica in modo che si attivi ''Dopo l''aggiornamento'', mentre l''azione deve essere impostata su ''Attiva al caricamento della pagina''. Entrambe le azioni verranno preimpostate in modo adeguato se l''azione dinamica viene creata se'
||'lezionando l''area nella sezione ''Rendering'' di Page Designer e creando l''azione dinamica da qui.</li>',
unistr('<li>Non verr\00E0 gestito l''accesso facilitato delle caselle di controllo visualizzate in ogni riga. Ci\00F2 dovr\00E0 essere eseguito separatamente nell''origine dell''area. Per un esempio, vedere 4000:656 ''Aree''.</li>'),
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(4973826483302347.4054)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>'Desktop'
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>3
,p_home_url=>'f?p=4050:3:&SESSION.'
,p_login_url=>'f?p=4550:10:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4054
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_include_jquery_migrate=>true
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'zero'
,p_step_title=>'zero'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517338613979160813.4054)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-instance-admin'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517338869335160813.4054)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(517338613979160813.4054)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517339036280160813.4054)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(517338869335160813.4054)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="f?p=4050:3:''||:APP_SESSION||''::''||:DEBUG||''::::" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''INSTANCE_ADMIN_HOME_NAV'')||''"><span class="a-Header-apexLogo"><span class="u-VisuallyHidden">''||wwv_flow_lang.system_me'
||'ssage(''INSTANCE_ADMIN_HOME_NAV'')||''</span></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517339235689160818.4054)
,p_plug_name=>'APEX 5 - Tabs'
,p_parent_plug_id=>wwv_flow_api.id(517338869335160813.4054)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(40102013671283832.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517380133540212757.4054)
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517339498543160818.4054)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(517338613979160813.4054)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517339884402160818.4054)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_api.id(517339498543160818.4054)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517340077689160819.4054)
,p_plug_name=>'APEX 5 - Admin Menu'
,p_parent_plug_id=>wwv_flow_api.id(517339884402160818.4054)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2101406451333034428.4054)
,p_plug_name=>'APEX 5 - Help'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_api.id(517339884402160818.4054)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(2105958267784095383.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517380464558212757.4054)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517340236798160820.4054)
,p_plug_name=>'APEX 5 - Account'
,p_parent_plug_id=>wwv_flow_api.id(517339498543160818.4054)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>90
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517340434349160820.4054)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-instance-admin'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>100
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'3'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517340605882160820.4054)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_api.id(517340434349160820.4054)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>110
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(517340807756160820.4054)
,p_plug_name=>'APEX 5 - Breadcrumb'
,p_parent_plug_id=>wwv_flow_api.id(517340605882160820.4054)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>120
,p_plug_display_point=>'BODY'
,p_menu_id=>wwv_flow_api.id(4585800473139662.4054)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(517472004210010979.4054)
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2101406596781034429.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(517339884402160818.4054)
,p_button_name=>'Help'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372928661202760.4054)
,p_button_image_alt=>'Guida'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Aree di lavoro esistenti'
,p_step_title=>'Aree di lavoro esistenti'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216765317551591446)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_wrkspc_existing.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(24550226216.4054)
,p_plug_name=>'Aree di lavoro'
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Utilizzare questa pagina per ricercare le aree di lavoro fornite. Fare clic sul nome dell''area di lavoro per visualizzare un report dettagliato su un''area di lavoro specifica. Fare clic su <b>Elimina</b> nella colonna dell''azione per avviare la Ri'
||'mozione guidata area di lavoro.</p>'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'Region generated by create flow wizard'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1123402460345350.4054)
,p_plug_name=>'Aree di lavoro'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(721125879764730304.4054)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4050P1a */',
'       short_name,',
'       (case account_status ',
'        when ''AVAILABLE'' then wwv_flow_lang.system_message(''F4050.AVAILABLE'')',
'        when ''ASSIGNED'' then wwv_flow_lang.system_message(''F4050.ASSIGNED'')',
'        when ''SUSPENDED'' then wwv_flow_lang.system_message(''F4050.SUSPENDED'')',
'        when ''TERMINATE'' then wwv_flow_lang.system_message(''F4050.TERMINATE'')',
'        else account_status',
'        end ) account_status ,',
'       display_name,',
'       rm_consumer_group,',
'       nvl(ALLOW_TO_BE_PURGED_YN,''Y'') auto_purge,',
'       (select count(*) from wwv_flow_fnd_user where  SECURITY_GROUP_ID = c.PROVISIONING_COMPANY_ID) c, ',
'       (select count(*) c from wwv_flow_developers where security_group_id=c.PROVISIONING_COMPANY_ID) d,',
'       (select count(*) c from wwv_flows where security_group_id = c.PROVISIONING_COMPANY_ID) f,',
'       (select project_status from wwv_flow_provision_company where security_group_id=c.PROVISIONING_COMPANY_ID) status,',
'       (select project_approval_date from wwv_flow_provision_company where security_group_id=c.PROVISIONING_COMPANY_ID) provision_date,',
'       (select project_approval_date from wwv_flow_provision_company where security_group_id=c.PROVISIONING_COMPANY_ID) provision_date2,',
'       PROVISIONING_COMPANY_ID,',
'       SOURCE_IDENTIFIER,',
'       allow_restful_services_yn,',
'       path_prefix,',
'       decode( provisioning_company_id,',
'               ''10'', '' '',',
'               ''<a href="''||',
'               wwv_flow_utilities.prepare_url (',
'                   ''f?p=4050:81:''||:flow_session||',
'                   '':BRANCH_TO_PAGE_ACCEPT|NEXT::81,82:P81_COMPANY:''||',
'                   short_name )||',
'               ''">''||',
'               wwv_flow_lang.system_message(''F4350.DELETE'') ) || ''</a>'' delete_me',
'  from WWV_FLOW_COMPANIES c ',
' where upper(short_name) != ''UNKNOWN'' ',
'   and provisioning_company_id not in ( 11, 12 )'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1123501416345350.4054)
,p_name=>'Workspaces'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('Questa query restituisce pi\00F9 di 10.000 righe. Filtrare i dati per ottenere risultati completi.')
,p_no_data_found_message=>'Nessun dato trovato.'
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="" />'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1123707388345359.4054)
,p_db_column_name=>'SHORT_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Nome area di lavoro'
,p_column_link=>'f?p=&APP_ID.:78:&SESSION.:REPORT:&DEBUG.:RP,78:P78_PROVISIONING_COMPANY_ID:#PROVISIONING_COMPANY_ID#'
,p_column_linktext=>'#SHORT_NAME#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1123820269345360.4054)
,p_db_column_name=>'C'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Utenti'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1123913070345360.4054)
,p_db_column_name=>'D'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Sviluppatori'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1124007202345360.4054)
,p_db_column_name=>'F'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Applicazioni'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1124118550345360.4054)
,p_db_column_name=>'STATUS'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Stato fornitura'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(316820619150159698)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1124224550345360.4054)
,p_db_column_name=>'PROVISION_DATE'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Data fornitura'
,p_column_type=>'DATE'
,p_format_mask=>'&DATE_TIME_FORMAT.'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1124324365345361.4054)
,p_db_column_name=>'PROVISIONING_COMPANY_ID'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'ID area di lavoro'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1124415825345361.4054)
,p_db_column_name=>'DELETE_ME'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Azione'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(484700015910994745.4054)
,p_db_column_name=>'AUTO_PURGE'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Rimozione automatica'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(157992123774592395)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(484701200027018549.4054)
,p_db_column_name=>'PROVISION_DATE2'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Provisioning eseguito'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(484860511289026229.4054)
,p_db_column_name=>'SOURCE_IDENTIFIER'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'Identificativo origine'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(356783130548564595.4054)
,p_db_column_name=>'ACCOUNT_STATUS'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>'Stato area di lavoro'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(378216319396668186.4054)
,p_db_column_name=>'DISPLAY_NAME'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>'Nome visualizzato'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(16904813381618873.4054)
,p_db_column_name=>'RM_CONSUMER_GROUP'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>'Gruppo di consumer'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(385885140328363834.4054)
,p_db_column_name=>'ALLOW_RESTFUL_SERVICES_YN'
,p_display_order=>15
,p_column_identifier=>'O'
,p_column_label=>'Servizi RESTful'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(157992123774592395)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(385885208621363841.4054)
,p_db_column_name=>'PATH_PREFIX'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>'Prefisso percorso'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(484700307037001616.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1123402460345350.4054)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Reimposta'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:1,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(254106119813882628.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1123402460345350.4054)
,p_button_name=>'CREATE_WORKSPACE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea area di lavoro'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:RP,27,79,72,73,74::'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(357640492667810948.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1123402460345350.4054)
,p_button_name=>'CREATE_WORKSPACE_ATP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea area di lavoro'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.:RP,142:LAST_VIEW:1'
,p_required_patch=>-wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(24599238284.4054)
,p_branch_action=>'1'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(270581419969760339.4054)
,p_computation_sequence=>10
,p_computation_item=>'LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'1'
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_api.create_page(
 p_id=>2.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Aree di lavoro solo con applicazione di esempio'
,p_step_title=>'Aree di lavoro con applicazione di esempio'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216765317551591446)
,p_step_template=>wwv_flow_api.id(721098416706687971.4054)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_mg_wrkspc.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25558617619873543.4054)
,p_plug_name=>'Aree di lavoro solo con applicazione di esempio'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(721125879764730304.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4050P2a */',
'   owner,',
'   name, ',
'   total,',
'   security_group_id,',
'   (select w.short_name from wwv_flow_companies w where security_group_id = w.PROVISIONING_COMPANY_ID) workspace,',
'   id application_id,',
'   last_updated_on,',
'   last_updated_by',
' from ( ',
' select last_updated_on, last_updated_by, id, security_group_id, owner, name, count(1) over(partition by owner) total',
'   from wwv_flows ',
' )',
' where ',
' (total = 1 and name like ''Sample Database Application%'')'))
,p_plug_source_type=>'NATIVE_IR'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(25558724657873543.4054)
,p_name=>'Workspaces With Sample Applications'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('Questa query restituisce pi\00F9 di 10.000 righe. Filtrare i dati per ottenere risultati completi.')
,p_no_data_found_message=>'Nessun dato trovato.'
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(25558930888873549.4054)
,p_db_column_name=>'OWNER'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Schema di analisi'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(25559016411873550.4054)
,p_db_column_name=>'NAME'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Nome applicazione'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(25559122484873550.4054)
,p_db_column_name=>'TOTAL'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Conteggio applicazioni'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(25560506180891871.4054)
,p_db_column_name=>'SECURITY_GROUP_ID'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'ID area di lavoro'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(25560720510905539.4054)
,p_db_column_name=>'WORKSPACE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Area di lavoro'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(25733006672920210.4054)
,p_db_column_name=>'APPLICATION_ID'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'ID applicazione'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(25859021002933748.4054)
,p_db_column_name=>'LAST_UPDATED_ON'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Aggiornato'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(25859119454933750.4054)
,p_db_column_name=>'LAST_UPDATED_BY'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Autore aggiornamento'
,p_column_type=>'STRING'
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_api.create_page(
 p_id=>3.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Servizi di amministrazione di Application Express'
,p_step_title=>'Servizi di amministrazione di Application Express'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216800021154677630)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'#fixed_height_region .rc-content {min-height: 200px; padding: 0;}',
'</style>'))
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_deep_linking=>'Y'
,p_help_text=>'AEADM/adm_wrkspc.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(118635692071.4054)
,p_plug_name=>'Informazioni'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>100
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Accedere ai task di amministrazione ed eseguirli per un''intera istanza di Oracle &PRODUCT_NAME..</p>',
'<p><a target="_blank" href="&SYSTEM_HELP_URL./aeadm/oracle-application-express-administration-services.html">Ulteriori informazioni...</a></p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'valign="top" align="right"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(20401325723455881.4054)
,p_name=>'Nuove richieste di servizio'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>90
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--noPadding:h240'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--stretch'
,p_report_attributes=>'width="100%"'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4050P4651d */',
'    ''<a href="''||provision_link||''">''||',
'       wwv_flow_escape.html(',
'          wwv_flow_lang.system_message(''REQUEST_WORKSPACE'',',
'              admin_email,',
'              workspace_name,',
'              request_size))||''</a>''',
'       the_request,',
'    request_date',
'from',
'(',
'select ',
'    ADMIN_EMAIL,',
'    COMPANY_NAME                         workspace_name,',
'    DATABASE_SIZE||''MB''                  request_size,',
'    request_date                         request_date,',
'    ''f?p=4050:4:''||:app_session||',
'       ''::NO::PROVISION_ID:''||id         provision_link',
'from WWV_FLOW_PROVISION_COMPANY',
'where project_status = ''REQUESTED''',
')',
'union',
'select ',
'        decode(m.request_status,',
'          ''REQUESTED'',''<a href="f?p=4050:110:''||:flow_session||''::NO:110:P110_REQUEST_ID,P110_SGID:''||m.id||'',''||m.security_group_id,',
'          ''APPROVED'', ''<a href="f?p=4050:110:''||:flow_session||''::NO:110,RP:P110_REQUEST_ID,P110_SGID:''||m.id||'',''||m.security_group_id',
'          ) ||''">''||',
'        wwv_flow_escape.html(',
'          decode(m.service_name,',
'          ''NEW_SCHEMA'',wwv_flow_lang.system_message(',
'                 ''REQUEST_NEW_SCHEMA'',',
'                 m.REQUESTED_BY, ',
'                 c.short_name, ',
'                 m.service_attribute_1',
'                 ),',
'          ''CHANGE_DB_SIZE'',       wwv_flow_lang.system_message(',
'                          ''REQUEST_CHANGE_DB_SIZE'',',
'                          m.REQUESTED_BY, ',
'                          c.short_name, ',
'                          m.service_attribute_1||''MB''',
'                          ),',
'           c.short_name ||',
'           '' - ''||m.service_name || ',
'           '' - ''||m.service_attribute_1)',
'        )||',
'        ''</a>'' the_request,',
'         m.requested_on        request_date',
'    from wwv_flow_provision_serice_mod m, ',
'         wwv_flow_companies c',
'   where m.security_group_id = c.provisioning_company_id',
'             and   m.request_status = ''REQUESTED''',
'order by 2 desc'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(805672157251677851.4054)
,p_query_num_rows=>100
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_no_data_found=>'Nessuna nuova richiesta di servizio.'
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image=>'apex/builder/dup.gif'
,p_query_asc_image_attr=>'width="16" height="16" alt="" '
,p_query_desc_image=>'apex/builder/ddown.gif'
,p_query_desc_image_attr=>'width="16" height="16" alt="" '
,p_plug_query_strip_html=>'Y'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(20401325723455881.4054)
,p_plug_column_width=>'apex-col--bottomBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(20401615462455886.4054)
,p_query_column_id=>1
,p_column_alias=>'THE_REQUEST'
,p_column_display_sequence=>1
,p_column_heading=>'Richiesta'
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(20401715743455886.4054)
,p_query_column_id=>2
,p_column_alias=>'REQUEST_DATE'
,p_column_display_sequence=>2
,p_column_heading=>'Data'
,p_use_as_row_header=>'N'
,p_column_format=>'SINCE'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29327206513889261.4054)
,p_plug_name=>'Task istanza'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>140
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(47534314618390800.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(27525012681104508.4054)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29719518059693725.4054)
,p_plug_name=>'Task area di lavoro'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>150
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(29722514446881924.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(27525012681104508.4054)
,p_plug_column_width=>'valign="top"'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29937821359675476.4054)
,p_plug_name=>'Provisioning'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>120
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare v varchar2(500); ',
'begin',
'v := wwv_flow_platform.get_preference( p_preference_name => ''SERVICE_REQUEST_FLOW'' );',
'if v = ''MANUAL'' then',
'   sys.htp.p(wwv_flow_lang.system_message(''PROVISIONING_MODE_MANUAL''));',
'elsif v = ''4700'' then',
'   sys.htp.p(wwv_flow_lang.system_message(''PROVISIONING_MODE_REQUEST''));   ',
'elsif v = ''EMAIL'' then',
'   sys.htp.p(wwv_flow_lang.system_message(''PROVISIONING_MODE_EMAIL''));',
'else',
'   sys.htp.p(''<p>''||wwv_flow_escape.html(v)||''</p>'');',
'end if;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(46453013260349027.4054)
,p_name=>'Riepilogo area di lavoro'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>60
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--noPadding:h240'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4050P3a */',
'    (select trim(to_char(count(*),''999G999G999G990'')) c ',
'     from wwv_flow_companies ',
'     where PROVISIONING_COMPANY_ID not in (0,10,11)) ',
'    workspaces,',
'    (select trim(to_char(count(*),''999G999G999G990'')) c ',
'     from WWV_FLOW_COMPANY_SCHEMAS ',
'     where security_group_id not in (0,10,11)) ',
'    schemas,',
'    (select trim(to_char(count(*),''999G999G999G990'')) c ',
'     from WWV_FLOWS ',
'     where SECURITY_GROUP_ID not in (0,10,11)) ',
'    Applications,',
'    (select trim(to_char(count(*),''999G999G999G990'')) c ',
'     from WWV_FLOW_FND_USER ',
'     ) ',
'    users,',
'    (select trim(to_char(count(*),''999G999G999G990'')) c ',
'     from wwv_flow_mail_queue',
'     ) ',
'    mail_queue_entries,',
'    (select trim(to_char(count(*),''999G999G999G999G990'')) c',
'     from wwv_flow_worksheets w, ',
'       wwv_flow_ws_websheet_attr a',
'     where w.id = a.worksheet_id and        ',
'       a.websheet_type != ''TEMPLATE'') ',
'    websheets,',
'    null sql_scripts',
'from dual'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46450823627307947.4054)
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>'nessun dato trovato'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(46453013260349027.4054)
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46453303454349039.4054)
,p_query_column_id=>1
,p_column_alias=>'WORKSPACES'
,p_column_display_sequence=>1
,p_column_heading=>'Aree di lavoro'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46453400739349041.4054)
,p_query_column_id=>2
,p_column_alias=>'SCHEMAS'
,p_column_display_sequence=>2
,p_column_heading=>'Schemi'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46453525576349042.4054)
,p_query_column_id=>3
,p_column_alias=>'APPLICATIONS'
,p_column_display_sequence=>3
,p_column_heading=>'Applicazioni'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46453620768349042.4054)
,p_query_column_id=>4
,p_column_alias=>'USERS'
,p_column_display_sequence=>4
,p_column_heading=>'Utenti'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(46453725854349042.4054)
,p_query_column_id=>5
,p_column_alias=>'MAIL_QUEUE_ENTRIES'
,p_column_display_sequence=>5
,p_column_heading=>'Voci di coda della posta'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47526422491265777.4054)
,p_query_column_id=>6
,p_column_alias=>'WEBSHEETS'
,p_column_display_sequence=>6
,p_column_heading=>'Websheet'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(47526519634265779.4054)
,p_query_column_id=>7
,p_column_alias=>'SQL_SCRIPTS'
,p_column_display_sequence=>7
,p_column_heading=>'SQL Scripts'
,p_use_as_row_header=>'N'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168904510438515608.4054)
,p_plug_name=>'Amministrazione istanza'
,p_region_sub_css_classes=>'instance-admin'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(168902912946497370.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410251255325302.4054)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168920123999973593.4054)
,p_plug_name=>'Messaggio di sistema'
,p_region_css_classes=>'a-Alert--inline'
,p_region_template_options=>'#DEFAULT#:a-Alert--colorBG:a-Alert--noIcon:a-Alert--warning:a-Alert--horizontal'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829706609080810173.4054)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>'wwv_flow_4050_ui.show_system_message( p_app_session => :APP_SESSION );'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(183463511911929201.4054)
,p_name=>'Impostazioni istanza'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>100
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--noPadding:h240'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  /* APEX 4050P4651c */',
'    wwv_flow_platform.get_preference(''INSTANCE_ID'') instance_id,',
'    wwv_flow_platform.get_preference(''NOTIFICATION_EMAIL'' ) ',
'        notification_email,',
'    wwv_flow_platform.get_preference(''EMAIL_INSTANCE_URL'' )',
'        instance_url,',
'    decode(wwv_flow_platform.get_preference(''SERVICE_REQUEST_FLOW''),',
'        ''EMAIL'',wwv_flow_lang.system_message(''PROVISIONING_MODE_EMAIL''),',
'        ''4700'',wwv_flow_lang.system_message(''PROVISIONING_MODE_REQUEST''),',
'        ''MANUAL'',wwv_flow_lang.system_message(''PROVISIONING_MODE_MANUAL''),',
'        wwv_flow_lang.system_message(''UNKNOWN''))',
'        provisioning_mode,',
'    decode ( wwv_flow_platform.get_preference(''REQ_NEW_SCHEMA'' ) ,',
'        ''Y'',wwv_flow_lang.system_message(''YES''),',
'        ''N'',wwv_flow_lang.system_message(''NO''),',
'        wwv_flow_lang.system_message(''UNKNOWN''))',
'        new_schema,',
'    decode(wwv_flow_platform.get_preference(''PRINT_BIB_LICENSED'' ),',
'        ''ADVANCED'',wwv_flow_lang.system_message(''print_server_advanced''),',
'        ''STANDARD'',wwv_flow_lang.system_message(''STANDARD''),',
'        wwv_flow_lang.system_message(''UNKNOWN''))',
'        print_server,',
'    wwv_flow_platform.get_preference(''PRINT_SVR_HOST'' )',
'        print_server_host_address,',
'    wwv_flow_platform.get_preference(''SMTP_HOST_ADDRESS'' )',
'        SMTP_HOST_ADDRESS',
'from dual'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46450823627307947.4054)
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>'nessun dato trovato'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(183463511911929201.4054)
,p_plug_column_width=>'apex-col--bottomBorder apex-col--leftBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(16863222023876407.4054)
,p_query_column_id=>1
,p_column_alias=>'INSTANCE_ID'
,p_column_display_sequence=>1
,p_column_heading=>'ID istanza'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183463813490929210.4054)
,p_query_column_id=>2
,p_column_alias=>'NOTIFICATION_EMAIL'
,p_column_display_sequence=>2
,p_column_heading=>'Messaggio di posta elettronica di notifica'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(20133310180661802.4054)
,p_query_column_id=>3
,p_column_alias=>'INSTANCE_URL'
,p_column_display_sequence=>3
,p_column_heading=>'URL istanza'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183465031566953824.4054)
,p_query_column_id=>4
,p_column_alias=>'PROVISIONING_MODE'
,p_column_display_sequence=>4
,p_column_heading=>unistr('Modalit\00E0 di provisioning')
,p_display_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183765727327988271.4054)
,p_query_column_id=>5
,p_column_alias=>'NEW_SCHEMA'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\00C8 richiesto un nuovo schema?')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183766604733000610.4054)
,p_query_column_id=>6
,p_column_alias=>'PRINT_SERVER'
,p_column_display_sequence=>6
,p_column_heading=>'Server di stampa'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183769506773048520.4054)
,p_query_column_id=>7
,p_column_alias=>'PRINT_SERVER_HOST_ADDRESS'
,p_column_display_sequence=>7
,p_column_heading=>'Indirizzo host server di stampa'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183766808327011155.4054)
,p_query_column_id=>8
,p_column_alias=>'SMTP_HOST_ADDRESS'
,p_column_display_sequence=>8
,p_column_heading=>'Indirizzo host SMTP'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(183769726644063701.4054)
,p_name=>'Impostazioni sicurezza'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>80
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--noPadding:h240'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_row=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  /* APEX 4050P4651b */',
'    decode(',
'    wwv_flow_platform.get_preference(''REQUIRE_HTTPS'' ) ,',
'        ''Y'',wwv_flow_lang.system_message(''YES''),',
'        ''N'',wwv_flow_lang.system_message(''NO''),',
'        ''A'',wwv_flow_lang.system_message(''ALWAYS''),',
'        wwv_flow_lang.system_message(''UNKNOWN''))',
'        require_https,',
'    nvl(wwv_flow_platform.get_preference(''MAX_SESSION_IDLE_SEC''),3600)',
'        maximum_session_idle_seconds,',
'    nvl(wwv_flow_platform.get_preference(''MAX_SESSION_LENGTH_SEC''),28800)',
'        maximum_session_length_seconds,',
'    decode(wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS''),',
'        ''Y'',wwv_flow_lang.system_message(''YES''),',
'        ''N'',wwv_flow_lang.system_message(''NO''),',
'        wwv_flow_lang.system_message(''UNKNOWN''))',
'        expire_user_accounts,',
'    wwv_flow_platform.get_preference(''MAX_LOGIN_FAILURES'')',
'        max_login_failures,',
'    wwv_flow_platform.get_preference(''ACCOUNT_LIFETIME_DAYS'')',
'        password_lifetime_days,',
'    decode(wwv_flow_platform.get_preference(''STRONG_SITE_ADMIN_PASSWORD'') ,',
'        ''Y'',wwv_flow_lang.system_message(''YES''),',
'        ''N'',wwv_flow_lang.system_message(''NO''),',
'        wwv_flow_lang.system_message(''UNKNOWN''))',
'        require_strong_admin_password',
'from dual'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(46450823627307947.4054)
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>'nessun dato trovato'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(183769726644063701.4054)
,p_plug_column_width=>'apex-col--leftBorder'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183772408383115226.4054)
,p_query_column_id=>1
,p_column_alias=>'REQUIRE_HTTPS'
,p_column_display_sequence=>1
,p_column_heading=>'Richiedi HTTPS'
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183772517652115226.4054)
,p_query_column_id=>2
,p_column_alias=>'MAXIMUM_SESSION_IDLE_SECONDS'
,p_column_display_sequence=>2
,p_column_heading=>unistr('Tempo di inattivit\00E0 sessione massimo (secondi)')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183772604474115226.4054)
,p_query_column_id=>3
,p_column_alias=>'MAXIMUM_SESSION_LENGTH_SECONDS'
,p_column_display_sequence=>3
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183772700820115226.4054)
,p_query_column_id=>4
,p_column_alias=>'EXPIRE_USER_ACCOUNTS'
,p_column_display_sequence=>4
,p_column_heading=>'Fai scadere account utente'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183772814386115227.4054)
,p_query_column_id=>5
,p_column_alias=>'MAX_LOGIN_FAILURES'
,p_column_display_sequence=>5
,p_column_heading=>'Numero massimo di login non riusciti'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183772932553115227.4054)
,p_query_column_id=>6
,p_column_alias=>'PASSWORD_LIFETIME_DAYS'
,p_column_display_sequence=>6
,p_column_heading=>'Durata password (giorni)'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(183773017254115227.4054)
,p_query_column_id=>7
,p_column_alias=>'REQUIRE_STRONG_ADMIN_PASSWORD'
,p_column_display_sequence=>7
,p_column_heading=>'Richiedi password amministratore efficace'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466818203845023502.4054)
,p_plug_name=>'Language'
,p_region_name=>'builder_home_lang_selector'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody:a-Region--hideHeader'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>110
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'sys.htp.p( wwv_flow_lang.get_language_selector_list );'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'wwv_flow_4000_ui.is_translation_installed( p_flow_id => 4000 )'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(619976314155172583.4054)
,p_name=>'Job'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>70
,p_region_template_options=>'#DEFAULT#:a-Region--shadowScroll:a-Region--noPadding:h240'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select j.job_name, apex_util.get_since_tswtz(j.last_start_date) last_start_date ',
'  from user_scheduler_jobs j ',
' where job_name in (''ORACLE_APEX_AUTO_APPROVAL'',''ORACLE_APEX_PURGE_SESSIONS'',''ORACLE_APEX_MAIL_QUEUE'',''ORACLE_APEX_WS_NOTIFICATIONS'',''ORACLE_APEX_DAILY_MAINTENANCE'')',
'union',
'select x.job_name, wwv_flow_lang.system_message(''NOT_FOUND'') last_start_date',
'  from (',
'select ''ORACLE_APEX_AUTO_APPROVAL'' job_name from dual',
'union',
'select ''ORACLE_APEX_PURGE_SESSIONS'' job_name from dual',
'union',
'select ''ORACLE_APEX_MAIL_QUEUE'' job_name from dual',
'union',
'select ''ORACLE_APEX_WS_NOTIFICATIONS'' job_name from dual',
'union',
'select ''ORACLE_APEX_DAILY_MAINTENANCE'' job_name from dual) x',
' where not exists ',
'(select null ',
'  from user_scheduler_jobs where job_name = x.job_name)',
'order by 1'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(47555718632924155.4054)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>'nessun dato trovato'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image=>'apex/builder/dup.gif'
,p_query_asc_image_attr=>'width="16" height="16" alt="" '
,p_query_desc_image=>'apex/builder/ddown.gif'
,p_query_desc_image_attr=>'width="16" height="16" alt="" '
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(619976605315172588.4054)
,p_query_column_id=>1
,p_column_alias=>'JOB_NAME'
,p_column_display_sequence=>1
,p_column_heading=>'Nome job'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(619976727550172590.4054)
,p_query_column_id=>2
,p_column_alias=>'LAST_START_DATE'
,p_column_display_sequence=>2
,p_column_heading=>'Ultima data di inizio'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(620840201547500783.4054)
,p_plug_name=>'Jobs'
,p_parent_plug_id=>wwv_flow_api.id(619976314155172583.4054)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>90
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<br /><p>''||wwv_flow_escape.html(wwv_flow_lang.system_message(''DATE_OF_LAST_RUN''))||''</p>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(777604149198624201.4054)
,p_plug_name=>'Aggiornamenti disponibili'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>180
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>'sys.htp.prn( ''<div id="updates"></div>'' );'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_plug_comment=>'Feature #1437'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(926451766177861836.4054)
,p_plug_name=>'Richieste in sospeso'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:h240'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(926449801871861817.4054)
,p_name=>'Richieste in sospeso'
,p_parent_plug_id=>wwv_flow_api.id(926451766177861836.4054)
,p_template=>wwv_flow_api.id(517376500704206647.4054)
,p_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-BadgeList--fixed:a-BadgeList--xlarge'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4500P1000cMH */',
'    wwv_flow_provisioning.total_open_service_requests new_service,',
'    --',
'    wwv_flow_provisioning.total_open_change_requests service_change',
'from dual'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(805663950138677747.4054)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(968678541063060714.4054)
,p_query_column_id=>1
,p_column_alias=>'NEW_SERVICE'
,p_column_display_sequence=>1
,p_column_heading=>'Nuovo servizio'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:RP,RIR:::'
,p_column_linktext=>'#NEW_SERVICE#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(968798125219081788.4054)
,p_query_column_id=>2
,p_column_alias=>'SERVICE_CHANGE'
,p_column_display_sequence=>2
,p_column_heading=>'Modifica di servizio'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:RP,RIR:::'
,p_column_linktext=>'#SERVICE_CHANGE#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(926451651092861835.4054)
,p_plug_name=>unistr('Modalit\00E0')
,p_parent_plug_id=>wwv_flow_api.id(926451766177861836.4054)
,p_region_css_classes=>'a-Region-regionDesc'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('Modalit\00E0 di provisioning: Provisioning Self Service')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(926451866270861837.4054)
,p_plug_name=>'Amministrazione istanza'
,p_region_css_classes=>'a-Region--noTopBorder'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--showTitle'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(183774608083143536.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(183463511911929201.4054)
,p_button_name=>'EDIT_SET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(517373248988202760.4054)
,p_button_image_alt=>'Modifica'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.:131::'
,p_icon_css_classes=>'icon-edit'
);
end;
/
begin
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(203133126735284812.4054)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(183463511911929201.4054)
,p_button_name=>'VIEW_INSTANCE_SETTINGS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(517373248988202760.4054)
,p_button_image_alt=>'Visualizza impostazioni istanza'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:RP::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(183774323405129018.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(183769726644063701.4054)
,p_button_name=>'EDIT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(517373248988202760.4054)
,p_button_image_alt=>'Modifica'
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_redirect_url=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:130::'
,p_icon_css_classes=>'icon-edit'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(256279016122801246.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(46453013260349027.4054)
,p_button_name=>'VIEW_MONITOR'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(517373248988202760.4054)
,p_button_image_alt=>unistr('Controlla attivit\00E0')
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_redirect_url=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:RP::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(202704411977539506.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(926451766177861836.4054)
,p_button_name=>'VIEW_REQUESTS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_api.id(517373248988202760.4054)
,p_button_image_alt=>'Visualizza richieste'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:RP::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(202796708138602663.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(926451866270861837.4054)
,p_button_name=>'CREATE_workspace'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372670814202760.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea area di lavoro'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:27,79,72,73,74::'
,p_icon_css_classes=>'icon-right-chevron'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1143246809648567421.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(168920123999973593.4054)
,p_button_name=>'EDIT_MESSAGE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517373248988202760.4054)
,p_button_image_alt=>'Modifica messaggio di sistema'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:132:&SESSION.::&DEBUG.:132:::'
,p_icon_css_classes=>'icon-edit'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1427416875824615006.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(777604149198624201.4054)
,p_button_name=>'set_preferences_updates'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517373248988202760.4054)
,p_button_image_alt=>'Imposta preferenze per aggiornamenti disponibili'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:70:&SESSION.::&DEBUG.:RP,70::'
,p_button_css_classes=>'a-Button a-Button--withIcon a-Button--noLabel a-Button--small a-Button--noUI'
,p_icon_css_classes=>'icon-gear'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(357640585498810948.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(926451866270861837.4054)
,p_button_name=>'CREATE_workspace_ATP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372670814202760.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea area di lavoro'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.:142:LAST_VIEW:3'
,p_icon_css_classes=>'icon-right-chevron'
,p_required_patch=>-wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(29945304933859964.4054)
,p_computation_sequence=>10
,p_computation_item=>'LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'3'
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1427416964580615007.4054)
,p_name=>'Updates - Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(1427416875824615006.4054)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1427417053117615008.4054)
,p_event_id=>wwv_flow_api.id(1427416964580615007.4054)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(777604149198624201.4054)
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// Reload page. We have to do it with a timer, because Firefox prevents the redirect otherwise',
'setTimeout( function() {',
'    apex.navigation.redirect( apex.util.makeApplicationUrl( {} ));',
'}, 0 );'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(777604227083624202.4054)
,p_process_sequence=>10
,p_process_point=>'BEFORE_FOOTER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check for updates'
,p_process_sql_clob=>'wwv_flow_4000_ui.updates();'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(359767105825562475.4054)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear'
,p_attribute_01=>'CLEAR_CACHE_FOR_ITEMS'
,p_attribute_03=>'F4050_P72_ADMIN_PASS,F4050_P79_SCHEMA_PASSWORD,F4050_P23_WEB_PASSWORD,P53_PASSWORD,P53_PASSWORD2,P53_GEN_PASSWORD,P106_PASSWORD,P277_SCHEMA_PASSWORD'
);
end;
/
prompt --application/pages/page_00004
begin
wwv_flow_api.create_page(
 p_id=>4.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Amministrazione della fornitura'
,p_step_title=>'Amministrazione della fornitura'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216766430018595041)
,p_step_template=>wwv_flow_api.id(721099117305687972.4054)
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>'AEADM/adm_create_wkspc.htm'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(173724892445.4054)
,p_name=>'Richiesta di area di lavoro'
,p_template=>wwv_flow_api.id(829706609080810173.4054)
,p_display_sequence=>20
,p_region_template_options=>'#DEFAULT#:a-Alert--defaultIcons:a-Alert--warning:a-Alert--wizard'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select     ',
'    COMPANY_NAME,',
'    ADMIN_FIRST_NAME,',
'    ADMIN_LAST_NAME,',
'    ADMIN_TITLE,',
'    ADMIN_EMAIL,',
'    ADMIN_PHONE,',
'    ADMIN_USERID,',
'    COMPANY_ADDRESS,',
'    CITY,',
'    STATE,',
'    ZIP,',
'    COUNTRY,',
'    COMPANY_TYPE,',
'    COMPANY_WEBSITE,',
'    NUMBER_OF_EMPLOYEES,',
'    COMPANY_PHONE,',
'    COMPANY_FAX,',
'    ORACLE_PARTNER,',
'    HOW_DID_YOU_HEAR_ABOUT_US,',
'    SERVICE_USE_STATUS,',
'    DATABASE_SIZE,',
'    SERVICE_START_DATE,',
'    SERVICE_TERMINATION_DATE,',
'    SCHEMA_NAME,',
'    ESTIMATED_END_USERS,',
'    PAGE_VIEWS_PER_DAY,',
'    PROJECT_DESCRIPTION,',
'    PROJECT_JUSTIFICATION,',
'    PROJECT_APPROVAL_DATE,',
'    PROJECT_ACTUAL_BEGIN_DATE,',
'    PROJECT_ACTUAL_END_DATE,',
'    PROJECT_STATUS,',
'    request_date,',
'    SECURITY_GROUP_ID,',
'    id',
'from WWV_FLOW_PROVISION_COMPANY',
'where id = :provision_id'))
,p_fixed_header=>'NONE'
,p_query_row_template=>2
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_break_cols=>'0'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48687419982771655.4054)
,p_query_column_id=>1
,p_column_alias=>'COMPANY_NAME'
,p_column_display_sequence=>1
,p_column_heading=>'Nome area di lavoro'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48687515843771656.4054)
,p_query_column_id=>2
,p_column_alias=>'ADMIN_FIRST_NAME'
,p_column_display_sequence=>2
,p_column_heading=>'Nome amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48687628068771656.4054)
,p_query_column_id=>3
,p_column_alias=>'ADMIN_LAST_NAME'
,p_column_display_sequence=>3
,p_column_heading=>'Cognome amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48687729004771656.4054)
,p_query_column_id=>4
,p_column_alias=>'ADMIN_TITLE'
,p_column_display_sequence=>4
,p_column_heading=>'Admin Title'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48687805987771656.4054)
,p_query_column_id=>5
,p_column_alias=>'ADMIN_EMAIL'
,p_column_display_sequence=>5
,p_column_heading=>'Posta elettronica amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48687909288771656.4054)
,p_query_column_id=>6
,p_column_alias=>'ADMIN_PHONE'
,p_column_display_sequence=>6
,p_column_heading=>'Admin Phone'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48688029577771656.4054)
,p_query_column_id=>7
,p_column_alias=>'ADMIN_USERID'
,p_column_display_sequence=>7
,p_column_heading=>'ID utente amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48688118304771656.4054)
,p_query_column_id=>8
,p_column_alias=>'COMPANY_ADDRESS'
,p_column_display_sequence=>8
,p_column_heading=>'Company Address'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48688207126771656.4054)
,p_query_column_id=>9
,p_column_alias=>'CITY'
,p_column_display_sequence=>9
,p_column_heading=>'City'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48688309531771656.4054)
,p_query_column_id=>10
,p_column_alias=>'STATE'
,p_column_display_sequence=>10
,p_column_heading=>'State'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48688426433771657.4054)
,p_query_column_id=>11
,p_column_alias=>'ZIP'
,p_column_display_sequence=>11
,p_column_heading=>'Zip'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48688501652771657.4054)
,p_query_column_id=>12
,p_column_alias=>'COUNTRY'
,p_column_display_sequence=>12
,p_column_heading=>'Country'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48688632281771657.4054)
,p_query_column_id=>13
,p_column_alias=>'COMPANY_TYPE'
,p_column_display_sequence=>13
,p_column_heading=>'Company Type'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48688721428771657.4054)
,p_query_column_id=>14
,p_column_alias=>'COMPANY_WEBSITE'
,p_column_display_sequence=>14
,p_column_heading=>'Company Website'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48688808773771657.4054)
,p_query_column_id=>15
,p_column_alias=>'NUMBER_OF_EMPLOYEES'
,p_column_display_sequence=>15
,p_column_heading=>'Number Of Employees'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48688903783771657.4054)
,p_query_column_id=>16
,p_column_alias=>'COMPANY_PHONE'
,p_column_display_sequence=>16
,p_column_heading=>'Company Phone'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48689016797771657.4054)
,p_query_column_id=>17
,p_column_alias=>'COMPANY_FAX'
,p_column_display_sequence=>17
,p_column_heading=>'Company Fax'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48689116782771657.4054)
,p_query_column_id=>18
,p_column_alias=>'ORACLE_PARTNER'
,p_column_display_sequence=>18
,p_column_heading=>'Oracle Partner'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48689200152771658.4054)
,p_query_column_id=>19
,p_column_alias=>'HOW_DID_YOU_HEAR_ABOUT_US'
,p_column_display_sequence=>19
,p_column_heading=>'How Did You Hear About Us'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48689300933771658.4054)
,p_query_column_id=>20
,p_column_alias=>'SERVICE_USE_STATUS'
,p_column_display_sequence=>20
,p_column_heading=>'Stato di uso dell''area di lavoro'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48689400444771658.4054)
,p_query_column_id=>21
,p_column_alias=>'DATABASE_SIZE'
,p_column_display_sequence=>21
,p_column_heading=>'Dimensioni database'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48689521409771658.4054)
,p_query_column_id=>22
,p_column_alias=>'SERVICE_START_DATE'
,p_column_display_sequence=>22
,p_column_heading=>'Service Start Date'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48689621142771658.4054)
,p_query_column_id=>23
,p_column_alias=>'SERVICE_TERMINATION_DATE'
,p_column_display_sequence=>23
,p_column_heading=>'Service Termination Date'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48689700511771658.4054)
,p_query_column_id=>24
,p_column_alias=>'SCHEMA_NAME'
,p_column_display_sequence=>24
,p_column_heading=>'Nome schema'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48689810534771658.4054)
,p_query_column_id=>25
,p_column_alias=>'ESTIMATED_END_USERS'
,p_column_display_sequence=>25
,p_column_heading=>'Estimated End Users'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48689908996771658.4054)
,p_query_column_id=>26
,p_column_alias=>'PAGE_VIEWS_PER_DAY'
,p_column_display_sequence=>26
,p_column_heading=>'Page Views Per Day'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48690003327771658.4054)
,p_query_column_id=>27
,p_column_alias=>'PROJECT_DESCRIPTION'
,p_column_display_sequence=>27
,p_column_heading=>'Descrizione'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48690115108771658.4054)
,p_query_column_id=>28
,p_column_alias=>'PROJECT_JUSTIFICATION'
,p_column_display_sequence=>28
,p_column_heading=>'Justification'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48690213710771659.4054)
,p_query_column_id=>29
,p_column_alias=>'PROJECT_APPROVAL_DATE'
,p_column_display_sequence=>29
,p_column_heading=>'Project Approval Date'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48690326689771659.4054)
,p_query_column_id=>30
,p_column_alias=>'PROJECT_ACTUAL_BEGIN_DATE'
,p_column_display_sequence=>30
,p_column_heading=>'Project Actual Begin Date'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48690425411771659.4054)
,p_query_column_id=>31
,p_column_alias=>'PROJECT_ACTUAL_END_DATE'
,p_column_display_sequence=>31
,p_column_heading=>'Project Actual End Date'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48690503555771659.4054)
,p_query_column_id=>32
,p_column_alias=>'PROJECT_STATUS'
,p_column_display_sequence=>32
,p_column_heading=>'Project Status'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48690621397771659.4054)
,p_query_column_id=>33
,p_column_alias=>'REQUEST_DATE'
,p_column_display_sequence=>33
,p_column_heading=>'Data richiesta'
,p_column_format=>'&DATE_TIME_FORMAT.'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48690710746771659.4054)
,p_query_column_id=>34
,p_column_alias=>'SECURITY_GROUP_ID'
,p_column_display_sequence=>34
,p_column_heading=>'Workspace'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48690814352771659.4054)
,p_query_column_id=>35
,p_column_alias=>'ID'
,p_column_display_sequence=>35
,p_column_heading=>'Identification Number'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(179795422363234062.4054)
,p_plug_name=>'Avvertenze'
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829706609080810173.4054)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'l_schema                    wwv_flow_provision_company.schema_name%type;',
'l_schema_exists             boolean := false;',
'l_schema_in_use             boolean := false;',
'l_schema_cannot_be_assigned boolean := false;',
'begin',
'',
'for c1 in (select upper(schema_name) sa1',
'    from wwv_flow_provision_company',
'    where id = :PROVISION_ID) loop',
'    l_schema := c1.sa1;',
'end loop;',
'',
'l_schema_exists := wwv_flow_security.get_db_user_or_role(p_username => l_schema) is not null;',
'',
'for c1 in (select 1 from wwv_flow_company_schemas ',
'  where schema = l_schema) loop',
'  l_schema_in_use := true;',
'end loop;',
'',
'for c1 in (select 1 from dual',
'  where wwv_flow_provisioning.reserved_schema_i(l_schema) = 1',
'  or wwv_flow_provisioning.restricted_schema_i(l_schema, :P4_COMPANY_NAME) = 1) loop',
'    l_schema_cannot_be_assigned := true;',
'end loop;',
'',
'sys.htp.p(''<br />'');sys.htp.p(''<br />'');',
'',
'if l_schema_exists then',
'  sys.htp.p(''<p />''||',
'  wwv_flow_lang.system_message(''F4050.SCHEMA_EXISTS''));',
'end if;',
'',
'if l_schema_in_use then',
'  sys.htp.p(''<p />''||',
'  wwv_flow_lang.system_message(''F4050.SCHEMA_ASSIGNED''));',
'end if;',
'',
'if l_schema_cannot_be_assigned then',
'  sys.htp.p(''<p />''||',
'  wwv_flow_lang.system_message(''F4050.RESTRICTED_ADMIN''));',
'end if;',
'',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'l_schema wwv_flow_provision_company.schema_name%type;',
'l_schema_exists             boolean := false;',
'l_schema_in_use             boolean := false;',
'l_schema_restricted         boolean := false;',
'begin',
'',
'for c1 in (select upper(schema_name) sa1',
'    from wwv_flow_provision_company',
'    where id = :PROVISION_ID) loop',
'    l_schema := c1.sa1;',
'end loop;',
'',
'l_schema_exists := wwv_flow_security.get_db_user_or_role(p_username => l_schema) is not null;',
'',
'for c1 in (select 1 from wwv_flow_company_schemas ',
'  where schema = l_schema) loop',
'  l_schema_in_use := true;',
'end loop;',
'',
'for c1 in (select 1 from dual',
'  where wwv_flow_provisioning.reserved_schema_i(l_schema) = 1',
'  or wwv_flow_provisioning.restricted_schema_i(l_schema,:P4_COMPANY_NAME) = 1) loop',
'  l_schema_restricted := true;',
'end loop;',
'',
'return l_schema_exists or l_schema_in_use or l_schema_restricted ;',
'',
'end;'))
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(179796001715237593.4054)
,p_name=>'Aree di lavoro che utilizzano lo schema richiesto'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>40
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select short_name from wwv_flow_companies where provisioning_company_id in (select security_group_id from wwv_flow_company_schemas where schema = (',
' select upper(schema_name)',
'    from wwv_flow_provision_company',
'    where id = :PROVISION_ID))'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_company_schemas where schema = (',
' select upper(schema_name)',
'    from wwv_flow_provision_company',
'    where id = :PROVISION_ID)'))
,p_display_condition_type=>'EXISTS'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(6897002870390711.4054)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_query_asc_image=>'blue_arrow_down.gif'
,p_query_desc_image=>'blue_arrow_up.gif'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(179796231768237594.4054)
,p_query_column_id=>1
,p_column_alias=>'SHORT_NAME'
,p_column_display_sequence=>1
,p_column_heading=>'Area di lavoro'
,p_use_as_row_header=>'N'
,p_default_sort_column_sequence=>1
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(955890703465997318.4054)
,p_plug_name=>'pulsanti'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1433457275968958953.4054)
,p_name=>'Risposte indagine'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>60
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select     ',
'    survey_question_01,',
'    survey_answer_01,',
'    survey_question_02,',
'    survey_answer_02,',
'    survey_question_03,',
'    survey_answer_03,',
'    survey_question_04,',
'    survey_answer_04,',
'    survey_question_05,',
'    survey_answer_05,',
'    survey_question_06,',
'    survey_answer_06,',
'    survey_question_07,',
'    survey_answer_07,',
'    survey_question_08,',
'    survey_answer_08,',
'    survey_question_09,',
'    survey_answer_09,',
'    survey_question_10,',
'    survey_answer_10',
'from WWV_FLOW_PROVISION_COMPANY',
'where id = :provision_id'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null      ',
'from WWV_FLOW_PROVISION_COMPANY',
'where id = :provision_id and',
'    ( survey_answer_01 is not null or',
'      survey_answer_02 is not null or',
'      survey_answer_03 is not null or',
'      survey_answer_04 is not null or',
'      survey_answer_05 is not null or',
'      survey_answer_06 is not null or',
'      survey_answer_07 is not null or',
'      survey_answer_08 is not null or',
'      survey_answer_09 is not null or',
'      survey_answer_10 is not null )'))
,p_display_condition_type=>'EXISTS'
,p_ajax_items_to_submit=>'PROVISION_ID'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(805670753642677848.4054)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_break_cols=>'0'
,p_query_no_data_found=>'nessun dato trovato'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433457585099958965.4054)
,p_query_column_id=>1
,p_column_alias=>'SURVEY_QUESTION_01'
,p_column_display_sequence=>1
,p_column_heading=>'Domanda 1'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433457692977958969.4054)
,p_query_column_id=>2
,p_column_alias=>'SURVEY_ANSWER_01'
,p_column_display_sequence=>2
,p_column_heading=>'Risposta 1'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433457710480958969.4054)
,p_query_column_id=>3
,p_column_alias=>'SURVEY_QUESTION_02'
,p_column_display_sequence=>3
,p_column_heading=>'Domanda 2'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433457800100958969.4054)
,p_query_column_id=>4
,p_column_alias=>'SURVEY_ANSWER_02'
,p_column_display_sequence=>4
,p_column_heading=>'Risposta 2'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433457960885958969.4054)
,p_query_column_id=>5
,p_column_alias=>'SURVEY_QUESTION_03'
,p_column_display_sequence=>5
,p_column_heading=>'Domanda 3'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433458067626958969.4054)
,p_query_column_id=>6
,p_column_alias=>'SURVEY_ANSWER_03'
,p_column_display_sequence=>6
,p_column_heading=>'Risposta 3'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433458181108958970.4054)
,p_query_column_id=>7
,p_column_alias=>'SURVEY_QUESTION_04'
,p_column_display_sequence=>7
,p_column_heading=>'Domanda 4'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433458215472958970.4054)
,p_query_column_id=>8
,p_column_alias=>'SURVEY_ANSWER_04'
,p_column_display_sequence=>8
,p_column_heading=>'Risposta 4'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433458355035958970.4054)
,p_query_column_id=>9
,p_column_alias=>'SURVEY_QUESTION_05'
,p_column_display_sequence=>9
,p_column_heading=>'Domanda 5'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433458464778958970.4054)
,p_query_column_id=>10
,p_column_alias=>'SURVEY_ANSWER_05'
,p_column_display_sequence=>10
,p_column_heading=>'Risposta 5'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433458525808958970.4054)
,p_query_column_id=>11
,p_column_alias=>'SURVEY_QUESTION_06'
,p_column_display_sequence=>11
,p_column_heading=>'Domanda 6'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433458664310958970.4054)
,p_query_column_id=>12
,p_column_alias=>'SURVEY_ANSWER_06'
,p_column_display_sequence=>12
,p_column_heading=>'Risposta 6'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433458782369958971.4054)
,p_query_column_id=>13
,p_column_alias=>'SURVEY_QUESTION_07'
,p_column_display_sequence=>13
,p_column_heading=>'Domanda 7'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433458832624958971.4054)
,p_query_column_id=>14
,p_column_alias=>'SURVEY_ANSWER_07'
,p_column_display_sequence=>14
,p_column_heading=>'Risposta 7'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433458949321958971.4054)
,p_query_column_id=>15
,p_column_alias=>'SURVEY_QUESTION_08'
,p_column_display_sequence=>15
,p_column_heading=>'Domanda 8'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433459046464958971.4054)
,p_query_column_id=>16
,p_column_alias=>'SURVEY_ANSWER_08'
,p_column_display_sequence=>16
,p_column_heading=>'Risposta 8'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433459117563958971.4054)
,p_query_column_id=>17
,p_column_alias=>'SURVEY_QUESTION_09'
,p_column_display_sequence=>17
,p_column_heading=>'Domanda 9'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433459281317958971.4054)
,p_query_column_id=>18
,p_column_alias=>'SURVEY_ANSWER_09'
,p_column_display_sequence=>18
,p_column_heading=>'Risposta 9'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433459328870958971.4054)
,p_query_column_id=>19
,p_column_alias=>'SURVEY_QUESTION_10'
,p_column_display_sequence=>19
,p_column_heading=>'Domanda 10'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1433459404441958971.4054)
,p_query_column_id=>20
,p_column_alias=>'SURVEY_ANSWER_10'
,p_column_display_sequence=>20
,p_column_heading=>'Risposta 10'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(225165738087.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(955890703465997318.4054)
,p_button_name=>'DECLINE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372670814202760.4054)
,p_button_image_alt=>'Rifiuta'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:56:&SESSION.::&DEBUG.:56::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(200345928591.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(955890703465997318.4054)
,p_button_name=>'Approve'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372670814202760.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Approva'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:55:&SESSION.::&DEBUG.:55::'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare l_schema varchar2(30) := null;',
'begin',
'    for c1 in (select upper(schema_name) sa1',
'        from wwv_flow_provision_company',
'        where id = :PROVISION_ID) loop',
'        l_schema := c1.sa1;',
'    end loop;',
'    ',
'    if l_schema is not null then        ',
'        for c1 in (',
'          select 1 from dual',
'          where ',
'(wwv_flow_provisioning.reserved_schema_i(l_schema) = 1)',
' or',
'(wwv_flow_provisioning.restricted_schema_i(l_schema,:P4_COMPANY_NAME) = 1)) loop',
'            return false;',
'        end loop;',
'        return true;',
'    else',
'        return false;',
'    end if;',
'end;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(203403932651.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(955890703465997318.4054)
,p_button_name=>'Cancel'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(168826226311399329.4054)
,p_branch_action=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(183253903897.4054)
,p_name=>'PROVISION_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(173724892445.4054)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(48853112333141000.4054)
,p_name=>'P4_COMPANY_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(173724892445.4054)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(48857919699199941.4054)
,p_computation_sequence=>10
,p_computation_item=>'P4_COMPANY_NAME'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select company_name from wwv_flow_provision_company',
' where id = :PROVISION_ID'))
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Gestisci richieste'
,p_step_title=>'Gestisci richieste'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216800021154677630)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_ser_rqst.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6119928615239299.4054)
,p_plug_name=>'Informazioni'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Approvare o rifiutare le richieste di servizio effettuate dagli amministratori di area di lavoro</p>',
'<p><a target="_blank" href="&SYSTEM_HELP_URL./aeadm/managing-workspace-and-change-requests.html">Ulteriori informazioni...</a></p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168703709392622412.4054)
,p_plug_name=>'manage service requests'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(168703120343616153.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(169533626431592276.4054)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(363047307212822256.4054)
,p_plug_name=>'Richieste in sospeso'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>90
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>'sys.htp.p(''<p>'' || wwv_flow_lang.system_message(''INST_RUNNING_IN_MAN_MODE_4050'') || ''</p>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'nvl(wwv_flow_platform.get_preference(''SERVICE_REQUEST_FLOW''), ''MANUAL'') = ''MANUAL'''
,p_plug_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'--sys.htp.p(wwv_flow_workspace_reports.get_pending_requests(p_session_id => :app_session));',
''))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466784027754334318.4054)
,p_plug_name=>'Nuove richieste di servizio'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(721125879764730304.4054)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4050P5a */',
'    provision_link the_link,',
'    wwv_flow_lang.system_message(''REQUEST_WORKSPACE'',',
'        admin_email,',
'        workspace_name,',
'        request_size ) as the_request,',
'    request_date',
'from',
'(',
'select ',
'    ADMIN_EMAIL,',
'    COMPANY_NAME                         workspace_name,',
'    DATABASE_SIZE||''MB''                  request_size,',
'    request_date                         request_date,',
'    ''f?p=4050:4:''||:app_session||',
'       ''::NO::PROVISION_ID:''||id         provision_link',
'from WWV_FLOW_PROVISION_COMPANY',
'where project_status = ''REQUESTED''',
')',
'union',
'select ',
'        decode(m.request_status,',
'          ''REQUESTED'',''f?p=4050:110:''||:flow_session||',
'                      ''::NO:110:P110_REQUEST_ID,P110_SGID:''||m.id||'',''||',
'                      m.security_group_id,',
'          ''APPROVED'', ''f?p=4050:110:''||:flow_session||',
'                      ''::NO:110,RP:P110_REQUEST_ID,P110_SGID:''||m.id||'',''||',
'                      m.security_group_id) the_link,',
'          decode(m.service_name,',
'          ''NEW_SCHEMA'',wwv_flow_lang.system_message(',
'                 ''REQUEST_NEW_SCHEMA'',',
'                 m.REQUESTED_BY, ',
'                 c.short_name, ',
'                 m.service_attribute_1',
'                 ),',
'          ''CHANGE_DB_SIZE'',       wwv_flow_lang.system_message(',
'                          ''REQUEST_CHANGE_DB_SIZE'',',
'                          m.REQUESTED_BY, ',
'                          c.short_name, ',
'                          m.service_attribute_1||''MB''',
'                          ),',
'           c.short_name ||',
'           '' - ''||m.service_name || ',
'           '' - ''||m.service_attribute_1) as the_request,',
'         m.requested_on        request_date',
'    from wwv_flow_provision_serice_mod m, ',
'         wwv_flow_companies c',
'   where m.security_group_id = c.provisioning_company_id',
'             and   m.request_status = ''REQUESTED'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(466784129153334318.4054)
,p_name=>'New Service Requests'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('Questa query restituisce pi\00F9 di 10.000 righe. Filtrare i dati per ottenere risultati completi.')
,p_no_data_found_message=>'Nessun dato trovato.'
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'C'
,p_show_aggregate=>'N'
,p_show_group_by=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_detail_link=>'#THE_LINK#'
,p_detail_link_text=>'<span class="a-Icon icon-edit"></span>'
,p_detail_link_attr=>'class="a-Button a-Button--small a-Button--noLabel a-Button--withIcon a-Button--noUI"'
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(466784329387334331.4054)
,p_db_column_name=>'THE_REQUEST'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Richiesta di servizio'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(466784425269334336.4054)
,p_db_column_name=>'REQUEST_DATE'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Data della richiesta'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(472988616335136594.4054)
,p_db_column_name=>'THE_LINK'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Collegamento'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1080987107325523904.4054)
,p_name=>'Richieste in sospeso'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>80
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#:a-BadgeList--stacked:a-BadgeList--large'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_provisioning.total_open_service_requests new_services,',
'    wwv_flow_provisioning.total_open_change_requests service_change',
'from dual'))
,p_display_when_condition=>'nvl(wwv_flow_platform.get_preference(''SERVICE_REQUEST_FLOW''), ''MANUAL'') != ''MANUAL'''
,p_display_condition_type=>'PLSQL_EXPRESSION'
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(805663950138677747.4054)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
,p_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'--sys.htp.p(wwv_flow_workspace_reports.get_pending_requests(p_session_id => :app_session));',
''))
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1080987275465523905.4054)
,p_query_column_id=>1
,p_column_alias=>'NEW_SERVICES'
,p_column_display_sequence=>1
,p_column_heading=>'Nuovo servizio'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:RP,RIR:::'
,p_column_linktext=>'#NEW_SERVICES#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1080987374026523906.4054)
,p_query_column_id=>2
,p_column_alias=>'SERVICE_CHANGE'
,p_column_display_sequence=>2
,p_column_heading=>'Modifica di servizio'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:RP,RIR:::'
,p_column_linktext=>'#SERVICE_CHANGE#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(484348231779602259.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(466784027754334318.4054)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Reimposta'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:5,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(202780809310222232.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(466784027754334318.4054)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372670814202760.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea area di lavoro'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:27,79,72,73,74::'
,p_icon_css_classes=>'icon-right-chevron'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(357640393972810948.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(466784027754334318.4054)
,p_button_name=>'CREATE_ATP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517849275695867600.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea area di lavoro'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.:142:LAST_VIEW:5'
,p_icon_css_classes=>'icon-right-chevron'
,p_required_patch=>-wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(168507612620814711.4054)
,p_computation_sequence=>10
,p_computation_item=>'LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'5'
);
end;
/
prompt --application/pages/page_00006
begin
wwv_flow_api.create_page(
 p_id=>6.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Richiesta di fornitura'
,p_step_title=>'Richiesta di fornitura'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216766430018595041)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>'AEADM/adm_ser_rqst.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(225183790487.4054)
,p_plug_name=>'Dettagli richiesta'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows=>15
,p_plug_column_width=>'valign="top"'
,p_plug_query_show_nulls_as=>'(null)'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'generated 23-FEB-2001 17:53:48'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(225294842695.4054)
,p_plug_name=>'Modifica richiesta'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Modificare la richiesta di area di lavoro corrente.</p>',
'<p>Fare clic sul pulsante <b>Applica modifiche</b>, se presente, per salvare le modifiche. Fare clic sul pulsante <b>Cessa o elimina</b>, se presente, per interrompere la richiesta. Fare clic sul pulsante <b>Elimina</b>, se presente, per eliminare la'
||' richiesta.</p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS_INITCAP'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'ROWS_X_TO_Y_OF_Z'
,p_plug_column_width=>'valign="top" align="right"'
,p_plug_query_show_nulls_as=>'(null)'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(195699107817256786.4054)
,p_plug_name=>'Modifica richiesta di fornitura'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder:a-ButtonRegion--showTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(225186790489.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(195699107817256786.4054)
,p_button_name=>'Cancel'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2934116575079521.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(195699107817256786.4054)
,p_button_name=>'Terminate_or_Delete'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Cessa o elimina'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'',
'from wwv_flow_provision_company',
'',
'where id = :F4050_P6_ID',
'',
'and project_status = ''APPROVED'''))
,p_button_condition_type=>'EXISTS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(52722223258062562.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(195699107817256786.4054)
,p_button_name=>'Delete'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Elimina'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.::D_PROVISION_ID:&F4050_P6_ID.'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'',
'from wwv_flow_provision_company',
'',
'where id = :F4050_P6_ID',
'',
'and project_status = ''APPROVED'''))
,p_button_condition_type=>'NOT_EXISTS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(225190790490.4054)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(195699107817256786.4054)
,p_button_name=>'Apply_Changes'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'F4050_P6_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(135407227774354772.4054)
,p_branch_action=>'f?p=&FLOW_ID.:81:&SESSION.::&DEBUG.:81,82:P81_COMPANY:&F4050_P6_COMPANY_NAME.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(2934116575079521.4054)
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(225180790486.4054)
,p_branch_action=>'26'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>20
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(225182790487.4054)
,p_branch_action=>'26'
,p_branch_point=>'BEFORE_VALIDATION'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>30
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'Cancel'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225194790494.4054)
,p_name=>'F4050_P6_ID'
,p_item_sequence=>260
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225196790494.4054)
,p_name=>'F4050_P6_SECURITY_GROUP_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'SECURITY_GROUP_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225198790495.4054)
,p_name=>'F4050_P6_COMPANY_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Area di lavoro'
,p_source=>'COMPANY_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133598269759785.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Immettere un''area di lavoro.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225200790495.4054)
,p_name=>'F4050_P6_ADMIN_FIRST_NAME'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nome amministratore'
,p_source=>'ADMIN_FIRST_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Immettere il nome.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225202790496.4054)
,p_name=>'F4050_P6_ADMIN_LAST_NAME'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Cognome amministratore'
,p_source=>'ADMIN_LAST_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Immettere il cognome.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225204790497.4054)
,p_name=>'F4050_P6_ADMIN_TITLE'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'ADMIN_TITLE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225206790497.4054)
,p_name=>'F4050_P6_ADMIN_EMAIL'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Posta elettronica amministratore'
,p_source=>'ADMIN_EMAIL'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133598269759785.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Immettere l''indirizzo di posta elettronica.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'EMAIL'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225208790498.4054)
,p_name=>'F4050_P6_ADMIN_PHONE'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'ADMIN_PHONE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225210790498.4054)
,p_name=>'F4050_P6_ADMIN_USERID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'ID utente amministratore'
,p_source=>'ADMIN_USERID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133598269759785.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Identificare l''ID utente dell''amministratore.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225212790499.4054)
,p_name=>'F4050_P6_COMPANY_ADDRESS'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'COMPANY_ADDRESS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225214790500.4054)
,p_name=>'F4050_P6_CITY'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'CITY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225216790500.4054)
,p_name=>'F4050_P6_STATE'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'STATE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225218790501.4054)
,p_name=>'F4050_P6_ZIP'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'ZIP'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225220790501.4054)
,p_name=>'F4050_P6_COUNTRY'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'COUNTRY'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225222790502.4054)
,p_name=>'F4050_P6_COMPANY_TYPE'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'COMPANY_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225236790507.4054)
,p_name=>'F4050_P6_SERVICE_USE_STATUS'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'SERVICE_USE_STATUS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225238790508.4054)
,p_name=>'F4050_P6_DATABASE_SIZE'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Dimensioni database'
,p_source=>'DATABASE_SIZE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Identificare le dimensioni del database.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225240790509.4054)
,p_name=>'F4050_P6_SERVICE_START_DATE'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'SERVICE_START_DATE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Identificare la data di inizio del servizio.'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225242790509.4054)
,p_name=>'F4050_P6_SERVICE_TERMINATION_DATE'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'SERVICE_TERMINATION_DATE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Identificare la data di cessazione del servizio.'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225244790510.4054)
,p_name=>'F4050_P6_SCHEMA_NAME'
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nome schema'
,p_source=>'SCHEMA_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select username d,',
'       username r',
'  from wwv_flow_admin_all_schemas s',
' where (   restricted_to_workspace is null',
'        or restricted_to_workspace = upper(:F4050_P6_COMPANY_NAME))',
' order by 1'))
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133598269759785.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_input=>'N'
,p_help_text=>'Identificare il nome dello schema.'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_03=>'N'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225250790511.4054)
,p_name=>'F4050_P6_PROJECT_DESCRIPTION'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Descrizione progetto'
,p_source=>'PROJECT_DESCRIPTION'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Identificare la descrizione del progetto.'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225254790513.4054)
,p_name=>'F4050_P6_PROJECT_APPROVAL_DATE'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'PROJECT_APPROVAL_DATE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Identifica la data di approvazione.'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225256790513.4054)
,p_name=>'F4050_P6_PROJECT_ACTUAL_BEGIN_DATE'
,p_item_sequence=>230
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'PROJECT_ACTUAL_BEGIN_DATE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Identifica la data di fornitura.'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(225260790515.4054)
,p_name=>'F4050_P6_PROJECT_STATUS'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(225183790487.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Stato progetto:'
,p_source=>'PROJECT_STATUS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'SERVICE.REQUEST.STATUS'
,p_lov=>'.'||wwv_flow_api.id(87755726864223308.4054)||'.'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Identificare lo stato del progetto.'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(183384800804268476.4054)
,p_validation_name=>'schema not restricted'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if (wwv_flow_provisioning.site_admin_is_restricted and',
'     wwv_flow_provisioning.restricted_schema(',
'         p_schema => upper(:F4050_P6_SCHEMA_NAME),',
'         p_workspace_name => upper(:F4050_P6_COMPANY_NAME)',
'         )) then',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Lo schema richiesto \00E8 limitato. Impossibile assegnare schemi limitati alle aree di lavoro.')
,p_when_button_pressed=>wwv_flow_api.id(225190790490.4054)
,p_associated_item=>wwv_flow_api.id(225244790510.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(183404521151643333.4054)
,p_validation_name=>'schema not reserved'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_provisioning.reserved_schema(p_schema =>   ',
'    upper(:F4050_P6_SCHEMA_NAME)) then',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('Lo schema richiesto \00E8 riservato.')
,p_when_button_pressed=>wwv_flow_api.id(225190790490.4054)
,p_associated_item=>wwv_flow_api.id(.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(225264790516.4054)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_PROVISION_COMPANY'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_PROVISION_COMPANY'
,p_attribute_03=>'F4050_P6_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>'Errore durante il recupero della riga.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(225266790517.4054)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_PROVISION_COMPANY'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_PROVISION_COMPANY'
,p_attribute_03=>'F4050_P6_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'U'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>'Errore durante l''elaborazione della riga.'
,p_process_when_button_id=>wwv_flow_api.id(225190790490.4054)
,p_process_success_message=>'Azione elaborata.'
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Adegua richiesta'
,p_step_title=>'Adegua richiesta'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216766430018595041)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>'AEADM/adm_create_wkspc.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(43187720190328736.4054)
,p_plug_name=>'Modifica stato attributo fornitura'
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS_INITCAP'
,p_plug_query_num_rows=>5
,p_plug_query_num_rows_type=>'ROWS_X_TO_Y_OF_Z'
,p_plug_column_width=>'valign="top"'
,p_plug_query_show_nulls_as=>'(null)'
,p_plug_footer=>unistr('<div class="htmldbInstructionText">Le informazioni riportate sopra provengono dalla richiesta di area di lavoro. Il nome effettivo dell''area di lavoro e altri attributi possono essere differenti per un utente fornito. Questa \00E8 solo la richiesta.</div')
||'>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'generated 16-MAR-2001 18:11:26'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(43202121056423198.4054)
,p_plug_name=>'Modifica stato'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Questa pagina consente agli amministratori dell''area di lavoro di modificare lo stato di una richiesta di area di lavoro.</p>',
unistr('<p>Reimpostandola su <b>Richiesta</b>, \00E8 possibile fornire nuovamente un''area di lavoro.</p>'),
'<p><b>Nota:</b> fare attenzione quando si imposta lo stato del progetto su <b>Richiesta</b>. Sebbene consenta di fornire nuovamente un''area di lavoro, tale impostazione potrebbe provocare danni ai dati, a causa del modo in cui gli account vengono for'
||'niti. Il sistema di fornitura presuppone che le richieste di area di lavoro con stato <b>Richiesta</b>, non abbiano schemi e voci di dizionario corrispondenti a un amministratore dell''area di lavoro o agli sviluppatori. Se si desidera modificare lo s'
||'tato del progetto per un''area di lavoro <b>Approvata</b> in <b>Richiesta</b>, arrestare prima l''area di lavoro, quindi modificare lo stato in <b>Richiesta</b>.</p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS_INITCAP'
,p_plug_query_num_rows=>5
,p_plug_query_num_rows_type=>'ROWS_X_TO_Y_OF_Z'
,p_plug_column_width=>'valign="top" align="right"'
,p_plug_query_show_nulls_as=>'(null)'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(48679045286466446.4054)
,p_name=>'Report sulle richieste di fornitura'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>30
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'    ID,',
'    SECURITY_GROUP_ID,',
'    COMPANY_NAME,',
'    ADMIN_FIRST_NAME,',
'    ADMIN_LAST_NAME,',
'    ADMIN_TITLE,',
'    ADMIN_EMAIL,',
'    ADMIN_PHONE,',
'    ADMIN_ID,',
'    ADMIN_USERID,',
'    COMPANY_ADDRESS,',
'    CITY,',
'    STATE,',
'    ZIP,',
'    COUNTRY,',
'    SERVICE_USE_STATUS,',
'    DATABASE_SIZE,',
'    SERVICE_START_DATE,',
'    SERVICE_TERMINATION_DATE,',
'    SCHEMA_NAME,',
'    ESTIMATED_END_USERS,',
'    PAGE_VIEWS_PER_DAY,',
'    PROJECT_DESCRIPTION,',
'    PROJECT_JUSTIFICATION,',
'    PROJECT_STATUS,',
'    REQUEST_DATE,',
'   SURVEY_QUESTION_01,',
'    SURVEY_ANSWER_01,',
'    SURVEY_QUESTION_02,',
'    SURVEY_ANSWER_02,',
'    SURVEY_QUESTION_03,',
'    SURVEY_ANSWER_03,',
'    SURVEY_QUESTION_04,',
'    SURVEY_ANSWER_04,',
'    SURVEY_QUESTION_05,',
'    SURVEY_ANSWER_05,',
'    SURVEY_QUESTION_06,',
'    SURVEY_ANSWER_06,',
'    SURVEY_QUESTION_07,',
'    SURVEY_ANSWER_07,',
'    SURVEY_QUESTION_08,',
'    SURVEY_ANSWER_08,',
'    SURVEY_QUESTION_09,',
'    SURVEY_ANSWER_09,',
'    SURVEY_QUESTION_10,',
'    SURVEY_ANSWER_10,',
'    AGREEMENT_ACCEPTANCE_DATE,',
'    AGREEMENT_NAME,',
'    AGREEMENT_USER_ENV',
'from WWV_FLOW_PROVISION_COMPANY',
'where id = :T_PROVISION_ID'))
,p_fixed_header=>'NONE'
,p_query_row_template=>2
,p_query_num_rows=>5
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'(null)'
,p_query_break_cols=>'0'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_query_asc_image=>'blue_arrow_down.gif'
,p_query_desc_image=>'blue_arrow_up.gif'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48556132422770818.4054)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>2
,p_column_heading=>'ID'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48556223377770818.4054)
,p_query_column_id=>2
,p_column_alias=>'SECURITY_GROUP_ID'
,p_column_display_sequence=>1
,p_column_heading=>'Area di lavoro'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48556324615770818.4054)
,p_query_column_id=>3
,p_column_alias=>'COMPANY_NAME'
,p_column_display_sequence=>3
,p_column_heading=>'Nome area di lavoro'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48556402156770818.4054)
,p_query_column_id=>4
,p_column_alias=>'ADMIN_FIRST_NAME'
,p_column_display_sequence=>4
,p_column_heading=>'Nome'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48556509895770818.4054)
,p_query_column_id=>5
,p_column_alias=>'ADMIN_LAST_NAME'
,p_column_display_sequence=>5
,p_column_heading=>'Cognome'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48556604610770818.4054)
,p_query_column_id=>6
,p_column_alias=>'ADMIN_TITLE'
,p_column_display_sequence=>6
,p_column_heading=>'Titolo'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48556719143770818.4054)
,p_query_column_id=>7
,p_column_alias=>'ADMIN_EMAIL'
,p_column_display_sequence=>7
,p_column_heading=>'Posta elettronica'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48556819251770818.4054)
,p_query_column_id=>8
,p_column_alias=>'ADMIN_PHONE'
,p_column_display_sequence=>8
,p_column_heading=>'Telefono'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48556903983770819.4054)
,p_query_column_id=>9
,p_column_alias=>'ADMIN_ID'
,p_column_display_sequence=>9
,p_column_heading=>'ID amministratore'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48557019200770819.4054)
,p_query_column_id=>10
,p_column_alias=>'ADMIN_USERID'
,p_column_display_sequence=>10
,p_column_heading=>'Utente amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48557116708770819.4054)
,p_query_column_id=>11
,p_column_alias=>'COMPANY_ADDRESS'
,p_column_display_sequence=>11
,p_column_heading=>'Indirizzo'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48557212730770819.4054)
,p_query_column_id=>12
,p_column_alias=>'CITY'
,p_column_display_sequence=>12
,p_column_heading=>unistr('Citt\00E0')
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48557300303770819.4054)
,p_query_column_id=>13
,p_column_alias=>'STATE'
,p_column_display_sequence=>13
,p_column_heading=>'Stato'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48557417190770819.4054)
,p_query_column_id=>14
,p_column_alias=>'ZIP'
,p_column_display_sequence=>14
,p_column_heading=>'CAP'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48557531161770819.4054)
,p_query_column_id=>15
,p_column_alias=>'COUNTRY'
,p_column_display_sequence=>15
,p_column_heading=>'Paese'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48558301343770820.4054)
,p_query_column_id=>16
,p_column_alias=>'SERVICE_USE_STATUS'
,p_column_display_sequence=>16
,p_column_heading=>'Stato di uso dell''area di lavoro'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48558416989770820.4054)
,p_query_column_id=>17
,p_column_alias=>'DATABASE_SIZE'
,p_column_display_sequence=>17
,p_column_heading=>'Dimensioni database'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48558502328770820.4054)
,p_query_column_id=>18
,p_column_alias=>'SERVICE_START_DATE'
,p_column_display_sequence=>18
,p_column_heading=>'Data di inizio dell''area di lavoro'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48558608436770821.4054)
,p_query_column_id=>19
,p_column_alias=>'SERVICE_TERMINATION_DATE'
,p_column_display_sequence=>19
,p_column_heading=>'Data di cessazione dell''area di lavoro'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48558732412770821.4054)
,p_query_column_id=>20
,p_column_alias=>'SCHEMA_NAME'
,p_column_display_sequence=>20
,p_column_heading=>'Nome schema'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48558828706770821.4054)
,p_query_column_id=>21
,p_column_alias=>'ESTIMATED_END_USERS'
,p_column_display_sequence=>21
,p_column_heading=>'Utenti finali stimati'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48558926502770821.4054)
,p_query_column_id=>22
,p_column_alias=>'PAGE_VIEWS_PER_DAY'
,p_column_display_sequence=>22
,p_column_heading=>'Visualizzazioni di pagina per giorno'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48559028941770821.4054)
,p_query_column_id=>23
,p_column_alias=>'PROJECT_DESCRIPTION'
,p_column_display_sequence=>23
,p_column_heading=>'Descrizione progetto'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48559105122770821.4054)
,p_query_column_id=>24
,p_column_alias=>'PROJECT_JUSTIFICATION'
,p_column_display_sequence=>24
,p_column_heading=>'Giustificazione progetto'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48559505641770822.4054)
,p_query_column_id=>25
,p_column_alias=>'PROJECT_STATUS'
,p_column_display_sequence=>25
,p_column_heading=>'Stato progetto'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(316820619150159698)
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48559715673770822.4054)
,p_query_column_id=>26
,p_column_alias=>'REQUEST_DATE'
,p_column_display_sequence=>26
,p_column_heading=>'Data richiesta'
,p_column_format=>'&DATE_TIME_FORMAT.'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127233300885112327.4054)
,p_query_column_id=>27
,p_column_alias=>'SURVEY_QUESTION_01'
,p_column_display_sequence=>27
,p_column_heading=>'Domanda 1 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127233418541112327.4054)
,p_query_column_id=>28
,p_column_alias=>'SURVEY_ANSWER_01'
,p_column_display_sequence=>28
,p_column_heading=>'Risposta 1 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127233515172112327.4054)
,p_query_column_id=>29
,p_column_alias=>'SURVEY_QUESTION_02'
,p_column_display_sequence=>29
,p_column_heading=>'Domanda 2 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127233615113112327.4054)
,p_query_column_id=>30
,p_column_alias=>'SURVEY_ANSWER_02'
,p_column_display_sequence=>30
,p_column_heading=>'Risposta 2 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127233706102112327.4054)
,p_query_column_id=>31
,p_column_alias=>'SURVEY_QUESTION_03'
,p_column_display_sequence=>31
,p_column_heading=>'Domanda 3 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127233801078112327.4054)
,p_query_column_id=>32
,p_column_alias=>'SURVEY_ANSWER_03'
,p_column_display_sequence=>32
,p_column_heading=>'Risposta 3 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127233932661112327.4054)
,p_query_column_id=>33
,p_column_alias=>'SURVEY_QUESTION_04'
,p_column_display_sequence=>33
,p_column_heading=>'Domanda 4 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127234021629112327.4054)
,p_query_column_id=>34
,p_column_alias=>'SURVEY_ANSWER_04'
,p_column_display_sequence=>34
,p_column_heading=>'Risposta 4 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127234122858112327.4054)
,p_query_column_id=>35
,p_column_alias=>'SURVEY_QUESTION_05'
,p_column_display_sequence=>35
,p_column_heading=>'Domanda 5 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127234232119112327.4054)
,p_query_column_id=>36
,p_column_alias=>'SURVEY_ANSWER_05'
,p_column_display_sequence=>36
,p_column_heading=>'Risposta 5 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127234323875112327.4054)
,p_query_column_id=>37
,p_column_alias=>'SURVEY_QUESTION_06'
,p_column_display_sequence=>37
,p_column_heading=>'Domanda 6 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127234415961112327.4054)
,p_query_column_id=>38
,p_column_alias=>'SURVEY_ANSWER_06'
,p_column_display_sequence=>38
,p_column_heading=>'Risposta 6 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127234512307112327.4054)
,p_query_column_id=>39
,p_column_alias=>'SURVEY_QUESTION_07'
,p_column_display_sequence=>39
,p_column_heading=>'Domanda 7 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127234601873112328.4054)
,p_query_column_id=>40
,p_column_alias=>'SURVEY_ANSWER_07'
,p_column_display_sequence=>40
,p_column_heading=>'Risposta 7 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127234717583112328.4054)
,p_query_column_id=>41
,p_column_alias=>'SURVEY_QUESTION_08'
,p_column_display_sequence=>41
,p_column_heading=>'Domanda 8 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127234801062112328.4054)
,p_query_column_id=>42
,p_column_alias=>'SURVEY_ANSWER_08'
,p_column_display_sequence=>42
,p_column_heading=>'Risposta 8 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127234916016112328.4054)
,p_query_column_id=>43
,p_column_alias=>'SURVEY_QUESTION_09'
,p_column_display_sequence=>43
,p_column_heading=>'Domanda 9 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127235000735112328.4054)
,p_query_column_id=>44
,p_column_alias=>'SURVEY_ANSWER_09'
,p_column_display_sequence=>44
,p_column_heading=>'Risposta 9 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127235111807112328.4054)
,p_query_column_id=>45
,p_column_alias=>'SURVEY_QUESTION_10'
,p_column_display_sequence=>45
,p_column_heading=>'Domanda 10 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127235211618112328.4054)
,p_query_column_id=>46
,p_column_alias=>'SURVEY_ANSWER_10'
,p_column_display_sequence=>46
,p_column_heading=>'Risposta 10 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127235322684112328.4054)
,p_query_column_id=>47
,p_column_alias=>'AGREEMENT_ACCEPTANCE_DATE'
,p_column_display_sequence=>47
,p_column_heading=>'Data di accettazione dell''accordo'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127235407487112328.4054)
,p_query_column_id=>48
,p_column_alias=>'AGREEMENT_NAME'
,p_column_display_sequence=>48
,p_column_heading=>'Nome accordo'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(127235506714112328.4054)
,p_query_column_id=>49
,p_column_alias=>'AGREEMENT_USER_ENV'
,p_column_display_sequence=>49
,p_column_heading=>'Amb. utente di accordo'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168823108472356352.4054)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(227262248958.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(168823108472356352.4054)
,p_button_name=>'Cancel'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(43186036285311765.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(168823108472356352.4054)
,p_button_name=>'Apply_Changes'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'(:T_PROVISION_ID is not null)'
,p_button_condition_type=>'PLSQL_EXPRESSION'
,p_button_cattributes=>'class="button10"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(23895428675298516.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(168823108472356352.4054)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Elimina'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'F4050_P26_STATUS'
,p_button_condition2=>'ACCEPTED'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(168825819600387963.4054)
,p_branch_action=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(227275281088.4054)
,p_name=>'T_PROVISION_ID'
,p_item_sequence=>10
,p_prompt=>'<b>New Service Provisioning Request ID</b>:'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3143616388404027.4054)
,p_name=>'F4050_P7_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(43187720190328736.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'ID richiesta:'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Numero di ID della richiesta di fornitura.'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3147132094442338.4054)
,p_name=>'F4050_P7_SECURITY_GROUP_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(43187720190328736.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'ID gruppo di sicurezza (identifica l''area di lavoro)'
,p_source=>'SECURITY_GROUP_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Numero di ID dell''area di lavoro fornita.'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3149427134444600.4054)
,p_name=>'F4050_P7_COMPANY_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(43187720190328736.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Area di lavoro:'
,p_source=>'COMPANY_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Nome dell''area di lavoro.'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3151719586448120.4054)
,p_name=>'F4050_P7_ADMIN_EMAIL'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(43187720190328736.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Posta elettronica amministratore:'
,p_source=>'ADMIN_EMAIL'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Indirizzo di posta elettronica dell''amministratore dell''area di lavoro.'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3154014626450405.4054)
,p_name=>'F4050_P7_SCHEMA_NAME'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(43187720190328736.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nome schema:'
,p_source=>'SCHEMA_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Schema da fornire.'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3156308803453087.4054)
,p_name=>'F4050_P7_PROJECT_STATUS'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(43187720190328736.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Stato progetto'
,p_source=>'PROJECT_STATUS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'SERVICE.REQUEST.STATUS'
,p_lov=>'.'||wwv_flow_api.id(87755726864223308.4054)||'.'
,p_cHeight=>1
,p_read_only_when=>'F4050_P7_PROJECT_STATUS'
,p_read_only_when2=>'TERMINATED'
,p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>'Stato del progetto.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(52855125454514117.4054)
,p_name=>'F4050_P7_PREV_PROJ_STATUS'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(43187720190328736.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'F4050_P7_PREV_PROJ_STATUS'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select project_status',
'',
'from wwv_flow_provision_company',
'',
'where id = :F4050_P7_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(52862315508549089.4054)
,p_validation_name=>'status error'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :F4050_P7_PREV_PROJ_STATUS = ''APPROVED'' then',
'  if :F4050_P7_PROJECT_STATUS = ''TERMINATED'' then',
'    return true;',
'  else',
'    return false;',
'  end if;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\00C8 possibile soltanto cessare un servizio approvato. Le altre modifiche di stato provocheranno il danneggiamento dei dati.')
,p_when_button_pressed=>wwv_flow_api.id(43186036285311765.4054)
,p_associated_item=>wwv_flow_api.id(3156308803453087.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(43195820508328757.4054)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_PROVISION_COMPANY'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_PROVISION_COMPANY'
,p_attribute_03=>'T_PROVISION_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>'Errore durante il recupero della riga.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(43196090106328758.4054)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_PROVISION_COMPANY'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_PROVISION_COMPANY'
,p_attribute_03=>'T_PROVISION_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>'Errore durante l''elaborazione della riga.'
,p_process_when_button_id=>wwv_flow_api.id(43186036285311765.4054)
,p_process_when=>'F4050_P7_PROJECT_STATUS'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_process_when2=>'TERMINATED'
,p_process_success_message=>'Azione elaborata.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(52670212528973146.4054)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'terminate service'
,p_process_sql_clob=>'wwv_flow_provisioning.terminate_service(p_id=>:F4050_P7_ID);'
,p_process_error_message=>'Errore durante la cessazione del servizio.'
,p_process_when_button_id=>wwv_flow_api.id(43186036285311765.4054)
,p_process_when=>'F4050_P7_PROJECT_STATUS'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'TERMINATED'
,p_process_success_message=>'Servizio cessato.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(22250501311969152.4054)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete service'
,p_process_sql_clob=>'wwv_flow_provisioning.delete_accepted_request(p_id=>:F4050_P7_ID);'
,p_process_error_message=>'Errore durante l''eliminazione del servizio.'
,p_process_when_button_id=>wwv_flow_api.id(23895428675298516.4054)
,p_process_when=>'F4050_P26_STATUS'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'ACCEPTED'
,p_process_success_message=>'Servizio eliminato.'
);
end;
/
prompt --application/pages/page_00008
begin
wwv_flow_api.create_page(
 p_id=>8.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Elimina richiesta'
,p_step_title=>'Elimina richiesta'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216766430018595041)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>'AEADM/adm_create_wkspc.htm'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(2842620068855323.4054)
,p_name=>'Richiesta di fornitura'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>40
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>'select * from wwv_flow_provision_company where id = :D_PROVISION_ID'
,p_fixed_header=>'NONE'
,p_query_row_template=>2
,p_query_num_rows=>5
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'(null)'
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image=>'blue_arrow_down.gif'
,p_query_desc_image=>'blue_arrow_up.gif'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48631213889771330.4054)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_column_heading=>'ID'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48631331903771330.4054)
,p_query_column_id=>2
,p_column_alias=>'SECURITY_GROUP_ID'
,p_column_display_sequence=>2
,p_column_heading=>'Area di lavoro'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48631423316771330.4054)
,p_query_column_id=>3
,p_column_alias=>'COMPANY_NAME'
,p_column_display_sequence=>3
,p_column_heading=>'Nome area di lavoro'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48631502805771331.4054)
,p_query_column_id=>4
,p_column_alias=>'ADMIN_FIRST_NAME'
,p_column_display_sequence=>4
,p_column_heading=>'Nome amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48631615946771331.4054)
,p_query_column_id=>5
,p_column_alias=>'ADMIN_LAST_NAME'
,p_column_display_sequence=>5
,p_column_heading=>'Cognome amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48631701678771331.4054)
,p_query_column_id=>6
,p_column_alias=>'ADMIN_TITLE'
,p_column_display_sequence=>6
,p_column_heading=>'Mansioni amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48631811461771331.4054)
,p_query_column_id=>7
,p_column_alias=>'ADMIN_EMAIL'
,p_column_display_sequence=>7
,p_column_heading=>'Posta elettronica amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48631925591771331.4054)
,p_query_column_id=>8
,p_column_alias=>'ADMIN_PHONE'
,p_column_display_sequence=>8
,p_column_heading=>'Telefono amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48632024673771331.4054)
,p_query_column_id=>9
,p_column_alias=>'ADMIN_ID'
,p_column_display_sequence=>9
,p_column_heading=>'Amministratore'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48632117814771331.4054)
,p_query_column_id=>10
,p_column_alias=>'ADMIN_USERID'
,p_column_display_sequence=>10
,p_column_heading=>'ID utente amministratore'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48632218354771331.4054)
,p_query_column_id=>11
,p_column_alias=>'COMPANY_ADDRESS'
,p_column_display_sequence=>11
,p_column_heading=>unistr('Indirizzo societ\00E0')
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48632328727771331.4054)
,p_query_column_id=>12
,p_column_alias=>'CITY'
,p_column_display_sequence=>12
,p_column_heading=>unistr('Citt\00E0')
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48632405878771332.4054)
,p_query_column_id=>13
,p_column_alias=>'STATE'
,p_column_display_sequence=>13
,p_column_heading=>'Stato'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48632521698771332.4054)
,p_query_column_id=>14
,p_column_alias=>'ZIP'
,p_column_display_sequence=>14
,p_column_heading=>'CAP'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48632632685771332.4054)
,p_query_column_id=>15
,p_column_alias=>'COUNTRY'
,p_column_display_sequence=>15
,p_column_heading=>'Paese'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48632706380771332.4054)
,p_query_column_id=>16
,p_column_alias=>'COMPANY_TYPE'
,p_column_display_sequence=>16
,p_column_heading=>unistr('Tipo di societ\00E0')
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48632818574771332.4054)
,p_query_column_id=>17
,p_column_alias=>'COMPANY_WEBSITE'
,p_column_display_sequence=>17
,p_column_heading=>unistr('Sito Web societ\00E0')
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48632908699771332.4054)
,p_query_column_id=>18
,p_column_alias=>'NUMBER_OF_EMPLOYEES'
,p_column_display_sequence=>18
,p_column_heading=>'Numero di dipendenti'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48633014812771332.4054)
,p_query_column_id=>19
,p_column_alias=>'COMPANY_PHONE'
,p_column_display_sequence=>19
,p_column_heading=>unistr('Telefono societ\00E0')
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48633113309771332.4054)
,p_query_column_id=>20
,p_column_alias=>'COMPANY_FAX'
,p_column_display_sequence=>20
,p_column_heading=>unistr('Fax societ\00E0')
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48633231303771332.4054)
,p_query_column_id=>21
,p_column_alias=>'ORACLE_PARTNER'
,p_column_display_sequence=>21
,p_column_heading=>'Partner di Oracle'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48633303328771333.4054)
,p_query_column_id=>22
,p_column_alias=>'HOW_DID_YOU_HEAR_ABOUT_US'
,p_column_display_sequence=>22
,p_column_heading=>'Come ha saputo di noi'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48633407898771333.4054)
,p_query_column_id=>23
,p_column_alias=>'SERVICE_USE_STATUS'
,p_column_display_sequence=>23
,p_column_heading=>'Stato di uso dell''area di lavoro'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48633520261771333.4054)
,p_query_column_id=>24
,p_column_alias=>'DATABASE_SIZE'
,p_column_display_sequence=>24
,p_column_heading=>'Dimensioni database'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236237917010177041.4054)
,p_query_column_id=>25
,p_column_alias=>'DATABASE_INITIAL_SIZE'
,p_column_display_sequence=>38
,p_column_heading=>'Dimensione iniziale database'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48633625766771333.4054)
,p_query_column_id=>26
,p_column_alias=>'SERVICE_START_DATE'
,p_column_display_sequence=>25
,p_column_heading=>'Data di inizio dell''area di lavoro'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48633723979771333.4054)
,p_query_column_id=>27
,p_column_alias=>'SERVICE_TERMINATION_DATE'
,p_column_display_sequence=>26
,p_column_heading=>'Data di cessazione dell''area di lavoro'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48633823851771333.4054)
,p_query_column_id=>28
,p_column_alias=>'SCHEMA_NAME'
,p_column_display_sequence=>27
,p_column_heading=>'Nome schema'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48633922599771333.4054)
,p_query_column_id=>29
,p_column_alias=>'ESTIMATED_END_USERS'
,p_column_display_sequence=>28
,p_column_heading=>'Utenti finali stimati'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48634022185771333.4054)
,p_query_column_id=>30
,p_column_alias=>'PAGE_VIEWS_PER_DAY'
,p_column_display_sequence=>29
,p_column_heading=>'Visualizzazioni di pagina per giorno'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236238009656177041.4054)
,p_query_column_id=>31
,p_column_alias=>'SURVEY_QUESTION_01'
,p_column_display_sequence=>39
,p_column_heading=>'Domanda 1 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236238124332177041.4054)
,p_query_column_id=>32
,p_column_alias=>'SURVEY_ANSWER_01'
,p_column_display_sequence=>40
,p_column_heading=>'Risposta 1 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236238225708177041.4054)
,p_query_column_id=>33
,p_column_alias=>'SURVEY_QUESTION_02'
,p_column_display_sequence=>41
,p_column_heading=>'Domanda 2 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236238319647177041.4054)
,p_query_column_id=>34
,p_column_alias=>'SURVEY_ANSWER_02'
,p_column_display_sequence=>42
,p_column_heading=>'Risposta 2 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236238404563177041.4054)
,p_query_column_id=>35
,p_column_alias=>'SURVEY_QUESTION_03'
,p_column_display_sequence=>43
,p_column_heading=>'Domanda 3 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236238510917177041.4054)
,p_query_column_id=>36
,p_column_alias=>'SURVEY_ANSWER_03'
,p_column_display_sequence=>44
,p_column_heading=>'Risposta 3 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236238617141177041.4054)
,p_query_column_id=>37
,p_column_alias=>'SURVEY_QUESTION_04'
,p_column_display_sequence=>45
,p_column_heading=>'Domanda 4 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236238722774177041.4054)
,p_query_column_id=>38
,p_column_alias=>'SURVEY_ANSWER_04'
,p_column_display_sequence=>46
,p_column_heading=>'Risposta 4 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236238832744177041.4054)
,p_query_column_id=>39
,p_column_alias=>'SURVEY_QUESTION_05'
,p_column_display_sequence=>47
,p_column_heading=>'Domanda 5 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236238918528177041.4054)
,p_query_column_id=>40
,p_column_alias=>'SURVEY_ANSWER_05'
,p_column_display_sequence=>48
,p_column_heading=>'Risposta 5 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236239032365177041.4054)
,p_query_column_id=>41
,p_column_alias=>'SURVEY_QUESTION_06'
,p_column_display_sequence=>49
,p_column_heading=>'Domanda 6 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236239120445177041.4054)
,p_query_column_id=>42
,p_column_alias=>'SURVEY_ANSWER_06'
,p_column_display_sequence=>50
,p_column_heading=>'Risposta 6 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236239200835177041.4054)
,p_query_column_id=>43
,p_column_alias=>'SURVEY_QUESTION_07'
,p_column_display_sequence=>51
,p_column_heading=>'Domanda 7 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236239311259177041.4054)
,p_query_column_id=>44
,p_column_alias=>'SURVEY_ANSWER_07'
,p_column_display_sequence=>52
,p_column_heading=>'Risposta 7 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236239414214177041.4054)
,p_query_column_id=>45
,p_column_alias=>'SURVEY_QUESTION_08'
,p_column_display_sequence=>53
,p_column_heading=>'Domanda 8 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236239531458177042.4054)
,p_query_column_id=>46
,p_column_alias=>'SURVEY_ANSWER_08'
,p_column_display_sequence=>54
,p_column_heading=>'Risposta 8 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236239615538177042.4054)
,p_query_column_id=>47
,p_column_alias=>'SURVEY_QUESTION_09'
,p_column_display_sequence=>55
,p_column_heading=>'Domanda 9 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236239730325177042.4054)
,p_query_column_id=>48
,p_column_alias=>'SURVEY_ANSWER_09'
,p_column_display_sequence=>56
,p_column_heading=>'Risposta 9 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236239807463177042.4054)
,p_query_column_id=>49
,p_column_alias=>'SURVEY_QUESTION_10'
,p_column_display_sequence=>57
,p_column_heading=>'Domanda 10 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236239927232177042.4054)
,p_query_column_id=>50
,p_column_alias=>'SURVEY_ANSWER_10'
,p_column_display_sequence=>58
,p_column_heading=>'Risposta 10 del sondaggio'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236240012349177042.4054)
,p_query_column_id=>51
,p_column_alias=>'AGREEMENT_ACCEPTANCE_DATE'
,p_column_display_sequence=>59
,p_column_heading=>'Data di accettazione dell''accordo'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236240132249177042.4054)
,p_query_column_id=>52
,p_column_alias=>'AGREEMENT_NAME'
,p_column_display_sequence=>60
,p_column_heading=>'Nome accordo'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236240230795177042.4054)
,p_query_column_id=>53
,p_column_alias=>'AGREEMENT_USER_ENV'
,p_column_display_sequence=>61
,p_column_heading=>'Amb. utente di accordo'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(236240329233177042.4054)
,p_query_column_id=>54
,p_column_alias=>'AGREEMENT_CHECKSUM'
,p_column_display_sequence=>62
,p_column_heading=>'Checksum accordo'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48634128002771334.4054)
,p_query_column_id=>55
,p_column_alias=>'PROJECT_DESCRIPTION'
,p_column_display_sequence=>30
,p_column_heading=>'Descrizione progetto'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48634202021771334.4054)
,p_query_column_id=>56
,p_column_alias=>'PROJECT_JUSTIFICATION'
,p_column_display_sequence=>31
,p_column_heading=>'Giustificazione progetto'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48634307951771334.4054)
,p_query_column_id=>57
,p_column_alias=>'PROJECT_APPROVAL_DATE'
,p_column_display_sequence=>32
,p_column_heading=>'Data di approvazione del progetto'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48634404873771334.4054)
,p_query_column_id=>58
,p_column_alias=>'PROJECT_ACTUAL_BEGIN_DATE'
,p_column_display_sequence=>33
,p_column_heading=>'Data di inizio effettiva del progetto'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48634508156771334.4054)
,p_query_column_id=>59
,p_column_alias=>'PROJECT_ACTUAL_END_DATE'
,p_column_display_sequence=>34
,p_column_heading=>'Data di fine effettiva del progetto'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48634623965771334.4054)
,p_query_column_id=>60
,p_column_alias=>'PROJECT_STATUS'
,p_column_display_sequence=>35
,p_column_heading=>'Stato progetto'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48634727595771334.4054)
,p_query_column_id=>61
,p_column_alias=>'WORK_LOG'
,p_column_display_sequence=>36
,p_column_heading=>'Log di lavoro'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(48634805072771335.4054)
,p_query_column_id=>62
,p_column_alias=>'REQUEST_DATE'
,p_column_display_sequence=>37
,p_column_heading=>'Data richiesta'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(852083723823313781.4054)
,p_query_column_id=>63
,p_column_alias=>'WORKSPACE_TYPE'
,p_column_display_sequence=>63
,p_column_heading=>'Tipo area di lavoro'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(56499914833442395.4054)
,p_plug_name=>'Elimina richiesta'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('Se l''area di lavoro \00E8 stata interrotta o rifiutata, \00E8 possibile eliminare l''intera richiesta dal sistema utilizzando questa pagina.  ')
,p_plug_query_headings=>'Edit:Seq.:Col.:Name:Display:Template:Source:Items:Buttons:BuildOption:DisplayWhenType'
,p_plug_query_num_rows=>500
,p_plug_query_num_rows_type=>'ROWS_X_TO_Y_OF_Z'
,p_plug_column_width=>'valign="top" align="right"'
,p_plug_query_show_nulls_as=>'-'
,p_plug_query_col_allignments=>'L:L:L:L:L:L:L:R:R:L:L:L:L'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(227287494596.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(2842620068855323.4054)
,p_button_name=>'Cancel'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(227285494595.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(2842620068855323.4054)
,p_button_name=>'DeleteRequest'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Elimina richiesta'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(227291494598.4054)
,p_branch_action=>'26'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_when_button_id=>wwv_flow_api.id(227285494595.4054)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(227319764028.4054)
,p_branch_action=>'26'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(227293494598.4054)
,p_branch_action=>'26'
,p_branch_point=>'BEFORE_VALIDATION'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_when_button_id=>wwv_flow_api.id(227287494596.4054)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2847701305864055.4054)
,p_name=>'D_PROVISION_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2842620068855323.4054)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(2855101293879192.4054)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete request'
,p_process_sql_clob=>'wwv_flow_provisioning.delete_provision_request(p_id=>:D_PROVISION_ID);'
,p_process_error_message=>'Errore durante l''eliminazione della richiesta di area di lavoro.'
,p_process_when_button_id=>wwv_flow_api.id(227285494595.4054)
,p_process_success_message=>'Richiesta eliminata.'
);
end;
/
prompt --application/pages/page_00009
begin
wwv_flow_api.create_page(
 p_id=>9.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Gestisci istanza'
,p_step_title=>'Gestisci istanza'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(3931176884177111905)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_ser_rqst.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168495707597569444.4054)
,p_plug_name=>'Impostazioni istanza'
,p_icon_css_classes=>'icon-utilities-ui-defaults'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody:h240'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(966388705490342505.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(47534314618390800.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_plug_column_width=>'apex-col--rightBorder apex-col--bottomBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168503102999717326.4054)
,p_plug_name=>'Gestisci componenti condivisi'
,p_icon_css_classes=>'icon-util-shared-components'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody:h240'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(966388705490342505.4054)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(137961006165346808.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168503812265738931.4054)
,p_plug_name=>'Informazioni'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>60
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Utilizzare questa pagina per controllare e impostare le funzioni e le funzionalit\00E0 di questa istanza di &PRODUCT_NAME..</p>'),
'<p><a target="_blank" href="&SYSTEM_HELP_URL./aeadm/overview-of-oracle-application-express-administration-services.html#GUID-94198B56-CABC-42F3-8795-F38212936763">Ulteriori informazioni...</a></p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168504112396748429.4054)
,p_plug_name=>'Gestisci metadati'
,p_icon_css_classes=>'icon-util-object-dependencies'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody:h240'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(966388705490342505.4054)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(19017202882431374.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_plug_column_width=>'apex-col--rightBorder apex-col--bottomBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168506212358795720.4054)
,p_plug_name=>'Messaggi'
,p_icon_css_classes=>'icon-sc-list'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody:h240'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(966388705490342505.4054)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(168505619846788416.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_plug_column_width=>'valign="top"'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(192441415743903627.4054)
,p_plug_name=>'Gestisci log e file'
,p_region_css_classes=>'h360'
,p_icon_css_classes=>'icon-util-logs'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(966388705490342505.4054)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(5021913929565780.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--rightBorder apex-col--bottomBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(203029008911057378.4054)
,p_plug_name=>'Iscrizione Self Service'
,p_region_css_classes=>'h360'
,p_icon_css_classes=>'icon-admin-service-request'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(966388705490342505.4054)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(203028225668057376.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'apex-col--bottomBorder'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(254701518341001744.4054)
,p_plug_name=>unistr('Modalit\00E0 di provisioning')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>70
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_output     varchar2(32767);',
'    l_session_id varchar2(255) := :APP_SESSION;',
'    x            varchar2(4000);',
'begin',
'    x := wwv_flow_platform.get_preference( p_preference_name => ''SERVICE_REQUEST_FLOW'' );',
'    l_output := ''<strong><a href="f?p=4050:131:''||l_session_id||'':::RIR:">'';',
'    if x = ''EMAIL'' then',
'        l_output:=l_output||wwv_flow_lang.system_message(''SELF_SERVICE_WITH_EMAIL'');',
'    elsif x = ''4700'' then',
'        l_output:=l_output||wwv_flow_lang.system_message(''SELF_SERVICE'');',
'    elsif x = ''AUTO'' then',
'        l_output:=l_output||wwv_flow_lang.system_message(''F4050.AUTOMATIC'');',
'    else',
'        l_output:=l_output||wwv_flow_lang.system_message(''MANUAL'');',
'    end if;',
'    l_output:=l_output||''</a></strong>'';',
'    sys.htp.p(l_output);',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(968837253318525063.4054)
,p_name=>'Metriche'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-BadgeList--stacked:a-BadgeList--xlarge'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4500P1000cMH9 */',
'   (select to_char(nvl(wwv_flow_platform.get_preference( p_preference_name => ''MAX_SESSION_IDLE_SEC''),3600),''999G999G999G999G990'') x from dual)  max_session_idle_time,',
'   --',
'   ( select to_char(count(*),''999G999G999G999G990'') c ',
'        from wwv_flow_pkg_applications p ',
'        where p.app_type = ''DB''',
'        and p.app_group != ''CUSTOM'') packaged_applications,',
'   --',
'   (select to_char(count(*),''999G999G999G999G990'') c ',
'        from wwv_flow_pkg_applications p',
'        where p.app_group = ''CUSTOM'') custom_applications,',
'   --',
'   (select to_char(count(*),''999G999G999G999G990'') c ',
'        from wwv_flow_pkg_applications p ',
'        where p.app_type = ''WS''',
'        and p.app_group != ''CUSTOM'') websheets',
'from dual'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(805663950138677747.4054)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(968839153112542694.4054)
,p_query_column_id=>1
,p_column_alias=>'MAX_SESSION_IDLE_TIME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('Tempo massimo di inattivit\00E0 sessione (secondi)')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(968839539782553959.4054)
,p_query_column_id=>2
,p_column_alias=>'PACKAGED_APPLICATIONS'
,p_column_display_sequence=>2
,p_column_heading=>unistr('Applicazioni di produttivit\00E0')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(968839875456566331.4054)
,p_query_column_id=>3
,p_column_alias=>'CUSTOM_APPLICATIONS'
,p_column_display_sequence=>3
,p_column_heading=>'Applicazioni personalizzate'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(968840143923576394.4054)
,p_query_column_id=>4
,p_column_alias=>'WEBSHEETS'
,p_column_display_sequence=>4
,p_column_heading=>'Websheet'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(168507403963812268.4054)
,p_computation_sequence=>10
,p_computation_item=>'LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'9'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1364682309896820101.4054)
,p_name=>'Close Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(192441415743903627.4054)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1364682468819820102.4054)
,p_event_id=>wwv_flow_api.id(1364682309896820101.4054)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if ( this.data.successMessage ) {',
'    // use new API to show the success message if any that came from the dialog',
'    apex.message.showPageSuccess(this.data.successMessage.text);',
'}'))
);
end;
/
prompt --application/pages/page_00010
begin
wwv_flow_api.create_page(
 p_id=>10.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Gestisci aree di lavoro'
,p_step_title=>'Gestisci aree di lavoro'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216765317551591446)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'#fixed_height_region .rc-content {min-height: 200px; padding: 0;}',
'</style>'))
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_mg_wrkspc_pg.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6049701880928601.4054)
,p_plug_name=>'Azioni area di lavoro'
,p_region_css_classes=>'h360'
,p_icon_css_classes=>'icon-util-workspace-actions'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(966388705490342505.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(19017606691432489.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_plug_column_width=>'apex-col--rightBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6144611534376254.4054)
,p_plug_name=>'Informazioni'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>60
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Un''area di lavoro \00E8 uno spazio condiviso in cui pi\00F9 sviluppatori possono creare le proprie applicazioni. Ciascuna area di lavoro ha il privilegio di eseguire analisi come uno o pi\00F9 schemi di database.</p>'),
'<p><a target="_blank" href="&SYSTEM_HELP_URL./aeadm/overview-of-oracle-application-express-administration-services.html#GUID-191CB956-10A7-4F8D-A522-018835864928">Ulteriori informazioni...</a></p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(10332829289896519.4054)
,p_plug_name=>'Report sull''area di lavoro'
,p_region_css_classes=>'h360'
,p_icon_css_classes=>'icon-sc-report-query'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(966388705490342505.4054)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(10332318553893424.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(32847028451566366.4054)
,p_plug_name=>'reset'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>':F4050_P79_SCHEMA_PASSWORD  := null;'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(47561719374965004.4054)
,p_plug_name=>'Esportazione/importazione'
,p_region_css_classes=>'h240'
,p_icon_css_classes=>'icon-utilities-data-workshop'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(966388705490342505.4054)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(47558804136960608.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_plug_column_width=>'apex-col--rightBorder apex-col--bottomBorder'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168490221110504940.4054)
,p_plug_name=>'Gestisci applicazioni'
,p_region_css_classes=>'h240'
,p_icon_css_classes=>'icon-util-manage'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'a-LinksList--nowrap'
,p_plug_template=>wwv_flow_api.id(966388705490342505.4054)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(244253103570784647.4054)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(517410627877325303.4054)
,p_plug_column_width=>'apex-col--bottomBorder'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1080988572880523918.4054)
,p_name=>'Stato corrente'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>80
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#:a-BadgeList--stacked:a-BadgeList--large'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'    (   select count(*) c',
'        from wwv_flow_companies',
'        where provisioning_company_id not in (0,10,11) )  workspace_count,',
'    (   select count(*) c',
'        from wwv_flow_fnd_user ) workspace_users,',
'    (   select count(*) c',
'        from wwv_flow_company_schemas cs,',
'             wwv_flow_companies c',
'        where cs.security_group_id = c.provisioning_company_id(+)',
'             and short_name != ''INTERNAL'' ) workspace_schemas,',
'    (   select count(*) c',
'        from wwv_flows',
'        where security_group_id not in (0,10,11) ) applications',
'from dual'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(805663950138677747.4054)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'0'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1080988619379523919.4054)
,p_query_column_id=>1
,p_column_alias=>'WORKSPACE_COUNT'
,p_column_display_sequence=>1
,p_column_heading=>'Conteggio aree di lavoro'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP,RIR:::'
,p_column_linktext=>'#WORKSPACE_COUNT#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1080988755941523920.4054)
,p_query_column_id=>2
,p_column_alias=>'WORKSPACE_USERS'
,p_column_display_sequence=>2
,p_column_heading=>'Utenti area di lavoro'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:RP,RIR:::'
,p_column_linktext=>'#WORKSPACE_USERS#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1080988827320523921.4054)
,p_query_column_id=>3
,p_column_alias=>'WORKSPACE_SCHEMAS'
,p_column_display_sequence=>3
,p_column_heading=>'Schemi area di lavoro'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:RP,RIR:::'
,p_column_linktext=>'#WORKSPACE_SCHEMAS#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1080988927572523922.4054)
,p_query_column_id=>4
,p_column_alias=>'APPLICATIONS'
,p_column_display_sequence=>4
,p_column_heading=>'Applicazioni'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:RP,RIR:::'
,p_column_linktext=>'#APPLICATIONS#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(30177820127829133.4054)
,p_computation_sequence=>10
,p_computation_item=>'LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'10'
,p_compute_when_type=>'%null%'
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_api.create_page(
 p_id=>11.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Attributi applicazione'
,p_step_title=>'Attributi applicazione'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(275228225185505839)
,p_step_template=>wwv_flow_api.id(721098416706687971.4054)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_app.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1154929605958289.4054)
,p_plug_name=>'Applicazioni'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(721125879764730304.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ID, ',
'(select short_name  from WWV_FLOW_COMPANIES where PROVISIONING_COMPANY_ID = f.security_group_id) SECURITY_GROUP_ID,',
'SECURITY_GROUP_ID workspace_id,',
'OWNER,',
'"NAME",',
'alias,',
'LAST_UPDATED_BY, LAST_UPDATED_ON,',
'(select count(*) from wwv_flow_steps where flow_id = f.id) pages,',
'CHARSET,',
'CREATED_ON created,',
'FLOW_LANGUAGE,',
'WEBDB_LOGGING logging,',
'DATE_FORMAT,',
'FLOW_IMAGE_PREFIX image_prefix,',
'FLOW_VERSION version,',
'FLOW_STATUS application_status,',
'FLOW_UNAVAILABLE_TEXT unavailable_text,',
'RESTRICT_TO_USER_LIST restrict_to_users,',
'BUILD_STATUS,',
'SECURITY_SCHEME',
'from WWV_FLOWS f',
'where',
'f.security_group_id != 10'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NOT_DISPLAYING_INLINE_VALIDATION_ERRORS'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1155017179958289.4054)
,p_name=>'Applications'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('Questa query restituisce pi\00F9 di 10.000 righe. Filtrare i dati per ottenere risultati completi.')
,p_no_data_found_message=>'Nessun dato trovato.'
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:PDF'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1155308703958298.4054)
,p_db_column_name=>'SECURITY_GROUP_ID'
,p_display_order=>1
,p_column_identifier=>'B'
,p_column_label=>'Area di lavoro'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1155213723958298.4054)
,p_db_column_name=>'ID'
,p_display_order=>2
,p_column_identifier=>'A'
,p_column_label=>'Applicazione'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1155425625958298.4054)
,p_db_column_name=>'OWNER'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Schema di analisi'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1155519945958298.4054)
,p_db_column_name=>'NAME'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Nome applicazione'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1155614168958299.4054)
,p_db_column_name=>'LAST_UPDATED_BY'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Autore aggiornamento'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1155710134958299.4054)
,p_db_column_name=>'LAST_UPDATED_ON'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Aggiornato'
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1155820920958299.4054)
,p_db_column_name=>'PAGES'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>'Pagine'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1155923375958299.4054)
,p_db_column_name=>'CHARSET'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Set di caratteri'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1156000595958300.4054)
,p_db_column_name=>'FLOW_LANGUAGE'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Lingua'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1170023688080440.4054)
,p_db_column_name=>'LOGGING'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Log'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(110344620122166929)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1170128212080441.4054)
,p_db_column_name=>'DATE_FORMAT'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'Formato data'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1170207128080445.4054)
,p_db_column_name=>'IMAGE_PREFIX'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>'Prefisso immagine'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1170516700080446.4054)
,p_db_column_name=>'VERSION'
,p_display_order=>15
,p_column_identifier=>'O'
,p_column_label=>'Versione'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1170611697080446.4054)
,p_db_column_name=>'APPLICATION_STATUS'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>'Stato applicazione'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1171928667091381.4054)
,p_db_column_name=>'UNAVAILABLE_TEXT'
,p_display_order=>17
,p_column_identifier=>'Q'
,p_column_label=>'Testo non disponibile'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1172004705091382.4054)
,p_db_column_name=>'RESTRICT_TO_USERS'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>'Limita a utenti'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1172110334091382.4054)
,p_db_column_name=>'BUILD_STATUS'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>'Stato di creazione'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(244320808989852457)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1172220531091382.4054)
,p_db_column_name=>'SECURITY_SCHEME'
,p_display_order=>20
,p_column_identifier=>'T'
,p_column_label=>'Schema di sicurezza'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1173327198109877.4054)
,p_db_column_name=>'CREATED'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>'Data creazione'
,p_column_type=>'DATE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(254152603061181874.4054)
,p_db_column_name=>'WORKSPACE_ID'
,p_display_order=>22
,p_column_identifier=>'V'
,p_column_label=>'ID area di lavoro'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(144298924302584758.4054)
,p_db_column_name=>'ALIAS'
,p_display_order=>23
,p_column_identifier=>'W'
,p_column_label=>'Alias'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(254091311699719427.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1154929605958289.4054)
,p_button_name=>'RESET_REPORT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Reimposta report'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(244651516120077672.4054)
,p_branch_action=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>99
);
end;
/
prompt --application/pages/page_00012
begin
wwv_flow_api.create_page(
 p_id=>12.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Gestisci sviluppatori e utenti'
,p_step_title=>'Gestisci sviluppatori e utenti'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216787602191653217)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_users.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6318778195.4054)
,p_plug_name=>'Sviluppatori e utenti'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Le applicazioni interne di &PRODUCT_NAME. (App Builder, SQL Workshop e cos\00EC via) autenticano le credenziali'),
' utente alle voci nel repository degli account di &PRODUCT_NAME.. Anche le applicazioni sviluppate dagli utenti possono utilizzare',
'questo repository degli account per l''autenticazione. </p>',
'',
'<p> Questo report mostra le voci di nome utente in questo repository per area di lavoro. Fare clic sul nome di un utente nel report per',
' modificare l''utente oppure fare clic su <b>Crea</b> per crearne uno nuovo. Fare clic sul collegamento <b>Reimposta</b> per reimpostare la password per l''utente specificato.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1301955870026853711.4054)
,p_plug_name=>'Gestisci sviluppatori di applicazioni e utenti'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select u.user_id,',
'       u.workspace_id,',
'       u."USER",',
'       u.first_name||'' ''||u.last_name full_name,',
'       u.df, -- default schema',
'       u.ul, -- is user locked?',
'       u.dev_type account_type,',
'       u.last_update_date,',
'       u.creation_date,',
'       c.short_name workspace,',
'       decode(u."USER",''ADMIN'',null,',
'              ''<a href="f?p=4050:53:''||:flow_session||',
'              ''::NO:53:F4050_P53_USER_ID:''||wwv_flow_escape.html(u.user_id)||''">''||',
'              wwv_flow_lang.system_message(''F4050.RESET'')||''</a>'') p',
'  from wwv_flow_workspace_users u,',
'       wwv_flow_companies c',
' where u.workspace_id = c.provisioning_company_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_document_header=>'APEX'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>11
,p_prn_height=>8.5
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1301955948511853712.4054)
,p_max_row_count=>'1000000'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_owner=>'JASON'
,p_internal_uid=>1301955948511853712
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1301956426284853717.4054)
,p_db_column_name=>'USER_ID'
,p_display_order=>50
,p_column_identifier=>'E'
,p_column_label=>'ID utente'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1301956557228853718.4054)
,p_db_column_name=>'USER'
,p_display_order=>60
,p_column_identifier=>'F'
,p_column_label=>'Utente'
,p_column_link=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:RP,23:F4050_P23_USER_ID:#USER_ID#'
,p_column_linktext=>'#USER#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1301956930963853722.4054)
,p_db_column_name=>'DF'
,p_display_order=>100
,p_column_identifier=>'J'
,p_column_label=>'Schema predefinito'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1301957424892853727.4054)
,p_db_column_name=>'UL'
,p_display_order=>150
,p_column_identifier=>'O'
,p_column_label=>'Bloccato'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1301958980212853742.4054)
,p_db_column_name=>'LAST_UPDATE_DATE'
,p_display_order=>300
,p_column_identifier=>'AD'
,p_column_label=>'Aggiornato'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1301959124887853744.4054)
,p_db_column_name=>'CREATION_DATE'
,p_display_order=>320
,p_column_identifier=>'AF'
,p_column_label=>'Data creazione'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1796417210487006101.4054)
,p_db_column_name=>'FULL_NAME'
,p_display_order=>330
,p_column_identifier=>'AM'
,p_column_label=>'Nome completo'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1796417582391006104.4054)
,p_db_column_name=>'ACCOUNT_TYPE'
,p_display_order=>340
,p_column_identifier=>'AP'
,p_column_label=>'Tipo di account'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1796417696532006105.4054)
,p_db_column_name=>'WORKSPACE'
,p_display_order=>350
,p_column_identifier=>'AQ'
,p_column_label=>'Area di lavoro'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1796417728321006106.4054)
,p_db_column_name=>'P'
,p_display_order=>360
,p_column_identifier=>'AR'
,p_column_label=>'Password'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(2024852857686481305.4054)
,p_db_column_name=>'WORKSPACE_ID'
,p_display_order=>370
,p_column_identifier=>'AS'
,p_column_label=>'ID area di lavoro'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(484702204098038644.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1301955870026853711.4054)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Reimposta'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:12,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(43040243631941918.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1301955870026853711.4054)
,p_button_name=>'Create_New'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372670814202760.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea utente'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:23,EDIT_USER_PRIVS::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(25567619615581607.4054)
,p_branch_action=>'f?p=&FLOW_ID.:12:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(25564831604575604.4054)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_RESET_PAGINATION'
,p_process_name=>'rp'
,p_attribute_01=>'THIS_PAGE'
,p_process_when=>'GO'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00013
begin
wwv_flow_api.create_page(
 p_id=>13.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Visualizzazioni di pagina per sistema operativo'
,p_step_title=>'Visualizzazioni di pagina per sistema operativo'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216662902659587159)
,p_inline_css=>'td[headers=GRAPH] {min-width: 150px;}'
,p_step_template=>wwv_flow_api.id(721098416706687971.4054)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_activity.htm'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(2584726337646135.4054)
,p_name=>'Visualizzazioni di pagina per sistema operativo'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>20
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with total_count as',
'(select /* APEX 4050P13a */ count(*) a ',
'from wwv_flow_activity_log ',
'where security_group_id = :flow_security_group_id and ',
'time_stamp >= sysdate - nvl(:P13_TIME,1)',
') ',
'select os, page_views , 100*page_views/total_count.a pct, round(100*page_views/total_count.a) graph',
'from (',
'select ',
' x.os, ',
' sum(x.c) page_views',
'from',
'(',
'select session_id, max(decode(user_agent,null,'' Null'',',
'       nvl(',
'       decode(instr(user_agent,''Mac OS X''),0,'''',''Mac OS X'')||',
'       decode(instr(user_agent,''Linux''),0,'''',''Linux'')||',
'       decode(instr(user_agent,''Windows NT 5.0''),0,'''',''Windows 2000'')||',
'       decode(instr(user_agent,''Windows NT 6.0''),0,'''',''Windows Vista'')||',
'       decode(instr(user_agent,''Windows NT 7''),0,'''',''Windows 7'')||',
'       decode(instr(user_agent,''Windows NT 8''),0,'''',''Windows 8'')||',
'       decode(instr(user_agent,''Windows NT 9''),0,'''',''Windows 9'')||',
'       decode(instr(user_agent,''Windows NT 10''),0,'''',''Windows 10'')||',
'       decode(instr(user_agent,''Windows NT 11''),0,'''',''Windows 11'')||',
'       decode(instr(user_agent,''Windows NT 5.1''),0,'''',''Windows XP''),',
'       t.other))) os, count(*) c',
'from wwv_flow_activity_log, ',
'    (select wwv_flow_lang.system_message(''other'') other from dual) t',
'where security_group_id = :flow_security_group_id',
'       and time_stamp >= sysdate - nvl(:P13_TIME,1)',
'group by session_id',
') x',
'group by os) d, ',
'total_count',
'where (:P13_SEARCH is null or instr(upper(os),upper(:P13_SEARCH)) > 0)'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(805672157251677851.4054)
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_break_cols=>'0'
,p_query_no_data_found=>'Nessuna visualizzazione di pagina trovata.'
,p_query_num_rows_item=>'P13_ROWS'
,p_query_num_rows_type=>'ROW_RANGES_IN_SELECT_LIST'
,p_query_row_count_max=>5000
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'Y'
,p_csv_output_link_text=>'Scarica'
,p_prn_output=>'Y'
,p_prn_format=>'PDF'
,p_prn_output_show_link=>'Y'
,p_prn_output_link_text=>'Stampa'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>11
,p_prn_height=>8.5
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header=>'&PRODUCT_NAME.'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#ffffff'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3213125863900959.4054)
,p_query_column_id=>1
,p_column_alias=>'OS'
,p_column_display_sequence=>1
,p_column_heading=>'Sistema operativo'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_default_sort_column_sequence=>1
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_print_col_width=>'40'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2585103254646189.4054)
,p_query_column_id=>2
,p_column_alias=>'PAGE_VIEWS'
,p_column_display_sequence=>2
,p_column_heading=>'Visualizzazioni di pagina'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_print_col_width=>'30'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3213229658900959.4054)
,p_query_column_id=>3
,p_column_alias=>'PCT'
,p_column_display_sequence=>3
,p_column_heading=>'Percentuale'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G990D00'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_print_col_width=>'30'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3213317952900970.4054)
,p_query_column_id=>4
,p_column_alias=>'GRAPH'
,p_column_display_sequence=>4
,p_column_heading=>'Grafico'
,p_column_format=>'PCT_GRAPH:#cccccc:#777777:'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(108275219905850320.4054)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3216622316918896.4054)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(108275219905850320.4054)
,p_button_name=>'P13_GO'
,p_button_static_id=>'P13_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Vai'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3215505347913957.4054)
,p_name=>'P13_TIME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(108275219905850320.4054)
,p_item_default=>'1'
,p_prompt=>'Includi'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT_TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Limitare il report a un periodo di tempo specifico. Identificare la quantit\00E0 di tempo da includere nel report e fare clic su <b>Vai</b>.<p />'),
'Se si seleziona 1 giorno, verranno visualizzate solo le ultime 24 ore.  '))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(92431227952006274.4054)
,p_name=>'P13_ROWS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(108275219905850320.4054)
,p_item_default=>'100'
,p_prompt=>'Righe'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MAX_ROWS_G'
,p_lov=>'.'||wwv_flow_api.id(87738929453259457.4054)||'.'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Selezionare il numero di righe da visualizzare e fare clic su <b>Vai</b>.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(92433515962012317.4054)
,p_name=>'P13_SEARCH'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(108275219905850320.4054)
,p_prompt=>'Cerca'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Immettere criteri di query senza distinzione tra maiuscole e minuscole e fare clic su <b>Vai</b>.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
end;
/
prompt --application/pages/page_00014
begin
wwv_flow_api.create_page(
 p_id=>14.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Dettagli area di lavoro'
,p_step_title=>'Dettagli area di lavoro'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216765317551591446)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_wrkspc_details.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2882705150907846.4054)
,p_plug_name=>'Workspace Details'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-Form--labelsAbove:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_row_template=>wwv_flow_api.id(81008210556197147.4054)
,p_plug_query_headings=>wwv_flow_string.join(wwv_flow_t_varchar2(
'blue_arrow_down.gif::blue_arrow_up.gif:|2,3,4\1|',
'',
'&nbsp;:',
'',
'<font color="black" class="nounderline">Schema</font>:',
'',
'<font color="black" class="nounderline">Company</font>:',
'',
'<font color="black" class="nounderline">CompanyID</font>'))
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'ROWS_X_TO_Y_OF_Z'
,p_plug_column_width=>'valign="top"'
,p_plug_query_show_nulls_as=>'(null)'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(177744611327233052.4054)
,p_plug_name=>'Dettagli area di lavoro'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Questa pagina visualizza attributi chiave relativi all''area di lavoro selezionata.</p>'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180211706270323234.4054)
,p_plug_name=>'Summary report area di lavoro'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_workspace_reports.report_workspace_usage (',
'    p_security_group_id => :SGID,',
'    p_max_apps => 5,',
'    p_max_db_objects=> 5,',
'    p_max_websheets=> 5,',
'    p_time_frame_DWMY => nvl(:P14_REPORTING_PERIOD,''W''),',
'    p_date_format => :DATE_TIME_FORMAT );'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'SGID'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(180427220917510105.4054)
,p_plug_name=>'Hidden'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517376500704206647.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(19471711351438457.4054)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(2882705150907846.4054)
,p_button_name=>'P14_GO'
,p_button_static_id=>'P14_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Imposta'
,p_button_position=>'BODY'
,p_request_source=>'GO'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(180478505463215176.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(2882705150907846.4054)
,p_button_name=>'REMOVE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Rimuovi'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:81:&SESSION.::&DEBUG.:81:P81_COMPANY:&P14_WORKSPACE_NAME.'
,p_button_condition=>'SGID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(360939525109430983.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(2882705150907846.4054)
,p_button_name=>'EDIT_WS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Modifica'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:78:&SESSION.::&DEBUG.::P78_PROVISIONING_COMPANY_ID:&SGID.'
,p_button_condition=>'SGID'
,p_button_condition2=>'10'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(360949518239533093.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(2882705150907846.4054)
,p_button_name=>'MAN_WS_SCHEMAS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Assegnazioni dello schema'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:21,RIR:IR_SECURITY_GROUP_ID:&SGID.'
,p_button_condition=>'SGID'
,p_button_condition2=>'10'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(361023100417991549.4054)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(2882705150907846.4054)
,p_button_name=>'MAN_USERS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Gestisci utenti'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:12,RIR:IR_WORKSPACE_ID:&SGID.'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(184089511347405635.4054)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(2882705150907846.4054)
,p_button_name=>'EMAIL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Posta elettronica'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.::P76_REPORTING_PERIOD,P76_WORKSPACE_ID:&P14_REPORTING_PERIOD.,&SGID.'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(317937565640.4054)
,p_branch_action=>'14'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(297977429861.4054)
,p_name=>'SGID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2882705150907846.4054)
,p_prompt=>'Area di lavoro'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select short_name, PROVISIONING_COMPANY_ID',
'from   WWV_FLOW_COMPANIES',
'where provisioning_company_id not in (0, 11)',
'order  by short_name'))
,p_cSize=>30
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Selezionare un''area di lavoro e fare clic su <b>Vai</b>.'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180427011913507481.4054)
,p_name=>'P14_WORKSPACE_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(2882705150907846.4054)
,p_prompt=>'Workspace Name'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(180730012565372136.4054)
,p_name=>'P14_REPORTING_PERIOD'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(2882705150907846.4054)
,p_item_default=>'W'
,p_prompt=>'Periodo report'
,p_source=>'W'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'REPORTING PERIOD'
,p_lov=>'.'||wwv_flow_api.id(180726228364333770.4054)||'.'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(180427400962513786.4054)
,p_computation_sequence=>10
,p_computation_item=>'P14_WORKSPACE_NAME'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>'select short_name from wwv_flow_companies where provisioning_company_id = :SGID'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(180400628882162317.4054)
,p_computation_sequence=>20
,p_computation_item=>'SGID'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_name varchar2(255);',
'   l_next_sgid number;',
'begin',
'   select short_name into l_name ',
'   from wwv_flow_companies ',
'   where provisioning_company_id = :SGID;',
'   for c1 in (select provisioning_company_id',
'              from wwv_flow_companies ',
'              where short_name > l_name',
'              order by short_name) loop',
'       l_next_sgid := c1.provisioning_company_id;',
'       exit;',
'   end loop;',
'   return nvl(l_next_sgid,:SGID);',
'end;'))
,p_compute_when=>'NEXT'
,p_compute_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(180401916892168333.4054)
,p_computation_sequence=>30
,p_computation_item=>'SGID'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_name varchar2(255);',
'   l_next_sgid number;',
'begin',
'   select short_name into l_name ',
'   from wwv_flow_companies ',
'   where provisioning_company_id = :SGID;',
'   for c1 in (select provisioning_company_id',
'              from wwv_flow_companies ',
'              where short_name < l_name',
'              order by short_name desc) loop',
'       l_next_sgid := c1.provisioning_company_id;',
'       exit;',
'   end loop;',
'   return nvl(l_next_sgid,:SGID);',
'end;'))
,p_compute_when=>'PREVIOUS'
,p_compute_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(19034431362034300.4054)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_RESET_PAGINATION'
,p_process_name=>'reset pagination'
,p_attribute_01=>'THIS_PAGE'
,p_process_when_button_id=>wwv_flow_api.id(19471711351438457.4054)
);
end;
/
prompt --application/pages/page_00015
begin
wwv_flow_api.create_page(
 p_id=>15.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Visualizzazioni di pagina per browser'
,p_step_title=>'Visualizzazioni di pagina per browser'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216662902659587159)
,p_inline_css=>'td[headers=GRAPH] {min-width: 150px;}'
,p_step_template=>wwv_flow_api.id(721098416706687971.4054)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_activity.htm'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(2597607668687988.4054)
,p_name=>'Visualizzazioni di pagina per browser'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>20
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with total_count as',
'(',
'select /* APEX 4050P15a */ count(*) a ',
'from   wwv_flow_activity_log ',
'where  security_group_id = :flow_security_group_id and ',
'       time_stamp >= sysdate - nvl(:P15_TIME,1) and',
'       user_agent is not null',
') ',
'select os, page_views , 100*page_views/total_count.a pct, round(100*page_views/total_count.a) graph',
'from (',
'select ',
' x.os, ',
' sum(x.c) page_views',
'from',
'(',
'select session_id, ',
'       case ',
'       when user_agent is null then ''No User Agent''',
'       when instr(user_agent,''Chrome/'') > 0 then ''Chrome''',
'       when instr(user_agent,''Edge/'') > 0 then ''Edge''',
'       when instr(user_agent,''Safari/'') > 0 then ''Safari''',
'       when instr(user_agent,''Opera/'') > 0 then ''Opera''',
'       when instr(user_agent,''Firefox/'') > 0 then ''Firefox''',
'       when instr(user_agent,''AppleWebKit/'') > 0 then ''AppleWebKit''',
'       when instr(user_agent,''Mozilla/'') > 0 then ''Mozilla''',
'       when instr(user_agent,''Trident/'') > 0 then ''Trident''',
'       else ''Unkonwn'' end os,',
'       count(*) c',
'from wwv_flow_activity_log',
'where security_group_id = :flow_security_group_id',
'       and time_stamp >= sysdate - nvl(:P15_TIME,1)',
'       and user_agent is not null',
'group by session_id,',
'case ',
'       when user_agent is null then ''No User Agent''',
'       when instr(user_agent,''Chrome/'') > 0 then ''Chrome''',
'       when instr(user_agent,''Edge/'') > 0 then ''Edge''',
'       when instr(user_agent,''Safari/'') > 0 then ''Safari''',
'       when instr(user_agent,''Opera/'') > 0 then ''Opera''',
'       when instr(user_agent,''Firefox/'') > 0 then ''Firefox''',
'       when instr(user_agent,''AppleWebKit/'') > 0 then ''AppleWebKit''',
'       when instr(user_agent,''Mozilla/'') > 0 then ''Mozilla''',
'       when instr(user_agent,''Trident/'') > 0 then ''Trident''',
'       else ''Unkonwn'' end',
') x',
'group by os) d, total_count'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(805672157251677851.4054)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>'Nessuna visualizzazione di pagina trovata.'
,p_query_num_rows_type=>'ROW_RANGES_IN_SELECT_LIST'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'Y'
,p_csv_output_link_text=>'Scarica'
,p_prn_output=>'Y'
,p_prn_format=>'PDF'
,p_prn_output_show_link=>'Y'
,p_prn_output_link_text=>'Stampa'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>11
,p_prn_height=>8.5
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header=>'&PRODUCT_NAME.'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#ffffff'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2597921064687990.4054)
,p_query_column_id=>1
,p_column_alias=>'OS'
,p_column_display_sequence=>1
,p_column_heading=>'Browser'
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_print_col_width=>'50'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(2598028849688000.4054)
,p_query_column_id=>2
,p_column_alias=>'PAGE_VIEWS'
,p_column_display_sequence=>2
,p_column_heading=>'Visualizzazioni di pagina'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_print_col_width=>'25'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3207811487858971.4054)
,p_query_column_id=>3
,p_column_alias=>'PCT'
,p_column_display_sequence=>3
,p_column_heading=>'Percentuale'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990D00'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_default_sort_column_sequence=>1
,p_default_sort_dir=>'desc'
,p_disable_sort_column=>'N'
,p_sum_column=>'Y'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_print_col_width=>'25'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3207921931858972.4054)
,p_query_column_id=>4
,p_column_alias=>'GRAPH'
,p_column_display_sequence=>4
,p_column_heading=>'Grafico'
,p_column_format=>'PCT_GRAPH:#cccccc:#777777:'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(108279024884861232.4054)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3210024085872083.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(108279024884861232.4054)
,p_button_name=>'P15_GO'
,p_button_static_id=>'P15_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--small'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Imposta'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(200369623299026784.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(108279024884861232.4054)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Reimposta'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.:15,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3208727763863613.4054)
,p_name=>'P15_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(108279024884861232.4054)
,p_item_default=>'1'
,p_prompt=>'Includi'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'RECENT_TIME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Limitare il report a un periodo di tempo specifico. Identificare la quantit\00E0 di tempo da includere nel report e fare clic su <b>Vai</b>.<p />'),
'Se si seleziona 1 giorno, verranno visualizzate solo le ultime 24 ore.  '))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
prompt --application/pages/page_00016
begin
wwv_flow_api.create_page(
 p_id=>16.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Configurazione funzioni'
,p_step_title=>'Configurazione funzioni'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216766702444596508)
,p_step_template=>wwv_flow_api.id(704456563630760825.4054)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_config_feature.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1220877187620120.4054)
,p_plug_name=>'Team Development'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>100
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(169304800930079016.4054)
,p_plug_name=>'Sviluppo di applicazioni'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(169306214436082917.4054)
,p_plug_name=>'SQL Workshop'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(169312431105116196.4054)
,p_plug_name=>'Controllo'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(169386325798256586.4054)
,p_plug_name=>'Configurazione funzioni'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder:a-ButtonRegion--showTitle'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(320717107575109777.4054)
,p_plug_name=>'Opzioni di installazione applicazione'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(521637608266366438.4054)
,p_plug_name=>'REST'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(617449525355766463.4054)
,p_plug_name=>'Informazioni'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>70
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Gestire le impostazioni valide per l''intera istanza.</p>'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(689843502838462013.4054)
,p_plug_name=>unistr('Team Development precedente (non pi\00F9 valido)')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>110
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(907405108418643658.4054)
,p_plug_name=>'Anchor'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(195775112470763477.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_translate_title=>'N'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(908012317600684138.4054)
,p_plug_name=>'Amministrazione area di lavoro'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(12936728094071536.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(169386325798256586.4054)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(169388709307261209.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(169386325798256586.4054)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(168521612246937591.4054)
,p_branch_action=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1220904441620121.4054)
,p_name=>'P16_ISSUE_FILES_YN'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1220877187620120.4054)
,p_item_default=>'Y'
,p_prompt=>'Abilita repository file problemi'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Selezionare <strong>S\00EC</strong> per tutte le nuove aree di lavoro create in questa istanza per consentire il caricamento dei file nel repository file centrale di Team Development. Selezionare <strong>No</strong> per tutte le nuove aree di lavoro crea')
||'te in questa istanza per non consentire il caricamento dei file nel repository file centrale di Team Development.',
'<br>',
'<br>',
'Questa impostazione non ha effetto sulle aree di lavoro esistenti.'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1221084382620122.4054)
,p_name=>'P16_ISSUE_FS_LIMIT'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1220877187620120.4054)
,p_item_default=>'15728640'
,p_prompt=>'Dimensione massima file (in MB)'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TEAM_DEV_FS_LIMIT'
,p_lov=>'.'||wwv_flow_api.id(689538645438591983.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Selezionare la dimensione massima per qualsiasi file caricato nel repository file centrale di Team Development. Il valore predefinito \00E8 15 MB.</p>'),
'',
'<p>Questa impostazione non ha effetto sulle aree di lavoro esistenti.</p>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(15317323587906632.4054)
,p_name=>'P16_APP_ACTIVITY_LOGGING'
,p_is_required=>true
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(169312431105116196.4054)
,p_item_default=>'U'
,p_prompt=>unistr('Log attivit\00E0 applicazione')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'APPLICATION ACTIVITY LOGGING'
,p_lov=>'.'||wwv_flow_api.id(15203330831314824.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Selezionare la modalit\00E0 di registrazione dell''attivit\00E0 dell''applicazione per tutte le applicazioni di questa istanza.'),
'<p>Sono disponibili le opzioni riportate di seguito.',
'<ul>',
unistr('<li><b>Usa impostazioni applicazioni (predefinito)</b>: utilizza l''attributo Log di ciascuna applicazione per determinare se l''attivit\00E0 viene registrata.</li>'),
unistr('<li><b>Mai</b>: disabilita la registrazione dell''attivit\00E0 per tutte le applicazioni dell''istanza.</li>'),
unistr('<li><b>Sempre</b>: abilita la registrazione dell''attivit\00E0 per tutte le applicazioni dell''istanza.</li>'),
unistr('<li><b>Disabilitata inizialmente per nuove applicazioni e applicazioni di produttivit\00E0 e di esempio</b>: la registrazione dell''attivit\00E0 sar\00E0 disabilitata inizialmente per le nuove applicazioni.</li>'),
'</ul>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(169297610580053441.4054)
,p_name=>'P16_ALLOW_DB_MONITOR'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(169312431105116196.4054)
,p_item_default=>'Y'
,p_prompt=>'Abilita controllo del database'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Abilitare o disabilitare il controllo in SQL Workshop.'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(169297816049053446.4054)
,p_name=>'P16_PLSQL_EDITING'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(169304800930079016.4054)
,p_item_default=>'Y'
,p_prompt=>'Consenti modifica program unit PL/SQL'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Per impostazione predefinita, gli sviluppatori possono modificare e compilare il codice sorgente PL/SQL durante l''esplorazione di procedure, package e funzioni del database in Browser oggetti. Per disabilitare la modifica e la compilazione delle prog'
||'ram unit PL/SQL da Browser oggetti, selezionare <b>No</b>.'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(169298013657053447.4054)
,p_name=>'P16_WORKSPACE_P_DEMO_OBJECT'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(169304800930079016.4054)
,p_item_default=>'Y'
,p_prompt=>'Crea oggetti demo in nuove aree di lavoro'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Controlla la creazione di applicazioni demo e oggetti di database demo durante la creazione di nuove aree di lavoro. Per disabilitare la creazione delle applicazioni demo, selezionare <b>No</b>.  ',
''))
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(169299221292053451.4054)
,p_name=>'P16_SQL_C_MAX_INACTIVITY'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(169306214436082917.4054)
,p_item_default=>'60'
,p_prompt=>unistr('Tempo massimo di inattivit\00E0 comandi SQL in minuti')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Identificare il periodo di tempo massimo di attesa di un comando transazionale nel processore comandi SQL prima del timeout.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(169299418817053452.4054)
,p_name=>'P16_SQL_SCRIPT_MAX_OUTPUT_SIZE'
,p_is_required=>true
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(169306214436082917.4054)
,p_prompt=>'Dimensione massima di output per script SQL in byte'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('Identificare la quantit\00E0 massima di output che un singolo script SQL pu\00F2 generare. Gli script SQL vengono eseguiti da SQL Workshop.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(169299604071053452.4054)
,p_name=>'P16_WORKSPACE_MAX_OUTPUT_SIZE'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(169306214436082917.4054)
,p_prompt=>'Dimensione massima di output area di lavoro per script SQL in byte'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('Identificare la quantit\00E0 massima di spazio che tutti gli script possono consumare all''interno di un''area di lavoro. I risultati degli script SQL costituiscono l''output generato durante l''esecuzione degli script SQL dal processore comandi SQL.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(169299802122053454.4054)
,p_name=>'P16_MAX_SCRIPT_SIZE'
,p_is_required=>true
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(169306214436082917.4054)
,p_prompt=>'Dimensione massima di output script per script SQL in byte'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Identificare la dimensione massima di uno script SQL utilizzata all''interno di SQL Workshop.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(175483619946469918.4054)
,p_name=>'P16_ENABLE_TRANSACTIONAL_SQL'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(169306214436082917.4054)
,p_item_default=>'N'
,p_prompt=>'Abilita comandi SQL transazionali'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('Abilitare i comandi SQL transazionali per l''intera istanza. L''abilitazione di questa funzione consente agli utenti dei comandi SQL di eseguire pi\00F9 comandi SQL all''interno della stessa transazione del database fisico.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(218527933367706511.4054)
,p_name=>'P16_DATA_LOADING_JOB_CLASS'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(169306214436082917.4054)
,p_prompt=>'Classe job di caricamento dati'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
unistr('    Identifica la classe di job DBMS_SCHEDULER in cui eseguire i job di caricamento dati SQL Workshop. Questa classe consente di assegnare i job di caricamento dati a un gruppo di consumer Resource Manager specifico. Se non \00E8 impostata, viene utilizz')
||'ata la classe di job <strong>SYS.DEFAULT_JOB_CLASS</strong>. Per ulteriori informazioni sulle classi di job, consultare la Guida per gli amministratori di Oracle Database.',
'</p>',
'<p>',
'    Esempio: esecuzione con i privilegi DBA:',
'</p>',
'<pre>',
'-- 1. Creare la classe di job',
'--   ',
'begin ',
'    dbms_scheduler.create_job_class(',
'         job_class_name          => ''MY_LOADER_CLASS'', ',
'         resource_consumer_group => ''RES_MGR_LOW_PRIO_GROUP'', -- si presuppone che esista un gruppo di consumer RES_MGR_LOW_PRIO_GROUP',
unistr('         comments                => ''Questa \00E8 una classe di job per i job di caricamento dati SQL Workshop'');'),
'end;',
'/',
'',
'-- 2. Concedere il privilegio EXECUTE nella classe di job all''utente del motore APEX',
'--',
'grant execute on MY_LOADER_CLASS to apex_NNNNNN',
'/',
'',
'-- 3. Configurare la classe di job qui oppure utilizzare APEX_INSTANCE_ADMIN.SET_PARAMETER',
'--',
'begin ',
'    apex_instance_admin.set_parameter(',
'        p_parameter => ''DATA_LOADING_JOB_CLASS'', ',
'        p_value     => ''MY_LOADER_CLASS''); ',
'end;',
'/',
'</pre>',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320717004022101694.4054)
,p_name=>'P16_PKG_APP_AUTH_ALLOW_HHEAD'
,p_is_required=>true
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(320717107575109777.4054)
,p_item_default=>'N'
,p_prompt=>'Consenti autenticazione con variabile di intestazione HTTP'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Quando si installano nuove applicazioni di produttivit\00E0 o di esempio, consentire di specificare questo tipo di schema di autenticazione.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320717629014120470.4054)
,p_name=>'P16_PKG_APP_AUTH_ALLOW_LDAP'
,p_is_required=>true
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(320717107575109777.4054)
,p_item_default=>'N'
,p_prompt=>'Consenti autenticazione con directory HTTP'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('Quando si installano nuove applicazioni di produttivit\00E0 o di esempio, consentire di specificare questo tipo di schema di autenticazione.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(320721414565127190.4054)
,p_name=>'P16_PKG_APP_AUTH_ALLOW_SSO'
,p_is_required=>true
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(320717107575109777.4054)
,p_item_default=>'N'
,p_prompt=>'Consenti autenticazione con Oracle Application Server Single Sign-On'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>unistr('Quando si installano nuove applicazioni di produttivit\00E0 o di esempio, consentire di specificare questo tipo di schema di autenticazione.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(335464077854351503.4054)
,p_name=>'P16_DATA_LOADING_MAX_FILE_SIZE'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(169306214436082917.4054)
,p_prompt=>'Dimensione massima del file per il caricamento dati, in byte'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Fornire la dimensione massima globale dei file per il caricamento dei dati SQL Workshop. Tenere presente che esistono limiti inferiori per i file XML e XSLX, nonch\00E9 per i file JSON nei database 11.2 e 12.1. Questa impostazione consente di configurare')
||' il limite per la dimensione globale di tutti i tipi di file.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(337361432473658487.4054)
,p_name=>'P16_ALLOW_TRACING'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(169312431105116196.4054)
,p_item_default=>'Y'
,p_prompt=>'Abilita trace applicazione'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Abilita o disabilita il trace delle applicazioni &PRODUCT_NAME.. Se questa opzione \00E8 abilitata, gli sviluppatori possono generare file di trace di database per tutta esecuzione di un evento di pagina.'),
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(483424604396106602.4054)
,p_name=>'P16_WEBSHEET_OBJECT'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(169304800930079016.4054)
,p_item_default=>'Y'
,p_prompt=>'Crea oggetti Websheet in nuove aree di lavoro'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Controlla la creazione degli oggetti di Websheet durante la creazione di nuove aree di lavoro. Per disabilitare la creazione degli oggetti di Websheet, selezionare <b>No</b>.  ',
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492054609484746145.4054)
,p_name=>'P16_WEBSHEET_SQL_ACCESS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(169304800930079016.4054)
,p_item_default=>'Y'
,p_prompt=>'Abilita accesso SQL nei Websheet'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Controlla la possibilit\00E0 di usare la tag SQL e di creare report SQL nei Websheet &PRODUCT_NAME.. Quando \00E8 disabilitato, a tutte le applicazioni Websheet di tutte le aree di lavoro dell''istanza verr\00E0 negata la possibilit\00E0 di usare la tag SQL o di crea')
||'re report SQL.',
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(521637788671366439.4054)
,p_name=>'P16_SWAGGER_UI_URL'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(521637608266366438.4054)
,p_prompt=>'URL interfaccia utente Swagger'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>80
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Definisce l''URL che punta al server dell''interfaccia utente SWAGGER 2.0+ che dovr\00E0 essere utilizzato dal Workshop REST ORDS durante la generazione della documentazione per un modulo. Se l''URL viene specificato, l''URI della documentazione Swagger d')
||unistr('el Web Service verr\00E0 passato al server dell''interfaccia utente Swagger. Se invece l''URL non viene specificato, verr\00E0 prodotta una notazione JSON raw.</p>'),
'',
'<p>Il server dell''interfaccia utente Swagger deve essere in grado di raggiungere l''URI di Web Service di riferimento per generare la documentazione. Quando si utilizza un servizio di interfaccia Swagger di terze parti, esaminarne le norme sulla priva'
||unistr('cy per capire le modalit\00E0 di utilizzo e condivisione delle informazioni raccolte.</p>')))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(582421357301226501.4054)
,p_name=>'P16_WEBSERVICE_LOGGING'
,p_is_required=>true
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(169312431105116196.4054)
,p_item_default=>'U'
,p_prompt=>unistr('Log attivit\00E0 Web Service')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'WEBSERVICE LOGGING'
,p_lov=>'.'||wwv_flow_api.id(582428114482274404.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Selezionare la modalit\00E0 di registrazione dell''attivit\00E0 Web Service per tutte le aree di lavoro dell''istanza.'),
'<p>Sono disponibili le opzioni riportate di seguito.',
'<ul>',
unistr('<li><b>Usa impostazioni area di lavoro (predefinito)</b>: usa l''attributo Log Web Service di ogni area di lavoro per determinare se l''attivit\00E0 deve essere registrata.</li>'),
'<li><b>Mai</b>: disabilita il log Web Service per tutte le aree di lavoro dell''istanza.</li>',
'<li><b>Sempre</b>: abilita il log Web Service per tutte le aree di lavoro dell''istanza.</li>',
'</ul>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(689844200493496911.4054)
,p_name=>'P16_TEAM_DEV_FILES_YN'
,p_is_required=>true
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(689843502838462013.4054)
,p_item_default=>'Y'
,p_prompt=>'Abilita repository file di Team Development'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Selezionare <strong>S\00EC</strong> per tutte le nuove aree di lavoro create in questa istanza per consentire il caricamento dei file nel repository file del Team Development precedente. Selezionare <strong>No</strong> per tutte le nuove aree di lavoro c')
||'reate in questa istanza per non consentire il caricamento dei file nel repository file del Team Development precedente.',
'<br>',
'<br>',
'Questa impostazione non ha effetto sulle aree di lavoro esistenti.'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(689845678483533445.4054)
,p_name=>'P16_TEAM_DEV_FS_LIMIT'
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(689843502838462013.4054)
,p_item_default=>'15728640'
,p_prompt=>'Dimensione massima file (in MB)'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TEAM_DEV_FS_LIMIT'
,p_lov=>'.'||wwv_flow_api.id(689538645438591983.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Selezionare la dimensione massima per qualsiasi file caricato nel repository file del Team Development precedente. Il valore predefinito \00E8 15 MB.</p>'),
'',
'<p>Questa impostazione non ha effetto sulle aree di lavoro esistenti.</p>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801931419084659361.4054)
,p_name=>'P16_RESTFUL_SERVICES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(521637608266366438.4054)
,p_item_default=>'Y'
,p_prompt=>'Abilita servizi RESTful'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Controlla la possibilit\00E0 di creare e accedere ai servizi RESTful mappati a istruzioni SQL e PL/SQL. I servizi RESTful possono essere inoltre abilitati o disabilitati per singole aree di lavoro.</p>'),
'',
unistr('<p>La funzionalit\00E0 Servizi RESTful \00E8 disponibile solo quando si usa Oracle REST Data Services 2.0 o versione successiva come listener Web.</p>')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(908176812321701564.4054)
,p_name=>'P16_SERVICE_REQUESTS'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(908012317600684138.4054)
,p_item_default=>'Y'
,p_prompt=>'Abilita richieste di servizio'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('Controlla la capacit\00E0 degli amministratori dell''area di lavoro di creare richieste di servizio nella finestra Amministrazione area di lavoro. Le richieste di servizio includono la capacit\00E0 di richiedere un nuovo schema, una richiesta di memoria oppur')
||'e una richiesta di cessazione della relativa area di lavoro.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(637919682872057.4054)
,p_computation_sequence=>10
,p_computation_item=>'F4050_P15_ID'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_comment=>'Set the value of the item conainting the primary key to null when asked to create a new row.'
,p_compute_when=>'CREATE_ROW'
,p_compute_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(171947423698040938.4054)
,p_validation_name=>'P16_SQL_C_MAX_INACTIVITY must be positive integer'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_number number;',
'begin',
'    l_number := to_number( :P16_SQL_C_MAX_INACTIVITY );',
'    if l_number = abs(trunc(l_number)) then',
'        return TRUE;',
'    else ',
'        return FALSE;',
'    end if;',
'exception',
'    when others then',
'        return FALSE;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Il valore deve essere un numero intero positivo.'
,p_when_button_pressed=>wwv_flow_api.id(169388709307261209.4054)
,p_associated_item=>wwv_flow_api.id(169299221292053451.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(172007922499154166.4054)
,p_validation_name=>'P16_SQL_SCRIPT_MAX_OUTPUT_SIZE positive integer'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_number number;',
'begin',
'    l_number := to_number( :P16_SQL_SCRIPT_MAX_OUTPUT_SIZE );',
'    if l_number = abs(trunc(l_number)) then',
'        return TRUE;',
'    else ',
'        return FALSE;',
'    end if;',
'exception',
'    when others then',
'        return FALSE;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Il valore deve essere un numero intero positivo.'
,p_when_button_pressed=>wwv_flow_api.id(169388709307261209.4054)
,p_associated_item=>wwv_flow_api.id(169299418817053452.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(172010617436162145.4054)
,p_validation_name=>'P16_WORKSPACE_MAX_OUTPUT_SIZE positive integer'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_number number;',
'begin',
'    l_number := to_number( :P16_WORKSPACE_MAX_OUTPUT_SIZE );',
'    if l_number = abs(trunc(l_number)) then',
'        return TRUE;',
'    else ',
'        return FALSE;',
'    end if;',
'exception',
'    when others then',
'        return FALSE;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Il valore deve essere un numero intero positivo.'
,p_when_button_pressed=>wwv_flow_api.id(169388709307261209.4054)
,p_associated_item=>wwv_flow_api.id(169299604071053452.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(172014314796170894.4054)
,p_validation_name=>'P16_MAX_SCRIPT_SIZE positive integer'
,p_validation_sequence=>40
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_number number;',
'begin',
'    l_number := to_number( :P16_MAX_SCRIPT_SIZE );',
'    if l_number = abs(trunc(l_number)) then',
'        return TRUE;',
'    else ',
'        return FALSE;',
'    end if;',
'exception',
'    when others then',
'        return FALSE;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Il valore deve essere un numero intero positivo.'
,p_when_button_pressed=>wwv_flow_api.id(169388709307261209.4054)
,p_associated_item=>wwv_flow_api.id(169299802122053454.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(689846059611545544.4054)
,p_name=>'Show/Hide Team Dev File Size Limit'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P16_TEAM_DEV_FILES_YN'
,p_condition_element=>'P16_TEAM_DEV_FILES_YN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'N'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(689846384315545545.4054)
,p_event_id=>wwv_flow_api.id(689846059611545544.4054)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P16_TEAM_DEV_FS_LIMIT'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(689846540959545546.4054)
,p_event_id=>wwv_flow_api.id(689846059611545544.4054)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P16_TEAM_DEV_FS_LIMIT'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1221105941620123.4054)
,p_name=>'Show/Hide Issue File Size'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P16_ISSUE_FILES_YN'
,p_condition_element=>'P16_ISSUE_FILES_YN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1221256529620124.4054)
,p_event_id=>wwv_flow_api.id(1221105941620123.4054)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P16_ISSUE_FS_LIMIT'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1221395384620125.4054)
,p_event_id=>wwv_flow_api.id(1221105941620123.4054)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P16_ISSUE_FS_LIMIT'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(169602917870557035.4054)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fetch values from platform prefs table'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P16_PKG_APP_AUTH_ALLOW_HHEAD := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''PKG_APP_AUTH_ALLOW_HHEAD'' );',
':P16_PKG_APP_AUTH_ALLOW_LDAP := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''PKG_APP_AUTH_ALLOW_LDAP'' );',
':P16_PKG_APP_AUTH_ALLOW_SSO := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''PKG_APP_AUTH_ALLOW_SSO'' );',
'',
':P16_PLSQL_EDITING := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''PLSQL_EDITING'' );',
'',
':P16_WORKSPACE_P_DEMO_OBJECT := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''WORKSPACE_PROVISION_DEMO_OBJECTS'' );',
'',
':P16_WEBSHEET_OBJECT := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''WORKSPACE_WEBSHEET_OBJECTS'' );',
'',
':P16_SQL_C_MAX_INACTIVITY := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''SQL_COMMAND_MAX_INACTIVITY'' );',
'',
':P16_SQL_SCRIPT_MAX_OUTPUT_SIZE := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''SQL_SCRIPT_MAX_OUTPUT_SIZE'' );',
'',
':P16_WORKSPACE_MAX_OUTPUT_SIZE := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''WORKSPACE_MAX_OUTPUT_SIZE'' );',
'',
':P16_MAX_SCRIPT_SIZE := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''MAX_SCRIPT_SIZE'' );',
'',
':P16_ALLOW_DB_MONITOR := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''ALLOW_DB_MONITOR'' );',
'',
':P16_ENABLE_TRANSACTIONAL_SQL := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''ENABLE_TRANSACTIONAL_SQL'' );',
'',
':P16_WEBSHEET_SQL_ACCESS := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''WEBSHEET_SQL_ACCESS'' );',
'',
':P16_APP_ACTIVITY_LOGGING := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''APPLICATION_ACTIVITY_LOGGING'' );',
'    ',
':P16_WEBSERVICE_LOGGING := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''WEBSERVICE_LOGGING'' );',
'',
':P16_RESTFUL_SERVICES :=',
'    wwv_flow_platform.get_preference( p_preference_name => ''RESTFUL_SERVICES_ENABLED'' );',
'',
':P16_SWAGGER_UI_URL :=',
'    wwv_flow_platform.get_preference( p_preference_name => ''SWAGGER_UI_URL'' );',
'    ',
':P16_SERVICE_REQUESTS :=',
'    wwv_flow_platform.get_preference( p_preference_name => ''SERVICE_REQUESTS_ENABLED'' );',
'',
':P16_ALLOW_TRACING :=',
'    wwv_flow_platform.get_preference( p_preference_name => ''TRACING_ENABLED'' );',
'',
':P16_TEAM_DEV_FILES_YN :=',
'    wwv_flow_platform.get_preference( p_preference_name => ''WORKSPACE_TEAM_DEV_FILES_YN'' );',
'',
':P16_TEAM_DEV_FS_LIMIT :=',
'    wwv_flow_platform.get_preference( p_preference_name => ''WORKSPACE_TEAM_DEV_FS_LIMIT'' );',
'    ',
'    ',
':P16_DATA_LOADING_JOB_CLASS :=',
'    wwv_flow_platform.get_preference( p_preference_name => ''DATA_LOADING_JOB_CLASS'' );',
'',
':P16_DATA_LOADING_MAX_FILE_SIZE :=',
'    wwv_flow_platform.get_preference( p_preference_name => ''DATA_LOADING_MAX_FILE_SIZE'' );',
'    ',
':P16_ISSUE_FILES_YN :=',
'    wwv_flow_platform.get_preference( p_preference_name => ''WORKSPACE_ISSUE_FILES_YN'' );',
'',
':P16_ISSUE_FS_LIMIT :=',
'    wwv_flow_platform.get_preference( p_preference_name => ''WORKSPACE_ISSUE_FS_LIMIT'' );',
'',
'',
''))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1222261495620134.4054)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Remove Spaces from File Types'
,p_process_sql_clob=>':P16_ISSUE_ALLOWED_FILE_TYPES := trim(BOTH '':'' FROM replace(:P16_ISSUE_ALLOWED_FILE_TYPES,'' '',''''));'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(169524720875349790.4054)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Apply Changes'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'--',
'-- See if the preference value for activity logging has changed, and if so, then update the logging attribute of all non-internal applications in the instance',
'--',
'if nvl(wwv_flow_platform.get_preference( p_preference_name => ''APPLICATION_ACTIVITY_LOGGING'' ),''X'') <> nvl(:P16_APP_ACTIVITY_LOGGING,''Y'') then',
'    update wwv_flows',
'       set webdb_logging = decode(:P16_APP_ACTIVITY_LOGGING,''A'',''YES'',''N'',''NO'',webdb_logging)',
'     where security_group_id not in (10,11);',
'end if;',
'',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''PLSQL_EDITING'',',
'                                  p_preference_value => :P16_PLSQL_EDITING );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''WORKSPACE_PROVISION_DEMO_OBJECTS'',',
'                                  p_preference_value => :P16_WORKSPACE_P_DEMO_OBJECT );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''WORKSPACE_WEBSHEET_OBJECTS'',',
'                                  p_preference_value => :P16_WEBSHEET_OBJECT );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''SQL_COMMAND_MAX_INACTIVITY'',',
'                                  p_preference_value => :P16_SQL_C_MAX_INACTIVITY );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''SQL_SCRIPT_MAX_OUTPUT_SIZE'',',
'                                  p_preference_value => :P16_SQL_SCRIPT_MAX_OUTPUT_SIZE );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''WORKSPACE_MAX_OUTPUT_SIZE'',',
'                                  p_preference_value => :P16_WORKSPACE_MAX_OUTPUT_SIZE );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''MAX_SCRIPT_SIZE'',',
'                                  p_preference_value => :P16_MAX_SCRIPT_SIZE );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''ALLOW_DB_MONITOR'',',
'                                  p_preference_value => :P16_ALLOW_DB_MONITOR );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''ENABLE_TRANSACTIONAL_SQL'',',
'                                  p_preference_value => :P16_ENABLE_TRANSACTIONAL_SQL );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''WEBSHEET_SQL_ACCESS'',',
'                                  p_preference_value => :P16_WEBSHEET_SQL_ACCESS );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''APPLICATION_ACTIVITY_LOGGING'',',
'                                  p_preference_value => :P16_APP_ACTIVITY_LOGGING );',
'if :P16_WEBSERVICE_LOGGING is not null then                                  ',
'wwv_flow_platform.set_preference( p_preference_name => ''WEBSERVICE_LOGGING'',',
'                                  p_preference_value => :P16_WEBSERVICE_LOGGING );',
'end if;',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''RESTFUL_SERVICES_ENABLED'',',
'                                  p_preference_value => :P16_RESTFUL_SERVICES );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''SWAGGER_UI_URL'',',
'                                  p_preference_value => :P16_SWAGGER_UI_URL );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''SERVICE_REQUESTS_ENABLED'',',
'                                  p_preference_value => :P16_SERVICE_REQUESTS );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''PKG_APP_AUTH_ALLOW_HHEAD'',',
'                                  p_preference_value => :P16_PKG_APP_AUTH_ALLOW_HHEAD );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''PKG_APP_AUTH_ALLOW_LDAP'',',
'                                  p_preference_value => :P16_PKG_APP_AUTH_ALLOW_LDAP );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''PKG_APP_AUTH_ALLOW_SSO'',',
'                                  p_preference_value =>:P16_PKG_APP_AUTH_ALLOW_SSO  );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''TRACING_ENABLED'',',
'                                  p_preference_value => :P16_ALLOW_TRACING );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''WORKSPACE_TEAM_DEV_FILES_YN'',',
'                                  p_preference_value => :P16_TEAM_DEV_FILES_YN );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''WORKSPACE_TEAM_DEV_FS_LIMIT'',',
'                                  p_preference_value => :P16_TEAM_DEV_FS_LIMIT );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''DATA_LOADING_JOB_CLASS'',',
'                                  p_preference_value => :P16_DATA_LOADING_JOB_CLASS );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''DATA_LOADING_MAX_FILE_SIZE'',',
'                                  p_preference_value => :P16_DATA_LOADING_MAX_FILE_SIZE );',
'                                  ',
'wwv_flow_platform.set_preference( p_preference_name => ''WORKSPACE_ISSUE_FILES_YN'',',
'                                  p_preference_value => :P16_ISSUE_FILES_YN );',
'',
'wwv_flow_platform.set_preference( p_preference_name => ''WORKSPACE_ISSUE_FS_LIMIT'',',
'                                  p_preference_value => :P16_ISSUE_FS_LIMIT );',
'                                  ',
'                                ',
'commit;',
'',
''))
,p_process_error_message=>'Impossibile salvare le impostazioni di configurazione funzioni.'
,p_process_when_button_id=>wwv_flow_api.id(169388709307261209.4054)
,p_process_success_message=>'Impostazioni di configurazione funzioni salvate.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(35198113704069357.4054)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'16'
);
end;
/
prompt --application/pages/page_00017
begin
wwv_flow_api.create_page(
 p_id=>17.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Crea/Modifica task specifici del sito'
,p_step_title=>'Crea/Modifica task specifici del sito'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216789322970659213)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>'AEADM/adm_env_sec.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(951627136736335.4054)
,p_plug_name=>'Task specifici del sito'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'generated 04-MAR-2001 19:43:24'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(952029128736337.4054)
,p_plug_name=>'Task specifici del sito'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specificare i task per le liste dei task specifici del sito che devono comparire nelle pagine Login ad area di lavoro e Home area di lavoro.</p>',
unistr('<p>Per stabilire se un task deve essere visualizzato, selezionare <b>S\00EC</b> o <b>No</b> dalla lista Visualizzato.</p>')))
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168832320396520620.4054)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>5
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(952714907736406.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(168832320396520620.4054)
,p_button_name=>'Cancel'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_cattributes=>'class="button10"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(953528940736408.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(168832320396520620.4054)
,p_button_name=>'Delete'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Elimina'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P17_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_button_cattributes=>'class="button10"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(952400766736345.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(168832320396520620.4054)
,p_button_name=>'ApplyChanges'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P17_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_button_cattributes=>'class="button10"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(953110060736407.4054)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(168832320396520620.4054)
,p_button_name=>'Create'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P17_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_button_cattributes=>'class="button10"'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(75294331022650118.4054)
,p_branch_action=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:17::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(75293614053645275.4054)
,p_branch_action=>'f?p=&FLOW_ID.:18:&SESSION.::&DEBUG.:17::'
,p_branch_point=>'BEFORE_COMPUTATION'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(952714907736406.4054)
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(953917950736415.4054)
,p_name=>'P17_TASK_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(951627136736335.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Nome task'
,p_source=>'TASK_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_cHeight=>2
,p_field_template=>wwv_flow_api.id(721133598269759785.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Immettere il testo da visualizzare con la destinazione del collegamento oppure il testo da visualizzare qualora non sia specificato nessun collegamento per questo task.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(954517336736480.4054)
,p_name=>'P17_TASK_LINK'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(951627136736335.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Collegamento a task'
,p_source=>'TASK_LINK'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>2
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Immettere una destinazione del collegamento facoltativa da visualizzare nell''area dei task. Ad esempio:',
'<pre>http://www.oracle.com</pre>'))
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(955210485736485.4054)
,p_name=>'P17_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(951627136736335.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Id'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(75234509655426344.4054)
,p_name=>'P17_DISPLAY_SEQUENCE'
,p_item_sequence=>12
,p_item_plug_id=>wwv_flow_api.id(951627136736335.4054)
,p_use_cache_before_default=>'NO'
,p_item_default=>'10'
,p_prompt=>'Sequenza di visualizzazione'
,p_source=>'DISPLAY_SEQUENCE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>5
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(721133598269759785.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Definisce l''ordine relativo in cui compaiono i collegamenti all''interno di ogni lista di task.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(75236031126432516.4054)
,p_name=>'P17_DISPLAYED'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(951627136736335.4054)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>'Visualizzato'
,p_source=>'DISPLAYED'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>5
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Determina se viene visualizzato un task o un collegamento. Selezionare <b>S\00EC</b> per abilitare la visualizzazione oppure <b>No</b> per disabilitarla.')
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(75239916843447392.4054)
,p_name=>'P17_DISPLAY_LOCATION'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(951627136736335.4054)
,p_use_cache_before_default=>'NO'
,p_item_default=>'WORKSPACE_HOME'
,p_prompt=>'Posizione di visualizzazione'
,p_source=>'DISPLAY_LOCATION'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'TASK_DISPLAY_LOCATION'
,p_lov=>'.'||wwv_flow_api.id(75242612126455451.4054)||'.'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Selezionare la lista di task in cui deve comparire questo collegamento o testo. Le opzioni disponibili sono le seguenti:',
'<ul>',
'<li>pagina Home area di lavoro</li>',
'<li>pagina Login ad area di lavoro</li>',
'</ul>'))
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(956110817736502.4054)
,p_validation_name=>'value is required'
,p_validation_sequence=>20
,p_validation=>'P17_TASK_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare il testo.'
,p_validation_condition=>'Create,ApplyChanges'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(953917950736415.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(152718005693876831.4054)
,p_validation_name=>'name not whitespace'
,p_validation_sequence=>30
,p_validation=>'replace(:P17_TASK_NAME,'' '',null) is not null'
,p_validation_type=>'PLSQL_EXPRESSION'
,p_error_message=>unistr('Il nome task non pu\00F2 contenere tutti spazi vuoti.')
,p_validation_condition=>'ApplyChanges,Create'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(953917950736415.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(202090127032390388.4054)
,p_validation_name=>'display sequence must be numeric'
,p_validation_sequence=>40
,p_validation=>'P17_DISPLAY_SEQUENCE'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>'Il valore deve essere numerico.'
,p_validation_condition=>'Create, ApplyChanges'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(75234509655426344.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(956523719736519.4054)
,p_process_sequence=>1
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_CUSTOMIZED_TASKS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_CUSTOMIZED_TASKS'
,p_attribute_03=>'P17_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_process_error_message=>'Errore durante il recupero della riga.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(152749516531012440.4054)
,p_process_sequence=>11
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set ID'
,p_process_sql_clob=>':P17_ID := wwv_flow_id.next_val;'
,p_process_when=>'P17_ID'
,p_process_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(956903422736535.4054)
,p_process_sequence=>21
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_CUSTOMIZED_TASKS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_CUSTOMIZED_TASKS'
,p_attribute_03=>'P17_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>'Errore durante l''elaborazione della riga della tabella WWV_FLOW_CUSTOMIZED_TASKS.'
,p_process_success_message=>'Azione elaborata.'
);
end;
/
prompt --application/pages/page_00018
begin
wwv_flow_api.create_page(
 p_id=>18.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Task specifici del sito'
,p_step_title=>'Task specifici del sito'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216765317551591446)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>'AEADM/adm_env_sec.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(960020599743353.4054)
,p_plug_name=>'Task specifici del sito'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'Questi collegamenti vengono visualizzati nelle pagine Home area di lavoro e Login ad area di lavoro come liste di task specifici del sito.'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(964406793756833.4054)
,p_name=>'Task specifici del sito'
,p_template=>wwv_flow_api.id(517418631967368160.4054)
,p_display_sequence=>50
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id, ',
'   display_sequence, ',
'   task_name, ',
'   task_link, ',
'   decode(',
'      display_location,',
'     ''WORKSPACE_HOME'',',
'      wwv_flow_lang.system_message(''F4050.WORKSPACE_HOME''),',
'     ''WORKSPACE_LOGIN'',',
'     wwv_flow_lang.system_message(''F4050.WORKSPACE_LOGIN'')',
'     ) display_location, ',
'   decode(',
'     displayed,',
'     ''Y'',',
'     wwv_flow_lang.system_message(''F4000.YES''),',
'     wwv_flow_lang.system_message(''F4000.NO'')',
'     ) displayed',
'from wwv_flow_customized_tasks'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(805672157251677851.4054)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_no_data_found=>'nessun task trovato'
,p_query_num_rows_type=>'ROW_RANGES_WITH_LINKS'
,p_query_row_count_max=>50000
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(75164114382143826.4054)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_hidden_column=>'Y'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(965130942757270.4054)
,p_query_column_id=>2
,p_column_alias=>'DISPLAY_SEQUENCE'
,p_column_display_sequence=>3
,p_column_heading=>'Sequenza'
,p_use_as_row_header=>'N'
,p_column_alignment=>'RIGHT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(964932084757269.4054)
,p_query_column_id=>3
,p_column_alias=>'TASK_NAME'
,p_column_display_sequence=>2
,p_column_heading=>'Nome'
,p_column_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:17:P17_ID:#ID#'
,p_column_linktext=>'#TASK_NAME#'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(965011042757269.4054)
,p_query_column_id=>4
,p_column_alias=>'TASK_LINK'
,p_column_display_sequence=>5
,p_column_heading=>'Collegamento a task'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(965232430757270.4054)
,p_query_column_id=>5
,p_column_alias=>'DISPLAY_LOCATION'
,p_column_display_sequence=>4
,p_column_heading=>'Visualizzato nella pagina'
,p_use_as_row_header=>'N'
,p_default_sort_column_sequence=>1
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(965320533757270.4054)
,p_query_column_id=>6
,p_column_alias=>'DISPLAYED'
,p_column_display_sequence=>6
,p_column_heading=>'Visualizza'
,p_use_as_row_header=>'N'
,p_column_alignment=>'CENTER'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(200723903023857946.4054)
,p_plug_name=>'Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(961500556743430.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(200723903023857946.4054)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(961902894743435.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(200723903023857946.4054)
,p_button_name=>'CREATE_ROW'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372670814202760.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(962710881743501.4054)
,p_branch_action=>'17'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>1
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'CREATE_ROW'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(963118584743503.4054)
,p_branch_action=>'5'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(962412919743490.4054)
,p_computation_sequence=>1
,p_computation_item=>'P17_ID'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_comment=>'Set the value of the item conainting the primary key to null when asked to create a new row.'
,p_compute_when=>'CREATE_ROW'
,p_compute_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00019
begin
wwv_flow_api.create_page(
 p_id=>19.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>unistr('Gestisci log di attivit\00E0 dello sviluppatore')
,p_step_title=>unistr('Gestisci log di attivit\00E0 dello sviluppatore')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216783731365642767)
,p_step_template=>wwv_flow_api.id(721099117305687972.4054)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_logs.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19799503430565082.4054)
,p_plug_name=>unistr('Voci di log di attivit\00E0 dello sviluppatore')
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(829706609080810173.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   c_dev pls_integer := 0;',
'',
'begin',
'/*',
'sys.htp.p(''<table class="htmldbInstructionText" role="presentation"><tbody>'');',
'select count(*) into c_dev from wwv_flow_builder_audit_trail;',
'sys.htp.p(''<tr><td>''||wwv_flow_lang.system_message(''4050_19_LOG_ENTRIES'')||''</td>'');',
'sys.htp.p(''<td align="right">''|| to_char(c_dev,''999,999,999,990'') || ''</td></tr>'');',
'sys.htp.p(''</tbody></table>'');',
'*/',
'select count(*) into c_dev from wwv_flow_builder_audit_trail;',
'sys.htp.p(''<p>''||wwv_flow_lang.system_message(''4050_19_LOG_ENTRIES'')||'': '');',
'sys.htp.p(to_char(c_dev,''999,999,999,990'')||''</p>'');',
'',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(982230745511899631.4054)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(582425076905226538.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(982230745511899631.4054)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Salva impostazione di conservazione'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(19803315335578026.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(982230745511899631.4054)
,p_button_name=>'DELETE_ENTRIES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Elimina voci'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(19847614137691252.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(982230745511899631.4054)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(19803703152578047.4054)
,p_branch_action=>'19'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_when_button_id=>wwv_flow_api.id(19803315335578026.4054)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19801228364572352.4054)
,p_name=>'P19_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(19799503430565082.4054)
,p_prompt=>unistr('Elimina le voci di questo numero di giorni e pi\00F9 vecchie:')
,p_source=>'31'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIME_INTERVALS'
,p_lov=>'.'||wwv_flow_api.id(87720511660244788.4054)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Eliminare le voci del log di attivit\00E0 che sono presenti da un numero di giorni maggiore di quello specificato.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(582424812492226536.4054)
,p_name=>'P19_AUDIT_LOG_RETENTION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(19799503430565082.4054)
,p_prompt=>'Giorni di conservazione log sviluppatore'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>6
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('Immettere il numero di giorni per conservare le voci del log degli sviluppatori. Le voci pi\00F9 vecchie rispetto a questa impostazione verranno eliminate durante la manutenzione giornaliera.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(19880014493766985.4054)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete rows'
,p_process_sql_clob=>'delete from WWV_FLOW_BUILDER_AUDIT_TRAIL where AUDIT_DATE < (sysdate - nvl(:p19_time,31))'
,p_process_error_message=>unistr('Errore durante l''eliminazione del log di attivit\00E0 dello sviluppatore.')
,p_process_when_button_id=>wwv_flow_api.id(19803315335578026.4054)
,p_process_success_message=>unistr('Log di attivit\00E0 dello sviluppatore eliminato.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(582425141822226539.4054)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Apply Changes'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_platform.set_preference( ',
'    p_preference_name  => ''AUDIT_LOG_RETENTION'',',
'    p_preference_value => :P19_AUDIT_LOG_RETENTION );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(582425076905226538.4054)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(582424972443226537.4054)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fetch value from platform_prefs'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P19_AUDIT_LOG_RETENTION := ',
'    wwv_flow_platform.get_preference( p_preference_name => ''AUDIT_LOG_RETENTION'' );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00020
begin
wwv_flow_api.create_page(
 p_id=>20.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Modifica assegnazione schema ad area di lavoro'
,p_alias=>'P20'
,p_page_mode=>'MODAL'
,p_step_title=>'Modifica assegnazione schema ad area di lavoro'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216765317551591446)
,p_step_template=>wwv_flow_api.id(721098050798687927.4054)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'250'
,p_dialog_width=>'450'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'AEADM/adm_mg_wrkspc.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(680521474522216.4054)
,p_plug_name=>'Assegnazione schema ad area di lavoro'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(721130166613730309.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'generated 10-MAR-2001 10:51:46'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(982230881241899632.4054)
,p_plug_name=>'Pulsanti'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(681012794522218.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(982230881241899632.4054)
,p_button_name=>'Delete'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Elimina'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>':F4050_P20_ID is not null and :P20_IS_FIRST_SCHEMA = ''N'''
,p_button_condition_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(681208267522219.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(982230881241899632.4054)
,p_button_name=>'Apply_Changes'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'F4050_P20_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(681404738522220.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(982230881241899632.4054)
,p_button_name=>'Create'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'F4050_P20_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(680801594522218.4054)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(982230881241899632.4054)
,p_button_name=>'Cancel'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(680228915522216.4054)
,p_branch_action=>'21'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(274506709117217135.4054)
,p_branch_action=>'f?p=&APP_ID.:78:&SESSION.::&DEBUG.::P78_PROVISIONING_COMPANY_ID:&F4050_P20_SECURITY_GROUP_ID.'
,p_branch_point=>'BEFORE_COMPUTATION'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'F4050_P20_SECURITY_GROUP_ID'
,p_branch_condition_text=>'10'
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(681626422522223.4054)
,p_name=>'F4050_P20_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(680521474522216.4054)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(681827271522225.4054)
,p_name=>'F4050_P20_SECURITY_GROUP_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(680521474522216.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Area di lavoro'
,p_source=>'SECURITY_GROUP_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'LIST_DEVELOPER_WORKSPACES_NO_NULL_OPTION'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,',
'       PROVISIONING_COMPANY_ID r',
'from   WWV_FLOW_COMPANIES',
'where  provisioning_company_id not in (0,10,11, 12)',
'order by 1'))
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Identificare l''area di lavoro.'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(682001271522225.4054)
,p_name=>'F4050_P20_SCHEMA'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(680521474522216.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Schema di database'
,p_source=>'SCHEMA'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select username d,',
'       username r',
'  from wwv_flow_admin_all_schemas s,',
'       ( select short_name',
'           from wwv_flow_companies',
'          where provisioning_company_id = :F4050_P20_SECURITY_GROUP_ID ) ws',
' where (   restricted_to_workspace is null',
'        or restricted_to_workspace = ws.short_name)',
' order by 1'))
,p_lov_cascade_parent_items=>'F4050_P20_SECURITY_GROUP_ID'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Identificare lo schema corrispondente.'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(12950002945536473.4054)
,p_name=>'P20_PREVIOUS_SCHEMA'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(680521474522216.4054)
,p_use_cache_before_default=>'NO'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(135418406612396046.4054)
,p_name=>'P20_IS_FIRST_SCHEMA'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(680521474522216.4054)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(12950302646564854.4054)
,p_computation_sequence=>10
,p_computation_item=>'P20_PREVIOUS_SCHEMA'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'     l_schema varchar2(4000);',
'begin',
'     for c1 in (select schema from wwv_flow_company_schemas where security_group_id = :F4050_P20_SECURITY_GROUP_ID and id = :F4050_P20_ID) loop',
'         l_schema := c1.schema;',
'     end loop;',
'    return l_schema;',
'end;  '))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(135422609644415804.4054)
,p_computation_sequence=>10
,p_computation_item=>'P20_IS_FIRST_SCHEMA'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select a.schema, b.first_schema_provisioned',
'             from wwv_flow_company_schemas a, wwv_flow_companies b',
'            where a.security_group_id = b.provisioning_company_id',
'              and a.id = :F4050_P20_ID ) loop',
'  if c1.schema = c1.first_schema_provisioned then',
'    return ''Y'';',
'  else ',
'    return ''N'';',
'  end if;',
'  exit;',
'end loop;'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(206354662431953019.4054)
,p_name=>'Cancel dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(680801594522218.4054)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(206354732706953020.4054)
,p_event_id=>wwv_flow_api.id(206354662431953019.4054)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(682212029522226.4054)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_COMPANY_SCHEMAS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_COMPANY_SCHEMAS'
,p_attribute_03=>'F4050_P20_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>'Errore durante il recupero della riga.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(274482203755203147.4054)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'check schema'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_provisioning.reserved_schema(p_schema => :F4050_P20_SCHEMA)',
' or ',
'  (wwv_flow_provisioning.site_admin_is_restricted and ',
'   wwv_flow_provisioning.restricted_schema(',
'     p_schema =>  :F4050_P20_SCHEMA, ',
'     p_workspace_name => wwv_flow_security.find_company_name(:F4050_P20_SECURITY_GROUP_ID))) then',
'  :F4050_P20_SCHEMA := ''INVALID'';',
'end if;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(682401703522227.4054)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_COMPANY_SCHEMAS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_COMPANY_SCHEMAS'
,p_attribute_03=>'F4050_P20_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>'Errore durante l''elaborazione della riga.'
,p_process_success_message=>'Azione elaborata.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(12121519965351173.4054)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Users'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :F4050_P20_SCHEMA <> ''INVALID'' then',
'  wwv_flow_provisioning.update_user_default_schema(',
'           p_security_group_id     => :F4050_P20_SECURITY_GROUP_ID,',
'           p_new_schema            => :F4050_P20_SCHEMA,',
'           p_old_schema            => :P20_PREVIOUS_SCHEMA);',
'end if;'))
,p_process_error_message=>'Errore durante l''elaborazione della riga.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(681208267522219.4054)
,p_process_success_message=>'Azione elaborata.'
);
end;
/
prompt --application/pages/page_00021
begin
wwv_flow_api.create_page(
 p_id=>21.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Gestisci assegnazioni area di lavoro a schema'
,p_step_title=>'Gestisci assegnazioni area di lavoro a schema'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216765317551591446)
,p_step_template=>wwv_flow_api.id(517336519765126407.4054)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_schema_assign.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19713719462515413.4054)
,p_plug_name=>'Schemi area di lavoro'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>Questo report elenca gli schemi che una determinata area di lavoro pu\00F2 utilizzare per la creazione. Quando gli sviluppatori creano nuove applicazioni, possono scegliere uno schema di creazione in base al quale far analizzare le proprie istruzioni ')
||'SQL, selezionandolo dalla lista di schemi assegnati all''area di lavoro.</p>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(32859321338800843.4054)
,p_plug_name=>'reset'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>':P106_PASSWORD := null;'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(472503211871482476.4054)
,p_plug_name=>'Schemi forniti dall''area di lavoro'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(721125879764730304.4054)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select cs.SCHEMA,',
'       c.short_name,',
'       cs.SECURITY_GROUP_ID,',
'       cs.id,',
'       case when u.username is not null then ''Y'' else ''N'' end as schema_exists',
'  from WWV_FLOW_COMPANY_SCHEMAS cs,',
'       wwv_flow_companies c,',
'       sys.all_users u',
' where cs.security_group_id = c.PROVISIONING_COMPANY_ID (+)',
'   and cs.schema = u.username (+)',
'   and cs.security_group_id not in ( 10, 11, 12 )'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(472503303297482477.4054)
,p_name=>'Schemas Provisioned by Workspace'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('Questa query restituisce pi\00F9 di 10.000 righe. Filtrare i dati per ottenere risultati completi.')
,p_no_data_found_message=>'Nessun dato trovato.'
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(472503608089482489.4054)
,p_db_column_name=>'SHORT_NAME'
,p_display_order=>1
,p_column_identifier=>'B'
,p_column_label=>'Area di lavoro'
,p_column_link=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.::F4050_P20_ID:#ID#'
,p_column_linktext=>'#SHORT_NAME#'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(472503509106482485.4054)
,p_db_column_name=>'SCHEMA'
,p_display_order=>2
,p_column_identifier=>'A'
,p_column_label=>'Schema'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(206354546530953018.4054)
,p_db_column_name=>'SCHEMA_EXISTS'
,p_display_order=>12
,p_column_identifier=>'E'
,p_column_label=>'Schema esistente'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(157992123774592395)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(472503726508482490.4054)
,p_db_column_name=>'SECURITY_GROUP_ID'
,p_display_order=>22
,p_column_identifier=>'C'
,p_column_label=>'ID area di lavoro'
,p_column_type=>'NUMBER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(472503806891482491.4054)
,p_db_column_name=>'ID'
,p_display_order=>32
,p_column_identifier=>'D'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(472517919866500137.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(472503211871482476.4054)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Reimposta'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(19713915330515414.4054)
,p_button_sequence=>100
,p_button_plug_id=>wwv_flow_api.id(472503211871482476.4054)
,p_button_name=>'Create'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372670814202760.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Aggiungi schema'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:105,106,107::'
,p_icon_css_classes=>'icon-right-chevron'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(19715800116515426.4054)
,p_branch_action=>'21'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(982230976761899633.4054)
,p_name=>'Handle Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(472503211871482476.4054)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(982231061401899634.4054)
,p_event_id=>wwv_flow_api.id(982230976761899633.4054)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(472503211871482476.4054)
);
end;
/
prompt --application/pages/page_00022
begin
wwv_flow_api.create_page(
 p_id=>22.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Gestisci privilegi database area di lavoro'
,p_step_title=>'Gestisci privilegi database area di lavoro'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(216765317551591446)
,p_step_template=>wwv_flow_api.id(721098416706687971.4054)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/adm_wrkspc_privs.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(168541603401017650.4054)
,p_plug_name=>'Privilegi area di lavoro'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(721125879764730304.4054)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4050P22a */',
'  cs.SCHEMA,',
'  c.short_name,',
'  cs.SECURITY_GROUP_ID,',
'  cs.id, p.privilege, p.admin_option',
'from ',
'  WWV_FLOW_COMPANY_SCHEMAS cs, ',
'  wwv_flow_companies c, ',
'  sys.dba_sys_privs p',
'where ',
'cs.schema = p.grantee and',
'(:P22_FIND is null or ',
' instr(p.privilege,upper(:P22_FIND)) > 0 or',
' instr(upper(cs.schema),upper(:P22_FIND)) > 0 or',
' instr(upper(c.short_name),upper(:P22_FIND)) > 0)  and',
'cs.security_group_id = c.PROVISIONING_COMPANY_ID(+)'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(168541709855017650.4054)
,p_name=>'Workspace Privileges'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('Questa query restituisce pi\00F9 di 10.000 righe. Filtrare i dati per ottenere risultati completi.')
,p_no_data_found_message=>'Nessun dato trovato.'
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(168542020537017667.4054)
,p_db_column_name=>'SHORT_NAME'
,p_display_order=>1
,p_column_identifier=>'B'
,p_column_label=>'Area di lavoro'
,p_column_link=>'f?p=4050:14:&SESSION.:REPORT:NO:14:SGID:#SECURITY_GROUP_ID#'
,p_column_linktext=>'#SHORT_NAME#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(168541906509017665.4054)
,p_db_column_name=>'SCHEMA'
,p_display_order=>2
,p_column_identifier=>'A'
,p_column_label=>'Schema'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(168542124780017668.4054)
,p_db_column_name=>'SECURITY_GROUP_ID'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'ID gruppo di sicurezza'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(168542210066017668.4054)
,p_db_column_name=>'ID'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(168542300521017669.4054)
,p_db_column_name=>'PRIVILEGE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Privilegio'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(168542430129017669.4054)
,p_db_column_name=>'ADMIN_OPTION'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Opzione di amministrazione'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(110344620122166929)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(982231175324899635.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(168541603401017650.4054)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Reimposta'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:RP,RIR,22:::'
);
end;
/
prompt --application/pages/page_00023
begin
wwv_flow_api.create_page(
 p_id=>23.4054
,p_user_interface_id=>wwv_flow_api.id(4973826483302347.4054)
,p_name=>'Crea/Modifica utente'
,p_step_title=>'Crea/Modifica utente'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(216787602191653217)
,p_step_template=>wwv_flow_api.id(704456563630760825.4054)
,p_page_template_options=>'#DEFAULT#'
,p_required_patch=>wwv_flow_api.id(3913175260740993520.4054)
,p_help_text=>'AEADM/adm_users.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4789806742494505.4054)
,p_plug_name=>'Privilegi account'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20502200062918881.4054)
,p_plug_name=>'reset'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
':F4050_P23_WEB_PASSWORD := null;',
':F4050_P23_CONFIRM_PASSWD := null;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(43032554506866236.4054)
,p_plug_name=>'Attributi utente'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings=>'UserID:Security<br>GroupID:<font color=green>Company</font>:Web<br>Password'
,p_plug_query_num_rows=>15
,p_plug_column_width=>'valign="top"'
,p_plug_query_no_data_found=>'Nessun utente basato sui cookie definito. Fare clic sull''icona di aggiunta per creare un nuovo utente.'
,p_plug_query_show_nulls_as=>'(null)'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'generated 16-MAR-2001 11:21:01'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(61303115419117985.4054)
,p_plug_name=>'&F4050_PASSWORD_REGION_TITLE.'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(161703707200871657.4054)
,p_plug_name=>'Links'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(182517420179163788.4054)
,p_plug_name=>'Crea/Modifica utente'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder:a-ButtonRegion--showTitle'
,p_plug_template=>wwv_flow_api.id(721110277025730268.4054)
,p_plug_display_sequence=>80
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(190667230101179100.4054)
,p_plug_name=>'Gruppi di utenti'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings=>'&nbsp;:Flow:User:Developer Role(s)'
,p_plug_query_num_rows=>500
,p_plug_query_num_rows_type=>'ROWS_X_TO_Y_OF_Z'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'valign="top"'
,p_plug_query_show_nulls_as=>'(null)'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_fnd boolean default false;',
'begin',
'for c1 in (',
'select 1',
'from wwv_flow_fnd_user_groups_noapp',
'where security_group_id = :F4050_P23_SECURITY_GROUP_ID ) loop',
'  l_fnd := true;',
'end loop;',
'return l_fnd;',
'end;'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(254117224240978570.4054)
,p_plug_name=>'Selettore di visualizzazione area'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(195775112470763477.4054)
,p_plug_display_sequence=>90
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(504825819331106161.4054)
,p_plug_name=>'Informazioni'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(517418631967368160.4054)
,p_plug_display_sequence=>70
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Gli amministratori del servizio &PRODUCT_NAME. possono gestire account utente per qualsiasi area di lavoro.</p>'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(43032820185866237.4054)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(182517420179163788.4054)
,p_button_name=>'Cancel'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Annulla'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:23::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(43033071157866237.4054)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(182517420179163788.4054)
,p_button_name=>'Delete'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Elimina utente'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:confirmDelete(''&DELETE_MSG.'');'
,p_button_condition=>':F4050_P23_USER_ID is not null and :F4050_P23_USER_ID != wwv_flow_user_api.get_user_id(:FLOW_USER)'
,p_button_condition_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(43033257856866238.4054)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(182517420179163788.4054)
,p_button_name=>'Apply_Changes'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Applica modifiche'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'F4050_P23_USER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(39279805171990401.4054)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(182517420179163788.4054)
,p_button_name=>'CREATE_ANOTHER'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_image_alt=>'Crea e crea di nuovo'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'F4050_P23_USER_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(43033414946866238.4054)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(182517420179163788.4054)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(517372214551202759.4054)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Crea utente'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'F4050_P23_USER_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(43031812037866231.4054)
,p_branch_name=>'Go To Page 12'
,p_branch_action=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:23::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'Create'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(39280113672990404.4054)
,p_branch_name=>'Go To Page 23'
,p_branch_action=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:23,EDIT_USER_PRIVS:F4050_P23_SECURITY_GROUP_ID:&F4050_P23_SECURITY_GROUP_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(39279805171990401.4054)
,p_branch_sequence=>20
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(43032215890866234.4054)
,p_branch_name=>'Go To Page 12'
,p_branch_action=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:23::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2691628386326712.4054)
,p_name=>'F4050_P23_DEFAULT_SCHEMA'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_prompt=>'Schema predefinito'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select schema d, schema r',
' from wwv_flow_company_schemas',
'where security_group_id = :F4050_P23_SECURITY_GROUP_ID',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Seleziona schema -'
,p_lov_cascade_parent_items=>'F4050_P23_SECURITY_GROUP_ID'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Lo schema predefinito per questo utente.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(12480015129149970.4054)
,p_name=>'P23_ACCOUNT_EXPIRY'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(12480931059154603.4054)
,p_name=>'P23_ACCOUNT_LOCKED'
,p_item_sequence=>230
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_item_default=>'N'
,p_prompt=>unistr('Disponibilit\00E0 account')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ACCOUNT_LOCK_STATUS'
,p_lov=>'.'||wwv_flow_api.id(12506800188785204.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Opzioni disponibili:',
'<ul>',
'<li>Selezionare <b>Bloccato</b> per impedire che l''account venga utilizzato.</li> ',
'<li>Selezionare <b>Sbloccato</b> per consentire l''uso dell''account.</b></li>',
'</ul>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(12481506257156915.4054)
,p_name=>'P23_FAILED_ACCESS_ATTEMPTS'
,p_item_sequence=>330
,p_item_plug_id=>wwv_flow_api.id(61303115419117985.4054)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(12482115260159568.4054)
,p_name=>'P23_CHANGE_PWD_ON_FIRST_USE'
,p_item_sequence=>270
,p_item_plug_id=>wwv_flow_api.id(61303115419117985.4054)
,p_item_default=>'''Y'''
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>'Richiedi modifica password al primo utilizzo'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Selezionare <strong>S\00EC</strong> per richiedere all''utente di modificare la password immediatamente dopo il login con la password temporanea corrente. '),
unistr('<p>Questa regola \00E8 valida per l''utilizzo di questo account per gli sviluppatori e gli amministratori di dell''area di lavoro. \00C8 valida inoltre per tutti gli utenti che utilizzano questo account per il login alle applicazioni sviluppate.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(12482722533161601.4054)
,p_name=>'P23_FIRST_PWD_USE_OCCURRED'
,p_item_sequence=>280
,p_item_plug_id=>wwv_flow_api.id(61303115419117985.4054)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(12496823435353552.4054)
,p_name=>'P23_SHOW_EXPIRE_FLAG'
,p_item_sequence=>310
,p_item_plug_id=>wwv_flow_api.id(61303115419117985.4054)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(12498809783385770.4054)
,p_name=>'P23_EXPIRATION_STATUS1'
,p_item_sequence=>290
,p_item_plug_id=>wwv_flow_api.id(61303115419117985.4054)
,p_prompt=>'Password sviluppatore/amministratore:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_css_classes=>'fielddatabold'
,p_display_when=>':F4050_P23_USER_ID is not null and :P23_EXPIRATION_STATUS1 <> ''NA'''
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Indica se la password \00E8 scaduta o valida per il login dello sviluppatore o dell''amministratore.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(12499022628385770.4054)
,p_name=>'P23_EXPIRATION_STATUS2'
,p_item_sequence=>300
,p_item_plug_id=>wwv_flow_api.id(61303115419117985.4054)
,p_prompt=>'Password utente finale:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_css_classes=>'fielddatabold'
,p_display_when=>':F4050_P23_USER_ID is not null and :P23_EXPIRATION_STATUS2 <> ''NA'''
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Indica se la password \00E8 scaduta o valida per il login dell''utente finale.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(12501217642408601.4054)
,p_name=>'P23_EXPIRE'
,p_item_sequence=>320
,p_item_plug_id=>wwv_flow_api.id(61303115419117985.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Scadenza password'
,p_display_as=>'NATIVE_CHECKBOX'
,p_lov=>'select null d, ''Y'' r from dual'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_display_when=>':P23_SHOW_EXPIRE_FLAG = ''Y'' and :F4050_P23_USER_ID is not null'
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Selezionare per specificare la scadenza della password dell''utente. Questa impostazione influisce sul login dello sviluppatore/amministratore e sull''accesso dell''utente finale. Con la password scaduta, al successivo tentativo di accesso all''account, '
||unistr('all''utente verr\00E0 richiesto di fornire la vecchia e una nuova password per poter effettuare il login.')
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(43033620636866241.4054)
,p_name=>'F4050_P23_USER_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(43032554506866236.4054)
,p_prompt=>'User ID'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(43033813964866242.4054)
,p_name=>'F4050_P23_USER_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(43032554506866236.4054)
,p_prompt=>'Nome utente'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133598269759785.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Immettere il nome utente.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(43034067641866243.4054)
,p_name=>'F4050_P23_FIRST_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(43032554506866236.4054)
,p_prompt=>'Nome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Immettere il nome dell''utente.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(43034227119866244.4054)
,p_name=>'F4050_P23_LAST_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(43032554506866236.4054)
,p_prompt=>'Cognome'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Immettere il cognome dell''utente.',
'',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(43035819093866248.4054)
,p_name=>'F4050_P23_DESCRIPTION'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(43032554506866236.4054)
,p_prompt=>'Descrizione'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>200
,p_cHeight=>3
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Immettere una descrizione facoltativa per questo utente.'
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(43037241672866252.4054)
,p_name=>'F4050_P23_EMAIL_ADDRESS'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(43032554506866236.4054)
,p_prompt=>'Indirizzo di posta elettronica'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>240
,p_field_template=>wwv_flow_api.id(721133598269759785.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Immettere l''indirizzo di posta elettronica dell''utente.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'EMAIL'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(43037870063866254.4054)
,p_name=>'F4050_P23_WEB_PASSWORD'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(61303115419117985.4054)
,p_prompt=>'Password'
,p_post_element_text=>' <span class="instructiontext">Le password fanno distinzione tra maiuscole e minuscole</span>'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>32
,p_cMaxlength=>255
,p_tag_attributes=>'autocomplete="new-password"'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Immettere la password. Non immettere la password a meno che si stia creando un nuovo account con password o si stia aggiornando la password di un account esistente.'
,p_encrypt_session_state_yn=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(43042986599987259.4054)
,p_name=>'F4050_P23_SECURITY_GROUP_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_prompt=>'Area di lavoro'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'LIST_ALL_COMPANIES_NO_NULL_OPTION'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,',
'       PROVISIONING_COMPANY_ID r',
'from   WWV_FLOW_COMPANIES',
'where  provisioning_company_id > 0',
'  and  provisioning_company_id != 11',
'  and  provisioning_company_id != 12',
'order by 1'))
,p_cSize=>30
,p_cMaxlength=>2000
,p_read_only_when=>':F4050_P23_USER_ID is not null'
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(721133598269759785.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Scegliere un''area di lavoro per l''utente dalla lista popup.'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(157994413889601615.4054)
,p_name=>'P23_DEVELOPER'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_item_default=>'Y'
,p_prompt=>unistr('L''utente \00E8 uno sviluppatore:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_tag_attributes=>'onClick="javascript:if (document.forms[0].P23_ADMIN_0.checked) document.forms[0].P23_DEVELOPER_0.checked = true;"'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Specificare se questo utente deve disporre dei privilegi di sviluppatore. Gli sviluppatori devono poter accedere all''App Builder, a SQL Workshop o a entrambi.',
'',
unistr('\00C8 possibile che i componenti non siano disponibili se sono stati disattivati dagli amministratori delle istanze.')))
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(157996406317627808.4054)
,p_name=>'P23_ADMIN'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_item_default=>'Y'
,p_prompt=>unistr('L''utente \00E8 un amministratore:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'onClick="javascript:if (document.forms[0].P23_ADMIN_0.checked) document.forms[0].P23_DEVELOPER_0.checked = true;"'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Specificare se questo utente deve disporre di privilegi di amministratore dell''area di lavoro. Gli amministratori possono accedere a tutti i componenti. Inoltre, possono gestire account utente, gruppi e servizi di sviluppo.',
'',
unistr('\00C8 possibile che i componenti non siano disponibili se sono stati disattivati dagli amministratori delle istanze.')))
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(182810818563091386.4054)
,p_name=>'F4050_P23_DEV_PRIVS'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_prompt=>'Developer Privileges (Click only ADMIN to receive all privileges)'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(190665205313175398.4054)
,p_name=>'F4050_P23_GROUPS'
,p_item_sequence=>340
,p_item_plug_id=>wwv_flow_api.id(190667230101179100.4054)
,p_prompt=>'Gruppi'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'USER.GROUPS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(group_name) d, id r',
'from wwv_flow_fnd_user_groups_noapp',
'where security_group_id = :F4050_P23_SECURITY_GROUP_ID order by 1'))
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>8
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>'Identificare a quali gruppi appartiene l''utente.'
,p_attribute_01=>'NONE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(240387620119665972.4054)
,p_name=>'F4050_P23_CONFIRM_PASSWD'
,p_item_sequence=>250
,p_item_plug_id=>wwv_flow_api.id(61303115419117985.4054)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Conferma password'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>'Immettere nuovamente la password per confermare. Non immettere la password a meno che si stia creando un nuovo account con password o si stia aggiornando la password di un account esistente.'
,p_encrypt_session_state_yn=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(351317726029487696.4054)
,p_name=>'P23_ALLOW_ACCESS_SCHEMAS'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_prompt=>unistr('Schemi a cui \00E8 possibile accedere (NULL per tutti)')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_read_only_when=>'F4050_P23_SECURITY_GROUP_ID'
,p_read_only_when2=>'10'
,p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'Immettere una lista separata da due punti di schemi in cui questo sviluppatore dispone dei privilegi se utilizza SQL Workshop. La lista di schemi che si immette qui serve a limitare gli utenti a un subset del set completo di schemi forniti per l''area'
||' di lavoro e determina quali nomi di schema sono visualizzati dall''utente in SQL Workshop.'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(367577404458914012.4054)
,p_name=>'P23_DEFAULT_DATE_FORMAT'
,p_item_sequence=>350
,p_item_plug_id=>wwv_flow_api.id(43032554506866236.4054)
,p_prompt=>'Formato data predefinito'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'DATE_FORMAT_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'  from wwv_flow_format_masks',
' where t=''D'''))
,p_cSize=>30
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('Specificare il formato della data Oracle predefinito per l''utente. In questo modo il formato della data predefinito verr\00E0 controllato all''interno di SQL Workshop.')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_03=>'N'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(499671720750978400.4054)
,p_name=>'P23_ALLOW_APP_BUILDING_YN'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_item_default=>'Y'
,p_prompt=>'Accesso a App Builder'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''x''',
'from WWV_FLOW_COMPANIES',
'where (provisioning_company_id = :F4050_P23_SECURITY_GROUP_ID',
'and    NVL(allow_app_building_yn,''Y'') = ''Y'')',
'or :F4050_P23_SECURITY_GROUP_ID IS NULL'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Determina se uno sviluppatore pu\00F2 accedere all''App Builder.<br>'),
'<br>',
unistr('Un amministratore potr\00E0 accedere sempre all''App Builder.<br>'),
'Uno sviluppatore deve poter accedere all''App Builder, a SQL Workshop o a entrambi.<br>',
'<br>',
unistr('Questo attributo \00E8 sempre disabilitato se un amministratore ha disabilitato l''accesso all''App Builder per l''area di lavoro.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(499671908704978402.4054)
,p_name=>'P23_ALLOW_WEBSHEET_DEV_YN'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_item_default=>'Y'
,p_prompt=>'Accesso a Websheet Development'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Determina se uno sviluppatore pu\00F2 accedere a Websheet Development.<br>'),
'<br>',
unistr('Un amministratore potr\00E0 accedere sempre a Websheet Development.<br>'),
'<br>',
'Questo attributo e sempre disabilitato se un amministratore ha disabilitato l''accesso a Websheet Development per l''area di lavoro.'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(499672130451978402.4054)
,p_name=>'P23_ALLOW_SQL_WORKSHOP_YN'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_item_default=>'Y'
,p_prompt=>'Accesso a SQL Workshop'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''x''',
'from WWV_FLOW_COMPANIES',
'where (provisioning_company_id = :F4050_P23_SECURITY_GROUP_ID',
'and    NVL(allow_sql_workshop_yn,''Y'') = ''Y'')',
'or :F4050_P23_SECURITY_GROUP_ID IS NULL'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Determina se uno sviluppatore pu\00F2 accedere a SQL Workshop.<br>'),
'<br>',
unistr('Un amministratore potr\00E0 accedere sempre a SQL Workshop.<br>'),
'Uno sviluppatore deve poter accedere all''App Builder, a SQL Workshop o a entrambi.<br>',
'<br>',
unistr('Questo attributo \00E8 sempre disabilitato se un amministratore ha disabilitato l''accesso a SQL Workshop per l''area di lavoro.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(499672303492978402.4054)
,p_name=>'P23_ALLOW_TEAM_DEVELOPMENT_YN'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_item_default=>'Y'
,p_prompt=>'Accesso a Team Development'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''x''',
'from WWV_FLOW_COMPANIES',
'where (provisioning_company_id = :F4050_P23_SECURITY_GROUP_ID',
'and    NVL(allow_team_development_yn,''Y'') = ''Y'')',
'or :F4050_P23_SECURITY_GROUP_ID IS NULL'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Determina se un utente pu\00F2 accedere a Team Development.<br>'),
'<br>',
unistr('Un amministratore potr\00E0 accedere sempre a Team Development.<br>'),
'<br>',
'Questo attributo e sempre disabilitato se un amministratore ha disabilitato l''accesso a Team Development per l''area di lavoro.'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(499944115009587837.4054)
,p_name=>'P23_DISALLOW_APP_BUILDING'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>'Accesso a App Builder'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''x''',
'from WWV_FLOW_COMPANIES',
'where provisioning_company_id = :F4050_P23_SECURITY_GROUP_ID',
'and   NVL(allow_app_building_yn,''Y'') = ''N'''))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Determina se uno sviluppatore pu\00F2 accedere all''App Builder.<br>'),
'<br>',
unistr('Un amministratore potr\00E0 accedere sempre all''App Builder.<br>'),
'Uno sviluppatore deve poter accedere all''App Builder, a SQL Workshop o a entrambi.<br>',
'<br>',
unistr('Questo attributo \00E8 sempre disabilitato se un amministratore ha disabilitato l''accesso all''App Builder per l''area di lavoro.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(499944628169591686.4054)
,p_name=>'P23_DISALLOW_WEBSHEET_DEV'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>'Accesso a Websheet Development'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Determina se uno sviluppatore pu\00F2 accedere a Websheet Development.<br>'),
'<br>',
unistr('Un amministratore potr\00E0 accedere sempre a Websheet Development.<br>'),
'<br>',
'Questo attributo e sempre disabilitato se un amministratore ha disabilitato l''accesso a Websheet Development per l''area di lavoro.'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(499945108907595575.4054)
,p_name=>'P23_DISALLOW_SQL_WORKSHOP'
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>'Accesso a SQL Workshop'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cHeight=>1
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''x''',
'from WWV_FLOW_COMPANIES',
'where provisioning_company_id = :F4050_P23_SECURITY_GROUP_ID',
'and   NVL(allow_sql_workshop_yn,''Y'') = ''N'''))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Determina se uno sviluppatore pu\00F2 accedere a SQL Workshop.<br>'),
'<br>',
unistr('Un amministratore potr\00E0 accedere sempre a SQL Workshop.<br>'),
'Uno sviluppatore deve poter accedere all''App Builder, a SQL Workshop o a entrambi.<br>',
'<br>',
unistr('Questo attributo \00E8 sempre disabilitato se un amministratore ha disabilitato l''accesso a SQL Workshop per l''area di lavoro.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(499945618950598529.4054)
,p_name=>'P23_DISALLOW_TEAM_DEVELOPMENT'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(4789806742494505.4054)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>'Accesso a Team Development'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(157992123774592395.4054)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''x''',
'from WWV_FLOW_COMPANIES',
'where provisioning_company_id = :F4050_P23_SECURITY_GROUP_ID',
'and   NVL(allow_team_development_yn,''Y'') = ''N'''))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(721133390982759781.4054)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Determina se un utente pu\00F2 accedere a Team Development.<br>'),
'<br>',
unistr('Un amministratore potr\00E0 accedere sempre a Team Development.<br>'),
'<br>',
'Questo attributo e sempre disabilitato se un amministratore ha disabilitato l''accesso a Team Development per l''area di lavoro.'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(316540319552589525.4054)
,p_computation_sequence=>10
,p_computation_item=>'F4050_P23_DEFAULT_SCHEMA'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'replace(:F4050_P23_DEFAULT_SCHEMA,''%''||''null%'',null)'
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(240393507137700064.4054)
,p_computation_sequence=>20
,p_computation_item=>'F4050_P23_CONFIRM_PASSWD'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'ltrim(rtrim(:F4050_P23_CONFIRM_PASSWD))'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(12554726371767163.4054)
,p_computation_sequence=>40
,p_computation_item=>'P23_EXPIRE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(:P23_EXPIRE,''N'') <> ''Y'' then',
'  return ''N'';',
'else',
'  return ''Y'';',
'end if;'))
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(12555506070770774.4054)
,p_computation_sequence=>50
,p_computation_item=>'P23_ACCOUNT_LOCKED'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(:P23_ACCOUNT_LOCKED,''N'') <> ''Y'' then',
'  return ''N'';',
'else',
'  return ''Y'';',
'end if;'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(182745532211009071.4054)
,p_validation_name=>'F4050_P23_USER_NAME Not Null'
,p_validation_sequence=>10
,p_validation=>'F4050_P23_USER_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'Specificare il nome utente.'
,p_validation_condition=>':REQUEST in (''Apply_Changes'',''CREATE'',''CREATE_ANOTHER'')'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(43033813964866242.4054)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
,p_validation_comment=>'generated 22-FEB-2002 12:40'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(111539302381125034.4054)
,p_validation_name=>'Invalid characters in username'
,p_validation_sequence=>20
,p_validation=>'F4050_P23_USER_NAME'
,p