prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4415
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4415 - Oracle APEX  System Messages and Native Types
--
-- Application Export:
--   Application:     4415
--   Name:            Oracle APEX  System Messages and Native Types
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             124
--       Globalization:
--         Messages:          14,593
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX  System Messages and Native Types')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286625815332927123')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135328'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'it'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(91645213681389498.4415)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141229'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562090986404402217.4415)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48650898565635010.4415)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Scollega'
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>'Scollega da Application Express'
,p_list_text_09=>'Y'
,p_list_text_10=>'logout exit quit :q'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(281916990329150760.4415)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Crea un''applicazione da un foglio di calcolo'
,p_list_item_link_target=>'f?p=4000:447:&APP_SESSION.::NO:448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT::'
,p_list_text_01=>'Importare i file Excel o CSV e creare l''applicazione'
,p_list_text_09=>'Y'
,p_list_text_10=>'excel csv xsl xslx spreadsheet data paste load import'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(282255839842182292.4415)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Home Oracle APEX'
,p_list_item_link_target=>'f?p=4500:1000:&APP_SESSION.'
,p_list_text_10=>'inizio home page '
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(296033420364984683.4415)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Sfoglia icone Carattere APEX'
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>'Sfogliare le icone Carattere APEX, aggiungere i modificatori e copiare CSS o HTML necessari.'
,p_list_text_09=>'Y'
,p_list_text_10=>'icone elementi grafici libreria apex'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562091518091404815.4415)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562091727563404815.4415)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Esporta applicazione'
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>'Esporta l''applicazione {APP_ID} come file SQL'
,p_list_text_09=>'Y'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562093357853428158.4415)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Liste inutilizzate'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562092153904409717.4415)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48392393581618193.4415)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Log della console'
,p_list_item_link_target=>'javascript:console.log(''hello friend'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14843831009863117.4415)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859012524941040.4415)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(86380554411225400.4415)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91997339122572414.4415)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(460407779408652225.4415)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(497671453666914719.4415)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attribute_01=>'fa-star'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082458703597614427.4415)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082517678315623391.4415)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072678475712055.4415)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831649180083980462.4415)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780276458994154.4415)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1832884277947217587.4415)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1840861033969283097.4415)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917665913120940054.4415)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1990227023531717243.4415)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626406749381989.4415)
,p_theme_id=>1
,p_name=>'One Level Tabs.it'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE# ',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626529080381989.4415)
,p_theme_id=>1
,p_name=>'Printer Friendly.it'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(91626823864381990.4415)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(91632832228382001.4415)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(91636711305382010.4415)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(91638400927382012.4415)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(91638400927382012.4415)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(91641225667382016.4415)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641730492382017.4415)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641814330382017.4415)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(91642503902382024.4415)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>'Finestra di dialogo di ricerca'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Cerca'
,p_close_button_text=>'Chiudi'
,p_next_button_text=>'Successivo >'
,p_prev_button_text=>'< Precedente'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Righe #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91641910982382018.4415)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642102481382020.4415)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642303533382020.4415)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277794694139867748)
,p_name=>'2DCOLUMN'
,p_message_language=>'it'
,p_message_text=>'A colonne 2D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277796960902867750)
,p_name=>'2DCOLUMN_LINE'
,p_message_language=>'it'
,p_message_text=>'A linee di colonne 2D'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277794847578867749)
,p_name=>'2DDOUGHNUT'
,p_message_language=>'it'
,p_message_text=>'Ad anello 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277796718944867750)
,p_name=>'2DHSTACKED_PCT'
,p_message_language=>'it'
,p_message_text=>'A colonne 2D orizzontali in pila (percentuale)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277794966717867749)
,p_name=>'2DLINE'
,p_message_language=>'it'
,p_message_text=>'A linee 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277795051007867749)
,p_name=>'2DPIE'
,p_message_language=>'it'
,p_message_text=>'A torta 2D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277796530370867750)
,p_name=>'2DSTACKED_PCT'
,p_message_language=>'it'
,p_message_text=>'A colonne 2D in pila (percentuale)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277795103051867749)
,p_name=>'3DCOLUMN'
,p_message_language=>'it'
,p_message_text=>'A colonne 3D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277796860313867750)
,p_name=>'3DHSTACKED_PCT'
,p_message_language=>'it'
,p_message_text=>'A colonne 3D orizzontali in pila (percentuale)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277795264799867749)
,p_name=>'3DPIE'
,p_message_language=>'it'
,p_message_text=>'A torta 3D'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277796625381867750)
,p_name=>'3DSTACKED_PCT'
,p_message_language=>'it'
,p_message_text=>'A colonne 3D in pila (percentuale)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278692585566868316)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'it'
,p_message_text=>'0 elementi da inserire nel dizionario attributi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278692391976868315)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_language=>'it'
,p_message_text=>'0 elementi per l''aggiornamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278692702526868316)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'it'
,p_message_text=>'0 elementi per aggiornare il dizionario attributi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278693175090868316)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'it'
,p_message_text=>'0 colonne del report da inserire nel dizionario attributi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278693361701868316)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'it'
,p_message_text=>'0 colonne del report per aggiornare il dizionario attributi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278692204168868315)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_language=>'it'
,p_message_text=>'Controllare %0 elementi per l''aggiornamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278692923924868316)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_language=>'it'
,p_message_text=>'0 colonne di report per l''aggiornamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278692460002868315)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'it'
,p_message_text=>'Rivedi %0 elementi da inserire nel dizionario attributi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278692622118868316)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'it'
,p_message_text=>'Rivedi %0 elementi per aggiornare il dizionario attributi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278693026634868316)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'it'
,p_message_text=>'Rivedi %0 colonne del report da inserire nel dizionario attributi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278692873267868316)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_language=>'it'
,p_message_text=>'Controllare %0 colonne di report per l''aggiornamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278693220841868316)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'it'
,p_message_text=>'Rivedi %0 colonne del report per aggiornare il dizionario attributi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278383054295868120)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_language=>'it'
,p_message_text=>'Il valore deve essere numerico.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278367549569868110)
,p_name=>'4000_639_SEQ_MESG'
,p_message_language=>'it'
,p_message_text=>'<span class="fielddata"> Impossibile riordinare. Sequenze di aree non univoche.</span>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278367679070868110)
,p_name=>'4000_641_SEQ_MESG'
,p_message_language=>'it'
,p_message_text=>'<span class="fielddata">Impossibile riordinare. Sequenze di pulsanti non univoche.</span>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278367724652868110)
,p_name=>'4000_646_SEQ_MESG'
,p_message_language=>'it'
,p_message_text=>'<span class="fielddata">Impossibile riordinare. Sequenze di barre di navigazione non univoche.</span>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278367856151868110)
,p_name=>'4000_749_SEQ_MESG'
,p_message_language=>'it'
,p_message_text=>'<span class="fielddata">Impossibile riordinare. Sequenze di elementi di area non univoche.</span>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278447411556868161)
,p_name=>'4000_APPLICATION_ID'
,p_message_language=>'it'
,p_message_text=>'ID applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277939139168867839)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Modifica applicazione: %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278339187357868092)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_language=>'it'
,p_message_text=>unistr('Il formato data specificato non \00E8 valido. Il calendario richiede che la data sia in formato YYYYMMDD.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278388299100868123)
,p_name=>'4000_TREE'
,p_message_language=>'it'
,p_message_text=>'Struttura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278447579575868161)
,p_name=>'4000_WORKSPACE_ID'
,p_message_language=>'it'
,p_message_text=>'ID area di lavoro'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278220273618868017)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Immettere il nome del nuovo schema da creare. Scegliere',
'         una password per lo schema, quindi la tablespace predefinita',
'         e la tablespace temporanea.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278220304369868017)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_language=>'it'
,p_message_text=>'Immettere il nome dello schema esistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278220430659868017)
,p_name=>'4050_106_WHEN_DONE'
,p_message_language=>'it'
,p_message_text=>'Al termine, fare clic sul pulsante "Successivo &gt;"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278113437834867949)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_language=>'it'
,p_message_text=>'Elimina le tablespace e i file di dati associati: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278113386705867949)
,p_name=>'4050_110_DROP_USERS'
,p_message_language=>'it'
,p_message_text=>'Elimina utente del database: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279026080110868528)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_language=>'it'
,p_message_text=>unistr('Voci del log di attivit\00E0 Web Service')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278213676206868013)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_language=>'it'
,p_message_text=>unistr('Voci di log di attivit\00E0 dello sviluppatore')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277832291615867772)
,p_name=>'4050_31_LOG_COUNT'
,p_message_language=>'it'
,p_message_text=>'Voci log degli accessi di login'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278213194912868012)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_language=>'it'
,p_message_text=>'Richieste di modifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278213235208868012)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_language=>'it'
,p_message_text=>'Richieste di runtime'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278212939368868012)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_language=>'it'
,p_message_text=>'Richieste di area di lavoro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278215612065868014)
,p_name=>'4050_46_AD_HOC'
,p_message_language=>'it'
,p_message_text=>'Voci della cronologia del processore comandi SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278215550568868014)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_language=>'it'
,p_message_text=>'Voci di log di esecuzione dei control file'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278215469560868014)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_language=>'it'
,p_message_text=>'Voci di log di esecuzione dei file di script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278215754487868014)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_language=>'it'
,p_message_text=>'Voci degli archivi SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278217734299868015)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_language=>'it'
,p_message_text=>'Informazioni sul log attivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278217826591868015)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_language=>'it'
,p_message_text=>'Numero del log corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278217978852868015)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_language=>'it'
,p_message_text=>'Indicatore orario del log corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278218504980868016)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_language=>'it'
,p_message_text=>'Ore fino al log switch successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278218141707868015)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_language=>'it'
,p_message_text=>'Intervallo in giorni (costante)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278218418925868016)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_language=>'it'
,p_message_text=>'Log switch successivo pianificato per'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278218823251868016)
,p_name=>'4050_70_DEV_ACT'
,p_message_language=>'it'
,p_message_text=>unistr('Voci di log di attivit\00E0 dello sviluppatore')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278219027465868016)
,p_name=>'4050_71_CLICK'
,p_message_language=>'it'
,p_message_text=>'Voci di log dei clic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278219828379868017)
,p_name=>'4050_75_AD_HOC'
,p_message_language=>'it'
,p_message_text=>'Voci della cronologia del processore comandi SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278219752315868016)
,p_name=>'4050_75_CTRL_FILE'
,p_message_language=>'it'
,p_message_text=>'Voci di log di esecuzione dei control file'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278219537102868016)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_language=>'it'
,p_message_text=>'Voci di log di esecuzione dei file di script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278219959761868017)
,p_name=>'4050_75_SQL_ARCH'
,p_message_language=>'it'
,p_message_text=>'Voci degli archivi SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278220055938868017)
,p_name=>'4050_82_WORKSPACE'
,p_message_language=>'it'
,p_message_text=>'L''area di lavoro %1 ha %2 applicazione/i e %3 utente/i.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278220104589868017)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_language=>'it'
,p_message_text=>'Voci di log di conteggio clic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278418283942868142)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_language=>'it'
,p_message_text=>unistr('Applicazioni di produttivit\00E0 e di esempio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278418351271868142)
,p_name=>'4050_PACKAGED_WEBSHEETS'
,p_message_language=>'it'
,p_message_text=>'Websheet di esempio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278417534154868142)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_language=>'it'
,p_message_text=>'Conteggio aree di lavoro'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277957827531867851)
,p_name=>'4150_COLUMN_NUMBER'
,p_message_language=>'it'
,p_message_text=>'Colonna %0'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278141501741867967)
,p_name=>'4350_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278141612202867967)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Modifica applicazione'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277847322672867782)
,p_name=>'4500 800 HD DBA'
,p_message_language=>'it'
,p_message_text=>'Oracle Database Express Edition 2 Day DBA.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277847427623867782)
,p_name=>'4500 800 HD DEV'
,p_message_language=>'it'
,p_message_text=>'Oracle Database Express Edition 2 Day Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277847210442867781)
,p_name=>'4500 800 HD HTMLDB'
,p_message_language=>'it'
,p_message_text=>'Oracle Application Express 2 Day Plus Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277847579248867782)
,p_name=>'4500 800 HD JAVA'
,p_message_language=>'it'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus Java Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277847624369867782)
,p_name=>'4500 800 HD NET'
,p_message_language=>'it'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus .NET Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277847780527867782)
,p_name=>'4500 800 HD PHP'
,p_message_language=>'it'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus PHP Developer.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277847836931867782)
,p_name=>'4500 800 MSG DBA'
,p_message_language=>'it'
,p_message_text=>'Tratta dei comuni task amministrativi quotidiani.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277847922684867782)
,p_name=>'4500 800 MSG DEV'
,p_message_language=>'it'
,p_message_text=>unistr('Illustra come sfruttare le potenzialit\00E0 dell''ambiente di sviluppo di Oracle Database Express Edition.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277848077902867782)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_language=>'it'
,p_message_text=>unistr('Offre una serie di esercitazioni che illustrano le modalit\00E0 di creazione di applicazioni Web basate su database.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277848207059867782)
,p_name=>'4500 800 MSG JAVA'
,p_message_language=>'it'
,p_message_text=>'Questo documento fornisce un''esercitazione che illustra come utilizzare Java e JDBC per connettersi a Oracle Database XE e mostra come sviluppare una semplice applicazione Java per l''accesso e la modifica dei dati.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277848349083867782)
,p_name=>'4500 800 MSG NET'
,p_message_language=>'it'
,p_message_text=>'Questo documento descrive le funzioni fondamentali di Oracle Data Provider for .NET e Oracle Developer Tools for Visual Studio .NET, fornisce istruzioni dettagliate per l''installazione e la configurazione e mostra come creare applicazioni di base uti'
||unistr('lizzando Oracle Data Provider for .NET e Oracle Developer Tools for Visual Studio .NET, nonch\00E9 come creare e utilizzare stored procedure PL/SQL e .NET.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277848172295867782)
,p_name=>'4500 800 MSG PHP'
,p_message_language=>'it'
,p_message_text=>'Questo documento fornisce un''esercitazione che illustra come scaricare e installare i driver PHP Zend Core e Apache e come utilizzare PHP per connettersi a Oracle Database XE; mostra inoltre come utilizzare PHP per sviluppare un''applicazione semplice'
||' per l''accesso e la modifica dei dati.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277818001977867763)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_language=>'it'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277817971920867763)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277818208351867763)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_language=>'it'
,p_message_text=>'Condizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278276913708868053)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_language=>'it'
,p_message_text=>'Elimina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277818680372867763)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_language=>'it'
,p_message_text=>'Funzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277818731597867764)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_language=>'it'
,p_message_text=>'Raggruppa per'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277818114780867763)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_language=>'it'
,p_message_text=>'Oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277818513480867763)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_language=>'it'
,p_message_text=>'Mostra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277818375295867763)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_language=>'it'
,p_message_text=>'Tipo di ordinamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277818482875867763)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_language=>'it'
,p_message_text=>'Criterio di ordinamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277821833392867765)
,p_name=>'4500_1002_QB_JOIN'
,p_message_language=>'it'
,p_message_text=>'Join'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277815396011867761)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_language=>'it'
,p_message_text=>'Fare clic qui per selezionare una colonna per il join.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277822256219867766)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 possibile selezionare un massimo di 60 colonne.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277815233058867761)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_language=>'it'
,p_message_text=>'Rimuovi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277815154256867761)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_language=>'it'
,p_message_text=>'Mostra/Nascondi colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277821956034867766)
,p_name=>'4500_1002_QB_TO'
,p_message_language=>'it'
,p_message_text=>'a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277813572943867760)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_language=>'it'
,p_message_text=>'Risultati di %0, esecuzione alle %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278113607290867949)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_language=>'it'
,p_message_text=>'Torna alla query originale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277829549816867770)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_language=>'it'
,p_message_text=>'Prime %0 colonne visualizzate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278306685912868071)
,p_name=>'4500_SESS_EVENT'
,p_message_language=>'it'
,p_message_text=>'Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278306551778868071)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_language=>'it'
,p_message_text=>'Kilobyte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278306495756868071)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_language=>'it'
,p_message_text=>'Megabyte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277851230327867784)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_language=>'it'
,p_message_text=>unistr('I valori predefiniti dell''interfaccia utente vengono utilizzati dall''App Builder per popolare i valori iniziali per l''area e le propriet\00E0 degli elementi che assicurano la coerenza su pi\00F9 pagine in una o pi\00F9 applicazioni.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277895641711867812)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_language=>'it'
,p_message_text=>'Questa applicazione richiede l''abilitazione dei cookie.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277895553977867812)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_language=>'it'
,p_message_text=>'Questa applicazione richiede l''abilitazione di JavaScript.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278087262540867933)
,p_name=>'4800_9015_UPDATE_OVERDUE_FEATURES'
,p_message_language=>'it'
,p_message_text=>unistr('%0 funzione/i scaduta/e verr\00E0 o verranno assegnate al nuovo milestone selezionato.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278337430794868091)
,p_name=>'ABOUT'
,p_message_language=>'it'
,p_message_text=>'Informazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279098293756868574)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_language=>'it'
,p_message_text=>'Confermare l''aggiunta dei %0 utenti seguenti all''area di lavoro.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278349870095868099)
,p_name=>'ACCEPTED'
,p_message_language=>'it'
,p_message_text=>'Accettato'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278316290222868078)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_language=>'it'
,p_message_text=>'Assegnatario accesso facilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278314381462868076)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_language=>'it'
,p_message_text=>'Impatto accesso facilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278316740874868078)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_language=>'it'
,p_message_text=>'Stato accesso facilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279177313848868624)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_language=>'it'
,p_message_text=>'Test accesso facilitato eseguito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277828329405867770)
,p_name=>'ACCESS_CONTROL_ADMIN'
,p_message_language=>'it'
,p_message_text=>'Amministratore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277987703433867870)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_language=>'it'
,p_message_text=>'Diritti di amministrazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277826841565867769)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina di amministrazione controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278265496191868045)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_language=>'it'
,p_message_text=>'Amministratore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278376509097868116)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_language=>'it'
,p_message_text=>'Ruolo assegnato agli amministratori dell''applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277827062425867769)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_language=>'it'
,p_message_text=>'Amministrazione applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277827650652867769)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_language=>'it'
,p_message_text=>unistr('Modalit\00E0 di applicazione')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277827553855867769)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_language=>'it'
,p_message_text=>unistr('Specificare la modalit\00E0 di controllo dell''accesso a questa applicazione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277828822025867770)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_language=>'it'
,p_message_text=>unistr('Impossibile elaborare la richiesta di impostazione della modalit\00E0 di applicazione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277828952327867770)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_language=>'it'
,p_message_text=>unistr('Modalit\00E0 di applicazione impostata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277988612941867871)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_language=>'it'
,p_message_text=>'Impossibile eliminare se stessi.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277988739047867871)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_language=>'it'
,p_message_text=>'Impossibile rimuovere il privilegio di amministratore da se stessi.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277826995311867769)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_language=>'it'
,p_message_text=>'Crea tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278265304286868045)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_language=>'it'
,p_message_text=>'Diritti contributo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278265535900868045)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_language=>'it'
,p_message_text=>'Collaboratore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278376623618868116)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_language=>'it'
,p_message_text=>'Ruolo assegnato ai collaboratori dell''applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278309033129868073)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Verranno create le impostazioni applicazione seguenti:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278265657306868045)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_language=>'it'
,p_message_text=>'Verranno creati i ruoli di accesso applicazione seguenti:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277844406812867780)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_language=>'it'
,p_message_text=>'Verranno creati gli schemi di autorizzazione seguenti:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277918186771867826)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_language=>'it'
,p_message_text=>'Impossibile creare la pagina di controllo dell''accesso. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277918044038867826)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_language=>'it'
,p_message_text=>'Impossibile creare le tabelle di controllo dell''accesso. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277991200215867872)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_language=>'it'
,p_message_text=>'Impossibile immettere un nome utente duplicato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277987865103867870)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_language=>'it'
,p_message_text=>'controllo dell''accesso - modifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277828540415867770)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_language=>'it'
,p_message_text=>'Immettere una query senza distinzione tra maiuscole e minuscole, quindi fare clic sul pulsante <b>Vai</b>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277828667176867770)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_language=>'it'
,p_message_text=>unistr('Impossibile ottenere la modalit\00E0 di amministrazione dell''applicazione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277828435649867770)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_language=>'it'
,p_message_text=>'Autore ultima modifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277827988650867769)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_language=>'it'
,p_message_text=>'Lista di controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277827122814867769)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_language=>'it'
,p_message_text=>'Accesso completo a tutto, lista di controllo dell''accesso non utilizzata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277827275983867769)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_language=>'it'
,p_message_text=>'Accesso limitato. Accesso consentito solo agli utenti definiti nella lista di controllo dell''accesso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277827372603867769)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_language=>'it'
,p_message_text=>'Pubblico sola lettura. Privilegi di modifica e amministrazione controllati dalla lista di controllo dell''accesso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277827431560867769)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_language=>'it'
,p_message_text=>'Solo accesso amministrativo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277828767430867770)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_language=>'it'
,p_message_text=>'Nessun privilegio per l''azione tentata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277828204025867770)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_language=>'it'
,p_message_text=>'Privilegio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278308969802868073)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_language=>'it'
,p_message_text=>'Diritti lettore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278308813030868073)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_language=>'it'
,p_message_text=>'Processo di lettura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278376711448868116)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_language=>'it'
,p_message_text=>'Ruolo assegnato ai lettori dell''applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277845262826867780)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_language=>'it'
,p_message_text=>'Specificare i nomi utente che corrispondono allo schema di autenticazione di questa applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277827768743867769)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_language=>'it'
,p_message_text=>unistr('Imposta modalit\00E0 di applicazione')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277946216088867844)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_language=>'it'
,p_message_text=>'Creazione delle pagine di controllo dell''accesso completata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277828115477867769)
,p_name=>'ACCESS_CONTROL_USERNAME'
,p_message_language=>'it'
,p_message_text=>'Nome utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278265709491868045)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_language=>'it'
,p_message_text=>'Usa ruolo di controllo dell''accesso esistente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277845141108867780)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_language=>'it'
,p_message_text=>'Usa schema di autorizzazione esistente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277844373282867780)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_language=>'it'
,p_message_text=>'Usa tabella esistente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277987946661867870)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_language=>'it'
,p_message_text=>'controllo dell''accesso - visualizza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278277622690868053)
,p_name=>'ACCESS_DENIED_SIMPLE'
,p_message_language=>'it'
,p_message_text=>'Accesso negato'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277848636040867782)
,p_name=>'ACCOUNT_CREATED'
,p_message_language=>'it'
,p_message_text=>'Account creato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277971582109867860)
,p_name=>'ACCOUNT_HAS_BEEN_CREATED'
,p_message_language=>'it'
,p_message_text=>unistr('L''account %0 \00E8 stato creato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277846006181867781)
,p_name=>'ACCOUNT_LOCKED'
,p_message_language=>'it'
,p_message_text=>unistr('L''account \00E8 bloccato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278638602067868282)
,p_name=>'ACCOUNT_MENU'
,p_message_language=>'it'
,p_message_text=>'Menu account'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278296167806868065)
,p_name=>'ACKNOWLEDGED'
,p_message_language=>'it'
,p_message_text=>'Confermato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278296398904868065)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_language=>'it'
,p_message_text=>'Confermato, nessuna azione'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278360243116868105)
,p_name=>'ACL_ADD_USER'
,p_message_language=>'it'
,p_message_text=>'Aggiungi utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279028899005868529)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_language=>'it'
,p_message_text=>'Accesso al dashboard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279028957549868530)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_language=>'it'
,p_message_text=>unistr('Accesso a controllo attivit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279028071099868529)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_language=>'it'
,p_message_text=>'Aggiungi/modifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279028779216868529)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_language=>'it'
,p_message_text=>'Amministrazione quando si esegue l''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279027219843868528)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_language=>'it'
,p_message_text=>'Amministrazione dall''App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279027908458868529)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_language=>'it'
,p_message_text=>'Annotazioni (file, tag, note)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279026996539868528)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_language=>'it'
,p_message_text=>'Autenticazione dell''account Application Express senza lista di controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279026813442868528)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_language=>'it'
,p_message_text=>'Autenticazione con lista di controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279027691668868529)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_language=>'it'
,p_message_text=>'Modifica accesso SQL e oggetti consigliati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279031909698868532)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_language=>'it'
,p_message_text=>unistr('Dopo aver eseguito l''autenticazione in un''applicazione, il controllo dell''accesso specifica cosa possono fare gli utenti nell''applicazione. La tabella riportata di seguito identifica le varie funzionalit\00E0 disponibili per gli utenti, a seconda dell''au')
||'tenticazione nell''applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279029015925868530)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_language=>'it'
,p_message_text=>'Conserva lista di controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279027706198868529)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_language=>'it'
,p_message_text=>'Esegui e visualizza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279027439664868529)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_language=>'it'
,p_message_text=>unistr('Aggiorna propriet\00E0 applicazione')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278687103854868312)
,p_name=>'ACTIONS'
,p_message_language=>'it'
,p_message_text=>'Azioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279026396739868528)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni menu Azioni'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277859705545867789)
,p_name=>'ACTIVE'
,p_message_language=>'it'
,p_message_text=>'Attivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278273290185868050)
,p_name=>'ACTIVITY'
,p_message_language=>'it'
,p_message_text=>unistr('Attivit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278317772206868078)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Riepilogo attivit\00E0'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278553232906868227)
,p_name=>'ADDED_BY'
,p_message_language=>'it'
,p_message_text=>'Autore aggiunta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279023816768868526)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_language=>'it'
,p_message_text=>'Aggiunto alla lista di rimozione'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278672834364868303)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_language=>'it'
,p_message_text=>'Richieste ulteriori informazioni'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278227474638868021)
,p_name=>'ADD_ARGUEMENT'
,p_message_language=>'it'
,p_message_text=>'Aggiungi argomento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278217529663868015)
,p_name=>'ADD_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Aggiungi colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278433780686868152)
,p_name=>'ADD_COLUMN_NAME'
,p_message_language=>'it'
,p_message_text=>'Aggiungi colonna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278075597539867925)
,p_name=>'ADD_CONSTRAINT'
,p_message_language=>'it'
,p_message_text=>'Aggiungi vincolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278215388400868014)
,p_name=>'ADD_MORE...'
,p_message_language=>'it'
,p_message_text=>'Aggiungi altro...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278288167463868060)
,p_name=>'ADD_ROW'
,p_message_language=>'it'
,p_message_text=>'Aggiungi riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278441208264868157)
,p_name=>'ADD_USER_INTERFACE'
,p_message_language=>'it'
,p_message_text=>'Aggiungi interfaccia utente'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278444880968868159)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_language=>'it'
,p_message_text=>'Adegua spazio fornito di %0 MB'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278213899744868013)
,p_name=>'ADMIN'
,p_message_language=>'it'
,p_message_text=>'Amministratore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277840029377867777)
,p_name=>'ADMINISTRATOR'
,p_message_language=>'it'
,p_message_text=>'Amministratore area di lavoro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278317565643868078)
,p_name=>'ADMINISTRATORS'
,p_message_language=>'it'
,p_message_text=>'Amministratori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278221105569868017)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 necessario fornire la posta elettronica degli amministratori')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278385246223868121)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_language=>'it'
,p_message_text=>'Accesso facilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277875692405867799)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277875977194867800)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_language=>'it'
,p_message_text=>'Prestazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277876007585867800)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_language=>'it'
,p_message_text=>unistr('Controllo di qualit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277875754858867799)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_language=>'it'
,p_message_text=>'Sicurezza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277876162707867800)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_language=>'it'
,p_message_text=>unistr('Usabilit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277875856194867800)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_language=>'it'
,p_message_text=>'Avvertenza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278518584054868206)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_language=>'it'
,p_message_text=>unistr('L''elemento "%1" \00E8 protetto e non pu\00F2 essere impostato mediante una chiamata Ajax.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278518652101868206)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_language=>'it'
,p_message_text=>unistr('L''elemento "%1" \00E8 protetto e non pu\00F2 essere impostato mediante una chiamata Ajax.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278550532455868226)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_language=>'it'
,p_message_text=>unistr('L''elemento "%1" \00E8 protetto e non pu\00F2 essere impostato mediante una chiamata Ajax.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277906442687867819)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_language=>'it'
,p_message_text=>'Prefisso dello schema SYS mancante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278728496800868338)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_language=>'it'
,p_message_text=>'Uso delle API WWV_FLOW (utilizzare invece le API APEX)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278668544333868300)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'La colonna %0 non esiste nell''istruzione SQL dell''origine dell''area.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277885959426867806)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'Colonna di report interattivo %0 inesistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277883616013867804)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'%0 inesistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277852025422867785)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'La colonna %0 non esiste nell''istruzione SQL dell''origine dell''area.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278763071608868360)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'Colonna di form tabulare %0 inesistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277883761071867805)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_language=>'it'
,p_message_text=>'Impossibile fare riferimento a %0 come nome elemento di applicazione o di pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279104233645868578)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_language=>'it'
,p_message_text=>unistr('Il processo dell''applicazione Callback Ajax non \00E8 protetto da uno schema di autorizzazione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279103828758868577)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_language=>'it'
,p_message_text=>unistr('La pagina non \00E8 protetta da uno schema di autorizzazione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277884632857867805)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_language=>'it'
,p_message_text=>'Nessuno schema di autorizzazione definito per la pagina di destinazione %1 nell''applicazione %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279105963214868579)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_language=>'it'
,p_message_text=>unistr('L''autorizzazione di questa pagina \00E8 diversa dall''autorizzazione "%1" della pagina padre %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277884767178867805)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_language=>'it'
,p_message_text=>unistr('L''autorizzazione "%0" nella pagina di destinazione \00E8 diversa da "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277883270800867804)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'%0 inesistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277883181678867804)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_language=>'it'
,p_message_text=>'Impossibile eseguire il controllo della sintassi di bind variable. Errore: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277883318877867804)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'it'
,p_message_text=>'Impossibile fare riferimento a %0 con una sintassi di bind variable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277885320951867806)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_language=>'it'
,p_message_text=>'Diramazione non condizionale prima di altre diramazioni.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279103638391868577)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_language=>'it'
,p_message_text=>unistr('Il completamento automatico \00E8 attivato per una pagina che contiene elementi di password.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279103753242868577)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_language=>'it'
,p_message_text=>'"Cache" consente al browser di inserire nella cache i dati riservati.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278988603541868503)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_language=>'it'
,p_message_text=>unistr('Con "Incorpora in frame" l''applicazione \00E8 vulnerabile agli attacchi di tipo clickjacking.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278988784039868503)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_language=>'it'
,p_message_text=>unistr('"Modalit\00E0 di escape HTML" si applica solo a un set di caratteri limitato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277809865072867758)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('In Attributi pulsante \00E8 stato rilevato un ID per un pulsante cui viene fatto riferimento in un''azione dinamica (%0). '),
'',
unistr('La definizione di un ID in Attributi pulsante provoca il mancato funzionamento delle azioni dinamiche che fanno riferimento al pulsante. Rimuovere questo ID, poich\00E9 il pulsante generer\00E0 un ID per impostazione predefinita.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277809917999867758)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Il modello di pulsante utilizzato da un pulsante cui viene fatto riferimento in un''azione dinamica (%0) non contiene la stringa di sostituzione #BUTTON_ID#.',
'',
'Modello:',
'%1',
'',
'Aggiungere la stringa di sostituzione #BUTTON_ID# a questo modello oppure sostituire il modello di pulsante con uno che includa la stringa di sostituzione #BUTTON_ID#.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277812547810867760)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore ''Azione'' non \00E8 ''Definita da azione dinamica'' per un pulsante cui viene fatto riferimento in un''azione dinamica (%0).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277819264343867764)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_language=>'it'
,p_message_text=>'Pulsante (%0) con valore di ''Azione'' impostato su ''Definita da azione dinamica'' ma senza azione dinamica corrispondente che fa riferimento a questo pulsante.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278386753744868122)
,p_name=>'ADVISOR.CHECK.CHART_TYPE_IS_ACCESSIBLE.MSG_ANYCHART_CHART'
,p_message_language=>'it'
,p_message_text=>unistr('Questo \00E8 un tipo di grafico AnyChart obsoleto. Usare la funzione ''Aggiornamento applicazione'' per impostare il grafico per l''uso dei nuovi grafici basati su Oracle JET, in modo da usufruire di funzioni di usabilit\00E0 e accesso facilitato ottimali.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277884346798867805)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('La pagina di svuotamento della cache %0 non \00E8 la pagina corrente o di destinazione %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277883037522867804)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'%0 inesistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279075814923868560)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_language=>'it'
,p_message_text=>unistr('Questo valore di attributo non \00E8 pi\00F9 valido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279077396420868560)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_language=>'it'
,p_message_text=>unistr('Questo tipo di componente non \00E8 pi\00F9 valido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278518727749868206)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_language=>'it'
,p_message_text=>'Elementi protetti nelle chiamate Ajax'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277906386307867819)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_language=>'it'
,p_message_text=>'Difetto del codice (interno APEX)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277881172583867803)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_language=>'it'
,p_message_text=>'Riferimenti dichiarativi di elementi di applicazione, elementi di pagina, colonne o filtri di report interattivi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279103513981868577)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_language=>'it'
,p_message_text=>'Autorizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277880894254867803)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_language=>'it'
,p_message_text=>'Riferimenti con sintassi di bind variable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277882287584867804)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_language=>'it'
,p_message_text=>'Diramazione non condizionale prima di altre diramazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279104069482868577)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_language=>'it'
,p_message_text=>'Impostazioni di sicurezza del browser'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277809792731867758)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_language=>'it'
,p_message_text=>'Pulsante non compatibile con le azioni dinamiche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277819028874867764)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_language=>'it'
,p_message_text=>'Riferimenti incoerenti tra azioni dinamiche e pulsanti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278386597748868122)
,p_name=>'ADVISOR.CHECK.DESC_CHART_TYPE_IS_ACCESSIBLE'
,p_message_language=>'it'
,p_message_text=>'Il tipo di grafico supporta l''accesso facilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277881411956867803)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_language=>'it'
,p_message_text=>unistr('Il numero di pagina di svuotamento della cache \00E8 uguale alla pagina di destinazione o corrente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277880788757867803)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_language=>'it'
,p_message_text=>'Riferimenti con sintassi di colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279075707857868559)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_language=>'it'
,p_message_text=>unistr('Valori attributi non pi\00F9 validi')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277881721610867803)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_language=>'it'
,p_message_text=>'I processi di recupero, DML e MR* sono validi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277882127126867804)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_language=>'it'
,p_message_text=>'ID applicazione non modificabile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278292779434868063)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_language=>'it'
,p_message_text=>'L''elemento di pagina contiene il testo della Guida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278385083189868121)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_language=>'it'
,p_message_text=>'La pagina dispone del titolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278411155794868138)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_language=>'it'
,p_message_text=>'L''elemento Visualizza immagine dispone di testo alternativo immagine definito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278988435027868503)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_language=>'it'
,p_message_text=>'Attributi applicazione che possono essere bloccati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277880945575867803)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_language=>'it'
,p_message_text=>'L''elemento a cui si fa riferimento si trova nella pagina corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277881077317867803)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('L''elemento a cui si fa riferimento \00E8 un elemento della pagina di destinazione')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278385761448868121)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_language=>'it'
,p_message_text=>'L''elemento di pagina non causa una modifica di contesto imprevista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278386906416868122)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_language=>'it'
,p_message_text=>'L''elemento di pagina dispone di un''etichetta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277882440162867804)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_language=>'it'
,p_message_text=>'Lunghezza del nome degli elementi o delle colonne di form tabulare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277881292459867803)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_language=>'it'
,p_message_text=>'Riferimenti di elemento di pagina in una stringa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277881377779867803)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_language=>'it'
,p_message_text=>'Il numero di pagina a cui si fa riferimento esiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278385319009868121)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_language=>'it'
,p_message_text=>'L''area dispone di un''intestazione riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277882650062867804)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_language=>'it'
,p_message_text=>'Il report ha un ordine predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279104143956868578)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_language=>'it'
,p_message_text=>'Protezione stato sessione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277881817350867803)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_language=>'it'
,p_message_text=>'Uso errato della sintassi di sostituzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277880660059867803)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_language=>'it'
,p_message_text=>'Riferimenti con sintassi di sostituzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277881693173867803)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_language=>'it'
,p_message_text=>unistr('L''autorizzazione della pagina di destinazione \00E8 impostata anche per il componente corrente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278385504983868121)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_language=>'it'
,p_message_text=>'Stile tema sottoposto a test per l''accesso facilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278507440094868198)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_language=>'it'
,p_message_text=>unistr('L''interfaccia utente include JavaScript di compatibilit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277882319298867804)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_language=>'it'
,p_message_text=>'Elemento o colonna di convalide associato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277881510107867803)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 codice SQL o PL/SQL valido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277882013864867803)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_language=>'it'
,p_message_text=>unistr('Verifica propriet\00E0 Clob')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277881970634867803)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_language=>'it'
,p_message_text=>'Funzione V utilizzata nelle istruzioni SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277882509802867804)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_language=>'it'
,p_message_text=>'Il pulsante a cui si fa riferimento in Se si fa clic sul pulsante esiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277884913899867805)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_language=>'it'
,p_message_text=>'Errore di compilazione: %0. Istruzione: %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277885222664867805)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_language=>'it'
,p_message_text=>'Il collegamento contiene un valore non modificabile per l''ID applicazione corrente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278292614402868062)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_language=>'it'
,p_message_text=>'Nessun testo della Guida definito.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278385154999868121)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_language=>'it'
,p_message_text=>unistr('Questa pagina \00E8 priva di titolo. I titoli di pagina significativi sono importanti per l''accesso facilitato e per aiutare gli utenti a capire il contenuto e lo scopo della pagina corrente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278411201875868138)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_language=>'it'
,p_message_text=>unistr('Nell''elemento manca il testo alternativo richiesto per l''immagine. Il testo valido da utilizzare deve descrivere in modo adeguato il contenuto dell''immagine e inoltre non deve ripetere le informazioni gi\00E0 visibili nella pagina visualizzata nel contes')
||unistr('to dell''immagine (per evitare possibili duplicazioni). Nota: se l''immagine \00E8 fornita dagli utenti, dovr\00E0 esserlo anche il testo alternativo dell''immagine, con istruzioni appropriate per aiutare gli utenti a fornire testo di alta qualit\00E0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278988504888868503)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_language=>'it'
,p_message_text=>'"Uso API runtime" consente la modifica delle applicazioni e delle aree di lavoro.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277883462019867804)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('%0 non \00E8 un elemento della pagina %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277883526020867804)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('%0 non \00E8 un elemento della pagina di destinazione %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278385862826868121)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_language=>'it'
,p_message_text=>unistr('L''impostazione ''Azione pagina su selezione'' per l''elemento di pagina pu\00F2 causare la modifica imprevista del contesto per l''utente. Scegliere l''impostazione ''Nessuno'' in modo che non si verifichi alcuna modifica del contesto e sostituire la funzionali')
||unistr('t\00E0 con Azioni dinamiche o LOV a catena (se \00E8 necessario rimanere nella stessa pagina). In alternativa, fornire informazioni per l''utente in modo che sappia cosa si verificher\00E0, ad esempio, aggiungendo ''Visualizza una nuova pagina'' nell''etichetta. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278411006267868138)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_language=>'it'
,p_message_text=>'Definire un''etichetta per l''elemento. Se si preferisce non impostare un''etichetta visibile, definire comunque l''etichetta, ma selezionare il modello di etichetta ''Nascosta''.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278387055261868122)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_language=>'it'
,p_message_text=>unistr('L''elemento definisce un valore ''Segnaposto valore'', ma non un''etichetta. Il testo del segnaposto non deve essere utilizzato come unica etichetta dell''elemento, in quanto causa problemi di accesso facilitato. Per migliorare l''accesso facilitato, \00E8 nec')
||'essario definire un''etichetta per l''elemento. Se si preferisce non impostare un''etichetta visibile, definire comunque l''etichetta, ma selezionare il modello di etichetta ''Nascosta''.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277885620995867806)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_language=>'it'
,p_message_text=>'Il nome ha una lunghezza di %0 caratteri, ma deve contenere al massimo 30 caratteri.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277883837960867805)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'%0 potrebbe non esistere.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277883973341867805)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_language=>'it'
,p_message_text=>'%0 potrebbe non essere un elemento di pagina o di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277884284055867805)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'La pagina di svuotamento della cache %1 nell''applicazione %0 non esiste.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277884079492867805)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'Pagina %0 inesistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277884133459867805)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'La pagina di destinazione %1 nell''applicazione %0 non esiste.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278309193621868073)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_language=>'it'
,p_message_text=>unistr('Quest''area Attivazione/disattivazione colonna non contiene una colonna con l''attributo ''Usa come intestazione di riga'' impostato su ''S\00EC''. La colonna Intestazione riga deve essere la colonna che identifica in modo ottimale la riga corrente (ad esempio')
||' il nome di un cliente in un report delle informazioni sui clienti).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278309213793868073)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_language=>'it'
,p_message_text=>unistr('Quest''area Reflow non contiene una colonna con l''attributo ''Usa come intestazione di riga'' impostato su ''S\00EC''. La colonna Intestazione riga deve essere la colonna che identifica in modo ottimale la riga corrente (ad esempio il nome di un cliente in un')
||' report delle informazioni sui clienti).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278385481264868121)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_language=>'it'
,p_message_text=>unistr('Questa area di form tabulare non contiene una colonna con l''attributo "Usa come intestazione di riga" impostato su S\00EC. La colonna Intestazione riga deve essere la colonna che identifica in modo ottimale la riga corrente (ad esempio il nome del client')
||'e in una tabella di informazioni sul cliente). Queste informazioni vengono utilizzate successivamente durante la presentazione del form tabulare per fornire etichette univoche per i campi form di ogni riga.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277885807572867806)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_language=>'it'
,p_message_text=>'Il report non ha un ordine predefinito.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278988856368868503)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_language=>'it'
,p_message_text=>unistr('"Funzione hash segnalibro" \00E8 impostata su un algoritmo precedente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278988932962868503)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_language=>'it'
,p_message_text=>unistr('La funzione "Protezione stato sessione" \00E8 disabilitata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279103916280868577)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_language=>'it'
,p_message_text=>unistr('In una pagina con un processo di recupero \00E8 necessario utilizzare Protezione accesso pagina e abilitare la protezione per gli elementi passati mediante l''URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277842518691867778)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_language=>'it'
,p_message_text=>unistr('L''area contiene l''URL "f?p" che non \00E8 stato passato tramite APEX_UTIL.PREPARE_URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277885031583867805)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato rilevato un possibile inserimento SQL. %0 \00E8 utilizzato con sintassi di sostituzione nel codice SQL o PL/SQL oppure con un nome di tabella di processo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277882855977867804)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'%0 inesistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277882943926867804)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'it'
,p_message_text=>'Impossibile fare riferimento a %0 con una sintassi di sostituzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277884847000867805)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato definito uno schema di autorizzazione per la pagina di destinazione %1 nell''applicazione %0, ma non per il componente corrente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278385628799868121)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_language=>'it'
,p_message_text=>unistr('Lo stile di tema corrente per l''applicazione non \00E8 stato sottoposto a test per l''accesso facilitato. Passare a un altro stile di tema con l''attributo Test accesso facilitato eseguito impostato su S\00EC oppure, se lo stile di tema corrente \00E8 stato sottop')
||unistr('osto a test, impostarne l''attributo Test accesso facilitato eseguito su S\00EC nella pagina delle impostazioni del tema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278507631177868199)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('L''interfaccia utente include la funzione di migrazione jQuery, che facilita la migrazione a una versione pi\00F9 recente di jQuery mediante il ripristino delle interfacce API rimosse e visualizza avvertenze nella console del browser quando vengono utiliz')
||unistr('zate interfacce API rimosse o non pi\00F9 valide. Ci\00F2 comporta l''inserimento di un file JavaScript extra in ogni pagina dell''applicazione. Per informazioni sulla rimozione di tali elementi, vedere la Guida all''aggiornamento della funzione di migrazione j')
||unistr('Query per i dettagli sulle interfacce API da modificare, quindi, dopo aver verificato che tali interfacce API non siano pi\00F9 utilizzate, impostare Includi migrazione jQuery su No.'),
'',
'https://github.com/jquery/jquery-migrate'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278507570381868198)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_language=>'it'
,p_message_text=>unistr('L''interfaccia utente include funzioni JavaScript non pi\00F9 valide o non pi\00F9 supportate. Ci\00F2 comporta l''inserimento di un file JavaScript extra in ogni pagina dell''applicazione. Per informazioni sulla rimozione di tali elementi, vedere la sezione relati')
||unistr('va alle funzioni non pi\00F9 valide delle Note di rilascio. Tale sezione contiene inoltre le istruzioni per il controllo delle dipendenze delle funzioni non pi\00F9 valide o non pi\00F9 supportate e suggerimenti per evitarne l''inclusione nell''applicazione in fut')
||'uro.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277885543546867806)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_language=>'it'
,p_message_text=>unistr('La colonna o l''elemento associato non \00E8 definito, ma "Posizione di visualizzazione del messaggio di errore" lo richiede.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277885416716867806)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_language=>'it'
,p_message_text=>unistr('La colonna o l''elemento associato non \00E8 uguale a "%0", specificato nell''espressione di convalida 1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277884420269867805)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_language=>'it'
,p_message_text=>'Errore di compilazione: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277884553674867805)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_language=>'it'
,p_message_text=>'Nessun codice SQL o PL/SQL definito.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277882709107867804)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 pi\00F9 lungo di 32767 caratteri. Vengono controllati solo i primi 32767 caratteri. Lunghezza: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277885144235867805)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_language=>'it'
,p_message_text=>unistr('Contiene una chiamata di funzione V/NV/DV nell''istruzione SQL. \00C8 possibile che sia un problema di prestazioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277885780785867806)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>unistr('Il pulsante a cui si fa riferimento non esiste pi\00F9.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278279292702868054)
,p_name=>'AFTER'
,p_message_language=>'it'
,p_message_text=>'Dopo'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278220504590868017)
,p_name=>'AGREEMENT_MISSING'
,p_message_language=>'it'
,p_message_text=>'Accordo mancante'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278025451735867894)
,p_name=>'ALIAS'
,p_message_language=>'it'
,p_message_text=>'Alias'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278731668969868340)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_language=>'it'
,p_message_text=>'Consenti creazione applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278648448446868288)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Consente l''installazione di applicazioni di produttivit\00E0 e di esempio.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278483709464868183)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_language=>'it'
,p_message_text=>'Consenti uso dei servizi per REST'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278731729737868340)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_language=>'it'
,p_message_text=>'Consenti uso di SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278731951228868340)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_language=>'it'
,p_message_text=>'Consenti uso di Team Development'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278731564804868340)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_language=>'it'
,p_message_text=>'Consenti rimozione aree di lavoro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278731803567868340)
,p_name=>'ALLOW_WEBSHEET_DEV'
,p_message_language=>'it'
,p_message_text=>'Consenti Websheet Development'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278044701028867906)
,p_name=>'ALL_APPLICATIONS'
,p_message_language=>'it'
,p_message_text=>'Tutte le applicazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277830525688867771)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_language=>'it'
,p_message_text=>'- Tutto - '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277830344277867771)
,p_name=>'ALL_CATEGORIES'
,p_message_language=>'it'
,p_message_text=>'Tutte le categorie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277830670737867771)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_language=>'it'
,p_message_text=>'- Tutte le categorie -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278734636098868342)
,p_name=>'ALL_MILESTONES'
,p_message_language=>'it'
,p_message_text=>'Tutti i milestone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278412668289868139)
,p_name=>'ALL_RELEASES'
,p_message_language=>'it'
,p_message_text=>'Tutte le release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278050660839867910)
,p_name=>'ALL_STATIC_FILES'
,p_message_language=>'it'
,p_message_text=>'tutti i file statici'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278049230216867909)
,p_name=>'ALL_THEMES'
,p_message_language=>'it'
,p_message_text=>'tutti i temi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278756316513868356)
,p_name=>'ALL_TYPES'
,p_message_language=>'it'
,p_message_text=>'Tutti i tipi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278756782338868356)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_language=>'it'
,p_message_text=>'- Tutti i tipi -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278045823991867907)
,p_name=>'ALL_USERS'
,p_message_language=>'it'
,p_message_text=>'Tutti gli utenti'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279098446609868574)
,p_name=>'ALREADY_IN_ACL'
,p_message_language=>'it'
,p_message_text=>unistr('L''utente dispone gi\00E0 di un account APEX')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279088365262868567)
,p_name=>'ALREADY_IN_WS'
,p_message_language=>'it'
,p_message_text=>unistr('L''utente esiste gi\00E0 nell''area di lavoro')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279049094410868543)
,p_name=>'ALWAYS'
,p_message_language=>'it'
,p_message_text=>'Sempre'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277802006056867753)
,p_name=>'AM_PM'
,p_message_language=>'it'
,p_message_text=>'AM / PM'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278295983961868065)
,p_name=>'ANALYSIS'
,p_message_language=>'it'
,p_message_text=>'Analisi %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278296049153868065)
,p_name=>'ANALYZE'
,p_message_language=>'it'
,p_message_text=>'Analizza per %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278434978450868153)
,p_name=>'ANALYZE_TABLE'
,p_message_language=>'it'
,p_message_text=>'Analizza con il metodo %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277903626096867817)
,p_name=>'ANCHOR.SHOW_ALL'
,p_message_language=>'it'
,p_message_text=>'Mostra tutto'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278048170260867908)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_language=>'it'
,p_message_text=>'blocco anonimo'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277890559264867809)
,p_name=>'ANSWERS'
,p_message_language=>'it'
,p_message_text=>'Risposte'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277842237139867778)
,p_name=>'ANY_DEVELOPER'
,p_message_language=>'it'
,p_message_text=>'(Qualsiasi sviluppatore)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279064114453868552)
,p_name=>'APEX.ACTIONS.TOGGLE'
,p_message_language=>'it'
,p_message_text=>'Attiva/disattiva %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279103361211868577)
,p_name=>'APEX.ACTIVE_STATE'
,p_message_language=>'it'
,p_message_text=>'(Attivo)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279166998437868617)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_language=>'it'
,p_message_text=>'Modifiche all''applicazione:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279166821133868617)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_language=>'it'
,p_message_text=>'Ora:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279171677771868620)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_language=>'it'
,p_message_text=>'%0 K'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279167094449868618)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_language=>'it'
,p_message_text=>'Visualizzazioni di pagina: '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278689057970868313)
,p_name=>'APEX.AJAX_SERVER_ERROR'
,p_message_language=>'it'
,p_message_text=>'La chiamata Ajax ha restituito un errore del server %0 per %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278986445157868502)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Una chiamata di interfaccia API \00E8 stata proibita.'),
'Contattare l''amministratore.',
'I dettagli dell''incidente sono disponibili tramite l''ID debug "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278093194385867936)
,p_name=>'APEX.APPLICATION.ALIAS.NON_UNIQUE'
,p_message_language=>'it'
,p_message_text=>'Impossibile convertire l''alias di applicazione "%0" in un ID di applicazione univoco.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278093297623867936)
,p_name=>'APEX.APPLICATION.ALIAS.NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'L''applicazione con l''alias "%0" non esiste.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278050858515867910)
,p_name=>'APEX.APPLICATION.ALIAS.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'ERR-1816 Errore imprevisto durante la conversione dell''alias di applicazione p_flow_alias_or_id (%0).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277919602825867827)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_language=>'it'
,p_message_text=>unistr('La chiamata di interfaccia API "%0" non \00E8 pi\00F9 supportata in Application Express versione %1. I dettagli relativi all''incidente sono disponibili tramite l''ID debug "%2".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277926371780867831)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNC.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione della funzione di autenticazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277813975498867761)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione della funzione di autenticazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279181753983868627)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.HOST_PREFIX_MISMATCH'
,p_message_language=>'it'
,p_message_text=>unistr('Il nome tenant %0 restituito da Oracle Cloud Identity Management non \00E8 autorizzato per il dominio %1.<br/><a href="&LOGOUT_URL.">Eseguire di nuovo il login</a> e specificare un nome tenant autorizzato oppure modificare l''URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277807010518867756)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.USER_IS_NOT_DEVELOPER'
,p_message_language=>'it'
,p_message_text=>'L''account "%0" non dispone dei privilegi di sviluppo necessari (DB_DEVELOPER o DB_ADMINISTRATOR)<br/>per l''area di lavoro "%1". <a href="&LOGOUT_URL.">Eseguire di nuovo il login</a> dopo aver ottenuto i privilegi.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277802404895867753)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.WRONG_GROUP_NAME'
,p_message_language=>'it'
,p_message_text=>unistr('Il nome tenant restituito da Oracle Cloud Identity Management non \00E8 autorizzato per l''area di lavoro corrente.<br/><a href="&LOGOUT_URL.">Eseguire di nuovo il login</a> e specificare un nome tenant autorizzato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277940636125867840)
,p_name=>'APEX.AUTHENTICATION.HEADER.DUPLICATE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('L''intestazione HTTP %0 \00E8 stata inviata due volte e potrebbe essere un attacco.'),
'<ul>',
'<li>Primo valore: "%1"</li>',
'<li>Secondo valore: "%2"</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277807297566867756)
,p_name=>'APEX.AUTHENTICATION.HOST_PREFIX_MISMATCH'
,p_message_language=>'it'
,p_message_text=>unistr('Per motivi di sicurezza, l''esecuzione delle applicazioni di questa area di lavoro tramite il dominio nell''URL non \00E8 consentita.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277926006187867831)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.ASK_FOR_INSTALLATION'
,p_message_language=>'it'
,p_message_text=>'Chiedere al proprio DBA di eseguire $OH/rdbms/admin/catldap.sql.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277925956831867831)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.MISSING'
,p_message_language=>'it'
,p_message_text=>unistr('Il package SYS.DBMS_LDAP non esiste o non \00E8 valido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277925869295867831)
,p_name=>'APEX.AUTHENTICATION.LDAP.EDIT_USER_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione della funzione di modifica utente LDAP.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277926182837867831)
,p_name=>'APEX.AUTHENTICATION.LDAP.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione dell''autenticazione LDAP.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277927331739867832)
,p_name=>'APEX.AUTHENTICATION.LOGIN.ILLEGAL_PAGE_ARG'
,p_message_language=>'it'
,p_message_text=>'Errore nell''argomento p_flow_page per la procedura login_page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277926807215867832)
,p_name=>'APEX.AUTHENTICATION.LOGIN.INVALID_ARG'
,p_message_language=>'it'
,p_message_text=>'p_session non valido in wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277926614991867832)
,p_name=>'APEX.AUTHENTICATION.LOGIN.MALFORMED_ARGS'
,p_message_language=>'it'
,p_message_text=>'Argomento con formato non valido per wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277927010809867832)
,p_name=>'APEX.AUTHENTICATION.LOGIN.NULL_USER'
,p_message_language=>'it'
,p_message_text=>'Nome utente nullo passato alla procedura di login.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277826749284867769)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.COUNTER'
,p_message_language=>'it'
,p_message_text=>'Lasciar trascorrere <span id="apex_login_throttle_sec">%0</span> secondi prima di tentare di nuovo il login.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277831719294867772)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.ERROR'
,p_message_language=>'it'
,p_message_text=>unistr('Il tentativo di login \00E8 stato bloccato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278267046852868046)
,p_name=>'APEX.AUTHENTICATION.NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'Autenticazione "%0" non trovata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277840311329867777)
,p_name=>'APEX.AUTHENTICATION.NO_SECURITY_GROUP_ID'
,p_message_language=>'it'
,p_message_text=>'ID gruppo di sicurezza nullo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277926538478867832)
,p_name=>'APEX.AUTHENTICATION.POST_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''esecuzione del processo di post-autenticazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277926280380867831)
,p_name=>'APEX.AUTHENTICATION.PRE_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione del processo di pre-autenticazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277945763556867844)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD.INSTRUCTIONS'
,p_message_language=>'it'
,p_message_text=>unistr('Aprire l''URL nello stesso browser in cui \00E8 stata avviata la richiesta di reimpostazione della password.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279166118638868617)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD_URL'
,p_message_language=>'it'
,p_message_text=>'Reimposta URL password'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277807427306867756)
,p_name=>'APEX.AUTHENTICATION.RM_GROUP_NOT_GRANTED'
,p_message_language=>'it'
,p_message_text=>unistr('Il gruppo di consumer di Resource Manager %0 non \00E8 stato concesso a %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277807583925867757)
,p_name=>'APEX.AUTHENTICATION.RM_INFO_TO_GRANT'
,p_message_language=>'it'
,p_message_text=>'Usare DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP per concedere il privilegio mancante.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278003527698867880)
,p_name=>'APEX.AUTHENTICATION.SESSION_SENTRY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione della funzione sentry della sessione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278003672763867880)
,p_name=>'APEX.AUTHENTICATION.SESSION_VERIFY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione della funzione di verifica della sessione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278003851272867880)
,p_name=>'APEX.AUTHENTICATION.SSO.ASK_FOR_INSTALLATION'
,p_message_language=>'it'
,p_message_text=>'Chiedere all''amministratore di %0 di configurare il motore per Oracle Application Server Single Sign-On.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278079931520867928)
,p_name=>'APEX.AUTHENTICATION.SSO.BAD_URLC'
,p_message_language=>'it'
,p_message_text=>'%0 non valido nel token %1 restituito da SSO.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277927278168867832)
,p_name=>'APEX.AUTHENTICATION.SSO.FIX_PARTNER_APP'
,p_message_language=>'it'
,p_message_text=>'Modificare lo schema di autenticazione e aggiungere il nome dell''applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278079516008867928)
,p_name=>'APEX.AUTHENTICATION.SSO.ILLEGAL_CALLER'
,p_message_language=>'it'
,p_message_text=>'Chiamante non valido della procedura %0:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278079738550867928)
,p_name=>'APEX.AUTHENTICATION.SSO.INVALID_APP_SESSION'
,p_message_language=>'it'
,p_message_text=>'Sessione di applicazione non valida nel token URLC: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278079301273867928)
,p_name=>'APEX.AUTHENTICATION.SSO.MISSING_APP_REGISTRATION'
,p_message_language=>'it'
,p_message_text=>'Errore in portal_sso_redirect: informazioni sulla registrazione dell''applicazione mancanti: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278003769620867880)
,p_name=>'APEX.AUTHENTICATION.SSO.PACKAGE_MISSING'
,p_message_language=>'it'
,p_message_text=>unistr('Il package WWSEC_SSO_ENABLER_PRIVATE non esiste o non \00E8 valido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277927199808867832)
,p_name=>'APEX.AUTHENTICATION.SSO.PARTNER_APP_IS_NULL'
,p_message_language=>'it'
,p_message_text=>'Impossibile trovare il nome di applicazione partner registrato nello schema di autenticazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278079467255867928)
,p_name=>'APEX.AUTHENTICATION.SSO.REGISTER_APP'
,p_message_language=>'it'
,p_message_text=>'Registrare questa applicazione come descritto nella guida all''installazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278003998567867880)
,p_name=>'APEX.AUTHENTICATION.SSO.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione dell''autenticazione SSO.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279082923888868564)
,p_name=>'APEX.AUTHENTICATION.UNAUTHORIZED_URL'
,p_message_language=>'it'
,p_message_text=>'URL non autorizzato:  %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278003357465867880)
,p_name=>'APEX.AUTHENTICATION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione dell''autenticazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277807316762867756)
,p_name=>'APEX.AUTHENTICATION.WORKSPACE_NOT_ASSIGNED'
,p_message_language=>'it'
,p_message_text=>unistr('L''area di lavoro "%0" \00E8 inattiva. Contattare l''amministratore.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277808513337867757)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED'
,p_message_language=>'it'
,p_message_text=>'%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277829281258867770)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Accesso negato dal controllo di sicurezza dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277829320388867770)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.PAGE'
,p_message_language=>'it'
,p_message_text=>'Accesso negato dal controllo di sicurezza della pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277829405638867770)
,p_name=>'APEX.AUTHORIZATION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione dell''autorizzazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278306226958868071)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_language=>'it'
,p_message_text=>'#LABEL# inesistente nella lista.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278688611929868313)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_language=>'it'
,p_message_text=>unistr('Mostra solo diramazioni non \00E8 supportato se l''attributo di pagina "Ricarica se si fa clic su Sottometti" \00E8 impostato su "Solo per operazione riuscita".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278053603784867912)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione della diramazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278374141796868114)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX'
,p_message_language=>'it'
,p_message_text=>'Creato con %0 utilizzando %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278374253461868114)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX.ACCESSIBLE.LOVE'
,p_message_language=>'it'
,p_message_text=>'amore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278410871991868137)
,p_name=>'APEX.CALCULATOR.ICON_TEXT'
,p_message_language=>'it'
,p_message_text=>'Calcolatore popup: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279038976810868536)
,p_name=>'APEX.CALENDAR.EVENT_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Descrizione evento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279038719000868536)
,p_name=>'APEX.CALENDAR.EVENT_END'
,p_message_language=>'it'
,p_message_text=>'Data di fine'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279039075924868536)
,p_name=>'APEX.CALENDAR.EVENT_ID'
,p_message_language=>'it'
,p_message_text=>'ID evento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279038610731868536)
,p_name=>'APEX.CALENDAR.EVENT_START'
,p_message_language=>'it'
,p_message_text=>'Data di inizio'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279038883140868536)
,p_name=>'APEX.CALENDAR.EVENT_TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo evento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278506904492868198)
,p_name=>'APEX.CLIPBOARD.COPIED'
,p_message_language=>'it'
,p_message_text=>'Copiato negli Appunti.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278499963136868194)
,p_name=>'APEX.CLIPBOARD.NOTSUP'
,p_message_language=>'it'
,p_message_text=>'Questo browser non supporta la copia da un pulsante o da un menu. Provare con Ctrl+C o Comando+C.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278376247725868115)
,p_name=>'APEX.CLOSE_NOTIFICATION'
,p_message_language=>'it'
,p_message_text=>'Chiudi notifica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277798099959867751)
,p_name=>'APEX.COLOR_PICKER.ICON_TEXT'
,p_message_language=>'it'
,p_message_text=>'Selettore colori popup: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279152113928868608)
,p_name=>'APEX.COMBOBOX.LIST_OF_VALUES'
,p_message_language=>'it'
,p_message_text=>'Lista di valori'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279152207414868608)
,p_name=>'APEX.COMBOBOX.SHOW_ALL_VALUES'
,p_message_language=>'it'
,p_message_text=>'Apri lista per: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279103420273868577)
,p_name=>'APEX.COMPLETED_STATE'
,p_message_language=>'it'
,p_message_text=>'(Completato)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277808759197867757)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione del calcolo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278031057380867898)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione della condizione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278093788792867937)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di condizione sconosciuto "%0"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278058932031867915)
,p_name=>'APEX.CONTACT_ADMIN'
,p_message_language=>'it'
,p_message_text=>'Rivolgersi all''amministratore delle applicazioni.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278141279477867967)
,p_name=>'APEX.CONTACT_ADMIN.DEBUG'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Contattare l''amministratore dell''applicazione.',
'I dettagli relativi all''incidente sono disponibili tramite l''ID debug "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279025979787868528)
,p_name=>'APEX.CORRECT_ERRORS'
,p_message_language=>'it'
,p_message_text=>'Correggere gli errori prima di salvare'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279107688475868580)
,p_name=>'APEX.CURRENT_PROGRESS'
,p_message_language=>'it'
,p_message_text=>'Avanzamento corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278726985980868337)
,p_name=>'APEX.DATA_HAS_CHANGED'
,p_message_language=>'it'
,p_message_text=>unistr('La versione corrente dei dati nel database \00E8 cambiata da quando l''utente ha iniziato il processo di aggiornamento.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278410771615868137)
,p_name=>'APEX.DATEPICKER.ICON_TEXT'
,p_message_language=>'it'
,p_message_text=>'Calendario popup: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278419826074868143)
,p_name=>'APEX.DATEPICKER_VALUE_GREATER_MAX_DATE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di #LABEL# \00E8 maggiore della data massima specificata %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278425143010868147)
,p_name=>'APEX.DATEPICKER_VALUE_INVALID'
,p_message_language=>'it'
,p_message_text=>'Il valore di #LABEL# non corrisponde al formato %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278419774224868143)
,p_name=>'APEX.DATEPICKER_VALUE_LESS_MIN_DATE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di #LABEL# \00E8 minore della data minima specificata %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278419999560868143)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di #LABEL# non \00E8 compreso nell''intervallo valido tra %0 e %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278423471019868145)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_IN_YEAR_RANGE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di #LABEL# non \00E8 compreso nell''intervallo valido di anni tra %0 e %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279026658937868528)
,p_name=>'APEX.DIALOG.CANCEL'
,p_message_language=>'it'
,p_message_text=>'Annulla'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279132399944868595)
,p_name=>'APEX.DIALOG.CLOSE'
,p_message_language=>'it'
,p_message_text=>'Chiudi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279137315281868599)
,p_name=>'APEX.DIALOG.HELP'
,p_message_language=>'it'
,p_message_text=>'Guida'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279026415665868528)
,p_name=>'APEX.DIALOG.OK'
,p_message_language=>'it'
,p_message_text=>'OK'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278237860673868028)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_language=>'it'
,p_message_text=>'Impossibile visualizzare in modo corretto la pagina finestra di dialogo %1 dell''applicazione %0. Assicurarsi che il modello di pagina utilizzato nella pagina %1 sia del tipo "Pagina finestra di dialogo", con il codice JavaScript di inizializzazione, '
||'chiusura e annullamento della finestra di dialogo appropriato definito.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279026518951868528)
,p_name=>'APEX.DIALOG.SAVE'
,p_message_language=>'it'
,p_message_text=>'Salva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279154048625868609)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_language=>'it'
,p_message_text=>unistr('Copyright \00A9 %0. Tutti i diritti riservati.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279154854706868610)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_language=>'it'
,p_message_text=>'Crea area di lavoro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279153980704868609)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_language=>'it'
,p_message_text=>unistr('Questo \00E8 un messaggio generato dal sistema, non rispondere.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279163723153868615)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_language=>'it'
,p_message_text=>'Ambiente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279176384099868623)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_language=>'it'
,p_message_text=>'Utente Oracle Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279155499578868610)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_language=>'it'
,p_message_text=>'Introduzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279154189804868609)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_language=>'it'
,p_message_text=>'Gentile %0,'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279155122811868610)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_language=>'it'
,p_message_text=>'Password'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279163878892868615)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_language=>'it'
,p_message_text=>'Impedisci rimozione aree di lavoro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279155378717868610)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_language=>'it'
,p_message_text=>unistr('Per evitare che l''area di lavoro venga rimossa, fare clic sul pulsante sottostante e attenersi alle istruzioni visualizzate. Se non si svolge alcuna attivit\00E0 per %0 giorno/i, l''area di lavoro verr\00E0 rimossa in modo automatico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279163587268868615)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_language=>'it'
,p_message_text=>unistr('Non necessaria alcuna azione se l''area di lavoro non \00E8 pi\00F9 indispensabile.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279164089646868616)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_language=>'it'
,p_message_text=>'L''area di lavoro sta per essere rimossa.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279163353999868615)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_language=>'it'
,p_message_text=>unistr('Non \00E8 stata rilevata alcuna attivit\00E0 recente per l''area di lavoro %0, che \00E8 stata pianificata per essere rimossa a breve termine.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279163216214868615)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_language=>'it'
,p_message_text=>'Avvertenza: l''area di lavoro "%0" sta per essere rimossa.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279163671082868615)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_language=>'it'
,p_message_text=>'Data rimozione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279164348295868616)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_language=>'it'
,p_message_text=>'Completare la richiesta di area di lavoro.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279164189301868616)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_language=>'it'
,p_message_text=>unistr('L''area di lavoro "%0" \00E8 pronta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279164401368868616)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_language=>'it'
,p_message_text=>unistr('L''area di lavoro "%0" \00E8 stata approvata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279164260731868616)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_language=>'it'
,p_message_text=>unistr('La richiesta di area di lavoro \00E8 stata rifiutata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279154742031868610)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_language=>'it'
,p_message_text=>'Nome utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279163998524868616)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_language=>'it'
,p_message_text=>'Avvertenza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279154643693868610)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_language=>'it'
,p_message_text=>'Area di lavoro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279154247440868609)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_language=>'it'
,p_message_text=>'Richiesta di area di lavoro approvata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279154964947868610)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_language=>'it'
,p_message_text=>'Fare clic sul pulsante riportato di seguito per completare il processo di approvazione e impostare la password.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279154496040868610)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_language=>'it'
,p_message_text=>unistr('La richiesta di area di lavoro \00E8 stata approvata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279155005328868610)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_language=>'it'
,p_message_text=>'Fare clic sul pulsante in basso per iniziare.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279155298238868610)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_language=>'it'
,p_message_text=>unistr('L''area di lavoro \00E8 pronta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279154366805868609)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_language=>'it'
,p_message_text=>'Richiesta di area di lavoro rifiutata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279154531787868610)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_language=>'it'
,p_message_text=>unistr('La richiesta di area di lavoro \00E8 stata rifiutata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278053974964867912)
,p_name=>'APEX.ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277804279115867754)
,p_name=>'APEX.ERROR.CALLBACK_FAILED'
,p_message_language=>'it'
,p_message_text=>unistr('Durante il callback di gestione degli errori si \00E8 verificato l''errore seguente: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277845358144867780)
,p_name=>'APEX.ERROR.ERROR_PAGE.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 verificato un errore durante la pittura della pagina di errore: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277808093288867757)
,p_name=>'APEX.ERROR.INTERNAL'
,p_message_language=>'it'
,p_message_text=>'Errore interno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279096488226868573)
,p_name=>'APEX.ERROR.INTERNAL.CONTACT_ADMINISTRATOR'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Contattare l''amministratore.',
'I dettagli relativi all''incidente sono disponibili tramite l''ID debug "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279177272020868624)
,p_name=>'APEX.ERROR.ORA-28353'
,p_message_language=>'it'
,p_message_text=>'ORA-28353: apertura del wallet non riuscita. Dati dell''applicazione attualmente non accessibili.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279078696231868561)
,p_name=>'APEX.ERROR.PAGE_NOT_AVAILABLE'
,p_message_language=>'it'
,p_message_text=>unistr('Questa pagina non \00E8 disponibile')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277813867663867760)
,p_name=>'APEX.ERROR.TECHNICAL_INFO'
,p_message_language=>'it'
,p_message_text=>'Informazioni tecniche (visibili solo per gli sviluppatori)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278641648904868283)
,p_name=>'APEX.ERROR_MESSAGE_HEADING'
,p_message_language=>'it'
,p_message_text=>'Messaggio di errore'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278715529966868330)
,p_name=>'APEX.EXPECTED_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formato previsto: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278439114216868155)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.ALREADY_IN_ACL'
,p_message_language=>'it'
,p_message_text=>unistr('L''utente \00E8 gi\00E0 definito nella lista di controllo dell''accesso')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278439060037868155)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.CREATE_CONFIRM'
,p_message_language=>'it'
,p_message_text=>'Confermare l''aggiunta dei %0 utenti <strong>%1</strong> seguenti alla lista di controllo dell''accesso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278439532375868156)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.DUPLICATE_USE'
,p_message_language=>'it'
,p_message_text=>'Esiste un utente duplicato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278439247957868155)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_AT_SIGN'
,p_message_language=>'it'
,p_message_text=>'Chiocciola (@) mancante nell''indirizzo di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278439384271868155)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_DO'
,p_message_language=>'it'
,p_message_text=>'Punto (.) mancante nell''indirizzo di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278439466592868155)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.USERNAME_TOO_LONG'
,p_message_language=>'it'
,p_message_text=>unistr('Il nome utente \00E8 troppo lungo')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278439784074868156)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_ONLY'
,p_message_language=>'it'
,p_message_text=>'Solo gli utenti definiti nella lista di controllo dell''accesso dell''applicazione possono accedere a questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278439838379868156)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_VALUE_INVALID'
,p_message_language=>'it'
,p_message_text=>'Valore di impostazione del controllo dell''accesso imprevisto: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278439646376868156)
,p_name=>'APEX.FEATURE.ACL.INFO.ALL_USERS'
,p_message_language=>'it'
,p_message_text=>'Tutti gli utenti autenticati possono accedere a questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278985272777868501)
,p_name=>'APEX.FEATURE.CONFIG.DISABLED'
,p_message_language=>'it'
,p_message_text=>'Disabilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278985150650868501)
,p_name=>'APEX.FEATURE.CONFIG.ENABLED'
,p_message_language=>'it'
,p_message_text=>'Abilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278986236114868502)
,p_name=>'APEX.FEATURE.CONFIG.IS_DISABLED'
,p_message_language=>'it'
,p_message_text=>unistr('%0: \00C8 disabilitato')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278985329500868501)
,p_name=>'APEX.FEATURE.CONFIG.IS_ENABLED'
,p_message_language=>'it'
,p_message_text=>unistr('%0: \00C8 abilitato')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278374967728868115)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_language=>'it'
,p_message_text=>'In coda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278375084475868115)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_language=>'it'
,p_message_text=>'Inviati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278985047304868501)
,p_name=>'APEX.FEATURE.TOP_USERS.USERNAME.NOT_IDENTIFIED'
,p_message_language=>'it'
,p_message_text=>'non identificato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277838634178867776)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_language=>'it'
,p_message_text=>'Voci di feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277838758374867776)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_language=>'it'
,p_message_text=>'Voci di feedback aperte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277838824770867776)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_language=>'it'
,p_message_text=>'Utenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278728672598868338)
,p_name=>'APEX.FILE_BROWSE.DOWNLOAD_LINK_TEXT'
,p_message_language=>'it'
,p_message_text=>'Scarica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278721873543868334)
,p_name=>'APEX.FS.BATCH_APPLY'
,p_message_language=>'it'
,p_message_text=>'Applica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278722319623868334)
,p_name=>'APEX.FS.CLEAR'
,p_message_language=>'it'
,p_message_text=>'Cancella'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278722451818868334)
,p_name=>'APEX.FS.CLEAR_ALL'
,p_message_language=>'it'
,p_message_text=>'Cancella tutto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278722549806868334)
,p_name=>'APEX.FS.CLEAR_VALUE'
,p_message_language=>'it'
,p_message_text=>'Cancella %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279053191786868545)
,p_name=>'APEX.FS.COLUMN_UNAUTHORIZED'
,p_message_language=>'it'
,p_message_text=>unistr('La colonna %1, a cui fa riferimento il facet %0, non \00E8 disponibile o non \00E8 autorizzata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279045553351868540)
,p_name=>'APEX.FS.FACET_VALUE_LIMIT_EXCEEDED'
,p_message_language=>'it'
,p_message_text=>'Limite del valore distinto (%0) superato per il facet %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278724008955868335)
,p_name=>'APEX.FS.FC_TYPE_UNSUPPORTED_FOR_DATE_COLUMNS'
,p_message_language=>'it'
,p_message_text=>unistr('Il facet %0 non \00E8 supportato per le colonne DATE o TIMESTAMP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278721945323868334)
,p_name=>'APEX.FS.FILTER'
,p_message_language=>'it'
,p_message_text=>'Filtra %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278722030455868334)
,p_name=>'APEX.FS.GO'
,p_message_language=>'it'
,p_message_text=>'Vai'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278723651538868335)
,p_name=>'APEX.FS.INPUT_CURRENT_LABEL'
,p_message_language=>'it'
,p_message_text=>'uguale a %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278723867879868335)
,p_name=>'APEX.FS.NO_SEARCH_COLUMNS_PROVIDED'
,p_message_language=>'it'
,p_message_text=>'Nessuna colonna di ricerca fornita per il facet %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278723334238868335)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL'
,p_message_language=>'it'
,p_message_text=>'Tra %0 e %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278723466643868335)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_HI'
,p_message_language=>'it'
,p_message_text=>'Al di sopra di %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278723523759868335)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_LO'
,p_message_language=>'it'
,p_message_text=>'Al di sotto di %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279063943298868552)
,p_name=>'APEX.FS.RANGE_LOV_ITEM_INVALID'
,p_message_language=>'it'
,p_message_text=>unistr('L''elemento LOV #%2 ("%1") per il facet Intervallo %0 non \00E8 valido (separatore "|" mancante).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278723758752868335)
,p_name=>'APEX.FS.RANGE_MANUAL_NOT_SUPPORTED'
,p_message_language=>'it'
,p_message_text=>unistr('Attualmente l''input manuale per il facet Intervallo %0 non \00E8 supportato perch\00E9 la colonna \00E8 del tipo DATE o TIMESTAMP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278722947976868335)
,p_name=>'APEX.FS.RANGE_TEXT'
,p_message_language=>'it'
,p_message_text=>'a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278722247883868334)
,p_name=>'APEX.FS.SEARCH_LABEL'
,p_message_language=>'it'
,p_message_text=>'Cerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278722186867868334)
,p_name=>'APEX.FS.SEARCH_PLACEHOLDER'
,p_message_language=>'it'
,p_message_text=>'Cerca...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278723112563868335)
,p_name=>'APEX.FS.SELECT_PLACEHOLDER'
,p_message_language=>'it'
,p_message_text=>'- Seleziona -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278722725482868335)
,p_name=>'APEX.FS.SHOW_LESS'
,p_message_language=>'it'
,p_message_text=>'Mostra meno'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278722864597868335)
,p_name=>'APEX.FS.SHOW_MORE'
,p_message_language=>'it'
,p_message_text=>'Mostra altro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278723017655868335)
,p_name=>'APEX.FS.STAR_RATING_LABEL'
,p_message_language=>'it'
,p_message_text=>'%0 stelle e oltre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278723980299868335)
,p_name=>'APEX.FS.TEXT_FIELD_ONLY_FOR_NUMBER_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Attualmente il facet Campo di testo %0 u supportato solo per le colonne NUMBER.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279053336885868545)
,p_name=>'APEX.FS.UNSUPPORTED_DATA_TYPE'
,p_message_language=>'it'
,p_message_text=>unistr('Il tipo di dati %0 (%1) non \00E8 supportato per la ricerca con facet.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278986890938868502)
,p_name=>'APEX.GO_TO_ERROR'
,p_message_language=>'it'
,p_message_text=>'Vai a errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278199769681868004)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'Impossibile trovare il gruppo "%0"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278445662599868160)
,p_name=>'APEX.GV.AGG_CONTEXT'
,p_message_language=>'it'
,p_message_text=>'Aggregato.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278554293417868228)
,p_name=>'APEX.GV.BREAK_COLLAPSE'
,p_message_language=>'it'
,p_message_text=>'Comprimi interruzione di controllo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278445753383868160)
,p_name=>'APEX.GV.BREAK_CONTEXT'
,p_message_language=>'it'
,p_message_text=>'Interruzione di controllo.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278554102665868228)
,p_name=>'APEX.GV.BREAK_EXPAND'
,p_message_language=>'it'
,p_message_text=>'Espandi interruzione di controllo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279183432536868628)
,p_name=>'APEX.GV.COLUMN_CONTEXT'
,p_message_language=>'it'
,p_message_text=>'Colonna %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278553990872868228)
,p_name=>'APEX.GV.DELETED_COUNT'
,p_message_language=>'it'
,p_message_text=>'%0 righe eliminate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279142978530868602)
,p_name=>'APEX.GV.DUP_REC_ID'
,p_message_language=>'it'
,p_message_text=>unistr('Identit\00E0 duplicata')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278432625105868151)
,p_name=>'APEX.GV.FIRST_PAGE'
,p_message_language=>'it'
,p_message_text=>'Primo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278445969942868160)
,p_name=>'APEX.GV.GROUP_CONTEXT'
,p_message_language=>'it'
,p_message_text=>'Intestazione gruppo.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278445894990868160)
,p_name=>'APEX.GV.HEADER_CONTEXT'
,p_message_language=>'it'
,p_message_text=>'Intestazione.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278432781628868151)
,p_name=>'APEX.GV.LAST_PAGE'
,p_message_language=>'it'
,p_message_text=>'Ultimo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278594533670868254)
,p_name=>'APEX.GV.LOAD_MORE'
,p_message_language=>'it'
,p_message_text=>'Carica altre righe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278432407439868151)
,p_name=>'APEX.GV.NEXT_PAGE'
,p_message_language=>'it'
,p_message_text=>'Successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278446076198868160)
,p_name=>'APEX.GV.PAGE_RANGE'
,p_message_language=>'it'
,p_message_text=>'Righe di pagina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278432873929868151)
,p_name=>'APEX.GV.PAGE_RANGE_XY'
,p_message_language=>'it'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278432995991868151)
,p_name=>'APEX.GV.PAGE_RANGE_XYZ'
,p_message_language=>'it'
,p_message_text=>'%0 - %1 di %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278432515923868151)
,p_name=>'APEX.GV.PREV_PAGE'
,p_message_language=>'it'
,p_message_text=>'Precedente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279142740988868602)
,p_name=>'APEX.GV.ROW_ADDED'
,p_message_language=>'it'
,p_message_text=>'Aggiunto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279142828916868602)
,p_name=>'APEX.GV.ROW_CHANGED'
,p_message_language=>'it'
,p_message_text=>'Modificato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279183202472868628)
,p_name=>'APEX.GV.ROW_COLUMN_CONTEXT'
,p_message_language=>'it'
,p_message_text=>'Riga %0, colonna %1.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279183374548868628)
,p_name=>'APEX.GV.ROW_CONTEXT'
,p_message_language=>'it'
,p_message_text=>'Riga %0.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279142623833868602)
,p_name=>'APEX.GV.ROW_DELETED'
,p_message_language=>'it'
,p_message_text=>'Eliminato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278474889531868178)
,p_name=>'APEX.GV.ROW_HEADER'
,p_message_language=>'it'
,p_message_text=>'Intestazione riga'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278431700729868151)
,p_name=>'APEX.GV.SELECTION_CELL_COUNT'
,p_message_language=>'it'
,p_message_text=>'%0 celle selezionate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278433027354868151)
,p_name=>'APEX.GV.SELECTION_COUNT'
,p_message_language=>'it'
,p_message_text=>'%0 righe selezionate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278778499932868370)
,p_name=>'APEX.GV.SELECT_ALL'
,p_message_language=>'it'
,p_message_text=>'Seleziona tutto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278554060718868228)
,p_name=>'APEX.GV.SELECT_PAGE_N'
,p_message_language=>'it'
,p_message_text=>'Pagina %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278474795457868178)
,p_name=>'APEX.GV.SELECT_ROW'
,p_message_language=>'it'
,p_message_text=>'Seleziona riga'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278477340610868179)
,p_name=>'APEX.GV.SORTED_ASCENDING'
,p_message_language=>'it'
,p_message_text=>'Con ordinamento crescente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278477401668868179)
,p_name=>'APEX.GV.SORTED_DESCENDING'
,p_message_language=>'it'
,p_message_text=>'Con ordinamento decrescente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278431947225868151)
,p_name=>'APEX.GV.SORT_ASCENDING'
,p_message_language=>'it'
,p_message_text=>'Ordinamento crescente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278432218797868151)
,p_name=>'APEX.GV.SORT_ASCENDING_ORDER'
,p_message_language=>'it'
,p_message_text=>'Ordinamento crescente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278432024171868151)
,p_name=>'APEX.GV.SORT_DESCENDING'
,p_message_language=>'it'
,p_message_text=>'Ordinamento decrescente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278432318956868151)
,p_name=>'APEX.GV.SORT_DESCENDING_ORDER'
,p_message_language=>'it'
,p_message_text=>'Ordinamento decrescente %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278432147034868151)
,p_name=>'APEX.GV.SORT_OFF'
,p_message_language=>'it'
,p_message_text=>'Non ordinare'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278553836799868228)
,p_name=>'APEX.GV.TOTAL_PAGES'
,p_message_language=>'it'
,p_message_text=>'Totale %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279117116897868586)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_language=>'it'
,p_message_text=>'Visualizza documentazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279136663781868598)
,p_name=>'APEX.ICON_LIST.GRID_DIM'
,p_message_language=>'it'
,p_message_text=>'Lista di selezione griglia: %0 colonne %1 righe. Utilizzare i tasti freccia'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278552916494868227)
,p_name=>'APEX.ICON_LIST.LIST_DIM'
,p_message_language=>'it'
,p_message_text=>'Lista di selezione: %0 righe. Utilizzare i tasti freccia'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279183094941868628)
,p_name=>'APEX.IG.ACC_LABEL'
,p_message_language=>'it'
,p_message_text=>'Griglia interattiva %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278415115319868140)
,p_name=>'APEX.IG.ACTIONS'
,p_message_language=>'it'
,p_message_text=>'Azioni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278416190819868141)
,p_name=>'APEX.IG.ADD'
,p_message_language=>'it'
,p_message_text=>'Aggiungi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278416056091868141)
,p_name=>'APEX.IG.ADD_ROW'
,p_message_language=>'it'
,p_message_text=>'Aggiungi riga'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279150743845868607)
,p_name=>'APEX.IG.AGGREGATE'
,p_message_language=>'it'
,p_message_text=>'Aggrega'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279113656399868584)
,p_name=>'APEX.IG.AGGREGATION'
,p_message_language=>'it'
,p_message_text=>'Aggregazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279116636530868586)
,p_name=>'APEX.IG.ALL'
,p_message_language=>'it'
,p_message_text=>'Tutto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278673848351868304)
,p_name=>'APEX.IG.ALL_TEXT_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Tutte le colonne di testo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278675043197868305)
,p_name=>'APEX.IG.ALTERNATIVE'
,p_message_language=>'it'
,p_message_text=>'Alternativo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278676168302868305)
,p_name=>'APEX.IG.AND'
,p_message_language=>'it'
,p_message_text=>'e'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279022187997868525)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT'
,p_message_language=>'it'
,p_message_text=>'Conteggio distinti appross.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279151793699868608)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT_OVERALL'
,p_message_language=>'it'
,p_message_text=>'Conteggio distinti appross. globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279109719226868581)
,p_name=>'APEX.IG.AREA'
,p_message_language=>'it'
,p_message_text=>'Ad aree'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279115246063868585)
,p_name=>'APEX.IG.ASCENDING'
,p_message_language=>'it'
,p_message_text=>'Crescente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278675163238868305)
,p_name=>'APEX.IG.AUTHORIZATION'
,p_message_language=>'it'
,p_message_text=>'Autorizzazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279150844252868607)
,p_name=>'APEX.IG.AUTO'
,p_message_language=>'it'
,p_message_text=>'Automatico'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279022556537868525)
,p_name=>'APEX.IG.AVG'
,p_message_language=>'it'
,p_message_text=>'Media'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279151462360868608)
,p_name=>'APEX.IG.AVG_OVERALL'
,p_message_language=>'it'
,p_message_text=>'Media globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279109230146868581)
,p_name=>'APEX.IG.AXIS_LABEL_TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo asse etichetta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279109447434868581)
,p_name=>'APEX.IG.AXIS_VALUE_DECIMAL'
,p_message_language=>'it'
,p_message_text=>'Posizioni decimali'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279109338354868581)
,p_name=>'APEX.IG.AXIS_VALUE_TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo asse valori'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279123455168868590)
,p_name=>'APEX.IG.BACKGROUND_COLOR'
,p_message_language=>'it'
,p_message_text=>'Colore sfondo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279109893536868581)
,p_name=>'APEX.IG.BAR'
,p_message_language=>'it'
,p_message_text=>'A barre'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278657543432868294)
,p_name=>'APEX.IG.BETWEEN'
,p_message_language=>'it'
,p_message_text=>'tra'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279125194012868591)
,p_name=>'APEX.IG.BOTH'
,p_message_language=>'it'
,p_message_text=>'Entrambi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279109981175868581)
,p_name=>'APEX.IG.BUBBLE'
,p_message_language=>'it'
,p_message_text=>'A bolle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278416309128868141)
,p_name=>'APEX.IG.CANCEL'
,p_message_language=>'it'
,p_message_text=>'Annulla'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278676048139868305)
,p_name=>'APEX.IG.CASE_SENSITIVE'
,p_message_language=>'it'
,p_message_text=>'Con distinzione tra maiuscole e minuscole'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279152308321868608)
,p_name=>'APEX.IG.CASE_SENSITIVE_WITH_BRACKETS'
,p_message_language=>'it'
,p_message_text=>'(Con distinzione tra maiuscole e minuscole)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279061831776868551)
,p_name=>'APEX.IG.CHANGES_SAVED'
,p_message_language=>'it'
,p_message_text=>'Modifiche salvate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278416792845868141)
,p_name=>'APEX.IG.CHANGE_VIEW'
,p_message_language=>'it'
,p_message_text=>'Modifica vista'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278677192615868306)
,p_name=>'APEX.IG.CHART'
,p_message_language=>'it'
,p_message_text=>'Grafico'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278672524048868303)
,p_name=>'APEX.IG.CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'it'
,p_message_text=>'La query supera il numero massimo di %0 datapoint per grafico. Applicare un filtro per ridurre il numero di record nella query di base.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278415060354868140)
,p_name=>'APEX.IG.CHART_VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista grafico'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278478324568868180)
,p_name=>'APEX.IG.CLEAR'
,p_message_language=>'it'
,p_message_text=>'Cancella'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279108770027868580)
,p_name=>'APEX.IG.CLOSE_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Chiusura'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279124131233868590)
,p_name=>'APEX.IG.COLORS'
,p_message_language=>'it'
,p_message_text=>'Colori'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279124063020868590)
,p_name=>'APEX.IG.COLOR_BLUE'
,p_message_language=>'it'
,p_message_text=>'Blu'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279123926794868590)
,p_name=>'APEX.IG.COLOR_GREEN'
,p_message_language=>'it'
,p_message_text=>'Verde'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279123774292868590)
,p_name=>'APEX.IG.COLOR_ORANGE'
,p_message_language=>'it'
,p_message_text=>'Arancione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279123858695868590)
,p_name=>'APEX.IG.COLOR_RED'
,p_message_language=>'it'
,p_message_text=>'Rosso'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279123661426868590)
,p_name=>'APEX.IG.COLOR_YELLOW'
,p_message_language=>'it'
,p_message_text=>'Giallo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278675410449868305)
,p_name=>'APEX.IG.COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278415245611868140)
,p_name=>'APEX.IG.COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279128916342868593)
,p_name=>'APEX.IG.COLUMN_TYPE'
,p_message_language=>'it'
,p_message_text=>'Scopo colonna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278675572364868305)
,p_name=>'APEX.IG.COMPLEX'
,p_message_language=>'it'
,p_message_text=>'Complesso'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278415435511868140)
,p_name=>'APEX.IG.COMPUTE'
,p_message_language=>'it'
,p_message_text=>'Calcola'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278658132015868294)
,p_name=>'APEX.IG.CONTAINS'
,p_message_language=>'it'
,p_message_text=>'contiene'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278681419134868309)
,p_name=>'APEX.IG.CONTROL_BREAK'
,p_message_language=>'it'
,p_message_text=>'Interruzione di controllo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278478177674868180)
,p_name=>'APEX.IG.COPY_CB'
,p_message_language=>'it'
,p_message_text=>'Copia negli Appunti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278478295240868180)
,p_name=>'APEX.IG.COPY_DOWN'
,p_message_language=>'it'
,p_message_text=>'Copia in basso'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279021909342868525)
,p_name=>'APEX.IG.COUNT'
,p_message_language=>'it'
,p_message_text=>'Conteggio'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279022093672868525)
,p_name=>'APEX.IG.COUNT_DISTINCT'
,p_message_language=>'it'
,p_message_text=>'Conteggio distinti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279151619977868608)
,p_name=>'APEX.IG.COUNT_DISTINCT_OVERALL'
,p_message_language=>'it'
,p_message_text=>'Conteggio distinti globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279151549618868608)
,p_name=>'APEX.IG.COUNT_OVERALL'
,p_message_language=>'it'
,p_message_text=>'Conteggio globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279143063752868602)
,p_name=>'APEX.IG.CREATE_X'
,p_message_language=>'it'
,p_message_text=>'Crea %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278674034796868304)
,p_name=>'APEX.IG.DATA'
,p_message_language=>'it'
,p_message_text=>'Dati'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279126373342868592)
,p_name=>'APEX.IG.DATA_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo dati'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279125319990868591)
,p_name=>'APEX.IG.DATE'
,p_message_language=>'it'
,p_message_text=>'Data'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279061672790868551)
,p_name=>'APEX.IG.DATE_INVALID_VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore della data non valido'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278659008717868294)
,p_name=>'APEX.IG.DAYS'
,p_message_language=>'it'
,p_message_text=>'giorni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278674746104868304)
,p_name=>'APEX.IG.DEFAULT_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni predefinite'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278674529123868304)
,p_name=>'APEX.IG.DEFAULT_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo predefinito'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278416232487868141)
,p_name=>'APEX.IG.DELETE'
,p_message_language=>'it'
,p_message_text=>'Elimina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279129944311868594)
,p_name=>'APEX.IG.DELETE_REPORT_CONFIRM'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 certi di voler eliminare questo report?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278683209876868310)
,p_name=>'APEX.IG.DELETE_ROW'
,p_message_language=>'it'
,p_message_text=>'Elimina riga'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278682089685868309)
,p_name=>'APEX.IG.DELETE_ROWS'
,p_message_language=>'it'
,p_message_text=>'Elimina righe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279115399230868585)
,p_name=>'APEX.IG.DESCENDING'
,p_message_language=>'it'
,p_message_text=>'Decrescente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278676843099868306)
,p_name=>'APEX.IG.DETAIL'
,p_message_language=>'it'
,p_message_text=>'Dettaglio'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278414747070868140)
,p_name=>'APEX.IG.DETAIL_VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista dei dettagli'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279077515427868561)
,p_name=>'APEX.IG.DIRECTION'
,p_message_language=>'it'
,p_message_text=>'Direzione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278676577462868306)
,p_name=>'APEX.IG.DISABLED'
,p_message_language=>'it'
,p_message_text=>'Disabilitato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278658222113868294)
,p_name=>'APEX.IG.DOES_NOT_CONTAIN'
,p_message_language=>'it'
,p_message_text=>'non contiene'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278658468997868294)
,p_name=>'APEX.IG.DOES_NOT_START_WITH'
,p_message_language=>'it'
,p_message_text=>'non inizia con'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279110054644868581)
,p_name=>'APEX.IG.DONUT'
,p_message_language=>'it'
,p_message_text=>'Ciambella'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278681635302868309)
,p_name=>'APEX.IG.DOWNLOAD'
,p_message_language=>'it'
,p_message_text=>'Scarica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279130978908868595)
,p_name=>'APEX.IG.DOWNLOAD_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Scegliere un formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279116269705868585)
,p_name=>'APEX.IG.DUPLICATE_AGGREGATION'
,p_message_language=>'it'
,p_message_text=>'Aggregazione duplicata'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279116324862868585)
,p_name=>'APEX.IG.DUPLICATE_CONTROLBREAK'
,p_message_language=>'it'
,p_message_text=>'Interruzione di controllo duplicata'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278683159305868310)
,p_name=>'APEX.IG.DUPLICATE_ROW'
,p_message_language=>'it'
,p_message_text=>'Duplica riga'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278681916629868309)
,p_name=>'APEX.IG.DUPLICATE_ROWS'
,p_message_language=>'it'
,p_message_text=>'Duplica righe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278415816454868141)
,p_name=>'APEX.IG.EDIT'
,p_message_language=>'it'
,p_message_text=>'Modifica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279114763332868584)
,p_name=>'APEX.IG.EDIT_CHART'
,p_message_language=>'it'
,p_message_text=>'Modifica grafico'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279138751349868600)
,p_name=>'APEX.IG.EDIT_GROUP_BY'
,p_message_language=>'it'
,p_message_text=>'Modifica raggruppamento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279130545016868594)
,p_name=>'APEX.IG.EMAIL_BCC'
,p_message_language=>'it'
,p_message_text=>'Copia nascosta (Ccn)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279130790458868594)
,p_name=>'APEX.IG.EMAIL_BODY'
,p_message_language=>'it'
,p_message_text=>'Messaggio'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279130459956868594)
,p_name=>'APEX.IG.EMAIL_CC'
,p_message_language=>'it'
,p_message_text=>'Copia (Cc)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279130191866868594)
,p_name=>'APEX.IG.EMAIL_SENT'
,p_message_language=>'it'
,p_message_text=>'Posta elettronica inviata.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279130656948868594)
,p_name=>'APEX.IG.EMAIL_SUBJECT'
,p_message_language=>'it'
,p_message_text=>'Oggetto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279130327839868594)
,p_name=>'APEX.IG.EMAIL_TO'
,p_message_language=>'it'
,p_message_text=>'Destinatario (A)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278676248421868305)
,p_name=>'APEX.IG.ENABLED'
,p_message_language=>'it'
,p_message_text=>'Abilitato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278656522159868293)
,p_name=>'APEX.IG.EQUALS'
,p_message_language=>'it'
,p_message_text=>'uguale a'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279129518996868594)
,p_name=>'APEX.IG.EXAMPLE'
,p_message_language=>'it'
,p_message_text=>'Esempio'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278676301192868305)
,p_name=>'APEX.IG.EXPRESSION'
,p_message_language=>'it'
,p_message_text=>'Espressione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279129484100868594)
,p_name=>'APEX.IG.FD_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278778330227868370)
,p_name=>'APEX.IG.FILE_PREPARED'
,p_message_language=>'it'
,p_message_text=>'File preparato. Avvio del download in corso.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278478426051868180)
,p_name=>'APEX.IG.FILL'
,p_message_language=>'it'
,p_message_text=>'Riempimento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278499832396868194)
,p_name=>'APEX.IG.FILL_LABEL'
,p_message_language=>'it'
,p_message_text=>'Riempi selezione con'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278499761169868194)
,p_name=>'APEX.IG.FILL_TITLE'
,p_message_language=>'it'
,p_message_text=>'Riempi selezione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278415352250868140)
,p_name=>'APEX.IG.FILTER'
,p_message_language=>'it'
,p_message_text=>'Filtra'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278675604495868305)
,p_name=>'APEX.IG.FILTERS'
,p_message_language=>'it'
,p_message_text=>'Filtri'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279151197098868607)
,p_name=>'APEX.IG.FILTER_WITH_DOTS'
,p_message_language=>'it'
,p_message_text=>'Filtra...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279115567004868585)
,p_name=>'APEX.IG.FIRST'
,p_message_language=>'it'
,p_message_text=>'Primo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278415502659868140)
,p_name=>'APEX.IG.FLASHBACK'
,p_message_language=>'it'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278674114138868304)
,p_name=>'APEX.IG.FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279125041788868591)
,p_name=>'APEX.IG.FORMATMASK'
,p_message_language=>'it'
,p_message_text=>'Formato di visualizzazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279129835323868594)
,p_name=>'APEX.IG.FORMAT_CSV'
,p_message_language=>'it'
,p_message_text=>'CSV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279129734459868594)
,p_name=>'APEX.IG.FORMAT_HTML'
,p_message_language=>'it'
,p_message_text=>'HTML'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278682809932868309)
,p_name=>'APEX.IG.FREEZE'
,p_message_language=>'it'
,p_message_text=>'Blocca'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278676478949868305)
,p_name=>'APEX.IG.FUNCTIONS_AND_OPERATORS'
,p_message_language=>'it'
,p_message_text=>'Funzioni e operatori'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279110196719868581)
,p_name=>'APEX.IG.FUNNEL'
,p_message_language=>'it'
,p_message_text=>'A imbuto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279021869845868525)
,p_name=>'APEX.IG.GO'
,p_message_language=>'it'
,p_message_text=>'Vai'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278657130556868293)
,p_name=>'APEX.IG.GREATER_THAN'
,p_message_language=>'it'
,p_message_text=>'maggiore di'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278657200197868293)
,p_name=>'APEX.IG.GREATER_THAN_OR_EQUALS'
,p_message_language=>'it'
,p_message_text=>'maggiore o uguale a'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278676719336868306)
,p_name=>'APEX.IG.GRID'
,p_message_language=>'it'
,p_message_text=>'Griglia'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278414534012868140)
,p_name=>'APEX.IG.GRID_VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista griglia'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279116557695868585)
,p_name=>'APEX.IG.GROUP'
,p_message_language=>'it'
,p_message_text=>'Gruppo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278676909571868306)
,p_name=>'APEX.IG.GROUP_BY'
,p_message_language=>'it'
,p_message_text=>'Raggruppa per'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278414814994868140)
,p_name=>'APEX.IG.GROUP_BY_VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista Raggruppa per'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279125649783868591)
,p_name=>'APEX.IG.HD_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di condizione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279124511918868591)
,p_name=>'APEX.IG.HEADING'
,p_message_language=>'it'
,p_message_text=>'Intestazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279124798737868591)
,p_name=>'APEX.IG.HEADING_ALIGN'
,p_message_language=>'it'
,p_message_text=>'Allineamento intestazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279151035336868607)
,p_name=>'APEX.IG.HELP'
,p_message_language=>'it'
,p_message_text=>'Guida'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279136878991868598)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\00C8 possibile inserire, aggiornare ed eliminare i dati direttamente all''interno di questa griglia interattiva.</p>'),
'',
'<p>Per inserire una nuova riga, fare clic sul pulsante Aggiungi riga.</p>',
'',
unistr('<p>Per modificare i dati esistenti, fare doppio clic su una cella specifica. Per interventi di modifica pi\00F9 ampi, fare clic su Modifica per attivare la modalit\00E0 di modifica. Nella modalit\00E0 di modifica \00E8 possibile fare clic una sola volta oppure usare')
||' la tastiera per modificare le celle specifiche.</p>',
'',
unistr('<p>Usare il menu Modifica per duplicare e eliminare le righe. Per abilitare il menu Modifica, usare le caselle di controllo per selezionare una o pi\00F9 righe.</p>'),
'',
'<p>Per duplicare una riga selezionata, fare clic sul menu Modifica e selezionare Duplica righe. Per eliminare una riga selezionata, fare clic sul menu Modifica e selezionare Elimina riga.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279139234787868600)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING_HEADING'
,p_message_language=>'it'
,p_message_text=>unistr('Capacit\00E0 di modifica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279139378997868600)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Una griglia interattiva presenta un set di dati in un report abilitato per le ricerche e personalizzabile. \00C8 possibile eseguire varie operazioni per limitare il numero dei record restituiti e modificare le modalit\00E0 di visualizzazione dei dati.</p>'),
'',
'<p>Usare il campo Cerca per filtrare i record restituiti. Fare clic su Azioni per accedere a varie opzioni per la modifica del layout del report oppure usare i menu Intestazione colonna nelle colonne visualizzate.</p>',
'',
unistr('<p>Usare Impostazioni report per salvare le personalizzazioni apportate a un report. \00C8 inoltre possibile scaricare i dati dal report in un file esterno oppure inviare i dati mediante posta elettronica a se stessi o ad altre persone.</p>'),
'',
'<p>Per ulteriori informazioni, vedere "Uso delle griglie interattive" in <em>Guida per l''utente finale di Oracle Application Express</em>.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279139068486868600)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO_HEADING'
,p_message_language=>'it'
,p_message_text=>'Panoramica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279136753844868598)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\00C8 possibile personalizzare la griglia interattiva per visualizzare i dati in vari modi diversi mediante le capacit\00E0 incorporate disponibili.</p>'),
'',
unistr('<p>Usare i menu Intestazione colonna o i menu Azione per determinare le colonne da visualizzare, scegliere la sequenza di visualizzazione e bloccare le colonne. \00C8 inoltre possibile definire vari filtri di dati e ordinare i dati restituiti.</p>'),
'',
unistr('<p>Usare il pulsante Visualizza, situato accanto al campo di ricerca, per accedere alle eventuali altre viste dati definite dallo sviluppatore dell''applicazione. \00C8 inoltre possibile creare un grafico o visualizzare un grafico esistente.</p> '),
'',
unistr('<p><em>Nota: per ottenere informazioni pi\00F9 dettagliate sulla funzione selezionata, fare clic su <strong>?</strong> nelle finestre di dialogo della griglia interattiva.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279139153739868600)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING_HEADING'
,p_message_language=>'it'
,p_message_text=>unistr('Capacit\00E0 di report')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278681891512868309)
,p_name=>'APEX.IG.HELP.ACTIONS_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida della griglia interattiva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279133712412868596)
,p_name=>'APEX.IG.HELP.AGGREGATE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questa finestra di dialogo per aggregare le colonne. I valori aggregati vengono visualizzati sotto i dati oppure, se sono state definite le interruzioni di controllo, sotto ogni interruzione.</p>',
'',
'<p><strong>Lista Aggregazione</strong><br>',
'Nella lista Aggregazione vengono visualizzate le aggregazioni definite. Per disabilitare un''aggregazione esistente, deselezionarla.<br>',
'Fare clic su Aggiungi ( &plus; ) per creare una nuova aggregazione oppure su Elimina ( &minus; ) per rimuovere un''aggregazione esistente.</p>',
'',
'<p><strong>Impostazioni di aggregazione</strong><br>',
'Usare il form a destra per definire l''aggregazione.<br>',
'Selezionare il nome della colonna e il tipo di aggregazione.<br>',
'Se necessario, immettere una descrizione comandi per l''aggregazione.<br>',
unistr('Se \00E8 stata definita un''interruzione di controllo, la selezione di <strong>Mostra valore globale</strong> comporta la visualizzazione della media complessiva, del totale o di un altro valore simile sotto i dati.</p>'),
'',
'<p><em>Nota: per accedere alla finestra di dialogo Aggregazione, utilizzare il menu Azioni oppure fare clic sull''intestazione e sulla somma ( &sum; ) della colonna.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279138191118868599)
,p_name=>'APEX.IG.HELP.AGGREGATE_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Aggregazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279134476122868597)
,p_name=>'APEX.IG.HELP.CHART'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questa finestra di dialogo per definire un grafico da visualizzare come vista dati distinta.<br> ',
'Selezionare un tipo di grafico, configurare le impostazioni del grafico e fare clic su <strong>Salva.</strong></p>',
'',
'<p><strong>Impostazioni del grafico</strong></br>',
unistr('Gli attributi del grafico variano a seconda del tipo di grafico selezionato. Per definire il grafico \00E8 possibile immettere numerosi attributi. Gli attributi contrassegnati con un asterisco di colore rosso sono obbligatori.</p>'),
'',
'<p>Di seguito sono riportati tutti gli attributi disponibili per i vari tipi di grafico.',
'<ul>',
unistr('  <li>Aggregazione: selezionare le modalit\00E0 di aggregazione dei valori di grafico associati.</li> '),
'  <li>Chiusura: selezionare la colonna che contiene il prezzo di chiusura giornaliero delle azioni (solo per il grafico Borsistico).</li> ',
'  <li>Posizioni decimali: immettere il numero di posizioni decimali alle quali vengono arrotondati i valori.</li> ',
'  <li>Direzione (correlato all''attributo Ordina per): specificare se i dati devono essere ordinati in ordine crescente o decrescente.</li> ',
'  <li>Valore massimo: selezionare la colonna che contiene il valore massimo (solo per i grafici Intervallo e Borsistico).</li> ',
'  <li>Etichetta: selezionare la colonna che contiene il testo per ogni datapoint.</li> ',
unistr('  <li>Titolo asse etichetta: immettere il titolo che verr\00E0 visualizzato sull''asse dell''etichetta.</li> '),
'  <li>Valore minimo: selezionare la colonna che contiene il valore minimo (solo per i grafici Intervallo e Borsistico).</li> ',
unistr('  <li>Valori nulli (correlato all''attributo Ordina per): specificare le modalit\00E0 di ordinamento dei record con valori nulli rispetto ai record con valori non nulli.</li> '),
'  <li>Apertura: selezionare la colonna che contiene il prezzo di apertura giornaliero delle azioni (solo per il grafico Borsistico).</li> ',
'  <li>Orientamento: selezionare se gli elementi del grafico, ad esempio le barre, devono essere visualizzati verticalmente o orizzontalmente.</li> ',
unistr('  <li>Serie: selezionare la colonna da utilizzare per la definizione della query dinamica a pi\00F9 serie.</li> '),
'  <li>In pila: specificare se gli elementi dati vengono visualizzati in pila.</li> ',
unistr('  <li>Ordina per: indicare se il grafico viene ordinato in base all''etichetta o a uno o pi\00F9 valori.</li> '),
unistr('  <li>Destinazione: selezionare la colonna da utilizzare per la definizione del valore di destinazione in questo grafico. Quando \00E8 impostato, l''attributo Valore definisce l''area riempita all''interno della porzione e la destinazione rappresenta il val')
||'ore dell''intera porzione (solo per il grafico A imbuto).</li> ',
'  <li>Valore: selezionare la colonna che contiene i dati da rappresentare.</li> ',
unistr('  <li>Titolo asse valori: immettere il titolo che verr\00E0 visualizzato sull''asse dei valori.</li> '),
'  <li>Volume: selezionare la colonna che contiene il volume di azioni giornaliero (solo per il grafico Borsistico).</li> ',
'  <li>X: selezionare la colonna che contiene il valore dell''asse X per questo grafico (solo per i grafici A bolle e A dispersione).</li> ',
'  <li>Y: selezionare la colonna che contiene il valore dell''asse Y per questo grafico (solo per i grafici A bolle e A dispersione).</li> ',
'  <li>Z: selezionare la colonna che contiene la larghezza delle barre o il raggio delle bolle (solo per i grafici A barre, A bolle e Intervallo).</li> ',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279138598753868599)
,p_name=>'APEX.IG.HELP.CHART_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Grafico'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279133481008868596)
,p_name=>'APEX.IG.HELP.COLUMNS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questa finestra di dialogo per scegliere le colonne da visualizzare e l''ordine di visualizzazione delle colonne.</p>',
'',
'<p>Per nascondere una colonna, deselezionarla.<br>',
'Per riordinare le colonne, fare clic su Sposta in alto ( &uarr; ) o su Sposta in basso ( &darr; ).<br>',
'Usare il selettore a discesa per elencare tutte le colonne, le colonne visualizzate o le colonne non visualizzate.</p>',
'',
'<p>Facoltativamente, usare il form per specificare la larghezza minima di una colonna in pixel.</p>',
'',
unistr('<p><em>Nota: \00E8 possibile riordinare le colonne visualizzate anche facendo clic sul quadratino di trascinamento (all''inizio dell''intestazione della colonna) e trascinando la colonna a sinistra o a destra. \00C8 possibile modificare la larghezza delle colo')
||'nne visualizzate anche selezionando il separatore delle colonne, tra le intestazioni, e spostandolo a sinistra o a destra.</em</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279138414186868599)
,p_name=>'APEX.IG.HELP.COLUMNS_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida sulle colonne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279133846180868596)
,p_name=>'APEX.IG.HELP.COMPUTE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questa finestra di dialogo per definire colonne aggiuntive in base ai calcoli matematici e funzionali eseguiti sulle colonne esistenti.</p>',
'',
'<p><strong>Lista Calcolo</strong><br>',
'Nella lista Calcolo vengono visualizzati i calcoli definiti. Per disabilitare un calcolo esistente, deselezionarlo.<br>',
'Fare clic su Aggiungi ( &plus; ) per aggiungere un nuovo calcolo oppure su Elimina ( &minus; ) per rimuovere un calcolo esistente.</p>',
'',
'<p><strong>Impostazioni di calcolo</strong><br>',
'Usare il form per definire il calcolo.<br>',
'Immettere i dettagli di colonna, ovvero l''intestazione e l''etichetta, quindi selezionare le impostazioni di allineamento.<br> ',
'Usare l''area di testo Espressione per immettere la colonna o le colonne e le funzioni associate per il calcolo.<br>',
'Selezionare il tipo di dati appropriato e, facoltativamente, un formato di visualizzazione, per la nuova colonna.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279138058145868599)
,p_name=>'APEX.IG.HELP.COMPUTE_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Calcola'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279134180667868597)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Usare questa finestra di dialogo per definire un''interruzione di controllo in una o pi\00F9 colonne.</p>'),
'',
'<p><strong>Lista Interruzione di controllo</strong><br>',
'Nella lista Interruzione di controllo vengono visualizzate le interruzioni di controllo definite. Per disabilitare una colonna di interruzione di controllo esistente, deselezionarla.<br>',
'Fare clic su Aggiungi ( &plus; ) per includere una nuova colonna nell''interruzione di controllo oppure su Elimina ( &minus; ) per rimuovere una colonna esistente dall''interruzione di controllo.<br>',
'Per riordinare le colonne, fare clic su Sposta in alto ( &uarr; ) o su Sposta in basso ( &darr; ) per spostare la colonna selezionata verso l''alto o verso il basso rispetto alle altre colonne.</p>',
'',
'<p><strong>Impostazioni di interruzione di controllo</strong><br>',
'Usare il form per definire la colonna dell''interruzione di controllo.<br>',
unistr('Selezionare una colonna di interruzione di controllo, la direzione dell''ordinamento e le modalit\00E0 di ordinamento delle colonne nulle (le colonne prive di valori).</p>'),
'',
unistr('<p><em>Nota: durante la visualizzazione della griglia interattiva, \00E8 possibile definire un''interruzione di controllo facendo clic sull''intestazione di una colonna e selezionando l''icona Interruzione di controllo.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279137757222868599)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Interruzione di controllo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279134379203868597)
,p_name=>'APEX.IG.HELP.DOWNLOAD'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Usare questa finestra di dialogo per scaricare tutte le righe correnti in un file esterno. Il file conterr\00E0 solo le colonne visualizzate al momento in base ai filtri e all''ordinamento applicati ai dati.</p>'),
'',
'<p>Selezionare il formato del file e fare clic su Scarica.<br>',
'Nota: con il formato CSV i dettagli di formattazione del testo, quali le aggregazioni e le interruzioni di controllo, non vengono inclusi.</p>',
'',
'<p>Per inviare il file tramite posta elettronica, selezionare Invia come posta elettronica e immettere i dettagli dell''invio (Destinatario, Oggetto e Messaggio).</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279137563514868599)
,p_name=>'APEX.IG.HELP.DOWNLOAD_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Scarica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279133522579868596)
,p_name=>'APEX.IG.HELP.FILTER'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questa finestra di dialogo per configurare i filtri dei dati che limitano il numero delle righe restituite.</p>',
'',
'<p><strong>Lista Filtro</strong><br>',
'La lista Filtro contiene i filtri definiti. Per disabilitare un filtro esistente, deselezionarlo.<br>',
'Fare clic su Aggiungi ( &plus; ) per creare un nuovo filtro o su Elimina ( &minus; ) per rimuovere un filtro esistente.</p>',
'',
'<p><strong>Impostazioni di filtro</strong><br>',
unistr('Usare il form per definire le propriet\00E0 del filtro.<br>'),
'Selezionare il tipo di filtro appropriato:<br>',
'&nbsp;&nbsp;&nbsp;Riga: filtro per un termine in qualsiasi colonna filtrabile.<br>',
'&nbsp;&nbsp;&nbsp;Colonna: filtra una colonna specifica con l''operatore e il valore specificati.</p>',
'',
unistr('<p><em>Nota: durante la visualizzazione della griglia interattiva, \00E8 possibile definire i filtri Riga digitando direttamente nel campo di ricerca. Fare clic su Selezionare le colonne in cui cercare per limitare la ricerca a una colonna specifica. In ')
||'alternativa, aprire un menu Intestazione colonna e selezionare un valore per creare un filtro Colonna.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279138365789868599)
,p_name=>'APEX.IG.HELP.FILTER_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Filtra'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279133936930868596)
,p_name=>'APEX.IG.HELP.FLASHBACK'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Usare questa finestra di dialogo per visualizzare i dati cos\00EC come si presentavano in un point-in-time precedente.</p>'),
'<p>Immettere il numero di minuti nel passato per eseguire la funzione Flashback query.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279137991675868599)
,p_name=>'APEX.IG.HELP.FLASHBACK_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279138637539868599)
,p_name=>'APEX.IG.HELP.GROUP_BY_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Raggruppa per'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279134029637868597)
,p_name=>'APEX.IG.HELP.HIGHLIGHT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questa finestra di dialogo per evidenziare le righe o le colonne di dati in base alla condizione immessa.</p>',
'',
'<p><strong>Lista Evidenzia</strong><br>',
'Nella lista Evidenzia vengono visualizzate le evidenziazioni definite. Per disabilitare un''evidenziazione esistente, deselezionarla.<br>',
'Fare clic su Aggiungi ( &plus; ) per creare una nuova evidenziazione oppure su Elimina ( &minus; ) per rimuovere un''evidenziazione esistente.</p>',
'',
'<p><strong>Impostazioni di evidenziazione</strong><br>',
unistr('Usare il form per definire le propriet\00E0 di evidenziazione.<br>'),
'Immettere il nome, selezionare Riga o Colonna, quindi selezionare i codici di colore HTML per lo sfondo e il testo.<br>',
'Selezionare il <strong>tipo di condizione</strong> appropriato per evidenziare dati specifici:<br>',
'&nbsp;&nbsp;&nbsp;Riga: evidenzia un termine in qualsiasi colonna.<br>',
'&nbsp;&nbsp;&nbsp;Colonna: applica l''evidenziazione in una colonna specifica in base all''operatore e valore specificati.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279137802203868599)
,p_name=>'APEX.IG.HELP.HIGHLIGHT_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Evidenzia'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279134207325868597)
,p_name=>'APEX.IG.HELP.REPORT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questa finestra di dialogo per salvare le modifiche apportate al layout e alla configurazione della griglia corrente.<br>',
unistr('Gli sviluppatori di applicazioni possono definire pi\00F9 layout di report alternativi. Laddove si \00E8 autorizzati a farlo, \00E8 possibile salvare un report come Pubblico, ovvero renderlo disponibile per tutti gli altri utenti della griglia. \00C8 inoltre possibi')
||unistr('le salvare un report come Privato, in modo da essere l''unica persona che potr\00E0 visualizzarne il contenuto.</p>'),
'<p>Effettuare la selezione nei tipi disponibili e immettere un nome per il report salvato.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279137693340868599)
,p_name=>'APEX.IG.HELP.REPORT_TITLE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Guida di Report',
''))
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279133664969868596)
,p_name=>'APEX.IG.HELP.SORT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questa finestra di dialogo per impostare l''ordine di visualizzazione.</p>',
'',
'<p><strong>Lista Ordina</strong><br>',
'La finestra di dialogo Ordina visualizza la lista delle regole di ordinamento configurate.<br>',
'Fare clic su Aggiungi ( &plus; ) per creare una colonna di ordinamento oppure su Elimina ( &minus; ) per rimuovere una colonna di ordinamento.<br>',
'Fare clic su Sposta in alto ( &uarr; ) e su Sposta in basso ( &darr; ) per spostare la colonna di ordinamento selezionata verso l''alto e verso il basso rispetto alle altre colonne di ordinamento.</p>',
'',
'<p><strong>Impostazioni di ordinamento</strong><br>',
unistr('Selezionare una colonna di ordinamento, la direzione dell''ordinamento e le modalit\00E0 di ordinamento delle colonne nulle (le colonne prive di valori).</p>'),
'',
'<p><em>Nota: i dati possono essere ordinati in base a colonne non visualizzate, ma non tutte le colonne sono ordinabili.</em><br>',
unistr('<em>Le colonne visualizzate possono essere ordinate facendo clic sulla freccia su (ordine crescente) o sulla freccia gi\00F9 (ordine decrescente) alla fine delle intestazioni delle colonne. Per aggiungere un''ulteriore colonna a un ordinamento esistente, ')
||unistr('tenere premuto il tasto Maiusc e premere Freccia SU o Freccia GI\00D9.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279138212927868599)
,p_name=>'APEX.IG.HELP.SORT_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Ordina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279137445186868599)
,p_name=>'APEX.IG.HELP.SUBSCRIPTION_TITLE'
,p_message_language=>'it'
,p_message_text=>'Guida di Sottoscrizione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278682799334868309)
,p_name=>'APEX.IG.HIDE'
,p_message_language=>'it'
,p_message_text=>'Nascondi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278415770259868141)
,p_name=>'APEX.IG.HIGHLIGHT'
,p_message_language=>'it'
,p_message_text=>'Evidenzia'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279108814551868581)
,p_name=>'APEX.IG.HIGH_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Valore massimo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279109607478868581)
,p_name=>'APEX.IG.HORIZONTAL'
,p_message_language=>'it'
,p_message_text=>'Orizzontale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278658981977868294)
,p_name=>'APEX.IG.HOURS'
,p_message_language=>'it'
,p_message_text=>'ore'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278676673967868306)
,p_name=>'APEX.IG.ICON'
,p_message_language=>'it'
,p_message_text=>'Icona'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278414696984868140)
,p_name=>'APEX.IG.ICON_VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista icone'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278656941823868293)
,p_name=>'APEX.IG.IN'
,p_message_language=>'it'
,p_message_text=>'in'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278682359538868309)
,p_name=>'APEX.IG.INACTIVE_SETTING'
,p_message_language=>'it'
,p_message_text=>'Impostazione non attiva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278682432800868309)
,p_name=>'APEX.IG.INACTIVE_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni non attive'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278729785845868339)
,p_name=>'APEX.IG.INTERNAL_ERROR'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 verificato un errore interno durante l''elaborazione della richiesta della griglia interattiva.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279136940162868598)
,p_name=>'APEX.IG.INVALID_DATE_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formato data non valido'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279147511022868605)
,p_name=>'APEX.IG.INVALID_SETTING'
,p_message_language=>'it'
,p_message_text=>'Impostazione non valida'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279147671918868605)
,p_name=>'APEX.IG.INVALID_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni non valide'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279123390820868590)
,p_name=>'APEX.IG.INVALID_SORT_BY'
,p_message_language=>'it'
,p_message_text=>unistr('L''opzione Ordina per \00E8 stata impostata su %0, ma non \00E8 stata selezionata alcuna colonna per %0.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279116447318868585)
,p_name=>'APEX.IG.INVALID_VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore non valido'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279104605191868578)
,p_name=>'APEX.IG.INVISIBLE'
,p_message_language=>'it'
,p_message_text=>'Non visualizzato'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278657708228868294)
,p_name=>'APEX.IG.IN_THE_LAST'
,p_message_language=>'it'
,p_message_text=>'negli/lle ultimi/e'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278657956117868294)
,p_name=>'APEX.IG.IN_THE_NEXT'
,p_message_language=>'it'
,p_message_text=>'nei seguenti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278656881524868293)
,p_name=>'APEX.IG.IS_NOT_NULL'
,p_message_language=>'it'
,p_message_text=>unistr('non \00E8 vuoto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278656718239868293)
,p_name=>'APEX.IG.IS_NULL'
,p_message_language=>'it'
,p_message_text=>unistr('\00E8 vuoto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279124675382868591)
,p_name=>'APEX.IG.LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279108145826868580)
,p_name=>'APEX.IG.LABEL_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Etichetta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279115635253868585)
,p_name=>'APEX.IG.LAST'
,p_message_language=>'it'
,p_message_text=>'Ultimo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278555662817868229)
,p_name=>'APEX.IG.LAST.DAY'
,p_message_language=>'it'
,p_message_text=>'Ultimo giorno'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278555846192868229)
,p_name=>'APEX.IG.LAST.HOUR'
,p_message_language=>'it'
,p_message_text=>'Ultima ora'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278556300328868229)
,p_name=>'APEX.IG.LAST.MINUTE'
,p_message_language=>'it'
,p_message_text=>'Ultimo minuto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278555306640868229)
,p_name=>'APEX.IG.LAST.MONTH'
,p_message_language=>'it'
,p_message_text=>'Mese scorso'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278555480321868229)
,p_name=>'APEX.IG.LAST.WEEK'
,p_message_language=>'it'
,p_message_text=>'Settimana scorsa'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278555505295868229)
,p_name=>'APEX.IG.LAST.X_DAYS'
,p_message_language=>'it'
,p_message_text=>'Ultimi %0 giorni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278555799180868229)
,p_name=>'APEX.IG.LAST.X_HOURS'
,p_message_language=>'it'
,p_message_text=>'Ultime %0 ore'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278556477327868229)
,p_name=>'APEX.IG.LAST.X_MINUTES'
,p_message_language=>'it'
,p_message_text=>'Ultimi %0 minuti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278556283752868229)
,p_name=>'APEX.IG.LAST.X_MONTHS'
,p_message_language=>'it'
,p_message_text=>'Ultimi %0 mesi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278556161478868229)
,p_name=>'APEX.IG.LAST.X_WEEKS'
,p_message_language=>'it'
,p_message_text=>'Ultime %0 settimane'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278555176694868229)
,p_name=>'APEX.IG.LAST.X_YEARS'
,p_message_language=>'it'
,p_message_text=>'Ultimi %0 anni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278555215086868229)
,p_name=>'APEX.IG.LAST.YEAR'
,p_message_language=>'it'
,p_message_text=>'Anno scorso'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279124847884868591)
,p_name=>'APEX.IG.LAYOUT_ALIGN'
,p_message_language=>'it'
,p_message_text=>'Allineamento cella'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279124933777868591)
,p_name=>'APEX.IG.LAYOUT_USEGROUPFOR'
,p_message_language=>'it'
,p_message_text=>'Usa gruppo per'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278657376366868293)
,p_name=>'APEX.IG.LESS_THAN'
,p_message_language=>'it'
,p_message_text=>'minore di'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278657457991868293)
,p_name=>'APEX.IG.LESS_THAN_OR_EQUALS'
,p_message_language=>'it'
,p_message_text=>'minore o uguale a'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279110232811868581)
,p_name=>'APEX.IG.LINE'
,p_message_language=>'it'
,p_message_text=>'A linee'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279110329383868581)
,p_name=>'APEX.IG.LINE_WITH_AREA'
,p_message_language=>'it'
,p_message_text=>'A linee con area'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279125234681868591)
,p_name=>'APEX.IG.LISTAGG'
,p_message_language=>'it'
,p_message_text=>'LISTAGG'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279108929599868581)
,p_name=>'APEX.IG.LOW_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Valore minimo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279130895158868594)
,p_name=>'APEX.IG.MAILADDRESSES_COMMASEP'
,p_message_language=>'it'
,p_message_text=>unistr('Separare pi\00F9 indirizzi con virgole')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278658595524868294)
,p_name=>'APEX.IG.MATCHES_REGULAR_EXPRESSION'
,p_message_language=>'it'
,p_message_text=>'corrisponde all''espressione regolare'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279022420269868525)
,p_name=>'APEX.IG.MAX'
,p_message_language=>'it'
,p_message_text=>'Massimo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279151973323868608)
,p_name=>'APEX.IG.MAX_OVERALL'
,p_message_language=>'it'
,p_message_text=>'Massimo globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279022635713868525)
,p_name=>'APEX.IG.MEDIAN'
,p_message_language=>'it'
,p_message_text=>'Mediana'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279152095430868608)
,p_name=>'APEX.IG.MEDIAN_OVERALL'
,p_message_language=>'it'
,p_message_text=>'Mediana globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279022381712868525)
,p_name=>'APEX.IG.MIN'
,p_message_language=>'it'
,p_message_text=>'Minimo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278658815911868294)
,p_name=>'APEX.IG.MINUTES'
,p_message_language=>'it'
,p_message_text=>'minuti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279024155027868526)
,p_name=>'APEX.IG.MINUTES_AGO'
,p_message_language=>'it'
,p_message_text=>'Minuti fa'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279151867879868608)
,p_name=>'APEX.IG.MIN_OVERALL'
,p_message_language=>'it'
,p_message_text=>'Minimo globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278659438376868295)
,p_name=>'APEX.IG.MONTHS'
,p_message_language=>'it'
,p_message_text=>'mesi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278682695636868309)
,p_name=>'APEX.IG.MORE_DATA_FOUND'
,p_message_language=>'it'
,p_message_text=>unistr('I dati contengono pi\00F9 di %0 righe. Questo valore supera il limite massimo consentito. Applicare ulteriori filtri per visualizzare i risultati.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278674684217868304)
,p_name=>'APEX.IG.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278674818505868304)
,p_name=>'APEX.IG.NAMED_REPORT'
,p_message_language=>'it'
,p_message_text=>'Report denominato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278554507756868228)
,p_name=>'APEX.IG.NEXT.DAY'
,p_message_language=>'it'
,p_message_text=>'Giorno successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278554322867868228)
,p_name=>'APEX.IG.NEXT.HOUR'
,p_message_language=>'it'
,p_message_text=>'Ora successiva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278556571188868230)
,p_name=>'APEX.IG.NEXT.MINUTE'
,p_message_language=>'it'
,p_message_text=>'Minuto successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278554822802868228)
,p_name=>'APEX.IG.NEXT.MONTH'
,p_message_language=>'it'
,p_message_text=>'Mese successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278554744100868228)
,p_name=>'APEX.IG.NEXT.WEEK'
,p_message_language=>'it'
,p_message_text=>'Settimana successiva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278554685510868228)
,p_name=>'APEX.IG.NEXT.X_DAYS'
,p_message_language=>'it'
,p_message_text=>'%0 giorni successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278554409532868228)
,p_name=>'APEX.IG.NEXT.X_HOURS'
,p_message_language=>'it'
,p_message_text=>'%0 ore successive'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278556685453868230)
,p_name=>'APEX.IG.NEXT.X_MINUTES'
,p_message_language=>'it'
,p_message_text=>'%0 minuti successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278555997151868229)
,p_name=>'APEX.IG.NEXT.X_MONTHS'
,p_message_language=>'it'
,p_message_text=>'%0 mesi successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278556034920868229)
,p_name=>'APEX.IG.NEXT.X_WEEKS'
,p_message_language=>'it'
,p_message_text=>'%0 settimane successive'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278555006088868229)
,p_name=>'APEX.IG.NEXT.X_YEARS'
,p_message_language=>'it'
,p_message_text=>'%0 anni successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278554941145868229)
,p_name=>'APEX.IG.NEXT.YEAR'
,p_message_language=>'it'
,p_message_text=>'Anno successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278657629867868294)
,p_name=>'APEX.IG.NOT_BETWEEN'
,p_message_language=>'it'
,p_message_text=>'non tra'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278656663828868293)
,p_name=>'APEX.IG.NOT_EQUALS'
,p_message_language=>'it'
,p_message_text=>'diverso da'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279177015671868624)
,p_name=>'APEX.IG.NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>unistr('L''area con ID %0 non \00E8 di tipo Griglia interattiva oppure non esiste nell''applicazione %1.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278657033230868293)
,p_name=>'APEX.IG.NOT_IN'
,p_message_language=>'it'
,p_message_text=>'non contenuta in'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278657829951868294)
,p_name=>'APEX.IG.NOT_IN_THE_LAST'
,p_message_language=>'it'
,p_message_text=>'non negli/lle ultimi/e'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278658043693868294)
,p_name=>'APEX.IG.NOT_IN_THE_NEXT'
,p_message_language=>'it'
,p_message_text=>'non nei/lle seguenti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278682538298868309)
,p_name=>'APEX.IG.NO_DATA_FOUND'
,p_message_language=>'it'
,p_message_text=>'Nessun dato trovato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279115432930868585)
,p_name=>'APEX.IG.NULLS'
,p_message_language=>'it'
,p_message_text=>'Valori nulli'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279125461106868591)
,p_name=>'APEX.IG.NUMBER'
,p_message_language=>'it'
,p_message_text=>'Numerico'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279115972054868585)
,p_name=>'APEX.IG.OFF'
,p_message_language=>'it'
,p_message_text=>'Non attivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279116029709868585)
,p_name=>'APEX.IG.ON'
,p_message_language=>'it'
,p_message_text=>'Attivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278640049107868282)
,p_name=>'APEX.IG.ONE_MINUTE_AGO'
,p_message_language=>'it'
,p_message_text=>'1 minuto fa'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279133114016868596)
,p_name=>'APEX.IG.OPEN_COLORPICKER'
,p_message_language=>'it'
,p_message_text=>'Apri selettore colori: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279108683663868580)
,p_name=>'APEX.IG.OPEN_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Apertura'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278675730752868305)
,p_name=>'APEX.IG.OPERATOR'
,p_message_language=>'it'
,p_message_text=>'Operatore'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279108098937868580)
,p_name=>'APEX.IG.ORIENTATION'
,p_message_language=>'it'
,p_message_text=>'Orientamento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279110485654868582)
,p_name=>'APEX.IG.PIE'
,p_message_language=>'it'
,p_message_text=>'A torta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278677023595868306)
,p_name=>'APEX.IG.PIVOT'
,p_message_language=>'it'
,p_message_text=>'Pivot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278414985246868140)
,p_name=>'APEX.IG.PIVOT_VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista pivot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279133034368868596)
,p_name=>'APEX.IG.PLACEHOLDER_INVALUES'
,p_message_language=>'it'
,p_message_text=>'Separare i valori con "%0"'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279110531529868582)
,p_name=>'APEX.IG.POLAR'
,p_message_language=>'it'
,p_message_text=>'Polare'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279124368769868590)
,p_name=>'APEX.IG.POSITION_CENTER'
,p_message_language=>'it'
,p_message_text=>'Al centro'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279124420235868590)
,p_name=>'APEX.IG.POSITION_END'
,p_message_language=>'it'
,p_message_text=>'Fine'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279124267679868590)
,p_name=>'APEX.IG.POSITION_START'
,p_message_language=>'it'
,p_message_text=>'Inizio'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278674970378868304)
,p_name=>'APEX.IG.PRIMARY'
,p_message_language=>'it'
,p_message_text=>'Chiave primaria'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278675243438868305)
,p_name=>'APEX.IG.PRIMARY_DEFAULT'
,p_message_language=>'it'
,p_message_text=>'Predefinito primario'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278970276803868492)
,p_name=>'APEX.IG.PRIMARY_REPORT'
,p_message_language=>'it'
,p_message_text=>'Report primario'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279110649217868582)
,p_name=>'APEX.IG.RADAR'
,p_message_language=>'it'
,p_message_text=>'A radar'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279110746895868582)
,p_name=>'APEX.IG.RANGE'
,p_message_language=>'it'
,p_message_text=>'Intervallo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279134503089868597)
,p_name=>'APEX.IG.REFRESH'
,p_message_language=>'it'
,p_message_text=>'Aggiorna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278683306100868310)
,p_name=>'APEX.IG.REFRESH_ROW'
,p_message_language=>'it'
,p_message_text=>'Aggiorna riga'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278682149729868309)
,p_name=>'APEX.IG.REFRESH_ROWS'
,p_message_language=>'it'
,p_message_text=>'Aggiorna righe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278416431114868141)
,p_name=>'APEX.IG.REMOVE_CONTROL'
,p_message_language=>'it'
,p_message_text=>'Rimuovi %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278674387287868304)
,p_name=>'APEX.IG.REPORT'
,p_message_language=>'it'
,p_message_text=>'Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279167779817868618)
,p_name=>'APEX.IG.REPORT.DELETED'
,p_message_language=>'it'
,p_message_text=>'Report eliminato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279167470607868618)
,p_name=>'APEX.IG.REPORT.SAVED.ALTERNATIVE'
,p_message_language=>'it'
,p_message_text=>'Report alternativo salvato per tutti gli utenti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279167323679868618)
,p_name=>'APEX.IG.REPORT.SAVED.DEFAULT'
,p_message_language=>'it'
,p_message_text=>'Report predefinito salvato per tutti gli utenti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279167647680868618)
,p_name=>'APEX.IG.REPORT.SAVED.PRIVATE'
,p_message_language=>'it'
,p_message_text=>'Report privato salvato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279167593843868618)
,p_name=>'APEX.IG.REPORT.SAVED.PUBLIC'
,p_message_language=>'it'
,p_message_text=>'Report pubblico salvato per tutti gli utenti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278639952093868282)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF.X.MINUTES_AGO'
,p_message_language=>'it'
,p_message_text=>unistr('Dati del report cos\00EC come si presentavano %0 minuti fa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278639887357868282)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF_ONE_MINUTE_AGO'
,p_message_language=>'it'
,p_message_text=>unistr('Dati del report cos\00EC come si presentavano 1 minuto fa')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279138952070868600)
,p_name=>'APEX.IG.REPORT_EDIT'
,p_message_language=>'it'
,p_message_text=>'Report - Modifica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279138843313868600)
,p_name=>'APEX.IG.REPORT_SAVE_AS'
,p_message_language=>'it'
,p_message_text=>'Report - Salva con nome'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278416599627868141)
,p_name=>'APEX.IG.REPORT_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279177137585868624)
,p_name=>'APEX.IG.REPORT_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'La griglia interattiva salvata con ID statico %0 non esiste.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279151237007868608)
,p_name=>'APEX.IG.REPORT_VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278415648922868140)
,p_name=>'APEX.IG.RESET'
,p_message_language=>'it'
,p_message_text=>'Reimposta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278683448175868310)
,p_name=>'APEX.IG.REVERT_CHANGES'
,p_message_language=>'it'
,p_message_text=>'Annulla modifiche'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278682221475868309)
,p_name=>'APEX.IG.REVERT_ROWS'
,p_message_language=>'it'
,p_message_text=>'Ripristina righe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278675332930868305)
,p_name=>'APEX.IG.ROW'
,p_message_language=>'it'
,p_message_text=>'Riga'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278674282232868304)
,p_name=>'APEX.IG.ROWS_PER_PAGE'
,p_message_language=>'it'
,p_message_text=>'Righe per pagina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279175742054868623)
,p_name=>'APEX.IG.ROW_ACTIONS'
,p_message_language=>'it'
,p_message_text=>'Azioni riga'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279182996971868628)
,p_name=>'APEX.IG.ROW_ACTIONS_FOR'
,p_message_language=>'it'
,p_message_text=>'Azioni per la riga %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278415950415868141)
,p_name=>'APEX.IG.SAVE'
,p_message_language=>'it'
,p_message_text=>'Salva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278758340323868357)
,p_name=>'APEX.IG.SAVED'
,p_message_language=>'it'
,p_message_text=>'salvato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278414158043868139)
,p_name=>'APEX.IG.SAVED_REPORTS'
,p_message_language=>'it'
,p_message_text=>'Report salvati'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278414281325868140)
,p_name=>'APEX.IG.SAVED_REPORT_DEFAULT'
,p_message_language=>'it'
,p_message_text=>'Valore predefinito'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278414380207868140)
,p_name=>'APEX.IG.SAVED_REPORT_PRIVATE'
,p_message_language=>'it'
,p_message_text=>'Privato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278414497319868140)
,p_name=>'APEX.IG.SAVED_REPORT_PUBLIC'
,p_message_language=>'it'
,p_message_text=>'Pubblico'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279150920300868607)
,p_name=>'APEX.IG.SAVE_AS'
,p_message_language=>'it'
,p_message_text=>'Salva con nome'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278681554757868309)
,p_name=>'APEX.IG.SAVE_REPORT_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Salva impostazioni report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279110853041868582)
,p_name=>'APEX.IG.SCATTER'
,p_message_language=>'it'
,p_message_text=>'A dispersione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278414079438868139)
,p_name=>'APEX.IG.SEARCH'
,p_message_language=>'it'
,p_message_text=>'Cerca'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279129633967868594)
,p_name=>'APEX.IG.SEARCH.ALL_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Cerca: Tutte le colonne di testo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278413938624868139)
,p_name=>'APEX.IG.SEARCH.COLUMN'
,p_message_language=>'it'
,p_message_text=>'Cerca: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279128446613868593)
,p_name=>'APEX.IG.SEARCH.ORACLE_TEXT'
,p_message_language=>'it'
,p_message_text=>'Cerca: Testo completo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278639786366868282)
,p_name=>'APEX.IG.SEARCH_FOR.X'
,p_message_language=>'it'
,p_message_text=>'Cerca ''%0'''
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279104385079868578)
,p_name=>'APEX.IG.SELECT'
,p_message_language=>'it'
,p_message_text=>'- Seleziona -'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278478519343868180)
,p_name=>'APEX.IG.SELECTION'
,p_message_language=>'it'
,p_message_text=>'Selezione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279077125561868560)
,p_name=>'APEX.IG.SELECT_1_ROW_IN_MASTER'
,p_message_language=>'it'
,p_message_text=>'Selezionare 1 riga nell''area master'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278413878131868139)
,p_name=>'APEX.IG.SELECT_COLUMNS_TO_SEARCH'
,p_message_language=>'it'
,p_message_text=>'Selezionare le colonne in cui cercare'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279174777541868622)
,p_name=>'APEX.IG.SEL_ACTIONS'
,p_message_language=>'it'
,p_message_text=>'Azioni selezione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278478799402868180)
,p_name=>'APEX.IG.SEL_MODE_CELL'
,p_message_language=>'it'
,p_message_text=>'Selezione celle'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278478668646868180)
,p_name=>'APEX.IG.SEL_MODE_ROW'
,p_message_language=>'it'
,p_message_text=>'Selezione righe'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279130295326868594)
,p_name=>'APEX.IG.SEND_AS_EMAIL'
,p_message_language=>'it'
,p_message_text=>'Invia come posta elettronica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279113764650868584)
,p_name=>'APEX.IG.SERIES_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Serie'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278374725005868114)
,p_name=>'APEX.IG.SHOW'
,p_message_language=>'it'
,p_message_text=>'Mostra'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278989688606868504)
,p_name=>'APEX.IG.SHOW_OVERALL_VALUE'
,p_message_language=>'it'
,p_message_text=>'Mostra valore globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278683011996868310)
,p_name=>'APEX.IG.SINGLE_ROW_VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista a riga singola'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278677245132868306)
,p_name=>'APEX.IG.SORT'
,p_message_language=>'it'
,p_message_text=>'Ordina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279113826688868584)
,p_name=>'APEX.IG.SORT_BY'
,p_message_language=>'it'
,p_message_text=>'Ordina per'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279175843662868623)
,p_name=>'APEX.IG.SORT_ONLY_ONE_PER_COLUMN'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 possibile definire solo un ordinamento per colonna.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279174961732868623)
,p_name=>'APEX.IG.SRV_CHANGE_MENU'
,p_message_language=>'it'
,p_message_text=>'Menu Modifica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279116154497868585)
,p_name=>'APEX.IG.STACK'
,p_message_language=>'it'
,p_message_text=>'In pila'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278658314534868294)
,p_name=>'APEX.IG.STARTS_WITH'
,p_message_language=>'it'
,p_message_text=>'inizia con'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279110909353868582)
,p_name=>'APEX.IG.STOCK'
,p_message_language=>'it'
,p_message_text=>'Borsistico'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278303433852868069)
,p_name=>'APEX.IG.STRETCH_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Estendi larghezza colonne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278681799545868309)
,p_name=>'APEX.IG.SUBSCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Sottoscrizione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279022265664868525)
,p_name=>'APEX.IG.SUM'
,p_message_language=>'it'
,p_message_text=>'Somma'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279183123401868628)
,p_name=>'APEX.IG.SUMMARY'
,p_message_language=>'it'
,p_message_text=>'Griglia interattiva. Report: %0, vista: %1.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279151373268868608)
,p_name=>'APEX.IG.SUM_OVERALL'
,p_message_language=>'it'
,p_message_text=>'Somma globale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279109179149868581)
,p_name=>'APEX.IG.TARGET_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Destinazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279123527887868590)
,p_name=>'APEX.IG.TEXT_COLOR'
,p_message_language=>'it'
,p_message_text=>'Colore testo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278416608473868141)
,p_name=>'APEX.IG.TOGGLE'
,p_message_language=>'it'
,p_message_text=>'Attiva/disattiva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278989534813868504)
,p_name=>'APEX.IG.TOOLTIP'
,p_message_language=>'it'
,p_message_text=>'Descrizione comandi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278674406122868304)
,p_name=>'APEX.IG.TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278682942232868310)
,p_name=>'APEX.IG.UNFREEZE'
,p_message_language=>'it'
,p_message_text=>'Sblocca'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278675972793868305)
,p_name=>'APEX.IG.UNIT'
,p_message_language=>'it'
,p_message_text=>unistr('Unit\00E0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279130037261868594)
,p_name=>'APEX.IG.UNSAVED_CHANGES_CONTINUE_CONFIRM'
,p_message_language=>'it'
,p_message_text=>'Esistono modifiche non salvate. Continuare?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278675836050868305)
,p_name=>'APEX.IG.VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279108278772868580)
,p_name=>'APEX.IG.VALUE_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Valore'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279117260396868586)
,p_name=>'APEX.IG.VALUE_REQUIRED'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 richiesto un valore.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279061714905868551)
,p_name=>'APEX.IG.VALUE_TIMESTAMP_TZ'
,p_message_language=>'it'
,p_message_text=>'Valore (impossibile modificare il fuso orario)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279125595906868591)
,p_name=>'APEX.IG.VARCHAR2'
,p_message_language=>'it'
,p_message_text=>'Testo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279109506347868581)
,p_name=>'APEX.IG.VERTICAL'
,p_message_language=>'it'
,p_message_text=>'Verticale'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278673961954868304)
,p_name=>'APEX.IG.VIEW'
,p_message_language=>'it'
,p_message_text=>'Visualizza'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279104458683868578)
,p_name=>'APEX.IG.VISIBLE'
,p_message_language=>'it'
,p_message_text=>'Visualizzato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279109059162868581)
,p_name=>'APEX.IG.VOLUME_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Volume'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278659323827868295)
,p_name=>'APEX.IG.WEEKS'
,p_message_language=>'it'
,p_message_text=>'settimane'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279104519184868578)
,p_name=>'APEX.IG.WIDTH'
,p_message_language=>'it'
,p_message_text=>'Larghezza colonna minima (pixel)'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278589504229868250)
,p_name=>'APEX.IG.X.BETWEEN.Y.AND.Z'
,p_message_language=>'it'
,p_message_text=>'%0 compreso tra %1 e %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278589230563868250)
,p_name=>'APEX.IG.X.CONTAINS.Y'
,p_message_language=>'it'
,p_message_text=>'%0 contiene %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278589335701868250)
,p_name=>'APEX.IG.X.DOES_NOT_CONTAIN.Y'
,p_message_language=>'it'
,p_message_text=>'%0 non contiene %1'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278370909641868112)
,p_name=>'APEX.IG.X.DOES_NOT_START_WITH.Y'
,p_message_language=>'it'
,p_message_text=>'%0 non inizia con %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278588009777868250)
,p_name=>'APEX.IG.X.EQUALS.Y'
,p_message_language=>'it'
,p_message_text=>'%0 uguale a %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278588273765868250)
,p_name=>'APEX.IG.X.GREATER_THAN.Y'
,p_message_language=>'it'
,p_message_text=>'%0 maggiore di %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278588381950868250)
,p_name=>'APEX.IG.X.GREATER_THAN_OR_EQUALS.Y'
,p_message_language=>'it'
,p_message_text=>'%0 maggiore o uguale a %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278589014166868250)
,p_name=>'APEX.IG.X.IN.Y'
,p_message_language=>'it'
,p_message_text=>'%0 in %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278590260334868251)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.DAYS'
,p_message_language=>'it'
,p_message_text=>'%0 negli ultimi %1 giorni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278590052763868251)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.HOURS'
,p_message_language=>'it'
,p_message_text=>'%0 nelle ultime %1 ore'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278589889283868251)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MINUTES'
,p_message_language=>'it'
,p_message_text=>'%0 negli ultimi %1 minuti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278590662273868251)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MONTHS'
,p_message_language=>'it'
,p_message_text=>'%0 negli ultimi %1 mesi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278590423142868251)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.WEEKS'
,p_message_language=>'it'
,p_message_text=>'%0 nelle ultime %1 settimane'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278590871335868251)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.YEARS'
,p_message_language=>'it'
,p_message_text=>'%0 negli ultimi %1 anni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278590160263868251)
,p_name=>'APEX.IG.X.IN_THE_LAST_DAY'
,p_message_language=>'it'
,p_message_text=>'%0 nell''ultimo giorno'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278589926233868251)
,p_name=>'APEX.IG.X.IN_THE_LAST_HOUR'
,p_message_language=>'it'
,p_message_text=>'%0 nell''ultima ora'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278589705672868251)
,p_name=>'APEX.IG.X.IN_THE_LAST_MINUTE'
,p_message_language=>'it'
,p_message_text=>'%0 nell''ultimo minuto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278590587321868251)
,p_name=>'APEX.IG.X.IN_THE_LAST_MONTH'
,p_message_language=>'it'
,p_message_text=>'%0 nell''ultimo mese'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278590313080868251)
,p_name=>'APEX.IG.X.IN_THE_LAST_WEEK'
,p_message_language=>'it'
,p_message_text=>'%0 nell''ultima settimana'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278590781337868251)
,p_name=>'APEX.IG.X.IN_THE_LAST_YEAR'
,p_message_language=>'it'
,p_message_text=>'%0 nell''ultimo anno'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278592636101868252)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.DAYS'
,p_message_language=>'it'
,p_message_text=>'%0 nei %1 giorni successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278592453869868252)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.HOURS'
,p_message_language=>'it'
,p_message_text=>'%0 nelle %1 ore successive'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278592271816868252)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'it'
,p_message_text=>'%0 nei %1 minuti successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278593090877868253)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'it'
,p_message_text=>'%0 nei %1 mesi successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278592824139868253)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'it'
,p_message_text=>'%0 nelle %1 settimane successive'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278593206955868253)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.YEARS'
,p_message_language=>'it'
,p_message_text=>'%0 nei %1 anni successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278592568188868252)
,p_name=>'APEX.IG.X.IN_THE_NEXT_DAY'
,p_message_language=>'it'
,p_message_text=>'%0 nel giorno successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278592308170868252)
,p_name=>'APEX.IG.X.IN_THE_NEXT_HOUR'
,p_message_language=>'it'
,p_message_text=>'%0 nell''ora successiva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278592144772868252)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MINUTE'
,p_message_language=>'it'
,p_message_text=>'%0 nel minuto successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278592923011868253)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MONTH'
,p_message_language=>'it'
,p_message_text=>'%0 nel mese successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278592768120868252)
,p_name=>'APEX.IG.X.IN_THE_NEXT_WEEK'
,p_message_language=>'it'
,p_message_text=>'%0 nella settimana successiva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278593182643868253)
,p_name=>'APEX.IG.X.IN_THE_NEXT_YEAR'
,p_message_language=>'it'
,p_message_text=>'%0 nell''anno successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278588723819868250)
,p_name=>'APEX.IG.X.IS_NOT_NULL'
,p_message_language=>'it'
,p_message_text=>unistr('%0 non \00E8 vuoto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278588684985868250)
,p_name=>'APEX.IG.X.IS_NULL'
,p_message_language=>'it'
,p_message_text=>unistr('%0 \00E8 vuoto')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278588442178868250)
,p_name=>'APEX.IG.X.LESS_THAN.Y'
,p_message_language=>'it'
,p_message_text=>'%0 minore di %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278588597016868250)
,p_name=>'APEX.IG.X.LESS_THAN_OR_EQUALS.Y'
,p_message_language=>'it'
,p_message_text=>'%0 minore o uguale a %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278588884603868250)
,p_name=>'APEX.IG.X.LIKE.Y'
,p_message_language=>'it'
,p_message_text=>'%0 simile a %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278589401133868250)
,p_name=>'APEX.IG.X.MATCHES_REGULAR_EXPRESSION.Y'
,p_message_language=>'it'
,p_message_text=>'%0 corrisponde all''espressione regolare %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278640104914868282)
,p_name=>'APEX.IG.X.MINUTES_AGO'
,p_message_language=>'it'
,p_message_text=>'%0 minuti fa'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278589621566868251)
,p_name=>'APEX.IG.X.NOT_BETWEEN.Y.AND.Z'
,p_message_language=>'it'
,p_message_text=>'%0 non compreso tra %1 e %2'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278588152840868250)
,p_name=>'APEX.IG.X.NOT_EQUALS.Y'
,p_message_language=>'it'
,p_message_text=>'%0 diverso da %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278589183444868250)
,p_name=>'APEX.IG.X.NOT_IN.Y'
,p_message_language=>'it'
,p_message_text=>'%0 non in %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278591498196868252)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.DAYS'
,p_message_language=>'it'
,p_message_text=>'%0 non negli ultimi %1 giorni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278591222097868252)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.HOURS'
,p_message_language=>'it'
,p_message_text=>'%0 non nelle ultime %1 ore'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278591077024868251)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MINUTES'
,p_message_language=>'it'
,p_message_text=>'%0 non negli ultimi %1 minuti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278591847943868252)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MONTHS'
,p_message_language=>'it'
,p_message_text=>'%0 non negli ultimi %1 mesi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278591644339868252)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.WEEKS'
,p_message_language=>'it'
,p_message_text=>'%0 non nelle ultime %1 settimane'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278592021899868252)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.YEARS'
,p_message_language=>'it'
,p_message_text=>'%0 non negli ultimi %1 anni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278591323491868252)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_DAY'
,p_message_language=>'it'
,p_message_text=>'%0 non nell''ultimo giorno'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278591109107868251)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_HOUR'
,p_message_language=>'it'
,p_message_text=>'%0 non nell''ultima ora'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278590942222868251)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MINUTE'
,p_message_language=>'it'
,p_message_text=>'%0 non nell''ultimo minuto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278591707170868252)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MONTH'
,p_message_language=>'it'
,p_message_text=>'%0 non nell''ultimo mese'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278591559208868252)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_WEEK'
,p_message_language=>'it'
,p_message_text=>'%0 non nell''ultima settimana'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278591957315868252)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_YEAR'
,p_message_language=>'it'
,p_message_text=>'%0 non nell''ultimo anno'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278593828637868253)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.DAYS'
,p_message_language=>'it'
,p_message_text=>'%0 non nei %1 giorni successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278593647862868253)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.HOURS'
,p_message_language=>'it'
,p_message_text=>'%0 non nelle %1 ore successive'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278593451787868253)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'it'
,p_message_text=>'%0 non nei %1 minuti successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278594251710868253)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'it'
,p_message_text=>'%0 non nei %1 mesi successivi '
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278594019616868253)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'it'
,p_message_text=>'%0 non nelle %1 settimane successive'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278594495729868254)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.YEARS'
,p_message_language=>'it'
,p_message_text=>'%0 non nei %1 anni successivi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278593768037868253)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_DAY'
,p_message_language=>'it'
,p_message_text=>'%0 non nel giorno successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278593557723868253)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_HOUR'
,p_message_language=>'it'
,p_message_text=>'%0 non nell''ora successiva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278593361104868253)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MINUTE'
,p_message_language=>'it'
,p_message_text=>'%0 non nel minuto successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278594172461868253)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MONTH'
,p_message_language=>'it'
,p_message_text=>'%0 non nel mese successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278593908822868253)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_WEEK'
,p_message_language=>'it'
,p_message_text=>'%0 non nella settimana successiva'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278594316558868254)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_YEAR'
,p_message_language=>'it'
,p_message_text=>'%0 non nell''anno successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278588955228868250)
,p_name=>'APEX.IG.X.NOT_LIKE.Y'
,p_message_language=>'it'
,p_message_text=>'%0 non simile a %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278650025795868289)
,p_name=>'APEX.IG.X.STARTS_WITH.Y'
,p_message_language=>'it'
,p_message_text=>'%0 inizia con %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279108357368868580)
,p_name=>'APEX.IG.X_COLUMN'
,p_message_language=>'it'
,p_message_text=>'X'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278659589736868295)
,p_name=>'APEX.IG.YEARS'
,p_message_language=>'it'
,p_message_text=>'anni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279108427378868580)
,p_name=>'APEX.IG.Y_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Y'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279108552281868580)
,p_name=>'APEX.IG.Z_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Z'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279129074798868593)
,p_name=>'APEX.IG_FORMAT_SAMPLE_1'
,p_message_language=>'it'
,p_message_text=>unistr('Luned\00EC 12 gennaio 2016')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279129137564868593)
,p_name=>'APEX.IG_FORMAT_SAMPLE_2'
,p_message_language=>'it'
,p_message_text=>'Gennaio'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279129207756868593)
,p_name=>'APEX.IG_FORMAT_SAMPLE_3'
,p_message_language=>'it'
,p_message_text=>'16 ore fa'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279129313053868594)
,p_name=>'APEX.IG_FORMAT_SAMPLE_4'
,p_message_language=>'it'
,p_message_text=>'tra 16 ore'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277985194820867868)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_language=>'it'
,p_message_text=>'Il supporto di stampa deve essere STANDARD o ADVANCED'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277985286567867869)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_language=>'it'
,p_message_text=>'Impossibile rimuovere l''impostazione del primo schema fornito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277874097016867798)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'ID applicazione non valido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278412093962868138)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_language=>'it'
,p_message_text=>'Indirizzo di posta elettronica non valido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277855175501867787)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_language=>'it'
,p_message_text=>'Il valore deve essere pari a zero o un numero intero positivo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277985308124867869)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_language=>'it'
,p_message_text=>'Numero di porta non valido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278447817971868161)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_language=>'it'
,p_message_text=>'ID sottoscrizione non valido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277985434428867869)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_language=>'it'
,p_message_text=>'Il percorso del wallet deve essere nel file di formato: <filesystempath>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278076895320867926)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_language=>'it'
,p_message_text=>'Area di lavoro non trovata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278076711172867926)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_language=>'it'
,p_message_text=>'ID area di lavoro non valido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278004333693867881)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_language=>'it'
,p_message_text=>'Il valore "%1" del parametro di istanza "%0" non corrisponde all''espressione regolare "%2"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278004263839867881)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Il parametro di istanza "%0" deve avere un valore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277985549937867869)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_language=>'it'
,p_message_text=>'Parametro di istanza non trovato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278443427425868158)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_language=>'it'
,p_message_text=>'Password'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277808860987867757)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_language=>'it'
,p_message_text=>'Password (solo per l''autenticazione rispetto al repository degli account utente dell''area di lavoro)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278728922194868338)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_language=>'it'
,p_message_text=>'Password (solo per l''autenticazione rispetto al repository degli account utente dell''area di lavoro)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278550441323868226)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_language=>'it'
,p_message_text=>'Password (solo per l''autenticazione rispetto al repository degli account utente dell''area di lavoro)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278130680191867960)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_language=>'it'
,p_message_text=>'Password (solo per l''autenticazione rispetto al repository degli account utente dell''area di lavoro)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278443335456868158)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_language=>'it'
,p_message_text=>'Password (solo per l''autenticazione rispetto al repository degli account utente dell''area di lavoro)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277987401042867870)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_language=>'it'
,p_message_text=>'Il protocollo del server di stampa deve essere http o https'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277987587041867870)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'Schema inesistente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277987611838867870)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_language=>'it'
,p_message_text=>'Schema limitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277833778503867773)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277833512524867773)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_language=>'it'
,p_message_text=>unistr('L''applicazione non esiste pi\00F9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278778148732868370)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_language=>'it'
,p_message_text=>'Assegna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279058427256868549)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_language=>'it'
,p_message_text=>'Schede'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277835620225867774)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_language=>'it'
,p_message_text=>'Commentato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277835598207867774)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_language=>'it'
,p_message_text=>'commenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277810355137867758)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_language=>'it'
,p_message_text=>'Elimina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277810119001867758)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 certi di voler eliminare questo commento?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278762589470868360)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_language=>'it'
,p_message_text=>'Elimina problema'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277819987277867764)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 certi di voler eliminare questo problema?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277837260611867775)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_language=>'it'
,p_message_text=>'Documento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277836199218867774)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_language=>'it'
,p_message_text=>'Documenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277810289627867758)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_language=>'it'
,p_message_text=>'Modifica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278986054176868502)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_language=>'it'
,p_message_text=>'Modifica commento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278986108596868502)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_language=>'it'
,p_message_text=>'Modifica problema'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277834343970867773)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'L''applicazione specificata non esiste in questa area di lavoro.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277834761445867774)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_language=>'it'
,p_message_text=>'Errore durante il tentativo di eliminare il commento.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277834610135867774)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'Commento non trovato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277834952375867774)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'Problema non trovato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277835098300867774)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_language=>'it'
,p_message_text=>'Errore durante il tentativo di contrassegnare il problema per l''eliminazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277834461404867773)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'La pagina specificata non esiste in questa area di lavoro o nell''applicazione fornita.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277834860621867774)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_language=>'it'
,p_message_text=>unistr('L''utente non \00E8 autorizzato a eliminare questo commento.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277835186696867774)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_language=>'it'
,p_message_text=>unistr('L''utente non \00E8 autorizzato a eliminare questo problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277834524703867773)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_language=>'it'
,p_message_text=>unistr('L''utente non \00E8 autorizzato a modificare la visibilit\00E0 di questo commento.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278994971077868507)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 verificato un problema durante il controllo delle dimensioni dei file. Contattare l''amministratore del sistema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278994851211868507)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_language=>'it'
,p_message_text=>unistr('Uno di questi file \00E8 pi\00F9 grande della dimensione massima file di %0 byte.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278994788167868507)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_language=>'it'
,p_message_text=>unistr('Questo file \00E8 pi\00F9 grande della dimensione massima file di %0 byte.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277810498325867758)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_language=>'it'
,p_message_text=>'Nascondi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277837050696867775)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_language=>'it'
,p_message_text=>'Immagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277835924866867774)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_language=>'it'
,p_message_text=>'Immagini'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277833384010867773)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'un problema non trovato nel sistema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277794004608867748)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_language=>'it'
,p_message_text=>'Aggiungi preferenza per l''utente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277835740201867774)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_language=>'it'
,p_message_text=>'Allega file'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277835431279867774)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_language=>'it'
,p_message_text=>'Chiuso/i'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279064037704868552)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_language=>'it'
,p_message_text=>'Intestazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277836796043867775)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_language=>'it'
,p_message_text=>unistr('\00E8 vuoto.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277836587625867775)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_language=>'it'
,p_message_text=>unistr('Uno di questi file \00E8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277835371050867774)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_language=>'it'
,p_message_text=>'Apri'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277837844462867775)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_language=>'it'
,p_message_text=>'Elimina definitivamente elementi selezionati'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278763465198868360)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_language=>'it'
,p_message_text=>'Rimuovi tutto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277837767319867775)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_language=>'it'
,p_message_text=>'Ricrea istanza elementi selezionati'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277835830684867774)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_language=>'it'
,p_message_text=>'Modelli di risposta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277836620373867775)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_language=>'it'
,p_message_text=>'troppo grande per essere caricato. <br>La dimensione del file deve essere minore di'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277836983462867775)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_language=>'it'
,p_message_text=>'Tipi di file supportati: '
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278989990539868504)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Selezionare un modello di risposta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277836421747867775)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_language=>'it'
,p_message_text=>unistr('Questo file \00E8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277836858840867775)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_language=>'it'
,p_message_text=>unistr('non \00E8 un tipo di file supportato.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278702261893868322)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_language=>'it'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278702852364868322)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_language=>'it'
,p_message_text=>'Problema di documentazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278702383267868322)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_language=>'it'
,p_message_text=>'Richiesta di miglioramento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278702458862868322)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_language=>'it'
,p_message_text=>'Richiesta di funzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278702725830868322)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_language=>'it'
,p_message_text=>'Problemi di installazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278702600883868322)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_language=>'it'
,p_message_text=>'Problema di prestazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278702543629868322)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_language=>'it'
,p_message_text=>'Problema di sicurezza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278702928240868322)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_language=>'it'
,p_message_text=>'Problema di formazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278703620673868323)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_language=>'it'
,p_message_text=>'Amministrazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278703329012868322)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_language=>'it'
,p_message_text=>'CSS / HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278703437807868322)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_language=>'it'
,p_message_text=>'Azioni dinamiche/JavaScript'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278703121930868322)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_language=>'it'
,p_message_text=>'Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278703713080868323)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_language=>'it'
,p_message_text=>'Integrazione sistema esterno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278703254571868322)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_language=>'it'
,p_message_text=>'Integrazione REST'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278703531713868322)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_language=>'it'
,p_message_text=>'Sicurezza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278703045046868322)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_language=>'it'
,p_message_text=>'UI / UX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278702110541868322)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_language=>'it'
,p_message_text=>'Categoria assegnata al problema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278701259846868321)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_language=>'it'
,p_message_text=>'Categoria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278702048053868322)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_language=>'it'
,p_message_text=>'Area funzionale interessata dal problema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278701334702868321)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_language=>'it'
,p_message_text=>'Area funzionale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278701996279868321)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_language=>'it'
,p_message_text=>'Livello di importanza assegnato al problema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278701451245868321)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_language=>'it'
,p_message_text=>'Importanza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278701853163868321)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_language=>'it'
,p_message_text=>'Livello d''impegno richiesto per risolvere il problema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278701530974868321)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_language=>'it'
,p_message_text=>'Livello d''impegno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278701764630868321)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_language=>'it'
,p_message_text=>'Stato di avanzamento per la risoluzione del problema.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278701668931868321)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_language=>'it'
,p_message_text=>'Stato di avanzamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278704181334868323)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_language=>'it'
,p_message_text=>'Backlog'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278703833632868323)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_language=>'it'
,p_message_text=>'Critico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278703958502868323)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_language=>'it'
,p_message_text=>'Importante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278704001556868323)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_language=>'it'
,p_message_text=>'Normale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278704294662868323)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_language=>'it'
,p_message_text=>unistr('Non verr\00E0 risolto')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278704343247868323)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_language=>'it'
,p_message_text=>'Correzione facile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278704582258868323)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_language=>'it'
,p_message_text=>'Grande impegno di sviluppo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278704432166868323)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_language=>'it'
,p_message_text=>'Impegno moderato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278704959920868323)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_language=>'it'
,p_message_text=>'Correzione impossibile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278705039772868323)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_language=>'it'
,p_message_text=>'Completato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278704763113868323)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_language=>'it'
,p_message_text=>'Richiede ulteriori informazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278704835528868323)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_language=>'it'
,p_message_text=>'In attesa di terze parti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278704612971868323)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_language=>'it'
,p_message_text=>'In fase di elaborazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278715300471868330)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_language=>'it'
,p_message_text=>unistr('Questo gruppo di etichette non pu\00F2 essere eliminato perch\00E9 uno o pi\00F9 membri sono assegnati a un problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277835237193867774)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_language=>'it'
,p_message_text=>'Contrassegnato come duplicato di'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278762919992868360)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_language=>'it'
,p_message_text=>'Assegnatari'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278762835350868360)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_language=>'it'
,p_message_text=>'Etichette'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278763324162868360)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_language=>'it'
,p_message_text=>'Milestone'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278762736411868360)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_language=>'it'
,p_message_text=>'Stato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277833137325867773)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_language=>'it'
,p_message_text=>'milestone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278705652031868324)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_language=>'it'
,p_message_text=>'Blocco codice'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278705879400868324)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_language=>'it'
,p_message_text=>'Release finale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278705707074868324)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_language=>'it'
,p_message_text=>'Blocco interfaccia utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277837684089867775)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_language=>'it'
,p_message_text=>'%0 ha aggiunto un commento a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277793735844867748)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_language=>'it'
,p_message_text=>'modificato/a.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278719550141868332)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_language=>'it'
,p_message_text=>unistr('Il numero problema %0 nell''area di lavoro %1 \00E8 stato modificato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278994607538868507)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_language=>'it'
,p_message_text=>unistr('Non \00E8 stata definita alcuna etichetta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277836313131867775)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_language=>'it'
,p_message_text=>'Altro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277833894926867773)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277833623449867773)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_language=>'it'
,p_message_text=>unistr('La pagina non esiste pi\00F9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279055920356868547)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_language=>'it'
,p_message_text=>'Rimuovi tutto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278778242189868370)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_language=>'it'
,p_message_text=>'Rimuovi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277833481157867773)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_language=>'it'
,p_message_text=>'Associazione applicazione e pagina rimossa da'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277834198144867773)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_language=>'it'
,p_message_text=>'Allegato rimosso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279029753665868530)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_language=>'it'
,p_message_text=>'Sostituire il commento corrente con questo modello?'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279031756525868531)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Salve! ',
'',
unistr('Questo \00E8 il primo problema in assoluto. \00C8 possibile creare problemi per tenere traccia di task, funzioni, bug e feedback per tutti i progetti APEX personali. Utilizzando il linguaggio Markdown a sintassi abbreviata \00E8 possibile aggiungere etichette ai')
||' problemi, aggiungere assegnatari, impostare milestone e anche applicare la formattazione.  ',
'',
unistr('Di seguito viene illustrato un breve esempio delle possibilit\00E0 offerte dal linguaggio Markdown:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279031636430868531)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_language=>'it'
,p_message_text=>'Benvenuti in Team Development di Oracle APEX.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278778546724868370)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_language=>'it'
,p_message_text=>'- Seleziona -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277834233167867773)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_language=>'it'
,p_message_text=>'Imposta stato su'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277810629104867758)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_language=>'it'
,p_message_text=>'Mostra azioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279031534407868531)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_language=>'it'
,p_message_text=>'Mostra altri...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277833939925867773)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_language=>'it'
,p_message_text=>'Sottoscritto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278995039362868507)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_language=>'it'
,p_message_text=>'%2 nuove notifiche nell''area di lavoro %1 per %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278698723499868319)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_language=>'it'
,p_message_text=>'Modello utilizzato per registrare un bug.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278698692999868319)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_language=>'it'
,p_message_text=>'Modello bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278698535660868319)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Funzionamento previsto**',
'- Indicare cosa si ritiene si sia verificato.',
'',
'',
'**Funzionamento corrente**',
'- Indicare cosa realmente succede.',
'',
'',
'**Persone o elementi interessati**',
'- Comunicare le persone o gli elementi interessati. ',
'',
'**Possibile soluzione**',
'- Nei limiti del possibile, suggerire come si correggerebbe il bug.',
'',
'**Passi da riprodurre**',
'- Fornire in modo chiaro il set di passi da riprodurre, includendo screenshot e snippet di codice ove opportuno.',
'1.',
'2.',
'3.',
'',
'**Contesto**',
unistr('- Descrivere le caratteristiche dell''operazione in corso quando si \00E8 verificato il bug. Specificare se il bug si verifica solo in determinate condizioni, a certe ore del giorno e cos\00EC via.'),
'',
'**Ambiente**',
'',
'- Versione: ',
'- Piattaforma: ',
'- Sottosistema:',
'',
'______',
'',
'_**NOTA:** per associare un problema a un''applicazione e/o a una pagina, registrare in primo luogo il problema, quindi utilizzare l''elenco a discesa **AZIONI** per associare l''applicazione e la pagina._'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278699886081868320)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato rilevato un bug.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278699774587868320)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_language=>'it'
,p_message_text=>'Rilevato bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278699933232868320)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\00C8 stato registrato un **bug** nel sistema esterno appropriato.'),
'',
'- Sistema di registrazione bug: ',
'- ID bug: ',
'- URL del bug: ',
'',
'Commenti:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278698962975868320)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_language=>'it'
,p_message_text=>'Modello utilizzato per registrare una richiesta di funzione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278698801787868320)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_language=>'it'
,p_message_text=>'Modello richiesta funzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278699060282868320)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Riepilogo funzione**',
' - Fornire una panoramica generale di un solo paragrafo della richiesta di funzione.',
'',
'',
'**Contesto**',
unistr(' - Indicare se la richiesta riguarda una situazione o un processo specifici. Ad esempio, "L''esito \00E8 sempre negativo quando [...]"'),
'',
'',
unistr(' - Fornire tutte le informazioni di supporto possibili, allegando screenshot, casi d''uso e cos\00EC via.'),
'',
'',
'**Soluzione preferita**',
'- Fornire una descrizione chiara di cosa si desidera venga implementato.',
'',
'',
'**Soluzioni alternative**',
'- Fornire la descrizione delle soluzioni o delle funzioni alternative prese in considerazione o utilizzate.',
'',
'',
'______',
'_**NOTA:** per associare un problema a un''applicazione e/o a una pagina, registrare in primo luogo il problema, quindi utilizzare l''elenco a discesa **AZIONI** per associare l''applicazione e la pagina._'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278700183390868320)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stata presentata una richiesta di funzione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278700034536868320)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_language=>'it'
,p_message_text=>'Richiesta di funzione presentata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278700206191868320)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Una **richiesta di funzione** \00E8 stata presentata nel sistema esterno appropriato.'),
'',
'- Sistema di registrazione funzioni: ',
'- ID funzione: ',
'- URL della definizione della funzione: ',
'',
'Commenti:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278701002712868321)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 richiesta un''azione di follow-up.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278700934036868321)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_language=>'it'
,p_message_text=>'Azione di follow-up richiesta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278701173825868321)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Eseguire le azioni seguenti: ',
'',
'1.',
'2.',
'3.',
'4.',
'',
'Commenti: '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278699209257868320)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_language=>'it'
,p_message_text=>'Modello utilizzato per porre una domanda di procedura.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278699108045868320)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_language=>'it'
,p_message_text=>'Come...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278699302091868320)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'**Domanda**',
unistr('- Porre la domanda o la richiesta in modo pi\00F9 conciso possibile.'),
'',
'**Contesto generale**',
'- Specificare cosa si sta tentando di fare. ',
'',
'',
'- Indicare inoltre le ricerche effettuate o le persone contattate per trovare una risposta. ',
'',
'',
'**Ambiente** ',
'Specificare se la domanda riguarda in modo specifico un ambiente, un linguaggio di programmazione o un altro settore.',
'',
'______',
'_**NOTE:** per associare un problema a un''applicazione e/o a una pagina, registrare in primo luogo il problema, quindi utilizzare l''elenco a discesa **AZIONI** per associare l''applicazione e la pagina._'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278700718824868321)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_language=>'it'
,p_message_text=>'Riferimento a un problema noto.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278700648452868321)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_language=>'it'
,p_message_text=>'Problema noto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278700868780868321)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'L''analisi ha evidenziato che si tratta un problema noto. Vedere i dettagli riportati di seguito.',
'',
'- Sistema di registrazione bug: ',
'- ID bug: ',
'- URL del bug: ',
'',
'Commenti: '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278700475049868321)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_language=>'it'
,p_message_text=>'Richiesta di ulteriori informazioni.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278700324854868320)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_language=>'it'
,p_message_text=>'Sono necessarie ulteriori informazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278700510267868321)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**Sono necessarie pi\00F9 informazioni per questo problema:**'),
'',
'Fornire le informazioni richieste in basso. Senza queste informazioni risulta difficile classificare e tentare di risolvere il problema.',
'',
'',
'Commenti:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278699536998868320)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('Non verr\00E0 eseguita alcuna azione per il problema.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278699434921868320)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_language=>'it'
,p_message_text=>'Nessuna azione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278699658739868320)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Dopo un attento esame della situazione, **non verr\00E0 eseguita alcuna azione per questo problema**. '),
'',
'Commenti:'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277837371645867775)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_language=>'it'
,p_message_text=>'File di testo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277836268709867775)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_language=>'it'
,p_message_text=>'File di testo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277833029059867772)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_language=>'it'
,p_message_text=>'questo problema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278720657286868333)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_language=>'it'
,p_message_text=>'ha aggiunto l''allegato %0 a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278719611593868333)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_language=>'it'
,p_message_text=>'ha aggiunto %0 a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278721228139868334)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_language=>'it'
,p_message_text=>'ha aggiunto %0 a %1 %2				'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278719866868868333)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_language=>'it'
,p_message_text=>'ha assegnato %0 a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278720279416868333)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_language=>'it'
,p_message_text=>'ha associato %0 a %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277837583930867775)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_language=>'it'
,p_message_text=>'ha modificato un commento per %0	%1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278721145213868334)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_language=>'it'
,p_message_text=>unistr('Questo problema \00E8 stato nascosto.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278720070822868333)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_language=>'it'
,p_message_text=>'ha contrassegnato %0 come duplicato di %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278721080022868333)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_language=>'it'
,p_message_text=>'ha aperto %0 mediante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278720796397868333)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_language=>'it'
,p_message_text=>'ha rimosso l''allegato %0 da %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278719704888868333)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_language=>'it'
,p_message_text=>'ha rimosso %0 da %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278721329620868334)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_language=>'it'
,p_message_text=>'ha rimosso %0 da %1 %2 			'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278720889147868333)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_language=>'it'
,p_message_text=>'ha impostato lo stato per %0 su %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278720448987868333)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_language=>'it'
,p_message_text=>'ha eseguito la sottoscrizione a %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278719979321868333)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_language=>'it'
,p_message_text=>'ha annullato l''assegnazione di %0 in %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278720396306868333)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_language=>'it'
,p_message_text=>'ha rimosso l''associazione di applicazione e pagina da %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278720154698868333)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_language=>'it'
,p_message_text=>'ha annullato il contrassegno di %0 come duplicato di %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278720530862868333)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_language=>'it'
,p_message_text=>'ha annullato la sottoscrizione a %0 %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278720965220868333)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_language=>'it'
,p_message_text=>'ha contrassegnato come duplicato di %0 %1 %2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277833295342867773)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_language=>'it'
,p_message_text=>'Non assegnato/i'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277810509033867758)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_language=>'it'
,p_message_text=>'Mostra'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277834099205867773)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_language=>'it'
,p_message_text=>'Non sottoscritto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278762634853868360)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_language=>'it'
,p_message_text=>'Aggiorna...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277837142813867775)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_language=>'it'
,p_message_text=>'File ZIP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277836061652867774)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_language=>'it'
,p_message_text=>'File ZIP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279068994945868555)
,p_name=>'APEX.ITEM.FILE.BROWSE'
,p_message_language=>'it'
,p_message_text=>'Sfoglia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279066820695868554)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILE'
,p_message_language=>'it'
,p_message_text=>'Scegli file'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279066931794868554)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILES'
,p_message_language=>'it'
,p_message_text=>'Scegli file'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279171826128868621)
,p_name=>'APEX.ITEM.HELP_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo della Guida: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279024989465868527)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'Elemento %0 non trovato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277820614324867765)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di #LABEL# non \00E8 compreso nell''intervallo valido tra %0 e %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277820733782867765)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_MULTIPLE_OF_STEP'
,p_message_language=>'it'
,p_message_text=>unistr('#LABEL# non \00E8 multiplo di %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277820063959867764)
,p_name=>'APEX.ITEM_TYPE.YES_NO.INVALID_VALUE'
,p_message_language=>'it'
,p_message_text=>'#LABEL# deve corrispondere ai valori %0 e %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277820271791867764)
,p_name=>'APEX.ITEM_TYPE.YES_NO.NO_LABEL'
,p_message_language=>'it'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278479887596868181)
,p_name=>'APEX.ITEM_TYPE.YES_NO.OFF_LABEL'
,p_message_language=>'it'
,p_message_text=>'Non attivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278479903114868181)
,p_name=>'APEX.ITEM_TYPE.YES_NO.ON_LABEL'
,p_message_language=>'it'
,p_message_text=>'Attivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277820187899867764)
,p_name=>'APEX.ITEM_TYPE.YES_NO.YES_LABEL'
,p_message_language=>'it'
,p_message_text=>unistr('S\00EC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277791213846867746)
,p_name=>'APEX.LIST_MANAGER.ADD_ENTRY'
,p_message_language=>'it'
,p_message_text=>'Aggiungi voce'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278736718241868343)
,p_name=>'APEX.LIST_MANAGER.BUTTON_ADD'
,p_message_language=>'it'
,p_message_text=>'Aggiungi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278736846800868343)
,p_name=>'APEX.LIST_MANAGER.BUTTON_REMOVE'
,p_message_language=>'it'
,p_message_text=>'Rimuovi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277791390572867746)
,p_name=>'APEX.LIST_MANAGER.SELECTED_ENTRY'
,p_message_language=>'it'
,p_message_text=>'Voci selezionate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278968508862868490)
,p_name=>'APEX.LTO.ADVANCED'
,p_message_language=>'it'
,p_message_text=>'Avanzate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278968845316868491)
,p_name=>'APEX.LTO.CANCEL'
,p_message_language=>'it'
,p_message_text=>'Annulla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278968688406868491)
,p_name=>'APEX.LTO.COMMON'
,p_message_language=>'it'
,p_message_text=>'Comune'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278968945433868491)
,p_name=>'APEX.LTO.LIVE_TEMPLATE_OPTIONS'
,p_message_language=>'it'
,p_message_text=>'Opzioni modello attive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278970115858868492)
,p_name=>'APEX.LTO.NOT_APPLICABLE'
,p_message_language=>'it'
,p_message_text=>unistr('Opzioni modello non disponibili: questo componente non \00E8 visualizzato nella pagina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278968432274868490)
,p_name=>'APEX.LTO.NO_OPTIONS_FOUND'
,p_message_language=>'it'
,p_message_text=>'Nessuna opzione modello trovata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278968774497868491)
,p_name=>'APEX.LTO.SAVE'
,p_message_language=>'it'
,p_message_text=>'Salva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278966253990868489)
,p_name=>'APEX.MARKDOWN.BOLD'
,p_message_language=>'it'
,p_message_text=>'Grassetto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278967542867868490)
,p_name=>'APEX.MARKDOWN.IMAGE'
,p_message_language=>'it'
,p_message_text=>'Immagine'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278967158655868490)
,p_name=>'APEX.MARKDOWN.INLINE_CODE'
,p_message_language=>'it'
,p_message_text=>'Codice in linea'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279062039850868551)
,p_name=>'APEX.MARKDOWN.INSERT_IMAGE'
,p_message_language=>'it'
,p_message_text=>'Inserisci immagine'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279062177430868551)
,p_name=>'APEX.MARKDOWN.INSERT_LINK'
,p_message_language=>'it'
,p_message_text=>'Inserisci collegamento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278966349242868489)
,p_name=>'APEX.MARKDOWN.ITALIC'
,p_message_language=>'it'
,p_message_text=>'Corsivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279063866424868552)
,p_name=>'APEX.MARKDOWN.LINK'
,p_message_language=>'it'
,p_message_text=>'Collegamento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278967448776868490)
,p_name=>'APEX.MARKDOWN.LIST'
,p_message_language=>'it'
,p_message_text=>'Lista'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278967361019868490)
,p_name=>'APEX.MARKDOWN.ORDERED_LIST'
,p_message_language=>'it'
,p_message_text=>'Lista ordinata'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278966434613868489)
,p_name=>'APEX.MARKDOWN.PREVIEW'
,p_message_language=>'it'
,p_message_text=>'Anteprima'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278966987621868489)
,p_name=>'APEX.MARKDOWN.PREVIEW_EMPTY'
,p_message_language=>'it'
,p_message_text=>'Nessun elemento da visualizzare in anteprima'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278967037244868490)
,p_name=>'APEX.MARKDOWN.STRIKETHROUGH'
,p_message_language=>'it'
,p_message_text=>'Barrato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278967224092868490)
,p_name=>'APEX.MARKDOWN.UNORDERED_LIST'
,p_message_language=>'it'
,p_message_text=>'Lista non ordinata'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278594992184868254)
,p_name=>'APEX.MENU.CURRENT_MENU'
,p_message_language=>'it'
,p_message_text=>'corrente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279135198785868597)
,p_name=>'APEX.MENU.OVERFLOW_LABEL'
,p_message_language=>'it'
,p_message_text=>'Altro...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278594835445868254)
,p_name=>'APEX.MENU.PROCESSING'
,p_message_language=>'it'
,p_message_text=>'Caricamento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279045735383868541)
,p_name=>'APEX.NOTIFICATION_MESSAGE_HEADING'
,p_message_language=>'it'
,p_message_text=>'Messaggio di notifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277957013119867851)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore contenuto checksum messaggio di notifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277956986281867851)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore formato checksum messaggio di notifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278670444646868302)
,p_name=>'APEX.NUMBER_FIELD.VALUE_GREATER_MAX_VALUE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di #LABEL# \00E8 maggiore del valore massimo specificato %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278670568377868302)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID'
,p_message_language=>'it'
,p_message_text=>'Il valore di #LABEL# deve essere numerico.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278670615934868302)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID2'
,p_message_language=>'it'
,p_message_text=>'Il valore di #LABEL# non corrisponde al formato numerico %0 (ad esempio %1).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278670309689868302)
,p_name=>'APEX.NUMBER_FIELD.VALUE_LESS_MIN_VALUE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di #LABEL# \00E8 minore del valore minimo specificato %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278670294494868301)
,p_name=>'APEX.NUMBER_FIELD.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di #LABEL# non \00E8 compreso nell''intervallo valido tra %0 e %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278196028744868002)
,p_name=>'APEX.PAGE.DUPLICATE_SUBMIT'
,p_message_language=>'it'
,p_message_text=>unistr('Questa pagina \00E8 stata gi\00E0 sottomessa e non pu\00F2 essere sottomessa nuovamente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278058714198867915)
,p_name=>'APEX.PAGE.NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'Applicazione "%0": pagina "%1" non trovata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278339675999868092)
,p_name=>'APEX.PAGE_ITEM_IS_REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Specificare un valore per #LABEL#.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279075317844868559)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_language=>'it'
,p_message_text=>'Informazioni sull''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279075118009868559)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_language=>'it'
,p_message_text=>'Opzioni di configurazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279075250402868559)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_language=>'it'
,p_message_text=>'Selezione stile tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278737171379868344)
,p_name=>'APEX.POPUP_LOV.BUTTON_CLOSE'
,p_message_language=>'it'
,p_message_text=>'Chiudi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278737063439868343)
,p_name=>'APEX.POPUP_LOV.BUTTON_FIND'
,p_message_language=>'it'
,p_message_text=>'Trova %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278737333878868344)
,p_name=>'APEX.POPUP_LOV.BUTTON_NEXT'
,p_message_language=>'it'
,p_message_text=>'Successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278737223952868344)
,p_name=>'APEX.POPUP_LOV.BUTTON_PREV'
,p_message_language=>'it'
,p_message_text=>'Precedente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277814603569867761)
,p_name=>'APEX.POPUP_LOV.FILTER_REQ'
,p_message_language=>'it'
,p_message_text=>'Immettere un termine di ricerca di almeno %0 caratteri.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278388915341868123)
,p_name=>'APEX.POPUP_LOV.ICON_TEXT'
,p_message_language=>'it'
,p_message_text=>'Lista di valori popup: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277814786198867761)
,p_name=>'APEX.POPUP_LOV.INITIAL_FILTER_REQ'
,p_message_language=>'it'
,p_message_text=>'Immettere il termine di ricerca.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277814544951867761)
,p_name=>'APEX.POPUP_LOV.NO_RESULTS'
,p_message_language=>'it'
,p_message_text=>'Nessun risultato trovato.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277814439492867761)
,p_name=>'APEX.POPUP_LOV.REMOVE_VALUE'
,p_message_language=>'it'
,p_message_text=>'Rimuovi %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278557131154868230)
,p_name=>'APEX.POPUP_LOV.SEARCH'
,p_message_language=>'it'
,p_message_text=>'Termine di ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278736944185868343)
,p_name=>'APEX.POPUP_LOV.TITLE'
,p_message_language=>'it'
,p_message_text=>'Finestra di dialogo di ricerca'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277817275031867763)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_language=>'it'
,p_message_text=>'Impossibile richiamare il valore di chiave primaria successivo o precedente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278550196204868226)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>unistr('Il Web Service non \00E8 stato trovato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278060207918867916)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione del processo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279029371911868530)
,p_name=>'APEX.PROCESSING'
,p_message_language=>'it'
,p_message_text=>'Elaborazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277843948506867779)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Application Express non \00E8 stato in grado di elaborare la richiesta a causa delle risorse limitate disponibili per la sessione del database. Riprovare pi\00F9 tardi.'),
'<p/>',
'I dettagli relativi all''incidente sono disponibili tramite l''ID debug "%0".'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279086363621868566)
,p_name=>'APEX.REGION.CSSCALENDAR.ADD'
,p_message_language=>'it'
,p_message_text=>'Aggiungi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278508509360868199)
,p_name=>'APEX.REGION.CSSCALENDAR.ALL_DAY'
,p_message_language=>'it'
,p_message_text=>'Giornata intera'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279158679142868612)
,p_name=>'APEX.REGION.CSSCALENDAR.BUTTON.SENDEMAIL'
,p_message_language=>'it'
,p_message_text=>'Invia invito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279158347306868612)
,p_name=>'APEX.REGION.CSSCALENDAR.CHOOSE_ACTION'
,p_message_language=>'it'
,p_message_text=>'Opzioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278523615110868209)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_ALLDAY'
,p_message_language=>'it'
,p_message_text=>'Vista giornaliera per tutto il giorno '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278523449852868209)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_TIME_SPECIFIC'
,p_message_language=>'it'
,p_message_text=>'Vista giornaliera per dati con ora '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279048250822868542)
,p_name=>'APEX.REGION.CSSCALENDAR.DAY'
,p_message_language=>'it'
,p_message_text=>'Giorno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278995194974868507)
,p_name=>'APEX.REGION.CSSCALENDAR.DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Descrizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277906248932867819)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.CSV'
,p_message_language=>'it'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277906047992867819)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.ICALENDAR'
,p_message_language=>'it'
,p_message_text=>'iCal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277905930730867819)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.PDF'
,p_message_language=>'it'
,p_message_text=>'PDF'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277906187455867819)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.XML'
,p_message_language=>'it'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277905647834867818)
,p_name=>'APEX.REGION.CSSCALENDAR.ENDDATE'
,p_message_language=>'it'
,p_message_text=>'Data di fine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277905828348867819)
,p_name=>'APEX.REGION.CSSCALENDAR.EVENTNAME'
,p_message_language=>'it'
,p_message_text=>'Nome evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279158439836868612)
,p_name=>'APEX.REGION.CSSCALENDAR.INVITATION'
,p_message_language=>'it'
,p_message_text=>'Invito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279048370250868542)
,p_name=>'APEX.REGION.CSSCALENDAR.LIST'
,p_message_language=>'it'
,p_message_text=>'Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279048098269868542)
,p_name=>'APEX.REGION.CSSCALENDAR.MONTH'
,p_message_language=>'it'
,p_message_text=>'Mese'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279063099425868551)
,p_name=>'APEX.REGION.CSSCALENDAR.NEXT'
,p_message_language=>'it'
,p_message_text=>'Successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279116729799868586)
,p_name=>'APEX.REGION.CSSCALENDAR.NOEVENTS'
,p_message_language=>'it'
,p_message_text=>'Nessun evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279159029198868612)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.FORM'
,p_message_language=>'it'
,p_message_text=>'Modifica un evento esistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279158909559868612)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.SEND'
,p_message_language=>'it'
,p_message_text=>'Invio di un invito mediante posta elettronica.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279063197391868551)
,p_name=>'APEX.REGION.CSSCALENDAR.PREVIOUS'
,p_message_language=>'it'
,p_message_text=>'Precedente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279102408153868576)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL'
,p_message_language=>'it'
,p_message_text=>'Invia messaggio di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279102016448868576)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.BUTTON'
,p_message_language=>'it'
,p_message_text=>'Invia messaggio di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279166092933868617)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Tutti i campi sono obbligatori.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279165970124868617)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.TITLE'
,p_message_language=>'it'
,p_message_text=>'Invia invito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279158011536868612)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.SUBJECT'
,p_message_language=>'it'
,p_message_text=>'Oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279102377411868576)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.TO'
,p_message_language=>'it'
,p_message_text=>'A'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277905747237867818)
,p_name=>'APEX.REGION.CSSCALENDAR.STARTDATE'
,p_message_language=>'it'
,p_message_text=>'Data di inizio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279083083810868564)
,p_name=>'APEX.REGION.CSSCALENDAR.TABLEFORM'
,p_message_language=>'it'
,p_message_text=>'Form su %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278523261166868209)
,p_name=>'APEX.REGION.CSSCALENDAR.TIME'
,p_message_language=>'it'
,p_message_text=>'Ora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279063771008868552)
,p_name=>'APEX.REGION.CSSCALENDAR.TODAY'
,p_message_language=>'it'
,p_message_text=>'Oggi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279049199083868543)
,p_name=>'APEX.REGION.CSSCALENDAR.VIEW'
,p_message_language=>'it'
,p_message_text=>'Visualizza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279048176323868542)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEK'
,p_message_language=>'it'
,p_message_text=>'Settimana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278523585375868209)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_ALLDAY'
,p_message_language=>'it'
,p_message_text=>'Vista settimanale per tutto il giorno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278523331961868209)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_TIME_SPECIFIC'
,p_message_language=>'it'
,p_message_text=>'Vista settimanale per dati con ora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279048723051868542)
,p_name=>'APEX.REGION.CSSCALENDAR.YEAR'
,p_message_language=>'it'
,p_message_text=>'Anno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277817568055867763)
,p_name=>'APEX.REGION.FLASH_CHART.INITIALIZING'
,p_message_language=>'it'
,p_message_text=>'Inizializzazione in corso...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278076949640867926)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_DATA'
,p_message_language=>'it'
,p_message_text=>'Caricamento dati in corso...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279087842056868567)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_RESOURCES'
,p_message_language=>'it'
,p_message_text=>'Caricamento delle risorse in corso...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279087992412868567)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_TEMPLATES'
,p_message_language=>'it'
,p_message_text=>'Caricamento dei modelli in corso...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277817687999867763)
,p_name=>'APEX.REGION.FLASH_CHART.NO_DATA_FOUND'
,p_message_language=>'it'
,p_message_text=>'Nessun dato trovato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277982454728867867)
,p_name=>'APEX.REGION.FLASH_CHART.SHOW_XML'
,p_message_language=>'it'
,p_message_text=>'Mostra XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278077001672867926)
,p_name=>'APEX.REGION.FLASH_CHART.WAITING'
,p_message_language=>'it'
,p_message_text=>'Caricamento dei dati in corso. Attendere.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279048470657868542)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279048526857868542)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.LOAD_MORE'
,p_message_language=>'it'
,p_message_text=>'Carica altro...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278249386762868035)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.BACK'
,p_message_language=>'it'
,p_message_text=>'Indietro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277845442327867780)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.LOAD_MORE'
,p_message_language=>'it'
,p_message_text=>'Carica altro...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277870415085867796)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.SEARCH'
,p_message_language=>'it'
,p_message_text=>'Cerca...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279048643118868542)
,p_name=>'APEX.REGION.JQM_REFLOW.LOAD_MORE'
,p_message_language=>'it'
,p_message_text=>'Carica altro...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279062316657868551)
,p_name=>'APEX.REGION.NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'ID area %0 non trovato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277856610872867787)
,p_name=>'APEX.REGION.NO_DATA_FOUND_MESSAGE'
,p_message_language=>'it'
,p_message_text=>'Nessun dato trovato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278064626650867919)
,p_name=>'APEX.REGION.PAGINATION.RESET_ERROR'
,p_message_language=>'it'
,p_message_text=>'Impossibile reimpostare l''impaginazione per l''area.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277817457649867763)
,p_name=>'APEX.REGION.PAGINATION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''impostazione dell''impaginazione dell''area.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278989809054868504)
,p_name=>'APEX.REGION.RESPONSIVE_TABLE.COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279062299909868551)
,p_name=>'APEX.REGION.TYPE_NOT_SUPPORTED'
,p_message_language=>'it'
,p_message_text=>unistr('Il tipo di area %0 non \00E8 supportato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277817328890867763)
,p_name=>'APEX.REGION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante la presentazione dell''area "#COMPONENT_NAME#".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278339767981868092)
,p_name=>'APEX.REGION_COLUMN_IS_REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Specificare un valore per #COLUMN_HEADER#.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278519874427868206)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_language=>'it'
,p_message_text=>'Autenticazione non riuscita per il servizio SQL abilitato per REST.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277844270209867780)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_language=>'it'
,p_message_text=>unistr('Autenticazione non riuscita. La lista di valori utilizza un''origine dati SQL abilitata per REST che fa riferimento a credenziali Web non valide. Ci\00F2 impedir\00E0 di modificare le informazioni sulla colonna per questa LOV. Controllare le credenziali di au')
||'tenticazione. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279058142878868548)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_language=>'it'
,p_message_text=>unistr('Errore di comunicazione. Durante il richiamo dell''origine dati SQL abilitato per REST a cui fa riferimento la lista di valori, si \00E8 verificato un problema che impedisce di modificare le informazioni delle colonne per la lista di valori. Controllare c')
||'he l''origine dati SQL abilitato per REST funzioni correttamente e che le credenziali di autenticazione corrispondenti siano corrette.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278587535035868249)
,p_name=>'APEX.REMOTESQL.OAUTH_IS_RECOMMENDED'
,p_message_language=>'it'
,p_message_text=>'Avvertenza: Oracle consiglia l''uso delle credenziali del client OAuth per l''autenticazione con SQL abilitato per REST.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278521235423868207)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore nel server remoto: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278478048558868180)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'Istanza di SQL abilitato per REST ORDS specificata non trovata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278079294540867928)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_language=>'it'
,p_message_text=>'Il server ha inviato un reindirizzamento a: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278367224715868110)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_language=>'it'
,p_message_text=>unistr('L''istruzione SQL \00E8 pi\00F9 lunga di 32,767 byte.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278387177400868122)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Salve, Application Express. Si \00E8 connessi come #USER#.'),
unistr('L''indicatore orario del database locale \00E8: #SYSDATE#.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278715214292868330)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_language=>'it'
,p_message_text=>unistr('Si sta modificando l''alias per lo schema predefinito dell''area di lavoro. L''impostazione di questo alias comporter\00E0 anche la modifica del prefisso di percorso a livello di area di lavoro. Questa operazione avr\00E0 effetto sull''URL per tutti i servizi RE')
||'STful basati su APEX che potrebbero essere stati definiti.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278374494401868114)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ORDS'
,p_message_language=>'it'
,p_message_text=>'La versione ORDS corrente non supporta l''interfaccia di amministrazione REST.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278374569390868114)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ROLE'
,p_message_language=>'it'
,p_message_text=>unistr('Il ruolo client specificato non \00E8 supportato dall''interfaccia di amministrazione REST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279153844739868609)
,p_name=>'APEX.RICH_TEXT_EDITOR.ACCESSIBLE_LABEL'
,p_message_language=>'it'
,p_message_text=>'%0, Rich Text Editor'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278364870904868108)
,p_name=>'APEX.RICH_TEXT_EDITOR.MAXIMUM_LENGTH_EXCEEDED'
,p_message_language=>'it'
,p_message_text=>'Il markup HTML Rich Text supera la lunghezza massima dell''elemento (caratteri effettivi: %0, caratteri consentiti: %1)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279047064938868541)
,p_name=>'APEX.RV.DELETE'
,p_message_language=>'it'
,p_message_text=>'Elimina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278972832815868493)
,p_name=>'APEX.RV.DUPLICATE'
,p_message_language=>'it'
,p_message_text=>'Duplicato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278968006829868490)
,p_name=>'APEX.RV.EXCLUDE_HIDDEN'
,p_message_language=>'it'
,p_message_text=>'Colonne visualizzate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278967955614868490)
,p_name=>'APEX.RV.EXCLUDE_NULL'
,p_message_language=>'it'
,p_message_text=>'Escludi valori nulli'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279047144953868541)
,p_name=>'APEX.RV.INSERT'
,p_message_language=>'it'
,p_message_text=>'Aggiungi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278507246029868198)
,p_name=>'APEX.RV.MOVE_DOWN'
,p_message_language=>'it'
,p_message_text=>'Sposta in basso'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278507355022868198)
,p_name=>'APEX.RV.MOVE_UP'
,p_message_language=>'it'
,p_message_text=>'Sposta in alto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278967735623868490)
,p_name=>'APEX.RV.NEXT_RECORD'
,p_message_language=>'it'
,p_message_text=>'Successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278968388242868490)
,p_name=>'APEX.RV.NOT_GROUPED_LABEL'
,p_message_language=>'it'
,p_message_text=>'Altre colonne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278967822164868490)
,p_name=>'APEX.RV.PREV_RECORD'
,p_message_language=>'it'
,p_message_text=>'Precedente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278968151724868490)
,p_name=>'APEX.RV.REC_X'
,p_message_language=>'it'
,p_message_text=>'Riga %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278968200218868490)
,p_name=>'APEX.RV.REC_XY'
,p_message_language=>'it'
,p_message_text=>'Riga %0 di %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278972979394868493)
,p_name=>'APEX.RV.REFRESH'
,p_message_language=>'it'
,p_message_text=>'Aggiorna'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278973079897868493)
,p_name=>'APEX.RV.REVERT'
,p_message_language=>'it'
,p_message_text=>'Annulla modifiche'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278967668818868490)
,p_name=>'APEX.RV.SETTINGS_MENU'
,p_message_language=>'it'
,p_message_text=>'Menu Impostazioni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278442027694868157)
,p_name=>'APEX.SAMPLE_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Ad esempio, %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278364908001868108)
,p_name=>'APEX.SC.REFERENCES'
,p_message_language=>'it'
,p_message_text=>'%0 riferimenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278706508082868324)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_language=>'it'
,p_message_text=>'Utility'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278706651406868324)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Utility dell''applicazione\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278714044658868329)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_language=>'it'
,p_message_text=>'Vai a pagina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278713977501868329)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_language=>'it'
,p_message_text=>'Vai a Componenti condivisi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278706778407868324)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_language=>'it'
,p_message_text=>'App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278706850574868325)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_language=>'it'
,p_message_text=>'Task App Builder > '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278706953858868325)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Elementi di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278707004145868325)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Elementi di applicazione\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278707194091868325)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_language=>'it'
,p_message_text=>'Logica applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278707222010868325)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_language=>'it'
,p_message_text=>'Schemi di autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278707399354868325)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Sicurezza - Schemi di autenticazione\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278707471807868325)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_language=>'it'
,p_message_text=>'Schemi di autorizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278707582327868325)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Sicurezza - Schemi di autorizzazione\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278707625904868325)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_language=>'it'
,p_message_text=>'Indicatori di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278707751440868325)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Indicatori di percorso\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278707879275868325)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_language=>'it'
,p_message_text=>'Opzioni di creazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278707922942868325)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Opzioni di creazione\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278708094512868325)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278708109310868325)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Impostazioni componente\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278708206879868325)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_language=>'it'
,p_message_text=>'Calcoli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278708366406868325)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Calcoli di applicazione\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278708446432868326)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_language=>'it'
,p_message_text=>'Crea elemento di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278708571246868326)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_language=>'it'
,p_message_text=>'Crea schema di autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278708678717868326)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_language=>'it'
,p_message_text=>'Crea opzione di creazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278708784870868326)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_language=>'it'
,p_message_text=>'Crea calcolo applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278708827459868326)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Crea modello di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278708962554868326)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_language=>'it'
,p_message_text=>'Crea plugin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278709070397868326)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_language=>'it'
,p_message_text=>'Crea tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278709136484868326)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_language=>'it'
,p_message_text=>'Crea credenziali Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278709277921868326)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_language=>'it'
,p_message_text=>'Definizioni caricamento dati'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278709357985868326)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Definizioni caricamento dati\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278709413088868326)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_language=>'it'
,p_message_text=>'Origini dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278709557662868326)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_language=>'it'
,p_message_text=>'Attributi definizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278709694525868326)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_language=>'it'
,p_message_text=>'Modelli di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278709729292868326)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_language=>'it'
,p_message_text=>'Layout report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278709899012868326)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Layout report\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278709980208868326)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_language=>'it'
,p_message_text=>'Web Service precedenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278710036809868327)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Web Service precedenti\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278710108652868327)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_language=>'it'
,p_message_text=>'Liste di navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278710245025868327)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Liste di navigazione classiche\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278710313177868327)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_language=>'it'
,p_message_text=>'Lista di valori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278710495324868327)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Lista di valori\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278710586571868327)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_language=>'it'
,p_message_text=>'Navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278710610387868327)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_language=>'it'
,p_message_text=>'Altri componenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278710739025868327)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_language=>'it'
,p_message_text=>'Plugin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278710807044868327)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Plugin\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278710973787868327)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_language=>'it'
,p_message_text=>'Processi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278711054620868327)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Processi di applicazione\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278711141687868327)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_language=>'it'
,p_message_text=>'Query report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278711230868868327)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Query report\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278711346077868327)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_language=>'it'
,p_message_text=>'Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278711478458868327)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_language=>'it'
,p_message_text=>'SQL abilitato per REST'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278711513419868327)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\SQL abilitato per REST\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278711636379868328)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_language=>'it'
,p_message_text=>'Sicurezza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278711723495868328)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_language=>'it'
,p_message_text=>'Protezione stato sessione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278711837784868328)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_language=>'it'
,p_message_text=>'Imposta protezione stato applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278712001013868328)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_language=>'it'
,p_message_text=>'Componenti condivisi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278712175060868328)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278712233832868328)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_language=>'it'
,p_message_text=>'Scorciatoie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278712349114868328)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Scorciatoie\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278712440399868328)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_language=>'it'
,p_message_text=>'Schede (precedenti)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278712523315868328)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_language=>'it'
,p_message_text=>'Modelli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278712653946868328)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Interfaccia utente - Modelli\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278712799163868328)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_language=>'it'
,p_message_text=>'Temi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278712861803868328)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Interfaccia utente - Temi\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278712991792868328)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_language=>'it'
,p_message_text=>'Interfaccia utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278713018257868328)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_language=>'it'
,p_message_text=>'Credenziali Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278713111784868329)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Sicurezza - Credenziali Web\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278713244269868329)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_language=>'it'
,p_message_text=>'Moduli di origine Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278713375132868329)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Andare a: Componenti condivisi\Moduli di origine Web\%LIST_ITEM_NAME%'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278713497668868329)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_language=>'it'
,p_message_text=>'SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278713541658868329)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_language=>'it'
,p_message_text=>'Crea oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278713652109868329)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Crea %LIST_ITEM_NAME% in SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278713717955868329)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_language=>'it'
,p_message_text=>'Editor degli script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278713816754868329)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_language=>'it'
,p_message_text=>'Task SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279096317697868572)
,p_name=>'APEX.SESSION.DB_SESSION_CLEANUP.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione del codice di cleanup della sessione del database.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278058282607867914)
,p_name=>'APEX.SESSION.DB_SESSION_INIT.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione del codice di impostazione della sessione del database.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277831955516867772)
,p_name=>'APEX.SESSION.EXPIRED'
,p_message_language=>'it'
,p_message_text=>'Sessione scaduta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279088079983868567)
,p_name=>'APEX.SESSION.EXPIRED.CLOSE_DIALOG'
,p_message_language=>'it'
,p_message_text=>'Chiudere questa finestra di dialogo e fare clic sul pulsante di ricaricamento del browser per ottenere una nuova sessione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279148257764868606)
,p_name=>'APEX.SESSION.EXPIRED.NEW_SESSION'
,p_message_language=>'it'
,p_message_text=>'Fare clic <a href="%0">qui</a> per creare una nuova sessione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278511327182868201)
,p_name=>'APEX.SESSION.RAS.NO_DYNAMIC_ROLES'
,p_message_language=>'it'
,p_message_text=>unistr('Non \00E8 stato possibile abilitare alcun ruolo dinamico nella sessione Real Application Security per l''utente "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278051149997867910)
,p_name=>'APEX.SESSION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'ERR-99900 Impossibile creare un ID sessione univoco: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279159349884868613)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_language=>'it'
,p_message_text=>unistr('L''elemento di pagina %0 si basa su una colonna di database, ma l''attributo ''Origine utilizzata'' \00E8 impostato su ''Solo se il valore corrente dello stato di sessione \00E8 NULL''. Ci\00F2 \00E8 molto pericoloso e potrebbe causare la sovrascrittura involontaria dei d')
||unistr('ati quando di visualizzato e salvano pi\00F9 record. Impostare sempre ''Origine utilizzata'' su ''Sempre (sostituisci qualsiasi valore esistente nello stato di sessione)''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279068818252868555)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_language=>'it'
,p_message_text=>unistr('L''accesso allo stato della sessione \00E8 disabilitato, un tentativo di lettura/scrittura \00E8 stato bloccato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277869541931867796)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_language=>'it'
,p_message_text=>'Tentativo di salvataggio dell''elemento %0 nello stato delle sessioni durante l''elaborazione della visualizzazione: l''elemento ha una protezione "solo interna".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277850938475867784)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_language=>'it'
,p_message_text=>unistr('Tentativo di salvataggio dell''elemento %0 nello stato delle sessioni durante l''elaborazione dell''accettazione: l''elemento ha una protezione "solo interna" o non \00E8 un elemento di form che pu\00F2 essere inviato tramite POST.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278125472974867957)
,p_name=>'APEX.SESSION_STATE.ITEM_VALUE_PROTECTION'
,p_message_language=>'it'
,p_message_text=>unistr('Violazione della protezione dello stato sessione. Ci\00F2 potrebbe essere causato dalla modifica manuale dell''elemento di pagina protetto %0. Se non si \00E8 certi della causa dell''errore, contattare l''amministratore dell''applicazione per assistenza.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279184384571868629)
,p_name=>'APEX.SESSION_STATE.PAGE_PROTECTION'
,p_message_language=>'it'
,p_message_text=>unistr('Violazione della protezione della pagina. Ci\00F2 potrebbe essere causato dalla sottomissione di una pagina il cui caricamento era ancora in corso oppure dalla modifica manuale degli elementi di pagina protetti. Contattare l''amministratore dell''applicazi')
||'one per assistenza.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279181227320868627)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR'
,p_message_language=>'it'
,p_message_text=>'%0 contiene uno dei caratteri non validi seguenti: &<>"/;,*|=% o --'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279181354582868627)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR_NL'
,p_message_language=>'it'
,p_message_text=>'%0 contiene uno dei caratteri non validi seguenti: &<>"/;,*|=% o -- o nuova riga.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279181034828868626)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.US_ONLY'
,p_message_language=>'it'
,p_message_text=>'%0 contiene caratteri speciali. Sono consentiti solo i caratteri a-Z, 0-9 e gli spazi.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279181173866868627)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'it'
,p_message_text=>'%0 contiene <, > o ", ovvero caratteri non validi.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277850580173867784)
,p_name=>'APEX.SESSION_STATE.SSP_CHECKSUM_MISSING'
,p_message_language=>'it'
,p_message_text=>unistr('Non \00E8 stato fornito nessun checksum per visualizzare l''elaborazione di una pagina che richiede un checksum se vengono passati valori di richiesta, di svuotamento di cache o di argomento come parametri.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278112483621867949)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION'
,p_message_language=>'it'
,p_message_text=>unistr('Violazione della protezione dello stato sessione. Ci\00F2 potrebbe esse causato da una modifica manuale di un URL che contiene un checksum o dall''utilizzo di un collegamento con un checksum errato o mancante. Se non si \00E8 certi della causa dell''errore, co')
||'ntattare l''amministratore dell''applicazione per assistenza.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277850693708867784)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Il checksum calcolato sui valori di richiesta, di svuotamento di cache, di nome di argomento o di argomento (%0) non corrispondono al checksum passato nella procedura di visualizzazione (%1).',
'',
'Nota: agli utenti finali viene visualizzato un messaggio di errore diverso.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277849571213867783)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Tentativo di salvataggio dell''elemento %0 nello stato delle sessioni durante l''elaborazione della visualizzazione. Il livello di protezione dell''elemento \00E8:'),
'%1.',
'',
unistr('Non \00E8 stato passato alcun checksum oppure il checksum \00E8 adatto a un elemento con livello di protezione "%2".'),
'',
'Nota: agli utenti finali viene visualizzato un messaggio di errore diverso.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278060007024867916)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'ERR-1022 Impossibile salvare gli attributi.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278969057303868491)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_OFF'
,p_message_language=>'it'
,p_message_text=>unistr('Disattiva modalit\00E0 contrasto elevato')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278969178279868491)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_ON'
,p_message_language=>'it'
,p_message_text=>unistr('Attiva modalit\00E0 contrasto elevato')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278084853116867931)
,p_name=>'APEX.SHUTTLE.CONTROL_BOTTOM'
,p_message_language=>'it'
,p_message_text=>'In basso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278085079679867931)
,p_name=>'APEX.SHUTTLE.CONTROL_DOWN'
,p_message_language=>'it'
,p_message_text=>'Inattivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278085141189867931)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE'
,p_message_language=>'it'
,p_message_text=>'Sposta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278085263484867931)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE_ALL'
,p_message_language=>'it'
,p_message_text=>'Sposta tutto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278085317886867931)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE'
,p_message_language=>'it'
,p_message_text=>'Rimuovi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278085464397867932)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE_ALL'
,p_message_language=>'it'
,p_message_text=>'Rimuovi tutto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278085515080867932)
,p_name=>'APEX.SHUTTLE.CONTROL_RESET'
,p_message_language=>'it'
,p_message_text=>'Reimposta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278084779068867931)
,p_name=>'APEX.SHUTTLE.CONTROL_TOP'
,p_message_language=>'it'
,p_message_text=>'Inizio pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278084956569867931)
,p_name=>'APEX.SHUTTLE.CONTROL_UP'
,p_message_language=>'it'
,p_message_text=>'Su'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279122214680868589)
,p_name=>'APEX.SINCE.SHORT.DAYS_AGO'
,p_message_language=>'it'
,p_message_text=>'%0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279122956299868590)
,p_name=>'APEX.SINCE.SHORT.DAYS_FROM_NOW'
,p_message_language=>'it'
,p_message_text=>'tra %0 giorno/i'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279122184647868589)
,p_name=>'APEX.SINCE.SHORT.HOURS_AGO'
,p_message_language=>'it'
,p_message_text=>'%0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279123004512868590)
,p_name=>'APEX.SINCE.SHORT.HOURS_FROM_NOW'
,p_message_language=>'it'
,p_message_text=>'tra %0 ora/e'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279121989535868589)
,p_name=>'APEX.SINCE.SHORT.MINUTES_AGO'
,p_message_language=>'it'
,p_message_text=>'%0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279123192137868590)
,p_name=>'APEX.SINCE.SHORT.MINUTES_FROM_NOW'
,p_message_language=>'it'
,p_message_text=>'tra %0 minuto/i'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279122580751868589)
,p_name=>'APEX.SINCE.SHORT.MONTHS_AGO'
,p_message_language=>'it'
,p_message_text=>'%0 mese/i'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279122799664868589)
,p_name=>'APEX.SINCE.SHORT.MONTHS_FROM_NOW'
,p_message_language=>'it'
,p_message_text=>'tra %0 mese/i'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279122025452868589)
,p_name=>'APEX.SINCE.SHORT.SECONDS_AGO'
,p_message_language=>'it'
,p_message_text=>'%0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279122882137868589)
,p_name=>'APEX.SINCE.SHORT.SECONDS_FROM_NOW'
,p_message_language=>'it'
,p_message_text=>'tra %0 secondo/i'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279122339812868589)
,p_name=>'APEX.SINCE.SHORT.WEEKS_AGO'
,p_message_language=>'it'
,p_message_text=>'%0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279123217659868590)
,p_name=>'APEX.SINCE.SHORT.WEEKS_FROM_NOW'
,p_message_language=>'it'
,p_message_text=>'tra %0 settimana/e'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279122469528868589)
,p_name=>'APEX.SINCE.SHORT.YEARS_AGO'
,p_message_language=>'it'
,p_message_text=>'%0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279122619232868589)
,p_name=>'APEX.SINCE.SHORT.YEARS_FROM_NOW'
,p_message_language=>'it'
,p_message_text=>'tra %0 anno/i'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278298637137868066)
,p_name=>'APEX.SPLITTER.COLLAPSE_TEXT'
,p_message_language=>'it'
,p_message_text=>'Comprimi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278298505972868066)
,p_name=>'APEX.SPLITTER.RESTORE_TEXT'
,p_message_language=>'it'
,p_message_text=>'Ripristina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278705594942868324)
,p_name=>'APEX.STAR_RATING.CLEAR_RATING'
,p_message_language=>'it'
,p_message_text=>'Cancella valutazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278669576549868301)
,p_name=>'APEX.STAR_RATING.INVALID_RATING_RANGE'
,p_message_language=>'it'
,p_message_text=>unistr('%0 non \00E8 compreso nell''intervallo di valutazione 1 - %1 valido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278669658793868301)
,p_name=>'APEX.STAR_RATING.IS_NOT_NUMERIC'
,p_message_language=>'it'
,p_message_text=>unistr('%0 non \00E8 numerico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278641558169868283)
,p_name=>'APEX.SUCCESS_MESSAGE_HEADING'
,p_message_language=>'it'
,p_message_text=>'Messaggio di operazione completata'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277957241783867851)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore contenuto checksum messaggio di operazione riuscita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277957123933867851)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore formato checksum messaggio di operazione riuscita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279153441428868609)
,p_name=>'APEX.TABS.NEXT'
,p_message_language=>'it'
,p_message_text=>'Successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279153359483868609)
,p_name=>'APEX.TABS.PREVIOUS'
,p_message_language=>'it'
,p_message_text=>'Precedente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277808600745867757)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_language=>'it'
,p_message_text=>'Errore durante il calcolo del valore predefinito per la colonna #COMPONENT_NAME#.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277809226494867758)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>unistr('Errore durante l''elaborazione del processo di eliminazione di pi\00F9 righe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278094278698867937)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 richiesta una colonna di checksum ("FCS") ma non \00E8 stata fornita')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278094427118867937)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_language=>'it'
,p_message_text=>unistr('Non \00E8 stato fornito alcun valore di chiave primaria. Per eseguire gli aggiornamenti, \00E8 necessario fornire almeno una riga.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278095264422867938)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_language=>'it'
,p_message_text=>unistr('Non \00E8 stato fornito alcun valore secondario per la colonna chiave secondaria identificata')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278212101512868012)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_language=>'it'
,p_message_text=>'nessun dato trovato nel form tabulare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278094117834867937)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_language=>'it'
,p_message_text=>unistr('La colonna della chiave primaria non \00E8 stata specificata')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278095122376867938)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_language=>'it'
,p_message_text=>unistr('La colonna chiave secondaria identificata non \00E8 stata individuata nella lista di selezione della query')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278094057217867937)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_language=>'it'
,p_message_text=>'Nome tabella non specificato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278093976112867937)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_language=>'it'
,p_message_text=>'Proprietario tabella non specificato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278116257570867951)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>unistr('Errore durante l''elaborazione del processo di aggiornamento di pi\00F9 righe.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279116832093868586)
,p_name=>'APEX.TB.TOOLBAR'
,p_message_language=>'it'
,p_message_text=>'Barra degli strumenti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277977507858867864)
,p_name=>'APEX.TEAM.COMMITTED'
,p_message_language=>'it'
,p_message_text=>'Commit eseguito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277977371917867864)
,p_name=>'APEX.TEAM.CONTRIBUTOR'
,p_message_language=>'it'
,p_message_text=>'Collaboratore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277979265331867865)
,p_name=>'APEX.TEAM.CREATE'
,p_message_language=>'it'
,p_message_text=>'Funzione %0 aggiunta.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277979340342867865)
,p_name=>'APEX.TEAM.DELETE'
,p_message_language=>'it'
,p_message_text=>'Funzione %0 eliminata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277799652092867752)
,p_name=>'APEX.TEAM.DEPRECATED'
,p_message_language=>'it'
,p_message_text=>unistr('APEX Team Development non \00E8 pi\00F9 valido a partire dalla versione 19.2 e verr\00E0 rimosso da una release futura. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277977660214867864)
,p_name=>'APEX.TEAM.ESTIMATED_EFFORT'
,p_message_language=>'it'
,p_message_text=>'Impegno stimato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277977998066867864)
,p_name=>'APEX.TEAM.FEATURE_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Descrizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277977144688867863)
,p_name=>'APEX.TEAM.FEATURE_NAME'
,p_message_language=>'it'
,p_message_text=>'Funzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277977718278867864)
,p_name=>'APEX.TEAM.FEATURE_STATUS'
,p_message_language=>'it'
,p_message_text=>'Stato funzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277977883756867864)
,p_name=>'APEX.TEAM.MILESTONE'
,p_message_language=>'it'
,p_message_text=>'Milestone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277978166513867864)
,p_name=>'APEX.TEAM.NO'
,p_message_language=>'it'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277977220816867863)
,p_name=>'APEX.TEAM.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277977489684867864)
,p_name=>'APEX.TEAM.RELEASE'
,p_message_language=>'it'
,p_message_text=>'Release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277976218125867863)
,p_name=>'APEX.TEAM.SAVE'
,p_message_language=>'it'
,p_message_text=>'Funzione %0 aggiornata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277978062978867864)
,p_name=>'APEX.TEAM.YES'
,p_message_language=>'it'
,p_message_text=>unistr('S\00EC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279156261232868611)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_NAV_LABEL'
,p_message_language=>'it'
,p_message_text=>'Espandi/comprimi navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279156346523868611)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_SIDE_COL_LABEL'
,p_message_language=>'it'
,p_message_text=>'Espandi/comprimi colonna laterale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277832358341867772)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_language=>'it'
,p_message_text=>'Impossibile copiare il tema "%0" nell''applicazione "%1".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279148713395868606)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Il tema importato non \00E8 compatibile con il tema corrente.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279114521653868584)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_language=>'it'
,p_message_text=>unistr('Il numero del tema non \00E8 valido oppure il tema non \00E8 un tema dell''interfaccia utente corrente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278438482297868155)
,p_name=>'APEX.TIME.DAY'
,p_message_language=>'it'
,p_message_text=>'1 giorno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278438278148868155)
,p_name=>'APEX.TIME.HOUR'
,p_message_language=>'it'
,p_message_text=>'1 ora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278438544069868155)
,p_name=>'APEX.TIME.N_DAYS'
,p_message_language=>'it'
,p_message_text=>'%0 giorni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278438314879868155)
,p_name=>'APEX.TIME.N_HOURS'
,p_message_language=>'it'
,p_message_text=>'%0 ore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278438122021868155)
,p_name=>'APEX.TIME.N_MINUTES'
,p_message_language=>'it'
,p_message_text=>'%0 minuti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278438780629868155)
,p_name=>'APEX.TIME.N_WEEKS'
,p_message_language=>'it'
,p_message_text=>'%0 settimane'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278438645702868155)
,p_name=>'APEX.TIME.WEEK'
,p_message_language=>'it'
,p_message_text=>'1 settimana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279067989350868554)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Colonne Chiave primaria e Chiave padre richieste per il calcolo della gerarchia.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279068089024868555)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Colonna livello nodo e Colonna stato nodo richieste quando la gerarchia non viene calcolata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279175945078868623)
,p_name=>'APEX.UI.BACK_TO_TOP'
,p_message_language=>'it'
,p_message_text=>'Inizio della pagina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277993643472867874)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_language=>'it'
,p_message_text=>unistr('Modalit\00E0 scuro')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277993858981867874)
,p_name=>'APEX.UI.DISABLED'
,p_message_language=>'it'
,p_message_text=>'Disabilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277993753528867874)
,p_name=>'APEX.UI.ENABLED'
,p_message_language=>'it'
,p_message_text=>'Abilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278433329262868152)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Selezionare un''interfaccia utente dalla lista riportata di seguito:'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278435810682868153)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.TITLE'
,p_message_language=>'it'
,p_message_text=>'%0 - Selezione interfaccia utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277808983262867757)
,p_name=>'APEX.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione della richiesta.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277953885985867849)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_language=>'it'
,p_message_text=>'Accesso non autorizzato (variabile di package del gruppo di sicurezza non impostata).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277954455718867849)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_language=>'it'
,p_message_text=>'Impossibile recuperare o trovare le informazioni sull''utente. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277941674485867841)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_language=>'it'
,p_message_text=>'L''utente %0 richiede il privilegio ADMIN per eseguire questa operazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277954314387867849)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_language=>'it'
,p_message_text=>'L''utente %0 non ha fornito un indirizzo di posta elettronica.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277909813841867821)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_language=>'it'
,p_message_text=>'Accesso non autorizzato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277954276768867849)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'L''utente %0 non esiste.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278060160890867916)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''elaborazione della convalida.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278442326571868157)
,p_name=>'APEX.VALUE_REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Valore obbligatorio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279165554107868617)
,p_name=>'APEX.WAIT_UNTIL_PAGE_LOADED'
,p_message_language=>'it'
,p_message_text=>'Attendere il caricamento completo della pagina e riprovare.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278989492742868504)
,p_name=>'APEX.WARN_ON_UNSAVED_CHANGES'
,p_message_language=>'it'
,p_message_text=>'Questa pagina contiene modifiche non salvate.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279069361154868555)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_language=>'it'
,p_message_text=>unistr('Application Express non \00E8 in grado di calcolare un profilo dati da un tipo di dati di risposta: %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278500147239868194)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_language=>'it'
,p_message_text=>'Tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278500026036868194)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_language=>'it'
,p_message_text=>'Riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279053207843868545)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_language=>'it'
,p_message_text=>unistr('L''espressione di filtro non \00E8 una notazione JSON valida.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279044953777868540)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_language=>'it'
,p_message_text=>'Filtro non supportato da Oracle REST Data Services.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278386629336868122)
,p_name=>'APEX.WEBSRC.HIDE_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Nascondi colonne selezionate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278479550413868181)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_language=>'it'
,p_message_text=>'HTTP 200: operazione riuscita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278479656371868181)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_language=>'it'
,p_message_text=>'HTTP 201: creato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278479038511868180)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_language=>'it'
,p_message_text=>'HTTP 400: richiesta non valida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278478887411868180)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_language=>'it'
,p_message_text=>'HTTP 401: non autorizzato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278479113130868180)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_language=>'it'
,p_message_text=>'HTTP 403: vietato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278478914573868180)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_language=>'it'
,p_message_text=>'HTTP 404: non trovato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278479271193868181)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_language=>'it'
,p_message_text=>'HTTP 405: metodo non consentito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277798818179867751)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_language=>'it'
,p_message_text=>'HTTP 407: richiesta autenticazione proxy'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277799115047867751)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_language=>'it'
,p_message_text=>'HTTP 409: conflitto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277798939095867751)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_language=>'it'
,p_message_text=>'HTTP 412: precondizione non riuscita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277799055419867751)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_language=>'it'
,p_message_text=>'HTTP 428: richiesta precondizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278479342805868181)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_language=>'it'
,p_message_text=>'HTTP 500: errore server interno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278479492509868181)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_language=>'it'
,p_message_text=>'HTTP 502: gateway non valido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279069792470868556)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_language=>'it'
,p_message_text=>'HTTP 503: servizio non disponibile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279069896487868556)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_language=>'it'
,p_message_text=>'HTTP 504: timeout del gateway'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278989341666868504)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_language=>'it'
,p_message_text=>'L''origine Web ha restituito un errore HTTP: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278477955242868180)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'Modulo di origine Web non trovato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278022237773867892)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_language=>'it'
,p_message_text=>'Il selettore di righe "%0" non ha selezionato un array di oggetti da trattare come tabella.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278022344914867892)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_language=>'it'
,p_message_text=>'Il selettore di righe "%0" non ha selezionato un oggetto da trattare come riga singola.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278989202596868504)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_language=>'it'
,p_message_text=>'Il parametro obbligatorio IN "%0" di tipo "%1" dell''origine Web deve avere un valore.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278971896558868493)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_language=>'it'
,p_message_text=>unistr('Il corpo della risposta \00E8 troppo grande per essere visualizzato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278386821621868122)
,p_name=>'APEX.WEBSRC.SHOW_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Mostra colonne selezionate'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278442226103868157)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'it'
,p_message_text=>'Il servizio REST ORDS precedente utilizza dimensioni pagina fisse piccole.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278387276953868122)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_language=>'it'
,p_message_text=>'Timeout superato durante il recupero di tutti i dati di origine Web.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278361931955868106)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_language=>'it'
,p_message_text=>'I filtri SQL locali correnti richiedono un numero eccessivo di richieste "Pagina successiva" al servizio REST.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278442105467868157)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'it'
,p_message_text=>'Dimensioni pagina fisse sconosciute per il servizio REST ORDS precedente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279093756497868571)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'La colonna di griglia interattiva ''%0'' specificata per l''azione dinamica ''#COMPONENT_NAME#'' non esiste.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279093924571868571)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_language=>'it'
,p_message_text=>unistr('Il processo ''%0'' ha restituito ''%1'' durante l''esecuzione del blocco delle righe. Questo errore pu\00F2 verificarsi quando il processo esegue SELECT FOR UPDATE su una vista complessa con un trigger instead-of per bloccare la riga. Impostare l''attributo di')
||' processo ''Blocca riga'' su No o su Codice PL/SQL.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279093841151868571)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_language=>'it'
,p_message_text=>unistr('Il processo ''%0'' ha restituito ''%1'' durante l''esecuzione di un comando DML. Questo errore pu\00F2 verificarsi quando una colonna \00E8 basata su un''aggregazione o su un''espressione SQL. Impostare l''attributo di colonna ''Solo query'' su Yes (S\00EC) per escludere ')
||'la colonna dalle istruzioni INSERT e UPDATE.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278757910009868357)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_language=>'it'
,p_message_text=>'La colonna master-detail ''%0'' non contiene alcun valore. Accertarsi che il processo ''%1'' sia eseguito dopo il corrispondente processo dell''area master.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279075519644868559)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_language=>'it'
,p_message_text=>'La griglia interattiva ''%0'' non dispone di una colonna master definita, necessaria per una relazione master-detail.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278431648192868151)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_language=>'it'
,p_message_text=>'La griglia interattiva ''%0'' non dispone di una colonna chiave primaria definita, necessaria in una relazione master-detail o per eseguire operazioni di modifica.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279047291205868541)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_language=>'it'
,p_message_text=>'Per una griglia interattiva modificabile, l''attributo di pagina ''Ricarica se si fa clic su Sottometti'' deve essere impostato su ''Solo per operazione riuscita''.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279047343456868542)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_language=>'it'
,p_message_text=>'Per un form tabulare, l''attributo di pagina ''Ricarica se si fa clic su Sottometti'' deve essere impostato su ''Sempre''.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277989337565867871)
,p_name=>'APEXIR_3D'
,p_message_language=>'it'
,p_message_text=>'3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279082654815868564)
,p_name=>'APEXIR_ACTIONS'
,p_message_language=>'it'
,p_message_text=>'Azioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278210052264868010)
,p_name=>'APEXIR_ACTIONS_MENU'
,p_message_language=>'it'
,p_message_text=>'Menu Azioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278114949347867950)
,p_name=>'APEXIR_ADD'
,p_message_language=>'it'
,p_message_text=>'Aggiungi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278199630521868004)
,p_name=>'APEXIR_ADD_FUNCTION'
,p_message_language=>'it'
,p_message_text=>'Aggiungi funzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278199584245868004)
,p_name=>'APEXIR_ADD_GROUP_BY_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Aggiungi colonna Raggruppa per'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278524046391868209)
,p_name=>'APEXIR_ADD_PIVOT_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Aggiungi colonna pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278524137770868209)
,p_name=>'APEXIR_ADD_ROW_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Aggiungi colonna righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278687818421868313)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Aggiungi sottoscrizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277989579526867871)
,p_name=>'APEXIR_AGGREGATE'
,p_message_language=>'it'
,p_message_text=>'Aggrega'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278234096081868025)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Gli aggregati vengono visualizzati dopo ogni interruzione di controllo e alla fine del report.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278237140913868027)
,p_name=>'APEXIR_AGGREGATION'
,p_message_language=>'it'
,p_message_text=>'Aggregazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278115499362867951)
,p_name=>'APEXIR_AGG_AVG'
,p_message_language=>'it'
,p_message_text=>'Media'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278124380713867956)
,p_name=>'APEXIR_AGG_COUNT'
,p_message_language=>'it'
,p_message_text=>'Conteggio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278141375323867967)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_language=>'it'
,p_message_text=>'Conteggio distinti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278115557118867951)
,p_name=>'APEXIR_AGG_MAX'
,p_message_language=>'it'
,p_message_text=>'Massimo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278115723199867951)
,p_name=>'APEXIR_AGG_MEDIAN'
,p_message_language=>'it'
,p_message_text=>'Mediana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278115641148867951)
,p_name=>'APEXIR_AGG_MIN'
,p_message_language=>'it'
,p_message_text=>'Minimo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278115871474867951)
,p_name=>'APEXIR_AGG_MODE'
,p_message_language=>'it'
,p_message_text=>unistr('Modalit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278115317002867950)
,p_name=>'APEXIR_AGG_SUM'
,p_message_language=>'it'
,p_message_text=>'Somma %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278117134857867952)
,p_name=>'APEXIR_ALL'
,p_message_language=>'it'
,p_message_text=>'Tutto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277988507199867871)
,p_name=>'APEXIR_ALL_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Tutte le colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277839349150867776)
,p_name=>'APEXIR_ALL_ROWS'
,p_message_language=>'it'
,p_message_text=>'Tutte le righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279079121145868562)
,p_name=>'APEXIR_ALTERNATIVE'
,p_message_language=>'it'
,p_message_text=>'Alternativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279081204267868563)
,p_name=>'APEXIR_ALTERNATIVE_DEFAULT_NAME'
,p_message_language=>'it'
,p_message_text=>'Predefinito alternativo:  %0 '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278075299004867925)
,p_name=>'APEXIR_AND'
,p_message_language=>'it'
,p_message_text=>'e'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277996032504867875)
,p_name=>'APEXIR_APPLY'
,p_message_language=>'it'
,p_message_text=>'Applica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279045184651868540)
,p_name=>'APEXIR_AREA'
,p_message_language=>'it'
,p_message_text=>'Ad aree'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277959972313867852)
,p_name=>'APEXIR_ASCENDING'
,p_message_language=>'it'
,p_message_text=>'Crescente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278087700389867933)
,p_name=>'APEXIR_AS_OF'
,p_message_language=>'it'
,p_message_text=>'Come %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279081839109868563)
,p_name=>'APEXIR_AVERAGE_X'
,p_message_language=>'it'
,p_message_text=>'Media %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279045051171868540)
,p_name=>'APEXIR_BAR'
,p_message_language=>'it'
,p_message_text=>'A barre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277992446733867873)
,p_name=>'APEXIR_BETWEEN'
,p_message_language=>'it'
,p_message_text=>'tra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277958605282867852)
,p_name=>'APEXIR_BGCOLOR'
,p_message_language=>'it'
,p_message_text=>'Colore sfondo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278684834724868311)
,p_name=>'APEXIR_BLACK'
,p_message_language=>'it'
,p_message_text=>'Nero'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277960783391867853)
,p_name=>'APEXIR_BLUE'
,p_message_language=>'it'
,p_message_text=>'blu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278202419668868006)
,p_name=>'APEXIR_BOTTOM'
,p_message_language=>'it'
,p_message_text=>'In basso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278116714692867951)
,p_name=>'APEXIR_CALENDAR'
,p_message_language=>'it'
,p_message_text=>'Calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277961315888867853)
,p_name=>'APEXIR_CANCEL'
,p_message_language=>'it'
,p_message_text=>'Annulla'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278001458918867879)
,p_name=>'APEXIR_CATEGORY'
,p_message_language=>'it'
,p_message_text=>'Categoria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277958571605867852)
,p_name=>'APEXIR_CELL'
,p_message_language=>'it'
,p_message_text=>'Cella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278116675552867951)
,p_name=>'APEXIR_CHART'
,p_message_language=>'it'
,p_message_text=>'Grafico'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278205649670868008)
,p_name=>'APEXIR_CHART_INITIALIZING'
,p_message_language=>'it'
,p_message_text=>'Inizializzazione in corso...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278559919114868232)
,p_name=>'APEXIR_CHART_LABEL_NOT_NULL'
,p_message_language=>'it'
,p_message_text=>'Specificare l''etichetta del grafico.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278672485695868303)
,p_name=>'APEXIR_CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'it'
,p_message_text=>'La query supera il numero massimo di %0 datapoint per grafico. Applicare un filtro per ridurre il numero di record nella query di base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278666412700868299)
,p_name=>'APEXIR_CHART_MAX_ROW_CNT'
,p_message_language=>'it'
,p_message_text=>'Il conteggio massimo di righe per una query di tipo Grafico limita il numero di righe nella query di base, non il numero di righe visualizzate. La query di base supera il conteggio massimo di righe pari a %0 righe. Applicare un filtro per ridurre il '
||'numero di record nella query di base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277988886760867871)
,p_name=>'APEXIR_CHART_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278642287132868284)
,p_name=>'APEXIR_CHECK_ALL'
,p_message_language=>'it'
,p_message_text=>'Seleziona tutto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278088128536867933)
,p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Scegliere il formato di download dei report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278190845322867998)
,p_name=>'APEXIR_CLEAR'
,p_message_language=>'it'
,p_message_text=>'cancella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277961241717867853)
,p_name=>'APEXIR_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278234128551868026)
,p_name=>'APEXIR_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279061312890868550)
,p_name=>'APEXIR_COLUMN_FILTER'
,p_message_language=>'it'
,p_message_text=>'Filtra...'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278200501070868004)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_language=>'it'
,p_message_text=>'Intestazione colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278194555538868001)
,p_name=>'APEXIR_COLUMN_HEADING_MENU'
,p_message_language=>'it'
,p_message_text=>'Menu Intestazione colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278205474096868008)
,p_name=>'APEXIR_COLUMN_INFO'
,p_message_language=>'it'
,p_message_text=>'Informazioni colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279071528229868557)
,p_name=>'APEXIR_COLUMN_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278200282173868004)
,p_name=>'APEXIR_COLUMN_N'
,p_message_language=>'it'
,p_message_text=>'Colonna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278069598772867922)
,p_name=>'APEXIR_COMPARISON_CONTAINS'
,p_message_language=>'it'
,p_message_text=>'contiene'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278074266932867925)
,p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN'
,p_message_language=>'it'
,p_message_text=>'non contiene'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277959603960867852)
,p_name=>'APEXIR_COMPARISON_IN'
,p_message_language=>'it'
,p_message_text=>'in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278074431175867925)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST'
,p_message_language=>'it'
,p_message_text=>unistr('non \00E8 negli ultimi')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278119874069867953)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT'
,p_message_language=>'it'
,p_message_text=>unistr('non \00E8 nei prossimi')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278074393622867925)
,p_name=>'APEXIR_COMPARISON_IS_IN_LAST'
,p_message_language=>'it'
,p_message_text=>unistr('\00E8 negli ultimi')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278119787358867953)
,p_name=>'APEXIR_COMPARISON_IS_IN_NEXT'
,p_message_language=>'it'
,p_message_text=>unistr('\00E8 nei prossimi')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277959518429867852)
,p_name=>'APEXIR_COMPARISON_IS_NOT_NULL'
,p_message_language=>'it'
,p_message_text=>unistr('non \00E8 nullo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277959417040867852)
,p_name=>'APEXIR_COMPARISON_IS_NULL'
,p_message_language=>'it'
,p_message_text=>unistr('\00E8 nullo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277959212447867852)
,p_name=>'APEXIR_COMPARISON_LIKE'
,p_message_language=>'it'
,p_message_text=>'simile a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277959766800867852)
,p_name=>'APEXIR_COMPARISON_NOT_IN'
,p_message_language=>'it'
,p_message_text=>'non contenuta in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277959304531867852)
,p_name=>'APEXIR_COMPARISON_NOT_LIKE'
,p_message_language=>'it'
,p_message_text=>'non simile a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278070212572867922)
,p_name=>'APEXIR_COMPARISON_REGEXP_LIKE'
,p_message_language=>'it'
,p_message_text=>'corrisponde all''espressione regolare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278088026270867933)
,p_name=>'APEXIR_COMPUTATION'
,p_message_language=>'it'
,p_message_text=>'Calcolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278666010509868299)
,p_name=>'APEXIR_COMPUTATION_EXPRESSION'
,p_message_language=>'it'
,p_message_text=>'Espressione di calcolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278234455514868026)
,p_name=>'APEXIR_COMPUTATION_FOOTER'
,p_message_language=>'it'
,p_message_text=>'Creare un calcolo utilizzando alias di colonna.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278234579459868026)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E1'
,p_message_language=>'it'
,p_message_text=>'(B+C)*100'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278234617073868026)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E2'
,p_message_language=>'it'
,p_message_text=>'INITCAP(B)||'', ''||INITCAP(C)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278234782771868026)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E3'
,p_message_language=>'it'
,p_message_text=>'CASE WHEN A = 10 THEN B + C ELSE B END'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277826650908867769)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E4'
,p_message_language=>'it'
,p_message_text=>'ROUND(C / 1000000)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278117881721867952)
,p_name=>'APEXIR_COMPUTE'
,p_message_language=>'it'
,p_message_text=>'Calcola'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278201271006868005)
,p_name=>'APEXIR_CONTROL_BREAK'
,p_message_language=>'it'
,p_message_text=>'Interruzione di controllo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278209414476868010)
,p_name=>'APEXIR_CONTROL_BREAKS'
,p_message_language=>'it'
,p_message_text=>'Interruzioni di controllo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279089978156868568)
,p_name=>'APEXIR_CONTROL_BREAK_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne di interruzione controllo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277818849099867764)
,p_name=>'APEXIR_COUNT_DISTINCT'
,p_message_language=>'it'
,p_message_text=>'Conteggio distinti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279082354915868564)
,p_name=>'APEXIR_COUNT_DISTINCT_X'
,p_message_language=>'it'
,p_message_text=>'Conteggio distinti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279082254349868564)
,p_name=>'APEXIR_COUNT_X'
,p_message_language=>'it'
,p_message_text=>'Conteggio %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278685332365868311)
,p_name=>'APEXIR_DAILY'
,p_message_language=>'it'
,p_message_text=>'Giornaliero'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279174878481868622)
,p_name=>'APEXIR_DATA'
,p_message_language=>'it'
,p_message_text=>'Dati'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278205507134868008)
,p_name=>'APEXIR_DATA_AS_OF'
,p_message_language=>'it'
,p_message_text=>unistr('Dati del report cos\00EC come si presentavano %0 minuti fa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279036639748868535)
,p_name=>'APEXIR_DATA_GRID_HELP'
,p_message_language=>'it'
,p_message_text=>'Guida per le griglie dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277989772221867871)
,p_name=>'APEXIR_DATE'
,p_message_language=>'it'
,p_message_text=>'Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279080807366868563)
,p_name=>'APEXIR_DAY'
,p_message_language=>'it'
,p_message_text=>'Giorno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278231729359868024)
,p_name=>'APEXIR_DEFAULT'
,p_message_language=>'it'
,p_message_text=>'Valore predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279078984936868561)
,p_name=>'APEXIR_DEFAULT_REPORT_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di report predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277961479099867853)
,p_name=>'APEXIR_DELETE'
,p_message_language=>'it'
,p_message_text=>'Elimina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278118632623867953)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_language=>'it'
,p_message_text=>'Elimina selezione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277990693069867872)
,p_name=>'APEXIR_DELETE_CONFIRM'
,p_message_language=>'it'
,p_message_text=>'Eliminare queste impostazioni di report?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278235947140868027)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_language=>'it'
,p_message_text=>'Eseguire questa azione di eliminazione?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278969650530868491)
,p_name=>'APEXIR_DELETE_DEFAULT_REPORT'
,p_message_language=>'it'
,p_message_text=>'Elimina report predefinito'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278200902430868005)
,p_name=>'APEXIR_DELETE_REPORT'
,p_message_language=>'it'
,p_message_text=>'Elimina report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277960067600867852)
,p_name=>'APEXIR_DESCENDING'
,p_message_language=>'it'
,p_message_text=>'Decrescente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278001514831867879)
,p_name=>'APEXIR_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Descrizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278194496145868001)
,p_name=>'APEXIR_DETAIL_VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista a riga singola'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278232728823868025)
,p_name=>'APEXIR_DIRECTION'
,p_message_language=>'it'
,p_message_text=>'Direzione %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278209962987868010)
,p_name=>'APEXIR_DISABLE'
,p_message_language=>'it'
,p_message_text=>'Disabilita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278233903423868025)
,p_name=>'APEXIR_DISABLED'
,p_message_language=>'it'
,p_message_text=>'Disabilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277989891295867871)
,p_name=>'APEXIR_DISPLAY'
,p_message_language=>'it'
,p_message_text=>'Visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277960903455867853)
,p_name=>'APEXIR_DISPLAYED'
,p_message_language=>'it'
,p_message_text=>'Visualizzato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277988476465867871)
,p_name=>'APEXIR_DISPLAYED_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne visualizzate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278232631577868025)
,p_name=>'APEXIR_DISPLAY_IN_REPORT'
,p_message_language=>'it'
,p_message_text=>'Visualizza nel report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277961672854867854)
,p_name=>'APEXIR_DONUT'
,p_message_language=>'it'
,p_message_text=>'Ciambella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278202333166868006)
,p_name=>'APEXIR_DOWN'
,p_message_language=>'it'
,p_message_text=>'Inattivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278117923992867952)
,p_name=>'APEXIR_DOWNLOAD'
,p_message_language=>'it'
,p_message_text=>'Scarica'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277989666074867871)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_language=>'it'
,p_message_text=>'- Non aggregare -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278232581680868025)
,p_name=>'APEXIR_DO_NOT_DISPLAY'
,p_message_language=>'it'
,p_message_text=>'Non visualizzare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279090152493868569)
,p_name=>'APEXIR_DUPLICATE_PIVOT_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna pivot duplicata. La colonna pivot deve essere univoca.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279090576578868569)
,p_name=>'APEXIR_EDIT'
,p_message_language=>'it'
,p_message_text=>'Modifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279029242222868530)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_language=>'it'
,p_message_text=>'Modifica valore predefinito alternativo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278205745993868008)
,p_name=>'APEXIR_EDIT_CHART'
,p_message_language=>'it'
,p_message_text=>'Modifica impostazioni grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278235724515868027)
,p_name=>'APEXIR_EDIT_CHART2'
,p_message_language=>'it'
,p_message_text=>'Modifica grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278236292598868027)
,p_name=>'APEXIR_EDIT_FILTER'
,p_message_language=>'it'
,p_message_text=>'Modifica filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278732123881868340)
,p_name=>'APEXIR_EDIT_GROUP_BY'
,p_message_language=>'it'
,p_message_text=>'Modifica raggruppamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278236154063868027)
,p_name=>'APEXIR_EDIT_HIGHLIGHT'
,p_message_language=>'it'
,p_message_text=>'Modifica evidenziazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278548878573868225)
,p_name=>'APEXIR_EDIT_PIVOT'
,p_message_language=>'it'
,p_message_text=>'Modifica pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279079224293868562)
,p_name=>'APEXIR_EMAIL'
,p_message_language=>'it'
,p_message_text=>'Posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277904553724867818)
,p_name=>'APEXIR_EMAIL_ADDRESS'
,p_message_language=>'it'
,p_message_text=>'Indirizzo di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279079588176868562)
,p_name=>'APEXIR_EMAIL_BCC'
,p_message_language=>'it'
,p_message_text=>'Ccn'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279079724580868562)
,p_name=>'APEXIR_EMAIL_BODY'
,p_message_language=>'it'
,p_message_text=>'Corpo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279079491351868562)
,p_name=>'APEXIR_EMAIL_CC'
,p_message_language=>'it'
,p_message_text=>'Cc'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279080406073868562)
,p_name=>'APEXIR_EMAIL_FREQUENCY'
,p_message_language=>'it'
,p_message_text=>'Frequenza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277939362517867840)
,p_name=>'APEXIR_EMAIL_NOT_CONFIGURED'
,p_message_language=>'it'
,p_message_text=>'Posta elettronica non configurata per questa applicazione. Contattare l''amministratore.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278684446559868310)
,p_name=>'APEXIR_EMAIL_REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Specificare l''indirizzo di posta elettronica.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279079849126868562)
,p_name=>'APEXIR_EMAIL_SEE_ATTACHED'
,p_message_language=>'it'
,p_message_text=>'Vedere l''allegato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279079674035868562)
,p_name=>'APEXIR_EMAIL_SUBJECT'
,p_message_language=>'it'
,p_message_text=>'Oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278686355693868312)
,p_name=>'APEXIR_EMAIL_SUBJECT_REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Specificare l''oggetto del messaggio di posta elettronica.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279079324926868562)
,p_name=>'APEXIR_EMAIL_TO'
,p_message_language=>'it'
,p_message_text=>'A'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278209852833868010)
,p_name=>'APEXIR_ENABLE'
,p_message_language=>'it'
,p_message_text=>'Abilita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277958300151867851)
,p_name=>'APEXIR_ENABLED'
,p_message_language=>'it'
,p_message_text=>'Abilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278236076924868027)
,p_name=>'APEXIR_ENABLE_DISABLE_ALT'
,p_message_language=>'it'
,p_message_text=>'Abilita/disabilita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278235484795868026)
,p_name=>'APEXIR_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278234875173868026)
,p_name=>'APEXIR_EXAMPLES'
,p_message_language=>'it'
,p_message_text=>'Esempi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278235815255868027)
,p_name=>'APEXIR_EXAMPLES_WITH_COLON'
,p_message_language=>'it'
,p_message_text=>'Esempi:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277988340117867871)
,p_name=>'APEXIR_EXCLUDE_NULL'
,p_message_language=>'it'
,p_message_text=>'Escludi valori nulli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278236776302868027)
,p_name=>'APEXIR_EXPAND_COLLAPSE_ALT'
,p_message_language=>'it'
,p_message_text=>'Espandi/comprimi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278233609021868025)
,p_name=>'APEXIR_EXPRESSION'
,p_message_language=>'it'
,p_message_text=>'Espressione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278117499840867952)
,p_name=>'APEXIR_FILTER'
,p_message_language=>'it'
,p_message_text=>'Filtra'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278209336108868010)
,p_name=>'APEXIR_FILTERS'
,p_message_language=>'it'
,p_message_text=>'Filtri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278293886470868063)
,p_name=>'APEXIR_FILTER_EXPRESSION'
,p_message_language=>'it'
,p_message_text=>'Espressione di filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279156789906868611)
,p_name=>'APEXIR_FILTER_EXPR_TOO_LONG'
,p_message_language=>'it'
,p_message_text=>unistr('L''espressione di filtro \00E8 troppo lunga.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278293738331868063)
,p_name=>'APEXIR_FILTER_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278236981498868027)
,p_name=>'APEXIR_FINDER_ALT'
,p_message_language=>'it'
,p_message_text=>'Selezionare le colonne in cui cercare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278117760368867952)
,p_name=>'APEXIR_FLASHBACK'
,p_message_language=>'it'
,p_message_text=>'Flashback'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278233311337868025)
,p_name=>'APEXIR_FLASHBACK_DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>unistr('La funzione Flashback query consente di visualizzare i dati cos\00EC come si presentavano in un precedente point-in-time.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278235221295868026)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_language=>'it'
,p_message_text=>'Impossibile eseguire la richiesta di flashback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278685000765868311)
,p_name=>'APEXIR_FLASHBACK_LABEL'
,p_message_language=>'it'
,p_message_text=>'Durata flashback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278693690932868316)
,p_name=>'APEXIR_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278087965741867933)
,p_name=>'APEXIR_FORMAT_MASK'
,p_message_language=>'it'
,p_message_text=>'Formato di visualizzazione %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278200629634868005)
,p_name=>'APEXIR_FUNCTION'
,p_message_language=>'it'
,p_message_text=>'Funzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278234337576868026)
,p_name=>'APEXIR_FUNCTIONS'
,p_message_language=>'it'
,p_message_text=>'Funzioni %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279078884577868561)
,p_name=>'APEXIR_FUNCTIONS_OPERATORS'
,p_message_language=>'it'
,p_message_text=>'Funzioni/operatori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278666576209868299)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna funzione %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278200148560868004)
,p_name=>'APEXIR_FUNCTION_N'
,p_message_language=>'it'
,p_message_text=>'Funzione %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278117287755867952)
,p_name=>'APEXIR_GO'
,p_message_language=>'it'
,p_message_text=>'Vai'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278684908727868311)
,p_name=>'APEXIR_GRAY'
,p_message_language=>'it'
,p_message_text=>'Grigio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277958838282867852)
,p_name=>'APEXIR_GREEN'
,p_message_language=>'it'
,p_message_text=>'verde'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277818972113867764)
,p_name=>'APEXIR_GROUP_BY'
,p_message_language=>'it'
,p_message_text=>'Raggruppa per'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279079935569868562)
,p_name=>'APEXIR_GROUP_BY_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Raggruppa per colonna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278560035166868232)
,p_name=>'APEXIR_GROUP_BY_COL_NOT_NULL'
,p_message_language=>'it'
,p_message_text=>'Specificare la colonna Raggruppa per.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278666377168868299)
,p_name=>'APEXIR_GROUP_BY_MAX_ROW_CNT'
,p_message_language=>'it'
,p_message_text=>'Il conteggio massimo di righe per una query di tipo Raggruppa per limita il numero di righe nella query di base, non il numero di righe visualizzate. La query di base supera il conteggio massimo di righe pari a %0 righe. Applicare un filtro per ridur'
||'re il numero di record nella query di base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278480420833868181)
,p_name=>'APEXIR_GROUP_BY_SORT'
,p_message_language=>'it'
,p_message_text=>'Raggruppa per ordinamento'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279090026056868569)
,p_name=>'APEXIR_GROUP_BY_SORT_ORDER'
,p_message_language=>'it'
,p_message_text=>'Raggruppa per criterio ordinamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277988947935867871)
,p_name=>'APEXIR_HCOLUMN'
,p_message_language=>'it'
,p_message_text=>'A colonne orizzontali'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278227178652868021)
,p_name=>'APEXIR_HELP'
,p_message_language=>'it'
,p_message_text=>'Guida'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278192780389868000)
,p_name=>'APEXIR_HELP_01'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('I report interattivi consentono agli utenti finali di personalizzare i report. \00C8 possibile modificare il layout dei dati del report selezionando le colonne desiderate, applicando filtri, evidenziando e ordinando gli elementi. Gli utenti possono inolt')
||unistr('re definire interruzioni, aggregazioni, grafici e raggruppamenti nonch\00E9 aggiungere calcoli. \00C8 inoltre possibile impostare una sottoscrizione per inviare via posta elettronica una versione HTML del report in base all''intervallo specificato. Gli utenti')
||' possono creare varie versioni del report e salvarle come report denominati, visualizzabili pubblicamente o privatamente. ',
'<p/>',
unistr('Le sezioni seguenti contengono il riepilogo delle varie modalit\00E0 di personalizzazione di un report interattivo. Per ulteriori informazioni, vedere "Uso dei report interattivi" in <i>Guida per l''utente finale di Oracle Application Express</i></a>.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278210127101868010)
,p_name=>'APEXIR_HELP_ACTIONS_MENU'
,p_message_language=>'it'
,p_message_text=>unistr('Il menu Azioni \00E8 visualizzato a destra del pulsante Vai nella barra di ricerca. Utilizzare questo menu per personalizzare un report interattivo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278193788920868000)
,p_name=>'APEXIR_HELP_AGGREGATE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Gli aggregati sono calcoli matematici eseguiti su una colonna. Gli aggregati vengono visualizzati dopo ogni interruzione di controllo e alla fine del report all''interno della colonna in cui sono definiti. Opzioni disponibili:',
'<p>',
'</p><ul>',
'<li><b>Aggregazione</b>: consente di selezionare un''aggregazione definita',
'in precedenza per modificarla.</li>',
'<li><b>Funzione</b>: la funzione da eseguire (ad esempio SUM, MIN).</li>',
'<li><b>Colonna</b>: consente di selezionare la colonna a cui applicare la funzione matematica. Verranno visualizzate solo le',
'colonne numeriche.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278193859138868000)
,p_name=>'APEXIR_HELP_CHART'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\00C8 possibile definire un grafico per report salvato. Dopo aver definito'),
unistr('il grafico, \00E8 possibile alternare le viste grafico e report utilizzando le icone specifiche della barra di ricerca.'),
'Di seguito sono riportate le opzioni disponibili.',
'<p>',
'</p><ul>',
'<li><b>Tipo di grafico</b>: identifica il tipo di grafico da includere.',
'Selezionare tra grafico a barre orizzontali, a barre verticali, a torta o a linee.</li>',
'<li><b>Etichetta</b>: consente di selezionare la colonna da utilizzare come etichetta.</li>',
unistr('<li><b>Titolo asse per etichetta</b>: il titolo che verr\00E0 visualizzato sull''asse associato alla colonna selezionata'),
'per Etichetta. Non disponibile per il grafico a torta.</li>',
'<li><b>Valore</b>: consente di selezionare la colonna da utilizzare come valore. Se la funzione',
unistr('\00E8 COUNT, non \00E8 necessario selezionare un valore.</li>'),
unistr('<li><b>Titolo asse per valore</b>: il titolo che verr\00E0 visualizzato sull''asse associato alla colonna selezionata'),
'per Valore. Non disponibile per il grafico a torta.</li>',
'<li><b>Funzione</b>: funzione facoltativa da eseguire sulla colonna selezionata per Valore.</li>',
'<li><b>Ordina</b>: consente di ordinare il set di risultati.</li></ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278193166340868000)
,p_name=>'APEXIR_HELP_COLUMN_HEADING_MENU'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Quando si fa clic su un''intestazione di colonna qualsiasi viene visualizzato un menu Intestazione colonna. Opzioni disponibili:',
'<p></p>',
'<ul>',
'<li><b>Icona Ordinamento crescente</b>: ordina il report in base alla colonna con ordinamento crescente.</li>',
'<li><b>Icona Ordinamento decrescente</b>: ordina il report in base alla colonna con ordinamento decrescente.</li>',
unistr('<li><b>Nascondi colonna</b>: nasconde la colonna. Non tutte le colonne possono essere nascoste. Se non \00E8 possibile nascondere una colonna, non sar\00E0 presente l''icona Nascondi colonna.</li>'),
'<li><b>Colonna di interruzione</b>: crea un gruppo di interruzione sulla colonna. La colonna viene estratta dal report e visualizzata come record principale.</li>',
'<li><b>Informazioni colonna</b>: visualizza il testo della Guida relativo alla colonna, se disponibile.</li>',
'<li><b>Area di testo</b>: questa voce di menu viene utilizzata per l''immissione di criteri di ricerca senza distinzione tra maiuscole e minuscole',
'(non occorrono caratteri jolly). L''immissione di un valore comporta la riduzione della lista',
unistr('di valori alla fine del menu. \00C8 quindi possibile selezionare un valore nella'),
unistr('parte inferiore e il valore selezionato verr\00E0 creato come filtro con l''operatore ''='' (ad esempio, <code>colonna = ''ABC''</code>). In alternativa \00E8 possibile fare clic sull''icona a forma di torcia elettrica  e immettere un valore da creare come filtro ')
||'con il modificatore ''LIKE'' (ad esempio, <code>colonna LIKE ''%ABC%''</code>).',
'<li><b>Lista di valori univoci</b>: contiene i primi 500 valori',
unistr('univoci che soddisfano i criteri di filtro. Se la colonna \00E8 di tipo data, viene visualizzata una'),
unistr('lista di intervalli di date. Se si seleziona un valore, verr\00E0 creato'),
'un filtro con l''operatore ''='' (ad esempio, <code>colonna = ''ABC''</code>).</li></ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278193667517868000)
,p_name=>'APEXIR_HELP_COMPUTE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Consente di aggiungere colonne calcolate al report. Pu\00F2 trattarsi di calcoli matematici (ad esempio <code>NBR_HOURS/24</code>) o di funzioni Oracle'),
unistr('standard applicate a colonne esistenti (alcune sono state visualizzate ed \00E8 possibile utilizzarne altre, ad esempio <code>TO_DATE)</code>). Opzioni disponibili:'),
'<p></p>',
'<ul>',
'<li><b>Calcolo</b>: consente di selezionare un calcolo definito in precedenza per modificarlo.</li>',
'<li><b>Intestazione colonna</b>: l''intestazione della nuova colonna.</li>',
'<li><b>Formato di visualizzazione</b>: il formato di visualizzazione Oracle da applicare alla colonna (ad esempio S9999).</li>',
'<li><b>Calcolo</b>: il calcolo da eseguire. All''interno del calcolo per fare riferimento alle colonne si utilizzano gli alias visualizzati.</li>',
'</ul>',
'<p>Sotto il calcolo vengono visualizzate le colonne della query con',
'i rispettivi alias associati. Quando si fa clic sul nome o l''alias della colonna, ',
unistr('gli elementi vengono scritti nel calcolo. Accanto alle colonne \00E8 disponibile un tastierino,'),
unistr('che funge da scelta rapida per i tasti pi\00F9 utilizzati. A destra si trovano le funzioni.</p>'),
'<p>Di seguito viene riportato un esempio di calcolo del compenso totale:</p>',
'<pre>CASE WHEN A = ''SALES'' THEN B + C ELSE B END</pre>',
unistr('(dove A \00E8 l''ORGANIZZAZIONE, B \00E8 lo STIPENDIO e C \00E8 la COMMISSIONE)</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278210200761868011)
,p_name=>'APEXIR_HELP_CONTROL_BREAK'
,p_message_language=>'it'
,p_message_text=>unistr('Consente di creare un gruppo di interruzione su una o pi\00F9 colonne. Questa operazione comporta l''estrazione delle colonne dal report interattivo e la loro visualizzazione come record principale.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278194388371868001)
,p_name=>'APEXIR_HELP_DETAIL_VIEW'
,p_message_language=>'it'
,p_message_text=>unistr('Per visualizzare i dettagli di una sola riga alla volta, fare clic sull''icona della vista a riga singola sulla riga da visualizzare. Se disponibile, la vista a riga singola sar\00E0 sempre la prima colonna. A seconda della personalizzazione del report in')
||unistr('terattivo, la vista a riga singola pu\00F2 essere la vista standard oppure una pagina personalizzata che consente l''aggiornamento.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278194287177868001)
,p_name=>'APEXIR_HELP_DOWNLOAD'
,p_message_language=>'it'
,p_message_text=>'Consente di scaricare il set di risultati corrente. I formati di download variano a seconda dell''installazione e della definizione del report, ma possono comprendere CSV, HTML, Posta elettronica, XLS, PDF o RTF.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278193343874868000)
,p_name=>'APEXIR_HELP_FILTER'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Specifica ulteriormente il report aggiungendo o modificando la clausola <code>WHERE</code> nella query. \00C8 possibile applicare un filtro per colonna o per riga.  '),
'<p/>Se si applica il filtro per colonna, selezionare una colonna (non necessariamente quella',
'visualizzata), selezionare un operatore Oracle standard (=, !=, not in, between) e infine immettere un''espressione di confronto. Le espressioni distinguono tra maiuscole e minuscole. Utilizzare % come carattere jolly (ad esempio <code>STATE_NAME',
'like A%)<code>.</p>',
unistr('<p>Se si applica un filtro per riga, \00E8 possibile creare clausole <code>WHERE</code> complesse utilizzando'),
'alias di colonna e qualsiasi funzione o operatore Oracle (ad esempio <code>G = ''VA'' o G = ''CT''</code>, dove',
unistr('<code>G</code> \00E8 l''alias per <code>CUSTOMER_STATE</code>).</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278193930122868000)
,p_name=>'APEXIR_HELP_FLASHBACK'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Una funzione Flashback query consente di visualizzare i dati cos\00EC come si presentavano in un precedente'),
unistr('point in time. La quantit\00E0 di tempo massima presa in considerazione dalla funzione \00E8 pari a 3 ore (o 180'),
unistr('minuti) ma la quantit\00E0 effettiva varia a seconda del database.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278693545666868316)
,p_name=>'APEXIR_HELP_FORMAT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>L''opzione Formato consente di personalizzare la visualizzazione del report.',
'L''opzione Formato contiene i sottomenu seguenti:</p>',
'<ul><li>Ordina</li>',
'<li>Interruzione di controllo</li>',
'<li>Evidenzia</li>',
'<li>Calcola</li>',
'<li>Aggrega</li>',
'<li>Grafico</li>',
'<li>Raggruppa per</li>',
'<li>Pivot</li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278684204265868310)
,p_name=>'APEXIR_HELP_GROUP_BY'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\00C8 possibile definire una sola vista di raggruppamento per report salvato.'),
unistr('Dopo averla definita, \00E8 possibile alternare le viste di raggruppamento e report'),
'utilizzando le icone vista della barra di ricerca. Per creare una vista Raggruppa per',
unistr('\00E8 necessario selezionare:'),
'<p></p><ul>',
'<li>le colonne su cui basare il raggruppamento</li>',
unistr('<li>le colonne da aggregare insieme alla funzione da eseguire (media, somma, conteggio e cos\00EC via)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278193524918868000)
,p_name=>'APEXIR_HELP_HIGHLIGHT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di definire un filtro. Le righe che soddisfano i criteri del filtro vengono evidenziate mediante caratteristiche associate al filtro. Opzioni disponibili:<p/>',
'<ul>',
'<li><b>Nome</b>: utilizzato solo per la visualizzazione.</li>',
'<li><b>Sequenza</b>: identifica la sequenza in cui verranno valutate le regole.</li>',
unistr('<li><b>Abilitato</b>: indica se la regola \00E8 abilitata o disabilitata.</li>'),
'<li><b>Tipo di evidenziazione</b>: indica se deve essere evidenziata la riga o',
'una cella. Se si seleziona Cella, viene evidenziata la colonna a cui si fa riferimento',
'in Condizione di evidenziazione.</li>',
'<li><b>Colore sfondo</b>: il nuovo colore per lo sfondo dell''area evidenziata.</li>',
'<li><b>Colore testo</b>: il nuovo colore per il testo dell''area evidenziata.</li>',
'<li><b>Condizione di evidenziazione</b>: definisce la condizione del filtro.</li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277790231000867746)
,p_name=>'APEXIR_HELP_PIVOT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\00C8 possibile definire una sola vista pivot per report salvato. Dopo averla definita, \00E8 possibile alternare le viste pivot e report utilizzando le icone vista nella barra di ricerca. Per creare una vista pivot \00E8 necessario selezionare:'),
'<p></p>',
'<ul>',
'<li>le colonne su cui eseguire il pivot</li>',
'<li>le colonne da visualizzare come righe</li>',
unistr('<li>le colonne da aggregare insieme alla funzione da eseguire (media, somma, conteggio e cos\00EC via)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278235031307868026)
,p_name=>'APEXIR_HELP_REPORT_SETTINGS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Se si personalizza un report interattivo, le impostazioni del report verranno visualizzate',
unistr('sotto la barra di ricerca e sopra il report. Quest''area pu\00F2 essere compressa ed espansa utilizzando l''icona a sinistra.'),
'<p>',
unistr('Per ogni impostazione del report \00E8 possibile effettuare le operazioni riportate di seguito'),
'.</p><ul>',
'<li>Modificare un''impostazione facendo clic sul nome.</li>',
'<li>Disabilitare/abilitare un''impostazione deselezionando o selezionando la casella di controllo Abilita/disabilita. Questa casella di controllo consente di disattivare temporaneamente e riattivare l''impostazione.</li>',
'<li>Rimuovere un''impostazione facendo clic sull''icona Rimuovi.</li>',
'</ul>',
unistr('<p>Se \00E8 stato creato un grafico, un raggruppamento o una tabella pivot, \00E8 possibile alternarli'),
'con il report di base utilizzando i collegamenti Vista report, Vista grafico, Vista Raggruppa per e Vista pivot,',
unistr('mostrati a destra. Quando si visualizza il grafico, il raggruppamento o la tabella pivot, \00E8 possibile'),
'anche utilizzare il collegamento Modifica per modificare le impostazioni.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278194188922868000)
,p_name=>'APEXIR_HELP_RESET'
,p_message_language=>'it'
,p_message_text=>'Ripristina i valori predefiniti del report rimuovendo tutte le personalizzazioni effettuate dall''utente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278693863910868316)
,p_name=>'APEXIR_HELP_ROWS_PER_PAGE'
,p_message_language=>'it'
,p_message_text=>'Imposta il numero di record da visualizzare per pagina.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278194077957868000)
,p_name=>'APEXIR_HELP_SAVE_REPORT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Salva il report personalizzato per poterlo utilizzare in futuro. Occorre fornire un nome e una descrizione facoltativa. \00C8 possibile fare in modo che il report sia accessibile pubblicamente, ovvero da parte di tutti gli utenti che possono accedere ')
||unistr('al report primario predefinito. \00C8 possibile salvare quattro tipi di report interattivo:</p>'),
'<ul>',
unistr('<li><strong>Predefinito primario</strong> (solo sviluppatori). Il report predefinito primario \00E8 quello visualizzato inizialmente. I report di questo tipo non possono essere rinominati o eliminati.</li>'),
unistr('<li><strong>Report alternativo</strong> (solo sviluppatori). Consente agli sviluppatori di creare pi\00F9 layout di report. Solo gli sviluppatori possono salvare, rinominare o eliminare un report alternativo.</li>'),
unistr('<li><strong>Report pubblico</strong> (utenti finali). Pu\00F2 essere salvato, rinominato o eliminato solo dall''utente finale che lo ha creato. Gli altri utenti possono visualizzare e salvare il layout come report diverso.</li>'),
unistr('<li><strong>Report privato</strong> (utenti finali). Solo l''utente finale che crea il report pu\00F2 visualizzare, salvare, rinominare o eliminare il report.</li>'),
'</ul>',
'<p>Se si salvano report personalizzati, viene visualizzato un selettore dei report nella barra di ricerca, a sinistra del selettore delle righe (qualora questa funzione sia abilitata).</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278193088443868000)
,p_name=>'APEXIR_HELP_SEARCH_BAR'
,p_message_language=>'it'
,p_message_text=>unistr('Nella parte superiore di ogni pagina di report \00E8 presente un''area di ricerca. Questa area o barra di ricerca dispone delle seguenti funzioni:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278694459095868317)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ACTIONS_MENU'
,p_message_language=>'it'
,p_message_text=>'<li>Il menu <b>Azioni</b> consente di personalizzare un report. Vedere le sezioni seguenti.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278693949090868316)
,p_name=>'APEXIR_HELP_SEARCH_BAR_FINDER'
,p_message_language=>'it'
,p_message_text=>'<li>L''<b>icona di selezione delle colonne</b> consente di specificare una o tutte le colonne in cui eseguire la ricerca.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278694272373868317)
,p_name=>'APEXIR_HELP_SEARCH_BAR_REPORTS'
,p_message_language=>'it'
,p_message_text=>'<li><b>Report</b> mostra un valore predefinito alternativo e salva i report pubblici o privati.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278694171536868317)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ROWS'
,p_message_language=>'it'
,p_message_text=>'<li><b>Righe</b> imposta il numero di record da visualizzare per pagina.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278694079578868316)
,p_name=>'APEXIR_HELP_SEARCH_BAR_TEXTBOX'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>L''<b>area di testo</b> consente di immettere criteri di ricerca senza distinzione tra maiuscole e minuscole (i caratteri jolly sono impliciti).</li>',
unistr('<li>Il pulsante <b>Vai</b> esegue la ricerca. Quando il cursore si trova nell''area del testo di ricerca, la ricerca verr\00E0 eseguita anche premendo il tasto Invio.</li>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278694354932868317)
,p_name=>'APEXIR_HELP_SEARCH_BAR_VIEW'
,p_message_language=>'it'
,p_message_text=>'<li><b>Visualizza icone</b> alterna le viste a icone, report, dei dettagli, di grafico, di raggruppamento e pivot  del report, qualora siano definite.</li>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279036725356868535)
,p_name=>'APEXIR_HELP_SEARCH_BAR_WS_MANAGE'
,p_message_language=>'it'
,p_message_text=>unistr('<li><b>Gestisci</b> consente di gestire propriet\00E0, colonne e righe e visualizzare la cronologia del report o della griglia dati.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278193202305868000)
,p_name=>'APEXIR_HELP_SELECT_COLUMNS'
,p_message_language=>'it'
,p_message_text=>unistr('Utilizzato per modificare le colonne visualizzate. Le colonne a destra vengono visualizzate, mentre le colonne a sinistra vengono nascoste. \00C8 possibile riordinare le colonne visualizzate utilizzando le frecce a destra. Le colonne calcolate sono contr')
||'addistinte dal prefisso <b>**</b>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278193494768868000)
,p_name=>'APEXIR_HELP_SORT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Utilizzato per modificare le colonne da ordinare e per indicare se',
unistr('il tipo di ordinamento \00E8 crescente o decrescente. \00C8 inoltre possibile specificare le modalit\00E0 di gestione'),
'dei valori <code>NULL</code>. L''impostazione predefinita visualizza i valori <code>NULL</code> sempre per ultimi o per primi. L''ordinamento finale viene visualizzato a destra delle',
'intestazioni di colonna nel report.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278683809910868310)
,p_name=>'APEXIR_HELP_SUBSCRIPTION'
,p_message_language=>'it'
,p_message_text=>unistr('Quando si aggiunge una sottoscrizione, specificare un indirizzo di posta elettronica (o pi\00F9 indirizzi di posta elettronica separati da virgole), un oggetto del messaggio, la frequenza e le date di inizio e di fine. I messaggi di posta elettronica ris')
||'ultanti includono una versione HTML del report interattivo che contiene i dati correnti utilizzando l''impostazione di report presente al momento dell''aggiunta della sottoscrizione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279036270547868534)
,p_name=>'APEXIR_HELP_WS_01'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Le griglie dati sono, in pratica, report modificabili e personalizzabili in vari modi. \00C8 possibile modificare il layout dei dati del report selezionando le colonne desiderate, applicando filtri, evidenziando e ordinando gli elementi. \00C8 possibile anch')
||'e definire interruzioni, aggregazioni, grafici diversi, raggruppamenti e calcoli. Gli utenti possono creare varie versioni del report e salvarle come report denominati, visualizzabili privatamente.',
'<p/>',
'Le griglie dati possono essere personalizzate dalla barra di ricerca, dal menu delle azioni o dal menu delle intestazioni di colonna.'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279088620678868568)
,p_name=>'APEXIR_HELP_WS_ACTIONS_MENU'
,p_message_language=>'it'
,p_message_text=>unistr('Il menu Azioni \00E8 visualizzato a destra del pulsante Vai nella barra di ricerca. Usare questo menu per personalizzare un report griglia dati.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279037004731868535)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT'
,p_message_language=>'it'
,p_message_text=>'Pagina Aggiungi/modifica riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279037115769868535)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT_ROW'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Per aggiungere una riga alla griglia dati, fare clic su Aggiungi riga. Per modificare i dettagli di una riga, fare clic sull''icona di modifica della riga (prima colonna) nella riga che si desidera modificare. Verr\00E0 visualizzata la pagina Aggiungi/')
||'modifica riga, in cui sono presenti le colonne della griglia dati. </p>',
'',
unistr('<p>Quando si modifica una riga, \00E8 possibile effettuare le seguenti operazioni:</p>'),
'',
'<p><ul>',
'<li><b>Eliminare</b> la riga.</li>',
'<li><b>Applicare le modifiche</b> per salvare quelle apportate alla riga.</li>',
'<li>All''interno di <b>Azioni</b>, aggiungere una riga, aggiungere file, note, collegamenti o tag e rivedere la cronologia.</li>',
'<li>Accedere alle righe <b>successive e precedenti</b>.</li>',
unistr('<li>All''interno di <b>Gestisci</b>, impostare propriet\00E0 delle colonne, gruppi di colonne, convalide e liste di valori.</li>'),
'</ul></p>',
'',
'<p>L''area Annotazioni in fondo alla pagina mostra file, note, collegamenti o tag associate alla riga corrente.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279088799742868568)
,p_name=>'APEXIR_HELP_WS_CONTROL_BREAK'
,p_message_language=>'it'
,p_message_text=>unistr('Consente di creare un gruppo di interruzione su una o pi\00F9 colonne. Questa operazione comporta l''estrazione delle colonne dalla griglia dati e la loro visualizzazione come record principale.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279036990687868535)
,p_name=>'APEXIR_HELP_WS_DOWNLOAD'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Consente di scaricare il set di risultati corrente. I formati di download',
'comprendono CSV, HTML o Posta elettronica.'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279088864291868568)
,p_name=>'APEXIR_HELP_WS_REPORT_SETTINGS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Se si personalizza un report griglia dati, le impostazioni del report verranno visualizzate',
unistr('sotto la barra di ricerca e sopra il report. Quest''area pu\00F2 essere compressa ed espansa utilizzando l''icona a sinistra.'),
'<p/>',
unistr('Per ogni impostazione del report \00E8 possibile effettuare le operazioni riportate di seguito.</p><ul>'),
'<li>Modificare un''impostazione facendo clic sul nome.</li>',
'<li>Disabilitare/abilitare un''impostazione deselezionando o selezionando la casella di controllo Abilita/disabilita. Questa casella di controllo consente di disattivare temporaneamente e riattivare l''impostazione.</li>',
'<li>Rimuovere un''impostazione facendo clic sull''icona Rimuovi.</li>',
'</ul>',
unistr('<p>Se \00E8 stato creato un grafico o un raggruppamento, \00E8 possibile alternarli'),
'con il report di base utilizzando i collegamenti Vista report, Vista grafico e Vista Raggruppa per,',
unistr('mostrati a destra. Quando si visualizza il grafico o il raggruppamento, \00E8 possibile'),
'anche utilizzare il collegamento Modifica per modificare le impostazioni.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279036820807868535)
,p_name=>'APEXIR_HELP_WS_SAVE_REPORT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Salva il layout di report con griglia dati personalizzata per poterlo utilizzare in futuro. Occorre fornire un nome e una descrizione facoltativa. \00C8 possibile salvare tre tipi di layout di report con griglia dati:</p>'),
'<ul>',
unistr('<li><strong>Predefinito primario</strong> (solo amministratori). Il valore predefinito primario \00E8 il layout visualizzato inizialmente. I report di questo tipo non possono essere rinominati o eliminati.</li>'),
unistr('<li><strong>Report alternativo</strong> (solo amministratori). Consente agli amministratori di creare pi\00F9 layout di report. Solo gli amministratori possono salvare, rinominare o eliminare un report alternativo.</li>'),
unistr('<li><strong>Report privato</strong> (tutti gli utenti). L''utente che crea il layout di report pu\00F2 visualizzare, salvare, rinominare o eliminare il report.</li>'),
'</ul>',
'<p>Se si salvano report personalizzati, viene visualizzato un selettore dei report nella barra di ricerca, a sinistra del selettore delle righe (qualora questa funzione sia abilitata).</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278205345559868007)
,p_name=>'APEXIR_HIDE_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Nascondi colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278117654288867952)
,p_name=>'APEXIR_HIGHLIGHT'
,p_message_language=>'it'
,p_message_text=>'Evidenzia'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278209519176868010)
,p_name=>'APEXIR_HIGHLIGHTS'
,p_message_language=>'it'
,p_message_text=>'Evidenziazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278235193196868026)
,p_name=>'APEXIR_HIGHLIGHT_CONDITION'
,p_message_language=>'it'
,p_message_text=>'Condizione di evidenziazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278684718066868311)
,p_name=>'APEXIR_HIGHLIGHT_STYLE'
,p_message_language=>'it'
,p_message_text=>'Stile evidenziazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277958463565867851)
,p_name=>'APEXIR_HIGHLIGHT_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di evidenziazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277959141631867852)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_language=>'it'
,p_message_text=>'Evidenzia se'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279045312527868540)
,p_name=>'APEXIR_HORIZONTAL'
,p_message_language=>'it'
,p_message_text=>'Orizzontale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279148861103868606)
,p_name=>'APEXIR_INACTIVE_SETTING'
,p_message_language=>'it'
,p_message_text=>'1 impostazione non attiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279148977788868606)
,p_name=>'APEXIR_INACTIVE_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'%0 impostazioni non attive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278194742437868001)
,p_name=>'APEXIR_INTERACTIVE_REPORT_HELP'
,p_message_language=>'it'
,p_message_text=>'Guida del report interattivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278236445408868027)
,p_name=>'APEXIR_INVALID'
,p_message_language=>'it'
,p_message_text=>'Non valido'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278208092265868009)
,p_name=>'APEXIR_INVALID_COMPUTATION'
,p_message_language=>'it'
,p_message_text=>'Espressione di calcolo non valida. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277905568447867818)
,p_name=>'APEXIR_INVALID_END_DATE'
,p_message_language=>'it'
,p_message_text=>'La data di fine deve essere successiva alla data di inizio.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278354841467868102)
,p_name=>'APEXIR_INVALID_FILTER'
,p_message_language=>'it'
,p_message_text=>'Espressione di filtro non valida. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279081413405868563)
,p_name=>'APEXIR_INVALID_FILTER_QUERY'
,p_message_language=>'it'
,p_message_text=>'Query di filtro non valida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279149085429868606)
,p_name=>'APEXIR_INVALID_SETTING'
,p_message_language=>'it'
,p_message_text=>'1 impostazione non valida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279149110460868606)
,p_name=>'APEXIR_INVALID_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'%0 impostazioni non valide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278685108788868311)
,p_name=>'APEXIR_IN_MINUTES'
,p_message_language=>'it'
,p_message_text=>'(in minuti)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279028236643868529)
,p_name=>'APEXIR_IS_IN_THE_LAST'
,p_message_language=>'it'
,p_message_text=>'%0 rientra nell''ultimo %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279028508924868529)
,p_name=>'APEXIR_IS_IN_THE_NEXT'
,p_message_language=>'it'
,p_message_text=>'%0 rientra nel prossimo %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279028482472868529)
,p_name=>'APEXIR_IS_NOT_IN_THE_LAST'
,p_message_language=>'it'
,p_message_text=>'%0 non rientra nell''ultimo %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279028662611868529)
,p_name=>'APEXIR_IS_NOT_IN_THE_NEXT'
,p_message_language=>'it'
,p_message_text=>'%0 non rientra nel prossimo %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278234204184868026)
,p_name=>'APEXIR_KEYPAD'
,p_message_language=>'it'
,p_message_text=>'Tastierino'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277989457486867871)
,p_name=>'APEXIR_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta :%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278202974822868006)
,p_name=>'APEXIR_LABEL_AXIS_TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo asse per etichetta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278550288660868226)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_language=>'it'
,p_message_text=>'Prefisso etichetta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278121887924867954)
,p_name=>'APEXIR_LAST_DAY'
,p_message_language=>'it'
,p_message_text=>'Ultimo giorno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278122043996867955)
,p_name=>'APEXIR_LAST_HOUR'
,p_message_language=>'it'
,p_message_text=>'Ultima ora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278121564219867954)
,p_name=>'APEXIR_LAST_MONTH'
,p_message_language=>'it'
,p_message_text=>'Mese scorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278121694196867954)
,p_name=>'APEXIR_LAST_WEEK'
,p_message_language=>'it'
,p_message_text=>'Settimana scorsa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278121718160867954)
,p_name=>'APEXIR_LAST_X_DAYS'
,p_message_language=>'it'
,p_message_text=>'Ultimi %0 giorni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278121950071867955)
,p_name=>'APEXIR_LAST_X_HOURS'
,p_message_language=>'it'
,p_message_text=>'Ultime %0 ore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278121383275867954)
,p_name=>'APEXIR_LAST_X_YEARS'
,p_message_language=>'it'
,p_message_text=>'Ultimi %0 anni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278121420191867954)
,p_name=>'APEXIR_LAST_YEAR'
,p_message_language=>'it'
,p_message_text=>'Anno scorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277989246001867871)
,p_name=>'APEXIR_LINE'
,p_message_language=>'it'
,p_message_text=>'Riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277961540378867853)
,p_name=>'APEXIR_LINE_WITH_AREA'
,p_message_language=>'it'
,p_message_text=>'A linee con area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278668454534868300)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Fare clic <a href=''%0''>qui</a> per gestire la sottoscrizione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279081354983868563)
,p_name=>'APEXIR_MAP_IT'
,p_message_language=>'it'
,p_message_text=>'Mappa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278205966582868008)
,p_name=>'APEXIR_MAX_QUERY_COST'
,p_message_language=>'it'
,p_message_text=>'Secondo le stime la query supera il numero massimo di risorse consentito. Modificare le impostazioni del report e riprovare.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278074126214867924)
,p_name=>'APEXIR_MAX_ROW_CNT'
,p_message_language=>'it'
,p_message_text=>unistr('Il conteggio massimo di righe per questo report \00E8 %0 righe. Applicare un filtro per ridurre il numero di record nella query.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279081914541868563)
,p_name=>'APEXIR_MAX_X'
,p_message_language=>'it'
,p_message_text=>'Massimo %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279082195777868564)
,p_name=>'APEXIR_MEDIAN_X'
,p_message_language=>'it'
,p_message_text=>'Mediana %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278087865057867933)
,p_name=>'APEXIR_MIN_AGO'
,p_message_language=>'it'
,p_message_text=>'%0 minuti fa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279082032843868563)
,p_name=>'APEXIR_MIN_X'
,p_message_language=>'it'
,p_message_text=>'Minimo %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279080947841868563)
,p_name=>'APEXIR_MONTH'
,p_message_language=>'it'
,p_message_text=>'Mese'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278685542155868311)
,p_name=>'APEXIR_MONTHLY'
,p_message_language=>'it'
,p_message_text=>'Mensile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278236601708868027)
,p_name=>'APEXIR_MORE_DATA'
,p_message_language=>'it'
,p_message_text=>'Altri dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278201816802868005)
,p_name=>'APEXIR_MOVE'
,p_message_language=>'it'
,p_message_text=>'Sposta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278201765249868005)
,p_name=>'APEXIR_MOVE_ALL'
,p_message_language=>'it'
,p_message_text=>'Sposta tutto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279167228676868618)
,p_name=>'APEXIR_MULTIIR_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 necessario specificare l''ID statico area poich\00E9 la pagina contiene pi\00F9 report interattivi.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277960250379867853)
,p_name=>'APEXIR_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278191163452867999)
,p_name=>'APEXIR_NEW_AGGREGATION'
,p_message_language=>'it'
,p_message_text=>'Nuova aggregazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277983445564867867)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_language=>'it'
,p_message_text=>'- Nuova categoria -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279150525955868607)
,p_name=>'APEXIR_NEW_CATEGORY_LABEL'
,p_message_language=>'it'
,p_message_text=>'Nuova categoria'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278191248414867999)
,p_name=>'APEXIR_NEW_COMPUTATION'
,p_message_language=>'it'
,p_message_text=>'Nuovo calcolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278115982821867951)
,p_name=>'APEXIR_NEXT'
,p_message_language=>'it'
,p_message_text=>'Successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278122465552867955)
,p_name=>'APEXIR_NEXT_DAY'
,p_message_language=>'it'
,p_message_text=>'Giorno successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278122293087867955)
,p_name=>'APEXIR_NEXT_HOUR'
,p_message_language=>'it'
,p_message_text=>'Ora successiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278122765773867955)
,p_name=>'APEXIR_NEXT_MONTH'
,p_message_language=>'it'
,p_message_text=>'Mese successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278122683172867955)
,p_name=>'APEXIR_NEXT_WEEK'
,p_message_language=>'it'
,p_message_text=>'Settimana successiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278122505989867955)
,p_name=>'APEXIR_NEXT_X_DAYS'
,p_message_language=>'it'
,p_message_text=>'%0 giorni successivi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278122332315867955)
,p_name=>'APEXIR_NEXT_X_HOURS'
,p_message_language=>'it'
,p_message_text=>'%0 ore successive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278122906816867955)
,p_name=>'APEXIR_NEXT_X_YEARS'
,p_message_language=>'it'
,p_message_text=>'%0 anni successivi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278122805041867955)
,p_name=>'APEXIR_NEXT_YEAR'
,p_message_language=>'it'
,p_message_text=>'Anno successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277960589469867853)
,p_name=>'APEXIR_NO'
,p_message_language=>'it'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278236870735868027)
,p_name=>'APEXIR_NONE'
,p_message_language=>'it'
,p_message_text=>'- Nessuno -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278684593375868311)
,p_name=>'APEXIR_NOT_VALID_EMAIL'
,p_message_language=>'it'
,p_message_text=>unistr('Non \00E8 un indirizzo di posta elettronica valido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278118716710867953)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_language=>'it'
,p_message_text=>'Nessuna aggregazione definita.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278072967601867924)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_language=>'it'
,p_message_text=>'Non sono disponibili informazioni sulle colonne.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278118897907867953)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_language=>'it'
,p_message_text=>'Nessun calcolo definito.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279080708721868563)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_language=>'it'
,p_message_text=>'- Nessuna data di fine -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278231923291868024)
,p_name=>'APEXIR_NULLS_ALWAYS_FIRST'
,p_message_language=>'it'
,p_message_text=>'Valori nulli sempre per primi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278231857416868024)
,p_name=>'APEXIR_NULLS_ALWAYS_LAST'
,p_message_language=>'it'
,p_message_text=>'Valori nulli sempre per ultimi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278232828714868025)
,p_name=>'APEXIR_NULL_SORTING'
,p_message_language=>'it'
,p_message_text=>'Ordinamento valori nulli %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278208164558868009)
,p_name=>'APEXIR_NUMERIC_FLASHBACK_TIME'
,p_message_language=>'it'
,p_message_text=>'Il valore di tempo Flashback deve essere numerico.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278207666199868009)
,p_name=>'APEXIR_NUMERIC_SEQUENCE'
,p_message_language=>'it'
,p_message_text=>'La sequenza deve essere numerica.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278233589506868025)
,p_name=>'APEXIR_OPERATOR'
,p_message_language=>'it'
,p_message_text=>'Operatore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277958949780867852)
,p_name=>'APEXIR_ORANGE'
,p_message_language=>'it'
,p_message_text=>'arancione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279045281311868540)
,p_name=>'APEXIR_ORIENTATION'
,p_message_language=>'it'
,p_message_text=>'Orientamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277961028957867853)
,p_name=>'APEXIR_OTHER'
,p_message_language=>'it'
,p_message_text=>'Altro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279082403292868564)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_COUNT_X'
,p_message_language=>'it'
,p_message_text=>'Percentuale del conteggio totale %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279081665134868563)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_SUM_X'
,p_message_language=>'it'
,p_message_text=>'Percentuale della somma totale %0 (%)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279080190705868562)
,p_name=>'APEXIR_PERCENT_TOTAL_COUNT'
,p_message_language=>'it'
,p_message_text=>'Percentuale del conteggio totale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279080056716868562)
,p_name=>'APEXIR_PERCENT_TOTAL_SUM'
,p_message_language=>'it'
,p_message_text=>'Percentuale della somma totale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277989122138867871)
,p_name=>'APEXIR_PIE'
,p_message_language=>'it'
,p_message_text=>'A torta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278523941004868209)
,p_name=>'APEXIR_PIVOT'
,p_message_language=>'it'
,p_message_text=>'Pivot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278551581287868226)
,p_name=>'APEXIR_PIVOT_AGG_NOT_NULL'
,p_message_language=>'it'
,p_message_text=>'Specificare l''aggregato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278551872477868227)
,p_name=>'APEXIR_PIVOT_AGG_NOT_ON_ROW_COL'
,p_message_language=>'it'
,p_message_text=>'Impossibile aggregare una colonna selezionata come colonna righe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278549327120868225)
,p_name=>'APEXIR_PIVOT_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278549160309868225)
,p_name=>'APEXIR_PIVOT_COLUMN_N'
,p_message_language=>'it'
,p_message_text=>'Colonna pivot %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278551391477868226)
,p_name=>'APEXIR_PIVOT_COLUMN_NOT_NULL'
,p_message_language=>'it'
,p_message_text=>'Specificare la colonna pivot.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277790147562867746)
,p_name=>'APEXIR_PIVOT_MAX_ROW_CNT'
,p_message_language=>'it'
,p_message_text=>'Il numero massimo di righe per una query di tipo Pivot limita il numero di righe nella query di base, non il numero di righe visualizzate. La query di base supera il numero massimo di righe di %0 righe. Applicare un filtro per ridurre il numero di re'
||'cord nella query di base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279163190921868615)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_language=>'it'
,p_message_text=>'Selezionare una colonna righe diversa. L''espressione o il collegamento HTML nella colonna righe contiene una colonna definita come colonna pivot o di aggregazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278550321704868226)
,p_name=>'APEXIR_PIVOT_SORT'
,p_message_language=>'it'
,p_message_text=>'Ordinamento pivot'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278684691612868311)
,p_name=>'APEXIR_PREVIEW'
,p_message_language=>'it'
,p_message_text=>'Anteprima'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278116020204867951)
,p_name=>'APEXIR_PREVIOUS'
,p_message_language=>'it'
,p_message_text=>'Precedente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279079026391868562)
,p_name=>'APEXIR_PRIMARY'
,p_message_language=>'it'
,p_message_text=>'Chiave primaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278688341384868313)
,p_name=>'APEXIR_PRIMARY_REPORT'
,p_message_language=>'it'
,p_message_text=>'Report primario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278348814416868098)
,p_name=>'APEXIR_PRIVATE'
,p_message_language=>'it'
,p_message_text=>'Privato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277990541452867872)
,p_name=>'APEXIR_PUBLIC'
,p_message_language=>'it'
,p_message_text=>'Pubblico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277960897131867853)
,p_name=>'APEXIR_RED'
,p_message_language=>'it'
,p_message_text=>'rosso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279167187910868618)
,p_name=>'APEXIR_REGION_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'L''ID statico area %0 non esiste.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278201997338868005)
,p_name=>'APEXIR_REMOVE'
,p_message_language=>'it'
,p_message_text=>'Rimuovi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278115089132867950)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_language=>'it'
,p_message_text=>'Rimuovi aggregato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278202009283868005)
,p_name=>'APEXIR_REMOVE_ALL'
,p_message_language=>'it'
,p_message_text=>'Rimuovi tutto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279149273666868606)
,p_name=>'APEXIR_REMOVE_CHART'
,p_message_language=>'it'
,p_message_text=>'Rimuovi grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278201374311868005)
,p_name=>'APEXIR_REMOVE_CONTROL_BREAK'
,p_message_language=>'it'
,p_message_text=>'Rimuovi interruzione di controllo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278201019370868005)
,p_name=>'APEXIR_REMOVE_FILTER'
,p_message_language=>'it'
,p_message_text=>'Rimuovi filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278201160544868005)
,p_name=>'APEXIR_REMOVE_FLASHBACK'
,p_message_language=>'it'
,p_message_text=>'Rimuovi Flashback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279149343701868606)
,p_name=>'APEXIR_REMOVE_GROUP_BY'
,p_message_language=>'it'
,p_message_text=>'Rimuovi raggruppamento per'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278201477792868005)
,p_name=>'APEXIR_REMOVE_HIGHLIGHT'
,p_message_language=>'it'
,p_message_text=>'Rimuovi evidenziazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279149408676868606)
,p_name=>'APEXIR_REMOVE_PIVOT'
,p_message_language=>'it'
,p_message_text=>'Rimuovi pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279090672388868569)
,p_name=>'APEXIR_REMOVE_REPORT'
,p_message_language=>'it'
,p_message_text=>'Rimuovi report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278969529041868491)
,p_name=>'APEXIR_RENAME_DEFAULT_REPORT'
,p_message_language=>'it'
,p_message_text=>'Rinomina report predefinito'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278237213137868028)
,p_name=>'APEXIR_RENAME_REPORT'
,p_message_language=>'it'
,p_message_text=>'Rinomina report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278116572671867951)
,p_name=>'APEXIR_REPORT'
,p_message_language=>'it'
,p_message_text=>'Report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279082574787868564)
,p_name=>'APEXIR_REPORTS'
,p_message_language=>'it'
,p_message_text=>'Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277950015712867846)
,p_name=>'APEXIR_REPORT_ALIAS_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'Il report interattivo salvato con l''alias %0 non esiste.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278499463060868193)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_language=>'it'
,p_message_text=>'Il numero di colonne visualizzate nel report ha raggiunto il limite. Fare clic su Seleziona colonne nel menu Azioni per ridurre la liste delle colonne visualizzate del report.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278352174616868100)
,p_name=>'APEXIR_REPORT_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'Report inesistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277950109773867846)
,p_name=>'APEXIR_REPORT_ID_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'L''ID report interattivo salvato %0 non esiste.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278234934062868026)
,p_name=>'APEXIR_REPORT_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278088335356867933)
,p_name=>'APEXIR_REPORT_VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278118198742867952)
,p_name=>'APEXIR_RESET'
,p_message_language=>'it'
,p_message_text=>'Reimposta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277990756209867872)
,p_name=>'APEXIR_RESET_CONFIRM'
,p_message_language=>'it'
,p_message_text=>'Ripristina le impostazioni predefinite del report.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277960626109867853)
,p_name=>'APEXIR_ROW'
,p_message_language=>'it'
,p_message_text=>'Riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279074865691868559)
,p_name=>'APEXIR_ROWID_NOT_SUPPORTED_FOR_WEBSOURCE'
,p_message_language=>'it'
,p_message_text=>unistr('Non \00E8 possibile utilizzare ROWID come colonna chiave primaria per un''origine Web.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278200035337868004)
,p_name=>'APEXIR_ROWS'
,p_message_language=>'it'
,p_message_text=>'Righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278693730230868316)
,p_name=>'APEXIR_ROWS_PER_PAGE'
,p_message_language=>'it'
,p_message_text=>'Righe per pagina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278549410782868225)
,p_name=>'APEXIR_ROW_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278549269350868225)
,p_name=>'APEXIR_ROW_COLUMN_N'
,p_message_language=>'it'
,p_message_text=>'Colonna righe %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278551455011868226)
,p_name=>'APEXIR_ROW_COLUMN_NOT_NULL'
,p_message_language=>'it'
,p_message_text=>'Specificare la colonna righe.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278551618570868226)
,p_name=>'APEXIR_ROW_COL_DIFF_FROM_PIVOT_COL'
,p_message_language=>'it'
,p_message_text=>'La colonna righe deve essere diversa dalla colonna pivot.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278296787680868065)
,p_name=>'APEXIR_ROW_FILTER'
,p_message_language=>'it'
,p_message_text=>'Filtro righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278088455754867933)
,p_name=>'APEXIR_ROW_OF'
,p_message_language=>'it'
,p_message_text=>'Riga %0 di %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278087636343867933)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_language=>'it'
,p_message_text=>'Ordine righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278119622224867953)
,p_name=>'APEXIR_ROW_TEXT_CONTAINS'
,p_message_language=>'it'
,p_message_text=>'La riga di testo contiene'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277810003904867758)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_language=>'it'
,p_message_text=>'Il numero di colonne visualizzate nel report ha raggiunto il limite. Fare clic su Seleziona colonne nel menu Azioni per ridurre la liste delle colonne visualizzate del report.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277959861408867852)
,p_name=>'APEXIR_SAVE'
,p_message_language=>'it'
,p_message_text=>'Salva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278209730867868010)
,p_name=>'APEXIR_SAVED_REPORT'
,p_message_language=>'it'
,p_message_text=>'Report salvato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278209681531868010)
,p_name=>'APEXIR_SAVED_REPORT_MSG'
,p_message_language=>'it'
,p_message_text=>'Report salvato = "%0"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278118527624867952)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_language=>'it'
,p_message_text=>'Salva come predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278231101130868024)
,p_name=>'APEXIR_SAVE_DEFAULT_CONFIRM'
,p_message_language=>'it'
,p_message_text=>'Le impostazioni di report correnti verranno utilizzate come predefinite per tutti gli utenti.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278969432183868491)
,p_name=>'APEXIR_SAVE_DEFAULT_REPORT'
,p_message_language=>'it'
,p_message_text=>'Salva report predefinito'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278118057563867952)
,p_name=>'APEXIR_SAVE_REPORT'
,p_message_language=>'it'
,p_message_text=>'Salva report'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279150455769868607)
,p_name=>'APEXIR_SAVE_REPORT_DEFAULT'
,p_message_language=>'it'
,p_message_text=>'Salva report *'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278705307925868324)
,p_name=>'APEXIR_SEARCH'
,p_message_language=>'it'
,p_message_text=>'Cerca'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278194642410868001)
,p_name=>'APEXIR_SEARCH_BAR'
,p_message_language=>'it'
,p_message_text=>'Barra di ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279150386185868607)
,p_name=>'APEXIR_SEARCH_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Cerca: %0'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278754684008868355)
,p_name=>'APEXIR_SEARCH_REPORT'
,p_message_language=>'it'
,p_message_text=>'Report di ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278666224843868299)
,p_name=>'APEXIR_SELECTED_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne selezionate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277960160028867853)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_language=>'it'
,p_message_text=>'- Seleziona categoria -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277961781265867854)
,p_name=>'APEXIR_SELECT_COLUMN'
,p_message_language=>'it'
,p_message_text=>'- Seleziona colonna -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278117331903867952)
,p_name=>'APEXIR_SELECT_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Seleziona colonne'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278237025859868027)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_language=>'it'
,p_message_text=>'Le colonne calcolate sono contraddistinte dal prefisso **.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277989956161867872)
,p_name=>'APEXIR_SELECT_FUNCTION'
,p_message_language=>'it'
,p_message_text=>'- Seleziona funzione -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278199493618868004)
,p_name=>'APEXIR_SELECT_GROUP_BY_COLUMN'
,p_message_language=>'it'
,p_message_text=>'- Seleziona colonna Raggruppa per -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278548973503868225)
,p_name=>'APEXIR_SELECT_PIVOT_COLUMN'
,p_message_language=>'it'
,p_message_text=>'- Seleziona colonna pivot -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279081525285868563)
,p_name=>'APEXIR_SELECT_ROW'
,p_message_language=>'it'
,p_message_text=>'Seleziona riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278549082420868225)
,p_name=>'APEXIR_SELECT_ROW_COLUMN'
,p_message_language=>'it'
,p_message_text=>'- Seleziona colonna righe -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279080371100868562)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_language=>'it'
,p_message_text=>'- Seleziona colonna di ordinamento -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278236577182868027)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_language=>'it'
,p_message_text=>'Seleziona valore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277799887535867752)
,p_name=>'APEXIR_SEND'
,p_message_language=>'it'
,p_message_text=>'Invia'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277960303170867853)
,p_name=>'APEXIR_SEQUENCE'
,p_message_language=>'it'
,p_message_text=>'Sequenza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278117545515867952)
,p_name=>'APEXIR_SORT'
,p_message_language=>'it'
,p_message_text=>'Ordina'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278205152206868007)
,p_name=>'APEXIR_SORT_ASCENDING'
,p_message_language=>'it'
,p_message_text=>'Ordinamento crescente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279080279482868562)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Ordina colonna %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278205274893868007)
,p_name=>'APEXIR_SORT_DESCENDING'
,p_message_language=>'it'
,p_message_text=>'Ordinamento decrescente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279089829021868568)
,p_name=>'APEXIR_SORT_ORDER'
,p_message_language=>'it'
,p_message_text=>'Criterio di ordinamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278190742010867998)
,p_name=>'APEXIR_SPACE_AS_IN_ONE_EMPTY_STRING'
,p_message_language=>'it'
,p_message_text=>'spazio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278233814618868025)
,p_name=>'APEXIR_STATUS'
,p_message_language=>'it'
,p_message_text=>'Stato %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278685202726868311)
,p_name=>'APEXIR_SUBSCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Sottoscrizione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279080653459868563)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING'
,p_message_language=>'it'
,p_message_text=>'Fine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278666118576868299)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_language=>'it'
,p_message_text=>unistr('Unit\00E0 finale')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279080546576868563)
,p_name=>'APEXIR_SUBSCRIPTION_STARTING_FROM'
,p_message_language=>'it'
,p_message_text=>'Inizio da'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279081773738868563)
,p_name=>'APEXIR_SUM_X'
,p_message_language=>'it'
,p_message_text=>'Somma %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279031041602868531)
,p_name=>'APEXIR_TABLE_SUMMARY'
,p_message_language=>'it'
,p_message_text=>'Area = %0, report = %1, vista = %2, inizio righe visualizzate = %3, fine righe visualizzate = %4, righe totali = %5.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278141102498867967)
,p_name=>'APEXIR_TABLE_SUMMARY_NO_TOTAL'
,p_message_language=>'it'
,p_message_text=>'Area = %0, report = %1, vista = %2, inizio righe visualizzate = %3, fine righe visualizzate = %4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277959074353867852)
,p_name=>'APEXIR_TEXT_COLOR'
,p_message_language=>'it'
,p_message_text=>'Colore testo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278074749823867925)
,p_name=>'APEXIR_TIME_DAYS'
,p_message_language=>'it'
,p_message_text=>'giorni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278074617411867925)
,p_name=>'APEXIR_TIME_HOURS'
,p_message_language=>'it'
,p_message_text=>'ore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278074519565867925)
,p_name=>'APEXIR_TIME_MINS'
,p_message_language=>'it'
,p_message_text=>'minuti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278074988806867925)
,p_name=>'APEXIR_TIME_MONTHS'
,p_message_language=>'it'
,p_message_text=>'mesi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278074840937867925)
,p_name=>'APEXIR_TIME_WEEKS'
,p_message_language=>'it'
,p_message_text=>'settimane'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278075060989867925)
,p_name=>'APEXIR_TIME_YEARS'
,p_message_language=>'it'
,p_message_text=>'anni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279090445935868569)
,p_name=>'APEXIR_TOGGLE'
,p_message_language=>'it'
,p_message_text=>'Attiva/disattiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278202197711868005)
,p_name=>'APEXIR_TOP'
,p_message_language=>'it'
,p_message_text=>'Inizio pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278235343677868026)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_language=>'it'
,p_message_text=>'Non autorizzato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279064282800868552)
,p_name=>'APEXIR_UNGROUPED_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna non raggruppata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278207845336868009)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_language=>'it'
,p_message_text=>'L''intestazione di colonna deve essere univoca.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278207539006868009)
,p_name=>'APEXIR_UNIQUE_HIGHLIGHT_NAME'
,p_message_language=>'it'
,p_message_text=>'Il nome dell''evidenziazione deve essere univoco.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277988280579867870)
,p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE'
,p_message_language=>'it'
,p_message_text=>'tipo di dati non supportato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278202273122868006)
,p_name=>'APEXIR_UP'
,p_message_language=>'it'
,p_message_text=>'Su'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278207744726868009)
,p_name=>'APEXIR_VALID_COLOR'
,p_message_language=>'it'
,p_message_text=>'Immettere un colore valido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278207998459868009)
,p_name=>'APEXIR_VALID_FORMAT_MASK'
,p_message_language=>'it'
,p_message_text=>'Immettere un formato di visualizzazione valido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277961117537867853)
,p_name=>'APEXIR_VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278203083607868006)
,p_name=>'APEXIR_VALUE_AXIS_TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo asse per valore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278236354770868027)
,p_name=>'APEXIR_VALUE_REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Valore obbligatorio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277989094230867871)
,p_name=>'APEXIR_VCOLUMN'
,p_message_language=>'it'
,p_message_text=>'A colonne verticali'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279045470449868540)
,p_name=>'APEXIR_VERTICAL'
,p_message_language=>'it'
,p_message_text=>'Verticale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278235530389868027)
,p_name=>'APEXIR_VIEW_CHART'
,p_message_language=>'it'
,p_message_text=>'Visualizza grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278734401333868342)
,p_name=>'APEXIR_VIEW_DETAIL'
,p_message_language=>'it'
,p_message_text=>'Visualizza dettaglio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279153536045868609)
,p_name=>'APEXIR_VIEW_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'Nessun vista %0 definita per il report.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278734588060868342)
,p_name=>'APEXIR_VIEW_GROUP_BY'
,p_message_language=>'it'
,p_message_text=>'Visualizza raggruppamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278734389553868342)
,p_name=>'APEXIR_VIEW_ICONS'
,p_message_language=>'it'
,p_message_text=>'Visualizza icone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278548759211868225)
,p_name=>'APEXIR_VIEW_PIVOT'
,p_message_language=>'it'
,p_message_text=>'Visualizza pivot'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278235676240868027)
,p_name=>'APEXIR_VIEW_REPORT'
,p_message_language=>'it'
,p_message_text=>'Visualizza report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279081193651868563)
,p_name=>'APEXIR_WEEK'
,p_message_language=>'it'
,p_message_text=>'Settimana'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278685496037868311)
,p_name=>'APEXIR_WEEKLY'
,p_message_language=>'it'
,p_message_text=>'Settimanale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278116482282867951)
,p_name=>'APEXIR_WORKING_REPORT'
,p_message_language=>'it'
,p_message_text=>'Report di lavoro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279083309153868564)
,p_name=>'APEXIR_X_DAYS'
,p_message_language=>'it'
,p_message_text=>'%0 giorni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279083257907868564)
,p_name=>'APEXIR_X_HOURS'
,p_message_language=>'it'
,p_message_text=>'%0 ore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279083187078868564)
,p_name=>'APEXIR_X_MINS'
,p_message_language=>'it'
,p_message_text=>'%0 minuti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279083501785868564)
,p_name=>'APEXIR_X_MONTHS'
,p_message_language=>'it'
,p_message_text=>'%0 mesi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279083444009868564)
,p_name=>'APEXIR_X_WEEKS'
,p_message_language=>'it'
,p_message_text=>'%0 settimane'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279083646182868564)
,p_name=>'APEXIR_X_YEARS'
,p_message_language=>'it'
,p_message_text=>'%0 anni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279081038906868563)
,p_name=>'APEXIR_YEAR'
,p_message_language=>'it'
,p_message_text=>'Anno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277958729612867852)
,p_name=>'APEXIR_YELLOW'
,p_message_language=>'it'
,p_message_text=>'giallo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277960426392867853)
,p_name=>'APEXIR_YES'
,p_message_language=>'it'
,p_message_text=>unistr('S\00EC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277807149516867756)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_language=>'it'
,p_message_text=>'Servizi di amministrazione di Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279029691865868530)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_language=>'it'
,p_message_text=>'Nessuna autenticazione configurata per questa applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278202815211868006)
,p_name=>'APEX_GROUP.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'it'
,p_message_text=>'%0 contiene < o >, che sono caratteri non validi.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278420007761868143)
,p_name=>'APEX_REGION'
,p_message_language=>'it'
,p_message_text=>'Area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278276755070868052)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_language=>'it'
,p_message_text=>'Gli oggetti di database seguenti verranno %0 nello schema selezionato:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278276842127868052)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Operazione %0 riuscita per gli oggetti di database seguenti:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278764779590868361)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_language=>'it'
,p_message_text=>'scorrere in Basso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278764834691868361)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_language=>'it'
,p_message_text=>'Scorri fino all''inizio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277812752627867760)
,p_name=>'APEX_WIZARD_FORM'
,p_message_language=>'it'
,p_message_text=>'Form di navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279029133081868530)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_language=>'it'
,p_message_text=>'Modifica riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278447682788868161)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_language=>'it'
,p_message_text=>'Oggetti non validi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279087513720868567)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_language=>'it'
,p_message_text=>'Non esistono pagine peer'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279032418303868532)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_language=>'it'
,p_message_text=>'Oggetti da creare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279032619969868532)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_language=>'it'
,p_message_text=>'Elimina dalle tabelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279032832831868532)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_language=>'it'
,p_message_text=>'Elimina oggetti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278695597782868317)
,p_name=>'APEX_WS_SETUP_DROP_TABLES'
,p_message_language=>'it'
,p_message_text=>'Elimina tabelle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278694835084868317)
,p_name=>'APEX_WS_SETUP_MSG1'
,p_message_language=>'it'
,p_message_text=>'Questi oggetti verranno creati nello schema <b>%0</b>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279032980378868532)
,p_name=>'APEX_WS_SETUP_MSG10'
,p_message_language=>'it'
,p_message_text=>unistr('Questi oggetti esistono gi\00E0 nello schema <b>%0</b> e sono utilizzati da altre aree di lavoro. Se si continua, gli oggetti Websheet esistenti e di propriet\00E0 di <b>%0</b> verranno associati anche a questa area di lavoro.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279033088674868532)
,p_name=>'APEX_WS_SETUP_MSG11'
,p_message_language=>'it'
,p_message_text=>'Selezionare lo schema da utilizzare per questi oggetti:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279033157669868532)
,p_name=>'APEX_WS_SETUP_MSG12'
,p_message_language=>'it'
,p_message_text=>'Tabelle esistenti da utilizzare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279034012637868533)
,p_name=>'APEX_WS_SETUP_MSG13'
,p_message_language=>'it'
,p_message_text=>'Gli oggetti di database del Websheet verranno riutilizzati sulla base delle informazioni seguenti. Confermare la richiesta.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278694974440868317)
,p_name=>'APEX_WS_SETUP_MSG2'
,p_message_language=>'it'
,p_message_text=>'Se si desidera creare gli oggetti Websheet in un nuovo schema, utilizzare la procedura guidata <a href=%0>Richiedi schema di database</a>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278695047144868317)
,p_name=>'APEX_WS_SETUP_MSG3'
,p_message_language=>'it'
,p_message_text=>'Per eseguire i Websheet, sono richiesti gli oggetti seguenti:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278695163832868317)
,p_name=>'APEX_WS_SETUP_MSG5'
,p_message_language=>'it'
,p_message_text=>'Gli oggetti di database del Websheet verranno creati sulla base delle informazioni seguenti. Confermare la richiesta.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278695232688868317)
,p_name=>'APEX_WS_SETUP_MSG6'
,p_message_language=>'it'
,p_message_text=>'Tabelle da creare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278695353776868317)
,p_name=>'APEX_WS_SETUP_MSG7'
,p_message_language=>'it'
,p_message_text=>'Si stanno per rimuovere gli oggetti di database del Websheet. Verranno eliminati sia gli oggetti di database del Websheet che i dati interni che contengono i componenti di Websheet nell''area di lavoro. Continuare?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278695679139868318)
,p_name=>'APEX_WS_SETUP_MSG8'
,p_message_language=>'it'
,p_message_text=>unistr('Per eseguire i Websheet in modo corretto, \00E8 necessario correggere i seguenti oggetti non validi.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279032596393868532)
,p_name=>'APEX_WS_SETUP_MSG9'
,p_message_language=>'it'
,p_message_text=>'Si stanno per rimuovere le definizioni di Websheet per questa area di lavoro. Gli oggetti di database di Websheet sono utilizzati anche da altre aree di lavoro, quindi non verranno eliminati. I record associati a questa area di lavoro verranno elimin'
||'ati. Continuare?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278695780169868318)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278695815673868318)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278695418622868317)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_language=>'it'
,p_message_text=>'Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279032300192868532)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_language=>'it'
,p_message_text=>'Oggetti esistenti da usare'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277824025143867767)
,p_name=>'API_PRECONDITION_VIOLATED'
,p_message_language=>'it'
,p_message_text=>'Precondizione interfaccia API violata'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277982357120867867)
,p_name=>'APP.SETTING.CANNOT.GET'
,p_message_language=>'it'
,p_message_text=>unistr('Impossibile ottenere il valore per l''impostazione applicazione %0 perch\00E9 l''opzione di creazione associata \00E8 disabilitata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277982233174867867)
,p_name=>'APP.SETTING.CANNOT.SET'
,p_message_language=>'it'
,p_message_text=>unistr('Impossibile impostare il valore per l''impostazione applicazione %0 perch\00E9 l''opzione di creazione associata \00E8 disabilitata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279059091158868549)
,p_name=>'APP.SETTING.INVALID.VALUE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore dell''impostazione applicazione %0 non \00E8 valido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279058912300868549)
,p_name=>'APP.SETTING.NOT.DEFINED'
,p_message_language=>'it'
,p_message_text=>unistr('L''impostazione applicazione %0 richiesta non \00E8 definita')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279059131560868549)
,p_name=>'APP.SETTING.VALUE.NOT.NULL'
,p_message_language=>'it'
,p_message_text=>unistr('L''impostazione applicazione %0 non pu\00F2 essereimpostata su un valore nullo')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277875462948867799)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_language=>'it'
,p_message_text=>'Calcoli di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277875341919867799)
,p_name=>'APPLICACTION_PROCESS'
,p_message_language=>'it'
,p_message_text=>'Processi di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278440685237868156)
,p_name=>'APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278520823241868207)
,p_name=>'APPLICATION BUILDER'
,p_message_language=>'it'
,p_message_text=>'App Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278345359378868096)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_language=>'it'
,p_message_text=>'Condizione calcolo di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278348013298868098)
,p_name=>'APPLICATION IMAGE'
,p_message_language=>'it'
,p_message_text=>'Immagine applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278345423120868096)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_language=>'it'
,p_message_text=>'Condizione elaborazione di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278272138083868050)
,p_name=>'APPLICATIONS'
,p_message_language=>'it'
,p_message_text=>'applicazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278417867521868142)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_language=>'it'
,p_message_text=>'Applicazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278318102701868079)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_language=>'it'
,p_message_text=>unistr('Attivit\00E0 applicazioni')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278358646886868104)
,p_name=>'APPLICATION_ALIAS'
,p_message_language=>'it'
,p_message_text=>'Alias di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278356642061868103)
,p_name=>'APPLICATION_DELETED'
,p_message_language=>'it'
,p_message_text=>'Applicazione eliminata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277806858959867756)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_language=>'it'
,p_message_text=>'Sviluppo di applicazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278357624290868104)
,p_name=>'APPLICATION_HELP'
,p_message_language=>'it'
,p_message_text=>'Identifica l''applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278314788479868077)
,p_name=>'APPLICATION_ID'
,p_message_language=>'it'
,p_message_text=>'Numero applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278204017359868007)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_language=>'it'
,p_message_text=>unistr('L''ID applicazione \00E8 riservato.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278203969964868007)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_language=>'it'
,p_message_text=>'Il valore di ID applicazione deve essere un numero intero positivo.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278736192305868343)
,p_name=>'APPLICATION_IMAGES'
,p_message_language=>'it'
,p_message_text=>'Immagini dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278387912474868123)
,p_name=>'APPLICATION_ITEM'
,p_message_language=>'it'
,p_message_text=>'Elemento applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277904468786867818)
,p_name=>'APPLICATION_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Elementi di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277869811120867796)
,p_name=>'APPLICATION_LABEL'
,p_message_language=>'it'
,p_message_text=>'Applicazione: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278358537008868104)
,p_name=>'APPLICATION_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279087190482868567)
,p_name=>'APPLICATION_NAMES'
,p_message_language=>'it'
,p_message_text=>'Nomi applicazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278480944143868182)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_language=>'it'
,p_message_text=>'ID sostituzione applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278356137669868103)
,p_name=>'APPLICATION_OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279087096583868567)
,p_name=>'APPLICATION_PAGES'
,p_message_language=>'it'
,p_message_text=>'Pagine applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277992517560867873)
,p_name=>'APPLICATION_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278356389492868103)
,p_name=>'APPLICATION_STATUS'
,p_message_language=>'it'
,p_message_text=>'Stato applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278442638652868158)
,p_name=>'APPLICATION_VERSION'
,p_message_language=>'it'
,p_message_text=>'Versione applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277822418300867766)
,p_name=>'APPLICATION_X'
,p_message_language=>'it'
,p_message_text=>'Applicazione %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278301958017868068)
,p_name=>'APPROVED'
,p_message_language=>'it'
,p_message_text=>'Approvato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278362842385868107)
,p_name=>'APP_SUCCESS_MSG'
,p_message_language=>'it'
,p_message_text=>'Creazione dell''applicazione completata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279089795619868568)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_language=>'it'
,p_message_text=>'Applicazione modello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277856841114867788)
,p_name=>'APP_TYPE_DATABASE'
,p_message_language=>'it'
,p_message_text=>'Applicazione di database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277856935954867788)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_language=>'it'
,p_message_text=>unistr('Applicazione di produttivit\00E0 o di esempio')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278384373568868121)
,p_name=>'APP_TYPE_PACKAGED_WS'
,p_message_language=>'it'
,p_message_text=>'Websheet di esempio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277856782555867788)
,p_name=>'APP_TYPE_WEBSHEET'
,p_message_language=>'it'
,p_message_text=>'Applicazione Websheet'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278301495580868068)
,p_name=>'ARCHIVED'
,p_message_language=>'it'
,p_message_text=>'Archiviato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277870195489867796)
,p_name=>'ARCHIVELOG'
,p_message_language=>'it'
,p_message_text=>'Archiviazione log: attiva'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278121037979867954)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_language=>'it'
,p_message_text=>'Gli argomenti devono avere checksum'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278216807433868015)
,p_name=>'ARGUMENT_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome argomento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278217066644868015)
,p_name=>'ARGUMENT_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo argomento'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278295331417868064)
,p_name=>'ASAP'
,p_message_language=>'it'
,p_message_text=>'Il prima possibile'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278291987875868062)
,p_name=>'ASSIGNED'
,p_message_language=>'it'
,p_message_text=>'Assegnato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277990163049867872)
,p_name=>'ASSIGNEE'
,p_message_language=>'it'
,p_message_text=>'Assegnatario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279114658765868584)
,p_name=>'ASSIGN_LABEL'
,p_message_language=>'it'
,p_message_text=>'Assegna %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278050713736867910)
,p_name=>'ASSOCIATED'
,p_message_language=>'it'
,p_message_text=>'associato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277992029238867873)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_language=>'it'
,p_message_text=>'Funzioni associate'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278323362489868082)
,p_name=>'ATTACHMENT'
,p_message_language=>'it'
,p_message_text=>'Allegato'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279131044949868595)
,p_name=>'AT_RISK_LABEL'
,p_message_language=>'it'
,p_message_text=>'A rischio'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278020622647867891)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_language=>'it'
,p_message_text=>'Si sta per eseguire la migrazione delle opzioni di autenticazione personalizzate di questa applicazione in uno schema di autenticazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278020168668867891)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_language=>'it'
,p_message_text=>'Metodo di autenticazione corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278020595180867891)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_language=>'it'
,p_message_text=>'Funzione di autenticazione personalizzata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278020245408867891)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina di login'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278020437663867891)
,p_name=>'AUTH.LOGIN_URL'
,p_message_language=>'it'
,p_message_text=>'URL di login'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278020362942867891)
,p_name=>'AUTH.NONE'
,p_message_language=>'it'
,p_message_text=>'nessuno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278025710751867894)
,p_name=>'AUTHENTICATION'
,p_message_language=>'it'
,p_message_text=>'Autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278346369304868096)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_language=>'it'
,p_message_text=>'Funzione di autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278346003660868096)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_language=>'it'
,p_message_text=>'Schema di autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278040802716867904)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_language=>'it'
,p_message_text=>unistr('Si sta per eliminare uno schema di autenticazione dall''applicazione %0. Se l''applicazione non sta utilizzando attualmente un''autenticazione di tipo SCHEME o se lo schema di autenticazione non \00E8 quello corrente, l''applicazione continuer\00E0 a funzionare ')
||unistr('correttamente se si elimina lo schema. Se il flusso utilizza un''autenticazione di tipo SCHEME e questo \00E8 lo schema di autenticazione corrente, l''applicazione continuer\00E0 a essere eseguita utilizzando l''autenticazione di tipo SCHEME, ma con uno schema ')
||unistr('di autenticazione predefinito che utilizzer\00E0 una pagina di login incorporata con verifica delle credenziali "open door" (tutti potranno eseguire l''applicazione). ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278042762781867905)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_language=>'it'
,p_message_text=>unistr('Fare clic sul pulsante Rendi corrente affinch\00E9 l''applicazione utilizzi questo schema di autenticazione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278550668124868226)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_language=>'it'
,p_message_text=>'Account di Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277803458246867754)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'it'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278550762496868226)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_language=>'it'
,p_message_text=>'Personalizzato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278551074943868226)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_language=>'it'
,p_message_text=>'Nessuna autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278550849970868226)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_language=>'it'
,p_message_text=>'Account di database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278984037555868500)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_language=>'it'
,p_message_text=>'Variabile di intestazione HTTP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278551252497868226)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_language=>'it'
,p_message_text=>'Oracle Application Server Single Sign-On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278550918294868226)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_language=>'it'
,p_message_text=>'Directory LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278551170570868226)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_language=>'it'
,p_message_text=>'Credenziali "open door"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277793619683867748)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_language=>'it'
,p_message_text=>'Sign-In SAML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277832199926867772)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_language=>'it'
,p_message_text=>'Social Sign-In'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278389096607868124)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_language=>'it'
,p_message_text=>'Schema di autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278345961083868096)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_language=>'it'
,p_message_text=>'Schema di autorizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277803518819867754)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'it'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277822664536867766)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_language=>'it'
,p_message_text=>'Query SQL - Esiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277822711095867766)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_language=>'it'
,p_message_text=>'Funzione PL/SQL che restituisce un risultato booleano'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278199825514868004)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_language=>'it'
,p_message_text=>'In ruolo o gruppo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278199931048868004)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_language=>'it'
,p_message_text=>'Non in ruolo o gruppo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277822868790867766)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore dell''elemento in Espressione 1 \00E8 uguale a Espressione 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277822984731867766)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore dell''elemento in Espressione 1 \00E8 NOT NULL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277823051929867766)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore dell''elemento in Espressione 1 \00E8 NULL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277823147156867766)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore dell''elemento in Espressione 1 NON \00E8 uguale a Espressione 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277823277070867766)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'Query SQL - Non esiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277823387740867766)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore della preferenza in Espressione 1 \00E8 uguale a Espressione 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277823411721867767)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore della preferenza in Espressione 1 NON \00E8 uguale a Espressione 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277888448114867808)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_language=>'it'
,p_message_text=>'Valutazione per ogni visualizzazione pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277888505822867808)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_language=>'it'
,p_message_text=>'Valuta una volta per sessione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277825825835867768)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_language=>'it'
,p_message_text=>'Account scaduto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277825707688867768)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_language=>'it'
,p_message_text=>'Account bloccato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277826120979867768)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_language=>'it'
,p_message_text=>'Numero massimo di tentativi di login superato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277826271728867768)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore interno sconosciuto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277826010836867768)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_language=>'it'
,p_message_text=>'Primo utilizzo password'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277825999138867768)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_language=>'it'
,p_message_text=>'Password errata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277825520263867768)
,p_name=>'AUTH_SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Autenticazione riuscita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277825645608867768)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_language=>'it'
,p_message_text=>'Nome utente sconosciuto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277940431646867840)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_language=>'it'
,p_message_text=>'Nome di area di lavoro sconosciuto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277950900899867847)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_language=>'it'
,p_message_text=>'Nome di area di lavoro sconosciuto: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278094775465867937)
,p_name=>'AUTOCOMMIT'
,p_message_language=>'it'
,p_message_text=>'Istruzione di commit non applicabile. Viene eseguito il commit automatico di tutte le istruzioni.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278418433705868142)
,p_name=>'AUTOPROVISION_MODE'
,p_message_language=>'it'
,p_message_text=>unistr('Modalit\00E0 di provisioning')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277801111866867753)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_language=>'it'
,p_message_text=>'Primo elemento'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278444306740868159)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_language=>'it'
,p_message_text=>unistr('Disponibilit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277830788252867771)
,p_name=>'AVAILABLE'
,p_message_language=>'it'
,p_message_text=>'Disponibili'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278648066002868287)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_language=>'it'
,p_message_text=>'Disponibile solo per gli sviluppatori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278647979086868287)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_language=>'it'
,p_message_text=>'Disponibile con barra degli strumenti sviluppatore'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278318978671868079)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_language=>'it'
,p_message_text=>'Tempo medio di presentazione (secondi)'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277889222899867808)
,p_name=>'BACK'
,p_message_language=>'it'
,p_message_text=>'Indietro'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278299872450868067)
,p_name=>'BAR_CHART'
,p_message_language=>'it'
,p_message_text=>'Grafico a barre'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278721545895868334)
,p_name=>'BASIC'
,p_message_language=>'it'
,p_message_text=>'Di base'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277844514868867780)
,p_name=>'BASIC_DEVELOPER'
,p_message_language=>'it'
,p_message_text=>'Sviluppatore di base'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278279199538868054)
,p_name=>'BEFORE'
,p_message_language=>'it'
,p_message_text=>'Prima'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279092456357868570)
,p_name=>'BEFORE LIST ENTRY'
,p_message_language=>'it'
,p_message_text=>'Prima della voce di lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279113319643868583)
,p_name=>'BEFORE_FIRST'
,p_message_language=>'it'
,p_message_text=>'Prima del primo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278349273699868098)
,p_name=>'BIND_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta associazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278348517580868098)
,p_name=>'BIND_VARIABLE'
,p_message_language=>'it'
,p_message_text=>'Bind variable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278348693569868098)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta bind variable'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278364480197868108)
,p_name=>'BLACK_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo nero'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277807982868867757)
,p_name=>'BLANK'
,p_message_language=>'it'
,p_message_text=>'Vuota'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278322577622868081)
,p_name=>'BLOB_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278482662332868183)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_language=>'it'
,p_message_text=>'Scarica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277859666586867789)
,p_name=>'BLOB_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formato BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278483024459868183)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_language=>'it'
,p_message_text=>'Allegato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278482749330868183)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_language=>'it'
,p_message_text=>'DOWNLOAD'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278482880575868183)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_language=>'it'
,p_message_text=>'IMAGE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278482906169868183)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_language=>'it'
,p_message_text=>'In linea'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278323542140868082)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_language=>'it'
,p_message_text=>'Formato BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278323099819868082)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna ultimo aggiornamento BLOB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278322446418868081)
,p_name=>'BLOB_TABLE'
,p_message_language=>'it'
,p_message_text=>'Tabella BLOB'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278364310533868108)
,p_name=>'BLUE_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo blu'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278339584673868092)
,p_name=>'BRANCH CONDITION'
,p_message_language=>'it'
,p_message_text=>'Condizione diramazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277892833972867810)
,p_name=>'BRANCHES'
,p_message_language=>'it'
,p_message_text=>'Diramazioni'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278116969133867951)
,p_name=>'BREADCRUMB'
,p_message_language=>'it'
,p_message_text=>'Indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278279819478868054)
,p_name=>'BREADCRUMB LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278279942000868054)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_language=>'it'
,p_message_text=>'Nome lungo indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278117035450867952)
,p_name=>'BREADCRUMBS'
,p_message_language=>'it'
,p_message_text=>'Indicatori di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278372992968868113)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_language=>'it'
,p_message_text=>'Voce di indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278388197901868123)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_language=>'it'
,p_message_text=>'Voce di indicatore di percorso: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278204206630868007)
,p_name=>'BREADCRUMB_PAGES'
,p_message_language=>'it'
,p_message_text=>'Pagine indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278288065768868060)
,p_name=>'BREADCRUMB_REGION'
,p_message_language=>'it'
,p_message_text=>'Area con indicatori di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277953259315867848)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_language=>'it'
,p_message_text=>'Creazione dell''indicatore di percorso completata.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278282488240868056)
,p_name=>'BROWSE_ICON'
,p_message_language=>'it'
,p_message_text=>'Icona Sfoglia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278282248110868056)
,p_name=>'BROWSE_PACKAGE'
,p_message_language=>'it'
,p_message_text=>'Sfoglia package'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278216538890868014)
,p_name=>'BROWSE_TABLE'
,p_message_language=>'it'
,p_message_text=>'Sfoglia tabella'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277811214002867759)
,p_name=>'BUFFER CACHE'
,p_message_language=>'it'
,p_message_text=>'Buffer cache'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278295863077868065)
,p_name=>'BUG'
,p_message_language=>'it'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278320065380868080)
,p_name=>'BUGS'
,p_message_language=>'it'
,p_message_text=>'Bug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278342555837868094)
,p_name=>'BUGS_ASSIGNED'
,p_message_language=>'it'
,p_message_text=>'bug assegnato/i'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278381747455868119)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_language=>'it'
,p_message_text=>'Bug assegnati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277839846513867777)
,p_name=>'BUGS_CLOSED'
,p_message_language=>'it'
,p_message_text=>'Bug chiusi (%0 / %1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278757288131868356)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_language=>'it'
,p_message_text=>'Percentuale chiusura bug (%0/%1):'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278381872133868119)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_language=>'it'
,p_message_text=>'Bug non assegnati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278381961389868119)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_language=>'it'
,p_message_text=>'Nessuna data Correggi entro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278757642908868357)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_language=>'it'
,p_message_text=>'Bug: chiusi %1 su %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279121537599868589)
,p_name=>'BUG_LABEL'
,p_message_language=>'it'
,p_message_text=>'Bug: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278335842230868090)
,p_name=>'BUILD QUERY'
,p_message_language=>'it'
,p_message_text=>'Crea query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277803088726867754)
,p_name=>'BUILDER'
,p_message_language=>'it'
,p_message_text=>'Builder'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278441803177868157)
,p_name=>'BUILDER.PLUGINS'
,p_message_language=>'it'
,p_message_text=>'Plugin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278437324626868154)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_language=>'it'
,p_message_text=>'[Non supportato]'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278732078138868340)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_language=>'it'
,p_message_text=>'Messaggio di area di lavoro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278033097981867899)
,p_name=>'BUILD_OPTION'
,p_message_language=>'it'
,p_message_text=>'Opzione di creazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278506236667868198)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_language=>'it'
,p_message_text=>'Opzione di creazione: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279120237452868588)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_language=>'it'
,p_message_text=>'Stato di creazione: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278507139684868198)
,p_name=>'BUILD_VERSION'
,p_message_language=>'it'
,p_message_text=>'Versione build'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278375307370868115)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello report incorporato'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278278365229868053)
,p_name=>'BUTTON'
,p_message_language=>'it'
,p_message_text=>'pulsante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278279020150868054)
,p_name=>'BUTTON LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta pulsante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278484369840868184)
,p_name=>'BUTTON.ADD'
,p_message_language=>'it'
,p_message_text=>'Aggiungi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277819645649867764)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_language=>'it'
,p_message_text=>'In Attributi pulsante del pulsante selezionato non deve essere presente alcun ID'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277819503475867764)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 necessario che il pulsante selezionato abbia il valore di Azione impostato su ''Definita da azione dinamica''')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277819800029867764)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_language=>'it'
,p_message_text=>'Il pulsante selezionato utilizza un modello di pulsante che non contiene la stringa di sostituzione #BUTTON_ID#'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278484132166868184)
,p_name=>'BUTTON.DELETE'
,p_message_language=>'it'
,p_message_text=>'Elimina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277893118727867811)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_language=>'it'
,p_message_text=>'Specificare una pagina.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277869374779867795)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_language=>'it'
,p_message_text=>'Specificare la query del report.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277856590346867787)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_language=>'it'
,p_message_text=>'Specificare la richiesta pulsante per tutti i tipi di origine per la richiesta pulsante, a meno che il tipo di origine per la richiesta pulsante non sia "Sempre NULL".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277857285380867788)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_language=>'it'
,p_message_text=>'Specificare un tipo di origine per richiesta pulsante.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277893270989867811)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_language=>'it'
,p_message_text=>'Specificare un valore per Destinazione URL.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277822156477867766)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_language=>'it'
,p_message_text=>unistr('Quando Azione \00E8 impostato su ''Definita da azione dinamica'', gli attributi del pulsante non devono contenere alcun ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277894834914867812)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_language=>'it'
,p_message_text=>'Specificare un valore per Immagine.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277894990043867812)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_language=>'it'
,p_message_text=>'Specificare un valore per Stile.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277894759330867812)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Specificare un valore per Modello.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277822090327867766)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_language=>'it'
,p_message_text=>unistr('Quando lo stile del pulsante \00E8 ''Pulsante basato su modello'' e Azione \00E8 impostato su ''Definita da azione dinamica'', il modello di pulsante selezionato deve contenere la stringa di sostituzione #BUTTON_ID#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277809657020867758)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_language=>'it'
,p_message_text=>unistr('Impossibile eliminare il pulsante poich\00E9 vi si fa riferimento in un''azione dinamica (Pagina: %0, azione dinamica: ''%1'', azione: ''%2'', attributo: ''Elemento interessato'').')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277809532860867758)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_language=>'it'
,p_message_text=>unistr('Impossibile eliminare il pulsante poich\00E9 vi si fa riferimento in un''azione dinamica (Pagina: %0, azione dinamica: ''%1'', attributo: ''When'').')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278484276714868184)
,p_name=>'BUTTON.SUBMIT'
,p_message_language=>'it'
,p_message_text=>'Sottometti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278480102507868181)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_language=>'it'
,p_message_text=>'Da utilizzare in un attributo "onClick"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278483683618868183)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_language=>'it'
,p_message_text=>'Da utilizzare in un attributo "href"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277893076009867811)
,p_name=>'BUTTONS'
,p_message_language=>'it'
,p_message_text=>'Pulsanti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278349710990868099)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_language=>'it'
,p_message_text=>'Attributi pulsante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277801964925867753)
,p_name=>'BUTTON_CSS_CLASSES'
,p_message_language=>'it'
,p_message_text=>'Classi CSS pulsanti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278000422219867878)
,p_name=>'BUTTON_ID'
,p_message_language=>'it'
,p_message_text=>unistr('L''ID pulsante generato sar\00E0 l''ID statico del pulsante se definito oppure in caso contrario sar\00E0 un ID generato internamente nel formato ''B'' || [ID pulsante interno]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279120087238868588)
,p_name=>'BUTTON_LABEL'
,p_message_language=>'it'
,p_message_text=>'Pulsante: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278354974837868102)
,p_name=>'BUTTON_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di pulsante'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277889954411867809)
,p_name=>'BYTES'
,p_message_language=>'it'
,p_message_text=>'byte'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278295497609868064)
,p_name=>'BY_NEXT_PATCH'
,p_message_language=>'it'
,p_message_text=>'Per patch successiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278295505640868064)
,p_name=>'BY_NEXT_RELEASE'
,p_message_language=>'it'
,p_message_text=>'Per release successiva'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279219491228868651)
,p_name=>'CA.ABOUT'
,p_message_language=>'it'
,p_message_text=>'Informazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279185782156868630)
,p_name=>'CA.ABOUT.PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina delle informazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279185646077868629)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Include una pagina Informazioni sull''applicazione che contenga la descrizione e la versione dell''applicazione e il conteggio delle pagine.',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278010527725867885)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_language=>'it'
,p_message_text=>'Container contenuto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279219686725868651)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Pagina delle informazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279219795038868651)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('Il testo relativo all''applicazione specifica pu\00F2 essere inserito in questo campo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279219393010868651)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_language=>'it'
,p_message_text=>'Informazioni su questa pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279231674061868659)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_language=>'it'
,p_message_text=>'Informazioni su questa release in anteprima'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279186075860868630)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_language=>'it'
,p_message_text=>'Controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279221947502868653)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_language=>'it'
,p_message_text=>'Azioni di controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279211473362868646)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_language=>'it'
,p_message_text=>'Configurazione di controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279184421588868629)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_language=>'it'
,p_message_text=>'Abilita l''autorizzazione utente basata su ruoli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279186128335868630)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Incorpora l''autenticazione utente basata su ruoli all''interno dell''applicazione.',
unistr('\00C8 possibile definire gli utenti come amministratori, collaboratori o lettori.'),
unistr('\00C8 quindi possibile definire facilmente accessi diversi in base ai ruoli per i vari componenti in tutta l''applicazione, ad esempio per le pagine, le voci di menu, le aree, le colonne, gli elementi, i pulsanti e cos\00EC via.</p>'),
'<p>Include i seguenti componenti:',
'<ul>',
'<li>Area della pagina amministrativa con collegamenti per accedere alle funzioni di controllo</li>',
'<li>Tabella utenti per gestire il controllo dell''accesso</li>',
'<li>Pagina di configurazione per impostare il livello di accesso degli utenti autenticati</li>',
'<li>Pagina di configurazione per specificare se i nomi utente sono o meno indirizzi di posta elettronica</li>',
'<li>Gestione della pagina di accesso degli utenti per segnalare e modificare l''accesso degli utenti</li>',
unistr('<li>Aggiunta della pagina utente con possibilit\00E0 di aggiungere un singolo utente</li>'),
unistr('<li>Aggiunta di una pagina per pi\00F9 utenti con possibilit\00E0 di aggiungere pi\00F9 utenti (solo nomi utente di posta elettronica)</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279210361695868645)
,p_name=>'CA.ACCESS.ROLE'
,p_message_language=>'it'
,p_message_text=>'Ruolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279211096853868646)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_language=>'it'
,p_message_text=>'ID ruolo di accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277929912610867834)
,p_name=>'CA.ACCESS.ROLES'
,p_message_language=>'it'
,p_message_text=>'Ruoli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279210494086868645)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_language=>'it'
,p_message_text=>'Account bloccato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277957769320867851)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_language=>'it'
,p_message_text=>'Confermato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279221737224868653)
,p_name=>'CA.ACL.INFORMATION'
,p_message_language=>'it'
,p_message_text=>'Informazioni ACL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279222484746868653)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_language=>'it'
,p_message_text=>unistr('Privilegi insufficienti: l''utente non \00E8 un amministratore')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279222565711868653)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_language=>'it'
,p_message_text=>unistr('Non si \00E8 autorizzati a visualizzare questa applicazione: non si \00E8 autorizzati ad accedere o l''account \00E8 stato bloccato. Contattare l''amministratore dell''applicazione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279222657478868653)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_language=>'it'
,p_message_text=>unistr('Privilegi insufficienti: l''utente non \00E8 un collaboratore')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279212116919868646)
,p_name=>'CA.ACL.SAVED'
,p_message_language=>'it'
,p_message_text=>'Impostazioni controllo dell''accesso salvate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279216865789868649)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_language=>'it'
,p_message_text=>'HTML pulsante azione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279215770393868649)
,p_name=>'CA.ACTION.LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta azione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279215836762868649)
,p_name=>'CA.ACTION.LINK'
,p_message_language=>'it'
,p_message_text=>'Collegamento azione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279218447074868650)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_language=>'it'
,p_message_text=>'HTML collegamento azione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279203979001868641)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_language=>'it'
,p_message_text=>'Azione elaborata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279209485914868645)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_language=>'it'
,p_message_text=>unistr('Attivit\00E0 per ora')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279243773725868667)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_language=>'it'
,p_message_text=>unistr('Dashboard attivit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279186248395868630)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_language=>'it'
,p_message_text=>unistr('Generazione report su attivit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279185481669868629)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('Include l''attivit\00E0 utente e i report degli errori')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279186315491868630)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Include numerosi report sull''attivit\00E0 degli utenti finali con l''applicazione. Determina gli utenti pi\00F9 attivi, le pagine pi\00F9 utilizzate, le prestazioni delle pagine e gli errori che si sono verificati, per comprendere meglio la modalit\00E0 d''uso dell')
||'''applicazione e le aree che possono essere migliorate.</p>',
'<p>Include i seguenti componenti:',
'<ul>',
'<li>Report sui primi utenti</li>',
'<li>Report Log degli errori dell''applicazione</li>',
unistr('<li>Prestazioni globali, attivit\00E0 e prestazioni per pagina</li>'),
unistr('<li>Report sulle attivit\00E0 dell''applicazione per pagina</li>'),
'<li>Report dettagliato sulle viste di pagina</li>',
'',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278332161028868087)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_language=>'it'
,p_message_text=>'Data di inizio effettiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279221634688868653)
,p_name=>'CA.ADD'
,p_message_language=>'it'
,p_message_text=>'Aggiungi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279217036332868650)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Aggiungi modello di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279234675356868661)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_language=>'it'
,p_message_text=>unistr('Aggiungi pi\00F9 utenti - Passo 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279219953866868651)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_language=>'it'
,p_message_text=>'Aggiungi nuovo %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279202940312868641)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_language=>'it'
,p_message_text=>'Aggiungi notifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279075438171868559)
,p_name=>'CA.ADD.PAGE'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279211101150868646)
,p_name=>'CA.ADD.USER'
,p_message_language=>'it'
,p_message_text=>'Aggiungi utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279235084854868661)
,p_name=>'CA.ADD.USERS'
,p_message_language=>'it'
,p_message_text=>'Aggiungi utenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279187877040868631)
,p_name=>'CA.ADDING.PAGES'
,p_message_language=>'it'
,p_message_text=>'Aggiunta delle pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279188334732868631)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_language=>'it'
,p_message_text=>unistr('<p>Fare clic su <strong>Aggiungi pagina</strong> per aggiungere una pagina all''applicazione. Quindi selezionare il tipo di pagina (ad esempio Vuota, Grafico, Form, Report e cos\00EC via) e definirne gli attributi. Potrebbe essere inoltre necessario speci')
||'ficare una tabella o una vista valida oppure utilizzare SQL Workshop per preparare gli oggetti di database nell''area di lavoro.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279217874417868650)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_language=>'it'
,p_message_text=>'Avanzate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278331458398868087)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_language=>'it'
,p_message_text=>'Informazioni aggiuntive'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279210880484868646)
,p_name=>'CA.ADDRESS'
,p_message_language=>'it'
,p_message_text=>'Indirizzo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279191044233868633)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_language=>'it'
,p_message_text=>'Controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279191687649868633)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_language=>'it'
,p_message_text=>'Imposta il livello di accesso per gli utenti autenticati di questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279190103873868632)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_language=>'it'
,p_message_text=>unistr('Report attivit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279191105444868633)
,p_name=>'CA.ADMIN.ADD'
,p_message_language=>'it'
,p_message_text=>'Aggiungi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279192898952868634)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_language=>'it'
,p_message_text=>'Amministrazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279191518978868633)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_language=>'it'
,p_message_text=>'Amministratori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278367164400868110)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_language=>'it'
,p_message_text=>'Configurazione applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278477854685868180)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_language=>'it'
,p_message_text=>'Interfaccia utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279226424651868656)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_language=>'it'
,p_message_text=>'Amministrazione applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279226538617868656)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_language=>'it'
,p_message_text=>'Gestisci componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279189792818868632)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_language=>'it'
,p_message_text=>'Selezione stile tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279189858770868632)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_language=>'it'
,p_message_text=>'Imposta l''aspetto predefinito dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279189484236868632)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_language=>'it'
,p_message_text=>'Opzioni di configurazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279189312587868632)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_language=>'it'
,p_message_text=>'Abilita o disabilita le funzioni dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279190468712868633)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_language=>'it'
,p_message_text=>'Log degli errori dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279190570567868633)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_language=>'it'
,p_message_text=>'Report degli errori registrati da questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279189969694868632)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279190010226868632)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_language=>'it'
,p_message_text=>'Imposta il nome e una descrizione breve dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279189534332868632)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_language=>'it'
,p_message_text=>'Aggiornamenti applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279189639556868632)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_language=>'it'
,p_message_text=>'Gestisce la lista di aggiornamenti dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279189026319868632)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_language=>'it'
,p_message_text=>'Configurazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279191440839868633)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_language=>'it'
,p_message_text=>'Collaboratori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279242582918868666)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_language=>'it'
,p_message_text=>'Dashboard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279242407233868666)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('Visualizza metriche di attivit\00E0 dell''applicazione')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279194553851868635)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_language=>'it'
,p_message_text=>'Fuso orario predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279194651372868635)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_language=>'it'
,p_message_text=>'Impostare il fuso orario predefinito per questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279192331861868634)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_language=>'it'
,p_message_text=>'Posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279194732667868635)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279194858164868635)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_language=>'it'
,p_message_text=>'Impostare se la posta elettronica deve essere inviata e, in tal caso, chi deve esserne il destinatario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279191810359868633)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_language=>'it'
,p_message_text=>'Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279192139407868634)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279192203324868634)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_language=>'it'
,p_message_text=>'Consente di specificare se gli allegati devono essere consentiti.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279191945043868633)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_language=>'it'
,p_message_text=>'Feedback utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279192017624868634)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_language=>'it'
,p_message_text=>'Report di tutti i feedback sottomessi dagli utenti dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279192432127868634)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_language=>'it'
,p_message_text=>'Modelli di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279192557198868634)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_language=>'it'
,p_message_text=>'Gestisce i formati HTML e CSS dei modelli di posta elettronica usati da questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279189186896868632)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_language=>'it'
,p_message_text=>'Notifiche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279189231686868632)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_language=>'it'
,p_message_text=>'Visualizza le notifiche nella home page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279227129408868656)
,p_name=>'CA.ADMIN.PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina amministrazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279190675642868633)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_language=>'it'
,p_message_text=>'Prestazioni della pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279190742206868633)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('Report dell''attivit\00E0 e delle prestazioni in base alla pagina dell''applicazione')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279190857177868633)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_language=>'it'
,p_message_text=>'Visualizzazioni di pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279190977371868633)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_language=>'it'
,p_message_text=>'Report di ciascuna visualizzazione di pagina in base all''utente, inclusi data di accesso e tempo trascorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279191368638868633)
,p_name=>'CA.ADMIN.READERS'
,p_message_language=>'it'
,p_message_text=>'Lettori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279235735052868662)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_language=>'it'
,p_message_text=>'Invia messaggio di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279235806778868662)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_language=>'it'
,p_message_text=>'Invia messaggio di posta elettronica basato su modello da questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279190272671868632)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_language=>'it'
,p_message_text=>'Primi utenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279190325609868632)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_language=>'it'
,p_message_text=>'Report delle visualizzazioni di pagina aggregate per utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279191244353868633)
,p_name=>'CA.ADMIN.USERS'
,p_message_language=>'it'
,p_message_text=>'Utenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279191735407868633)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_language=>'it'
,p_message_text=>'Modifica le impostazioni del controllo dell''accesso e lo disabilita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279192646879868634)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_language=>'it'
,p_message_text=>'Log di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279192724915868634)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_language=>'it'
,p_message_text=>'Visualizza il log dei messaggi di posta elettronica inviati da questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278113756098867949)
,p_name=>'CA.ADVANCED'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
' <li><strong>Avanzate</strong>: espandere per visualizzare le opzioni avanzate.',
'    <ul>',
'      <li><strong>Imposta come home page</strong>: imposta la pagina corrente come home page per l''applicazione.<br>',
unistr('      &nbsp;&nbsp;&nbsp;La pagina definita in precedenza come home page verr\00E0 aggiornata.</li>'),
unistr('      <li><strong>Imposta come pagina di amministrazione</strong>: aggiunge la pagina corrente come pagina di amministrazione anzich\00E9 come pagina normale nell''applicazione. Per accedere, fare clic su Amministrazione nel menu principale, quindi effett')
||'uare la selezione nella lista Amministrazione applicazione.<br>',
unistr('        <em><strong>Nota:</strong> una pagina non pu\00F2 essere sia una home page che una pagina di amministrazione.</em></li>'),
'      &nbsp;<br>',
'      <li><strong>Guida sulla pagina</strong>: immettere il testo da aggiungere al testo della Guida per la pagina.</li>',
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277984009047867868)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
' <li><strong>Avanzate</strong>: espandere per visualizzare le opzioni avanzate.',
'    <ul>',
'      <li><strong>Guida sulla pagina</strong>: immettere il testo da aggiungere al testo della Guida per la pagina.</li>',
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279227587233868656)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni avanzate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279227664078868656)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_language=>'it'
,p_message_text=>'<p>Definire ulteriori impostazioni di definizione, sicurezza e globalizzazione. Queste impostazioni possono essere applicate quando si crea l''applicazione e possono essere inoltre modificate dopo la creazione dell''applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279230633570868658)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_language=>'it'
,p_message_text=>'<p>Per ulteriori informazioni, leggere la Guida dell''elemento ( <span class="fa fa-question-circle" aria-hidden="true"></span> ) per ciascuna impostazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279236445662868662)
,p_name=>'CA.AFTER.ROWS'
,p_message_language=>'it'
,p_message_text=>'Dopo le righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279216776849868649)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_language=>'it'
,p_message_text=>'HTML dopo le righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279219887682868651)
,p_name=>'CA.ALL.COLS'
,p_message_language=>'it'
,p_message_text=>'Tutte le colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279215959808868649)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_language=>'it'
,p_message_text=>'Consenti opt-out'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278325057890868083)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_language=>'it'
,p_message_text=>unistr('Consenti esecuzioni in modalit\00E0 limitata')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279209378867868645)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_language=>'it'
,p_message_text=>'Log degli errori dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279205226329868642)
,p_name=>'CA.APP.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278378007109868117)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('Indica se il controllo dell''accesso \00E8 attivato o meno.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278378191959868117)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_language=>'it'
,p_message_text=>'Livello di accesso predefinito concesso agli utenti autenticati non contenuti nella lista di controllo dell''accesso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279205651354868642)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_language=>'it'
,p_message_text=>'Impostazioni applicazione aggiornate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279205464741868642)
,p_name=>'CA.APP.SUBTITLE'
,p_message_language=>'it'
,p_message_text=>'Descrizione breve'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279205533612868642)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_language=>'it'
,p_message_text=>'Il testo immesso in questo campo viene visualizzato sotto il nome dell''applicazione nella relativa home page.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279194922967868635)
,p_name=>'CA.APPEARANCE'
,p_message_language=>'it'
,p_message_text=>'Aspetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279195041278868635)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_language=>'it'
,p_message_text=>'<p>Definire la combinazione di colori (stile tema) predefinita dell''applicazione, il punto in cui si trova la navigazione e l''icona usata per l''applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279214435717868648)
,p_name=>'CA.APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279201556068868640)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_language=>'it'
,p_message_text=>'Aspetto applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279195531156868636)
,p_name=>'CA.APPLICATION.ICON'
,p_message_language=>'it'
,p_message_text=>'Icona applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279195693086868636)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_language=>'it'
,p_message_text=>'<p>Fare clic su <strong>Scegli nuova icona</strong> per selezionare il colore dell''icona e una delle icone disponibili. La selezione viene visualizzata nella home page dell''applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279195929978868636)
,p_name=>'CA.APPLICATION.ID'
,p_message_language=>'it'
,p_message_text=>'ID applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279196046689868636)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_language=>'it'
,p_message_text=>'<p>Immettere un identificativo numerico univoco per l''applicazione. Per impostazione predefinita, questo campo contiene un identificativo generato automaticamente.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279215093829868648)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279207252501868643)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_language=>'it'
,p_message_text=>'Sessioni dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279185851357868630)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279184787278868629)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_language=>'it'
,p_message_text=>'Imposta il nome e una descrizione breve dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279185969965868630)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Consente agli amministratori dell''applicazione di aggiornare varie impostazioni quali il nome e una descrizione dell''applicazione, il fuso orario predefinito e cos\00EC via.</p>'),
'<p>Include i seguenti componenti:',
'<ul>',
'<li>Voce e form della lista di pagine amministrative</li>',
unistr('<li>Possibilit\00E0 di impostare il nome dell''applicazione</li>'),
unistr('<li>Possibilit\00E0 di impostare il sottotitolo dell''area hero della home page</li>'),
unistr('<li>Possibilit\00E0 di impostare i destinatari del feedback, qualora si utilizzi il feedback</li>'),
unistr('<li>Possibilit\00E0 di impostare il fuso orario predefinito dell''applicazione</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279241583631868665)
,p_name=>'CA.APPLICATIONITEM'
,p_message_language=>'it'
,p_message_text=>'Elemento applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279243304127868666)
,p_name=>'CA.APPLY'
,p_message_language=>'it'
,p_message_text=>'Applica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279245147593868668)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_language=>'it'
,p_message_text=>'Applicazione delle impostazioni predefinite applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279200777929868639)
,p_name=>'CA.APPLY.CHANGES'
,p_message_language=>'it'
,p_message_text=>'Applica modifiche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279243166748868666)
,p_name=>'CA.APPLY.FILTERS'
,p_message_language=>'it'
,p_message_text=>'Applica filtri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278475703297868178)
,p_name=>'CA.APP_BANNER'
,p_message_language=>'it'
,p_message_text=>'Applicazione creata dalla Creazione guidata applicazione %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278477048330868179)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_language=>'it'
,p_message_text=>'Salva impostazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279247319171868669)
,p_name=>'CA.ATTACHMENT'
,p_message_language=>'it'
,p_message_text=>'Allegato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278191427208867999)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_language=>'it'
,p_message_text=>'Conteggio allegati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279247412403868669)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome allegato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278191367112867999)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_language=>'it'
,p_message_text=>'Dimensione allegato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279243484507868667)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_language=>'it'
,p_message_text=>unistr('Impostazioni predefinite attributi gi\00E0 definite per %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279211572464868646)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_language=>'it'
,p_message_text=>unistr('Qualsiasi utente autenticato pu\00F2 accedere a questa applicazione')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279196755536868637)
,p_name=>'CA.AUTHENTICATION'
,p_message_language=>'it'
,p_message_text=>'Autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279196826722868637)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_language=>'it'
,p_message_text=>unistr('<p>Selezionare la modalit\00E0 di autenticazione degli utenti nell''applicazione.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278327703884868085)
,p_name=>'CA.AUTO.DROP'
,p_message_language=>'it'
,p_message_text=>'Eliminazione automatica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279207994075868644)
,p_name=>'CA.AVG.ELAPSED'
,p_message_language=>'it'
,p_message_text=>'Tempo medio trascorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278375143194868115)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_language=>'it'
,p_message_text=>'Torna al report Job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278192153882867999)
,p_name=>'CA.BCC'
,p_message_language=>'it'
,p_message_text=>'CCN'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279236367123868662)
,p_name=>'CA.BEFORE.ROWS'
,p_message_language=>'it'
,p_message_text=>'Prima delle righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279216689495868649)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_language=>'it'
,p_message_text=>'HTML prima delle righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279218106194868650)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Contenuto prima delle righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279193459719868634)
,p_name=>'CA.BLANK'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina vuota'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279193528502868634)
,p_name=>'CA.BLANK.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Consente di creare una pagina vuota come segnaposto. Una volta creata l''applicazione, \00E8 possibile creare immediatamente le aree sulla pagina tramite Page Designer.</p>'),
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome pagina</strong> (obbligatorio): immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
'<!--  <li><strong>Includi navigazione di pagina</strong>: selezionare questa opzione per visualizzare una lista di schede di tutte le altre pagine definite nell''applicazione.<br>',
'      &nbsp;&nbsp;&nbsp;Questa opzione viene in genere usata nella home page dell''applicazione.</li>',
'-->',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279226844146868656)
,p_name=>'CA.BLUEPRINT'
,p_message_language=>'it'
,p_message_text=>'Progetto applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279226995936868656)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Il progetto elenca la definizione dell''applicazione in formato JSON.</p>',
unistr('<p>Quando si accede a questa schermata per la prima volta, la definizione dell''applicazione corrente viene trasformata in un documento JSON e visualizzata. \00C8 possibile modificare il documento per aggiornare le propriet\00E0 dell''applicazione, quindi fare')
||' clic su <strong>Applica progetto</strong> per modificare i dettagli dell''applicazione corrente.</p>',
'<p>&nbsp;</p>',
unistr('<p>Per creare un numero elevato di pagine simili in modo molto pi\00F9 rapido rispetto all''uso manuale dell''opzione <strong>Aggiungi pagina</strong> per ciascuna pagina, copiare il codice JSON rilevante per una pagina e incollarlo pi\00F9 volte apportandovi ')
||'piccole modifiche.</p>',
unistr('<p>Fare clic su <strong>Carica progetto precedente</strong> per sostituire il progetto con la definizione di un''applicazione generata in precedenza. In questo modo \00E8 possibile ripetere molto facilmente la struttura di un''applicazione aggiungendo ulte')
||'riori pagine, modificando le funzioni o regolando le impostazioni, prima di generare nuovamente l''applicazione.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279215524789868649)
,p_name=>'CA.BODY1.TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo corpo 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279215617014868649)
,p_name=>'CA.BODY2.TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo corpo 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279236774815868662)
,p_name=>'CA.BOTH'
,p_message_language=>'it'
,p_message_text=>'Entrambi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279201943773868640)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_language=>'it'
,p_message_text=>'Dirama a pagina amministrativa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278112688385867949)
,p_name=>'CA.BUTTON.BAR'
,p_message_language=>'it'
,p_message_text=>'Barra dei pulsanti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279201668085868640)
,p_name=>'CA.BUTTONS'
,p_message_language=>'it'
,p_message_text=>'Pulsanti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279194122171868635)
,p_name=>'CA.CALENDAR'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina di calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279194261325868635)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di creare una pagina che visualizza un calendario.</p>',
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome pagina</strong> (obbligatorio): immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
'  <li><strong>Tabella o vista</strong> (obbligatorio): selezionare l''oggetto di database per il calendario.</li>',
'  <li><strong>Colonna di visualizzazione</strong> (obbligatorio): selezionare la colonna della tabella o della vista da visualizzare negli eventi di calendario.</li>',
'  <li><strong>Colonna data di inizio</strong> (obbligatorio): selezionare la colonna della data nella tabella o nella vista da usare come data di inizio per gli eventi di calendario.</li>',
'  <li><strong>Colonna data di fine</strong>: : selezionare la colonna della data nella tabella o nella vista da usare come data di fine per gli eventi di calendario.<br>',
unistr('      &nbsp;&nbsp;&nbsp;Se \00E8 stata specificata una data di fine, verranno visualizzati gli eventi basati sulla durata. </li>'),
unistr('  <li><strong>Mostra ora</strong>: selezionare <strong>S\00EC</strong> per mostrare la parte oraria degli eventi, nonch\00E9 abilitare le viste di calendario Settimanale e Giornaliero. Selezionare <strong>No</strong> per mostrare solo le date degli eventi.</')
||'li>',
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279200646197868639)
,p_name=>'CA.CANCEL'
,p_message_language=>'it'
,p_message_text=>'Annulla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279202581358868640)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_language=>'it'
,p_message_text=>'Annulla finestra di dialogo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278092761790867936)
,p_name=>'CA.CANCEL.MODAL'
,p_message_language=>'it'
,p_message_text=>'Annulla modale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279212416634868647)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_language=>'it'
,p_message_text=>'Impossibile rimuovere i privilegi di amministrazione dal record personale.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279244315168868667)
,p_name=>'CA.CARD'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina schede'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279244293983868667)
,p_name=>'CA.CARD.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di creare una pagina che visualizza le schede.</p>',
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome pagina</strong>(obbligatorio): immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
'  <li><strong>Tabella o vista</strong> (obbligatorio): selezionare l''oggetto di database per la scheda.</li>',
'  <li><strong>Titolo scheda</strong> (obbligatorio): selezionare la colonna della tabella o della vista da utilizzare come titolo per la scheda.</li>',
'  <li><strong>Colonna descrizione</strong> (obbligatorio): selezionare la colonna della tabella o della vista da utilizzare come descrizione per la scheda.</li>',
'  <li><strong>Colonna di testo aggiuntiva</strong>: selezionare la colonna della tabella o della vista da utilizzare come descrizione secondaria per la scheda.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279242894411868666)
,p_name=>'CA.CARDS'
,p_message_language=>'it'
,p_message_text=>'Schede'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279242995315868666)
,p_name=>'CA.CARDS.VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista schede'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278192291569867999)
,p_name=>'CA.CC'
,p_message_language=>'it'
,p_message_text=>'CC'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278476474362868179)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_language=>'it'
,p_message_text=>'Modifica filtri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279193274791868634)
,p_name=>'CA.CHART'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279193325341868634)
,p_name=>'CA.CHART.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di creare una pagina che visualizza un grafico ad aree, a barre, a linee o a torta.</p>',
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome pagina</strong> (obbligatorio): immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
'  <li><strong>Tipo di grafico</strong>: selezionare il tipo di grafico da visualizzare [<strong>Ad aree</strong>, <strong>A barre</strong>, <strong>A linee</strong>, <strong>A torta</strong>].</li>',
'  <li><strong>Tabella o vista</strong> (obbligatorio): selezionare l''oggetto di database per il grafico.</li>',
'  <li><strong>Colonna etichetta</strong> (obbligatorio): selezionare la colonna da utilizzare come etichetta per il grafico dalla tabella o dalla vista.</li>',
unistr('  <li><strong>Aggregazione valori</strong>: selezionare le modalit\00E0 di visualizzazione o aggregazione della colonna valori<br>'),
'      &nbsp;&nbsp;&nbsp;[Valore colonna, Somma, Conteggio].</li>',
'  <li><strong>Colonna valori</strong> (obbligatorio): selezionare la colonna numerica usata per calcolare i valori del grafico visualizzati dalla tabella o dalla vista.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279193665324868635)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h3>Esempi</h3>',
'<p>Rivedere gli esempi che mostrano come utilizzare i vari tipi di <strong>Riepilogo</strong>:</p>',
'<p><strong>Esempio 1:</strong> visualizza un grafico relativo ai dipendenti con la matricola dipendente del responsabile relativa a ciascun dipendente.',
'<code><ul>',
'  <li>Tabella o vista: selezionare EMP.</li>',
'  <li>Colonna etichetta: selezionare ENAME.</li>',
'  <li>Riepilogo: selezionare <u><strong>Valore colonna</strong></u>.</li>',
'  <li>Colonna valori: selezionare MGR.</li>',
'</ul></code>',
'</p>',
'<p><strong>Esempio 2:</strong> visualizza un grafico relativo ai dipendenti con il salario totale di ciascuna mansione lavorativa.',
'<code><ul>',
'  <li>Tabella o vista: selezionare EMP.</li>',
'  <li>Colonna etichetta: selezionare JOB.</li>',
'  <li>Riepilogo: selezionare <u><strong>Somma</strong></u>.</li>',
'  <li>Colonna valori: selezionare SAL.</li>',
'</ul></code>',
'</p>',
'<p><strong>Esempio 3:</strong> visualizza un grafico relativo ai dipendenti con il numero di dipendenti in ciascun reparto.',
'<code><ul>',
'  <li>Tabella o vista: selezionare EMP.</li>',
'  <li>Colonna etichetta: selezionare DEPTNO.</li>',
'  <li>Riepilogo: selezionare <u><strong>Conteggio</strong></u>.</li>',
'  <li>Colonna valori: selezionare EMPNO.</li>',
'</ul></code>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278329794198868086)
,p_name=>'CA.CLIENT.ID'
,p_message_language=>'it'
,p_message_text=>'ID client'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279247562783868669)
,p_name=>'CA.CLOSE'
,p_message_language=>'it'
,p_message_text=>'Chiudi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277957661273867851)
,p_name=>'CA.CLOSED'
,p_message_language=>'it'
,p_message_text=>'Chiuso/i'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279245573547868668)
,p_name=>'CA.COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279221473225868652)
,p_name=>'CA.COLUMN.1'
,p_message_language=>'it'
,p_message_text=>'Colonna 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279221500678868653)
,p_name=>'CA.COLUMN.2'
,p_message_language=>'it'
,p_message_text=>'Colonna 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279208807096868644)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_language=>'it'
,p_message_text=>'Alias colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279241325121868665)
,p_name=>'CA.COMMENTS'
,p_message_language=>'it'
,p_message_text=>'Commenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279206515033868643)
,p_name=>'CA.COMPONENT.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279211352242868646)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_language=>'it'
,p_message_text=>'Configura controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279201761687868640)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_language=>'it'
,p_message_text=>'Configura aspetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279201878576868640)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_language=>'it'
,p_message_text=>'<p>L''aspetto dell''applicazione viene definito dallo stile tema.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279205174563868642)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_language=>'it'
,p_message_text=>'Opzioni di configurazione aggiornate. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279187051884868630)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Opzioni di configurazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279185309134868629)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_language=>'it'
,p_message_text=>'Abilita o disabilita le funzioni dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279187141855868630)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Consente agli amministratori dell''applicazione di abilitare o disabilitare funzionalit\00E0 specifiche all''interno dell''applicazione. Questa funzione \00E8 utile se si selezionano funzioni che richiedono un ulteriore impegno a livello di sviluppo prima di')
||' poter essere usate dagli utenti finali.<br>',
unistr('Questa funzione pu\00F2 anche essere estesa a funzioni specifiche dell''applicazione. Se gli sviluppatori definiscono opzioni di creazione aggiuntive e le associano a funzionalit\00E0 specifiche in tutta l''applicazione, \00E8 possibile aggiungerle alle impostazio')
||'ni di configurazione per gli amministratori. Ad esempio, all''interno dell''applicazione Tracker clienti, gli amministratori possono attivare o disattivare funzioni quali Contatti, Caricamento dati, Geografia e molte altre ancora.',
'</p>',
'<p>Include i seguenti componenti:',
'<ul>',
unistr('<li>Possibilit\00E0 di abilitare e disabilitare funzionalit\00E0 dell''applicazione</li>'),
unistr('<li>Uso della funzione per consentire la funzionalit\00E0 selettiva in base alla distribuzione</li>'),
unistr('<li>Possibilit\00E0 di raggruppare le impostazioni dell''applicazione correlate</li>'),
'<li>Controllo dei componenti da parte degli sviluppatori dell''applicazione tramite opzioni di creazione</li>',
unistr('<li>Disponibilit\00E0 dalla pagina di amministrazione</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278324656355868083)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome credenziale connessione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278324737906868083)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario credenziale di connessione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279054618521868546)
,p_name=>'CA.CONTEXT'
,p_message_language=>'it'
,p_message_text=>'Contesto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279211893579868646)
,p_name=>'CA.CONTRIBUTOR'
,p_message_language=>'it'
,p_message_text=>'Collaboratore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278331651620868087)
,p_name=>'CA.CPU.USED'
,p_message_language=>'it'
,p_message_text=>'CPU utilizzata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279220320556868652)
,p_name=>'CA.CREATE'
,p_message_language=>'it'
,p_message_text=>'Crea'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279225426507868655)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina amministrazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279223053050868654)
,p_name=>'CA.CREATE.APP'
,p_message_language=>'it'
,p_message_text=>'Creazione dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279224148161868654)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_language=>'it'
,p_message_text=>'Creazione calcoli applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279223429010868654)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_language=>'it'
,p_message_text=>'Creazione icona dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279224002846868654)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_language=>'it'
,p_message_text=>'Creazione elementi applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279224240597868654)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_language=>'it'
,p_message_text=>'Creazione processi applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279065632896868553)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_language=>'it'
,p_message_text=>'Creazione delle impostazioni applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279231415845868659)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Crea un''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278376473608868116)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_language=>'it'
,p_message_text=>'Creazione dei ruoli applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279223625917868654)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_language=>'it'
,p_message_text=>'Creazione schemi di autorizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279224428513868654)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina vuota'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279223526805868654)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_language=>'it'
,p_message_text=>'Creazione opzioni di creazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279224843903868655)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina di calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279237747724868663)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina schede'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279224630380868655)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279225186026868655)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina report classico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279224703530868655)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina dashboard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279222920565868653)
,p_name=>'CA.CREATE.END'
,p_message_language=>'it'
,p_message_text=>'Completamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279245051549868668)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione della pagina Ricerca con facet'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279225752441868655)
,p_name=>'CA.CREATE.FEATURES'
,p_message_language=>'it'
,p_message_text=>'Creazione funzioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279242342682868666)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina contenuto filtrato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279224567820868654)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279223128453868654)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina globale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279225329030868655)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_language=>'it'
,p_message_text=>'Creazione lista navigazione home page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279225246695868655)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina griglia interattiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279225016138868655)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina report interattivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279231109659868659)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagine Master-Detail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279223808586868654)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_language=>'it'
,p_message_text=>'Creazione barre di navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279227095753868656)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_language=>'it'
,p_message_text=>'Creazione gruppo di pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279225611969868655)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_language=>'it'
,p_message_text=>'Esecuzione traduzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279225562657868655)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_language=>'it'
,p_message_text=>'Esecuzione traduzione per %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279224965057868655)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina report e form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279231389667868659)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_language=>'it'
,p_message_text=>'Salvataggio progetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279223901607868654)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_language=>'it'
,p_message_text=>'Creazione collegamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279224370439868654)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina di collegamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279222883173868653)
,p_name=>'CA.CREATE.START'
,p_message_language=>'it'
,p_message_text=>'Inizio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279223226833868654)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_language=>'it'
,p_message_text=>'Creazione script oggetti di supporto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279223767536868654)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_language=>'it'
,p_message_text=>'Creazione messaggi di testo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279237800434868663)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_language=>'it'
,p_message_text=>'Creazione pagina controllo temporale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279245223803868668)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_language=>'it'
,p_message_text=>'Crea pagina procedura guidata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279204400230868642)
,p_name=>'CA.CREATED'
,p_message_language=>'it'
,p_message_text=>'Data creazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279204518923868642)
,p_name=>'CA.CREATED.BY'
,p_message_language=>'it'
,p_message_text=>'Creazione di'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279192995943868634)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Creazione dell''applicazione in corso ...'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278325327129868083)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome credenziale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278331500623868087)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario credenziale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279205023434868642)
,p_name=>'CA.CURRENT.STATUS'
,p_message_language=>'it'
,p_message_text=>'Stato corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279226095304868655)
,p_name=>'CA.CUSTOM.QRY'
,p_message_language=>'it'
,p_message_text=>'Query personalizzata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278423276704868145)
,p_name=>'CA.CUSTOM.THEME'
,p_message_language=>'it'
,p_message_text=>'Usa tema personalizzato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278423397918868145)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Modifica la procedura guidata per consentire l''uso di un tema personalizzato al posto del tema universale.</p>',
'',
unistr('<p>Selezionare un tema area di lavoro per l''applicazione. Se il tema supporta gli stili, sar\00E0 possibile selezionare anche lo stile.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278092466814867936)
,p_name=>'CA.CUSTOM_THEME'
,p_message_language=>'it'
,p_message_text=>'Tema personalizzato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279226606792868656)
,p_name=>'CA.DASHBOARD'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina dashboard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279053028824868545)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_language=>'it'
,p_message_text=>'Grafico %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279226775512868656)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Consente di creare una pagina di dashboard con pi\00F9 grafici.</p>'),
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome pagina</strong> (obbligatorio): immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
'  </ul>',
'</ul>',
'&nbsp;<br>',
'<p>Ogni grafico (Grafico 1, Grafico 2, Grafico 3 e Grafico 4) viene impostato automaticamente su diversi tipi di grafico e si basa sui <em>dati di esempio</em>. ',
unistr('  Non \00E8 pertanto necessario immettere ulteriori dettagli per aggiungere questa pagina.'),
unistr('  \00C8 tuttavia possibile personalizzare ciascun grafico sostituendo i valori predefiniti con le proprie selezioni.<br>'),
'  Per personalizzare un grafico, immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome grafico</strong> (obbligatorio): immettere il nome per il grafico.</li>',
'  <li><strong>Tipo di grafico</strong>: selezionare il tipo di grafico da visualizzare [<strong>Ad aree</strong>, <strong>A barre</strong>, <strong>A linee</strong>, <strong>A torta</strong>].</li>',
'  <li><strong>Tabella o vista</strong> (obbligatorio): selezionare l''oggetto di database per il grafico.</li>',
'  <li><strong>Colonna etichetta</strong> (obbligatorio): selezionare dalla tabella o dalla vista la colonna da usare come etichetta per il grafico.</li>',
unistr('  <li><strong>Aggregazione valori</strong>: selezionare la modalit\00E0 di visualizzazione o aggregazione della colonna valori<br>'),
'      &nbsp;&nbsp;&nbsp;[Valore colonna, Somma, Conteggio].</li>',
'  <li><strong>Colonna valori</strong> (obbligatorio): selezionare dalla tabella o dalla vista la colonna numerica usata per calcolare i valori del grafico visualizzati.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279238449749868663)
,p_name=>'CA.DATATYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279239531957868664)
,p_name=>'CA.DATEFORMATMASK'
,p_message_language=>'it'
,p_message_text=>'Formato di visualizzazione data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279205715483868642)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_language=>'it'
,p_message_text=>'Fuso orario predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279205896841868642)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_language=>'it'
,p_message_text=>'Fuso orario predefinito aggiornato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279227451363868656)
,p_name=>'CA.DEFAULTS'
,p_message_language=>'it'
,p_message_text=>'Valori predefiniti attributi applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279227743935868657)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_language=>'it'
,p_message_text=>unistr('Questo documento JSON consente un controllo dettagliato sulla generazione dei nomi delle colonne di report e form, sui formati di visualizzazione e cos\00EC via. \00C8 anche possibile definire le liste di valori e altri componenti condivisi. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279244880086868667)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_language=>'it'
,p_message_text=>'Attributo lista di valori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279244917122868668)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di aggiungere un attributo LOV (Lista di valori). Le liste di valori possono essere utilizzate nelle definizioni delle colonne di tabella.</p>',
'<p>Immettere gli attributi riportati di seguito.',
'  <ul>',
'    <li><strong>Nome</strong> (obbligatorio): immettere il nome per la lista di valori.</li>',
'    <li><strong>Tipo</strong>: selezionare il tipo della lista [Strutturata, Dinamica, Statica].<br>',
'      Per il tipo <u>Strutturata</u> - ',
'      <ul>',
'          <li><strong>Tabella</strong> (obbligatorio): selezionare la tabella o la vista su cui basare la lista di valori.</li>',
'          <li><strong>Colonna di visualizzazione</strong> (obbligatorio): selezionare la colonna da mostrare agli utenti finali.</li>',
'          <li><strong>Colonna chiave</strong> (obbligatorio): selezionare il valore di colonna da restituire. Si tratta in genere della chiave primaria per la tabella.</li>',
'      </ul>',
'      &nbsp;<br>',
'      Per il tipo <u>Dinamica</u> -',
'      <ul>',
'          <li><strong>Query SQL</strong> (obbligatorio): immettere un''istruzione SELECT SQL valida per la restituzione di due valori (valore visualizzato e valore restituito).</li>',
'      </ul>',
'      &nbsp;<br>',
'      Per il tipo <u>Statica</u> -',
'      <ul>',
'          <li><strong>Lista di valori statica</strong> (obbligatorio): immettere una lista statica valida:',
'          <ul>',
'            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>Lista visualizzata secondo l''ordine di immissione</li>',
'            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>Lista in ordine alfabetico</li>',
'            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>Valore visualizzato e valore restituito uguali</li>',
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279246057785868668)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_language=>'it'
,p_message_text=>'Attributi report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279246165816868668)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di modificare gli attributi per tutti i report.</p>',
'<p>Immettere gli attributi riportati di seguito.',
'  <ul>',
'    <li><strong>Righe per pagina</strong>: immettere il numero di righe da visualizzare per impostazione predefinita.</li>',
unistr('    <li><strong>Metodo di impaginazione</strong>: selezionare le modalit\00E0 di visualizzazione dell''impaginazione dei report.</li>'),
'    <li><strong>Formato di visualizzazione numerico</strong>: immettere il formato di visualizzazione da applicare alle colonne e agli elementi numerici.</li>',
'    <li><strong>Formato di visualizzazione data</strong>: immettere il formato di visualizzazione da applicare alle colonne e agli elementi di data.</li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279245817310868668)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_language=>'it'
,p_message_text=>'Attributi tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279245611808868668)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_language=>'it'
,p_message_text=>'Attributi colonna tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279245718687868668)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di modificare gli attributi per la colonna di tabella selezionata.</p>',
'<p>Immettere gli attributi riportati di seguito.',
'  <ul>',
'    <li><strong>Tabella</strong> (Sola visualizzazione): la tabella associata.</li>',
'    <li><strong>Colonna</strong> (Sola visualizzazione): la colonna in base alla quale sono definiti gli attributi.</li>',
'    <li><strong>Etichetta</strong>: immettere il testo da usare nelle intestazioni dei report e nelle etichette dei form.</li>',
'    <li><strong>Controllo form</strong>: selezionare il tipo di elemento da usare nei form.</li>',
'    <li><strong>Lista di valori</strong>: selezionare la lista di valori esistente da utilizzare per visualizzare in modo appropriato i nomi riconoscibili dall''utente.</li>',
unistr('    <li><strong>Formato di visualizzazione</strong>: immettere il formato di visualizzazione appropriato in base al tipo di colonna (testo, numerico, data e cos\00EC via).</li>'),
'    <li><strong>Valore predefinito statico</strong>: immettere un valore predefinito di testo per la colonna.</li>',
unistr('    <li><strong>Includi in form</strong>: fare clic su S\00EC se la colonna deve essere inclusa nei form.</li>'),
unistr('    <li><strong>Includi in report</strong>: fare clic su S\00EC se la colonna deve essere inclusa nei report.</li>'),
unistr('    <li><strong>Obbligatorio</strong>: fare clic su S\00EC se \00E8 obbligatorio inserire i dati in questa colonna nei form.</li>'),
'    <li><strong>?</strong>: immettere il testo della Guida aggiunto all''attributo Guida dell''elemento.</li>',
'  </ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279245985198868668)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di modificare gli attributi per la tabella selezionata.</p>',
'<p>Immettere gli attributi riportati di seguito.',
'  <ul>',
'    <li><strong>Tabella</strong> (Sola visualizzazione): la tabella associata.</li>',
'    <li><strong>Etichetta, singolare</strong> (obbligatorio): immettere l''etichetta da usare nelle pagine dei form.</li>',
'    <li><strong>Etichetta, plurale</strong> (obbligatorio): immettere l''etichetta da usare nelle intestazioni delle aree e nei nomi delle pagine.</li>',
'    <li><strong>Colonna di visualizzazione primaria</strong>: selezionare la prima colonna da visualizzare, ad esempio nelle aree delle schede.</li>',
'    <li><strong>Colonna di visualizzazione secondaria</strong>: selezionare la seconda colonna da visualizzare, ad esempio nelle aree delle schede.</li>',
'    <li><strong>Colonna chiave primaria</strong>: selezionare la colonna di chiave primaria univoca per la tabella.</li>',
'    <li><strong>Descrizione</strong>: immettere la descrizione della tabella.</li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278325121169868083)
,p_name=>'CA.DEFERRED.DROP'
,p_message_language=>'it'
,p_message_text=>'Eliminazione differita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279240115316868664)
,p_name=>'CA.DEFINITION'
,p_message_language=>'it'
,p_message_text=>'Definizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279222706633868653)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_language=>'it'
,p_message_text=>'Disinstallazione completata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279203040762868641)
,p_name=>'CA.DELETE'
,p_message_language=>'it'
,p_message_text=>'Elimina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279222326603868653)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_language=>'it'
,p_message_text=>'Eseguire questa azione di eliminazione?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279188619408868631)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 certi di voler eliminare questa pagina?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279212822350868647)
,p_name=>'CA.DELETE.PHOTO'
,p_message_language=>'it'
,p_message_text=>'Elimina foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279203707602868641)
,p_name=>'CA.DESCRIPTION'
,p_message_language=>'it'
,p_message_text=>'Descrizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279220948393868652)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_language=>'it'
,p_message_text=>'Barra di navigazione desktop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279220842710868652)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_language=>'it'
,p_message_text=>'Menu di navigazione desktop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279202097786868640)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_language=>'it'
,p_message_text=>'Stile tema desktop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279202142352868640)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_language=>'it'
,p_message_text=>'Lo stile tema predefinito viene applicato a tutti gli utenti.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278325570773868083)
,p_name=>'CA.DESTINATION'
,p_message_language=>'it'
,p_message_text=>'Destinazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278325603564868083)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario destinazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278092535925867936)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_language=>'it'
,p_message_text=>'Pulsanti finestra di dialogo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279217382854868650)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_language=>'it'
,p_message_text=>'Spedisci messaggi di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279236957451868662)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_language=>'it'
,p_message_text=>'Determina se i messaggi di posta elettronica devono essere inviati dal framework di posta elettronica.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279203597573868641)
,p_name=>'CA.DISPLAY.FROM'
,p_message_language=>'it'
,p_message_text=>'Visualizza da'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279203463267868641)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_language=>'it'
,p_message_text=>'Sequenza di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279203604637868641)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_language=>'it'
,p_message_text=>'Visualizza fino a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279238654800868663)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279207169179868643)
,p_name=>'CA.DISTINCT .USERS'
,p_message_language=>'it'
,p_message_text=>'Utenti distinti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279220487804868652)
,p_name=>'CA.DOWNLOAD'
,p_message_language=>'it'
,p_message_text=>'Scarica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279227356333868656)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_language=>'it'
,p_message_text=>'Trascinare per riordinare la pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278113840273867950)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
'  <li><strong>Collegamento drill-down</strong>: espandere per visualizzare gli attributi per la definizione di un collegamento di drill-down.',
'&nbsp;<br>',
unistr('    <em><strong>Nota:</strong> Collegamento drill-down sar\00E0 visibile solo se la pagina corrente si basa su una tabella o una vista, se il tipo di report \00E8 Report interattivo e se \00E8 stata definita una pagina di report (Report interattivo) o Master-Det')
||'ail (Master-Detail).</em>',
'  <ul>',
unistr('    <li><strong>Colonna di collegamento</strong>: selezionare la colonna che verr\00E0 modificata in colonna di collegamento nel report.</li>'),
unistr('    <li><strong>Chiave di collegamento</strong>: selezionare la colonna della chiave di collegamento (chiave esterna) utilizzata per identificare il record specifico nella pagina a cui \00E8 collegato.</li>'),
unistr('    <li><strong>Collegamento alla pagina</strong>: selezionare la pagina di report o di form che verr\00E0 visualizzata selezionando il collegamento.</li>'),
unistr('    <li><strong>Chiave di destinazione</strong>: selezionare la colonna della chiave di destinazione (chiave primaria) nella tabella su cui \00E8 basata la pagina di report che verr\00E0 visualizzata selezionando il collegamento.'),
'  </ul>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279206296496868643)
,p_name=>'CA.ELAPSED'
,p_message_language=>'it'
,p_message_text=>'Tempo trascorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279188832429868632)
,p_name=>'CA.EMAIL'
,p_message_language=>'it'
,p_message_text=>'Framework posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279236545531868662)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_language=>'it'
,p_message_text=>'Indirizzi di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279246562364868669)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_language=>'it'
,p_message_text=>'Valore predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279188746157868631)
,p_name=>'CA.EMAIL.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('Aggiunge la possibilit\00E0 di configurare e inviare messaggi di posta elettronica')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279188980741868632)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Include la possibilit\00E0 di inviare messaggi di posta elettronica dall''applicazione. Utilizzando il modello di posta elettronica di esempio, \00E8 possibile inviare agli utenti messaggi di posta elettronica dall''aspetto professionale. I messaggi inviati')
||unistr(' vengono registrati in modo che gli amministratori possano tenere traccia dell''attivit\00E0 di posta elettronica.</p>'),
'<p>Include i componenti riportati di seguito.',
'<ul>',
'<li>Sistema di modelli di posta elettronica HTML estensibili</li>',
'<li>Package PL/SQL per l''invio di posta tramite package APEX</li>',
unistr('<li>Registrazione dell''attivit\00E0 e dello stato della posta elettronica</li>'),
'<li>Interfaccia utente amministrativa per gestire i modelli</li>',
'<li>Interfaccia utente amministrativa per visualizzare i log di posta elettronica</li>',
'<li>Interfaccia utente amministrativa per inviare i messaggi di posta elettronica</li>',
'</ul>',
'</p>',
'<p><em>Nota: questa funzione viene abilitata quando si seleziona Feedback</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279242277490868666)
,p_name=>'CA.EMAIL.FROM'
,p_message_language=>'it'
,p_message_text=>'Posta elettronica - Da'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279216376378868649)
,p_name=>'CA.EMAIL.LOG'
,p_message_language=>'it'
,p_message_text=>'Log di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279247163514868669)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Dettagli di impostazione posta elettronica obbligatori.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279246615025868669)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_language=>'it'
,p_message_text=>unistr('L''indirizzo del mittente non \00E8 valido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279238129701868663)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_language=>'it'
,p_message_text=>unistr('L''indirizzo del mittente non \00E8 valido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279237335529868663)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_language=>'it'
,p_message_text=>'Messaggio di posta elettronica elaborato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278192549101867999)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_language=>'it'
,p_message_text=>'Generazione report di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278378378687868117)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('Report relativo a tutti i messaggi di posta elettronica inseriti in coda per l''invio e a quelli gi\00E0 inviati.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279217297624868650)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279217645392868650)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_language=>'it'
,p_message_text=>'Impostazioni di posta elettronica aggiornate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279242665961868666)
,p_name=>'CA.EMAIL.STATUS'
,p_message_language=>'it'
,p_message_text=>'Stato messaggio di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279217712495868650)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_language=>'it'
,p_message_text=>'Dettagli modello di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278729499866868339)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_language=>'it'
,p_message_text=>unistr('Indisponibilit\00E0 pianificata per #SERVICE_NAME#')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278430892253868150)
,p_name=>'CA.EMAIL2'
,p_message_language=>'it'
,p_message_text=>'Posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279216262801868649)
,p_name=>'CA.EMAILS.SENT'
,p_message_language=>'it'
,p_message_text=>'Messaggi di posta elettronica inviati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279246759722868669)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_language=>'it'
,p_message_text=>'Abilita allegati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278330634632868087)
,p_name=>'CA.ENABLED'
,p_message_language=>'it'
,p_message_text=>'Abilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278327800628868085)
,p_name=>'CA.END.DATE'
,p_message_language=>'it'
,p_message_text=>'Data di fine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279218397272868650)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Contenuto dopo le righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279234408190868661)
,p_name=>'CA.ENTER.USERNAME'
,p_message_language=>'it'
,p_message_text=>'Immettere qui i nomi utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279206864784868643)
,p_name=>'CA.ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279209171440868645)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_language=>'it'
,p_message_text=>'Backtrace degli errori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279209038926868644)
,p_name=>'CA.ERROR.CODE'
,p_message_language=>'it'
,p_message_text=>'Codice di errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279208356090868644)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_language=>'it'
,p_message_text=>'Messaggio di errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278332386169868088)
,p_name=>'CA.ERROR.NUMBER'
,p_message_language=>'it'
,p_message_text=>'Numero errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278331364041868087)
,p_name=>'CA.ERRORS'
,p_message_language=>'it'
,p_message_text=>'Errori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278328213957868085)
,p_name=>'CA.EVENT.CONDITION'
,p_message_language=>'it'
,p_message_text=>'Condizione evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278328327881868085)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_language=>'it'
,p_message_text=>'Agente coda eventi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278328441616868085)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome coda eventi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278328587126868085)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario coda eventi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278328180716868085)
,p_name=>'CA.EVENT.RULE'
,p_message_language=>'it'
,p_message_text=>'Regola evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279234754303868661)
,p_name=>'CA.EXCEPTIONS'
,p_message_language=>'it'
,p_message_text=>'Eccezioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279247608837868669)
,p_name=>'CA.EXPERIENCE'
,p_message_language=>'it'
,p_message_text=>'Esperienza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278330356183868086)
,p_name=>'CA.FAILURE.COUNT'
,p_message_language=>'it'
,p_message_text=>'Conteggio errori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279204803564868642)
,p_name=>'CA.FEATURE'
,p_message_language=>'it'
,p_message_text=>'Funzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278984877526868501)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_language=>'it'
,p_message_text=>'Versione applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278984955069868501)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_language=>'it'
,p_message_text=>'Pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278476822477868179)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_language=>'it'
,p_message_text=>'Aggiungi utenti alla lista di controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278476652143868179)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_language=>'it'
,p_message_text=>'Vai al passo successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278476705470868179)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_language=>'it'
,p_message_text=>'Crea raccolte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278476539428868179)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_language=>'it'
,p_message_text=>'Impossibile modificare l''ultimo amministratore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278984541593868501)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_language=>'it'
,p_message_text=>unistr('Ultima attivit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278476362779868179)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_language=>'it'
,p_message_text=>unistr('Nessuna attivit\00E0 trovata')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278984793930868501)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_language=>'it'
,p_message_text=>'Causa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278476995845868179)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 richiesto almeno un feedback')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278477223265868179)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_language=>'it'
,p_message_text=>'Recupera ID file'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278475845653868178)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_language=>'it'
,p_message_text=>'Salva stile tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278475930689868178)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_language=>'it'
,p_message_text=>'Salva preferenza di stile utente finale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278984654737868501)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_language=>'it'
,p_message_text=>'Nome utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279193052599868634)
,p_name=>'CA.FEATURES'
,p_message_language=>'it'
,p_message_text=>'Funzioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279193154783868634)
,p_name=>'CA.FEATURES.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('Le funzioni forniscono funzionalit\00E0 a livello di applicazione e in genere vengono aggiunte una sola volta per applicazione. Scegliere le funzioni da includere nell''applicazione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279186916189868630)
,p_name=>'CA.FEEDBACK'
,p_message_language=>'it'
,p_message_text=>'Feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279184964870868629)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_language=>'it'
,p_message_text=>'Consente agli utenti di fornire un feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279186890585868630)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Fornisce agli utenti finali un meccanismo per inviare commenti generali agli amministratori e agli sviluppatori dell''applicazione. Gli invii includono informazioni utili sullo stato della sessione che consentono di determinare da quale punto gli u'
||unistr('tenti finali hanno inviato il feedback. La disponibilit\00E0 di un ciclo di feedback tanto semplice migliora la comunicazione tra la community di utenti e i proprietari dell''applicazione, migliorando notevolmente la soddisfazione degli utenti finali.</p>'),
'<p>Include i seguenti componenti:',
'<ul>',
unistr('<li>Possibilit\00E0 per gli utenti finali di lasciare un feedback facendo clic sull''icona della barra di navigazione</li>'),
'<li>Report amministrativo per visualizzare e aggiornare il feedback</li>',
'<li>Acquisizione delle informazioni su utente, data e ora e User Agent tramite il feedback</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279248030181868670)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_language=>'it'
,p_message_text=>'Fornire un feedback o la propria esperienza.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279247029429868669)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_language=>'it'
,p_message_text=>'Invia a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279246451320868668)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279214399515868648)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_language=>'it'
,p_message_text=>'Impostazioni feedback aggiornate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279247218622868669)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Feedback sottomesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278327904223868085)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome watcher file'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278328005148868085)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario watcher file'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277983134971867867)
,p_name=>'CA.FILED'
,p_message_language=>'it'
,p_message_text=>'Archiviato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277983237654867867)
,p_name=>'CA.FILED.BY'
,p_message_language=>'it'
,p_message_text=>'Presentato da'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279242758753868666)
,p_name=>'CA.FILTER.REPORT'
,p_message_language=>'it'
,p_message_text=>'Filtra report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279218754333868651)
,p_name=>'CA.FILTERS'
,p_message_language=>'it'
,p_message_text=>'Filtri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279245456134868668)
,p_name=>'CA.FINISH'
,p_message_language=>'it'
,p_message_text=>'Fine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279213089430868647)
,p_name=>'CA.FIRST.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278324912769868083)
,p_name=>'CA.FLAGS'
,p_message_language=>'it'
,p_message_text=>'Flag'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279194499198868635)
,p_name=>'CA.FORM'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279194333267868635)
,p_name=>'CA.FORM.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di creare una pagina che visualizza un pagina di form per consentire agli utenti finali di gestire i dati.</p>',
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome pagina</strong> (obbligatorio): immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
'  <li><strong>Tabella</strong> (obbligatorio): selezionare la tabella per il form.</li>',
unistr('<li><strong>Includi report</strong> (obbligatorio): selezionare questa opzione per creare un report e un form. La prima pagina \00E8 un report interattivo. In ogni riga \00E8 disponibile un collegamento a un form in cui gli utenti possono aggiornare il recor')
||'d. </li>',
'  &nbsp;<br>',
'<li><strong>Avanzate</strong>: espandere per visualizzare le opzioni avanzate.',
'     <ul>',
'      <li><strong>Guida sulla pagina</strong>: immettere il testo da aggiungere al testo della Guida per la pagina.</li>',
'      </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278112868910867949)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_language=>'it'
,p_message_text=>'Area elementi form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279220698933868652)
,p_name=>'CA.FORM.ON'
,p_message_language=>'it'
,p_message_text=>'Form su %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279234221940868661)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_language=>'it'
,p_message_text=>unistr('Il tipo di form non \00E8 valido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279240676070868665)
,p_name=>'CA.FORMATMASK'
,p_message_language=>'it'
,p_message_text=>'Formato di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279239679737868664)
,p_name=>'CA.FORMCONTROL'
,p_message_language=>'it'
,p_message_text=>'Controllo form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279204213862868641)
,p_name=>'CA.FROM'
,p_message_language=>'it'
,p_message_text=>'Da'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279217403950868650)
,p_name=>'CA.FROM.ADDRESS'
,p_message_language=>'it'
,p_message_text=>'Indirizzo mittente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279242131347868666)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_language=>'it'
,p_message_text=>'Impostazione posta elettronica "Indirizzo mittente"'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279238056636868663)
,p_name=>'CA.FROM.EMAIL'
,p_message_language=>'it'
,p_message_text=>'Posta elettronica mittente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279237931562868663)
,p_name=>'CA.FROM.WHO'
,p_message_language=>'it'
,p_message_text=>'Mittente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278986750301868502)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_language=>'it'
,p_message_text=>'Ricerca %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279207766676868644)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_language=>'it'
,p_message_text=>'Visualizzazioni pagina intera'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279216454834868649)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_language=>'it'
,p_message_text=>'HTML modello completo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279239133296868664)
,p_name=>'CA.FUNCTION'
,p_message_language=>'it'
,p_message_text=>'Funzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279187314643868631)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_language=>'it'
,p_message_text=>'Ricerca globale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279185199740868629)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_language=>'it'
,p_message_text=>unistr('Fornisce funzionalit\00E0 di ricerca nell''applicazione')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279187231931868631)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente agli utenti finali di cercare un testo nelle tabelle o viste chiave all''interno dell''applicazione. La pagina di ricerca avanzata include filtri per permettere agli utenti finali di limitare i risultati.<br>',
'Questa funzione estremamente efficace richiede un impegno a livello di sviluppo per definire le istruzioni SQL (in base agli esempi forniti).</p>',
'<p>Include i seguenti componenti:',
'<ul>',
'<li>Visualizzazione di un''icona di ricerca nella barra dell''intestazione</li>',
'<li>Presenza di una pagina di risultati di ricerca dettagliata con filtro della barra laterale</li>',
'<li>Implementazione delle istruzioni SQL da parte degli sviluppatori per definire la ricerca nell''applicazione</li>',
unistr('<li>Disponibilit\00E0 di dati di esempio per offrire una dimostrazione</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278329664287868086)
,p_name=>'CA.GLOBAL.UID'
,p_message_language=>'it'
,p_message_text=>'ID univoco globale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278475458662868178)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_language=>'it'
,p_message_text=>'Pagina globale - Desktop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278092614935867936)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_language=>'it'
,p_message_text=>'Vai a pagina di amministrazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279193930975868635)
,p_name=>'CA.GRID'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina della griglia interattiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279194097656868635)
,p_name=>'CA.GRID.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Consente di creare una pagina che visualizza una griglia interattiva simile a un foglio di calcolo. Quando la modifica \00E8 consentita, ovvero quando il tipo di griglia Consenti modifica \00E8 abilitato, gli utenti possono modificare direttamente pi\00F9 rig')
||'he nella pagina.</p>',
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome pagina</strong> (obbligatorio): immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
'  <li><strong>Tipo di query</strong>: selezionare l''origine per il report [<strong>Tabella o vista</strong> o <strong>Query SQL</strong>].<br>',
'    <strong>Tabella o vista</strong>:',
'    <ul>',
'      <li><strong>Tabella o vista</strong> (obbligatorio): selezionare l''oggetto di database per la griglia.</li>',
'    </ul>',
'    <strong>Query SQL</strong>:',
'    <ul>',
'      <li><strong>Query SQL</strong> (obbligatorio): immettere un''istruzione SQL valida che restituisca colonne distinte.</li>',
'    </ul>',
'  </li>',
'  <li><strong>Tipo di griglia</strong>: specificare per consentire o meno agli utenti di modificare le righe nella griglia [<strong>Consenti modifica</strong> o <strong>Sola lettura</strong>]. Per consentire la modifica, selezionare <strong>Consenti '
||'modifica</strong>.</li>',
'  &nbsp;<br>',
unistr('  <em><strong>Avvertenza:</strong> se si seleziona il tipo di query <strong>Query SQL</strong> e il tipo di griglia <strong>Consenti modifica</strong> e la query unisce tramite join due o pi\00F9 tabelle, la griglia interattiva generata produrr\00E0 un error')
||'e quando gli utenti tenteranno di aggiornare i record.',
unistr('Inoltre, se si seleziona il tipo di griglia <strong>Consenti modifica</strong> e la query (oppure la tabella o vista selezionata) usa una vista non aggiornabile, la griglia interattiva generata produrr\00E0 un errore quando gli utenti tenteranno di aggio')
||'rnare i record.</em><br>',
'  </li>',
'</ul>',
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279219214464868651)
,p_name=>'CA.HELP'
,p_message_language=>'it'
,p_message_text=>'Guida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279211629726868646)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_language=>'it'
,p_message_text=>unistr('Scegliere <strong>No</strong> se tutti gli utenti sono definiti nella lista di controllo dell''accesso. Scegliere <strong>S\00EC</strong>, se questa applicazione pu\00F2 essere usata anche dagli utenti autenticati che non si trovano nella lista di controllo d')
||'ell''accesso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279205303640868642)
,p_name=>'CA.HELP.APP.NAME'
,p_message_language=>'it'
,p_message_text=>unistr('Il testo immesso in questo campo viene usato in tutta l''applicazione, in modo pi\00F9 evidente, nell''angolo superiore sinistro di ogni pagina. La modifica avr\00E0 effetto immediatamente per l''amministratore che la apporta, ma gli altri utenti visualizzerann')
||'o la modifica solo quando accederanno a una nuova sessione (ad esempio, al successivo login).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279199919221868639)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_language=>'it'
,p_message_text=>'<p>Fare clic sull''icona di feedback (<span class="fa fa-comment-o" aria-hidden="true"></span>) nella barra di navigazione, in qualsiasi pagina dell''applicazione, per lasciare un feedback agli amministratori dell''applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279199632216868638)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_language=>'it'
,p_message_text=>unistr('<p>Questa \00E8 la home page dell''applicazione. Fare clic sulle schede per accedere alle varie pagine dell''applicazione o utilizzare il menu di navigazione sul lato della pagina.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279199822367868639)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_language=>'it'
,p_message_text=>unistr('<p>Questa \00E8 la home page dell''applicazione. Fare clic sulle schede per accedere alle varie pagine dell''applicazione o utilizzare il menu di navigazione nella parte superiore della pagina.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279200078098868639)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_language=>'it'
,p_message_text=>'<p>Immettere un termine di ricerca nel campo <strong>Cerca nell''applicazione</strong> di questa pagina o fare clic sull''icona di ricerca (<span class="fa fa-search" aria-hidden="true"></span>) nella barra di navigazione di qualsiasi pagina, per cerca'
||'re il termine all''interno dell''applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279200330310868639)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_language=>'it'
,p_message_text=>'<p>Fare clic sul menu a discesa del proprio nome nella barra di navigazione per scollegarsi dall''applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279200253506868639)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_language=>'it'
,p_message_text=>'<p>Fare clic sul menu dell''utente (<span class="fa fa-user" aria-hidden="true"></span>) nella barra di navigazione per aggiornare la preferenza di fuso orario e scollegarsi dall''applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279199719511868639)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_language=>'it'
,p_message_text=>'Home page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279200400596868639)
,p_name=>'CA.HELP.HOME.USER'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Fare clic sul menu dell''utente (<span class="fa fa-user" aria-hidden="true"></span>) nella barra di navigazione (in alto a destra) per accedere al proprio profilo utente e scollegarsi dall''applicazione.<br>',
unistr('Se si fa clic su <strong>Visualizza profilo personale</strong>, \00E8 poi possibile fare clic su <strong>Aggiorna profilo</strong> per immettere i dettagli personali e caricare una foto o un avatar.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279200193169868639)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Fare clic sul menu dell''utente (<span class="fa fa-user" aria-hidden="true"></span>) nella barra di navigazione per accedere al proprio profilo utente, aggiornare la preferenza di fuso orario e scollegarsi dall''applicazione.<br>',
unistr('Se si fa clic su <strong>Visualizza profilo personale</strong>, \00E8 poi possibile fare clic su <strong>Aggiorna profilo</strong> per immettere i dettagli personali e caricare una foto o un avatar.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279226226870868656)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Per trovare i dati, immettere un termine di ricerca nell''apposita finestra di dialogo oppure fare clic sulle intestazioni di colonna per limitare il numero di record restituiti.</p>',
'',
unistr('<p>\00C8 possibile eseguire numerose funzioni facendo clic sul pulsante <strong>Azioni</strong>, ad esempio selezionare le colonne visualizzate/nascoste e la relativa sequenza di visualizzazione, oltre a diverse funzioni relative a dati e formati. Inoltr')
||unistr('e, \00E8 possibile definire una vista aggiuntiva dei dati usando l''opzione basata sul grafico.</p>'),
'',
'<p>Se si desidera salvare le personalizzazioni, selezionare il report o fare clic su Download per scaricare i dati.<p>',
'<br>',
'<p>Per ulteriori informazioni, fare clic su ? nella parte inferiore del menu Azioni.</p>',
'',
'<p>Fare clic sul pulsante <strong>Reimposta</strong> per ripristinare le impostazioni predefinite del report interattivo.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279226172329868655)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\00C8 possibile inserire, aggiornare ed eliminare i dati direttamente all''interno di questa griglia interattiva.<br>'),
'  Inserire una nuova riga facendo clic sul pulsante Aggiungi riga.<br>',
'  Fare doppio clic in una cella o fare clic sul pulsante <strong>Modifica</strong> per aggiornare i valori dei dati, analogamente a quanto accede durante la modifica dei dati in un foglio di calcolo.</p>',
'',
'<p>Usare il menu Azioni riga (<span class="fa fa-bars" aria-hidden="true"></span>) nella parte superiore del report per duplicare, eliminare, aggiornare o ripristinare le righe selezionate.<br> ',
'  Usare il menu Azioni riga sulle singole righe per accedere anche alla visualizzazione di una singola riga o per aggiungere una nuova riga.</p>',
'',
'<p>Per trovare i dati, immettere un termine di ricerca nell''apposita finestra di dialogo o fare clic sulle intestazioni di colonna per limitare il numero di record restituiti.</p>',
'',
unistr('<p>\00C8 possibile eseguire numerose funzioni facendo clic sul pulsante <strong>Azioni</strong>, ad esempio selezionare le colonne visualizzate/nascoste e la relativa sequenza di visualizzazione, oltre a diverse funzioni relative a dati e formati. Inoltr')
||unistr('e, \00E8 possibile definire un''ulteriore vista dei dati utilizzando l''opzione basata sul grafico.</p>'),
'',
'<p>Se si desidera salvare le personalizzazioni, selezionare il report o fare clic su Download per scaricare i dati.<p>',
'',
'<p>Per ulteriori informazioni, fare clic su ? nella parte inferiore del menu Azioni.</p>',
'',
'<p>Fare clic sul pulsante <strong>Reimposta</strong> per ripristinare le impostazioni predefinite del report interattivo.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279199574611868638)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Per trovare i dati, immettere un termine di ricerca nell''apposita finestra di dialogo oppure fare clic sulle intestazioni di colonna per limitare il numero di record restituiti.</p>',
'',
unistr('<p>\00C8 possibile eseguire numerose funzioni facendo clic sul pulsante <strong>Azioni</strong>, ad esempio selezionare le colonne visualizzate/nascoste e la relativa sequenza di visualizzazione, oltre a diverse funzioni relative a dati e formati. Inoltr')
||unistr('e, \00E8 possibile definire ulteriori viste dei dati usando le opzioni basate su grafici, raggruppamenti e pivot.</p>'),
'',
'<p>Se si desidera salvare le personalizzazioni, selezionare il report o fare clic su Download per scaricare i dati. Immettere il proprio indirizzo di posta elettronica e il periodo di tempo previsto dalla sottoscrizione durante il quale i dati devono'
||' essere inviati regolarmente.<p>',
'',
'<p>Per ulteriori informazioni, fare clic su ? nella parte inferiore del menu Azioni.</p>',
'',
'<p>Fare clic sul pulsante <strong>Reimposta</strong> per ripristinare le impostazioni predefinite del report interattivo.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279235249801868661)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>In questa pagina di report sono visualizzati i record primari in un selettore a lato della pagina. ',
'  Selezionare un record per visualizzare il record Master e qualsiasi record Detail definito.<br> ',
'  Fare clic sull''icona di modifica (<span class="fa fa-pencil-square-o" aria-hidden="true"></span>) per modificare il record Master.',
'  Per i record Detail, fare clic sulla matita all''inizio di ogni riga per modificare il record corrispondente.</p>',
'<p>Per limitare i dati visualizzati nel selettore, immettere un termine di ricerca nell''apposita finestra di dialogo.</p>',
'',
'<p>Per aggiungere un nuovo record Master, fare clic su <strong>Crea</strong> nella parte superiore della pagina.',
unistr('  Per i record dettagliati, fare clic sull''icona con il segno pi\00F9 ( + ) nella parte superiore dell''area detail per aggiungere un record Detail.</p>'),
'',
'<p>Fare clic su <strong>Reimposta</strong> nella parte superiore della pagina per ripristinare le impostazioni predefinite della pagina, rimuovendo eventuali termini di ricerca definiti in precedenza.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279197516601868637)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>La pagina di amministrazione consente ai proprietari dell''applicazione (amministratori) di configurare l''applicazione e gestire i dati comuni usati in tutta l''applicazione.',
unistr('Se si seleziona una delle impostazioni disponibili, gli amministratori possono eventualmente modificare la modalit\00E0 di visualizzazione e/o le funzioni disponibili per gli utenti finali.</p>'),
'<p>L''accesso a questa pagina dovrebbe essere limitato solo agli amministratori.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279198769414868638)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Selezionare l''opzione appropriata per qualsiasi utente autenticato.<br>',
unistr('Se si seleziona <strong>No</strong>, si garantisce maggiore sicurezza all''applicazione poich\00E9 solo gli utenti specificati potranno accedere all''applicazione.'),
unistr('Tuttavia, se la community di utenti dell''applicazione \00E8 estesa, gestirli tutti potrebbe diventare oneroso. In questo caso, sarebbe preferibile scegliere <strong>S\00EC</strong> e immettere solo gli amministratori dell''applicazione ed eventualmente i coll')
||'aboratori.<br>',
unistr('Se si seleziona <strong>S\00EC</strong>, \00E8 necessario selezionare anche come gestire gli utenti non inclusi nell''apposita lista.</p>'),
'<p>Effettuare una selezione tra la richiesta di indirizzi di posta elettronica e qualsiasi valore numerico per Nomi utente.<br>',
unistr('In genere, \00E8 consigliabile impostare questa opzione su <strong>Indirizzo di posta elettronica</strong> se l''applicazione utilizza (o verr\00E0 configurata per usare) uno schema di autenticazione centralizzato come Oracle Access Manager o SSO.</p>'),
'<p><em><strong>Nota:</strong> questa applicazione supporta i tre livelli di accesso seguenti: Lettore, Collaboratore e Amministratore.',
'<ul>',
'  <li>I <strong>lettori</strong> hanno accesso in sola lettura a tutte le informazioni e possono visualizzare i report.</li>',
'  <li>I <strong>collaboratori</strong> possono creare, modificare ed eliminare le informazioni e visualizzare i report.</li>',
unistr('  <li>Gli <strong>amministratori</strong>, oltre alla funzionalit\00E0 previste per i collaboratori, possono eseguire anche la configurazione dell''applicazione accedendo alla sezione Amministrazione dell''applicazione.</li>'),
'</ul>',
'</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279198944619868638)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questo form per immettere gli utenti, i rispettivi indirizzi di posta elettronica e impostarne il livello di accesso.',
unistr('Le impostazioni definite in <em>Configura controllo dell''accesso</em> determineranno se il nome utente deve essere l''indirizzo di posta elettronica o pu\00F2 essere qualsiasi immissione alfanumerica.</p>'),
'<p>Questa applicazione supporta i tre livelli di accesso seguenti: Lettore, Collaboratore e Amministratore.</p>',
'<ul>',
'  <li>I <strong>lettori</strong> hanno accesso in sola lettura a tutte le informazioni e possono anche visualizzare i report.</li>',
'  <li>I <strong>collaboratori</strong> possono creare, modificare ed eliminare le informazioni e visualizzare i report.</li>',
unistr('  <li>Gli <strong>amministratori</strong>, oltre alle funzionalit\00E0 previste per i collaboratori, possono eseguire anche la configurazione dell''applicazione accedendo alla sezione Amministrazione dell''applicazione.</li>'),
'</ul>',
unistr('<p>Quando si modifica un utente esistente, \00E8 possibile bloccare il relativo account impedendone quindi l''accesso all''applicazione.</p>'),
unistr('<p><em><strong>Nota:</strong> se si utilizzano account Oracle Application Express, gli utenti immessi in questo form devono essere definiti come utenti finali anche da un amministratore dell''area di lavoro, che pu\00F2 impostarne le password.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279198898149868638)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Questa pagina mostra un report degli utenti dell''applicazione e il livello di accesso concesso.</p>',
'<p>Fare clic sulle intestazioni di colonna per ordinare e filtrare i dati oppure fare clic sul pulsante <strong>Azioni</strong> per personalizzare la visualizzazione della colonna e molte funzioni avanzate aggiuntive.<br>',
'Fare clic sul pulsante <strong>Reimposta</strong> per ripristinare le impostazioni predefinite del report interattivo.</p>',
'<p>Fare clic sull''icona di modifica (matita gialla) per modificare i dettagli e il livello di accesso dell''utente o per eliminare l''utente.</p>',
'<p>Fare clic su <strong>Aggiungi utente</strong>, nella parte superiore del report, per aggiungere un nuovo utente e il rispettivo livello di accesso.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279212328564868647)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Quando il controllo dell''accesso \00E8 abilitato, gli amministratori possono limitare l''accesso degli utenti autenticati a determinate funzioni dell''applicazione. Questa applicazione supporta i tre ruoli seguenti: Lettore, Collaboratore e Amministrato')
||'re.</p>',
'<ul>',
'  <li>I <strong>lettori</strong> hanno accesso in sola lettura a tutte le informazioni e possono anche visualizzare i report.</li>',
'  <li>I <strong>collaboratori</strong> possono creare, modificare ed eliminare le informazioni e visualizzare i report.</li>',
unistr('  <li>Gli <strong>amministratori</strong>, oltre alle funzionalit\00E0 previste per i collaboratori, possono eseguire anche la configurazione dell''applicazione.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279234350994868661)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_language=>'it'
,p_message_text=>'Immettere i nomi utente separati da virgole, punti e virgola o spazi. I nomi utente esistenti o duplicati verranno ignorati automaticamente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279197719445868637)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Le impostazioni di configurazione consentono di rendere funzionalit\00E0 specifiche disponibili (abilitate) o non disponibili (disabilitate) per gli utenti finali.</p>'),
unistr('<p>Se una funzione specifica non \00E8 pronta al 100% o deve essere temporaneamente rimossa, fare clic su <strong>Disabilitata</strong>.'),
'Una volta resa disponibile, fare semplicemente clic su <strong>Abilitata</strong>.</p>',
unistr('<p><em><strong>Nota:</strong> le modifiche apportate in questo campo non saranno evidenti ai singoli utenti che eseguono attualmente l''applicazione. Le impostazioni delle funzioni riviste verranno richiamate una volta che l''utente finale si sar\00E0 scol')
||'legato e poi ricollegato.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279197898581868637)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Selezionare la combinazione colori predefinita usata per visualizzare l''applicazione.</p>',
unistr('<p>Se l''opzione <strong>Consenti agli utenti finali di scegliere uno stile tema</strong> \00E8 selezionata, ciascun utente finale pu\00F2 selezionare uno degli stili di tema disponibili facendo clic sul collegamento <em>Personalizza</em> nell''angolo inferior')
||'e sinistro della home page.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279198446250868638)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Questa pagina fornisce un report interattivo di tutti gli errori imprevisti registrati dall''applicazione specifica.</p>',
'<p>Fare clic sulle intestazioni di colonna per ordinare e filtrare i dati oppure fare clic sul pulsante <strong>Azioni</strong> per personalizzare la visualizzazione della colonna e molte funzioni avanzate aggiuntive. Fare clic sul pulsante <strong>R'
||'eimposta</strong> per ripristinare le impostazioni predefinite del report interattivo.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279198335572868638)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Usare questo report e il grafico per visualizzare gli utenti con il maggior numero di visualizzazioni di pagina durante l''intervallo di tempo specificato.</p>',
'<p>Selezionare il periodo di tempo per la generazione del report (intervallo predefinito = 1 giorno) e scegliere tra le icone del report e del grafico nella parte superiore della pagina.</p>',
unistr('<p>Per il report interattivo, usare il campo di ricerca o selezionare l''intestazione di colonna <strong>Utente</strong> per selezionare un utente specifico. \00C8 possibile eseguire numerose funzioni facendo clic sul pulsante <strong>Azioni</strong>, ad ')
||unistr('esempio per scegliere le colonne visualizzate/nascoste, le righe per pagina, il filtro e cos\00EC via. Fare clic sul pulsante <strong>Reimposta</strong> per ripristinare le impostazioni predefinite del report interattivo.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279198510353868638)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Questa pagina fornisce un report interattivo delle prestazioni e della popolarit\00E0 della pagina. Il report viene ordinato in base alle <strong>Prestazioni ponderate</strong> che vengono calcolate moltiplicando il tempo mediano trascorso per il nume')
||'ro di visualizzazioni di pagina.</p>',
'<p>Selezionare il periodo di tempo per la generazione del report (intervallo predefinito = 1 giorno) nella parte superiore della pagina, in base alle esigenze.<br>',
'Fare clic sulle intestazioni di colonna per ordinare e filtrare i dati oppure fare clic sul pulsante <strong>Azioni</strong> per personalizzare la visualizzazione della colonna e molte funzioni avanzate aggiuntive. Fare clic sul pulsante <strong>Reim'
||'posta</strong> per ripristinare le impostazioni predefinite del report interattivo.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279198645869868638)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Questa pagina fornisce un report interattivo delle visualizzazioni di pagina pi\00F9 recenti.</p>'),
'<p>Selezionare il periodo di tempo per la generazione del report (intervallo predefinito = 1 giorno) nella parte superiore della pagina, in base alle esigenze.<br>',
'Fare clic sulle intestazioni di colonna per ordinare e filtrare i dati oppure fare clic sul pulsante <strong>Azioni</strong> per personalizzare la visualizzazione della colonna e molte funzioni avanzate aggiuntive. Fare clic sul pulsante <strong>Reim'
||'posta</strong> per ripristinare le impostazioni predefinite del report interattivo.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279197654597868637)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Le notifiche vengono visualizzate nella home page quando sono attive.</p>',
'<p>Questo report mostra le notifiche definite e il periodo di tempo in cui vengono visualizzate.</p>',
'<p>Fare clic sull''icona di modifica (matita gialla) per modificare una notifica esistente oppure fare clic su <strong>Aggiungi notifica</strong> per inserire una nuova notifica.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279197941833868637)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Immettere il nome e una descrizione breve dell''applicazione.</p>',
'<p>Il nome dell''applicazione viene visualizzato nella home page. La descrizione breve viene visualizzata sotto il nome dell''applicazione.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279198162088868637)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Gli utenti finali possono immettere un feedback da qualsiasi pagina standard all''interno dell''applicazione.</p>',
'<p>Questo report mostra il feedback immesso, qualsiasi risposta fornita dagli amministratori e lo stato del feedback.</p>',
'<p>Fare clic sull''icona di modifica (matita gialla) per immettere una risposta o aggiornare lo stato del feedback.</p>',
'<p><em><strong>Nota:</strong> se i destinatari del feedback sono stati definiti, gli invii del feedback verranno trasmessi tramite posta elettronica agli indirizzi presenti nella lista dei destinatari del feedback.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279214223605868648)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_language=>'it'
,p_message_text=>'Fornire una lista separata da virgole di indirizzi di posta elettronica.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279198284884868637)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_language=>'it'
,p_message_text=>unistr('<p><strong>Abilita allegati</strong>: se l''impostazione \00E8 S\00EC, gli utenti potranno caricare un allegato a supporto del proprio feedback.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279199240799868638)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>In questa pagina vengono elencati i modelli di posta elettronica definiti e viene indicato per quante volte \00E8 stato fatto riferimento al modello nei messaggi di posta elettronica inviati.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279199056178868638)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>In questa pagina vengono elencati i messaggi di posta elettronica inviati.</p>',
'<p>Fare clic sull''icona a forma di lente di ingrandimento per visualizzare ulteriori dettagli sui messaggi di posta elettronica inviati.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279199165995868638)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Immettere le informazioni nei campi riportati di seguito per definire un modello di posta elettronica:</p>',
'<ul>',
'  <li><strong>Nome modello</strong> (obbligatorio): immettere un nome significativo per il modello.</li>',
'  <li><strong>Modello HTML</strong> (obbligatorio): immettere il codice HTML usato per creare il messaggio di posta elettronica inviato ai destinatari che accettano la consegna di messaggi di posta elettronica in formato HTML.',
'    Di seguito sono elencati alcuni valori di sostituzione:',
'    <ul>',
unistr('        <li><strong>#APP_NAME#</strong>: verr\00E0 sostituito dal nome dell''applicazione</li>'),
unistr('        <li><strong>#BODY1#</strong>: verr\00E0 sostituito dal valore passato come p_body1_text</li> '),
unistr('        <li><strong>#TABLE#</strong>: verr\00E0 sostituito dal valore passato come p_table_content, utilizzando il codice HTML di apertura della tabella, della riga della tabella e di chiusura della tabella</li> '),
unistr('        <li><strong>#BODY2#</strong>: verr\00E0 sostituito dal valore passato come p_body2_text</li> '),
unistr('        <li><strong>#ACTION#</strong>: verr\00E0 sostituito dal valore passato come p_action_label e p_action_link, utilizzando il modello Collegamento azione</li>'),
'     </ul></li>',
'  <li><strong>Modello di testo non codificato</strong> (obbligatorio): immettere il testo non codificato usato per creare il messaggio di posta elettronica inviato ai destinatari che non accettano messaggi di posta elettronica in formato HTML. Vengon'
||'o utilizzate le stesse sostituzioni del modello HTML, ma #TABLE# e #ACTION# verranno visualizzate come testo non codificato.</li>',
'<ul>',
unistr('<p>Modelli HTML aggiuntivi consentono di definire messaggi di posta elettronica pi\00F9 avanzati. Di seguito sono riportati alcuni di questi elementi:</p>'),
'<ul>',
'  <li><strong>Prima delle righe</strong>: immettere il codice HTML per sostituire #TABLE# nel modello HTML. Utilizzato solo se p_table_content viene passato.</li>',
'  <li><strong>Modello di riga</strong>: immettere il codice HTML per il rendering di ogni riga della tabella, incluso il codice di apertura/chiusura della riga e di apertura/chiusura dei dati con le sostituzioni #LABEL# e #VALUE#. Utilizzato solo se '
||'p_table_content viene passato.</li>',
'  <li><strong>Dopo le righe</strong>: immettere il codice HTML per chiudere la tabella o div. Utilizzato solo se p_table_content viene passato.</li>',
'  <li><strong>HTML collegamento azione</strong>: immettere il codice HTML per sostituire #ACTION# nel modello HTML. Deve contenere #ACTION_LINK# e #ACTION_TEXT#. Utilizzato solo se p_action_label e p_action_link vengono passati.</li>',
'</ul>',
unistr('<p><em><strong>Nota:</strong> usare le voci all''interno del <strong>modello predefinito</strong> come esempio per sviluppare un modello personalizzato. I modelli predefiniti utilizzano tutte le variabili di sostituzione che \00E8 possibile includere nel ')
||'modello di posta elettronica personale.</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279199359432868638)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Abilitare o disabilitare l''invio di messaggi di posta elettronica selezionando una delle opzioni <strong>Spedisci messaggi di posta elettronica</strong>.</p>',
unistr('<p>Immettere i <strong>Messaggi di posta elettronica inviati da</strong> mediante l''indirizzo di posta elettronica del contatto primario per i problemi dell''applicazione. Questo valore pu\00F2 essere utilizzato o sovrascritto quando si usa la funzione di')
||' posta elettronica.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279217508562868650)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_language=>'it'
,p_message_text=>unistr('Si tratta dell''indirizzo del mittente che verr\00E0 usato per inviare i messaggi di posta elettronica. Pu\00F2 essere sovrascritto quando si utilizza la funzione di posta elettronica.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279235928908868662)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specificare le informazioni indicate di seguito e fare clic su [Invia messaggio di posta elettronica]. Tutti i messaggi di posta elettronica inviati vengono registrati nel log di posta elettronica.',
'    <ul>',
unistr('        <li><strong>Da</strong>: se in Impostazioni di posta elettronica \00E8 impostato un "Indirizzo mittente", tale indirizzo sar\00E0 considerato come un''opzione da cui effettuare l''invio. Se l''applicazione corrente utilizza gli indirizzi di posta elettr')
||unistr('onica come nome utente, \00E8 possibile scegliere di inviare i messaggi di posta elettronica dal proprio indirizzo. Infine, \00E8 sempre possibile utilizzare lo stesso indirizzo come mittente e come destinatario.</li>'),
unistr('        <li><strong>Invia a</strong>: se l''applicazione corrente utilizza gli indirizzi di posta elettronica come nome utente, \00E8 possibile scegliere di inviare i messaggi di posta elettronica a indirizzi e/o utenti.</li>'),
'        <li><strong>Indirizzi di posta elettronica</strong>: elenco separato da virgole di indirizzi di posta elettronica che riceveranno il messaggio. Gli indirizzi non validi non verranno inclusi.</li>',
'        <li><strong>Ruolo</strong>: inviare messaggi di posta elettronica a tutti gli utenti con un ruolo selezionato o a tutti gli utenti definiti. La lista di selezione include una lista di ruoli e il numero di utenti in ciascun ruolo.</li>',
'        <li><strong>Modello</strong>: selezionare il modello di posta elettronica da utilizzare per creare il corpo del messaggio di posta elettronica.</li>',
'        <li><strong>Oggetto</strong>: l''oggetto del messaggio di posta elettronica.</li>',
'        <li><strong>Corpo messaggio di posta elettronica</strong>: testo da includere come corpo del messaggio di posta elettronica.</li>',
'        <li><strong>Consenti opt-out</strong>: alcuni messaggi di posta elettronica devono essere inviati indipendentemente dal fatto che l''utente abbia eseguito l''opt-out dalla ricezione dei messaggi di posta elettronica, ad esempio messaggi di inte'
||unistr('rruzione del servizio e cos\00EC via. Questo flag identifica se \00E8 consentito l''opt-out per il messaggio di posta elettronica o se tale messaggio deve essere inviato indipendentemente dalla preferenza dell''utente.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279237648432868663)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specificare le informazioni indicate di seguito e fare clic su [Invia messaggio di posta elettronica]. Tutti i messaggi di posta elettronica inviati vengono registrati nel log di posta elettronica.',
'    <ul>',
unistr('        <li><strong>Da</strong>: se in Impostazioni di posta elettronica \00E8 impostato un "Indirizzo mittente", tale indirizzo sar\00E0 considerato come un''opzione da cui effettuare l''invio. Altrimenti, \00E8 sempre possibile utilizzare lo stesso indirizzo com')
||'e mittente e come destinatario.</li>',
'        <li><strong>Indirizzi di posta elettronica</strong>: elenco separato da virgole di indirizzi di posta elettronica che riceveranno il messaggio. Gli indirizzi non validi non verranno inclusi.</li>',
'        <li><strong>Modello</strong>: selezionare il modello di posta elettronica da utilizzare per creare il corpo del messaggio di posta elettronica.</li>',
'        <li><strong>Oggetto</strong>: l''oggetto del messaggio di posta elettronica.</li>',
'        <li><strong>Corpo messaggio di posta elettronica</strong>: testo da includere come corpo del messaggio di posta elettronica.</li>',
'        <li><strong>Consenti opt-out</strong>: alcuni messaggi di posta elettronica devono essere inviati indipendentemente dal fatto che l''utente abbia eseguito l''opt-out dalla ricezione dei messaggi di posta elettronica, ad esempio messaggi di inte'
||unistr('rruzione del servizio e cos\00EC via. Questo flag identifica se \00E8 consentito l''opt-out per il messaggio di posta elettronica o se tale messaggio deve essere inviato indipendentemente dalla preferenza dell''utente.</li>'),
'</ul>',
'</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279198016490868637)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Selezionare il fuso orario predefinito per tutti gli utenti di questa applicazione.</p>',
'<p>I singoli utenti possono sostituire questa impostazione facendo clic sul proprio nome utente (in alto a destra) e selezionando <strong>Preferenze</strong>. In alternativa, possono fare clic sul collegamento del fuso orario visualizzato nella parte'
||' inferiore della home page.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279213936906868648)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'it'
,p_message_text=>unistr('A questa pagina non \00E8 possibile accedere direttamente tramite l''interfaccia utente. Viene utilizzata per agevolare il download della foto del profilo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279213636220868647)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_language=>'it'
,p_message_text=>unistr('Nella pagina Profilo utente \00E8 possibile visualizzare informazioni pertinenti su un utente in un''unica schermata facile da usare.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279213312659868647)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_language=>'it'
,p_message_text=>'Caricare una foto con una simmetria quadrata, altrimenti potrebbe apparire distorta. Le dimensioni immagine preferenziali sono 250x250 pixel.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279199478331868638)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Questo form consente di aggiornare i dettagli personali e caricare una foto o un avatar.</p>',
'<p>Per caricare un''immagine, fare clic su <strong>Sfoglia</strong> oppure trascinare la selezione dell''immagine sul pulsante.<br>',
'Caricare una foto con una simmetria quadrata, altrimenti potrebbe apparire distorta. Le dimensioni immagine preferenziali sono 250x250 pixel.</p>',
'<p>Fare clic su <strong>Elimina foto</strong> per rimuovere l''immagine.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279219526885868651)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_language=>'it'
,p_message_text=>unistr('In questa pagina \00E8 possibile accedere a tutto il testo della Guida sull''applicazione. I collegamenti presenti nell''area "Documentazione" offrono una spiegazione pi\00F9 approfondita delle caratteristiche e delle funzionalit\00E0 dell''applicazione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279200552583868639)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_language=>'it'
,p_message_text=>unistr('In questa pagina, \00E8 possibile impostare le preferenze dell''applicazione per il proprio account che possono avere effetto su diversi aspetti dell''applicazione come il fuso orario. Fare clic sulle icone della Guida a livello di elemento per scoprire qu')
||'ali azioni vengono eseguite da ciascuna preferenza.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278192647983867999)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_language=>'it'
,p_message_text=>unistr('<p>Questo report mostra tutti i messaggi di posta elettronica in attesa di invio nella coda e quelli gi\00E0 inviati.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278324560253868083)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_language=>'it'
,p_message_text=>unistr('<p>Questo report include tutti i job selezionati per essere monitorati da questa applicazione. Facendo clic sul nome del job \00E8 possibile visualizzare ulteriori dettagli su un job.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278331115477868087)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_language=>'it'
,p_message_text=>'<p>Questo report include i dettagli di esecuzione relativi ai job selezionati per il monitoraggio da parte di questa applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279184881159868629)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_language=>'it'
,p_message_text=>'Aggiunge una pagina di informazioni su questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279201232787868639)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_language=>'it'
,p_message_text=>'Impostare questa opzione su No se non si desidera ricevere messaggi di posta elettronica da questa applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279235452249868661)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Immettere un termine di ricerca nell''apposita finestra di dialogo e fare clic su <strong>Cerca</strong>.<br>',
'Fare clic su una delle intestazioni dei risultati per passare al record specifico corrispondente.</p>',
unistr('<p>Per limitare la ricerca, deselezionare una o pi\00F9 origini. Il report corrispondente verr\00E0 eliminato dai risultati della ricerca.</p>'),
'<p>Fare clic su <strong>Reimposta</strong> per rimuovere il termine di ricerca corrente e selezionare tutte le origini.</p> '))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279201068753868639)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_language=>'it'
,p_message_text=>'Impostare il fuso orario preferito da usare in tutta l''applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278113132035867949)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_language=>'it'
,p_message_text=>'Elementi nascosti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279221177147868652)
,p_name=>'CA.HOME'
,p_message_language=>'it'
,p_message_text=>'Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279227237473868656)
,p_name=>'CA.HOME.PAGE'
,p_message_language=>'it'
,p_message_text=>'Home page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279243650038868667)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_language=>'it'
,p_message_text=>'Eventi pagina orari'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278191760326867999)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_language=>'it'
,p_message_text=>'Dimensione corpo HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279217904271868650)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279214608601868648)
,p_name=>'CA.IN.PROGRESS'
,p_message_language=>'it'
,p_message_text=>'In corso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279239852903868664)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_language=>'it'
,p_message_text=>'Includi in form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279239733668868664)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_language=>'it'
,p_message_text=>'Includi in report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279223305921868654)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_language=>'it'
,p_message_text=>'Installazione script oggetti di supporto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278325214392868083)
,p_name=>'CA.INSTANCE.ID'
,p_message_language=>'it'
,p_message_text=>'ID istanza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278326459023868084)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_language=>'it'
,p_message_text=>'Persistenza istanza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279197014982868637)
,p_name=>'CA.INTRO.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Benvenuti in questa anteprima esclusiva per l''ambiente cloud che riguarda un modo innovativo e migliorato di creare un''applicazione ancora pi\00F9 completa di funzionalit\00E0. La Creazione guidata dell''applicazione standard consente solo di selezionare l')
||'e pagine da generare, mentre questa procedura guida consente anche di precaricare rapidamente una serie di funzioni aggiuntive nell''applicazione.</p>',
'<p>Le applicazioni generate usando questa procedura guidata verranno completamente supportate e potrebbero anche includere oggetti di supporto per determinate funzioni quali Controllo dell''accesso, Framework posta elettronica, Feedback e molte altre '
||'ancora.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279197238185868637)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Iniziare immettendo un nome per l''applicazione. Successivamente, aggiungere una o pi\00F9 pagine all''applicazione. Selezionare le funzioni da includere. Scegliere le opzioni relative all''aspetto dell''applicazione, quindi immettere le impostazioni.<br>'),
unistr('A questo punto, fare clic su <strong>Crea applicazione</strong> e la procedura \00E8 terminata.</p>'),
'<p>Fare clic su <strong>Visualizza progetto</strong> per riutilizzare il modello di un''applicazione generata in precedenza o per replicare rapidamente le pagine.</p>',
'<p><em><strong>Nota:</strong> ciascuna sezione e ogni ''Aggiungi pagina'' include una Guida dettagliata che fornisce ulteriore assistenza.</em></p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279197171865868637)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_language=>'it'
,p_message_text=>'Come utilizzare questa procedura guidata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279231801385868659)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Di seguito sono elencati i principali problemi riscontrati al momento della release:',
'<ol>',
unistr('  <li>La procedura guidata Create Application from Blueprint Wizard non \00E8 tradotta.</li>'),
'  <li>Le applicazioni tradotte generate con questa procedura guidata sono tradotte solo in parte.</li>',
'  <li>Il drill-down del report supporta una sola colonna di drill-down.</li>',
unistr('  <li>Non \00E8 possibile generare le pagine del report dei filtri.</li>'),
'  <li>La funzione di posta elettronica include l''API di livello inferiore, ma non include ancora le funzioni di posta elettronica di livello superiore.</li>',
unistr('  <li>La generazione di un''applicazione da un progetto che fa riferimento a tabelle mancanti determiner\00E0 un errore imprevisto.</li>'),
'  <li>Impostazioni avanzate: i formati delle date non vengono applicati all''applicazione generata.</li>',
'</ol>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279231763063868659)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_language=>'it'
,p_message_text=>'Problemi noti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279197473537868637)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Rilasciata: %0.</p>',
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279197364678868637)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_language=>'it'
,p_message_text=>'Dettagli release'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279196917108868637)
,p_name=>'CA.INTRO.TITLE'
,p_message_language=>'it'
,p_message_text=>'Creazione guidata applicazione da un progetto {anteprima solo per il cloud}'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279208514374868644)
,p_name=>'CA.IP.ADDRESS'
,p_message_language=>'it'
,p_message_text=>'Indirizzo IP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279206732444868643)
,p_name=>'CA.IR.SEARCH'
,p_message_language=>'it'
,p_message_text=>'Ricerca IR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279209721284868645)
,p_name=>'CA.IR.SEARCHES'
,p_message_language=>'it'
,p_message_text=>'Ricerche di report interattivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279238248350868663)
,p_name=>'CA.ITEMNAME'
,p_message_language=>'it'
,p_message_text=>'Nome elemento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278329251302868086)
,p_name=>'CA.JOB.ACTION'
,p_message_language=>'it'
,p_message_text=>'Azione job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278330782513868087)
,p_name=>'CA.JOB.CLASS'
,p_message_language=>'it'
,p_message_text=>'Classe job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278329821852868086)
,p_name=>'CA.JOB.CREATOR'
,p_message_language=>'it'
,p_message_text=>'Creatore job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278330902127868087)
,p_name=>'CA.JOB.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278327477755868085)
,p_name=>'CA.JOB.PRIORITY'
,p_message_language=>'it'
,p_message_text=>unistr('Priorit\00E0 job')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278324443212868083)
,p_name=>'CA.JOB.REPORTING'
,p_message_language=>'it'
,p_message_text=>'Generazione report su job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278367062573868110)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_language=>'it'
,p_message_text=>'Visualizza i dettagli di stato e di esecuzione dei job che supportano questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278331092261868087)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_language=>'it'
,p_message_text=>'Dettagli esecuzione job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278329972522868086)
,p_name=>'CA.JOB.STYLE'
,p_message_language=>'it'
,p_message_text=>'Stile job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278330018818868086)
,p_name=>'CA.JOB.SUBNAME'
,p_message_language=>'it'
,p_message_text=>'Nome secondario job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278329303493868086)
,p_name=>'CA.JOB.TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278326056266868084)
,p_name=>'CA.JOB.WEIGHT'
,p_message_language=>'it'
,p_message_text=>'Carico del job'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279238794036868664)
,p_name=>'CA.KEYCOLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna chiave'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279240508967868665)
,p_name=>'CA.LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279239079532868664)
,p_name=>'CA.LABELCOLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna etichetta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279240767066868665)
,p_name=>'CA.LABELPLURAL'
,p_message_language=>'it'
,p_message_text=>'Etichetta plurale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279240483873868665)
,p_name=>'CA.LABELSINGULAR'
,p_message_language=>'it'
,p_message_text=>'Etichetta singolare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279196169785868636)
,p_name=>'CA.LANGUAGE'
,p_message_language=>'it'
,p_message_text=>'Lingua'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279196224744868636)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_language=>'it'
,p_message_text=>'Selezionare la lingua primaria per questa applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279231249352868659)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('<p>La lingua primaria determina la lingua utilizzata per visualizzare le pagine e i componenti generati in App Builder. Se si selezionano pi\00F9 traduzioni, saranno disponibili pi\00F9 opzioni per gli utenti finali relativamente alla lingua utilizzata per i')
||'l rendering dell''applicazione di runtime.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278475659017868178)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_language=>'it'
,p_message_text=>'Selettore lingue'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279213167681868647)
,p_name=>'CA.LAST.NAME'
,p_message_language=>'it'
,p_message_text=>'Cognome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278330168991868086)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_language=>'it'
,p_message_text=>'Durata ultima esecuzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278330259574868086)
,p_name=>'CA.LAST.START.DATE'
,p_message_language=>'it'
,p_message_text=>'Ultima data di inizio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279244056386868667)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_language=>'it'
,p_message_text=>unistr('Attivit\00E0 pi\00F9 recente')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279239914207868664)
,p_name=>'CA.LISTOFVALUES'
,p_message_language=>'it'
,p_message_text=>'Lista di valori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279235325850868661)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_language=>'it'
,p_message_text=>'Carica progetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278332583301868088)
,p_name=>'CA.LOG.DATE'
,p_message_language=>'it'
,p_message_text=>'Data log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278332727356868088)
,p_name=>'CA.LOG.ID'
,p_message_language=>'it'
,p_message_text=>'ID log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278326786030868084)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_language=>'it'
,p_message_text=>'Livello di log'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278113969053867950)
,p_name=>'CA.LOOKUP.COLUMNS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
' <li><strong>Colonne di ricerca</strong>: espandere per visualizzare gli attributi per la definizione di una ricerca in un''altra tabella. Utilizzare le colonne di ricerca per sostituire gli identificativi con una colonna di visualizzazione, ad esempi'
||unistr('o per mostrare il nome anzich\00E9 il numero del reparto.<br>'),
unistr('<em><strong>Nota:</strong> Colonne di ricerca sar\00E0 visibile solo se la pagina corrente si basa su una tabella o una vista e dispone di vincoli FOREIGN KEY su un''altra tabella.'),
'  <ul>',
unistr('    <li><strong>Chiave di ricerca</strong>: selezionare la colonna che verr\00E0 modificata per restituire la colonna di visualizzazione.</li>'),
'    <li><strong>Colonna di visualizzazione</strong>: selezionare la colonna da visualizzare dalla tabella di ricerca.</li>',
'    &nbsp;<br>',
'    <em><strong>Nota:</strong> selezionare solo le colonne che contengono un riferimento a un''altra colonna (mediante una chiave esterna).</em></li>',
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279217140444868650)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_language=>'it'
,p_message_text=>'Gestisci modelli di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279215113737868648)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_language=>'it'
,p_message_text=>'Gestisci feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279211258379868646)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_language=>'it'
,p_message_text=>'Gestisci accesso utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279244657652868667)
,p_name=>'CA.MASTER'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina Master-Detail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279244785697868667)
,p_name=>'CA.MASTER.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di creare una pagina che visualizza una pagina Master-Detail per permettere agli utenti finali di visualizzare e gestire i dati.<br>',
'&nbsp;</p>',
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome pagina</strong> (obbligatorio): immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
'  <li><strong>Tipo pagina</strong>: selezionare il tipo di pagina [Affiancate, In pila].<br>',
'    <strong>Affiancate</strong>: <br>',
'<em>Master-Detail a pagina singola che utilizza aree di layout e report affiancate con finestre di modifica modali.</em>',
'    <ul>',
'      <li><strong>Tabella</strong> (obbligatorio): selezionare la tabella master per la pagina.</li>',
'      <li><strong>Colonna di visualizzazione primaria</strong> (obbligatorio): selezionare la colonna da visualizzare nella lista dei record master.</li>',
'      <li><strong>Colonna di visualizzazione secondaria</strong> (obbligatorio): selezionare la colonna descrittiva da visualizzare nella lista dei record master sotto la colonna di visualizzazione primaria.</li>',
'      <li><strong>Tabella detail 1</strong> (obbligatorio): selezionare la prima tabella detail per la pagina.</li>',
'      <li><strong>Tabella detail 2</strong>: selezionare la seconda tabella detail per la pagina.</li>',
'      <li><strong>Tabella detail 3</strong>: selezionare la terza tabella detail per la pagina.</li>',
'      <li><strong>Tabella detail 4</strong>: selezionare la quarta tabella detail per la pagina.</li>',
'    </ul>',
'   <strong>In pila</strong>: <br>',
'<em>Master-Detail a pagina singola che utilizza griglie interattive modificabili.</em>',
'    <ul>',
'      <li><strong>Tabella</strong> (obbligatorio): selezionare la tabella master per la griglia interattiva modificabile.</li>',
'      <li><strong>Tabella detail</strong> (obbligatorio): selezionare la tabella detail per la pagina.</li>',
unistr('      <em><strong>Nota:</strong> quando si utilizza questa procedura guidata \00E8 possibile aggiungere una sola tabella detail (griglia interattiva modificabile). Ulteriori tabelle detail possono essere aggiunte con facilit\00E0 dopo la generazione della pa')
||'gina.</em>',
'    </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278475563794868178)
,p_name=>'CA.MASTER_RECORDS'
,p_message_language=>'it'
,p_message_text=>'Record principali'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279207405034868643)
,p_name=>'CA.MAX.ELAPSED'
,p_message_language=>'it'
,p_message_text=>'Tempo massimo trascorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278327255869868084)
,p_name=>'CA.MAX.FAILURES'
,p_message_language=>'it'
,p_message_text=>'Numero massimo di errori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278326866940868084)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_language=>'it'
,p_message_text=>'Durata massima esecuzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278327319351868084)
,p_name=>'CA.MAX.RUNS'
,p_message_language=>'it'
,p_message_text=>'Numero massimo di esecuzioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279238982908868664)
,p_name=>'CA.MAXIMUMROWS'
,p_message_language=>'it'
,p_message_text=>'Numero massimo di righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279241978501868666)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_language=>'it'
,p_message_text=>'Larghezza massima'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279232595494868660)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_language=>'it'
,p_message_text=>'Aggiungi filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279232988174868660)
,p_name=>'CA.MD.ADD.ROW'
,p_message_language=>'it'
,p_message_text=>'Aggiungi %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279232467126868660)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_language=>'it'
,p_message_text=>'Applica filtri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279233338372868660)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279233451447868660)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_language=>'it'
,p_message_text=>'Valore data 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279232602791868660)
,p_name=>'CA.MD.EDIT'
,p_message_language=>'it'
,p_message_text=>'Modifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279232060341868659)
,p_name=>'CA.MD.FILTER'
,p_message_language=>'it'
,p_message_text=>'Filtra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279231987674868659)
,p_name=>'CA.MD.FILTERS'
,p_message_language=>'it'
,p_message_text=>'Filtri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279233064022868660)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_language=>'it'
,p_message_text=>'Nessun filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279232354183868659)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_language=>'it'
,p_message_text=>'Nessun record selezionato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279232258771868659)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_language=>'it'
,p_message_text=>'Nessun record trovato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279232872859868660)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_language=>'it'
,p_message_text=>'Eliminazione di %0 completata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279232768565868660)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_language=>'it'
,p_message_text=>'Aggiornamento di %0 completato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279232166049868659)
,p_name=>'CA.MD.SEARCH'
,p_message_language=>'it'
,p_message_text=>'Cerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279233182139868660)
,p_name=>'CA.MD.VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279233275375868660)
,p_name=>'CA.MD.VALUE.2'
,p_message_language=>'it'
,p_message_text=>'Valore 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279206970116868643)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_language=>'it'
,p_message_text=>'Tempo mediano trascorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279216057914868649)
,p_name=>'CA.MESSAGE'
,p_message_language=>'it'
,p_message_text=>'Messaggio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279241483489868665)
,p_name=>'CA.METRIC'
,p_message_language=>'it'
,p_message_text=>'Metrica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279207887784868644)
,p_name=>'CA.MIN.ELAPSED'
,p_message_language=>'it'
,p_message_text=>'Tempo minimo trascorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279210672768868645)
,p_name=>'CA.MOBILE.PHONE'
,p_message_language=>'it'
,p_message_text=>'Telefono cellulare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279206492706868643)
,p_name=>'CA.MODE'
,p_message_language=>'it'
,p_message_text=>unistr('Modalit\00E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279220281227868652)
,p_name=>'CA.MORE'
,p_message_language=>'it'
,p_message_text=>'Altro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279209815822868645)
,p_name=>'CA.MOST RECENT'
,p_message_language=>'it'
,p_message_text=>'Most_Recent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279243852972868667)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_language=>'it'
,p_message_text=>unistr('Pagine pi\00F9 attive')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278114057243867950)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_language=>'it'
,p_message_text=>unistr('Pi\00F9 report')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278114169389867950)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Selezionare uno o pi\00F9 nomi di tabella o di vista. In alternativa, fare clic sulla casella di controllo nell''intestazione per selezionare o deselezionare tutti gli oggetti di database elencati.</p>'),
unistr('<p>Verr\00E0 aggiunta una pagina con un report interattivo per ogni oggetto di database selezionato.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279203878684868641)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_language=>'it'
,p_message_text=>'Il valore di #LABEL# deve essere un indicatore orario valido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279241283795868665)
,p_name=>'CA.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279195359442868636)
,p_name=>'CA.NAVIGATION'
,p_message_language=>'it'
,p_message_text=>'Navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279195476502868636)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_language=>'it'
,p_message_text=>'<p>Scegliere se il menu deve essere visualizzato sul lato o nella parte superiore dell''applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279247928313868669)
,p_name=>'CA.NEGATIVE'
,p_message_language=>'it'
,p_message_text=>'Negativa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279247883610868669)
,p_name=>'CA.NEUTRAL'
,p_message_language=>'it'
,p_message_text=>'Neutra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279233919992868660)
,p_name=>'CA.NEXT'
,p_message_language=>'it'
,p_message_text=>'Successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278327075745868084)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_language=>'it'
,p_message_text=>'Data esecuzione successiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278325964231868084)
,p_name=>'CA.NLS.ENV'
,p_message_language=>'it'
,p_message_text=>'Ambiente NLS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278423771024868146)
,p_name=>'CA.NO'
,p_message_language=>'it'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279214785247868648)
,p_name=>'CA.NO.ACTION'
,p_message_language=>'it'
,p_message_text=>'Nessuna azione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279226374540868656)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_language=>'it'
,p_message_text=>'Guida non disponibile per questa pagina.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278113287204867949)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'it'
,p_message_text=>'Non esistono utenti validi - Informazioni pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279234972842868661)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_language=>'it'
,p_message_text=>'Nessun nuovo utente valido trovato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279231020576868659)
,p_name=>'CA.NONE'
,p_message_language=>'it'
,p_message_text=>'Nessuno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279210910371868646)
,p_name=>'CA.NOTE'
,p_message_language=>'it'
,p_message_text=>'Nota'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279186437265868630)
,p_name=>'CA.NOTIFICATION'
,p_message_language=>'it'
,p_message_text=>'Notifiche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279185290935868629)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_language=>'it'
,p_message_text=>'Visualizza le notifiche nella home page'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279186589431868630)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Consente agli amministratori dell''applicazione di specificare gli avvisi (in giallo) o gli errori (in rosso) visualizzati a tutti gli utenti finali nella home page dell''applicazione. Questa funzione \00E8 utile per trasmettere informazioni importanti ')
||'alla community di utenti finali.</p>',
'<p>Include i seguenti componenti:<ul>',
unistr('<li>Possibilit\00E0 di definire le notifiche</li>'),
'<li>Visualizzazione della notifica nella home page dell''applicazione</li>',
unistr('<li>Possibilit\00E0 di controllare l''intervallo di tempo di visualizzazione della notifica</li>'),
'<li>Supporto della codifica colore delle notifiche in base al tipo</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279203155116868641)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279206640533868643)
,p_name=>'CA.NUM.ROWS'
,p_message_language=>'it'
,p_message_text=>'Numero di righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278329138089868086)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_language=>'it'
,p_message_text=>'Numero di argomenti'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278325723972868083)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_language=>'it'
,p_message_text=>'Numero di destinazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279239457461868664)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_language=>'it'
,p_message_text=>'Formato di visualizzazione numero'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279208127536868644)
,p_name=>'CA.OCCURRENCE'
,p_message_language=>'it'
,p_message_text=>'Ricorrenza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279248171576868670)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Impossibile eseguire questa azione a meno che non vi sia un altro amministratore.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279214950613868648)
,p_name=>'CA.OPEN'
,p_message_language=>'it'
,p_message_text=>'Aperto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279187971914868631)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_language=>'it'
,p_message_text=>'Organizzazione delle pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279188249304868631)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Disporre le pagine nell''ordine con cui si desidera vengano visualizzate nell''applicazione. <br>',
'Per riordinare le pagine nella lista, fare clic e tenere premuta l''icona <em>Menu</em> ( <span class="fa fa-bars" aria-hidden="true"></span> ) alla fine di ogni lista di pagine, quindi trascinare la pagina verso l''alto o verso il basso.</p>',
unistr('<p>La home page viene sempre visualizzata per prima e non pu\00F2 essere riordinata.<br>'),
unistr('Le pagine di amministrazione vengono sempre visualizzate alla fine della lista e l''ordine in cui sono visualizzate determiner\00E0 quello in cui appariranno nella lista Amministrazione applicazione della pagina Amministrazione.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278331203051868087)
,p_name=>'CA.OUTPUT'
,p_message_language=>'it'
,p_message_text=>'Output'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278332428254868088)
,p_name=>'CA.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279206320701868643)
,p_name=>'CA.PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279209510134868645)
,p_name=>'CA.PAGE.EVENTS'
,p_message_language=>'it'
,p_message_text=>'Eventi di pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279222090896868653)
,p_name=>'CA.PAGE.HELP'
,p_message_language=>'it'
,p_message_text=>'Guida sulla pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279208692553868644)
,p_name=>'CA.PAGE.ITEM'
,p_message_language=>'it'
,p_message_text=>'Elemento pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278477574792868179)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_language=>'it'
,p_message_text=>'Modifica record principale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278477749558868180)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_language=>'it'
,p_message_text=>'Esegue la ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279205922164868642)
,p_name=>'CA.PAGE.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279221378395868652)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_language=>'it'
,p_message_text=>'Navigazione delle pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279208016351868644)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_language=>'it'
,p_message_text=>'Prestazioni della pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279234012307868661)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_language=>'it'
,p_message_text=>unistr('Il tipo di pagina "%0" non \00E8 valido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279207386292868643)
,p_name=>'CA.PAGE.VIEWS'
,p_message_language=>'it'
,p_message_text=>'Visualizzazioni di pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279188480940868631)
,p_name=>'CA.PAGES'
,p_message_language=>'it'
,p_message_text=>'Pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279188580917868631)
,p_name=>'CA.PAGES.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Consente di definire la pagina o le pagine da includere nell''applicazione iniziale. \00C8 necessario definire almeno una pagina prima di poter creare l''applicazione.</p>'),
unistr('<p>\00C8 possibile eseguire lo stub dell''applicazione creando qualsiasi numero di pagine utilizzando questa procedura guidata. Dopo aver creato l''applicazione, usare la Creazione guidata della pagina per aggiungere altre pagine.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279239394930868664)
,p_name=>'CA.PAGINATIONMETHOD'
,p_message_language=>'it'
,p_message_text=>'Metodo di impaginazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279207624921868644)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_language=>'it'
,p_message_text=>'Visualizzazioni di pagina parziale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279213446476868647)
,p_name=>'CA.PHOTO'
,p_message_language=>'it'
,p_message_text=>'Foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279214096854868648)
,p_name=>'CA.PHOTO.DELETED'
,p_message_language=>'it'
,p_message_text=>'Foto eliminata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279213575589868647)
,p_name=>'CA.PHOTO.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279213241169868647)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_language=>'it'
,p_message_text=>'Caricamento foto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279218035063868650)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di testo non codificato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279247720101868669)
,p_name=>'CA.POSITIVE'
,p_message_language=>'it'
,p_message_text=>'Positiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279200810069868639)
,p_name=>'CA.PREFERENCES'
,p_message_language=>'it'
,p_message_text=>'Preferenze'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279245370169868668)
,p_name=>'CA.PREVIOUS'
,p_message_language=>'it'
,p_message_text=>'Precedente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279240044941868664)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna di visualizzazione primaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279240908471868665)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna chiave primaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279241012454868665)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_language=>'it'
,p_message_text=>'Tabella padre primaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279208288813868644)
,p_name=>'CA.PROCEDURE'
,p_message_language=>'it'
,p_message_text=>'Procedura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279201447470868640)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Preferenza di posta elettronica aggiornata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278477139166868179)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_language=>'it'
,p_message_text=>'Recupera riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279202654280868640)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni aspetto dell''applicazione salvate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279201321860868640)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Preferenza fuso orario aggiornata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279213808421868648)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'it'
,p_message_text=>'Download della foto del profilo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278329421745868086)
,p_name=>'CA.PROGRAM.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome programma'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278329543359868086)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario programma'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279240357385868665)
,p_name=>'CA.QUERY'
,p_message_language=>'it'
,p_message_text=>'Query'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278326262916868084)
,p_name=>'CA.RAISE.EVENTS'
,p_message_language=>'it'
,p_message_text=>'Richiama eventi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277958026783867851)
,p_name=>'CA.RATING'
,p_message_language=>'it'
,p_message_text=>'Valutazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279211782901868646)
,p_name=>'CA.READERS'
,p_message_language=>'it'
,p_message_text=>'Lettori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279201143850868639)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_language=>'it'
,p_message_text=>'Ricevi messaggi di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279243980484868667)
,p_name=>'CA.RECENT.ERRORS'
,p_message_language=>'it'
,p_message_text=>'Errori recenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278984392968868501)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278984458862868501)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279203392692868641)
,p_name=>'CA.RED'
,p_message_language=>'it'
,p_message_text=>'Rosso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279216921961868650)
,p_name=>'CA.REFERENCED'
,p_message_language=>'it'
,p_message_text=>'Di riferimento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278476261747868179)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_language=>'it'
,p_message_text=>'Aggiorna pagina di amministrazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278093673320867937)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_language=>'it'
,p_message_text=>'Aggiorna alla chiusura della finestra di dialogo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278477614605868180)
,p_name=>'CA.REFRESH_REPORT'
,p_message_language=>'it'
,p_message_text=>'Aggiorna report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279202886175868641)
,p_name=>'CA.REGION.BUTTONS'
,p_message_language=>'it'
,p_message_text=>'Area pulsanti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279202765827868640)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_language=>'it'
,p_message_text=>'Area elementi form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279208736187868644)
,p_name=>'CA.REGION.ID'
,p_message_language=>'it'
,p_message_text=>'ID area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279220749102868652)
,p_name=>'CA.RELEASE'
,p_message_language=>'it'
,p_message_text=>'Release %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279188099911868631)
,p_name=>'CA.REMOVING.PAGES'
,p_message_language=>'it'
,p_message_text=>'Rimozione delle pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279188132664868631)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_language=>'it'
,p_message_text=>'<p>Fare clic su <strong>Modifica</strong> per selezionare la pagina, quindi fare clic su <strong>Elimina pagina</strong> per rimuovere una pagina dall''applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278330886936868087)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_language=>'it'
,p_message_text=>'Intervallo ripetizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278192375365867999)
,p_name=>'CA.REPLY.TO'
,p_message_language=>'it'
,p_message_text=>'Rispondi a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279193821195868635)
,p_name=>'CA.REPORT'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279193799266868635)
,p_name=>'CA.REPORT.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di creare una pagina che visualizza un report interattivo o un report classico.</p>',
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome pagina</strong>: immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
'  <li><strong>Tipo di query</strong>: selezionare l''origine per il report [<strong>Tabella o vista</strong> o <strong>Query SQL</strong>]:<br>',
'    <strong>Tabella o vista</strong>:',
'    <ul>',
'      <li>Tabella o vista (obbligatorio): selezionare l''oggetto di database per il report.</li>',
'      <li>Includi form: selezionare per includere una pagina di form collegata per consentire agli utenti di gestire i valori delle tabelle.</li>',
'    </ul>',
'    <strong>Query SQL</strong>:',
'    <ul>',
'      <li>Query SQL (obbligatorio): immettere un''istruzione SQL valida che restituisca colonne distinte.</li>',
'    </ul>',
'  </li>',
'  <li><strong>Tipo di report</strong>: selezionare il tipo di report (<strong>Report interattivo</strong> o <strong>Report classico</strong>).</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279185549760868629)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_language=>'it'
,p_message_text=>'%0 con form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279030325898868530)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_language=>'it'
,p_message_text=>'Report %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279243037849868666)
,p_name=>'CA.REPORT.VIEW'
,p_message_language=>'it'
,p_message_text=>'Vista report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279241604751868665)
,p_name=>'CA.REPORTS'
,p_message_language=>'it'
,p_message_text=>'Report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278332239212868088)
,p_name=>'CA.REQ.START.DATE'
,p_message_language=>'it'
,p_message_text=>'Data di inizio richiesta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279241833785868666)
,p_name=>'CA.REQUIRED'
,p_message_language=>'it'
,p_message_text=>'Richiesto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279218897074868651)
,p_name=>'CA.RESET'
,p_message_language=>'it'
,p_message_text=>'Reimposta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279214840539868648)
,p_name=>'CA.RESOLVED'
,p_message_language=>'it'
,p_message_text=>'Risolto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279214569746868648)
,p_name=>'CA.RESPONSE'
,p_message_language=>'it'
,p_message_text=>'Risposta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278327587448868085)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_language=>'it'
,p_message_text=>'Riavvia in caso di errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278327621766868085)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_language=>'it'
,p_message_text=>'Riavvia in caso di recupero'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278324835080868083)
,p_name=>'CA.RESTARTABLE'
,p_message_language=>'it'
,p_message_text=>'Riavviabile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278327133947868084)
,p_name=>'CA.RETRY.COUNT'
,p_message_language=>'it'
,p_message_text=>'Conteggio nuovi tentativi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279236872214868662)
,p_name=>'CA.ROLE'
,p_message_language=>'it'
,p_message_text=>'Ruolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279208999615868644)
,p_name=>'CA.ROW.NUMBER'
,p_message_language=>'it'
,p_message_text=>'Numero riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279218212991868650)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279236204201868662)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_language=>'it'
,p_message_text=>'HTML modello riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279237507768868663)
,p_name=>'CA.ROWS.CONTENT'
,p_message_language=>'it'
,p_message_text=>'Contenuto righe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279209636680868645)
,p_name=>'CA.ROWS.FETCHED'
,p_message_language=>'it'
,p_message_text=>'Righe recuperate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279239204392868664)
,p_name=>'CA.ROWSPERPAGE'
,p_message_language=>'it'
,p_message_text=>'Righe per pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278330484334868086)
,p_name=>'CA.RUN.COUNT'
,p_message_language=>'it'
,p_message_text=>'Conteggio esecuzioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278332091444868087)
,p_name=>'CA.RUN.DURATION'
,p_message_language=>'it'
,p_message_text=>'Durata esecuzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278326930016868084)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_language=>'it'
,p_message_text=>'Limite pianificazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278328990483868085)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome pianificazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278329018414868086)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario pianificazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278328815279868085)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di pianificazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279196302107868636)
,p_name=>'CA.SCHEMA'
,p_message_language=>'it'
,p_message_text=>'Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279196453201868636)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_language=>'it'
,p_message_text=>'<p>Selezionare lo schema di database che memorizza gli oggetti di database da usare in questa applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279238391764868663)
,p_name=>'CA.SCOPE'
,p_message_language=>'it'
,p_message_text=>'Ambito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279218975154868651)
,p_name=>'CA.SEARCH'
,p_message_language=>'it'
,p_message_text=>'Cerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279219053302868651)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Applicazione di ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279219154244868651)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_language=>'it'
,p_message_text=>'Finestra di dialogo di ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279243244458868666)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_language=>'it'
,p_message_text=>'Filtri di ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279225850615868655)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Questa pagina si basa sulla lista di componenti condivisi denominata Tabelle in cui eseguire le ricerche.',
'',
'Eventuali pagine del report interattivo generate inizialmente dalla creazione guidata dell''applicazione verranno aggiunte automaticamente alla lista. ',
'Per aggiungere tabelle personali alla lista, passare a Componenti condivisi, selezionare Liste, quindi fare clic su Tabelle in cui eseguire le ricerche.',
'  Immettere i seguenti attributi:',
'    Voce: Etichetta voce di lista: immettere il nome visualizzato della tabella.',
'    Destinazione: Pagina: selezionare la pagina appropriata in cui spostarsi (preferibilmente un report interattivo)',
'    Destinazione: Svuota cache: immettere le eventuali pagine da cancellare (in genere lo stesso numero di pagine immesse in Pagina).',
unistr('       Se ci si sposta in una pagina di report interattivo, aggiungere CIR,RIR per cancellare eventuali filtri esistenti e cos\00EC via.'),
'    Destinazione: Imposta questi elementi: selezionare (o immettere) la pagina appropriata in cui inserire i dati.',
'       Se ci si sposta in una pagina di report interattivo, immettere IR_[COLUMN_NAME].',
'    Destinazione: Con questi valori: immettere =PK=',
'    Attributi definiti dall''utente: 1: immettere il nome della tabella in cui effettuare la ricerca in lettere maiuscole.',
'    Attributi definiti dall''utente: 2: immettere il nome della colonna primaria in lettere maiuscole.',
'    Attributi definiti dall''utente: 3 (facoltativo): lista separata da virgole di colonne in cui effettuare la ricerca.',
unistr('       Se non \00E8 specificata alcuna colonna, la ricerca viene effettuata in tutte le colonne di testo (varchar2) e clob (character large object).'),
'',
unistr('Nota: viene visualizzata una lista di tabelle disponibili in cui effettuare la ricerca solo se sono elencate pi\00F9 tabelle.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279218607134868651)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_language=>'it'
,p_message_text=>'Risultati ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279240861980868665)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna di visualizzazione secondaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279215223810868648)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello selezionato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278191638554867999)
,p_name=>'CA.SEND.BEGIN'
,p_message_language=>'it'
,p_message_text=>'Inizio invio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278192083283867999)
,p_name=>'CA.SEND.COUNT'
,p_message_language=>'it'
,p_message_text=>'Conteggio invii'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278191576754867999)
,p_name=>'CA.SEND.END'
,p_message_language=>'it'
,p_message_text=>'Fine invio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278191973756867999)
,p_name=>'CA.SEND.ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore di invio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279246834623868669)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_language=>'it'
,p_message_text=>'Invia messaggi di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279246980976868669)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_language=>'it'
,p_message_text=>unistr('Determina se \00E8 necessario inviare messaggi di posta elettronica alla ricezione di un nuovo feedback.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279243556520868667)
,p_name=>'CA.SEND.FROM'
,p_message_language=>'it'
,p_message_text=>'Invia da'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279236059032868662)
,p_name=>'CA.SEND.TO'
,p_message_language=>'it'
,p_message_text=>'Invia a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279220534925868652)
,p_name=>'CA.SERIES'
,p_message_language=>'it'
,p_message_text=>'Serie %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278331950776868087)
,p_name=>'CA.SESSION.ID'
,p_message_language=>'it'
,p_message_text=>'ID sessione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279238529601868663)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_language=>'it'
,p_message_text=>'Protezione stato sessione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279195790939868636)
,p_name=>'CA.SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279195817157868636)
,p_name=>'CA.SETTINGS.DESC'
,p_message_language=>'it'
,p_message_text=>'<p>Specificare le impostazioni utilizzate nella generazione dell''applicazione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279220170636868652)
,p_name=>'CA.SHOW.ALL'
,p_message_language=>'it'
,p_message_text=>'Mostra tutto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278092825057867936)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_language=>'it'
,p_message_text=>'Mostra/nascondi ambito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279221283184868652)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_language=>'it'
,p_message_text=>'Mostra fuso orario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279221090461868652)
,p_name=>'CA.SIGN.IN'
,p_message_language=>'it'
,p_message_text=>'Collega'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279222290908868653)
,p_name=>'CA.SIGN.OUT'
,p_message_language=>'it'
,p_message_text=>'Scollega'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278331864505868087)
,p_name=>'CA.SLAVE.PID'
,p_message_language=>'it'
,p_message_text=>'PID slave'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278325821671868083)
,p_name=>'CA.SOURCE'
,p_message_language=>'it'
,p_message_text=>'Origine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279234135194868661)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_language=>'it'
,p_message_text=>unistr('Il tipo di origine non \00E8 valido')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279225924057868655)
,p_name=>'CA.SOURCES'
,p_message_language=>'it'
,p_message_text=>'Origini'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278328764988868085)
,p_name=>'CA.START.DATE'
,p_message_language=>'it'
,p_message_text=>'Data di inizio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278330566852868087)
,p_name=>'CA.STATE'
,p_message_language=>'it'
,p_message_text=>'Stato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279241794219868665)
,p_name=>'CA.STATICDEFAULT'
,p_message_language=>'it'
,p_message_text=>'Valore statico predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279204996449868642)
,p_name=>'CA.STATUS'
,p_message_language=>'it'
,p_message_text=>'Stato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278326552850868084)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_language=>'it'
,p_message_text=>'Arresta alla chiusura della finestra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278326630252868084)
,p_name=>'CA.STORE.OUTPUT'
,p_message_language=>'it'
,p_message_text=>'Memorizza output'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279215459141868648)
,p_name=>'CA.SUBJECT'
,p_message_language=>'it'
,p_message_text=>'Oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279214124306868648)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_language=>'it'
,p_message_text=>'Sottometti feedback'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279238818662868664)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_language=>'it'
,p_message_text=>'Visualizzazione consigliata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279230778355868658)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_language=>'it'
,p_message_text=>'Oggetti di supporto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279230845520868659)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_language=>'it'
,p_message_text=>'<p>Immettere il codice nello script di installazione, in genere per creare o manipolare gli oggetti di database oppure per eseguire operazioni di inserimento/aggiornamento/eliminazione nei record esistenti. Immettere il codice nello script di disinst'
||'allazione, in genere per rimuovere (eliminare) gli oggetti di database. Questi script verranno incorporati negli oggetti di supporto in modo che, quando si esporta l''applicazione, questi stessi aggiornamenti vengano eseguiti negli ambienti di prova e'
||' di produzione.</p>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279230940250868659)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Immettere istruzioni SQL e/o PL/SQL valide nello script di installazione eseguito quando l''applicazione viene importata.</p>',
'<p>Se si desidera che queste istruzioni vengano eseguite anche nell''ambiente corrente e non solo quando l''applicazione viene importata in un altro ambiente, fare clic su <strong>Esegui durante la creazione dell''applicazione</strong>.</p>',
'<p>Immettere istruzioni SQL e/o PL/SQL valide nello script di disinstallazione eseguito quando l''applicazione viene eliminata da App Builder.</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278326145266868084)
,p_name=>'CA.SYSTEM'
,p_message_language=>'it'
,p_message_text=>'Sistema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279240290093868664)
,p_name=>'CA.TABLE'
,p_message_language=>'it'
,p_message_text=>'Tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279196542240868636)
,p_name=>'CA.TABLE.PREFIX'
,p_message_language=>'it'
,p_message_text=>'Prefisso oggetti framework'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279196608972868636)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Immettere il prefisso di un oggetto che dovr\00E0 essere usato dall''applicazione. Alcune funzioni aggiungono questo prefisso agli oggetti di database creati (inclusi package e tabelle).</p>'),
unistr('<p>Avvertenza: verificare di immettere un prefisso univoco non utilizzato da altre applicazioni. Se il prefisso non \00E8 univoco, l''applicazione potrebbe restituire errori durante la creazione e non funzionare in modo corretto.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279241186611868665)
,p_name=>'CA.TABLECOLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279236106792868662)
,p_name=>'CA.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279218557857868651)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_language=>'it'
,p_message_text=>unistr('Il nome modello \00E8 gi\00E0 in uso.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279215370132868648)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome modello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279204046369868641)
,p_name=>'CA.TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278191860384867999)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_language=>'it'
,p_message_text=>'Dimensione corpo testo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279216540498868649)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di testo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279202206185868640)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_language=>'it'
,p_message_text=>'Preferenza tema utente finale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279202466554868640)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_language=>'it'
,p_message_text=>'Se l''opzione viene selezionata, gli utenti finali possono scegliere uno stile tema personale utilizzando il collegamento Personalizza.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279202327269868640)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_language=>'it'
,p_message_text=>'Consenti agli utenti finali di scegliere lo stile tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279186628509868630)
,p_name=>'CA.THEME.SELECTOR'
,p_message_language=>'it'
,p_message_text=>'Selezione stile tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279185018605868629)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_language=>'it'
,p_message_text=>'Aggiorna l''aspetto predefinito dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279186702364868630)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente agli amministratori di selezionare una combinazione di colori predefinita (stile tema) per l''applicazione. Inoltre, gli amministratori possono decidere di autorizzare gli utenti finali a scegliere uno stile di tema personalizzato. Gli ute'
||unistr('nti finali possono semplicemente fare clic sul pulsante <em>Personalizza</em> in fondo alla home page ed effettuare una selezione tra gli stili di tema disponibili. Ad esempio, gli utenti con capacit\00E0 visive ridotte potrebbero preferire l''uso dello s')
||unistr('tile di tema <em>Vista</em> che prevede un contrasto di colori molto pi\00F9 elevato.</p>'),
'<p>Include i seguenti componenti:',
'<ul>',
unistr('<li>Possibilit\00E0 per gli amministratori di definire lo stile di tema predefinito</li>'),
unistr('<li>Possibilit\00E0 per gli utenti finali di selezionare vari stili di tema</li>'),
'</ul>',
'</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279195173283868635)
,p_name=>'CA.THEME.STYLE'
,p_message_language=>'it'
,p_message_text=>'Stile tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279195220908868636)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Selezionare lo stile tema predefinito usato per visualizzare l''applicazione.</p>',
unistr('<p>Lo stile pu\00F2 essere immediatamente modificato in un altro stile predefinito o modificato dopo la generazione. Per modificare lo stile, eseguire l''applicazione, quindi fare clic su <strong>Theme Roller</strong> nella barra degli strumenti sviluppat')
||'ore.</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279209233312868645)
,p_name=>'CA.TIME'
,p_message_language=>'it'
,p_message_text=>'Ora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279200953902868639)
,p_name=>'CA.TIME.ZONE'
,p_message_language=>'it'
,p_message_text=>'Fuso orario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279187796312868631)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_language=>'it'
,p_message_text=>'Supporto fuso orario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279184676616868629)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_language=>'it'
,p_message_text=>'Imposta fusi orari predefiniti e definiti dall''utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279187424982868631)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Consente agli utenti finali di impostare il proprio fuso orario. Questa funzione \00E8 importante se le tabelle dell''applicazione usano tipi di dati basati sul fuso orario (ad esempio un indicatore orario con fuso orario locale) in modo che i report e')
||unistr(' le immissioni di dati rispecchino la localit\00E0 in cui si trovano gli utenti finali.</p>'),
'<p>Include i seguenti componenti:',
'<ul>',
unistr('<li>Possibilit\00E0 per gli amministratori di impostare il fuso orario predefinito</li>'),
unistr('<li>Possibilit\00E0 per gli utenti finali di selezionare la preferenza di fuso orario</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279244130181868667)
,p_name=>'CA.TIMEFRAME'
,p_message_language=>'it'
,p_message_text=>'Intervallo di tempo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279244411520868667)
,p_name=>'CA.TIMELINE'
,p_message_language=>'it'
,p_message_text=>'Aggiungi pagina controllo temporale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279244572343868667)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di creare una pagina che visualizza un controllo temporale, particolarmente utile per la visualizzazione degli aggiornamenti.</p>',
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome pagina</strong>(obbligatorio): immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
'  <li><strong>Tabella o vista</strong> (obbligatorio): selezionare l''oggetto di database per il controllo temporale.</li>',
'  <li><strong>Nome utente</strong> (obbligatorio): selezionare la colonna della tabella o della vista da utilizzare per specificare l''utente visualizzato per le immissioni del controllo temporale.</li>',
'  <li><strong>Data</strong> (obbligatorio): selezionare la colonna della tabella o della vista da utilizzare per specificare la data per le immissioni del controllo temporale.</li>',
'  <li><strong>Nome evento</strong> (obbligatorio): selezionare la colonna della tabella o della vista da utilizzare per specificare il titolo per le immissioni del controllo temporale.</li>',
'  <li><strong>Descrizione</strong>: selezionare la colonna della tabella o della vista da utilizzare per specificare la descrizione per le immissioni del controllo temporale.</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279206195752868643)
,p_name=>'CA.TIMESTAMP'
,p_message_language=>'it'
,p_message_text=>'Indicatore orario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279210793860868646)
,p_name=>'CA.TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278192475698867999)
,p_name=>'CA.TO'
,p_message_language=>'it'
,p_message_text=>'A'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279209913471868645)
,p_name=>'CA.TOP.USERS'
,p_message_language=>'it'
,p_message_text=>'Primi utenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279210070298868645)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_language=>'it'
,p_message_text=>'Grafico Primi utenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279207517299868644)
,p_name=>'CA.TOTAL.ROWS'
,p_message_language=>'it'
,p_message_text=>'Righe totali'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279211993998868646)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_language=>'it'
,p_message_text=>'Ruolo predefinito per gli utenti che non fanno parte della lista di controllo dell''accesso.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279204191737868641)
,p_name=>'CA.TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278423099207868145)
,p_name=>'CA.UI.DEFAULTS'
,p_message_language=>'it'
,p_message_text=>'Valori predefiniti interfaccia utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278423120079868145)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_language=>'it'
,p_message_text=>'Consente di definire i valori predefiniti per le impostazioni dell''interfaccia utente, quali le righe per pagina, e di aggiungere le definizioni delle liste di valori. Queste impostazioni vengono utilizzate durante la generazione dei componenti nell'''
||'applicazione. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279204349399868641)
,p_name=>'CA.UNTIL'
,p_message_language=>'it'
,p_message_text=>'Fino a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278476035876868179)
,p_name=>'CA.UPDATE'
,p_message_language=>'it'
,p_message_text=>'Aggiorna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279213708158868647)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_language=>'it'
,p_message_text=>'Aggiorna profilo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279204692647868642)
,p_name=>'CA.UPDATED'
,p_message_language=>'it'
,p_message_text=>'Aggiornato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279204704463868642)
,p_name=>'CA.UPDATED.BY'
,p_message_language=>'it'
,p_message_text=>'Autore aggiornamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279206004257868643)
,p_name=>'CA.USER'
,p_message_language=>'it'
,p_message_text=>'Utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279233669812868660)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_language=>'it'
,p_message_text=>unistr('Aggiungi pi\00F9 utenti - Passo 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279233770463868660)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_language=>'it'
,p_message_text=>unistr('Aggiungi pi\00F9 utenti - Passo 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279233835830868660)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_language=>'it'
,p_message_text=>unistr('Aggiungi pi\00F9 utenti')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279208462143868644)
,p_name=>'CA.USER.AGENT'
,p_message_language=>'it'
,p_message_text=>'User Agent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279221875858868653)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_language=>'it'
,p_message_text=>'Report conteggi utenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279210219961868645)
,p_name=>'CA.USER.NAME'
,p_message_language=>'it'
,p_message_text=>'Nome utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279212773161868647)
,p_name=>'CA.USER.PROFILE'
,p_message_language=>'it'
,p_message_text=>'Profilo utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279187696309868631)
,p_name=>'CA.USER.PROFILES'
,p_message_language=>'it'
,p_message_text=>'Profili utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279184573534868629)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_language=>'it'
,p_message_text=>'Consente agli utenti di aggiornare il proprio profilo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279187535554868631)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente agli utenti finali di immettere informazioni aggiuntive su se stessi, inclusa un''immagine o un avatar, per personalizzare il proprio account.</p>',
'<p>Include i seguenti componenti:',
'<ul>',
'<li>Impostazione della pagina da parte degli utenti finali per impostare il proprio profilo</li>',
unistr('<li>Possibilit\00E0 di caricare una foto o un avatar</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279212945168868647)
,p_name=>'CA.USERNAME'
,p_message_language=>'it'
,p_message_text=>'Nome utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279212076083868646)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formato nome utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279234553492868661)
,p_name=>'CA.USERNAMES'
,p_message_language=>'it'
,p_message_text=>'Nomi utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278430715972868150)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formato nome utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279235154937868661)
,p_name=>'CA.USERS.ADDED'
,p_message_language=>'it'
,p_message_text=>'Utente/i aggiunto/i.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279236628227868662)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_language=>'it'
,p_message_text=>'Utenti per ruolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279216123191868649)
,p_name=>'CA.USERS.INCLUDED'
,p_message_language=>'it'
,p_message_text=>'Utenti inclusi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279234806705868661)
,p_name=>'CA.USERS.TO.ADD'
,p_message_language=>'it'
,p_message_text=>'Utenti da aggiungere'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279212238953868646)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_language=>'it'
,p_message_text=>'Formato nome utente aggiornato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278113095943867949)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'it'
,p_message_text=>'Esistono utenti validi - Informazioni pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279227840487868657)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_language=>'it'
,p_message_text=>unistr('L''ID applicazione esiste gi\00E0 oppure \00E8 riservato per un''altra applicazione.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278371381512868112)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_language=>'it'
,p_message_text=>'Specificare un valore per Nome applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279237281165868663)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 necessario specificare gli indirizzi di posta elettronica a cui inviare il messaggio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279237032637868662)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 necessario specificare gli indirizzi di posta elettronica o selezionare un gruppo di utenti a cui inviare il messaggio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279237105139868663)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 necessario specificare gli indirizzi di posta elettronica o selezionare un gruppo di utenti a cui inviare il messaggio.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279227953571868657)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_language=>'it'
,p_message_text=>'Il prefisso della tabella non deve superare i sei caratteri, deve iniziare con una lettera e contenere solo lettere, numeri e caratteri di sottolineatura.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279228038888868657)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_language=>'it'
,p_message_text=>unistr('Immettere un prefisso di tabella diverso. I seguenti oggetti di database esistono gi\00E0: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279212618279868647)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_language=>'it'
,p_message_text=>'Nome utente in un formato di indirizzo di posta elettronica non valido. Notare il formato del nome utente dell''applicazione riportato di seguito.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279212500201868647)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_language=>'it'
,p_message_text=>'Verifica formato di posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279210136638868645)
,p_name=>'CA.VIEW.AS'
,p_message_language=>'it'
,p_message_text=>'Visualizza come'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279231563906868659)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_language=>'it'
,p_message_text=>'Visualizza progetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279220000009868652)
,p_name=>'CA.VIEW.DETAILS'
,p_message_language=>'it'
,p_message_text=>'Visualizza dettagli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279237425281868663)
,p_name=>'CA.VIEW.EMAIL'
,p_message_language=>'it'
,p_message_text=>'Visualizza posta elettronica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279222115634868653)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_language=>'it'
,p_message_text=>'Visualizza profilo personale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279207022937868643)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_language=>'it'
,p_message_text=>'Prestazioni ponderate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279242098685868666)
,p_name=>'CA.WIDTH'
,p_message_language=>'it'
,p_message_text=>'Larghezza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279246207366868668)
,p_name=>'CA.WIZARD'
,p_message_language=>'it'
,p_message_text=>'Crea pagine procedura guidata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278112975646867949)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_language=>'it'
,p_message_text=>'Contenitore procedura guidata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279246361511868668)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Consente di creare una raccolta di pagine da utilizzare come procedura guidata. In genere le procedure guidate vengono utilizzate per l''immissione dei dati in vari passi successivi.</p>',
'<p>Immettere gli attributi riportati di seguito.</p>',
'<ul>',
'  <li><strong>Nome procedura guidata</strong> (obbligatorio): immettere un nome per questa pagina.</li>',
'  <li><strong>Imposta icona</strong>: selezionare l''icona da visualizzare nel menu di navigazione di questa pagina.</li>',
unistr('  <li><strong>Modalit\00E0 pagina</strong> (obbligatorio): specificare se i passi della procedura guidata verranno visualizzati come pagine di tipo modale o normale. Selezionare <strong>Pagina modale</strong> o <strong>Pagina intera</strong>.</li>'),
'  <li><strong>Passo 1 ... 8</strong>: immettere il nome pagina per i passi della procedura guidata.<br><em><strong>Nota:</strong> i passi da 5 a 8 vengono visualizzati quando si immette un nome per ogni passo precedente.</em></li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279210588023868645)
,p_name=>'CA.WORK.PHONE'
,p_message_language=>'it'
,p_message_text=>'Telefono ufficio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279203246208868641)
,p_name=>'CA.YELLOW'
,p_message_language=>'it'
,p_message_text=>'Giallo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278423694570868145)
,p_name=>'CA.YES'
,p_message_language=>'it'
,p_message_text=>unistr('S\00EC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277957932983867851)
,p_name=>'CACHED'
,p_message_language=>'it'
,p_message_text=>'Inserito nella cache'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277841612294867778)
,p_name=>'CACHE_CREATED'
,p_message_language=>'it'
,p_message_text=>'Cache creata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277829100782867770)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_language=>'it'
,p_message_text=>unistr('La funzionalit\00E0 di eliminazione di dati \00E8 disabilitata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277813620462867760)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_language=>'it'
,p_message_text=>unistr('La funzionalit\00E0 di aggiunta di dati \00E8 disabilitata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277813721521867760)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_language=>'it'
,p_message_text=>unistr('La funzionalit\00E0 di aggiornamento di dati \00E8 disabilitata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277996992013867876)
,p_name=>'CALENDAR.NEXT'
,p_message_language=>'it'
,p_message_text=>'Successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277996866179867876)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_language=>'it'
,p_message_text=>'Precedente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277854549744867786)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_language=>'it'
,p_message_text=>'Calendario semplice'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279018020927868522)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_language=>'it'
,p_message_text=>'Modifica voce di calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277802241607867753)
,p_name=>'CALENDAR_POPUP'
,p_message_language=>'it'
,p_message_text=>'Popup calendario per %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277952749248867848)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_language=>'it'
,p_message_text=>'Creazione del calendario completata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278355574707868102)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di calendario precedente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277854489594867786)
,p_name=>'CALENDAR_TYPE'
,p_message_language=>'it'
,p_message_text=>'Calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278206050132868008)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'Nessun modello di calendario trovato durante il tentativo di copia dall''applicazione %0 e dall''ID modello %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278356940501868103)
,p_name=>'CANCEL'
,p_message_language=>'it'
,p_message_text=>'Annulla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277795352531867749)
,p_name=>'CANDLESTICK'
,p_message_language=>'it'
,p_message_text=>'A canne d''organo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278691648677868315)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_language=>'it'
,p_message_text=>'CSS'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278413078629868139)
,p_name=>'CENTER'
,p_message_language=>'it'
,p_message_text=>'Al centro'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278447104863868160)
,p_name=>'CHANGES'
,p_message_language=>'it'
,p_message_text=>'Modifiche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279077263336868560)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_language=>'it'
,p_message_text=>'Modifica autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278351387391868100)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_language=>'it'
,p_message_text=>'Modifica dimensione database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277969538100867858)
,p_name=>'CHANGE_PW_REQUEST'
,p_message_language=>'it'
,p_message_text=>'%0 richieste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278351138644868099)
,p_name=>'CHANGE_REQUEST'
,p_message_language=>'it'
,p_message_text=>'Richiesta di modifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278638870535868282)
,p_name=>'CHANGE_WORKSPACE'
,p_message_language=>'it'
,p_message_text=>'Modifica area di lavoro'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278323147452868082)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna set di caratteri'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278048471241867908)
,p_name=>'CHART'
,p_message_language=>'it'
,p_message_text=>'grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277800694380867752)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Query su grafico non valida: %0<br><br>',
'Utilizzare la seguente sintassi:',
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
'<tr><td>LABEL</td><td>Testo associato alla barra</td></tr>',
'<tr><td>VALUE</td><td>Colonna numerica che definisce la dimensione della barra</td></tr>',
'</table>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277991737733867873)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Query su grafico non valida.<br /><br /> Utilizzare la seguente sintassi: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>',
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
'<td>Colonna numerica che definisce il valore di composizione.</td>',
'</tr>',
'<tr>',
'<td>MAX</td>',
'<td>Colonna numerica che definisce il valore massimo di composizione.</td>',
'</tr>',
'<tr>',
'<td>LOW (facoltativo)</td>',
'<td>Colonna numerica che definisce il valore minimo precedente di composizione.</td>',
'</tr>',
'<tr>',
'<td>HIGH (facoltativo)</td>',
'<td>Colonna numerica che definisce il valore massimo precedente di composizione.</td>',
'</tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278066686407867920)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_language=>'it'
,p_message_text=>'Tipo di grafico non valido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277800544208867752)
,p_name=>'CHART.INVALID_QUERY'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Analisi della query SQL non riuscita.',
'<p>%0</p>',
unistr('Alcune query possono essere eseguite solo se l''applicazione \00E8 in esecuzione. Se la query ha una sintassi corretta, \00E8 possibile salvarla senza convalida (vedere le opzioni sotto l''origine della query).')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279132409318868595)
,p_name=>'CHART_DEGREES'
,p_message_language=>'it'
,p_message_text=>'gradi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278300026792868067)
,p_name=>'CHART_PAGE'
,p_message_language=>'it'
,p_message_text=>'Grafico %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277829964714867771)
,p_name=>'CHART_SERIES'
,p_message_language=>'it'
,p_message_text=>'Serie di grafici'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278347612541868097)
,p_name=>'CHART_SERIES_ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore della serie di grafico %0 per %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277945980317867844)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_language=>'it'
,p_message_text=>'Creazione del grafico completata.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277905244076867818)
,p_name=>'CHECK$'
,p_message_language=>'it'
,p_message_text=>'selettore di riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279064997629868553)
,p_name=>'CHECKED'
,p_message_language=>'it'
,p_message_text=>'selezionato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278303945258868070)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Checksum obbligatorio: a livello applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278120480353867954)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_language=>'it'
,p_message_text=>'Checksum obbligatorio: a livello di sessione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278120310233867954)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_language=>'it'
,p_message_text=>'Checksum obbligatorio: a livello di utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278120252688867954)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_language=>'it'
,p_message_text=>'Checksum obbligatorio: a livello applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279134869136868597)
,p_name=>'CHECK_ALL'
,p_message_language=>'it'
,p_message_text=>'Seleziona tutto'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278287911681868059)
,p_name=>'CLASSIC_CALENDAR'
,p_message_language=>'it'
,p_message_text=>'Calendario classico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278290903738868061)
,p_name=>'CLASSIC_REPORT'
,p_message_language=>'it'
,p_message_text=>'Report classico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277990242836867872)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne report classico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278288533892868060)
,p_name=>'CLASSIC_TREE'
,p_message_language=>'it'
,p_message_text=>'Struttura classica'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278286787370868059)
,p_name=>'CLEAN_UP'
,p_message_language=>'it'
,p_message_text=>'Esegui cleanup della pagina'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277824196390867767)
,p_name=>'CLEAR_COMMAND'
,p_message_language=>'it'
,p_message_text=>'Cancella comando'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278296655219868065)
,p_name=>'CLOSED'
,p_message_language=>'it'
,p_message_text=>'Chiuso/i'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278344266452868095)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_language=>'it'
,p_message_text=>'Chiusi negli ultimi 7 giorni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278109927284867947)
,p_name=>'CLOSE_WINDOW'
,p_message_language=>'it'
,p_message_text=>'Chiudi finestra'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279228478519868657)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'it'
,p_message_text=>'Chiudi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279230165739868658)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'it'
,p_message_text=>'Trova'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279228313239868657)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'it'
,p_message_text=>'Trova'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279230056646868658)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'it'
,p_message_text=>'Trova successivo'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279229910224868658)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'it'
,p_message_text=>'Trova precedente'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279229721685868658)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'it'
,p_message_text=>'Completamento automatico'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279229039340868657)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'it'
,p_message_text=>'Dimensione indentazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279229230297868657)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'it'
,p_message_text=>'La tabulazione inserisce spazi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279228624465868657)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'it'
,p_message_text=>'Corrispondenza maiuscole/minuscole'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279228549338868657)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'it'
,p_message_text=>'Espressione regolare'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279233574763868660)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_language=>'it'
,p_message_text=>'Query Builder'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279230266145868658)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'it'
,p_message_text=>'Ripeti'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279229818705868658)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'it'
,p_message_text=>'Sostituisci'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279228104733868657)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'it'
,p_message_text=>'Sostituisci tutto'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279228205333868657)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'it'
,p_message_text=>'Sostituisci'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279230510450868658)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'it'
,p_message_text=>'Salta'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279229558264868658)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279228870648868657)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'it'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279229350786868658)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'it'
,p_message_text=>'Mostra numeri di riga'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279228759875868657)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'it'
,p_message_text=>'Mostra righello'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279229166652868657)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'it'
,p_message_text=>'Dimensione tabulazione'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279228909180868657)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'it'
,p_message_text=>'Temi'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279230357237868658)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'it'
,p_message_text=>'Annulla'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279229405796868658)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'it'
,p_message_text=>'Usa editor di testo non codificato'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279229624382868658)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'it'
,p_message_text=>'Convalida'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279230439484868658)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Convalida completata'
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278226852414868021)
,p_name=>'COLLAPSE'
,p_message_language=>'it'
,p_message_text=>'Comprimi '
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277837461352867775)
,p_name=>'COLOR_PALETTE'
,p_message_language=>'it'
,p_message_text=>'Tavolozza colori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278063285915867918)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_language=>'it'
,p_message_text=>'Analogici'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278062841392867917)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_language=>'it'
,p_message_text=>'Complementari'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278063489518867918)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_language=>'it'
,p_message_text=>'Colori complementari'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278063310912867918)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_language=>'it'
,p_message_text=>'Monotoni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278062903729867917)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_language=>'it'
,p_message_text=>'Complementari spaccati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278063106367867918)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_language=>'it'
,p_message_text=>'Tetrade'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278063081358867918)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_language=>'it'
,p_message_text=>'Triade'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278683743576868310)
,p_name=>'COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279119893464868588)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_language=>'it'
,p_message_text=>'Nome visualizzato: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278219161545868016)
,p_name=>'COLUMN_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome colonna'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278424895507868146)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_language=>'it'
,p_message_text=>'Tutti gli utenti autenticati possono accedere a questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278424991296868146)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_language=>'it'
,p_message_text=>'Solo gli utenti definiti nella lista di controllo dell''accesso dell''applicazione possono accedere a questa applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278425032319868146)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_language=>'it'
,p_message_text=>'Valore di impostazione del controllo dell''accesso imprevisto: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277830832822867771)
,p_name=>'COMING_SOON'
,p_message_language=>'it'
,p_message_text=>'Di futura implementazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278219690846868016)
,p_name=>'COMMENT'
,p_message_language=>'it'
,p_message_text=>'Commento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278357159304868103)
,p_name=>'COMMENTS'
,p_message_language=>'it'
,p_message_text=>'Commenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278111120584867948)
,p_name=>'COMPILE_FAILURE'
,p_message_language=>'it'
,p_message_text=>'Compilazione non riuscita: riga <a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278441188052868157)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_language=>'it'
,p_message_text=>unistr('Compilazione non riuscita: riga %0 (%2). I numeri di riga associati agli errori di compilazione sono relativi alla prima istruzione BEGIN. Ci\00F2 influenza solo la compilazione dei trigger di database.<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278111045527867948)
,p_name=>'COMPILE_SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Compilazione del codice PL/SQL completata (%0).'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278293977483868063)
,p_name=>'COMPLETE'
,p_message_language=>'it'
,p_message_text=>'Completato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278301331952868068)
,p_name=>'COMPLETED'
,p_message_language=>'it'
,p_message_text=>'Completato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278308386477868072)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_language=>'it'
,p_message_text=>'Completato/nessun problema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278344885271868096)
,p_name=>'COMPONENT'
,p_message_language=>'it'
,p_message_text=>'Componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278501642762868195)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_language=>'it'
,p_message_text=>'Nome componente: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278772988305868366)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_language=>'it'
,p_message_text=>'Componente non abilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277949465032867846)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_language=>'it'
,p_message_text=>'Creazione del componente riuscita.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279115118495868585)
,p_name=>'COMPONENT_SUMMARY'
,p_message_language=>'it'
,p_message_text=>'Riepilogo componenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277892619129867810)
,p_name=>'COMPUTATIONS'
,p_message_language=>'it'
,p_message_text=>'Calcoli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278368327618868110)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_language=>'it'
,p_message_text=>'Componenti di applicazione installati.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278111748632867948)
,p_name=>'CONDITIONAL'
,p_message_language=>'it'
,p_message_text=>'Condizionale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278201668657868005)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_language=>'it'
,p_message_text=>'lista di valori popup'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278285482032868058)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_language=>'it'
,p_message_text=>'sempre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278021496669867891)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'esiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278020995865867891)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_language=>'it'
,p_message_text=>'elemento/colonna=valore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278021013548867891)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_language=>'it'
,p_message_text=>'elemento/colonna non nullo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278987087005868502)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_language=>'it'
,p_message_text=>'elemento/colonna nullo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278021585229867892)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_language=>'it'
,p_message_text=>'mai'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278021690686867892)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_language=>'it'
,p_message_text=>'nessuno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278021234864867891)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_language=>'it'
,p_message_text=>'pagina inclusa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278021320390867891)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_language=>'it'
,p_message_text=>'pagina non inclusa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278020837430867891)
,p_name=>'CONDITIONS_SHORTCUT_PLSQL'
,p_message_language=>'it'
,p_message_text=>'PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278021192635867891)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_language=>'it'
,p_message_text=>'richiesta=e1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278032766324867899)
,p_name=>'CONDITION_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di condizione'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278246809659868034)
,p_name=>'CONFIRM'
,p_message_language=>'it'
,p_message_text=>'Conferma'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277797137500867750)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_language=>'it'
,p_message_text=>'Master-Detail a due pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277797043640867750)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_language=>'it'
,p_message_text=>'Master-Detail a tre pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278007418488867883)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome effettivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278293143659868063)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_language=>'it'
,p_message_text=>'Colonne Aggrega per'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278293206890868063)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_language=>'it'
,p_message_text=>'Funzioni aggregate da utilizzare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278004872744867881)
,p_name=>'CONFIRM.APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278018221591867889)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_language=>'it'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278018351729867889)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_language=>'it'
,p_message_text=>'Lingua predefinita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278018184390867889)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277899393704867814)
,p_name=>'CONFIRM.ARRAY'
,p_message_language=>'it'
,p_message_text=>'Struttura dei risultati per il report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277899440944867815)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_language=>'it'
,p_message_text=>'Parametri dei risultati per il report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278018422452867890)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_language=>'it'
,p_message_text=>'Autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278484842970868184)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_language=>'it'
,p_message_text=>'Dirama a pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278209081282868010)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne di interruzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278007265695867882)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_language=>'it'
,p_message_text=>'Diramazione del pulsante %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278007123410867882)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo visualizzato del pulsante %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277810843414867759)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_language=>'it'
,p_message_text=>'Abilita l''aggiunta di dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277810741441867759)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_language=>'it'
,p_message_text=>'Abilita trascinamento della selezione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278427297485868148)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_language=>'it'
,p_message_text=>'Annulla diramazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278484677884868184)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta pulsante Annulla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278475127817868178)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_language=>'it'
,p_message_text=>'Con distinzione tra maiuscole e minuscole'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278109427857867947)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 richiesto di modificare la query di report interattivo. Se sono state rimosse colonne nella query, verranno disabilitati i filtri esistenti, le regole di evidenziazione e altre impostazioni di report che fanno riferimento alle colonne eliminate.')
||' Confermare la richiesta.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278008397004867883)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_language=>'it'
,p_message_text=>'Asse del grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278357487604868103)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_language=>'it'
,p_message_text=>'Quadrante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278357584788868103)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_language=>'it'
,p_message_text=>'Quadrante (con riempimento)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278009067762867884)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_language=>'it'
,p_message_text=>'Barra orizzontale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278009229905867884)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_language=>'it'
,p_message_text=>'Riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278008501801867883)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_language=>'it'
,p_message_text=>'Maschera dei numeri'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278009141126867884)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_language=>'it'
,p_message_text=>'A torta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278008299807867883)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_language=>'it'
,p_message_text=>'Query su grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278008465378867883)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_language=>'it'
,p_message_text=>'Scala'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278009335768867884)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_language=>'it'
,p_message_text=>'A dispersione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278008878859867883)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_language=>'it'
,p_message_text=>'Dimensione grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278008769016867883)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo del grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278008662650867883)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di grafico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278008925121867884)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_language=>'it'
,p_message_text=>'Barra verticale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277899507954867815)
,p_name=>'CONFIRM.COLLECTION'
,p_message_language=>'it'
,p_message_text=>'Nome set di risultati temporaneo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278005683405867881)
,p_name=>'CONFIRM.COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278208864877868010)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_language=>'it'
,p_message_text=>'Intestazioni di colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278384794123868121)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278427405216868148)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_language=>'it'
,p_message_text=>'Nome/i colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278017947860867889)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_language=>'it'
,p_message_text=>'Utilizza ordinamento intestazioni di colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278124642340867956)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di copiare un''applicazione con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278016510787867888)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di copiare una pagina con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278006185185867882)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_language=>'it'
,p_message_text=>unistr('Un nuovo set di schede "%0" verr\00E0 creato e utilizzato da questa pagina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278018078743867889)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare un''applicazione con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278010642160867885)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di calendario con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278013856326867887)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di report espanso con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278073559441867924)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di report interattivo con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278016884771867889)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di report con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277804402162867755)
,p_name=>'CONFIRM.CREATE_FLASH_CHART'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina con grafico flash con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279090721299868569)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare un''applicazione database utilizzando lo stesso ID di un''applicazione database esistente nell''area di lavoro corrente. L''applicazione database esistente verr\00E0 eliminata e sostituita dalla nuova applicazione database. Confer')
||'mare le selezioni. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278381583378868119)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare pagine Vista form e lista con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278292818014868063)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di form e di report con pagine di analisi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278010274596867884)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare un form basato su query SQL con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278010128228867884)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare un form basato su stored procedure con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278010063754867884)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di form su tabella con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277855569377867787)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare un form su una pagina di riferimento a un Web Service con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277912326953867823)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare un form e un report su una pagina di riferimento a un Web Service con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278322138345868081)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di mappa con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277794501052867748)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare pagine Master-Detail con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278011839798867885)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare un''area di indicatore di percorso e un''opzione di indicatore di percorso con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278300177076868067)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_language=>'it'
,p_message_text=>unistr('Modalit\00E0 di creazione')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278009813412867884)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279166260309868617)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_language=>'it'
,p_message_text=>'Crea pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279166318502868617)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_language=>'it'
,p_message_text=>'Crea nome pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278012631269867886)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare pagine di form e report con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279086649035868566)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278016630907867888)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di report con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278010372684867884)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di grafico a barre HTML con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278016205149867888)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di riepilogo con i seguenti attributi. Fare clic sul pulsante "Aggiungi altro" per aggiungere ulteriori elementi da altre pagine e/o aree. Fare clic su "Fine" per creare gli elementi di riepilogo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278010418633867884)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina con grafico SVG con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278009710736867884)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di form tabulare con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278010947778867885)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una pagina di struttura con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278009955835867884)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare una procedura guidata con i seguenti attributi. Confermare le selezioni.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279090329657868569)
,p_name=>'CONFIRM.CREATE_WS_APP_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di creare un''applicazione Websheet utilizzando lo stesso ID di un''applicazione Websheet esistente nell''area di lavoro corrente. L''applicazione Websheet esistente verr\00E0 eliminata e sostituita dalla nuova applicazione Websheet. Confer')
||'mare le selezioni. '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278204603239868007)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_language=>'it'
,p_message_text=>'Etichetta di collegamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279023395293868526)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome definizione caricamento dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279097975525868574)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_language=>'it'
,p_message_text=>unistr('Questa definizione di caricamento dati verr\00E0 ricreata con le ricerche di tabella e le regole di trasformazione esistenti.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278475298528868178)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_language=>'it'
,p_message_text=>'Numero pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278010729033867885)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278300279647868067)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_language=>'it'
,p_message_text=>'Schema di autenticazione predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278009694551867884)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_language=>'it'
,p_message_text=>'Elimina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278014511979867887)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_language=>'it'
,p_message_text=>'Colonne di visualizzazione dettagli %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277797573750867750)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonna/e di visualizzazione dettagli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278016118399867888)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_language=>'it'
,p_message_text=>'Colonna indicatore di percorso dei dettagli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278015310276867888)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_language=>'it'
,p_message_text=>'Ordina per tabella dettagli %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278014027227867887)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina dettagli %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277797443614867750)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_language=>'it'
,p_message_text=>'Tabella dettagli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278014330378867887)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome tabella dettagli %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278014194833867887)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta scheda dettagli %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278427742946868148)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna di caricamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278007713898867883)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278384454036868121)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_language=>'it'
,p_message_text=>'Colonna di caricamento 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278384551743868121)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_language=>'it'
,p_message_text=>'Colonna di caricamento 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278012030679867885)
,p_name=>'CONFIRM.DISPLAY_POINT'
,p_message_language=>'it'
,p_message_text=>'Punto di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279175111292868623)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_language=>'it'
,p_message_text=>'Modifica pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279175220033868623)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_language=>'it'
,p_message_text=>'Modifica nome pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278197515504868003)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_language=>'it'
,p_message_text=>'Output CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278198237058868003)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_language=>'it'
,p_message_text=>'Output di stampa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278198833190868003)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_language=>'it'
,p_message_text=>'Abilita ordinamento intestazioni di colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278248751940868035)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('Un''area verr\00E0 aggiunta alla pagina di amministrazione esistente:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278427363943868148)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_language=>'it'
,p_message_text=>'Fine diramazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278013113759867886)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278013203124867886)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome pagina di form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278013495483867886)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta scheda pagina form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278013375367867886)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_language=>'it'
,p_message_text=>'Set di schede pagina form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278300398869868067)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_language=>'it'
,p_message_text=>'Importa componenti condivisi da'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278757817919868357)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_language=>'it'
,p_message_text=>'Includi calendario personalizzato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277797766327867750)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_language=>'it'
,p_message_text=>'Includere il report principale?'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278015804298867888)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_language=>'it'
,p_message_text=>'Includi un indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278006921389867882)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di informazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278007095471867882)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo predefinito informazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277855709258867787)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Elementi di form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277899703286867815)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello area form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277899629096867815)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo area form'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278009436383867884)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_language=>'it'
,p_message_text=>'Inserisci'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278006767555867882)
,p_name=>'CONFIRM.ITEMS'
,p_message_language=>'it'
,p_message_text=>'Elementi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278427613832868148)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna restituita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278426532114868147)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_language=>'it'
,p_message_text=>'Colonna chiave di ricerca 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278426697619868147)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_language=>'it'
,p_message_text=>'Colonna chiave 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278426795233868148)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_language=>'it'
,p_message_text=>'Colonna chiave 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278010853829867885)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna etichetta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278384659667868121)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278427591234868148)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_language=>'it'
,p_message_text=>'Tabella di ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277797894826867750)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_language=>'it'
,p_message_text=>'Layout Master-Detail'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277797347345867750)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonna/e di visualizzazione principale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277797647622867750)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_language=>'it'
,p_message_text=>'Navigazione del record principale per'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277797278231867750)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_language=>'it'
,p_message_text=>'Tabella principale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278208978078868010)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Numero massimo di colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278204470944868007)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_language=>'it'
,p_message_text=>'Righe per pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278082247026867930)
,p_name=>'CONFIRM.MENU'
,p_message_language=>'it'
,p_message_text=>'Indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278012389334867886)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_language=>'it'
,p_message_text=>'Collegamento indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278015968384867888)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_language=>'it'
,p_message_text=>'Radice indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278012108849867886)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278012428643867886)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277930096630867834)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 richiesto di aggiornare il grafico flash a un nuovo grafico flash 6. Confermare la richiesta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278294021751868063)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6_XML'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 richiesto di aggiornare un grafico flash basato su XML personalizzato a un nuovo grafico flash 6. A causa delle differenze nella struttura XML tra il grafico corrente e il grafico flash 6, il grafico aggiornato non sar\00E0 visualizzato. Per utilizz')
||unistr('are la nuova struttura XML \00E8 necessario modificare l''XML personalizzato del grafico aggiornato. Confermare la richiesta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277868362417867795)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 richiesto di aggiornare il grafico flash a un nuovo grafico HTML5. Confermare la richiesta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277868419348867795)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5_XML'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 richiesto di aggiornare un grafico flash basato su XML personalizzato a un nuovo grafico HTML5. A causa delle differenze nella struttura XML tra il grafico corrente e il grafico HTML5, il grafico aggiornato non sar\00E0 visualizzato. Per utilizzare ')
||unistr('la nuova struttura XML \00E8 necessario modificare l''XML personalizzato del grafico aggiornato. Confermare la richiesta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277868235344867795)
,p_name=>'CONFIRM.MIGRATE_HTML_TO_HTML5'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 richiesto di aggiornare il grafico HTML a un nuovo grafico HTML5. Confermare la richiesta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279111153161868582)
,p_name=>'CONFIRM.MIGRATE_JSTREE_TO_APEXTREE'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 richiesto di aggiornare jsTree a una nuova struttura. Confermare la richiesta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277996117356867876)
,p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('Il grafico SVG verr\00E0 aggiornato con le seguenti limitazioni:  '),
'<ul>',
'<li>',
unistr('Verr\00E0 eseguita la migrazione solo dei formati numerici definiti in stringhe di formato dell''asse. I formati di data e ora verranno ignorati.'),
'</li>',
'<li>',
unistr('Verr\00E0 eseguita la migrazione degli elementi in formato numerico contenenti i seguenti caratteri:'),
'<br />',
'0,9,D,G,, (virgola),. (punto),$,C,L,FM',
'</li>',
'<li>',
unistr('L''etichetta per ciascuna serie nel grafico Flash verr\00E0 derivata dall''alias di colonna di ciascuna serie,  '),
'a differenza di quanto accadeva per i grafici SVG, in cui l''etichetta di ciascuna serie veniva derivata dall''attributo Nome serie.',
'</li>',
'<li>',
'I grafici flash a quadrante visualizzano valori effettivi invece che percentuali.',
'</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277951211831867847)
,p_name=>'CONFIRM.MIGRATE_SVG_TO_HTML5'
,p_message_language=>'it'
,p_message_text=>unistr('Si \00E8 richiesto di aggiornare il grafico SVG al grafico HTML5. Confermare la richiesta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279086489836868566)
,p_name=>'CONFIRM.NAVIGATION'
,p_message_language=>'it'
,p_message_text=>'Navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278018733517867890)
,p_name=>'CONFIRM.NAV_BAR'
,p_message_language=>'it'
,p_message_text=>'Barra di navigazione'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278736620296868343)
,p_name=>'CONFIRM.NAV_LIST'
,p_message_language=>'it'
,p_message_text=>'Lista menu di navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278311974840868075)
,p_name=>'CONFIRM.NEW_ADMIN_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('Verr\00E0 aggiunta una nuova pagina di amministrazione. Pagina:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278109671384867947)
,p_name=>'CONFIRM.NEW_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Nuove colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278007526811867883)
,p_name=>'CONFIRM.NEW_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Nuovo modello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278484474017868184)
,p_name=>'CONFIRM.NEXT_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta pulsante Successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278006069132867882)
,p_name=>'CONFIRM.NO.TABSET.SELECTED'
,p_message_language=>'it'
,p_message_text=>unistr('Non \00E8 stato selezionato alcun set di schede per questa pagina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278006697171867882)
,p_name=>'CONFIRM.NO_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Nessun modello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277855826375867787)
,p_name=>'CONFIRM.OUTPUT_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Elementi di output'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278007962724867883)
,p_name=>'CONFIRM.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278004957200867881)
,p_name=>'CONFIRM.PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278018535655867890)
,p_name=>'CONFIRM.PAGES'
,p_message_language=>'it'
,p_message_text=>'Pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278005020072867881)
,p_name=>'CONFIRM.PAGE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278005922695867882)
,p_name=>'CONFIRM.PAGE_TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278014400129867887)
,p_name=>'CONFIRM.PARENT_DISPLAY_COLS'
,p_message_language=>'it'
,p_message_text=>'Colonne di visualizzazione padre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278012539343867886)
,p_name=>'CONFIRM.PARENT_MENU'
,p_message_language=>'it'
,p_message_text=>'Indicatore di percorso padre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278016063831867888)
,p_name=>'CONFIRM.PARENT_MENU_COL'
,p_message_language=>'it'
,p_message_text=>'Colonna indicatore di percorso padre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278014669675867887)
,p_name=>'CONFIRM.PARENT_ORDER_BY'
,p_message_language=>'it'
,p_message_text=>'Ordina per tabella padre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278013910437867887)
,p_name=>'CONFIRM.PARENT_PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina padre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278014259649867887)
,p_name=>'CONFIRM.PARENT_TABLE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome tabella padre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278006546550867882)
,p_name=>'CONFIRM.PARENT_TAB_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta scheda padre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278006480204867882)
,p_name=>'CONFIRM.PARENT_TAB_SET'
,p_message_language=>'it'
,p_message_text=>'Set di schede padre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278109338888867947)
,p_name=>'CONFIRM.PARSING_SCHEMA'
,p_message_language=>'it'
,p_message_text=>'Schema di analisi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278118303971867952)
,p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR'
,p_message_language=>'it'
,p_message_text=>'Aggiornamento pagina parziale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278484565806868184)
,p_name=>'CONFIRM.PREVIOUS_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta pulsante Precedente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278005896842867882)
,p_name=>'CONFIRM.PRIMARY_KEY'
,p_message_language=>'it'
,p_message_text=>'Colonna %0 chiave primaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278013545947867886)
,p_name=>'CONFIRM.PRIMARY_KEY_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna chiave primaria'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278204784351868007)
,p_name=>'CONFIRM.PRINT_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formato output'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278209179140868010)
,p_name=>'CONFIRM.PRINT_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta collegamento di stampa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278204899480868007)
,p_name=>'CONFIRM.PRINT_OUTPUT'
,p_message_language=>'it'
,p_message_text=>'Stampa report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278007872788867883)
,p_name=>'CONFIRM.PROCESS_OPTIONS'
,p_message_language=>'it'
,p_message_text=>'Opzioni dei processi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278204592809868007)
,p_name=>'CONFIRM.REGION_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278006805847867882)
,p_name=>'CONFIRM.REGION_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278005103439867881)
,p_name=>'CONFIRM.REGION_TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278011934056867885)
,p_name=>'CONFIRM.REGION_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278109502071867947)
,p_name=>'CONFIRM.REMOVED_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne rimosse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278013697452867886)
,p_name=>'CONFIRM.REPORT_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278226970405868021)
,p_name=>'CONFIRM.REPORT_IMPLEMENTATION'
,p_message_language=>'it'
,p_message_text=>'Implementazione report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278012736217867886)
,p_name=>'CONFIRM.REPORT_PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina di report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278012836574867886)
,p_name=>'CONFIRM.REPORT_PAGE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome pagina di report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278013087752867886)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta scheda pagina di report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278012975255867886)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_SET'
,p_message_language=>'it'
,p_message_text=>'Set di schede pagina di report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277899946483867815)
,p_name=>'CONFIRM.REPORT_REGION_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello area report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277899830166867815)
,p_name=>'CONFIRM.REPORT_REGION_TITLE'
,p_message_language=>'it'
,p_message_text=>'Titolo area report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278016977807867889)
,p_name=>'CONFIRM.REPORT_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277902480465867816)
,p_name=>'CONFIRM.ROW_VERSION_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna versione di riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278017129946867889)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME1'
,p_message_language=>'it'
,p_message_text=>'predefinito: HTML (standard)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278017486435867889)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME11'
,p_message_language=>'it'
,p_message_text=>'predefinito: aspetto 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278017558212867889)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME12'
,p_message_language=>'it'
,p_message_text=>'predefinito: aspetto 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278109169091867947)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME13'
,p_message_language=>'it'
,p_message_text=>'predefinito: aspetto 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278109255775867947)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME14'
,p_message_language=>'it'
,p_message_text=>'predefinito: aspetto 4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277900498531867815)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME15'
,p_message_language=>'it'
,p_message_text=>'predefinito: aspetto 5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278017231012867889)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME2'
,p_message_language=>'it'
,p_message_text=>'predefinito: report verticale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278017605290867889)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME21'
,p_message_language=>'it'
,p_message_text=>'esportazione: CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278017731301867889)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME22'
,p_message_language=>'it'
,p_message_text=>'esportazione: XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278017359271867889)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME3'
,p_message_language=>'it'
,p_message_text=>'predefinito: report verticale, aspetto 1 (includere le colonne NULL)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278108957556867946)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME4'
,p_message_language=>'it'
,p_message_text=>'predefinito: report verticale, aspetto 2 (escludere le colonne NULL)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278109031801867947)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME5'
,p_message_language=>'it'
,p_message_text=>'predefinito: report verticale, aspetto 2 (includere le colonne NULL)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278427869999868148)
,p_name=>'CONFIRM.RULE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome regola'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278428098609868148)
,p_name=>'CONFIRM.RULE_SEQUENCE'
,p_message_language=>'it'
,p_message_text=>'Sequenza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278428173652868148)
,p_name=>'CONFIRM.RULE_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di regola'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277829634078867770)
,p_name=>'CONFIRM.RUN_SCRIPT'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di eseguire lo script riportato di seguito. Confermare la richiesta.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278012241089867886)
,p_name=>'CONFIRM.SEQUENCE'
,p_message_language=>'it'
,p_message_text=>'Sequenza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278017094839867889)
,p_name=>'CONFIRM.SORT_OPTION'
,p_message_language=>'it'
,p_message_text=>'Opzione di ordinamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278008102503867883)
,p_name=>'CONFIRM.SQL_QUERY'
,p_message_language=>'it'
,p_message_text=>'Query SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278118265486867952)
,p_name=>'CONFIRM.STANDARD_CALENDAR'
,p_message_language=>'it'
,p_message_text=>'Standard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278246418744868033)
,p_name=>'CONFIRM.STARTING_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('Verranno create pi\00F9 pagine, iniziando dalla pagina:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278008082459867883)
,p_name=>'CONFIRM.STORED_PROCEDURE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome stored procedure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278110999314867948)
,p_name=>'CONFIRM.STORED_PROCEDURE_OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario stored procedure'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278484791805868184)
,p_name=>'CONFIRM.SUBMIT_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta pulsante Fine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279101983782868576)
,p_name=>'CONFIRM.SUBSCRIBE_THEME'
,p_message_language=>'it'
,p_message_text=>'Sottoscrivi tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278007321880867883)
,p_name=>'CONFIRM.SUGGESTED_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome consigliato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278292953244868063)
,p_name=>'CONFIRM.TABLE'
,p_message_language=>'it'
,p_message_text=>'Tabella/vista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278293000115868063)
,p_name=>'CONFIRM.TABLE_COLS'
,p_message_language=>'it'
,p_message_text=>'Colonna Riepiloga per'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278511978796868201)
,p_name=>'CONFIRM.TABLE_LOOKUPS'
,p_message_language=>'it'
,p_message_text=>'Ricerche tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278005584176867881)
,p_name=>'CONFIRM.TABLE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278005481432867881)
,p_name=>'CONFIRM.TABLE_OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278684019779868310)
,p_name=>'CONFIRM.TABLE_RULE'
,p_message_language=>'it'
,p_message_text=>'Regola di trasformazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278428276595868148)
,p_name=>'CONFIRM.TABLE_RULES'
,p_message_language=>'it'
,p_message_text=>'Regole di trasformazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278109801082867947)
,p_name=>'CONFIRM.TABLE_VIEW_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome tabella/vista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278109719105867947)
,p_name=>'CONFIRM.TABLE_VIEW_OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario tabella/vista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278018621000867890)
,p_name=>'CONFIRM.TABS'
,p_message_language=>'it'
,p_message_text=>'Schede'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278006382234867882)
,p_name=>'CONFIRM.TABSET.INCOMPLETE'
,p_message_language=>'it'
,p_message_text=>'Avvertenza: informazioni sul set di schede incomplete.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278005302831867881)
,p_name=>'CONFIRM.TAB_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta scheda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278016714176867888)
,p_name=>'CONFIRM.TAB_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome scheda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278005294761867881)
,p_name=>'CONFIRM.TAB_SET'
,p_message_language=>'it'
,p_message_text=>'Set di schede'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278017820748867889)
,p_name=>'CONFIRM.TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'modello:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278011537571867885)
,p_name=>'CONFIRM.TREE_LOV'
,p_message_language=>'it'
,p_message_text=>'Basato su un nuovo elemento della lista di valori popup'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278011206364867885)
,p_name=>'CONFIRM.TREE_MAX_LEVEL'
,p_message_language=>'it'
,p_message_text=>'Numero massimo livelli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278011007844867885)
,p_name=>'CONFIRM.TREE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome struttura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278011484221867885)
,p_name=>'CONFIRM.TREE_QUERY'
,p_message_language=>'it'
,p_message_text=>'Query struttura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278011679399867885)
,p_name=>'CONFIRM.TREE_SQL'
,p_message_language=>'it'
,p_message_text=>'Basato su una query SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278011356951867885)
,p_name=>'CONFIRM.TREE_START'
,p_message_language=>'it'
,p_message_text=>'Struttura iniziale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278011704662867885)
,p_name=>'CONFIRM.TREE_STATIC'
,p_message_language=>'it'
,p_message_text=>'Valore statico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278011140542867885)
,p_name=>'CONFIRM.TREE_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di struttura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278018883029867890)
,p_name=>'CONFIRM.UI_THEME'
,p_message_language=>'it'
,p_message_text=>'Tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278018966793867890)
,p_name=>'CONFIRM.UI_THEME1'
,p_message_language=>'it'
,p_message_text=>'Blu e marrone chiaro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278019072196867890)
,p_name=>'CONFIRM.UI_THEME2'
,p_message_language=>'it'
,p_message_text=>'Rosso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278019186878867890)
,p_name=>'CONFIRM.UI_THEME4'
,p_message_language=>'it'
,p_message_text=>'Blu scuro e grigio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278019291421867890)
,p_name=>'CONFIRM.UI_THEME5'
,p_message_language=>'it'
,p_message_text=>'Verde oliva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278019381402867890)
,p_name=>'CONFIRM.UI_THEME6'
,p_message_language=>'it'
,p_message_text=>'Bordeaux'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278019420508867890)
,p_name=>'CONFIRM.UI_THEME7'
,p_message_language=>'it'
,p_message_text=>'Azzurro e marrone chiaro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278019592801867890)
,p_name=>'CONFIRM.UI_THEME8'
,p_message_language=>'it'
,p_message_text=>'Blu'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278019672384867890)
,p_name=>'CONFIRM.UI_THEME_NONE'
,p_message_language=>'it'
,p_message_text=>'Nessuno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278005701711867882)
,p_name=>'CONFIRM.UPDATEABLE_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne aggiornabili'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278009568879867884)
,p_name=>'CONFIRM.UPDATE_PROCESS'
,p_message_language=>'it'
,p_message_text=>'Aggiorna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278006280515867882)
,p_name=>'CONFIRM.USE.EXISTING.TABSET'
,p_message_language=>'it'
,p_message_text=>unistr('Questa pagina utilizzer\00E0 il set di schede "%0" esistente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277855653009867787)
,p_name=>'CONFIRM.WEB_SERVICE_REF'
,p_message_language=>'it'
,p_message_text=>'Riferimento a Web Service, operazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278013793018867887)
,p_name=>'CONFIRM.WHERE_CLAUSE'
,p_message_language=>'it'
,p_message_text=>'Clausola Where'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278282375958868056)
,p_name=>'CONFIRMATION_ICON'
,p_message_language=>'it'
,p_message_text=>'Icona di conferma'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278294418365868064)
,p_name=>'CONFIRMED'
,p_message_language=>'it'
,p_message_text=>'Confermato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278294764683868064)
,p_name=>'CONFIRMED_BY_QA'
,p_message_language=>'it'
,p_message_text=>'Confermato da QA'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278205001520868007)
,p_name=>'CONFIRM_BREAK_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonne di interruzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278204965147868007)
,p_name=>'CONFIRM_PRINT_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formato di stampa'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278323259105868082)
,p_name=>'CONTENT_DISPOSITION'
,p_message_language=>'it'
,p_message_text=>'Disposizione contenuto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278358400658868104)
,p_name=>'CONTENT_SERVED_IN_KBYTES'
,p_message_language=>'it'
,p_message_text=>'Contenuto servito'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278195957383868002)
,p_name=>'CONTINUE'
,p_message_language=>'it'
,p_message_text=>'Continua'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279235597260868662)
,p_name=>'CONTRIBUTORS'
,p_message_language=>'it'
,p_message_text=>'Collaboratori'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279128136548868593)
,p_name=>'COPY.PAGE.NEW_STATIC_ID'
,p_message_language=>'it'
,p_message_text=>'Nuovo ID statico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277892326899867810)
,p_name=>'COPYRIGHT'
,p_message_language=>'it'
,p_message_text=>unistr('Copyright \00A9 %0. Tutti i diritti riservati.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277950792599867847)
,p_name=>'COPY_APP_SUCCESS_MSG'
,p_message_language=>'it'
,p_message_text=>unistr('L''applicazione \00E8 stata copiata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278086340592867932)
,p_name=>'COPY_BUTTON.EXECUTION_ERR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''esecuzione di copy_button: %0 >> %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278125229999867957)
,p_name=>'COPY_DEPLOYMENT'
,p_message_language=>'it'
,p_message_text=>'Copia attributi di definizione degli oggetti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277924051039867830)
,p_name=>'COPY_EXISTING_APP'
,p_message_language=>'it'
,p_message_text=>'Copia applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278382315330868119)
,p_name=>'COPY_FEATURE'
,p_message_language=>'it'
,p_message_text=>'Copia funzione: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278124851338867956)
,p_name=>'COPY_FROM_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Copia da applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278559064030868231)
,p_name=>'COPY_FROM_APP_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Basato su modello applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278124914598867956)
,p_name=>'COPY_FROM_NAME'
,p_message_language=>'it'
,p_message_text=>'Copia da nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277952970217867848)
,p_name=>'COPY_LIST_ENTRY'
,p_message_language=>'it'
,p_message_text=>'Copia voce di lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278086723371867932)
,p_name=>'COPY_NAMED_LOV.EXECUTION_ERR'
,p_message_language=>'it'
,p_message_text=>'Errore durante l''esecuzione di copy_named_lov: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278086692237867932)
,p_name=>'COPY_NAMED_LOV.NOT_FOUND_ERR'
,p_message_language=>'it'
,p_message_text=>'ID lista di valori "%0" non trovato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278086598797867932)
,p_name=>'COPY_NAMED_LOV.NUMERIC_ERR'
,p_message_language=>'it'
,p_message_text=>unistr('L''ID della lista di valori "%0" non \00E8 numerico.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278363382623868107)
,p_name=>'COPY_PAGE.COPY_FROM_PAGE'
,p_message_language=>'it'
,p_message_text=>'Copia da pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278363438045868107)
,p_name=>'COPY_PAGE.COPY_TO_PAGE'
,p_message_language=>'it'
,p_message_text=>'Copia a pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278362332072868107)
,p_name=>'COPY_PAGE.SELECT_AUTHORIZATION'
,p_message_language=>'it'
,p_message_text=>'- Seleziona autorizzazione-'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278362217554868107)
,p_name=>'COPY_PAGE.SELECT_LIST'
,p_message_language=>'it'
,p_message_text=>'- Seleziona lista -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278362114923868106)
,p_name=>'COPY_PAGE.SELECT_NAMED_LOV'
,p_message_language=>'it'
,p_message_text=>'- Seleziona lista di valori -'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278434277528868152)
,p_name=>'COPY_TABLE'
,p_message_language=>'it'
,p_message_text=>'Copia %0 nella tabella %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278125017505867957)
,p_name=>'COPY_TO_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Copia in applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278125117181867957)
,p_name=>'COPY_TO_NAME'
,p_message_language=>'it'
,p_message_text=>'Copia a nome'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278050555443867910)
,p_name=>'CORE'
,p_message_language=>'it'
,p_message_text=>'memoria'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278217466650868015)
,p_name=>'COUNT'
,p_message_language=>'it'
,p_message_text=>'Conteggio'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278275224970868052)
,p_name=>'CREATE'
,p_message_language=>'it'
,p_message_text=>'Crea'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278521425924868207)
,p_name=>'CREATE APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Crea applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278521595390868207)
,p_name=>'CREATE OBJECT'
,p_message_language=>'it'
,p_message_text=>'Crea oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278731180465868340)
,p_name=>'CREATED'
,p_message_language=>'it'
,p_message_text=>'Data creazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278731287110868340)
,p_name=>'CREATED_BY'
,p_message_language=>'it'
,p_message_text=>'Creazione di'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278382001710868119)
,p_name=>'CREATED_LAST_7_DAYS'
,p_message_language=>'it'
,p_message_text=>'Creati negli ultimi 7 giorni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278087427306867933)
,p_name=>'CREATED_ON'
,p_message_language=>'it'
,p_message_text=>'Data creazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277924171601867830)
,p_name=>'CREATE_APP_FROM_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Da un modello applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279025309335868527)
,p_name=>'CREATE_APP_WIZ.CANDLE_CHARTS'
,p_message_language=>'it'
,p_message_text=>'Grafici a canne d''organo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279025171224868527)
,p_name=>'CREATE_APP_WIZ.COL_CHARTS'
,p_message_language=>'it'
,p_message_text=>'Grafici 2D e 3D a colonne, a barre e in pila'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279025860925868528)
,p_name=>'CREATE_APP_WIZ.GAUGE_CHARTS'
,p_message_language=>'it'
,p_message_text=>'Grafici a quadrante e quadrante (percentuale)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279025242244868527)
,p_name=>'CREATE_APP_WIZ.PIE_CHARTS'
,p_message_language=>'it'
,p_message_text=>'Grafici 2D e 3D a torta e anello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279025556645868527)
,p_name=>'CREATE_APP_WIZ.PROJECTGANTT_CHARTS'
,p_message_language=>'it'
,p_message_text=>'Grafici Gantt (progetto)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279025799598868527)
,p_name=>'CREATE_APP_WIZ.RANGE_CHARTS'
,p_message_language=>'it'
,p_message_text=>'Grafici 2D e 3D a intervalli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279025632004868527)
,p_name=>'CREATE_APP_WIZ.RESOURCEGANTT_CHARTS'
,p_message_language=>'it'
,p_message_text=>'Grafici Gantt (risorsa)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279025410288868527)
,p_name=>'CREATE_APP_WIZ.SCATTER_CHARTS'
,p_message_language=>'it'
,p_message_text=>'Grafici a indicatore dispersione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278042403904867905)
,p_name=>'CREATE_CONDITION.AND'
,p_message_language=>'it'
,p_message_text=>'AND'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278042249737867904)
,p_name=>'CREATE_CONDITION.ARROW_DOWN'
,p_message_language=>'it'
,p_message_text=>unistr('Freccia in gi\00F9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278042325528867905)
,p_name=>'CREATE_CONDITION.ARROW_RIGHT'
,p_message_language=>'it'
,p_message_text=>'Freccia a destra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278042084733867904)
,p_name=>'CREATE_CONDITION.COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278042182860867904)
,p_name=>'CREATE_CONDITION.CONDITIONS'
,p_message_language=>'it'
,p_message_text=>'Condizioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278042579621867905)
,p_name=>'CREATE_CONDITION.OR'
,p_message_language=>'it'
,p_message_text=>'OR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278042632030867905)
,p_name=>'CREATE_CONDITION.PREVIEW'
,p_message_language=>'it'
,p_message_text=>'Anteprima condizione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278382855982868120)
,p_name=>'CREATE_DEMO_APP.GRANT'
,p_message_language=>'it'
,p_message_text=>'Fare clic sul pulsante Concedi privilegi sottostante per concedere subito questi privilegi a %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278382678965868119)
,p_name=>'CREATE_DEMO_APP.NO_CREATE_PRIV'
,p_message_language=>'it'
,p_message_text=>unistr('%0 non dispone del privilegio CREATE TABLE, CREATE VIEW, CREATE TRIGGER, CREATE SEQUENCE o CREATE PROCEDURE, quindi non potr\00E0 installare l''applicazione demo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278382709819868120)
,p_name=>'CREATE_DEMO_APP.NO_EXEC_PRIV'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('%0 non dispone del privilegio di esecuzione su CTX_DOC e CTX_DDL, quindi non potr\00E0 installare la demo Discorso di insediamento del presidente. Concedere i seguenti privilegi come utente privilegiato: '),
'<pre>',
'GRANT EXECUTE ON CTXSYS.CTX_DDL TO %0; ',
'GRANT EXECUTE ON CTXSYS.CTX_DOC TO %0;',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278729299339868339)
,p_name=>'CREATE_DIALOG_CLOSED_DA'
,p_message_language=>'it'
,p_message_text=>'Crea pulsante - Finestra di dialogo chiusa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277826579178867768)
,p_name=>'CREATE_DYNAMIC_LIST'
,p_message_language=>'it'
,p_message_text=>'Crea lista dinamica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278110677583867948)
,p_name=>'CREATE_DYNAMIC_LOV'
,p_message_language=>'it'
,p_message_text=>'Crea lista di valori dinamica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277804534190867755)
,p_name=>'CREATE_FLOW.CLOUD_IDM'
,p_message_language=>'it'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277844019318867779)
,p_name=>'CREATE_FLOW.DBACCOUNT'
,p_message_language=>'it'
,p_message_text=>'Account di database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278547643122868224)
,p_name=>'CREATE_FLOW.HTMLDB_AUTH'
,p_message_language=>'it'
,p_message_text=>'Autenticazione Application Express'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278383258095868120)
,p_name=>'CREATE_FLOW.LDAP'
,p_message_language=>'it'
,p_message_text=>'LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279086547396868566)
,p_name=>'CREATE_FLOW.NAVIGATION_LIST'
,p_message_language=>'it'
,p_message_text=>'Lista menu di navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278547748851868224)
,p_name=>'CREATE_FLOW.NO_AUTH'
,p_message_language=>'it'
,p_message_text=>'Nessuna autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278547342398868224)
,p_name=>'CREATE_FLOW.NO_TABS'
,p_message_language=>'it'
,p_message_text=>'Nessuna scheda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278547491560868224)
,p_name=>'CREATE_FLOW.ONE_LEVEL_TABS'
,p_message_language=>'it'
,p_message_text=>'Un livello di schede'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278383345543868120)
,p_name=>'CREATE_FLOW.SSO'
,p_message_language=>'it'
,p_message_text=>'Single Sign On (SSO)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278547581815868224)
,p_name=>'CREATE_FLOW.TWO_LEVEL_TABS'
,p_message_language=>'it'
,p_message_text=>'Due livelli di schede'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277923983064867830)
,p_name=>'CREATE_FROM_SPREADSHEET'
,p_message_language=>'it'
,p_message_text=>'Da un foglio di calcolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277800927935867752)
,p_name=>'CREATE_GLOBAL_PAGE'
,p_message_language=>'it'
,p_message_text=>unistr('I componenti della pagina globale vengono visualizzati su tutte le pagine se il punto di visualizzazione della relativa area si trova all''interno del modello di pagina selezionato. Per eliminare la visualizzazione \00E8 possibile usare gli attributi di v')
||'isualizzazione condizionale.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278075662506867925)
,p_name=>'CREATE_INDEX'
,p_message_language=>'it'
,p_message_text=>'Crea indice'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278231229713868024)
,p_name=>'CREATE_ITEM_WIZ.NO_REGION'
,p_message_language=>'it'
,p_message_text=>'nessun''area associata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278050237418867909)
,p_name=>'CREATE_NEW_LOGIN_PAGE'
,p_message_language=>'it'
,p_message_text=>'Creare una nuova pagina di login.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278044187857867906)
,p_name=>'CREATE_PACKAGE.BACK'
,p_message_language=>'it'
,p_message_text=>'Torna a Creazione guidata tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278043623569867905)
,p_name=>'CREATE_PACKAGE.BROWSE'
,p_message_language=>'it'
,p_message_text=>'Sfoglia package'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278043576838867905)
,p_name=>'CREATE_PACKAGE.CREATED'
,p_message_language=>'it'
,p_message_text=>unistr('Il package "%0" \00E8 stato creato nello schema "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278044252501867906)
,p_name=>'CREATE_PACKAGE.FAILED'
,p_message_language=>'it'
,p_message_text=>'Creazione della tabella "%0" non riuscita.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278044054009867906)
,p_name=>'CREATE_PACKAGE.HOME'
,p_message_language=>'it'
,p_message_text=>'Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278043813515867906)
,p_name=>'CREATE_PACKAGE.RETURN_TO'
,p_message_language=>'it'
,p_message_text=>'Torna a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278043992950867906)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP'
,p_message_language=>'it'
,p_message_text=>'SQL&nbsp;Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278043780682867905)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME'
,p_message_language=>'it'
,p_message_text=>'Home di SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278039451661867903)
,p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND'
,p_message_language=>'it'
,p_message_text=>'Nessun elemento trovato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278039066249867903)
,p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Elementi pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278039322148867903)
,p_name=>'CREATE_PAGE_ITEM.PROMPT'
,p_message_language=>'it'
,p_message_text=>'Prompt'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278039131396867903)
,p_name=>'CREATE_PAGE_ITEM.REGION'
,p_message_language=>'it'
,p_message_text=>'Area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278039283888867903)
,p_name=>'CREATE_PAGE_ITEM.SET_REGION'
,p_message_language=>'it'
,p_message_text=>'fare clic per impostare l''area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278037153025867901)
,p_name=>'CREATE_PROCESS.PAGE_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Elementi pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278037298653867901)
,p_name=>'CREATE_PROCESS.REGION'
,p_message_language=>'it'
,p_message_text=>'Area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278043426282867905)
,p_name=>'CREATE_TABLE.HOME'
,p_message_language=>'it'
,p_message_text=>'Home'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278043209115867905)
,p_name=>'CREATE_TABLE.RETURN_TO'
,p_message_language=>'it'
,p_message_text=>'Torna a'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278043101723867905)
,p_name=>'CREATE_TABLE.RUN_SCRIPT'
,p_message_language=>'it'
,p_message_text=>'Esegui script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278042862069867905)
,p_name=>'CREATE_TABLE.SCRIPT_CREATED'
,p_message_language=>'it'
,p_message_text=>unistr('Lo script di creazione per la tabella %0 \00E8 stato creato nel repository script SQL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278042943031867905)
,p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY'
,p_message_language=>'it'
,p_message_text=>'Vai a repository script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278043385936867905)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP'
,p_message_language=>'it'
,p_message_text=>'SQL&nbsp;Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278043046497867905)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME'
,p_message_language=>'it'
,p_message_text=>'Home di SQL Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278500239630868194)
,p_name=>'CREATE_TABULAR_FORM'
,p_message_language=>'it'
,p_message_text=>'Form tabulare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279105808066868579)
,p_name=>'CREATE_TO_DO'
,p_message_language=>'it'
,p_message_text=>unistr('Crea attivit\00E0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278435070121868153)
,p_name=>'CREATE_TRIGGER'
,p_message_language=>'it'
,p_message_text=>'Crea trigger %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278373207996868114)
,p_name=>'CREATE_WS_OBJ_SUCCESS_MSG'
,p_message_language=>'it'
,p_message_text=>'Oggetti database Websheet.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278325445177868083)
,p_name=>'CREDENTIAL.OWNER'
,p_message_language=>'it'
,p_message_text=>'Proprietario credenziale'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278287862768868059)
,p_name=>'CSS_CALENDAR'
,p_message_language=>'it'
,p_message_text=>'Calendario'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278200762492868005)
,p_name=>'CURRENT'
,p_message_language=>'it'
,p_message_text=>'Corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278279698011868054)
,p_name=>'CURRENT ENTRY'
,p_message_language=>'it'
,p_message_text=>'Voce corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278279364298868054)
,p_name=>'CURRENT FORM ELEMENT'
,p_message_language=>'it'
,p_message_text=>'Elemento form corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278063598786867918)
,p_name=>'CURRENT ITEM HELP TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo Guida dell''elemento corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278279446910868054)
,p_name=>'CURRENT ITEM IDENTIFICATION NUMBER'
,p_message_language=>'it'
,p_message_text=>'Numero di identificazione elemento corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278279547890868054)
,p_name=>'CURRENT ITEM LABEL NAME'
,p_message_language=>'it'
,p_message_text=>'Nome etichetta elemento corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278338531810868092)
,p_name=>'CURRENT TAB'
,p_message_language=>'it'
,p_message_text=>'Scheda corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278025321832867894)
,p_name=>'CURRENT_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Applicazione corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278032374949867898)
,p_name=>'CURRENT_IMAGE'
,p_message_language=>'it'
,p_message_text=>'Immagine corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278639029386868282)
,p_name=>'CURRENT_ITEM_CONTAINER_ID'
,p_message_language=>'it'
,p_message_text=>unistr('ID che pu\00F2 essere usato su un elemento contenitore che manda a capo il campo corrente nell''attributo Prima di etichetta ed elemento.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279114357720868584)
,p_name=>'CURRENT_ITEM_HELP_LABEL'
,p_message_language=>'it'
,p_message_text=>'Etichetta Guida dell''elemento corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277991122699867872)
,p_name=>'CURRENT_MILESTONE'
,p_message_language=>'it'
,p_message_text=>'Milestone corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278031481915867898)
,p_name=>'CURRENT_PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina corrente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278306121172868071)
,p_name=>'CURRENT_PAGE_CONTAINS_NO_ITEMS'
,p_message_language=>'it'
,p_message_text=>'La pagina corrente non contiene elementi.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278196564645868002)
,p_name=>'CUSTOM'
,p_message_language=>'it'
,p_message_text=>'Personalizzato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278239220728868029)
,p_name=>'CUSTOMIZE'
,p_message_language=>'it'
,p_message_text=>'Personalizza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278275102775868051)
,p_name=>'CUSTOMIZE LINK'
,p_message_language=>'it'
,p_message_text=>'Personalizza collegamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278284752060868057)
,p_name=>'CUSTOMIZE.USER_PAGE_PREFS_RESET'
,p_message_language=>'it'
,p_message_text=>'Preferenze di pagina reimpostate per l''utente %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278284829653868057)
,p_name=>'CUSTOMIZE.USER_PREFS_CHANGED'
,p_message_language=>'it'
,p_message_text=>'Preferenze modificate per l''utente %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278284608758868057)
,p_name=>'CUSTOMIZE.USER_PREFS_RESET'
,p_message_language=>'it'
,p_message_text=>'Preferenze di pagina reimpostate per l''utente %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278989016528868503)
,p_name=>'CUSTOM_APPLICATIONS'
,p_message_language=>'it'
,p_message_text=>'Applicazioni personalizzate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277825477388867768)
,p_name=>'CUSTOM_AUTH_SCHEME_DESC'
,p_message_language=>'it'
,p_message_text=>'Sviluppatore definito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278079809106867928)
,p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR'
,p_message_language=>'it'
,p_message_text=>'Errore in %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277991305374867872)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1'
,p_message_language=>'it'
,p_message_text=>'Immettere una stringa da utilizzare come identificativo utente per questa sessione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277991418652867873)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2'
,p_message_language=>'it'
,p_message_text=>'Immettere nome utente e password %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277991578704867873)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3'
,p_message_language=>'it'
,p_message_text=>'Immettere nome utente e password per la verifica da parte dell''host LDAP: %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277991654585867873)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4'
,p_message_language=>'it'
,p_message_text=>'Immettere nome utente e password dello schema di database.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278758187523868357)
,p_name=>'CUSTOM_CALENDAR'
,p_message_language=>'it'
,p_message_text=>'Ricarica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278763262726868360)
,p_name=>'CUSTOM_CALENDAR.END_DATE'
,p_message_language=>'it'
,p_message_text=>'Data di fine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278763126467868360)
,p_name=>'CUSTOM_CALENDAR.START_DATE'
,p_message_language=>'it'
,p_message_text=>'Data di inizio'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278435957214868153)
,p_name=>'DA.SET_VALUE.SQL.HELP_MSG'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Se l''azione True \00E8 un valore impostato di tipo Istruzione SQL, \00E8 necessario definire gli elementi interessati nello stesso ordine della colonna dell''istruzione SQL. L''istruzione SQL definita \00E8 la seguente:</p>'),
'<pre>%0</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277996724544867876)
,p_name=>'DAILY'
,p_message_language=>'it'
,p_message_text=>'Giornaliero'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278213929091868013)
,p_name=>'DATA'
,p_message_language=>'it'
,p_message_text=>'Dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278521073868868207)
,p_name=>'DATA WORKSHOP'
,p_message_language=>'it'
,p_message_text=>'Data Workshop'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278091439350867935)
,p_name=>'DATA.LOAD.ALL_COL_MAPPED'
,p_message_language=>'it'
,p_message_text=>'Tutte le colonne %0 sono state mappate automaticamente alla tabella %1.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278092200415867936)
,p_name=>'DATA.LOAD.APPEND_INCOMPLETE'
,p_message_language=>'it'
,p_message_text=>'Ai dati nella tabella <code>%0</code> sono state aggiunte <b id="incompl_success_row_count"></b> righe nuove.<b class="u-danger-text" id="incompl_fail_row_count"></b> righe rifiutate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278091875260867936)
,p_name=>'DATA.LOAD.APPEND_SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Ai dati nella tabella <code>%0</code> sono state aggiunte <b id="success_row_count"></b> righe nuove.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278092077217867936)
,p_name=>'DATA.LOAD.APPEND_WARNING'
,p_message_language=>'it'
,p_message_text=>'Ai dati nella tabella <code>%0</code> sono state aggiunte <b id="err_success_row_count"></b> righe nuove. <b class="u-danger-text" id="err_fail_row_count"></b> righe rifiutate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277801407253867753)
,p_name=>'DATA.LOAD.CHOOSE_FILE'
,p_message_language=>'it'
,p_message_text=>'Scegli file'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277839092082867776)
,p_name=>'DATA.LOAD.CONFIGURATION_SAVED'
,p_message_language=>'it'
,p_message_text=>'Configurazione salvata.'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278091557707867935)
,p_name=>'DATA.LOAD.DEFINE_COL_MAPPING'
,p_message_language=>'it'
,p_message_text=>'Definire il mapping delle colonne per caricare i dati nella tabella %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277801399120867753)
,p_name=>'DATA.LOAD.DRAG_DROP_FILE_HERE'
,p_message_language=>'it'
,p_message_text=>'Trascinare i file qui oppure'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277801271308867753)
,p_name=>'DATA.LOAD.FILE_FORMATS'
,p_message_language=>'it'
,p_message_text=>'Formati supportati: csv, xlsx, txt, xml, json'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277802324711867753)
,p_name=>'DATA.LOAD.INVALID_FILE'
,p_message_language=>'it'
,p_message_text=>unistr('Il file caricato non \00E8 valido oppure l''estensione \00E8 errata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277970675241867859)
,p_name=>'DATA.LOAD.INVALID_SELECTOR'
,p_message_language=>'it'
,p_message_text=>'Utilizzato selettore XML o JSON non valido.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278518993842868206)
,p_name=>'DATA.LOAD.JOB_INTERMITTENTLY_FAILED'
,p_message_language=>'it'
,p_message_text=>'Esecuzione del job di caricamento dati arrestato in modo imprevisto.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278443110555868158)
,p_name=>'DATA.LOAD.JOB_NAME'
,p_message_language=>'it'
,p_message_text=>'Job di caricamento dati nell''area di lavoro %0: caricamento nella tabella %1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278091609903867935)
,p_name=>'DATA.LOAD.MAP_REMAINING_COLS'
,p_message_language=>'it'
,p_message_text=>'%0 su %1 colonne sono state mappate automaticamente alla tabella %2. Configurare le restanti %3 colonne.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278436715413868154)
,p_name=>'DATA.LOAD.NO_FILE_CONTENTS'
,p_message_language=>'it'
,p_message_text=>'Nessun dato trovato nel file caricato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278436886128868154)
,p_name=>'DATA.LOAD.NO_WORKSHEET_CONTENTS'
,p_message_language=>'it'
,p_message_text=>'Nessun dato trovato nel foglio di lavoro "%0".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277801787991867753)
,p_name=>'DATA.LOAD.NO_XLSX_FILE'
,p_message_language=>'it'
,p_message_text=>unistr('Il file specificato non \00E8 un file XLSX.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278483544512868183)
,p_name=>'DATA.LOAD.PASTED_DATA'
,p_message_language=>'it'
,p_message_text=>'Dati incollati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278092370872867936)
,p_name=>'DATA.LOAD.REPLACE_INCOMPLETE'
,p_message_language=>'it'
,p_message_text=>'I dati nella tabella <code>%0</code> sono stati sostituiti con <b id="incompl_success_row_count"></b> righe nuove.<b class="u-danger-text" id="incompl_fail_row_count"></b> righe rifiutate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278091992482867936)
,p_name=>'DATA.LOAD.REPLACE_SUCCESS'
,p_message_language=>'it'
,p_message_text=>'I dati nella tabella <code>%0</code> sono stati sostituiti con <b id="success_row_count"></b> righe nuove.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278092176183867936)
,p_name=>'DATA.LOAD.REPLACE_WARNING'
,p_message_language=>'it'
,p_message_text=>'I dati nella tabella <code>%0</code> sono stati sostituiti con <b id="err_success_row_count"></b> righe nuove. <b class="u-danger-text" id="err_fail_row_count"></b> righe rifiutate.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278091758072867935)
,p_name=>'DATA.LOAD.SELECT_COLS'
,p_message_language=>'it'
,p_message_text=>'Selezionare le colonne da caricare.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279098609484868574)
,p_name=>'DATABASE'
,p_message_language=>'it'
,p_message_text=>'Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278521680879868207)
,p_name=>'DATABASE BROWSER'
,p_message_language=>'it'
,p_message_text=>'Database Browser'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279037278395868535)
,p_name=>'DATABASE.DEMO.SAMPLE.APP'
,p_message_language=>'it'
,p_message_text=>'Applicazione di database di esempio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279098762750868574)
,p_name=>'DATABASE_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Applicazione di database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277845787390867780)
,p_name=>'DATABASE_APPLICATIONS'
,p_message_language=>'it'
,p_message_text=>'Applicazioni di database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277873561064867798)
,p_name=>'DATABASE_APPS'
,p_message_language=>'it'
,p_message_text=>'Applicazioni di database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278368145106868110)
,p_name=>'DATABASE_APP_SUCCESS_MSG'
,p_message_language=>'it'
,p_message_text=>'Applicazione <strong>%0</strong> installata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278265082547868045)
,p_name=>'DATABASE_LINK'
,p_message_language=>'it'
,p_message_text=>'Database link'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278317815680868079)
,p_name=>'DATABASE_OBJECT_COUNTS_BY_TYPE'
,p_message_language=>'it'
,p_message_text=>'Conteggi di oggetti di database per tipo di oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278321001645868080)
,p_name=>'DATABASE_ROLE_PRIVILEGES'
,p_message_language=>'it'
,p_message_text=>'Privilegi ruolo database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277868065563867795)
,p_name=>'DATABASE_USERS'
,p_message_language=>'it'
,p_message_text=>'Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278428749798868149)
,p_name=>'DATA_GRID'
,p_message_language=>'it'
,p_message_text=>'Griglia dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279027843193868529)
,p_name=>'DATA_GRIDS'
,p_message_language=>'it'
,p_message_text=>'Griglie dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279028387354868529)
,p_name=>'DATA_GRID_DATA'
,p_message_language=>'it'
,p_message_text=>'Dati griglia dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279018300326868523)
,p_name=>'DATA_LOAD.ADVANCED_SETTINGS_REGION'
,p_message_language=>'it'
,p_message_text=>'Impostazioni avanzate del caricamento dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277954986208867849)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formati data/numero da usare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277955080774867849)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT_HELP'
,p_message_language=>'it'
,p_message_text=>'Scegliere se fornire formati di visualizzazione personalizzati o usare quelli standard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277869499590867795)
,p_name=>'DATA_LOAD.CHARSET'
,p_message_language=>'it'
,p_message_text=>'Set di caratteri file'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278509678139868200)
,p_name=>'DATA_LOAD.COLUMN_NAMES'
,p_message_language=>'it'
,p_message_text=>'Nomi di colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278508165196868199)
,p_name=>'DATA_LOAD.COLUMN_NAMES_MAPPING'
,p_message_language=>'it'
,p_message_text=>'Colonna di destinazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278366213861868109)
,p_name=>'DATA_LOAD.COLUMN_NAME_ALIASES'
,p_message_language=>'it'
,p_message_text=>'Alias nomi colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278722692861868334)
,p_name=>'DATA_LOAD.CONFIRM'
,p_message_language=>'it'
,p_message_text=>'Caricamento ei dati nella tabella riuscito.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278729995352868339)
,p_name=>'DATA_LOAD.COPY_PASTE'
,p_message_language=>'it'
,p_message_text=>'Copia e incolla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278716226443868330)
,p_name=>'DATA_LOAD.COPY_PASTE_TEXTAREA'
,p_message_language=>'it'
,p_message_text=>'Copia e incolla dati delimitati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279058686953868549)
,p_name=>'DATA_LOAD.CURRENCY_ITEM'
,p_message_language=>'it'
,p_message_text=>'Simbolo valuta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279058716633868549)
,p_name=>'DATA_LOAD.CURRENCY_ITEM_HELP'
,p_message_language=>'it'
,p_message_text=>'Se i dati contengono un simbolo di valuta internazionale, immetterlo qui. Ad esempio, se i dati contengono "&euro;1.234,56" o "&yen;1.234,56", immettere "&euro;" o "&yen;". In caso contrario, i dati non verranno caricati correttamente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277874487799867799)
,p_name=>'DATA_LOAD.DATA_LOADING'
,p_message_language=>'it'
,p_message_text=>'Caricamento dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279018427493868523)
,p_name=>'DATA_LOAD.DATE_FORMAT_APP'
,p_message_language=>'it'
,p_message_text=>'Usa formati di visualizzazione standard applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279018538199868523)
,p_name=>'DATA_LOAD.DATE_FORMAT_CUSTOM'
,p_message_language=>'it'
,p_message_text=>'Fornisci formati personalizzati per le colonne caricate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279060270508868550)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_HELP'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Il carattere decimale separa la parte intera dalla parte decimale di un numero.</p>',
unistr('<p> Qualunque carattere pu\00F2 fungere da separatore decimale, purch\00E9 sia a byte singolo e diverso dal separatore delle migliaia. Il carattere pu\00F2 essere uno spazio, ma non un carattere numerico n\00E9 alcuno dei seguenti caratteri:</p>'),
'<ul class="noIndent">',
unistr('<li>segno pi\00F9 (+)</li>'),
'<li>trattino (-)</li> ',
'<li>segno minore di (<)</li>',
'<li>segno maggiore di (>)</li> ',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279059376645868549)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_ITEM'
,p_message_language=>'it'
,p_message_text=>'Carattere decimale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278366458732868109)
,p_name=>'DATA_LOAD.DISPLAY'
,p_message_language=>'it'
,p_message_text=>'Visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278509574016868200)
,p_name=>'DATA_LOAD.DO_NOT_LOAD'
,p_message_language=>'it'
,p_message_text=>'Non caricare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279054204745868546)
,p_name=>'DATA_LOAD.FAILED'
,p_message_language=>'it'
,p_message_text=>'Errore di pre-elaborazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278966743240868489)
,p_name=>'DATA_LOAD.FAILED_COUNT'
,p_message_language=>'it'
,p_message_text=>'Riga/e non riuscite:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279038264704868536)
,p_name=>'DATA_LOAD.FAILED_RECORD'
,p_message_language=>'it'
,p_message_text=>'Record non riusciti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279058276055868548)
,p_name=>'DATA_LOAD.FILE_NAME_ITEM'
,p_message_language=>'it'
,p_message_text=>'Nome del file da caricare'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278508498166868199)
,p_name=>'DATA_LOAD.FIRST_COLUMN_NAMES'
,p_message_language=>'it'
,p_message_text=>'Colonna di origine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278726649178868337)
,p_name=>'DATA_LOAD.FIRST_ROW'
,p_message_language=>'it'
,p_message_text=>'La prima riga contiene nomi di colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279058308335868549)
,p_name=>'DATA_LOAD.FIRST_ROW_HELP'
,p_message_language=>'it'
,p_message_text=>'Selezionare questa casella se i dati contengono nomi di colonne nella prima riga.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278509742160868200)
,p_name=>'DATA_LOAD.FORMAT'
,p_message_language=>'it'
,p_message_text=>'Formato data/numero'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279058543597868549)
,p_name=>'DATA_LOAD.GLOBALIZATION_REGION'
,p_message_language=>'it'
,p_message_text=>'Globalizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279059276890868549)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_HELP'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>Il separatore delle migliaia \00E8 un carattere che separa gruppi di numeri interi, per mostrare ad esempio migliaia e milioni.</p>'),
unistr('<p>Qualsiasi carattere pu\00F2 fungere da separatore delle migliaia, purch\00E9 sia a byte singolo e diverso da qualsiasi altro carattere decimale. Il carattere pu\00F2 essere uno spazio, ma non pu\00F2 essere un carattere numerico n\00E9 alcuno dei seguenti:</p>'),
'<ul class="noIndent">',
unistr('<li>segno pi\00F9 (+)</li>'),
'<li>trattino (-)</li> ',
'<li>segno minore di (<)</li>',
'<li>segno maggiore di (>)</li> ',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279058859685868549)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_ITEM'
,p_message_language=>'it'
,p_message_text=>'Separatore di gruppo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279053985103868546)
,p_name=>'DATA_LOAD.INSERT'
,p_message_language=>'it'
,p_message_text=>'Inserisci riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278966504456868489)
,p_name=>'DATA_LOAD.INSERTED_COUNT'
,p_message_language=>'it'
,p_message_text=>'Riga/e inserite:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279055798622868547)
,p_name=>'DATA_LOAD.IR_MAX_ROW_COUNT'
,p_message_language=>'it'
,p_message_text=>unistr('Questa query restituisce pi\00F9 di #MAX_ROW_COUNT# righe. Filtrare i dati per ottenere risultati completi.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278365125288868108)
,p_name=>'DATA_LOAD.JUSTCHANGED_RECORD'
,p_message_language=>'it'
,p_message_text=>'Record modificati da un altro utente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277981448654867866)
,p_name=>'DATA_LOAD.LABEL_CASE_SENSITIVE'
,p_message_language=>'it'
,p_message_text=>'Con distinzione tra maiuscole e minuscole'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277981337697867866)
,p_name=>'DATA_LOAD.LABEL_UNIQUE_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna univoca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278689708528868314)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'it'
,p_message_text=>'Caricamento dati non riuscito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278689804795868314)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Azione elaborata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278715490232868330)
,p_name=>'DATA_LOAD.LOAD_TO'
,p_message_language=>'it'
,p_message_text=>'Origine importazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279119329457868587)
,p_name=>'DATA_LOAD.LOOKUP_FAILED'
,p_message_language=>'it'
,p_message_text=>'Recupero del valore di ricerca non riuscito.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278735844704868343)
,p_name=>'DATA_LOAD.MAPPING'
,p_message_language=>'it'
,p_message_text=>'Mapping dati/tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278426907078868148)
,p_name=>'DATA_LOAD.MAPPING_PAGE'
,p_message_language=>'it'
,p_message_text=>'Passo 2 - Nome pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279118075266868586)
,p_name=>'DATA_LOAD.NO_PREVIEW'
,p_message_language=>'it'
,p_message_text=>'Nessuna anteprima file disponibile'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279057493671868548)
,p_name=>'DATA_LOAD.OPTIONAL_ENCLOSE_ITEM'
,p_message_language=>'it'
,p_message_text=>'Facoltativamente racchiuso da'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279021739383868525)
,p_name=>'DATA_LOAD.PROGRESS_TITLE'
,p_message_language=>'it'
,p_message_text=>'Avanzamento del caricamento guidato dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278427125831868148)
,p_name=>'DATA_LOAD.RESULTS_PAGE'
,p_message_language=>'it'
,p_message_text=>'Passo 4 - Nome pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278366399654868109)
,p_name=>'DATA_LOAD.RETURN'
,p_message_language=>'it'
,p_message_text=>'Torna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278364604282868108)
,p_name=>'DATA_LOAD.REVIEW_COUNT'
,p_message_language=>'it'
,p_message_text=>'Righe da controllare:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278509808087868200)
,p_name=>'DATA_LOAD.ROW'
,p_message_language=>'it'
,p_message_text=>'Riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278506319100868198)
,p_name=>'DATA_LOAD.RULES_PLSQL_EXPRESSION_EXAMPLES'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'to_char(sysdate);',
'',
'my_func(p_1  => :SAL,',
'        p_2  => :COMM)',
'',
'dove SAL e COMM sono i nomi delle colonne dei dati caricati',
unistr('e my_func \00E8 la funzione che restituisce il valore che sar\00E0 il nuovo valore'),
'della colonna per la quale viene definita questa regola di trasformazione.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278506580036868198)
,p_name=>'DATA_LOAD.RULES_PLSQL_FUNCTION_EXAMPLES'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'declare',
'    l_result number;',
'begin',
'    l_result := :SAL * :COMM;',
'    return l_result;',
'end;',
'',
unistr('Il risultato restituito sar\00E0 il nuovo valore della colonna per la quale viene definita questa regola di trasformazione.'),
'',
':SAL e :COMM fanno riferimento ai nomi delle colonne SAL e COMM dei dati caricati..',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278506414287868198)
,p_name=>'DATA_LOAD.RULES_SQL_QUERY_EXAMPLES'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'select depno',
' from dept',
'where dname = :DEPTNAME',
'  and loc   = :LOC',
'',
'dove :DEPNAME e :LOC fanno riferimento ai nomi delle colonne DEPNAME e LOC dei dati caricati.',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279057289848868548)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_HELP'
,p_message_language=>'it'
,p_message_text=>'Identificare un carattere separatore di colonne. Utilizzare <code>\t</code> per la separazione con tabulazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279057386253868548)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_LABEL'
,p_message_language=>'it'
,p_message_text=>'Separatore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278366537730868109)
,p_name=>'DATA_LOAD.SEQUENCE'
,p_message_language=>'it'
,p_message_text=>'Sequenza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279111088936868582)
,p_name=>'DATA_LOAD.SEQUENCE_ACTION'
,p_message_language=>'it'
,p_message_text=>'Sequenza: azione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279018193911868522)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Usa impostazioni avanzate'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279018286377868523)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS_HELP'
,p_message_language=>'it'
,p_message_text=>'Visualizzare le impostazioni avanzate per il caricamento dati: Simbolo valuta, Caratteri decimali, Codifica file o Formati data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278735238883868342)
,p_name=>'DATA_LOAD.SOURCE'
,p_message_language=>'it'
,p_message_text=>'Origine caricamento dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278426846901868148)
,p_name=>'DATA_LOAD.SOURCE_PAGE'
,p_message_language=>'it'
,p_message_text=>'Passo 1 - Nome pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279098908347868574)
,p_name=>'DATA_LOAD.TAB_SEPARTOR_NOTE'
,p_message_language=>'it'
,p_message_text=>'(\t per la tabulazione)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278439993087868156)
,p_name=>'DATA_LOAD.TRANSFORMATION_FAILED'
,p_message_language=>'it'
,p_message_text=>'Errore della regola di trasformazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279056058064868547)
,p_name=>'DATA_LOAD.UNIQUE_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna univoca %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279054045802868546)
,p_name=>'DATA_LOAD.UPDATE'
,p_message_language=>'it'
,p_message_text=>'Aggiorna riga'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278966661743868489)
,p_name=>'DATA_LOAD.UPDATED_COUNT'
,p_message_language=>'it'
,p_message_text=>'Riga/e aggiornate:'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279166785260868617)
,p_name=>'DATA_LOAD.UPLOADED_NULL_VALUE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato caricato un valore nullo.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278729834839868339)
,p_name=>'DATA_LOAD.UPLOAD_FILE'
,p_message_language=>'it'
,p_message_text=>'Carica file separato da virgole (*.csv) o delimitato da tabulazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278735454304868342)
,p_name=>'DATA_LOAD.UPLOAD_RESULTS'
,p_message_language=>'it'
,p_message_text=>'Risultati caricamento dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278735397261868342)
,p_name=>'DATA_LOAD.VALIDATION'
,p_message_language=>'it'
,p_message_text=>'Convalida dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278427098638868148)
,p_name=>'DATA_LOAD.VALIDATION_PAGE'
,p_message_language=>'it'
,p_message_text=>'Passo 3 - Nome pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278431144207868150)
,p_name=>'DATA_LOAD_WIZARD_CREATED_SUCCESSFULLY'
,p_message_language=>'it'
,p_message_text=>'Creazione delle pagine della Creazione guidata caricamento dati completata.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278689912053868314)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'it'
,p_message_text=>'Mapping dati/tabella non riuscito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278690096443868314)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'it'
,p_message_text=>'Azione elaborata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278289384754868060)
,p_name=>'DATA_UPLOAD_COLUMN_MAPPING'
,p_message_language=>'it'
,p_message_text=>'Mapping colonna caricamento dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278214863220868013)
,p_name=>'DATE'
,p_message_language=>'it'
,p_message_text=>'Data'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278419473950868143)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID'
,p_message_language=>'it'
,p_message_text=>'Il valore di attributo %0 di data evidenziata immesso per l''elemento %1 non corrisponde al formato %2.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278425216530868147)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID_RELATIVE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di attributo %0 di data evidenziata immesso per l''elemento %1 non \00E8 una data relativa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278419638357868143)
,p_name=>'DATEPICKER.MAX_DATE_INVALID'
,p_message_language=>'it'
,p_message_text=>'Il valore di attributo %0 di data massima immesso per l''elemento %1 non corrisponde al formato %2.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278425422188868147)
,p_name=>'DATEPICKER.MAX_DATE_INVALID_RELATIVE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di attributo %0 di data massima immesso per l''elemento %1 non \00E8 una data relativa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278419511648868143)
,p_name=>'DATEPICKER.MIN_DATE_INVALID'
,p_message_language=>'it'
,p_message_text=>'Il valore di attributo %0 di data minima immesso per l''elemento %1 non corrisponde al formato %2.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278425337574868147)
,p_name=>'DATEPICKER.MIN_DATE_INVALID_RELATIVE'
,p_message_language=>'it'
,p_message_text=>unistr('Il valore di attributo %0 di data minima immesso per l''elemento %1 non \00E8 una data relativa.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278553356020868228)
,p_name=>'DATE_ADDED'
,p_message_language=>'it'
,p_message_text=>'Data aggiunta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279026191681868528)
,p_name=>'DATE_OF_LAST_RUN'
,p_message_language=>'it'
,p_message_text=>'Job del database Oracle Application Express database con ora dell''ultima esecuzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278045379452867906)
,p_name=>'DAY'
,p_message_language=>'it'
,p_message_text=>'giorno'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278045495146867907)
,p_name=>'DAYS'
,p_message_language=>'it'
,p_message_text=>'giorni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278342027949868094)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE'
,p_message_language=>'it'
,p_message_text=>'al milestone finale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278342102549868094)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE_OF_RELASE'
,p_message_language=>'it'
,p_message_text=>'al milestone finale della release %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278424589717868146)
,p_name=>'DA_NAME.NATIVE_ADD_CLASS'
,p_message_language=>'it'
,p_message_text=>'Aggiungi classe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279031137603868531)
,p_name=>'DA_NAME.NATIVE_ALERT'
,p_message_language=>'it'
,p_message_text=>'Avviso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279029888609868530)
,p_name=>'DA_NAME.NATIVE_CANCEL_EVENT'
,p_message_language=>'it'
,p_message_text=>'Annulla evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279031328608868531)
,p_name=>'DA_NAME.NATIVE_CLEAR'
,p_message_language=>'it'
,p_message_text=>'Cancella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279031299306868531)
,p_name=>'DA_NAME.NATIVE_CONFIRM'
,p_message_language=>'it'
,p_message_text=>'Conferma'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277790990637867746)
,p_name=>'DA_NAME.NATIVE_DIALOG_CANCEL'
,p_message_language=>'it'
,p_message_text=>'Annulla finestra di dialogo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277791030248867746)
,p_name=>'DA_NAME.NATIVE_DIALOG_CLOSE'
,p_message_language=>'it'
,p_message_text=>'Chiudi finestra di dialogo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277950650938867847)
,p_name=>'DA_NAME.NATIVE_DISABLE'
,p_message_language=>'it'
,p_message_text=>'Disabilita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277950557605867847)
,p_name=>'DA_NAME.NATIVE_ENABLE'
,p_message_language=>'it'
,p_message_text=>'Abilita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279023445696868526)
,p_name=>'DA_NAME.NATIVE_EXECUTE_PLSQL_CODE'
,p_message_language=>'it'
,p_message_text=>'Esegui codice PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277950498841867847)
,p_name=>'DA_NAME.NATIVE_HIDE'
,p_message_language=>'it'
,p_message_text=>'Nascondi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278336805798868090)
,p_name=>'DA_NAME.NATIVE_JAVASCRIPT_CODE'
,p_message_language=>'it'
,p_message_text=>'Esegui codice JavaScript'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278696862452868318)
,p_name=>'DA_NAME.NATIVE_REFRESH'
,p_message_language=>'it'
,p_message_text=>'Aggiorna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278424671772868146)
,p_name=>'DA_NAME.NATIVE_REMOVE_CLASS'
,p_message_language=>'it'
,p_message_text=>'Rimuovi classe'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278424745191868146)
,p_name=>'DA_NAME.NATIVE_SET_CSS'
,p_message_language=>'it'
,p_message_text=>'Imposta stile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278669709307868301)
,p_name=>'DA_NAME.NATIVE_SET_FOCUS'
,p_message_language=>'it'
,p_message_text=>'Imposta selezione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278336793164868090)
,p_name=>'DA_NAME.NATIVE_SET_VALUE'
,p_message_language=>'it'
,p_message_text=>'Imposta valore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277950352753867846)
,p_name=>'DA_NAME.NATIVE_SHOW'
,p_message_language=>'it'
,p_message_text=>'Mostra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278669856361868301)
,p_name=>'DA_NAME.NATIVE_SUBMIT_PAGE'
,p_message_language=>'it'
,p_message_text=>'Sottometti pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278607380496868262)
,p_name=>'DA_NAME.NATIVE_TREE_COLLAPSE'
,p_message_language=>'it'
,p_message_text=>'Comprimi struttura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278607272281868262)
,p_name=>'DA_NAME.NATIVE_TREE_EXPAND'
,p_message_language=>'it'
,p_message_text=>'Espandi struttura'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277827837535867769)
,p_name=>'DBACCOUNT_AUTH_SCHEME_DESC'
,p_message_language=>'it'
,p_message_text=>'Account di database'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278332941602868088)
,p_name=>'DB_COLS_CASE_SEN'
,p_message_language=>'it'
,p_message_text=>'I nomi delle tabelle di database e delle colonne fanno distinzione tra maiuscole e minuscole'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278445210375868159)
,p_name=>'DB_OBJECT_CREATION_EXCEPTION'
,p_message_language=>'it'
,p_message_text=>'eccezione per creazione di oggetto di database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277841519574867778)
,p_name=>'DB_PRODUCT_NAME'
,p_message_language=>'it'
,p_message_text=>'Database Oracle'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279089165123868568)
,p_name=>'DB_SERVICES_ALIAS'
,p_message_language=>'it'
,p_message_text=>'Alias'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279085563544868566)
,p_name=>'DB_SERVICES_ALL_MIMES'
,p_message_language=>'it'
,p_message_text=>'Tutti i tipi MIME'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279089028776868568)
,p_name=>'DB_SERVICES_CREATE_HANDLER'
,p_message_language=>'it'
,p_message_text=>'Crea handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279085867242868566)
,p_name=>'DB_SERVICES_CREATE_METHOD'
,p_message_language=>'it'
,p_message_text=>'Crea metodo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279085615397868566)
,p_name=>'DB_SERVICES_CREATE_PARAMETER'
,p_message_language=>'it'
,p_message_text=>'Crea parametro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279085797902868566)
,p_name=>'DB_SERVICES_CREATE_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Crea modello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279092890251868570)
,p_name=>'DB_SERVICES_DB_SERVICES_MODULE'
,p_message_language=>'it'
,p_message_text=>'Modulo servizio RESTful'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279088960898868568)
,p_name=>'DB_SERVICES_HANDLER'
,p_message_language=>'it'
,p_message_text=>'Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279093391177868571)
,p_name=>'DB_SERVICES_HANDLER_BIND_VARIABLE'
,p_message_language=>'it'
,p_message_text=>'Bind variable handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279062743280868551)
,p_name=>'DB_SERVICES_HANDLER_METHOD'
,p_message_language=>'it'
,p_message_text=>'Metodo handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279093632786868571)
,p_name=>'DB_SERVICES_HANDLER_SOURCE'
,p_message_language=>'it'
,p_message_text=>'Origine handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279062896853868551)
,p_name=>'DB_SERVICES_HANDLER_SRC_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di origine handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279085345754868566)
,p_name=>'DB_SERVICES_METHOD'
,p_message_language=>'it'
,p_message_text=>'Metodo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279092915236868570)
,p_name=>'DB_SERVICES_MODULE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome modulo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279093498610868571)
,p_name=>'DB_SERVICES_MODULE_URI'
,p_message_language=>'it'
,p_message_text=>'Prefisso URI modulo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279085949168868566)
,p_name=>'DB_SERVICES_NO_SOURCE'
,p_message_language=>'it'
,p_message_text=>'Nessuna origine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279085200851868565)
,p_name=>'DB_SERVICES_PARAMETER'
,p_message_language=>'it'
,p_message_text=>'Parametro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279093138918868570)
,p_name=>'DB_SERVICES_RESTFUL_SERVICES'
,p_message_language=>'it'
,p_message_text=>'Servizi RESTful'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279085405430868566)
,p_name=>'DB_SERVICES_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279093572541868571)
,p_name=>'DB_SERVICES_TEMPLATE_URI'
,p_message_language=>'it'
,p_message_text=>'Modello URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279062606774868551)
,p_name=>'DB_SERVICES_URI'
,p_message_language=>'it'
,p_message_text=>'URI (Uniform Resource Identifier)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279092654321868570)
,p_name=>'DB_SERVICES_URI_PRIFIX'
,p_message_language=>'it'
,p_message_text=>'Prefisso URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279092792690868570)
,p_name=>'DB_SERVICES_URI_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279062997515868551)
,p_name=>'DB_SERVICE_QUERY_ONE_ROW'
,p_message_language=>'it'
,p_message_text=>'Query su una riga'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278238332840868028)
,p_name=>'DEBUG'
,p_message_language=>'it'
,p_message_text=>'Debug'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278353358841868101)
,p_name=>'DEBUGGING_OFF'
,p_message_language=>'it'
,p_message_text=>'Debug non abilitato per questa applicazione.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278350010162868099)
,p_name=>'DECLINED'
,p_message_language=>'it'
,p_message_text=>'Rifiutato'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279164626170868616)
,p_name=>'DEFAULT_DIALOGBTNR_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area pulsante finestra di dialogo predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279164545524868616)
,p_name=>'DEFAULT_DIALOGR_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area contenuto finestra di dialogo predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278690737466868314)
,p_name=>'DEFAULT_PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina predefinita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278219233146868016)
,p_name=>'DEFAULT_TABLESPACE'
,p_message_language=>'it'
,p_message_text=>'tablespace predefinita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278220962203868017)
,p_name=>'DEFAULT_TABLESPACE_INIT'
,p_message_language=>'it'
,p_message_text=>'Tablespace predefinita'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278508666835868199)
,p_name=>'DEFAULT_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello predefinito'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277823570595867767)
,p_name=>'DEFINED_BY_DA'
,p_message_language=>'it'
,p_message_text=>'Definita da azione dinamica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278754347360868355)
,p_name=>'DEFINED_TABS'
,p_message_language=>'it'
,p_message_text=>'Questa applicazione dispone di %0 schede distribuite in %1 set di schede e di %2 schede padre definite.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278110543131867947)
,p_name=>'DEFINE_LOV'
,p_message_language=>'it'
,p_message_text=>'Definisci liste di valori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278275434787868052)
,p_name=>'DEFINITION'
,p_message_language=>'it'
,p_message_text=>'Definizione'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278443048064868158)
,p_name=>'DEINSTALLATION_SCRIPT'
,p_message_language=>'it'
,p_message_text=>'Script di disinstallazione'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278047132017867908)
,p_name=>'DELETE'
,p_message_language=>'it'
,p_message_text=>'elimina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277938791223867839)
,p_name=>'DELETED'
,p_message_language=>'it'
,p_message_text=>'Eliminato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279027361914868528)
,p_name=>'DELETE_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Elimina applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278500343594868194)
,p_name=>'DELETE_LABEL'
,p_message_language=>'it'
,p_message_text=>'Elimina: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278476128158868179)
,p_name=>'DELETE_LINK_TEXT'
,p_message_language=>'it'
,p_message_text=>'Elimina %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277852120135867785)
,p_name=>'DELETE_MSG'
,p_message_language=>'it'
,p_message_text=>'Eseguire questa azione di eliminazione?'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277889882370867808)
,p_name=>'DEMO.COLLECT.DESCR'
,p_message_language=>'it'
,p_message_text=>'Dimostrazione collection consente di memorizzare righe di dati da utilizzare in una sessione di Oracle Application Express. Questa applicazione di database illustra come utilizzare il codice PL/SQL per creare e gestire lo stato della sessione basato '
||'su una collection.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277889616948867808)
,p_name=>'DEMO.SAMPLE.APP'
,p_message_language=>'it'
,p_message_text=>'Applicazione di esempio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277889714728867808)
,p_name=>'DEMO.SAMPLE.APP.DESCR'
,p_message_language=>'it'
,p_message_text=>unistr('Portale prodotto \00E8 un''applicazione di esempio che evidenzia i concetti di progettazione pi\00F9 comuni. Include pagine dedicate per clienti, prodotti e ordini, nonch\00E9 illustra l''utilizzo di report, grafici, calendari, mappe e strutture.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278298199391868066)
,p_name=>'DEMONSTRABLE'
,p_message_language=>'it'
,p_message_text=>'Dimostrabile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278027947635867896)
,p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK'
,p_message_language=>'it'
,p_message_text=>'Esempi di report e nozioni fondamentali sull''impaginazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278027668273867895)
,p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE'
,p_message_language=>'it'
,p_message_text=>'Esempio di commercio elettronico creato utilizzando %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278028324395867896)
,p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL'
,p_message_language=>'it'
,p_message_text=>'Informazioni sull''utilizzo di Oracle Text con %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278028747517867896)
,p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING'
,p_message_language=>'it'
,p_message_text=>'Esempio di applicazione di registrazione dello stato del progetto sviluppata con %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278028190081867896)
,p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES'
,p_message_language=>'it'
,p_message_text=>'Informazioni sull''utilizzo dei Web Service con %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278026469349867895)
,p_name=>'DEMO_APPLICATION.ACTION'
,p_message_language=>'it'
,p_message_text=>'Azione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278024220509867893)
,p_name=>'DEMO_APPLICATION.APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278023922238867893)
,p_name=>'DEMO_APPLICATION.BASIC_LEXER'
,p_message_language=>'it'
,p_message_text=>'BASIC_LEXER'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278027886093867896)
,p_name=>'DEMO_APPLICATION.BUSINESS_LOOK'
,p_message_language=>'it'
,p_message_text=>'Look aziendale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278026549082867895)
,p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE'
,p_message_language=>'it'
,p_message_text=>'Dimostrazione collection'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278024014027867893)
,p_name=>'DEMO_APPLICATION.CONTEXT_INDEX'
,p_message_language=>'it'
,p_message_text=>'CONTEXT INDEX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278023498695867893)
,p_name=>'DEMO_APPLICATION.CREATE_BASIC'
,p_message_language=>'it'
,p_message_text=>'Si sta per creare l''applicazione demo Esempi di base.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278022055680867892)
,p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK'
,p_message_language=>'it'
,p_message_text=>'Si sta per (ri)creare l''applicazione demo Look aziendale.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278023562941867893)
,p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE'
,p_message_language=>'it'
,p_message_text=>'Si sta per creare l''applicazione demo collection.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278023691319867893)
,p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE'
,p_message_language=>'it'
,p_message_text=>'crea o ricrea nello schema %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278021925028867892)
,p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES'
,p_message_language=>'it'
,p_message_text=>'Creare un''applicazione di esempio per una dimostrazione dei Web Service.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278022101748867892)
,p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA'
,p_message_language=>'it'
,p_message_text=>'Si sta per creare l''applicazione demo World Cup Mania.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277832094680867772)
,p_name=>'DEMO_APPLICATION.DEINSTALL'
,p_message_language=>'it'
,p_message_text=>'Rimuovi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278026216357867895)
,p_name=>'DEMO_APPLICATION.DEMO_APP'
,p_message_language=>'it'
,p_message_text=>'Applicazione demo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278024520804867894)
,p_name=>'DEMO_APPLICATION.FREE_SPACE'
,p_message_language=>'it'
,p_message_text=>'Sono disponibili circa %0 MB di spazio libero.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278027076912867895)
,p_name=>'DEMO_APPLICATION.INSTALL'
,p_message_language=>'it'
,p_message_text=>'Installa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278026700592867895)
,p_name=>'DEMO_APPLICATION.INSTALLED'
,p_message_language=>'it'
,p_message_text=>'Installata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278141702014867967)
,p_name=>'DEMO_APPLICATION.INSTALL_DEMO_APP'
,p_message_language=>'it'
,p_message_text=>'Si sta per installare l''applicazione di esempio per la dimostrazione delle principali funzioni di %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278027759307867895)
,p_name=>'DEMO_APPLICATION.INSTALL_NOW'
,p_message_language=>'it'
,p_message_text=>'Installa ora'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278026641970867895)
,p_name=>'DEMO_APPLICATION.LEARN_ABOUT'
,p_message_language=>'it'
,p_message_text=>'Informazioni introduttive sul carrello %0.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278480310717868181)
,p_name=>'DEMO_APPLICATION.LOCKED'
,p_message_language=>'it'
,p_message_text=>'Bloccato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278024339492867893)
,p_name=>'DEMO_APPLICATION.NEED_7M'
,p_message_language=>'it'
,p_message_text=>unistr('L''applicazione demo Discorso di insediamento del presidente richiede circa 7 MB di spazio libero su disco e la relativa installazione nello schema corrente pu\00F2 richiedere fino a 2 minuti.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278141488827867967)
,p_name=>'DEMO_APPLICATION.NOT_ENOUGH_SPACE_ERR'
,p_message_language=>'it'
,p_message_text=>'Spazio insufficiente per creare questa demo. Richiedere altro spazio passando alle pagine di amministrazione e dei servizi di fornitura, quindi facendo clic sul collegamento della richiesta di spazio aggiuntivo. %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278026960898867895)
,p_name=>'DEMO_APPLICATION.NOT_INSTALLED'
,p_message_language=>'it'
,p_message_text=>'Non installata'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278022827638867892)
,p_name=>'DEMO_APPLICATION.OBJECT_EXIST'
,p_message_language=>'it'
,p_message_text=>'EXISTS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278021742108867892)
,p_name=>'DEMO_APPLICATION.OBJECT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'esiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278022759784867892)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278023895632867893)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME2'
,p_message_language=>'it'
,p_message_text=>'Nome oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278021887313867892)
,p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS'
,p_message_language=>'it'
,p_message_text=>'Non esiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278022421481867892)
,p_name=>'DEMO_APPLICATION.OBJECT_RECREATE'
,p_message_language=>'it'
,p_message_text=>'I seguenti oggetti di database verranno ricreati se esistenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278022695506867892)
,p_name=>'DEMO_APPLICATION.OBJECT_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di oggetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278023388137867893)
,p_name=>'DEMO_APPLICATION.PACKAGE'
,p_message_language=>'it'
,p_message_text=>'Package'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278027596120867895)
,p_name=>'DEMO_APPLICATION.PETSTORE'
,p_message_language=>'it'
,p_message_text=>'Negozio di animali domestici'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278028269569867896)
,p_name=>'DEMO_APPLICATION.PRESIDENTIAL'
,p_message_language=>'it'
,p_message_text=>'Discorso di insediamento del presidente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278028599527867896)
,p_name=>'DEMO_APPLICATION.PROJECT_TRACKING'
,p_message_language=>'it'
,p_message_text=>'Registrazione progetto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278224954976868020)
,p_name=>'DEMO_APPLICATION.RE_INSTALL'
,p_message_language=>'it'
,p_message_text=>'Reinstalla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278026891802867895)
,p_name=>'DEMO_APPLICATION.RUN'
,p_message_language=>'it'
,p_message_text=>'Esegui'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278022586100867892)
,p_name=>'DEMO_APPLICATION.SCHEMA'
,p_message_language=>'it'
,p_message_text=>'Schema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278023161831867893)
,p_name=>'DEMO_APPLICATION.SEQUENCE'
,p_message_language=>'it'
,p_message_text=>'Sequenza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278026319082867895)
,p_name=>'DEMO_APPLICATION.STATUS'
,p_message_language=>'it'
,p_message_text=>'Stato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278022910201867892)
,p_name=>'DEMO_APPLICATION.TABLE'
,p_message_language=>'it'
,p_message_text=>'Tabella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278026117514867895)
,p_name=>'DEMO_APPLICATION.TABLE_SUMMARY'
,p_message_language=>'it'
,p_message_text=>'Report stato installazione applicazioni demo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278023241997867893)
,p_name=>'DEMO_APPLICATION.TRIGGER'
,p_message_language=>'it'
,p_message_text=>'Trigger'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278480503452868181)
,p_name=>'DEMO_APPLICATION.UNLOCKED'
,p_message_language=>'it'
,p_message_text=>'Sbloccato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277869058333867795)
,p_name=>'DEMO_APPLICATION.UPDATE_AVAILABLE'
,p_message_language=>'it'
,p_message_text=>'Aggiornamento disponibile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279119094888868587)
,p_name=>'DEMO_APPLICATION.WEBSHEET_OBJECT_VALIDATE'
,p_message_language=>'it'
,p_message_text=>unistr('Per eseguire i Websheet in modo corretto, \00E8 necessario correggere i seguenti oggetti non validi.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278028036687867896)
,p_name=>'DEMO_APPLICATION.WEB_SERVICES'
,p_message_language=>'it'
,p_message_text=>'Web Service'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278024664083867894)
,p_name=>'DEMO_APPLICATION.WILL_ERROR'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 possibile che si verifichino errori se questa demo non viene ricreata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277957534857867851)
,p_name=>'DEMO_FLOW.CREATED_ERROR'
,p_message_language=>'it'
,p_message_text=>'Spazio insufficiente per creare questa demo. Richiedere altro spazio passando alla pagina di amministrazione e facendo clic sul collegamento "Richiedi modifiche al servizio corrente".'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277957477881867851)
,p_name=>'DEMO_FLOW.CREATED_SUCCESS'
,p_message_language=>'it'
,p_message_text=>unistr('L''applicazione demo %0 \00E8 stata creata.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278728552586868338)
,p_name=>'DEPRECATED'
,p_message_language=>'it'
,p_message_text=>unistr('Non pi\00F9 valido')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277905453715867818)
,p_name=>'DERIVED$'
,p_message_language=>'it'
,p_message_text=>'colonna derivata'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278298088737868066)
,p_name=>'DESIRABLE'
,p_message_language=>'it'
,p_message_text=>'Richiesto'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278373984772868114)
,p_name=>'DETAIL'
,p_message_language=>'it'
,p_message_text=>'Dettaglio'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278440785504868156)
,p_name=>'DETAILS_FOR_ALT_TAG'
,p_message_language=>'it'
,p_message_text=>'Dettagli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278374053930868114)
,p_name=>'DETAIL_2'
,p_message_language=>'it'
,p_message_text=>'Dettaglio 2'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277840146344867777)
,p_name=>'DEVELOPER'
,p_message_language=>'it'
,p_message_text=>'Sviluppatore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278446963271868160)
,p_name=>'DEVELOPERS'
,p_message_language=>'it'
,p_message_text=>'Sviluppatori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278318464090868079)
,p_name=>'DEVELOPER_ACTIVITY_SUMMARY'
,p_message_language=>'it'
,p_message_text=>unistr('Riepilogo attivit\00E0 sviluppatore')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278343305026868095)
,p_name=>'DEVELOPER_SUMMARY'
,p_message_language=>'it'
,p_message_text=>'Riepilogo sviluppatore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278523879701868209)
,p_name=>'DEVELOPER_TOOLBAR_CLEAR'
,p_message_language=>'it'
,p_message_text=>'Cancella'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278523797998868209)
,p_name=>'DEVELOPER_TOOLBAR_COPY'
,p_message_language=>'it'
,p_message_text=>'Copia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278552492951868227)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LABEL'
,p_message_language=>'it'
,p_message_text=>'Debug (%0)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278551996602868227)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL'
,p_message_language=>'it'
,p_message_text=>'Livello di debug predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278552196437868227)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL4'
,p_message_language=>'it'
,p_message_text=>'Informazioni (predefinite)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278552283208868227)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL6'
,p_message_language=>'it'
,p_message_text=>'Trace applicazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278552305714868227)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL9'
,p_message_language=>'it'
,p_message_text=>'Trace completo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278511453571868201)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS'
,p_message_language=>'it'
,p_message_text=>unistr('Si sono verificati uno o pi\00F9 errori dopo il caricamento della pagina. Aprire la console JavaScript del browser per visualizzare gli errori.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278512031921868201)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS_BTN'
,p_message_language=>'it'
,p_message_text=>'Errori JavaScript'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278606929586868262)
,p_name=>'DEVELOPER_TOOLBAR_NO_BUILDER'
,p_message_language=>'it'
,p_message_text=>unistr('Questa funzionalit\00E0 richiede che la finestra App Builder di Application Express sia aperta. Aprire la Costruzione guidata in questa finestra?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278586805496868249)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS'
,p_message_language=>'it'
,p_message_text=>'Opzioni della barra degli strumenti sviluppatore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278595171369868254)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_AUTO_HIDE'
,p_message_language=>'it'
,p_message_text=>'Nascondi automaticamente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278595338769868254)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_DISPLAY'
,p_message_language=>'it'
,p_message_text=>'Posizione di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278595266751868254)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_ICONS_ONLY'
,p_message_language=>'it'
,p_message_text=>'Mostra solo icone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278595557820868254)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_BOTTOM'
,p_message_language=>'it'
,p_message_text=>'In basso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278595427657868254)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_LEFT'
,p_message_language=>'it'
,p_message_text=>'A sinistra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278595686935868254)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_RIGHT'
,p_message_language=>'it'
,p_message_text=>'A destra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278603278934868259)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_TOP'
,p_message_language=>'it'
,p_message_text=>'Inizio pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278518111269868205)
,p_name=>'DEVELOPER_TOOLBAR_PAGE_INFO'
,p_message_language=>'it'
,p_message_text=>'Informazioni pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278518358470868205)
,p_name=>'DEVELOPER_TOOLBAR_PERF_TITLE'
,p_message_language=>'it'
,p_message_text=>'Tempificazione prestazioni pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278586900984868249)
,p_name=>'DEVELOPER_TOOLBAR_QUICK_EDIT'
,p_message_language=>'it'
,p_message_text=>'Modifica rapida'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278518291560868205)
,p_name=>'DEVELOPER_TOOLBAR_SHOW_PERF'
,p_message_language=>'it'
,p_message_text=>'Mostra tempificazione pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279135065508868597)
,p_name=>'DEVELOPER_TOOLBAR_THEME_ROLLER'
,p_message_language=>'it'
,p_message_text=>'Theme Roller'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278595059845868254)
,p_name=>'DEVELOPER_TOOLBAR_TITLE'
,p_message_language=>'it'
,p_message_text=>'Barra degli strumenti sviluppatore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278291567210868062)
,p_name=>'DEVELOPMENT_TASK'
,p_message_language=>'it'
,p_message_text=>'Task di sviluppo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278474696155868178)
,p_name=>'DIAL_CHART_ALERT_VALUE'
,p_message_language=>'it'
,p_message_text=>'Avviso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278474541101868178)
,p_name=>'DIAL_CHART_HIGH_VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore massimo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278474473003868178)
,p_name=>'DIAL_CHART_LOW_VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore minimo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277794786440867748)
,p_name=>'DIAL_PCT'
,p_message_language=>'it'
,p_message_text=>'Quadrante (Percentuale)'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277876243258867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATIONS'
,p_message_language=>'it'
,p_message_text=>'Applicazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277878867489867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTH'
,p_message_language=>'it'
,p_message_text=>'Schemi di autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277878907250867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTHORIZATION'
,p_message_language=>'it'
,p_message_text=>'Schemi di autorizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277878059123867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BC_ENTRIES'
,p_message_language=>'it'
,p_message_text=>'Voci'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277877969218867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BREADCRUMBS'
,p_message_language=>'it'
,p_message_text=>'Indicatori di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279176857472868624)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BUILD_OPTIONS'
,p_message_language=>'it'
,p_message_text=>'Opzioni di creazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277877613797867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_COMPUTATIONS'
,p_message_language=>'it'
,p_message_text=>'Calcoli di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277877811288867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Elementi di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277878168697867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LISTS'
,p_message_language=>'it'
,p_message_text=>'Liste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277878292803867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LIST_ENTRIES'
,p_message_language=>'it'
,p_message_text=>'Voci'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277878392864867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOVS'
,p_message_language=>'it'
,p_message_text=>'Lista di valori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277814396843867761)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_COLS'
,p_message_language=>'it'
,p_message_text=>'Colonne liste dei valori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277878417495867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_ENTRIES'
,p_message_language=>'it'
,p_message_text=>'Voci'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277878534703867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_NAV_BAR'
,p_message_language=>'it'
,p_message_text=>'Barre di navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277876360168867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGES'
,p_message_language=>'it'
,p_message_text=>'Pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277877540542867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BRANCHES'
,p_message_language=>'it'
,p_message_text=>'Diramazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277876771523867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BUTTONS'
,p_message_language=>'it'
,p_message_text=>'Pulsanti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278264502521868045)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHARTS'
,p_message_language=>'it'
,p_message_text=>'Grafici'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278264716351868045)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_A'
,p_message_language=>'it'
,p_message_text=>'Assi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278264638361868045)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_S'
,p_message_language=>'it'
,p_message_text=>'Serie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277877279567867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_COMP'
,p_message_language=>'it'
,p_message_text=>'Calcoli'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277923430791867830)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA'
,p_message_language=>'it'
,p_message_text=>'Azioni dinamiche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277923527134867830)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA_ACTS'
,p_message_language=>'it'
,p_message_text=>'Azione dinamica - Azioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278696178624868318)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5'
,p_message_language=>'it'
,p_message_text=>'Grafici flash 5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278696249137868318)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5_S'
,p_message_language=>'it'
,p_message_text=>'Serie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277876871199867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_CH'
,p_message_language=>'it'
,p_message_text=>'Grafici flash'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277876986244867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_S'
,p_message_language=>'it'
,p_message_text=>'Serie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277877073408867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR'
,p_message_language=>'it'
,p_message_text=>'Aree report interattivi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277877161796867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR_COL'
,p_message_language=>'it'
,p_message_text=>'Colonne report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277876555787867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Elementi pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277877447940867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_PROC'
,p_message_language=>'it'
,p_message_text=>'Processi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277876480630867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REGIONS'
,p_message_language=>'it'
,p_message_text=>'Aree'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278988237459868503)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REG_COLS'
,p_message_language=>'it'
,p_message_text=>'Colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277876681954867800)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_RPT_COLS'
,p_message_language=>'it'
,p_message_text=>'Colonne report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279083741842868565)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_TREES'
,p_message_language=>'it'
,p_message_text=>'Strutture'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277877392720867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_VAL'
,p_message_language=>'it'
,p_message_text=>'Convalide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277878614473867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PARENT_TABS'
,p_message_language=>'it'
,p_message_text=>'Schede padre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277877772980867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PROCESSES'
,p_message_language=>'it'
,p_message_text=>'Processi di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279114998632868584)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_LAYOUTS'
,p_message_language=>'it'
,p_message_text=>'Layout report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279115762700868585)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QRY_STMTS'
,p_message_language=>'it'
,p_message_text=>'Report istruzioni query SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279114863981868584)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QUERIES'
,p_message_language=>'it'
,p_message_text=>'Query report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279053870764868546)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277879031378867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SHORTCUTS'
,p_message_language=>'it'
,p_message_text=>'Scorciatoie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277874201332867799)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_STATIC_FILES'
,p_message_language=>'it'
,p_message_text=>'File delle applicazioni'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277880531474867803)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUBSTITUTIONS'
,p_message_language=>'it'
,p_message_text=>'Stringhe di sostituzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279176510827868624)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJECTS'
,p_message_language=>'it'
,p_message_text=>'Oggetti di supporto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279176680999868624)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_BOPT'
,p_message_language=>'it'
,p_message_text=>'Oggetti di supporto - Opzioni di creazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277880393504867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_CHCK'
,p_message_language=>'it'
,p_message_text=>'Oggetti di supporto - Convalide'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277880456220867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_SCR'
,p_message_language=>'it'
,p_message_text=>'Oggetti di supporto - Script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277878721380867801)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TABS'
,p_message_language=>'it'
,p_message_text=>'Schede'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277879452094867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BC'
,p_message_language=>'it'
,p_message_text=>'Modelli di indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277879537163867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BUTTON'
,p_message_language=>'it'
,p_message_text=>'Modelli di pulsante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277879631266867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_CALENDAR'
,p_message_language=>'it'
,p_message_text=>'Modelli di calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277949945590867846)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_GRID'
,p_message_language=>'it'
,p_message_text=>'Modelli griglia'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277879745929867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LABEL'
,p_message_language=>'it'
,p_message_text=>'Modelli di etichetta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277879856364867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LIST'
,p_message_language=>'it'
,p_message_text=>'Modelli di lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277879972455867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_PAGE'
,p_message_language=>'it'
,p_message_text=>'Modelli di pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277880085047867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_POPUPLOV'
,p_message_language=>'it'
,p_message_text=>'Modelli di LOV popup'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277880110283867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REGION'
,p_message_language=>'it'
,p_message_text=>'Modelli di area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277880246124867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REPORT'
,p_message_language=>'it'
,p_message_text=>'Modelli report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277879322851867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEMES'
,p_message_language=>'it'
,p_message_text=>'Temi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277856499743867787)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_FILES'
,p_message_language=>'it'
,p_message_text=>'File di temi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277802584508867753)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_STYLES'
,p_message_language=>'it'
,p_message_text=>'Stili tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278323650066868082)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANSLATIONS'
,p_message_language=>'it'
,p_message_text=>'Messaggi di testo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277848905052867783)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_DYNAMIC'
,p_message_language=>'it'
,p_message_text=>'Traduzioni dinamiche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277849019662867783)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_REPOS'
,p_message_language=>'it'
,p_message_text=>'Testo traducibile'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277879238800867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TREES'
,p_message_language=>'it'
,p_message_text=>'Strutture'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277879176320867802)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_WEB_SERVICES'
,p_message_language=>'it'
,p_message_text=>'Web Service'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279074969059868559)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_ROLES'
,p_message_language=>'it'
,p_message_text=>'Ruoli di controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279075096415868559)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USERS'
,p_message_language=>'it'
,p_message_text=>'Utenti di controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278365378425868108)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USER_ROLES'
,p_message_language=>'it'
,p_message_text=>'Assegnazione ruoli utente di controllo dell''accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279118612292868587)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_CONCATENATED_FILES'
,p_message_language=>'it'
,p_message_text=>'File concatenati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278272522157868050)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILES'
,p_message_language=>'it'
,p_message_text=>'Profili di analisi dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278272697535868050)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILE_COLS'
,p_message_language=>'it'
,p_message_text=>'Colonne profilo di analisi dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279148300362868606)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DEVELOPER_COMMENTS'
,p_message_language=>'it'
,p_message_text=>'Commenti sviluppatori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278683950458868310)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE'
,p_message_language=>'it'
,p_message_text=>'Tabella di caricamento dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278672144982868303)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLES'
,p_message_language=>'it'
,p_message_text=>'Tabelle di caricamento dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278672215579868303)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_LOOKUPS'
,p_message_language=>'it'
,p_message_text=>'Ricerche tabella di caricamento dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278672310445868303)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_RULES'
,p_message_language=>'it'
,p_message_text=>'Regole di trasformazione tabella di caricamento dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277809306469867758)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CALENDARS'
,p_message_language=>'it'
,p_message_text=>'Pagina di calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278587755479868249)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IGS'
,p_message_language=>'it'
,p_message_text=>'Aree griglia interattiva'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278587830738868249)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COLUMNS'
,p_message_language=>'it'
,p_message_text=>'Colonne report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278587961265868249)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COL_GROUPS'
,p_message_language=>'it'
,p_message_text=>'Gruppi di colonne'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277896643934867813)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGINS'
,p_message_language=>'it'
,p_message_text=>'Plugin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277896712390867813)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTRIBUTES'
,p_message_language=>'it'
,p_message_text=>'Attributi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278322253823868081)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTR_VALUES'
,p_message_language=>'it'
,p_message_text=>'Valori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277954796115867849)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_EVENTS'
,p_message_language=>'it'
,p_message_text=>'Eventi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277899164649867814)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_FILES'
,p_message_language=>'it'
,p_message_text=>'File'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278374605005868114)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ITEM_FILTERS'
,p_message_language=>'it'
,p_message_text=>'Operatori di filtro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279176763770868624)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Impostazioni componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279089532262868568)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_STD_ATTRS'
,p_message_language=>'it'
,p_message_text=>'Metadati attributi standard plugin'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278272452375868050)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_REMOTE_SQL'
,p_message_language=>'it'
,p_message_text=>'Server SQL abilitato per REST'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278988155509868503)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPTIONS'
,p_message_language=>'it'
,p_message_text=>'Opzioni modello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279176444903868623)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GROUPS'
,p_message_language=>'it'
,p_message_text=>'Gruppi di opzioni modello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279060776174868550)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMPLATE_OPT_GRP'
,p_message_language=>'it'
,p_message_text=>'Gruppo di opzioni modello'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279131839173868595)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_PAGE_DP'
,p_message_language=>'it'
,p_message_text=>'Punti di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279131985457868595)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_TEMP_REGION_DP'
,p_message_language=>'it'
,p_message_text=>'Punti di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277953108165867848)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_THEME_DISPLAY_POINTS'
,p_message_language=>'it'
,p_message_text=>'Punti di visualizzazione tema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277874172044867798)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_USER_INTERFACES'
,p_message_language=>'it'
,p_message_text=>'Interfacce utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278273180265868050)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_COMP_PARAMS'
,p_message_language=>'it'
,p_message_text=>'Parametri origine Web componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278272854947868050)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_MODULES'
,p_message_language=>'it'
,p_message_text=>'Moduli di origine Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278272906377868050)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_OPERATIONS'
,p_message_language=>'it'
,p_message_text=>'Operazioni origine Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278273026766868050)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_PARAMETERS'
,p_message_language=>'it'
,p_message_text=>'Parametri origine Web'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278272776106868050)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_WEB_SRC_SERVERS'
,p_message_language=>'it'
,p_message_text=>'Server remoti origine Web'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279092019082868570)
,p_name=>'DISABLED_NEXT_BUTTON'
,p_message_language=>'it'
,p_message_text=>'Pulsante Successivo disabilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279091985131868570)
,p_name=>'DISABLED_PREVIOUS_BUTTON'
,p_message_language=>'it'
,p_message_text=>'Pulsante Precedente disabilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278435370679868153)
,p_name=>'DISABLE_TRIGGER'
,p_message_language=>'it'
,p_message_text=>'Disabilita trigger %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278032617648867899)
,p_name=>'DISPLAY_CONDITION'
,p_message_language=>'it'
,p_message_text=>'Condizione di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278032891922867899)
,p_name=>'DISPLAY_CONDITION_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo condizione di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278500534487868194)
,p_name=>'DISPLAY_ORDER_LABEL'
,p_message_language=>'it'
,p_message_text=>'Ordine di visualizzazione: %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277903156490867817)
,p_name=>'DISPLAY_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279176121956868623)
,p_name=>'DISPLAY_VALUE.N'
,p_message_language=>'it'
,p_message_text=>'Valore visualizzato: %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279087351937868567)
,p_name=>'DISTINCT_PAGES'
,p_message_language=>'it'
,p_message_text=>'Pagine distinte'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279087467815868567)
,p_name=>'DISTINCT_USERS'
,p_message_language=>'it'
,p_message_text=>'Utenti distinti'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277814001923867761)
,p_name=>'DML_FORM'
,p_message_language=>'it'
,p_message_text=>'Form DML'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278120956833867954)
,p_name=>'DO NOT UPDATE PAGE ITEMS'
,p_message_language=>'it'
,p_message_text=>'DO_NOT_UPDATE_PAGE_ITEMS'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278314003068868076)
,p_name=>'DOC_IMPACT'
,p_message_language=>'it'
,p_message_text=>'Impatto documentazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278315207420868077)
,p_name=>'DOC_STATUS'
,p_message_language=>'it'
,p_message_text=>'Stato documentazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278315484106868077)
,p_name=>'DOC_WRITER'
,p_message_language=>'it'
,p_message_text=>'Autore documentazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278192939589868000)
,p_name=>'DOWN'
,p_message_language=>'it'
,p_message_text=>'Inattivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277824473623867767)
,p_name=>'DOWNLOAD'
,p_message_language=>'it'
,p_message_text=>'Scarica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278323405386868082)
,p_name=>'DOWNLOAD_LINK_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo di collegamento per il download'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278120695562867954)
,p_name=>'DO_NOT_UPDATE_APPLICATION_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Non aggiornare gli elementi di applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278120710550867954)
,p_name=>'DO_NOT_UPDATE_DATA_ENTRY_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Non aggiornare gli elementi di immissione dati'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278120814006867954)
,p_name=>'DO_NOT_UPDATE_DISPLAY_ONLY_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Non aggiornare elementi di sola visualizzazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278120520364867954)
,p_name=>'DO_NOT_UPDATE_PAGES'
,p_message_language=>'it'
,p_message_text=>'Non aggiornare le pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278122191702867955)
,p_name=>'DO_NOT_UPDATE_PAGE_ITEMS'
,p_message_language=>'it'
,p_message_text=>'Non aggiornare gli elementi di pagina'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278001118041867879)
,p_name=>'DRAG_AND_DROP'
,p_message_language=>'it'
,p_message_text=>'Trascinamento della selezione'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277893830532867811)
,p_name=>'DRILLDOWN'
,p_message_language=>'it'
,p_message_text=>'Espandi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277893774349867811)
,p_name=>'DRILLUP'
,p_message_language=>'it'
,p_message_text=>'Esegui drill-up'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278049433726867909)
,p_name=>'DRIVEN'
,p_message_language=>'it'
,p_message_text=>'basato su'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278435131902868153)
,p_name=>'DROP TRIGGER'
,p_message_language=>'it'
,p_message_text=>'Elimina trigger %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278434025127868152)
,p_name=>'DROP_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Elimina colonna %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278667443322868300)
,p_name=>'DS_ACCESS_METHOD'
,p_message_language=>'it'
,p_message_text=>'Metodo di accesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278667273317868300)
,p_name=>'DS_BIND_VARIABLE_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome bind variable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278667646697868300)
,p_name=>'DS_HANDLER'
,p_message_language=>'it'
,p_message_text=>'Handler'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278668053537868300)
,p_name=>'DS_ITEMS_PER_PAGE'
,p_message_language=>'it'
,p_message_text=>'Elementi per pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278667823753868300)
,p_name=>'DS_MIME_TYPES_ALLOWED'
,p_message_language=>'it'
,p_message_text=>'Tipi MIME consentiti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278667987668868300)
,p_name=>'DS_ORIGINS_ALLOWED'
,p_message_language=>'it'
,p_message_text=>'Origini consentite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278667589515868300)
,p_name=>'DS_PARAMETER_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di parametro'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278668176297868300)
,p_name=>'DS_SECURITY_CONSTRAINT'
,p_message_language=>'it'
,p_message_text=>'Vincolo di sicurezza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278667300104868300)
,p_name=>'DS_SOURCE'
,p_message_language=>'it'
,p_message_text=>'Origine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278667762656868300)
,p_name=>'DS_SOURCE_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo di origine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278668271856868300)
,p_name=>'DS_URI_PREFIX'
,p_message_language=>'it'
,p_message_text=>'Prefisso URI'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278666988246868299)
,p_name=>'DS_URI_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello URI'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279115893491868585)
,p_name=>'DUE'
,p_message_language=>'it'
,p_message_text=>'Scadenza'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278315083506868077)
,p_name=>'DUE_DATE'
,p_message_language=>'it'
,p_message_text=>'Data scadenza'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278294817057868064)
,p_name=>'DUPLICATE'
,p_message_language=>'it'
,p_message_text=>'Duplicato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279088288015868567)
,p_name=>'DUPLICATE_USER'
,p_message_language=>'it'
,p_message_text=>'Utente duplicato nella lista'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278737486088868344)
,p_name=>'DUP_USER'
,p_message_language=>'it'
,p_message_text=>'Nome utente duplicato nella lista.'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277802939376867754)
,p_name=>'DYNAMIC ACTION'
,p_message_language=>'it'
,p_message_text=>'Azione dinamica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277802830849867754)
,p_name=>'DYNAMIC ACTIONS'
,p_message_language=>'it'
,p_message_text=>'Azioni dinamiche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277812688668867760)
,p_name=>'DYNAMIC_FORM'
,p_message_language=>'it'
,p_message_text=>'Form dinamico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277938816883867839)
,p_name=>'DYNAMIC_HTML'
,p_message_language=>'it'
,p_message_text=>'HTML dinamico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277999962694867878)
,p_name=>'DYNAMIC_QUERY'
,p_message_language=>'it'
,p_message_text=>'Report interattivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277800471706867752)
,p_name=>'DYNAMIC_REFERENCE'
,p_message_language=>'it'
,p_message_text=>'Riferimento dinamico'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278108848793867946)
,p_name=>'EASY_REPORT.INVALID_CONDITION'
,p_message_language=>'it'
,p_message_text=>unistr('La condizione che si sta aggiungendo ha causato l''invalidit\00E0 della query.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277893934715867811)
,p_name=>'EDIT'
,p_message_language=>'it'
,p_message_text=>'Modifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277808144145867757)
,p_name=>'EDIT PAGE GROUP'
,p_message_language=>'it'
,p_message_text=>'Modifica gruppo di pagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278358320564868104)
,p_name=>'EDITOR_EXIT'
,p_message_language=>'it'
,p_message_text=>'Se si sceglie OK, le modifiche non salvate andranno perdute.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277839472715867776)
,p_name=>'EDIT_ALL'
,p_message_language=>'it'
,p_message_text=>'Modifica tutto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278110075030867947)
,p_name=>'EDIT_ALL_PAGE_DEFINITION_ATTRIBUTES'
,p_message_language=>'it'
,p_message_text=>'Modifica tutti gli attributi di definizione della pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278352555246868100)
,p_name=>'EDIT_ALL_REGION'
,p_message_language=>'it'
,p_message_text=>'Modifica tutti gli elementi in questa area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278278684944868054)
,p_name=>'EDIT_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Modifica applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278372779382868113)
,p_name=>'EDIT_ATTRIBUTE'
,p_message_language=>'it'
,p_message_text=>'Modifica attributo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279027527114868529)
,p_name=>'EDIT_AUTHENTICATION'
,p_message_language=>'it'
,p_message_text=>'Modifica autenticazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278362752468868107)
,p_name=>'EDIT_COMPONENT'
,p_message_language=>'it'
,p_message_text=>'Modifica componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278372889326868113)
,p_name=>'EDIT_COMPONENT_DEF'
,p_message_language=>'it'
,p_message_text=>'Modifica definizione dei componenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278475316954868178)
,p_name=>'EDIT_LINK_TEXT'
,p_message_language=>'it'
,p_message_text=>'Modifica %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278372642064868113)
,p_name=>'EDIT_LIST_DEV'
,p_message_language=>'it'
,p_message_text=>'Modifica definizione lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279102213494868576)
,p_name=>'EDIT_LOCK'
,p_message_language=>'it'
,p_message_text=>'Modifica lock'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278238182557868028)
,p_name=>'EDIT_PAGE'
,p_message_language=>'it'
,p_message_text=>'Modifica pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278112529125867949)
,p_name=>'EDIT_PAGE_ATTRIBUTES'
,p_message_language=>'it'
,p_message_text=>'Modifica attributi pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278735946412868343)
,p_name=>'EDIT_PROFILE'
,p_message_language=>'it'
,p_message_text=>'Modifica profilo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278756857294868356)
,p_name=>'EDIT_PROFILE.USER_NO_PRIV_ERR'
,p_message_language=>'it'
,p_message_text=>'L''utente 0% non dispone di privilegi per aggiornare le informazioni per un altro utente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278362568555868107)
,p_name=>'EDIT_REGION'
,p_message_language=>'it'
,p_message_text=>'Modifica area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278447741714868161)
,p_name=>'EDIT_REPORTING_TIMEFRAME'
,p_message_language=>'it'
,p_message_text=>'Modifica periodo di tempo di report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278362639213868107)
,p_name=>'EDIT_REPORT_COLS'
,p_message_language=>'it'
,p_message_text=>'Modifica colonne di report'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278729348293868339)
,p_name=>'EDIT_REPORT_DIALOG_CLOSED_DA'
,p_message_language=>'it'
,p_message_text=>'Modifica report - Finestra di dialogo chiusa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278351534260868100)
,p_name=>'EDIT_SYSTEM_MESSAGE'
,p_message_language=>'it'
,p_message_text=>'Modifica messaggio di sistema'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278690527558868314)
,p_name=>'EDIT_TAB'
,p_message_language=>'it'
,p_message_text=>'Modifica scheda'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278374325798868114)
,p_name=>'EDIT_THIS_ATTRIBUTE'
,p_message_language=>'it'
,p_message_text=>'Modifica questo attributo'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278215275697868014)
,p_name=>'ELAPSED_TIME'
,p_message_language=>'it'
,p_message_text=>'Tempo trascorso'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278302299076868069)
,p_name=>'EMAIL.TEMPLATE.FOOTER_EXAMPLE'
,p_message_language=>'it'
,p_message_text=>'<a href="#MY_APPLICATION_LINK#">Visitare Applicazione personale e gestire le preferenze di posta elettronica</a>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278309436452868073)
,p_name=>'EMAIL.TEMPLATE.HEADER_EXAMPLE'
,p_message_language=>'it'
,p_message_text=>'<b style="font-size: 24px;">Applicazione personale</b>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278434451168868152)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.EV'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>Gentile #INVITEE#,</b><br>',
'<br>',
unistr('questo \00E8 un promemoria per un evento imminente a cui si \00E8 invitati. I dettagli dell''evento sono riportati di seguito.<br>'),
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Organizzatore</th>',
'    <td>#ORGANIZER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Data evento</th>',
'    <td>#EVENT_DATE#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Ora di inizio</th>',
'    <td>#START_TIME#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Durata</th>',
'    <td>#DURATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Luogo</th>',
'    <td>#LOCATION#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">URL</th>',
'    <td><a href="#URL_LINK#">#URL_NAME#</a></td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Note</th>',
'    <td>#NOTES#</td>',
'  </tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278302124426868069)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.OD'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<b>Gentile #CUSTOMER_NAME#</b>,<br>',
'<br>',
'grazie per l''ordine.<br>',
'<br>',
'<b>Dettagli dell''ordine</b><br>',
'<br>',
'<table width="100%">',
'  <tr>',
'    <th align="left">Data ordine</th>',
'    <td>#ORDER_DATE#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Numero ordine</th>',
'    <td>#ORDER_NUMBER#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Destinatario</th>',
'    <td>#SHIP_TO#</td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Indirizzo di spedizione</th>',
'    <td>',
'      #SHIPPING_ADDRESS_LINE_1#<br>',
'      #SHIPPING_ADDRESS_LINE_2#',
'    </td>',
'  </tr>',
'  <tr>',
'    <th align="left" valign="top">Articoli ordinati</th>',
'    <td>#ITEMS_ORDERED#</td>',
'  </tr>',
'  <tr>',
'    <th align="left">Totale ordine</th>',
'    <td>#ORDER_TOTAL#</td>',
'  </tr>',
'</table>',
'<br>',
'<br>',
unistr('Se \00E8 necessario apportare modifiche: <a href="#ORDER_URL#">gestire l''ordine #ORDER_NUMBER# qui.</a>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278729626478868339)
,p_name=>'EMAIL.TEMPLATE.HTML_BODY_EXAMPLE.SO'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Gentile #SERVICE_USER#,<br>',
'<br>',
unistr('tenere presente l''imminente indisponibilit\00E0 pianificata del servizio #SERVICE_NAME#.<br>'),
unistr('In base alla pianificazione, l''indisponibilit\00E0 inizier\00E0 alle #OUTAGE_START# e il servizio sar\00E0 indisponibile per #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.<br>'),
'<br>',
unistr('Durante l''indisponibilit\00E0 pianificata verranno eseguite le operazioni seguenti:<br>'),
'#OUTAGE_REASON#<br>',
'<br>',
'<br>',
unistr('Per qualsiasi problema relativo all''indisponibilit\00E0 del servizio, rivolgersi a #OUTAGE_CONTACT#.<br>'),
'<br>',
'Grazie per la comprensione,<br>',
'#SERVICE_TEAM#'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278729044373868338)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.EV'
,p_message_language=>'it'
,p_message_text=>'Promemoria evento: #EVENT_NAME#'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278729107874868339)
,p_name=>'EMAIL.TEMPLATE.SUBJECT_EXAMPLE.OD'
,p_message_language=>'it'
,p_message_text=>'Ordine (#ORDER_NUMBER#) confermato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278434689727868152)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.EV'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Gentile #INVITEE#,',
'',
unistr('questo messaggio di posta elettronica \00E8 un promemoria per un evento imminente a cui si \00E8 associati.'),
'',
'Data evento: #EVENT_DATE#',
'Ora di inizio: #START_TIME#',
'Durata:      #DURATION#',
'Organizzatore: #ORGANIZER#',
'Luogo:     #LOCATION#',
'URL:        #URL_NAME# (#URL_LINK#)',
'Note:     #NOTES#',
'',
'Ulteriori dettagli sono disponibili qui: #EVENT_LINK#'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278434552265868152)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.OD'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Gentile #CUSTOMER_NAME#,',
'',
'grazie per l''ordine.',
'',
'Dettagli dell''ordine',
'--------------------------------------------------------------------------------',
'  Data ordine:      #ORDER_DATE#',
'  Numero ordine:    #ORDER_NUMBER#',
'  Destinatario:     #SHIP_TO#',
'  Indirizzo di spedizione: #SHIPPING_ADDRESS_LINE_1#',
'                    #SHIPPING_ADDRESS_LINE_2#',
'  Articoli ordinati: #ITEMS_ORDERED#',
'  Totale ordine:     #ORDER_TOTAL#',
'--------------------------------------------------------------------------------',
'',
unistr('Se \00E8 necessario apportare modifiche, gestire l''ordine #ORDER_NUMBER# qui: #ORDER_URL#')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278729516602868339)
,p_name=>'EMAIL.TEMPLATE.TEXT_BODY_EXAMPLE.SO'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Gentile #SERVICE_USER#,',
'',
unistr('tenere presente l''imminente indisponibilit\00E0 pianificata del servizio #SERVICE_NAME#.'),
unistr('In base alla pianificazione, l''indisponibilit\00E0 inizier\00E0 alle #OUTAGE_START# e il servizio sar\00E0 indisponibile per #OUTAGE_DURATION# #OUTAGE_TIMEFRAME#.'),
'',
unistr('Durante l''indisponibilit\00E0 pianificata verranno eseguite le operazioni seguenti:'),
'#OUTAGE_REASON#',
'',
unistr('Per qualsiasi problema relativo all''indisponibilit\00E0 del servizio, rivolgersi a #OUTAGE_CONTACT#.'),
'',
'Grazie per la comprensione,',
'#SERVICE_TEAM#',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277969463090867858)
,p_name=>'EMAIL_NOT_FOUND'
,p_message_language=>'it'
,p_message_text=>'Indirizzo di posta elettronica "%0" non trovato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277840467680867777)
,p_name=>'EMAIL_SENT_BY'
,p_message_language=>'it'
,p_message_text=>unistr('Questo messaggio di posta elettronica \00E8 stato inviato da %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278737650579868344)
,p_name=>'EMAIL_TOO_LONG'
,p_message_language=>'it'
,p_message_text=>unistr('Indirizzo di posta elettronica troppo lungo. Il limite \00E8 di 240 caratteri.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278356493564868103)
,p_name=>'ENABLE_DEBUGGING'
,p_message_language=>'it'
,p_message_text=>unistr('Abilita debug (S\00EC o No)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278435224501868153)
,p_name=>'ENABLE_TRIGGER'
,p_message_language=>'it'
,p_message_text=>'Abilita trigger %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277842007274867778)
,p_name=>'ENCRYPTION_INPUT_TOO_LONG'
,p_message_language=>'it'
,p_message_text=>unistr('La lunghezza del valore da cifrare non pu\00F2 superare 4000 byte.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277840221932867777)
,p_name=>'END_USER'
,p_message_language=>'it'
,p_message_text=>'Utente finale'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278291176328868061)
,p_name=>'ENHANCEMENT_REQUEST'
,p_message_language=>'it'
,p_message_text=>'Richiesta di miglioramento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278757575689868357)
,p_name=>'ENHANCEMENT_REQUEST_DASH'
,p_message_language=>'it'
,p_message_text=>'Richieste di miglioramento: chiuse %1 su %0'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278294337228868064)
,p_name=>'ENTERED'
,p_message_language=>'it'
,p_message_text=>'Immesso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277806702103867756)
,p_name=>'ENTER_WEBSHEETS_CREDENTIALS'
,p_message_language=>'it'
,p_message_text=>'Immettere le credenziali Websheet.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278280395278868055)
,p_name=>'ENTRY LINK'
,p_message_language=>'it'
,p_message_text=>'Collegamento della voce'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278280296720868055)
,p_name=>'ENTRY TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo della voce'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278195227604868001)
,p_name=>'ERROR'
,p_message_language=>'it'
,p_message_text=>'Errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278338962515868092)
,p_name=>'ERROR PAGE TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di pagina di errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278190645189867998)
,p_name=>'ERRORPAGE'
,p_message_language=>'it'
,p_message_text=>'Nella pagina di errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278353173702868101)
,p_name=>'ERRORS'
,p_message_language=>'it'
,p_message_text=>'Errori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278281505308868055)
,p_name=>'ERROR_ICON'
,p_message_language=>'it'
,p_message_text=>'Icona di errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279114295338868584)
,p_name=>'ERROR_MESSAGE'
,p_message_language=>'it'
,p_message_text=>'Messaggio di errore'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278440924480868156)
,p_name=>'ERROR_SET_ITEM_STATE_FOR_PPR_REGION'
,p_message_language=>'it'
,p_message_text=>'Impossibile impostare il valore di origine dell''elemento di pagina per l''area di aggiornamento di pagina parziale.'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278273625703868051)
,p_name=>'ESCAPED_COL_TOO_LARGE'
,p_message_language=>'it'
,p_message_text=>'<br><b>I dati con escape superano il limite consentito. I risultati verranno troncati a 32k</b>'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278048672194867909)
,p_name=>'ESCAPE_SC'
,p_message_language=>'it'
,p_message_text=>'caratteri speciali di escape'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278316557402868078)
,p_name=>'ESTIMATED_EFFORT_IN_HOURS'
,p_message_language=>'it'
,p_message_text=>'Impegno stimato in ore'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278667133710868300)
,p_name=>'ETAG_QUERY'
,p_message_language=>'it'
,p_message_text=>'Query ETAG'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278667013485868299)
,p_name=>'ETAG_TYPE'
,p_message_language=>'it'
,p_message_text=>'Tipo ETAG'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278291737968868062)
,p_name=>'EVENT'
,p_message_language=>'it'
,p_message_text=>'Evento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278734156249868342)
,p_name=>'EVENT.APEX.APEXAFTERREFRESH'
,p_message_language=>'it'
,p_message_text=>'Dopo l''aggiornamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278734778066868342)
,p_name=>'EVENT.APEX.APEXBEFOREPAGESUBMIT'
,p_message_language=>'it'
,p_message_text=>'Prima della sottomissione pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278734041358868342)
,p_name=>'EVENT.APEX.APEXBEFOREREFRESH'
,p_message_language=>'it'
,p_message_text=>'Prima dell''aggiornamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278738375477868344)
,p_name=>'EVENT.BROWSER'
,p_message_language=>'it'
,p_message_text=>'Eventi del browser'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278105176799867944)
,p_name=>'EVENT.BROWSER.APEXDOUBLETAP'
,p_message_language=>'it'
,p_message_text=>'Doppio tocco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278105388751867944)
,p_name=>'EVENT.BROWSER.APEXPAN'
,p_message_language=>'it'
,p_message_text=>'Panoramica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278105243690867944)
,p_name=>'EVENT.BROWSER.APEXPRESS'
,p_message_language=>'it'
,p_message_text=>'Premi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278105403825867944)
,p_name=>'EVENT.BROWSER.APEXSWIPE'
,p_message_language=>'it'
,p_message_text=>'Fai scorrere il dito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278105039180867944)
,p_name=>'EVENT.BROWSER.APEXTAP'
,p_message_language=>'it'
,p_message_text=>'Tocca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278733548195868341)
,p_name=>'EVENT.BROWSER.CHANGE'
,p_message_language=>'it'
,p_message_text=>'Modifica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278732868877868341)
,p_name=>'EVENT.BROWSER.CLICK'
,p_message_language=>'it'
,p_message_text=>'Clic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278732990038868341)
,p_name=>'EVENT.BROWSER.DBLCLICK'
,p_message_language=>'it'
,p_message_text=>'Doppio clic'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278732394691868341)
,p_name=>'EVENT.BROWSER.FOCUSIN'
,p_message_language=>'it'
,p_message_text=>'Elemento attivo selezionato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278732255419868340)
,p_name=>'EVENT.BROWSER.FOCUSOUT'
,p_message_language=>'it'
,p_message_text=>'Elemento attivo deselezionato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278733795790868341)
,p_name=>'EVENT.BROWSER.KEYDOWN'
,p_message_language=>'it'
,p_message_text=>'Tasto premuto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278733838320868341)
,p_name=>'EVENT.BROWSER.KEYPRESS'
,p_message_language=>'it'
,p_message_text=>'Pressione tasto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278733922797868342)
,p_name=>'EVENT.BROWSER.KEYUP'
,p_message_language=>'it'
,p_message_text=>'Rilascio tasto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278732400821868341)
,p_name=>'EVENT.BROWSER.LOAD'
,p_message_language=>'it'
,p_message_text=>'Caricamento risorsa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278733080905868341)
,p_name=>'EVENT.BROWSER.MOUSEDOWN'
,p_message_language=>'it'
,p_message_text=>'Pressione pulsante del mouse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278733393827868341)
,p_name=>'EVENT.BROWSER.MOUSEENTER'
,p_message_language=>'it'
,p_message_text=>'Entrata mouse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278733437903868341)
,p_name=>'EVENT.BROWSER.MOUSELEAVE'
,p_message_language=>'it'
,p_message_text=>'Uscita mouse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278733219106868341)
,p_name=>'EVENT.BROWSER.MOUSEMOVE'
,p_message_language=>'it'
,p_message_text=>'Spostamento mouse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278733102185868341)
,p_name=>'EVENT.BROWSER.MOUSEUP'
,p_message_language=>'it'
,p_message_text=>'Rilascio pulsante del mouse'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277805750787867755)
,p_name=>'EVENT.BROWSER.ORIENTATIONCHANGE'
,p_message_language=>'it'
,p_message_text=>'Modifica orientamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278743291175868348)
,p_name=>'EVENT.BROWSER.READY'
,p_message_language=>'it'
,p_message_text=>'Caricamento pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278732544782868341)
,p_name=>'EVENT.BROWSER.RESIZE'
,p_message_language=>'it'
,p_message_text=>'Ridimensionamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278732630494868341)
,p_name=>'EVENT.BROWSER.SCROLL'
,p_message_language=>'it'
,p_message_text=>'Scorrimento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277805801976867755)
,p_name=>'EVENT.BROWSER.SCROLLSTART'
,p_message_language=>'it'
,p_message_text=>'Avvio scorrimento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277805929241867756)
,p_name=>'EVENT.BROWSER.SCROLLSTOP'
,p_message_language=>'it'
,p_message_text=>'Arresto scorrimento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278733631150868341)
,p_name=>'EVENT.BROWSER.SELECT'
,p_message_language=>'it'
,p_message_text=>'Selezione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277804949254867755)
,p_name=>'EVENT.BROWSER.SWIPE'
,p_message_language=>'it'
,p_message_text=>'Fai scorrere il dito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277805016075867755)
,p_name=>'EVENT.BROWSER.SWIPELEFT'
,p_message_language=>'it'
,p_message_text=>'Fai scorrere il dito verso sinistra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277805129871867755)
,p_name=>'EVENT.BROWSER.SWIPERIGHT'
,p_message_language=>'it'
,p_message_text=>'Fai scorrere il dito verso destra'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277804757322867755)
,p_name=>'EVENT.BROWSER.TAP'
,p_message_language=>'it'
,p_message_text=>'Tocca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277804835275867755)
,p_name=>'EVENT.BROWSER.TAPHOLD'
,p_message_language=>'it'
,p_message_text=>'Tocca e tieni premuto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278732767261868341)
,p_name=>'EVENT.BROWSER.UNLOAD'
,p_message_language=>'it'
,p_message_text=>'Scaricamento pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277805539829867755)
,p_name=>'EVENT.BROWSER.VCLICK'
,p_message_language=>'it'
,p_message_text=>'Clic virtuale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277805604350867755)
,p_name=>'EVENT.BROWSER.VMOUSECANCEL'
,p_message_language=>'it'
,p_message_text=>'Annullamento tocco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277805280234867755)
,p_name=>'EVENT.BROWSER.VMOUSEDOWN'
,p_message_language=>'it'
,p_message_text=>'Avvia con tocco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277805335804867755)
,p_name=>'EVENT.BROWSER.VMOUSEMOVE'
,p_message_language=>'it'
,p_message_text=>'Sposta con tocco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277805456653867755)
,p_name=>'EVENT.BROWSER.VMOUSEUP'
,p_message_language=>'it'
,p_message_text=>'Fine tocco'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278738574179868344)
,p_name=>'EVENT.COMPONENT'
,p_message_language=>'it'
,p_message_text=>'Eventi di componente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277801537643867753)
,p_name=>'EVENT.CUSTOM'
,p_message_language=>'it'
,p_message_text=>'Evento personalizzato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277801667688867753)
,p_name=>'EVENT.CUSTOM.CUSTOM'
,p_message_language=>'it'
,p_message_text=>'Personalizzato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278738437001868344)
,p_name=>'EVENT.FRAMEWORK'
,p_message_language=>'it'
,p_message_text=>'Eventi del framework'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278362490215868107)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERCLOSEDIALOG'
,p_message_language=>'it'
,p_message_text=>'Finestra di dialogo chiusa'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279128675282868593)
,p_name=>'EVENT.FRAMEWORK.APEXAFTERREFRESH'
,p_message_language=>'it'
,p_message_text=>'Dopo l''aggiornamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279128738460868593)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREPAGESUBMIT'
,p_message_language=>'it'
,p_message_text=>'Prima della sottomissione pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279128595253868593)
,p_name=>'EVENT.FRAMEWORK.APEXBEFOREREFRESH'
,p_message_language=>'it'
,p_message_text=>'Prima dell''aggiornamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278275534163868052)
,p_name=>'EVENTS'
,p_message_language=>'it'
,p_message_text=>'Eventi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278315174606868077)
,p_name=>'EVENT_ID'
,p_message_language=>'it'
,p_message_text=>'Numero milestone'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278358762900868104)
,p_name=>'EXACT_SUBS'
,p_message_language=>'it'
,p_message_text=>'Stringhe di sostituzione esatte'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278499531102868193)
,p_name=>'EXAMPLE_1'
,p_message_language=>'it'
,p_message_text=>'Esempio 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278499621086868194)
,p_name=>'EXAMPLE_2'
,p_message_language=>'it'
,p_message_text=>'Esempio 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279032753139868532)
,p_name=>'EXAMPLE_OF_XML_COLUMN'
,p_message_language=>'it'
,p_message_text=>unistr('Questo \00E8 un esempio dei dati contenuti in una colonna di database XML.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279088173201868567)
,p_name=>'EXAMPLE_URI'
,p_message_language=>'it'
,p_message_text=>'URI esempio'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278436334976868154)
,p_name=>'EXCLUDE'
,p_message_language=>'it'
,p_message_text=>'Escludi'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278410423299868137)
,p_name=>'EXISTING_SCHEMA_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome di schema esistente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278348957976868098)
,p_name=>'EXISTS'
,p_message_language=>'it'
,p_message_text=>'Esiste'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277887537746867807)
,p_name=>'EXISTS_SQL_QUERY'
,p_message_language=>'it'
,p_message_text=>'Query SQL - Esiste'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278721489515868334)
,p_name=>'EXPANDED'
,p_message_language=>'it'
,p_message_text=>'Espanso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279082802011868564)
,p_name=>'EXPAND_ALL'
,p_message_language=>'it'
,p_message_text=>'Espandi tutto'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277958299616867851)
,p_name=>'EXPIRED'
,p_message_language=>'it'
,p_message_text=>'Scaduto'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278278820608868054)
,p_name=>'EXPLAIN PLAN'
,p_message_language=>'it'
,p_message_text=>'Explain plan'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278275802712868052)
,p_name=>'EXPORT'
,p_message_language=>'it'
,p_message_text=>'Esporta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278691805432868315)
,p_name=>'EXPORT REPOSITORY'
,p_message_language=>'it'
,p_message_text=>'Repository dei file di esportazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278363162133868107)
,p_name=>'EXPORTED_FROM_ANOTHER_WORKSPACE'
,p_message_language=>'it'
,p_message_text=>'Esportato da un''altra area di lavoro o applicazione.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278363261203868107)
,p_name=>'EXPORTED_FROM_CURRENT_WORKSPACE'
,p_message_language=>'it'
,p_message_text=>'Esportato da area di lavoro corrente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278442775832868158)
,p_name=>'EXPORT_APPLICATION'
,p_message_language=>'it'
,p_message_text=>'Esporta applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278447350711868161)
,p_name=>'EXPORT_PKG_APP_FOR_DEPLOYMENT'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Utilizzare questi collegamenti per scaricare l''applicazione e i corrispondenti oggetti di supporto del database per la distribuzione in un''altra installazione di Oracle Application Express. I file scaricati sono script SQL che possono essere eseguiti'
||' da SQL*Plus, SQL Developer o SQL Scripts all''interno di Oracle Application Express.',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278442885422868158)
,p_name=>'EXPORT_SUPPORTING_OBJECTS'
,p_message_language=>'it'
,p_message_text=>'Esporta oggetti di supporto'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278276178791868052)
,p_name=>'EXPORT_TYPES.APP_EXPORT'
,p_message_language=>'it'
,p_message_text=>'Esportazione applicazione  '
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278276328773868052)
,p_name=>'EXPORT_TYPES.CSS_EXPORT'
,p_message_language=>'it'
,p_message_text=>'Esportazione CSS (Cascading Style Sheet)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278276506814868052)
,p_name=>'EXPORT_TYPES.FILE_EXPORT'
,p_message_language=>'it'
,p_message_text=>'Esportazione file statico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278276498308868052)
,p_name=>'EXPORT_TYPES.IMAGE_EXPORT'
,p_message_language=>'it'
,p_message_text=>'Esportazione immagine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278276237294868052)
,p_name=>'EXPORT_TYPES.PAGE_EXPORT'
,p_message_language=>'it'
,p_message_text=>'Esportazione pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278276687421868052)
,p_name=>'EXPORT_TYPES.SCRIPT_FILE_EXPORT'
,p_message_language=>'it'
,p_message_text=>'Esportazione file di script'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278272347007868050)
,p_name=>'EXPORT_TYPES.UI_DEFAULTS'
,p_message_language=>'it'
,p_message_text=>'Valori predefiniti interfaccia utente'
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278198374768868003)
,p_name=>'F4000.APPLICATION_COMPUTATION'
,p_message_language=>'it'
,p_message_text=>'Calcolo applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278196176596868002)
,p_name=>'F4000.APPLICATION_ITEM'
,p_message_language=>'it'
,p_message_text=>'Elemento applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278198133571868003)
,p_name=>'F4000.APPLICATION_PROCESS'
,p_message_language=>'it'
,p_message_text=>'Processo applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278023095268867893)
,p_name=>'F4000.APPLICATION_RESERVED'
,p_message_language=>'it'
,p_message_text=>'Gli ID applicazione da 3000 a 8999 sono riservati.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277888881065867808)
,p_name=>'F4000.APP_EXPORT_CURR_WS'
,p_message_language=>'it'
,p_message_text=>unistr('Questa applicazione \00E8 stata esportata dall''area di lavoro corrente.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277888926051867808)
,p_name=>'F4000.APP_EXPORT_NON_CURR_WS'
,p_message_language=>'it'
,p_message_text=>unistr('Questa applicazione \00E8 stata esportata da un''altra area di lavoro.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278198082604868003)
,p_name=>'F4000.BRANCH'
,p_message_language=>'it'
,p_message_text=>'Diramazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278210623011868011)
,p_name=>'F4000.BRANCH_FROM_PAGE'
,p_message_language=>'it'
,p_message_text=>'Dirama da pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278210850903868011)
,p_name=>'F4000.BRANCH_TO_PAGE'
,p_message_language=>'it'
,p_message_text=>'Dirama a pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278197666852868003)
,p_name=>'F4000.BUTTON'
,p_message_language=>'it'
,p_message_text=>'Pulsante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278347809505868097)
,p_name=>'F4000.BUTTON.ITEM'
,p_message_language=>'it'
,p_message_text=>'Elemento pulsante'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277949846655867846)
,p_name=>'F4000.CALENDAR'
,p_message_language=>'it'
,p_message_text=>'Calendario'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278095370800867938)
,p_name=>'F4000.CALENDAR_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna di calendario.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278211270940868011)
,p_name=>'F4000.COLUMN_ATTRIBUTES'
,p_message_language=>'it'
,p_message_text=>'Attributi colonna'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279045655606868540)
,p_name=>'F4000.COLUMN_NAME_RESERVED_WORD'
,p_message_language=>'it'
,p_message_text=>unistr('Il nome identificato della colonna \00E8 una parola riservata Oracle. Scegliere un altro nome.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278225219983868020)
,p_name=>'F4000.DYNAMIC'
,p_message_language=>'it'
,p_message_text=>'Dinamico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277904739111867818)
,p_name=>'F4000.DYNAMIC ACTION'
,p_message_language=>'it'
,p_message_text=>'Azione dinamica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277888725919867808)
,p_name=>'F4000.EXPORT'
,p_message_language=>'it'
,p_message_text=>'Esporta'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278227518706868021)
,p_name=>'F4000.FIX_ME'
,p_message_language=>'it'
,p_message_text=>'Correggi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278224815906868020)
,p_name=>'F4000.FOR_USER'
,p_message_language=>'it'
,p_message_text=>'Per utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278224749450868020)
,p_name=>'F4000.FOR_USER_SESSION'
,p_message_language=>'it'
,p_message_text=>'Per sessione utente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278210999437868011)
,p_name=>'F4000.FROM'
,p_message_language=>'it'
,p_message_text=>'da'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278024163393867893)
,p_name=>'F4000.HEADER_VALIDATION1'
,p_message_language=>'it'
,p_message_text=>'L''intestazione deve contenere le tag <b> &lt;head&gt;</b> e <b>&lt;/head&gt;</b>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278024443201867893)
,p_name=>'F4000.HEADER_VALIDATION2'
,p_message_language=>'it'
,p_message_text=>'La stringa di sostituzione <b>#HEAD#</b> deve trovarsi tra le tag <b> &lt;head&gt;</b> e <b>&lt;/head&gt;</b>.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278289114051868060)
,p_name=>'F4000.INVALID_FILE_TYPE'
,p_message_language=>'it'
,p_message_text=>unistr('Il tipo dl file "%0" non \00E8 valido.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278197345845868002)
,p_name=>'F4000.ITEM_DISPLAY'
,p_message_language=>'it'
,p_message_text=>'Visualizzazione elemento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278197425128868002)
,p_name=>'F4000.ITEM_READ_ONLY'
,p_message_language=>'it'
,p_message_text=>'Elemento di sola lettura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277821502710867765)
,p_name=>'F4000.LEGACY_SQL'
,p_message_language=>'it'
,p_message_text=>'Istruzione SQL precedente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278376967924868116)
,p_name=>'F4000.LINK_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna di collegamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278230067264868023)
,p_name=>'F4000.LIST_INITCAP'
,p_message_language=>'it'
,p_message_text=>'Lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278198779727868003)
,p_name=>'F4000.LIST_ITEM'
,p_message_language=>'it'
,p_message_text=>'Elemento di lista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277821475603867765)
,p_name=>'F4000.LOCAL'
,p_message_language=>'it'
,p_message_text=>'Locale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278199047526868003)
,p_name=>'F4000.LOV_ENTRY'
,p_message_language=>'it'
,p_message_text=>'Voce di lista di valori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278211044122868011)
,p_name=>'F4000.MENU'
,p_message_language=>'it'
,p_message_text=>'Indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278198981984868003)
,p_name=>'F4000.MENU_OPTION'
,p_message_language=>'it'
,p_message_text=>'Voce di indicatore di percorso'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278246334165868033)
,p_name=>'F4000.MUST_SELECT_AT_LEAST_ONE_TO_COPY'
,p_message_language=>'it'
,p_message_text=>'Selezionare almeno un elemento da copiare o sottoscrivere.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278198456865868003)
,p_name=>'F4000.NAVIGATION_BAR_ENTRY'
,p_message_language=>'it'
,p_message_text=>'Elemento della barra di navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278119989936867953)
,p_name=>'F4000.NAVIGATION_BAR_ICON'
,p_message_language=>'it'
,p_message_text=>'Icona&nbsp;barra&nbsp;di navigazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278195831412868001)
,p_name=>'F4000.NO'
,p_message_language=>'it'
,p_message_text=>'No'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278225360885868020)
,p_name=>'F4000.NOT_REFERENCED'
,p_message_language=>'it'
,p_message_text=>'Senza riferimenti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278208393868868009)
,p_name=>'F4000.NO_DATA_FOUND'
,p_message_language=>'it'
,p_message_text=>'Nessun dato trovato.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279118736445868587)
,p_name=>'F4000.P1.APP_DOES_NOT_EXIST'
,p_message_language=>'it'
,p_message_text=>'L''applicazione %0 non esiste nell''area di lavoro corrente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278754790082868355)
,p_name=>'F4000.P1000.UPDATE_CHECK_DISABLED'
,p_message_language=>'it'
,p_message_text=>'Controllo aggiornamenti disabilitato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278239336639868029)
,p_name=>'F4000.P104.PARENT_TAB_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome tabella padre'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277891758117867810)
,p_name=>'F4000.P111.CANCEL_BUTTON_BRANCH'
,p_message_language=>'it'
,p_message_text=>'Diramazione del pulsante Annulla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277891351930867809)
,p_name=>'F4000.P111.CANCEL_BUTTON_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo visualizzato del pulsante Annulla'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277891871282867810)
,p_name=>'F4000.P111.FINISH_BUTTON_BRANCH'
,p_message_language=>'it'
,p_message_text=>'Diramazione del pulsante Fine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277891475219867810)
,p_name=>'F4000.P111.FINISH_BUTTON_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo visualizzato del pulsante Fine'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277891697869867810)
,p_name=>'F4000.P111.NEXT_BUTTON_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo visualizzato del pulsante Successivo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277891550961867810)
,p_name=>'F4000.P111.PREVIOUS_BUTTON_TEXT'
,p_message_language=>'it'
,p_message_text=>'Testo visualizzato del pulsante Precedente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278239458350868029)
,p_name=>'F4000.P112.TREE_PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina struttura'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278239535125868029)
,p_name=>'F4000.P119.GO'
,p_message_language=>'it'
,p_message_text=>'Vai'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278239605030868029)
,p_name=>'F4000.P130.USING_SAME_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Utilizzando gli stessi modelli di un''applicazione esistente.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279121705745868589)
,p_name=>'F4000.P135.COPY'
,p_message_language=>'it'
,p_message_text=>'Copia %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279127388431868592)
,p_name=>'F4000.P149.PUBLISH_AUTHORIZATION'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti schemi di autorizzazione:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279127618938868592)
,p_name=>'F4000.P149.PUBLISH_BREADCRUMB_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti modelli di indicatore di percorso:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279127705783868593)
,p_name=>'F4000.P149.PUBLISH_BUTTON_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti modelli di pulsante:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279127808092868593)
,p_name=>'F4000.P149.PUBLISH_CALENDAR_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti modelli di calendario:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279127286332868592)
,p_name=>'F4000.P149.PUBLISH_FIELD_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti modelli di etichetta:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279127004826868592)
,p_name=>'F4000.P149.PUBLISH_LIST_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti modelli di lista:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279126702393868592)
,p_name=>'F4000.P149.PUBLISH_LOV'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare le seguenti liste di valori:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279127547930868592)
,p_name=>'F4000.P149.PUBLISH_NAVBAR'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti elementi della barra di navigazione:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279126810795868592)
,p_name=>'F4000.P149.PUBLISH_PAGE_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti modelli di pagina:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279127946563868593)
,p_name=>'F4000.P149.PUBLISH_PLUGIN'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti plugin:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279128094859868593)
,p_name=>'F4000.P149.PUBLISH_POPUP_LOV_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti modelli di lista di valori popup:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279126915239868592)
,p_name=>'F4000.P149.PUBLISH_REGION_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti modelli di area:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279127187362868592)
,p_name=>'F4000.P149.PUBLISH_REPORT_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i seguenti modelli di report:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279127413263868592)
,p_name=>'F4000.P149.PUBLISH_SHORTCUT'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare le seguenti scorciatoie:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278411722778868138)
,p_name=>'F4000.P149.PUBLISH_WEB_SRC_MODULE'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 stato richiesto di pubblicare <strong>%0</strong>. Questa operazione andr\00E0 ad aggiornare i moduli di origine Web seguenti:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278247189659868034)
,p_name=>'F4000.P158.COPY_OF'
,p_message_language=>'it'
,p_message_text=>'Copia di %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279121690371868589)
,p_name=>'F4000.P1701.LOOKUP_DEFINITION'
,p_message_language=>'it'
,p_message_text=>'Definizione ricerche'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279118926699868587)
,p_name=>'F4000.P1704.REGION_NAME'
,p_message_language=>'it'
,p_message_text=>'Nome area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278023756933867893)
,p_name=>'F4000.P19.VALIDATION'
,p_message_language=>'it'
,p_message_text=>'Specificare almeno un elemento per creare una convalida NOT NULL.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278778059702868370)
,p_name=>'F4000.P2.UPDATE_EXPORT_SETTINGS'
,p_message_language=>'it'
,p_message_text=>'Aggiorna impostazioni di esportazione predefinite'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278284545837868057)
,p_name=>'F4000.P203.COMMENT='
,p_message_language=>'it'
,p_message_text=>'commento='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278282623382868056)
,p_name=>'F4000.P203.COMP.MSG'
,p_message_language=>'it'
,p_message_text=>'Utilizzato per eseguire il calcolo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279136187458868598)
,p_name=>'F4000.P203.CONCATENATED_FILE'
,p_message_language=>'it'
,p_message_text=>'File concatenato'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278283247290868056)
,p_name=>'F4000.P203.DISPVAL='
,p_message_language=>'it'
,p_message_text=>'valore visualizzato='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279136050331868598)
,p_name=>'F4000.P203.FILE='
,p_message_language=>'it'
,p_message_text=>'file='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278282994103868056)
,p_name=>'F4000.P203.ICONBAR'
,p_message_language=>'it'
,p_message_text=>'Barra delle icone'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278283461137868057)
,p_name=>'F4000.P203.LOV='
,p_message_language=>'it'
,p_message_text=>'Lista di valori='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278283117637868056)
,p_name=>'F4000.P203.LOVDATA'
,p_message_language=>'it'
,p_message_text=>'Dati della lista di valori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278283050302868056)
,p_name=>'F4000.P203.NAME='
,p_message_language=>'it'
,p_message_text=>'nome='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278282500995868056)
,p_name=>'F4000.P203.PAGE.MSG'
,p_message_language=>'it'
,p_message_text=>'Utilizzato per visualizzare la pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278284425468868057)
,p_name=>'F4000.P203.PAGEBRANCH'
,p_message_language=>'it'
,p_message_text=>'Diramazione di pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278283555905868057)
,p_name=>'F4000.P203.PGTEMP'
,p_message_language=>'it'
,p_message_text=>'Modello di pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278282805807868056)
,p_name=>'F4000.P203.PROC.MSG'
,p_message_language=>'it'
,p_message_text=>'Utilizzato per eseguire il processo'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278282712396868056)
,p_name=>'F4000.P203.PROCESSING'
,p_message_language=>'it'
,p_message_text=>'Elaborazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278283302453868057)
,p_name=>'F4000.P203.RETVAL='
,p_message_language=>'it'
,p_message_text=>'valore restituito='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279128296783868593)
,p_name=>'F4000.P2222.REPARENT_LIST_ENTRY'
,p_message_language=>'it'
,p_message_text=>'Assegna voce di lista a livello padre differente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278094979575867938)
,p_name=>'F4000.P254.VALIDATION'
,p_message_language=>'it'
,p_message_text=>'Specificare almeno un''area da creare.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278195560280868001)
,p_name=>'F4000.P277.WORKSPACE_NOT_CREATED_ALREADY_EXISTS'
,p_message_language=>'it'
,p_message_text=>unistr('L''area di lavoro non verr\00E0 creata perch\00E9 esiste gi\00E0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278195696504868001)
,p_name=>'F4000.P277.WORKSPACE_WILL_BE_CREATED'
,p_message_language=>'it'
,p_message_text=>unistr('L''area di lavoro verr\00E0 creata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279131345072868595)
,p_name=>'F4000.P291.VIEW_LOCK'
,p_message_language=>'it'
,p_message_text=>'Blocca vista'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278095077495867938)
,p_name=>'F4000.P295.VALIDATION'
,p_message_language=>'it'
,p_message_text=>'Specificare almeno una pagina da creare.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279131410287868595)
,p_name=>'F4000.P337.PAGE_UNLOCKED'
,p_message_language=>'it'
,p_message_text=>unistr('Questa pagina \00E8 sbloccata.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278716310839868331)
,p_name=>'F4000.P371.POPUP_LOV'
,p_message_language=>'it'
,p_message_text=>'LOV popup'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278240021053868029)
,p_name=>'F4000.P374.POS.1'
,p_message_language=>'it'
,p_message_text=>'Posizione 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278240104758868029)
,p_name=>'F4000.P374.POS.2'
,p_message_language=>'it'
,p_message_text=>'Posizione 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278240287872868029)
,p_name=>'F4000.P374.POS.3'
,p_message_language=>'it'
,p_message_text=>'Posizione 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278240351693868030)
,p_name=>'F4000.P374.POS.4'
,p_message_language=>'it'
,p_message_text=>'Posizione 4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277812148828867759)
,p_name=>'F4000.P374.POS.5'
,p_message_language=>'it'
,p_message_text=>'Pos.5'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278419115289868143)
,p_name=>'F4000.P374.POS.6'
,p_message_language=>'it'
,p_message_text=>'Posizione 6'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278419259290868143)
,p_name=>'F4000.P374.POS.7'
,p_message_language=>'it'
,p_message_text=>'Posizione 7'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278419346062868143)
,p_name=>'F4000.P374.POS.8'
,p_message_language=>'it'
,p_message_text=>'Posizione 8'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278240456497868030)
,p_name=>'F4000.P381_XBUTTON_HELP'
,p_message_language=>'it'
,p_message_text=>'I pulsanti DML e di impaginazione richiedono nomi di pulsanti specifici e riferimenti al testo della Guida.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279121862724868589)
,p_name=>'F4000.P386.CLASS_MATCHES'
,p_message_language=>'it'
,p_message_text=>'%0 (classe corrispondente)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278240578136868030)
,p_name=>'F4000.P4001.AUTH_HOME'
,p_message_language=>'it'
,p_message_text=>'gestisci'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279136479791868598)
,p_name=>'F4000.P4001.ORIGINAL_VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore originale'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278240657638868030)
,p_name=>'F4000.P4001.SUBSTITUTION_STR'
,p_message_language=>'it'
,p_message_text=>'Stringa di sostituzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278240765231868030)
,p_name=>'F4000.P4001.SUBSTITUTION_VALUE'
,p_message_language=>'it'
,p_message_text=>'Valore di sostituzione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278208216752868009)
,p_name=>'F4000.P4017.HELP_REGION_SOURCE'
,p_message_language=>'it'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<font class="instructiontext">In questa area verr\00E0 visualizzata la Guida relativa alla pagina e all''elemento per la pagina corrente se l''area viene richiamata utilizzando la seguente sintassi:<br>'),
'<pre><escape sc>f?p=&AMP;APP_ID.:Page:Session:&APP_PAGE_ID.</pre></font>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278240835923868030)
,p_name=>'F4000.P4039.FORM_ON'
,p_message_language=>'it'
,p_message_text=>'Form su %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278240906998868030)
,p_name=>'F4000.P404.VALUES'
,p_message_language=>'it'
,p_message_text=>'Valori'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277961908324867854)
,p_name=>'F4000.P4045.BRANCH='
,p_message_language=>'it'
,p_message_text=>'Diramazione='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278228401216868022)
,p_name=>'F4000.P4045.BUTTON='
,p_message_language=>'it'
,p_message_text=>'Pulsante='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277830275531867771)
,p_name=>'F4000.P4045.CHART_SERIES='
,p_message_language=>'it'
,p_message_text=>'Serie grafico ='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278228601232868022)
,p_name=>'F4000.P4045.COMPUTATION='
,p_message_language=>'it'
,p_message_text=>'Calcolo='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278228054704868022)
,p_name=>'F4000.P4045.ICON_SUBTEXT='
,p_message_language=>'it'
,p_message_text=>'Testo secondario icona='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278227984050868022)
,p_name=>'F4000.P4045.IMAGE='
,p_message_language=>'it'
,p_message_text=>'Immagine='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278228531923868022)
,p_name=>'F4000.P4045.ITEM='
,p_message_language=>'it'
,p_message_text=>'Elemento='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278228103690868022)
,p_name=>'F4000.P4045.LIST='
,p_message_language=>'it'
,p_message_text=>'Lista='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277962096838867854)
,p_name=>'F4000.P4045.MENU_OPTION='
,p_message_language=>'it'
,p_message_text=>'Voce di indicatore di percorso ='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278228338278868022)
,p_name=>'F4000.P4045.PAGE='
,p_message_language=>'it'
,p_message_text=>'Pagina='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278228741918868022)
,p_name=>'F4000.P4045.PROCESS='
,p_message_language=>'it'
,p_message_text=>'Processo='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277830152657867771)
,p_name=>'F4000.P4045.REGION='
,p_message_language=>'it'
,p_message_text=>'Area ='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278225409766868020)
,p_name=>'F4000.P4045.REQUIRED_BY_EVERY_PAGE'
,p_message_language=>'it'
,p_message_text=>'Richiesto da ogni pagina dell''applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278227677417868021)
,p_name=>'F4000.P4045.REQUIRED_TO_DISPLAY_PAGE'
,p_message_language=>'it'
,p_message_text=>'Pagina'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278227730572868021)
,p_name=>'F4000.P4045.REQUIRED_TO_RUN_APP_COMPUTATION'
,p_message_language=>'it'
,p_message_text=>'Calcolo applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278227811353868022)
,p_name=>'F4000.P4045.REQUIRED_TO_RUN_APP_PROCESS'
,p_message_language=>'it'
,p_message_text=>'Processo applicazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278228965308868022)
,p_name=>'F4000.P4045.TAB_NAME='
,p_message_language=>'it'
,p_message_text=>'Nome scheda='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278229013960868022)
,p_name=>'F4000.P4045.TAB_SET='
,p_message_language=>'it'
,p_message_text=>'Set di schede='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278228224707868022)
,p_name=>'F4000.P4045.TEXT='
,p_message_language=>'it'
,p_message_text=>'Testo='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278228898935868022)
,p_name=>'F4000.P4045.VALIDATION='
,p_message_language=>'it'
,p_message_text=>'Convalida='
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278242668062868031)
,p_name=>'F4000.P420.CSV_EXPORT'
,p_message_language=>'it'
,p_message_text=>'Scarica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278243209973868031)
,p_name=>'F4000.P420.CVS'
,p_message_language=>'it'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278242271256868031)
,p_name=>'F4000.P420.DEFAULT_LOOK1'
,p_message_language=>'it'
,p_message_text=>'Aspetto predefinito 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278242339962868031)
,p_name=>'F4000.P420.DEFAULT_LOOK2'
,p_message_language=>'it'
,p_message_text=>'Aspetto predefinito 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278242443525868031)
,p_name=>'F4000.P420.DEFAULT_LOOK3'
,p_message_language=>'it'
,p_message_text=>'Aspetto predefinito 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278242520984868031)
,p_name=>'F4000.P420.DEFAULT_LOOK4'
,p_message_language=>'it'
,p_message_text=>'Aspetto predefinito 4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278241322583868030)
,p_name=>'F4000.P420.EXTERNAL_PAGINATION'
,p_message_language=>'it'
,p_message_text=>'Utilizza pulsanti di impaginazione creati esternamente'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278242170624868031)
,p_name=>'F4000.P420.HTML_STD'
,p_message_language=>'it'
,p_message_text=>'Aspetto HTML standard'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278242836770868031)
,p_name=>'F4000.P420.LOOK1'
,p_message_language=>'it'
,p_message_text=>'Aspetto 1'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278242931154868031)
,p_name=>'F4000.P420.LOOK2'
,p_message_language=>'it'
,p_message_text=>'Aspetto 2'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278243032453868031)
,p_name=>'F4000.P420.LOOK3'
,p_message_language=>'it'
,p_message_text=>'Aspetto 3'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278243194082868031)
,p_name=>'F4000.P420.LOOK4'
,p_message_language=>'it'
,p_message_text=>'Aspetto 4'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278241828723868030)
,p_name=>'F4000.P420.ROWS_X_TO_Y'
,p_message_language=>'it'
,p_message_text=>'Righe da X a Y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278241534277868030)
,p_name=>'F4000.P420.ROW_RANGE'
,p_message_language=>'it'
,p_message_text=>'Intervalli di righe 1-15 16-30 nella lista di selezione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278242089299868031)
,p_name=>'F4000.P420.SEARCH_ENGINE'
,p_message_language=>'it'
,p_message_text=>'Motore di ricerca'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278241640405868030)
,p_name=>'F4000.P420.SEARCH_ENGINE_123'
,p_message_language=>'it'
,p_message_text=>'Motore di ricerca 1,2,3,4 (impaginazione in base a set)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278241959230868031)
,p_name=>'F4000.P420.SELECT_LIST'
,p_message_language=>'it'
,p_message_text=>'Lista di selezione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278241105454868030)
,p_name=>'F4000.P420.SET_DEFAULTS'
,p_message_language=>'it'
,p_message_text=>'imposta valori predefiniti'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278241231809868030)
,p_name=>'F4000.P420.TURN_OFF_PAGINATION'
,p_message_language=>'it'
,p_message_text=>'disattiva impaginazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278241770527868030)
,p_name=>'F4000.P420.USE_PAGINATION'
,p_message_language=>'it'
,p_message_text=>'Utilizza pulsanti di impaginazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278243324086868031)
,p_name=>'F4000.P420.XML'
,p_message_language=>'it'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278242776153868031)
,p_name=>'F4000.P420.XML_EXPORT'
,p_message_language=>'it'
,p_message_text=>'Esportazione XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278243440692868031)
,p_name=>'F4000.P422.GEN_LINK'
,p_message_language=>'it'
,p_message_text=>'Crea collegamento'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278241451257868030)
,p_name=>'F4000.P429.ROWS_X_TO_Y'
,p_message_language=>'it'
,p_message_text=>'Intervalli di righe da X a Y (con collegamenti Successivo e Precedente)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279166405251868617)
,p_name=>'F4000.P4311.P371.ALWAYS_NULL'
,p_message_language=>'it'
,p_message_text=>'Valore NULL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278373461150868114)
,p_name=>'F4000.P4311.P371.DB_COLUMN'
,p_message_language=>'it'
,p_message_text=>'Colonna DB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278373672439868114)
,p_name=>'F4000.P4311.P371.PLSQL_EXP'
,p_message_language=>'it'
,p_message_text=>'Espressione PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278373774426868114)
,p_name=>'F4000.P4311.P371.PLSQL_FUNC_BODY'
,p_message_language=>'it'
,p_message_text=>'Corpo funzione PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278373552239868114)
,p_name=>'F4000.P4311.P371.SQL_QUERY'
,p_message_language=>'it'
,p_message_text=>'Query SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278373391661868114)
,p_name=>'F4000.P4311.P371.STATIC_TEXT'
,p_message_language=>'it'
,p_message_text=>'testo statico'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278243568232868032)
,p_name=>'F4000.P4314_XBUTTON_HELP'
,p_message_language=>'it'
,p_message_text=>'I pulsanti DML richiedono nomi di pulsanti specifici e riferimenti al testo della Guida.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277900112510867815)
,p_name=>'F4000.P4450.ACTION_CREATE'
,p_message_language=>'it'
,p_message_text=>unistr('Il nuovo plugin verr\00E0 creato nell''applicazione %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277900097393867815)
,p_name=>'F4000.P4450.ACTION_REPLACE'
,p_message_language=>'it'
,p_message_text=>unistr('Il plugin esistente nell''applicazione %0 verr\00E0 sostituito.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278243635235868032)
,p_name=>'F4000.P4651.HTML_W_SHORTCUTS'
,p_message_language=>'it'
,p_message_text=>'HTML con scorciatoie'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278243817115868032)
,p_name=>'F4000.P4651.PLSQL'
,p_message_language=>'it'
,p_message_text=>'PLSQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278229833520868023)
,p_name=>'F4000.P4656.DEFAULT_BUTTON_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di pulsante predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277949778378867846)
,p_name=>'F4000.P4656.DEFAULT_CALENDAR_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di calendario predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279162013423868614)
,p_name=>'F4000.P4656.DEFAULT_CHART_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area grafico predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277949574926867846)
,p_name=>'F4000.P4656.DEFAULT_DIALOG_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di pagina finestra di dialogo predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279162160694868614)
,p_name=>'F4000.P4656.DEFAULT_FORM_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area form predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279162501725868615)
,p_name=>'F4000.P4656.DEFAULT_IRR_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area report interattivo predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278229777651868023)
,p_name=>'F4000.P4656.DEFAULT_LABEL_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di etichetta predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279162261491868615)
,p_name=>'F4000.P4656.DEFAULT_LISTR_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area lista predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278229643671868023)
,p_name=>'F4000.P4656.DEFAULT_LIST_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di lista predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279162749087868615)
,p_name=>'F4000.P4656.DEFAULT_MENUR_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area indicatore di percorso predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278229969591868023)
,p_name=>'F4000.P4656.DEFAULT_MENU_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di indicatore di percorso predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279161807750868614)
,p_name=>'F4000.P4656.DEFAULT_NAV_BAR_LIST_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di lista barra di navigazione predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279161547688868614)
,p_name=>'F4000.P4656.DEFAULT_NAV_LIST_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello lista menu di navigazione predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279161356999868614)
,p_name=>'F4000.P4656.DEFAULT_OPTION_LABEL'
,p_message_language=>'it'
,p_message_text=>'Modello di etichetta facoltativo predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278229378095868023)
,p_name=>'F4000.P4656.DEFAULT_PAGE_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di pagina predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278229460066868023)
,p_name=>'F4000.P4656.DEFAULT_REGION_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279162310200868615)
,p_name=>'F4000.P4656.DEFAULT_REPORTR_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area report predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278229505033868023)
,p_name=>'F4000.P4656.DEFAULT_REPORT_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di report predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279161484949868614)
,p_name=>'F4000.P4656.DEFAULT_REQUIRED_LABEL'
,p_message_language=>'it'
,p_message_text=>'Modello di etichetta obbligatorio predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279161753486868614)
,p_name=>'F4000.P4656.DEFAULT_SIDE_NAV_LIST_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello lista menu di navigazione laterale predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279162416934868615)
,p_name=>'F4000.P4656.DEFAULT_TABFORM_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area form tabulare predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279161662224868614)
,p_name=>'F4000.P4656.DEFAULT_TOP_NAV_LIST_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello lista menu di navigazione superiore predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279162634868868615)
,p_name=>'F4000.P4656.DEFAULT_WIZARD_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di area procedura guidata predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278229265184868022)
,p_name=>'F4000.P4656.ERROR_PAGE_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di pagina di errore predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(279161944744868614)
,p_name=>'F4000.P4656.LOGIN_PAGE_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>'Modello di pagina di login predefinito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278229167376868022)
,p_name=>'F4000.P4656.PRINT_MODE_PAGE_TEMPLATE'
,p_message_language=>'it'
,p_message_text=>unistr('Modello di pagina predefinito (modalit\00E0 di stampa)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278241020668868030)
,p_name=>'F4000.P4703.REPORT_ON'
,p_message_language=>'it'
,p_message_text=>'Report su %0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278237495448868028)
,p_name=>'F4000.P4717.ALERT_INFO'
,p_message_language=>'it'
,p_message_text=>'informazioni sugli avvisi'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278237653151868028)
,p_name=>'F4000.P4717.NEW_REGION'
,p_message_language=>'it'
,p_message_text=>'nuova area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278237301349868028)
,p_name=>'F4000.P4717.REGION_MUST_EXIST'
,p_message_language=>'it'
,p_message_text=>unistr('\00C8 necessario creare almeno un''area prima di poter creare un elemento di pagina.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278237578955868028)
,p_name=>'F4000.P4717.USE_WIZARD'
,p_message_language=>'it'
,p_message_text=>'Utilizzare una procedura guidata per creare una nuova area'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278238906743868029)
,p_name=>'F4000.P4719.ALPHABETIC_SORT'
,p_message_language=>'it'
,p_message_text=>unistr('l''ordinamento sar\00E0 alfabetico')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278239153469868029)
,p_name=>'F4000.P4719.BIND_VAR_LOV'
,p_message_language=>'it'
,p_message_text=>'Esempio 4: lista di valori con bind variable'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278239085578868029)
,p_name=>'F4000.P4719.CREATION_SORT'
,p_message_language=>'it'
,p_message_text=>'in ordine di creazione'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278238614252868028)
,p_name=>'F4000.P4719.D_R_LOV'
,p_message_language=>'it'
,p_message_text=>'Esempio 2: lista di valori con lo stesso valore visualizzato e restituito'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278335927241868090)
,p_name=>'F4000.P4719.INLINE'
,p_message_language=>'it'
,p_message_text=>'Esempio 5: la query contiene una query in linea; assicurarsi che la prima clausola FROM nell''istruzione SQL non faccia parte della query in linea.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278238530880868028)
,p_name=>'F4000.P4719.SQL_QUERY_LOV'
,p_message_language=>'it'
,p_message_text=>'Esempio 1: lista di valori basata su query SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278238817986868029)
,p_name=>'F4000.P4719.STATIC_LOV'
,p_message_language=>'it'
,p_message_text=>'Esempio 3: esempi di lista statica'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(278238763404868029)
,p_name=>'F4000.P4719.USE_ALIAS'
,p_message_language=>'it'
,p_message_text=>'Se si seleziona la stessa colonna per i valori visualizzati e restituiti, utilizzare un alias di colonna.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(277899009289867814)
,p_name=>'F4000.P4719.YN'
,p_message_language=>'it'
,p_message_text=>unistr('mostra S